/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

#define MENUBAR_ITEM_COUNT		3
#define ACTIONS_MENUITEM		0
#define SETTINGS_MENUITEM		1
#define HELP_MENUITEM			2

#define CREATE_MENUITEM			0
#define DELETE_MENUITEM			1
#define EXPAND_MENUITEM			2
#define SHRINK_MENUITEM			3
#define ADD_MENUITEM			4
#define REMOVE_MENUITEM			5
#define MODIFY_MENUITEM			6
#define VIEW_MENUITEM			7
#define CONVERT_MENUITEM		8
#define REPLACE_MENUITEM		9
#define OTHER_MENUITEM			10
#define FSYS_MENUITEM			11
#define SAVE_MENUITEM			12
#define QUIT_MENUITEM			13

typedef int (*menuitem_activate_cb)(void *item);
typedef void (*menuitem_delete_cb)(void *item);
typedef void (*menu_hide_cb)(void *menu);
typedef void (*menu_delete_cb)(void *menu);

/**
 *	struct menu_item - contains info on a menu item
 *	@label: the menu item text string to display
 *	@tip: short description of menuitem for statusbar
 *	@label_len: the length of the label string
 *	@accel: the character used to activate this menu item
 *	@flags: bitmap of various flags like MI_FLAG_SUBMENU and MI_FLAG_SENSITIVE
 *	@startx: column the label starts at (valid only for horizonal menu)
 *	@activate_cb: the function to invoke when menu item selected
 *	@delete_cb: the function to invoke when menu item is being deleted
 *	@user_data: to attach misc info to this menu item
 *
 *	This structure maintains information about a single menu item
 *	which can be used in various menues.
 */
struct menu_item {
 	char *label;
	char *tip;
	int label_len;
	int accel;
	int flags;
	int startx;
	menuitem_activate_cb activate_cb;
	menuitem_delete_cb delete_cb;
	void *user_data;
};

/*
 *	menu_item.flags
 */

#define MI_FLAG_SUBMENU		(1 << 0)
#define MI_FLAG_SENSITIVE	(1 << 1)
#define MI_FLAG_VISIBLE		(1 << 2)

#define MI_IS_SUBMENU(flags)	((flags) & MI_FLAG_SUBMENU)
#define MI_IS_SENSITIVE(flags)	((flags) & MI_FLAG_SENSITIVE)
#define MI_IS_VISIBLE(flags)	((flags) & MI_FLAG_VISIBLE)

/**
 *	struct popup_menu - contains info on a popup menu
 *	@win: the window id for this menu
 *	@items: the linked list of menu items
 *	@focus_item: the currently focused menu item
 *	@parent: the parent menu if this is a submenu or NULL if topmost
 *	@panel: the panel id for this menu
 *	@hide_cb: if not NULL, handler to call when menu is being hidden
 *	@delete_cb: if not NULL, handler to call when menu is being deleted
 *
 *	This structure maintains information about a menu and the
 *	menu items it contains. 
 */
struct popup_menu {
	WINDOW *win;
	GList *items;
	GList *focus_item;
	struct popup_menu *parent;
	PANEL *panel;
	menu_hide_cb hide_cb;
	menu_delete_cb delete_cb;
};

/**
 *	struct horizontal_menu - contains info to support a horizontal menu
 *	@win: the window for this menu
 *	@items: the menu items
 *	@focus_item: the currently focused menu item
 *	@spacing: the number of spaces to place between each item
 *
 *	This structure maintains information about a horizontal menu which
 *	is typically used for things such as an action bar menu or horizontal
 *	button menu bars.
 */
 struct horizontal_menu {
 	WINDOW *win;
	GList *items;
	GList *focus_item;
	int spacing;
 };

char get_accelerator_char(char *label);
char *remove_accel_identifier(char *label);
void draw_menubar(void);
void draw_statusbar(void);
int process_menubar_events(int key);
void print_statusbar_text(char *text);
WINDOW *get_statusbar_win(void);
inline void set_menu_item_activate_cb(struct menu_item *item, menuitem_activate_cb activate_cb);
inline void set_menu_item_delete_cb(struct menu_item *item, menuitem_delete_cb delete_cb);
inline void set_menu_item_sensitivity(struct menu_item *item, int sensitive);
inline void set_menu_item_visibility(struct menu_item *item, int visible);
inline gboolean is_menu_item_sensitive(struct menu_item *item);
inline gboolean is_menu_item_visible(struct menu_item *item);
struct menu_item *append_menu_item(struct popup_menu *menu, char *label, char *tip, int accel,
				int is_submenu, menuitem_activate_cb activate_cb, void *user_data);
struct menu_item *pack_menu_item_at_end(struct horizontal_menu *menu, char *label, int accel,
					menuitem_activate_cb activate_cb, void *user_data);
struct menu_item *pack_menu_item_at_start(struct horizontal_menu *menu, char *label, int accel,
					menuitem_activate_cb activate_cb, void *user_data);
inline void set_horizontal_menu_focus(struct horizontal_menu *menu, struct menu_item *item);
struct horizontal_menu *create_horizontal_menu(WINDOW *parent_win, int width, int starty, 
						int startx, int spacing);
void delete_horizontal_menu(struct horizontal_menu *menu);
void draw_horizontal_menu(struct horizontal_menu *menu);
int process_horizontal_menu_events(struct horizontal_menu *menu, int *key);
int actions_menuitem_activated(struct menu_item *item);
int settings_menuitem_activated(struct menu_item *item);
void popup_context_menu(object_handle_t handle, int starty, int startx);

