Name:      evms
Version:   2.5.3
Release:   1
URL:       http://evms.sourceforge.net
Source:    http://dl.sourceforge.net/evms/%{name}-%{version}.tar.gz
Group:     System Environment/Base
Copyright: GPL
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Summary:   Enterprise Volume Management System (EVMS)
Prereq:    ldconfig

BuildRequires: glib-devel >= 1.2.0, gtk+-devel >= 1.2.0

%description
The Enterprise Volume Management System (EVMS) Project has the goal of 
providing unparalleled flexibility and extensibility in managing storage.
It represents a new approach to logical volume management for Linux. The
architecture introduces a plug-in model that allows for easy expansion
and customization of various levels of volume management.

EVMS provides a single, unified system for handling all of your storage
management tasks. EVMS recognizes all of the disks on your system and 
allows for a variety of partitioning schemes. Software-RAID and logical
volume groups can be managed in EVMS. Filesystems can be created and
checked, and are automatically updated when changes are made to the
underlying volumes. With EVMS, there is no longer a need for several
individual utilities for performing each of these tasks.

%prep
%setup

%build
%configure
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} install
# Produce evms.lang with any available /usr/share/locale/*/evms.mo files.
%find_lang %{name}

%clean
[ "%{buildroot}" != "/" ] && %{__rm} -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

# Start a files block and initially populate it with the evms.mo files found earlier.
%defattr(-, root, root, 0755)
%files -f %{name}.lang
%doc COPYING ChangeLog INSTALL* README PLUGIN.IDS TERMINOLOGY
%doc %{_mandir}/man?/*
%config( noreplace ) %{_sysconfdir}/evms.conf*
%{_includedir}/*
%{_libdir}/*.so*
%{_libdir}/*.a*
%{_libdir}/evms/
%{_sbindir}/*


%changelog
* Fri Jun 10 2005 Kevin Corry <kevcorry@us.ibm.com> = 2.5.3-1
- EVMS 2.5.3
- Bug fixes
  - Engine
    - Marked all deleted volumes as needing deactivation.
    - Use LIST_FOR_EACH_SAFE when walking object lists during commit.
    - Fix a small memory leak when allocating multipath target structures.
  - Replace Plugin
    - Corrected checks during discovery for replace objects.
  - MD Plugin
    - Fix stack corruption bug in MD plugin. [Marcus Meissner]
    - Fix memory corruption bug for RAID-5 regions running in degraded
      mode. [Gleb Stiblo]
    - Remove left over check when comparing DM tables for multipath objects
      that was causing the comparisons to always fail.
  - LVM2 Plugin
    - Fix stack corruption bug in LVM2 plugin. [Thomas Fehr]
    - Fix "packed" structure definition in LVM2 plugin. [sannes]
    - Round up instead of down to nearest PE-size when creating an LVM2 region.
  - Disk and DOS Plugins
    - Correctly handle HP/Compaq disk array names. These disks usually have
      names like "cciss/c0d0" or "ida/c0d0". Their segments will contain a "p"
      before the segment number, to correspond with the commonly-used names.
  - Command-Line UI
    - Improved display formatting for the CLI.
- Minor improvements.
  - When mounting a volume in the GUI or Ncurses, check /etc/fstab for the
    initial suggested mountpoint.
  - Limit the number of open file-descriptors in the disk plugin. This also
    adds a new "max_open_disks" option in the config file.
- Updates to documentation, including updates to the CLI man page and
  help text.

* Mon Feb 28 2005 Kevin Corry <kevcorry@us.ibm.com> - 2.5.2-1
- EVMS 2.5.2
- Bug fixes
  - Engine
    - Properly clean up empty directories in the /dev/evms/ tree.
  - MD Plugin
    - When removing a failed disk, need to ioctl to the MD driver to make
      sure it drops its reference to the disk.
    - When a disk is marked faulty and a spare is automatically activated,
      the faulty disk's number needs to be updated to match the kernel's view.
    - Check for array syncing status when getting region info.
    - Compensate for differences in GET_DISK_INFO ioctl between 2.4
      and 2.6 kernels.
    - Fix number of entries in MD superblock.
    - Use ffs instead of ffz. (Stefan Bader)
    - Fix compile errors with older gcc's.
  - Snapshots
    - Fix a segfault that could occur when rolling-back a snapshot that
      isn't made into an EVMS volume.
  - evms_metadata_restore
    - Fix some macro definitions.
- Init-Ramdisk
  - Changes to linuxrc to be more backwards-compatible with older EVMS
    initrd images.
- Updates to INSTALL guide.

* Fri Jan 21 2005 Kevin Corry <kevcorry@us.ibm.com> - 2.5.1-1
- EVMS 2.5.1
- New features
  - New MD superblock support (>=2.6.10 kernels only).
- Bug fixes
  - Segfault when backing up metadata for a snapshotted volume.
  - Device-Mapper version mismatch with older kernels.
  - Correct "is-mounted" in the case when a volume has been renamed.
  - Infinite loop during discovery when a RAID-1 or RAID-5 is syncing.
  - Relax the PV size-check restrictions for LVM1 containers.
  - Try manually loading a DM target kernel module if it's not found
    when checking for target versions.
  - Update evms_mpathd to work with the new dm-multipath table format.
- Init-Ramdisk
  - Change linuxrc to use the pivot-root method for mounting the root-fs.

* Tue Dec 21 2004 Kevin Corry <kevcorry@us.ibm.com> - 2.5.0-1
- EVMS 2.5.0
- New features
  - Metadata backup and restore.
  - LVM2 move-mappings.
- Minor updates and bug fixes
  - Proper progress-indicator initialization in several plugins.
  - Engine
    - Simplify several informational data structures.
    - Reduce severity of some log messages to make them less misleading.
    - Minor reordering of commit sequence to prevent segfaults in the
      snapshot plugin's delete and deactivation code.
    - Fix to the volume size calculation code.
  - Clustering
    - Overhaul of remoting code to get rid of several memory leaks.
  - LVM2
    - Fix problem with converting some systems from LVM2 to EVMS.
    - Don't allow spaces in container and region names.
  - Snapshot
    - Add a routine for the discard API.
  - S/390 Segment Manager
    - Fix bug with deleting multiple segments.
    - Fix "format" plugin-function.
  - BBR Segment Manager
    - Fix potential seg-fault in deactivation routine.
    - Fix forwarding of kill-sector requests during delete.
  - Disk Plugin
    - More detailed information for IDE disks.
  - Multipath
    - Support the new table string format for the latest dm-multipath kernel
      module, along with the previous format.
- Updated documentation and kernel patches.

* Mon Oct 25 2004 Kevin Corry <kevcorry@us.ibm.com> - 2.4.1-1
- evms 2.4.1
- Bug fixes for the 2.4.0 release.
  - Engine
    - Fixed a potential volume activation problem.
    - Improved debugging log messages.
  - BBR Segment Manager
    - Important metadata update. See README file for details!
    - Fix segfault when creating new BBR segments.
  - Software-RAID
    - Fixes to recovery after a failed RAID-0 or RAID-5 expand.
    - Do proper filtering of spare disks based on cluster-disk-group.
  - LVM2
    - 64-bit-support cleanup
    - Fix a compile error.
  - FSIMs
    - Fix bugs in checking allowed size for shrinking.
    - Fix status checks after a fork/execvp.
  - Clustering Support
    - Make the membership timeout configurable in evms.conf.
  - Disk Manager
    - Fix private-data allocation bug.
  - Object-Replace
    - Fix bug with replacing one full disk with another full disk.
  - Build process
    - Improved version checking when searching for Linux-HA.
- Updated documentation and kernel patches.

* Tue Aug 31 2004 Peter Smith <peters@sourceforge.net> - 2.4.0-1
- evms 2.4.0
- New features
  - Selective activation.
  - RAID-0 and RAID-5 resize.
  - New LVM2 plugin.
  - New NTFS fsim.
  - NLS support.
  - Container PV expand and shrink.
- Updates and bug-fixes
  - Disk manager
    - Recognize multipath-tools devices as disks.
  - Online replace
    - Recover and complete replace operations following an engine or system
      crash during an online replace.
  - LVM1 plugin.
    - Add rename for regions and containers.
  - Swap FSIM
    - Add swapon and swapoff functions.
  - Command Line UI
    - Add mount and unmount commands.
  - Updates for 2.6.8 and 2.4.27 kernels.
  - Updated documentation.
