/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdrivelink.so
 *
 *   File: dl_object.h
 */
#ifndef _DL_OBJECT_HEADER_
#define _DL_OBJECT_HEADER_ 1

					       
int dl_can_set_volume( storage_object_t * object, boolean  flag );
int dl_can_delete( storage_object_t * object);
int dl_can_expand(storage_object_t *object, sector_count_t expand_limit, list_anchor_t expansion_points);
int dl_can_expand_by( storage_object_t *object, sector_count_t *size);
int dl_can_shrink( storage_object_t  *object, sector_count_t shrink_limit,  list_anchor_t shrink_points );
int dl_can_shrink_by( storage_object_t  *object,  sector_count_t *size);
int dl_can_replace_child( storage_object_t  * object, 
			  storage_object_t  * child,
			  storage_object_t  * new_child);
int dl_can_add_feature(storage_object_t * input_object, sector_count_t * size);


int dl_create( list_anchor_t input_objects, option_array_t *options,  list_anchor_t output_objects );
int dl_delete( storage_object_t * parent, list_anchor_t  child_objects );
int dl_discard(list_anchor_t objects);

int dl_expand( storage_object_t * parent, 
	       storage_object_t * expand_object,
	       list_anchor_t      objects,
	       option_array_t   * options );
int dl_shrink( storage_object_t * parent,
               storage_object_t * shrink_object,
               list_anchor_t      objects,
               option_array_t   * options );

int dl_replace_child( storage_object_t * parent,
                      storage_object_t * child,
                      storage_object_t * new_child);

int dl_add_sectors_to_kill_list( storage_object_t * object,
                                 lsn_t              lsn,
                                 sector_count_t     count);

int dl_read(storage_object_t *object, lsn_t lsn, sector_count_t count, void *buffer);
int dl_write(storage_object_t *object, lsn_t lsn, sector_count_t count, void *buffer);

void dl_set_volume( storage_object_t * object, boolean  flag );

int dl_plugin_function( storage_object_t * missing_child,
			task_action_t      action,
			list_anchor_t      objects,
			option_array_t   * options );

int dl_get_plugin_functions( storage_object_t        * object,
			     function_info_array_t * * actions);

#endif

