/*
 *
 *    Copyright 1999-2001 Sistina Software, Inc.
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file AUTHORS for a list of contributors.
 *
 *    This file was maintained by:
 *      David C. Teigland <teigland@sistina.com>
 *
 */
#ifndef _CLUSTER_CONFIG_H
#define _CLUSTER_CONFIG_H

#include "global.h"
#include "ogfs_ondisk.h"
#include "stomith.h"

#define OGFS_CLUSTER_GLOBAL  (0x47465341)
#define OGFS_CLUSTER_NODE    (0x47465342)

#define OGFS_CLUSTER_VERSION (0x47010000)

#define CIDEV_BLOCKSIZE     (4096)

/*  First sector of cidev  */

struct cluster_global {
	uint32	cg_magic;	/* magic number */
	uint32	cg_version;	/* version number */
	char	cg_lockdev[OGFS_LOCKNAME_LEN];	/* lock device */
	char	cg_datadev[OGFS_LOCKNAME_LEN];	/* data device */
	uint32	cg_cbport;	/* call-back port */
	uint32	cg_node_timeout;	/* in seconds */
};
typedef struct cluster_global cluster_global_t;

/*  One struct per sector.  Implicit: JID = block - 1  */

struct cluster_node {
	uint32	cn_magic;	/* Magic number */
	uint32	cn_ipaddr;	/* IP address of node */
	uint32	cn_cid;		/* Client ID of node */
	uint32	cn_num_stomith;	/* Number of stomith structs */
};
typedef struct cluster_node cluster_node_t;

/*  On-disk format translation functions  */

void cluster_global_in(struct cluster_global *cg, char *buf);
void cluster_global_out(struct cluster_global *cg, char *buf);
void cluster_node_in(struct cluster_node *cn, char *buf);
void cluster_node_out(struct cluster_node *cn, char *buf);
void cluster_stomith_in(struct cluster_stomith *cs, char *buf);
void cluster_stomith_out(struct cluster_stomith *cs, char *buf);
int ondisk_stomith_size(uint32 magic);

#endif /* _CLUSTER_CONFIG_H */
