/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.AbsListView;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.By;
import com.jayway.android.robotium.solo.DialogUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Sender;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.Timeout;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.Waiter;
import com.jayway.android.robotium.solo.WebElement;
import com.jayway.android.robotium.solo.WebUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Clicker {
    private final String LOG_TAG = "Robotium";
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Instrumentation inst;
    private final Sender sender;
    private final Sleeper sleeper;
    private final Waiter waiter;
    private final WebUtils webUtils;
    private final DialogUtils dialogUtils;
    private final int MINISLEEP = 100;

    public Clicker(ActivityUtils activityUtils, ViewFetcher viewFetcher, Sender sender, Instrumentation inst, Sleeper sleeper, Waiter waiter, WebUtils webUtils, DialogUtils dialogUtils) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sender = sender;
        this.inst = inst;
        this.sleeper = sleeper;
        this.waiter = waiter;
        this.webUtils = webUtils;
        this.dialogUtils = dialogUtils;
    }

    public void clickOnScreen(float x, float y) {
        boolean successfull = false;
        int retry = 0;
        while (!successfull && retry < 10) {
            long downTime = SystemClock.uptimeMillis();
            long eventTime = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)x, (float)y, (int)0);
            MotionEvent event2 = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)0);
            try {
                this.inst.sendPointerSync(event);
                this.inst.sendPointerSync(event2);
                successfull = true;
                this.sleeper.sleep(100);
            }
            catch (SecurityException e) {
                this.activityUtils.hideSoftKeyboard(null, false, true);
                ++retry;
            }
        }
        if (!successfull) {
            Assert.assertTrue((String)"Click can not be completed!", (boolean)false);
        }
    }

    public void clickLongOnScreen(float x, float y, int time) {
        boolean successfull = false;
        int retry = 0;
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)x, (float)y, (int)0);
        while (!successfull && retry < 10) {
            try {
                this.inst.sendPointerSync(event);
                successfull = true;
            }
            catch (SecurityException e) {
                this.activityUtils.hideSoftKeyboard(null, false, true);
                ++retry;
            }
        }
        if (!successfull) {
            Assert.assertTrue((String)"Click can not be completed!", (boolean)false);
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x + 1.0f), (float)(y + 1.0f), (int)0);
        this.inst.sendPointerSync(event);
        if (time > 0) {
            this.sleeper.sleep(time);
        } else {
            this.sleeper.sleep((int)((float)ViewConfiguration.getLongPressTimeout() * 2.5f));
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)0);
        this.inst.sendPointerSync(event);
        this.sleeper.sleep();
    }

    public void clickOnScreen(View view) {
        this.clickOnScreen(view, false, 0);
    }

    public void clickOnScreen(View view, boolean longClick, int time) {
        if (view == null) {
            Assert.assertTrue((String)"View is null and can therefore not be clicked!", (boolean)false);
        }
        int[] xy = new int[2];
        view.getLocationOnScreen(xy);
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float y = (float)xy[1] + (float)viewHeight / 2.0f;
        if (longClick) {
            this.clickLongOnScreen(x, y, time);
        } else {
            this.clickOnScreen(x, y);
        }
    }

    public void clickLongOnTextAndPress(String text, int index) {
        this.clickOnText(text, true, 0, true, 0);
        this.dialogUtils.waitForDialogToOpen(Timeout.getSmallTimeout());
        try {
            this.inst.sendKeyDownUpSync(20);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not press the context menu!", (boolean)false);
        }
        for (int i = 0; i < index; ++i) {
            this.sleeper.sleepMini();
            this.inst.sendKeyDownUpSync(20);
        }
        this.inst.sendKeyDownUpSync(66);
    }

    public void clickOnMenuItem(String text) {
        this.sleeper.sleep();
        try {
            this.sender.sendKeyCode(82);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not open the menu!", (boolean)false);
        }
        this.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnMenuItem(String text, boolean subMenu) {
        boolean textShown;
        this.sleeper.sleep();
        TextView textMore = null;
        int[] xy = new int[2];
        int x = 0;
        int y = 0;
        try {
            this.sender.sendKeyCode(82);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not open the menu!", (boolean)false);
        }
        boolean bl = textShown = this.waiter.waitForText(text, 1, 1500L, false) != null;
        if (subMenu && this.viewFetcher.getCurrentViews(TextView.class).size() > 5 && !textShown) {
            for (TextView textView : this.viewFetcher.getCurrentViews(TextView.class)) {
                x = xy[0];
                y = xy[1];
                textView.getLocationOnScreen(xy);
                if (xy[0] <= x && xy[1] <= y) continue;
                textMore = textView;
            }
        }
        if (textMore != null) {
            this.clickOnScreen((View)textMore);
        }
        this.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnActionBarItem(int resourceId) {
        this.inst.invokeMenuActionSync(this.activityUtils.getCurrentActivity(), resourceId, 0);
    }

    public void clickOnActionBarHomeButton() {
        Activity activity = this.activityUtils.getCurrentActivity();
        MenuItem homeMenuItem = null;
        try {
            Class<?> cls = Class.forName("com.android.internal.view.menu.ActionMenuItem");
            Class[] partypes = new Class[]{Context.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CharSequence.class};
            Constructor<?> ct = cls.getConstructor(partypes);
            Object[] argList = new Object[]{activity, 0, 16908332, 0, 0, ""};
            homeMenuItem = (MenuItem)ct.newInstance(argList);
        }
        catch (Exception ex) {
            Log.d((String)"Robotium", (String)"Can not find methods to invoke Home button!");
        }
        if (homeMenuItem != null) {
            activity.getWindow().getCallback().onMenuItemSelected(0, homeMenuItem);
        }
    }

    public void clickOnWebElement(By by, int match, boolean scroll) {
        WebElement webElementToClick = this.waiter.waitForWebElement(by, match, Timeout.getSmallTimeout(), scroll);
        if (webElementToClick == null) {
            if (match > 1) {
                Assert.assertTrue((String)(match + " WebElements with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' are not found!"), (boolean)false);
            } else {
                Assert.assertTrue((String)("WebElement with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' is not found!"), (boolean)false);
            }
        }
        this.clickOnScreen(webElementToClick.getLocationX(), webElementToClick.getLocationY());
    }

    public void clickOnText(String regex, boolean longClick, int match, boolean scroll, int time) {
        TextView textToClick = this.waiter.waitForText(regex, match, Timeout.getSmallTimeout(), scroll, true, false);
        if (textToClick != null) {
            this.clickOnScreen((View)textToClick, longClick, time);
        } else if (match > 1) {
            Assert.assertTrue((String)(match + " matches of text string: '" + regex + "' are not found!"), (boolean)false);
        } else {
            ArrayList<TextView> allTextViews = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(TextView.class));
            allTextViews.addAll(this.webUtils.getTextViewsFromWebView());
            for (TextView textView : allTextViews) {
                Log.d((String)"Robotium", (String)("'" + regex + "' not found. Have found: '" + textView.getText() + "'"));
            }
            allTextViews = null;
            Assert.assertTrue((String)("Text string: '" + regex + "' is not found!"), (boolean)false);
        }
    }

    public <T extends TextView> void clickOn(Class<T> viewClass, String nameRegex) {
        T viewToClick = this.waiter.waitForText(viewClass, nameRegex, 0, Timeout.getSmallTimeout(), true, true, false);
        if (viewToClick != null) {
            this.clickOnScreen((View)viewToClick);
        } else {
            ArrayList<TextView> allTextViews = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(viewClass));
            for (TextView view : allTextViews) {
                Log.d((String)"Robotium", (String)("'" + nameRegex + "' not found. Have found: '" + view.getText() + "'"));
            }
            Assert.assertTrue((String)(viewClass.getSimpleName() + " with text: '" + nameRegex + "' is not found!"), (boolean)false);
        }
    }

    public <T extends View> void clickOn(Class<T> viewClass, int index) {
        this.clickOnScreen((View)this.waiter.waitForAndGetView(index, viewClass));
    }

    public ArrayList<TextView> clickInList(int line) {
        return this.clickInList(line, 0, false, 0);
    }

    public ArrayList<TextView> clickInList(int line, int index, boolean longClick, int time) {
        long endTime = SystemClock.uptimeMillis() + (long)Timeout.getSmallTimeout();
        int lineIndex = line - 1;
        if (lineIndex < 0) {
            lineIndex = 0;
        }
        ArrayList<Object> views = new ArrayList();
        AbsListView absListView = this.waiter.waitForAndGetView(index, AbsListView.class);
        if (absListView == null) {
            Assert.assertTrue((String)"ListView is null!", (boolean)false);
        }
        while (lineIndex > absListView.getChildCount()) {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                int numberOfLines = absListView.getChildCount();
                Assert.assertTrue((String)("Can not click on line number " + line + " as there are only " + numberOfLines + " lines available"), (boolean)false);
            }
            this.sleeper.sleep();
        }
        View view = absListView.getChildAt(lineIndex);
        if (view != null) {
            views = this.viewFetcher.getViews(view, true);
            views = RobotiumUtils.removeInvisibleViews(views);
            this.clickOnScreen(view, longClick, time);
        }
        return RobotiumUtils.filterViews(TextView.class, views);
    }
}

