/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.view.View;
import com.jayway.android.robotium.solo.Reflect;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class GLRenderWrapper
implements GLSurfaceView.Renderer {
    private GLSurfaceView.Renderer renderer;
    private int width;
    private int height;
    private final GLSurfaceView view;
    private CountDownLatch latch;
    private boolean takeScreenshot = true;
    private int glVersion;

    public GLRenderWrapper(GLSurfaceView view, GLSurfaceView.Renderer renderer, CountDownLatch latch) {
        this.view = view;
        this.renderer = renderer;
        this.latch = latch;
        this.width = view.getWidth();
        this.height = view.getHeight();
        this.glVersion = new Reflect(view).field("mEGLContextClientVersion").out(Integer.class);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.renderer.onSurfaceCreated(gl, config);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.width = width;
        this.height = height;
        this.renderer.onSurfaceChanged(gl, width, height);
    }

    public void onDrawFrame(GL10 gl) {
        this.renderer.onDrawFrame(gl);
        if (this.takeScreenshot) {
            Bitmap screenshot = null;
            screenshot = this.glVersion == 2 ? this.savePixels(0, 0, this.width, this.height) : GLRenderWrapper.savePixels(0, 0, this.width, this.height, gl);
            new Reflect(this.view).field("mDrawingCache").type(View.class).in(screenshot);
            this.latch.countDown();
            this.takeScreenshot = false;
        }
    }

    public void setTakeScreenshot() {
        this.takeScreenshot = true;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    private Bitmap savePixels(int x, int y, int w, int h) {
        int[] b = new int[w * (y + h)];
        int[] bt = new int[w * h];
        IntBuffer ib = IntBuffer.wrap(b);
        ib.position(0);
        GLES20.glReadPixels((int)x, (int)0, (int)w, (int)(y + h), (int)6408, (int)5121, (Buffer)ib);
        int i = 0;
        int k = 0;
        while (i < h) {
            for (int j = 0; j < w; ++j) {
                int pix1;
                int pix = b[i * w + j];
                int pb = pix >> 16 & 0xFF;
                int pr = pix << 16 & 0xFF0000;
                bt[(h - k - 1) * w + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
            }
            ++i;
            ++k;
        }
        Bitmap sb = Bitmap.createBitmap((int[])bt, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return sb;
    }

    private static Bitmap savePixels(int x, int y, int w, int h, GL10 gl) {
        int[] b = new int[w * (y + h)];
        int[] bt = new int[w * h];
        IntBuffer ib = IntBuffer.wrap(b);
        ib.position(0);
        gl.glReadPixels(x, 0, w, y + h, 6408, 5121, (Buffer)ib);
        int i = 0;
        int k = 0;
        while (i < h) {
            for (int j = 0; j < w; ++j) {
                int pix1;
                int pix = b[i * w + j];
                int pb = pix >> 16 & 0xFF;
                int pr = pix << 16 & 0xFF0000;
                bt[(h - k - 1) * w + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
            }
            ++i;
            ++k;
        }
        Bitmap sb = Bitmap.createBitmap((int[])bt, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return sb;
    }
}

