/* role-details.c generated by valac 0.29.3.10-b87a, the Vala compiler
 * generated from role-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>


#define FOLKS_TYPE_ROLE (folks_role_get_type ())
#define FOLKS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE, FolksRole))
#define FOLKS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ROLE, FolksRoleClass))
#define FOLKS_IS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE))
#define FOLKS_IS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ROLE))
#define FOLKS_ROLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ROLE, FolksRoleClass))

typedef struct _FolksRole FolksRole;
typedef struct _FolksRoleClass FolksRoleClass;
typedef struct _FolksRolePrivate FolksRolePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;

#define FOLKS_TYPE_ROLE_FIELD_DETAILS (folks_role_field_details_get_type ())
#define FOLKS_ROLE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails))
#define FOLKS_ROLE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetailsClass))
#define FOLKS_IS_ROLE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE_FIELD_DETAILS))
#define FOLKS_IS_ROLE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ROLE_FIELD_DETAILS))
#define FOLKS_ROLE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetailsClass))

typedef struct _FolksRoleFieldDetails FolksRoleFieldDetails;
typedef struct _FolksRoleFieldDetailsClass FolksRoleFieldDetailsClass;
typedef struct _FolksRoleFieldDetailsPrivate FolksRoleFieldDetailsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_ROLE_DETAILS (folks_role_details_get_type ())
#define FOLKS_ROLE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetails))
#define FOLKS_IS_ROLE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE_DETAILS))
#define FOLKS_ROLE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetailsIface))

typedef struct _FolksRoleDetails FolksRoleDetails;
typedef struct _FolksRoleDetailsIface FolksRoleDetailsIface;
typedef struct _FolksRoleDetailsChangeRolesData FolksRoleDetailsChangeRolesData;

struct _FolksRole {
	GObject parent_instance;
	FolksRolePrivate * priv;
};

struct _FolksRoleClass {
	GObjectClass parent_class;
};

struct _FolksRolePrivate {
	gchar* _organisation_name;
	gchar* _title;
	gchar* _role;
	gchar* _uid;
};

struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*parameters_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*values_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	const gchar* (*get_id) (FolksAbstractFieldDetails* self);
	void (*set_id) (FolksAbstractFieldDetails* self, const gchar* value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksRoleFieldDetails {
	FolksAbstractFieldDetails parent_instance;
	FolksRoleFieldDetailsPrivate * priv;
};

struct _FolksRoleFieldDetailsClass {
	FolksAbstractFieldDetailsClass parent_class;
};

struct _FolksRoleFieldDetailsPrivate {
	gchar* _id;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksRoleDetailsIface {
	GTypeInterface parent_iface;
	void (*change_roles) (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_roles_finish) (FolksRoleDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_roles) (FolksRoleDetails* self);
	void (*set_roles) (FolksRoleDetails* self, GeeSet* value);
};

struct _FolksRoleDetailsChangeRolesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksRoleDetails* self;
	GeeSet* roles;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};


static gpointer folks_role_parent_class = NULL;
static gpointer folks_role_field_details_parent_class = NULL;

GType folks_role_get_type (void) G_GNUC_CONST;
#define FOLKS_ROLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_ROLE, FolksRolePrivate))
enum  {
	FOLKS_ROLE_DUMMY_PROPERTY,
	FOLKS_ROLE_ORGANISATION_NAME,
	FOLKS_ROLE_TITLE,
	FOLKS_ROLE_ROLE,
	FOLKS_ROLE_UID
};
FolksRole* folks_role_new (const gchar* title, const gchar* organisation_name, const gchar* uid);
FolksRole* folks_role_construct (GType object_type, const gchar* title, const gchar* organisation_name, const gchar* uid);
gboolean folks_role_is_empty (FolksRole* self);
const gchar* folks_role_get_organisation_name (FolksRole* self);
const gchar* folks_role_get_title (FolksRole* self);
const gchar* folks_role_get_role (FolksRole* self);
gboolean folks_role_equal (FolksRole* a, FolksRole* b);
guint folks_role_hash (FolksRole* r);
gchar* folks_role_to_string (FolksRole* self);
void folks_role_set_organisation_name (FolksRole* self, const gchar* value);
void folks_role_set_title (FolksRole* self, const gchar* value);
void folks_role_set_role (FolksRole* self, const gchar* value);
const gchar* folks_role_get_uid (FolksRole* self);
void folks_role_set_uid (FolksRole* self, const gchar* value);
static void folks_role_finalize (GObject* obj);
static void _vala_folks_role_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_role_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_role_field_details_get_type (void) G_GNUC_CONST;
#define FOLKS_ROLE_FIELD_DETAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetailsPrivate))
enum  {
	FOLKS_ROLE_FIELD_DETAILS_DUMMY_PROPERTY,
	FOLKS_ROLE_FIELD_DETAILS_ID
};
FolksRoleFieldDetails* folks_role_field_details_new (FolksRole* value, GeeMultiMap* parameters);
FolksRoleFieldDetails* folks_role_field_details_construct (GType object_type, FolksRole* value, GeeMultiMap* parameters);
static gboolean folks_role_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_parameters_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
static guint folks_role_field_details_real_hash (FolksAbstractFieldDetails* base);
static GObject * folks_role_field_details_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _folks_role_field_details___lambda47_ (FolksRoleFieldDetails* self, GObject* s, GParamSpec* p);
const gchar* folks_abstract_field_details_get_id (FolksAbstractFieldDetails* self);
void folks_abstract_field_details_set_id (FolksAbstractFieldDetails* self, const gchar* value);
static void __folks_role_field_details___lambda47__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void folks_role_field_details_finalize (GObject* obj);
static void _vala_folks_role_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_role_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GQuark folks_property_error_quark (void);
GType folks_role_details_get_type (void) G_GNUC_CONST;
static void folks_role_details_real_change_roles_data_free (gpointer _data);
static void folks_role_details_real_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_role_details_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_role_details_change_roles_finish (FolksRoleDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_role_details_real_change_roles_co (FolksRoleDetailsChangeRolesData* _data_);
GeeSet* folks_role_details_get_roles (FolksRoleDetails* self);
void folks_role_details_set_roles (FolksRoleDetails* self, GeeSet* value);


/**
   * Default constructor.
   *
   * @param title title of the position
   * @param organisation_name organisation where the role is hold
   * @param uid a Unique ID associated to this Role
   * @return a new Role
   *
   * @since 0.4.0
   */
FolksRole* folks_role_construct (GType object_type, const gchar* title, const gchar* organisation_name, const gchar* uid) {
	FolksRole * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = uid;
	_tmp1_ = title;
	_tmp2_ = organisation_name;
	self = (FolksRole*) g_object_new (object_type, "uid", _tmp0_, "title", _tmp1_, "organisation-name", _tmp2_, NULL);
	return self;
}


FolksRole* folks_role_new (const gchar* title, const gchar* organisation_name, const gchar* uid) {
	return folks_role_construct (FOLKS_TYPE_ROLE, title, organisation_name, uid);
}


/**
   * Whether none of the components is set.
   *
   * @return ``true`` if all the components are the empty string, ``false``
   * otherwise.
   *
   * @since 0.6.7
   */
gboolean folks_role_is_empty (FolksRole* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = folks_role_get_organisation_name (self);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = folks_role_get_title (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = g_strcmp0 (_tmp5_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = folks_role_get_role (self);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
   * Compare if two roles are equal. Roles are equal if their titles and
   * organisation names are equal.
   *
   * @param a a role to compare
   * @param b another role to compare
   * @return ``true`` if the roles are equal, ``false`` otherwise
   */
gboolean folks_role_equal (FolksRole* a, FolksRole* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	FolksRole* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	FolksRole* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp2_ = a;
	_tmp3_ = folks_role_get_title (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = b;
	_tmp6_ = folks_role_get_title (_tmp5_);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp4_, _tmp7_) == 0) {
		FolksRole* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		FolksRole* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp8_ = a;
		_tmp9_ = folks_role_get_role (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = b;
		_tmp12_ = folks_role_get_role (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp1_ = g_strcmp0 (_tmp10_, _tmp13_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FolksRole* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		FolksRole* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp14_ = a;
		_tmp15_ = folks_role_get_organisation_name (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = b;
		_tmp18_ = folks_role_get_organisation_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp0_ = g_strcmp0 (_tmp16_, _tmp19_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
   * Hash function for the class. Suitable for use as a hash table key.
   *
   * @param r a role to hash
   * @return hash value for the role instance
   */
guint folks_role_hash (FolksRole* r) {
	guint result = 0U;
	FolksRole* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	FolksRole* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	FolksRole* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	g_return_val_if_fail (r != NULL, 0U);
	_tmp0_ = r;
	_tmp1_ = folks_role_get_organisation_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_hash (_tmp2_);
	_tmp4_ = r;
	_tmp5_ = folks_role_get_title (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_str_hash (_tmp6_);
	_tmp8_ = r;
	_tmp9_ = folks_role_get_role (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_str_hash (_tmp10_);
	result = (_tmp3_ ^ _tmp7_) ^ _tmp11_;
	return result;
}


/**
   * Formatted version of this role.
   *
   * @since 0.4.0
   */
gchar* folks_role_to_string (FolksRole* self) {
	gchar* result = NULL;
	gchar* str = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Title: %s, Organisation: %s, Role: %s");
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = folks_role_get_title (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_role_get_organisation_name (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_role_get_role (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (str, _tmp3_, _tmp5_, _tmp7_);
	result = _tmp8_;
	_g_free0 (str);
	return result;
}


const gchar* folks_role_get_organisation_name (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_organisation_name;
	result = _tmp0_;
	return result;
}


void folks_role_set_organisation_name (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_organisation_name);
	self->priv->_organisation_name = _tmp3_;
	g_object_notify ((GObject *) self, "organisation-name");
}


const gchar* folks_role_get_title (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void folks_role_set_title (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp3_;
	g_object_notify ((GObject *) self, "title");
}


const gchar* folks_role_get_role (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_role;
	result = _tmp0_;
	return result;
}


void folks_role_set_role (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_role);
	self->priv->_role = _tmp3_;
	g_object_notify ((GObject *) self, "role");
}


const gchar* folks_role_get_uid (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}


void folks_role_set_uid (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp3_;
	g_object_notify ((GObject *) self, "uid");
}


static void folks_role_class_init (FolksRoleClass * klass) {
	folks_role_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksRolePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_role_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_role_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_role_finalize;
	/**
	   * The name of the organisation in which the role is held.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_ORGANISATION_NAME, g_param_spec_string ("organisation-name", "organisation-name", "organisation-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The title of the position held.
	   *
	   * For example: “Director, Ministry of Silly Walks”
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The role of the position.
	   *
	   * For example: “Programmer”
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_ROLE, g_param_spec_string ("role", "role", "role", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The UID that distinguishes this role.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_role_instance_init (FolksRole * self) {
	self->priv = FOLKS_ROLE_GET_PRIVATE (self);
}


static void folks_role_finalize (GObject* obj) {
	FolksRole * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ROLE, FolksRole);
	_g_free0 (self->priv->_organisation_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_role);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_role_parent_class)->finalize (obj);
}


/**
 * Role a contact has in an organisation.
 *
 * This represents the role a {@link Persona} or {@link Individual} has in a
 * single given organisation, such as a company.
 *
 * @since 0.4.0
 */
GType folks_role_get_type (void) {
	static volatile gsize folks_role_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksRole), 0, (GInstanceInitFunc) folks_role_instance_init, NULL };
		GType folks_role_type_id;
		folks_role_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksRole", &g_define_type_info, 0);
		g_once_init_leave (&folks_role_type_id__volatile, folks_role_type_id);
	}
	return folks_role_type_id__volatile;
}


static void _vala_folks_role_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksRole * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE, FolksRole);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME:
		g_value_set_string (value, folks_role_get_organisation_name (self));
		break;
		case FOLKS_ROLE_TITLE:
		g_value_set_string (value, folks_role_get_title (self));
		break;
		case FOLKS_ROLE_ROLE:
		g_value_set_string (value, folks_role_get_role (self));
		break;
		case FOLKS_ROLE_UID:
		g_value_set_string (value, folks_role_get_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_role_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksRole * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE, FolksRole);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME:
		folks_role_set_organisation_name (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_TITLE:
		folks_role_set_title (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_ROLE:
		folks_role_set_role (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_UID:
		folks_role_set_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
   * Create a new RoleFieldDetails.
   *
   * @param value the non-empty {@link Role} of the field
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to an
   * empty map of parameters.
   *
   * @return a new RoleFieldDetails
   *
   * @since 0.6.0
   */
FolksRoleFieldDetails* folks_role_field_details_construct (GType object_type, FolksRole* value, GeeMultiMap* parameters) {
	FolksRoleFieldDetails * self = NULL;
	FolksRole* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	FolksRole* _tmp2_ = NULL;
	GeeMultiMap* _tmp3_ = NULL;
	FolksRole* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = value;
	_tmp1_ = folks_role_is_empty (_tmp0_);
	if (_tmp1_) {
		g_warning ("role-details.vala:199: Empty role passed to RoleFieldDetails.");
	}
	_tmp2_ = value;
	_tmp3_ = parameters;
	_tmp4_ = value;
	_tmp5_ = folks_role_get_uid (_tmp4_);
	_tmp6_ = _tmp5_;
	self = (FolksRoleFieldDetails*) g_object_new (object_type, "t_type", FOLKS_TYPE_ROLE, "t_dup_func", (GBoxedCopyFunc) g_object_ref, "t_destroy_func", g_object_unref, "value", _tmp2_, "parameters", _tmp3_, "id", _tmp6_, NULL);
	return self;
}


FolksRoleFieldDetails* folks_role_field_details_new (FolksRole* value, GeeMultiMap* parameters) {
	return folks_role_field_details_construct (FOLKS_TYPE_ROLE_FIELD_DETAILS, value, parameters);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0 
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean folks_role_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksRoleFieldDetails * self;
	gboolean result = FALSE;
	FolksRoleFieldDetails* _that_fd = NULL;
	FolksAbstractFieldDetails* _tmp0_ = NULL;
	FolksRoleFieldDetails* _tmp1_ = NULL;
	FolksRoleFieldDetails* _tmp2_ = NULL;
	FolksRoleFieldDetails* that_fd = NULL;
	FolksRoleFieldDetails* _tmp3_ = NULL;
	FolksRoleFieldDetails* _tmp4_ = NULL;
	FolksAbstractFieldDetails* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gconstpointer _tmp7_ = NULL;
	FolksRole* _tmp8_ = NULL;
	FolksRoleFieldDetails* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
	FolksRole* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	self = (FolksRoleFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_ROLE_FIELD_DETAILS) ? ((FolksRoleFieldDetails*) _tmp0_) : NULL);
	_that_fd = _tmp1_;
	_tmp2_ = _that_fd;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (_that_fd);
		return result;
	}
	_tmp3_ = _that_fd;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails));
	that_fd = _tmp4_;
	_tmp5_ = that;
	_tmp6_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_role_field_details_parent_class)->parameters_equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), _tmp5_);
	if (!_tmp6_) {
		result = FALSE;
		_g_object_unref0 (that_fd);
		_g_object_unref0 (_that_fd);
		return result;
	}
	_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = that_fd;
	_tmp10_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = folks_role_equal ((FolksRole*) _tmp8_, (FolksRole*) _tmp11_);
	result = _tmp12_;
	_g_object_unref0 (that_fd);
	_g_object_unref0 (_that_fd);
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint folks_role_field_details_real_hash (FolksAbstractFieldDetails* base) {
	FolksRoleFieldDetails * self;
	guint result = 0U;
	GHashFunc _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	FolksRole* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	self = (FolksRoleFieldDetails*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_role_to_string ((FolksRole*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


static const gchar* folks_role_field_details_real_get_id (FolksAbstractFieldDetails* base) {
	const gchar* result;
	FolksRoleFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksRoleFieldDetails*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void folks_role_field_details_real_set_id (FolksAbstractFieldDetails* base, const gchar* value) {
	FolksRoleFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	FolksRole* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	self = (FolksRoleFieldDetails*) base;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp3_;
	_tmp4_ = self->priv->_id;
	_tmp5_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = folks_role_get_uid ((FolksRole*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp4_, _tmp8_) != 0) {
		gconstpointer _tmp9_ = NULL;
		FolksRole* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_id;
		folks_role_set_uid ((FolksRole*) _tmp10_, _tmp11_);
	}
	g_object_notify ((GObject *) self, "id");
}


static void _folks_role_field_details___lambda47_ (FolksRoleFieldDetails* self, GObject* s, GParamSpec* p) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	FolksRole* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_role_get_uid ((FolksRole*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp1_, _tmp5_) != 0) {
		gconstpointer _tmp6_ = NULL;
		FolksRole* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp6_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = folks_role_get_uid ((FolksRole*) _tmp7_);
		_tmp9_ = _tmp8_;
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, _tmp9_);
	}
}


static void __folks_role_field_details___lambda47__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_role_field_details___lambda47_ ((FolksRoleFieldDetails*) self, _sender, pspec);
}


static GObject * folks_role_field_details_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksRoleFieldDetails * self;
	gconstpointer _tmp0_ = NULL;
	FolksRole* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_role_field_details_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) ((FolksRole*) _tmp1_), "notify::uid", (GCallback) __folks_role_field_details___lambda47__g_object_notify, self, 0);
	return obj;
}


static void folks_role_field_details_class_init (FolksRoleFieldDetailsClass * klass) {
	folks_role_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksRoleFieldDetailsPrivate));
	((FolksAbstractFieldDetailsClass *) klass)->equal = folks_role_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = folks_role_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = folks_role_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = folks_role_field_details_real_set_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_role_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_role_field_details_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_role_field_details_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_role_field_details_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_FIELD_DETAILS_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_role_field_details_instance_init (FolksRoleFieldDetails * self) {
	self->priv = FOLKS_ROLE_FIELD_DETAILS_GET_PRIVATE (self);
}


static void folks_role_field_details_finalize (GObject* obj) {
	FolksRoleFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_role_field_details_parent_class)->finalize (obj);
}


/**
 * Object representing details of a contact in an organisation which can have
 * some parameters associated with it.
 *
 * See {@link Folks.AbstractFieldDetails}.
 *
 * @since 0.6.0
 */
GType folks_role_field_details_get_type (void) {
	static volatile gsize folks_role_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksRoleFieldDetails), 0, (GInstanceInitFunc) folks_role_field_details_instance_init, NULL };
		GType folks_role_field_details_type_id;
		folks_role_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksRoleFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_role_field_details_type_id__volatile, folks_role_field_details_type_id);
	}
	return folks_role_field_details_type_id__volatile;
}


static void _vala_folks_role_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksRoleFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	switch (property_id) {
		case FOLKS_ROLE_FIELD_DETAILS_ID:
		g_value_set_string (value, folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_role_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksRoleFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	switch (property_id) {
		case FOLKS_ROLE_FIELD_DETAILS_ID:
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_role_details_real_change_roles_data_free (gpointer _data) {
	FolksRoleDetailsChangeRolesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->roles);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksRoleDetailsChangeRolesData, _data_);
}


static void folks_role_details_real_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksRoleDetailsChangeRolesData* _data_;
	FolksRoleDetails* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksRoleDetailsChangeRolesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_role_details_real_change_roles);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_role_details_real_change_roles_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = roles;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->roles);
	_data_->roles = _tmp2_;
	folks_role_details_real_change_roles_co (_data_);
}


static void folks_role_details_real_change_roles_finish (FolksRoleDetails* self, GAsyncResult* _res_, GError** error) {
	FolksRoleDetailsChangeRolesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's roles.
   *
   * It's preferred to call this rather than setting {@link RoleDetails.roles}
   * directly, as this method gives error notification and will only return once
   * the roles have been written to the relevant backing store (or the
   * operation's failed).
   *
   * @param roles the set of roles
   * @throws PropertyError if setting the roles failed
   * @since 0.6.2
   */
static gboolean folks_role_details_real_change_roles_co (FolksRoleDetailsChangeRolesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Roles are not writeable on this contact.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_role_details_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->change_roles (self, roles, _callback_, _user_data_);
}


void folks_role_details_change_roles_finish (FolksRoleDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->change_roles_finish (self, _res_, error);
}


GeeSet* folks_role_details_get_roles (FolksRoleDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->get_roles (self);
}


void folks_role_details_set_roles (FolksRoleDetails* self, GeeSet* value) {
	g_return_if_fail (self != NULL);
	FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->set_roles (self, value);
}


static void folks_role_details_base_init (FolksRoleDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The roles of the contact.
		   *
		   * @since 0.6.0
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("roles", "roles", "roles", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_roles = folks_role_details_real_change_roles;
		iface->change_roles_finish = folks_role_details_real_change_roles_finish;
	}
}


/**
 * This interfaces represents the list of roles a {@link Persona} and
 * {@link Individual} might have.
 *
 * @since 0.4.0
 */
GType folks_role_details_get_type (void) {
	static volatile gsize folks_role_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleDetailsIface), (GBaseInitFunc) folks_role_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_role_details_type_id;
		folks_role_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksRoleDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_role_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_role_details_type_id__volatile, folks_role_details_type_id);
	}
	return folks_role_details_type_id__volatile;
}



