/* postal-address-details.c generated by valac 0.14.0.15-f8b5, the Vala compiler
 * generated from postal-address-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>


#define FOLKS_TYPE_POSTAL_ADDRESS (folks_postal_address_get_type ())
#define FOLKS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress))
#define FOLKS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))
#define FOLKS_IS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_IS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_POSTAL_ADDRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))

typedef struct _FolksPostalAddress FolksPostalAddress;
typedef struct _FolksPostalAddressClass FolksPostalAddressClass;
typedef struct _FolksPostalAddressPrivate FolksPostalAddressPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;

#define FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS (folks_postal_address_field_details_get_type ())
#define FOLKS_POSTAL_ADDRESS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails))
#define FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetailsClass))
#define FOLKS_IS_POSTAL_ADDRESS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS))
#define FOLKS_IS_POSTAL_ADDRESS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS))
#define FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetailsClass))

typedef struct _FolksPostalAddressFieldDetails FolksPostalAddressFieldDetails;
typedef struct _FolksPostalAddressFieldDetailsClass FolksPostalAddressFieldDetailsClass;
typedef struct _FolksPostalAddressFieldDetailsPrivate FolksPostalAddressFieldDetailsPrivate;

#define FOLKS_TYPE_POSTAL_ADDRESS_DETAILS (folks_postal_address_details_get_type ())
#define FOLKS_POSTAL_ADDRESS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails))
#define FOLKS_IS_POSTAL_ADDRESS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS))
#define FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetailsIface))

typedef struct _FolksPostalAddressDetails FolksPostalAddressDetails;
typedef struct _FolksPostalAddressDetailsIface FolksPostalAddressDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksPostalAddressDetailsChangePostalAddressesData FolksPostalAddressDetailsChangePostalAddressesData;

struct _FolksPostalAddress {
	GObject parent_instance;
	FolksPostalAddressPrivate * priv;
};

struct _FolksPostalAddressClass {
	GObjectClass parent_class;
};

struct _FolksPostalAddressPrivate {
	gchar* _po_box;
	gchar* _extension;
	gchar* _street;
	gchar* _locality;
	gchar* _region;
	gchar* _postal_code;
	gchar* _country;
	gchar* _address_format;
	gchar* _uid;
};

struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksPostalAddressFieldDetails {
	FolksAbstractFieldDetails parent_instance;
	FolksPostalAddressFieldDetailsPrivate * priv;
};

struct _FolksPostalAddressFieldDetailsClass {
	FolksAbstractFieldDetailsClass parent_class;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksPostalAddressDetailsIface {
	GTypeInterface parent_iface;
	void (*change_postal_addresses) (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_postal_addresses_finish) (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_postal_addresses) (FolksPostalAddressDetails* self);
	void (*set_postal_addresses) (FolksPostalAddressDetails* self, GeeSet* value);
};

struct _FolksPostalAddressDetailsChangePostalAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksPostalAddressDetails* self;
	GeeSet* postal_addresses;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};


static gpointer folks_postal_address_parent_class = NULL;
static gpointer folks_postal_address_field_details_parent_class = NULL;

GType folks_postal_address_get_type (void) G_GNUC_CONST;
#define FOLKS_POSTAL_ADDRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressPrivate))
enum  {
	FOLKS_POSTAL_ADDRESS_DUMMY_PROPERTY,
	FOLKS_POSTAL_ADDRESS_PO_BOX,
	FOLKS_POSTAL_ADDRESS_EXTENSION,
	FOLKS_POSTAL_ADDRESS_STREET,
	FOLKS_POSTAL_ADDRESS_LOCALITY,
	FOLKS_POSTAL_ADDRESS_REGION,
	FOLKS_POSTAL_ADDRESS_POSTAL_CODE,
	FOLKS_POSTAL_ADDRESS_COUNTRY,
	FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT,
	FOLKS_POSTAL_ADDRESS_UID
};
FolksPostalAddress* folks_postal_address_new (const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid);
FolksPostalAddress* folks_postal_address_construct (GType object_type, const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid);
gboolean folks_postal_address_equal (FolksPostalAddress* self, FolksPostalAddress* with);
const gchar* folks_postal_address_get_po_box (FolksPostalAddress* self);
const gchar* folks_postal_address_get_extension (FolksPostalAddress* self);
const gchar* folks_postal_address_get_street (FolksPostalAddress* self);
const gchar* folks_postal_address_get_locality (FolksPostalAddress* self);
const gchar* folks_postal_address_get_region (FolksPostalAddress* self);
const gchar* folks_postal_address_get_postal_code (FolksPostalAddress* self);
const gchar* folks_postal_address_get_country (FolksPostalAddress* self);
const gchar* folks_postal_address_get_address_format (FolksPostalAddress* self);
const gchar* folks_postal_address_get_uid (FolksPostalAddress* self);
gchar* folks_postal_address_to_string (FolksPostalAddress* self);
void folks_postal_address_set_po_box (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_extension (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_street (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_locality (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_region (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_postal_code (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_country (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_address_format (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_uid (FolksPostalAddress* self, const gchar* value);
static void folks_postal_address_finalize (GObject* obj);
static void _vala_folks_postal_address_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_postal_address_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_postal_address_field_details_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_DUMMY_PROPERTY
};
FolksPostalAddressFieldDetails* folks_postal_address_field_details_new (FolksPostalAddress* value, GeeMultiMap* parameters);
FolksPostalAddressFieldDetails* folks_postal_address_field_details_construct (GType object_type, FolksPostalAddress* value, GeeMultiMap* parameters);
FolksAbstractFieldDetails* folks_abstract_field_details_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
void folks_abstract_field_details_set_value (FolksAbstractFieldDetails* self, gconstpointer value);
void folks_abstract_field_details_set_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* value);
static gboolean folks_postal_address_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
static guint folks_postal_address_field_details_real_hash (FolksAbstractFieldDetails* base);
GQuark folks_property_error_quark (void);
GType folks_postal_address_details_get_type (void) G_GNUC_CONST;
static void folks_postal_address_details_real_change_postal_addresses_data_free (gpointer _data);
static void folks_postal_address_details_real_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_postal_address_details_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_postal_address_details_change_postal_addresses_finish (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_postal_address_details_real_change_postal_addresses_co (FolksPostalAddressDetailsChangePostalAddressesData* _data_);
GeeSet* folks_postal_address_details_get_postal_addresses (FolksPostalAddressDetails* self);
void folks_postal_address_details_set_postal_addresses (FolksPostalAddressDetails* self, GeeSet* value);


/**
   * Create a PostalAddress.
   *
   * You can pass `null` if a component is not set.
   *
   * @param po_box the PO Box
   * @param extension the address extension
   * @param street the street name and number
   * @param locality the locality (city, town or village) name
   * @param region the region (state or province) name
   * @param postal_code the postal code
   * @param country the country name
   * @param address_format the address format
   * @param types set of types for the address (such as "personal" or "work")
   * @param uid external UID for the address instance
   * @since 0.5.1
   */
FolksPostalAddress* folks_postal_address_construct (GType object_type, const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid) {
	FolksPostalAddress * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	_tmp0_ = po_box;
	_tmp1_ = extension;
	_tmp2_ = street;
	_tmp3_ = locality;
	_tmp4_ = region;
	_tmp5_ = postal_code;
	_tmp6_ = country;
	_tmp7_ = address_format;
	_tmp8_ = uid;
	self = (FolksPostalAddress*) g_object_new (object_type, "po-box", _tmp0_, "extension", _tmp1_, "street", _tmp2_, "locality", _tmp3_, "region", _tmp4_, "postal-code", _tmp5_, "country", _tmp6_, "address-format", _tmp7_, "uid", _tmp8_, NULL);
	return self;
}


FolksPostalAddress* folks_postal_address_new (const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid) {
	return folks_postal_address_construct (FOLKS_TYPE_POSTAL_ADDRESS, po_box, extension, street, locality, region, postal_code, country, address_format, uid);
}


/**
   * Compare if two postal addresses are equal. Addresses are equal if all their
   * components are equal (where `null` compares equal only with `null`) and
   * they have the same set of types (or both have no types).
   *
   * @param with another postal address to compare with
   * @return `true` if the addresses are equal, `false` otherwise
   */
gboolean folks_postal_address_equal (FolksPostalAddress* self, FolksPostalAddress* with) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FolksPostalAddress* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp18_;
	gboolean _tmp24_;
	gboolean _tmp30_;
	gboolean _tmp36_;
	gboolean _tmp42_;
	gboolean _tmp48_;
	gboolean _tmp54_;
	gboolean _tmp60_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (with != NULL, FALSE);
	_tmp8_ = folks_postal_address_get_po_box (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = with;
	_tmp11_ = folks_postal_address_get_po_box (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp9_, _tmp12_) != 0) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		FolksPostalAddress* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp13_ = folks_postal_address_get_extension (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = with;
		_tmp16_ = folks_postal_address_get_extension (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp7_ = g_strcmp0 (_tmp14_, _tmp17_) != 0;
	}
	_tmp18_ = _tmp7_;
	if (_tmp18_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		FolksPostalAddress* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp19_ = folks_postal_address_get_street (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = with;
		_tmp22_ = folks_postal_address_get_street (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp6_ = g_strcmp0 (_tmp20_, _tmp23_) != 0;
	}
	_tmp24_ = _tmp6_;
	if (_tmp24_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		FolksPostalAddress* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp25_ = folks_postal_address_get_locality (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = with;
		_tmp28_ = folks_postal_address_get_locality (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp5_ = g_strcmp0 (_tmp26_, _tmp29_) != 0;
	}
	_tmp30_ = _tmp5_;
	if (_tmp30_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		FolksPostalAddress* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp31_ = folks_postal_address_get_region (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = with;
		_tmp34_ = folks_postal_address_get_region (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp4_ = g_strcmp0 (_tmp32_, _tmp35_) != 0;
	}
	_tmp36_ = _tmp4_;
	if (_tmp36_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		FolksPostalAddress* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp37_ = folks_postal_address_get_postal_code (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = with;
		_tmp40_ = folks_postal_address_get_postal_code (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp3_ = g_strcmp0 (_tmp38_, _tmp41_) != 0;
	}
	_tmp42_ = _tmp3_;
	if (_tmp42_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		FolksPostalAddress* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		_tmp43_ = folks_postal_address_get_country (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = with;
		_tmp46_ = folks_postal_address_get_country (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp2_ = g_strcmp0 (_tmp44_, _tmp47_) != 0;
	}
	_tmp48_ = _tmp2_;
	if (_tmp48_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		FolksPostalAddress* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		_tmp49_ = folks_postal_address_get_address_format (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = with;
		_tmp52_ = folks_postal_address_get_address_format (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp1_ = g_strcmp0 (_tmp50_, _tmp53_) != 0;
	}
	_tmp54_ = _tmp1_;
	if (_tmp54_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		FolksPostalAddress* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		_tmp55_ = folks_postal_address_get_uid (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = with;
		_tmp58_ = folks_postal_address_get_uid (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp0_ = g_strcmp0 (_tmp56_, _tmp59_) != 0;
	}
	_tmp60_ = _tmp0_;
	if (_tmp60_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


/**
   * Get a formatted version of the address. The format is localised, and by
   * default is comma-separated.
   *
   * @return a formatted address.
   *
   * @since 0.4.0
   */
gchar* folks_postal_address_to_string (FolksPostalAddress* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* str;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("%s, %s, %s, %s, %s, %s, %s");
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = folks_postal_address_get_po_box (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_postal_address_get_extension (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_postal_address_get_street (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = folks_postal_address_get_locality (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = folks_postal_address_get_region (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = folks_postal_address_get_postal_code (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = folks_postal_address_get_country (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf (str, _tmp3_, _tmp5_, _tmp7_, _tmp9_, _tmp11_, _tmp13_, _tmp15_);
	result = _tmp16_;
	_g_free0 (str);
	return result;
}


const gchar* folks_postal_address_get_po_box (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_po_box;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_po_box (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_po_box);
	self->priv->_po_box = _tmp4_;
	g_object_notify ((GObject *) self, "po-box");
}


const gchar* folks_postal_address_get_extension (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_extension (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp4_;
	g_object_notify ((GObject *) self, "extension");
}


const gchar* folks_postal_address_get_street (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_street;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_street (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_street);
	self->priv->_street = _tmp4_;
	g_object_notify ((GObject *) self, "street");
}


const gchar* folks_postal_address_get_locality (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locality;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_locality (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_locality);
	self->priv->_locality = _tmp4_;
	g_object_notify ((GObject *) self, "locality");
}


const gchar* folks_postal_address_get_region (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_region;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_region (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_region);
	self->priv->_region = _tmp4_;
	g_object_notify ((GObject *) self, "region");
}


const gchar* folks_postal_address_get_postal_code (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_postal_code;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_postal_code (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_postal_code);
	self->priv->_postal_code = _tmp4_;
	g_object_notify ((GObject *) self, "postal-code");
}


const gchar* folks_postal_address_get_country (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_country;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_country (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_country);
	self->priv->_country = _tmp4_;
	g_object_notify ((GObject *) self, "country");
}


const gchar* folks_postal_address_get_address_format (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address_format;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_address_format (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_address_format);
	self->priv->_address_format = _tmp4_;
	g_object_notify ((GObject *) self, "address-format");
}


const gchar* folks_postal_address_get_uid (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_uid (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp4_;
	g_object_notify ((GObject *) self, "uid");
}


static void folks_postal_address_class_init (FolksPostalAddressClass * klass) {
	folks_postal_address_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPostalAddressPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_postal_address_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_postal_address_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_postal_address_finalize;
	/**
	   * The PO Box.
	   *
	   * The PO Box (also known as Postal office box or Postal box).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_PO_BOX, g_param_spec_string ("po-box", "po-box", "po-box", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address extension.
	   *
	   * Any additional part of the address, for instance a flat number.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The street name and number.
	   *
	   * The street name including the optional building number.
	   * The number can be before or after the street name based on the
	   * language and country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_STREET, g_param_spec_string ("street", "street", "street", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The locality.
	   *
	   * The locality, for instance the city name.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_LOCALITY, g_param_spec_string ("locality", "locality", "locality", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The region.
	   *
	   * The region, for instance the name of the state or province.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_REGION, g_param_spec_string ("region", "region", "region", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The postal code.
	   *
	   * The postal code (also known as post code, postcode or ZIP code).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_POSTAL_CODE, g_param_spec_string ("postal-code", "postal-code", "postal-code", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The country.
	   *
	   * The name of the country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_COUNTRY, g_param_spec_string ("country", "country", "country", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address format.
	   *
	   * The two letter country code that determines the format or exact
	   * meaning of the other fields.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT, g_param_spec_string ("address-format", "address-format", "address-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The UID of the Postal Address (if any).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void folks_postal_address_instance_init (FolksPostalAddress * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self->priv = FOLKS_POSTAL_ADDRESS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_po_box = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_extension = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_street = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_locality = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_region = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->_postal_code = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_country = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->_address_format = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->priv->_uid = _tmp8_;
}


static void folks_postal_address_finalize (GObject* obj) {
	FolksPostalAddress * self;
	self = FOLKS_POSTAL_ADDRESS (obj);
	_g_free0 (self->priv->_po_box);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_street);
	_g_free0 (self->priv->_locality);
	_g_free0 (self->priv->_region);
	_g_free0 (self->priv->_postal_code);
	_g_free0 (self->priv->_country);
	_g_free0 (self->priv->_address_format);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_postal_address_parent_class)->finalize (obj);
}


/**
 * Object representing a postal mail address.
 * The components of the address are never null, an empty string
 * indicates that a property is not set.
 */
GType folks_postal_address_get_type (void) {
	static volatile gsize folks_postal_address_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPostalAddress), 0, (GInstanceInitFunc) folks_postal_address_instance_init, NULL };
		GType folks_postal_address_type_id;
		folks_postal_address_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPostalAddress", &g_define_type_info, 0);
		g_once_init_leave (&folks_postal_address_type_id__volatile, folks_postal_address_type_id);
	}
	return folks_postal_address_type_id__volatile;
}


static void _vala_folks_postal_address_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPostalAddress * self;
	self = FOLKS_POSTAL_ADDRESS (object);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX:
		g_value_set_string (value, folks_postal_address_get_po_box (self));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION:
		g_value_set_string (value, folks_postal_address_get_extension (self));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET:
		g_value_set_string (value, folks_postal_address_get_street (self));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY:
		g_value_set_string (value, folks_postal_address_get_locality (self));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION:
		g_value_set_string (value, folks_postal_address_get_region (self));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE:
		g_value_set_string (value, folks_postal_address_get_postal_code (self));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY:
		g_value_set_string (value, folks_postal_address_get_country (self));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT:
		g_value_set_string (value, folks_postal_address_get_address_format (self));
		break;
		case FOLKS_POSTAL_ADDRESS_UID:
		g_value_set_string (value, folks_postal_address_get_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_postal_address_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPostalAddress * self;
	self = FOLKS_POSTAL_ADDRESS (object);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX:
		folks_postal_address_set_po_box (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION:
		folks_postal_address_set_extension (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET:
		folks_postal_address_set_street (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY:
		folks_postal_address_set_locality (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION:
		folks_postal_address_set_region (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE:
		folks_postal_address_set_postal_code (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY:
		folks_postal_address_set_country (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT:
		folks_postal_address_set_address_format (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_UID:
		folks_postal_address_set_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
   * Create a new PostalAddressFieldDetails.
   *
   * @param value the value of the field
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A `null` value is equivalent to an
   * empty map of parameters.
   *
   *
   * @return a new PostalAddressFieldDetails
   *
   * @since 0.6.0
   */
FolksPostalAddressFieldDetails* folks_postal_address_field_details_construct (GType object_type, FolksPostalAddress* value, GeeMultiMap* parameters) {
	FolksPostalAddressFieldDetails * self = NULL;
	FolksPostalAddress* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksPostalAddressFieldDetails*) folks_abstract_field_details_construct (object_type, FOLKS_TYPE_POSTAL_ADDRESS, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	_tmp0_ = value;
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) self, _tmp0_);
	_tmp1_ = parameters;
	if (_tmp1_ != NULL) {
		GeeMultiMap* _tmp2_;
		_tmp2_ = parameters;
		folks_abstract_field_details_set_parameters ((FolksAbstractFieldDetails*) self, _tmp2_);
	}
	return self;
}


FolksPostalAddressFieldDetails* folks_postal_address_field_details_new (FolksPostalAddress* value, GeeMultiMap* parameters) {
	return folks_postal_address_field_details_construct (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, value, parameters);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean folks_postal_address_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksPostalAddressFieldDetails * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	FolksPostalAddress* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	FolksAbstractFieldDetails* _tmp4_;
	gconstpointer _tmp5_;
	FolksPostalAddress* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_;
	self = (FolksPostalAddressFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = that;
	_tmp5_ = folks_abstract_field_details_get_value (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp3_, _tmp8_) == 0;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp3_);
	result = _tmp9_;
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint folks_postal_address_field_details_real_hash (FolksAbstractFieldDetails* base) {
	FolksPostalAddressFieldDetails * self;
	guint result = 0U;
	GHashFunc _tmp0_;
	gconstpointer _tmp1_;
	FolksPostalAddress* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_;
	self = (FolksPostalAddressFieldDetails*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


static void folks_postal_address_field_details_class_init (FolksPostalAddressFieldDetailsClass * klass) {
	folks_postal_address_field_details_parent_class = g_type_class_peek_parent (klass);
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->equal = folks_postal_address_field_details_real_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->hash = folks_postal_address_field_details_real_hash;
}


static void folks_postal_address_field_details_instance_init (FolksPostalAddressFieldDetails * self) {
}


/**
 * Object representing a PostalAddress value that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
GType folks_postal_address_field_details_get_type (void) {
	static volatile gsize folks_postal_address_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPostalAddressFieldDetails), 0, (GInstanceInitFunc) folks_postal_address_field_details_instance_init, NULL };
		GType folks_postal_address_field_details_type_id;
		folks_postal_address_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksPostalAddressFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_postal_address_field_details_type_id__volatile, folks_postal_address_field_details_type_id);
	}
	return folks_postal_address_field_details_type_id__volatile;
}


static void folks_postal_address_details_real_change_postal_addresses_data_free (gpointer _data) {
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->postal_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksPostalAddressDetailsChangePostalAddressesData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_postal_address_details_real_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	FolksPostalAddressDetails* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	_data_ = g_slice_new0 (FolksPostalAddressDetailsChangePostalAddressesData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_postal_address_details_real_change_postal_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_postal_address_details_real_change_postal_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = postal_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->postal_addresses = _tmp2_;
	folks_postal_address_details_real_change_postal_addresses_co (_data_);
}


static void folks_postal_address_details_real_change_postal_addresses_finish (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error) {
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's postal addresses.
   *
   * It's preferred to call this rather than setting
   * {@link PostalAddressDetails.postal_addresses} directly, as this method
   * gives error notification and will only return once the addresses have been
   * written to the relevant backing store (or the operation's failed).
   *
   * @param postal_addresses the set of postal addresses
   * @throws PropertyError if setting the addresses failed
   * @since 0.6.2
   */
static gboolean folks_postal_address_details_real_change_postal_addresses_co (FolksPostalAddressDetailsChangePostalAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Postal addresses are not writeable on this contact.");
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_postal_address_details_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->change_postal_addresses (self, postal_addresses, _callback_, _user_data_);
}


void folks_postal_address_details_change_postal_addresses_finish (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->change_postal_addresses_finish (self, _res_, error);
}


GeeSet* folks_postal_address_details_get_postal_addresses (FolksPostalAddressDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->get_postal_addresses (self);
}


void folks_postal_address_details_set_postal_addresses (FolksPostalAddressDetails* self, GeeSet* value) {
	g_return_if_fail (self != NULL);
	FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->set_postal_addresses (self, value);
}


static void folks_postal_address_details_base_init (FolksPostalAddressDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The postal addresses of the contact.
		   *
		   * A list of postal addresses associated to the contact.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("postal-addresses", "postal-addresses", "postal-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_postal_addresses = folks_postal_address_details_real_change_postal_addresses;
		iface->change_postal_addresses_finish = folks_postal_address_details_real_change_postal_addresses_finish;
	}
}


/**
 * Interface for classes that can provide postal addresses, such as
 * {@link Persona} and {@link Individual}.
 */
GType folks_postal_address_details_get_type (void) {
	static volatile gsize folks_postal_address_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressDetailsIface), (GBaseInitFunc) folks_postal_address_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_postal_address_details_type_id;
		folks_postal_address_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPostalAddressDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_postal_address_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_postal_address_details_type_id__volatile, folks_postal_address_details_type_id);
	}
	return folks_postal_address_details_type_id__volatile;
}



