/* This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 3, or (at your option) any later
version.

GNU Modula-2 is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with gm2; see the file COPYING.  If not, write to the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  */

#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _mcFileName_H
#define _mcFileName_C

#   include "GASCII.h"
#   include "GDynamicStrings.h"

#   define MaxFileName 0
#   define MaxStemName 0
#   define Directory '/'

/*
   calculateFileName - calculates and returns a new string filename given a module
                       and an extension. String, Extension, is concatenated onto
                       Module and thus it is safe to `Mark' the extension for garbage
                       collection.
*/

DynamicStrings_String mcFileName_calculateFileName (DynamicStrings_String module, DynamicStrings_String extension);

/*
   calculateStemName - calculates the stem name for given a module.
                       This name length will be operating system and
      	       	       compiler specific.
*/

DynamicStrings_String mcFileName_calculateStemName (DynamicStrings_String module);

/*
   extractExtension - given a, filename, return the filename without
                      the extension, Ext.
*/

DynamicStrings_String mcFileName_extractExtension (DynamicStrings_String filename, DynamicStrings_String ext);

/*
   extractModule - given a, filename, return the module name including any
                   extension. A new string is returned.
*/

DynamicStrings_String mcFileName_extractModule (DynamicStrings_String filename);


/*
   calculateFileName - calculates and returns a new string filename given a module
                       and an extension. String, Extension, is concatenated onto
                       Module and thus it is safe to `Mark' the extension for garbage
                       collection.
*/

DynamicStrings_String mcFileName_calculateFileName (DynamicStrings_String module, DynamicStrings_String extension)
{
  if (MaxFileName == 0)
    return DynamicStrings_ConCat (DynamicStrings_ConCatChar (DynamicStrings_Slice (module, 0, MaxFileName), '.'), extension);
  else
    return DynamicStrings_ConCat (DynamicStrings_ConCatChar (DynamicStrings_Slice (module, 0, (MaxFileName-(DynamicStrings_Length (extension)))-1), '.'), extension);
}


/*
   calculateStemName - calculates the stem name for given a module.
                       This name length will be operating system and
      	       	       compiler specific.
*/

DynamicStrings_String mcFileName_calculateStemName (DynamicStrings_String module)
{
  return DynamicStrings_Slice (module, 0, MaxStemName);
}


/*
   extractExtension - given a, filename, return the filename without
                      the extension, Ext.
*/

DynamicStrings_String mcFileName_extractExtension (DynamicStrings_String filename, DynamicStrings_String ext)
{
  if (DynamicStrings_Equal (ext, DynamicStrings_Mark (DynamicStrings_Slice (filename, (int) -(DynamicStrings_Length (ext)), 0))))
    return DynamicStrings_Slice (filename, 0, (int) -(DynamicStrings_Length (ext)));
  else
    return filename;
}


/*
   extractModule - given a, filename, return the module name including any
                   extension. A new string is returned.
*/

DynamicStrings_String mcFileName_extractModule (DynamicStrings_String filename)
{
  int i;

  i = DynamicStrings_Index (filename, Directory, 0);
  if (i == -1)
    return DynamicStrings_Dup (filename);
  else
    return DynamicStrings_Slice (filename, i+1, 0);
}

void _M2_mcFileName_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}

void _M2_mcFileName_finish (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}
