/* Copyright (C) 2015, 2016
   Free Software Foundation, Inc.
   This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 3, or (at your option) any later
version.

GNU Modula-2 is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with gm2; see the file COPYING.  If not, write to the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  */

#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#include <stddef.h>
#include <string.h>
#include <limits.h>
#define _mcp3_H
#define _mcp3_C

#   include "GDynamicStrings.h"
#   include "GmcError.h"
#   include "GnameKey.h"
#   include "GmcPrintf.h"
#   include "GmcDebug.h"
#   include "GmcReserved.h"
#   include "GmcMetaError.h"
#   include "GmcStack.h"
#   include "GmcLexBuf.h"
#   include "Gdecl.h"

#   define Pass1 FALSE
#   define Debugging FALSE
typedef unsigned int stop0;

typedef unsigned int SetOfStop0;

typedef unsigned int stop1;

typedef unsigned int SetOfStop1;

typedef unsigned int stop2;

typedef unsigned int SetOfStop2;

static unsigned int WasNoError;
static nameKey_Name curstring;
static nameKey_Name curident;
static decl_node curproc;
static decl_node frommodule;
static decl_node typeDes;
static decl_node typeExp;
static decl_node curmodule;
static mcStack_stack stk;

/*
   CompilationUnit - returns TRUE if the input was correct enough to parse
                     in future passes.
*/

unsigned int mcp3_CompilationUnit (void);

/*
   push -
*/

static decl_node push (decl_node n);

/*
   pop -
*/

static decl_node pop (void);

/*
   replace -
*/

static decl_node replace (decl_node n);

/*
   peep - returns the top node on the stack without removing it.
*/

static decl_node peep (void);

/*
   depth - returns the depth of the stack.
*/

static unsigned int depth (void);

/*
   checkDuplicate -
*/

static void checkDuplicate (unsigned int b);

/*
   checkDuplicate -
*/

static void ErrorString (DynamicStrings_String s);

/*
   checkDuplicate -
*/

static void ErrorArray (char *a_, unsigned int _a_high);

/*
   pushNunbounded -
*/

static void pushNunbounded (unsigned int c);

/*
   makeIndexedArray - builds and returns an array of type, t, with, c, indices.
*/

static decl_node makeIndexedArray (unsigned int c, decl_node t);

/*
   importInto - from, m, import, name, into module, current.
                It checks to see if curident is an enumeration type
                and if so automatically includes all enumeration fields
                as well.
*/

static void importInto (decl_node m, nameKey_Name name, decl_node current);

/*
   checkEndName - if module does not have, name, then issue an error containing, desc.
*/

static void checkEndName (decl_node module, nameKey_Name name, char *desc_, unsigned int _desc_high);

/*
   DescribeStop - issues a message explaining what tokens were expected
*/

static DynamicStrings_String DescribeStop (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DescribeError - issues a message explaining what tokens were expected
*/

static void DescribeError (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SyntaxError - after a syntax error we skip all tokens up until we reach
                 a stop symbol.
*/

static void SyntaxError (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SyntaxCheck -
*/

static void SyntaxCheck (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   WarnMissingToken - generates a warning message about a missing token, t.
*/

static void WarnMissingToken (mcReserved_toktype t);

/*
   MissingToken - generates a warning message about a missing token, t.
*/

static void MissingToken (mcReserved_toktype t);

/*
   CheckAndInsert -
*/

static unsigned int CheckAndInsert (mcReserved_toktype t, SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   InStopSet
*/

static unsigned int InStopSet (mcReserved_toktype t, SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   PeepToken - peep token checks to see whether the stopset is satisfied by currenttoken
               If it is not then it will insert a token providing the token
               is one of ; ] ) } . OF END ,

               if the stopset contains <identtok> then we do not insert a token
*/

static void PeepToken (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Expect -
*/

static void Expect (mcReserved_toktype t, SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Ident - error checking varient of Ident
*/

static void Ident (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   string -
*/

static void string (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Integer -
*/

static void Integer (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Real -
*/

static void Real (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FileUnit := DefinitionModule  | ImplementationOrProgramModule 

   first  symbols:implementationtok, moduletok, definitiontok
   
   cannot reachend
*/

static void FileUnit (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProgramModule := 'MODULE' Ident 
                    % curmodule := lookupModule (curident)  %
                    
                    % enterScope (curmodule)  %
                    
                    % resetEnumPos (curmodule)  %
                    [ Priority  ] ';' { Import  } Block Ident 
                    
                    % checkEndName (curmodule, curident, 'program module')  %
                    
                    % setConstExpComplete (curmodule)  %
                    
                    % leaveScope  %
                    '.' 

   first  symbols:moduletok
   
   cannot reachend
*/

static void ProgramModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ImplementationModule := 'IMPLEMENTATION' 'MODULE' Ident 
                           % curmodule := lookupImp (curident)  %
                           
                           % enterScope (lookupDef (curident))  %
                           
                           % enterScope (curmodule)  %
                           
                           % resetEnumPos (curmodule)  %
                           [ Priority  ] ';' { Import  } Block 
                           Ident 
                           % checkEndName (curmodule, curident, 'implementation module')  %
                           
                           % setConstExpComplete (curmodule)  %
                           
                           % leaveScope ; leaveScope  %
                           '.' 

   first  symbols:implementationtok
   
   cannot reachend
*/

static void ImplementationModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ImplementationOrProgramModule := ImplementationModule  | 
                                    ProgramModule 

   first  symbols:moduletok, implementationtok
   
   cannot reachend
*/

static void ImplementationOrProgramModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Number := Integer  | Real 

   first  symbols:realtok, integertok
   
   cannot reachend
*/

static void Number (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Qualident := Ident { '.' Ident  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void Qualident (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstantDeclaration := 
                          % VAR d, e: node ;  %
                          Ident 
                          % d := lookupSym (curident)  %
                          '=' ConstExpression 
                          % e := pop ()  %
                          
                          % assert (isConst (d))  %
                          
                          % putConst (d, e)  %
                          

   first  symbols:identtok
   
   cannot reachend
*/

static void ConstantDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstExpressionNop := SimpleConstExpr 
                         % VAR n: node ;  %
                         [ Relation SimpleConstExpr  ] 
                         % n := makeConstExp ()  %
                         

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void ConstExpressionNop (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstExpression := 
                      % VAR n: node ;  %
                      
                      % n := push (makeConstExp ())  %
                      SimpleConstExpr [ Relation SimpleConstExpr  ] 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void ConstExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Relation := '='  | '#'  | '<>'  | '<'  | '<='  | '>'  | 
               '>='  | 'IN' 

   first  symbols:intok, greaterequaltok, greatertok, lessequaltok, lesstok, lessgreatertok, hashtok, equaltok
   
   cannot reachend
*/

static void Relation (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SimpleConstExpr := UnaryOrConstTerm { AddOperator ConstTerm  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void SimpleConstExpr (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   UnaryOrConstTerm := '+' ConstTerm  | '-' ConstTerm  | 
                       ConstTerm 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void UnaryOrConstTerm (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AddOperator := '+'  | '-'  | 'OR' 

   first  symbols:ortok, minustok, plustok
   
   cannot reachend
*/

static void AddOperator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstTerm := ConstFactor { MulOperator ConstFactor  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok
   
   cannot reachend
*/

static void ConstTerm (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   MulOperator := '*'  | '/'  | 'DIV'  | 'MOD'  | 'REM'  | 
                  'AND'  | '&' 

   first  symbols:ambersandtok, andtok, remtok, modtok, divtok, dividetok, timestok
   
   cannot reachend
*/

static void MulOperator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstFactor := Number  | ConstString  | ConstSetOrQualidentOrFunction  | 
                  '(' ConstExpressionNop ')'  | 
                  'NOT' ConstFactor  | ConstAttribute 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok
   
   cannot reachend
*/

static void ConstFactor (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstString := string 

   first  symbols:stringtok
   
   cannot reachend
*/

static void ConstString (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ComponentElement := ConstExpressionNop [ '..' ConstExpressionNop  ] 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ComponentElement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ComponentValue := ComponentElement [ 'BY' ConstExpressionNop  ] 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void ComponentValue (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ArraySetRecordValue := ComponentValue { ',' ComponentValue  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ArraySetRecordValue (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Constructor := '{' [ ArraySetRecordValue  ] '}' 

   first  symbols:lcbratok
   
   cannot reachend
*/

static void Constructor (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstSetOrQualidentOrFunction := Qualident [ Constructor  | 
                                                ConstActualParameters  ]  | 
                                    Constructor 

   first  symbols:lcbratok, identtok
   
   cannot reachend
*/

static void ConstSetOrQualidentOrFunction (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstActualParameters := '(' [ ConstExpList  ] ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void ConstActualParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstExpList := ConstExpressionNop { ',' ConstExpressionNop  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ConstExpList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstAttribute := '__ATTRIBUTE__' '__BUILTIN__' '(' '(' ConstAttributeExpression 
                     ')' ')' 

   first  symbols:attributetok
   
   cannot reachend
*/

static void ConstAttribute (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ConstAttributeExpression := Ident  | '<' Qualident ',' Ident 
                               '>' 

   first  symbols:lesstok, identtok
   
   cannot reachend
*/

static void ConstAttributeExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ByteAlignment := '' 

   first  symbols:ldirectivetok
   
   cannot reachend
*/

static void ByteAlignment (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   OptAlignmentExpression := [ AlignmentExpression  ] 

   first  symbols:lparatok
   
   reachend
*/

static void OptAlignmentExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AlignmentExpression := '(' ConstExpressionNop ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void AlignmentExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Alignment := [ ByteAlignment  ] 

   first  symbols:ldirectivetok
   
   reachend
*/

static void Alignment (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   IdentList := Ident { ',' Ident  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void IdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   PushIdentList := 
                    % VAR n: node ;  %
                    
                    % n := makeIdentList ()  %
                    Ident 
                    % checkDuplicate (putIdent (n, curident))  %
                    { ',' Ident 
                      % checkDuplicate (putIdent (n, curident))  %
                       } 
                    % n := push (n)  %
                    

   first  symbols:identtok
   
   cannot reachend
*/

static void PushIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SubrangeType := 
                   % VAR low, high: node ; d: CARDINAL ;  %
                   '[' 
                   % d := depth ()  %
                   ConstExpression 
                   % low := pop ()  %
                   
                   % assert (d = depth ())  %
                   '..' ConstExpression 
                   % high := pop ()  %
                   
                   % assert (d = depth ())  %
                   
                   % typeExp := push (makeSubrange (low, high))  %
                   
                   % assert (d = depth () - 1)  %
                   ']' 

   first  symbols:lsbratok
   
   cannot reachend
*/

static void SubrangeType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ArrayType := 'ARRAY' 
                % VAR c: CARDINAL ; t, n: node ;  %
                
                % c := 0  %
                SimpleType 
                % INC (c)  %
                { ',' SimpleType 
                  % INC (c)  %
                   } 'OF' Type 
                % n := push (makeIndexedArray (c, pop ()))  %
                

   first  symbols:arraytok
   
   cannot reachend
*/

static void ArrayType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   RecordType := 'RECORD' 
                 % VAR n: node ;  %
                 
                 % n := push (makeRecord ())  %
                 
                 % n := push (NIL)     no varient   %
                 [ DefaultRecordAttributes  ] FieldListSequence 
                 
                 % assert (pop ()=NIL)  %
                 'END' 

   first  symbols:recordtok
   
   cannot reachend
*/

static void RecordType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefaultRecordAttributes := '' 

   first  symbols:ldirectivetok
   
   cannot reachend
*/

static void DefaultRecordAttributes (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   RecordFieldPragma := [ ''  ] 

   first  symbols:ldirectivetok
   
   reachend
*/

static void RecordFieldPragma (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FieldPragmaExpression := Ident PragmaConstExpression 

   first  symbols:identtok
   
   cannot reachend
*/

static void FieldPragmaExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   PragmaConstExpression := [ '(' ConstExpressionNop ')'  ] 

   first  symbols:lparatok
   
   reachend
*/

static void PragmaConstExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AttributeExpression := Ident '(' ConstExpressionNop ')' 

   first  symbols:identtok
   
   cannot reachend
*/

static void AttributeExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FieldListSequence := FieldListStatement { ';' FieldListStatement  } 

   first  symbols:casetok, identtok, semicolontok
   
   reachend
*/

static void FieldListSequence (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FieldListStatement := [ FieldList  ] 

   first  symbols:identtok, casetok
   
   reachend
*/

static void FieldListStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FieldList := 
                % VAR r, i, f, t, n, v, w: node ; d: CARDINAL ;  %
                
                % d := depth ()  %
                
                % v := pop () ; assert ((v=NIL) OR isVarient (v))  %
                
                % r := peep () ; assert (isRecord (r) OR isVarientField (r))  %
                
                % v := push (v)  %
                
                % assert (d=depth ())  %
                
                % assert (((v=NIL) AND isRecord (r)) OR ((v#NIL) AND isVarientField (r)))  %
                PushIdentList ':' 
                % assert (d=depth () - 1)  %
                
                % i := pop ()  %
                Type 
                % assert (d=depth () - 1)  %
                
                % t := pop ()  %
                RecordFieldPragma 
                % assert (d=depth ())  %
                
                % r := addFieldsToRecord (r, v, i, t)  %
                
                % assert (d=depth ())  %
                 | 'CASE' 
                %  addRecordToList   %
                
                % d := depth ()  %
                
                % v := pop () ; assert ((v=NIL) OR isVarient (v))  %
                
                % r := peep () ; assert (isRecord (r) OR isVarientField (r))  %
                
                % v := push (v)  %
                
                % assert (((v=NIL) AND isRecord (r)) OR ((v#NIL) AND isRecordField (r)))  %
                
                % w := push (makeVarient (r))  %
                
                % assert (d = depth () - 1)  %
                
                %  addVarientToList   %
                CaseTag 'OF' 
                % assert (d = depth () - 1)  %
                Varient 
                % assert (d = depth () - 1)  %
                { '|' Varient 
                  % assert (d = depth () - 1)  %
                   } 
                % w := peep () ; assert (isVarient (w))  %
                
                % assert (d = depth () - 1)  %
                [ 'ELSE' FieldListSequence  ] 'END' 
                % w := pop () ; assert (isVarient (w))  %
                
                % assert (d=depth ())  %
                

   first  symbols:casetok, identtok
   
   cannot reachend
*/

static void FieldList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   TagIdent := Ident  | 
               % curident := NulName  %
               

   first  symbols:identtok
   
   reachend
*/

static void TagIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   CaseTag := 
              % VAR tagident: Name ; q, v, w, r: node ;  %
              
              % w := pop () ; v := pop () ; r := peep () ; v := push (v) ; w := push (w)  %
              
              % assert (isVarient (w))  %
              
              % assert ((v=NIL) OR isVarient (v))  %
              
              % assert (isRecord (r) OR isVarientField (r))  %
              
              % assert (isVarient (push (pop ())))  %
              TagIdent 
              % tagident := curident  %
              ( ':' PushQualident 
                % q := pop ()  %
                
                % assert (isVarient (push (pop ())))  %
                 | 
                % q := NIL  %
                 ) 
              % buildVarientSelector (r, w, tagident, q)  %
              

   first  symbols:colontok, identtok
   
   reachend
*/

static void CaseTag (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Varient := 
              % VAR p, r, v, f: node ; d: CARDINAL ;  %
              
              % d := depth ()  %
              
              % assert (isVarient (peep ()))  %
              [ 
                % v := pop () ; assert (isVarient (v))  %
                
                % r := pop ()  %
                
                % p := peep ()  %
                
                % r := push (r)  %
                
                % f := push (buildVarientFieldRecord (v, p))  %
                
                % v := push (v)  %
                VarientCaseLabelList ':' FieldListSequence 
                % v := pop ()  %
                
                % f := pop ()  %
                
                % assert (isVarientField (f))  %
                
                % assert (isVarient (v))  %
                
                % v := push (v)  %
                 ] 
              % assert (isVarient (peep ()))  %
              
              % assert (d=depth ())  %
              

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   reachend
*/

static void Varient (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   VarientCaseLabelList := VarientCaseLabels { ',' VarientCaseLabels  } 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void VarientCaseLabelList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   VarientCaseLabels := 
                        % VAR l, h: node ;  %
                        
                        % h := NIL  %
                        ConstExpression 
                        % l := pop ()  %
                        [ '..' ConstExpression 
                          % h := pop ()  %
                           ] 
                        %  l, h  could be saved if necessary.    %
                        

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void VarientCaseLabels (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SetType := ( 'SET'  | 'PACKEDSET'  ) 'OF' SimpleType 
              % VAR n: node ;  %
              
              % n := push (makeSet (pop ()))  %
              

   first  symbols:oftok, packedsettok, settok
   
   cannot reachend
*/

static void SetType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   PointerType := 'POINTER' 'TO' Type 
                  % VAR n: node ;  %
                  
                  % n := push (makePointer (pop ()))  %
                  

   first  symbols:pointertok
   
   cannot reachend
*/

static void PointerType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureType := 'PROCEDURE' 
                    % curproc := push (makeProcType ())  %
                    [ FormalTypeList  ] 

   first  symbols:proceduretok
   
   cannot reachend
*/

static void ProcedureType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FormalTypeList := '(' ( ')' FormalReturn  | 
                           ProcedureParameters ')' FormalReturn  ) 

   first  symbols:lparatok
   
   cannot reachend
*/

static void FormalTypeList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FormalReturn := [ ':' OptReturnType  ] 

   first  symbols:colontok
   
   reachend
*/

static void FormalReturn (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   OptReturnType := '[' PushQualident 
                    % putReturnType (curproc, pop ())  %
                    
                    % putOptReturn (curproc)  %
                    ']'  | PushQualident 
                    % putReturnType (curproc, pop ())  %
                    

   first  symbols:identtok, lsbratok
   
   cannot reachend
*/

static void OptReturnType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureParameters := ProcedureParameter 
                          % addParameter (curproc, pop ())  %
                          { ',' ProcedureParameter 
                            % addParameter (curproc, pop ())  %
                             } 

   first  symbols:identtok, arraytok, periodperiodperiodtok, vartok
   
   cannot reachend
*/

static void ProcedureParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureParameter := '...' 
                         % VAR n: node ;  %
                         
                         % n := push (makeVarargs ())  %
                          | 'VAR' FormalType 
                         % n := push (makeVarParameter (NIL, pop (), curproc))  %
                          | FormalType 
                         % n := push (makeNonVarParameter (NIL, pop (), curproc))  %
                         

   first  symbols:identtok, arraytok, vartok, periodperiodperiodtok
   
   cannot reachend
*/

static void ProcedureParameter (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   VarIdent := 
               % VAR n, a: node ;  %
               
               % n := pop ()  %
               Ident 
               % checkDuplicate (putIdent (n, curident))  %
               
               % n := push (n)  %
               [ '[' ConstExpression 
                 % a := pop ()   could store, a, into, n.    %
                 ']'  ] 

   first  symbols:identtok
   
   cannot reachend
*/

static void VarIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   VarIdentList := 
                   % VAR n: node ;  %
                   
                   % n := makeIdentList ()  %
                   
                   % n := push (n)  %
                   VarIdent { ',' VarIdent  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void VarIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   VariableDeclaration := 
                          % VAR v, d: node ;  %
                          VarIdentList 
                          % v := pop ()  %
                          ':' Type 
                          % d := makeVarDecl (v, pop ())  %
                          Alignment 

   first  symbols:identtok
   
   cannot reachend
*/

static void VariableDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Designator := Qualident { SubDesignator  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void Designator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SubDesignator := '.' Ident  | '[' ArrayExpList ']'  | 
                    '^' 

   first  symbols:uparrowtok, lsbratok, periodtok
   
   cannot reachend
*/

static void SubDesignator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ArrayExpList := Expression { ',' Expression  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ArrayExpList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ExpList := Expression { ',' Expression  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ExpList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Expression := SimpleExpression [ Relation SimpleExpression  ] 

   first  symbols:identtok, lcbratok, nottok, lparatok, stringtok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void Expression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SimpleExpression := UnaryOrTerm { AddOperator Term  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void SimpleExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   UnaryOrTerm := '+' Term  | '-' Term  | Term 

   first  symbols:identtok, lcbratok, nottok, lparatok, stringtok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void UnaryOrTerm (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Term := Factor { MulOperator Factor  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok
   
   cannot reachend
*/

static void Term (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Factor := Number  | string  | SetOrDesignatorOrFunction  | 
             '(' Expression ')'  | 'NOT' ( Factor  | ConstAttribute  ) 

   first  symbols:identtok, lcbratok, nottok, lparatok, stringtok, integertok, realtok
   
   cannot reachend
*/

static void Factor (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SetOrDesignatorOrFunction := Qualident [ Constructor  | 
                                            SimpleDes [ ActualParameters  ]  ]  | 
                                Constructor 

   first  symbols:lcbratok, identtok
   
   cannot reachend
*/

static void SetOrDesignatorOrFunction (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SimpleDes := { SubDesignator  } 

   first  symbols:periodtok, lsbratok, uparrowtok
   
   reachend
*/

static void SimpleDes (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ActualParameters := '(' [ ExpList  ] ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void ActualParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ExitStatement := 'EXIT' 

   first  symbols:exittok
   
   cannot reachend
*/

static void ExitStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ReturnStatement := 'RETURN' [ Expression  ] 

   first  symbols:returntok
   
   cannot reachend
*/

static void ReturnStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Statement := [ AssignmentOrProcedureCall  | 
                  IfStatement  | CaseStatement  | 
                  WhileStatement  | RepeatStatement  | 
                  LoopStatement  | ForStatement  | 
                  WithStatement  | AsmStatement  | 
                  ExitStatement  | ReturnStatement  | 
                  RetryStatement  ] 

   first  symbols:retrytok, asmtok, withtok, fortok, looptok, repeattok, whiletok, casetok, iftok, identtok, returntok, exittok
   
   reachend
*/

static void Statement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   RetryStatement := 'RETRY' 

   first  symbols:retrytok
   
   cannot reachend
*/

static void RetryStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AssignmentOrProcedureCall := Designator ( ':=' Expression  | 
                                             ActualParameters  | 
                                             
                                             %  epsilon   %
                                              ) 

   first  symbols:identtok
   
   cannot reachend
*/

static void AssignmentOrProcedureCall (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   StatementSequence := Statement { ';' Statement  } 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok
   
   reachend
*/

static void StatementSequence (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   IfStatement := 'IF' Expression 'THEN' StatementSequence { 
   'ELSIF' Expression 'THEN' StatementSequence  } [ 'ELSE' StatementSequence  ] 
                  'END' 

   first  symbols:iftok
   
   cannot reachend
*/

static void IfStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   CaseStatement := 'CASE' Expression 'OF' Case { '|' Case  } 
                    CaseEndStatement 

   first  symbols:casetok
   
   cannot reachend
*/

static void CaseStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   CaseEndStatement := 'END'  | 'ELSE' StatementSequence 'END' 

   first  symbols:elsetok, endtok
   
   cannot reachend
*/

static void CaseEndStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Case := [ CaseLabelList ':' StatementSequence  ] 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   reachend
*/

static void Case (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   CaseLabelList := CaseLabels { ',' CaseLabels  } 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void CaseLabelList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   CaseLabels := ConstExpressionNop [ '..' ConstExpressionNop  ] 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void CaseLabels (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   WhileStatement := 'WHILE' Expression 'DO' StatementSequence 
                     'END' 

   first  symbols:whiletok
   
   cannot reachend
*/

static void WhileStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   RepeatStatement := 'REPEAT' StatementSequence 'UNTIL' Expression 

   first  symbols:repeattok
   
   cannot reachend
*/

static void RepeatStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ForStatement := 'FOR' Ident ':=' Expression 'TO' Expression 
                   [ 'BY' ConstExpressionNop  ] 'DO' StatementSequence 
                   'END' 

   first  symbols:fortok
   
   cannot reachend
*/

static void ForStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   LoopStatement := 'LOOP' StatementSequence 'END' 

   first  symbols:looptok
   
   cannot reachend
*/

static void LoopStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   WithStatement := 'WITH' Designator 'DO' StatementSequence 
                    'END' 

   first  symbols:withtok
   
   cannot reachend
*/

static void WithStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureDeclaration := ProcedureHeading ';' ProcedureBlock 
                           Ident 
                           % leaveScope  %
                           

   first  symbols:proceduretok
   
   cannot reachend
*/

static void ProcedureDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureIdent := Ident 
                     % curproc := lookupSym (curident)  %
                     
                     % enterScope (curproc)  %
                     

   first  symbols:identtok
   
   cannot reachend
*/

static void ProcedureIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefProcedureIdent := Ident 
                        % curproc := lookupSym (curident)  %
                        

   first  symbols:identtok
   
   cannot reachend
*/

static void DefProcedureIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefineBuiltinProcedure := [ '__ATTRIBUTE__' '__BUILTIN__' 
                               '(' '(' Ident ')' ')'  | 
                               '__INLINE__'  ] 

   first  symbols:inlinetok, attributetok
   
   reachend
*/

static void DefineBuiltinProcedure (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureHeading := 'PROCEDURE' DefineBuiltinProcedure ( ProcedureIdent 
                                                            [ 
   FormalParameters  ]  ) 

   first  symbols:proceduretok
   
   cannot reachend
*/

static void ProcedureHeading (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Builtin := [ '__BUILTIN__'  | '__INLINE__'  ] 

   first  symbols:inlinetok, builtintok
   
   reachend
*/

static void Builtin (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefProcedureHeading := 'PROCEDURE' Builtin ( DefProcedureIdent 
                                                [ DefFormalParameters  ]  ) 

   first  symbols:proceduretok
   
   cannot reachend
*/

static void DefProcedureHeading (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureBlock := { Declaration  } [ 'BEGIN' ProcedureBlockBody  ] 
                     'END' 

   first  symbols:proceduretok, moduletok, consttok, typetok, vartok, endtok, begintok
   
   cannot reachend
*/

static void ProcedureBlock (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Block := { Declaration  } InitialBlock FinalBlock 'END' 

   first  symbols:proceduretok, moduletok, finallytok, begintok, consttok, typetok, vartok, endtok
   
   cannot reachend
*/

static void Block (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   InitialBlock := [ 'BEGIN' InitialBlockBody  ] 

   first  symbols:begintok
   
   reachend
*/

static void InitialBlock (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FinalBlock := [ 'FINALLY' FinalBlockBody  ] 

   first  symbols:finallytok
   
   reachend
*/

static void FinalBlock (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   InitialBlockBody := NormalPart [ 'EXCEPT' ExceptionalPart  ] 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok, excepttok
   
   reachend
*/

static void InitialBlockBody (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FinalBlockBody := NormalPart [ 'EXCEPT' ExceptionalPart  ] 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok, excepttok
   
   reachend
*/

static void FinalBlockBody (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ProcedureBlockBody := NormalPart [ 'EXCEPT' ExceptionalPart  ] 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok, excepttok
   
   reachend
*/

static void ProcedureBlockBody (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   NormalPart := StatementSequence 

   first  symbols:retrytok, asmtok, withtok, fortok, looptok, repeattok, whiletok, casetok, iftok, identtok, returntok, exittok, semicolontok
   
   reachend
*/

static void NormalPart (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ExceptionalPart := StatementSequence 

   first  symbols:retrytok, asmtok, withtok, fortok, looptok, repeattok, whiletok, casetok, iftok, identtok, returntok, exittok, semicolontok
   
   reachend
*/

static void ExceptionalPart (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Declaration := 'CONST' { ConstantDeclaration ';'  }  | 
                  'TYPE' { TypeDeclaration  }  | 
                  'VAR' { VariableDeclaration ';'  }  | 
                  ProcedureDeclaration ';'  | 
                  ModuleDeclaration ';' 

   first  symbols:moduletok, proceduretok, vartok, typetok, consttok
   
   cannot reachend
*/

static void Declaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefFormalParameters := '(' 
                          % paramEnter (curproc)  %
                          [ DefMultiFPSection  ] ')' 
                          % paramLeave (curproc)  %
                          FormalReturn 

   first  symbols:lparatok
   
   cannot reachend
*/

static void DefFormalParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefMultiFPSection := DefExtendedFP  | FPSection [ ';' DefMultiFPSection  ] 

   first  symbols:identtok, vartok, lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void DefMultiFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FormalParameters := '(' 
                       % paramEnter (curproc)  %
                       [ MultiFPSection  ] ')' 
                       % paramLeave (curproc)  %
                       FormalReturn 

   first  symbols:lparatok
   
   cannot reachend
*/

static void FormalParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   MultiFPSection := ExtendedFP  | FPSection [ ';' MultiFPSection  ] 

   first  symbols:identtok, vartok, lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void MultiFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FPSection := NonVarFPSection  | VarFPSection 

   first  symbols:vartok, identtok
   
   cannot reachend
*/

static void FPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefExtendedFP := DefOptArg  | '...' 
                    % addParameter (curproc, makeVarargs ())  %
                    

   first  symbols:lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void DefExtendedFP (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ExtendedFP := OptArg  | '...' 

   first  symbols:lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void ExtendedFP (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   VarFPSection := 'VAR' PushIdentList 
                   % VAR l, t: node ;  %
                   ':' FormalType 
                   % t := pop ()  %
                   
                   % l := pop ()  %
                   
                   % addVarParameters (curproc, l, t)  %
                   

   first  symbols:vartok
   
   cannot reachend
*/

static void VarFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   NonVarFPSection := PushIdentList 
                      % VAR l, t: node ;  %
                      ':' FormalType 
                      % t := pop ()  %
                      
                      % l := pop ()  %
                      
                      % addNonVarParameters (curproc, l, t)  %
                      

   first  symbols:identtok
   
   cannot reachend
*/

static void NonVarFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   OptArg := 
             % VAR p, init, type: node ; id: Name ;  %
             '[' Ident 
             % id := curident  %
             ':' FormalType 
             % type := pop ()  %
             
             % init := NIL  %
             [ '=' ConstExpression 
               % init := pop ()  %
                ] ']' 
             % p := addOptParameter (curproc, id, type, init)  %
             

   first  symbols:lsbratok
   
   cannot reachend
*/

static void OptArg (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefOptArg := 
                % VAR p, init, type: node ; id: Name ;  %
                '[' Ident 
                % id := curident  %
                ':' FormalType 
                % type := pop ()  %
                '=' ConstExpression 
                % init := pop ()  %
                ']' 
                % p := addOptParameter (curproc, id, type, init)  %
                

   first  symbols:lsbratok
   
   cannot reachend
*/

static void DefOptArg (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FormalType := 
                 % VAR c: CARDINAL ;  %
                 
                 % VAR n, a, s: node ;  %
                 
                 % c := 0  %
                 { 'ARRAY' 'OF' 
                   % INC (c)  %
                    } PushQualident 
                 % pushNunbounded (c)  %
                 

   first  symbols:identtok, arraytok
   
   cannot reachend
*/

static void FormalType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ModuleDeclaration := 'MODULE' Ident [ Priority  ] ';' { Import  } 
                        [ Export  ] Block Ident 

   first  symbols:moduletok
   
   cannot reachend
*/

static void ModuleDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Priority := '[' ConstExpressionNop ']' 

   first  symbols:lsbratok
   
   cannot reachend
*/

static void Priority (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Export := 'EXPORT' ( 'QUALIFIED' IdentList  | 
                        'UNQUALIFIED' IdentList  | 
                        IdentList  ) ';' 

   first  symbols:exporttok
   
   cannot reachend
*/

static void Export (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FromIdentList := Ident 
                    % importInto (frommodule, curident, curmodule)  %
                    { ',' Ident 
                      % importInto (frommodule, curident, curmodule)  %
                       } 

   first  symbols:identtok
   
   cannot reachend
*/

static void FromIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   FromImport := 'FROM' Ident 
                 % frommodule := lookupDef (curident)  %
                 'IMPORT' FromIdentList ';' 

   first  symbols:fromtok
   
   cannot reachend
*/

static void FromImport (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   ImportModuleList := Ident { ',' Ident  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void ImportModuleList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   WithoutFromImport := 'IMPORT' ImportModuleList ';' 

   first  symbols:importtok
   
   cannot reachend
*/

static void WithoutFromImport (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Import := FromImport  | WithoutFromImport 

   first  symbols:importtok, fromtok
   
   cannot reachend
*/

static void Import (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   DefinitionModule := 'DEFINITION' 'MODULE' [ 'FOR' string  ] 
                       Ident ';' 
                       % curmodule := lookupDef (curident)  %
                       
                       % enterScope (curmodule)  %
                       
                       % resetEnumPos (curmodule)  %
                       { Import  } [ Export  ] { Definition  } 
                       'END' Ident '.' 
                       % checkEndName (curmodule, curident, 'definition module')  %
                       
                       % setConstExpComplete (curmodule)  %
                       
                       % leaveScope  %
                       

   first  symbols:definitiontok
   
   cannot reachend
*/

static void DefinitionModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   PushQualident := Ident 
                    % typeExp := push (lookupSym (curident))  %
                    
                    % IF typeExp = NIL
                                    THEN
                                       metaError1 ('the symbol {%1k} is not visible in this scope (or any other nested scope)', curident)
                                    END  %
                    [ '.' 
                      % IF NOT isDef (typeExp)
                                      THEN
                        									    ErrorArray ('the first component of this qualident must be a definition module')
                                      END  %
                      Ident 
                      % typeExp := replace (lookupInScope (typeExp, curident)) ;
                        			                                                 IF typeExp=NIL
                                      THEN
                                         ErrorArray ('identifier not found in definition module')
                                      END  %
                       ] 

   first  symbols:identtok
   
   cannot reachend
*/

static void PushQualident (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   OptSubrange := [ SubrangeType 
                    % VAR q, s: node ;  %
                    
                    % s := pop ()  %
                    
                    % q := pop ()  %
                    
                    % putSubrangeType (s, q)  %
                    
                    % typeExp := push (s)  %
                     ] 

   first  symbols:lsbratok
   
   reachend
*/

static void OptSubrange (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   TypeEquiv := PushQualident OptSubrange 

   first  symbols:identtok
   
   cannot reachend
*/

static void TypeEquiv (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   EnumIdentList := 
                    % VAR f: node ;  %
                    
                    % typeExp := push (makeEnum ())  %
                    Ident 
                    % f := makeEnumField (typeExp, curident)  %
                    { ',' Ident 
                      % f := makeEnumField (typeExp, curident)  %
                       } 

   first  symbols:identtok
   
   cannot reachend
*/

static void EnumIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Enumeration := '(' EnumIdentList ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void Enumeration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   SimpleType := 
                 % VAR d: CARDINAL ;  %
                 
                 % d := depth ()  %
                 ( TypeEquiv  | Enumeration  | SubrangeType  ) 
                 
                 % assert (d = depth () - 1)  %
                 

   first  symbols:lsbratok, lparatok, identtok
   
   cannot reachend
*/

static void SimpleType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Type := SimpleType  | ArrayType  | RecordType  | 
           SetType  | PointerType  | ProcedureType 

   first  symbols:proceduretok, pointertok, settok, packedsettok, oftok, recordtok, arraytok, identtok, lparatok, lsbratok
   
   cannot reachend
*/

static void Type (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   TypeDeclaration := { Ident 
                        % typeDes := lookupSym (curident)  %
                        ( ';'  | '=' Type 
                          % putType (typeDes, pop ())  %
                          Alignment ';'  )  } 

   first  symbols:identtok
   
   reachend
*/

static void TypeDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   Definition := 'CONST' { ConstantDeclaration ';'  }  | 
                 'TYPE' { TypeDeclaration  }  | 
                 'VAR' { VariableDeclaration ';'  }  | 
                 DefProcedureHeading ';' 

   first  symbols:proceduretok, vartok, typetok, consttok
   
   cannot reachend
*/

static void Definition (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AsmStatement := 'ASM' [ 'VOLATILE'  ] '(' AsmOperands ')' 

   first  symbols:asmtok
   
   cannot reachend
*/

static void AsmStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AsmOperands := string [ AsmOperandSpec  ] 

   first  symbols:stringtok
   
   cannot reachend
*/

static void AsmOperands (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AsmOperandSpec := [ ':' AsmList [ ':' AsmList [ ':' TrashList  ]  ]  ] 

   first  symbols:colontok
   
   reachend
*/

static void AsmOperandSpec (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AsmList := [ AsmElement  ] { ',' AsmElement  } 

   first  symbols:lsbratok, stringtok, commatok
   
   reachend
*/

static void AsmList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   NamedOperand := '[' Ident ']' 

   first  symbols:lsbratok
   
   cannot reachend
*/

static void NamedOperand (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AsmOperandName := [ NamedOperand  ] 

   first  symbols:lsbratok
   
   reachend
*/

static void AsmOperandName (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   AsmElement := AsmOperandName string '(' Expression ')' 

   first  symbols:stringtok, lsbratok
   
   cannot reachend
*/

static void AsmElement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);

/*
   TrashList := [ string  ] { ',' string  } 

   first  symbols:commatok, stringtok
   
   reachend
*/

static void TrashList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2);


/*
   push -
*/

static decl_node push (decl_node n)
{
  return mcStack_push (stk, (void *) n);
}


/*
   pop -
*/

static decl_node pop (void)
{
  return mcStack_pop (stk);
}


/*
   replace -
*/

static decl_node replace (decl_node n)
{
  return mcStack_replace (stk, (void *) n);
}


/*
   peep - returns the top node on the stack without removing it.
*/

static decl_node peep (void)
{
  return push (pop ());
}


/*
   depth - returns the depth of the stack.
*/

static unsigned int depth (void)
{
  return mcStack_depth (stk);
}


/*
   checkDuplicate -
*/

static void checkDuplicate (unsigned int b)
{
}


/*
   checkDuplicate -
*/

static void ErrorString (DynamicStrings_String s)
{
  mcError_errorStringAt (s, mcLexBuf_getTokenNo ());
  WasNoError = FALSE;
}


/*
   checkDuplicate -
*/

static void ErrorArray (char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  ErrorString (DynamicStrings_InitString ((char *) a, _a_high));
}


/*
   pushNunbounded -
*/

static void pushNunbounded (unsigned int c)
{
  decl_node type;
  decl_node array;
  decl_node subrange;

  while (c != 0)
    {
      type = pop ();
      subrange = decl_makeSubrange ((decl_node) NULL, (decl_node) NULL);
      decl_putSubrangeType (subrange, decl_getCardinal ());
      array = decl_makeArray (subrange, type);
      decl_putUnbounded (array);
      type = push (array);
      c -= 1;
    }
}


/*
   makeIndexedArray - builds and returns an array of type, t, with, c, indices.
*/

static decl_node makeIndexedArray (unsigned int c, decl_node t)
{
  decl_node i;

  while (c > 0)
    {
      t = decl_makeArray (pop (), t);
      c -= 1;
    }
  return t;
}


/*
   importInto - from, m, import, name, into module, current.
                It checks to see if curident is an enumeration type
                and if so automatically includes all enumeration fields
                as well.
*/

static void importInto (decl_node m, nameKey_Name name, decl_node current)
{
  decl_node s;
  decl_node o;

  mcDebug_assert (decl_isDef (m));
  mcDebug_assert (((decl_isDef (current)) || (decl_isModule (current))) || (decl_isImp (current)));
  s = decl_lookupExported (m, name);
  if (s == NULL)
    mcMetaError_metaError2 ((char *) "{%1k} was not exported from definition module {%2a}", 51, (unsigned char *) &name, (sizeof (name)-1), (unsigned char *) &m, (sizeof (m)-1));
  else
    {
      o = decl_import (current, s);
      if (s != o)
        mcMetaError_metaError2 ((char *) "{%1ad} cannot be imported into the current module as it causes a name clash with {%2ad}", 87, (unsigned char *) &s, (sizeof (s)-1), (unsigned char *) &o, (sizeof (o)-1));
    }
}


/*
   checkEndName - if module does not have, name, then issue an error containing, desc.
*/

static void checkEndName (decl_node module, nameKey_Name name, char *desc_, unsigned int _desc_high)
{
  DynamicStrings_String s;
  char desc[_desc_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (desc, desc_, _desc_high+1);

  if ((decl_getSymName (module)) != name)
    {
      s = DynamicStrings_InitString ((char *) "inconsistent module name found with this ", 41);
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((char *) desc, _desc_high)));
      ErrorString (s);
    }
}


/*
   DescribeStop - issues a message explaining what tokens were expected
*/

static DynamicStrings_String DescribeStop (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  unsigned int n;
  DynamicStrings_String str;
  DynamicStrings_String message;

  n = 0;
  message = DynamicStrings_InitString ((char *) "", 0);
  if ((((1 << (mcReserved_stringtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`string'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_realtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`real number'", 13)));
      n += 1;
    }
  if ((((1 << (mcReserved_identtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`identifier'", 12)));
      n += 1;
    }
  if ((((1 << (mcReserved_integertok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`integer number'", 16)));
      n += 1;
    }
  if ((((1 << (mcReserved_inlinetok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`__INLINE__'", 12)));
      n += 1;
    }
  if ((((1 << (mcReserved_builtintok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`__BUILTIN__'", 13)));
      n += 1;
    }
  if ((((1 << (mcReserved_attributetok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`__ATTRIBUTE__'", 15)));
      n += 1;
    }
  if ((((1 << (mcReserved_filetok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`__FILE__'", 10)));
      n += 1;
    }
  if ((((1 << (mcReserved_linetok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`__LINE__'", 10)));
      n += 1;
    }
  if ((((1 << (mcReserved_datetok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`__DATE__'", 10)));
      n += 1;
    }
  if ((((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`...'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_volatiletok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`VOLATILE'", 10)));
      n += 1;
    }
  if ((((1 << (mcReserved_asmtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`ASM'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_withtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`WITH'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_whiletok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`WHILE'", 7)));
      n += 1;
    }
  if ((((1 << (mcReserved_vartok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`VAR'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_untiltok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`UNTIL'", 7)));
      n += 1;
    }
  if ((((1 << (mcReserved_typetok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`TYPE'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_totok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`TO'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_thentok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`THEN'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_settok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`SET'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_returntok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`RETURN'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_retrytok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`RETRY'", 7)));
      n += 1;
    }
  if ((((1 << (mcReserved_repeattok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`REPEAT'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_remtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`REM'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_recordtok-mcReserved_recordtok)) & (stopset2)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`RECORD'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_unqualifiedtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`UNQUALIFIED'", 13)));
      n += 1;
    }
  if ((((1 << (mcReserved_qualifiedtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`QUALIFIED'", 11)));
      n += 1;
    }
  if ((((1 << (mcReserved_proceduretok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`PROCEDURE'", 11)));
      n += 1;
    }
  if ((((1 << (mcReserved_pointertok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`POINTER'", 9)));
      n += 1;
    }
  if ((((1 << (mcReserved_packedsettok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`PACKEDSET'", 11)));
      n += 1;
    }
  if ((((1 << (mcReserved_ortok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`OR'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_oftok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`OF'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_nottok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`NOT'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_moduletok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`MODULE'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_modtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`MOD'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_looptok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`LOOP'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_intok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`IN'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_importtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`IMPORT'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_implementationtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`IMPLEMENTATION'", 16)));
      n += 1;
    }
  if ((((1 << (mcReserved_iftok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`IF'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_fromtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`FROM'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_fortok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`FOR'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_finallytok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`FINALLY'", 9)));
      n += 1;
    }
  if ((((1 << (mcReserved_exporttok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`EXPORT'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_exittok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`EXIT'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_excepttok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`EXCEPT'", 8)));
      n += 1;
    }
  if ((((1 << (mcReserved_endtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`END'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_elsiftok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`ELSIF'", 7)));
      n += 1;
    }
  if ((((1 << (mcReserved_elsetok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`ELSE'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_dotok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`DO'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_divtok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`DIV'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_definitiontok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`DEFINITION'", 12)));
      n += 1;
    }
  if ((((1 << (mcReserved_consttok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`CONST'", 7)));
      n += 1;
    }
  if ((((1 << (mcReserved_casetok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`CASE'", 6)));
      n += 1;
    }
  if ((((1 << (mcReserved_bytok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`BY'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_begintok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`BEGIN'", 7)));
      n += 1;
    }
  if ((((1 << (mcReserved_arraytok-mcReserved_arraytok)) & (stopset1)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`ARRAY'", 7)));
      n += 1;
    }
  if ((((1 << (mcReserved_andtok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`AND'", 5)));
      n += 1;
    }
  if ((((1 << (mcReserved_colontok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`:'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_periodperiodtok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`..'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_rdirectivetok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`*>'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_ldirectivetok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`<*'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_greaterequaltok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`>='", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_lessequaltok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`<='", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_lessgreatertok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`<>'", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_hashtok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`#'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_equaltok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`='", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_uparrowtok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`^'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_semicolontok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`;'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_commatok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`,'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_periodtok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`.'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_ambersandtok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`&'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_dividetok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`/'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_timestok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`*'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_minustok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`-'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_plustok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`+'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_doublequotestok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (message, ' '), '`'), '"'), '\''), ',');
      n += 1;
    }
  if ((((1 << (mcReserved_singlequotetok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (message, ' '), '"'), '\''), '"'), ',');
      n += 1;
    }
  if ((((1 << (mcReserved_greatertok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`>'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_lesstok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`<'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_rparatok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`)'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_lparatok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`('", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_rcbratok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`}'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_lcbratok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`{'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_rsbratok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`]'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_lsbratok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`['", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_bartok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`|'", 3)));
      n += 1;
    }
  if ((((1 << (mcReserved_becomestok-mcReserved_eoftok)) & (stopset0)) != 0))
    {
      message = DynamicStrings_ConCat (DynamicStrings_ConCatChar (message, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((char *) "`:='", 4)));
      n += 1;
    }
  if ((((1 << (mcReserved_eoftok-mcReserved_eoftok)) & (stopset0)) != 0))
    {}  /* empty.  */
  /* eoftok has no token name (needed to generate error messages)  */
  if (n == 0)
    {
      str = DynamicStrings_InitString ((char *) " syntax error", 13);
      message = DynamicStrings_KillString (message);
    }
  else if (n == 1)
    str = DynamicStrings_ConCat (message, DynamicStrings_Mark (DynamicStrings_InitString ((char *) " missing ", 9)));
  else
    {
      str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) " expecting one of", 17), message);
      message = DynamicStrings_KillString (message);
    }
  return str;
}


/*
   DescribeError - issues a message explaining what tokens were expected
*/

static void DescribeError (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  DynamicStrings_String str;

  str = DynamicStrings_InitString ((char *) "", 0);
  switch (mcLexBuf_currenttoken)
    {
      case mcReserved_stringtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `string'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_realtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `real number'", 33), DynamicStrings_Mark (str));
        break;

      case mcReserved_identtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `identifier'", 32), DynamicStrings_Mark (str));
        break;

      case mcReserved_integertok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `integer number'", 36), DynamicStrings_Mark (str));
        break;

      case mcReserved_inlinetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `__INLINE__'", 32), DynamicStrings_Mark (str));
        break;

      case mcReserved_builtintok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `__BUILTIN__'", 33), DynamicStrings_Mark (str));
        break;

      case mcReserved_attributetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `__ATTRIBUTE__'", 35), DynamicStrings_Mark (str));
        break;

      case mcReserved_filetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `__FILE__'", 30), DynamicStrings_Mark (str));
        break;

      case mcReserved_linetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `__LINE__'", 30), DynamicStrings_Mark (str));
        break;

      case mcReserved_datetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `__DATE__'", 30), DynamicStrings_Mark (str));
        break;

      case mcReserved_periodperiodperiodtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `...'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_volatiletok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `VOLATILE'", 30), DynamicStrings_Mark (str));
        break;

      case mcReserved_asmtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `ASM'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_withtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `WITH'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_whiletok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `WHILE'", 27), DynamicStrings_Mark (str));
        break;

      case mcReserved_vartok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `VAR'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_untiltok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `UNTIL'", 27), DynamicStrings_Mark (str));
        break;

      case mcReserved_typetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `TYPE'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_totok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `TO'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_thentok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `THEN'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_settok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `SET'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_returntok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `RETURN'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_retrytok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `RETRY'", 27), DynamicStrings_Mark (str));
        break;

      case mcReserved_repeattok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `REPEAT'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_remtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `REM'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_recordtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `RECORD'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_unqualifiedtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `UNQUALIFIED'", 33), DynamicStrings_Mark (str));
        break;

      case mcReserved_qualifiedtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `QUALIFIED'", 31), DynamicStrings_Mark (str));
        break;

      case mcReserved_proceduretok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `PROCEDURE'", 31), DynamicStrings_Mark (str));
        break;

      case mcReserved_pointertok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `POINTER'", 29), DynamicStrings_Mark (str));
        break;

      case mcReserved_packedsettok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `PACKEDSET'", 31), DynamicStrings_Mark (str));
        break;

      case mcReserved_ortok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `OR'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_oftok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `OF'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_nottok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `NOT'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_moduletok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `MODULE'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_modtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `MOD'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_looptok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `LOOP'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_intok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `IN'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_importtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `IMPORT'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_implementationtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `IMPLEMENTATION'", 36), DynamicStrings_Mark (str));
        break;

      case mcReserved_iftok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `IF'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_fromtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `FROM'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_fortok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `FOR'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_finallytok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `FINALLY'", 29), DynamicStrings_Mark (str));
        break;

      case mcReserved_exporttok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `EXPORT'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_exittok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `EXIT'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_excepttok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `EXCEPT'", 28), DynamicStrings_Mark (str));
        break;

      case mcReserved_endtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `END'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_elsiftok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `ELSIF'", 27), DynamicStrings_Mark (str));
        break;

      case mcReserved_elsetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `ELSE'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_dotok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `DO'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_divtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `DIV'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_definitiontok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `DEFINITION'", 32), DynamicStrings_Mark (str));
        break;

      case mcReserved_consttok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `CONST'", 27), DynamicStrings_Mark (str));
        break;

      case mcReserved_casetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `CASE'", 26), DynamicStrings_Mark (str));
        break;

      case mcReserved_bytok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `BY'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_begintok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `BEGIN'", 27), DynamicStrings_Mark (str));
        break;

      case mcReserved_arraytok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `ARRAY'", 27), DynamicStrings_Mark (str));
        break;

      case mcReserved_andtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `AND'", 25), DynamicStrings_Mark (str));
        break;

      case mcReserved_colontok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `:'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_periodperiodtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `..'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_rdirectivetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `*>'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_ldirectivetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `<*'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_greaterequaltok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `>='", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_lessequaltok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `<='", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_lessgreatertok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `<>'", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_hashtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `#'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_equaltok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `='", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_uparrowtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `^'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_semicolontok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `;'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_commatok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `,'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_periodtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `.'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_ambersandtok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `&'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_dividetok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `/'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_timestok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `*'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_minustok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `-'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_plustok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `+'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_doublequotestok:
        str = DynamicStrings_ConCat (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_InitString ((char *) "syntax error, found '", 21), '"'), '\''), DynamicStrings_Mark (str));
        break;

      case mcReserved_singlequotetok:
        str = DynamicStrings_ConCat (DynamicStrings_ConCatChar (DynamicStrings_ConCatChar (DynamicStrings_InitString ((char *) "syntax error, found \"", 21), '\''), '"'), DynamicStrings_Mark (str));
        break;

      case mcReserved_greatertok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `>'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_lesstok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `<'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_rparatok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `)'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_lparatok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `('", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_rcbratok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `}'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_lcbratok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `{'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_rsbratok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `]'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_lsbratok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `['", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_bartok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `|'", 23), DynamicStrings_Mark (str));
        break;

      case mcReserved_becomestok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `:='", 24), DynamicStrings_Mark (str));
        break;

      case mcReserved_eoftok:
        str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error, found `'", 22), DynamicStrings_Mark (str));
        break;


      default:
        break;
    }
  ErrorString (str);
}


/*
   SyntaxError - after a syntax error we skip all tokens up until we reach
                 a stop symbol.
*/

static void SyntaxError (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  DescribeError (stopset0, stopset1, stopset2);
  if (Debugging)
    mcPrintf_printf0 ((char *) "\\nskipping token *** ", 21);
  /* 
      yes the ORD(currenttoken) looks ugly, but it is *much* safer than
      using currenttoken<sometok as a change to the ordering of the
      token declarations below would cause this to break. Using ORD() we are
      immune from such changes
  */
  while (! ((((((unsigned int) (mcLexBuf_currenttoken)) < 32) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & (stopset0)) != 0))) || (((((unsigned int) (mcLexBuf_currenttoken)) >= 32) && (((unsigned int) (mcLexBuf_currenttoken)) < 64)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & (stopset1)) != 0)))) || ((((unsigned int) (mcLexBuf_currenttoken)) >= 64) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & (stopset2)) != 0)))))
    mcLexBuf_getToken ();
  if (Debugging)
    mcPrintf_printf0 ((char *) " ***\\n", 6);
}


/*
   SyntaxCheck -
*/

static void SyntaxCheck (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  /* and again (see above re: ORD)
  */
  if (! ((((((unsigned int) (mcLexBuf_currenttoken)) < 32) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & (stopset0)) != 0))) || (((((unsigned int) (mcLexBuf_currenttoken)) >= 32) && (((unsigned int) (mcLexBuf_currenttoken)) < 64)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & (stopset1)) != 0)))) || ((((unsigned int) (mcLexBuf_currenttoken)) >= 64) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & (stopset2)) != 0)))))
    SyntaxError (stopset0, stopset1, stopset2);
}


/*
   WarnMissingToken - generates a warning message about a missing token, t.
*/

static void WarnMissingToken (mcReserved_toktype t)
{
  SetOfStop0 s0;
  SetOfStop1 s1;
  SetOfStop2 s2;
  DynamicStrings_String str;

  s0 = (SetOfStop0) 0;
  s1 = (SetOfStop1) 0;
  s2 = (SetOfStop2) 0;
  if (((unsigned int) (t)) < 32)
    s0 = (SetOfStop0) ((1 << (t-mcReserved_eoftok)));
  else if (((unsigned int) (t)) < 64)
    s1 = (SetOfStop1) ((1 << (t-mcReserved_arraytok)));
  else
    s2 = (SetOfStop2) ((1 << (t-mcReserved_recordtok)));
  str = DescribeStop (s0, s1, s2);
  str = DynamicStrings_ConCat (DynamicStrings_InitString ((char *) "syntax error,", 13), DynamicStrings_Mark (str));
  mcError_errorStringAt (str, mcLexBuf_getTokenNo ());
}


/*
   MissingToken - generates a warning message about a missing token, t.
*/

static void MissingToken (mcReserved_toktype t)
{
  WarnMissingToken (t);
  if ((((t != mcReserved_identtok) && (t != mcReserved_integertok)) && (t != mcReserved_realtok)) && (t != mcReserved_stringtok))
    {
      if (Debugging)
        mcPrintf_printf0 ((char *) "inserting token\\n", 17);
      mcLexBuf_insertToken (t);
    }
}


/*
   CheckAndInsert -
*/

static unsigned int CheckAndInsert (mcReserved_toktype t, SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((((((unsigned int) (t)) < 32) && ((((1 << (t-mcReserved_eoftok)) & (stopset0)) != 0))) || (((((unsigned int) (t)) >= 32) && (((unsigned int) (t)) < 64)) && ((((1 << (t-mcReserved_arraytok)) & (stopset1)) != 0)))) || ((((unsigned int) (t)) >= 64) && ((((1 << (t-mcReserved_recordtok)) & (stopset2)) != 0))))
    {
      WarnMissingToken (t);
      mcLexBuf_insertTokenAndRewind (t);
      return TRUE;
    }
  else
    return FALSE;
}


/*
   InStopSet
*/

static unsigned int InStopSet (mcReserved_toktype t, SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((((((unsigned int) (t)) < 32) && ((((1 << (t-mcReserved_eoftok)) & (stopset0)) != 0))) || (((((unsigned int) (t)) >= 32) && (((unsigned int) (t)) < 64)) && ((((1 << (t-mcReserved_arraytok)) & (stopset1)) != 0)))) || ((((unsigned int) (t)) >= 64) && ((((1 << (t-mcReserved_recordtok)) & (stopset2)) != 0))))
    return TRUE;
  else
    return FALSE;
}


/*
   PeepToken - peep token checks to see whether the stopset is satisfied by currenttoken
               If it is not then it will insert a token providing the token
               is one of ; ] ) } . OF END ,

               if the stopset contains <identtok> then we do not insert a token
*/

static void PeepToken (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  /* and again (see above re: ORD)
  */
  if ((! ((((((unsigned int) (mcLexBuf_currenttoken)) < 32) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & (stopset0)) != 0))) || (((((unsigned int) (mcLexBuf_currenttoken)) >= 32) && (((unsigned int) (mcLexBuf_currenttoken)) < 64)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & (stopset1)) != 0)))) || ((((unsigned int) (mcLexBuf_currenttoken)) >= 64) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & (stopset2)) != 0))))) && (! (InStopSet ((mcReserved_toktype) mcReserved_identtok, stopset0, stopset1, stopset2))))
    /* SyntaxCheck would fail since currentoken is not part of the stopset
         we check to see whether any of currenttoken might be a commonly omitted token  */
    if ((((((((CheckAndInsert ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2)) || (CheckAndInsert ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2))) || (CheckAndInsert ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2))) || (CheckAndInsert ((mcReserved_toktype) mcReserved_rcbratok, stopset0, stopset1, stopset2))) || (CheckAndInsert ((mcReserved_toktype) mcReserved_periodtok, stopset0, stopset1, stopset2))) || (CheckAndInsert ((mcReserved_toktype) mcReserved_oftok, stopset0, stopset1, stopset2))) || (CheckAndInsert ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2))) || (CheckAndInsert ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2)))
      {}  /* empty.  */
}


/*
   Expect -
*/

static void Expect (mcReserved_toktype t, SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == t)
    {
      /* avoid dangling else.  */
      mcLexBuf_getToken ();
      if (Pass1)
        PeepToken (stopset0, stopset1, stopset2);
    }
  else
    MissingToken (t);
  SyntaxCheck (stopset0, stopset1, stopset2);
}


/*
   Ident - error checking varient of Ident
*/

static void Ident (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  curident = nameKey_makekey (mcLexBuf_currentstring);
  Expect ((mcReserved_toktype) mcReserved_identtok, stopset0, stopset1, stopset2);
}


/*
   string -
*/

static void string (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  curstring = nameKey_makekey (mcLexBuf_currentstring);
  Expect ((mcReserved_toktype) mcReserved_stringtok, stopset0, stopset1, stopset2);
}


/*
   Integer -
*/

static void Integer (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_integertok, stopset0, stopset1, stopset2);
}


/*
   Real -
*/

static void Real (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_realtok, stopset0, stopset1, stopset2);
}


/*
   FileUnit := DefinitionModule  | ImplementationOrProgramModule 

   first  symbols:implementationtok, moduletok, definitiontok
   
   cannot reachend
*/

static void FileUnit (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_definitiontok)
    DefinitionModule (stopset0, stopset1, stopset2);
  else if (((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_implementationtok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))))) != 0)))
    ImplementationOrProgramModule (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: IMPLEMENTATION MODULE DEFINITION", 50);
}


/*
   ProgramModule := 'MODULE' Ident 
                    % curmodule := lookupModule (curident)  %
                    
                    % enterScope (curmodule)  %
                    
                    % resetEnumPos (curmodule)  %
                    [ Priority  ] ';' { Import  } Block Ident 
                    
                    % checkEndName (curmodule, curident, 'program module')  %
                    
                    % setConstExpComplete (curmodule)  %
                    
                    % leaveScope  %
                    '.' 

   first  symbols:moduletok
   
   cannot reachend
*/

static void ProgramModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_moduletok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2);
  curmodule = decl_lookupModule (curident);
  decl_enterScope (curmodule);
  decl_resetEnumPos (curmodule);
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    Priority (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
  while (((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok))))) != 0)))
    Import (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_typetok-mcReserved_recordtok))));
   /* while  */
  Block (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok))), stopset1, stopset2);
  checkEndName (curmodule, curident, (char *) "program module", 14);
  decl_setConstExpComplete (curmodule);
  decl_leaveScope ();
  Expect ((mcReserved_toktype) mcReserved_periodtok, stopset0, stopset1, stopset2);
}


/*
   ImplementationModule := 'IMPLEMENTATION' 'MODULE' Ident 
                           % curmodule := lookupImp (curident)  %
                           
                           % enterScope (lookupDef (curident))  %
                           
                           % enterScope (curmodule)  %
                           
                           % resetEnumPos (curmodule)  %
                           [ Priority  ] ';' { Import  } Block 
                           Ident 
                           % checkEndName (curmodule, curident, 'implementation module')  %
                           
                           % setConstExpComplete (curmodule)  %
                           
                           % leaveScope ; leaveScope  %
                           '.' 

   first  symbols:implementationtok
   
   cannot reachend
*/

static void ImplementationModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_implementationtok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_moduletok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2);
  curmodule = decl_lookupImp (curident);
  decl_enterScope (decl_lookupDef (curident));
  decl_enterScope (curmodule);
  decl_resetEnumPos (curmodule);
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    Priority (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
  while (((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok))))) != 0)))
    Import (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_typetok-mcReserved_recordtok))));
   /* while  */
  Block (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok))), stopset1, stopset2);
  checkEndName (curmodule, curident, (char *) "implementation module", 21);
  decl_setConstExpComplete (curmodule);
  decl_leaveScope ();
  decl_leaveScope ();
  Expect ((mcReserved_toktype) mcReserved_periodtok, stopset0, stopset1, stopset2);
}


/*
   ImplementationOrProgramModule := ImplementationModule  | 
                                    ProgramModule 

   first  symbols:moduletok, implementationtok
   
   cannot reachend
*/

static void ImplementationOrProgramModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_implementationtok)
    ImplementationModule (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_moduletok)
    ProgramModule (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: MODULE IMPLEMENTATION", 39);
}


/*
   Number := Integer  | Real 

   first  symbols:realtok, integertok
   
   cannot reachend
*/

static void Number (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_integertok)
    Integer (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_realtok)
    Real (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: real number integer number", 44);
}


/*
   Qualident := Ident { '.' Ident  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void Qualident (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_periodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   ConstantDeclaration := 
                          % VAR d, e: node ;  %
                          Ident 
                          % d := lookupSym (curident)  %
                          '=' ConstExpression 
                          % e := pop ()  %
                          
                          % assert (isConst (d))  %
                          
                          % putConst (d, e)  %
                          

   first  symbols:identtok
   
   cannot reachend
*/

static void ConstantDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node d;
  decl_node e;

  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_equaltok-mcReserved_eoftok))), stopset1, stopset2);
  d = decl_lookupSym (curident);
  Expect ((mcReserved_toktype) mcReserved_equaltok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
  ConstExpression (stopset0, stopset1, stopset2);
  e = pop ();
  mcDebug_assert (decl_isConst (d));
  decl_putConst (d, e);
}


/*
   ConstExpressionNop := SimpleConstExpr 
                         % VAR n: node ;  %
                         [ Relation SimpleConstExpr  ] 
                         % n := makeConstExp ()  %
                         

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void ConstExpressionNop (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  SimpleConstExpr (stopset0|(SetOfStop0) ((1 << (mcReserved_greaterequaltok-mcReserved_eoftok)) | (1 << (mcReserved_greatertok-mcReserved_eoftok)) | (1 << (mcReserved_lessequaltok-mcReserved_eoftok)) | (1 << (mcReserved_lesstok-mcReserved_eoftok)) | (1 << (mcReserved_lessgreatertok-mcReserved_eoftok)) | (1 << (mcReserved_hashtok-mcReserved_eoftok)) | (1 << (mcReserved_equaltok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_intok-mcReserved_arraytok))), stopset2);
  if (((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_equaltok-mcReserved_eoftok)) | (1 << (mcReserved_hashtok-mcReserved_eoftok)) | (1 << (mcReserved_lessgreatertok-mcReserved_eoftok)) | (1 << (mcReserved_lesstok-mcReserved_eoftok)) | (1 << (mcReserved_lessequaltok-mcReserved_eoftok)) | (1 << (mcReserved_greatertok-mcReserved_eoftok)) | (1 << (mcReserved_greaterequaltok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_intok))
    {
      Relation (stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      SimpleConstExpr (stopset0, stopset1, stopset2);
    }
  n = decl_makeConstExp ();
}


/*
   ConstExpression := 
                      % VAR n: node ;  %
                      
                      % n := push (makeConstExp ())  %
                      SimpleConstExpr [ Relation SimpleConstExpr  ] 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void ConstExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  n = push (decl_makeConstExp ());
  SimpleConstExpr (stopset0|(SetOfStop0) ((1 << (mcReserved_greaterequaltok-mcReserved_eoftok)) | (1 << (mcReserved_greatertok-mcReserved_eoftok)) | (1 << (mcReserved_lessequaltok-mcReserved_eoftok)) | (1 << (mcReserved_lesstok-mcReserved_eoftok)) | (1 << (mcReserved_lessgreatertok-mcReserved_eoftok)) | (1 << (mcReserved_hashtok-mcReserved_eoftok)) | (1 << (mcReserved_equaltok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_intok-mcReserved_arraytok))), stopset2);
  if (((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_equaltok-mcReserved_eoftok)) | (1 << (mcReserved_hashtok-mcReserved_eoftok)) | (1 << (mcReserved_lessgreatertok-mcReserved_eoftok)) | (1 << (mcReserved_lesstok-mcReserved_eoftok)) | (1 << (mcReserved_lessequaltok-mcReserved_eoftok)) | (1 << (mcReserved_greatertok-mcReserved_eoftok)) | (1 << (mcReserved_greaterequaltok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_intok))
    {
      Relation (stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      SimpleConstExpr (stopset0, stopset1, stopset2);
    }
}


/*
   Relation := '='  | '#'  | '<>'  | '<'  | '<='  | '>'  | 
               '>='  | 'IN' 

   first  symbols:intok, greaterequaltok, greatertok, lessequaltok, lesstok, lessgreatertok, hashtok, equaltok
   
   cannot reachend
*/

static void Relation (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_equaltok)
    Expect ((mcReserved_toktype) mcReserved_equaltok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_hashtok)
    Expect ((mcReserved_toktype) mcReserved_hashtok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lessgreatertok)
    Expect ((mcReserved_toktype) mcReserved_lessgreatertok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lesstok)
    Expect ((mcReserved_toktype) mcReserved_lesstok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lessequaltok)
    Expect ((mcReserved_toktype) mcReserved_lessequaltok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_greatertok)
    Expect ((mcReserved_toktype) mcReserved_greatertok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_greaterequaltok)
    Expect ((mcReserved_toktype) mcReserved_greaterequaltok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_intok)
    Expect ((mcReserved_toktype) mcReserved_intok, stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: IN >= > <= < <> # =", 37);
}


/*
   SimpleConstExpr := UnaryOrConstTerm { AddOperator ConstTerm  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void SimpleConstExpr (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  UnaryOrConstTerm (stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_ortok-mcReserved_arraytok))), stopset2);
  while (((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_ortok))
    {
      AddOperator (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      ConstTerm (stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_ortok-mcReserved_arraytok))), stopset2);
    }
   /* while  */
}


/*
   UnaryOrConstTerm := '+' ConstTerm  | '-' ConstTerm  | 
                       ConstTerm 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void UnaryOrConstTerm (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_plustok)
    {
      Expect ((mcReserved_toktype) mcReserved_plustok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      ConstTerm (stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_minustok)
    {
      Expect ((mcReserved_toktype) mcReserved_minustok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      ConstTerm (stopset0, stopset1, stopset2);
    }
  else if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))))) != 0))))
    ConstTerm (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: NOT ( integer number real number __ATTRIBUTE__ identifier { string - +", 88);
}


/*
   AddOperator := '+'  | '-'  | 'OR' 

   first  symbols:ortok, minustok, plustok
   
   cannot reachend
*/

static void AddOperator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_plustok)
    Expect ((mcReserved_toktype) mcReserved_plustok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_minustok)
    Expect ((mcReserved_toktype) mcReserved_minustok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_ortok)
    Expect ((mcReserved_toktype) mcReserved_ortok, stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: OR - +", 24);
}


/*
   ConstTerm := ConstFactor { MulOperator ConstFactor  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok
   
   cannot reachend
*/

static void ConstTerm (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ConstFactor (stopset0|(SetOfStop0) ((1 << (mcReserved_ambersandtok-mcReserved_eoftok)) | (1 << (mcReserved_andtok-mcReserved_eoftok)) | (1 << (mcReserved_dividetok-mcReserved_eoftok)) | (1 << (mcReserved_timestok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_modtok-mcReserved_arraytok)) | (1 << (mcReserved_divtok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_remtok-mcReserved_recordtok))));
  while ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_timestok-mcReserved_eoftok)) | (1 << (mcReserved_dividetok-mcReserved_eoftok)) | (1 << (mcReserved_andtok-mcReserved_eoftok)) | (1 << (mcReserved_ambersandtok-mcReserved_eoftok))))) != 0))) || (((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_divtok-mcReserved_arraytok)) | (1 << (mcReserved_modtok-mcReserved_arraytok))))) != 0)))) || (mcLexBuf_currenttoken == mcReserved_remtok))
    {
      MulOperator (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstFactor (stopset0|(SetOfStop0) ((1 << (mcReserved_timestok-mcReserved_eoftok)) | (1 << (mcReserved_dividetok-mcReserved_eoftok)) | (1 << (mcReserved_andtok-mcReserved_eoftok)) | (1 << (mcReserved_ambersandtok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_divtok-mcReserved_arraytok)) | (1 << (mcReserved_modtok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_remtok-mcReserved_recordtok))));
    }
   /* while  */
}


/*
   MulOperator := '*'  | '/'  | 'DIV'  | 'MOD'  | 'REM'  | 
                  'AND'  | '&' 

   first  symbols:ambersandtok, andtok, remtok, modtok, divtok, dividetok, timestok
   
   cannot reachend
*/

static void MulOperator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_timestok)
    Expect ((mcReserved_toktype) mcReserved_timestok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_dividetok)
    Expect ((mcReserved_toktype) mcReserved_dividetok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_divtok)
    Expect ((mcReserved_toktype) mcReserved_divtok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_modtok)
    Expect ((mcReserved_toktype) mcReserved_modtok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_remtok)
    Expect ((mcReserved_toktype) mcReserved_remtok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_andtok)
    Expect ((mcReserved_toktype) mcReserved_andtok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_ambersandtok)
    Expect ((mcReserved_toktype) mcReserved_ambersandtok, stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: & AND REM MOD DIV / *", 39);
}


/*
   ConstFactor := Number  | ConstString  | ConstSetOrQualidentOrFunction  | 
                  '(' ConstExpressionNop ')'  | 
                  'NOT' ConstFactor  | ConstAttribute 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok
   
   cannot reachend
*/

static void ConstFactor (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok))))) != 0)))
    Number (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_stringtok)
    ConstString (stopset0, stopset1, stopset2);
  else if ((mcLexBuf_currenttoken == mcReserved_lcbratok) || (mcLexBuf_currenttoken == mcReserved_identtok))
    ConstSetOrQualidentOrFunction (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lparatok)
    {
      Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_nottok)
    {
      Expect ((mcReserved_toktype) mcReserved_nottok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstFactor (stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_attributetok)
    ConstAttribute (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: __ATTRIBUTE__ NOT ( identifier { string integer number real number", 84);
}


/*
   ConstString := string 

   first  symbols:stringtok
   
   cannot reachend
*/

static void ConstString (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  string (stopset0, stopset1, stopset2);
}


/*
   ComponentElement := ConstExpressionNop [ '..' ConstExpressionNop  ] 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ComponentElement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_periodperiodtok-mcReserved_eoftok))), stopset1, stopset2);
  if (mcLexBuf_currenttoken == mcReserved_periodperiodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodperiodtok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpressionNop (stopset0, stopset1, stopset2);
    }
}


/*
   ComponentValue := ComponentElement [ 'BY' ConstExpressionNop  ] 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void ComponentValue (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ComponentElement (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_bytok-mcReserved_arraytok))), stopset2);
  if (mcLexBuf_currenttoken == mcReserved_bytok)
    {
      Expect ((mcReserved_toktype) mcReserved_bytok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpressionNop (stopset0, stopset1, stopset2);
    }
}


/*
   ArraySetRecordValue := ComponentValue { ',' ComponentValue  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ArraySetRecordValue (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ComponentValue (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ComponentValue (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   Constructor := '{' [ ArraySetRecordValue  ] '}' 

   first  symbols:lcbratok
   
   cannot reachend
*/

static void Constructor (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lcbratok, stopset0|(SetOfStop0) ((1 << (mcReserved_rcbratok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
  if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))))) != 0))))
    ArraySetRecordValue (stopset0|(SetOfStop0) ((1 << (mcReserved_rcbratok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rcbratok, stopset0, stopset1, stopset2);
}


/*
   ConstSetOrQualidentOrFunction := Qualident [ Constructor  | 
                                                ConstActualParameters  ]  | 
                                    Constructor 

   first  symbols:lcbratok, identtok
   
   cannot reachend
*/

static void ConstSetOrQualidentOrFunction (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_identtok)
    {
      /* avoid dangling else.  */
      Qualident (stopset0|(SetOfStop0) ((1 << (mcReserved_lcbratok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
      if ((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* seen optional [ | ] expression  */
          if (mcLexBuf_currenttoken == mcReserved_lcbratok)
            Constructor (stopset0, stopset1, stopset2);
          else if (mcLexBuf_currenttoken == mcReserved_lparatok)
            ConstActualParameters (stopset0, stopset1, stopset2);
          else
            ErrorArray ((char *) "expecting one of: ( {", 21);
        }
      /* end of optional [ | ] expression  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_lcbratok)
    Constructor (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: { identifier", 30);
}


/*
   ConstActualParameters := '(' [ ConstExpList  ] ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void ConstActualParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
  if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))))) != 0))))
    ConstExpList (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   ConstExpList := ConstExpressionNop { ',' ConstExpressionNop  } 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ConstExpList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   ConstAttribute := '__ATTRIBUTE__' '__BUILTIN__' '(' '(' ConstAttributeExpression 
                     ')' ')' 

   first  symbols:attributetok
   
   cannot reachend
*/

static void ConstAttribute (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_attributetok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_builtintok-mcReserved_recordtok))));
  Expect ((mcReserved_toktype) mcReserved_builtintok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_lesstok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  ConstAttributeExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   ConstAttributeExpression := Ident  | '<' Qualident ',' Ident 
                               '>' 

   first  symbols:lesstok, identtok
   
   cannot reachend
*/

static void ConstAttributeExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_identtok)
    Ident (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lesstok)
    {
      Expect ((mcReserved_toktype) mcReserved_lesstok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Qualident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_greatertok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_greatertok, stopset0, stopset1, stopset2);
    }
  else
    ErrorArray ((char *) "expecting one of: < identifier", 30);
}


/*
   ByteAlignment := '' 

   first  symbols:ldirectivetok
   
   cannot reachend
*/

static void ByteAlignment (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_ldirectivetok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  AttributeExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rdirectivetok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rdirectivetok, stopset0, stopset1, stopset2);
}


/*
   OptAlignmentExpression := [ AlignmentExpression  ] 

   first  symbols:lparatok
   
   reachend
*/

static void OptAlignmentExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_lparatok)
    AlignmentExpression (stopset0, stopset1, stopset2);
}


/*
   AlignmentExpression := '(' ConstExpressionNop ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void AlignmentExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
  ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   Alignment := [ ByteAlignment  ] 

   first  symbols:ldirectivetok
   
   reachend
*/

static void Alignment (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_ldirectivetok)
    ByteAlignment (stopset0, stopset1, stopset2);
}


/*
   IdentList := Ident { ',' Ident  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void IdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   PushIdentList := 
                    % VAR n: node ;  %
                    
                    % n := makeIdentList ()  %
                    Ident 
                    % checkDuplicate (putIdent (n, curident))  %
                    { ',' Ident 
                      % checkDuplicate (putIdent (n, curident))  %
                       } 
                    % n := push (n)  %
                    

   first  symbols:identtok
   
   cannot reachend
*/

static void PushIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  n = decl_makeIdentList ();
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  checkDuplicate (decl_putIdent (n, curident));
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
      checkDuplicate (decl_putIdent (n, curident));
    }
   /* while  */
  n = push (n);
}


/*
   SubrangeType := 
                   % VAR low, high: node ; d: CARDINAL ;  %
                   '[' 
                   % d := depth ()  %
                   ConstExpression 
                   % low := pop ()  %
                   
                   % assert (d = depth ())  %
                   '..' ConstExpression 
                   % high := pop ()  %
                   
                   % assert (d = depth ())  %
                   
                   % typeExp := push (makeSubrange (low, high))  %
                   
                   % assert (d = depth () - 1)  %
                   ']' 

   first  symbols:lsbratok
   
   cannot reachend
*/

static void SubrangeType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node low;
  decl_node high;
  unsigned int d;

  Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
  d = depth ();
  ConstExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_periodperiodtok-mcReserved_eoftok))), stopset1, stopset2);
  low = pop ();
  mcDebug_assert (d == (depth ()));
  Expect ((mcReserved_toktype) mcReserved_periodperiodtok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
  ConstExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
  high = pop ();
  mcDebug_assert (d == (depth ()));
  typeExp = push (decl_makeSubrange (low, high));
  mcDebug_assert (d == ((depth ())-1));
  Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
}


/*
   ArrayType := 'ARRAY' 
                % VAR c: CARDINAL ; t, n: node ;  %
                
                % c := 0  %
                SimpleType 
                % INC (c)  %
                { ',' SimpleType 
                  % INC (c)  %
                   } 'OF' Type 
                % n := push (makeIndexedArray (c, pop ()))  %
                

   first  symbols:arraytok
   
   cannot reachend
*/

static void ArrayType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  unsigned int c;
  decl_node t;
  decl_node n;

  Expect ((mcReserved_toktype) mcReserved_arraytok, stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  c = 0;
  SimpleType (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2);
  c += 1;
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      SimpleType (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2);
      c += 1;
    }
   /* while  */
  Expect ((mcReserved_toktype) mcReserved_oftok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_pointertok-mcReserved_arraytok)) | (1 << (mcReserved_packedsettok-mcReserved_arraytok)) | (1 << (mcReserved_oftok-mcReserved_arraytok)) | (1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_settok-mcReserved_recordtok)) | (1 << (mcReserved_recordtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Type (stopset0, stopset1, stopset2);
  n = push (makeIndexedArray (c, pop ()));
}


/*
   RecordType := 'RECORD' 
                 % VAR n: node ;  %
                 
                 % n := push (makeRecord ())  %
                 
                 % n := push (NIL)     no varient   %
                 [ DefaultRecordAttributes  ] FieldListSequence 
                 
                 % assert (pop ()=NIL)  %
                 'END' 

   first  symbols:recordtok
   
   cannot reachend
*/

static void RecordType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  Expect ((mcReserved_toktype) mcReserved_recordtok, stopset0|(SetOfStop0) ((1 << (mcReserved_ldirectivetok-mcReserved_eoftok)) | (1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  n = push (decl_makeRecord ());
  n = push ((decl_node) NULL);  /* no varient  */
  if (mcLexBuf_currenttoken == mcReserved_ldirectivetok)
    DefaultRecordAttributes (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  FieldListSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  mcDebug_assert ((pop ()) == NULL);
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   DefaultRecordAttributes := '' 

   first  symbols:ldirectivetok
   
   cannot reachend
*/

static void DefaultRecordAttributes (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_ldirectivetok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  AttributeExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rdirectivetok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rdirectivetok, stopset0, stopset1, stopset2);
}


/*
   RecordFieldPragma := [ ''  ] 

   first  symbols:ldirectivetok
   
   reachend
*/

static void RecordFieldPragma (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_ldirectivetok)
    {
      Expect ((mcReserved_toktype) mcReserved_ldirectivetok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      FieldPragmaExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok)) | (1 << (mcReserved_rdirectivetok-mcReserved_eoftok))), stopset1, stopset2);
      while (mcLexBuf_currenttoken == mcReserved_commatok)
        {
          Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
          FieldPragmaExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rdirectivetok-mcReserved_eoftok)) | (1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
        }
       /* while  */
      Expect ((mcReserved_toktype) mcReserved_rdirectivetok, stopset0, stopset1, stopset2);
    }
}


/*
   FieldPragmaExpression := Ident PragmaConstExpression 

   first  symbols:identtok
   
   cannot reachend
*/

static void FieldPragmaExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  PragmaConstExpression (stopset0, stopset1, stopset2);
}


/*
   PragmaConstExpression := [ '(' ConstExpressionNop ')'  ] 

   first  symbols:lparatok
   
   reachend
*/

static void PragmaConstExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_lparatok)
    {
      Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
    }
}


/*
   AttributeExpression := Ident '(' ConstExpressionNop ')' 

   first  symbols:identtok
   
   cannot reachend
*/

static void AttributeExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
  ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   FieldListSequence := FieldListStatement { ';' FieldListStatement  } 

   first  symbols:casetok, identtok, semicolontok
   
   reachend
*/

static void FieldListSequence (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  FieldListStatement (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_semicolontok)
    {
      Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_casetok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      FieldListStatement (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   FieldListStatement := [ FieldList  ] 

   first  symbols:identtok, casetok
   
   reachend
*/

static void FieldListStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken == mcReserved_casetok) || (mcLexBuf_currenttoken == mcReserved_identtok))
    FieldList (stopset0, stopset1, stopset2);
}


/*
   FieldList := 
                % VAR r, i, f, t, n, v, w: node ; d: CARDINAL ;  %
                
                % d := depth ()  %
                
                % v := pop () ; assert ((v=NIL) OR isVarient (v))  %
                
                % r := peep () ; assert (isRecord (r) OR isVarientField (r))  %
                
                % v := push (v)  %
                
                % assert (d=depth ())  %
                
                % assert (((v=NIL) AND isRecord (r)) OR ((v#NIL) AND isVarientField (r)))  %
                PushIdentList ':' 
                % assert (d=depth () - 1)  %
                
                % i := pop ()  %
                Type 
                % assert (d=depth () - 1)  %
                
                % t := pop ()  %
                RecordFieldPragma 
                % assert (d=depth ())  %
                
                % r := addFieldsToRecord (r, v, i, t)  %
                
                % assert (d=depth ())  %
                 | 'CASE' 
                %  addRecordToList   %
                
                % d := depth ()  %
                
                % v := pop () ; assert ((v=NIL) OR isVarient (v))  %
                
                % r := peep () ; assert (isRecord (r) OR isVarientField (r))  %
                
                % v := push (v)  %
                
                % assert (((v=NIL) AND isRecord (r)) OR ((v#NIL) AND isRecordField (r)))  %
                
                % w := push (makeVarient (r))  %
                
                % assert (d = depth () - 1)  %
                
                %  addVarientToList   %
                CaseTag 'OF' 
                % assert (d = depth () - 1)  %
                Varient 
                % assert (d = depth () - 1)  %
                { '|' Varient 
                  % assert (d = depth () - 1)  %
                   } 
                % w := peep () ; assert (isVarient (w))  %
                
                % assert (d = depth () - 1)  %
                [ 'ELSE' FieldListSequence  ] 'END' 
                % w := pop () ; assert (isVarient (w))  %
                
                % assert (d=depth ())  %
                

   first  symbols:casetok, identtok
   
   cannot reachend
*/

static void FieldList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node r;
  decl_node i;
  decl_node f;
  decl_node t;
  decl_node n;
  decl_node v;
  decl_node w;
  unsigned int d;

  if (mcLexBuf_currenttoken == mcReserved_identtok)
    {
      d = depth ();
      v = pop ();
      mcDebug_assert ((v == NULL) || (decl_isVarient (v)));
      r = peep ();
      mcDebug_assert ((decl_isRecord (r)) || (decl_isVarientField (r)));
      v = push (v);
      mcDebug_assert (d == (depth ()));
      mcDebug_assert (((v == NULL) && (decl_isRecord (r))) || ((v != NULL) && (decl_isVarientField (r))));
      PushIdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_pointertok-mcReserved_arraytok)) | (1 << (mcReserved_packedsettok-mcReserved_arraytok)) | (1 << (mcReserved_oftok-mcReserved_arraytok)) | (1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_settok-mcReserved_recordtok)) | (1 << (mcReserved_recordtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      mcDebug_assert (d == ((depth ())-1));
      i = pop ();
      Type (stopset0|(SetOfStop0) ((1 << (mcReserved_ldirectivetok-mcReserved_eoftok))), stopset1, stopset2);
      mcDebug_assert (d == ((depth ())-1));
      t = pop ();
      RecordFieldPragma (stopset0, stopset1, stopset2);
      mcDebug_assert (d == (depth ()));
      r = decl_addFieldsToRecord (r, v, i, t);
      mcDebug_assert (d == (depth ()));
    }
  else if (mcLexBuf_currenttoken == mcReserved_casetok)
    {
      Expect ((mcReserved_toktype) mcReserved_casetok, stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      /* addRecordToList  */
      d = depth ();
      v = pop ();
      mcDebug_assert ((v == NULL) || (decl_isVarient (v)));
      r = peep ();
      mcDebug_assert ((decl_isRecord (r)) || (decl_isVarientField (r)));
      v = push (v);
      mcDebug_assert (((v == NULL) && (decl_isRecord (r))) || ((v != NULL) && (decl_isRecordField (r))));
      w = push (decl_makeVarient (r));
      mcDebug_assert (d == ((depth ())-1));
      /* addVarientToList  */
      CaseTag (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2);
      Expect ((mcReserved_toktype) mcReserved_oftok, stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      mcDebug_assert (d == ((depth ())-1));
      Varient (stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
      mcDebug_assert (d == ((depth ())-1));
      while (mcLexBuf_currenttoken == mcReserved_bartok)
        {
          Expect ((mcReserved_toktype) mcReserved_bartok, stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
          Varient (stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok))), stopset2);
          mcDebug_assert (d == ((depth ())-1));
        }
       /* while  */
      w = peep ();
      mcDebug_assert (decl_isVarient (w));
      mcDebug_assert (d == ((depth ())-1));
      if (mcLexBuf_currenttoken == mcReserved_elsetok)
        {
          Expect ((mcReserved_toktype) mcReserved_elsetok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
          FieldListSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
        }
      Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
      w = pop ();
      mcDebug_assert (decl_isVarient (w));
      mcDebug_assert (d == (depth ()));
    }
  else
    ErrorArray ((char *) "expecting one of: CASE identifier", 33);
}


/*
   TagIdent := Ident  | 
               % curident := NulName  %
               

   first  symbols:identtok
   
   reachend
*/

static void TagIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_identtok)
    Ident (stopset0, stopset1, stopset2);
  else
    curident = nameKey_NulName;
}


/*
   CaseTag := 
              % VAR tagident: Name ; q, v, w, r: node ;  %
              
              % w := pop () ; v := pop () ; r := peep () ; v := push (v) ; w := push (w)  %
              
              % assert (isVarient (w))  %
              
              % assert ((v=NIL) OR isVarient (v))  %
              
              % assert (isRecord (r) OR isVarientField (r))  %
              
              % assert (isVarient (push (pop ())))  %
              TagIdent 
              % tagident := curident  %
              ( ':' PushQualident 
                % q := pop ()  %
                
                % assert (isVarient (push (pop ())))  %
                 | 
                % q := NIL  %
                 ) 
              % buildVarientSelector (r, w, tagident, q)  %
              

   first  symbols:colontok, identtok
   
   reachend
*/

static void CaseTag (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  nameKey_Name tagident;
  decl_node q;
  decl_node v;
  decl_node w;
  decl_node r;

  w = pop ();
  v = pop ();
  r = peep ();
  v = push (v);
  w = push (w);
  mcDebug_assert (decl_isVarient (w));
  mcDebug_assert ((v == NULL) || (decl_isVarient (v)));
  mcDebug_assert ((decl_isRecord (r)) || (decl_isVarientField (r)));
  mcDebug_assert (decl_isVarient (push (pop ())));
  TagIdent (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  tagident = curident;
  if (mcLexBuf_currenttoken == mcReserved_colontok)
    {
      Expect ((mcReserved_toktype) mcReserved_colontok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      PushQualident (stopset0, stopset1, stopset2);
      q = pop ();
      mcDebug_assert (decl_isVarient (push (pop ())));
    }
  else
    q = NULL;
  decl_buildVarientSelector (r, w, tagident, q);
}


/*
   Varient := 
              % VAR p, r, v, f: node ; d: CARDINAL ;  %
              
              % d := depth ()  %
              
              % assert (isVarient (peep ()))  %
              [ 
                % v := pop () ; assert (isVarient (v))  %
                
                % r := pop ()  %
                
                % p := peep ()  %
                
                % r := push (r)  %
                
                % f := push (buildVarientFieldRecord (v, p))  %
                
                % v := push (v)  %
                VarientCaseLabelList ':' FieldListSequence 
                % v := pop ()  %
                
                % f := pop ()  %
                
                % assert (isVarientField (f))  %
                
                % assert (isVarient (v))  %
                
                % v := push (v)  %
                 ] 
              % assert (isVarient (peep ()))  %
              
              % assert (d=depth ())  %
              

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   reachend
*/

static void Varient (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node p;
  decl_node r;
  decl_node v;
  decl_node f;
  unsigned int d;

  d = depth ();
  mcDebug_assert (decl_isVarient (peep ()));
  if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))))) != 0))))
    {
      v = pop ();
      mcDebug_assert (decl_isVarient (v));
      r = pop ();
      p = peep ();
      r = push (r);
      f = push (decl_buildVarientFieldRecord (v, p));
      v = push (v);
      VarientCaseLabelList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_casetok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      FieldListSequence (stopset0, stopset1, stopset2);
      v = pop ();
      f = pop ();
      mcDebug_assert (decl_isVarientField (f));
      mcDebug_assert (decl_isVarient (v));
      v = push (v);
    }
  mcDebug_assert (decl_isVarient (peep ()));
  mcDebug_assert (d == (depth ()));
}


/*
   VarientCaseLabelList := VarientCaseLabels { ',' VarientCaseLabels  } 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void VarientCaseLabelList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  VarientCaseLabels (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      VarientCaseLabels (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   VarientCaseLabels := 
                        % VAR l, h: node ;  %
                        
                        % h := NIL  %
                        ConstExpression 
                        % l := pop ()  %
                        [ '..' ConstExpression 
                          % h := pop ()  %
                           ] 
                        %  l, h  could be saved if necessary.    %
                        

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void VarientCaseLabels (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node l;
  decl_node h;

  h = NULL;
  ConstExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_periodperiodtok-mcReserved_eoftok))), stopset1, stopset2);
  l = pop ();
  if (mcLexBuf_currenttoken == mcReserved_periodperiodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodperiodtok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpression (stopset0, stopset1, stopset2);
      h = pop ();
    }
}


/*
   SetType := ( 'SET'  | 'PACKEDSET'  ) 'OF' SimpleType 
              % VAR n: node ;  %
              
              % n := push (makeSet (pop ()))  %
              

   first  symbols:oftok, packedsettok, settok
   
   cannot reachend
*/

static void SetType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  if (mcLexBuf_currenttoken == mcReserved_settok)
    Expect ((mcReserved_toktype) mcReserved_settok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_packedsettok)
    Expect ((mcReserved_toktype) mcReserved_packedsettok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2);
  else
    ErrorArray ((char *) "expecting one of: PACKEDSET SET", 31);
  Expect ((mcReserved_toktype) mcReserved_oftok, stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  SimpleType (stopset0, stopset1, stopset2);
  n = push (decl_makeSet (pop ()));
}


/*
   PointerType := 'POINTER' 'TO' Type 
                  % VAR n: node ;  %
                  
                  % n := push (makePointer (pop ()))  %
                  

   first  symbols:pointertok
   
   cannot reachend
*/

static void PointerType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  Expect ((mcReserved_toktype) mcReserved_pointertok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_totok-mcReserved_recordtok))));
  Expect ((mcReserved_toktype) mcReserved_totok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_pointertok-mcReserved_arraytok)) | (1 << (mcReserved_packedsettok-mcReserved_arraytok)) | (1 << (mcReserved_oftok-mcReserved_arraytok)) | (1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_settok-mcReserved_recordtok)) | (1 << (mcReserved_recordtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Type (stopset0, stopset1, stopset2);
  n = push (decl_makePointer (pop ()));
}


/*
   ProcedureType := 'PROCEDURE' 
                    % curproc := push (makeProcType ())  %
                    [ FormalTypeList  ] 

   first  symbols:proceduretok
   
   cannot reachend
*/

static void ProcedureType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_proceduretok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  curproc = push (decl_makeProcType ());
  if (mcLexBuf_currenttoken == mcReserved_lparatok)
    FormalTypeList (stopset0, stopset1, stopset2);
}


/*
   FormalTypeList := '(' ( ')' FormalReturn  | 
                           ProcedureParameters ')' FormalReturn  ) 

   first  symbols:lparatok
   
   cannot reachend
*/

static void FormalTypeList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  if (mcLexBuf_currenttoken == mcReserved_rparatok)
    {
      Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
      FormalReturn (stopset0, stopset1, stopset2);
    }
  else if ((mcLexBuf_currenttoken == mcReserved_arraytok) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
    {
      ProcedureParameters (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
      FormalReturn (stopset0, stopset1, stopset2);
    }
  else
    ErrorArray ((char *) "expecting one of: VAR ... ARRAY identifier )", 44);
}


/*
   FormalReturn := [ ':' OptReturnType  ] 

   first  symbols:colontok
   
   reachend
*/

static void FormalReturn (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_colontok)
    {
      Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      OptReturnType (stopset0, stopset1, stopset2);
    }
}


/*
   OptReturnType := '[' PushQualident 
                    % putReturnType (curproc, pop ())  %
                    
                    % putOptReturn (curproc)  %
                    ']'  | PushQualident 
                    % putReturnType (curproc, pop ())  %
                    

   first  symbols:identtok, lsbratok
   
   cannot reachend
*/

static void OptReturnType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    {
      Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      PushQualident (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
      decl_putReturnType (curproc, pop ());
      decl_putOptReturn (curproc);
      Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_identtok)
    {
      PushQualident (stopset0, stopset1, stopset2);
      decl_putReturnType (curproc, pop ());
    }
  else
    ErrorArray ((char *) "expecting one of: identifier [", 30);
}


/*
   ProcedureParameters := ProcedureParameter 
                          % addParameter (curproc, pop ())  %
                          { ',' ProcedureParameter 
                            % addParameter (curproc, pop ())  %
                             } 

   first  symbols:identtok, arraytok, periodperiodperiodtok, vartok
   
   cannot reachend
*/

static void ProcedureParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ProcedureParameter (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  decl_addParameter (curproc, pop ());
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      ProcedureParameter (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
      decl_addParameter (curproc, pop ());
    }
   /* while  */
}


/*
   ProcedureParameter := '...' 
                         % VAR n: node ;  %
                         
                         % n := push (makeVarargs ())  %
                          | 'VAR' FormalType 
                         % n := push (makeVarParameter (NIL, pop (), curproc))  %
                          | FormalType 
                         % n := push (makeNonVarParameter (NIL, pop (), curproc))  %
                         

   first  symbols:identtok, arraytok, vartok, periodperiodperiodtok
   
   cannot reachend
*/

static void ProcedureParameter (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  if (mcLexBuf_currenttoken == mcReserved_periodperiodperiodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodperiodperiodtok, stopset0, stopset1, stopset2);
      n = push (decl_makeVarargs ());
    }
  else if (mcLexBuf_currenttoken == mcReserved_vartok)
    {
      Expect ((mcReserved_toktype) mcReserved_vartok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      FormalType (stopset0, stopset1, stopset2);
      n = push (decl_makeVarParameter ((decl_node) NULL, pop (), curproc));
    }
  else if ((mcLexBuf_currenttoken == mcReserved_arraytok) || (mcLexBuf_currenttoken == mcReserved_identtok))
    {
      FormalType (stopset0, stopset1, stopset2);
      n = push (decl_makeNonVarParameter ((decl_node) NULL, pop (), curproc));
    }
  else
    ErrorArray ((char *) "expecting one of: ARRAY identifier VAR ...", 42);
}


/*
   VarIdent := 
               % VAR n, a: node ;  %
               
               % n := pop ()  %
               Ident 
               % checkDuplicate (putIdent (n, curident))  %
               
               % n := push (n)  %
               [ '[' ConstExpression 
                 % a := pop ()   could store, a, into, n.    %
                 ']'  ] 

   first  symbols:identtok
   
   cannot reachend
*/

static void VarIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;
  decl_node a;

  n = pop ();
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2);
  checkDuplicate (decl_putIdent (n, curident));
  n = push (n);
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    {
      Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
      a = pop ();  /* could store, a, into, n.  */
      Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
    }
}


/*
   VarIdentList := 
                   % VAR n: node ;  %
                   
                   % n := makeIdentList ()  %
                   
                   % n := push (n)  %
                   VarIdent { ',' VarIdent  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void VarIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node n;

  n = decl_makeIdentList ();
  n = push (n);
  VarIdent (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      VarIdent (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   VariableDeclaration := 
                          % VAR v, d: node ;  %
                          VarIdentList 
                          % v := pop ()  %
                          ':' Type 
                          % d := makeVarDecl (v, pop ())  %
                          Alignment 

   first  symbols:identtok
   
   cannot reachend
*/

static void VariableDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node v;
  decl_node d;

  VarIdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  v = pop ();
  Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_pointertok-mcReserved_arraytok)) | (1 << (mcReserved_packedsettok-mcReserved_arraytok)) | (1 << (mcReserved_oftok-mcReserved_arraytok)) | (1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_settok-mcReserved_recordtok)) | (1 << (mcReserved_recordtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Type (stopset0|(SetOfStop0) ((1 << (mcReserved_ldirectivetok-mcReserved_eoftok))), stopset1, stopset2);
  d = decl_makeVarDecl (v, pop ());
  Alignment (stopset0, stopset1, stopset2);
}


/*
   Designator := Qualident { SubDesignator  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void Designator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Qualident (stopset0|(SetOfStop0) ((1 << (mcReserved_uparrowtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_periodtok-mcReserved_eoftok))), stopset1, stopset2);
  while ((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_uparrowtok-mcReserved_eoftok))))) != 0)))
    SubDesignator (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_uparrowtok-mcReserved_eoftok))), stopset1, stopset2);
   /* while  */
}


/*
   SubDesignator := '.' Ident  | '[' ArrayExpList ']'  | 
                    '^' 

   first  symbols:uparrowtok, lsbratok, periodtok
   
   cannot reachend
*/

static void SubDesignator (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_periodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    {
      Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      ArrayExpList (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_uparrowtok)
    Expect ((mcReserved_toktype) mcReserved_uparrowtok, stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: ^ [ .", 23);
}


/*
   ArrayExpList := Expression { ',' Expression  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ArrayExpList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expression (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Expression (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   ExpList := Expression { ',' Expression  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void ExpList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expression (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Expression (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   Expression := SimpleExpression [ Relation SimpleExpression  ] 

   first  symbols:identtok, lcbratok, nottok, lparatok, stringtok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void Expression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  SimpleExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_greaterequaltok-mcReserved_eoftok)) | (1 << (mcReserved_greatertok-mcReserved_eoftok)) | (1 << (mcReserved_lessequaltok-mcReserved_eoftok)) | (1 << (mcReserved_lesstok-mcReserved_eoftok)) | (1 << (mcReserved_lessgreatertok-mcReserved_eoftok)) | (1 << (mcReserved_hashtok-mcReserved_eoftok)) | (1 << (mcReserved_equaltok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_intok-mcReserved_arraytok))), stopset2);
  if (((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_equaltok-mcReserved_eoftok)) | (1 << (mcReserved_hashtok-mcReserved_eoftok)) | (1 << (mcReserved_lessgreatertok-mcReserved_eoftok)) | (1 << (mcReserved_lesstok-mcReserved_eoftok)) | (1 << (mcReserved_lessequaltok-mcReserved_eoftok)) | (1 << (mcReserved_greatertok-mcReserved_eoftok)) | (1 << (mcReserved_greaterequaltok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_intok))
    {
      Relation (stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      SimpleExpression (stopset0, stopset1, stopset2);
    }
}


/*
   SimpleExpression := UnaryOrTerm { AddOperator Term  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void SimpleExpression (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  UnaryOrTerm (stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_ortok-mcReserved_arraytok))), stopset2);
  while (((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_ortok))
    {
      AddOperator (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Term (stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_ortok-mcReserved_arraytok))), stopset2);
    }
   /* while  */
}


/*
   UnaryOrTerm := '+' Term  | '-' Term  | Term 

   first  symbols:identtok, lcbratok, nottok, lparatok, stringtok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void UnaryOrTerm (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_plustok)
    {
      Expect ((mcReserved_toktype) mcReserved_plustok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Term (stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_minustok)
    {
      Expect ((mcReserved_toktype) mcReserved_minustok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Term (stopset0, stopset1, stopset2);
    }
  else if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
    Term (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: NOT ( string integer number real number identifier { - +", 74);
}


/*
   Term := Factor { MulOperator Factor  } 

   first  symbols:lcbratok, identtok, realtok, integertok, stringtok, lparatok, nottok
   
   cannot reachend
*/

static void Term (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Factor (stopset0|(SetOfStop0) ((1 << (mcReserved_ambersandtok-mcReserved_eoftok)) | (1 << (mcReserved_andtok-mcReserved_eoftok)) | (1 << (mcReserved_dividetok-mcReserved_eoftok)) | (1 << (mcReserved_timestok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_modtok-mcReserved_arraytok)) | (1 << (mcReserved_divtok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_remtok-mcReserved_recordtok))));
  while ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_timestok-mcReserved_eoftok)) | (1 << (mcReserved_dividetok-mcReserved_eoftok)) | (1 << (mcReserved_andtok-mcReserved_eoftok)) | (1 << (mcReserved_ambersandtok-mcReserved_eoftok))))) != 0))) || (((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_divtok-mcReserved_arraytok)) | (1 << (mcReserved_modtok-mcReserved_arraytok))))) != 0)))) || (mcLexBuf_currenttoken == mcReserved_remtok))
    {
      MulOperator (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Factor (stopset0|(SetOfStop0) ((1 << (mcReserved_timestok-mcReserved_eoftok)) | (1 << (mcReserved_dividetok-mcReserved_eoftok)) | (1 << (mcReserved_andtok-mcReserved_eoftok)) | (1 << (mcReserved_ambersandtok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_divtok-mcReserved_arraytok)) | (1 << (mcReserved_modtok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_remtok-mcReserved_recordtok))));
    }
   /* while  */
}


/*
   Factor := Number  | string  | SetOrDesignatorOrFunction  | 
             '(' Expression ')'  | 'NOT' ( Factor  | ConstAttribute  ) 

   first  symbols:identtok, lcbratok, nottok, lparatok, stringtok, integertok, realtok
   
   cannot reachend
*/

static void Factor (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok))))) != 0)))
    Number (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_stringtok)
    string (stopset0, stopset1, stopset2);
  else if ((mcLexBuf_currenttoken == mcReserved_lcbratok) || (mcLexBuf_currenttoken == mcReserved_identtok))
    SetOrDesignatorOrFunction (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lparatok)
    {
      Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Expression (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_nottok)
    {
      Expect ((mcReserved_toktype) mcReserved_nottok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
        Factor (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_attributetok)
        ConstAttribute (stopset0, stopset1, stopset2);
      else
        ErrorArray ((char *) "expecting one of: __ATTRIBUTE__ real number integer number string ( NOT { identifier", 84);
    }
  else
    ErrorArray ((char *) "expecting one of: NOT ( identifier { string integer number real number", 70);
}


/*
   SetOrDesignatorOrFunction := Qualident [ Constructor  | 
                                            SimpleDes [ ActualParameters  ]  ]  | 
                                Constructor 

   first  symbols:lcbratok, identtok
   
   cannot reachend
*/

static void SetOrDesignatorOrFunction (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_identtok)
    {
      /* avoid dangling else.  */
      Qualident (stopset0|(SetOfStop0) ((1 << (mcReserved_lcbratok-mcReserved_eoftok)) | (1 << (mcReserved_periodtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_uparrowtok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
      if ((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_uparrowtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_periodtok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* seen optional [ | ] expression  */
          if (mcLexBuf_currenttoken == mcReserved_lcbratok)
            Constructor (stopset0, stopset1, stopset2);
          else if ((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_uparrowtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_periodtok-mcReserved_eoftok))))) != 0)))
            {
              /* avoid dangling else.  */
              SimpleDes (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
              if (mcLexBuf_currenttoken == mcReserved_lparatok)
                ActualParameters (stopset0, stopset1, stopset2);
            }
          else
            ErrorArray ((char *) "expecting one of: ( ^ [ . {", 27);
        }
      /* end of optional [ | ] expression  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_lcbratok)
    Constructor (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: { identifier", 30);
}


/*
   SimpleDes := { SubDesignator  } 

   first  symbols:periodtok, lsbratok, uparrowtok
   
   reachend
*/

static void SimpleDes (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  while ((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_uparrowtok-mcReserved_eoftok))))) != 0)))
    SubDesignator (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok)) | (1 << (mcReserved_uparrowtok-mcReserved_eoftok))), stopset1, stopset2);
   /* while  */
}


/*
   ActualParameters := '(' [ ExpList  ] ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void ActualParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
    ExpList (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   ExitStatement := 'EXIT' 

   first  symbols:exittok
   
   cannot reachend
*/

static void ExitStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_exittok, stopset0, stopset1, stopset2);
}


/*
   ReturnStatement := 'RETURN' [ Expression  ] 

   first  symbols:returntok
   
   cannot reachend
*/

static void ReturnStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_returntok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
    Expression (stopset0, stopset1, stopset2);
}


/*
   Statement := [ AssignmentOrProcedureCall  | 
                  IfStatement  | CaseStatement  | 
                  WhileStatement  | RepeatStatement  | 
                  LoopStatement  | ForStatement  | 
                  WithStatement  | AsmStatement  | 
                  ExitStatement  | ReturnStatement  | 
                  RetryStatement  ] 

   first  symbols:retrytok, asmtok, withtok, fortok, looptok, repeattok, whiletok, casetok, iftok, identtok, returntok, exittok
   
   reachend
*/

static void Statement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok))))) != 0))) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_retrytok-mcReserved_recordtok)) | (1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      /* seen optional [ | ] expression  */
      if (mcLexBuf_currenttoken == mcReserved_identtok)
        AssignmentOrProcedureCall (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_iftok)
        IfStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_casetok)
        CaseStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_whiletok)
        WhileStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_repeattok)
        RepeatStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_looptok)
        LoopStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_fortok)
        ForStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_withtok)
        WithStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_asmtok)
        AsmStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_exittok)
        ExitStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_returntok)
        ReturnStatement (stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_retrytok)
        RetryStatement (stopset0, stopset1, stopset2);
      else
        ErrorArray ((char *) "expecting one of: RETRY RETURN EXIT ASM WITH FOR LOOP REPEAT WHILE CASE IF identifier", 85);
    }
  /* end of optional [ | ] expression  */
}


/*
   RetryStatement := 'RETRY' 

   first  symbols:retrytok
   
   cannot reachend
*/

static void RetryStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_retrytok, stopset0, stopset1, stopset2);
}


/*
   AssignmentOrProcedureCall := Designator ( ':=' Expression  | 
                                             ActualParameters  | 
                                             
                                             %  epsilon   %
                                              ) 

   first  symbols:identtok
   
   cannot reachend
*/

static void AssignmentOrProcedureCall (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Designator (stopset0|(SetOfStop0) ((1 << (mcReserved_becomestok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  if (mcLexBuf_currenttoken == mcReserved_becomestok)
    {
      Expect ((mcReserved_toktype) mcReserved_becomestok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Expression (stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_lparatok)
    ActualParameters (stopset0, stopset1, stopset2);
  /* epsilon  */
}


/*
   StatementSequence := Statement { ';' Statement  } 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok
   
   reachend
*/

static void StatementSequence (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Statement (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_semicolontok)
    {
      Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Statement (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   IfStatement := 'IF' Expression 'THEN' StatementSequence { 
   'ELSIF' Expression 'THEN' StatementSequence  } [ 'ELSE' StatementSequence  ] 
                  'END' 

   first  symbols:iftok
   
   cannot reachend
*/

static void IfStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_iftok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Expression (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_thentok-mcReserved_recordtok))));
  Expect ((mcReserved_toktype) mcReserved_thentok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_elsiftok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
  StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_elsiftok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  while (mcLexBuf_currenttoken == mcReserved_elsiftok)
    {
      Expect ((mcReserved_toktype) mcReserved_elsiftok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      Expression (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_thentok-mcReserved_recordtok))));
      Expect ((mcReserved_toktype) mcReserved_thentok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_elsiftok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
      StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_elsiftok-mcReserved_arraytok))), stopset2);
    }
   /* while  */
  if (mcLexBuf_currenttoken == mcReserved_elsetok)
    {
      Expect ((mcReserved_toktype) mcReserved_elsetok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
      StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
    }
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   CaseStatement := 'CASE' Expression 'OF' Case { '|' Case  } 
                    CaseEndStatement 

   first  symbols:casetok
   
   cannot reachend
*/

static void CaseStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_casetok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Expression (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_oftok, stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
  Case (stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  while (mcLexBuf_currenttoken == mcReserved_bartok)
    {
      Expect ((mcReserved_toktype) mcReserved_bartok, stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok)) | (1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      Case (stopset0|(SetOfStop0) ((1 << (mcReserved_bartok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_elsetok-mcReserved_arraytok))), stopset2);
    }
   /* while  */
  CaseEndStatement (stopset0, stopset1, stopset2);
}


/*
   CaseEndStatement := 'END'  | 'ELSE' StatementSequence 'END' 

   first  symbols:elsetok, endtok
   
   cannot reachend
*/

static void CaseEndStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_endtok)
    Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_elsetok)
    {
      Expect ((mcReserved_toktype) mcReserved_elsetok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
      StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
      Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
    }
  else
    ErrorArray ((char *) "expecting one of: ELSE END", 26);
}


/*
   Case := [ CaseLabelList ':' StatementSequence  ] 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   reachend
*/

static void Case (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_nottok)) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))))) != 0))))
    {
      CaseLabelList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
      StatementSequence (stopset0, stopset1, stopset2);
    }
}


/*
   CaseLabelList := CaseLabels { ',' CaseLabels  } 

   first  symbols:attributetok, identtok, lcbratok, stringtok, nottok, lparatok, integertok, realtok, minustok, plustok
   
   cannot reachend
*/

static void CaseLabelList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  CaseLabels (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))));
      CaseLabels (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   CaseLabels := ConstExpressionNop [ '..' ConstExpressionNop  ] 

   first  symbols:stringtok, lcbratok, identtok, attributetok, realtok, integertok, lparatok, nottok, plustok, minustok
   
   cannot reachend
*/

static void CaseLabels (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_periodperiodtok-mcReserved_eoftok))), stopset1, stopset2);
  if (mcLexBuf_currenttoken == mcReserved_periodperiodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodperiodtok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpressionNop (stopset0, stopset1, stopset2);
    }
}


/*
   WhileStatement := 'WHILE' Expression 'DO' StatementSequence 
                     'END' 

   first  symbols:whiletok
   
   cannot reachend
*/

static void WhileStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_whiletok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Expression (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_dotok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_dotok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
  StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   RepeatStatement := 'REPEAT' StatementSequence 'UNTIL' Expression 

   first  symbols:repeattok
   
   cannot reachend
*/

static void RepeatStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_repeattok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_untiltok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
  StatementSequence (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_untiltok-mcReserved_recordtok))));
  Expect ((mcReserved_toktype) mcReserved_untiltok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Expression (stopset0, stopset1, stopset2);
}


/*
   ForStatement := 'FOR' Ident ':=' Expression 'TO' Expression 
                   [ 'BY' ConstExpressionNop  ] 'DO' StatementSequence 
                   'END' 

   first  symbols:fortok
   
   cannot reachend
*/

static void ForStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_fortok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_becomestok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_becomestok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Expression (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_totok-mcReserved_recordtok))));
  Expect ((mcReserved_toktype) mcReserved_totok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Expression (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_bytok-mcReserved_arraytok)) | (1 << (mcReserved_dotok-mcReserved_arraytok))), stopset2);
  if (mcLexBuf_currenttoken == mcReserved_bytok)
    {
      Expect ((mcReserved_toktype) mcReserved_bytok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpressionNop (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_dotok-mcReserved_arraytok))), stopset2);
    }
  Expect ((mcReserved_toktype) mcReserved_dotok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
  StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   LoopStatement := 'LOOP' StatementSequence 'END' 

   first  symbols:looptok
   
   cannot reachend
*/

static void LoopStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_looptok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
  StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   WithStatement := 'WITH' Designator 'DO' StatementSequence 
                    'END' 

   first  symbols:withtok
   
   cannot reachend
*/

static void WithStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_withtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Designator (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_dotok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_dotok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
  StatementSequence (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   ProcedureDeclaration := ProcedureHeading ';' ProcedureBlock 
                           Ident 
                           % leaveScope  %
                           

   first  symbols:proceduretok
   
   cannot reachend
*/

static void ProcedureDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  ProcedureHeading (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
  ProcedureBlock (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0, stopset1, stopset2);
  decl_leaveScope ();
}


/*
   ProcedureIdent := Ident 
                     % curproc := lookupSym (curident)  %
                     
                     % enterScope (curproc)  %
                     

   first  symbols:identtok
   
   cannot reachend
*/

static void ProcedureIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0, stopset1, stopset2);
  curproc = decl_lookupSym (curident);
  decl_enterScope (curproc);
}


/*
   DefProcedureIdent := Ident 
                        % curproc := lookupSym (curident)  %
                        

   first  symbols:identtok
   
   cannot reachend
*/

static void DefProcedureIdent (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0, stopset1, stopset2);
  curproc = decl_lookupSym (curident);
}


/*
   DefineBuiltinProcedure := [ '__ATTRIBUTE__' '__BUILTIN__' 
                               '(' '(' Ident ')' ')'  | 
                               '__INLINE__'  ] 

   first  symbols:inlinetok, attributetok
   
   reachend
*/

static void DefineBuiltinProcedure (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_inlinetok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok))))) != 0)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      /* seen optional [ | ] expression  */
      if (mcLexBuf_currenttoken == mcReserved_attributetok)
        {
          Expect ((mcReserved_toktype) mcReserved_attributetok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_builtintok-mcReserved_recordtok))));
          Expect ((mcReserved_toktype) mcReserved_builtintok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
          Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
        }
      else if (mcLexBuf_currenttoken == mcReserved_inlinetok)
        Expect ((mcReserved_toktype) mcReserved_inlinetok, stopset0, stopset1, stopset2);
      else
        ErrorArray ((char *) "expecting one of: __INLINE__ __ATTRIBUTE__", 42);
    }
  /* end of optional [ | ] expression  */
}


/*
   ProcedureHeading := 'PROCEDURE' DefineBuiltinProcedure ( ProcedureIdent 
                                                            [ 
   FormalParameters  ]  ) 

   first  symbols:proceduretok
   
   cannot reachend
*/

static void ProcedureHeading (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_proceduretok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_inlinetok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  DefineBuiltinProcedure (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  ProcedureIdent (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  if (mcLexBuf_currenttoken == mcReserved_lparatok)
    FormalParameters (stopset0, stopset1, stopset2);
}


/*
   Builtin := [ '__BUILTIN__'  | '__INLINE__'  ] 

   first  symbols:inlinetok, builtintok
   
   reachend
*/

static void Builtin (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_inlinetok-mcReserved_recordtok)) | (1 << (mcReserved_builtintok-mcReserved_recordtok))))) != 0)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      /* seen optional [ | ] expression  */
      if (mcLexBuf_currenttoken == mcReserved_builtintok)
        Expect ((mcReserved_toktype) mcReserved_builtintok, stopset0, stopset1, stopset2);
      else if (mcLexBuf_currenttoken == mcReserved_inlinetok)
        Expect ((mcReserved_toktype) mcReserved_inlinetok, stopset0, stopset1, stopset2);
      else
        ErrorArray ((char *) "expecting one of: __INLINE__ __BUILTIN__", 40);
    }
  /* end of optional [ | ] expression  */
}


/*
   DefProcedureHeading := 'PROCEDURE' Builtin ( DefProcedureIdent 
                                                [ DefFormalParameters  ]  ) 

   first  symbols:proceduretok
   
   cannot reachend
*/

static void DefProcedureHeading (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_proceduretok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_inlinetok-mcReserved_recordtok)) | (1 << (mcReserved_builtintok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Builtin (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  DefProcedureIdent (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  if (mcLexBuf_currenttoken == mcReserved_lparatok)
    DefFormalParameters (stopset0, stopset1, stopset2);
}


/*
   ProcedureBlock := { Declaration  } [ 'BEGIN' ProcedureBlockBody  ] 
                     'END' 

   first  symbols:proceduretok, moduletok, consttok, typetok, vartok, endtok, begintok
   
   cannot reachend
*/

static void ProcedureBlock (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  while ((((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))))) != 0))) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))))) != 0))))
    Declaration (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
   /* while  */
  if (mcLexBuf_currenttoken == mcReserved_begintok)
    {
      Expect ((mcReserved_toktype) mcReserved_begintok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_excepttok-mcReserved_arraytok)) | (1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
      ProcedureBlockBody (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
    }
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   Block := { Declaration  } InitialBlock FinalBlock 'END' 

   first  symbols:proceduretok, moduletok, finallytok, begintok, consttok, typetok, vartok, endtok
   
   cannot reachend
*/

static void Block (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  while ((((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))))) != 0))) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))))) != 0))))
    Declaration (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
   /* while  */
  InitialBlock (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok))), stopset2);
  FinalBlock (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2);
}


/*
   InitialBlock := [ 'BEGIN' InitialBlockBody  ] 

   first  symbols:begintok
   
   reachend
*/

static void InitialBlock (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_begintok)
    {
      Expect ((mcReserved_toktype) mcReserved_begintok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_excepttok-mcReserved_arraytok)) | (1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
      InitialBlockBody (stopset0, stopset1, stopset2);
    }
}


/*
   FinalBlock := [ 'FINALLY' FinalBlockBody  ] 

   first  symbols:finallytok
   
   reachend
*/

static void FinalBlock (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_finallytok)
    {
      Expect ((mcReserved_toktype) mcReserved_finallytok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_excepttok-mcReserved_arraytok)) | (1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok))));
      FinalBlockBody (stopset0, stopset1, stopset2);
    }
}


/*
   InitialBlockBody := NormalPart [ 'EXCEPT' ExceptionalPart  ] 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok, excepttok
   
   reachend
*/

static void InitialBlockBody (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  NormalPart (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_excepttok-mcReserved_arraytok))), stopset2);
  if (mcLexBuf_currenttoken == mcReserved_excepttok)
    {
      Expect ((mcReserved_toktype) mcReserved_excepttok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      ExceptionalPart (stopset0, stopset1, stopset2);
    }
}


/*
   FinalBlockBody := NormalPart [ 'EXCEPT' ExceptionalPart  ] 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok, excepttok
   
   reachend
*/

static void FinalBlockBody (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  NormalPart (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_excepttok-mcReserved_arraytok))), stopset2);
  if (mcLexBuf_currenttoken == mcReserved_excepttok)
    {
      Expect ((mcReserved_toktype) mcReserved_excepttok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      ExceptionalPart (stopset0, stopset1, stopset2);
    }
}


/*
   ProcedureBlockBody := NormalPart [ 'EXCEPT' ExceptionalPart  ] 

   first  symbols:identtok, iftok, casetok, whiletok, repeattok, looptok, fortok, withtok, asmtok, retrytok, semicolontok, exittok, returntok, excepttok
   
   reachend
*/

static void ProcedureBlockBody (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  NormalPart (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_excepttok-mcReserved_arraytok))), stopset2);
  if (mcLexBuf_currenttoken == mcReserved_excepttok)
    {
      Expect ((mcReserved_toktype) mcReserved_excepttok, stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_exittok-mcReserved_arraytok)) | (1 << (mcReserved_fortok-mcReserved_arraytok)) | (1 << (mcReserved_looptok-mcReserved_arraytok)) | (1 << (mcReserved_casetok-mcReserved_arraytok)) | (1 << (mcReserved_iftok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_returntok-mcReserved_recordtok)) | (1 << (mcReserved_retrytok-mcReserved_recordtok)) | (1 << (mcReserved_asmtok-mcReserved_recordtok)) | (1 << (mcReserved_withtok-mcReserved_recordtok)) | (1 << (mcReserved_repeattok-mcReserved_recordtok)) | (1 << (mcReserved_whiletok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
      ExceptionalPart (stopset0, stopset1, stopset2);
    }
}


/*
   NormalPart := StatementSequence 

   first  symbols:retrytok, asmtok, withtok, fortok, looptok, repeattok, whiletok, casetok, iftok, identtok, returntok, exittok, semicolontok
   
   reachend
*/

static void NormalPart (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  StatementSequence (stopset0, stopset1, stopset2);
}


/*
   ExceptionalPart := StatementSequence 

   first  symbols:retrytok, asmtok, withtok, fortok, looptok, repeattok, whiletok, casetok, iftok, identtok, returntok, exittok, semicolontok
   
   reachend
*/

static void ExceptionalPart (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  StatementSequence (stopset0, stopset1, stopset2);
}


/*
   Declaration := 'CONST' { ConstantDeclaration ';'  }  | 
                  'TYPE' { TypeDeclaration  }  | 
                  'VAR' { VariableDeclaration ';'  }  | 
                  ProcedureDeclaration ';'  | 
                  ModuleDeclaration ';' 

   first  symbols:moduletok, proceduretok, vartok, typetok, consttok
   
   cannot reachend
*/

static void Declaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_consttok)
    {
      Expect ((mcReserved_toktype) mcReserved_consttok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      while (mcLexBuf_currenttoken == mcReserved_identtok)
        {
          ConstantDeclaration (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
        }
       /* while  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_typetok)
    {
      Expect ((mcReserved_toktype) mcReserved_typetok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      while (mcLexBuf_currenttoken == mcReserved_identtok)
        TypeDeclaration (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
       /* while  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_vartok)
    {
      Expect ((mcReserved_toktype) mcReserved_vartok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      while (mcLexBuf_currenttoken == mcReserved_identtok)
        {
          VariableDeclaration (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
        }
       /* while  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_proceduretok)
    {
      ProcedureDeclaration (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_moduletok)
    {
      ModuleDeclaration (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2);
    }
  else
    ErrorArray ((char *) "expecting one of: MODULE PROCEDURE VAR TYPE CONST", 49);
}


/*
   DefFormalParameters := '(' 
                          % paramEnter (curproc)  %
                          [ DefMultiFPSection  ] ')' 
                          % paramLeave (curproc)  %
                          FormalReturn 

   first  symbols:lparatok
   
   cannot reachend
*/

static void DefFormalParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
  decl_paramEnter (curproc);
  if ((mcLexBuf_currenttoken == mcReserved_lsbratok) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
    DefMultiFPSection (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  decl_paramLeave (curproc);
  FormalReturn (stopset0, stopset1, stopset2);
}


/*
   DefMultiFPSection := DefExtendedFP  | FPSection [ ';' DefMultiFPSection  ] 

   first  symbols:identtok, vartok, lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void DefMultiFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken == mcReserved_lsbratok) || (mcLexBuf_currenttoken == mcReserved_periodperiodperiodtok))
    DefExtendedFP (stopset0, stopset1, stopset2);
  else if ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))))) != 0)))
    {
      /* avoid dangling else.  */
      FPSection (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
      if (mcLexBuf_currenttoken == mcReserved_semicolontok)
        {
          Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
          DefMultiFPSection (stopset0, stopset1, stopset2);
        }
    }
  else
    ErrorArray ((char *) "expecting one of: identifier VAR ... [", 38);
}


/*
   FormalParameters := '(' 
                       % paramEnter (curproc)  %
                       [ MultiFPSection  ] ')' 
                       % paramLeave (curproc)  %
                       FormalReturn 

   first  symbols:lparatok
   
   cannot reachend
*/

static void FormalParameters (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
  decl_paramEnter (curproc);
  if ((mcLexBuf_currenttoken == mcReserved_lsbratok) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))))) != 0))))
    MultiFPSection (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  decl_paramLeave (curproc);
  FormalReturn (stopset0, stopset1, stopset2);
}


/*
   MultiFPSection := ExtendedFP  | FPSection [ ';' MultiFPSection  ] 

   first  symbols:identtok, vartok, lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void MultiFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken == mcReserved_lsbratok) || (mcLexBuf_currenttoken == mcReserved_periodperiodperiodtok))
    ExtendedFP (stopset0, stopset1, stopset2);
  else if ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))))) != 0)))
    {
      /* avoid dangling else.  */
      FPSection (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
      if (mcLexBuf_currenttoken == mcReserved_semicolontok)
        {
          Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_periodperiodperiodtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
          MultiFPSection (stopset0, stopset1, stopset2);
        }
    }
  else
    ErrorArray ((char *) "expecting one of: identifier VAR ... [", 38);
}


/*
   FPSection := NonVarFPSection  | VarFPSection 

   first  symbols:vartok, identtok
   
   cannot reachend
*/

static void FPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_identtok)
    NonVarFPSection (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_vartok)
    VarFPSection (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: VAR identifier", 32);
}


/*
   DefExtendedFP := DefOptArg  | '...' 
                    % addParameter (curproc, makeVarargs ())  %
                    

   first  symbols:lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void DefExtendedFP (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    DefOptArg (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_periodperiodperiodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodperiodperiodtok, stopset0, stopset1, stopset2);
      decl_addParameter (curproc, decl_makeVarargs ());
    }
  else
    ErrorArray ((char *) "expecting one of: ... [", 23);
}


/*
   ExtendedFP := OptArg  | '...' 

   first  symbols:lsbratok, periodperiodperiodtok
   
   cannot reachend
*/

static void ExtendedFP (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    OptArg (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_periodperiodperiodtok)
    Expect ((mcReserved_toktype) mcReserved_periodperiodperiodtok, stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: ... [", 23);
}


/*
   VarFPSection := 'VAR' PushIdentList 
                   % VAR l, t: node ;  %
                   ':' FormalType 
                   % t := pop ()  %
                   
                   % l := pop ()  %
                   
                   % addVarParameters (curproc, l, t)  %
                   

   first  symbols:vartok
   
   cannot reachend
*/

static void VarFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node l;
  decl_node t;

  Expect ((mcReserved_toktype) mcReserved_vartok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  PushIdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_colontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  FormalType (stopset0, stopset1, stopset2);
  t = pop ();
  l = pop ();
  decl_addVarParameters (curproc, l, t);
}


/*
   NonVarFPSection := PushIdentList 
                      % VAR l, t: node ;  %
                      ':' FormalType 
                      % t := pop ()  %
                      
                      % l := pop ()  %
                      
                      % addNonVarParameters (curproc, l, t)  %
                      

   first  symbols:identtok
   
   cannot reachend
*/

static void NonVarFPSection (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node l;
  decl_node t;

  PushIdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_colontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  FormalType (stopset0, stopset1, stopset2);
  t = pop ();
  l = pop ();
  decl_addNonVarParameters (curproc, l, t);
}


/*
   OptArg := 
             % VAR p, init, type: node ; id: Name ;  %
             '[' Ident 
             % id := curident  %
             ':' FormalType 
             % type := pop ()  %
             
             % init := NIL  %
             [ '=' ConstExpression 
               % init := pop ()  %
                ] ']' 
             % p := addOptParameter (curproc, id, type, init)  %
             

   first  symbols:lsbratok
   
   cannot reachend
*/

static void OptArg (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node p;
  decl_node init;
  decl_node type;
  nameKey_Name id;

  Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  id = curident;
  Expect ((mcReserved_toktype) mcReserved_colontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  FormalType (stopset0|(SetOfStop0) ((1 << (mcReserved_equaltok-mcReserved_eoftok)) | (1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
  type = pop ();
  init = NULL;
  if (mcLexBuf_currenttoken == mcReserved_equaltok)
    {
      Expect ((mcReserved_toktype) mcReserved_equaltok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
      ConstExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
      init = pop ();
    }
  Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
  p = decl_addOptParameter (curproc, id, type, init);
}


/*
   DefOptArg := 
                % VAR p, init, type: node ; id: Name ;  %
                '[' Ident 
                % id := curident  %
                ':' FormalType 
                % type := pop ()  %
                '=' ConstExpression 
                % init := pop ()  %
                ']' 
                % p := addOptParameter (curproc, id, type, init)  %
                

   first  symbols:lsbratok
   
   cannot reachend
*/

static void DefOptArg (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node p;
  decl_node init;
  decl_node type;
  nameKey_Name id;

  Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  id = curident;
  Expect ((mcReserved_toktype) mcReserved_colontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  FormalType (stopset0|(SetOfStop0) ((1 << (mcReserved_equaltok-mcReserved_eoftok))), stopset1, stopset2);
  type = pop ();
  Expect ((mcReserved_toktype) mcReserved_equaltok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
  ConstExpression (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
  init = pop ();
  Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
  p = decl_addOptParameter (curproc, id, type, init);
}


/*
   FormalType := 
                 % VAR c: CARDINAL ;  %
                 
                 % VAR n, a, s: node ;  %
                 
                 % c := 0  %
                 { 'ARRAY' 'OF' 
                   % INC (c)  %
                    } PushQualident 
                 % pushNunbounded (c)  %
                 

   first  symbols:identtok, arraytok
   
   cannot reachend
*/

static void FormalType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  unsigned int c;
  decl_node n;
  decl_node a;
  decl_node s;

  c = 0;
  while (mcLexBuf_currenttoken == mcReserved_arraytok)
    {
      Expect ((mcReserved_toktype) mcReserved_arraytok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_oftok-mcReserved_arraytok))), stopset2);
      Expect ((mcReserved_toktype) mcReserved_oftok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      c += 1;
    }
   /* while  */
  PushQualident (stopset0, stopset1, stopset2);
  pushNunbounded (c);
}


/*
   ModuleDeclaration := 'MODULE' Ident [ Priority  ] ';' { Import  } 
                        [ Export  ] Block Ident 

   first  symbols:moduletok
   
   cannot reachend
*/

static void ModuleDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_moduletok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2);
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    Priority (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_exporttok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
  while (((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok))))) != 0)))
    Import (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_exporttok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_typetok-mcReserved_recordtok))));
   /* while  */
  if (mcLexBuf_currenttoken == mcReserved_exporttok)
    Export (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_begintok-mcReserved_arraytok)) | (1 << (mcReserved_finallytok-mcReserved_arraytok)) | (1 << (mcReserved_moduletok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_typetok-mcReserved_recordtok))));
  Block (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0, stopset1, stopset2);
}


/*
   Priority := '[' ConstExpressionNop ']' 

   first  symbols:lsbratok
   
   cannot reachend
*/

static void Priority (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_attributetok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok)) | (1 << (mcReserved_stringtok-mcReserved_recordtok))));
  ConstExpressionNop (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
}


/*
   Export := 'EXPORT' ( 'QUALIFIED' IdentList  | 
                        'UNQUALIFIED' IdentList  | 
                        IdentList  ) ';' 

   first  symbols:exporttok
   
   cannot reachend
*/

static void Export (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_exporttok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_qualifiedtok-mcReserved_arraytok)) | (1 << (mcReserved_unqualifiedtok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  if (mcLexBuf_currenttoken == mcReserved_qualifiedtok)
    {
      Expect ((mcReserved_toktype) mcReserved_qualifiedtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      IdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_unqualifiedtok)
    {
      Expect ((mcReserved_toktype) mcReserved_unqualifiedtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      IdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
    }
  else if (mcLexBuf_currenttoken == mcReserved_identtok)
    IdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: identifier UNQUALIFIED QUALIFIED", 50);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2);
}


/*
   FromIdentList := Ident 
                    % importInto (frommodule, curident, curmodule)  %
                    { ',' Ident 
                      % importInto (frommodule, curident, curmodule)  %
                       } 

   first  symbols:identtok
   
   cannot reachend
*/

static void FromIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  importInto (frommodule, curident, curmodule);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
      importInto (frommodule, curident, curmodule);
    }
   /* while  */
}


/*
   FromImport := 'FROM' Ident 
                 % frommodule := lookupDef (curident)  %
                 'IMPORT' FromIdentList ';' 

   first  symbols:fromtok
   
   cannot reachend
*/

static void FromImport (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_fromtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_importtok-mcReserved_arraytok))), stopset2);
  frommodule = decl_lookupDef (curident);
  Expect ((mcReserved_toktype) mcReserved_importtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  FromIdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2);
}


/*
   ImportModuleList := Ident { ',' Ident  } 

   first  symbols:identtok
   
   cannot reachend
*/

static void ImportModuleList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   WithoutFromImport := 'IMPORT' ImportModuleList ';' 

   first  symbols:importtok
   
   cannot reachend
*/

static void WithoutFromImport (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_importtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  ImportModuleList (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2);
}


/*
   Import := FromImport  | WithoutFromImport 

   first  symbols:importtok, fromtok
   
   cannot reachend
*/

static void Import (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_fromtok)
    FromImport (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_importtok)
    WithoutFromImport (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: IMPORT FROM", 29);
}


/*
   DefinitionModule := 'DEFINITION' 'MODULE' [ 'FOR' string  ] 
                       Ident ';' 
                       % curmodule := lookupDef (curident)  %
                       
                       % enterScope (curmodule)  %
                       
                       % resetEnumPos (curmodule)  %
                       { Import  } [ Export  ] { Definition  } 
                       'END' Ident '.' 
                       % checkEndName (curmodule, curident, 'definition module')  %
                       
                       % setConstExpComplete (curmodule)  %
                       
                       % leaveScope  %
                       

   first  symbols:definitiontok
   
   cannot reachend
*/

static void DefinitionModule (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_definitiontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_moduletok-mcReserved_arraytok))), stopset2);
  Expect ((mcReserved_toktype) mcReserved_moduletok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_fortok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  if (mcLexBuf_currenttoken == mcReserved_fortok)
    {
      Expect ((mcReserved_toktype) mcReserved_fortok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
      string (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
    }
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_exporttok-mcReserved_arraytok)) | (1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_vartok-mcReserved_recordtok)) | (1 << (mcReserved_typetok-mcReserved_recordtok))));
  curmodule = decl_lookupDef (curident);
  decl_enterScope (curmodule);
  decl_resetEnumPos (curmodule);
  while (((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok))))) != 0)))
    Import (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_exporttok-mcReserved_arraytok)) | (1 << (mcReserved_fromtok-mcReserved_arraytok)) | (1 << (mcReserved_importtok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
   /* while  */
  if (mcLexBuf_currenttoken == mcReserved_exporttok)
    Export (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
  while ((((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))))) != 0))) || ((mcLexBuf_currenttoken >= mcReserved_recordtok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_recordtok)) & ((SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))))) != 0))))
    Definition (stopset0, stopset1|(SetOfStop1) ((1 << (mcReserved_endtok-mcReserved_arraytok)) | (1 << (mcReserved_consttok-mcReserved_arraytok)) | (1 << (mcReserved_proceduretok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_typetok-mcReserved_recordtok)) | (1 << (mcReserved_vartok-mcReserved_recordtok))));
   /* while  */
  Expect ((mcReserved_toktype) mcReserved_endtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_periodtok, stopset0, stopset1, stopset2);
  checkEndName (curmodule, curident, (char *) "definition module", 17);
  decl_setConstExpComplete (curmodule);
  decl_leaveScope ();
}


/*
   PushQualident := Ident 
                    % typeExp := push (lookupSym (curident))  %
                    
                    % IF typeExp = NIL
                                    THEN
                                       metaError1 ('the symbol {%1k} is not visible in this scope (or any other nested scope)', curident)
                                    END  %
                    [ '.' 
                      % IF NOT isDef (typeExp)
                                      THEN
                        									    ErrorArray ('the first component of this qualident must be a definition module')
                                      END  %
                      Ident 
                      % typeExp := replace (lookupInScope (typeExp, curident)) ;
                        			                                                 IF typeExp=NIL
                                      THEN
                                         ErrorArray ('identifier not found in definition module')
                                      END  %
                       ] 

   first  symbols:identtok
   
   cannot reachend
*/

static void PushQualident (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_periodtok-mcReserved_eoftok))), stopset1, stopset2);
  typeExp = push (decl_lookupSym (curident));
  if (typeExp == NULL)
    mcMetaError_metaError1 ((char *) "the symbol {%1k} is not visible in this scope (or any other nested scope)", 73, (unsigned char *) &curident, (sizeof (curident)-1));
  if (mcLexBuf_currenttoken == mcReserved_periodtok)
    {
      Expect ((mcReserved_toktype) mcReserved_periodtok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      if (! (decl_isDef (typeExp)))
        ErrorArray ((char *) "the first component of this qualident must be a definition module", 65);
      Ident (stopset0, stopset1, stopset2);
      typeExp = replace (decl_lookupInScope (typeExp, curident));
      if (typeExp == NULL)
        ErrorArray ((char *) "identifier not found in definition module", 41);
    }
}


/*
   OptSubrange := [ SubrangeType 
                    % VAR q, s: node ;  %
                    
                    % s := pop ()  %
                    
                    % q := pop ()  %
                    
                    % putSubrangeType (s, q)  %
                    
                    % typeExp := push (s)  %
                     ] 

   first  symbols:lsbratok
   
   reachend
*/

static void OptSubrange (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node q;
  decl_node s;

  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    {
      SubrangeType (stopset0, stopset1, stopset2);
      s = pop ();
      q = pop ();
      decl_putSubrangeType (s, q);
      typeExp = push (s);
    }
}


/*
   TypeEquiv := PushQualident OptSubrange 

   first  symbols:identtok
   
   cannot reachend
*/

static void TypeEquiv (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  PushQualident (stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2);
  OptSubrange (stopset0, stopset1, stopset2);
}


/*
   EnumIdentList := 
                    % VAR f: node ;  %
                    
                    % typeExp := push (makeEnum ())  %
                    Ident 
                    % f := makeEnumField (typeExp, curident)  %
                    { ',' Ident 
                      % f := makeEnumField (typeExp, curident)  %
                       } 

   first  symbols:identtok
   
   cannot reachend
*/

static void EnumIdentList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  decl_node f;

  typeExp = push (decl_makeEnum ());
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  f = decl_makeEnumField (typeExp, curident);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
      f = decl_makeEnumField (typeExp, curident);
    }
   /* while  */
}


/*
   Enumeration := '(' EnumIdentList ')' 

   first  symbols:lparatok
   
   cannot reachend
*/

static void Enumeration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  EnumIdentList (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   SimpleType := 
                 % VAR d: CARDINAL ;  %
                 
                 % d := depth ()  %
                 ( TypeEquiv  | Enumeration  | SubrangeType  ) 
                 
                 % assert (d = depth () - 1)  %
                 

   first  symbols:lsbratok, lparatok, identtok
   
   cannot reachend
*/

static void SimpleType (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  unsigned int d;

  d = depth ();
  if (mcLexBuf_currenttoken == mcReserved_identtok)
    TypeEquiv (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lparatok)
    Enumeration (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    SubrangeType (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: [ ( identifier", 32);
  mcDebug_assert (d == ((depth ())-1));
}


/*
   Type := SimpleType  | ArrayType  | RecordType  | 
           SetType  | PointerType  | ProcedureType 

   first  symbols:proceduretok, pointertok, settok, packedsettok, oftok, recordtok, arraytok, identtok, lparatok, lsbratok
   
   cannot reachend
*/

static void Type (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (((mcLexBuf_currenttoken < mcReserved_arraytok) && ((((1 << (mcLexBuf_currenttoken-mcReserved_eoftok)) & ((SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_identtok))
    SimpleType (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_arraytok)
    ArrayType (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_recordtok)
    RecordType (stopset0, stopset1, stopset2);
  else if ((((mcLexBuf_currenttoken >= mcReserved_arraytok) && (mcLexBuf_currenttoken < mcReserved_recordtok)) && ((((1 << (mcLexBuf_currenttoken-mcReserved_arraytok)) & ((SetOfStop1) ((1 << (mcReserved_packedsettok-mcReserved_arraytok)) | (1 << (mcReserved_oftok-mcReserved_arraytok))))) != 0))) || (mcLexBuf_currenttoken == mcReserved_settok))
    SetType (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_pointertok)
    PointerType (stopset0, stopset1, stopset2);
  else if (mcLexBuf_currenttoken == mcReserved_proceduretok)
    ProcedureType (stopset0, stopset1, stopset2);
  else
    ErrorArray ((char *) "expecting one of: PROCEDURE POINTER SET PACKEDSET OF RECORD ARRAY identifier ( [", 80);
}


/*
   TypeDeclaration := { Ident 
                        % typeDes := lookupSym (curident)  %
                        ( ';'  | '=' Type 
                          % putType (typeDes, pop ())  %
                          Alignment ';'  )  } 

   first  symbols:identtok
   
   reachend
*/

static void TypeDeclaration (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  while (mcLexBuf_currenttoken == mcReserved_identtok)
    {
      Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok)) | (1 << (mcReserved_equaltok-mcReserved_eoftok))), stopset1, stopset2);
      typeDes = decl_lookupSym (curident);
      if (mcLexBuf_currenttoken == mcReserved_semicolontok)
        Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      else if (mcLexBuf_currenttoken == mcReserved_equaltok)
        {
          Expect ((mcReserved_toktype) mcReserved_equaltok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_proceduretok-mcReserved_arraytok)) | (1 << (mcReserved_pointertok-mcReserved_arraytok)) | (1 << (mcReserved_packedsettok-mcReserved_arraytok)) | (1 << (mcReserved_oftok-mcReserved_arraytok)) | (1 << (mcReserved_arraytok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_settok-mcReserved_recordtok)) | (1 << (mcReserved_recordtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
          Type (stopset0|(SetOfStop0) ((1 << (mcReserved_ldirectivetok-mcReserved_eoftok)) | (1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
          decl_putType (typeDes, pop ());
          Alignment (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
        }
      else
        ErrorArray ((char *) "expecting one of: = ;", 21);
    }
   /* while  */
}


/*
   Definition := 'CONST' { ConstantDeclaration ';'  }  | 
                 'TYPE' { TypeDeclaration  }  | 
                 'VAR' { VariableDeclaration ';'  }  | 
                 DefProcedureHeading ';' 

   first  symbols:proceduretok, vartok, typetok, consttok
   
   cannot reachend
*/

static void Definition (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_consttok)
    {
      Expect ((mcReserved_toktype) mcReserved_consttok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      while (mcLexBuf_currenttoken == mcReserved_identtok)
        {
          ConstantDeclaration (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
        }
       /* while  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_typetok)
    {
      Expect ((mcReserved_toktype) mcReserved_typetok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      while (mcLexBuf_currenttoken == mcReserved_identtok)
        TypeDeclaration (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
       /* while  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_vartok)
    {
      Expect ((mcReserved_toktype) mcReserved_vartok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
      while (mcLexBuf_currenttoken == mcReserved_identtok)
        {
          VariableDeclaration (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
          Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
        }
       /* while  */
    }
  else if (mcLexBuf_currenttoken == mcReserved_proceduretok)
    {
      DefProcedureHeading (stopset0|(SetOfStop0) ((1 << (mcReserved_semicolontok-mcReserved_eoftok))), stopset1, stopset2);
      Expect ((mcReserved_toktype) mcReserved_semicolontok, stopset0, stopset1, stopset2);
    }
  else
    ErrorArray ((char *) "expecting one of: PROCEDURE VAR TYPE CONST", 42);
}


/*
   AsmStatement := 'ASM' [ 'VOLATILE'  ] '(' AsmOperands ')' 

   first  symbols:asmtok
   
   cannot reachend
*/

static void AsmStatement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_asmtok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_volatiletok-mcReserved_recordtok))));
  if (mcLexBuf_currenttoken == mcReserved_volatiletok)
    Expect ((mcReserved_toktype) mcReserved_volatiletok, stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
  AsmOperands (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   AsmOperands := string [ AsmOperandSpec  ] 

   first  symbols:stringtok
   
   cannot reachend
*/

static void AsmOperands (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  string (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
  if (mcLexBuf_currenttoken == mcReserved_colontok)
    AsmOperandSpec (stopset0, stopset1, stopset2);
}


/*
   AsmOperandSpec := [ ':' AsmList [ ':' AsmList [ ':' TrashList  ]  ]  ] 

   first  symbols:colontok
   
   reachend
*/

static void AsmOperandSpec (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_colontok)
    {
      Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok)) | (1 << (mcReserved_commatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
      AsmList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
      if (mcLexBuf_currenttoken == mcReserved_colontok)
        {
          Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok)) | (1 << (mcReserved_commatok-mcReserved_eoftok)) | (1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
          AsmList (stopset0|(SetOfStop0) ((1 << (mcReserved_colontok-mcReserved_eoftok))), stopset1, stopset2);
          if (mcLexBuf_currenttoken == mcReserved_colontok)
            {
              Expect ((mcReserved_toktype) mcReserved_colontok, stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
              TrashList (stopset0, stopset1, stopset2);
            }
        }
    }
}


/*
   AsmList := [ AsmElement  ] { ',' AsmElement  } 

   first  symbols:lsbratok, stringtok, commatok
   
   reachend
*/

static void AsmList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if ((mcLexBuf_currenttoken == mcReserved_lsbratok) || (mcLexBuf_currenttoken == mcReserved_stringtok))
    AsmElement (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0|(SetOfStop0) ((1 << (mcReserved_lsbratok-mcReserved_eoftok))), stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
      AsmElement (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   NamedOperand := '[' Ident ']' 

   first  symbols:lsbratok
   
   cannot reachend
*/

static void NamedOperand (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  Expect ((mcReserved_toktype) mcReserved_lsbratok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_identtok-mcReserved_recordtok))));
  Ident (stopset0|(SetOfStop0) ((1 << (mcReserved_rsbratok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rsbratok, stopset0, stopset1, stopset2);
}


/*
   AsmOperandName := [ NamedOperand  ] 

   first  symbols:lsbratok
   
   reachend
*/

static void AsmOperandName (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_lsbratok)
    NamedOperand (stopset0, stopset1, stopset2);
}


/*
   AsmElement := AsmOperandName string '(' Expression ')' 

   first  symbols:stringtok, lsbratok
   
   cannot reachend
*/

static void AsmElement (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  AsmOperandName (stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
  string (stopset0|(SetOfStop0) ((1 << (mcReserved_lparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_lparatok, stopset0|(SetOfStop0) ((1 << (mcReserved_minustok-mcReserved_eoftok)) | (1 << (mcReserved_plustok-mcReserved_eoftok)) | (1 << (mcReserved_lparatok-mcReserved_eoftok)) | (1 << (mcReserved_lcbratok-mcReserved_eoftok))), stopset1|(SetOfStop1) ((1 << (mcReserved_nottok-mcReserved_arraytok))), stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok)) | (1 << (mcReserved_integertok-mcReserved_recordtok)) | (1 << (mcReserved_realtok-mcReserved_recordtok)) | (1 << (mcReserved_identtok-mcReserved_recordtok))));
  Expression (stopset0|(SetOfStop0) ((1 << (mcReserved_rparatok-mcReserved_eoftok))), stopset1, stopset2);
  Expect ((mcReserved_toktype) mcReserved_rparatok, stopset0, stopset1, stopset2);
}


/*
   TrashList := [ string  ] { ',' string  } 

   first  symbols:commatok, stringtok
   
   reachend
*/

static void TrashList (SetOfStop0 stopset0, SetOfStop1 stopset1, SetOfStop2 stopset2)
{
  if (mcLexBuf_currenttoken == mcReserved_stringtok)
    string (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
  while (mcLexBuf_currenttoken == mcReserved_commatok)
    {
      Expect ((mcReserved_toktype) mcReserved_commatok, stopset0, stopset1, stopset2|(SetOfStop2) ((1 << (mcReserved_stringtok-mcReserved_recordtok))));
      string (stopset0|(SetOfStop0) ((1 << (mcReserved_commatok-mcReserved_eoftok))), stopset1, stopset2);
    }
   /* while  */
}


/*
   CompilationUnit - returns TRUE if the input was correct enough to parse
                     in future passes.
*/

unsigned int mcp3_CompilationUnit (void)
{
  stk = mcStack_init ();
  WasNoError = TRUE;
  FileUnit ((SetOfStop0) ((1 << (mcReserved_eoftok-mcReserved_eoftok))), (SetOfStop1) 0, (SetOfStop2) 0);
  mcStack_kill (&stk);
  return WasNoError;
}

void _M2_mcp3_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}

void _M2_mcp3_finish (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}
