static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * This operation is a port of the GIMP Engrave plug-in                       \n"
" *                                                                            \n"
" * Copyright (C) 1995 Spencer Kimball and Peter Mattis                        \n"
" * Copyright (C) 1997 Eiichi Takamori                                         \n"
" * Copyright (C) 1996, 1997 Torsten Martinsen                                 \n"
" *                                                                            \n"
" * GEGL Port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (row_height, _(\"Height\"), 10)                                  \n"
"    description (_(\"Resolution in pixels\"))                                 \n"
"    value_range (2, 16)                                                       \n"
"    ui_range    (2, 16)                                                       \n"
"                                                                              \n"
"property_boolean (limit, _(\"Limit line width\"), FALSE)                      \n"
"    description (_(\"Limit line width\"))                                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE engrave.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"engrave_row (gfloat        *in_row,                                           \n"
"             GeglRectangle *in_rect,                                          \n"
"             gfloat        *out_row,                                          \n"
"             GeglRectangle *out_rect,                                         \n"
"             gboolean      limit)                                             \n"
"{                                                                             \n"
"  gfloat average, v;                                                          \n"
"  gint   x, y, y_offset, real_y, inten;                                       \n"
"                                                                              \n"
"  y_offset = in_rect->height - out_rect->height;                              \n"
"                                                                              \n"
"  for (x = 0; x < in_rect->width; x++)                                        \n"
"    {                                                                         \n"
"      average = 0.0f;                                                         \n"
"                                                                              \n"
"      for (y = 0; y < in_rect->height; y++)                                   \n"
"        {                                                                     \n"
"          average += in_row[(x + y * in_rect->width) * 2];                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      inten = average;                                                        \n"
"                                                                              \n"
"      for (y = 0; y < out_rect->height; y++)                                  \n"
"        {                                                                     \n"
"          real_y = y;                                                         \n"
"                                                                              \n"
"          if (in_rect->y != out_rect->y)                                      \n"
"            real_y += y_offset;                                               \n"
"                                                                              \n"
"          v = inten > real_y ? 1.0f : 0.0f;                                   \n"
"                                                                              \n"
"          if (limit)                                                          \n"
"            {                                                                 \n"
"              if (real_y == 0)                                                \n"
"                v = 1.0f;                                                     \n"
"              else if (real_y == in_rect->height - 1)                         \n"
"                v = 0.0f;                                                     \n"
"            }                                                                 \n"
"                                                                              \n"
"          out_row[(x + y * out_rect->width) * 2] = v;                         \n"
"                                                                              \n"
"          /* restore alpha */                                                 \n"
"          out_row[(x + y * out_rect->width) * 2 + 1] = in_row[(x + real_y * in_rect->width) * 2 + 1];\n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties          *o = GEGL_PROPERTIES (operation);                   \n"
"  const Babl              *format = babl_format (\"Y'A float\");              \n"
"                                                                              \n"
"  area->left = area->right  = 0;                                              \n"
"  area->top  = area->bottom = o->row_height;                                  \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (in_rect)                                                                \n"
"  {                                                                           \n"
"    result = *in_rect;                                                        \n"
"  }                                                                           \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl     *format = babl_format (\"Y'A float\");                       \n"
"                                                                              \n"
"  GeglRectangle *whole_region;                                                \n"
"  GeglRectangle in_rect;                                                      \n"
"  GeglRectangle out_rect;                                                     \n"
"                                                                              \n"
"  gint row_count;                                                             \n"
"  gint top_offset, bottom_offset;                                             \n"
"  gint extended_roi_y, extended_roi_height;                                   \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  top_offset = roi->y % o->row_height;                                        \n"
"  bottom_offset = (roi->y + roi->height) % o->row_height;                     \n"
"                                                                              \n"
"  extended_roi_y = roi->y - top_offset;                                       \n"
"  extended_roi_height = roi->height + top_offset + (o->row_height - bottom_offset);\n"
"                                                                              \n"
"  row_count = extended_roi_height / o->row_height;                            \n"
"                                                                              \n"
"  for (i = 0; i < row_count; i++)                                             \n"
"    {                                                                         \n"
"      gfloat *in_buf;                                                         \n"
"      gfloat *out_buf;                                                        \n"
"      gint   in_y;                                                            \n"
"                                                                              \n"
"      in_y = extended_roi_y + i * o->row_height;                              \n"
"                                                                              \n"
"      gegl_rectangle_set (&in_rect, roi->x, in_y, roi->width, o->row_height); \n"
"      gegl_rectangle_intersect (&in_rect, &in_rect, whole_region);            \n"
"                                                                              \n"
"      gegl_rectangle_set (&out_rect, roi->x, in_y, roi->width, o->row_height);\n"
"      gegl_rectangle_intersect (&out_rect, &out_rect, roi);                   \n"
"                                                                              \n"
"      in_buf = g_new (gfloat, in_rect.width * in_rect.height * 2);            \n"
"      out_buf = g_new (gfloat, out_rect.width * out_rect.height * 2);         \n"
"                                                                              \n"
"      gegl_buffer_get (input, &in_rect, 1.0, format, in_buf,                  \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"                                                                              \n"
"      engrave_row (in_buf, &in_rect, out_buf, &out_rect, o->limit);           \n"
"                                                                              \n"
"      gegl_buffer_set (output, &out_rect, 0, format, out_buf,                 \n"
"                       GEGL_AUTO_ROWSTRIDE);                                  \n"
"                                                                              \n"
"      g_free (in_buf);                                                        \n"
"      g_free (out_buf);                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process             = process;                                \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:engrave\",                                        \n"
"    \"title\",       _(\"Engrave\"),                                          \n"
"    \"categories\",  \"distort\",                                             \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Simulate an antique engraving\"),                    \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
