static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2003, 2006 Øyvind Kolås <pippin@gimp.org>                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"   description (_(\"Path of video file to load\"))                            \n"
"                                                                              \n"
"property_int (frame, _(\"Frame number\"), 0)                                  \n"
"   value_range (0, G_MAXINT)                                                  \n"
"   ui_range (0, 10000)                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE ff-load.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <errno.h>                                                            \n"
"                                                                              \n"
"#ifdef HAVE_LIBAVFORMAT_AVFORMAT_H                                            \n"
"#include <libavformat/avformat.h>                                             \n"
"#else                                                                         \n"
"#include <avformat.h>                                                         \n"
"#endif                                                                        \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble          frames;                                                    \n"
"  gint             width;                                                     \n"
"  gint             height;                                                    \n"
"  gdouble          fps;                                                       \n"
"  gchar           *codec_name;                                                \n"
"  gchar           *fourcc;                                                    \n"
"                                                                              \n"
"  int              video_stream;                                              \n"
"  AVFormatContext *ic;                                                        \n"
"  AVStream        *video_st;                                                  \n"
"  AVCodecContext  *enc;                                                       \n"
"  AVCodec         *codec;                                                     \n"
"  AVPacket         pkt;                                                       \n"
"  AVFrame         *lavc_frame;                                                \n"
"                                                                              \n"
"  glong            coded_bytes;                                               \n"
"  guchar          *coded_buf;                                                 \n"
"                                                                              \n"
"  gchar           *loadedfilename; /* to remember which file is \"cached\"     */\n"
"  glong            prevframe;      /* previously decoded frame in loadedfile */\n"
"} Priv;                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"print_error (const char *filename, int err)                                   \n"
"{                                                                             \n"
"  switch (err)                                                                \n"
"    {                                                                         \n"
"#if LIBAVFORMAT_VERSION_MAJOR >= 53                                           \n"
"    case AVERROR(EINVAL):                                                     \n"
"#else                                                                         \n"
"    case AVERROR_NUMEXPECTED:                                                 \n"
"#endif                                                                        \n"
"      g_warning (\"%s: Incorrect image filename syntax.\\n\"                  \n"
"                 \"Use '%%d' to specify the image number:\\n\"                \n"
"                 \"  for img1.jpg, img2.jpg, ..., use 'img%%d.jpg';\\n\"      \n"
"                 \"  for img001.jpg, img002.jpg, ..., use 'img%%03d.jpg'.\\n\",\n"
"                 filename);                                                   \n"
"      break;                                                                  \n"
"    case AVERROR_INVALIDDATA:                                                 \n"
"#if LIBAVFORMAT_VERSION_MAJOR >= 53                                           \n"
"      g_warning (\"%s: Error while parsing header or unknown format\\n\", filename);\n"
"#else                                                                         \n"
"      g_warning (\"%s: Error while parsing header\\n\", filename);            \n"
"      break;                                                                  \n"
"    case AVERROR_NOFMT:                                                       \n"
"      g_warning (\"%s: Unknown format\\n\", filename);                        \n"
"#endif                                                                        \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      g_warning (\"%s: Error while opening file\\n\", filename);              \n"
"      break;                                                                  \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  static gint inited = 0; /*< this is actually meant to be static, only to be done once */\n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  if (p==NULL)                                                                \n"
"    {                                                                         \n"
"      p = g_new0 (Priv, 1);                                                   \n"
"      o->user_data = (void*) p;                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->width = 320;                                                             \n"
"  p->height = 200;                                                            \n"
"                                                                              \n"
"  if (!inited)                                                                \n"
"    {                                                                         \n"
"      av_register_all ();                                                     \n"
"      avcodec_register_all ();                                                \n"
"      inited = 1;                                                             \n"
"    }                                                                         \n"
"  p->loadedfilename = g_strdup (\"\");                                        \n"
"  p->fourcc = g_strdup (\"\");                                                \n"
"  p->codec_name = g_strdup (\"\");                                            \n"
"}                                                                             \n"
"                                                                              \n"
"/* FIXME: probably some more stuff to free here */                            \n"
"static void                                                                   \n"
"ff_cleanup (GeglProperties *o)                                                \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"  if (p)                                                                      \n"
"    {                                                                         \n"
"      if (p->codec_name)                                                      \n"
"        g_free (p->codec_name);                                               \n"
"      if (p->loadedfilename)                                                  \n"
"        g_free (p->loadedfilename);                                           \n"
"                                                                              \n"
"      if (p->enc)                                                             \n"
"        avcodec_close (p->enc);                                               \n"
"      if (p->ic)                                                              \n"
"        avformat_close_input(&p->ic);                                         \n"
"      if (p->lavc_frame)                                                      \n"
"        av_free (p->lavc_frame);                                              \n"
"                                                                              \n"
"      p->enc = NULL;                                                          \n"
"      p->ic = NULL;                                                           \n"
"      p->lavc_frame = NULL;                                                   \n"
"      p->codec_name = NULL;                                                   \n"
"      p->loadedfilename = NULL;                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static glong                                                                  \n"
"prev_keyframe (Priv *priv, glong frame)                                       \n"
"{                                                                             \n"
"  /* no way to detect previous keyframe at the moment for ffmpeg,             \n"
"     so we'll just return 0, the first, and a forced reload happens           \n"
"     if needed                                                                \n"
"   */                                                                         \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"decode_frame (GeglOperation *operation,                                       \n"
"              glong          frame)                                           \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"  glong       prevframe = p->prevframe;                                       \n"
"  glong       decodeframe;        /*< frame to be requested decoded */        \n"
"                                                                              \n"
"  if (frame >= p->frames)                                                     \n"
"    {                                                                         \n"
"      frame = p->frames - 1;                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (frame < 0)                                                              \n"
"    {                                                                         \n"
"      frame = 0;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (frame == prevframe)                                                     \n"
"    {                                                                         \n"
"      return 0;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* figure out which frame we should start decoding at */                    \n"
"                                                                              \n"
"  if (frame == prevframe + 1)                                                 \n"
"    {                                                                         \n"
"      decodeframe = prevframe + 1;                                            \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      decodeframe = prev_keyframe (p, frame);                                 \n"
"      if (prevframe > decodeframe && prevframe < frame)                       \n"
"        decodeframe = prevframe + 1;                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (decodeframe < prevframe)                                                \n"
"    {                                                                         \n"
"      /* seeking backwards, since it ffmpeg doesn't allow us,. we'll reload the file */\n"
"      g_free (p->loadedfilename);                                             \n"
"      p->loadedfilename = NULL;                                               \n"
"      init (o);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (decodeframe <= frame)                                                \n"
"    {                                                                         \n"
"      int       got_picture = 0;                                              \n"
"                                                                              \n"
"      do                                                                      \n"
"        {                                                                     \n"
"          int       decoded_bytes;                                            \n"
"                                                                              \n"
"          if (p->coded_bytes <= 0)                                            \n"
"            {                                                                 \n"
"              do                                                              \n"
"                {                                                             \n"
"                  if (av_read_frame (p->ic, &p->pkt) < 0)                     \n"
"                    {                                                         \n"
"                      fprintf (stderr, \"av_read_frame failed for %s\\n\",    \n"
"                               o->path);                                      \n"
"                      return -1;                                              \n"
"                    }                                                         \n"
"                }                                                             \n"
"              while (p->pkt.stream_index != p->video_stream);                 \n"
"                                                                              \n"
"              p->coded_bytes = p->pkt.size;                                   \n"
"              p->coded_buf = p->pkt.data;                                     \n"
"            }                                                                 \n"
"          decoded_bytes =                                                     \n"
"            avcodec_decode_video2 (p->video_st->codec, p->lavc_frame,         \n"
"                                  &got_picture, &p->pkt);                     \n"
"          if (decoded_bytes < 0)                                              \n"
"            {                                                                 \n"
"              fprintf (stderr, \"avcodec_decode_video failed for %s\\n\",     \n"
"                       o->path);                                              \n"
"              return -1;                                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          p->coded_buf += decoded_bytes;                                      \n"
"          p->coded_bytes -= decoded_bytes;                                    \n"
"        }                                                                     \n"
"      while (!got_picture);                                                   \n"
"                                                                              \n"
"      decodeframe++;                                                          \n"
"    }                                                                         \n"
"  p->prevframe = frame;                                                       \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"  g_assert (o->user_data != NULL);                                            \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A u8\"));\n"
"                                                                              \n"
"                                                                              \n"
"  if (!p->loadedfilename ||                                                   \n"
"      strcmp (p->loadedfilename, o->path))                                    \n"
"    {                                                                         \n"
"      gint i;                                                                 \n"
"      gint err;                                                               \n"
"                                                                              \n"
"      ff_cleanup (o);                                                         \n"
"      err = avformat_open_input(&p->ic, o->path, NULL, 0);                    \n"
"      if (err < 0)                                                            \n"
"        {                                                                     \n"
"          print_error (o->path, err);                                         \n"
"        }                                                                     \n"
"      err = avformat_find_stream_info (p->ic, NULL);                          \n"
"      if (err < 0)                                                            \n"
"        {                                                                     \n"
"          g_warning (\"ff-load: error finding stream info for %s\", o->path); \n"
"                                                                              \n"
"          return;                                                             \n"
"        }                                                                     \n"
"      for (i = 0; i< p->ic->nb_streams; i++)                                  \n"
"        {                                                                     \n"
"          AVCodecContext *c = p->ic->streams[i]->codec;                       \n"
"#if LIBAVFORMAT_VERSION_MAJOR >= 53                                           \n"
"          if (c->codec_type == AVMEDIA_TYPE_VIDEO)                            \n"
"#else                                                                         \n"
"          if (c->codec_type == CODEC_TYPE_VIDEO)                              \n"
"#endif                                                                        \n"
"            {                                                                 \n"
"              p->video_st = p->ic->streams[i];                                \n"
"              p->video_stream = i;                                            \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->enc = p->video_st->codec;                                            \n"
"      p->codec = avcodec_find_decoder (p->enc->codec_id);                     \n"
"                                                                              \n"
"      /* p->enc->error_resilience = 2; */                                     \n"
"      p->enc->error_concealment = 3;                                          \n"
"      p->enc->workaround_bugs = FF_BUG_AUTODETECT;                            \n"
"                                                                              \n"
"      if (p->codec == NULL)                                                   \n"
"        {                                                                     \n"
"          g_warning (\"codec not found\");                                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (p->codec->capabilities & CODEC_CAP_TRUNCATED)                       \n"
"        p->enc->flags |= CODEC_FLAG_TRUNCATED;                                \n"
"                                                                              \n"
"      if (avcodec_open2 (p->enc, p->codec, NULL) < 0)                         \n"
"        {                                                                     \n"
"          g_warning (\"error opening codec %s\", p->enc->codec->name);        \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->width = p->enc->width;                                               \n"
"      p->height = p->enc->height;                                             \n"
"      p->frames = 10000000;                                                   \n"
"      p->lavc_frame = avcodec_alloc_frame ();                                 \n"
"                                                                              \n"
"      if (p->fourcc)                                                          \n"
"        g_free (p->fourcc);                                                   \n"
"      p->fourcc = g_strdup (\"none\");                                        \n"
"          p->fourcc[0] = (p->enc->codec_tag) & 0xff;                          \n"
"      p->fourcc[1] = (p->enc->codec_tag >> 8) & 0xff;                         \n"
"      p->fourcc[2] = (p->enc->codec_tag >> 16) & 0xff;                        \n"
"      p->fourcc[3] = (p->enc->codec_tag >> 24) & 0xff;                        \n"
"                                                                              \n"
"      if (p->codec_name)                                                      \n"
"        g_free (p->codec_name);                                               \n"
"      if (p->codec->name)                                                     \n"
"        {                                                                     \n"
"          p->codec_name = g_strdup (p->codec->name);                          \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          p->codec_name = g_strdup (\"\");                                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (p->loadedfilename)                                                  \n"
"        g_free (p->loadedfilename);                                           \n"
"      p->loadedfilename = g_strdup (o->path);                                 \n"
"      p->prevframe = -1;                                                      \n"
"      p->coded_bytes = 0;                                                     \n"
"      p->coded_buf = NULL;                                                    \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {0,0,320,200};                                       \n"
"  Priv *p = (Priv*)GEGL_PROPERTIES (operation)->user_data;                    \n"
"  result.width = p->width;                                                    \n"
"  result.height = p->height;                                                  \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  {                                                                           \n"
"    if (p->ic && !decode_frame (operation, o->frame))                         \n"
"      {                                                                       \n"
"        guchar *buf;                                                          \n"
"        gint    pxsize;                                                       \n"
"        gint    x,y;                                                          \n"
"                                                                              \n"
"                                                                              \n"
"        g_object_get (output, \"px-size\", &pxsize, NULL);                    \n"
"        buf = g_new (guchar, p->width * p->height * pxsize);                  \n"
"                                                                              \n"
"        for (y=0; y < p->height; y++)                                         \n"
"          {                                                                   \n"
"            guchar       *dst  = buf + y * p->width * 4;                      \n"
"            const guchar *ysrc = p->lavc_frame->data[0] + y * p->lavc_frame->linesize[0];\n"
"            const guchar *usrc = p->lavc_frame->data[1] + y/2 * p->lavc_frame->linesize[1];\n"
"            const guchar *vsrc = p->lavc_frame->data[2] + y/2 * p->lavc_frame->linesize[2];\n"
"                                                                              \n"
"            for (x=0;x < p->width; x++)                                       \n"
"              {                                                               \n"
"                gint R,G,B;                                                   \n"
"#ifndef byteclamp                                                             \n"
"#define byteclamp(j) do{if(j<0)j=0; else if(j>255)j=255;}while(0)             \n"
"#endif                                                                        \n"
"#define YUV82RGB8(Y,U,V,R,G,B)do{\\                                           \n"
"                R= ((Y<<15)                 + 37355*(V-128))>>15;\\           \n"
"                G= ((Y<<15) -12911* (U-128) - 19038*(V-128))>>15;\\           \n"
"                B= ((Y<<15) +66454* (U-128)                )>>15;\\           \n"
"                byteclamp(R);\\                                               \n"
"                byteclamp(G);\\                                               \n"
"                byteclamp(B);\\                                               \n"
"              } while(0)                                                      \n"
"                                                                              \n"
"              YUV82RGB8 (*ysrc, *usrc, *vsrc, R, G, B);                       \n"
"                                                                              \n"
"              *(unsigned int *) dst = R + G * 256 + B * 256 * 256 + 0xff000000;\n"
"              dst += 4;                                                       \n"
"              ysrc ++;                                                        \n"
"              if (x % 2)                                                      \n"
"                {                                                             \n"
"                  usrc++;                                                     \n"
"                  vsrc++;                                                     \n"
"                }                                                             \n"
"              }                                                               \n"
"          }                                                                   \n"
"        gegl_buffer_set (output, NULL, 0, NULL, buf, GEGL_AUTO_ROWSTRIDE);    \n"
"        g_free (buf);                                                         \n"
"      }                                                                       \n"
"  }                                                                           \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"                                                                              \n"
"      g_free (p->loadedfilename);                                             \n"
"      g_free (p->fourcc);                                                     \n"
"      g_free (p->codec_name);                                                 \n"
"                                                                              \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:ff-load\",                                       \n"
"    \"title\",        _(\"FFmpeg Frame Loader\"),                             \n"
"    \"categories\"  , \"input:video\",                                        \n"
"    \"description\" , _(\"FFmpeg video frame importer.\"),                    \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
