/**
 * @file geis_xcb_backend_sub_table.h
 * @brief GEIS XCB subscription table
 *
 * Copyright 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef GEIS_XCB_BACKEND_SUB_TABLE_H_
#define GEIS_XCB_BACKEND_SUB_TABLE_H_

#include "geis_xcb_backend_token.h"


/**
 * A table of XCB subscriptions.
 */
typedef struct GeisXcbBackendSubTable *GeisXcbBackendSubTable;

/**
 * Creates a new XCB subscription table.
 */
GeisXcbBackendSubTable geis_xcb_backend_sub_table_new();

/**
 * Destroys an XCB subscription table.
 */
void geis_xcb_backend_sub_table_delete(GeisXcbBackendSubTable table);

/**
 * Adds a new entry to an XCB subscription table.
 */
void geis_xcb_backend_sub_table_insert(GeisXcbBackendSubTable table,
                                       xcb_window_t           window_id,
                                       uint16_t               device_id,
                                       XcbBackendToken        token);

/**
 * Removes all entries matching a given token from an XCB subscription table.
 */
void geis_xcb_backend_sub_table_remove_token(GeisXcbBackendSubTable table,
                                             XcbBackendToken        token);

/**
 * A callback type for processing elements in the table.
 */
typedef void (*GeisXcbBackendSubTableFunction)(XcbBackendToken  token,
                                               void            *context);

/**
 * Executes a function for all entires in an XCB subscription table matching
 * given criteria.
 */
void geis_xcb_backend_sub_table_foreach(GeisXcbBackendSubTable          table,
                                        xcb_window_t                    window_id,
                                        uint16_t                        device_id,
                                        GeisXcbBackendSubTableFunction  function,
                                        void                           *context);

#endif /* GEIS_XCB_BACKEND_SUB_TABLE_H_ */
