/**
 * @file geis_xcb_backend_token.h
 * @brief GEIS filter token for the XCB-based grail back end
 *
 * Copyright 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef GEIS_XCB_BACKEND_TOKEN_H_
#define GEIS_XCB_BACKEND_TOKEN_H_

#include "geis_backend_protected.h"
#include <xcb/xcb.h>

typedef struct XcbBackendToken *XcbBackendToken;

GeisBackendToken geis_xcb_token_new(GeisBackend be, GeisBackendTokenInitState);

void geis_xcb_token_set_xcb(GeisBackendToken, xcb_connection_t *xcb_connection);

GeisStatus geis_xcb_token_add_class_term(GeisBackendToken     gbtoken,
                                         void                *context,
                                         GeisString           name,
                                         GeisFilterOperation  op,
                                         void                *value);

GeisStatus geis_xcb_token_add_device_term(GeisBackendToken     gbtoken,
                                          void                *context,
                                          GeisString           name,
                                          GeisFilterOperation  op,
                                          void                *value);

GeisStatus geis_xcb_token_add_region_term(GeisBackendToken     gbtoken,
                                          void                *context,
                                          GeisString           name,
                                          GeisFilterOperation  op,
                                          void                *value);

GeisStatus geis_xcb_token_add_feature_term(GeisBackendToken     gbtoken,
                                           void                *context,
                                           GeisString           name,
                                           GeisFilterOperation  op,
                                           void                *value);


/**
 * Gets the number of devices on a token.
 */
uint16_t geis_xcb_token_device_count(XcbBackendToken token);

/**
 * Gets an indicated device from a tken.
 */
uint16_t geis_xcb_token_device(XcbBackendToken token, uint16_t index);

/**
 * Gets the number of windowids on a token.
 */
int geis_xcb_token_window_count(XcbBackendToken token);

/**
 * Gets an indicated window from a token.
 */
xcb_window_t geis_xcb_token_window(XcbBackendToken token, int index);

/**
 * Gets the size of the grail bitmask on the token.
 */
uint16_t geis_xcb_token_grail_mask_len(XcbBackendToken token);

/**
 * Gets the grail bitmask fro the token.
 */
uint32_t* geis_xcb_token_grail_mask(XcbBackendToken token);

#endif /* GEIS_XCB_BACKEND_TOKEN_H_ */
