/* gLife - An Artificial Life implementation using GNOME
 *
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

typedef struct {
	GladeXML *xml; /* Main XML path */
	GladeXML *pb_xml; /* XML Path for PropertyBox */
	
	GnomePropertyBox *pb;

	gint timeoutid;
	gboolean timeout_on;
	gint updatecounter;
} LifeData;

extern LifeData glife;
extern guint32 terrcolor;
extern guint32 malecolor;
extern guint32 femalecolor;

#define R_(x) (x >> 24)
#define G_(x) ((x >> 16) & 0xff)
#define B_(x) ((x >> 8) & 0xff)
#define A_(x) (x & 0xff)

/* #define RAND(x,y) ((lrand48() % (y-x)) + x) */
#define RAND(x,y) (((rand()>>6) % ((y-x)+1)) + x) /* goes from x to y */
