/**
 * GMyth Library
 *
 * @file gmyth/gmyth_debug.h
 * 
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Renato Filho <renato.filho@indt.org.br>
 *
* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU Lesser General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*/

#ifndef __GMYTH_DEBUG_H__
#define __GMYTH_DEBUG_H__

#include <stdarg.h>
#include <glib.h>
#include <time.h>

G_BEGIN_DECLS
#ifdef GMYTH_USE_DEBUG
#define gmyth_debug(...) gmyth_debug_real (__FUNCTION__, __FILE__, __LINE__, TRUE, __VA_ARGS__)
#else
#define gmyth_debug(...)
#endif
    void
gmyth_debug_real(const char *func,
                 const char *file, int line, gboolean newline,
                 const char *format, ...)
G_GNUC_PRINTF(5, 6);

G_END_DECLS
#endif
