/**
 * GMyth Library
 *
 * @file gmyth/gmyth_recorder.h
 * 
 * @brief <p> GMythRecorder defines functions for playing live tv.
 *
 * The remote encoder is used by gmyth_tvplayer to setup livetv. 
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Hallyson Luiz de Morais Melo <hallyson.melo@indt.org.br>
 * @author Rosfran Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_RECORDER_H__
#define __GMYTH_RECORDER_H__

#include <glib-object.h>

#include "gmyth_socket.h"
#include "gmyth_programinfo.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

G_BEGIN_DECLS
#define GMYTH_RECORDER_TYPE               (gmyth_recorder_get_type ())
#define GMYTH_RECORDER(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_RECORDER_TYPE, GMythRecorder))
#define GMYTH_RECORDER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_RECORDER_TYPE, GMythRecorderClass))
#define IS_GMYTH_RECORDER(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_RECORDER_TYPE))
#define IS_GMYTH_RECORDER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_RECORDER_TYPE))
#define GMYTH_RECORDER_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_RECORDER_TYPE, GMythRecorderClass))
typedef struct _GMythRecorder GMythRecorder;
typedef struct _GMythRecorderClass GMythRecorderClass;

struct _GMythRecorderClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
    /*
     * no one for now 
     */
};

struct _GMythRecorder {
    GObject         parent;

    /*
     * socket descriptor 
     */
    GMythSocket    *myth_socket;

    gint            recorder_num;
    GString        *hostname;
    gint            port;

    GList          *progs_info_list;

    GMutex         *mutex;
};

typedef enum _GMythRecorderChannelChangeDirection {
    CHANNEL_DIRECTION_UP = 0,
    CHANNEL_DIRECTION_DOWN,
    CHANNEL_DIRECTION_FAVORITE,
    CHANNEL_DIRECTION_SAME
} GMythRecorderChannelChangeDirection;

typedef enum _GMythRecorderBrowseDirection {
    BROWSE_DIRECTION_SAME = 0,  /* Stay in the same place */
    BROWSE_DIRECTION_UP,        /* Move up one slot (down one channel) */
    BROWSE_DIRECTION_DOWN,      /* Move down one slot (up one channel) */
    BROWSE_DIRECTION_LEFT,      /* Move left one slot (down one time slot) 
                                 */
    BROWSE_DIRECTION_RIGHT,     /* Move right one slot (up one time slot) */
    BROWSE_DIRECTION_FAVORITE   /* Move to the next favorite slot */
} GMythRecorderBrowseDirection;

GType           gmyth_recorder_get_type(void);

GMythRecorder  *gmyth_recorder_new(int num, GString * hostname,
                                   gshort port);

void            gmyth_recorder_close(GMythRecorder * recorder);

gboolean        gmyth_recorder_setup(GMythRecorder * recorder);
gboolean        gmyth_recorder_spawntv(GMythRecorder * recorder,
                                       GString * tvchain_id);

gboolean        gmyth_recorder_spawntv_no_tvchain(GMythRecorder *
                                                  recorder);

gboolean        gmyth_recorder_stop_livetv(GMythRecorder * recorder);

gboolean        gmyth_recorder_send_frontend_ready_command(GMythRecorder *
                                                           recorder);

gboolean        gmyth_recorder_check_channel(GMythRecorder * recorder,
                                             gint channel);

gboolean        gmyth_recorder_check_channel_name(GMythRecorder * recorder,
                                                  gchar * channel);

gboolean        gmyth_recorder_set_channel(GMythRecorder * recorder,
                                           gint channel);

gboolean        gmyth_recorder_set_channel_name(GMythRecorder * recorder,
                                                const gchar * channel);

gboolean        gmyth_recorder_change_channel(GMythRecorder * recorder, const
                                              GMythRecorderChannelChangeDirection
                                              direction);

GList          *gmyth_recorder_get_channel_list(GMythRecorder * recorder);

gboolean        gmyth_recorder_pause_recording(GMythRecorder * recorder);

GMythProgramInfo *gmyth_recorder_get_current_program_info(GMythRecorder *
                                                          recorder);

GMythProgramInfo *gmyth_recorder_get_next_program_info(GMythRecorder *
                                                       recorder, const
                                                       GMythRecorderBrowseDirection
                                                       direction);

GMythRecorder  *gmyth_recorder_get_recorder_from_num(gint rec_id);

gint64          gmyth_recorder_get_file_position(GMythRecorder * recorder);

gboolean        gmyth_recorder_is_recording(GMythRecorder * recorder);

gboolean        gmyth_recorder_finish_recording(GMythRecorder * recorder);

gboolean        gmyth_recorder_stop_playing(GMythRecorder * recorder);

gboolean        gmyth_recorder_free_tuner(GMythRecorder * recorder);

gdouble         gmyth_recorder_get_framerate(GMythRecorder * recorder);

G_END_DECLS
#endif                          /* __GMYTH_REMOTE_ENCODER_H__ */
