
#include <glib.h>
#include <gmyth/gmyth_transcoder.h>
#include <gmyth/gmyth_jobqueue.h>
#include <gmyth/gmyth_uri.h>
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_socket.h>
#include <gmyth/gmyth_query.h>

#include "common.h"

int
main(int args, const char **argv)
{
    GMythBackendInfo *backend_info;
    GMythTranscoder *transcode;
    g_type_init();
    g_thread_init(NULL);

    backend_info = gmyth_backend_info_new();
    gmyth_backend_info_set_hostname(backend_info, "192.168.3.165");
    gmyth_backend_info_set_port(backend_info, 6543);
    gmyth_backend_info_set_status_port(backend_info, 6544);

    transcode = gmyth_transcoder_new(backend_info);

    transcode->backend_info = backend_info;
    transcode->cutlist = TRUE;

    // gmyth_transcoder_set_output (transcode, TRUE, "/tmp/teste.mp4");
    // gmyth_transcoder_set_filename (transcode,
    // "1000_20070309160500.nuv");
    gmyth_transcoder_set_filename(transcode, "1000_20070319170000.nuv");
    int             teste =
        gmyth_jobqueue_add_job(transcode, "JOB_TRANSCODE");

    teste = gmyth_jobqueue_change_cmd(transcode, "STOP", "JOB_TRANSCODE");

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (transcode != NULL)
        g_object_unref(transcode);

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return (0);

}
