# misc utils
# (c) 2005 Canonical, GPL

import warnings
warnings.filterwarnings("ignore", "apt API not stable yet", FutureWarning)
import apt
import os

# Column enumeration

# Columns of the categories store
(COL_CAT_NAME,
 COL_CAT_ITEM) = range(0,2)

# Columns of the packages store
(COL_NAME,
 COL_ITEM,
 COL_POPCON) = range(3)

class MyCache(apt.Cache):
    def __init__(self, progress=None):
        apt.Cache.__init__(self, progress)
        # cache the arch we use
        pipe = os.popen("dpkg --print-architecture")
        self._arch = pipe.read().strip()
        del pipe
    
    def pkgDependsOn(self, pkgname, depends_name):
        """ check if a given pkg depends on a given dependencie """
        if not self.has_key(pkgname):
            return False
        pkg = self[pkgname]
        candver = self._depcache.GetCandidateVer(pkg._pkg)
	if candver == None:
		return False
	dependslist = candver.DependsList
	for dep in dependslist.keys():
            if dep == "Depends" or dep == "PreDepends":
                # get the list of each dependency object
                for depVerList in dependslist[dep]:
                    for z in depVerList:
                        # get all TargetVersions of
                        # the dependency object
                        for tpkg in z.AllTargets():
                            if depends_name == tpkg.ParentPkg.Name:
                                return True
        return False
    def clean(self):
        self._depcache.Init()
    def getArch(self):
        """ Return the cpu architecture of the system"""
        
        return self._arch

def xmlescape(s):
    from xml.sax.saxutils import escape
    if s==None:
        return ""
    else:
        return escape(s)


def iterate_list_store(store, it):
    """ iterate over a gtk tree-model, returns a gtk.TreeIter for each element
    """
    if not it:
        raise StopIteration
    yield it
    while True:
        it = store.iter_next(it)
        if it == None:
            raise StopIteration
        yield it
    


# class SimpleFilteredCache(apt.cache.FilteredCache):
#     """ a simpler version of the filtered cache that will not react to
#         cache changed (no need, we are only interessted in text)
#     """
#     def filterCachePostChange(self):
#         pass
#     def runFilter(self):
#         self._reapplyFilter()

# class SearchFilter(apt.cache.Filter):
#     """ a filter class that just searchs insensitive in name/description """
#     def SetSearchTerm(self, term):
#         self._term = term.lower()
#     def apply(self, pkg):
#         if self._term in pkg.name.lower() or \
#                self._term in pkg.description.lower():
#             return True
#         else:
#             return False
#     def __init__(self, query=None):
#         if query != None:
#             self.SetSearchTerm(query)



