/* math-window.c generated by valac 0.29.1, the Vala compiler
 * generated from math-window.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
typedef struct _MathWindowPrivate MathWindowPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BUTTON_MODE (button_mode_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MathWindow {
	GtkApplicationWindow parent_instance;
	MathWindowPrivate * priv;
};

struct _MathWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MathWindowPrivate {
	MathEquation* _equation;
	MathDisplay* _display;
	MathConverter* converter;
	MathButtons* _buttons;
	gboolean right_aligned;
	gboolean remove_buttons;
	GtkMenuButton* menu_button;
	GtkHeaderBar* headerbar;
	GtkBox* vbox;
	GtkLabel* mode_label;
};

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;


static gpointer math_window_parent_class = NULL;

GType math_window_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType math_display_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
#define MATH_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_WINDOW, MathWindowPrivate))
enum  {
	MATH_WINDOW_DUMMY_PROPERTY,
	MATH_WINDOW_EQUATION,
	MATH_WINDOW_DISPLAY,
	MATH_WINDOW_BUTTONS
};
static void math_window_copy_cb (MathWindow* self);
static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_paste_cb (MathWindow* self);
static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_undo_cb (MathWindow* self);
static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_redo_cb (MathWindow* self);
static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_mode_cb (MathWindow* self, GSimpleAction* action, GVariant* parameter);
static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self);
static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
void math_display_grabfocus (MathDisplay* self);
MathDisplay* math_window_get_display (MathWindow* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
GType button_mode_get_type (void) G_GNUC_CONST;
ButtonMode math_buttons_get_mode (MathButtons* self);
MathButtons* math_window_get_buttons (MathWindow* self);
static void math_window_mode_changed_cb (MathWindow* self);
static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents);
static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
MathEquation* math_window_get_equation (MathWindow* self);
void math_equation_set_number_base (MathEquation* self, gint value);
void math_equation_copy (MathEquation* self);
void math_equation_paste (MathEquation* self);
void math_display_grab_focus (MathDisplay* self);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
static void math_window_finalize (GObject* obj);
static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);

static const GActionEntry MATH_WINDOW_window_entries[5] = {{"copy", _math_window_copy_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"paste", _math_window_paste_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"undo", _math_window_undo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"redo", _math_window_redo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"mode", _math_window_mode_cb_gsimple_action_activate_callback, "s", "\"basic\"", NULL}};

static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_copy_cb ((MathWindow*) self);
#line 183 "math-window.c"
}


static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_paste_cb ((MathWindow*) self);
#line 190 "math-window.c"
}


static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_undo_cb ((MathWindow*) self);
#line 197 "math-window.c"
}


static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_redo_cb ((MathWindow*) self);
#line 204 "math-window.c"
}


static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_mode_cb ((MathWindow*) self, action, parameter);
#line 211 "math-window.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 218 "math-window.c"
}


static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_scroll_changed_cb ((MathWindow*) self, _sender);
#line 225 "math-window.c"
}


static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_scroll_value_changed_cb ((MathWindow*) self, _sender);
#line 232 "math-window.c"
}


static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_mode_changed_cb ((MathWindow*) self);
#line 239 "math-window.c"
}


MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation) {
	MathWindow * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	MathConverter* _tmp5_ = NULL;
	MathConverter* _tmp6_ = NULL;
	MathConverter* _tmp7_ = NULL;
	MathEquation* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	MathEquation* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp16_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkArrow* arrow = NULL;
	GtkArrow* _tmp20_ = NULL;
	GtkArrow* _tmp21_ = NULL;
	GtkBox* menu_box = NULL;
	GtkBox* _tmp22_ = NULL;
	GtkBox* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkBox* _tmp25_ = NULL;
	GtkArrow* _tmp26_ = NULL;
	GtkBox* _tmp27_ = NULL;
	GtkMenuButton* _tmp28_ = NULL;
	GtkMenuButton* _tmp29_ = NULL;
	GtkBox* _tmp30_ = NULL;
	GtkMenuButton* _tmp31_ = NULL;
	GObject* _tmp32_ = NULL;
	GtkMenuButton* _tmp33_ = NULL;
	GtkStyleContext* _tmp34_ = NULL;
	GtkMenuButton* _tmp35_ = NULL;
	GtkStyleContext* _tmp36_ = NULL;
	GtkMenuButton* _tmp37_ = NULL;
	GtkMenuButton* _tmp38_ = NULL;
	GtkMenuButton* _tmp39_ = NULL;
	GtkHeaderBar* _tmp40_ = NULL;
	GtkHeaderBar* _tmp41_ = NULL;
	GtkHeaderBar* _tmp42_ = NULL;
	GtkMenuButton* _tmp43_ = NULL;
	GtkHeaderBar* _tmp44_ = NULL;
	GtkHeaderBar* _tmp45_ = NULL;
	GtkBox* main_vbox = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkBox* _tmp47_ = NULL;
	GtkBox* _tmp48_ = NULL;
	GtkBox* _tmp49_ = NULL;
	GtkBox* _tmp50_ = NULL;
	GtkBox* _tmp51_ = NULL;
	GtkBox* _tmp52_ = NULL;
	MathConverter* _tmp53_ = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkBox* _tmp55_ = NULL;
	GtkBox* _tmp56_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp57_ = NULL;
	GtkScrolledWindow* _tmp58_ = NULL;
	GtkScrolledWindow* _tmp59_ = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkScrolledWindow* _tmp61_ = NULL;
	GtkScrolledWindow* _tmp62_ = NULL;
	GtkAdjustment* _tmp63_ = NULL;
	GtkScrolledWindow* _tmp64_ = NULL;
	GtkAdjustment* _tmp65_ = NULL;
	GtkScrolledWindow* _tmp66_ = NULL;
	MathEquation* _tmp67_ = NULL;
	MathDisplay* _tmp68_ = NULL;
	MathDisplay* _tmp69_ = NULL;
	GtkScrolledWindow* _tmp70_ = NULL;
	MathDisplay* _tmp71_ = NULL;
	MathDisplay* _tmp72_ = NULL;
	MathDisplay* _tmp73_ = NULL;
	MathDisplay* _tmp74_ = NULL;
	MathEquation* _tmp75_ = NULL;
	MathButtons* _tmp76_ = NULL;
	MathButtons* _tmp77_ = NULL;
	ButtonMode _tmp78_ = 0;
	ButtonMode _tmp79_ = 0;
	MathButtons* _tmp85_ = NULL;
	MathButtons* _tmp86_ = NULL;
	MathButtons* _tmp87_ = NULL;
	MathButtons* _tmp88_ = NULL;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp89_ = NULL;
	GFile* file = NULL;
	GFile* _tmp90_ = NULL;
	GError * _inner_error_ = NULL;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_val_if_fail (equation != NULL, NULL);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = app;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self = (MathWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = equation;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->_equation);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->_equation = _tmp2_;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp3_ = _ ("Calculator");
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp3_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_window_set_role ((GtkWindow*) self, "gnome-calculator");
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp4_ = self->priv->_equation;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp5_ = math_converter_new (_tmp4_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp5_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->converter);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->converter = _tmp5_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp6_ = self->priv->converter;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_converter_set_category (_tmp6_, NULL);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp7_ = self->priv->converter;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp8_ = equation;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp9_ = math_equation_get_source_units (_tmp8_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp10_ = _tmp9_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp11_ = _tmp10_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp12_ = equation;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp13_ = math_equation_get_target_units (_tmp12_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp14_ = _tmp13_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp15_ = _tmp14_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_converter_set_conversion (_tmp7_, _tmp11_, _tmp15_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_free0 (_tmp15_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_free0 (_tmp11_);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, MATH_WINDOW_window_entries, G_N_ELEMENTS (MATH_WINDOW_window_entries), self);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp16_ = gtk_builder_new ();
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	builder = _tmp16_;
#line 406 "math-window.c"
	{
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_builder_add_from_resource (builder, "/org/gnome/calculator/menu.ui", &_inner_error_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 412 "math-window.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_ = NULL;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		e = _inner_error_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_inner_error_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp17_ = e->message;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_error ("math-window.vala:60: Error loading menu UI: %s", _tmp17_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_error_free0 (e);
#line 431 "math-window.c"
	}
	__finally12:
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (builder);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_clear_error (&_inner_error_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		return NULL;
#line 444 "math-window.c"
	}
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp18_ = (GtkLabel*) gtk_label_new (NULL);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp18_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->mode_label);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->mode_label = _tmp18_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp19_ = self->priv->mode_label;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp19_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp20_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_NONE);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp20_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	arrow = _tmp20_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp21_ = arrow;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp21_);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp22_);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	menu_box = _tmp22_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp23_ = menu_box;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp24_ = self->priv->mode_label;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_box_pack_start (_tmp23_, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp25_ = menu_box;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp26_ = arrow;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp27_ = menu_box;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp27_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp28_ = (GtkMenuButton*) gtk_menu_button_new ();
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp28_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->menu_button);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->menu_button = _tmp28_;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp29_ = self->priv->menu_button;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp30_ = menu_box;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp31_ = self->priv->menu_button;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp32_ = gtk_builder_get_object (builder, "window-menu");
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_menu_button_set_menu_model (_tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, g_menu_model_get_type (), GMenuModel));
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp33_ = self->priv->menu_button;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) _tmp33_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_style_context_add_class (_tmp34_, "title");
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp35_ = self->priv->menu_button;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp36_ = gtk_widget_get_style_context ((GtkWidget*) _tmp35_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_style_context_add_class (_tmp36_, "text-button");
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp37_ = self->priv->menu_button;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_menu_button_set_use_popover (_tmp37_, TRUE);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp38_ = self->priv->menu_button;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_button_set_relief ((GtkButton*) _tmp38_, GTK_RELIEF_NONE);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp39_ = self->priv->menu_button;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp39_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp40_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp40_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->headerbar = _tmp40_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp41_ = self->priv->headerbar;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_header_bar_set_show_close_button (_tmp41_, TRUE);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp42_ = self->priv->headerbar;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp43_ = self->priv->menu_button;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_header_bar_set_custom_title (_tmp42_, (GtkWidget*) _tmp43_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp44_ = self->priv->headerbar;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp44_);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp45_ = self->priv->headerbar;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp45_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp46_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	main_vbox = _tmp46_;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp47_ = main_vbox;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp47_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp48_ = main_vbox;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp48_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp49_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp49_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->vbox);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->vbox = _tmp49_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp50_ = self->priv->vbox;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp50_, (guint) 6);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp51_ = self->priv->vbox;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp51_, TRUE);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp52_ = self->priv->vbox;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp53_ = self->priv->converter;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, FALSE, TRUE, (guint) 0);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp54_ = main_vbox;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp55_ = self->priv->vbox;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_box_pack_start (_tmp54_, (GtkWidget*) _tmp55_, TRUE, TRUE, (guint) 0);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp56_ = self->priv->vbox;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp56_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp57_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp57_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	scrolled_window = _tmp57_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp58_ = scrolled_window;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_scrolled_window_set_policy (_tmp58_, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp59_ = scrolled_window;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_scrolled_window_set_shadow_type (_tmp59_, GTK_SHADOW_IN);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp60_ = self->priv->vbox;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp61_ = scrolled_window;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_box_pack_start (_tmp60_, (GtkWidget*) _tmp61_, FALSE, TRUE, (guint) 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp62_ = scrolled_window;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp63_ = gtk_scrolled_window_get_hadjustment (_tmp62_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_signal_connect_object (_tmp63_, "changed", (GCallback) _math_window_scroll_changed_cb_gtk_adjustment_changed, self, 0);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp64_ = scrolled_window;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp65_ = gtk_scrolled_window_get_hadjustment (_tmp64_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_signal_connect_object (_tmp65_, "value-changed", (GCallback) _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed, self, 0);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->right_aligned = TRUE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp66_ = scrolled_window;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp66_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp67_ = equation;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp68_ = math_display_new (_tmp67_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp68_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->_display);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->_display = _tmp68_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp69_ = self->priv->_display;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_display_grabfocus (_tmp69_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp70_ = scrolled_window;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp71_ = math_window_get_display (self);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp72_ = _tmp71_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp72_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp73_ = math_window_get_display (self);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp74_ = _tmp73_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp74_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp75_ = equation;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp76_ = math_buttons_new (_tmp75_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp76_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->_buttons);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv->_buttons = _tmp76_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp77_ = self->priv->_buttons;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp78_ = math_buttons_get_mode (_tmp77_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp79_ = _tmp78_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (_tmp79_ != BUTTON_MODE_KEYBOARD) {
#line 690 "math-window.c"
		GtkBox* _tmp80_ = NULL;
		MathButtons* _tmp81_ = NULL;
		MathButtons* _tmp82_ = NULL;
		MathConverter* _tmp83_ = NULL;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp80_ = self->priv->vbox;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp81_ = math_window_get_buttons (self);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp82_ = _tmp81_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_box_pack_start (_tmp80_, (GtkWidget*) _tmp82_, TRUE, TRUE, (guint) 0);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		self->priv->remove_buttons = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp83_ = self->priv->converter;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp83_, FALSE);
#line 709 "math-window.c"
	} else {
		MathConverter* _tmp84_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		self->priv->remove_buttons = TRUE;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp84_ = self->priv->converter;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp84_, TRUE);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_window_set_resizable ((GtkWindow*) self, TRUE);
#line 720 "math-window.c"
	}
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp85_ = math_window_get_buttons (self);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp86_ = _tmp85_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp86_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp87_ = math_window_get_buttons (self);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp88_ = _tmp87_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_signal_connect_object ((GObject*) _tmp88_, "notify::mode", (GCallback) _math_window_mode_changed_cb_g_object_notify, self, 0);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_mode_changed_cb (self);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp89_ = gtk_css_provider_new ();
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	provider = _tmp89_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp90_ = g_file_new_for_uri ("resource:///org/gnome/calculator/calculator.css");
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	file = _tmp90_;
#line 744 "math-window.c"
	{
		gboolean _tmp91_ = FALSE;
		gboolean _tmp92_ = FALSE;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp92_ = gtk_css_provider_load_from_file (provider, file, &_inner_error_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp91_ = _tmp92_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 754 "math-window.c"
			goto __catch13_g_error;
		}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		if (_tmp91_) {
#line 759 "math-window.c"
			GdkScreen* _tmp93_ = NULL;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp93_ = gtk_window_get_screen ((GtkWindow*) self);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_style_context_add_provider_for_screen (_tmp93_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 765 "math-window.c"
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		e = _inner_error_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_inner_error_ = NULL;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp94_ = e;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp95_ = _tmp94_->message;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_warning ("math-window.vala:144: Error while loading css: %s", _tmp95_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_error_free0 (e);
#line 786 "math-window.c"
	}
	__finally13:
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (file);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (provider);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (scrolled_window);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (main_vbox);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (menu_box);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (arrow);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_g_object_unref0 (builder);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_clear_error (&_inner_error_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		return NULL;
#line 811 "math-window.c"
	}
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (file);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (provider);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (scrolled_window);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (main_vbox);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (menu_box);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (arrow);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (builder);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	return self;
#line 829 "math-window.c"
}


MathWindow* math_window_new (GtkApplication* app, MathEquation* equation) {
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	return math_window_construct (TYPE_MATH_WINDOW, app, equation);
#line 836 "math-window.c"
}


static void math_window_mode_changed_cb (MathWindow* self) {
	GSimpleAction* action = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	MathButtons* _tmp2_ = NULL;
	MathButtons* _tmp3_ = NULL;
	ButtonMode _tmp4_ = 0;
	ButtonMode _tmp5_ = 0;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	action = _tmp1_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp2_ = math_window_get_buttons (self);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp3_ = _tmp2_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp4_ = math_buttons_get_mode (_tmp3_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp5_ = _tmp4_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	switch (_tmp5_) {
#line 868 "math-window.c"
		default:
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case BUTTON_MODE_BASIC:
#line 872 "math-window.c"
		{
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GSimpleAction* _tmp8_ = NULL;
			GVariant* _tmp9_ = NULL;
			GVariant* _tmp10_ = NULL;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp6_ = self->priv->mode_label;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp7_ = _ ("Basic Mode");
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_label_set_label (_tmp6_, _tmp7_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp8_ = action;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp9_ = g_variant_new_string ("basic");
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_variant_ref_sink (_tmp9_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp10_ = _tmp9_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_simple_action_set_state (_tmp8_, _tmp10_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_g_variant_unref0 (_tmp10_);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			break;
#line 899 "math-window.c"
		}
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case BUTTON_MODE_ADVANCED:
#line 903 "math-window.c"
		{
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GSimpleAction* _tmp13_ = NULL;
			GVariant* _tmp14_ = NULL;
			GVariant* _tmp15_ = NULL;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp11_ = self->priv->mode_label;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp12_ = _ ("Advanced Mode");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_label_set_label (_tmp11_, _tmp12_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp13_ = action;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp14_ = g_variant_new_string ("advanced");
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_variant_ref_sink (_tmp14_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp15_ = _tmp14_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_simple_action_set_state (_tmp13_, _tmp15_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_g_variant_unref0 (_tmp15_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			break;
#line 930 "math-window.c"
		}
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case BUTTON_MODE_FINANCIAL:
#line 934 "math-window.c"
		{
			GtkLabel* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			GSimpleAction* _tmp18_ = NULL;
			GVariant* _tmp19_ = NULL;
			GVariant* _tmp20_ = NULL;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp16_ = self->priv->mode_label;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp17_ = _ ("Financial Mode");
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_label_set_label (_tmp16_, _tmp17_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp18_ = action;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp19_ = g_variant_new_string ("financial");
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_variant_ref_sink (_tmp19_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp20_ = _tmp19_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_simple_action_set_state (_tmp18_, _tmp20_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_g_variant_unref0 (_tmp20_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			break;
#line 961 "math-window.c"
		}
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case BUTTON_MODE_PROGRAMMING:
#line 965 "math-window.c"
		{
			GtkLabel* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GSimpleAction* _tmp23_ = NULL;
			GVariant* _tmp24_ = NULL;
			GVariant* _tmp25_ = NULL;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp21_ = self->priv->mode_label;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp22_ = _ ("Programming Mode");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_label_set_label (_tmp21_, _tmp22_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp23_ = action;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp24_ = g_variant_new_string ("programming");
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_variant_ref_sink (_tmp24_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp25_ = _tmp24_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_simple_action_set_state (_tmp23_, _tmp25_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_g_variant_unref0 (_tmp25_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			break;
#line 992 "math-window.c"
		}
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case BUTTON_MODE_KEYBOARD:
#line 996 "math-window.c"
		{
			GtkLabel* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			GSimpleAction* _tmp28_ = NULL;
			GVariant* _tmp29_ = NULL;
			GVariant* _tmp30_ = NULL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp26_ = self->priv->mode_label;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp27_ = _ ("Keyboard Mode");
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_label_set_label (_tmp26_, _tmp27_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp28_ = action;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp29_ = g_variant_new_string ("keyboard");
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_variant_ref_sink (_tmp29_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp30_ = _tmp29_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			g_simple_action_set_state (_tmp28_, _tmp30_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_g_variant_unref0 (_tmp30_);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			break;
#line 1023 "math-window.c"
		}
	}
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp32_ = self->priv->remove_buttons;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (_tmp32_ == TRUE) {
#line 1030 "math-window.c"
		MathButtons* _tmp33_ = NULL;
		MathButtons* _tmp34_ = NULL;
		ButtonMode _tmp35_ = 0;
		ButtonMode _tmp36_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp33_ = math_window_get_buttons (self);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp34_ = _tmp33_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp35_ = math_buttons_get_mode (_tmp34_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp36_ = _tmp35_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp31_ = _tmp36_ != BUTTON_MODE_KEYBOARD;
#line 1045 "math-window.c"
	} else {
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp31_ = FALSE;
#line 1049 "math-window.c"
	}
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (_tmp31_) {
#line 1053 "math-window.c"
		GtkBox* _tmp37_ = NULL;
		MathButtons* _tmp38_ = NULL;
		MathButtons* _tmp39_ = NULL;
		MathConverter* _tmp40_ = NULL;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp37_ = self->priv->vbox;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp38_ = math_window_get_buttons (self);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp39_ = _tmp38_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_box_pack_start (_tmp37_, (GtkWidget*) _tmp39_, TRUE, TRUE, (guint) 0);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		self->priv->remove_buttons = FALSE;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp40_ = self->priv->converter;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp40_, FALSE);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 1074 "math-window.c"
	} else {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp42_ = self->priv->remove_buttons;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		if (_tmp42_ == FALSE) {
#line 1082 "math-window.c"
			MathButtons* _tmp43_ = NULL;
			MathButtons* _tmp44_ = NULL;
			ButtonMode _tmp45_ = 0;
			ButtonMode _tmp46_ = 0;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp43_ = math_window_get_buttons (self);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp44_ = _tmp43_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp45_ = math_buttons_get_mode (_tmp44_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp46_ = _tmp45_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp41_ = _tmp46_ == BUTTON_MODE_KEYBOARD;
#line 1097 "math-window.c"
		} else {
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp41_ = FALSE;
#line 1101 "math-window.c"
		}
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		if (_tmp41_) {
#line 1105 "math-window.c"
			GtkBox* _tmp47_ = NULL;
			GtkBox* _tmp48_ = NULL;
			GList* _tmp49_ = NULL;
			GList* _tmp50_ = NULL;
			gconstpointer _tmp51_ = NULL;
			MathConverter* _tmp52_ = NULL;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp47_ = self->priv->vbox;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp48_ = self->priv->vbox;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp49_ = gtk_container_get_children ((GtkContainer*) _tmp48_);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp50_ = _tmp49_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp51_ = g_list_nth_data (_tmp50_, (guint) 2);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_container_remove ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp51_);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_g_list_free0 (_tmp50_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			self->priv->remove_buttons = TRUE;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp52_ = self->priv->converter;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_widget_set_visible ((GtkWidget*) _tmp52_, TRUE);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			gtk_window_set_resizable ((GtkWindow*) self, TRUE);
#line 1134 "math-window.c"
		}
	}
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (action);
#line 1139 "math-window.c"
}


void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents) {
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (title != NULL);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (contents != NULL);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = title;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp0_);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_ref_sink (_tmp1_);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	dialog = _tmp1_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp2_ = contents;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp2_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp3_ = _ ("_Quit");
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_dialog_add_buttons ((GtkDialog*) dialog, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_destroy ((GtkWidget*) self);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (dialog);
#line 1177 "math-window.c"
}


static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathWindow * self;
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	MathButtons* _tmp3_ = NULL;
	MathButtons* _tmp4_ = NULL;
	ButtonMode _tmp5_ = 0;
	ButtonMode _tmp6_ = 0;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self = (MathWindow*) base;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = event;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = GTK_WIDGET_CLASS (math_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), _tmp0_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_result_ = _tmp1_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp3_ = math_window_get_buttons (self);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp4_ = _tmp3_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp5_ = math_buttons_get_mode (_tmp4_);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp6_ = _tmp5_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (_tmp6_ == BUTTON_MODE_PROGRAMMING) {
#line 1212 "math-window.c"
		GdkEventKey* _tmp7_ = NULL;
		GdkModifierType _tmp8_ = 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp7_ = event;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp8_ = _tmp7_->state;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp2_ = (_tmp8_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
#line 1221 "math-window.c"
	} else {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp2_ = FALSE;
#line 1225 "math-window.c"
	}
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (_tmp2_) {
#line 1229 "math-window.c"
		GdkEventKey* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp9_ = event;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp10_ = _tmp9_->keyval;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		switch (_tmp10_) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			case GDK_KEY_b:
#line 1240 "math-window.c"
			{
				MathEquation* _tmp11_ = NULL;
				MathEquation* _tmp12_ = NULL;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp11_ = math_window_get_equation (self);
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp12_ = _tmp11_;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				math_equation_set_number_base (_tmp12_, 2);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				result = TRUE;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				return result;
#line 1254 "math-window.c"
			}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			case GDK_KEY_o:
#line 1258 "math-window.c"
			{
				MathEquation* _tmp13_ = NULL;
				MathEquation* _tmp14_ = NULL;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp13_ = math_window_get_equation (self);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp14_ = _tmp13_;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				math_equation_set_number_base (_tmp14_, 8);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				result = TRUE;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				return result;
#line 1272 "math-window.c"
			}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			case GDK_KEY_d:
#line 1276 "math-window.c"
			{
				MathEquation* _tmp15_ = NULL;
				MathEquation* _tmp16_ = NULL;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp15_ = math_window_get_equation (self);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp16_ = _tmp15_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				math_equation_set_number_base (_tmp16_, 10);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				result = TRUE;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				return result;
#line 1290 "math-window.c"
			}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			case GDK_KEY_h:
#line 1294 "math-window.c"
			{
				MathEquation* _tmp17_ = NULL;
				MathEquation* _tmp18_ = NULL;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp17_ = math_window_get_equation (self);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp18_ = _tmp17_;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				math_equation_set_number_base (_tmp18_, 16);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				result = TRUE;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				return result;
#line 1308 "math-window.c"
			}
			default:
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			break;
#line 1313 "math-window.c"
		}
	}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	result = _result_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	return result;
#line 1320 "math-window.c"
}


static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	gboolean _tmp0_ = FALSE;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (adjustment != NULL);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = self->priv->right_aligned;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (_tmp0_) {
#line 1334 "math-window.c"
		GtkAdjustment* _tmp1_ = NULL;
		GtkAdjustment* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		GtkAdjustment* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp1_ = adjustment;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp2_ = adjustment;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp4_ = adjustment;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		gtk_adjustment_set_value (_tmp1_, _tmp3_ - _tmp5_);
#line 1352 "math-window.c"
	}
}


static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GtkAdjustment* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (adjustment != NULL);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = adjustment;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp2_ = adjustment;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp4_ = adjustment;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (_tmp1_ == (_tmp3_ - _tmp5_)) {
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		self->priv->right_aligned = TRUE;
#line 1384 "math-window.c"
	} else {
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		self->priv->right_aligned = FALSE;
#line 1388 "math-window.c"
	}
}


static void math_window_copy_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = math_window_get_equation (self);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = _tmp0_;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_equation_copy (_tmp1_);
#line 1404 "math-window.c"
}


static void math_window_paste_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = math_window_get_equation (self);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = _tmp0_;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_equation_paste (_tmp1_);
#line 1419 "math-window.c"
}


static void math_window_undo_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = math_window_get_equation (self);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = _tmp0_;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp1_);
#line 1434 "math-window.c"
}


static void math_window_redo_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = math_window_get_equation (self);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = _tmp0_;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_source_buffer_redo ((GtkSourceBuffer*) _tmp1_);
#line 1449 "math-window.c"
}


static void math_window_mode_cb (MathWindow* self, GSimpleAction* action, GVariant* parameter) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	const GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkPopover* popover = NULL;
	GtkMenuButton* _tmp4_ = NULL;
	GtkPopover* _tmp5_ = NULL;
	GtkPopover* _tmp6_ = NULL;
	GtkPopover* _tmp7_ = NULL;
	GtkMenuButton* _tmp8_ = NULL;
	MathDisplay* _tmp9_ = NULL;
	MathDisplay* _tmp10_ = NULL;
	ButtonMode mode = 0;
	gchar* mode_str = NULL;
	GVariant* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	MathButtons* _tmp19_ = NULL;
	MathButtons* _tmp20_ = NULL;
	ButtonMode _tmp21_ = 0;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (self != NULL);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_if_fail (action != NULL);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = parameter;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "parameter != null");
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp1_ = parameter;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp2_ = G_VARIANT_TYPE_STRING;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp3_ = g_variant_is_of_type (_tmp1_, _tmp2_);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_vala_return_if_fail (_tmp3_, "parameter.is_of_type (VariantType.STRING)");
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp4_ = self->priv->menu_button;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp5_ = gtk_menu_button_get_popover (_tmp4_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	popover = _tmp6_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp7_ = popover;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp8_ = self->priv->menu_button;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp8_, FALSE);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp9_ = math_window_get_display (self);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp10_ = _tmp9_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_display_grab_focus (_tmp10_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	mode = BUTTON_MODE_BASIC;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp11_ = parameter;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp12_ = g_variant_get_string (_tmp11_, NULL);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	mode_str = _tmp13_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp14_ = mode_str;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	if (g_strcmp0 (_tmp14_, "basic") == 0) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		mode = BUTTON_MODE_BASIC;
#line 1529 "math-window.c"
	} else {
		const gchar* _tmp15_ = NULL;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		_tmp15_ = mode_str;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		if (g_strcmp0 (_tmp15_, "advanced") == 0) {
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			mode = BUTTON_MODE_ADVANCED;
#line 1538 "math-window.c"
		} else {
			const gchar* _tmp16_ = NULL;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			_tmp16_ = mode_str;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
			if (g_strcmp0 (_tmp16_, "financial") == 0) {
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				mode = BUTTON_MODE_FINANCIAL;
#line 1547 "math-window.c"
			} else {
				const gchar* _tmp17_ = NULL;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				_tmp17_ = mode_str;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
				if (g_strcmp0 (_tmp17_, "programming") == 0) {
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
					mode = BUTTON_MODE_PROGRAMMING;
#line 1556 "math-window.c"
				} else {
					const gchar* _tmp18_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
					_tmp18_ = mode_str;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
					if (g_strcmp0 (_tmp18_, "keyboard") == 0) {
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
						mode = BUTTON_MODE_KEYBOARD;
#line 1565 "math-window.c"
					} else {
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
						g_assert_not_reached ();
#line 1569 "math-window.c"
					}
				}
			}
		}
	}
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp19_ = math_window_get_buttons (self);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp20_ = _tmp19_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp21_ = mode;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_buttons_set_mode (_tmp20_, _tmp21_);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_free0 (mode_str);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (popover);
#line 1587 "math-window.c"
}


MathEquation* math_window_get_equation (MathWindow* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = self->priv->_equation;
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	result = _tmp0_;
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	return result;
#line 1602 "math-window.c"
}


MathDisplay* math_window_get_display (MathWindow* self) {
	MathDisplay* result;
	MathDisplay* _tmp0_ = NULL;
#line 18 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 18 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = self->priv->_display;
#line 18 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	result = _tmp0_;
#line 18 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	return result;
#line 1617 "math-window.c"
}


MathButtons* math_window_get_buttons (MathWindow* self) {
	MathButtons* result;
	MathButtons* _tmp0_ = NULL;
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_tmp0_ = self->priv->_buttons;
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	result = _tmp0_;
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	return result;
#line 1632 "math-window.c"
}


static void math_window_class_init (MathWindowClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	math_window_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_type_class_add_private (klass, sizeof (MathWindowPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	((GtkWidgetClass *) klass)->key_press_event = math_window_real_key_press_event;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_math_window_get_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	G_OBJECT_CLASS (klass)->finalize = math_window_finalize;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_DISPLAY, g_param_spec_object ("display", "display", "display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_BUTTONS, g_param_spec_object ("buttons", "buttons", "buttons", TYPE_MATH_BUTTONS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1653 "math-window.c"
}


static void math_window_instance_init (MathWindow * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self->priv = MATH_WINDOW_GET_PRIVATE (self);
#line 1660 "math-window.c"
}


static void math_window_finalize (GObject* obj) {
	MathWindow * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_WINDOW, MathWindow);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->_equation);
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->_display);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->converter);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->_buttons);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->menu_button);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->vbox);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	_g_object_unref0 (self->priv->mode_label);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	G_OBJECT_CLASS (math_window_parent_class)->finalize (obj);
#line 1686 "math-window.c"
}


GType math_window_get_type (void) {
	static volatile gsize math_window_type_id__volatile = 0;
	if (g_once_init_enter (&math_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathWindow), 0, (GInstanceInitFunc) math_window_instance_init, NULL };
		GType math_window_type_id;
		math_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MathWindow", &g_define_type_info, 0);
		g_once_init_leave (&math_window_type_id__volatile, math_window_type_id);
	}
	return math_window_type_id__volatile;
}


static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_WINDOW, MathWindow);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case MATH_WINDOW_EQUATION:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_value_set_object (value, math_window_get_equation (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case MATH_WINDOW_DISPLAY:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_value_set_object (value, math_window_get_display (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		case MATH_WINDOW_BUTTONS:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		g_value_set_object (value, math_window_get_buttons (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		break;
#line 1725 "math-window.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-window.vala"
		break;
#line 1731 "math-window.c"
	}
}



