/* unit.c generated by valac 0.36.4, the Vala compiler
 * generated from unit.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_UNIT_MANAGER (unit_manager_get_type ())
#define UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_MANAGER, UnitManager))
#define UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_MANAGER, UnitManagerClass))
#define IS_UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_MANAGER))
#define IS_UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_MANAGER))
#define UNIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_MANAGER, UnitManagerClass))

typedef struct _UnitManager UnitManager;
typedef struct _UnitManagerClass UnitManagerClass;
typedef struct _UnitManagerPrivate UnitManagerPrivate;

#define TYPE_UNIT_CATEGORY (unit_category_get_type ())
#define UNIT_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_CATEGORY, UnitCategory))
#define UNIT_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_CATEGORY, UnitCategoryClass))
#define IS_UNIT_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_CATEGORY))
#define IS_UNIT_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_CATEGORY))
#define UNIT_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_CATEGORY, UnitCategoryClass))

typedef struct _UnitCategory UnitCategory;
typedef struct _UnitCategoryClass UnitCategoryClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT, UnitClass))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT))
#define UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT, UnitClass))

typedef struct _Unit Unit;
typedef struct _UnitClass UnitClass;

#define TYPE_CURRENCY (currency_get_type ())
#define CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY, Currency))
#define CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY, CurrencyClass))
#define IS_CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY))
#define IS_CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY))
#define CURRENCY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY, CurrencyClass))

typedef struct _Currency Currency;
typedef struct _CurrencyClass CurrencyClass;

#define TYPE_CURRENCY_MANAGER (currency_manager_get_type ())
#define CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY_MANAGER, CurrencyManager))
#define CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))
#define IS_CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY_MANAGER))
#define IS_CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY_MANAGER))
#define CURRENCY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))

typedef struct _CurrencyManager CurrencyManager;
typedef struct _CurrencyManagerClass CurrencyManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _UnitCategoryPrivate UnitCategoryPrivate;
typedef struct _UnitPrivate UnitPrivate;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;

#define TYPE_UNIT_SOLVE_EQUATION (unit_solve_equation_get_type ())
#define UNIT_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquation))
#define UNIT_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationClass))
#define IS_UNIT_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_SOLVE_EQUATION))
#define IS_UNIT_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_SOLVE_EQUATION))
#define UNIT_SOLVE_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationClass))

typedef struct _UnitSolveEquation UnitSolveEquation;
typedef struct _UnitSolveEquationClass UnitSolveEquationClass;
typedef struct _EquationPrivate EquationPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_ERROR_CODE (error_code_get_type ())
typedef struct _UnitSolveEquationPrivate UnitSolveEquationPrivate;

struct _UnitManager {
	GObject parent_instance;
	UnitManagerPrivate * priv;
};

struct _UnitManagerClass {
	GObjectClass parent_class;
};

struct _UnitManagerPrivate {
	GList* categories;
};

struct _UnitCategory {
	GObject parent_instance;
	UnitCategoryPrivate * priv;
};

struct _UnitCategoryClass {
	GObjectClass parent_class;
};

struct _UnitCategoryPrivate {
	GList* units;
	gchar* _name;
	gchar* _display_name;
};

struct _Unit {
	GObject parent_instance;
	UnitPrivate * priv;
};

struct _UnitClass {
	GObjectClass parent_class;
};

struct _UnitPrivate {
	gchar* _name;
	gchar* _display_name;
	gchar* _format;
	GList* _symbols;
	gchar* from_function;
	gchar* to_function;
	Serializer* serializer;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Equation {
	GObject parent_instance;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GObjectClass parent_class;
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	gboolean (*unit_is_defined) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _UnitSolveEquation {
	Equation parent_instance;
	UnitSolveEquationPrivate * priv;
};

struct _UnitSolveEquationClass {
	EquationClass parent_class;
};

struct _UnitSolveEquationPrivate {
	Number* x;
};


extern UnitManager* default_unit_manager;
UnitManager* default_unit_manager = NULL;
static gpointer unit_manager_parent_class = NULL;
static gpointer unit_category_parent_class = NULL;
static gpointer unit_parent_class = NULL;
static gpointer unit_solve_equation_parent_class = NULL;

GType unit_manager_get_type (void) G_GNUC_CONST;
GType unit_category_get_type (void) G_GNUC_CONST;
#define UNIT_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT_MANAGER, UnitManagerPrivate))
enum  {
	UNIT_MANAGER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
UnitManager* unit_manager_new (void);
UnitManager* unit_manager_construct (GType object_type);
UnitManager* unit_manager_get_default (void);
UnitCategory* unit_manager_add_category (UnitManager* self, const gchar* name, const gchar* display_name);
GType unit_get_type (void) G_GNUC_CONST;
void unit_category_add_unit (UnitCategory* self, Unit* unit);
Unit* unit_new (const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols);
Unit* unit_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols);
GType currency_get_type (void) G_GNUC_CONST;
GType currency_manager_get_type (void) G_GNUC_CONST;
CurrencyManager* currency_manager_get_default (void);
GList* currency_manager_get_currencies (CurrencyManager* self);
static gint __lambda9_ (Currency* a, Currency* b);
gchar* currency_get_display_name (Currency* self);
static gint ___lambda9__gcompare_func (gconstpointer a, gconstpointer b);
gchar* currency_get_symbol (Currency* self);
gchar* currency_get_name (Currency* self);
UnitCategory* unit_category_new (const gchar* name, const gchar* display_name);
UnitCategory* unit_category_construct (GType object_type, const gchar* name, const gchar* display_name);
GList* unit_manager_get_categories (UnitManager* self);
UnitCategory* unit_manager_get_category (UnitManager* self, const gchar* category);
gchar* unit_category_get_name (UnitCategory* self);
Unit* unit_manager_get_unit_by_name (UnitManager* self, const gchar* name);
Unit* unit_category_get_unit_by_name (UnitCategory* self, const gchar* name, gboolean case_sensitive);
Unit* unit_manager_get_unit_by_symbol (UnitManager* self, const gchar* symbol);
Unit* unit_category_get_unit_by_symbol (UnitCategory* self, const gchar* symbol, gboolean case_sensitive);
gboolean unit_manager_unit_is_defined (UnitManager* self, const gchar* name);
GType number_get_type (void) G_GNUC_CONST;
Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol);
Number* unit_category_convert (UnitCategory* self, Number* x, Unit* x_units, Unit* z_units);
static void unit_manager_finalize (GObject * obj);
#define UNIT_CATEGORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT_CATEGORY, UnitCategoryPrivate))
enum  {
	UNIT_CATEGORY_DUMMY_PROPERTY,
	UNIT_CATEGORY_NAME,
	UNIT_CATEGORY_DISPLAY_NAME
};
gchar* unit_get_name (Unit* self);
gboolean unit_matches_symbol (Unit* self, const gchar* symbol, gboolean case_sensitive);
GList* unit_category_get_units (UnitCategory* self);
Number* unit_convert_from (Unit* self, Number* x);
Number* unit_convert_to (Unit* self, Number* x);
gchar* unit_category_get_display_name (UnitCategory* self);
static void unit_category_finalize (GObject * obj);
static void _vala_unit_category_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType serializer_get_type (void) G_GNUC_CONST;
#define UNIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT, UnitPrivate))
enum  {
	UNIT_DUMMY_PROPERTY,
	UNIT_NAME,
	UNIT_DISPLAY_NAME
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
void serializer_set_leading_digits (Serializer* self, gint leading_digits);
GList* unit_get_symbols (Unit* self);
static Number* unit_solve_function (Unit* self, const gchar* function, Number* x);
Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency);
Number* number_divide (Number* self, Number* y);
Number* number_multiply (Number* self, Number* y);
gchar* unit_format (Unit* self, Number* x);
gchar* serializer_to_string (Serializer* self, Number* x);
GType equation_get_type (void) G_GNUC_CONST;
GType unit_solve_equation_get_type (void) G_GNUC_CONST;
UnitSolveEquation* unit_solve_equation_new (const gchar* function, Number* x);
UnitSolveEquation* unit_solve_equation_construct (GType object_type, const gchar* function, Number* x);
GType angle_unit_get_type (void) G_GNUC_CONST;
GType error_code_get_type (void) G_GNUC_CONST;
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar* * error_token, guint** error_start, guint** error_end);
gchar* unit_get_display_name (Unit* self);
static void unit_finalize (GObject * obj);
static void _vala_unit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define UNIT_SOLVE_EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationPrivate))
enum  {
	UNIT_SOLVE_EQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
static gboolean unit_solve_equation_real_variable_is_defined (Equation* base, const gchar* name);
static Number* unit_solve_equation_real_get_variable (Equation* base, const gchar* name);
static void unit_solve_equation_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


UnitManager* unit_manager_construct (GType object_type) {
	UnitManager * self = NULL;
	self = (UnitManager*) g_object_new (object_type, NULL);
	__g_list_free__g_object_unref0_0 (self->priv->categories);
	self->priv->categories = NULL;
	return self;
}


UnitManager* unit_manager_new (void) {
	return unit_manager_construct (TYPE_UNIT_MANAGER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint __lambda9_ (Currency* a, Currency* b) {
	gint result = 0;
	Currency* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	Currency* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = currency_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = currency_get_display_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate (_tmp3_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static gint ___lambda9__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda9_ ((Currency*) a, (Currency*) b);
	return result;
}


UnitManager* unit_manager_get_default (void) {
	UnitManager* result = NULL;
	UnitManager* _tmp0_;
	UnitManager* _tmp3_;
	UnitCategory* angle_category = NULL;
	UnitManager* _tmp4_;
	UnitCategory* _tmp5_;
	UnitCategory* length_category = NULL;
	UnitManager* _tmp6_;
	UnitCategory* _tmp7_;
	UnitCategory* area_category = NULL;
	UnitManager* _tmp8_;
	UnitCategory* _tmp9_;
	UnitCategory* volume_category = NULL;
	UnitManager* _tmp10_;
	UnitCategory* _tmp11_;
	UnitCategory* weight_category = NULL;
	UnitManager* _tmp12_;
	UnitCategory* _tmp13_;
	UnitCategory* duration_category = NULL;
	UnitManager* _tmp14_;
	UnitCategory* _tmp15_;
	UnitCategory* temperature_category = NULL;
	UnitManager* _tmp16_;
	UnitCategory* _tmp17_;
	UnitCategory* digitalstorage_category = NULL;
	UnitManager* _tmp18_;
	UnitCategory* _tmp19_;
	UnitCategory* _tmp20_;
	Unit* _tmp21_;
	Unit* _tmp22_;
	UnitCategory* _tmp23_;
	Unit* _tmp24_;
	Unit* _tmp25_;
	UnitCategory* _tmp26_;
	Unit* _tmp27_;
	Unit* _tmp28_;
	UnitCategory* _tmp29_;
	Unit* _tmp30_;
	Unit* _tmp31_;
	UnitCategory* _tmp32_;
	Unit* _tmp33_;
	Unit* _tmp34_;
	UnitCategory* _tmp35_;
	Unit* _tmp36_;
	Unit* _tmp37_;
	UnitCategory* _tmp38_;
	Unit* _tmp39_;
	Unit* _tmp40_;
	UnitCategory* _tmp41_;
	Unit* _tmp42_;
	Unit* _tmp43_;
	UnitCategory* _tmp44_;
	Unit* _tmp45_;
	Unit* _tmp46_;
	UnitCategory* _tmp47_;
	Unit* _tmp48_;
	Unit* _tmp49_;
	UnitCategory* _tmp50_;
	Unit* _tmp51_;
	Unit* _tmp52_;
	UnitCategory* _tmp53_;
	Unit* _tmp54_;
	Unit* _tmp55_;
	UnitCategory* _tmp56_;
	Unit* _tmp57_;
	Unit* _tmp58_;
	UnitCategory* _tmp59_;
	Unit* _tmp60_;
	Unit* _tmp61_;
	UnitCategory* _tmp62_;
	Unit* _tmp63_;
	Unit* _tmp64_;
	UnitCategory* _tmp65_;
	Unit* _tmp66_;
	Unit* _tmp67_;
	UnitCategory* _tmp68_;
	Unit* _tmp69_;
	Unit* _tmp70_;
	UnitCategory* _tmp71_;
	Unit* _tmp72_;
	Unit* _tmp73_;
	UnitCategory* _tmp74_;
	Unit* _tmp75_;
	Unit* _tmp76_;
	UnitCategory* _tmp77_;
	Unit* _tmp78_;
	Unit* _tmp79_;
	UnitCategory* _tmp80_;
	Unit* _tmp81_;
	Unit* _tmp82_;
	UnitCategory* _tmp83_;
	Unit* _tmp84_;
	Unit* _tmp85_;
	UnitCategory* _tmp86_;
	Unit* _tmp87_;
	Unit* _tmp88_;
	UnitCategory* _tmp89_;
	Unit* _tmp90_;
	Unit* _tmp91_;
	UnitCategory* _tmp92_;
	Unit* _tmp93_;
	Unit* _tmp94_;
	UnitCategory* _tmp95_;
	Unit* _tmp96_;
	Unit* _tmp97_;
	UnitCategory* _tmp98_;
	Unit* _tmp99_;
	Unit* _tmp100_;
	UnitCategory* _tmp101_;
	Unit* _tmp102_;
	Unit* _tmp103_;
	UnitCategory* _tmp104_;
	Unit* _tmp105_;
	Unit* _tmp106_;
	UnitCategory* _tmp107_;
	Unit* _tmp108_;
	Unit* _tmp109_;
	UnitCategory* _tmp110_;
	Unit* _tmp111_;
	Unit* _tmp112_;
	UnitCategory* _tmp113_;
	Unit* _tmp114_;
	Unit* _tmp115_;
	UnitCategory* _tmp116_;
	Unit* _tmp117_;
	Unit* _tmp118_;
	UnitCategory* _tmp119_;
	Unit* _tmp120_;
	Unit* _tmp121_;
	UnitCategory* _tmp122_;
	Unit* _tmp123_;
	Unit* _tmp124_;
	UnitCategory* _tmp125_;
	Unit* _tmp126_;
	Unit* _tmp127_;
	UnitCategory* _tmp128_;
	Unit* _tmp129_;
	Unit* _tmp130_;
	UnitCategory* _tmp131_;
	Unit* _tmp132_;
	Unit* _tmp133_;
	UnitCategory* _tmp134_;
	Unit* _tmp135_;
	Unit* _tmp136_;
	UnitCategory* _tmp137_;
	Unit* _tmp138_;
	Unit* _tmp139_;
	UnitCategory* _tmp140_;
	Unit* _tmp141_;
	Unit* _tmp142_;
	UnitCategory* _tmp143_;
	Unit* _tmp144_;
	Unit* _tmp145_;
	UnitCategory* _tmp146_;
	Unit* _tmp147_;
	Unit* _tmp148_;
	UnitCategory* _tmp149_;
	Unit* _tmp150_;
	Unit* _tmp151_;
	UnitCategory* _tmp152_;
	Unit* _tmp153_;
	Unit* _tmp154_;
	UnitCategory* _tmp155_;
	Unit* _tmp156_;
	Unit* _tmp157_;
	UnitCategory* _tmp158_;
	Unit* _tmp159_;
	Unit* _tmp160_;
	UnitCategory* _tmp161_;
	Unit* _tmp162_;
	Unit* _tmp163_;
	UnitCategory* _tmp164_;
	Unit* _tmp165_;
	Unit* _tmp166_;
	UnitCategory* _tmp167_;
	Unit* _tmp168_;
	Unit* _tmp169_;
	UnitCategory* _tmp170_;
	Unit* _tmp171_;
	Unit* _tmp172_;
	UnitCategory* _tmp173_;
	Unit* _tmp174_;
	Unit* _tmp175_;
	UnitCategory* _tmp176_;
	Unit* _tmp177_;
	Unit* _tmp178_;
	UnitCategory* _tmp179_;
	Unit* _tmp180_;
	Unit* _tmp181_;
	UnitCategory* _tmp182_;
	Unit* _tmp183_;
	Unit* _tmp184_;
	UnitCategory* _tmp185_;
	Unit* _tmp186_;
	Unit* _tmp187_;
	UnitCategory* _tmp188_;
	Unit* _tmp189_;
	Unit* _tmp190_;
	UnitCategory* _tmp191_;
	Unit* _tmp192_;
	Unit* _tmp193_;
	UnitCategory* _tmp194_;
	Unit* _tmp195_;
	Unit* _tmp196_;
	UnitCategory* _tmp197_;
	Unit* _tmp198_;
	Unit* _tmp199_;
	UnitCategory* _tmp200_;
	Unit* _tmp201_;
	Unit* _tmp202_;
	UnitCategory* _tmp203_;
	Unit* _tmp204_;
	Unit* _tmp205_;
	UnitCategory* _tmp206_;
	Unit* _tmp207_;
	Unit* _tmp208_;
	UnitCategory* _tmp209_;
	Unit* _tmp210_;
	Unit* _tmp211_;
	UnitCategory* _tmp212_;
	Unit* _tmp213_;
	Unit* _tmp214_;
	UnitCategory* _tmp215_;
	Unit* _tmp216_;
	Unit* _tmp217_;
	UnitCategory* _tmp218_;
	Unit* _tmp219_;
	Unit* _tmp220_;
	UnitCategory* _tmp221_;
	Unit* _tmp222_;
	Unit* _tmp223_;
	UnitCategory* _tmp224_;
	Unit* _tmp225_;
	Unit* _tmp226_;
	UnitCategory* _tmp227_;
	Unit* _tmp228_;
	Unit* _tmp229_;
	UnitCategory* _tmp230_;
	Unit* _tmp231_;
	Unit* _tmp232_;
	UnitCategory* _tmp233_;
	Unit* _tmp234_;
	Unit* _tmp235_;
	UnitCategory* _tmp236_;
	Unit* _tmp237_;
	Unit* _tmp238_;
	UnitCategory* _tmp239_;
	Unit* _tmp240_;
	Unit* _tmp241_;
	UnitCategory* _tmp242_;
	Unit* _tmp243_;
	Unit* _tmp244_;
	UnitCategory* _tmp245_;
	Unit* _tmp246_;
	Unit* _tmp247_;
	UnitCategory* _tmp248_;
	Unit* _tmp249_;
	Unit* _tmp250_;
	UnitCategory* _tmp251_;
	Unit* _tmp252_;
	Unit* _tmp253_;
	UnitCategory* _tmp254_;
	Unit* _tmp255_;
	Unit* _tmp256_;
	UnitCategory* _tmp257_;
	Unit* _tmp258_;
	Unit* _tmp259_;
	UnitCategory* _tmp260_;
	Unit* _tmp261_;
	Unit* _tmp262_;
	UnitCategory* _tmp263_;
	Unit* _tmp264_;
	Unit* _tmp265_;
	UnitCategory* _tmp266_;
	Unit* _tmp267_;
	Unit* _tmp268_;
	UnitCategory* currency_category = NULL;
	UnitManager* _tmp269_;
	UnitCategory* _tmp270_;
	GList* currencies = NULL;
	CurrencyManager* _tmp271_;
	CurrencyManager* _tmp272_;
	GList* _tmp273_;
	GList* _tmp274_;
	GList* _tmp275_;
	UnitManager* _tmp300_;
	UnitManager* _tmp301_;
	_tmp0_ = default_unit_manager;
	if (_tmp0_ != NULL) {
		UnitManager* _tmp1_;
		UnitManager* _tmp2_;
		_tmp1_ = default_unit_manager;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = unit_manager_new ();
	_g_object_unref0 (default_unit_manager);
	default_unit_manager = _tmp3_;
	_tmp4_ = default_unit_manager;
	_tmp5_ = unit_manager_add_category (_tmp4_, "angle", _ ("Angle"));
	angle_category = _tmp5_;
	_tmp6_ = default_unit_manager;
	_tmp7_ = unit_manager_add_category (_tmp6_, "length", _ ("Length"));
	length_category = _tmp7_;
	_tmp8_ = default_unit_manager;
	_tmp9_ = unit_manager_add_category (_tmp8_, "area", _ ("Area"));
	area_category = _tmp9_;
	_tmp10_ = default_unit_manager;
	_tmp11_ = unit_manager_add_category (_tmp10_, "volume", _ ("Volume"));
	volume_category = _tmp11_;
	_tmp12_ = default_unit_manager;
	_tmp13_ = unit_manager_add_category (_tmp12_, "weight", _ ("Weight"));
	weight_category = _tmp13_;
	_tmp14_ = default_unit_manager;
	_tmp15_ = unit_manager_add_category (_tmp14_, "duration", _ ("Duration"));
	duration_category = _tmp15_;
	_tmp16_ = default_unit_manager;
	_tmp17_ = unit_manager_add_category (_tmp16_, "temperature", _ ("Temperature"));
	temperature_category = _tmp17_;
	_tmp18_ = default_unit_manager;
	_tmp19_ = unit_manager_add_category (_tmp18_, "digitalstorage", _ ("Digital Storage"));
	digitalstorage_category = _tmp19_;
	_tmp20_ = angle_category;
	_tmp21_ = unit_new ("degree", _ ("Degrees"), g_dpgettext2 (NULL, "unit-format", "%s degrees"), "π*x/180", "180x/π", g_dpgettext2 (NULL, "unit-symbols", "degree,degrees,deg"));
	_tmp22_ = _tmp21_;
	unit_category_add_unit (_tmp20_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = angle_category;
	_tmp24_ = unit_new ("radian", _ ("Radians"), g_dpgettext2 (NULL, "unit-format", "%s radians"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "radian,radians,rad"));
	_tmp25_ = _tmp24_;
	unit_category_add_unit (_tmp23_, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = angle_category;
	_tmp27_ = unit_new ("gradian", _ ("Gradians"), g_dpgettext2 (NULL, "unit-format", "%s gradians"), "π*x/200", "200x/π", g_dpgettext2 (NULL, "unit-symbols", "gradian,gradians,grad"));
	_tmp28_ = _tmp27_;
	unit_category_add_unit (_tmp26_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = length_category;
	_tmp30_ = unit_new ("parsec", _ ("Parsecs"), g_dpgettext2 (NULL, "unit-format", "%s pc"), "30857000000000000x", "x/30857000000000000", g_dpgettext2 (NULL, "unit-symbols", "parsec,parsecs,pc"));
	_tmp31_ = _tmp30_;
	unit_category_add_unit (_tmp29_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = length_category;
	_tmp33_ = unit_new ("lightyear", _ ("Light Years"), g_dpgettext2 (NULL, "unit-format", "%s ly"), "9460730472580800x", "x/9460730472580800", g_dpgettext2 (NULL, "unit-symbols", "lightyear,lightyears,ly"));
	_tmp34_ = _tmp33_;
	unit_category_add_unit (_tmp32_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = length_category;
	_tmp36_ = unit_new ("astronomical-unit", _ ("Astronomical Units"), g_dpgettext2 (NULL, "unit-format", "%s au"), "149597870691x", "x/149597870691", g_dpgettext2 (NULL, "unit-symbols", "au"));
	_tmp37_ = _tmp36_;
	unit_category_add_unit (_tmp35_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = length_category;
	_tmp39_ = unit_new ("nautical-mile", _ ("Nautical Miles"), g_dpgettext2 (NULL, "unit-format", "%s nmi"), "1852x", "x/1852", g_dpgettext2 (NULL, "unit-symbols", "nmi"));
	_tmp40_ = _tmp39_;
	unit_category_add_unit (_tmp38_, _tmp40_);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = length_category;
	_tmp42_ = unit_new ("mile", _ ("Miles"), g_dpgettext2 (NULL, "unit-format", "%s mi"), "1609.344x", "x/1609.344", g_dpgettext2 (NULL, "unit-symbols", "mile,miles,mi"));
	_tmp43_ = _tmp42_;
	unit_category_add_unit (_tmp41_, _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = length_category;
	_tmp45_ = unit_new ("kilometer", _ ("Kilometers"), g_dpgettext2 (NULL, "unit-format", "%s km"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "kilometer,kilometers,km,kms"));
	_tmp46_ = _tmp45_;
	unit_category_add_unit (_tmp44_, _tmp46_);
	_g_object_unref0 (_tmp46_);
	_tmp47_ = length_category;
	_tmp48_ = unit_new ("cable", _ ("Cables"), g_dpgettext2 (NULL, "unit-format", "%s cb"), "219.456x", "x/219.456", g_dpgettext2 (NULL, "unit-symbols", "cable,cables,cb"));
	_tmp49_ = _tmp48_;
	unit_category_add_unit (_tmp47_, _tmp49_);
	_g_object_unref0 (_tmp49_);
	_tmp50_ = length_category;
	_tmp51_ = unit_new ("fathom", _ ("Fathoms"), g_dpgettext2 (NULL, "unit-format", "%s ftm"), "1.8288x", "x/1.8288", g_dpgettext2 (NULL, "unit-symbols", "fathom,fathoms,ftm"));
	_tmp52_ = _tmp51_;
	unit_category_add_unit (_tmp50_, _tmp52_);
	_g_object_unref0 (_tmp52_);
	_tmp53_ = length_category;
	_tmp54_ = unit_new ("meter", _ ("Meters"), g_dpgettext2 (NULL, "unit-format", "%s m"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "meter,meters,m"));
	_tmp55_ = _tmp54_;
	unit_category_add_unit (_tmp53_, _tmp55_);
	_g_object_unref0 (_tmp55_);
	_tmp56_ = length_category;
	_tmp57_ = unit_new ("yard", _ ("Yards"), g_dpgettext2 (NULL, "unit-format", "%s yd"), "0.9144x", "x/0.9144", g_dpgettext2 (NULL, "unit-symbols", "yard,yards,yd"));
	_tmp58_ = _tmp57_;
	unit_category_add_unit (_tmp56_, _tmp58_);
	_g_object_unref0 (_tmp58_);
	_tmp59_ = length_category;
	_tmp60_ = unit_new ("foot", _ ("Feet"), g_dpgettext2 (NULL, "unit-format", "%s ft"), "0.3048x", "x/0.3048", g_dpgettext2 (NULL, "unit-symbols", "foot,feet,ft"));
	_tmp61_ = _tmp60_;
	unit_category_add_unit (_tmp59_, _tmp61_);
	_g_object_unref0 (_tmp61_);
	_tmp62_ = length_category;
	_tmp63_ = unit_new ("inch", _ ("Inches"), g_dpgettext2 (NULL, "unit-format", "%s in"), "0.0254x", "x/0.0254", g_dpgettext2 (NULL, "unit-symbols", "inch,inches,in"));
	_tmp64_ = _tmp63_;
	unit_category_add_unit (_tmp62_, _tmp64_);
	_g_object_unref0 (_tmp64_);
	_tmp65_ = length_category;
	_tmp66_ = unit_new ("centimeter", _ ("Centimeters"), g_dpgettext2 (NULL, "unit-format", "%s cm"), "x/100", "100x", g_dpgettext2 (NULL, "unit-symbols", "centimeter,centimeters,cm,cms"));
	_tmp67_ = _tmp66_;
	unit_category_add_unit (_tmp65_, _tmp67_);
	_g_object_unref0 (_tmp67_);
	_tmp68_ = length_category;
	_tmp69_ = unit_new ("millimeter", _ ("Millimeters"), g_dpgettext2 (NULL, "unit-format", "%s mm"), "x/1000", "1000x", g_dpgettext2 (NULL, "unit-symbols", "millimeter,millimeters,mm"));
	_tmp70_ = _tmp69_;
	unit_category_add_unit (_tmp68_, _tmp70_);
	_g_object_unref0 (_tmp70_);
	_tmp71_ = length_category;
	_tmp72_ = unit_new ("micrometer", _ ("Micrometers"), g_dpgettext2 (NULL, "unit-format", "%s μm"), "x/1000000", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "micrometer,micrometers,um"));
	_tmp73_ = _tmp72_;
	unit_category_add_unit (_tmp71_, _tmp73_);
	_g_object_unref0 (_tmp73_);
	_tmp74_ = length_category;
	_tmp75_ = unit_new ("nanometer", _ ("Nanometers"), g_dpgettext2 (NULL, "unit-format", "%s nm"), "x/1000000000", "1000000000x", g_dpgettext2 (NULL, "unit-symbols", "nanometer,nanometers,nm"));
	_tmp76_ = _tmp75_;
	unit_category_add_unit (_tmp74_, _tmp76_);
	_g_object_unref0 (_tmp76_);
	_tmp77_ = length_category;
	_tmp78_ = unit_new ("point", _ ("Desktop Publishing Point"), g_dpgettext2 (NULL, "unit-format", "%s pt"), "0.000352777778x", "x/0.000352777778", g_dpgettext2 (NULL, "unit-symbols", "point,pt,points,pts"));
	_tmp79_ = _tmp78_;
	unit_category_add_unit (_tmp77_, _tmp79_);
	_g_object_unref0 (_tmp79_);
	_tmp80_ = area_category;
	_tmp81_ = unit_new ("hectare", _ ("Hectares"), g_dpgettext2 (NULL, "unit-format", "%s ha"), "10000x", "x/10000", g_dpgettext2 (NULL, "unit-symbols", "hectare,hectares,ha"));
	_tmp82_ = _tmp81_;
	unit_category_add_unit (_tmp80_, _tmp82_);
	_g_object_unref0 (_tmp82_);
	_tmp83_ = area_category;
	_tmp84_ = unit_new ("acre", _ ("Acres"), g_dpgettext2 (NULL, "unit-format", "%s acres"), "4046.8564224x", "x/4046.8564224", g_dpgettext2 (NULL, "unit-symbols", "acre,acres"));
	_tmp85_ = _tmp84_;
	unit_category_add_unit (_tmp83_, _tmp85_);
	_g_object_unref0 (_tmp85_);
	_tmp86_ = area_category;
	_tmp87_ = unit_new ("square-meter", _ ("Square Meters"), g_dpgettext2 (NULL, "unit-format", "%s m²"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "m²"));
	_tmp88_ = _tmp87_;
	unit_category_add_unit (_tmp86_, _tmp88_);
	_g_object_unref0 (_tmp88_);
	_tmp89_ = area_category;
	_tmp90_ = unit_new ("square-centimeter", _ ("Square Centimeters"), g_dpgettext2 (NULL, "unit-format", "%s cm²"), "0.0001x", "10000x", g_dpgettext2 (NULL, "unit-symbols", "cm²"));
	_tmp91_ = _tmp90_;
	unit_category_add_unit (_tmp89_, _tmp91_);
	_g_object_unref0 (_tmp91_);
	_tmp92_ = area_category;
	_tmp93_ = unit_new ("square-millimeter", _ ("Square Millimeters"), g_dpgettext2 (NULL, "unit-format", "%s mm²"), "0.000001x", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "mm²"));
	_tmp94_ = _tmp93_;
	unit_category_add_unit (_tmp92_, _tmp94_);
	_g_object_unref0 (_tmp94_);
	_tmp95_ = volume_category;
	_tmp96_ = unit_new ("cubic-meter", _ ("Cubic Meters"), g_dpgettext2 (NULL, "unit-format", "%s m³"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "m³"));
	_tmp97_ = _tmp96_;
	unit_category_add_unit (_tmp95_, _tmp97_);
	_g_object_unref0 (_tmp97_);
	_tmp98_ = volume_category;
	_tmp99_ = unit_new ("gallon", _ ("Gallons"), g_dpgettext2 (NULL, "unit-format", "%s gal"), "3.785412x", "x/3.785412", g_dpgettext2 (NULL, "unit-symbols", "gallon,gallons,gal"));
	_tmp100_ = _tmp99_;
	unit_category_add_unit (_tmp98_, _tmp100_);
	_g_object_unref0 (_tmp100_);
	_tmp101_ = volume_category;
	_tmp102_ = unit_new ("litre", _ ("Liters"), g_dpgettext2 (NULL, "unit-format", "%s L"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "litre,litres,liter,liters,L"));
	_tmp103_ = _tmp102_;
	unit_category_add_unit (_tmp101_, _tmp103_);
	_g_object_unref0 (_tmp103_);
	_tmp104_ = volume_category;
	_tmp105_ = unit_new ("quart", _ ("Quarts"), g_dpgettext2 (NULL, "unit-format", "%s qt"), "0.9463529x", "x/0.9463529", g_dpgettext2 (NULL, "unit-symbols", "quart,quarts,qt"));
	_tmp106_ = _tmp105_;
	unit_category_add_unit (_tmp104_, _tmp106_);
	_g_object_unref0 (_tmp106_);
	_tmp107_ = volume_category;
	_tmp108_ = unit_new ("pint", _ ("Pints"), g_dpgettext2 (NULL, "unit-format", "%s pt"), "0.4731765x", "x/0.4731765", g_dpgettext2 (NULL, "unit-symbols", "pint,pints,pt"));
	_tmp109_ = _tmp108_;
	unit_category_add_unit (_tmp107_, _tmp109_);
	_g_object_unref0 (_tmp109_);
	_tmp110_ = volume_category;
	_tmp111_ = unit_new ("millilitre", _ ("Milliliters"), g_dpgettext2 (NULL, "unit-format", "%s mL"), "0.001x", "1000x", g_dpgettext2 (NULL, "unit-symbols", "millilitre,millilitres,milliliter,milliliters,mL,cm³"));
	_tmp112_ = _tmp111_;
	unit_category_add_unit (_tmp110_, _tmp112_);
	_g_object_unref0 (_tmp112_);
	_tmp113_ = volume_category;
	_tmp114_ = unit_new ("microlitre", _ ("Microliters"), g_dpgettext2 (NULL, "unit-format", "%s μL"), "0.000001x", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "mm³,μL,uL"));
	_tmp115_ = _tmp114_;
	unit_category_add_unit (_tmp113_, _tmp115_);
	_g_object_unref0 (_tmp115_);
	_tmp116_ = weight_category;
	_tmp117_ = unit_new ("tonne", _ ("Tonnes"), g_dpgettext2 (NULL, "unit-format", "%s T"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "tonne,tonnes"));
	_tmp118_ = _tmp117_;
	unit_category_add_unit (_tmp116_, _tmp118_);
	_g_object_unref0 (_tmp118_);
	_tmp119_ = weight_category;
	_tmp120_ = unit_new ("kilograms", _ ("Kilograms"), g_dpgettext2 (NULL, "unit-format", "%s kg"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "kilogram,kilograms,kilogramme,kilogrammes,kg,kgs"));
	_tmp121_ = _tmp120_;
	unit_category_add_unit (_tmp119_, _tmp121_);
	_g_object_unref0 (_tmp121_);
	_tmp122_ = weight_category;
	_tmp123_ = unit_new ("pound", _ ("Pounds"), g_dpgettext2 (NULL, "unit-format", "%s lb"), "0.45359237x", "x/0.45359237", g_dpgettext2 (NULL, "unit-symbols", "pound,pounds,lb"));
	_tmp124_ = _tmp123_;
	unit_category_add_unit (_tmp122_, _tmp124_);
	_g_object_unref0 (_tmp124_);
	_tmp125_ = weight_category;
	_tmp126_ = unit_new ("ounce", _ ("Ounces"), g_dpgettext2 (NULL, "unit-format", "%s oz"), "0.02834952x", "x/0.02834952", g_dpgettext2 (NULL, "unit-symbols", "ounce,ounces,oz"));
	_tmp127_ = _tmp126_;
	unit_category_add_unit (_tmp125_, _tmp127_);
	_g_object_unref0 (_tmp127_);
	_tmp128_ = weight_category;
	_tmp129_ = unit_new ("gram", _ ("Grams"), g_dpgettext2 (NULL, "unit-format", "%s g"), "0.001x", "1000x", g_dpgettext2 (NULL, "unit-symbols", "gram,grams,gramme,grammes,g"));
	_tmp130_ = _tmp129_;
	unit_category_add_unit (_tmp128_, _tmp130_);
	_g_object_unref0 (_tmp130_);
	_tmp131_ = duration_category;
	_tmp132_ = unit_new ("year", _ ("Years"), g_dpgettext2 (NULL, "unit-format", "%s years"), "31557600x", "x/31557600", g_dpgettext2 (NULL, "unit-symbols", "year,years"));
	_tmp133_ = _tmp132_;
	unit_category_add_unit (_tmp131_, _tmp133_);
	_g_object_unref0 (_tmp133_);
	_tmp134_ = duration_category;
	_tmp135_ = unit_new ("day", _ ("Days"), g_dpgettext2 (NULL, "unit-format", "%s days"), "86400x", "x/86400", g_dpgettext2 (NULL, "unit-symbols", "day,days"));
	_tmp136_ = _tmp135_;
	unit_category_add_unit (_tmp134_, _tmp136_);
	_g_object_unref0 (_tmp136_);
	_tmp137_ = duration_category;
	_tmp138_ = unit_new ("hour", _ ("Hours"), g_dpgettext2 (NULL, "unit-format", "%s hours"), "3600x", "x/3600", g_dpgettext2 (NULL, "unit-symbols", "hour,hours"));
	_tmp139_ = _tmp138_;
	unit_category_add_unit (_tmp137_, _tmp139_);
	_g_object_unref0 (_tmp139_);
	_tmp140_ = duration_category;
	_tmp141_ = unit_new ("minute", _ ("Minutes"), g_dpgettext2 (NULL, "unit-format", "%s minutes"), "60x", "x/60", g_dpgettext2 (NULL, "unit-symbols", "minute,minutes"));
	_tmp142_ = _tmp141_;
	unit_category_add_unit (_tmp140_, _tmp142_);
	_g_object_unref0 (_tmp142_);
	_tmp143_ = duration_category;
	_tmp144_ = unit_new ("second", _ ("Seconds"), g_dpgettext2 (NULL, "unit-format", "%s s"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "second,seconds,s"));
	_tmp145_ = _tmp144_;
	unit_category_add_unit (_tmp143_, _tmp145_);
	_g_object_unref0 (_tmp145_);
	_tmp146_ = duration_category;
	_tmp147_ = unit_new ("millisecond", _ ("Milliseconds"), g_dpgettext2 (NULL, "unit-format", "%s ms"), "0.001x", "1000x", g_dpgettext2 (NULL, "unit-symbols", "millisecond,milliseconds,ms"));
	_tmp148_ = _tmp147_;
	unit_category_add_unit (_tmp146_, _tmp148_);
	_g_object_unref0 (_tmp148_);
	_tmp149_ = duration_category;
	_tmp150_ = unit_new ("microsecond", _ ("Microseconds"), g_dpgettext2 (NULL, "unit-format", "%s μs"), "0.000001x", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "microsecond,microseconds,us,μs"));
	_tmp151_ = _tmp150_;
	unit_category_add_unit (_tmp149_, _tmp151_);
	_g_object_unref0 (_tmp151_);
	_tmp152_ = temperature_category;
	_tmp153_ = unit_new ("degree-celcius", _ ("Celsius"), g_dpgettext2 (NULL, "unit-format", "%s ˚C"), "x+273.15", "x-273.15", g_dpgettext2 (NULL, "unit-symbols", "degC,˚C,C,c,Celsius,celsius"));
	_tmp154_ = _tmp153_;
	unit_category_add_unit (_tmp152_, _tmp154_);
	_g_object_unref0 (_tmp154_);
	_tmp155_ = temperature_category;
	_tmp156_ = unit_new ("degree-farenheit", _ ("Fahrenheit"), g_dpgettext2 (NULL, "unit-format", "%s ˚F"), "(x+459.67)*5/9", "x*9/5-459.67", g_dpgettext2 (NULL, "unit-symbols", "degF,˚F,F,f,Fahrenheit,fahrenheit"));
	_tmp157_ = _tmp156_;
	unit_category_add_unit (_tmp155_, _tmp157_);
	_g_object_unref0 (_tmp157_);
	_tmp158_ = temperature_category;
	_tmp159_ = unit_new ("degree-kelvin", _ ("Kelvin"), g_dpgettext2 (NULL, "unit-format", "%s K"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "k,K,Kelvin,kelvin"));
	_tmp160_ = _tmp159_;
	unit_category_add_unit (_tmp158_, _tmp160_);
	_g_object_unref0 (_tmp160_);
	_tmp161_ = temperature_category;
	_tmp162_ = unit_new ("degree-rankine", _ ("Rankine"), g_dpgettext2 (NULL, "unit-format", "%s ˚R"), "x*5/9", "x*9/5", g_dpgettext2 (NULL, "unit-symbols", "degR,˚R,˚Ra,r,R,Rankine,rankine"));
	_tmp163_ = _tmp162_;
	unit_category_add_unit (_tmp161_, _tmp163_);
	_g_object_unref0 (_tmp163_);
	_tmp164_ = digitalstorage_category;
	_tmp165_ = unit_new ("bit", _ ("Bits"), g_dpgettext2 (NULL, "unit-format", "%s b"), "x/8", "8x", g_dpgettext2 (NULL, "unit-symbols", "bit,bits,b"));
	_tmp166_ = _tmp165_;
	unit_category_add_unit (_tmp164_, _tmp166_);
	_g_object_unref0 (_tmp166_);
	_tmp167_ = digitalstorage_category;
	_tmp168_ = unit_new ("byte", _ ("Bytes"), g_dpgettext2 (NULL, "unit-format", "%s B"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "byte,bytes,B"));
	_tmp169_ = _tmp168_;
	unit_category_add_unit (_tmp167_, _tmp169_);
	_g_object_unref0 (_tmp169_);
	_tmp170_ = digitalstorage_category;
	_tmp171_ = unit_new ("nibble", _ ("Nibbles"), g_dpgettext2 (NULL, "unit-format", "%s nibble"), "x/2", "2x", g_dpgettext2 (NULL, "unit-symbols", "nibble,nibbles"));
	_tmp172_ = _tmp171_;
	unit_category_add_unit (_tmp170_, _tmp172_);
	_g_object_unref0 (_tmp172_);
	_tmp173_ = digitalstorage_category;
	_tmp174_ = unit_new ("kilobit", _ ("Kilobits"), g_dpgettext2 (NULL, "unit-format", "%s kb"), "1000x/8", "8x/1000", g_dpgettext2 (NULL, "unit-symbols", "kilobit,kilobits,kb,Kb"));
	_tmp175_ = _tmp174_;
	unit_category_add_unit (_tmp173_, _tmp175_);
	_g_object_unref0 (_tmp175_);
	_tmp176_ = digitalstorage_category;
	_tmp177_ = unit_new ("kilobyte", _ ("Kilobytes"), g_dpgettext2 (NULL, "unit-format", "%s kB"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "kilobyte,kilobytes,kB,KB"));
	_tmp178_ = _tmp177_;
	unit_category_add_unit (_tmp176_, _tmp178_);
	_g_object_unref0 (_tmp178_);
	_tmp179_ = digitalstorage_category;
	_tmp180_ = unit_new ("kibibit", _ ("Kibibits"), g_dpgettext2 (NULL, "unit-format", "%s Kib"), "1024x/8", "8x/1024", g_dpgettext2 (NULL, "unit-symbols", "kibibit,kibibits,Kib"));
	_tmp181_ = _tmp180_;
	unit_category_add_unit (_tmp179_, _tmp181_);
	_g_object_unref0 (_tmp181_);
	_tmp182_ = digitalstorage_category;
	_tmp183_ = unit_new ("kibibyte", _ ("Kibibytes"), g_dpgettext2 (NULL, "unit-format", "%s KiB"), "1024x", "x/1024", g_dpgettext2 (NULL, "unit-symbols", "kibibyte,kibibytes,KiB"));
	_tmp184_ = _tmp183_;
	unit_category_add_unit (_tmp182_, _tmp184_);
	_g_object_unref0 (_tmp184_);
	_tmp185_ = digitalstorage_category;
	_tmp186_ = unit_new ("megabit", _ ("Megabits"), g_dpgettext2 (NULL, "unit-format", "%s Mb"), "1000000x/8", "8x/1000000", g_dpgettext2 (NULL, "unit-symbols", "megabit,megabits,Mb"));
	_tmp187_ = _tmp186_;
	unit_category_add_unit (_tmp185_, _tmp187_);
	_g_object_unref0 (_tmp187_);
	_tmp188_ = digitalstorage_category;
	_tmp189_ = unit_new ("megabyte", _ ("Megabytes"), g_dpgettext2 (NULL, "unit-format", "%s MB"), "1000000x", "x/1000000", g_dpgettext2 (NULL, "unit-symbols", "megabyte,megabytes,MB"));
	_tmp190_ = _tmp189_;
	unit_category_add_unit (_tmp188_, _tmp190_);
	_g_object_unref0 (_tmp190_);
	_tmp191_ = digitalstorage_category;
	_tmp192_ = unit_new ("mebibit", _ ("Mebibits"), g_dpgettext2 (NULL, "unit-format", "%s Mib"), "1048576x/8", "8x/1048576", g_dpgettext2 (NULL, "unit-symbols", "mebibit,mebibits,Mib"));
	_tmp193_ = _tmp192_;
	unit_category_add_unit (_tmp191_, _tmp193_);
	_g_object_unref0 (_tmp193_);
	_tmp194_ = digitalstorage_category;
	_tmp195_ = unit_new ("mebibyte", _ ("Mebibytes"), g_dpgettext2 (NULL, "unit-format", "%s MiB"), "1048576x", "x/1048576", g_dpgettext2 (NULL, "unit-symbols", "mebibyte,mebibytes,MiB"));
	_tmp196_ = _tmp195_;
	unit_category_add_unit (_tmp194_, _tmp196_);
	_g_object_unref0 (_tmp196_);
	_tmp197_ = digitalstorage_category;
	_tmp198_ = unit_new ("gigabit", _ ("Gigabits"), g_dpgettext2 (NULL, "unit-format", "%s Gb"), "1000000000x/8", "8x/1000000000", g_dpgettext2 (NULL, "unit-symbols", "gigabit,gigabits,Gb"));
	_tmp199_ = _tmp198_;
	unit_category_add_unit (_tmp197_, _tmp199_);
	_g_object_unref0 (_tmp199_);
	_tmp200_ = digitalstorage_category;
	_tmp201_ = unit_new ("gigabyte", _ ("Gigabytes"), g_dpgettext2 (NULL, "unit-format", "%s GB"), "1000000000x", "x/1000000000", g_dpgettext2 (NULL, "unit-symbols", "gigabyte,gigabytes,GB"));
	_tmp202_ = _tmp201_;
	unit_category_add_unit (_tmp200_, _tmp202_);
	_g_object_unref0 (_tmp202_);
	_tmp203_ = digitalstorage_category;
	_tmp204_ = unit_new ("gibibit", _ ("Gibibits"), g_dpgettext2 (NULL, "unit-format", "%s Gib"), "1073741824x/8", "8x/1073741824", g_dpgettext2 (NULL, "unit-symbols", "gibibit,gibibits,Gib"));
	_tmp205_ = _tmp204_;
	unit_category_add_unit (_tmp203_, _tmp205_);
	_g_object_unref0 (_tmp205_);
	_tmp206_ = digitalstorage_category;
	_tmp207_ = unit_new ("gibibyte", _ ("Gibibytes"), g_dpgettext2 (NULL, "unit-format", "%s GiB"), "1073741824x", "x/1073741824", g_dpgettext2 (NULL, "unit-symbols", "gibibyte,gibibytes,GiB"));
	_tmp208_ = _tmp207_;
	unit_category_add_unit (_tmp206_, _tmp208_);
	_g_object_unref0 (_tmp208_);
	_tmp209_ = digitalstorage_category;
	_tmp210_ = unit_new ("terabit", _ ("Terabits"), g_dpgettext2 (NULL, "unit-format", "%s Tb"), "1000000000000x/8", "8x/1000000000000", g_dpgettext2 (NULL, "unit-symbols", "terabit,terabits,Tb"));
	_tmp211_ = _tmp210_;
	unit_category_add_unit (_tmp209_, _tmp211_);
	_g_object_unref0 (_tmp211_);
	_tmp212_ = digitalstorage_category;
	_tmp213_ = unit_new ("terabyte", _ ("Terabytes"), g_dpgettext2 (NULL, "unit-format", "%s TB"), "1000000000000x", "x/1000000000000", g_dpgettext2 (NULL, "unit-symbols", "terabyte,terabytes,TB"));
	_tmp214_ = _tmp213_;
	unit_category_add_unit (_tmp212_, _tmp214_);
	_g_object_unref0 (_tmp214_);
	_tmp215_ = digitalstorage_category;
	_tmp216_ = unit_new ("tebibit", _ ("Tebibits"), g_dpgettext2 (NULL, "unit-format", "%s Tib"), "1099511627776x/8", "8x/1099511627776", g_dpgettext2 (NULL, "unit-symbols", "tebibit,tebibits,Tib"));
	_tmp217_ = _tmp216_;
	unit_category_add_unit (_tmp215_, _tmp217_);
	_g_object_unref0 (_tmp217_);
	_tmp218_ = digitalstorage_category;
	_tmp219_ = unit_new ("tebibyte", _ ("Tebibytes"), g_dpgettext2 (NULL, "unit-format", "%s TiB"), "1099511627776x", "x/1099511627776", g_dpgettext2 (NULL, "unit-symbols", "tebibyte,tebibytes,TiB"));
	_tmp220_ = _tmp219_;
	unit_category_add_unit (_tmp218_, _tmp220_);
	_g_object_unref0 (_tmp220_);
	_tmp221_ = digitalstorage_category;
	_tmp222_ = unit_new ("petabit", _ ("Petabits"), g_dpgettext2 (NULL, "unit-format", "%s Pb"), "1000000000000000x/8", "8x/1000000000000000", g_dpgettext2 (NULL, "unit-symbols", "petabit,petabits,Pb"));
	_tmp223_ = _tmp222_;
	unit_category_add_unit (_tmp221_, _tmp223_);
	_g_object_unref0 (_tmp223_);
	_tmp224_ = digitalstorage_category;
	_tmp225_ = unit_new ("petabyte", _ ("Petabytes"), g_dpgettext2 (NULL, "unit-format", "%s PB"), "1000000000000000x", "x/1000000000000000", g_dpgettext2 (NULL, "unit-symbols", "petabyte,petabytes,PB"));
	_tmp226_ = _tmp225_;
	unit_category_add_unit (_tmp224_, _tmp226_);
	_g_object_unref0 (_tmp226_);
	_tmp227_ = digitalstorage_category;
	_tmp228_ = unit_new ("pebibit", _ ("Pebibits"), g_dpgettext2 (NULL, "unit-format", "%s Pib"), "1125899906842624x/8", "8x/1125899906842624", g_dpgettext2 (NULL, "unit-symbols", "pebibit,pebibits,Pib"));
	_tmp229_ = _tmp228_;
	unit_category_add_unit (_tmp227_, _tmp229_);
	_g_object_unref0 (_tmp229_);
	_tmp230_ = digitalstorage_category;
	_tmp231_ = unit_new ("pebibyte", _ ("Pebibytes"), g_dpgettext2 (NULL, "unit-format", "%s PiB"), "1125899906842624x", "x/1125899906842624", g_dpgettext2 (NULL, "unit-symbols", "pebibyte,pebibytes,PiB"));
	_tmp232_ = _tmp231_;
	unit_category_add_unit (_tmp230_, _tmp232_);
	_g_object_unref0 (_tmp232_);
	_tmp233_ = digitalstorage_category;
	_tmp234_ = unit_new ("exabit", _ ("Exabits"), g_dpgettext2 (NULL, "unit-format", "%s Eb"), "1000000000000000000x/8", "8x/1000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "exabit,exabits,Eb"));
	_tmp235_ = _tmp234_;
	unit_category_add_unit (_tmp233_, _tmp235_);
	_g_object_unref0 (_tmp235_);
	_tmp236_ = digitalstorage_category;
	_tmp237_ = unit_new ("exabyte", _ ("Exabytes"), g_dpgettext2 (NULL, "unit-format", "%s EB"), "1000000000000000000x", "x/1000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "exabyte,exabytes,EB"));
	_tmp238_ = _tmp237_;
	unit_category_add_unit (_tmp236_, _tmp238_);
	_g_object_unref0 (_tmp238_);
	_tmp239_ = digitalstorage_category;
	_tmp240_ = unit_new ("exbibit", _ ("Exbibits"), g_dpgettext2 (NULL, "unit-format", "%s Eib"), "1152921504606846976x/8", "8x/1152921504606846976", g_dpgettext2 (NULL, "unit-symbols", "exbibit,exbibits,Eib"));
	_tmp241_ = _tmp240_;
	unit_category_add_unit (_tmp239_, _tmp241_);
	_g_object_unref0 (_tmp241_);
	_tmp242_ = digitalstorage_category;
	_tmp243_ = unit_new ("exbibyte", _ ("Exbibytes"), g_dpgettext2 (NULL, "unit-format", "%s EiB"), "1152921504606846976x", "x/1152921504606846976", g_dpgettext2 (NULL, "unit-symbols", "exbibyte,exbibytes,EiB"));
	_tmp244_ = _tmp243_;
	unit_category_add_unit (_tmp242_, _tmp244_);
	_g_object_unref0 (_tmp244_);
	_tmp245_ = digitalstorage_category;
	_tmp246_ = unit_new ("zettabit", _ ("Zettabits"), g_dpgettext2 (NULL, "unit-format", "%s Eb"), "1000000000000000000000x/8", "8x/1000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "zettabit,zettabits,Zb"));
	_tmp247_ = _tmp246_;
	unit_category_add_unit (_tmp245_, _tmp247_);
	_g_object_unref0 (_tmp247_);
	_tmp248_ = digitalstorage_category;
	_tmp249_ = unit_new ("zettabyte", _ ("Zettabytes"), g_dpgettext2 (NULL, "unit-format", "%s EB"), "1000000000000000000000x", "x/1000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "zettabyte,zettabytes,ZB"));
	_tmp250_ = _tmp249_;
	unit_category_add_unit (_tmp248_, _tmp250_);
	_g_object_unref0 (_tmp250_);
	_tmp251_ = digitalstorage_category;
	_tmp252_ = unit_new ("zebibit", _ ("Zebibits"), g_dpgettext2 (NULL, "unit-format", "%s Zib"), "1180591620717411303424x/8", "8x/1180591620717411303424", g_dpgettext2 (NULL, "unit-symbols", "zebibit,zebibits,Zib"));
	_tmp253_ = _tmp252_;
	unit_category_add_unit (_tmp251_, _tmp253_);
	_g_object_unref0 (_tmp253_);
	_tmp254_ = digitalstorage_category;
	_tmp255_ = unit_new ("zebibyte", _ ("Zebibytes"), g_dpgettext2 (NULL, "unit-format", "%s ZiB"), "1180591620717411303424x", "x/1180591620717411303424", g_dpgettext2 (NULL, "unit-symbols", "zebibyte,zebibytes,ZiB"));
	_tmp256_ = _tmp255_;
	unit_category_add_unit (_tmp254_, _tmp256_);
	_g_object_unref0 (_tmp256_);
	_tmp257_ = digitalstorage_category;
	_tmp258_ = unit_new ("yottabit", _ ("Yottabits"), g_dpgettext2 (NULL, "unit-format", "%s Yb"), "1000000000000000000000000x/8", "8x/1000000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "yottabit,yottabits,Yb"));
	_tmp259_ = _tmp258_;
	unit_category_add_unit (_tmp257_, _tmp259_);
	_g_object_unref0 (_tmp259_);
	_tmp260_ = digitalstorage_category;
	_tmp261_ = unit_new ("yottabyte", _ ("Yottabytes"), g_dpgettext2 (NULL, "unit-format", "%s YB"), "1000000000000000000000000x", "x/1000000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "yottabyte,yottabytes,YB"));
	_tmp262_ = _tmp261_;
	unit_category_add_unit (_tmp260_, _tmp262_);
	_g_object_unref0 (_tmp262_);
	_tmp263_ = digitalstorage_category;
	_tmp264_ = unit_new ("yobibit", _ ("Yobibits"), g_dpgettext2 (NULL, "unit-format", "%s Yib"), "1208925819614629174706176x/8", "8x/1208925819614629174706176", g_dpgettext2 (NULL, "unit-symbols", "yobibit,yobibits,Yib"));
	_tmp265_ = _tmp264_;
	unit_category_add_unit (_tmp263_, _tmp265_);
	_g_object_unref0 (_tmp265_);
	_tmp266_ = digitalstorage_category;
	_tmp267_ = unit_new ("yobibyte", _ ("Yobibytes"), g_dpgettext2 (NULL, "unit-format", "%s YiB"), "1208925819614629174706176x", "x/1208925819614629174706176", g_dpgettext2 (NULL, "unit-symbols", "yobibyte,yobibytes,YiB"));
	_tmp268_ = _tmp267_;
	unit_category_add_unit (_tmp266_, _tmp268_);
	_g_object_unref0 (_tmp268_);
	_tmp269_ = default_unit_manager;
	_tmp270_ = unit_manager_add_category (_tmp269_, "currency", _ ("Currency"));
	currency_category = _tmp270_;
	_tmp271_ = currency_manager_get_default ();
	_tmp272_ = _tmp271_;
	_tmp273_ = currency_manager_get_currencies (_tmp272_);
	_tmp274_ = _tmp273_;
	_g_object_unref0 (_tmp272_);
	currencies = _tmp274_;
	currencies = g_list_sort (currencies, ___lambda9__gcompare_func);
	_tmp275_ = currencies;
	{
		GList* currency_collection = NULL;
		GList* currency_it = NULL;
		currency_collection = _tmp275_;
		for (currency_it = currency_collection; currency_it != NULL; currency_it = currency_it->next) {
			Currency* _tmp276_;
			Currency* currency = NULL;
			_tmp276_ = _g_object_ref0 ((Currency*) currency_it->data);
			currency = _tmp276_;
			{
				gchar* format = NULL;
				Currency* _tmp277_;
				gchar* _tmp278_;
				gchar* _tmp279_;
				gchar* _tmp280_;
				gchar* _tmp281_;
				gchar* _tmp282_;
				Unit* unit = NULL;
				Currency* _tmp283_;
				gchar* _tmp284_;
				gchar* _tmp285_;
				gchar* _tmp286_;
				Currency* _tmp287_;
				gchar* _tmp288_;
				gchar* _tmp289_;
				gchar* _tmp290_;
				const gchar* _tmp291_;
				Currency* _tmp292_;
				gchar* _tmp293_;
				gchar* _tmp294_;
				gchar* _tmp295_;
				Unit* _tmp296_;
				Unit* _tmp297_;
				UnitCategory* _tmp298_;
				Unit* _tmp299_;
				_tmp277_ = currency;
				_tmp278_ = currency_get_symbol (_tmp277_);
				_tmp279_ = _tmp278_;
				_tmp280_ = _tmp279_;
				_tmp281_ = g_strdup_printf (_ ("%s%%s"), _tmp280_);
				_tmp282_ = _tmp281_;
				_g_free0 (_tmp280_);
				format = _tmp282_;
				_tmp283_ = currency;
				_tmp284_ = currency_get_name (_tmp283_);
				_tmp285_ = _tmp284_;
				_tmp286_ = _tmp285_;
				_tmp287_ = currency;
				_tmp288_ = currency_get_display_name (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = _tmp289_;
				_tmp291_ = format;
				_tmp292_ = currency;
				_tmp293_ = currency_get_name (_tmp292_);
				_tmp294_ = _tmp293_;
				_tmp295_ = _tmp294_;
				_tmp296_ = unit_new (_tmp286_, _tmp290_, _tmp291_, NULL, NULL, _tmp295_);
				_tmp297_ = _tmp296_;
				_g_free0 (_tmp295_);
				_g_free0 (_tmp290_);
				_g_free0 (_tmp286_);
				unit = _tmp297_;
				_tmp298_ = currency_category;
				_tmp299_ = unit;
				unit_category_add_unit (_tmp298_, _tmp299_);
				_g_object_unref0 (unit);
				_g_free0 (format);
				_g_object_unref0 (currency);
			}
		}
	}
	_tmp300_ = default_unit_manager;
	_tmp301_ = _g_object_ref0 (_tmp300_);
	result = _tmp301_;
	__g_list_free__g_object_unref0_0 (currencies);
	_g_object_unref0 (currency_category);
	_g_object_unref0 (digitalstorage_category);
	_g_object_unref0 (temperature_category);
	_g_object_unref0 (duration_category);
	_g_object_unref0 (weight_category);
	_g_object_unref0 (volume_category);
	_g_object_unref0 (area_category);
	_g_object_unref0 (length_category);
	_g_object_unref0 (angle_category);
	return result;
}


UnitCategory* unit_manager_add_category (UnitManager* self, const gchar* name, const gchar* display_name) {
	UnitCategory* result = NULL;
	UnitCategory* category = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	UnitCategory* _tmp2_;
	UnitCategory* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = display_name;
	_tmp2_ = unit_category_new (_tmp0_, _tmp1_);
	category = _tmp2_;
	_tmp3_ = _g_object_ref0 (category);
	self->priv->categories = g_list_append (self->priv->categories, _tmp3_);
	result = category;
	return result;
}


GList* unit_manager_get_categories (UnitManager* self) {
	GList* result = NULL;
	GList* r = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				UnitCategory* _tmp2_;
				UnitCategory* _tmp3_;
				_tmp2_ = c;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				r = g_list_append (r, _tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	result = r;
	return result;
}


UnitCategory* unit_manager_get_category (UnitManager* self, const gchar* category) {
	UnitCategory* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				UnitCategory* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = c;
				_tmp3_ = unit_category_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = category;
				_tmp7_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp7_) {
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


Unit* unit_manager_get_unit_by_name (UnitManager* self, const gchar* name) {
	Unit* result = NULL;
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	gint _tmp9_;
	GList* _tmp11_;
	gint _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp2_;
				const gchar* _tmp3_;
				Unit* _tmp4_;
				Unit* _tmp5_;
				_tmp2_ = c;
				_tmp3_ = name;
				_tmp4_ = unit_category_get_unit_by_name (_tmp2_, _tmp3_, TRUE);
				u = _tmp4_;
				_tmp5_ = u;
				if (_tmp5_ != NULL) {
					Unit* _tmp6_;
					Unit* _tmp7_;
					gint _tmp8_;
					_tmp6_ = u;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp7_;
					_tmp8_ = count;
					count = _tmp8_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	_tmp9_ = count;
	if (_tmp9_ > 1) {
		result = NULL;
		_g_object_unref0 (return_unit);
		return result;
	} else {
		gint _tmp10_;
		_tmp10_ = count;
		if (_tmp10_ == 1) {
			result = return_unit;
			return result;
		}
	}
	_tmp11_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp11_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp12_;
			UnitCategory* c = NULL;
			_tmp12_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp12_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp13_;
				const gchar* _tmp14_;
				Unit* _tmp15_;
				Unit* _tmp16_;
				_tmp13_ = c;
				_tmp14_ = name;
				_tmp15_ = unit_category_get_unit_by_name (_tmp13_, _tmp14_, FALSE);
				u = _tmp15_;
				_tmp16_ = u;
				if (_tmp16_ != NULL) {
					Unit* _tmp17_;
					Unit* _tmp18_;
					gint _tmp19_;
					_tmp17_ = u;
					_tmp18_ = _g_object_ref0 (_tmp17_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp18_;
					_tmp19_ = count;
					count = _tmp19_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	_tmp20_ = count;
	if (_tmp20_ == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}


Unit* unit_manager_get_unit_by_symbol (UnitManager* self, const gchar* symbol) {
	Unit* result = NULL;
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	gint _tmp9_;
	GList* _tmp11_;
	gint _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp2_;
				const gchar* _tmp3_;
				Unit* _tmp4_;
				Unit* _tmp5_;
				_tmp2_ = c;
				_tmp3_ = symbol;
				_tmp4_ = unit_category_get_unit_by_symbol (_tmp2_, _tmp3_, TRUE);
				u = _tmp4_;
				_tmp5_ = u;
				if (_tmp5_ != NULL) {
					Unit* _tmp6_;
					Unit* _tmp7_;
					gint _tmp8_;
					_tmp6_ = u;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp7_;
					_tmp8_ = count;
					count = _tmp8_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	_tmp9_ = count;
	if (_tmp9_ > 1) {
		result = NULL;
		_g_object_unref0 (return_unit);
		return result;
	} else {
		gint _tmp10_;
		_tmp10_ = count;
		if (_tmp10_ == 1) {
			result = return_unit;
			return result;
		}
	}
	_tmp11_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp11_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp12_;
			UnitCategory* c = NULL;
			_tmp12_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp12_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp13_;
				const gchar* _tmp14_;
				Unit* _tmp15_;
				Unit* _tmp16_;
				_tmp13_ = c;
				_tmp14_ = symbol;
				_tmp15_ = unit_category_get_unit_by_symbol (_tmp13_, _tmp14_, FALSE);
				u = _tmp15_;
				_tmp16_ = u;
				if (_tmp16_ != NULL) {
					Unit* _tmp17_;
					Unit* _tmp18_;
					gint _tmp19_;
					_tmp17_ = u;
					_tmp18_ = _g_object_ref0 (_tmp17_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp18_;
					_tmp19_ = count;
					count = _tmp19_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	_tmp20_ = count;
	if (_tmp20_ == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}


gboolean unit_manager_unit_is_defined (UnitManager* self, const gchar* name) {
	gboolean result = FALSE;
	Unit* unit = NULL;
	const gchar* _tmp0_;
	Unit* _tmp1_;
	Unit* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = unit_manager_get_unit_by_symbol (self, _tmp0_);
	unit = _tmp1_;
	_tmp2_ = unit;
	if (_tmp2_ != NULL) {
		result = TRUE;
		_g_object_unref0 (unit);
		return result;
	} else {
		result = FALSE;
		_g_object_unref0 (unit);
		return result;
	}
	_g_object_unref0 (unit);
}


Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol) {
	Number* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_symbol != NULL, NULL);
	g_return_val_if_fail (z_symbol != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* x_units = NULL;
				UnitCategory* _tmp2_;
				const gchar* _tmp3_;
				Unit* _tmp4_;
				Unit* _tmp5_;
				Unit* z_units = NULL;
				UnitCategory* _tmp9_;
				const gchar* _tmp10_;
				Unit* _tmp11_;
				Unit* _tmp12_;
				gboolean _tmp16_ = FALSE;
				Unit* _tmp17_;
				_tmp2_ = c;
				_tmp3_ = x_symbol;
				_tmp4_ = unit_category_get_unit_by_symbol (_tmp2_, _tmp3_, TRUE);
				x_units = _tmp4_;
				_tmp5_ = x_units;
				if (_tmp5_ == NULL) {
					UnitCategory* _tmp6_;
					const gchar* _tmp7_;
					Unit* _tmp8_;
					_tmp6_ = c;
					_tmp7_ = x_symbol;
					_tmp8_ = unit_category_get_unit_by_symbol (_tmp6_, _tmp7_, FALSE);
					_g_object_unref0 (x_units);
					x_units = _tmp8_;
				}
				_tmp9_ = c;
				_tmp10_ = z_symbol;
				_tmp11_ = unit_category_get_unit_by_symbol (_tmp9_, _tmp10_, TRUE);
				z_units = _tmp11_;
				_tmp12_ = z_units;
				if (_tmp12_ == NULL) {
					UnitCategory* _tmp13_;
					const gchar* _tmp14_;
					Unit* _tmp15_;
					_tmp13_ = c;
					_tmp14_ = z_symbol;
					_tmp15_ = unit_category_get_unit_by_symbol (_tmp13_, _tmp14_, FALSE);
					_g_object_unref0 (z_units);
					z_units = _tmp15_;
				}
				_tmp17_ = x_units;
				if (_tmp17_ != NULL) {
					Unit* _tmp18_;
					_tmp18_ = z_units;
					_tmp16_ = _tmp18_ != NULL;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					UnitCategory* _tmp19_;
					Number* _tmp20_;
					Unit* _tmp21_;
					Unit* _tmp22_;
					Number* _tmp23_;
					_tmp19_ = c;
					_tmp20_ = x;
					_tmp21_ = x_units;
					_tmp22_ = z_units;
					_tmp23_ = unit_category_convert (_tmp19_, _tmp20_, _tmp21_, _tmp22_);
					result = _tmp23_;
					_g_object_unref0 (z_units);
					_g_object_unref0 (x_units);
					_g_object_unref0 (c);
					return result;
				}
				_g_object_unref0 (z_units);
				_g_object_unref0 (x_units);
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


static void unit_manager_class_init (UnitManagerClass * klass) {
	unit_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = unit_manager_finalize;
}


static void unit_manager_instance_init (UnitManager * self) {
	self->priv = UNIT_MANAGER_GET_PRIVATE (self);
}


static void unit_manager_finalize (GObject * obj) {
	UnitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_MANAGER, UnitManager);
	__g_list_free__g_object_unref0_0 (self->priv->categories);
	G_OBJECT_CLASS (unit_manager_parent_class)->finalize (obj);
}


GType unit_manager_get_type (void) {
	static volatile gsize unit_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unit_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitManager), 0, (GInstanceInitFunc) unit_manager_instance_init, NULL };
		GType unit_manager_type_id;
		unit_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitManager", &g_define_type_info, 0);
		g_once_init_leave (&unit_manager_type_id__volatile, unit_manager_type_id);
	}
	return unit_manager_type_id__volatile;
}


UnitCategory* unit_category_construct (GType object_type, const gchar* name, const gchar* display_name) {
	UnitCategory * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnitCategory*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp3_;
	__g_list_free__g_object_unref0_0 (self->priv->units);
	self->priv->units = NULL;
	return self;
}


UnitCategory* unit_category_new (const gchar* name, const gchar* display_name) {
	return unit_category_construct (TYPE_UNIT_CATEGORY, name, display_name);
}


void unit_category_add_unit (UnitCategory* self, Unit* unit) {
	Unit* _tmp0_;
	Unit* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unit != NULL);
	_tmp0_ = unit;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	self->priv->units = g_list_append (self->priv->units, _tmp1_);
}


Unit* unit_category_get_unit_by_name (UnitCategory* self, const gchar* name, gboolean case_sensitive) {
	Unit* result = NULL;
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	gint _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp0_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp1_;
			Unit* unit = NULL;
			_tmp1_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_;
				_tmp4_ = case_sensitive;
				if (_tmp4_) {
					Unit* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					const gchar* _tmp9_;
					_tmp5_ = unit;
					_tmp6_ = unit_get_name (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = _tmp7_;
					_tmp9_ = name;
					_tmp3_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
					_g_free0 (_tmp8_);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_;
					_tmp11_ = case_sensitive;
					if (!_tmp11_) {
						Unit* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						const gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						_tmp12_ = unit;
						_tmp13_ = unit_get_name (_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = _tmp14_;
						_tmp16_ = g_utf8_strdown (_tmp15_, (gssize) -1);
						_tmp17_ = _tmp16_;
						_tmp18_ = name;
						_tmp19_ = g_utf8_strdown (_tmp18_, (gssize) -1);
						_tmp20_ = _tmp19_;
						_tmp10_ = g_strcmp0 (_tmp17_, _tmp20_) == 0;
						_g_free0 (_tmp20_);
						_g_free0 (_tmp17_);
						_g_free0 (_tmp15_);
					} else {
						_tmp10_ = FALSE;
					}
					_tmp2_ = _tmp10_;
				}
				if (_tmp2_) {
					Unit* _tmp21_;
					Unit* _tmp22_;
					gint _tmp23_;
					_tmp21_ = unit;
					_tmp22_ = _g_object_ref0 (_tmp21_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp22_;
					_tmp23_ = count;
					count = _tmp23_ + 1;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	_tmp24_ = count;
	if (_tmp24_ == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}


Unit* unit_category_get_unit_by_symbol (UnitCategory* self, const gchar* symbol, gboolean case_sensitive) {
	Unit* result = NULL;
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	gint _tmp8_;
	GList* _tmp10_;
	gint _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp0_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp1_;
			Unit* unit = NULL;
			_tmp1_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp1_;
			{
				Unit* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = unit;
				_tmp3_ = symbol;
				_tmp4_ = unit_matches_symbol (_tmp2_, _tmp3_, TRUE);
				if (_tmp4_) {
					Unit* _tmp5_;
					Unit* _tmp6_;
					gint _tmp7_;
					_tmp5_ = unit;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp6_;
					_tmp7_ = count;
					count = _tmp7_ + 1;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	_tmp8_ = count;
	if (_tmp8_ > 1) {
		result = NULL;
		_g_object_unref0 (return_unit);
		return result;
	} else {
		gint _tmp9_;
		_tmp9_ = count;
		if (_tmp9_ == 1) {
			result = return_unit;
			return result;
		}
	}
	_tmp10_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp10_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp11_;
			Unit* unit = NULL;
			_tmp11_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp11_;
			{
				Unit* _tmp12_;
				const gchar* _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = unit;
				_tmp13_ = symbol;
				_tmp14_ = unit_matches_symbol (_tmp12_, _tmp13_, FALSE);
				if (_tmp14_) {
					Unit* _tmp15_;
					Unit* _tmp16_;
					gint _tmp17_;
					_tmp15_ = unit;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp16_;
					_tmp17_ = count;
					count = _tmp17_ + 1;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	_tmp18_ = count;
	if (_tmp18_ == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}


GList* unit_category_get_units (UnitCategory* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->units;
	result = _tmp0_;
	return result;
}


Number* unit_category_convert (UnitCategory* self, Number* x, Unit* x_units, Unit* z_units) {
	Number* result = NULL;
	Number* t = NULL;
	Unit* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Unit* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = x_units;
	_tmp1_ = x;
	_tmp2_ = unit_convert_from (_tmp0_, _tmp1_);
	t = _tmp2_;
	_tmp3_ = t;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (t);
		return result;
	}
	_tmp4_ = z_units;
	_tmp5_ = t;
	_tmp6_ = unit_convert_to (_tmp4_, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (t);
	return result;
}


gchar* unit_category_get_name (UnitCategory* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* unit_category_get_display_name (UnitCategory* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void unit_category_class_init (UnitCategoryClass * klass) {
	unit_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitCategoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unit_category_get_property;
	G_OBJECT_CLASS (klass)->finalize = unit_category_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_CATEGORY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_CATEGORY_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unit_category_instance_init (UnitCategory * self) {
	self->priv = UNIT_CATEGORY_GET_PRIVATE (self);
}


static void unit_category_finalize (GObject * obj) {
	UnitCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_CATEGORY, UnitCategory);
	__g_list_free__g_object_unref0_0 (self->priv->units);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	G_OBJECT_CLASS (unit_category_parent_class)->finalize (obj);
}


GType unit_category_get_type (void) {
	static volatile gsize unit_category_type_id__volatile = 0;
	if (g_once_init_enter (&unit_category_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitCategory), 0, (GInstanceInitFunc) unit_category_instance_init, NULL };
		GType unit_category_type_id;
		unit_category_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitCategory", &g_define_type_info, 0);
		g_once_init_leave (&unit_category_type_id__volatile, unit_category_type_id);
	}
	return unit_category_type_id__volatile;
}


static void _vala_unit_category_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnitCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIT_CATEGORY, UnitCategory);
	switch (property_id) {
		case UNIT_CATEGORY_NAME:
		g_value_take_string (value, unit_category_get_name (self));
		break;
		case UNIT_CATEGORY_DISPLAY_NAME:
		g_value_take_string (value, unit_category_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


Unit* unit_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols) {
	Unit * self = NULL;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** symbol_names = NULL;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint symbol_names_length1;
	gint _symbol_names_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	g_return_val_if_fail (symbols != NULL, NULL);
	self = (Unit*) g_object_new (object_type, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 2);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp0_;
	_tmp1_ = self->priv->serializer;
	serializer_set_leading_digits (_tmp1_, 6);
	_tmp2_ = name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp3_;
	_tmp4_ = display_name;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp5_;
	_tmp6_ = format;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->_format);
	self->priv->_format = _tmp7_;
	_tmp8_ = from_function;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->priv->from_function);
	self->priv->from_function = _tmp9_;
	_tmp10_ = to_function;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->to_function);
	self->priv->to_function = _tmp11_;
	__g_list_free__g_free0_0 (self->priv->_symbols);
	self->priv->_symbols = NULL;
	_tmp12_ = symbols;
	_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, ",", 0);
	symbol_names = _tmp14_;
	symbol_names_length1 = _vala_array_length (_tmp13_);
	_symbol_names_size_ = symbol_names_length1;
	_tmp15_ = symbol_names;
	_tmp15__length1 = symbol_names_length1;
	{
		gchar** symbol_name_collection = NULL;
		gint symbol_name_collection_length1 = 0;
		gint _symbol_name_collection_size_ = 0;
		gint symbol_name_it = 0;
		symbol_name_collection = _tmp15_;
		symbol_name_collection_length1 = _tmp15__length1;
		for (symbol_name_it = 0; symbol_name_it < _tmp15__length1; symbol_name_it = symbol_name_it + 1) {
			gchar* _tmp16_;
			gchar* symbol_name = NULL;
			_tmp16_ = g_strdup (symbol_name_collection[symbol_name_it]);
			symbol_name = _tmp16_;
			{
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = symbol_name;
				_tmp18_ = g_strdup (_tmp17_);
				self->priv->_symbols = g_list_append (self->priv->_symbols, _tmp18_);
				_g_free0 (symbol_name);
			}
		}
	}
	symbol_names = (_vala_array_free (symbol_names, symbol_names_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Unit* unit_new (const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols) {
	return unit_construct (TYPE_UNIT, name, display_name, format, from_function, to_function, symbols);
}


gboolean unit_matches_symbol (Unit* self, const gchar* symbol, gboolean case_sensitive) {
	gboolean result = FALSE;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = self->priv->_symbols;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp0_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp1_;
			gchar* s = NULL;
			_tmp1_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_;
				_tmp4_ = case_sensitive;
				if (_tmp4_) {
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					_tmp5_ = s;
					_tmp6_ = symbol;
					_tmp3_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					gboolean _tmp7_ = FALSE;
					gboolean _tmp8_;
					_tmp8_ = case_sensitive;
					if (!_tmp8_) {
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						const gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp9_ = s;
						_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
						_tmp11_ = _tmp10_;
						_tmp12_ = symbol;
						_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
						_tmp14_ = _tmp13_;
						_tmp7_ = g_strcmp0 (_tmp11_, _tmp14_) == 0;
						_g_free0 (_tmp14_);
						_g_free0 (_tmp11_);
					} else {
						_tmp7_ = FALSE;
					}
					_tmp2_ = _tmp7_;
				}
				if (_tmp2_) {
					result = TRUE;
					_g_free0 (s);
					return result;
				}
				_g_free0 (s);
			}
		}
	}
	result = FALSE;
	return result;
}


GList* unit_get_symbols (Unit* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbols;
	result = _tmp0_;
	return result;
}


Number* unit_convert_from (Unit* self, Number* x) {
	Number* result = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->from_function;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = self->priv->from_function;
		_tmp2_ = x;
		_tmp3_ = unit_solve_function (self, _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		Number* r = NULL;
		CurrencyManager* _tmp4_;
		CurrencyManager* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		Number* _tmp12_;
		Number* _tmp13_;
		Number* _tmp14_;
		_tmp4_ = currency_manager_get_default ();
		_tmp5_ = _tmp4_;
		_tmp6_ = unit_get_name (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = currency_manager_get_value (_tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp5_);
		r = _tmp10_;
		_tmp11_ = r;
		if (_tmp11_ == NULL) {
			result = NULL;
			_g_object_unref0 (r);
			return result;
		}
		_tmp12_ = x;
		_tmp13_ = r;
		_tmp14_ = number_divide (_tmp12_, _tmp13_);
		result = _tmp14_;
		_g_object_unref0 (r);
		return result;
	}
}


Number* unit_convert_to (Unit* self, Number* x) {
	Number* result = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->to_function;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = self->priv->to_function;
		_tmp2_ = x;
		_tmp3_ = unit_solve_function (self, _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		Number* r = NULL;
		CurrencyManager* _tmp4_;
		CurrencyManager* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		Number* _tmp12_;
		Number* _tmp13_;
		Number* _tmp14_;
		_tmp4_ = currency_manager_get_default ();
		_tmp5_ = _tmp4_;
		_tmp6_ = unit_get_name (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = currency_manager_get_value (_tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp5_);
		r = _tmp10_;
		_tmp11_ = r;
		if (_tmp11_ == NULL) {
			result = NULL;
			_g_object_unref0 (r);
			return result;
		}
		_tmp12_ = x;
		_tmp13_ = r;
		_tmp14_ = number_multiply (_tmp12_, _tmp13_);
		result = _tmp14_;
		_g_object_unref0 (r);
		return result;
	}
}


gchar* unit_format (Unit* self, Number* x) {
	gchar* result = NULL;
	gchar* number_text = NULL;
	Serializer* _tmp0_;
	Number* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->serializer;
	_tmp1_ = x;
	_tmp2_ = serializer_to_string (_tmp0_, _tmp1_);
	number_text = _tmp2_;
	_tmp3_ = self->priv->_format;
	_tmp4_ = g_strdup_printf (_tmp3_, number_text);
	result = _tmp4_;
	_g_free0 (number_text);
	return result;
}


static Number* unit_solve_function (Unit* self, const gchar* function, Number* x) {
	Number* result = NULL;
	UnitSolveEquation* equation = NULL;
	const gchar* _tmp0_;
	Number* _tmp1_;
	UnitSolveEquation* _tmp2_;
	UnitSolveEquation* _tmp3_;
	UnitSolveEquation* _tmp4_;
	Number* z = NULL;
	UnitSolveEquation* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (function != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = function;
	_tmp1_ = x;
	_tmp2_ = unit_solve_equation_new (_tmp0_, _tmp1_);
	equation = _tmp2_;
	_tmp3_ = equation;
	((Equation*) _tmp3_)->base = 10;
	_tmp4_ = equation;
	((Equation*) _tmp4_)->wordlen = 32;
	_tmp5_ = equation;
	_tmp6_ = equation_parse ((Equation*) _tmp5_, NULL, NULL, NULL, NULL, NULL);
	z = _tmp6_;
	_tmp7_ = z;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		_tmp8_ = function;
		g_warning ("unit.vala:416: Failed to convert value: %s", _tmp8_);
	}
	result = z;
	_g_object_unref0 (equation);
	return result;
}


gchar* unit_get_name (Unit* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* unit_get_display_name (Unit* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void unit_class_init (UnitClass * klass) {
	unit_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unit_get_property;
	G_OBJECT_CLASS (klass)->finalize = unit_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unit_instance_init (Unit * self) {
	self->priv = UNIT_GET_PRIVATE (self);
}


static void unit_finalize (GObject * obj) {
	Unit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT, Unit);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_format);
	__g_list_free__g_free0_0 (self->priv->_symbols);
	_g_free0 (self->priv->from_function);
	_g_free0 (self->priv->to_function);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (unit_parent_class)->finalize (obj);
}


GType unit_get_type (void) {
	static volatile gsize unit_type_id__volatile = 0;
	if (g_once_init_enter (&unit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Unit), 0, (GInstanceInitFunc) unit_instance_init, NULL };
		GType unit_type_id;
		unit_type_id = g_type_register_static (G_TYPE_OBJECT, "Unit", &g_define_type_info, 0);
		g_once_init_leave (&unit_type_id__volatile, unit_type_id);
	}
	return unit_type_id__volatile;
}


static void _vala_unit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Unit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIT, Unit);
	switch (property_id) {
		case UNIT_NAME:
		g_value_take_string (value, unit_get_name (self));
		break;
		case UNIT_DISPLAY_NAME:
		g_value_take_string (value, unit_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnitSolveEquation* unit_solve_equation_construct (GType object_type, const gchar* function, Number* x) {
	UnitSolveEquation * self = NULL;
	const gchar* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	g_return_val_if_fail (function != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = function;
	self = (UnitSolveEquation*) equation_construct (object_type, _tmp0_);
	_tmp1_ = x;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->x);
	self->priv->x = _tmp2_;
	return self;
}


UnitSolveEquation* unit_solve_equation_new (const gchar* function, Number* x) {
	return unit_solve_equation_construct (TYPE_UNIT_SOLVE_EQUATION, function, x);
}


static gboolean unit_solve_equation_real_variable_is_defined (Equation* base, const gchar* name) {
	UnitSolveEquation * self;
	gboolean result = FALSE;
	self = (UnitSolveEquation*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	result = TRUE;
	return result;
}


static Number* unit_solve_equation_real_get_variable (Equation* base, const gchar* name) {
	UnitSolveEquation * self;
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	self = (UnitSolveEquation*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->x;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void unit_solve_equation_class_init (UnitSolveEquationClass * klass) {
	unit_solve_equation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitSolveEquationPrivate));
	((EquationClass *) klass)->variable_is_defined = (gboolean (*) (Equation *, const gchar*)) unit_solve_equation_real_variable_is_defined;
	((EquationClass *) klass)->get_variable = (Number* (*) (Equation *, const gchar*)) unit_solve_equation_real_get_variable;
	G_OBJECT_CLASS (klass)->finalize = unit_solve_equation_finalize;
}


static void unit_solve_equation_instance_init (UnitSolveEquation * self) {
	self->priv = UNIT_SOLVE_EQUATION_GET_PRIVATE (self);
}


static void unit_solve_equation_finalize (GObject * obj) {
	UnitSolveEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquation);
	_g_object_unref0 (self->priv->x);
	G_OBJECT_CLASS (unit_solve_equation_parent_class)->finalize (obj);
}


GType unit_solve_equation_get_type (void) {
	static volatile gsize unit_solve_equation_type_id__volatile = 0;
	if (g_once_init_enter (&unit_solve_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitSolveEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_solve_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitSolveEquation), 0, (GInstanceInitFunc) unit_solve_equation_instance_init, NULL };
		GType unit_solve_equation_type_id;
		unit_solve_equation_type_id = g_type_register_static (TYPE_EQUATION, "UnitSolveEquation", &g_define_type_info, 0);
		g_once_init_leave (&unit_solve_equation_type_id__volatile, unit_solve_equation_type_id);
	}
	return unit_solve_equation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



