/* serializer.c generated by valac 0.20.1, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "langinfo.h"
#include <stdlib.h>
#include <string.h>


#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
typedef struct _SerializerPrivate SerializerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

struct _Serializer {
	GObject parent_instance;
	SerializerPrivate * priv;
};

struct _SerializerClass {
	GObjectClass parent_class;
};

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
};


static gpointer serializer_parent_class = NULL;

GType display_format_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define SERIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERIALIZER, SerializerPrivate))
enum  {
	SERIALIZER_DUMMY_PROPERTY
};
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
gchar* serializer_to_string (Serializer* self, Number* x);
static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits);
gint serializer_get_base (Serializer* self);
static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits);
Number* serializer_from_string (Serializer* self, const gchar* str);
Number* mp_set_from_string (const gchar* str, gint default_base);
void serializer_set_base (Serializer* self, gint number_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_radix (Serializer* self, gunichar radix);
gunichar serializer_get_radix (Serializer* self);
void serializer_set_thousands_separator (Serializer* self, gunichar separator);
gunichar serializer_get_thousands_separator (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
void serializer_set_thousands_separator_count (Serializer* self, gint count);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean serializer_get_show_thousands_separators (Serializer* self);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
gint serializer_get_leading_digits (Serializer* self);
void serializer_set_leading_digits (Serializer* self, gint leading_digits);
gint serializer_get_trailing_digits (Serializer* self);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
DisplayFormat serializer_get_number_format (Serializer* self);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
Number* number_real_component (Number* self);
static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string);
gboolean number_is_complex (Number* self);
Number* number_imaginary_component (Number* self);
gboolean number_is_negative (Number* self);
Number* number_abs (Number* self);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_add (Number* self, Number* y);
Number* number_floor (Number* self);
gboolean number_is_zero (Number* self);
Number* number_subtract (Number* self, Number* y);
gint64 number_to_integer (Number* self);
Number* number_fractional_component (Number* self);
static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits);
Number* number_divide (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_multiply (Number* self, Number* y);
static void serializer_append_exponent (Serializer* self, GString* string, gint exponent);
static void serializer_finalize (GObject* obj);


GType display_format_get_type (void) {
	static volatile gsize display_format_type_id__volatile = 0;
	if (g_once_init_enter (&display_format_type_id__volatile)) {
		static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
		GType display_format_type_id;
		display_format_type_id = g_enum_register_static ("DisplayFormat", values);
		g_once_init_leave (&display_format_type_id__volatile, display_format_type_id);
	}
	return display_format_type_id__volatile;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits) {
	Serializer * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* radix_string;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* tsep_string;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp15_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	DisplayFormat _tmp23_;
	self = (Serializer*) g_object_new (object_type, NULL);
	_tmp0_ = nl_langinfo (RADIXCHAR);
	_tmp1_ = g_strdup (_tmp0_);
	radix_string = _tmp1_;
	_tmp3_ = radix_string;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = radix_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gunichar _tmp9_ = 0U;
		_tmp6_ = radix_string;
		_tmp7_ = g_locale_to_utf8 (_tmp6_, (gssize) (-1), NULL, NULL, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_get_char (_tmp8_, (glong) 0);
		self->priv->radix = _tmp9_;
		_g_free0 (_tmp8_);
	} else {
		self->priv->radix = (gunichar) '.';
	}
	_tmp10_ = nl_langinfo (THOUSEP);
	_tmp11_ = g_strdup (_tmp10_);
	tsep_string = _tmp11_;
	_tmp13_ = tsep_string;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = tsep_string;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gunichar _tmp19_ = 0U;
		_tmp16_ = tsep_string;
		_tmp17_ = g_locale_to_utf8 (_tmp16_, (gssize) (-1), NULL, NULL, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_get_char (_tmp18_, (glong) 0);
		self->priv->tsep = _tmp19_;
		_g_free0 (_tmp18_);
	} else {
		self->priv->tsep = (gunichar) ' ';
	}
	self->priv->tsep_count = 3;
	_tmp20_ = number_base;
	self->priv->number_base = _tmp20_;
	_tmp21_ = number_base;
	self->priv->representation_base = (guint) _tmp21_;
	self->priv->leading_digits = 12;
	_tmp22_ = trailing_digits;
	self->priv->trailing_digits = _tmp22_;
	self->priv->show_zeroes = FALSE;
	self->priv->show_tsep = FALSE;
	_tmp23_ = format;
	self->priv->format = _tmp23_;
	_g_free0 (tsep_string);
	_g_free0 (radix_string);
	return self;
}


Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits) {
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
}


gchar* serializer_to_string (Serializer* self, Number* x) {
	gchar* result = NULL;
	guint _tmp0_;
	gint _tmp1_;
	DisplayFormat _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->representation_base;
	_tmp1_ = self->priv->number_base;
	if (_tmp0_ != ((guint) _tmp1_)) {
		gint n_digits;
		Number* _tmp2_;
		gchar* _tmp3_ = NULL;
		n_digits = 0;
		_tmp2_ = x;
		_tmp3_ = serializer_cast_to_string (self, _tmp2_, &n_digits);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->format;
	switch (_tmp4_) {
		default:
		case DISPLAY_FORMAT_AUTOMATIC:
		{
			gint n_digits;
			Number* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* s0;
			gint _tmp7_ = 0;
			n_digits = 0;
			_tmp5_ = x;
			_tmp6_ = serializer_cast_to_string (self, _tmp5_, &n_digits);
			s0 = _tmp6_;
			_tmp7_ = serializer_get_base (self);
			switch (_tmp7_) {
				case 2:
				{
					gint _tmp8_;
					_tmp8_ = n_digits;
					if (_tmp8_ <= 64) {
						result = s0;
						return result;
					} else {
						Number* _tmp9_;
						gchar* _tmp10_ = NULL;
						_tmp9_ = x;
						_tmp10_ = serializer_cast_to_exponential_string (self, _tmp9_, FALSE, &n_digits);
						result = _tmp10_;
						_g_free0 (s0);
						return result;
					}
				}
				case 8:
				{
					gint _tmp11_;
					_tmp11_ = n_digits;
					if (_tmp11_ <= 22) {
						result = s0;
						return result;
					} else {
						Number* _tmp12_;
						gchar* _tmp13_ = NULL;
						_tmp12_ = x;
						_tmp13_ = serializer_cast_to_exponential_string (self, _tmp12_, FALSE, &n_digits);
						result = _tmp13_;
						_g_free0 (s0);
						return result;
					}
				}
				case 16:
				{
					gint _tmp14_;
					_tmp14_ = n_digits;
					if (_tmp14_ <= 16) {
						result = s0;
						return result;
					} else {
						Number* _tmp15_;
						gchar* _tmp16_ = NULL;
						_tmp15_ = x;
						_tmp16_ = serializer_cast_to_exponential_string (self, _tmp15_, FALSE, &n_digits);
						result = _tmp16_;
						_g_free0 (s0);
						return result;
					}
				}
				default:
				case 10:
				{
					gint _tmp17_;
					gint _tmp18_;
					_tmp17_ = n_digits;
					_tmp18_ = self->priv->leading_digits;
					if (_tmp17_ <= _tmp18_) {
						result = s0;
						return result;
					} else {
						Number* _tmp19_;
						gchar* _tmp20_ = NULL;
						_tmp19_ = x;
						_tmp20_ = serializer_cast_to_exponential_string (self, _tmp19_, FALSE, &n_digits);
						result = _tmp20_;
						_g_free0 (s0);
						return result;
					}
				}
			}
			_g_free0 (s0);
		}
		case DISPLAY_FORMAT_FIXED:
		{
			gint n_digits;
			Number* _tmp21_;
			gchar* _tmp22_ = NULL;
			n_digits = 0;
			_tmp21_ = x;
			_tmp22_ = serializer_cast_to_string (self, _tmp21_, &n_digits);
			result = _tmp22_;
			return result;
		}
		case DISPLAY_FORMAT_SCIENTIFIC:
		{
			gint n_digits;
			Number* _tmp23_;
			gchar* _tmp24_ = NULL;
			n_digits = 0;
			_tmp23_ = x;
			_tmp24_ = serializer_cast_to_exponential_string (self, _tmp23_, FALSE, &n_digits);
			result = _tmp24_;
			return result;
		}
		case DISPLAY_FORMAT_ENGINEERING:
		{
			gint n_digits;
			Number* _tmp25_;
			gchar* _tmp26_ = NULL;
			n_digits = 0;
			_tmp25_ = x;
			_tmp26_ = serializer_cast_to_exponential_string (self, _tmp25_, TRUE, &n_digits);
			result = _tmp26_;
			return result;
		}
	}
}


Number* serializer_from_string (Serializer* self, const gchar* str) {
	Number* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	Number* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = self->priv->number_base;
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


void serializer_set_base (Serializer* self, gint number_base) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = number_base;
	self->priv->number_base = _tmp0_;
}


gint serializer_get_base (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->number_base;
	result = _tmp0_;
	return result;
}


void serializer_set_representation_base (Serializer* self, guint representation_base) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = representation_base;
	self->priv->representation_base = _tmp0_;
}


guint serializer_get_representation_base (Serializer* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->representation_base;
	result = _tmp0_;
	return result;
}


void serializer_set_radix (Serializer* self, gunichar radix) {
	gunichar _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = radix;
	self->priv->radix = _tmp0_;
}


gunichar serializer_get_radix (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->radix;
	result = _tmp0_;
	return result;
}


void serializer_set_thousands_separator (Serializer* self, gunichar separator) {
	gunichar _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = separator;
	self->priv->tsep = _tmp0_;
}


gunichar serializer_get_thousands_separator (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->tsep;
	result = _tmp0_;
	return result;
}


gint serializer_get_thousands_separator_count (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tsep_count;
	result = _tmp0_;
	return result;
}


void serializer_set_thousands_separator_count (Serializer* self, gint count) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = count;
	self->priv->tsep_count = _tmp0_;
}


void serializer_set_show_thousands_separators (Serializer* self, gboolean visible) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = visible;
	self->priv->show_tsep = _tmp0_;
}


gboolean serializer_get_show_thousands_separators (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_tsep;
	result = _tmp0_;
	return result;
}


void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = visible;
	self->priv->show_zeroes = _tmp0_;
}


gboolean serializer_get_show_trailing_zeroes (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_zeroes;
	result = _tmp0_;
	return result;
}


gint serializer_get_leading_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->leading_digits;
	result = _tmp0_;
	return result;
}


void serializer_set_leading_digits (Serializer* self, gint leading_digits) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = leading_digits;
	self->priv->leading_digits = _tmp0_;
}


gint serializer_get_trailing_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->trailing_digits;
	result = _tmp0_;
	return result;
}


void serializer_set_trailing_digits (Serializer* self, gint trailing_digits) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = trailing_digits;
	self->priv->trailing_digits = _tmp0_;
}


DisplayFormat serializer_get_number_format (Serializer* self) {
	DisplayFormat result = 0;
	DisplayFormat _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->format;
	result = _tmp0_;
	return result;
}


void serializer_set_number_format (Serializer* self, DisplayFormat format) {
	DisplayFormat _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = format;
	self->priv->format = _tmp0_;
}


static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* string;
	Number* _tmp1_;
	Number* _tmp2_ = NULL;
	Number* x_real;
	Number* _tmp3_;
	guint _tmp4_;
	GString* _tmp5_;
	Number* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GString* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = x;
	_tmp2_ = number_real_component (_tmp1_);
	x_real = _tmp2_;
	_tmp3_ = x_real;
	_tmp4_ = self->priv->representation_base;
	_tmp5_ = string;
	serializer_cast_to_string_real (self, _tmp3_, (gint) _tmp4_, FALSE, n_digits, _tmp5_);
	_tmp6_ = x;
	_tmp7_ = number_is_complex (_tmp6_);
	if (_tmp7_) {
		Number* _tmp8_;
		Number* _tmp9_ = NULL;
		Number* x_im;
		gboolean force_sign;
		GString* _tmp10_;
		const gchar* _tmp11_;
		GString* _tmp13_;
		GString* s;
		gint n_complex_digits;
		Number* _tmp14_;
		guint _tmp15_;
		gboolean _tmp16_;
		GString* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		GString* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp27_;
		gboolean _tmp30_;
		_tmp8_ = x;
		_tmp9_ = number_imaginary_component (_tmp8_);
		x_im = _tmp9_;
		force_sign = TRUE;
		_tmp10_ = string;
		_tmp11_ = _tmp10_->str;
		if (g_strcmp0 (_tmp11_, "0") == 0) {
			GString* _tmp12_;
			_tmp12_ = string;
			g_string_assign (_tmp12_, "");
			force_sign = FALSE;
		}
		_tmp13_ = g_string_sized_new ((gsize) 1024);
		s = _tmp13_;
		n_complex_digits = 0;
		_tmp14_ = x_im;
		_tmp15_ = self->priv->representation_base;
		_tmp16_ = force_sign;
		_tmp17_ = s;
		serializer_cast_to_string_real (self, _tmp14_, (gint) _tmp15_, _tmp16_, &n_complex_digits, _tmp17_);
		_tmp18_ = n_complex_digits;
		_tmp19_ = *n_digits;
		if (_tmp18_ > _tmp19_) {
			gint _tmp20_;
			_tmp20_ = n_complex_digits;
			*n_digits = _tmp20_;
		}
		_tmp23_ = s;
		_tmp24_ = _tmp23_->str;
		if (g_strcmp0 (_tmp24_, "0") == 0) {
			_tmp22_ = TRUE;
		} else {
			GString* _tmp25_;
			const gchar* _tmp26_;
			_tmp25_ = s;
			_tmp26_ = _tmp25_->str;
			_tmp22_ = g_strcmp0 (_tmp26_, "+0") == 0;
		}
		_tmp27_ = _tmp22_;
		if (_tmp27_) {
			_tmp21_ = TRUE;
		} else {
			GString* _tmp28_;
			const gchar* _tmp29_;
			_tmp28_ = s;
			_tmp29_ = _tmp28_->str;
			_tmp21_ = g_strcmp0 (_tmp29_, "−0") == 0;
		}
		_tmp30_ = _tmp21_;
		if (_tmp30_) {
		} else {
			GString* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = s;
			_tmp32_ = _tmp31_->str;
			if (g_strcmp0 (_tmp32_, "1") == 0) {
				GString* _tmp33_;
				_tmp33_ = string;
				g_string_append (_tmp33_, "i");
			} else {
				GString* _tmp34_;
				const gchar* _tmp35_;
				_tmp34_ = s;
				_tmp35_ = _tmp34_->str;
				if (g_strcmp0 (_tmp35_, "+1") == 0) {
					GString* _tmp36_;
					_tmp36_ = string;
					g_string_append (_tmp36_, "+i");
				} else {
					GString* _tmp37_;
					const gchar* _tmp38_;
					_tmp37_ = s;
					_tmp38_ = _tmp37_->str;
					if (g_strcmp0 (_tmp38_, "−1") == 0) {
						GString* _tmp39_;
						_tmp39_ = string;
						g_string_append (_tmp39_, "−i");
					} else {
						GString* _tmp40_;
						const gchar* _tmp41_;
						GString* _tmp48_;
						_tmp40_ = s;
						_tmp41_ = _tmp40_->str;
						if (g_strcmp0 (_tmp41_, "+0") == 0) {
							GString* _tmp42_;
							_tmp42_ = string;
							g_string_append (_tmp42_, "+");
						} else {
							GString* _tmp43_;
							const gchar* _tmp44_;
							_tmp43_ = s;
							_tmp44_ = _tmp43_->str;
							if (g_strcmp0 (_tmp44_, "0") != 0) {
								GString* _tmp45_;
								GString* _tmp46_;
								const gchar* _tmp47_;
								_tmp45_ = string;
								_tmp46_ = s;
								_tmp47_ = _tmp46_->str;
								g_string_append (_tmp45_, _tmp47_);
							}
						}
						_tmp48_ = string;
						g_string_append (_tmp48_, "i");
					}
				}
			}
		}
		_g_string_free0 (s);
		_number_unref0 (x_im);
	}
	_tmp49_ = string;
	_tmp50_ = _tmp49_->str;
	_tmp51_ = g_strdup (_tmp50_);
	result = _tmp51_;
	_number_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gpointer _number_ref0 (gpointer self) {
	return self ? number_ref (self) : NULL;
}


static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string) {
	static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	Number* _tmp0_;
	Number* _tmp1_;
	Number* number;
	Number* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint _tmp6_;
	Number* _tmp7_;
	Number* temp;
	Number* _tmp8_;
	gint _tmp9_;
	Number* _tmp10_ = NULL;
	Number* _tmp11_;
	gint _tmp12_;
	Number* _tmp13_ = NULL;
	Number* _tmp14_;
	Number* _tmp15_ = NULL;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_ = NULL;
	Number* rounded_number;
	Number* _tmp19_;
	Number* _tmp20_ = NULL;
	gint i;
	GString* _tmp58_;
	gssize _tmp59_;
	gssize last_non_zero;
	GString* _tmp60_;
	gunichar _tmp61_;
	Number* _tmp62_;
	Number* _tmp63_ = NULL;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_;
	gboolean _tmp90_;
	gboolean _tmp93_ = FALSE;
	GString* _tmp94_;
	const gchar* _tmp95_;
	gboolean _tmp97_;
	gint _tmp103_;
	gint _tmp104_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = x;
	_tmp1_ = _number_ref0 (_tmp0_);
	number = _tmp1_;
	_tmp2_ = number;
	_tmp3_ = number_is_negative (_tmp2_);
	if (_tmp3_) {
		Number* _tmp4_;
		Number* _tmp5_ = NULL;
		_tmp4_ = number;
		_tmp5_ = number_abs (_tmp4_);
		_number_unref0 (number);
		number = _tmp5_;
	}
	_tmp6_ = number_base;
	_tmp7_ = number_new_integer ((gint64) _tmp6_);
	temp = _tmp7_;
	_tmp8_ = temp;
	_tmp9_ = self->priv->trailing_digits;
	_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) (-(_tmp9_ + 1)));
	_number_unref0 (temp);
	temp = _tmp10_;
	_tmp11_ = temp;
	_tmp12_ = number_base;
	_tmp13_ = number_multiply_integer (_tmp11_, (gint64) _tmp12_);
	_number_unref0 (temp);
	temp = _tmp13_;
	_tmp14_ = temp;
	_tmp15_ = number_divide_integer (_tmp14_, (gint64) 2);
	_number_unref0 (temp);
	temp = _tmp15_;
	_tmp16_ = number;
	_tmp17_ = temp;
	_tmp18_ = number_add (_tmp16_, _tmp17_);
	rounded_number = _tmp18_;
	_tmp19_ = rounded_number;
	_tmp20_ = number_floor (_tmp19_);
	_number_unref0 (temp);
	temp = _tmp20_;
	i = 0;
	{
		gboolean _tmp21_;
		_tmp21_ = TRUE;
		while (TRUE) {
			gboolean _tmp22_;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			gint _tmp27_;
			gboolean _tmp29_;
			gboolean _tmp32_;
			gint _tmp35_;
			Number* _tmp36_;
			gint _tmp37_;
			Number* _tmp38_ = NULL;
			Number* t;
			Number* _tmp39_;
			Number* _tmp40_ = NULL;
			Number* _tmp41_;
			gint _tmp42_;
			Number* _tmp43_ = NULL;
			Number* t2;
			Number* _tmp44_;
			Number* _tmp45_;
			Number* _tmp46_ = NULL;
			Number* t3;
			Number* _tmp47_;
			gint64 _tmp48_ = 0LL;
			gint64 d;
			gchar _tmp49_ = '\0';
			gint64 _tmp50_;
			GString* _tmp53_;
			gchar _tmp54_;
			gint _tmp55_;
			Number* _tmp56_;
			Number* _tmp57_;
			_tmp22_ = _tmp21_;
			if (!_tmp22_) {
				Number* _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp23_ = temp;
				_tmp24_ = number_is_zero (_tmp23_);
				if (!(!_tmp24_)) {
					break;
				}
			}
			_tmp21_ = FALSE;
			_tmp27_ = number_base;
			if (_tmp27_ == 10) {
				gboolean _tmp28_;
				_tmp28_ = self->priv->show_tsep;
				_tmp26_ = _tmp28_;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp29_ = _tmp26_;
			if (_tmp29_) {
				gint _tmp30_;
				gint _tmp31_;
				_tmp30_ = i;
				_tmp31_ = self->priv->tsep_count;
				_tmp25_ = _tmp30_ == _tmp31_;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp32_ = _tmp25_;
			if (_tmp32_) {
				GString* _tmp33_;
				gunichar _tmp34_;
				_tmp33_ = string;
				_tmp34_ = self->priv->tsep;
				g_string_prepend_unichar (_tmp33_, _tmp34_);
				i = 0;
			}
			_tmp35_ = i;
			i = _tmp35_ + 1;
			_tmp36_ = temp;
			_tmp37_ = number_base;
			_tmp38_ = number_divide_integer (_tmp36_, (gint64) _tmp37_);
			t = _tmp38_;
			_tmp39_ = t;
			_tmp40_ = number_floor (_tmp39_);
			_number_unref0 (t);
			t = _tmp40_;
			_tmp41_ = t;
			_tmp42_ = number_base;
			_tmp43_ = number_multiply_integer (_tmp41_, (gint64) _tmp42_);
			t2 = _tmp43_;
			_tmp44_ = temp;
			_tmp45_ = t2;
			_tmp46_ = number_subtract (_tmp44_, _tmp45_);
			t3 = _tmp46_;
			_tmp47_ = t3;
			_tmp48_ = number_to_integer (_tmp47_);
			d = _tmp48_;
			_tmp50_ = d;
			if (_tmp50_ < ((gint64) 16)) {
				gint64 _tmp51_;
				gchar _tmp52_;
				_tmp51_ = d;
				_tmp52_ = digits[_tmp51_];
				_tmp49_ = _tmp52_;
			} else {
				_tmp49_ = '?';
			}
			_tmp53_ = string;
			_tmp54_ = _tmp49_;
			g_string_prepend_c (_tmp53_, _tmp54_);
			_tmp55_ = *n_digits;
			*n_digits = _tmp55_ + 1;
			_tmp56_ = t;
			_tmp57_ = _number_ref0 (_tmp56_);
			_number_unref0 (temp);
			temp = _tmp57_;
			_number_unref0 (t3);
			_number_unref0 (t2);
			_number_unref0 (t);
		}
	}
	_tmp58_ = string;
	_tmp59_ = _tmp58_->len;
	last_non_zero = _tmp59_;
	_tmp60_ = string;
	_tmp61_ = self->priv->radix;
	g_string_append_unichar (_tmp60_, _tmp61_);
	_tmp62_ = rounded_number;
	_tmp63_ = number_fractional_component (_tmp62_);
	_number_unref0 (temp);
	temp = _tmp63_;
	{
		gboolean _tmp64_;
		i = 0;
		_tmp64_ = TRUE;
		while (TRUE) {
			gboolean _tmp65_;
			gint _tmp67_;
			gint _tmp68_;
			Number* _tmp69_;
			gboolean _tmp70_ = FALSE;
			Number* _tmp71_;
			gint _tmp72_;
			Number* _tmp73_ = NULL;
			Number* _tmp74_;
			Number* _tmp75_ = NULL;
			Number* digit;
			Number* _tmp76_;
			gint64 _tmp77_ = 0LL;
			gint64 d;
			GString* _tmp78_;
			gint64 _tmp79_;
			gchar _tmp80_;
			gint64 _tmp81_;
			Number* _tmp84_;
			Number* _tmp85_;
			Number* _tmp86_ = NULL;
			_tmp65_ = _tmp64_;
			if (!_tmp65_) {
				gint _tmp66_;
				_tmp66_ = i;
				i = _tmp66_ + 1;
			}
			_tmp64_ = FALSE;
			_tmp67_ = i;
			_tmp68_ = self->priv->trailing_digits;
			if (!(_tmp67_ < _tmp68_)) {
				break;
			}
			_tmp69_ = temp;
			_tmp70_ = number_is_zero (_tmp69_);
			if (_tmp70_) {
				break;
			}
			_tmp71_ = temp;
			_tmp72_ = number_base;
			_tmp73_ = number_multiply_integer (_tmp71_, (gint64) _tmp72_);
			_number_unref0 (temp);
			temp = _tmp73_;
			_tmp74_ = temp;
			_tmp75_ = number_floor (_tmp74_);
			digit = _tmp75_;
			_tmp76_ = digit;
			_tmp77_ = number_to_integer (_tmp76_);
			d = _tmp77_;
			_tmp78_ = string;
			_tmp79_ = d;
			_tmp80_ = digits[_tmp79_];
			g_string_append_c (_tmp78_, _tmp80_);
			_tmp81_ = d;
			if (_tmp81_ != ((gint64) 0)) {
				GString* _tmp82_;
				gssize _tmp83_;
				_tmp82_ = string;
				_tmp83_ = _tmp82_->len;
				last_non_zero = _tmp83_;
			}
			_tmp84_ = temp;
			_tmp85_ = digit;
			_tmp86_ = number_subtract (_tmp84_, _tmp85_);
			_number_unref0 (temp);
			temp = _tmp86_;
			_number_unref0 (digit);
		}
	}
	_tmp88_ = self->priv->show_zeroes;
	if (!_tmp88_) {
		_tmp87_ = TRUE;
	} else {
		gint _tmp89_;
		_tmp89_ = self->priv->trailing_digits;
		_tmp87_ = _tmp89_ == 0;
	}
	_tmp90_ = _tmp87_;
	if (_tmp90_) {
		GString* _tmp91_;
		gssize _tmp92_;
		_tmp91_ = string;
		_tmp92_ = last_non_zero;
		g_string_truncate (_tmp91_, (gsize) _tmp92_);
	}
	_tmp94_ = string;
	_tmp95_ = _tmp94_->str;
	if (g_strcmp0 (_tmp95_, "0") != 0) {
		_tmp93_ = TRUE;
	} else {
		gboolean _tmp96_;
		_tmp96_ = force_sign;
		_tmp93_ = _tmp96_;
	}
	_tmp97_ = _tmp93_;
	if (_tmp97_) {
		Number* _tmp98_;
		gboolean _tmp99_ = FALSE;
		_tmp98_ = x;
		_tmp99_ = number_is_negative (_tmp98_);
		if (_tmp99_) {
			GString* _tmp100_;
			_tmp100_ = string;
			g_string_prepend (_tmp100_, "−");
		} else {
			gboolean _tmp101_;
			_tmp101_ = force_sign;
			if (_tmp101_) {
				GString* _tmp102_;
				_tmp102_ = string;
				g_string_prepend (_tmp102_, "+");
			}
		}
	}
	_tmp103_ = number_base;
	_tmp104_ = self->priv->number_base;
	if (_tmp103_ != _tmp104_) {
		static const gchar* sub_digits[] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
		gint multiplier;
		gint _tmp105_;
		gint b;
		multiplier = 1;
		_tmp105_ = number_base;
		b = _tmp105_;
		while (TRUE) {
			gint _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			_tmp106_ = number_base;
			_tmp107_ = multiplier;
			if (!((_tmp106_ / _tmp107_) != 0)) {
				break;
			}
			_tmp108_ = multiplier;
			multiplier = _tmp108_ * 10;
		}
		while (TRUE) {
			gint _tmp109_;
			gint d = 0;
			gint _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			GString* _tmp113_;
			gint _tmp114_;
			const gchar* _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			gint _tmp118_;
			_tmp109_ = multiplier;
			if (!(_tmp109_ != 1)) {
				break;
			}
			_tmp110_ = multiplier;
			multiplier = _tmp110_ / 10;
			_tmp111_ = b;
			_tmp112_ = multiplier;
			d = _tmp111_ / _tmp112_;
			_tmp113_ = string;
			_tmp114_ = d;
			_tmp115_ = sub_digits[_tmp114_];
			g_string_append (_tmp113_, _tmp115_);
			_tmp116_ = b;
			_tmp117_ = d;
			_tmp118_ = multiplier;
			b = _tmp116_ - (_tmp117_ * _tmp118_);
		}
	}
	_number_unref0 (rounded_number);
	_number_unref0 (temp);
	_number_unref0 (number);
}


static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits) {
	gint result = 0;
	Number* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Number* _tmp3_;
	Number* _tmp4_ = NULL;
	Number* mantissa;
	gint _tmp5_;
	Number* _tmp6_;
	Number* base_;
	Number* _tmp7_;
	Number* _tmp8_ = NULL;
	Number* base3;
	Number* _tmp9_;
	Number* _tmp10_ = NULL;
	Number* base10;
	Number* _tmp11_;
	Number* t;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_ = NULL;
	Number* base10inv;
	gint exponent;
	Number* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GString* _tmp72_;
	Number* _tmp73_;
	gchar* _tmp74_ = NULL;
	gchar* _tmp75_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (string != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = number_is_negative (_tmp0_);
	if (_tmp1_) {
		GString* _tmp2_;
		_tmp2_ = string;
		g_string_append (_tmp2_, "−");
	}
	_tmp3_ = x;
	_tmp4_ = number_abs (_tmp3_);
	mantissa = _tmp4_;
	_tmp5_ = self->priv->number_base;
	_tmp6_ = number_new_integer ((gint64) _tmp5_);
	base_ = _tmp6_;
	_tmp7_ = base_;
	_tmp8_ = number_xpowy_integer (_tmp7_, (gint64) 3);
	base3 = _tmp8_;
	_tmp9_ = base_;
	_tmp10_ = number_xpowy_integer (_tmp9_, (gint64) 10);
	base10 = _tmp10_;
	_tmp11_ = number_new_integer ((gint64) 1);
	t = _tmp11_;
	_tmp12_ = t;
	_tmp13_ = base10;
	_tmp14_ = number_divide (_tmp12_, _tmp13_);
	base10inv = _tmp14_;
	exponent = 0;
	_tmp15_ = mantissa;
	_tmp16_ = number_is_zero (_tmp15_);
	if (!_tmp16_) {
		Number* _tmp58_;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_;
			gboolean _tmp22_;
			gint _tmp23_;
			Number* _tmp24_;
			Number* _tmp25_;
			Number* _tmp26_ = NULL;
			_tmp18_ = eng_format;
			if (!_tmp18_) {
				Number* _tmp19_;
				Number* _tmp20_;
				gint _tmp21_ = 0;
				_tmp19_ = mantissa;
				_tmp20_ = base10;
				_tmp21_ = number_compare (_tmp19_, _tmp20_);
				_tmp17_ = _tmp21_ >= 0;
			} else {
				_tmp17_ = FALSE;
			}
			_tmp22_ = _tmp17_;
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = exponent;
			exponent = _tmp23_ + 10;
			_tmp24_ = mantissa;
			_tmp25_ = base10inv;
			_tmp26_ = number_multiply (_tmp24_, _tmp25_);
			_number_unref0 (mantissa);
			mantissa = _tmp26_;
		}
		while (TRUE) {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_;
			gboolean _tmp33_;
			gboolean _tmp43_;
			gint _tmp44_;
			Number* _tmp45_;
			Number* _tmp46_;
			Number* _tmp47_ = NULL;
			_tmp29_ = eng_format;
			if (!_tmp29_) {
				Number* _tmp30_;
				Number* _tmp31_;
				gint _tmp32_ = 0;
				_tmp30_ = mantissa;
				_tmp31_ = base_;
				_tmp32_ = number_compare (_tmp30_, _tmp31_);
				_tmp28_ = _tmp32_ >= 0;
			} else {
				_tmp28_ = FALSE;
			}
			_tmp33_ = _tmp28_;
			if (_tmp33_) {
				_tmp27_ = TRUE;
			} else {
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_;
				gboolean _tmp42_;
				_tmp35_ = eng_format;
				if (_tmp35_) {
					gboolean _tmp36_ = FALSE;
					Number* _tmp37_;
					Number* _tmp38_;
					gint _tmp39_ = 0;
					gboolean _tmp41_;
					_tmp37_ = mantissa;
					_tmp38_ = base3;
					_tmp39_ = number_compare (_tmp37_, _tmp38_);
					if (_tmp39_ >= 0) {
						_tmp36_ = TRUE;
					} else {
						gint _tmp40_;
						_tmp40_ = exponent;
						_tmp36_ = (_tmp40_ % 3) != 0;
					}
					_tmp41_ = _tmp36_;
					_tmp34_ = _tmp41_;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp42_ = _tmp34_;
				_tmp27_ = _tmp42_;
			}
			_tmp43_ = _tmp27_;
			if (!_tmp43_) {
				break;
			}
			_tmp44_ = exponent;
			exponent = _tmp44_ + 1;
			_tmp45_ = mantissa;
			_tmp46_ = base_;
			_tmp47_ = number_divide (_tmp45_, _tmp46_);
			_number_unref0 (mantissa);
			mantissa = _tmp47_;
		}
		while (TRUE) {
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_;
			gboolean _tmp53_;
			gint _tmp54_;
			Number* _tmp55_;
			Number* _tmp56_;
			Number* _tmp57_ = NULL;
			_tmp49_ = eng_format;
			if (!_tmp49_) {
				Number* _tmp50_;
				Number* _tmp51_;
				gint _tmp52_ = 0;
				_tmp50_ = mantissa;
				_tmp51_ = base10inv;
				_tmp52_ = number_compare (_tmp50_, _tmp51_);
				_tmp48_ = _tmp52_ < 0;
			} else {
				_tmp48_ = FALSE;
			}
			_tmp53_ = _tmp48_;
			if (!_tmp53_) {
				break;
			}
			_tmp54_ = exponent;
			exponent = _tmp54_ - 10;
			_tmp55_ = mantissa;
			_tmp56_ = base10;
			_tmp57_ = number_multiply (_tmp55_, _tmp56_);
			_number_unref0 (mantissa);
			mantissa = _tmp57_;
		}
		_tmp58_ = number_new_integer ((gint64) 1);
		_number_unref0 (t);
		t = _tmp58_;
		while (TRUE) {
			gboolean _tmp59_ = FALSE;
			Number* _tmp60_;
			Number* _tmp61_;
			gint _tmp62_ = 0;
			gboolean _tmp67_;
			gint _tmp68_;
			Number* _tmp69_;
			Number* _tmp70_;
			Number* _tmp71_ = NULL;
			_tmp60_ = mantissa;
			_tmp61_ = t;
			_tmp62_ = number_compare (_tmp60_, _tmp61_);
			if (_tmp62_ < 0) {
				_tmp59_ = TRUE;
			} else {
				gboolean _tmp63_ = FALSE;
				gboolean _tmp64_;
				gboolean _tmp66_;
				_tmp64_ = eng_format;
				if (_tmp64_) {
					gint _tmp65_;
					_tmp65_ = exponent;
					_tmp63_ = (_tmp65_ % 3) != 0;
				} else {
					_tmp63_ = FALSE;
				}
				_tmp66_ = _tmp63_;
				_tmp59_ = _tmp66_;
			}
			_tmp67_ = _tmp59_;
			if (!_tmp67_) {
				break;
			}
			_tmp68_ = exponent;
			exponent = _tmp68_ - 1;
			_tmp69_ = mantissa;
			_tmp70_ = base_;
			_tmp71_ = number_multiply (_tmp69_, _tmp70_);
			_number_unref0 (mantissa);
			mantissa = _tmp71_;
		}
	}
	_tmp72_ = string;
	_tmp73_ = mantissa;
	_tmp74_ = serializer_cast_to_string (self, _tmp73_, n_digits);
	_tmp75_ = _tmp74_;
	g_string_append (_tmp72_, _tmp75_);
	_g_free0 (_tmp75_);
	result = exponent;
	_number_unref0 (base10inv);
	_number_unref0 (t);
	_number_unref0 (base10);
	_number_unref0 (base3);
	_number_unref0 (base_);
	_number_unref0 (mantissa);
	return result;
}


static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* string;
	Number* _tmp1_;
	Number* _tmp2_ = NULL;
	Number* x_real;
	Number* _tmp3_;
	GString* _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_ = 0;
	gint exponent;
	GString* _tmp7_;
	gint _tmp8_;
	Number* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GString* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = x;
	_tmp2_ = number_real_component (_tmp1_);
	x_real = _tmp2_;
	_tmp3_ = x_real;
	_tmp4_ = string;
	_tmp5_ = eng_format;
	_tmp6_ = serializer_cast_to_exponential_string_real (self, _tmp3_, _tmp4_, _tmp5_, n_digits);
	exponent = _tmp6_;
	_tmp7_ = string;
	_tmp8_ = exponent;
	serializer_append_exponent (self, _tmp7_, _tmp8_);
	_tmp9_ = x;
	_tmp10_ = number_is_complex (_tmp9_);
	if (_tmp10_) {
		Number* _tmp11_;
		Number* _tmp12_ = NULL;
		Number* x_im;
		GString* _tmp13_;
		const gchar* _tmp14_;
		GString* _tmp16_;
		GString* s;
		gint n_complex_digits;
		Number* _tmp17_;
		GString* _tmp18_;
		gboolean _tmp19_;
		gint _tmp20_ = 0;
		gint _tmp21_;
		gint _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		GString* _tmp26_;
		const gchar* _tmp27_;
		gboolean _tmp30_;
		gboolean _tmp33_;
		GString* _tmp52_;
		gint _tmp53_;
		_tmp11_ = x;
		_tmp12_ = number_imaginary_component (_tmp11_);
		x_im = _tmp12_;
		_tmp13_ = string;
		_tmp14_ = _tmp13_->str;
		if (g_strcmp0 (_tmp14_, "0") == 0) {
			GString* _tmp15_;
			_tmp15_ = string;
			g_string_assign (_tmp15_, "");
		}
		_tmp16_ = g_string_sized_new ((gsize) 1024);
		s = _tmp16_;
		n_complex_digits = 0;
		_tmp17_ = x_im;
		_tmp18_ = s;
		_tmp19_ = eng_format;
		_tmp20_ = serializer_cast_to_exponential_string_real (self, _tmp17_, _tmp18_, _tmp19_, &n_complex_digits);
		exponent = _tmp20_;
		_tmp21_ = n_complex_digits;
		_tmp22_ = *n_digits;
		if (_tmp21_ > _tmp22_) {
			gint _tmp23_;
			_tmp23_ = n_complex_digits;
			*n_digits = _tmp23_;
		}
		_tmp26_ = s;
		_tmp27_ = _tmp26_->str;
		if (g_strcmp0 (_tmp27_, "0") == 0) {
			_tmp25_ = TRUE;
		} else {
			GString* _tmp28_;
			const gchar* _tmp29_;
			_tmp28_ = s;
			_tmp29_ = _tmp28_->str;
			_tmp25_ = g_strcmp0 (_tmp29_, "+0") == 0;
		}
		_tmp30_ = _tmp25_;
		if (_tmp30_) {
			_tmp24_ = TRUE;
		} else {
			GString* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = s;
			_tmp32_ = _tmp31_->str;
			_tmp24_ = g_strcmp0 (_tmp32_, "−0") == 0;
		}
		_tmp33_ = _tmp24_;
		if (_tmp33_) {
		} else {
			GString* _tmp34_;
			const gchar* _tmp35_;
			_tmp34_ = s;
			_tmp35_ = _tmp34_->str;
			if (g_strcmp0 (_tmp35_, "1") == 0) {
				GString* _tmp36_;
				_tmp36_ = string;
				g_string_append (_tmp36_, "i");
			} else {
				GString* _tmp37_;
				const gchar* _tmp38_;
				_tmp37_ = s;
				_tmp38_ = _tmp37_->str;
				if (g_strcmp0 (_tmp38_, "+1") == 0) {
					GString* _tmp39_;
					_tmp39_ = string;
					g_string_append (_tmp39_, "+i");
				} else {
					GString* _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = s;
					_tmp41_ = _tmp40_->str;
					if (g_strcmp0 (_tmp41_, "−1") == 0) {
						GString* _tmp42_;
						_tmp42_ = string;
						g_string_append (_tmp42_, "−i");
					} else {
						GString* _tmp43_;
						const gchar* _tmp44_;
						GString* _tmp51_;
						_tmp43_ = s;
						_tmp44_ = _tmp43_->str;
						if (g_strcmp0 (_tmp44_, "+0") == 0) {
							GString* _tmp45_;
							_tmp45_ = string;
							g_string_append (_tmp45_, "+");
						} else {
							GString* _tmp46_;
							const gchar* _tmp47_;
							_tmp46_ = s;
							_tmp47_ = _tmp46_->str;
							if (g_strcmp0 (_tmp47_, "0") != 0) {
								GString* _tmp48_;
								GString* _tmp49_;
								const gchar* _tmp50_;
								_tmp48_ = string;
								_tmp49_ = s;
								_tmp50_ = _tmp49_->str;
								g_string_append (_tmp48_, _tmp50_);
							}
						}
						_tmp51_ = string;
						g_string_append (_tmp51_, "i");
					}
				}
			}
		}
		_tmp52_ = string;
		_tmp53_ = exponent;
		serializer_append_exponent (self, _tmp52_, _tmp53_);
		_g_string_free0 (s);
		_number_unref0 (x_im);
	}
	_tmp54_ = string;
	_tmp55_ = _tmp54_->str;
	_tmp56_ = g_strdup (_tmp55_);
	result = _tmp56_;
	_number_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void serializer_append_exponent (Serializer* self, GString* string, gint exponent) {
	static const gunichar super_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gint _tmp0_;
	GString* _tmp1_;
	gint _tmp2_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* super_value;
	g_return_if_fail (self != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = exponent;
	if (_tmp0_ == 0) {
		return;
	}
	_tmp1_ = string;
	g_string_append (_tmp1_, "×10");
	_tmp2_ = exponent;
	if (_tmp2_ < 0) {
		gint _tmp3_;
		GString* _tmp4_;
		_tmp3_ = exponent;
		exponent = -_tmp3_;
		_tmp4_ = string;
		g_string_append_unichar (_tmp4_, 8315U);
	}
	_tmp5_ = exponent;
	_tmp6_ = g_strdup_printf ("%d", _tmp5_);
	super_value = _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				GString* _tmp14_;
				const gchar* _tmp15_;
				gint _tmp16_;
				gchar _tmp17_ = '\0';
				gunichar _tmp18_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = super_value;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp10_ < _tmp13_)) {
					break;
				}
				_tmp14_ = string;
				_tmp15_ = super_value;
				_tmp16_ = i;
				_tmp17_ = string_get (_tmp15_, (glong) _tmp16_);
				_tmp18_ = super_digits[_tmp17_ - '0'];
				g_string_append_unichar (_tmp14_, _tmp18_);
			}
		}
	}
	_g_free0 (super_value);
}


static void serializer_class_init (SerializerClass * klass) {
	serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SerializerPrivate));
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
}


static void serializer_instance_init (Serializer * self) {
	self->priv = SERIALIZER_GET_PRIVATE (self);
}


static void serializer_finalize (GObject* obj) {
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
}


GType serializer_get_type (void) {
	static volatile gsize serializer_type_id__volatile = 0;
	if (g_once_init_enter (&serializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
		GType serializer_type_id;
		serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
		g_once_init_leave (&serializer_type_id__volatile, serializer_type_id);
	}
	return serializer_type_id__volatile;
}



