/* cc-credentials-authorization-page.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-authorization-page.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libaccount-plugin/account-plugin.h>
#include <libaccounts-glib/accounts-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE (cc_credentials_authorization_page_get_type ())
#define CC_CREDENTIALS_AUTHORIZATION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, CcCredentialsAuthorizationPage))
#define CC_CREDENTIALS_AUTHORIZATION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, CcCredentialsAuthorizationPageClass))
#define CC_CREDENTIALS_IS_AUTHORIZATION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE))
#define CC_CREDENTIALS_IS_AUTHORIZATION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE))
#define CC_CREDENTIALS_AUTHORIZATION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, CcCredentialsAuthorizationPageClass))

typedef struct _CcCredentialsAuthorizationPage CcCredentialsAuthorizationPage;
typedef struct _CcCredentialsAuthorizationPageClass CcCredentialsAuthorizationPageClass;
typedef struct _CcCredentialsAuthorizationPagePrivate CcCredentialsAuthorizationPagePrivate;

#define CC_TYPE_WEBCREDENTIALS_INDICATOR (cc_webcredentials_indicator_get_type ())
#define CC_WEBCREDENTIALS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_TYPE_WEBCREDENTIALS_INDICATOR, CcWebcredentialsIndicator))
#define CC_IS_WEBCREDENTIALS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_TYPE_WEBCREDENTIALS_INDICATOR))
#define CC_WEBCREDENTIALS_INDICATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CC_TYPE_WEBCREDENTIALS_INDICATOR, CcWebcredentialsIndicatorIface))

typedef struct _CcWebcredentialsIndicator CcWebcredentialsIndicator;
typedef struct _CcWebcredentialsIndicatorIface CcWebcredentialsIndicatorIface;

#define CC_TYPE_WEBCREDENTIALS_INDICATOR_PROXY (cc_webcredentials_indicator_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CcCredentialsAuthorizationPage {
	GtkGrid parent_instance;
	CcCredentialsAuthorizationPagePrivate * priv;
};

struct _CcCredentialsAuthorizationPageClass {
	GtkGridClass parent_class;
};

struct _CcWebcredentialsIndicatorIface {
	GTypeInterface parent_iface;
	void (*report_failure) (CcWebcredentialsIndicator* self, guint account_id, GHashTable* notification, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*report_failure_finish) (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
	void (*remove_failures) (CcWebcredentialsIndicator* self, guint* account_ids, int account_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_failures_finish) (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
	void (*clear_error_status) (CcWebcredentialsIndicator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*clear_error_status_finish) (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
	guint* (*get_failures) (CcWebcredentialsIndicator* self, int* result_length1);
};

struct _CcCredentialsAuthorizationPagePrivate {
	ApPlugin* plugin;
	GtkWidget* widget;
	AgAccount* current_account;
	CcWebcredentialsIndicator* indicator;
	gboolean needs_reauthentication;
};


static gpointer cc_credentials_authorization_page_parent_class = NULL;

GType cc_credentials_authorization_page_get_type (void) G_GNUC_CONST;
GType cc_webcredentials_indicator_proxy_get_type (void) G_GNUC_CONST;
guint cc_webcredentials_indicator_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType cc_webcredentials_indicator_get_type (void) G_GNUC_CONST;
#define CC_CREDENTIALS_AUTHORIZATION_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, CcCredentialsAuthorizationPagePrivate))
enum  {
	CC_CREDENTIALS_AUTHORIZATION_PAGE_DUMMY_PROPERTY,
	CC_CREDENTIALS_AUTHORIZATION_PAGE_ACCOUNT
};
CcCredentialsAuthorizationPage* cc_credentials_authorization_page_new (void);
CcCredentialsAuthorizationPage* cc_credentials_authorization_page_construct (GType object_type);
void cc_credentials_authorization_page_reauthenticate_account (CcCredentialsAuthorizationPage* self, AgAccount* account);
void cc_credentials_authorization_page_set_account (CcCredentialsAuthorizationPage* self, AgAccount* value);
void cc_credentials_authorization_page_set_login_data (CcCredentialsAuthorizationPage* self, const gchar* username, const gchar* password, GHashTable* cookies);
static void cc_credentials_authorization_page_set_plugin_widget (CcCredentialsAuthorizationPage* self, GtkWidget* plugin_widget);
static void cc_credentials_authorization_page_remove_plugin_widget (CcCredentialsAuthorizationPage* self);
static void cc_credentials_authorization_page_on_plugin_finished (CcCredentialsAuthorizationPage* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
void cc_webcredentials_indicator_report_failure (CcWebcredentialsIndicator* self, guint account_id, GHashTable* notification, GAsyncReadyCallback _callback_, gpointer _user_data_);
void cc_webcredentials_indicator_report_failure_finish (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
void cc_webcredentials_indicator_remove_failures (CcWebcredentialsIndicator* self, guint* account_ids, int account_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void cc_webcredentials_indicator_remove_failures_finish (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
void cc_webcredentials_indicator_clear_error_status (CcWebcredentialsIndicator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void cc_webcredentials_indicator_clear_error_status_finish (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
AgAccount* cc_credentials_authorization_page_get_account (CcCredentialsAuthorizationPage* self);
static void _cc_credentials_authorization_page_on_plugin_finished_ap_plugin_finished (ApPlugin* _sender, gpointer self);
static GObject * cc_credentials_authorization_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void cc_credentials_authorization_page_finalize (GObject* obj);
static void _vala_cc_credentials_authorization_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_cc_credentials_authorization_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


CcCredentialsAuthorizationPage* cc_credentials_authorization_page_construct (GType object_type) {
	CcCredentialsAuthorizationPage * self = NULL;
	self = (CcCredentialsAuthorizationPage*) g_object_new (object_type, NULL);
	return self;
}


CcCredentialsAuthorizationPage* cc_credentials_authorization_page_new (void) {
	return cc_credentials_authorization_page_construct (CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE);
}


/**
     * Trigger a re-authentication with the supplied account.
     *
     * @param account the account to re-authenticate
     */
void cc_credentials_authorization_page_reauthenticate_account (CcCredentialsAuthorizationPage* self, AgAccount* account) {
	AgAccount* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	self->priv->needs_reauthentication = TRUE;
	_tmp0_ = account;
	cc_credentials_authorization_page_set_account (self, _tmp0_);
}


/**
     * Set the login data that the plugin might use while performing the
     * authentication.
     *
     * @param username the user login name.
     * @param password the user password.
     * @param cookies a dictionary of cookies.
     */
void cc_credentials_authorization_page_set_login_data (CcCredentialsAuthorizationPage* self, const gchar* username, const gchar* password, GHashTable* cookies) {
	ApPlugin* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	_tmp0_ = self->priv->plugin;
	_tmp1_ = username;
	_tmp2_ = password;
	ap_plugin_set_credentials (_tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = cookies;
	if (_tmp3_ != NULL) {
		ApPlugin* _tmp4_;
		GHashTable* _tmp5_;
		_tmp4_ = self->priv->plugin;
		_tmp5_ = cookies;
		ap_plugin_set_cookies (_tmp4_, _tmp5_);
	}
}


/**
     * Set a plugin widget and show it, removing the old widget if necessary.
     *
     * @param plugin_widget the Gtk.Widget to set as the new plugin widget
     */
static void cc_credentials_authorization_page_set_plugin_widget (CcCredentialsAuthorizationPage* self, GtkWidget* plugin_widget) {
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_widget != NULL);
	cc_credentials_authorization_page_remove_plugin_widget (self);
	_tmp0_ = plugin_widget;
	self->priv->widget = _tmp0_;
	_tmp1_ = self->priv->widget;
	gtk_widget_show (_tmp1_);
	_tmp2_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) self, _tmp2_);
}


/**
     * Remove the plugin widget.
     */
static void cc_credentials_authorization_page_remove_plugin_widget (CcCredentialsAuthorizationPage* self) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_;
		_tmp1_ = self->priv->widget;
		gtk_container_remove ((GtkContainer*) self, _tmp1_);
		self->priv->widget = NULL;
	}
}


/**
     * Handle the "finished" signal from the plugin. 
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void cc_credentials_authorization_page_on_plugin_finished (CcCredentialsAuthorizationPage* self) {
	ApPlugin* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean user_cancelled;
	ApPlugin* _tmp2_;
	GError* _tmp3_ = NULL;
	GError* _tmp4_;
	GError* plugin_err;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->plugin;
	_tmp1_ = ap_plugin_get_user_cancelled (_tmp0_);
	user_cancelled = _tmp1_;
	_tmp2_ = self->priv->plugin;
	_tmp3_ = ap_plugin_get_error (_tmp2_);
	_tmp4_ = _g_error_copy0 (_tmp3_);
	plugin_err = _tmp4_;
	cc_credentials_authorization_page_remove_plugin_widget (self);
	_g_object_unref0 (self->priv->plugin);
	self->priv->plugin = NULL;
	_tmp5_ = user_cancelled;
	if (_tmp5_) {
		g_signal_emit_by_name (self, "cancelled");
	} else {
		GError* _tmp6_;
		_tmp6_ = plugin_err;
		if (_tmp6_ != NULL) {
			GError* _tmp24_;
			const gchar* _tmp25_;
			{
				GHashFunc _tmp7_;
				GHashTable* _tmp8_;
				GHashTable* notification;
				AgAccount* _tmp9_;
				const gchar* _tmp10_ = NULL;
				GVariant* _tmp11_;
				GVariant* _tmp12_;
				GVariant* display_name;
				GHashTable* _tmp13_;
				gchar* _tmp14_;
				GVariant* _tmp15_;
				GVariant* _tmp16_;
				CcWebcredentialsIndicator* _tmp17_;
				AgAccount* _tmp18_;
				guint _tmp19_ = 0U;
				guint _tmp20_;
				GHashTable* _tmp21_;
				_tmp7_ = g_str_hash;
				_tmp8_ = g_hash_table_new_full (_tmp7_, NULL, _g_free0_, _g_variant_unref0_);
				notification = _tmp8_;
				_tmp9_ = self->priv->current_account;
				_tmp10_ = ag_account_get_display_name (_tmp9_);
				_tmp11_ = g_variant_new_string (_tmp10_);
				_tmp12_ = g_variant_ref_sink (_tmp11_);
				display_name = _tmp12_;
				_tmp13_ = notification;
				_tmp14_ = g_strdup ("DisplayName");
				_tmp15_ = display_name;
				_tmp16_ = _g_variant_ref0 (_tmp15_);
				g_hash_table_insert (_tmp13_, _tmp14_, _tmp16_);
				_tmp17_ = self->priv->indicator;
				_tmp18_ = self->priv->current_account;
				g_object_get (_tmp18_, "id", &_tmp19_, NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = notification;
				cc_webcredentials_indicator_report_failure (_tmp17_, _tmp20_, _tmp21_, NULL, NULL);
				_g_variant_unref0 (display_name);
				_g_hash_table_unref0 (notification);
			}
			goto __finally8;
			__catch8_g_io_error:
			{
				GError* err = NULL;
				GError* _tmp22_;
				const gchar* _tmp23_;
				err = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = err;
				_tmp23_ = _tmp22_->message;
				g_warning ("cc-credentials-authorization-page.vala:192: Error reporting authentica" \
"tion failure: %s", _tmp23_);
				_g_error_free0 (err);
			}
			__finally8:
			if (_inner_error_ != NULL) {
				_g_error_free0 (plugin_err);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp24_ = plugin_err;
			_tmp25_ = _tmp24_->message;
			g_critical ("cc-credentials-authorization-page.vala:196: Error completing auth sess" \
"ion process: %s", _tmp25_);
		} else {
			CcWebcredentialsIndicator* _tmp26_;
			AgAccount* _tmp27_;
			guint _tmp28_ = 0U;
			guint _tmp29_;
			guint* _tmp30_ = NULL;
			guint* _tmp31_;
			gint _tmp31__length1;
			CcWebcredentialsIndicator* _tmp32_;
			_tmp26_ = self->priv->indicator;
			_tmp27_ = self->priv->current_account;
			g_object_get (_tmp27_, "id", &_tmp28_, NULL);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_new0 (guint, 1);
			_tmp30_[0] = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp31__length1 = 1;
			cc_webcredentials_indicator_remove_failures (_tmp26_, _tmp31_, 1, NULL, NULL);
			_tmp31_ = (g_free (_tmp31_), NULL);
			_tmp32_ = self->priv->indicator;
			cc_webcredentials_indicator_clear_error_status (_tmp32_, NULL, NULL);
		}
		g_signal_emit_by_name (self, "cancelled");
	}
	_g_error_free0 (plugin_err);
}


AgAccount* cc_credentials_authorization_page_get_account (CcCredentialsAuthorizationPage* self) {
	AgAccount* result;
	AgAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_account;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cc_credentials_authorization_page_on_plugin_finished_ap_plugin_finished (ApPlugin* _sender, gpointer self) {
	cc_credentials_authorization_page_on_plugin_finished (self);
}


void cc_credentials_authorization_page_set_account (CcCredentialsAuthorizationPage* self, AgAccount* value) {
	AgAccount* _tmp0_;
	AgAccount* _tmp1_;
	AgAccount* _tmp2_;
	AgAccount* _tmp3_;
	ApPlugin* _tmp4_ = NULL;
	ApPlugin* _tmp5_;
	ApPlugin* _tmp8_;
	gboolean _tmp9_;
	ApPlugin* _tmp11_;
	GtkWidget* _tmp12_ = NULL;
	GtkWidget* _tmp13_;
	GtkWidget* plugin_widget;
	GtkWidget* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->current_account);
	self->priv->current_account = _tmp1_;
	_tmp2_ = cc_credentials_authorization_page_get_account (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = ap_client_load_plugin (_tmp3_);
	_g_object_unref0 (self->priv->plugin);
	self->priv->plugin = _tmp4_;
	_tmp5_ = self->priv->plugin;
	if (_tmp5_ == NULL) {
		AgAccount* _tmp6_;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = value;
		_tmp7_ = ag_account_get_provider_name (_tmp6_);
		g_critical ("cc-credentials-authorization-page.vala:54: No valid plugin found for p" \
"rovider %s", _tmp7_);
		return;
	}
	_tmp8_ = self->priv->plugin;
	g_signal_connect_object (_tmp8_, "finished", (GCallback) _cc_credentials_authorization_page_on_plugin_finished_ap_plugin_finished, self, 0);
	_tmp9_ = self->priv->needs_reauthentication;
	if (_tmp9_) {
		ApPlugin* _tmp10_;
		_tmp10_ = self->priv->plugin;
		ap_plugin_set_need_authentication (_tmp10_, TRUE);
	}
	_tmp11_ = self->priv->plugin;
	_tmp12_ = ap_plugin_build_widget (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	plugin_widget = _tmp13_;
	_tmp14_ = plugin_widget;
	if (_tmp14_ != NULL) {
		ApPlugin* _tmp15_;
		GtkWidget* _tmp16_ = NULL;
		_tmp15_ = self->priv->plugin;
		_tmp16_ = ap_plugin_build_widget (_tmp15_);
		cc_credentials_authorization_page_set_plugin_widget (self, _tmp16_);
	} else {
		AgAccount* _tmp17_;
		guint _tmp18_ = 0U;
		guint _tmp19_;
		_tmp17_ = value;
		g_object_get (_tmp17_, "id", &_tmp18_, NULL);
		_tmp19_ = _tmp18_;
		g_critical ("cc-credentials-authorization-page.vala:74: Plugin failed to build widg" \
"et for account ID: %u", _tmp19_);
		_g_object_unref0 (plugin_widget);
		return;
	}
	_g_object_unref0 (plugin_widget);
	g_object_notify ((GObject *) self, "account");
}


static GObject * cc_credentials_authorization_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CcCredentialsAuthorizationPage * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (cc_credentials_authorization_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CC_CREDENTIALS_AUTHORIZATION_PAGE (obj);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	{
		CcWebcredentialsIndicator* _tmp0_ = NULL;
		CcWebcredentialsIndicator* _tmp1_;
		_tmp0_ = g_initable_new (CC_TYPE_WEBCREDENTIALS_INDICATOR_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "com.canonical.indicators.webcredentials", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/com/canonical/indicators/webcredentials", "g-interface-name", "com.canonical.indicators.webcredentials", NULL);
		_tmp1_ = (CcWebcredentialsIndicator*) _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch9_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->indicator);
		self->priv->indicator = _tmp1_;
	}
	goto __finally9;
	__catch9_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("cc-credentials-authorization-page.vala:99: Error initializing indicato" \
"r proxy: %s\n" \
"Account attention notifications will not function", _tmp3_);
		_g_error_free0 (err);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	gtk_widget_show ((GtkWidget*) self);
	return obj;
}


static void cc_credentials_authorization_page_class_init (CcCredentialsAuthorizationPageClass * klass) {
	cc_credentials_authorization_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsAuthorizationPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_authorization_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_cc_credentials_authorization_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = cc_credentials_authorization_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_authorization_page_finalize;
	/**
	     * Keep the UI state consistent when the account is changed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_AUTHORIZATION_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", ag_account_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Emitted when the authorization process was cancelled.
	     */
	g_signal_new ("cancelled", CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void cc_credentials_authorization_page_instance_init (CcCredentialsAuthorizationPage * self) {
	self->priv = CC_CREDENTIALS_AUTHORIZATION_PAGE_GET_PRIVATE (self);
	self->priv->needs_reauthentication = FALSE;
}


static void cc_credentials_authorization_page_finalize (GObject* obj) {
	CcCredentialsAuthorizationPage * self;
	self = CC_CREDENTIALS_AUTHORIZATION_PAGE (obj);
	_g_object_unref0 (self->priv->plugin);
	_g_object_unref0 (self->priv->current_account);
	_g_object_unref0 (self->priv->indicator);
	G_OBJECT_CLASS (cc_credentials_authorization_page_parent_class)->finalize (obj);
}


/**
 * Web credentials authorization page. This is designed to take the full width
 * of the parent widget, for display of an authorization widget, such as a
 * WebKit view.
 */
GType cc_credentials_authorization_page_get_type (void) {
	static volatile gsize cc_credentials_authorization_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_authorization_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsAuthorizationPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_authorization_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsAuthorizationPage), 0, (GInstanceInitFunc) cc_credentials_authorization_page_instance_init, NULL };
		GType cc_credentials_authorization_page_type_id;
		cc_credentials_authorization_page_type_id = g_type_register_static (GTK_TYPE_GRID, "CcCredentialsAuthorizationPage", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_authorization_page_type_id__volatile, cc_credentials_authorization_page_type_id);
	}
	return cc_credentials_authorization_page_type_id__volatile;
}


static void _vala_cc_credentials_authorization_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsAuthorizationPage * self;
	self = CC_CREDENTIALS_AUTHORIZATION_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_AUTHORIZATION_PAGE_ACCOUNT:
		g_value_set_object (value, cc_credentials_authorization_page_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_cc_credentials_authorization_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CcCredentialsAuthorizationPage * self;
	self = CC_CREDENTIALS_AUTHORIZATION_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_AUTHORIZATION_PAGE_ACCOUNT:
		cc_credentials_authorization_page_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



