/*
 * Copyright (C) 2001, 2002 Free Software Foundation
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Authors : Carlos Garca Campos <carlosgc@gnome.org>
 */


#include <gnome.h>
#include <panel-applet.h>

typedef enum {
	   POWERSAVE,
	   PERFORMANCE,
	   USERSPACE,
} CPUFreqMode;

typedef enum {
	   MODE_FREQUENCY,
	   MODE_PERCENTAGE,
	   MODE_NONE
} CPUFreqShowMode;

typedef struct {
	   PanelApplet base;
	   guint cpu;
	   guint mcpu; /* Max cpu number (0 in a single cpu system) */

	   CPUFreqShowMode show_mode;
	   gboolean show_unit;
	   gchar *freq;
	   gchar *perc;
	   gchar *unit;

	   guint timeout_handler;

	   GtkWidget *label;
	   GtkWidget *pixmap;
	   GtkWidget *box;
	   GdkPixbuf *pixbufs[4];
	   GtkTooltips *tips;

	   GtkWidget *prefs;
	   GtkWidget *about_dialog;
}CPUFreqApplet;

void cpufreq_applet_update        (CPUFreqApplet *applet, CPUFreqMode mode);
void cpufreq_applet_display_error (const gchar *error_message);
