// This file was generated by go generate; DO NOT EDIT

package display

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "27.0.1"

// Version is deprecated. Use CLDRVersion.
const Version = "27.0.1"

var parents = [210]int16{
	// Entry 0 - 3F
	-1, -1, -1, -1, -1, 4, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 18, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	31, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, 41, -1, -1, 44, 44, -1,
	-1, -1, -1, 50, -1, -1, -1, -1,
	-1, 56, -1, -1, -1, -1, -1, -1,
	// Entry 40 - 7F
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	// Entry 80 - BF
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 146, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	159, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	175, -1, 177, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, 190,
	// Entry C0 - FF
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, 203, -1, -1, -1,
	207, -1,
}

// Number of keys: 604
var (
	langIndex = tagIndex{
		"aaabaeafakamanarasavayazbabebgbibmbnbobrbscacechcocrcscucvcydadedvdzeeel" +
			"eneoeseteufafffifjfofrfygagdglgngugvhahehihohrhthuhyhziaidieigiiikio" +
			"isitiujajvkakgkikjkkklkmknkokrkskukvkwkylalblglilnloltlulvmgmhmimkml" +
			"mnmrmsmtmynandnengnlnnnonrnvnyocojomorospapiplpsptqurmrnrorurwsascsd" +
			"sesgsiskslsmsnsosqsrssstsusvswtatetgthtitktntotrtstttyugukuruzvevivo" +
			"wawoxhyiyozazhzu",
		"aceachadaadyaebafhagqainakkakzalealnaltanganparcarnaroarparqarwaryarzasa" +
			"aseastavkawaazbbalbanbarbasbaxbbcbbjbejbembewbezbfdbfqbhobikbinbjnbk" +
			"mblabpybqibrabrhbrxbssbuabugbumbynbyvcadcarcaycchcebcggchbchgchkchmc" +
			"hnchochpchrchyckbcopcpscrhcsbdakdardavdeldendgrdindjedoidsbdtpduadum" +
			"dyodyudzgebuefieglegyekaelxenmesuewoextfanfilfitfonfrcfrmfrofrpfrrfr" +
			"sfurgaagaggangaygbagbzgezgilglkgmhgohgomgongorgotgrbgrcgswgucgurguzg" +
			"wihaihakhawhifhilhithmnhsbhsnhupibaibbiloinhizhjamjbojgojmcjprjrbjut" +
			"kaakabkackajkamkawkbdkblkcgkdekeakenkfokgpkhakhokhqkhwkiukkjklnkmbko" +
			"ikokkoskpekrckrikrjkrlkruksbksfkshkumkutladlaglahlamlezlfnlijlivlktl" +
			"molollozltglualuilunluolusluylzhlzzmadmafmagmaimakmanmasmdemdfmdrmen" +
			"mermfemgamghmgomicminmncmnimohmosmrjmuamulmusmwlmwrmwvmyemyvmznnanna" +
			"pnaqndsnewnianiunjonmgnnhnognonnovnqonsonusnwcnymnynnyonziosaotapagp" +
			"alpampappaupcdpdcpdtpeopflphnpmspntponprgproqucqugrajraprarrgnrifrof" +
			"romrtmruerugruprwksadsahsamsaqsassatsazsbasbpscnscosdcseesehseiselse" +
			"ssgasgsshishnshusidslislysmasmjsmnsmssnksogsrnsrrssystqsuksussuxswbs" +
			"wcsycsyrszltcytemteotertettigtivtkltkrtlhtlitlytmhtogtpitrutrvtsdtsi" +
			"ttttumtvltwqtyvtzmudmugaumbundvaivecvepvlsvmfvotvrovunwaewalwarwaswb" +
			"pwuuxalxmfxogyaoyapyavybbyrlyuezapzblzeazenzghzunzxxzza",
		"",
	}
	langTagsLong = []string{ // 19 elements
		"ar-001",
		"de-AT",
		"de-CH",
		"en-AU",
		"en-CA",
		"en-GB",
		"en-US",
		"es-419",
		"es-ES",
		"es-MX",
		"fr-CA",
		"fr-CH",
		"nl-BE",
		"pt-BR",
		"pt-PT",
		"ro-MD",
		"sr-Latn",
		"zh-Hans",
		"zh-Hant",
	}
)

var langHeaders = [210]header{
	{ // af
		afLangStr,
		afLangIdx,
	},
	{ // agq
		"AkanÀmalìÀlabìBɛ̀làlusànBùugɨlìaBɨ̀ŋgalìChɛ̂Dzamɛ̀Gɨ̀lêʔKɨŋgeleSɨ̀kpanìs" +
			"KpɛɛshìaKɨ̀fàlàŋsiKɨtsɔŋkaŋEndìHɔŋgalìaÈndònɛshìaEgbòÈtalìaDzàkpànêD" +
			"zàbvànêKɨmɛ̀kùulîaMàlaeBùumɛsɛ̀Nɛ̀kpalìDɔ̂sKpuwndzabìKpɔlìsKpotùwgîi" +
			"LùmanyìaLushìaLùwandàSòmalìSuedìsTamìTàeTʉʉkìsÙkɛlɛnìaUudùwVìyɛtnàmê" +
			"YulùbaChàenêZulùAghem",
		[]uint16{ // 188 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0020, 0x002b,
			0x002b, 0x002b, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037,
			0x0037, 0x0037, 0x0037, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x0045, 0x0045, 0x0045, 0x0045, 0x004f, 0x0058, 0x0058, 0x0064,
			0x0064, 0x0064, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x007e,
			0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x008b,
			0x008b, 0x0090, 0x0090, 0x0090, 0x0090, 0x009b, 0x009b, 0x009b,
			// Entry 40 - 7F
			0x009b, 0x00a9, 0x00a9, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00b6, 0x00b6, 0x00c1, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00cc, 0x00cc, 0x00d4, 0x00d4, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00e2, 0x00e2, 0x00ee, 0x00ee, 0x00ee,
			0x00f9, 0x00f9, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
			0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x010a, 0x010a, 0x0112,
			// Entry 80 - BF
			0x0112, 0x011d, 0x011d, 0x011d, 0x011d, 0x0127, 0x012e, 0x0137,
			0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137,
			0x0137, 0x0137, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0146, 0x0146, 0x014b, 0x014b, 0x014b, 0x014f, 0x014f, 0x014f,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0158, 0x0158, 0x0164,
			0x016a, 0x016a, 0x016a, 0x0177, 0x0177, 0x0177, 0x0177, 0x0177,
			0x0177, 0x017e, 0x017e, 0x0186, 0x018b, 0x018b, 0x018b, 0x018b,
			0x018b, 0x018b, 0x018b, 0x0190,
		},
	},
	{ // ak
		"AkanAmarikArabikBelarus kasaBɔlgeria kasaBengali kasaKyɛk kasaGyaamanGre" +
			"ek kasaBorɔfoSpain kasaPɛɛhyia kasaFrɛnkyeHausaHindiHangri kasaIndon" +
			"ihyia kasaIgboItaly kasaGyapan kasaGyabanis kasaKambodia kasaKorea k" +
			"asaMalay kasaBɛɛmis kasaNɛpal kasaDɛɛkyePungyabi kasaPɔland kasaPɔɔt" +
			"ugal kasaRomenia kasaRahyia kasaRewanda kasaSomalia kasaSweden kasaT" +
			"amil kasaTaeland kasaTɛɛki kasaUkren kasaUrdu kasaViɛtnam kasaYoruba" +
			"Kyaena kasaZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000a, 0x000a,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x001c, 0x002a,
			0x002a, 0x002a, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0047, 0x0047, 0x0047, 0x0047, 0x0051, 0x0058, 0x0058, 0x0062,
			0x0062, 0x0062, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0078,
			0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x007d,
			0x007d, 0x0082, 0x0082, 0x0082, 0x0082, 0x008d, 0x008d, 0x008d,
			// Entry 40 - 7F
			0x008d, 0x009c, 0x009c, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0,
			0x00aa, 0x00aa, 0x00b5, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00cf, 0x00cf, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00e3, 0x00e3, 0x00f0, 0x00f0, 0x00f0,
			0x00fb, 0x00fb, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103,
			0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x0110, 0x0110, 0x011c,
			// Entry 80 - BF
			0x011c, 0x012b, 0x012b, 0x012b, 0x012b, 0x0137, 0x0142, 0x014e,
			0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
			0x014e, 0x014e, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x0165, 0x0165, 0x016f, 0x016f, 0x016f, 0x017b, 0x017b, 0x017b,
			0x017b, 0x017b, 0x0187, 0x0187, 0x0187, 0x0187, 0x0187, 0x0191,
			0x019a, 0x019a, 0x019a, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01ad, 0x01ad, 0x01b8, 0x01bc,
		},
	},
	{ // am
		amLangStr,
		amLangIdx,
	},
	{ // ar
		arLangStr,
		arLangIdx,
	},
	{ // ar-EG
		"الدنماركية",
		[]uint16{ // 32 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014,
		},
	},
	{ // as
		"অসমীয়া",
		[]uint16{ // 10 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0015,
		},
	},
	{ // asa
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKichekiKijerumaniKigiri" +
			"kiKiingeredhaKihithpaniaKiajemiKifaranthaKihauthaKihindiKihungariKii" +
			"ndonethiaKiigboKiitaliaanoKijapaniKijavaKikambodiaKikoreaKimalesiaKi" +
			"burmaKinepaliKiholandhiKipunjabiKipolandiKirenoKiromaniaKiruthiKinya" +
			"randwaKithomaliKithwidiKitamilKitailandiKiturukiKiukraniaKiurduKivie" +
			"tinamuKiyorubaKichinaKidhuluKipare",
		[]uint16{ // 205 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0042, 0x0042, 0x0042, 0x0042, 0x004a, 0x0055, 0x0055, 0x0060,
			0x0060, 0x0060, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0071,
			0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0079,
			0x0079, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089, 0x0089, 0x0089,
			// Entry 40 - 7F
			0x0089, 0x0095, 0x0095, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x00a6, 0x00a6, 0x00ae, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00be, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00ce, 0x00ce, 0x00d5, 0x00d5, 0x00d5,
			0x00dd, 0x00dd, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00f0, 0x00f0, 0x00f9,
			// Entry 80 - BF
			0x00f9, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x0108, 0x010f, 0x011a,
			0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x011a, 0x011a, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123,
			0x012b, 0x012b, 0x0132, 0x0132, 0x0132, 0x013c, 0x013c, 0x013c,
			0x013c, 0x013c, 0x0144, 0x0144, 0x0144, 0x0144, 0x0144, 0x014d,
			0x0153, 0x0153, 0x0153, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e,
			0x015e, 0x0166, 0x0166, 0x016d, 0x0174, 0x0174, 0x0174, 0x0174,
			0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174,
			// Entry C0 - FF
			0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174,
			0x0174, 0x0174, 0x0174, 0x0174, 0x017a,
		},
	},
	{ // ast
		"afarabkhazianuavestanínafrikaansakamharicuaragonésárabeasamésaváricuayma" +
			"raazerbaixanubashkirbielorrusubúlgarubislamabambarabengalíntibetanub" +
			"retónbosniucatalánchechenuchamorrocorsucreechecueslávicu eclesiástic" +
			"uchuvashgalésdanésalemándivehidzongkhaewegrieguinglésesperantoespaño" +
			"lestoniuvascupersafulahfinlandésfixanuferoésfrancésfrisón occidental" +
			"irlandésgaélicu escocésgalleguguaraníguyaratímanésḥausahebréuhindihi" +
			"ri motucroatahaitianuhúngaruarmeniuhererointerlinguaindonesiuinterli" +
			"ngueigboyi de Sichuaninupiaqidoislandésitalianuinuktitutxaponésxavan" +
			"ésxeorxanukongokikuyukuanyamakazaquistanínkalaallisutkhmercanarésco" +
			"reanukanuricachemiréscurdukomicórnicukirguistanínllatínluxemburguésg" +
			"andalimburguéslingalalaosianulituanuluba-katangaletónmalgaxemarshall" +
			"ésmaorímacedoniumalayalammongolmarathimalayumaltésbirmanunaurundebe" +
			"le del nortenepalésndonganeerlandésnoruegu Nynorsknoruegu Bokmålndeb" +
			"ele del surnavajonyanjaoccitanuojibwaoromooriyaoséticupunyabípolacup" +
			"ashtuportuguésquechuaromancherundirumanurusurwsánscritusardusindhisa" +
			"mi del nortesangocingaléseslovacueslovenusamoanushonasomalínalbanuse" +
			"rbiuswatisotho del sursondanéssuecusuaḥilitamiltelugutaxiquistanínta" +
			"ilandéstigrinyaturcomanutswanatonganuturcutsongatártarutahitianuuigu" +
			"rucraínuruzbequistanínvendavietnamínvalónwolofxhosayiddishyorubazhua" +
			"ngchinuzulúachinésacoliadangmeadygheárabe de Túnezafrihiliaghemainua" +
			"cadianualabamaaleutgheg d’Albaniaaltai del suringlés antiguuangikaar" +
			"améumapuchearaonaarapahoárabe d’Arxeliaarawakárabe de Marruecosárabe" +
			" d’Exiptuasullingua de signos americanaasturianukotavaawadhiazerbaix" +
			"anu del surbaluchibalinésbávarubasaabamunbatak tobaghomalabejabembab" +
			"etawibenabafutbadagabhojpuribikolbinibanjarkomsiksikabishnupriyabakh" +
			"tiaribrajbrahuibodoakooseburiatbuginésbulublinmedumbacaddocaribecayu" +
			"gaatsamcebuanuchigachibchachagataichuukésmarixíriga chinookchoctawch" +
			"ipewyanucheroquicheyennekurdu soranicoptucapiznonturcu de Crimeakash" +
			"ubianudakotadargwataitadelawareslavedogribdinkazarmadogribaxu sorbiu" +
			"dusun centraldualaneerlandés mediujola-fonyidyuladazagaembúefikemili" +
			"anuexipciu antiguuekajukelamitainglés mediuyupik centralewondoestrem" +
			"eñufangfilipínfinlandés de Tornedalenfonfrancés cajunfrancés mediufr" +
			"ancés antiguuarpitanufrisón del nortefrisón orientalfriulianugagagau" +
			"zchinu gangayogbayadari zoroastrianugeezgilbertésgilakialtualemán me" +
			"diualtualemán antiguugoan konkanigondigorontalogóticugrebogriegu ant" +
			"iguualemán de Suizawayuufrafragusiigwichʼinhaidachinu hakkahawaianuh" +
			"indi de Fijihiligaynonhititahmongaltu sorbiuchinu xianghupaibanibibi" +
			"oilokoingushingrianuinglés criollu xamaicanulojbanngombamachamexudeo" +
			"-persaxudeo-árabejutlandéskara-kalpakkabileñukachinjjukambakawikabar" +
			"dianukanembutyapmakondecabuverdianukenyangkorokaingangkhasikhotanésk" +
			"oyra chiinikhowarkirmanjkikakoklnkimbundukomi-permyakkonkanikosraean" +
			"ukpellekarachay-balkarkriokinaray-akarelianukurukhshambalabafiacolon" +
			"ianukumykkutenailadinolangilahndalambalezghianulingua franca novalig" +
			"urianulivonianulakotalombardumongolozilatgalianuluba-lulualuisenolun" +
			"daluomizoluyiachinu lliterariulazmadurésmafamagahimaithilimakasarman" +
			"dingomasaimabamokshamandarmendemerumorisyenírlandés mediumakhuwa-mee" +
			"ttometa’micmacminangkabaumanchúmanipurimohawkmossimari occidentalmun" +
			"dangmúltiples llingüescreekmirandésmarwarimentawaimyeneerzyamazander" +
			"anichinu min nannapolitanunamabaxu alemánnewariniasniueanuao nagakwa" +
			"siongiemboonnogainoruegu antiguunovialn’kosotho del nortenuernewari " +
			"clásicunyamwezinyankolenyoronzimaturcu otomanupangasinanpampangapapi" +
			"amentopalauanupícarualemán de Pennsylvaniapersa antiguualemán palati" +
			"nufeniciupiamontéspohnpeianuprusianuprovenzal antiguukʼicheʼrajastha" +
			"nínromañolrifianuromboromanírotumanurusynrwasakhaaraméu samaritanusa" +
			"mburusasaksantalisaurashtrasangusicilianuscotssardu sassaréssénecase" +
			"nakoyraboro senniirlandés antiguutachelhitshansidamosami del surlule" +
			" samiinari samiskolt samisoninkesranan tongoserersahofrisón de Sater" +
			"landsukumasususumeriucomorianuswahili del Congosiriacu clásicusiriac" +
			"usilesianutulutimnetesotetumtigretivtokelauklingontamashektok pisint" +
			"arokotumbukatuvalutasawaqtuvinianutamazight del Atlas centraludmurtu" +
			"garíticuumbundurootvaivenecianuflamencu occidentalvunjowolayttawaray" +
			"chinu wusogayaoyapésyangbenyembacantonészapotecazeelandéstamazight e" +
			"stándar de Marruecosensin conteníu llingüísticuárabe estándar modern" +
			"ualtualemán de Suizainglés de Canadáinglés de Gran Bretañainglés ame" +
			"ricanuespañol de Méxicofrancés de Canadáfrancés de Suizaflamencuport" +
			"ugués del Brasilmoldavuserbo-croatachinu simplificáuchinu tradiciona" +
			"l",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000e, 0x0018, 0x0021, 0x0023, 0x002b, 0x0034,
			0x003a, 0x0041, 0x0049, 0x004f, 0x005a, 0x0061, 0x006b, 0x0073,
			0x007a, 0x0081, 0x008a, 0x0092, 0x0099, 0x009f, 0x00a7, 0x00af,
			0x00b7, 0x00bc, 0x00c0, 0x00c5, 0x00dc, 0x00e3, 0x00e9, 0x00ef,
			0x00f6, 0x00fc, 0x0104, 0x0107, 0x010d, 0x0114, 0x011d, 0x0125,
			0x012c, 0x0131, 0x0136, 0x013b, 0x0145, 0x014b, 0x0152, 0x015a,
			0x016c, 0x0175, 0x0186, 0x018d, 0x0195, 0x019e, 0x01a4, 0x01ab,
			0x01b2, 0x01b7, 0x01c0, 0x01c6, 0x01ce, 0x01d6, 0x01dd, 0x01e3,
			// Entry 40 - 7F
			0x01ee, 0x01f7, 0x0202, 0x0206, 0x0213, 0x021a, 0x021d, 0x0226,
			0x022e, 0x0237, 0x023f, 0x0247, 0x024f, 0x0254, 0x025a, 0x0262,
			0x0270, 0x027b, 0x0280, 0x0288, 0x028f, 0x0295, 0x02a0, 0x02a5,
			0x02a9, 0x02b1, 0x02be, 0x02c5, 0x02d2, 0x02d7, 0x02e2, 0x02e9,
			0x02f1, 0x02f8, 0x0304, 0x030a, 0x0311, 0x031c, 0x0322, 0x032b,
			0x0334, 0x033a, 0x0341, 0x0347, 0x034e, 0x0355, 0x035a, 0x036b,
			0x0373, 0x0379, 0x0384, 0x0393, 0x03a2, 0x03b1, 0x03b7, 0x03bd,
			0x03c5, 0x03cb, 0x03d0, 0x03d5, 0x03dd, 0x03e5, 0x03e5, 0x03eb,
			// Entry 80 - BF
			0x03f1, 0x03fb, 0x0402, 0x040a, 0x040f, 0x0415, 0x0419, 0x041b,
			0x0425, 0x042a, 0x0430, 0x043e, 0x0443, 0x044c, 0x0454, 0x045c,
			0x0463, 0x0468, 0x0470, 0x0476, 0x047c, 0x0481, 0x048e, 0x0497,
			0x049c, 0x04a5, 0x04aa, 0x04b0, 0x04be, 0x04c8, 0x04d0, 0x04d9,
			0x04df, 0x04e6, 0x04eb, 0x04f1, 0x04f9, 0x0502, 0x0507, 0x050e,
			0x0510, 0x051e, 0x0523, 0x052d, 0x052d, 0x0533, 0x0538, 0x053d,
			0x0544, 0x054a, 0x0550, 0x0555, 0x055a, 0x0562, 0x0567, 0x056e,
			0x0574, 0x0584, 0x058c, 0x0591, 0x0595, 0x059d, 0x05a4, 0x05a9,
			// Entry C0 - FF
			0x05b9, 0x05c6, 0x05d5, 0x05db, 0x05e2, 0x05e9, 0x05ef, 0x05f6,
			0x0608, 0x060e, 0x0621, 0x0632, 0x0635, 0x0650, 0x0659, 0x065f,
			0x0665, 0x0678, 0x067f, 0x0687, 0x068e, 0x0693, 0x0698, 0x06a2,
			0x06a9, 0x06ad, 0x06b2, 0x06b8, 0x06bc, 0x06c1, 0x06c7, 0x06cf,
			0x06d4, 0x06d8, 0x06de, 0x06e1, 0x06e8, 0x06f3, 0x06fc, 0x0700,
			0x0706, 0x070a, 0x0710, 0x0716, 0x071e, 0x0722, 0x0726, 0x072d,
			0x0732, 0x0738, 0x073e, 0x0743, 0x074a, 0x074f, 0x0756, 0x075e,
			0x0766, 0x076a, 0x0779, 0x0780, 0x078a, 0x0792, 0x079a, 0x07a6,
			// Entry 100 - 13F
			0x07ab, 0x07b3, 0x07c2, 0x07cc, 0x07d2, 0x07d8, 0x07dd, 0x07e5,
			0x07ea, 0x07f0, 0x07f5, 0x07fa, 0x07ff, 0x080a, 0x0817, 0x081c,
			0x082d, 0x0837, 0x083c, 0x0842, 0x0847, 0x084b, 0x0853, 0x0862,
			0x0868, 0x086f, 0x087c, 0x0889, 0x088f, 0x0899, 0x089d, 0x08a5,
			0x08bd, 0x08c0, 0x08ce, 0x08dc, 0x08ec, 0x08f4, 0x0905, 0x0915,
			0x091e, 0x0920, 0x0926, 0x092f, 0x0933, 0x0938, 0x0949, 0x094d,
			0x0957, 0x095d, 0x096e, 0x0981, 0x098d, 0x0992, 0x099b, 0x09a2,
			0x09a7, 0x09b5, 0x09c5, 0x09ca, 0x09d0, 0x09d5, 0x09de, 0x09e3,
			// Entry 140 - 17F
			0x09ee, 0x09f6, 0x0a03, 0x0a0d, 0x0a13, 0x0a18, 0x0a23, 0x0a2e,
			0x0a32, 0x0a36, 0x0a3c, 0x0a41, 0x0a47, 0x0a4f, 0x0a68, 0x0a6e,
			0x0a74, 0x0a7b, 0x0a86, 0x0a92, 0x0a9c, 0x0aa7, 0x0ab0, 0x0ab6,
			0x0ab9, 0x0abe, 0x0ac2, 0x0acc, 0x0ad3, 0x0ad7, 0x0ade, 0x0aea,
			0x0af1, 0x0af5, 0x0afd, 0x0b02, 0x0b0b, 0x0b17, 0x0b1d, 0x0b26,
			0x0b2a, 0x0b2d, 0x0b35, 0x0b41, 0x0b48, 0x0b51, 0x0b57, 0x0b66,
			0x0b6a, 0x0b73, 0x0b7c, 0x0b82, 0x0b8a, 0x0b8f, 0x0b98, 0x0b9d,
			0x0ba4, 0x0baa, 0x0baf, 0x0bb5, 0x0bba, 0x0bc3, 0x0bd5, 0x0bde,
			// Entry 180 - 1BF
			0x0be7, 0x0bed, 0x0bf5, 0x0bfa, 0x0bfe, 0x0c08, 0x0c12, 0x0c19,
			0x0c1e, 0x0c21, 0x0c25, 0x0c2a, 0x0c3a, 0x0c3d, 0x0c45, 0x0c49,
			0x0c4f, 0x0c57, 0x0c5e, 0x0c66, 0x0c6b, 0x0c6f, 0x0c75, 0x0c7b,
			0x0c80, 0x0c84, 0x0c8c, 0x0c9c, 0x0caa, 0x0cb1, 0x0cb7, 0x0cc2,
			0x0cc9, 0x0cd1, 0x0cd7, 0x0cdc, 0x0ceb, 0x0cf2, 0x0d06, 0x0d0b,
			0x0d14, 0x0d1b, 0x0d23, 0x0d28, 0x0d2d, 0x0d38, 0x0d45, 0x0d4f,
			0x0d53, 0x0d5f, 0x0d65, 0x0d69, 0x0d70, 0x0d77, 0x0d7d, 0x0d86,
			0x0d8b, 0x0d9a, 0x0da0, 0x0da6, 0x0db5, 0x0db9, 0x0dc8, 0x0dd0,
			// Entry 1C0 - 1FF
			0x0dd8, 0x0ddd, 0x0de2, 0x0de2, 0x0def, 0x0df9, 0x0df9, 0x0e01,
			0x0e0b, 0x0e13, 0x0e1a, 0x0e31, 0x0e31, 0x0e3e, 0x0e4e, 0x0e55,
			0x0e5f, 0x0e5f, 0x0e69, 0x0e71, 0x0e82, 0x0e8b, 0x0e8b, 0x0e97,
			0x0e97, 0x0e97, 0x0e9f, 0x0ea6, 0x0eab, 0x0eb2, 0x0eba, 0x0ebf,
			0x0ebf, 0x0ebf, 0x0ec2, 0x0ec2, 0x0ec7, 0x0ed9, 0x0ee0, 0x0ee5,
			0x0eec, 0x0ef6, 0x0ef6, 0x0efb, 0x0f04, 0x0f09, 0x0f18, 0x0f1f,
			0x0f23, 0x0f23, 0x0f23, 0x0f32, 0x0f43, 0x0f43, 0x0f4c, 0x0f50,
			0x0f50, 0x0f56, 0x0f56, 0x0f56, 0x0f62, 0x0f6b, 0x0f75, 0x0f7f,
			// Entry 200 - 23F
			0x0f86, 0x0f86, 0x0f92, 0x0f97, 0x0f9b, 0x0faf, 0x0fb5, 0x0fb9,
			0x0fc0, 0x0fc9, 0x0fda, 0x0fea, 0x0ff1, 0x0ffa, 0x0ffe, 0x1003,
			0x1007, 0x1007, 0x100c, 0x1011, 0x1014, 0x101b, 0x101b, 0x1022,
			0x1022, 0x1022, 0x102a, 0x102a, 0x1033, 0x1033, 0x1039, 0x1039,
			0x1039, 0x1039, 0x1040, 0x1046, 0x104d, 0x1056, 0x1071, 0x1077,
			0x1081, 0x1088, 0x108c, 0x108f, 0x1098, 0x1098, 0x10ab, 0x10ab,
			0x10ab, 0x10ab, 0x10b0, 0x10b0, 0x10b8, 0x10bd, 0x10bd, 0x10bd,
			0x10c5, 0x10c5, 0x10c5, 0x10c9, 0x10cc, 0x10d2, 0x10d9, 0x10de,
			// Entry 240 - 27F
			0x10de, 0x10e7, 0x10ef, 0x10ef, 0x10f9, 0x10f9, 0x1119, 0x1119,
			0x1137, 0x1137, 0x114f, 0x114f, 0x1163, 0x1163, 0x1175, 0x118d,
			0x119e, 0x119e, 0x119e, 0x11b1, 0x11c4, 0x11d5, 0x11dd, 0x11f2,
			0x11f2, 0x11f9, 0x1205, 0x1217, 0x1228,
		},
	},
	{ // az
		azLangStr,
		azLangIdx,
	},
	{ // az-Cyrl
		"Азәрбајҹаналманҹаинҝилисҹәиспанҹафрансызҹаиталјанҹајапонҹапортугалҹарусҹ" +
			"ачинҹә",
		[]uint16{ // 180 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0034, 0x0034, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			// Entry 40 - 7F
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0066, 0x0066, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			// Entry 80 - BF
			0x0074, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x009c,
		},
	},
	{ // bas
		"Hɔp u akanHɔp u amhārìkHɔp u arâbHɔp u bièlòrûsHɔp u bûlgârHɔp u bɛŋgàli" +
			"Hɔp u cɛ̂kHɔp u jamânHɔp u gri ᷇kyàHɔp u ŋgisìHɔp u panyāHɔp u pɛrsì" +
			"àHɔp u pulàsiHɔp u ɓausaHɔp u hindìHɔp u hɔŋgrìiHɔp u indònesìàHɔp " +
			"u iɓòHɔp u italìàHɔp u yapànHɔp u yavàHɔp u kmɛ̂rHɔp u kɔrēàHɔp u ma" +
			"kɛ᷆Hɔp u birmànHɔp u nepa᷆lHɔp u nlɛ̀ndiHɔp u pɛnjàbiHɔp u pɔlɔ̄nàHɔ" +
			"p u pɔtɔ̄kìHɔp u rùmanìàHɔp u ruslàndHɔp u ruāndàHɔp u somàlîHɔp u s" +
			"uɛ᷆dHɔp u tamu᷆lHɔp u tâyHɔp u tûrkHɔp u ukrǎnìàHɔp u urdùHɔp u vyɛ̄" +
			"dnàmHɔp u yorūbàHɔp u kinàHɔp u zulùƁàsàa",
		[]uint16{ // 214 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x001b, 0x001b,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0039, 0x0048,
			0x0048, 0x0048, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0085, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00be,
			0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00cb,
			0x00cb, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00e9, 0x00e9, 0x00e9,
			// Entry 40 - 7F
			0x00e9, 0x00fc, 0x00fc, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
			0x0117, 0x0117, 0x0124, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130,
			0x0130, 0x0130, 0x013e, 0x013e, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x014d, 0x014d, 0x015c, 0x015c, 0x016a, 0x016a, 0x016a,
			0x0179, 0x0179, 0x0189, 0x0189, 0x0189, 0x0189, 0x0189, 0x0189,
			0x0189, 0x0189, 0x0189, 0x0189, 0x0189, 0x0199, 0x0199, 0x01ab,
			// Entry 80 - BF
			0x01ab, 0x01bd, 0x01bd, 0x01bd, 0x01bd, 0x01ce, 0x01dd, 0x01ec,
			0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec,
			0x01ec, 0x01ec, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb,
			0x020a, 0x020a, 0x0219, 0x0219, 0x0219, 0x0224, 0x0224, 0x0224,
			0x0224, 0x0224, 0x0230, 0x0230, 0x0230, 0x0230, 0x0230, 0x0241,
			0x024d, 0x024d, 0x024d, 0x025f, 0x025f, 0x025f, 0x025f, 0x025f,
			0x025f, 0x026e, 0x026e, 0x027a, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286,
			// Entry C0 - FF
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x028e,
		},
	},
	{ // be
		"абхазскаяафрыкаансамхарскаяарагонскаяарабскаяасамскаяаварскаяаймараазерб" +
			"айджанскаябашкірскаябеларускаябалгарскаябенгальскаябрэтонскаябасній" +
			"скаякаталонскаячачэнскаячэшскаячувашскаявалійскаядацкаянямецкаягрэц" +
			"каяанглійскаяэсперантаіспанскаяэстонскаябаскскаяфарсіфінскаяфарэрск" +
			"аяфранцузскаяфрызскаяірландскаяшатландская гэльскаягалісійскаягуара" +
			"нігуярацііўрытхіндзіхарвацкаявенгерскаяармянскаяінтэрлінгваінданезі" +
			"йскаяінтэрлінгвеісландскаяітальянскаяяпонскаяяванскаягрузінскаяказа" +
			"хскаяканнадакарэйскаякурдскаялацінскаялінгалалаоскаялітоўскаялатышс" +
			"каямакедонскаямалаяламскаямангольскаямаратхімалайскаямальтыйскаянеп" +
			"альскаягаландскаянарвежская (нюнорск)нарвэская букмалправансальская" +
			"панджабіпольскаяпуштупартугальскаярумынскаярускаясанскрытсіндхісінг" +
			"альскаяславацкаяславенскаясамалійскаяалбанскаясербскаясуданскаяшвед" +
			"скаясуахілітамільскаятэлугутайскаятыгрыньятуркменскаятурэцкаятатарс" +
			"каяуйгурскаяукраінскаяурдуузбекскаяв’етнамскаяхосаідышкітайскаязулу" +
			"адыгейскаяакадзкаяалеуцкаястараанглійскаяарамейскаяастурыйскаябурац" +
			"каякопцкаястараэгіпецкаятагальскаястарафранцузскаястарагрэцкаяякуцк" +
			"аяклінгонневядомая мованямецкая (аўстр.)нямецкая (швейц.)англійская" +
			" (аўстрал.)англійская (канад.)англійская (ЗША)іспанская (лацінаамер." +
			")французская (канад.)французская (швейц.)фламандскаяпартугальская (б" +
			"разіл.)малдаўскаясербска-харвацкаяспрошчаная кітайскаятрадыцыйная к" +
			"ітайская",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0012, 0x0012, 0x0024, 0x0024, 0x0036, 0x004a,
			0x005a, 0x006a, 0x007a, 0x0086, 0x00a4, 0x00b8, 0x00cc, 0x00e0,
			0x00e0, 0x00e0, 0x00f6, 0x00f6, 0x010a, 0x011e, 0x0134, 0x0146,
			0x0146, 0x0146, 0x0146, 0x0154, 0x0154, 0x0166, 0x0178, 0x0184,
			0x0194, 0x0194, 0x0194, 0x0194, 0x01a2, 0x01b6, 0x01c8, 0x01da,
			0x01ec, 0x01fc, 0x0206, 0x0206, 0x0214, 0x0214, 0x0226, 0x023c,
			0x024c, 0x0260, 0x0287, 0x029d, 0x02ab, 0x02b9, 0x02b9, 0x02b9,
			0x02c3, 0x02cf, 0x02cf, 0x02e1, 0x02e1, 0x02f5, 0x0307, 0x0307,
			// Entry 40 - 7F
			0x031d, 0x0337, 0x034d, 0x034d, 0x034d, 0x034d, 0x034d, 0x0361,
			0x0377, 0x0377, 0x0387, 0x0397, 0x03ab, 0x03ab, 0x03ab, 0x03ab,
			0x03bd, 0x03bd, 0x03bd, 0x03cb, 0x03dd, 0x03dd, 0x03dd, 0x03ed,
			0x03ed, 0x03ed, 0x03ed, 0x03ff, 0x03ff, 0x03ff, 0x03ff, 0x040d,
			0x041b, 0x042d, 0x042d, 0x043f, 0x043f, 0x043f, 0x043f, 0x0455,
			0x046d, 0x0483, 0x0491, 0x04a3, 0x04b9, 0x04b9, 0x04b9, 0x04b9,
			0x04cd, 0x04cd, 0x04e1, 0x0506, 0x0525, 0x0525, 0x0525, 0x0525,
			0x0541, 0x0541, 0x0541, 0x0541, 0x0541, 0x0551, 0x0551, 0x0561,
			// Entry 80 - BF
			0x056b, 0x0585, 0x0585, 0x0585, 0x0585, 0x0597, 0x05a3, 0x05a3,
			0x05b3, 0x05b3, 0x05bf, 0x05bf, 0x05bf, 0x05d5, 0x05e7, 0x05fb,
			0x05fb, 0x05fb, 0x0611, 0x0623, 0x0633, 0x0633, 0x0633, 0x0645,
			0x0655, 0x0663, 0x0677, 0x0683, 0x0683, 0x0691, 0x06a1, 0x06b7,
			0x06b7, 0x06b7, 0x06c7, 0x06c7, 0x06d9, 0x06d9, 0x06eb, 0x06ff,
			0x0707, 0x0719, 0x0719, 0x0730, 0x0730, 0x0730, 0x0730, 0x0738,
			0x0740, 0x0740, 0x0740, 0x0752, 0x075a, 0x075a, 0x075a, 0x075a,
			0x076e, 0x076e, 0x076e, 0x076e, 0x076e, 0x077e, 0x077e, 0x078e,
			// Entry C0 - FF
			0x078e, 0x078e, 0x07ac, 0x07ac, 0x07c0, 0x07c0, 0x07c0, 0x07c0,
			0x07c0, 0x07c0, 0x07c0, 0x07c0, 0x07c0, 0x07c0, 0x07d6, 0x07d6,
			0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6,
			0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6,
			0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6,
			0x07d6, 0x07d6, 0x07d6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6,
			0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6,
			0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6,
			// Entry 100 - 13F
			0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4,
			0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4,
			0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x07f4, 0x0810,
			0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0824,
			0x0824, 0x0824, 0x0824, 0x0824, 0x0844, 0x0844, 0x0844, 0x0844,
			0x0844, 0x0844, 0x0844, 0x0844, 0x0844, 0x0844, 0x0844, 0x0844,
			0x0844, 0x0844, 0x0844, 0x0844, 0x0844, 0x0844, 0x0844, 0x0844,
			0x0844, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			// Entry 140 - 17F
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			// Entry 180 - 1BF
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			// Entry 1C0 - 1FF
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x085c, 0x086a, 0x086a, 0x086a, 0x086a,
			0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a,
			0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a,
			0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a,
			// Entry 200 - 23F
			0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a,
			0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a,
			0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x086a, 0x0878,
			0x0878, 0x0878, 0x0878, 0x0878, 0x0878, 0x0878, 0x0878, 0x0878,
			0x0878, 0x0878, 0x0878, 0x0878, 0x0878, 0x0878, 0x0878, 0x0878,
			0x0878, 0x0878, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893,
			0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893,
			0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893,
			// Entry 240 - 27F
			0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893, 0x0893,
			0x0893, 0x0893, 0x0893, 0x08b1, 0x08cf, 0x08f5, 0x0917, 0x0917,
			0x0934, 0x095e, 0x095e, 0x095e, 0x0982, 0x09a6, 0x09bc, 0x09e6,
			0x09e6, 0x09fa, 0x0a1b, 0x0a42, 0x0a6b,
		},
	},
	{ // bem
		"Ichi AkanIchi AmhariIchi ArabIchi BelarusIchi BulgarianiIchi BengaliIchi" +
			" ChekiIchi JemaniIchi GrikiIchi SunguIchi SpanishiIchi PesiaIchi Fre" +
			"nchiIchi HausaIchi HinduIchi HangarianIchi IndonesianiIchi IboIchi I" +
			"talianiIchi JapanisiIchi JavanisiIchi KhmerIchi KorianiIchi Maleshan" +
			"iIchi BurmaIchi NepaliIchi DachiIchi PunjabiIchi PolishiIchi Potogis" +
			"iIchi RomanianiIchi RusianiIchi RwandaIchi SomaliaIchi SwideniIchi T" +
			"amilIchi ThaiIchi TakishiIchi UkranianiIchi UruduIchi VietinamuIchi " +
			"YorubaIchi ChainisiIchi ZuluIchibemba",
		[]uint16{ // 219 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0014, 0x0014,
			0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x0029, 0x0038,
			0x0038, 0x0038, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0063, 0x006d, 0x006d, 0x007a,
			0x007a, 0x007a, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0090,
			0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x009a,
			0x009a, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00b2, 0x00b2, 0x00b2,
			// Entry 40 - 7F
			0x00b2, 0x00c2, 0x00c2, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
			0x00d7, 0x00d7, 0x00e4, 0x00f1, 0x00f1, 0x00f1, 0x00f1, 0x00f1,
			0x00f1, 0x00f1, 0x00fb, 0x00fb, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0115, 0x0115, 0x011f, 0x011f, 0x011f,
			0x012a, 0x012a, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0140, 0x0140, 0x014c,
			// Entry 80 - BF
			0x014c, 0x0159, 0x0159, 0x0159, 0x0159, 0x0167, 0x0173, 0x017e,
			0x017e, 0x017e, 0x017e, 0x017e, 0x017e, 0x017e, 0x017e, 0x017e,
			0x017e, 0x017e, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
			0x0196, 0x0196, 0x01a0, 0x01a0, 0x01a0, 0x01a9, 0x01a9, 0x01a9,
			0x01a9, 0x01a9, 0x01b5, 0x01b5, 0x01b5, 0x01b5, 0x01b5, 0x01c3,
			0x01cd, 0x01cd, 0x01cd, 0x01db, 0x01db, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01e6, 0x01e6, 0x01f3, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			// Entry C0 - FF
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x0205,
		},
	},
	{ // bez
		"HiakanHiamhariHiharabuHibelarusiHibulgariaHibanglaHichekiHijerumaniHigir" +
			"ikiHiingerezaHihispaniaHiajemiHifaransaHihausaHihindiHihungariHiindo" +
			"nesiaHiiboHiitalianoHijapaniHijavaHikambodiaHikoreaHimalesiaHiburmaH" +
			"inepaliHiholanziHipunjabiHipolandiHilenoHilomaniaHilusiHinyarwandaHi" +
			"somaliHiswidiHitamilHitailandHitulukiHiukraniaHiurduHivietinamuHiyor" +
			"ubaHichinaHizuluHibena",
		[]uint16{ // 221 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0055, 0x0055, 0x005f,
			0x005f, 0x005f, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x006f,
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x0076,
			0x0076, 0x007d, 0x007d, 0x007d, 0x007d, 0x0086, 0x0086, 0x0086,
			// Entry 40 - 7F
			0x0086, 0x0091, 0x0091, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0142,
			0x0148, 0x0148, 0x0148, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
			0x0153, 0x015b, 0x015b, 0x0162, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			// Entry C0 - FF
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x016e,
		},
	},
	{ // bg
		bgLangStr,
		bgLangIdx,
	},
	{ // bm
		"akankanamarikikanlarabukanbiyelorisikanbuligarikanbamanakanbɛngalikancɛk" +
			"ikanalimaɲikangɛrɛsikanangilɛkanesipaɲolkanperisanikantubabukanawusa" +
			"kaninidikanoŋirikanƐndonezikanigibokanitalikanzapɔnekanjavanekankamb" +
			"ojikankorekanmalɛzikanbirimanikannepalekanolandekanpɛnijabikanpolone" +
			"kanpɔritigalikanrumanikanirisikanruwandakansomalikansuwɛdikantamulik" +
			"antayikanturikikanukɛrɛnikanurudukanwiyɛtinamukanyorubakansiniwakanz" +
			"ulukan",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0011, 0x0011,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x0027, 0x0032,
			0x0032, 0x003b, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0064, 0x006e, 0x006e, 0x007a,
			0x007a, 0x007a, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x0096,
			0x0096, 0x009e, 0x009e, 0x009e, 0x009e, 0x00a7, 0x00a7, 0x00a7,
			// Entry 40 - 7F
			0x00a7, 0x00b3, 0x00b3, 0x00bb, 0x00bb, 0x00bb, 0x00bb, 0x00bb,
			0x00c3, 0x00c3, 0x00cd, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00f1, 0x00f1, 0x00fc, 0x00fc, 0x00fc,
			0x0105, 0x0105, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e,
			0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x011a, 0x011a, 0x0123,
			// Entry 80 - BF
			0x0123, 0x0131, 0x0131, 0x0131, 0x0131, 0x013a, 0x0142, 0x014c,
			0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c,
			0x014c, 0x014c, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155,
			0x015f, 0x015f, 0x0168, 0x0168, 0x0168, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0184,
			0x018c, 0x018c, 0x018c, 0x019a, 0x019a, 0x019a, 0x019a, 0x019a,
			0x019a, 0x01a3, 0x01a3, 0x01ac, 0x01b3,
		},
	},
	{ // bn
		bnLangStr,
		bnLangIdx,
	},
	{ // bo
		"བོད་སྐད་རྫོང་ཁཧིན་དིརི་པིན་སྐད་ནེ་པ་ལིཨུ་རུ་སུ་སྐད་རྒྱ་སྐད་",
		[]uint16{ // 180 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
			0x0018, 0x0018, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
			0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
			0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
			0x002a, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 40 - 7F
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d,
			0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d,
			0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d,
			0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d,
			0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			// Entry 80 - BF
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x00b1,
		},
	},
	{}, // bo-IN
	{ // br
		"afarabkhazegavestegafrikaansakanamharegaragonegarabegasamegavaraymaraaze" +
			"ribachkirbelarusegbulgaregbislamabambarabengalitibetanegbrezhonegbos" +
			"negkatalanegtchetchenegchamorrukorsegkritchekegslavoneg iliztchouvat" +
			"chkembraegdanegalamanegdivehidzongkhaewegresianegsaoznegesperantegsp" +
			"agnolegestonegeuskaregpersegfinnegfidjiegfaeroeggallegfrizeg ar Cʼho" +
			"rnôgiwerzhonegskoseggalizegguaranigujaratimanaveghaousahebraeghindih" +
			"iri motukroateghaitieghungaregarmenianeghererointerlinguaindonezegin" +
			"terlingueigboyieg Sichuaninupiaqidoislandegitalianeginuktitutjapaneg" +
			"javanegjorjianegkongokikuyukwanyamakazakkhmerkanaregkoreanegkanourik" +
			"ashmirikurdegkerneveuregkirgizlatinluksembourgeggandalimbourgeglinga" +
			"lalaoseglituanegluba-katangalatviegmalgachegmarshallmaorimakedonegma" +
			"layalammongolegmarathimalaysegmaltegbirmanegnauruegndebele an Norzhn" +
			"epalegndonganederlandegnorvegeg nynorsknorvegeg bokmålndebele ar Sun" +
			"avacʼhonyanjaokitanegojibwaoriyaosetegpunjabipalipolonegpachtoportug" +
			"alegkechuaegromañchegrundiroumanegrusianegkinyarwandasanskritegsarde" +
			"gsindhisámi an Norzhsangosinghalegslovakegslovenegsamoanshonasomalia" +
			"lbanegserbegswatisotho ar Susundanegsvedegswahilitamilegtelougoutadj" +
			"ikthaitigrignaturkmenegtswanatongaturkegtsongatatartahitianegouigour" +
			"egukrainegourdououzbekegvendavietnamegvolapükwallonegwolofxhosayiddi" +
			"shyoroubazhuangsinaegzoulouegachinegacoliadangmeadygeiegarabeg Tuniz" +
			"iaafrihiliaghemainouegakadegalabamaegaleouteggegegaltaieg ar Suhensa" +
			"oznegarameegaraoukanegarapahoarabeg Aljeriaarawakegarabeg Marokoarab" +
			"eg Egiptasuawadhiazeri ar Subaloutchibalinegbavariegbasaabedawiegbem" +
			"babenabhojpuribikolbinibrajbrahwegbodobouriatbugiblincaddokaribegceb" +
			"uanochibchamariegchoktawchipewyancherokeecheyennekurdeg soranikopteg" +
			"turkeg Krimeakachoubegdakotadargwadelawaredogribdinkadogriizelsorabe" +
			"gnederlandeg krenndyulaembuefikhenegiptegekajukelamegkrennsaoznegewo" +
			"ndofangfilipinegfonkrenncʼhalleghencʼhallegarpitanegfrizeg an Norzhf" +
			"rizeg ar Reterfrioulaneggagagaouzegsinaeg Gangayogbayagezeggilberteg" +
			"krennalamaneg uhelhenalamaneg uhelgorontalogoteggrebohencʼhresianega" +
			"lamaneg Suishaidasinaeg Hakkahawaieghiligaynonhmonguhelsorabegsinaeg" +
			" Xianhupaibanibibioingouchegyuzev-persegyuzev-arabegkarakalpakkabile" +
			"gkachinkambakabardegkabuverdianukhasikhotanegkimbundukonkanikosraekp" +
			"ellekaratchay-balkarkareliegkurukhkutenailadinolahndalambalezgilingu" +
			"a franca novaliguriegmongoloziluba-lulualuisenolundaluolushailuyiasi" +
			"naeg lennegelmagahimaithilimasaimokshamandarmendemorisegkrenniwerzho" +
			"negmanchoumanipurimohawkmarieg ar Cʼhornôgyezhoù liesmuskogierzasina" +
			"eg Min Nannapolitanegalamaneg izelnewariniasniuenogayhennorsegnovial" +
			"sotho an Norzhnewari klaselnyamwezinyankolenyoroosageturkeg otomanpa" +
			"ngasinanpahlavipampangapapiamentopalaupikardegalamaneg Pennsylvaniah" +
			"enbersegfenikianegpiemontegpontegpohnpeihenbruseghenbrovañsegrajasth" +
			"anirapanuirarotongaromagnolegromboromaniegaroumanegrwasandaweyakoute" +
			"garameeg ar Samaritanedsasaksantalisikiliegskotegsasaresegheniwerzho" +
			"negshanarabeg Tchadsidamosámi ar Susámi Luleåsámi Inarisámi Skoltson" +
			"inkesogdiegserersumeregkomoregsirieg klaselsiriegtoulouegterenotetum" +
			"tigreanegtivtokelauklingontinglittamachegnyasa tongatok pisintsimshi" +
			"antumbukatuvalutouvaoudmourtegougaritegumbunduyezh dianavvaiflandrez" +
			"eg ar c’hornôgvotyakegwalserwalamowaraywashosinaeg Wukalmoukyaoyapeg" +
			"kantonegzapotegBlisszelandegzenagatamacheg Maroko standartzunidiyezh" +
			"arabeg modernalamaneg Aostriaalamaneg uhel Suissaozneg Aostraliasaoz" +
			"neg Kanadasaozneg Breizh-Veursaozneg Amerikaspagnoleg Amerika latins" +
			"pagnoleg Europaspagnoleg Mecʼhikogalleg Kanadagalleg Suisflandrezegp" +
			"ortugaleg Brazilportugaleg Europamoldovegserb-kroategsinaeg eeunaets" +
			"inaeg hengounel",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000c, 0x0013, 0x001c, 0x0020, 0x0027, 0x002f,
			0x0035, 0x003b, 0x003f, 0x0045, 0x004a, 0x0051, 0x005a, 0x0062,
			0x0069, 0x0070, 0x0077, 0x0080, 0x0089, 0x008f, 0x0098, 0x00a3,
			0x00ab, 0x00b1, 0x00b4, 0x00bb, 0x00c8, 0x00d2, 0x00da, 0x00df,
			0x00e7, 0x00ed, 0x00f5, 0x00f8, 0x0101, 0x0108, 0x0112, 0x011b,
			0x0122, 0x012a, 0x0130, 0x0130, 0x0136, 0x013d, 0x0144, 0x014a,
			0x015e, 0x0168, 0x016e, 0x0175, 0x017c, 0x0184, 0x018b, 0x0191,
			0x0198, 0x019d, 0x01a6, 0x01ad, 0x01b4, 0x01bc, 0x01c6, 0x01cc,
			// Entry 40 - 7F
			0x01d7, 0x01e0, 0x01eb, 0x01ef, 0x01fb, 0x0202, 0x0205, 0x020d,
			0x0216, 0x021f, 0x0226, 0x022d, 0x0236, 0x023b, 0x0241, 0x0249,
			0x024e, 0x024e, 0x0253, 0x025a, 0x0262, 0x0269, 0x0271, 0x0277,
			0x0277, 0x0282, 0x0288, 0x028d, 0x029a, 0x029f, 0x02a9, 0x02b0,
			0x02b6, 0x02be, 0x02ca, 0x02d1, 0x02da, 0x02e2, 0x02e7, 0x02f0,
			0x02f9, 0x0301, 0x0308, 0x0310, 0x0316, 0x031e, 0x0325, 0x0335,
			0x033c, 0x0342, 0x034d, 0x035d, 0x036d, 0x037a, 0x0383, 0x0389,
			0x0391, 0x0397, 0x0397, 0x039c, 0x03a2, 0x03a9, 0x03ad, 0x03b4,
			// Entry 80 - BF
			0x03ba, 0x03c4, 0x03cc, 0x03d6, 0x03db, 0x03e3, 0x03eb, 0x03f6,
			0x0400, 0x0406, 0x040c, 0x041a, 0x041f, 0x0428, 0x0430, 0x0438,
			0x043e, 0x0443, 0x0449, 0x0450, 0x0456, 0x045b, 0x0466, 0x046e,
			0x0474, 0x047b, 0x0482, 0x048a, 0x0490, 0x0494, 0x049c, 0x04a5,
			0x04ab, 0x04b0, 0x04b6, 0x04bc, 0x04c1, 0x04cb, 0x04d4, 0x04dc,
			0x04e2, 0x04ea, 0x04ef, 0x04f8, 0x0500, 0x0508, 0x050d, 0x0512,
			0x0519, 0x0520, 0x0526, 0x052c, 0x0534, 0x053b, 0x0540, 0x0547,
			0x054f, 0x055d, 0x0565, 0x056a, 0x0571, 0x0577, 0x0580, 0x0588,
			// Entry C0 - FF
			0x058d, 0x059a, 0x05a4, 0x05a4, 0x05ab, 0x05b5, 0x05b5, 0x05bc,
			0x05ca, 0x05d2, 0x05df, 0x05eb, 0x05ee, 0x05ee, 0x05ee, 0x05ee,
			0x05f4, 0x05ff, 0x0608, 0x060f, 0x0617, 0x061c, 0x061c, 0x061c,
			0x061c, 0x0624, 0x0629, 0x0629, 0x062d, 0x062d, 0x062d, 0x0635,
			0x063a, 0x063e, 0x063e, 0x063e, 0x063e, 0x063e, 0x063e, 0x0642,
			0x0649, 0x064d, 0x064d, 0x0654, 0x0658, 0x0658, 0x065c, 0x065c,
			0x0661, 0x0668, 0x0668, 0x0668, 0x066f, 0x066f, 0x0676, 0x0676,
			0x0676, 0x067c, 0x067c, 0x0683, 0x068c, 0x0694, 0x069c, 0x06a9,
			// Entry 100 - 13F
			0x06af, 0x06af, 0x06bc, 0x06c5, 0x06cb, 0x06d1, 0x06d1, 0x06d9,
			0x06d9, 0x06df, 0x06e4, 0x06e4, 0x06e9, 0x06f4, 0x06f4, 0x06f4,
			0x0705, 0x0705, 0x070a, 0x070a, 0x070e, 0x0712, 0x0712, 0x071c,
			0x0722, 0x0728, 0x0734, 0x0734, 0x073a, 0x073a, 0x073e, 0x0747,
			0x0747, 0x074a, 0x074a, 0x0758, 0x0764, 0x076d, 0x077c, 0x078b,
			0x0795, 0x0797, 0x07a0, 0x07aa, 0x07ae, 0x07b3, 0x07b3, 0x07b8,
			0x07c1, 0x07c1, 0x07d3, 0x07e3, 0x07e3, 0x07e3, 0x07ec, 0x07f1,
			0x07f6, 0x0805, 0x0812, 0x0812, 0x0812, 0x0812, 0x0812, 0x0817,
			// Entry 140 - 17F
			0x0823, 0x082a, 0x082a, 0x0834, 0x0834, 0x0839, 0x0844, 0x084f,
			0x0853, 0x0857, 0x085d, 0x085d, 0x0866, 0x0866, 0x0866, 0x0866,
			0x0866, 0x0866, 0x0872, 0x087e, 0x087e, 0x0888, 0x088f, 0x0895,
			0x0895, 0x089a, 0x089a, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08ae,
			0x08ae, 0x08ae, 0x08ae, 0x08b3, 0x08bb, 0x08bb, 0x08bb, 0x08bb,
			0x08bb, 0x08bb, 0x08c3, 0x08c3, 0x08ca, 0x08d0, 0x08d6, 0x08e6,
			0x08e6, 0x08e6, 0x08ee, 0x08f4, 0x08f4, 0x08f4, 0x08f4, 0x08f4,
			0x08fb, 0x0901, 0x0901, 0x0907, 0x090c, 0x0911, 0x0923, 0x092b,
			// Entry 180 - 1BF
			0x092b, 0x092b, 0x092b, 0x0930, 0x0934, 0x0934, 0x093e, 0x0945,
			0x094a, 0x094d, 0x0953, 0x0958, 0x0967, 0x0967, 0x0967, 0x0967,
			0x096d, 0x0975, 0x0975, 0x0975, 0x097a, 0x097a, 0x0980, 0x0986,
			0x098b, 0x098b, 0x0992, 0x09a1, 0x09a1, 0x09a1, 0x09a1, 0x09a1,
			0x09a8, 0x09b0, 0x09b6, 0x09b6, 0x09ca, 0x09ca, 0x09d6, 0x09dd,
			0x09dd, 0x09dd, 0x09dd, 0x09dd, 0x09e1, 0x09e1, 0x09ef, 0x09fa,
			0x09fa, 0x0a07, 0x0a0d, 0x0a11, 0x0a15, 0x0a15, 0x0a15, 0x0a15,
			0x0a1a, 0x0a23, 0x0a29, 0x0a29, 0x0a37, 0x0a37, 0x0a44, 0x0a4c,
			// Entry 1C0 - 1FF
			0x0a54, 0x0a59, 0x0a59, 0x0a5e, 0x0a6b, 0x0a75, 0x0a7c, 0x0a84,
			0x0a8e, 0x0a93, 0x0a9b, 0x0ab0, 0x0ab0, 0x0ab9, 0x0ab9, 0x0ac3,
			0x0acc, 0x0ad2, 0x0ad9, 0x0ae2, 0x0aef, 0x0aef, 0x0aef, 0x0af9,
			0x0b00, 0x0b09, 0x0b13, 0x0b13, 0x0b18, 0x0b20, 0x0b20, 0x0b20,
			0x0b20, 0x0b29, 0x0b2c, 0x0b33, 0x0b3b, 0x0b51, 0x0b51, 0x0b56,
			0x0b5d, 0x0b5d, 0x0b5d, 0x0b5d, 0x0b65, 0x0b6b, 0x0b74, 0x0b74,
			0x0b74, 0x0b74, 0x0b74, 0x0b74, 0x0b81, 0x0b81, 0x0b81, 0x0b85,
			0x0b91, 0x0b97, 0x0b97, 0x0b97, 0x0ba2, 0x0bae, 0x0bb9, 0x0bc4,
			// Entry 200 - 23F
			0x0bcb, 0x0bd2, 0x0bd2, 0x0bd7, 0x0bd7, 0x0bd7, 0x0bd7, 0x0bd7,
			0x0bde, 0x0be5, 0x0be5, 0x0bf2, 0x0bf8, 0x0bf8, 0x0c00, 0x0c00,
			0x0c00, 0x0c06, 0x0c0b, 0x0c14, 0x0c17, 0x0c1e, 0x0c1e, 0x0c25,
			0x0c2c, 0x0c2c, 0x0c34, 0x0c3f, 0x0c48, 0x0c48, 0x0c48, 0x0c48,
			0x0c51, 0x0c51, 0x0c58, 0x0c5e, 0x0c5e, 0x0c63, 0x0c63, 0x0c6d,
			0x0c76, 0x0c7d, 0x0c88, 0x0c8b, 0x0c8b, 0x0c8b, 0x0ca4, 0x0ca4,
			0x0cac, 0x0cac, 0x0cac, 0x0cb2, 0x0cb8, 0x0cbd, 0x0cc2, 0x0cc2,
			0x0ccb, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd5, 0x0cda, 0x0cda, 0x0cda,
			// Entry 240 - 27F
			0x0cda, 0x0ce2, 0x0ce9, 0x0cee, 0x0cf6, 0x0cfc, 0x0d14, 0x0d18,
			0x0d1e, 0x0d1e, 0x0d2b, 0x0d3b, 0x0d4d, 0x0d5e, 0x0d6c, 0x0d7f,
			0x0d8e, 0x0da5, 0x0db5, 0x0dc8, 0x0dd5, 0x0de0, 0x0dea, 0x0dfb,
			0x0e0c, 0x0e14, 0x0e20, 0x0e2e, 0x0e3e,
		},
	},
	{ // brx
		"अब्खाज़ियन्अवस्तन्अफ्रीकीअकनअम्हारिक्आर्गोनीअरबीअसामीअवारिक्आयमाराअज़रबै" +
			"जानीबशख़िर्बैलोरूसियन्बल्गैरियन्बिस्लामाबांबाराबंगलातिब्बतीब्रटोंब" +
			"ोस्नियाईकातालान्चेचेन्चामोरोकोर्सीकन्क्रीचेक्चर्च स्लाविक्चुवाश्वै" +
			"ल्श्डैनीश्ज़र्मनदीवेहीभुटानीएवेग्रीकअंग्रेज़ीएस्पेरान्तोस्पैनिशऐस्" +
			"टोनियन्बास्क्फार्सीफुलाह्फिनिश्फ़ीजीफिरोज़ीफ्रांसीसीपश्चीमी फ्रीज़" +
			"ियन्आईरिशस्कॉट्स् गैलिक्गैलिशियन्गुआरानीगुजरातीमैंक्सहउसाहिब्रुहिं" +
			"दीहीरी मोटुक्रोएशन्हाईशीयन्हंगैरीयन्अरमेनियन्हेरेरोईन्टरलिंग्वाइन्" +
			"डोनेशियन्ईन्टरलिंग्वेईग्बोसीचुआन् यीइनुपियाक़्ईडोआईस्लैंडिक्ईटालिय" +
			"न्इनूक्टीटूत्जापानीजावानीसजॉर्जियन्कॉंगोकिकुयुकुआनयामाक़ज़ाख़्कलाल" +
			"ीसुतख्मेरकन्नड्कोरीयन्कनुरीकश्मिरीकुर्दीकोमीकौर्नवॉलीकिरग़ीज़्लैटी" +
			"न्लुक्समबुर्गीगांडालींबुर्गीलिंगालालाओसीयन्लिथुआनियन्लुबा कटांगाला" +
			"टवियन् (लैट्टीश)मालागासीमार्शलीमाओरीमैसेडोनियन्मलयालममोंगोलियनमराठ" +
			"ीमलायमालटीज़्बर्मीनाऊरूउत्तर न्दबेलेनेपालीन्डोंगाडच्नॉर्वेजियन् नी" +
			"नॉर्स्क्नोर्वेगी बोकमालदक्षिणी न्दबेलेनावाहोन्यानजाओक्सीतानओहीबवाओ" +
			"रोमो (अफ़ान)उड़ियाओस्सेटीपंजाबीपालीपोलिशपख़्तुपुर्तगालीक्वेचुआरेह्" +
			"टो-रोमान्सकिरून्दीरूमानीयन्रुसीकिन्यारुआण्डासंस्कृत्सार्दीनीसिंधीउ" +
			"त्तरी सामीसांग्रोसींहालास्लोवाक्स्लोवेनियन्सामोअनशोनासोमालीआल्बेनि" +
			"यन्सर्बियन्स्वाटिसुन्दानीस्वीडिशस्वाहिलीतमिळतेलुगुताजिक्थाईतिग्रीन" +
			"्यातुर्कमेनत्स्वानाटॉंगातुर्कीसोंगाटाटर्टाहिटिउईग़ुरयूक्रेनियन्ऊर्" +
			"दुउज़बेक्वेंडावियेतनामीवोलापोकवालुनवोलोफख़ोसायीद्दीशयोरूबाज़ुआंगची" +
			"नीज़ुलूअचेहनीअकोलीअडांगमेअडीगेअफ्रीहीलीऐनूअकाडिनीअलुटपुरानी अंग्रे" +
			"ज़ीअंगीकाअरामाईकअरापाहोअरावाकअवधीबलूचीबालिनीबास्क़्बेजाबेंबाभोजपुर" +
			"ीबिकोल्बिनीसीकसीकाब्रजबड़ोबुरियातबुगीनीब्लीनकाद्दौकारीब्आत्समचेबुआ" +
			"नोचीबचाचगताईचुकेसेमारीचीनूक् जार्गन्चौक्टोचिपेवियान्चीरोकीशायान्कॉ" +
			"प्टीक्तुर्की क्रिमियाकाशुबियान्डकौटादर्गवादलावार्स्लेव्डोगरीब्डींग" +
			"काडोगरीसोर्बियन्डुआलामध्य डचद्युआलाएफीक्प्राचीन मिस्रीएकाजुकएलामीम" +
			"ध्य अंग्रेज़ीएवौंडोफाँग्फिलिपिनोफोनमध्य फ्रांसीसीपुरानी फ्रांसीसीउ" +
			"त्तरी फ्रीज़ियन्पूर्वी फ्रीज़ियन्फ्रीउलीअन्गागायोग्बायागीज़्गीलबर्" +
			"टीमध्य उच्चस्तरी जर्मनपुरानी उच्चस्तरी जर्मनगाँडीगोरंटालोगॉथिकग्रे" +
			"बोप्राचीन यूनानीस्वीस जर्मनग्वीचलीनहईडाहवाईअनहीलीगैनोनहीत्तीह्मौंग" +
			"ऊपरी सौर्बियनहूपाईबान्ईलोकोईंगुषलोजबानयहुदी फ़ारसीयहुदी अरबीकारा क" +
			"लपककाबील्कचीन्जुकंबाकावीकबार्डी भाषात्याप्कोरोख़ासीख़ोतानीकींबुंडु" +
			"कोंकणीकोस्राईयन्क्पेलेकराचय् बलकार्करेलियन्कुरुख़्कुमीक्कुतेनाईलाड" +
			"़ीनोलाह्डांलांबालेज़गीयानमोंगोलोज़ीलुबा लुलुआलुईसेनोलुंडालुओलुशाईम" +
			"ादुरीमघीमैथीलीमक्सरमांडींगोमसाईमोक्षामंदारमेंदेमध्य आईरीश भाषामीकम" +
			"ाकमिनंगकाबाउमांचुमणीपुरीमोहोकमोस्सीक्रीकमीरांडीमारवाड़ीऐर्ज़ियानेआ" +
			"पोलिटननीजी स्तरिय जर्मननेवारीनियासनियुइआननोगाईपुरानी नॉर्स्न्गकोपु" +
			"रानी नेवारीन्यामवेज़ीन्यानकोलेन्यौरोन्ज़ीमाओसेजतुर्की ओटोमानपांगास" +
			"ीननपहलवीपंपंगापापीआमेन्तोपालाऊपुरानी फ़ारसीफीनीसीपोहनपीपुरानी प्रो" +
			"वाँसालराजस्थानीरापानुईरारोटोंगारुमानीआरोमानीसंडावेयकुट्समारीती आरा" +
			"माईक़सासकसंतालीसीसीलीअनस्कॉटसेलकुपपुरानी आईरीशशानसीदामोपश्चीमी साम" +
			"ीलुले सामीईनारी सामीस्कोल्ट् सामीसोनिंगकेसोगडीयनस्रनान् टॉंगोसेरेर" +
			"सुकुमासुसुसुमेरिअनपारंपरीक सिरिआकसिरिआकतीमनेतेरेनोतेतुमटीग्रेटीव्ट" +
			"ोकेलौक्लींगदनट्लिंगीततमाशेकन्यासा टॉंगातोक पिसीनत्सीमशीआन्टुँबुकाट" +
			"ुवालुटुवीउड़मुर्तउगारितीउंबुंडुरुटवाईवोटीकवालामोवारयवाशोकालमीकयाओय" +
			"ापीज़ज़ापोतेकब्लीस चिन्हज़ेनागाज़ुनीरिक्तज़ाज़ाजर्मन (ऑस्ट्रिया)उच" +
			"्च स्तरिय स्वीस जर्मनअंग्रेज़ी (ऑस्ट्रेलिया का)अंग्रेज़ी (कनाडाई)अ" +
			"ंग्रेजी (ब्रिटिश)अंग्रेज़ी (अमरिकी)लैटिन अमरिकी स्पैनिशईवेरियाई स्" +
			"पैनिशफ्रांसीसी (कनाडाई)फ्रांसीसी (स्वीस)फ्लेमीमोल्डेवियन्सर्बो-क्र" +
			"ोएशन्चीनी (सरलीकृत)चीनी (पारम्परिक)",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0021, 0x0036, 0x004b, 0x0054, 0x006f, 0x0084,
			0x0090, 0x009f, 0x00b4, 0x00c6, 0x00e4, 0x00f9, 0x011a, 0x0138,
			0x0150, 0x0165, 0x0174, 0x0189, 0x019b, 0x01b6, 0x01ce, 0x01e0,
			0x01f2, 0x020d, 0x0219, 0x0225, 0x024a, 0x025c, 0x026e, 0x0280,
			0x0292, 0x02a4, 0x02b6, 0x02bf, 0x02ce, 0x02e9, 0x030a, 0x031f,
			0x033d, 0x034f, 0x0361, 0x0373, 0x0385, 0x0394, 0x03a9, 0x03c4,
			0x03f8, 0x0407, 0x0432, 0x044d, 0x0462, 0x0477, 0x0489, 0x0495,
			0x04a7, 0x04b6, 0x04cf, 0x04e7, 0x04ff, 0x051a, 0x0535, 0x0547,
			// Entry 40 - 7F
			0x056b, 0x058f, 0x05b3, 0x05c2, 0x05de, 0x05fc, 0x0605, 0x0626,
			0x063e, 0x065f, 0x0671, 0x0686, 0x06a1, 0x06b0, 0x06c2, 0x06da,
			0x06f2, 0x070a, 0x0719, 0x072b, 0x0740, 0x074f, 0x0764, 0x0776,
			0x0782, 0x079d, 0x07b8, 0x07ca, 0x07ee, 0x07fd, 0x0818, 0x082d,
			0x0845, 0x0863, 0x0882, 0x08b2, 0x08ca, 0x08df, 0x08ee, 0x090f,
			0x0921, 0x093c, 0x094b, 0x0957, 0x096f, 0x097e, 0x098d, 0x09b2,
			0x09c4, 0x09d9, 0x09e2, 0x0a22, 0x0a4d, 0x0a78, 0x0a8a, 0x0a9f,
			0x0ab7, 0x0ac9, 0x0aea, 0x0afc, 0x0b11, 0x0b23, 0x0b2f, 0x0b3e,
			// Entry 80 - BF
			0x0b50, 0x0b6b, 0x0b80, 0x0ba8, 0x0bc0, 0x0bdb, 0x0be7, 0x0c0e,
			0x0c26, 0x0c3e, 0x0c4d, 0x0c6c, 0x0c81, 0x0c96, 0x0cae, 0x0ccf,
			0x0ce1, 0x0ced, 0x0cff, 0x0d1d, 0x0d35, 0x0d47, 0x0d47, 0x0d5f,
			0x0d74, 0x0d8c, 0x0d98, 0x0daa, 0x0dbc, 0x0dc5, 0x0de3, 0x0dfb,
			0x0e13, 0x0e22, 0x0e34, 0x0e43, 0x0e52, 0x0e64, 0x0e76, 0x0e97,
			0x0ea6, 0x0ebb, 0x0eca, 0x0ee5, 0x0efa, 0x0f09, 0x0f18, 0x0f27,
			0x0f3c, 0x0f4e, 0x0f60, 0x0f6c, 0x0f7b, 0x0f8d, 0x0f9c, 0x0fb1,
			0x0fc0, 0x0fc0, 0x0fdb, 0x0fdb, 0x0fe4, 0x0ff9, 0x0ff9, 0x1005,
			// Entry C0 - FF
			0x1005, 0x1005, 0x1033, 0x1045, 0x105a, 0x105a, 0x105a, 0x106f,
			0x106f, 0x1081, 0x1081, 0x1081, 0x1081, 0x1081, 0x1081, 0x1081,
			0x108d, 0x108d, 0x109c, 0x10ae, 0x10ae, 0x10c3, 0x10c3, 0x10c3,
			0x10c3, 0x10cf, 0x10de, 0x10de, 0x10de, 0x10de, 0x10de, 0x10f3,
			0x1105, 0x1111, 0x1111, 0x1111, 0x1126, 0x1126, 0x1126, 0x1132,
			0x1132, 0x113e, 0x113e, 0x1153, 0x1165, 0x1165, 0x1174, 0x1174,
			0x1186, 0x1198, 0x1198, 0x11a7, 0x11bc, 0x11bc, 0x11cb, 0x11da,
			0x11ec, 0x11f8, 0x1220, 0x1232, 0x1250, 0x1262, 0x1274, 0x1274,
			// Entry 100 - 13F
			0x128c, 0x128c, 0x12b7, 0x12d5, 0x12e4, 0x12f6, 0x12f6, 0x130b,
			0x131d, 0x1332, 0x1344, 0x1344, 0x1353, 0x136e, 0x136e, 0x137d,
			0x1390, 0x1390, 0x13a5, 0x13a5, 0x13a5, 0x13b4, 0x13b4, 0x13dc,
			0x13ee, 0x13fd, 0x1425, 0x1425, 0x1437, 0x1437, 0x1446, 0x145e,
			0x145e, 0x1467, 0x1467, 0x148f, 0x14bd, 0x14bd, 0x14ee, 0x151f,
			0x153d, 0x1543, 0x1543, 0x1543, 0x154f, 0x1561, 0x1561, 0x1570,
			0x1588, 0x1588, 0x15c0, 0x15fe, 0x15fe, 0x160d, 0x1625, 0x1634,
			0x1646, 0x166e, 0x168d, 0x168d, 0x168d, 0x168d, 0x16a5, 0x16b1,
			// Entry 140 - 17F
			0x16b1, 0x16c3, 0x16c3, 0x16de, 0x16f0, 0x1702, 0x1727, 0x1727,
			0x1733, 0x1742, 0x1742, 0x1751, 0x1760, 0x1760, 0x1760, 0x1772,
			0x1772, 0x1772, 0x1794, 0x17b0, 0x17b0, 0x17c9, 0x17db, 0x17ea,
			0x17f0, 0x17fc, 0x1808, 0x182a, 0x182a, 0x183c, 0x183c, 0x183c,
			0x183c, 0x1848, 0x1848, 0x1857, 0x186c, 0x186c, 0x186c, 0x186c,
			0x186c, 0x186c, 0x1884, 0x1884, 0x1896, 0x18b4, 0x18c6, 0x18eb,
			0x18eb, 0x18eb, 0x1903, 0x1918, 0x1918, 0x1918, 0x1918, 0x192a,
			0x193f, 0x1954, 0x1954, 0x1969, 0x1978, 0x1993, 0x1993, 0x1993,
			// Entry 180 - 1BF
			0x1993, 0x1993, 0x1993, 0x19a2, 0x19b1, 0x19b1, 0x19cd, 0x19e2,
			0x19f1, 0x19fa, 0x1a09, 0x1a09, 0x1a09, 0x1a09, 0x1a1b, 0x1a1b,
			0x1a24, 0x1a36, 0x1a45, 0x1a5d, 0x1a69, 0x1a69, 0x1a7b, 0x1a8a,
			0x1a99, 0x1a99, 0x1a99, 0x1ac2, 0x1ac2, 0x1ac2, 0x1ad4, 0x1af2,
			0x1b01, 0x1b16, 0x1b25, 0x1b37, 0x1b37, 0x1b37, 0x1b37, 0x1b46,
			0x1b5b, 0x1b73, 0x1b73, 0x1b73, 0x1b8b, 0x1b8b, 0x1b8b, 0x1ba6,
			0x1ba6, 0x1bd5, 0x1be7, 0x1bf6, 0x1c0b, 0x1c0b, 0x1c0b, 0x1c0b,
			0x1c1a, 0x1c3f, 0x1c3f, 0x1c4e, 0x1c4e, 0x1c4e, 0x1c73, 0x1c91,
			// Entry 1C0 - 1FF
			0x1cac, 0x1cbe, 0x1cd3, 0x1cdf, 0x1d04, 0x1d1f, 0x1d2e, 0x1d40,
			0x1d61, 0x1d70, 0x1d70, 0x1d70, 0x1d70, 0x1d95, 0x1d95, 0x1da7,
			0x1da7, 0x1da7, 0x1db9, 0x1db9, 0x1dea, 0x1dea, 0x1dea, 0x1e05,
			0x1e1a, 0x1e35, 0x1e35, 0x1e35, 0x1e35, 0x1e47, 0x1e47, 0x1e47,
			0x1e47, 0x1e5c, 0x1e5c, 0x1e6e, 0x1e7d, 0x1eab, 0x1eab, 0x1eb7,
			0x1ec9, 0x1ec9, 0x1ec9, 0x1ec9, 0x1ee1, 0x1ef0, 0x1ef0, 0x1ef0,
			0x1ef0, 0x1ef0, 0x1f02, 0x1f02, 0x1f24, 0x1f24, 0x1f24, 0x1f2d,
			0x1f2d, 0x1f3f, 0x1f3f, 0x1f3f, 0x1f61, 0x1f7a, 0x1f96, 0x1fbb,
			// Entry 200 - 23F
			0x1fd3, 0x1fe8, 0x200d, 0x201c, 0x201c, 0x201c, 0x202e, 0x203a,
			0x2052, 0x2052, 0x2052, 0x207d, 0x208f, 0x208f, 0x208f, 0x209e,
			0x209e, 0x20b0, 0x20bf, 0x20d1, 0x20dd, 0x20ef, 0x20ef, 0x2107,
			0x211f, 0x211f, 0x2131, 0x2153, 0x216c, 0x216c, 0x216c, 0x216c,
			0x218a, 0x218a, 0x219f, 0x21b1, 0x21b1, 0x21bd, 0x21bd, 0x21d5,
			0x21ea, 0x21ff, 0x2208, 0x2211, 0x2211, 0x2211, 0x2211, 0x2211,
			0x2220, 0x2220, 0x2220, 0x2220, 0x2232, 0x223e, 0x224a, 0x224a,
			0x224a, 0x225c, 0x225c, 0x225c, 0x2265, 0x2277, 0x2277, 0x2277,
			// Entry 240 - 27F
			0x2277, 0x2277, 0x228f, 0x22ae, 0x22ae, 0x22c3, 0x22c3, 0x22d2,
			0x22e1, 0x22f3, 0x22f3, 0x2320, 0x235f, 0x23a5, 0x23d5, 0x2405,
			0x2435, 0x246d, 0x249b, 0x249b, 0x24cb, 0x24f8, 0x250a, 0x250a,
			0x250a, 0x252b, 0x2553, 0x2577, 0x25a1,
		},
	},
	{ // bs
		"afarskiabhazijskiavestanskiafrikanerskiakanamharskiaragonežanskiarapskia" +
			"semijskiavarskiajmaraazerbejdžanskibaškirskibjeloruskibugarskibislam" +
			"abambarabengalskitibetanskibretonskibosanskikatalonskičečenskičamoro" +
			"korzikanskikričeškistaroslovenskičuvaškicydanskinjemačkidivehijskidž" +
			"ongaevegrčkiengleskiesperantošpanskiestonskibaskijskiperzijskifulahf" +
			"inskifidžijskifarskifrancuskifrizijskiirskiškotski galskigalskigvara" +
			"nigudžaratimankshausahebrejskihindihiri motuhrvatskihaićanskimađarsk" +
			"ijermenskihererointerlingvaindonezijskiinterlingveigbosičuan jiinupi" +
			"akidoislandskiitalijanskiinuktitutjapanskijavanskigruzijskikongokiku" +
			"jukuanjamakazačkikalalisutskikmerskikanadakorejskikanurikašmirikurds" +
			"kikomikorniškikirgiskilatinskiluksemburškigandalimburgišlingalalaošk" +
			"ilitvanskiluba-katangaletonskimalagazijskimaršalskimaorskimakedonski" +
			"malajalammongolskimaratimalajskimalteškiburmanskinaurusjeverni ndebe" +
			"lenepalskindongaholandskinorveški njorsknorveški bokmaljužni ndebele" +
			"navahonjanjaprovansalskiojibvaoromoorijskiosetskipandžabskipalipoljs" +
			"kipaštunskiportugalskikvenčareto-romanskirundirumunskiruskikinjarvan" +
			"dasanskritsardinijskisindisjeverni samisangosingaleskislovačkisloven" +
			"ačkisamoanskišonasomalskialbanskisrpskisvatisesotosudanskišvedskisva" +
			"hilitamilskitelugutadžičkitajlandskitigrinjaturkmenskitsvanatongatur" +
			"skitsongatatarskitahićanskiujgurskiukrajinskiurduuzbečkivendavijetna" +
			"mskivolapükvalunvolofkosajidišjorubanskizuangkineskizuluačineskiakol" +
			"iadangmejskiadigejskiafrihiliaghemainuakadijskialjutjužni altaistaro" +
			"engleskiangikaarmajskiaraukanskiarapahoaravakasuasturijskiavadhibalu" +
			"čibalinezijskibasabejabembabenabojpuribikolbinisiksikabrajbodoburia" +
			"tbuginežanskiiblinkadokaripskiatsamcebuanočigačibčačagataičukeskimar" +
			"ičinukskičoktavskičipvijanskičirokičejenskisoranski kurdskikoptskikr" +
			"imeanski turskikašubijanskidakotadargvataitadelaverslavskidogribdink" +
			"azarmadogridonjolužičkosrpskidualasrednji holandskijola-fonyiđulaemb" +
			"uefikskistaroegipatskiekajukelamitskisrednji engleskievondofangfilip" +
			"inskifonsrednji francuskistarofrancuskiseverno-frizijskiistočni friz" +
			"ijskifriulijskigagagauškigajogbajadžizgilbertškisrednji visoki nemač" +
			"kistaronemačkigondigorontalogotskigrebostarogrčkišvajcarski njemački" +
			"gusiihaidahavajskihiligajnonhititehmonggornjolužičkosrpskihupaibanil" +
			"okoingušetskilojbanngombamachamejudeo-persijskijudeo-arapskikara-kal" +
			"paškikabilekačinžjukambakavikabardijskitjapmakondezelenortskikorokas" +
			"ikotanizijskikoyra chiinikalenjinkimbundukomi-permjačkikonkanikosrea" +
			"nskikpelekaračaj-balkarkarelijskikurukhshambalabafiakumikkutenailadi" +
			"nolangilandalambalezgianlakotamongoloziluba-lulualuisenolundaluoluša" +
			"iluyiamadureškimagahimaitilimakasarmandingomasaimokšamandarmendemeru" +
			"mauricijski kreolskisrednji irskimakhuwa-meettometa’mikmakminangkaba" +
			"umančumanipurimahavskimosimundangviše jezikakriškimirandeškimarvarie" +
			"rzijaneapolitanskinamaniski nemačkinevariniasniueankwasionogaistari " +
			"norskinkoseverni sotonuerklasični nevarinjamvezinjankolenjoronzimaos" +
			"ageotomanski turskipangasinskipahlavipampangapapiamentopalauanskista" +
			"ropersijskifeničanskiponpejskistaroprovansalskikičerađastanirapanuir" +
			"arotonganromboromaniaromanijskiruasandavejakutsamaritanski aramejski" +
			"samburusasaksantalisangusicilijanskiškotskisenaselkapkojraboro senis" +
			"taroirskitahelhitšansidamojužni samilule samiinari samiskoltski jezi" +
			"ksoninkesodžijenskisrananski tongoserersukumasususumerskikongoanski " +
			"swahiliklasični sirijskisirijskitimnetesoterenotetumtigretivtokelauk" +
			"lingonskitlingittamašeknjasa tongatok pisintsimšiantumbukatuvalutasa" +
			"vaktuvinijskimarokanski tamazigtudmurtugaritskiumbundurunvaivotskivu" +
			"njovalamovarejvašokalmiksogajaojapeškizapotečkiblisimbolizenagastand" +
			"ardni marokanski tamazigtzunibez lingvističkog sadržajazazamoderni s" +
			"tandardni arapskiaustrijski njemačkigornjonjemački (švicarski)austra" +
			"lski engleskikanadski engleskibritanski engleskiamerički engleskilat" +
			"inoamerički španskievropski španskimeksički španskikanadski francusk" +
			"išvajcarski francuskiflamanskimoldavskisrpskohrvatskikineski (pojedn" +
			"ostavljeni)kineski (tradicionalni)",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0007, 0x0011, 0x001b, 0x0027, 0x002b, 0x0033, 0x0041,
			0x0048, 0x0051, 0x0058, 0x005e, 0x006d, 0x0077, 0x0081, 0x0089,
			0x0090, 0x0097, 0x00a0, 0x00aa, 0x00b3, 0x00bb, 0x00c5, 0x00cf,
			0x00d6, 0x00e1, 0x00e4, 0x00eb, 0x00f9, 0x0102, 0x0104, 0x010a,
			0x0113, 0x011d, 0x0124, 0x0127, 0x012d, 0x0135, 0x013e, 0x0146,
			0x014e, 0x0157, 0x0160, 0x0165, 0x016b, 0x0175, 0x017b, 0x0184,
			0x018d, 0x0192, 0x01a1, 0x01a7, 0x01ae, 0x01b8, 0x01bd, 0x01c2,
			0x01cb, 0x01d0, 0x01d9, 0x01e1, 0x01eb, 0x01f4, 0x01fd, 0x0203,
			// Entry 40 - 7F
			0x020e, 0x021a, 0x0225, 0x0229, 0x0233, 0x023a, 0x023d, 0x0246,
			0x0251, 0x025a, 0x0262, 0x026a, 0x0273, 0x0278, 0x027e, 0x0286,
			0x028e, 0x029a, 0x02a1, 0x02a7, 0x02af, 0x02b5, 0x02bd, 0x02c4,
			0x02c8, 0x02d1, 0x02d9, 0x02e1, 0x02ee, 0x02f3, 0x02fd, 0x0304,
			0x030b, 0x0314, 0x0320, 0x0328, 0x0334, 0x033e, 0x0345, 0x034f,
			0x0358, 0x0361, 0x0367, 0x036f, 0x0378, 0x0381, 0x0386, 0x0396,
			0x039e, 0x03a4, 0x03ad, 0x03bd, 0x03cd, 0x03db, 0x03e1, 0x03e7,
			0x03f3, 0x03f9, 0x03fe, 0x0405, 0x040c, 0x0417, 0x041b, 0x0422,
			// Entry 80 - BF
			0x042c, 0x0437, 0x043e, 0x044b, 0x0450, 0x0458, 0x045d, 0x0468,
			0x0470, 0x047b, 0x0480, 0x048d, 0x0492, 0x049c, 0x04a5, 0x04b0,
			0x04b9, 0x04be, 0x04c6, 0x04ce, 0x04d4, 0x04d9, 0x04df, 0x04e7,
			0x04ef, 0x04f6, 0x04fe, 0x0504, 0x050e, 0x0518, 0x0520, 0x052a,
			0x0530, 0x0535, 0x053b, 0x0541, 0x0549, 0x0554, 0x055c, 0x0566,
			0x056a, 0x0572, 0x0577, 0x0582, 0x058a, 0x058f, 0x0594, 0x0598,
			0x059e, 0x05a8, 0x05ad, 0x05b4, 0x05b8, 0x05c1, 0x05c6, 0x05d1,
			0x05da, 0x05da, 0x05e2, 0x05e7, 0x05eb, 0x05f4, 0x05f4, 0x05f9,
			// Entry C0 - FF
			0x05f9, 0x0605, 0x0612, 0x0618, 0x0620, 0x062a, 0x062a, 0x0631,
			0x0631, 0x0637, 0x0637, 0x0637, 0x063a, 0x063a, 0x0644, 0x0644,
			0x064a, 0x064a, 0x0651, 0x065d, 0x065d, 0x0661, 0x0661, 0x0661,
			0x0661, 0x0665, 0x066a, 0x066a, 0x066e, 0x066e, 0x066e, 0x0675,
			0x067a, 0x067e, 0x067e, 0x067e, 0x0685, 0x0685, 0x0685, 0x0689,
			0x0689, 0x068d, 0x068d, 0x0693, 0x06a1, 0x06a1, 0x06a5, 0x06a5,
			0x06a9, 0x06b1, 0x06b1, 0x06b6, 0x06bd, 0x06c2, 0x06c9, 0x06d1,
			0x06d9, 0x06dd, 0x06e6, 0x06f0, 0x06fc, 0x0703, 0x070c, 0x071c,
			// Entry 100 - 13F
			0x0723, 0x0723, 0x0734, 0x0741, 0x0747, 0x074d, 0x0752, 0x0759,
			0x0760, 0x0766, 0x076b, 0x0770, 0x0775, 0x0789, 0x0789, 0x078e,
			0x079f, 0x07a9, 0x07ae, 0x07ae, 0x07b2, 0x07b9, 0x07b9, 0x07c7,
			0x07cd, 0x07d6, 0x07e6, 0x07e6, 0x07ec, 0x07ec, 0x07f0, 0x07fa,
			0x07fa, 0x07fd, 0x07fd, 0x080e, 0x081c, 0x081c, 0x082d, 0x083f,
			0x0849, 0x084b, 0x0854, 0x0854, 0x0858, 0x085d, 0x085d, 0x0862,
			0x086d, 0x086d, 0x0884, 0x0891, 0x0891, 0x0896, 0x089f, 0x08a5,
			0x08aa, 0x08b5, 0x08ca, 0x08ca, 0x08ca, 0x08cf, 0x08cf, 0x08d4,
			// Entry 140 - 17F
			0x08d4, 0x08dc, 0x08dc, 0x08e6, 0x08ec, 0x08f1, 0x0906, 0x0906,
			0x090a, 0x090e, 0x090e, 0x0913, 0x091e, 0x091e, 0x091e, 0x0924,
			0x092a, 0x0931, 0x0940, 0x094d, 0x094d, 0x095b, 0x0961, 0x0967,
			0x096b, 0x0970, 0x0974, 0x097f, 0x097f, 0x0983, 0x098a, 0x0995,
			0x0995, 0x0999, 0x0999, 0x099d, 0x09a9, 0x09b5, 0x09b5, 0x09b5,
			0x09b5, 0x09bd, 0x09c5, 0x09d4, 0x09db, 0x09e5, 0x09ea, 0x09f9,
			0x09f9, 0x09f9, 0x0a03, 0x0a09, 0x0a11, 0x0a16, 0x0a16, 0x0a1b,
			0x0a22, 0x0a28, 0x0a2d, 0x0a32, 0x0a37, 0x0a3e, 0x0a3e, 0x0a3e,
			// Entry 180 - 1BF
			0x0a3e, 0x0a44, 0x0a44, 0x0a49, 0x0a4d, 0x0a4d, 0x0a57, 0x0a5e,
			0x0a63, 0x0a66, 0x0a6c, 0x0a71, 0x0a71, 0x0a71, 0x0a7b, 0x0a7b,
			0x0a81, 0x0a88, 0x0a8f, 0x0a97, 0x0a9c, 0x0a9c, 0x0aa2, 0x0aa8,
			0x0aad, 0x0ab1, 0x0ac5, 0x0ad2, 0x0ae0, 0x0ae7, 0x0aed, 0x0af8,
			0x0afe, 0x0b06, 0x0b0e, 0x0b12, 0x0b12, 0x0b19, 0x0b25, 0x0b2c,
			0x0b37, 0x0b3e, 0x0b3e, 0x0b3e, 0x0b44, 0x0b44, 0x0b44, 0x0b51,
			0x0b55, 0x0b63, 0x0b69, 0x0b6d, 0x0b73, 0x0b73, 0x0b79, 0x0b79,
			0x0b7e, 0x0b8a, 0x0b8a, 0x0b8d, 0x0b99, 0x0b9d, 0x0bad, 0x0bb5,
			// Entry 1C0 - 1FF
			0x0bbd, 0x0bc2, 0x0bc7, 0x0bcc, 0x0bdc, 0x0be7, 0x0bee, 0x0bf6,
			0x0c00, 0x0c0a, 0x0c0a, 0x0c0a, 0x0c0a, 0x0c18, 0x0c18, 0x0c23,
			0x0c23, 0x0c23, 0x0c2c, 0x0c2c, 0x0c3d, 0x0c42, 0x0c42, 0x0c4c,
			0x0c53, 0x0c5d, 0x0c5d, 0x0c5d, 0x0c62, 0x0c68, 0x0c68, 0x0c68,
			0x0c68, 0x0c73, 0x0c76, 0x0c7d, 0x0c82, 0x0c98, 0x0c9f, 0x0ca4,
			0x0cab, 0x0cab, 0x0cab, 0x0cb0, 0x0cbc, 0x0cc4, 0x0cc4, 0x0cc4,
			0x0cc8, 0x0cc8, 0x0cce, 0x0cdc, 0x0ce6, 0x0ce6, 0x0cee, 0x0cf2,
			0x0cf2, 0x0cf8, 0x0cf8, 0x0cf8, 0x0d03, 0x0d0c, 0x0d16, 0x0d24,
			// Entry 200 - 23F
			0x0d2b, 0x0d37, 0x0d46, 0x0d4b, 0x0d4b, 0x0d4b, 0x0d51, 0x0d55,
			0x0d5d, 0x0d5d, 0x0d6f, 0x0d81, 0x0d89, 0x0d89, 0x0d89, 0x0d8e,
			0x0d92, 0x0d98, 0x0d9d, 0x0da2, 0x0da5, 0x0dac, 0x0dac, 0x0db6,
			0x0dbd, 0x0dbd, 0x0dc5, 0x0dd0, 0x0dd9, 0x0dd9, 0x0dd9, 0x0dd9,
			0x0de2, 0x0de2, 0x0de9, 0x0def, 0x0df6, 0x0e00, 0x0e13, 0x0e19,
			0x0e22, 0x0e29, 0x0e2c, 0x0e2f, 0x0e2f, 0x0e2f, 0x0e2f, 0x0e2f,
			0x0e35, 0x0e35, 0x0e3a, 0x0e3a, 0x0e40, 0x0e45, 0x0e4a, 0x0e4a,
			0x0e4a, 0x0e50, 0x0e50, 0x0e54, 0x0e57, 0x0e5f, 0x0e5f, 0x0e5f,
			// Entry 240 - 27F
			0x0e5f, 0x0e5f, 0x0e69, 0x0e73, 0x0e73, 0x0e79, 0x0e97, 0x0e9b,
			0x0eb7, 0x0ebb, 0x0ed5, 0x0ee9, 0x0f05, 0x0f18, 0x0f29, 0x0f3b,
			0x0f4d, 0x0f65, 0x0f76, 0x0f88, 0x0f9a, 0x0faf, 0x0fb8, 0x0fb8,
			0x0fb8, 0x0fc1, 0x0fcf, 0x0fe9, 0x1000,
		},
	},
	{ // bs-Cyrl
		"афарскиабказијскиавестанскиафриканерскиаканамхарскиарагонежанскиарапскиа" +
			"семијскиаварскиајмараазербејџанскибашкирбелорускибугарскибисламабам" +
			"барабенгласкитибетанскибретонскибосанскикаталонскичеченскичаморокор" +
			"зиканскикричешкистарословенскичувашкивелшкиданскинемачкидивехијскиџ" +
			"онгаевегрчкиенглескиесперантошпанскиестонскибаскијскиперсијскифулах" +
			"финскифиджијскифарскифранцускифризијскиирскишкотски галскигалскигва" +
			"ранигуџаратиманксхаусахебрејскихиндихири мотухрватскихаитскимађарск" +
			"ијерменскихерероинтерлингваиндонежанскимеђујезичкиигбосичуан јиунуп" +
			"иакидоисландскииталијанскиинуктитутјапанскијаванскигрузијскиконгоки" +
			"кујукуањамакозачкикалалисуткмерскиканадакорејскиканурикашмирскикурд" +
			"скикомикорнишкикиргискилатинскилуксембуршкигандалимбургишлингалалао" +
			"скилитванскилуба-катангалетонскималагасијскимаршалскимаорскимакедон" +
			"скималајаламмонголскимаратималајскимелтешкибурманскинаурусеверни нд" +
			"ебеленепалскиндонгахоландскинорвешки њорскнорвешки бокмалјужни ндеб" +
			"еленавахоњањапровансалскиојибваоромооријскиосетскипанџабскипалипољс" +
			"кипаштунскипортугалскиквенчарето-романскирундирумунскирускикинјаруа" +
			"ндасанскритсардињаскисиндисеверни самисангосингалескисловачкисловен" +
			"ачкисамоанскишонасомалскиалбанскисрпскисватисесотосуданскишведскисв" +
			"ахилитамилскителугутађиктајландскитигрињатуркменскитсванатонгатурск" +
			"итсонгататарскитахићанскиујгурскиукрајинскиурдуузбечкивендавијетнам" +
			"скиволапуквалунволофксхосајидишјорубажуангкинескизулуачинескиаколиа" +
			"дангмејскиадигејскиафрихилиаинуакадијскиаљутјужни алтаистароенглеск" +
			"иангикаармајскиароканијскиарапахоаравакастуријскиавадхибалучибалине" +
			"зијскибасабејабембабојпурибиколбинисисикабрајбуриатбугинежанскиблин" +
			"кадокарипскиатсамскицебуаночибчачагатаичукескимаричинукскичоктавски" +
			"чипвијанскичерокичејенскикоптскикримеански турскикашубијанскидакота" +
			"даргваделаверславскидогрибдинкадогриниски сорбијанскидуаласредњи хо" +
			"ландскиђулаефикскистароегипатскиекајукеламитскисредњи енглескиевонд" +
			"офангтагалогфонсредњи францускистарофранцускисеверно-фризијскиисточ" +
			"ни фризијскифриулијскигагајогбајаџизгилбертшкисредњи високи немачки" +
			"старонемачкигондигоронталоготскигребостарогрчкишвајцарски немачкигв" +
			"ич’инхаидахавајскихилигајнонхититехмонггорњи сорбијскихупаибанилоко" +
			"ингвишкилојбанјудео-персијскијудео-арапскикара-калпашкикабилекачинђ" +
			"укамбакавикабардијскитјапкорокасикотанешкикимбундуконканикосреански" +
			"кпелекарачај-балкаркарелијскикурукхкумиккутенаиладиноландаламбалезг" +
			"ианмонголозилуба-лулуалуисенолундалуолушаимадурешкимагахимаитилимак" +
			"асармандингомасаимокшамандармендесредњи ирскимикмакминангкабауманчу" +
			"манипуримахавскимосивише језикакришкимирандешкимарвариерзијанеаполи" +
			"танскиниски немачкиневариниасниуеанногаистари норскин’косеверни сот" +
			"окласични неварињамвезињанколењоронзимаосагеотомански турскипангаси" +
			"нскипахлавипампангапапиаментопалауанскистароперсијскифеничанскипонп" +
			"ејскистаропровансалскирађастанирапануираротонганроманиароманијскиса" +
			"ндавејакутсамаритански арамејскисасаксанталисицилијанскишкотскиселк" +
			"апстароирскишансидамојужни самилуле самиинари самисколтски језиксон" +
			"инкесоџијенскисранански тонгосерерсукумасусусумерскикоморскикласичн" +
			"и сиријскисиријскитимнетеренотетумтигретивтокелауклингонскитлингитт" +
			"амашекњаса тонгаток писинтсимшиантумбукатувалутувинијскиудмуртугари" +
			"тскиумбундурутваивотскиваламоварајвашокалмикјаојапешкикантонскизапо" +
			"течкиблисимболизенагазунибез лингвистичког садржајазазаАустријски н" +
			"емачкиШвајцарски високи немачкиАустралијски енглескиКанадски енглес" +
			"киБритански енглескиСАД енглескиЛатино-амерички шпанскиИберијски шп" +
			"анскиКанадски францускиШвајцарски францускифламанскиБразилски порту" +
			"галскиИберијски португалскимолдавскисрпскохрватскикинески (поједнос" +
			"тављен)кинески (традиционални)",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x000e, 0x0022, 0x0036, 0x004e, 0x0056, 0x0066, 0x0080,
			0x008e, 0x00a0, 0x00ae, 0x00ba, 0x00d4, 0x00e0, 0x00f2, 0x0102,
			0x0110, 0x011e, 0x0130, 0x0144, 0x0156, 0x0166, 0x017a, 0x018a,
			0x0196, 0x01ac, 0x01b2, 0x01bc, 0x01d8, 0x01e6, 0x01f2, 0x01fe,
			0x020c, 0x0220, 0x022a, 0x0230, 0x023a, 0x024a, 0x025c, 0x026a,
			0x027a, 0x028c, 0x029e, 0x02a8, 0x02b4, 0x02c6, 0x02d2, 0x02e4,
			0x02f6, 0x0300, 0x031b, 0x0327, 0x0335, 0x0345, 0x034f, 0x0359,
			0x036b, 0x0375, 0x0386, 0x0396, 0x03a4, 0x03b4, 0x03c6, 0x03d2,
			// Entry 40 - 7F
			0x03e8, 0x0400, 0x0416, 0x041e, 0x042f, 0x043d, 0x0443, 0x0455,
			0x046b, 0x047d, 0x048d, 0x049d, 0x04af, 0x04b9, 0x04c5, 0x04d3,
			0x04e1, 0x04f3, 0x0501, 0x050d, 0x051d, 0x0529, 0x053b, 0x0549,
			0x0551, 0x0561, 0x0571, 0x0581, 0x0599, 0x05a3, 0x05b5, 0x05c3,
			0x05cf, 0x05e1, 0x05f8, 0x0608, 0x0620, 0x0632, 0x0640, 0x0654,
			0x0666, 0x0678, 0x0684, 0x0694, 0x06a4, 0x06b6, 0x06c0, 0x06dd,
			0x06ed, 0x06f9, 0x070b, 0x0726, 0x0743, 0x075c, 0x0768, 0x0770,
			0x0788, 0x0794, 0x079e, 0x07ac, 0x07ba, 0x07cc, 0x07d4, 0x07e0,
			// Entry 80 - BF
			0x07f2, 0x0808, 0x0814, 0x082d, 0x0837, 0x0847, 0x0851, 0x0867,
			0x0877, 0x088b, 0x0895, 0x08ac, 0x08b6, 0x08ca, 0x08da, 0x08ee,
			0x0900, 0x0908, 0x0918, 0x0928, 0x0934, 0x093e, 0x094a, 0x095a,
			0x0968, 0x0976, 0x0986, 0x0992, 0x099c, 0x09b0, 0x09be, 0x09d2,
			0x09de, 0x09e8, 0x09f4, 0x0a00, 0x0a10, 0x0a24, 0x0a34, 0x0a48,
			0x0a50, 0x0a5e, 0x0a68, 0x0a7e, 0x0a8c, 0x0a96, 0x0aa0, 0x0aac,
			0x0ab6, 0x0ac2, 0x0acc, 0x0ada, 0x0ae2, 0x0af2, 0x0afc, 0x0b12,
			0x0b24, 0x0b24, 0x0b34, 0x0b34, 0x0b3c, 0x0b4e, 0x0b4e, 0x0b56,
			// Entry C0 - FF
			0x0b56, 0x0b6b, 0x0b85, 0x0b91, 0x0ba1, 0x0bb7, 0x0bb7, 0x0bc5,
			0x0bc5, 0x0bd1, 0x0bd1, 0x0bd1, 0x0bd1, 0x0bd1, 0x0be5, 0x0be5,
			0x0bf1, 0x0bf1, 0x0bfd, 0x0c15, 0x0c15, 0x0c1d, 0x0c1d, 0x0c1d,
			0x0c1d, 0x0c25, 0x0c2f, 0x0c2f, 0x0c2f, 0x0c2f, 0x0c2f, 0x0c3d,
			0x0c47, 0x0c4f, 0x0c4f, 0x0c4f, 0x0c5b, 0x0c5b, 0x0c5b, 0x0c63,
			0x0c63, 0x0c63, 0x0c63, 0x0c6f, 0x0c87, 0x0c87, 0x0c8f, 0x0c8f,
			0x0c97, 0x0ca7, 0x0ca7, 0x0cb7, 0x0cc5, 0x0cc5, 0x0ccf, 0x0cdd,
			0x0ceb, 0x0cf3, 0x0d03, 0x0d15, 0x0d2b, 0x0d37, 0x0d47, 0x0d47,
			// Entry 100 - 13F
			0x0d55, 0x0d55, 0x0d76, 0x0d8e, 0x0d9a, 0x0da6, 0x0da6, 0x0db4,
			0x0dc2, 0x0dce, 0x0dd8, 0x0dd8, 0x0de2, 0x0e03, 0x0e03, 0x0e0d,
			0x0e2c, 0x0e2c, 0x0e34, 0x0e34, 0x0e34, 0x0e42, 0x0e42, 0x0e5e,
			0x0e6a, 0x0e7c, 0x0e99, 0x0e99, 0x0ea5, 0x0ea5, 0x0ead, 0x0ebb,
			0x0ebb, 0x0ec1, 0x0ec1, 0x0ee0, 0x0efc, 0x0efc, 0x0f1d, 0x0f3e,
			0x0f52, 0x0f56, 0x0f56, 0x0f56, 0x0f5e, 0x0f68, 0x0f68, 0x0f6e,
			0x0f82, 0x0f82, 0x0faa, 0x0fc2, 0x0fc2, 0x0fcc, 0x0fde, 0x0fea,
			0x0ff4, 0x1008, 0x102b, 0x102b, 0x102b, 0x102b, 0x103a, 0x1044,
			// Entry 140 - 17F
			0x1044, 0x1054, 0x1054, 0x1068, 0x1074, 0x107e, 0x109b, 0x109b,
			0x10a3, 0x10ab, 0x10ab, 0x10b5, 0x10c5, 0x10c5, 0x10c5, 0x10d1,
			0x10d1, 0x10d1, 0x10ee, 0x1107, 0x1107, 0x1120, 0x112c, 0x1136,
			0x113a, 0x1144, 0x114c, 0x1162, 0x1162, 0x116a, 0x116a, 0x116a,
			0x116a, 0x1172, 0x1172, 0x117a, 0x118c, 0x118c, 0x118c, 0x118c,
			0x118c, 0x118c, 0x119c, 0x119c, 0x11aa, 0x11be, 0x11c8, 0x11e3,
			0x11e3, 0x11e3, 0x11f7, 0x1203, 0x1203, 0x1203, 0x1203, 0x120d,
			0x121b, 0x1227, 0x1227, 0x1231, 0x123b, 0x1249, 0x1249, 0x1249,
			// Entry 180 - 1BF
			0x1249, 0x1249, 0x1249, 0x1253, 0x125b, 0x125b, 0x126e, 0x127c,
			0x1286, 0x128c, 0x1296, 0x1296, 0x1296, 0x1296, 0x12a8, 0x12a8,
			0x12b4, 0x12c2, 0x12d0, 0x12e0, 0x12ea, 0x12ea, 0x12f4, 0x1300,
			0x130a, 0x130a, 0x130a, 0x1321, 0x1321, 0x1321, 0x132d, 0x1343,
			0x134d, 0x135d, 0x136d, 0x1375, 0x1375, 0x1375, 0x138a, 0x1396,
			0x13aa, 0x13b8, 0x13b8, 0x13b8, 0x13c4, 0x13c4, 0x13c4, 0x13de,
			0x13de, 0x13f7, 0x1403, 0x140b, 0x1417, 0x1417, 0x1417, 0x1417,
			0x1421, 0x1438, 0x1438, 0x1441, 0x1458, 0x1458, 0x1475, 0x1483,
			// Entry 1C0 - 1FF
			0x1491, 0x1499, 0x14a3, 0x14ad, 0x14cc, 0x14e2, 0x14f0, 0x1500,
			0x1514, 0x1528, 0x1528, 0x1528, 0x1528, 0x1544, 0x1544, 0x1558,
			0x1558, 0x1558, 0x156a, 0x156a, 0x158c, 0x158c, 0x158c, 0x159e,
			0x15ac, 0x15c0, 0x15c0, 0x15c0, 0x15c0, 0x15cc, 0x15cc, 0x15cc,
			0x15cc, 0x15e2, 0x15e2, 0x15f0, 0x15fa, 0x1625, 0x1625, 0x162f,
			0x163d, 0x163d, 0x163d, 0x163d, 0x1655, 0x1663, 0x1663, 0x1663,
			0x1663, 0x1663, 0x166f, 0x166f, 0x1683, 0x1683, 0x1683, 0x1689,
			0x1689, 0x1695, 0x1695, 0x1695, 0x16a8, 0x16b9, 0x16cc, 0x16e7,
			// Entry 200 - 23F
			0x16f5, 0x1709, 0x1726, 0x1730, 0x1730, 0x1730, 0x173c, 0x1744,
			0x1754, 0x1764, 0x1764, 0x1785, 0x1795, 0x1795, 0x1795, 0x179f,
			0x179f, 0x17ab, 0x17b5, 0x17bf, 0x17c5, 0x17d3, 0x17d3, 0x17e7,
			0x17f5, 0x17f5, 0x1803, 0x1816, 0x1827, 0x1827, 0x1827, 0x1827,
			0x1837, 0x1837, 0x1845, 0x1851, 0x1851, 0x1865, 0x1865, 0x1871,
			0x1883, 0x1891, 0x1897, 0x189d, 0x189d, 0x189d, 0x189d, 0x189d,
			0x18a9, 0x18a9, 0x18a9, 0x18a9, 0x18b5, 0x18bf, 0x18c7, 0x18c7,
			0x18c7, 0x18d3, 0x18d3, 0x18d3, 0x18d9, 0x18e7, 0x18e7, 0x18e7,
			// Entry 240 - 27F
			0x18e7, 0x18f9, 0x190b, 0x191f, 0x191f, 0x192b, 0x192b, 0x1933,
			0x1965, 0x196d, 0x196d, 0x1990, 0x19c0, 0x19e9, 0x1a0a, 0x1a2d,
			0x1a44, 0x1a70, 0x1a91, 0x1a91, 0x1ab4, 0x1adb, 0x1aed, 0x1b16,
			0x1b3f, 0x1b51, 0x1b6d, 0x1b9a, 0x1bc5,
		},
	},
	{ // ca
		caLangStr,
		caLangIdx,
	},
	{ // cgg
		"OrukaniOrumarikiOruharabuOruberarusiOruburugariyaOrubengariOruceekiOrugi" +
			"rimaaniOruguriikiOrungyerezaOrusupaaniOrupaasiyaOrufaransaOruhausaOr" +
			"uhindiOruhangareOruindoneziaOruiboOruyitareOrujapaaniOrujavaOrukambo" +
			"diyaOrukoreyaOrumalesiyaOruburumaOrunepaliOrudaakiOrupungyabiOrupoor" +
			"iOrupocugoOruromaniaOrurrashaOrunyarwandaOrusomaariOruswidiOrutamiri" +
			"OrutailandiOrukurukiOrukurainiOru-UruduOruviyetinaamuOruyorubaOrucha" +
			"inaOruzuruRukiga",
		[]uint16{ // 246 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0031,
			0x0031, 0x0031, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
			0x003b, 0x003b, 0x003b, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x004f, 0x004f, 0x004f, 0x004f, 0x0059, 0x0064, 0x0064, 0x006e,
			0x006e, 0x006e, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x008a,
			0x008a, 0x0092, 0x0092, 0x0092, 0x0092, 0x009c, 0x009c, 0x009c,
			// Entry 40 - 7F
			0x009c, 0x00a8, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00b7, 0x00b7, 0x00c1, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00d4, 0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00e8, 0x00f1, 0x00f1, 0x00f1,
			0x00fa, 0x00fa, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102,
			0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x010d, 0x010d, 0x0115,
			// Entry 80 - BF
			0x0115, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128, 0x0131, 0x013d,
			0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d,
			0x013d, 0x013d, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0163, 0x0163, 0x0163,
			0x0163, 0x0163, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x0176,
			0x017f, 0x017f, 0x017f, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d,
			0x018d, 0x0196, 0x0196, 0x019f, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry C0 - FF
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01ac,
		},
	},
	{ // chr
		"ᎠᏂᏓᏥᎩᎵᏏᏍᏆᏂᎦᎸᏥᎬᏩᎵᏲᏥᎢᏣᏩᏂᏏᏉᏧᎦᎵᏲᏂᎢᏓᎶᏂᎨᎦᏳᎦᎠᏣᏗᏣᎳᎩᎼᎻᎦᎠᎫᏌᏏᏂᎦᏄᏬᎵᏍᏛᎾ ᎦᏬᏂᎯᏍᏗ",
		[]uint16{ // 555 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x0015, 0x0015, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			// Entry 40 - 7F
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			0x0039, 0x0039, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			// Entry 80 - BF
			0x0045, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			// Entry C0 - FF
			0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f,
			0x006f, 0x006f, 0x006f, 0x0078, 0x0078, 0x0081, 0x0081, 0x0081,
			// Entry 100 - 13F
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			// Entry 140 - 17F
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			// Entry 180 - 1BF
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			// Entry 1C0 - 1FF
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			// Entry 200 - 23F
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x00c1,
		},
	},
	{ // cs
		csLangStr,
		csLangIdx,
	},
	{ // cy
		"AffaregAbchasegAfestanegAffricânegAcanegAmharegAragonegArabegAsamegAfare" +
			"gAserbaijanegBashcortegBelarwsegBwlgaregBislamaBambaregBengalegTibet" +
			"egLlydawegBosniegCatalanegTsietsienegTsiamorroCorsegCriTsiecegHen Sl" +
			"afonegCymraegDanegAlmaenegDifehiEweGroegSaesnegEsperantoSbaenegEston" +
			"egBasgegPersegFfwlaFfinnegFfijïegFfaröegFfrangegFfriseg y GorllewinG" +
			"wyddelegGaeleg yr AlbanGalisiegGuaraníGwjaratiManawegHawsaHebraegHin" +
			"diCroategCreol HaitiHwngaregArmenegHereroInterlinguaIndonesegInterli" +
			"ngueIgboNwoswInwpiacegIslandegEidalegInwctitwtJapaneegJafanaegGeorge" +
			"gCongokiCasachegChmeregKannadaCoreegCanwriCashmiregCwrdegComiCernywe" +
			"gCirgisegLladinLwcsembwrgegGandaLimbwrgegLingalaLaoegLithwanegLatfie" +
			"gMalagasegMarsialegMaoriMacedonegMalayalamMongolegMarathiMaleiegMalt" +
			"egByrmanegNawrŵegNdebele GogleddolNepalegNdongaIseldiregNorwyeg Nyno" +
			"rskNorwyeg BokmålNdebele DeheuolNafahoNianjaOcsitanegOjibwaOromoOriy" +
			"aOsetegPwnjabegPaliPwylegPashtoPortiwgeegQuechuaRomaunschRwndiRwmane" +
			"gRwsegCiniarŵandegSansgritSardegSindhiSami GogleddolSangoSinhalegSlo" +
			"facegSlofenegSamöegSomalegAlbanegSerbegSesothegSwndanegSwedegSwahili" +
			"TamilegTeluguTajicegThaiTigrinyaTwrcmenegTswanaTongegTyrcegTsongaegT" +
			"ataregUighurWcreinegWrdwWsbecegFendegFietnamegWalwnegWoloffXhosaIdde" +
			"w-AlmaenegIorwbaTsieineegSwlwAcehnegAcoliAdangmegCircaseg Gorllewino" +
			"lArabeg TunisiaAffrihiliAghemegAinŵegAcadegAlabamäegAlewtegGhegeg Al" +
			"baniaAltäeg DeheuolHen SaesnegAramaegArawcanegAraonaegArapahoArabeg " +
			"AlgeriaArawacegArabeg MorocoArabeg yr AifftIaith Arwyddion AmericaAs" +
			"erbaijaneg DeheuolBalwtsiBalïegBasâegBamwmegBejäegBembegBenaComegBra" +
			"huiBwriategBwlwCadoCaribegAtsamegMariegSioctoTsierocîCheyenneCwrdeg " +
			"SoraniCoptegTyrceg y CrimeaDacotaegDargwaDincaZarmaegDogriSorbeg Isa" +
			"fIseldireg CanolEmbwHen EifftegElamegSaesneg CanolEwondoExtremadureg" +
			"FfilipinegFfinneg TornedalFfrangeg CajwnFfrangeg CanolHen FfrangegFf" +
			"riseg y GogleddFfriseg y DwyrainFfriwlegGaioGbaiaDareg y Zoroastriai" +
			"dGilbertegUchel Almaeneg CanolHen Uchel AlmaenegGothegHen RoegAlmaen" +
			"eg y SwistirHaidaHawäiegHethegHmongegSorbeg UchafIbanegIbibioIlocane" +
			"gIngwsiegMatsiameIddew-BersiegIddew-ArabegCara-CalpacegCabilegCambaC" +
			"ircaseg DwyreiniolMacondegCaboferdianegCàsegConcaniCarelegBaffiaCwle" +
			"negCwmicegIddew-SbaenegLangiLahndaLambaLezghegLombardegMongoLoziLatg" +
			"aliegLwndaLŵoLwshaiegLwyiaMadwregMagahiMaithiliMacasaregMandingoMasa" +
			"iMocsiaMandaregMendegMêrwGwyddeleg CanolMicmacegManshwManipwriMohoce" +
			"gMosiMasmwy nag un iaithMirandegMarwariNapliegIsel AlmaenegNewaegHen" +
			" NorsegSotho GogleddolNŵeregHen NewariNiamweziNiancoleNioroNzimegOsa" +
			"gegTyrceg OtomanPangasinegPahlafiPampangaPicardegAlmaeneg Pensylfani" +
			"aHen BersiegAlmaeneg PalatinPhoenicegPiedmontegPohnpeianegPrwsegHen " +
			"BrofensalegK’iche’RajasthanegRapanŵiRaratongegRomboRomaniRotumanegAr" +
			"omanegRwaSandäwegAramaeg SamariaSambŵrwSasacegSantaliNgambeiegSangwS" +
			"isilegSgotegSasareseg SardiniaSenecaSelcypegHen WyddelegArabeg ChadS" +
			"idamoIs-silesiegSami DeheuolSami LwleSami InariSami ScoltSonincegSog" +
			"degSwcwmaSwsŵegSwmeregComoregSwahili’r CongoHen SyriegSyriegSilesieg" +
			"TuluTimnegTetumegKlingonTamashecegTwfalwegFotiacegWgaritegUmbunduy G" +
			"wraiddFaiegFenisegFflemeg GorllewinolWalamoCalmycegIembaegCantoneegZ" +
			"apotecegBlisssymbolsZêlandegTamazight Safonol MorocoZuniDim cynnwys " +
			"ieithyddolZazäegArabeg Modern SafonolAlmaeneg AwstriaAlmaeneg Safono" +
			"l y SwistirSaesneg AwstraliaSaesneg CanadaSaesneg PrydainSaesneg Ame" +
			"ricaSbaeneg America LadinSbaeneg EwropSbaeneg MecsicoFfrangeg Canada" +
			"Ffrangeg y SwistirFflemegPortiwgeeg BrasilPortiwgeeg EwropMoldofegSe" +
			"rbo-CroategTsieineeg SymledigTsieineeg Traddodiadol",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0007, 0x000f, 0x0018, 0x0023, 0x0029, 0x0030, 0x0038,
			0x003e, 0x0044, 0x004a, 0x004a, 0x0056, 0x0060, 0x0069, 0x0071,
			0x0078, 0x0080, 0x0088, 0x008f, 0x0097, 0x009e, 0x00a7, 0x00b2,
			0x00bb, 0x00c1, 0x00c4, 0x00cb, 0x00d7, 0x00d7, 0x00de, 0x00e3,
			0x00eb, 0x00f1, 0x00f1, 0x00f4, 0x00f9, 0x0100, 0x0109, 0x0110,
			0x0117, 0x011d, 0x0123, 0x0128, 0x012f, 0x0137, 0x013f, 0x0147,
			0x015a, 0x0163, 0x0172, 0x017a, 0x0182, 0x018a, 0x0191, 0x0196,
			0x019d, 0x01a2, 0x01a2, 0x01a9, 0x01b4, 0x01bc, 0x01c3, 0x01c9,
			// Entry 40 - 7F
			0x01d4, 0x01dd, 0x01e8, 0x01ec, 0x01f1, 0x01fa, 0x01fa, 0x0202,
			0x0209, 0x0212, 0x021a, 0x0222, 0x0229, 0x022e, 0x0230, 0x0230,
			0x0238, 0x0238, 0x023f, 0x0246, 0x024c, 0x0252, 0x025b, 0x0261,
			0x0265, 0x026d, 0x0275, 0x027b, 0x0287, 0x028c, 0x0295, 0x029c,
			0x02a1, 0x02aa, 0x02aa, 0x02b1, 0x02ba, 0x02c3, 0x02c8, 0x02d1,
			0x02da, 0x02e2, 0x02e9, 0x02f0, 0x02f6, 0x02fe, 0x0306, 0x0317,
			0x031e, 0x0324, 0x032d, 0x033c, 0x034b, 0x035a, 0x0360, 0x0366,
			0x036f, 0x0375, 0x037a, 0x037f, 0x0385, 0x038d, 0x0391, 0x0397,
			// Entry 80 - BF
			0x039d, 0x03a7, 0x03ae, 0x03b7, 0x03bc, 0x03c3, 0x03c8, 0x03d5,
			0x03dd, 0x03e3, 0x03e9, 0x03f7, 0x03fc, 0x0404, 0x040c, 0x0414,
			0x041b, 0x041b, 0x0422, 0x0429, 0x042f, 0x042f, 0x0437, 0x043f,
			0x0445, 0x044c, 0x0453, 0x0459, 0x0460, 0x0464, 0x046c, 0x0475,
			0x047b, 0x0481, 0x0487, 0x048f, 0x0496, 0x0496, 0x049c, 0x04a4,
			0x04a8, 0x04af, 0x04b5, 0x04be, 0x04be, 0x04c5, 0x04cb, 0x04d0,
			0x04de, 0x04e4, 0x04e4, 0x04ed, 0x04f1, 0x04f8, 0x04fd, 0x0505,
			0x0519, 0x0527, 0x0530, 0x0537, 0x053e, 0x0544, 0x054e, 0x0555,
			// Entry C0 - FF
			0x0563, 0x0572, 0x057d, 0x057d, 0x0584, 0x058d, 0x0595, 0x059c,
			0x05aa, 0x05b2, 0x05bf, 0x05ce, 0x05ce, 0x05e5, 0x05e5, 0x05e5,
			0x05e5, 0x05f9, 0x0600, 0x0607, 0x0607, 0x060e, 0x0615, 0x0615,
			0x0615, 0x061c, 0x0622, 0x0622, 0x0626, 0x0626, 0x0626, 0x0626,
			0x0626, 0x0626, 0x0626, 0x062b, 0x062b, 0x062b, 0x062b, 0x062b,
			0x0631, 0x0631, 0x0631, 0x0639, 0x0639, 0x063d, 0x063d, 0x063d,
			0x0641, 0x0648, 0x0648, 0x064f, 0x064f, 0x064f, 0x064f, 0x064f,
			0x064f, 0x0655, 0x0655, 0x065b, 0x065b, 0x0664, 0x066c, 0x0679,
			// Entry 100 - 13F
			0x067f, 0x067f, 0x068e, 0x068e, 0x0696, 0x069c, 0x069c, 0x069c,
			0x069c, 0x069c, 0x06a1, 0x06a8, 0x06ad, 0x06b8, 0x06b8, 0x06b8,
			0x06c7, 0x06c7, 0x06c7, 0x06c7, 0x06cb, 0x06cb, 0x06cb, 0x06d6,
			0x06d6, 0x06dc, 0x06e9, 0x06e9, 0x06ef, 0x06fb, 0x06fb, 0x0705,
			0x0715, 0x0715, 0x0723, 0x0731, 0x073d, 0x073d, 0x074e, 0x075f,
			0x0767, 0x0767, 0x0767, 0x0767, 0x076b, 0x0770, 0x0784, 0x0784,
			0x078d, 0x078d, 0x07a1, 0x07b3, 0x07b3, 0x07b3, 0x07b3, 0x07b9,
			0x07b9, 0x07c1, 0x07d3, 0x07d3, 0x07d3, 0x07d3, 0x07d3, 0x07d8,
			// Entry 140 - 17F
			0x07d8, 0x07e0, 0x07e0, 0x07e0, 0x07e6, 0x07ed, 0x07f9, 0x07f9,
			0x07f9, 0x07ff, 0x0805, 0x080d, 0x0815, 0x0815, 0x0815, 0x0815,
			0x0815, 0x081d, 0x082a, 0x0836, 0x0836, 0x0843, 0x084a, 0x084a,
			0x084a, 0x084f, 0x084f, 0x0862, 0x0862, 0x0862, 0x086a, 0x0877,
			0x0877, 0x0877, 0x0877, 0x087d, 0x087d, 0x087d, 0x087d, 0x087d,
			0x087d, 0x087d, 0x087d, 0x087d, 0x0884, 0x0884, 0x0884, 0x0884,
			0x0884, 0x0884, 0x088b, 0x088b, 0x088b, 0x0891, 0x0898, 0x089f,
			0x089f, 0x08ac, 0x08b1, 0x08b7, 0x08bc, 0x08c3, 0x08c3, 0x08c3,
			// Entry 180 - 1BF
			0x08c3, 0x08c3, 0x08cc, 0x08d1, 0x08d5, 0x08de, 0x08de, 0x08de,
			0x08e3, 0x08e7, 0x08ef, 0x08f4, 0x08f4, 0x08f4, 0x08fb, 0x08fb,
			0x0901, 0x0909, 0x0912, 0x091a, 0x091f, 0x091f, 0x0925, 0x092d,
			0x0933, 0x0938, 0x0938, 0x0947, 0x0947, 0x0947, 0x094f, 0x094f,
			0x0955, 0x095d, 0x0964, 0x0968, 0x0968, 0x096b, 0x097b, 0x097b,
			0x0983, 0x098a, 0x098a, 0x098a, 0x098a, 0x098a, 0x098a, 0x0991,
			0x0991, 0x099e, 0x09a4, 0x09a4, 0x09a4, 0x09a4, 0x09a4, 0x09a4,
			0x09a4, 0x09ae, 0x09ae, 0x09ae, 0x09bd, 0x09c4, 0x09ce, 0x09d6,
			// Entry 1C0 - 1FF
			0x09de, 0x09e3, 0x09e9, 0x09ef, 0x09fc, 0x0a06, 0x0a0d, 0x0a15,
			0x0a15, 0x0a15, 0x0a1d, 0x0a31, 0x0a31, 0x0a3c, 0x0a4c, 0x0a55,
			0x0a5f, 0x0a5f, 0x0a6a, 0x0a70, 0x0a7f, 0x0a8a, 0x0a8a, 0x0a95,
			0x0a9d, 0x0aa7, 0x0aa7, 0x0aa7, 0x0aac, 0x0ab2, 0x0abb, 0x0abb,
			0x0abb, 0x0ac3, 0x0ac6, 0x0acf, 0x0acf, 0x0ade, 0x0ae6, 0x0aed,
			0x0af4, 0x0af4, 0x0afd, 0x0b02, 0x0b09, 0x0b0f, 0x0b21, 0x0b27,
			0x0b27, 0x0b27, 0x0b2f, 0x0b2f, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b3b,
			0x0b46, 0x0b4c, 0x0b57, 0x0b57, 0x0b63, 0x0b6c, 0x0b76, 0x0b80,
			// Entry 200 - 23F
			0x0b88, 0x0b8e, 0x0b8e, 0x0b8e, 0x0b8e, 0x0b8e, 0x0b94, 0x0b9b,
			0x0ba2, 0x0ba9, 0x0bba, 0x0bc4, 0x0bca, 0x0bd2, 0x0bd6, 0x0bdc,
			0x0bdc, 0x0bdc, 0x0be3, 0x0be3, 0x0be3, 0x0be3, 0x0be3, 0x0bea,
			0x0bea, 0x0bea, 0x0bf4, 0x0bf4, 0x0bf4, 0x0bf4, 0x0bf4, 0x0bf4,
			0x0bf4, 0x0bf4, 0x0bf4, 0x0bfc, 0x0bfc, 0x0bfc, 0x0bfc, 0x0c04,
			0x0c0c, 0x0c13, 0x0c1c, 0x0c21, 0x0c28, 0x0c28, 0x0c3b, 0x0c3b,
			0x0c3b, 0x0c3b, 0x0c3b, 0x0c3b, 0x0c41, 0x0c41, 0x0c41, 0x0c41,
			0x0c41, 0x0c49, 0x0c49, 0x0c49, 0x0c49, 0x0c49, 0x0c49, 0x0c50,
			// Entry 240 - 27F
			0x0c50, 0x0c59, 0x0c62, 0x0c6e, 0x0c77, 0x0c77, 0x0c8f, 0x0c93,
			0x0ca9, 0x0cb0, 0x0cc5, 0x0cd5, 0x0cef, 0x0d00, 0x0d0e, 0x0d1d,
			0x0d2c, 0x0d41, 0x0d4e, 0x0d5d, 0x0d6c, 0x0d7e, 0x0d85, 0x0d96,
			0x0da6, 0x0dae, 0x0dbb, 0x0dcd, 0x0de3,
		},
	},
	{ // da
		daLangStr,
		daLangIdx,
	},
	{ // dav
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKitaita",
		[]uint16{ // 263 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0170,
		},
	},
	{ // de
		deLangStr,
		deLangIdx,
	},
	{ // de-CH
		"WeissrussischAltpreussisch",
		[]uint16{ // 468 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 40 - 7F
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 80 - BF
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry C0 - FF
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 100 - 13F
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 140 - 17F
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 180 - 1BF
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 1C0 - 1FF
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x001a,
		},
	},
	{ // dje
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senniKoree" +
			" senniMaleezi senniBurme senniNeepal senniHolandee senniPunjaabi sen" +
			"niiPolonee senniPortugee senniRumaani senniRuusi senniRwanda senniSo" +
			"maali senniSuweede senniTamil senniTaailandu senniTurku senniUkreen " +
			"senniUrdu senniVietnaam senniYorbance senniSinuwa senniZulu senniZar" +
			"maciine",
		[]uint16{ // 268 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0111, 0x0111, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x0129, 0x0129, 0x0134, 0x0134, 0x0134,
			0x0140, 0x0140, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
			0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x015d, 0x015d, 0x016a,
			// Entry 80 - BF
			0x016a, 0x0178, 0x0178, 0x0178, 0x0178, 0x0185, 0x0190, 0x019c,
			0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c,
			0x019c, 0x019c, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9,
			0x01b6, 0x01b6, 0x01c1, 0x01c1, 0x01c1, 0x01d0, 0x01d0, 0x01d0,
			0x01d0, 0x01d0, 0x01db, 0x01db, 0x01db, 0x01db, 0x01db, 0x01e7,
			0x01f1, 0x01f1, 0x01f1, 0x01ff, 0x01ff, 0x01ff, 0x01ff, 0x01ff,
			0x01ff, 0x020d, 0x020d, 0x0219, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			// Entry C0 - FF
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			// Entry 100 - 13F
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x022d,
		},
	},
	{ // dsb
		"afaršćinaabchazšćinaafrikansakanšćinaamharšćinaaragonšćinaarabšćinaasamš" +
			"ćinaawaršćinaaymaršćinaazerbajdžanšćinabaškiršćinaběłorušćinabulgar" +
			"šćinabislamšćinabambarabengalšćinatibetšćinabretonšćinabosnišćinaka" +
			"tanlanšćinačamoršćinakorsišćinakričešćinawalizišćinadanšćinanimšćina" +
			"divehidzongkhaewegrichišćinaengelšćinaesperantošpańšćinaestišćinabas" +
			"kišćinapersišćinafinšćinafidžišćinaferejšćinafrancojšćinafrizišćinai" +
			"ršćinašotišćinagalicišćinaguaranigudžaratšćinamanšćinahausahebrejšći" +
			"nahindišćinachorwatšćinahaitišćinahungoršćinaarmeńšćinainterlinguain" +
			"donešćinaigbosichuan yiinupiakidoislandšćinaitalšćinainuitšćinajapań" +
			"šćinajavašćinageorgišćinakikuyukazachšćinagrönlandšćinakambodžanšći" +
			"nakannadšćinakorejańšćinakašmiršćinakurdišćinakornišćinakirgišćinała" +
			"tyńšćinaluxemburgšćinagandšćinalimburšćinalingalalaošćinalitawšćinal" +
			"uba-katangaletišćinamalgašćinamaorišćinamakedońšćinamalajamšćinamong" +
			"olšćinamaratišćinamalajšćinamaltašćinaburmašćinanaurušćinapódpołnocn" +
			"e ndebelenepalšćinanižozemšćinanorwegske nynorsknorwegske bokmålnava" +
			"hookcitanšćinaoromoorojišćinapandžabšćinapólšćinapaštunšćinaportugal" +
			"šćinakečuaretoromańšćinakirundišćinarumunšćinarušćinakinjarwandasan" +
			"skritsardinšćinasindšćinalapšćinasangosingalšćinasłowakšćinasłowjeńš" +
			"ćinasamošćinašonšćinasomališćinaalbanšćinaserbišćinasiswatipódpołdn" +
			"jowa sotšćina (Sesotho)sundanšćinašwedšćinaswahilišćinatamilšćinatel" +
			"ugšćinatadžikišćinathailandšćinatigrinjaturkmeńšćinatswanatonganšćin" +
			"aturkojšćinatsongatataršćinatahitišćinaujguršćinaukrainšćinaurdušćin" +
			"ausbekšćinavietnamšćinavolapükwalonšćinawolofxhosajidišćinajorubšćin" +
			"azhuangchinšćinazuluaghemanglosaksojšćinaarawkašćinapareasturšćinabe" +
			"mbabenabodobugišćinachigachoctawšćinacherokeesoranitaitazarmadolnose" +
			"rbšćinadualajola-fonyiembufilipinšćinagagauzšćinagotišćinašwicarska " +
			"nimšćinagusiihawaiišćinagórnoserbšćinangombamachamekabylšćinakambama" +
			"kondekapverdšćinakoyra chiinikalenjinkomi-permyakkonkanišambalabafia" +
			"langilakotšćinaluoluhyamasaišćinamerumauriciska kreolšćinamakhuwa-me" +
			"ettometa’mohawkšćinamundangkriknamadolnonimšćinakwasion’konuernyanko" +
			"leprusčinakʼicheʼromborwasamburusangusicilianišćinasenakoyra sennita" +
			"šelhitpódpołdnjowa samišćinalule-samišćinainari-samišćinaskolt-sami" +
			"šćinasaterfrizišćinakongojska swahilišćinatesotasawaqcentralnoatlas" +
			"ki tamazightnjeznata rěcvaivunjosogastandardny marokkański tamazight" +
			"žedno rěcne wopśimjeśemoderna wusokoarabšćinaawstriska nimšćinašwic" +
			"arska wusokonimšćinaawstralska engelšćinakanadiska engelšćinabritisk" +
			"a engelšćinaameriska engelšćinałatyńskoamerikańska špańšćinaeuropejs" +
			"ka špańšćinamexikańska špańšćinakanadiska francojšćinašwicarska fran" +
			"cojšćinaflamšćinabrazilska portugalšćinaeuropejska portugalšćinamold" +
			"awišćinaserbochorwatšćinachinšćina (zjadnorjona)chinšćina (tradicion" +
			"alna)",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x000b, 0x0018, 0x0018, 0x0020, 0x002b, 0x0037, 0x0044,
			0x004f, 0x005a, 0x0065, 0x0071, 0x0084, 0x0092, 0x00a1, 0x00ae,
			0x00bb, 0x00c2, 0x00cf, 0x00db, 0x00e8, 0x00f4, 0x0103, 0x0103,
			0x0110, 0x011c, 0x011f, 0x0129, 0x0129, 0x0129, 0x0136, 0x0140,
			0x014a, 0x0150, 0x0158, 0x015b, 0x0168, 0x0174, 0x017d, 0x018a,
			0x0195, 0x01a1, 0x01ad, 0x01ad, 0x01b7, 0x01c4, 0x01d0, 0x01de,
			0x01ea, 0x01f3, 0x01ff, 0x020c, 0x0213, 0x0223, 0x022d, 0x0232,
			0x023f, 0x024b, 0x024b, 0x0259, 0x0265, 0x0272, 0x027f, 0x027f,
			// Entry 40 - 7F
			0x028a, 0x0297, 0x0297, 0x029b, 0x02a5, 0x02ac, 0x02af, 0x02bc,
			0x02c7, 0x02d3, 0x02e0, 0x02eb, 0x02f8, 0x02f8, 0x02fe, 0x02fe,
			0x030b, 0x031b, 0x032c, 0x0339, 0x0348, 0x0348, 0x0356, 0x0362,
			0x0362, 0x036e, 0x037a, 0x0388, 0x0398, 0x03a3, 0x03b0, 0x03b7,
			0x03c1, 0x03cd, 0x03d9, 0x03e4, 0x03f0, 0x03f0, 0x03fc, 0x040b,
			0x0419, 0x0426, 0x0433, 0x043f, 0x044b, 0x0457, 0x0463, 0x0478,
			0x0484, 0x0484, 0x0493, 0x04a4, 0x04b5, 0x04b5, 0x04bb, 0x04bb,
			0x04c9, 0x04c9, 0x04ce, 0x04da, 0x04da, 0x04e9, 0x04e9, 0x04f4,
			// Entry 80 - BF
			0x0502, 0x0511, 0x0517, 0x0528, 0x0536, 0x0542, 0x054b, 0x0556,
			0x055e, 0x056b, 0x0576, 0x0580, 0x0585, 0x0592, 0x05a0, 0x05b0,
			0x05bb, 0x05c6, 0x05d3, 0x05df, 0x05eb, 0x05f2, 0x0615, 0x0622,
			0x062e, 0x063c, 0x0648, 0x0654, 0x0663, 0x0672, 0x067a, 0x0689,
			0x068f, 0x069c, 0x06a9, 0x06af, 0x06bb, 0x06c8, 0x06d4, 0x06e1,
			0x06ec, 0x06f8, 0x06f8, 0x0706, 0x070e, 0x071a, 0x071f, 0x0724,
			0x072f, 0x073b, 0x0741, 0x074c, 0x0750, 0x0750, 0x0750, 0x0750,
			0x0750, 0x0750, 0x0750, 0x0755, 0x0755, 0x0755, 0x0755, 0x0755,
			// Entry C0 - FF
			0x0755, 0x0755, 0x0767, 0x0767, 0x0767, 0x0774, 0x0774, 0x0774,
			0x0774, 0x0774, 0x0774, 0x0774, 0x0778, 0x0778, 0x0784, 0x0784,
			0x0784, 0x0784, 0x0784, 0x0784, 0x0784, 0x0784, 0x0784, 0x0784,
			0x0784, 0x0784, 0x0789, 0x0789, 0x078d, 0x078d, 0x078d, 0x078d,
			0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d,
			0x078d, 0x0791, 0x0791, 0x0791, 0x079c, 0x079c, 0x079c, 0x079c,
			0x079c, 0x079c, 0x079c, 0x079c, 0x079c, 0x07a1, 0x07a1, 0x07a1,
			0x07a1, 0x07a1, 0x07a1, 0x07af, 0x07af, 0x07b7, 0x07b7, 0x07bd,
			// Entry 100 - 13F
			0x07bd, 0x07bd, 0x07bd, 0x07bd, 0x07bd, 0x07bd, 0x07c2, 0x07c2,
			0x07c2, 0x07c2, 0x07c2, 0x07c7, 0x07c7, 0x07d7, 0x07d7, 0x07dc,
			0x07dc, 0x07e6, 0x07e6, 0x07e6, 0x07ea, 0x07ea, 0x07ea, 0x07ea,
			0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07f8,
			0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x07f8,
			0x07f8, 0x07f8, 0x0805, 0x0805, 0x0805, 0x0805, 0x0805, 0x0805,
			0x0805, 0x0805, 0x0805, 0x0805, 0x0805, 0x0805, 0x0805, 0x0810,
			0x0810, 0x0810, 0x0825, 0x0825, 0x0825, 0x082a, 0x082a, 0x082a,
			// Entry 140 - 17F
			0x082a, 0x0837, 0x0837, 0x0837, 0x0837, 0x0837, 0x0848, 0x0848,
			0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848,
			0x084e, 0x0855, 0x0855, 0x0855, 0x0855, 0x0855, 0x0861, 0x0861,
			0x0861, 0x0866, 0x0866, 0x0866, 0x0866, 0x0866, 0x086d, 0x087b,
			0x087b, 0x087b, 0x087b, 0x087b, 0x087b, 0x0887, 0x0887, 0x0887,
			0x0887, 0x088f, 0x088f, 0x089b, 0x08a2, 0x08a2, 0x08a2, 0x08a2,
			0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08aa, 0x08af, 0x08af, 0x08af,
			0x08af, 0x08af, 0x08b4, 0x08b4, 0x08b4, 0x08b4, 0x08b4, 0x08b4,
			// Entry 180 - 1BF
			0x08b4, 0x08c0, 0x08c0, 0x08c0, 0x08c0, 0x08c0, 0x08c0, 0x08c0,
			0x08c0, 0x08c3, 0x08c3, 0x08c8, 0x08c8, 0x08c8, 0x08c8, 0x08c8,
			0x08c8, 0x08c8, 0x08c8, 0x08c8, 0x08d4, 0x08d4, 0x08d4, 0x08d4,
			0x08d4, 0x08d8, 0x08ef, 0x08ef, 0x08fd, 0x0904, 0x0904, 0x0904,
			0x0904, 0x0904, 0x0911, 0x0911, 0x0911, 0x0918, 0x0918, 0x091c,
			0x091c, 0x091c, 0x091c, 0x091c, 0x091c, 0x091c, 0x091c, 0x091c,
			0x0920, 0x092f, 0x092f, 0x092f, 0x092f, 0x092f, 0x0935, 0x0935,
			0x0935, 0x0935, 0x0935, 0x093b, 0x093b, 0x093f, 0x093f, 0x093f,
			// Entry 1C0 - 1FF
			0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947,
			0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947,
			0x0947, 0x0947, 0x0947, 0x0950, 0x0950, 0x0959, 0x0959, 0x0959,
			0x0959, 0x0959, 0x0959, 0x0959, 0x095e, 0x095e, 0x095e, 0x095e,
			0x095e, 0x095e, 0x0961, 0x0961, 0x0961, 0x0961, 0x0968, 0x0968,
			0x0968, 0x0968, 0x0968, 0x096d, 0x097d, 0x097d, 0x097d, 0x097d,
			0x0981, 0x0981, 0x0981, 0x098c, 0x098c, 0x098c, 0x0995, 0x0995,
			0x0995, 0x0995, 0x0995, 0x0995, 0x09af, 0x09bf, 0x09d0, 0x09e1,
			// Entry 200 - 23F
			0x09e1, 0x09e1, 0x09e1, 0x09e1, 0x09e1, 0x09f2, 0x09f2, 0x09f2,
			0x09f2, 0x09f2, 0x0a0a, 0x0a0a, 0x0a0a, 0x0a0a, 0x0a0a, 0x0a0a,
			0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e,
			0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e,
			0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a15, 0x0a15, 0x0a2f, 0x0a2f,
			0x0a2f, 0x0a2f, 0x0a3c, 0x0a3f, 0x0a3f, 0x0a3f, 0x0a3f, 0x0a3f,
			0x0a3f, 0x0a3f, 0x0a44, 0x0a44, 0x0a44, 0x0a44, 0x0a44, 0x0a44,
			0x0a44, 0x0a44, 0x0a44, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a48,
			// Entry 240 - 27F
			0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a69, 0x0a69,
			0x0a83, 0x0a83, 0x0a9c, 0x0ab0, 0x0acb, 0x0ae2, 0x0af8, 0x0b0d,
			0x0b22, 0x0b46, 0x0b5e, 0x0b77, 0x0b8f, 0x0ba8, 0x0bb3, 0x0bcc,
			0x0be6, 0x0bf4, 0x0c07, 0x0c20, 0x0c3b,
		},
	},
	{ // dua
		"duálá",
		[]uint16{ // 272 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007,
		},
	},
	{ // dyo
		"akanamharikarabbelarusbulgaaribengalisekalmangreekangleespañolpersanfran" +
			"sehausaenduongruaindoneesiigboitaliensaponeesavaneekmeerkoreemaleesi" +
			"birmaninepaleesneerlandepenjabipoloneesportugeesrumeenrusruandasomal" +
			"isueditamiltayturkiukrainurduvietnamyorubasinuasulujoola",
		[]uint16{ // 274 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x0016, 0x001e,
			0x001e, 0x001e, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
			0x0025, 0x0025, 0x0025, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x002d, 0x002d, 0x002d, 0x002d, 0x0032, 0x0037, 0x0037, 0x003f,
			0x003f, 0x003f, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x004b,
			0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x0050,
			0x0050, 0x0054, 0x0054, 0x0054, 0x0054, 0x005a, 0x005a, 0x005a,
			// Entry 40 - 7F
			0x005a, 0x0063, 0x0063, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
			0x006e, 0x006e, 0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c,
			0x007c, 0x007c, 0x0081, 0x0081, 0x0086, 0x0086, 0x0086, 0x0086,
			0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
			0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
			0x0086, 0x0086, 0x0086, 0x008d, 0x008d, 0x0094, 0x0094, 0x0094,
			0x009c, 0x009c, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00ac, 0x00ac, 0x00b4,
			// Entry 80 - BF
			0x00b4, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00c3, 0x00c6, 0x00cc,
			0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00cc, 0x00cc, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d7, 0x00d7, 0x00dc, 0x00dc, 0x00dc, 0x00df, 0x00df, 0x00df,
			0x00df, 0x00df, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00ea,
			0x00ee, 0x00ee, 0x00ee, 0x00f5, 0x00f5, 0x00f5, 0x00f5, 0x00f5,
			0x00f5, 0x00fb, 0x00fb, 0x0100, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			// Entry C0 - FF
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			// Entry 100 - 13F
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0109,
		},
	},
	{ // dz
		"ཨ་ཕར་ཁཨཱབ་ཁ་ཟི་ཡ་ཁཨཕ་རི་ཀཱནས་ཁཨམ་ཧ་རིཀ་ཁཨེ་ར་བིཀ་ཁཨ་ས་མིས་ཁཨ་ཛར་བྷའི་ཇཱན" +
			"་ཁབེལ་ཨ་རུས་ཁབཱལ་གེ་རི་ཡཱན་ཁབངྒ་ལ་ཁབོད་ཁབྷོས་ནི་ཡཱན་ཁཀེ་ཊ་ལཱན་ཁཅེཀ" +
			"་ཁཝེལཤ་ཁཌེ་ནིཤ་ཁཇཱར་མཱན་ཁདི་བེ་ཧི་ཁརྫོང་ཁགྲིཀ་ཁཨིང་ལིཤ་ཁཨེས་པ་རཱན་" +
			"ཏོ་ཁཨིས་པེ་ནིཤ་ཁཨེས་ཊོ་ནི་ཡཱན་ཁབཱསཀ་ཁཔར་ཤི་ཡཱན་ཁཕི་ནིཤ་ཁཕི་ཇི་ཡཱན་" +
			"ཁཕཱ་རོ་ཨིས་ཁཕྲནཅ་ཁནུབ་ཕྼི་སི་ཡན་ཁཨཱའི་རིཤ་ཁགལ་ཨིས་ཨི་ཡན་ཁགུ་ཝ་ར་ནི" +
			"་ཁགུ་ཇ་ར་ཏི་ཁཧཝ་ས་ཁཧེ་བྲུ་ཁཧིན་དི་ཁཀྲོ་ཨེ་ཤི་ཡཱན་ཁཧེ་ཏི་ཡཱན་ཁཧཱང་ག" +
			"ྷ་རི་ཡཱན་ཁཨར་མི་ནི་ཡཱན་ཁཨིན་ཌོ་ནེ་ཤི་ཡཱན་ཁཨིག་བོ་ཁཨ་ཡིས་ལེན་ཌིཀ་ཁཨ" +
			"ི་ཊ་ལི་ཡཱན་ཁཇཱ་པཱ་ནིས་ཁཇཱ་བ་ནིས་ཁཇཽ་ཇི་ཡཱན་ཁཀ་ཛགས་ཁཁེ་མེར་ཁཀ་ན་ཌ་ཁ" +
			"ཀོ་རི་ཡཱན་ཁཀཱཤ་མི་རི་ཁཀར་ཌིཤ་ཁཀིར་གིས་ཁལེ་ཊིན་ཁལག་ཛམ་བོརྒ་ཁལཱ་ཝོས་" +
			"ཁལི་ཐུ་ཝེ་ནི་ཡཱན་ཁལཊ་བི་ཡཱན་ཁམ་ལ་ག་སི་ཁམ་ཨོ་རི་ཁམ་སེ་ཌོ་ནི་ཡཱན་ཁམ་" +
			"ལ་ཡ་ལམ་ཁམ་ར་ཐི་ཁམ་ལེ་ཁམཱལ་ཊ་ཁབར་མིས་ཁནེ་པཱལི་ཁཌཆ་ཁནོར་ཝེ་ཇི་ཡཱན་ནོ" +
			"རསཀ་ཁནོར་ཝེ་ཇི་ཡཱན་བོཀ་མཱལ་ཁཨོ་རི་ཡ་ཁཔཱན་ཇ་བི་ཁཔོ་ལིཤ་ཁཔཱཤ་ཏོ་ཁཔོར" +
			"་ཅུ་གིས་ཁཀྭེ་ཆུ་ཨ་ཁརོ་མེ་ནིཤ་ཁརོ་མེ་ནི་ཡཱན་ཁཨུ་རུ་སུའི་ཁསཾསྐྲྀཏ་ཁས" +
			"ིན་དཱི་ཁསིང་ཧ་ལ་ཁསུ་ལོ་བཱཀ་ཁསུ་ལོ་བི་ནི་ཡཱན་ཁསོ་མ་ལི་ཁཨཱལ་བེ་ནི་ཡཱ" +
			"ན་ཁསཱར་བྷི་ཡཱན་ཁསཱུན་ད་ནིས་ཁསུའི་ཌིཤ་ཁསྭཱ་ཧི་ལི་ཁཏ་མིལ་ཁཏེ་ལུ་གུ་ཁ" +
			"ཏ་ཇིཀ་ཁཐཱའི་ཁཏིག་རི་ཉ་ཁཊཱརཀ་མེན་ཁཊོང་གྷན་ཁཊཱར་ཀིཤ་ཁཊ་ཊར་ཁཝི་གུར་ཁཡ" +
			"ུ་ཀེ་རེ་ནི་ཡཱན་ཁཨུར་དུ་ཁཨུས་བེཀ་ཁབེཊ་ནཱ་མིས་ཁཝོ་ལོཕ་ཁཞོ་ས་ཁཡོ་རུ་བ" +
			"་ཁརྒྱ་མི་ཁཟུ་ལུ་ཁད་ཀོ་ཏ་ཁཕི་ལི་པི་ནོ་ཁསུ་ཡིས་ཇཱར་མཱན་ཁཧ་ཝ་ཡིའི་ཁཀ་" +
			"ཆིན་ཁཀོ་རོ་ཁམན་ཇུ་ཁཤཱན་ཁཁ་ངོ་མ་ཤེསཔསྐད་རིག་ནང་དོན་མེདཔཨཱོས་ཊྲི་ཡཱན" +
			"་ཇཱར་མཱན་ཁསུ་ཡིས་གི་མཐོ་སའི་ཇཱར་མཱན་ཁཨཱོས་ཊྲེ་ལི་ཡཱན་ཨིང་ལིཤ་ཁཀེ་ན" +
			"་ཌི་ཡཱན་ཨིང་ལིཤ་ཁབྲི་ཊིཤ་ཨིང་ལིཤ་ཁཡུ་ཨེས་ཨིང་ལིཤ་ཁལེ་ཊིན་ཨ་མེ་རི་ཀ" +
			"ཱན་གི་ཨིས་པེ་ནིཤ་ཁཡུ་རོབ་ཀྱི་ཨིས་པེ་ནིཤ་ཁཀེ་ན་ཌི་ཡཱན་ཕྲནཅ་ཁསུ་ཡིས་" +
			"ཕྲནཅ་ཁཕྷེལེ་མིཤ་ཁབྲ་ཛི་ལི་ཡཱན་པོར་ཅུ་གིས་ཁཨི་བེ་རི་ཡཱན་པོར་ཅུ་གིས་" +
			"ཁརྒྱ་མི་ཁ་འཇམ་སངམསྔ་དུས་ཀྱི་རྒྱ་མི་ཁ",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0012, 0x0036, 0x0036, 0x005a, 0x005a, 0x0078, 0x0078,
			0x0096, 0x00b1, 0x00b1, 0x00b1, 0x00de, 0x00de, 0x00ff, 0x012c,
			0x012c, 0x012c, 0x0141, 0x0150, 0x0150, 0x0177, 0x0195, 0x0195,
			0x0195, 0x0195, 0x0195, 0x01a4, 0x01a4, 0x01a4, 0x01b6, 0x01ce,
			0x01e9, 0x0207, 0x0219, 0x0219, 0x022b, 0x0246, 0x0270, 0x0294,
			0x02c1, 0x02d3, 0x02f4, 0x02f4, 0x030c, 0x032d, 0x034e, 0x0360,
			0x038d, 0x03ab, 0x03ab, 0x03d5, 0x03f6, 0x0417, 0x0417, 0x0429,
			0x0441, 0x0459, 0x0459, 0x0486, 0x04a7, 0x04d4, 0x04fe, 0x04fe,
			// Entry 40 - 7F
			0x04fe, 0x0534, 0x0534, 0x054c, 0x054c, 0x054c, 0x054c, 0x0579,
			0x05a0, 0x05a0, 0x05c1, 0x05df, 0x0600, 0x0600, 0x0600, 0x0600,
			0x0615, 0x0615, 0x062d, 0x0642, 0x0663, 0x0663, 0x0684, 0x069c,
			0x069c, 0x069c, 0x06b7, 0x06cf, 0x06f3, 0x06f3, 0x06f3, 0x06f3,
			0x070b, 0x073e, 0x073e, 0x075f, 0x077d, 0x077d, 0x0798, 0x07c8,
			0x07e6, 0x07e6, 0x07fe, 0x0810, 0x0825, 0x083d, 0x083d, 0x083d,
			0x0858, 0x0858, 0x0864, 0x08a3, 0x08e8, 0x08e8, 0x08e8, 0x08e8,
			0x08e8, 0x08e8, 0x08e8, 0x0903, 0x0903, 0x0921, 0x0921, 0x0939,
			// Entry 80 - BF
			0x0951, 0x0975, 0x0993, 0x09b4, 0x09b4, 0x09de, 0x0a02, 0x0a02,
			0x0a1d, 0x0a1d, 0x0a38, 0x0a38, 0x0a38, 0x0a53, 0x0a74, 0x0aa7,
			0x0aa7, 0x0aa7, 0x0ac2, 0x0aef, 0x0b16, 0x0b16, 0x0b16, 0x0b3a,
			0x0b58, 0x0b79, 0x0b8e, 0x0bac, 0x0bc1, 0x0bd3, 0x0bf1, 0x0c0f,
			0x0c0f, 0x0c2a, 0x0c45, 0x0c45, 0x0c57, 0x0c57, 0x0c6f, 0x0ca2,
			0x0cba, 0x0cd5, 0x0cd5, 0x0cf9, 0x0cf9, 0x0cf9, 0x0d11, 0x0d23,
			0x0d23, 0x0d3e, 0x0d3e, 0x0d56, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			// Entry C0 - FF
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			// Entry 100 - 13F
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d83, 0x0d83, 0x0d83, 0x0d83,
			0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83,
			0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83,
			0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0daa,
			0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa,
			0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa,
			0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa,
			0x0daa, 0x0daa, 0x0dda, 0x0dda, 0x0dda, 0x0dda, 0x0dda, 0x0dda,
			// Entry 140 - 17F
			0x0dda, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8,
			0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8,
			0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0e0d,
			0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d,
			0x0e0d, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			// Entry 180 - 1BF
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			// Entry 1C0 - 1FF
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			// Entry 200 - 23F
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67,
			0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67,
			0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67,
			// Entry 240 - 27F
			0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67,
			0x0ea0, 0x0ea0, 0x0ea0, 0x0ee2, 0x0f33, 0x0f7e, 0x0fbd, 0x0ff0,
			0x1020, 0x1086, 0x10cb, 0x10cb, 0x1101, 0x1128, 0x1149, 0x1194,
			0x11df, 0x11df, 0x11df, 0x120f, 0x1248,
		},
	},
	{ // ebu
		"KĩakanKĩamhariKĩarabuKĩmbelarusiKĩbulgariaKĩbanglaKĩchekiKĩnjeremaniKĩng" +
			"rikiKĩthunguKĩhispaniaKĩanjemiKĩfaransaKĩhausaKĩhindĩKĩhungariKĩindo" +
			"nesiaKĩigboKĩitalianoKĩnjapaniKĩjavaKĩkambodiaKĩkoreaKĩmalesiaKĩburm" +
			"aKĩnepaliKĩholanziKĩpunjabiKĩpolandiKĩrenoKĩromaniaKĩrusiKĩnyarwanda" +
			"KĩsomaliKĩswidiKĩtamilKĩtailandiKĩturukiKĩukraniaKĩurduKĩvietinamuKĩ" +
			"yorubaKĩchinaKĩzuluKĩembu",
		[]uint16{ // 277 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0024, 0x002f,
			0x002f, 0x002f, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x004c, 0x004c, 0x004c, 0x004c, 0x0055, 0x005e, 0x005e, 0x0069,
			0x0069, 0x0069, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x007c,
			0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x0084,
			0x0084, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00bf, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00d1, 0x00d1, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00e3, 0x00e3, 0x00eb, 0x00eb, 0x00eb,
			0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe,
			0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x0108, 0x0108, 0x0112,
			// Entry 80 - BF
			0x0112, 0x0119, 0x0119, 0x0119, 0x0119, 0x0123, 0x012a, 0x0136,
			0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136,
			0x0136, 0x0136, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0163, 0x0163, 0x0163, 0x0163, 0x0163, 0x016d,
			0x0174, 0x0174, 0x0174, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0189, 0x0189, 0x0191, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			// Entry C0 - FF
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			// Entry 100 - 13F
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x019f,
		},
	},
	{ // ee
		"abkhaziagbeafrikaangbeblugbeamhariagbearabiagbeassamegbeaymargbeazerbaij" +
			"angbebelarusiagbebulgariagbebambaragbebengalgbetibetagbebretongbebos" +
			"niagbekatalagbetsɛkgbewalesgbedenmarkgbegermaniagbedivehgbedzongkhag" +
			"beeʋegbegrisigbeyevugbeesperantogbespaniagbeestoniagbebasqugbepersia" +
			"gbefinlanɖgbefidzigbefransegbeirelanɖgbegalatagbeguarangbegujaratiha" +
			"usagbehebrigbehindigbekroatiagbehaitigbehungarigbearmeniagbeindonesi" +
			"agbeigbogbeicelanɖgbeitaliagbedzapangbedzavangbegɔgiagbekazakhstangb" +
			"ekhmergbekannadagbekoreagbekashmirgbekurdiagbekirghistangbelatinlaks" +
			"embɔggbelingalalaogbelithuaniagbelatviagbemalagasegbemaorgbemakedoni" +
			"agbemalayagbemongoliagbemarathiagbemalaygbemaltagbeburmagbedziehe nd" +
			"ebelegbenepalgbehɔlandgbenɔweigbe ninɔsknɔweigbe bokmålnyanjagbeoriy" +
			"agbeossetiagbepundzabgbepolandgbepashtogbepɔtugalgbekwetsuagberomans" +
			"hgberundigberomaniagberɔtsiagberuwandagbesanskrigbesindhgbedziehe sa" +
			"migbesangogbesinhalgbeslovakiagbesloveniagbesamoagbeshonagbesomaliag" +
			"bealbaniagbeserbiagbeswatgbeanyiehe sothogbesudangbeswedengbeswahili" +
			"tamilgbetelegugbetadzikistangbetailandgbetigrinyagbetɛkmengbetswanag" +
			"betongagbetɛkigbetsongagbetahitigbeuighurgbeukraingbeurdugbeuzbekist" +
			"angbevendagbevietnamgbewolofgbexhosagbeyorubagbekinagbezulugbeasagbe" +
			"bembagbebenagbebodogbeembugbeefigbefilipingbeswizerlanɖtɔwo ƒe germa" +
			"niagbehawaigbecape verdegbelahndagbeluyiagbegbegbɔgblɔ sɔgbɔwodziehe" +
			" sothogberombogberwagbesakagbekomorogbetetumgbetok pisigbegbegbɔgblɔ" +
			" manyawalsegbecantongbegbegbɔgblɔ manɔmeeaustriatɔwo ƒe germaniagbes" +
			"wizerlanɖ germaniagbe kɔkɔtɔaustraliatɔwo ƒe yevugbekanadatɔwo ƒe ye" +
			"vugbebritaintɔwo ƒe yevugbeu.s.dukɔmetɔwo ƒe yevugbelatin amerikatɔw" +
			"o ƒe spaniagbeiberiatɔwo ƒe spaniagbekanadatɔwo ƒe fransegbeswizerla" +
			"nɖtɔwo ƒe fransegbeflemiagbebraziltɔwo ƒe portugalgbeiberiatɔwo ƒe p" +
			"ortugalgbeserbo-croatiagbetsainagbeblema tsainagbe",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000b, 0x000b, 0x0016, 0x001c, 0x0026, 0x0026,
			0x002f, 0x0038, 0x0038, 0x0040, 0x004d, 0x004d, 0x0059, 0x0064,
			0x0064, 0x006e, 0x0077, 0x0080, 0x0089, 0x0092, 0x009b, 0x009b,
			0x009b, 0x009b, 0x009b, 0x00a3, 0x00a3, 0x00a3, 0x00ab, 0x00b5,
			0x00c0, 0x00c8, 0x00d3, 0x00da, 0x00e2, 0x00e9, 0x00f5, 0x00fe,
			0x0108, 0x0110, 0x0119, 0x0119, 0x0124, 0x012c, 0x012c, 0x0135,
			0x0135, 0x0140, 0x0140, 0x0149, 0x0152, 0x015a, 0x015a, 0x0162,
			0x016a, 0x0172, 0x0172, 0x017c, 0x0184, 0x018e, 0x0198, 0x0198,
			// Entry 40 - 7F
			0x0198, 0x01a4, 0x01a4, 0x01ab, 0x01ab, 0x01ab, 0x01ab, 0x01b6,
			0x01bf, 0x01bf, 0x01c8, 0x01d1, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01e7, 0x01e7, 0x01ef, 0x01f9, 0x0201, 0x0201, 0x020b, 0x0214,
			0x0214, 0x0214, 0x0221, 0x0226, 0x0233, 0x0233, 0x0233, 0x023a,
			0x0240, 0x024c, 0x024c, 0x0255, 0x0260, 0x0260, 0x0267, 0x0273,
			0x027c, 0x0287, 0x0292, 0x029a, 0x02a2, 0x02aa, 0x02aa, 0x02bb,
			0x02c3, 0x02c3, 0x02cd, 0x02de, 0x02ef, 0x02ef, 0x02ef, 0x02f8,
			0x02f8, 0x02f8, 0x02f8, 0x0300, 0x030a, 0x0314, 0x0314, 0x031d,
			// Entry 80 - BF
			0x0326, 0x0331, 0x033b, 0x0345, 0x034d, 0x0357, 0x0361, 0x036b,
			0x0375, 0x0375, 0x037d, 0x038b, 0x0393, 0x039c, 0x03a7, 0x03b2,
			0x03ba, 0x03c2, 0x03cc, 0x03d6, 0x03df, 0x03e6, 0x03f6, 0x03fe,
			0x0407, 0x040e, 0x0416, 0x041f, 0x042d, 0x0437, 0x0442, 0x044c,
			0x0455, 0x045d, 0x0465, 0x046e, 0x046e, 0x0477, 0x0480, 0x0489,
			0x0490, 0x049d, 0x04a5, 0x04af, 0x04af, 0x04af, 0x04b7, 0x04bf,
			0x04bf, 0x04c8, 0x04c8, 0x04cf, 0x04d6, 0x04d6, 0x04d6, 0x04d6,
			0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6,
			// Entry C0 - FF
			0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04d6,
			0x04d6, 0x04d6, 0x04d6, 0x04d6, 0x04dc, 0x04dc, 0x04dc, 0x04dc,
			0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc,
			0x04dc, 0x04dc, 0x04e4, 0x04e4, 0x04eb, 0x04eb, 0x04eb, 0x04eb,
			0x04eb, 0x04eb, 0x04eb, 0x04eb, 0x04eb, 0x04eb, 0x04eb, 0x04eb,
			0x04eb, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			// Entry 100 - 13F
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f9, 0x04ff, 0x04ff, 0x04ff,
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0529, 0x0529, 0x0529, 0x0529, 0x0529, 0x0529,
			// Entry 140 - 17F
			0x0529, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531,
			0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531,
			0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531,
			0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x0531, 0x053e,
			0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e,
			0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e,
			0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e, 0x053e,
			0x053e, 0x053e, 0x053e, 0x0547, 0x0547, 0x0547, 0x0547, 0x0547,
			// Entry 180 - 1BF
			0x0547, 0x0547, 0x0547, 0x0547, 0x0547, 0x0547, 0x0547, 0x0547,
			0x0547, 0x0547, 0x0547, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f,
			0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f,
			0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f,
			0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x0565, 0x0565,
			0x0565, 0x0565, 0x0565, 0x0565, 0x0565, 0x0565, 0x0565, 0x0565,
			0x0565, 0x0565, 0x0565, 0x0565, 0x0565, 0x0565, 0x0565, 0x0565,
			0x0565, 0x0565, 0x0565, 0x0565, 0x0574, 0x0574, 0x0574, 0x0574,
			// Entry 1C0 - 1FF
			0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574,
			0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574,
			0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574,
			0x0574, 0x0574, 0x0574, 0x0574, 0x057c, 0x057c, 0x057c, 0x057c,
			0x057c, 0x057c, 0x0582, 0x0582, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			// Entry 200 - 23F
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0592, 0x0592, 0x0592, 0x0592, 0x0592, 0x0592, 0x0592,
			0x0592, 0x0592, 0x059a, 0x059a, 0x059a, 0x059a, 0x059a, 0x059a,
			0x059a, 0x059a, 0x059a, 0x059a, 0x05a5, 0x05a5, 0x05a5, 0x05a5,
			0x05a5, 0x05a5, 0x05a5, 0x05a5, 0x05a5, 0x05a5, 0x05a5, 0x05a5,
			0x05a5, 0x05a5, 0x05b7, 0x05b7, 0x05b7, 0x05b7, 0x05b7, 0x05b7,
			0x05b7, 0x05b7, 0x05b7, 0x05bf, 0x05bf, 0x05bf, 0x05bf, 0x05bf,
			0x05bf, 0x05bf, 0x05bf, 0x05bf, 0x05bf, 0x05bf, 0x05bf, 0x05bf,
			// Entry 240 - 27F
			0x05bf, 0x05c8, 0x05c8, 0x05c8, 0x05c8, 0x05c8, 0x05c8, 0x05c8,
			0x05dd, 0x05dd, 0x05dd, 0x05f9, 0x061a, 0x0634, 0x064b, 0x0663,
			0x067f, 0x069f, 0x06b8, 0x06b8, 0x06d1, 0x06ef, 0x06f8, 0x0713,
			0x072e, 0x072e, 0x073e, 0x0747, 0x0756,
		},
	},
	{ // el
		elLangStr,
		elLangIdx,
	},
	{ // en
		enLangStr,
		enLangIdx,
	},
	{ // en-AU
		"BamumUnited States English",
		[]uint16{ // 593 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 100 - 13F
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 140 - 17F
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 180 - 1BF
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 1C0 - 1FF
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 200 - 23F
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 240 - 27F
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x001a,
		},
	},
	{ // eo
		"afaraabĥazaafrikansatwamharaarabaasamaajmaraazerbajĝanabaŝkirabelorusabu" +
			"lgarabislamobengalatibetabretonabosniakatalunakorsikaĉeĥakimradanage" +
			"rmanamahladzonkogrekaanglaesperantohispanaestonaeŭskapersafinnafiĝia" +
			"feroafrancafrisairlandagaelagalegagvaraniaguĝaratahaŭsahebreahindakr" +
			"oatahaitia kreolahungaraarmenainterlingvaoindoneziaokcidentaloeskima" +
			"islandaitalainuitajapanajavakartvelakazaĥagronlandakmerakanarakoreak" +
			"aŝmirakurdakirgizalatinoluksemburgalingalalaŭalitovalatvamalagasamao" +
			"riamakedonamalajalamamongolamaratamalajamaltabirmanauranepalanederla" +
			"ndanovnorvegadannorvegaokcitanaoromaorijopanĝabapolapaŝtoaportugalak" +
			"eĉuaromanĉaburundarumanarusaruandasanskritosindasangoasinhalaslovaka" +
			"slovenasamoaŝonasomalaalbanaserbasvaziasotasundasvedasvahilatamilate" +
			"luguataĝikatajatigrajaturkmenacvanatongaaturkacongatataraujguraukrai" +
			"naurduouzbekavjetnamavolapukovolofaksosajidajorubaĝuangaĉinazuluaibi" +
			"bioefikafilipinahavajaklingonanekonata lingvonelingvaĵobrazilportuga" +
			"laeŭropportugalaserbo-Kroataĉina simpligitaĉina tradicia",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0005, 0x000c, 0x000c, 0x0015, 0x0017, 0x001d, 0x001d,
			0x0022, 0x0027, 0x0027, 0x002d, 0x0039, 0x0041, 0x0049, 0x0050,
			0x0057, 0x0057, 0x005e, 0x0064, 0x006b, 0x0071, 0x0079, 0x0079,
			0x0079, 0x0080, 0x0080, 0x0086, 0x0086, 0x0086, 0x008b, 0x008f,
			0x0096, 0x009b, 0x00a1, 0x00a1, 0x00a6, 0x00ab, 0x00b4, 0x00bb,
			0x00c1, 0x00c7, 0x00cc, 0x00cc, 0x00d1, 0x00d7, 0x00dc, 0x00e2,
			0x00e7, 0x00ee, 0x00f3, 0x00f9, 0x0101, 0x010a, 0x010a, 0x0110,
			0x0116, 0x011b, 0x011b, 0x0121, 0x012e, 0x0135, 0x013b, 0x013b,
			// Entry 40 - 7F
			0x0147, 0x0150, 0x015b, 0x015b, 0x015b, 0x0161, 0x0161, 0x0168,
			0x016d, 0x0173, 0x0179, 0x017d, 0x0185, 0x0185, 0x0185, 0x0185,
			0x018c, 0x0195, 0x019a, 0x01a0, 0x01a5, 0x01a5, 0x01ad, 0x01b2,
			0x01b2, 0x01b2, 0x01b9, 0x01bf, 0x01ca, 0x01ca, 0x01ca, 0x01d1,
			0x01d6, 0x01dc, 0x01dc, 0x01e1, 0x01e9, 0x01e9, 0x01ef, 0x01f7,
			0x0201, 0x0208, 0x020e, 0x0214, 0x0219, 0x021e, 0x0223, 0x0223,
			0x0229, 0x0229, 0x0233, 0x023d, 0x0247, 0x0247, 0x0247, 0x0247,
			0x024f, 0x024f, 0x0254, 0x0259, 0x0259, 0x0261, 0x0261, 0x0265,
			// Entry 80 - BF
			0x026c, 0x0275, 0x027b, 0x0283, 0x028a, 0x0290, 0x0294, 0x029a,
			0x02a3, 0x02a3, 0x02a8, 0x02a8, 0x02ae, 0x02b5, 0x02bc, 0x02c3,
			0x02c8, 0x02cd, 0x02d3, 0x02d9, 0x02de, 0x02e4, 0x02e8, 0x02ed,
			0x02f2, 0x02f9, 0x02ff, 0x0306, 0x030d, 0x0311, 0x0318, 0x0320,
			0x0325, 0x032b, 0x0330, 0x0335, 0x033b, 0x033b, 0x0341, 0x0348,
			0x034d, 0x0353, 0x0353, 0x035b, 0x0363, 0x0363, 0x0369, 0x036e,
			0x0372, 0x0378, 0x037f, 0x0384, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			// Entry C0 - FF
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			// Entry 100 - 13F
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0394, 0x0394, 0x0394,
			0x0394, 0x0394, 0x0394, 0x0394, 0x0394, 0x0394, 0x0394, 0x039c,
			0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			// Entry 140 - 17F
			0x039c, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			// Entry 180 - 1BF
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			// Entry 1C0 - 1FF
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			// Entry 200 - 23F
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03aa,
			0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa,
			0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa,
			0x03aa, 0x03aa, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9,
			0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9,
			0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9,
			// Entry 240 - 27F
			0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9,
			0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4,
			0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03d3,
			0x03e2, 0x03e2, 0x03ee, 0x03fe, 0x040c,
		},
	},
	{ // es
		esLangStr,
		esLangIdx,
	},
	{}, // es-CL
	{ // es-MX
		"bashkir",
		[]uint16{ // 14 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007,
		},
	},
	{ // et
		etLangStr,
		etLangIdx,
	},
	{ // eu
		"abkhazeraafrikaansaakaneraamhareraarabieraassameraaimaraazerbaijanerabas" +
			"hkirrerabielorrusierabulgarierabambarerabengaleratibeterabretoierabo" +
			"snierakatalanakorsikeratxekieragaleseradanieraalemanadivehieradzongk" +
			"haeweeragrezieraingelesaesperantoaespainieraestonieraeuskarapersiera" +
			"finlandierafijierafaroerafrantsesafrisieragaelikoaeskoziako gaelikoa" +
			"galizieraguaranieragujarateramanxerahausahebreerahindiakroazierahait" +
			"ierahungarieraarmenieraInterlinguaindonesierainterlingueigboerasichu" +
			"an yiaislandieraitalierainuiterajaponierajaverageorgieraKikongoakiku" +
			"yuerakazakherakalaallisuterakhemererakannaderakoreerakashmirerakurdu" +
			"erakornubierakirgizeralatinaluxenburgeraganderalingalalaoseralituani" +
			"eraluba-katangeraletonieramalagasyeramaorieramazedonieramalayalamera" +
			"mongolieramaratheramalaysieramalteraburmatarraiparraldeko ndebeleera" +
			"nepaleranederlanderanynorsk norvegierabokmala (Norvegia)nyanjaOkzita" +
			"nieraoromoeraoriyeraosetierapunjaberapolonierapaxtueraportugesaquech" +
			"ueraerromantxerarundieraerrumanieraerrusierakinyaruandasanskritoasin" +
			"dhiaiparraldeko samierasangoerasinhalaeslovakieraeslovenierasamoeras" +
			"honerasomalieraalbanieraserbieraswatierahegoaldeko sothoerasundanera" +
			"suedieraswahilitamileratelugueratajikistanerathailandieratigriñeratu" +
			"rkmenieratswaneratongeraturkieratsongeratatareratahitierauigurrerauk" +
			"raineraurduauzbekeravenderavietnamerawoloferaxhoseraJiddishayorubera" +
			"txinerazulueraAcholieraaghemeramaputxeaasuabemberabenerabodoerachige" +
			"ratxerokierasoranierataiterazarmerabehe-sorabieradualerafonyi jolera" +
			"embuaefikeratagalogaGagagauzeraalemana (Suitza)gusiierahawaiieragoi-" +
			"sorabierangombamachamerakabilerakamberamakonderaCabo Verdeko kreolak" +
			"oyra chiinierakalenjinerakomi-permyakerakonkanierashambalerabafieral" +
			"angieralakoteraLozieraLuba-lulualuoeraluhyeramasaieramerueraMauritan" +
			"iako kreoleramakhuwa-meettoerameteramohawkeramudangerahizkuntza anit" +
			"zaknamerakwasieran’koerapedieranuereraankolerak’iche’raromboerarwaer" +
			"asamburuerasanguerasenerakoyraboro senniatachelhitahegoaldeko samier" +
			"aLule samieraInari samieraSkolt samieraKongoko swahiliatesoeratetuma" +
			"Klingoneratok pisinaTumbukeratasawaqaMaroko erdialdeko tamazightahiz" +
			"kuntza ezezagunavaieravunjoasogeratamazight estandarraez dago eduki " +
			"linguistikorikarabiera moderno estandarraaleman garaia (Suitza)ingel" +
			"esa (AEB)espainiera (Europa)flandrieraportugesa (Europa)serbokroazie" +
			"ratxinera soilduatxinera tradizionala",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0009, 0x0009, 0x0013, 0x001a, 0x0022, 0x0022,
			0x002a, 0x0032, 0x0032, 0x0038, 0x0045, 0x0050, 0x005d, 0x0067,
			0x0067, 0x0070, 0x0079, 0x0081, 0x008a, 0x0092, 0x009a, 0x009a,
			0x009a, 0x00a3, 0x00a3, 0x00ab, 0x00ab, 0x00ab, 0x00b3, 0x00ba,
			0x00c1, 0x00ca, 0x00d2, 0x00d8, 0x00e0, 0x00e8, 0x00f2, 0x00fc,
			0x0105, 0x010c, 0x0114, 0x0114, 0x011f, 0x0126, 0x012d, 0x0136,
			0x013e, 0x0146, 0x0158, 0x0161, 0x016b, 0x0175, 0x017c, 0x0181,
			0x0189, 0x018f, 0x018f, 0x0198, 0x01a0, 0x01aa, 0x01b3, 0x01b3,
			// Entry 40 - 7F
			0x01be, 0x01c9, 0x01d4, 0x01db, 0x01e6, 0x01e6, 0x01e6, 0x01f0,
			0x01f8, 0x0200, 0x0209, 0x020f, 0x0218, 0x0220, 0x0229, 0x0229,
			0x0232, 0x0240, 0x0249, 0x0252, 0x0259, 0x0259, 0x0263, 0x026b,
			0x026b, 0x0275, 0x027e, 0x0284, 0x0290, 0x0297, 0x0297, 0x029e,
			0x02a5, 0x02af, 0x02bd, 0x02c6, 0x02d1, 0x02d1, 0x02d9, 0x02e4,
			0x02f0, 0x02fa, 0x0303, 0x030d, 0x0314, 0x031e, 0x031e, 0x0334,
			0x033c, 0x033c, 0x0348, 0x035a, 0x036c, 0x036c, 0x036c, 0x0372,
			0x037d, 0x037d, 0x0385, 0x038c, 0x0394, 0x039d, 0x039d, 0x03a6,
			// Entry 80 - BF
			0x03ae, 0x03b7, 0x03c0, 0x03cc, 0x03d4, 0x03df, 0x03e8, 0x03f3,
			0x03fd, 0x03fd, 0x0404, 0x0417, 0x041f, 0x0426, 0x0431, 0x043c,
			0x0443, 0x044a, 0x0453, 0x045c, 0x0464, 0x046c, 0x047f, 0x0488,
			0x0490, 0x0497, 0x049f, 0x04a8, 0x04b5, 0x04c1, 0x04cb, 0x04d6,
			0x04de, 0x04e5, 0x04ed, 0x04f5, 0x04fd, 0x0506, 0x050f, 0x0518,
			0x051d, 0x0525, 0x052c, 0x0536, 0x0536, 0x0536, 0x053e, 0x0545,
			0x054d, 0x0555, 0x0555, 0x055c, 0x0563, 0x0563, 0x056c, 0x056c,
			0x056c, 0x056c, 0x056c, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574,
			// Entry C0 - FF
			0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x057c, 0x057c, 0x057c,
			0x057c, 0x057c, 0x057c, 0x057c, 0x0580, 0x0580, 0x0580, 0x0580,
			0x0580, 0x0580, 0x0580, 0x0580, 0x0580, 0x0580, 0x0580, 0x0580,
			0x0580, 0x0580, 0x0587, 0x0587, 0x058d, 0x058d, 0x058d, 0x058d,
			0x058d, 0x058d, 0x058d, 0x058d, 0x058d, 0x058d, 0x058d, 0x058d,
			0x058d, 0x0594, 0x0594, 0x0594, 0x0594, 0x0594, 0x0594, 0x0594,
			0x0594, 0x0594, 0x0594, 0x0594, 0x0594, 0x059b, 0x059b, 0x059b,
			0x059b, 0x059b, 0x059b, 0x059b, 0x059b, 0x05a5, 0x05a5, 0x05ae,
			// Entry 100 - 13F
			0x05ae, 0x05ae, 0x05ae, 0x05ae, 0x05ae, 0x05ae, 0x05b5, 0x05b5,
			0x05b5, 0x05b5, 0x05b5, 0x05bc, 0x05bc, 0x05ca, 0x05ca, 0x05d1,
			0x05d1, 0x05dd, 0x05dd, 0x05dd, 0x05e2, 0x05e9, 0x05e9, 0x05e9,
			0x05e9, 0x05e9, 0x05e9, 0x05e9, 0x05e9, 0x05e9, 0x05e9, 0x05f1,
			0x05f1, 0x05f1, 0x05f1, 0x05f1, 0x05f1, 0x05f1, 0x05f1, 0x05f1,
			0x05f1, 0x05f3, 0x05fc, 0x05fc, 0x05fc, 0x05fc, 0x05fc, 0x05fc,
			0x05fc, 0x05fc, 0x05fc, 0x05fc, 0x05fc, 0x05fc, 0x05fc, 0x05fc,
			0x05fc, 0x05fc, 0x060c, 0x060c, 0x060c, 0x0614, 0x0614, 0x0614,
			// Entry 140 - 17F
			0x0614, 0x061d, 0x061d, 0x061d, 0x061d, 0x061d, 0x062a, 0x062a,
			0x062a, 0x062a, 0x062a, 0x062a, 0x062a, 0x062a, 0x062a, 0x062a,
			0x0630, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x0641, 0x0641,
			0x0641, 0x0648, 0x0648, 0x0648, 0x0648, 0x0648, 0x0651, 0x0664,
			0x0664, 0x0664, 0x0664, 0x0664, 0x0664, 0x0673, 0x0673, 0x0673,
			0x0673, 0x067e, 0x067e, 0x068d, 0x0697, 0x0697, 0x0697, 0x0697,
			0x0697, 0x0697, 0x0697, 0x0697, 0x06a1, 0x06a8, 0x06a8, 0x06a8,
			0x06a8, 0x06a8, 0x06b0, 0x06b0, 0x06b0, 0x06b0, 0x06b0, 0x06b0,
			// Entry 180 - 1BF
			0x06b0, 0x06b8, 0x06b8, 0x06b8, 0x06bf, 0x06bf, 0x06c9, 0x06c9,
			0x06c9, 0x06cf, 0x06cf, 0x06d6, 0x06d6, 0x06d6, 0x06d6, 0x06d6,
			0x06d6, 0x06d6, 0x06d6, 0x06d6, 0x06de, 0x06de, 0x06de, 0x06de,
			0x06de, 0x06e5, 0x06fa, 0x06fa, 0x070b, 0x0711, 0x0711, 0x0711,
			0x0711, 0x0711, 0x071a, 0x071a, 0x071a, 0x0723, 0x0734, 0x0734,
			0x0734, 0x0734, 0x0734, 0x0734, 0x0734, 0x0734, 0x0734, 0x0734,
			0x073a, 0x073a, 0x073a, 0x073a, 0x073a, 0x073a, 0x0742, 0x0742,
			0x0742, 0x0742, 0x0742, 0x074b, 0x0752, 0x0759, 0x0759, 0x0759,
			// Entry 1C0 - 1FF
			0x0761, 0x0761, 0x0761, 0x0761, 0x0761, 0x0761, 0x0761, 0x0761,
			0x0761, 0x0761, 0x0761, 0x0761, 0x0761, 0x0761, 0x0761, 0x0761,
			0x0761, 0x0761, 0x0761, 0x0761, 0x0761, 0x076e, 0x076e, 0x076e,
			0x076e, 0x076e, 0x076e, 0x076e, 0x0776, 0x0776, 0x0776, 0x0776,
			0x0776, 0x0776, 0x077c, 0x077c, 0x077c, 0x077c, 0x0786, 0x0786,
			0x0786, 0x0786, 0x0786, 0x078e, 0x078e, 0x078e, 0x078e, 0x078e,
			0x0794, 0x0794, 0x0794, 0x07a4, 0x07a4, 0x07a4, 0x07ae, 0x07ae,
			0x07ae, 0x07ae, 0x07ae, 0x07ae, 0x07c0, 0x07cc, 0x07d9, 0x07e6,
			// Entry 200 - 23F
			0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6, 0x07e6,
			0x07e6, 0x07e6, 0x07f6, 0x07f6, 0x07f6, 0x07f6, 0x07f6, 0x07f6,
			0x07fd, 0x07fd, 0x0803, 0x0803, 0x0803, 0x0803, 0x0803, 0x080d,
			0x080d, 0x080d, 0x080d, 0x080d, 0x0817, 0x0817, 0x0817, 0x0817,
			0x0817, 0x0817, 0x0820, 0x0820, 0x0828, 0x0828, 0x0844, 0x0844,
			0x0844, 0x0844, 0x0857, 0x085d, 0x085d, 0x085d, 0x085d, 0x085d,
			0x085d, 0x085d, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863,
			0x0863, 0x0863, 0x0863, 0x0869, 0x0869, 0x0869, 0x0869, 0x0869,
			// Entry 240 - 27F
			0x0869, 0x0869, 0x0869, 0x0869, 0x0869, 0x0869, 0x087d, 0x087d,
			0x0899, 0x0899, 0x08b4, 0x08b4, 0x08ca, 0x08ca, 0x08ca, 0x08ca,
			0x08d8, 0x08d8, 0x08eb, 0x08eb, 0x08eb, 0x08eb, 0x08f5, 0x08f5,
			0x0907, 0x0907, 0x0915, 0x0924, 0x0938,
		},
	},
	{ // ewo
		"Ǹkɔ́bɔ akánǸkɔ́bɔ amáriaǸkɔ́bɔ arábiaǸkɔ́bɔ belarúsianǸkɔ́bɔ buləgárianǸ" +
			"kɔ́bɔ bɛngalíǸkɔ́bɔ tsɛ́gǸkɔ́bɔ ndzámanǸkɔ́bɔ gəlɛ́gǸkɔ́bɔ éngəlísǹk" +
			"ɔ́bɔ kpənyáǹkɔ́bɔ fɛ́rəsianǸkɔ́bɔ fulɛnsíǸkɔ́bɔ aúsáǸkɔ́bɔ hindíǸkɔ" +
			"́bɔ ungáríanǸkɔ́bɔ ɛndonésianǸkɔ́bɔ ibóǸkɔ́bɔ etáliɛnǸkɔ́bɔ hapɔ́nǸ" +
			"kɔ́bɔ havanísǸkɔ́bɔ kəmɛ́rǸkɔ́bɔ koréanǸkɔ́bɔ malɛ́sianǸkɔ́bɔ birəmá" +
			"nǹkɔ́bɔ nefálianǸkɔ́bɔ nɛrəlándíaǹkɔ́bɔ funəhábiaǹkɔ́bɔ fólisǹkɔ́bɔ " +
			"fɔtugɛ́sńkɔ́bɔ románíaǹkɔ́bɔ rúsianǹkɔ́bɔ ruwandáǹkɔ́bɔ somáliaǹkɔ́b" +
			"ɔ suwɛ́dǹkɔ́bɔ tamílǹkɔ́bɔ táilanǹkɔ́bɔ túrəkiǹkɔ́bɔ ukeléniaǹkɔ́bɔ" +
			" urudúǹkɔ́bɔ hiɛdənámǹkɔ́bɔ yorúbaǸkɔ́bɔ tsainísǹkɔ́bɔ zulúewondo",
		[]uint16{ // 285 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0022, 0x0022,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x004a, 0x0061,
			0x0061, 0x0061, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x009a, 0x009a, 0x009a, 0x009a, 0x00ae, 0x00c3, 0x00c3, 0x00d6,
			0x00d6, 0x00d6, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0112,
			0x0112, 0x0123, 0x0123, 0x0123, 0x0123, 0x0138, 0x0138, 0x0138,
			// Entry 40 - 7F
			0x0138, 0x014f, 0x014f, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e,
			0x0172, 0x0172, 0x0185, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x01ac, 0x01ac, 0x01be, 0x01be, 0x01be, 0x01be,
			0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be,
			0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be,
			0x01be, 0x01be, 0x01be, 0x01d4, 0x01d4, 0x01e8, 0x01e8, 0x01e8,
			0x01fc, 0x01fc, 0x0215, 0x0215, 0x0215, 0x0215, 0x0215, 0x0215,
			0x0215, 0x0215, 0x0215, 0x0215, 0x0215, 0x022b, 0x022b, 0x023c,
			// Entry 80 - BF
			0x023c, 0x0252, 0x0252, 0x0252, 0x0252, 0x0266, 0x0278, 0x028b,
			0x028b, 0x028b, 0x028b, 0x028b, 0x028b, 0x028b, 0x028b, 0x028b,
			0x028b, 0x028b, 0x029e, 0x029e, 0x029e, 0x029e, 0x029e, 0x029e,
			0x02b1, 0x02b1, 0x02c2, 0x02c2, 0x02c2, 0x02d4, 0x02d4, 0x02d4,
			0x02d4, 0x02d4, 0x02e7, 0x02e7, 0x02e7, 0x02e7, 0x02e7, 0x02fb,
			0x030c, 0x030c, 0x030c, 0x0322, 0x0322, 0x0322, 0x0322, 0x0322,
			0x0322, 0x0334, 0x0334, 0x0347, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			// Entry C0 - FF
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			// Entry 100 - 13F
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x035d,
		},
	},
	{ // fa
		faLangStr,
		faLangIdx,
	},
	{ // fa-AF
		"هسپانویفنلندیآیرلندیکروشیاییاندونیزیاییآیسلندیایتالویجاپانیکوریاییقرغزیم" +
			"غلینیپالیهالندینارویژیپولندیپرتگالیسویدنیتاجکی",
		[]uint16{ // 157 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			// Entry 40 - 7F
			0x0038, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x005c,
			0x006a, 0x006a, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076,
			0x0076, 0x0076, 0x0076, 0x0076, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a2, 0x00a2, 0x00ae, 0x00ae, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00c8,
			// Entry 80 - BF
			0x00c8, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00ec,
		},
	},
	{ // ff
		"AkaanAmarikAarabeereBelaruuseBulgariireBengaliCekkereDocceereGerkeEngele" +
			"ereEspañolPerseerePulaarFarayseereHawsaŋkooreHinndiHongariireEndones" +
			"iireIgibooreItaliyeereSaponeereSawaneereKemeereKoreereMalayeereBurme" +
			"eseNepaaleereDacceerePunjabeerePoloneerePurtugeereRomaneereRiisRuwaa" +
			"nndeereSomaliiSweedeereTamilTaayTurkeereUkereneereUrduWiyetnameereYo" +
			"rrubaaSinuwaareSuluŋkoore",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x000b, 0x000b,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x001d, 0x0027,
			0x0027, 0x0027, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x003d, 0x003d, 0x003d, 0x003d, 0x0042, 0x004b, 0x004b, 0x0053,
			0x0053, 0x0053, 0x005b, 0x0061, 0x0061, 0x0061, 0x0061, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x0077,
			0x0077, 0x007d, 0x007d, 0x007d, 0x007d, 0x0087, 0x0087, 0x0087,
			// Entry 40 - 7F
			0x0087, 0x0092, 0x0092, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x00a4, 0x00a4, 0x00ad, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6,
			0x00b6, 0x00b6, 0x00bd, 0x00bd, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			0x00c4, 0x00c4, 0x00c4, 0x00cd, 0x00cd, 0x00d5, 0x00d5, 0x00d5,
			0x00df, 0x00df, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00f1, 0x00f1, 0x00fa,
			// Entry 80 - BF
			0x00fa, 0x0104, 0x0104, 0x0104, 0x0104, 0x010d, 0x0111, 0x011d,
			0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x011d, 0x011d, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124,
			0x012d, 0x012d, 0x0132, 0x0132, 0x0132, 0x0136, 0x0136, 0x0136,
			0x0136, 0x0136, 0x013e, 0x013e, 0x013e, 0x013e, 0x013e, 0x0148,
			0x014c, 0x014c, 0x014c, 0x0158, 0x0158, 0x0158, 0x0158, 0x0158,
			0x0158, 0x0160, 0x0160, 0x0169, 0x0174,
		},
	},
	{ // fi
		fiLangStr,
		fiLangIdx,
	},
	{ // fil
		filLangStr,
		filLangIdx,
	},
	{ // fo
		"abkhazisktafrískatwiamharisktarabisktassamesisktaymaraazerbaijaniskthvit" +
			"arussisktbulgarsktbambarabengaliskttibetansktbretonsktbosnisktkatala" +
			"nsktkekkisktvalisisktdanskttýsktdivehidzongkhagrikisktensktesperanto" +
			"spansktestlendsktbaskisktpersisktfinsktfidjiansktføroysktfransktvest" +
			"frisiktírsktskotskt gælisktgalisisktguaranigujaritihaussahebraiskthi" +
			"ndikroatiskthaitisktungarsktarmensktinterlinguaindonesisktinterlingu" +
			"eigboíslendsktitalsktjapansktjavanesisktgeorgisktkazakisktkambodjans" +
			"ktkannadakoreansktkashmirisktkurdisktkirgisiktlatínluxemburgisktling" +
			"alalaotisktlitavsktlatvisktmalagasisktmaorisktmakedonsktmalayalammon" +
			"golisktmarathisktmalajisktmaltesisktburmesisktnepalskthollendsktnýno" +
			"rsktnorskt bokmálnyanjaoccitanoriyaossetisktpunjabisktpolsktafghansk" +
			"tportugisisktquechuaromanshrundiromansktrussisktruandasanskritsindhi" +
			"sangosinhalesisktslovakisktslovensktsamoisktshonasomalisktalbansktse" +
			"rbisktswatisktsesothosundanesisktsvensktswahilitamilskttelugiskttaji" +
			"kisktthailendskttigrinyaturkmenskttswanatongansktturkiskttsongatatar" +
			"iskttahitisktuighurukrainskturduuzbekisktvendavietnamesisktwolofxhos" +
			"ajiddisktyorubakinesisktsuluasu (Tanzania)bembabena (Tanzania)bakoss" +
			"ikiembuefikfilipiniskthawaiiansktkapverdisktlahndaolulujiashimaoréte" +
			"tumklingonskttok pisinukjent málkantonesísktserbokroatiskt",
		[]uint16{ // 603 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000a, 0x000a, 0x0012, 0x0015, 0x001e, 0x001e,
			0x0026, 0x0031, 0x0031, 0x0037, 0x0045, 0x0045, 0x0052, 0x005b,
			0x005b, 0x0062, 0x006c, 0x0076, 0x007f, 0x0087, 0x0091, 0x0091,
			0x0091, 0x0091, 0x0091, 0x0099, 0x0099, 0x0099, 0x00a2, 0x00a8,
			0x00ae, 0x00b4, 0x00bc, 0x00bc, 0x00c4, 0x00c9, 0x00d2, 0x00d9,
			0x00e3, 0x00eb, 0x00f3, 0x00f3, 0x00f9, 0x0103, 0x010c, 0x0113,
			0x011e, 0x0124, 0x0134, 0x013d, 0x0144, 0x014c, 0x014c, 0x0152,
			0x015b, 0x0160, 0x0160, 0x0169, 0x0171, 0x0179, 0x0181, 0x0181,
			// Entry 40 - 7F
			0x018c, 0x0197, 0x01a2, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01b0,
			0x01b7, 0x01b7, 0x01bf, 0x01ca, 0x01d3, 0x01d3, 0x01d3, 0x01d3,
			0x01dc, 0x01dc, 0x01e8, 0x01ef, 0x01f8, 0x01f8, 0x0203, 0x020b,
			0x020b, 0x020b, 0x0214, 0x021a, 0x0227, 0x0227, 0x0227, 0x022e,
			0x0236, 0x023e, 0x023e, 0x0246, 0x0251, 0x0251, 0x0259, 0x0263,
			0x026c, 0x0276, 0x0280, 0x0289, 0x0293, 0x029d, 0x029d, 0x029d,
			0x02a5, 0x02a5, 0x02af, 0x02b8, 0x02c6, 0x02c6, 0x02c6, 0x02cc,
			0x02d3, 0x02d3, 0x02d3, 0x02d8, 0x02e1, 0x02eb, 0x02eb, 0x02f1,
			// Entry 80 - BF
			0x02fa, 0x0306, 0x030d, 0x0314, 0x0319, 0x0321, 0x0329, 0x032f,
			0x0337, 0x0337, 0x033d, 0x033d, 0x0342, 0x034e, 0x0358, 0x0361,
			0x0369, 0x036e, 0x0377, 0x037f, 0x0387, 0x038f, 0x0396, 0x03a2,
			0x03a9, 0x03b0, 0x03b8, 0x03c1, 0x03ca, 0x03d5, 0x03dd, 0x03e7,
			0x03ed, 0x03f6, 0x03fe, 0x0404, 0x040d, 0x0416, 0x041c, 0x0425,
			0x0429, 0x0432, 0x0437, 0x0444, 0x0444, 0x0444, 0x0449, 0x044e,
			0x0456, 0x045c, 0x045c, 0x0465, 0x0469, 0x0469, 0x0469, 0x0469,
			0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469,
			// Entry C0 - FF
			0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469,
			0x0469, 0x0469, 0x0469, 0x0469, 0x0477, 0x0477, 0x0477, 0x0477,
			0x0477, 0x0477, 0x0477, 0x0477, 0x0477, 0x0477, 0x0477, 0x0477,
			0x0477, 0x0477, 0x047c, 0x047c, 0x048b, 0x048b, 0x048b, 0x048b,
			0x048b, 0x048b, 0x048b, 0x048b, 0x048b, 0x048b, 0x048b, 0x048b,
			0x048b, 0x048b, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492,
			0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492,
			0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492,
			// Entry 100 - 13F
			0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492,
			0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492, 0x0492,
			0x0492, 0x0492, 0x0492, 0x0492, 0x0498, 0x049c, 0x049c, 0x049c,
			0x049c, 0x049c, 0x049c, 0x049c, 0x049c, 0x049c, 0x049c, 0x04a7,
			0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7,
			0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7,
			0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7,
			0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7,
			// Entry 140 - 17F
			0x04a7, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2,
			0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2,
			0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2,
			0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04b2, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04c3, 0x04c3, 0x04c3, 0x04c3, 0x04c3,
			// Entry 180 - 1BF
			0x04c3, 0x04c3, 0x04c3, 0x04c3, 0x04c3, 0x04c3, 0x04c3, 0x04c3,
			0x04c3, 0x04c3, 0x04c3, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			// Entry 1C0 - 1FF
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			// Entry 200 - 23F
			0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb, 0x04cb,
			0x04cb, 0x04d4, 0x04d4, 0x04d4, 0x04d4, 0x04d4, 0x04d4, 0x04d4,
			0x04d4, 0x04d4, 0x04d9, 0x04d9, 0x04d9, 0x04d9, 0x04d9, 0x04e3,
			0x04e3, 0x04e3, 0x04e3, 0x04e3, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			// Entry 240 - 27F
			0x04f7, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504,
			0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504,
			0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504, 0x0504,
			0x0504, 0x0504, 0x0512,
		},
	},
	{ // fr
		frLangStr,
		frLangIdx,
	},
	{ // fr-CA
		frCALangStr,
		frCALangIdx,
	},
	{ // fur
		"afarabcazianavestanafrikaansamaricaragonêsarapassamêsavaraymaràazerbaija" +
			"nibielorùsbulgarbengalêstibetanbretonbosniaccatalancecenchamorrocors" +
			"creececsclâf de glesiegalêsdanêstodescgrêcinglêsesperantospagnûlesto" +
			"nbascpersianfulahfinlandêsfizianfaroêsfrancêsfrisiangaelic irlandêsg" +
			"aelic scozêsgalizianguaranìgujaratimanxebraichindicravuathaitianongj" +
			"arêsarmenindonesianigboinupiaqidoislandêstalianinuktitutgjaponêsgjeo" +
			"rgjiankazackalaallisutkhmerkannadacoreancurdcornualiêslatinlussembur" +
			"ghêslimburghêslingalalaolituanletonmalagasymaorimacedonmalayalammong" +
			"ulmarathimalêsmaltêsndebele setentrionâlnepalêsolandêsnorvegjês nyno" +
			"rsknorvegjês bokmålnavajoocitanoriyaoseticpunjabipolacpashtoportughê" +
			"squechuarumançromenrussanscritsardegnûlsindhisami setentrionâlsangos" +
			"inalêsslovacslovensamoansomalalbanêsserpswatisotho meridionâlsundanê" +
			"ssvedêsswahilitamiltelegutagicthaiturcmenturctartartahitianuigurucra" +
			"inurduuzbecvendavietnamitevalonwolofxhosayiddishyorubacinêszuluvieri" +
			" inglêsaramaicasturiancopticsclâfvieri egjizianfilipinvieri francêsf" +
			"urlangoticvieri grêcladinlenghis multiplismirandêsnapoletanbas todes" +
			"cvieri norvegjêssotho setentrionâlturc otomanpapiamentovieri persian" +
			"vieri provenzâlsicilianscozêsvieri irlandêssumerictetumindeterminade" +
			"todesc de Austriealt todesc de Svuizareinglês australianinglês canad" +
			"êsinglês britanicingles merecanspagnûl de Americhe Latinespagnûl ib" +
			"ericfrancês dal Canadefrancês de Svuizareflamantportughês brasilianp" +
			"ortughês ibericmoldâfcinês semplificâtcinês tradizionâl",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000c, 0x0013, 0x001c, 0x001c, 0x0022, 0x002b,
			0x002f, 0x0037, 0x003b, 0x0042, 0x004d, 0x004d, 0x0056, 0x005c,
			0x005c, 0x005c, 0x0065, 0x006c, 0x0072, 0x0079, 0x0080, 0x0085,
			0x008d, 0x0091, 0x0095, 0x0098, 0x00a8, 0x00a8, 0x00ae, 0x00b4,
			0x00ba, 0x00ba, 0x00ba, 0x00ba, 0x00bf, 0x00c6, 0x00cf, 0x00d7,
			0x00dc, 0x00e0, 0x00e7, 0x00ec, 0x00f6, 0x00fc, 0x0103, 0x010b,
			0x0112, 0x0122, 0x0130, 0x0138, 0x0140, 0x0148, 0x014c, 0x014c,
			0x0152, 0x0157, 0x0157, 0x015e, 0x0165, 0x016e, 0x0173, 0x0173,
			// Entry 40 - 7F
			0x0173, 0x017d, 0x017d, 0x0181, 0x0181, 0x0188, 0x018b, 0x0194,
			0x019a, 0x01a3, 0x01ac, 0x01ac, 0x01b6, 0x01b6, 0x01b6, 0x01b6,
			0x01bb, 0x01c6, 0x01cb, 0x01d2, 0x01d8, 0x01d8, 0x01d8, 0x01dc,
			0x01dc, 0x01e7, 0x01e7, 0x01ec, 0x01fa, 0x01fa, 0x0205, 0x020c,
			0x020f, 0x0215, 0x0215, 0x021a, 0x0222, 0x0222, 0x0227, 0x022e,
			0x0237, 0x023d, 0x0244, 0x024a, 0x0251, 0x0251, 0x0251, 0x0266,
			0x026e, 0x026e, 0x0276, 0x0288, 0x029a, 0x029a, 0x02a0, 0x02a0,
			0x02a6, 0x02a6, 0x02a6, 0x02ab, 0x02b1, 0x02b8, 0x02b8, 0x02bd,
			// Entry 80 - BF
			0x02c3, 0x02cd, 0x02d4, 0x02db, 0x02db, 0x02e0, 0x02e3, 0x02e3,
			0x02eb, 0x02f5, 0x02fb, 0x030d, 0x0312, 0x031a, 0x0320, 0x0326,
			0x032c, 0x032c, 0x0331, 0x0339, 0x033d, 0x0342, 0x0353, 0x035c,
			0x0363, 0x036a, 0x036f, 0x0375, 0x037a, 0x037e, 0x037e, 0x0385,
			0x0385, 0x0385, 0x0389, 0x0389, 0x038f, 0x0397, 0x039c, 0x03a2,
			0x03a6, 0x03ab, 0x03b0, 0x03ba, 0x03ba, 0x03bf, 0x03c4, 0x03c9,
			0x03d0, 0x03d6, 0x03d6, 0x03dc, 0x03e0, 0x03e0, 0x03e0, 0x03e0,
			0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0,
			// Entry C0 - FF
			0x03e0, 0x03e0, 0x03ed, 0x03ed, 0x03f4, 0x03f4, 0x03f4, 0x03f4,
			0x03f4, 0x03f4, 0x03f4, 0x03f4, 0x03f4, 0x03f4, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			// Entry 100 - 13F
			0x0402, 0x0402, 0x0402, 0x0402, 0x0402, 0x0402, 0x0402, 0x0402,
			0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408,
			0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0416,
			0x0416, 0x0416, 0x0416, 0x0416, 0x0416, 0x0416, 0x0416, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x042b, 0x042b, 0x042b, 0x042b,
			0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431,
			0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0436,
			0x0436, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			// Entry 140 - 17F
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			// Entry 180 - 1BF
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0457, 0x0457,
			0x0460, 0x0460, 0x0460, 0x0460, 0x0460, 0x0460, 0x0460, 0x0469,
			0x0469, 0x0473, 0x0473, 0x0473, 0x0473, 0x0473, 0x0473, 0x0473,
			0x0473, 0x0483, 0x0483, 0x0483, 0x0496, 0x0496, 0x0496, 0x0496,
			// Entry 1C0 - 1FF
			0x0496, 0x0496, 0x0496, 0x0496, 0x04a1, 0x04a1, 0x04a1, 0x04a1,
			0x04ab, 0x04ab, 0x04ab, 0x04ab, 0x04ab, 0x04b8, 0x04b8, 0x04b8,
			0x04b8, 0x04b8, 0x04b8, 0x04b8, 0x04c8, 0x04c8, 0x04c8, 0x04c8,
			0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8,
			0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8,
			0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04d0, 0x04d7, 0x04d7, 0x04d7,
			0x04d7, 0x04d7, 0x04d7, 0x04d7, 0x04e6, 0x04e6, 0x04e6, 0x04e6,
			0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6,
			// Entry 200 - 23F
			0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6,
			0x04ed, 0x04ed, 0x04ed, 0x04ed, 0x04ed, 0x04ed, 0x04ed, 0x04ed,
			0x04ed, 0x04ed, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			// Entry 240 - 27F
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			0x04ff, 0x04ff, 0x04ff, 0x0510, 0x0526, 0x0538, 0x0548, 0x0558,
			0x0566, 0x0581, 0x0590, 0x0590, 0x05a3, 0x05b7, 0x05be, 0x05d2,
			0x05e3, 0x05ea, 0x05ea, 0x05fd, 0x0610,
		},
	},
	{ // fy
		"AfarAbchazyskAvestyskAfrikaanskAkanAmhaarskAragoneeskArabyskAssameeskAva" +
			"ryskAymaraAzerbeidzjaanskBasjkierskWyt-RussyskBulgaarskBislamaBambar" +
			"aBengaalskTibetaanskBretonskBosnyskKatalaanskTsjetsjeenskChamorroKor" +
			"sikaanskCreeTsjechyskKerkslavyskTsjoevasjyskWelskDeenskDútskDivehiDz" +
			"ongkhaEweGryksIngelskEsperantoSpaanskEstlânskBaskyskPerzyskFulahFins" +
			"kFijyskFaeröerskFrânskWest-FryskIerskSchotsk GaelicGalisyskGuaraníGu" +
			"jaratiManksHausaHebreeuwskHindiHiri MotuKroatyskHaïtiaanskHongaarskA" +
			"rmeenskHereroInterlinguaYndonezyskInterlingueIgboSichuan YiInupiaqId" +
			"oYslânsItaliaanskInuktitutJapansJavaanskGeorgyskKongoKikuyuKuanyamaK" +
			"azachsGrienlânsKhmerKannadaKoreaanskKanuriKasjmiriKoerdyskKomiCornis" +
			"hKirgizyskLatynLuxemburgsGandaLimburgsLingalaLaotiaanskLitouwsLuba-K" +
			"atangaLetlânsMalagasyskMarshalleesMaoriMacedonyskMalayalamMongoolsMa" +
			"rathiMaleisMalteesBirmeesNauruaanskNoard-NdbeleNepaleesNdongaNederlâ" +
			"nskNoors - NynorskNoors - BokmålSûd-NdbeleNavajoNyanjaOccitaanskOjib" +
			"waOromoOdiaOssetyskPunjabiPaliPoalskPasjtoePortugeeskQuechuaReto-Rom" +
			"aanskKirundiRoemeenskRussyskKinyarwandaSanskrietSardinyskSindhiNoard" +
			"-SamyskSangoSingaleesSlowaaksSloveenskSamoaanskShonaSomalyskAlbanees" +
			"kServyskSwaziSûd-SothoSoendaneeskZweedsSwahiliTamilTeluguTadzjieksTh" +
			"aisTigrinyaTurkmeensTswanaTongaanskTurksTsongaTataarsTahityskOeigoer" +
			"sOekraïensUrduOezbeeksVendaVietnameesVolapükWaalsWolofXhosaJiddyskYo" +
			"rubaZhuangSineeskZuluAtjeeskAkoliAdangmeAdygheAfrihiliAghemAinuAkkad" +
			"yskAleutSûd-AltaïskâldingelskAngikaArameeskAraukaanskArapahoArawakAs" +
			"uAsturyskAwadhiBaloetsjyskBalineeskBasaBamounGhomala’BejaBembaBenaBa" +
			"futBhojpuriBikolBiniKomSiksikaBrajBodoAkooseBuriatBugineeskBuluBlinM" +
			"edumbaKaddoKaribyskCayugaAtsamCebuanoChigaChibchaChagataiChuukeeskMa" +
			"riChinook-jargonChoctawChipewyanCherokeeCheyenneSoranîKoptyskKrim-Ta" +
			"taarskKasjoebyskDakotaDargwaTaitaDelawareSlaveDogribDinkaZarmaDogriN" +
			"edersorbyskDualaMiddelnederlânskJola-FonyiDyulaDazagaEmbuEfikAldegyp" +
			"tyskEkajukElamityskMiddelingelskEwondoFangFilipynskFonMiddelfrânskAl" +
			"dfrânskNoard-FryskEast-FryskFriulyskGaGayoGbayaGeezGilberteeskMiddel" +
			"heechdútskAlsheechdútskGondiGorontaloGothyskGreboAldgryksSwitsers Dú" +
			"tskGusiiGwichʼinHaidaHawaïaanskHiligaynonHettityskHmongOppersorbyskH" +
			"upaIbanIbibioIlokoIngoesjLojbanNgombaMachameJudeo-PerzyskJudeo-Araby" +
			"skKarakalpaksKabyleKachinJjuKambaKawiKabardyskKanembuTyapMakondeKaap" +
			"verdysk CreoolsKoroKhasiKhotaneeskKoyra ChiiniKakoKalenjinKimbunduKo" +
			"nkaniKosraeaanskKpelleKarachay-BalkarKarelyskKurukhShambalaBafiaKöls" +
			"chKoemuksKutenaiLadinoLangiLahndaLambaLezgyskLakotaMongoLoziLuba-Lul" +
			"uaLuisenoLundaLuoLushaiLuyiaMadureesMafaMagahiMaithiliMakassaarsMand" +
			"ingoMasaiMabaMokshaMandarMendeMeruMorisyenMiddeliersMakhuwa-MeettoMe" +
			"ta’Mi’kmaqMinangkabauMantsjoeManipoeriMohawkMossiMundangMeardere tal" +
			"enCreekMirandeesMarwariMyeneErzjaNapolitaanskNamaLaagduitsNewariNias" +
			"NiueaanskNgumbaNgiemboonNogaiAldnoarskN’koNoard-SothoNuerKlassiek Ne" +
			"wariNyamweziNyankoleNyoroNzimaOsageOttomaansk-TurksPangasinanPahlavi" +
			"PampangaPapiamentsPalauaanskAldperzyskFoenisyskPohnpeiaanskAldproven" +
			"çaalsRajasthaniRapanuiRarotonganRomboRomaniAromaniaanskRwaSandaweJa" +
			"koetsSamaritaansk-ArameeskSamburuSasakSantaliNgambaySanguSiciliaansk" +
			"SchotsSenecaSenaSelkupKoyraboro SenniAldyrskTashelhiytShanTsjadysk A" +
			"rabyskSidamoSûd-SamyskLule SamiInari SamiSkolt SamiSoninkeSogdyskSra" +
			"nantongoSererSahoSukumaSoesoeSoemeryskShimaoreCongo SwahiliKlassiek " +
			"SyryskSyryskTimneTesoTerenoTetunTigreTivTokelausKlingonTlingitTamash" +
			"ekNyasa TongaTok PisinTarokoTsimshianToemboekaTuvaluaanskTasawaqTuvi" +
			"nyskTamazight (Sintraal-Marokko)OedmoertsOegarityskUmbunduRootVaiVot" +
			"yskVunjoWalserWalamoWarayWashoKalmykSogaYaoYapeesYangbenYembaKantone" +
			"eskZapotecBlissymbolenZenagaStandert Marokkaanske TamazightZuniGjin " +
			"linguïstyske ynhâldZazaModern standert ArabyskEastenryks DútskSwitse" +
			"rsk HeechdútskAustralysk IngelskKanadeesk IngelskBritsk IngelskAmeri" +
			"kaansk IngelskLatynsk-Amerikaansk SpaanskEuropeesk SpaanskMeksikaans" +
			"k SpaanskKanadeesk FrânskSwitserse FrânskVlaamsBrazyljaansk Portugee" +
			"sEuropees PortugeesMoldavyskServokroatyskFerienfâldich SineeskTradis" +
			"joneel Sineesk",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0015, 0x001f, 0x0023, 0x002b, 0x0035,
			0x003c, 0x0045, 0x004c, 0x0052, 0x0061, 0x006b, 0x0076, 0x007f,
			0x0086, 0x008d, 0x0096, 0x00a0, 0x00a8, 0x00af, 0x00b9, 0x00c5,
			0x00cd, 0x00d8, 0x00dc, 0x00e5, 0x00f0, 0x00fc, 0x0101, 0x0107,
			0x010d, 0x0113, 0x011b, 0x011e, 0x0123, 0x012a, 0x0133, 0x013a,
			0x0143, 0x014a, 0x0151, 0x0156, 0x015b, 0x0161, 0x016b, 0x0172,
			0x017c, 0x0181, 0x018f, 0x0197, 0x019f, 0x01a7, 0x01ac, 0x01b1,
			0x01bb, 0x01c0, 0x01c9, 0x01d1, 0x01dc, 0x01e5, 0x01ed, 0x01f3,
			// Entry 40 - 7F
			0x01fe, 0x0208, 0x0213, 0x0217, 0x0221, 0x0228, 0x022b, 0x0232,
			0x023c, 0x0245, 0x024b, 0x0253, 0x025b, 0x0260, 0x0266, 0x026e,
			0x0275, 0x027f, 0x0284, 0x028b, 0x0294, 0x029a, 0x02a2, 0x02aa,
			0x02ae, 0x02b5, 0x02be, 0x02c3, 0x02cd, 0x02d2, 0x02da, 0x02e1,
			0x02eb, 0x02f2, 0x02fe, 0x0306, 0x0310, 0x031b, 0x0320, 0x032a,
			0x0333, 0x033b, 0x0342, 0x0348, 0x034f, 0x0356, 0x0360, 0x036c,
			0x0374, 0x037a, 0x0385, 0x0394, 0x03a3, 0x03ae, 0x03b4, 0x03ba,
			0x03c4, 0x03ca, 0x03cf, 0x03d3, 0x03db, 0x03e2, 0x03e6, 0x03ec,
			// Entry 80 - BF
			0x03f3, 0x03fd, 0x0404, 0x0411, 0x0418, 0x0421, 0x0428, 0x0433,
			0x043c, 0x0445, 0x044b, 0x0457, 0x045c, 0x0465, 0x046d, 0x0476,
			0x047f, 0x0484, 0x048c, 0x0495, 0x049c, 0x04a1, 0x04ab, 0x04b6,
			0x04bc, 0x04c3, 0x04c8, 0x04ce, 0x04d7, 0x04dc, 0x04e4, 0x04ed,
			0x04f3, 0x04fc, 0x0501, 0x0507, 0x050e, 0x0516, 0x051e, 0x0528,
			0x052c, 0x0534, 0x0539, 0x0543, 0x054b, 0x0550, 0x0555, 0x055a,
			0x0561, 0x0567, 0x056d, 0x0574, 0x0578, 0x057f, 0x0584, 0x058b,
			0x0591, 0x0591, 0x0599, 0x059e, 0x05a2, 0x05aa, 0x05aa, 0x05af,
			// Entry C0 - FF
			0x05af, 0x05bc, 0x05c7, 0x05cd, 0x05d5, 0x05df, 0x05df, 0x05e6,
			0x05e6, 0x05ec, 0x05ec, 0x05ec, 0x05ef, 0x05ef, 0x05f7, 0x05f7,
			0x05fd, 0x05fd, 0x0608, 0x0611, 0x0611, 0x0615, 0x061b, 0x061b,
			0x0625, 0x0629, 0x062e, 0x062e, 0x0632, 0x0637, 0x0637, 0x063f,
			0x0644, 0x0648, 0x0648, 0x064b, 0x0652, 0x0652, 0x0652, 0x0656,
			0x0656, 0x065a, 0x0660, 0x0666, 0x066f, 0x0673, 0x0677, 0x067e,
			0x0683, 0x068b, 0x0691, 0x0696, 0x069d, 0x06a2, 0x06a9, 0x06b1,
			0x06ba, 0x06be, 0x06cc, 0x06d3, 0x06dc, 0x06e4, 0x06ec, 0x06f3,
			// Entry 100 - 13F
			0x06fa, 0x06fa, 0x0707, 0x0711, 0x0717, 0x071d, 0x0722, 0x072a,
			0x072f, 0x0735, 0x073a, 0x073f, 0x0744, 0x0750, 0x0750, 0x0755,
			0x0766, 0x0770, 0x0775, 0x077b, 0x077f, 0x0783, 0x0783, 0x078e,
			0x0794, 0x079d, 0x07aa, 0x07aa, 0x07b0, 0x07b0, 0x07b4, 0x07bd,
			0x07bd, 0x07c0, 0x07c0, 0x07cd, 0x07d7, 0x07d7, 0x07e2, 0x07ec,
			0x07f4, 0x07f6, 0x07f6, 0x07f6, 0x07fa, 0x07ff, 0x07ff, 0x0803,
			0x080e, 0x080e, 0x081f, 0x082d, 0x082d, 0x0832, 0x083b, 0x0842,
			0x0847, 0x084f, 0x085e, 0x085e, 0x085e, 0x0863, 0x086c, 0x0871,
			// Entry 140 - 17F
			0x0871, 0x087c, 0x087c, 0x0886, 0x088f, 0x0894, 0x08a0, 0x08a0,
			0x08a4, 0x08a8, 0x08ae, 0x08b3, 0x08ba, 0x08ba, 0x08ba, 0x08c0,
			0x08c6, 0x08cd, 0x08da, 0x08e7, 0x08e7, 0x08f2, 0x08f8, 0x08fe,
			0x0901, 0x0906, 0x090a, 0x0913, 0x091a, 0x091e, 0x0925, 0x0938,
			0x0938, 0x093c, 0x093c, 0x0941, 0x094b, 0x0957, 0x0957, 0x0957,
			0x095b, 0x0963, 0x096b, 0x096b, 0x0972, 0x097d, 0x0983, 0x0992,
			0x0992, 0x0992, 0x099a, 0x09a0, 0x09a8, 0x09ad, 0x09b4, 0x09bb,
			0x09c2, 0x09c8, 0x09cd, 0x09d3, 0x09d8, 0x09df, 0x09df, 0x09df,
			// Entry 180 - 1BF
			0x09df, 0x09e5, 0x09e5, 0x09ea, 0x09ee, 0x09ee, 0x09f8, 0x09ff,
			0x0a04, 0x0a07, 0x0a0d, 0x0a12, 0x0a12, 0x0a12, 0x0a1a, 0x0a1e,
			0x0a24, 0x0a2c, 0x0a36, 0x0a3e, 0x0a43, 0x0a47, 0x0a4d, 0x0a53,
			0x0a58, 0x0a5c, 0x0a64, 0x0a6e, 0x0a7c, 0x0a83, 0x0a8c, 0x0a97,
			0x0a9f, 0x0aa8, 0x0aae, 0x0ab3, 0x0ab3, 0x0aba, 0x0ac8, 0x0acd,
			0x0ad6, 0x0add, 0x0add, 0x0ae2, 0x0ae7, 0x0ae7, 0x0ae7, 0x0af3,
			0x0af7, 0x0b00, 0x0b06, 0x0b0a, 0x0b13, 0x0b13, 0x0b19, 0x0b22,
			0x0b27, 0x0b30, 0x0b30, 0x0b36, 0x0b41, 0x0b45, 0x0b54, 0x0b5c,
			// Entry 1C0 - 1FF
			0x0b64, 0x0b69, 0x0b6e, 0x0b73, 0x0b83, 0x0b8d, 0x0b94, 0x0b9c,
			0x0ba6, 0x0bb0, 0x0bb0, 0x0bb0, 0x0bb0, 0x0bba, 0x0bba, 0x0bc3,
			0x0bc3, 0x0bc3, 0x0bcf, 0x0bcf, 0x0bde, 0x0bde, 0x0bde, 0x0be8,
			0x0bef, 0x0bf9, 0x0bf9, 0x0bf9, 0x0bfe, 0x0c04, 0x0c04, 0x0c04,
			0x0c04, 0x0c10, 0x0c13, 0x0c1a, 0x0c21, 0x0c36, 0x0c3d, 0x0c42,
			0x0c49, 0x0c49, 0x0c50, 0x0c55, 0x0c60, 0x0c66, 0x0c66, 0x0c6c,
			0x0c70, 0x0c70, 0x0c76, 0x0c85, 0x0c8c, 0x0c8c, 0x0c96, 0x0c9a,
			0x0caa, 0x0cb0, 0x0cb0, 0x0cb0, 0x0cbb, 0x0cc4, 0x0cce, 0x0cd8,
			// Entry 200 - 23F
			0x0cdf, 0x0ce6, 0x0cf1, 0x0cf6, 0x0cfa, 0x0cfa, 0x0d00, 0x0d06,
			0x0d0f, 0x0d17, 0x0d24, 0x0d33, 0x0d39, 0x0d39, 0x0d39, 0x0d3e,
			0x0d42, 0x0d48, 0x0d4d, 0x0d52, 0x0d55, 0x0d5d, 0x0d5d, 0x0d64,
			0x0d6b, 0x0d6b, 0x0d73, 0x0d7e, 0x0d87, 0x0d87, 0x0d8d, 0x0d8d,
			0x0d96, 0x0d96, 0x0d9f, 0x0daa, 0x0db1, 0x0db9, 0x0dd5, 0x0dde,
			0x0de8, 0x0def, 0x0df3, 0x0df6, 0x0df6, 0x0df6, 0x0df6, 0x0df6,
			0x0dfc, 0x0dfc, 0x0e01, 0x0e07, 0x0e0d, 0x0e12, 0x0e17, 0x0e17,
			0x0e17, 0x0e1d, 0x0e1d, 0x0e21, 0x0e24, 0x0e2a, 0x0e31, 0x0e36,
			// Entry 240 - 27F
			0x0e36, 0x0e40, 0x0e47, 0x0e53, 0x0e53, 0x0e59, 0x0e78, 0x0e7c,
			0x0e96, 0x0e9a, 0x0eb1, 0x0ec2, 0x0ed7, 0x0ee9, 0x0efa, 0x0f08,
			0x0f1b, 0x0f36, 0x0f47, 0x0f5a, 0x0f6b, 0x0f7c, 0x0f82, 0x0f98,
			0x0faa, 0x0fb3, 0x0fc0, 0x0fd6, 0x0fea,
		},
	},
	{ // ga
		"AfáirisAbcáisisAivéistisAfracáinisAcáinisAmáirisAragóinisAraibisAsaimisA" +
			"váirisAidhmirisAsarbaiseáinisBaiscírisBealarúisisBulgáirisBioslaimis" +
			"BeangáilisTibéidisBriotáinisBoisnisCatalóinisSisinisSeamóirisCorsaic" +
			"isCraísSeicisSlavais na hEaglaiseSuvaisisBreatnaisDanmhairgisGearmái" +
			"nisDivéihisSeoinicisGréigisBéarlaEsperantoSpáinnisEastóinisBascaisPe" +
			"irsisFuláinisFionlainnisFidsisFaróisFraincisFreaslainnis IartharachG" +
			"aeilgeGaeilge na hAlbanGailísisGuaráinisGúisearáitisManainnisHásaisE" +
			"abhraisHiondúisMotúis HíríCróitisCriól HáítíochUngáirisAirméinisHeir" +
			"éirisInterlinguaIndinéisisInterlingueÍogbóisIniúipiaicisIdoÍoslainn" +
			"isIodáilisIonúitisSeapáinisIáivisSeoirsisCongóisCiocúisCuainiáimisCa" +
			"saicisKalaallisutCiméirisCannadaisCóiréisCanúirisCaismírisCoirdisCoi" +
			"misCoirnisCirgisisLaidinLucsambuirgisLugandaisLiongáilisLaoisisLiotu" +
			"áinisLúba-CataingisLaitvisMalagáisisMairsillisMaoraisMacadóinisMail" +
			"éalaimisMongóilisMaraitisMalaeisMáltaisBurmaisNárúisNdeibéilis an T" +
			"uaiscirtNeipeailisNdongaisOllainnisNua-IoruaisIoruais BokmålNdeibéil" +
			"is an DeiscirtNavachóisSiséivisOcsatáinisÓisibisOraimisOirísisOiséit" +
			"isPuinseáibisPáilisPolainnisPaistisPortaingéilisCeatsuaisRómainisRúi" +
			"ndisRómáinisRúisisCiniaruaindisSanscraitSairdínisSindisSáimis Thuaid" +
			"hSangóisSiolóinisSlóvaicisSlóivéinisSamóisSeoinisSomáilisAlbáinisSei" +
			"rbisSuaisisSeasóitisSundaisSualainnisSvahaílisTamailisTeileagúisTáid" +
			"sícisTéalainnisTigrinisTuircméinisSuáinisTongaisTuircisSongaisTatair" +
			"isTaihítisUigiúirisÚcráinisUrdúisÚisbéiceastáinisVeindisVítneaimisVo" +
			"lapükVallúnaisVolaifisCóisisGiúdaisIarúibisSiuáingisSínisSúlúisAidhn" +
			"iúisAcáidisSean-BhéarlaAramaisMapúitsisAstúirisBailísBaváirisBeimbis" +
			"BuiriáitisBuiginisSeabúáinisMairisSeiricisCoptaisCaisiúibisZarmaisSo" +
			"rbais ÍochtarachMeán-OllainnisSean-ÉigiptisMeán-BhéarlaFilipínisMeán" +
			"-FhraincisSean-FhraincisFreaslainnis an TuaiscirtFriúilisAetóipisMeá" +
			"n-Ard-GhearmáinisSean-Ard-GhearmáinisSean-GhréigisGearmáinis Eilvéis" +
			"eachUaúisHaicéisHaváisHiondúis FhidsíHilgeanóinisHitisMongaisSorbais" +
			" UachtarachHúipisIbibisIongúisIútlainnisCara-ChalpáisConcáinisCairéi" +
			"lisCurúicisLaidínisPuinseáibis IartharachLiogúirisLiovóinisLombairdi" +
			"sMeindisMeán-GhaeilgeManapúirisMóháicisMairis IartharachMioraindéisM" +
			"armhairisGearmáinis ÍochtarachNíobhaisSean-LochlainnisSútúis an Tuai" +
			"scirtSean-PheirsisPrúisisRomainisArómáinisSachaisAramais ShamárachSa" +
			"ntáilisSicilisAlbainisSean-GhaeilgeSáimis LuleSogdánaisSuiméirisSvah" +
			"aílis an ChongóSiricisSiléisisKlingonUdmairtisTeanga AnaithnidVeinéi" +
			"sisPléimeannais IartharachCailmícisCantainisSéalainnisZúinisGan ábha" +
			"r teangeolaíochAraibis ChaighdeánachGearmáinis OstarachArd-Ghearmáin" +
			"is EilvéiseachBéarla AstrálachBéarla CeanadachBéarla BriotanachBéarl" +
			"a MeiriceánachSpáinnis Mheiriceá LaidinighSpáinnis EorpachSpáinnis M" +
			"heicsiceachFraincis CheanadachFraincis EilvéiseachPléimeannaisPortai" +
			"ngéilis na BrasaílePortaingéilis IbéarachMoldáivisSeirbea-ChróitisSí" +
			"nis ShimplitheSínis Thraidisiúnta",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0008, 0x0011, 0x001b, 0x0026, 0x002e, 0x0036, 0x0040,
			0x0047, 0x004e, 0x0056, 0x005f, 0x006e, 0x0078, 0x0084, 0x008e,
			0x0098, 0x0098, 0x00a3, 0x00ac, 0x00b7, 0x00be, 0x00c9, 0x00d0,
			0x00da, 0x00e3, 0x00e9, 0x00ef, 0x0103, 0x010b, 0x0114, 0x011f,
			0x012a, 0x0133, 0x013c, 0x013c, 0x0144, 0x014b, 0x0154, 0x015d,
			0x0167, 0x016e, 0x0175, 0x017e, 0x0189, 0x018f, 0x0196, 0x019e,
			0x01b5, 0x01bc, 0x01cd, 0x01d6, 0x01e0, 0x01ee, 0x01f7, 0x01fe,
			0x0206, 0x020f, 0x021d, 0x0225, 0x0237, 0x0240, 0x024a, 0x0254,
			// Entry 40 - 7F
			0x025f, 0x026a, 0x0275, 0x027e, 0x027e, 0x028b, 0x028e, 0x0299,
			0x02a2, 0x02ab, 0x02b5, 0x02bc, 0x02c4, 0x02cc, 0x02d4, 0x02e0,
			0x02e8, 0x02f3, 0x02fc, 0x0305, 0x030e, 0x0317, 0x0321, 0x0328,
			0x032e, 0x0335, 0x033d, 0x0343, 0x0350, 0x0359, 0x0359, 0x0364,
			0x036b, 0x0376, 0x0385, 0x038c, 0x0397, 0x03a1, 0x03a8, 0x03b3,
			0x03c0, 0x03ca, 0x03d2, 0x03d9, 0x03e1, 0x03e8, 0x03f0, 0x0408,
			0x0412, 0x041a, 0x0423, 0x042e, 0x043d, 0x0454, 0x045e, 0x0467,
			0x0472, 0x047a, 0x0481, 0x0489, 0x0492, 0x049e, 0x04a5, 0x04ae,
			// Entry 80 - BF
			0x04b5, 0x04c3, 0x04cc, 0x04d5, 0x04dd, 0x04e7, 0x04ee, 0x04fb,
			0x0504, 0x050e, 0x0514, 0x0523, 0x052b, 0x0535, 0x053f, 0x054b,
			0x0552, 0x0559, 0x0562, 0x056b, 0x0572, 0x0579, 0x0583, 0x058a,
			0x0594, 0x059e, 0x05a6, 0x05b1, 0x05bc, 0x05c7, 0x05cf, 0x05db,
			0x05e3, 0x05ea, 0x05f1, 0x05f8, 0x0600, 0x0609, 0x0613, 0x061d,
			0x0624, 0x0637, 0x063e, 0x0649, 0x0651, 0x065b, 0x0663, 0x066a,
			0x0672, 0x067b, 0x0685, 0x068b, 0x0693, 0x0693, 0x0693, 0x0693,
			0x0693, 0x0693, 0x0693, 0x0693, 0x069d, 0x06a5, 0x06a5, 0x06a5,
			// Entry C0 - FF
			0x06a5, 0x06a5, 0x06b2, 0x06b2, 0x06b9, 0x06c3, 0x06c3, 0x06c3,
			0x06c3, 0x06c3, 0x06c3, 0x06c3, 0x06c3, 0x06c3, 0x06cc, 0x06cc,
			0x06cc, 0x06cc, 0x06cc, 0x06d3, 0x06dc, 0x06dc, 0x06dc, 0x06dc,
			0x06dc, 0x06dc, 0x06e3, 0x06e3, 0x06e3, 0x06e3, 0x06e3, 0x06e3,
			0x06e3, 0x06e3, 0x06e3, 0x06e3, 0x06e3, 0x06e3, 0x06e3, 0x06e3,
			0x06e3, 0x06e3, 0x06e3, 0x06ee, 0x06f6, 0x06f6, 0x06f6, 0x06f6,
			0x06f6, 0x06f6, 0x06f6, 0x06f6, 0x0702, 0x0702, 0x0702, 0x0702,
			0x0702, 0x0708, 0x0708, 0x0708, 0x0708, 0x0710, 0x0710, 0x0710,
			// Entry 100 - 13F
			0x0717, 0x0717, 0x0717, 0x0722, 0x0722, 0x0722, 0x0722, 0x0722,
			0x0722, 0x0722, 0x0722, 0x0729, 0x0729, 0x073c, 0x073c, 0x073c,
			0x074b, 0x074b, 0x074b, 0x074b, 0x074b, 0x074b, 0x074b, 0x0759,
			0x0759, 0x0759, 0x0767, 0x0767, 0x0767, 0x0767, 0x0767, 0x0771,
			0x0771, 0x0771, 0x0771, 0x0780, 0x078e, 0x078e, 0x07a7, 0x07a7,
			0x07b0, 0x07b0, 0x07b0, 0x07b0, 0x07b0, 0x07b0, 0x07b0, 0x07b9,
			0x07b9, 0x07b9, 0x07cf, 0x07e4, 0x07e4, 0x07e4, 0x07e4, 0x07e4,
			0x07e4, 0x07f2, 0x080a, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810,
			// Entry 140 - 17F
			0x0818, 0x081f, 0x0830, 0x083d, 0x0842, 0x0849, 0x085b, 0x085b,
			0x0862, 0x0862, 0x0868, 0x0868, 0x0870, 0x0870, 0x0870, 0x0870,
			0x0870, 0x0870, 0x0870, 0x0870, 0x087b, 0x0889, 0x0889, 0x0889,
			0x0889, 0x0889, 0x0889, 0x0889, 0x0889, 0x0889, 0x0889, 0x0889,
			0x0889, 0x0889, 0x0889, 0x0889, 0x0889, 0x0889, 0x0889, 0x0889,
			0x0889, 0x0889, 0x0889, 0x0889, 0x0893, 0x0893, 0x0893, 0x0893,
			0x0893, 0x0893, 0x089d, 0x08a6, 0x08a6, 0x08a6, 0x08a6, 0x08a6,
			0x08a6, 0x08af, 0x08af, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08d0,
			// Entry 180 - 1BF
			0x08da, 0x08da, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4,
			0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4,
			0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08e4,
			0x08eb, 0x08eb, 0x08eb, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9,
			0x08f9, 0x0904, 0x090e, 0x090e, 0x091f, 0x091f, 0x091f, 0x091f,
			0x092b, 0x0935, 0x0935, 0x0935, 0x0935, 0x0935, 0x0935, 0x0935,
			0x0935, 0x094c, 0x094c, 0x094c, 0x0955, 0x0955, 0x0955, 0x0955,
			0x0955, 0x0965, 0x0965, 0x0965, 0x097a, 0x097a, 0x097a, 0x097a,
			// Entry 1C0 - 1FF
			0x097a, 0x097a, 0x097a, 0x097a, 0x097a, 0x097a, 0x097a, 0x097a,
			0x097a, 0x097a, 0x097a, 0x097a, 0x097a, 0x0987, 0x0987, 0x0987,
			0x0987, 0x0987, 0x0987, 0x098f, 0x098f, 0x098f, 0x098f, 0x098f,
			0x098f, 0x098f, 0x098f, 0x098f, 0x098f, 0x0997, 0x0997, 0x0997,
			0x0997, 0x09a2, 0x09a2, 0x09a2, 0x09a9, 0x09bb, 0x09bb, 0x09bb,
			0x09c5, 0x09c5, 0x09c5, 0x09c5, 0x09cc, 0x09d4, 0x09d4, 0x09d4,
			0x09d4, 0x09d4, 0x09d4, 0x09d4, 0x09e1, 0x09e1, 0x09e1, 0x09e1,
			0x09e1, 0x09e1, 0x09e1, 0x09e1, 0x09e1, 0x09ed, 0x09ed, 0x09ed,
			// Entry 200 - 23F
			0x09ed, 0x09f7, 0x09f7, 0x09f7, 0x09f7, 0x09f7, 0x09f7, 0x09f7,
			0x0a01, 0x0a01, 0x0a16, 0x0a16, 0x0a1d, 0x0a26, 0x0a26, 0x0a26,
			0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a2d,
			0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d,
			0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a2d, 0x0a36,
			0x0a36, 0x0a36, 0x0a46, 0x0a46, 0x0a50, 0x0a50, 0x0a68, 0x0a68,
			0x0a68, 0x0a68, 0x0a68, 0x0a68, 0x0a68, 0x0a68, 0x0a68, 0x0a68,
			0x0a68, 0x0a72, 0x0a72, 0x0a72, 0x0a72, 0x0a72, 0x0a72, 0x0a72,
			// Entry 240 - 27F
			0x0a72, 0x0a7b, 0x0a7b, 0x0a7b, 0x0a86, 0x0a86, 0x0a86, 0x0a8d,
			0x0aa6, 0x0aa6, 0x0abc, 0x0ad0, 0x0aed, 0x0aff, 0x0b10, 0x0b22,
			0x0b37, 0x0b55, 0x0b66, 0x0b7c, 0x0b8f, 0x0ba4, 0x0bb1, 0x0bcc,
			0x0be4, 0x0bee, 0x0bff, 0x0c10, 0x0c25,
		},
	},
	{ // gd
		"AfarAbchasaisAvestanaisAfraganaisAkanAmtharaisAragonaisArabaisAsamaisAva" +
			"raisAsarbaideànaisBashkirBealaruisisBulgaraisBislamaBambaraBeangaili" +
			"sTibeitisBreatnaisBosnaisCatalanaisDeideanaisChamorroCorsaisSeacaisS" +
			"làbhais na h-EaglaiseCuimrisDanmhairgisGearmailtisDivehiDzongkhaEweG" +
			"reugaisBeurlaEsperantoSpàinntisEastoinisBasgaisFarsaidhFionnlannaisF" +
			"ìdisFàrothaisFraingisFrìoslannais SiarachGaeilgeGàidhligGailìsisGua" +
			"raníGujaratiGaelgHausaEabhraHindisHiri MotuCròthaisisCrìtheol Haidht" +
			"iUngairisAirmeinisInterlinguaInnd-InnsisInterlingueIgboYi SichuanInu" +
			"piaqIdoInnis TìlisEadailtisInuktitutSeapanaisDeàbhanaisCairtbheilisK" +
			"ikuyuCasachaisKalaallisutCmèarKannadaCoirèanaisCaismirisCùrdaisCòrna" +
			"isCìorgasaisLaideannLugsamburgaisGandaLingalaLàthoLiotuainisLuba-Kat" +
			"angaLaitbheisMalagasaisMarshallaisMāoriMasadonaisMalayalamMongolaisM" +
			"arathiMalaidhisMaltaisBurmaisNabhruNdebele ThuathachNeapàilisDuitsis" +
			"Nynorsk na NirribhidhBokmål na NirribhidhNdebele DheasachChichewaOgs" +
			"atanaisOromoOriyaOsseticPanjabiPaliPòlainnisPachtuPortagailisCeatsua" +
			"RumainsKirundiRomàinisRuisisKinyarwandaSanskritSàrdaisSindhiSàmais T" +
			"huathachSangoSinhalaSlòbhacaisSlòbhainisSamothaisShonaSomàilisAlbàin" +
			"isSèirbisLeasotach DheasachCànan SundaSuainisKiswahiliTaimilisTelugu" +
			"TaidigisTàidhTigrinyaTurcmanaisTongaisTurcaisTsongaTataraisÙigiurais" +
			"UcràinisÙrduUsbagaisVendaBhiet-NamaisVolapükWolofXhosaIùdhaisIorubaS" +
			"ìnisZuluArabais ThuiniseachAghemAleutaisSeann-BheurlaAramaisMapuche" +
			"Arabais AildireachArabais MhorocachArabais ÈipheiteachAsuCainnt-shan" +
			"ais na h-AimeireagaAstùraisAsarbaideànais DheasachBaluchìBembaBenaBo" +
			"doChigaCherokeeCùrdais SoranîCoptaisTurcais ChriomachCaisiubaisTaita" +
			"ZarmaSòrbais ÌochdarachDualaMeadhan-DhuitsisJola-FonyiEmbuÈipheitis " +
			"ÀrsaidhElamaisMeadhan-BheurlaFilipinisMeadhan-FhraingisSeann-Fhrain" +
			"gisFrìoslannais ThuathachFrìoslannais EarachFriùilisGagauzGe’ezCirib" +
			"easaisMeadhan-Àrd-GearmailtisSeann-Àrd-GearmailtisGotaisGreugais Àrs" +
			"aidhGearmailtis EilbheiseachGusiiCànan Hawai’iHindis FhìditheachSòrb" +
			"ais UachdarachBeurla Crìtheolach DiameugaNgombaMachamePeirsis Iùdhac" +
			"hArabais IùdhachKabyleKambaMakondeKabuverdianuKoyra ChiiniKalenjinKo" +
			"mi-PermyakKonkaniShambalaBafiaLadinoLangiLiogùraisLakhótaLombardaisL" +
			"uoLuyiaSìnis an LitreachaisMaasaiMeruMorisyenMeadhan-GhaeilgeMakhuwa" +
			"-MeettoMeta’MohawkMundangIomadh cànanNamaKwasioSeann-LochlannaisN’Ko" +
			"Leasotais ThuathachNuerNyankoleTurcais OtomanachPalabhaisGearmailtis" +
			" PhennsylvaniaSeann-PheirsisPruisisK’iche’Rapa NuiRomboRomanaisRwaSa" +
			"chaisAramais ShamaritanachSamburuSanguSisilisAlbaisSenaKoyraboro Sen" +
			"niSeann-GhaeilgeTachelhitArabais SeàdachSàmais DheasachSàmais LuleSà" +
			"mais InariSàmais SkoltSoninkeComoraisKiswahili na CongoSuraidheac Ch" +
			"lasaigeachSuraidheacTesoTetumTokelauNyasa TongaTok PisinTasawaqTamaz" +
			"ight Meadhan na h-AtlasCànan neo-aithnichteVaiFlannrais SiarachVunjo" +
			"SogaCantonaisTamazight Stannardach MorocoSusbaint nach eil ‘na chàna" +
			"nNuadh-Arabais StannardachGearmailtis na h-OstaireÀrd-Ghearmailtis n" +
			"a h-EilbheiseBeurla AstràiliaBeurla ChanadaBeurla BhreatainnBeurla n" +
			"a h-AimeireagaSpàinntis na h-Aimeireaga LaidinneachSpàinntis Eòrpach" +
			"Spàinntis MheagsagachFraingis ChanadaFraingis EilbheiseachFlannraisP" +
			"ortagailis BhraisileachPortagailis EòrpachMoldobhaisSìnis Shimplicht" +
			"eSìnis Thradaiseanta",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0017, 0x0021, 0x0025, 0x002e, 0x0037,
			0x003e, 0x0045, 0x004c, 0x004c, 0x005b, 0x0062, 0x006d, 0x0076,
			0x007d, 0x0084, 0x008e, 0x0096, 0x009f, 0x00a6, 0x00b0, 0x00ba,
			0x00c2, 0x00c9, 0x00c9, 0x00d0, 0x00e7, 0x00e7, 0x00ee, 0x00f9,
			0x0104, 0x010a, 0x0112, 0x0115, 0x011d, 0x0123, 0x012c, 0x0136,
			0x013f, 0x0146, 0x014e, 0x014e, 0x015a, 0x0160, 0x016a, 0x0172,
			0x0187, 0x018e, 0x0197, 0x01a0, 0x01a8, 0x01b0, 0x01b5, 0x01ba,
			0x01c0, 0x01c6, 0x01cf, 0x01da, 0x01eb, 0x01f3, 0x01fc, 0x01fc,
			// Entry 40 - 7F
			0x0207, 0x0212, 0x021d, 0x0221, 0x022b, 0x0232, 0x0235, 0x0241,
			0x024a, 0x0253, 0x025c, 0x0267, 0x0273, 0x0273, 0x0279, 0x0279,
			0x0282, 0x028d, 0x0293, 0x029a, 0x02a5, 0x02a5, 0x02ae, 0x02b6,
			0x02b6, 0x02be, 0x02c9, 0x02d1, 0x02de, 0x02e3, 0x02e3, 0x02ea,
			0x02f0, 0x02fa, 0x0306, 0x030f, 0x0319, 0x0324, 0x032a, 0x0334,
			0x033d, 0x0346, 0x034d, 0x0356, 0x035d, 0x0364, 0x036a, 0x037b,
			0x0385, 0x0385, 0x038c, 0x03a1, 0x03b6, 0x03c6, 0x03c6, 0x03ce,
			0x03d8, 0x03d8, 0x03dd, 0x03e2, 0x03e9, 0x03f0, 0x03f4, 0x03fe,
			// Entry 80 - BF
			0x0404, 0x040f, 0x0416, 0x041d, 0x0424, 0x042d, 0x0433, 0x043e,
			0x0446, 0x044e, 0x0454, 0x0465, 0x046a, 0x0471, 0x047c, 0x0487,
			0x0490, 0x0495, 0x049e, 0x04a7, 0x04af, 0x04af, 0x04c1, 0x04cd,
			0x04d4, 0x04dd, 0x04e5, 0x04eb, 0x04f3, 0x04f9, 0x0501, 0x050b,
			0x050b, 0x0512, 0x0519, 0x051f, 0x0527, 0x0527, 0x0531, 0x053a,
			0x053f, 0x0547, 0x054c, 0x0558, 0x0560, 0x0560, 0x0565, 0x056a,
			0x0572, 0x0578, 0x0578, 0x057e, 0x0582, 0x0582, 0x0582, 0x0582,
			0x0582, 0x0595, 0x0595, 0x059a, 0x059a, 0x059a, 0x059a, 0x05a2,
			// Entry C0 - FF
			0x05a2, 0x05a2, 0x05af, 0x05af, 0x05b6, 0x05bd, 0x05bd, 0x05bd,
			0x05cf, 0x05cf, 0x05e0, 0x05f4, 0x05f7, 0x0615, 0x061e, 0x061e,
			0x061e, 0x0636, 0x063e, 0x063e, 0x063e, 0x063e, 0x063e, 0x063e,
			0x063e, 0x063e, 0x0643, 0x0643, 0x0647, 0x0647, 0x0647, 0x0647,
			0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647,
			0x0647, 0x064b, 0x064b, 0x064b, 0x064b, 0x064b, 0x064b, 0x064b,
			0x064b, 0x064b, 0x064b, 0x064b, 0x064b, 0x0650, 0x0650, 0x0650,
			0x0650, 0x0650, 0x0650, 0x0650, 0x0650, 0x0658, 0x0658, 0x0668,
			// Entry 100 - 13F
			0x066f, 0x066f, 0x0680, 0x068a, 0x068a, 0x068a, 0x068f, 0x068f,
			0x068f, 0x068f, 0x068f, 0x0694, 0x0694, 0x06a8, 0x06a8, 0x06ad,
			0x06bd, 0x06c7, 0x06c7, 0x06c7, 0x06cb, 0x06cb, 0x06cb, 0x06de,
			0x06de, 0x06e5, 0x06f4, 0x06f4, 0x06f4, 0x06f4, 0x06f4, 0x06fd,
			0x06fd, 0x06fd, 0x06fd, 0x070e, 0x071d, 0x071d, 0x0734, 0x0748,
			0x0751, 0x0751, 0x0757, 0x0757, 0x0757, 0x0757, 0x0757, 0x075e,
			0x0769, 0x0769, 0x0781, 0x0797, 0x0797, 0x0797, 0x0797, 0x079d,
			0x079d, 0x07ae, 0x07c6, 0x07c6, 0x07c6, 0x07cb, 0x07cb, 0x07cb,
			// Entry 140 - 17F
			0x07cb, 0x07db, 0x07ee, 0x07ee, 0x07ee, 0x07ee, 0x0801, 0x0801,
			0x0801, 0x0801, 0x0801, 0x0801, 0x0801, 0x0801, 0x081d, 0x081d,
			0x0823, 0x082a, 0x083a, 0x084a, 0x084a, 0x084a, 0x0850, 0x0850,
			0x0850, 0x0855, 0x0855, 0x0855, 0x0855, 0x0855, 0x085c, 0x0868,
			0x0868, 0x0868, 0x0868, 0x0868, 0x0868, 0x0874, 0x0874, 0x0874,
			0x0874, 0x087c, 0x087c, 0x0888, 0x088f, 0x088f, 0x088f, 0x088f,
			0x088f, 0x088f, 0x088f, 0x088f, 0x0897, 0x089c, 0x089c, 0x089c,
			0x089c, 0x08a2, 0x08a7, 0x08a7, 0x08a7, 0x08a7, 0x08a7, 0x08b1,
			// Entry 180 - 1BF
			0x08b1, 0x08b9, 0x08c3, 0x08c3, 0x08c3, 0x08c3, 0x08c3, 0x08c3,
			0x08c3, 0x08c6, 0x08c6, 0x08cb, 0x08e0, 0x08e0, 0x08e0, 0x08e0,
			0x08e0, 0x08e0, 0x08e0, 0x08e0, 0x08e6, 0x08e6, 0x08e6, 0x08e6,
			0x08e6, 0x08ea, 0x08f2, 0x0902, 0x0910, 0x0917, 0x0917, 0x0917,
			0x0917, 0x0917, 0x091d, 0x091d, 0x091d, 0x0924, 0x0931, 0x0931,
			0x0931, 0x0931, 0x0931, 0x0931, 0x0931, 0x0931, 0x0931, 0x0931,
			0x0935, 0x0935, 0x0935, 0x0935, 0x0935, 0x0935, 0x093b, 0x093b,
			0x093b, 0x094c, 0x094c, 0x0952, 0x0965, 0x0969, 0x0969, 0x0969,
			// Entry 1C0 - 1FF
			0x0971, 0x0971, 0x0971, 0x0971, 0x0982, 0x0982, 0x0982, 0x0982,
			0x0982, 0x098b, 0x098b, 0x09a4, 0x09a4, 0x09b2, 0x09b2, 0x09b2,
			0x09b2, 0x09b2, 0x09b2, 0x09b9, 0x09b9, 0x09c4, 0x09c4, 0x09c4,
			0x09cc, 0x09cc, 0x09cc, 0x09cc, 0x09d1, 0x09d9, 0x09d9, 0x09d9,
			0x09d9, 0x09d9, 0x09dc, 0x09dc, 0x09e3, 0x09f8, 0x09ff, 0x09ff,
			0x09ff, 0x09ff, 0x09ff, 0x0a04, 0x0a0b, 0x0a11, 0x0a11, 0x0a11,
			0x0a15, 0x0a15, 0x0a15, 0x0a24, 0x0a32, 0x0a32, 0x0a3b, 0x0a3b,
			0x0a4b, 0x0a4b, 0x0a4b, 0x0a4b, 0x0a5b, 0x0a67, 0x0a74, 0x0a81,
			// Entry 200 - 23F
			0x0a88, 0x0a88, 0x0a88, 0x0a88, 0x0a88, 0x0a88, 0x0a88, 0x0a88,
			0x0a88, 0x0a90, 0x0aa2, 0x0ab9, 0x0ac3, 0x0ac3, 0x0ac3, 0x0ac3,
			0x0ac7, 0x0ac7, 0x0acc, 0x0acc, 0x0acc, 0x0ad3, 0x0ad3, 0x0ad3,
			0x0ad3, 0x0ad3, 0x0ad3, 0x0ade, 0x0ae7, 0x0ae7, 0x0ae7, 0x0ae7,
			0x0ae7, 0x0ae7, 0x0ae7, 0x0ae7, 0x0aee, 0x0aee, 0x0b0a, 0x0b0a,
			0x0b0a, 0x0b0a, 0x0b1f, 0x0b22, 0x0b22, 0x0b22, 0x0b33, 0x0b33,
			0x0b33, 0x0b33, 0x0b38, 0x0b38, 0x0b38, 0x0b38, 0x0b38, 0x0b38,
			0x0b38, 0x0b38, 0x0b38, 0x0b3c, 0x0b3c, 0x0b3c, 0x0b3c, 0x0b3c,
			// Entry 240 - 27F
			0x0b3c, 0x0b45, 0x0b45, 0x0b45, 0x0b45, 0x0b45, 0x0b61, 0x0b61,
			0x0b80, 0x0b80, 0x0b99, 0x0bb1, 0x0bd1, 0x0be2, 0x0bf0, 0x0c01,
			0x0c17, 0x0c3d, 0x0c50, 0x0c66, 0x0c76, 0x0c8b, 0x0c94, 0x0cac,
			0x0cc0, 0x0cca, 0x0cca, 0x0cdc, 0x0cf0,
		},
	},
	{ // gl
		"abkhazoafrikaansakánamáricoaragonésárabeassamésaimaráacerbaixanobaskirbi" +
			"elorrusobúlgarobambarabengalítibetanobretónbosniocataláncorsochecoes" +
			"lavo eclesiásticogalésdinamarquésalemándivehidzongkhaewégregoinglése" +
			"sperantoespañolestonianoéuscaropersafinésfixianofaroésfrancésfrisóni" +
			"rlandésgaélico escocésgalegoguaraníguxaratianomanxhausahebreohindicr" +
			"oatahaitianohúngaroarmeniointerlinguaindonesioiboyi sichuanésislandé" +
			"sitalianoinuitxaponésxavanésxeorxianokongokikuyucasacogroenlandéscam" +
			"bodianokannadacoreanocachemirkurdocórnicoquirguizlatínluxemburguésga" +
			"ndalingalalaotianolituanoluba-katangaletónmalgaxemaorímacedoniomalab" +
			"armongolmarathimalaiomaltésbirmanondebele do nortenepalíholandésnoru" +
			"egués nynorsknoruegués bokmalchewaoccitanooromooriyaosetiopunjabipol" +
			"acopaxtúnportuguésquechuaromancherundiromanésrusoruandéssánscritosin" +
			"dhisami do nortesangocingaléseslovacoeslovenosamoanoshonasomalíalban" +
			"ésserbioswatisesotosondanéssuecoswahilitamiltelugutaxicotailandésti" +
			"griñaturcomanotswanatonganésturcoxitsongatártarotahitianouigurucraín" +
			"ourdúuzbecovendavietnamitawólofxhosayiddishiorubachinészulúacoliaghe" +
			"marameomapucheasuasturianobembabenabodokigacheroquicurdo soranítaita" +
			"zarmabaixo sorabiodualajola-fonyiembuibibioexipcio antigofilipinogag" +
			"agauzgrego antigoalemán suízogusiihawaianoalto sorabiongombamachamek" +
			"abilekambamakondecaboverdianokoyra chiinikalenjinkomi permiokonkanis" +
			"hambalabafialangilakotaloziluba-lulualuoluyiamasaimerucrioulo maurit" +
			"anomakhuwa-meettometa’mohawkmundangvarias linguasnamakwasion’kosesot" +
			"ho sa leboanuernyankolequichéromborwasamburusangusenakoyraboro senni" +
			"tachelhitsaami do sursaami lulesaami inarisaami skoltsuahili congolé" +
			"stesotetúnklingontok pisintumbukatasawaqtamazight marroquí centralli" +
			"ngua descoñecida ou non válidavaivunjosogatamazight de Marrocos está" +
			"ndarsen contido lingüísticoárabe estándar modernoalemán de austriaal" +
			"to alemán suízoinglés australianoinglés canadianoinglés británicoing" +
			"lés dos Estados Unidosespañol latinoamericanocastelánespañol de Méxi" +
			"cofrancés canadianofrancés suízoflamencoportugués brasileiroportugué" +
			"s europeoserbocroatachinés simplificadochinés tradicional",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0007, 0x0007, 0x0010, 0x0015, 0x001d, 0x0026,
			0x002c, 0x0034, 0x0034, 0x003b, 0x0046, 0x004c, 0x0056, 0x005e,
			0x005e, 0x0065, 0x006d, 0x0075, 0x007c, 0x0082, 0x008a, 0x008a,
			0x008a, 0x008f, 0x008f, 0x0094, 0x00a8, 0x00a8, 0x00ae, 0x00ba,
			0x00c1, 0x00c7, 0x00cf, 0x00d3, 0x00d8, 0x00df, 0x00e8, 0x00f0,
			0x00f9, 0x0101, 0x0106, 0x0106, 0x010c, 0x0113, 0x011a, 0x0122,
			0x0129, 0x0132, 0x0143, 0x0149, 0x0151, 0x015c, 0x0160, 0x0165,
			0x016b, 0x0170, 0x0170, 0x0176, 0x017e, 0x0186, 0x018d, 0x018d,
			// Entry 40 - 7F
			0x0198, 0x01a1, 0x01a1, 0x01a4, 0x01b1, 0x01b1, 0x01b1, 0x01ba,
			0x01c2, 0x01c7, 0x01cf, 0x01d7, 0x01e0, 0x01e5, 0x01eb, 0x01eb,
			0x01f1, 0x01fd, 0x0207, 0x020e, 0x0215, 0x0215, 0x021d, 0x0222,
			0x0222, 0x022a, 0x0232, 0x0238, 0x0245, 0x024a, 0x024a, 0x0251,
			0x0259, 0x0260, 0x026c, 0x0272, 0x0279, 0x0279, 0x027f, 0x0288,
			0x028f, 0x0295, 0x029c, 0x02a2, 0x02a9, 0x02b0, 0x02b0, 0x02c0,
			0x02c7, 0x02c7, 0x02d0, 0x02e2, 0x02f3, 0x02f3, 0x02f3, 0x02f8,
			0x0300, 0x0300, 0x0305, 0x030a, 0x0310, 0x0317, 0x0317, 0x031d,
			// Entry 80 - BF
			0x0324, 0x032e, 0x0335, 0x033d, 0x0342, 0x034a, 0x034e, 0x0356,
			0x0360, 0x0360, 0x0366, 0x0373, 0x0378, 0x0381, 0x0389, 0x0391,
			0x0398, 0x039d, 0x03a4, 0x03ac, 0x03b2, 0x03b7, 0x03bd, 0x03c6,
			0x03cb, 0x03d2, 0x03d7, 0x03dd, 0x03e3, 0x03ed, 0x03f5, 0x03fe,
			0x0404, 0x040d, 0x0412, 0x041a, 0x0422, 0x042b, 0x0430, 0x0438,
			0x043d, 0x0443, 0x0448, 0x0452, 0x0452, 0x0452, 0x0458, 0x045d,
			0x0464, 0x046a, 0x046a, 0x0471, 0x0476, 0x0476, 0x047b, 0x047b,
			0x047b, 0x047b, 0x047b, 0x0480, 0x0480, 0x0480, 0x0480, 0x0480,
			// Entry C0 - FF
			0x0480, 0x0480, 0x0480, 0x0480, 0x0486, 0x048d, 0x048d, 0x048d,
			0x048d, 0x048d, 0x048d, 0x048d, 0x0490, 0x0490, 0x0499, 0x0499,
			0x0499, 0x0499, 0x0499, 0x0499, 0x0499, 0x0499, 0x0499, 0x0499,
			0x0499, 0x0499, 0x049e, 0x049e, 0x04a2, 0x04a2, 0x04a2, 0x04a2,
			0x04a2, 0x04a2, 0x04a2, 0x04a2, 0x04a2, 0x04a2, 0x04a2, 0x04a2,
			0x04a2, 0x04a6, 0x04a6, 0x04a6, 0x04a6, 0x04a6, 0x04a6, 0x04a6,
			0x04a6, 0x04a6, 0x04a6, 0x04a6, 0x04a6, 0x04aa, 0x04aa, 0x04aa,
			0x04aa, 0x04aa, 0x04aa, 0x04aa, 0x04aa, 0x04b2, 0x04b2, 0x04bf,
			// Entry 100 - 13F
			0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04c4, 0x04c4,
			0x04c4, 0x04c4, 0x04c4, 0x04c9, 0x04c9, 0x04d6, 0x04d6, 0x04db,
			0x04db, 0x04e5, 0x04e5, 0x04e5, 0x04e9, 0x04ef, 0x04ef, 0x04fd,
			0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0507, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d,
			0x050d, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d,
			0x050d, 0x0519, 0x0527, 0x0527, 0x0527, 0x052c, 0x052c, 0x052c,
			// Entry 140 - 17F
			0x052c, 0x0534, 0x0534, 0x0534, 0x0534, 0x0534, 0x0540, 0x0540,
			0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540,
			0x0546, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x0553, 0x0553,
			0x0553, 0x0558, 0x0558, 0x0558, 0x0558, 0x0558, 0x055f, 0x056b,
			0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x0577, 0x0577, 0x0577,
			0x0577, 0x057f, 0x057f, 0x058a, 0x0591, 0x0591, 0x0591, 0x0591,
			0x0591, 0x0591, 0x0591, 0x0591, 0x0599, 0x059e, 0x059e, 0x059e,
			0x059e, 0x059e, 0x05a3, 0x05a3, 0x05a3, 0x05a3, 0x05a3, 0x05a3,
			// Entry 180 - 1BF
			0x05a3, 0x05a9, 0x05a9, 0x05a9, 0x05ad, 0x05ad, 0x05b7, 0x05b7,
			0x05b7, 0x05ba, 0x05ba, 0x05bf, 0x05bf, 0x05bf, 0x05bf, 0x05bf,
			0x05bf, 0x05bf, 0x05bf, 0x05bf, 0x05c4, 0x05c4, 0x05c4, 0x05c4,
			0x05c4, 0x05c8, 0x05d9, 0x05d9, 0x05e7, 0x05ee, 0x05ee, 0x05ee,
			0x05ee, 0x05ee, 0x05f4, 0x05f4, 0x05f4, 0x05fb, 0x0609, 0x0609,
			0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609,
			0x060d, 0x060d, 0x060d, 0x060d, 0x060d, 0x060d, 0x0613, 0x0613,
			0x0613, 0x0613, 0x0613, 0x0619, 0x0629, 0x062d, 0x062d, 0x062d,
			// Entry 1C0 - 1FF
			0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635,
			0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635,
			0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x063c, 0x063c, 0x063c,
			0x063c, 0x063c, 0x063c, 0x063c, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0644, 0x0644, 0x0644, 0x0644, 0x064b, 0x064b,
			0x064b, 0x064b, 0x064b, 0x0650, 0x0650, 0x0650, 0x0650, 0x0650,
			0x0654, 0x0654, 0x0654, 0x0663, 0x0663, 0x0663, 0x066c, 0x066c,
			0x066c, 0x066c, 0x066c, 0x066c, 0x0678, 0x0682, 0x068d, 0x0698,
			// Entry 200 - 23F
			0x0698, 0x0698, 0x0698, 0x0698, 0x0698, 0x0698, 0x0698, 0x0698,
			0x0698, 0x0698, 0x06a9, 0x06a9, 0x06a9, 0x06a9, 0x06a9, 0x06a9,
			0x06ad, 0x06ad, 0x06b3, 0x06b3, 0x06b3, 0x06b3, 0x06b3, 0x06ba,
			0x06ba, 0x06ba, 0x06ba, 0x06ba, 0x06c3, 0x06c3, 0x06c3, 0x06c3,
			0x06c3, 0x06c3, 0x06ca, 0x06ca, 0x06d1, 0x06d1, 0x06ec, 0x06ec,
			0x06ec, 0x06ec, 0x070e, 0x0711, 0x0711, 0x0711, 0x0711, 0x0711,
			0x0711, 0x0711, 0x0716, 0x0716, 0x0716, 0x0716, 0x0716, 0x0716,
			0x0716, 0x0716, 0x0716, 0x071a, 0x071a, 0x071a, 0x071a, 0x071a,
			// Entry 240 - 27F
			0x071a, 0x071a, 0x071a, 0x071a, 0x071a, 0x071a, 0x0739, 0x0739,
			0x0752, 0x0752, 0x076a, 0x077c, 0x078f, 0x07a2, 0x07b3, 0x07c5,
			0x07df, 0x07f7, 0x0800, 0x0813, 0x0825, 0x0834, 0x083c, 0x0851,
			0x0863, 0x0863, 0x086e, 0x0882, 0x0895,
		},
	},
	{ // gsw
		"AfarAbchasischAvestischAfrikaansAkanAmharischAragonesischArabischAssames" +
			"ischAwarischAymaraAserbaidschanischBaschkirischWiissrussischBulgaari" +
			"schBislamaBambaraBengalischTibeetischBrötoonischBosnischKatalaanisch" +
			"TschetscheenischChamorroKorsischCreeTschechischChileslawischTschuwas" +
			"chischWalisischTänischTüütschMalediivischDschongkhaEweGriechischÄngl" +
			"ischEschperantoSchpanischEestnischBaskischPersischFulFinnischFidschi" +
			"anischFäröischFranzösischFriesischIirischSchottisch-GäälischGalizisc" +
			"hGuaraniGujaratiManx-GäälischHaussaHebräischHindiHiri-MotuKroazischH" +
			"aitischUngarischArmenischHereroInterlinguaIndonesischInterlingueIgbo" +
			"Sezuanischs YiInupiakIdoIisländischItaliänischInukitutJapanischJavan" +
			"ischGeorgischKongolesischKikuyu-SchpraachKwanyamaKasachischGröönländ" +
			"ischKambodschanischKannadaKoreaanischKanuri-SchpraachKaschmirischKur" +
			"dischKomi-SchpraachKornischKirgiisischLatiinLuxemburgischGanda-Schpr" +
			"aachLimburgischLingalaLaozischLitauischLubaLettischMadagassischMarsc" +
			"hallesischMaoriMazedonischMalayalamMongolischMarathiMalaiischMaltesi" +
			"schBirmanischNauruischNord-Ndebele-SchpraachNepalesischNdongaNiderlä" +
			"ndischNorwegisch NynorskNorwegisch BokmålSüüd-Ndebele-SchpraachNavaj" +
			"o-SchpraachChewa-SchpraachOkzitanischOjibwa-SchpraachOromoOrijaOssez" +
			"ischPandschabischPaliPolnischPaschtuPortugiisischQuechuaRätoromanisc" +
			"hRundi-SchpraachRumänischRussischRuandischSanschkritSardischSindhiNo" +
			"rd-SamischSangoSinghalesischSlowakischSlowenischSamoanischSchhonaSom" +
			"aliAlbanischSerbischSwaziSüüd-Sotho-SchpraachSundanesischSchwedischS" +
			"uaheliTamilischTeluguTadschikischThailändischTigrinjaTurkmenischTswa" +
			"na-SchpraachTongaischTürkischTsongaTatarischTahitischUigurischUkrain" +
			"ischUrduUsbekischVenda-SchpraachVietnamesischVolapükWallonischWolofX" +
			"hosaJiddischYorubaZhuangChineesischZuluAcehAcholiAdangmeAdygaiAfrihi" +
			"liAinuAkkadischAleutischSüüd-AltaischAltänglischAngikaAramääischArau" +
			"kanischArapahoArawakAschturianischAwadhiBelutschischBalinesischBasaa" +
			"BedauyeBembaBhodschpuriBikolischBiniBlackfoot-SchpraachBraj-BhakhaBu" +
			"rjatischBugineesischBlinCaddoKariibischAtsamCebuanoTschibtschaTschag" +
			"ataischTrukesischTscheremissischChinookChoctawChipewyanCherokeeCheye" +
			"nneKoptischKrimtatarischKaschubischTakotaTargiinischDelaware-Schpraa" +
			"chSlaveyTogribTinkaTogriNidersorbischTualaMittelniderländischTiulaEf" +
			"ikischAltägyptischEkajukElamischMittelänglischEwondoPangwe-Schpraach" +
			"FilipinoFonMittelfranzösischAltfranzösischNordfriesischOschtfriesisc" +
			"hFriulischGaGayoGbayaGeezGilbertesischMittelhochtüütschAlthochtüütsc" +
			"hGondiMongondouGotischGreboAltgriechischSchwiizertüütschKutchinischH" +
			"aidaHawaiianischHiligaynonischHethitischMiaoObersorbischHupaIbanisch" +
			"IlokanoInguschischLojbanischJüüdisch-PersischJüüdisch-ArabischKaraka" +
			"lpakischKabylischKachin-SchpraachJjuKambaKawiKabardinischTyapKoroKha" +
			"sischSakischKimbundu-SchpraachKonkaniKosraeanischKpelle-SchpraachKar" +
			"atschaiisch-BalkarischKarelischOraon-SchpraachKumükischKutenai-Schpr" +
			"aachLadinoLahndanischLambanischLesgischMongoRotse-SchpraachLuba-Lulu" +
			"aLuiseno-SchpraachLunda-SchpraachLuo-SchpraachLushai-SchpraachMadure" +
			"sischKhottaMaithiliMakassarischManding-SchpraachMassai-SchpraachMoks" +
			"chamordwinischMandaresischMende-SchpraachMittelirischMicmac-Schpraac" +
			"hMinangkabau-SchpraachMandschurischMeithei-SchpraachMohawk-Schpraach" +
			"Mossi-SchpraachMehrschpraachigMuskogee-SchpraachMirandesischMarwaris" +
			"chErzyaNeapolitanischNidertüütschNewarischNias-SchpraachNiue-Schpraa" +
			"chNogaischAltnordischN’KoNord-Sotho-SchpraachAlt-NewariNyamwezi-Schp" +
			"raachNyankoleNyoroNzimaOsage-SchpraachOsmanischPangasinanischMittelp" +
			"ersischPampanggan-SchpraachPapiamentoPalauAltpersischPhönikischPonap" +
			"eanischAltprovenzalischRajasthaniOschterinsel-SchpraachRarotonganisc" +
			"hZigüünerschpraachAromunischSandawe-SchpraachJakutischSamaritanischS" +
			"asakSantaliSizilianischSchottischSelkupischAltirischSchan-SchpraachS" +
			"idamoSüüd-SamischLule-SamischInari-SamischSkolt-SamischSoninke-Schpr" +
			"aachSogdischSrananischSerer-SchpraachSukuma-SchpraachSusuSumerischAl" +
			"tsyrischSyrischTemneTereno-SchpraachTetum-SchpraachTigreTiv-Schpraac" +
			"hTokelauanischKlingonischTlingit-SchpraachTamaseqTsonga-SchpraachNeu" +
			"melanesischTsimshian-SchpraachTumbuka-SchpraachElliceanischTuwinisch" +
			"UdmurtischUgaritischMbundu-SchpraachRootVai-SchpraachWotischWalamo-S" +
			"chpraachWarayWasho-SchpraachKalmückischYao-SchpraachYapesischZapotek" +
			"ischBliss-SymboolZenagaZuni-SchpraachKän schpraachliche InhaltZazaÖs" +
			"chtriichischs TüütschSchwiizer HochtüütschAuschtralischs ÄnglischKan" +
			"adischs ÄnglischBritischs ÄnglischAmerikanischs ÄnglischLatiinamerik" +
			"anischs SchpanischIbeerischs SchpanischKanadischs FranzösischSchwiiz" +
			"er FranzösischFläämischBrasilianischs PortugiisischIberischs Portugi" +
			"isischMoldawischSerbo-KroatischVeräifachts ChineesischTradizionells " +
			"Chineesisch",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000e, 0x0017, 0x0020, 0x0024, 0x002d, 0x0039,
			0x0041, 0x004c, 0x0054, 0x005a, 0x006b, 0x0077, 0x0084, 0x008f,
			0x0096, 0x009d, 0x00a7, 0x00b1, 0x00bd, 0x00c5, 0x00d1, 0x00e1,
			0x00e9, 0x00f1, 0x00f5, 0x0100, 0x010d, 0x011b, 0x0124, 0x012c,
			0x0135, 0x0141, 0x014b, 0x014e, 0x0158, 0x0161, 0x016c, 0x0176,
			0x017f, 0x0187, 0x018f, 0x0192, 0x019a, 0x01a7, 0x01b1, 0x01bd,
			0x01c6, 0x01cd, 0x01e2, 0x01eb, 0x01f2, 0x01fa, 0x0209, 0x020f,
			0x0219, 0x021e, 0x0227, 0x0230, 0x0238, 0x0241, 0x024a, 0x0250,
			// Entry 40 - 7F
			0x025b, 0x0266, 0x0271, 0x0275, 0x0283, 0x028a, 0x028d, 0x0299,
			0x02a5, 0x02ad, 0x02b6, 0x02bf, 0x02c8, 0x02d4, 0x02e4, 0x02ec,
			0x02f6, 0x0306, 0x0315, 0x031c, 0x0327, 0x0337, 0x0343, 0x034b,
			0x0359, 0x0361, 0x036c, 0x0372, 0x037f, 0x038e, 0x0399, 0x03a0,
			0x03a8, 0x03b1, 0x03b5, 0x03bd, 0x03c9, 0x03d8, 0x03dd, 0x03e8,
			0x03f1, 0x03fb, 0x0402, 0x040b, 0x0415, 0x041f, 0x0428, 0x043e,
			0x0449, 0x044f, 0x045d, 0x046f, 0x0481, 0x0499, 0x04a9, 0x04b8,
			0x04c3, 0x04d3, 0x04d8, 0x04dd, 0x04e6, 0x04f3, 0x04f7, 0x04ff,
			// Entry 80 - BF
			0x0506, 0x0513, 0x051a, 0x0528, 0x0537, 0x0541, 0x0549, 0x0552,
			0x055c, 0x0564, 0x056a, 0x0576, 0x057b, 0x0588, 0x0592, 0x059c,
			0x05a6, 0x05ad, 0x05b3, 0x05bc, 0x05c4, 0x05c9, 0x05df, 0x05eb,
			0x05f5, 0x05fc, 0x0605, 0x060b, 0x0617, 0x0624, 0x062c, 0x0637,
			0x0647, 0x0650, 0x0659, 0x065f, 0x0668, 0x0671, 0x067a, 0x0684,
			0x0688, 0x0691, 0x06a0, 0x06ad, 0x06b5, 0x06bf, 0x06c4, 0x06c9,
			0x06d1, 0x06d7, 0x06dd, 0x06e8, 0x06ec, 0x06f0, 0x06f6, 0x06fd,
			0x0703, 0x0703, 0x070b, 0x070b, 0x070f, 0x0718, 0x0718, 0x0721,
			// Entry C0 - FF
			0x0721, 0x0730, 0x073c, 0x0742, 0x074e, 0x0759, 0x0759, 0x0760,
			0x0760, 0x0766, 0x0766, 0x0766, 0x0766, 0x0766, 0x0774, 0x0774,
			0x077a, 0x077a, 0x0786, 0x0791, 0x0791, 0x0796, 0x0796, 0x0796,
			0x0796, 0x079d, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07ad,
			0x07b6, 0x07ba, 0x07ba, 0x07ba, 0x07cd, 0x07cd, 0x07cd, 0x07d8,
			0x07d8, 0x07d8, 0x07d8, 0x07e2, 0x07ee, 0x07ee, 0x07f2, 0x07f2,
			0x07f7, 0x0801, 0x0801, 0x0806, 0x080d, 0x080d, 0x0818, 0x0825,
			0x082f, 0x083e, 0x0845, 0x084c, 0x0855, 0x085d, 0x0865, 0x0865,
			// Entry 100 - 13F
			0x086d, 0x086d, 0x087a, 0x0885, 0x088b, 0x0896, 0x0896, 0x08a8,
			0x08ae, 0x08b4, 0x08b9, 0x08b9, 0x08be, 0x08cb, 0x08cb, 0x08d0,
			0x08e4, 0x08e4, 0x08e9, 0x08e9, 0x08e9, 0x08f1, 0x08f1, 0x08fe,
			0x0904, 0x090c, 0x091b, 0x091b, 0x0921, 0x0921, 0x0931, 0x0939,
			0x0939, 0x093c, 0x093c, 0x094e, 0x095d, 0x095d, 0x096a, 0x0978,
			0x0981, 0x0983, 0x0983, 0x0983, 0x0987, 0x098c, 0x098c, 0x0990,
			0x099d, 0x099d, 0x09b0, 0x09c0, 0x09c0, 0x09c5, 0x09ce, 0x09d5,
			0x09da, 0x09e7, 0x09f9, 0x09f9, 0x09f9, 0x09f9, 0x0a04, 0x0a09,
			// Entry 140 - 17F
			0x0a09, 0x0a15, 0x0a15, 0x0a23, 0x0a2d, 0x0a31, 0x0a3d, 0x0a3d,
			0x0a41, 0x0a49, 0x0a49, 0x0a50, 0x0a5b, 0x0a5b, 0x0a5b, 0x0a65,
			0x0a65, 0x0a65, 0x0a78, 0x0a8b, 0x0a8b, 0x0a99, 0x0aa2, 0x0ab2,
			0x0ab5, 0x0aba, 0x0abe, 0x0aca, 0x0aca, 0x0ace, 0x0ace, 0x0ace,
			0x0ace, 0x0ad2, 0x0ad2, 0x0ada, 0x0ae1, 0x0ae1, 0x0ae1, 0x0ae1,
			0x0ae1, 0x0ae1, 0x0af3, 0x0af3, 0x0afa, 0x0b06, 0x0b16, 0x0b2f,
			0x0b2f, 0x0b2f, 0x0b38, 0x0b47, 0x0b47, 0x0b47, 0x0b47, 0x0b51,
			0x0b62, 0x0b68, 0x0b68, 0x0b73, 0x0b7d, 0x0b85, 0x0b85, 0x0b85,
			// Entry 180 - 1BF
			0x0b85, 0x0b85, 0x0b85, 0x0b8a, 0x0b99, 0x0b99, 0x0ba3, 0x0bb4,
			0x0bc3, 0x0bd0, 0x0be0, 0x0be0, 0x0be0, 0x0be0, 0x0beb, 0x0beb,
			0x0bf1, 0x0bf9, 0x0c05, 0x0c16, 0x0c26, 0x0c26, 0x0c38, 0x0c44,
			0x0c53, 0x0c53, 0x0c53, 0x0c5f, 0x0c5f, 0x0c5f, 0x0c6f, 0x0c84,
			0x0c91, 0x0ca2, 0x0cb2, 0x0cc1, 0x0cc1, 0x0cc1, 0x0cd0, 0x0ce2,
			0x0cee, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cfd, 0x0cfd, 0x0cfd, 0x0d0b,
			0x0d0b, 0x0d19, 0x0d22, 0x0d30, 0x0d3e, 0x0d3e, 0x0d3e, 0x0d3e,
			0x0d46, 0x0d51, 0x0d51, 0x0d57, 0x0d6b, 0x0d6b, 0x0d75, 0x0d87,
			// Entry 1C0 - 1FF
			0x0d8f, 0x0d94, 0x0d99, 0x0da8, 0x0db1, 0x0dbf, 0x0dcd, 0x0de1,
			0x0deb, 0x0df0, 0x0df0, 0x0df0, 0x0df0, 0x0dfb, 0x0dfb, 0x0e06,
			0x0e06, 0x0e06, 0x0e12, 0x0e12, 0x0e22, 0x0e22, 0x0e22, 0x0e2c,
			0x0e42, 0x0e50, 0x0e50, 0x0e50, 0x0e50, 0x0e63, 0x0e63, 0x0e63,
			0x0e63, 0x0e6d, 0x0e6d, 0x0e7e, 0x0e87, 0x0e94, 0x0e94, 0x0e99,
			0x0ea0, 0x0ea0, 0x0ea0, 0x0ea0, 0x0eac, 0x0eb6, 0x0eb6, 0x0eb6,
			0x0eb6, 0x0eb6, 0x0ec0, 0x0ec0, 0x0ec9, 0x0ec9, 0x0ec9, 0x0ed8,
			0x0ed8, 0x0ede, 0x0ede, 0x0ede, 0x0eec, 0x0ef8, 0x0f05, 0x0f12,
			// Entry 200 - 23F
			0x0f23, 0x0f2b, 0x0f35, 0x0f44, 0x0f44, 0x0f44, 0x0f54, 0x0f58,
			0x0f61, 0x0f61, 0x0f61, 0x0f6b, 0x0f72, 0x0f72, 0x0f72, 0x0f77,
			0x0f77, 0x0f87, 0x0f96, 0x0f9b, 0x0fa8, 0x0fb5, 0x0fb5, 0x0fc0,
			0x0fd1, 0x0fd1, 0x0fd8, 0x0fe8, 0x0ff6, 0x0ff6, 0x0ff6, 0x0ff6,
			0x1009, 0x1009, 0x101a, 0x1026, 0x1026, 0x102f, 0x102f, 0x1039,
			0x1043, 0x1053, 0x1057, 0x1064, 0x1064, 0x1064, 0x1064, 0x1064,
			0x106b, 0x106b, 0x106b, 0x106b, 0x107b, 0x1080, 0x108f, 0x108f,
			0x108f, 0x109b, 0x109b, 0x109b, 0x10a8, 0x10b1, 0x10b1, 0x10b1,
			// Entry 240 - 27F
			0x10b1, 0x10b1, 0x10bc, 0x10c9, 0x10c9, 0x10cf, 0x10cf, 0x10dd,
			0x10f7, 0x10fb, 0x10fb, 0x1115, 0x112c, 0x1144, 0x1158, 0x116b,
			0x1182, 0x11a0, 0x11b5, 0x11b5, 0x11cc, 0x11e2, 0x11ed, 0x1209,
			0x1220, 0x122a, 0x1239, 0x1251, 0x126a,
		},
	},
	{ // gu
		guLangStr,
		guLangIdx,
	},
	{ // guz
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluEkegusii",
		[]uint16{ // 318 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0171,
		},
	},
	{ // gv
		"Gaelg",
		[]uint16{ // 55 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005,
		},
	},
	{ // ha
		"AkanAmharikLarabciBelarusanciBulgaranciBengaliHarshen CakJamusanciGirkan" +
			"ciTuranciIspaniyanciParisanciFaransanciHausaHarshen HindiHarshen Hun" +
			"gariHarshen IndunusiyaInyamuranciItaliyanciJapananciJabananciHarshen" +
			" KimarHarshen KoreyaHarshen MalaiBurmanciNepaliHolanciPunjabiHarshen" +
			" PolanHarshen PortugalRomaniyanciRashanciKiniyaruwandaSomaliHarshen " +
			"SuwedanTamilThaiHarshen TurkiyyaHarshen YukurenHarshen UrduHarshen B" +
			"iyetinamYarbanciHarshen SinHarshen Zulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x001d, 0x0027,
			0x0027, 0x0027, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0042, 0x0042, 0x0042, 0x0042, 0x004a, 0x0051, 0x0051, 0x005c,
			0x005c, 0x005c, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006f,
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x0074,
			0x0074, 0x0081, 0x0081, 0x0081, 0x0081, 0x0090, 0x0090, 0x0090,
			// Entry 40 - 7F
			0x0090, 0x00a2, 0x00a2, 0x00ad, 0x00ad, 0x00ad, 0x00ad, 0x00ad,
			0x00b7, 0x00b7, 0x00c0, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
			0x00c9, 0x00c9, 0x00d6, 0x00d6, 0x00e4, 0x00e4, 0x00e4, 0x00e4,
			0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4,
			0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4,
			0x00e4, 0x00e4, 0x00e4, 0x00f1, 0x00f1, 0x00f9, 0x00f9, 0x00f9,
			0x00ff, 0x00ff, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x010d, 0x010d, 0x011a,
			// Entry 80 - BF
			0x011a, 0x012a, 0x012a, 0x012a, 0x012a, 0x0135, 0x013d, 0x014a,
			0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
			0x014a, 0x014a, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x015f, 0x015f, 0x0164, 0x0164, 0x0164, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0187,
			0x0193, 0x0193, 0x0193, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4,
			0x01a4, 0x01ac, 0x01ac, 0x01b7, 0x01c3,
		},
	},
	{ // haw
		"ʻAlapiaWaleKenemakaKelemāniaHelenePelekāniaPanioloPīkīPalaniʻAilikiHeber" +
			"aʻĪkāliaKepanīKōleaLākinaMāoriHōlaniPukikīLūkiaKāmoaKuekeneTongaPola" +
			"polaWiekanamaPākēKuikilani KelemāniaʻŌlelo HawaiʻiʻIke ʻole ‘ia a kū" +
			"pono ʻole paha ka ʻōleloPelekāne Nū HōlaniPelekāne KanakāPelekānia P" +
			"ekekānePelekānia ʻAmelikaPalani KanakāKuikilaniPukikī PalakilaPākē H" +
			"oʻomaʻalahi ʻiaPākē Kuʻuna",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x000c, 0x0014,
			0x001e, 0x001e, 0x001e, 0x001e, 0x0024, 0x002e, 0x002e, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003b, 0x003b, 0x0041,
			0x0041, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
			0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f,
			// Entry 40 - 7F
			0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f,
			0x0059, 0x0059, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060,
			0x0060, 0x0060, 0x0060, 0x0060, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x0073, 0x0073,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073,
			0x0073, 0x0073, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a,
			0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a,
			// Entry 80 - BF
			0x007a, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x008d, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0099, 0x0099, 0x0099, 0x0099, 0x00a1, 0x00a1, 0x00a1,
			0x00a1, 0x00a1, 0x00a1, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			// Entry C0 - FF
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			// Entry 100 - 13F
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			// Entry 140 - 17F
			0x00c4, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			// Entry 180 - 1BF
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			// Entry 1C0 - 1FF
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			// Entry 200 - 23F
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			// Entry 240 - 27F
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x011c, 0x012d, 0x0141,
			0x0155, 0x0155, 0x0155, 0x0155, 0x0163, 0x016c, 0x016c, 0x017c,
			0x017c, 0x017c, 0x017c, 0x0196, 0x01a4,
		},
	},
	{ // he
		heLangStr,
		heLangIdx,
	},
	{ // hi
		hiLangStr,
		hiLangIdx,
	},
	{ // hr
		hrLangStr,
		hrLangIdx,
	},
	{ // hsb
		"afaršćinaabchazišćinaafrikaanšćinaakanšćinaamharšćinaaragonšćinaarabšćin" +
			"aasamšćinaawaršćinaaymaršćinaazerbajdźanšćinabaškiršćinaběłorušćinab" +
			"ołharšćinabislamšćinabambarabengalšćinatibetšćinabretonšćinabosnišći" +
			"nakatalanšćinačamoršćinakorsišćinakričěšćinawalizišćinadanšćinaněmči" +
			"nadivehidzongkhaewegrjekšćinajendźelšćinaesperantošpanišćinaestišćin" +
			"abaskišćinapersišćinafinšćinafidźišćinafäröšćinafrancošćinafrizišćin" +
			"airšćinašotiska gelšćinagalicišćinaguaranigujaratimanšćinahausahebre" +
			"jšćinahindišćinachorwatšćinahaitišćinamadźaršćinaarmenšćinainterling" +
			"uaindonešćinaigbosichuan yiinupiakidoislandšćinaitalšćinainuitšćinaj" +
			"apanšćinajavašćinageorgišćinakikuyukazachšćinagröndlandšćinakhmeršći" +
			"nakannadšćinakorejšćinakašmiršćinakurdišćinakornišćinakirgišćinałaćo" +
			"nšćinaluxemburgšćinagandšćinalimburšćinalingalalaošćinalitawšćinalub" +
			"a-katangaletišćinamalagassišćinamaoršćinamakedonšćinamalajamšćinamon" +
			"golšćinamaratišćinamalajšćinamaltašćinaburmašćinanaurušćinasewjero-n" +
			"debelenepalšćinanižozemšćinanorwegšćina (nynorsk)norwegšćina (bokmål" +
			")navahookcitanšćinaoromoorijšćinapandźabšćinapólšćinapaštunšćinaport" +
			"ugalšćinakečuaretoromanšćinakirundišćinarumunšćinarušćinakinjarwanda" +
			"sanskritsardinšćinasindhišćinasewjerosamišćinasangosinghalšćinasłowa" +
			"kšćinasłowjenšćinasamoašćinašonašćinasomališćinaalbanšćinaserbišćina" +
			"siswatijužnosotšćina (Sesotho)sundanezišćinašwedšćinasuahelšćinatami" +
			"lšćinatelugutadźikšćinathailandšćinatigrinšćinaturkmenšćinatswanaton" +
			"gašćinaturkowšćinatsongatataršćinatahitišćinaujguršćinaukrainšćinaur" +
			"dušćinauzbekšćinavietnamšćinavolapükwalonšćinawolofxhosajidišćinajor" +
			"ubašćinazhuangchinšćinazulušćinaaghemšćinaanglosakšćinaarawkanšćinap" +
			"areasturšćinabembabenabodobuginezišćinachigachoctawšćinacherokeesora" +
			"nitaitazarmadelnjoserbšćinadualajola-fonyiembufilipinšćinagagauzišći" +
			"nagotšćinašwicarska němčinagusiihawaiišćinahornjoserbšćinangombamach" +
			"amekabylšćinakambamakondekapverdšćinakoyra chiinikalenjinpermska kom" +
			"išćinakonkanišambalabafialangilakotaluoluhyamasaišćinamerumauriciska" +
			" kreolšćinamakhuwa-meettometa’mohawkšćinamundangkriknamadelnjoněmčin" +
			"akwasion’konuernyankoleprušćinakʼicheʼromborwasamburusangusicilšćina" +
			"senakoyra sennitašelhitjužnosamišćinalule-samišćinainari-samišćinask" +
			"olt-samišćinasaterfrizišćinakongoska suahelšćinatesotasawaqtamazight" +
			" (srjedźny Marokko)njeznata rěčvaivunjosogatamazightžadyn rěčny wobs" +
			"ahmoderna wysokoarabšćinaawstriska němčinašwicarska wysokoněmčinaaws" +
			"tralska jendźelšćinakanadiska jendźelšćinabritiska jendźelšćinaameri" +
			"ska jendźelšćinałaćonskoameriska španišćinaeuropska španišćinamexisk" +
			"a španišćinakanadiska francošćinašwicarska francošćinaflamšćinabrazi" +
			"lska portugalšćinaeuropska portugalšćinamoldawšćinaserbochorwatšćina" +
			"chinšćina (zjednorjena)chinšćina (tradicionalna)",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x000b, 0x0019, 0x0019, 0x0028, 0x0033, 0x003f, 0x004c,
			0x0057, 0x0062, 0x006d, 0x0079, 0x008c, 0x009a, 0x00a9, 0x00b7,
			0x00c4, 0x00cb, 0x00d8, 0x00e4, 0x00f1, 0x00fd, 0x010b, 0x010b,
			0x0118, 0x0124, 0x0127, 0x0132, 0x0132, 0x0132, 0x013f, 0x0149,
			0x0152, 0x0158, 0x0160, 0x0163, 0x016f, 0x017e, 0x0187, 0x0194,
			0x019f, 0x01ab, 0x01b7, 0x01b7, 0x01c1, 0x01ce, 0x01db, 0x01e8,
			0x01f4, 0x01fd, 0x0210, 0x021d, 0x0224, 0x022c, 0x0236, 0x023b,
			0x0248, 0x0254, 0x0254, 0x0262, 0x026e, 0x027c, 0x0288, 0x0288,
			// Entry 40 - 7F
			0x0293, 0x02a0, 0x02a0, 0x02a4, 0x02ae, 0x02b5, 0x02b8, 0x02c5,
			0x02d0, 0x02dc, 0x02e8, 0x02f3, 0x0300, 0x0300, 0x0306, 0x0306,
			0x0313, 0x0324, 0x0330, 0x033d, 0x0349, 0x0349, 0x0357, 0x0363,
			0x0363, 0x036f, 0x037b, 0x0389, 0x0399, 0x03a4, 0x03b1, 0x03b8,
			0x03c2, 0x03ce, 0x03da, 0x03e5, 0x03f5, 0x03f5, 0x0400, 0x040e,
			0x041c, 0x0429, 0x0436, 0x0442, 0x044e, 0x045a, 0x0466, 0x0475,
			0x0481, 0x0481, 0x0490, 0x04a7, 0x04be, 0x04be, 0x04c4, 0x04c4,
			0x04d2, 0x04d2, 0x04d7, 0x04e2, 0x04e2, 0x04f1, 0x04f1, 0x04fc,
			// Entry 80 - BF
			0x050a, 0x0519, 0x051f, 0x052f, 0x053d, 0x0549, 0x0552, 0x055d,
			0x0565, 0x0572, 0x057f, 0x0591, 0x0596, 0x05a4, 0x05b2, 0x05c1,
			0x05cd, 0x05d9, 0x05e6, 0x05f2, 0x05fe, 0x0605, 0x061f, 0x062f,
			0x063b, 0x0648, 0x0654, 0x065a, 0x0668, 0x0677, 0x0684, 0x0692,
			0x0698, 0x06a4, 0x06b1, 0x06b7, 0x06c3, 0x06d0, 0x06dc, 0x06e9,
			0x06f4, 0x0700, 0x0700, 0x070e, 0x0716, 0x0722, 0x0727, 0x072c,
			0x0737, 0x0744, 0x074a, 0x0755, 0x0760, 0x0760, 0x0760, 0x0760,
			0x0760, 0x0760, 0x0760, 0x076c, 0x076c, 0x076c, 0x076c, 0x076c,
			// Entry C0 - FF
			0x076c, 0x076c, 0x077b, 0x077b, 0x077b, 0x0789, 0x0789, 0x0789,
			0x0789, 0x0789, 0x0789, 0x0789, 0x078d, 0x078d, 0x0799, 0x0799,
			0x0799, 0x0799, 0x0799, 0x0799, 0x0799, 0x0799, 0x0799, 0x0799,
			0x0799, 0x0799, 0x079e, 0x079e, 0x07a2, 0x07a2, 0x07a2, 0x07a2,
			0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2,
			0x07a2, 0x07a6, 0x07a6, 0x07a6, 0x07b5, 0x07b5, 0x07b5, 0x07b5,
			0x07b5, 0x07b5, 0x07b5, 0x07b5, 0x07b5, 0x07ba, 0x07ba, 0x07ba,
			0x07ba, 0x07ba, 0x07ba, 0x07c8, 0x07c8, 0x07d0, 0x07d0, 0x07d6,
			// Entry 100 - 13F
			0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07db, 0x07db,
			0x07db, 0x07db, 0x07db, 0x07e0, 0x07e0, 0x07f1, 0x07f1, 0x07f6,
			0x07f6, 0x0800, 0x0800, 0x0800, 0x0804, 0x0804, 0x0804, 0x0804,
			0x0804, 0x0804, 0x0804, 0x0804, 0x0804, 0x0804, 0x0804, 0x0812,
			0x0812, 0x0812, 0x0812, 0x0812, 0x0812, 0x0812, 0x0812, 0x0812,
			0x0812, 0x0812, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820,
			0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x082a,
			0x082a, 0x082a, 0x083e, 0x083e, 0x083e, 0x0843, 0x0843, 0x0843,
			// Entry 140 - 17F
			0x0843, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850, 0x0861, 0x0861,
			0x0861, 0x0861, 0x0861, 0x0861, 0x0861, 0x0861, 0x0861, 0x0861,
			0x0867, 0x086e, 0x086e, 0x086e, 0x086e, 0x086e, 0x087a, 0x087a,
			0x087a, 0x087f, 0x087f, 0x087f, 0x087f, 0x087f, 0x0886, 0x0894,
			0x0894, 0x0894, 0x0894, 0x0894, 0x0894, 0x08a0, 0x08a0, 0x08a0,
			0x08a0, 0x08a8, 0x08a8, 0x08bb, 0x08c2, 0x08c2, 0x08c2, 0x08c2,
			0x08c2, 0x08c2, 0x08c2, 0x08c2, 0x08ca, 0x08cf, 0x08cf, 0x08cf,
			0x08cf, 0x08cf, 0x08d4, 0x08d4, 0x08d4, 0x08d4, 0x08d4, 0x08d4,
			// Entry 180 - 1BF
			0x08d4, 0x08da, 0x08da, 0x08da, 0x08da, 0x08da, 0x08da, 0x08da,
			0x08da, 0x08dd, 0x08dd, 0x08e2, 0x08e2, 0x08e2, 0x08e2, 0x08e2,
			0x08e2, 0x08e2, 0x08e2, 0x08e2, 0x08ee, 0x08ee, 0x08ee, 0x08ee,
			0x08ee, 0x08f2, 0x0909, 0x0909, 0x0917, 0x091e, 0x091e, 0x091e,
			0x091e, 0x091e, 0x092b, 0x092b, 0x092b, 0x0932, 0x0932, 0x0936,
			0x0936, 0x0936, 0x0936, 0x0936, 0x0936, 0x0936, 0x0936, 0x0936,
			0x093a, 0x0949, 0x0949, 0x0949, 0x0949, 0x0949, 0x094f, 0x094f,
			0x094f, 0x094f, 0x094f, 0x0955, 0x0955, 0x0959, 0x0959, 0x0959,
			// Entry 1C0 - 1FF
			0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961,
			0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961,
			0x0961, 0x0961, 0x0961, 0x096b, 0x096b, 0x0974, 0x0974, 0x0974,
			0x0974, 0x0974, 0x0974, 0x0974, 0x0979, 0x0979, 0x0979, 0x0979,
			0x0979, 0x0979, 0x097c, 0x097c, 0x097c, 0x097c, 0x0983, 0x0983,
			0x0983, 0x0983, 0x0983, 0x0988, 0x0994, 0x0994, 0x0994, 0x0994,
			0x0998, 0x0998, 0x0998, 0x09a3, 0x09a3, 0x09a3, 0x09ac, 0x09ac,
			0x09ac, 0x09ac, 0x09ac, 0x09ac, 0x09bd, 0x09cd, 0x09de, 0x09ef,
			// Entry 200 - 23F
			0x09ef, 0x09ef, 0x09ef, 0x09ef, 0x09ef, 0x0a00, 0x0a00, 0x0a00,
			0x0a00, 0x0a00, 0x0a16, 0x0a16, 0x0a16, 0x0a16, 0x0a16, 0x0a16,
			0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a,
			0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a,
			0x0a1a, 0x0a1a, 0x0a1a, 0x0a1a, 0x0a21, 0x0a21, 0x0a3e, 0x0a3e,
			0x0a3e, 0x0a3e, 0x0a4c, 0x0a4f, 0x0a4f, 0x0a4f, 0x0a4f, 0x0a4f,
			0x0a4f, 0x0a4f, 0x0a54, 0x0a54, 0x0a54, 0x0a54, 0x0a54, 0x0a54,
			0x0a54, 0x0a54, 0x0a54, 0x0a58, 0x0a58, 0x0a58, 0x0a58, 0x0a58,
			// Entry 240 - 27F
			0x0a58, 0x0a58, 0x0a58, 0x0a58, 0x0a58, 0x0a58, 0x0a61, 0x0a61,
			0x0a76, 0x0a76, 0x0a8f, 0x0aa2, 0x0abc, 0x0ad6, 0x0aef, 0x0b07,
			0x0b1f, 0x0b3f, 0x0b55, 0x0b6a, 0x0b81, 0x0b99, 0x0ba4, 0x0bbd,
			0x0bd5, 0x0be2, 0x0bf5, 0x0c0e, 0x0c29,
		},
	},
	{ // hu
		huLangStr,
		huLangIdx,
	},
	{ // hy
		hyLangStr,
		hyLangIdx,
	},
	{ // id
		idLangStr,
		idLangIdx,
	},
	{ // ig
		"AkanAmariikịArabiikịBelaruusuBọlụgarịaBengaliCheekịJamaanGiriikịOyiboPan" +
			"yaPeshanFụrenchAwụsaHindiMagịyaIndonisiaIgboItaloJapaneseJavaKeme, E" +
			"titiKoriaMaleyiMịanmaNepaliDọọchPunjabiPoliishiPotokiRumeniaRọshanRụ" +
			"wandaSomaliSụwidiishiTamụlụTaịTọkiishiUkureenịUruduViyetịnaamụYoruba" +
			"MandarịịnịZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000e, 0x000e,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0021, 0x0030,
			0x0030, 0x0030, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037,
			0x0037, 0x0037, 0x0037, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x0045, 0x0045, 0x0045, 0x0045, 0x004e, 0x0053, 0x0053, 0x0058,
			0x0058, 0x0058, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x0067,
			0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x006e,
			0x006e, 0x0073, 0x0073, 0x0073, 0x0073, 0x007b, 0x007b, 0x007b,
			// Entry 40 - 7F
			0x007b, 0x0084, 0x0084, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088,
			0x008d, 0x008d, 0x0095, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x0099, 0x0099, 0x00a4, 0x00a4, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00a9, 0x00a9, 0x00a9, 0x00af, 0x00af, 0x00b7, 0x00b7, 0x00b7,
			0x00bd, 0x00bd, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00cd, 0x00cd, 0x00d5,
			// Entry 80 - BF
			0x00d5, 0x00db, 0x00db, 0x00db, 0x00db, 0x00e2, 0x00ea, 0x00f3,
			0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3,
			0x00f3, 0x00f3, 0x00f9, 0x00f9, 0x00f9, 0x00f9, 0x00f9, 0x00f9,
			0x0105, 0x0105, 0x010f, 0x010f, 0x010f, 0x0114, 0x0114, 0x0114,
			0x0114, 0x0114, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128,
			0x012d, 0x012d, 0x012d, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c,
			0x013c, 0x0142, 0x0142, 0x0152, 0x0156,
		},
	},
	{ // ii
		"ꄓꇩꉙꑱꇩꉙꑭꀠꑸꉙꃔꇩꉙꆈꌠꉙꑴꄊꆺꉙꏝꀪꉙꁍꄨꑸꉙꊉꇩꉙꍏꇩꉙꅉꀋꌠꅇꂷꀠꑟꁍꄨꑸꉙꈝꐯꍏꇩꉙꀎꋏꍏꇩꉙ",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0012, 0x0012, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			// Entry 40 - 7F
			0x0027, 0x0027, 0x0027, 0x0027, 0x0030, 0x0030, 0x0030, 0x0030,
			0x003c, 0x003c, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			// Entry 80 - BF
			0x0045, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry C0 - FF
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 100 - 13F
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 140 - 17F
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 180 - 1BF
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 1C0 - 1FF
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 200 - 23F
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			// Entry 240 - 27F
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0093, 0x00a2,
		},
	},
	{ // is
		isLangStr,
		isLangIdx,
	},
	{ // it
		itLangStr,
		itLangIdx,
	},
	{ // ja
		jaLangStr,
		jaLangIdx,
	},
	{ // jgo
		"AlâbɛNjámanŊgɛlɛ̂kAŋgɛlúshiFɛlánciShinwâNdaꞌacú-pʉɔ yi pɛ́ ká kɛ́ jí",
		[]uint16{ // 555 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000e, 0x000e, 0x000e, 0x000e, 0x0019, 0x0025, 0x0025, 0x0025,
			0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			// Entry 40 - 7F
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			// Entry 80 - BF
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry 100 - 13F
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry 140 - 17F
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 180 - 1BF
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 1C0 - 1FF
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 200 - 23F
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x005c,
		},
	},
	{ // jmc
		"KiakanyiKiamharyiKyiarabuKyibelarusiKyibulgaryiaKyibanglaKyicheckiKyijer" +
			"umaniKyigirikiKyingerezaKyihispaniaKyiajemiKyifaransaKyihausaKyihind" +
			"iKyihungariKyiindonesiaKyiigboKyiitalianoKyijapaniKyijavaKyikambodia" +
			"KyikoreaKyimalesiaKyiburmaKyinepaliKyiholanziKyipunjabiKyipolandiKyi" +
			"renoKyiromaniaKyirusiKyinyarwandaKyisomalyiKyiswidiKyitamilKyitailan" +
			"diKyiturukyiKyiukraniaKyiurduKyivietinamuKyiyorubaKyichinaKyizuluKim" +
			"achame",
		[]uint16{ // 338 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0056, 0x0060, 0x0060, 0x006b,
			0x006b, 0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x0085,
			0x0085, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00d0, 0x00d0, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00e2, 0x00e2, 0x00ea, 0x00ea, 0x00ea,
			0x00f3, 0x00f3, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd,
			0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x0107, 0x0107, 0x0111,
			// Entry 80 - BF
			0x0111, 0x0118, 0x0118, 0x0118, 0x0118, 0x0122, 0x0129, 0x0135,
			0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x01a2,
		},
	},
	{ // ka
		kaLangStr,
		kaLangIdx,
	},
	{ // kab
		"TakanitTamahrictTaɛrabtTabilarusitTabulgaritTabengalitTačikitTalmantTagr" +
			"ikitTaglizitTaspenyulitTafarisitTafransistTahwasitTahenditTahungarit" +
			"TandunisitTigbutTaṭalyanitTajapunitTajavanitTakemritTakuritTamalawit" +
			"TaburmisitTanipalitTadučitTapunjabitTapulunitTapurtugalitTarumanitTa" +
			"rusitTaruwanditTaṣumalitTaswiditTaṭamulitTaṭaylunditTaṭurkitTukranit" +
			"TurdutTabyiṭnamitTayurubitTacinwat, TamundarintTazulutTaqbaylit",
		[]uint16{ // 343 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0023, 0x002d,
			0x002d, 0x002d, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037,
			0x0037, 0x0037, 0x0037, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x0046, 0x0046, 0x0046, 0x0046, 0x004e, 0x0056, 0x0056, 0x0061,
			0x0061, 0x0061, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x007c,
			0x007c, 0x0084, 0x0084, 0x0084, 0x0084, 0x008e, 0x008e, 0x008e,
			// Entry 40 - 7F
			0x008e, 0x0098, 0x0098, 0x009e, 0x009e, 0x009e, 0x009e, 0x009e,
			0x00aa, 0x00aa, 0x00b3, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00c4, 0x00c4, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00d4, 0x00d4, 0x00de, 0x00de, 0x00de,
			0x00e7, 0x00e7, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef,
			0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00f9, 0x00f9, 0x0102,
			// Entry 80 - BF
			0x0102, 0x010e, 0x010e, 0x010e, 0x010e, 0x0117, 0x011e, 0x0128,
			0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128,
			0x0128, 0x0128, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
			0x013b, 0x013b, 0x0146, 0x0146, 0x0146, 0x0153, 0x0153, 0x0153,
			0x0153, 0x0153, 0x015d, 0x015d, 0x015d, 0x015d, 0x015d, 0x0165,
			0x016b, 0x016b, 0x016b, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178,
			0x0178, 0x0181, 0x0181, 0x0196, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			// Entry C0 - FF
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			// Entry 100 - 13F
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			// Entry 140 - 17F
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x01a6,
		},
	},
	{ // kam
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKikamba",
		[]uint16{ // 346 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0170,
		},
	},
	{ // kde
		"ChakanChamhaliChalabuChibelalusiChibulgaliaChibanglaChichechiChidyeluman" +
			"iChigilichiChiingelezaChihispaniaChiajemiChifalansaChihausaChihindiC" +
			"hihungaliChiiongonesiaChiigboChiitalianoChidyapaniChidyavaChikambodi" +
			"aChikoleaChimalesiaChibulmaChinepaliChiholanziChipunjabiChipolandiCh" +
			"ilenoChilomaniaChilusiChinyalwandaChisomaliChiswidiChitamilChitailan" +
			"diChituluchiChiuklaniaChiulduChivietinamuChiyolubaChichinaChizuluChi" +
			"makonde",
		[]uint16{ // 351 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0020, 0x002b,
			0x002b, 0x002b, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x0049, 0x0049, 0x0049, 0x0049, 0x0053, 0x005e, 0x005e, 0x0069,
			0x0069, 0x0069, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x0083,
			0x0083, 0x008b, 0x008b, 0x008b, 0x008b, 0x0095, 0x0095, 0x0095,
			// Entry 40 - 7F
			0x0095, 0x00a2, 0x00a2, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00b4, 0x00b4, 0x00be, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00d1, 0x00d1, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00e3, 0x00e3, 0x00eb, 0x00eb, 0x00eb,
			0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe,
			0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x0108, 0x0108, 0x0112,
			// Entry 80 - BF
			0x0112, 0x0119, 0x0119, 0x0119, 0x0119, 0x0123, 0x012a, 0x0136,
			0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136,
			0x0136, 0x0136, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x01a3,
		},
	},
	{ // kea
		"abkaziuafrikanerakanamarikuarabiasamesaimaraazerbaijanubaxkirbielorusubu" +
			"lgarubambarabengalitibetanubretãubosniukatalãucórsikutxekugalesdinam" +
			"arkesalimãudzonkaevegreguinglessperantuspanholstonianubaskupersafinl" +
			"andesfijianufaroesfransesfrisiu osidentalirlandesgaleguguaranigujara" +
			"timanksauzaebraikuindikroataaitianuúngaruarméniuindoneziuibonuosuisl" +
			"andesitalianuinuktitutjaponesjavanesjorjianukazakkmerkanareskureanuk" +
			"axmirakurdukirgizlatinluxemburgeslausianulituanesletãumalgaximaorima" +
			"sedoniumalaialammaratimalaiumaltesbirmanesnepalesolandesnorueges nyn" +
			"orsknorueges bokmåloromooriyapandjabipulakupaxtopurtugeskexuaromanxi" +
			"rumenurusukiniaruandasanskritusindisingalesslovakusloveniusomalialba" +
			"nessérviusundanessuekusuaílitamiltelugutajiktailandestigriniaturkmen" +
			"utonganesturkutataruigurukranianuurduuzbekivietnamitauolofkozaioruba" +
			"xineszuluaghemaraukanuasubembabenabodoxigaxerokikurdu soranitaitazar" +
			"masórbiu baxudualajola-fonyiembufilipinugagauzalimãu di Suisagusiiav" +
			"aianusórbiu altuñombamatxamekabuverdianukitxelingua diskonxedusem ko" +
			"nteudo linguistikuarabi mudernualimãu austriakualtu alimãu suisuingl" +
			"es australianuingles kanadianuingles britanukuingles merkanuspanhol " +
			"latinu-merkanuspanhol europeuspanhol mexikanufranses kanadianufranse" +
			"s suisuflamengupurtuges brazilerupurtuges europeuxines simplifikadux" +
			"ines tradisional",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0007, 0x0007, 0x0010, 0x0014, 0x001b, 0x001b,
			0x0020, 0x0026, 0x0026, 0x002c, 0x0037, 0x003d, 0x0046, 0x004d,
			0x004d, 0x0054, 0x005b, 0x0063, 0x006a, 0x0070, 0x0078, 0x0078,
			0x0078, 0x0080, 0x0080, 0x0085, 0x0085, 0x0085, 0x008a, 0x0094,
			0x009b, 0x009b, 0x00a1, 0x00a4, 0x00a9, 0x00af, 0x00b7, 0x00be,
			0x00c6, 0x00cb, 0x00d0, 0x00d0, 0x00d9, 0x00e0, 0x00e6, 0x00ed,
			0x00fd, 0x0105, 0x0105, 0x010b, 0x0112, 0x011a, 0x011f, 0x0123,
			0x012a, 0x012e, 0x012e, 0x0134, 0x013b, 0x0142, 0x014a, 0x014a,
			// Entry 40 - 7F
			0x014a, 0x0153, 0x0153, 0x0156, 0x015b, 0x015b, 0x015b, 0x0163,
			0x016b, 0x0174, 0x017b, 0x0182, 0x018a, 0x018a, 0x018a, 0x018a,
			0x018f, 0x018f, 0x0193, 0x019a, 0x01a1, 0x01a1, 0x01a8, 0x01ad,
			0x01ad, 0x01ad, 0x01b3, 0x01b8, 0x01c3, 0x01c3, 0x01c3, 0x01c3,
			0x01cb, 0x01d3, 0x01d3, 0x01d9, 0x01e0, 0x01e0, 0x01e5, 0x01ee,
			0x01f7, 0x01f7, 0x01fd, 0x0203, 0x0209, 0x0211, 0x0211, 0x0211,
			0x0218, 0x0218, 0x021f, 0x022f, 0x023f, 0x023f, 0x023f, 0x023f,
			0x023f, 0x023f, 0x0244, 0x0249, 0x0249, 0x0251, 0x0251, 0x0257,
			// Entry 80 - BF
			0x025c, 0x0264, 0x0269, 0x0270, 0x0270, 0x0276, 0x027a, 0x0285,
			0x028e, 0x028e, 0x0293, 0x0293, 0x0293, 0x029b, 0x02a2, 0x02aa,
			0x02aa, 0x02aa, 0x02b0, 0x02b7, 0x02be, 0x02be, 0x02be, 0x02c6,
			0x02cb, 0x02d2, 0x02d7, 0x02dd, 0x02e2, 0x02eb, 0x02f3, 0x02fb,
			0x02fb, 0x0303, 0x0308, 0x0308, 0x030d, 0x030d, 0x0312, 0x031b,
			0x031f, 0x0325, 0x0325, 0x032f, 0x032f, 0x032f, 0x0334, 0x0338,
			0x0338, 0x033e, 0x033e, 0x0343, 0x0347, 0x0347, 0x0347, 0x0347,
			0x0347, 0x0347, 0x0347, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c,
			// Entry C0 - FF
			0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x0354, 0x0354, 0x0354,
			0x0354, 0x0354, 0x0354, 0x0354, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x035c, 0x035c, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0364, 0x0364, 0x0364, 0x0364, 0x0364, 0x0364, 0x0364,
			0x0364, 0x0364, 0x0364, 0x0364, 0x0364, 0x0368, 0x0368, 0x0368,
			0x0368, 0x0368, 0x0368, 0x0368, 0x0368, 0x036e, 0x036e, 0x037a,
			// Entry 100 - 13F
			0x037a, 0x037a, 0x037a, 0x037a, 0x037a, 0x037a, 0x037f, 0x037f,
			0x037f, 0x037f, 0x037f, 0x0384, 0x0384, 0x0390, 0x0390, 0x0395,
			0x0395, 0x039f, 0x039f, 0x039f, 0x03a3, 0x03a3, 0x03a3, 0x03a3,
			0x03a3, 0x03a3, 0x03a3, 0x03a3, 0x03a3, 0x03a3, 0x03a3, 0x03ab,
			0x03ab, 0x03ab, 0x03ab, 0x03ab, 0x03ab, 0x03ab, 0x03ab, 0x03ab,
			0x03ab, 0x03ab, 0x03b1, 0x03b1, 0x03b1, 0x03b1, 0x03b1, 0x03b1,
			0x03b1, 0x03b1, 0x03b1, 0x03b1, 0x03b1, 0x03b1, 0x03b1, 0x03b1,
			0x03b1, 0x03b1, 0x03c1, 0x03c1, 0x03c1, 0x03c6, 0x03c6, 0x03c6,
			// Entry 140 - 17F
			0x03c6, 0x03cd, 0x03cd, 0x03cd, 0x03cd, 0x03cd, 0x03d9, 0x03d9,
			0x03d9, 0x03d9, 0x03d9, 0x03d9, 0x03d9, 0x03d9, 0x03d9, 0x03d9,
			0x03df, 0x03e6, 0x03e6, 0x03e6, 0x03e6, 0x03e6, 0x03e6, 0x03e6,
			0x03e6, 0x03e6, 0x03e6, 0x03e6, 0x03e6, 0x03e6, 0x03e6, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			// Entry 180 - 1BF
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			// Entry 1C0 - 1FF
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2,
			0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f2, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			// Entry 200 - 23F
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
			0x03f7, 0x03f7, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408,
			0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408,
			0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408,
			// Entry 240 - 27F
			0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408,
			0x0420, 0x0420, 0x042d, 0x043e, 0x0450, 0x0462, 0x0472, 0x0482,
			0x0490, 0x04a6, 0x04b5, 0x04c5, 0x04d6, 0x04e3, 0x04eb, 0x04fd,
			0x050d, 0x050d, 0x050d, 0x051f, 0x0530,
		},
	},
	{ // khq
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senni, Gam" +
			"e hereKoree senniMaleezi senniBurme senniNeepal senniHolandee senniP" +
			"unjaabi senniiPolonee senniPortugee senniRumaani senniRuusi senniRwa" +
			"nda senniSomaali senniSuweede senniTamil senniTaailandu senniTurku s" +
			"enniUkreen senniUrdu senniVietnaam senniYorbance senniSinuwa senni, " +
			"MandareŋJulu senniKoyra ciini",
		[]uint16{ // 358 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x011c, 0x011c, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0134, 0x0134, 0x013f, 0x013f, 0x013f,
			0x014b, 0x014b, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159,
			0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0168, 0x0168, 0x0175,
			// Entry 80 - BF
			0x0175, 0x0183, 0x0183, 0x0183, 0x0183, 0x0190, 0x019b, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			0x01c1, 0x01c1, 0x01cc, 0x01cc, 0x01cc, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01db, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01f2,
			0x01fc, 0x01fc, 0x01fc, 0x020a, 0x020a, 0x020a, 0x020a, 0x020a,
			0x020a, 0x0218, 0x0218, 0x022f, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry C0 - FF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 100 - 13F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 140 - 17F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0244,
		},
	},
	{ // ki
		"KiakanKiamhariKĩarabuKibelarusiKibulgariaKibanglaKicheckiKĩnjeremaniKigi" +
			"rikiGĩthungũKihispaniaKiajemiKĩbaranjaKihausaKĩhĩndĩKihungariKiindon" +
			"esiaKiigboKĩtalianoKĩnjabaniKijavaGikuyuKikambodiaKikoreaKimalesiaKi" +
			"burmaKinepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKĩraciaKinyar" +
			"wandaKĩcumarĩKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietin" +
			"amuKiyorubaKĩcainaKizulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a,
			0x0046, 0x0046, 0x0046, 0x0046, 0x004e, 0x0058, 0x0058, 0x0062,
			0x0062, 0x0062, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0073,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007a,
			0x007a, 0x0084, 0x0084, 0x0084, 0x0084, 0x008d, 0x008d, 0x008d,
			// Entry 40 - 7F
			0x008d, 0x0098, 0x0098, 0x009e, 0x009e, 0x009e, 0x009e, 0x009e,
			0x00a8, 0x00a8, 0x00b2, 0x00b8, 0x00b8, 0x00b8, 0x00be, 0x00be,
			0x00be, 0x00be, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00d8, 0x00d8, 0x00df, 0x00df, 0x00df,
			0x00e7, 0x00e7, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f9, 0x00f9, 0x0102,
			// Entry 80 - BF
			0x0102, 0x0108, 0x0108, 0x0108, 0x0108, 0x0111, 0x0119, 0x0124,
			0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124,
			0x0124, 0x0124, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x0135, 0x0135, 0x013c, 0x013c, 0x013c, 0x0146, 0x0146, 0x0146,
			0x0146, 0x0146, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x0157,
			0x015d, 0x015d, 0x015d, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0170, 0x0170, 0x0178, 0x017e,
		},
	},
	{ // kk
		kkLangStr,
		kkLangIdx,
	},
	{ // kkj
		"yamannumbu buykakɔ",
		[]uint16{ // 361 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 40 - 7F
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 80 - BF
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry C0 - FF
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 100 - 13F
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 140 - 17F
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x0013,
		},
	},
	{ // kl
		"kalaallisut",
		[]uint16{ // 82 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x000b,
		},
	},
	{ // kln
		"kutitab Akakutitab Amariekkutitab Arabukkutitab Belarusakutitab Bulgaria" +
			"kutitab Bengalikutitab Chekkutitab Chermanikutitab Greecekutitab Uin" +
			"geresakutitab Espianikkutitab Persiakutitab Kifaransakutitab Hausaku" +
			"titab Maindiikkutitab Hangarikutitab Indonesiakutitab Igbokutitab Ta" +
			"lianekkutitap Japankutitap Javanesekutitab Kher nebo Kwenkutitab Kor" +
			"eakutitab Malaykutitab Burmakutitab Nepalikutitab Boakutitab Punjabk" +
			"utitap Polandkutitab Portugalkutitab Romaniekkutitab Russiakutitab K" +
			"inyarwandakutitab Somaliekkutitab Swedenkutitab Tamilkutitab Thailan" +
			"dkutitab Turkeykutitab Ukrainekutitab Urdukutitab Vietnamkutitab Yor" +
			"ubakutitab Chinakutitab ZuluKalenjin",
		[]uint16{ // 362 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x001a, 0x001a,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0038, 0x0048,
			0x0048, 0x0048, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0081, 0x0092, 0x0092, 0x00a2,
			0x00a2, 0x00a2, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00c1,
			0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00ce,
			0x00ce, 0x00de, 0x00de, 0x00de, 0x00de, 0x00ed, 0x00ed, 0x00ed,
			// Entry 40 - 7F
			0x00ed, 0x00fe, 0x00fe, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
			0x011a, 0x011a, 0x0127, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137,
			0x0137, 0x0137, 0x014d, 0x014d, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x015a, 0x0167, 0x0167, 0x0174, 0x0174, 0x0174,
			0x0182, 0x0182, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d,
			0x018d, 0x018d, 0x018d, 0x018d, 0x018d, 0x019b, 0x019b, 0x01a9,
			// Entry 80 - BF
			0x01a9, 0x01b9, 0x01b9, 0x01b9, 0x01b9, 0x01c9, 0x01d7, 0x01ea,
			0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea,
			0x01ea, 0x01ea, 0x01fa, 0x01fa, 0x01fa, 0x01fa, 0x01fa, 0x01fa,
			0x0208, 0x0208, 0x0215, 0x0215, 0x0215, 0x0225, 0x0225, 0x0225,
			0x0225, 0x0225, 0x0233, 0x0233, 0x0233, 0x0233, 0x0233, 0x0242,
			0x024e, 0x024e, 0x024e, 0x025d, 0x025d, 0x025d, 0x025d, 0x025d,
			0x025d, 0x026b, 0x026b, 0x0278, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			// Entry C0 - FF
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			// Entry 100 - 13F
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			// Entry 140 - 17F
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x028c,
		},
	},
	{ // km
		kmLangStr,
		kmLangIdx,
	},
	{ // kn
		knLangStr,
		knLangIdx,
	},
	{ // ko
		koLangStr,
		koLangIdx,
	},
	{ // kok
		"अफारअबखेज़ियनअफ्रिकान्सत्विअमहारिक्अरेबिक्असामीऐमराअज़रबैजानीबष्किरबैलोर" +
			"ुसियन्बल्गेरियनबिसलमाबंगालीतिबेतियनब्रेटनकटलानकोर्शियनज़ेक्वेळ्ष्ड" +
			"ानिषजर्मनभूटानीग्रीक्आंग्लइस्परान्टोस्पानिषइस्टोनियन्बास्कपर्षियन्" +
			"फिन्निष्फिजीफेरोस्फ्रेन्चफ्रिशियन्ऐरिषस्काटस् गेलिक्गेलीशियनगौरानी" +
			"गुजरातीहौसाहेब्रुहिन्दीक्रोयेषियन्हंगेरियन्आर्मीनियन्इन्टरलिंग्वाइ" +
			"न्डोनेषियनइन्टरलिंग्इनूपेयाक्आईस्लान्डिकइटालियनइन्युकट्टजापनीस्जाव" +
			"नीस्जार्जियन्कज़ख्ग्रीनलान्डिककंबोडियनकन्नडाकोरियन्कश्मीरीकुर्दिषक" +
			"िर्गिज़लाटिनलिंगालालाओतियन्लिथुआनियन्लाट्वियन् (लेट्टिष्)मलागसीमाओ" +
			"रीमसीडोनियन्मळियाळममंगोलियन्मराठीमलयमालतीस्बर्मीज़्नौरोनेपाळीडच्नो" +
			"र्वेजियनओसिटान्ओरोमो (अफान)ओरियापंजाबीपोलिषपाष्टो (पुष्टो)पोर्चुगी" +
			"ज़्क्वेच्वारहटो-रोमान्स्किरुन्दीरोमानियन्रष्यन्किन्यार्वान्डासंस्क" +
			"ृतसिंधीसांग्रोसिन्हलीस्स्लोवाकस्लोवेनियन्समोनशोनासोमाळीआल्बेनियन्स" +
			"ेर्बियन्सिस्वातीसेसोथोसुंदनीसस्वीदीषस्वाहिलीतमिळतेलुगूतजिकथाईतिग्र" +
			"िन्यातुर्कमनसेत्स्वानातोंगातुर्किषत्सोगातटारउधूरयुक्रेनियन्उर्दूउज" +
			"़बेकवियत्नामीज़ओलापुकउलोफ़झ़ौसाइद्दिष्यूरुबाझ्हुन्गचीनीस्जुलूतगालो" +
			"गकोंकणीमोल्डावियन्सेर्बो-क्रोयेषियन्",
		[]uint16{ // 603 elements
			// Entry 0 - 3F
			0x0000, 0x000c, 0x0027, 0x0027, 0x0045, 0x0051, 0x0069, 0x0069,
			0x007e, 0x008d, 0x008d, 0x0099, 0x00b7, 0x00c9, 0x00ea, 0x0105,
			0x0117, 0x0117, 0x0129, 0x0141, 0x0153, 0x0153, 0x0162, 0x0162,
			0x0162, 0x017a, 0x017a, 0x0189, 0x0189, 0x0189, 0x019b, 0x01aa,
			0x01b9, 0x01b9, 0x01cb, 0x01cb, 0x01dd, 0x01ec, 0x020a, 0x021f,
			0x023d, 0x024c, 0x0264, 0x0264, 0x027c, 0x0288, 0x029a, 0x02af,
			0x02ca, 0x02d6, 0x02fe, 0x0316, 0x0328, 0x033d, 0x033d, 0x0349,
			0x035b, 0x036d, 0x036d, 0x038e, 0x038e, 0x03a9, 0x03c7, 0x03c7,
			// Entry 40 - 7F
			0x03eb, 0x040c, 0x042a, 0x042a, 0x042a, 0x0445, 0x0445, 0x0466,
			0x047b, 0x0496, 0x04ab, 0x04c0, 0x04db, 0x04db, 0x04db, 0x04db,
			0x04ea, 0x050e, 0x0526, 0x0538, 0x054d, 0x054d, 0x0562, 0x0577,
			0x0577, 0x0577, 0x058f, 0x059e, 0x059e, 0x059e, 0x059e, 0x05b3,
			0x05cb, 0x05e9, 0x05e9, 0x061f, 0x0631, 0x0631, 0x0640, 0x065e,
			0x0673, 0x068e, 0x069d, 0x06a6, 0x06bb, 0x06d3, 0x06df, 0x06df,
			0x06f1, 0x06f1, 0x06fa, 0x06fa, 0x0718, 0x0718, 0x0718, 0x0718,
			0x072d, 0x072d, 0x074b, 0x075a, 0x075a, 0x076c, 0x076c, 0x077b,
			// Entry 80 - BF
			0x07a2, 0x07c3, 0x07db, 0x0800, 0x0818, 0x0833, 0x0845, 0x086f,
			0x0884, 0x0884, 0x0893, 0x0893, 0x08a8, 0x08c3, 0x08d8, 0x08f9,
			0x0905, 0x0911, 0x0923, 0x0941, 0x095c, 0x0974, 0x0986, 0x099b,
			0x09b0, 0x09c8, 0x09d4, 0x09e6, 0x09f2, 0x09fb, 0x0a19, 0x0a2e,
			0x0a4c, 0x0a5b, 0x0a70, 0x0a82, 0x0a8e, 0x0a8e, 0x0a9a, 0x0abb,
			0x0aca, 0x0adc, 0x0adc, 0x0afd, 0x0b0f, 0x0b0f, 0x0b1e, 0x0b2d,
			0x0b42, 0x0b54, 0x0b69, 0x0b7b, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			// Entry C0 - FF
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			// Entry 100 - 13F
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			// Entry 140 - 17F
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 180 - 1BF
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 1C0 - 1FF
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 200 - 23F
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 240 - 27F
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bcc, 0x0c00,
		},
	},
	{ // ks
		"اَفاراَبخازِیاناَویستَناَفریٖکانٛزاَکاناَمہاریاَراگونیعربیاسٲمۍاَوارِکای" +
			"مارااَزَربیجانیبَشکیٖربیلَروٗشیَنبینابِسلامابَمبارابَنٛگٲلۍتِبتیبری" +
			"ٹَنبوسنِیَنکَتلانچیچَنکَموروکارسِکَنکریچیٚکچٔرچ سلاوِکچُواشویٚلشڈین" +
			"ِشجٔرمَندِویہیزونٛگکھاایٖویوٗنٲنیاَنٛگیٖزۍایٚسپَرینٹوسپینِشایٚسٹونی" +
			"َنباسکفارسیفُلاہفِنِشفِجیَنفَروسفریٚنچمغربی فرِشیَناَیرِشسکوٹِش گیے" +
			"لِکگیلِشِیَنگُوارَنیگُجرٲتیمینٛکسہاوساعبرٲنۍہِندیہِری موتوٗکروشِیَن" +
			"ہیتِیاںہَنٛگیریَناَرمینیَنہیٚریٖرواِنٹَرلِنٛگوااِنڈونیشیااِنٹَر لِن" +
			"ٛنگویےاِگبوسِچوان یٖیاِنُپِیاکاِڈوآیِسلینڈِکاِٹیلیَناِنُکتِتوٗجاپٲن" +
			"ۍجَوَنیٖزجارجِیَنکونٛگوکِکُیوٗکُوانیاماکازَخکَلالِسُتخَمیرکَنَڑکوری" +
			"َنکَنوٗریکٲشُرکُردِشکومیکورنِشکِرگِزلاتیٖنیلُکھزیمبورگِشگاندالِمبٔر" +
			"گِشلِنگالالاولِتھوانِیَنلوُبا کَتَنٛگالَتوِیَنمَلاگَسیمارشَلیٖزماور" +
			"یمیکَڈونیَنمٔلیالَممَنٛگولیمَرٲٹھۍمَلَےمَلتیٖسبٔمیٖزناورُشُمال ڈَبی" +
			"لنیٚپٲلۍڈونٛگاڈَچناروییَن نَے نورسکناروییَن بوکمالجنوب ڈیٚبیلنَواجو" +
			"نِیَنجااوکسیٖٹَناوجِبوااوٚرومواوٚرِیااوٚسیٚٹِکپَنجٲبۍپالیپالِشپَشتو" +
			"ٗپُرتَگیٖزکُویشُوارومانشرُندیرومٲنیروٗسیکِنیاوِنداسَنسکرٕتسراڈیٖنیس" +
			"ِندیشُمٲلی سَمیسَنگوسِنہالاسلووَکسلووینیَنسَمواَنشوناسومٲلیالبانِیَ" +
			"نسٔربِیَنسواتیجنوبی ستھوسَنڈَنیٖزسویٖڈِشسواہِلیتَمِلتیلگوٗتاجِکتھاے" +
			"ٹِگرِنیاتُرکمینسواناٹونٛگاتُرکِشژونٛگاتَتارتاہیشِیَنیوٗکرینیٲییاُرد" +
			"وٗاُزبیکوینداوِیَتنَمیٖزوولَپُکوَلوٗنوولوفکھوسایِدِشیورُبازُہانٛگچی" +
			"ٖنیزُلوٗاَچَےنیٖزاَکولیاَدَنٛگمیےاَدَیٖگیےاَفرِہِلیاینوٗاَکادِیَناَ" +
			"لویتیجنوٗبی اَلتاییپرون اَنٛگریٖزیاَنٛگِکااَرَمیکایرو کونِیَناَراپا" +
			"ہواَراوَکایسٹوٗریَناَوَدیبَلوٗچیبالِنیٖزباسابیجابیٚمبابوجپوٗریبِکول" +
			"بِنیسِکسِکابرٛجبُرِیَتبَگنیٖزبٕلِنکاڈوکارِباتسَمسیباونوچیٖبچاچھَگتا" +
			"ےچُکیٖزماریچِنوٗک جارگَنچوکتَوشیپویانچیٚروکیشییونکاپٹِککرٕمیٖن تُرک" +
			"یکَشوٗبِیَنڈکوٹادَرگواڈیٚلوییَرسلیوڈاگرِبڈِنکاڈوگریبوٚنِم ساربِیَند" +
			"ُوالاوَستی پُرتُگالیڈِیوٗلاایٚفِکقدیٖمی مِصریایٚکاجُکایٚلامایِٹوَسط" +
			"ی اَنٛگریٖزۍایٚوونڈوفینٛگفِلِپیٖنوفونوسطی فریٚنچپرون فریٚنچشُمٲلی ف" +
			"رِشیَنمشرِقی فرِشیَنفروٗلِیَنگاگیےیوگبایاگیٖزگِلبٔرٹیٖزوَسطی ہاے جٔ" +
			"رمَنپرون ہاے جٔرمَنگوندیگورینٹیلوگوتھِکگرِبوقدیٖم یوٗنٲنیسٕوِس جٔرم" +
			"َنگُوِچ اِنہَیداہوایِیَنہِلیٖگینَنہِتایِتہمونٛگہیٚرِم ساربِیَنہُپاا" +
			"ِباناِلوکواِنٛگُشلوجبانجوڈیو فارسیجوڈیو عربیکارا کَلپَککَبایِلکاچِن" +
			"جُوٗکامباکَویکَبارڈِیَنتَیَپکوروکھاسیکھوتَنیٖزکِمبُندوٗکونکَنیکوسری" +
			"یَنکَپیلیکراچیے بَلکارکَریلِیَنکُرُکھکُمِککُتینَےلیڈِنولَہَندالَمبا" +
			"لیزگِیَنمونٛگولوزیلوٗبا لوٗلُوالویِسینولُندالُوولُسہاےمَدُریٖزمَگاے" +
			"میتَھلیمَکَسارمَندِنٛگومَساےموکشامَندَرمیندیےوَستی ایرِشمِکمیکمِنَن" +
			"ٛگکَباومانٛچوٗمَنیپوٗریموہاکموسیواریاہ زبانکریٖکمِراندیٖزمارواڑیایٚ" +
			"رزِیانیٖپالیٹَنبوٚنِم جٔرمَننیٚوارینِیاسنِیویَننوگاےپرون نارسیایٚن " +
			"کوشمالی ستھوکلاسِکَل نیوارینِیَمویٚزینِیَنکولنِیورونَظیٖمااوٚسیجاوٹ" +
			"ومَن تُرکِشپَنٛگاسِنَنپَہلَویپَمپَنٛگاپَپِیامیٚنٹوپَلااُواںپرون فار" +
			"سیفونیٖشیَنپانپیٚیَنپرون پروویٚنچَلراجِستھٲنۍرَپانویرَروٹونٛگَنرومَ" +
			"نیاَرومانیسَندَویےیاکُتسَمارِتَن اَرامیکسَسَکسَنتالیسِچِلِیَنسکاٹسس" +
			"یٚلکُپپرون ایرِششانسِداموجنوٗبی سَمیلولیے سَمیاِناری سَمیسکولٹ سَمی" +
			"سونِنکیےسوگڈِیَنسرٛانَن ٹونٛگوسیٚریرسُکُماسُسوٗسُمیریَنسیٖریٲییٹِمن" +
			"یےٹیٚریٚنوٹیٹَمٹاےگریےتیٖوٹوکیٖلاوکِلِنگونٹِلِنگِتتاماشیکنیاسا ٹونٛ" +
			"گاٹاک پِسِنژھِمشِیانتُمبُکاتُوالوٗتُویٖنیَناُدمُرتاُگارتِکیُمبُندوٗ" +
			"روٗٹواےووتِکوالامووَریےواشوکالمِکیاویَپیٖززَپوتیٚکزیناگازوٗنیکانٛہہ" +
			" تہِ لِسانیاتی مواد نہٕزازاآسٹرِیَن جٔرمَنسٕوِس ہاےجٔرمَنآسٹریلیَن ا" +
			"َنٛگریٖزۍکینَڈِیٲیی اَنٛگریٖزۍبَرطانوی اَنٛگریٖزۍیوٗ ایٚس اَنٛگریٖز" +
			"ۍلیٹٕن امریٖکی سپینِشلِبیریَن سپینِشکَنیڈیَن فریٚنچسٕوٕس فریٚنچفلیٚ" +
			"مِشبرازیٖلی پُتَگیٖزلِبیریَن پُرتَگیٖزمولداوِیَنسیٚربو کروشِیَنسیٚو" +
			"د چیٖنیرِوٲجی چیٖنی",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x000a, 0x001e, 0x002e, 0x0044, 0x004e, 0x005c, 0x006c,
			0x0074, 0x007e, 0x008c, 0x0098, 0x00ae, 0x00bc, 0x00d2, 0x00da,
			0x00e8, 0x00f6, 0x0106, 0x0110, 0x011c, 0x012c, 0x0138, 0x0142,
			0x014e, 0x015e, 0x0164, 0x016c, 0x0181, 0x018b, 0x0195, 0x019f,
			0x01ab, 0x01b7, 0x01c7, 0x01cf, 0x01dd, 0x01ef, 0x0205, 0x0211,
			0x0225, 0x022d, 0x0237, 0x0241, 0x024b, 0x0257, 0x0261, 0x026d,
			0x0286, 0x0292, 0x02ab, 0x02bd, 0x02cd, 0x02db, 0x02e7, 0x02f1,
			0x02fd, 0x0307, 0x031a, 0x032a, 0x0338, 0x034c, 0x035e, 0x036e,
			// Entry 40 - 7F
			0x0388, 0x039c, 0x03bb, 0x03c5, 0x03d8, 0x03ea, 0x03f2, 0x0406,
			0x0416, 0x042a, 0x0436, 0x0446, 0x0456, 0x0462, 0x0470, 0x0482,
			0x048c, 0x049e, 0x04a8, 0x04b2, 0x04be, 0x04cc, 0x04d6, 0x04e2,
			0x04ea, 0x04f6, 0x0502, 0x0510, 0x052a, 0x0534, 0x0546, 0x0554,
			0x055a, 0x0570, 0x058b, 0x059b, 0x05ab, 0x05bd, 0x05c7, 0x05db,
			0x05eb, 0x05fb, 0x0609, 0x0613, 0x0621, 0x062d, 0x0637, 0x064c,
			0x065a, 0x0666, 0x066c, 0x068e, 0x06ab, 0x06c0, 0x06cc, 0x06da,
			0x06ec, 0x06fa, 0x0708, 0x0716, 0x0728, 0x0736, 0x073e, 0x0748,
			// Entry 80 - BF
			0x0754, 0x0766, 0x0776, 0x0782, 0x078c, 0x0798, 0x07a2, 0x07b6,
			0x07c6, 0x07d6, 0x07e0, 0x07f5, 0x07ff, 0x080d, 0x0819, 0x082b,
			0x0839, 0x0841, 0x084d, 0x085f, 0x086f, 0x0879, 0x088c, 0x089e,
			0x08ac, 0x08ba, 0x08c4, 0x08d0, 0x08da, 0x08e2, 0x08f2, 0x0900,
			0x090a, 0x0916, 0x0922, 0x092e, 0x0938, 0x094a, 0x094a, 0x0960,
			0x096c, 0x0978, 0x0982, 0x0998, 0x09a6, 0x09b2, 0x09bc, 0x09c6,
			0x09d0, 0x09dc, 0x09ea, 0x09f4, 0x09fe, 0x0a10, 0x0a1c, 0x0a30,
			0x0a42, 0x0a42, 0x0a54, 0x0a54, 0x0a5e, 0x0a70, 0x0a70, 0x0a7e,
			// Entry C0 - FF
			0x0a7e, 0x0a99, 0x0ab6, 0x0ac6, 0x0ad4, 0x0aeb, 0x0aeb, 0x0afb,
			0x0afb, 0x0b09, 0x0b09, 0x0b09, 0x0b09, 0x0b09, 0x0b1d, 0x0b1d,
			0x0b29, 0x0b29, 0x0b37, 0x0b47, 0x0b47, 0x0b4f, 0x0b4f, 0x0b4f,
			0x0b4f, 0x0b57, 0x0b63, 0x0b63, 0x0b63, 0x0b63, 0x0b63, 0x0b73,
			0x0b7d, 0x0b85, 0x0b85, 0x0b85, 0x0b93, 0x0b93, 0x0b93, 0x0b9b,
			0x0b9b, 0x0b9b, 0x0b9b, 0x0ba9, 0x0bb7, 0x0bb7, 0x0bc1, 0x0bc1,
			0x0bc9, 0x0bd3, 0x0bd3, 0x0bdd, 0x0beb, 0x0beb, 0x0bf7, 0x0c05,
			0x0c11, 0x0c19, 0x0c32, 0x0c3e, 0x0c4c, 0x0c5a, 0x0c64, 0x0c64,
			// Entry 100 - 13F
			0x0c70, 0x0c70, 0x0c89, 0x0c9d, 0x0ca7, 0x0cb3, 0x0cb3, 0x0cc5,
			0x0ccd, 0x0cd9, 0x0ce3, 0x0ce3, 0x0ced, 0x0d0a, 0x0d0a, 0x0d16,
			0x0d33, 0x0d33, 0x0d41, 0x0d41, 0x0d41, 0x0d4d, 0x0d4d, 0x0d64,
			0x0d74, 0x0d88, 0x0da7, 0x0da7, 0x0db7, 0x0db7, 0x0dc1, 0x0dd3,
			0x0dd3, 0x0dd9, 0x0dd9, 0x0dee, 0x0e03, 0x0e03, 0x0e1e, 0x0e39,
			0x0e4b, 0x0e4f, 0x0e4f, 0x0e4f, 0x0e59, 0x0e63, 0x0e63, 0x0e6b,
			0x0e7f, 0x0e7f, 0x0e9d, 0x0eb9, 0x0eb9, 0x0ec3, 0x0ed5, 0x0ee1,
			0x0eeb, 0x0f04, 0x0f1b, 0x0f1b, 0x0f1b, 0x0f1b, 0x0f2c, 0x0f36,
			// Entry 140 - 17F
			0x0f36, 0x0f46, 0x0f46, 0x0f5a, 0x0f68, 0x0f74, 0x0f91, 0x0f91,
			0x0f99, 0x0fa3, 0x0fa3, 0x0faf, 0x0fbd, 0x0fbd, 0x0fbd, 0x0fc9,
			0x0fc9, 0x0fc9, 0x0fde, 0x0ff1, 0x0ff1, 0x1006, 0x1014, 0x101e,
			0x1026, 0x1030, 0x1038, 0x104c, 0x104c, 0x1056, 0x1056, 0x1056,
			0x1056, 0x105e, 0x105e, 0x1068, 0x107a, 0x107a, 0x107a, 0x107a,
			0x107a, 0x107a, 0x108c, 0x108c, 0x109a, 0x10aa, 0x10b6, 0x10cf,
			0x10cf, 0x10cf, 0x10e1, 0x10ed, 0x10ed, 0x10ed, 0x10ed, 0x10f7,
			0x1105, 0x1111, 0x1111, 0x111f, 0x1129, 0x1139, 0x1139, 0x1139,
			// Entry 180 - 1BF
			0x1139, 0x1139, 0x1139, 0x1145, 0x114d, 0x114d, 0x1166, 0x1176,
			0x1180, 0x1188, 0x1194, 0x1194, 0x1194, 0x1194, 0x11a4, 0x11a4,
			0x11ae, 0x11bc, 0x11ca, 0x11dc, 0x11e6, 0x11e6, 0x11f0, 0x11fc,
			0x1208, 0x1208, 0x1208, 0x121d, 0x121d, 0x121d, 0x1229, 0x1241,
			0x124f, 0x1261, 0x126b, 0x1273, 0x1273, 0x1273, 0x1288, 0x1292,
			0x12a4, 0x12b2, 0x12b2, 0x12b2, 0x12c2, 0x12c2, 0x12c2, 0x12d6,
			0x12d6, 0x12ef, 0x12fd, 0x1307, 0x1315, 0x1315, 0x1315, 0x1315,
			0x131f, 0x1332, 0x1332, 0x133f, 0x1352, 0x1352, 0x136f, 0x1383,
			// Entry 1C0 - 1FF
			0x1393, 0x139f, 0x13ad, 0x13b9, 0x13d4, 0x13ea, 0x13f8, 0x140a,
			0x1422, 0x1434, 0x1434, 0x1434, 0x1434, 0x1447, 0x1447, 0x1459,
			0x1459, 0x1459, 0x146b, 0x146b, 0x1488, 0x1488, 0x1488, 0x149c,
			0x14aa, 0x14c0, 0x14c0, 0x14c0, 0x14c0, 0x14cc, 0x14cc, 0x14cc,
			0x14cc, 0x14dc, 0x14dc, 0x14ec, 0x14f6, 0x1517, 0x1517, 0x1521,
			0x152f, 0x152f, 0x152f, 0x152f, 0x1541, 0x154b, 0x154b, 0x154b,
			0x154b, 0x154b, 0x1559, 0x1559, 0x156c, 0x156c, 0x156c, 0x1572,
			0x1572, 0x157e, 0x157e, 0x157e, 0x1593, 0x15a6, 0x15bb, 0x15ce,
			// Entry 200 - 23F
			0x15de, 0x15ee, 0x1609, 0x1615, 0x1615, 0x1615, 0x1621, 0x162b,
			0x163b, 0x163b, 0x163b, 0x163b, 0x164b, 0x164b, 0x164b, 0x1657,
			0x1657, 0x1667, 0x1671, 0x167f, 0x1687, 0x1697, 0x1697, 0x16a7,
			0x16b7, 0x16b7, 0x16c5, 0x16dc, 0x16ed, 0x16ed, 0x16ed, 0x16ed,
			0x16ff, 0x16ff, 0x170d, 0x171b, 0x171b, 0x172d, 0x172d, 0x173b,
			0x174b, 0x175d, 0x1765, 0x176b, 0x176b, 0x176b, 0x176b, 0x176b,
			0x1775, 0x1775, 0x1775, 0x1775, 0x1781, 0x178b, 0x1793, 0x1793,
			0x1793, 0x179f, 0x179f, 0x179f, 0x17a5, 0x17b1, 0x17b1, 0x17b1,
			// Entry 240 - 27F
			0x17b1, 0x17b1, 0x17c1, 0x17c1, 0x17c1, 0x17cd, 0x17cd, 0x17d7,
			0x180d, 0x1815, 0x1815, 0x1832, 0x184f, 0x1876, 0x189f, 0x18c4,
			0x18e8, 0x190e, 0x192b, 0x192b, 0x1948, 0x195f, 0x196d, 0x198e,
			0x19b1, 0x19c5, 0x19e2, 0x19f7, 0x1a0e,
		},
	},
	{ // ksb
		"KiakanKiamhaliKialabuKibelaausiKibulgaliaKibanglaKicheckiKijeumaniKigiik" +
			"iKiingeezaKihispaniaKiajemiKifalansaKihausaKihindiKihungaiKiindonesi" +
			"aKiigboKiitalianoKijapaniKijavaKikambodiaKikoleaKimalesiaKibulmaKine" +
			"paliKiholanziKipunjabiKipolandiKilenoKiomaniaKilusiKinyalwandaKisoma" +
			"liKiswidiKitamilKitailandiKituukiKiuklaniaKiulduKivietinamuKiyolubaK" +
			"ichinaKizuluKishambaa",
		[]uint16{ // 373 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0049, 0x0052, 0x0052, 0x005c,
			0x005c, 0x005c, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x006c,
			0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x0073,
			0x0073, 0x007a, 0x007a, 0x007a, 0x007a, 0x0082, 0x0082, 0x0082,
			// Entry 40 - 7F
			0x0082, 0x008d, 0x008d, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x009d, 0x009d, 0x00a5, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00ab, 0x00ab, 0x00b5, 0x00b5, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00c5, 0x00c5, 0x00cc, 0x00cc, 0x00cc,
			0x00d4, 0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00e6, 0x00e6, 0x00ef,
			// Entry 80 - BF
			0x00ef, 0x00f5, 0x00f5, 0x00f5, 0x00f5, 0x00fd, 0x0103, 0x010e,
			0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e,
			0x010e, 0x010e, 0x0116, 0x0116, 0x0116, 0x0116, 0x0116, 0x0116,
			0x011d, 0x011d, 0x0124, 0x0124, 0x0124, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x013e,
			0x0144, 0x0144, 0x0144, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f,
			0x014f, 0x0157, 0x0157, 0x015e, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			// Entry C0 - FF
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			// Entry 100 - 13F
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			// Entry 140 - 17F
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x016d,
		},
	},
	{ // ksf
		"riakanriamarikriarabribɛlɔrísribulgaríribɛngáliricɛ́kridjɛrmanrigrɛ́krii" +
			"ngɛrísrikpanyáripɛrsánripɛrɛsǝ́rikaksariíndíriɔngrɔáriindonɛsíriigbo" +
			"riitalyɛ́nrijapɔ́ŋrijawanɛ́rikmɛrrikɔrɛɛ́rimalaíribirmánrinepalɛ́riɔ" +
			"lándɛ́ripɛnjabíripɔlɔ́nripɔrtugɛ́rirɔmánrirísrirwandarisomalíriswɛ́d" +
			"ǝritamúlritaíriturkriukrɛ́nriurdúriwyɛtnámriyúubaricinɔárizúlurikpa",
		[]uint16{ // 374 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x0047, 0x0047, 0x0047, 0x0047, 0x0050, 0x005b, 0x005b, 0x0064,
			0x0064, 0x0064, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x0082,
			0x0082, 0x008a, 0x008a, 0x008a, 0x008a, 0x0095, 0x0095, 0x0095,
			// Entry 40 - 7F
			0x0095, 0x00a1, 0x00a1, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
			0x00b3, 0x00b3, 0x00be, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
			0x00c9, 0x00c9, 0x00d0, 0x00d0, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00e4, 0x00e4, 0x00ed, 0x00ed, 0x00ed,
			0x00f8, 0x00f8, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0110, 0x0110, 0x011b,
			// Entry 80 - BF
			0x011b, 0x0128, 0x0128, 0x0128, 0x0128, 0x0131, 0x0137, 0x013f,
			0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x013f, 0x013f, 0x0148, 0x0148, 0x0148, 0x0148, 0x0148, 0x0148,
			0x0153, 0x0153, 0x015b, 0x015b, 0x015b, 0x0161, 0x0161, 0x0161,
			0x0161, 0x0161, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0171,
			0x0178, 0x0178, 0x0178, 0x0183, 0x0183, 0x0183, 0x0183, 0x0183,
			0x0183, 0x018b, 0x018b, 0x0194, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			// Entry C0 - FF
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			// Entry 100 - 13F
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			// Entry 140 - 17F
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x01a0,
		},
	},
	{ // ksh
		"AfahreschAbchahseschAvästahneschAfrikaansAkahneschAmhahreschArrajonehses" +
			"chArahbeschAßamehseschAvahreschAimahreschAsserbaidschahneschBaschkih" +
			"reschWiißrußeschBulljaareschBambaraBängjaaleschTibehteschBettohnesch" +
			"BoßneschKattalahneschKorseschTschäscheschKerscheßlahweschTschowasche" +
			"schWallihseschDähneschDeutschDivehjeschButahneschEweJrihscheschÄngle" +
			"schEsperantoSchpahneschÄßneschBaskeschPärseschFinneschFidscheschFärr" +
			"öereschFranzüüseschWäßfriiseschIereschJalliizeschJuwaraaneschGutsch" +
			"arateschHaußaHebräjeschHindiKrowateschHa’iiteschUnjarreschArmeenesch" +
			"IndoneeseschIgboIdoIßländeschEtalljäneschInuktitutJapaaneschJavahnes" +
			"chJe’orjeschKassakeschKhmerKannadaKorrejaaneschKaschmiereschKurdesch" +
			"KirjihseschLateijneschLuxemborjeschLingjallaLahooteschLittoueschLätt" +
			"eschMadajaßkeschMaahoriMazedooneschMallajalamMongjoleschMarraateschM" +
			"allaijeschMalteeseschBurmesseschNood-NdebeleNepallesseschHolländesch" +
			"Neu-NorrweejeschNorrweejesch BokmålSchi-SchewaOriijaOßeeteschPanscha" +
			"abeschPollneschPaschtuuneschPochtojeseschKättschowaRätoromaaneschK-R" +
			"undeschRumäneschRußßeschKinja-RuandeschSanskritSinndiNood-Lappländes" +
			"chSangjoSingjaleeseschẞlovakeschẞloveeneschSammohaneschSchi-SchonaSo" +
			"maaleschAlbaaneschSärbeschSi-SwateschSöd-SootoSindaneeseschSchweedes" +
			"chSuaheeleschTamiileschTelluujuTadschiikeschTailändeschTijrenejaanes" +
			"chTörkmeeneschSe-ZwaaneschTongjaaneschTörkeschXi-ZongjaneschTattaare" +
			"schTahiteschUj’juuerschUkraineschUrdu/HindiUßbeekeschWendaVijätnamme" +
			"eseschWoloffIsi-KhoosaJoruubaSchineeseschSuuluAschenehseschTonehsesc" +
			"h ArahbeschAfrehihleschAkahdeschAle’uhteschAhl ÄngleschAljehresch Ar" +
			"ahbeschMarokahnesch ArahbeschÄjiptesch ArahbeschPareAmärrekahnesche " +
			"BlendeschprohchAstuhrejahneschSödasserbaidschahneschBeluhtscheschBal" +
			"inehseschBaireschBembaBenaBischnuprejahneschBrajeschBrahuijeschBoddo" +
			"BurejahteschBujinehseschKopteschKaschuhbeschNiddersorbeschMeddelnehd" +
			"erlängschDassajahneschEmbuEfikEmilijahneschAhl ÄjipteschMeddelängles" +
			"chZätrahl-JupikfilSchwitzerdütschHauajaaneschEngjuscheschIngjrijahne" +
			"schJamaikahnesch-ÄngleschLodschbahnJühdesch-PärseschJüteschKapvärdes" +
			"chKölschde Landa-SchproocheLuyjanesch-ongerscheidlijje Schprooche-No" +
			"od-SootoKiromboJackuteschKommooreschTetumschTook Pisin-onbikannte-Sc" +
			"hprooch-WalserdütschKanton-Schineeseschkein SchproochSchtandatt Arah" +
			"beschDeutsch uß ÖßterichDeutsch uß de SchweijzÄnglesch uß Außtraalij" +
			"eÄnglesch uß KanadaÄnglesch uß JruußbrettannijeAmärrekaanesch Ängles" +
			"chSchpaanesch uß Latting-AmmärrikaSchpahnesch en SchpahnejeSchpahnes" +
			"ch en MäxikohFranzüüsesch uß KanadaFranzüüsesch uß de SchweijzFlämes" +
			"chBrasilljaanesch PochtojeseschPochtojesesch uß PochtojallSärbokowat" +
			"eschSchineesesch en de eijfacher SchreffSchineesesch en de tradizjon" +
			"älle Schreff",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0009, 0x0014, 0x0021, 0x002a, 0x0033, 0x003d, 0x004b,
			0x0054, 0x0060, 0x0069, 0x0073, 0x0086, 0x0093, 0x00a0, 0x00ac,
			0x00ac, 0x00b3, 0x00c0, 0x00ca, 0x00d5, 0x00de, 0x00eb, 0x00eb,
			0x00eb, 0x00f3, 0x00f3, 0x0100, 0x0111, 0x011f, 0x012a, 0x0133,
			0x013a, 0x0144, 0x014e, 0x0151, 0x015c, 0x0165, 0x016e, 0x0179,
			0x0182, 0x018a, 0x0193, 0x0193, 0x019b, 0x01a5, 0x01b2, 0x01c0,
			0x01ce, 0x01d5, 0x01d5, 0x01e0, 0x01ec, 0x01fa, 0x01fa, 0x0200,
			0x020b, 0x0210, 0x0210, 0x021a, 0x0226, 0x0230, 0x023a, 0x023a,
			// Entry 40 - 7F
			0x023a, 0x0246, 0x0246, 0x024a, 0x024a, 0x024a, 0x024d, 0x0259,
			0x0266, 0x026f, 0x0279, 0x0283, 0x028f, 0x028f, 0x028f, 0x028f,
			0x0299, 0x0299, 0x029e, 0x02a5, 0x02b2, 0x02b2, 0x02bf, 0x02c7,
			0x02c7, 0x02c7, 0x02d2, 0x02dd, 0x02ea, 0x02ea, 0x02ea, 0x02f3,
			0x02fd, 0x0307, 0x0307, 0x0310, 0x031d, 0x031d, 0x0324, 0x0330,
			0x033a, 0x0345, 0x0350, 0x035b, 0x0366, 0x0371, 0x0371, 0x037d,
			0x038a, 0x038a, 0x0396, 0x03a6, 0x03ba, 0x03ba, 0x03ba, 0x03c5,
			0x03c5, 0x03c5, 0x03c5, 0x03cb, 0x03d5, 0x03e2, 0x03e2, 0x03eb,
			// Entry 80 - BF
			0x03f8, 0x0405, 0x0410, 0x041f, 0x0429, 0x0433, 0x043d, 0x044c,
			0x0454, 0x0454, 0x045a, 0x046c, 0x0472, 0x0480, 0x048c, 0x0499,
			0x04a5, 0x04b0, 0x04ba, 0x04c4, 0x04cd, 0x04d8, 0x04e2, 0x04ef,
			0x04fa, 0x0505, 0x050f, 0x0517, 0x0524, 0x0530, 0x053f, 0x054c,
			0x0558, 0x0564, 0x056d, 0x057b, 0x0586, 0x058f, 0x059c, 0x05a6,
			0x05b0, 0x05bb, 0x05c0, 0x05d1, 0x05d1, 0x05d1, 0x05d7, 0x05e1,
			0x05e1, 0x05e8, 0x05e8, 0x05f4, 0x05f9, 0x0606, 0x0606, 0x0606,
			0x0606, 0x061a, 0x0626, 0x0626, 0x0626, 0x062f, 0x062f, 0x063c,
			// Entry C0 - FF
			0x063c, 0x063c, 0x0649, 0x0649, 0x0649, 0x0649, 0x0649, 0x0649,
			0x065d, 0x065d, 0x0673, 0x0687, 0x068b, 0x06ab, 0x06ba, 0x06ba,
			0x06ba, 0x06d1, 0x06de, 0x06ea, 0x06f2, 0x06f2, 0x06f2, 0x06f2,
			0x06f2, 0x06f2, 0x06f7, 0x06f7, 0x06fb, 0x06fb, 0x06fb, 0x06fb,
			0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x070d, 0x070d, 0x0715,
			0x0720, 0x0725, 0x0725, 0x0731, 0x073d, 0x073d, 0x073d, 0x073d,
			0x073d, 0x073d, 0x073d, 0x073d, 0x073d, 0x073d, 0x073d, 0x073d,
			0x073d, 0x073d, 0x073d, 0x073d, 0x073d, 0x073d, 0x073d, 0x073d,
			// Entry 100 - 13F
			0x0745, 0x0745, 0x0745, 0x0751, 0x0751, 0x0751, 0x0751, 0x0751,
			0x0751, 0x0751, 0x0751, 0x0751, 0x0751, 0x075f, 0x075f, 0x075f,
			0x0773, 0x0773, 0x0773, 0x0780, 0x0784, 0x0788, 0x0795, 0x07a3,
			0x07a3, 0x07a3, 0x07b2, 0x07c0, 0x07c0, 0x07c0, 0x07c0, 0x07c3,
			0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3,
			0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3,
			0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3, 0x07c3,
			0x07c3, 0x07c3, 0x07d3, 0x07d3, 0x07d3, 0x07d3, 0x07d3, 0x07d3,
			// Entry 140 - 17F
			0x07d3, 0x07df, 0x07df, 0x07df, 0x07df, 0x07df, 0x07df, 0x07df,
			0x07df, 0x07df, 0x07df, 0x07df, 0x07eb, 0x07f9, 0x0810, 0x081a,
			0x081a, 0x081a, 0x082d, 0x082d, 0x0835, 0x0835, 0x0835, 0x0835,
			0x0835, 0x0835, 0x0835, 0x0835, 0x0835, 0x0835, 0x0835, 0x0841,
			0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0841,
			0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0841,
			0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0841, 0x0848, 0x0848,
			0x0848, 0x0848, 0x0848, 0x085b, 0x085b, 0x085b, 0x085b, 0x085b,
			// Entry 180 - 1BF
			0x085b, 0x085b, 0x085b, 0x085b, 0x085b, 0x085b, 0x085b, 0x085b,
			0x085b, 0x085b, 0x085b, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865,
			0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865,
			0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865,
			0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0865, 0x0882, 0x0882,
			0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x0882,
			0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x0882,
			0x0882, 0x0882, 0x0882, 0x0882, 0x088c, 0x088c, 0x088c, 0x088c,
			// Entry 1C0 - 1FF
			0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c,
			0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c,
			0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c,
			0x088c, 0x088c, 0x088c, 0x088c, 0x0893, 0x0893, 0x0893, 0x0893,
			0x0893, 0x0893, 0x0893, 0x0893, 0x089d, 0x089d, 0x089d, 0x089d,
			0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d,
			0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d,
			0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d,
			// Entry 200 - 23F
			0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d,
			0x089d, 0x08a8, 0x08a8, 0x08a8, 0x08a8, 0x08a8, 0x08a8, 0x08a8,
			0x08a8, 0x08a8, 0x08b0, 0x08b0, 0x08b0, 0x08b0, 0x08b0, 0x08b0,
			0x08b0, 0x08b0, 0x08b0, 0x08b0, 0x08ba, 0x08ba, 0x08ba, 0x08ba,
			0x08ba, 0x08ba, 0x08ba, 0x08ba, 0x08ba, 0x08ba, 0x08ba, 0x08ba,
			0x08ba, 0x08ba, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0,
			0x08d0, 0x08d0, 0x08d0, 0x08dd, 0x08dd, 0x08dd, 0x08dd, 0x08dd,
			0x08dd, 0x08dd, 0x08dd, 0x08dd, 0x08dd, 0x08dd, 0x08dd, 0x08dd,
			// Entry 240 - 27F
			0x08dd, 0x08f0, 0x08f0, 0x08f0, 0x08f0, 0x08f0, 0x08f0, 0x08f0,
			0x08fe, 0x08fe, 0x0912, 0x0928, 0x093f, 0x0959, 0x096d, 0x098c,
			0x09a5, 0x09c7, 0x09e0, 0x09f7, 0x0a10, 0x0a2e, 0x0a37, 0x0a54,
			0x0a70, 0x0a70, 0x0a7f, 0x0aa3, 0x0acc,
		},
	},
	{ // kw
		"kernewek",
		[]uint16{ // 90 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0008,
		},
	},
	{ // ky
		kyLangStr,
		kyLangIdx,
	},
	{ // lag
		"KɨakáaniKɨmʉháariKɨaráabuKɨberalúusiKɨbulugáriaKɨbangálaKɨchéekiKɨjerʉmá" +
			"aniKɨgiríkiKɨɨngeréesaKɨhispániaKɨajéemiKɨfaráansaKɨhaúusaKɨhíindiKɨ" +
			"hungáriKɨɨndonésiaKiígiboKɨtaliáanoKɨjapáaniKɨjáavaKɨkambódiaKɨkoréa" +
			"KɨmelésiaKɨbáamaKɨnepáaliKɨholáanziKɨpúnjabiKɨpólandiKɨréenoKɨromaní" +
			"aKɨrúusiKɨnyarwáandaKɨsómáaliKɨswíidiKɨtamíiliKɨtáilandiKɨturúukiKɨu" +
			"kɨraníaKɨúrduKɨvietináamuKɨyorúubaKɨchíinaKɨzúuluKɨlaangi",
		[]uint16{ // 379 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0016, 0x0016,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x002d, 0x003a,
			0x003a, 0x003a, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f,
			0x005d, 0x005d, 0x005d, 0x005d, 0x0067, 0x0075, 0x0075, 0x0081,
			0x0081, 0x0081, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x0097,
			0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x00a1,
			0x00a1, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00b6, 0x00b6, 0x00b6,
			// Entry 40 - 7F
			0x00b6, 0x00c4, 0x00c4, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00d8, 0x00d8, 0x00e3, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
			0x00ec, 0x00ec, 0x00f8, 0x00f8, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x010c, 0x010c, 0x0115, 0x0115, 0x0115,
			0x0120, 0x0120, 0x012c, 0x012c, 0x012c, 0x012c, 0x012c, 0x012c,
			0x012c, 0x012c, 0x012c, 0x012c, 0x012c, 0x0137, 0x0137, 0x0142,
			// Entry 80 - BF
			0x0142, 0x014b, 0x014b, 0x014b, 0x014b, 0x0156, 0x015f, 0x016d,
			0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d,
			0x016d, 0x016d, 0x0179, 0x0179, 0x0179, 0x0179, 0x0179, 0x0179,
			0x0183, 0x0183, 0x018e, 0x018e, 0x018e, 0x019a, 0x019a, 0x019a,
			0x019a, 0x019a, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01b2,
			0x01ba, 0x01ba, 0x01ba, 0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01c8,
			0x01c8, 0x01d3, 0x01d3, 0x01dd, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			// Entry C0 - FF
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			// Entry 100 - 13F
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			// Entry 140 - 17F
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01ef,
		},
	},
	{ // lb
		"AfarAbchaseschAvesteschAfrikaansAkanAmhareschAragoneseschArabeschAssames" +
			"eschAwareschAymaraAserbaidschaneschBaschkireschWäissrusseschBulgares" +
			"chBislamaBambara-SproochBengaleschTibeteschBretoneschBosneschKatalan" +
			"eschTschetscheneschChamorro-SproochKorseschCreeTschecheschKierchesla" +
			"weschTschuwascheschWaliseschDäneschDäitschMaldiveschBhutaneschEwe-Sp" +
			"roochGriicheschEngleschEsperantoSpueneschEstneschBaskeschPerseschFul" +
			"FinneschFidschianeschFäröeschFranséischWestfrieseschIreschSchottesch" +
			"t GälleschGalizeschGuaraniGujaratiManxHausaHebräeschHindiHiri-MotuKr" +
			"oateschHaitianeschUngareschArmeneschHerero-SproochInterlinguaIndones" +
			"eschInterlingueIgbo-SproochSichuan YiInupiakIdo-SproochIslänneschIta" +
			"lieneschInukitutJapaneschJavaneschGeorgeschKongoleseschKikuyu-Sprooc" +
			"hKwanyamaKasacheschGrönlänneschKambodschaneschKannadaKoreaneschKanur" +
			"i-SproochKaschmireschKurdeschKomi-SproochKorneschKirgiseschLatäinLët" +
			"zebuergeschGanda-SproochLimburgeschLingalaLaoteschLitaueschLuba-Kata" +
			"ngaLetteschMalagassi-SproochMarschalleseschMaoriMazedoneschMalayalam" +
			"MongoleschMarathiMalaieschMalteseschBirmaneschNaurueschNord-Ndebele-" +
			"SproochNepaleseschNdongaHollänneschNorwegesch NynorskNorwegesch Bokm" +
			"ålSüd-Ndebele-SproochNavajoNyanja-SproochOkzitaneschOjibwa-SproochO" +
			"romoOrijaOsseteschPandschabeschPaliPolneschPaschtuPortugiseschQuechu" +
			"aRätoromaneschRundi-SproochRumäneschRusseschRuandeschSanskritSardesc" +
			"hSindhiNordsameschSangoSinghaleseschSlowakeschSloweneschSamoaneschSh" +
			"onaSomaliAlbaneschSerbeschSwaziSüd-Sotho-SproochSundaneseschSchwedes" +
			"chSuaheliTamileschTeluguTadschikeschThailänneschTigrinjaTurkmeneschT" +
			"swana-SproochTongaeschTierkeschTsongaTatareschTahiteschUigureschUkra" +
			"ineschUrduUsbekeschVenda-SproochVietnameseschVolapükWallouneschWolof" +
			"XhosaJiddeschYorubaZhuangChineseschZuluAceh-SproochAcholi-SproochAda" +
			"ngmeAdygéieschTunesescht ArabeschAfrihiliAghemAinu-SproochAkkadeschA" +
			"labamaAleuteschGegeschSüd-AlaeschAlengleschAngikaAramäeschAraukanesc" +
			"hAraonaArapaho-SproochAlgerescht ArabeschArawak-SproochMarokkanescht" +
			" ArabeschEgyptescht ArabeschAsu (Tanzania)Amerikanesch Zeechesprooch" +
			"AsturianeschKotavaAwadhiSüd-AserbaidschaneschBelutscheschBalinesesch" +
			"BaireschBasaa-SproochBamunBatak TobaGhomálá’BedauyeBemba-SproochBeta" +
			"wiBenaBafutBadagaBhodschpuriBikol-SproochBini-SproochBanjareseschKom" +
			"Blackfoot-SproochBishnupriyaBachtiareschBraj-BhakhaBrahuiBodoAkooseB" +
			"urjateschBugineseschBuluBlinMedumbaCaddoKaribeschCayugaAtsamCebuanoK" +
			"igaChibcha-SproochTschagataeschTrukeseschMariChinookChoctawChipewyan" +
			"CherokeeCheyenneSoraniKopteschCapiznonKrimtatareschKaschubeschDakota" +
			"-SproochDargineschTaitaDelaware-SproochSlaveDogribDinka-SproochZarma" +
			"DogriNiddersorbeschZentral-DusunDualaMëttelhollänneschJola-FonyiDyul" +
			"a-SproochDazagaKiembuEfikEmilianeschEgypteschEkajukElameschMëtteleng" +
			"leschYup’ikEwondoExtremadureschPangwe-SproochFilipinoMeänkieliFon-Sp" +
			"roochCajunMëttelfranséischAlfranséischFrankoprovenzaleschNordfrieses" +
			"chOstfrieseschFriuleschGa-SproochGagauseschGan-ChineseschGayoGbaya-S" +
			"proochZoroastrianescht DariGeezGilberteseschGilakiMëttelhéichdäitsch" +
			"AlhéichdäitschGoan-KonkaniGondi-SproochMongondouGoteschGrebo-Sprooch" +
			"AlgriicheschSchwäizerdäitschWayuuFarefareGusii-SproochKutchin-Sprooc" +
			"hHaida-SproochHakka-ChineseschHawaieschFidschi-HindiHiligaynon-Sproo" +
			"chHethiteschMiao-SproochUewersorbeschXiang-ChineseschHupaIbanIbibioI" +
			"lokano-SproochInguscheschIschoreschJamaikanesch-KreoleschLojbanNgomb" +
			"aMachameJiddesch-PerseschJiddesch-ArabeschJüteschKarakalpakeschKabyl" +
			"eschKachin-SproochJjuKambaKawiKabardineschKanembuTyapMakondeKabuverd" +
			"ianuKenyangKoroKaingangKhasi-SproochSakeschKoyra ChiiniKhowarKirmanj" +
			"kiKakoKalenjinKimbundu-SproochKomi-PermiakKonkaniKosraeaneschKpelle-" +
			"SproochKaratschaiesch-BalkareschKrioKinaray-aKareleschOraon-SproochS" +
			"hambalaBafiaKölschKumükeschKutenai-SproochLadinoLangiLahndaLamba-Spr" +
			"oochLesgeschLingua Franca NovaLigureschLiveschLakota-SproochLombarde" +
			"schMongoRotse-SproochLettgalleschLuba-LuluaLuiseno-SproochLunda-Spro" +
			"ochLuo-SproochLushai-SproochOlulujiaKlassescht ChineseschLasesch Spr" +
			"oochMadureseschMafaKhottaMaithiliMakassareschManding-SproochMassai-S" +
			"proochMabaMokshaMandareseschMende-SproochMeru-SproochMorisyenMëtteli" +
			"reschMakhuwa-MeettoMeta’Micmac-SproochMinangkabau-SproochMandschures" +
			"chMeithei-SproochMohawk-SproochMossi-SproochWest-MariMundangMéisproo" +
			"chegMuskogee-SproochMirandeseschMarwariMentawaiMyeneErsja-Mordwinesc" +
			"hMazandaraniMin-Nan-ChineseschNeapolitaneschNamaNidderdäitschNewariN" +
			"ias-SproochNiue-SproochAo NagaKwasioNgiemboonNogaiAlnordeschNovialN’" +
			"KoNord-Sotho-SproochNuerAl-NewariNyamwezi-SproochNyankoleNyoroNzimaO" +
			"sage-SproochOsmaneschPangasinan-SproochMëttelperseschPampanggan-Spro" +
			"ochPapiamentoPalauPicardeschPennsylvaniadäitschPlattdäitschAlpersesc" +
			"hPfälzesch DäitschPhönikeschPiemonteseschPonteschPonapeaneschPreises" +
			"chAlprovenzaleschQuiché-SproochKichwa (Chimborazo-Gebidder)Rajasthan" +
			"iOuschterinsel-SproochRarotonganeschRomagnolTarifitRomboRomaniRotuma" +
			"neschRussineschRovianaAromuneschRwaSandawe-SproochJakuteschSamaritan" +
			"eschSamburuSasakSantaliSaurashtraNgambaySanguSizilianeschSchotteschS" +
			"assareseschSenecaSenaSeriSelkupeschKoyra SenniAlireschSamogiteschTas" +
			"chelhitSchan-SproochTschadesch-ArabeschSidamoNidderschleseschSelayar" +
			"SüdsameschLule-LappeschInari-LappeschSkolt-LappeschSoninke-SproochSo" +
			"gdeschSrananeschSerer-SproochSahoSaterfrieseschSukuma-SproochSusuSum" +
			"ereschKomoreschKongo-SwahiliAlsyreschSyreschSchleseschTuluTemneTesoT" +
			"ereno-SproochTetum-SproochTigreTiv-SproochTokelauaneschTsachureschKl" +
			"ingoneschTlingit-SproochTaleschTamaseqTsonga-SproochNeimelaneseschTu" +
			"royoSeediqTsakoneschTsimshian-SproochTateschTumbuka-SproochElliceane" +
			"schTasawaqTuwineschMëttlert-Atlas-TamazightUdmurteschUgariteschMbund" +
			"u-SproochRootVai-SproochVenezeschWepseschWestflämeschMainfränkeschWo" +
			"teschVoroVunjoWalliserdäitschWalamo-SproochWarayWasho-SproochWu-Chin" +
			"eseschKalmückeschMingrelesch SproochSogaYao-SproochYapeseschYangbenY" +
			"embaNheengatuKantoneseschZapotekeschBliss-SymbolerSeelänneschZenagaM" +
			"arokkanescht Standard-TamazightZuni-SproochKeng SproochinhalterZazaM" +
			"odernt HéicharabeschÉisträichescht DäitschSchwäizer HéichdäitschAust" +
			"ralescht EngleschKanadescht EngleschBritescht EngleschAmerikanescht " +
			"EngleschLatäinamerikanescht SpueneschEuropäescht SpueneschMexikanesc" +
			"ht SpueneschKanadescht FranséischSchwäizer FranséischFlämeschBrasili" +
			"anescht PortugiseschEuropäescht PortugiseschMoldaweschSerbo-Kroatesc" +
			"hChinesesch (vereinfacht)Chinesesch (traditionell)",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000e, 0x0017, 0x0020, 0x0024, 0x002d, 0x0039,
			0x0041, 0x004c, 0x0054, 0x005a, 0x006b, 0x0077, 0x0085, 0x008f,
			0x0096, 0x00a5, 0x00af, 0x00b8, 0x00c2, 0x00ca, 0x00d5, 0x00e4,
			0x00f4, 0x00fc, 0x0100, 0x010b, 0x011a, 0x0128, 0x0131, 0x0139,
			0x0141, 0x014b, 0x0155, 0x0160, 0x016a, 0x0172, 0x017b, 0x0184,
			0x018c, 0x0194, 0x019c, 0x019f, 0x01a7, 0x01b4, 0x01be, 0x01c9,
			0x01d6, 0x01dc, 0x01f1, 0x01fa, 0x0201, 0x0209, 0x020d, 0x0212,
			0x021c, 0x0221, 0x022a, 0x0233, 0x023e, 0x0247, 0x0250, 0x025e,
			// Entry 40 - 7F
			0x0269, 0x0274, 0x027f, 0x028b, 0x0295, 0x029c, 0x02a7, 0x02b2,
			0x02bd, 0x02c5, 0x02ce, 0x02d7, 0x02e0, 0x02ec, 0x02fa, 0x0302,
			0x030c, 0x031a, 0x0329, 0x0330, 0x033a, 0x0348, 0x0354, 0x035c,
			0x0368, 0x0370, 0x037a, 0x0381, 0x0390, 0x039d, 0x03a8, 0x03af,
			0x03b7, 0x03c0, 0x03cc, 0x03d4, 0x03e5, 0x03f4, 0x03f9, 0x0404,
			0x040d, 0x0417, 0x041e, 0x0427, 0x0431, 0x043b, 0x0444, 0x0458,
			0x0463, 0x0469, 0x0475, 0x0487, 0x0499, 0x04ad, 0x04b3, 0x04c1,
			0x04cc, 0x04da, 0x04df, 0x04e4, 0x04ed, 0x04fa, 0x04fe, 0x0506,
			// Entry 80 - BF
			0x050d, 0x0519, 0x0520, 0x052e, 0x053b, 0x0545, 0x054d, 0x0556,
			0x055e, 0x0566, 0x056c, 0x0577, 0x057c, 0x0589, 0x0593, 0x059d,
			0x05a7, 0x05ac, 0x05b2, 0x05bb, 0x05c3, 0x05c8, 0x05da, 0x05e6,
			0x05f0, 0x05f7, 0x0600, 0x0606, 0x0612, 0x061f, 0x0627, 0x0632,
			0x0640, 0x0649, 0x0652, 0x0658, 0x0661, 0x066a, 0x0673, 0x067d,
			0x0681, 0x068a, 0x0697, 0x06a4, 0x06ac, 0x06b7, 0x06bc, 0x06c1,
			0x06c9, 0x06cf, 0x06d5, 0x06df, 0x06e3, 0x06ef, 0x06fd, 0x0704,
			0x070f, 0x0722, 0x072a, 0x072f, 0x073b, 0x0744, 0x074b, 0x0754,
			// Entry C0 - FF
			0x075b, 0x0767, 0x0771, 0x0777, 0x0781, 0x078c, 0x0792, 0x07a1,
			0x07b4, 0x07c2, 0x07d8, 0x07eb, 0x07f9, 0x0813, 0x081f, 0x0825,
			0x082b, 0x0841, 0x084d, 0x0858, 0x0860, 0x086d, 0x0872, 0x087c,
			0x0888, 0x088f, 0x089c, 0x08a2, 0x08a6, 0x08ab, 0x08b1, 0x08bc,
			0x08c9, 0x08d5, 0x08e1, 0x08e4, 0x08f5, 0x0900, 0x090c, 0x0917,
			0x091d, 0x0921, 0x0927, 0x0931, 0x093c, 0x0940, 0x0944, 0x094b,
			0x0950, 0x0959, 0x095f, 0x0964, 0x096b, 0x096f, 0x097e, 0x098b,
			0x0995, 0x0999, 0x09a0, 0x09a7, 0x09b0, 0x09b8, 0x09c0, 0x09c6,
			// Entry 100 - 13F
			0x09ce, 0x09d6, 0x09e3, 0x09ee, 0x09fc, 0x0a06, 0x0a0b, 0x0a1b,
			0x0a20, 0x0a26, 0x0a33, 0x0a38, 0x0a3d, 0x0a4b, 0x0a58, 0x0a5d,
			0x0a70, 0x0a7a, 0x0a87, 0x0a8d, 0x0a93, 0x0a97, 0x0aa2, 0x0aab,
			0x0ab1, 0x0ab9, 0x0ac8, 0x0ad0, 0x0ad6, 0x0ae4, 0x0af2, 0x0afa,
			0x0b04, 0x0b0f, 0x0b14, 0x0b26, 0x0b33, 0x0b46, 0x0b53, 0x0b5f,
			0x0b68, 0x0b72, 0x0b7c, 0x0b8a, 0x0b8e, 0x0b9b, 0x0bb0, 0x0bb4,
			0x0bc1, 0x0bc7, 0x0bdc, 0x0bec, 0x0bf8, 0x0c05, 0x0c0e, 0x0c15,
			0x0c22, 0x0c2e, 0x0c40, 0x0c45, 0x0c4d, 0x0c5a, 0x0c69, 0x0c76,
			// Entry 140 - 17F
			0x0c86, 0x0c8f, 0x0c9c, 0x0cae, 0x0cb8, 0x0cc4, 0x0cd1, 0x0ce1,
			0x0ce5, 0x0ce9, 0x0cef, 0x0cfe, 0x0d09, 0x0d13, 0x0d29, 0x0d2f,
			0x0d35, 0x0d3c, 0x0d4d, 0x0d5e, 0x0d66, 0x0d74, 0x0d7d, 0x0d8b,
			0x0d8e, 0x0d93, 0x0d97, 0x0da3, 0x0daa, 0x0dae, 0x0db5, 0x0dc1,
			0x0dc8, 0x0dcc, 0x0dd4, 0x0de1, 0x0de8, 0x0df4, 0x0dfa, 0x0e03,
			0x0e07, 0x0e0f, 0x0e1f, 0x0e2b, 0x0e32, 0x0e3e, 0x0e4c, 0x0e65,
			0x0e69, 0x0e72, 0x0e7b, 0x0e88, 0x0e90, 0x0e95, 0x0e9c, 0x0ea6,
			0x0eb5, 0x0ebb, 0x0ec0, 0x0ec6, 0x0ed3, 0x0edb, 0x0eed, 0x0ef6,
			// Entry 180 - 1BF
			0x0efd, 0x0f0b, 0x0f16, 0x0f1b, 0x0f28, 0x0f34, 0x0f3e, 0x0f4d,
			0x0f5a, 0x0f65, 0x0f73, 0x0f7b, 0x0f90, 0x0f9f, 0x0faa, 0x0fae,
			0x0fb4, 0x0fbc, 0x0fc8, 0x0fd7, 0x0fe5, 0x0fe9, 0x0fef, 0x0ffb,
			0x1008, 0x1014, 0x101c, 0x1029, 0x1037, 0x103e, 0x104c, 0x105f,
			0x106c, 0x107b, 0x1089, 0x1096, 0x109f, 0x10a6, 0x10b3, 0x10c3,
			0x10cf, 0x10d6, 0x10de, 0x10e3, 0x10f4, 0x10ff, 0x1111, 0x111f,
			0x1123, 0x1131, 0x1137, 0x1143, 0x114f, 0x1156, 0x115c, 0x1165,
			0x116a, 0x1174, 0x117a, 0x1180, 0x1192, 0x1196, 0x119f, 0x11af,
			// Entry 1C0 - 1FF
			0x11b7, 0x11bc, 0x11c1, 0x11ce, 0x11d7, 0x11e9, 0x11f8, 0x120a,
			0x1214, 0x1219, 0x1223, 0x1237, 0x1244, 0x124e, 0x1261, 0x126c,
			0x1279, 0x1281, 0x128d, 0x1296, 0x12a5, 0x12b4, 0x12d0, 0x12da,
			0x12ef, 0x12fd, 0x1305, 0x130c, 0x1311, 0x1317, 0x1322, 0x132c,
			0x1333, 0x133d, 0x1340, 0x134f, 0x1358, 0x1365, 0x136c, 0x1371,
			0x1378, 0x1382, 0x1389, 0x138e, 0x139a, 0x13a4, 0x13b0, 0x13b6,
			0x13ba, 0x13be, 0x13c8, 0x13d3, 0x13db, 0x13e6, 0x13f0, 0x13fd,
			0x1410, 0x1416, 0x1426, 0x142d, 0x1438, 0x1445, 0x1453, 0x1461,
			// Entry 200 - 23F
			0x1470, 0x1478, 0x1482, 0x148f, 0x1493, 0x14a1, 0x14af, 0x14b3,
			0x14bc, 0x14c5, 0x14d2, 0x14db, 0x14e2, 0x14ec, 0x14f0, 0x14f5,
			0x14f9, 0x1507, 0x1514, 0x1519, 0x1524, 0x1531, 0x153c, 0x1547,
			0x1556, 0x155d, 0x1564, 0x1572, 0x1580, 0x1586, 0x158c, 0x1596,
			0x15a7, 0x15ae, 0x15bd, 0x15c9, 0x15d0, 0x15d9, 0x15f2, 0x15fc,
			0x1606, 0x1614, 0x1618, 0x1623, 0x162c, 0x1634, 0x1641, 0x164f,
			0x1656, 0x165a, 0x165f, 0x166f, 0x167d, 0x1682, 0x168f, 0x168f,
			0x169c, 0x16a8, 0x16bb, 0x16bf, 0x16ca, 0x16d3, 0x16da, 0x16df,
			// Entry 240 - 27F
			0x16e8, 0x16f4, 0x16ff, 0x170d, 0x1719, 0x171f, 0x173f, 0x174b,
			0x175f, 0x1763, 0x1779, 0x1792, 0x17ab, 0x17c0, 0x17d3, 0x17e5,
			0x17fb, 0x1819, 0x182f, 0x1845, 0x185b, 0x1871, 0x187a, 0x1895,
			0x18ae, 0x18b8, 0x18c7, 0x18df, 0x18f8,
		},
	},
	{ // lg
		"Lu-akaaniLu-amharikiLuwarabuLubelarusiLubulugariyaLubengaliLuceekeLudaak" +
			"iLugereeki/LuyonaaniLungerezaLusipanyaLuperusiLufalansaLuhawuzaLuhin" +
			"duLuhangareLuyindonezyaLuyiboLuyitaleLujapaniLunnajjavaLukmeLukoreya" +
			"LugandaLumalayiLubbamaLunepaliLuholandiLupunjabiLupolandiLupotugiizi" +
			"LulomaniyaLulasaLunarwandaLusomaliyaLuswideniLutamiiruLuttaayiLutake" +
			"LuyukurayineLu-uruduLuvyetinaamuLuyorubaLucayinaLuzzulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0014, 0x0014,
			0x001c, 0x001c, 0x001c, 0x001c, 0x001c, 0x001c, 0x0026, 0x0032,
			0x0032, 0x0032, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
			0x003b, 0x003b, 0x003b, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0049, 0x0049, 0x0049, 0x0049, 0x005c, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x007f,
			0x007f, 0x007f, 0x007f, 0x007f, 0x007f, 0x007f, 0x007f, 0x0087,
			0x0087, 0x008e, 0x008e, 0x008e, 0x008e, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00b1, 0x00b1, 0x00b9, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3,
			0x00c3, 0x00c3, 0x00c8, 0x00c8, 0x00d0, 0x00d0, 0x00d0, 0x00d0,
			0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d7, 0x00d7, 0x00d7,
			0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7,
			0x00d7, 0x00d7, 0x00d7, 0x00df, 0x00df, 0x00e6, 0x00e6, 0x00e6,
			0x00ee, 0x00ee, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
			0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x0100, 0x0100, 0x0109,
			// Entry 80 - BF
			0x0109, 0x0114, 0x0114, 0x0114, 0x0114, 0x011e, 0x0124, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x0138, 0x0138, 0x0138, 0x0138, 0x0138, 0x0138,
			0x0141, 0x0141, 0x014a, 0x014a, 0x014a, 0x0152, 0x0152, 0x0152,
			0x0152, 0x0152, 0x0158, 0x0158, 0x0158, 0x0158, 0x0158, 0x0164,
			0x016c, 0x016c, 0x016c, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178,
			0x0178, 0x0180, 0x0180, 0x0188, 0x018f,
		},
	},
	{ // lkt
		"Abkhaz IyápiAvestan IyápiAfrikaans IyápiAmharic IyápiArab IyápiAssamese " +
			"IyápiAvaric IyápiAzerbaijani IyápiBashkir IyápiBelarus IyápiBulgar I" +
			"yápiBengali IyápiTibetan IyápiBosnia IyápiCatalan IyápiChechen Iyápi" +
			"Maštíŋča Oyáte IyápiCzech IyápiChuvash IyápiWales IyápiDane IyápiIyá" +
			"šiča IyápiGreece IyápiWašíčuiyapiEsperanto IyápiSpayóla IyápiEstoni" +
			"a IyápiBasque IyápiPersian IyápiFinnish IyápiFiji IyápiFaroese Iyápi" +
			"Wašíču Ikčéka IyápiIrish IyápiGalician IyápiGuarani IyápiGujarati Iy" +
			"ápiHausa IyápiHebrew IyápiHindi IyápiCroatian IyápiHaiti IyápiHunga" +
			"ry IyápiArmenia IyápiIndonesia IyápiIgbo IyápiIceland IyápiItalia Iy" +
			"ápiKisúŋla IyápiJava IyápiGeoria IyápiKazakh IyápiKhmer IyápiKannad" +
			"a IyápiKorea IyápiKashmir IyápiKurd IyápiKirghiz IyápiLatin IyápiLux" +
			"embourg IyápiLao IyápiLithuania IyápiltLatvia IyápiMalagasy IyápiMao" +
			"ri IyápiMacedonia IyápiMalayalam IyápiMarathi IyápiMalay IyápiMaltes" +
			"e IyápiBurmese IyápiNepal IyápiDutch IyápiŠináglegleǧa IyápiȞaȟátȟuŋ" +
			"waŋ IyápiOriya IyápiPunjabi IyápiPolish IyápiPashto IyápiPortuguese " +
			"IyápiQuechua IyápiRomansh IyápiRomanian IyápiRussia IyápiSanskrit Iy" +
			"ápiSindhi IyápiSinhala IyápiSlovak IyápiSlovenian IyápiSomali Iyápi" +
			"Albanian IyápiSerbia IyápiSundanese IyápiSwedish IyápiSwahili IyápiT" +
			"amil IyápiTelugu IyápiTajik IyápiThai IyápiTigrinya IyápiTurkmen Iyá" +
			"piTongan IyápiTurkish IyápiTatar IyápiUyghur IyápiUkrain IyápiUrdu I" +
			"yápiUzbek IyápiVietnamese IyápiWolof IyápiXhosa IyápiYoruba IyápiPȟe" +
			"čhókaŋ Háŋska IyápiZulu IyápiAdyghe IyápiItóǧata Altai IyápiMaȟpíya" +
			" Tȟó IyápiBaluchi IyápiBamun IyápiBeja IyápiBuriat IyápiMari IyápiCh" +
			"erokee IyápiŠahíyela IyápiCoptic IyápiCrimean Turkish IyápiDakȟótiya" +
			"piDargwa IyápiDogri IyápiFilipino IyápiGbaya IyápiHawaiian IyápiIngu" +
			"sh IyápiKara-Kalpak IyápiKabardian IyápiLahnda IyápiLakȟólʼiyapiMizo" +
			" IyápiNamipuri IyápiComonian IyápiTukté iyápi tȟaŋíŋ šniZaza IyápiŠa" +
			"gláša WašíčuiyapiMílahaŋska WašíčuiyapiWiyóȟpeyata Spayóla IyápiSpay" +
			"ólaȟča IyápiFlemish IyápiPȟečhókaŋ Háŋska Iyápi IkčékaPȟečhókaŋ Háŋ" +
			"ska Iyápi Ȟče",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000d, 0x001b, 0x002b, 0x002b, 0x0039, 0x0039,
			0x0044, 0x0053, 0x0060, 0x0060, 0x0072, 0x0080, 0x008e, 0x009b,
			0x009b, 0x009b, 0x00a9, 0x00b7, 0x00b7, 0x00c4, 0x00d2, 0x00e0,
			0x00e0, 0x00e0, 0x00fa, 0x0106, 0x0106, 0x0114, 0x0120, 0x012b,
			0x013c, 0x013c, 0x013c, 0x013c, 0x0149, 0x0157, 0x0167, 0x0176,
			0x0184, 0x0191, 0x019f, 0x019f, 0x01ad, 0x01b8, 0x01c6, 0x01df,
			0x01df, 0x01eb, 0x01eb, 0x01fa, 0x0208, 0x0217, 0x0217, 0x0223,
			0x0230, 0x023c, 0x023c, 0x024b, 0x0257, 0x0265, 0x0273, 0x0273,
			// Entry 40 - 7F
			0x0273, 0x0283, 0x0283, 0x028e, 0x028e, 0x028e, 0x028e, 0x029c,
			0x02a9, 0x02a9, 0x02b9, 0x02c4, 0x02d1, 0x02d1, 0x02d1, 0x02d1,
			0x02de, 0x02de, 0x02ea, 0x02f8, 0x0304, 0x0304, 0x0312, 0x031d,
			0x031d, 0x031d, 0x032b, 0x0337, 0x0348, 0x0348, 0x0348, 0x0348,
			0x0352, 0x0364, 0x0364, 0x0371, 0x0380, 0x0380, 0x038c, 0x039c,
			0x03ac, 0x03ac, 0x03ba, 0x03c6, 0x03d4, 0x03e2, 0x03e2, 0x03e2,
			0x03ee, 0x03ee, 0x03fa, 0x03fa, 0x03fa, 0x03fa, 0x0410, 0x0410,
			0x0410, 0x0428, 0x0428, 0x0434, 0x0434, 0x0442, 0x0442, 0x044f,
			// Entry 80 - BF
			0x045c, 0x046d, 0x047b, 0x0489, 0x0489, 0x0498, 0x04a5, 0x04a5,
			0x04b4, 0x04b4, 0x04c1, 0x04c1, 0x04c1, 0x04cf, 0x04dc, 0x04ec,
			0x04ec, 0x04ec, 0x04f9, 0x0508, 0x0515, 0x0515, 0x0515, 0x0525,
			0x0533, 0x0541, 0x054d, 0x055a, 0x0566, 0x0571, 0x0580, 0x058e,
			0x058e, 0x059b, 0x05a9, 0x05a9, 0x05b5, 0x05b5, 0x05c2, 0x05cf,
			0x05da, 0x05e6, 0x05e6, 0x05f7, 0x05f7, 0x05f7, 0x0603, 0x060f,
			0x060f, 0x061c, 0x061c, 0x0639, 0x0644, 0x0644, 0x0644, 0x0644,
			0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651,
			// Entry C0 - FF
			0x0651, 0x0667, 0x0667, 0x0667, 0x0667, 0x0667, 0x0667, 0x067d,
			0x067d, 0x067d, 0x067d, 0x067d, 0x067d, 0x067d, 0x067d, 0x067d,
			0x067d, 0x067d, 0x068b, 0x068b, 0x068b, 0x068b, 0x0697, 0x0697,
			0x0697, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2,
			0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2,
			0x06a2, 0x06a2, 0x06a2, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af,
			0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af,
			0x06af, 0x06ba, 0x06ba, 0x06ba, 0x06ba, 0x06c9, 0x06da, 0x06da,
			// Entry 100 - 13F
			0x06e7, 0x06e7, 0x06fd, 0x06fd, 0x070a, 0x0717, 0x0717, 0x0717,
			0x0717, 0x0717, 0x0717, 0x0717, 0x0723, 0x0723, 0x0723, 0x0723,
			0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723,
			0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0732,
			0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732,
			0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x073e, 0x073e, 0x073e,
			0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e,
			0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e,
			// Entry 140 - 17F
			0x073e, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d,
			0x074d, 0x074d, 0x074d, 0x074d, 0x075a, 0x075a, 0x075a, 0x075a,
			0x075a, 0x075a, 0x075a, 0x075a, 0x075a, 0x076c, 0x076c, 0x076c,
			0x076c, 0x076c, 0x076c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x0789, 0x0789, 0x0789, 0x0789, 0x0789,
			// Entry 180 - 1BF
			0x0789, 0x0798, 0x0798, 0x0798, 0x0798, 0x0798, 0x0798, 0x0798,
			0x0798, 0x0798, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3,
			0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3,
			0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3,
			0x07a3, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			// Entry 1C0 - 1FF
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			// Entry 200 - 23F
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de,
			0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de,
			0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de,
			// Entry 240 - 27F
			0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de,
			0x07de, 0x07e9, 0x07e9, 0x07e9, 0x07e9, 0x07e9, 0x07e9, 0x0802,
			0x081d, 0x083a, 0x084e, 0x084e, 0x084e, 0x084e, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x0882, 0x08a5,
		},
	},
	{ // ln
		"akanliamarikilialabolibyelorisílibiligalilibengalilitshekɛlialemáligelek" +
			"ilingɛlɛ́salisipanyelipelésanɛlifalansɛ́hausalihindiliongililindonez" +
			"iigbolitalianolizapɔlizavalikambodzalikoreyalingálalimalezilibilimál" +
			"inepalɛlifalamálipendzabilipolonɛlipulutugɛ́siliromanilirisíkinyarwa" +
			"ndalisomalilisuwedɛlitamulilitayelitilikilikrɛniliurduliviyetinámiyo" +
			"rubalisinwazulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000d, 0x000d,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0033, 0x0033, 0x0033, 0x0033, 0x0033, 0x0033,
			0x0033, 0x0033, 0x0033, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x004c, 0x0059, 0x0059, 0x0062,
			0x0062, 0x0062, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x007a,
			0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007f,
			0x007f, 0x0086, 0x0086, 0x0086, 0x0086, 0x008e, 0x008e, 0x008e,
			// Entry 40 - 7F
			0x008e, 0x0097, 0x0097, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x00a4, 0x00a4, 0x00ab, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00bb, 0x00bb, 0x00c3, 0x00c3, 0x00c3, 0x00c3,
			0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00d3, 0x00d3, 0x00dc, 0x00dc, 0x00dc,
			0x00e5, 0x00e5, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee,
			0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00f8, 0x00f8, 0x0101,
			// Entry 80 - BF
			0x0101, 0x0110, 0x0110, 0x0110, 0x0110, 0x0118, 0x011f, 0x012a,
			0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a,
			0x012a, 0x012a, 0x0132, 0x0132, 0x0132, 0x0132, 0x0132, 0x0132,
			0x013b, 0x013b, 0x0143, 0x0143, 0x0143, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0151, 0x0151, 0x0151, 0x0151, 0x0151, 0x0159,
			0x015f, 0x015f, 0x015f, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x0172, 0x0172, 0x0179, 0x017d,
		},
	},
	{ // lo
		loLangStr,
		loLangIdx,
	},
	{ // lt
		ltLangStr,
		ltLangIdx,
	},
	{ // lu
		"LiakanLiamharikiArabiBelarusiBulegariBengaliTshekiLizelumaniGilikiLingel" +
			"esaLihispaniaMpepajemiMfwàlànsaHausaHindiHongiliLindoneziaIgboLitali" +
			"LiyapaniJavaLikoreyaTshilubaLimalezianepaliolandiLipunjabiMpoloniMpu" +
			"tulugɛsiLiromaniLirisikinyarwandaLisomaliLisuwidiMtamuiliNtailandiNt" +
			"ulukiNkraniUrduLiviyetinamuNyorubashinɛNzulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0010, 0x0010,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001d, 0x0025,
			0x0025, 0x0025, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x003c, 0x003c, 0x003c, 0x003c, 0x0042, 0x004b, 0x004b, 0x0055,
			0x0055, 0x0055, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x006e,
			0x006e, 0x0073, 0x0073, 0x0073, 0x0073, 0x007a, 0x007a, 0x007a,
			// Entry 40 - 7F
			0x007a, 0x0084, 0x0084, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088,
			0x008e, 0x008e, 0x0096, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00b3, 0x00b3, 0x00b3, 0x00b3, 0x00b3,
			0x00b9, 0x00b9, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf,
			// Entry 80 - BF
			0x00cf, 0x00db, 0x00db, 0x00db, 0x00db, 0x00e3, 0x00e9, 0x00f4,
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			0x00f4, 0x00f4, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x0104, 0x0104, 0x010c, 0x010c, 0x010c, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x0122,
			0x0126, 0x0126, 0x0126, 0x0132, 0x0132, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0139, 0x0139, 0x013f, 0x0144,
		},
	},
	{ // luo
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluDholuo",
		[]uint16{ // 394 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 180 - 1BF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x016f,
		},
	},
	{ // luy
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiLusunguKihispaniaKiajemiKifaransaKihausaLuhindiKihungariKiindones" +
			"iaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaKin" +
			"epaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKiso" +
			"maliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyoru" +
			"baKichinaKizuluLuluhia",
		[]uint16{ // 396 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0052, 0x0052, 0x005c,
			0x005c, 0x005c, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x006c,
			0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x0073,
			0x0073, 0x007a, 0x007a, 0x007a, 0x007a, 0x0083, 0x0083, 0x0083,
			// Entry 40 - 7F
			0x0083, 0x008e, 0x008e, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x009e, 0x009e, 0x00a6, 0x00ac, 0x00ac, 0x00ac, 0x00ac, 0x00ac,
			0x00ac, 0x00ac, 0x00b6, 0x00b6, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00c6, 0x00c6, 0x00cd, 0x00cd, 0x00cd,
			0x00d5, 0x00d5, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00e7, 0x00e7, 0x00f0,
			// Entry 80 - BF
			0x00f0, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00ff, 0x0105, 0x0110,
			0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110,
			0x0110, 0x0110, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
			0x011f, 0x011f, 0x0126, 0x0126, 0x0126, 0x0130, 0x0130, 0x0130,
			0x0130, 0x0130, 0x0138, 0x0138, 0x0138, 0x0138, 0x0138, 0x0141,
			0x0147, 0x0147, 0x0147, 0x0152, 0x0152, 0x0152, 0x0152, 0x0152,
			0x0152, 0x015a, 0x015a, 0x0161, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry C0 - FF
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry 100 - 13F
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry 140 - 17F
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry 180 - 1BF
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x016e,
		},
	},
	{ // lv
		lvLangStr,
		lvLangIdx,
	},
	{ // mas
		"nkʉtʉ́k ɔ́ɔ̄ lAkannkʉtʉ́k ɔ́ɔ̄ lAmharinkʉtʉ́k ɔ́ɔ̄ lmarabunkʉtʉ́k ɔ́ɔ̄ l" +
			"Belarusinkʉtʉ́k ɔ́ɔ̄ lBulgarialnkʉtʉ́k ɔ́ɔ̄ lBengalinkʉtʉ́k ɔ́ɔ̄ lch" +
			"ekinkʉtʉ́k ɔ́ɔ̄ ljerumaninkʉtʉ́k ɔ́ɔ̄ lgirikinkʉtʉ́k ɔ́ɔ̄ nkɨ́resank" +
			"ʉtʉ́k ɔ́ɔ̄ lspaniankʉtʉ́k ɔ́ɔ̄ lpersiankʉtʉ́k ɔ́ɔ̄ faransankʉtʉ́k ɔ" +
			"́ɔ̄ hausankʉtʉ́k ɔ́ɔ̄ lmoindinkʉtʉ́k ɔ́ɔ̄ lhungarinkʉtʉ́k ɔ́ɔ̄ Indo" +
			"nesiankʉtʉ́k ɔ́ɔ̄ Igbonkʉtʉ́k ɔ́ɔ̄ ltaliannkʉtʉ́k ɔ́ɔ̄ japaninkʉtʉ́k" +
			" ɔ́ɔ̄ ljanankʉtʉ́k ɔ́ɔ̄ lkambodiankʉtʉ́k ɔ́ɔ̄ lkoreankʉtʉ́k ɔ́ɔ̄ mal" +
			"aynkʉtʉ́k ɔ́ɔ̄ lBurmankʉtʉ́k ɔ́ɔ̄ lnepalinkʉtʉ́k ɔ́ɔ̄ lduchinkʉtʉ́k " +
			"ɔ́ɔ̄ lpunjabinkʉtʉ́k ɔ́ɔ̄ lpolandnkʉtʉ́k ɔ́ɔ̄ lportuguesenkʉtʉ́k ɔ́" +
			"ɔ̄ lromaniankʉtʉ́k ɔ́ɔ̄ lrusinkʉtʉ́k ɔ́ɔ̄ lruwandankʉtʉ́k ɔ́ɔ̄ lchu" +
			"marinkʉtʉ́k ɔ́ɔ̄ lswidinkʉtʉ́k ɔ́ɔ̄ ltamilnkʉtʉ́k ɔ́ɔ̄ ltainkʉtʉ́k ɔ" +
			"́ɔ̄ lturukinkʉtʉ́k ɔ́ɔ̄ lkraniankʉtʉ́k ɔ́ɔ̄ lurdunkʉtʉ́k ɔ́ɔ̄ lviet" +
			"inamunkʉtʉ́k ɔ́ɔ̄ lyorubankʉtʉ́k ɔ́ɔ̄ lchinankʉtʉ́k ɔ́ɔ̄ lzuluMaa",
		[]uint16{ // 405 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0034, 0x0034,
			0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x006c, 0x0089,
			0x0089, 0x0089, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6,
			0x00a6, 0x00a6, 0x00a6, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00f8, 0x0116, 0x0116, 0x0131,
			0x0131, 0x0131, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0180,
			0x0180, 0x019b, 0x019b, 0x019b, 0x019b, 0x01b7, 0x01b7, 0x01b7,
			// Entry 40 - 7F
			0x01b7, 0x01d4, 0x01d4, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec,
			0x0207, 0x0207, 0x0221, 0x023a, 0x023a, 0x023a, 0x023a, 0x023a,
			0x023a, 0x023a, 0x0257, 0x0257, 0x0271, 0x0271, 0x0271, 0x0271,
			0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271,
			0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271,
			0x0271, 0x0271, 0x0271, 0x028a, 0x028a, 0x02a4, 0x02a4, 0x02a4,
			0x02bf, 0x02bf, 0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02d9,
			0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02f5, 0x02f5, 0x0310,
			// Entry 80 - BF
			0x0310, 0x032f, 0x032f, 0x032f, 0x032f, 0x034b, 0x0364, 0x0380,
			0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380,
			0x0380, 0x0380, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x03b6, 0x03b6, 0x03d0, 0x03d0, 0x03d0, 0x03e8, 0x03e8, 0x03e8,
			0x03e8, 0x03e8, 0x0403, 0x0403, 0x0403, 0x0403, 0x0403, 0x041e,
			0x0437, 0x0437, 0x0437, 0x0455, 0x0455, 0x0455, 0x0455, 0x0455,
			0x0455, 0x0470, 0x0470, 0x048a, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry C0 - FF
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry 100 - 13F
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry 140 - 17F
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry 180 - 1BF
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a6,
		},
	},
	{ // mer
		"KĩakaniKĩamarĩkiKĩarabuKĩbelarusiKĩbulugĩriaKĩbangiraKĩchekiKĩnjamanĩKĩn" +
			"girikiKĩngerethaKĩspĩniKĩpasiaKĩfuransiKĩhausaKĩhĩndiKĩhangarĩKĩindo" +
			"nesiaKĩigboKĩitalĩKĩjapaniKĩjavaKĩkambodiaKĩkoreaKĩmalesiaKĩburmaKĩn" +
			"epaliKĩholandiKĩpunjabuKĩpolandiKĩpochogoKĩromaniaKĩrashiaKĩrwandaKĩ" +
			"somaliKĩswideniKĩtamiluKĩthailandiKĩtakĩKĩukirĩniKĩurduKĩvietinamuKĩ" +
			"yorubaKĩchinaKĩzuluKĩmĩrũ",
		[]uint16{ // 410 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0013, 0x0013,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x0026, 0x0033,
			0x0033, 0x0033, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x003d, 0x003d, 0x003d, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0050, 0x0050, 0x0050, 0x0050, 0x005a, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0080,
			0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0088,
			0x0088, 0x0091, 0x0091, 0x0091, 0x0091, 0x009c, 0x009c, 0x009c,
			// Entry 40 - 7F
			0x009c, 0x00a8, 0x00a8, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af,
			0x00b8, 0x00b8, 0x00c1, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00d3, 0x00d3, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00e5, 0x00e5, 0x00ed, 0x00ed, 0x00ed,
			0x00f6, 0x00f6, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
			0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x010a, 0x010a, 0x0114,
			// Entry 80 - BF
			0x0114, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128, 0x0131, 0x013a,
			0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a,
			0x013a, 0x013a, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
			0x014d, 0x014d, 0x0156, 0x0156, 0x0156, 0x0162, 0x0162, 0x0162,
			0x0162, 0x0162, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x0175,
			0x017c, 0x017c, 0x017c, 0x0188, 0x0188, 0x0188, 0x0188, 0x0188,
			0x0188, 0x0191, 0x0191, 0x0199, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry C0 - FF
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry 100 - 13F
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry 140 - 17F
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry 180 - 1BF
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a9,
		},
	},
	{ // mfe
		"akanamarikarabbielorisbilgarbengalitchekalmangrekangleespagnolpersanfran" +
			"sehaoussahindihongrwaindonezienigboitalienzaponezavanekhmer, santral" +
			"koreenmalebirmannepaleolandepenjabipoloneportigerouminrisrwandasomal" +
			"iswedwatamoulthaïtirkikrenienourdouvietnamienyorubasinwa, mandarinzo" +
			"uloukreol morisien",
		[]uint16{ // 411 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000a, 0x000a,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x0016, 0x001c,
			0x001c, 0x001c, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x002d, 0x002d, 0x002d, 0x002d, 0x0031, 0x0036, 0x0036, 0x003e,
			0x003e, 0x003e, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x004a,
			0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x0051,
			0x0051, 0x0056, 0x0056, 0x0056, 0x0056, 0x005d, 0x005d, 0x005d,
			// Entry 40 - 7F
			0x005d, 0x0067, 0x0067, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x0072, 0x0072, 0x0078, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e,
			0x007e, 0x007e, 0x008c, 0x008c, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0096, 0x0096, 0x009c, 0x009c, 0x009c,
			0x00a2, 0x00a2, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
			0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00af, 0x00af, 0x00b5,
			// Entry 80 - BF
			0x00b5, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00c2, 0x00c5, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00d1, 0x00d1, 0x00d1, 0x00d1, 0x00d1, 0x00d1,
			0x00d7, 0x00d7, 0x00dd, 0x00dd, 0x00dd, 0x00e2, 0x00e2, 0x00e2,
			0x00e2, 0x00e2, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00ee,
			0x00f4, 0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe,
			0x00fe, 0x0104, 0x0104, 0x0113, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry C0 - FF
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry 100 - 13F
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry 140 - 17F
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry 180 - 1BF
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0127,
		},
	},
	{ // mg
		"AkanAmharikaAraboBielorosyBiolgaraBengaliTsekyAlemaninaGrikaAnglisyEspan" +
			"iolaPersaFrantsayhaoussahindihongroàIndonezianinaigboItalianinaJapon" +
			"eyJavaneykhmerKoreaninaMalagasyMalayBirmanaNepaleHolandeyPenjabiPolo" +
			"neyPortiogeyRomanianinaRosianinaRoandeSomalianinaSoisaTamoilaTaioane" +
			"yTiorkaOkrainianinaOrdòVietnamianinaYôrobàSinoa, MandarinZolò",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000c, 0x000c,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x001a, 0x0022,
			0x0022, 0x0022, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
			0x0029, 0x0029, 0x0029, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x0037, 0x0037, 0x0037, 0x0037, 0x003c, 0x0043, 0x0043, 0x004c,
			0x004c, 0x004c, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0060,
			0x0060, 0x0065, 0x0065, 0x0065, 0x0065, 0x006d, 0x006d, 0x006d,
			// Entry 40 - 7F
			0x006d, 0x007a, 0x007a, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e,
			0x0088, 0x0088, 0x008f, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x0096, 0x0096, 0x009b, 0x009b, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00ac, 0x00ac, 0x00ac, 0x00ac,
			0x00ac, 0x00ac, 0x00ac, 0x00b1, 0x00b1, 0x00b8, 0x00b8, 0x00b8,
			0x00be, 0x00be, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00cd, 0x00cd, 0x00d4,
			// Entry 80 - BF
			0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00f1, 0x00f7,
			0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
			0x00f7, 0x00f7, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102,
			0x0107, 0x0107, 0x010e, 0x010e, 0x010e, 0x0116, 0x0116, 0x0116,
			0x0116, 0x0116, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x0128,
			0x012d, 0x012d, 0x012d, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a,
			0x013a, 0x0142, 0x0142, 0x0151, 0x0156,
		},
	},
	{ // mgh
		"IkanImhariIarabuIbelausiIbulgariaIbanglaIchekiIjerimaniIgirikiIngilishiI" +
			"hispaniolaIajemiIfaransaIhausaIhindiIhungariIgboItalianoIjapaniIjava" +
			"IkambodiaIkoreaImalesiaIburmaInepaliIholanziIpunjabiIpolandiNrenoIro" +
			"maniaIrisiInyarandaIsomaliIswidiItamilItailandiIturukiIukranIhurduIv" +
			"yetinamuIyorubaIchinaIzuluMakua",
		[]uint16{ // 413 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000a, 0x000a,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0018, 0x0021,
			0x0021, 0x0021, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x0037, 0x0037, 0x0037, 0x0037, 0x003e, 0x0047, 0x0047, 0x0052,
			0x0052, 0x0052, 0x0058, 0x0058, 0x0058, 0x0058, 0x0058, 0x0060,
			0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0066,
			0x0066, 0x006c, 0x006c, 0x006c, 0x006c, 0x0074, 0x0074, 0x0074,
			// Entry 40 - 7F
			0x0074, 0x0074, 0x0074, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078,
			0x0080, 0x0080, 0x0087, 0x008c, 0x008c, 0x008c, 0x008c, 0x008c,
			0x008c, 0x008c, 0x0095, 0x0095, 0x009b, 0x009b, 0x009b, 0x009b,
			0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x009b, 0x009b, 0x009b, 0x00a3, 0x00a3, 0x00a9, 0x00a9, 0x00a9,
			0x00b0, 0x00b0, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8,
			0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00c0, 0x00c0, 0x00c8,
			// Entry 80 - BF
			0x00c8, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00d5, 0x00da, 0x00e3,
			0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3,
			0x00e3, 0x00e3, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00f0, 0x00f0, 0x00f6, 0x00f6, 0x00f6, 0x00ff, 0x00ff, 0x00ff,
			0x00ff, 0x00ff, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x010c,
			0x0112, 0x0112, 0x0112, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x0123, 0x0123, 0x0129, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry C0 - FF
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry 100 - 13F
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry 140 - 17F
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry 180 - 1BF
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x0133,
		},
	},
	{ // mgo
		"metaʼngam tisɔʼ",
		[]uint16{ // 555 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 140 - 17F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 180 - 1BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 1C0 - 1FF
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 200 - 23F
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0012,
		},
	},
	{ // mk
		mkLangStr,
		mkLangIdx,
	},
	{ // ml
		mlLangStr,
		mlLangIdx,
	},
	{ // mn
		mnLangStr,
		mnLangIdx,
	},
	{ // mr
		mrLangStr,
		mrLangIdx,
	},
	{ // ms
		msLangStr,
		msLangIdx,
	},
	{ // mt
		"AfarAbkażjanAvestanAfrikansAkanAmħarikuAragoneseGħarbiAssameseAvarikAjma" +
			"raAżerbajġaniBaxkirBelarussuBulgaruBislamaBambaraBengaliTibetjanBren" +
			"tonBosnijanKatalanĊeċenĊamorroKorsikuKrijĊekSlaviku tal-KnisjaĊuvaxW" +
			"elxDaniżĠermaniżDiveħiDżongkaEweGriegIngliżEsperantoSpanjolEstonjanB" +
			"askPersjanFulaħFinlandiżFiġiFawriżFranċiżFriżjanIrlandiżGalliku Skoċ" +
			"ċiżGallegjanGwaraniGuġaratiManksĦawsaEbrajkĦindiĦiri MotuKroatHaiti" +
			"anUngeriżArmenjanĦereroInterlinguaIndoneżjanInterlingueIgboSichuan Y" +
			"iInupjakIdoIżlandiżTaljanInukitutĠappuniżĠavaniżĠorġjanKongoKikujuKu" +
			"anyamaKażakKalallisutKmerKannadaKorejanKanuriKaxmiriKurdiżKomiKornik" +
			"uKirgiżLatinLetżburgiżGandaLimburgishLingaljanLaoLitwanjanLuba-Katan" +
			"gaLatvjanMalagażiMarxallMaoriMaċedonjanMalajalamMongoljanMaratiMalaj" +
			"anMaltiBurmiżNawuruNdebele, ta’ FuqNepaliżNdongaOlandiżNinorsk Norve" +
			"ġiżBokmahal NorveġiżNdebele, t’IsfelNavaħoĊiċewa; NjanġaOċċitanOġib" +
			"waOromo (Afan)OrijaOssettikuPunġabiPaliPollakkPaxtunPortugiżKeċwaRet" +
			"o-RomanzRundiRumenRussuKinjarwandaSanskritSardinjanSindiSami ta’ Fuq" +
			"SangoSinħaliżSlovakkSlovenSamojanXonaSomaliAlbaniżSerbSwatiSoto, t’I" +
			"sfelSundaniżSvediżSwaħiliTamilTeluguTaġikTajlandiżTigrinjaTurkmeniZw" +
			"anaTonganTorkTsongaTatarTaħitjanWigurUkranjanUrduUżbekVendaVjetnamiż" +
			"VolapukWalloonWolofĦożaJiddixJorubaŻwangĊiniżŻuluAċiniżAkoliAdangmeA" +
			"dygheAfriħiliAjnuAkkadjenAleutIngliż, AntikAngikaAramajkArawkanjanAr" +
			"apaħoArawakAsturianAwadħiBaluċiBaliniżBasaBejaBembaBojpuriBikolBiniS" +
			"iksikaBrajBurjatBuginiżBlinKaddoKaribAtsamSibwanoĊibċaĊagatajĊukeseM" +
			"ariĠargon taċ-ĊinukĊostawĊipewjanĊerokijXajennKoptikuCrimean Turkish" +
			"; Crimean TatarKashubianDakotaDargwaDelawerjanSlavDogribDinkaDogriLo" +
			"wer SorbianDwalaOlandiż, MedjevaliDjulaEfikEġizzjan (Antik)EkajukEla" +
			"mitIngliż, MedjevaliEwondoFangFilippinoFonFranċiż, MedjevaliFranċiż," +
			" AntikFrijuljanGaGajoGbajaGeezGilbertjanĠermaniku, Medjevali PulitĠe" +
			"rmaniku, Antik PulitGondiGorontaloGotikuĠerboGrieg, AntikGwiċinĦajda" +
			"ĦawajjanHiligaynonĦittitĦmongUpper SorbianĦupaIbanIlokoIngushLojban" +
			"Lhudi-PersjanLhudi-GħarbiKara-KalpakKabuljanKaċinKambaKawiKabardianK" +
			"asiKotaniżKimbunduKonkaniKosrejanKpelleKarachay-BalkarKuruskKumikuKu" +
			"tenajLadinoLandaLambaLeżgjanMongoLożiLuba-LuluwaLuwisinużLundaLuwaLu" +
			"xajMaduriżMagaħiMajtiliMakasarMandingwanMasajMokshaMandarMendeIrland" +
			"iż, MedjevaliMikmekMinangkabawManċurjanManipuriMoħakMossiLingwi Dive" +
			"rsiKriekMirandiżMarwariErzyaNeapolitanĠermaniż Komuni; Sassonu Komun" +
			"iNewariNijasNijuwejanNogaiSkandinav, AntikSoto, ta’ FuqClassical New" +
			"ariNjamweżiNyankoleNjoroNżimaOsaġjanTork (Imperu Ottoman)Pangasinjan" +
			"PaħlaviPampamgaPapjamentoPalawjanPersjan AntikFeniċjuPonpejanProvenz" +
			"al, AntikRaġastaniRapanwiRarotonganiŻingaruAromanijanSandaweJakutSam" +
			"ritanSaskaSantaliSkoċċiżSelkupIrlandiż, AntikXanSidamoSouthern SamiL" +
			"ule SamiInari SamiSkolt SamiSoninkeSogdienSererSukumaSusuSumerjanSir" +
			"janTimneTerenoTetumTigreTivTokelauKlingonTlingitTamaxekTonga (Njasa)" +
			"Tok PisinZimxjanTumbukaTuvaluTuvinjanUdmurtUgaritikuUmbunduGħerqVaiV" +
			"otikWalamoWarajWaxoKalmykJaoJapeseŻapotekŻenagaŻuniGħarbi Standard M" +
			"odernIngliż AwstraljanIngliż BrittanikuIngliż AmerikanFranċiż Kanadi" +
			"żFranċiż ŻvizzeruMoldavjanSerbo-KroatĊiniż Simplifikat",
		[]uint16{ // 604 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0014, 0x001c, 0x0020, 0x0029, 0x0032,
			0x0039, 0x0041, 0x0047, 0x004d, 0x005a, 0x0060, 0x0069, 0x0070,
			0x0077, 0x007e, 0x0085, 0x008d, 0x0094, 0x009c, 0x00a3, 0x00aa,
			0x00b2, 0x00b9, 0x00bd, 0x00c1, 0x00d3, 0x00d9, 0x00dd, 0x00e3,
			0x00ed, 0x00f4, 0x00fc, 0x00ff, 0x0104, 0x010b, 0x0114, 0x011b,
			0x0123, 0x0127, 0x012e, 0x0134, 0x013e, 0x0143, 0x014a, 0x0153,
			0x015b, 0x0164, 0x0176, 0x017f, 0x0186, 0x018f, 0x0194, 0x019a,
			0x01a0, 0x01a6, 0x01b0, 0x01b5, 0x01bc, 0x01c4, 0x01cc, 0x01d3,
			// Entry 40 - 7F
			0x01de, 0x01e9, 0x01f4, 0x01f8, 0x0202, 0x0209, 0x020c, 0x0216,
			0x021c, 0x0224, 0x022e, 0x0237, 0x0240, 0x0245, 0x024b, 0x0253,
			0x0259, 0x0263, 0x0267, 0x026e, 0x0275, 0x027b, 0x0282, 0x0289,
			0x028d, 0x0294, 0x029b, 0x02a0, 0x02ac, 0x02b1, 0x02bb, 0x02c4,
			0x02c7, 0x02d0, 0x02dc, 0x02e3, 0x02ec, 0x02f3, 0x02f8, 0x0303,
			0x030c, 0x0315, 0x031b, 0x0322, 0x0327, 0x032e, 0x0334, 0x0346,
			0x034e, 0x0354, 0x035c, 0x036e, 0x0381, 0x0393, 0x039a, 0x03ab,
			0x03b4, 0x03bb, 0x03c7, 0x03cc, 0x03d5, 0x03dd, 0x03e1, 0x03e8,
			// Entry 80 - BF
			0x03ee, 0x03f7, 0x03fd, 0x0408, 0x040d, 0x0412, 0x0417, 0x0422,
			0x042a, 0x0433, 0x0438, 0x0446, 0x044b, 0x0455, 0x045c, 0x0462,
			0x0469, 0x046d, 0x0473, 0x047b, 0x047f, 0x0484, 0x0493, 0x049c,
			0x04a3, 0x04ab, 0x04b0, 0x04b6, 0x04bc, 0x04c6, 0x04ce, 0x04d6,
			0x04db, 0x04e1, 0x04e5, 0x04eb, 0x04f0, 0x04f9, 0x04fe, 0x0506,
			0x050a, 0x0510, 0x0515, 0x051f, 0x0526, 0x052d, 0x0532, 0x0538,
			0x053e, 0x0544, 0x054a, 0x0551, 0x0556, 0x055e, 0x0563, 0x056a,
			0x0570, 0x0570, 0x0579, 0x0579, 0x057d, 0x0585, 0x0585, 0x058a,
			// Entry C0 - FF
			0x058a, 0x058a, 0x0598, 0x059e, 0x05a5, 0x05af, 0x05af, 0x05b7,
			0x05b7, 0x05bd, 0x05bd, 0x05bd, 0x05bd, 0x05bd, 0x05c5, 0x05c5,
			0x05cc, 0x05cc, 0x05d3, 0x05db, 0x05db, 0x05df, 0x05df, 0x05df,
			0x05df, 0x05e3, 0x05e8, 0x05e8, 0x05e8, 0x05e8, 0x05e8, 0x05ef,
			0x05f4, 0x05f8, 0x05f8, 0x05f8, 0x05ff, 0x05ff, 0x05ff, 0x0603,
			0x0603, 0x0603, 0x0603, 0x0609, 0x0611, 0x0611, 0x0615, 0x0615,
			0x061a, 0x061f, 0x061f, 0x0624, 0x062b, 0x062b, 0x0632, 0x063a,
			0x0641, 0x0645, 0x0658, 0x065f, 0x0668, 0x0670, 0x0676, 0x0676,
			// Entry 100 - 13F
			0x067d, 0x067d, 0x069b, 0x06a4, 0x06aa, 0x06b0, 0x06b0, 0x06ba,
			0x06be, 0x06c4, 0x06c9, 0x06c9, 0x06ce, 0x06db, 0x06db, 0x06e0,
			0x06f3, 0x06f3, 0x06f8, 0x06f8, 0x06f8, 0x06fc, 0x06fc, 0x070d,
			0x0713, 0x0719, 0x072b, 0x072b, 0x0731, 0x0731, 0x0735, 0x073e,
			0x073e, 0x0741, 0x0741, 0x0755, 0x0765, 0x0765, 0x0765, 0x0765,
			0x076e, 0x0770, 0x0770, 0x0770, 0x0774, 0x0779, 0x0779, 0x077d,
			0x0787, 0x0787, 0x07a2, 0x07b9, 0x07b9, 0x07be, 0x07c7, 0x07cd,
			0x07d3, 0x07df, 0x07df, 0x07df, 0x07df, 0x07df, 0x07e6, 0x07ec,
			// Entry 140 - 17F
			0x07ec, 0x07f5, 0x07f5, 0x07ff, 0x0806, 0x080c, 0x0819, 0x0819,
			0x081e, 0x0822, 0x0822, 0x0827, 0x082d, 0x082d, 0x082d, 0x0833,
			0x0833, 0x0833, 0x0840, 0x084d, 0x084d, 0x0858, 0x0860, 0x0866,
			0x0866, 0x086b, 0x086f, 0x0878, 0x0878, 0x0878, 0x0878, 0x0878,
			0x0878, 0x0878, 0x0878, 0x087c, 0x0884, 0x0884, 0x0884, 0x0884,
			0x0884, 0x0884, 0x088c, 0x088c, 0x0893, 0x089b, 0x08a1, 0x08b0,
			0x08b0, 0x08b0, 0x08b0, 0x08b6, 0x08b6, 0x08b6, 0x08b6, 0x08bc,
			0x08c3, 0x08c9, 0x08c9, 0x08ce, 0x08d3, 0x08db, 0x08db, 0x08db,
			// Entry 180 - 1BF
			0x08db, 0x08db, 0x08db, 0x08e0, 0x08e5, 0x08e5, 0x08f0, 0x08fa,
			0x08ff, 0x0903, 0x0908, 0x0908, 0x0908, 0x0908, 0x0910, 0x0910,
			0x0917, 0x091e, 0x0925, 0x092f, 0x0934, 0x0934, 0x093a, 0x0940,
			0x0945, 0x0945, 0x0945, 0x0959, 0x0959, 0x0959, 0x095f, 0x096a,
			0x0974, 0x097c, 0x0982, 0x0987, 0x0987, 0x0987, 0x0995, 0x099a,
			0x09a3, 0x09aa, 0x09aa, 0x09aa, 0x09af, 0x09af, 0x09af, 0x09b9,
			0x09b9, 0x09da, 0x09e0, 0x09e5, 0x09ee, 0x09ee, 0x09ee, 0x09ee,
			0x09f3, 0x0a03, 0x0a03, 0x0a03, 0x0a12, 0x0a12, 0x0a22, 0x0a2b,
			// Entry 1C0 - 1FF
			0x0a33, 0x0a38, 0x0a3e, 0x0a46, 0x0a5b, 0x0a66, 0x0a6e, 0x0a76,
			0x0a80, 0x0a88, 0x0a88, 0x0a88, 0x0a88, 0x0a95, 0x0a95, 0x0a9d,
			0x0a9d, 0x0a9d, 0x0aa5, 0x0aa5, 0x0ab5, 0x0ab5, 0x0ab5, 0x0abf,
			0x0ac6, 0x0ad1, 0x0ad1, 0x0ad1, 0x0ad1, 0x0ad9, 0x0ad9, 0x0ad9,
			0x0ad9, 0x0ae3, 0x0ae3, 0x0aea, 0x0aef, 0x0af7, 0x0af7, 0x0afc,
			0x0b03, 0x0b03, 0x0b03, 0x0b03, 0x0b03, 0x0b0d, 0x0b0d, 0x0b0d,
			0x0b0d, 0x0b0d, 0x0b13, 0x0b13, 0x0b23, 0x0b23, 0x0b23, 0x0b26,
			0x0b26, 0x0b2c, 0x0b2c, 0x0b2c, 0x0b39, 0x0b42, 0x0b4c, 0x0b56,
			// Entry 200 - 23F
			0x0b5d, 0x0b64, 0x0b64, 0x0b69, 0x0b69, 0x0b69, 0x0b6f, 0x0b73,
			0x0b7b, 0x0b7b, 0x0b7b, 0x0b7b, 0x0b81, 0x0b81, 0x0b81, 0x0b86,
			0x0b86, 0x0b8c, 0x0b91, 0x0b96, 0x0b99, 0x0ba0, 0x0ba0, 0x0ba7,
			0x0bae, 0x0bae, 0x0bb5, 0x0bc2, 0x0bcb, 0x0bcb, 0x0bcb, 0x0bcb,
			0x0bd2, 0x0bd2, 0x0bd9, 0x0bdf, 0x0bdf, 0x0be7, 0x0be7, 0x0bed,
			0x0bf6, 0x0bfd, 0x0c03, 0x0c06, 0x0c06, 0x0c06, 0x0c06, 0x0c06,
			0x0c0b, 0x0c0b, 0x0c0b, 0x0c0b, 0x0c11, 0x0c16, 0x0c1a, 0x0c1a,
			0x0c1a, 0x0c20, 0x0c20, 0x0c20, 0x0c23, 0x0c29, 0x0c29, 0x0c29,
			// Entry 240 - 27F
			0x0c29, 0x0c29, 0x0c31, 0x0c31, 0x0c31, 0x0c38, 0x0c38, 0x0c3d,
			0x0c3d, 0x0c3d, 0x0c54, 0x0c54, 0x0c54, 0x0c66, 0x0c66, 0x0c78,
			0x0c88, 0x0c88, 0x0c88, 0x0c88, 0x0c9a, 0x0cad, 0x0cad, 0x0cad,
			0x0cad, 0x0cb6, 0x0cc1, 0x0cd4,
		},
	},
	{ // mua
		"akaŋamharikarabiyabelarussiyabulgariabengaliasyekyagermaŋgrekzah Anglofo" +
			"ŋEspaniyaPersiazah sǝr Franssǝhaussahindihungariyaindonesiyaigboita" +
			"liyazah sǝr JapoŋjavaniyakmerkoreamalasiyabirmaniaNepaliyazah sǝr ma" +
			" kasǝŋPǝnjabiPoloniyaZah sǝr PortugalRomaniyaRussiyaZah sǝr RwandaSo" +
			"maliyaSwediaTamulthTurkUkrainiaUrduVietnamiyaYorubazah SyiŋZuluMUNDA" +
			"Ŋ",
		[]uint16{ // 422 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x000c, 0x000c,
			0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x001e, 0x0026,
			0x0026, 0x0026, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x003b, 0x003b, 0x003b, 0x003b, 0x003f, 0x004c, 0x004c, 0x0054,
			0x0054, 0x0054, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x0071,
			0x0071, 0x0076, 0x0076, 0x0076, 0x0076, 0x007f, 0x007f, 0x007f,
			// Entry 40 - 7F
			0x007f, 0x0089, 0x0089, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d,
			0x0094, 0x0094, 0x00a3, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00ab, 0x00ab, 0x00af, 0x00af, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00bc, 0x00bc, 0x00c4, 0x00c4, 0x00c4,
			0x00cc, 0x00cc, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df,
			0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00e7, 0x00e7, 0x00ef,
			// Entry 80 - BF
			0x00ef, 0x0100, 0x0100, 0x0100, 0x0100, 0x0108, 0x010f, 0x011e,
			0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e,
			0x011e, 0x011e, 0x0126, 0x0126, 0x0126, 0x0126, 0x0126, 0x0126,
			0x012c, 0x012c, 0x0131, 0x0131, 0x0131, 0x0133, 0x0133, 0x0133,
			0x0133, 0x0133, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x013f,
			0x0143, 0x0143, 0x0143, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x0153, 0x0153, 0x015c, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry C0 - FF
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry 100 - 13F
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry 140 - 17F
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry 180 - 1BF
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0167,
		},
	},
	{ // my
		myLangStr,
		myLangIdx,
	},
	{ // naq
		"AkangowabAmharicgowabArabiǁî gowabBelarusanǁî gowabBulgariaǁî gowabBenga" +
			"liǁî gowabCzechǁî gowabDuitsXriksEngelsSpaansPersiaǁî gowabFransHaus" +
			"agowabHindigowabHungariaǁî gowabIndonesiaǁî gowabIgbogowabItaliansJa" +
			"paneesJavaneseKhmerǁî gowab, CentralKoreaǁî gowabMalayǁî gowabBurmes" +
			"ǁî gowabNepalǁî gowabHollandsPunjabigowabPoleǁî gowabPortugeesRoman" +
			"iaǁî gowabRussiaǁî gowabRwandaǁî gowabSomaliǁî gowabSwedeǁî gowabTam" +
			"ilǁî gowabThaiǁî gowabTurkeǁî gowabUkrainiaǁî gowabUrduǁî gowabVietn" +
			"amǁî gowabYorubabChineesǁî gowab, MandarinniZulubKhoekhoegowab",
		[]uint16{ // 433 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0015, 0x0015,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0037, 0x0049,
			0x0049, 0x0049, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x006e, 0x006e, 0x006e, 0x006e, 0x0073, 0x0079, 0x0079, 0x007f,
			0x007f, 0x007f, 0x008f, 0x008f, 0x008f, 0x008f, 0x008f, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x009e,
			0x009e, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00ba, 0x00ba, 0x00ba,
			// Entry 40 - 7F
			0x00ba, 0x00cd, 0x00cd, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00de, 0x00de, 0x00e6, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee,
			0x00ee, 0x00ee, 0x0106, 0x0106, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0124, 0x0124, 0x0134, 0x0134, 0x0134,
			0x0143, 0x0143, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b,
			0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x0157, 0x0157, 0x0165,
			// Entry 80 - BF
			0x0165, 0x016e, 0x016e, 0x016e, 0x016e, 0x017f, 0x018f, 0x019f,
			0x019f, 0x019f, 0x019f, 0x019f, 0x019f, 0x019f, 0x019f, 0x019f,
			0x019f, 0x019f, 0x01af, 0x01af, 0x01af, 0x01af, 0x01af, 0x01af,
			0x01be, 0x01be, 0x01cd, 0x01cd, 0x01cd, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01db, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01fc,
			0x020a, 0x020a, 0x020a, 0x021b, 0x021b, 0x021b, 0x021b, 0x021b,
			0x021b, 0x0222, 0x0222, 0x023f, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry C0 - FF
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry 100 - 13F
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry 140 - 17F
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry 180 - 1BF
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0251,
		},
	},
	{ // nd
		"isi-Akhaniisi-Amaharikhiisi-Alabhuisi-Bhelarashiyaniisi-Bulgariaisi-Bhen" +
			"galiisi-Czechisi-Jalimaniisi-Gilikiisi-Ngisiisi-Sipeyiniisi-Pheshiya" +
			"niisi-Fulentshiisi-Hausaisi-Hindiisi-Hangariisi-Indonesiaisi-Igboisi" +
			"-Italianoisi-Japhaniisi-Javaisi-Khambodiyaisi-Koriyaisi-Malayiisi-Bu" +
			"rmaisiNdebeleisi-Nepaliisi-Dutchisi-Phunjabiisi-Pholoshiisi-Potukezi" +
			"isi-Romaniisi-Rashiyaisi-Ruwandaisi-Somaliisi-Swidishiisi-Thamilisi-" +
			"Thayiisi-Thekishiisi-Ukrainisi-Uduisi-Vietnameseisi-Yorubhaisi-China" +
			"isi-Zulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0034, 0x0040,
			0x0040, 0x0040, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c,
			0x004c, 0x004c, 0x004c, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0061, 0x0061, 0x0061, 0x0061, 0x006b, 0x0074, 0x0074, 0x0080,
			0x0080, 0x0080, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x009b,
			0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x00a4,
			0x00a4, 0x00ad, 0x00ad, 0x00ad, 0x00ad, 0x00b8, 0x00b8, 0x00b8,
			// Entry 40 - 7F
			0x00b8, 0x00c5, 0x00c5, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00d9, 0x00d9, 0x00e4, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
			0x00ec, 0x00ec, 0x00fa, 0x00fa, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x010e, 0x010e, 0x0117, 0x0117, 0x0121,
			0x012b, 0x012b, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0140, 0x0140, 0x014c,
			// Entry 80 - BF
			0x014c, 0x0158, 0x0158, 0x0158, 0x0158, 0x0162, 0x016d, 0x0178,
			0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178,
			0x0178, 0x0178, 0x0182, 0x0182, 0x0182, 0x0182, 0x0182, 0x0182,
			0x018e, 0x018e, 0x0198, 0x0198, 0x0198, 0x01a1, 0x01a1, 0x01a1,
			0x01a1, 0x01a1, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01b7,
			0x01be, 0x01be, 0x01be, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
			0x01cc, 0x01d7, 0x01d7, 0x01e0, 0x01e8,
		},
	},
	{ // ne
		neLangStr,
		neLangIdx,
	},
	{ // nl
		nlLangStr,
		nlLangIdx,
	},
	{ // nmg
		"Kiɛl akanKiɛl amariaKiɛl b’árabeKiɛl belarussieKiɛl bulgariaKiɛl bengali" +
			"aKiɛl bó tchɛkJámanKiɛl bó grɛkNgɛ̄lɛ̄nPaŋáKiɛl pɛrsiaFalaKiɛl máwús" +
			"áKiɛl b’indienKiɛl b’ɔ́ngroisKiɛl indonesieKiɛl ikboKiɛl italiaKiɛl" +
			" bó japonɛ̌Kiɛl bó javanɛ̌Kiɛl bó mɛrKiɛl koréKiɛl Malɛ̌siāKiɛl birm" +
			"aniaKiɛl nepalKiɛl bóllandaisKiɛl pɛndjabiKiɛl pɔlɔŋeKiɛl bó pɔ̄rtug" +
			"ɛ̂Kiɛl bó rumɛ̂nKiɛl russiaKiɛl rwandāKiɛl somaliāKiɛl bó suedoisKi" +
			"ɛl tamulKiɛl thaïKiɛl bó turkKiɛl b’ukrɛ̄nienKiɛl úrduKiɛl viɛtnamY" +
			"orúbâKiɛl bó chinoisZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0016, 0x0016,
			0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0036, 0x0044,
			0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0068, 0x0068, 0x0068, 0x0068, 0x0077, 0x0083, 0x0083, 0x0089,
			0x0089, 0x0089, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x00a9,
			0x00a9, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00cd, 0x00cd, 0x00cd,
			// Entry 40 - 7F
			0x00cd, 0x00dc, 0x00dc, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e6,
			0x00f2, 0x00f2, 0x0105, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
			0x0118, 0x0118, 0x0126, 0x0126, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0131, 0x0142, 0x0142, 0x0150, 0x0150, 0x0150,
			0x015b, 0x015b, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x017b, 0x017b, 0x018a,
			// Entry 80 - BF
			0x018a, 0x01a1, 0x01a1, 0x01a1, 0x01a1, 0x01b3, 0x01bf, 0x01cc,
			0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
			0x01cc, 0x01cc, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01eb, 0x01eb, 0x01f6, 0x01f6, 0x01f6, 0x0201, 0x0201, 0x0201,
			0x0201, 0x0201, 0x020f, 0x020f, 0x020f, 0x020f, 0x020f, 0x0224,
			0x022f, 0x022f, 0x022f, 0x023d, 0x023d, 0x023d, 0x023d, 0x023d,
			0x023d, 0x0245, 0x0245, 0x0256, 0x025a,
		},
	},
	{ // nn
		"afarabkhasiskavestiskafrikaansakanamhariskaragonskarabiskassamiskavarisk" +
			"aymaraaserbajdsjanskbasjkirskkviterussiskbulgarskbislamabambarabenga" +
			"litibetanskbretonskbosniskkatalansktsjetsjenskchamorrokorsikanskcree" +
			"tsjekkiskkyrkjeslavisktsjuvanskwalisiskdansktyskdivehidzongkhaewegre" +
			"skengelskesperantospanskestiskbaskiskpersiskfulanifinskfijianskfærøy" +
			"skfranskvestfrisiskirskskotsk-gæliskgaliciskguaranigujaratimanxhausa" +
			"hebraiskhindihiri motukroatiskhaitiskungarskarmenskhererointerlingua" +
			"indonesiskinterlingueibosichuan-yiinupiakidoislandskitalienskinuktit" +
			"utjapanskjavanesiskgeorgiskkikongokikuyukuanyamakasakhiskkalaallisut" +
			"; grønlandskkhmerkannadakoreanskkanurikasjmirikurdiskkomikorniskkirg" +
			"isisklatinluxemburgskgandalimburgisklingalalaotisklitauiskluba-katan" +
			"galatviskmadagassiskmarshallesiskmaorimakedonskmalayalammongolskmara" +
			"thimalayiskmaltesiskburmesisknaurunord-ndebelenepalskndonganederland" +
			"sknynorskbokmålsør-ndebelenavajonyanjaoksitanskojibwaoromooriyaosset" +
			"iskpanjabipalipolskpashtoportugisiskquechuaretoromanskrundirumenskru" +
			"ssiskkinjarwandasanskritsardinsksindhinordsamisksangosingalesiskslov" +
			"akiskslovensksamoanskshonasomalialbanskserbiskswatisørsothosundanesi" +
			"sksvenskswahilitamiltelugutatsjikiskthaitigrinjaturkmensktswanatonga" +
			" (Tonga-øyane)tyrkisktsongatatarisktahitiskuiguriskukrainskurduusbek" +
			"iskvendavietnamesiskvolapykvallonskwolofxhosajiddiskjorubazhuangkine" +
			"siskzuluachinesiskacoliadangmeadygheafrihiliaghemainuakkadiskaleutis" +
			"ksør-altaigammalengelskangikaarameiskaraukanskarapahoarawakasu (Tanz" +
			"ania)asturiskawadhibaluchibalinesiskbasabejabembabena (Tanzania)bhoj" +
			"puribikolbinisiksikabrajbodoburjatiskbuginesiskblincaddokaribiskatsa" +
			"mcebuanskchibchachagataichuukesiskmarichinookchoctawchipewianskchero" +
			"keecheyennekoptiskkrimtatariskkasjubiskdakotadargwadelawareslavejdog" +
			"ribdinkazarmadogrilågsorbiskdualamellumnederlandskjola-fonyidyulakie" +
			"mbuefikgammalegyptiskekajukelamittiskmellomengelskewondofangfilippin" +
			"skfonmellomfranskgammalfransknordfrisiskaustfrisiskfriulianskgagayog" +
			"bayageskiribatiskmellomhøgtyskgammalhøgtyskgondigorontalogotiskgrebo" +
			"gammalgresksveitsertyskgwichinhaidahawaiiskhiligaynonhettittiskhmong" +
			"høgsorbiskhupaibanilokoingusjisklojbanjødepersiskjødearabiskkarakalp" +
			"akiskkabylskkachinjjukambakawikabardisktyapkapverdiskkorokhasikhotan" +
			"esiskkimbundukonkanikosraeanskkpellekarachay-balkarkarelskkurukhbafi" +
			"akumykkutenailadinsklahndalambalezghianmongoloziluba-lulualuisenolun" +
			"daluolushaimaduresiskmagahimaithilimakasarmandingomasaimokshamandarm" +
			"endemellomirskmicmacminangkabaumandsjumanipurimohawkmossimundangflei" +
			"re språkcreekmirandesiskmarwarierzyanapolitansklågtysknewariniasniue" +
			"anskkwasionogaigammalnorskn’konordsothonuerklassisk newarisknyamwezi" +
			"nyankolenyoronzimaosageottomansk tyrkiskpangasinanpahlavipampangapap" +
			"iamentopalauiskgammalpersiskfønikiskponapiskgammalprovençalskrajasth" +
			"anirapanuirarotonganskromboromaniaromanskrwasandawejakutsksamaritans" +
			"k arameisksasaksantalisangusicilianskskotskselkupiskgammalirskshansi" +
			"damosørsamisklulesamiskenaresamiskskoltesamisksoninkesogdisksranan t" +
			"ongoserersukumasususumeriskshimaoreklassisk syrisksyrisktemneterenot" +
			"etumtigrétivitokelauklingontlingittamasjektonga (Nyasa)tok pisintsim" +
			"shiantumbukatuvalutasawaqtuviniskudmurtugaritiskumbundurotvaivotiskw" +
			"alamowaraywashokalmykyaoyapesiskyangbenkantonesiskzapotecblissymbolz" +
			"enagazuniutan språkleg innhaldzazaausterriksk tysksveitsisk høgtyska" +
			"ustralisk engelskkanadisk engelskbritisk engelskengelsk (amerikansk)" +
			"latinamerikansk spanskiberisk spanskkanadisk fransksveitsisk franskf" +
			"lamskbrasiliansk portugisiskeuropeisk portugisiskmoldaviskserbokroat" +
			"iskforenkla kinesisktradisjonell kinesisk",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0015, 0x001e, 0x0022, 0x002a, 0x0032,
			0x0039, 0x0041, 0x0048, 0x004e, 0x005c, 0x0065, 0x0071, 0x0079,
			0x0080, 0x0087, 0x008e, 0x0097, 0x009f, 0x00a6, 0x00af, 0x00ba,
			0x00c2, 0x00cc, 0x00d0, 0x00d9, 0x00e6, 0x00ef, 0x00f7, 0x00fc,
			0x0100, 0x0106, 0x010e, 0x0111, 0x0116, 0x011d, 0x0126, 0x012c,
			0x0132, 0x0139, 0x0140, 0x0146, 0x014b, 0x0153, 0x015c, 0x0162,
			0x016d, 0x0171, 0x017f, 0x0187, 0x018e, 0x0196, 0x019a, 0x019f,
			0x01a7, 0x01ac, 0x01b5, 0x01bd, 0x01c4, 0x01cb, 0x01d2, 0x01d8,
			// Entry 40 - 7F
			0x01e3, 0x01ed, 0x01f8, 0x01fb, 0x0205, 0x020c, 0x020f, 0x0217,
			0x0220, 0x0229, 0x0230, 0x023a, 0x0242, 0x0249, 0x024f, 0x0257,
			0x0260, 0x0278, 0x027d, 0x0284, 0x028c, 0x0292, 0x029a, 0x02a1,
			0x02a5, 0x02ac, 0x02b5, 0x02ba, 0x02c5, 0x02ca, 0x02d4, 0x02db,
			0x02e2, 0x02ea, 0x02f6, 0x02fd, 0x0308, 0x0315, 0x031a, 0x0323,
			0x032c, 0x0334, 0x033b, 0x0343, 0x034c, 0x0355, 0x035a, 0x0366,
			0x036d, 0x0373, 0x037e, 0x0385, 0x038c, 0x0398, 0x039e, 0x03a4,
			0x03ad, 0x03b3, 0x03b8, 0x03bd, 0x03c5, 0x03cc, 0x03d0, 0x03d5,
			// Entry 80 - BF
			0x03db, 0x03e6, 0x03ed, 0x03f8, 0x03fd, 0x0404, 0x040b, 0x0416,
			0x041e, 0x0426, 0x042c, 0x0436, 0x043b, 0x0446, 0x044f, 0x0457,
			0x045f, 0x0464, 0x046a, 0x0471, 0x0478, 0x047d, 0x0486, 0x0491,
			0x0497, 0x049e, 0x04a3, 0x04a9, 0x04b3, 0x04b7, 0x04bf, 0x04c8,
			0x04ce, 0x04e2, 0x04e9, 0x04ef, 0x04f7, 0x04ff, 0x0507, 0x050f,
			0x0513, 0x051b, 0x0520, 0x052c, 0x0533, 0x053b, 0x0540, 0x0545,
			0x054c, 0x0552, 0x0558, 0x0560, 0x0564, 0x056e, 0x0573, 0x057a,
			0x0580, 0x0580, 0x0588, 0x058d, 0x0591, 0x0599, 0x0599, 0x05a1,
			// Entry C0 - FF
			0x05a1, 0x05ab, 0x05b8, 0x05be, 0x05c6, 0x05cf, 0x05cf, 0x05d6,
			0x05d6, 0x05dc, 0x05dc, 0x05dc, 0x05ea, 0x05ea, 0x05f2, 0x05f2,
			0x05f8, 0x05f8, 0x05ff, 0x0609, 0x0609, 0x060d, 0x060d, 0x060d,
			0x060d, 0x0611, 0x0616, 0x0616, 0x0625, 0x0625, 0x0625, 0x062d,
			0x0632, 0x0636, 0x0636, 0x0636, 0x063d, 0x063d, 0x063d, 0x0641,
			0x0641, 0x0645, 0x0645, 0x064e, 0x0658, 0x0658, 0x065c, 0x065c,
			0x0661, 0x0669, 0x0669, 0x066e, 0x0676, 0x0676, 0x067d, 0x0685,
			0x068f, 0x0693, 0x069a, 0x06a1, 0x06ac, 0x06b4, 0x06bc, 0x06bc,
			// Entry 100 - 13F
			0x06c3, 0x06c3, 0x06cf, 0x06d8, 0x06de, 0x06e4, 0x06e4, 0x06ec,
			0x06f2, 0x06f8, 0x06fd, 0x0702, 0x0707, 0x0712, 0x0712, 0x0717,
			0x0728, 0x0732, 0x0737, 0x0737, 0x073d, 0x0741, 0x0741, 0x074f,
			0x0755, 0x075f, 0x076c, 0x076c, 0x0772, 0x0772, 0x0776, 0x0780,
			0x0780, 0x0783, 0x0783, 0x078f, 0x079b, 0x079b, 0x07a6, 0x07b1,
			0x07bb, 0x07bd, 0x07bd, 0x07bd, 0x07c1, 0x07c6, 0x07c6, 0x07c9,
			0x07d3, 0x07d3, 0x07e1, 0x07ef, 0x07ef, 0x07f4, 0x07fd, 0x0803,
			0x0808, 0x0813, 0x081f, 0x081f, 0x081f, 0x081f, 0x0826, 0x082b,
			// Entry 140 - 17F
			0x082b, 0x0833, 0x0833, 0x083d, 0x0847, 0x084c, 0x0857, 0x0857,
			0x085b, 0x085f, 0x085f, 0x0864, 0x086d, 0x086d, 0x086d, 0x0873,
			0x0873, 0x0873, 0x087f, 0x088b, 0x088b, 0x0898, 0x089f, 0x08a5,
			0x08a8, 0x08ad, 0x08b1, 0x08ba, 0x08ba, 0x08be, 0x08be, 0x08c8,
			0x08c8, 0x08cc, 0x08cc, 0x08d1, 0x08dc, 0x08dc, 0x08dc, 0x08dc,
			0x08dc, 0x08dc, 0x08e4, 0x08e4, 0x08eb, 0x08f5, 0x08fb, 0x090a,
			0x090a, 0x090a, 0x0911, 0x0917, 0x0917, 0x091c, 0x091c, 0x0921,
			0x0928, 0x092f, 0x092f, 0x0935, 0x093a, 0x0942, 0x0942, 0x0942,
			// Entry 180 - 1BF
			0x0942, 0x0942, 0x0942, 0x0947, 0x094b, 0x094b, 0x0955, 0x095c,
			0x0961, 0x0964, 0x096a, 0x096a, 0x096a, 0x096a, 0x0974, 0x0974,
			0x097a, 0x0982, 0x0989, 0x0991, 0x0996, 0x0996, 0x099c, 0x09a2,
			0x09a7, 0x09a7, 0x09a7, 0x09b1, 0x09b1, 0x09b1, 0x09b7, 0x09c2,
			0x09c9, 0x09d1, 0x09d7, 0x09dc, 0x09dc, 0x09e3, 0x09f0, 0x09f5,
			0x0a00, 0x0a07, 0x0a07, 0x0a07, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a17,
			0x0a17, 0x0a1f, 0x0a25, 0x0a29, 0x0a31, 0x0a31, 0x0a37, 0x0a37,
			0x0a3c, 0x0a47, 0x0a47, 0x0a4d, 0x0a56, 0x0a5a, 0x0a6b, 0x0a73,
			// Entry 1C0 - 1FF
			0x0a7b, 0x0a80, 0x0a85, 0x0a8a, 0x0a9b, 0x0aa5, 0x0aac, 0x0ab4,
			0x0abe, 0x0ac6, 0x0ac6, 0x0ac6, 0x0ac6, 0x0ad3, 0x0ad3, 0x0adc,
			0x0adc, 0x0adc, 0x0ae4, 0x0ae4, 0x0af6, 0x0af6, 0x0af6, 0x0b00,
			0x0b07, 0x0b13, 0x0b13, 0x0b13, 0x0b18, 0x0b1e, 0x0b1e, 0x0b1e,
			0x0b1e, 0x0b26, 0x0b29, 0x0b30, 0x0b37, 0x0b4b, 0x0b4b, 0x0b50,
			0x0b57, 0x0b57, 0x0b57, 0x0b5c, 0x0b66, 0x0b6c, 0x0b6c, 0x0b6c,
			0x0b6c, 0x0b6c, 0x0b75, 0x0b75, 0x0b7f, 0x0b7f, 0x0b7f, 0x0b83,
			0x0b83, 0x0b89, 0x0b89, 0x0b89, 0x0b93, 0x0b9d, 0x0ba8, 0x0bb4,
			// Entry 200 - 23F
			0x0bbb, 0x0bc2, 0x0bce, 0x0bd3, 0x0bd3, 0x0bd3, 0x0bd9, 0x0bdd,
			0x0be5, 0x0bed, 0x0bed, 0x0bfc, 0x0c02, 0x0c02, 0x0c02, 0x0c07,
			0x0c07, 0x0c0d, 0x0c12, 0x0c18, 0x0c1c, 0x0c23, 0x0c23, 0x0c2a,
			0x0c31, 0x0c31, 0x0c39, 0x0c46, 0x0c4f, 0x0c4f, 0x0c4f, 0x0c4f,
			0x0c58, 0x0c58, 0x0c5f, 0x0c65, 0x0c6c, 0x0c74, 0x0c74, 0x0c7a,
			0x0c83, 0x0c8a, 0x0c8d, 0x0c90, 0x0c90, 0x0c90, 0x0c90, 0x0c90,
			0x0c96, 0x0c96, 0x0c96, 0x0c96, 0x0c9c, 0x0ca1, 0x0ca6, 0x0ca6,
			0x0ca6, 0x0cac, 0x0cac, 0x0cac, 0x0caf, 0x0cb7, 0x0cbe, 0x0cbe,
			// Entry 240 - 27F
			0x0cbe, 0x0cc9, 0x0cd0, 0x0cda, 0x0cda, 0x0ce0, 0x0ce0, 0x0ce4,
			0x0cfa, 0x0cfe, 0x0cfe, 0x0d0e, 0x0d20, 0x0d32, 0x0d42, 0x0d51,
			0x0d65, 0x0d7b, 0x0d89, 0x0d89, 0x0d98, 0x0da8, 0x0dae, 0x0dc5,
			0x0dda, 0x0de3, 0x0df0, 0x0e01, 0x0e16,
		},
	},
	{ // nnh
		"nzǎmɔ̂ɔnngilísèShwóŋò menkesaŋfelaŋséeShwóŋò pʉa mbasǎShwóŋò pamomShwóŋò" +
			" pʉa nzsekàʼaShwóŋò pafutShwóŋò pʉ̀a njinikomShwóŋò pakɔsiShwóŋò mbu" +
			"luShwóŋò ngáŋtʉɔʼShwóŋò pʉa YɔɔnmendiShwóŋò pʉa shÿó BɛgtùaShwóŋò ng" +
			"iembɔɔnShwóŋò pʉa shÿó MbafìaShwóŋò Tsaŋ",
		[]uint16{ // 576 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x0015, 0x0015, 0x0015,
			0x0015, 0x0015, 0x0015, 0x0028, 0x0028, 0x0028, 0x0028, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			// Entry 40 - 7F
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			// Entry 80 - BF
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			// Entry C0 - FF
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0047, 0x0056, 0x0056,
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x007e, 0x007e, 0x007e,
			0x007e, 0x007e, 0x007e, 0x0097, 0x0097, 0x0097, 0x0097, 0x0097,
			0x0097, 0x0097, 0x00a8, 0x00a8, 0x00a8, 0x00b7, 0x00b7, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			// Entry 100 - 13F
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			// Entry 140 - 17F
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			// Entry 180 - 1BF
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			// Entry 1C0 - 1FF
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			// Entry 200 - 23F
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x0138, 0x0147,
		},
	},
	{ // no
		noLangStr,
		noLangIdx,
	},
	{ // nus
		"Thok aka̱niThok bunyniThok JalabniThok bäläruthaThok bälga̱a̱rianiThok b" +
			"ängaliThok cikThok jarmaniThok girikniThok liŋli̱thniThok i̱thpaani" +
			"aniThok perthianiThok pɔrɔthaniThok ɣowthaniThok ɣändiniThok ɣänga̱a" +
			"̱riɛniThok indunithianiThok i̱gboniThok i̱talianiThok japanniThok j" +
			"abanithniThok kameeriThok kurianiThok mayɛyniThok bormi̱thniThok nap" +
			"alniThok da̱cThok puɔnjabaniThok pölicniThok puɔtigaliThok ji̱ römTh" +
			"ok ra̱ciaaniThok ruaandaniThok thomaalianiThok i̱thwidicniThok tamil" +
			"niThok tayniThok turkicniThok ukeraaniniThok udoniThok betnaamniThok" +
			" yurubaniThok caynaThok dhuluniThok Nath",
		[]uint16{ // 446 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0017, 0x0017,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0033, 0x0048,
			0x0048, 0x0048, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0075, 0x0086, 0x0086, 0x0098,
			0x0098, 0x0098, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00b6,
			0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00c4,
			0x00c4, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00e9, 0x00e9, 0x00e9,
			// Entry 40 - 7F
			0x00e9, 0x00fa, 0x00fa, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0116, 0x0116, 0x0122, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x013d, 0x013d, 0x0149, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0149, 0x0156, 0x0156, 0x0166, 0x0166, 0x0166,
			0x0172, 0x0172, 0x017c, 0x017c, 0x017c, 0x017c, 0x017c, 0x017c,
			0x017c, 0x017c, 0x017c, 0x017c, 0x017c, 0x018c, 0x018c, 0x0199,
			// Entry 80 - BF
			0x0199, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01b6, 0x01c5, 0x01d3,
			0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3,
			0x01d3, 0x01d3, 0x01e3, 0x01e3, 0x01e3, 0x01e3, 0x01e3, 0x01e3,
			0x01f4, 0x01f4, 0x0200, 0x0200, 0x0200, 0x020a, 0x020a, 0x020a,
			0x020a, 0x020a, 0x0217, 0x0217, 0x0217, 0x0217, 0x0217, 0x0226,
			0x0230, 0x0230, 0x0230, 0x023e, 0x023e, 0x023e, 0x023e, 0x023e,
			0x023e, 0x024b, 0x024b, 0x0255, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry C0 - FF
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry 100 - 13F
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry 140 - 17F
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry 180 - 1BF
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x026a,
		},
	},
	{ // nyn
		"OrukaniOrumarikiOruharabuOruberarusiOruburugariyaOrubengariOruceekiOrugi" +
			"rimaaniOruguriikiOrungyerezaOrusupaaniOrupaasiyaOrufaransaOruhausaOr" +
			"uhindiOruhangareOruindoneziaOruiboOruyitareOrujapaaniOrujavaOrukambo" +
			"diyaOrukoreyaOrumalesiyaOruburumaOrunepaliOrudaakiOrupungyabiOrupoor" +
			"iOrupocugoOruromaniaOrurrashaOrunyarwandaOrusomaariOruswidiOrutamiri" +
			"OrutailandiOrukurukiOrukurainiOru-UruduOruviyetinaamuOruyorubaOrucha" +
			"inaOruzuruRunyankore",
		[]uint16{ // 449 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0031,
			0x0031, 0x0031, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
			0x003b, 0x003b, 0x003b, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x004f, 0x004f, 0x004f, 0x004f, 0x0059, 0x0064, 0x0064, 0x006e,
			0x006e, 0x006e, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x008a,
			0x008a, 0x0092, 0x0092, 0x0092, 0x0092, 0x009c, 0x009c, 0x009c,
			// Entry 40 - 7F
			0x009c, 0x00a8, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00b7, 0x00b7, 0x00c1, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00d4, 0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00e8, 0x00f1, 0x00f1, 0x00f1,
			0x00fa, 0x00fa, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102,
			0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x010d, 0x010d, 0x0115,
			// Entry 80 - BF
			0x0115, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128, 0x0131, 0x013d,
			0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d,
			0x013d, 0x013d, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0163, 0x0163, 0x0163,
			0x0163, 0x0163, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x0176,
			0x017f, 0x017f, 0x017f, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d,
			0x018d, 0x0196, 0x0196, 0x019f, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry C0 - FF
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 100 - 13F
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 140 - 17F
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 180 - 1BF
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 1C0 - 1FF
			0x01b0,
		},
	},
	{ // om
		"AfrikootaAfaan SidaamaaArabiffaaAfaan AzerbaijaniAfaan BelarusiaAfaan Bu" +
			"lgariyaAfaan BaangladeshiAfaan BosniyaaAfaan KatalaaAfaan CzechWelis" +
			"hiffaaAfaan DeenmaarkAfaan JarmaniiAfaan GiriikiIngliffaAfaan Espera" +
			"ntooAfaan IspeenAfaan IstooniyaAfaan BaskuuAfaan PersiaAfaan Fiilaan" +
			"diAfaan FaroeseAfaan FaransaayiiAfaan FirisiyaaniAfaan AyirishiiScot" +
			"s GaelicAfaan GalishiiAfaan GuaraniAfaan GujaratiAfaan HebrewAfaan H" +
			"indiiAfaan CroatianAfaan HangaariInterlinguaAfaan IndoneziyaAyiislan" +
			"diffaaAfaan XaaliyaaniAfaan JapaniiAfaan JavaAfaan GeorgianAfaan Kan" +
			"nadaAfaan KoreaAfaan LaatiniAfaan LiituniyaaAfaan LativiyaaAfaan Mac" +
			"edooniyaaMalayaalamiffaaAfaan MaratiiMalaayiffaaAfaan MaltesiiAfaan " +
			"NepaliiAfaan DachiiAfaan NorwegianAfaan NorweyiiAfaan OccitOromooAfa" +
			"an PunjabiiAfaan PolandiiAfaan PorchugaalAfaan RomaniyaaAfaan Rushiy" +
			"aaAfaan SinhaleseAfaan SlovakAfaan IslovaniyaaAfaan AlbaniyaaAfaan S" +
			"erbiyaAfaan SudaaniiAfaan SuwidiinSuwahiliiAfaan TamiliiAfaan Telugu" +
			"Afaan TayiiAfaan TigireeLammii TurkiiAfaan TurkiiAfaan UkreeniiAfaan" +
			" UrduAfaan UzbekAfaan VeetinamAfaan XhosaChineseAfaan ZuuluAfaan Fil" +
			"ippiniiAfaan KilingonAfaan Portugali (Braazil)Afaan Protuguese",
		[]uint16{ // 601 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0009, 0x0017, 0x0017,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0031, 0x0031, 0x0040, 0x004f,
			0x004f, 0x004f, 0x0061, 0x0061, 0x0061, 0x006f, 0x007c, 0x007c,
			0x007c, 0x007c, 0x007c, 0x0087, 0x0087, 0x0087, 0x0092, 0x00a1,
			0x00af, 0x00af, 0x00af, 0x00af, 0x00bc, 0x00c4, 0x00d4, 0x00e0,
			0x00ef, 0x00fb, 0x0107, 0x0107, 0x0116, 0x0116, 0x0123, 0x0134,
			0x0145, 0x0154, 0x0160, 0x016e, 0x017b, 0x0189, 0x0189, 0x0189,
			0x0195, 0x01a1, 0x01a1, 0x01af, 0x01af, 0x01bd, 0x01bd, 0x01bd,
			// Entry 40 - 7F
			0x01c8, 0x01d8, 0x01d8, 0x01d8, 0x01d8, 0x01d8, 0x01d8, 0x01e6,
			0x01f6, 0x01f6, 0x0203, 0x020d, 0x021b, 0x021b, 0x021b, 0x021b,
			0x021b, 0x021b, 0x021b, 0x0228, 0x0233, 0x0233, 0x0233, 0x0233,
			0x0233, 0x0233, 0x0233, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0250, 0x0250, 0x025f, 0x025f, 0x025f, 0x025f, 0x0271,
			0x0280, 0x0280, 0x028d, 0x0298, 0x02a6, 0x02a6, 0x02a6, 0x02a6,
			0x02b3, 0x02b3, 0x02bf, 0x02ce, 0x02dc, 0x02dc, 0x02dc, 0x02dc,
			0x02e7, 0x02e7, 0x02ed, 0x02ed, 0x02ed, 0x02fb, 0x02fb, 0x0309,
			// Entry 80 - BF
			0x0309, 0x0319, 0x0319, 0x0319, 0x0319, 0x0328, 0x0336, 0x0336,
			0x0336, 0x0336, 0x0336, 0x0336, 0x0336, 0x0345, 0x0351, 0x0362,
			0x0362, 0x0362, 0x0362, 0x0371, 0x037e, 0x037e, 0x037e, 0x038c,
			0x039a, 0x03a3, 0x03b0, 0x03bc, 0x03bc, 0x03c7, 0x03d4, 0x03e1,
			0x03e1, 0x03e1, 0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03fb,
			0x0405, 0x0410, 0x0410, 0x041e, 0x041e, 0x041e, 0x041e, 0x0429,
			0x0429, 0x0429, 0x0429, 0x0430, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			// Entry C0 - FF
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			// Entry 100 - 13F
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 140 - 17F
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 180 - 1BF
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 1C0 - 1FF
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 200 - 23F
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			// Entry 240 - 27F
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0472,
			0x0482,
		},
	},
	{ // or
		"ଅଫାର୍ଆବ୍ଖାଜିଆନ୍ଅବେସ୍ତନଆଫ୍ରିକାନସ୍ଅକନ୍ଆମହାରକିଆର୍ଗୋନୀଆରବିକ୍ଆସାମୀଆଭାରିକ୍ଆୟମା" +
			"ରାଆଜେରବାଇଜାନିବଶଖିର୍ବେଲାରୁଷିଆନ୍ବୁଲଗେରିଆନ୍ବିସଲାମାବାମ୍ବାରାବଙ୍ଗାଳୀତିବେ" +
			"ତାନ୍ବ୍ରେଟନ୍କାଟଲାନ୍କାଟାଲାନ୍ଚେଚନ୍ଚାମୋରୋକୋର୍ସିକାନ୍କ୍ରୀଚେକ୍ଚର୍ଚ୍ଚ ସ୍ଲା" +
			"ଭିକ୍ଚୁଭାଶ୍ୱେଲ୍ସଡାନ୍ନିସ୍ଜର୍ମାନ୍ଡିଭେହୀଭୂଟାନୀଇୱେଗ୍ରୀକ୍ଇଂରାଜୀଏସ୍ପାରେଣ୍" +
			"ଟୋସ୍ପାନିସ୍ଏସ୍ତୋନିଆନ୍ବାସ୍କ୍ୱିପର୍ସିଆନ୍ଫୁଲାହଫିନ୍ନିସ୍ଫିଜିଫାରୋଏସେଫ୍ରେଞ୍" +
			"ଚପଶ୍ଚିମ ଫ୍ରିସିୟନ୍ଇରିସ୍ସ୍କଟିସ୍ ଗାଏଲିକ୍ଗାଲସିଆନ୍ଗୁଆରାନୀଗୁଜୁରାଟୀମାଁକ୍ସ" +
			"ହୌସାହେବ୍ର୍ୟୁହିନ୍ଦୀହିରି ମୋଟୁକ୍ରୋଆଟିଆନ୍ହୈତାୟିନ୍ହଙ୍ଗେରିଆନ୍ଆର୍ମେନିଆନ୍ହ" +
			"େରେରୋଇର୍ଣ୍ଟଲିଙ୍ଗୁଆଇଣ୍ଡୋନେସିଆନ୍ଇର୍ଣ୍ଟରଲିଙ୍ଗୁଇଇଗ୍ବୋସିଚୁଆନ୍ ୟୀଇନୁପିୟା" +
			"କ୍ଇଡୋଆଇସଲାଣ୍ଡିକ୍ଇଟାଲିଆନ୍ଇନକୀଟୁତ୍ଜାପାନୀଜ୍ଜାଭାନୀଜ୍ଜର୍ଜିଆନ୍କଙ୍ଗୋକୀକୁୟ" +
			"ୁକ୍ୱାନ୍ୟାମ୍କାଜାକ୍ଗ୍ରୀନଲାଣ୍ଡିକ୍ଖ୍ମେର୍କନ୍ନଡକୋରିଆନ୍କନୁରୀକାଶ୍ମିରୀକୁର୍ଦ" +
			"୍ଦିଶ୍କୋମିକୋର୍ନିସ୍କିରଗିଜ୍ଲାଟିନ୍ଲକ୍ସେମବର୍ଗିସ୍ଗନ୍ଦାଲିମ୍ବୁର୍ଗିସ୍ଲିଙ୍ଗା" +
			"ଲାଲାଓଲିଥୁଆନିଆନ୍ଲ୍ୟୁବା-କାଟାଙ୍ଗାଲାଟଭିଆନ୍ମାଲାଗାସୀମାର୍ଶାଲୀଜ୍ମାଓରୀମାକଡୋ" +
			"ନିଆନ୍ମାଲାୟଲମ୍ମଙ୍ଗୋଲିଆନ୍ମରାଠୀମାଲୟମାଲଟୀଜ୍ବର୍ମୀଜ୍ନାଉରୁଉତ୍ତର ନେଡବେଲେନେ" +
			"ପାଳୀଡୋଙ୍ଗାଡଚ୍ନରୱେଜିଆନ୍ ନିୟୋର୍ସ୍କନରୱେଜିଆନ୍ ବୋକମଲ୍ଦକ୍ଷିଣ ନେଡବେଲେନାଭା" +
			"ଜୋନିୟାଞ୍ଜଓସିଟାନ୍ଓଜିୱାଓରୋମୋଓଡ଼ିଆଓସେଟିକ୍ପଞ୍ଜାବୀପାଲିପୋଲିଶ୍ପାସ୍ତୋପର୍ତ୍" +
			"ତୁଗ୍ରୀଜ୍କ୍ୱେଚୁଆରେହେଟୋ-ରୋମାନ୍ସରୁଣ୍ଡିରୋମାନିଆନ୍ରଷିଆନ୍କିନ୍ୟାରୱାଣ୍ଡାସଂସ" +
			"୍କୃତସର୍ଦିନିଆନ୍ସିନ୍ଧୀଉତ୍ତର ସାମିସାଙ୍ଗୋସିଂହଳସ୍ଲୋଭାକ୍ସ୍ଲୋଭେନିଆନ୍ସାମୋଆନ" +
			"୍ଶୋନାସୋମାଲିଆଆଲବାନିଆନ୍ସର୍ବିଆନ୍ସ୍ବାତୀସେସୋଥୋସୁଦାନୀଜ୍ସ୍ୱେଡିସ୍ସ୍ୱାହିଲ୍ତ" +
			"ାମିଲ୍ତେଲୁଗୁତାଜିକ୍ଥାଇଟ୍ରିଗିନିଆତୁର୍କମେନ୍ସେସ୍ବାନାଟୋଙ୍ଗାତୁର୍କିସ୍ସୋଂଗାତ" +
			"ାତାର୍ତାହିତିଆନ୍ୟୁଘୁର୍ୟୁକ୍ରାନିଆନ୍ଉର୍ଦ୍ଦୁଉଜବେକ୍ଭେଣ୍ଡାଭିଏତନାମିଜ୍ବୋଲାପୁ" +
			"କୱାଲୁନ୍ୱୋଲଫ୍ଖୋସାୟିଡିସ୍ୟୋରୁବାଜୁଆଙ୍ଗଚାଇନୀଜ୍ଜୁଲୁଆଚାଇନୀଜ୍ଆକୋଲିଆଦାଙ୍ଗେମ" +
			"୍ଅଦ୍ୟଘେଆଫ୍ରିହିଲିଆଇନୁଆକାଡିଆନ୍ଆଲେଇଟୁଦକ୍ଷିଣ ଆଲ୍ଟାଇପୁରୁଣା ଇଁରାଜୀଅଁଗୀକା" +
			"ଆରାମାଇକ୍ଆରାଉକାନିଆନ୍ଆରାପାହୋଆରୱକଆଷ୍ଟୁରିଆନ୍ଆୱାଧିବାଲୁଚିବାଲିନୀଜ୍ବାସାବେଜ" +
			"ାବେମ୍ବାଭୋଜପୁରୀବିକୋଲ୍ବିନିବିକ୍ସିକାବ୍ରାଜ୍ବୁରିଆଟ୍ବୁଗୀନୀଜ୍ବ୍ଲିନ୍କାଡୋକାର" +
			"ିବ୍ଆତ୍ସମ୍ସୀବୁଆନୋଚିବ୍ଚାଛଗତାଇଚୁକୀସେମାରୀଚିନୁକ୍ ଜାରଗାଁନ୍ଚୋଟୱାଚିପେୱାନ୍ଚ" +
			"େରୋକୀଚେଚେନାକପ୍ଟିକ୍କ୍ରୀମିନ୍ ତୁର୍କୀସ୍କାଶୁବିଆନ୍ଡାକୋଟାଡାରାଗ୍ୱାଡେଲାୱେର୍" +
			"ସ୍ଲେଭ୍ଡୋଗ୍ରିବ୍ଦିଙ୍କାଡୋଗ୍ରୀନିଚଳା ସର୍ବିଆନ୍ଡୁଆନାମଧ୍ୟ ପର୍ତ୍ତୁଗାଲୀଡୁଆଲା" +
			"ଏଫିକ୍ପ୍ରାଚୀନ୍ ମିଶିରିଏକାଜୁକ୍ଏଲାମାଇଟ୍ମଧ୍ୟ ଇଁରାଜୀଇୱୋଣ୍ଡୋଫାଙ୍ଗଫିଲିପିନୋ" +
			"ଫନ୍ମଧ୍ୟ ଫ୍ରେଞ୍ଚପୁରୁଣା ଫ୍ରେଞ୍ଚଉତ୍ତର ଫ୍ରିସିୟାନ୍ପୂର୍ବ ଫ୍ରିସିୟାନ୍ଫ୍ରିୟ" +
			"ୁଲୀୟାନ୍ଗାଗାୟୋଗବାୟାଗୀଜ୍ଜିବ୍ରାଟୀଜ୍ମିଡିଲ୍ ହାଇ ଜର୍ମାନ୍ପୁରୁଣା ହାଇ ଜର୍ମା" +
			"ନ୍ଗୋଣ୍ଡିଗୋରୋଣ୍ଟାଲୋଗୋଥିକ୍ଗ୍ରେବୋପ୍ରାଚୀନ୍ ୟୁନାନୀସ୍ବିସ୍ ଜର୍ମାନ୍ସ୍ବିଚ୍ " +
			"ଇନ୍ହାଇଡାହାୱାଇନ୍ହିଲିଗୈନନ୍ହିତୀତେହଁଙ୍ଗଉପର ସର୍ବିଆନ୍ହୁପାଇବାନ୍ଇଲୋକୋଇଁଙ୍ଗ" +
			"ୁଶ୍ଲୋଜବାନ୍ଜୁଡେଓ-ପର୍ସିଆନ୍ଜୁଡେଓ-ଆରବୀକ୍କାରା-କଲ୍ପକ୍କବାଇଲ୍କଚିନ୍ଜ୍ଜୁକମ୍ବ" +
			"ାକାୱିକାବାର୍ଡିଆନ୍ତ୍ୟାପ୍କୋରୋଖାସୀଖୋତାନୀଜ୍କିମ୍ବୁଣ୍ଡୁକୋନକାନୀକୋସରୈନ୍କୈପେ" +
			"ଲେକରାଚୟ-ବଲ୍କାରକାରେଲିୟାନ୍କୁରୁଖକୁମୀକ୍କୁତେନାଉଲାଦିନୋଲାହାଣ୍ଡାଲାମ୍ବାଲେଜଗ" +
			"ିୟାନ୍ମଙ୍ଗୋଲୋଜିଲୁବା-ଲୁଲୁଆଲୁଇସେନୋଲୁଣ୍ଡାଲୁଓଲୁସାଉମାଦୁରୀସ୍ମାଗାହୀମୈଥିଳୀମ" +
			"କାସର୍ମାଣ୍ଡିଙ୍ଗୋମାସାଇମୋକ୍ଷମନ୍ଦାରମେଣ୍ଡେମଧ୍ୟ ଇରିଶ୍ମିକମୌକ୍ମିନାଙ୍ଗାବାଉମ" +
			"ାଞ୍ଚୁମଣିପୁରୀମୋହୌକମୋସିବିବିଧ ଭାଷାମାନକ୍ରୀକ୍ମିରାଣ୍ଡିଜ୍ମାରୱାରୀଏର୍ଜୟାନୀପ" +
			"ୋଲିଟାନ୍ଲୋ ଜର୍ମାନ୍ନେୱାରୀନୀୟାସ୍ନିୟୁଆନ୍ନୋଗାଇପୁରୁଣା ନର୍ସଏନ୍କୋଉତ୍ତରୀ ସୋ" +
			"ଥୋପାରମ୍ପରିକ ନେୱାରୀନ୍ୟାମୱେଜୀନ୍ୟାନକୋଲ୍ନ୍ୟାରୋଞ୍ଜିମାୱୌସେଜ୍ଓଟ୍ଟୋମନ୍ ତୁର" +
			"୍କିସ୍ପାଙ୍ଗାସିନିଆନ୍ପାହ୍ଲାଭିପାମ୍ପାଙ୍ଗାପାପିୟାମିଣ୍ଟୋପାଲାଉଆନ୍ପୁରୁଣା ପର୍" +
			"ସିଆନ୍ଫୋନେସିଆନ୍ପୋହପିଏନ୍ପୁରୁଣା ପ୍ରେଭେନେସିଆଲ୍ରାଜସ୍ଥାନୀରାପାନୁଇରାରୋତୋଙ୍" +
			"ଗନ୍ରୋମାନିଆରୋମାନିଆନ୍ସଣ୍ଡାୱେୟାକୁଟ୍ସାମୌରିଟନ୍ ଆରମାଇକ୍ସାସାକ୍ସାନ୍ତାଳିସିଶ" +
			"ିଲିଆନ୍ସ୍କଟସ୍ସେଲ୍କପ୍ପୁରୁଣା ଇରିଶ୍ଶାନ୍ସିଦାମୋଦକ୍ଷିଣ ସାମିଲୁଲେ ସାମିଇନାରୀ" +
			" ସାମିସ୍କୋଲ୍ଟ ସାମୀସୋନିଙ୍କେସୋଗଡିଏନ୍ଶାରାନା ଟୋଙ୍ଗୋଶେରେର୍ସୁକୁମାଶୁଶୁସୁମେରି" +
			"ଆନ୍କ୍ଲାସିକାଲ୍ ସିରିକ୍ସିରିକ୍ତିମନେତେରେନୋତେତୁମ୍ଟାଇଗ୍ରେତୀଭ୍ଟୋକେଲାଉକ୍ଲିଙ" +
			"୍ଗନ୍ତ୍ଲିଙ୍ଗିଟ୍ତାମାଶେକ୍ନ୍ୟାସା ଟୋଙ୍ଗୋଟୋକ୍ ପିସିନ୍ତିସିମିସିଆନ୍ଟୁମ୍ବୁକାତ" +
			"ୁଭାଲୁତୁଭିନିଆନ୍ଉଦମୂର୍ତ୍ତୟୁଗୋରଟିକ୍ଉମ୍ବୁଣ୍ଡୁମୂଳଭାଇଭୋଟିକ୍ୱାଲମୋୱାରୈୱାସୋ" +
			"କାଲ୍ମୀକ୍ୟାଓୟାପୀସ୍ଜାପୋଟେକ୍ବ୍ଲିସିମ୍ବଲସ୍ଜେନାଗାଜୁନୀକୌଣସି ଲିଙ୍ଗୁଇଷ୍ଟ ସା" +
			"ମଗ୍ରୀ ନାହିଁଜାଜାଅଷ୍ଟ୍ରିଆନ୍ ଜର୍ମାନସ୍ବିସ୍ ହାଇ ଜର୍ମାନ୍ଅଷ୍ଟ୍ରେଲିଆନ୍ ଇଁର" +
			"ାଜୀକାନାଡିଆନ୍ ଇଁରାଜୀବ୍ରିଟିଶ୍ ଇଁରାଜୀୟୁ.ଏସ୍. ଇଁରାଜୀଲାଟିନ୍ ଆମେରିକାନ୍ ସ" +
			"୍ପାନିଶ୍ଲେବେରିଆନ୍ ସ୍ପାନିଶ୍କାନାଡିଆନ୍ ଫ୍ରେଞ୍ଚସ୍ବିସ୍ ଫ୍ରେଞ୍ଚ୍ଫ୍ଲେମିଶ୍ବ" +
			"୍ରାଜିଲିଆନ୍ ପର୍ତ୍ତୁଗୀଜ୍ଲେବେରିଆନ୍ ପର୍ତ୍ତୁଗୀଜ୍ମୋଲଡୋଭିଆନ୍ସର୍ବୋ-କ୍ରୋଆଟି" +
			"ଆନ୍ସରଳିକରଣ ଚାଇନୀଜ୍ପାରମ୍ପରିକ ଚାଇନୀଜ୍",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x000f, 0x002d, 0x0042, 0x0060, 0x006c, 0x0081, 0x0096,
			0x00a8, 0x00b7, 0x00cc, 0x00de, 0x00ff, 0x0111, 0x0132, 0x0150,
			0x0165, 0x017d, 0x0192, 0x01aa, 0x01bf, 0x01d4, 0x01ec, 0x01fb,
			0x020d, 0x022b, 0x0237, 0x0243, 0x026e, 0x0280, 0x028f, 0x02a7,
			0x02bc, 0x02ce, 0x02e0, 0x02e9, 0x02fb, 0x030d, 0x032e, 0x0346,
			0x0364, 0x037c, 0x0394, 0x03a3, 0x03bb, 0x03c7, 0x03dc, 0x03f1,
			0x041f, 0x042e, 0x0459, 0x0471, 0x0486, 0x049e, 0x04b0, 0x04bc,
			0x04d4, 0x04e6, 0x04ff, 0x051d, 0x0535, 0x0553, 0x0571, 0x0583,
			// Entry 40 - 7F
			0x05aa, 0x05ce, 0x05f8, 0x0607, 0x0623, 0x063e, 0x0647, 0x0668,
			0x0680, 0x0698, 0x06b0, 0x06c8, 0x06e0, 0x06ef, 0x0701, 0x071f,
			0x0731, 0x0758, 0x076a, 0x0779, 0x078e, 0x079d, 0x07b5, 0x07d3,
			0x07df, 0x07f7, 0x080c, 0x081e, 0x0845, 0x0854, 0x0878, 0x0890,
			0x0899, 0x08b7, 0x08e2, 0x08fa, 0x0912, 0x0930, 0x093f, 0x095d,
			0x0975, 0x0993, 0x09a2, 0x09ae, 0x09c3, 0x09d8, 0x09e7, 0x0a0c,
			0x0a1e, 0x0a30, 0x0a39, 0x0a70, 0x0a9e, 0x0ac6, 0x0ad8, 0x0aed,
			0x0b02, 0x0b11, 0x0b20, 0x0b2f, 0x0b44, 0x0b59, 0x0b65, 0x0b77,
			// Entry 80 - BF
			0x0b89, 0x0bb0, 0x0bc5, 0x0bed, 0x0bff, 0x0c1a, 0x0c2c, 0x0c53,
			0x0c68, 0x0c86, 0x0c98, 0x0cb4, 0x0cc6, 0x0cd5, 0x0ced, 0x0d0e,
			0x0d23, 0x0d2f, 0x0d44, 0x0d5f, 0x0d77, 0x0d89, 0x0d9b, 0x0db3,
			0x0dcb, 0x0de3, 0x0df5, 0x0e07, 0x0e19, 0x0e22, 0x0e3d, 0x0e58,
			0x0e70, 0x0e82, 0x0e9a, 0x0ea9, 0x0ebb, 0x0ed6, 0x0ee8, 0x0f09,
			0x0f1e, 0x0f30, 0x0f42, 0x0f60, 0x0f75, 0x0f87, 0x0f96, 0x0fa2,
			0x0fb4, 0x0fc6, 0x0fd8, 0x0fed, 0x0ff9, 0x1011, 0x1020, 0x103b,
			0x104d, 0x104d, 0x1068, 0x1068, 0x1074, 0x108c, 0x108c, 0x109e,
			// Entry C0 - FF
			0x109e, 0x10c3, 0x10e8, 0x10fa, 0x1112, 0x1133, 0x1133, 0x1148,
			0x1148, 0x1154, 0x1154, 0x1154, 0x1154, 0x1154, 0x1172, 0x1172,
			0x1181, 0x1181, 0x1193, 0x11ab, 0x11ab, 0x11b7, 0x11b7, 0x11b7,
			0x11b7, 0x11c3, 0x11d5, 0x11d5, 0x11d5, 0x11d5, 0x11d5, 0x11ea,
			0x11fc, 0x1208, 0x1208, 0x1208, 0x1220, 0x1220, 0x1220, 0x1232,
			0x1232, 0x1232, 0x1232, 0x1247, 0x125f, 0x125f, 0x1271, 0x1271,
			0x127d, 0x128f, 0x128f, 0x12a1, 0x12b6, 0x12b6, 0x12c8, 0x12d7,
			0x12e9, 0x12f5, 0x1320, 0x132f, 0x1347, 0x1359, 0x136b, 0x136b,
			// Entry 100 - 13F
			0x1380, 0x1380, 0x13b1, 0x13cc, 0x13de, 0x13f6, 0x13f6, 0x140e,
			0x1420, 0x1438, 0x144a, 0x144a, 0x145c, 0x1484, 0x1484, 0x1493,
			0x14c1, 0x14c1, 0x14d0, 0x14d0, 0x14d0, 0x14df, 0x14df, 0x150a,
			0x151f, 0x1537, 0x1556, 0x1556, 0x156b, 0x156b, 0x157a, 0x1592,
			0x1592, 0x159b, 0x159b, 0x15bd, 0x15e5, 0x15e5, 0x1613, 0x1641,
			0x1665, 0x166b, 0x166b, 0x166b, 0x1677, 0x1686, 0x1686, 0x1692,
			0x16b0, 0x16b0, 0x16e2, 0x1714, 0x1714, 0x1726, 0x1744, 0x1756,
			0x1768, 0x1793, 0x17bb, 0x17bb, 0x17bb, 0x17bb, 0x17d7, 0x17e6,
			// Entry 140 - 17F
			0x17e6, 0x17fb, 0x17fb, 0x1816, 0x1828, 0x1837, 0x1859, 0x1859,
			0x1865, 0x1874, 0x1874, 0x1883, 0x189b, 0x189b, 0x189b, 0x18b0,
			0x18b0, 0x18b0, 0x18d8, 0x18fa, 0x18fa, 0x1919, 0x192b, 0x193a,
			0x1946, 0x1955, 0x1961, 0x1982, 0x1982, 0x1994, 0x1994, 0x1994,
			0x1994, 0x19a0, 0x19a0, 0x19ac, 0x19c4, 0x19c4, 0x19c4, 0x19c4,
			0x19c4, 0x19c4, 0x19e2, 0x19e2, 0x19f7, 0x1a0c, 0x1a1e, 0x1a40,
			0x1a40, 0x1a40, 0x1a5e, 0x1a6d, 0x1a6d, 0x1a6d, 0x1a6d, 0x1a7f,
			0x1a94, 0x1aa6, 0x1aa6, 0x1abe, 0x1ad0, 0x1aeb, 0x1aeb, 0x1aeb,
			// Entry 180 - 1BF
			0x1aeb, 0x1aeb, 0x1aeb, 0x1afa, 0x1b06, 0x1b06, 0x1b22, 0x1b37,
			0x1b49, 0x1b52, 0x1b61, 0x1b61, 0x1b61, 0x1b61, 0x1b79, 0x1b79,
			0x1b8b, 0x1b9d, 0x1baf, 0x1bcd, 0x1bdc, 0x1bdc, 0x1beb, 0x1bfd,
			0x1c0f, 0x1c0f, 0x1c0f, 0x1c2b, 0x1c2b, 0x1c2b, 0x1c40, 0x1c61,
			0x1c73, 0x1c88, 0x1c97, 0x1ca3, 0x1ca3, 0x1ca3, 0x1cc8, 0x1cda,
			0x1cf8, 0x1d0d, 0x1d0d, 0x1d0d, 0x1d1f, 0x1d1f, 0x1d1f, 0x1d3d,
			0x1d3d, 0x1d59, 0x1d6b, 0x1d7d, 0x1d92, 0x1d92, 0x1d92, 0x1d92,
			0x1da1, 0x1dc0, 0x1dc0, 0x1dcf, 0x1dee, 0x1dee, 0x1e1c, 0x1e37,
			// Entry 1C0 - 1FF
			0x1e52, 0x1e64, 0x1e76, 0x1e88, 0x1eb9, 0x1ee0, 0x1ef8, 0x1f16,
			0x1f3a, 0x1f52, 0x1f52, 0x1f52, 0x1f52, 0x1f7d, 0x1f7d, 0x1f98,
			0x1f98, 0x1f98, 0x1fb0, 0x1fb0, 0x1fea, 0x1fea, 0x1fea, 0x2005,
			0x201a, 0x203b, 0x203b, 0x203b, 0x203b, 0x204d, 0x204d, 0x204d,
			0x204d, 0x206b, 0x206b, 0x2080, 0x2092, 0x20c3, 0x20c3, 0x20d5,
			0x20ed, 0x20ed, 0x20ed, 0x20ed, 0x2108, 0x211a, 0x211a, 0x211a,
			0x211a, 0x211a, 0x212f, 0x212f, 0x2151, 0x2151, 0x2151, 0x215d,
			0x215d, 0x216f, 0x216f, 0x216f, 0x218e, 0x21a7, 0x21c3, 0x21e5,
			// Entry 200 - 23F
			0x21fd, 0x2215, 0x223a, 0x224c, 0x224c, 0x224c, 0x225e, 0x226a,
			0x2285, 0x2285, 0x2285, 0x22b6, 0x22c8, 0x22c8, 0x22c8, 0x22d7,
			0x22d7, 0x22e9, 0x22fb, 0x2310, 0x231c, 0x2331, 0x2331, 0x234c,
			0x236a, 0x236a, 0x2382, 0x23a7, 0x23c6, 0x23c6, 0x23c6, 0x23c6,
			0x23e7, 0x23e7, 0x23ff, 0x2411, 0x2411, 0x242c, 0x242c, 0x2447,
			0x2462, 0x247d, 0x2486, 0x248f, 0x248f, 0x248f, 0x248f, 0x248f,
			0x24a1, 0x24a1, 0x24a1, 0x24a1, 0x24b0, 0x24bc, 0x24c8, 0x24c8,
			0x24c8, 0x24e0, 0x24e0, 0x24e0, 0x24e9, 0x24fb, 0x24fb, 0x24fb,
			// Entry 240 - 27F
			0x24fb, 0x24fb, 0x2513, 0x2537, 0x2537, 0x2549, 0x2549, 0x2555,
			0x25a9, 0x25b5, 0x25b5, 0x25e6, 0x2618, 0x264f, 0x267d, 0x26a8,
			0x26cc, 0x2713, 0x2747, 0x2747, 0x2778, 0x27a3, 0x27bb, 0x27fe,
			0x283b, 0x2859, 0x2887, 0x28b2, 0x28e3,
		},
	},
	{ // os
		"абхазагавестӕафрикаансараббагавайрагтӕтӕйрагбашкирагболгайрагбосниагката" +
			"лайнагцӕцӕйнагчехагчувашагданиагнемыцагбердзейнаганглисагесперантои" +
			"спайнагестойнагбаскагперсайнагфиннагфиджифарерагфранцагирландиагуир" +
			"агхорватагвенгериагсомихагиталиагяпойнаггуырдзиагкурдаглатинагмӕчъи" +
			"дониронпортугалиагуырыссагкитайагадыгейаграгон англисагбурятагкопта" +
			"грагон египтагфилиппинаграгон францаграгон бердзейнагмӕхъӕлонкӕсгон" +
			"бӕлхъӕронхъуымыхъхъаглекъагцигайнагнӕзонгӕ ӕвзагавстралиаг немыцагш" +
			"вйецариаг немыцагавстралиаг англисагканадӕйаг англисагбритайнаг анг" +
			"лисагамерикаг англисаглатинаг америкаг англисагевропӕйаг англисагка" +
			"надӕйаг францагшвейцариаг францагбразилиаг португалиагевропӕйаг пол" +
			"тугалиагӕнцонгонд китайагтрадицион китайаг",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000e, 0x001a, 0x002c, 0x002c, 0x002c, 0x002c,
			0x003a, 0x003a, 0x0048, 0x0048, 0x0058, 0x0068, 0x0068, 0x007a,
			0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x0088, 0x009c, 0x00ac,
			0x00ac, 0x00ac, 0x00ac, 0x00b6, 0x00b6, 0x00c4, 0x00c4, 0x00d0,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00f2, 0x0102, 0x0114, 0x0124,
			0x0134, 0x0140, 0x0152, 0x0152, 0x015e, 0x0168, 0x0176, 0x0184,
			0x0184, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196,
			0x01a0, 0x01a0, 0x01a0, 0x01b0, 0x01b0, 0x01c2, 0x01d0, 0x01d0,
			// Entry 40 - 7F
			0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0,
			0x01de, 0x01de, 0x01ec, 0x01ec, 0x01fe, 0x01fe, 0x01fe, 0x01fe,
			0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x020a,
			0x020a, 0x020a, 0x020a, 0x0218, 0x0218, 0x0218, 0x0218, 0x0218,
			0x0218, 0x0218, 0x0218, 0x0218, 0x0218, 0x0218, 0x0218, 0x0228,
			0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228,
			0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228,
			0x0228, 0x0228, 0x0228, 0x0228, 0x0230, 0x0230, 0x0230, 0x0230,
			// Entry 80 - BF
			0x0230, 0x0246, 0x0246, 0x0246, 0x0246, 0x0246, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0264, 0x0264, 0x0264, 0x0264, 0x0264,
			0x0274, 0x0274, 0x0274, 0x0274, 0x0274, 0x0274, 0x0274, 0x0274,
			// Entry C0 - FF
			0x0274, 0x0274, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			// Entry 100 - 13F
			0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9,
			0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9,
			0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02c2,
			0x02c2, 0x02c2, 0x02c2, 0x02c2, 0x02c2, 0x02c2, 0x02c2, 0x02d6,
			0x02d6, 0x02d6, 0x02d6, 0x02d6, 0x02ef, 0x02ef, 0x02ef, 0x02ef,
			0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef,
			0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef,
			0x02ef, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e,
			// Entry 140 - 17F
			0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e,
			0x030e, 0x030e, 0x030e, 0x030e, 0x031e, 0x031e, 0x031e, 0x031e,
			0x031e, 0x031e, 0x031e, 0x031e, 0x031e, 0x031e, 0x031e, 0x031e,
			0x031e, 0x031e, 0x031e, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a,
			0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a,
			0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x033c,
			0x033c, 0x033c, 0x033c, 0x033c, 0x033c, 0x033c, 0x033c, 0x0354,
			0x0354, 0x0354, 0x0354, 0x0354, 0x0354, 0x0360, 0x0360, 0x0360,
			// Entry 180 - 1BF
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			// Entry 1C0 - 1FF
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			// Entry 200 - 23F
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			// Entry 240 - 27F
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x03ac, 0x03cf, 0x03f4, 0x0417, 0x043a,
			0x045b, 0x048b, 0x04ae, 0x04ae, 0x04cf, 0x04f2, 0x04f2, 0x051b,
			0x0544, 0x0544, 0x0544, 0x0565, 0x0586,
		},
	},
	{ // pa
		paLangStr,
		paLangIdx,
	},
	{ // pa-Arab
		"پنجابی",
		[]uint16{ // 126 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c,
		},
	},
	{ // pl
		plLangStr,
		plLangIdx,
	},
	{ // ps
		"عربيالمانيیونانيانګلیسيحبشيفارسيفینلنډيفرانسويعبريهنديارمنيایټالويجاپانی" +
			"کرديلاتینيملغاسيمقدونيمغوليملایاپولنډيپښتوپورتګاليروسيسنسکریټسویډنی" +
			"تاجکترکمنيتاتارازبکيچینيبلوڅي",
		[]uint16{ // 211 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0020, 0x002e, 0x002e, 0x002e,
			0x0036, 0x0036, 0x0040, 0x0040, 0x004e, 0x004e, 0x004e, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x0064, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x0076, 0x0076,
			// Entry 40 - 7F
			0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076,
			0x0084, 0x0084, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090,
			0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0098,
			0x0098, 0x0098, 0x0098, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00b0, 0x00b0, 0x00b0, 0x00bc,
			0x00bc, 0x00c6, 0x00c6, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0,
			0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0,
			0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00dc,
			// Entry 80 - BF
			0x00e4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00fc, 0x00fc,
			0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
			0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
			0x0116, 0x0116, 0x0116, 0x0116, 0x011e, 0x011e, 0x011e, 0x012a,
			0x012a, 0x012a, 0x012a, 0x012a, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x013e, 0x013e, 0x013e, 0x013e, 0x013e, 0x013e, 0x013e,
			0x013e, 0x013e, 0x013e, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146,
			0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146,
			// Entry C0 - FF
			0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146,
			0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146, 0x0146,
			0x0146, 0x0146, 0x0150,
		},
	},
	{ // pt
		ptLangStr,
		ptLangIdx,
	},
	{ // pt-PT
		ptPTLangStr,
		ptPTLangIdx,
	},
	{ // qu
		"Afrikaans SimiAmarico SimiArabe SimiAsames SimiAzerbaiyano SimiBaskir Si" +
			"miBielorruso SimiBulgaro SimiBangla SimiTibetano SimiBreton SimiBosn" +
			"io SimiCatalan SimiCorso SimiCheco SimiGales SimiDanes SimiAleman Si" +
			"miDivehi SimiGriego SimiIngles SimiEspañol SimiEstonio SimiEuskera S" +
			"imiPersa SimiFulah SimiFines SimiFeroes SimiFrances SimiFrison SimiI" +
			"rlandes SimiGaelico Escoces SimiGallego SimiGujarati SimiHausa SimiH" +
			"ebreo SimiHindi SimiCroata SimiHaitiano Criollo SimiHungaro SimiArme" +
			"nio SimiIndonesio SimiIgbo SimiYi SimiIslandes SimiItaliano SimiInuk" +
			"titut SimiJapones SimiGeorgiano SimiKazajo SimiGroenlandes SimiKhmer" +
			" SimiKannada SimiCoreano SimiKirghiz SimiLuxemburgues SimiLao SimiLi" +
			"tuano SimiLeton SimiMaori SimiMacedonio SimiMalayalam SimiMongol Sim" +
			"iMarathi SimiMalayo SimiMaltes SimiNepali SimiNeerlandes SimiNoruego" +
			" SimiOccitano SimiOdia SimiPunyabi SimiPolaco SimiPashto SimiPortugu" +
			"es SimiRunasimiRomanche SimiRumano SimiRuso SimiKinyarwanda SimiSans" +
			"crito SimiSindhi SimiChincha Sami SimiCingales SimiEslovaco SimiEslo" +
			"veno SimiAlbanes SimiSerbio SimiSueco SimiSuajili SimiTamil SimiTelu" +
			"gu SimiTayiko SimiTailandes SimiTigriña SimiTurcomano SimiSetsuana S" +
			"imiTurco SimiTartaro SimiUigur SimiUcraniano SimiUrdu SimiUzbeko Sim" +
			"iVietnamita SimiWolof SimiIsixhosa SimiYoruba SimiChino SimiIsizulu " +
			"SimiMapuche SimiCheroqui SimiChawpi Kurdo SimiBajo Sorbio SimiFilipi" +
			"no SimiAlsaciano SimiHmong Daw SimiAlto Sorbio SimiKonkani SimiMohaw" +
			"k SimiSesotho Sa Leboa SimiPapiamento SimiKʼicheʼ SimiSakha SimiQull" +
			"a Sami SimiSami Lule SimiSami Inari SimiSami Skolt SimiSiriaco Simi",
		[]uint16{ // 525 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x000e, 0x001a, 0x001a,
			0x0024, 0x002f, 0x002f, 0x002f, 0x003f, 0x004a, 0x0059, 0x0065,
			0x0065, 0x0065, 0x0070, 0x007d, 0x0088, 0x0093, 0x009f, 0x009f,
			0x009f, 0x00a9, 0x00a9, 0x00b3, 0x00b3, 0x00b3, 0x00bd, 0x00c7,
			0x00d2, 0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00f3, 0x00f3, 0x0100,
			0x010c, 0x0118, 0x0122, 0x012c, 0x0136, 0x0136, 0x0141, 0x014d,
			0x0158, 0x0165, 0x0179, 0x0185, 0x0185, 0x0192, 0x0192, 0x019c,
			0x01a7, 0x01b1, 0x01b1, 0x01bc, 0x01d1, 0x01dd, 0x01e9, 0x01e9,
			// Entry 40 - 7F
			0x01e9, 0x01f7, 0x01f7, 0x0200, 0x0207, 0x0207, 0x0207, 0x0214,
			0x0221, 0x022f, 0x023b, 0x023b, 0x0249, 0x0249, 0x0249, 0x0249,
			0x0254, 0x0264, 0x026e, 0x027a, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0292, 0x0292, 0x02a3, 0x02a3, 0x02a3, 0x02a3,
			0x02ab, 0x02b7, 0x02b7, 0x02c1, 0x02c1, 0x02c1, 0x02cb, 0x02d9,
			0x02e7, 0x02f2, 0x02fe, 0x0309, 0x0314, 0x0314, 0x0314, 0x0314,
			0x031f, 0x031f, 0x032e, 0x032e, 0x033a, 0x033a, 0x033a, 0x033a,
			0x0347, 0x0347, 0x0347, 0x0350, 0x0350, 0x035c, 0x035c, 0x0367,
			// Entry 80 - BF
			0x0372, 0x0380, 0x0388, 0x0395, 0x0395, 0x03a0, 0x03a9, 0x03b9,
			0x03c7, 0x03c7, 0x03d2, 0x03e3, 0x03e3, 0x03f0, 0x03fd, 0x040a,
			0x040a, 0x040a, 0x040a, 0x0416, 0x0421, 0x0421, 0x0421, 0x0421,
			0x042b, 0x0437, 0x0441, 0x044c, 0x0457, 0x0465, 0x0472, 0x0480,
			0x048d, 0x048d, 0x0497, 0x0497, 0x04a3, 0x04a3, 0x04ad, 0x04bb,
			0x04c4, 0x04cf, 0x04cf, 0x04de, 0x04de, 0x04de, 0x04e8, 0x04f5,
			0x04f5, 0x0500, 0x0500, 0x050a, 0x0516, 0x0516, 0x0516, 0x0516,
			0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0516,
			// Entry C0 - FF
			0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x052f, 0x052f, 0x0540,
			// Entry 100 - 13F
			0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540,
			0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0550, 0x0550, 0x0550,
			0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550,
			0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x055d,
			0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d,
			0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d,
			0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d,
			0x055d, 0x055d, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b,
			// Entry 140 - 17F
			0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x0579, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			// Entry 180 - 1BF
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0,
			0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0,
			0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0,
			0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05b5, 0x05b5, 0x05b5, 0x05b5,
			// Entry 1C0 - 1FF
			0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5,
			0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4,
			0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05d2, 0x05d2, 0x05d2,
			0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2,
			0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05dc, 0x05dc, 0x05dc, 0x05dc,
			0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc,
			0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc,
			0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05eb, 0x05f9, 0x0608, 0x0617,
			// Entry 200 - 23F
			0x0617, 0x0617, 0x0617, 0x0617, 0x0617, 0x0617, 0x0617, 0x0617,
			0x0617, 0x0617, 0x0617, 0x0617, 0x0623,
		},
	},
	{ // rm
		"afarabchasianavesticafrikaansakanamaricaragonaisarabassamiavaricaymaraas" +
			"erbeidschanicbaschkirbielorussbulgarbislamabambarabengaltibetanbreto" +
			"nbosniaccatalantschetschenchamorrocorscreetschecslav da baselgiatsch" +
			"uvaschkimricdanaistudestgmaledivicdzongkhaewegrecenglaisesperantospa" +
			"gnolestonbascpersianfulahfinlandaisfidschianferraisfranzosfrisirland" +
			"aisgaelic scotgalicianguaranigujaratimanxhaussaebraichindihiri motuc" +
			"roathaitianungaraisarmenhererointerlinguaindonaisinterlingueigbosich" +
			"uan yiinupiakidoislandaistalianinuktitutgiapunaisjavanaisgeorgiankon" +
			"gokikuyukuanyamacasacgrönlandaiscambodschankannadacoreankanurikashmi" +
			"ricurdkomicornickirghislatinluxemburgaisgandalimburgaislingalalaotli" +
			"tuanluba-katangalettonmalagassimarschallaismaorimacedonmalayalammong" +
			"olicmarathimalaicmaltaisbirmannaurundebele dal nordnepalaisndongaoll" +
			"andaisnorvegiais nynorsknorvegais bokmålndebele dal sidnavajonyanjao" +
			"ccitanojibwaoromooriyaosseticpunjabipalipolacpaschtoportugaisquechua" +
			"rumantschrundirumenrusskinyarwandasanscritsardsindhisami dal nordsan" +
			"gosingalaisslovacslovensamoanshonasomalialbanaisserbswazisotho dal s" +
			"idsundanaissvedaissuahilitamiltelugutadjiktailandaistigrinyaturkment" +
			"swanatongatirctsongatatartahitianuiguricucranaisurduusbecvendavietna" +
			"maisvolapukvallonwolofxhosajiddicyorubazhuangchinaiszuluacehacoliand" +
			"angmeadygaiafrihiliainuaccadicaleuticaltaic dal sidenglais veglangik" +
			"aarameicaraucanicarapahoarawakasturianawadhibelutschibalinaisbasaabe" +
			"dschabembabhojpuribikolbinisiksikabrajburiatbugiblincaddocaribicatsa" +
			"mcebuanochibchatschagataicchuukaismaripatuà chinookchoctawchipewyanc" +
			"herokeecheyennecoptictirc crimeankaschubicdakotadargwadelawareslavey" +
			"dogribdinkadogribass sorbdualaollandais mesaundiulaefikegipzian vegl" +
			"ekajukelamiticenglais mesaunewondofangfilippinofonfranzos mesaunfran" +
			"zos veglfris dal nordfris da l’ostfriulangagayogbayageezgilbertaistu" +
			"destg mesaunvegl tudestg da scrittiragondigorontalogoticgrebogrec ve" +
			"gltudestg svizzergwichʼinhaidahawaianhiligaynonettitichmongaut sorbh" +
			"upaibanilocanoingushlojbangiudaic-persiangiudaic-arabkarakalpakkabyl" +
			"ekachinjjukambakawikabardictyapkorokhasikhotanaiskimbundukonkanikosr" +
			"aeankpellekarachay-balkarcareliankurukhkumukkutenailadinolahndalamba" +
			"lezghianlomongoloziluba-lulualuisenolundaluolushaimaduraismagahimait" +
			"hilimakassarmandingomasaimokshamandarmendeirlandais mesaunmicmacmina" +
			"ngkabaumanchumanipurimohawkmossiplurilingcreekmirandaismarwarierzyan" +
			"eapolitanbass tudestgnewariniasniuenogainordic vegln’kosotho dal nor" +
			"dnewari classicnyamwezinyankolenyoronzimaosagetirc ottomanpangasinan" +
			"pahlavipampangapapiamentopalaupersian veglfenizianponapeanprovenzal " +
			"veglrajasthanirapanuirarotongaromaniaromunicsandawejakutarameic sama" +
			"ritansasaksantalisicilianscotselkupirlandais veglshansidamosami dal " +
			"sidsami lulesami inarisami skoltsoninkesogdiansranan tongoserersukum" +
			"asususumericsiric classicsirictemneterenotetumtigretivtokelauklingon" +
			"ictlingittamasheqlingua tsongatok pisintsimshiantumbukatuvalutuvinia" +
			"nudmurtugariticmbundulinguas betg determinadasvaivoticwalamowaraywas" +
			"hokalmukyaoyapaiszapotecsimbols da Blisszenagazuninagins cuntegns li" +
			"nguisticszazatudestg austriacenglais australianenglais canadaisengla" +
			"is britannicenglais americanspagnol latinamericanspagnol ibericfranz" +
			"os canadaisfranzos svizzerflamportugais brasilianportugais iberianmo" +
			"ldavserbo-croatchinais simplifitgàchinais tradiziunal",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0014, 0x001d, 0x0021, 0x0027, 0x0030,
			0x0034, 0x003a, 0x0040, 0x0046, 0x0055, 0x005d, 0x0066, 0x006c,
			0x0073, 0x007a, 0x0080, 0x0087, 0x008d, 0x0094, 0x009b, 0x00a6,
			0x00ae, 0x00b2, 0x00b6, 0x00bc, 0x00cc, 0x00d6, 0x00dc, 0x00e2,
			0x00e9, 0x00f2, 0x00fa, 0x00fd, 0x0101, 0x0108, 0x0111, 0x0118,
			0x011d, 0x0121, 0x0128, 0x012d, 0x0137, 0x0140, 0x0147, 0x014e,
			0x0152, 0x015b, 0x0166, 0x016e, 0x0175, 0x017d, 0x0181, 0x0187,
			0x018d, 0x0192, 0x019b, 0x01a0, 0x01a7, 0x01af, 0x01b4, 0x01ba,
			// Entry 40 - 7F
			0x01c5, 0x01cd, 0x01d8, 0x01dc, 0x01e6, 0x01ed, 0x01f0, 0x01f9,
			0x01ff, 0x0208, 0x0211, 0x0219, 0x0221, 0x0226, 0x022c, 0x0234,
			0x0239, 0x0245, 0x0250, 0x0257, 0x025d, 0x0263, 0x026b, 0x026f,
			0x0273, 0x0279, 0x0280, 0x0285, 0x0291, 0x0296, 0x02a0, 0x02a7,
			0x02ab, 0x02b1, 0x02bd, 0x02c3, 0x02cc, 0x02d8, 0x02dd, 0x02e4,
			0x02ed, 0x02f5, 0x02fc, 0x0302, 0x0309, 0x030f, 0x0314, 0x0324,
			0x032c, 0x0332, 0x033b, 0x034d, 0x035e, 0x036d, 0x0373, 0x0379,
			0x0380, 0x0386, 0x038b, 0x0390, 0x0397, 0x039e, 0x03a2, 0x03a7,
			// Entry 80 - BF
			0x03ae, 0x03b7, 0x03be, 0x03c7, 0x03cc, 0x03d1, 0x03d5, 0x03e0,
			0x03e8, 0x03ec, 0x03f2, 0x03ff, 0x0404, 0x040d, 0x0413, 0x0419,
			0x041f, 0x0424, 0x042a, 0x0432, 0x0436, 0x043b, 0x0448, 0x0451,
			0x0458, 0x045f, 0x0464, 0x046a, 0x0470, 0x047a, 0x0482, 0x0489,
			0x048f, 0x0494, 0x0498, 0x049e, 0x04a3, 0x04ab, 0x04b2, 0x04ba,
			0x04be, 0x04c3, 0x04c8, 0x04d2, 0x04d9, 0x04df, 0x04e4, 0x04e9,
			0x04ef, 0x04f5, 0x04fb, 0x0502, 0x0506, 0x050a, 0x050f, 0x0517,
			0x051d, 0x051d, 0x0525, 0x0525, 0x0529, 0x0530, 0x0530, 0x0537,
			// Entry C0 - FF
			0x0537, 0x0545, 0x0551, 0x0557, 0x055e, 0x0567, 0x0567, 0x056e,
			0x056e, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x057c, 0x057c,
			0x0582, 0x0582, 0x058b, 0x0593, 0x0593, 0x0598, 0x0598, 0x0598,
			0x0598, 0x059f, 0x05a4, 0x05a4, 0x05a4, 0x05a4, 0x05a4, 0x05ac,
			0x05b1, 0x05b5, 0x05b5, 0x05b5, 0x05bc, 0x05bc, 0x05bc, 0x05c0,
			0x05c0, 0x05c0, 0x05c0, 0x05c6, 0x05ca, 0x05ca, 0x05ce, 0x05ce,
			0x05d3, 0x05da, 0x05da, 0x05df, 0x05e6, 0x05e6, 0x05ed, 0x05f8,
			0x0600, 0x0604, 0x0612, 0x0619, 0x0622, 0x062a, 0x0632, 0x0632,
			// Entry 100 - 13F
			0x0638, 0x0638, 0x0644, 0x064d, 0x0653, 0x0659, 0x0659, 0x0661,
			0x0667, 0x066d, 0x0672, 0x0672, 0x0677, 0x0680, 0x0680, 0x0685,
			0x0695, 0x0695, 0x069a, 0x069a, 0x069a, 0x069e, 0x069e, 0x06ab,
			0x06b1, 0x06b9, 0x06c7, 0x06c7, 0x06cd, 0x06cd, 0x06d1, 0x06da,
			0x06da, 0x06dd, 0x06dd, 0x06eb, 0x06f7, 0x06f7, 0x0704, 0x0713,
			0x071a, 0x071c, 0x071c, 0x071c, 0x0720, 0x0725, 0x0725, 0x0729,
			0x0733, 0x0733, 0x0741, 0x075a, 0x075a, 0x075f, 0x0768, 0x076d,
			0x0772, 0x077b, 0x078a, 0x078a, 0x078a, 0x078a, 0x0793, 0x0798,
			// Entry 140 - 17F
			0x0798, 0x079f, 0x079f, 0x07a9, 0x07b0, 0x07b5, 0x07bd, 0x07bd,
			0x07c1, 0x07c5, 0x07c5, 0x07cc, 0x07d2, 0x07d2, 0x07d2, 0x07d8,
			0x07d8, 0x07d8, 0x07e7, 0x07f3, 0x07f3, 0x07fd, 0x0803, 0x0809,
			0x080c, 0x0811, 0x0815, 0x081d, 0x081d, 0x0821, 0x0821, 0x0821,
			0x0821, 0x0825, 0x0825, 0x082a, 0x0833, 0x0833, 0x0833, 0x0833,
			0x0833, 0x0833, 0x083b, 0x083b, 0x0842, 0x084a, 0x0850, 0x085f,
			0x085f, 0x085f, 0x0867, 0x086d, 0x086d, 0x086d, 0x086d, 0x0872,
			0x0879, 0x087f, 0x087f, 0x0885, 0x088a, 0x0892, 0x0892, 0x0892,
			// Entry 180 - 1BF
			0x0892, 0x0892, 0x0892, 0x0899, 0x089d, 0x089d, 0x08a7, 0x08ae,
			0x08b3, 0x08b6, 0x08bc, 0x08bc, 0x08bc, 0x08bc, 0x08c4, 0x08c4,
			0x08ca, 0x08d2, 0x08da, 0x08e2, 0x08e7, 0x08e7, 0x08ed, 0x08f3,
			0x08f8, 0x08f8, 0x08f8, 0x0908, 0x0908, 0x0908, 0x090e, 0x0919,
			0x091f, 0x0927, 0x092d, 0x0932, 0x0932, 0x0932, 0x093b, 0x0940,
			0x0949, 0x0950, 0x0950, 0x0950, 0x0955, 0x0955, 0x0955, 0x095f,
			0x095f, 0x096b, 0x0971, 0x0975, 0x0979, 0x0979, 0x0979, 0x0979,
			0x097e, 0x0989, 0x0989, 0x098f, 0x099d, 0x099d, 0x09ab, 0x09b3,
			// Entry 1C0 - 1FF
			0x09bb, 0x09c0, 0x09c5, 0x09ca, 0x09d6, 0x09e0, 0x09e7, 0x09ef,
			0x09f9, 0x09fe, 0x09fe, 0x09fe, 0x09fe, 0x0a0a, 0x0a0a, 0x0a12,
			0x0a12, 0x0a12, 0x0a1a, 0x0a1a, 0x0a28, 0x0a28, 0x0a28, 0x0a32,
			0x0a39, 0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a48, 0x0a48, 0x0a48,
			0x0a48, 0x0a50, 0x0a50, 0x0a57, 0x0a5c, 0x0a6d, 0x0a6d, 0x0a72,
			0x0a79, 0x0a79, 0x0a79, 0x0a79, 0x0a81, 0x0a85, 0x0a85, 0x0a85,
			0x0a85, 0x0a85, 0x0a8b, 0x0a8b, 0x0a99, 0x0a99, 0x0a99, 0x0a9d,
			0x0a9d, 0x0aa3, 0x0aa3, 0x0aa3, 0x0aaf, 0x0ab8, 0x0ac2, 0x0acc,
			// Entry 200 - 23F
			0x0ad3, 0x0ada, 0x0ae6, 0x0aeb, 0x0aeb, 0x0aeb, 0x0af1, 0x0af5,
			0x0afc, 0x0afc, 0x0afc, 0x0b09, 0x0b0e, 0x0b0e, 0x0b0e, 0x0b13,
			0x0b13, 0x0b19, 0x0b1e, 0x0b23, 0x0b26, 0x0b2d, 0x0b2d, 0x0b36,
			0x0b3d, 0x0b3d, 0x0b45, 0x0b52, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b,
			0x0b64, 0x0b64, 0x0b6b, 0x0b71, 0x0b71, 0x0b79, 0x0b79, 0x0b7f,
			0x0b87, 0x0b8d, 0x0ba6, 0x0ba9, 0x0ba9, 0x0ba9, 0x0ba9, 0x0ba9,
			0x0bae, 0x0bae, 0x0bae, 0x0bae, 0x0bb4, 0x0bb9, 0x0bbe, 0x0bbe,
			0x0bbe, 0x0bc4, 0x0bc4, 0x0bc4, 0x0bc7, 0x0bcd, 0x0bcd, 0x0bcd,
			// Entry 240 - 27F
			0x0bcd, 0x0bcd, 0x0bd4, 0x0be4, 0x0be4, 0x0bea, 0x0bea, 0x0bee,
			0x0c09, 0x0c0d, 0x0c0d, 0x0c1d, 0x0c1d, 0x0c2f, 0x0c3f, 0x0c50,
			0x0c60, 0x0c75, 0x0c83, 0x0c83, 0x0c93, 0x0ca2, 0x0ca6, 0x0cb9,
			0x0cca, 0x0cd0, 0x0cdb, 0x0cef, 0x0d02,
		},
	},
	{ // rn
		"IgikaniIkimuharikiIcarabuIkibelarusiyaIkinyabuligariyaIkibengaliIgicekeI" +
			"kidageIkigerekiIcongerezaIcesipanyoloIgiperisiIgifaransaIgihawusaIgi" +
			"hindiIkinyahongiriyaIkinyendoziyaIkiguboIgitaliyaniIkiyapaniIkinyeja" +
			"vaIgikambodiyaIkinyakoreyaIkinyamaleziyaIkinyabirimaniyaIkinepaliIgi" +
			"holandiIgipunjabiIkinyapolonyeIgiporutugariIkirundiIkinyarumaniyaIki" +
			"rusiyaIkinyarwandaIgisomaliIgisuweduwaIgitamiliIkinyatayilandiIgitur" +
			"ukiyaIkinyayukereniInyeyuruduIkinyaviyetinamuIkiyorubaIgishinwaIkizu" +
			"lu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0012, 0x0012,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0026, 0x0036,
			0x0036, 0x0036, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
			0x004e, 0x004e, 0x004e, 0x004e, 0x0057, 0x0061, 0x0061, 0x006d,
			0x006d, 0x006d, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0080,
			0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089,
			0x0089, 0x0091, 0x0091, 0x0091, 0x0091, 0x00a0, 0x00a0, 0x00a0,
			// Entry 40 - 7F
			0x00a0, 0x00ad, 0x00ad, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00bf, 0x00bf, 0x00c8, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00de, 0x00de, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00ea, 0x00ea, 0x00ea, 0x00f8, 0x00f8, 0x0108, 0x0108, 0x0108,
			0x0111, 0x0111, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x0125, 0x0125, 0x0132,
			// Entry 80 - BF
			0x0132, 0x013f, 0x013f, 0x013f, 0x0147, 0x0155, 0x015e, 0x016a,
			0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a,
			0x016a, 0x016a, 0x0173, 0x0173, 0x0173, 0x0173, 0x0173, 0x0173,
			0x017e, 0x017e, 0x0187, 0x0187, 0x0187, 0x0196, 0x0196, 0x0196,
			0x0196, 0x0196, 0x01a1, 0x01a1, 0x01a1, 0x01a1, 0x01a1, 0x01af,
			0x01b9, 0x01b9, 0x01b9, 0x01c9, 0x01c9, 0x01c9, 0x01c9, 0x01c9,
			0x01c9, 0x01d2, 0x01d2, 0x01db, 0x01e2,
		},
	},
	{ // ro
		roLangStr,
		roLangIdx,
	},
	{ // rof
		"KiakaniKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigi" +
			"rikiKiingerezaKihispaniaKiajemiKyifaransaKihausaKihindiKihungariKiin" +
			"donesiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKibur" +
			"maKinepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwand" +
			"aKisomaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuK" +
			"iyorubaKichinaKizuluKihorombo",
		[]uint16{ // 477 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x000f, 0x000f,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a,
			0x0044, 0x0044, 0x0044, 0x0044, 0x004c, 0x0056, 0x0056, 0x0060,
			0x0060, 0x0060, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0071,
			0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0078,
			0x0078, 0x007f, 0x007f, 0x007f, 0x007f, 0x0088, 0x0088, 0x0088,
			// Entry 40 - 7F
			0x0088, 0x0093, 0x0093, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x00a3, 0x00a3, 0x00ab, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00bb, 0x00bb, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00c2, 0x00cb, 0x00cb, 0x00d2, 0x00d2, 0x00d2,
			0x00da, 0x00da, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3,
			0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00ec, 0x00ec, 0x00f5,
			// Entry 80 - BF
			0x00f5, 0x00fb, 0x00fb, 0x00fb, 0x00fb, 0x0104, 0x010a, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x0124, 0x0124, 0x012b, 0x012b, 0x012b, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x0146,
			0x014c, 0x014c, 0x014c, 0x0157, 0x0157, 0x0157, 0x0157, 0x0157,
			0x0157, 0x015f, 0x015f, 0x0166, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry C0 - FF
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 100 - 13F
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 140 - 17F
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 180 - 1BF
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 1C0 - 1FF
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x0175,
		},
	},
	{ // ru
		ruLangStr,
		ruLangIdx,
	},
	{ // rw
		"IkinyafurikaneriInyetuwiInyamuharikiIcyarabuIcyasamiziInyazeribayijaniIk" +
			"ibelarusiyaUrunyabuligariyaIkibengaliInyebiritoniInyebosiniyaIgikata" +
			"laniIgicekeIkigaluwaIkidaninwaIkidageIkigerekiIcyongerezaIcyesiperan" +
			"toIcyesipanyoloIcyesitoniyaIkibasikiInyeperisiIgifinilandeInyefaroyi" +
			"ziIgifaransaIgifiriziyaniIkirilandiIkigaluwa cy’IgisweduwaIkigalisiy" +
			"aInyaguwaraniInyegujaratiIgiheburayoIgihindiIgikorowasiyaIgihongiriy" +
			"aIkinyarumeniyaUrurimi GahuzamiryangoIkinyendoziyaUruhuzandimiIgisil" +
			"andeIgitaliyaniIkiyapaniInyejavaInyejeworujiyaIgikambodiyaIgikanadaI" +
			"gikoreyaInyekuridishiInkerigiziIkilatiniIlingalaIkilawotiyaniIkilitu" +
			"waniyaIkinyaletoviyaniIkimasedoniyaniIkimalayalamiIkimongoliIkimarat" +
			"iIkimalayiIkimalitezeIkinepaliIkinerilandeInyenoruveji (Nyonorusiki)" +
			"IkinoruvejiInyogusitaniInyoriyaIgipunjabiIgipoloneImpashitoIgiporutu" +
			"galiIkinyarumaniyaIkirusiyaKinyarwandaIgisansikiriIgisindiInyesimpal" +
			"ezeIgisilovakiIkinyasiloveniyaIgisomaliIcyalubaniyaIgiseribeInyeseso" +
			"toInyesudaniIgisuweduwaIgiswahiliIgitamiliIgiteluguIgitayiInyatigiri" +
			"nyaInyeturukimeniIgiturukiyaIkiwiguriIkinyayukereniInyeyuruduInyeyuz" +
			"ubekiIkinyaviyetinamuInyehawusaInyeyidishiInyezuluIkinyafilipineInye" +
			"kilingoniInyeporutigali (Brezili)Inyeporutigali (Igiporutigali)Inyes" +
			"eribiya na Korowasiya",
		[]uint16{ // 603 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0018, 0x0024, 0x0024,
			0x002c, 0x0036, 0x0036, 0x0036, 0x0046, 0x0046, 0x0053, 0x0063,
			0x0063, 0x0063, 0x006d, 0x006d, 0x0079, 0x0085, 0x0090, 0x0090,
			0x0090, 0x0090, 0x0090, 0x0097, 0x0097, 0x0097, 0x00a0, 0x00aa,
			0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00ba, 0x00c5, 0x00d2, 0x00df,
			0x00eb, 0x00f4, 0x00fe, 0x00fe, 0x010a, 0x010a, 0x0116, 0x0120,
			0x012d, 0x0137, 0x0150, 0x015b, 0x0167, 0x0173, 0x0173, 0x0173,
			0x017e, 0x0186, 0x0186, 0x0193, 0x0193, 0x019f, 0x01ad, 0x01ad,
			// Entry 40 - 7F
			0x01c3, 0x01d0, 0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01e6,
			0x01f1, 0x01f1, 0x01fa, 0x0202, 0x0210, 0x0210, 0x0210, 0x0210,
			0x0210, 0x0210, 0x021c, 0x0225, 0x022e, 0x022e, 0x022e, 0x023b,
			0x023b, 0x023b, 0x0245, 0x024e, 0x024e, 0x024e, 0x024e, 0x0256,
			0x0263, 0x0270, 0x0270, 0x0280, 0x0280, 0x0280, 0x0280, 0x028f,
			0x029c, 0x02a6, 0x02af, 0x02b8, 0x02c3, 0x02c3, 0x02c3, 0x02c3,
			0x02cc, 0x02cc, 0x02d8, 0x02f2, 0x02fd, 0x02fd, 0x02fd, 0x02fd,
			0x0309, 0x0309, 0x0309, 0x0311, 0x0311, 0x031b, 0x031b, 0x0324,
			// Entry 80 - BF
			0x032d, 0x033a, 0x033a, 0x033a, 0x033a, 0x0348, 0x0351, 0x035c,
			0x0368, 0x0368, 0x0370, 0x0370, 0x0370, 0x037d, 0x0388, 0x0398,
			0x0398, 0x0398, 0x03a1, 0x03ad, 0x03b6, 0x03b6, 0x03c0, 0x03ca,
			0x03d5, 0x03df, 0x03e8, 0x03f1, 0x03f1, 0x03f8, 0x0405, 0x0413,
			0x0413, 0x0413, 0x041e, 0x041e, 0x041e, 0x041e, 0x0427, 0x0435,
			0x043f, 0x044b, 0x044b, 0x045b, 0x045b, 0x045b, 0x045b, 0x0465,
			0x0470, 0x0470, 0x0470, 0x0470, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			// Entry C0 - FF
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			// Entry 100 - 13F
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 140 - 17F
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 180 - 1BF
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 1C0 - 1FF
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 200 - 23F
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			// Entry 240 - 27F
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x04ab,
			0x04c9, 0x04c9, 0x04e3,
		},
	},
	{ // rwk
		"KiakanyiKiamharyiKyiarabuKyibelarusiKyibulgaryiaKyibanglaKyicheckiKyijer" +
			"umaniKyigirikiKyingerezaKyihispaniaKyiajemiKyifaransaKyihausaKyihind" +
			"iKyihungariKyiindonesiaKyiigboKyiitalianoKyijapaniKyijavaKyikambodia" +
			"KyikoreaKyimalesiaKyiburmaKyinepaliKyiholanziKyipunjabiKyipolandiKyi" +
			"renoKyiromaniaKyirusiKyinyarwandaKyisomalyiKyiswidiKyitamilKyitailan" +
			"diKyiturukyiKyiukraniaKyiurduKyivietinamuKyiyorubaKyichinaKyizuluKir" +
			"uwa",
		[]uint16{ // 483 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0056, 0x0060, 0x0060, 0x006b,
			0x006b, 0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x0085,
			0x0085, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00d0, 0x00d0, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00e2, 0x00e2, 0x00ea, 0x00ea, 0x00ea,
			0x00f3, 0x00f3, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd,
			0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x0107, 0x0107, 0x0111,
			// Entry 80 - BF
			0x0111, 0x0118, 0x0118, 0x0118, 0x0118, 0x0122, 0x0129, 0x0135,
			0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 180 - 1BF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 1C0 - 1FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x019f,
		},
	},
	{ // sah
		"АбхаастыыАппырыкааныстыыАраабтыыАдьырбайдьаанныыБөлөрүүстүүБулҕаардыыБен" +
			"галлыыТибиэттииБосныйалыыКаталаанныыЧиэскэйдииДаатскайдыыНиэмэстииГ" +
			"ириэктииАҥылычаанныыЫспаанныыЭстиэнийэлииПиэрсийэлииПииннииПырансуу" +
			"стууБэҥгиэрдииЭрмээннииЫтаалыйалыыДьоппуоннууГурусууннууХаһаахтыыКэ" +
			"риэйдииКыргыстыыЛатыынныыМоҕуоллууНьыпааллыыПандьаабтыыПортугааллыы" +
			"РумыынныыНууччалыыСловаактыыАлбаанскайдыыТамыллыыТөлүгүлүүТадьыыкты" +
			"ыУйгуурдууУкрайыыньыстыыҮзбиэктииКытайдыыЗуулулууПилипиинниисаха ты" +
			"ла",
		[]uint16{ // 485 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0012, 0x0012, 0x0030, 0x0030, 0x0030, 0x0030,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0060, 0x0060, 0x0076, 0x008a,
			0x008a, 0x008a, 0x009c, 0x00ae, 0x00ae, 0x00c2, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x0102,
			0x0114, 0x0114, 0x0114, 0x0114, 0x0126, 0x013e, 0x013e, 0x0150,
			0x0168, 0x0168, 0x017e, 0x017e, 0x018c, 0x018c, 0x018c, 0x01a4,
			0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4,
			0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01b8, 0x01ca, 0x01ca,
			// Entry 40 - 7F
			0x01ca, 0x01ca, 0x01ca, 0x01ca, 0x01ca, 0x01ca, 0x01ca, 0x01ca,
			0x01e0, 0x01e0, 0x01f6, 0x01f6, 0x020c, 0x020c, 0x020c, 0x020c,
			0x021e, 0x021e, 0x021e, 0x021e, 0x0230, 0x0230, 0x0230, 0x0230,
			0x0230, 0x0230, 0x0242, 0x0254, 0x0254, 0x0254, 0x0254, 0x0254,
			0x0254, 0x0254, 0x0254, 0x0254, 0x0254, 0x0254, 0x0254, 0x0254,
			0x0254, 0x0266, 0x0266, 0x0266, 0x0266, 0x0266, 0x0266, 0x0266,
			0x027a, 0x027a, 0x027a, 0x027a, 0x027a, 0x027a, 0x027a, 0x027a,
			0x027a, 0x027a, 0x027a, 0x027a, 0x027a, 0x0290, 0x0290, 0x0290,
			// Entry 80 - BF
			0x0290, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02ba, 0x02cc, 0x02cc,
			0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02e0, 0x02e0,
			0x02e0, 0x02e0, 0x02e0, 0x02fa, 0x02fa, 0x02fa, 0x02fa, 0x02fa,
			0x02fa, 0x02fa, 0x030a, 0x031c, 0x0330, 0x0330, 0x0330, 0x0330,
			0x0330, 0x0330, 0x0330, 0x0330, 0x0330, 0x0330, 0x0342, 0x035e,
			0x035e, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0380, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			// Entry C0 - FF
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			// Entry 100 - 13F
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390,
			0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x0390, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			// Entry 140 - 17F
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			// Entry 180 - 1BF
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			// Entry 1C0 - 1FF
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03a6,
			0x03a6, 0x03a6, 0x03a6, 0x03a6, 0x03b7,
		},
	},
	{ // saq
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKisampur",
		[]uint16{ // 487 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 180 - 1BF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 1C0 - 1FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0171,
		},
	},
	{ // sbp
		"IshiyakaniIshiyamuhaliIshiyalabuIshibelalusiIshibulugaliaIshibangilaIshi" +
			"shekiIshijelumaniIshigilikiIshingelesaIshihisipaniyaIshiajemiIshifal" +
			"ansaIshihawusaIshihindiIshihungaliIshihindonesiaIshihigiboIshihitali" +
			"yanoIshijapaniIshijavaIshikambodiaIshikoleyaIshimalesiyaIshibulumaIs" +
			"hinepaliIshiholansiIshipunjabiIshipolandiIshilenoIshilomaniyaIshilus" +
			"iIshinyalwandaIshisomaliIshiswidiIshitamiliIshitayilandiIshitulukiIs" +
			"hiyukilaniyaIshiwuludiIshivietinamuIshiyolubaIshishinaIshisuluIshisa" +
			"ngu",
		[]uint16{ // 492 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0016, 0x0016,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x002c, 0x0039,
			0x0039, 0x0039, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0063, 0x006e, 0x006e, 0x007c,
			0x007c, 0x007c, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0090,
			0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x009a,
			0x009a, 0x00a3, 0x00a3, 0x00a3, 0x00a3, 0x00ae, 0x00ae, 0x00ae,
			// Entry 40 - 7F
			0x00ae, 0x00bc, 0x00bc, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00d4, 0x00d4, 0x00de, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e6,
			0x00e6, 0x00e6, 0x00f2, 0x00f2, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x00fc, 0x00fc, 0x00fc, 0x0108, 0x0108, 0x0112, 0x0112, 0x0112,
			0x011c, 0x011c, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0132, 0x0132, 0x013d,
			// Entry 80 - BF
			0x013d, 0x0145, 0x0145, 0x0145, 0x0145, 0x0151, 0x0159, 0x0166,
			0x0166, 0x0166, 0x0166, 0x0166, 0x0166, 0x0166, 0x0166, 0x0166,
			0x0166, 0x0166, 0x0170, 0x0170, 0x0170, 0x0170, 0x0170, 0x0170,
			0x0179, 0x0179, 0x0183, 0x0183, 0x0183, 0x0190, 0x0190, 0x0190,
			0x0190, 0x0190, 0x019a, 0x019a, 0x019a, 0x019a, 0x019a, 0x01a8,
			0x01b2, 0x01b2, 0x01b2, 0x01bf, 0x01bf, 0x01bf, 0x01bf, 0x01bf,
			0x01bf, 0x01c9, 0x01c9, 0x01d2, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry C0 - FF
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 100 - 13F
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 140 - 17F
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 180 - 1BF
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 1C0 - 1FF
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01e3,
		},
	},
	{ // se
		"afrikánsagiellaaragoniagiellaarábagiellavilges-ruoššagiellabulgáriagiell" +
			"abengalgiellatibetagiellabretonagiellabosniagiellakatalánagiellacors" +
			"icagiellačeahkagiellakymragielladánskkagielladuiskkagielladivehigiel" +
			"ladzongkhagiellagreikkagiellaeaŋgalsgiellaspánskkagiellaesttegiellap" +
			"ersijagiellasuomagiellafidjigiellafearagiellafránskkagiellaoarjifrii" +
			"sagiellaiirragiellagujaratagiellamanksgiellahaussagiellahindigiellak" +
			"roátiagiellahaitigiellaungárgiellaarmeenagiellaindonesiagiellaislánd" +
			"dagiellaitáliagiellajapánagiellajavagiellageorgiagiellakazakgiellaka" +
			"mbodiagiellakoreagiellakurdigiellakomigiellakornagiellaláhtengiellal" +
			"uxemburggagiellalaogiellaliettuvagiellalátviagiellamaorigiellamakedo" +
			"niagiellamongoliagiellamaltagiellaburmagiellanepaligiellahollánddagi" +
			"ellaođđadárogiellagirjedárogiellaoksitánagiellapanjabigiellapolskkag" +
			"iellaportugálagiellaromanšgiellaromániagiellaruoššagiellasardigiella" +
			"davvisámegiellaslovákiagiellaslovenagiellasamoagiellaalbánagiellaser" +
			"biagiellaruoŧagiellaŧaigielladurkagiellatahitigiellaukrainagiellaurd" +
			"ugiellavietnamgiellavallonagiellakiinnágiellaacehgiellaboares eaŋgal" +
			"asgiellaasturiagiellamarigiellafilippiinnagiellahawaiigiellagárjilgi" +
			"ellamokšagiellaersagiellasisiliagiellaselkupagiellalullisámegiellaju" +
			"levsámegiellaanárašgiellanuortalašgiellashimaorigiellaudmurtagiellad" +
			"ovdameahttun giellakantongiellaserbokroatiagiellaálki kiinágiellaárb" +
			"evirolaš kiinnágiella",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0010, 0x001e,
			0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x003f, 0x004e,
			0x004e, 0x004e, 0x005a, 0x0066, 0x0073, 0x007f, 0x008e, 0x008e,
			0x008e, 0x009b, 0x009b, 0x00a8, 0x00a8, 0x00a8, 0x00b3, 0x00c1,
			0x00ce, 0x00da, 0x00e8, 0x00e8, 0x00f5, 0x0103, 0x0103, 0x0112,
			0x011d, 0x011d, 0x012a, 0x012a, 0x0135, 0x0140, 0x014b, 0x015a,
			0x016b, 0x0176, 0x0176, 0x0176, 0x0176, 0x0184, 0x018f, 0x019b,
			0x019b, 0x01a6, 0x01a6, 0x01b4, 0x01bf, 0x01cb, 0x01d8, 0x01d8,
			// Entry 40 - 7F
			0x01d8, 0x01e7, 0x01e7, 0x01e7, 0x01e7, 0x01e7, 0x01e7, 0x01f6,
			0x0203, 0x0203, 0x0210, 0x021a, 0x0227, 0x0227, 0x0227, 0x0227,
			0x0232, 0x0232, 0x0240, 0x0240, 0x024b, 0x024b, 0x024b, 0x0256,
			0x0260, 0x026b, 0x026b, 0x0278, 0x0289, 0x0289, 0x0289, 0x0289,
			0x0292, 0x02a0, 0x02a0, 0x02ad, 0x02ad, 0x02ad, 0x02b8, 0x02c7,
			0x02c7, 0x02d5, 0x02d5, 0x02d5, 0x02e0, 0x02eb, 0x02eb, 0x02eb,
			0x02f7, 0x02f7, 0x0307, 0x0318, 0x0328, 0x0328, 0x0328, 0x0328,
			0x0337, 0x0337, 0x0337, 0x0337, 0x0337, 0x0344, 0x0344, 0x0351,
			// Entry 80 - BF
			0x0351, 0x0361, 0x0361, 0x036e, 0x036e, 0x037c, 0x038a, 0x038a,
			0x038a, 0x0395, 0x0395, 0x03a5, 0x03a5, 0x03a5, 0x03b4, 0x03c1,
			0x03cc, 0x03cc, 0x03cc, 0x03d9, 0x03e5, 0x03e5, 0x03e5, 0x03e5,
			0x03f1, 0x03f1, 0x03f1, 0x03f1, 0x03f1, 0x03fb, 0x03fb, 0x03fb,
			0x03fb, 0x03fb, 0x0406, 0x0406, 0x0406, 0x0412, 0x0412, 0x041f,
			0x0429, 0x0429, 0x0429, 0x0436, 0x0436, 0x0443, 0x0443, 0x0443,
			0x0443, 0x0443, 0x0443, 0x0450, 0x0450, 0x045a, 0x045a, 0x045a,
			0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a,
			// Entry C0 - FF
			0x045a, 0x045a, 0x0470, 0x0470, 0x0470, 0x0470, 0x0470, 0x0470,
			0x0470, 0x0470, 0x0470, 0x0470, 0x0470, 0x0470, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			// Entry 100 - 13F
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0498,
			0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			// Entry 140 - 17F
			0x0498, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			// Entry 180 - 1BF
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			// Entry 1C0 - 1FF
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04d4, 0x04d4, 0x04d4, 0x04d4,
			0x04d4, 0x04d4, 0x04e1, 0x04e1, 0x04e1, 0x04e1, 0x04e1, 0x04e1,
			0x04e1, 0x04e1, 0x04e1, 0x04e1, 0x04f1, 0x0501, 0x050f, 0x051f,
			// Entry 200 - 23F
			0x051f, 0x051f, 0x051f, 0x051f, 0x051f, 0x051f, 0x051f, 0x051f,
			0x051f, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d,
			0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d,
			0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d,
			0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x053a,
			0x053a, 0x053a, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e,
			0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e,
			0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e,
			// Entry 240 - 27F
			0x054e, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a,
			0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a,
			0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a,
			0x055a, 0x055a, 0x056c, 0x057e, 0x0599,
		},
	},
	{ // se-FI
		"vilgesruoššagiellabengalagiellafižigiellaarmenagiellakazakhgiellakamboža" +
			"giellanepalagiellapanjabagiellathaigiellavietnamagiellaačehgiellakom" +
			"oragiellastandárda arábagiellanuortariikkalaš duiskkagiellašveicalaš" +
			" duiskkagiellaaustrálialaš eaŋgalsgiellakanádalaš eaŋgalsgiellabriht" +
			"talaš eaŋgalsgiellaamerihkálaš eaŋgalsgiellalatiinna-amerihkalaš spá" +
			"nskkagiellaespánjalaš spánskkagiellameksikolaš spánskkagiellakanádal" +
			"aš fránskkagiellašveicalaš fránskkagiellabelgialaš hollánddagiellabr" +
			"asilialaš portugálagiellaportugálalaš portugálagiellamoldávialaš rom" +
			"ániagiellaálkes kiinnágiella",
		[]uint16{ // 604 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x0038, 0x0038,
			// Entry 40 - 7F
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e,
			0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x006b, 0x006b, 0x006b,
			// Entry 80 - BF
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083,
			0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry C0 - FF
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 100 - 13F
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 140 - 17F
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 180 - 1BF
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 1C0 - 1FF
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 200 - 23F
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			// Entry 240 - 27F
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x00b1, 0x00cf, 0x00e8, 0x0105, 0x011f, 0x0139,
			0x0155, 0x017a, 0x0196, 0x01b1, 0x01cc, 0x01e7, 0x0202, 0x021f,
			0x023e, 0x025a, 0x025a, 0x026e,
		},
	},
	{ // seh
		"akanamáricoárabebielo-russobúlgarobengalitchecoalemãogregoinglêsespanhol" +
			"persafrancêshausahindihúngaroindonésioiboitalianojaponêsjavanêscmerc" +
			"oreanomalaiobirmanêsnepalêsholandêspanjabipolonêsportuguêsromenoruss" +
			"okinyarwandasomalisuecotâmiltailandêsturcoucranianourduvietnamitaior" +
			"ubáchinêszulusena",
		[]uint16{ // 497 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000c, 0x000c,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x001d, 0x0025,
			0x0025, 0x0025, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0039, 0x0039, 0x0039, 0x0039, 0x003e, 0x0045, 0x0045, 0x004d,
			0x004d, 0x004d, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005f,
			0x005f, 0x0064, 0x0064, 0x0064, 0x0064, 0x006c, 0x006c, 0x006c,
			// Entry 40 - 7F
			0x006c, 0x0076, 0x0076, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079,
			0x0081, 0x0081, 0x0089, 0x0091, 0x0091, 0x0091, 0x0091, 0x0091,
			0x0091, 0x0091, 0x0095, 0x0095, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x00a2, 0x00a2, 0x00ab, 0x00ab, 0x00ab,
			0x00b3, 0x00b3, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00c3, 0x00c3, 0x00cb,
			// Entry 80 - BF
			0x00cb, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00db, 0x00e0, 0x00eb,
			0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb,
			0x00eb, 0x00eb, 0x00f1, 0x00f1, 0x00f1, 0x00f1, 0x00f1, 0x00f1,
			0x00f6, 0x00f6, 0x00fc, 0x00fc, 0x00fc, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x0114,
			0x0118, 0x0118, 0x0118, 0x0122, 0x0122, 0x0122, 0x0122, 0x0122,
			0x0122, 0x0129, 0x0129, 0x0130, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry C0 - FF
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 100 - 13F
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 140 - 17F
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 180 - 1BF
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 1C0 - 1FF
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0138,
		},
	},
	{ // ses
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senniKoree" +
			" senniMaleezi senniBurme senniNeepal senniHolandee senniPunjaabi sen" +
			"niiPolonee senniPortugee senniRumaani senniRuusi senniRwanda senniSo" +
			"maali senniSuweede senniTamil senniTaailandu senniTurku senniUkreen " +
			"senniUrdu senniVietnaam senniYorbance senniSinuwa senni, MandareŋZul" +
			"u senniKoyraboro senni",
		[]uint16{ // 500 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0111, 0x0111, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x0129, 0x0129, 0x0134, 0x0134, 0x0134,
			0x0140, 0x0140, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
			0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x015d, 0x015d, 0x016a,
			// Entry 80 - BF
			0x016a, 0x0178, 0x0178, 0x0178, 0x0178, 0x0185, 0x0190, 0x019c,
			0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c,
			0x019c, 0x019c, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9,
			0x01b6, 0x01b6, 0x01c1, 0x01c1, 0x01c1, 0x01d0, 0x01d0, 0x01d0,
			0x01d0, 0x01d0, 0x01db, 0x01db, 0x01db, 0x01db, 0x01db, 0x01e7,
			0x01f1, 0x01f1, 0x01f1, 0x01ff, 0x01ff, 0x01ff, 0x01ff, 0x01ff,
			0x01ff, 0x020d, 0x020d, 0x0224, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry C0 - FF
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 100 - 13F
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 140 - 17F
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 180 - 1BF
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 1C0 - 1FF
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x023d,
		},
	},
	{ // sg
		"AkâanAmarîkiArâboBielörûsiBulugäriBengäliTyêkiZâmaniGerêkiAnglëeEspanyöl" +
			"FarsîFarânziHaüsäHîndiHongruäaEnndonezïiÏgböÊnndeZaponëeZavanëeKmêre" +
			"KoreyëenMalëeMiamära, BirimäniNepalëeHolandëePenzäbïPolonëePortugëe," +
			" PûraRumëenRûsiRuandäaSängöSomalïiSueduäaTämûliThâiTûrûkuUkrêniÛrduV" +
			"ietnämYorubaShinuäaZûlu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x001f, 0x0028,
			0x0028, 0x0028, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030,
			0x0030, 0x0030, 0x0030, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x003d, 0x003d, 0x003d, 0x003d, 0x0044, 0x004b, 0x004b, 0x0054,
			0x0054, 0x0054, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0069,
			0x0069, 0x006f, 0x006f, 0x006f, 0x006f, 0x0078, 0x0078, 0x0078,
			// Entry 40 - 7F
			0x0078, 0x0083, 0x0083, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x008f, 0x008f, 0x0097, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f,
			0x009f, 0x009f, 0x00a5, 0x00a5, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00ae, 0x00b4, 0x00b4, 0x00c7, 0x00c7, 0x00c7,
			0x00cf, 0x00cf, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00e1, 0x00e1, 0x00e9,
			// Entry 80 - BF
			0x00e9, 0x00f9, 0x00f9, 0x00f9, 0x00f9, 0x0100, 0x0105, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x0114, 0x0114, 0x0114, 0x0114,
			0x0114, 0x0114, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x0124, 0x0124, 0x012c, 0x012c, 0x012c, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0140,
			0x0145, 0x0145, 0x0145, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x0153, 0x0153, 0x015b, 0x0160,
		},
	},
	{ // shi
		"ⵜⴰⴽⴰⵏⵜⵜⴰⵎⵀⴰⵔⵉⵜⵜⴰⵄⵔⴰⴱⵜⵜⴰⴱⵉⵍⴰⵔⵓⵙⵜⵜⴰⴱⵍⵖⴰⵔⵉⵜⵜⴰⴱⵏⵖⴰⵍⵉⵜⵜⴰⵜⵛⵉⴽⵉⵜⵜⴰⵍⵉⵎⴰⵏⵜⵜⴰⴳⵔⵉⴳⵉ" +
			"ⵜⵜⴰⵏⴳⵍⵉⵣⵜⵜⴰⵙⴱⵏⵢⵓⵍⵉⵜⵜⴰⴼⵓⵔⵙⵉⵜⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜⵜⴰⵀⴰⵡⵙⴰⵜⵜⴰⵀⵉⵏⴷⵉⵜⵜⴰⵀⵏⵖⴰⵔⵉⵜⵜⴰⵏⴷ" +
			"ⵓⵏⵉⵙⵉⵜⵜⵉⴳⴱⵓⵜⵜⴰⵟⴰⵍⵢⴰⵏⵜⵜⴰⵊⴰⴱⴱⵓⵏⵉⵜⵜⴰⵊⴰⴼⴰⵏⵉⵜⵜⴰⵅⵎⵉⵔⵜⵜⴰⴽⵓⵔⵉⵜⵜⴰⵎⴰⵍⴰⵡⵉⵜⵜⴰⴱ" +
			"ⵉⵔⵎⴰⵏⵉⵜⵜⴰⵏⵉⴱⴰⵍⵉⵜⵜⴰⵀⵓⵍⴰⵏⴷⵉⵜⵜⴰⴱⵏⵊⴰⴱⵉⵜⵜⴰⴱⵓⵍⵓⵏⵉⵜⵜⴰⴱⵕⵟⵇⵉⵣⵜⵜⴰⵔⵓⵎⴰⵏⵉⵜⵜⴰⵔⵓ" +
			"ⵙⵉⵜⵜⴰⵔⵓⵡⴰⵏⴷⵉⵜⵜⴰⵙⵓⵎⴰⵍⵉⵜⵜⴰⵙⵡⵉⴷⵉⵜⵜⴰⵜⴰⵎⵉⵍⵜⵜⴰⵜⴰⵢⵍⴰⵏⴷⵉⵜⵜⴰⵜⵓⵔⴽⵉⵜⵜⵓⴽⵔⴰⵏⵉⵜⵜ" +
			"ⵓⵔⴷⵓⵜⵜⴰⴼⵉⵜⵏⴰⵎⵉⵜⵜⴰⵢⵔⵓⴱⴰⵜⵜⴰⵛⵉⵏⵡⵉⵜⵜⴰⵣⵓⵍⵓⵜⵜⴰⵎⴰⵣⵉⵖⵜ",
		[]uint16{ // 503 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x002a, 0x002a,
			0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x005d, 0x0078,
			0x0078, 0x0078, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00db, 0x00f3, 0x00f3, 0x0111,
			0x0111, 0x0111, 0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0147,
			0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x015f,
			0x015f, 0x0177, 0x0177, 0x0177, 0x0177, 0x0192, 0x0192, 0x0192,
			// Entry 40 - 7F
			0x0192, 0x01b0, 0x01b0, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2,
			0x01dd, 0x01dd, 0x01fb, 0x0216, 0x0216, 0x0216, 0x0216, 0x0216,
			0x0216, 0x0216, 0x022b, 0x022b, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x025b, 0x025b, 0x0279, 0x0279, 0x0279,
			0x0294, 0x0294, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2,
			0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02cd, 0x02cd, 0x02e8,
			// Entry 80 - BF
			0x02e8, 0x0303, 0x0303, 0x0303, 0x0303, 0x031e, 0x0333, 0x0351,
			0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351,
			0x0351, 0x0351, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c,
			0x0384, 0x0384, 0x039c, 0x039c, 0x039c, 0x03bd, 0x03bd, 0x03bd,
			0x03bd, 0x03bd, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03ed,
			0x03ff, 0x03ff, 0x03ff, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x0435, 0x0435, 0x044d, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry C0 - FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 100 - 13F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 140 - 17F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 180 - 1BF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 1C0 - 1FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x047a,
		},
	},
	{ // shi-Latn
		"takanttamharittaɛrabttabilarusttablɣarittabnɣalittatcikittalimanttagrigi" +
			"ttanglizttasbnyulittafursittafransisttahawsattahindittahnɣarittandun" +
			"isittigbuttaṭalyanttajabbunittajavanittaxmirttakurittamalawittabirma" +
			"nittanibalittahulandittabnjabittabulunittabṛṭqizttarumanittarusittar" +
			"uwandittasumalittaswidittatamilttataylandittaturkittukranitturduttaf" +
			"itnamittayrubattacinwittazuluttamazight",
		[]uint16{ // 503 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x004c, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0078,
			0x0078, 0x0080, 0x0080, 0x0080, 0x0080, 0x008a, 0x008a, 0x008a,
			// Entry 40 - 7F
			0x008a, 0x0094, 0x0094, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x00a5, 0x00a5, 0x00af, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8,
			0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00cf, 0x00cf, 0x00d9, 0x00d9, 0x00d9,
			0x00e2, 0x00e2, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
			0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00f5, 0x00f5, 0x00fe,
			// Entry 80 - BF
			0x00fe, 0x010b, 0x010b, 0x010b, 0x010b, 0x0114, 0x011b, 0x0125,
			0x0125, 0x0125, 0x0125, 0x0125, 0x0125, 0x0125, 0x0125, 0x0125,
			0x0125, 0x0125, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x0136, 0x0136, 0x013e, 0x013e, 0x013e, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0151, 0x0151, 0x0151, 0x0151, 0x0151, 0x0159,
			0x015f, 0x015f, 0x015f, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0171, 0x0171, 0x0179, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry C0 - FF
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 100 - 13F
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 140 - 17F
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 180 - 1BF
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 1C0 - 1FF
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0189,
		},
	},
	{ // si
		siLangStr,
		siLangIdx,
	},
	{ // sk
		skLangStr,
		skLangIdx,
	},
	{ // sl
		slLangStr,
		slLangIdx,
	},
	{ // smn
		"arabiakielâvielgisruošâkielâbulgariakielâtšeekikielâkirkkoslaavitanskaki" +
			"elâsaksakielâkreikakielâengâlâskielâespanjakielâeestikielâsuomâkielâ" +
			"ranskakielâiirikielâhepreakielâkroatiakielâuŋgarkielâarmeniakielâisl" +
			"andkielâitaliakielâjaapaankielâkurdikielâkomikielâläättinkielâlatvia" +
			"kielâmaorikielâmakedoniakielâmongoliakielâneepaalkielâhollandkielâtá" +
			"rukielâ nynorsktárukielâpuolakielâportugalkielâromaniakielâruošâkiel" +
			"âsanskritkielâtavesämikielâsloveniakielâserbiakielâruotâkielâturkki" +
			"kielâukrainakielâvietnamkielâkiinakielâainukielâmarikielâtoovláškrei" +
			"kakielâmokšâkielâviestârmarikielâtoovláštárukielâroomaankielâmaadâsä" +
			"mikielâjuulevsämikielâanarâškielânuorttâlâškielâudmurtkielâvepsäkiel" +
			"âkantonkiinakielâNuorttâriijkâ saksakielâAustralia engâlâskielâKana" +
			"da engâlâskielâoovtâkiärdánis kiinakielâärbivuáválâš kiinakielâ",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x0020, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x003b, 0x0047, 0x0047, 0x0047, 0x0053,
			0x005e, 0x005e, 0x005e, 0x005e, 0x006a, 0x0079, 0x0079, 0x0086,
			0x0091, 0x0091, 0x0091, 0x0091, 0x009d, 0x009d, 0x009d, 0x00a9,
			0x00a9, 0x00b3, 0x00b3, 0x00b3, 0x00b3, 0x00b3, 0x00b3, 0x00b3,
			0x00bf, 0x00bf, 0x00bf, 0x00cc, 0x00cc, 0x00d8, 0x00e5, 0x00e5,
			// Entry 40 - 7F
			0x00e5, 0x00e5, 0x00e5, 0x00e5, 0x00e5, 0x00e5, 0x00e5, 0x00f1,
			0x00fd, 0x00fd, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
			0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x0115,
			0x011f, 0x011f, 0x011f, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x013a, 0x013a, 0x013a, 0x0145, 0x0154,
			0x0154, 0x0162, 0x0162, 0x0162, 0x0162, 0x0162, 0x0162, 0x0162,
			0x016f, 0x016f, 0x017c, 0x018f, 0x019a, 0x019a, 0x019a, 0x019a,
			0x019a, 0x019a, 0x019a, 0x019a, 0x019a, 0x019a, 0x019a, 0x01a5,
			// Entry 80 - BF
			0x01a5, 0x01b3, 0x01b3, 0x01b3, 0x01b3, 0x01c0, 0x01cd, 0x01cd,
			0x01db, 0x01db, 0x01db, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01f8,
			0x01f8, 0x01f8, 0x01f8, 0x01f8, 0x0204, 0x0204, 0x0204, 0x0204,
			0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210,
			0x0210, 0x0210, 0x021c, 0x021c, 0x021c, 0x021c, 0x021c, 0x0229,
			0x0229, 0x0229, 0x0229, 0x0236, 0x0236, 0x0236, 0x0236, 0x0236,
			0x0236, 0x0236, 0x0236, 0x0241, 0x0241, 0x0241, 0x0241, 0x0241,
			0x0241, 0x0241, 0x0241, 0x0241, 0x024b, 0x024b, 0x024b, 0x024b,
			// Entry C0 - FF
			0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
			0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
			0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
			0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
			0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
			0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
			0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
			0x024b, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			// Entry 100 - 13F
			0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255, 0x0255,
			0x0255, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			// Entry 140 - 17F
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			// Entry 180 - 1BF
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a,
			0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x026a, 0x0277, 0x0277,
			0x0277, 0x0277, 0x0277, 0x0277, 0x0277, 0x0277, 0x0277, 0x0277,
			0x0277, 0x0277, 0x0277, 0x0277, 0x0289, 0x0289, 0x0289, 0x0289,
			0x0289, 0x0289, 0x0289, 0x0289, 0x0289, 0x0289, 0x0289, 0x0289,
			0x0289, 0x0289, 0x0289, 0x0289, 0x0289, 0x0289, 0x0289, 0x0289,
			0x0289, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			// Entry 1C0 - 1FF
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x02aa, 0x02aa, 0x02aa,
			0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa,
			0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa,
			0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02aa,
			0x02aa, 0x02aa, 0x02aa, 0x02aa, 0x02bb, 0x02cc, 0x02da, 0x02ed,
			// Entry 200 - 23F
			0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed,
			0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed,
			0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed,
			0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed,
			0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x02f9,
			0x02f9, 0x02f9, 0x02f9, 0x02f9, 0x02f9, 0x0305, 0x0305, 0x0305,
			0x0305, 0x0305, 0x0305, 0x0305, 0x0305, 0x0305, 0x0305, 0x0305,
			0x0305, 0x0305, 0x0305, 0x0305, 0x0305, 0x0305, 0x0305, 0x0305,
			// Entry 240 - 27F
			0x0305, 0x0316, 0x0316, 0x0316, 0x0316, 0x0316, 0x0316, 0x0316,
			0x0316, 0x0316, 0x0316, 0x0331, 0x0331, 0x034a, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x037d, 0x039a,
		},
	},
	{ // sn
		"chiAkanichiAmaricchiArabuchiBelarusichiBulgarianchiBengalichiCzechchiJer" +
			"imanichiGreekChirunguchiSpanishchiPeshiyachiFurenchichiHausachiHindi" +
			"chiHungarichiIndonesiachiIgbochiTarianachiJapanichiJavachiKhemachiKo" +
			"riachiMalaychiBurmachiNepalichiDutchchiPunjabichiPolishchiPutukezich" +
			"iRomanianchiRashiyachiRwandachiShonachiSomalichiSwedishchiTamilchiTh" +
			"aichiTurkishchiUkreniachiUrduchiVietnamchiYorubachiChinesechiZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a,
			0x003a, 0x003a, 0x003a, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0055, 0x005d, 0x005d, 0x0067,
			0x0067, 0x0067, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x007c,
			0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x0084,
			0x0084, 0x008c, 0x008c, 0x008c, 0x008c, 0x0096, 0x0096, 0x0096,
			// Entry 40 - 7F
			0x0096, 0x00a2, 0x00a2, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00b3, 0x00b3, 0x00bc, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3,
			0x00c3, 0x00c3, 0x00cb, 0x00cb, 0x00d3, 0x00d3, 0x00d3, 0x00d3,
			0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3,
			0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3,
			0x00d3, 0x00d3, 0x00d3, 0x00db, 0x00db, 0x00e3, 0x00e3, 0x00e3,
			0x00ec, 0x00ec, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x0107,
			// Entry 80 - BF
			0x0107, 0x0112, 0x0112, 0x0112, 0x0112, 0x011d, 0x0127, 0x0130,
			0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130,
			0x0130, 0x0138, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
			0x014b, 0x014b, 0x0153, 0x0153, 0x0153, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f,
			0x017f, 0x0188, 0x0188, 0x0192, 0x0199,
		},
	},
	{ // so
		"AkanAxmaariCarabiBeleruusiyaanBulgeeriyaanBangaaliJeegJarmalGiriikIngiri" +
			"isiIsbaanishFaarisiFaransiisFiriisiyan GalbeedHawsaHindiHangariyaanI" +
			"ndunuusiyaanIgboTalyaaniJabbaaniisJafaaniisKamboodhianKuuriyaanMalaa" +
			"yBurmeseNebaaliHolandaysBunjaabiBoolishBoortaqiisRomankaRuushRwandaS" +
			"oomaaliSwiidhisTamiilTaaylandaysTurkishYukreeniyaanUrduuFiitnaamaysY" +
			"oruubaJayniisZuulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x001e, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x003c, 0x003c, 0x003c, 0x003c, 0x0042, 0x004b, 0x004b, 0x0054,
			0x0054, 0x0054, 0x005b, 0x005b, 0x005b, 0x005b, 0x005b, 0x0064,
			0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x007b,
			0x007b, 0x0080, 0x0080, 0x0080, 0x0080, 0x008b, 0x008b, 0x008b,
			// Entry 40 - 7F
			0x008b, 0x0098, 0x0098, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x00a4, 0x00a4, 0x00ae, 0x00b7, 0x00b7, 0x00b7, 0x00b7, 0x00b7,
			0x00b7, 0x00b7, 0x00c2, 0x00c2, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00d1, 0x00d1, 0x00d8, 0x00d8, 0x00d8,
			0x00df, 0x00df, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00f0, 0x00f0, 0x00f7,
			// Entry 80 - BF
			0x00f7, 0x0101, 0x0101, 0x0101, 0x0101, 0x0108, 0x010d, 0x0113,
			0x0113, 0x0113, 0x0113, 0x0113, 0x0113, 0x0113, 0x0113, 0x0113,
			0x0113, 0x0113, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x0123, 0x0123, 0x0129, 0x0129, 0x0129, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x013b, 0x013b, 0x013b, 0x013b, 0x013b, 0x0147,
			0x014c, 0x014c, 0x014c, 0x0157, 0x0157, 0x0157, 0x0157, 0x0157,
			0x0157, 0x015e, 0x015e, 0x0165, 0x016a,
		},
	},
	{ // sq
		sqLangStr,
		sqLangIdx,
	},
	{ // sr
		srLangStr,
		srLangIdx,
	},
	{ // sr-Latn
		srLatnLangStr,
		srLatnLangIdx,
	},
	{ // sv
		svLangStr,
		svLangIdx,
	},
	{ // sv-FI
		"kirgiziska",
		[]uint16{ // 91 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x000a,
		},
	},
	{ // sw
		swLangStr,
		swLangIdx,
	},
	{ // sw-CD
		"KiakanKibanglaKicheckiKingerezaKiswahili ya Kongo",
		[]uint16{ // 523 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry 40 - 7F
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry 80 - BF
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry C0 - FF
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry 100 - 13F
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry 140 - 17F
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry 180 - 1BF
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry 1C0 - 1FF
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			// Entry 200 - 23F
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x0031,
		},
	},
	{ // ta
		taLangStr,
		taLangIdx,
	},
	{ // te
		teLangStr,
		teLangIdx,
	},
	{ // teo
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKiteso",
		[]uint16{ // 529 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 180 - 1BF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 1C0 - 1FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 200 - 23F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x016f,
		},
	},
	{ // th
		thLangStr,
		thLangIdx,
	},
	{ // ti
		"አፍሪቃንሰኛትዊአምሐረኛዓረበኛአዜርባይጃንኛቤላራሻኛቡልጋሪኛበንጋሊኛብሬቶንቦስኒያንካታላንቼክኛወልሽዴኒሽጀርመንግሪከኛእ" +
			"ንግሊዝኛኤስፐራንቶስፓኒሽኤስቶኒአንባስክኛፐርሲያኛፊኒሽፋሮኛፈረንሳይኛፍሪሰኛአይሪሽእስኮትስ ጌልክኛጋለቪኛጓራ" +
			"ኒጉጃራቲኛዕብራስጥሕንደኛክሮሽያንኛሀንጋሪኛኢንቴር ቋንቋእንዶኑሲኛአይስላንደኛጣሊያንኛጃፓንኛጃቫንኛጊዮርጊያኛ" +
			"ካማደኛኮሪያኛኩርድሽኪሩጋዚላቲንኛሊቱአኒየንላቲቪያንማክዶኒኛማላያላምኛማራቲኛማላይኛማልቲስኛኔፖሊኛደችኖርዌይኛ" +
			" (ናይ ኝኖርስክ)ኖርዌጂያንኦኪታንኛኦሪያፑንጃቢኛፖሊሽፓሽቶፖርቱጋሊኛሮማኒያንራሽኛስንሃልኛስሎቨክኛስቁቪኛአልቤኒ" +
			"ኛሰርቢኛሰሴቶሱዳንኛስዊድንኛሰዋሂሊኛታሚልኛተሉጉኛታይኛትግርኛናይ ቱርኪ ሰብዓይ (ቱርካዊ)ቱርከኛዩክረኒኛኡር" +
			"ዱኛኡዝበክኛቪትናምኛዞሳኛዪዲሽዙሉኛታጋሎገኛክሊንግኦንኛፖርቱጋልኛ (ናይ ብራዚል)ፖርቱጋልኛ (ናይ ፖርቱጋል)" +
			"ሰርቦ- ክሮዊታን",
		[]uint16{ // 603 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0015, 0x001b, 0x002a, 0x002a,
			0x0036, 0x0036, 0x0036, 0x0036, 0x004e, 0x004e, 0x005d, 0x006c,
			0x006c, 0x006c, 0x007b, 0x007b, 0x0087, 0x0096, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00ab, 0x00ab, 0x00ab, 0x00b4, 0x00bd,
			0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00d5, 0x00e7, 0x00f9, 0x0105,
			0x0117, 0x0123, 0x0132, 0x0132, 0x013b, 0x013b, 0x0144, 0x0156,
			0x0162, 0x016e, 0x018a, 0x0196, 0x019f, 0x01ae, 0x01ae, 0x01ae,
			0x01bd, 0x01c9, 0x01c9, 0x01db, 0x01db, 0x01ea, 0x01ea, 0x01ea,
			// Entry 40 - 7F
			0x0200, 0x0212, 0x0212, 0x0212, 0x0212, 0x0212, 0x0212, 0x0227,
			0x0236, 0x0236, 0x0242, 0x024e, 0x0260, 0x0260, 0x0260, 0x0260,
			0x0260, 0x0260, 0x0260, 0x026c, 0x0278, 0x0278, 0x0278, 0x0284,
			0x0284, 0x0284, 0x0290, 0x029c, 0x029c, 0x029c, 0x029c, 0x029c,
			0x029c, 0x02ae, 0x02ae, 0x02bd, 0x02bd, 0x02bd, 0x02bd, 0x02cc,
			0x02de, 0x02de, 0x02ea, 0x02f6, 0x0305, 0x0305, 0x0305, 0x0305,
			0x0311, 0x0311, 0x0317, 0x033f, 0x0351, 0x0351, 0x0351, 0x0351,
			0x0360, 0x0360, 0x0360, 0x0369, 0x0369, 0x0378, 0x0378, 0x0381,
			// Entry 80 - BF
			0x038a, 0x039c, 0x039c, 0x039c, 0x039c, 0x03ab, 0x03b4, 0x03b4,
			0x03b4, 0x03b4, 0x03b4, 0x03b4, 0x03b4, 0x03c3, 0x03d2, 0x03de,
			0x03de, 0x03de, 0x03de, 0x03ed, 0x03f9, 0x03f9, 0x0402, 0x040e,
			0x041d, 0x042c, 0x0438, 0x0444, 0x0444, 0x044d, 0x0459, 0x0485,
			0x0485, 0x0485, 0x0491, 0x0491, 0x0491, 0x0491, 0x0491, 0x04a0,
			0x04ac, 0x04bb, 0x04bb, 0x04ca, 0x04ca, 0x04ca, 0x04ca, 0x04d3,
			0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			// Entry C0 - FF
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			// Entry 100 - 13F
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 140 - 17F
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 180 - 1BF
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 1C0 - 1FF
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 200 - 23F
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			// Entry 240 - 27F
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0531,
			0x055c, 0x055c, 0x0576,
		},
	},
	{ // to
		"lea fakaʻafālalea fakaʻapakasialea fakaʻavesitanilea fakaʻafilikanalea f" +
			"akaʻakanilea fakaʻamelikilea fakaʻalakonilea fakaʻalepealea fakaʻasa" +
			"mialea fakaʻavalikilea fakaʻaimalalea fakaʻasapaisanilea fakapasikil" +
			"ilea fakapelalusilea fakapulukalialea fakapisilamalea fakapamipalale" +
			"a fakapengikalilea fakatipetilea fakapeletonilea fakaposinialea faka" +
			"katalanilea fakaseselea fakakamololea fakakōsikalea fakakelīlea faka" +
			"sekilea fakasilavia-fakasiasilea fakasuvasalea fakauēlesilea fakaten" +
			"imaʻakelea fakasiamanelea fakativehilea fakaputenilea fakaʻeuelea fa" +
			"kakalisilea fakapālangilea fakaʻesipulanitolea fakasipēnisilea fakaʻ" +
			"esitōnialea fakapāsikilea fakapēsialea fakafulālea fakafinilanilea f" +
			"akafisilea fakafaloelea fakafalanisēlea fakafilisia-hihifolea fakaʻa" +
			"elanilea fakakaelikilea fakakalisialea fakakualanilea fakakutalatile" +
			"a fakamangikīlea fakahausalea fakahepelūlea fakahinitīlea fakahili-m" +
			"otulea fakakuloisialea fakahaitilea fakahungakalialea fakaʻāmenialea" +
			" fakahelelolea fakavahaʻalealea fakaʻinitōnesialea fakavahaʻalingikē" +
			"lea fakaʻikipōlea fakasisiuani-īlea fakaʻinupiakilea fakaʻitolea fak" +
			"aʻaisilanilea fakaʻītalilea fakaʻinuketitutilea fakasiapanilea fakas" +
			"avalea fakaseōsialea fakakongikōlea fakakikuiulea fakakuaniamalea fa" +
			"kakasakilea fakakalaʻalisutilea fakakamipōtialea fakakanatalea fakak" +
			"ōlealea fakakanulilea fakakāsimilalea fakakulitīlea fakakomilea fak" +
			"akoniualilea fakakīsisilea fakalatinalea fakalakisimipekilea fakakan" +
			"italea fakalimipūlikilea lingikalalea fakalaulea fakalituanialea fak" +
			"alupa-katangalea fakalativialea fakamalakasilea fakamāsololea fakama" +
			"ulilea fakamasitōnialea fakaʻinitia-malāialamilea fakamongokōlialea " +
			"fakamalatilea fakamaleilea fakamolotalea fakapemalea fakanaululea fa" +
			"kanetepele-tokelaulea fakanepalilea fakanetongikālea fakahōlanilea f" +
			"akanoauē-ninosikilea fakanouaē-pokimalilea fakanetepele-tongalea fak" +
			"anavaholea fakanianisalea fakaʻokitanelea fakaʻosipiuālea fakaʻolomo" +
			"lea fakaʻinitia-ʻolāealea fakaʻosetikilea fakapūnusapilea fakapālile" +
			"a fakapōlanilea fakapasitōlea fakapotukalilea fakakuetisalea fakalai" +
			"to-lomēnialea fakaluanitilea fakalōmenialea fakalūsialea fakakiniāua" +
			"nitalea fakasanisukulitilea fakasaletīnialea fakasīnitilea fakasami-" +
			"tokelaulea fakasangikōlea fakasingihalalea fakasolāvakilea fakasolov" +
			"enialea fakahaʻamoalea fakasionalea fakasomalilea fakaʻalapēnialea f" +
			"akasēpialea fakasuasilanilea fakasoto-tongalea fakasunitālea fakasuē" +
			"tenilea fakasuahililea fakatamililea fakaʻinitia-telukulea fakatāsik" +
			"ilea fakatailanilea fakatikilinialea fakatēkimenilea suanalea fakato" +
			"ngalea fakatoakelea fakatisongalea fakatatalelea fakatahitilea fakaʻ" +
			"uikūlilea fakaʻūkalaʻinelea fakaʻūtūlea fakaʻusipekilea fakavenitāle" +
			"a fakavietinamilea fakavolapikilea fakaʻualonialea fakaʻuolofolea fa" +
			"katōsalea fakaītisilea fakaʻiōlupalea fakasuangilea fakasiainalea fa" +
			"kasululea fakaʻatisēlea fakaʻakolilea fakaʻatangimēlea fakaʻatikēlea" +
			" fakaʻalepea-tunīsialea fakaʻafilihililea fakaʻakihemilea fakaʻainul" +
			"ea fakaʻakatialea fakaʻalapamalea fakaʻaleutilea fakaʻalapēnia-kekil" +
			"ea fakaʻalitai-tongalea fakapālangi-motuʻalea fakaʻangikalea fakaʻal" +
			"āmitilea fakamapuselea fakaʻalaonalea fakaʻalapaholea fakaʻalepea-ʻ" +
			"aisilialea fakaʻalauakilea fakaʻalepea-molokolea fakaʻalepea-ʻisipit" +
			"elea fakaʻasulea fakaʻilonga-ʻamelikalea fakaʻasitūlialea fakakotava" +
			"lea fakaʻauatilea fakaʻasapaisani-tongalea fakapalusilea fakapalilea" +
			" fakapavālialea fakapasaʻalea fakapamunilea fakatōpe-pētekilea fakak" +
			"omalalea fakapesalea fakapēmipalea fakapetavilea fakapenalea fakapaf" +
			"utilea fakapatakalea fakaposipulilea fakapikolilea fakapinilea fakap" +
			"anisalilea fakakomelea fakasikesikālea fakapisinupilialea fakapakiti" +
			"ālilea fakapalailea fakapalahuilea fakapōtolea fakaʻakōselea fakapu" +
			"liatilea fakapukisilea fakapululea fakapilinilea fakametūmipalea fak" +
			"akatolea fakakalipalea fakakaiukalea fakaʻatisamilea fakasepuanolea " +
			"fakakikalea fakasīpisalea fakasakatāilea fakatūkelea fakamalīlea fak" +
			"asinuki-takotelea fakasokitaulea fakasipeuianilea fakaselokīlea faka" +
			"seienelea fakakūtisi-solanilea fakakopitikalea fakakapisenolea fakat" +
			"oake-kilimealea fakakasiupialea fakatakotalea fakatalakuālea fakatai" +
			"talea fakatelaualelea fakasilavelea fakatōkelipilea fakatingikālea f" +
			"akatisāmalea fakatokililea fakasōpia-hifolea fakatusuni-lolotolea fa" +
			"katualalea fakahōlani-lotolotolea fakaiola-fonīlea fakatiulalea faka" +
			"tasakalea fakaʻemipūlea fakaʻefikilea fakaʻemilialea fakaʻisipitemuʻ" +
			"alea fakaʻekaiukilea fakaʻelamitelea fakapālangi-lotolotolea fakaiūp" +
			"iki-lolotolea fakaʻeuōnitolea fakaʻekisitematulalea fakafangilea fak" +
			"afilipainilea fakafinilani-tōnetalelea fakafōngilea fakafalanisē-kas" +
			"unilea fakafalanisē-lotolotolea fakafalanisē-motuʻalea fakaʻāpitanol" +
			"ea fakafilisia-tokelaulea fakafilisia-hahakelea fakafulilānilea faka" +
			"kālea fakakakausilea fakasiaina-kanilea fakakaiolea fakakapaialea fa" +
			"kateli-soloasitelialea fakasiʻisilea fakakilipasilea fakakilakilea f" +
			"akasiamane-hake-lotolotolea fakasiamane-hake-motuʻalea fakakonikanī-" +
			"koanilea fakakonitīlea fakakolonitalolea fakakotikalea fakakēpolea f" +
			"akakalisimuʻalea fakasiamane-suisilanilea fakaʻuaiūlea fakafalefalel" +
			"ea fakakusīlea fakaʻuīsinilea fakahaitalea fakasiaina-hakalea fakaha" +
			"uaiʻilea fakahihitī-fisilea fakahilikainonilea fakahititelea fakamōn" +
			"gilea fakasōpia-hakelea fakasiaina-siangilea fakahupalea fakaʻipanil" +
			"ea fakaʻipipiolea fakaʻilokolea fakaʻingusilea fakaʻingilianilea fak" +
			"apālangi-samaikalea fakalosipanilea fakanikōmipalea fakamasamelea fa" +
			"kaʻiuteo-pēsialea fakaʻiuteo-ʻalepealea fakaʻiutilanilea fakakala-ka" +
			"lipakilea fakakapilelea fakakasinilea fakasisūlea fakakamipalea faka" +
			"kavilea fakakapālitialea fakakanēmipulea fakatiapilea fakamakōnitele" +
			"a fakakapuvelitianulea fakakeniangilea fakakololea fakakaingangilea " +
			"fakakāsilea fakakōtanilea fakakoila-sīnilea fakakoualilea fakakilima" +
			"nisikīlea fakakakolea fakakalenisinilea fakakimipūnitulea fakakomi-p" +
			"elemiakilea fakakonikanīlea fakakosilaelea fakakepelelea fakakalate-" +
			"palakililea fakakiliolea fakakinaraiālea fakakalelialea fakakulukile" +
			"a fakasiamipalalea fakapafialea fakakolongialea fakakumikilea fakaku" +
			"tenailea fakalatinolea fakalangilea fakalānitalea fakalamipālea faka" +
			"lesikialea fakakavakava-foʻoulea fakalikulialea fakalivonialea fakal" +
			"akotalea fakalomipātilea fakamongikōlea fakalosilea fakalatakalelea " +
			"fakalupa-lulualea fakaluisenolea fakalunitālea fakaluolea fakamisole" +
			"a fakaluīalea fakasiaina-faʻutohilea fakalasulea fakamatulalea fakam" +
			"afalea fakamakahilea fakamaitililea fakamakasalilea fakamanitīngikol" +
			"ea fakamasailea fakamapalea fakamokisiālea fakamanetalilea fakamenet" +
			"īlea fakamelulea fakamolisienilea fakaʻaelani-lotolotolea fakamakūa" +
			"-meʻetolea fakametalea fakamikemakilea fakaminangikapaulea fakamanis" +
			"ūlea fakamanipulilea fakamohaukilea fakamosilea fakamali-hihifolea " +
			"fakamunitangilea tuifiolea fakakilekilea fakamilanitēsilea fakamaliw" +
			"alilea fakamenitauailea fakamienelea fakaʻelisialea fakamasanitelani" +
			"lea fakasiaina-mininanilea fakanapoletanolea fakanamalea fakasiamane" +
			"-hifolea fakaneualilea fakaniasilea fakaniuēlea fakaʻaonasalea fakak" +
			"uasiolea fakangiemipōnilea fakanokailea fakanoauē-motuʻalea fakanovi" +
			"alelea fakanikōlea fakasoto-tokelaulea fakanuelilea fakaneuali-motuʻ" +
			"alea fakaniamiuesilea fakanianikolelea fakaniololea fakanesimalea fa" +
			"kaʻosēselea fakatoake-ʻotomanilea fakapangasinanilea fakapālavilea f" +
			"akapamipangalea fakapapiamēnitolea fakapalaulea fakapikātilea fakasi" +
			"amane-penisilivanialea fakasiamane-lafalafalea fakapēsia-motuʻalea f" +
			"akasiamane-palatinelea fakafoinikialea fakapiemonitelea fakaponitiki" +
			"lea fakaponapēlea fakapulūsialea fakapolovenisi-motuʻalea fakakīsēle" +
			"a fakakuitisa-simipolasolea fakalasasitanilea fakalapanuilea fakalal" +
			"otongalea fakaromaniololea fakalifilea fakalomipōlea fakalomanilea f" +
			"akalotumalea fakalusinilea fakalovianalea fakaʻalomanialea fakaluāle" +
			"a fakasanitauelea fakasakalea fakasamalitani-ʻalāmitilea fakasamipul" +
			"ulea fakasasakilea fakasanitalilea fakasaulasitilālea fakangāmipaile" +
			"a fakasangulea fakasisīlialea fakasikotilanilea fakasaletīnia-sasale" +
			"sulea fakasenekalea fakasenalea fakaselilea fakaselikupilea fakakoil" +
			"apolo-senilea fakaʻaelani-motuʻalea fakasamositialea fakataselihitil" +
			"ea fakasianilea fakaʻalepea-sātilea fakasitamolea fakasilesia-hifole" +
			"a fakaselaiālea fakasami-tongalea fakasami-lulelea fakasami-ʻinalile" +
			"a fakasami-sikolitalea fakasoninekēlea fakasokitianalea fakasuranane" +
			"-tongikōlea fakasēlēlelea fakasaholea fakafilisia-satēlanilea fakasu" +
			"kumalea fakasusūlea fakasumelialea fakakomololea fakasuahili-kongikō" +
			"lea fakasuliāiā-muʻalea fakasuliāiālea fakasilesialea fakatululea fa" +
			"katimenēlea fakatesolea fakatelenolea fakatetumulea fakatikilīnialea" +
			" fakativilea fakatokelaulea fakasākulilea fakakilingonilea fakatilin" +
			"gikītelea fakatalisilea fakatamasiekilea fakaniasa-tongalea fakatoki" +
			"-pisinilea fakatuloiolea fakatalokolea fakasakōnialea fakatisīmisian" +
			"ilea fakatati-moselemilea fakatumepukalea fakatūvalulea fakatasauaki" +
			"lea fakatuvīnialea fakatamasaiti-ʻatilasi-lolotolea fakaʻutimulitile" +
			"a fakaʻūkalitilea fakaʻumipūnitulea fakaʻilonga-tefitolea fakavailea" +
			" fakavenēsialea fakavepisilea fakavelamingi-hihifolea fakafalanikoni" +
			"-lolotolea fakavotikilea fakavōlolea fakavūnisolea fakaʻualiselilea " +
			"fakaʻuolaitalea fakaʻualailea fakaʻuasiōlea fakasiaina-uūlea fakakal" +
			"imikilea fakamingilelialea fakasokalea fakaʻiaolea fakaʻiapilea faka" +
			"ʻiangipenilea fakaʻiēmipalea fakaneʻēngatūlea fakakuangitongilea fa" +
			"kasapotekilea fakaʻilonga-pilisilea fakasēlanilea fakasenakalea faka" +
			"tamasaiti-molokolea fakasuniʻikai ha lealea fakasāsālea fakaʻalepea " +
			"(māmani)lea fakasiamane-ʻaositulialea fakasiamane-hake-suisilanilea " +
			"fakapālangi-ʻaositelēlialea fakapālangi-kānatalea fakapilitānialea f" +
			"akapālangi-ʻamelikalea fakasipēnisi lātini-ʻamelikalea fakasipēnisi-" +
			"‘iulopelea fakasipēnisi-mekisikoulea fakafalanisē-kānatalea fakafa" +
			"lanisē-suisilanilea fakahōlani-pelesiumelea fakapotukali-palāsililea" +
			" fakapotukali-ʻiulopelea fakamolitāvialea fakakuloisia-sēpialea faka" +
			"siaina-fakafaingofualea fakasiaina-tukufakaholo",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0010, 0x0022, 0x0035, 0x0048, 0x0057, 0x0068, 0x0079,
			0x0089, 0x0099, 0x00aa, 0x00ba, 0x00ce, 0x00de, 0x00ee, 0x00ff,
			0x010f, 0x011f, 0x0130, 0x013e, 0x014e, 0x015d, 0x016d, 0x0179,
			0x0187, 0x0196, 0x01a3, 0x01af, 0x01c8, 0x01d6, 0x01e5, 0x01f8,
			0x0207, 0x0215, 0x0223, 0x0230, 0x023e, 0x024e, 0x0263, 0x0274,
			0x0287, 0x0296, 0x02a4, 0x02b1, 0x02c1, 0x02cd, 0x02da, 0x02eb,
			0x0301, 0x0311, 0x0320, 0x032f, 0x033e, 0x034e, 0x035e, 0x036b,
			0x037a, 0x0389, 0x039a, 0x03aa, 0x03b7, 0x03c9, 0x03da, 0x03e8,
			// Entry 40 - 7F
			0x03fa, 0x040f, 0x0426, 0x0436, 0x0449, 0x045b, 0x0468, 0x047a,
			0x048a, 0x049f, 0x04ae, 0x04ba, 0x04c9, 0x04d9, 0x04e7, 0x04f7,
			0x0505, 0x051a, 0x052c, 0x053a, 0x0548, 0x0556, 0x0567, 0x0576,
			0x0582, 0x0592, 0x05a1, 0x05af, 0x05c3, 0x05d1, 0x05e4, 0x05f1,
			0x05fc, 0x060c, 0x0620, 0x062f, 0x063f, 0x064e, 0x065b, 0x066d,
			0x0689, 0x069c, 0x06aa, 0x06b7, 0x06c5, 0x06d1, 0x06de, 0x06f6,
			0x0704, 0x0716, 0x0725, 0x073c, 0x0753, 0x0769, 0x0777, 0x0786,
			0x0797, 0x07a9, 0x07b8, 0x07d1, 0x07e2, 0x07f3, 0x0800, 0x080f,
			// Entry 80 - BF
			0x081e, 0x082e, 0x083d, 0x0853, 0x0862, 0x0872, 0x0880, 0x0894,
			0x08a8, 0x08ba, 0x08c9, 0x08dd, 0x08ed, 0x08fe, 0x090f, 0x0920,
			0x0930, 0x093d, 0x094b, 0x095e, 0x096c, 0x097d, 0x098f, 0x099e,
			0x09ae, 0x09bd, 0x09cb, 0x09e2, 0x09f1, 0x0a00, 0x0a11, 0x0a22,
			0x0a2b, 0x0a38, 0x0a45, 0x0a54, 0x0a62, 0x0a70, 0x0a81, 0x0a96,
			0x0aa5, 0x0ab6, 0x0ac5, 0x0ad6, 0x0ae6, 0x0af7, 0x0b07, 0x0b14,
			0x0b22, 0x0b33, 0x0b41, 0x0b4f, 0x0b5b, 0x0b6b, 0x0b7a, 0x0b8d,
			0x0b9d, 0x0bb6, 0x0bc9, 0x0bda, 0x0be8, 0x0bf8, 0x0c09, 0x0c19,
			// Entry C0 - FF
			0x0c31, 0x0c47, 0x0c5f, 0x0c6f, 0x0c81, 0x0c8f, 0x0c9f, 0x0cb0,
			0x0cca, 0x0cdb, 0x0cf2, 0x0d0c, 0x0d19, 0x0d33, 0x0d46, 0x0d54,
			0x0d63, 0x0d7d, 0x0d8b, 0x0d97, 0x0da7, 0x0db6, 0x0dc4, 0x0dd9,
			0x0de7, 0x0df3, 0x0e02, 0x0e10, 0x0e1c, 0x0e2a, 0x0e38, 0x0e48,
			0x0e56, 0x0e62, 0x0e72, 0x0e7e, 0x0e8f, 0x0ea2, 0x0eb4, 0x0ec1,
			0x0ed0, 0x0edd, 0x0eed, 0x0efc, 0x0f0a, 0x0f16, 0x0f24, 0x0f35,
			0x0f41, 0x0f4f, 0x0f5d, 0x0f6e, 0x0f7d, 0x0f89, 0x0f98, 0x0fa8,
			0x0fb5, 0x0fc2, 0x0fd7, 0x0fe6, 0x0ff7, 0x1006, 0x1014, 0x102a,
			// Entry 100 - 13F
			0x103a, 0x104a, 0x105f, 0x106f, 0x107d, 0x108d, 0x109a, 0x10aa,
			0x10b8, 0x10c9, 0x10d9, 0x10e8, 0x10f6, 0x1109, 0x111e, 0x112b,
			0x1143, 0x1155, 0x1162, 0x1170, 0x1180, 0x118f, 0x119f, 0x11b5,
			0x11c6, 0x11d7, 0x11f0, 0x1206, 0x1218, 0x122f, 0x123c, 0x124d,
			0x1267, 0x1275, 0x128d, 0x12a7, 0x12c0, 0x12d2, 0x12e9, 0x12ff,
			0x1310, 0x131b, 0x132a, 0x133d, 0x1349, 0x1357, 0x1370, 0x137f,
			0x138f, 0x139d, 0x13ba, 0x13d6, 0x13ed, 0x13fc, 0x140e, 0x141c,
			0x1429, 0x143c, 0x1455, 0x1464, 0x1474, 0x1481, 0x1492, 0x149f,
			// Entry 140 - 17F
			0x14b2, 0x14c2, 0x14d6, 0x14e9, 0x14f7, 0x1505, 0x1518, 0x152d,
			0x1539, 0x1548, 0x1558, 0x1567, 0x1577, 0x158a, 0x15a2, 0x15b2,
			0x15c3, 0x15d1, 0x15e7, 0x15ff, 0x1611, 0x1626, 0x1634, 0x1642,
			0x164f, 0x165d, 0x1669, 0x167b, 0x168c, 0x1699, 0x16aa, 0x16bf,
			0x16cf, 0x16db, 0x16ec, 0x16f9, 0x1708, 0x171b, 0x1729, 0x173e,
			0x174a, 0x175c, 0x176f, 0x1785, 0x1796, 0x17a5, 0x17b3, 0x17ca,
			0x17d7, 0x17e8, 0x17f7, 0x1805, 0x1816, 0x1823, 0x1833, 0x1841,
			0x1850, 0x185e, 0x186b, 0x187a, 0x1889, 0x1898, 0x18af, 0x18be,
			// Entry 180 - 1BF
			0x18cd, 0x18db, 0x18ec, 0x18fc, 0x1908, 0x1918, 0x192a, 0x1939,
			0x1948, 0x1953, 0x195f, 0x196c, 0x1984, 0x1990, 0x199e, 0x19aa,
			0x19b8, 0x19c7, 0x19d7, 0x19eb, 0x19f8, 0x1a04, 0x1a14, 0x1a24,
			0x1a33, 0x1a3f, 0x1a50, 0x1a69, 0x1a7f, 0x1a8b, 0x1a9b, 0x1aaf,
			0x1abe, 0x1ace, 0x1add, 0x1ae9, 0x1afc, 0x1b0d, 0x1b17, 0x1b25,
			0x1b38, 0x1b48, 0x1b59, 0x1b66, 0x1b76, 0x1b8a, 0x1ba1, 0x1bb3,
			0x1bbf, 0x1bd3, 0x1be1, 0x1bee, 0x1bfb, 0x1c0b, 0x1c19, 0x1c2c,
			0x1c39, 0x1c4f, 0x1c5e, 0x1c6b, 0x1c7f, 0x1c8c, 0x1ca2, 0x1cb3,
			// Entry 1C0 - 1FF
			0x1cc4, 0x1cd1, 0x1cdf, 0x1cef, 0x1d06, 0x1d19, 0x1d28, 0x1d39,
			0x1d4d, 0x1d5a, 0x1d69, 0x1d86, 0x1d9e, 0x1db4, 0x1dcc, 0x1ddc,
			0x1ded, 0x1dfd, 0x1e0c, 0x1e1c, 0x1e36, 0x1e44, 0x1e5e, 0x1e70,
			0x1e7f, 0x1e90, 0x1ea1, 0x1ead, 0x1ebc, 0x1eca, 0x1ed8, 0x1ee6,
			0x1ef5, 0x1f07, 0x1f13, 0x1f23, 0x1f2f, 0x1f4c, 0x1f5c, 0x1f6a,
			0x1f7a, 0x1f8e, 0x1f9f, 0x1fac, 0x1fbc, 0x1fce, 0x1fe9, 0x1ff7,
			0x2003, 0x200f, 0x201f, 0x2035, 0x204d, 0x205e, 0x2070, 0x207d,
			0x2093, 0x20a1, 0x20b5, 0x20c4, 0x20d6, 0x20e7, 0x20fb, 0x2110,
			// Entry 200 - 23F
			0x2121, 0x2132, 0x214b, 0x215b, 0x2167, 0x2180, 0x218e, 0x219b,
			0x21aa, 0x21b8, 0x21d0, 0x21e7, 0x21f8, 0x2207, 0x2213, 0x2222,
			0x222e, 0x223c, 0x224a, 0x225c, 0x2268, 0x2277, 0x2286, 0x2297,
			0x22ab, 0x22b9, 0x22ca, 0x22dd, 0x22f0, 0x22fe, 0x230c, 0x231c,
			0x2330, 0x2345, 0x2355, 0x2364, 0x2374, 0x2384, 0x23a6, 0x23b9,
			0x23cb, 0x23df, 0x23f6, 0x2401, 0x2411, 0x241f, 0x2437, 0x2450,
			0x245e, 0x246b, 0x247a, 0x248c, 0x249d, 0x24ac, 0x24bc, 0x24bc,
			0x24ce, 0x24de, 0x24f0, 0x24fc, 0x2509, 0x2517, 0x252a, 0x253b,
			// Entry 240 - 27F
			0x254f, 0x2562, 0x2572, 0x2589, 0x2598, 0x25a6, 0x25be, 0x25ca,
			0x25d7, 0x25e5, 0x25ff, 0x261a, 0x2638, 0x2657, 0x266f, 0x2681,
			0x269b, 0x26be, 0x26d9, 0x26f4, 0x270d, 0x2728, 0x2741, 0x275b,
			0x2774, 0x2786, 0x279d, 0x27b9, 0x27d4,
		},
	},
	{ // tr
		trLangStr,
		trLangIdx,
	},
	{ // twq
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senni, Gam" +
			"e hereKoree senniMaleezi senniBurme senniNeepal senniHolandee senniP" +
			"unjaabi senniiPolonee senniPortugee senniRumaani senniRuusi senniRwa" +
			"nda senniSomaali senniSuweede senniTamil senniTaailandu senniTurku s" +
			"enniUkreen senniUrdu senniVietnaam senniYorbance senniSinuwa senni, " +
			"MandareŋZulu senniTasawaq senni",
		[]uint16{ // 549 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x011c, 0x011c, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0134, 0x0134, 0x013f, 0x013f, 0x013f,
			0x014b, 0x014b, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159,
			0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0168, 0x0168, 0x0175,
			// Entry 80 - BF
			0x0175, 0x0183, 0x0183, 0x0183, 0x0183, 0x0190, 0x019b, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			0x01c1, 0x01c1, 0x01cc, 0x01cc, 0x01cc, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01db, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01f2,
			0x01fc, 0x01fc, 0x01fc, 0x020a, 0x020a, 0x020a, 0x020a, 0x020a,
			0x020a, 0x0218, 0x0218, 0x022f, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry C0 - FF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 100 - 13F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 140 - 17F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 180 - 1BF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 1C0 - 1FF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 200 - 23F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0246,
		},
	},
	{ // tzm
		"TakanitTamharitTaεrabtTabilarusitTabelɣaritTabinɣalitTačiktTalmanitTayun" +
			"anitTanglizttasbelyunitTafarisitTafṛansistTahawsatTahinditTahenɣarit" +
			"TindunisitTigbutTaṭalyantTajappunitTajavanitTaxmert ,TalammastTakuri" +
			"tTamalizitTaburmanitTanippalitTahulanḍitTabenjabitTappulunitTaburtuɣ" +
			"alitTaṛumanitTarusitTarwanditTaṣumalitTaswiditTatamiltTaṭaytTaturkit" +
			"TukranitTurdutTaviṭnamitTayurubatTacinwit,MandarintazulutTamaziɣt",
		[]uint16{ // 551 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x000f, 0x000f,
			0x0017, 0x0017, 0x0017, 0x0017, 0x0017, 0x0017, 0x0022, 0x002d,
			0x002d, 0x002d, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x0047, 0x0047, 0x0047, 0x0047, 0x0050, 0x0058, 0x0058, 0x0063,
			0x0063, 0x0063, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x0078,
			0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0080,
			0x0080, 0x0088, 0x0088, 0x0088, 0x0088, 0x0093, 0x0093, 0x0093,
			// Entry 40 - 7F
			0x0093, 0x009d, 0x009d, 0x00a3, 0x00a3, 0x00a3, 0x00a3, 0x00a3,
			0x00ae, 0x00ae, 0x00b8, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1,
			0x00c1, 0x00c1, 0x00d3, 0x00d3, 0x00da, 0x00da, 0x00da, 0x00da,
			0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da,
			0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da,
			0x00da, 0x00da, 0x00da, 0x00e3, 0x00e3, 0x00ed, 0x00ed, 0x00ed,
			0x00f7, 0x00f7, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103,
			0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x010d, 0x010d, 0x0117,
			// Entry 80 - BF
			0x0117, 0x0124, 0x0124, 0x0124, 0x0124, 0x012f, 0x0136, 0x013f,
			0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x013f, 0x013f, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
			0x0152, 0x0152, 0x015a, 0x015a, 0x015a, 0x0162, 0x0162, 0x0162,
			0x0162, 0x0162, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x0172,
			0x0178, 0x0178, 0x0178, 0x0184, 0x0184, 0x0184, 0x0184, 0x0184,
			0x0184, 0x018d, 0x018d, 0x019e, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry C0 - FF
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 100 - 13F
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 140 - 17F
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 180 - 1BF
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 1C0 - 1FF
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 200 - 23F
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01ae,
		},
	},
	{ // ug
		"ئافارچەئابخازچەئاۋېستاچەئافرىكانچەئاكانچەئامخاراچەئاراگونچەئەرەبچەئاسسام" +
			"چەئاۋارچەئايماراچەئەزەرىچەباشقىرتچەبېلارۇسچەبۇلغارچەبىسلاماچەبامبار" +
			"اچەبېنگالچەتىبەتچەبىرېتونچەبوسنىيەچەكاتالانچەچېچىنچەچامورروچەكورساچ" +
			"ەكرىچەچېخچەقەدىمكى سلاۋيانچەچۇۋاشچەۋېلشچەدانىشچەگېرمانچەدىۋەخىچەبۇت" +
			"انچەئېۋېچەگىرېكچەئىنگلىزچەدۇنيا تىلىئىسپانچەئېستونچەباسكىچەپارسچەفۇ" +
			"لاچەفىنچەفىجىچەفائېروچەفىرانسۇزچەغەربى فىرىزيەچەئىرېلاندچەسكوتچەگال" +
			"ىتسىيانچەگۇئارانىچەگۇجاراتچەمانچەخائۇساچەئىبرانىچەھىندىچەھىرى موتۇچ" +
			"ەخورۋاتچەھايتىچەماجارچەئەرمەنچەخېرېروچەئارىلىق تىلھىندونېزىيەچەئىنت" +
			"ىرلىڭچەئىبوچەيىچە (سىچۈەن)ئىنۇپىكچەئىدوچەئىسلاندچەئىتاليانچەئىنۇكتى" +
			"تۇتچەياپونچەياۋاچەگىرۇزىنچەكونگوچەكىكۇيۇچەكىۋانياماچەقازاقچەگىرېنلا" +
			"ندچەكىخمېرچەكانناداچەكورېيەچەكانۇرىچەكەشمىرچەكۇردچەكومىچەكورنىشچەقى" +
			"رغىزچەلاتىنچەلىيۇكسېمبۇرگچەگانداچەلىمبۇرگچەلىنگالاچەلائوسچەلىتۋاچەل" +
			"ۇبا-كاتانگاچەلاتۋىيەچەماداغاسقارچەمارشالچەماۋرىچەماكېدونچەمالايامچە" +
			"موڭغۇلچەماراتچەمالايچەمالتاچەبىرماچەناۋرۇچەشىمالى ندەبەلەچەنېپالچەن" +
			"دونگاچەگوللاندىيەچەيېڭى نورۋېگچەنورۋىگىيە بوكمالچەجەنۇبى ندەبەلەچەن" +
			"اۋاخوچەنيانجاچەئوكسىتانچەئوجىبۋاچەئوروموچەئورىياچەئوسسېتچەچەپەنجابچ" +
			"ەپالىچەپولەكچەپۇشتۇچەپورتۇگالچەكېچياچەرومانىشچەرۇندىچەرۇمىنىيەچەرۇس" +
			"چەرىۋانداچەسانسكرىتچەساردىنىيەچەسىندىچەشىمالى سامىچەسانگوچەسىنگالچە" +
			"سىلوۋاكچەسىلوۋېنىيەچەساموئاچەشوناچەسومالىچەئالبانچەسېربچەسىۋاتىچەجە" +
			"نۇبى سوتوچەسۇنداچەشۋېدچەسىۋالىچەتامىلچەتېلۇگۇچەتاجىكچەتايلاندچەتىگر" +
			"ىنياچەتۈركمەنچەسىۋاناچەتوڭانچەتۈركچەسونگاچەتاتارچەتاختىچەئۇيغۇرچەئۇ" +
			"كرائىنچەئوردوچەئۆزبېكچەۋېنداچەۋىيېتنامچەۋولاپۇكچەۋاللۇنچەۋولوفچەخوس" +
			"اچەيىددىشچەيورۇباچەجۇاڭچەخەنچەزۇلۇچەئاتجېچەئاچولىچەئاداڭمېچەئادىگېي" +
			"چەئافرىخىلىچەئاگەمچەئاينۇچەئاككادچەئالېيۇتچەجەنۇبى ئالتاي تىللىرىقە" +
			"دىمكى ئىنگلىزچەئانگىكاچەئارامۇچەماپۇچەئاراپاخوچەئاراۋاكچەئاسۇچەئاست" +
			"ۇرىيەچەئاۋادىچەبېلۇجىچەبالىچەباساچەبامۇنچەگومالاچەبېجاچەبېمباچەبېنا" +
			"چەبافۇتچەبوجپۇرىچەبىكولچەبىنىچەكومچەسىكسىكاچەبىراجچەبودوچەئاكۇسچەبۇ" +
			"رىياتچەبۇگىچەبۇلۇچەبىلىنچەمېدۇمباچەكاددوچەكارىبچەكايۇگاچەئاتسامچەسې" +
			"بۇچەچىگاچەچىبچاچەچاغاتايچەچۇكچەمارىچەچىنۇك-ژارگونچەچوكتاۋچەچىپېۋيان" +
			"چەچېروكىچەچېيېنچەسورانى كۇردچەكوپتىكچەقىرىم تۈركچەكاسزۇبىچەداكوتاچە" +
			"دارگىۋاچەتايتاچەدېلاۋارېچەسلاۋچەدوگرىبچەدىنكاچەزارماچەدوگرىچەتوۋەن " +
			"سېربچەدۇئالاچەئوتتۇرا گوللاندىيەچەجولاچەدىيۇلاچەدازاگاچەئېمبۇچەئېفى" +
			"كچەقەدىمكى مىسىرچەئېكاجۇكچەئېلامىتچەئوتتۇرا ئەسىر ئىنگلىزچەئېۋوندوچ" +
			"ەفاڭچەفىلىپپىنچەفونچەئوتتۇرا ئەسىر فىرانسۇزچەقەدىمكى فىرانسۇزچەشىما" +
			"لى فىرىزيەچەشەرقى فىرىزيەچەفىرىئۇلىچەگاچەگايوچەگىباياچەگىزچەگىلبېرت" +
			"چەئوتتۇرا ئەسىر ئېگىزلىك گېرمانچەقەدىمكى ئېگىزلىك گېرمانچەگوندىچەگو" +
			"رونتالوچەگوتچەگرېبوچەقەدىمكى گىرېكچەگېرمانچە شىۋىتسارىيەگۇسىچەگىۋىچ" +
			"ىنچەھەيدەچەھاۋايچەخىلىگاينونچەخىتتىتچەمۆڭچەيۇقىرىقى سېربچەخۇپاچەئىب" +
			"انچەئىبىبىئوچەئىلوكانوچەئىنگۇشچەلوجبانچەنگومباچەماچامچەئىبرانى پارس" +
			"چەئىبرانى ئەرەبچەقارا-قالپاقچەكابىلېچەكاچىنچەجۇچەكامباچەكاۋىچەكابار" +
			"دەيچەكانېمبۇچەتياپچەماكوندېچەكابۇۋېردىيانچەكوروچەكاسىچەخوتەنچەكويرا" +
			" چىنىچەكاكوچەكالېنجىنچەكىمبۇندۇچەكونكانىچەكوسرايېچەكىپەللېچەقاراچاي-" +
			"بالقارچەكارەلچەكۇرۇكچەشامبالاچەبافىياچەكولىشچەقۇمۇقچەكۇتەنايچەلادىن" +
			"وچەلانگىچەلانداچەلامباچەلېزگىنچەمونگوچەلوزىچەلۇبا-لۇئاچەلۇيسېنگوچەل" +
			"ۇنداچەلۇئوچەمىزوچەلۇياچەمادۇرېسچەمافاچەماگاخىچەمايتىلىچەماكاسارچەما" +
			"ندىنگوچەماسايچەماباچەموكشاچەماندارچەمېندېچەمېرۇچەمورىسيېنچەئوتتۇرا " +
			"ئەسىر ئىرېلاندچەماكۇۋاچەمېتاچە’مىكماكچەمىناڭكابائۇچەمانجۇچەمانىپۇرى" +
			"چەموخوكچەموسسىچەمۇنداڭچەكۆپ تىللاركىرىكچەمىراندېسچەمارۋارىچەميېنېچە" +
			"ئېرزاچەناپولىچەناماچەتۆۋەن گېرمانچەنېۋارىچەنىئاسچەنيۇئېچەكۋاسىيوچەن" +
			"گېمبۇنچەنوغايچەقەدىمكى نورۋېگچەنىكوچەشىمالى سوتوچەمۇئېرچەنېۋارچەنيا" +
			"مۋېزىچەنىيانكولېچەنىئوروچەنىزەماچەئوساگېلارچەئوسمان تۈركچەپانگاسىنا" +
			"نچەپەھلەۋىچەپامپانگاچەپاپىيامەنتۇچەپالاۋچەقەدىمكى پارىسچەفىنىكىيەچە" +
			"پوناپېئانچەقەدىمكى پروۋېنچالچەراجاستانچەراپانىيچەرومبوچەسىگانچەئارو" +
			"مانچەرىۋاچەسانداۋېچەياقۇتچەسامارىتانچەسامبۇرۇچەساساكچەسانتالىچەنگام" +
			"بايچەسانگۇچەسىتسىلىيەچەشوتلاندىيەچەسېكنېكاچەسېناچەسېلكاپچەشەرقىي سو" +
			"ڭخايچەقەدىمكى ئىرېلاندچەشىلخاچەشانچەچاد ئەرەبچەسىداموچەجەنۇبى سامى " +
			"تىللىرىلۇلې سامىچەئىنارى سامىچەسىكولت سامىچەسونىنكەچەسوغدىچەسىرانان" +
			"-توڭوچەسېرېرچەساخوچەسۇكۇماچەسۇسۇچەسۈمەرچەكومورىچەكونگو سىۋالىچەكلاسس" +
			"ىك سۈرىيەچەسۈرىيەچەتېمنېچەتېسوچەتېرېناچەتېتۇمچەتىگرېچەتىۋچەتوكېلاۋچ" +
			"ەكىلىنگونچەتىلىنگىتچەتاماشېكچەنياسا توڭانچەتوك-پىسىنچەتوروكوچەسىمشي" +
			"انچەتۇمبۇكاچەتۇۋالۇچەشىمالىي سوڭخايچەتوۋاچەمەركىزى ئاتلاس تاماچاگىت" +
			"ئۇدمۇرتچەئۇگارىتىكچەئۇمبۇندۇچەغول تىلۋايچەۋوتېچەۋۇنجوچەۋالسېرچەۋولا" +
			"يتاچەۋارايچەۋاشوچەقالماقچەسوگاچەياۋچەياپچەياڭبەنچەيېمباچەگۇاڭدوڭچەز" +
			"اپوتېكچەبىلىس بەلگىلىرىزېناگاچەئۆلچەملىك ماراكەش تامازىتچەزۇنىچەتىل" +
			" مەزمۇنى يوقزازاچەھازىرقى زامان ئۆلچەملىك ئەرەبچەئاۋستىرىيە گېرمانچە" +
			"شىۋىتسارىيە ئېگىزلىك گېرمانچەئاۋسترالىيە ئىنگلىزچەكانادا ئىنگلىزچەئ" +
			"ەنگلىيە ئىنگلىزچەئامېرىكا ئىنگلىزچەلاتىن ئامېرىكا ئىسپانچەياۋروپا ئ" +
			"ىسپانچەمېكسىكا ئىسپانچەكانادا فىرانسۇزچەشىۋىتسارىيە فىرانسۇزچەبىراز" +
			"ىلىيە پورتۇگالچەياۋروپا پورتۇگالچەسېرب-كرودىيەچەئاددىي خەنچەمۇرەككە" +
			"پ خەنچە",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x000e, 0x001e, 0x0030, 0x0044, 0x0052, 0x0064, 0x0076,
			0x0084, 0x0094, 0x00a2, 0x00b4, 0x00c4, 0x00d6, 0x00e8, 0x00f8,
			0x010a, 0x011c, 0x012c, 0x013a, 0x014c, 0x015e, 0x0170, 0x017e,
			0x0190, 0x019e, 0x01a8, 0x01b2, 0x01d3, 0x01e1, 0x01ed, 0x01fb,
			0x020b, 0x021b, 0x0229, 0x0235, 0x0243, 0x0255, 0x0268, 0x0278,
			0x0288, 0x0296, 0x02a2, 0x02ae, 0x02b8, 0x02c4, 0x02d4, 0x02e8,
			0x0305, 0x0319, 0x0325, 0x033d, 0x0351, 0x0363, 0x036d, 0x037d,
			0x038f, 0x039d, 0x03b2, 0x03c2, 0x03d0, 0x03de, 0x03ee, 0x03fe,
			// Entry 40 - 7F
			0x0413, 0x042d, 0x0443, 0x044f, 0x0466, 0x0478, 0x0484, 0x0496,
			0x04aa, 0x04c2, 0x04d0, 0x04dc, 0x04ee, 0x04fc, 0x050c, 0x0522,
			0x0530, 0x0546, 0x0556, 0x0568, 0x0578, 0x0588, 0x0598, 0x05a4,
			0x05b0, 0x05c0, 0x05d0, 0x05de, 0x05fa, 0x0608, 0x061a, 0x062c,
			0x063a, 0x0648, 0x0663, 0x0675, 0x068d, 0x069d, 0x06ab, 0x06bd,
			0x06cf, 0x06df, 0x06ed, 0x06fb, 0x0709, 0x0717, 0x0725, 0x0744,
			0x0752, 0x0762, 0x077a, 0x0793, 0x07b6, 0x07d5, 0x07e5, 0x07f5,
			0x0809, 0x081b, 0x082b, 0x083b, 0x084f, 0x085f, 0x086b, 0x0879,
			// Entry 80 - BF
			0x0887, 0x089b, 0x08a9, 0x08bb, 0x08c9, 0x08dd, 0x08e7, 0x08f9,
			0x090d, 0x0923, 0x0931, 0x094a, 0x0958, 0x0968, 0x097a, 0x0992,
			0x09a2, 0x09ae, 0x09be, 0x09ce, 0x09da, 0x09ea, 0x0a03, 0x0a11,
			0x0a1d, 0x0a2d, 0x0a3b, 0x0a4b, 0x0a59, 0x0a6b, 0x0a7f, 0x0a91,
			0x0aa1, 0x0aaf, 0x0abb, 0x0ac9, 0x0ad7, 0x0ae5, 0x0af5, 0x0b09,
			0x0b17, 0x0b27, 0x0b35, 0x0b49, 0x0b5b, 0x0b6b, 0x0b79, 0x0b85,
			0x0b95, 0x0ba5, 0x0bb1, 0x0bbb, 0x0bc7, 0x0bd5, 0x0be5, 0x0bf7,
			0x0c09, 0x0c09, 0x0c1f, 0x0c2d, 0x0c3b, 0x0c4b, 0x0c4b, 0x0c5d,
			// Entry C0 - FF
			0x0c5d, 0x0c85, 0x0ca6, 0x0cb8, 0x0cc8, 0x0cd4, 0x0cd4, 0x0ce8,
			0x0ce8, 0x0cfa, 0x0cfa, 0x0cfa, 0x0d06, 0x0d06, 0x0d1c, 0x0d1c,
			0x0d2c, 0x0d2c, 0x0d3c, 0x0d48, 0x0d48, 0x0d54, 0x0d62, 0x0d62,
			0x0d72, 0x0d7e, 0x0d8c, 0x0d8c, 0x0d98, 0x0da6, 0x0da6, 0x0db8,
			0x0dc6, 0x0dd2, 0x0dd2, 0x0ddc, 0x0dee, 0x0dee, 0x0dee, 0x0dfc,
			0x0dfc, 0x0e08, 0x0e16, 0x0e28, 0x0e34, 0x0e40, 0x0e4e, 0x0e60,
			0x0e6e, 0x0e7c, 0x0e8c, 0x0e9c, 0x0ea8, 0x0eb4, 0x0ec2, 0x0ed4,
			0x0ede, 0x0eea, 0x0f05, 0x0f15, 0x0f29, 0x0f39, 0x0f47, 0x0f60,
			// Entry 100 - 13F
			0x0f70, 0x0f70, 0x0f87, 0x0f99, 0x0fa9, 0x0fbb, 0x0fc9, 0x0fdd,
			0x0fe9, 0x0ff9, 0x1007, 0x1015, 0x1023, 0x103a, 0x103a, 0x104a,
			0x1071, 0x107d, 0x108d, 0x109d, 0x10ab, 0x10b9, 0x10b9, 0x10d6,
			0x10e8, 0x10fa, 0x1126, 0x1126, 0x1138, 0x1138, 0x1142, 0x1156,
			0x1156, 0x1160, 0x1160, 0x118e, 0x11b1, 0x11b1, 0x11d0, 0x11ed,
			0x1201, 0x1209, 0x1209, 0x1209, 0x1215, 0x1225, 0x1225, 0x122f,
			0x1241, 0x1241, 0x127c, 0x12ac, 0x12ac, 0x12ba, 0x12d0, 0x12da,
			0x12e8, 0x1305, 0x132c, 0x132c, 0x132c, 0x1338, 0x134a, 0x1358,
			// Entry 140 - 17F
			0x1358, 0x1366, 0x1366, 0x137e, 0x138e, 0x1398, 0x13b5, 0x13b5,
			0x13c1, 0x13cf, 0x13e3, 0x13f7, 0x1407, 0x1407, 0x1407, 0x1417,
			0x1427, 0x1435, 0x1450, 0x146d, 0x146d, 0x1486, 0x1496, 0x14a4,
			0x14ac, 0x14ba, 0x14c6, 0x14da, 0x14ec, 0x14f8, 0x150a, 0x1526,
			0x1526, 0x1532, 0x1532, 0x153e, 0x154c, 0x1563, 0x1563, 0x1563,
			0x156f, 0x1583, 0x1597, 0x1597, 0x15a9, 0x15bb, 0x15cd, 0x15ec,
			0x15ec, 0x15ec, 0x15fa, 0x1608, 0x161a, 0x162a, 0x1638, 0x1646,
			0x1658, 0x1668, 0x1676, 0x1684, 0x1692, 0x16a2, 0x16a2, 0x16a2,
			// Entry 180 - 1BF
			0x16a2, 0x16a2, 0x16a2, 0x16b0, 0x16bc, 0x16bc, 0x16d1, 0x16e5,
			0x16f3, 0x16ff, 0x170b, 0x1717, 0x1717, 0x1717, 0x1729, 0x1735,
			0x1745, 0x1757, 0x1769, 0x177d, 0x178b, 0x1797, 0x17a5, 0x17b5,
			0x17c3, 0x17cf, 0x17e3, 0x1811, 0x1821, 0x1830, 0x1840, 0x185a,
			0x1868, 0x187c, 0x188a, 0x1898, 0x1898, 0x18a8, 0x18bb, 0x18c9,
			0x18dd, 0x18ef, 0x18ef, 0x18fd, 0x190b, 0x190b, 0x190b, 0x191b,
			0x1927, 0x1942, 0x1952, 0x1960, 0x196e, 0x196e, 0x1980, 0x1992,
			0x19a0, 0x19bf, 0x19bf, 0x19cb, 0x19e4, 0x19f2, 0x1a00, 0x1a14,
			// Entry 1C0 - 1FF
			0x1a2a, 0x1a3a, 0x1a4a, 0x1a60, 0x1a79, 0x1a91, 0x1aa3, 0x1ab7,
			0x1ad1, 0x1adf, 0x1adf, 0x1adf, 0x1adf, 0x1afc, 0x1afc, 0x1b10,
			0x1b10, 0x1b10, 0x1b26, 0x1b26, 0x1b4b, 0x1b4b, 0x1b4b, 0x1b5f,
			0x1b71, 0x1b71, 0x1b71, 0x1b71, 0x1b7f, 0x1b8d, 0x1b8d, 0x1b8d,
			0x1b8d, 0x1b9f, 0x1bab, 0x1bbd, 0x1bcb, 0x1be1, 0x1bf3, 0x1c01,
			0x1c13, 0x1c13, 0x1c25, 0x1c33, 0x1c49, 0x1c61, 0x1c61, 0x1c73,
			0x1c7f, 0x1c7f, 0x1c8f, 0x1cac, 0x1ccf, 0x1ccf, 0x1cdd, 0x1ce7,
			0x1cfc, 0x1d0c, 0x1d0c, 0x1d0c, 0x1d30, 0x1d45, 0x1d5e, 0x1d77,
			// Entry 200 - 23F
			0x1d89, 0x1d97, 0x1db2, 0x1dc0, 0x1dcc, 0x1dcc, 0x1ddc, 0x1de8,
			0x1df6, 0x1e06, 0x1e21, 0x1e40, 0x1e50, 0x1e50, 0x1e50, 0x1e5e,
			0x1e6a, 0x1e7a, 0x1e88, 0x1e96, 0x1ea0, 0x1eb2, 0x1eb2, 0x1ec6,
			0x1eda, 0x1eda, 0x1eec, 0x1f05, 0x1f1a, 0x1f1a, 0x1f2a, 0x1f2a,
			0x1f3c, 0x1f3c, 0x1f4e, 0x1f5e, 0x1f7d, 0x1f89, 0x1fb7, 0x1fc9,
			0x1fdf, 0x1ff3, 0x2000, 0x200a, 0x200a, 0x200a, 0x200a, 0x200a,
			0x2016, 0x2016, 0x2024, 0x2034, 0x2046, 0x2054, 0x2060, 0x2060,
			0x2060, 0x2070, 0x2070, 0x207c, 0x2086, 0x2090, 0x20a0, 0x20ae,
			// Entry 240 - 27F
			0x20ae, 0x20c0, 0x20d2, 0x20ef, 0x20ef, 0x20ff, 0x2133, 0x213f,
			0x215b, 0x2167, 0x21a2, 0x21c7, 0x21ff, 0x2228, 0x2247, 0x226a,
			0x228d, 0x22b9, 0x22d8, 0x22f7, 0x2318, 0x2343, 0x2343, 0x236c,
			0x238f, 0x238f, 0x23aa, 0x23c1, 0x23dc,
		},
	},
	{ // uk
		ukLangStr,
		ukLangIdx,
	},
	{ // ur
		urLangStr,
		urLangIdx,
	},
	{ // ur-IN
		"افریقیکارسیکائیکنڑکردلٹويایزرمہمعیاری مراقشی تمازیقیجدید معیاری عربیآسان" +
			" چینی",
		[]uint16{ // 604 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			// Entry 40 - 7F
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x0024, 0x0024, 0x0024, 0x0024, 0x002a,
			0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
			0x002a, 0x002a, 0x002a, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			// Entry 80 - BF
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			// Entry C0 - FF
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			// Entry 100 - 13F
			0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			// Entry 140 - 17F
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			// Entry 180 - 1BF
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			// Entry 1C0 - 1FF
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			// Entry 200 - 23F
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			// Entry 240 - 27F
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0095,
		},
	},
	{ // uz
		uzLangStr,
		uzLangIdx,
	},
	{ // uz-Arab
		"دریپشتواوزبیک",
		[]uint16{ // 170 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 40 - 7F
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 80 - BF
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x001a,
		},
	},
	{ // uz-Cyrl
		"АбхазчаАфриканчаАмхарчаАрабчаАссамчаОзарбайжончаБеларусчаБолгарчаБенгалч" +
			"аТибетчаБосниячаКаталанчаЧехчаУэлсчаДаниячаОлмончаГрекчаИнглизчаЭсп" +
			"ерантоИспанчаЭстончаБаскчаФорсчаФинчаФижичаФарэрчаФранцузчаҒарбий ф" +
			"ризианчаИрландчаГалицийчаГуараниГужаратиХаусаИбронийҲиндчаХорватчаГ" +
			"аитианчаВенгрчаАрманчаИндонезиячаИгбоИсландчаИталянчаЯпончаЯванчаГр" +
			"узинчаҚозоқчаХмерчаКаннадаКорейсчаКашмирчаКурдчаҚирғизчаЛотинчаЛюкс" +
			"ембургчаЛаоЛитвачаЛатишчаМалагасиМаориМакедончаМалайаламМаратиМалай" +
			"чаМальтачаБирманчаНепалчаГолландчаНорвегча НинорскНорвегча БокмалОр" +
			"ияПанжобчаПолякчаПуштуПортугалчаКвечуаРоманчаРуминчаРусчаСанскритча" +
			"СиндхиСинхалаСловакчаСловенчаСомаличаАлбанчаСербчаСунданчаШведчаСуа" +
			"хилиТамилчаТелугуТожикчаТайчаТигриньяТуркманчаТонгочаТуркчаТатарчаУ" +
			"йғурчаУкраинчаУрдуЎзбекВьетнамчаВолофчаХосаЙорубаХитойчаЗулуФилипин" +
			"оШвейцария немисчасиГавайчаНомаълум тилСтандарт Марокаш ТамазитТил " +
			"таркиби йўқЛотин Америка испанчасиФламандча",
		[]uint16{ // 599 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000e, 0x000e, 0x0020, 0x0020, 0x002e, 0x002e,
			0x003a, 0x0048, 0x0048, 0x0048, 0x0060, 0x0060, 0x0072, 0x0082,
			0x0082, 0x0082, 0x0092, 0x00a0, 0x00a0, 0x00b0, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00c2, 0x00cc, 0x00cc, 0x00cc, 0x00d8, 0x00e6,
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x0100, 0x0110, 0x0122, 0x0130,
			0x013e, 0x014a, 0x0156, 0x0156, 0x0160, 0x016c, 0x017a, 0x018c,
			0x01ab, 0x01bb, 0x01bb, 0x01cd, 0x01db, 0x01eb, 0x01eb, 0x01f5,
			0x0203, 0x020f, 0x020f, 0x021f, 0x0231, 0x023f, 0x024d, 0x024d,
			// Entry 40 - 7F
			0x024d, 0x0263, 0x0263, 0x026b, 0x026b, 0x026b, 0x026b, 0x027b,
			0x028b, 0x028b, 0x0297, 0x02a3, 0x02b3, 0x02b3, 0x02b3, 0x02b3,
			0x02c1, 0x02c1, 0x02cd, 0x02db, 0x02eb, 0x02eb, 0x02fb, 0x0307,
			0x0307, 0x0307, 0x0317, 0x0325, 0x033d, 0x033d, 0x033d, 0x033d,
			0x0343, 0x0351, 0x0351, 0x035f, 0x036f, 0x036f, 0x0379, 0x038b,
			0x039d, 0x039d, 0x03a9, 0x03b7, 0x03c7, 0x03d7, 0x03d7, 0x03d7,
			0x03e5, 0x03e5, 0x03f7, 0x0416, 0x0433, 0x0433, 0x0433, 0x0433,
			0x0433, 0x0433, 0x0433, 0x043b, 0x043b, 0x044b, 0x044b, 0x0459,
			// Entry 80 - BF
			0x0463, 0x0477, 0x0483, 0x0491, 0x0491, 0x049f, 0x04a9, 0x04a9,
			0x04bd, 0x04bd, 0x04c9, 0x04c9, 0x04c9, 0x04d7, 0x04e7, 0x04f7,
			0x04f7, 0x04f7, 0x0507, 0x0515, 0x0521, 0x0521, 0x0521, 0x0531,
			0x053d, 0x054b, 0x0559, 0x0565, 0x0573, 0x057d, 0x058d, 0x059f,
			0x059f, 0x05ad, 0x05b9, 0x05b9, 0x05c7, 0x05c7, 0x05d5, 0x05e5,
			0x05ed, 0x05f7, 0x05f7, 0x0609, 0x0609, 0x0609, 0x0617, 0x061f,
			0x061f, 0x062b, 0x062b, 0x0639, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			// Entry C0 - FF
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			// Entry 100 - 13F
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641,
			0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0651,
			0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651,
			0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651,
			0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651,
			0x0651, 0x0651, 0x0676, 0x0676, 0x0676, 0x0676, 0x0676, 0x0676,
			// Entry 140 - 17F
			0x0676, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			// Entry 180 - 1BF
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			// Entry 1C0 - 1FF
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			// Entry 200 - 23F
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684,
			0x0684, 0x0684, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b,
			0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b,
			0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b,
			// Entry 240 - 27F
			0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x069b, 0x06c9, 0x06c9,
			0x06e5, 0x06e5, 0x06e5, 0x06e5, 0x06e5, 0x06e5, 0x06e5, 0x06e5,
			0x06e5, 0x0711, 0x0711, 0x0711, 0x0711, 0x0711, 0x0723,
		},
	},
	{ // vai
		"ꕉꕪꘋꕉꕆꕌꔸꕞꕌꖝꔆꕞꖩꔻꗂꔠꗸꘋꗩꕭꔷꗿꗡꕧꕮꔧꗥꗷꘋꕶꕱꕐꘊꔧꗨꗡꔻꘂꘋꗱꘋꔻꕌꖙꕢꔦꔺꖽꔟꗸꘋꔤꖆꕇꔻꘂꘋꔤꕼꔤꕚꔷꘂꘋꕧꕐꕇꔧꕧꕙꕇꔧ" +
			"ꕃꘈꗢꖏꔸꘂꘋꕮꔒꔀꗩꕆꔻꕇꕐꔷꗍꔿꖛꕨꔬꗁꔒꔻꕶꕿꕃꔤꖄꕆꕇꘂꘋꗐꖺꔻꘂꘋꕟꖙꕡꖇꕮꔷꖬꔨꗵꘋꕚꕆꔷꕚꔤꗋꕃꖳꖴꔓꕇꘂꘋꖺꖦꔲꕩꕯ" +
			"ꕆꔧꖎꖄꕑꕦꕇꔧꖮꖨꕙꔤ",
		[]uint16{ // 556 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0015, 0x0015,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x002a, 0x0036,
			0x0036, 0x0036, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x003f, 0x003f, 0x003f, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x004e, 0x004e, 0x004e, 0x004e, 0x0057, 0x005d, 0x005d, 0x0066,
			0x0066, 0x0066, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x007e,
			0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x0087,
			0x0087, 0x008d, 0x008d, 0x008d, 0x008d, 0x0099, 0x0099, 0x0099,
			// Entry 40 - 7F
			0x0099, 0x00ab, 0x00ab, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00c0, 0x00c0, 0x00cc, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00e1, 0x00e1, 0x00ed, 0x00ed, 0x00ed, 0x00ed,
			0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed,
			0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed,
			0x00ed, 0x00ed, 0x00ed, 0x00f6, 0x00f6, 0x00ff, 0x00ff, 0x00ff,
			0x0108, 0x0108, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e,
			0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x0117, 0x0117, 0x0120,
			// Entry 80 - BF
			0x0120, 0x012c, 0x012c, 0x012c, 0x012c, 0x013b, 0x014a, 0x0153,
			0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
			0x0153, 0x0153, 0x015c, 0x015c, 0x015c, 0x015c, 0x015c, 0x015c,
			0x0168, 0x0168, 0x0171, 0x0171, 0x0171, 0x0177, 0x0177, 0x0177,
			0x0177, 0x0177, 0x017d, 0x017d, 0x017d, 0x017d, 0x017d, 0x018f,
			0x0195, 0x0195, 0x0195, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4,
			0x01a4, 0x01ad, 0x01ad, 0x01b6, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry C0 - FF
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 100 - 13F
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 140 - 17F
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 180 - 1BF
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 1C0 - 1FF
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 200 - 23F
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01c2,
		},
	},
	{ // vai-Latn
		"AkaŋAmiháriLahabuBhelarusaŋBhɔgerɛŋBhɛŋgáliChɛJamáĩHɛlɛŋPooPanyɛĩPɛɛsiyɛ" +
			"ŋFɛŋsiHawusaHíiŋdiHɔŋgérɛŋÍndonisiyɛŋÍgboItáliyɛŋJapaníĩJavaníĩKimɛ" +
			"ɛ̃ tɛKoríyɛŋMaléeeBhɛmísiNipaliDɔchiPuŋjabhiPɔ́lésiPotokíiRomíniyɛŋ" +
			"RɔshiyɛŋRawundaSomáliSúwídɛŋTamíliTáiTɔ́kiYukureniyɛŋƆduViyamíĩYórób" +
			"haChaniĩZúluVai",
		[]uint16{ // 556 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x000d, 0x000d,
			0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x001e, 0x0029,
			0x0029, 0x0029, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x003f, 0x003f, 0x003f, 0x003f, 0x0047, 0x004a, 0x004a, 0x0052,
			0x0052, 0x0052, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006b,
			0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0080, 0x0080, 0x0080,
			// Entry 40 - 7F
			0x0080, 0x008e, 0x008e, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x009e, 0x009e, 0x00a7, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00bd, 0x00bd, 0x00c7, 0x00c7, 0x00c7, 0x00c7,
			0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7,
			0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7,
			0x00c7, 0x00c7, 0x00c7, 0x00ce, 0x00ce, 0x00d7, 0x00d7, 0x00d7,
			0x00dd, 0x00dd, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3,
			0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00ec, 0x00ec, 0x00f6,
			// Entry 80 - BF
			0x00f6, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x010a, 0x0115, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123,
			0x012e, 0x012e, 0x0135, 0x0135, 0x0135, 0x0139, 0x0139, 0x0139,
			0x0139, 0x0139, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x014d,
			0x0151, 0x0151, 0x0151, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x0163, 0x0163, 0x016a, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry C0 - FF
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 100 - 13F
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 140 - 17F
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 180 - 1BF
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 1C0 - 1FF
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 200 - 23F
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x0172,
		},
	},
	{ // vi
		viLangStr,
		viLangIdx,
	},
	{ // vun
		"KiakanyiKiamharyiKyiarabuKyibelarusiKyibulgaryiaKyibanglaKyicheckiKyijer" +
			"umaniKyigirikiKyingerezaKyihispaniaKyiajemiKyifaransaKyihausaKyihind" +
			"iKyihungariKyiindonesiaKyiigboKyiitalianoKyijapaniKyijavaKyikambodia" +
			"KyikoreaKyimalesiaKyiburmaKyinepaliKyiholanziKyipunjabiKyipolandiKyi" +
			"renoKyiromaniaKyirusiKyinyarwandaKyisomalyiKyiswidiKyitamilKyitailan" +
			"diKyiturukyiKyiukraniaKyiurduKyivietinamuKyiyorubaKyichinaKyizuluKyi" +
			"vunjo",
		[]uint16{ // 563 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0056, 0x0060, 0x0060, 0x006b,
			0x006b, 0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x0085,
			0x0085, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00d0, 0x00d0, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00e2, 0x00e2, 0x00ea, 0x00ea, 0x00ea,
			0x00f3, 0x00f3, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd,
			0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x0107, 0x0107, 0x0111,
			// Entry 80 - BF
			0x0111, 0x0118, 0x0118, 0x0118, 0x0118, 0x0122, 0x0129, 0x0135,
			0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 180 - 1BF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 1C0 - 1FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 200 - 23F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x01a1,
		},
	},
	{ // wae
		"AbčasišAfrikánsAmharišArabišAssamesišAymaraSerbaidšanišWísrussišBulgariš" +
			"BengališTibetišBosnišKatalanišTšečišWalisišDänišTitšMalediwišButaniš" +
			"GričišEnglišSchpanišEstnišBaskišPersišFinišFidšianišWälšIrišGalizišG" +
			"uaraniGujaratiHausaHebräišHindiKroatišHaitianišUngarišArmenišIndones" +
			"išIgboIisländišItalienišJapanišGeorgišKazačišKambodšanišKannadaKorea" +
			"nišKašmirišKurdišKirgisišLatinišLuxemburgišLingalaLaotišLitauišLetti" +
			"šMalagásiMaoriMazedonišMalayalamMongolišMarathiMalaíšMaltesišBurmes" +
			"išNordndebeleNepalesišHoländišNorwegiš NynorskNorwegiš BokmålNyanjaO" +
			"riyaOsétišPandšabišPolnišPaštuPortugisišQuečuaRätromanišRundiRumäniš" +
			"RusišRuandišSanskritSindhiNordsamišSangoSingalesišSlowakišSlowenišSa" +
			"moanišShonaSomališAlbanišSerbišSwaziSüdsothoSundanesišSchwedišSuahel" +
			"išTamilišTeluguTadšikišThailändišTigrinjaTurkmenišTswanaTongaTürkišT" +
			"songaTaitišUigurišUkrainišUrduUsbekišVendaVietnamesišWolofXhosaYorub" +
			"aChinesišZuluEfikFilipinišHawaíanišNordsothoJakutišTetumNiwmelanesiš" +
			"Unbekannti SchpračWalserÖštričišes TitšSchwizer HočtitšAuštrališes E" +
			"nglišKanadišes EnglišBritišes EnglišAmerikanišes EnglišLatiamerikani" +
			"šes SchpanišIberišes SchpanišKanadišes WälšSchwizer WälšFlämišBrasi" +
			"lianišes PortugisišIberišes PortugisišVereifačts ChinesišTraditionel" +
			"ls Chinesiš",
		[]uint16{ // 605 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0009, 0x0009, 0x0012, 0x0012, 0x001a, 0x001a,
			0x0021, 0x002b, 0x002b, 0x0031, 0x003f, 0x003f, 0x004a, 0x0053,
			0x0053, 0x0053, 0x005c, 0x0064, 0x0064, 0x006b, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x007e, 0x007e, 0x007e, 0x0086, 0x008d,
			0x0092, 0x009c, 0x00a4, 0x00a4, 0x00ac, 0x00b3, 0x00b3, 0x00bc,
			0x00c3, 0x00ca, 0x00d1, 0x00d1, 0x00d7, 0x00e2, 0x00e2, 0x00e8,
			0x00e8, 0x00ed, 0x00ed, 0x00f5, 0x00fc, 0x0104, 0x0104, 0x0109,
			0x0112, 0x0117, 0x0117, 0x011f, 0x0129, 0x0131, 0x0139, 0x0139,
			// Entry 40 - 7F
			0x0139, 0x0143, 0x0143, 0x0147, 0x0147, 0x0147, 0x0147, 0x0152,
			0x015c, 0x015c, 0x0164, 0x0164, 0x016c, 0x016c, 0x016c, 0x016c,
			0x0175, 0x0175, 0x0182, 0x0189, 0x0192, 0x0192, 0x019c, 0x01a3,
			0x01a3, 0x01a3, 0x01ac, 0x01b4, 0x01c0, 0x01c0, 0x01c0, 0x01c7,
			0x01ce, 0x01d6, 0x01d6, 0x01dd, 0x01e6, 0x01e6, 0x01eb, 0x01f5,
			0x01fe, 0x0207, 0x020e, 0x0216, 0x021f, 0x0228, 0x0228, 0x0233,
			0x023d, 0x023d, 0x0247, 0x0258, 0x0269, 0x0269, 0x0269, 0x026f,
			0x026f, 0x026f, 0x026f, 0x0274, 0x027c, 0x0287, 0x0287, 0x028e,
			// Entry 80 - BF
			0x0294, 0x029f, 0x02a6, 0x02b2, 0x02b7, 0x02c0, 0x02c6, 0x02ce,
			0x02d6, 0x02d6, 0x02dc, 0x02e6, 0x02eb, 0x02f6, 0x02ff, 0x0308,
			0x0311, 0x0316, 0x031e, 0x0326, 0x032d, 0x0332, 0x033b, 0x0346,
			0x034f, 0x0358, 0x0360, 0x0366, 0x0370, 0x037c, 0x0384, 0x038e,
			0x0394, 0x0399, 0x03a1, 0x03a7, 0x03a7, 0x03ae, 0x03b6, 0x03bf,
			0x03c3, 0x03cb, 0x03d0, 0x03dc, 0x03dc, 0x03dc, 0x03e1, 0x03e6,
			0x03e6, 0x03ec, 0x03ec, 0x03f5, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			// Entry C0 - FF
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			// Entry 100 - 13F
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03fd, 0x03fd, 0x03fd,
			0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			// Entry 140 - 17F
			0x0407, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			// Entry 180 - 1BF
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x041b, 0x041b, 0x041b, 0x041b,
			// Entry 1C0 - 1FF
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			// Entry 200 - 23F
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0428, 0x0428, 0x0428, 0x0428, 0x0428, 0x0428,
			0x0428, 0x0428, 0x0428, 0x0428, 0x0435, 0x0435, 0x0435, 0x0435,
			0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0435,
			0x0435, 0x0435, 0x0448, 0x0448, 0x0448, 0x0448, 0x0448, 0x0448,
			0x0448, 0x0448, 0x0448, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e,
			0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e,
			// Entry 240 - 27F
			0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e,
			0x044e, 0x044e, 0x044e, 0x0462, 0x0474, 0x0489, 0x049b, 0x04ac,
			0x04c1, 0x04dc, 0x04ef, 0x04ef, 0x0500, 0x050f, 0x0517, 0x0531,
			0x0546, 0x0546, 0x0546, 0x055b, 0x0572,
		},
	},
	{ // xog
		"OluakaaniOluamharikiOluwarabuOlubelarusiOlubulugariyaOlubengaliOluceekeO" +
			"ludaakiOluyonaaniOlungerezaOlusipanyaOluperusiOlufalansaOluhawuzaOlu" +
			"hinduOluhangareOluyindonezyaOluyiboOluyitaleOlujapaniOlunnajjavaOluk" +
			"meOlukoreyaOlumalayiOlubbamaOlunepaliOluholandiOlupunjabiOlupolandiO" +
			"lupotugiiziOlulomaniyaOlulasaOlunarwandaOlusomaliyaOluswideniOlutami" +
			"iruOluttaayiOlutakeOluyukurayineOlu-uruduOluvyetinaamuOluyorubaOluca" +
			"yinaOluzzuluOlusoga",
		[]uint16{ // 572 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0014, 0x0014,
			0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x0028, 0x0035,
			0x0035, 0x0035, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x003f, 0x003f, 0x003f, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
			0x004f, 0x004f, 0x004f, 0x004f, 0x0059, 0x0063, 0x0063, 0x006d,
			0x006d, 0x006d, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0080,
			0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089,
			0x0089, 0x0091, 0x0091, 0x0091, 0x0091, 0x009b, 0x009b, 0x009b,
			// Entry 40 - 7F
			0x009b, 0x00a8, 0x00a8, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af,
			0x00b8, 0x00b8, 0x00c1, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00cc, 0x00cc, 0x00d2, 0x00d2, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00e4, 0x00e4, 0x00ec, 0x00ec, 0x00ec,
			0x00f5, 0x00f5, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
			0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x0109, 0x0109, 0x0113,
			// Entry 80 - BF
			0x0113, 0x011f, 0x011f, 0x011f, 0x011f, 0x012a, 0x0131, 0x013c,
			0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c,
			0x013c, 0x013c, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x0151, 0x0151, 0x015b, 0x015b, 0x015b, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x016b, 0x016b, 0x016b, 0x016b, 0x016b, 0x0178,
			0x0181, 0x0181, 0x0181, 0x018e, 0x018e, 0x018e, 0x018e, 0x018e,
			0x018e, 0x0197, 0x0197, 0x01a0, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry C0 - FF
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 100 - 13F
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 140 - 17F
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 180 - 1BF
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 1C0 - 1FF
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 200 - 23F
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01af,
		},
	},
	{ // yav
		"akánɛamalíképakaspielúsebulgálɛpengálɛ́ɛcɛ́kɛ́ɛŋndiámanyavánɛíŋgilísénu" +
			"ɛspanyɔ́lɛnupɛ́lisɛfeleŋsípakasíndíɔ́ŋgɛíndonísiɛíboitáliɛndiámanyá" +
			"vanɛkímɛɛkolíemáliɛbímanɛnunipálɛnilándɛnupunsapíɛ́nupolonɛ́ɛnupɔlit" +
			"ukɛ́ɛnulumɛ́ŋɛnulúsenuluándɛ́ɛnusomalíɛnusuetuanutámulenutáyɛnutúluk" +
			"enukeleniɛ́ŋɛnulutúnufiɛtnamíɛŋnuyolúpasinúɛnusulúnuasue",
		[]uint16{ // 575 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x000f, 0x000f,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x001e, 0x0027,
			0x0027, 0x0027, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x004a, 0x004a, 0x004a, 0x004a, 0x0052, 0x005e, 0x005e, 0x006e,
			0x006e, 0x006e, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x0083,
			0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0088,
			0x0088, 0x008e, 0x008e, 0x008e, 0x008e, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
			0x00af, 0x00af, 0x00b7, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00c7, 0x00c7, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00cd, 0x00cd, 0x00cd, 0x00d4, 0x00d4, 0x00dc, 0x00dc, 0x00dc,
			0x00e6, 0x00e6, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef,
			0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00fd, 0x00fd, 0x010a,
			// Entry 80 - BF
			0x010a, 0x011a, 0x011a, 0x011a, 0x011a, 0x0127, 0x012e, 0x013c,
			0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c,
			0x013c, 0x013c, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0179,
			0x0180, 0x0180, 0x0180, 0x0190, 0x0190, 0x0190, 0x0190, 0x0190,
			0x0190, 0x0199, 0x0199, 0x01a0, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry C0 - FF
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 100 - 13F
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 140 - 17F
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 180 - 1BF
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 1C0 - 1FF
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 200 - 23F
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01ad,
		},
	},
	{ // yi
		"אַפֿאַראַפֿריקאַנסאַמהאַרישאַראַגאנישאַראַבישאַסאַמישאַזערביידזשאַנישבעל" +
			"אַרוסישבולגאַרישבענגאַלישטיבעטישברעטאנישבאסנישקאַטאַלאנישטשעכישקלוי" +
			"סטער־סלאַווישוועלשישדענישדײַטשגריכישענגלישעספּעראַנטאשפּאַנישעסטישב" +
			"אַסקישפּערסישפֿינישפֿידזשיפֿאַראישפֿראַנצויזישמערב־פֿריזישאירישסקאט" +
			"יש געלישגאַלישישמאַנקסהאַוסאַהעברעאישהינדיקראאַטישאונגערישאַרמענישא" +
			"ינדאנעזישאידאאיסלאַנדישאיטאַליענישיאַפּאַנישיאַוואַנעזישגרוזינישקאַ" +
			"זאַכישכמערקאַנאַדאַקארעאישקורדישקארנישקירגיזישלאטיינישלוקסעמבורגישל" +
			"אַאליטווישלעטישמאַארישמאַקעדאנישמאַלאַיאַלאַםמאנגאלישמאַלטעזישבירמא" +
			"ַנישנעפּאַלישהאלענדישנײַ־נארוועגישנארוועגישאקסיטאַנישאסעטישפּוילישפ" +
			"ּאַשטאָפּארטוגעזישרומענישרוסישסאַנסקריטסאַרדישסינדהינארדסאַמישסינהא" +
			"ַלישסלאוואַקישסלאווענישסאַמאאַניששאנאַסאמאַלישאַלבאַנישסערביששוועדי" +
			"שסוואַהילישטאַמילטורקמענישטאָטערישאוקראַאינישאורדואוזבעקישוויעטנאַמ" +
			"עזישוואלאַפּוקייִדישכינעזישזולואַקאַדישאַלט ענגלישאַראַמישדרום אַזע" +
			"רביידזשאַנישבאַלינעזישבײַערישסעבואַנישקרים־טערקישקאַשובישאונטער־סאר" +
			"בישזשאלא־פֿאנימיטל ענגלישפֿיליפּינאאַלט־פֿראַנצויזישדרום־פֿריזישמזר" +
			"ח־פֿריזישמיטל הויכדויטשאַלט־ הויכדויטשגאטישאוראַלט־גריכישפידזשי הינ" +
			"דיאייבער־סארבישלאזשבאָןיידיש־פערסישלאַדינאליווישמיזאנאַפּאליטַנישני" +
			"דערדײַטשאַלט פּערסישפּרייסישרוסינישסיציליאַנישסקאטסאַלט־אירישאונטער" +
			" שלעזישslyסומערישקאמארישקאנגא־סוואַהיליששלעזישטיגרעאומבאַוואוסטע שפּ" +
			"ראַךמערב פֿלעמיששפּאַניש (ES)פֿלעמישסערבא־קראאַטיש",
		[]uint16{ // 603 elements
			// Entry 0 - 3F
			0x0000, 0x000e, 0x000e, 0x000e, 0x0024, 0x0024, 0x0036, 0x004a,
			0x005a, 0x006a, 0x006a, 0x006a, 0x008a, 0x008a, 0x009e, 0x00b0,
			0x00b0, 0x00b0, 0x00c2, 0x00d0, 0x00e0, 0x00ec, 0x0102, 0x0102,
			0x0102, 0x0102, 0x0102, 0x010e, 0x0130, 0x0130, 0x013e, 0x0148,
			0x0152, 0x0152, 0x0152, 0x0152, 0x015e, 0x016a, 0x0180, 0x0190,
			0x019a, 0x01a8, 0x01b6, 0x01b6, 0x01c2, 0x01d0, 0x01e0, 0x01f8,
			0x0210, 0x021a, 0x0231, 0x0241, 0x0241, 0x0241, 0x024d, 0x025b,
			0x026b, 0x0275, 0x0275, 0x0285, 0x0285, 0x0295, 0x02a5, 0x02a5,
			// Entry 40 - 7F
			0x02a5, 0x02b9, 0x02b9, 0x02b9, 0x02b9, 0x02b9, 0x02c1, 0x02d5,
			0x02eb, 0x02eb, 0x02ff, 0x0317, 0x0327, 0x0327, 0x0327, 0x0327,
			0x0339, 0x0339, 0x0341, 0x0353, 0x0361, 0x0361, 0x0361, 0x036d,
			0x036d, 0x0379, 0x0389, 0x0399, 0x03b1, 0x03b1, 0x03b1, 0x03b1,
			0x03b9, 0x03c7, 0x03c7, 0x03d1, 0x03d1, 0x03d1, 0x03df, 0x03f3,
			0x040d, 0x041d, 0x041d, 0x041d, 0x042f, 0x0441, 0x0441, 0x0441,
			0x0453, 0x0453, 0x0463, 0x047d, 0x048f, 0x048f, 0x048f, 0x048f,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04af, 0x04af, 0x04af, 0x04bd,
			// Entry 80 - BF
			0x04cd, 0x04e3, 0x04e3, 0x04e3, 0x04e3, 0x04f1, 0x04fb, 0x04fb,
			0x050d, 0x051b, 0x0527, 0x053b, 0x053b, 0x054d, 0x0561, 0x0573,
			0x0587, 0x0591, 0x05a1, 0x05b3, 0x05bf, 0x05bf, 0x05bf, 0x05bf,
			0x05cd, 0x05e1, 0x05ed, 0x05ed, 0x05ed, 0x05ed, 0x05ed, 0x05ff,
			0x05ff, 0x05ff, 0x05ff, 0x05ff, 0x060f, 0x060f, 0x060f, 0x0625,
			0x062f, 0x063f, 0x063f, 0x0659, 0x066d, 0x066d, 0x066d, 0x066d,
			0x0679, 0x0679, 0x0679, 0x0687, 0x068f, 0x068f, 0x068f, 0x068f,
			0x068f, 0x068f, 0x068f, 0x068f, 0x068f, 0x069f, 0x069f, 0x069f,
			// Entry C0 - FF
			0x069f, 0x069f, 0x06b4, 0x06b4, 0x06c4, 0x06c4, 0x06c4, 0x06c4,
			0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4,
			0x06c4, 0x06ed, 0x06ed, 0x0701, 0x070f, 0x070f, 0x070f, 0x070f,
			0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f,
			0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f,
			0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f, 0x070f,
			0x070f, 0x070f, 0x070f, 0x070f, 0x0721, 0x0721, 0x0721, 0x0721,
			0x0721, 0x0721, 0x0721, 0x0721, 0x0721, 0x0721, 0x0721, 0x0721,
			// Entry 100 - 13F
			0x0721, 0x0721, 0x0737, 0x0747, 0x0747, 0x0747, 0x0747, 0x0747,
			0x0747, 0x0747, 0x0747, 0x0747, 0x0747, 0x0761, 0x0761, 0x0761,
			0x0761, 0x0777, 0x0777, 0x0777, 0x0777, 0x0777, 0x0777, 0x0777,
			0x0777, 0x0777, 0x078c, 0x078c, 0x078c, 0x078c, 0x078c, 0x07a0,
			0x07a0, 0x07a0, 0x07a0, 0x07a0, 0x07c2, 0x07c2, 0x07da, 0x07f2,
			0x07f2, 0x07f2, 0x07f2, 0x07f2, 0x07f2, 0x07f2, 0x07f2, 0x07f2,
			0x07f2, 0x07f2, 0x080d, 0x082a, 0x082a, 0x082a, 0x082a, 0x0834,
			0x0834, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850,
			// Entry 140 - 17F
			0x0850, 0x0850, 0x0867, 0x0867, 0x0867, 0x0867, 0x0881, 0x0881,
			0x0881, 0x0881, 0x0881, 0x0881, 0x0881, 0x0881, 0x0881, 0x0891,
			0x0891, 0x0891, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9,
			0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9,
			0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9,
			0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9,
			0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9, 0x08a9,
			0x08a9, 0x08b7, 0x08b7, 0x08b7, 0x08b7, 0x08b7, 0x08b7, 0x08b7,
			// Entry 180 - 1BF
			0x08c3, 0x08c3, 0x08c3, 0x08c3, 0x08c3, 0x08c3, 0x08c3, 0x08c3,
			0x08c3, 0x08c3, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb,
			0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb,
			0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb,
			0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb,
			0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08cb, 0x08e5,
			0x08e5, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9,
			0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9,
			// Entry 1C0 - 1FF
			0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9,
			0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x0910, 0x0910, 0x0910,
			0x0910, 0x0910, 0x0910, 0x0920, 0x0920, 0x0920, 0x0920, 0x0920,
			0x0920, 0x0920, 0x0920, 0x0920, 0x0920, 0x0920, 0x0920, 0x092e,
			0x092e, 0x092e, 0x092e, 0x092e, 0x092e, 0x092e, 0x092e, 0x092e,
			0x092e, 0x092e, 0x092e, 0x092e, 0x0944, 0x094e, 0x094e, 0x094e,
			0x094e, 0x094e, 0x094e, 0x094e, 0x0962, 0x0962, 0x0962, 0x0962,
			0x0962, 0x0962, 0x097b, 0x097e, 0x097e, 0x097e, 0x097e, 0x097e,
			// Entry 200 - 23F
			0x097e, 0x097e, 0x097e, 0x097e, 0x097e, 0x097e, 0x097e, 0x097e,
			0x098c, 0x099a, 0x09ba, 0x09ba, 0x09ba, 0x09c6, 0x09c6, 0x09c6,
			0x09c6, 0x09c6, 0x09c6, 0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0,
			0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0,
			0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0, 0x09d0,
			0x09d0, 0x09d0, 0x09f9, 0x09f9, 0x09f9, 0x09f9, 0x0a10, 0x0a10,
			0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10,
			0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10,
			// Entry 240 - 27F
			0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10,
			0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10,
			0x0a10, 0x0a10, 0x0a25, 0x0a25, 0x0a25, 0x0a25, 0x0a33, 0x0a33,
			0x0a33, 0x0a33, 0x0a4f,
		},
	},
	{ // yo
		"Èdè AfrikaniÈdè AkaniÈdè AmarikiÈdè ArabikiTi AssamÈdè AzerbaijaniÈdè Be" +
			"larusiÈdè BugariaÈdè BengaliÈdè BretoniÈdè BosniaÈdè CatalaÈdè seeki" +
			"Èdè WelshiÈdè Ilẹ̀ DenmarkÈdè Ilẹ̀ GemaniÈdè GirikiÈdè Gẹ̀ẹ́sìÈdè E" +
			"sperantoÈdè SipanisiÈdè EstoniaÈdè BaskiÈdè PasiaÈdè FinisiÈdè Faroe" +
			"siÈdè FaranséÈdè FrisiaÈdè IrelandÈdè Gaelik ti Ilu ScotlandÈdè Gali" +
			"ciaÈdè GuaraniÈdè GujaratiÈdè HausaÈdè HeberuÈdè HindiÈdè KroatiaÈdè" +
			" HungariaÈdè Ile ArmeniaÈdè pipoÈdè IndonasiaIru ÈdèÈdè IboÈdè Icela" +
			"ndicÈdè ItalianiÈdè JapanisiÈdè JavanasiÈdè GeorgiaÈdè kameriÈdè Kan" +
			"nadaÈdè KoriaÈdè LatiniÈdè LithuaniaÈdè LatvianuÈdè MacedoniaÈdè mar" +
			"athiÈdè MalayaÈdè MaltaÈdè BumiisiÈdè NepaliÈdè DukiÈdè NorwayÈdè Oc" +
			"citaniÈdè PunjabiÈdè Ilẹ̀ PolandiÈdè PọtugiÈdè RomaniaÈdè ̣RọọsiaÈdè" +
			" RuwandaÈdè awon ara IndoÈdè SindhiÈdè SinhaleseÈdè SlovakiÈdè Slove" +
			"niaÈdè ara SomaliaÈdè AlbaniaÈdè SerbiaÈdè SesotoÈdè SudaniÈdè Suwid" +
			"iisiÈdè SwahiliÈdè TamiliÈdè TeluguÈdè TaiÈdè TigrinyaÈdè TurkmenÈdè" +
			" TọọkisiÈdè UkaniaÈdè UduÈdè UzbekÈdè JetinamuÈdè XhosaÈdè YiddishiÈ" +
			"dè YorùbáÈdè MandariÈdè ṢuluÈdè TagalogiÈdè KlingoniÈdè Serbo-Croati" +
			"ani",
		[]uint16{ // 603 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x0019, 0x0026, 0x0026,
			0x0033, 0x003b, 0x003b, 0x003b, 0x004c, 0x004c, 0x005a, 0x0067,
			0x0067, 0x0067, 0x0074, 0x0074, 0x0081, 0x008d, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x00a4, 0x00a4, 0x00a4, 0x00b0, 0x00c5,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00e5, 0x00f9, 0x0108, 0x0116,
			0x0123, 0x012e, 0x0139, 0x0139, 0x0145, 0x0145, 0x0152, 0x0160,
			0x016c, 0x0179, 0x0195, 0x01a2, 0x01af, 0x01bd, 0x01bd, 0x01c8,
			0x01d4, 0x01df, 0x01df, 0x01ec, 0x01ec, 0x01fa, 0x020b, 0x020b,
			// Entry 40 - 7F
			0x0215, 0x0224, 0x022d, 0x0236, 0x0236, 0x0236, 0x0236, 0x0245,
			0x0253, 0x0253, 0x0261, 0x026f, 0x027c, 0x027c, 0x027c, 0x027c,
			0x027c, 0x027c, 0x0288, 0x0295, 0x02a0, 0x02a0, 0x02a0, 0x02a0,
			0x02a0, 0x02a0, 0x02a0, 0x02ac, 0x02ac, 0x02ac, 0x02ac, 0x02ac,
			0x02ac, 0x02bb, 0x02bb, 0x02c9, 0x02c9, 0x02c9, 0x02c9, 0x02d8,
			0x02d8, 0x02d8, 0x02e5, 0x02f1, 0x02fc, 0x0309, 0x0309, 0x0309,
			0x0315, 0x0315, 0x031f, 0x031f, 0x032b, 0x032b, 0x032b, 0x032b,
			0x0339, 0x0339, 0x0339, 0x0339, 0x0339, 0x0346, 0x0346, 0x035b,
			// Entry 80 - BF
			0x035b, 0x0369, 0x0369, 0x0369, 0x0369, 0x0376, 0x0388, 0x0395,
			0x03a8, 0x03a8, 0x03b4, 0x03b4, 0x03b4, 0x03c3, 0x03d0, 0x03de,
			0x03de, 0x03de, 0x03ef, 0x03fc, 0x0408, 0x0408, 0x0414, 0x0420,
			0x042f, 0x043c, 0x0448, 0x0454, 0x0454, 0x045d, 0x046b, 0x0478,
			0x0478, 0x0478, 0x0489, 0x0489, 0x0489, 0x0489, 0x0489, 0x0495,
			0x049e, 0x04a9, 0x04a9, 0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04c2,
			0x04d0, 0x04de, 0x04de, 0x04eb, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			// Entry C0 - FF
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			// Entry 100 - 13F
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 140 - 17F
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 180 - 1BF
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 1C0 - 1FF
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 200 - 23F
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			// Entry 240 - 27F
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0528,
		},
	},
	{ // yo-BJ
		"Èdè AfrikaniÈdè AkaniÈdè AmarikiÈdè ArabikiTi AssamÈdè AzerbaijaniÈdè Be" +
			"larusiÈdè BugariaÈdè BengaliÈdè BretoniÈdè BosniaÈdè CatalaÈdè seeki" +
			"Èdè WelshiÈdè Ilɛ̀ DenmarkÈdè Ilɛ̀ GemaniÈdè GirikiÈdè Gɛ̀ɛ́sìÈdè E" +
			"sperantoÈdè SipanisiÈdè EstoniaÈdè BaskiÈdè PasiaÈdè FinisiÈdè Faroe" +
			"siÈdè FaranséÈdè FrisiaÈdè IrelandÈdè Gaelik ti Ilu ScotlandÈdè Gali" +
			"ciaÈdè GuaraniÈdè GujaratiÈdè HausaÈdè HeberuÈdè HindiÈdè KroatiaÈdè" +
			" HungariaÈdè Ile ArmeniaÈdè pipoÈdè IndonasiaIru ÈdèÈdè IboÈdè Icela" +
			"ndicÈdè ItalianiÈdè JapanisiÈdè JavanasiÈdè GeorgiaÈdè kameriÈdè Kan" +
			"nadaÈdè KoriaÈdè LatiniÈdè LithuaniaÈdè LatvianuÈdè MacedoniaÈdè mar" +
			"athiÈdè MalayaÈdè MaltaÈdè BumiisiÈdè NepaliÈdè DukiÈdè NorwayÈdè Oc" +
			"citaniÈdè PunjabiÈdè Ilɛ̀ PolandiÈdè PɔtugiÈdè RomaniaÈdè ̣RɔɔsiaÈdè" +
			" RuwandaÈdè awon ara IndoÈdè SindhiÈdè SinhaleseÈdè SlovakiÈdè Slove" +
			"niaÈdè ara SomaliaÈdè AlbaniaÈdè SerbiaÈdè SesotoÈdè SudaniÈdè Suwid" +
			"iisiÈdè SwahiliÈdè TamiliÈdè TeluguÈdè TaiÈdè TigrinyaÈdè TurkmenÈdè" +
			" TɔɔkisiÈdè UkaniaÈdè UduÈdè UzbekÈdè JetinamuÈdè XhosaÈdè YiddishiÈ" +
			"dè YorùbáÈdè MandariÈdè ShuluÈdè TagalogiÈdè KlingoniÈdè Serbo-Croat" +
			"iani",
		[]uint16{ // 603 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x0019, 0x0026, 0x0026,
			0x0033, 0x003b, 0x003b, 0x003b, 0x004c, 0x004c, 0x005a, 0x0067,
			0x0067, 0x0067, 0x0074, 0x0074, 0x0081, 0x008d, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x00a4, 0x00a4, 0x00a4, 0x00b0, 0x00c4,
			0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00e3, 0x00f5, 0x0104, 0x0112,
			0x011f, 0x012a, 0x0135, 0x0135, 0x0141, 0x0141, 0x014e, 0x015c,
			0x0168, 0x0175, 0x0191, 0x019e, 0x01ab, 0x01b9, 0x01b9, 0x01c4,
			0x01d0, 0x01db, 0x01db, 0x01e8, 0x01e8, 0x01f6, 0x0207, 0x0207,
			// Entry 40 - 7F
			0x0211, 0x0220, 0x0229, 0x0232, 0x0232, 0x0232, 0x0232, 0x0241,
			0x024f, 0x024f, 0x025d, 0x026b, 0x0278, 0x0278, 0x0278, 0x0278,
			0x0278, 0x0278, 0x0284, 0x0291, 0x029c, 0x029c, 0x029c, 0x029c,
			0x029c, 0x029c, 0x029c, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8,
			0x02a8, 0x02b7, 0x02b7, 0x02c5, 0x02c5, 0x02c5, 0x02c5, 0x02d4,
			0x02d4, 0x02d4, 0x02e1, 0x02ed, 0x02f8, 0x0305, 0x0305, 0x0305,
			0x0311, 0x0311, 0x031b, 0x031b, 0x0327, 0x0327, 0x0327, 0x0327,
			0x0335, 0x0335, 0x0335, 0x0335, 0x0335, 0x0342, 0x0342, 0x0356,
			// Entry 80 - BF
			0x0356, 0x0363, 0x0363, 0x0363, 0x0363, 0x0370, 0x0380, 0x038d,
			0x03a0, 0x03a0, 0x03ac, 0x03ac, 0x03ac, 0x03bb, 0x03c8, 0x03d6,
			0x03d6, 0x03d6, 0x03e7, 0x03f4, 0x0400, 0x0400, 0x040c, 0x0418,
			0x0427, 0x0434, 0x0440, 0x044c, 0x044c, 0x0455, 0x0463, 0x0470,
			0x0470, 0x0470, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x048b,
			0x0494, 0x049f, 0x049f, 0x04ad, 0x04ad, 0x04ad, 0x04ad, 0x04b8,
			0x04c6, 0x04d4, 0x04d4, 0x04e1, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			// Entry C0 - FF
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			// Entry 100 - 13F
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec,
			0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04ec, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			// Entry 140 - 17F
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			// Entry 180 - 1BF
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			// Entry 1C0 - 1FF
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			// Entry 200 - 23F
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa,
			0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x04fa, 0x0508,
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			// Entry 240 - 27F
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0508,
			0x0508, 0x0508, 0x051d,
		},
	},
	{ // zgh
		"ⵜⴰⴽⴰⵏⵜⵜⴰⵎⵀⴰⵔⵉⵜⵜⴰⵄⵔⴰⴱⵜⵜⴰⴱⵉⵍⴰⵔⵓⵙⵜⵜⴰⴱⵍⵖⴰⵔⵉⵜⵜⴰⴱⵏⵖⴰⵍⵉⵜⵜⴰⵜⵛⵉⴽⵉⵜⵜⴰⵍⵉⵎⴰⵏⵜⵜⴰⴳⵔⵉⴳⵉ" +
			"ⵜⵜⴰⵏⴳⵍⵉⵣⵜⵜⴰⵙⴱⵏⵢⵓⵍⵉⵜⵜⴰⴼⵓⵔⵙⵉⵜⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜⵜⴰⵀⴰⵡⵙⴰⵜⵜⴰⵀⵉⵏⴷⵉⵜⵜⴰⵀⵏⵖⴰⵔⵉⵜⵜⴰⵏⴷ" +
			"ⵓⵏⵉⵙⵉⵜⵜⵉⴳⴱⵓⵜⵜⴰⵟⴰⵍⵢⴰⵏⵜⵜⴰⵊⴰⴱⴱⵓⵏⵉⵜⵜⴰⵊⴰⴱⴰⵏⵉⵜⵜⴰⵅⵎⵉⵔⵜⵜⴰⴽⵓⵔⵉⵜⵜⴰⵎⴰⵍⴰⵡⵉⵜⵜⴰⴱ" +
			"ⵉⵔⵎⴰⵏⵉⵜⵜⴰⵏⵉⴱⴰⵍⵉⵜⵜⴰⵀⵓⵍⴰⵏⴷⵉⵜⵜⴰⴱⵏⵊⴰⴱⵉⵜⵜⴰⴱⵓⵍⵓⵏⵉⵜⵜⴰⴱⵕⵟⵇⵉⵣⵜⵜⴰⵔⵓⵎⴰⵏⵉⵜⵜⴰⵔⵓ" +
			"ⵙⵉⵜⵜⴰⵔⵓⵡⴰⵏⴷⵉⵜⵜⴰⵙⵓⵎⴰⵍⵉⵜⵜⴰⵙⵡⵉⴷⵉⵜⵜⴰⵜⴰⵎⵉⵍⵜⵜⴰⵜⴰⵢⵍⴰⵏⴷⵉⵜⵜⴰⵜⵓⵔⴽⵉⵜⵜⵓⴽⵔⴰⵏⵉⵜⵜ" +
			"ⵓⵔⴷⵓⵜⵜⴰⴱⵉⵜⵏⴰⵎⵉⵜⵜⴰⵢⵔⵓⴱⴰⵜⵜⴰⵛⵉⵏⵡⵉⵜⵜⴰⵣⵓⵍⵓⵜⵜⴰⵎⴰⵣⵉⵖⵜ",
		[]uint16{ // 583 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x002a, 0x002a,
			0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x005d, 0x0078,
			0x0078, 0x0078, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00db, 0x00f3, 0x00f3, 0x0111,
			0x0111, 0x0111, 0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0147,
			0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x015f,
			0x015f, 0x0177, 0x0177, 0x0177, 0x0177, 0x0192, 0x0192, 0x0192,
			// Entry 40 - 7F
			0x0192, 0x01b0, 0x01b0, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2,
			0x01dd, 0x01dd, 0x01fb, 0x0216, 0x0216, 0x0216, 0x0216, 0x0216,
			0x0216, 0x0216, 0x022b, 0x022b, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x025b, 0x025b, 0x0279, 0x0279, 0x0279,
			0x0294, 0x0294, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2,
			0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02cd, 0x02cd, 0x02e8,
			// Entry 80 - BF
			0x02e8, 0x0303, 0x0303, 0x0303, 0x0303, 0x031e, 0x0333, 0x0351,
			0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351,
			0x0351, 0x0351, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c,
			0x0384, 0x0384, 0x039c, 0x039c, 0x039c, 0x03bd, 0x03bd, 0x03bd,
			0x03bd, 0x03bd, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03ed,
			0x03ff, 0x03ff, 0x03ff, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x0435, 0x0435, 0x044d, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry C0 - FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 100 - 13F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 140 - 17F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 180 - 1BF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 1C0 - 1FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 200 - 23F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 240 - 27F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x047a,
		},
	},
	{ // zh
		zhLangStr,
		zhLangIdx,
	},
	{ // zh-Hant
		zhHantLangStr,
		zhHantLangIdx,
	},
	{ // zh-Hant-HK
		"意大利文瑞士德語巴西葡萄牙語",
		[]uint16{ // 600 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry 80 - BF
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry C0 - FF
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry 100 - 13F
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry 140 - 17F
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry 180 - 1BF
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry 1C0 - 1FF
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry 200 - 23F
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			// Entry 240 - 27F
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x0018, 0x0018, 0x0018, 0x0018,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x002a,
		},
	},
	{ // zu
		zuLangStr,
		zuLangIdx,
	},
}

// Size: 1912 bytes
const afLangStr = "" +
	"AbkasiesAfrikaansAkanAmhariesArabiesAssameesAymaraAzerbeidjansBaskirWit-" +
	"RussiesBulgaarsBambaraBengaalsTibettaansBretonsBosniesKatalaansKorsikaan" +
	"sTsjeggiesWalliesDeensDuitsDivehiDzongkhaEweGrieksEngelsEsperantoSpaansE" +
	"stniesBaskiesPersiesFinsFidjiaansFaroeesFransWes-FriesIersSkotse Gallies" +
	"GalisiesGuaraniGoedjaratiManxHausaHebreeusHindiKroatiesHaïtiaansHongaars" +
	"ArmeensInterlinguaIndonesiesIgboSichuan YiYslandsItaliaansInnuïtiesJapan" +
	"neesJavaansGeorgiesKongoleesKikuyuKazaksKalaallisutKhmerKannadaKoreaansK" +
	"asjmirsKoerdiesKorniesKirgisiesLatynLuxemburgsGandaLingaalsLaoLitausLuba" +
	"-KatangaLettiesMalgassiesMaoriMasedoniesMalabaarsMongoolsMarathiMaleisMa" +
	"lteesBirmaansNoord-NdebeleNepaleesNederlandsNoorweegse NynorskNoorse Bok" +
	"målSuid-NdebeleNyanjaOksitaansOromoOriyaOssetiesPandjabiPoolsPasjtoPortu" +
	"geesQuechuaReto-RomaansRundiRoemeensRussiesRwandeesSanskritSindhiNoordel" +
	"ike SamiSangoSinhalaSlowaaksSloweensSamoaansShonaSomaliesAlbaneesSerwies" +
	"SwaziSuid-SothoSundaneesSweedsSwahiliTamilTeluguTadzjieksThaiTigrinyaTur" +
	"kmeensTswanaTongaansTurksTsongaTataarsTahitiesUighurOekraïensOerdoeOezbe" +
	"eksVendaViëtnameesWolofXhosaJiddisjYorubaSjineesZoeloeAkoliAghemArameesM" +
	"apucheAsuBembaBenaBodoSjigaCherokeesSorani KoerdiesTaitaZarmaLae Sorbies" +
	"DualaJola-FonyiEmbuEfikAntieke EgiptiesFilippynsGaaGagauzGotiesAntieke G" +
	"rieksSwitserse DuitsGusiiHawaiiesHoog-SorbiesNgombaMachameKabyleKambaMak" +
	"ondeKabuverdianuKoyra ChiiniKalenjinKomi-PermyaksKonkaniShambalaBafiaLan" +
	"giLakotaLoziLuba-LuluaLuoLuyiaMasaiMeruMorisjenMakhuwa-MeettoMeta’Mohawk" +
	"MundangVeelvuldige taleNamaKwasioN’KoNoord-SothoNuerNyankoleK’iche’Rombo" +
	"RwaSamburuSanguSenaKoyraboro SenniTachelhitSuid-SamiLule SamiInari SamiS" +
	"kolt SamiSwahili (Kongo)TesoTetumKlingonTok PisinToemboekaTasawaqSentraa" +
	"l Atlas TamazightOnbekende of ongeldige taalVaiVunjoSogaStandaard Marokk" +
	"aanse TamazightGeen linguistiese inhoudModerne Standaard ArabiesSwitsers" +
	"e hoog-DuitsVlaamsMoldawies"

// Size: 1228 bytes, 602 elements
var afLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0000, 0x0008, 0x0008, 0x0011, 0x0015, 0x001d, 0x001d,
	0x0024, 0x002c, 0x002c, 0x0032, 0x003e, 0x0044, 0x004f, 0x0057,
	0x0057, 0x005e, 0x0066, 0x0070, 0x0077, 0x007e, 0x0087, 0x0087,
	0x0087, 0x0091, 0x0091, 0x009a, 0x009a, 0x009a, 0x00a1, 0x00a6,
	0x00ab, 0x00b1, 0x00b9, 0x00bc, 0x00c2, 0x00c8, 0x00d1, 0x00d7,
	0x00de, 0x00e5, 0x00ec, 0x00ec, 0x00f0, 0x00f9, 0x0100, 0x0105,
	0x010e, 0x0112, 0x0120, 0x0128, 0x012f, 0x0139, 0x013d, 0x0142,
	0x014a, 0x014f, 0x014f, 0x0157, 0x0161, 0x0169, 0x0170, 0x0170,
	// Entry 40 - 7F
	0x017b, 0x0185, 0x0185, 0x0189, 0x0193, 0x0193, 0x0193, 0x019a,
	0x01a3, 0x01ad, 0x01b6, 0x01bd, 0x01c5, 0x01ce, 0x01d4, 0x01d4,
	0x01da, 0x01e5, 0x01ea, 0x01f1, 0x01f9, 0x01f9, 0x0201, 0x0209,
	0x0209, 0x0210, 0x0219, 0x021e, 0x0228, 0x022d, 0x022d, 0x0235,
	0x0238, 0x023e, 0x024a, 0x0251, 0x025b, 0x025b, 0x0260, 0x026a,
	0x0273, 0x027b, 0x0282, 0x0288, 0x028f, 0x0297, 0x0297, 0x02a4,
	0x02ac, 0x02ac, 0x02b6, 0x02c8, 0x02d6, 0x02e2, 0x02e2, 0x02e8,
	0x02f1, 0x02f1, 0x02f6, 0x02fb, 0x0303, 0x030b, 0x030b, 0x0310,
	// Entry 80 - BF
	0x0316, 0x031f, 0x0326, 0x0332, 0x0337, 0x033f, 0x0346, 0x034e,
	0x0356, 0x0356, 0x035c, 0x036b, 0x0370, 0x0377, 0x037f, 0x0387,
	0x038f, 0x0394, 0x039c, 0x03a4, 0x03ab, 0x03b0, 0x03ba, 0x03c3,
	0x03c9, 0x03d0, 0x03d5, 0x03db, 0x03e4, 0x03e8, 0x03f0, 0x03f9,
	0x03ff, 0x0407, 0x040c, 0x0412, 0x0419, 0x0421, 0x0427, 0x0431,
	0x0437, 0x043f, 0x0444, 0x044f, 0x044f, 0x044f, 0x0454, 0x0459,
	0x0460, 0x0466, 0x0466, 0x046d, 0x0473, 0x0473, 0x0478, 0x0478,
	0x0478, 0x0478, 0x0478, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
	// Entry C0 - FF
	0x047d, 0x047d, 0x047d, 0x047d, 0x0484, 0x048b, 0x048b, 0x048b,
	0x048b, 0x048b, 0x048b, 0x048b, 0x048e, 0x048e, 0x048e, 0x048e,
	0x048e, 0x048e, 0x048e, 0x048e, 0x048e, 0x048e, 0x048e, 0x048e,
	0x048e, 0x048e, 0x0493, 0x0493, 0x0497, 0x0497, 0x0497, 0x0497,
	0x0497, 0x0497, 0x0497, 0x0497, 0x0497, 0x0497, 0x0497, 0x0497,
	0x0497, 0x049b, 0x049b, 0x049b, 0x049b, 0x049b, 0x049b, 0x049b,
	0x049b, 0x049b, 0x049b, 0x049b, 0x049b, 0x04a0, 0x04a0, 0x04a0,
	0x04a0, 0x04a0, 0x04a0, 0x04a0, 0x04a0, 0x04a9, 0x04a9, 0x04b8,
	// Entry 100 - 13F
	0x04b8, 0x04b8, 0x04b8, 0x04b8, 0x04b8, 0x04b8, 0x04bd, 0x04bd,
	0x04bd, 0x04bd, 0x04bd, 0x04c2, 0x04c2, 0x04cd, 0x04cd, 0x04d2,
	0x04d2, 0x04dc, 0x04dc, 0x04dc, 0x04e0, 0x04e4, 0x04e4, 0x04f4,
	0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04fd,
	0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd,
	0x04fd, 0x0500, 0x0506, 0x0506, 0x0506, 0x0506, 0x0506, 0x0506,
	0x0506, 0x0506, 0x0506, 0x0506, 0x0506, 0x0506, 0x0506, 0x050c,
	0x050c, 0x051a, 0x0529, 0x0529, 0x0529, 0x052e, 0x052e, 0x052e,
	// Entry 140 - 17F
	0x052e, 0x0536, 0x0536, 0x0536, 0x0536, 0x0536, 0x0542, 0x0542,
	0x0542, 0x0542, 0x0542, 0x0542, 0x0542, 0x0542, 0x0542, 0x0542,
	0x0548, 0x054f, 0x054f, 0x054f, 0x054f, 0x054f, 0x0555, 0x0555,
	0x0555, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x0561, 0x056d,
	0x056d, 0x056d, 0x056d, 0x056d, 0x056d, 0x0579, 0x0579, 0x0579,
	0x0579, 0x0581, 0x0581, 0x058e, 0x0595, 0x0595, 0x0595, 0x0595,
	0x0595, 0x0595, 0x0595, 0x0595, 0x059d, 0x05a2, 0x05a2, 0x05a2,
	0x05a2, 0x05a2, 0x05a7, 0x05a7, 0x05a7, 0x05a7, 0x05a7, 0x05a7,
	// Entry 180 - 1BF
	0x05a7, 0x05ad, 0x05ad, 0x05ad, 0x05b1, 0x05b1, 0x05bb, 0x05bb,
	0x05bb, 0x05be, 0x05be, 0x05c3, 0x05c3, 0x05c3, 0x05c3, 0x05c3,
	0x05c3, 0x05c3, 0x05c3, 0x05c3, 0x05c8, 0x05c8, 0x05c8, 0x05c8,
	0x05c8, 0x05cc, 0x05d4, 0x05d4, 0x05e2, 0x05e9, 0x05e9, 0x05e9,
	0x05e9, 0x05e9, 0x05ef, 0x05ef, 0x05ef, 0x05f6, 0x0606, 0x0606,
	0x0606, 0x0606, 0x0606, 0x0606, 0x0606, 0x0606, 0x0606, 0x0606,
	0x060a, 0x060a, 0x060a, 0x060a, 0x060a, 0x060a, 0x0610, 0x0610,
	0x0610, 0x0610, 0x0610, 0x0616, 0x0621, 0x0625, 0x0625, 0x0625,
	// Entry 1C0 - 1FF
	0x062d, 0x062d, 0x062d, 0x062d, 0x062d, 0x062d, 0x062d, 0x062d,
	0x062d, 0x062d, 0x062d, 0x062d, 0x062d, 0x062d, 0x062d, 0x062d,
	0x062d, 0x062d, 0x062d, 0x062d, 0x062d, 0x0638, 0x0638, 0x0638,
	0x0638, 0x0638, 0x0638, 0x0638, 0x063d, 0x063d, 0x063d, 0x063d,
	0x063d, 0x063d, 0x0640, 0x0640, 0x0640, 0x0640, 0x0647, 0x0647,
	0x0647, 0x0647, 0x0647, 0x064c, 0x064c, 0x064c, 0x064c, 0x064c,
	0x0650, 0x0650, 0x0650, 0x065f, 0x065f, 0x065f, 0x0668, 0x0668,
	0x0668, 0x0668, 0x0668, 0x0668, 0x0671, 0x067a, 0x0684, 0x068e,
	// Entry 200 - 23F
	0x068e, 0x068e, 0x068e, 0x068e, 0x068e, 0x068e, 0x068e, 0x068e,
	0x068e, 0x068e, 0x069d, 0x069d, 0x069d, 0x069d, 0x069d, 0x069d,
	0x06a1, 0x06a1, 0x06a6, 0x06a6, 0x06a6, 0x06a6, 0x06a6, 0x06ad,
	0x06ad, 0x06ad, 0x06ad, 0x06ad, 0x06b6, 0x06b6, 0x06b6, 0x06b6,
	0x06b6, 0x06b6, 0x06bf, 0x06bf, 0x06c6, 0x06c6, 0x06de, 0x06de,
	0x06de, 0x06de, 0x06f9, 0x06fc, 0x06fc, 0x06fc, 0x06fc, 0x06fc,
	0x06fc, 0x06fc, 0x0701, 0x0701, 0x0701, 0x0701, 0x0701, 0x0701,
	0x0701, 0x0701, 0x0701, 0x0705, 0x0705, 0x0705, 0x0705, 0x0705,
	// Entry 240 - 27F
	0x0705, 0x0705, 0x0705, 0x0705, 0x0705, 0x0705, 0x0724, 0x0724,
	0x073c, 0x073c, 0x0755, 0x0755, 0x0769, 0x0769, 0x0769, 0x0769,
	0x0769, 0x0769, 0x0769, 0x0769, 0x0769, 0x0769, 0x076f, 0x076f,
	0x076f, 0x0778,
}

// Size: 3927 bytes
const amLangStr = "" +
	"አፋርኛአብሐዚኛአፍሪካንኛአካንኛአማርኛዓረብኛአሳሜዛዊአያማርኛአዘርባጃንኛባስኪርኛቤላራሻኛቡልጋሪኛቢስላምኛባምባርኛቤንጋ" +
	"ሊኛቲቤታንኛብሬቶንኛቦስኒያንኛካታላንኛኮርሲካኛቼክኛወልሽዴኒሽጀርመንዲቬህድዞንግኻኛኢዊግሪክኛእንግሊዝኛኤስፐራንቶስፓ" +
	"ኒሽኢስቶኒያንኛባስክኛፐርሺያኛፊኒሽፊጂኛፋሮኛፈረንሳይኛየምዕራብ ፍሪስኛአይሪሽእስኮትስ ጌልክኛጋሊሺያጓራኒኛጉጃርቲኛ" +
	"ማንክስኛሃውሳኛዕብራስጥሒንዱኛክሮሽያንኛሃይትኛሀንጋሪኛአርመናዊኢንቴርሊንጓኢንዶኔዥኛእንተርሊንግወኢግቦኛሲቹንዪኛእኑ" +
	"ፒያቅኛአይስላንድኛጣሊያንኛእኑክቲቱትኛጃፓንኛጃቫንኛጆርጂያንኮንጎኛኪኩዩካዛክኛካላሊሱትኛክመርኛ ማእከላዊካናዳኛኮሪያ" +
	"ኛካሽሚርኛኩርድሽኛኮርኒሽኪርጊዝኛላቲንኛሉክዘምበርገርኛጋንዳኛሊንጋላኛላውስኛሉቴንያንኛሉባ ካታንጋላትቪያንማላጋስኛማ" +
	"ዮሪኛማሴዶንኛማላያላምኛሞንጎላዊኛማራቲኛማላይኛማልቲስኛቡርማኛናኡሩሰሜን ንዴብሌኔፓሊኛደችየኖርዌይ ናይኖርስክየኖርዌ" +
	"ይ ቦክማልንያንጃኦኪታንኛኦሮሞኛኦሪያኛኦሴቲክፑንጃብኛፖሊሽኛፓሽቶኛፖርቹጋልኛኵቿኛሮማንሽሩንዲኛሮማኒያንራሽኛኪንያርዋ" +
	"ንድኛሳንስክሪትኛሲንድሂኛሰሜናዊ ሳሚሳንጎኛሲንሃልኛስሎቫክኛስሎቪኛሳሞአኛሾናኛሱማልኛልቤኒኛሰርቢኛስዋቲኛሶዞኛሱዳንኛ" +
	"ስዊድንኛስዋሂሊኛታሚልኛተሉጉኛታጂኪኛታይኛትግርኛቱርክመንኛጽዋናዊኛቶንጋኛቱርክኛጾንጋኛታታርኛታሂታንኛኡዊግሁርኛዩክሬ" +
	"ንኛኡርዱኛኡዝቤክኛቬንዳቪትናምኛቮላፑክኛዎሎፍኛዞሳኛይዲሽኛዮሩባዊኛዡዋንግኛቻይንኛዙሉኛአኮሊኛአገምማፑቼአሱቤምባቤናቦ" +
	"ዶብሊንቺጋኛቼሮኬኛየሶራኒ ኩርድኛታይታኛዛርማኛየታችኛው ሶርቢያንኛዱዋላኛጆላ ፎንያኛኢቦኛኤፊክፊሊፒንኛጋጋጉዝኛግዕዝ" +
	"ኛየስዊዝ ጀርመንጉስሊኛሃዊያኛየላይኛው ሶርቢያንኛንጎባኛማቻሜኛካብይልካምባማኮንዴካቡቨርዲያኑኮይራ ቺኒካለንጂንኮሚ " +
	"ፔርምያክኮካኒሻምባላባፊያላንጊላኮታሎዚኛሉባ-ሉሏሉኦሉዪያማሳይሜሩሞሪሲየኛማኩዋ ሜቶሜታሞሃውክሙንዳንግናማክዋሲዮንኮሰ" +
	"ሜናዊ ሶቶኑዌርኒያንኮልኛኪቼሮምቦርዋሳምቡሩሳንጉሴናኮይራቦሮ ሴኒታቼልሂትሲዳምኛደቡባዊ ሳሚሉሌ ሳሚኢናሪ ሳሚስኮልት" +
	" ሳሚኮንጎ ስዋሂሊቴሶቴተምትግረክሊንጎንኛቶክ ፒሲንቱምቡካታሳዋቅመካከለኛ አትላስ ታማዚግትያልታወቀ ቋንቋቫይቩንጆሶጋመ" +
	"ደበኛ የሞሮኮ ታማዚግትቋንቋዊ ይዘት አይደለምዘመናዊ መደበኛ ዓረብኛየኦስትሪያ ጀርመንየስዊዝ ከፍተኛ ጀርመንኛየአ" +
	"ውስትራሊያ እንግሊዝኛየካናዳ እንግሊዝኛየብሪቲሽ እንግሊዝኛየአሜሪካ እንግሊዝኛየላቲን አሜሪካ ስፓኒሽየአውሮፓ እስ" +
	"ፓንኛየካናዳ ፈረንሳይኛየስዊዝ ፈረንሳይኛፍሌሚሽየብራዚል ፖርቹጋልኛየአውሮፓ ፖርቹጋልኛሞልዳቫዊናቀለል ያለ ቻይንኛ" +
	"ባህላዊ ቻይንኛ"

// Size: 1234 bytes, 605 elements
var amLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000c, 0x001b, 0x001b, 0x002d, 0x0039, 0x0045, 0x0045,
	0x0051, 0x0060, 0x0060, 0x006f, 0x0084, 0x0093, 0x00a2, 0x00b1,
	0x00c0, 0x00cf, 0x00de, 0x00ed, 0x00fc, 0x010e, 0x011d, 0x011d,
	0x011d, 0x012c, 0x012c, 0x0135, 0x0135, 0x0135, 0x013e, 0x0147,
	0x0153, 0x015c, 0x016e, 0x0174, 0x0180, 0x0192, 0x01a4, 0x01b0,
	0x01c5, 0x01d1, 0x01e0, 0x01e0, 0x01e9, 0x01f2, 0x01fb, 0x020d,
	0x0229, 0x0235, 0x0251, 0x025d, 0x0269, 0x0278, 0x0287, 0x0293,
	0x02a2, 0x02ae, 0x02ae, 0x02c0, 0x02cc, 0x02db, 0x02ea, 0x02ea,
	// Entry 40 - 7F
	0x02ff, 0x0311, 0x0329, 0x0335, 0x0344, 0x0356, 0x0356, 0x036b,
	0x037a, 0x038f, 0x039b, 0x03a7, 0x03b6, 0x03c2, 0x03cb, 0x03cb,
	0x03d7, 0x03e9, 0x0405, 0x0411, 0x041d, 0x041d, 0x042c, 0x043b,
	0x043b, 0x0447, 0x0456, 0x0462, 0x047d, 0x0489, 0x0489, 0x0498,
	0x04a4, 0x04b6, 0x04c9, 0x04d8, 0x04e7, 0x04e7, 0x04f3, 0x0502,
	0x0514, 0x0526, 0x0532, 0x053e, 0x054d, 0x0559, 0x0562, 0x0578,
	0x0584, 0x0584, 0x058a, 0x05ac, 0x05c8, 0x05c8, 0x05c8, 0x05d4,
	0x05e3, 0x05e3, 0x05ef, 0x05fb, 0x0607, 0x0616, 0x0616, 0x0622,
	// Entry 80 - BF
	0x062e, 0x0640, 0x0649, 0x0655, 0x0661, 0x0670, 0x0679, 0x0691,
	0x06a6, 0x06a6, 0x06b5, 0x06c8, 0x06d4, 0x06e3, 0x06f2, 0x06fe,
	0x070a, 0x0713, 0x071f, 0x072b, 0x0737, 0x0743, 0x074c, 0x0758,
	0x0767, 0x0776, 0x0782, 0x078e, 0x079a, 0x07a3, 0x07af, 0x07c1,
	0x07d0, 0x07dc, 0x07e8, 0x07f4, 0x0800, 0x080f, 0x0821, 0x0830,
	0x083c, 0x084b, 0x0854, 0x0863, 0x0872, 0x0872, 0x087e, 0x0887,
	0x0893, 0x08a2, 0x08b1, 0x08bd, 0x08c6, 0x08c6, 0x08d2, 0x08d2,
	0x08d2, 0x08d2, 0x08d2, 0x08db, 0x08db, 0x08db, 0x08db, 0x08db,
	// Entry C0 - FF
	0x08db, 0x08db, 0x08db, 0x08db, 0x08db, 0x08e4, 0x08e4, 0x08e4,
	0x08e4, 0x08e4, 0x08e4, 0x08e4, 0x08ea, 0x08ea, 0x08ea, 0x08ea,
	0x08ea, 0x08ea, 0x08ea, 0x08ea, 0x08ea, 0x08ea, 0x08ea, 0x08ea,
	0x08ea, 0x08ea, 0x08f3, 0x08f3, 0x08f9, 0x08f9, 0x08f9, 0x08f9,
	0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9, 0x08f9,
	0x08f9, 0x08ff, 0x08ff, 0x08ff, 0x08ff, 0x08ff, 0x0908, 0x0908,
	0x0908, 0x0908, 0x0908, 0x0908, 0x0908, 0x0911, 0x0911, 0x0911,
	0x0911, 0x0911, 0x0911, 0x0911, 0x0911, 0x091d, 0x091d, 0x0936,
	// Entry 100 - 13F
	0x0936, 0x0936, 0x0936, 0x0936, 0x0936, 0x0936, 0x0942, 0x0942,
	0x0942, 0x0942, 0x0942, 0x094e, 0x094e, 0x0970, 0x0970, 0x097c,
	0x097c, 0x098f, 0x098f, 0x098f, 0x0998, 0x09a1, 0x09a1, 0x09a1,
	0x09a1, 0x09a1, 0x09a1, 0x09a1, 0x09a1, 0x09a1, 0x09a1, 0x09b0,
	0x09b0, 0x09b0, 0x09b0, 0x09b0, 0x09b0, 0x09b0, 0x09b0, 0x09b0,
	0x09b0, 0x09b3, 0x09bf, 0x09bf, 0x09bf, 0x09bf, 0x09bf, 0x09cb,
	0x09cb, 0x09cb, 0x09cb, 0x09cb, 0x09cb, 0x09cb, 0x09cb, 0x09cb,
	0x09cb, 0x09cb, 0x09e4, 0x09e4, 0x09e4, 0x09f0, 0x09f0, 0x09f0,
	// Entry 140 - 17F
	0x09f0, 0x09fc, 0x09fc, 0x09fc, 0x09fc, 0x09fc, 0x0a1e, 0x0a1e,
	0x0a1e, 0x0a1e, 0x0a1e, 0x0a1e, 0x0a1e, 0x0a1e, 0x0a1e, 0x0a1e,
	0x0a2a, 0x0a36, 0x0a36, 0x0a36, 0x0a36, 0x0a36, 0x0a42, 0x0a42,
	0x0a42, 0x0a4b, 0x0a4b, 0x0a4b, 0x0a4b, 0x0a4b, 0x0a57, 0x0a6c,
	0x0a6c, 0x0a6c, 0x0a6c, 0x0a6c, 0x0a6c, 0x0a7c, 0x0a7c, 0x0a7c,
	0x0a7c, 0x0a8b, 0x0a8b, 0x0aa1, 0x0aaa, 0x0aaa, 0x0aaa, 0x0aaa,
	0x0aaa, 0x0aaa, 0x0aaa, 0x0aaa, 0x0ab6, 0x0abf, 0x0abf, 0x0abf,
	0x0abf, 0x0abf, 0x0ac8, 0x0ac8, 0x0ac8, 0x0ac8, 0x0ac8, 0x0ac8,
	// Entry 180 - 1BF
	0x0ac8, 0x0ad1, 0x0ad1, 0x0ad1, 0x0ada, 0x0ada, 0x0ae7, 0x0ae7,
	0x0ae7, 0x0aed, 0x0aed, 0x0af6, 0x0af6, 0x0af6, 0x0af6, 0x0af6,
	0x0af6, 0x0af6, 0x0af6, 0x0af6, 0x0aff, 0x0aff, 0x0aff, 0x0aff,
	0x0aff, 0x0b05, 0x0b14, 0x0b14, 0x0b24, 0x0b2a, 0x0b2a, 0x0b2a,
	0x0b2a, 0x0b2a, 0x0b36, 0x0b36, 0x0b36, 0x0b45, 0x0b45, 0x0b45,
	0x0b45, 0x0b45, 0x0b45, 0x0b45, 0x0b45, 0x0b45, 0x0b45, 0x0b45,
	0x0b4b, 0x0b4b, 0x0b4b, 0x0b4b, 0x0b4b, 0x0b4b, 0x0b57, 0x0b57,
	0x0b57, 0x0b57, 0x0b57, 0x0b5d, 0x0b70, 0x0b79, 0x0b79, 0x0b79,
	// Entry 1C0 - 1FF
	0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b,
	0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b,
	0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b91, 0x0b91, 0x0b91,
	0x0b91, 0x0b91, 0x0b91, 0x0b91, 0x0b9a, 0x0b9a, 0x0b9a, 0x0b9a,
	0x0b9a, 0x0b9a, 0x0ba0, 0x0ba0, 0x0ba0, 0x0ba0, 0x0bac, 0x0bac,
	0x0bac, 0x0bac, 0x0bac, 0x0bb5, 0x0bb5, 0x0bb5, 0x0bb5, 0x0bb5,
	0x0bbb, 0x0bbb, 0x0bbb, 0x0bd1, 0x0bd1, 0x0bd1, 0x0be0, 0x0be0,
	0x0be0, 0x0bec, 0x0bec, 0x0bec, 0x0bff, 0x0c0c, 0x0c1c, 0x0c2f,
	// Entry 200 - 23F
	0x0c2f, 0x0c2f, 0x0c2f, 0x0c2f, 0x0c2f, 0x0c2f, 0x0c2f, 0x0c2f,
	0x0c2f, 0x0c2f, 0x0c45, 0x0c45, 0x0c45, 0x0c45, 0x0c45, 0x0c45,
	0x0c4b, 0x0c4b, 0x0c54, 0x0c5d, 0x0c5d, 0x0c5d, 0x0c5d, 0x0c6f,
	0x0c6f, 0x0c6f, 0x0c6f, 0x0c6f, 0x0c7f, 0x0c7f, 0x0c7f, 0x0c7f,
	0x0c7f, 0x0c7f, 0x0c8b, 0x0c8b, 0x0c97, 0x0c97, 0x0cc3, 0x0cc3,
	0x0cc3, 0x0cc3, 0x0cdc, 0x0ce2, 0x0ce2, 0x0ce2, 0x0ce2, 0x0ce2,
	0x0ce2, 0x0ce2, 0x0ceb, 0x0ceb, 0x0ceb, 0x0ceb, 0x0ceb, 0x0ceb,
	0x0ceb, 0x0ceb, 0x0ceb, 0x0cf1, 0x0cf1, 0x0cf1, 0x0cf1, 0x0cf1,
	// Entry 240 - 27F
	0x0cf1, 0x0cf1, 0x0cf1, 0x0cf1, 0x0cf1, 0x0cf1, 0x0d1a, 0x0d1a,
	0x0d40, 0x0d40, 0x0d66, 0x0d85, 0x0dae, 0x0dd9, 0x0df8, 0x0e1a,
	0x0e3c, 0x0e62, 0x0e81, 0x0e81, 0x0ea0, 0x0ebf, 0x0ecb, 0x0eed,
	0x0f0f, 0x0f21, 0x0f21, 0x0f3e, 0x0f57,
}

// Size: 9558 bytes
const arLangStr = "" +
	"الأفاريةالأبخازيةالأفستيةالأفريقانيةالأكانيةالأمهريةالأراغونيةالعربيةالأ" +
	"ساميةالأواريةالأيماراالأذربيجانيةالباشكيريةالبيلاروسيةالبلغاريةالبيسلام" +
	"يةالبامباراالبنغاليةالتبتيةالبريتونيةالبوسنيةالكتالانيةالشيشانيةالتشامو" +
	"روالكورسيكيةالكرىالتشيكيةسلافية كنسيةالتشوفاشيالولزيةالدانماركيةالألمان" +
	"يةالمالديفيةالزونخايةالإيوياليونانيةالإنجليزيةالإسبرانتوالإسبانيةالإستو" +
	"نيةلغة الباسكالفارسيةالفلةالفنلنديةالفيجيةالفارويزالفرنسيةالفريزيانالأي" +
	"رلنديةالغيلية الأسكتلنديةالجاليكيةالجوارانيالغوجاراتيةالمنكيةالهوساالعب" +
	"ريةالهنديةالهيري موتوالكرواتيةالهايتيةالهنغاريةالأرمينيةالهيريرواللّغة " +
	"الوسيطةالإندونيسيةالإنترلينجالإيجبوالسيتشيون ييالإينبياكالإيدوالأيسلاند" +
	"يةالإيطاليةالإينكتيتتاليابانيةالجاويةالجورجيةالكونغوالكيكيوالكيونياماال" +
	"كازاخستانيةالكالاليستالخميريةالكاناداالكوريةالكانيوريالكشميريةالكرديةال" +
	"كوميالكورنيةالقرغيزيةاللاتينيةاللوكسمبرجيةالجانداالليمبرجيشيةاللينجالاا" +
	"للاويةاللتوانيةاللبا-كاتانجااللاتفيةالمالاجاشيةالمارشاليةالماوريةالمقدو" +
	"نيةالماليالامالمنغوليةالماراثيلغة الملايوالمالطيةالبورميةالنوروالنديبيل" +
	" الشماليالنيباليةالندونجاالهولنديةالنينورسك النرويجيالبوكمالية النرويجية" +
	"النديبيل الجنوبيالنافاجوالنيانجاالأوكيتانيةالأوجيبواالأوروموالأوريياالأ" +
	"وسيتيكالبنجابيةالباليةالبولنديةالبشتونيةالبرتغاليةالكويتشواالرومانشيةال" +
	"رنديالرومانيةالروسيةالكينياروانداالسنسكريتيةالسردينيةالسنديةالسامي الشم" +
	"اليالسانجوالسنهاليةالسلوفاكيةالسلوفانيةالساموائيةالشوناالصوماليةالألبان" +
	"يةالصربيةالسواتيالسوتو الجنوبيةالسوندانيةالسويديةالسواحليةالتاميليةالتي" +
	"لجوالطاجيكيةالتايلانديةالتغرينيةالتركمانيةالتسوانيةالتونغيةالتركيةالسون" +
	"جاالتتاريةالتاهيتيةالأغوريةالأوكرانيةالأرديةالأوزبكيةالفينداالفيتناميةل" +
	"غة الفولابوكالولونيةالولوفالخوسااليديشيةاليوروبيةالزهيونجالصينيةالزولوا" +
	"لأتشينيزيةالأكوليةالأدانجميةالأديغةالأفريهيليةالأغمالآينويةالأكاديةالأل" +
	"يوتيةالألطائية الجنوبيةالإنجليزية القديمةالأنجيكاالآراميةالأروكانيةالأر" +
	"اباهوالأراواكيةالآسوالأستريةالأواديةالبلوشيةاللغة الباليةالباسابامنلغة " +
	"الغومالاالبيجاالبيمبابينالغة البافوتالبهوجبوريةالبيكوليةالبينيةلغة الكو" +
	"مالسيكسيكيةالبراجيةالبودوأكوسالبرياتيةالبجينيزيةلغة البولوالبلينيةلغة ا" +
	"لميدومباالكادوالكاريبيةالكايوجيةالأتسامالسيبونيةتشيغاالتشيبشاالتشاجاتاي" +
	"التشكيزيةالماريالشينوك جارجونالشوكتوالشيباوايانالشيروكيالشايانالسورانية" +
	" الكرديةالقبطيةلغة تتار القرمالكاشبايانالداكوتاالدارجواتيتاالديلويرالسلا" +
	"فيةالدوجريبالدنكاالزارميةالدوجريةالصربية السفلىالديولاالهولندية الوسطىج" +
	"ولا فونياالدايلاالقرعانيةإمبوالإفيكالمصرية القديمةالإكاجكالإمايتالإنجلي" +
	"زية الوسطىالإيوندوالفانجالفلبينيةالفونالفرنسية الوسطىالفرنسية القديمةال" +
	"فريزينية الشماليةالفريزينية الشرقيةالفريلايانالجاالغاغوزالجايوالجبياالج" +
	"عزيةلغة أهل جبل طارقالألمانية العليا الوسطىالألمانية العليا القديمةالجن" +
	"ديالجورونتالوالقوطيةالجريبواليونانية القديمةالألمانية السويسريةالغيزيةغ" +
	"وتشنالهيدالغة أهل الهاوايالهيليجينونالحثيةالهمونجيةالصربية العلياالهباا" +
	"لإيبانالإيبيبيويةالإيلوكوالإنجوشيةاللوجباننغومباالماتشاميةالفارسية اليه" +
	"وديةالعربية اليهوديةالكارا-كالباكالقبيليةالكاتشينالجوالكامباالكويالكابا" +
	"ردايانكانمبوالتايابيةماكوندهكابوفيرديانوالكوروالكازيةالخوتانيزكويرا تشي" +
	"نيكالينجينالكيمبندوكومي-بيرماياكالكونكانيةالكوسراينالكبيلالكاراتشاي-بال" +
	"كارالكاريليةالكوروخشامبالالغة البافيالغة الكولونيانالقموقيةالكتيناياللا" +
	"دينولانجياللاهندااللامباالليزجيةلاكوتامنغولىاللوزياللبا-لؤلؤاللوسينوالل" +
	"وندااللوالميزولغة اللوياالمادريزالماجاالمايثيليالماكاسارالماندينغالماسا" +
	"يماباالموكشاالماندارالميندالميروالمورسيانيةالأيرلندية الوسطىماخاوا-ميتو" +
	"ميتاالميكماكيونيةالمينانجكاباوالمانشوالمانيبوريةالموهوكالموسيمندنجلغات " +
	"متعددةالكريكالميرانديزالمارواريةالأرزيةاللغة النابوليةلغة الناماالألمان" +
	"ية السفلىالنواريةالنياسالنيويكواسيولغة النجيمبونالنوجايالنورس القديمأنك" +
	"والسوتو الشماليةالنويرالنوارية التقليديةالنيامويزيالنيانكولالنيوروالنزي" +
	"ماالأوساجالتركية العثمانيةالبانجاسينانالبهلويةالبامبانجاالبابيامينتوالب" +
	"الوانالفارسية القديمةالفينيقيةالبوهنبيايانالبروفانسية القديمةكيشيالراجا" +
	"سثانيةالرابانيالراروتونجانيالرومبوغجريالأرومانيانالرواالسانداويالساخيةا" +
	"لآرامية السامريةسامبوروالساساكالسانتالينامبيسانغوالصقليةالأسكتلنديةالسن" +
	"يكاسيناالسيلكبكويرابورو سينيالأيرلندية القديمةتشلحيتالشانيةالعربية التش" +
	"اديةالسيداموالسامي الجنوبياللول ساميالإيناري ساميالسكولت ساميالسونينكال" +
	"سوجدينالسرانان تونجوالسررلغة الساهوالسوكوماالسوسوالسوماريةالقمريةلغة ال" +
	"كونغو السواحليةسريانية تقليديةالسريانيةالتيمنتيسوالتيرينوالتيتمالتغريةا" +
	"لتيفالتوكيلاوالكلينجونالتلينغيتيةالتاماشيكتونجا - نياساالتوك بيسينلغة ا" +
	"لتاروكوالتسيمشيانالتامبوكاالتوفالوتاساواقالتوفيةالأمازيغية وسط الأطلسال" +
	"أدمرتاليجاريتيكالأمبندوالجذرالفايالفوتيكالفونجوالوالسرالولاياتاالوارايا" +
	"لواشوالكالميكالسوغاالياواليابيزيانجبنيمباالكَنْتُونيةالزابوتيكرموز المع" +
	"ايير الأساسيةالزيناجاالتمازيغية المغربية القياسيةالزونيةبدون محتوى لغوي" +
	"زازاالعربية الرسمية الحديثةالألمانية النمساويةالألمانية العليا السويسري" +
	"ةالإنجليزية الأستراليةالإنجليزية الكنديةالإنجليزية البريطانيةالإنجليزية" +
	" الولايات المتحدةالإسبانية أمريكا اللاتينيةالإسبانية الأوروبيةالإسبانية " +
	"المكسيكيةالفرنسية الكنديةالفرنسية السويسريةالفلمنكيةالبرتغالية البرازيل" +
	"يةالبرتغالية الأوروبيةالمولدوفيةصربية-كرواتيةالصينية المبسطةالصينية الت" +
	"قليدية"

// Size: 1234 bytes, 605 elements
var arLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0010, 0x0022, 0x0032, 0x0048, 0x0058, 0x0068, 0x007c,
	0x008a, 0x009a, 0x00aa, 0x00ba, 0x00d2, 0x00e6, 0x00fc, 0x010e,
	0x0122, 0x0134, 0x0146, 0x0154, 0x0168, 0x0178, 0x018c, 0x019e,
	0x01b0, 0x01c4, 0x01ce, 0x01de, 0x01f5, 0x0207, 0x0215, 0x022b,
	0x023d, 0x0251, 0x0263, 0x026f, 0x0281, 0x0295, 0x02a9, 0x02bb,
	0x02cd, 0x02e0, 0x02f0, 0x02fa, 0x030c, 0x031a, 0x032a, 0x033a,
	0x034c, 0x0360, 0x0385, 0x0397, 0x03a9, 0x03bf, 0x03cd, 0x03d9,
	0x03e7, 0x03f5, 0x040a, 0x041c, 0x042c, 0x043e, 0x0450, 0x0460,
	// Entry 40 - 7F
	0x047b, 0x0491, 0x04a5, 0x04b3, 0x04ca, 0x04dc, 0x04e8, 0x04fe,
	0x0510, 0x0524, 0x0536, 0x0544, 0x0554, 0x0562, 0x0570, 0x0584,
	0x059e, 0x05b2, 0x05c2, 0x05d2, 0x05e0, 0x05f2, 0x0604, 0x0612,
	0x061e, 0x062e, 0x0640, 0x0652, 0x066a, 0x0678, 0x0690, 0x06a2,
	0x06b0, 0x06c2, 0x06db, 0x06eb, 0x0701, 0x0715, 0x0725, 0x0737,
	0x074b, 0x075d, 0x076d, 0x0782, 0x0792, 0x07a2, 0x07ae, 0x07cd,
	0x07df, 0x07ef, 0x0801, 0x0824, 0x084b, 0x086a, 0x087a, 0x088a,
	0x08a0, 0x08b2, 0x08c2, 0x08d2, 0x08e4, 0x08f6, 0x0904, 0x0916,
	// Entry 80 - BF
	0x0928, 0x093c, 0x094e, 0x0962, 0x096e, 0x0980, 0x098e, 0x09a8,
	0x09be, 0x09d0, 0x09de, 0x09f9, 0x0a07, 0x0a19, 0x0a2d, 0x0a41,
	0x0a55, 0x0a61, 0x0a73, 0x0a85, 0x0a93, 0x0aa1, 0x0abe, 0x0ad2,
	0x0ae2, 0x0af4, 0x0b06, 0x0b14, 0x0b26, 0x0b3c, 0x0b4e, 0x0b62,
	0x0b74, 0x0b84, 0x0b92, 0x0ba0, 0x0bb0, 0x0bc2, 0x0bd2, 0x0be6,
	0x0bf4, 0x0c06, 0x0c14, 0x0c28, 0x0c41, 0x0c51, 0x0c5d, 0x0c69,
	0x0c79, 0x0c8b, 0x0c9b, 0x0ca9, 0x0cb5, 0x0ccb, 0x0cdb, 0x0cef,
	0x0cfd, 0x0cfd, 0x0d13, 0x0d1d, 0x0d2d, 0x0d3d, 0x0d3d, 0x0d4f,
	// Entry C0 - FF
	0x0d4f, 0x0d72, 0x0d95, 0x0da5, 0x0db5, 0x0dc9, 0x0dc9, 0x0ddb,
	0x0ddb, 0x0def, 0x0def, 0x0def, 0x0df9, 0x0df9, 0x0e09, 0x0e09,
	0x0e19, 0x0e19, 0x0e29, 0x0e42, 0x0e42, 0x0e4e, 0x0e56, 0x0e56,
	0x0e6d, 0x0e79, 0x0e87, 0x0e87, 0x0e8f, 0x0ea4, 0x0ea4, 0x0eba,
	0x0ecc, 0x0eda, 0x0eda, 0x0eeb, 0x0eff, 0x0eff, 0x0eff, 0x0f0f,
	0x0f0f, 0x0f1b, 0x0f23, 0x0f35, 0x0f49, 0x0f5c, 0x0f6c, 0x0f85,
	0x0f91, 0x0fa3, 0x0fb5, 0x0fc3, 0x0fd5, 0x0fdf, 0x0fef, 0x1003,
	0x1015, 0x1021, 0x103c, 0x104a, 0x1060, 0x1070, 0x107e, 0x109f,
	// Entry 100 - 13F
	0x10ad, 0x10ad, 0x10c7, 0x10db, 0x10eb, 0x10fb, 0x1103, 0x1113,
	0x1123, 0x1133, 0x113f, 0x114f, 0x115f, 0x117a, 0x117a, 0x1188,
	0x11a7, 0x11ba, 0x11c8, 0x11da, 0x11e2, 0x11ee, 0x11ee, 0x120b,
	0x1219, 0x1227, 0x1248, 0x1248, 0x1258, 0x1258, 0x1264, 0x1276,
	0x1276, 0x1280, 0x1280, 0x129d, 0x12bc, 0x12bc, 0x12e1, 0x1304,
	0x1318, 0x1320, 0x132e, 0x132e, 0x133a, 0x1346, 0x1346, 0x1354,
	0x1371, 0x1371, 0x139d, 0x13cb, 0x13cb, 0x13d7, 0x13ed, 0x13fb,
	0x1409, 0x142a, 0x144f, 0x144f, 0x144f, 0x145d, 0x1467, 0x1473,
	// Entry 140 - 17F
	0x1473, 0x148f, 0x148f, 0x14a5, 0x14b1, 0x14c3, 0x14de, 0x14de,
	0x14e8, 0x14f6, 0x150c, 0x151c, 0x152e, 0x152e, 0x152e, 0x153e,
	0x154a, 0x155e, 0x157f, 0x159e, 0x159e, 0x15b7, 0x15c7, 0x15d7,
	0x15df, 0x15ed, 0x15f7, 0x160f, 0x161b, 0x162d, 0x163b, 0x1653,
	0x1653, 0x165f, 0x165f, 0x166d, 0x167f, 0x1694, 0x1694, 0x1694,
	0x1694, 0x16a4, 0x16b6, 0x16cf, 0x16e3, 0x16f5, 0x1701, 0x1722,
	0x1722, 0x1722, 0x1734, 0x1742, 0x1750, 0x1765, 0x1780, 0x1790,
	0x17a0, 0x17b0, 0x17ba, 0x17ca, 0x17d8, 0x17e8, 0x17e8, 0x17e8,
	// Entry 180 - 1BF
	0x17e8, 0x17f4, 0x17f4, 0x1800, 0x180c, 0x180c, 0x181f, 0x182f,
	0x183d, 0x1845, 0x1851, 0x1864, 0x1864, 0x1864, 0x1874, 0x1874,
	0x1880, 0x1892, 0x18a4, 0x18b6, 0x18c4, 0x18cc, 0x18da, 0x18ea,
	0x18f6, 0x1902, 0x1918, 0x1939, 0x194e, 0x1956, 0x1970, 0x198a,
	0x1998, 0x19ae, 0x19bc, 0x19c8, 0x19c8, 0x19d2, 0x19e7, 0x19f3,
	0x1a07, 0x1a1b, 0x1a1b, 0x1a1b, 0x1a29, 0x1a29, 0x1a29, 0x1a46,
	0x1a59, 0x1a78, 0x1a88, 0x1a94, 0x1aa0, 0x1aa0, 0x1aac, 0x1ac5,
	0x1ad3, 0x1aec, 0x1aec, 0x1af4, 0x1b11, 0x1b1d, 0x1b40, 0x1b54,
	// Entry 1C0 - 1FF
	0x1b66, 0x1b74, 0x1b82, 0x1b90, 0x1bb1, 0x1bc9, 0x1bd9, 0x1bed,
	0x1c05, 0x1c15, 0x1c15, 0x1c15, 0x1c15, 0x1c34, 0x1c34, 0x1c46,
	0x1c46, 0x1c46, 0x1c5e, 0x1c5e, 0x1c83, 0x1c8b, 0x1c8b, 0x1ca3,
	0x1cb3, 0x1ccd, 0x1ccd, 0x1ccd, 0x1cdb, 0x1ce3, 0x1ce3, 0x1ce3,
	0x1ce3, 0x1cf9, 0x1d03, 0x1d15, 0x1d23, 0x1d44, 0x1d52, 0x1d60,
	0x1d72, 0x1d72, 0x1d7c, 0x1d86, 0x1d94, 0x1daa, 0x1daa, 0x1db8,
	0x1dc0, 0x1dc0, 0x1dce, 0x1de9, 0x1e0c, 0x1e0c, 0x1e18, 0x1e26,
	0x1e45, 0x1e55, 0x1e55, 0x1e55, 0x1e70, 0x1e83, 0x1e9c, 0x1eb3,
	// Entry 200 - 23F
	0x1ec3, 0x1ed3, 0x1eee, 0x1ef8, 0x1f0b, 0x1f0b, 0x1f1b, 0x1f27,
	0x1f39, 0x1f47, 0x1f6f, 0x1f8c, 0x1f9e, 0x1f9e, 0x1f9e, 0x1faa,
	0x1fb2, 0x1fc2, 0x1fce, 0x1fdc, 0x1fe6, 0x1ff8, 0x1ff8, 0x200a,
	0x2020, 0x2020, 0x2032, 0x2049, 0x205e, 0x205e, 0x2075, 0x2075,
	0x2089, 0x2089, 0x209b, 0x20ab, 0x20b9, 0x20c7, 0x20ef, 0x20fd,
	0x2111, 0x2121, 0x212b, 0x2135, 0x2135, 0x2135, 0x2135, 0x2135,
	0x2143, 0x2143, 0x2151, 0x215f, 0x2171, 0x217f, 0x218b, 0x218b,
	0x218b, 0x219b, 0x219b, 0x21a7, 0x21b1, 0x21bf, 0x21cb, 0x21d3,
	// Entry 240 - 27F
	0x21d3, 0x21eb, 0x21fd, 0x2227, 0x2227, 0x2237, 0x226d, 0x227b,
	0x2297, 0x229f, 0x22cb, 0x22f0, 0x2322, 0x234b, 0x236e, 0x2397,
	0x23cb, 0x23fd, 0x2422, 0x2447, 0x2466, 0x2489, 0x249b, 0x24c4,
	0x24eb, 0x24ff, 0x2518, 0x2535, 0x2556,
}

// Size: 4672 bytes
const azLangStr = "" +
	"afarcaabxazavestancaafrikaansakancaamhararagoncaərəbassamavarikcəaymarca" +
	"azərbaycanbaşqırdbelarusbolqarbislama dilibambarabenqaltibetBretoncabosn" +
	"iakkatalançeçen diliçamoro dilikorsikakri diliçexkilsə slav diliçuvaş di" +
	"liuelsdanimarkaalmandiveh dilidzonqaeveyunaningilisesperantoispanestonba" +
	"skfarsfula dilifinficifarerfransızqərbi frizirlandskot gaelik diliqalisi" +
	"anquaraniqucaratmankshausaivrithindihiri motu dilixorvathaitimacarerməni" +
	"Herer diliinterlingua diliindonezinterlingue diliiqbosiçuan yiinupiaq di" +
	"liido diliislanditalyaninuktitutyaponyavagürcükonqo dilikikuyukuanyama d" +
	"iliqazaxkalaallisutkxmerkannadakoreyakanur dilikaşmirkürdkomi dilikornqı" +
	"rğızlatınlüksemburqqandalimburqiş dililinqalalaoslitvaluba-katanqalatışm" +
	"alaqasmarşal dilimaorimakedonmalayalammonqolmaratimalaymaltabirmanauru d" +
	"ilişimali ndebelenepalnqonka dilihollandnünorsk norveçbokmal norveçcənub" +
	" ndebele dilinavayo dilinyanca dilioksitancaocibva dilioromooriyaosetik " +
	"dilipəncabpali dilipolyakpuştuportuqalkeçuaretoromanrundirumınruskinyarv" +
	"andasanskritsardin dilisindhişimali samisanqosinhalslovakslovensamoa dil" +
	"işonasomalialbanserbsvati diliSesoto dilisudanisveçsuahilitamilteluqutac" +
	"iktaytiqrintürkmənsvana dilitonqatürksonqa dilitatartaxiti diliuyğurukra" +
	"ynaurduözbəkvenda dilivyetnamvolapük dilivalun dilivolofxosaYahudi diliy" +
	"orubajuənq diliçinzuluakin diliakoli diliadangme diliaduge diliafrihili " +
	"diliaqhemaynucaakadiancaaleutcacənub altay diliqədimi ingiliscəangikə di" +
	"liaramik diliaraukancaarapaho diliaravakçaasuasturicəavadicəbaluc diliba" +
	"lincəbasa dilibeja dilibembabenabxoçpuri dilibikolcabini dilisiksikə dil" +
	"ibraj dilibodoburyat dilibugin dilibilincəkado dilikarib diliatsamcakebu" +
	"ano diliçiqaçibçə diliçağatay diliçukiz dilimari diliçinuk ləhçəsiçoktau" +
	" diliçipevyan diliçirokiçeyen dilisorani kürdkopt dilikrım türkçəkaşubya" +
	"n dilidakota dilidarqva dilitaitadelaver dilislaveydoqrib dilidinka dili" +
	"zarmadoqri diliaşağı sorbdualaortacaq hollandcadioladyula diliembuefik d" +
	"iliqədimi misir diliekacuk dilielamit diliortacaq ingiliscəevondo dilifa" +
	"ng dilifilippinfon diliortacaq fransızcaqədimi fransızcaşimal fris dilif" +
	"riul diliqa diliqaqauzqayo diliqabaya diliqez diliqilbert giliortacaq yü" +
	"ksək almancaqədimi almancaqondi diliqorontalo diligotçaqrebo diliqədimi " +
	"yunancaİsveçrə almancasıqusiqviçin dilihayda dilihavayhiliqaynon dilihit" +
	"tit dilimonq diliyuxarı sorbhupa diliiban diliiloko diliinquş dililoğban" +
	" dilinqombamaçamjudo-farscajude-ərəbcəqara-qalpaq dilikabilekaçincaju di" +
	"likambakavi dilikabardcatiyap dilimakondkabuverdiankoro dilixazi dilixot" +
	"an dilikoyra çiinikalencinkimbundu dilikomi-permyakkonkankosreyan dilikp" +
	"elle diliqaraçay-balkar dilikarelyan dilikurux dilişambalabafiakumuk dil" +
	"ikutenay dililadin dililangilaxnda dililamba dililəzqi dililakotamonqo d" +
	"ililozi dililuba-lulua dililuyseno dililunda dililuolushaycaluyiamaduriz" +
	" dilimaqahi dilimaitili dilimakasar diliməndinqo dilimasaymokşa dilimand" +
	"ar dilimende dilimerumorisienortacaq irlandcamaxuva-meettometa’mikmak di" +
	"liminanqkaban dilimançu dilimanipüri dilimohavkmosi dilimundanqdigər dil" +
	"lərkrik dilimirand dilimaruari dilierzya dilineapolital dilinamaaşağı al" +
	"mancanevari dilinyas diliniyuan dilikvasionoqay diliqədimi norscanqoşima" +
	"l soto dilinuernyamvezi dilinyankolniyoro dilinizima diliosage diliosman" +
	" dilipanqasinan dilipaxlavi dilipampanqa dilipapyamento dilipalayancaqəd" +
	"imi farscafoyenik diliponpeyan diliqədimi provensialcakiçeracastan dilir" +
	"apanu dilirarotonqan diliromboroman diliaromancaruasandave diliyakut dil" +
	"isamaritan dilisamburusasak dilisantal dilisanqusisili diliskots dilisen" +
	"aselkup dilikoyraboro senniqədimi irlandcataçelitşan dilisidamo dilicənu" +
	"bi samilule samiinari samiskoltsoninke dilisoqdiyen dilisranan tonqo dil" +
	"iserer diliisukuma dilisusu dilisumeryan diliKonqo suahilicəsisiryak dil" +
	"itimne dilitesotereno dilitetum dilitiqre dilitiv dilitokelay diliklinqo" +
	"ntlinqit dilitamaşek diliniyasa tonga dilitok pisin dilisimşyan dilitumb" +
	"uka dilituvalu dilitasavaqtuvinyan diliMərkəzi Atlas tamazicəsiudmurt di" +
	"liuqaritik diliumbundu dilirut dilivaivotik dilivunyovalamo dilivaray di" +
	"livaşo dilikalmıqcasoqayao diliyapiz dilizapotek diliblisimbols dilizena" +
	"qa dilitamazizuni dilidil məzmunu yoxdurzaza diliModern Standart ƏrəbcəA" +
	"vstriya almancasıİsveçrə yüksək almancasıAvstraliya ingiliscəsiKanada in" +
	"giliscəsiBritaniya ingiliscəsiAmerika ingiliscəsiLatın Amerikası ispanca" +
	"sıKastiliya ispancasıMeksika ispancasıKanada fransızcasıİsveçrə fransızc" +
	"asıflamandBraziliya portuqalcasıPortuqaliya portuqalcasımoldavserb-xorva" +
	"tcasadələşmiş çinənənəvi çin"

// Size: 1234 bytes, 605 elements
var azLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0006, 0x000b, 0x0014, 0x001d, 0x0023, 0x0028, 0x0030,
	0x0036, 0x003b, 0x0044, 0x004b, 0x0056, 0x005f, 0x0066, 0x006c,
	0x0078, 0x007f, 0x0085, 0x008a, 0x0092, 0x0099, 0x00a0, 0x00ac,
	0x00b8, 0x00bf, 0x00c7, 0x00cb, 0x00db, 0x00e7, 0x00eb, 0x00f4,
	0x00f9, 0x0103, 0x0109, 0x010c, 0x0111, 0x0118, 0x0121, 0x0126,
	0x012b, 0x012f, 0x0133, 0x013c, 0x013f, 0x0143, 0x0148, 0x0150,
	0x015b, 0x0161, 0x0171, 0x0179, 0x0180, 0x0187, 0x018c, 0x0191,
	0x0196, 0x019b, 0x01a9, 0x01af, 0x01b4, 0x01b9, 0x01c0, 0x01ca,
	// Entry 40 - 7F
	0x01da, 0x01e1, 0x01f1, 0x01f5, 0x01ff, 0x020b, 0x0213, 0x0219,
	0x0220, 0x0229, 0x022e, 0x0232, 0x0239, 0x0243, 0x0249, 0x0256,
	0x025b, 0x0266, 0x026b, 0x0272, 0x0278, 0x0282, 0x0289, 0x028e,
	0x0297, 0x029b, 0x02a4, 0x02aa, 0x02b5, 0x02ba, 0x02c9, 0x02d0,
	0x02d4, 0x02d9, 0x02e5, 0x02ec, 0x02f3, 0x02ff, 0x0304, 0x030b,
	0x0314, 0x031a, 0x0320, 0x0325, 0x032a, 0x032f, 0x0339, 0x0348,
	0x034d, 0x0358, 0x035f, 0x036f, 0x037d, 0x0390, 0x039b, 0x03a6,
	0x03af, 0x03ba, 0x03bf, 0x03c4, 0x03cf, 0x03d6, 0x03df, 0x03e5,
	// Entry 80 - BF
	0x03eb, 0x03f3, 0x03f9, 0x0402, 0x0407, 0x040d, 0x0410, 0x041b,
	0x0423, 0x042e, 0x0434, 0x0440, 0x0445, 0x044b, 0x0451, 0x0457,
	0x0461, 0x0466, 0x046c, 0x0471, 0x0475, 0x047f, 0x048a, 0x048f,
	0x0495, 0x049c, 0x04a1, 0x04a7, 0x04ac, 0x04af, 0x04b5, 0x04be,
	0x04c8, 0x04cd, 0x04d2, 0x04dc, 0x04e1, 0x04ec, 0x04f2, 0x04f9,
	0x04fd, 0x0504, 0x050e, 0x0515, 0x0522, 0x052c, 0x0531, 0x0535,
	0x0540, 0x0546, 0x0551, 0x0555, 0x0559, 0x0562, 0x056c, 0x0578,
	0x0582, 0x0582, 0x058f, 0x0594, 0x059a, 0x05a3, 0x05a3, 0x05aa,
	// Entry C0 - FF
	0x05aa, 0x05bb, 0x05cd, 0x05d9, 0x05e4, 0x05ed, 0x05ed, 0x05f9,
	0x05f9, 0x0602, 0x0602, 0x0602, 0x0605, 0x0605, 0x060e, 0x060e,
	0x0616, 0x0616, 0x0620, 0x0628, 0x0628, 0x0631, 0x0631, 0x0631,
	0x0631, 0x063a, 0x063f, 0x063f, 0x0643, 0x0643, 0x0643, 0x0651,
	0x0658, 0x0661, 0x0661, 0x0661, 0x066e, 0x066e, 0x066e, 0x0677,
	0x0677, 0x067b, 0x067b, 0x0686, 0x0690, 0x0690, 0x0698, 0x0698,
	0x06a1, 0x06ab, 0x06ab, 0x06b2, 0x06be, 0x06c3, 0x06d0, 0x06de,
	0x06e9, 0x06f2, 0x0703, 0x070f, 0x071d, 0x0724, 0x072f, 0x073b,
	// Entry 100 - 13F
	0x0744, 0x0744, 0x0753, 0x0761, 0x076c, 0x0777, 0x077c, 0x0788,
	0x078e, 0x0799, 0x07a3, 0x07a8, 0x07b2, 0x07bf, 0x07bf, 0x07c4,
	0x07d5, 0x07da, 0x07e4, 0x07e4, 0x07e8, 0x07f1, 0x07f1, 0x0803,
	0x080e, 0x0819, 0x082b, 0x082b, 0x0836, 0x0836, 0x083f, 0x0847,
	0x0847, 0x084f, 0x084f, 0x0861, 0x0873, 0x0873, 0x0883, 0x0883,
	0x088d, 0x0894, 0x089a, 0x089a, 0x08a3, 0x08ae, 0x08ae, 0x08b6,
	0x08c2, 0x08c2, 0x08da, 0x08e9, 0x08e9, 0x08f3, 0x0901, 0x0907,
	0x0911, 0x0920, 0x0935, 0x0935, 0x0935, 0x0939, 0x0945, 0x094f,
	// Entry 140 - 17F
	0x094f, 0x0954, 0x0954, 0x0963, 0x096e, 0x0977, 0x0983, 0x0983,
	0x098c, 0x0995, 0x0995, 0x099f, 0x09aa, 0x09aa, 0x09aa, 0x09b6,
	0x09bc, 0x09c2, 0x09cd, 0x09db, 0x09db, 0x09eb, 0x09f1, 0x09f9,
	0x0a00, 0x0a05, 0x0a0e, 0x0a16, 0x0a16, 0x0a20, 0x0a26, 0x0a31,
	0x0a31, 0x0a3a, 0x0a3a, 0x0a43, 0x0a4d, 0x0a59, 0x0a59, 0x0a59,
	0x0a59, 0x0a61, 0x0a6e, 0x0a7a, 0x0a80, 0x0a8d, 0x0a98, 0x0aac,
	0x0aac, 0x0aac, 0x0ab9, 0x0ac3, 0x0acb, 0x0ad0, 0x0ad0, 0x0ada,
	0x0ae6, 0x0af0, 0x0af5, 0x0b00, 0x0b0a, 0x0b15, 0x0b15, 0x0b15,
	// Entry 180 - 1BF
	0x0b15, 0x0b1b, 0x0b1b, 0x0b25, 0x0b2e, 0x0b2e, 0x0b3d, 0x0b49,
	0x0b53, 0x0b56, 0x0b5e, 0x0b63, 0x0b63, 0x0b63, 0x0b6f, 0x0b6f,
	0x0b7a, 0x0b86, 0x0b92, 0x0ba0, 0x0ba5, 0x0ba5, 0x0bb0, 0x0bbb,
	0x0bc5, 0x0bc9, 0x0bd1, 0x0be1, 0x0bee, 0x0bf5, 0x0c00, 0x0c10,
	0x0c1b, 0x0c29, 0x0c2f, 0x0c38, 0x0c38, 0x0c3f, 0x0c4d, 0x0c56,
	0x0c61, 0x0c6d, 0x0c6d, 0x0c6d, 0x0c77, 0x0c77, 0x0c77, 0x0c86,
	0x0c8a, 0x0c9a, 0x0ca5, 0x0cae, 0x0cb9, 0x0cb9, 0x0cbf, 0x0cbf,
	0x0cc9, 0x0cd7, 0x0cd7, 0x0cda, 0x0cea, 0x0cee, 0x0cee, 0x0cfb,
	// Entry 1C0 - 1FF
	0x0d02, 0x0d0d, 0x0d18, 0x0d22, 0x0d2c, 0x0d3b, 0x0d47, 0x0d54,
	0x0d63, 0x0d6c, 0x0d6c, 0x0d6c, 0x0d6c, 0x0d7a, 0x0d7a, 0x0d86,
	0x0d86, 0x0d86, 0x0d93, 0x0d93, 0x0da7, 0x0dac, 0x0dac, 0x0db9,
	0x0dc4, 0x0dd3, 0x0dd3, 0x0dd3, 0x0dd8, 0x0de2, 0x0de2, 0x0de2,
	0x0de2, 0x0dea, 0x0ded, 0x0df9, 0x0e03, 0x0e11, 0x0e18, 0x0e22,
	0x0e2d, 0x0e2d, 0x0e2d, 0x0e32, 0x0e3d, 0x0e47, 0x0e47, 0x0e47,
	0x0e4b, 0x0e4b, 0x0e56, 0x0e65, 0x0e75, 0x0e75, 0x0e7d, 0x0e86,
	0x0e86, 0x0e91, 0x0e91, 0x0e91, 0x0e9d, 0x0ea6, 0x0eb0, 0x0eb5,
	// Entry 200 - 23F
	0x0ec1, 0x0ece, 0x0edf, 0x0eea, 0x0eea, 0x0eea, 0x0ef5, 0x0efe,
	0x0f0b, 0x0f0b, 0x0f1d, 0x0f1d, 0x0f28, 0x0f28, 0x0f28, 0x0f32,
	0x0f36, 0x0f41, 0x0f4b, 0x0f55, 0x0f5d, 0x0f69, 0x0f69, 0x0f70,
	0x0f7c, 0x0f7c, 0x0f89, 0x0f9a, 0x0fa8, 0x0fa8, 0x0fa8, 0x0fa8,
	0x0fb5, 0x0fb5, 0x0fc1, 0x0fcc, 0x0fd3, 0x0fe0, 0x0ffb, 0x1006,
	0x1013, 0x101f, 0x1027, 0x102a, 0x102a, 0x102a, 0x102a, 0x102a,
	0x1034, 0x1034, 0x1039, 0x1039, 0x1044, 0x104e, 0x1058, 0x1058,
	0x1058, 0x1061, 0x1061, 0x1065, 0x106d, 0x1077, 0x1077, 0x1077,
	// Entry 240 - 27F
	0x1077, 0x1077, 0x1083, 0x1092, 0x1092, 0x109d, 0x10a3, 0x10ac,
	0x10bf, 0x10c8, 0x10e1, 0x10f4, 0x1112, 0x1129, 0x113c, 0x1152,
	0x1166, 0x1182, 0x1196, 0x11a8, 0x11bc, 0x11d4, 0x11db, 0x11f2,
	0x120b, 0x1211, 0x121e, 0x1231, 0x1240,
}

// Size: 7876 bytes
const bgLangStr = "" +
	"афарабхазкиавестскиафрикансаканамхарскиарагонскиарабскиасамскиаварскиайм" +
	"араазербайджанскибашкирскибеларускибългарскибисламабамбарабенгалскитибе" +
	"тскибретонскибосненскикаталонскичеченскичаморокорсиканскикриичешкицърко" +
	"вно славянскичувашкиуелскидатскинемскидивехидзонхаевегръцкианглийскиесп" +
	"ерантоиспанскиестонскибаскиперсийскифулафинскифиджийскифарьорскифренски" +
	"фризийскиирландскишотландски галскигалисийскигуаранигуджаратиманкскихау" +
	"заивритхиндихири мотухърватскихаитянскиунгарскиарменскихерероинтерлингв" +
	"аиндонезийскиоксиденталигбосъчуански иинупиакидоисландскииталианскиинук" +
	"титутяпонскияванскигрузинскиконгоанскикикуюкванямаказахскигренландскикх" +
	"мерскиканнадакорейскиканурикашмирскикюрдскиКомикорнуолскикиргизкилатинс" +
	"килюксембургскигандалимбургскилингалалаоскилитовскилуба катангалатвийск" +
	"ималгашкимаршалеземаорскимакедонскималаяламмонголскимаратималайскималти" +
	"йскибирманскинаурусеверен ндебеленепалскиндонганидерландскинорвежки нюн" +
	"ошкнорвежки букмолюжен ндебеленавахочинянджаокситанскиоджибваоромоорияо" +
	"сетскипенджабскипалиполскипущупортугалскикечуаретороманскирундирумънски" +
	"рускикиняруандасанкскритскисардинскисиндхисеверносаамскисангосинхалскис" +
	"ловашкисловенскисамоанскишонасомалийскиалбанскисръбскисуазисесутосундан" +
	"скишведскисуахилитамилскителугутаджикскитайскитигринятуркменскитсванато" +
	"нгатурскитсонгататарскитаитянскиуйгурскиукраинскиурдуузбекскивендавиетн" +
	"амскиволапюквалонскиволофксосаидишйорубазуангкитайскизулускиачинскиакол" +
	"иадангмеадигеафрихилиагемайнуакадскиалеутскиюжноалтайскистароанглийскиа" +
	"нгикаарамейскимапучеарапахоаравакасуастурскиавадибалучибалинейскибасабе" +
	"ябембабенабожпурибиколскибинисиксикабраджбодобурятскибугинскибиленскика" +
	"ддокарибскиатсамсебуаночигачибчачагатайчуукмарийскижаргон чинуукчокточи" +
	"ипувскичерокичейенскикюрдски (сорани)коптскикримскотатарскикашубскидако" +
	"тскидаргватаитаделауерслейвидогрибдинкаджермадогридолнолужишкидуаласред" +
	"новековен холандскидиоладиулаембуефикегипетскиекажукеламитскисредновеко" +
	"вен английскиевондофангфилипинскифонсредновековен френскистарофренскисе" +
	"верен фризскиизточен фризскифриулианскигагагаузкигайогбаягиизгилбертски" +
	"средновековен немскистаровисоконемскигондигоронталоготическигребодревно" +
	"гръцкишвейцарски немскигусиигвичинхайдахавайскихилигайнонхитскихмонггор" +
	"нолужишкихупаибанилокоингушетскилоджбаннгомбамачамееврейско-персийскиев" +
	"рейско-арабскикаракалпашкикабилскикачинскижжикамбакавикабардиантуапмако" +
	"ндекабовердианскикорокхасикотскикойра чииникаленджинкимбундукоми-пермяц" +
	"киконканикосраенкпелекарачай-балкарскикарелскикурукшамбалабафиякумикски" +
	"кутенайладинолангилахндаламбалезгинскилакотамонголозилуба-лулуалуисеньо" +
	"лундалуолушаилуямадурскимагахимайтхилимакасармандингомасайскимокшаманда" +
	"рмендемеруморисиенсредновековен ирландскимакуа метометамикмакминангбаум" +
	"анчжурскиманипуримохоукмосимундангмногоезичникрикмирандийскимарвариерзи" +
	"анеаполитанскинамадолносаксонскиневарскиниасниуеанквасионогаистаронорве" +
	"жскинкосеверен сотонуеркласически невариниамвезинианколенуоронзимаоседж" +
	"иотомански турскипангасинанпехлевийскипампангапапиаментупалауанстаропер" +
	"сийскифиникийскипохнпеианпровансалскикичераджастанскирапа нуирапотонган" +
	"ромбоцигански езикарумънскирвасандвеякутскисамаритански арамейскисамбур" +
	"усасаксанталисангусицилианскишотландскисенаселкупкойраборо сенистароирл" +
	"андскиташелхитшансидамоюжносаамскилуле-саамскиинари-саамскисколт-саамск" +
	"исонинкесогдийскисранан тонгосерерсукумасусушумерскикоморскиконгоански " +
	"суахиликласически сирийскисирийскитемнетесотеренотетумтигретивтокелайск" +
	"иклингонтлингиттамашекнианса тонгаток писинцимшианскитумбукатувалуански" +
	"тасавактувинскицентралноатласки тамазигтудмуртскиугаритскиумбундуроотва" +
	"ивотиквунджоваламоварайуашокалмиксогаяояпезекантонскизапотекблис символ" +
	"изенагастандартен марокански тамазигтзунибез лингвистично съдържаниезаз" +
	"асъвременен стандартен арабскиавстрийски немскишвейцарски горногерманск" +
	"иавстралийски английскиканадски английскибритански английскиамерикански" +
	" английскимексикански испанскиканадски френскишвейцарски френскифламандс" +
	"кимолдовскисърбохърватскиопростен китайскитрадиционен китайски"

// Size: 1234 bytes, 605 elements
var bgLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0008, 0x0016, 0x0026, 0x0036, 0x003e, 0x004e, 0x0060,
	0x006e, 0x007c, 0x008a, 0x0096, 0x00b2, 0x00c4, 0x00d6, 0x00e8,
	0x00f6, 0x0104, 0x0116, 0x0126, 0x0138, 0x014a, 0x015e, 0x016e,
	0x017a, 0x0190, 0x0198, 0x01a2, 0x01c5, 0x01d3, 0x01df, 0x01eb,
	0x01f7, 0x0203, 0x020f, 0x0215, 0x0221, 0x0233, 0x0245, 0x0255,
	0x0265, 0x026f, 0x0281, 0x0289, 0x0295, 0x02a7, 0x02b9, 0x02c7,
	0x02d9, 0x02eb, 0x030c, 0x0320, 0x032e, 0x0340, 0x034e, 0x0358,
	0x0362, 0x036c, 0x037d, 0x038f, 0x03a1, 0x03b1, 0x03c1, 0x03cd,
	// Entry 40 - 7F
	0x03e3, 0x03fb, 0x040f, 0x0417, 0x042c, 0x043a, 0x0440, 0x0452,
	0x0466, 0x0478, 0x0486, 0x0494, 0x04a6, 0x04ba, 0x04c4, 0x04d2,
	0x04e2, 0x04f8, 0x0508, 0x0516, 0x0526, 0x0532, 0x0544, 0x0552,
	0x055a, 0x056e, 0x057e, 0x058e, 0x05a8, 0x05b2, 0x05c6, 0x05d4,
	0x05e0, 0x05f0, 0x0607, 0x0619, 0x0629, 0x063b, 0x0649, 0x065d,
	0x066d, 0x067f, 0x068b, 0x069b, 0x06ad, 0x06bf, 0x06c9, 0x06e6,
	0x06f6, 0x0702, 0x071a, 0x0737, 0x0754, 0x076b, 0x0777, 0x0787,
	0x079b, 0x07a9, 0x07b3, 0x07bb, 0x07c9, 0x07dd, 0x07e5, 0x07f1,
	// Entry 80 - BF
	0x07f9, 0x080f, 0x0819, 0x0831, 0x083b, 0x084b, 0x0855, 0x0869,
	0x0881, 0x0893, 0x089f, 0x08bb, 0x08c5, 0x08d7, 0x08e7, 0x08f9,
	0x090b, 0x0913, 0x0927, 0x0937, 0x0945, 0x094f, 0x095b, 0x096d,
	0x097b, 0x0989, 0x0999, 0x09a5, 0x09b7, 0x09c3, 0x09d1, 0x09e5,
	0x09f1, 0x09fb, 0x0a07, 0x0a13, 0x0a23, 0x0a35, 0x0a45, 0x0a57,
	0x0a5f, 0x0a6f, 0x0a79, 0x0a8d, 0x0a9b, 0x0aab, 0x0ab5, 0x0abf,
	0x0ac7, 0x0ad3, 0x0add, 0x0aed, 0x0afb, 0x0b09, 0x0b13, 0x0b21,
	0x0b2b, 0x0b2b, 0x0b3b, 0x0b43, 0x0b4b, 0x0b59, 0x0b59, 0x0b69,
	// Entry C0 - FF
	0x0b69, 0x0b81, 0x0b9d, 0x0ba9, 0x0bbb, 0x0bc7, 0x0bc7, 0x0bd5,
	0x0bd5, 0x0be1, 0x0be1, 0x0be1, 0x0be7, 0x0be7, 0x0bf7, 0x0bf7,
	0x0c01, 0x0c01, 0x0c0d, 0x0c21, 0x0c21, 0x0c29, 0x0c29, 0x0c29,
	0x0c29, 0x0c2f, 0x0c39, 0x0c39, 0x0c41, 0x0c41, 0x0c41, 0x0c4f,
	0x0c5f, 0x0c67, 0x0c67, 0x0c67, 0x0c75, 0x0c75, 0x0c75, 0x0c7f,
	0x0c7f, 0x0c87, 0x0c87, 0x0c97, 0x0ca7, 0x0ca7, 0x0cb7, 0x0cb7,
	0x0cc1, 0x0cd1, 0x0cd1, 0x0cdb, 0x0ce9, 0x0cf1, 0x0cfb, 0x0d09,
	0x0d11, 0x0d21, 0x0d3a, 0x0d44, 0x0d56, 0x0d62, 0x0d72, 0x0d8f,
	// Entry 100 - 13F
	0x0d9d, 0x0d9d, 0x0dbb, 0x0dcb, 0x0ddb, 0x0de7, 0x0df1, 0x0dff,
	0x0e0b, 0x0e17, 0x0e21, 0x0e2d, 0x0e37, 0x0e4f, 0x0e4f, 0x0e59,
	0x0e86, 0x0e90, 0x0e9a, 0x0e9a, 0x0ea2, 0x0eaa, 0x0eaa, 0x0ebc,
	0x0ec8, 0x0eda, 0x0f07, 0x0f07, 0x0f13, 0x0f13, 0x0f1b, 0x0f2f,
	0x0f2f, 0x0f35, 0x0f35, 0x0f5e, 0x0f76, 0x0f76, 0x0f93, 0x0fb0,
	0x0fc6, 0x0fca, 0x0fda, 0x0fda, 0x0fe2, 0x0fea, 0x0fea, 0x0ff2,
	0x1006, 0x1006, 0x102d, 0x104f, 0x104f, 0x1059, 0x106b, 0x107d,
	0x1087, 0x109f, 0x10c0, 0x10c0, 0x10c0, 0x10ca, 0x10d6, 0x10e0,
	// Entry 140 - 17F
	0x10e0, 0x10f0, 0x10f0, 0x1104, 0x1110, 0x111a, 0x1132, 0x1132,
	0x113a, 0x1142, 0x1142, 0x114c, 0x1160, 0x1160, 0x1160, 0x116e,
	0x117a, 0x1186, 0x11a9, 0x11c8, 0x11c8, 0x11e0, 0x11f0, 0x1200,
	0x1206, 0x1210, 0x1218, 0x122a, 0x122a, 0x1232, 0x1240, 0x125c,
	0x125c, 0x1264, 0x1264, 0x126e, 0x127a, 0x128f, 0x128f, 0x128f,
	0x128f, 0x12a1, 0x12b1, 0x12ca, 0x12d8, 0x12e6, 0x12f0, 0x1311,
	0x1311, 0x1311, 0x1321, 0x132b, 0x1339, 0x1343, 0x1343, 0x1353,
	0x1361, 0x136d, 0x1377, 0x1383, 0x138d, 0x139f, 0x139f, 0x139f,
	// Entry 180 - 1BF
	0x139f, 0x13ab, 0x13ab, 0x13b5, 0x13bd, 0x13bd, 0x13d0, 0x13e0,
	0x13ea, 0x13f0, 0x13fa, 0x1400, 0x1400, 0x1400, 0x1410, 0x1410,
	0x141c, 0x142c, 0x143a, 0x144a, 0x145a, 0x145a, 0x1464, 0x1470,
	0x147a, 0x1482, 0x1492, 0x14bf, 0x14d2, 0x14da, 0x14e6, 0x14f8,
	0x150c, 0x151c, 0x1528, 0x1530, 0x1530, 0x153e, 0x1554, 0x155c,
	0x1572, 0x1580, 0x1580, 0x1580, 0x158a, 0x158a, 0x158a, 0x15a4,
	0x15ac, 0x15c8, 0x15d8, 0x15e0, 0x15ec, 0x15ec, 0x15f8, 0x15f8,
	0x1602, 0x161e, 0x161e, 0x1624, 0x163b, 0x1643, 0x1664, 0x1674,
	// Entry 1C0 - 1FF
	0x1684, 0x168e, 0x1698, 0x16a4, 0x16c3, 0x16d7, 0x16ed, 0x16fd,
	0x1711, 0x171f, 0x171f, 0x171f, 0x171f, 0x173b, 0x173b, 0x174f,
	0x174f, 0x174f, 0x1761, 0x1761, 0x1779, 0x1781, 0x1781, 0x1799,
	0x17a8, 0x17bc, 0x17bc, 0x17bc, 0x17c6, 0x17df, 0x17df, 0x17df,
	0x17df, 0x17f1, 0x17f7, 0x1803, 0x1811, 0x183c, 0x184a, 0x1854,
	0x1862, 0x1862, 0x1862, 0x186c, 0x1882, 0x1896, 0x1896, 0x1896,
	0x189e, 0x189e, 0x18aa, 0x18c5, 0x18e1, 0x18e1, 0x18f1, 0x18f7,
	0x18f7, 0x1903, 0x1903, 0x1903, 0x1919, 0x1930, 0x1949, 0x1962,
	// Entry 200 - 23F
	0x1970, 0x1982, 0x1999, 0x19a3, 0x19a3, 0x19a3, 0x19af, 0x19b7,
	0x19c7, 0x19d7, 0x19fa, 0x1a1f, 0x1a2f, 0x1a2f, 0x1a2f, 0x1a39,
	0x1a41, 0x1a4d, 0x1a57, 0x1a61, 0x1a67, 0x1a7b, 0x1a7b, 0x1a89,
	0x1a97, 0x1a97, 0x1aa5, 0x1abc, 0x1acd, 0x1acd, 0x1acd, 0x1acd,
	0x1ae1, 0x1ae1, 0x1aef, 0x1b05, 0x1b13, 0x1b23, 0x1b54, 0x1b66,
	0x1b78, 0x1b86, 0x1b8e, 0x1b94, 0x1b94, 0x1b94, 0x1b94, 0x1b94,
	0x1b9e, 0x1b9e, 0x1baa, 0x1baa, 0x1bb6, 0x1bc0, 0x1bc8, 0x1bc8,
	0x1bc8, 0x1bd4, 0x1bd4, 0x1bdc, 0x1be0, 0x1bea, 0x1bea, 0x1bea,
	// Entry 240 - 27F
	0x1bea, 0x1bfc, 0x1c0a, 0x1c21, 0x1c21, 0x1c2d, 0x1c67, 0x1c6f,
	0x1ca3, 0x1cab, 0x1ce3, 0x1d04, 0x1d35, 0x1d60, 0x1d83, 0x1da8,
	0x1dd1, 0x1dd1, 0x1dd1, 0x1df8, 0x1e17, 0x1e3a, 0x1e4e, 0x1e4e,
	0x1e4e, 0x1e60, 0x1e7c, 0x1e9d, 0x1ec4,
}

// Size: 11736 bytes
const bnLangStr = "" +
	"আফারআবখাজিয়ানআবেস্তীয়আফ্রিকান্সআকানআমহারিকআর্গোনিজআরবীআসামিআভেরিকআয়মা" +
	"রাআজারবাইজানীবাশকিরবেলারুশিয়বুলগেরিয়বিসলামাবামবারাবাংলাতিব্বতিব্রেটন" +
	"বসনীয়ানকাতালানচেচেনচামোরোকর্সিকানক্রিচেকচার্চ স্লাভিকচুবাসওয়েলশডেনিশ" +
	"জার্মানদিবেহিজোঙ্গাএয়েগ্রিকইংরেজিএস্পেরান্তোস্প্যানিশএস্তোনীয়বাস্কফা" +
	"র্সিফুলাহ্ফিনিশফিজিওফেরাউনিফরাসিপশ্চিম ফ্রিসিয়আইরিশস্কটস-গ্যেলিকগ্যাল" +
	"িশিয়গুয়ারানিগুজরাটিম্যাঙ্কসহাউসাহিব্রুহিন্দিহিরি মোতুক্রোয়েশীয়হাইত" +
	"িয়ানহাঙ্গেরীয়আর্মেনিয়হেরেরোইন্টারলিঙ্গুয়াইন্দোনেশীয়ইন্টারলিঙ্গইগ্" +
	"\u200cবোসিচুয়ান য়িইনুপিয়াকইডোআইসল্যান্ডীয়ইতালীয়ইনুক্টিটুটজাপানিজাভা" +
	"নিজর্জিয়ানকঙ্গোকিকু্ইয়ুকোয়ানিয়ামাকাজাখক্যালাল্লিসুটখমেরকান্নাড়ীকো" +
	"রিয়ানকানুরিকাশ্মীরীকুর্দিকোমিকর্ণিশকির্গিজলাটিনলুক্সেমবার্গীয়গান্ডাল" +
	"িম্বুর্গিশলিঙ্গালালাওলিথুয়েনীয়লুবা-কাটাঙ্গালাত্\u200cভীয়মালাগাসিমার" +
	"্শালিজমাওরিম্যাসিডোনীয়মালায়ালামমঙ্গোলিয়মারাঠিমালয়মল্টিয়বর্মিনাউরু" +
	"উত্তর এন্দেবিলিনেপালীএন্দোঙ্গাডাচনরওয়েজীয়ান নিনর্স্কনরওয়েজিয়ান বোক" +
	"মালদক্ষিণ এনডেবেলেনাভাজোনায়াঞ্জাঅক্সিটানওজিবওয়াঅরোমোওড়িয়াওসেটিকপাঞ" +
	"্জাবীপালিপোলিশপাশ্তুপর্তুগীজকেচুয়ারোমান্সরুন্দিরোমানীয়রুশকিনয়ারোয়া" +
	"ন্ডাসংষ্কৃতসার্ডিনিয়ানসিন্ধিউত্তরাঞ্চলীয় সামিসাঙ্গোসিংহলীস্লোভাকস্লো" +
	"ভেনীয়সামোয়ানশোনাসোমালীআলবেনীয়সার্বীয়সোয়াতিদক্ষিন সোথোসুদানীসুইডিশ" +
	"সোয়াহিলিতামিলতেলেগুতাজিকথাইতিগরিনিয়াতুর্কমেনীসোয়ানাটোঙ্গানতুর্কীসঙ্" +
	"গাতাতারতাহিতিয়ানউইঘুরইউক্রেনীয়উর্দুউজবেকীয়ভেন্ডাভিয়েতনামীভোলাপুকওয" +
	"়ালুনউওলোফজোসায়িদ্দিশইওরুবাঝু্য়াঙচীনাজুলুঅ্যাচাইনিজআকোলিঅদাগ্মেআদেগে" +
	"আফ্রিহিলিএঘেমআইনুআক্কাদিয়ানআলেউতদক্ষিন আলতাইপ্রাচীন ইংরেজীআঙ্গিকাআরাম" +
	"াইকমাপুচিআরাপাহোআরাওয়াকআসুআস্তুরিয়আওয়াধিবেলুচীবালিনীয়বাসাবেজাবেম্ব" +
	"াবেনাভোজপুরিবিকোলবিনিসিকসিকাব্রাজবড়োবুরিয়াতবুগিনিব্লিনক্যাডোক্যারিবআ" +
	"ত্সামচেবুয়ানোচিগাচিবচাচাগাতাইচুকিমারিচিনুক জার্গনচকটোওচিপেওয়ানচেরোকী" +
	"শাইয়েনসোরানি কুর্দিশকপটিকক্রিমিয়ান তুর্কিকাশুবিয়ানডাকোটাদার্গওয়াতা" +
	"ইতাডেলাওয়েরস্ল্যাভদোগ্রীবডিংকাজার্মাডোগরিনিম্নতর সোর্বিয়ানদুয়ালামধ্" +
	"য ডাচজলা-ফনীডিউলাএম্বুএফিকপ্রাচীন মিশরীয়ইকাজুকএলামাইটমধ্য ইংরেজিইওন্ড" +
	"োফ্যাঙ্গফিলিপিনোফনমধ্য ফরাসিপ্রাচীন ফরাসিউত্তরাঞ্চলীয় ফ্রিসিয়ানপূর্ব" +
	" ফ্রিসিয়ফ্রিউলিয়ানগাগাগাউজগায়োবায়াগীজগিলবার্টিজমধ্য-উচ্চ জার্মানিপ্র" +
	"াচীন উচ্চ জার্মানিগোন্ডিগোরোন্তালোগথিকগ্রেবোপ্রাচীন গ্রীকসুইস জার্মানগ" +
	"ুসীগওইচ্’ইনহাইডাহাওয়াইয়ানহিলিগ্যায়নোনহিট্টিটহ্\u200cমোঙউচ্চ সোর্বিয" +
	"়ানহুপাইবানইলোকোইঙ্গুশলোজবানগোম্বামাকামেজুদেও ফার্সিজুদেও আরবিকারা-কাল" +
	"্পাককাবাইলেকাচিনঅজ্জুকাম্বাকাউইকাবার্ডিয়ানটাইয়াপমাকোন্দেকাবুভারদিয়া" +
	"নুকোরোখাশিখোটানিজকোয়রা চীনিকালেনজিনকিম্বুন্দুকমি-পারমিআককোঙ্কানিকোস্র" +
	"াইনক্\u200cপেল্লেকারচে-বাল্কারকারেলিয়ানকুরুখশাম্বালাবাফিয়াকুমিককুটেন" +
	"াইলাডিনোলাঙ্গিলান্ডালাম্বালেজঘিয়ানলাকোটামোঙ্গোলোজিলুবা-লুলুয়ালুইসেনো" +
	"লুন্ডালুয়োলুশাইলুইয়ামাদুরেসেমাগাহিমৈথিলিম্যাকাসারম্যান্ডিঙ্গোমাসাইমো" +
	"কশাম্যাণ্ডারমেন্ডেমেরুমরিসিয়ানমধ্য আইরিশমাখুয়া-মেত্তোমেটামিকম্যাকমিন" +
	"াঙ্গ্\u200cকাবাউমাঞ্চুমণিপুরীমোহাওকমসিমুদাঙ্গবহুগুণিতক ভাষাসমূহক্রিকমি" +
	"রান্ডিজমারোয়ারিএরজিয়ানেয়াপোলিটাননামানিম্ন জার্মানিনেওয়ারিনিয়াসনিউ" +
	"য়ানকোয়াসিওনোগাইপ্রাচীন নর্সএন’কোউত্তরাঞ্চলীয় সোথোনুয়ারপ্রাচীন নেওয" +
	"়ারীন্যায়ামওয়েজিন্যায়াঙ্কোলেন্যোরোএন্.জিমাওসেজঅটোমান তুর্কিপাঙ্গাসি" +
	"নানপাহ্লাভিপাম্পাঙ্গাপাপিয়ামেন্টোপালায়ুয়ানপ্রাচীন ফার্সিফোনিশীয়ানপ" +
	"োহ্নপেইয়ানপ্রাচীন প্রোভেনসালকি‘চেরাজস্থানীরাপানুইরারোটোংগানরম্বোরোমান" +
	"িআরমেনিয়ানরাওয়াস্যান্ডাওয়েইয়াকুটসামারিটান আরামিকসামবুরুসাসাকসাঁওতা" +
	"লিসাঙ্গুসিসিলিয়ানস্কটসসেনাসেল্কুপকোয়রাবেনো সেন্নীপ্রাচীন আইরিশতাচেলহ" +
	"িতশানসিডামোদক্ষিণাঞ্চলীয় সামিলুলে সামিইনারি সামিস্কোল্ট সামিসোনিঙ্কেস" +
	"োগডিয়ানস্রানান টোঙ্গোসেরেরসুকুমাসুসুসুমেরীয়কঙ্গো সোয়াহিলিপ্রাচীন সি" +
	"রিওসিরিয়াকটাইম্নেতেসোতেরেনোতেতুমটাইগ্রেটিভটোকেলাউক্লিঙ্গনত্লিঙ্গিটতাম" +
	"াশেকনায়াসা টোঙ্গাটোক পিসিনসিমশিয়ানতুম্বুকাটুভালুতাসাওয়াকটুভিনিয়ানস" +
	"েন্ট্রাল আটলাস তামাজিগাতউডমুর্টউগারিটিকউম্বুন্দুমূলভাইভোটিকভুঞ্জোওয়াল" +
	"ামোওয়ারেওয়াশোকাল্মইকসোগাইয়াওইয়াপেসেজাপোটেকচিত্র ভাষাজেনাগাআদর্শ মর" +
	"ক্কোন তামাজিগাতজুনিভাষাভিত্তিক বিষয়বস্তু নেইজাজাআধুনিক আদর্শ আরবীঅস্ট" +
	"্রিয়ান জারমানসুইস উচ্চ জার্মানিঅস্ট্রেলীয় ইংরেজিকানাডীয় ইংরেজিব্রিট" +
	"িশ ইংরেজিআমেরিকার ইংরেজিল্যাটিন আমেরিকান স্প্যানিশইউরোপীয় স্প্যানিশম্" +
	"যাক্সিকান স্প্যানিশক্যানাডিয়ান ফরাসীসুইস ফরাসিফ্লেমিশব্রাজিলের পর্তুগ" +
	"ীজইউরোপের পর্তুগীজমলদাভিয়সার্বো-ক্রোয়েশিয়সরলীকৃত চীনাঐতিহ্যবাহি চীন" +
	"া"

// Size: 1234 bytes, 605 elements
var bnLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000c, 0x002a, 0x0045, 0x0063, 0x006f, 0x0084, 0x009c,
	0x00a8, 0x00b7, 0x00c9, 0x00de, 0x00ff, 0x0111, 0x012f, 0x014a,
	0x015f, 0x0174, 0x0183, 0x0198, 0x01aa, 0x01c2, 0x01d7, 0x01e6,
	0x01f8, 0x0210, 0x021c, 0x0225, 0x024a, 0x0259, 0x026b, 0x027a,
	0x028f, 0x02a1, 0x02b3, 0x02bf, 0x02ce, 0x02e0, 0x0301, 0x031c,
	0x0337, 0x0346, 0x0358, 0x036a, 0x0379, 0x0388, 0x039d, 0x03ac,
	0x03d7, 0x03e6, 0x040b, 0x0429, 0x0444, 0x0459, 0x0471, 0x0480,
	0x0492, 0x04a4, 0x04bd, 0x04de, 0x04f9, 0x0517, 0x0532, 0x0544,
	// Entry 40 - 7F
	0x0571, 0x0592, 0x05b3, 0x05c5, 0x05e7, 0x0602, 0x060b, 0x0632,
	0x0647, 0x0665, 0x0677, 0x0689, 0x06a4, 0x06b3, 0x06ce, 0x06f2,
	0x0701, 0x0728, 0x0734, 0x074f, 0x0767, 0x0779, 0x0791, 0x07a3,
	0x07af, 0x07c1, 0x07d6, 0x07e5, 0x0812, 0x0824, 0x0845, 0x085d,
	0x0866, 0x0887, 0x08ac, 0x08c7, 0x08df, 0x08fa, 0x0909, 0x092d,
	0x094b, 0x0966, 0x0978, 0x0987, 0x099c, 0x09ab, 0x09ba, 0x09e5,
	0x09f7, 0x0a12, 0x0a1b, 0x0a58, 0x0a8f, 0x0aba, 0x0acc, 0x0ae7,
	0x0aff, 0x0b17, 0x0b26, 0x0b3b, 0x0b4d, 0x0b65, 0x0b71, 0x0b80,
	// Entry 80 - BF
	0x0b92, 0x0baa, 0x0bbf, 0x0bd4, 0x0be6, 0x0bfe, 0x0c07, 0x0c34,
	0x0c49, 0x0c6d, 0x0c7f, 0x0cb3, 0x0cc5, 0x0cd7, 0x0cec, 0x0d0a,
	0x0d22, 0x0d2e, 0x0d40, 0x0d58, 0x0d70, 0x0d85, 0x0da4, 0x0db6,
	0x0dc8, 0x0de3, 0x0df2, 0x0e04, 0x0e13, 0x0e1c, 0x0e3a, 0x0e55,
	0x0e6a, 0x0e7f, 0x0e91, 0x0ea0, 0x0eaf, 0x0ecd, 0x0edc, 0x0efa,
	0x0f09, 0x0f21, 0x0f33, 0x0f51, 0x0f66, 0x0f7b, 0x0f8a, 0x0f96,
	0x0fae, 0x0fc0, 0x0fd5, 0x0fe1, 0x0fed, 0x100b, 0x101a, 0x102f,
	0x103e, 0x103e, 0x1059, 0x1065, 0x1071, 0x1092, 0x1092, 0x10a1,
	// Entry C0 - FF
	0x10a1, 0x10c3, 0x10eb, 0x1100, 0x1115, 0x1127, 0x1127, 0x113c,
	0x113c, 0x1154, 0x1154, 0x1154, 0x115d, 0x115d, 0x1178, 0x1178,
	0x118d, 0x118d, 0x119f, 0x11b7, 0x11b7, 0x11c3, 0x11c3, 0x11c3,
	0x11c3, 0x11cf, 0x11e1, 0x11e1, 0x11ed, 0x11ed, 0x11ed, 0x1202,
	0x1211, 0x121d, 0x121d, 0x121d, 0x1232, 0x1232, 0x1232, 0x1241,
	0x1241, 0x124d, 0x124d, 0x1265, 0x1277, 0x1277, 0x1286, 0x1286,
	0x1298, 0x12ad, 0x12ad, 0x12bf, 0x12da, 0x12e6, 0x12f5, 0x130a,
	0x1316, 0x1322, 0x1344, 0x1353, 0x136e, 0x1380, 0x1395, 0x13bd,
	// Entry 100 - 13F
	0x13cc, 0x13cc, 0x13fd, 0x141b, 0x142d, 0x1448, 0x1457, 0x1472,
	0x1487, 0x149c, 0x14ab, 0x14bd, 0x14cc, 0x1500, 0x1500, 0x1515,
	0x152b, 0x153e, 0x154d, 0x154d, 0x155c, 0x1568, 0x1568, 0x1593,
	0x15a5, 0x15ba, 0x15d9, 0x15d9, 0x15eb, 0x15eb, 0x1600, 0x1618,
	0x1618, 0x161e, 0x161e, 0x163a, 0x165f, 0x165f, 0x16a5, 0x16cd,
	0x16ee, 0x16f4, 0x1706, 0x1706, 0x1715, 0x1724, 0x1724, 0x172d,
	0x174b, 0x174b, 0x177d, 0x17b8, 0x17b8, 0x17ca, 0x17e8, 0x17f4,
	0x1806, 0x182b, 0x184d, 0x184d, 0x184d, 0x1859, 0x1871, 0x1880,
	// Entry 140 - 17F
	0x1880, 0x18a1, 0x18a1, 0x18c8, 0x18dd, 0x18ef, 0x191a, 0x191a,
	0x1926, 0x1932, 0x1932, 0x1941, 0x1953, 0x1953, 0x1953, 0x1965,
	0x1977, 0x1989, 0x19ab, 0x19c7, 0x19c7, 0x19e9, 0x19fe, 0x1a0d,
	0x1a1c, 0x1a2e, 0x1a3a, 0x1a5e, 0x1a5e, 0x1a73, 0x1a8b, 0x1ab5,
	0x1ab5, 0x1ac1, 0x1ac1, 0x1acd, 0x1ae2, 0x1b01, 0x1b01, 0x1b01,
	0x1b01, 0x1b19, 0x1b37, 0x1b56, 0x1b6e, 0x1b86, 0x1ba1, 0x1bc6,
	0x1bc6, 0x1bc6, 0x1be4, 0x1bf3, 0x1c0b, 0x1c20, 0x1c20, 0x1c2f,
	0x1c44, 0x1c56, 0x1c68, 0x1c7a, 0x1c8c, 0x1ca7, 0x1ca7, 0x1ca7,
	// Entry 180 - 1BF
	0x1ca7, 0x1cb9, 0x1cb9, 0x1ccb, 0x1cd7, 0x1cd7, 0x1cf9, 0x1d0e,
	0x1d20, 0x1d2f, 0x1d3e, 0x1d50, 0x1d50, 0x1d50, 0x1d68, 0x1d68,
	0x1d7a, 0x1d8c, 0x1da7, 0x1dcb, 0x1dda, 0x1dda, 0x1de9, 0x1e04,
	0x1e16, 0x1e22, 0x1e3d, 0x1e59, 0x1e81, 0x1e8d, 0x1ea5, 0x1ecf,
	0x1ee1, 0x1ef6, 0x1f08, 0x1f11, 0x1f11, 0x1f26, 0x1f5a, 0x1f69,
	0x1f84, 0x1f9f, 0x1f9f, 0x1f9f, 0x1fb4, 0x1fb4, 0x1fb4, 0x1fd8,
	0x1fe4, 0x200c, 0x2024, 0x2036, 0x204b, 0x204b, 0x2063, 0x2063,
	0x2072, 0x2094, 0x2094, 0x20a3, 0x20d7, 0x20e9, 0x2117, 0x2141,
	// Entry 1C0 - 1FF
	0x2168, 0x217a, 0x2190, 0x219c, 0x21c1, 0x21e2, 0x21fa, 0x2218,
	0x223f, 0x2260, 0x2260, 0x2260, 0x2260, 0x2288, 0x2288, 0x22a6,
	0x22a6, 0x22a6, 0x22ca, 0x22ca, 0x22fe, 0x230d, 0x230d, 0x2328,
	0x233d, 0x235b, 0x235b, 0x235b, 0x236a, 0x237c, 0x237c, 0x237c,
	0x237c, 0x239a, 0x23ac, 0x23d0, 0x23e5, 0x2413, 0x2428, 0x2437,
	0x244f, 0x244f, 0x244f, 0x2461, 0x247f, 0x248e, 0x248e, 0x248e,
	0x249a, 0x249a, 0x24af, 0x24e0, 0x2505, 0x2505, 0x251d, 0x2526,
	0x2526, 0x2538, 0x2538, 0x2538, 0x256f, 0x2588, 0x25a4, 0x25c6,
	// Entry 200 - 23F
	0x25de, 0x25f9, 0x2621, 0x2630, 0x2630, 0x2630, 0x2642, 0x264e,
	0x2666, 0x2666, 0x2691, 0x26b6, 0x26ce, 0x26ce, 0x26ce, 0x26e3,
	0x26ef, 0x2701, 0x2710, 0x2725, 0x272e, 0x2743, 0x2743, 0x275b,
	0x2776, 0x2776, 0x278b, 0x27b3, 0x27cc, 0x27cc, 0x27cc, 0x27cc,
	0x27e7, 0x27e7, 0x27ff, 0x2811, 0x282c, 0x284a, 0x2891, 0x28a6,
	0x28be, 0x28d9, 0x28e2, 0x28eb, 0x28eb, 0x28eb, 0x28eb, 0x28eb,
	0x28fa, 0x28fa, 0x290c, 0x290c, 0x2924, 0x2936, 0x2948, 0x2948,
	0x2948, 0x295d, 0x295d, 0x2969, 0x2978, 0x2990, 0x2990, 0x2990,
	// Entry 240 - 27F
	0x2990, 0x2990, 0x29a5, 0x29c1, 0x29c1, 0x29d3, 0x2a14, 0x2a20,
	0x2a6a, 0x2a76, 0x2aa5, 0x2ad9, 0x2b0b, 0x2b3f, 0x2b6a, 0x2b92,
	0x2bbd, 0x2c07, 0x2c3b, 0x2c78, 0x2cac, 0x2cc8, 0x2cdd, 0x2d11,
	0x2d3f, 0x2d57, 0x2d8b, 0x2dad, 0x2dd8,
}

// Size: 4000 bytes
const caLangStr = "" +
	"àfarabkhazavèsticafrikaansàkanamhàricaragonèsàrabassamèsàvaraimaraazerba" +
	"idjanèsbaixkirbielorúsbúlgarbislamabambarabengalítibetàbretóbosniàcatalà" +
	"txetxèchamorrocorscreetxeceslau eclesiàstictxuvaixgal·lèsdanèsalemanydiv" +
	"ehidzongkaewegrecanglèsesperantoespanyolestoniàbascpersafulfinèsfijiàfer" +
	"oèsfrancèsfrisó orientalirlandèsgaèlic escocèsgallecguaranígujaratimanxh" +
	"aussahebreuhindihiri motucroathaitiàhongarèsarmenihererointerlinguaindon" +
	"esiinterlingueigboyi sichuaninupiakidoislandèsitaliàinuktitutjaponèsjava" +
	"nèsgeorgiàkongokikuiukuanyamakazakhgrenlandèskhmerkannadacoreàkanuricaix" +
	"mirikurdkomicòrnickirguísllatíluxemburguèsgandalimburguèslingalalaosiàli" +
	"tuàluba katangaletómalgaixmarshallèsmaorimacedonimalaiàlammongolmarathim" +
	"alaimaltèsbirmànauruàndebele septentrionalnepalèsndonganeerlandèsnoruec " +
	"nynorsknoruec bokmålndebele meridionalnavahonyanjaoccitàojibwaoromooriya" +
	"ossetpanjabipalipolonèspaixtuportuguèsquítxuaretoromànicrundiromanèsrusr" +
	"uandèssànscritsardsindhisami septentrionalsangosingalèseslovaceslovèsamo" +
	"àshonasomalialbanèsserbisiswatisotho meridionalsundanèssuecsuahilitàmil" +
	"telugutadjiktailandèstigrinyaturcmantswanatongalèsturctsongatàtartahitià" +
	"uigurucraïnèsurdúuzbekvendavietnamitavolapükvalówòlofxosajiddischiorubaz" +
	"huangxinèszuluatjehacoliadangmeadiguéafrihiliaghemainuaccadialeutaaltaic" +
	" meridionalanglès anticangikaarameuaraucàarapahoarauacpareasturiàawadhib" +
	"alutxibalinèsbasabamunghomalabejabembabenabafutbhojpuribicolbinikomblack" +
	"footbrajbodoakooseburiatbuguisekibilinmedumbacaddocaribcayugaatsamcebuàc" +
	"higatxibtxatxagataichuukmaripidgin chinookchoctawchipewyancherokeexeienn" +
	"ekurd soranicoptetàtar de Crimeacaixubidakotadarguàtaitadelawareslaveydo" +
	"gribdinkazarmadogribaix sòrabdoualaneerlandès mitjàdiolajuladazagaembuef" +
	"ikegipci anticekajukelamitaanglès mitjàewondofangfilipífonfrancès mitjàf" +
	"rancès anticfrisó septentrionalfrisó occidentalfriülàgagagaúsgayogbayagu" +
	"eezgilbertèsalt alemany mitjàalt alemany anticgondigorontalogòticgrebogr" +
	"ec anticalemany suísgusígwichinhaidahawaiàhiligainonhititahmongalt sòrab" +
	"hupaibanibibioilocàingúixlojbanngombamachamejudeopersajudeoàrabkarakalpa" +
	"kcabilenckatxinjjukambakawikabardíkanembutyapmakondecrioll capverdiàkoro" +
	"khasikhotanèskoyra chiinikakokalenjinkimbundukomi-permiackonkanikosraeàk" +
	"pellekaratxaicareliàkurukhshambalabafiacologniankúmikkutenailadílangipan" +
	"jabi occidentallambalesguiàlakotamongoloziluba-lulualuisenyolundaluomizo" +
	"luyiamadurèsmafamagahimaithilimakassarmandingamassaimabamordovià moksama" +
	"ndarmendemerumauriciàgaèlic irlandès mitjàmakhuwa-mettometa’micmacminang" +
	"kabaumanxúmanipurímohawkmorémundangllengües vàriescreekmirandèsmarwarimy" +
	"enemordovià erzanapolitànamabaix alemanynewariniasniueàbissiongiemboonno" +
	"gainòrdic anticn’Kosotho septentrionalnuernewari clàssicnyamwesinyankole" +
	"nyoronzemaosageturc otomàpangasipahlavipampangàpapiamentopalauàpersa ant" +
	"icfeniciponapeàprovençal anticquitxérajasthanirapanuirarotongàromboroman" +
	"íaromanèsrwosandaweiacutarameu samaritàsamburusasaksantalingambaysangus" +
	"iciliàescocèssenecasenaselkupsonghai orientalirlandès antictaixelhitxanà" +
	"rab txadiàsidamosami meridionalsami lulesami d’Inarisami skoltsoninkesog" +
	"diàsrananserersahosukumasusúsumericomoriàsuahili del Congosiríac clàssic" +
	"siríactemnetesoterenatetuntigretivtokelauèsklingoniàtlingittamazighttong" +
	"atok pisintarokotsimshiàtumbukatuvaluàtasawaqtuviniàamazic del Marroc ce" +
	"ntraludmurtugaríticumbunduarrelvaivòticvunjowalserametowaray-waraywashoc" +
	"almucsogayaoyapeàyangbenyembacantonèszapotecasímbols Blisszenagaamazic e" +
	"stàndard marroquízunisense contingut lingüísticzazaàrab estàndard modern" +
	"alemany austríacalt alemany suísanglès australiàanglès canadencanglès br" +
	"itànicanglès americàespanyol hispanoamericàespanyol europeuespanyol de M" +
	"èxicfrancès canadencfrancès suísflamencportuguès del Brasilportuguès de" +
	" Portugalmoldauserbocroatxinès simplificatxinès tradicional"

// Size: 1234 bytes, 605 elements
var caLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0005, 0x000b, 0x0013, 0x001c, 0x0021, 0x0029, 0x0032,
	0x0037, 0x003f, 0x0044, 0x004a, 0x0058, 0x005f, 0x0068, 0x006f,
	0x0076, 0x007d, 0x0085, 0x008c, 0x0092, 0x0099, 0x00a0, 0x00a7,
	0x00af, 0x00b3, 0x00b7, 0x00bb, 0x00cd, 0x00d4, 0x00dd, 0x00e3,
	0x00ea, 0x00f0, 0x00f7, 0x00fa, 0x00fe, 0x0105, 0x010e, 0x0116,
	0x011e, 0x0122, 0x0127, 0x012a, 0x0130, 0x0136, 0x013d, 0x0145,
	0x0154, 0x015d, 0x016d, 0x0173, 0x017b, 0x0183, 0x0187, 0x018d,
	0x0193, 0x0198, 0x01a1, 0x01a6, 0x01ad, 0x01b6, 0x01bc, 0x01c2,
	// Entry 40 - 7F
	0x01cd, 0x01d5, 0x01e0, 0x01e4, 0x01ee, 0x01f5, 0x01f8, 0x0201,
	0x0208, 0x0211, 0x0219, 0x0221, 0x0229, 0x022e, 0x0234, 0x023c,
	0x0242, 0x024d, 0x0252, 0x0259, 0x025f, 0x0265, 0x026d, 0x0271,
	0x0275, 0x027c, 0x0284, 0x028a, 0x0297, 0x029c, 0x02a7, 0x02ae,
	0x02b5, 0x02bb, 0x02c7, 0x02cc, 0x02d3, 0x02de, 0x02e3, 0x02eb,
	0x02f5, 0x02fb, 0x0302, 0x0307, 0x030e, 0x0314, 0x031b, 0x0330,
	0x0338, 0x033e, 0x0349, 0x0357, 0x0365, 0x0377, 0x037d, 0x0383,
	0x038a, 0x0390, 0x0395, 0x039a, 0x039f, 0x03a6, 0x03aa, 0x03b2,
	// Entry 80 - BF
	0x03b8, 0x03c2, 0x03ca, 0x03d6, 0x03db, 0x03e3, 0x03e6, 0x03ee,
	0x03f7, 0x03fb, 0x0401, 0x0413, 0x0418, 0x0421, 0x0428, 0x042f,
	0x0435, 0x043a, 0x0440, 0x0448, 0x044d, 0x0454, 0x0464, 0x046d,
	0x0471, 0x0478, 0x047e, 0x0484, 0x048a, 0x0494, 0x049c, 0x04a3,
	0x04a9, 0x04b2, 0x04b6, 0x04bc, 0x04c2, 0x04ca, 0x04cf, 0x04d9,
	0x04de, 0x04e3, 0x04e8, 0x04f2, 0x04fa, 0x04ff, 0x0505, 0x0509,
	0x0511, 0x0517, 0x051d, 0x0523, 0x0527, 0x052c, 0x0531, 0x0538,
	0x053f, 0x053f, 0x0547, 0x054c, 0x0550, 0x0556, 0x0556, 0x055c,
	// Entry C0 - FF
	0x055c, 0x056d, 0x057a, 0x0580, 0x0586, 0x058d, 0x058d, 0x0594,
	0x0594, 0x059a, 0x059a, 0x059a, 0x059e, 0x059e, 0x05a6, 0x05a6,
	0x05ac, 0x05ac, 0x05b3, 0x05bb, 0x05bb, 0x05bf, 0x05c4, 0x05c4,
	0x05cb, 0x05cf, 0x05d4, 0x05d4, 0x05d8, 0x05dd, 0x05dd, 0x05e5,
	0x05ea, 0x05ee, 0x05ee, 0x05f1, 0x05fa, 0x05fa, 0x05fa, 0x05fe,
	0x05fe, 0x0602, 0x0608, 0x060e, 0x0613, 0x0617, 0x061c, 0x0623,
	0x0628, 0x062d, 0x0633, 0x0638, 0x063e, 0x0643, 0x064a, 0x0652,
	0x0657, 0x065b, 0x0669, 0x0670, 0x0679, 0x0681, 0x0688, 0x0693,
	// Entry 100 - 13F
	0x0698, 0x0698, 0x06a8, 0x06af, 0x06b5, 0x06bc, 0x06c1, 0x06c9,
	0x06cf, 0x06d5, 0x06da, 0x06df, 0x06e4, 0x06ef, 0x06ef, 0x06f5,
	0x0707, 0x070c, 0x0710, 0x0716, 0x071a, 0x071e, 0x071e, 0x072a,
	0x0730, 0x0737, 0x0745, 0x0745, 0x074b, 0x074b, 0x074f, 0x0756,
	0x0756, 0x0759, 0x0759, 0x0768, 0x0776, 0x0776, 0x078a, 0x079b,
	0x07a3, 0x07a5, 0x07ac, 0x07ac, 0x07b0, 0x07b5, 0x07b5, 0x07ba,
	0x07c4, 0x07c4, 0x07d6, 0x07e7, 0x07e7, 0x07ec, 0x07f5, 0x07fb,
	0x0800, 0x080a, 0x0817, 0x0817, 0x0817, 0x081c, 0x0823, 0x0828,
	// Entry 140 - 17F
	0x0828, 0x082f, 0x082f, 0x0839, 0x083f, 0x0844, 0x084e, 0x084e,
	0x0852, 0x0856, 0x085c, 0x0862, 0x0869, 0x0869, 0x0869, 0x086f,
	0x0875, 0x087c, 0x0886, 0x0890, 0x0890, 0x089a, 0x08a2, 0x08a8,
	0x08ab, 0x08b0, 0x08b4, 0x08bc, 0x08c3, 0x08c7, 0x08ce, 0x08df,
	0x08df, 0x08e3, 0x08e3, 0x08e8, 0x08f1, 0x08fd, 0x08fd, 0x08fd,
	0x0901, 0x0909, 0x0911, 0x091d, 0x0924, 0x092c, 0x0932, 0x093a,
	0x093a, 0x093a, 0x0942, 0x0948, 0x0950, 0x0955, 0x095e, 0x0964,
	0x096b, 0x0970, 0x0975, 0x0987, 0x098c, 0x0994, 0x0994, 0x0994,
	// Entry 180 - 1BF
	0x0994, 0x099a, 0x099a, 0x099f, 0x09a3, 0x09a3, 0x09ad, 0x09b5,
	0x09ba, 0x09bd, 0x09c1, 0x09c6, 0x09c6, 0x09c6, 0x09ce, 0x09d2,
	0x09d8, 0x09e0, 0x09e8, 0x09f0, 0x09f6, 0x09fa, 0x0a09, 0x0a0f,
	0x0a14, 0x0a18, 0x0a21, 0x0a39, 0x0a46, 0x0a4d, 0x0a53, 0x0a5e,
	0x0a64, 0x0a6d, 0x0a73, 0x0a78, 0x0a78, 0x0a7f, 0x0a90, 0x0a95,
	0x0a9e, 0x0aa5, 0x0aa5, 0x0aaa, 0x0ab8, 0x0ab8, 0x0ab8, 0x0ac1,
	0x0ac5, 0x0ad1, 0x0ad7, 0x0adb, 0x0ae1, 0x0ae1, 0x0ae7, 0x0af0,
	0x0af5, 0x0b02, 0x0b02, 0x0b08, 0x0b1b, 0x0b1f, 0x0b2e, 0x0b36,
	// Entry 1C0 - 1FF
	0x0b3e, 0x0b43, 0x0b48, 0x0b4d, 0x0b58, 0x0b5f, 0x0b66, 0x0b6f,
	0x0b79, 0x0b80, 0x0b80, 0x0b80, 0x0b80, 0x0b8b, 0x0b8b, 0x0b91,
	0x0b91, 0x0b91, 0x0b99, 0x0b99, 0x0ba9, 0x0bb0, 0x0bb0, 0x0bba,
	0x0bc1, 0x0bcb, 0x0bcb, 0x0bcb, 0x0bd0, 0x0bd7, 0x0bd7, 0x0bd7,
	0x0bd7, 0x0be0, 0x0be3, 0x0bea, 0x0bef, 0x0bff, 0x0c06, 0x0c0b,
	0x0c12, 0x0c12, 0x0c19, 0x0c1e, 0x0c26, 0x0c2e, 0x0c2e, 0x0c34,
	0x0c38, 0x0c38, 0x0c3e, 0x0c4e, 0x0c5d, 0x0c5d, 0x0c66, 0x0c69,
	0x0c76, 0x0c7c, 0x0c7c, 0x0c7c, 0x0c8b, 0x0c94, 0x0ca2, 0x0cac,
	// Entry 200 - 23F
	0x0cb3, 0x0cba, 0x0cc0, 0x0cc5, 0x0cc9, 0x0cc9, 0x0ccf, 0x0cd4,
	0x0cda, 0x0ce2, 0x0cf3, 0x0d03, 0x0d0a, 0x0d0a, 0x0d0a, 0x0d0f,
	0x0d13, 0x0d19, 0x0d1e, 0x0d23, 0x0d26, 0x0d30, 0x0d30, 0x0d3a,
	0x0d41, 0x0d41, 0x0d4a, 0x0d4f, 0x0d58, 0x0d58, 0x0d5e, 0x0d5e,
	0x0d67, 0x0d67, 0x0d6e, 0x0d76, 0x0d7d, 0x0d85, 0x0d9e, 0x0da4,
	0x0dad, 0x0db4, 0x0db9, 0x0dbc, 0x0dbc, 0x0dbc, 0x0dbc, 0x0dbc,
	0x0dc2, 0x0dc2, 0x0dc7, 0x0dcd, 0x0dd2, 0x0ddd, 0x0de2, 0x0de2,
	0x0de2, 0x0de8, 0x0de8, 0x0dec, 0x0def, 0x0df5, 0x0dfc, 0x0e01,
	// Entry 240 - 27F
	0x0e01, 0x0e0a, 0x0e12, 0x0e20, 0x0e20, 0x0e26, 0x0e41, 0x0e45,
	0x0e61, 0x0e65, 0x0e7c, 0x0e8d, 0x0e9e, 0x0eb0, 0x0ec0, 0x0ed1,
	0x0ee1, 0x0ef9, 0x0f09, 0x0f1b, 0x0f2c, 0x0f3a, 0x0f41, 0x0f56,
	0x0f6c, 0x0f72, 0x0f7c, 0x0f8e, 0x0fa0,
}

// Size: 7260 bytes
const csLangStr = "" +
	"afarštinaabcházštinaavestánštinaafrikánštinaakanštinaamharštinaaragonšti" +
	"naarabštinaásámštinaavarštinaajmarštinaázerbájdžánštinabaškirštinaběloru" +
	"štinabulharštinabislamštinabambarštinabengálštinatibetštinabretonštinab" +
	"osenštinakatalánštinačečenštinačamorokorsičtinakríjštinačeštinastaroslov" +
	"ěnštinačuvaštinavelštinadánštinaněmčinamaledivštinadzongkäeweštinařečti" +
	"naangličtinaesperantošpanělštinaestonštinabaskičtinaperštinafulbštinafin" +
	"štinafidžijštinafaerštinafrancouzštinafríštinairštinaskotská gaelštinag" +
	"alicijštinaguaranštinagudžarátštinamanštinahauštinahebrejštinahindštinah" +
	"iri motuchorvatštinahaitštinamaďarštinaarménštinahererštinainterlinguain" +
	"donéštinainterlingueigboštinas’-čchuan iinupiakštinaidoislandštinaitalšt" +
	"inainuktitutštinajaponštinajavánštinagruzínštinakonžštinakikujštinakuaňa" +
	"mštinakazaštinagrónštinakhmérštinakannadštinakorejštinakanurikašmírština" +
	"kurdštinakomijštinakornštinakyrgyzštinalatinalucemburštinagandštinalimbu" +
	"rštinalingalštinalaoštinalitevštinalubu-katanžštinalotyštinamalgaštinama" +
	"ršálštinamaorštinamakedonštinamalajálamštinamongolštinamaráthštinamalajš" +
	"tinamaltštinabarmštinanaurštinandebele (Zimbabwe)nepálštinandondštinaniz" +
	"ozemštinanorština (nynorsk)norština (bokmål)ndebele (Jižní Afrika)navažš" +
	"tinaňandžštinaokcitánštinaodžibvejštinaoromštinaurijštinaosetštinapaňdžá" +
	"bštinapálípolštinapaštštinaportugalštinakečuánštinarétorománštinakirundš" +
	"tinarumunštinaruštinakiňarwandštinasanskrtsardštinasindhštinasámština (s" +
	"everní)sangštinasinhálštinaslovenštinaslovinštinasamojštinašonštinasomál" +
	"štinaalbánštinasrbštinasiswatštinasotština (jižní)sundštinašvédštinasva" +
	"hilštinatamilštinatelugštinatádžičtinathajštinatigrinijštinaturkmenština" +
	"setswanštinatongánštinaturečtinatsongatatarštinatahitštinaujgurštinaukra" +
	"jinštinaurdštinauzbečtinavendavietnamštinavolapükvalonštinawolofštinaxho" +
	"štinajidišjorubštinačuangštinačínštinazuluštinaacehštinaakolštinaadangm" +
	"eadygejštinaarabština (tuniská)afrihiliaghemainštinaakkadštinaalabamštin" +
	"aaleutštinaalbánština (Gheg)altajština (jižní)staroangličtinaangikaarame" +
	"jštinaaraukánštinaaraonštinaarapažštinaarabština (alžírská)arawacké jazy" +
	"kyarabština (marocká)arabština (egyptská)asuznaková řeč (americká)asturš" +
	"tinakotavaawadhštinaázerbájdžánština (jižní)balúčštinabalijštinabavoršti" +
	"nabasabamunbatak tobaghomalabedžabembštinabatavštinabenabafutbadagštinab" +
	"hojpurštinabikolštinabinibandžarštinakomsiksikabišnuprijskomanipurštinab" +
	"achtijárštinabradžštinabrahujštinabodoštinaakooseburjatštinabugištinabul" +
	"ublinštinamedumbacaddokaribštinakajugštinaatsamcebuánštinakigačibčačagat" +
	"ajštinačukštinamarijštinačinuk pidžinčoktštinačipevajštinačerokézštinače" +
	"jenštinakurdština (sorání)koptštinakapiznonštinaturečtina (krymská)kašub" +
	"štinadakotštinadargštinataitadelawarštinaslejvština (athabaský jazyk)do" +
	"gribdinkštinazarmštinadogarštinadolnolužická srbštinakadazandusunštinadu" +
	"alštinaholandština (středověká)jola-fonyidjuladazagaembuefikštinaemilijš" +
	"tinaegyptština staráekajukelamitštinaangličtina (středověká)jupikština (" +
	"středoaljašská)ewondoextremadurštinafangfilipínštinafinština (tornedalsk" +
	"á)fonštinafrancouzština (kajunská)francouzština (středověká)francouzšti" +
	"na (stará)franko-provensálštinafríština (severní)fríština (východní)furl" +
	"anštinagaštinagagauzštinačínština (dialekty Gan)gayogbajadaríjština (zor" +
	"oastrijská)geezkiribatštinagilačtinahornoněmčina (středověká)hornoněmčin" +
	"a (stará)konkánština (Goa)góndštinagorontalogótštinagrebostarořečtinaněm" +
	"čina (Švýcarsko)wayúuštinafrafragusiigwichʼinhaidštinačínština (dialekt" +
	"y Hakka)havajštinahindština (Fidži)hiligajnonštinachetitštinahmongštinah" +
	"ornolužická srbštinačínština (dialekty Xiang)hupaibanštinaibibioilokánšt" +
	"inainguštinaingrijštinajamajská kreolštinalojbanngombamašamejudeoperštin" +
	"ajudeoarabštinajutštinakarakalpačtinakabylštinakačijštinajjukambštinakaw" +
	"ikabardinštinakanembutyapmakondekapverdštinakenyangkorokaingangkhásíchot" +
	"ánštinakoyra chiinichovarštinazazakštinakakokalendžinkimbundštinakomi-p" +
	"ermjačtinakonkánštinakosrajštinakpellekaračajevo-balkarštinakriokinaraj-" +
	"akarelštinakuruchštinašambalabafiakolínštinakumyčtinakutenajštinaladinšt" +
	"inalangilahndštinalambštinalezginštinalingua franca novaligurštinalivonš" +
	"tinalakotštinalombardštinamongštinalozštinalatgalštinaluba-luluaštinalui" +
	"seňolundštinaluoštinamizoštinaluhjačínština (klasická)lazštinamadurština" +
	"mafamagahijštinamaithilištinamakasarštinamandingštinamasajštinamabamokša" +
	"nštinamandarmendemerumauricijská kreolštinairština (středověká)makhuwa-m" +
	"eettometa’micmacminangkabaumandžuštinamanipurštinamohawkštinamosimarijšt" +
	"ina (západní)mundangsložené (víceřádkové) jazykykríkštinamirandštinamárv" +
	"árštinamentavajštinamyeneerzjanštinamázandaránštinačínština (dialekty M" +
	"innan)neapolštinanamaštinadolnoněmčinanévárštinaniasniueštinaao (jazyky " +
	"Nágálandu)kwasiongiemboonnogajštinanorština historickánovialn’kosotština" +
	" (severní)nuerštinanewarština (klasická)ňamwežštinaňankolštinaňorštinanz" +
	"imaosageturečtina (osmanská)pangasinanštinapahlavštinapapangaupapiamento" +
	"palauštinapicardštinaněmčina (pensylvánská)němčina (plautdietsch)starope" +
	"rštinafalčtinaféničtinapiemonštinapontštinapohnpeištinapruštinaprovensál" +
	"štinakičékečuánština (chimborazo)rádžastánštinarapanujštinararotongánšt" +
	"inaromaňolštinarífštinaromboromštinarotumanštinarusínštinarovianštinaaru" +
	"munštinarwasandawštinajakutštinasamarštinasamburusasakštinasantálštinasa" +
	"urášterštinangambaysangoštinasicilštinaskotštinasassarštinasenecasenaser" +
	"ištinaselkupštinakoyraboro senniirština (stará)žemaitštinatachelhitšanšt" +
	"inaarabština (čadská)sidamoněmčina (slezská)selajarštinasámština (jižní)" +
	"sámština (lulejská)sámština (inarijská)sámština (skoltská)sonikštinasogd" +
	"štinasranan tongosererštinasahofríština (saterlandská)sukumasususumeršt" +
	"inakomorštinasvahilština (Kongo)syrština (klasická)syrštinaslezštinatulu" +
	"štinatemnetesoterenotetumštinatigrejštinativštinatokelauštinacachurštin" +
	"aklingonštinatlingittalyštinatamašektonžština (nyasa)tok pisinturojština" +
	"tarokotsakonštinatsimšijské jazykytatštinatumbukštinatuvalštinatasawaqtu" +
	"vinštinatamazight (střední Maroko)udmurtštinaugaritštinaumbunduneznámý j" +
	"azykvaibenátštinavepštinavlámština (západní)němčina (mohansko-franské di" +
	"alekty)votštinavõruštinavunjoněmčina (walser)wolajtštinawarajštinawaštin" +
	"ačínština (dialekty Wu)kalmyčtinamingrelštinasogštinajaoštinajapštinajan" +
	"gbenštinayembanheengatukantonštinazapotéčtinabliss systémzélandštinazena" +
	"gatamazight (standardní marocký)zunijštinažádný jazykový obsahzazaarabšt" +
	"ina (moderní standardní)němčina standardní (Švýcarsko)angličtina (USA)šp" +
	"anělština (Evropa)vlámštinaportugalština (Evropa)moldavštinasrbochorvatš" +
	"tinačínština (zjednodušená)"

// Size: 1232 bytes, 604 elements
var csLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000a, 0x0017, 0x0025, 0x0033, 0x003d, 0x0048, 0x0054,
	0x005e, 0x006a, 0x0074, 0x007f, 0x0094, 0x00a1, 0x00ae, 0x00ba,
	0x00c6, 0x00d2, 0x00df, 0x00ea, 0x00f6, 0x0101, 0x010f, 0x011c,
	0x0123, 0x012e, 0x0139, 0x0142, 0x0154, 0x015f, 0x0168, 0x0172,
	0x017b, 0x0188, 0x0190, 0x0199, 0x01a2, 0x01ad, 0x01b6, 0x01c4,
	0x01cf, 0x01da, 0x01e3, 0x01ed, 0x01f6, 0x0203, 0x020d, 0x021b,
	0x0225, 0x022d, 0x0240, 0x024d, 0x0259, 0x0269, 0x0272, 0x027b,
	0x0287, 0x0291, 0x029a, 0x02a7, 0x02b1, 0x02bd, 0x02c9, 0x02d4,
	// Entry 40 - 7F
	0x02df, 0x02ec, 0x02f7, 0x0301, 0x030f, 0x031c, 0x031f, 0x032b,
	0x0335, 0x0344, 0x034f, 0x035b, 0x0368, 0x0373, 0x037e, 0x038b,
	0x0395, 0x03a0, 0x03ac, 0x03b8, 0x03c3, 0x03c9, 0x03d7, 0x03e1,
	0x03ec, 0x03f6, 0x0402, 0x0408, 0x0416, 0x0420, 0x042c, 0x0438,
	0x0441, 0x044c, 0x045e, 0x0468, 0x0473, 0x0481, 0x048b, 0x0498,
	0x04a8, 0x04b4, 0x04c1, 0x04cc, 0x04d6, 0x04e0, 0x04ea, 0x04fc,
	0x0508, 0x0513, 0x0520, 0x0533, 0x0546, 0x055e, 0x056a, 0x0577,
	0x0585, 0x0594, 0x059e, 0x05a8, 0x05b2, 0x05c2, 0x05c8, 0x05d1,
	// Entry 80 - BF
	0x05dc, 0x05ea, 0x05f8, 0x0609, 0x0615, 0x0620, 0x0628, 0x0638,
	0x063f, 0x0649, 0x0654, 0x0669, 0x0673, 0x0680, 0x068c, 0x0698,
	0x06a3, 0x06ad, 0x06b9, 0x06c5, 0x06ce, 0x06da, 0x06ed, 0x06f7,
	0x0703, 0x070f, 0x071a, 0x0725, 0x0732, 0x073c, 0x074a, 0x0757,
	0x0764, 0x0771, 0x077b, 0x0781, 0x078c, 0x0797, 0x07a2, 0x07af,
	0x07b8, 0x07c2, 0x07c7, 0x07d4, 0x07dc, 0x07e7, 0x07f2, 0x07fb,
	0x0801, 0x080c, 0x0818, 0x0823, 0x082d, 0x0837, 0x0841, 0x0848,
	0x0854, 0x0869, 0x0871, 0x0876, 0x087f, 0x088a, 0x0896, 0x08a1,
	// Entry C0 - FF
	0x08b4, 0x08c9, 0x08d9, 0x08df, 0x08eb, 0x08f9, 0x0904, 0x0911,
	0x0929, 0x0939, 0x094e, 0x0964, 0x0967, 0x0981, 0x098c, 0x0992,
	0x099d, 0x09bc, 0x09c9, 0x09d4, 0x09df, 0x09e3, 0x09e8, 0x09f2,
	0x09f9, 0x09ff, 0x0a09, 0x0a14, 0x0a18, 0x0a1d, 0x0a28, 0x0a35,
	0x0a40, 0x0a44, 0x0a52, 0x0a55, 0x0a5c, 0x0a76, 0x0a86, 0x0a92,
	0x0a9e, 0x0aa8, 0x0aae, 0x0aba, 0x0ac4, 0x0ac8, 0x0ad2, 0x0ad9,
	0x0ade, 0x0ae9, 0x0af4, 0x0af9, 0x0b06, 0x0b0a, 0x0b11, 0x0b1f,
	0x0b29, 0x0b34, 0x0b42, 0x0b4d, 0x0b5b, 0x0b6a, 0x0b76, 0x0b8b,
	// Entry 100 - 13F
	0x0b95, 0x0ba3, 0x0bb8, 0x0bc4, 0x0bcf, 0x0bd9, 0x0bde, 0x0beb,
	0x0c09, 0x0c0f, 0x0c19, 0x0c23, 0x0c2e, 0x0c46, 0x0c58, 0x0c62,
	0x0c7e, 0x0c88, 0x0c8d, 0x0c93, 0x0c97, 0x0ca1, 0x0cad, 0x0cbf,
	0x0cc5, 0x0cd1, 0x0cec, 0x0d0b, 0x0d11, 0x0d21, 0x0d25, 0x0d33,
	0x0d4b, 0x0d54, 0x0d6e, 0x0d8c, 0x0da3, 0x0dba, 0x0dcf, 0x0de6,
	0x0df2, 0x0dfa, 0x0e06, 0x0e20, 0x0e24, 0x0e29, 0x0e46, 0x0e4a,
	0x0e57, 0x0e61, 0x0e7f, 0x0e96, 0x0ea9, 0x0eb4, 0x0ebd, 0x0ec7,
	0x0ecc, 0x0eda, 0x0ef1, 0x0efd, 0x0f03, 0x0f08, 0x0f11, 0x0f1b,
	// Entry 140 - 17F
	0x0f37, 0x0f42, 0x0f55, 0x0f65, 0x0f71, 0x0f7c, 0x0f94, 0x0fb0,
	0x0fb4, 0x0fbe, 0x0fc4, 0x0fd1, 0x0fdb, 0x0fe7, 0x0ffc, 0x1002,
	0x1008, 0x100f, 0x101d, 0x102c, 0x1035, 0x1044, 0x104f, 0x105b,
	0x105e, 0x1068, 0x106c, 0x107a, 0x1081, 0x1085, 0x108c, 0x1099,
	0x10a0, 0x10a4, 0x10ac, 0x10b3, 0x10c0, 0x10cc, 0x10d8, 0x10e3,
	0x10e7, 0x10f1, 0x10fe, 0x110f, 0x111c, 0x1128, 0x112e, 0x1146,
	0x114a, 0x1153, 0x115e, 0x116a, 0x1172, 0x1177, 0x1183, 0x118d,
	0x119a, 0x11a5, 0x11aa, 0x11b5, 0x11bf, 0x11cb, 0x11dd, 0x11e8,
	// Entry 180 - 1BF
	0x11f3, 0x11fe, 0x120b, 0x1215, 0x121e, 0x122a, 0x123a, 0x1242,
	0x124c, 0x1255, 0x125f, 0x1264, 0x127b, 0x1284, 0x128f, 0x1293,
	0x12a0, 0x12ae, 0x12bb, 0x12c8, 0x12d3, 0x12d7, 0x12e4, 0x12ea,
	0x12ef, 0x12f3, 0x130b, 0x1323, 0x1331, 0x1338, 0x133e, 0x1349,
	0x1356, 0x1363, 0x136f, 0x1373, 0x138a, 0x1391, 0x13b3, 0x13be,
	0x13ca, 0x13d8, 0x13e6, 0x13eb, 0x13f7, 0x1409, 0x1426, 0x1432,
	0x143c, 0x144a, 0x1457, 0x145b, 0x1465, 0x147c, 0x1482, 0x148b,
	0x1496, 0x14ab, 0x14b1, 0x14b7, 0x14cb, 0x14d5, 0x14ec, 0x14fa,
	// Entry 1C0 - 1FF
	0x1507, 0x1511, 0x1516, 0x151b, 0x1531, 0x1541, 0x154d, 0x1555,
	0x155f, 0x156a, 0x1576, 0x1590, 0x15a8, 0x15b6, 0x15bf, 0x15ca,
	0x15d6, 0x15e0, 0x15ed, 0x15f6, 0x1606, 0x160c, 0x1627, 0x1639,
	0x1646, 0x1657, 0x1665, 0x166f, 0x1674, 0x167d, 0x168a, 0x1696,
	0x16a2, 0x16ae, 0x16b1, 0x16bd, 0x16c8, 0x16d3, 0x16da, 0x16e5,
	0x16f2, 0x1703, 0x170a, 0x1715, 0x1720, 0x172a, 0x1736, 0x173c,
	0x1740, 0x174a, 0x1756, 0x1765, 0x1776, 0x1783, 0x178c, 0x1796,
	0x17ab, 0x17b1, 0x17c5, 0x17d2, 0x17e6, 0x17fc, 0x1813, 0x1829,
	// Entry 200 - 23F
	0x1834, 0x183e, 0x184a, 0x1855, 0x1859, 0x1873, 0x1879, 0x187d,
	0x1888, 0x1893, 0x18a7, 0x18bc, 0x18c5, 0x18cf, 0x18d9, 0x18de,
	0x18e2, 0x18e8, 0x18f3, 0x18ff, 0x1908, 0x1915, 0x1921, 0x192e,
	0x1935, 0x193f, 0x1947, 0x195a, 0x1963, 0x196e, 0x1974, 0x1980,
	0x1993, 0x199c, 0x19a8, 0x19b3, 0x19ba, 0x19c5, 0x19e1, 0x19ed,
	0x19f9, 0x1a00, 0x1a0f, 0x1a12, 0x1a1e, 0x1a27, 0x1a3e, 0x1a64,
	0x1a6d, 0x1a78, 0x1a7d, 0x1a8f, 0x1a9b, 0x1aa6, 0x1aae, 0x1aae,
	0x1ac7, 0x1ad2, 0x1adf, 0x1ae8, 0x1af1, 0x1afa, 0x1b07, 0x1b0c,
	// Entry 240 - 27F
	0x1b15, 0x1b21, 0x1b2e, 0x1b3b, 0x1b48, 0x1b4e, 0x1b6e, 0x1b79,
	0x1b91, 0x1b95, 0x1bb6, 0x1bb6, 0x1bd9, 0x1bd9, 0x1bd9, 0x1bd9,
	0x1bea, 0x1bea, 0x1c01, 0x1c01, 0x1c01, 0x1c01, 0x1c0c, 0x1c0c,
	0x1c23, 0x1c2f, 0x1c40, 0x1c5c,
}

// Size: 3966 bytes
const daLangStr = "" +
	"afarabkhasiskavestanafrikaansakanamhariskaragonesiskarabiskassamesiskava" +
	"riskaymaraaserbajdsjanskbashkirhviderussiskbulgarskbislamabambarabengali" +
	"tibetanskbretonskbosniskcatalansktjetjenskchamorrokorsikanskcreetjekkisk" +
	"kirkeslaviskchuvashwalisiskdansktyskdivehidzongkhaewegræskengelskesperan" +
	"tospanskestiskbaskiskpersiskfulahfinskfijianskfærøskfranskfrisiskirsksko" +
	"tsk gæliskgaliciskguaranigujaratimanxhausahebraiskhindihirimotukroatiskh" +
	"aitiskungarskarmenskhererointerlinguaindonesiskinterlingueigbosichuan yi" +
	"inupiaqidoislandskitalienskinuktitutjapanskjavanesiskgeorgiskkongokikuyu" +
	"kuanyamakasakhiskgrønlandskkhmerkannadakoreanskkanurikashmirikurdiskkomi" +
	"corniskkirgisisklatinluxembourgskgandalimburgsklingalalaolitauiskluba-Ka" +
	"tangalettiskmalagassiskmarshallesemaorimakedonskmalayalammongolskmarathi" +
	"skmalaymaltesiskburmesisknaurunordndebelenepalesiskndongahollandsknynors" +
	"knorsk bokmålsydndebelenavajonyanjaoccitanskojibwaoromooriyaossetiskpunj" +
	"abipalipolskpashtoportugisiskquechuarætoromanskrundirumænskrussiskkinyar" +
	"wandasanskritsardinsksindhinordsamisksangosingalesiskslovakiskslovensksa" +
	"moanskshonasomaliskalbanskserbiskswatisydsothosundanesisksvenskswahilita" +
	"milsktelugutajikthailandsktigrinyaturkmensktswanatongansktyrkisktsongata" +
	"tarisktahitianskuyguriskukrainskurduusbekiskvendavietnamesiskvolapykvall" +
	"onskwolofxhosajiddischyorubazhuangkinesiskzuluachinesiskacoliadangmeadyg" +
	"heafrihiliaghemainuakkadiskaleutisksydaltaiskoldengelskangikaaramæiskara" +
	"ukanskarapahoarawakasuasturiskawadhibaluchibalinesiskbasabamunghomalabej" +
	"abembabenabafutbhojpuribikolbinikomsiksikabrajbodobakossiburiatiskbugine" +
	"siskbulublinmedumbacaddocaribiskcayugaatsamcebuanochigachibchachagataich" +
	"uukesemarichinookchoctawchipewyancherokeecheyennesoranikoptiskkrim tyrki" +
	"skkasjubiskdakotadargwataitadelawareathapaskiskdogribdinkazarmadogrinede" +
	"rsorbiskdualamiddelhollandskjola-fonyidyuladazagakiembuefikoldegyptiskek" +
	"ajukelamitiskmiddelengelskewondofangfilippinskfonmiddelfranskoldfranskno" +
	"rdfrisiskøstfrisiskfriuliangagagauziskgayogbayageezgilbertesiskmiddelhøj" +
	"tyskoldhøjtyskgondigorontalogotiskgrebooldgræskschweizertyskgusiigwichin" +
	"haidahawaiianskhiligaynonhittitiskhmongøvresorbiskhupaibanibibioilokoing" +
	"ushlojbanngombamachamejødisk-persiskjødisk-arabiskkarakalpakiskkabyliskk" +
	"achinjjukambakawikabardiankanembutyapmakondekapverdiskkorokhasikhotanesi" +
	"skkoyra-chiinikakokalenjinkimbundukomi-permjakiskkonkanikosraeankpelleka" +
	"ratjai-balkarkarelskkurukhshambalabafiakölschkymykkutenajladinolangilahn" +
	"dalambalezghianlakotamongoloziluba-Lulualuisenolundaluolushailuyanamadur" +
	"esemafamagahimaithilimakasarmandingomasaimabamokshamandarmendemerumorisy" +
	"enmiddelirskmakhuwa-meettometamicmacminangkabaumanchumanipurimohawkmossi" +
	"mundangflere sprogcreekmirandesiskmarwarimyeneerzyaneapolitansknamaneder" +
	"tysknewariniasniueankwasiongiemboonnogaioldislandskn-konordsothonuerklas" +
	"sisk newarisknyamwezinyankolenyoro sprognzimaosageosmannisk-tyrkiskpanga" +
	"sinanpahlavipampangapapiamentopalauanskoldpersiskfønikiskponapeoldproven" +
	"calskquichérajasthanirapanuirarotonganromboromaniarumænskrwasandaweyakut" +
	"samaritansksamburusasaksantalingambaysangusicilianskskotsksenecasenaselk" +
	"upiskkoyraboro sennioldirsktachelhitshantchadisk-arabisksidamosydsamiskl" +
	"ulesamiskenaresamiskskoltesamisksoninkesogdiansksranan tongoserersahosuk" +
	"umasususumeriskshimaorecongolesisk swahiliklassisk syrisksyrisktemneteso" +
	"terenotetumtigretivitokelauklingontlingittamasheknyasa tongansktok pisin" +
	"tarokotsimshisktumbukatuvalutasawaqtuviniancentralmarokkansk tamazightud" +
	"murtugaristiskumbundurotvaivotiskvunjowalsertyskwalamowaraywashokalmykso" +
	"gayaoyapeseyangbenyembakantonesiskzapotecblissymbolerzenagatamazightzuni" +
	"intet sprogligt indholdzazamoderne standardarabiskøstrigsk tyskschweizer" +
	"højtyskaustralsk engelskcanadisk engelskbritisk engelskamerikansk engels" +
	"klatinamerikansk spanskeuropæisk spanskmexicansk spanskcanadisk fransksc" +
	"hweizisk franskflamskbrasiliansk portugisiskeuropæisk portugisiskmoldovi" +
	"skserbokroatiskforenklet kinesisktraditionelt kinesisk"

// Size: 1234 bytes, 605 elements
var daLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000d, 0x0014, 0x001d, 0x0021, 0x0029, 0x0034,
	0x003b, 0x0045, 0x004c, 0x0052, 0x0060, 0x0067, 0x0073, 0x007b,
	0x0082, 0x0089, 0x0090, 0x0099, 0x00a1, 0x00a8, 0x00b1, 0x00ba,
	0x00c2, 0x00cc, 0x00d0, 0x00d8, 0x00e4, 0x00eb, 0x00f3, 0x00f8,
	0x00fc, 0x0102, 0x010a, 0x010d, 0x0113, 0x011a, 0x0123, 0x0129,
	0x012f, 0x0136, 0x013d, 0x0142, 0x0147, 0x014f, 0x0157, 0x015d,
	0x0164, 0x0168, 0x0176, 0x017e, 0x0185, 0x018d, 0x0191, 0x0196,
	0x019e, 0x01a3, 0x01ab, 0x01b3, 0x01ba, 0x01c1, 0x01c8, 0x01ce,
	// Entry 40 - 7F
	0x01d9, 0x01e3, 0x01ee, 0x01f2, 0x01fc, 0x0203, 0x0206, 0x020e,
	0x0217, 0x0220, 0x0227, 0x0231, 0x0239, 0x023e, 0x0244, 0x024c,
	0x0255, 0x0260, 0x0265, 0x026c, 0x0274, 0x027a, 0x0282, 0x0289,
	0x028d, 0x0294, 0x029d, 0x02a2, 0x02ae, 0x02b3, 0x02bc, 0x02c3,
	0x02c6, 0x02ce, 0x02da, 0x02e1, 0x02ec, 0x02f7, 0x02fc, 0x0305,
	0x030e, 0x0316, 0x031f, 0x0324, 0x032d, 0x0336, 0x033b, 0x0346,
	0x0350, 0x0356, 0x035f, 0x0366, 0x0373, 0x037d, 0x0383, 0x0389,
	0x0392, 0x0398, 0x039d, 0x03a2, 0x03aa, 0x03b1, 0x03b5, 0x03ba,
	// Entry 80 - BF
	0x03c0, 0x03cb, 0x03d2, 0x03de, 0x03e3, 0x03eb, 0x03f2, 0x03fd,
	0x0405, 0x040d, 0x0413, 0x041d, 0x0422, 0x042d, 0x0436, 0x043e,
	0x0446, 0x044b, 0x0453, 0x045a, 0x0461, 0x0466, 0x046e, 0x0479,
	0x047f, 0x0486, 0x048d, 0x0493, 0x0498, 0x04a2, 0x04aa, 0x04b3,
	0x04b9, 0x04c1, 0x04c8, 0x04ce, 0x04d6, 0x04e0, 0x04e8, 0x04f0,
	0x04f4, 0x04fc, 0x0501, 0x050d, 0x0514, 0x051c, 0x0521, 0x0526,
	0x052e, 0x0534, 0x053a, 0x0542, 0x0546, 0x0550, 0x0555, 0x055c,
	0x0562, 0x0562, 0x056a, 0x056f, 0x0573, 0x057b, 0x057b, 0x0583,
	// Entry C0 - FF
	0x0583, 0x058d, 0x0597, 0x059d, 0x05a6, 0x05af, 0x05af, 0x05b6,
	0x05b6, 0x05bc, 0x05bc, 0x05bc, 0x05bf, 0x05bf, 0x05c7, 0x05c7,
	0x05cd, 0x05cd, 0x05d4, 0x05de, 0x05de, 0x05e2, 0x05e7, 0x05e7,
	0x05ee, 0x05f2, 0x05f7, 0x05f7, 0x05fb, 0x0600, 0x0600, 0x0608,
	0x060d, 0x0611, 0x0611, 0x0614, 0x061b, 0x061b, 0x061b, 0x061f,
	0x061f, 0x0623, 0x062a, 0x0633, 0x063d, 0x0641, 0x0645, 0x064c,
	0x0651, 0x0659, 0x065f, 0x0664, 0x066b, 0x0670, 0x0677, 0x067f,
	0x0687, 0x068b, 0x0692, 0x0699, 0x06a2, 0x06aa, 0x06b2, 0x06b8,
	// Entry 100 - 13F
	0x06bf, 0x06bf, 0x06cb, 0x06d4, 0x06da, 0x06e0, 0x06e5, 0x06ed,
	0x06f8, 0x06fe, 0x0703, 0x0708, 0x070d, 0x0719, 0x0719, 0x071e,
	0x072d, 0x0737, 0x073c, 0x0742, 0x0748, 0x074c, 0x074c, 0x0757,
	0x075d, 0x0766, 0x0773, 0x0773, 0x0779, 0x0779, 0x077d, 0x0787,
	0x0787, 0x078a, 0x078a, 0x0796, 0x079f, 0x079f, 0x07aa, 0x07b5,
	0x07bd, 0x07bf, 0x07c8, 0x07c8, 0x07cc, 0x07d1, 0x07d1, 0x07d5,
	0x07e1, 0x07e1, 0x07ef, 0x07fa, 0x07fa, 0x07ff, 0x0808, 0x080e,
	0x0813, 0x081c, 0x0829, 0x0829, 0x0829, 0x082e, 0x0835, 0x083a,
	// Entry 140 - 17F
	0x083a, 0x0844, 0x0844, 0x084e, 0x0857, 0x085c, 0x0868, 0x0868,
	0x086c, 0x0870, 0x0876, 0x087b, 0x0881, 0x0881, 0x0881, 0x0887,
	0x088d, 0x0894, 0x08a3, 0x08b2, 0x08b2, 0x08bf, 0x08c7, 0x08cd,
	0x08d0, 0x08d5, 0x08d9, 0x08e2, 0x08e9, 0x08ed, 0x08f4, 0x08fe,
	0x08fe, 0x0902, 0x0902, 0x0907, 0x0912, 0x091e, 0x091e, 0x091e,
	0x0922, 0x092a, 0x0932, 0x0941, 0x0948, 0x0950, 0x0956, 0x0965,
	0x0965, 0x0965, 0x096c, 0x0972, 0x097a, 0x097f, 0x0986, 0x098b,
	0x0992, 0x0998, 0x099d, 0x09a3, 0x09a8, 0x09b0, 0x09b0, 0x09b0,
	// Entry 180 - 1BF
	0x09b0, 0x09b6, 0x09b6, 0x09bb, 0x09bf, 0x09bf, 0x09c9, 0x09d0,
	0x09d5, 0x09d8, 0x09de, 0x09e4, 0x09e4, 0x09e4, 0x09ec, 0x09f0,
	0x09f6, 0x09fe, 0x0a05, 0x0a0d, 0x0a12, 0x0a16, 0x0a1c, 0x0a22,
	0x0a27, 0x0a2b, 0x0a33, 0x0a3d, 0x0a4b, 0x0a4f, 0x0a55, 0x0a60,
	0x0a66, 0x0a6e, 0x0a74, 0x0a79, 0x0a79, 0x0a80, 0x0a8b, 0x0a90,
	0x0a9b, 0x0aa2, 0x0aa2, 0x0aa7, 0x0aac, 0x0aac, 0x0aac, 0x0ab8,
	0x0abc, 0x0ac5, 0x0acb, 0x0acf, 0x0ad5, 0x0ad5, 0x0adb, 0x0ae4,
	0x0ae9, 0x0af4, 0x0af4, 0x0af8, 0x0b01, 0x0b05, 0x0b16, 0x0b1e,
	// Entry 1C0 - 1FF
	0x0b26, 0x0b31, 0x0b36, 0x0b3b, 0x0b4c, 0x0b56, 0x0b5d, 0x0b65,
	0x0b6f, 0x0b78, 0x0b78, 0x0b78, 0x0b78, 0x0b82, 0x0b82, 0x0b8b,
	0x0b8b, 0x0b8b, 0x0b91, 0x0b91, 0x0b9f, 0x0ba6, 0x0ba6, 0x0bb0,
	0x0bb7, 0x0bc1, 0x0bc1, 0x0bc1, 0x0bc6, 0x0bcc, 0x0bcc, 0x0bcc,
	0x0bcc, 0x0bd5, 0x0bd8, 0x0bdf, 0x0be4, 0x0bef, 0x0bf6, 0x0bfb,
	0x0c02, 0x0c02, 0x0c09, 0x0c0e, 0x0c18, 0x0c1e, 0x0c1e, 0x0c24,
	0x0c28, 0x0c28, 0x0c31, 0x0c40, 0x0c47, 0x0c47, 0x0c50, 0x0c54,
	0x0c64, 0x0c6a, 0x0c6a, 0x0c6a, 0x0c73, 0x0c7d, 0x0c88, 0x0c94,
	// Entry 200 - 23F
	0x0c9b, 0x0ca4, 0x0cb0, 0x0cb5, 0x0cb9, 0x0cb9, 0x0cbf, 0x0cc3,
	0x0ccb, 0x0cd3, 0x0ce6, 0x0cf5, 0x0cfb, 0x0cfb, 0x0cfb, 0x0d00,
	0x0d04, 0x0d0a, 0x0d0f, 0x0d14, 0x0d18, 0x0d1f, 0x0d1f, 0x0d26,
	0x0d2d, 0x0d2d, 0x0d35, 0x0d43, 0x0d4c, 0x0d4c, 0x0d52, 0x0d52,
	0x0d5b, 0x0d5b, 0x0d62, 0x0d68, 0x0d6f, 0x0d77, 0x0d92, 0x0d98,
	0x0da2, 0x0da9, 0x0dac, 0x0daf, 0x0daf, 0x0daf, 0x0daf, 0x0daf,
	0x0db5, 0x0db5, 0x0dba, 0x0dc4, 0x0dca, 0x0dcf, 0x0dd4, 0x0dd4,
	0x0dd4, 0x0dda, 0x0dda, 0x0dde, 0x0de1, 0x0de7, 0x0dee, 0x0df3,
	// Entry 240 - 27F
	0x0df3, 0x0dfe, 0x0e05, 0x0e11, 0x0e11, 0x0e17, 0x0e20, 0x0e24,
	0x0e3b, 0x0e3f, 0x0e56, 0x0e64, 0x0e75, 0x0e86, 0x0e96, 0x0ea5,
	0x0eb7, 0x0ecd, 0x0ede, 0x0eee, 0x0efd, 0x0f0e, 0x0f14, 0x0f2b,
	0x0f41, 0x0f4a, 0x0f57, 0x0f69, 0x0f7e,
}

// Size: 6193 bytes
const deLangStr = "" +
	"AfarAbchasischAvestischAfrikaansAkanAmharischAragonesischArabischAssames" +
	"ischAwarischAymaraAserbaidschanischBaschkirischWeißrussischBulgarischBis" +
	"lamaBambara-SpracheBengalischTibetischBretonischBosnischKatalanischTsche" +
	"tschenischChamorro-SpracheKorsischCreeTschechischKirchenslawischTschuwas" +
	"chischWalisischDänischDeutschMaledivischBhutanischEweGriechischEnglischE" +
	"sperantoSpanischEstnischBaskischPersischFulFinnischFidschiFäröischFranzö" +
	"sischWestfriesischIrischSchottisches GälischGalizischGuaraniGujaratiManx" +
	"HausaHebräischHindiHiri-MotuKroatischHaitianischUngarischArmenischHerero" +
	"-SpracheInterlinguaIndonesischInterlingueIgboYiInupiakIdo-SpracheIsländi" +
	"schItalienischInuktitutJapanischJavanischGeorgischKongolesischKikuyuKwan" +
	"yamaKasachischGrönländischKambodschanischKannadaKoreanischKanuri-Sprache" +
	"KaschmirischKurdischKomi-SpracheKornischKirgisischLateinLuxemburgischGan" +
	"daLimburgischLingalaLaotischLitauischLuba-KatangaLettischMadagassischMar" +
	"schallesischMaoriMazedonischMalayalamMongolischMarathiMalaiischMaltesisc" +
	"hBirmanischNauruischNord-Ndebele-SpracheNepalesischNdongaNiederländischN" +
	"orwegisch NynorskNorwegisch BokmålSüd-Ndebele-SpracheNavajoNyanja-Sprach" +
	"eOkzitanischOjibwa-SpracheOromoOriyaOssetischPanjabiPaliPolnischPaschtuP" +
	"ortugiesischQuechuaRätoromanischRundi-SpracheRumänischRussischRuandischS" +
	"anskritSardischSindhiNord-SamischSangoSinghalesischSlowakischSlowenischS" +
	"amoanischShonaSomaliAlbanischSerbischSwaziSüd-Sotho-SpracheSundanesischS" +
	"chwedischSuaheliTamilischTeluguTadschikischThailändischTigrinjaTurkmenis" +
	"chTswana-SpracheTongaischTürkischTsongaTatarischTahitischUigurischUkrain" +
	"ischUrduUsbekischVenda-SpracheVietnamesischVolapükWallonischWolofXhosaJi" +
	"ddischYorubaZhuangChinesischZuluAceh-SpracheAcholi-SpracheAdangmeAdygeis" +
	"chTunesisches ArabischAfrihiliAghemAinu-SpracheAkkadischAlabamaAleutisch" +
	"GegischSüd-AltaischAltenglischAngikaAramäischAraukanischAraonaArapaho-Sp" +
	"racheAlgerisches ArabischArawak-SpracheMarokkanisches ArabischÄgyptische" +
	"s ArabischPareAmerikanische GebärdenspracheAsturianischKotavaAwadhiSüdas" +
	"erbaidschanischBelutschischBalinesischBairischBasaa-SpracheBamunBatak To" +
	"baGhomalaBedauyeBemba-SpracheBetawiBenaBafutBadagaBhodschpuriBikol-Sprac" +
	"heBini-SpracheBanjaresischKomBlackfoot-SpracheBishnupriyaBachtiarischBra" +
	"j-BhakhaBrahuiBodoAkooseBurjatischBuginesischBuluBlinMedumbaCaddoKaribis" +
	"chCayugaAtsamCebuanoRukigaChibcha-SpracheTschagataischTrukesischTscherem" +
	"issischChinookChoctawChipewyanCherokeeCheyenneSoraniKoptischCapiznonKrim" +
	"tatarischKaschubischDakota-SpracheDarginischTaitaDelaware-SpracheSlaveDo" +
	"gribDinka-SpracheZarmaDogriNiedersorbischZentral-DusunDualaMittelniederl" +
	"ändischDiolaDyula-SpracheDazagaEmbuEfikEmilianischÄgyptischEkajukElamis" +
	"chMittelenglischZentral-Alaska-YupikEwondoExtremadurischPangwe-SpracheFi" +
	"lipinoMeänkieliFon-SpracheCajunMittelfranzösischAltfranzösischFrankoprov" +
	"enzalischNordfriesischOstfriesischFriulischGa-SpracheGagausischGanGayoGb" +
	"aya-SpracheGabriGeezGilbertesischGilakiMittelhochdeutschAlthochdeutschGo" +
	"a-KonkaniGondi-SpracheMongondouGotischGrebo-SpracheAltgriechischSchweize" +
	"rdeutschWayúuFarefareGusiiKutchin-SpracheHaida-SpracheHakkaHawaiischFids" +
	"chi-HindiHiligaynon-SpracheHethitischMiao-SpracheObersorbischXiangHupaIb" +
	"anIbibioIlokano-SpracheInguschischIschorischJamaikanisch-kreolische Spra" +
	"cheLojbanNgombaMachameJüdisch-PersischJüdisch-ArabischJütischKarakalpaki" +
	"schKabylischKachin-SpracheJjuKambaKawiKabardinischKanembuTyapMakondeKabu" +
	"verdianuKenyangKoroKaingangKhasi-SpracheSakischKoyra ChiiniKhowarKirmanj" +
	"kiKakoKalenjinKimbundu-SpracheKomi-PermjakischKonkaniKosraeanischKpelle-" +
	"SpracheKaratschaiisch-BalkarischKrioKinaray-aKarelischOraon-SpracheShamb" +
	"alaBafiaKölschKumükischKutenai-SpracheLadinoLangiLahndaLamba-SpracheLesg" +
	"ischLingua Franca NovaLigurischLivischLakotaLombardischMongoRotse-Sprach" +
	"eLettgallischLuba-LuluaLuiseno-SpracheLunda-SpracheLuo-SpracheLushai-Spr" +
	"acheLuhyaKlassisches ChinesischLasischMaduresischMafaKhottaMaithiliMakas" +
	"sarischManding-SpracheMassai-SpracheMabaMokshaMandaresischMende-SpracheM" +
	"eruMorisyenMittelirischMakhuwa-MeettoMeta’Micmac-SpracheMinangkabau-Spra" +
	"cheMandschurischMeithei-SpracheMohawkMossi-SpracheBergmariMundangMehrspr" +
	"achigMuskogee-SpracheMirandesischMarwariMentawaiMyeneErsja-MordwinischMa" +
	"sanderanischMin NanNeapolitanischNamaNiederdeutschNewariNias-SpracheNiue" +
	"-SpracheAo-NagaKwasioNgiemboonNogaiAltnordischNovialN’KoNord-Sotho-Sprac" +
	"heNuerAlt-NewariNyamwezi-SpracheNyankoleNyoroNzimaOsage-SpracheOsmanisch" +
	"Pangasinan-SpracheMittelpersischPampanggan-SprachePapiamentoPalauPicardi" +
	"schPennsylvaniadeutschPlautdietschAltpersischPfälzischPhönikischPiemonte" +
	"sischPontischPonapeanischAltpreußischAltprovenzalischK’iche’Chimborazo H" +
	"ochland-QuechuaRajasthaniOsterinsel-SpracheRarotonganischRomagnolTarifit" +
	"RomboRomaniRotumanischRussinischRovianaAromunischRwaSandawe-SpracheJakut" +
	"ischSamaritanischSamburuSasakSantaliSaurashtraNgambaySanguSizilianischSc" +
	"hottischSassarischSenecaSenaSeriSelkupischKoyra SenniAltirischSamogitisc" +
	"hTaschelhitSchan-SpracheTschadisch-ArabischSidamoSchlesischSelayarSüd-Sa" +
	"mischLule-LappischInari-LappischSkolt-LappischSoninke-SpracheSogdischSra" +
	"nanischSerer-SpracheSahoSaterfriesischSukuma-SpracheSusuSumerischKomoris" +
	"chKongo-SuaheliAltsyrischSyrischSchlesisch (Polen)TuluTemneTesoTereno-Sp" +
	"racheTetum-SpracheTigreTiv-SpracheTokelauanischTsachurischKlingonischTli" +
	"ngit-SpracheTalischTamaseqTsonga-SpracheNeumelanesischTuroyoTarokoTsakon" +
	"ischTsimshian-SpracheTatischTumbuka-SpracheElliceanischTasawaqTuwinischZ" +
	"entralatlas-TamazightUdmurtischUgaritischMbundu-SpracheRootVaiVenetischW" +
	"epsischWestflämischMainfränkischWotischVõroVunjoWalser-DialekteWalamo-Sp" +
	"racheWarayWasho-SpracheWuKalmückischMingrelischSogaYao-SpracheYapesischY" +
	"angbenYembaNheengatuKantonesischZapotekischBliss-SymboleSeeländischZenag" +
	"aTamazightZuni-SpracheKeine SprachinhalteZazaModernes HocharabischÖsterr" +
	"eichisches DeutschSchweizer HochdeutschAustralisches EnglischKanadisches" +
	" EnglischBritisches EnglischAmerikanisches EnglischLateinamerikanisches " +
	"SpanischEuropäisches SpanischMexikanisches SpanischKanadisches Französis" +
	"chSchweizer FranzösischFlämischBrasilianisches PortugiesischEuropäisches" +
	" PortugiesischMoldauischSerbo-KroatischChinesisch (vereinfacht)Chinesisc" +
	"h (traditionell)"

// Size: 1234 bytes, 605 elements
var deLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000e, 0x0017, 0x0020, 0x0024, 0x002d, 0x0039,
	0x0041, 0x004c, 0x0054, 0x005a, 0x006b, 0x0077, 0x0084, 0x008e,
	0x0095, 0x00a4, 0x00ae, 0x00b7, 0x00c1, 0x00c9, 0x00d4, 0x00e3,
	0x00f3, 0x00fb, 0x00ff, 0x010a, 0x0119, 0x0127, 0x0130, 0x0138,
	0x013f, 0x014a, 0x0154, 0x0157, 0x0161, 0x0169, 0x0172, 0x017a,
	0x0182, 0x018a, 0x0192, 0x0195, 0x019d, 0x01a4, 0x01ae, 0x01ba,
	0x01c7, 0x01cd, 0x01e2, 0x01eb, 0x01f2, 0x01fa, 0x01fe, 0x0203,
	0x020d, 0x0212, 0x021b, 0x0224, 0x022f, 0x0238, 0x0241, 0x024f,
	// Entry 40 - 7F
	0x025a, 0x0265, 0x0270, 0x0274, 0x0276, 0x027d, 0x0288, 0x0293,
	0x029e, 0x02a7, 0x02b0, 0x02b9, 0x02c2, 0x02ce, 0x02d4, 0x02dc,
	0x02e6, 0x02f4, 0x0303, 0x030a, 0x0314, 0x0322, 0x032e, 0x0336,
	0x0342, 0x034a, 0x0354, 0x035a, 0x0367, 0x036c, 0x0377, 0x037e,
	0x0386, 0x038f, 0x039b, 0x03a3, 0x03af, 0x03be, 0x03c3, 0x03ce,
	0x03d7, 0x03e1, 0x03e8, 0x03f1, 0x03fb, 0x0405, 0x040e, 0x0422,
	0x042d, 0x0433, 0x0442, 0x0454, 0x0466, 0x047a, 0x0480, 0x048e,
	0x0499, 0x04a7, 0x04ac, 0x04b1, 0x04ba, 0x04c1, 0x04c5, 0x04cd,
	// Entry 80 - BF
	0x04d4, 0x04e1, 0x04e8, 0x04f6, 0x0503, 0x050d, 0x0515, 0x051e,
	0x0526, 0x052e, 0x0534, 0x0540, 0x0545, 0x0552, 0x055c, 0x0566,
	0x0570, 0x0575, 0x057b, 0x0584, 0x058c, 0x0591, 0x05a3, 0x05af,
	0x05b9, 0x05c0, 0x05c9, 0x05cf, 0x05db, 0x05e8, 0x05f0, 0x05fb,
	0x0609, 0x0612, 0x061b, 0x0621, 0x062a, 0x0633, 0x063c, 0x0646,
	0x064a, 0x0653, 0x0660, 0x066d, 0x0675, 0x067f, 0x0684, 0x0689,
	0x0691, 0x0697, 0x069d, 0x06a7, 0x06ab, 0x06b7, 0x06c5, 0x06cc,
	0x06d5, 0x06e9, 0x06f1, 0x06f6, 0x0702, 0x070b, 0x0712, 0x071b,
	// Entry C0 - FF
	0x0722, 0x072f, 0x073a, 0x0740, 0x074a, 0x0755, 0x075b, 0x076a,
	0x077e, 0x078c, 0x07a3, 0x07b8, 0x07bc, 0x07da, 0x07e6, 0x07ec,
	0x07f2, 0x0807, 0x0813, 0x081e, 0x0826, 0x0833, 0x0838, 0x0842,
	0x0849, 0x0850, 0x085d, 0x0863, 0x0867, 0x086c, 0x0872, 0x087d,
	0x088a, 0x0896, 0x08a2, 0x08a5, 0x08b6, 0x08c1, 0x08cd, 0x08d8,
	0x08de, 0x08e2, 0x08e8, 0x08f2, 0x08fd, 0x0901, 0x0905, 0x090c,
	0x0911, 0x091a, 0x0920, 0x0925, 0x092c, 0x0932, 0x0941, 0x094e,
	0x0958, 0x0967, 0x096e, 0x0975, 0x097e, 0x0986, 0x098e, 0x0994,
	// Entry 100 - 13F
	0x099c, 0x09a4, 0x09b1, 0x09bc, 0x09ca, 0x09d4, 0x09d9, 0x09e9,
	0x09ee, 0x09f4, 0x0a01, 0x0a06, 0x0a0b, 0x0a19, 0x0a26, 0x0a2b,
	0x0a40, 0x0a45, 0x0a52, 0x0a58, 0x0a5c, 0x0a60, 0x0a6b, 0x0a75,
	0x0a7b, 0x0a83, 0x0a91, 0x0aa5, 0x0aab, 0x0ab9, 0x0ac7, 0x0acf,
	0x0ad9, 0x0ae4, 0x0ae9, 0x0afb, 0x0b0a, 0x0b1d, 0x0b2a, 0x0b36,
	0x0b3f, 0x0b49, 0x0b53, 0x0b56, 0x0b5a, 0x0b67, 0x0b6c, 0x0b70,
	0x0b7d, 0x0b83, 0x0b94, 0x0ba2, 0x0bad, 0x0bba, 0x0bc3, 0x0bca,
	0x0bd7, 0x0be4, 0x0bf4, 0x0bfa, 0x0c02, 0x0c07, 0x0c16, 0x0c23,
	// Entry 140 - 17F
	0x0c28, 0x0c31, 0x0c3e, 0x0c50, 0x0c5a, 0x0c66, 0x0c72, 0x0c77,
	0x0c7b, 0x0c7f, 0x0c85, 0x0c94, 0x0c9f, 0x0ca9, 0x0cc8, 0x0cce,
	0x0cd4, 0x0cdb, 0x0cec, 0x0cfd, 0x0d05, 0x0d13, 0x0d1c, 0x0d2a,
	0x0d2d, 0x0d32, 0x0d36, 0x0d42, 0x0d49, 0x0d4d, 0x0d54, 0x0d60,
	0x0d67, 0x0d6b, 0x0d73, 0x0d80, 0x0d87, 0x0d93, 0x0d99, 0x0da2,
	0x0da6, 0x0dae, 0x0dbe, 0x0dce, 0x0dd5, 0x0de1, 0x0def, 0x0e08,
	0x0e0c, 0x0e15, 0x0e1e, 0x0e2b, 0x0e33, 0x0e38, 0x0e3f, 0x0e49,
	0x0e58, 0x0e5e, 0x0e63, 0x0e69, 0x0e76, 0x0e7e, 0x0e90, 0x0e99,
	// Entry 180 - 1BF
	0x0ea0, 0x0ea6, 0x0eb1, 0x0eb6, 0x0ec3, 0x0ecf, 0x0ed9, 0x0ee8,
	0x0ef5, 0x0f00, 0x0f0e, 0x0f13, 0x0f29, 0x0f30, 0x0f3b, 0x0f3f,
	0x0f45, 0x0f4d, 0x0f59, 0x0f68, 0x0f76, 0x0f7a, 0x0f80, 0x0f8c,
	0x0f99, 0x0f9d, 0x0fa5, 0x0fb1, 0x0fbf, 0x0fc6, 0x0fd4, 0x0fe7,
	0x0ff4, 0x1003, 0x1009, 0x1016, 0x101e, 0x1025, 0x1031, 0x1041,
	0x104d, 0x1054, 0x105c, 0x1061, 0x1072, 0x1080, 0x1087, 0x1095,
	0x1099, 0x10a6, 0x10ac, 0x10b8, 0x10c4, 0x10cb, 0x10d1, 0x10da,
	0x10df, 0x10ea, 0x10f0, 0x10f6, 0x1108, 0x110c, 0x1116, 0x1126,
	// Entry 1C0 - 1FF
	0x112e, 0x1133, 0x1138, 0x1145, 0x114e, 0x1160, 0x116e, 0x1180,
	0x118a, 0x118f, 0x1199, 0x11ac, 0x11b8, 0x11c3, 0x11cd, 0x11d8,
	0x11e5, 0x11ed, 0x11f9, 0x1206, 0x1216, 0x1221, 0x123c, 0x1246,
	0x1258, 0x1266, 0x126e, 0x1275, 0x127a, 0x1280, 0x128b, 0x1295,
	0x129c, 0x12a6, 0x12a9, 0x12b8, 0x12c1, 0x12ce, 0x12d5, 0x12da,
	0x12e1, 0x12eb, 0x12f2, 0x12f7, 0x1303, 0x130d, 0x1317, 0x131d,
	0x1321, 0x1325, 0x132f, 0x133a, 0x1343, 0x134e, 0x1358, 0x1365,
	0x1378, 0x137e, 0x1388, 0x138f, 0x139b, 0x13a8, 0x13b6, 0x13c4,
	// Entry 200 - 23F
	0x13d3, 0x13db, 0x13e5, 0x13f2, 0x13f6, 0x1404, 0x1412, 0x1416,
	0x141f, 0x1428, 0x1435, 0x143f, 0x1446, 0x1458, 0x145c, 0x1461,
	0x1465, 0x1473, 0x1480, 0x1485, 0x1490, 0x149d, 0x14a8, 0x14b3,
	0x14c2, 0x14c9, 0x14d0, 0x14de, 0x14ec, 0x14f2, 0x14f8, 0x1502,
	0x1513, 0x151a, 0x1529, 0x1535, 0x153c, 0x1545, 0x155b, 0x1565,
	0x156f, 0x157d, 0x1581, 0x1584, 0x158d, 0x1595, 0x15a2, 0x15b0,
	0x15b7, 0x15bc, 0x15c1, 0x15d0, 0x15de, 0x15e3, 0x15f0, 0x15f0,
	0x15f2, 0x15fe, 0x1609, 0x160d, 0x1618, 0x1621, 0x1628, 0x162d,
	// Entry 240 - 27F
	0x1636, 0x1642, 0x164d, 0x165a, 0x1666, 0x166c, 0x1675, 0x1681,
	0x1694, 0x1698, 0x16ad, 0x16c6, 0x16db, 0x16f1, 0x1705, 0x1718,
	0x172f, 0x174c, 0x1762, 0x1778, 0x1790, 0x17a6, 0x17af, 0x17cc,
	0x17e7, 0x17f1, 0x1800, 0x1818, 0x1831,
}

// Size: 8765 bytes
const elLangStr = "" +
	"ΑφάρΑμπχαζικάΑβεστάνΑφρικάανςΑκάνΑμαρικάΑραγκονικάΑραβικάΑσαμεζικάΆβαρικ" +
	"ΑϊμάραΑζερμπαϊτζανικάΜπασκίρΛευκορωσικάΒουλγαρικάΜπισλάμαΜπαμπάραΜπενγκ" +
	"άλιΘιβετιανάΒρετονικάΒοσνιακάΚαταλανικάΤσέτσνιανΚαμόρροΚορσικανικάΚριΤσ" +
	"εχικάΕκκλησιαστικά ΣλαβικάΧουβάςΟυαλικάΔανικάΓερμανικάΝτιβέχιΝτζόνγκχαΓ" +
	"ιΕλληνικάΑγγλικάΕσπεράντοΙσπανικάΕσθονικάΒασκικάΠερσικάΦουλάχΦινλανδικά" +
	"ΦίτζιΦαρόεΓαλλικάΔυτικά ΦριζιανάΙρλανδικάΣκωτικά ΚελτικάΓαλικιανάΓκουαρ" +
	"ανίΓκουγιαράτιΜανξΧάουσαΕβραϊκάΧίντιΧίρι ΜότουΚροατικάΑϊτιανάΟυγγρικάΑρ" +
	"μενικάΧερέροΙντερλίνγκουαΙνδονησιακάΙντερλίνγκουεΊγκμποΣικουάν ΓιΙνουπι" +
	"άκΊντοΙσλανδικάΙταλικάΙνουκτιτούτΙαπωνικάΙαβανεζικάΓεωργιανάΚονγκόΚικού" +
	"γιουΚουανιγιάμαΚαζακικάΚαλαάλισουτΚαμποτζιανάΚανάνταΚορεατικάΚανούριΚασ" +
	"μίριΚουρδικάΚόμιΚόρνιςΚυργιζικάΛατινικάΛουξεμβουργιανάΓκάνταΛιμβουργιαν" +
	"άΛινγκάλαΛαοθιανάΛιθουανικάΛούμπα-ΚατάνγκαΛετονικάΜαλαγάσιΜάρσαλΜάοριΣλ" +
	"αβομακεδονικάΜαλαγιαλάμΜογγολικάΜαράθιΜαλάιΜαλτεζικάΒιρμανικάΝαούρουΝτε" +
	"μπέλε ΒορράΝεπάλιΝτόνγκαΟλλανδικάΝορβηγικά ΝινόρσκΝορβηγικά ΜποκμάλΝτεμ" +
	"πέλε ΝότουΝάβαχοΝιάντζαΟκσιτανικάΟζιβίγουαΟρόμοΟρίγιαΟσετικάΠαντζαπικάΠ" +
	"άλιΠολωνικάΠάστοΠορτογαλικάΚετσούαΡομανικάΡούντιΡουμανικάΡωσικάΚινιαρβά" +
	"νταΣανσκριτικάΣαρδινικάΣίντιΒόρεια ΣάμιΣάνγκοΣινχαλεζικάΣλοβακικάΣλοβεν" +
	"ικάΣαμόανΣχόναΣομάλιΑλβανικάΣερβικάΣουάτιΝότια ΣόθοΣουδανικάΣουηδικάΣου" +
	"αχίλιΤαμίλΤελούγκουΤατζίκΤαϊλανδικάΤιγκρίνυαΤουρκμενικάΤσιγουάναΤονγκαν" +
	"ικάΤουρκικάΤσόνγκαΤατάρΤαϊτιανάΟυιγουρικάΟυκρανικάΟυρντούΟυζμπεκικάΒένδ" +
	"αΒιετναμικάΒόλαπικΓουαλούνΓουόλοφΖόσαΓίντιςΓιορούμπαΖουάνγκΚινεζικάΖουλ" +
	"ούΑχινίζΑκολίΑντάνγκμεΑντιγκέαΑφριχίλιΑγκέμΑϊνούΑκάντιανΑλούτΝότια Αλατ" +
	"αϊκάΠαλαιά ΑγγλικάΑνγκικάΑραμαϊκάΑρουκάνιανΑράπαχοΑραγουάκΆσουΑστουριαν" +
	"άΑγουαντίΜπαλούτσιΜπαλινίζΜπάσαΜπαμούνΓκομάλαΜπέζαΜπέμπαΜπέναΜπαφούτΜπο" +
	"ζπούριΜπικόλΜπίνιΚομΣικσίκαΜπρατζΜπόντοΑκόσιΜπουριάτΜπουγκίζΜπουλούΜπλι" +
	"νΜεντούμπαΚάντοΚαρίμπΚαγιούγκαΑτσάμΚεμπουάνοΤσίγκαΤσίμπτσαΤσαγκατάιΤσου" +
	"κίζιΜάριΙδιωματικά ΣινούκΤσοκτάουΤσίπιουανΤσερόκιΣεγιένΚουρδικά ΣοράνιΚ" +
	"οπτικάΤουρκικά ΚριμαίαςΚασούμπιανΝτακόταΝτάργκουαΤάιταΝτέλαγουερΣλαβικά" +
	"ΝτόγκριμπΝτίνκαΖάρμαΝτόγκριΓλώσσα Κάτω ΛουσατίαςΝτουάλαΜέσα ΟλλανδικάΤζ" +
	"όλα-ΦόνιΝτογιούλαΝταζάγκαΈμπουΕφίκΑρχαία ΑιγυπτιακάΕκατζούκΕλαμάιτΜέσα " +
	"ΑγγλικάΕγουόντοΦανγκΦιλιππινεζικάΦονΜέσα ΓαλλικάΠαλαιά ΓαλλικάΒόρεια Φρ" +
	"ιζιανάΑνατολικά ΦριζιανάΦριούλιανΓκαΓκαγκάουζΓκάγιοΓκμπάγιαΓκιζΓκιλμπερ" +
	"τίζΜέσα Άνω ΓερμανικάΠαλαιά Άνω ΓερμανικάΓκόντιΓκοροντάλοΓοτθικάΓκρίμπο" +
	"Αρχαία ΕλληνικάΕλβετικά ΓερμανικάΓκούσιΓκουίτσινΧάινταΧαβανεζικάΧιλιγκα" +
	"γιόνΧιτίτεΧμονγκΓλώσσα Άνω ΛουσατίαςΧούπαΙμπάνΙμπίμπιοΙλόκοΙνγκούςΛόζμπ" +
	"ανΝγκόμπαΜάχαμεΙουδαϊκά-ΠερσικάΙουδαϊκά-ΑραβικάΚάρα-ΚαλπάκΚαμπίλεΚατσίν" +
	"ΤζουΚάμπαΚάουιΚαμπαρντιανάΚανέμπουΤουάπΜακόντεΓλώσσα του Πράσινου Ακρωτ" +
	"ηρίουΚόροΚάσιΚοτανικάΚόιρα ΤσίνιΚάκοΚαλεντζίνΚιμπούντουΚόμι-ΠερμιάκΚονκ" +
	"άνιΚοσραενικάΚπέλεΚαρατσάι-ΜπαλκάρΚαρελιακάΚουρούχΣάμπαλαΜπάφιαΚολωνικά" +
	"ΚουμγιούκΚουτενάιΛαδίνοΛάνγκιΛάχδαΛάμπαΛαζγκιάνΛακόταΜόνγκοΛόζιΛούμπα-Λ" +
	"ουλούαΛουισένοΛούνταΛούοΛουσάιΛουχίαΜαντουρίζΜάφαΜαγκάχιΜαϊτχίλιΜακαζάρ" +
	"ΜαντίνγκοΜασάιΜάμπαΜόκσαΜανδάρΜέντεΜερούΜορίσιενΜέσα ΙρλανδικάΜακούβα-Μ" +
	"έτοΜετάΜικμάκΜινανγκαμπάουΜαντσούΜανιπούριΜοχόκΜόσιΜουντάνγκΠολλαπλές γ" +
	"λώσσεςΚρικΜιραντεζικάΜαργουάριΜιένεΈρζυαΝαπολιτανικάΝάμαΚάτω ΓερμανικάΝ" +
	"εγουάριΝίαςΝιούεανΚβάσιοΝγκιεμπούνΝογκάιΠαλαιά ΝορβηγικάΝ’ΚοΒόρεια Σόθο" +
	"ΝουέρΚλασικά ΝεουάριΝιαμγουέζιΝιανκόλεΝιόροΝζίμαΟσάζΟθωμανικά ΤουρκικάΠ" +
	"ανγκασινάνΠαχλάβιΠαμπάνγκαΠαπιαμέντοΠαλάουανΑρχαία ΠερσικάΦοινικικάΠοχπ" +
	"έιανΠαλαιά ΠροβενσιάλΚισέΡαζασθάνιΡαπανούιΡαροτονγκάνΡόμποΡομανίΑρομανι" +
	"κάΡουάΣαντάγουεΓιακούτΣαμαρίτικα ΑραμαϊκάΣαμπούρουΣασάκΣαντάλιΝγκαμπέιΣ" +
	"άνγκουΣικελιανάΣκωτικάΣένεκαΣέναΣελκούπΚοϊραμπόρο ΣένιΠαλαιά ΙρλανδικάΤ" +
	"ασελχίτΣανΑραβικά του ΤσαντΣιντάμοΝότια ΣάμιΛούλε ΣάμιΙνάρι ΣάμιΣκολτ Σ" +
	"άμιΣονίνκεΣογκντιένΣρανάρ ΤόνγκοΣερέρΣάχοΣουκούμαΣούσουΣουμερικάΚομόρρι" +
	"αΚονγκό ΣουαχίλιΚλασικά ΣυριακάΣυριακάΤίμνεΤέσοΤερένοΤέτουμΤίγκρεΤιβΤοκ" +
	"ελάουΚλίνγκονΤλίνγκιτΤαμασέκΝιάσα ΤόνγκαΤοκ ΠισίνΤαρόκοΤσίμσιανΤουμπούκ" +
	"αΤουβαλούΤασαβάκΤουβίνιανΤαμαζίτ Κεντρικού ΜαρόκοΟυντμούρτΟυγκαρίτικΟυμ" +
	"πούντουΡουτΒάιΒότικΒούντζοΒάλσερΓουάλαμοΓουάρειΓουασόΚαλμίκΣόγκαΓιάοΓια" +
	"πίζΓιανγκμπένΓιέμπαΚαντονέζικαΖάποτεκΣύμβολα BlissΖενάγκαΤυπικά Ταμαζίγ" +
	"κτ ΜαρόκουΖούνιΧωρίς γλωσσολογικό περιεχόμενοΖάζαΣύγχρονα Τυπικά Αραβικ" +
	"άΓερμανικά ΑυστρίαςΓερμανικά ΕλβετίαςΑγγλικά ΑυστραλίαςΑγγλικά ΚαναδάΑγ" +
	"γλικά Ηνωμένου ΒασιλείουΑγγλικά ΑμερικήςΙσπανικά Λατινικής ΑμερικήςΙσπα" +
	"νικά ΕυρώπηςΙσπανικά ΜεξικούΓαλλικά ΚαναδάΓαλλικά ΕλβετίαςΦλαμανδικάΠορ" +
	"τογαλικά ΒραζιλίαςΠορτογαλικά ΕυρώπηςΜολδαβικάΣερβοκροατικάΑπλοποιημένα" +
	" ΚινεζικάΠαραδοσιακά Κινεζικά"

// Size: 1234 bytes, 605 elements
var elLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0008, 0x001a, 0x0028, 0x003a, 0x0042, 0x0050, 0x0064,
	0x0072, 0x0084, 0x0090, 0x009c, 0x00ba, 0x00c8, 0x00de, 0x00f2,
	0x0102, 0x0112, 0x0124, 0x0136, 0x0148, 0x0158, 0x016c, 0x017e,
	0x018c, 0x01a2, 0x01a8, 0x01b6, 0x01df, 0x01eb, 0x01f9, 0x0205,
	0x0217, 0x0225, 0x0237, 0x023b, 0x024b, 0x0259, 0x026b, 0x027b,
	0x028b, 0x0299, 0x02a7, 0x02b3, 0x02c7, 0x02d1, 0x02db, 0x02e9,
	0x0306, 0x0318, 0x0335, 0x0347, 0x0359, 0x036f, 0x0377, 0x0383,
	0x0391, 0x039b, 0x03ae, 0x03be, 0x03cc, 0x03dc, 0x03ec, 0x03f8,
	// Entry 40 - 7F
	0x0412, 0x0428, 0x0442, 0x044e, 0x0461, 0x0471, 0x0479, 0x048b,
	0x0499, 0x04af, 0x04bf, 0x04d3, 0x04e5, 0x04f1, 0x0503, 0x0519,
	0x0529, 0x053f, 0x0555, 0x0563, 0x0575, 0x0583, 0x0591, 0x05a1,
	0x05a9, 0x05b5, 0x05c7, 0x05d7, 0x05f5, 0x0601, 0x0619, 0x0629,
	0x0639, 0x064d, 0x066a, 0x067a, 0x068a, 0x0696, 0x06a0, 0x06be,
	0x06d2, 0x06e4, 0x06f0, 0x06fa, 0x070c, 0x071e, 0x072c, 0x0747,
	0x0753, 0x0761, 0x0773, 0x0794, 0x07b5, 0x07d0, 0x07dc, 0x07ea,
	0x07fe, 0x0810, 0x081a, 0x0826, 0x0834, 0x0848, 0x0850, 0x0860,
	// Entry 80 - BF
	0x086a, 0x0880, 0x088e, 0x089e, 0x08aa, 0x08bc, 0x08c8, 0x08de,
	0x08f4, 0x0906, 0x0910, 0x0925, 0x0931, 0x0947, 0x0959, 0x096b,
	0x0977, 0x0981, 0x098d, 0x099d, 0x09ab, 0x09b7, 0x09ca, 0x09dc,
	0x09ec, 0x09fc, 0x0a06, 0x0a18, 0x0a24, 0x0a38, 0x0a4a, 0x0a60,
	0x0a72, 0x0a86, 0x0a96, 0x0aa4, 0x0aae, 0x0abe, 0x0ad2, 0x0ae4,
	0x0af2, 0x0b06, 0x0b10, 0x0b24, 0x0b32, 0x0b42, 0x0b50, 0x0b58,
	0x0b64, 0x0b76, 0x0b84, 0x0b94, 0x0ba0, 0x0bac, 0x0bb6, 0x0bc8,
	0x0bd8, 0x0bd8, 0x0be8, 0x0bf2, 0x0bfc, 0x0c0c, 0x0c0c, 0x0c16,
	// Entry C0 - FF
	0x0c16, 0x0c31, 0x0c4c, 0x0c5a, 0x0c6a, 0x0c7e, 0x0c7e, 0x0c8c,
	0x0c8c, 0x0c9c, 0x0c9c, 0x0c9c, 0x0ca4, 0x0ca4, 0x0cb8, 0x0cb8,
	0x0cc8, 0x0cc8, 0x0cda, 0x0cea, 0x0cea, 0x0cf4, 0x0d02, 0x0d02,
	0x0d10, 0x0d1a, 0x0d26, 0x0d26, 0x0d30, 0x0d3e, 0x0d3e, 0x0d50,
	0x0d5c, 0x0d66, 0x0d66, 0x0d6c, 0x0d7a, 0x0d7a, 0x0d7a, 0x0d86,
	0x0d86, 0x0d92, 0x0d9c, 0x0dac, 0x0dbc, 0x0dca, 0x0dd4, 0x0de6,
	0x0df0, 0x0dfc, 0x0e0e, 0x0e18, 0x0e2a, 0x0e36, 0x0e46, 0x0e58,
	0x0e68, 0x0e70, 0x0e91, 0x0ea1, 0x0eb3, 0x0ec1, 0x0ecd, 0x0eea,
	// Entry 100 - 13F
	0x0ef8, 0x0ef8, 0x0f19, 0x0f2d, 0x0f3b, 0x0f4d, 0x0f57, 0x0f6b,
	0x0f79, 0x0f8b, 0x0f97, 0x0fa1, 0x0faf, 0x0fd7, 0x0fd7, 0x0fe5,
	0x1000, 0x1013, 0x1025, 0x1035, 0x103f, 0x1047, 0x1047, 0x1068,
	0x1078, 0x1086, 0x109d, 0x109d, 0x10ad, 0x10ad, 0x10b7, 0x10d1,
	0x10d1, 0x10d7, 0x10d7, 0x10ee, 0x1109, 0x1109, 0x1126, 0x1149,
	0x115b, 0x1161, 0x1173, 0x1173, 0x117f, 0x118f, 0x118f, 0x1197,
	0x11ad, 0x11ad, 0x11cf, 0x11f5, 0x11f5, 0x1201, 0x1215, 0x1223,
	0x1231, 0x124e, 0x1271, 0x1271, 0x1271, 0x127d, 0x128f, 0x129b,
	// Entry 140 - 17F
	0x129b, 0x12af, 0x12af, 0x12c5, 0x12d1, 0x12dd, 0x1303, 0x1303,
	0x130d, 0x1317, 0x1327, 0x1331, 0x133f, 0x133f, 0x133f, 0x134d,
	0x135b, 0x1367, 0x1386, 0x13a5, 0x13a5, 0x13ba, 0x13c8, 0x13d4,
	0x13dc, 0x13e6, 0x13f0, 0x1408, 0x1418, 0x1422, 0x1430, 0x1469,
	0x1469, 0x1471, 0x1471, 0x1479, 0x1489, 0x149e, 0x149e, 0x149e,
	0x14a6, 0x14b8, 0x14cc, 0x14e3, 0x14f1, 0x1505, 0x150f, 0x152e,
	0x152e, 0x152e, 0x1540, 0x154e, 0x155c, 0x1568, 0x1578, 0x158a,
	0x159a, 0x15a6, 0x15b2, 0x15bc, 0x15c6, 0x15d6, 0x15d6, 0x15d6,
	// Entry 180 - 1BF
	0x15d6, 0x15e2, 0x15e2, 0x15ee, 0x15f6, 0x15f6, 0x1611, 0x1621,
	0x162d, 0x1635, 0x1641, 0x164d, 0x164d, 0x164d, 0x165f, 0x1667,
	0x1675, 0x1685, 0x1693, 0x16a5, 0x16af, 0x16b9, 0x16c3, 0x16cf,
	0x16d9, 0x16e3, 0x16f3, 0x170e, 0x1725, 0x172d, 0x1739, 0x1753,
	0x1761, 0x1773, 0x177d, 0x1785, 0x1785, 0x1797, 0x17b8, 0x17c0,
	0x17d6, 0x17e8, 0x17e8, 0x17f2, 0x17fc, 0x17fc, 0x17fc, 0x1814,
	0x181c, 0x1837, 0x1847, 0x184f, 0x185d, 0x185d, 0x1869, 0x187d,
	0x1889, 0x18a8, 0x18a8, 0x18b1, 0x18c6, 0x18d0, 0x18ed, 0x1901,
	// Entry 1C0 - 1FF
	0x1911, 0x191b, 0x1925, 0x192d, 0x1950, 0x1966, 0x1974, 0x1986,
	0x199a, 0x19aa, 0x19aa, 0x19aa, 0x19aa, 0x19c5, 0x19c5, 0x19d7,
	0x19d7, 0x19d7, 0x19e7, 0x19e7, 0x1a08, 0x1a10, 0x1a10, 0x1a22,
	0x1a32, 0x1a48, 0x1a48, 0x1a48, 0x1a52, 0x1a5e, 0x1a5e, 0x1a5e,
	0x1a5e, 0x1a70, 0x1a78, 0x1a8a, 0x1a98, 0x1abd, 0x1acf, 0x1ad9,
	0x1ae7, 0x1ae7, 0x1af7, 0x1b05, 0x1b17, 0x1b25, 0x1b25, 0x1b31,
	0x1b39, 0x1b39, 0x1b47, 0x1b64, 0x1b83, 0x1b83, 0x1b93, 0x1b99,
	0x1bb9, 0x1bc7, 0x1bc7, 0x1bc7, 0x1bda, 0x1bed, 0x1c00, 0x1c13,
	// Entry 200 - 23F
	0x1c21, 0x1c33, 0x1c4c, 0x1c56, 0x1c5e, 0x1c5e, 0x1c6e, 0x1c7a,
	0x1c8c, 0x1c9c, 0x1cb9, 0x1cd6, 0x1ce4, 0x1ce4, 0x1ce4, 0x1cee,
	0x1cf6, 0x1d02, 0x1d0e, 0x1d1a, 0x1d20, 0x1d30, 0x1d30, 0x1d40,
	0x1d50, 0x1d50, 0x1d5e, 0x1d75, 0x1d86, 0x1d86, 0x1d92, 0x1d92,
	0x1da2, 0x1da2, 0x1db4, 0x1dc4, 0x1dd2, 0x1de4, 0x1e12, 0x1e24,
	0x1e38, 0x1e4c, 0x1e54, 0x1e5a, 0x1e5a, 0x1e5a, 0x1e5a, 0x1e5a,
	0x1e64, 0x1e64, 0x1e72, 0x1e7e, 0x1e8e, 0x1e9c, 0x1ea8, 0x1ea8,
	0x1ea8, 0x1eb4, 0x1eb4, 0x1ebe, 0x1ec6, 0x1ed2, 0x1ee6, 0x1ef2,
	// Entry 240 - 27F
	0x1ef2, 0x1f08, 0x1f16, 0x1f2a, 0x1f2a, 0x1f38, 0x1f66, 0x1f70,
	0x1faa, 0x1fb2, 0x1fde, 0x2001, 0x2024, 0x2047, 0x2062, 0x2094,
	0x20b3, 0x20e7, 0x2106, 0x2125, 0x2140, 0x215f, 0x2173, 0x219c,
	0x21c1, 0x21d3, 0x21ed, 0x2216, 0x223d,
}

// Size: 4849 bytes
const enLangStr = "" +
	"AfarAbkhazianAvestanAfrikaansAkanAmharicAragoneseArabicAssameseAvaricAym" +
	"araAzerbaijaniBashkirBelarusianBulgarianBislamaBambaraBengaliTibetanBret" +
	"onBosnianCatalanChechenChamorroCorsicanCreeCzechChurch SlavicChuvashWels" +
	"hDanishGermanDivehiDzongkhaEweGreekEnglishEsperantoSpanishEstonianBasque" +
	"PersianFulahFinnishFijianFaroeseFrenchWestern FrisianIrishScottish Gaeli" +
	"cGalicianGuaraniGujaratiManxHausaHebrewHindiHiri MotuCroatianHaitianHung" +
	"arianArmenianHereroInterlinguaIndonesianInterlingueIgboSichuan YiInupiaq" +
	"IdoIcelandicItalianInuktitutJapaneseJavaneseGeorgianKongoKikuyuKuanyamaK" +
	"azakhKalaallisutKhmerKannadaKoreanKanuriKashmiriKurdishKomiCornishKyrgyz" +
	"LatinLuxembourgishGandaLimburgishLingalaLaoLithuanianLuba-KatangaLatvian" +
	"MalagasyMarshalleseMaoriMacedonianMalayalamMongolianMarathiMalayMalteseB" +
	"urmeseNauruNorth NdebeleNepaliNdongaDutchNorwegian NynorskNorwegian Bokm" +
	"ålSouth NdebeleNavajoNyanjaOccitanOjibwaOromoOriyaOsseticPunjabiPaliPol" +
	"ishPashtoPortugueseQuechuaRomanshRundiRomanianRussianKinyarwandaSanskrit" +
	"SardinianSindhiNorthern SamiSangoSinhalaSlovakSlovenianSamoanShonaSomali" +
	"AlbanianSerbianSwatiSouthern SothoSundaneseSwedishSwahiliTamilTeluguTaji" +
	"kThaiTigrinyaTurkmenTswanaTonganTurkishTsongaTatarTahitianUyghurUkrainia" +
	"nUrduUzbekVendaVietnameseVolapükWalloonWolofXhosaYiddishYorubaZhuangChin" +
	"eseZuluAchineseAcoliAdangmeAdygheTunisian ArabicAfrihiliAghemAinuAkkadia" +
	"nAlabamaAleutGheg AlbanianSouthern AltaiOld EnglishAngikaAramaicMapucheA" +
	"raonaArapahoAlgerian ArabicArawakMoroccan ArabicEgyptian ArabicAsuAmeric" +
	"an Sign LanguageAsturianKotavaAwadhiSouth AzerbaijaniBaluchiBalineseBava" +
	"rianBasaaBamunBatak TobaGhomalaBejaBembaBetawiBenaBafutBadagaBhojpuriBik" +
	"olBiniBanjarKomSiksikaBishnupriyaBakhtiariBrajBrahuiBodoAkooseBuriatBugi" +
	"neseBuluBlinMedumbaCaddoCaribCayugaAtsamCebuanoChigaChibchaChagataiChuuk" +
	"eseMariChinook JargonChoctawChipewyanCherokeeCheyenneCentral KurdishCopt" +
	"icCapiznonCrimean TurkishKashubianDakotaDargwaTaitaDelawareSlaveDogribDi" +
	"nkaZarmaDogriLower SorbianCentral DusunDualaMiddle DutchJola-FonyiDyulaD" +
	"azagaEmbuEfikEmilianAncient EgyptianEkajukElamiteMiddle EnglishCentral Y" +
	"upikEwondoExtremaduranFangFilipinoTornedalen FinnishFonCajun FrenchMiddl" +
	"e FrenchOld FrenchArpitanNorthern FrisianEastern FrisianFriulianGaGagauz" +
	"Gan ChineseGayoGbayaZoroastrian DariGeezGilberteseGilakiMiddle High Germ" +
	"anOld High GermanGoan KonkaniGondiGorontaloGothicGreboAncient GreekSwiss" +
	" GermanWayuuFrafraGusiiGwichʼinHaidaHakka ChineseHawaiianFiji HindiHilig" +
	"aynonHittiteHmongUpper SorbianXiang ChineseHupaIbanIbibioIlokoIngushIngr" +
	"ianJamaican Creole EnglishLojbanNgombaMachameJudeo-PersianJudeo-ArabicJu" +
	"tishKara-KalpakKabyleKachinJjuKambaKawiKabardianKanembuTyapMakondeKabuve" +
	"rdianuKenyangKoroKaingangKhasiKhotaneseKoyra ChiiniKhowarKirmanjkiKakoKa" +
	"lenjinKimbunduKomi-PermyakKonkaniKosraeanKpelleKarachay-BalkarKrioKinara" +
	"y-aKarelianKurukhShambalaBafiaColognianKumykKutenaiLadinoLangiLahndaLamb" +
	"aLezghianLingua Franca NovaLigurianLivonianLakotaLombardMongoLoziLatgali" +
	"anLuba-LuluaLuisenoLundaLuoMizoLuyiaLiterary ChineseLazMadureseMafaMagah" +
	"iMaithiliMakasarMandingoMasaiMabaMokshaMandarMendeMeruMorisyenMiddle Iri" +
	"shMakhuwa-MeettoMetaʼMicmacMinangkabauManchuManipuriMohawkMossiWestern M" +
	"ariMundangMultiple LanguagesCreekMirandeseMarwariMentawaiMyeneErzyaMazan" +
	"deraniMin Nan ChineseNeapolitanNamaLow GermanNewariNiasNiueanAo NagaKwas" +
	"ioNgiemboonNogaiOld NorseNovialNʼKoNorthern SothoNuerClassical NewariNya" +
	"mweziNyankoleNyoroNzimaOsageOttoman TurkishPangasinanPahlaviPampangaPapi" +
	"amentoPalauanPicardPennsylvania GermanPlautdietschOld PersianPalatine Ge" +
	"rmanPhoenicianPiedmontesePonticPohnpeianPrussianOld ProvençalKʼicheʼChim" +
	"borazo Highland QuichuaRajasthaniRapanuiRarotonganRomagnolRiffianRomboRo" +
	"manyRotumanRusynRovianaAromanianRwaSandaweSakhaSamaritan AramaicSamburuS" +
	"asakSantaliSaurashtraNgambaySanguSicilianScotsSassarese SardinianSenecaS" +
	"enaSeriSelkupKoyraboro SenniOld IrishSamogitianTachelhitShanChadian Arab" +
	"icSidamoLower SilesianSelayarSouthern SamiLule SamiInari SamiSkolt SamiS" +
	"oninkeSogdienSranan TongoSererSahoSaterland FrisianSukumaSusuSumerianCom" +
	"orianCongo SwahiliClassical SyriacSyriacSilesianTuluTimneTesoTerenoTetum" +
	"TigreTivTokelauTsakhurKlingonTlingitTalyshTamashekNyasa TongaTok PisinTu" +
	"royoTarokoTsakonianTsimshianMuslim TatTumbukaTuvaluTasawaqTuvinianCentra" +
	"l Atlas TamazightUdmurtUgariticUmbunduRootVaiVenetianVepsWest FlemishMai" +
	"n-FranconianVoticVõroVunjoWalserWolayttaWarayWashoWarlpiriWu ChineseKalm" +
	"ykMingrelianSogaYaoYapeseYangbenYembaNheengatuCantoneseZapotecBlissymbol" +
	"sZeelandicZenagaStandard Moroccan TamazightZuniNo linguistic contentZaza" +
	"Modern Standard ArabicAustrian GermanSwiss High GermanAustralian English" +
	"Canadian EnglishBritish EnglishAmerican EnglishLatin American SpanishEur" +
	"opean SpanishMexican SpanishCanadian FrenchSwiss FrenchFlemishBrazilian " +
	"PortugueseEuropean PortugueseMoldavianSerbo-CroatianSimplified ChineseTr" +
	"aditional Chinese"

// Size: 1234 bytes, 605 elements
var enLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000d, 0x0014, 0x001d, 0x0021, 0x0028, 0x0031,
	0x0037, 0x003f, 0x0045, 0x004b, 0x0056, 0x005d, 0x0067, 0x0070,
	0x0077, 0x007e, 0x0085, 0x008c, 0x0092, 0x0099, 0x00a0, 0x00a7,
	0x00af, 0x00b7, 0x00bb, 0x00c0, 0x00cd, 0x00d4, 0x00d9, 0x00df,
	0x00e5, 0x00eb, 0x00f3, 0x00f6, 0x00fb, 0x0102, 0x010b, 0x0112,
	0x011a, 0x0120, 0x0127, 0x012c, 0x0133, 0x0139, 0x0140, 0x0146,
	0x0155, 0x015a, 0x0169, 0x0171, 0x0178, 0x0180, 0x0184, 0x0189,
	0x018f, 0x0194, 0x019d, 0x01a5, 0x01ac, 0x01b5, 0x01bd, 0x01c3,
	// Entry 40 - 7F
	0x01ce, 0x01d8, 0x01e3, 0x01e7, 0x01f1, 0x01f8, 0x01fb, 0x0204,
	0x020b, 0x0214, 0x021c, 0x0224, 0x022c, 0x0231, 0x0237, 0x023f,
	0x0245, 0x0250, 0x0255, 0x025c, 0x0262, 0x0268, 0x0270, 0x0277,
	0x027b, 0x0282, 0x0288, 0x028d, 0x029a, 0x029f, 0x02a9, 0x02b0,
	0x02b3, 0x02bd, 0x02c9, 0x02d0, 0x02d8, 0x02e3, 0x02e8, 0x02f2,
	0x02fb, 0x0304, 0x030b, 0x0310, 0x0317, 0x031e, 0x0323, 0x0330,
	0x0336, 0x033c, 0x0341, 0x0352, 0x0363, 0x0370, 0x0376, 0x037c,
	0x0383, 0x0389, 0x038e, 0x0393, 0x039a, 0x03a1, 0x03a5, 0x03ab,
	// Entry 80 - BF
	0x03b1, 0x03bb, 0x03c2, 0x03c9, 0x03ce, 0x03d6, 0x03dd, 0x03e8,
	0x03f0, 0x03f9, 0x03ff, 0x040c, 0x0411, 0x0418, 0x041e, 0x0427,
	0x042d, 0x0432, 0x0438, 0x0440, 0x0447, 0x044c, 0x045a, 0x0463,
	0x046a, 0x0471, 0x0476, 0x047c, 0x0481, 0x0485, 0x048d, 0x0494,
	0x049a, 0x04a0, 0x04a7, 0x04ad, 0x04b2, 0x04ba, 0x04c0, 0x04c9,
	0x04cd, 0x04d2, 0x04d7, 0x04e1, 0x04e9, 0x04f0, 0x04f5, 0x04fa,
	0x0501, 0x0507, 0x050d, 0x0514, 0x0518, 0x0520, 0x0525, 0x052c,
	0x0532, 0x0541, 0x0549, 0x054e, 0x0552, 0x055a, 0x0561, 0x0566,
	// Entry C0 - FF
	0x0573, 0x0581, 0x058c, 0x0592, 0x0599, 0x05a0, 0x05a6, 0x05ad,
	0x05bc, 0x05c2, 0x05d1, 0x05e0, 0x05e3, 0x05f9, 0x0601, 0x0607,
	0x060d, 0x061e, 0x0625, 0x062d, 0x0635, 0x063a, 0x063f, 0x0649,
	0x0650, 0x0654, 0x0659, 0x065f, 0x0663, 0x0668, 0x066e, 0x0676,
	0x067b, 0x067f, 0x0685, 0x0688, 0x068f, 0x069a, 0x06a3, 0x06a7,
	0x06ad, 0x06b1, 0x06b7, 0x06bd, 0x06c5, 0x06c9, 0x06cd, 0x06d4,
	0x06d9, 0x06de, 0x06e4, 0x06e9, 0x06f0, 0x06f5, 0x06fc, 0x0704,
	0x070c, 0x0710, 0x071e, 0x0725, 0x072e, 0x0736, 0x073e, 0x074d,
	// Entry 100 - 13F
	0x0753, 0x075b, 0x076a, 0x0773, 0x0779, 0x077f, 0x0784, 0x078c,
	0x0791, 0x0797, 0x079c, 0x07a1, 0x07a6, 0x07b3, 0x07c0, 0x07c5,
	0x07d1, 0x07db, 0x07e0, 0x07e6, 0x07ea, 0x07ee, 0x07f5, 0x0805,
	0x080b, 0x0812, 0x0820, 0x082d, 0x0833, 0x083f, 0x0843, 0x084b,
	0x085d, 0x0860, 0x086c, 0x0879, 0x0883, 0x088a, 0x089a, 0x08a9,
	0x08b1, 0x08b3, 0x08b9, 0x08c4, 0x08c8, 0x08cd, 0x08dd, 0x08e1,
	0x08eb, 0x08f1, 0x0903, 0x0912, 0x091e, 0x0923, 0x092c, 0x0932,
	0x0937, 0x0944, 0x0950, 0x0955, 0x095b, 0x0960, 0x0969, 0x096e,
	// Entry 140 - 17F
	0x097b, 0x0983, 0x098d, 0x0997, 0x099e, 0x09a3, 0x09b0, 0x09bd,
	0x09c1, 0x09c5, 0x09cb, 0x09d0, 0x09d6, 0x09dd, 0x09f4, 0x09fa,
	0x0a00, 0x0a07, 0x0a14, 0x0a20, 0x0a26, 0x0a31, 0x0a37, 0x0a3d,
	0x0a40, 0x0a45, 0x0a49, 0x0a52, 0x0a59, 0x0a5d, 0x0a64, 0x0a70,
	0x0a77, 0x0a7b, 0x0a83, 0x0a88, 0x0a91, 0x0a9d, 0x0aa3, 0x0aac,
	0x0ab0, 0x0ab8, 0x0ac0, 0x0acc, 0x0ad3, 0x0adb, 0x0ae1, 0x0af0,
	0x0af4, 0x0afd, 0x0b05, 0x0b0b, 0x0b13, 0x0b18, 0x0b21, 0x0b26,
	0x0b2d, 0x0b33, 0x0b38, 0x0b3e, 0x0b43, 0x0b4b, 0x0b5d, 0x0b65,
	// Entry 180 - 1BF
	0x0b6d, 0x0b73, 0x0b7a, 0x0b7f, 0x0b83, 0x0b8c, 0x0b96, 0x0b9d,
	0x0ba2, 0x0ba5, 0x0ba9, 0x0bae, 0x0bbe, 0x0bc1, 0x0bc9, 0x0bcd,
	0x0bd3, 0x0bdb, 0x0be2, 0x0bea, 0x0bef, 0x0bf3, 0x0bf9, 0x0bff,
	0x0c04, 0x0c08, 0x0c10, 0x0c1c, 0x0c2a, 0x0c30, 0x0c36, 0x0c41,
	0x0c47, 0x0c4f, 0x0c55, 0x0c5a, 0x0c66, 0x0c6d, 0x0c7f, 0x0c84,
	0x0c8d, 0x0c94, 0x0c9c, 0x0ca1, 0x0ca6, 0x0cb1, 0x0cc0, 0x0cca,
	0x0cce, 0x0cd8, 0x0cde, 0x0ce2, 0x0ce8, 0x0cef, 0x0cf5, 0x0cfe,
	0x0d03, 0x0d0c, 0x0d12, 0x0d17, 0x0d25, 0x0d29, 0x0d39, 0x0d41,
	// Entry 1C0 - 1FF
	0x0d49, 0x0d4e, 0x0d53, 0x0d58, 0x0d67, 0x0d71, 0x0d78, 0x0d80,
	0x0d8a, 0x0d91, 0x0d97, 0x0daa, 0x0db6, 0x0dc1, 0x0dd0, 0x0dda,
	0x0de5, 0x0deb, 0x0df4, 0x0dfc, 0x0e0a, 0x0e13, 0x0e2e, 0x0e38,
	0x0e3f, 0x0e49, 0x0e51, 0x0e58, 0x0e5d, 0x0e63, 0x0e6a, 0x0e6f,
	0x0e76, 0x0e7f, 0x0e82, 0x0e89, 0x0e8e, 0x0e9f, 0x0ea6, 0x0eab,
	0x0eb2, 0x0ebc, 0x0ec3, 0x0ec8, 0x0ed0, 0x0ed5, 0x0ee8, 0x0eee,
	0x0ef2, 0x0ef6, 0x0efc, 0x0f0b, 0x0f14, 0x0f1e, 0x0f27, 0x0f2b,
	0x0f39, 0x0f3f, 0x0f4d, 0x0f54, 0x0f61, 0x0f6a, 0x0f74, 0x0f7e,
	// Entry 200 - 23F
	0x0f85, 0x0f8c, 0x0f98, 0x0f9d, 0x0fa1, 0x0fb2, 0x0fb8, 0x0fbc,
	0x0fc4, 0x0fcc, 0x0fd9, 0x0fe9, 0x0fef, 0x0ff7, 0x0ffb, 0x1000,
	0x1004, 0x100a, 0x100f, 0x1014, 0x1017, 0x101e, 0x1025, 0x102c,
	0x1033, 0x1039, 0x1041, 0x104c, 0x1055, 0x105b, 0x1061, 0x106a,
	0x1073, 0x107d, 0x1084, 0x108a, 0x1091, 0x1099, 0x10b0, 0x10b6,
	0x10be, 0x10c5, 0x10c9, 0x10cc, 0x10d4, 0x10d8, 0x10e4, 0x10f3,
	0x10f8, 0x10fd, 0x1102, 0x1108, 0x1110, 0x1115, 0x111a, 0x1122,
	0x112c, 0x1132, 0x113c, 0x1140, 0x1143, 0x1149, 0x1150, 0x1155,
	// Entry 240 - 27F
	0x115e, 0x1167, 0x116e, 0x1179, 0x1182, 0x1188, 0x11a3, 0x11a7,
	0x11bc, 0x11c0, 0x11d6, 0x11e5, 0x11f6, 0x1208, 0x1218, 0x1227,
	0x1237, 0x124d, 0x125d, 0x126c, 0x127b, 0x1287, 0x128e, 0x12a2,
	0x12b5, 0x12be, 0x12cc, 0x12de, 0x12f1,
}

// Size: 4180 bytes
const esLangStr = "" +
	"afarabjasioavésticoafrikáansakanamáricoaragonésárabeasamésavaraimaraazer" +
	"baiyanobaskirbielorrusobúlgarobislamabambarabengalítibetanobretónbosnioc" +
	"atalánchechenochamorrocorsocreechecoeslavo eclesiásticochuvashgalésdanés" +
	"alemándivehidzongkhaewégriegoinglésesperantoespañolestonioeuskerapersafu" +
	"lafinésfiyianoferoésfrancésfrisón occidentalirlandésgaélico escocésgalle" +
	"goguaranígujaratimanéshausahebreohindihiri motucroatahaitianohúngaroarme" +
	"niohererointerlinguaindonesiointerlingueigboyi de Sichuáninupiaqidoislan" +
	"désitalianoinuktitutjaponésjavanésgeorgianokongokikuyukuanyamakazajogroe" +
	"nlandésjemercanaréscoreanokanuricachemirokurdokomicórnicokirguíslatínlux" +
	"emburguésgandalimburguéslingalalaosianolituanoluba-katangaletónmalgachem" +
	"arshalésmaorímacedoniomalayalammongolmaratímalayomaltésbirmanonauruanond" +
	"ebele septentrionalnepalíndonganeerlandésnynorsk noruegobokmal noruegond" +
	"ebele meridionalnavajonyanjaoccitanoojibwaoromooriyaoséticopanyabípalipo" +
	"lacopastúnportuguésquechuaretorrománicokiroundirumanorusokinyarwandasáns" +
	"critosardosindhisami septentrionalsangocingaléseslovacoeslovenosamoanosh" +
	"onasomalíalbanésserbiosiswatisesotho meridionalsundanéssuecoswahilitamil" +
	"telugutayikotailandéstigriñaturcomanosetchwanatonganoturcotsongatártarot" +
	"ahitianouigurucranianourduuzbekovendavietnamitavolapükvalónwólofxhosayíd" +
	"ishyorubazhuangchinozulúacehnésacoliadangmeadigeoafrihiliaghemainuacadio" +
	"aleutianoaltái meridionalinglés antiguoangikaarameomapuchearapahoarahuac" +
	"oasuasturianoavadhibaluchibalinésbasabamunghomalabejabembabenabafutbhojp" +
	"uribicolbinikomsiksikabrajbodoakooseburiatbuginésbulublinmedumbacaddocar" +
	"ibecayugaatsamcebuanochigachibchachagatáitrukésmaríjerga chinukchoctawch" +
	"ipewyancheroquicheyenekurdo soranicoptotártaro de Crimeacasubiodakotadar" +
	"gvataitadelawareslavedogribdinkazarmadogribajo sorbiodualaneerlandés med" +
	"ievaljola-fonyidiuladazagaembuefikegipcio antiguoekajukelamitainglés med" +
	"ievalewondofangfilipinofonfrancés medievalfrancés antiguofrisón septentr" +
	"ionalfrisón orientalfriulanogagagauzogayogbayageezgilbertésalemán de la " +
	"alta edad mediaalemán de la alta edad antiguagondigorontalogóticogrebogr" +
	"iego antiguoalemán suizogusiikutchinhaidahawaianohiligaynonhititahmongal" +
	"to sorbiohupaibanibibioilocanoingushlojbanngombamachamejudeo-persajudeo-" +
	"árabekarakalpakocabilakachinjjukambakawikabardianokanembutyapmakondecri" +
	"ollo caboverdianokorokhasikotanéskoyra chiinikakokalenjinkimbundukomi pe" +
	"rmiokonkaníkosraeanokpellekarachay-balkarcareliokurukhshambalabafiakölsc" +
	"hkumykkutenailadinolangilahndalambalezgianolakotamongoloziluba-lulualuis" +
	"eñolundaluolushailuyiamadurésmafamagahimaithilimacasarmandingomasáimabam" +
	"okshamandarmendemerucriollo mauricianoirlandés medievalmakhuwa-meettomet" +
	"a’micmacminangkabaumanchúmanipurimohawkmossimundanglenguas múltiplescree" +
	"kmirandésmarwarimyeneerzyanapolitanonamabajo alemánnewariniasniueanokwas" +
	"iongiemboonnogainórdico antiguon’kosotho septentrionalnuernewari clásico" +
	"nyamwezinyankolenyoronzimaosageturco otomanopangasinánpahlavipampangapap" +
	"iamentopalauanopersa antiguofeniciopohnpeianoprovenzal antiguoquichéraja" +
	"sthanirapanuirarotonganoromboromaníarrumanorwasandawesakhaarameo samarit" +
	"anosamburusasaksantalingambaysangusicilianoescocéssenecasenaselkupkoyrab" +
	"oro senniirlandés antiguotashelhitshanárabe chadianosidamosami meridiona" +
	"lsami lulesami inarisami skoltsoninkésogdianosranan tongoserersahosukuma" +
	"sususumeriocomorenseswahili del Congosiríaco clásicosiriacotemnetesotere" +
	"notetúntigrétivtokelauanoklingontlingittamashektonga del Nyasatok pisint" +
	"arokotsimshianotumbukatuvaluanotasawaqtuvinianotamazight del Marruecos C" +
	"entraludmurtugaríticoumbunduraízvaivóticovunjowalserwalamowaraywashokalm" +
	"yksogayaoyapésyangbenyembacantonészapotecosímbolos Blisszenagatamazight " +
	"estándar marroquízunisin contenido lingüísticozazakiárabe estándar moder" +
	"noalemán austríacoalto alemán suizoinglés australianoinglés canadiensein" +
	"glés británicoinglés estadounidenseespañol latinoamericanoespañol de Esp" +
	"añaespañol de Méxicofrancés canadiensefrancés suizoflamencoportugués de " +
	"Brasilportugués de Portugalmoldavoserbocroatachino simplificadochino tra" +
	"dicional"

// Size: 1234 bytes, 605 elements
var esLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000b, 0x0014, 0x001e, 0x0022, 0x002a, 0x0033,
	0x0039, 0x0040, 0x0044, 0x004a, 0x0055, 0x005b, 0x0065, 0x006d,
	0x0074, 0x007b, 0x0083, 0x008b, 0x0092, 0x0098, 0x00a0, 0x00a8,
	0x00b0, 0x00b5, 0x00b9, 0x00be, 0x00d2, 0x00d9, 0x00df, 0x00e5,
	0x00ec, 0x00f2, 0x00fa, 0x00fe, 0x0104, 0x010b, 0x0114, 0x011c,
	0x0123, 0x012a, 0x012f, 0x0133, 0x0139, 0x0140, 0x0147, 0x014f,
	0x0161, 0x016a, 0x017b, 0x0182, 0x018a, 0x0192, 0x0198, 0x019d,
	0x01a3, 0x01a8, 0x01b1, 0x01b7, 0x01bf, 0x01c7, 0x01ce, 0x01d4,
	// Entry 40 - 7F
	0x01df, 0x01e8, 0x01f3, 0x01f7, 0x0205, 0x020c, 0x020f, 0x0218,
	0x0220, 0x0229, 0x0231, 0x0239, 0x0242, 0x0247, 0x024d, 0x0255,
	0x025b, 0x0267, 0x026c, 0x0274, 0x027b, 0x0281, 0x028a, 0x028f,
	0x0293, 0x029b, 0x02a3, 0x02a9, 0x02b6, 0x02bb, 0x02c6, 0x02cd,
	0x02d5, 0x02dc, 0x02e8, 0x02ee, 0x02f6, 0x0300, 0x0306, 0x030f,
	0x0318, 0x031e, 0x0325, 0x032b, 0x0332, 0x0339, 0x0341, 0x0356,
	0x035d, 0x0363, 0x036e, 0x037d, 0x038b, 0x039d, 0x03a3, 0x03a9,
	0x03b1, 0x03b7, 0x03bc, 0x03c1, 0x03c9, 0x03d1, 0x03d5, 0x03db,
	// Entry 80 - BF
	0x03e2, 0x03ec, 0x03f3, 0x0401, 0x0409, 0x040f, 0x0413, 0x041e,
	0x0428, 0x042d, 0x0433, 0x0445, 0x044a, 0x0453, 0x045b, 0x0463,
	0x046a, 0x046f, 0x0476, 0x047e, 0x0484, 0x048b, 0x049d, 0x04a6,
	0x04ab, 0x04b2, 0x04b7, 0x04bd, 0x04c3, 0x04cd, 0x04d5, 0x04de,
	0x04e7, 0x04ee, 0x04f3, 0x04f9, 0x0501, 0x050a, 0x050f, 0x0518,
	0x051c, 0x0522, 0x0527, 0x0531, 0x0539, 0x053f, 0x0545, 0x054a,
	0x0551, 0x0557, 0x055d, 0x0562, 0x0567, 0x056f, 0x0574, 0x057b,
	0x0581, 0x0581, 0x0589, 0x058e, 0x0592, 0x0598, 0x0598, 0x05a1,
	// Entry C0 - FF
	0x05a1, 0x05b2, 0x05c1, 0x05c7, 0x05cd, 0x05d4, 0x05d4, 0x05db,
	0x05db, 0x05e3, 0x05e3, 0x05e3, 0x05e6, 0x05e6, 0x05ef, 0x05ef,
	0x05f5, 0x05f5, 0x05fc, 0x0604, 0x0604, 0x0608, 0x060d, 0x060d,
	0x0614, 0x0618, 0x061d, 0x061d, 0x0621, 0x0626, 0x0626, 0x062e,
	0x0633, 0x0637, 0x0637, 0x063a, 0x0641, 0x0641, 0x0641, 0x0645,
	0x0645, 0x0649, 0x064f, 0x0655, 0x065d, 0x0661, 0x0665, 0x066c,
	0x0671, 0x0677, 0x067d, 0x0682, 0x0689, 0x068e, 0x0695, 0x069e,
	0x06a5, 0x06aa, 0x06b6, 0x06bd, 0x06c6, 0x06ce, 0x06d5, 0x06e1,
	// Entry 100 - 13F
	0x06e6, 0x06e6, 0x06f8, 0x06ff, 0x0705, 0x070b, 0x0710, 0x0718,
	0x071d, 0x0723, 0x0728, 0x072d, 0x0732, 0x073d, 0x073d, 0x0742,
	0x0756, 0x0760, 0x0765, 0x076b, 0x076f, 0x0773, 0x0773, 0x0782,
	0x0788, 0x078f, 0x079f, 0x079f, 0x07a5, 0x07a5, 0x07a9, 0x07b1,
	0x07b1, 0x07b4, 0x07b4, 0x07c5, 0x07d5, 0x07d5, 0x07ea, 0x07fa,
	0x0802, 0x0804, 0x080b, 0x080b, 0x080f, 0x0814, 0x0814, 0x0818,
	0x0822, 0x0822, 0x083f, 0x085e, 0x085e, 0x0863, 0x086c, 0x0873,
	0x0878, 0x0886, 0x0893, 0x0893, 0x0893, 0x0898, 0x089f, 0x08a4,
	// Entry 140 - 17F
	0x08a4, 0x08ac, 0x08ac, 0x08b6, 0x08bc, 0x08c1, 0x08cc, 0x08cc,
	0x08d0, 0x08d4, 0x08da, 0x08e1, 0x08e7, 0x08e7, 0x08e7, 0x08ed,
	0x08f3, 0x08fa, 0x0905, 0x0911, 0x0911, 0x091c, 0x0922, 0x0928,
	0x092b, 0x0930, 0x0934, 0x093e, 0x0945, 0x0949, 0x0950, 0x0964,
	0x0964, 0x0968, 0x0968, 0x096d, 0x0975, 0x0981, 0x0981, 0x0981,
	0x0985, 0x098d, 0x0995, 0x09a0, 0x09a8, 0x09b1, 0x09b7, 0x09c6,
	0x09c6, 0x09c6, 0x09cd, 0x09d3, 0x09db, 0x09e0, 0x09e7, 0x09ec,
	0x09f3, 0x09f9, 0x09fe, 0x0a04, 0x0a09, 0x0a11, 0x0a11, 0x0a11,
	// Entry 180 - 1BF
	0x0a11, 0x0a17, 0x0a17, 0x0a1c, 0x0a20, 0x0a20, 0x0a2a, 0x0a32,
	0x0a37, 0x0a3a, 0x0a40, 0x0a45, 0x0a45, 0x0a45, 0x0a4d, 0x0a51,
	0x0a57, 0x0a5f, 0x0a66, 0x0a6e, 0x0a74, 0x0a78, 0x0a7e, 0x0a84,
	0x0a89, 0x0a8d, 0x0a9f, 0x0ab1, 0x0abf, 0x0ac6, 0x0acc, 0x0ad7,
	0x0ade, 0x0ae6, 0x0aec, 0x0af1, 0x0af1, 0x0af8, 0x0b0a, 0x0b0f,
	0x0b18, 0x0b1f, 0x0b1f, 0x0b24, 0x0b29, 0x0b29, 0x0b29, 0x0b33,
	0x0b37, 0x0b43, 0x0b49, 0x0b4d, 0x0b54, 0x0b54, 0x0b5a, 0x0b63,
	0x0b68, 0x0b78, 0x0b78, 0x0b7e, 0x0b91, 0x0b95, 0x0ba4, 0x0bac,
	// Entry 1C0 - 1FF
	0x0bb4, 0x0bb9, 0x0bbe, 0x0bc3, 0x0bd0, 0x0bdb, 0x0be2, 0x0bea,
	0x0bf4, 0x0bfc, 0x0bfc, 0x0bfc, 0x0bfc, 0x0c09, 0x0c09, 0x0c10,
	0x0c10, 0x0c10, 0x0c1a, 0x0c1a, 0x0c2b, 0x0c32, 0x0c32, 0x0c3c,
	0x0c43, 0x0c4e, 0x0c4e, 0x0c4e, 0x0c53, 0x0c5a, 0x0c5a, 0x0c5a,
	0x0c5a, 0x0c62, 0x0c65, 0x0c6c, 0x0c71, 0x0c82, 0x0c89, 0x0c8e,
	0x0c95, 0x0c95, 0x0c9c, 0x0ca1, 0x0caa, 0x0cb2, 0x0cb2, 0x0cb8,
	0x0cbc, 0x0cbc, 0x0cc2, 0x0cd1, 0x0ce2, 0x0ce2, 0x0ceb, 0x0cef,
	0x0cfe, 0x0d04, 0x0d04, 0x0d04, 0x0d13, 0x0d1c, 0x0d26, 0x0d30,
	// Entry 200 - 23F
	0x0d38, 0x0d40, 0x0d4c, 0x0d51, 0x0d55, 0x0d55, 0x0d5b, 0x0d5f,
	0x0d66, 0x0d6f, 0x0d80, 0x0d91, 0x0d98, 0x0d98, 0x0d98, 0x0d9d,
	0x0da1, 0x0da7, 0x0dad, 0x0db3, 0x0db6, 0x0dc0, 0x0dc0, 0x0dc7,
	0x0dce, 0x0dce, 0x0dd6, 0x0de5, 0x0dee, 0x0dee, 0x0df4, 0x0df4,
	0x0dfe, 0x0dfe, 0x0e05, 0x0e0e, 0x0e15, 0x0e1e, 0x0e3d, 0x0e43,
	0x0e4d, 0x0e54, 0x0e59, 0x0e5c, 0x0e5c, 0x0e5c, 0x0e5c, 0x0e5c,
	0x0e63, 0x0e63, 0x0e68, 0x0e6e, 0x0e74, 0x0e79, 0x0e7e, 0x0e7e,
	0x0e7e, 0x0e84, 0x0e84, 0x0e88, 0x0e8b, 0x0e91, 0x0e98, 0x0e9d,
	// Entry 240 - 27F
	0x0e9d, 0x0ea6, 0x0eae, 0x0ebd, 0x0ebd, 0x0ec3, 0x0ee0, 0x0ee4,
	0x0eff, 0x0f05, 0x0f1d, 0x0f2f, 0x0f41, 0x0f54, 0x0f66, 0x0f78,
	0x0f8e, 0x0fa6, 0x0fb9, 0x0fcc, 0x0fdf, 0x0fed, 0x0ff5, 0x1009,
	0x101f, 0x1026, 0x1031, 0x1043, 0x1054,
}

// Size: 3704 bytes
const etLangStr = "" +
	"afariabhaasiavestaafrikaaniakaniamhariaragoniaraabiaassamiavaariaimaraas" +
	"erbaidžaanibaškiirivalgevenebulgaariabislamabambarabengalitiibetibretoon" +
	"ibosniakatalaanitšetšeenitšamorrokorsikakriitšehhikirikuslaavitšuvašikõm" +
	"ritaanisaksamaldiividzongkhaevekreekaingliseesperantohispaaniaeestibaski" +
	"pärsiafulbesoomefidžifääriprantsuseläänefriisiiirigaeligaleegiguaraniigu" +
	"džaratimänksihausaheebreahindimotuhorvaadihaitiungariarmeeniahererointer" +
	"linguaindoneesiainterlingueibosichuani jiiinjupiakiidoislandiitaaliainuk" +
	"titutijaapanijaavagruusiakongokikujuambokasahhigröönikhmeerikannadakorea" +
	"kanurikašmiirikurdikomikornikirgiisiladinaletseburgigandalimburgilingala" +
	"laoleedulubalätimalagassimaršallimaoorimakedooniamalajalamimongolimarath" +
	"imalaimaltabirmanaurupõhjandebelenepalindongahollandinorra nynorsknorra " +
	"bokmållõunandebelenavahonjandžaprovansiodžibveioromooriaosseedipandžabip" +
	"aalipoolapuštuportugaliketšuaretoromaanirundirumeeniaveneruandasanskriti" +
	"sardiiniasindhipõhjasaamisangosingalislovakisloveenisamoašonasomaalialba" +
	"aniaserbiasvaasilõunasothosundarootsisuahiilitamilitelugutadžikitaitigri" +
	"njatürkmeenitsvanatongatürgitsongatataritahitiuiguuriukrainaurduusbekive" +
	"ndavietnamivolapükivalloonivolofikoosajidišijorubatšuangihiinasuuluatšeh" +
	"iakoliadangmeadõgeeafrihiliaghemiainuakadialeuudialtaivanaingliseangikaa" +
	"rameaaraukaaniarapahoaravakiasaastuuriaavadhibelutšibalibasabamunighomal" +
	"abedžabembabenabafutibhodžpuribikoliedoitaŋikomisiksikabradžibodoakooseb" +
	"urjaadibugibulubilinimedumbakadokariibicayugaatsamisebuchigatšibtšatšaga" +
	"taitšuugimaritšinuki žargoontšoktotšipevaitšerokiišaieenisorani kurdikop" +
	"tikrimmitatarikašuubisiuudargitaitadelavarisleividogribidinkazarmadogria" +
	"lamsorbidualakeskhollandijola-fonyidjuladazagaembuefikimuinasegiptuseeka" +
	"džukieelamikeskingliseevondofangifilipinofonikeskprantsusevanaprantsusep" +
	"õhjafriisiidafriisifriuuligaagagauusigajogbajaetioopiakiribatikeskülems" +
	"aksavanaülemsaksagondigorontalogootigrebovanakreekašveitsisaksagusiigvit" +
	"šinihaidahavaihiligainonihetihmongiülemsorbihupaibaniibibioilokoingušil" +
	"ojbaningombamachamejuudipärsiajuudiaraabiakarakalpakikabiilikatšinijjuka" +
	"mbakaavikabardi-tšerkessikanembutyapimakondekabuverdianukorokhasisakikoy" +
	"ra chiinikakokaljenjinmbundupermikomikonkanikosraekpellekaratšai-balkaar" +
	"ikarjalaoraonishambalabafiacolognianikumõkikutenailadiinolangilahndalamb" +
	"alesgilakotamongoloziluba-lulualuisenjolundaluolušeiluyiamaduramafamagal" +
	"imaithilimakassarimalinkemasaimabamokšamandarimendemeruMauritiuse kreool" +
	"keelkeskiirimakhuwa-meettometa’mikmakiminangkabaumandžumanipurimohoogimo" +
	"remundangimitu keeltmaskogimirandamarvarimyeneersanapolinamaalamsaksanev" +
	"ariniasiniuekwasiongiembooninogaivanapõhjalankoopedinuerivananevarinjamv" +
	"esinkolenjoronzimaoseidžiosmanitürgipangasinanipahlavipampangapapiamento" +
	"belauvanapärsiafoiniikiapoonpeivanaprovansik’iche’radžastanirapanuirarot" +
	"ongarombomustlaskeelaromuunirwasandavejakuudisamaaria arameasamburusasak" +
	"isantalingembaysangusitsiiliašotisenecasenasölkupikoyraboro sennivanaiir" +
	"itachelhitišaniTšaadi araabiasidamolõunasaamilule saamiinari saamikoltas" +
	"aamisoninkesogdisrananisererisahosukumasususumerikomooriKongo suahiilikl" +
	"assikaline süüriasüüriatemnetesoterenotetumitigreetivitokelauklingonitli" +
	"ngititamašekitšitongauusmelaneesiatarokotšimšitumbukatuvalutaswaqitõvaKe" +
	"sk-Maroko tamazightiudmurdiugaritiumbundurootvaivadjavunjowalserivolamov" +
	"araivašokalmõkisogajaojapiyangbeniyembakantonisapoteegiblissümbolidzenag" +
	"atamasikti (Maroko)sunjimittekeelelinezazaaraabia (tänapäevane)saksa (kõ" +
	"rgsaksa)inglise (Briti)inglise (USA)hispaania (Euroopa)flaamiportugali (" +
	"Euroopa)moldovaserbia-horvaadihiina (lihtsustatud)hiina (traditsioonilin" +
	"e)"

// Size: 1234 bytes, 605 elements
var etLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0005, 0x000c, 0x0012, 0x001b, 0x0020, 0x0026, 0x002d,
	0x0034, 0x003a, 0x0040, 0x0046, 0x0054, 0x005d, 0x0066, 0x006f,
	0x0076, 0x007d, 0x0084, 0x008b, 0x0093, 0x0099, 0x00a2, 0x00ad,
	0x00b6, 0x00bd, 0x00c1, 0x00c8, 0x00d4, 0x00dd, 0x00e3, 0x00e8,
	0x00ed, 0x00f5, 0x00fd, 0x0100, 0x0106, 0x010d, 0x0116, 0x011f,
	0x0124, 0x0129, 0x0130, 0x0135, 0x013a, 0x0140, 0x0147, 0x0150,
	0x015d, 0x0161, 0x0166, 0x016d, 0x0175, 0x017f, 0x0186, 0x018b,
	0x0192, 0x0197, 0x019b, 0x01a3, 0x01a8, 0x01ae, 0x01b6, 0x01bc,
	// Entry 40 - 7F
	0x01c7, 0x01d1, 0x01dc, 0x01df, 0x01eb, 0x01f4, 0x01f7, 0x01fe,
	0x0205, 0x020f, 0x0216, 0x021b, 0x0222, 0x0227, 0x022d, 0x0231,
	0x0238, 0x0240, 0x0247, 0x024e, 0x0253, 0x0259, 0x0262, 0x0267,
	0x026b, 0x0270, 0x0278, 0x027e, 0x0288, 0x028d, 0x0295, 0x029c,
	0x029f, 0x02a4, 0x02a8, 0x02ad, 0x02b6, 0x02bf, 0x02c5, 0x02cf,
	0x02d9, 0x02e0, 0x02e7, 0x02ec, 0x02f1, 0x02f6, 0x02fb, 0x0308,
	0x030e, 0x0314, 0x031c, 0x0329, 0x0336, 0x0343, 0x0349, 0x0351,
	0x0359, 0x0362, 0x0367, 0x036b, 0x0372, 0x037b, 0x0380, 0x0385,
	// Entry 80 - BF
	0x038b, 0x0394, 0x039b, 0x03a6, 0x03ab, 0x03b3, 0x03b7, 0x03bd,
	0x03c6, 0x03cf, 0x03d5, 0x03e0, 0x03e5, 0x03ec, 0x03f3, 0x03fb,
	0x0400, 0x0405, 0x040c, 0x0414, 0x041a, 0x0420, 0x042b, 0x0430,
	0x0436, 0x043e, 0x0444, 0x044a, 0x0452, 0x0455, 0x045d, 0x0467,
	0x046d, 0x0472, 0x0478, 0x047e, 0x0484, 0x048a, 0x0491, 0x0498,
	0x049c, 0x04a2, 0x04a7, 0x04af, 0x04b8, 0x04c0, 0x04c6, 0x04cb,
	0x04d2, 0x04d8, 0x04e0, 0x04e5, 0x04ea, 0x04f1, 0x04f6, 0x04fd,
	0x0504, 0x0504, 0x050c, 0x0512, 0x0516, 0x051b, 0x051b, 0x0522,
	// Entry C0 - FF
	0x0522, 0x0527, 0x0532, 0x0538, 0x053e, 0x0547, 0x0547, 0x054e,
	0x054e, 0x0555, 0x0555, 0x0555, 0x0558, 0x0558, 0x0560, 0x0560,
	0x0566, 0x0566, 0x056e, 0x0572, 0x0572, 0x0576, 0x057c, 0x057c,
	0x0583, 0x0589, 0x058e, 0x058e, 0x0592, 0x0598, 0x0598, 0x05a2,
	0x05a8, 0x05ab, 0x05ab, 0x05b5, 0x05bc, 0x05bc, 0x05bc, 0x05c3,
	0x05c3, 0x05c7, 0x05cd, 0x05d5, 0x05d9, 0x05dd, 0x05e3, 0x05ea,
	0x05ee, 0x05f5, 0x05fb, 0x0601, 0x0605, 0x060a, 0x0613, 0x061c,
	0x0623, 0x0627, 0x0638, 0x063f, 0x0648, 0x0651, 0x0659, 0x0665,
	// Entry 100 - 13F
	0x066a, 0x066a, 0x0676, 0x067e, 0x0682, 0x0687, 0x068c, 0x0694,
	0x069a, 0x06a1, 0x06a6, 0x06ab, 0x06b0, 0x06b9, 0x06b9, 0x06be,
	0x06ca, 0x06d4, 0x06d9, 0x06df, 0x06e3, 0x06e8, 0x06e8, 0x06f6,
	0x06ff, 0x0705, 0x0710, 0x0710, 0x0716, 0x0716, 0x071b, 0x0723,
	0x0723, 0x0727, 0x0727, 0x0734, 0x0741, 0x0741, 0x074d, 0x0756,
	0x075d, 0x0760, 0x0768, 0x0768, 0x076c, 0x0771, 0x0771, 0x0779,
	0x0781, 0x0781, 0x078f, 0x079d, 0x079d, 0x07a2, 0x07ab, 0x07b0,
	0x07b5, 0x07bf, 0x07cc, 0x07cc, 0x07cc, 0x07d1, 0x07da, 0x07df,
	// Entry 140 - 17F
	0x07df, 0x07e4, 0x07e4, 0x07ef, 0x07f3, 0x07f9, 0x0803, 0x0803,
	0x0807, 0x080c, 0x0812, 0x0817, 0x081e, 0x081e, 0x081e, 0x0825,
	0x082b, 0x0832, 0x083e, 0x084a, 0x084a, 0x0855, 0x085c, 0x0864,
	0x0867, 0x086c, 0x0871, 0x0883, 0x088a, 0x088f, 0x0896, 0x08a2,
	0x08a2, 0x08a6, 0x08a6, 0x08ab, 0x08af, 0x08bb, 0x08bb, 0x08bb,
	0x08bf, 0x08c8, 0x08ce, 0x08d7, 0x08de, 0x08e4, 0x08ea, 0x08fc,
	0x08fc, 0x08fc, 0x0903, 0x0909, 0x0911, 0x0916, 0x0920, 0x0927,
	0x092e, 0x0935, 0x093a, 0x0940, 0x0945, 0x094a, 0x094a, 0x094a,
	// Entry 180 - 1BF
	0x094a, 0x0950, 0x0950, 0x0955, 0x0959, 0x0959, 0x0963, 0x096b,
	0x0970, 0x0973, 0x0979, 0x097e, 0x097e, 0x097e, 0x0984, 0x0988,
	0x098e, 0x0996, 0x099f, 0x09a6, 0x09ab, 0x09af, 0x09b5, 0x09bc,
	0x09c1, 0x09c5, 0x09da, 0x09e2, 0x09f0, 0x09f7, 0x09fe, 0x0a09,
	0x0a10, 0x0a18, 0x0a1f, 0x0a23, 0x0a23, 0x0a2b, 0x0a35, 0x0a3c,
	0x0a43, 0x0a4a, 0x0a4a, 0x0a4f, 0x0a53, 0x0a53, 0x0a53, 0x0a59,
	0x0a5d, 0x0a66, 0x0a6c, 0x0a71, 0x0a75, 0x0a75, 0x0a7b, 0x0a85,
	0x0a8a, 0x0a96, 0x0a96, 0x0a9a, 0x0a9e, 0x0aa3, 0x0aad, 0x0ab5,
	// Entry 1C0 - 1FF
	0x0aba, 0x0abf, 0x0ac4, 0x0acc, 0x0ad8, 0x0ae3, 0x0aea, 0x0af2,
	0x0afc, 0x0b01, 0x0b01, 0x0b01, 0x0b01, 0x0b0c, 0x0b0c, 0x0b15,
	0x0b15, 0x0b15, 0x0b1c, 0x0b1c, 0x0b28, 0x0b33, 0x0b33, 0x0b3e,
	0x0b45, 0x0b4e, 0x0b4e, 0x0b4e, 0x0b53, 0x0b5e, 0x0b5e, 0x0b5e,
	0x0b5e, 0x0b66, 0x0b69, 0x0b70, 0x0b77, 0x0b86, 0x0b8d, 0x0b93,
	0x0b9a, 0x0b9a, 0x0ba1, 0x0ba6, 0x0baf, 0x0bb4, 0x0bb4, 0x0bba,
	0x0bbe, 0x0bbe, 0x0bc6, 0x0bd5, 0x0bdd, 0x0bdd, 0x0be7, 0x0bec,
	0x0bfb, 0x0c01, 0x0c01, 0x0c01, 0x0c0c, 0x0c16, 0x0c21, 0x0c2b,
	// Entry 200 - 23F
	0x0c32, 0x0c37, 0x0c3e, 0x0c44, 0x0c48, 0x0c48, 0x0c4e, 0x0c52,
	0x0c58, 0x0c5f, 0x0c6d, 0x0c82, 0x0c8a, 0x0c8a, 0x0c8a, 0x0c8f,
	0x0c93, 0x0c99, 0x0c9f, 0x0ca5, 0x0ca9, 0x0cb0, 0x0cb0, 0x0cb8,
	0x0cc0, 0x0cc0, 0x0cc9, 0x0cd2, 0x0cdf, 0x0cdf, 0x0ce5, 0x0ce5,
	0x0ced, 0x0ced, 0x0cf4, 0x0cfa, 0x0d01, 0x0d06, 0x0d1c, 0x0d23,
	0x0d2a, 0x0d31, 0x0d35, 0x0d38, 0x0d38, 0x0d38, 0x0d38, 0x0d38,
	0x0d3d, 0x0d3d, 0x0d42, 0x0d49, 0x0d4f, 0x0d54, 0x0d59, 0x0d59,
	0x0d59, 0x0d61, 0x0d61, 0x0d65, 0x0d68, 0x0d6c, 0x0d74, 0x0d79,
	// Entry 240 - 27F
	0x0d79, 0x0d80, 0x0d89, 0x0d96, 0x0d96, 0x0d9c, 0x0dae, 0x0db3,
	0x0dc1, 0x0dc5, 0x0ddc, 0x0ddc, 0x0dee, 0x0dee, 0x0dee, 0x0dfd,
	0x0e0a, 0x0e0a, 0x0e1d, 0x0e1d, 0x0e1d, 0x0e1d, 0x0e23, 0x0e23,
	0x0e36, 0x0e3d, 0x0e4c, 0x0e60, 0x0e78,
}

// Size: 7513 bytes
const faLangStr = "" +
	"آفاریآبخازیاوستاییآفریکانسآکانامهریآراگونیعربیآسامیآواریآیماراییترکی آذر" +
	"بایجانیباشغیریبلوروسیبلغاریبیسلامابامباراییبنگالیتبتیبرتانیاییبوسنیاییک" +
	"اتالانچچنیچاموروییکورسیکریاییچکیاسلاوی کلیساییچوواشیویلزیدانمارکیآلمانی" +
	"مالدیویجونخاییاوه\u200cاییونانیانگلیسیاسپرانتواسپانیاییاستونیاییباسکیفا" +
	"رسیفولاییفنلاندیفیجیاییفاروییفرانسویفریزی غربیایرلندیگیلی اسکاتلندیگالی" +
	"سیاییگوارانیگجراتیمانیهوسیاییعبریهندیموتویی هیریکرواتهائیتیاییمجاریارمن" +
	"یهریروییمیان\u200cزباناندونزیاییاکسیدنتالایگبویییی سیچواناینوپیکایدوایس" +
	"لندیایتالیاییاینوکتیتوتژاپنیجاوه\u200cایگرجیکنگوییکیکویوییکوانیاماقزاقی" +
	"گرینلندیخمریکاناده\u200cایکره\u200cایکانوریاییکشمیریکردیکومیاییکرنوالیق" +
	"رقیزیلاتینیلوگزامبورگیگانداییلیمبورگیلینگالالائوسیلیتوانیاییلوبایی‐کاتا" +
	"نگالتونیاییمالاگاسیاییمارشالیمائوریاییمقدونیمالایالامیمغولیمراتیمالاییم" +
	"التیبرمه\u200cاینائوروییانده\u200cبله\u200cای شمالینپالیاندونگاییهلندین" +
	"رس جدید نروژیبوکسمال نروژیانده\u200cبله\u200cای جنوبیناواهویینیانجاییاو" +
	"کیتاییاوجیبواییاوروموییاوریه\u200cایآسیپنجابیپالیلهستانیپشتوپرتغالیکچوا" +
	"ییرومانشروندیاییرومانیاییروسیکینیاروانداییسنسکریتساردینیاییسندیسامی شما" +
	"لیسانگوییسینهالیاسلواکیاسلووینیاییساموآییشوناییسومالیاییآلبانیاییصربیسو" +
	"ازیاییسوتویی جنوبیسونداییسوئدیسواحلیتامیلیتلوگوییتاجیکیتایلندیتیگرینیای" +
	"یترکمنیتسواناییتونگاییترکی استانبولیتسونگاییتاتاریتاهیتیاییاویغوریاوکرا" +
	"ینیاردوازبکیونداییویتنامیولاپوکوالونیولوفیخوسایییدییوروباییچوانگیچینیزو" +
	"لوییآچئیآچولیاییآدانگمه\u200cایآدیجیاییعربی تونسیآفریهیلیآگیمآینوییاکدی" +
	"آلاباماییآلئوتیآلتایی جنوبیانگلیسی باستانآنگیکاآرامیماپوچه\u200cایآراپا" +
	"هوییعربی الجزایریآراواکیعربی مراکشیعربی مصریآسوترکی آذربایجانی ایرانبلو" +
	"چیبالیاییباواریاییباساییبمونیبجاییبمباییبناییبوجپوریبیکولیبینیلری بختیا" +
	"ریبراجبراهوییبودوییبوریاتیبوگیاییبلینکادوییکاریبیسبوییچیگاچیبچاجغتاییچو" +
	"کیماریاییچوکتوییچیپه\u200cویه\u200cایچروکیاییشایانیکردی سورانیقبطیترکی " +
	"کریمهکاشوبیداکوتاییدارقینیتایتادلاواریدوگریبدینکاییزرمادوگریصُربی سفلید" +
	"وآلاییهلندی میانهدیولا فونیدایولاییامبوافیکیمصری کهناکاجوکعیلامیانگلیسی" +
	" میانهاواندوفانکیفیلیپینیفونیفرانسوی میانهفرانسوی باستانفریزی شمالیفریزی" +
	" شرقیفریولیاییگاییگاگاوزگایوییگبایاییدری زرتشتیگی\u200cئزیگیلبرتیگیلکیآل" +
	"مانی علیای میانهآلمانی علیای باستانگوندیگورونتالوگوتیگریبویییونانی کهنآ" +
	"لمانی سوئیسیگوسیگویچ اینهایداییهاوائیاییهندی فیجیاییهیلی\u200cگاینونیهی" +
	"تیهمونگصُربی علیاهوپاآیبنایلوکوییاینگوشیلوجباننگومباماچامه\u200cایفارسی" +
	" یهودیعربی یهودیقره\u200cقالپاقیقبایلیکاچینیجوکامباییکاویاییکاباردینیتیا" +
	"پیماکوندهکابووردیانوکوروخاسیاییختنیکوجراچینیکهوارزازاکیکالنجینکیمبوندوی" +
	"یکومی پرمیاککنکانیکپله\u200cایقره\u200cچایی‐بالکاریکوروخیشامبالابافیایی" +
	"کومیکیکوتنیلادینولانگیلاهندالامبالزگیلاکوتامونگوییلوزیاییلوبایی‐لولوالو" +
	"یسنولونداییلوئوییلوشه\u200cایلویاچینی ادبیمادوراییماگاهیاییمایدیلیماکاس" +
	"ارماندینگوییماساییمکشاییماندارمنده\u200cایمروییموریسینایرلندی میانهماکو" +
	"ا متومتاییمیکماکیمینانگ\u200cکابوییمانچوییمیته\u200cایموهاکیماسیاییماند" +
	"انگیچندین زبانکریکیمارواریارزیاییناپلیناماییآلمانی سفلینواریایینیاسینیو" +
	"ییکوازیونغایینرس باستاننکوسوتویی شمالینویرنواریایی کلاسیکنیام\u200cوزیا" +
	"یینیانکوله\u200cاینیورویینزیماییاوسیجیترکی عثمانیپانگاسینانیپهلویپامپان" +
	"گاییپاپیامنتوپالائوییآلمانی پنسیلوانیاییفارسی باستانفنیقیپانپییپروسیپرو" +
	"وانسی باستانکیچه\u200cراجستانیراپانوییراروتونگاییرومبوییرومانوییرواییسا" +
	"نداوه\u200cاییاقوتیآرامی سامریسامبوروساساکیسانتالیسانگوسیسیلیاسکاتلندیس" +
	"ناسلکوپیکویرابورا سنیایرلندی باستانتاچل\u200cهیتشانیعربی چادیسیداموییسا" +
	"می جنوبیلوله سامیایناری سامیاسکولت سامیسونینکه\u200cایسغدیتاکی\u200cتاک" +
	"یسریریسوکوماییسوسوییسومریکوموریسواحلی کنگوییسریانی کلاسیکسریانیتمنه" +
	"\u200cایتسوییترنوتتومیتیگره\u200cایتیویکلینگونتلین\u200cگیتیتاماشقیتونگا" +
	"یی نیاساتوک\u200cپیسینیتسیم\u200cشیانیتومبوکاییتووالوییتسواکیتوواییآماز" +
	"یغی اطلس مرکزیاودمورتیاوگاریتیامبوندوییریشهویاییوتیونجووالاموواراییواشو" +
	"ییقلموقیسوگایییائویییاپیکانتونیزاپوتکیزناگاآمازیغی معیار مراکشزونیاییبد" +
	"ون محتوای زبانیزازاییعربی رسمیآلمانی اتریشآلمانی علیای سوئیسانگلیسی است" +
	"رالیاانگلیسی کاناداانگلیسی بریتانیاانگلیسی امریکااسپانیایی امریکای لاتی" +
	"ناسپانیایی اروپااسپانیایی مکزیکفرانسوی کانادافرانسوی سوئیسفلمنگیپرتغالی" +
	" برزیلپرتغالی اروپامولداویاییصرب و کرواتیچینی ساده\u200cشدهچینی سنتی"

// Size: 1234 bytes, 605 elements
var faLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000a, 0x0016, 0x0024, 0x0034, 0x003c, 0x0046, 0x0054,
	0x005c, 0x0066, 0x0070, 0x0080, 0x009d, 0x00ab, 0x00b9, 0x00c5,
	0x00d3, 0x00e5, 0x00f1, 0x00f9, 0x010b, 0x011b, 0x0129, 0x0131,
	0x0141, 0x014b, 0x0157, 0x015d, 0x0178, 0x0184, 0x018e, 0x019e,
	0x01aa, 0x01b8, 0x01c6, 0x01d3, 0x01df, 0x01ed, 0x01fd, 0x020f,
	0x0221, 0x022b, 0x0235, 0x0241, 0x024f, 0x025d, 0x0269, 0x0277,
	0x028a, 0x0298, 0x02b3, 0x02c5, 0x02d3, 0x02df, 0x02e7, 0x02f5,
	0x02fd, 0x0305, 0x031a, 0x0324, 0x0336, 0x0340, 0x034a, 0x0358,
	// Entry 40 - 7F
	0x036b, 0x037f, 0x0391, 0x039f, 0x03b0, 0x03be, 0x03c6, 0x03d4,
	0x03e6, 0x03fa, 0x0404, 0x0413, 0x041b, 0x0427, 0x0437, 0x0447,
	0x0451, 0x0461, 0x0469, 0x047c, 0x0489, 0x049b, 0x04a7, 0x04af,
	0x04bd, 0x04cb, 0x04d7, 0x04e3, 0x04f9, 0x0507, 0x0517, 0x0525,
	0x0531, 0x0545, 0x0562, 0x0572, 0x0588, 0x0596, 0x05a8, 0x05b4,
	0x05c8, 0x05d2, 0x05dc, 0x05e8, 0x05f2, 0x0601, 0x0611, 0x0634,
	0x063e, 0x0650, 0x065a, 0x0674, 0x068d, 0x06b0, 0x06c0, 0x06d0,
	0x06e0, 0x06f2, 0x0702, 0x0713, 0x0719, 0x0725, 0x072d, 0x073b,
	// Entry 80 - BF
	0x0743, 0x0751, 0x075d, 0x0769, 0x0779, 0x078b, 0x0793, 0x07ad,
	0x07bb, 0x07cf, 0x07d7, 0x07ea, 0x07f8, 0x0806, 0x0814, 0x082a,
	0x0838, 0x0844, 0x0856, 0x0868, 0x0870, 0x0880, 0x0897, 0x08a5,
	0x08af, 0x08bb, 0x08c7, 0x08d5, 0x08e1, 0x08ef, 0x0903, 0x090f,
	0x091f, 0x092d, 0x0948, 0x0958, 0x0964, 0x0976, 0x0984, 0x0994,
	0x099c, 0x09a6, 0x09b2, 0x09c0, 0x09cc, 0x09d8, 0x09e2, 0x09ee,
	0x09f4, 0x0a04, 0x0a10, 0x0a18, 0x0a24, 0x0a2c, 0x0a3c, 0x0a51,
	0x0a61, 0x0a74, 0x0a84, 0x0a8c, 0x0a98, 0x0aa0, 0x0ab2, 0x0abe,
	// Entry C0 - FF
	0x0abe, 0x0ad5, 0x0af0, 0x0afc, 0x0b06, 0x0b19, 0x0b19, 0x0b2b,
	0x0b44, 0x0b52, 0x0b67, 0x0b78, 0x0b7e, 0x0b7e, 0x0b7e, 0x0b7e,
	0x0b7e, 0x0ba6, 0x0bb0, 0x0bbe, 0x0bd0, 0x0bdc, 0x0be6, 0x0be6,
	0x0be6, 0x0bf0, 0x0bfc, 0x0bfc, 0x0c06, 0x0c06, 0x0c06, 0x0c14,
	0x0c20, 0x0c28, 0x0c28, 0x0c28, 0x0c28, 0x0c28, 0x0c3d, 0x0c45,
	0x0c53, 0x0c5f, 0x0c5f, 0x0c6d, 0x0c7b, 0x0c7b, 0x0c83, 0x0c83,
	0x0c8f, 0x0c9b, 0x0c9b, 0x0c9b, 0x0ca5, 0x0cad, 0x0cb7, 0x0cc3,
	0x0ccb, 0x0cd9, 0x0cd9, 0x0ce7, 0x0cff, 0x0d0f, 0x0d1b, 0x0d30,
	// Entry 100 - 13F
	0x0d38, 0x0d38, 0x0d4b, 0x0d57, 0x0d67, 0x0d75, 0x0d7f, 0x0d8d,
	0x0d8d, 0x0d99, 0x0da7, 0x0daf, 0x0db9, 0x0dcc, 0x0dcc, 0x0dda,
	0x0def, 0x0e02, 0x0e12, 0x0e12, 0x0e1a, 0x0e24, 0x0e24, 0x0e33,
	0x0e3f, 0x0e4b, 0x0e64, 0x0e64, 0x0e70, 0x0e70, 0x0e7a, 0x0e8a,
	0x0e8a, 0x0e92, 0x0e92, 0x0eab, 0x0ec6, 0x0ec6, 0x0edb, 0x0eee,
	0x0f00, 0x0f08, 0x0f14, 0x0f14, 0x0f20, 0x0f2e, 0x0f41, 0x0f4e,
	0x0f5c, 0x0f66, 0x0f88, 0x0fac, 0x0fac, 0x0fb6, 0x0fc8, 0x0fd0,
	0x0fde, 0x0ff1, 0x100a, 0x100a, 0x100a, 0x1012, 0x1021, 0x102f,
	// Entry 140 - 17F
	0x102f, 0x1041, 0x1058, 0x1071, 0x1079, 0x1083, 0x1096, 0x1096,
	0x109e, 0x10a6, 0x10a6, 0x10b6, 0x10c4, 0x10c4, 0x10c4, 0x10d0,
	0x10dc, 0x10ef, 0x1104, 0x1117, 0x1117, 0x112e, 0x113a, 0x1146,
	0x114a, 0x1158, 0x1166, 0x1178, 0x1178, 0x1182, 0x1190, 0x11a6,
	0x11a6, 0x11ae, 0x11ae, 0x11bc, 0x11c4, 0x11d6, 0x11e0, 0x11ec,
	0x11ec, 0x11fa, 0x120e, 0x1223, 0x122f, 0x122f, 0x123e, 0x1260,
	0x1260, 0x1260, 0x1260, 0x126c, 0x127a, 0x1288, 0x1288, 0x1294,
	0x129e, 0x12aa, 0x12b4, 0x12c0, 0x12ca, 0x12d2, 0x12d2, 0x12d2,
	// Entry 180 - 1BF
	0x12d2, 0x12de, 0x12de, 0x12ec, 0x12fa, 0x12fa, 0x1313, 0x131f,
	0x132d, 0x1339, 0x1348, 0x1350, 0x1361, 0x1361, 0x1371, 0x1371,
	0x1383, 0x1391, 0x139f, 0x13b3, 0x13bf, 0x13bf, 0x13cb, 0x13d7,
	0x13e6, 0x13f0, 0x13fe, 0x1417, 0x1428, 0x1432, 0x1440, 0x145b,
	0x1469, 0x1478, 0x1484, 0x1492, 0x1492, 0x14a2, 0x14b5, 0x14bf,
	0x14bf, 0x14cd, 0x14cd, 0x14cd, 0x14db, 0x14db, 0x14db, 0x14e5,
	0x14f1, 0x1506, 0x1516, 0x1520, 0x152a, 0x152a, 0x1536, 0x1536,
	0x1540, 0x1553, 0x1553, 0x1559, 0x1570, 0x1578, 0x1595, 0x15ac,
	// Entry 1C0 - 1FF
	0x15c3, 0x15d1, 0x15df, 0x15eb, 0x1600, 0x1616, 0x1620, 0x1634,
	0x1646, 0x1656, 0x1656, 0x167b, 0x167b, 0x1692, 0x1692, 0x169c,
	0x169c, 0x169c, 0x16a8, 0x16b2, 0x16cf, 0x16da, 0x16da, 0x16ea,
	0x16fa, 0x1710, 0x1710, 0x1710, 0x171e, 0x172e, 0x172e, 0x172e,
	0x172e, 0x172e, 0x1738, 0x174d, 0x1759, 0x176e, 0x177c, 0x1788,
	0x1796, 0x1796, 0x1796, 0x17a0, 0x17ac, 0x17be, 0x17be, 0x17be,
	0x17c4, 0x17c4, 0x17d0, 0x17e9, 0x1804, 0x1804, 0x1815, 0x181d,
	0x182e, 0x183e, 0x183e, 0x183e, 0x1851, 0x1862, 0x1877, 0x188c,
	// Entry 200 - 23F
	0x18a1, 0x18a9, 0x18bc, 0x18c6, 0x18c6, 0x18c6, 0x18d6, 0x18e2,
	0x18ec, 0x18f8, 0x1911, 0x192a, 0x1936, 0x1936, 0x1936, 0x1945,
	0x194f, 0x1957, 0x1961, 0x1972, 0x197a, 0x197a, 0x197a, 0x1988,
	0x199b, 0x199b, 0x19a9, 0x19c2, 0x19d7, 0x19d7, 0x19d7, 0x19d7,
	0x19ec, 0x19ec, 0x19fe, 0x1a0e, 0x1a1a, 0x1a26, 0x1a48, 0x1a58,
	0x1a68, 0x1a7a, 0x1a82, 0x1a8c, 0x1a8c, 0x1a8c, 0x1a8c, 0x1a8c,
	0x1a92, 0x1a92, 0x1a9a, 0x1a9a, 0x1aa6, 0x1ab2, 0x1abe, 0x1abe,
	0x1abe, 0x1aca, 0x1aca, 0x1ad6, 0x1ae2, 0x1aea, 0x1aea, 0x1aea,
	// Entry 240 - 27F
	0x1aea, 0x1af8, 0x1b06, 0x1b06, 0x1b06, 0x1b10, 0x1b34, 0x1b42,
	0x1b62, 0x1b6e, 0x1b7f, 0x1b96, 0x1bb8, 0x1bd7, 0x1bf2, 0x1c11,
	0x1c2c, 0x1c58, 0x1c75, 0x1c92, 0x1cad, 0x1cc6, 0x1cd2, 0x1ceb,
	0x1d04, 0x1d18, 0x1d2e, 0x1d48, 0x1d59,
}

// Size: 4652 bytes
const fiLangStr = "" +
	"afarabhaasiavestaafrikaansakanamharaaragoniaarabiaassamiavaariaimaraazer" +
	"ibaškiirivalkovenäjäbulgariabislamabambarabengalitiibetbretonibosniakata" +
	"laanitšetšeenitšamorrokorsikacreetšekkikirkkoslaavitšuvassikymritanskasa" +
	"ksadivehidzongkhaewekreikkaenglantiesperantoespanjavirobaskifarsifulanis" +
	"uomifidžifääriranskalänsifriisiiirigaeligaliciaguaranigudžaratimanksihau" +
	"sahepreahindihiri-motukroatiahaitiunkariarmeniahererointerlinguaindonesi" +
	"ainterlingueigbosichuanin-yiinupiaqidoislantiitaliainuktitutjapanijaavag" +
	"eorgiakongokikujukuanjamakazakkikalaallisutkhmerkannadakoreakanurikašmir" +
	"ikurdikomikornikirgiisilatinaluxemburggandalimburglingalalaoliettuakatan" +
	"ganlubalatviamalagassimarshallmaorimakedoniamalajalammongolimarathimalai" +
	"jimaltaburmanaurupohjois-ndebelenepalindongahollantinorjan nynorsknorjan" +
	" bokmåletelä-ndebelenavajonjandžaoksitaaniodžibwaoromoorijaosseettipandž" +
	"abipaalipuolapaštuportugaliketšuaretoromaanirundiromaniavenäjäruandasans" +
	"kritsardisindhipohjoissaamesangosinhalaslovakkisloveenisamoašonasomalial" +
	"baniaserbiaswazieteläsothosundaruotsiswahilitamilitelugutadžikkithaitigr" +
	"injaturkmeenitswanatongaturkkitsongatataaritahitiuiguuriukrainaurduuzbek" +
	"kivendavietnamvolapükvalloniwolofxhosajiddišjorubazhuangkiinazuluatšehat" +
	"šoliadangmeadygetunisianarabiaafrihiliaghemainuakkadialabamaaleuttigega" +
	"ltaimuinaisenglantiangikavaltakunnanarameamapudungunaraonaarapahoalgeria" +
	"narabiaarawakmarokonarabiaegyptinarabiaasuamerikkalainen viittomakielias" +
	"turiakotavaawadhieteläazeribelutšibalibaijeribasaabamumbatak-tobaghomala" +
	"bedžabembabetawibenafutbadagabhodžpuribikolbinibanjarkomsiksikabišnupria" +
	"bahtiaribradžbrahuibodokooseburjaattibugibulubilinmedumbacaddokaribicayu" +
	"gaatsamcebuanokigatšibtšatšagataichuukmarichinook-jargonchoctawchipewyan" +
	"cherokeecheyennesoranikopticapiznonkrimintataarikašubidakotadargitaitade" +
	"lawareslevidogribdinkadjermadogrialasorbidusundualakeskihollantijola-fon" +
	"yidjuladazagaembuefikemiliamuinaisegyptiekajukelamikeskienglantialaskanj" +
	"upikewondoextremadurafangfilipinomeänkielifoncajunkeskiranskamuinaisrans" +
	"kaarpitaanipohjoisfriisiitäfriisifriuligagagauzigan-kiinagajogbajazoroas" +
	"trialaisdarige’ezkiribatigilakikeskiyläsaksamuinaisyläsaksagoankonkanigo" +
	"ndigorontalogoottigrebomuinaiskreikkasveitsinsaksawayuufrafragusiigwitši" +
	"nhaidahakka-kiinahavaijifidžinhindihiligainoheettihmongyläsorbixiang-kii" +
	"nahupaibanibibioilokoinguušiinkeroinenjamaikankreolienglantilojbanngomba" +
	"machamejuutalaispersiajuutalaisarabiajuuttikarakalpakkikabyylikatšinjjuk" +
	"ambakavikabardikanembutyapmakondekapverdenkreolikenyangnorsunluurannikon" +
	"korokaingangkhasikhotanikoyra chiinikhowarkirmanjkikakokalenjinkimbunduk" +
	"omipermjakkikonkanikosraekpellekaratšai-balkaarikriokinaray-akarjalakuru" +
	"khshambalabafiakölschkumykkikutenailadinolangolahndalambalezgilingua fra" +
	"nca novaliguuriliivilakotalombardimongolozilatgalliluluanlubaluiseñolund" +
	"aluolusailuhyaklassinen kiinalazimaduramafamagahimaithilimakassarmanding" +
	"omaasaimabamokšamandarmendemerumorisyenkeski-iirimakua-meettometa’micmac" +
	"minangkabaumantšumanipurimohawkmossivuorimarimundangmonia kieliäcreekmir" +
	"andeesimarwarimentawaimyeneersämazandaranimin nan -kiinanapolinamaalasak" +
	"sanewariniasniueao nagakwasiongiemboonnogaimuinaisnorjanovialn’kopohjois" +
	"sothonuerklassinen newarinyamwezinyankolenyoronzimaosageosmanipangasinan" +
	"pahlavipampangapapiamentupalaupicardipennsylvaniansaksaplautdietschmuina" +
	"ispersiapfaltsifoinikiapiemontepontoksenkreikkapohnpeimuinaispreussimuin" +
	"aisprovensaalikʼicheʼchimborazonylänköketšuaradžastanirapanuirarotongaro" +
	"magnolitarifitromboromanirotumaruteenirovianaaromaniarwasandawejakuuttis" +
	"amarianarameasamburusasaksantalisauraštringambaysangusisiliaskottisassar" +
	"insardisenecasenaseriselkuppikoyraboro sennimuinaisiirisamogiittitašelhi" +
	"tshantšadinarabiasidamosleesiansaksaselayareteläsaameluulajansaameinarin" +
	"saamekoltansaamesoninkesogdisrananserersahosaterlandinfriisisukumasususu" +
	"merikomorikingwanamuinaissyyriasyyriasleesiatulutemnetesoterenotetumtigr" +
	"etivtokelautsahuriklingontlingittališitamašekmalawintongatok-pisinturojo" +
	"tarokotsakoniatsimšitatitumbukatuvalutasawaqtuvakeskiatlaksentamazightud" +
	"murttiugaritmbundujuurivaivenetsiavepsälänsiflaamimaininfrankkivatjavõro" +
	"vunjowalserwolaittawaraywashowu-kiinakalmukkimingrelisogajaojapiyangbeny" +
	"embañeengatúkantoninkiinazapoteekkiblisskieliseelantizenagavakioitu tama" +
	"zightzuniei kielellistä sisältöäzazayleisarabiaitävallansaksasveitsinylä" +
	"saksaaustralianenglantikanadanenglantibritannianenglantiamerikanenglanti" +
	"amerikanespanjaespanjanespanjameksikonespanjakanadanranskasveitsinranska" +
	"flaamibrasilianportugaliportugalinportugalimoldovaserbokroaattiyksinkert" +
	"aistettu kiinaperinteinen kiina"

// Size: 1234 bytes, 605 elements
var fiLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000b, 0x0011, 0x001a, 0x001e, 0x0024, 0x002c,
	0x0032, 0x0038, 0x003e, 0x0044, 0x0049, 0x0052, 0x005f, 0x0067,
	0x006e, 0x0075, 0x007c, 0x0082, 0x0089, 0x008f, 0x0098, 0x00a3,
	0x00ac, 0x00b3, 0x00b7, 0x00be, 0x00ca, 0x00d3, 0x00d8, 0x00de,
	0x00e3, 0x00e9, 0x00f1, 0x00f4, 0x00fb, 0x0103, 0x010c, 0x0113,
	0x0117, 0x011c, 0x0121, 0x0127, 0x012c, 0x0132, 0x0139, 0x013f,
	0x014b, 0x014f, 0x0154, 0x015b, 0x0162, 0x016c, 0x0172, 0x0177,
	0x017d, 0x0182, 0x018b, 0x0192, 0x0197, 0x019d, 0x01a4, 0x01aa,
	// Entry 40 - 7F
	0x01b5, 0x01be, 0x01c9, 0x01cd, 0x01d9, 0x01e0, 0x01e3, 0x01ea,
	0x01f0, 0x01f9, 0x01ff, 0x0204, 0x020b, 0x0210, 0x0216, 0x021e,
	0x0225, 0x0230, 0x0235, 0x023c, 0x0241, 0x0247, 0x024f, 0x0254,
	0x0258, 0x025d, 0x0265, 0x026b, 0x0274, 0x0279, 0x0280, 0x0287,
	0x028a, 0x0291, 0x029d, 0x02a3, 0x02ac, 0x02b4, 0x02b9, 0x02c2,
	0x02cb, 0x02d2, 0x02d9, 0x02e0, 0x02e5, 0x02ea, 0x02ef, 0x02fe,
	0x0304, 0x030a, 0x0312, 0x0320, 0x032e, 0x033c, 0x0342, 0x034a,
	0x0353, 0x035b, 0x0360, 0x0365, 0x036d, 0x0376, 0x037b, 0x0380,
	// Entry 80 - BF
	0x0386, 0x038f, 0x0396, 0x03a1, 0x03a6, 0x03ad, 0x03b5, 0x03bb,
	0x03c3, 0x03c8, 0x03ce, 0x03da, 0x03df, 0x03e6, 0x03ee, 0x03f6,
	0x03fb, 0x0400, 0x0406, 0x040d, 0x0413, 0x0418, 0x0423, 0x0428,
	0x042e, 0x0435, 0x043b, 0x0441, 0x044a, 0x044e, 0x0456, 0x045f,
	0x0465, 0x046a, 0x0470, 0x0476, 0x047d, 0x0483, 0x048a, 0x0491,
	0x0495, 0x049c, 0x04a1, 0x04a8, 0x04b0, 0x04b7, 0x04bc, 0x04c1,
	0x04c8, 0x04ce, 0x04d4, 0x04d9, 0x04dd, 0x04e3, 0x04ea, 0x04f1,
	0x04f6, 0x0504, 0x050c, 0x0511, 0x0515, 0x051b, 0x0522, 0x0529,
	// Entry C0 - FF
	0x052c, 0x0531, 0x0540, 0x0546, 0x0557, 0x0561, 0x0567, 0x056e,
	0x057c, 0x0582, 0x058f, 0x059c, 0x059f, 0x05bb, 0x05c2, 0x05c8,
	0x05ce, 0x05d9, 0x05e1, 0x05e5, 0x05ec, 0x05f1, 0x05f6, 0x0600,
	0x0607, 0x060d, 0x0612, 0x0618, 0x061c, 0x061f, 0x0625, 0x062f,
	0x0634, 0x0638, 0x063e, 0x0641, 0x0648, 0x0652, 0x065a, 0x0660,
	0x0666, 0x066a, 0x066f, 0x0678, 0x067c, 0x0680, 0x0685, 0x068c,
	0x0691, 0x0697, 0x069d, 0x06a2, 0x06a9, 0x06ad, 0x06b6, 0x06bf,
	0x06c4, 0x06c8, 0x06d6, 0x06dd, 0x06e6, 0x06ee, 0x06f6, 0x06fc,
	// Entry 100 - 13F
	0x0701, 0x0709, 0x0716, 0x071d, 0x0723, 0x0728, 0x072d, 0x0735,
	0x073a, 0x0740, 0x0745, 0x074b, 0x0750, 0x0758, 0x075d, 0x0762,
	0x076f, 0x0779, 0x077e, 0x0784, 0x0788, 0x078c, 0x0792, 0x079f,
	0x07a5, 0x07aa, 0x07b7, 0x07c3, 0x07c9, 0x07d4, 0x07d8, 0x07e0,
	0x07ea, 0x07ed, 0x07f2, 0x07fd, 0x080a, 0x0813, 0x0820, 0x082a,
	0x0830, 0x0832, 0x0839, 0x0842, 0x0846, 0x084b, 0x085d, 0x0864,
	0x086c, 0x0872, 0x0880, 0x0890, 0x089b, 0x08a0, 0x08a9, 0x08af,
	0x08b4, 0x08c2, 0x08cf, 0x08d4, 0x08da, 0x08df, 0x08e7, 0x08ec,
	// Entry 140 - 17F
	0x08f7, 0x08fe, 0x090a, 0x0913, 0x0919, 0x091e, 0x0927, 0x0932,
	0x0936, 0x093a, 0x0940, 0x0945, 0x094d, 0x0957, 0x096d, 0x0973,
	0x0979, 0x0980, 0x098f, 0x099e, 0x09a4, 0x09b0, 0x09b7, 0x09be,
	0x09c1, 0x09c6, 0x09ca, 0x09d1, 0x09d8, 0x09dc, 0x09e3, 0x09f2,
	0x09f9, 0x0a0e, 0x0a16, 0x0a1b, 0x0a22, 0x0a2e, 0x0a34, 0x0a3d,
	0x0a41, 0x0a49, 0x0a51, 0x0a5e, 0x0a65, 0x0a6b, 0x0a71, 0x0a83,
	0x0a87, 0x0a90, 0x0a97, 0x0a9d, 0x0aa5, 0x0aaa, 0x0ab1, 0x0ab8,
	0x0abf, 0x0ac5, 0x0aca, 0x0ad0, 0x0ad5, 0x0ada, 0x0aec, 0x0af3,
	// Entry 180 - 1BF
	0x0af8, 0x0afe, 0x0b06, 0x0b0b, 0x0b0f, 0x0b17, 0x0b21, 0x0b29,
	0x0b2e, 0x0b31, 0x0b36, 0x0b3b, 0x0b4a, 0x0b4e, 0x0b54, 0x0b58,
	0x0b5e, 0x0b66, 0x0b6e, 0x0b76, 0x0b7c, 0x0b80, 0x0b86, 0x0b8c,
	0x0b91, 0x0b95, 0x0b9d, 0x0ba7, 0x0bb3, 0x0bba, 0x0bc0, 0x0bcb,
	0x0bd2, 0x0bda, 0x0be0, 0x0be5, 0x0bee, 0x0bf5, 0x0c02, 0x0c07,
	0x0c11, 0x0c18, 0x0c20, 0x0c25, 0x0c2a, 0x0c35, 0x0c43, 0x0c49,
	0x0c4d, 0x0c55, 0x0c5b, 0x0c5f, 0x0c63, 0x0c6a, 0x0c70, 0x0c79,
	0x0c7e, 0x0c8a, 0x0c90, 0x0c96, 0x0ca2, 0x0ca6, 0x0cb6, 0x0cbe,
	// Entry 1C0 - 1FF
	0x0cc6, 0x0ccb, 0x0cd0, 0x0cd5, 0x0cdb, 0x0ce5, 0x0cec, 0x0cf4,
	0x0cfe, 0x0d03, 0x0d0a, 0x0d1c, 0x0d28, 0x0d35, 0x0d3c, 0x0d44,
	0x0d4c, 0x0d5c, 0x0d63, 0x0d71, 0x0d83, 0x0d8c, 0x0da6, 0x0db1,
	0x0db8, 0x0dc1, 0x0dca, 0x0dd1, 0x0dd6, 0x0ddc, 0x0de2, 0x0de9,
	0x0df0, 0x0df8, 0x0dfb, 0x0e02, 0x0e0a, 0x0e18, 0x0e1f, 0x0e24,
	0x0e2b, 0x0e35, 0x0e3c, 0x0e41, 0x0e48, 0x0e4e, 0x0e5b, 0x0e61,
	0x0e65, 0x0e69, 0x0e71, 0x0e80, 0x0e8b, 0x0e95, 0x0e9e, 0x0ea2,
	0x0eaf, 0x0eb5, 0x0ec2, 0x0ec9, 0x0ed4, 0x0ee1, 0x0eec, 0x0ef7,
	// Entry 200 - 23F
	0x0efe, 0x0f03, 0x0f09, 0x0f0e, 0x0f12, 0x0f23, 0x0f29, 0x0f2d,
	0x0f33, 0x0f39, 0x0f41, 0x0f4e, 0x0f54, 0x0f5b, 0x0f5f, 0x0f64,
	0x0f68, 0x0f6e, 0x0f73, 0x0f78, 0x0f7b, 0x0f82, 0x0f89, 0x0f90,
	0x0f97, 0x0f9e, 0x0fa6, 0x0fb2, 0x0fbb, 0x0fc1, 0x0fc7, 0x0fcf,
	0x0fd6, 0x0fda, 0x0fe1, 0x0fe7, 0x0fee, 0x0ff2, 0x1008, 0x1010,
	0x1016, 0x101c, 0x1021, 0x1024, 0x102c, 0x1032, 0x103e, 0x104b,
	0x1050, 0x1055, 0x105a, 0x1060, 0x1068, 0x106d, 0x1072, 0x1072,
	0x107a, 0x1082, 0x108a, 0x108e, 0x1091, 0x1095, 0x109c, 0x10a1,
	// Entry 240 - 27F
	0x10ab, 0x10b8, 0x10c2, 0x10cc, 0x10d4, 0x10da, 0x10ec, 0x10f0,
	0x110b, 0x110f, 0x111a, 0x1129, 0x113a, 0x114c, 0x115b, 0x116d,
	0x117d, 0x118c, 0x119b, 0x11aa, 0x11b7, 0x11c5, 0x11cb, 0x11dd,
	0x11f0, 0x11f7, 0x1204, 0x121b, 0x122c,
}

// Size: 2002 bytes
const filLangStr = "" +
	"AbkhazianAfrikaansAkanAmharicArabeAssameseAymaraAzerbaijaniBashkirBelaru" +
	"sianBulgarianBambaraBengaliTibetanBretonBosnianCatalanCorsicanCzechWelsh" +
	"DanishGermanDivehiDzongkhaEweGreekInglesEsperantoSpanishEstonianBasquePe" +
	"rsianFinnishFijianFaroeseFrenchWestern FrisianIrishScots GaelicGalicianG" +
	"uaraniGujaratiManxHausaHebrewHindiCroatianHaitianHungarianArmenianInterl" +
	"inguaIndonesianInterlingueIgboSichuan YiIcelandicItalianInuktitutJapanes" +
	"eJavaneseGeorgianKongoKikuyuKazakhKalaallisutKhmerKannadaKoreanKashmiriK" +
	"urdishCornishKirghizLatinLuxembourgishGandaLingalaLaoLithuanianLuba-Kata" +
	"ngaLatvianMalagasyMaoriMacedonianMalayalamMongolianMarathiMalayMalteseBu" +
	"rmeseNorth NdebeleNepaliDutchNorwegian NynorskNorwegian BokmalNyanjaOcci" +
	"tanOromoOriyaOsseticPunjabiPolishPashtoPortugesQuechuaRomanshRundiRomani" +
	"anRussianKinyarwandaSanskritSindhiNorthern SamiSangoSinhalaSlovakSloveni" +
	"anSamoanShonaSomaliAlbanianSerbianSwatiSouthern SothoSundaneseSwedishSwa" +
	"hiliTamilTeluguTajikThaiTigrinyaTurkmenTswanaTonganTurkishTsongaTatarTah" +
	"itianUyghurUkranianUrduUzbekVendaVietnameseWolofXhosaYiddishYorubaChines" +
	"eZuluAcoliAghemMapucheAsuBembaBenaBodoChigaCherokeeSorani KurdishTaitaZa" +
	"rmaLower SorbianDualaJola-FonyiEmbuEfikFilipinoGaGagauzSwiss GermanGusii" +
	"HawaiianUpper SorbianNgombaMachameKabyleKambaMakondeKabuverdianuKoyra Ch" +
	"iiniKalenjinKomi-PermyakKonkaniShambalaBafiaLangiLakotaLoziLuba-LuluaLuo" +
	"LuyiaMasaiMeruMorisyenMakhuwa-MeettoMeta’MohawkMundangNamaKwasioN’KoNort" +
	"hern SothoNuerNyankoleKʼicheʼRomboRwaSamburuSanguSenaKoyraboro SenniTach" +
	"elhitSouthern SamiLule SamiInari SamiSkolt SamiComorianSwahili (Congo)Te" +
	"soTetumKlingonTok PisinTumbukaTasawaqTamazight ng Gitnang AtlasHindi Kil" +
	"alang WikaVaiVunjoSogaCantoneseStandard Moroccan TamazightWalang nilalam" +
	"an na ukol sa wikaModernong Karaniwang ArabeIngles ng AustralyaIngles sa" +
	" CanadaIngles (UK)Ingles (US)Latin American SpanishEuropean SpanishMexic" +
	"an SpanishCanadian FrenchSwiss FrenchFlemishBrazilian PortugueseEuropean" +
	" PortugueseMoldavianSerbo-CroatianSimplified Chinese"

// Size: 1232 bytes, 604 elements
var filLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0000, 0x0009, 0x0009, 0x0012, 0x0016, 0x001d, 0x001d,
	0x0022, 0x002a, 0x002a, 0x0030, 0x003b, 0x0042, 0x004c, 0x0055,
	0x0055, 0x005c, 0x0063, 0x006a, 0x0070, 0x0077, 0x007e, 0x007e,
	0x007e, 0x0086, 0x0086, 0x008b, 0x008b, 0x008b, 0x0090, 0x0096,
	0x009c, 0x00a2, 0x00aa, 0x00ad, 0x00b2, 0x00b8, 0x00c1, 0x00c8,
	0x00d0, 0x00d6, 0x00dd, 0x00dd, 0x00e4, 0x00ea, 0x00f1, 0x00f7,
	0x0106, 0x010b, 0x0117, 0x011f, 0x0126, 0x012e, 0x0132, 0x0137,
	0x013d, 0x0142, 0x0142, 0x014a, 0x0151, 0x015a, 0x0162, 0x0162,
	// Entry 40 - 7F
	0x016d, 0x0177, 0x0182, 0x0186, 0x0190, 0x0190, 0x0190, 0x0199,
	0x01a0, 0x01a9, 0x01b1, 0x01b9, 0x01c1, 0x01c6, 0x01cc, 0x01cc,
	0x01d2, 0x01dd, 0x01e2, 0x01e9, 0x01ef, 0x01ef, 0x01f7, 0x01fe,
	0x01fe, 0x0205, 0x020c, 0x0211, 0x021e, 0x0223, 0x0223, 0x022a,
	0x022d, 0x0237, 0x0243, 0x024a, 0x0252, 0x0252, 0x0257, 0x0261,
	0x026a, 0x0273, 0x027a, 0x027f, 0x0286, 0x028d, 0x028d, 0x029a,
	0x02a0, 0x02a0, 0x02a5, 0x02b6, 0x02c6, 0x02c6, 0x02c6, 0x02cc,
	0x02d3, 0x02d3, 0x02d8, 0x02dd, 0x02e4, 0x02eb, 0x02eb, 0x02f1,
	// Entry 80 - BF
	0x02f7, 0x02ff, 0x0306, 0x030d, 0x0312, 0x031a, 0x0321, 0x032c,
	0x0334, 0x0334, 0x033a, 0x0347, 0x034c, 0x0353, 0x0359, 0x0362,
	0x0368, 0x036d, 0x0373, 0x037b, 0x0382, 0x0387, 0x0395, 0x039e,
	0x03a5, 0x03ac, 0x03b1, 0x03b7, 0x03bc, 0x03c0, 0x03c8, 0x03cf,
	0x03d5, 0x03db, 0x03e2, 0x03e8, 0x03ed, 0x03f5, 0x03fb, 0x0403,
	0x0407, 0x040c, 0x0411, 0x041b, 0x041b, 0x041b, 0x0420, 0x0425,
	0x042c, 0x0432, 0x0432, 0x0439, 0x043d, 0x043d, 0x0442, 0x0442,
	0x0442, 0x0442, 0x0442, 0x0447, 0x0447, 0x0447, 0x0447, 0x0447,
	// Entry C0 - FF
	0x0447, 0x0447, 0x0447, 0x0447, 0x0447, 0x044e, 0x044e, 0x044e,
	0x044e, 0x044e, 0x044e, 0x044e, 0x0451, 0x0451, 0x0451, 0x0451,
	0x0451, 0x0451, 0x0451, 0x0451, 0x0451, 0x0451, 0x0451, 0x0451,
	0x0451, 0x0451, 0x0456, 0x0456, 0x045a, 0x045a, 0x045a, 0x045a,
	0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a,
	0x045a, 0x045e, 0x045e, 0x045e, 0x045e, 0x045e, 0x045e, 0x045e,
	0x045e, 0x045e, 0x045e, 0x045e, 0x045e, 0x0463, 0x0463, 0x0463,
	0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x046b, 0x046b, 0x0479,
	// Entry 100 - 13F
	0x0479, 0x0479, 0x0479, 0x0479, 0x0479, 0x0479, 0x047e, 0x047e,
	0x047e, 0x047e, 0x047e, 0x0483, 0x0483, 0x0490, 0x0490, 0x0495,
	0x0495, 0x049f, 0x049f, 0x049f, 0x04a3, 0x04a7, 0x04a7, 0x04a7,
	0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04a7, 0x04af,
	0x04af, 0x04af, 0x04af, 0x04af, 0x04af, 0x04af, 0x04af, 0x04af,
	0x04af, 0x04b1, 0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04b7,
	0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04b7,
	0x04b7, 0x04b7, 0x04c3, 0x04c3, 0x04c3, 0x04c8, 0x04c8, 0x04c8,
	// Entry 140 - 17F
	0x04c8, 0x04d0, 0x04d0, 0x04d0, 0x04d0, 0x04d0, 0x04dd, 0x04dd,
	0x04dd, 0x04dd, 0x04dd, 0x04dd, 0x04dd, 0x04dd, 0x04dd, 0x04dd,
	0x04e3, 0x04ea, 0x04ea, 0x04ea, 0x04ea, 0x04ea, 0x04f0, 0x04f0,
	0x04f0, 0x04f5, 0x04f5, 0x04f5, 0x04f5, 0x04f5, 0x04fc, 0x0508,
	0x0508, 0x0508, 0x0508, 0x0508, 0x0508, 0x0514, 0x0514, 0x0514,
	0x0514, 0x051c, 0x051c, 0x0528, 0x052f, 0x052f, 0x052f, 0x052f,
	0x052f, 0x052f, 0x052f, 0x052f, 0x0537, 0x053c, 0x053c, 0x053c,
	0x053c, 0x053c, 0x0541, 0x0541, 0x0541, 0x0541, 0x0541, 0x0541,
	// Entry 180 - 1BF
	0x0541, 0x0547, 0x0547, 0x0547, 0x054b, 0x054b, 0x0555, 0x0555,
	0x0555, 0x0558, 0x0558, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d,
	0x055d, 0x055d, 0x055d, 0x055d, 0x0562, 0x0562, 0x0562, 0x0562,
	0x0562, 0x0566, 0x056e, 0x056e, 0x057c, 0x0583, 0x0583, 0x0583,
	0x0583, 0x0583, 0x0589, 0x0589, 0x0589, 0x0590, 0x0590, 0x0590,
	0x0590, 0x0590, 0x0590, 0x0590, 0x0590, 0x0590, 0x0590, 0x0590,
	0x0594, 0x0594, 0x0594, 0x0594, 0x0594, 0x0594, 0x059a, 0x059a,
	0x059a, 0x059a, 0x059a, 0x05a0, 0x05ae, 0x05b2, 0x05b2, 0x05b2,
	// Entry 1C0 - 1FF
	0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba,
	0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba,
	0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05ba, 0x05c3, 0x05c3, 0x05c3,
	0x05c3, 0x05c3, 0x05c3, 0x05c3, 0x05c8, 0x05c8, 0x05c8, 0x05c8,
	0x05c8, 0x05c8, 0x05cb, 0x05cb, 0x05cb, 0x05cb, 0x05d2, 0x05d2,
	0x05d2, 0x05d2, 0x05d2, 0x05d7, 0x05d7, 0x05d7, 0x05d7, 0x05d7,
	0x05db, 0x05db, 0x05db, 0x05ea, 0x05ea, 0x05ea, 0x05f3, 0x05f3,
	0x05f3, 0x05f3, 0x05f3, 0x05f3, 0x0600, 0x0609, 0x0613, 0x061d,
	// Entry 200 - 23F
	0x061d, 0x061d, 0x061d, 0x061d, 0x061d, 0x061d, 0x061d, 0x061d,
	0x061d, 0x0625, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634,
	0x0638, 0x0638, 0x063d, 0x063d, 0x063d, 0x063d, 0x063d, 0x0644,
	0x0644, 0x0644, 0x0644, 0x0644, 0x064d, 0x064d, 0x064d, 0x064d,
	0x064d, 0x064d, 0x0654, 0x0654, 0x065b, 0x065b, 0x0675, 0x0675,
	0x0675, 0x0675, 0x0688, 0x068b, 0x068b, 0x068b, 0x068b, 0x068b,
	0x068b, 0x068b, 0x0690, 0x0690, 0x0690, 0x0690, 0x0690, 0x0690,
	0x0690, 0x0690, 0x0690, 0x0694, 0x0694, 0x0694, 0x0694, 0x0694,
	// Entry 240 - 27F
	0x0694, 0x069d, 0x069d, 0x069d, 0x069d, 0x069d, 0x06b8, 0x06b8,
	0x06d8, 0x06d8, 0x06f2, 0x06f2, 0x06f2, 0x0705, 0x0715, 0x0720,
	0x072b, 0x0741, 0x0751, 0x0760, 0x076f, 0x077b, 0x0782, 0x0796,
	0x07a9, 0x07b2, 0x07c0, 0x07d2,
}

// Size: 4124 bytes
const frLangStr = "" +
	"afarabkhazeavestiqueafrikaansakanamhariquearagonaisarabeassamaisavarayma" +
	"raazéribachkirbiélorussebulgarebichelamarbambarabengalitibétainbretonbos" +
	"niaquecatalantchétchènechamorrocorsecreetchèqueslavon d’églisetchouvache" +
	"galloisdanoisallemandmaldiviendzongkhaéwégrecanglaisespérantoespagnolest" +
	"onienbasquepersanpeulfinnoisfidjienféroïenfrançaisfrison occidentalirlan" +
	"daisgaélique écossaisgalicienguaranigujaratimanxhaoussahébreuhindihiri m" +
	"otucroatehaïtienhongroisarménienhérérointerlinguaindonésieninterlingueig" +
	"boyi du Sichuaninupiaqidoislandaisitalieninuktitutjaponaisjavanaisgéorgi" +
	"enkongokikuyukuanyamakazakhgroenlandaiskhmerkannadacoréenkanourikashmiri" +
	"kurdekomicorniquekirghizelatinluxembourgeoisgandalimbourgeoislingalalaol" +
	"ituanienluba-katangalettonmalgachemarshallmaorimacédonienmalayalammongol" +
	"marathemalaismaltaisbirmannauruanndébélé du Nordnépalaisndonganéerlandai" +
	"snorvégien nynorsknorvégien bokmålndébélé du Sudnavahonyanjaoccitanojibw" +
	"aoromooriyaossètependjabipalipolonaispachtoportugaisquechuaromancheround" +
	"iroumainrusserwandasanskritsardesindhisami du Nordsanghocinghalaisslovaq" +
	"ueslovènesamoanshonasomalialbanaisserbeswatisesothosoundanaissuédoisswah" +
	"ilitamoultélougoutadjikthaïtigrignaturkmènetswanatonguienturctsongatatar" +
	"tahitienouïghourukrainienourdououzbekvendavietnamienvolapukwallonwolofxh" +
	"osayiddishyorubazhuangchinoiszoulouacehacoliadangmeadyghéenafrihiliaghem" +
	"aïnouakkadienaléoutealtaï du Sudancien anglaisangikaaraméenaraukanarapah" +
	"oarawakassouasturienawadhibaloutchibalinaisbassabamounghomalabedjabembab" +
	"énabafutbhojpuribikolbinikomsiksikabrajbodoakoosebouriatebugibouloublin" +
	"medumbacaddocaribecayugaatsamcebuanokigachibchatchaghataïchuukmarijargon" +
	" chinookchoctawchipewyancherokeecheyennesoranicopteturc de Criméekachoub" +
	"edakotadargwataitadelawareslaveydogribdinkazarmadogribas-sorabedoualamoy" +
	"en néerlandaisdiola-fognydiouladazagaembouefikégyptien ancienekajukélami" +
	"temoyen anglaiséwondofangfilipinofonmoyen françaisancien françaisfranco-" +
	"provençalfrison du Nordfrison orientalfrioulangagagaouzegayogbayaguèzegi" +
	"lbertaismoyen haut-allemandancien haut allemandgondigorontalogotiquegreb" +
	"ogrec anciensuisse allemandgusiigwichʼinhaidahawaïenhiligaynonhittitehmo" +
	"nghaut-sorabehupaibanibibioilokanoingouchelojbanngombamachamejudéo-persa" +
	"njudéo-arabekarakalpakkabylekachinjjukambakawikabardinkanemboutyapmakond" +
	"ecapverdienkorokhasikhotanaiskoyra chiinikakokalenjinkiMboundoukomi-perm" +
	"iakkonkanikusaienkpellékaratchaï balkarcarélienkurukhchambalabafiafranci" +
	"que ripuairekoumykkutenailadinolangilahndalambalezghienlakotamongolozilu" +
	"ba-lulualuisenolundaluolushaioluluyiamaduraismafamagahimaithilimakassarm" +
	"andinguemasaimabamoksamandarmendémeroucréole mauricienmoyen irlandaismak" +
	"huwa-meettométa’micmacminangkabaumandchoumanipurimohawkmorémundangmultil" +
	"inguecreekmirandaismarwarîmyènèerzyanapolitainnamabas-allemandnewarinias" +
	"niuékwasiongiemboonnogaïvieux norroisn’kosotho du Nordnuernewarî classiq" +
	"uenyamwezinyankolényoronzemaosageturc ottomanpangasinanpahlavipampanganp" +
	"apiamentopalaupersan ancienphénicienpohnpeiprovençal ancienk’iche’rajast" +
	"hanirapanuirarotongienrombotziganevalaquerwasandaweiakoutearaméen samari" +
	"tainsamburusasaksantalngambaysangusicilienécossaissenecasenaselkoupekoyr" +
	"aboro senniancien irlandaischleuhshanarabe tchadiensidamosami du Sudsami" +
	" de Lulesami d’Inarisami skoltsoninkésogdiensranan tongosérèresahosukuma" +
	"soussousumériencomorienswahili du Congosyriaque classiquesyriaquetemnete" +
	"soterenotetumtigrétivtokelauklingontlingittamacheqtonga nyasatok pisinta" +
	"rokotsimshiantumbukatuvalutasawaqtouvatamazightoudmourteougaritiqueumbun" +
	"duracinevaïvotevunjowalserwalamowaraywashokalmouksogayaoyapoisyangbenyem" +
	"bacantonaiszapotèquesymboles Blisszenagaamazighe standard marocainzunisa" +
	"ns contenu linguistiquezazakiarabe standard moderneallemand autrichienal" +
	"lemand suisseanglais australienanglais canadienanglais britanniqueanglai" +
	"s américainespagnol latino-américainespagnol européenespagnol mexicainfr" +
	"ançais canadienfrançais suisseflamandportugais brésilienportugais europé" +
	"enmoldaveserbo-croatechinois simplifiéchinois traditionnel"

// Size: 1234 bytes, 605 elements
var frLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000b, 0x0014, 0x001d, 0x0021, 0x002a, 0x0033,
	0x0038, 0x0040, 0x0044, 0x004a, 0x0050, 0x0057, 0x0062, 0x0069,
	0x0073, 0x007a, 0x0081, 0x008a, 0x0090, 0x0099, 0x00a0, 0x00ac,
	0x00b4, 0x00b9, 0x00bd, 0x00c5, 0x00d7, 0x00e1, 0x00e8, 0x00ee,
	0x00f6, 0x00ff, 0x0107, 0x010c, 0x0110, 0x0117, 0x0121, 0x0129,
	0x0131, 0x0137, 0x013d, 0x0141, 0x0148, 0x014f, 0x0158, 0x0161,
	0x0172, 0x017b, 0x018e, 0x0196, 0x019d, 0x01a5, 0x01a9, 0x01b0,
	0x01b7, 0x01bc, 0x01c5, 0x01cb, 0x01d3, 0x01db, 0x01e4, 0x01ec,
	// Entry 40 - 7F
	0x01f7, 0x0202, 0x020d, 0x0211, 0x021e, 0x0225, 0x0228, 0x0231,
	0x0238, 0x0241, 0x0249, 0x0251, 0x025a, 0x025f, 0x0265, 0x026d,
	0x0273, 0x027f, 0x0284, 0x028b, 0x0292, 0x0299, 0x02a1, 0x02a6,
	0x02aa, 0x02b2, 0x02ba, 0x02bf, 0x02cd, 0x02d2, 0x02de, 0x02e5,
	0x02e8, 0x02f1, 0x02fd, 0x0303, 0x030b, 0x0313, 0x0318, 0x0323,
	0x032c, 0x0332, 0x0339, 0x033f, 0x0346, 0x034c, 0x0353, 0x0365,
	0x036e, 0x0374, 0x0380, 0x0392, 0x03a4, 0x03b5, 0x03bb, 0x03c1,
	0x03c8, 0x03ce, 0x03d3, 0x03d8, 0x03df, 0x03e7, 0x03eb, 0x03f3,
	// Entry 80 - BF
	0x03f9, 0x0402, 0x0409, 0x0411, 0x0417, 0x041e, 0x0423, 0x0429,
	0x0431, 0x0436, 0x043c, 0x0448, 0x044e, 0x0458, 0x0460, 0x0468,
	0x046e, 0x0473, 0x0479, 0x0481, 0x0486, 0x048b, 0x0492, 0x049c,
	0x04a4, 0x04ab, 0x04b1, 0x04ba, 0x04c0, 0x04c5, 0x04cd, 0x04d6,
	0x04dc, 0x04e4, 0x04e8, 0x04ee, 0x04f3, 0x04fb, 0x0504, 0x050d,
	0x0513, 0x0519, 0x051e, 0x0528, 0x052f, 0x0535, 0x053a, 0x053f,
	0x0546, 0x054c, 0x0552, 0x0559, 0x055f, 0x0563, 0x0568, 0x056f,
	0x0578, 0x0578, 0x0580, 0x0585, 0x058b, 0x0593, 0x0593, 0x059b,
	// Entry C0 - FF
	0x059b, 0x05a8, 0x05b6, 0x05bc, 0x05c4, 0x05cb, 0x05cb, 0x05d2,
	0x05d2, 0x05d8, 0x05d8, 0x05d8, 0x05dd, 0x05dd, 0x05e5, 0x05e5,
	0x05eb, 0x05eb, 0x05f4, 0x05fc, 0x05fc, 0x0601, 0x0607, 0x0607,
	0x060e, 0x0613, 0x0618, 0x0618, 0x061d, 0x0622, 0x0622, 0x062a,
	0x062f, 0x0633, 0x0633, 0x0636, 0x063d, 0x063d, 0x063d, 0x0641,
	0x0641, 0x0645, 0x064b, 0x0653, 0x0657, 0x065d, 0x0661, 0x0668,
	0x066d, 0x0673, 0x0679, 0x067e, 0x0685, 0x0689, 0x0690, 0x069b,
	0x06a0, 0x06a4, 0x06b2, 0x06b9, 0x06c2, 0x06ca, 0x06d2, 0x06d8,
	// Entry 100 - 13F
	0x06dd, 0x06dd, 0x06ec, 0x06f4, 0x06fa, 0x0700, 0x0705, 0x070d,
	0x0713, 0x0719, 0x071e, 0x0723, 0x0728, 0x0732, 0x0732, 0x0738,
	0x074a, 0x0755, 0x075b, 0x0761, 0x0766, 0x076a, 0x076a, 0x077a,
	0x0780, 0x0788, 0x0795, 0x0795, 0x079c, 0x079c, 0x07a0, 0x07a8,
	0x07a8, 0x07ab, 0x07ab, 0x07ba, 0x07ca, 0x07db, 0x07e9, 0x07f8,
	0x0800, 0x0802, 0x080a, 0x080a, 0x080e, 0x0813, 0x0813, 0x0819,
	0x0823, 0x0823, 0x0836, 0x084a, 0x084a, 0x084f, 0x0858, 0x085f,
	0x0864, 0x086f, 0x087e, 0x087e, 0x087e, 0x0883, 0x088c, 0x0891,
	// Entry 140 - 17F
	0x0891, 0x0899, 0x0899, 0x08a3, 0x08aa, 0x08af, 0x08ba, 0x08ba,
	0x08be, 0x08c2, 0x08c8, 0x08cf, 0x08d7, 0x08d7, 0x08d7, 0x08dd,
	0x08e3, 0x08ea, 0x08f7, 0x0903, 0x0903, 0x090d, 0x0913, 0x0919,
	0x091c, 0x0921, 0x0925, 0x092d, 0x0935, 0x0939, 0x0940, 0x094a,
	0x094a, 0x094e, 0x094e, 0x0953, 0x095c, 0x0968, 0x0968, 0x0968,
	0x096c, 0x0974, 0x097e, 0x098a, 0x0991, 0x0998, 0x099f, 0x09b0,
	0x09b0, 0x09b0, 0x09b9, 0x09bf, 0x09c7, 0x09cc, 0x09de, 0x09e4,
	0x09eb, 0x09f1, 0x09f6, 0x09fc, 0x0a01, 0x0a09, 0x0a09, 0x0a09,
	// Entry 180 - 1BF
	0x0a09, 0x0a0f, 0x0a0f, 0x0a14, 0x0a18, 0x0a18, 0x0a22, 0x0a29,
	0x0a2e, 0x0a31, 0x0a37, 0x0a3f, 0x0a3f, 0x0a3f, 0x0a47, 0x0a4b,
	0x0a51, 0x0a59, 0x0a61, 0x0a6a, 0x0a6f, 0x0a73, 0x0a78, 0x0a7e,
	0x0a84, 0x0a89, 0x0a9a, 0x0aa9, 0x0ab7, 0x0abf, 0x0ac5, 0x0ad0,
	0x0ad8, 0x0ae0, 0x0ae6, 0x0aeb, 0x0aeb, 0x0af2, 0x0afd, 0x0b02,
	0x0b0b, 0x0b13, 0x0b13, 0x0b1a, 0x0b1f, 0x0b1f, 0x0b1f, 0x0b29,
	0x0b2d, 0x0b39, 0x0b3f, 0x0b43, 0x0b48, 0x0b48, 0x0b4e, 0x0b57,
	0x0b5d, 0x0b6a, 0x0b6a, 0x0b70, 0x0b7d, 0x0b81, 0x0b92, 0x0b9a,
	// Entry 1C0 - 1FF
	0x0ba3, 0x0ba8, 0x0bad, 0x0bb2, 0x0bbe, 0x0bc8, 0x0bcf, 0x0bd8,
	0x0be2, 0x0be7, 0x0be7, 0x0be7, 0x0be7, 0x0bf4, 0x0bf4, 0x0bfe,
	0x0bfe, 0x0bfe, 0x0c05, 0x0c05, 0x0c16, 0x0c21, 0x0c21, 0x0c2b,
	0x0c32, 0x0c3d, 0x0c3d, 0x0c3d, 0x0c42, 0x0c49, 0x0c49, 0x0c49,
	0x0c49, 0x0c50, 0x0c53, 0x0c5a, 0x0c61, 0x0c74, 0x0c7b, 0x0c80,
	0x0c86, 0x0c86, 0x0c8d, 0x0c92, 0x0c9a, 0x0ca3, 0x0ca3, 0x0ca9,
	0x0cad, 0x0cad, 0x0cb5, 0x0cc4, 0x0cd4, 0x0cd4, 0x0cda, 0x0cde,
	0x0cec, 0x0cf2, 0x0cf2, 0x0cf2, 0x0cfd, 0x0d09, 0x0d17, 0x0d21,
	// Entry 200 - 23F
	0x0d29, 0x0d30, 0x0d3c, 0x0d44, 0x0d48, 0x0d48, 0x0d4e, 0x0d55,
	0x0d5e, 0x0d66, 0x0d76, 0x0d88, 0x0d90, 0x0d90, 0x0d90, 0x0d95,
	0x0d99, 0x0d9f, 0x0da4, 0x0daa, 0x0dad, 0x0db4, 0x0db4, 0x0dbb,
	0x0dc2, 0x0dc2, 0x0dca, 0x0dd5, 0x0dde, 0x0dde, 0x0de4, 0x0de4,
	0x0ded, 0x0ded, 0x0df4, 0x0dfa, 0x0e01, 0x0e06, 0x0e0f, 0x0e18,
	0x0e23, 0x0e2a, 0x0e30, 0x0e34, 0x0e34, 0x0e34, 0x0e34, 0x0e34,
	0x0e38, 0x0e38, 0x0e3d, 0x0e43, 0x0e49, 0x0e4e, 0x0e53, 0x0e53,
	0x0e53, 0x0e5a, 0x0e5a, 0x0e5e, 0x0e61, 0x0e67, 0x0e6e, 0x0e73,
	// Entry 240 - 27F
	0x0e73, 0x0e7c, 0x0e86, 0x0e94, 0x0e94, 0x0e9a, 0x0eb4, 0x0eb8,
	0x0ed1, 0x0ed7, 0x0eed, 0x0f00, 0x0f0f, 0x0f21, 0x0f31, 0x0f44,
	0x0f56, 0x0f70, 0x0f82, 0x0f93, 0x0fa5, 0x0fb5, 0x0fbc, 0x0fd0,
	0x0fe3, 0x0fea, 0x0ff6, 0x1008, 0x101c,
}

// Size: 3 bytes
const frCALangStr = "luo"

// Size: 812 bytes, 394 elements
var frCALangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	// Entry 40 - 7F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	// Entry 80 - BF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	// Entry C0 - FF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	// Entry 100 - 13F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	// Entry 140 - 17F
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	// Entry 180 - 1BF
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0003,
}

// Size: 11217 bytes
const guLangStr = "" +
	"અફારઅબખાજિયનઅવેસ્તનઆફ્રિકન્સઅકાનએમ્હારિકઅર્ગોનીઝઅરબીઆસામીઅવેરિકઆયમારાઅઝર" +
	"બૈજાનીબશ્કીરબેલારુશિયનબલ્ગેરિયનબિસ્લામાબામ્બારાબંગાળીતિબેટીયનબ્રેટોનબો" +
	"સ્નિયનકતલાનચેચનકેમોરોકોર્સિકનક્રીચેકચર્ચ સ્લાવિકચૂવાશવેલ્શડેનિશજર્મનદિ" +
	"વેહીડ્ઝોંગ્ખાઈવગ્રીકઅંગ્રેજીએસ્પેરાન્ટોસ્પેનિશએસ્ટોનિયનબાસ્કફારસીફુલાહ" +
	"ફિનિશફિજીયનફોરિસ્તફ્રેન્ચપશ્ચિમી ફ્રિશિયનઆઇરિશસ્કોટ્સ ગેલિકગેલિશિયનગુઆ" +
	"રાનીગુજરાતીમાંક્સહૌસાહીબ્રુહિન્દીહિરી મોટૂક્રોએશિયનહૈતીયનહંગેરિયનઆર્મે" +
	"નિયનહેરેરોઇંટરલિંગુઆઇન્ડોનેશિયનઇંટરલિંગઇગ્બોસિચુઆન યીઇનુપિયાકઇડૌઆઇસલેન" +
	"્ડિકઇટાલિયનઇનુકિટૂટજાપાનીઝજાવાનીસજ્યોર્જિઅનકોંગોકિકુયૂક્વાન્યામાકઝાખકલ" +
	"ાલ્લિસુતખ્મેરકન્નડકોરિયનકનુરીકાશ્મીરીકુર્દિશકોમીકોર્નિશકિર્ગીઝલેટિનલક્" +
	"ઝેમબર્ગિશગાંડાલિંબૂર્ગિશલિંગાલાલાઓથિયનલિથુનિયનલ્યૂબા કટાંગાલાતવિયનમલાગ" +
	"સીમાર્શલીઝમાઓરીમેસેડોનિયનમલયાલમમોંગોલિયનમરાઠીમલયમાલ્ટિઝબર્મીઝનાઉરૂઉતર " +
	"દેબેલનેપાળીડોન્ગાડચનૉર્વેજીયન નાયનૉર્સ્કનોર્વેજીયન બોકમાલદક્ષિણ દેબેલન" +
	"ાવાજોન્યાન્જાઓક્સિટનઓઝિંબ્વાઓરોમોઉડિયાઓસ્સેટિકપંજાબીપાલીપોલીશપશ્તોપોર્" +
	"ટુગીઝક્વેચુઆરોમાન્શરૂન્દીરોમાનિયનરશિયનકિન્યારવાન્ડાસંસ્કૃતસાર્દિનિયનસિ" +
	"ંધીઉત્તરીય સામીસાંગોસિંહાલીસ્લોવૅકસ્લોવેનિયનસામોનશોનાસોમાલીઅલ્બેનિયનસર" +
	"્બિયનસ્વાતીસદર્ન સોથોસંડેનીઝસ્વીડિશસ્વાહિલીતમિલતેલુગુતાજીકથાઈટાઇગ્રિનિ" +
	"યાતુર્કમેનત્સ્વાનાટોંગાનટર્કીશસોંગાતતારતાહિતિયનઉઇગુરયુક્રેનિયનઉર્દૂઉઝ્" +
	"બેકવેન્દાવિયેતનામીસવોલાપુકવાલૂનવોલોફખોસાયિદ્દિશયોરૂબાઝુઆગચાઇનીઝઝુલુઅચી" +
	"નીએકોલીઅદાંગ્મીઅદિઘેઅફ્રિહિલીઅઘેમઐનુઅક્કાદીયાનઅલેઉતદક્ષિણ અલ્તાઇજુની અ" +
	"ંગ્રેજીઅંગીકાઅર્માઇકએરોકૈનિયનઅરાપાહોઆલ્જેરિયન અરબીઅરાવકમોરોક્કન અરબીઈજ" +
	"િપ્શિયન અરબીઅસુઅસ્તુરિયનઅવધીદક્ષિણ ઝરબૈજાનીબલૂચીબાલિનીસબસાબેજાબેમ્બાબે" +
	"નાભોજપુરીબિકોલબિનીસિક્સિકાબિષ્નુપ્રિયાવ્રજબ્રાહુઈબોડોબુરિયાતબગિનીસબ્લિ" +
	"નકડ્ડોકરિબઅત્સમસિબુઆનોચિગાચિબ્ચાછગાતાઇચૂકીસેમારીચિનૂક જાર્ગનચોક્તૌશિપે" +
	"વ્યાનશેરોકીશેયેન્નસોરાની કુર્દિશકોપ્ટિકક્રિમિયન તુર્કીકાશુબિયનદાકોતાદા" +
	"ર્ગવાતૈતાદેલેવેરસ્લેવડોગ્રિબદિન્કાઝર્માડોગ્રીનિમ્ન સોર્બિયનદુઆલામધ્ય ડ" +
	"ચજોલા-ફોન્યીડ્યુલાઍમ્બુએફિકપ્રાચીન ઇજીપ્શિયનએકાજુકએલામાઇટમિડિલ અંગ્રેજ" +
	"ીઇવોન્ડોફેંગફિલિપિનોફોનમિડિલ ફ્રેંચજૂની ફ્રેંચનોર્ધર્ન ફ્રિશિયનપૂર્વ ફ" +
	"્રિશિયનફ્રિયુલિયાનGaગાગાઝગાયોબાયાઝોરોસ્ટ્રિઅન દારીગીઝજિલ્બરટીઝમધ્ય હાઇ" +
	" જર્મનજૂની હાઇ જર્મનગોઅન કોંકણીગોંડીગોરોન્તાલોગોથિકગ્રેબોપ્રાચીન ગ્રીકસ્" +
	"વિસ જર્મનગુસીગ્વિચ’ઇનહૈડાહાવાઇયનફીજી હિંદીહિલિગેનોનહિટ્ટિતેમોંગઅપ્પર સ" +
	"ોર્બિયનહૂપાઇબાનઇલોકોઇંગુશલોજ્બાનનગોમ્બામકામેજુદેઓ-પર્શિયનજુદેઓ-અરબીકાર" +
	"ા-કલ્પકકબાઇલકાચિનજ્જુકમ્બાકાવીકબાર્ડિયનત્યાપમકોન્ડેકાબુવર્ડિઆનુકોરોખાસ" +
	"ીખોતાનીસકોયરા ચિનિકલેજિનકિમ્બન્દુકોમી-પર્મ્યાકકોંકણીકોસરિયનક્પેલ્લેકરા" +
	"ચય-બલ્કારકરેલિયનકુરૂખશમ્બાલાબફિયાકુમીકકુતેનાઇલાદીનોલંગીલાહન્ડાલામ્બાલે" +
	"ઝધીયનલિંગ્વા ફેન્કા નોવાલાકોટામોગોલોઝીલ્યૂબા-લુલુઆલુઇસેનોલુન્ડાલ્યુઓલુ" +
	"શાઇલુઈયામાદુરીસમગહીમૈથિલીમકાસરમન્ડિન્ગોમસાઇમોક્ષમંડારમેન્ડેમેરુમોરીસ્ય" +
	"ેનમિડિલ આઇરિશમાખુવા-મીટ્ટુમેતામિકમેકમિનાંગ્કાબાઉમાન્ચુમણિપુરીમોહૌકમોસ્" +
	"સીપશ્ચિમી મારીમુનડાન્ગબહુવિધ ભાષાક્રિકમિરાંડીમારવાડીએર્ઝયાનેપોલિટાનનમા" +
	"લો જર્મનનેવાડીનિયાસનિયુઆનક્વાસિઓનોગાઇજૂની નોર્સએન’કોઉતરી સોથોનુએરપરંપર" +
	"ાગત નેવારીન્યામવેઝીન્યાનકોલન્યોરોન્ઝિમાઓસેજઓટોમાન તુર્કિશપંગાસીનાનપહલવ" +
	"ીપમ્પાન્ગાપાપિયામેન્ટોપલાઉઆનજૂની ફારસીફોનિશિયનપોહપિએનજુની પ્રોવેન્સલકિ" +
	"ચેરાજસ્થાનીરાપાનુઇરારોટોંગનરોમ્બોરોમાનીઅરોમેનિયનરવાસોંડવેયાકૂતસામરિટાન" +
	" અરેમિકસમ્બુરુસાસાકસંતાલીસાંગુસિસિલિયાનસ્કોટ્સસેનાસેલ્કપકોયરાબોરો સેન્ની" +
	"જૂની આયરિશતેશીલહિટશેનસિદામોદક્ષિણ સામીલ્યુલ સામીઇનારી સામીસ્કોલ્ટ સામી" +
	"સોનિન્કેસોગ્ડિએનસ્રાનન ટોન્ગોસેરેરસુકુમાસુસુસુમેરિયનકોમોરિયનકોંગો સ્વા" +
	"હિલીપરંપરાગત સિરિએકસિરિએકતુલુટિમ્નેતેસોતેરેનોતેતુમટાઇગ્રેતિવતોકેલાઉક્લ" +
	"િન્ગોનલિંગિતતામાશેખન્યાસા ટોન્ગાટોક પિસિનસિમ્શિયનમુસ્લિમ તાટતુમ્બુકાતુ" +
	"વાલુતસાવાકટુવીનિયનસેન્ટ્રલ ઍટ્લસ તામાઝિગ્ટઉદમુર્તયુગેરિટિકઉમ્બુન્ડૂમૂલ" +
	"વાઇવોટિકવુન્જોવલામોવારેવાશોકાલ્મિકસોગાયાઓયાપીસકેંટોનીઝઝેપોટેકબ્લિસિમ્બ" +
	"ોલ્સઝેનાગાપ્રમાણભૂત મોરોક્કન ટમાઝિટઝૂનીકોઇ ભાષાશાસ્ત્રીય સામગ્રી નથીઝા" +
	"ઝામોડર્ન સ્ટાન્ડર્ડ અરબીઓસ્ટ્રિઅન જર્મનસ્વિસ હાય જર્મનઓસ્ટ્રેલિયન અંગ્" +
	"રેજીકેનેડિયન અંગ્રેજીબ્રિટિશ અંગ્રેજીઅમેરિકન અંગ્રેજીલેટિન અમેરિકન સ્પ" +
	"ેનિશયુરોપિયન સ્પેનિશમેક્સિકન સ્પેનિશકેનેડિયન ફ્રેંચસ્વિસ ફ્રેંચફ્લેમિશ" +
	"બ્રાઝિલીયન પોર્ટુગીઝયુરોપિયન પોર્ટુગીઝમોલડાવિયનસર્બો-ક્રોએશિયનસરળીકૃત " +
	"ચાઇનીઝપારંપરિક ચાઇનીઝ"

// Size: 1234 bytes, 605 elements
var guLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000c, 0x0024, 0x0039, 0x0054, 0x0060, 0x0078, 0x0090,
	0x009c, 0x00ab, 0x00bd, 0x00cf, 0x00ea, 0x00fc, 0x011a, 0x0135,
	0x014d, 0x0165, 0x0177, 0x018f, 0x01a4, 0x01bc, 0x01cb, 0x01d7,
	0x01e9, 0x0201, 0x020d, 0x0216, 0x0238, 0x0247, 0x0256, 0x0265,
	0x0274, 0x0286, 0x02a1, 0x02a7, 0x02b6, 0x02ce, 0x02ef, 0x0304,
	0x031f, 0x032e, 0x033d, 0x034c, 0x035b, 0x036d, 0x0382, 0x0397,
	0x03c5, 0x03d4, 0x03f9, 0x0411, 0x0426, 0x043b, 0x044d, 0x0459,
	0x046b, 0x047d, 0x0496, 0x04b1, 0x04c3, 0x04db, 0x04f6, 0x0508,
	// Entry 40 - 7F
	0x0526, 0x0547, 0x055f, 0x056e, 0x0587, 0x059f, 0x05a8, 0x05c6,
	0x05db, 0x05f3, 0x0608, 0x061d, 0x063b, 0x064a, 0x065c, 0x067a,
	0x0686, 0x06a4, 0x06b3, 0x06c2, 0x06d4, 0x06e3, 0x06fb, 0x0710,
	0x071c, 0x0731, 0x0746, 0x0755, 0x0779, 0x0788, 0x07a6, 0x07bb,
	0x07d0, 0x07e8, 0x080d, 0x0822, 0x0834, 0x084c, 0x085b, 0x0879,
	0x088b, 0x08a6, 0x08b5, 0x08be, 0x08d3, 0x08e5, 0x08f4, 0x090d,
	0x091f, 0x0931, 0x0937, 0x0974, 0x09a5, 0x09c7, 0x09d9, 0x09f1,
	0x0a06, 0x0a1e, 0x0a2d, 0x0a3c, 0x0a54, 0x0a66, 0x0a72, 0x0a81,
	// Entry 80 - BF
	0x0a90, 0x0aab, 0x0ac0, 0x0ad5, 0x0ae7, 0x0aff, 0x0b0e, 0x0b35,
	0x0b4a, 0x0b68, 0x0b77, 0x0b99, 0x0ba8, 0x0bbd, 0x0bd2, 0x0bf0,
	0x0bff, 0x0c0b, 0x0c1d, 0x0c38, 0x0c4d, 0x0c5f, 0x0c7b, 0x0c90,
	0x0ca5, 0x0cbd, 0x0cc9, 0x0cdb, 0x0cea, 0x0cf3, 0x0d14, 0x0d2c,
	0x0d44, 0x0d56, 0x0d68, 0x0d77, 0x0d83, 0x0d9b, 0x0daa, 0x0dc8,
	0x0dd7, 0x0de9, 0x0dfb, 0x0e19, 0x0e2e, 0x0e3d, 0x0e4c, 0x0e58,
	0x0e6d, 0x0e7f, 0x0e8b, 0x0e9d, 0x0ea9, 0x0eb8, 0x0ec7, 0x0edf,
	0x0eee, 0x0eee, 0x0f09, 0x0f15, 0x0f1e, 0x0f3c, 0x0f3c, 0x0f4b,
	// Entry C0 - FF
	0x0f4b, 0x0f70, 0x0f95, 0x0fa7, 0x0fbc, 0x0fd7, 0x0fd7, 0x0fec,
	0x1014, 0x1023, 0x1048, 0x1070, 0x1079, 0x1079, 0x1094, 0x1094,
	0x10a0, 0x10cb, 0x10da, 0x10ef, 0x10ef, 0x10f8, 0x10f8, 0x10f8,
	0x10f8, 0x1104, 0x1116, 0x1116, 0x1122, 0x1122, 0x1122, 0x1137,
	0x1146, 0x1152, 0x1152, 0x1152, 0x116a, 0x118e, 0x118e, 0x119a,
	0x11af, 0x11bb, 0x11bb, 0x11d0, 0x11e2, 0x11e2, 0x11f1, 0x11f1,
	0x1200, 0x120c, 0x120c, 0x121b, 0x1230, 0x123c, 0x124e, 0x1260,
	0x1272, 0x127e, 0x12a0, 0x12b2, 0x12cd, 0x12df, 0x12f4, 0x131c,
	// Entry 100 - 13F
	0x1331, 0x1331, 0x135c, 0x1374, 0x1386, 0x139b, 0x13a7, 0x13bc,
	0x13cb, 0x13e0, 0x13f2, 0x1401, 0x1413, 0x143b, 0x143b, 0x144a,
	0x145d, 0x147c, 0x148e, 0x148e, 0x149d, 0x14a9, 0x14a9, 0x14da,
	0x14ec, 0x1501, 0x1529, 0x1529, 0x153e, 0x153e, 0x154a, 0x1562,
	0x1562, 0x156b, 0x156b, 0x158d, 0x15ac, 0x15ac, 0x15dd, 0x1605,
	0x1626, 0x1628, 0x1637, 0x1637, 0x1643, 0x164f, 0x1680, 0x1689,
	0x16a4, 0x16a4, 0x16ca, 0x16f0, 0x170f, 0x171e, 0x173c, 0x174b,
	0x175d, 0x1782, 0x17a1, 0x17a1, 0x17a1, 0x17ad, 0x17c5, 0x17d1,
	// Entry 140 - 17F
	0x17d1, 0x17e6, 0x1802, 0x181d, 0x1835, 0x1841, 0x1869, 0x1869,
	0x1875, 0x1881, 0x1881, 0x1890, 0x189f, 0x189f, 0x189f, 0x18b4,
	0x18c9, 0x18d8, 0x18fd, 0x1919, 0x1919, 0x1935, 0x1944, 0x1953,
	0x195f, 0x196e, 0x197a, 0x1995, 0x1995, 0x19a4, 0x19b9, 0x19dd,
	0x19dd, 0x19e9, 0x19e9, 0x19f5, 0x1a0a, 0x1a26, 0x1a26, 0x1a26,
	0x1a26, 0x1a38, 0x1a53, 0x1a78, 0x1a8a, 0x1a9f, 0x1ab7, 0x1ad9,
	0x1ad9, 0x1ad9, 0x1aee, 0x1afd, 0x1b12, 0x1b21, 0x1b21, 0x1b30,
	0x1b45, 0x1b57, 0x1b63, 0x1b78, 0x1b8a, 0x1b9f, 0x1bd4, 0x1bd4,
	// Entry 180 - 1BF
	0x1bd4, 0x1be6, 0x1be6, 0x1bf2, 0x1bfe, 0x1bfe, 0x1c20, 0x1c35,
	0x1c47, 0x1c56, 0x1c65, 0x1c74, 0x1c74, 0x1c74, 0x1c89, 0x1c89,
	0x1c95, 0x1ca7, 0x1cb6, 0x1cd1, 0x1cdd, 0x1cdd, 0x1cec, 0x1cfb,
	0x1d0d, 0x1d19, 0x1d34, 0x1d53, 0x1d78, 0x1d84, 0x1d96, 0x1dba,
	0x1dcc, 0x1de1, 0x1df0, 0x1e02, 0x1e24, 0x1e3c, 0x1e5b, 0x1e6a,
	0x1e7f, 0x1e94, 0x1e94, 0x1e94, 0x1ea6, 0x1ea6, 0x1ea6, 0x1ec1,
	0x1eca, 0x1ee0, 0x1ef2, 0x1f01, 0x1f13, 0x1f13, 0x1f28, 0x1f28,
	0x1f37, 0x1f53, 0x1f53, 0x1f62, 0x1f7b, 0x1f87, 0x1fb2, 0x1fcd,
	// Entry 1C0 - 1FF
	0x1fe5, 0x1ff7, 0x2009, 0x2015, 0x203d, 0x2058, 0x2067, 0x2082,
	0x20a6, 0x20b8, 0x20b8, 0x20b8, 0x20b8, 0x20d4, 0x20d4, 0x20ec,
	0x20ec, 0x20ec, 0x2101, 0x2101, 0x212c, 0x2138, 0x2138, 0x2153,
	0x2168, 0x2183, 0x2183, 0x2183, 0x2195, 0x21a7, 0x21a7, 0x21a7,
	0x21a7, 0x21c2, 0x21cb, 0x21dd, 0x21ec, 0x2217, 0x222c, 0x223b,
	0x224d, 0x224d, 0x224d, 0x225c, 0x2277, 0x228c, 0x228c, 0x228c,
	0x2298, 0x2298, 0x22aa, 0x22d8, 0x22f4, 0x22f4, 0x230c, 0x2315,
	0x2315, 0x2327, 0x2327, 0x2327, 0x2346, 0x2362, 0x237e, 0x23a0,
	// Entry 200 - 23F
	0x23b8, 0x23d0, 0x23f5, 0x2404, 0x2404, 0x2404, 0x2416, 0x2422,
	0x243a, 0x2452, 0x247a, 0x24a5, 0x24b7, 0x24b7, 0x24c3, 0x24d5,
	0x24e1, 0x24f3, 0x2502, 0x2517, 0x2520, 0x2535, 0x2535, 0x2550,
	0x2562, 0x2562, 0x2577, 0x259c, 0x25b5, 0x25b5, 0x25b5, 0x25b5,
	0x25cd, 0x25ec, 0x2604, 0x2616, 0x2628, 0x2640, 0x2684, 0x2699,
	0x26b4, 0x26cf, 0x26d8, 0x26e1, 0x26e1, 0x26e1, 0x26e1, 0x26e1,
	0x26f0, 0x26f0, 0x2702, 0x2702, 0x2711, 0x271d, 0x2729, 0x2729,
	0x2729, 0x273e, 0x273e, 0x274a, 0x2753, 0x2762, 0x2762, 0x2762,
	// Entry 240 - 27F
	0x2762, 0x277a, 0x278f, 0x27b6, 0x27b6, 0x27c8, 0x280f, 0x281b,
	0x286c, 0x2878, 0x28b6, 0x28e1, 0x290a, 0x2944, 0x2975, 0x29a3,
	0x29d1, 0x2a0c, 0x2a3a, 0x2a68, 0x2a93, 0x2ab5, 0x2aca, 0x2b04,
	0x2b38, 0x2b53, 0x2b7e, 0x2ba6, 0x2bd1,
}

// Size: 7063 bytes
const heLangStr = "" +
	"אפאריתאבחזיתאבסטןאפריקאנסאקאןאמהריתאראגוניתערביתאסאמיתאבאריתאיימאריתאזרי" +
	"תבשקיריתבלארוסיתבולגריתביסלמהבמבארהבנגליתטיבטיתברטוניתבוסניתקטלאניתצ׳צ׳" +
	"ניתצ׳מורוקורסיקניתקריצ׳כיתסלאבית כנסייתית עתיקהצ׳ובאשולשיתדניתגרמניתדיב" +
	"הידזונקהאווהיווניתאנגליתאספרנטוספרדיתאסטוניתבסקיתפרסיתפולהפיניתפיג׳יתפא" +
	"רואזיתצרפתיתפריזיתאיריתגאלית סקוטיתגליציאניתגוארניגוג׳ראטיתמאניתהאוסהעב" +
	"ריתהינדיהארי מוטוקרואטיתהאיטיתהונגריתארמניתהררו\u200fאינטרלינגואהאינדונ" +
	"זיתאינטרלינגהאיגבוסיצ׳ואן ייאינופיאקאידואיסלנדיתאיטלקיתאינוקטיטוטיפניתי" +
	"אווניתגאורגיתקונגוקיקויוקואניאמהקזחיתקאלאליסוטיתקמריתקנאדהקוריאניתקאנור" +
	"יקשמיריתכורדיתקומיקורניתקירגיזיתלטיניתלוקסמבורגיתגאנדהלימבורגישלינגלהלא" +
	"יתליטאיתלובה-קטנגהלטביתמלגשיתמרשאלסמאוריתמקדוניתמלאיאלםמונגוליתמרטהימלא" +
	"יתמלטיתבורמזיתנאוריתצפון נדבלהנפאליתנדונגההולנדיתנורבגית חדשה\u200fנורב" +
	"גית ספרותיתדרום נדבלהנבחוניאנג׳האוקסיטניתאוג׳יבווהאורומואוריהאוסטיתפנג׳" +
	"אביתפאליפולניתפאשטופורטוגליתקצ׳ואהרומאנשקירונדירומניתרוסיתקינירואנדהסנס" +
	"קריטסרדיניתסינדהיתלאפית צפוניתסנגוסינהלהסלובקיתסלובניתסמואיתשונהסומליתא" +
	"לבניתסרביתסיסוואטיססות׳וסונדניתשוודיתסווהיליתטמיליתטלוגוטג׳יקיתתאיתטיגר" +
	"ינאיתטורקמניתטוניסיהטונגןטורקיתטסונגהטטריתטהיטיתאויגהוראוקראיניתאורדואו" +
	"זבקיתוונדהויאטנמית\u200fוולאפיקוואלוןג׳ולוףקסוסהיידישיורובהז׳ואנגסיניתז" +
	"ולואכינזיתאקוליאדנמהאדיגיתאפריהיליאהייםאינואכדיתאלאוטאלטאי דרומיתאנגלית" +
	" עתיקהאנג׳יקהארמיתאראוקניתארפהוארוואקאסואסטוריתאוואדיתבאלוצ׳יבלינזיתבווא" +
	"ריתבסאאבאקסגומלבז׳הבמבהבנהבאפוטבוג׳פוריביקולביניקוםסיקסיקהבראג׳בודואקוס" +
	"הבוריאטבוגינזיתבולובליןמדומבהקאדוקאריבקאיוגהאטסםקבואנוצ׳יגהצ׳יבצ׳הצ׳אגא" +
	"טאיצ׳וקסהמאריניב צ׳ינוקצ׳וקטאוצ׳יפוויאןצ׳רוקישאייןכורדית סוראניתקופטיתט" +
	"טרית של קריםקשוביאןדקוטהדרגווהטאיטהדלאוורסלאביתדוגריבדינקהזארמהדוגריסור" +
	"בית נמוכהדואלההולנדית תיכונההולה-פוניידיולהדזאנגהאמבואפיקמצרית עתיקהאקי" +
	"וקעילמיתאנגלית תיכונהאוונדופנגפיליפיניתפוןצרפתית תיכונהצרפתית עתיקהפריז" +
	"ית צפוניתפריזיאן מזרחיתפריוליתגאגגאוזיתגאיוגבאיהגעזגילברטזיתגרמנית בינו" +
	"נית-גבוההגרמנית עתיקה גבוההגונדיגורונטאלוגותיתגרבויוונית עתיקהגרמנית שו" +
	"ויצריתגוסיגוויצ׳יןהאידההוואיתהיליגאינוןחיתיתמונגסורבית גבוהההופהאיבאןאי" +
	"ביביואילוקואינגושיתלויבאןנגומהמצ׳אמהפרסית יהודיתערבית יהודיתקארא-קלפאקק" +
	"בילהקצ׳יןג׳יוקמבהקאוויקברדיתקנמבוטיאפמקונדהקאבוורדיאנוקורוקאסיקוטאנזיתק" +
	"וירה צ׳יניקאקוקאלנג׳יןקימבונדוקומי-פרמיאקיתקונקאניקוסראיאןקפלהקראצ׳י-בל" +
	"קרקארליתקורוקשמבאלהבאפיהקולוניאןקומיקקוטנאילדינולאנגילנדהלמבהלזגיתלקוטה" +
	"מונגולוזילובה, לולואהלואיסנולונדהלואולושאילויהמדורסהמאפאמאגאהיתמאיטילית" +
	"מקסארמנדינגומאסאיתמאבאמוקשהמנדארמנדהמרומוריסייןאירית תיכונהמקואה-מיטומט" +
	"אמיקמקמיננגקבאומנצ׳ומניפוריתמוהוקמוסימונדאנגמספר שפותקריקמירנדזיתמרוואר" +
	"ימאייןארזיהנפוליטניתנאמהגרמנית תחתיתנוואריניאסניואיאןקוואסיונגיאמבוןנוג" +
	"אי\u200fנורדית עתיקהנ׳קוסוטו הצפוניתנוארנווארית קלאסיתניאמווזיניאנקולהנ" +
	"יורונזימהאוסג׳הטורקית עותומניתפנגסינאןפלאביפמפאניהפפיאמנטופלוואןפרסית ע" +
	"תיקהפניקיתפונפיאןפרובנסאל עתיקהקיצ׳הראג׳סטןרפאנויררוטונגאןרומבורומאניתא" +
	"רומניתרוואסנדאווהסאחהארמית שומרוניתסמבורוססאקסאנטלינגמבאיסאנגוסיציליאני" +
	"תסקוטיתסנקהסנהסלקופקויראבורו סניאירית עתיקהטצ׳להיטשאןערבית צ׳אדיתסידמוס" +
	"אמי דרומיתלולה סאמיאינארי סאמיסקולט סאמיסונינקהסוגדיאןסרנאן טונגוסררסאה" +
	"וסוקומהסוסושומריתסווהילי קונגולטזיתסירית קלאסיתסוריתטימנהטסוטרנוטטוםטיג" +
	"ריתטיבטוקלאוקלינגוןטלינגיטטמאשקניאסה טונגהטוק פיסיןטרוקוטסימשיאןטומבוקה" +
	"טובאלוטסוואקטוביניתטמזייט של מרכז מרוקואודמורטאוגריתיתאומבונדורוטואיווט" +
	"יקוונג׳ווואלסרוולאמוווראיוואשוקלמיקסוגהיאויאפזיתיאנגבןימבהקנטונזיתזאפוט" +
	"קבליסימבולסזנאגהתמזיע׳ת מרוקאית תקניתזוניללא תוכן לשוניזאזאערבית ספרותי" +
	"תגרמנית אוסטריתגרמנית שוויצרית (גבוהה)אנגלית אוסטרליתאנגלית קנדיתאנגלית" +
	" בריטיתאנגלית אמריקאיתספרדית לטינו־אמריקאיתספרדית אירופאיתספרדית מקסיקני" +
	"תצרפתית קנדיתצרפתית שוויצריתפלמיתפורטוגלית ברזילאיתפורטוגלית אירופאיתמו" +
	"לדביתסרבו-קרואטיתסינית מפושטתסינית מסורתית"

// Size: 1234 bytes, 605 elements
var heLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000c, 0x0018, 0x0022, 0x0032, 0x003a, 0x0046, 0x0056,
	0x0060, 0x006c, 0x0078, 0x0088, 0x0092, 0x00a0, 0x00b0, 0x00be,
	0x00ca, 0x00d6, 0x00e2, 0x00ee, 0x00fc, 0x0108, 0x0116, 0x0124,
	0x0130, 0x0142, 0x0148, 0x0152, 0x017a, 0x0186, 0x0190, 0x0198,
	0x01a4, 0x01ae, 0x01ba, 0x01c2, 0x01ce, 0x01da, 0x01e8, 0x01f4,
	0x0202, 0x020c, 0x0216, 0x021e, 0x0228, 0x0234, 0x0244, 0x0250,
	0x025c, 0x0266, 0x027d, 0x028f, 0x029b, 0x02ad, 0x02b7, 0x02c1,
	0x02cb, 0x02d5, 0x02e6, 0x02f4, 0x0300, 0x030e, 0x031a, 0x0322,
	// Entry 40 - 7F
	0x033d, 0x034f, 0x0363, 0x036d, 0x0380, 0x0390, 0x0398, 0x03a8,
	0x03b6, 0x03ca, 0x03d4, 0x03e2, 0x03f0, 0x03fa, 0x0406, 0x0416,
	0x0420, 0x0436, 0x0440, 0x044a, 0x045a, 0x0466, 0x0474, 0x0480,
	0x0488, 0x0494, 0x04a4, 0x04b0, 0x04c6, 0x04d0, 0x04e2, 0x04ee,
	0x04f6, 0x0502, 0x0515, 0x051f, 0x052b, 0x0537, 0x0543, 0x0551,
	0x055f, 0x056f, 0x0579, 0x0583, 0x058d, 0x059b, 0x05a7, 0x05ba,
	0x05c6, 0x05d2, 0x05e0, 0x05f7, 0x0617, 0x062a, 0x0632, 0x0640,
	0x0652, 0x0664, 0x0670, 0x067a, 0x0686, 0x0696, 0x069e, 0x06aa,
	// Entry 80 - BF
	0x06b4, 0x06c6, 0x06d2, 0x06de, 0x06ec, 0x06f8, 0x0702, 0x0716,
	0x0724, 0x0732, 0x0740, 0x0757, 0x075f, 0x076b, 0x0779, 0x0787,
	0x0793, 0x079b, 0x07a7, 0x07b3, 0x07bd, 0x07cd, 0x07d9, 0x07e7,
	0x07f3, 0x0803, 0x080f, 0x0819, 0x0827, 0x082f, 0x0841, 0x0851,
	0x085f, 0x0869, 0x0875, 0x0881, 0x088b, 0x0897, 0x08a5, 0x08b7,
	0x08c1, 0x08cf, 0x08d9, 0x08e9, 0x08fa, 0x0906, 0x0912, 0x091c,
	0x0926, 0x0932, 0x093e, 0x0948, 0x0950, 0x095e, 0x0968, 0x0972,
	0x097e, 0x097e, 0x098e, 0x0998, 0x09a0, 0x09aa, 0x09aa, 0x09b4,
	// Entry C0 - FF
	0x09b4, 0x09cb, 0x09e2, 0x09f0, 0x09fa, 0x0a0a, 0x0a0a, 0x0a14,
	0x0a14, 0x0a20, 0x0a20, 0x0a20, 0x0a26, 0x0a26, 0x0a34, 0x0a34,
	0x0a42, 0x0a42, 0x0a50, 0x0a5e, 0x0a6c, 0x0a74, 0x0a7c, 0x0a7c,
	0x0a84, 0x0a8c, 0x0a94, 0x0a94, 0x0a9a, 0x0aa4, 0x0aa4, 0x0ab4,
	0x0abe, 0x0ac6, 0x0ac6, 0x0acc, 0x0ada, 0x0ada, 0x0ada, 0x0ae4,
	0x0ae4, 0x0aec, 0x0af6, 0x0b02, 0x0b12, 0x0b1a, 0x0b22, 0x0b2e,
	0x0b36, 0x0b40, 0x0b4c, 0x0b54, 0x0b60, 0x0b6a, 0x0b78, 0x0b88,
	0x0b94, 0x0b9c, 0x0baf, 0x0bbd, 0x0bcf, 0x0bdb, 0x0be5, 0x0c00,
	// Entry 100 - 13F
	0x0c0c, 0x0c0c, 0x0c24, 0x0c32, 0x0c3c, 0x0c48, 0x0c52, 0x0c5e,
	0x0c6a, 0x0c76, 0x0c80, 0x0c8a, 0x0c94, 0x0cab, 0x0cab, 0x0cb5,
	0x0cd0, 0x0ce3, 0x0ced, 0x0cf9, 0x0d01, 0x0d09, 0x0d09, 0x0d1e,
	0x0d28, 0x0d34, 0x0d4d, 0x0d4d, 0x0d59, 0x0d59, 0x0d5f, 0x0d71,
	0x0d71, 0x0d77, 0x0d77, 0x0d90, 0x0da7, 0x0da7, 0x0dc0, 0x0ddb,
	0x0de9, 0x0ded, 0x0dfb, 0x0dfb, 0x0e03, 0x0e0d, 0x0e0d, 0x0e13,
	0x0e25, 0x0e25, 0x0e4b, 0x0e6d, 0x0e6d, 0x0e77, 0x0e89, 0x0e93,
	0x0e9b, 0x0eb2, 0x0ecf, 0x0ecf, 0x0ecf, 0x0ed7, 0x0ee7, 0x0ef1,
	// Entry 140 - 17F
	0x0ef1, 0x0efd, 0x0efd, 0x0f11, 0x0f1b, 0x0f23, 0x0f3a, 0x0f3a,
	0x0f42, 0x0f4c, 0x0f5a, 0x0f66, 0x0f76, 0x0f76, 0x0f76, 0x0f82,
	0x0f8c, 0x0f98, 0x0faf, 0x0fc6, 0x0fc6, 0x0fd9, 0x0fe3, 0x0fed,
	0x0ff5, 0x0ffd, 0x1007, 0x1013, 0x101d, 0x1025, 0x1031, 0x1047,
	0x1047, 0x104f, 0x104f, 0x1057, 0x1067, 0x107c, 0x107c, 0x107c,
	0x1084, 0x1094, 0x10a4, 0x10bd, 0x10cb, 0x10db, 0x10e3, 0x10f8,
	0x10f8, 0x10f8, 0x1104, 0x110e, 0x111a, 0x1124, 0x1134, 0x113e,
	0x114a, 0x1154, 0x115e, 0x1166, 0x116e, 0x1178, 0x1178, 0x1178,
	// Entry 180 - 1BF
	0x1178, 0x1182, 0x1182, 0x118c, 0x1194, 0x1194, 0x11aa, 0x11b8,
	0x11c2, 0x11ca, 0x11d4, 0x11dc, 0x11dc, 0x11dc, 0x11e8, 0x11f0,
	0x11fe, 0x120e, 0x1218, 0x1226, 0x1232, 0x123a, 0x1244, 0x124e,
	0x1256, 0x125c, 0x126c, 0x1283, 0x1296, 0x129c, 0x12a6, 0x12b8,
	0x12c2, 0x12d2, 0x12dc, 0x12e4, 0x12e4, 0x12f2, 0x1303, 0x130b,
	0x131b, 0x1329, 0x1329, 0x1333, 0x133d, 0x133d, 0x133d, 0x134f,
	0x1357, 0x136e, 0x137a, 0x1382, 0x1390, 0x1390, 0x139e, 0x13ae,
	0x13b8, 0x13d2, 0x13d2, 0x13da, 0x13f1, 0x13f9, 0x1414, 0x1424,
	// Entry 1C0 - 1FF
	0x1434, 0x143e, 0x1448, 0x1454, 0x1471, 0x1481, 0x148b, 0x1499,
	0x14a9, 0x14b5, 0x14b5, 0x14b5, 0x14b5, 0x14ca, 0x14ca, 0x14d6,
	0x14d6, 0x14d6, 0x14e4, 0x14e4, 0x14ff, 0x1509, 0x1509, 0x1517,
	0x1523, 0x1535, 0x1535, 0x1535, 0x153f, 0x154d, 0x154d, 0x154d,
	0x154d, 0x155b, 0x1563, 0x1571, 0x1579, 0x1594, 0x15a0, 0x15a8,
	0x15b4, 0x15b4, 0x15c0, 0x15ca, 0x15de, 0x15ea, 0x15ea, 0x15f2,
	0x15f8, 0x15f8, 0x1602, 0x161b, 0x1630, 0x1630, 0x163e, 0x1644,
	0x165b, 0x1665, 0x1665, 0x1665, 0x167a, 0x168b, 0x16a0, 0x16b3,
	// Entry 200 - 23F
	0x16c1, 0x16cf, 0x16e4, 0x16ea, 0x16f2, 0x16f2, 0x16fe, 0x1706,
	0x1712, 0x1712, 0x1735, 0x174c, 0x1756, 0x1756, 0x1756, 0x1760,
	0x1766, 0x176e, 0x1776, 0x1782, 0x1788, 0x1794, 0x1794, 0x17a2,
	0x17b0, 0x17b0, 0x17ba, 0x17cf, 0x17e0, 0x17e0, 0x17ea, 0x17ea,
	0x17fa, 0x17fa, 0x1808, 0x1814, 0x1820, 0x182e, 0x1853, 0x1861,
	0x1871, 0x1881, 0x1887, 0x188d, 0x188d, 0x188d, 0x188d, 0x188d,
	0x1897, 0x1897, 0x18a3, 0x18af, 0x18bb, 0x18c5, 0x18cf, 0x18cf,
	0x18cf, 0x18d9, 0x18d9, 0x18e1, 0x18e7, 0x18f3, 0x18ff, 0x1907,
	// Entry 240 - 27F
	0x1907, 0x1917, 0x1923, 0x1937, 0x1937, 0x1941, 0x1969, 0x1971,
	0x198b, 0x1993, 0x19ac, 0x19c7, 0x19f1, 0x1a0e, 0x1a25, 0x1a3e,
	0x1a5b, 0x1a84, 0x1aa1, 0x1abe, 0x1ad5, 0x1af2, 0x1afc, 0x1b1f,
	0x1b42, 0x1b50, 0x1b67, 0x1b7e, 0x1b97,
}

// Size: 10978 bytes
const hiLangStr = "" +
	"अफ़ारअब्ख़ाज़ियनअवस्ताईअफ़्रीकीअकनअम्हेरीअर्गोनीअरबीअसमियाअवेरिकआयमाराअज" +
	"़रबैजानीबशख़िरबेलारूसीबुल्गारियाईबिस्लामाबाम्बाराबंगालीतिब्बतीब्रेटनबो" +
	"स्नियाईकातालानचेचनकमोरोकोर्सीकनक्रीचेकचर्च साल्विकचूवाशवेल्शडेनिशजर्मन" +
	"दिवेहीज़ोन्गखाईवेयूनानीअंग्रेज़ीएस्पेरेंतोस्पेनीएस्टोनियाईबास्कफ़ारसीफ" +
	"ुलाहफ़िनिशफ़ीजीफ़ैरोइज़फ़्रेंचपश्चिमी फ़्रिसियाईआइरिशस्काट्स् गायेलिक्" +
	"गैलिशियनगुआरानीगुजरातीमैंक्सहौसाहिब्रूहिन्दीहिरी मोटूक्रोएशियाईहैतियाई" +
	"हंगेरियाईआर्मेनियाईहरैरोईन्टरलिंगुआइंडोनेशियाईईन्टरलिंगुइईग्बोसिचुआन य" +
	"ीइनुपियाक्इडौआइसलैंडीइतालवीइनूकीटूत्जापानीजावानीज़जॉर्जियाईकोंगोकिकुयू" +
	"क्वान्यामाकज़ाख़ग्रीनलैंडिकखमेरकन्नड़कोरियाईकनुरीकश्मीरीकुर्दिशकोमीकोर" +
	"्निशकिर्गीज़लैटिनलग्ज़मबर्गीगांडालिंबर्गिशलिंगालालाओलिथुआनियाईल्यूबा-क" +
	"टांगालातवियाईमालागासीमार्शलीज़माओरीमैसिडोनियाईमलयालममंगोलीयाईमराठीमलयम" +
	"ाल्टीज़बर्मीज़नाउरूउत्तरी देबेलनेपालीडोन्गाडचनॉर्वेजियाई नॉयनॉर्स्कनॉर" +
	"्वेजियाई बोकमालदक्षिण देबेलनावाजोन्यानजाओसीटानओजिब्वाओरोमोउड़ियाओस्सेट" +
	"िकपंजाबीपालीपोलिशपश्तोपुर्तगालीक्वेचुआरोमान्शरुन्दीरोमानियाईरूसीकिन्या" +
	"रवांडासंस्कृतसार्दिनियनसिंधीनॉर्दन सामीसांगोसिंहलीस्लोवाकस्लोवेनियाईसा" +
	"मोनशोणासोमालीअल्बानियाईसर्बियाईस्वातीसेसोथोसुंडानीस्वीडिशस्वाहिलीतमिलत" +
	"ेलुगूताजिकथाईतिग्रीन्यातुर्कमेनसेत्स्वानाटोंगनतुर्कीसोंगातातारताहितियन" +
	"विघुरयूक्रेनियाईउर्दूउज़्बेकवेन्दावियतनामीवोलापुकवाल्लूनवोलोफ़ख़ोसायेह" +
	"ुदीयोरूबाज़ुआंगचीनीज़ुलूअचाइनीसअकोलीअदान्गमेअदिघेअफ्रिहिलीअग्हेमऐनूअक्" +
	"कादीअलेउतदक्षिणी अल्ताईपुरानी अंग्रेज़ीअंगिकाऐरेमेकमापूचेअराफाओअरावकअस" +
	"ुअस्तुरियनअवधीबलूचीबालिनीसबसाबेजाबेम्बाबेनाभोजपुरीबिकोलबिनीसिक्सिकाब्र" +
	"जबोडोबुरियातबगिनीसब्लिनकैड्डोकैरिबअत्समसिबुआनोशिगाचिब्चाछगाताईचूकीसमार" +
	"ीचिनूक जारगॉनचोक्तौशिपेव्यानशेरोकीशेयेन्नसोरानी कुर्दिशकॉप्टिकक्रीमीन " +
	"तुर्कीकाशुबियनदाकोतादार्गवातैताडिलैवेयरस्लेवडोग्रिबदिन्काझार्माडोग्रीन" +
	"िचला सॉर्बियनदुआलामध्य पुर्तगालीजोला-फोंईड्युलाएम्बुएफिकप्राचीन मिस्री" +
	"एकाजुकएलामाइटमध्यकालीन अंग्रेज़ीइवोन्डोफैन्गफ़िलिपीनोफॉनमध्यकालीन फ़्र" +
	"ांसीसीपुरातन फ़्रांसीसीउत्तरी फ्रीसीयनपूर्वी फ्रीसीयनफ्रीयुलीयानगागागौ" +
	"ज़गायोग्बायागीज़गिल्बरतीसमध्यकालीन हाइ जर्मनपुरातन हाइ जर्मनगाँडीगोरोन" +
	"्तालोगॉथिकग्रेबोप्राचीन यूनानीस्विस जर्मनगुसीग्विच’इनहैडाहवाईहिलिगेननह" +
	"िताइतह्मॉंगऊपरी सॉर्बियनहूपाइबानइलोकोइंगुशलोज्बाननगोंबामैकहैमेजुदेओ-पर" +
	"्शियनजुदेओ-अरेबिककारा-कल्पककबाइलकाचिनज्जुकम्बाकावीकबार्डियनत्यापमैकोंड" +
	"काबुवेर्दियानुकोरोखासीखोतानीसकोयरा चीनीकलेंजिनकिम्बन्दुकोमी-पर्मयाककों" +
	"कणीकोसरैनक्पेल्लैकराचय-बल्कारकरेलियनकुरूखशम्बालाबफिआकुमीककुतेनाईलादीनो" +
	"लांगिलाह्न्डालाम्बालेज़्घीयनलैकोटामोंगोलोज़ील्यूबा-लुलुआलुइसेनोलुन्डाल" +
	"्युओलुशाईल्युईआमादुरीसमगाहीमैथिलीमकासरमन्डिन्गोमसाईमोक्षमंधारमेन्डेमेर" +
	"ुमोरीस्येनमध्यकाल आइरिशमैखुवा-मीट्टोमेटामिकमैकमिनांग्काबाउमन्चुमणिपूरी" +
	"मोहौकमोस्सीमुंडैंगविविध भाषाएँक्रीकमिरांडीमारवाड़ीएर्ज़यानीपोलिटननामान" +
	"िचला जर्मननेवाड़ीनियासनियुआनक्वासिओनोगाईपुराना नॉर्सएन्कोउत्तरी सोथोनु" +
	"एरपारम्परिक नेवारीन्यामवेज़ीन्यानकोलन्योरोन्ज़ीमाओसेजओटोमान तुर्किशपंग" +
	"ासीनानपाह्लावीपाम्पान्गापापियामेन्टोपलोउआनपुरानी फारसीफोएनिशियनपोह्नपि" +
	"एनपुरानी प्रोवेन्सलकिशराजस्थानीरापानुईरारोतोंगनरोम्बोरोमानीअरोमानियनरव" +
	"ासन्डावेयाकूतसामैरिटन अरैमिकसैम्बुरुसासाकसंतालीसैंगुसिसिलियनस्कॉट्ससेन" +
	"ासेल्कपकोयराबोरो सेन्नीपुरानी आइरिशतैचेल्हितशैनसिदामोदक्षिण सामील्युल " +
	"सामीइनारी सामीस्कोल्ट सामीसोनिन्केसोग्डिएनस्रानान टॉन्गोसेरेरसुकुमासुस" +
	"ुसुमेरियनकांगो स्वाहिलीक्लासिकल सिरिएकसिरिएकटिम्नेटेसोतेरेनोतेतुमटाइग्" +
	"रेतिवतोकेलाऊक्लिंगनत्लिंगिततामाशेकन्यासा टोन्गाटोक पिसिनत्सिमीशियनतम्ब" +
	"ूकातुवालुटासवाकतुवीनियनमध्य एटलस तमाज़ितउदमुर्तयुगैरिटिकउम्बुन्डुरूटवा" +
	"ईवॉटिकवुंजोवलामोवारैवाशोकाल्मिकसोगायाओयापीसकैंटोनीज़ज़ेपोटेकब्लिसिम्बॉ" +
	"ल्सज़ेनान्गामानक मोरक्कन तामाज़ाइटज़ूनीकोई भाषा सामग्री नहींज़ाज़ाआधुन" +
	"िक मानक अरबीऑस्ट्रियाई जर्मनस्विस उच्च जर्मनऑस्ट्रेलियाई अंग्रेज़ीकनाड" +
	"ाई अंग्रेज़ीब्रिटिश अंग्रेज़ीअमेरिकी अंग्रेज़ीलैटिन अमेरिकी स्पेनीयूरो" +
	"पीय स्पेनीमैक्सिकन स्पेनिशकनाडाई फ़्रेंचस्विस फ़्रेंचफ़्लेमिशब्राज़ीली" +
	" पुर्तगालीयूरोपीय पुर्तगालीमोलडावियनसेर्बो-क्रोएशन्सरलीकृत चीनीपारंपरिक " +
	"चीनी"

// Size: 1234 bytes, 605 elements
var hiLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000f, 0x0030, 0x0045, 0x005d, 0x0066, 0x007b, 0x0090,
	0x009c, 0x00ae, 0x00c0, 0x00d2, 0x00f0, 0x0102, 0x011a, 0x013b,
	0x0153, 0x016b, 0x017d, 0x0192, 0x01a4, 0x01bf, 0x01d4, 0x01e0,
	0x01ef, 0x0207, 0x0213, 0x021c, 0x023e, 0x024d, 0x025c, 0x026b,
	0x027a, 0x028c, 0x02a4, 0x02ad, 0x02bf, 0x02da, 0x02f8, 0x030a,
	0x0328, 0x0337, 0x0349, 0x0358, 0x036a, 0x0379, 0x0391, 0x03a6,
	0x03da, 0x03e9, 0x041a, 0x0432, 0x0447, 0x045c, 0x046e, 0x047a,
	0x048c, 0x049e, 0x04b7, 0x04d5, 0x04ea, 0x0505, 0x0523, 0x0532,
	// Entry 40 - 7F
	0x0553, 0x0574, 0x0595, 0x05a4, 0x05bd, 0x05d8, 0x05e1, 0x05f9,
	0x060b, 0x0626, 0x0638, 0x0650, 0x066b, 0x067a, 0x068c, 0x06aa,
	0x06bc, 0x06dd, 0x06e9, 0x06fb, 0x0710, 0x071f, 0x0734, 0x0749,
	0x0755, 0x076a, 0x0782, 0x0791, 0x07b2, 0x07c1, 0x07dc, 0x07f1,
	0x07fa, 0x0818, 0x083d, 0x0855, 0x086d, 0x0888, 0x0897, 0x08b8,
	0x08ca, 0x08e5, 0x08f4, 0x08fd, 0x0915, 0x092a, 0x0939, 0x095b,
	0x096d, 0x097f, 0x0985, 0x09c5, 0x09f9, 0x0a1b, 0x0a2d, 0x0a42,
	0x0a54, 0x0a69, 0x0a78, 0x0a8a, 0x0aa2, 0x0ab4, 0x0ac0, 0x0acf,
	// Entry 80 - BF
	0x0ade, 0x0af9, 0x0b0e, 0x0b23, 0x0b35, 0x0b50, 0x0b5c, 0x0b80,
	0x0b95, 0x0bb3, 0x0bc2, 0x0be1, 0x0bf0, 0x0c02, 0x0c17, 0x0c38,
	0x0c47, 0x0c53, 0x0c65, 0x0c83, 0x0c9b, 0x0cad, 0x0cbf, 0x0cd4,
	0x0ce9, 0x0d01, 0x0d0d, 0x0d1f, 0x0d2e, 0x0d37, 0x0d55, 0x0d6d,
	0x0d8b, 0x0d9a, 0x0dac, 0x0dbb, 0x0dca, 0x0de2, 0x0df1, 0x0e12,
	0x0e21, 0x0e36, 0x0e48, 0x0e60, 0x0e75, 0x0e8a, 0x0e9c, 0x0eab,
	0x0ebd, 0x0ecf, 0x0ee1, 0x0eed, 0x0efc, 0x0f11, 0x0f20, 0x0f38,
	0x0f47, 0x0f47, 0x0f62, 0x0f74, 0x0f7d, 0x0f92, 0x0f92, 0x0fa1,
	// Entry C0 - FF
	0x0fa1, 0x0fc9, 0x0ff7, 0x1009, 0x101b, 0x102d, 0x102d, 0x103f,
	0x103f, 0x104e, 0x104e, 0x104e, 0x1057, 0x1057, 0x1072, 0x1072,
	0x107e, 0x107e, 0x108d, 0x10a2, 0x10a2, 0x10ab, 0x10ab, 0x10ab,
	0x10ab, 0x10b7, 0x10c9, 0x10c9, 0x10d5, 0x10d5, 0x10d5, 0x10ea,
	0x10f9, 0x1105, 0x1105, 0x1105, 0x111d, 0x111d, 0x111d, 0x1129,
	0x1129, 0x1135, 0x1135, 0x114a, 0x115c, 0x115c, 0x116b, 0x116b,
	0x117d, 0x118c, 0x118c, 0x119b, 0x11b0, 0x11bc, 0x11ce, 0x11e0,
	0x11ef, 0x11fb, 0x121d, 0x122f, 0x124a, 0x125c, 0x1271, 0x1299,
	// Entry 100 - 13F
	0x12ae, 0x12ae, 0x12d6, 0x12ee, 0x1300, 0x1315, 0x1321, 0x1339,
	0x1348, 0x135d, 0x136f, 0x1381, 0x1393, 0x13bb, 0x13bb, 0x13ca,
	0x13f2, 0x140b, 0x141d, 0x141d, 0x142c, 0x1438, 0x1438, 0x1460,
	0x1472, 0x1487, 0x14be, 0x14be, 0x14d3, 0x14d3, 0x14e2, 0x14fd,
	0x14fd, 0x1506, 0x1506, 0x1540, 0x1571, 0x1571, 0x159c, 0x15c7,
	0x15e8, 0x15ee, 0x1600, 0x1600, 0x160c, 0x161e, 0x161e, 0x162a,
	0x1645, 0x1645, 0x167a, 0x16a6, 0x16a6, 0x16b5, 0x16d3, 0x16e2,
	0x16f4, 0x171c, 0x173b, 0x173b, 0x173b, 0x1747, 0x175f, 0x176b,
	// Entry 140 - 17F
	0x176b, 0x1777, 0x1777, 0x178f, 0x17a1, 0x17b3, 0x17d8, 0x17d8,
	0x17e4, 0x17f0, 0x17f0, 0x17ff, 0x180e, 0x180e, 0x180e, 0x1823,
	0x1835, 0x184a, 0x186f, 0x1891, 0x1891, 0x18ad, 0x18bc, 0x18cb,
	0x18d7, 0x18e6, 0x18f2, 0x190d, 0x190d, 0x191c, 0x192e, 0x1958,
	0x1958, 0x1964, 0x1964, 0x1970, 0x1985, 0x19a1, 0x19a1, 0x19a1,
	0x19a1, 0x19b6, 0x19d1, 0x19f3, 0x1a05, 0x1a17, 0x1a2f, 0x1a51,
	0x1a51, 0x1a51, 0x1a66, 0x1a75, 0x1a8a, 0x1a96, 0x1a96, 0x1aa5,
	0x1aba, 0x1acc, 0x1adb, 0x1af3, 0x1b05, 0x1b20, 0x1b20, 0x1b20,
	// Entry 180 - 1BF
	0x1b20, 0x1b32, 0x1b32, 0x1b41, 0x1b50, 0x1b50, 0x1b72, 0x1b87,
	0x1b99, 0x1ba8, 0x1bb7, 0x1bc9, 0x1bc9, 0x1bc9, 0x1bde, 0x1bde,
	0x1bed, 0x1bff, 0x1c0e, 0x1c29, 0x1c35, 0x1c35, 0x1c44, 0x1c53,
	0x1c65, 0x1c71, 0x1c8c, 0x1cb1, 0x1cd6, 0x1ce2, 0x1cf4, 0x1d18,
	0x1d27, 0x1d3c, 0x1d4b, 0x1d5d, 0x1d5d, 0x1d72, 0x1d94, 0x1da3,
	0x1db8, 0x1dd0, 0x1dd0, 0x1dd0, 0x1de5, 0x1de5, 0x1de5, 0x1dfd,
	0x1e09, 0x1e28, 0x1e3d, 0x1e4c, 0x1e5e, 0x1e5e, 0x1e73, 0x1e73,
	0x1e82, 0x1ea4, 0x1ea4, 0x1eb3, 0x1ed2, 0x1ede, 0x1f0c, 0x1f2a,
	// Entry 1C0 - 1FF
	0x1f42, 0x1f54, 0x1f69, 0x1f75, 0x1f9d, 0x1fb8, 0x1fd0, 0x1fee,
	0x2012, 0x2024, 0x2024, 0x2024, 0x2024, 0x2046, 0x2046, 0x2061,
	0x2061, 0x2061, 0x207c, 0x207c, 0x20ad, 0x20b6, 0x20b6, 0x20d1,
	0x20e6, 0x2101, 0x2101, 0x2101, 0x2113, 0x2125, 0x2125, 0x2125,
	0x2125, 0x2140, 0x2149, 0x215e, 0x216d, 0x2198, 0x21b0, 0x21bf,
	0x21d1, 0x21d1, 0x21d1, 0x21e0, 0x21f8, 0x220d, 0x220d, 0x220d,
	0x2219, 0x2219, 0x222b, 0x2259, 0x227b, 0x227b, 0x2296, 0x229f,
	0x229f, 0x22b1, 0x22b1, 0x22b1, 0x22d0, 0x22ec, 0x2308, 0x232a,
	// Entry 200 - 23F
	0x2342, 0x235a, 0x2382, 0x2391, 0x2391, 0x2391, 0x23a3, 0x23af,
	0x23c7, 0x23c7, 0x23ef, 0x241a, 0x242c, 0x242c, 0x242c, 0x243e,
	0x244a, 0x245c, 0x246b, 0x2480, 0x2489, 0x249e, 0x249e, 0x24b3,
	0x24cb, 0x24cb, 0x24e0, 0x2505, 0x251e, 0x251e, 0x251e, 0x251e,
	0x253c, 0x253c, 0x2551, 0x2563, 0x2575, 0x258d, 0x25bc, 0x25d1,
	0x25ec, 0x2607, 0x2610, 0x2619, 0x2619, 0x2619, 0x2619, 0x2619,
	0x2628, 0x2628, 0x2637, 0x2637, 0x2646, 0x2652, 0x265e, 0x265e,
	0x265e, 0x2673, 0x2673, 0x267f, 0x2688, 0x2697, 0x2697, 0x2697,
	// Entry 240 - 27F
	0x2697, 0x26b2, 0x26ca, 0x26f1, 0x26f1, 0x270c, 0x274a, 0x2759,
	0x2792, 0x27a4, 0x27d0, 0x27fe, 0x282a, 0x286a, 0x2898, 0x28c9,
	0x28fa, 0x2932, 0x295a, 0x2988, 0x29b0, 0x29d5, 0x29ed, 0x2a24,
	0x2a55, 0x2a70, 0x2a9b, 0x2abd, 0x2ae2,
}

// Size: 4364 bytes
const hrLangStr = "" +
	"afarskiabhaskiavestanafrikaansakanskiamharskiaragonskiarapskiasamskiavar" +
	"skiaymaraazerbajdžanskibaškirskibjeloruskibugarskibislamabambarabengalsk" +
	"itibetanskibretonskibosanskikatalonskičečenskichamorrokorzičkicreečeškic" +
	"rkvenoslavenskichuvashvelškidanskinjemačkidivehidzongkhaewegrčkiengleski" +
	"esperantošpanjolskiestonskibaskijskiperzijskifulahfinskifidžijskiferojsk" +
	"ifrancuskizapadnofrizijskiirskiškotski-galskigalicijskiguaranigudžaratsk" +
	"imanskihausahebrejskihindskihiri motuhrvatskikreolskimađarskiarmenskiher" +
	"erointerlinguaindonezijskiinterliguaigbosichuan yiinupiaqidoislandskital" +
	"ijanskiinuktitutjapanskijavanskigruzijskikongokikuyukuanyamakazaškikalaa" +
	"llisutkmerskikannadskikorejskikanurikašmirskikurdskikomikornskikirgiškil" +
	"atinskiluksemburškigandalimburgishlingalalaoskilitavskiluba-katangalatvi" +
	"jskimalgaškimaršalskimaorskimakedonskimalajalamskimongolskimarathskimala" +
	"jskimalteškiburmanskinaurusjeverni ndebelenepalskindonganizozemskinovono" +
	"rveškiknjiževni norveškijužni ndebelenavajonyanjaokcitanskiojibwaoromski" +
	"orijskiosetskipandžapskipalipoljskipaštuportugalskikečuaromanšrundirumun" +
	"jskiruskikinyarwandasanskrtskisardskisindhijužni samisangosinhaleškislov" +
	"ačkislovenskisamoanskishonasomalskialbanskisrpskisvatisesotskisundanskiš" +
	"vedskisvahilitamilskitelugutadžičkitajlandskitigrinjaturkmenskicvanatong" +
	"anskiturskitsongatatarskitahićanskiujgurskiukrajinskiurdskiuzbečkivendav" +
	"ijetnamskivolapükvalonskiwolofxhosajidišjorubazhuangkineskizuluachinesea" +
	"coliadangmeadigejskiafrihiliaghemainuakkadianaleutskijužni altaistaroeng" +
	"leskiangikaaramejskiaraukanskiarapahoarawakasuasturijskiawadhibaluchibal" +
	"inezijskibasabamunskighomalabejabembabenabafutbhojpuribikolbinikomsiksik" +
	"abrajbodoakooseburiatbuginskibulublinmedumbacaddokaripskicayugaatsamcebu" +
	"anochigachibchachagataichuukesemarichinook žargonchoctawchipewyančerokič" +
	"ejenskisoranski kurdskikoptskikrimski turskikašupskidakota jezikdargwata" +
	"itadelavarskislavedogribdinkazarmadogrilužičkosrpskidualanizozemski, sre" +
	"dnjijola-fonyidyuladazagaembuefikstaroegipatskiekajukelamitskiengleski, " +
	"srednjiewondofangfilipinofonfrancuski, srednjistarofrancuskisjevernofriz" +
	"ijskiistočnofrizijskifriulskigagagauskigayogbayastaroetiopskigilbertskin" +
	"jemački, srednji visokistaronjemački, visokigondigorontalogothicgrebosta" +
	"rogrčkišvicarski njemačkigusiigwich’inhaidihavajskihiligaynonhetitskihmo" +
	"nggornjolužičkihupaibanibibioilokoingušetskilojbanngombamachamejudejsko-" +
	"perzijskijudejsko-arapskikara-kalpakkabilskikachinkajekambakawikabardian" +
	"kanembutyapmakondezelenortskikorokhasikhotanesekoyra chiinikakokalenjink" +
	"imbundukomski ili permskikonkaninaurskikpellekarachay-balkarkarelijskiku" +
	"ruškishambalabafiakelnskikumykkutenailadinolangilahndalambalezgiškilakot" +
	"amongoloziluba-lulualuisenolundaluolushailuyiamadurskimafamagahimaithili" +
	"makasarmandingomasajskimabamokshamandarmendemerumauricijski kreolskiirsk" +
	"i, srednjimakhuwa-meettometa’micmacminangkabaumandžurskimanipurskimohawk" +
	"mossimundangviše jezikacreekmirandskimarwarimyenemordvinskinapolitanskin" +
	"amadonjonjemačkinewariniasniujskikwasiongiemboonnogajskistaronorveškin’k" +
	"osjeverni sothonuerklasični newarinyamwezinyankolenyoronzimaosageturski " +
	"- otomanskipangasinanpahlavipampangapapiamentopalauanskistaroperzijskife" +
	"ničkipohnpeianstaroprovansalskikičerajasthanirapa nuirarotonškiromboroms" +
	"kiaromunskirwasandawejakutskisamarijanski aramejskisamburusasaksantaling" +
	"ambaysangusicilijskiškotskisenecasenaselkupskikoyraboro sennistaroirskit" +
	"achelhitshančadski arapskisidamosjeverni samilule samiinari samiskolt sa" +
	"misoninkesogdiensranan tongoserersahosukumasususumerskikomorskikongoansk" +
	"i swahiliklasični sirskisirijskitemnetesoterenotetumtigriškitivtokelauns" +
	"kiklingonskitlingittamasheknyasa tongatok pisintarokotsimshiantumbukatuv" +
	"aluanskitasawaqtuvinianmarokanski tamazightudmurtskiugaritskiumbundukori" +
	"jenskivaivoticvunjowalserwalamowaraywashokalmyksogayaojapskiyangbenyemba" +
	"kantonskizapotecblissymbolszenagastandardni marokanski tamazightzunibez " +
	"jezičnog sadržajazazakimoderni standardni arapskiaustrijski njemačkigorn" +
	"jonjemački (švicarski)australski engleskikanadski engleskibritanski engl" +
	"eskiamerički engleskilatinoamerički španjolskieuropski španjolskimeksičk" +
	"i španjolskikanadski francuskišvicarski francuskiflamanskibrazilski port" +
	"ugalskieuropski portugalskimoldavskisrpsko-hrvatskikineski (pojednostavl" +
	"jeni)kineski (tradicionalni)"

// Size: 1234 bytes, 605 elements
var hrLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0007, 0x000e, 0x0015, 0x001e, 0x0025, 0x002d, 0x0036,
	0x003d, 0x0044, 0x004b, 0x0051, 0x0060, 0x006a, 0x0074, 0x007c,
	0x0083, 0x008a, 0x0093, 0x009d, 0x00a6, 0x00ae, 0x00b8, 0x00c2,
	0x00ca, 0x00d3, 0x00d7, 0x00de, 0x00ee, 0x00f5, 0x00fc, 0x0102,
	0x010b, 0x0111, 0x0119, 0x011c, 0x0122, 0x012a, 0x0133, 0x013e,
	0x0146, 0x014f, 0x0158, 0x015d, 0x0163, 0x016d, 0x0175, 0x017e,
	0x018e, 0x0193, 0x01a2, 0x01ac, 0x01b3, 0x01bf, 0x01c5, 0x01ca,
	0x01d3, 0x01da, 0x01e3, 0x01eb, 0x01f3, 0x01fc, 0x0204, 0x020a,
	// Entry 40 - 7F
	0x0215, 0x0221, 0x022b, 0x022f, 0x0239, 0x0240, 0x0243, 0x024c,
	0x0256, 0x025f, 0x0267, 0x026f, 0x0278, 0x027d, 0x0283, 0x028b,
	0x0293, 0x029e, 0x02a5, 0x02ae, 0x02b6, 0x02bc, 0x02c6, 0x02cd,
	0x02d1, 0x02d8, 0x02e1, 0x02e9, 0x02f6, 0x02fb, 0x0305, 0x030c,
	0x0312, 0x031a, 0x0326, 0x032f, 0x0338, 0x0342, 0x0349, 0x0353,
	0x035f, 0x0368, 0x0371, 0x0379, 0x0382, 0x038b, 0x0390, 0x03a0,
	0x03a8, 0x03ae, 0x03b8, 0x03c5, 0x03d9, 0x03e7, 0x03ed, 0x03f3,
	0x03fd, 0x0403, 0x040a, 0x0411, 0x0418, 0x0423, 0x0427, 0x042e,
	// Entry 80 - BF
	0x0434, 0x043f, 0x0445, 0x044c, 0x0451, 0x045a, 0x045f, 0x046a,
	0x0474, 0x047b, 0x0481, 0x048c, 0x0491, 0x049c, 0x04a5, 0x04ae,
	0x04b7, 0x04bc, 0x04c4, 0x04cc, 0x04d2, 0x04d7, 0x04df, 0x04e8,
	0x04f0, 0x04f7, 0x04ff, 0x0505, 0x050f, 0x0519, 0x0521, 0x052b,
	0x0530, 0x0539, 0x053f, 0x0545, 0x054d, 0x0558, 0x0560, 0x056a,
	0x0570, 0x0578, 0x057d, 0x0588, 0x0590, 0x0598, 0x059d, 0x05a2,
	0x05a8, 0x05ae, 0x05b4, 0x05bb, 0x05bf, 0x05c7, 0x05cc, 0x05d3,
	0x05dc, 0x05dc, 0x05e4, 0x05e9, 0x05ed, 0x05f5, 0x05f5, 0x05fd,
	// Entry C0 - FF
	0x05fd, 0x0609, 0x0616, 0x061c, 0x0625, 0x062f, 0x062f, 0x0636,
	0x0636, 0x063c, 0x063c, 0x063c, 0x063f, 0x063f, 0x0649, 0x0649,
	0x064f, 0x064f, 0x0656, 0x0662, 0x0662, 0x0666, 0x066e, 0x066e,
	0x0675, 0x0679, 0x067e, 0x067e, 0x0682, 0x0687, 0x0687, 0x068f,
	0x0694, 0x0698, 0x0698, 0x069b, 0x06a2, 0x06a2, 0x06a2, 0x06a6,
	0x06a6, 0x06aa, 0x06b0, 0x06b6, 0x06be, 0x06c2, 0x06c6, 0x06cd,
	0x06d2, 0x06da, 0x06e0, 0x06e5, 0x06ec, 0x06f1, 0x06f8, 0x0700,
	0x0708, 0x070c, 0x071b, 0x0722, 0x072b, 0x0732, 0x073b, 0x074b,
	// Entry 100 - 13F
	0x0752, 0x0752, 0x0760, 0x0769, 0x0775, 0x077b, 0x0780, 0x078a,
	0x078f, 0x0795, 0x079a, 0x079f, 0x07a4, 0x07b3, 0x07b3, 0x07b8,
	0x07cb, 0x07d5, 0x07da, 0x07e0, 0x07e4, 0x07e8, 0x07e8, 0x07f6,
	0x07fc, 0x0805, 0x0816, 0x0816, 0x081c, 0x081c, 0x0820, 0x0828,
	0x0828, 0x082b, 0x082b, 0x083d, 0x084b, 0x084b, 0x085c, 0x086d,
	0x0875, 0x0877, 0x087f, 0x087f, 0x0883, 0x0888, 0x0888, 0x0895,
	0x089f, 0x089f, 0x08b8, 0x08ce, 0x08ce, 0x08d3, 0x08dc, 0x08e2,
	0x08e7, 0x08f2, 0x0906, 0x0906, 0x0906, 0x090b, 0x0915, 0x091a,
	// Entry 140 - 17F
	0x091a, 0x0922, 0x0922, 0x092c, 0x0934, 0x0939, 0x0948, 0x0948,
	0x094c, 0x0950, 0x0956, 0x095b, 0x0966, 0x0966, 0x0966, 0x096c,
	0x0972, 0x0979, 0x098b, 0x099b, 0x099b, 0x09a6, 0x09ae, 0x09b4,
	0x09b8, 0x09bd, 0x09c1, 0x09ca, 0x09d1, 0x09d5, 0x09dc, 0x09e7,
	0x09e7, 0x09eb, 0x09eb, 0x09f0, 0x09f9, 0x0a05, 0x0a05, 0x0a05,
	0x0a09, 0x0a11, 0x0a19, 0x0a2b, 0x0a32, 0x0a39, 0x0a3f, 0x0a4e,
	0x0a4e, 0x0a4e, 0x0a58, 0x0a60, 0x0a68, 0x0a6d, 0x0a74, 0x0a79,
	0x0a80, 0x0a86, 0x0a8b, 0x0a91, 0x0a96, 0x0a9f, 0x0a9f, 0x0a9f,
	// Entry 180 - 1BF
	0x0a9f, 0x0aa5, 0x0aa5, 0x0aaa, 0x0aae, 0x0aae, 0x0ab8, 0x0abf,
	0x0ac4, 0x0ac7, 0x0acd, 0x0ad2, 0x0ad2, 0x0ad2, 0x0ada, 0x0ade,
	0x0ae4, 0x0aec, 0x0af3, 0x0afb, 0x0b03, 0x0b07, 0x0b0d, 0x0b13,
	0x0b18, 0x0b1c, 0x0b30, 0x0b3e, 0x0b4c, 0x0b53, 0x0b59, 0x0b64,
	0x0b6f, 0x0b79, 0x0b7f, 0x0b84, 0x0b84, 0x0b8b, 0x0b97, 0x0b9c,
	0x0ba5, 0x0bac, 0x0bac, 0x0bb1, 0x0bbb, 0x0bbb, 0x0bbb, 0x0bc7,
	0x0bcb, 0x0bd9, 0x0bdf, 0x0be3, 0x0bea, 0x0bea, 0x0bf0, 0x0bf9,
	0x0c01, 0x0c0f, 0x0c0f, 0x0c15, 0x0c23, 0x0c27, 0x0c37, 0x0c3f,
	// Entry 1C0 - 1FF
	0x0c47, 0x0c4c, 0x0c51, 0x0c56, 0x0c68, 0x0c72, 0x0c79, 0x0c81,
	0x0c8b, 0x0c95, 0x0c95, 0x0c95, 0x0c95, 0x0ca3, 0x0ca3, 0x0cab,
	0x0cab, 0x0cab, 0x0cb4, 0x0cb4, 0x0cc5, 0x0cca, 0x0cca, 0x0cd4,
	0x0cdc, 0x0ce7, 0x0ce7, 0x0ce7, 0x0cec, 0x0cf2, 0x0cf2, 0x0cf2,
	0x0cf2, 0x0cfb, 0x0cfe, 0x0d05, 0x0d0d, 0x0d23, 0x0d2a, 0x0d2f,
	0x0d36, 0x0d36, 0x0d3d, 0x0d42, 0x0d4c, 0x0d54, 0x0d54, 0x0d5a,
	0x0d5e, 0x0d5e, 0x0d67, 0x0d76, 0x0d80, 0x0d80, 0x0d89, 0x0d8d,
	0x0d9c, 0x0da2, 0x0da2, 0x0da2, 0x0daf, 0x0db8, 0x0dc2, 0x0dcc,
	// Entry 200 - 23F
	0x0dd3, 0x0dda, 0x0de6, 0x0deb, 0x0def, 0x0def, 0x0df5, 0x0df9,
	0x0e01, 0x0e09, 0x0e1b, 0x0e2b, 0x0e33, 0x0e33, 0x0e33, 0x0e38,
	0x0e3c, 0x0e42, 0x0e47, 0x0e50, 0x0e53, 0x0e5e, 0x0e5e, 0x0e68,
	0x0e6f, 0x0e6f, 0x0e77, 0x0e82, 0x0e8b, 0x0e8b, 0x0e91, 0x0e91,
	0x0e9a, 0x0e9a, 0x0ea1, 0x0eac, 0x0eb3, 0x0ebb, 0x0ecf, 0x0ed8,
	0x0ee1, 0x0ee8, 0x0ef2, 0x0ef5, 0x0ef5, 0x0ef5, 0x0ef5, 0x0ef5,
	0x0efa, 0x0efa, 0x0eff, 0x0f05, 0x0f0b, 0x0f10, 0x0f15, 0x0f15,
	0x0f15, 0x0f1b, 0x0f1b, 0x0f1f, 0x0f22, 0x0f28, 0x0f2f, 0x0f34,
	// Entry 240 - 27F
	0x0f34, 0x0f3d, 0x0f44, 0x0f4f, 0x0f4f, 0x0f55, 0x0f74, 0x0f78,
	0x0f8f, 0x0f95, 0x0faf, 0x0fc3, 0x0fdf, 0x0ff2, 0x1003, 0x1015,
	0x1027, 0x1042, 0x1056, 0x106b, 0x107d, 0x1091, 0x109a, 0x10af,
	0x10c3, 0x10cc, 0x10db, 0x10f5, 0x110c,
}

// Size: 3870 bytes
const huLangStr = "" +
	"afarabházavesztánafrikaansakanamharaaragonézarabasszámiavarajmaraazerbaj" +
	"dzsánibaskírbeloruszbolgárbislamabambarabengálitibetibretonbosnyákkatalá" +
	"ncsecsencsamorókorzikaikrícsehegyházi szlávcsuvaswalesidánnémetdivehibut" +
	"ánievegörögangoleszperantóspanyolésztbaszkperzsafulanifinnfidzsiferöeri" +
	"franciafrízírskót gaelgalíciaiguaranigudzsaratiman-szigetihauszahéberhin" +
	"dihiri motuhorváthaitimagyarörményhererointerlingvaindonézinterlingueigb" +
	"ószecsuán jiinupiakidóizlandiolaszinuktitutjapánjávaigrúzkongokikujukua" +
	"nyamakazahgrönlandikambodzsaikannadakoreaikanurikásmírikurdkomikornikirg" +
	"izlatinluxemburgigandalimburgilingalalaoszilitvánluba-katangalettmálgasm" +
	"arshallimaorimacedónmalajálammongolmarathimalájmáltaiburmainauruiészaki " +
	"ndebelenepálindongahollandnorvég nynorsknorvég bokmaldéli ndebelenavahón" +
	"yanjaokszitánojibvaoromóiorijaoszétpandzsábipalilengyelpastuportugálkecs" +
	"uaréto-románkirundirománoroszkiruandaszanszkritszardíniaiszindhiészaki s" +
	"zámiszangószingalézszlovákszlovénszamoaisonaszomáliaialbánszerbsziszuati" +
	"szeszotószundanézsvédszuahélitamiltelugutadzsikthaitigrinjatürkménszecsu" +
	"ánitongatörökcongatatártahitiujgurukránurduüzbégvendavietnamivolapükval" +
	"lonvolofhoszajiddisjorubazsuangkínaizuluachinézakoliadangmeadygheafrihil" +
	"iagemainuakkádaleutdél-altajióangolangikaarámiaraucaniarapahoaravakasuas" +
	"ztúrawádibalucsibalinézbaszabamungomalabedzsabembabenabafutbodzspuribiko" +
	"lbinikomsiksikabrajbodokosziburjátbuginézbulublinmedumbacaddokaribkajuga" +
	"atszamcebuikigacsibcsacsagatájcsukézmaricsinuk zsargoncsoktócsipevécsero" +
	"kicsejenszoráni kurdkoptkrími tatárkasubdakotadargvataitadelavárszlevido" +
	"gribdinkazarmadogrialsó szorbdualaközép hollandjola-fonyidiuladazagaembu" +
	"efikóegyiptomiekadzsukelamitközép angolevondofangfilippínófonközép franc" +
	"iaófranciaészaki frízkeleti frízfriuligagagauzgajogbajageezikiribatiközé" +
	"p felső németófelső németgondigorontalogótgrebóógörögsvájci németgusziig" +
	"vicsinhaidahawaiihiligajnonhittitehmongfelső szorbhupaibanibibióilokóing" +
	"uslojbanngombamachamezsidó-perzsazsidó-arabkara-kalpakkabijekacsinjjukam" +
	"bakawikabardikanembutyapmakondekabuverdianukorokaszikotanézkojra-csínika" +
	"kókalendzsinkimbundukomi-permjákkonkanikosreikpellekaracsáj-balkárkarela" +
	"ikuruhsambalabafiakölschkumükkutenailadinolangilahndalambalezglakotamong" +
	"óloziluba-lulualuisenolundaluolushailujiamaduraimafamagahimaithilimakas" +
	"zarmandingómasaimabamoksánmandarmendemerumauritiusi kreolközép írmakua-m" +
	"etómeta’mikmakminangkabaumandzsumanipurimohawkmoszimundangtöbbszörös nye" +
	"lvekkríkmirandézmarvarimyeneerzjánynápolyinamaalsónémetnevariniasniuingu" +
	"mbangiemboonnogajóskandinávn’kóészaki szotónuerklasszikus newarinyamvézi" +
	"nyankolenyorónzimaosageottomán törökpangaszinanpahlavipampanganpapiament" +
	"ópalauióperzsafőniciaipohnpeióprovánszikicseradzsasztánirapanuirarotong" +
	"airomboromaarománrwoszandavejakutszamaritánus arámiszamburusasakszantáli" +
	"ngambayszanguszicíliaiskótszenekaszenaszölkupkojra-szennióírtachelhitsan" +
	"csádi arabszidamódéli számilule számiinar samikoltta lappszoninkesogdien" +
	"szranai tongószererszahószukumaszuszusumércomoreikongói szuahéliklasszik" +
	"us szírszíriaitemneteszóterenótetumtigrétivtokelauiklingontlingittamasek" +
	"nyasa tongatok pisintarokócsimsiánitumbukatuvaluszaváktuvaiközép-marokkó" +
	"i tamazigtudmurtugaritiumbunduősivaivotjákvunjowalservalamovaraóvasókalm" +
	"ükszogajaójapijangbenjembakantonizapotékBliss jelképrendszerzenagamarok" +
	"kói tamazightzuninincs nyelvészeti tartalomzazamodern szabányos araboszt" +
	"rák németsvájci felnémetausztrál angolkanadai angolbrit angolamerikai an" +
	"gollatin-amerikai spanyoleurópai spanyolspanyol (mexikói)kanadai francia" +
	"svájci franciaflamandbrazíliai portugáleurópai portugálmoldvaiszerbhorvá" +
	"tegyszerűsített kínaihagyományos kínai"

// Size: 1234 bytes, 605 elements
var huLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000a, 0x0013, 0x001c, 0x0020, 0x0026, 0x002f,
	0x0033, 0x003b, 0x003f, 0x0045, 0x0053, 0x005a, 0x0062, 0x0069,
	0x0070, 0x0077, 0x007f, 0x0085, 0x008b, 0x0093, 0x009b, 0x00a2,
	0x00aa, 0x00b2, 0x00b6, 0x00ba, 0x00c9, 0x00cf, 0x00d5, 0x00d9,
	0x00df, 0x00e5, 0x00ec, 0x00ef, 0x00f6, 0x00fb, 0x0106, 0x010d,
	0x0112, 0x0117, 0x011d, 0x0123, 0x0127, 0x012d, 0x0135, 0x013c,
	0x0141, 0x0144, 0x014e, 0x0157, 0x015e, 0x0168, 0x0173, 0x0179,
	0x017f, 0x0184, 0x018d, 0x0194, 0x0199, 0x019f, 0x01a7, 0x01ad,
	// Entry 40 - 7F
	0x01b8, 0x01c0, 0x01cb, 0x01d0, 0x01dc, 0x01e3, 0x01e7, 0x01ee,
	0x01f3, 0x01fc, 0x0202, 0x0208, 0x020d, 0x0212, 0x0218, 0x0220,
	0x0225, 0x022f, 0x0239, 0x0240, 0x0246, 0x024c, 0x0255, 0x0259,
	0x025d, 0x0262, 0x0268, 0x026d, 0x0277, 0x027c, 0x0284, 0x028b,
	0x0291, 0x0298, 0x02a4, 0x02a8, 0x02af, 0x02b8, 0x02bd, 0x02c5,
	0x02cf, 0x02d5, 0x02dc, 0x02e2, 0x02e9, 0x02ef, 0x02f5, 0x0304,
	0x030b, 0x0311, 0x0318, 0x0327, 0x0335, 0x0342, 0x0349, 0x034f,
	0x0358, 0x035e, 0x0365, 0x036a, 0x0370, 0x037a, 0x037e, 0x0385,
	// Entry 80 - BF
	0x038a, 0x0393, 0x0399, 0x03a5, 0x03ac, 0x03b2, 0x03b7, 0x03bf,
	0x03c9, 0x03d4, 0x03db, 0x03e9, 0x03f0, 0x03fa, 0x0402, 0x040a,
	0x0411, 0x0415, 0x041f, 0x0425, 0x042a, 0x0433, 0x043c, 0x0446,
	0x044b, 0x0454, 0x0459, 0x045f, 0x0466, 0x046a, 0x0472, 0x047b,
	0x0485, 0x048a, 0x0491, 0x0496, 0x049c, 0x04a2, 0x04a7, 0x04ad,
	0x04b1, 0x04b8, 0x04bd, 0x04c5, 0x04cd, 0x04d3, 0x04d8, 0x04dd,
	0x04e3, 0x04e9, 0x04ef, 0x04f5, 0x04f9, 0x0501, 0x0506, 0x050d,
	0x0513, 0x0513, 0x051b, 0x051f, 0x0523, 0x0529, 0x0529, 0x052e,
	// Entry C0 - FF
	0x052e, 0x0539, 0x0540, 0x0546, 0x054c, 0x0554, 0x0554, 0x055b,
	0x055b, 0x0561, 0x0561, 0x0561, 0x0564, 0x0564, 0x056b, 0x056b,
	0x0571, 0x0571, 0x0578, 0x0580, 0x0580, 0x0585, 0x058a, 0x058a,
	0x0590, 0x0596, 0x059b, 0x059b, 0x059f, 0x05a4, 0x05a4, 0x05ad,
	0x05b2, 0x05b6, 0x05b6, 0x05b9, 0x05c0, 0x05c0, 0x05c0, 0x05c4,
	0x05c4, 0x05c8, 0x05cd, 0x05d4, 0x05dc, 0x05e0, 0x05e4, 0x05eb,
	0x05f0, 0x05f5, 0x05fb, 0x0601, 0x0606, 0x060a, 0x0611, 0x061a,
	0x0621, 0x0625, 0x0633, 0x063a, 0x0642, 0x0649, 0x064f, 0x065c,
	// Entry 100 - 13F
	0x0660, 0x0660, 0x066d, 0x0672, 0x0678, 0x067e, 0x0683, 0x068b,
	0x0691, 0x0697, 0x069c, 0x06a1, 0x06a6, 0x06b1, 0x06b1, 0x06b6,
	0x06c5, 0x06cf, 0x06d4, 0x06da, 0x06de, 0x06e2, 0x06e2, 0x06ed,
	0x06f5, 0x06fb, 0x0708, 0x0708, 0x070e, 0x070e, 0x0712, 0x071d,
	0x071d, 0x0720, 0x0720, 0x072f, 0x0738, 0x0738, 0x0745, 0x0751,
	0x0757, 0x0759, 0x075f, 0x075f, 0x0763, 0x0768, 0x0768, 0x076c,
	0x0775, 0x0775, 0x078a, 0x0799, 0x0799, 0x079e, 0x07a7, 0x07ab,
	0x07b1, 0x07ba, 0x07c8, 0x07c8, 0x07c8, 0x07ce, 0x07d5, 0x07da,
	// Entry 140 - 17F
	0x07da, 0x07e0, 0x07e0, 0x07ea, 0x07f1, 0x07f6, 0x0802, 0x0802,
	0x0806, 0x080a, 0x0811, 0x0817, 0x081c, 0x081c, 0x081c, 0x0822,
	0x0828, 0x082f, 0x083c, 0x0847, 0x0847, 0x0852, 0x0858, 0x085e,
	0x0861, 0x0866, 0x086a, 0x0871, 0x0878, 0x087c, 0x0883, 0x088f,
	0x088f, 0x0893, 0x0893, 0x0898, 0x08a0, 0x08ac, 0x08ac, 0x08ac,
	0x08b1, 0x08bb, 0x08c3, 0x08d0, 0x08d7, 0x08dd, 0x08e3, 0x08f4,
	0x08f4, 0x08f4, 0x08fb, 0x0900, 0x0907, 0x090c, 0x0913, 0x0919,
	0x0920, 0x0926, 0x092b, 0x0931, 0x0936, 0x093a, 0x093a, 0x093a,
	// Entry 180 - 1BF
	0x093a, 0x0940, 0x0940, 0x0946, 0x094a, 0x094a, 0x0954, 0x095b,
	0x0960, 0x0963, 0x0969, 0x096e, 0x096e, 0x096e, 0x0975, 0x0979,
	0x097f, 0x0987, 0x098f, 0x0998, 0x099d, 0x09a1, 0x09a8, 0x09ae,
	0x09b3, 0x09b7, 0x09c7, 0x09d2, 0x09dd, 0x09e4, 0x09ea, 0x09f5,
	0x09fc, 0x0a04, 0x0a0a, 0x0a0f, 0x0a0f, 0x0a16, 0x0a2b, 0x0a30,
	0x0a39, 0x0a40, 0x0a40, 0x0a45, 0x0a4d, 0x0a4d, 0x0a4d, 0x0a55,
	0x0a59, 0x0a64, 0x0a6a, 0x0a6e, 0x0a72, 0x0a72, 0x0a78, 0x0a81,
	0x0a86, 0x0a92, 0x0a92, 0x0a99, 0x0aa7, 0x0aab, 0x0abc, 0x0ac5,
	// Entry 1C0 - 1FF
	0x0acd, 0x0ad3, 0x0ad8, 0x0add, 0x0aed, 0x0af8, 0x0aff, 0x0b08,
	0x0b13, 0x0b19, 0x0b19, 0x0b19, 0x0b19, 0x0b21, 0x0b21, 0x0b2a,
	0x0b2a, 0x0b2a, 0x0b31, 0x0b31, 0x0b3d, 0x0b42, 0x0b42, 0x0b4f,
	0x0b56, 0x0b60, 0x0b60, 0x0b60, 0x0b65, 0x0b69, 0x0b69, 0x0b69,
	0x0b69, 0x0b70, 0x0b73, 0x0b7b, 0x0b80, 0x0b94, 0x0b9c, 0x0ba1,
	0x0baa, 0x0baa, 0x0bb1, 0x0bb7, 0x0bc1, 0x0bc6, 0x0bc6, 0x0bcd,
	0x0bd2, 0x0bd2, 0x0bda, 0x0be6, 0x0beb, 0x0beb, 0x0bf4, 0x0bf7,
	0x0c02, 0x0c0a, 0x0c0a, 0x0c0a, 0x0c16, 0x0c21, 0x0c2a, 0x0c35,
	// Entry 200 - 23F
	0x0c3d, 0x0c44, 0x0c52, 0x0c58, 0x0c5e, 0x0c5e, 0x0c65, 0x0c6b,
	0x0c71, 0x0c78, 0x0c89, 0x0c99, 0x0ca1, 0x0ca1, 0x0ca1, 0x0ca6,
	0x0cac, 0x0cb3, 0x0cb8, 0x0cbe, 0x0cc1, 0x0cc9, 0x0cc9, 0x0cd0,
	0x0cd7, 0x0cd7, 0x0cde, 0x0ce9, 0x0cf2, 0x0cf2, 0x0cf9, 0x0cf9,
	0x0d03, 0x0d03, 0x0d0a, 0x0d10, 0x0d17, 0x0d1c, 0x0d36, 0x0d3c,
	0x0d43, 0x0d4a, 0x0d4e, 0x0d51, 0x0d51, 0x0d51, 0x0d51, 0x0d51,
	0x0d58, 0x0d58, 0x0d5d, 0x0d63, 0x0d69, 0x0d6f, 0x0d74, 0x0d74,
	0x0d74, 0x0d7b, 0x0d7b, 0x0d80, 0x0d84, 0x0d88, 0x0d8f, 0x0d94,
	// Entry 240 - 27F
	0x0d94, 0x0d9b, 0x0da3, 0x0db8, 0x0db8, 0x0dbe, 0x0dd1, 0x0dd5,
	0x0df0, 0x0df4, 0x0e0a, 0x0e19, 0x0e2a, 0x0e39, 0x0e46, 0x0e50,
	0x0e5e, 0x0e74, 0x0e84, 0x0e96, 0x0ea5, 0x0eb4, 0x0ebb, 0x0ecf,
	0x0ee1, 0x0ee8, 0x0ef4, 0x0f0b, 0x0f1e,
}

// Size: 4247 bytes
const hyLangStr = "" +
	"աբխազերենաֆրիկաանսաքաներենամհարերենարաբերենասամերենադրբեջաներենբաշկիրերե" +
	"նբելառուսերենբուլղարերենբամբարաբենգալերենտիբեթերենբրետոներենբոսնիերենկա" +
	"տալաներենկորսիկերենչեխերենուելսերենդանիերենգերմաներենջոնգքհաէվեհունարեն" +
	"անգլերենէսպերանտոիսպաներենէստոներենբասկերենպարսկերենֆիններենֆիջիերենֆար" +
	"յորերենֆրանսերենարևմտյան ֆրիզերենիռլանդերենգալիսերենգուարանիգուջարաթիմե" +
	"ներենհաուսաեբրայերենհինդիխորվաթերենհաիթերենհունգարերենհայերենինդոնեզերե" +
	"նիգբոսիխուան յիիսլանդերենիտալերենինուկտիտուտճապոներենճավայերենվրացերենկ" +
	"իկույուղազախերենկալաալիսուտքմերերենկաննադակորեերենքաշմիրերենքրդերենկոռն" +
	"երենղրղզերենլատիներենլյուքսեմբուրգերենգանդալինգալալաոսերենլիտվերենլուբա" +
	"-կատանգալատվիերենմալագասերենմաորիմակեդոներենմալայալամմոնղոլերենմարաթիմալ" +
	"այերենմալթերենբիրմայերենհյուսիսային նդեբելենեպալերենհոլանդերեննորվեգերե" +
	"ն նյունորսկնորվեգերեն բուկմոլօրոմոօրիյափենջաբերենլեհերենփուշթուպորտուգա" +
	"լերենքեչուառոմանշերենռունդիռումիներենռուսերենքինյարվանդասանսկրիտսինդհիհ" +
	"յուսիսային սամիսանգոսինհալերենսլովակերենսլովեներենշոնասոմալիերենալբաներ" +
	"ենսերբերենսունդաներենշվեդերենսուահիլիթամիլերենթելուգուտաջիկերենթայերենթ" +
	"իգրինիաթուրքմեներենտոնգաթուրքերենթաթարերենույղուրերենուկրաիներենուրդուո" +
	"ւզբեկերենվիետնամերենվոլոֆքսոզայորուբաչինարենզուլուսերենաղեմմապուչիասուբ" +
	"եմբաբենաբոդոչիգաշերոկիսորանի (քրդերեն)թաիթազարմաստորին սորբիերենդուալաջ" +
	"ոլա-ֆոնյիէմբուֆիլիպիներենգագաուզերենշվեյցարական գերմաներենգուսիհավայիեր" +
	"ենվերին սորբիերեննգոմբամաշամեկաբիլերենկամբամակոնդեկուբավերդիանուկոյրա չ" +
	"ինիկալենջինկոմի-պերմյակկոնկանիշամբալաբաֆիալանգիլակոտալուոլույամասաիմերո" +
	"ւմորիսյենմաքուա-մետտոմետամոհավքմունդանգնամակվասիոնկոնուերնյանկոլեկիչեռո" +
	"մբոռվասամբուրուսանգուսենակոյրաբորո սեննիտաշելհիթհարավային սամիլուլե սամ" +
	"իինարի սամիսկոլտ սամիկոնգոյի սուահիլիտեսոտասավաքկենտրոնատլասյան թամազիխ" +
	"տանհայտ լեզուվաիվունջոսոգաստանդարտ մարոկական թամազիղտառանց լեզվային բով" +
	"անդակությանժամանակակից ստանդարտ արաբերենավստրիական գերմաներենշվեյցարակա" +
	"ն բարձր գերմաներենավստրալական անգլերենկանադական անգլերենբրիտանական անգլ" +
	"երենամերիկյան անգլերենլատինաամերիկյան իսպաներենեվրոպական իսպաներենմեքսի" +
	"կական իսպաներենկանադական ֆրանսերենշվեյցարական ֆրանսերենֆլամանդերենբրազի" +
	"լական պորտուգալերենեվրոպական պորտուգալերենմոլդովերենպարզեցված չինարենավ" +
	"անդական չինարեն"

// Size: 1234 bytes, 605 elements
var hyLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0000, 0x0012, 0x0012, 0x0024, 0x0034, 0x0046, 0x0046,
	0x0056, 0x0066, 0x0066, 0x0066, 0x007e, 0x0092, 0x00aa, 0x00c0,
	0x00c0, 0x00ce, 0x00e2, 0x00f4, 0x0108, 0x011a, 0x0130, 0x0130,
	0x0130, 0x0144, 0x0144, 0x0152, 0x0152, 0x0152, 0x0164, 0x0174,
	0x0188, 0x0188, 0x0196, 0x019c, 0x01ac, 0x01bc, 0x01ce, 0x01e0,
	0x01f2, 0x0202, 0x0214, 0x0214, 0x0224, 0x0234, 0x0248, 0x025a,
	0x027b, 0x028f, 0x028f, 0x02a1, 0x02b1, 0x02c3, 0x02d1, 0x02dd,
	0x02ef, 0x02f9, 0x02f9, 0x030d, 0x031d, 0x0333, 0x0341, 0x0341,
	// Entry 40 - 7F
	0x0341, 0x0357, 0x0357, 0x035f, 0x0372, 0x0372, 0x0372, 0x0386,
	0x0396, 0x03ac, 0x03be, 0x03d0, 0x03e0, 0x03e0, 0x03f0, 0x03f0,
	0x0402, 0x0418, 0x0428, 0x0436, 0x0446, 0x0446, 0x045a, 0x0468,
	0x0468, 0x0478, 0x0488, 0x049a, 0x04bc, 0x04c6, 0x04c6, 0x04d4,
	0x04e4, 0x04f4, 0x050d, 0x051f, 0x0535, 0x0535, 0x053f, 0x0555,
	0x0567, 0x057b, 0x0587, 0x0599, 0x05a9, 0x05bd, 0x05bd, 0x05e2,
	0x05f4, 0x05f4, 0x0608, 0x062f, 0x0652, 0x0652, 0x0652, 0x0652,
	0x0652, 0x0652, 0x065c, 0x0666, 0x0666, 0x067a, 0x067a, 0x0688,
	// Entry 80 - BF
	0x0696, 0x06b0, 0x06bc, 0x06d0, 0x06dc, 0x06f0, 0x0700, 0x0716,
	0x0726, 0x0726, 0x0732, 0x0751, 0x075b, 0x076f, 0x0783, 0x0797,
	0x0797, 0x079f, 0x07b3, 0x07c5, 0x07d5, 0x07d5, 0x07d5, 0x07eb,
	0x07fb, 0x080b, 0x081d, 0x082d, 0x083f, 0x084d, 0x085d, 0x0875,
	0x0875, 0x087f, 0x0891, 0x0891, 0x08a3, 0x08a3, 0x08b9, 0x08cf,
	0x08db, 0x08ef, 0x08ef, 0x0905, 0x0905, 0x0905, 0x090f, 0x0919,
	0x0919, 0x0927, 0x0927, 0x0935, 0x094b, 0x094b, 0x094b, 0x094b,
	0x094b, 0x094b, 0x094b, 0x0953, 0x0953, 0x0953, 0x0953, 0x0953,
	// Entry C0 - FF
	0x0953, 0x0953, 0x0953, 0x0953, 0x0953, 0x0961, 0x0961, 0x0961,
	0x0961, 0x0961, 0x0961, 0x0961, 0x0969, 0x0969, 0x0969, 0x0969,
	0x0969, 0x0969, 0x0969, 0x0969, 0x0969, 0x0969, 0x0969, 0x0969,
	0x0969, 0x0969, 0x0973, 0x0973, 0x097b, 0x097b, 0x097b, 0x097b,
	0x097b, 0x097b, 0x097b, 0x097b, 0x097b, 0x097b, 0x097b, 0x097b,
	0x097b, 0x0983, 0x0983, 0x0983, 0x0983, 0x0983, 0x0983, 0x0983,
	0x0983, 0x0983, 0x0983, 0x0983, 0x0983, 0x098b, 0x098b, 0x098b,
	0x098b, 0x098b, 0x098b, 0x098b, 0x098b, 0x0997, 0x0997, 0x09b4,
	// Entry 100 - 13F
	0x09b4, 0x09b4, 0x09b4, 0x09b4, 0x09b4, 0x09b4, 0x09be, 0x09be,
	0x09be, 0x09be, 0x09be, 0x09c8, 0x09c8, 0x09e7, 0x09e7, 0x09f3,
	0x09f3, 0x0a06, 0x0a06, 0x0a06, 0x0a10, 0x0a10, 0x0a10, 0x0a10,
	0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a26,
	0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a26, 0x0a26,
	0x0a26, 0x0a26, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c,
	0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c,
	0x0a3c, 0x0a3c, 0x0a67, 0x0a67, 0x0a67, 0x0a71, 0x0a71, 0x0a71,
	// Entry 140 - 17F
	0x0a71, 0x0a85, 0x0a85, 0x0a85, 0x0a85, 0x0a85, 0x0aa2, 0x0aa2,
	0x0aa2, 0x0aa2, 0x0aa2, 0x0aa2, 0x0aa2, 0x0aa2, 0x0aa2, 0x0aa2,
	0x0aae, 0x0aba, 0x0aba, 0x0aba, 0x0aba, 0x0aba, 0x0acc, 0x0acc,
	0x0acc, 0x0ad6, 0x0ad6, 0x0ad6, 0x0ad6, 0x0ad6, 0x0ae4, 0x0b00,
	0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b13, 0x0b13, 0x0b13,
	0x0b13, 0x0b23, 0x0b23, 0x0b3a, 0x0b48, 0x0b48, 0x0b48, 0x0b48,
	0x0b48, 0x0b48, 0x0b48, 0x0b48, 0x0b56, 0x0b60, 0x0b60, 0x0b60,
	0x0b60, 0x0b60, 0x0b6a, 0x0b6a, 0x0b6a, 0x0b6a, 0x0b6a, 0x0b6a,
	// Entry 180 - 1BF
	0x0b6a, 0x0b76, 0x0b76, 0x0b76, 0x0b76, 0x0b76, 0x0b76, 0x0b76,
	0x0b76, 0x0b7e, 0x0b7e, 0x0b88, 0x0b88, 0x0b88, 0x0b88, 0x0b88,
	0x0b88, 0x0b88, 0x0b88, 0x0b88, 0x0b92, 0x0b92, 0x0b92, 0x0b92,
	0x0b92, 0x0b9c, 0x0bac, 0x0bac, 0x0bc3, 0x0bcb, 0x0bcb, 0x0bcb,
	0x0bcb, 0x0bcb, 0x0bd7, 0x0bd7, 0x0bd7, 0x0be7, 0x0be7, 0x0be7,
	0x0be7, 0x0be7, 0x0be7, 0x0be7, 0x0be7, 0x0be7, 0x0be7, 0x0be7,
	0x0bef, 0x0bef, 0x0bef, 0x0bef, 0x0bef, 0x0bef, 0x0bfb, 0x0bfb,
	0x0bfb, 0x0bfb, 0x0bfb, 0x0c01, 0x0c01, 0x0c0b, 0x0c0b, 0x0c0b,
	// Entry 1C0 - 1FF
	0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b,
	0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b,
	0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c1b, 0x0c23, 0x0c23, 0x0c23,
	0x0c23, 0x0c23, 0x0c23, 0x0c23, 0x0c2d, 0x0c2d, 0x0c2d, 0x0c2d,
	0x0c2d, 0x0c2d, 0x0c33, 0x0c33, 0x0c33, 0x0c33, 0x0c45, 0x0c45,
	0x0c45, 0x0c45, 0x0c45, 0x0c51, 0x0c51, 0x0c51, 0x0c51, 0x0c51,
	0x0c59, 0x0c59, 0x0c59, 0x0c76, 0x0c76, 0x0c76, 0x0c86, 0x0c86,
	0x0c86, 0x0c86, 0x0c86, 0x0c86, 0x0ca1, 0x0cb4, 0x0cc7, 0x0cda,
	// Entry 200 - 23F
	0x0cda, 0x0cda, 0x0cda, 0x0cda, 0x0cda, 0x0cda, 0x0cda, 0x0cda,
	0x0cda, 0x0cda, 0x0cf9, 0x0cf9, 0x0cf9, 0x0cf9, 0x0cf9, 0x0cf9,
	0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01,
	0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d01,
	0x0d01, 0x0d01, 0x0d01, 0x0d01, 0x0d0f, 0x0d0f, 0x0d3e, 0x0d3e,
	0x0d3e, 0x0d3e, 0x0d55, 0x0d5b, 0x0d5b, 0x0d5b, 0x0d5b, 0x0d5b,
	0x0d5b, 0x0d5b, 0x0d67, 0x0d67, 0x0d67, 0x0d67, 0x0d67, 0x0d67,
	0x0d67, 0x0d67, 0x0d67, 0x0d6f, 0x0d6f, 0x0d6f, 0x0d6f, 0x0d6f,
	// Entry 240 - 27F
	0x0d6f, 0x0d6f, 0x0d6f, 0x0d6f, 0x0d6f, 0x0d6f, 0x0da3, 0x0da3,
	0x0ddb, 0x0ddb, 0x0e13, 0x0e3c, 0x0e72, 0x0e99, 0x0ebc, 0x0ee1,
	0x0f04, 0x0f35, 0x0f5a, 0x0f81, 0x0fa6, 0x0fcf, 0x0fe5, 0x1014,
	0x1041, 0x1055, 0x1055, 0x1076, 0x1097,
}

// Size: 4032 bytes
const idLangStr = "" +
	"AfarAbkhazAvestaAfrikaansAkanAmharikAragonArabAssamAvarAymaraAzerbaijanB" +
	"ashkirBelarusiaBulgarBislamaBambaraBengaliTibetBretonBosniaKatalanCheche" +
	"nChamorroKorsikaKreeCheskaBahasa Gereja SlavoniaChuvashWelshDanskJermanD" +
	"ivehiDzongkhaEweYunaniInggrisEsperantoSpanyolEstiBaskPersiaFulaSuomiFiji" +
	"FaroPrancisFrisia BaratIrlandiaGaelik SkotlandiaGalisiaGuaraniGujaratiMa" +
	"nxHausaIbraniHindiHiri MotuKroasiaHaitiHungariaArmeniaHereroInterlinguaB" +
	"ahasa IndonesiaInterlingueIgboSichuan YiInupiakIdoIslandiaItaliaInuktitu" +
	"tJepangJawaGeorgiaKongoKikuyuKuanyamaKazakhKalaallisutKhmerKannadaKoreaK" +
	"anuriKashmirKurdiKomiKornishKirgizLatinLuksemburgGandaLimburgiaLingalaLa" +
	"oLituaviLuba-KatangaLatviMalagasiMarshallMaoriMakedoniaMalayalamMongolia" +
	"MarathiMelayuMaltaBurmaNauruNdebele UtaraNepaliNdongaBelandaNynorsk Norw" +
	"egiaBokmål NorwegiaNdebele SelatanNavajoNyanjaOsitaniaOjibwaOromoOriyaOs" +
	"setiaPunjabiPaliPolskiPashtoPortugisQuechuaReto-RomanRundiRumaniaRusiaKi" +
	"nyarwandaSanskertaSardiniaSindhiSami UtaraSangoSinhalaSlovakSlovenSamoaS" +
	"honaSomaliAlbaniaSerbSwatiSotho SelatanSundaSwediaSwahiliTamilTeluguTaji" +
	"kThaiTigrinyaTurkmenTswanaTongaTurkiTsongaTatarTahitiUyghurUkrainaUrduUz" +
	"bekVendaVietnamVolapukWalloonWolofXhosaYiddishYorubaZhuangChinaZuluAcehA" +
	"coliAdangmeAdygeiArab TunisiaAfrihiliAghemAinuAkkadiaAlabamaAleutAltai S" +
	"elatanInggris KunoAngikaAramAraukanArapahoArab AlgeriaArawakArab MarokoA" +
	"rab MesirAsuBahasa Isyarat AmerikaAsturAwadhiAzerbaijani SelatanBaluchiB" +
	"aliBavariaBasaBamunBatak TobaGhomalaBejaBembaBetawiBenaBafutBhojpuriBiko" +
	"lBiniBanjarKomSiksikaBrajBodoAkooseBuriatBugisBuluBlinMedumbaKadoKaribCa" +
	"yugaAtsamSebuanoKigaChibchaChagataiChuukeMariJargon ChinookKoktawChipewy" +
	"anCherokeeCheyenneKurdi SoraniKoptikTatar KrimeaKashubiaDakotaDargwaTait" +
	"aDelawareSlaveDogribDinkaZarmaDogriSorbia RendahDualaBelanda TengahJola-" +
	"FonyiDyulaDazagaEmbuEfikMesir KunoEkajukElamInggris Abad PertengahanEwon" +
	"doFangFilipinoFonPrancis Abad PertengahanPrancis KunoArpitanFrisia Utara" +
	"Frisia TimurFriuliGaGagauzGayoGbayaGeezGilbertGilakiJerman Abad Pertenga" +
	"hanJerman KunoGondiGorontaloGothikGreboYunani KunoJerman SwissGusiiGwich" +
	"’inHaidaHawaiiHindi FijiHiligaynonHititHmongSorbia AtasHupaIbanIbibioI" +
	"lokoIngushetiaLojbanNgombaMachameIbrani-PersiaIbrani-ArabKara-KalpakKaby" +
	"leKachinJjuKambaKawiKabardiKanembuTyapMakondeKabuverdianuKenyangKoroKhas" +
	"iKhotanKoyra ChiiniKakoKalenjinKimbunduKomi-PermyakKonkaniKosreKpelleKar" +
	"achai BalkarKrioKareliaKurukShambalaBafiaDialek KolschKumykKutenaiLadino" +
	"LangiLahndaLambaLezghiaLiguriaLakotaMongoLoziLuba-LuluaLuisenoLundaLuoMi" +
	"zoLuyiaLazMaduraMafaMagahiMaithiliMakasarMandingoMasaiMabaMokshaMandarMe" +
	"ndeMeruMorisienIrlandia Abad PertengahanMakhuwa-Meettometa’MikmakMinangk" +
	"abauManchuriaManipuriMohawkMossiMundangBeberapa BahasaBahasa MuskogeeMir" +
	"andaMarwariMentawaiMyeneEryzaNeapolitanNamaJerman RendahNewariNiasNiueaK" +
	"wasioNgiemboonNogaiNorse KunoN’KoSotho UtaraNuerNewari KlasikNyamweziNya" +
	"nkoleNyoroNzimaOsageTurki OsmaniPangasinaPahleviPampangaPapiamentoPalauJ" +
	"erman PennsylvaniaPersia KunoFunisiaPohnpeiaProvencal LamaKʼicheʼRajasth" +
	"aniRapanuiRarotongaRomboRomaniRotumaMakedo-RumaniaRwaSandaweSakhaAram Sa" +
	"mariaSamburuSasakSantaliNgambaiSanguSisiliaSkotlandiaSenecaSenaSeriSelku" +
	"pKoyraboro SenniIrlandia KunoTachelhitShanArab SuwaSidamoSilesia BawahSe" +
	"layarSami SelatanLule SamiInari SamiSkolt SamiSoninkeSogdienSranan Tongo" +
	"SererSahoSukumaSusuSumeriaKomoriaKongo SwahiliSuriah KlasikSuriahSilesia" +
	"TuluTimneTesoTerenoTetunTigreTivTokelauKlingonTlingitTamashekNyasa Tonga" +
	"Tok PisinTuroyoTarokoTsimshiaTat MuslimTumbukaTuvaluTasawaqTuviniaTamazi" +
	"ght Maroko TengahUdmurtUgaritUmbunduRootVaiVenesiaVotiaVunjoWalserWalamo" +
	"WaraiWashoKalmukSogaYaoYapoisYangbenYembaKantonZapotekBlissymbolZenagaTa" +
	"mazight Maroko StandarZuniTidak ada konten linguistikZazaArab Standar Mo" +
	"dernJerman AustriaJerman Tinggi SwissInggris AustraliaInggris KanadaIngg" +
	"ris InggrisInggris AmerikaSpanyol Amerika LatinSpanyol EropaSpanyol Meks" +
	"ikoPrancis KanadaPrancis SwissFlemishPortugis BrasilPortugis EropaMoldav" +
	"iaSerbo-KroasiaChina (Aksara Sederhana)China (Aksara Tradisional)"

// Size: 1234 bytes, 605 elements
var idLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000a, 0x0010, 0x0019, 0x001d, 0x0024, 0x002a,
	0x002e, 0x0033, 0x0037, 0x003d, 0x0047, 0x004e, 0x0057, 0x005d,
	0x0064, 0x006b, 0x0072, 0x0077, 0x007d, 0x0083, 0x008a, 0x0091,
	0x0099, 0x00a0, 0x00a4, 0x00aa, 0x00c0, 0x00c7, 0x00cc, 0x00d1,
	0x00d7, 0x00dd, 0x00e5, 0x00e8, 0x00ee, 0x00f5, 0x00fe, 0x0105,
	0x0109, 0x010d, 0x0113, 0x0117, 0x011c, 0x0120, 0x0124, 0x012b,
	0x0137, 0x013f, 0x0150, 0x0157, 0x015e, 0x0166, 0x016a, 0x016f,
	0x0175, 0x017a, 0x0183, 0x018a, 0x018f, 0x0197, 0x019e, 0x01a4,
	// Entry 40 - 7F
	0x01af, 0x01bf, 0x01ca, 0x01ce, 0x01d8, 0x01df, 0x01e2, 0x01ea,
	0x01f0, 0x01f9, 0x01ff, 0x0203, 0x020a, 0x020f, 0x0215, 0x021d,
	0x0223, 0x022e, 0x0233, 0x023a, 0x023f, 0x0245, 0x024c, 0x0251,
	0x0255, 0x025c, 0x0262, 0x0267, 0x0271, 0x0276, 0x027f, 0x0286,
	0x0289, 0x0290, 0x029c, 0x02a1, 0x02a9, 0x02b1, 0x02b6, 0x02bf,
	0x02c8, 0x02d0, 0x02d7, 0x02dd, 0x02e2, 0x02e7, 0x02ec, 0x02f9,
	0x02ff, 0x0305, 0x030c, 0x031c, 0x032c, 0x033b, 0x0341, 0x0347,
	0x034f, 0x0355, 0x035a, 0x035f, 0x0366, 0x036d, 0x0371, 0x0377,
	// Entry 80 - BF
	0x037d, 0x0385, 0x038c, 0x0396, 0x039b, 0x03a2, 0x03a7, 0x03b2,
	0x03bb, 0x03c3, 0x03c9, 0x03d3, 0x03d8, 0x03df, 0x03e5, 0x03eb,
	0x03f0, 0x03f5, 0x03fb, 0x0402, 0x0406, 0x040b, 0x0418, 0x041d,
	0x0423, 0x042a, 0x042f, 0x0435, 0x043a, 0x043e, 0x0446, 0x044d,
	0x0453, 0x0458, 0x045d, 0x0463, 0x0468, 0x046e, 0x0474, 0x047b,
	0x047f, 0x0484, 0x0489, 0x0490, 0x0497, 0x049e, 0x04a3, 0x04a8,
	0x04af, 0x04b5, 0x04bb, 0x04c0, 0x04c4, 0x04c8, 0x04cd, 0x04d4,
	0x04da, 0x04e6, 0x04ee, 0x04f3, 0x04f7, 0x04fe, 0x0505, 0x050a,
	// Entry C0 - FF
	0x050a, 0x0517, 0x0523, 0x0529, 0x052d, 0x0534, 0x0534, 0x053b,
	0x0547, 0x054d, 0x0558, 0x0562, 0x0565, 0x057b, 0x0580, 0x0580,
	0x0586, 0x0599, 0x05a0, 0x05a4, 0x05ab, 0x05af, 0x05b4, 0x05be,
	0x05c5, 0x05c9, 0x05ce, 0x05d4, 0x05d8, 0x05dd, 0x05dd, 0x05e5,
	0x05ea, 0x05ee, 0x05f4, 0x05f7, 0x05fe, 0x05fe, 0x05fe, 0x0602,
	0x0602, 0x0606, 0x060c, 0x0612, 0x0617, 0x061b, 0x061f, 0x0626,
	0x062a, 0x062f, 0x0635, 0x063a, 0x0641, 0x0645, 0x064c, 0x0654,
	0x065a, 0x065e, 0x066c, 0x0672, 0x067b, 0x0683, 0x068b, 0x0697,
	// Entry 100 - 13F
	0x069d, 0x069d, 0x06a9, 0x06b1, 0x06b7, 0x06bd, 0x06c2, 0x06ca,
	0x06cf, 0x06d5, 0x06da, 0x06df, 0x06e4, 0x06f1, 0x06f1, 0x06f6,
	0x0704, 0x070e, 0x0713, 0x0719, 0x071d, 0x0721, 0x0721, 0x072b,
	0x0731, 0x0735, 0x074d, 0x074d, 0x0753, 0x0753, 0x0757, 0x075f,
	0x075f, 0x0762, 0x0762, 0x077a, 0x0786, 0x078d, 0x0799, 0x07a5,
	0x07ab, 0x07ad, 0x07b3, 0x07b3, 0x07b7, 0x07bc, 0x07bc, 0x07c0,
	0x07c7, 0x07cd, 0x07e4, 0x07ef, 0x07ef, 0x07f4, 0x07fd, 0x0803,
	0x0808, 0x0813, 0x081f, 0x081f, 0x081f, 0x0824, 0x082e, 0x0833,
	// Entry 140 - 17F
	0x0833, 0x0839, 0x0843, 0x084d, 0x0852, 0x0857, 0x0862, 0x0862,
	0x0866, 0x086a, 0x0870, 0x0875, 0x087f, 0x087f, 0x087f, 0x0885,
	0x088b, 0x0892, 0x089f, 0x08aa, 0x08aa, 0x08b5, 0x08bb, 0x08c1,
	0x08c4, 0x08c9, 0x08cd, 0x08d4, 0x08db, 0x08df, 0x08e6, 0x08f2,
	0x08f9, 0x08fd, 0x08fd, 0x0902, 0x0908, 0x0914, 0x0914, 0x0914,
	0x0918, 0x0920, 0x0928, 0x0934, 0x093b, 0x0940, 0x0946, 0x0955,
	0x0959, 0x0959, 0x0960, 0x0965, 0x096d, 0x0972, 0x097f, 0x0984,
	0x098b, 0x0991, 0x0996, 0x099c, 0x09a1, 0x09a8, 0x09a8, 0x09af,
	// Entry 180 - 1BF
	0x09af, 0x09b5, 0x09b5, 0x09ba, 0x09be, 0x09be, 0x09c8, 0x09cf,
	0x09d4, 0x09d7, 0x09db, 0x09e0, 0x09e0, 0x09e3, 0x09e9, 0x09ed,
	0x09f3, 0x09fb, 0x0a02, 0x0a0a, 0x0a0f, 0x0a13, 0x0a19, 0x0a1f,
	0x0a24, 0x0a28, 0x0a30, 0x0a49, 0x0a57, 0x0a5e, 0x0a64, 0x0a6f,
	0x0a78, 0x0a80, 0x0a86, 0x0a8b, 0x0a8b, 0x0a92, 0x0aa1, 0x0ab0,
	0x0ab7, 0x0abe, 0x0ac6, 0x0acb, 0x0ad0, 0x0ad0, 0x0ad0, 0x0ada,
	0x0ade, 0x0aeb, 0x0af1, 0x0af5, 0x0afa, 0x0afa, 0x0b00, 0x0b09,
	0x0b0e, 0x0b18, 0x0b18, 0x0b1e, 0x0b29, 0x0b2d, 0x0b3a, 0x0b42,
	// Entry 1C0 - 1FF
	0x0b4a, 0x0b4f, 0x0b54, 0x0b59, 0x0b65, 0x0b6e, 0x0b75, 0x0b7d,
	0x0b87, 0x0b8c, 0x0b8c, 0x0b9f, 0x0b9f, 0x0baa, 0x0baa, 0x0bb1,
	0x0bb1, 0x0bb1, 0x0bb9, 0x0bb9, 0x0bc7, 0x0bd0, 0x0bd0, 0x0bda,
	0x0be1, 0x0bea, 0x0bea, 0x0bea, 0x0bef, 0x0bf5, 0x0bfb, 0x0bfb,
	0x0bfb, 0x0c09, 0x0c0c, 0x0c13, 0x0c18, 0x0c24, 0x0c2b, 0x0c30,
	0x0c37, 0x0c37, 0x0c3e, 0x0c43, 0x0c4a, 0x0c54, 0x0c54, 0x0c5a,
	0x0c5e, 0x0c62, 0x0c68, 0x0c77, 0x0c84, 0x0c84, 0x0c8d, 0x0c91,
	0x0c9a, 0x0ca0, 0x0cad, 0x0cb4, 0x0cc0, 0x0cc9, 0x0cd3, 0x0cdd,
	// Entry 200 - 23F
	0x0ce4, 0x0ceb, 0x0cf7, 0x0cfc, 0x0d00, 0x0d00, 0x0d06, 0x0d0a,
	0x0d11, 0x0d18, 0x0d25, 0x0d32, 0x0d38, 0x0d3f, 0x0d43, 0x0d48,
	0x0d4c, 0x0d52, 0x0d57, 0x0d5c, 0x0d5f, 0x0d66, 0x0d66, 0x0d6d,
	0x0d74, 0x0d74, 0x0d7c, 0x0d87, 0x0d90, 0x0d96, 0x0d9c, 0x0d9c,
	0x0da4, 0x0dae, 0x0db5, 0x0dbb, 0x0dc2, 0x0dc9, 0x0de0, 0x0de6,
	0x0dec, 0x0df3, 0x0df7, 0x0dfa, 0x0e01, 0x0e01, 0x0e01, 0x0e01,
	0x0e06, 0x0e06, 0x0e0b, 0x0e11, 0x0e17, 0x0e1c, 0x0e21, 0x0e21,
	0x0e21, 0x0e27, 0x0e27, 0x0e2b, 0x0e2e, 0x0e34, 0x0e3b, 0x0e40,
	// Entry 240 - 27F
	0x0e40, 0x0e46, 0x0e4d, 0x0e57, 0x0e57, 0x0e5d, 0x0e75, 0x0e79,
	0x0e94, 0x0e98, 0x0eab, 0x0eb9, 0x0ecc, 0x0edd, 0x0eeb, 0x0efa,
	0x0f09, 0x0f1e, 0x0f2b, 0x0f3a, 0x0f48, 0x0f55, 0x0f5c, 0x0f6b,
	0x0f79, 0x0f81, 0x0f8e, 0x0fa6, 0x0fc0,
}

// Size: 4224 bytes
const isLangStr = "" +
	"abkasískaavestískaafríkanskaakanamharískaaragonskaarabískaassamskaavarís" +
	"kaaímaraaserskabaskírhvítrússneskabúlgarskabíslamabambarabengalskatíbesk" +
	"abretónskabosnískakatalónskatsjetsjenskakamorrókorsískakrítékkneskakirkj" +
	"uslavneskasjúvasvelskadanskaþýskadívehídsongkaewegrískaenskaesperantóspæ" +
	"nskaeistneskabaskneskapersneskafúlafinnskafídjeyskafæreyskafranskavestur" +
	"frísneskaírskaskosk gelískagalíanskagvaranígújaratímanskahásahebreskahin" +
	"díhírímótúkróatískahaítískaungverskaarmenskahereróalþjóðatungaindónesísk" +
	"ainterlingveígbósísúanjíínúpíakídóíslenskaítalskainúktitútjapanskajavans" +
	"kageorgískakongóskakíkújúkúanjamakasakskagrænlenskakmerkannadakóreskakan" +
	"úríkasmírskakúrdískakomískakornbreskakirgiskalatínalúxemborgískagandali" +
	"mbúrgískalingalalaólitháískalúbakatangalettneskamalagasískamarshallskama" +
	"orímakedónskamalajalammongólskamaratímalaískamaltneskaburmneskanárúskano" +
	"rður-ndebelenepalskandongahollenskanýnorskanorskt bókmálsuðurndebelenava" +
	"hónjanja; sísjeva; sjevaoksítanískaojibvaoromoóríaossetískapúnjabípalípó" +
	"lskapastúportúgalskakvesjúarómanskarúndírúmenskarússneskakínjarvandasans" +
	"krítsardínskasindínorðursamískasangósingalískaslóvakískaslóvenskasamóska" +
	"shonasómalskaalbanskaserbneskasvatísuðursótósúndanskasænskasvahílítamíls" +
	"katelúgútadsjikskataílenskatígrinjatúrkmenskatsúanatongverskatyrkneskats" +
	"ongatatarskatahítískaúígúrúkraínskaúrdúúsbekskavendavíetnamskavallónskav" +
	"olofsósajiddískajórúbasúangkínverskasúlúakkískaacoliadangmeadýgeafríhílí" +
	"aghemakkadískaaleúskafornenskaarameískaarákanískaarapahóaravakskaasuastú" +
	"rískaavadíbalúkíbalískabasabejabembabenabojpúríbíkolbínísiksikabraíbódób" +
	"úríatbúgískablínkaddókaríbamálkebúanókígasíbsjasjagataísjúkískamarísínú" +
	"ksjoktásípevískaCherokee-málsjeyensorani-kúrdískakoptískakrímtyrkneskaka" +
	"súbískadakótadargvataítadelaverslavneskadogríbdinkazarmadogrílágsorbnesk" +
	"adúalamiðhollenskajola-fonyidjúlaembuefíkfornegypskaekajúkelamítmiðenska" +
	"evondófangfilippseyskafónmiðfranskafornfranskanorðurfrísneskaausturfrísn" +
	"eskafríúlskagagagásgajógbajagísgilberskamiðháþýskafornháþýskagondígoront" +
	"alógotneskagerbóforngrískasvissnesk þýskagusiigvísínhaídahavaískahíligaí" +
	"nonhettitískahmonghásorbneskahúpaíbanílokóingúslojbanngombamasjámegyðing" +
	"apersneskagyðingaarabískakarakalpakkabílekasínkambakavíkabardískamakonde" +
	"grænhöfðeyskakasíkotaskakoyra chiinikalenjinkimbúndúkómí-permyakkonkaník" +
	"osraskakpellekarasaíbalkarkúrúksjambalabafíakúmíkkútenaíladínskalangílan" +
	"dalambalesgískalakótamongóloziluba-lulualúisenólúndalúólúsaíluyiamadúrsk" +
	"amagahímaítílímakasarmandingómasaímoksamandarmendemerúmáritískamiðírskam" +
	"akhuwa-meettometa’mikmakmínangkabámansjúmanípúrímóhískamossímundangmargv" +
	"ísleg málkríkmarvaríersjanapólískanamalágþýska; lágsaxneskanevaríníasní" +
	"veskakwasionógaínorrænan’konorðursótónúernjamvesínyankolenjórónsímaósage" +
	"tyrkneska, ottómanpangasínmálpalavípampangapapíamentópaláskafornpersnesk" +
	"afönikískaponpeiskafornpróvensalskakicherajastanírapanúírarótongskarombó" +
	"romanírúasandavejakútsamversk arameískasambúrúsasaksantalísangúsikileysk" +
	"askoskasenaselkúpkoíraboró-sennífornírskatachelhitsjansídamósuðursamíska" +
	"lúlesamískaenaresamískaskoltesamískasóninkesogdíenserersúkúmasúsúsúmersk" +
	"aKongó-svahílíklassísk sýrlenskasýrlenskatímnetesóterenótetúmtígretívtók" +
	"eláskaklingonskatlingittamasjektongverska (nyasa)tokpisintsimsískatúmbúk" +
	"atúvalúskatasawaqtúvínskatamazightúdmúrtúgarítískaúmbúndúrótvaívotískavu" +
	"njóvalamóvaraívasjókalmúkskasógajaójapískasapótekblisstáknsenagastaðlað " +
	"marokkóskt tamazightsúníekkert tungumálaefnistöðluð nútímaarabískaaustur" +
	"rísk þýskasvissnesk háþýskaáströlsk enskakanadísk enskabresk enskabandar" +
	"ísk enskarómanskamerísk spænskaevrópsk spænskamexíkósk spænskakanadísk " +
	"franskasvissnesk franskaflæmskabrasílísk portúgalskaevrópsk portúgalskam" +
	"oldóvskaserbókróatískakínverska (einfölduð)kínverska (hefðbundin)"

// Size: 1234 bytes, 605 elements
var isLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0000, 0x000a, 0x0014, 0x001f, 0x0023, 0x002d, 0x0036,
	0x003f, 0x0047, 0x0050, 0x0057, 0x005e, 0x0065, 0x0074, 0x007e,
	0x0086, 0x008d, 0x0096, 0x009e, 0x00a8, 0x00b1, 0x00bc, 0x00c8,
	0x00d0, 0x00d9, 0x00dd, 0x00e7, 0x00f6, 0x00fd, 0x0103, 0x0109,
	0x0110, 0x0118, 0x011f, 0x0122, 0x0129, 0x012e, 0x0138, 0x0140,
	0x0149, 0x0152, 0x015b, 0x0160, 0x0167, 0x0171, 0x017a, 0x0181,
	0x0191, 0x0197, 0x01a5, 0x01af, 0x01b7, 0x01c1, 0x01c7, 0x01cc,
	0x01d4, 0x01da, 0x01e6, 0x01f1, 0x01fb, 0x0204, 0x020c, 0x0213,
	// Entry 40 - 7F
	0x0222, 0x022f, 0x023a, 0x0240, 0x024b, 0x0255, 0x025a, 0x0263,
	0x026b, 0x0276, 0x027e, 0x0286, 0x0290, 0x0299, 0x02a2, 0x02ab,
	0x02b3, 0x02be, 0x02c2, 0x02c9, 0x02d1, 0x02d9, 0x02e3, 0x02ed,
	0x02f5, 0x02ff, 0x0307, 0x030e, 0x031d, 0x0322, 0x032f, 0x0336,
	0x033a, 0x0345, 0x0351, 0x035a, 0x0366, 0x0371, 0x0377, 0x0382,
	0x038b, 0x0395, 0x039c, 0x03a5, 0x03ae, 0x03b7, 0x03c0, 0x03cf,
	0x03d7, 0x03dd, 0x03e6, 0x03ef, 0x03fe, 0x040b, 0x0412, 0x0429,
	0x0436, 0x043c, 0x0441, 0x0447, 0x0451, 0x045a, 0x045f, 0x0466,
	// Entry 80 - BF
	0x046c, 0x0478, 0x0480, 0x0489, 0x0490, 0x0499, 0x04a3, 0x04af,
	0x04b8, 0x04c2, 0x04c8, 0x04d7, 0x04dd, 0x04e8, 0x04f4, 0x04fe,
	0x0506, 0x050b, 0x0514, 0x051c, 0x0525, 0x052b, 0x0537, 0x0541,
	0x0548, 0x0551, 0x055a, 0x0562, 0x056c, 0x0576, 0x057f, 0x058a,
	0x0591, 0x059b, 0x05a4, 0x05aa, 0x05b2, 0x05bd, 0x05c5, 0x05d0,
	0x05d6, 0x05df, 0x05e4, 0x05ef, 0x05ef, 0x05f9, 0x05fe, 0x0603,
	0x060c, 0x0614, 0x061a, 0x0624, 0x062a, 0x0632, 0x0637, 0x063e,
	0x0644, 0x0644, 0x064f, 0x0654, 0x0654, 0x065e, 0x065e, 0x0666,
	// Entry C0 - FF
	0x0666, 0x0666, 0x066f, 0x066f, 0x0679, 0x0685, 0x0685, 0x068d,
	0x068d, 0x0696, 0x0696, 0x0696, 0x0699, 0x0699, 0x06a4, 0x06a4,
	0x06aa, 0x06aa, 0x06b2, 0x06ba, 0x06ba, 0x06be, 0x06be, 0x06be,
	0x06be, 0x06c2, 0x06c7, 0x06c7, 0x06cb, 0x06cb, 0x06cb, 0x06d4,
	0x06da, 0x06e0, 0x06e0, 0x06e0, 0x06e7, 0x06e7, 0x06e7, 0x06ec,
	0x06ec, 0x06f2, 0x06f2, 0x06fa, 0x0703, 0x0703, 0x0708, 0x0708,
	0x070e, 0x0719, 0x0719, 0x0719, 0x0722, 0x0727, 0x072e, 0x0737,
	0x0741, 0x0746, 0x074d, 0x0754, 0x075f, 0x076c, 0x0772, 0x0783,
	// Entry 100 - 13F
	0x078c, 0x078c, 0x079a, 0x07a5, 0x07ac, 0x07b2, 0x07b8, 0x07bf,
	0x07c8, 0x07cf, 0x07d4, 0x07d9, 0x07df, 0x07ec, 0x07ec, 0x07f2,
	0x07ff, 0x0809, 0x080f, 0x080f, 0x0813, 0x0818, 0x0818, 0x0823,
	0x082a, 0x0831, 0x083a, 0x083a, 0x0841, 0x0841, 0x0845, 0x0851,
	0x0851, 0x0855, 0x0855, 0x0860, 0x086b, 0x086b, 0x087c, 0x088c,
	0x0896, 0x0898, 0x089e, 0x089e, 0x08a3, 0x08a8, 0x08a8, 0x08ac,
	0x08b5, 0x08b5, 0x08c3, 0x08d1, 0x08d1, 0x08d7, 0x08e1, 0x08e9,
	0x08ef, 0x08fa, 0x090b, 0x090b, 0x090b, 0x0910, 0x0918, 0x091e,
	// Entry 140 - 17F
	0x091e, 0x0927, 0x0927, 0x0933, 0x093e, 0x0943, 0x094f, 0x094f,
	0x0954, 0x0959, 0x0959, 0x0960, 0x0966, 0x0966, 0x0966, 0x096c,
	0x0972, 0x097a, 0x098b, 0x099c, 0x099c, 0x09a6, 0x09ad, 0x09b3,
	0x09b3, 0x09b8, 0x09bd, 0x09c8, 0x09c8, 0x09c8, 0x09cf, 0x09df,
	0x09df, 0x09df, 0x09df, 0x09e4, 0x09eb, 0x09f7, 0x09f7, 0x09f7,
	0x09f7, 0x09ff, 0x0a09, 0x0a17, 0x0a1f, 0x0a27, 0x0a2d, 0x0a3b,
	0x0a3b, 0x0a3b, 0x0a3b, 0x0a42, 0x0a4a, 0x0a50, 0x0a50, 0x0a57,
	0x0a60, 0x0a69, 0x0a6f, 0x0a74, 0x0a79, 0x0a82, 0x0a82, 0x0a82,
	// Entry 180 - 1BF
	0x0a82, 0x0a89, 0x0a89, 0x0a8f, 0x0a93, 0x0a93, 0x0a9d, 0x0aa6,
	0x0aac, 0x0ab1, 0x0ab8, 0x0abd, 0x0abd, 0x0abd, 0x0ac6, 0x0ac6,
	0x0acd, 0x0ad7, 0x0ade, 0x0ae7, 0x0aed, 0x0aed, 0x0af2, 0x0af8,
	0x0afd, 0x0b02, 0x0b0d, 0x0b17, 0x0b25, 0x0b2c, 0x0b32, 0x0b3e,
	0x0b45, 0x0b50, 0x0b59, 0x0b5f, 0x0b5f, 0x0b66, 0x0b76, 0x0b7b,
	0x0b7b, 0x0b83, 0x0b83, 0x0b83, 0x0b88, 0x0b88, 0x0b88, 0x0b93,
	0x0b97, 0x0bb0, 0x0bb7, 0x0bbc, 0x0bc4, 0x0bc4, 0x0bca, 0x0bca,
	0x0bd1, 0x0bd9, 0x0bd9, 0x0bdf, 0x0bec, 0x0bf1, 0x0bf1, 0x0bfa,
	// Entry 1C0 - 1FF
	0x0c02, 0x0c09, 0x0c0f, 0x0c15, 0x0c28, 0x0c35, 0x0c3c, 0x0c44,
	0x0c50, 0x0c58, 0x0c58, 0x0c58, 0x0c58, 0x0c65, 0x0c65, 0x0c70,
	0x0c70, 0x0c70, 0x0c79, 0x0c79, 0x0c8a, 0x0c8f, 0x0c8f, 0x0c99,
	0x0ca2, 0x0cae, 0x0cae, 0x0cae, 0x0cb4, 0x0cbb, 0x0cbb, 0x0cbb,
	0x0cbb, 0x0cbb, 0x0cbf, 0x0cc6, 0x0ccc, 0x0cdf, 0x0ce8, 0x0ced,
	0x0cf5, 0x0cf5, 0x0cf5, 0x0cfb, 0x0d05, 0x0d0b, 0x0d0b, 0x0d0b,
	0x0d0f, 0x0d0f, 0x0d16, 0x0d28, 0x0d32, 0x0d32, 0x0d3b, 0x0d3f,
	0x0d3f, 0x0d47, 0x0d47, 0x0d47, 0x0d55, 0x0d62, 0x0d6f, 0x0d7d,
	// Entry 200 - 23F
	0x0d85, 0x0d8d, 0x0d8d, 0x0d92, 0x0d92, 0x0d92, 0x0d9a, 0x0da0,
	0x0da9, 0x0da9, 0x0db9, 0x0dcd, 0x0dd7, 0x0dd7, 0x0dd7, 0x0ddd,
	0x0de2, 0x0de9, 0x0def, 0x0df5, 0x0df9, 0x0e04, 0x0e04, 0x0e0e,
	0x0e15, 0x0e15, 0x0e1d, 0x0e2f, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
	0x0e41, 0x0e41, 0x0e4a, 0x0e55, 0x0e5c, 0x0e66, 0x0e6f, 0x0e77,
	0x0e84, 0x0e8e, 0x0e92, 0x0e96, 0x0e96, 0x0e96, 0x0e96, 0x0e96,
	0x0e9e, 0x0e9e, 0x0ea4, 0x0ea4, 0x0eab, 0x0eb1, 0x0eb7, 0x0eb7,
	0x0eb7, 0x0ec1, 0x0ec1, 0x0ec6, 0x0eca, 0x0ed2, 0x0ed2, 0x0ed2,
	// Entry 240 - 27F
	0x0ed2, 0x0ed2, 0x0eda, 0x0ee4, 0x0ee4, 0x0eea, 0x0f09, 0x0f0f,
	0x0f24, 0x0f24, 0x0f40, 0x0f53, 0x0f67, 0x0f77, 0x0f86, 0x0f91,
	0x0fa1, 0x0fba, 0x0fcb, 0x0fde, 0x0fef, 0x1000, 0x1008, 0x1020,
	0x1035, 0x103f, 0x1050, 0x1068, 0x1080,
}

// Size: 4915 bytes
const itLangStr = "" +
	"afarabcasoavestanafrikaansakanamaricoaragonesearaboassameseavaroaymaraaz" +
	"erbaigianobaschirobielorussobulgarobislamabambarabengalesetibetanobreton" +
	"ebosniacocatalanocecenochamorrocorsocreececoslavo della Chiesachuvashgal" +
	"lesedanesetedescodivehidzongkhaewegrecoingleseesperantospagnoloestonebas" +
	"copersianofulahfinlandesefigianofaroesefrancesefrisone occidentaleirland" +
	"esegaelico scozzesegalizianoguaranígujaratimanxhausaebraicohindihiri mot" +
	"ucroatohaitianoungheresearmenohererointerlinguaindonesianointerlingueigb" +
	"osichuan yiinupiakidoislandeseitalianoinuktitutgiapponesegiavanesegeorgi" +
	"anokongokikuyukuanyamakazakokalaallisutkhmerkannadacoreanokanurikashmiri" +
	"curdokomicornicochirghisolatinolussemburghesegandalimburgeselingalalaoli" +
	"tuanoluba-katangalettonemalgasciomarshallesemaorimacedonemalayalammongol" +
	"omarathimalesemaltesebirmanonaurundebele del nordnepalesendongaolandesen" +
	"orvegese nynorsknorvegese bokmålndebele del sudnavajonyanjaoccitanoojibw" +
	"aoromooriyaosseticopunjabipalipolaccopashtoportoghesequechuaromanciorund" +
	"irumenorussokinyarwandasanscritosardosindhisami del nordsangosingalesesl" +
	"ovaccoslovenosamoanoshonasomaloalbaneseserboswatisotho del sudsundaneses" +
	"vedeseswahilitamiltelugutagicothaitigrinoturcomannotswanatonganoturcotso" +
	"ngatatarotaitianouiguroucrainourduusbecovendavietnamitavolapükvallonewol" +
	"ofxhosayiddishyorubazhuangcinesezuluaccineseacioliadangmeadyghearabo tun" +
	"isinoafrihiliaghemainuaccadoalabamaaleutoalbanese ghegoaltai meridionale" +
	"inglese anticoangikaaramaicoaraucanoaraonaarapahoarabo algerinoaruacoara" +
	"bo marocchinoarabo egizianoasulingua dei segni americanaasturianokotavaa" +
	"wadhiazero meridionalebelucibalinesebavaresebasabamunbatak tobaghomalabe" +
	"giawembabetawibenabafutbadagabhojpuribicolbinibanjarkomsiksikabishnupriy" +
	"abakhtiaribrajbrahuibodoakooseburiatbugibulublinmedumbacaddocaribicocayu" +
	"gaatsamcebuanochigachibchaciagataicochuukesemarigergo chinookchoctawchip" +
	"ewyancherokeecheyennecurdo soranicoptocapiznonturco crimeokashubiandakot" +
	"adargwataitadelawareslavedogribdincazarmadogribasso sorabodusun centrale" +
	"dualaolandese mediojola-fonydiuladazagaembuefikemilianoegiziano anticoek" +
	"ajukaelamiticoinglese medioyupik centraleewondoestremegnofangfilippinofi" +
	"nlandese del Tornedalenfonfrancese cajunfrancese mediofrancese anticofra" +
	"ncoprovenzalefrisone settentrionalefrisone orientalefriulanogagagauzogan" +
	"gayogbayadari zoroastrianogeezgilbertesegilakitedesco medio altotedesco " +
	"antico altokonkani goanogondigorontalogoticogerbogreco anticotedesco svi" +
	"zzerowayuugusiigwichʼinhaidahakkahawaianohindi figianohiligaynahittitehm" +
	"ongalto soraboxianghupaibanibibioilocanoingushingricocreolo giamaicanolo" +
	"jbanngamambomachamegiudeo persianogiudeo arabojutlandicokara-kalpakcabil" +
	"okachinkaikambakawikabardiakanembutyapmakondecapoverdianokorokaingangkha" +
	"sikhotanesekoyra chiinikhowarkirmanjkikakokalenjinkimbundupermiacokonkan" +
	"ikosraeankpellekarachay-Balkarcarelianokurukhshambalabafiacoloniesekumyk" +
	"kutenaigiudeo-spagnololangilahndalambalezghianLingua Franca Novaligureli" +
	"vonelakotalombardololo bantuloziletgalloluba-lulualuisenolundaluolushail" +
	"uyiacinese classicolazmaduresemafamagahimaithilimakasarmandingomasaimaba" +
	"mokshamandarmendemerucreolo maurizianoirlandese mediomakhuwa-meettometa’" +
	"micmacmenangkabaumanchumanipurimohawkmossimari occidentalemundangmultili" +
	"nguacreekmirandesemarwarimentawaimyeneerzyamazandaranimin nannapoletanon" +
	"amabasso tedesconewariniasniueaokwasiongiemboonnogainorse anticonovialn’" +
	"kosotho del nordnuernewari classiconyamwezinyankolenyoronzimaosageturco " +
	"ottomanopangasinanpahlavipampangapapiamentopalaupiccardotedesco della Pe" +
	"nnsylvaniapersiano anticotedesco palatinofeniciopiemonteseponticoponapep" +
	"russianoprovenzale anticok’iche’quechua dell’altopiano del Chimborazoraj" +
	"asthanirapanuirarotongaromagnolotarifitromboromanirotumanorutenorovianaa" +
	"rumenorwasandaweyakutaramaico samaritanosamburusasaksantalisaurashtranga" +
	"mbaysangusicilianoscozzesesassaresesenecasenaseriselkupkoyraboro senniir" +
	"landese anticosamogiticotashelhitshanchadian arabicsidamotedesco slesian" +
	"oselayarsami del sudsami di Lulesami di Inarisami skoltsoninkesogdianosr" +
	"anan tongoserersahosaterfriesischsukumasususumerocomorianocongo swahilis" +
	"iriaco classicosiriacoslesianotulutemnetesoterenotetumtigretivtokelautsa" +
	"khurklingontlingittalisciotamasheknyasa del Tongatok pisinturoyotarokoza" +
	"conicotsimshiantat islamicotumbukatuvalutasawaqtuviniantamazightudmurtug" +
	"ariticombundurootvaivenetovepsofiammingo occidentalevotovõrovunjowalserw" +
	"alamowaraywashowukalmykmengreliosogayao (bantu)yapeseyangbenyembanheenga" +
	"tucantonesezapotecblissymbolzelandesezenagatamazight del Marocco standar" +
	"dzuninessun contenuto linguisticozazaarabo moderno standardtedesco austr" +
	"iacoalto tedesco svizzeroinglese australianoinglese canadeseinglese brit" +
	"annicoinglese americanospagnolo latinoamericanospagnolo europeospagnolo " +
	"messicanofrancese canadesefrancese svizzerofiammingoportoghese brasilian" +
	"oportoghese europeomoldavoserbo-croatocinese semplificatocinese tradizio" +
	"nale"

// Size: 1234 bytes, 605 elements
var itLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000a, 0x0011, 0x001a, 0x001e, 0x0025, 0x002e,
	0x0033, 0x003b, 0x0040, 0x0046, 0x0052, 0x005a, 0x0064, 0x006b,
	0x0072, 0x0079, 0x0082, 0x008a, 0x0091, 0x0099, 0x00a1, 0x00a7,
	0x00af, 0x00b4, 0x00b8, 0x00bc, 0x00ce, 0x00d5, 0x00dc, 0x00e2,
	0x00e9, 0x00ef, 0x00f7, 0x00fa, 0x00ff, 0x0106, 0x010f, 0x0117,
	0x011d, 0x0122, 0x012a, 0x012f, 0x0139, 0x0140, 0x0147, 0x014f,
	0x0162, 0x016b, 0x017b, 0x0184, 0x018c, 0x0194, 0x0198, 0x019d,
	0x01a4, 0x01a9, 0x01b2, 0x01b8, 0x01c0, 0x01c9, 0x01cf, 0x01d5,
	// Entry 40 - 7F
	0x01e0, 0x01eb, 0x01f6, 0x01fa, 0x0204, 0x020b, 0x020e, 0x0217,
	0x021f, 0x0228, 0x0232, 0x023b, 0x0244, 0x0249, 0x024f, 0x0257,
	0x025d, 0x0268, 0x026d, 0x0274, 0x027b, 0x0281, 0x0289, 0x028e,
	0x0292, 0x0299, 0x02a2, 0x02a8, 0x02b6, 0x02bb, 0x02c5, 0x02cc,
	0x02cf, 0x02d6, 0x02e2, 0x02e9, 0x02f2, 0x02fd, 0x0302, 0x030a,
	0x0313, 0x031a, 0x0321, 0x0327, 0x032e, 0x0335, 0x033a, 0x034a,
	0x0352, 0x0358, 0x0360, 0x0371, 0x0382, 0x0391, 0x0397, 0x039d,
	0x03a5, 0x03ab, 0x03b0, 0x03b5, 0x03bd, 0x03c4, 0x03c8, 0x03cf,
	// Entry 80 - BF
	0x03d5, 0x03df, 0x03e6, 0x03ee, 0x03f3, 0x03f9, 0x03fe, 0x0409,
	0x0412, 0x0417, 0x041d, 0x042a, 0x042f, 0x0438, 0x0440, 0x0447,
	0x044e, 0x0453, 0x0459, 0x0461, 0x0466, 0x046b, 0x0478, 0x0481,
	0x0488, 0x048f, 0x0494, 0x049a, 0x04a0, 0x04a4, 0x04ab, 0x04b5,
	0x04bb, 0x04c2, 0x04c7, 0x04cd, 0x04d3, 0x04db, 0x04e1, 0x04e8,
	0x04ec, 0x04f2, 0x04f7, 0x0501, 0x0509, 0x0510, 0x0515, 0x051a,
	0x0521, 0x0527, 0x052d, 0x0533, 0x0537, 0x053f, 0x0545, 0x054c,
	0x0552, 0x0560, 0x0568, 0x056d, 0x0571, 0x0577, 0x057e, 0x0584,
	// Entry C0 - FF
	0x0592, 0x05a3, 0x05b1, 0x05b7, 0x05bf, 0x05c7, 0x05cd, 0x05d4,
	0x05e2, 0x05e8, 0x05f8, 0x0606, 0x0609, 0x0623, 0x062c, 0x0632,
	0x0638, 0x0649, 0x064f, 0x0657, 0x065f, 0x0663, 0x0668, 0x0672,
	0x0679, 0x067e, 0x0683, 0x0689, 0x068d, 0x0692, 0x0698, 0x06a0,
	0x06a5, 0x06a9, 0x06af, 0x06b2, 0x06b9, 0x06c4, 0x06cd, 0x06d1,
	0x06d7, 0x06db, 0x06e1, 0x06e7, 0x06eb, 0x06ef, 0x06f3, 0x06fa,
	0x06ff, 0x0707, 0x070d, 0x0712, 0x0719, 0x071e, 0x0725, 0x072f,
	0x0737, 0x073b, 0x0748, 0x074f, 0x0758, 0x0760, 0x0768, 0x0774,
	// Entry 100 - 13F
	0x0779, 0x0781, 0x078d, 0x0796, 0x079c, 0x07a2, 0x07a7, 0x07af,
	0x07b4, 0x07ba, 0x07bf, 0x07c4, 0x07c9, 0x07d5, 0x07e3, 0x07e8,
	0x07f6, 0x07ff, 0x0804, 0x080a, 0x080e, 0x0812, 0x081a, 0x0829,
	0x0830, 0x0839, 0x0846, 0x0854, 0x085a, 0x0864, 0x0868, 0x0871,
	0x088a, 0x088d, 0x089b, 0x08a9, 0x08b8, 0x08c8, 0x08de, 0x08ef,
	0x08f7, 0x08f9, 0x0900, 0x0903, 0x0907, 0x090c, 0x091d, 0x0921,
	0x092b, 0x0931, 0x0943, 0x0956, 0x0963, 0x0968, 0x0971, 0x0977,
	0x097c, 0x0988, 0x0998, 0x099d, 0x099d, 0x09a2, 0x09ab, 0x09b0,
	// Entry 140 - 17F
	0x09b5, 0x09bd, 0x09ca, 0x09d3, 0x09da, 0x09df, 0x09ea, 0x09ef,
	0x09f3, 0x09f7, 0x09fd, 0x0a04, 0x0a0a, 0x0a11, 0x0a22, 0x0a28,
	0x0a30, 0x0a37, 0x0a46, 0x0a52, 0x0a5c, 0x0a67, 0x0a6d, 0x0a73,
	0x0a76, 0x0a7b, 0x0a7f, 0x0a87, 0x0a8e, 0x0a92, 0x0a99, 0x0aa5,
	0x0aa5, 0x0aa9, 0x0ab1, 0x0ab6, 0x0abf, 0x0acb, 0x0ad1, 0x0ada,
	0x0ade, 0x0ae6, 0x0aee, 0x0af6, 0x0afd, 0x0b05, 0x0b0b, 0x0b1a,
	0x0b1a, 0x0b1a, 0x0b23, 0x0b29, 0x0b31, 0x0b36, 0x0b3f, 0x0b44,
	0x0b4b, 0x0b5a, 0x0b5f, 0x0b65, 0x0b6a, 0x0b72, 0x0b84, 0x0b8a,
	// Entry 180 - 1BF
	0x0b90, 0x0b96, 0x0b9e, 0x0ba8, 0x0bac, 0x0bb4, 0x0bbe, 0x0bc5,
	0x0bca, 0x0bcd, 0x0bd3, 0x0bd8, 0x0be7, 0x0bea, 0x0bf2, 0x0bf6,
	0x0bfc, 0x0c04, 0x0c0b, 0x0c13, 0x0c18, 0x0c1c, 0x0c22, 0x0c28,
	0x0c2d, 0x0c31, 0x0c42, 0x0c51, 0x0c5f, 0x0c66, 0x0c6c, 0x0c77,
	0x0c7d, 0x0c85, 0x0c8b, 0x0c90, 0x0ca0, 0x0ca7, 0x0cb2, 0x0cb7,
	0x0cc0, 0x0cc7, 0x0ccf, 0x0cd4, 0x0cd9, 0x0ce4, 0x0ceb, 0x0cf5,
	0x0cf9, 0x0d06, 0x0d0c, 0x0d10, 0x0d14, 0x0d16, 0x0d1c, 0x0d25,
	0x0d2a, 0x0d36, 0x0d3c, 0x0d42, 0x0d50, 0x0d54, 0x0d63, 0x0d6b,
	// Entry 1C0 - 1FF
	0x0d73, 0x0d78, 0x0d7d, 0x0d82, 0x0d90, 0x0d9a, 0x0da1, 0x0da9,
	0x0db3, 0x0db8, 0x0dc0, 0x0dda, 0x0dda, 0x0de9, 0x0df9, 0x0e00,
	0x0e0a, 0x0e11, 0x0e17, 0x0e20, 0x0e31, 0x0e3c, 0x0e63, 0x0e6d,
	0x0e74, 0x0e7d, 0x0e86, 0x0e8d, 0x0e92, 0x0e98, 0x0ea0, 0x0ea6,
	0x0ead, 0x0eb4, 0x0eb7, 0x0ebe, 0x0ec3, 0x0ed6, 0x0edd, 0x0ee2,
	0x0ee9, 0x0ef3, 0x0efa, 0x0eff, 0x0f08, 0x0f10, 0x0f19, 0x0f1f,
	0x0f23, 0x0f27, 0x0f2d, 0x0f3c, 0x0f4c, 0x0f56, 0x0f5f, 0x0f63,
	0x0f71, 0x0f77, 0x0f87, 0x0f8e, 0x0f9a, 0x0fa6, 0x0fb3, 0x0fbd,
	// Entry 200 - 23F
	0x0fc4, 0x0fcc, 0x0fd8, 0x0fdd, 0x0fe1, 0x0fef, 0x0ff5, 0x0ff9,
	0x0fff, 0x1008, 0x1015, 0x1025, 0x102c, 0x1034, 0x1038, 0x103d,
	0x1041, 0x1047, 0x104c, 0x1051, 0x1054, 0x105b, 0x1062, 0x1069,
	0x1070, 0x1078, 0x1080, 0x108f, 0x1098, 0x109e, 0x10a4, 0x10ac,
	0x10b5, 0x10c1, 0x10c8, 0x10ce, 0x10d5, 0x10dd, 0x10e6, 0x10ec,
	0x10f5, 0x10fb, 0x10ff, 0x1102, 0x1108, 0x110d, 0x1122, 0x1122,
	0x1126, 0x112b, 0x1130, 0x1136, 0x113c, 0x1141, 0x1146, 0x1146,
	0x1148, 0x114e, 0x1157, 0x115b, 0x1166, 0x116c, 0x1173, 0x1178,
	// Entry 240 - 27F
	0x1181, 0x118a, 0x1191, 0x119b, 0x11a4, 0x11aa, 0x11c8, 0x11cc,
	0x11e8, 0x11ec, 0x1202, 0x1213, 0x1228, 0x123b, 0x124b, 0x125d,
	0x126e, 0x1286, 0x1296, 0x12a8, 0x12b9, 0x12ca, 0x12d3, 0x12e8,
	0x12fa, 0x1301, 0x130d, 0x1320, 0x1333,
}

// Size: 9904 bytes
const jaLangStr = "" +
	"アファル語アブハズ語アヴェスタ語アフリカーンス語アカン語アムハラ語アラゴン語アラビア語アッサム語アヴァル語アイマラ語アゼルバイジャン語バシキール" +
	"語ベラルーシ語ブルガリア語ビスラマ語バンバラ語ベンガル語チベット語ブルトン語ボスニア語カタロニア語チェチェン語チャモロ語コルシカ語クリー語チ" +
	"ェコ語教会スラブ語チュヴァシ語ウェールズ語デンマーク語ドイツ語ディベヒ語ゾンカ語エウェ語ギリシャ語英語エスペラント語スペイン語エストニア語バ" +
	"スク語ペルシア語フラニ語フィンランド語フィジー語フェロー語フランス語西フリジア語アイルランド語スコットランド・ゲール語ガリシア語グアラニー語" +
	"グジャラート語マン島語ハウサ語ヘブライ語ヒンディー語ヒリモツ語クロアチア語ハイチ語ハンガリー語アルメニア語ヘレロ語インターリングアインドネシ" +
	"ア語インターリングイボ語四川イ語イヌピアック語イド語アイスランド語イタリア語イヌクウティトット語日本語ジャワ語グルジア語コンゴ語キクユ語クワ" +
	"ニャマ語カザフ語グリーンランド語クメール語カンナダ語韓国語カヌリ語カシミール語クルド語コミ語コーンウォール語キルギス語ラテン語ルクセンブルク" +
	"語ガンダ語リンブルフ語リンガラ語ラオ語リトアニア語ルバ・カタンガ語ラトビア語マダガスカル語マーシャル語マオリ語マケドニア語マラヤーラム語モン" +
	"ゴル語マラーティー語マレー語マルタ語ビルマ語ナウル語北ンデベレ語ネパール語ンドンガ語オランダ語ノルウェー語(ニーノシュク)ノルウェー語(ブー" +
	"クモール)南ンデベレ語ナバホ語ニャンジャ語オック語オジブウェー語オロモ語オリヤー語オセット語パンジャブ語パーリ語ポーランド語パシュトゥー語ポ" +
	"ルトガル語ケチュア語ロマンシュ語ルンディ語ルーマニア語ロシア語ルワンダ語サンスクリット語サルデーニャ語シンド語北サーミ語サンゴ語シンハラ語ス" +
	"ロバキア語スロベニア語サモア語ショナ語ソマリ語アルバニア語セルビア語スワジ語南部ソト語スンダ語スウェーデン語スワヒリ語タミル語テルグ語タジク" +
	"語タイ語ティグリニア語トルクメン語ツワナ語トンガ語トルコ語ツォンガ語タタール語タヒチ語ウイグル語ウクライナ語ウルドゥー語ウズベク語ベンダ語ベ" +
	"トナム語ヴォラピュク語ワロン語ウォロフ語コサ語イディッシュ語ヨルバ語チワン語中国語ズールー語アチェ語アチョリ語アダングメ語アディゲ語チュニジ" +
	"ア・アラビア語アフリヒリ語アゲム語アイヌ語アッカド語アラバマ語アレウト語ゲグ・アルバニア語南アルタイ語古英語アンギカ語アラム語アラウカン語ア" +
	"ラオナ語アラパホー語アルジェリア・アラビア語アラワク語モロッコ・アラビア語エジプト・アラビア語アス語アメリカ手話アストゥリアス語コタヴァアワ" +
	"ディー語南アゼルバイジャン語バルーチー語バリ語バサ語バムン語トバ・バタク語ゴーマラ語ベジャ語ベンバ語ベタウィ語ベナ語バフット語バダガ語ボージ" +
	"ュプリー語ビコル語ビニ語バンジャル語コム語シクシカ語ビシュヌプリヤ・マニプリ語バフティヤーリー語ブラジ語ブラフイ語ボド語アコース語ブリヤート" +
	"語ブギ語ブル語ビリン語メドゥンバ語カドー語カリブ語カユーガ語チャワイ語セブアノ語チガ語チブチャ語チャガタイ語チューク語マリ語チヌーク混成語チ" +
	"ョクトー語チペワイアン語チェロキー語シャイアン語クルド語(ソラニー)コプト語カピス語クリミア・タタール語カシューブ語ダコタ語ダルガン語タイタ" +
	"語デラウェア語スレイビー語ドグリブ語ディンカ語ザルマ語ドーグリー語低ソルビア語中央ドゥスン語ドゥアラ語中世オランダ語ジョラ＝フォニィ語ジュラ" +
	"語ダザガ語エンブ語エフィク語エミリア語古代エジプト語エカジュク語エラム語中英語中央アラスカ・ユピック語エウォンド語エストレマドゥーラ語ファン" +
	"グ語フィリピノ語トルネダール・フィンランド語フォン語ケイジャン・フランス語中期フランス語古フランス語アルピタン語北フリジア語東フリジア語フリ" +
	"ウリ語ガ語ガガウズ語贛語ガヨ語バヤ語ダリー語(ゾロアスター教)ゲエズ語キリバス語ギラキ語中高ドイツ語古高ドイツ語ゴア・コンカニ語ゴーンディー" +
	"語ゴロンタロ語ゴート語グレボ語古代ギリシャ語スイスドイツ語ワユ語フラフラ語グシイ語グウィッチン語ハイダ語客家語ハワイ語フィジー・ヒンディー語" +
	"ヒリガイノン語ヒッタイト語フモン語上ソルビア語湘語アタパスカ語イバン語イビビオ語イロカノ語イングーシ語イングリア語ジャマイカ・クレオール語ロ" +
	"ジバン語ンゴンバ語マチャメ語ユダヤ・ペルシア語ユダヤ・アラビア語ユトランド語カラカルパク語カビル語カチン語カジェ語カンバ語カウィ語カバルド語" +
	"カネンブ語カタブ語マコンデ語カーボベルデ・クレオール語ニャン語コロ語カインガング語カシ語コータン語コイラ・チーニ語コワール語キルマンジュキ語" +
	"カコ語カレンジン語キンブンド語コミ・ペルミャク語コンカニ語コスラエ語クペレ語カラチャイ語クリオ語キナライア語カレリア語クルク語サンバー語バフ" +
	"ィア語ケルン語クムク語クテナイ語ラディノ語ランギ語ラフンダー語ランバ語レズギ語リングア・フランカ・ノバリグリア語リヴォニア語ラコタ語ロンバル" +
	"ド語モンゴ語ロジ語ラトガリア語ルバ・ルルア語ルイセーニョ語ルンダ語ルオ語ルシャイ語ルヒヤ語漢文ラズ語マドゥラ語マファ語マガヒー語マイティリー" +
	"語マカッサル語マンディンゴ語マサイ語マバ語モクシャ語マンダル語メンデ語メル語モーリシャス・クレオール語中期アイルランド語マクア・ミート語メタ" +
	"語ミクマク語ミナンカバウ語満州語マニプリ語モーホーク語モシ語山地マリ語ムンダン語複数言語クリーク語ミランダ語マールワーリー語メンタワイ語ミエ" +
	"ネ語エルジャ語マーザンダラーン語閩南語ナポリ語ナマ語低地ドイツ語ネワール語ニアス語ニウーエイ語アオ・ナガ語クワシオ語ンジエムブーン語ノガイ語" +
	"古ノルド語ンコ語北部ソト語ヌエル語古典ネワール語ニャムウェジ語ニャンコレ語ニョロ語ンゼマ語オセージ語オスマントルコ語パンガシナン語パフラヴィ" +
	"ー語パンパンガ語パピアメント語パラオ語ピカルディ語ペンシルベニア・ドイツ語メノナイト低地ドイツ語古代ペルシア語プファルツ語フェニキア語ピエモ" +
	"ンテ語ポントス・ギリシャ語ポンペイ語プロシア語古期プロバンス語キチェ語チンボラソ高地ケチュア語ラージャスターン語ラパヌイ語ラロトンガ語ロマー" +
	"ニャ語リーフ語ロンボ語ロマーニー語ロツマ語ルシン語ロヴィアナ語アルーマニア語ルワ語サンダウェ語ヤクート語サマリア・アラム語サンブル語ササク語" +
	"サンターリー語サウラーシュトラ語ンガムバイ語サング語シチリア語スコットランド語サッサリ・サルデーニャ語セネカ語セナ語セリ語セリクプ語コイラボ" +
	"ロ・センニ語古期アイルランド語サモギティア語)タシルハイト語シャン語チャド・アラビア語シダモ語低シレジア語スラヤール語南サーミ語ルレ・サーミ" +
	"語イナリ・サーミ語スコルト・サーミ語ソニンケ語ソグド語スリナム語セレル語サホ語ザーターフリジア語スクマ語スス語シュメール語コモロ語コンゴ・ス" +
	"ワヒリ語古典シリア語シリア語シレジア語トゥル語テムネ語テソ語テレーノ語テトゥン語ティグレ語ティブ語トケラウ語ツァフル語クリンゴン語トリンギッ" +
	"ト語タリシュ語タマシェク語トンガ語(ニアサ)トク・ピシン語トゥロヨ語タロコ語ツァコン語チムシュ語ムスリム・タタール語トゥンブカ語ツバル語タサ" +
	"ワク語トゥヴァ語中央アトラス・タマジクト語ウドムルト語ウガリト語ムブンドゥ語ルートヴァイ語ヴェネト語ヴェプス語西フラマン語マインフランク語ヴ" +
	"ォート語ヴォロ語ヴンジョ語ヴァリス語ウォライタ語ワライ語ワショ語呉語カルムイク語メグレル語ソガ語ヤオ語ヤップ語ヤンベン語イエンバ語ニェエンガ" +
	"トゥ語広東語サポテカ語ブリスシンボルゼーラント語ゼナガ語タマージク語(モロッコ公用語)ズニ語言語的内容なしザザ語現代標準アラビア語標準ドイツ" +
	"語(スイス)オーストラリア英語カナダ英語イギリス英語アメリカ英語スペイン語(イベリア半島)フレミッシュ語ポルトガル語(イベリア半島)モルダビ" +
	"ア語セルボ・クロアチア語簡体中国語繁体中国語"

// Size: 1234 bytes, 605 elements
var jaLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000f, 0x001e, 0x0030, 0x0048, 0x0054, 0x0063, 0x0072,
	0x0081, 0x0090, 0x009f, 0x00ae, 0x00c9, 0x00db, 0x00ed, 0x00ff,
	0x010e, 0x011d, 0x012c, 0x013b, 0x014a, 0x0159, 0x016b, 0x017d,
	0x018c, 0x019b, 0x01a7, 0x01b3, 0x01c5, 0x01d7, 0x01e9, 0x01fb,
	0x0207, 0x0216, 0x0222, 0x022e, 0x023d, 0x0243, 0x0258, 0x0267,
	0x0279, 0x0285, 0x0294, 0x02a0, 0x02b5, 0x02c4, 0x02d3, 0x02e2,
	0x02f4, 0x0309, 0x032d, 0x033c, 0x034e, 0x0363, 0x036f, 0x037b,
	0x038a, 0x039c, 0x03ab, 0x03bd, 0x03c9, 0x03db, 0x03ed, 0x03f9,
	// Entry 40 - 7F
	0x0411, 0x0426, 0x043b, 0x0444, 0x0450, 0x0465, 0x046e, 0x0483,
	0x0492, 0x04b0, 0x04b9, 0x04c5, 0x04d4, 0x04e0, 0x04ec, 0x04fe,
	0x050a, 0x0522, 0x0531, 0x0540, 0x0549, 0x0555, 0x0567, 0x0573,
	0x057c, 0x0594, 0x05a3, 0x05af, 0x05c7, 0x05d3, 0x05e5, 0x05f4,
	0x05fd, 0x060f, 0x0627, 0x0636, 0x064b, 0x065d, 0x0669, 0x067b,
	0x0690, 0x069f, 0x06b4, 0x06c0, 0x06cc, 0x06d8, 0x06e4, 0x06f6,
	0x0705, 0x0714, 0x0723, 0x0749, 0x076f, 0x0781, 0x078d, 0x079f,
	0x07ab, 0x07c0, 0x07cc, 0x07db, 0x07ea, 0x07fc, 0x0808, 0x081a,
	// Entry 80 - BF
	0x082f, 0x0841, 0x0850, 0x0862, 0x0871, 0x0883, 0x088f, 0x089e,
	0x08b6, 0x08cb, 0x08d7, 0x08e6, 0x08f2, 0x0901, 0x0913, 0x0925,
	0x0931, 0x093d, 0x0949, 0x095b, 0x096a, 0x0976, 0x0985, 0x0991,
	0x09a6, 0x09b5, 0x09c1, 0x09cd, 0x09d9, 0x09e2, 0x09f7, 0x0a09,
	0x0a15, 0x0a21, 0x0a2d, 0x0a3c, 0x0a4b, 0x0a57, 0x0a66, 0x0a78,
	0x0a8a, 0x0a99, 0x0aa5, 0x0ab4, 0x0ac9, 0x0ad5, 0x0ae4, 0x0aed,
	0x0b02, 0x0b0e, 0x0b1a, 0x0b23, 0x0b32, 0x0b3e, 0x0b4d, 0x0b5f,
	0x0b6e, 0x0b8f, 0x0ba1, 0x0bad, 0x0bb9, 0x0bc8, 0x0bd7, 0x0be6,
	// Entry C0 - FF
	0x0c01, 0x0c13, 0x0c1c, 0x0c2b, 0x0c37, 0x0c49, 0x0c58, 0x0c6a,
	0x0c8e, 0x0c9d, 0x0cbb, 0x0cd9, 0x0ce2, 0x0cf4, 0x0d0c, 0x0d18,
	0x0d2a, 0x0d48, 0x0d5a, 0x0d63, 0x0d63, 0x0d6c, 0x0d78, 0x0d8d,
	0x0d9c, 0x0da8, 0x0db4, 0x0dc3, 0x0dcc, 0x0ddb, 0x0de7, 0x0dff,
	0x0e0b, 0x0e14, 0x0e26, 0x0e2f, 0x0e3e, 0x0e65, 0x0e80, 0x0e8c,
	0x0e9b, 0x0ea4, 0x0eb3, 0x0ec5, 0x0ece, 0x0ed7, 0x0ee3, 0x0ef5,
	0x0f01, 0x0f0d, 0x0f1c, 0x0f2b, 0x0f3a, 0x0f43, 0x0f52, 0x0f64,
	0x0f73, 0x0f7c, 0x0f91, 0x0fa3, 0x0fb8, 0x0fca, 0x0fdc, 0x0ff6,
	// Entry 100 - 13F
	0x1002, 0x100e, 0x102c, 0x103e, 0x104a, 0x1059, 0x1065, 0x1077,
	0x1089, 0x1098, 0x10a7, 0x10b3, 0x10c5, 0x10d7, 0x10ec, 0x10fb,
	0x1110, 0x112b, 0x1137, 0x1143, 0x114f, 0x115e, 0x116d, 0x1182,
	0x1194, 0x11a0, 0x11a9, 0x11cd, 0x11df, 0x11fd, 0x120c, 0x121e,
	0x1248, 0x1254, 0x1275, 0x128a, 0x129c, 0x12ae, 0x12c0, 0x12d2,
	0x12e1, 0x12e7, 0x12f6, 0x12fc, 0x1305, 0x130e, 0x1331, 0x133d,
	0x134c, 0x1358, 0x136a, 0x137c, 0x1394, 0x13a9, 0x13bb, 0x13c7,
	0x13d3, 0x13e8, 0x13fd, 0x1406, 0x1415, 0x1421, 0x1436, 0x1442,
	// Entry 140 - 17F
	0x144b, 0x1457, 0x1478, 0x148d, 0x149f, 0x14ab, 0x14bd, 0x14c3,
	0x14d5, 0x14e1, 0x14f0, 0x14ff, 0x1511, 0x1523, 0x1547, 0x1556,
	0x1565, 0x1574, 0x158f, 0x15aa, 0x15bc, 0x15d1, 0x15dd, 0x15e9,
	0x15f5, 0x1601, 0x160d, 0x161c, 0x162b, 0x1637, 0x1646, 0x166d,
	0x1679, 0x1682, 0x1697, 0x16a0, 0x16af, 0x16c7, 0x16d6, 0x16ee,
	0x16f7, 0x1709, 0x171b, 0x1736, 0x1745, 0x1754, 0x1760, 0x1772,
	0x177e, 0x1790, 0x179f, 0x17ab, 0x17ba, 0x17c9, 0x17d5, 0x17e1,
	0x17f0, 0x17ff, 0x180b, 0x181d, 0x1829, 0x1835, 0x1859, 0x1868,
	// Entry 180 - 1BF
	0x187a, 0x1886, 0x1898, 0x18a4, 0x18ad, 0x18bf, 0x18d4, 0x18e9,
	0x18f5, 0x18fe, 0x190d, 0x1919, 0x191f, 0x1928, 0x1937, 0x1943,
	0x1952, 0x1967, 0x1979, 0x198e, 0x199a, 0x19a3, 0x19b2, 0x19c1,
	0x19cd, 0x19d6, 0x19fd, 0x1a18, 0x1a30, 0x1a39, 0x1a48, 0x1a5d,
	0x1a66, 0x1a75, 0x1a87, 0x1a90, 0x1a9f, 0x1aae, 0x1aba, 0x1ac9,
	0x1ad8, 0x1af0, 0x1b02, 0x1b0e, 0x1b1d, 0x1b38, 0x1b41, 0x1b4d,
	0x1b56, 0x1b68, 0x1b77, 0x1b83, 0x1b95, 0x1ba7, 0x1bb6, 0x1bce,
	0x1bda, 0x1be9, 0x1be9, 0x1bf2, 0x1c01, 0x1c0d, 0x1c22, 0x1c37,
	// Entry 1C0 - 1FF
	0x1c49, 0x1c55, 0x1c61, 0x1c70, 0x1c88, 0x1c9d, 0x1cb2, 0x1cc4,
	0x1cd9, 0x1ce5, 0x1cf7, 0x1d1b, 0x1d3c, 0x1d51, 0x1d63, 0x1d75,
	0x1d87, 0x1da5, 0x1db4, 0x1dc3, 0x1ddb, 0x1de7, 0x1e0b, 0x1e26,
	0x1e35, 0x1e47, 0x1e59, 0x1e65, 0x1e71, 0x1e83, 0x1e8f, 0x1e9b,
	0x1ead, 0x1ec2, 0x1ecb, 0x1edd, 0x1eec, 0x1f07, 0x1f16, 0x1f22,
	0x1f37, 0x1f52, 0x1f64, 0x1f70, 0x1f7f, 0x1f97, 0x1fbb, 0x1fc7,
	0x1fd0, 0x1fd9, 0x1fe8, 0x2006, 0x2021, 0x2037, 0x204c, 0x2058,
	0x2073, 0x207f, 0x2091, 0x20a3, 0x20b2, 0x20c7, 0x20df, 0x20fa,
	// Entry 200 - 23F
	0x2109, 0x2115, 0x2124, 0x2130, 0x2139, 0x2154, 0x2160, 0x2169,
	0x217b, 0x2187, 0x21a2, 0x21b4, 0x21c0, 0x21cf, 0x21db, 0x21e7,
	0x21f0, 0x21ff, 0x220e, 0x221d, 0x2229, 0x2238, 0x2247, 0x2259,
	0x226e, 0x227d, 0x228f, 0x22a6, 0x22bb, 0x22ca, 0x22d6, 0x22e5,
	0x22f4, 0x2312, 0x2324, 0x2330, 0x233f, 0x234e, 0x2375, 0x2387,
	0x2396, 0x23a8, 0x23b1, 0x23bd, 0x23cc, 0x23db, 0x23ed, 0x2405,
	0x2414, 0x2420, 0x242f, 0x243e, 0x2450, 0x245c, 0x2468, 0x2468,
	0x246e, 0x2480, 0x248f, 0x2498, 0x24a1, 0x24ad, 0x24bc, 0x24cb,
	// Entry 240 - 27F
	0x24e3, 0x24ec, 0x24fb, 0x2510, 0x2522, 0x252e, 0x2557, 0x2560,
	0x2575, 0x257e, 0x2599, 0x2599, 0x25b6, 0x25d1, 0x25e0, 0x25f2,
	0x2604, 0x2604, 0x2627, 0x2627, 0x2627, 0x2627, 0x263c, 0x263c,
	0x2662, 0x2674, 0x2692, 0x26a1, 0x26b0,
}

// Size: 9856 bytes
const kaLangStr = "" +
	"აფარიაფხაზურიავესტურიაფრიკაანსიაკანიამჰარულიარაგონულიარაბულიასამურიაიმარ" +
	"ააზერბაიჯანულიბაშკირულიბელორუსულიბულგარულიბამბარაბენგალურიტიბეტურიბრეტ" +
	"ონულიბოსნიურიკატალანურიჩეჩნურიკორსიკულიკრიჩეხურისაეკლესიო სლავურიჩუვაშ" +
	"ურიუელსურიდანიურიგერმანულიდივეჰიძონგკხაევებერძნულიინგლისურიესპერანტოეს" +
	"პანურიესტონურიბასკურისპარსულიფინურიფიჯიფარერულიფრანგულიდასავლეთფრიზიულ" +
	"იირლანდიურიშოტლანდიური გელურიგალისიურიგუარანიგუჯარათიმენურიჰაუსაებრაულ" +
	"იჰინდიხორვატულიჰაიტიურიუნგრულისომხურიინტერლინგუალურიინდონეზიურიინტერლი" +
	"ნგიიგბოსიჩუანის იიდოისლანდიურიიტალიურიინუკტიტუტიიაპონურიიავურიქართულიკ" +
	"ონგოკიკუიუყაზახურიდასავლეთ გრენლანდიურიქმერულიკანადაკორეულიკანურიქაშმი" +
	"რულიქურთულიკომიკორნულიყირგიზულილათინურილუქსემბურგულიგანდალიმბურგულილინ" +
	"გალალაოსურილიტვურილუბა-კატანგალატვიურიმალაგასიურიმაორიმაკედონურიმალაია" +
	"ლამურიმონღოლურიმარათჰიმალაიურიმალტურიბირმულინაურუჩრდილოეთ ნდებელენეპალ" +
	"ურინიდერლანდურინორვეგიული ნიუნორსკინორვეგიული ბუკმოლინავახონიანჯაოქსიტ" +
	"ანურიოჯიბვეორომოორიაოსურიპენჯაბურიპალიპოლონურიპუშტუპორტუგალიურიკეჩუარე" +
	"ტორომანულირუნდირუმინულირუსულიკინიარუანდასანსკრიტისარდინიულისინდჰურიჩრდ" +
	"ილოეთ საამურისანგოსინჰალურისლოვაკურისლოვენურისამოაშონასომალიურიალბანურ" +
	"ისერბულისამხრეთ სოთოს ენასუნდურიშვედურისუაჰილიტამილურიტელუგუტაჯიკურიტა" +
	"ითიგრინიათურქმენულიტსვანატონგანურითურქულითათრულიუიღურულიუკრაინულიურდუუ" +
	"ზბეკურივიეტნამურივოლოფურიქჰოსაიდიშიიორუბაჩინურიზულუაჩეხურიაჩოლიადანგმე" +
	"ადიღეურიაღემიაინუურიაქადურიალეუტურისამხრეთ ალთაურიძველი ინგლისურიანგიკ" +
	"აარამეულიმაპუდუნგუნიარაპაჰოარავაკიასუასტურიულიავადიბელუჯიბალინურიბასაბ" +
	"ამუნიბეჯაბემბაბენაბოჯპურიბრაჯიბოდობურიატულიბილინიკაიუგაჩიგაჩიბჩამარიულ" +
	"იჩეროკისორანი ქურთულიკოპტურიყირიმულ-თურქულიკაშუბურიდაკოტადარგუულიტაიტა" +
	"დელავარულიდოგრიბიდინკაზარმადოგრიქვემოსორბულიდუალადიოლადიულაემბუეფიკიძვ" +
	"ელეგვიპტურიევონდოფილიპინურიფონიძველი ფრანგულიჩრდილოფრიზიულიაღმოსავლეთფ" +
	"რიზიულიფრიულურიგაგაუზურიგბაიაგეეზიძველი ზემოგერმანულიგონდიგოთურიძველი " +
	"ბერძნულიშვეიცარიული გერმანულიგუსიიჰავაიურიხეთური ენაზემოსორბულიიბანიიბ" +
	"იბიოინგუშურილოჟბანინგომბაკიმაშამიიუდეო-სპარსულიიუდეო-არაბულიყარაყალფახ" +
	"ურიკაბილურიკაჩინიკამბაყაბარდოულიმაკონდეკაბუვერდიანუკოირა-ჩიინიკალენჯინ" +
	"იკიმბუნდუკომი-პერმიაკულიკონკანიკპელეყარაჩაულ-ბალყარულიკარელიურიკურუქიშ" +
	"ამბალაბაფიაყუმუხურიკუტენაილადინოლანგილანდალამბალეზგიურილაკოტამონგოლოზი" +
	"ლუისენიოლუნდალუომიზოლუჰიამაფამაგაჰიმაითილიმასაიმაბამოქშამენდემერუმორის" +
	"იენიმაქუვა-მეეტომეტა’ ენამანჯურიულიმანიპურიმოჰაუკურიმუნდანგიკრიკიმირან" +
	"დულიმარვარიმიენეერზიანეაპოლიტანურინამანევარიკვასიონოღაურიძველსკანდინავ" +
	"იურინკონუერიკლასიკური ნევარულინიამვეზინიანკოლენიორონზიმაფალაურიძველი ს" +
	"პარსულიფინიკიურიძველი პროვანსულიკიჩერაჯასთანირაპანუირაროტონგულირომბობო" +
	"შურირუაიაკუტურისამარიულ-არამეულისამბურუსანგუსიცილიურისენეკასენასელკუპუ" +
	"რიკოირაბორო-სენიძველი ირლანდიურიშილჰაშანიჩადური არაბულისამხრეთ საამური" +
	"ლულე-საამურიინარი-საამურისკოლტ-საამურიშუმერულიკომორულიკონგოს სუაჰილიკლ" +
	"ასიკური სირიულისირიულიტესოთიგრეკლინგონიტასავაქიტუვაცენტრალური მოროკოს " +
	"ტამაზიგხტიუდმურტულიუგარითულიუცნობი ენავაივუნჯოველაითაყალმუხურისოგაკანტ" +
	"ონურიბლისსიმბოლოებიზენაგასტანდარტული მაროკოული ტამაზიგხტილინგვისტური შ" +
	"იგთავსი არ არისზაზაკითანამედროვე სტანდარტული არაბულიავსტრიული გერმანულ" +
	"იშვეიცარიული ზემოგერმანულიავსტრალიური ინგლისურიკანადური ინგლისურიბრიტა" +
	"ნული ინგლისურიამერიკული ინგლისურილათინურ ამერიკული ესპანურიევროპული ეს" +
	"პანურიმექსიკური ესპანურიკანადური ფრანგულიშვეიცარიული ფრანგულიფლამანდიუ" +
	"რიბრაზილიური პორტუგალიურიევროპული პორტუგალიურიმოლდავურისერბულ-ხორვატულ" +
	"იგამარტივებული ჩინურიტრადიციული ჩინური"

// Size: 1234 bytes, 605 elements
var kaLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000f, 0x0027, 0x003f, 0x005d, 0x006c, 0x0084, 0x009f,
	0x00b4, 0x00c9, 0x00c9, 0x00db, 0x0102, 0x011d, 0x013b, 0x0156,
	0x0156, 0x016b, 0x0186, 0x019e, 0x01b9, 0x01d1, 0x01ef, 0x0204,
	0x0204, 0x021f, 0x0228, 0x023a, 0x026b, 0x0283, 0x0298, 0x02ad,
	0x02c8, 0x02da, 0x02ef, 0x02f8, 0x0310, 0x032b, 0x0346, 0x035e,
	0x0376, 0x038b, 0x03a3, 0x03a3, 0x03b5, 0x03c1, 0x03d9, 0x03f1,
	0x0421, 0x043f, 0x0473, 0x048e, 0x04a3, 0x04bb, 0x04cd, 0x04dc,
	0x04f1, 0x0500, 0x0500, 0x051b, 0x0533, 0x0548, 0x055d, 0x055d,
	// Entry 40 - 7F
	0x058a, 0x05ab, 0x05c9, 0x05d5, 0x05f1, 0x05f1, 0x05fa, 0x0618,
	0x0630, 0x064e, 0x0666, 0x0678, 0x068d, 0x069c, 0x06ae, 0x06ae,
	0x06c6, 0x0703, 0x0718, 0x072a, 0x073f, 0x0751, 0x076c, 0x0781,
	0x078d, 0x07a2, 0x07bd, 0x07d5, 0x07fc, 0x080b, 0x0829, 0x083e,
	0x0853, 0x0868, 0x088a, 0x08a2, 0x08c3, 0x08c3, 0x08d2, 0x08f0,
	0x0914, 0x092f, 0x0944, 0x095c, 0x0971, 0x0986, 0x0995, 0x09c3,
	0x09db, 0x09db, 0x09ff, 0x0a39, 0x0a6d, 0x0a6d, 0x0a7f, 0x0a91,
	0x0aaf, 0x0ac1, 0x0ad0, 0x0adc, 0x0aeb, 0x0b06, 0x0b12, 0x0b2a,
	// Entry 80 - BF
	0x0b39, 0x0b5d, 0x0b6c, 0x0b90, 0x0b9f, 0x0bb7, 0x0bc9, 0x0bea,
	0x0c05, 0x0c23, 0x0c3b, 0x0c69, 0x0c78, 0x0c93, 0x0cae, 0x0cc9,
	0x0cd8, 0x0ce4, 0x0cff, 0x0d17, 0x0d2c, 0x0d2c, 0x0d5b, 0x0d70,
	0x0d85, 0x0d9a, 0x0db2, 0x0dc4, 0x0ddc, 0x0de5, 0x0dfd, 0x0e1b,
	0x0e2d, 0x0e48, 0x0e5d, 0x0e5d, 0x0e72, 0x0e72, 0x0e8a, 0x0ea5,
	0x0eb1, 0x0ec9, 0x0ec9, 0x0ee7, 0x0ee7, 0x0ee7, 0x0eff, 0x0f0e,
	0x0f1d, 0x0f2f, 0x0f2f, 0x0f41, 0x0f4d, 0x0f62, 0x0f71, 0x0f86,
	0x0f9e, 0x0f9e, 0x0f9e, 0x0fad, 0x0fc2, 0x0fd7, 0x0fd7, 0x0fef,
	// Entry C0 - FF
	0x0fef, 0x101a, 0x1045, 0x1057, 0x106f, 0x1090, 0x1090, 0x10a5,
	0x10a5, 0x10ba, 0x10ba, 0x10ba, 0x10c3, 0x10c3, 0x10de, 0x10de,
	0x10ed, 0x10ed, 0x10ff, 0x1117, 0x1117, 0x1123, 0x1135, 0x1135,
	0x1135, 0x1141, 0x1150, 0x1150, 0x115c, 0x115c, 0x115c, 0x1171,
	0x1171, 0x1171, 0x1171, 0x1171, 0x1171, 0x1171, 0x1171, 0x1180,
	0x1180, 0x118c, 0x118c, 0x11a7, 0x11a7, 0x11a7, 0x11b9, 0x11b9,
	0x11b9, 0x11b9, 0x11cb, 0x11cb, 0x11cb, 0x11d7, 0x11e6, 0x11e6,
	0x11e6, 0x11fb, 0x11fb, 0x11fb, 0x11fb, 0x120d, 0x120d, 0x1235,
	// Entry 100 - 13F
	0x124a, 0x124a, 0x1275, 0x128d, 0x129f, 0x12b7, 0x12c6, 0x12e4,
	0x12e4, 0x12f9, 0x1308, 0x1317, 0x1326, 0x134a, 0x134a, 0x1359,
	0x1359, 0x1368, 0x1377, 0x1377, 0x1383, 0x1392, 0x1392, 0x13b9,
	0x13b9, 0x13b9, 0x13b9, 0x13b9, 0x13cb, 0x13cb, 0x13cb, 0x13e9,
	0x13e9, 0x13f5, 0x13f5, 0x13f5, 0x141d, 0x141d, 0x1447, 0x147d,
	0x1495, 0x1495, 0x14b0, 0x14b0, 0x14b0, 0x14bf, 0x14bf, 0x14ce,
	0x14ce, 0x14ce, 0x14ce, 0x1505, 0x1505, 0x1514, 0x1514, 0x1526,
	0x1526, 0x154e, 0x158b, 0x158b, 0x158b, 0x159a, 0x159a, 0x159a,
	// Entry 140 - 17F
	0x159a, 0x15b2, 0x15b2, 0x15b2, 0x15ce, 0x15ce, 0x15ef, 0x15ef,
	0x15ef, 0x15fe, 0x1610, 0x1610, 0x1628, 0x1628, 0x1628, 0x163d,
	0x164f, 0x1667, 0x168f, 0x16b4, 0x16b4, 0x16db, 0x16f3, 0x1705,
	0x1705, 0x1714, 0x1714, 0x1732, 0x1732, 0x1732, 0x1747, 0x176b,
	0x176b, 0x176b, 0x176b, 0x176b, 0x176b, 0x178a, 0x178a, 0x178a,
	0x178a, 0x17a5, 0x17bd, 0x17e8, 0x17fd, 0x17fd, 0x180c, 0x1840,
	0x1840, 0x1840, 0x185b, 0x186d, 0x1882, 0x1891, 0x1891, 0x18a9,
	0x18be, 0x18d0, 0x18df, 0x18ee, 0x18fd, 0x1915, 0x1915, 0x1915,
	// Entry 180 - 1BF
	0x1915, 0x1927, 0x1927, 0x1936, 0x1942, 0x1942, 0x1942, 0x195a,
	0x1969, 0x1972, 0x197e, 0x198d, 0x198d, 0x198d, 0x198d, 0x1999,
	0x19ab, 0x19c0, 0x19c0, 0x19c0, 0x19cf, 0x19db, 0x19ea, 0x19ea,
	0x19f9, 0x1a05, 0x1a20, 0x1a20, 0x1a42, 0x1a5b, 0x1a5b, 0x1a5b,
	0x1a79, 0x1a91, 0x1aac, 0x1aac, 0x1aac, 0x1ac4, 0x1ac4, 0x1ad3,
	0x1aee, 0x1b03, 0x1b03, 0x1b12, 0x1b21, 0x1b21, 0x1b21, 0x1b48,
	0x1b54, 0x1b54, 0x1b66, 0x1b66, 0x1b66, 0x1b66, 0x1b78, 0x1b78,
	0x1b8d, 0x1bc0, 0x1bc0, 0x1bc9, 0x1bc9, 0x1bd8, 0x1c0c, 0x1c24,
	// Entry 1C0 - 1FF
	0x1c3c, 0x1c4b, 0x1c5a, 0x1c5a, 0x1c5a, 0x1c5a, 0x1c6f, 0x1c6f,
	0x1c6f, 0x1c6f, 0x1c6f, 0x1c6f, 0x1c6f, 0x1c97, 0x1c97, 0x1cb2,
	0x1cb2, 0x1cb2, 0x1cb2, 0x1cb2, 0x1ce0, 0x1cec, 0x1cec, 0x1d07,
	0x1d1c, 0x1d3d, 0x1d3d, 0x1d3d, 0x1d4c, 0x1d5e, 0x1d5e, 0x1d5e,
	0x1d5e, 0x1d5e, 0x1d67, 0x1d67, 0x1d7f, 0x1db0, 0x1dc5, 0x1dc5,
	0x1dc5, 0x1dc5, 0x1dc5, 0x1dd4, 0x1def, 0x1def, 0x1def, 0x1e01,
	0x1e0d, 0x1e0d, 0x1e28, 0x1e50, 0x1e7e, 0x1e7e, 0x1e8d, 0x1e99,
	0x1ec1, 0x1ec1, 0x1ec1, 0x1ec1, 0x1eec, 0x1f0e, 0x1f33, 0x1f58,
	// Entry 200 - 23F
	0x1f58, 0x1f58, 0x1f58, 0x1f58, 0x1f58, 0x1f58, 0x1f58, 0x1f58,
	0x1f70, 0x1f88, 0x1fb0, 0x1fe1, 0x1ff6, 0x1ff6, 0x1ff6, 0x1ff6,
	0x2002, 0x2002, 0x2002, 0x2011, 0x2011, 0x2011, 0x2011, 0x2029,
	0x2029, 0x2029, 0x2029, 0x2029, 0x2029, 0x2029, 0x2029, 0x2029,
	0x2029, 0x2029, 0x2029, 0x2029, 0x2041, 0x204d, 0x20a0, 0x20bb,
	0x20d6, 0x20d6, 0x20f2, 0x20fb, 0x20fb, 0x20fb, 0x20fb, 0x20fb,
	0x20fb, 0x20fb, 0x210a, 0x210a, 0x211f, 0x211f, 0x211f, 0x211f,
	0x211f, 0x213a, 0x213a, 0x2146, 0x2146, 0x2146, 0x2146, 0x2146,
	// Entry 240 - 27F
	0x2146, 0x2161, 0x2161, 0x218b, 0x218b, 0x219d, 0x21f9, 0x21f9,
	0x2247, 0x2259, 0x22b2, 0x22e9, 0x2332, 0x236f, 0x23a3, 0x23da,
	0x2411, 0x245b, 0x248c, 0x24c0, 0x24f1, 0x252b, 0x254c, 0x258f,
	0x25cc, 0x25e7, 0x2615, 0x264f, 0x2680,
}

// Size: 3974 bytes
const kkLangStr = "" +
	"абхаз тіліафрикаансаканамхарараб тіліассам тіліәзірбайжан тілібашқұрт ті" +
	"лібеларус тіліболгар тілібамбарабенгал тілітибет тілібретон тілібосния " +
	"тілікаталанкорсикан тілічех тіліваллийдатнеміс тілідзонг-кээвегрек тілі" +
	"ағылшын тіліэсперантоиспан тіліэстон тілібаскпарсы тіліфинфиджифарерфра" +
	"нцуз тілібатыс фризирланд тілігалигуаранигуджаратимэнсхаусаивритхиндихо" +
	"рватгаитянвенгерармян тіліиндонез тіліигбосычуан и тіліисландитальян ті" +
	"ліинуктитутжапон тіліявагрузин тілікикуйюқазақ тілікалаалисуткхмерканна" +
	"дакәріс тілікашмир тілікүрд тілікорнишқырғыз тілілатынлюксембурггандали" +
	"нгалалаос тілілитва тілілуба-катангалатыш тілімалагасимаоримакедон тілі" +
	"малайяламмоңғол тілімаратхималаймальтабирмансолтүстік ндебелнепалнидерл" +
	"анд тілінорвегиялық нинорскнорвегиялық букмолоромоорияпенджабполяк тілі" +
	"пуштупортугал тілікечуароманшрундирумынорыс тілікиньяруандасанскритсинд" +
	"хисолтүстік самисангосингалсловаксловеншонасомалиалбансерб тілісуданшве" +
	"дсуахилитамилтелугутәжік тілітайтигриньятүрікментонгантүріктатар тіліұй" +
	"ғыр тіліукраин тіліурдуөзбеквьетнамволофксозайорубақытай тілізулуагхемм" +
	"апучеасубембабенабодо тілікигачероки тілісорани тілітаитазарматөменгі л" +
	"ужица тілідуаладиолаембуфилиппингагаузшвейцариялық неміс тілігусиигавай" +
	"жоғарғы лужицангомбамачамекабилкамбамакондекабувердианакойра чиникаленж" +
	"инкоми-пермь тіліконканишамбалабафиаланги тілілакоталуолухиамасаймерумо" +
	"рисиенмакуа-мееттометамохокимундангнамаквасионконуернианколекичеромбору" +
	"асамбурусангусенакойраборо сенниташелхитоңтүстік саамилуле сааминари са" +
	"амсколт саамконго суахили тілітесотасавакорталық атлас тамасагихт тіліб" +
	"елгісіз тілвайвунджосогамарокколық стандартты тамазигхттілдік мазмұны ж" +
	"оққазіргі стандартты араб тіліавстриялық неміс тілінеміс тілінің швейца" +
	"риялық диалектіавстралиялық ағылшын тіліканадалық ағылшын тілібританиял" +
	"ық ағылшын тіліамерикандық ағылшын тілілатын американдық испан тіліибер" +
	"иялық испан тілімексикалық испан тіліканадалық француз тілішвейцариялық" +
	" француз тіліфламанд тілібразилиялық португал тіліеуропалық португал тіл" +
	"імолдован тіліжеңілдетілген қытай тілідәстүрлі қытай тілі"

// Size: 1234 bytes, 605 elements
var kkLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0000, 0x0013, 0x0013, 0x0025, 0x002d, 0x0037, 0x0037,
	0x0048, 0x005b, 0x005b, 0x005b, 0x0078, 0x008f, 0x00a6, 0x00bb,
	0x00bb, 0x00c9, 0x00de, 0x00f1, 0x0106, 0x011b, 0x0129, 0x0129,
	0x0129, 0x0142, 0x0142, 0x0151, 0x0151, 0x0151, 0x015d, 0x0163,
	0x0176, 0x0176, 0x0185, 0x018b, 0x019c, 0x01b3, 0x01c5, 0x01d8,
	0x01eb, 0x01f3, 0x0206, 0x0206, 0x020c, 0x0216, 0x0220, 0x0237,
	0x024a, 0x025f, 0x025f, 0x0267, 0x0275, 0x0287, 0x028f, 0x0299,
	0x02a3, 0x02ad, 0x02ad, 0x02b9, 0x02c5, 0x02d1, 0x02e4, 0x02e4,
	// Entry 40 - 7F
	0x02e4, 0x02fb, 0x02fb, 0x0303, 0x031b, 0x031b, 0x031b, 0x0327,
	0x033e, 0x0350, 0x0363, 0x0369, 0x037e, 0x037e, 0x038a, 0x038a,
	0x039d, 0x03b1, 0x03bb, 0x03c9, 0x03dc, 0x03dc, 0x03f1, 0x0402,
	0x0402, 0x040e, 0x0423, 0x042d, 0x0441, 0x044b, 0x044b, 0x0459,
	0x046a, 0x047d, 0x0494, 0x04a7, 0x04b7, 0x04b7, 0x04c1, 0x04d8,
	0x04ea, 0x04ff, 0x050d, 0x0517, 0x0523, 0x052f, 0x052f, 0x054e,
	0x0558, 0x0558, 0x0573, 0x0598, 0x05bb, 0x05bb, 0x05bb, 0x05bb,
	0x05bb, 0x05bb, 0x05c5, 0x05cd, 0x05cd, 0x05db, 0x05db, 0x05ee,
	// Entry 80 - BF
	0x05f8, 0x0611, 0x061b, 0x0627, 0x0631, 0x063b, 0x064c, 0x0662,
	0x0672, 0x0672, 0x067e, 0x0699, 0x06a3, 0x06af, 0x06bb, 0x06c7,
	0x06c7, 0x06cf, 0x06db, 0x06e5, 0x06f6, 0x06f6, 0x06f6, 0x0700,
	0x0708, 0x0716, 0x0720, 0x072c, 0x073f, 0x0745, 0x0755, 0x0765,
	0x0765, 0x0771, 0x077b, 0x077b, 0x078e, 0x078e, 0x07a1, 0x07b6,
	0x07be, 0x07c8, 0x07c8, 0x07d6, 0x07d6, 0x07d6, 0x07e0, 0x07ea,
	0x07ea, 0x07f6, 0x07f6, 0x0809, 0x0811, 0x0811, 0x0811, 0x0811,
	0x0811, 0x0811, 0x0811, 0x081b, 0x081b, 0x081b, 0x081b, 0x081b,
	// Entry C0 - FF
	0x081b, 0x081b, 0x081b, 0x081b, 0x081b, 0x0827, 0x0827, 0x0827,
	0x0827, 0x0827, 0x0827, 0x0827, 0x082d, 0x082d, 0x082d, 0x082d,
	0x082d, 0x082d, 0x082d, 0x082d, 0x082d, 0x082d, 0x082d, 0x082d,
	0x082d, 0x082d, 0x0837, 0x0837, 0x083f, 0x083f, 0x083f, 0x083f,
	0x083f, 0x083f, 0x083f, 0x083f, 0x083f, 0x083f, 0x083f, 0x083f,
	0x083f, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850,
	0x0850, 0x0850, 0x0850, 0x0850, 0x0850, 0x0858, 0x0858, 0x0858,
	0x0858, 0x0858, 0x0858, 0x0858, 0x0858, 0x086d, 0x086d, 0x0882,
	// Entry 100 - 13F
	0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x0882, 0x088c, 0x088c,
	0x088c, 0x088c, 0x088c, 0x0896, 0x0896, 0x08ba, 0x08ba, 0x08c4,
	0x08c4, 0x08ce, 0x08ce, 0x08ce, 0x08d6, 0x08d6, 0x08d6, 0x08d6,
	0x08d6, 0x08d6, 0x08d6, 0x08d6, 0x08d6, 0x08d6, 0x08d6, 0x08e6,
	0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08e6,
	0x08e6, 0x08e6, 0x08f2, 0x08f2, 0x08f2, 0x08f2, 0x08f2, 0x08f2,
	0x08f2, 0x08f2, 0x08f2, 0x08f2, 0x08f2, 0x08f2, 0x08f2, 0x08f2,
	0x08f2, 0x08f2, 0x091e, 0x091e, 0x091e, 0x0928, 0x0928, 0x0928,
	// Entry 140 - 17F
	0x0928, 0x0932, 0x0932, 0x0932, 0x0932, 0x0932, 0x094d, 0x094d,
	0x094d, 0x094d, 0x094d, 0x094d, 0x094d, 0x094d, 0x094d, 0x094d,
	0x0959, 0x0965, 0x0965, 0x0965, 0x0965, 0x0965, 0x096f, 0x096f,
	0x096f, 0x0979, 0x0979, 0x0979, 0x0979, 0x0979, 0x0987, 0x099f,
	0x099f, 0x099f, 0x099f, 0x099f, 0x099f, 0x09b2, 0x09b2, 0x09b2,
	0x09b2, 0x09c2, 0x09c2, 0x09de, 0x09ec, 0x09ec, 0x09ec, 0x09ec,
	0x09ec, 0x09ec, 0x09ec, 0x09ec, 0x09fa, 0x0a04, 0x0a04, 0x0a04,
	0x0a04, 0x0a04, 0x0a17, 0x0a17, 0x0a17, 0x0a17, 0x0a17, 0x0a17,
	// Entry 180 - 1BF
	0x0a17, 0x0a23, 0x0a23, 0x0a23, 0x0a23, 0x0a23, 0x0a23, 0x0a23,
	0x0a23, 0x0a29, 0x0a29, 0x0a33, 0x0a33, 0x0a33, 0x0a33, 0x0a33,
	0x0a33, 0x0a33, 0x0a33, 0x0a33, 0x0a3d, 0x0a3d, 0x0a3d, 0x0a3d,
	0x0a3d, 0x0a45, 0x0a55, 0x0a55, 0x0a6c, 0x0a74, 0x0a74, 0x0a74,
	0x0a74, 0x0a74, 0x0a80, 0x0a80, 0x0a80, 0x0a8e, 0x0a8e, 0x0a8e,
	0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e,
	0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0aa2, 0x0aa2,
	0x0aa2, 0x0aa2, 0x0aa2, 0x0aa8, 0x0aa8, 0x0ab0, 0x0ab0, 0x0ab0,
	// Entry 1C0 - 1FF
	0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0,
	0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0,
	0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac8, 0x0ac8, 0x0ac8,
	0x0ac8, 0x0ac8, 0x0ac8, 0x0ac8, 0x0ad2, 0x0ad2, 0x0ad2, 0x0ad2,
	0x0ad2, 0x0ad2, 0x0ad8, 0x0ad8, 0x0ad8, 0x0ad8, 0x0ae6, 0x0ae6,
	0x0ae6, 0x0ae6, 0x0ae6, 0x0af0, 0x0af0, 0x0af0, 0x0af0, 0x0af0,
	0x0af8, 0x0af8, 0x0af8, 0x0b15, 0x0b15, 0x0b15, 0x0b25, 0x0b25,
	0x0b25, 0x0b25, 0x0b25, 0x0b25, 0x0b40, 0x0b51, 0x0b64, 0x0b77,
	// Entry 200 - 23F
	0x0b77, 0x0b77, 0x0b77, 0x0b77, 0x0b77, 0x0b77, 0x0b77, 0x0b77,
	0x0b77, 0x0b77, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
	0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1,
	0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1,
	0x0ba1, 0x0ba1, 0x0ba1, 0x0ba1, 0x0baf, 0x0baf, 0x0be6, 0x0be6,
	0x0be6, 0x0be6, 0x0bfd, 0x0c03, 0x0c03, 0x0c03, 0x0c03, 0x0c03,
	0x0c03, 0x0c03, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f,
	0x0c0f, 0x0c0f, 0x0c0f, 0x0c17, 0x0c17, 0x0c17, 0x0c17, 0x0c17,
	// Entry 240 - 27F
	0x0c17, 0x0c17, 0x0c17, 0x0c17, 0x0c17, 0x0c17, 0x0c53, 0x0c53,
	0x0c75, 0x0c75, 0x0caa, 0x0cd2, 0x0d15, 0x0d45, 0x0d6f, 0x0d9d,
	0x0dcb, 0x0e00, 0x0e26, 0x0e4e, 0x0e78, 0x0ea8, 0x0ebf, 0x0eef,
	0x0f1b, 0x0f34, 0x0f34, 0x0f62, 0x0f86,
}

// Size: 4548 bytes
const kmLangStr = "" +
	"ភាសាអាហ្វារអាប់ខាហ៊្សានភាសាអាវែស្តង់អាហ្វ្រីកាអានAkanអាមហារីចភាសាអារ៉ាហ្" +
	"គោនអារ៉ាប់អាសាមីសភាសាអីម៉ារ៉ាអាហ៊្សែរបែហ្សង់បែស្កឺបេឡារុស្សប៊ុលហ្ការីប" +
	"ាម្បារាបង់ក្លាដែសទីបេប្រីស្តុនបូស្នីកាតាឡានCorsicanឆេកវេលដាណឺម៉ាកអាល្ល" +
	"ឺម៉ង់ភាសាប៊ូតានEweក្រិចអង់គ្លេសអេស្ពេរ៉ាន់តូអេស្ប៉ាញអេស្តូនីបាស្កេភឺសៀ" +
	"នហ្វាំងឡង់ហ៊្វីជីហ្វារូសបារាំងហ្វ្រីស៊ានខាងលិចអៀរឡង់ភាសាហ្កែលិគ (gd)ហ្" +
	"គាលីស្យានហ្គូរ៉ានីហ្កុយ៉ារាទីManxហូសាអ៊ីស្រាអែលហិណ្ឌូក្រូអាតហៃទីហុងគ្រ" +
	"ីអារមេនីឥណ្ឌូណេស៊ីអ៊ីកបូSichuan Yiអ៊ីស្លង់អ៊ីតាលីInuktitutជប៉ុនជ្វាហ្ស" +
	"ក\u200bហ្ស៊ីKikuyuកាហ្សាក់ស្តង់់Kalaallisutខ្មែរកន្នដកូរ៉េកាស្មៀរឃឺដCo" +
	"rnishគៀរហ្គីស្តង់ឡាតំាងលុចហ្សំបួរGandaលីនកាឡាឡាវលីទុយអានីLuba-Katangaឡាត" +
	"វីយ៉ាម៉ាឡាហ្គាស៊ីម៉ោរីម៉ាសេដូនីមលយាល័មម៉ុងហ្គោលីមរាធិម៉ាឡេស៊ីម៉ាល់តាភូ" +
	"មាNorth Ndebeleនេប៉ាល់ហុល្លង់ន័រវែស នីនូសន័រវែស បុកម៉ាល់Oromoអូរីយ៉ាបឹ" +
	"នជាពិប៉ូឡូញបាស្តូព័រទុយហ្កាល់កេទជួអារ៉ូម៉ង់រូន្ឌីរូម៉ានីរុស្ស៊ីKinyarw" +
	"andaសំស្ក្រឹត\u200b\u200bស៊ីន្តីSami ភាគ\u200bខាង\u200bជើងSangoស្រីលង្កា" +
	"ស្លូវ៉ាគីស្លូវ៉ានីភាសាសាមូអាShonaសូម៉ាលីអាល់បានីសើបស៊ូដង់ស៊ុយអែដស្វាហ៊" +
	"ីលីតាមីលតេលុគុតាដហ្សីគីស្តង់ថៃទីរិនយាទួគមេនីស្តង់តុងហ្គោទួរគីតាតារអ៊ុយ" +
	"ហ្គឺរអ៊ុយក្រែនអ៊ូរឌូអ៊ូហ្សបេគីស្តង់វៀតណាមវូឡុហ្វឃសាភាសាយីឌីហ្សយរូបាភាស" +
	"ាចួងចិនសូលូAghemMapucheAsuBembaBenaBodoChigaឆេរូគីសុរ៉ានីTaitaZarmaLow" +
	"er SorbianDualaJola-FonyiEmbuហ្វីលីពីនGagauzអាល្លឺម៉ង ស្វីសGusiiហាវៃUppe" +
	"r SorbianNgombaMachameKabyleKambaMakondeKabuverdianuKoyra ChiiniKalenjin" +
	"Komi-PermyakKonkaniShambalaBafiaLangiLakotaLuoLuyiaMasaiMeruMorisyenMakh" +
	"uwa-MeettoMetaMohawkMundangNamaKwasioN’KoNuerNyankoleKʼicheʼRomboRwaSamb" +
	"uruSanguSenaKoyraboro SenniTachelhitSami ភាគ\u200bខាង\u200bត្បូងLule Sam" +
	"iInari SamiSkolt SamiCongo SwahiliTesoTasawaqAtlas Tamazight កណ្ដាលមិន" +
	"\u200bស្គាល់\u200bភាសាVaiVunjoSogaម៉ារ៉ុកគ្មាន\u200bទិន្នន័យ\u200bភាសាអា" +
	"រ៉ាប់\u200bស្តង់ដារ\u200bទំនើបអាល្លឺម៉ង់ អូទ្រីសអាល្លឺម៉ង់ ស្វីសអង់គ្ល" +
	"េស អូស្ត្រាលីអង់គ្លេស កាណាដាអង់គ្លេស ចក្រភព\u200bអង់គ្លេសអង់គ្លេស អាមេ" +
	"រិកអេស្ប៉ាញ អាមេរីកឡាតាំងអេស្ប៉ាញ អឺរ៉ុបផ្លាមីសព័រទុយហ្គាល់ ប្រេស៊ីលព័" +
	"រទុយហ្គាល់ អឺរ៉ុបភាសាម៉ុលដាវីចិន\u200bអក្សរ\u200bកាត់ចិន\u200bអក្សរ" +
	"\u200bពេញ"

// Size: 1234 bytes, 605 elements
var kmLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0021, 0x0045, 0x006c, 0x0093, 0x0097, 0x00af, 0x00d9,
	0x00ee, 0x0103, 0x0103, 0x0127, 0x0154, 0x0166, 0x0181, 0x019f,
	0x019f, 0x01b7, 0x01d5, 0x01e1, 0x01fc, 0x020e, 0x0223, 0x0223,
	0x0223, 0x022b, 0x022b, 0x0234, 0x0234, 0x0234, 0x023d, 0x0255,
	0x0273, 0x0273, 0x0291, 0x0294, 0x02a3, 0x02bb, 0x02e2, 0x02fa,
	0x0312, 0x0324, 0x0333, 0x0333, 0x034e, 0x0363, 0x0378, 0x038a,
	0x03ba, 0x03cc, 0x03f2, 0x0413, 0x042e, 0x044f, 0x0453, 0x045f,
	0x047d, 0x048f, 0x048f, 0x04a4, 0x04b0, 0x04c5, 0x04da, 0x04da,
	// Entry 40 - 7F
	0x04da, 0x04f8, 0x04f8, 0x050a, 0x0514, 0x0514, 0x0514, 0x052c,
	0x0541, 0x054a, 0x0559, 0x0565, 0x0583, 0x0583, 0x0589, 0x0589,
	0x05b3, 0x05be, 0x05cd, 0x05dc, 0x05eb, 0x05eb, 0x0600, 0x0609,
	0x0609, 0x0610, 0x0634, 0x0646, 0x0664, 0x0669, 0x0669, 0x067e,
	0x0687, 0x06a2, 0x06ae, 0x06c6, 0x06ea, 0x06ea, 0x06f9, 0x0714,
	0x0729, 0x0747, 0x0756, 0x076e, 0x0783, 0x078f, 0x078f, 0x079c,
	0x07b1, 0x07b1, 0x07c6, 0x07e8, 0x0813, 0x0813, 0x0813, 0x0813,
	0x0813, 0x0813, 0x0818, 0x082d, 0x082d, 0x0842, 0x0842, 0x0854,
	// Entry 80 - BF
	0x0866, 0x088a, 0x089f, 0x08b4, 0x08c6, 0x08db, 0x08f0, 0x08fb,
	0x0916, 0x0916, 0x0931, 0x0957, 0x095c, 0x0977, 0x0992, 0x09ad,
	0x09cb, 0x09d0, 0x09e5, 0x09fd, 0x0a06, 0x0a06, 0x0a06, 0x0a18,
	0x0a2d, 0x0a48, 0x0a57, 0x0a69, 0x0a93, 0x0a99, 0x0aae, 0x0ad2,
	0x0ad2, 0x0ae7, 0x0af6, 0x0af6, 0x0b05, 0x0b05, 0x0b20, 0x0b3b,
	0x0b4d, 0x0b7a, 0x0b7a, 0x0b8c, 0x0b8c, 0x0b8c, 0x0ba1, 0x0baa,
	0x0bcb, 0x0bda, 0x0bef, 0x0bf8, 0x0c04, 0x0c04, 0x0c04, 0x0c04,
	0x0c04, 0x0c04, 0x0c04, 0x0c09, 0x0c09, 0x0c09, 0x0c09, 0x0c09,
	// Entry C0 - FF
	0x0c09, 0x0c09, 0x0c09, 0x0c09, 0x0c09, 0x0c10, 0x0c10, 0x0c10,
	0x0c10, 0x0c10, 0x0c10, 0x0c10, 0x0c13, 0x0c13, 0x0c13, 0x0c13,
	0x0c13, 0x0c13, 0x0c13, 0x0c13, 0x0c13, 0x0c13, 0x0c13, 0x0c13,
	0x0c13, 0x0c13, 0x0c18, 0x0c18, 0x0c1c, 0x0c1c, 0x0c1c, 0x0c1c,
	0x0c1c, 0x0c1c, 0x0c1c, 0x0c1c, 0x0c1c, 0x0c1c, 0x0c1c, 0x0c1c,
	0x0c1c, 0x0c20, 0x0c20, 0x0c20, 0x0c20, 0x0c20, 0x0c20, 0x0c20,
	0x0c20, 0x0c20, 0x0c20, 0x0c20, 0x0c20, 0x0c25, 0x0c25, 0x0c25,
	0x0c25, 0x0c25, 0x0c25, 0x0c25, 0x0c25, 0x0c37, 0x0c37, 0x0c4c,
	// Entry 100 - 13F
	0x0c4c, 0x0c4c, 0x0c4c, 0x0c4c, 0x0c4c, 0x0c4c, 0x0c51, 0x0c51,
	0x0c51, 0x0c51, 0x0c51, 0x0c56, 0x0c56, 0x0c63, 0x0c63, 0x0c68,
	0x0c68, 0x0c72, 0x0c72, 0x0c72, 0x0c76, 0x0c76, 0x0c76, 0x0c76,
	0x0c76, 0x0c76, 0x0c76, 0x0c76, 0x0c76, 0x0c76, 0x0c76, 0x0c91,
	0x0c91, 0x0c91, 0x0c91, 0x0c91, 0x0c91, 0x0c91, 0x0c91, 0x0c91,
	0x0c91, 0x0c91, 0x0c97, 0x0c97, 0x0c97, 0x0c97, 0x0c97, 0x0c97,
	0x0c97, 0x0c97, 0x0c97, 0x0c97, 0x0c97, 0x0c97, 0x0c97, 0x0c97,
	0x0c97, 0x0c97, 0x0cc2, 0x0cc2, 0x0cc2, 0x0cc7, 0x0cc7, 0x0cc7,
	// Entry 140 - 17F
	0x0cc7, 0x0cd3, 0x0cd3, 0x0cd3, 0x0cd3, 0x0cd3, 0x0ce0, 0x0ce0,
	0x0ce0, 0x0ce0, 0x0ce0, 0x0ce0, 0x0ce0, 0x0ce0, 0x0ce0, 0x0ce0,
	0x0ce6, 0x0ced, 0x0ced, 0x0ced, 0x0ced, 0x0ced, 0x0cf3, 0x0cf3,
	0x0cf3, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cff, 0x0d0b,
	0x0d0b, 0x0d0b, 0x0d0b, 0x0d0b, 0x0d0b, 0x0d17, 0x0d17, 0x0d17,
	0x0d17, 0x0d1f, 0x0d1f, 0x0d2b, 0x0d32, 0x0d32, 0x0d32, 0x0d32,
	0x0d32, 0x0d32, 0x0d32, 0x0d32, 0x0d3a, 0x0d3f, 0x0d3f, 0x0d3f,
	0x0d3f, 0x0d3f, 0x0d44, 0x0d44, 0x0d44, 0x0d44, 0x0d44, 0x0d44,
	// Entry 180 - 1BF
	0x0d44, 0x0d4a, 0x0d4a, 0x0d4a, 0x0d4a, 0x0d4a, 0x0d4a, 0x0d4a,
	0x0d4a, 0x0d4d, 0x0d4d, 0x0d52, 0x0d52, 0x0d52, 0x0d52, 0x0d52,
	0x0d52, 0x0d52, 0x0d52, 0x0d52, 0x0d57, 0x0d57, 0x0d57, 0x0d57,
	0x0d57, 0x0d5b, 0x0d63, 0x0d63, 0x0d71, 0x0d75, 0x0d75, 0x0d75,
	0x0d75, 0x0d75, 0x0d7b, 0x0d7b, 0x0d7b, 0x0d82, 0x0d82, 0x0d82,
	0x0d82, 0x0d82, 0x0d82, 0x0d82, 0x0d82, 0x0d82, 0x0d82, 0x0d82,
	0x0d86, 0x0d86, 0x0d86, 0x0d86, 0x0d86, 0x0d86, 0x0d8c, 0x0d8c,
	0x0d8c, 0x0d8c, 0x0d8c, 0x0d92, 0x0d92, 0x0d96, 0x0d96, 0x0d96,
	// Entry 1C0 - 1FF
	0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e,
	0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e,
	0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0d9e, 0x0da7, 0x0da7, 0x0da7,
	0x0da7, 0x0da7, 0x0da7, 0x0da7, 0x0dac, 0x0dac, 0x0dac, 0x0dac,
	0x0dac, 0x0dac, 0x0daf, 0x0daf, 0x0daf, 0x0daf, 0x0db6, 0x0db6,
	0x0db6, 0x0db6, 0x0db6, 0x0dbb, 0x0dbb, 0x0dbb, 0x0dbb, 0x0dbb,
	0x0dbf, 0x0dbf, 0x0dbf, 0x0dce, 0x0dce, 0x0dce, 0x0dd7, 0x0dd7,
	0x0dd7, 0x0dd7, 0x0dd7, 0x0dd7, 0x0e03, 0x0e0c, 0x0e16, 0x0e20,
	// Entry 200 - 23F
	0x0e20, 0x0e20, 0x0e20, 0x0e20, 0x0e20, 0x0e20, 0x0e20, 0x0e20,
	0x0e20, 0x0e20, 0x0e2d, 0x0e2d, 0x0e2d, 0x0e2d, 0x0e2d, 0x0e2d,
	0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31,
	0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e31,
	0x0e31, 0x0e31, 0x0e31, 0x0e31, 0x0e38, 0x0e38, 0x0e5a, 0x0e5a,
	0x0e5a, 0x0e5a, 0x0e87, 0x0e8a, 0x0e8a, 0x0e8a, 0x0e8a, 0x0e8a,
	0x0e8a, 0x0e8a, 0x0e8f, 0x0e8f, 0x0e8f, 0x0e8f, 0x0e8f, 0x0e8f,
	0x0e8f, 0x0e8f, 0x0e8f, 0x0e93, 0x0e93, 0x0e93, 0x0e93, 0x0e93,
	// Entry 240 - 27F
	0x0e93, 0x0e93, 0x0e93, 0x0e93, 0x0e93, 0x0e93, 0x0ea8, 0x0ea8,
	0x0ee1, 0x0ee1, 0x0f23, 0x0f57, 0x0f85, 0x0fbc, 0x0fe7, 0x102d,
	0x105b, 0x109b, 0x10c6, 0x10c6, 0x10c6, 0x10c6, 0x10db, 0x1118,
	0x114f, 0x1173, 0x1173, 0x119d, 0x11c4,
}

// Size: 11546 bytes
const knLangStr = "" +
	"ಅಫಾರ್ಅಬ್ಖಾಜಿಯನ್ಅವೆಸ್ಟನ್ಆಫ್ರಿಕಾನ್ಸ್ಅಕಾನ್ಅಂಹರಿಕ್ಅರಗೊನೀಸ್ಅರೇಬಿಕ್ಅಸ್ಸಾಮೀಸ್ಅವ" +
	"ರಿಕ್ಅಯ್ಮಾರಾಅಜೆರ್ಬೈಜಾನಿಬಶ್ಕಿರ್ಬೆಲರೂಸಿಯನ್ಬಲ್ಗೇರಿಯನ್ಬಿಸ್ಲಾಮಾಬಂಬಾರಾಬೆಂಗಾಲಿ" +
	"ಟಿಬೇಟಿಯನ್ಬ್ರೆಟನ್ಬೋಸ್ನಿಯನ್ಕೆಟಲಾನ್ಚೆಚನ್ಕಮೊರೊಕೋರ್ಸಿಕನ್ಕ್ರೀಜೆಕ್ಚರ್ಚ್ ಸ್ಲಾವ" +
	"ಿಕ್ಚುವಾಶ್ವೆಲ್ಶ್ಡ್ಯಾನಿಶ್ಜರ್ಮನ್ದಿವೆಹಿಜೋಂಗ್\u200cಖಾಈವ್ಗ್ರೀಕ್ಇಂಗ್ಲೀಷ್ಎಸ್ಪೆ" +
	"ರಾಂಟೊಸ್ಪ್ಯಾನಿಷ್ಎಸ್ಟೊನಿಯನ್ಬಾಸ್ಕ್ಪರ್ಶಿಯನ್ಫುಲಾಹ್ಫಿನ್ನಿಶ್ಫಿಜಿಯನ್ಫರೋಸಿಫ್ರೆಂ" +
	"ಚ್ಪಶ್ಚಿಮ ಫ್ರಿಸಿಯನ್ಐರಿಷ್ಸ್ಕಾಟಿಶ್ ಗ್ಯಾಲಿಕ್ಗ್ಯಾಲಿಶಿಯನ್ಗೌರಾನಿಗುಜರಾತಿಮ್ಯಾಂಕ" +
	"್ಸ್ಹೌಸಾಹೀಬ್ರ್ಯೂಹಿಂದಿಹಿರಿ ಮೊಟುಕ್ರೊಯೇಶಿಯನ್ಹೈತಿಯನ್ಹಂಗೇರಿಯನ್ಅರ್ಮೇನಿಯನ್ಹೆರೆ" +
	"ರೊಇಂಟರ್\u200cಲಿಂಗ್ವಾಇಂಡೋನೇಶಿಯನ್ಇಂಟರ್ಲಿಂಗ್ಇಗ್ಬೊಸಿಚುಅನ್ ಯಿಇನುಪಿಯಾಕ್ಇಡೊಐಸ" +
	"್ಲಾಂಡಿಕ್ಇಟಾಲಿಯನ್ಇನುಕ್ಟಿಟುಟ್ಜಾಪನೀಸ್ಜಾವಾನೀಸ್ಜಾರ್ಜಿಯನ್ಕೊಂಗೊಕಿಕುಯುಕ್ವಾನ್" +
	"\u200cಯಾಮಾಕಝಕ್ಕಲಾಲ್ಲಿಸುಟ್ಖಮೇರ್ಕನ್ನಡಕೊರಿಯನ್ಕನುರಿಕಾಶ್ಮೀರಿಕುರ್ದಿಷ್ಕೋಮಿಕೋರ್ನ" +
	"ಿಷ್ಕಿರ್ಗಿಜ್ಲ್ಯಾಟಿನ್ಲಕ್ಸಂಬರ್ಗ್ಗಾಂಡಾಲಿಂಬರ್ಗಿಶ್ಲಿಂಗಾಲಲಾವೋಲಿಥುವೇನಿಯನ್ಲೂಬಾ-" +
	"ಕಟಾಂಗಾಲಟ್ವಿಯನ್ಮಲಗಾಸಿಮಾರ್ಶಲ್ಲೀಸ್ಮಾವೋರಿಮೆಸಿಡೋನಿಯನ್ಮಲಯಾಳಂಮಂಗೋಲಿಯನ್ಮರಾಠಿಮಲ" +
	"ಯ್ಮಾಲ್ಟೀಸ್ಬರ್ಮೀಸ್ನೌರುಉತ್ತರ ದೆಬೆಲೆನೇಪಾಳಿಡೋಂಗಾಡಚ್ನಾರ್ವೆಜಿಯನ್ ನೈನೊಸ್ಕ್ನಾರ" +
	"್ವೆಜಿಯನ್ ಬೊಕ್ಮಲ್ದಕ್ಷಿಣ ದೆಬೆಲೆನವಾಜೊನ್ಯಾಂಜಾಒಸಿಟನ್ಒಜಿಬ್ವಾಓರೊಮೋಒರಿಯಾಒಸ್ಸೆಟ" +
	"ಿಕ್ಪಂಜಾಬಿಪಾಲಿಪೋಲಿಶ್ಪಾಷ್ಟೋಪೋರ್ಚುಗೀಸ್ಕ್ವೆಚುವಾರೊಮಾನ್ಷ್ರುಂಡಿರೊಮೇನಿಯನ್ರಷ್ಯನ" +
	"್ಕೀನ್ಯಾರುವಾಂಡಾಸಂಸ್ಕೃತಸರ್ಡೀನಿಯನ್ಸಿಂಧಿಉತ್ತರ ಸಾಮಿಸಾಂಗೋಸಿಂಹಳಸ್ಲೋವಾಕ್ಸ್ಲೋವೇ" +
	"ನಿಯನ್ಸಮೋವನ್ಶೋನಾಸೊಮಾಲಿಅಲ್ಬೇನಿಯನ್ಸರ್ಬಿಯನ್ಸ್ವಾತಿದಕ್ಷಿಣ ಸೋಥೋಸುಂಡಾನೀಸ್ಸ್ವೀಡ" +
	"ಿಷ್ಸ್ವಹಿಲಿತಮಿಳುತೆಲುಗುತಾಜಿಕ್ಥಾಯ್ಟಿಗ್ರಿನ್ಯಾಟರ್ಕ್\u200cಮೆನ್ಸ್ವಾನಾಟೋಂಗನ್ಟರ" +
	"್ಕಿಶ್ಸೋಂಗಾಟಾಟರ್ತಹಿತಿಯನ್ಉಯಿಘರ್ಉಕ್ರೈನಿಯನ್ಉರ್ದುಉಜ್ಬೇಕ್ವೆಂಡಾವಿಯೇಟ್ನಾಮೀಸ್ವೋ" +
	"ಲಾಪುಕ್ವಾಲೂನ್ವೋಲೋಫ್ಕ್ಸೋಸಯಡ್ಡಿಶ್ಯೊರುಬಾಝೂವಾಂಗ್ಚೈನೀಸ್ಜುಲುಅಛಿನೀಸ್ಅಕೋಲಿಅಡಂಗ್" +
	"\u200cಮೆಅಡೈಘೆಆಫ್ರಿಹಿಲಿಅಘೆಮ್ಐನುಅಕ್ಕಾಡಿಯನ್ಅಲೆಯುಟ್ದಕ್ಷಿಣ ಅಲ್ಟಾಯ್ಪ್ರಾಚೀನ ಇಂಗ" +
	"್ಲೀಷ್ಆಂಗಿಕಾಅರಾಮಿಕ್ಮಪುಚೆಅರಪಾಹೋಅರಾವಾಕ್ಅಸುಆಸ್ಟುರಿಯನ್ಅವಧಿಬಲೂಚಿಬಲಿನೀಸ್ಬಸಾಬೇ" +
	"ಜಾಬೆಂಬಾಬೆನಭೋಜಪುರಿಬಿಕೊಲ್ಬಿನಿಸಿಕ್ಸಿಕಾಬ್ರಾಜ್ಬೋಡೊಬುರಿಯಟ್ಬುಗಿನೀಸ್ಬ್ಲಿನ್ಕ್ಯಾ" +
	"ಡ್ಡೋಕಾರಿಬ್ಅಟ್ಸಮ್ಸೆಬುಆನೋಚಿಗಾಚಿಬ್ಚಾಚಗಟಾಯ್ಚೂಕಿಸೆಮಾರಿಚಿನೂಕ್ ಜಾರ್ಗೋನ್ಚೋಕ್ಟಾ" +
	"ವ್ಚಿಪೆವ್ಯಾನ್ಚೆರೋಕೀಚೀಯೆನ್ನೇಸೊರಾನಿ ಕುರ್ದಿಷ್ಕೊಪ್ಟಿಕ್ಕ್ರಿಮೀಯನ್ ಟರ್ಕಿಷ್ಕಶುಬ" +
	"ಿಯನ್ಡಕೋಟದರ್ಗ್ವಾಟೈಟಡೆಲಾವೇರ್ಸ್ಲೇವ್ಡೋಗ್ರಿಬ್ಡಿಂಕಾಜರ್ಮಾಡೋಗ್ರಿಲೋವರ್ ಸೋರ್ಬಿಯನ" +
	"್ಡುವಾಲಾಮಧ್ಯ ಡಚ್ಜೊಲ-ಫೊನ್ಯಿಡ್ಯೂಲಾಎಂಬುಎಫಿಕ್ಪ್ರಾಚೀನ ಈಜಿಪ್ಟಿಯನ್ಎಕಾಜುಕ್ಎಲಾಮೈ" +
	"ಟ್ಮಧ್ಯ ಇಂಗ್ಲೀಷ್ಇವಾಂಡೋಫೆಂಗ್ಫಿಲಿಪಿನೊಫೋನ್ಮಧ್ಯ ಫ್ರೆಂಚ್ಪ್ರಾಚೀನ ಫ್ರೆಂಚ್ಉತ್ತರ" +
	" ಫ್ರಿಸಿಯನ್ಪೂರ್ವ ಫ್ರಿಸಿಯನ್ಫ್ರಿಯುಲಿಯನ್ಗಗಗೌಜ್ಗಾಯೋಗ್ಬಾಯಾಗೀಝ್ಗಿಲ್ಬರ್ಟೀಸ್ಮಧ್ಯ " +
	"ಹೈ ಜರ್ಮನ್ಪ್ರಾಚೀನ ಹೈ ಜರ್ಮನ್ಗೊಂಡಿಗೊರೊಂಟಾಲೋಗೋಥಿಕ್ಗ್ರೇಬೋಪ್ರಾಚೀನ ಗ್ರೀಕ್ಸ್ವಿ" +
	"ಸ್ ಜರ್ಮನ್ಗುಸಿಗ್ವಿಚ್\u200cಇನ್ಹೈಡಾಹವಾಯಿಯನ್ಹಿಲಿಗೇನನ್ಹಿಟ್ಟಿಟೆಮೋಂಗ್ಅಪ್ಪರ್ ಸ" +
	"ರ್ಬಿಯನ್ಹೂಪಾಇಬಾನ್ಇಲ್ಲಿಕೋಇಂಗುಷ್ಲೊಜ್ಬಾನ್ನೊಂಬಾಮ್ಯಕಮೆಜೂಡಿಯೋ-ಪರ್ಶಿಯನ್ಜೂಡಿಯೋ-" +
	"ಅರೇಬಿಕ್ಕಾರಾ-ಕಲ್ಪಾಕ್ಕಬೈಲ್ಕಚಿನ್ಜ್ಜುಕಂಬಾಕಾವಿಕಬರ್ಡಿಯನ್ಟ್ಯಾಪ್ಮ್ಯಾಕೊಂಡ್ಕಬುವೆ" +
	"ರ್ಡಿಯನುಕೋರೋಖಾಸಿಖೋಟಾನೀಸ್ಕೊಯ್ರ ಚೀನಿಕಲೆಂಜಿನ್ಕಿಂಬುಂಡುಕೊಮಿ-ಪರ್ಮ್ಯಕ್ಕೊಂಕಣಿಕೊ" +
	"ಸರಿಯನ್ಕಪೆಲ್ಲೆಕರಚಯ್-ಬಲ್ಕಾರ್ಕರೇಲಿಯನ್ಕುರುಖ್ಶಂಬಲಬಫಿಯಕುಮೈಕ್ಕುಟೇನಾಯ್ಕಾಡಿನೋಲಾ" +
	"ಂಗಿಲಹಂಡಾಲಂಬಾಲೆಜ್ಘಿಯನ್ಲಕೊಟಮೊಂಗೋಲೋಝಿಲುಬ-ಲುಲಾಲೂಯಿಸೆನೋಲುಂಡಾಲುವೋಲುಶಾಯ್ಲುಯಿಯ" +
	"ಮದುರೀಸ್ಮಗಾಹಿಮೈಥಿಲಿಮಕಾಸರ್ಮಂಡಿಂಗೊಮಸಾಯ್ಮೋಕ್ಷಮಂದಾರ್ಮೆಂಡೆಮೆರುಮೊರಿಸನ್ಮಧ್ಯ ಐರ" +
	"ಿಷ್ಮ್ಯಖುವಾ- ಮೀಟ್ಟೊಮೆಟಾಮಿಕ್\u200cಮ್ಯಾಕ್ಮಿನಂಗ್\u200cಕಬಾವುಮಂಚುಮಣಿಪುರಿಮೊಹಾ" +
	"ವ್ಕ್ಮೊಸ್ಸಿಮುಂಡಂಗ್ಬಹುಸಂಖ್ಯೆಯ ಭಾಷೆಗಳುಕ್ರೀಕ್ಕಿರಾಂಡೀಸ್ಮಾರ್ವಾಡಿಎರ್\u200cಝ್ಯ" +
	"ಾನಿಯಾಪೊಲಿಟನ್ನಮಲೋ ಜರ್ಮನ್ನೇವಾರೀನಿಯಾಸ್ನಿಯುವನ್ಖ್ವಾಸಿಯೊನೊಗಾಯ್ಪ್ರಾಚೀನ ನೋರ್ಸ್" +
	"ಎನ್\u200cಕೋಉತ್ತರ ಸೋಥೋನೂಯರ್ಶಾಸ್ತ್ರೀಯ ನೇವಾರಿನ್ಯಾಮ್\u200cವೆಂಜಿನ್ಯಾನ್" +
	"\u200cಕೋಲೆನ್ಯೋರೋಜೀಮಾಓಸಾಜ್ಒಟ್ಟೋಮನ್ ತುರ್ಕಿಷ್ಪಂಗಾಸಿನನ್ಪಹ್ಲವಿಪಂಪಾಂಗಾಪಾಪಿಯಮೆಂ" +
	"ಟೋಪಲುಆನ್ಪ್ರಾಚೀನ ಪರ್ಶಿಯನ್ಫೀನಿಷಿಯನ್ಪೋನ್\u200c\u200cಪಿಯನ್ಪ್ರಾಚೀನ ಪ್ರೊವೆನ್" +
	"ಶಿಯಲ್ಕಿಷೆರಾಜಾಸ್ಥಾನಿರಾಪಾನುಯಿರಾರೋಟೊಂಗನ್ರೊಂಬೊರೋಮಾನಿಅರೋಮಾನಿಯನ್ರುವಸಂಡಾವೇಯಾಕ" +
	"ುಟ್ಸಮರಿಟನ್ ಅರಾಮಿಕ್ಸಂಬುರುಸಸಾಕ್ಸಂತಾಲಿಸಂಗುಸಿಸಿಲಿಯನ್ಸ್ಕೋಟ್ಸ್ಸೆನಸೆಲ್ಕಪ್ಕೊಯ್" +
	"ರಬೊರೊ ಸೆನ್ನಿಪ್ರಾಚೀನ ಐರಿಷ್ಟಷೆಲ್\u200dಹಿಟ್ಶಾನ್ಸಿಡಾಮೋದಕ್ಷಿಣ ಸಾಮಿಲೂಲ್ ಸಾಮಿ" +
	"ಇನರಿ ಸಾಮಿಸ್ಕೋಟ್ ಸಾಮಿಸೋನಿಂಕೆಸೋಗ್ಡಿಏನ್ಸ್ರಾನನ್ ಟೋಂಗೋಸೇರೇರ್ಸುಕುಮಾಸುಸುಸುಮೇರ" +
	"ಿಯನ್ಕಾಂಗೊ ಸ್ವಹಿಲಿಶಾಸ್ತ್ರೀಯ ಸಿರಿಯಕ್ಸಿರಿಯಕ್ಟಿಮ್ನೆಟೆಸೊಟೆರೆನೋಟೇಟಮ್ಟೈಗ್ರೆಟಿ" +
	"ವ್ಟೊಕೆಲಾವ್ಕ್ಲಿಂಗನ್ಟ್ಲಿಂಗಿಟ್ಟಮಾಷೆಕ್ನ್ಯಾಸಾ ಟೋಂಗಾಟೋಕ್ ಪಿಸಿನ್ಸಿಂಶಿಯನ್ತುಂಬು" +
	"ಕಾಟುವಾಲುಟಸವಕ್ಟುವಿನಿಯನ್ಮಧ್ಯ ಅಟ್ಲಾಸ್ ಟಮಜೈಟ್ಉಡ್\u200cಮುರ್ಟ್ಉಗಾರಿಟಿಕ್ಉಂಬುಂ" +
	"ಡುರೂಟ್ವಾಯಿವೋಟಿಕ್ವುಂಜೊವಲಾಮೋವರಾಯ್ವಾಷೋಕಲ್\u200cಮೈಕ್ಸೊಗಯಾಓಯಪೀಸೆಝೋಪೊಟೆಕ್ಬ್ಲ" +
	"ಿಸ್\u200cಸಿಂಬಲ್ಸ್ಝೆನಾಗಾಸ್ಟ್ಯಾಂಡರ್ಡ್ ಮೊರೊಕ್ಕನ್ ಟಮಜೈಟ್ಝೂನಿಯಾವುದೇ ಭಾಷಾಸಂಬ" +
	"ಂಧಿ ವಿಷಯವಿಲ್ಲಜಾಝಾಆಧುನಿಕ ಪ್ರಮಾಣಿತ ಅರೇಬಿಕ್ಆಸ್ಟ್ರಿಯನ್ ಜರ್ಮನ್ಸ್ವಿಸ್ ಹೈ ಜರ್" +
	"ಮನ್ಆಸ್ಟ್ರೇಲಿಯನ್ ಇಂಗ್ಲೀಷ್ಕೆನೆಡಿಯನ್ ಇಂಗ್ಲೀಷ್ಬ್ರಿಟಿಷ್ ಇಂಗ್ಲೀಷ್ಅಮೆರಿಕನ್ ಇಂ" +
	"ಗ್ಲೀಷ್ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕನ್ ಸ್ಪ್ಯಾನಿಶ್ಯುರೋಪಿಯನ್ ಸ್ಪ್ಯಾನಿಷ್ಮೆಕ್ಸಿಕನ್ ಸ್ಪ್ಯಾ" +
	"ನಿಷ್ಕೆನೆಡಿಯನ್ ಫ್ರೆಂಚ್ಸ್ವಿಸ್ ಫ್ರೆಂಚ್ಫ್ಲೆಮಿಷ್ಬ್ರೆಜಿಲಿಯನ್ ಪೋರ್ಚುಗೀಸ್ಯೂರೋಪ" +
	"ಿಯನ್ ಪೋರ್ಚುಗೀಸ್ಮೊಲ್ಡೆವಿಯನ್ಸರ್ಬೋ-ಕ್ರೊಯೇಶಿಯನ್ಸರಳೀಕೃತ ಚೈನೀಸ್ಸಾಂಪ್ರದಾಯಿಕ ಚ" +
	"ೈನೀಸ್"

// Size: 1234 bytes, 605 elements
var knLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000f, 0x002d, 0x0045, 0x0066, 0x0075, 0x008a, 0x00a2,
	0x00b7, 0x00d2, 0x00e4, 0x00f9, 0x011a, 0x012f, 0x014d, 0x016b,
	0x0183, 0x0195, 0x01aa, 0x01c5, 0x01da, 0x01f5, 0x020a, 0x0219,
	0x0228, 0x0243, 0x024f, 0x025b, 0x0283, 0x0295, 0x02a7, 0x02bf,
	0x02d1, 0x02e3, 0x02fb, 0x0304, 0x0316, 0x032e, 0x034c, 0x036a,
	0x0388, 0x039a, 0x03b2, 0x03c4, 0x03dc, 0x03f1, 0x0400, 0x0415,
	0x0443, 0x0452, 0x0483, 0x04a4, 0x04b6, 0x04cb, 0x04e6, 0x04f2,
	0x050a, 0x0519, 0x0532, 0x0553, 0x0568, 0x0583, 0x05a1, 0x05b3,
	// Entry 40 - 7F
	0x05da, 0x05fb, 0x0619, 0x0628, 0x0644, 0x065f, 0x0668, 0x0686,
	0x069e, 0x06bf, 0x06d4, 0x06ec, 0x0707, 0x0716, 0x0728, 0x0749,
	0x0755, 0x0776, 0x0785, 0x0794, 0x07a9, 0x07b8, 0x07d0, 0x07e8,
	0x07f4, 0x080c, 0x0824, 0x083c, 0x085a, 0x0869, 0x0887, 0x0899,
	0x08a5, 0x08c6, 0x08e5, 0x08fd, 0x090f, 0x0930, 0x0942, 0x0963,
	0x0975, 0x0990, 0x099f, 0x09ab, 0x09c3, 0x09d8, 0x09e4, 0x0a06,
	0x0a18, 0x0a27, 0x0a30, 0x0a6a, 0x0aa1, 0x0ac6, 0x0ad5, 0x0aea,
	0x0afc, 0x0b11, 0x0b20, 0x0b2f, 0x0b4a, 0x0b5c, 0x0b68, 0x0b7a,
	// Entry 80 - BF
	0x0b8c, 0x0baa, 0x0bc2, 0x0bda, 0x0be9, 0x0c04, 0x0c16, 0x0c3d,
	0x0c52, 0x0c70, 0x0c7f, 0x0c9b, 0x0caa, 0x0cb9, 0x0cd1, 0x0cf2,
	0x0d04, 0x0d10, 0x0d22, 0x0d40, 0x0d58, 0x0d6a, 0x0d89, 0x0da4,
	0x0dbc, 0x0dd1, 0x0de0, 0x0df2, 0x0e04, 0x0e10, 0x0e2e, 0x0e4c,
	0x0e5e, 0x0e70, 0x0e85, 0x0e94, 0x0ea3, 0x0ebb, 0x0ecd, 0x0eeb,
	0x0efa, 0x0f0f, 0x0f1e, 0x0f42, 0x0f5a, 0x0f6c, 0x0f7e, 0x0f8d,
	0x0fa2, 0x0fb4, 0x0fc9, 0x0fdb, 0x0fe7, 0x0ffc, 0x100b, 0x1023,
	0x1032, 0x1032, 0x104d, 0x105c, 0x1065, 0x1083, 0x1083, 0x1098,
	// Entry C0 - FF
	0x1098, 0x10c0, 0x10ee, 0x1100, 0x1115, 0x1124, 0x1124, 0x1136,
	0x1136, 0x114b, 0x114b, 0x114b, 0x1154, 0x1154, 0x1172, 0x1172,
	0x117e, 0x117e, 0x118d, 0x11a2, 0x11a2, 0x11ab, 0x11ab, 0x11ab,
	0x11ab, 0x11b7, 0x11c6, 0x11c6, 0x11cf, 0x11cf, 0x11cf, 0x11e4,
	0x11f6, 0x1202, 0x1202, 0x1202, 0x121a, 0x121a, 0x121a, 0x122c,
	0x122c, 0x1238, 0x1238, 0x124d, 0x1265, 0x1265, 0x1277, 0x1277,
	0x128f, 0x12a1, 0x12a1, 0x12b3, 0x12c8, 0x12d4, 0x12e6, 0x12f8,
	0x130a, 0x1316, 0x1341, 0x1359, 0x1377, 0x1389, 0x13a1, 0x13cc,
	// Entry 100 - 13F
	0x13e4, 0x13e4, 0x1415, 0x142d, 0x1439, 0x144e, 0x1457, 0x146f,
	0x1481, 0x1499, 0x14a8, 0x14b7, 0x14c9, 0x14f4, 0x14f4, 0x1506,
	0x151c, 0x1538, 0x154a, 0x154a, 0x1556, 0x1565, 0x1565, 0x1599,
	0x15ae, 0x15c3, 0x15e8, 0x15e8, 0x15fa, 0x15fa, 0x1609, 0x1621,
	0x1621, 0x162d, 0x162d, 0x164f, 0x167a, 0x167a, 0x16a5, 0x16d0,
	0x16f1, 0x16f4, 0x1703, 0x1703, 0x170f, 0x1721, 0x1721, 0x172d,
	0x174e, 0x174e, 0x1774, 0x17a3, 0x17a3, 0x17b2, 0x17cd, 0x17df,
	0x17f1, 0x1819, 0x183e, 0x183e, 0x183e, 0x184a, 0x1868, 0x1874,
	// Entry 140 - 17F
	0x1874, 0x188c, 0x188c, 0x18a7, 0x18bf, 0x18ce, 0x18f9, 0x18f9,
	0x1905, 0x1914, 0x1914, 0x1929, 0x193b, 0x193b, 0x193b, 0x1953,
	0x1962, 0x1974, 0x199f, 0x19c7, 0x19c7, 0x19e9, 0x19f8, 0x1a07,
	0x1a13, 0x1a1f, 0x1a2b, 0x1a46, 0x1a46, 0x1a58, 0x1a73, 0x1a97,
	0x1a97, 0x1aa3, 0x1aa3, 0x1aaf, 0x1ac7, 0x1ae3, 0x1ae3, 0x1ae3,
	0x1ae3, 0x1afb, 0x1b13, 0x1b38, 0x1b4a, 0x1b62, 0x1b77, 0x1b9c,
	0x1b9c, 0x1b9c, 0x1bb4, 0x1bc6, 0x1bd2, 0x1bde, 0x1bde, 0x1bf0,
	0x1c08, 0x1c1a, 0x1c29, 0x1c38, 0x1c44, 0x1c5f, 0x1c5f, 0x1c5f,
	// Entry 180 - 1BF
	0x1c5f, 0x1c6b, 0x1c6b, 0x1c7a, 0x1c86, 0x1c86, 0x1c9c, 0x1cb4,
	0x1cc3, 0x1ccf, 0x1ce1, 0x1cf0, 0x1cf0, 0x1cf0, 0x1d05, 0x1d05,
	0x1d14, 0x1d26, 0x1d38, 0x1d4d, 0x1d5c, 0x1d5c, 0x1d6b, 0x1d7d,
	0x1d8c, 0x1d98, 0x1dad, 0x1dc9, 0x1df2, 0x1dfe, 0x1e1f, 0x1e43,
	0x1e4f, 0x1e64, 0x1e7c, 0x1e8e, 0x1e8e, 0x1ea3, 0x1ed7, 0x1ee9,
	0x1f04, 0x1f1c, 0x1f1c, 0x1f1c, 0x1f34, 0x1f34, 0x1f34, 0x1f55,
	0x1f5b, 0x1f74, 0x1f86, 0x1f98, 0x1fad, 0x1fad, 0x1fc5, 0x1fc5,
	0x1fd7, 0x1fff, 0x1fff, 0x2011, 0x202d, 0x203c, 0x206a, 0x208e,
	// Entry 1C0 - 1FF
	0x20af, 0x20c1, 0x20cd, 0x20dc, 0x210d, 0x2128, 0x213a, 0x214f,
	0x216d, 0x217f, 0x217f, 0x217f, 0x217f, 0x21ad, 0x21ad, 0x21c8,
	0x21c8, 0x21c8, 0x21e9, 0x21e9, 0x2226, 0x2232, 0x2232, 0x2250,
	0x2268, 0x2286, 0x2286, 0x2286, 0x2295, 0x22a7, 0x22a7, 0x22a7,
	0x22a7, 0x22c5, 0x22ce, 0x22e0, 0x22f2, 0x231d, 0x232f, 0x233e,
	0x2350, 0x2350, 0x2350, 0x235c, 0x2377, 0x238f, 0x238f, 0x238f,
	0x2398, 0x2398, 0x23ad, 0x23db, 0x2400, 0x2400, 0x241e, 0x242a,
	0x242a, 0x243c, 0x243c, 0x243c, 0x245b, 0x2474, 0x248d, 0x24ac,
	// Entry 200 - 23F
	0x24c1, 0x24dc, 0x2501, 0x2513, 0x2513, 0x2513, 0x2525, 0x2531,
	0x254c, 0x254c, 0x2571, 0x25a2, 0x25b7, 0x25b7, 0x25b7, 0x25c9,
	0x25d5, 0x25e7, 0x25f6, 0x2608, 0x2614, 0x262c, 0x262c, 0x2644,
	0x265f, 0x265f, 0x2674, 0x2696, 0x26b5, 0x26b5, 0x26b5, 0x26b5,
	0x26cd, 0x26cd, 0x26e2, 0x26f4, 0x2703, 0x271e, 0x2753, 0x2771,
	0x278c, 0x27a1, 0x27ad, 0x27b9, 0x27b9, 0x27b9, 0x27b9, 0x27b9,
	0x27cb, 0x27cb, 0x27da, 0x27da, 0x27e9, 0x27f8, 0x2804, 0x2804,
	0x2804, 0x281c, 0x281c, 0x2825, 0x282e, 0x283d, 0x283d, 0x283d,
	// Entry 240 - 27F
	0x283d, 0x283d, 0x2855, 0x2882, 0x2882, 0x2894, 0x28e7, 0x28f3,
	0x2940, 0x294c, 0x298d, 0x29be, 0x29ea, 0x2a27, 0x2a5b, 0x2a8c,
	0x2abd, 0x2b0d, 0x2b47, 0x2b81, 0x2bb2, 0x2bda, 0x2bf2, 0x2c32,
	0x2c6c, 0x2c8d, 0x2cbe, 0x2ce6, 0x2d1a,
}

// Size: 7179 bytes
const koLangStr = "" +
	"아파르어압카즈어아베스타어아프리칸스어아칸어암하라어아라곤어아랍어아샘어아바릭어아이마라어아제르바이잔어바슈키르어벨라루스어불가리아어비슬라마어" +
	"밤바라어벵골어티베트어브르타뉴어보스니아어카탈로니아어체첸어차모로어코르시카어크리어체코어교회 슬라브어추바시어웨일스어덴마크어독일어디베히" +
	"어종카어에웨어그리스어영어에스페란토어스페인어에스토니아어바스크어페르시아어풀라어핀란드어피지어페로어프랑스어프리지아어아일랜드어스코틀랜드" +
	" 게일어갈리시아어과라니어구자라트어맹크스어하우사어히브리어힌디어히리 모투어크로아티아어아이티어헝가리어아르메니아어헤레로어인테르링구아 (국" +
	"제보조어협회)인도네시아어인테르링구에이그보어쓰촨 이어이누피아크어이도어아이슬란드어이탈리아어이눅티투트어일본어자바어조지아어콩고어키쿠유" +
	"어쿠안야마어카자흐어그린란드어캄보디아어칸나다어한국어칸누리어카슈미르어쿠르드어코미어콘월어키르기스어라틴어룩셈부르크어간다어림버거어링갈라" +
	"어라오어리투아니아어루바-카탄가어라트비아어말라가시어마셜제도어마오리어마케도니아어말라얄람어몽고어마라티어말레이어몰타어버마어나우루어북부" +
	" 은데벨레어네팔어느동가어네덜란드어노르웨이어(니노르스크)노르웨이어(보크말)남부 은데벨레어나바호어니안자어; 치츄어; 츄어오크어오지브웨" +
	"이어오로모어오리야어오세트어펀잡어팔리어폴란드어파슈토어포르투갈어케추아어레토로만어룬디어루마니아어러시아어르완다어산스크리트어사르디니아어" +
	"신디어북부 사미어산고어스리랑카어슬로바키아어슬로베니아어사모아어쇼나어소말리아어알바니아어세르비아어시스와티어소토어 (남부)순다어스웨덴" +
	"어스와힐리어타밀어텔루구어타지크어태국어티그리냐어투르크멘어세츠와나어통가어터키어총가어타타르어타히티어위구르어우크라이나어우르두어우즈베크" +
	"어벤다어베트남어볼라퓌크어왈론어올로프어코사어이디시어요루바어주앙어중국어줄루어아체어아콜리어아당메어아닥헤어튀니지 아랍어아프리히리어아그" +
	"햄어아이누어아카드어알류트어남부 알타이어고대 영어앙가어아람어아라우칸어아라파호어알제리 아랍어아라와크어모로코 아랍어이집트 아랍어아수" +
	"어아스투리아어아와히어남아제르바이잔어발루치어발리어바사어바문어고말라어베자어벰바어베나어바푸트어호즈푸리어비콜어비니어콤어식시카어브라지어" +
	"브라후이어보도어아쿠즈어부리아타부기어불루어브린어메둠바어카도어카리브어카유가어아삼어세부아노어치가어치브차어차가타이어추크어마리어치누크어" +
	"와 영어 프랑스어의 혼성어촉토어치페우얀체로키어샤이엔어소라니 쿠르드어콥트어크리민 터키어; 크리민 타타르어카슈비아어다코타어다르그와" +
	"어타이타어델라웨어어슬라브어도그리브어딩카어자르마어도그리어저지 소르비아어드와라어중세 네덜란드어졸라 포니어드율라어다장가어엠부어이픽어" +
	"이집트어 (고대)이카죽어엘람어영어, 중세이원도어팡그어필리핀어폰어중세 프랑스어고대 프랑스어북부 프리슬란드어동부 프리슬란드어프리우" +
	"리안어가어가가우스어가요어그바야어조로아스터 다리어게이즈어키리바시어길라키어중세 고지 독일어고대 고지 독일어고아 콘칸어곤디어고론탈로" +
	"어고트어게르보어그리스어, 고대독일어(스위스)구시어그위친어하이다어하와이어피지 힌디어헤리가뇬어하타이트어히몸어고지 소르비아어후파어이" +
	"반어이비비오어이로코어인귀시어로반어응곰바어마차메어유대-페르시아어유대-아라비아어카라칼파크어커바일어카친어까꼬토끄어캄바어카위어카바르디" +
	"어카넴부어티얍어마콘데어크리올어코로어카시어호탄어코이라 친니어코와르어카코어칼렌진어킴분두어코미페르먀크어코카니어코스라이엔어크펠레어카라" +
	"챠이-발카르어카렐리야어쿠르크어샴발라어바피아어콜로그니안어쿠믹어쿠테네어라디노어랑기어라한다어람바어레즈기안어링구아 프랑카 노바라코타어" +
	"몽구어로지어루바-룰루아어루이세노어룬다어루오어루샤이어루야어마두라어마파어마가히마이틸리마카사어만딩고어마사이어마바어모크샤어만다르어멘데" +
	"어메루어모리스얀어아일랜드어, 중세마크후와-메토어메타어미크맥어미낭카바우만주어마니푸리어모호크어모시어서부 마리어문당어다중 언어크리크" +
	"어미란데어마르와리어미예네어엘즈야어마잔데라니어나폴리어나마어저지 독일어네와르어니아스어니웨언어크와시오어느기엠본어노가이어노르웨이, 고" +
	"대응코어소토어 (북부)누에르어네와르어 (고전)니암웨지어니안콜어뉴로어느지마어오세이지어터키어, 오스만판가시난어팔레비어팜팡가어파피아" +
	"먼토어파라우안어고대 페르시아어페니키아어폰틱어폼페이어고대 프로방스어키체어라자스탄어라파뉴이라로통가어롬보어집시어루신어아로마니아어르와" +
	"어산다웨어야큐트어사마리아 아랍어삼부루어사사크어산탈리어느감바이어상구어시칠리아어스코틀랜드어세네카어세나어셀쿠프어코이야보로 세니어아일" +
	"랜드, 고대타셸히트어샨어차디언 아라비아어시다모어남부 사미어룰레 사미어이나리 사미어스콜트 사미어소닌케어소그디엔어스라난 통가어세레" +
	"르어사호어수쿠마족어수수어수메르어코모로어콩고 스와힐리어시리아어 (고전)시리아어팀니어테조어테레노어테툼어티그레어티비어토켈라우제도어차" +
	"후르어클링온어틀링깃족어탈리쉬어타마섹어통가어 (니아살랜드)토크 피신어타로코어트심시안어툼부카어투발루어타사와크어투비니안어중앙모로코 " +
	"타마지트어우드말트어유가리틱어윤번두어어근바이어보틱어분조어월저어와라모어와라이어와쇼어칼미크어소가어야오족어얍페세어양본어옘바어사포테크어" +
	"블리스 심볼제나가어표준 모로코 타마제크어주니어언어 관련 내용 없음자자어현대 표준 아랍어고지 독일어 (스위스)영어(호주)영어 (" +
	"캐나다)영어 (영국식)중남미 스페인어유럽식 스페인어프랑스어 (캐나다)프랑스어 (스위스)플라망어포르투갈어 (브라질)유럽식 포르투" +
	"갈어몰도바어세르비아-크로아티아어중국어(간체)중국어(번체)"

// Size: 1234 bytes, 605 elements
var koLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000c, 0x0018, 0x0027, 0x0039, 0x0042, 0x004e, 0x005a,
	0x0063, 0x006c, 0x0078, 0x0087, 0x009c, 0x00ab, 0x00ba, 0x00c9,
	0x00d8, 0x00e4, 0x00ed, 0x00f9, 0x0108, 0x0117, 0x0129, 0x0132,
	0x013e, 0x014d, 0x0156, 0x015f, 0x0172, 0x017e, 0x018a, 0x0196,
	0x019f, 0x01ab, 0x01b4, 0x01bd, 0x01c9, 0x01cf, 0x01e1, 0x01ed,
	0x01ff, 0x020b, 0x021a, 0x0223, 0x022f, 0x0238, 0x0241, 0x024d,
	0x025c, 0x026b, 0x0284, 0x0293, 0x029f, 0x02ae, 0x02ba, 0x02c6,
	0x02d2, 0x02db, 0x02eb, 0x02fd, 0x0309, 0x0315, 0x0327, 0x0333,
	// Entry 40 - 7F
	0x035d, 0x036f, 0x0381, 0x038d, 0x039a, 0x03ac, 0x03b5, 0x03c7,
	0x03d6, 0x03e8, 0x03f1, 0x03fa, 0x0406, 0x040f, 0x041b, 0x042a,
	0x0436, 0x0445, 0x0454, 0x0460, 0x0469, 0x0475, 0x0484, 0x0490,
	0x0499, 0x04a2, 0x04b1, 0x04ba, 0x04cc, 0x04d5, 0x04e1, 0x04ed,
	0x04f6, 0x0508, 0x051b, 0x052a, 0x0539, 0x0548, 0x0554, 0x0566,
	0x0575, 0x057e, 0x058a, 0x0596, 0x059f, 0x05a8, 0x05b4, 0x05ca,
	0x05d3, 0x05df, 0x05ee, 0x060e, 0x0628, 0x063e, 0x064a, 0x0669,
	0x0672, 0x0684, 0x0690, 0x069c, 0x06a8, 0x06b1, 0x06ba, 0x06c6,
	// Entry 80 - BF
	0x06d2, 0x06e1, 0x06ed, 0x06fc, 0x0705, 0x0714, 0x0720, 0x072c,
	0x073e, 0x0750, 0x0759, 0x0769, 0x0772, 0x0781, 0x0793, 0x07a5,
	0x07b1, 0x07ba, 0x07c9, 0x07d8, 0x07e7, 0x07f6, 0x0808, 0x0811,
	0x081d, 0x082c, 0x0835, 0x0841, 0x084d, 0x0856, 0x0865, 0x0874,
	0x0883, 0x088c, 0x0895, 0x089e, 0x08aa, 0x08b6, 0x08c2, 0x08d4,
	0x08e0, 0x08ef, 0x08f8, 0x0904, 0x0913, 0x091c, 0x0928, 0x0931,
	0x093d, 0x0949, 0x0952, 0x095b, 0x0964, 0x096d, 0x0979, 0x0985,
	0x0991, 0x09a4, 0x09b6, 0x09c2, 0x09ce, 0x09da, 0x09da, 0x09e6,
	// Entry C0 - FF
	0x09e6, 0x09f9, 0x0a06, 0x0a0f, 0x0a18, 0x0a27, 0x0a27, 0x0a36,
	0x0a49, 0x0a58, 0x0a6b, 0x0a7e, 0x0a87, 0x0a87, 0x0a99, 0x0a99,
	0x0aa5, 0x0abd, 0x0ac9, 0x0ad2, 0x0ad2, 0x0adb, 0x0ae4, 0x0ae4,
	0x0af0, 0x0af9, 0x0b02, 0x0b02, 0x0b0b, 0x0b17, 0x0b17, 0x0b26,
	0x0b2f, 0x0b38, 0x0b38, 0x0b3e, 0x0b4a, 0x0b4a, 0x0b4a, 0x0b56,
	0x0b65, 0x0b6e, 0x0b7a, 0x0b86, 0x0b8f, 0x0b98, 0x0ba1, 0x0bad,
	0x0bb6, 0x0bc2, 0x0bce, 0x0bd7, 0x0be6, 0x0bef, 0x0bfb, 0x0c0a,
	0x0c13, 0x0c1c, 0x0c4c, 0x0c55, 0x0c61, 0x0c6d, 0x0c79, 0x0c8f,
	// Entry 100 - 13F
	0x0c98, 0x0c98, 0x0cc3, 0x0cd2, 0x0cde, 0x0ced, 0x0cf9, 0x0d08,
	0x0d14, 0x0d23, 0x0d2c, 0x0d38, 0x0d44, 0x0d5a, 0x0d5a, 0x0d66,
	0x0d7c, 0x0d8c, 0x0d98, 0x0da4, 0x0dad, 0x0db6, 0x0db6, 0x0dcb,
	0x0dd7, 0x0de0, 0x0dee, 0x0dee, 0x0dfa, 0x0dfa, 0x0e03, 0x0e0f,
	0x0e0f, 0x0e15, 0x0e15, 0x0e28, 0x0e3b, 0x0e3b, 0x0e54, 0x0e6d,
	0x0e7f, 0x0e85, 0x0e94, 0x0e94, 0x0e9d, 0x0ea9, 0x0ec2, 0x0ece,
	0x0edd, 0x0ee9, 0x0f00, 0x0f17, 0x0f27, 0x0f30, 0x0f3f, 0x0f48,
	0x0f54, 0x0f68, 0x0f7c, 0x0f7c, 0x0f7c, 0x0f85, 0x0f91, 0x0f9d,
	// Entry 140 - 17F
	0x0f9d, 0x0fa9, 0x0fb9, 0x0fc8, 0x0fd7, 0x0fe0, 0x0ff6, 0x0ff6,
	0x0fff, 0x1008, 0x1017, 0x1023, 0x102f, 0x102f, 0x102f, 0x1038,
	0x1044, 0x1050, 0x1066, 0x107c, 0x107c, 0x108e, 0x109a, 0x10a3,
	0x10b2, 0x10bb, 0x10c4, 0x10d3, 0x10df, 0x10e8, 0x10f4, 0x1100,
	0x1100, 0x1109, 0x1109, 0x1112, 0x111b, 0x112e, 0x113a, 0x113a,
	0x1143, 0x114f, 0x115b, 0x1170, 0x117c, 0x118e, 0x119a, 0x11b3,
	0x11b3, 0x11b3, 0x11c2, 0x11ce, 0x11da, 0x11e6, 0x11f8, 0x1201,
	0x120d, 0x1219, 0x1222, 0x122e, 0x1237, 0x1246, 0x1260, 0x1260,
	// Entry 180 - 1BF
	0x1260, 0x126c, 0x126c, 0x1275, 0x127e, 0x127e, 0x1291, 0x12a0,
	0x12a9, 0x12b2, 0x12be, 0x12c7, 0x12c7, 0x12c7, 0x12d3, 0x12dc,
	0x12e5, 0x12f1, 0x12fd, 0x1309, 0x1315, 0x131e, 0x132a, 0x1336,
	0x133f, 0x1348, 0x1357, 0x136e, 0x1384, 0x138d, 0x1399, 0x13a8,
	0x13b1, 0x13c0, 0x13cc, 0x13d5, 0x13e5, 0x13ee, 0x13fb, 0x1407,
	0x1413, 0x1422, 0x1422, 0x142e, 0x143a, 0x144c, 0x144c, 0x1458,
	0x1461, 0x1471, 0x147d, 0x1489, 0x1495, 0x1495, 0x14a4, 0x14b3,
	0x14bf, 0x14d3, 0x14d3, 0x14dc, 0x14ee, 0x14fa, 0x150f, 0x151e,
	// Entry 1C0 - 1FF
	0x152a, 0x1533, 0x153f, 0x154e, 0x1562, 0x1571, 0x157d, 0x1589,
	0x159b, 0x15aa, 0x15aa, 0x15aa, 0x15aa, 0x15c0, 0x15c0, 0x15cf,
	0x15cf, 0x15d8, 0x15e4, 0x15e4, 0x15fa, 0x1603, 0x1603, 0x1612,
	0x161e, 0x162d, 0x162d, 0x162d, 0x1636, 0x163f, 0x163f, 0x1648,
	0x1648, 0x165a, 0x1663, 0x166f, 0x167b, 0x1691, 0x169d, 0x16a9,
	0x16b5, 0x16b5, 0x16c4, 0x16cd, 0x16dc, 0x16ee, 0x16ee, 0x16fa,
	0x1703, 0x1703, 0x170f, 0x1728, 0x173c, 0x173c, 0x174b, 0x1751,
	0x176a, 0x1776, 0x1776, 0x1776, 0x1786, 0x1796, 0x17a9, 0x17bc,
	// Entry 200 - 23F
	0x17c8, 0x17d7, 0x17ea, 0x17f6, 0x17ff, 0x17ff, 0x180e, 0x1817,
	0x1823, 0x182f, 0x1845, 0x185a, 0x1866, 0x1866, 0x1866, 0x186f,
	0x1878, 0x1884, 0x188d, 0x1899, 0x18a2, 0x18b7, 0x18c3, 0x18cf,
	0x18de, 0x18ea, 0x18f6, 0x1911, 0x1921, 0x1921, 0x192d, 0x192d,
	0x193c, 0x193c, 0x1948, 0x1954, 0x1963, 0x1972, 0x1991, 0x19a0,
	0x19af, 0x19bb, 0x19c1, 0x19ca, 0x19ca, 0x19ca, 0x19ca, 0x19ca,
	0x19d3, 0x19d3, 0x19dc, 0x19e5, 0x19f1, 0x19fd, 0x1a06, 0x1a06,
	0x1a06, 0x1a12, 0x1a12, 0x1a1b, 0x1a27, 0x1a33, 0x1a3c, 0x1a45,
	// Entry 240 - 27F
	0x1a45, 0x1a45, 0x1a54, 0x1a64, 0x1a64, 0x1a70, 0x1a90, 0x1a99,
	0x1ab4, 0x1abd, 0x1ad4, 0x1ad4, 0x1af0, 0x1afe, 0x1b10, 0x1b22,
	0x1b22, 0x1b38, 0x1b4e, 0x1b4e, 0x1b66, 0x1b7e, 0x1b8a, 0x1ba5,
	0x1bbe, 0x1bca, 0x1be9, 0x1bfa, 0x1c0b,
}

// Size: 3747 bytes
const kyLangStr = "" +
	"абхазчаафрикаанчааканчаамхарчаарабчаассамчаазербайжанчабашкырчабеларусча" +
	"болгарчабамбарадабангладешчетибетчебретончобоснийчекаталанчакорсиканчач" +
	"ехчеуелшчедатчанемисчежонгучаэбечегрекчеанглисчеэсперантоиспанчаэстончо" +
	"баскчафарсычафинчефижичефароэчефранцузчабатыш фризчеирландчагалисиячагу" +
	"арашгужаратчаманксычахаусачаивриттехиндичехорватчагаитичемажарчаармянча" +
	"индонезчеигбочоносучаисландчаиталиянчаинуктитуттаяпончожаванизчегрузинч" +
	"екикуйичеказакчакалаалисутчакмерчеканнадачакорейчекашмирчекурдчакорнишч" +
	"екыргызчалатынчалюксембургчагандачалингалачалаочолитовчолуба-катангачал" +
	"атышчамалагасчамаоричемакедончомалайаламчамоңголчомаратичемалайчамалтиз" +
	"чебурмачатүндүк ндыбелченепалчаголландчанорвежче (Нинорск)норвежче (Бук" +
	"мал)оромочоориячапунжабичеполякчапашточопортугалчакечуачароманшчарундич" +
	"ерумынчаорусчаруандачасанскритчесиндхичетүндүк самичесангочосингалачасл" +
	"овакчасловенчешоначасомаличеалбанчасербчесесотосунданчашведчесуахиличет" +
	"амилчетелугучатажикчетайчатигриниачатүркмөнчөтонгачатүркчөтатарчауйгурч" +
	"аукраинчеурдучаөзбекчевьетнамчауолофчокосачаидишчейорубачакытайчазулуча" +
	"агемчемапучедеасучабембачабеначабододочигачачерокичесорани курдтаитачаз" +
	"амрачатөмөнкү сорбианчадуалачажола-фоничеэмбучафилипиногагаузчанемисче " +
	"(Швейцария)гусичегавайчажогорку сорбианчангомбачамачамечекабылчакамбачам" +
	"акондечекабувердичекойра чиничекаленжичекоми-пермякчаконканичешамабалач" +
	"абафиячалангичелакотачалуочолухиячамасайчамеручаморисианчамакуачаметөчө" +
	"мохаукчамундангчанамачаквасиочонкочонуерченыйанколчокичечеромбочоруачас" +
	"амбуручасангучасеначакойраборо сенничеташелитчетүштүк саамичелөлө саами" +
	"чеинари саамическолт саамичеконго суахаличетесочоклингончотасабакчаборб" +
	"ордук Атлас тамазитчебелгисиз тилдевайичевунжочосогачамарокко тамазигт " +
	"адабий тилиндетилдик мазмун жоказыркы адабий араб тилиндежогорку немисч" +
	"е (Швейцария)испанча (Европа)фламандчапортугалча (Европа)молдованчасерб" +
	"-хорваткытайча (жөнөкөйлөштүрүлгөн)кытайча (салттуу)"

// Size: 1234 bytes, 605 elements
var kyLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0000, 0x000e, 0x000e, 0x0022, 0x002e, 0x003c, 0x003c,
	0x0048, 0x0056, 0x0056, 0x0056, 0x006e, 0x007e, 0x0090, 0x00a0,
	0x00a0, 0x00b2, 0x00c8, 0x00d6, 0x00e6, 0x00f6, 0x0108, 0x0108,
	0x0108, 0x011c, 0x011c, 0x0126, 0x0126, 0x0126, 0x0132, 0x013c,
	0x014a, 0x014a, 0x0158, 0x0162, 0x016e, 0x017e, 0x0190, 0x019e,
	0x01ac, 0x01b8, 0x01c6, 0x01c6, 0x01d0, 0x01dc, 0x01ea, 0x01fc,
	0x0213, 0x0223, 0x0223, 0x0235, 0x0241, 0x0253, 0x0263, 0x0271,
	0x027f, 0x028d, 0x028d, 0x029d, 0x02ab, 0x02b9, 0x02c7, 0x02c7,
	// Entry 40 - 7F
	0x02c7, 0x02d9, 0x02d9, 0x02e5, 0x02f1, 0x02f1, 0x02f1, 0x0301,
	0x0313, 0x0329, 0x0335, 0x0347, 0x0357, 0x0357, 0x0367, 0x0367,
	0x0375, 0x038d, 0x0399, 0x03ab, 0x03b9, 0x03b9, 0x03c9, 0x03d5,
	0x03d5, 0x03e5, 0x03f5, 0x0403, 0x041b, 0x0429, 0x0429, 0x043b,
	0x0445, 0x0453, 0x046e, 0x047c, 0x048e, 0x048e, 0x049c, 0x04ae,
	0x04c4, 0x04d4, 0x04e4, 0x04f2, 0x0502, 0x0510, 0x0510, 0x052d,
	0x053b, 0x053b, 0x054d, 0x056e, 0x058d, 0x058d, 0x058d, 0x058d,
	0x058d, 0x058d, 0x059b, 0x05a7, 0x05a7, 0x05b9, 0x05b9, 0x05c7,
	// Entry 80 - BF
	0x05d5, 0x05e9, 0x05f7, 0x0607, 0x0615, 0x0623, 0x062f, 0x063f,
	0x0653, 0x0653, 0x0663, 0x067c, 0x068a, 0x069c, 0x06ac, 0x06bc,
	0x06bc, 0x06c8, 0x06d8, 0x06e6, 0x06f2, 0x06f2, 0x06fe, 0x070e,
	0x071a, 0x072c, 0x073a, 0x074a, 0x0758, 0x0762, 0x0776, 0x0788,
	0x0788, 0x0796, 0x07a2, 0x07a2, 0x07b0, 0x07b0, 0x07be, 0x07ce,
	0x07da, 0x07e8, 0x07e8, 0x07fa, 0x07fa, 0x07fa, 0x0808, 0x0814,
	0x0820, 0x0830, 0x0830, 0x083e, 0x084a, 0x084a, 0x084a, 0x084a,
	0x084a, 0x084a, 0x084a, 0x0856, 0x0856, 0x0856, 0x0856, 0x0856,
	// Entry C0 - FF
	0x0856, 0x0856, 0x0856, 0x0856, 0x0856, 0x0866, 0x0866, 0x0866,
	0x0866, 0x0866, 0x0866, 0x0866, 0x0870, 0x0870, 0x0870, 0x0870,
	0x0870, 0x0870, 0x0870, 0x0870, 0x0870, 0x0870, 0x0870, 0x0870,
	0x0870, 0x0870, 0x087e, 0x087e, 0x088a, 0x088a, 0x088a, 0x088a,
	0x088a, 0x088a, 0x088a, 0x088a, 0x088a, 0x088a, 0x088a, 0x088a,
	0x088a, 0x0896, 0x0896, 0x0896, 0x0896, 0x0896, 0x0896, 0x0896,
	0x0896, 0x0896, 0x0896, 0x0896, 0x0896, 0x08a2, 0x08a2, 0x08a2,
	0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08b2, 0x08b2, 0x08c7,
	// Entry 100 - 13F
	0x08c7, 0x08c7, 0x08c7, 0x08c7, 0x08c7, 0x08c7, 0x08d5, 0x08d5,
	0x08d5, 0x08d5, 0x08d5, 0x08e3, 0x08e3, 0x0904, 0x0904, 0x0912,
	0x0912, 0x0927, 0x0927, 0x0927, 0x0933, 0x0933, 0x0933, 0x0933,
	0x0933, 0x0933, 0x0933, 0x0933, 0x0933, 0x0933, 0x0933, 0x0943,
	0x0943, 0x0943, 0x0943, 0x0943, 0x0943, 0x0943, 0x0943, 0x0943,
	0x0943, 0x0943, 0x0953, 0x0953, 0x0953, 0x0953, 0x0953, 0x0953,
	0x0953, 0x0953, 0x0953, 0x0953, 0x0953, 0x0953, 0x0953, 0x0953,
	0x0953, 0x0953, 0x0976, 0x0976, 0x0976, 0x0982, 0x0982, 0x0982,
	// Entry 140 - 17F
	0x0982, 0x0990, 0x0990, 0x0990, 0x0990, 0x0990, 0x09b1, 0x09b1,
	0x09b1, 0x09b1, 0x09b1, 0x09b1, 0x09b1, 0x09b1, 0x09b1, 0x09b1,
	0x09c1, 0x09d1, 0x09d1, 0x09d1, 0x09d1, 0x09d1, 0x09df, 0x09df,
	0x09df, 0x09ed, 0x09ed, 0x09ed, 0x09ed, 0x09ed, 0x09ff, 0x0a15,
	0x0a15, 0x0a15, 0x0a15, 0x0a15, 0x0a15, 0x0a2c, 0x0a2c, 0x0a2c,
	0x0a2c, 0x0a3e, 0x0a3e, 0x0a57, 0x0a69, 0x0a69, 0x0a69, 0x0a69,
	0x0a69, 0x0a69, 0x0a69, 0x0a69, 0x0a7d, 0x0a8b, 0x0a8b, 0x0a8b,
	0x0a8b, 0x0a8b, 0x0a99, 0x0a99, 0x0a99, 0x0a99, 0x0a99, 0x0a99,
	// Entry 180 - 1BF
	0x0a99, 0x0aa9, 0x0aa9, 0x0aa9, 0x0aa9, 0x0aa9, 0x0aa9, 0x0aa9,
	0x0aa9, 0x0ab3, 0x0ab3, 0x0ac1, 0x0ac1, 0x0ac1, 0x0ac1, 0x0ac1,
	0x0ac1, 0x0ac1, 0x0ac1, 0x0ac1, 0x0acf, 0x0acf, 0x0acf, 0x0acf,
	0x0acf, 0x0adb, 0x0aef, 0x0aef, 0x0afd, 0x0b09, 0x0b09, 0x0b09,
	0x0b09, 0x0b09, 0x0b19, 0x0b19, 0x0b19, 0x0b2b, 0x0b2b, 0x0b2b,
	0x0b2b, 0x0b2b, 0x0b2b, 0x0b2b, 0x0b2b, 0x0b2b, 0x0b2b, 0x0b2b,
	0x0b37, 0x0b37, 0x0b37, 0x0b37, 0x0b37, 0x0b37, 0x0b47, 0x0b47,
	0x0b47, 0x0b47, 0x0b47, 0x0b51, 0x0b51, 0x0b5d, 0x0b5d, 0x0b5d,
	// Entry 1C0 - 1FF
	0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71,
	0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71,
	0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b71, 0x0b7d, 0x0b7d, 0x0b7d,
	0x0b7d, 0x0b7d, 0x0b7d, 0x0b7d, 0x0b8b, 0x0b8b, 0x0b8b, 0x0b8b,
	0x0b8b, 0x0b8b, 0x0b95, 0x0b95, 0x0b95, 0x0b95, 0x0ba7, 0x0ba7,
	0x0ba7, 0x0ba7, 0x0ba7, 0x0bb5, 0x0bb5, 0x0bb5, 0x0bb5, 0x0bb5,
	0x0bc1, 0x0bc1, 0x0bc1, 0x0be2, 0x0be2, 0x0be2, 0x0bf4, 0x0bf4,
	0x0bf4, 0x0bf4, 0x0bf4, 0x0bf4, 0x0c0f, 0x0c26, 0x0c3f, 0x0c58,
	// Entry 200 - 23F
	0x0c58, 0x0c58, 0x0c58, 0x0c58, 0x0c58, 0x0c58, 0x0c58, 0x0c58,
	0x0c58, 0x0c58, 0x0c75, 0x0c75, 0x0c75, 0x0c75, 0x0c75, 0x0c75,
	0x0c81, 0x0c81, 0x0c81, 0x0c81, 0x0c81, 0x0c81, 0x0c81, 0x0c93,
	0x0c93, 0x0c93, 0x0c93, 0x0c93, 0x0c93, 0x0c93, 0x0c93, 0x0c93,
	0x0c93, 0x0c93, 0x0c93, 0x0c93, 0x0ca5, 0x0ca5, 0x0cd5, 0x0cd5,
	0x0cd5, 0x0cd5, 0x0cf0, 0x0cfc, 0x0cfc, 0x0cfc, 0x0cfc, 0x0cfc,
	0x0cfc, 0x0cfc, 0x0d0a, 0x0d0a, 0x0d0a, 0x0d0a, 0x0d0a, 0x0d0a,
	0x0d0a, 0x0d0a, 0x0d0a, 0x0d16, 0x0d16, 0x0d16, 0x0d16, 0x0d16,
	// Entry 240 - 27F
	0x0d16, 0x0d16, 0x0d16, 0x0d16, 0x0d16, 0x0d16, 0x0d51, 0x0d51,
	0x0d71, 0x0d71, 0x0da2, 0x0da2, 0x0dd4, 0x0dd4, 0x0dd4, 0x0dd4,
	0x0dd4, 0x0dd4, 0x0df1, 0x0df1, 0x0df1, 0x0df1, 0x0e03, 0x0e03,
	0x0e26, 0x0e3a, 0x0e4f, 0x0e84, 0x0ea3,
}

// Size: 10635 bytes
const loLangStr = "" +
	"ອະຟາແອບຄາຊຽນອາເວັສແຕນອາຟຣິການອາການອຳຮາຣິກອາຣາໂກເນັດອາຣັບອັສຊາມີສອາວາຣິກອ" +
	"າຍມາລາອາເຊີໄບຈານິບາຣກີເບລາຣັສຊຽນບັງກາຣຽນບິສລະມາບາມບາຣາເບັງກາລີທິເບທັນເ" +
	"ບຣຕັນບອສນຽນຄາຕາລານຊີເຄນຊາມໍໂຣຄໍຊິກາຄີເຊກໂບດສລາວິກຊູວາຊເວວແດນິຊເຢຍລະມັນ" +
	"ດີວີຮີດີຊອງຄາອິວາກຣີກອັງກິດເອສເປີຣັນໂຕສະແປນນິຊເອສໂຕນຽນບັສກີເປີຊຽນຟູລາຟ" +
	"ິນນິຊຟິຈຽນຟາໂຣສຝຣັ່ງເວສເທີນ ຟຣິຊຽນໄອຣິສສະກັອດເກລິກກາລິຊຽນກົວຣານີກູຈາຣາ" +
	"ຕິແມງຊ໌ເຮົາຊາຮີບຣິວຮິນດິຮິຣິໂມຕູໂຄຣເອທຽນໄຮຕຽນຮັງກາຣຽນອາເມນຽນເຮິຮິໂຣອິນ" +
	"ເຕີລິງລົວອິນໂດເນຊຽນອິນເຕີລິງກຣີອິກໂບເຊສວຍຢີອິນນູປຽກອີໂດໄອສແລນດິກອິຕາລຽ" +
	"ນອິນນຸກຕິຕັດຍີ່ປຸ່ນຈາແວນີສຈໍຈຽນຄອງໂກຄິຄູຢຸກວນຍາມາຄາຊັກກຣີນແລນລິດຂະເໝນຄ" +
	"ັນນາດາເກົາຫລີຄານຸລິຄັດຊະມີຣີເຄີດິສໂຄມິຄໍນິຊເກຍກີສລາຕິນລັກເຊມບວກກິຊແກນດ" +
	"າລິມເບີກີຊລິງກາລາລາວລິທົວນຽນລູບາ-ຄາຕັງກາລັດວຽນມາລາກາສຊີມາຊານເລັດມາວຣິແ" +
	"ມັກເຊໂດນຽນມາເລອາລຳມອງໂກເລຍມາຣາທີມາເລມອລທີສມຽນມານາຢູລູເອັນເດເບເລເໜືອເນປ" +
	"າລີເອັນດອງກາດັຊນໍເວຈຽນ ນີນອກນໍເວຈຽນ ບັອກມອລນີບີລີໃຕ້ນາວາໂຈນານຈາອັອກຊີຕ" +
	"ານໂອຈິບວາໂອໂຣໂມໂອຣິຢາອອດເຊຕິກປັນຈາບີປາລີໂປລິຊປາສໂຕປໍຕູກີສຄີຊົວໂຣແມນຣຸນ" +
	"ດິໂຣແມນຽນຣັດຊຽນຄິນຢາວານດາສັນສະກຣິດສາດີນຽນສິນທິຊາມິເໜືອແຊງໂກສິນຫາລາສະໂລ" +
	"ແວັກສະໂລເວນຽນຊາມົວໂຊນາໂຊມາລີອານບານຽນເຊີບຽນຊຣາຕິໂຊໂທໃຕ້ຊຸນແດນນີສສະວີດິຊ" +
	"ຊວາຮີລິທາມິລເຕລູກູທາຈິກໄທຕິກຣິນຢາເທີກເມັນເຕສະວານາທອງການເທີຄິຊເຕຊອງກາທາ" +
	"ທາຕາຮີຕຽນອຸຍເຄີຢູເຄຣນຽນອູຣະດູອຸສເບກເວນດາຫວຽດນາມໂວລາພັກວໍລູມວໍລອບໂຮຊາຢິ" +
	"ວໂຢຣູບາຊວາງຈີນຊູລູແອັກຊີເນັສອາໂຄລີອາແດງມີເອດີຮິແອຟີຮີລີອາເຮັມໄອນູອັກກາ" +
	"ດຽມອາເລີດອານໄຕໃຕ້ອັງກິດໂບຮານແອນຈີກາອາລາມິກອາຣົວຄານຽນອາຣາປາໂຮອາຣາແວກອາຊ" +
	"ູອັສຕູຮຽນອາວາຮິບາລູຊີບາລີເນັດບາຊາບາມຸນໂຄມາລາບີເຈເບັມບາບີນາບາຟັດໂບພູຣິບ" +
	"ີຄອນບີນີກົມຊິກຊິກາບຣາໂບດູອາຄຸດບູຣຽດບູຈີເນັດບູລູບລິນເມດູມບາແຄດໂດຄາຣິບຄາ" +
	"ຢູກາອາດແຊມຊີບູໂນຊີກາຊິບຊາຊາກາໄຕຊູເກດມາຣິຊີນຸກຈາກອນຊອກຕິວຊີພິວຢານຊີໂຣກີ" +
	"ຊີເຢນນີໂຊຣານິ ເຄີດິຊຄອບຕິກຄຣີເມນເຕີຄິຊກາຊູບຽນດາໂກຕາດາກວາໄຕຕາເດລາວາຊີເລ" +
	"ັບໂດກຣິບດິນກາຊາມາດອກຣີຊໍບຽນຕໍ່ກວ່າດົວລາດັກກາງໂຈລາ-ຟອນຢີດູລາດາຊາກາເອັມບ" +
	"ູອີຟິກອີຢິບບູຮານອີກາຈັກອີລາໄມອັງກິດກາງອີວອນດູແຟງຟີລິປີໂນຟອນຟຮັ່ງເສດກາງ" +
	"ຟຮັ່ງເສດໂບຮານຟຣີຊຽນເໜືອຟຣີຊຽນຕາເວັນອອກຟຣີລຽນກາກາກາອຸຊກາໂຢບາຍາກີກິນເບີເ" +
	"ທັດເຢຍລະມັນສູງກາງເຢຍລະມັນສູງໂບຮານກອນດີໂກຣອນຕາໂຣກອດຮິກກຣີໂບແອນຊຽນກຣີກສະ" +
	"ວິສ ເຈີແມນກູຊິວິດອິນໄຮດາຮາໄວອຽນຮິຣິໄກນອນຮິດໄຕມອງຊຸບເປີຊໍບຽນຮູປາໄອບານໄອ" +
	"ໄບໄບໂອໄອໂລໂກອິນກັຊໂລບບັນງອມບາມາແຊມຈູແດວ-ເພີຊຽນຈູແດວ-ອາລາບິກກາຣາ-ການປາກ" +
	"ກາໄບລ໌ກາຊິນຈຣູກາມບາກະວີກາບາດຽນຄາແນມບູຕີບມາຄອນເດຄາເວີເດຍນູໂຄໂລຄາສິໂຄຕັນ" +
	"ຄອຍຣາ ຊິນີຄາໂກຄາເລັນຈິນຄິມບັນດູໂຄມີ-ເພີມຢັກກອນການີຄູສໄລກາແປຣກາຣາໄຊ-ບານ" +
	"ກາກາເຣລຽນກູຣູກຊຳບາລ້າບາເຟຍໂຄລອກນຽນຄູມີກຄູເທໄນລາດີໂນແລນກິລານດາແລມບາລີຊຽ" +
	"ນລາໂກຕາແມັງໂກ້ໂລຊິລູບາ-ລູລົວລູເຊໂນລຸນດາລົວລູໄຊລູໄຍມາດູລາມາຟາມາກາຮິໄມທີ" +
	"ລິມາກາຊາຣມັນດິງກາມາໄຊມາບາມອກຊາມານດາຣເມນເດເມຣູມໍຣິສເຢນໄອລິດກາງມາຄູວາ-ມີ" +
	"ດໂຕເມທາມິກແມກທີແນງກາບູແມນຈູມານີພູຣິໂມຫາມອສຊີມັນດັງຫລາຍພາສາຄຣິກມີລັນດາມ" +
	"າວາຣິມໍຢິນເອີຍານາໂປລີນາມາເຢຍລະມັນຕ່ຳ ແຊກຊອນຕໍ່ຳນີວາຣິນີ່ອັດນີ່ອູກວາຊີໂ" +
	"ອຈີ່ມບູນນໍໄກນໍໂບຮານເອັນໂກໂຊໂທເໜືອເນີເນວາດັ້ງເດີມນາມວີຊິນານຄອນໂນໂຣນິມາໂ" +
	"ອແຊກຕູກີອອດໂຕມັນປານກາຊີມານພາລາວີປາມປານກາປາມເປຍເມັນໂທປາລົວອານເປີເຊຍໂບຮາ" +
	"ນຟີນີເຊຍພອນເພໂປວອງຊານໂບຮານKʼicheʼຣາຈັສທານິຣາປານຸຍຣາໂຣທອນການຣົມໂບໂຣເມນີ" +
	"ອາໂຣມານຽນອາຣວາຊັນດາວຊາກາສາມາຣິແຕນ-ຊຳບູຣູຊາຊັກຊານທາລິກຳເບຊານກູຊີຊິລີນສກ" +
	"ອດຊີນາເຊນຄັບໂຄຍຣາໂບໂຣ ເຊນນິອີຣິຊເກົ່າທາເຊວຫິດໄທໃຫ່ຍອາລັບ-ຊາດຊິດາໂມຊາມິ" +
	"ໃຕ້ລຸນຊາມິອີນາຣິຊາມິສກອດຊາມິໂຊນິນກີຊອກດິນສຣານນານຕອນໂກເຊເລີຊາໂຮຊູຄູມ້າຊ" +
	"ູຊູຊູເມີເລຍໂຄໂນຣຽນຄອງໂກ ຊວາຮີລິຊີເລຍແບບດັ້ງເດີມຊີເລຍທີມເນເຕໂຊເຕເລໂນເຕຕ" +
	"ູມໄທກຣີຕີວໂຕເກເລົາຄຣິງກອນທລີງກິດທາມາກເຊກນາຍອາຊາຕອງກາທອກພີຊິນຕາໂລໂກຊີມຊ" +
	"ີແອນຕຳບູກາຕູວາລູຕາຊາວັກຕູວີນຽນອັດລາສ ທາມາຊີກ ກາງອຸດມັດຢູກາລິກອຳບັນດູລູ" +
	"ດໄວໂວຕິກວັນໂຈວາເຊີວາລາໂມວາເລວາໂຊການມິກໂຊກາເຢົ້າຢັບແຍງເບນແຢມບາກວາງຕຸ້ງຊ" +
	"າໂປແຕບສັນຍາລັກບລີຊິມເຊນາກາໂມຣັອກແຄນ ທາມາຊີກ ມາດຕະຖານຊູນີບໍ່ມີເນື້ອຫາພາ" +
	"ສາຊາຊາອາຣາບິກມາດຕະຖານສະໄໝໃໝ່ອອສຕຣຽນ ເຈີແມນສະວິສ ໄຮ ເຈີແມນອັງກິດ (ອອສເຕ" +
	"ຣລຽນ)ອັງກິດ (ເຄເນດຽນ)ອັງກິດ (ບຣິດທິຊ)ອັງກິດ (ອາເມລິກັນ)ລາຕິນ ອາເມຣິກັນ" +
	" ສະແປນນິຊຢູໂຣປຽນ ສະແປນນິຊເມັກຊິກັນ ສະແປນນິຊເຄເນດຽນ ຝຣັ່ງສະວິສ ຝຣັ່ງຟລີມິ" +
	"ຊບຣາຊິລຽນ ປໍຕູກີສຢູໂຣປຽນ ປໍຕູກີສໂມດາວຽນເຊີໂບ-ໂກເຊຍຈີນແບບຮຽບງ່າຍຈີນແບບດ" +
	"ັ້ງເດີມ"

// Size: 1234 bytes, 605 elements
var loLangIdx = []uint16{
	// Entry 0 - 3F
	0x0000, 0x000c, 0x0024, 0x003f, 0x0057, 0x0066, 0x007b, 0x0099,
	0x00a8, 0x00c0, 0x00d5, 0x00ea, 0x010b, 0x011a, 0x0138, 0x0150,
	0x0165, 0x017a, 0x0192, 0x01a7, 0x01b9, 0x01cb, 0x01e0, 0x01ef,
	0x0201, 0x0213, 0x0219, 0