WIX = $(PROGRAMFILES)\Windows Installer XML v3\bin
CANDLE = "$(WIX)\candle.exe"
LIGHT = "$(WIX)\light.exe"
HEAT = "$(WIX)\heat.exe"
SED = sed
BUILD = build\usr\local

graphviz.msi : graphviz.wixobj bin.wixobj include.wixobj lib.wixobj share.wixobj
	$(LIGHT) -ext WixUIExtension -cultures:en-us -out $@ $^

%.wixobj : %.wxs
	$(CANDLE) -sw1092 -out $@ $^

# we need to post process dir.wxs with sed to:
# (1) change the GUID markers PUT-GUID-HERE to the autogenerated *
# (2) change the ComponentGroup1 ID to the dir
# (3) change the graphviz id of a directory to dir_graphviz
# (4) convert first <Directory Name="dir"> in Fragment to <DirectoryRef Id="dir">
# (5) convert last </Directory> in Fragment to </DirectoryRef>
bin.wxs include.wxs lib.wxs share.wxs : %.wxs : $(shell find "$(BUILD)" -type f)
	$(HEAT) dir "$(BUILD)\$*" -sfrag -out $*-pre.wxs && \
	$(SED) 's/PUT-GUID-HERE/*/g; s/Id="ComponentGroup1"/Id="$*"/g; s/Id="graphviz"/Id="$*_graphviz"/g; $!N; s/\(<Fragment>\W*\)<Directory.*Name="$*".*>/\1<DirectoryRef Id="$*">/g; s/<\/Directory>\(\W*<\/Fragment>\)/<\/DirectoryRef>\1/g; P; D' $*-pre.wxs >$*.wxs 

.PHONY : clean
clean :
	-rm *.msi *.wixobj bin*.wxs include*.wxs lib*.wxs share*.wxs 
 
