/* grepmap
 * arch-tag: 89a95311-663d-4568-9c93-b9a9e4fe0fd0
 *
 * util.c - utility functions
 *
 * Copyright © 2004 Canonical Ltd.
 * Author: Scott James Remnant <scott@canonical.com>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "grepmap.h"


/**
 * fgets_alloc:
 * @stream: stdio stream to read from.
 *
 * Reads from stream up to EOF or a newline, without any line-length
 * limitations.
 *
 * Returns: static string containing the entire line WITHOUT the
 * terminating newline, or NULL if end of file is reached and nothing
 * was read.
 **/
char *
fgets_alloc (FILE *stream)
{
	static char   *buf = NULL;
	static size_t  buf_sz = 0;
	size_t         buf_len = 0;

	for (;;) {
		char *ret, *pos;

		if (buf_sz <= (buf_len + 1)) {
			buf_sz += BUFSIZ;
			buf = realloc (buf, buf_sz);
			if (! buf)
				abort();
		}

		ret = fgets (buf + buf_len, buf_sz - buf_len, stream);
		if ((! ret) && (! buf_len)) {
			return NULL;
		} else if (! ret) {
			return buf;
		}

		buf_len += strlen (ret);
		pos = strchr (ret, '\n');
		if (pos) {
			*pos = '\0';
			break;
		}
	}

	return buf;
}

/**
 * parse_hex:
 * @str: string to parse.
 * @hex: variable to write value to.
 *
 * Parses the string as a hexadecimal value, optionally beginning with
 * a variety of silly prefixes.
 *
 * Returns: 0 on success, 1 on failure.
 **/
int
parse_hex (const char   *str,
	   unsigned int *hex)
{
	if (! strncmp (str, "0x", 2)) {
		str += 2;
	} else if (! strncmp (str, "&#x", 3)) {
		str += 3;
	} else if (! strncmp (str, "&", 1)) {
		str += 1;
	}

	if (sscanf (str, "%x", hex) != 1)
		return 1;

	return 0;
}
