// Copyright (C) 2000-2006, Luca Padovani <padovani@sti.uniurb.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <padovani@sti.uniurb.it>

#include "TFM.hh"

static TFM::Font font = {
"CMR",

  0xf2,
  "TeX text",
  0x00600000,
  0xb94161a8,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00000000 },
  { 0x02, "space", 0x0006aaa5 },
  { 0x03, "space_stretch", 0x00031c70 },
  { 0x04, "space_shrink", 0x000212f5 },
  { 0x05, "x_height", 0x0006e38d },
  { 0x06, "quad", 0x00138e2b },
  { 0x07, "extra_space", 0x000212f5 }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x00014bd8 },
  { 0x27, 0x00014bd8 },
  { 0x29, 0x00014bd8 },
  { 0x3f, 0x00014bd8 },
  { 0x5d, 0x00014bd8 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfff9a500 },
  { 0x6c, 0xfffa5ed5 }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x000212f5 },
  { 0x3f, 0x000212f5 }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff7b43 },
  { 0x47, 0xffff7b43 },
  { 0x4f, 0xffff7b43 },
  { 0x51, 0xffff7b43 },
  { 0x54, 0xfffe71c8 },
  { 0x55, 0xffff7b43 },
  { 0x56, 0xfffded0b },
  { 0x57, 0xfffded0b },
  { 0x59, 0xfffe71c8 },
  { 0x74, 0xffff7b43 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff7b43 },
  { 0x56, 0xffff7b43 },
  { 0x57, 0xffff7b43 },
  { 0x58, 0xffff7b43 },
  { 0x59, 0xffff7b43 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffded0b },
  { 0x43, 0xffff7b43 },
  { 0x47, 0xffff7b43 },
  { 0x4f, 0xffff7b43 },
  { 0x51, 0xffff7b43 },
  { 0x61, 0xfffe71c8 },
  { 0x65, 0xfffe71c8 },
  { 0x6f, 0xfffe71c8 },
  { 0x72, 0xfffe71c8 },
  { 0x75, 0xfffe71c8 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x49, 0x000084bd }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff7b43 },
  { 0x47, 0xffff7b43 },
  { 0x4f, 0xffff7b43 },
  { 0x51, 0xffff7b43 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffe71c8 },
  { 0x56, 0xfffded0b },
  { 0x57, 0xfffded0b },
  { 0x59, 0xfffe71c8 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff7b43 },
  { 0x56, 0xffff7b43 },
  { 0x57, 0xffff7b43 },
  { 0x58, 0xffff7b43 },
  { 0x59, 0xffff7b43 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x2c, 0xfffe71c8 },
  { 0x2e, 0xfffe71c8 },
  { 0x41, 0xfffe71c8 },
  { 0x61, 0xffff7b43 },
  { 0x65, 0xffff7b43 },
  { 0x6f, 0xffff7b43 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x43, 0xffff7b43 },
  { 0x47, 0xffff7b43 },
  { 0x4f, 0xffff7b43 },
  { 0x51, 0xffff7b43 },
  { 0x54, 0xfffe71c8 },
  { 0x55, 0xffff7b43 },
  { 0x56, 0xfffded0b },
  { 0x57, 0xfffded0b },
  { 0x59, 0xfffe71c8 },
  { 0x74, 0xffff7b43 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffe71c8 },
  { 0x61, 0xfffe71c8 },
  { 0x65, 0xfffe71c8 },
  { 0x6f, 0xfffe71c8 },
  { 0x72, 0xfffe71c8 },
  { 0x75, 0xfffe71c8 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffded0b },
  { 0x43, 0xffff7b43 },
  { 0x47, 0xffff7b43 },
  { 0x4f, 0xffff7b43 },
  { 0x51, 0xffff7b43 },
  { 0x61, 0xfffe71c8 },
  { 0x65, 0xfffe71c8 },
  { 0x6f, 0xfffe71c8 },
  { 0x72, 0xfffe71c8 },
  { 0x75, 0xfffe71c8 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffded0b },
  { 0x43, 0xffff7b43 },
  { 0x47, 0xffff7b43 },
  { 0x4f, 0xffff7b43 },
  { 0x51, 0xffff7b43 },
  { 0x61, 0xfffe71c8 },
  { 0x65, 0xfffe71c8 },
  { 0x6f, 0xfffe71c8 },
  { 0x72, 0xfffe71c8 },
  { 0x75, 0xfffe71c8 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff7b43 },
  { 0x47, 0xffff7b43 },
  { 0x4f, 0xffff7b43 },
  { 0x51, 0xffff7b43 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffe71c8 },
  { 0x61, 0xfffe71c8 },
  { 0x65, 0xfffe71c8 },
  { 0x6f, 0xfffe71c8 },
  { 0x72, 0xfffe71c8 },
  { 0x75, 0xfffe71c8 }
};

static TFM::Kerning C_61_Kerning[] = {
  { 0x6a, 0x0001097b },
  { 0x76, 0xffff7b43 },
  { 0x77, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x63, 0x000084bd },
  { 0x64, 0x000084bd },
  { 0x65, 0x000084bd },
  { 0x6a, 0x0001097b },
  { 0x6f, 0x000084bd },
  { 0x71, 0x000084bd },
  { 0x76, 0xffff7b43 },
  { 0x77, 0xffff7b43 },
  { 0x78, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x68, 0xffff7b43 },
  { 0x6b, 0xffff7b43 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x00014bd8 },
  { 0x27, 0x00014bd8 },
  { 0x29, 0x00014bd8 },
  { 0x3f, 0x00014bd8 },
  { 0x5d, 0x00014bd8 }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x6a, 0x000084bd }
};

static TFM::Kerning C_68_Kerning[] = {
  { 0x62, 0xffff7b43 },
  { 0x74, 0xffff7b43 },
  { 0x75, 0xffff7b43 },
  { 0x76, 0xffff7b43 },
  { 0x77, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_6b_Kerning[] = {
  { 0x61, 0xfffef685 },
  { 0x61, 0xffff7b43 },
  { 0x63, 0xffff7b43 },
  { 0x65, 0xffff7b43 },
  { 0x6f, 0xffff7b43 }
};

static TFM::Kerning C_6d_Kerning[] = {
  { 0x62, 0xffff7b43 },
  { 0x74, 0xffff7b43 },
  { 0x75, 0xffff7b43 },
  { 0x76, 0xffff7b43 },
  { 0x77, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_6e_Kerning[] = {
  { 0x62, 0xffff7b43 },
  { 0x74, 0xffff7b43 },
  { 0x75, 0xffff7b43 },
  { 0x76, 0xffff7b43 },
  { 0x77, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x63, 0x000084bd },
  { 0x64, 0x000084bd },
  { 0x65, 0x000084bd },
  { 0x6a, 0x0001097b },
  { 0x6f, 0x000084bd },
  { 0x71, 0x000084bd },
  { 0x76, 0xffff7b43 },
  { 0x77, 0xffff7b43 },
  { 0x78, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x63, 0x000084bd },
  { 0x64, 0x000084bd },
  { 0x65, 0x000084bd },
  { 0x6a, 0x0001097b },
  { 0x6f, 0x000084bd },
  { 0x71, 0x000084bd },
  { 0x76, 0xffff7b43 },
  { 0x77, 0xffff7b43 },
  { 0x78, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x77, 0xffff7b43 },
  { 0x79, 0xffff7b43 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x77, 0xffff7b43 }
};

static TFM::Kerning C_76_Kerning[] = {
  { 0x61, 0xfffef685 },
  { 0x61, 0xffff7b43 },
  { 0x63, 0xffff7b43 },
  { 0x65, 0xffff7b43 },
  { 0x6f, 0xffff7b43 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x61, 0xffff7b43 },
  { 0x63, 0xffff7b43 },
  { 0x65, 0xffff7b43 },
  { 0x6f, 0xffff7b43 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x2c, 0xfffe71c8 },
  { 0x2e, 0xfffe71c8 },
  { 0x61, 0xffff7b43 },
  { 0x65, 0xffff7b43 },
  { 0x6f, 0xffff7b43 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x000c0f23, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x000ffff5, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000ef67b, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x000d4db5, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000ce385, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000e5730, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000ded00, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000ef67b, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000ded00, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000ef67b, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000ded00, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000bc713, 0x000b1c73, 0x00000000, 0x00014bd8, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x000b4255, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x000b4255, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x0010e380, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x0010e380, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x0005a12b, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x000625e8, 0x0006e38d, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x0009c715, 0x000a0e3b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x0009c715, 0x0009425d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000e5730, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x0008bd9b, 0x00000000, 0x0002b8e5, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000ded00, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000ef67b, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x0009c715, 0x000871c8, 0x00018e3b, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00113e88, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x0013517d, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000ef67b, 0x000bb60d, 0x0000c71d, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x0005a12b, 0x0006e38d, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x0005a12b, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x000ffff5, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x0009c715, 0x000c0000, 0x0000e38d, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x000ffff5, 0x000c0000, 0x0000e38d, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x000ef67b, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x0005a12b, 0x000b1c73, 0x00000000, 0x00000000, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x0007b420, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x0007b420, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x0009c715, 0x000c0000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000ef67b, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x0005a12b, 0x0001ed0b, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0006aaa5, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x0005a12b, 0x0001ed0b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x0009c715, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x0009c715, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x0005a12b, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x0005a12b, 0x0006e38d, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x0005a12b, 0x00080000, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000ef67b, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x00094258, 0x00080000, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00094258, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000ef67b, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000e5730, 0x000aeef0, 0x00000000, 0x00000000, 10, C_41_Kerning, 0, 0 },
  { 0x42, 0x000d9d5b, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x000ded00, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x000ea6d5, 0x000aeef0, 0x00000000, 0x00000000, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x000d189d, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x000c93e0, 0x000aeef0, 0x00000000, 0x00000000, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000f1108, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x000e5730, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x000714d5, 0x000aeef0, 0x00000000, 0x00000000, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x0009fc2d, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x000edbed, 0x000aeef0, 0x00000000, 0x00000000, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000c0f23, 0x000aeef0, 0x00000000, 0x00000000, 4, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x001173a0, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x000e5730, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x000ef67b, 0x000aeef0, 0x00000000, 0x00000000, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000d189d, 0x000aeef0, 0x00000000, 0x00000000, 6, C_50_Kerning, 0, 0 },
  { 0x51, 0x000ef67b, 0x000aeef0, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x000e2218, 0x000aeef0, 0x00000000, 0x00000000, 10, C_52_Kerning, 0, 0 },
  { 0x53, 0x000ad090, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x000ded00, 0x000aeef0, 0x00000000, 0x00000000, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000e5730, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x56, 0x000e5730, 0x000aeef0, 0x00000000, 0x00004260, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x00138695, 0x000aeef0, 0x00000000, 0x00004260, 10, C_57_Kerning, 0, 0 },
  { 0x58, 0x000e5730, 0x000aeef0, 0x00000000, 0x00000000, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000e5730, 0x000aeef0, 0x00000000, 0x00007778, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000bda0b, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x0005a12b, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x0005a12b, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x0005a12b, 0x000acde3, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x0005a12b, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x0009c715, 0x0006e38d, 0x00000000, 0x00000000, 4, C_61_Kerning, 0, 0 },
  { 0x62, 0x000ad090, 0x000b1c73, 0x00000000, 0x00000000, 10, C_62_Kerning, 0, 0 },
  { 0x63, 0x0008bd9b, 0x0006e38d, 0x00000000, 0x00000000, 2, C_63_Kerning, 0, 0 },
  { 0x64, 0x000ad090, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x0008bd9d, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x000625e8, 0x000b1c73, 0x00000000, 0x00014bd8, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x0009c715, 0x0006e38d, 0x00031c73, 0x00004260, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x000ad090, 0x000b1c73, 0x00000000, 0x00000000, 6, C_68_Kerning, 0, 0 },
  { 0x69, 0x0005a12b, 0x000acde3, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x000625e8, 0x000acde3, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000a4bd3, 0x000b1c73, 0x00000000, 0x00000000, 5, C_6b_Kerning, 0, 0 },
  { 0x6c, 0x0005a12b, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000ffff5, 0x0006e38d, 0x00000000, 0x00000000, 6, C_6d_Kerning, 0, 0 },
  { 0x6e, 0x000ad090, 0x0006e38d, 0x00000000, 0x00000000, 6, C_6e_Kerning, 0, 0 },
  { 0x6f, 0x0009c715, 0x0006e38d, 0x00000000, 0x00000000, 10, C_6f_Kerning, 0, 0 },
  { 0x70, 0x000ad090, 0x0006e38d, 0x00031c73, 0x00000000, 10, C_70_Kerning, 0, 0 },
  { 0x71, 0x000a4bd3, 0x0006e38d, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x0007b420, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x0007cead, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x0007b420, 0x0009d75d, 0x00000000, 0x00000000, 2, C_74_Kerning, 0, 0 },
  { 0x75, 0x000ad090, 0x0006e38d, 0x00000000, 0x00000000, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x000a4bd3, 0x0006e38d, 0x00000000, 0x00004260, 5, C_76_Kerning, 0, 0 },
  { 0x77, 0x000ded00, 0x0006e38d, 0x00000000, 0x00004260, 4, C_77_Kerning, 0, 0 },
  { 0x78, 0x000a4bd3, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x000a4bd3, 0x0006e38d, 0x00031c73, 0x00004260, 5, C_79_Kerning, 0, 0 },
  { 0x7a, 0x0008bd9b, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x0009c715, 0x0006e38d, 0x00000000, 0x000084bd, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x00138e2b, 0x0006e38d, 0x00000000, 0x000084bd, 0, 0, 0, 0 },
  { 0x7d, 0x0009c715, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x0009c715, 0x000acde3, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x0009c715, 0x000acde3, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
cmr6_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
