// Copyright (C) 2000-2006, Luca Padovani <padovani@sti.uniurb.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <padovani@sti.uniurb.it>

#include "TFM.hh"

static TFM::Font font = {
"CMSY",

  0xec,
  "TeX math symbols",
  0x00900000,
  0xa9b190ca,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x001071c0 },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000a590b },
  { 0x09, "num2", 0x00068e24 },
  { 0x0a, "num3", 0x0007327c },
  { 0x0b, "denom1", 0x000ada00 },
  { 0x0c, "denom2", 0x00056deb },
  { 0x0d, "sup1", 0x0007af95 },
  { 0x0e, "sup2", 0x0006cc07 },
  { 0x0f, "sup3", 0x000497b4 },
  { 0x10, "sub1", 0x0001c71c },
  { 0x11, "sub2", 0x0002d09e },
  { 0x12, "supdrop", 0x0005a134 },
  { 0x13, "subdrop", 0x0000e38e },
  { 0x14, "delim1", 0x002a7d27 },
  { 0x15, "delim2", 0x00102d84 },
  { 0x16, "axis_height", 0x00040000 }
};


static TFM::Kerning C_41_Kerning[] = {
  { 0x30, 0x00033290 }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x30, 0x000248b0 }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x30, 0x000248b0 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x30, 0x00015ed0 }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x30, 0x0001d3c0 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x30, 0x0001d3c0 }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x30, 0x0001d3c0 }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x30, 0x0001d3c0 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x30, 0x000074f0 }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x30, 0x0002bda0 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x30, 0x0000e9e0 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x30, 0x000248b0 }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x30, 0x000248b0 }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x30, 0x00015ed0 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x30, 0x0001d3c0 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x30, 0x00015ed0 }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x30, 0x0001d3c0 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x30, 0x00015ed0 }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x30, 0x000248b0 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x30, 0x000074f0 }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x30, 0x00015ed0 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x30, 0x000074f0 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x30, 0x00015ed0 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x30, 0x000248b0 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x30, 0x00015ed0 }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x30, 0x000248b0 }
};


static TFM::Character character[] = {
  { 0x00, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x00049160, 0x00073290, 0xffff3290, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x000838e0, 0x000771c7, 0xffff71c7, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000838e0, 0x00073290, 0xffff3290, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x000cca40, 0x00097b40, 0x00017b40, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x001071c0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x000838e0, 0x00073290, 0xffff3290, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x000838e0, 0x00073290, 0xffff3290, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x000cca40, 0x00079357, 0xffff9357, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x000cca40, 0x00079357, 0xffff9357, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000cca40, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000cca40, 0x0007e639, 0xffffe639, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000cca40, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000cca40, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x001071c0, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x001071c0, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000cca40, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000cca40, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x001071c0, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x001071c0, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x000838e0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x000838e0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x001071c0, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x001071c0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x001071c0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x000cca40, 0x00079357, 0xffff9357, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x001071c0, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x001071c0, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000a0ca0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000a0ca0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x001071c0, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x001071c0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x001071c0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000cca40, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00047819, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x001071c0, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000af680, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000af680, 0x0008d0c9, 0x0000d0c9, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x000e9e00, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x000e9e00, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00000000, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00000000, 0x0005f4e9, 0xfffdf4e9, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000922c0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000922c0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000af680, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x000838e0, 0x000c0000, 0x0000e38e, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000be060, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000be060, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x000cca40, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000cca40, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000a0ca0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000d234b, 0x000aeeee, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000ac729, 0x000aeeee, 0x00000000, 0x00007652, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x0008ae60, 0x000aeeee, 0x00000000, 0x0000e60b, 1, C_43_Kerning, 0, 0 },
  { 0x44, 0x000cb33e, 0x000aeeee, 0x00000000, 0x000074f0, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x0008add0, 0x000aeeee, 0x00000000, 0x000168fc, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000bc807, 0x000aeeee, 0x00000000, 0x00019855, 1, C_46_Kerning, 0, 0 },
  { 0x47, 0x0009c647, 0x000aeeee, 0x00018e39, 0x0000eff0, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x000defd0, 0x000aeeee, 0x00000000, 0x00001822, 1, C_48_Kerning, 0, 0 },
  { 0x49, 0x000900e5, 0x000aeeee, 0x00000000, 0x000123e4, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000b2545, 0x000aeeee, 0x00018e39, 0x00000000, 1, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x000c83b9, 0x000aeeee, 0x00000000, 0x00002d47, 1, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000b53ac, 0x000aeeee, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x0013aaa4, 0x000aeeee, 0x00000000, 0x00000000, 1, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x000d792e, 0x000aeeee, 0x00000000, 0x00025ec0, 1, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x000d0fa7, 0x000aeeee, 0x00000000, 0x000074f0, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000b77e4, 0x000aeeee, 0x00000000, 0x0001525c, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x000d6df5, 0x000aeeee, 0x00018e39, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x000dfb6b, 0x000aeeee, 0x00000000, 0x00000000, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x0009f53c, 0x000aeeee, 0x00000000, 0x0001300e, 1, C_53_Kerning, 0, 0 },
  { 0x54, 0x000902b0, 0x000aeeee, 0x00000000, 0x00001822, 1, C_54_Kerning, 0, 0 },
  { 0x55, 0x000a46b4, 0x000aeeee, 0x00000000, 0x00019855, 1, C_55_Kerning, 0, 0 },
  { 0x56, 0x000a1cf0, 0x000aeeee, 0x00000000, 0x0001525c, 1, C_56_Kerning, 0, 0 },
  { 0x57, 0x00104797, 0x000aeeee, 0x00000000, 0x0001525c, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000bb804, 0x000aeeee, 0x00000000, 0x000257c5, 1, C_58_Kerning, 0, 0 },
  { 0x59, 0x000af5c2, 0x000aeeee, 0x00018e39, 0x0001525c, 1, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000bdf3e, 0x000aeeee, 0x00000000, 0x000146ab, 1, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x000af680, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000af680, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000af680, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000af680, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x000af680, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000a0ca0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000a0ca0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00074f00, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00074f00, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x00074f00, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00074f00, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x000838e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x000838e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x00066520, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x00066520, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00049160, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000838e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x000838e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000a0ca0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x000838e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x00049160, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000db420, 0x0000acf2, 0x000f530e, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x000c54ae, 0x000aeeee, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x000db420, 0x000aeeee, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x0006da12, 0x000b1c72, 0x00031c72, 0x0001d3c0, 0, 0, 0, 0 },
  { 0x74, 0x000af680, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x000af680, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x000cca40, 0x000a6f37, 0x00026f37, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x00074f00, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x00074f00, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x00074f00, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000a0ca0, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x000cca40, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x000cca40, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000cca40, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000cca40, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 }
};

void
cmsy9_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
