/* stream-view.c generated by valac 0.12.1, the Vala compiler
 * generated from stream-view.vala, do not modify */

/*
 * Copyright (C) 2010 Neil Jagdish Patel
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber-gtk.h"
#include <gtk/gtk.h>
#include <dee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gwibber.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <gdk/gdk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))

struct _GwibberGtkTileBoxPrivate {
	gint _last_height;
};

struct _GwibberGtkStreamViewPrivate {
	GtkAdjustment* adjustment;
	GtkVScrollbar* scrollbar;
	GwibberGtkTileBox* view_box;
	DeeModel* _model;
	DeeModel* _stream_filter_model;
	DeeFilter* stream_filter;
	DeeFilter* sort_filter;
	gint _position;
	gchar* _stream;
	gint _sort_order;
	guint refresh_id;
	gint tiles_visible;
	gboolean _prepared;
	gboolean _showing;
	gboolean _show_fullname;
	GSettings* settings;
	GSList* tiles;
	gint last_width;
	gint last_height;
};


static gpointer gwibber_gtk_tile_box_parent_class = NULL;
static gpointer gwibber_gtk_stream_view_parent_class = NULL;

#define GWIBBER_GTK_TILE_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_TILE_BOX, GwibberGtkTileBoxPrivate))
enum  {
	GWIBBER_GTK_TILE_BOX_DUMMY_PROPERTY,
	GWIBBER_GTK_TILE_BOX_LAST_HEIGHT
};
static void gwibber_gtk_tile_box_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* mh, gint* nh);
static void gwibber_gtk_tile_box_real_get_preferred_height (GtkWidget* base, gint* mh, gint* nh);
static GObject * gwibber_gtk_tile_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_gtk_tile_box_finalize (GObject* obj);
static void _vala_gwibber_gtk_tile_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_tile_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_GTK_STREAM_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_STREAM_VIEW, GwibberGtkStreamViewPrivate))
enum  {
	GWIBBER_GTK_STREAM_VIEW_DUMMY_PROPERTY,
	GWIBBER_GTK_STREAM_VIEW_MODEL,
	GWIBBER_GTK_STREAM_VIEW_STREAM_FILTER_MODEL,
	GWIBBER_GTK_STREAM_VIEW_POSITION,
	GWIBBER_GTK_STREAM_VIEW_STREAM,
	GWIBBER_GTK_STREAM_VIEW_SORT_ORDER,
	GWIBBER_GTK_STREAM_VIEW_SHOW_FULLNAME,
	GWIBBER_GTK_STREAM_VIEW_PREPARED,
	GWIBBER_GTK_STREAM_VIEW_SHOWING
};
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void gwibber_gtk_stream_view_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* mh, gint* nh);
static void gwibber_gtk_stream_view_real_get_preferred_height (GtkWidget* base, gint* mh, gint* nh);
static void gwibber_gtk_stream_view_refresh (GwibberGtkStreamView* self);
static gboolean _lambda27_ (GwibberGtkStreamView* self);
static void gwibber_gtk_stream_view_do_refresh (GwibberGtkStreamView* self);
static gboolean __lambda27__gsource_func (gpointer self);
static void gwibber_gtk_stream_view_fill_up_remaining_space (GwibberGtkStreamView* self);
static gchar** _variant_get1 (GVariant* value, int* result_length1);
static void _lambda28_ (const gchar* mid, const gchar* account, const gchar* sender, GwibberGtkStreamView* self);
static void __lambda28__gwibber_gtk_stream_view_tile_reply (GwibberGtkStreamViewTile* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self);
static gboolean _lambda29_ (GwibberGtkStreamView* self);
static gboolean __lambda29__gsource_func (gpointer self);
static gboolean _lambda30_ (GwibberGtkStreamView* self);
static gboolean __lambda30__gsource_func (gpointer self);
static void gwibber_gtk_stream_view_on_row_added (GwibberGtkStreamView* self);
static void gwibber_gtk_stream_view_on_row_removed (GwibberGtkStreamView* self);
static void gwibber_gtk_stream_view_on_row_changed (GwibberGtkStreamView* self);
static void gwibber_gtk_stream_view_on_synchronized (GwibberGtkStreamView* self);
static void _gwibber_gtk_stream_view_on_row_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _gwibber_gtk_stream_view_on_synchronized_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _lambda26_ (GwibberGtkStreamView* self);
static gboolean __lambda26__gsource_func (gpointer self);
static void gwibber_gtk_stream_view_real_reply (GwibberGtkStreamView* self, const gchar* mid, const gchar* account, const gchar* sender);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gwibber_gtk_stream_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda31_ (const gchar* key, GwibberGtkStreamView* self);
static void __lambda31__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda32_ (GwibberGtkStreamView* self);
static void __lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _lambda33_ (GtkWidget* source, GdkEventScroll* event, GwibberGtkStreamView* self);
static gboolean __lambda33__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static gboolean _lambda34_ (GtkWidget* source, GdkEventKey* event, GwibberGtkStreamView* self);
static gboolean __lambda34__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _lambda35_ (const gchar* mid, const gchar* account, const gchar* sender, GwibberGtkStreamView* self);
static void __lambda35__gwibber_gtk_stream_view_tile_reply (GwibberGtkStreamViewTile* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self);
static void _lambda36_ (GdkRectangle* a, GwibberGtkStreamView* self);
static void __lambda36__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void gwibber_gtk_stream_view_finalize (GObject* obj);
static void _vala_gwibber_gtk_stream_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_stream_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GwibberGtkTileBox* gwibber_gtk_tile_box_construct (GType object_type) {
	GwibberGtkTileBox * self = NULL;
	self = (GwibberGtkTileBox*) g_object_new (object_type, "homogeneous", FALSE, "spacing", 0, NULL);
	return self;
}


GwibberGtkTileBox* gwibber_gtk_tile_box_new (void) {
	return gwibber_gtk_tile_box_construct (GWIBBER_GTK_TYPE_TILE_BOX);
}


static void gwibber_gtk_tile_box_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* mh, gint* nh) {
	GwibberGtkTileBox * self;
	gint _mh = 0;
	gint _nh = 0;
	self = (GwibberGtkTileBox*) base;
	_nh = self->priv->_last_height;
	_mh = _nh;
	if (mh) {
		*mh = _mh;
	}
	if (nh) {
		*nh = _nh;
	}
}


static void gwibber_gtk_tile_box_real_get_preferred_height (GtkWidget* base, gint* mh, gint* nh) {
	GwibberGtkTileBox * self;
	gint _mh = 0;
	gint _nh = 0;
	self = (GwibberGtkTileBox*) base;
	_nh = self->priv->_last_height;
	_mh = _nh;
	if (mh) {
		*mh = _mh;
	}
	if (nh) {
		*nh = _nh;
	}
}


gint gwibber_gtk_tile_box_get_last_height (GwibberGtkTileBox* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_last_height;
	return result;
}


void gwibber_gtk_tile_box_set_last_height (GwibberGtkTileBox* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_last_height = value;
	g_object_notify ((GObject *) self, "last-height");
}


static GObject * gwibber_gtk_tile_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkTileBox * self;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_tile_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_TILE_BOX (obj);
	gwibber_gtk_tile_box_set_last_height (self, 200);
	return obj;
}


static void gwibber_gtk_tile_box_class_init (GwibberGtkTileBoxClass * klass) {
	gwibber_gtk_tile_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkTileBoxPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_height_for_width = gwibber_gtk_tile_box_real_get_preferred_height_for_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = gwibber_gtk_tile_box_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_tile_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_tile_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_tile_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_tile_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_TILE_BOX_LAST_HEIGHT, g_param_spec_int ("last-height", "last-height", "last-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gwibber_gtk_tile_box_instance_init (GwibberGtkTileBox * self) {
	self->priv = GWIBBER_GTK_TILE_BOX_GET_PRIVATE (self);
}


static void gwibber_gtk_tile_box_finalize (GObject* obj) {
	GwibberGtkTileBox * self;
	self = GWIBBER_GTK_TILE_BOX (obj);
	G_OBJECT_CLASS (gwibber_gtk_tile_box_parent_class)->finalize (obj);
}


GType gwibber_gtk_tile_box_get_type (void) {
	static volatile gsize gwibber_gtk_tile_box_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_tile_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkTileBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_tile_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkTileBox), 0, (GInstanceInitFunc) gwibber_gtk_tile_box_instance_init, NULL };
		GType gwibber_gtk_tile_box_type_id;
		gwibber_gtk_tile_box_type_id = g_type_register_static (GTK_TYPE_VBOX, "GwibberGtkTileBox", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_tile_box_type_id__volatile, gwibber_gtk_tile_box_type_id);
	}
	return gwibber_gtk_tile_box_type_id__volatile;
}


static void _vala_gwibber_gtk_tile_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkTileBox * self;
	self = GWIBBER_GTK_TILE_BOX (object);
	switch (property_id) {
		case GWIBBER_GTK_TILE_BOX_LAST_HEIGHT:
		g_value_set_int (value, gwibber_gtk_tile_box_get_last_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_tile_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkTileBox * self;
	self = GWIBBER_GTK_TILE_BOX (object);
	switch (property_id) {
		case GWIBBER_GTK_TILE_BOX_LAST_HEIGHT:
		gwibber_gtk_tile_box_set_last_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


GwibberGtkStreamView* gwibber_gtk_stream_view_construct (GType object_type) {
	GwibberGtkStreamView * self = NULL;
	self = (GwibberGtkStreamView*) g_object_new (object_type, "homogeneous", FALSE, "spacing", 0, NULL);
	return self;
}


GwibberGtkStreamView* gwibber_gtk_stream_view_new (void) {
	return gwibber_gtk_stream_view_construct (GWIBBER_GTK_TYPE_STREAM_VIEW);
}


static void gwibber_gtk_stream_view_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* mh, gint* nh) {
	GwibberGtkStreamView * self;
	gint _mh = 0;
	gint _nh = 0;
	self = (GwibberGtkStreamView*) base;
	_nh = self->priv->last_height;
	_mh = _nh;
	if (mh) {
		*mh = _mh;
	}
	if (nh) {
		*nh = _nh;
	}
}


static void gwibber_gtk_stream_view_real_get_preferred_height (GtkWidget* base, gint* mh, gint* nh) {
	GwibberGtkStreamView * self;
	gint _mh = 0;
	gint _nh = 0;
	self = (GwibberGtkStreamView*) base;
	_nh = self->priv->last_height;
	_mh = _nh;
	if (mh) {
		*mh = _mh;
	}
	if (nh) {
		*nh = _nh;
	}
}


static gboolean _lambda27_ (GwibberGtkStreamView* self) {
	gboolean result = FALSE;
	gwibber_gtk_stream_view_do_refresh (self);
	self->priv->refresh_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean __lambda27__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda27_ (self);
	return result;
}


static void gwibber_gtk_stream_view_refresh (GwibberGtkStreamView* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->refresh_id == 0) {
		gboolean _tmp1_;
		_tmp1_ = gwibber_gtk_stream_view_get_showing (self);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp2_;
		_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, __lambda27__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->refresh_id = _tmp2_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar** _variant_get1 (GVariant* value, int* result_length1) {
	gchar** _tmp13_;
	int _tmp13__length;
	int _tmp13__size;
	int _tmp13__length1;
	GVariantIter _tmp14_;
	GVariant* _tmp15_;
	_tmp13_ = g_new (gchar*, 5);
	_tmp13__length = 0;
	_tmp13__size = 4;
	_tmp13__length1 = 0;
	g_variant_iter_init (&_tmp14_, value);
	for (; (_tmp15_ = g_variant_iter_next_value (&_tmp14_)) != NULL; _tmp13__length1++) {
		if (_tmp13__size == _tmp13__length) {
			_tmp13__size = 2 * _tmp13__size;
			_tmp13_ = g_renew (gchar*, _tmp13_, _tmp13__size + 1);
		}
		_tmp13_[_tmp13__length++] = g_variant_dup_string (_tmp15_, NULL);
		g_variant_unref (_tmp15_);
	}
	*result_length1 = _tmp13__length1;
	_tmp13_[_tmp13__length] = NULL;
	return _tmp13_;
}


static void gwibber_gtk_stream_view_do_refresh (GwibberGtkStreamView* self) {
	gint i;
	DeeModel* _tmp0_ = NULL;
	DeeModel* _tmp2_ = NULL;
	guint _tmp3_;
	guint n_rows;
	DeeModelIter* iter = NULL;
	DeeModel* _tmp4_ = NULL;
	gint _tmp5_;
	DeeModelIter* _tmp6_ = NULL;
	gboolean _tmp87_;
	g_return_if_fail (self != NULL);
	i = 0;
	_tmp0_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
	if (!DEE_IS_FILTER_MODEL (_tmp0_)) {
		DeeModel* _tmp1_ = NULL;
		_tmp1_ = gwibber_gtk_stream_view_get_model (self);
		gwibber_gtk_stream_view_set_stream_filter_model (self, _tmp1_);
	}
	_tmp2_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
	_tmp3_ = dee_model_get_n_rows (_tmp2_);
	n_rows = _tmp3_;
	gwibber_gtk_stream_view_fill_up_remaining_space (self);
	_tmp4_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
	_tmp5_ = gwibber_gtk_stream_view_get_position (self);
	_tmp6_ = dee_model_get_iter_at_row (_tmp4_, (guint) _tmp5_);
	iter = _tmp6_;
	{
		GSList* tile_collection;
		GSList* tile_it;
		tile_collection = self->priv->tiles;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			GwibberGtkStreamViewTile* _tmp7_;
			GwibberGtkStreamViewTile* tile;
			_tmp7_ = _g_object_ref0 ((GwibberGtkStreamViewTile*) tile_it->data);
			tile = _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				gint _tmp83_;
				if (iter != NULL) {
					gint _tmp9_;
					_tmp9_ = gwibber_gtk_stream_view_get_position (self);
					_tmp8_ = (_tmp9_ + i) < n_rows;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					DeeModel* _tmp10_ = NULL;
					GVariant* _tmp11_ = NULL;
					gint _tmp12_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					DeeModel* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					DeeModel* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					DeeModel* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					DeeModel* _tmp23_ = NULL;
					gboolean _tmp24_;
					DeeModel* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					DeeModel* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					DeeModel* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					DeeModel* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					DeeModel* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					DeeModel* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					DeeModel* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					DeeModel* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					DeeModel* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					DeeModel* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					DeeModel* _tmp45_ = NULL;
					gdouble _tmp46_;
					DeeModel* _tmp47_ = NULL;
					const gchar* _tmp48_ = NULL;
					DeeModel* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					DeeModel* _tmp51_ = NULL;
					const gchar* _tmp52_ = NULL;
					DeeModel* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					DeeModel* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					DeeModel* _tmp57_ = NULL;
					const gchar* _tmp58_ = NULL;
					DeeModel* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					DeeModel* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					DeeModel* _tmp63_ = NULL;
					const gchar* _tmp64_ = NULL;
					DeeModel* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					DeeModel* _tmp67_ = NULL;
					const gchar* _tmp68_ = NULL;
					DeeModel* _tmp69_ = NULL;
					const gchar* _tmp70_ = NULL;
					DeeModel* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					DeeModel* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					DeeModel* _tmp75_ = NULL;
					const gchar* _tmp76_ = NULL;
					DeeModel* _tmp77_ = NULL;
					const gchar* _tmp78_ = NULL;
					DeeModel* _tmp79_ = NULL;
					const gchar* _tmp80_ = NULL;
					DeeModel* _tmp81_ = NULL;
					const gchar* _tmp82_ = NULL;
					_tmp10_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp11_ = dee_model_get_value (_tmp10_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS);
					_tmp16_ = _variant_get1 (_tmp11_, &_tmp12_);
					_tmp16__length1 = _tmp12_;
					_tmp17_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp18_ = dee_model_get_string (_tmp17_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
					_tmp19_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp20_ = dee_model_get_string (_tmp19_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER);
					_tmp21_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp22_ = dee_model_get_string (_tmp21_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER_NICK);
					_tmp23_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp24_ = dee_model_get_bool (_tmp23_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_FROM_ME);
					_tmp25_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp26_ = dee_model_get_string (_tmp25_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP);
					_tmp27_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp28_ = dee_model_get_string (_tmp27_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE);
					_tmp29_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp30_ = dee_model_get_string (_tmp29_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_HTML);
					_tmp31_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp32_ = dee_model_get_string (_tmp31_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_ICON_URI);
					_tmp33_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp34_ = dee_model_get_string (_tmp33_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_URL);
					_tmp35_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp36_ = dee_model_get_string (_tmp35_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_SOURCE);
					_tmp37_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp38_ = dee_model_get_string (_tmp37_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTRING);
					_tmp39_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp40_ = dee_model_get_string (_tmp39_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_REPLY_NICK);
					_tmp41_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp42_ = dee_model_get_string (_tmp41_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_REPLY_NAME);
					_tmp43_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp44_ = dee_model_get_string (_tmp43_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_REPLY_URL);
					_tmp45_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp46_ = dee_model_get_double (_tmp45_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LIKES);
					_tmp47_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp48_ = dee_model_get_string (_tmp47_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_RETWEET_NICK);
					_tmp49_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp50_ = dee_model_get_string (_tmp49_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_RETWEET_NAME);
					_tmp51_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp52_ = dee_model_get_string (_tmp51_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_RETWEET_ID);
					_tmp53_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp54_ = dee_model_get_string (_tmp53_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LINK_PICTURE);
					_tmp55_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp56_ = dee_model_get_string (_tmp55_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LINK_NAME);
					_tmp57_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp58_ = dee_model_get_string (_tmp57_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LINK_URL);
					_tmp59_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp60_ = dee_model_get_string (_tmp59_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LINK_DESC);
					_tmp61_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp62_ = dee_model_get_string (_tmp61_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LINK_CAPTION);
					_tmp63_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp64_ = dee_model_get_string (_tmp63_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LINK_ICON);
					_tmp65_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp66_ = dee_model_get_string (_tmp65_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_IMG_URL);
					_tmp67_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp68_ = dee_model_get_string (_tmp67_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_IMG_SRC);
					_tmp69_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp70_ = dee_model_get_string (_tmp69_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_IMG_THUMB);
					_tmp71_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp72_ = dee_model_get_string (_tmp71_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_IMG_NAME);
					_tmp73_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp74_ = dee_model_get_string (_tmp73_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_VIDEO_PIC);
					_tmp75_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp76_ = dee_model_get_string (_tmp75_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_VIDEO_SRC);
					_tmp77_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp78_ = dee_model_get_string (_tmp77_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_VIDEO_URL);
					_tmp79_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp80_ = dee_model_get_string (_tmp79_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_VIDEO_NAME);
					_tmp81_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp82_ = dee_model_get_string (_tmp81_, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_COMMENTS);
					gwibber_gtk_stream_view_tile_set_details (tile, _tmp16_, _tmp12_, _tmp18_, _tmp20_, _tmp22_, _tmp24_, _tmp26_, _tmp28_, _tmp30_, _tmp32_, _tmp34_, _tmp36_, _tmp38_, _tmp40_, _tmp42_, _tmp44_, _tmp46_, _tmp48_, _tmp50_, _tmp52_, _tmp54_, _tmp56_, _tmp58_, _tmp60_, _tmp62_, _tmp64_, _tmp66_, _tmp68_, _tmp70_, _tmp72_, _tmp74_, _tmp76_, _tmp78_, _tmp80_, _tmp82_);
					_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
					self->priv->tiles_visible = i + 1;
				} else {
					gwibber_gtk_stream_view_tile_reset (tile);
					self->priv->tiles_visible = i - 1;
				}
				i++;
				_tmp83_ = gwibber_gtk_stream_view_get_position (self);
				if ((_tmp83_ + i) > n_rows) {
					iter = NULL;
				} else {
					DeeModel* _tmp84_ = NULL;
					gint _tmp85_;
					DeeModelIter* _tmp86_ = NULL;
					_tmp84_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
					_tmp85_ = gwibber_gtk_stream_view_get_position (self);
					_tmp86_ = dee_model_get_iter_at_row (_tmp84_, (guint) (_tmp85_ + i));
					iter = _tmp86_;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	_tmp87_ = gwibber_gtk_stream_view_get_prepared (self);
	if (!_tmp87_) {
		gwibber_gtk_stream_view_set_prepared (self, TRUE);
	}
}


static void _lambda28_ (const gchar* mid, const gchar* account, const gchar* sender, GwibberGtkStreamView* self) {
	g_return_if_fail (mid != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit_by_name (self, "reply", mid, account, sender);
}


static void __lambda28__gwibber_gtk_stream_view_tile_reply (GwibberGtkStreamViewTile* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self) {
	_lambda28_ (mid, account, sender, self);
}


static gboolean _lambda29_ (GwibberGtkStreamView* self) {
	gboolean result = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	gwibber_gtk_stream_view_do_refresh (self);
	result = FALSE;
	return result;
}


static gboolean __lambda29__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda29_ (self);
	return result;
}


static gboolean _lambda30_ (GwibberGtkStreamView* self) {
	gboolean result = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	gwibber_gtk_stream_view_do_refresh (self);
	result = FALSE;
	return result;
}


static gboolean __lambda30__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda30_ (self);
	return result;
}


static void gwibber_gtk_stream_view_fill_up_remaining_space (GwibberGtkStreamView* self) {
	GtkAllocation alloc = {0};
	gint overall_height;
	gint largest_tile;
	gboolean one_was_hidden;
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	overall_height = 0;
	largest_tile = 0;
	one_was_hidden = FALSE;
	gtk_widget_get_allocation ((GtkWidget*) self->priv->view_box, &_tmp0_);
	alloc = _tmp0_;
	{
		GSList* tile_collection;
		GSList* tile_it;
		tile_collection = self->priv->tiles;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			GwibberGtkStreamViewTile* _tmp1_;
			GwibberGtkStreamViewTile* tile;
			_tmp1_ = _g_object_ref0 ((GwibberGtkStreamViewTile*) tile_it->data);
			tile = _tmp1_;
			{
				GtkAllocation a = {0};
				gboolean _tmp2_;
				_tmp2_ = gtk_widget_get_visible ((GtkWidget*) tile);
				if (_tmp2_) {
					GtkAllocation _tmp3_ = {0};
					gtk_widget_get_allocation ((GtkWidget*) tile, &_tmp3_);
					a = _tmp3_;
					overall_height = overall_height + a.height;
					if (a.height > largest_tile) {
						largest_tile = a.height;
					}
				} else {
					one_was_hidden = TRUE;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	if (alloc.height > overall_height) {
		_tmp4_ = !one_was_hidden;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp5_;
		GwibberGtkStreamViewTile* _tmp6_ = NULL;
		GwibberGtkStreamViewTile* tile;
		GwibberGtkStreamViewTile* _tmp7_;
		_tmp5_ = gwibber_gtk_stream_view_get_show_fullname (self);
		_tmp6_ = gwibber_gtk_stream_view_tile_new (self->utils, self->service, _tmp5_);
		tile = g_object_ref_sink (_tmp6_);
		gtk_widget_show_all ((GtkWidget*) tile);
		gtk_box_pack_start ((GtkBox*) self->priv->view_box, (GtkWidget*) tile, FALSE, FALSE, (guint) 0);
		_tmp7_ = _g_object_ref0 (tile);
		self->priv->tiles = g_slist_append (self->priv->tiles, _tmp7_);
		g_signal_connect_object (tile, "reply", (GCallback) __lambda28__gwibber_gtk_stream_view_tile_reply, self, 0);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda29__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (tile);
		return;
	}
	if (alloc.height < (overall_height - (largest_tile * 3))) {
		guint _tmp8_;
		gconstpointer _tmp9_ = NULL;
		GwibberGtkStreamViewTile* _tmp10_;
		GwibberGtkStreamViewTile* last_tile;
		_tmp8_ = g_slist_length (self->priv->tiles);
		_tmp9_ = g_slist_nth_data (self->priv->tiles, _tmp8_ - 1);
		_tmp10_ = _g_object_ref0 ((GwibberGtkStreamViewTile*) _tmp9_);
		last_tile = _tmp10_;
		gwibber_gtk_stream_view_tile_reset (last_tile);
		gtk_widget_destroy ((GtkWidget*) last_tile);
		self->priv->tiles = g_slist_remove (self->priv->tiles, last_tile);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda30__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (last_tile);
		return;
	}
}


static void gwibber_gtk_stream_view_on_row_added (GwibberGtkStreamView* self) {
	g_return_if_fail (self != NULL);
	gwibber_gtk_stream_view_refresh (self);
}


static void gwibber_gtk_stream_view_on_row_removed (GwibberGtkStreamView* self) {
	g_return_if_fail (self != NULL);
	gwibber_gtk_stream_view_refresh (self);
}


static void gwibber_gtk_stream_view_on_row_changed (GwibberGtkStreamView* self) {
	g_return_if_fail (self != NULL);
	gwibber_gtk_stream_view_refresh (self);
}


static void gwibber_gtk_stream_view_on_synchronized (GwibberGtkStreamView* self) {
	DeeModel* _tmp0_ = NULL;
	DeeModel* _tmp1_ = NULL;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_debug ("stream-view.vala:503: on_synchronized");
	_tmp0_ = gwibber_gtk_stream_view_get_model (self);
	gwibber_gtk_stream_view_set_stream_filter_model (self, _tmp0_);
	_tmp1_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
	_tmp2_ = dee_model_get_n_rows (_tmp1_);
	gtk_adjustment_set_upper (self->priv->adjustment, (gdouble) _tmp2_);
	gwibber_gtk_stream_view_refresh (self);
}


DeeModel* gwibber_gtk_stream_view_get_model (GwibberGtkStreamView* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_model;
	return result;
}


static void _gwibber_gtk_stream_view_on_row_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	gwibber_gtk_stream_view_on_row_added (self);
}


static void _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	gwibber_gtk_stream_view_on_row_removed (self);
}


static void _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	gwibber_gtk_stream_view_on_row_changed (self);
}


static void _gwibber_gtk_stream_view_on_synchronized_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gwibber_gtk_stream_view_on_synchronized (self);
}


void gwibber_gtk_stream_view_set_model (GwibberGtkStreamView* self, DeeModel* value) {
	DeeModel* _tmp5_;
	g_return_if_fail (self != NULL);
	if (DEE_IS_MODEL (self->priv->_model)) {
		guint _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		g_signal_parse_name ("row-added", DEE_TYPE_MODEL, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gwibber_gtk_stream_view_on_row_added_dee_model_row_added, self);
		g_signal_parse_name ("row-removed", DEE_TYPE_MODEL, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed, self);
		g_signal_parse_name ("row-changed", DEE_TYPE_MODEL, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed, self);
		if (DEE_IS_SHARED_MODEL (self->priv->_model)) {
			guint _tmp3_;
			GQuark _tmp4_;
			g_signal_parse_name ("notify::synchronized", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
			g_signal_handlers_disconnect_matched ((GObject*) self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _gwibber_gtk_stream_view_on_synchronized_g_object_notify, self);
		}
	}
	_tmp5_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp5_;
	g_signal_connect_object (self->priv->_model, "row-added", (GCallback) _gwibber_gtk_stream_view_on_row_added_dee_model_row_added, self, 0);
	g_signal_connect_object (self->priv->_model, "row-removed", (GCallback) _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed, self, 0);
	g_signal_connect_object (self->priv->_model, "row-changed", (GCallback) _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed, self, 0);
	if (DEE_IS_SHARED_MODEL (self->priv->_model)) {
		g_signal_connect_object ((GObject*) self->priv->_model, "notify::synchronized", (GCallback) _gwibber_gtk_stream_view_on_synchronized_g_object_notify, self, 0);
	}
	g_object_notify ((GObject *) self, "model");
}


DeeModel* gwibber_gtk_stream_view_get_stream_filter_model (GwibberGtkStreamView* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_stream_filter_model;
	return result;
}


static gboolean _lambda26_ (GwibberGtkStreamView* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	_tmp0_ = dee_model_get_n_rows (self->priv->_stream_filter_model);
	gtk_adjustment_set_upper (self->priv->adjustment, (gdouble) _tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda26__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda26_ (self);
	return result;
}


void gwibber_gtk_stream_view_set_stream_filter_model (GwibberGtkStreamView* self, DeeModel* value) {
	gint _tmp0_;
	DeeModel* _tmp3_ = NULL;
	DeeFilterModel* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gwibber_gtk_stream_view_get_sort_order (self);
	if (_tmp0_ == 0) {
		DeeFilter* _tmp1_ = NULL;
		_tmp1_ = dee_filter_new_collator ((guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP);
		self->priv->sort_filter = _tmp1_;
	} else {
		DeeFilter* _tmp2_ = NULL;
		_tmp2_ = dee_filter_new_collator_desc ((guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP);
		self->priv->sort_filter = _tmp2_;
	}
	_tmp3_ = gwibber_gtk_stream_view_get_model (self);
	_tmp4_ = (DeeFilterModel*) dee_filter_model_new (self->priv->sort_filter, _tmp3_);
	_g_object_unref0 (self->priv->_stream_filter_model);
	self->priv->_stream_filter_model = (DeeModel*) _tmp4_;
	gwibber_gtk_stream_view_refresh (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda26__gsource_func, g_object_ref (self), g_object_unref);
	g_object_notify ((GObject *) self, "stream-filter-model");
}


gint gwibber_gtk_stream_view_get_position (GwibberGtkStreamView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_position;
	return result;
}


void gwibber_gtk_stream_view_set_position (GwibberGtkStreamView* self, gint value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_position != value) {
		DeeModel* _tmp0_ = NULL;
		guint _tmp1_;
		gint _tmp2_;
		gdouble _tmp3_;
		self->priv->_position = value;
		_tmp0_ = gwibber_gtk_stream_view_get_stream_filter_model (self);
		_tmp1_ = dee_model_get_n_rows (_tmp0_);
		_tmp2_ = CLAMP (self->priv->_position, 0, (gint) _tmp1_);
		self->priv->_position = _tmp2_;
		_tmp3_ = gtk_adjustment_get_value (self->priv->adjustment);
		if (self->priv->_position != _tmp3_) {
			gtk_adjustment_set_value (self->priv->adjustment, (gdouble) self->priv->_position);
			gwibber_gtk_stream_view_refresh (self);
		}
	}
	g_object_notify ((GObject *) self, "position");
}


const gchar* gwibber_gtk_stream_view_get_stream (GwibberGtkStreamView* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_stream;
	return result;
}


void gwibber_gtk_stream_view_set_stream (GwibberGtkStreamView* self, const gchar* value) {
	gchar* _tmp0_;
	DeeModel* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_stream);
	self->priv->_stream = _tmp0_;
	_tmp1_ = gwibber_gtk_stream_view_get_model (self);
	gwibber_gtk_stream_view_set_stream_filter_model (self, _tmp1_);
	g_object_notify ((GObject *) self, "stream");
}


gint gwibber_gtk_stream_view_get_sort_order (GwibberGtkStreamView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sort_order;
	return result;
}


void gwibber_gtk_stream_view_set_sort_order (GwibberGtkStreamView* self, gint value) {
	g_return_if_fail (self != NULL);
	if (value != self->priv->_sort_order) {
		DeeModel* _tmp0_ = NULL;
		self->priv->_sort_order = value;
		_tmp0_ = gwibber_gtk_stream_view_get_model (self);
		gwibber_gtk_stream_view_set_stream_filter_model (self, _tmp0_);
	}
	g_object_notify ((GObject *) self, "sort-order");
}


gboolean gwibber_gtk_stream_view_get_show_fullname (GwibberGtkStreamView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_fullname;
	return result;
}


void gwibber_gtk_stream_view_set_show_fullname (GwibberGtkStreamView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (value != self->priv->_show_fullname) {
		self->priv->_show_fullname = value;
	}
	g_object_notify ((GObject *) self, "show-fullname");
}


gboolean gwibber_gtk_stream_view_get_prepared (GwibberGtkStreamView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prepared;
	return result;
}


void gwibber_gtk_stream_view_set_prepared (GwibberGtkStreamView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (value != self->priv->_prepared) {
		self->priv->_prepared = value;
	}
	g_object_notify ((GObject *) self, "prepared");
}


gboolean gwibber_gtk_stream_view_get_showing (GwibberGtkStreamView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_showing;
	return result;
}


void gwibber_gtk_stream_view_set_showing (GwibberGtkStreamView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (value != self->priv->_showing) {
		self->priv->_showing = value;
	}
	if (self->priv->_showing) {
		guint _tmp0_;
		const gchar* _tmp1_ = NULL;
		_tmp0_ = dee_model_get_n_rows (self->priv->_stream_filter_model);
		gtk_adjustment_set_upper (self->priv->adjustment, (gdouble) _tmp0_);
		_tmp1_ = gwibber_gtk_stream_view_get_stream (self);
		gwibber_service_update_indicators (self->service, _tmp1_);
		gwibber_gtk_stream_view_refresh (self);
	}
	g_object_notify ((GObject *) self, "showing");
}


static void gwibber_gtk_stream_view_real_reply (GwibberGtkStreamView* self, const gchar* mid, const gchar* account, const gchar* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mid != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void _lambda31_ (const gchar* key, GwibberGtkStreamView* self) {
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "show-fullname") == 0) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = gwibber_gtk_stream_view_get_show_fullname (self);
		_tmp1_ = g_settings_get_boolean (self->priv->settings, "show-fullname");
		if (_tmp0_ != _tmp1_) {
			gboolean _tmp2_;
			_tmp2_ = g_settings_get_boolean (self->priv->settings, "show-fullname");
			gwibber_gtk_stream_view_set_show_fullname (self, _tmp2_);
		}
	}
}


static void __lambda31__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda31_ (key, self);
}


static void _lambda32_ (GwibberGtkStreamView* self) {
	gdouble _tmp0_;
	gdouble v;
	gint _tmp1_;
	_tmp0_ = gtk_adjustment_get_value (self->priv->adjustment);
	v = _tmp0_;
	_tmp1_ = gwibber_gtk_stream_view_get_position (self);
	if (((gdouble) _tmp1_) != v) {
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		_tmp3_ = gwibber_gtk_stream_view_get_position (self);
		if (((gdouble) _tmp3_) < v) {
			gint _tmp4_;
			_tmp4_ = gwibber_gtk_stream_view_get_position (self);
			_tmp2_ = v < (_tmp4_ + 1);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp5_;
			_tmp5_ = gwibber_gtk_stream_view_get_position (self);
			gwibber_gtk_stream_view_set_position (self, _tmp5_ + 1);
		} else {
			gboolean _tmp6_ = FALSE;
			gint _tmp7_;
			_tmp7_ = gwibber_gtk_stream_view_get_position (self);
			if (((gdouble) _tmp7_) > v) {
				gint _tmp8_;
				_tmp8_ = gwibber_gtk_stream_view_get_position (self);
				_tmp6_ = v > (_tmp8_ - 1);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				gint _tmp9_;
				_tmp9_ = gwibber_gtk_stream_view_get_position (self);
				gwibber_gtk_stream_view_set_position (self, _tmp9_ - 1);
			} else {
				gdouble _tmp10_;
				_tmp10_ = gtk_adjustment_get_value (self->priv->adjustment);
				gwibber_gtk_stream_view_set_position (self, (gint) _tmp10_);
			}
		}
	}
}


static void __lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda32_ (self);
}


static gboolean _lambda33_ (GtkWidget* source, GdkEventScroll* event, GwibberGtkStreamView* self) {
	gboolean result = FALSE;
	GdkScrollDirection direction;
	g_return_val_if_fail (source != NULL, FALSE);
	direction = (*event).direction;
	if ((*event).direction == GDK_SCROLL_UP) {
		gint _tmp0_;
		_tmp0_ = gwibber_gtk_stream_view_get_position (self);
		if (_tmp0_ > 0) {
			gint _tmp1_;
			_tmp1_ = gwibber_gtk_stream_view_get_position (self);
			gwibber_gtk_stream_view_set_position (self, _tmp1_ - 1);
		}
	}
	if ((*event).direction == GDK_SCROLL_DOWN) {
		gint _tmp2_;
		gdouble _tmp3_;
		_tmp2_ = gwibber_gtk_stream_view_get_position (self);
		_tmp3_ = gtk_adjustment_get_upper (self->priv->adjustment);
		if (_tmp2_ < (_tmp3_ - self->priv->tiles_visible)) {
			gint _tmp4_;
			_tmp4_ = gwibber_gtk_stream_view_get_position (self);
			gwibber_gtk_stream_view_set_position (self, _tmp4_ + 1);
		}
	}
	result = TRUE;
	return result;
}


static gboolean __lambda33__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = _lambda33_ (_sender, event, self);
	return result;
}


static gboolean _lambda34_ (GtkWidget* source, GdkEventKey* event, GwibberGtkStreamView* self) {
	gboolean result = FALSE;
	guint key;
	g_return_val_if_fail (source != NULL, FALSE);
	key = (*event).keyval;
	switch ((*event).keyval) {
		case 0xff55:
		case 0xff9a:
		{
			gint _tmp0_;
			_tmp0_ = gwibber_gtk_stream_view_get_position (self);
			gwibber_gtk_stream_view_set_position (self, _tmp0_ - self->priv->tiles_visible);
			break;
		}
		case 0xff56:
		case 0xff9b:
		{
			gint _tmp1_;
			_tmp1_ = gwibber_gtk_stream_view_get_position (self);
			gwibber_gtk_stream_view_set_position (self, _tmp1_ + self->priv->tiles_visible);
			break;
		}
		case 0xff54:
		case 0xff99:
		{
			gint _tmp2_;
			_tmp2_ = gwibber_gtk_stream_view_get_position (self);
			gwibber_gtk_stream_view_set_position (self, _tmp2_ + 1);
			break;
		}
		case 0xff52:
		case 0xff97:
		{
			gint _tmp3_;
			_tmp3_ = gwibber_gtk_stream_view_get_position (self);
			gwibber_gtk_stream_view_set_position (self, _tmp3_ - 1);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean __lambda34__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _lambda34_ (_sender, event, self);
	return result;
}


static void _lambda35_ (const gchar* mid, const gchar* account, const gchar* sender, GwibberGtkStreamView* self) {
	g_return_if_fail (mid != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit_by_name (self, "reply", mid, account, sender);
}


static void __lambda35__gwibber_gtk_stream_view_tile_reply (GwibberGtkStreamViewTile* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self) {
	_lambda35_ (mid, account, sender, self);
}


static void _lambda36_ (GdkRectangle* a, GwibberGtkStreamView* self) {
	gboolean _tmp0_ = FALSE;
	if (self->priv->last_width != (*a).width) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->last_height != (*a).height;
	}
	if (_tmp0_) {
		self->priv->last_width = (*a).width;
		self->priv->last_height = (*a).height;
		gwibber_gtk_tile_box_set_last_height (self->priv->view_box, self->priv->last_height);
		gwibber_gtk_stream_view_refresh (self);
	}
}


static void __lambda36__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda36_ (allocation, self);
}


static GObject * gwibber_gtk_stream_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkStreamView * self;
	GwibberUtils* _tmp0_ = NULL;
	GwibberService* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gboolean _tmp3_;
	GtkAdjustment* _tmp4_ = NULL;
	GwibberGtkTileBox* _tmp5_ = NULL;
	GtkVScrollbar* _tmp6_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_stream_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_STREAM_VIEW (obj);
	setlocale (LC_COLLATE, "C");
	_tmp0_ = gwibber_utils_new ();
	_g_object_unref0 (self->utils);
	self->utils = _tmp0_;
	_tmp1_ = gwibber_service_new ();
	_g_object_unref0 (self->service);
	self->service = _tmp1_;
	_tmp2_ = g_settings_new ("org.gwibber.preferences");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = g_settings_get_boolean (self->priv->settings, "show-fullname");
	gwibber_gtk_stream_view_set_show_fullname (self, _tmp3_);
	g_signal_connect_object (self->priv->settings, "changed", (GCallback) __lambda31__g_settings_changed, self, 0);
	_tmp4_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_g_object_unref0 (self->priv->adjustment);
	self->priv->adjustment = g_object_ref_sink (_tmp4_);
	g_signal_connect_object ((GObject*) self->priv->adjustment, "notify::value", (GCallback) __lambda32__g_object_notify, self, 0);
	_tmp5_ = gwibber_gtk_tile_box_new ();
	_g_object_unref0 (self->priv->view_box);
	self->priv->view_box = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->view_box, TRUE, TRUE, (guint) 0);
	_tmp6_ = (GtkVScrollbar*) gtk_vscrollbar_new (self->priv->adjustment);
	_g_object_unref0 (self->priv->scrollbar);
	self->priv->scrollbar = g_object_ref_sink (_tmp6_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->scrollbar, FALSE, FALSE, (guint) 0);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_KEY_PRESS_MASK | GDK_SCROLL_MASK));
	g_signal_connect_object ((GtkWidget*) self, "scroll-event", (GCallback) __lambda33__gtk_widget_scroll_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) __lambda34__gtk_widget_key_press_event, self, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				GwibberGtkStreamViewTile* _tmp9_ = NULL;
				GwibberGtkStreamViewTile* tile;
				GwibberGtkStreamViewTile* _tmp10_;
				if (!_tmp7_) {
					i++;
				}
				_tmp7_ = FALSE;
				if (!(i < 15)) {
					break;
				}
				_tmp8_ = gwibber_gtk_stream_view_get_show_fullname (self);
				_tmp9_ = gwibber_gtk_stream_view_tile_new (self->utils, self->service, _tmp8_);
				tile = g_object_ref_sink (_tmp9_);
				gtk_widget_show_all ((GtkWidget*) tile);
				gtk_box_pack_start ((GtkBox*) self->priv->view_box, (GtkWidget*) tile, FALSE, FALSE, (guint) 0);
				_tmp10_ = _g_object_ref0 (tile);
				self->priv->tiles = g_slist_append (self->priv->tiles, _tmp10_);
				g_signal_connect_object (tile, "reply", (GCallback) __lambda35__gwibber_gtk_stream_view_tile_reply, self, 0);
				_g_object_unref0 (tile);
			}
		}
	}
	g_signal_connect_object ((GtkWidget*) self->priv->view_box, "size-allocate", (GCallback) __lambda36__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	return obj;
}


static void gwibber_gtk_stream_view_class_init (GwibberGtkStreamViewClass * klass) {
	gwibber_gtk_stream_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkStreamViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_height_for_width = gwibber_gtk_stream_view_real_get_preferred_height_for_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = gwibber_gtk_stream_view_real_get_preferred_height;
	GWIBBER_GTK_STREAM_VIEW_CLASS (klass)->reply = gwibber_gtk_stream_view_real_reply;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_stream_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_stream_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_stream_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_stream_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_MODEL, g_param_spec_object ("model", "model", "model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_STREAM_FILTER_MODEL, g_param_spec_object ("stream-filter-model", "stream-filter-model", "stream-filter-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_POSITION, g_param_spec_int ("position", "position", "position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_STREAM, g_param_spec_string ("stream", "stream", "stream", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_SORT_ORDER, g_param_spec_int ("sort-order", "sort-order", "sort-order", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_SHOW_FULLNAME, g_param_spec_boolean ("show-fullname", "show-fullname", "show-fullname", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_PREPARED, g_param_spec_boolean ("prepared", "prepared", "prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_SHOWING, g_param_spec_boolean ("showing", "showing", "showing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("reply", GWIBBER_GTK_TYPE_STREAM_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberGtkStreamViewClass, reply), NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
}


static void gwibber_gtk_stream_view_instance_init (GwibberGtkStreamView * self) {
	gchar* _tmp0_;
	self->priv = GWIBBER_GTK_STREAM_VIEW_GET_PRIVATE (self);
	self->priv->_model = NULL;
	self->priv->_stream_filter_model = NULL;
	self->priv->_position = 0;
	_tmp0_ = g_strdup ("home");
	self->priv->_stream = _tmp0_;
	self->priv->_sort_order = 1;
	self->priv->refresh_id = (guint) 0;
	self->priv->tiles_visible = 0;
	self->priv->_prepared = FALSE;
	self->priv->_showing = FALSE;
	self->priv->last_width = 0;
	self->priv->last_height = 0;
}


static void gwibber_gtk_stream_view_finalize (GObject* obj) {
	GwibberGtkStreamView * self;
	self = GWIBBER_GTK_STREAM_VIEW (obj);
	_g_object_unref0 (self->priv->_stream_filter_model);
	self->priv->_stream_filter_model = NULL;
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = NULL;
	_g_object_unref0 (self->priv->adjustment);
	_g_object_unref0 (self->priv->scrollbar);
	_g_object_unref0 (self->priv->view_box);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_stream_filter_model);
	_g_free0 (self->priv->_stream);
	_g_object_unref0 (self->utils);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->priv->settings);
	__g_slist_free__g_object_unref0_0 (self->priv->tiles);
	G_OBJECT_CLASS (gwibber_gtk_stream_view_parent_class)->finalize (obj);
}


GType gwibber_gtk_stream_view_get_type (void) {
	static volatile gsize gwibber_gtk_stream_view_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_stream_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkStreamViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_stream_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkStreamView), 0, (GInstanceInitFunc) gwibber_gtk_stream_view_instance_init, NULL };
		GType gwibber_gtk_stream_view_type_id;
		gwibber_gtk_stream_view_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberGtkStreamView", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_stream_view_type_id__volatile, gwibber_gtk_stream_view_type_id);
	}
	return gwibber_gtk_stream_view_type_id__volatile;
}


static void _vala_gwibber_gtk_stream_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkStreamView * self;
	self = GWIBBER_GTK_STREAM_VIEW (object);
	switch (property_id) {
		case GWIBBER_GTK_STREAM_VIEW_MODEL:
		g_value_set_object (value, gwibber_gtk_stream_view_get_model (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_STREAM_FILTER_MODEL:
		g_value_set_object (value, gwibber_gtk_stream_view_get_stream_filter_model (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_POSITION:
		g_value_set_int (value, gwibber_gtk_stream_view_get_position (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_STREAM:
		g_value_set_string (value, gwibber_gtk_stream_view_get_stream (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_SORT_ORDER:
		g_value_set_int (value, gwibber_gtk_stream_view_get_sort_order (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_SHOW_FULLNAME:
		g_value_set_boolean (value, gwibber_gtk_stream_view_get_show_fullname (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_PREPARED:
		g_value_set_boolean (value, gwibber_gtk_stream_view_get_prepared (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_SHOWING:
		g_value_set_boolean (value, gwibber_gtk_stream_view_get_showing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_stream_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkStreamView * self;
	self = GWIBBER_GTK_STREAM_VIEW (object);
	switch (property_id) {
		case GWIBBER_GTK_STREAM_VIEW_MODEL:
		gwibber_gtk_stream_view_set_model (self, g_value_get_object (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_STREAM_FILTER_MODEL:
		gwibber_gtk_stream_view_set_stream_filter_model (self, g_value_get_object (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_POSITION:
		gwibber_gtk_stream_view_set_position (self, g_value_get_int (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_STREAM:
		gwibber_gtk_stream_view_set_stream (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_SORT_ORDER:
		gwibber_gtk_stream_view_set_sort_order (self, g_value_get_int (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_SHOW_FULLNAME:
		gwibber_gtk_stream_view_set_show_fullname (self, g_value_get_boolean (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_PREPARED:
		gwibber_gtk_stream_view_set_prepared (self, g_value_get_boolean (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_SHOWING:
		gwibber_gtk_stream_view_set_showing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



