/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

private class Poster : Gtk.Window
{
  private StreamEntry? _entry = null;
  public GwibberGtk.InputTextView text_view;

  public Poster ()
  {
    set_decorated (false);
    set_skip_taskbar_hint (true);
    set_has_resize_grip (false);
    
    _entry = new StreamEntry ();

    add (_entry);
    set_position (Gtk.WindowPosition.CENTER);

    text_view = _entry.text_view;
    _entry.set_size_request (400, 100);
    _entry.showing = true;
    _entry.text_view.grab_focus ();

    show_all ();

    _entry.notify["showing"].connect (()=> {
      if (_entry.showing == false)
        Idle.add (() => {
          destroy ();
          return false;
        });
      });
  }
}

public static void main (string[] args)
{
  Gtk.init (ref args);

  string message = null;

  if (args.length > 1)
  {
    switch (args[1]) {
      case "--message":
        if (args.length < 3)
        {
          stdout.printf("Usage: gwibber-poster --message <message>\n\n");
          return;
        }
        message = args[2];
        debug ("Message is %s", message);
        break;
    }
  }

  var w = new Poster ();
  if (message != null)
  {
    w.text_view.get_buffer ().set_text(message);
  }
  w.destroy.connect(() => {
    Gtk.main_quit();
  });

  w.focus_out_event.connect(() => {
    w.destroy();
    return false;
  });

  Gtk.main ();
}
