/* tab-bar-item.c generated by valac 0.12.1, the Vala compiler
 * generated from tab-bar-item.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gwibber-gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dee.h>
#include <cairo.h>


#define TYPE_TAB_BAR_ITEM (tab_bar_item_get_type ())
#define TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR_ITEM, TabBarItem))
#define TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR_ITEM, TabBarItemClass))
#define IS_TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR_ITEM))
#define IS_TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR_ITEM))
#define TAB_BAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR_ITEM, TabBarItemClass))

typedef struct _TabBarItem TabBarItem;
typedef struct _TabBarItemClass TabBarItemClass;
typedef struct _TabBarItemPrivate TabBarItemPrivate;

#define TYPE_STREAM_ENTRY (stream_entry_get_type ())
#define STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STREAM_ENTRY, StreamEntry))
#define STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STREAM_ENTRY, StreamEntryClass))
#define IS_STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STREAM_ENTRY))
#define IS_STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STREAM_ENTRY))
#define STREAM_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STREAM_ENTRY, StreamEntryClass))

typedef struct _StreamEntry StreamEntry;
typedef struct _StreamEntryClass StreamEntryClass;

#define TYPE_TAB_BAR_STREAM_ITEM (tab_bar_stream_item_get_type ())
#define TAB_BAR_STREAM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR_STREAM_ITEM, TabBarStreamItem))
#define TAB_BAR_STREAM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR_STREAM_ITEM, TabBarStreamItemClass))
#define IS_TAB_BAR_STREAM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR_STREAM_ITEM))
#define IS_TAB_BAR_STREAM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR_STREAM_ITEM))
#define TAB_BAR_STREAM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR_STREAM_ITEM, TabBarStreamItemClass))

typedef struct _TabBarStreamItem TabBarStreamItem;
typedef struct _TabBarStreamItemClass TabBarStreamItemClass;
typedef struct _TabBarStreamItemPrivate TabBarStreamItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _StreamEntryPrivate StreamEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TabBarItem {
	GtkButton parent_instance;
	TabBarItemPrivate * priv;
	StreamEntry* entry;
};

struct _TabBarItemClass {
	GtkButtonClass parent_class;
	GtkWidget* (*get_toolbar) (TabBarItem* self);
	GtkWidget* (*get_view) (TabBarItem* self);
};

struct _TabBarStreamItem {
	TabBarItem parent_instance;
	TabBarStreamItemPrivate * priv;
	GwibberGtkStreamView* view;
};

struct _TabBarStreamItemClass {
	TabBarItemClass parent_class;
};

struct _StreamEntry {
	GtkAlignment parent_instance;
	StreamEntryPrivate * priv;
	GwibberGtkInputTextView* text_view;
	GtkImage* private;
	GwibberGtkAccountTargetBar* target_bar;
};

struct _StreamEntryClass {
	GtkAlignmentClass parent_class;
};

struct _TabBarItemPrivate {
	gchar* _stream;
	gchar* _tooltip;
	gchar* _icon_name;
	GeeHashMap* _streams;
	GtkImage* _image;
	gboolean _active;
};


static gpointer tab_bar_stream_item_parent_class = NULL;
static gpointer tab_bar_item_parent_class = NULL;

GType tab_bar_item_get_type (void) G_GNUC_CONST;
GType stream_entry_get_type (void) G_GNUC_CONST;
GType tab_bar_stream_item_get_type (void) G_GNUC_CONST;
enum  {
	TAB_BAR_STREAM_ITEM_DUMMY_PROPERTY
};
TabBarStreamItem* tab_bar_stream_item_construct (GType object_type, const gchar* stream, const gchar* icon_name, const gchar* tooltip, GeeHashMap* streams);
static GObject * tab_bar_stream_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda16_ (TabBarStreamItem* self);
static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GeeHashMap* tab_bar_item_get_streams (TabBarItem* self);
const gchar* tab_bar_item_get_stream (TabBarItem* self);
static void _lambda17_ (const gchar* mid, const gchar* account, const gchar* sender, TabBarStreamItem* self);
void stream_entry_set_showing (StreamEntry* self, gboolean value);
static void __lambda17__gwibber_gtk_stream_view_reply (GwibberGtkStreamView* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self);
static void _lambda18_ (TabBarStreamItem* self);
gboolean tab_bar_item_get_active (TabBarItem* self);
static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tab_bar_stream_item_finalize (GObject* obj);
#define TAB_BAR_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAB_BAR_ITEM, TabBarItemPrivate))
enum  {
	TAB_BAR_ITEM_DUMMY_PROPERTY,
	TAB_BAR_ITEM_STREAM,
	TAB_BAR_ITEM_TOOLTIP,
	TAB_BAR_ITEM_ICON_NAME,
	TAB_BAR_ITEM_STREAMS,
	TAB_BAR_ITEM_ACTIVE
};
TabBarItem* tab_bar_item_construct (GType object_type, const gchar* stream, const gchar* icon_name, const gchar* tooltip, GeeHashMap* streams);
static gboolean tab_bar_item_real_draw (GtkWidget* base, cairo_t* cr);
StreamEntry* tab_bar_item_get_entry (TabBarItem* self);
GtkWidget* tab_bar_item_get_toolbar (TabBarItem* self);
static GtkWidget* tab_bar_item_real_get_toolbar (TabBarItem* self);
GtkWidget* tab_bar_item_get_view (TabBarItem* self);
static GtkWidget* tab_bar_item_real_get_view (TabBarItem* self);
void tab_bar_item_set_stream (TabBarItem* self, const gchar* value);
const gchar* tab_bar_item_get_tooltip (TabBarItem* self);
void tab_bar_item_set_tooltip (TabBarItem* self, const gchar* value);
const gchar* tab_bar_item_get_icon_name (TabBarItem* self);
void tab_bar_item_set_icon_name (TabBarItem* self, const gchar* value);
void tab_bar_item_set_streams (TabBarItem* self, GeeHashMap* value);
void tab_bar_item_set_active (TabBarItem* self, gboolean value);
static gboolean _lambda10_ (TabBarItem* self);
static gboolean __lambda10__gsource_func (gpointer self);
static GObject * tab_bar_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tab_bar_item_finalize (GObject* obj);
static void _vala_tab_bar_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tab_bar_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


TabBarStreamItem* tab_bar_stream_item_construct (GType object_type, const gchar* stream, const gchar* icon_name, const gchar* tooltip, GeeHashMap* streams) {
	TabBarStreamItem * self = NULL;
	g_return_val_if_fail (stream != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (tooltip != NULL, NULL);
	g_return_val_if_fail (streams != NULL, NULL);
	self = (TabBarStreamItem*) g_object_new (object_type, "stream", stream, "tooltip", tooltip, "icon-name", icon_name, "streams", streams, NULL);
	return self;
}


static void _lambda16_ (TabBarStreamItem* self) {
	gtk_widget_set_no_show_all ((GtkWidget*) self->view, FALSE);
	gtk_widget_show_all ((GtkWidget*) self->view);
}


static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda16_ (self);
}


static void _lambda17_ (const gchar* mid, const gchar* account, const gchar* sender, TabBarStreamItem* self) {
	const gchar* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (mid != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
	gwibber_gtk_input_text_view_set_mid (((TabBarItem*) self)->entry->text_view, mid);
	_tmp0_ = tab_bar_item_get_stream ((TabBarItem*) self);
	if (g_strcmp0 (_tmp0_, "private") == 0) {
		gwibber_gtk_input_text_view_set_action (((TabBarItem*) self)->entry->text_view, "private");
		gtk_widget_show ((GtkWidget*) ((TabBarItem*) self)->entry->private);
	} else {
		gwibber_gtk_input_text_view_set_action (((TabBarItem*) self)->entry->text_view, "reply");
	}
	gwibber_gtk_account_target_bar_set_selected (((TabBarItem*) self)->entry->target_bar, account);
	stream_entry_set_showing (((TabBarItem*) self)->entry, TRUE);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) ((TabBarItem*) self)->entry->text_view);
	_tmp2_ = g_strconcat (sender, " ", NULL);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp1_, "text", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	gtk_widget_grab_focus ((GtkWidget*) ((TabBarItem*) self)->entry->text_view);
}


static void __lambda17__gwibber_gtk_stream_view_reply (GwibberGtkStreamView* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self) {
	_lambda17_ (mid, account, sender, self);
}


static void _lambda18_ (TabBarStreamItem* self) {
	gboolean _tmp0_;
	_tmp0_ = tab_bar_item_get_active ((TabBarItem*) self);
	gwibber_gtk_stream_view_set_showing (self->view, _tmp0_);
}


static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda18_ (self);
}


static GObject * tab_bar_stream_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TabBarStreamItem * self;
	GwibberGtkStreamView* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	DeeModel* _tmp4_;
	const gchar* _tmp5_ = NULL;
	parent_class = G_OBJECT_CLASS (tab_bar_stream_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TAB_BAR_STREAM_ITEM (obj);
	_tmp0_ = gwibber_gtk_stream_view_new ();
	_g_object_unref0 (self->view);
	self->view = g_object_ref_sink (_tmp0_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->view, TRUE);
	g_signal_connect_object ((GObject*) self->view, "notify::prepared", (GCallback) __lambda16__g_object_notify, self, 0);
	_tmp1_ = tab_bar_item_get_streams ((TabBarItem*) self);
	_tmp2_ = tab_bar_item_get_stream ((TabBarItem*) self);
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	_tmp4_ = (DeeModel*) _tmp3_;
	gwibber_gtk_stream_view_set_model (self->view, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = tab_bar_item_get_stream ((TabBarItem*) self);
	gwibber_gtk_stream_view_set_stream (self->view, _tmp5_);
	g_signal_connect_object (self->view, "reply", (GCallback) __lambda17__gwibber_gtk_stream_view_reply, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::active", (GCallback) __lambda18__g_object_notify, self, 0);
	return obj;
}


static void tab_bar_stream_item_class_init (TabBarStreamItemClass * klass) {
	tab_bar_stream_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = tab_bar_stream_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = tab_bar_stream_item_finalize;
}


static void tab_bar_stream_item_instance_init (TabBarStreamItem * self) {
	self->view = NULL;
}


static void tab_bar_stream_item_finalize (GObject* obj) {
	TabBarStreamItem * self;
	self = TAB_BAR_STREAM_ITEM (obj);
	_g_object_unref0 (self->view);
	G_OBJECT_CLASS (tab_bar_stream_item_parent_class)->finalize (obj);
}


GType tab_bar_stream_item_get_type (void) {
	static volatile gsize tab_bar_stream_item_type_id__volatile = 0;
	if (g_once_init_enter (&tab_bar_stream_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TabBarStreamItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_bar_stream_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TabBarStreamItem), 0, (GInstanceInitFunc) tab_bar_stream_item_instance_init, NULL };
		GType tab_bar_stream_item_type_id;
		tab_bar_stream_item_type_id = g_type_register_static (TYPE_TAB_BAR_ITEM, "TabBarStreamItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tab_bar_stream_item_type_id__volatile, tab_bar_stream_item_type_id);
	}
	return tab_bar_stream_item_type_id__volatile;
}


TabBarItem* tab_bar_item_construct (GType object_type, const gchar* stream, const gchar* icon_name, const gchar* tooltip, GeeHashMap* streams) {
	TabBarItem * self = NULL;
	g_return_val_if_fail (stream != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (tooltip != NULL, NULL);
	g_return_val_if_fail (streams != NULL, NULL);
	self = (TabBarItem*) g_object_new (object_type, "stream", stream, "tooltip", tooltip, "icon-name", icon_name, "streams", streams, NULL);
	return self;
}


static gboolean tab_bar_item_real_draw (GtkWidget* base, cairo_t* cr) {
	TabBarItem * self;
	gboolean result = FALSE;
	self = (TabBarItem*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_container_propagate_draw ((GtkContainer*) self, (GtkWidget*) self->priv->_image, cr);
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


StreamEntry* tab_bar_item_get_entry (TabBarItem* self) {
	StreamEntry* result = NULL;
	StreamEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->entry);
	result = _tmp0_;
	return result;
}


static GtkWidget* tab_bar_item_real_get_toolbar (TabBarItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `tab_bar_item_get_toolbar'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* tab_bar_item_get_toolbar (TabBarItem* self) {
	return TAB_BAR_ITEM_GET_CLASS (self)->get_toolbar (self);
}


static GtkWidget* tab_bar_item_real_get_view (TabBarItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `tab_bar_item_get_view'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* tab_bar_item_get_view (TabBarItem* self) {
	return TAB_BAR_ITEM_GET_CLASS (self)->get_view (self);
}


const gchar* tab_bar_item_get_stream (TabBarItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_stream;
	return result;
}


void tab_bar_item_set_stream (TabBarItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_stream);
	self->priv->_stream = _tmp0_;
	g_object_notify ((GObject *) self, "stream");
}


const gchar* tab_bar_item_get_tooltip (TabBarItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_tooltip;
	return result;
}


void tab_bar_item_set_tooltip (TabBarItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_tooltip);
	self->priv->_tooltip = _tmp0_;
	g_object_notify ((GObject *) self, "tooltip");
}


const gchar* tab_bar_item_get_icon_name (TabBarItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_name;
	return result;
}


void tab_bar_item_set_icon_name (TabBarItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp0_;
	g_object_notify ((GObject *) self, "icon-name");
}


GeeHashMap* tab_bar_item_get_streams (TabBarItem* self) {
	GeeHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_streams;
	return result;
}


void tab_bar_item_set_streams (TabBarItem* self, GeeHashMap* value) {
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_streams);
	self->priv->_streams = _tmp0_;
	g_object_notify ((GObject *) self, "streams");
}


gboolean tab_bar_item_get_active (TabBarItem* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


static gboolean _lambda10_ (TabBarItem* self) {
	gboolean result = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean __lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda10_ (self);
	return result;
}


void tab_bar_item_set_active (TabBarItem* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda10__gsource_func, g_object_ref (self), g_object_unref);
	g_object_notify ((GObject *) self, "active");
}


static GObject * tab_bar_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TabBarItem * self;
	StreamEntry* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (tab_bar_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TAB_BAR_ITEM (obj);
	_tmp0_ = tab_bar_item_get_entry (self);
	_g_object_unref0 (self->entry);
	self->entry = _tmp0_;
	gtk_widget_set_size_request ((GtkWidget*) self, 40, 32);
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (self->priv->_icon_name, GTK_ICON_SIZE_BUTTON);
	_g_object_unref0 (self->priv->_image);
	self->priv->_image = g_object_ref_sink (_tmp1_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_image, self->priv->_tooltip);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->_image);
	return obj;
}


static void tab_bar_item_class_init (TabBarItemClass * klass) {
	tab_bar_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TabBarItemPrivate));
	GTK_WIDGET_CLASS (klass)->draw = tab_bar_item_real_draw;
	TAB_BAR_ITEM_CLASS (klass)->get_toolbar = tab_bar_item_real_get_toolbar;
	TAB_BAR_ITEM_CLASS (klass)->get_view = tab_bar_item_real_get_view;
	G_OBJECT_CLASS (klass)->get_property = _vala_tab_bar_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tab_bar_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = tab_bar_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = tab_bar_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_BAR_ITEM_STREAM, g_param_spec_string ("stream", "stream", "stream", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_BAR_ITEM_TOOLTIP, g_param_spec_string ("tooltip", "tooltip", "tooltip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_BAR_ITEM_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_BAR_ITEM_STREAMS, g_param_spec_object ("streams", "streams", "streams", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_BAR_ITEM_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tab_bar_item_instance_init (TabBarItem * self) {
	self->priv = TAB_BAR_ITEM_GET_PRIVATE (self);
	self->entry = NULL;
	self->priv->_active = FALSE;
}


static void tab_bar_item_finalize (GObject* obj) {
	TabBarItem * self;
	self = TAB_BAR_ITEM (obj);
	_g_free0 (self->priv->_stream);
	_g_free0 (self->priv->_tooltip);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->_streams);
	_g_object_unref0 (self->entry);
	_g_object_unref0 (self->priv->_image);
	G_OBJECT_CLASS (tab_bar_item_parent_class)->finalize (obj);
}


GType tab_bar_item_get_type (void) {
	static volatile gsize tab_bar_item_type_id__volatile = 0;
	if (g_once_init_enter (&tab_bar_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TabBarItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_bar_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TabBarItem), 0, (GInstanceInitFunc) tab_bar_item_instance_init, NULL };
		GType tab_bar_item_type_id;
		tab_bar_item_type_id = g_type_register_static (GTK_TYPE_BUTTON, "TabBarItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tab_bar_item_type_id__volatile, tab_bar_item_type_id);
	}
	return tab_bar_item_type_id__volatile;
}


static void _vala_tab_bar_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TabBarItem * self;
	self = TAB_BAR_ITEM (object);
	switch (property_id) {
		case TAB_BAR_ITEM_STREAM:
		g_value_set_string (value, tab_bar_item_get_stream (self));
		break;
		case TAB_BAR_ITEM_TOOLTIP:
		g_value_set_string (value, tab_bar_item_get_tooltip (self));
		break;
		case TAB_BAR_ITEM_ICON_NAME:
		g_value_set_string (value, tab_bar_item_get_icon_name (self));
		break;
		case TAB_BAR_ITEM_STREAMS:
		g_value_set_object (value, tab_bar_item_get_streams (self));
		break;
		case TAB_BAR_ITEM_ACTIVE:
		g_value_set_boolean (value, tab_bar_item_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tab_bar_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TabBarItem * self;
	self = TAB_BAR_ITEM (object);
	switch (property_id) {
		case TAB_BAR_ITEM_STREAM:
		tab_bar_item_set_stream (self, g_value_get_string (value));
		break;
		case TAB_BAR_ITEM_TOOLTIP:
		tab_bar_item_set_tooltip (self, g_value_get_string (value));
		break;
		case TAB_BAR_ITEM_ICON_NAME:
		tab_bar_item_set_icon_name (self, g_value_get_string (value));
		break;
		case TAB_BAR_ITEM_STREAMS:
		tab_bar_item_set_streams (self, g_value_get_object (value));
		break;
		case TAB_BAR_ITEM_ACTIVE:
		tab_bar_item_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



