/* tab-bar.c generated by valac 0.16.0, the Vala compiler
 * generated from tab-bar.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include "gwibber-gtk.h"


#define TYPE_TAB_BAR_ITEM (tab_bar_item_get_type ())
#define TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR_ITEM, TabBarItem))
#define TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR_ITEM, TabBarItemClass))
#define IS_TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR_ITEM))
#define IS_TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR_ITEM))
#define TAB_BAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR_ITEM, TabBarItemClass))

typedef struct _TabBarItem TabBarItem;
typedef struct _TabBarItemClass TabBarItemClass;
typedef struct _TabBarItemPrivate TabBarItemPrivate;

#define TYPE_STREAM_ENTRY (stream_entry_get_type ())
#define STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STREAM_ENTRY, StreamEntry))
#define STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STREAM_ENTRY, StreamEntryClass))
#define IS_STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STREAM_ENTRY))
#define IS_STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STREAM_ENTRY))
#define STREAM_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STREAM_ENTRY, StreamEntryClass))

typedef struct _StreamEntry StreamEntry;
typedef struct _StreamEntryClass StreamEntryClass;

#define TYPE_WRITE_ITEM (write_item_get_type ())
#define WRITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WRITE_ITEM, WriteItem))
#define WRITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WRITE_ITEM, WriteItemClass))
#define IS_WRITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WRITE_ITEM))
#define IS_WRITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WRITE_ITEM))
#define WRITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WRITE_ITEM, WriteItemClass))

typedef struct _WriteItem WriteItem;
typedef struct _WriteItemClass WriteItemClass;
typedef struct _WriteItemPrivate WriteItemPrivate;

#define TYPE_TAB_BAR (tab_bar_get_type ())
#define TAB_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR, TabBar))
#define TAB_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR, TabBarClass))
#define IS_TAB_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR))
#define IS_TAB_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR))
#define TAB_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR, TabBarClass))

typedef struct _TabBar TabBar;
typedef struct _TabBarClass TabBarClass;
typedef struct _TabBarPrivate TabBarPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _StreamEntryPrivate StreamEntryPrivate;

struct _TabBarItem {
	GtkButton parent_instance;
	TabBarItemPrivate * priv;
	StreamEntry* entry;
};

struct _TabBarItemClass {
	GtkButtonClass parent_class;
	GtkWidget* (*get_toolbar) (TabBarItem* self);
	GtkWidget* (*get_view) (TabBarItem* self);
};

struct _WriteItem {
	TabBarItem parent_instance;
	WriteItemPrivate * priv;
};

struct _WriteItemClass {
	TabBarItemClass parent_class;
};

struct _TabBar {
	GtkBox parent_instance;
	TabBarPrivate * priv;
};

struct _TabBarClass {
	GtkBoxClass parent_class;
};

struct _TabBarPrivate {
	GtkAlignment* _align;
	GtkBox* _vbox;
	GtkBox* _tab_box;
	GtkBox* _toolbar_box;
	GtkLayout* _layout;
	gint _last_width;
	gint _last_height;
	GtkBox* _view_box;
	GtkSizeGroup* _view_group;
	WriteItem* _write_item;
	StreamEntry* _entry;
	TabBarItem* _active_item;
	gint _active_item_n;
	guint _anim_id;
	gfloat _anim_offset;
	gint64 _anim_start;
};

struct _StreamEntry {
	GtkAlignment parent_instance;
	StreamEntryPrivate * priv;
	GwibberGtkInputTextView* text_view;
	GtkImage* private;
	gboolean in_client;
	GwibberGtkAccountTargetBar* target_bar;
};

struct _StreamEntryClass {
	GtkAlignmentClass parent_class;
};


static gpointer write_item_parent_class = NULL;
static gpointer tab_bar_parent_class = NULL;

GType tab_bar_item_get_type (void) G_GNUC_CONST;
GType stream_entry_get_type (void) G_GNUC_CONST;
GType write_item_get_type (void) G_GNUC_CONST;
enum  {
	WRITE_ITEM_DUMMY_PROPERTY
};
WriteItem* write_item_new (void);
WriteItem* write_item_construct (GType object_type);
static GtkWidget* write_item_real_get_toolbar (TabBarItem* base);
static GtkWidget* write_item_real_get_view (TabBarItem* base);
static GObject * write_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GType tab_bar_get_type (void) G_GNUC_CONST;
#define TAB_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAB_BAR, TabBarPrivate))
enum  {
	TAB_BAR_DUMMY_PROPERTY
};
TabBar* tab_bar_new (void);
TabBar* tab_bar_construct (GType object_type);
gboolean tab_bar_on_align_draw (TabBar* self, cairo_t* cr);
GtkWidget* tab_bar_item_get_toolbar (TabBarItem* self);
static void tab_bar_draw_arrowed_line (TabBar* self, cairo_t* cr, gint x, gint y, gint width, gint point);
void tab_bar_add_item (TabBar* self, TabBarItem* item);
void tab_bar_on_tab_clicked (TabBar* self, GtkButton* gtk_item);
static void _tab_bar_on_tab_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkWidget* tab_bar_item_get_view (TabBarItem* self);
void stream_entry_set_showing (StreamEntry* self, gboolean value);
void tab_bar_item_set_active (TabBarItem* self, gboolean value);
static gboolean ___lambda13_ (TabBar* self);
static gboolean ____lambda13__gsource_func (gpointer self);
void tab_bar_show_entry (TabBar* self);
void tab_bar_on_write_clicked (TabBar* self);
gboolean stream_entry_get_showing (StreamEntry* self);
static GObject * tab_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _tab_bar_on_align_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static void _tab_bar_on_write_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
StreamEntry* stream_entry_new (void);
StreamEntry* stream_entry_construct (GType object_type);
static void _tab_bar___lambda14_ (TabBar* self);
static void __tab_bar___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tab_bar___lambda15_ (TabBar* self, GtkAllocation* a);
static void __tab_bar___lambda15__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static void tab_bar_finalize (GObject* obj);


WriteItem* write_item_construct (GType object_type) {
	WriteItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = _ ("New Message");
	self = (WriteItem*) g_object_new (object_type, "stream", "", "icon-name", "gwibber-new-post", "tooltip", _tmp0_, NULL);
	return self;
}


WriteItem* write_item_new (void) {
	return write_item_construct (TYPE_WRITE_ITEM);
}


static GtkWidget* write_item_real_get_toolbar (TabBarItem* base) {
	WriteItem * self;
	GtkWidget* result = NULL;
	self = (WriteItem*) base;
	result = NULL;
	return result;
}


static GtkWidget* write_item_real_get_view (TabBarItem* base) {
	WriteItem * self;
	GtkWidget* result = NULL;
	self = (WriteItem*) base;
	result = NULL;
	return result;
}


static GObject * write_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	WriteItem * self;
	parent_class = G_OBJECT_CLASS (write_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = WRITE_ITEM (obj);
	return obj;
}


static void write_item_class_init (WriteItemClass * klass) {
	write_item_parent_class = g_type_class_peek_parent (klass);
	TAB_BAR_ITEM_CLASS (klass)->get_toolbar = write_item_real_get_toolbar;
	TAB_BAR_ITEM_CLASS (klass)->get_view = write_item_real_get_view;
	G_OBJECT_CLASS (klass)->constructor = write_item_constructor;
}


static void write_item_instance_init (WriteItem * self) {
}


GType write_item_get_type (void) {
	static volatile gsize write_item_type_id__volatile = 0;
	if (g_once_init_enter (&write_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WriteItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) write_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WriteItem), 0, (GInstanceInitFunc) write_item_instance_init, NULL };
		GType write_item_type_id;
		write_item_type_id = g_type_register_static (TYPE_TAB_BAR_ITEM, "WriteItem", &g_define_type_info, 0);
		g_once_init_leave (&write_item_type_id__volatile, write_item_type_id);
	}
	return write_item_type_id__volatile;
}


TabBar* tab_bar_construct (GType object_type) {
	TabBar * self = NULL;
	self = (TabBar*) g_object_new (object_type, "homogeneous", FALSE, "spacing", 0, NULL);
	return self;
}


TabBar* tab_bar_new (void) {
	return tab_bar_construct (TYPE_TAB_BAR);
}


gboolean tab_bar_on_align_draw (TabBar* self, cairo_t* cr) {
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	GtkAlignment* _tmp1_;
	GtkStyleContext* _tmp2_ = NULL;
	cairo_t* _tmp3_;
	GtkAlignment* _tmp4_;
	gint _tmp5_ = 0;
	GtkAlignment* _tmp6_;
	gint _tmp7_ = 0;
	GtkAlignment* _tmp8_;
	GtkStyleContext* _tmp9_ = NULL;
	cairo_t* _tmp10_;
	GtkAlignment* _tmp11_;
	gint _tmp12_ = 0;
	GtkAlignment* _tmp13_;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	TabBarItem* _tmp16_;
	gboolean _tmp19_;
	GtkAlignment* _tmp76_;
	GtkBox* _tmp77_;
	cairo_t* _tmp78_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = cr;
	cairo_set_operator (_tmp0_, CAIRO_OPERATOR_OVER);
	_tmp1_ = self->priv->_align;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = cr;
	_tmp4_ = self->priv->_align;
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp4_);
	_tmp6_ = self->priv->_align;
	_tmp7_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp6_);
	gtk_render_background (_tmp2_, _tmp3_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp5_, (gdouble) _tmp7_);
	_tmp8_ = self->priv->_align;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	_tmp10_ = cr;
	_tmp11_ = self->priv->_align;
	_tmp12_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp11_);
	_tmp13_ = self->priv->_align;
	_tmp14_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp13_);
	gtk_render_frame (_tmp9_, _tmp10_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp12_, (gdouble) _tmp14_);
	_tmp16_ = self->priv->_active_item;
	if (GTK_IS_WIDGET (_tmp16_)) {
		StreamEntry* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = self->priv->_entry;
		_tmp18_ = gtk_widget_get_visible ((GtkWidget*) _tmp17_);
		_tmp15_ = !_tmp18_;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp19_ = _tmp15_;
	if (_tmp19_) {
		GtkAllocation a = {0};
		TabBarItem* _tmp20_;
		GtkAllocation _tmp21_ = {0};
		cairo_t* _tmp22_;
		cairo_t* _tmp23_;
		cairo_t* _tmp24_;
		GtkAllocation _tmp25_;
		gint _tmp26_;
		GtkAllocation _tmp27_;
		gint _tmp28_;
		GtkAlignment* _tmp29_;
		gint _tmp30_ = 0;
		cairo_t* _tmp31_;
		GtkAllocation _tmp32_;
		gint _tmp33_;
		GtkAllocation _tmp34_;
		gint _tmp35_;
		GtkAlignment* _tmp36_;
		gint _tmp37_ = 0;
		cairo_t* _tmp38_;
		GtkAllocation _tmp39_;
		gint _tmp40_;
		GtkAllocation _tmp41_;
		gint _tmp42_;
		GtkAlignment* _tmp43_;
		gint _tmp44_ = 0;
		cairo_t* _tmp45_;
		cairo_t* _tmp46_;
		TabBarItem* _tmp47_;
		GtkWidget* _tmp48_ = NULL;
		GtkWidget* _tmp49_;
		gboolean _tmp50_;
		_tmp20_ = self->priv->_active_item;
		gtk_widget_get_allocation ((GtkWidget*) _tmp20_, &_tmp21_);
		a = _tmp21_;
		_tmp22_ = cr;
		cairo_set_line_width (_tmp22_, 1.0);
		_tmp23_ = cr;
		cairo_set_source_rgb (_tmp23_, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f);
		_tmp24_ = cr;
		_tmp25_ = a;
		_tmp26_ = _tmp25_.x;
		_tmp27_ = a;
		_tmp28_ = _tmp27_.width;
		_tmp29_ = self->priv->_align;
		_tmp30_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp29_);
		cairo_move_to (_tmp24_, _tmp26_ + (_tmp28_ / 2.0), (gdouble) (_tmp30_ - 5));
		_tmp31_ = cr;
		_tmp32_ = a;
		_tmp33_ = _tmp32_.x;
		_tmp34_ = a;
		_tmp35_ = _tmp34_.width;
		_tmp36_ = self->priv->_align;
		_tmp37_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp36_);
		cairo_line_to (_tmp31_, (_tmp33_ + (_tmp35_ / 2.0)) + 5, (gdouble) _tmp37_);
		_tmp38_ = cr;
		_tmp39_ = a;
		_tmp40_ = _tmp39_.x;
		_tmp41_ = a;
		_tmp42_ = _tmp41_.width;
		_tmp43_ = self->priv->_align;
		_tmp44_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp43_);
		cairo_line_to (_tmp38_, (_tmp40_ + (_tmp42_ / 2.0)) - 5, (gdouble) _tmp44_);
		_tmp45_ = cr;
		cairo_close_path (_tmp45_);
		_tmp46_ = cr;
		cairo_fill (_tmp46_);
		_tmp47_ = self->priv->_active_item;
		_tmp48_ = tab_bar_item_get_toolbar (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = GTK_IS_WIDGET (_tmp49_);
		_g_object_unref0 (_tmp49_);
		if (_tmp50_) {
			cairo_t* _tmp51_;
			cairo_t* _tmp52_;
			cairo_t* _tmp53_;
			GtkAllocation _tmp54_;
			gint _tmp55_;
			GtkAlignment* _tmp56_;
			gint _tmp57_ = 0;
			GtkAllocation _tmp58_;
			gint _tmp59_;
			GtkAllocation _tmp60_;
			gint _tmp61_;
			cairo_t* _tmp62_;
			cairo_t* _tmp63_;
			cairo_t* _tmp64_;
			GtkAllocation _tmp65_;
			gint _tmp66_;
			GtkAlignment* _tmp67_;
			gint _tmp68_ = 0;
			GtkAllocation _tmp69_;
			gint _tmp70_;
			GtkAllocation _tmp71_;
			gint _tmp72_;
			cairo_t* _tmp73_;
			cairo_t* _tmp74_;
			cairo_t* _tmp75_;
			_tmp51_ = cr;
			cairo_save (_tmp51_);
			_tmp52_ = cr;
			cairo_translate (_tmp52_, 0.5, 0.5);
			_tmp53_ = cr;
			_tmp54_ = a;
			_tmp55_ = _tmp54_.height;
			_tmp56_ = self->priv->_align;
			_tmp57_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp56_);
			_tmp58_ = a;
			_tmp59_ = _tmp58_.x;
			_tmp60_ = a;
			_tmp61_ = _tmp60_.width;
			tab_bar_draw_arrowed_line (self, _tmp53_, 0, _tmp55_ + 3, _tmp57_, (gint) (_tmp59_ + (_tmp61_ / 2.0)));
			_tmp62_ = cr;
			cairo_set_source_rgba (_tmp62_, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.2f);
			_tmp63_ = cr;
			cairo_stroke (_tmp63_);
			_tmp64_ = cr;
			_tmp65_ = a;
			_tmp66_ = _tmp65_.height;
			_tmp67_ = self->priv->_align;
			_tmp68_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp67_);
			_tmp69_ = a;
			_tmp70_ = _tmp69_.x;
			_tmp71_ = a;
			_tmp72_ = _tmp71_.width;
			tab_bar_draw_arrowed_line (self, _tmp64_, 0, _tmp66_ + 2, _tmp68_, (gint) (_tmp70_ + (_tmp72_ / 2.0)));
			_tmp73_ = cr;
			cairo_set_source_rgba (_tmp73_, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.5f);
			_tmp74_ = cr;
			cairo_stroke (_tmp74_);
			_tmp75_ = cr;
			cairo_restore (_tmp75_);
		}
	}
	_tmp76_ = self->priv->_align;
	_tmp77_ = self->priv->_vbox;
	_tmp78_ = cr;
	gtk_container_propagate_draw ((GtkContainer*) _tmp76_, (GtkWidget*) _tmp77_, _tmp78_);
	result = TRUE;
	return result;
}


static void tab_bar_draw_arrowed_line (TabBar* self, cairo_t* cr, gint x, gint y, gint width, gint point) {
	gint size;
	cairo_t* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	cairo_t* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	cairo_t* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	cairo_t* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	cairo_t* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	size = 5;
	_tmp0_ = cr;
	_tmp1_ = x;
	_tmp2_ = y;
	cairo_move_to (_tmp0_, (gdouble) _tmp1_, (gdouble) _tmp2_);
	_tmp3_ = cr;
	_tmp4_ = point;
	_tmp5_ = y;
	cairo_line_to (_tmp3_, (gdouble) (_tmp4_ - size), (gdouble) _tmp5_);
	_tmp6_ = cr;
	_tmp7_ = point;
	_tmp8_ = y;
	cairo_line_to (_tmp6_, (gdouble) _tmp7_, (gdouble) (_tmp8_ - size));
	_tmp9_ = cr;
	_tmp10_ = point;
	_tmp11_ = y;
	cairo_line_to (_tmp9_, (gdouble) (_tmp10_ + size), (gdouble) _tmp11_);
	_tmp12_ = cr;
	_tmp13_ = x;
	_tmp14_ = width;
	_tmp15_ = y;
	cairo_line_to (_tmp12_, (gdouble) (_tmp13_ + _tmp14_), (gdouble) _tmp15_);
}


static void _tab_bar_on_tab_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tab_bar_on_tab_clicked (self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tab_bar_add_item (TabBar* self, TabBarItem* item) {
	TabBarItem* _tmp0_;
	GtkBox* _tmp1_;
	TabBarItem* _tmp2_;
	TabBarItem* _tmp3_;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	gboolean _tmp6_;
	TabBarItem* _tmp13_;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	g_signal_connect_object ((GtkButton*) _tmp0_, "clicked", (GCallback) _tab_bar_on_tab_clicked_gtk_button_clicked, self, 0);
	_tmp1_ = self->priv->_tab_box;
	_tmp2_ = item;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = item;
	_tmp4_ = tab_bar_item_get_toolbar (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = GTK_IS_WIDGET (_tmp5_);
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		TabBarItem* _tmp7_;
		GtkWidget* _tmp8_ = NULL;
		GtkWidget* toolbar;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		GtkBox* _tmp11_;
		GtkWidget* _tmp12_;
		_tmp7_ = item;
		_tmp8_ = tab_bar_item_get_toolbar (_tmp7_);
		toolbar = _tmp8_;
		_tmp9_ = toolbar;
		gtk_widget_set_no_show_all (_tmp9_, TRUE);
		_tmp10_ = toolbar;
		gtk_widget_hide (_tmp10_);
		_tmp11_ = self->priv->_toolbar_box;
		_tmp12_ = toolbar;
		gtk_container_add ((GtkContainer*) _tmp11_, _tmp12_);
		_g_object_unref0 (toolbar);
	}
	_tmp13_ = item;
	_tmp14_ = tab_bar_item_get_view (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = GTK_IS_WIDGET (_tmp15_);
	_g_object_unref0 (_tmp15_);
	if (_tmp16_) {
		TabBarItem* _tmp17_;
		GtkWidget* _tmp18_ = NULL;
		GtkWidget* view;
		TabBarItem* _tmp19_;
		StreamEntry* _tmp20_;
		StreamEntry* _tmp21_;
		GtkWidget* _tmp22_;
		GtkBox* _tmp23_;
		GtkWidget* _tmp24_;
		GtkSizeGroup* _tmp25_;
		GtkWidget* _tmp26_;
		GtkBox* _tmp27_;
		GList* _tmp28_ = NULL;
		GList* children;
		GtkBox* _tmp29_;
		gint _tmp30_;
		GList* _tmp31_;
		guint _tmp32_ = 0U;
		gint _tmp33_;
		_tmp17_ = item;
		_tmp18_ = tab_bar_item_get_view (_tmp17_);
		view = _tmp18_;
		_tmp19_ = item;
		_tmp20_ = self->priv->_entry;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (_tmp19_->entry);
		_tmp19_->entry = _tmp21_;
		_tmp22_ = view;
		gtk_widget_show (_tmp22_);
		_tmp23_ = self->priv->_view_box;
		_tmp24_ = view;
		gtk_container_add ((GtkContainer*) _tmp23_, _tmp24_);
		_tmp25_ = self->priv->_view_group;
		_tmp26_ = view;
		gtk_size_group_add_widget (_tmp25_, _tmp26_);
		_tmp27_ = self->priv->_view_box;
		_tmp28_ = gtk_container_get_children ((GtkContainer*) _tmp27_);
		children = _tmp28_;
		_tmp29_ = self->priv->_view_box;
		_tmp30_ = self->priv->_last_width;
		_tmp31_ = children;
		_tmp32_ = g_list_length (_tmp31_);
		_tmp33_ = self->priv->_last_height;
		gtk_widget_set_size_request ((GtkWidget*) _tmp29_, _tmp30_ * ((gint) _tmp32_), _tmp33_);
		_g_list_free0 (children);
		_g_object_unref0 (view);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean ___lambda13_ (TabBar* self) {
	gboolean result = FALSE;
	gfloat LENGTH;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
	gint64 diff;
	gint64 _tmp2_;
	gfloat _tmp3_;
	gfloat progress;
	GtkAllocation a = {0};
	GtkBox* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_;
	GtkLayout* _tmp7_;
	gint _tmp8_ = 0;
	gfloat target_x;
	GtkAllocation _tmp9_;
	gint _tmp10_;
	gfloat current_x;
	gfloat new_x;
	gfloat _tmp11_;
	gfloat _tmp12_;
	GtkLayout* _tmp23_;
	GtkBox* _tmp24_;
	gfloat _tmp25_;
	gint64 _tmp26_;
	gfloat _tmp27_;
	LENGTH = 200000.0f;
	_tmp0_ = g_get_monotonic_time ();
	_tmp1_ = self->priv->_anim_start;
	diff = _tmp0_ - _tmp1_;
	_tmp2_ = diff;
	_tmp3_ = LENGTH;
	progress = _tmp2_ / _tmp3_;
	_tmp4_ = self->priv->_view_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp4_, &_tmp5_);
	a = _tmp5_;
	_tmp6_ = self->priv->_active_item_n;
	_tmp7_ = self->priv->_layout;
	_tmp8_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp7_);
	target_x = (gfloat) ((_tmp6_ * _tmp8_) * (-1));
	_tmp9_ = a;
	_tmp10_ = _tmp9_.x;
	current_x = (gfloat) _tmp10_;
	new_x = (gfloat) 0;
	_tmp11_ = target_x;
	_tmp12_ = current_x;
	if (_tmp11_ > _tmp12_) {
		gfloat _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		gfloat _tmp16_;
		_tmp13_ = current_x;
		_tmp14_ = target_x;
		_tmp15_ = current_x;
		_tmp16_ = progress;
		new_x = _tmp13_ + ((_tmp14_ - _tmp15_) * _tmp16_);
	} else {
		gfloat _tmp17_;
		gfloat _tmp18_;
		_tmp17_ = target_x;
		_tmp18_ = current_x;
		if (_tmp17_ < _tmp18_) {
			gfloat _tmp19_;
			gfloat _tmp20_;
			gfloat _tmp21_;
			gfloat _tmp22_;
			_tmp19_ = current_x;
			_tmp20_ = current_x;
			_tmp21_ = target_x;
			_tmp22_ = progress;
			new_x = _tmp19_ - ((_tmp20_ - _tmp21_) * _tmp22_);
		}
	}
	_tmp23_ = self->priv->_layout;
	_tmp24_ = self->priv->_view_box;
	_tmp25_ = new_x;
	gtk_layout_move (_tmp23_, (GtkWidget*) _tmp24_, (gint) _tmp25_, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp26_ = diff;
	_tmp27_ = LENGTH;
	if (((gfloat) _tmp26_) > _tmp27_) {
		GtkLayout* _tmp28_;
		GtkBox* _tmp29_;
		GtkLayout* _tmp30_;
		gint _tmp31_ = 0;
		gint _tmp32_;
		self->priv->_anim_id = (guint) 0;
		self->priv->_anim_offset = 1.0f;
		_tmp28_ = self->priv->_layout;
		_tmp29_ = self->priv->_view_box;
		_tmp30_ = self->priv->_layout;
		_tmp31_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp30_);
		_tmp32_ = self->priv->_active_item_n;
		gtk_layout_move (_tmp28_, (GtkWidget*) _tmp29_, (_tmp31_ * _tmp32_) * (-1), 0);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean ____lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda13_ (self);
	return result;
}


void tab_bar_on_tab_clicked (TabBar* self, GtkButton* gtk_item) {
	StreamEntry* _tmp0_;
	StreamEntry* _tmp1_;
	GwibberGtkInputTextView* _tmp2_;
	GtkButton* _tmp3_;
	TabBarItem* _tmp4_;
	TabBarItem* item;
	gboolean _tmp5_ = FALSE;
	TabBarItem* _tmp6_;
	TabBarItem* _tmp7_;
	gboolean _tmp9_;
	TabBarItem* _tmp10_;
	TabBarItem* _tmp19_;
	TabBarItem* _tmp20_;
	TabBarItem* _tmp21_;
	TabBarItem* _tmp22_;
	GtkWidget* _tmp23_ = NULL;
	GtkWidget* _tmp24_;
	gboolean _tmp25_;
	TabBarItem* _tmp31_;
	GtkWidget* _tmp32_ = NULL;
	GtkWidget* _tmp33_;
	gboolean _tmp34_;
	StreamEntry* _tmp55_;
	TabBarItem* _tmp56_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry;
	stream_entry_set_showing (_tmp0_, FALSE);
	_tmp1_ = self->priv->_entry;
	_tmp2_ = _tmp1_->text_view;
	gwibber_gtk_input_text_view_reset (_tmp2_);
	_tmp3_ = gtk_item;
	_tmp4_ = _g_object_ref0 (IS_TAB_BAR_ITEM (_tmp3_) ? ((TabBarItem*) _tmp3_) : NULL);
	item = _tmp4_;
	_tmp6_ = self->priv->_active_item;
	_tmp7_ = item;
	if (_tmp6_ == _tmp7_) {
		_tmp5_ = TRUE;
	} else {
		GtkButton* _tmp8_;
		_tmp8_ = gtk_item;
		_tmp5_ = _tmp8_ == NULL;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		_g_object_unref0 (item);
		return;
	}
	_tmp10_ = self->priv->_active_item;
	if (IS_TAB_BAR_ITEM (_tmp10_)) {
		TabBarItem* _tmp11_;
		TabBarItem* _tmp12_;
		GtkWidget* _tmp13_ = NULL;
		GtkWidget* _tmp14_;
		gboolean _tmp15_;
		_tmp11_ = self->priv->_active_item;
		tab_bar_item_set_active (_tmp11_, FALSE);
		_tmp12_ = self->priv->_active_item;
		_tmp13_ = tab_bar_item_get_toolbar (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = GTK_IS_WIDGET (_tmp14_);
		_g_object_unref0 (_tmp14_);
		if (_tmp15_) {
			TabBarItem* _tmp16_;
			GtkWidget* _tmp17_ = NULL;
			GtkWidget* _tmp18_;
			_tmp16_ = self->priv->_active_item;
			_tmp17_ = tab_bar_item_get_toolbar (_tmp16_);
			_tmp18_ = _tmp17_;
			gtk_widget_hide (_tmp18_);
			_g_object_unref0 (_tmp18_);
		}
	}
	_tmp19_ = item;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (self->priv->_active_item);
	self->priv->_active_item = _tmp20_;
	_tmp21_ = self->priv->_active_item;
	tab_bar_item_set_active (_tmp21_, TRUE);
	_tmp22_ = self->priv->_active_item;
	_tmp23_ = tab_bar_item_get_toolbar (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = GTK_IS_WIDGET (_tmp24_);
	_g_object_unref0 (_tmp24_);
	if (_tmp25_) {
		TabBarItem* _tmp26_;
		GtkWidget* _tmp27_ = NULL;
		GtkWidget* _tmp28_;
		GtkAlignment* _tmp29_;
		_tmp26_ = self->priv->_active_item;
		_tmp27_ = tab_bar_item_get_toolbar (_tmp26_);
		_tmp28_ = _tmp27_;
		gtk_widget_show (_tmp28_);
		_g_object_unref0 (_tmp28_);
		_tmp29_ = self->priv->_align;
		gtk_alignment_set_padding (_tmp29_, (guint) 0, (guint) 8, (guint) 0, (guint) 0);
	} else {
		GtkAlignment* _tmp30_;
		_tmp30_ = self->priv->_align;
		gtk_alignment_set_padding (_tmp30_, (guint) 0, (guint) 0, (guint) 0, (guint) 0);
	}
	_tmp31_ = self->priv->_active_item;
	_tmp32_ = tab_bar_item_get_view (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = GTK_IS_WIDGET (_tmp33_);
	_g_object_unref0 (_tmp33_);
	if (_tmp34_) {
		GtkBox* _tmp35_;
		GList* _tmp36_ = NULL;
		GList* children;
		gint i;
		GList* _tmp37_;
		gint _tmp45_;
		guint _tmp46_;
		gint64 _tmp48_ = 0LL;
		guint _tmp49_ = 0U;
		TabBarItem* _tmp50_;
		GtkWidget* _tmp51_ = NULL;
		GtkWidget* _tmp52_;
		GtkBox* _tmp53_;
		GtkLayout* _tmp54_;
		_tmp35_ = self->priv->_view_box;
		_tmp36_ = gtk_container_get_children ((GtkContainer*) _tmp35_);
		children = _tmp36_;
		i = 0;
		_tmp37_ = children;
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp37_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp38_;
				GtkWidget* child = NULL;
				_tmp38_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp38_;
				{
					GtkWidget* _tmp39_;
					TabBarItem* _tmp40_;
					GtkWidget* _tmp41_ = NULL;
					GtkWidget* _tmp42_;
					gboolean _tmp43_;
					gint _tmp44_;
					_tmp39_ = child;
					_tmp40_ = self->priv->_active_item;
					_tmp41_ = tab_bar_item_get_view (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp39_ == _tmp42_;
					_g_object_unref0 (_tmp42_);
					if (_tmp43_) {
						_g_object_unref0 (child);
						break;
					}
					_tmp44_ = i;
					i = _tmp44_ + 1;
					_g_object_unref0 (child);
				}
			}
		}
		_tmp45_ = i;
		self->priv->_active_item_n = _tmp45_;
		_tmp46_ = self->priv->_anim_id;
		if (_tmp46_ != ((guint) 0)) {
			guint _tmp47_;
			_tmp47_ = self->priv->_anim_id;
			g_source_remove (_tmp47_);
		}
		_tmp48_ = g_get_monotonic_time ();
		self->priv->_anim_start = _tmp48_;
		_tmp49_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 15, ____lambda13__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_anim_id = _tmp49_;
		_tmp50_ = self->priv->_active_item;
		_tmp51_ = tab_bar_item_get_view (_tmp50_);
		_tmp52_ = _tmp51_;
		gtk_widget_queue_draw (_tmp52_);
		_g_object_unref0 (_tmp52_);
		_tmp53_ = self->priv->_view_box;
		gtk_widget_queue_draw ((GtkWidget*) _tmp53_);
		_tmp54_ = self->priv->_layout;
		gtk_widget_queue_draw ((GtkWidget*) _tmp54_);
		_g_list_free0 (children);
	}
	_tmp55_ = self->priv->_entry;
	gtk_widget_queue_draw ((GtkWidget*) _tmp55_);
	_tmp56_ = item;
	g_signal_emit_by_name (self, "tab-changed", _tmp56_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (item);
}


void tab_bar_show_entry (TabBar* self) {
	g_return_if_fail (self != NULL);
}


void tab_bar_on_write_clicked (TabBar* self) {
	StreamEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry;
	_tmp1_ = stream_entry_get_showing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		StreamEntry* _tmp3_;
		StreamEntry* _tmp4_;
		GwibberGtkInputTextView* _tmp5_;
		GtkBox* _tmp6_;
		_tmp3_ = self->priv->_entry;
		stream_entry_set_showing (_tmp3_, FALSE);
		_tmp4_ = self->priv->_entry;
		_tmp5_ = _tmp4_->text_view;
		gwibber_gtk_input_text_view_reset (_tmp5_);
		_tmp6_ = self->priv->_view_box;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, TRUE);
	} else {
		StreamEntry* _tmp7_;
		StreamEntry* _tmp8_;
		GwibberGtkInputTextView* _tmp9_;
		GtkBox* _tmp10_;
		_tmp7_ = self->priv->_entry;
		stream_entry_set_showing (_tmp7_, TRUE);
		_tmp8_ = self->priv->_entry;
		_tmp9_ = _tmp8_->text_view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
		_tmp10_ = self->priv->_view_box;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean _tab_bar_on_align_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = tab_bar_on_align_draw (self, cr);
	return result;
}


static void _tab_bar_on_write_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tab_bar_on_write_clicked (self);
}


static void _tab_bar___lambda14_ (TabBar* self) {
	StreamEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkBox* _tmp5_;
	StreamEntry* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	_tmp0_ = self->priv->_entry;
	_tmp1_ = stream_entry_get_showing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		StreamEntry* _tmp3_;
		GwibberGtkInputTextView* _tmp4_;
		_tmp3_ = self->priv->_entry;
		_tmp4_ = _tmp3_->text_view;
		gwibber_gtk_input_text_view_reset (_tmp4_);
	}
	_tmp5_ = self->priv->_view_box;
	_tmp6_ = self->priv->_entry;
	_tmp7_ = stream_entry_get_showing (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, !_tmp8_);
}


static void __tab_bar___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tab_bar___lambda14_ (self);
}


static void _tab_bar___lambda15_ (TabBar* self, GtkAllocation* a) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	gboolean _tmp7_;
	g_return_if_fail (a != NULL);
	_tmp1_ = self->priv->_last_width;
	_tmp2_ = *a;
	_tmp3_ = _tmp2_.width;
	if (_tmp1_ != _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		GtkAllocation _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->_last_height;
		_tmp5_ = *a;
		_tmp6_ = _tmp5_.height;
		_tmp0_ = _tmp4_ != _tmp6_;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		GtkAllocation _tmp8_;
		gint _tmp9_;
		GtkAllocation _tmp10_;
		gint _tmp11_;
		GtkBox* _tmp12_;
		GList* _tmp13_ = NULL;
		GList* children;
		GList* _tmp14_;
		GtkBox* _tmp20_;
		gint _tmp21_;
		GList* _tmp22_;
		guint _tmp23_ = 0U;
		gint _tmp24_;
		StreamEntry* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp8_ = *a;
		_tmp9_ = _tmp8_.width;
		self->priv->_last_width = _tmp9_;
		_tmp10_ = *a;
		_tmp11_ = _tmp10_.height;
		self->priv->_last_height = _tmp11_;
		_tmp12_ = self->priv->_view_box;
		_tmp13_ = gtk_container_get_children ((GtkContainer*) _tmp12_);
		children = _tmp13_;
		_tmp14_ = children;
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp14_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp15_;
				GtkWidget* child = NULL;
				_tmp15_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp15_;
				{
					GtkWidget* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					GtkWidget* _tmp19_;
					_tmp16_ = child;
					_tmp17_ = self->priv->_last_width;
					_tmp18_ = self->priv->_last_height;
					gtk_widget_set_size_request (_tmp16_, _tmp17_, _tmp18_);
					_tmp19_ = child;
					gtk_widget_queue_draw (_tmp19_);
					_g_object_unref0 (child);
				}
			}
		}
		_tmp20_ = self->priv->_view_box;
		_tmp21_ = self->priv->_last_width;
		_tmp22_ = children;
		_tmp23_ = g_list_length (_tmp22_);
		_tmp24_ = self->priv->_last_height;
		gtk_widget_set_size_request ((GtkWidget*) _tmp20_, _tmp21_ * ((gint) _tmp23_), _tmp24_);
		_tmp25_ = self->priv->_entry;
		_tmp26_ = self->priv->_last_width;
		_tmp27_ = self->priv->_last_height;
		gtk_widget_set_size_request ((GtkWidget*) _tmp25_, _tmp26_, _tmp27_);
		gtk_widget_queue_draw ((GtkWidget*) self);
		_g_list_free0 (children);
	}
}


static void __tab_bar___lambda15__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	_tab_bar___lambda15_ (self, allocation);
}


static GObject * tab_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TabBar * self;
	GtkAlignment* _tmp0_;
	GtkAlignment* _tmp1_;
	GtkAlignment* _tmp2_;
	GtkStyleContext* _tmp3_ = NULL;
	GtkAlignment* _tmp4_;
	GtkStyleContext* _tmp5_ = NULL;
	GtkAlignment* _tmp6_;
	GtkAlignment* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkAlignment* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkLayout* _tmp20_;
	GtkLayout* _tmp21_;
	GtkLayout* _tmp22_;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkLayout* _tmp26_;
	GtkBox* _tmp27_;
	GtkSizeGroup* _tmp28_;
	WriteItem* _tmp29_;
	WriteItem* _tmp30_;
	WriteItem* _tmp31_;
	GtkBox* _tmp32_;
	WriteItem* _tmp33_;
	StreamEntry* _tmp34_;
	StreamEntry* _tmp35_;
	StreamEntry* _tmp36_;
	GtkLayout* _tmp37_;
	StreamEntry* _tmp38_;
	StreamEntry* _tmp39_;
	GtkLayout* _tmp40_;
	parent_class = G_OBJECT_CLASS (tab_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TAB_BAR (obj);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 1.0f);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_align);
	self->priv->_align = _tmp1_;
	_tmp2_ = self->priv->_align;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "primary-toolbar");
	_tmp4_ = self->priv->_align;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "toolbar");
	_tmp6_ = self->priv->_align;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "draw", (GCallback) _tab_bar_on_align_draw_gtk_widget_draw, self, 0);
	_tmp7_ = self->priv->_align;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp7_, FALSE, TRUE, (guint) 0);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 8);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->_vbox);
	self->priv->_vbox = _tmp9_;
	_tmp10_ = self->priv->_align;
	_tmp11_ = self->priv->_vbox;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp13_ = g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->_tab_box);
	self->priv->_tab_box = _tmp13_;
	_tmp14_ = self->priv->_vbox;
	_tmp15_ = self->priv->_tab_box;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp17_ = g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_toolbar_box);
	self->priv->_toolbar_box = _tmp17_;
	_tmp18_ = self->priv->_vbox;
	_tmp19_ = self->priv->_toolbar_box;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = (GtkLayout*) gtk_layout_new (NULL, NULL);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->_layout);
	self->priv->_layout = _tmp21_;
	_tmp22_ = self->priv->_layout;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp22_, TRUE, TRUE, (guint) 0);
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp24_ = g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->_view_box);
	self->priv->_view_box = _tmp24_;
	_tmp25_ = self->priv->_view_box;
	gtk_box_set_homogeneous (_tmp25_, TRUE);
	_tmp26_ = self->priv->_layout;
	_tmp27_ = self->priv->_view_box;
	gtk_layout_put (_tmp26_, (GtkWidget*) _tmp27_, 0, 0);
	_tmp28_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	_g_object_unref0 (self->priv->_view_group);
	self->priv->_view_group = _tmp28_;
	_tmp29_ = write_item_new ();
	_tmp30_ = g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->_write_item);
	self->priv->_write_item = _tmp30_;
	_tmp31_ = self->priv->_write_item;
	g_signal_connect_object ((GtkButton*) _tmp31_, "clicked", (GCallback) _tab_bar_on_write_clicked_gtk_button_clicked, self, 0);
	_tmp32_ = self->priv->_tab_box;
	_tmp33_ = self->priv->_write_item;
	gtk_box_pack_end (_tmp32_, (GtkWidget*) _tmp33_, FALSE, TRUE, (guint) 0);
	_tmp34_ = stream_entry_new ();
	_tmp35_ = g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = _tmp35_;
	_tmp36_ = self->priv->_entry;
	_tmp36_->in_client = TRUE;
	_tmp37_ = self->priv->_layout;
	_tmp38_ = self->priv->_entry;
	gtk_layout_put (_tmp37_, (GtkWidget*) _tmp38_, 0, 0);
	_tmp39_ = self->priv->_entry;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::showing", (GCallback) __tab_bar___lambda14__g_object_notify, self, 0);
	_tmp40_ = self->priv->_layout;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "size-allocate", (GCallback) __tab_bar___lambda15__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}


static void tab_bar_class_init (TabBarClass * klass) {
	tab_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TabBarPrivate));
	G_OBJECT_CLASS (klass)->constructor = tab_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = tab_bar_finalize;
	g_signal_new ("tab_changed", TYPE_TAB_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TAB_BAR_ITEM);
}


static void tab_bar_instance_init (TabBar * self) {
	self->priv = TAB_BAR_GET_PRIVATE (self);
	self->priv->_entry = NULL;
	self->priv->_active_item = NULL;
	self->priv->_active_item_n = 0;
	self->priv->_anim_id = (guint) 0;
	self->priv->_anim_offset = 0.0f;
	self->priv->_anim_start = (gint64) 0;
}


static void tab_bar_finalize (GObject* obj) {
	TabBar * self;
	self = TAB_BAR (obj);
	_g_object_unref0 (self->priv->_align);
	_g_object_unref0 (self->priv->_vbox);
	_g_object_unref0 (self->priv->_tab_box);
	_g_object_unref0 (self->priv->_toolbar_box);
	_g_object_unref0 (self->priv->_layout);
	_g_object_unref0 (self->priv->_view_box);
	_g_object_unref0 (self->priv->_view_group);
	_g_object_unref0 (self->priv->_write_item);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->_active_item);
	G_OBJECT_CLASS (tab_bar_parent_class)->finalize (obj);
}


GType tab_bar_get_type (void) {
	static volatile gsize tab_bar_type_id__volatile = 0;
	if (g_once_init_enter (&tab_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TabBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TabBar), 0, (GInstanceInitFunc) tab_bar_instance_init, NULL };
		GType tab_bar_type_id;
		tab_bar_type_id = g_type_register_static (GTK_TYPE_BOX, "TabBar", &g_define_type_info, 0);
		g_once_init_leave (&tab_bar_type_id__volatile, tab_bar_type_id);
	}
	return tab_bar_type_id__volatile;
}



