from gwibber.microblog import network, util
from gwibber.microblog.util import resources
import json, re
from gettext import lgettext as _

import logging
logger = logging.getLogger("FourSquare")
logger.debug("Initializing.")

PROTOCOL_INFO = {
  "name": "Foursquare",
  "version": "4.0",
  
  "config": [
    "private:secret_token",
    "access_token",
    "receive_enabled",
    "username",
    "color",
  ],

  "authtype": "oauth2",
  "color": "#990099",

  "features": [
    "receive",
  ],

  "default_streams": [
    "receive",
  ],
}

URL_PREFIX = "https://api.foursquare.com/v2"

class Client:
  def __init__(self, acct):
    self.service = util.getbus("Service")
    if acct.has_key("secret_token") and acct.has_key("password"): acct.pop("password")
    self.account = acct
    
    if not acct.has_key("access_token") and not acct.has_key("secret_token"):
      return [{"error": {"type": "auth", "account": self.account, "message": _("Failed to find credentials")}}]

    self.token = acct["access_token"]

  def _message(self, data):

    m = {}; 
    m["mid"] = str(data["id"])
    m["service"] = "foursquare"
    m["account"] = self.account["id"]
    m["time"] = data["createdAt"]

    shouttext = ""
    text = ""
    
    if data.has_key("shout"):
      shout = data["shout"]
      shout = shout.replace('& ', '&amp; ')
        
    if data.has_key("venue"):
      venuename = data["venue"]["name"]
      venuename = venuename.replace('& ', '&amp; ')
    
      if data.has_key("shout"):
        shouttext += shout + "\n\n"
        text += shout + "\n"
      if data["venue"].has_key("id"):
        m["url"] = "https://foursquare.com/venue/%s" % data["venue"]["id"]
      else:
        m["url"] = "https://foursquare.com"
      shouttext += "Checked in at <a href='" + m["url"] + "'>" + venuename + "</a>"
      text += "Checked in at " + venuename
      if data["venue"]["location"].has_key("address"):
        shouttext += ", " + data["venue"]["location"]["address"]
        text += ", " + data["venue"]["location"]["address"]
      if data["venue"]["location"].has_key("crossstreet"):
        shouttext += " and " + data["venue"]["location"]["crossstreet"]
        text += " and " + data["venue"]["location"]["crossstreet"]
      if data["venue"]["location"].has_key("city"):
        shouttext += ", " + data["venue"]["location"]["city"]
        text += ", " + data["venue"]["location"]["city"]
      if data["venue"]["location"].has_key("state"):
        shouttext += ", " + data["venue"]["location"]["state"]
        text += ", " + data["venue"]["location"]["state"]
      if data.has_key("event"):
        if data["event"].has_key("name"):
          shouttext += " for " + data["event"]["name"]
    else:
      if data.has_key("shout"):
          shouttext += shout + "\n\n"
          text += shout + "\n"
      else:
          text= "Checked in off the grid"
          shouttext= "Checked in off the grid"
    
    m["text"] = text
    m["content"] = shouttext
    m["html"] = shouttext
    
    m["sender"] = {}
    m["sender"]["id"] = data["user"]["id"]
    m["sender"]["image"] = data["user"]["photo"]
    m["sender"]["url"] = data["user"]["canonicalUrl"]
    if data["user"]["relationship"] == "self": 
        m["sender"]["is_me"] = True 
    else: 
        m["sender"]["is_me"] = False
    fullname = ""
    if data["user"].has_key("firstName"):
        fullname += data["user"]["firstName"] + " "
    if data["user"].has_key("lastName"):
        fullname += data["user"]["lastName"]

    if data.has_key("photos"):
      if data["photos"]["count"] > 0:
        m["photo"] = {}
        m["photo"]["url"] = ""
        m["photo"]["picture"] = data["photos"]["items"][0]["url"] 
        m["photo"]["name"] = ""
        m["type"] = "photo"

    m["sender"]["name"] = fullname
    m["sender"]["nick"] = fullname

    if data.has_key("source"):
        m["source"] = "<a href='" + data["source"]["url"] + "'>" + data["source"]["name"] + "</a>"
    else:
        m["source"] = "<a href='https://foursquare.com/'>Foursquare</a>"
    
    if data.has_key("comments"):
      if data["comments"]["count"] > 0:

        m["comments"] = []
        comments = self._get_comments(data["id"])
        for comment in comments:
          # Get the commenter's name
          fullname = ""
          if comment["user"].has_key("firstName"):
            fullname += comment["user"]["firstName"] + " "
          if comment["user"].has_key("lastName"):
            fullname += comment["user"]["lastName"]
         
          # Create a sender
          sender = {
            "name" : fullname,
            "id"   : comment["user"]["id"],
            "is_me": False,
            "image": comment["user"]["photo"],
            "url"  : comment["user"]["canonicalUrl"]
          }
          # Create a comment
          m["comments"].append({
              "text"  : comment["text"],
              "time"  : comment["createdAt"],
              "sender": sender,
          })

    return m

  def _check_error(self, data):
    if isinstance(data, dict) and "recent" in data:
      return True
    else:
      logger.error("Foursquare error %s", data)
      return False
  
  def _get_comments(self, checkin_id):
    url = "/".join((URL_PREFIX, "checkins", checkin_id))
    url = url + "?oauth_token=" + self.token
    data = network.Download(url, None, False).get_json()["response"]
    return data["checkin"]["comments"]["items"]

  def _get(self, path, parse="message", post=False, single=False, **args):
    url = "/".join((URL_PREFIX, path))
    
    url = url + "?oauth_token=" + self.token

    data = network.Download(url, None, post).get_json()["response"]

    resources.dump(self.account["service"], self.account["id"], data)

    if isinstance(data, dict) and data.get("errors", 0):
      if "authenticate" in data["errors"][0]["message"]:
        logstr = """%s: %s - %s""" % (PROTOCOL_INFO["name"], _("Authentication failed"), error["message"])
        logger.error("%s", logstr)
        return [{"error": {"type": "auth", "account": self.account, "message": data["errors"][0]["message"]}}]
      else:
        for error in data["errors"]:
          logstr = """%s: %s - %s""" % (PROTOCOL_INFO["name"], _("Unknown failure"), error["message"])
          return [{"error": {"type": "unknown", "account": self.account, "message": error["message"]}}]
    elif isinstance(data, dict) and data.get("error", 0):
      if "Incorrect signature" in data["error"]:
        logstr = """%s: %s - %s""" % (PROTOCOL_INFO["name"], _("Request failed"), data["error"])
        logger.error("%s", logstr)
        return [{"error": {"type": "auth", "account": self.account, "message": data["error"]}}]
    elif isinstance(data, str):
      logstr = """%s: %s - %s""" % (PROTOCOL_INFO["name"], _("Request failed"), data)
      logger.error("%s", logstr)
      return [{"error": {"type": "request", "account": self.account, "message": data}}]
    if not self._check_error(data):
      return []

    checkins = data["recent"]
    if single: return [getattr(self, "_%s" % parse)(checkins)]
    if parse: return [getattr(self, "_%s" % parse)(m) for m in checkins]
    else: return []
    
  def __call__(self, opname, **args):
    return getattr(self, opname)(**args)

  def receive(self):
    return self._get("checkins/recent")
