import os, unittest, gettext, time
from gi.repository import Gwibber, Dee, GObject

class StreamsModelTestCase (unittest.TestCase):
    def setUp (self):
        self.streams = Gwibber.Streams ()
        self.model = self.streams.props.stream_model

    def test_streams_model_cols (self):
        self.assertEqual (int(self.model.get_n_columns ()), len(Gwibber.StreamModelColumn.__enum_values__))

    def test_streams_model_rows (self):
        GObject.timeout_add (100, lambda: self.assertLess (0, len(self.model)))

test_cases = (StreamsModelTestCase,)

def load_tests (loader, tests, pattern):
    suite = unittest.TestSuite ()
    for test_class in test_cases:
        tests = loader.loadTestsFromTestCase (test_class)
        suite.addTests (tests)
    return suite
