# Copyright (c) 2012 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from os import path

from django.conf import settings

from openstack_dashboard.test import helpers as test


class ErrorPageTests(test.TestCase):
    """Tests for error pages."""
    urls = 'openstack_dashboard.test.error_pages_urls'

    def test_500_error(self):
        TEMPLATE_DIRS = (path.join(settings.ROOT_PATH, 'templates'),)
        with self.settings(TEMPLATE_DIRS=TEMPLATE_DIRS):
            response = self.client.get('/500/')
            self.assertTrue('Server error' in response.content)
