#ifndef __LINUX_NL80211_H
#define __LINUX_NL80211_H
/*
 * 802.11 netlink interface public header
 *
 * Copyright 2006 Johannes Berg <johannes@sipsolutions.net>
 */

/* currently supported commands
 * don't change the order or add anything inbetween, this is ABI! */
enum {
	/* There's no technical reason to not use command 0 but malformed
	 * zeroed messages may have it and this catches that */
	NL80211_CMD_UNSPEC,

	/* Get supported commands by ifindex,
	 * uses NL80211_ATTR_CMDS (output) and NL80211_ATTR_IFINDEX (input) */
	NL80211_CMD_GET_CMDLIST,

	/* Supported commands returned */
	NL80211_CMD_NEW_CMDLIST,

	/* Inject a frame using NL80211_ATTR_FLAGS and NL80211_ATTR_FRAME.
	 * If kernel sends this, it's a status notification for the injected
	 * frame. */
	NL80211_CMD_INJECT,

	/* add a virtual interface to a group that is identified by any
	 * other ifindex in the group of a wiphy index, needs the
	 * NL80211_IF_NAME attribute */
	NL80211_CMD_ADD_VIRTUAL_INTERFACE,

	/* remove a given (with NL80211_ATTR_IFINDEX) virtual device */
	NL80211_CMD_DEL_VIRTUAL_INTERFACE,

	/* get list of all wiphys */
	NL80211_CMD_GET_WIPHYS,

	/* get list of all wiphys */
	NL80211_CMD_NEW_WIPHYS,

	/* get list of all interfaces belonging to a wiphy */
	NL80211_CMD_GET_INTERFACES,

	/* get list of all interfaces belonging to a wiphy */
	NL80211_CMD_NEW_INTERFACES,

	/* configure device */
	NL80211_CMD_CONFIGURE,

	/* request configuration */
	NL80211_CMD_GET_CONFIG,

	/* configuration sent from kernel */
	NL80211_CMD_NEW_CONFIG,

	/* initiate scan.
	 * Takes a CHANNEL_LIST attribute containing nested
	 * attributes which in turn contain CHANNEL and FLAGS
	 * attributes.
	 * The top level can also contain a FLAGS attribute
	 * which is then the default for each channel.
	 * If no channel list is given (or it is empty)
	 * all channels shall be scanned. */
	NL80211_CMD_INITIATE_SCAN,

	/* scan result (kernel -> userspace) */
	NL80211_CMD_SCAN_RESULT,

	/* change roaming control */
	NL80211_CMD_SET_ROAMING_CONTROL,

	/* get roaming control setting */
	NL80211_CMD_GET_ROAMING_CONTROL,

	/* answer to that */
	NL80211_CMD_ROAMING_CONTROL,

	/* set access point BSSID for userspace roaming */
	NL80211_CMD_SET_FIXED_BSSID,

	/* get currently set userspace roaming BSSID */
	NL80211_CMD_GET_FIXED_BSSID,

	/* currently set roaming BSSID */
	NL80211_CMD_FIXED_BSSID,

	/* get current association information, if not associated then
	 * the BSSID attribute is not present in response */
	NL80211_CMD_GET_ASSOCIATION,

	/* association notification and response to GET_BSSID */
	NL80211_CMD_ASSOCIATION_CHANGED,

	/* disassociate from current AP */
	NL80211_CMD_DISASSOCIATE,

	/* deauth from current AP */
	NL80211_CMD_DEAUTH,

	/* associate with current settings */
	NL80211_CMD_ASSOCIATE,

	/* re-associate with current settings
	 * (SSID and BSSID if roaming control in userspace) */
	NL80211_CMD_REASSOCIATE,

	/* request the full list of BSSs the device is
	 * authenticated with */
	NL80211_CMD_GET_AUTH_LIST,

	/* sent as a response to GET_AUTH_LIST containing
	 * an ATTR_BSSID_LIST */
	NL80211_CMD_AUTH_LIST,

	/* sent when authenticating/deauthenticating.
	 * contains an ATTR_BSSID and possibly an
	 * ATTR_DEAUTHENTICATED */
	NL80211_CMD_AUTHENTICATION_CHANGED,

	/* add commands here */

	/* used to define NL80211_CMD_MAX below */
	__NL80211_CMD_AFTER_LAST,
};
#define NL80211_CMD_MAX (__NL80211_CMD_AFTER_LAST - 1)


/* currently supported attributes.
 * don't change the order or add anything inbetween, this is ABI! */
enum {
	NL80211_ATTR_UNSPEC,

	/* network device (ifindex) to operate on */
	NL80211_ATTR_IFINDEX,

	/* wiphy index to operate on */
	NL80211_ATTR_WIPHY,

	/* list of u8 cmds that a given device implements */
	NL80211_ATTR_CMDS,

	/* flags for injection and other commands, see below */
	NL80211_ATTR_FLAGS,

	/* which hardware queue to use */
	NL80211_ATTR_QUEUE,

	/* frame to inject or received frame for mgmt frame subscribers */
	NL80211_ATTR_FRAME,

	/* interface name */
	NL80211_ATTR_IFNAME,

	/* type of (virtual) interface */
	NL80211_ATTR_IFTYPE,

	/* interface list */
	NL80211_ATTR_INTERFACE_LIST,

	/* wiphy list */
	NL80211_ATTR_WIPHY_LIST,

	/* channel, 1-14 are B/G */
	NL80211_ATTR_CHANNEL,

	/* channel list for scan determination */
	NL80211_ATTR_CHANNEL_LIST,

	/* receiver sensitivity in dBm */
	NL80211_ATTR_RX_SENSITIVITY,

	/* BSSID to associate to, only used when roaming control
	 * is in userspace */
	NL80211_ATTR_BSSID,

	/* list of multiple BSSIDs, this is a nested attribute
	 * containing an index->(attrs) mapping */
	NL80211_ATTR_BSSID_LIST,

	/* this is a flag for when an authentication is lost */
	NL80211_ATTR_DEAUTHENTICATED,

	/* SSID of ESS to associate to */
	NL80211_ATTR_SSID,

	/* transmit power in mW */
	NL80211_ATTR_TRANSMIT_POWER,

	/* fragmentation threshold in bytes */
	NL80211_ATTR_FRAG_THRESHOLD,

	/* one or more information elements */
	NL80211_ATTR_INFORMATION_ELEMENT,

	NL80211_ATTR_ROAMING_CONTROL,

	NL80211_ATTR_SCAN_TYPE,

	/* add attributes here */

	/* used to define NL80211_ATTR_MAX below */
	__NL80211_ATTR_AFTER_LAST,
};
#define NL80211_ATTR_MAX (__NL80211_ATTR_AFTER_LAST - 1)

/**
 * NL80211_FLAG_TXSTATUS - send transmit status indication
 */
#define NL80211_FLAG_TXSTATUS		(1<<0)
/**
 * NL80211_FLAG_ENCRYPT - encrypt this packet
 * Warning: This looks inside the packet header!
 */
#define NL80211_FLAG_ENCRYPT		(1<<1)

/**
 * NL80211_FLAG_SCAN_TYPE_ACTIVE - set this with a scan
 * request to have it scan actively, can also be used
 * within the nested CHANNEL_LIST...
 */
#define NL80211_FLAG_SCAN_TYPE_ACTIVE	(1<<2)

/**
 * maximum length of a frame that can be injected
 */
#define NL80211_MAX_FRAME_LEN 2500

/* this is an arbitrary limit, 516 means two full-length
 * IEs would fit... */
/**
 * maximum length of IE(s) passed in an NL80211_ATTR_INFORMATION_ELEMENT.
 */
#define NL80211_MAX_IE_LEN 516

/* may need to be bumped? */
/**
 * maximum number of items in an ATTR_CHANNEL_LIST
 */
#define NL80211_MAX_CHANNEL_LIST_ITEM 20

/**
 * &enum nl80211_iftype - (virtual) interface types
 *
 * This structure is used with the NL80211_ATTR_IFTYPE
 * to set the type of an interface.
 * Note that these are intentionally compatible with
 * the IW_MODE_* constants except for the removal of
 * IW_MODE_AUTO.
 *
 */
enum {
	NL80211_IFTYPE_UNSPECIFIED,
	NL80211_IFTYPE_ADHOC,
	NL80211_IFTYPE_STATION,
	NL80211_IFTYPE_AP,
	NL80211_IFTYPE_WDS,
	NL80211_IFTYPE_SECONDARY,
	NL80211_IFTYPE_MONITOR,

	/* keep last */
	__NL80211_IFTYPE_AFTER_LAST
};
#define NL80211_IFTYPE_MAX (__NL80211_IFTYPE_AFTER_LAST - 1)

enum {
	NL80211_ROAMING_CONTROL_KERNEL,
	NL80211_ROAMING_CONTROL_USERSPACE,

	/* keep last */
	__NL80211_ROAMING_CONTROL_AFTER_LAST
};
#define NL80211_ROAMING_CONTROL_MAX (__NL80211_ROAMING_CONTROL_AFTER_LAST-1)

#endif /* __LINUX_NL80211_H */
