/* Generated by GOB (v2.0.16)   (do not edit directly) */



/*
 * Copyright © 2009  Red Hat, Inc. All rights reserved.
 * Copyright © 2009  Ding-Yi Chen <dchen at redhat.com>
 *
 * This file is part of the ibus-chewing Project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include <stdlib.h>
#include <libintl.h>
#include <ibus.h>
#include <chewing.h>
#include <string.h>
#include <stdio.h>
#define GETTEXT_PACKAGE "gtk20"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <X11/extensions/XTest.h>
#include <X11/Xlib.h>
#include <ctype.h>

#include <glib.h>
#include <glib-object.h>
#ifndef __IBUS_CHEWING_ENGINE_H__
#define __IBUS_CHEWING_ENGINE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef enum {
	CHEWING_KBTYPE_INVALID = -1,
	CHEWING_KBTYPE_DEFAULT,
	CHEWING_KBTYPE_HSU,
	CHEWING_KBTYPE_IBM,
	CHEWING_KBTYPE_GIN_YIEH,
	CHEWING_KBTYPE_ETEN,
	CHEWING_KBTYPE_ETEN26,
	CHEWING_KBTYPE_DVORAK,
	CHEWING_KBTYPE_DVORAK_HSU,
	CHEWING_KBTYPE_DACHEN_CP26,
	CHEWING_KBTYPE_HAN_YU
} ChewingKbType;
#define CHEWING_TYPE_KBTYPE chewing_kbtype_get_type()
GType chewing_kbtype_get_type (void) G_GNUC_CONST;


typedef enum {
	CHEWING_MODIFIER_SYNC_DISABLE,
	CHEWING_MODIFIER_SYNC_FROM_KEYBOARD,
	CHEWING_MODIFIER_SYNC_FROM_IM
} ChewingModifierSync;
#define CHEWING_TYPE_MODIFIER_SYNC chewing_modifier_sync_get_type()
GType chewing_modifier_sync_get_type (void) G_GNUC_CONST;


typedef enum {
	CHEWING_INPUT_MODE_BYPASS,
	CHEWING_INPUT_MODE_EDITING,
	CHEWING_INPUT_MODE_SELECTING,
	CHEWING_INPUT_MODE_SELECTING_DONE
} ChewingInputMode;
#define CHEWING_TYPE_INPUT_MODE chewing_input_mode_get_type()
GType chewing_input_mode_get_type (void) G_GNUC_CONST;


typedef enum {
	CHEWING_OUTPUT_CHARSET_AUTO,
	CHEWING_OUTPUT_CHARSET_BIG5,
	CHEWING_OUTPUT_CHARSET_UTF8
} ChewingOutputCharset;
#define CHEWING_TYPE_OUTPUT_CHARSET chewing_output_charset_get_type()
GType chewing_output_charset_get_type (void) G_GNUC_CONST;



#include "maker-dialog.h"
#define GCONF_KEY_PREFIX "/desktop/ibus/engine/Chewing/"
#define EASY_SYMBOL_INPUT_WORK_AROUND

extern PropertySpec propSpecs[];
extern const gchar *page_labels[];
extern const gchar *button_labels[];
extern GtkResponseType button_responses[];
#define ZHUYIN_BUFFER_SIZE 12

#define ENGINE_FLAG_INITIALIZED		1
#define ENGINE_FLAG_ENABLED		2
#define ENGINE_FLAG_FOCUS_IN		4
#define	ENGINE_FLAG_SHOW_CANDIDATE      8
#define ibus_chewing_engine_set_flag(cengine,f) cengine->_priv->flags |= f
#define ibus_chewing_engine_clear_flag(cengine,f) cengine->_priv->flags &= ~f

#ifdef IBUS_1_1
/*
 * Dummy data structure for ibus 1.1 and early.
 */
typedef void IBusKeymap;
IBusKeymap *ibus_keymap_new(gchar *keymap_name);
#endif /* IBUS_1_1 */

#define G_DEBUG_MSG(level, msg, args...) if (level<=ibus_chewing_verbose) g_debug(msg, ##args)


/*
 * Type checking and casting macros
 */
#define IBUS_TYPE_CHEWING_ENGINE	(ibus_chewing_engine_get_type())
#define IBUS_CHEWING_ENGINE(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), ibus_chewing_engine_get_type(), IBusChewingEngine)
#define IBUS_CHEWING_ENGINE_CONST(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), ibus_chewing_engine_get_type(), IBusChewingEngine const)
#define IBUS_CHEWING_ENGINE_CLASS(klass)	G_TYPE_CHECK_CLASS_CAST((klass), ibus_chewing_engine_get_type(), IBusChewingEngineClass)
#define IBUS_IS_CHEWING_ENGINE(obj)	G_TYPE_CHECK_INSTANCE_TYPE((obj), ibus_chewing_engine_get_type ())

#define IBUS_CHEWING_ENGINE_GET_CLASS(obj)	G_TYPE_INSTANCE_GET_CLASS((obj), ibus_chewing_engine_get_type(), IBusChewingEngineClass)

/* Private structure type */
typedef struct _IBusChewingEnginePrivate IBusChewingEnginePrivate;

/*
 * Main object structure
 */
#ifndef __TYPEDEF_IBUS_CHEWING_ENGINE__
#define __TYPEDEF_IBUS_CHEWING_ENGINE__
typedef struct _IBusChewingEngine IBusChewingEngine;
#endif
struct _IBusChewingEngine {
	IBusEngine __parent__;
	/*< public >*/
	ChewingContext * context;
	ChewingModifierSync syncCapsLock_local;
	GtkWidget * setting_dialog;
	IBusProperty * chieng_prop;
	IBusProperty * alnumSize_prop;
	IBusProperty * settings_prop;
	IBusPropList * prop_list;
	IBusConfig * config;
	/*< private >*/
	gint selKeys[MAX_SELKEY]; /* protected */
	gboolean plainZhuyin; /* protected */
	ChewingInputMode inputMode; /* protected */
	gboolean forceLowercaseEnglish; /* protected */
	gboolean numpadAlwaysNumber; /* protected */
	IBusLookupTable * table; /* protected */
	IBusKeymap * keymap_us; /* protected */
	IBusChewingEnginePrivate *_priv;
};

/*
 * Class definition
 */
typedef struct _IBusChewingEngineClass IBusChewingEngineClass;
struct _IBusChewingEngineClass {
	IBusEngineClass __parent__;
	IBusText * chieng_prop_label_chi;
	IBusText * chieng_prop_label_eng;
	IBusText * alnumSize_prop_label_full;
	IBusText * alnumSize_prop_label_half;
	IBusText * settings_prop_label;
};


/*
 * Public methods
 */
GType	ibus_chewing_engine_get_type	(void) G_GNUC_CONST;
#line 534 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 	ibus_chewing_engine_refresh_property_list	(IBusChewingEngine * self);
#line 186 "ibus-chewing-engine.h"
#line 554 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 	ibus_chewing_engine_hide_property_list	(IBusChewingEngine * self);
#line 189 "ibus-chewing-engine.h"
#line 568 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
gboolean 	ibus_chewing_engine_save_config	(IBusChewingEngine * self,
					const gchar * key_suffix);
#line 193 "ibus-chewing-engine.h"
#line 583 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
gboolean 	ibus_chewing_engine_save_config_all	(IBusChewingEngine * self);
#line 196 "ibus-chewing-engine.h"

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
