/* Generated by GOB (v2.0.16)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "/home/dchen/ibus-chewing/src/MakerDialog.gob"

/*
 * Copyright © 2009  Red Hat, Inc. All rights reserved.
 * Copyright © 2009  Ding-Yi Chen <dchen at redhat.com>
 *
 * This file is part of the ibus-chewing Project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include <stdlib.h>
#include <strings.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <locale.h>

#line 35 "maker-dialog.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 16

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "maker-dialog.h"

#include "maker-dialog-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
static const GEnumValue _maker_dialog_property_flag_values[] = {
	{ MAKER_DIALOG_PROPERTY_FLAG_INVISIBLE, (char *)"MAKER_DIALOG_PROPERTY_FLAG_INVISIBLE", (char *)"invisible" },
	{ MAKER_DIALOG_PROPERTY_FLAG_INSENSITIVE, (char *)"MAKER_DIALOG_PROPERTY_FLAG_INSENSITIVE", (char *)"insensitive" },
	{ MAKER_DIALOG_PROPERTY_FLAG_INEDITABLE, (char *)"MAKER_DIALOG_PROPERTY_FLAG_INEDITABLE", (char *)"ineditable" },
	{ MAKER_DIALOG_PROPERTY_FLAG_HAS_TRANSLATION, (char *)"MAKER_DIALOG_PROPERTY_FLAG_HAS_TRANSLATION", (char *)"has-translation" },
	{ MAKER_DIALOG_PROPERTY_FLAG_TRANSLATION_WITH_CONTEXT, (char *)"MAKER_DIALOG_PROPERTY_FLAG_TRANSLATION_WITH_CONTEXT", (char *)"translation-with-context" },
	{ 0, NULL, NULL }
};

GType
maker_dialog_property_flag_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MakerDialogPropertyFlag", _maker_dialog_property_flag_values);
	return type;
}


#line 90 "/home/dchen/ibus-chewing/src/MakerDialog.gob"

void G_DEBUG_MSG(gint level, const char *format, ...);
#include "MakerDialog-def.c"

#line 79 "maker-dialog.c"
/* self casting macros */
#define SELF(x) MAKER_DIALOG(x)
#define SELF_CONST(x) MAKER_DIALOG_CONST(x)
#define IS_SELF(x) MAKER_IS_DIALOG(x)
#define TYPE_SELF MAKER_TYPE_DIALOG
#define SELF_CLASS(x) MAKER_DIALOG_CLASS(x)

#define SELF_GET_CLASS(x) MAKER_DIALOG_GET_CLASS(x)

/* self typedefs */
typedef MakerDialog Self;
typedef MakerDialogClass SelfClass;

/* here are local prototypes */
#line 0 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
static void maker_dialog_class_init (MakerDialogClass * c) G_GNUC_UNUSED;
#line 96 "maker-dialog.c"
#line 117 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
static void maker_dialog_init (MakerDialog * self) G_GNUC_UNUSED;
#line 99 "maker-dialog.c"
#line 619 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
static void maker_dialog_widget_register (MakerDialog * self, GtkWidget * widget, const gchar * widget_label, const gchar * widget_type) G_GNUC_UNUSED;
#line 102 "maker-dialog.c"

/* pointer to the class of our parent */
static GtkDialogClass *parent_class = NULL;

/* Short form macros */
#define self_new maker_dialog_new
#define self_new_full maker_dialog_new_full
#define self_set_verbose_level maker_dialog_set_verbose_level
#define self_add_property_no_gui maker_dialog_add_property_no_gui
#define self_add_property maker_dialog_add_property
#define self_align_labels maker_dialog_align_labels
#define self_reload_property_value maker_dialog_reload_property_value
#define self_write_gconf_schemas_file maker_dialog_write_gconf_schemas_file
#define self_apply_widget_value maker_dialog_apply_widget_value
#define self_get_widget_value maker_dialog_get_widget_value
#define self_set_widget_value maker_dialog_set_widget_value
#define self_get_widget maker_dialog_get_widget
#define self_get_widget_by_key maker_dialog_get_widget_by_key
#define self_get_widget_by_id maker_dialog_get_widget_by_id
#define self_get_propertyContext_by_key maker_dialog_get_propertyContext_by_key
#define self_get_base_vbox maker_dialog_get_base_vbox
#define self_widget_register maker_dialog_widget_register
GType
maker_dialog_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MakerDialogClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) maker_dialog_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MakerDialog),
			0 /* n_preallocs */,
			(GInstanceInitFunc) maker_dialog_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_DIALOG, "MakerDialog", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MakerDialog *)g_object_new(maker_dialog_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MakerDialog * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MakerDialog *
GET_NEW_VARG (const char *first, ...)
{
	MakerDialog *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MakerDialog *)g_object_new_valist (maker_dialog_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Maker:Dialog::finalize"
	MakerDialog *self G_GNUC_UNUSED = MAKER_DIALOG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 101 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	if(self->dialog_notebook) { gtk_widget_destroy ((gpointer) self->dialog_notebook); self->dialog_notebook = NULL; }
#line 178 "maker-dialog.c"
#line 104 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	if(self->_priv->widgetTable) { g_hash_table_destroy ((gpointer) self->_priv->widgetTable); self->_priv->widgetTable = NULL; }
#line 181 "maker-dialog.c"
#line 106 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	if(self->_priv->notebookContentTable) { g_hash_table_destroy ((gpointer) self->_priv->notebookContentTable); self->_priv->notebookContentTable = NULL; }
#line 184 "maker-dialog.c"
#line 108 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	if(self->_priv->widgetIds) { g_string_chunk_free ((gpointer) self->_priv->widgetIds); self->_priv->widgetIds = NULL; }
#line 187 "maker-dialog.c"
#define propList (self->_priv->propList)
#define VAR propList
	{
#line 110 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	if (VAR){
	    g_ptr_array_foreach(VAR,propList_free_deep_callback,NULL);
	    g_ptr_array_free(VAR,TRUE);
	}
    }
#line 198 "maker-dialog.c"
	memset(&propList, 0, sizeof(propList));
#undef VAR
#undef propList
}
#undef __GOB_FUNCTION__

static void 
maker_dialog_class_init (MakerDialogClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Maker:Dialog::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MakerDialogPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_DIALOG);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 117 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
static void 
maker_dialog_init (MakerDialog * self G_GNUC_UNUSED)
{
#line 222 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MAKER_TYPE_DIALOG,MakerDialogPrivate);
#line 90 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->vbox_homogeneous = TRUE;
#line 227 "maker-dialog.c"
#line 90 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->hbox_spacing = 2;
#line 230 "maker-dialog.c"
#line 90 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->vbox_spacing = 2;
#line 233 "maker-dialog.c"
#line 90 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->dialog_notebook = NULL;
#line 236 "maker-dialog.c"
#line 103 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->_priv->widgetTable = g_hash_table_new_full(g_str_hash,g_str_equal,NULL,NULL);
#line 239 "maker-dialog.c"
#line 105 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->_priv->notebookContentTable = g_hash_table_new_full(g_str_hash,g_str_equal,NULL,NULL);
#line 242 "maker-dialog.c"
#line 107 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->_priv->widgetIds = g_string_chunk_new(STRING_BUFFER_SIZE_DEFAULT);
#line 245 "maker-dialog.c"
#line 109 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	self->_priv->propList = g_ptr_array_new();
#line 248 "maker-dialog.c"
}
#undef __GOB_FUNCTION__



#line 120 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
MakerDialog * 
maker_dialog_new (void)
{
#line 258 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::new"
{
#line 120 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	Self *self = GET_NEW;
	return self;
    }}
#line 266 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 125 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
MakerDialog * 
maker_dialog_new_full (const gchar * title, int notebook_pages, const gchar ** notebook_page_labels, int button_num, const gchar ** button_labels, GtkResponseType * button_responses)
{
#line 273 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::new_full"
{
#line 127 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	Self *self = GET_NEW;
	GtkDialog *dialog=GTK_DIALOG(self);
	gtk_window_set_title(GTK_WINDOW(dialog),title);
	gtk_window_set_destroy_with_parent (GTK_WINDOW(dialog), TRUE);
	gtk_window_set_type_hint (GTK_WINDOW(dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

	int i;
	for(i=0;i<button_num;i++){
	    GtkWidget *button=gtk_dialog_add_button(dialog,button_labels[i],button_responses[i]);
	    self_widget_register(self, button, button_labels[i], "button");
	}

	GtkWidget *dialog_vbox = GTK_DIALOG(dialog)->vbox;
	gtk_widget_show (dialog_vbox);

	if (notebook_pages>0){
	    self->dialog_notebook = gtk_notebook_new();
	    gtk_box_pack_start (GTK_BOX(dialog_vbox), self->dialog_notebook, TRUE, TRUE, 0);
	    for (i=0;i<notebook_pages;i++){
		GtkWidget *label=gtk_label_new(_(notebook_page_labels[i]));
		self_widget_register(self, label, notebook_page_labels[i], "label");
		gtk_widget_show(label);

		GtkWidget *vbox=gtk_vbox_new(self->vbox_homogeneous,self->vbox_spacing);
		self_widget_register(self, vbox, notebook_page_labels[i], "vbox");
		gtk_widget_show(vbox);
		gtk_notebook_append_page (GTK_NOTEBOOK(self->dialog_notebook), vbox,label);
	    }
	}
	return self;
    }}
#line 309 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 160 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
void 
maker_dialog_set_verbose_level (MakerDialog * self, gint level)
{
#line 316 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::set_verbose_level"
#line 160 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (self != NULL);
#line 160 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (MAKER_IS_DIALOG (self));
#line 322 "maker-dialog.c"
{
#line 160 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	verboseLevel=level;
    }}
#line 328 "maker-dialog.c"
#undef __GOB_FUNCTION__

/**
 * maker_dialog_add_property_no_gui:
 * @self: A MakerDialog
 * @pSpec: A property spec to be added.
 * @user_data: user_data to be passed to callback functions.
 * @returns: A newly allocated PropertyContext.
 *
 * Add a property without GUI automation involved.
 **/
#line 173 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
PropertyContext * 
maker_dialog_add_property_no_gui (MakerDialog * self, PropertySpec * pSpec, gpointer user_data)
{
#line 344 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::add_property_no_gui"
#line 173 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (PropertyContext * )0);
#line 173 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (PropertyContext * )0);
#line 350 "maker-dialog.c"
{
#line 173 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	G_DEBUG_MSG(2,"::add_property_no_gui(%s,-)",pSpec->key);
	PropertyContext *ctx=propertyContext_new(pSpec,user_data);
	g_ptr_array_add(self->_priv->propList,ctx);
	g_hash_table_insert(self->_priv->notebookContentTable, pSpec->key, pSpec->pageName);
	return ctx;
    }}
#line 360 "maker-dialog.c"
#undef __GOB_FUNCTION__

/**
 * maker_dialog_add_property:
 * @self: A MakerDialog
 * @pSpec: A property spec to be added.
 * @initValue: Initial value of the property.
 * @user_data: user_data to be passed to callback functions.
 * @returns: TRUE if the property adding succeed; FALSE otherwise.
 *
 * Add a property to the dialog and corresponding Gtk widget will also be
 * set.
 * If @initValue is not NULL, it will be the initial value of the widget.
 **/
#line 193 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
gboolean 
maker_dialog_add_property (MakerDialog * self, PropertySpec * pSpec, const gchar * initValue, gpointer user_data)
{
#line 379 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::add_property"
#line 193 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 193 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (gboolean )0);
#line 385 "maker-dialog.c"
{
#line 193 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	G_DEBUG_MSG(2,"::add_property(%s,%s,-)",pSpec->key,initValue);

	GtkWidget *vbox=self_get_base_vbox(self, pSpec->pageName);
	g_assert(vbox);

	GtkWidget *hbox=gtk_hbox_new(FALSE,self->hbox_spacing);
	self_widget_register(self, hbox, pSpec->key, "hbox");
	GtkWidget *label=gtk_label_new(_(pSpec->label));
	self_widget_register(self, label, pSpec->key, "label");
	if (pSpec->tooltip){
	    gtk_widget_set_tooltip_text (label,_(pSpec->tooltip));
	}
	gtk_widget_show(label);
	gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);

	GtkWidget *widget=NULL;
        GtkAdjustment *gAdjust=NULL;
	PropertyContext *ctx=self_add_property_no_gui(self,pSpec,user_data);
	if (!ctx){
	    return FALSE;
	}

	switch(pSpec->valueType){
	    case G_TYPE_BOOLEAN:
		widget = gtk_check_button_new();
		self_widget_register(self, widget, pSpec->key, NULL);
		gboolean bValue=FALSE;
		if(initValue){
		    bValue=atob(initValue);
		}else if (pSpec->defaultValue){
		    bValue=atob(pSpec->defaultValue);
		}
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),bValue);
		if (pSpec->setFunc){
		    g_signal_connect(widget, "toggled", G_CALLBACK(on_toggleButton_toggled_wrap),ctx);
		}
		break;
	    case G_TYPE_UINT:
	    case G_TYPE_INT:
		 gAdjust = (GtkAdjustment *)gtk_adjustment_new (atoi(pSpec->defaultValue),
			     pSpec->min, pSpec->max, 1.0, 0.0, 0.0);
		 widget = gtk_spin_button_new (gAdjust, 1.0, 0);
		 self_widget_register(self, widget, pSpec->key, NULL);

		 if(initValue){
		     gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),atoi(initValue));
		 }else if (pSpec->defaultValue){
		     gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),atoi(pSpec->defaultValue));
		 }

		 if (pSpec->setFunc){
		     g_signal_connect(widget, "value-changed", G_CALLBACK(on_spinButton_value_changed_wrap),ctx);
		 }
		 break;
	    case G_TYPE_STRING:
		if (pSpec->validValues){
		    GtkListStore *listStore=NULL;

		    if (pSpec->propertyFlags & MAKER_DIALOG_PROPERTY_FLAG_HAS_TRANSLATION){
			listStore=gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
		    }else{
			listStore=gtk_list_store_new (1, G_TYPE_STRING);
		    }
		    int i;

		    for(i=0;pSpec->validValues[i]!=NULL;i++){
			/* Add new item*/
			listStore_append(listStore, pSpec->validValues[i],
				pSpec->translationContext,pSpec->propertyFlags);
		    }
		    int index=-1;

		    if (initValue){
			index=listStore_find_string(listStore,initValue,
				pSpec->translationContext,pSpec->propertyFlags);
		    }

		    if (index<0 && pSpec->defaultValue){
			index=listStore_find_string(listStore,pSpec->defaultValue,
				pSpec->translationContext,pSpec->propertyFlags);
		    }

		    if (pSpec->propertyFlags & MAKER_DIALOG_PROPERTY_FLAG_INEDITABLE){
			widget=gtk_combo_box_new_with_model (GTK_TREE_MODEL(listStore));
			GtkCellRenderer *renderer = gtk_cell_renderer_text_new();
			gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(widget), renderer, FALSE);
			if (pSpec->propertyFlags & MAKER_DIALOG_PROPERTY_FLAG_HAS_TRANSLATION){
			    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(widget), renderer,
				    "text", 1,
				    NULL);
			}else{
			    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(widget), renderer,
				    "text", 0,
				    NULL);
			}

		    }else{
			widget=gtk_combo_box_entry_new_with_model (GTK_TREE_MODEL(listStore),
				(pSpec->propertyFlags & MAKER_DIALOG_PROPERTY_FLAG_HAS_TRANSLATION)? 1:0);
		    }

		    self_widget_register(self, widget, pSpec->key, NULL);
		    gtk_combo_box_set_active(GTK_COMBO_BOX(widget),index);


		    if (pSpec->setFunc){
			g_signal_connect(widget, "changed", G_CALLBACK(on_comboBox_changed_wrap),ctx);
		    }

		}else{
		    widget=gtk_entry_new();
		    self_widget_register(self, widget, pSpec->key, NULL);
		    if (pSpec->max>=0){
			gtk_entry_set_max_length(GTK_ENTRY(widget),pSpec->max);
		    }

		    const char *sValue=NULL;

		    if(initValue){
			sValue=initValue;
		    }else if (pSpec->defaultValue){
			sValue=pSpec->defaultValue;
		    }else{
			sValue="";
		    }
		    gtk_entry_set_text(GTK_ENTRY(widget),sValue);
		    gtk_editable_set_editable (GTK_EDITABLE(widget),
			    !(pSpec->propertyFlags & MAKER_DIALOG_PROPERTY_FLAG_INEDITABLE));

		    if (pSpec->setFunc){
			g_signal_connect(widget, "activate", G_CALLBACK(on_entry_activate_wrap),ctx);
		    }
		}
		break;
	    default:
		break;
	}
	if (!widget){
	    return FALSE;
	}

	gtk_box_pack_start (GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	return TRUE;
    }}
#line 535 "maker-dialog.c"
#undef __GOB_FUNCTION__

/**
 * maker_dialog_align_labels:
 * @self: A MakerDialog.
 * @pageName: Name of notebook page to be apply, can be NULL.
 * @xalign: x align of labels. 0.0f for LEFT, 0.5f for CENTER, 1.0f for RIGHT.
 * @yalign: y align of labels. 0.0f for TOP, 0.5f for CENTER, 1.0f for BOTTOM.
 *
 * Align labels for better dialog appearance.
 *
 * Labels that associate with value setting widget are stretched into same width.
 * If @pageName is not NULL, only the labels in the page are stretched,
 * otherwise, all labels will be stretched.
 *
 * Moreover, the horizontal and vertical alignment can set by @xalign and @yalign, respectively.
 **/
#line 356 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
void 
maker_dialog_align_labels (MakerDialog * self, const gchar * pageName, gfloat xalign, gfloat yalign)
{
#line 557 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::align_labels"
#line 356 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (self != NULL);
#line 356 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (MAKER_IS_DIALOG (self));
#line 563 "maker-dialog.c"
{
#line 356 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	WidgetAlignment wAlignment;
	wAlignment.self=self;
	wAlignment.currentMaxWidth=0;
	wAlignment.pageName=pageName;
	wAlignment.xalign=xalign;
	wAlignment.yalign=yalign;
	g_hash_table_foreach(self->_priv->notebookContentTable,
		caculate_max_label_width_callback, (gpointer) &wAlignment);
	g_hash_table_foreach(self->_priv->notebookContentTable,
		set_label_width_callback, (gpointer) &wAlignment);
	gtk_widget_show_all(GTK_WIDGET(self));
    }}
#line 579 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 370 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
void 
maker_dialog_reload_property_value (MakerDialog * self, const gchar * key)
{
#line 586 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::reload_property_value"
#line 370 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (self != NULL);
#line 370 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (MAKER_IS_DIALOG (self));
#line 592 "maker-dialog.c"
{
#line 370 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	gboolean boolValue;
	gint intValue;
	gint uintValue;
	const gchar *stringValue;

	PropertyContext *ctx=self_get_propertyContext_by_key(self,key);
	PropertySpec *pSpec=ctx->spec;
	GtkWidget *widget=self_get_widget_by_key(self,pSpec->key);
	GValue *gValue;

	if (pSpec->getFunc){
	    gValue=pSpec->getFunc(ctx);

	    switch(pSpec->valueType){
		case G_TYPE_BOOLEAN:
		    boolValue=g_value_get_boolean(gValue);
		    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),boolValue);
		    break;
		case G_TYPE_INT:
		    intValue=g_value_get_int(gValue);
		    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),(gdouble) intValue);
		    break;
		case G_TYPE_UINT:
		    uintValue=g_value_get_uint(gValue);
		    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),(gdouble) uintValue);
		    break;
		case G_TYPE_STRING:
		    stringValue=g_value_get_string(gValue);
		    if (pSpec->validValues){
			int index=-1;
			if (stringValue){
			    index=combo_find_string_index(GTK_COMBO_BOX(widget),stringValue,
				    pSpec->translationContext,
				    ctx->spec->propertyFlags);
			}
			if (index<0 && pSpec->defaultValue){
			    index=combo_find_string_index(GTK_COMBO_BOX(widget),pSpec->defaultValue,
				    pSpec->translationContext,
				    ctx->spec->propertyFlags);
			}
			gtk_combo_box_set_active(GTK_COMBO_BOX(widget),index);

		    }else{
			gtk_entry_set_text(GTK_ENTRY(widget),stringValue);
		    }
		    break;
		default:
		    break;
	    }
	}
    }}
#line 647 "maker-dialog.c"
#undef __GOB_FUNCTION__

/**
 * maker_dialog_write_gconf_schemas_file:
 * @self: A MakerDialog.
 * @filename: Filename for output.
 * @owner: Owner of the schemas.
 * @schemasHome: The "home direcory" of schemas.
 * @locales: Supported locales, use ';' as delimiter.
 * @returns: TRUE if succeed; FALSE otherwise.
 *
 * Output the parameters as GConf schemes file.
 **/
#line 434 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
gboolean 
maker_dialog_write_gconf_schemas_file (MakerDialog * self, const gchar * filename, const gchar * owner, const gchar * schemasHome, const gchar * locales)
{
#line 665 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::write_gconf_schemas_file"
#line 434 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 434 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (gboolean )0);
#line 671 "maker-dialog.c"
{
#line 435 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	G_DEBUG_MSG(2,"::output_gconf_schemes_file(%s)",filename);
	FILE *outF=fopen(filename,"w");
	if (outF==NULL){
	    G_DEBUG_MSG(1,"::output_gconf_schemes_file(%s) file %s cannot be written!",
		    filename,filename);
	    return FALSE;
	}
	xml_tags_write(outF,"gconfschemafile",XML_TAG_TYPE_BEGIN_ONLY,NULL,NULL);
	xml_tags_write(outF,"schemalist",XML_TAG_TYPE_BEGIN_ONLY,NULL,NULL);
	SchemasFileData sData;
	sData.schemasHome=schemasHome;
	sData.owner=owner;
	sData.locales=locales;
	sData.outF=outF;
	g_ptr_array_foreach(self->_priv->propList,ctx_write_callback,&sData);
	xml_tags_write(outF,"schemalist",XML_TAG_TYPE_END_ONLY,NULL,NULL);
	xml_tags_write(outF,"gconfschemafile",XML_TAG_TYPE_END_ONLY,NULL,NULL);
	if (fclose(outF))
	    return FALSE;
	G_DEBUG_MSG(2,"::output_gconf_schemes_file(%s) ... done.",filename);
	return TRUE;
    }}
#line 697 "maker-dialog.c"
#undef __GOB_FUNCTION__

/**
 * maker_dialog_apply_widget_value:
 * @self: A MakerDialog.
 * @key: The key of a property.
 *
 * Apply the value shown in widget to the property.
 * Note that a set callback function is needed in PropertySpec to apply the value to property.
 *
 * @see_also: set_widget_value()
 **/
#line 469 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
void 
maker_dialog_apply_widget_value (MakerDialog * self, const gchar * key)
{
#line 714 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::apply_widget_value"
#line 469 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (self != NULL);
#line 469 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (MAKER_IS_DIALOG (self));
#line 720 "maker-dialog.c"
{
#line 469 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	G_DEBUG_MSG(2,"::apply_widget_value(%s)",key);
	PropertyContext *ctx=self_get_propertyContext_by_key(self,key);
	if (!ctx){
	    /* Not found */
	    g_warning("%s: no such PropertyContext",key);
	    return;
	}
	GValue gValue={0};

	self_get_widget_value(self,key,&gValue);

	if (ctx->spec->setFunc){
	    ctx->spec->setFunc(ctx,&gValue);
	}
	g_value_unset(&gValue);
    }}
#line 740 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 488 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
GValue * 
maker_dialog_get_widget_value (MakerDialog * self, const gchar * key, GValue * gValue)
{
#line 747 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::get_widget_value"
#line 488 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (GValue * )0);
#line 488 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (GValue * )0);
#line 753 "maker-dialog.c"
{
#line 488 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	G_DEBUG_MSG(2,"::get_widget_value(%s)",key);
	PropertyContext *ctx=self_get_propertyContext_by_key(self,key);
	if (!ctx){
	    /* Not found */
	    return NULL;
	}
	GtkWidget *widget=self_get_widget_by_key(self,key);
	if (ctx->spec->valueType!=G_TYPE_STRING){
	    g_value_init(gValue,ctx->spec->valueType);
	}
	switch(ctx->spec->valueType){
	    case G_TYPE_BOOLEAN:
		g_value_set_boolean(gValue, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget)));
		break;
	    case G_TYPE_INT:
		g_value_set_int(gValue, (gint) gtk_spin_button_get_value (GTK_SPIN_BUTTON(widget)));
		break;
	    case G_TYPE_UINT:
		g_value_set_uint(gValue, (guint) gtk_spin_button_get_value (GTK_SPIN_BUTTON(widget)));
		break;
	    case G_TYPE_STRING:
		if (ctx->spec->validValues){
		    const char *str=combo_get_active_text (GTK_COMBO_BOX(widget),gValue);
		    G_DEBUG_MSG(3,"::get_widget_value(%s) %s",
			    key,str);
		}else{
		    g_value_set_string(gValue, gtk_entry_get_text (GTK_ENTRY(widget)));
		}

		break;
	    default:
		break;
	}
	return gValue;
    }}
#line 792 "maker-dialog.c"
#undef __GOB_FUNCTION__

/**
 * maker_dialog_set_widget_value:
 * @self: A MakerDialog.
 * @key: The key of a property.
 * @value: Value to be shown in widget.
 *
 * Set value for widget display.
 * However, the property value is not set.
 * Use apply_widget_value() to do it.
 * @see_also: apply_widget_value()
 **/
#line 536 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
void 
maker_dialog_set_widget_value (MakerDialog * self, const gchar * key, GValue * value)
{
#line 810 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::set_widget_value"
#line 536 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (self != NULL);
#line 536 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (MAKER_IS_DIALOG (self));
#line 816 "maker-dialog.c"
{
#line 536 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	int index;
	PropertyContext *ctx=self_get_propertyContext_by_key(self,key);
	if (!ctx){
	    /* Not found */
	    return;
	}
	GtkWidget *widget=self_get_widget_by_key(self,key);
	switch(ctx->spec->valueType){
	    case G_TYPE_BOOLEAN:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(widget),g_value_get_boolean(value));
		break;
	    case G_TYPE_INT:
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),(gdouble) g_value_get_int(value));
		break;
	    case G_TYPE_UINT:
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),(gdouble) g_value_get_uint(value));
		break;
	    case G_TYPE_STRING:
		if (ctx->spec->validValues){
		    const gchar *str=g_value_get_string(value);
		    index=combo_find_string_index(GTK_COMBO_BOX(widget),str,
			    ctx->spec->translationContext,ctx->spec->propertyFlags);
		    gtk_combo_box_set_active (GTK_COMBO_BOX(widget),index);
		}else{
		    g_value_set_string(value, gtk_entry_get_text (GTK_ENTRY(widget)));
		}
		break;
	    default:
		break;
	}
    }}
#line 851 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 570 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
GtkWidget * 
maker_dialog_get_widget (MakerDialog * self, const gchar * widget_key, const gchar * widget_type)
{
#line 858 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::get_widget"
#line 570 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 570 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (GtkWidget * )0);
#line 864 "maker-dialog.c"
{
#line 571 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	gchar buf[STRING_BUFFER_SIZE_DEFAULT];
	widget_get_id(buf, STRING_BUFFER_SIZE_DEFAULT, widget_key, widget_type);
	return self_get_widget_by_id(self, buf);
    }}
#line 872 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 577 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
GtkWidget * 
maker_dialog_get_widget_by_key (MakerDialog * self, const gchar * key)
{
#line 879 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::get_widget_by_key"
#line 577 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 577 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (GtkWidget * )0);
#line 885 "maker-dialog.c"
{
#line 577 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	return self_get_widget(self,key,NULL);
    }}
#line 891 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 581 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
GtkWidget * 
maker_dialog_get_widget_by_id (MakerDialog * self, const gchar * id)
{
#line 898 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::get_widget_by_id"
#line 581 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 581 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (GtkWidget * )0);
#line 904 "maker-dialog.c"
{
#line 581 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	G_DEBUG_MSG(3,"*** get_widget_by_id(%s)",id);
	return (GtkWidget *) g_hash_table_lookup (self->_priv->widgetTable, id);
    }}
#line 911 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 586 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
PropertyContext * 
maker_dialog_get_propertyContext_by_key (MakerDialog * self, const gchar * key)
{
#line 918 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::get_propertyContext_by_key"
#line 586 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (PropertyContext * )0);
#line 586 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (PropertyContext * )0);
#line 924 "maker-dialog.c"
{
#line 586 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	int i=0;
	PropertyContext *ctx=NULL;
	for(i=0; i<self->_priv->propList->len;i++){
	    ctx=g_ptr_array_index(self->_priv->propList,i);
	    if (strcmp(ctx->spec->key,key)==0){
		break;
	    }
	}
	if (i>=self->_priv->propList->len){
	    /* Not found */
	    return NULL;
	}
	return ctx;
    }}
#line 942 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 603 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
GtkWidget * 
maker_dialog_get_base_vbox (MakerDialog * self, const gchar * notebook_page_label)
{
#line 949 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::get_base_vbox"
#line 603 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 603 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_val_if_fail (MAKER_IS_DIALOG (self), (GtkWidget * )0);
#line 955 "maker-dialog.c"
{
#line 603 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	gchar buf[STRING_BUFFER_SIZE_DEFAULT];
	GtkWidget *ret;
	if (notebook_page_label){
	    widget_get_id(buf, STRING_BUFFER_SIZE_DEFAULT, notebook_page_label, "vbox");
	    ret=self_get_widget(self, notebook_page_label, "vbox");
	}else{
	    ret=GTK_DIALOG(self)->vbox;
	}
	if (!ret){
	    ret=GTK_DIALOG(self)->vbox;
	}
	return ret;
    }}
#line 972 "maker-dialog.c"
#undef __GOB_FUNCTION__

#line 619 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
static void 
maker_dialog_widget_register (MakerDialog * self, GtkWidget * widget, const gchar * widget_label, const gchar * widget_type)
{
#line 979 "maker-dialog.c"
#define __GOB_FUNCTION__ "Maker:Dialog::widget_register"
#line 619 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (self != NULL);
#line 619 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	g_return_if_fail (MAKER_IS_DIALOG (self));
#line 985 "maker-dialog.c"
{
#line 620 "/home/dchen/ibus-chewing/src/MakerDialog.gob"
	
	gchar buf[STRING_BUFFER_SIZE_DEFAULT];
	widget_get_id(buf, STRING_BUFFER_SIZE_DEFAULT, widget_label, widget_type);
	gchar *chunk_ret=g_string_chunk_insert(self->_priv->widgetIds,buf);
	g_hash_table_insert(self->_priv->widgetTable, chunk_ret,widget);
	G_DEBUG_MSG(3,"*** widget_register(-,%s,%s) widget registered as %s",
		widget_label,(widget_type)? (widget_type) : "", chunk_ret);
    }}
#line 996 "maker-dialog.c"
#undef __GOB_FUNCTION__
