static const Pinyin pinyin_table[] = {
    {  /* 0 */
        text        : "a",
        sheng       : "",
        yun         : "a",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : 0
    },
    {  /* 1 */
        text        : "agn",
        sheng       : "",
        yun         : "ang",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 2 */
        text        : "ai",
        sheng       : "",
        yun         : "ai",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 3 */
        text        : "amg",
        sheng       : "",
        yun         : "ang",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 4 */
        text        : "an",
        sheng       : "",
        yun         : "an",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 5 */
        text        : "ang",
        sheng       : "",
        yun         : "ang",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 6 */
        text        : "ao",
        sheng       : "",
        yun         : "ao",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 7 */
        text        : "b",
        sheng       : "b",
        yun         : "",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 8 */
        text        : "ba",
        sheng       : "b",
        yun         : "a",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 9 */
        text        : "bagn",
        sheng       : "b",
        yun         : "ang",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 10 */
        text        : "bai",
        sheng       : "b",
        yun         : "ai",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 11 */
        text        : "bamg",
        sheng       : "b",
        yun         : "ang",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 12 */
        text        : "ban",
        sheng       : "b",
        yun         : "an",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 13 */
        text        : "bang",
        sheng       : "b",
        yun         : "ang",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 14 */
        text        : "bao",
        sheng       : "b",
        yun         : "ao",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 15 */
        text        : "begn",
        sheng       : "b",
        yun         : "eng",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 16 */
        text        : "bei",
        sheng       : "b",
        yun         : "ei",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 17 */
        text        : "bemg",
        sheng       : "b",
        yun         : "eng",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 18 */
        text        : "ben",
        sheng       : "b",
        yun         : "en",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 19 */
        text        : "beng",
        sheng       : "b",
        yun         : "eng",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 20 */
        text        : "bi",
        sheng       : "b",
        yun         : "i",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 21 */
        text        : "bian",
        sheng       : "b",
        yun         : "ian",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 22 */
        text        : "biang",
        sheng       : "b",
        yun         : "iang",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_IANG_IAN
    },
    {  /* 23 */
        text        : "biao",
        sheng       : "b",
        yun         : "iao",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 24 */
        text        : "bie",
        sheng       : "b",
        yun         : "ie",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 25 */
        text        : "bign",
        sheng       : "b",
        yun         : "ing",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 26 */
        text        : "bimg",
        sheng       : "b",
        yun         : "ing",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 27 */
        text        : "bin",
        sheng       : "b",
        yun         : "in",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 28 */
        text        : "bing",
        sheng       : "b",
        yun         : "ing",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 29 */
        text        : "bo",
        sheng       : "b",
        yun         : "o",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 30 */
        text        : "bu",
        sheng       : "b",
        yun         : "u",
        sheng_id    : PINYIN_ID_B,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 31 */
        text        : "c",
        sheng       : "c",
        yun         : "",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 32 */
        text        : "ca",
        sheng       : "c",
        yun         : "a",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 33 */
        text        : "cagn",
        sheng       : "c",
        yun         : "ang",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 34 */
        text        : "cai",
        sheng       : "c",
        yun         : "ai",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 35 */
        text        : "camg",
        sheng       : "c",
        yun         : "ang",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 36 */
        text        : "can",
        sheng       : "c",
        yun         : "an",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 37 */
        text        : "cang",
        sheng       : "c",
        yun         : "ang",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 38 */
        text        : "cao",
        sheng       : "c",
        yun         : "ao",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 39 */
        text        : "ce",
        sheng       : "c",
        yun         : "e",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 40 */
        text        : "cegn",
        sheng       : "c",
        yun         : "eng",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 41 */
        text        : "cemg",
        sheng       : "c",
        yun         : "eng",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 42 */
        text        : "cen",
        sheng       : "c",
        yun         : "en",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 43 */
        text        : "ceng",
        sheng       : "c",
        yun         : "eng",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 44 */
        text        : "ch",
        sheng       : "ch",
        yun         : "",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 45 */
        text        : "cha",
        sheng       : "ch",
        yun         : "a",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 46 */
        text        : "chagn",
        sheng       : "ch",
        yun         : "ang",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 47 */
        text        : "chai",
        sheng       : "ch",
        yun         : "ai",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 48 */
        text        : "chamg",
        sheng       : "ch",
        yun         : "ang",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 49 */
        text        : "chan",
        sheng       : "ch",
        yun         : "an",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 50 */
        text        : "chang",
        sheng       : "ch",
        yun         : "ang",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 51 */
        text        : "chao",
        sheng       : "ch",
        yun         : "ao",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 52 */
        text        : "che",
        sheng       : "ch",
        yun         : "e",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 53 */
        text        : "chegn",
        sheng       : "ch",
        yun         : "eng",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 54 */
        text        : "chemg",
        sheng       : "ch",
        yun         : "eng",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 55 */
        text        : "chen",
        sheng       : "ch",
        yun         : "en",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 56 */
        text        : "cheng",
        sheng       : "ch",
        yun         : "eng",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 57 */
        text        : "chi",
        sheng       : "ch",
        yun         : "i",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 58 */
        text        : "chogn",
        sheng       : "ch",
        yun         : "ong",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 59 */
        text        : "chomg",
        sheng       : "ch",
        yun         : "ong",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 60 */
        text        : "chong",
        sheng       : "ch",
        yun         : "ong",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 61 */
        text        : "chou",
        sheng       : "ch",
        yun         : "ou",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 62 */
        text        : "chu",
        sheng       : "ch",
        yun         : "u",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 63 */
        text        : "chuagn",
        sheng       : "ch",
        yun         : "uang",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 64 */
        text        : "chuai",
        sheng       : "ch",
        yun         : "uai",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 65 */
        text        : "chuamg",
        sheng       : "ch",
        yun         : "uang",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 66 */
        text        : "chuan",
        sheng       : "ch",
        yun         : "uan",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 67 */
        text        : "chuang",
        sheng       : "ch",
        yun         : "uang",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : 0
    },
    {  /* 68 */
        text        : "chuei",
        sheng       : "ch",
        yun         : "ui",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 69 */
        text        : "chuen",
        sheng       : "ch",
        yun         : "un",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 70 */
        text        : "chui",
        sheng       : "ch",
        yun         : "ui",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 71 */
        text        : "chun",
        sheng       : "ch",
        yun         : "un",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 72 */
        text        : "chuo",
        sheng       : "ch",
        yun         : "uo",
        sheng_id    : PINYIN_ID_CH,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_C,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 73 */
        text        : "ci",
        sheng       : "c",
        yun         : "i",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 74 */
        text        : "cogn",
        sheng       : "c",
        yun         : "ong",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 75 */
        text        : "comg",
        sheng       : "c",
        yun         : "ong",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 76 */
        text        : "cong",
        sheng       : "c",
        yun         : "ong",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 77 */
        text        : "cou",
        sheng       : "c",
        yun         : "ou",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 78 */
        text        : "cu",
        sheng       : "c",
        yun         : "u",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 79 */
        text        : "cuai",
        sheng       : "c",
        yun         : "uai",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_C_CH
    },
    {  /* 80 */
        text        : "cuan",
        sheng       : "c",
        yun         : "uan",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 81 */
        text        : "cuang",
        sheng       : "c",
        yun         : "uang",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_C_CH | PINYIN_FUZZY_UANG_UAN
    },
    {  /* 82 */
        text        : "cuei",
        sheng       : "c",
        yun         : "ui",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 83 */
        text        : "cuen",
        sheng       : "c",
        yun         : "un",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 84 */
        text        : "cui",
        sheng       : "c",
        yun         : "ui",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 85 */
        text        : "cun",
        sheng       : "c",
        yun         : "un",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 86 */
        text        : "cuo",
        sheng       : "c",
        yun         : "uo",
        sheng_id    : PINYIN_ID_C,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_CH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 87 */
        text        : "d",
        sheng       : "d",
        yun         : "",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 88 */
        text        : "da",
        sheng       : "d",
        yun         : "a",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 89 */
        text        : "dagn",
        sheng       : "d",
        yun         : "ang",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 90 */
        text        : "dai",
        sheng       : "d",
        yun         : "ai",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 91 */
        text        : "damg",
        sheng       : "d",
        yun         : "ang",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 92 */
        text        : "dan",
        sheng       : "d",
        yun         : "an",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 93 */
        text        : "dang",
        sheng       : "d",
        yun         : "ang",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 94 */
        text        : "dao",
        sheng       : "d",
        yun         : "ao",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 95 */
        text        : "de",
        sheng       : "d",
        yun         : "e",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 96 */
        text        : "degn",
        sheng       : "d",
        yun         : "eng",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 97 */
        text        : "dei",
        sheng       : "d",
        yun         : "ei",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 98 */
        text        : "demg",
        sheng       : "d",
        yun         : "eng",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 99 */
        text        : "den",
        sheng       : "d",
        yun         : "en",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_EN_ENG
    },
    {  /* 100 */
        text        : "deng",
        sheng       : "d",
        yun         : "eng",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 101 */
        text        : "di",
        sheng       : "d",
        yun         : "i",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 102 */
        text        : "dia",
        sheng       : "d",
        yun         : "ia",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IA,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 103 */
        text        : "dian",
        sheng       : "d",
        yun         : "ian",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 104 */
        text        : "diang",
        sheng       : "d",
        yun         : "iang",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_IANG_IAN
    },
    {  /* 105 */
        text        : "diao",
        sheng       : "d",
        yun         : "iao",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 106 */
        text        : "die",
        sheng       : "d",
        yun         : "ie",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 107 */
        text        : "dign",
        sheng       : "d",
        yun         : "ing",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 108 */
        text        : "dimg",
        sheng       : "d",
        yun         : "ing",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 109 */
        text        : "din",
        sheng       : "d",
        yun         : "in",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_IN_ING
    },
    {  /* 110 */
        text        : "ding",
        sheng       : "d",
        yun         : "ing",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 111 */
        text        : "diou",
        sheng       : "d",
        yun         : "iu",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_IOU_TO_IU
    },
    {  /* 112 */
        text        : "diu",
        sheng       : "d",
        yun         : "iu",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 113 */
        text        : "dogn",
        sheng       : "d",
        yun         : "ong",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 114 */
        text        : "domg",
        sheng       : "d",
        yun         : "ong",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 115 */
        text        : "dong",
        sheng       : "d",
        yun         : "ong",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 116 */
        text        : "dou",
        sheng       : "d",
        yun         : "ou",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 117 */
        text        : "du",
        sheng       : "d",
        yun         : "u",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 118 */
        text        : "duan",
        sheng       : "d",
        yun         : "uan",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 119 */
        text        : "duang",
        sheng       : "d",
        yun         : "uang",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 120 */
        text        : "duei",
        sheng       : "d",
        yun         : "ui",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 121 */
        text        : "duen",
        sheng       : "d",
        yun         : "un",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 122 */
        text        : "dui",
        sheng       : "d",
        yun         : "ui",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 123 */
        text        : "dun",
        sheng       : "d",
        yun         : "un",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 124 */
        text        : "duo",
        sheng       : "d",
        yun         : "uo",
        sheng_id    : PINYIN_ID_D,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 125 */
        text        : "e",
        sheng       : "",
        yun         : "e",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : 0
    },
    {  /* 126 */
        text        : "ei",
        sheng       : "",
        yun         : "ei",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 127 */
        text        : "en",
        sheng       : "",
        yun         : "en",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 128 */
        text        : "er",
        sheng       : "",
        yun         : "er",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_ER,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 129 */
        text        : "f",
        sheng       : "f",
        yun         : "",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 130 */
        text        : "fa",
        sheng       : "f",
        yun         : "a",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 131 */
        text        : "fagn",
        sheng       : "f",
        yun         : "ang",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 132 */
        text        : "fai",
        sheng       : "f",
        yun         : "ai",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 133 */
        text        : "famg",
        sheng       : "f",
        yun         : "ang",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 134 */
        text        : "fan",
        sheng       : "f",
        yun         : "an",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 135 */
        text        : "fang",
        sheng       : "f",
        yun         : "ang",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 136 */
        text        : "fao",
        sheng       : "f",
        yun         : "ao",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 137 */
        text        : "fe",
        sheng       : "f",
        yun         : "e",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 138 */
        text        : "fegn",
        sheng       : "f",
        yun         : "eng",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 139 */
        text        : "fei",
        sheng       : "f",
        yun         : "ei",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 140 */
        text        : "femg",
        sheng       : "f",
        yun         : "eng",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 141 */
        text        : "fen",
        sheng       : "f",
        yun         : "en",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 142 */
        text        : "feng",
        sheng       : "f",
        yun         : "eng",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 143 */
        text        : "fo",
        sheng       : "f",
        yun         : "o",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 144 */
        text        : "fong",
        sheng       : "f",
        yun         : "ong",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 145 */
        text        : "fou",
        sheng       : "f",
        yun         : "ou",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 146 */
        text        : "fu",
        sheng       : "f",
        yun         : "u",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 147 */
        text        : "fua",
        sheng       : "f",
        yun         : "ua",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 148 */
        text        : "fuai",
        sheng       : "f",
        yun         : "uai",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 149 */
        text        : "fuan",
        sheng       : "f",
        yun         : "uan",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 150 */
        text        : "fuang",
        sheng       : "f",
        yun         : "uang",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 151 */
        text        : "fui",
        sheng       : "f",
        yun         : "ui",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 152 */
        text        : "fun",
        sheng       : "f",
        yun         : "un",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 153 */
        text        : "fuo",
        sheng       : "f",
        yun         : "uo",
        sheng_id    : PINYIN_ID_F,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_H,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_F_H
    },
    {  /* 154 */
        text        : "g",
        sheng       : "g",
        yun         : "",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 155 */
        text        : "ga",
        sheng       : "g",
        yun         : "a",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 156 */
        text        : "gagn",
        sheng       : "g",
        yun         : "ang",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 157 */
        text        : "gai",
        sheng       : "g",
        yun         : "ai",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 158 */
        text        : "gamg",
        sheng       : "g",
        yun         : "ang",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 159 */
        text        : "gan",
        sheng       : "g",
        yun         : "an",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 160 */
        text        : "gang",
        sheng       : "g",
        yun         : "ang",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 161 */
        text        : "gao",
        sheng       : "g",
        yun         : "ao",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 162 */
        text        : "ge",
        sheng       : "g",
        yun         : "e",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 163 */
        text        : "gegn",
        sheng       : "g",
        yun         : "eng",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 164 */
        text        : "gei",
        sheng       : "g",
        yun         : "ei",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 165 */
        text        : "gemg",
        sheng       : "g",
        yun         : "eng",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 166 */
        text        : "gen",
        sheng       : "g",
        yun         : "en",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 167 */
        text        : "geng",
        sheng       : "g",
        yun         : "eng",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 168 */
        text        : "gogn",
        sheng       : "g",
        yun         : "ong",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 169 */
        text        : "gomg",
        sheng       : "g",
        yun         : "ong",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 170 */
        text        : "gong",
        sheng       : "g",
        yun         : "ong",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 171 */
        text        : "gou",
        sheng       : "g",
        yun         : "ou",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 172 */
        text        : "gu",
        sheng       : "g",
        yun         : "u",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 173 */
        text        : "gua",
        sheng       : "g",
        yun         : "ua",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 174 */
        text        : "guagn",
        sheng       : "g",
        yun         : "uang",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 175 */
        text        : "guai",
        sheng       : "g",
        yun         : "uai",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 176 */
        text        : "guamg",
        sheng       : "g",
        yun         : "uang",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 177 */
        text        : "guan",
        sheng       : "g",
        yun         : "uan",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 178 */
        text        : "guang",
        sheng       : "g",
        yun         : "uang",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 179 */
        text        : "guei",
        sheng       : "g",
        yun         : "ui",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 180 */
        text        : "guen",
        sheng       : "g",
        yun         : "un",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 181 */
        text        : "gui",
        sheng       : "g",
        yun         : "ui",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 182 */
        text        : "gun",
        sheng       : "g",
        yun         : "un",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 183 */
        text        : "guo",
        sheng       : "g",
        yun         : "uo",
        sheng_id    : PINYIN_ID_G,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_K,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 184 */
        text        : "h",
        sheng       : "h",
        yun         : "",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 185 */
        text        : "ha",
        sheng       : "h",
        yun         : "a",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 186 */
        text        : "hagn",
        sheng       : "h",
        yun         : "ang",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 187 */
        text        : "hai",
        sheng       : "h",
        yun         : "ai",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 188 */
        text        : "hamg",
        sheng       : "h",
        yun         : "ang",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 189 */
        text        : "han",
        sheng       : "h",
        yun         : "an",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 190 */
        text        : "hang",
        sheng       : "h",
        yun         : "ang",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 191 */
        text        : "hao",
        sheng       : "h",
        yun         : "ao",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 192 */
        text        : "he",
        sheng       : "h",
        yun         : "e",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 193 */
        text        : "hegn",
        sheng       : "h",
        yun         : "eng",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 194 */
        text        : "hei",
        sheng       : "h",
        yun         : "ei",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 195 */
        text        : "hemg",
        sheng       : "h",
        yun         : "eng",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 196 */
        text        : "hen",
        sheng       : "h",
        yun         : "en",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 197 */
        text        : "heng",
        sheng       : "h",
        yun         : "eng",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 198 */
        text        : "ho",
        sheng       : "h",
        yun         : "o",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_FUZZY_H_F
    },
    {  /* 199 */
        text        : "hogn",
        sheng       : "h",
        yun         : "ong",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 200 */
        text        : "homg",
        sheng       : "h",
        yun         : "ong",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 201 */
        text        : "hong",
        sheng       : "h",
        yun         : "ong",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 202 */
        text        : "hou",
        sheng       : "h",
        yun         : "ou",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 203 */
        text        : "hu",
        sheng       : "h",
        yun         : "u",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 204 */
        text        : "hua",
        sheng       : "h",
        yun         : "ua",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 205 */
        text        : "huagn",
        sheng       : "h",
        yun         : "uang",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 206 */
        text        : "huai",
        sheng       : "h",
        yun         : "uai",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 207 */
        text        : "huamg",
        sheng       : "h",
        yun         : "uang",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 208 */
        text        : "huan",
        sheng       : "h",
        yun         : "uan",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 209 */
        text        : "huang",
        sheng       : "h",
        yun         : "uang",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 210 */
        text        : "huei",
        sheng       : "h",
        yun         : "ui",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 211 */
        text        : "huen",
        sheng       : "h",
        yun         : "un",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 212 */
        text        : "hui",
        sheng       : "h",
        yun         : "ui",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 213 */
        text        : "hun",
        sheng       : "h",
        yun         : "un",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 214 */
        text        : "huo",
        sheng       : "h",
        yun         : "uo",
        sheng_id    : PINYIN_ID_H,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_F,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 215 */
        text        : "j",
        sheng       : "j",
        yun         : "",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 216 */
        text        : "ji",
        sheng       : "j",
        yun         : "i",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 217 */
        text        : "jia",
        sheng       : "j",
        yun         : "ia",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IA,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 218 */
        text        : "jiagn",
        sheng       : "j",
        yun         : "iang",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 219 */
        text        : "jiamg",
        sheng       : "j",
        yun         : "iang",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 220 */
        text        : "jian",
        sheng       : "j",
        yun         : "ian",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 221 */
        text        : "jiang",
        sheng       : "j",
        yun         : "iang",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 222 */
        text        : "jiao",
        sheng       : "j",
        yun         : "iao",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 223 */
        text        : "jie",
        sheng       : "j",
        yun         : "ie",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 224 */
        text        : "jign",
        sheng       : "j",
        yun         : "ing",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 225 */
        text        : "jimg",
        sheng       : "j",
        yun         : "ing",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 226 */
        text        : "jin",
        sheng       : "j",
        yun         : "in",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 227 */
        text        : "jing",
        sheng       : "j",
        yun         : "ing",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 228 */
        text        : "jiogn",
        sheng       : "j",
        yun         : "iong",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 229 */
        text        : "jiomg",
        sheng       : "j",
        yun         : "iong",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 230 */
        text        : "jiong",
        sheng       : "j",
        yun         : "iong",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 231 */
        text        : "jiou",
        sheng       : "j",
        yun         : "iu",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_IOU_TO_IU
    },
    {  /* 232 */
        text        : "jiu",
        sheng       : "j",
        yun         : "iu",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 233 */
        text        : "ju",
        sheng       : "j",
        yun         : "u",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 234 */
        text        : "juan",
        sheng       : "j",
        yun         : "uan",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 235 */
        text        : "juang",
        sheng       : "j",
        yun         : "uang",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 236 */
        text        : "jue",
        sheng       : "j",
        yun         : "ue",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 237 */
        text        : "juen",
        sheng       : "j",
        yun         : "un",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 238 */
        text        : "jun",
        sheng       : "j",
        yun         : "un",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 239 */
        text        : "jve",
        sheng       : "j",
        yun         : "ue",
        sheng_id    : PINYIN_ID_J,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_VE_TO_UE
    },
    {  /* 240 */
        text        : "k",
        sheng       : "k",
        yun         : "",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 241 */
        text        : "ka",
        sheng       : "k",
        yun         : "a",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 242 */
        text        : "kagn",
        sheng       : "k",
        yun         : "ang",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 243 */
        text        : "kai",
        sheng       : "k",
        yun         : "ai",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 244 */
        text        : "kamg",
        sheng       : "k",
        yun         : "ang",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 245 */
        text        : "kan",
        sheng       : "k",
        yun         : "an",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 246 */
        text        : "kang",
        sheng       : "k",
        yun         : "ang",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 247 */
        text        : "kao",
        sheng       : "k",
        yun         : "ao",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 248 */
        text        : "ke",
        sheng       : "k",
        yun         : "e",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 249 */
        text        : "kegn",
        sheng       : "k",
        yun         : "eng",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 250 */
        text        : "kei",
        sheng       : "k",
        yun         : "ei",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_K_G
    },
    {  /* 251 */
        text        : "kemg",
        sheng       : "k",
        yun         : "eng",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 252 */
        text        : "ken",
        sheng       : "k",
        yun         : "en",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 253 */
        text        : "keng",
        sheng       : "k",
        yun         : "eng",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 254 */
        text        : "kogn",
        sheng       : "k",
        yun         : "ong",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 255 */
        text        : "komg",
        sheng       : "k",
        yun         : "ong",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 256 */
        text        : "kong",
        sheng       : "k",
        yun         : "ong",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 257 */
        text        : "kou",
        sheng       : "k",
        yun         : "ou",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 258 */
        text        : "ku",
        sheng       : "k",
        yun         : "u",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 259 */
        text        : "kua",
        sheng       : "k",
        yun         : "ua",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 260 */
        text        : "kuagn",
        sheng       : "k",
        yun         : "uang",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 261 */
        text        : "kuai",
        sheng       : "k",
        yun         : "uai",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 262 */
        text        : "kuamg",
        sheng       : "k",
        yun         : "uang",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 263 */
        text        : "kuan",
        sheng       : "k",
        yun         : "uan",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 264 */
        text        : "kuang",
        sheng       : "k",
        yun         : "uang",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 265 */
        text        : "kuei",
        sheng       : "k",
        yun         : "ui",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 266 */
        text        : "kuen",
        sheng       : "k",
        yun         : "un",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 267 */
        text        : "kui",
        sheng       : "k",
        yun         : "ui",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 268 */
        text        : "kun",
        sheng       : "k",
        yun         : "un",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 269 */
        text        : "kuo",
        sheng       : "k",
        yun         : "uo",
        sheng_id    : PINYIN_ID_K,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_G,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 270 */
        text        : "l",
        sheng       : "l",
        yun         : "",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 271 */
        text        : "la",
        sheng       : "l",
        yun         : "a",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 272 */
        text        : "lagn",
        sheng       : "l",
        yun         : "ang",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 273 */
        text        : "lai",
        sheng       : "l",
        yun         : "ai",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 274 */
        text        : "lamg",
        sheng       : "l",
        yun         : "ang",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 275 */
        text        : "lan",
        sheng       : "l",
        yun         : "an",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 276 */
        text        : "lang",
        sheng       : "l",
        yun         : "ang",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 277 */
        text        : "lao",
        sheng       : "l",
        yun         : "ao",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 278 */
        text        : "le",
        sheng       : "l",
        yun         : "e",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 279 */
        text        : "legn",
        sheng       : "l",
        yun         : "eng",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 280 */
        text        : "lei",
        sheng       : "l",
        yun         : "ei",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 281 */
        text        : "lemg",
        sheng       : "l",
        yun         : "eng",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 282 */
        text        : "len",
        sheng       : "l",
        yun         : "en",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_L_N | PINYIN_FUZZY_L_R | PINYIN_FUZZY_EN_ENG
    },
    {  /* 283 */
        text        : "leng",
        sheng       : "l",
        yun         : "eng",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 284 */
        text        : "li",
        sheng       : "l",
        yun         : "i",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 285 */
        text        : "lia",
        sheng       : "l",
        yun         : "ia",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IA,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 286 */
        text        : "liagn",
        sheng       : "l",
        yun         : "iang",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 287 */
        text        : "liamg",
        sheng       : "l",
        yun         : "iang",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 288 */
        text        : "lian",
        sheng       : "l",
        yun         : "ian",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 289 */
        text        : "liang",
        sheng       : "l",
        yun         : "iang",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 290 */
        text        : "liao",
        sheng       : "l",
        yun         : "iao",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 291 */
        text        : "lie",
        sheng       : "l",
        yun         : "ie",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 292 */
        text        : "lign",
        sheng       : "l",
        yun         : "ing",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 293 */
        text        : "limg",
        sheng       : "l",
        yun         : "ing",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 294 */
        text        : "lin",
        sheng       : "l",
        yun         : "in",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 295 */
        text        : "ling",
        sheng       : "l",
        yun         : "ing",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 296 */
        text        : "liou",
        sheng       : "l",
        yun         : "iu",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_IOU_TO_IU
    },
    {  /* 297 */
        text        : "liu",
        sheng       : "l",
        yun         : "iu",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 298 */
        text        : "lo",
        sheng       : "l",
        yun         : "o",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 299 */
        text        : "logn",
        sheng       : "l",
        yun         : "ong",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 300 */
        text        : "lomg",
        sheng       : "l",
        yun         : "ong",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 301 */
        text        : "long",
        sheng       : "l",
        yun         : "ong",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 302 */
        text        : "lou",
        sheng       : "l",
        yun         : "ou",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 303 */
        text        : "lu",
        sheng       : "l",
        yun         : "u",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 304 */
        text        : "luan",
        sheng       : "l",
        yun         : "uan",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 305 */
        text        : "luang",
        sheng       : "l",
        yun         : "uang",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 306 */
        text        : "lue",
        sheng       : "l",
        yun         : "ue",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 307 */
        text        : "luen",
        sheng       : "l",
        yun         : "un",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 308 */
        text        : "lui",
        sheng       : "l",
        yun         : "ui",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_L_R
    },
    {  /* 309 */
        text        : "lun",
        sheng       : "l",
        yun         : "un",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 310 */
        text        : "luo",
        sheng       : "l",
        yun         : "uo",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 311 */
        text        : "lv",
        sheng       : "l",
        yun         : "v",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_V,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 312 */
        text        : "lve",
        sheng       : "l",
        yun         : "ue",
        sheng_id    : PINYIN_ID_L,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_N,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_R,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_VE_TO_UE
    },
    {  /* 313 */
        text        : "m",
        sheng       : "m",
        yun         : "",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 314 */
        text        : "ma",
        sheng       : "m",
        yun         : "a",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 315 */
        text        : "magn",
        sheng       : "m",
        yun         : "ang",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 316 */
        text        : "mai",
        sheng       : "m",
        yun         : "ai",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 317 */
        text        : "mamg",
        sheng       : "m",
        yun         : "ang",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 318 */
        text        : "man",
        sheng       : "m",
        yun         : "an",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 319 */
        text        : "mang",
        sheng       : "m",
        yun         : "ang",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 320 */
        text        : "mao",
        sheng       : "m",
        yun         : "ao",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 321 */
        text        : "me",
        sheng       : "m",
        yun         : "e",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 322 */
        text        : "megn",
        sheng       : "m",
        yun         : "eng",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 323 */
        text        : "mei",
        sheng       : "m",
        yun         : "ei",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 324 */
        text        : "memg",
        sheng       : "m",
        yun         : "eng",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 325 */
        text        : "men",
        sheng       : "m",
        yun         : "en",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 326 */
        text        : "meng",
        sheng       : "m",
        yun         : "eng",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 327 */
        text        : "mi",
        sheng       : "m",
        yun         : "i",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 328 */
        text        : "mian",
        sheng       : "m",
        yun         : "ian",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 329 */
        text        : "miang",
        sheng       : "m",
        yun         : "iang",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_IANG_IAN
    },
    {  /* 330 */
        text        : "miao",
        sheng       : "m",
        yun         : "iao",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 331 */
        text        : "mie",
        sheng       : "m",
        yun         : "ie",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 332 */
        text        : "mign",
        sheng       : "m",
        yun         : "ing",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 333 */
        text        : "mimg",
        sheng       : "m",
        yun         : "ing",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 334 */
        text        : "min",
        sheng       : "m",
        yun         : "in",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 335 */
        text        : "ming",
        sheng       : "m",
        yun         : "ing",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 336 */
        text        : "miou",
        sheng       : "m",
        yun         : "iu",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_IOU_TO_IU
    },
    {  /* 337 */
        text        : "miu",
        sheng       : "m",
        yun         : "iu",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 338 */
        text        : "mo",
        sheng       : "m",
        yun         : "o",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 339 */
        text        : "mou",
        sheng       : "m",
        yun         : "ou",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 340 */
        text        : "mu",
        sheng       : "m",
        yun         : "u",
        sheng_id    : PINYIN_ID_M,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 341 */
        text        : "n",
        sheng       : "n",
        yun         : "",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 342 */
        text        : "na",
        sheng       : "n",
        yun         : "a",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 343 */
        text        : "nagn",
        sheng       : "n",
        yun         : "ang",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 344 */
        text        : "nai",
        sheng       : "n",
        yun         : "ai",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 345 */
        text        : "namg",
        sheng       : "n",
        yun         : "ang",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 346 */
        text        : "nan",
        sheng       : "n",
        yun         : "an",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 347 */
        text        : "nang",
        sheng       : "n",
        yun         : "ang",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 348 */
        text        : "nao",
        sheng       : "n",
        yun         : "ao",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 349 */
        text        : "ne",
        sheng       : "n",
        yun         : "e",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 350 */
        text        : "negn",
        sheng       : "n",
        yun         : "eng",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 351 */
        text        : "nei",
        sheng       : "n",
        yun         : "ei",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 352 */
        text        : "nemg",
        sheng       : "n",
        yun         : "eng",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 353 */
        text        : "nen",
        sheng       : "n",
        yun         : "en",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 354 */
        text        : "neng",
        sheng       : "n",
        yun         : "eng",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 355 */
        text        : "ni",
        sheng       : "n",
        yun         : "i",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 356 */
        text        : "nia",
        sheng       : "n",
        yun         : "ia",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IA,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_N_L
    },
    {  /* 357 */
        text        : "niagn",
        sheng       : "n",
        yun         : "iang",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 358 */
        text        : "niamg",
        sheng       : "n",
        yun         : "iang",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 359 */
        text        : "nian",
        sheng       : "n",
        yun         : "ian",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 360 */
        text        : "niang",
        sheng       : "n",
        yun         : "iang",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 361 */
        text        : "niao",
        sheng       : "n",
        yun         : "iao",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 362 */
        text        : "nie",
        sheng       : "n",
        yun         : "ie",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 363 */
        text        : "nign",
        sheng       : "n",
        yun         : "ing",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 364 */
        text        : "nimg",
        sheng       : "n",
        yun         : "ing",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 365 */
        text        : "nin",
        sheng       : "n",
        yun         : "in",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 366 */
        text        : "ning",
        sheng       : "n",
        yun         : "ing",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 367 */
        text        : "niou",
        sheng       : "n",
        yun         : "iu",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_IOU_TO_IU
    },
    {  /* 368 */
        text        : "niu",
        sheng       : "n",
        yun         : "iu",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 369 */
        text        : "no",
        sheng       : "n",
        yun         : "o",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_FUZZY_N_L
    },
    {  /* 370 */
        text        : "nogn",
        sheng       : "n",
        yun         : "ong",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 371 */
        text        : "nomg",
        sheng       : "n",
        yun         : "ong",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 372 */
        text        : "nong",
        sheng       : "n",
        yun         : "ong",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 373 */
        text        : "nou",
        sheng       : "n",
        yun         : "ou",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 374 */
        text        : "nu",
        sheng       : "n",
        yun         : "u",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 375 */
        text        : "nuan",
        sheng       : "n",
        yun         : "uan",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 376 */
        text        : "nuang",
        sheng       : "n",
        yun         : "uang",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 377 */
        text        : "nue",
        sheng       : "n",
        yun         : "ue",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 378 */
        text        : "nun",
        sheng       : "n",
        yun         : "un",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_N_L
    },
    {  /* 379 */
        text        : "nuo",
        sheng       : "n",
        yun         : "uo",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 380 */
        text        : "nv",
        sheng       : "n",
        yun         : "v",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_V,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 381 */
        text        : "nve",
        sheng       : "n",
        yun         : "ue",
        sheng_id    : PINYIN_ID_N,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_VE_TO_UE
    },
    {  /* 382 */
        text        : "o",
        sheng       : "",
        yun         : "o",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : 0
    },
    {  /* 383 */
        text        : "ou",
        sheng       : "",
        yun         : "ou",
        sheng_id    : PINYIN_ID_ZERO,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 384 */
        text        : "p",
        sheng       : "p",
        yun         : "",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 385 */
        text        : "pa",
        sheng       : "p",
        yun         : "a",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 386 */
        text        : "pagn",
        sheng       : "p",
        yun         : "ang",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 387 */
        text        : "pai",
        sheng       : "p",
        yun         : "ai",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 388 */
        text        : "pamg",
        sheng       : "p",
        yun         : "ang",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 389 */
        text        : "pan",
        sheng       : "p",
        yun         : "an",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 390 */
        text        : "pang",
        sheng       : "p",
        yun         : "ang",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 391 */
        text        : "pao",
        sheng       : "p",
        yun         : "ao",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 392 */
        text        : "pegn",
        sheng       : "p",
        yun         : "eng",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 393 */
        text        : "pei",
        sheng       : "p",
        yun         : "ei",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 394 */
        text        : "pemg",
        sheng       : "p",
        yun         : "eng",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 395 */
        text        : "pen",
        sheng       : "p",
        yun         : "en",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 396 */
        text        : "peng",
        sheng       : "p",
        yun         : "eng",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 397 */
        text        : "pi",
        sheng       : "p",
        yun         : "i",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 398 */
        text        : "pian",
        sheng       : "p",
        yun         : "ian",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 399 */
        text        : "piang",
        sheng       : "p",
        yun         : "iang",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_IANG_IAN
    },
    {  /* 400 */
        text        : "piao",
        sheng       : "p",
        yun         : "iao",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 401 */
        text        : "pie",
        sheng       : "p",
        yun         : "ie",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 402 */
        text        : "pign",
        sheng       : "p",
        yun         : "ing",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 403 */
        text        : "pimg",
        sheng       : "p",
        yun         : "ing",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 404 */
        text        : "pin",
        sheng       : "p",
        yun         : "in",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 405 */
        text        : "ping",
        sheng       : "p",
        yun         : "ing",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 406 */
        text        : "po",
        sheng       : "p",
        yun         : "o",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 407 */
        text        : "pou",
        sheng       : "p",
        yun         : "ou",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 408 */
        text        : "pu",
        sheng       : "p",
        yun         : "u",
        sheng_id    : PINYIN_ID_P,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 409 */
        text        : "q",
        sheng       : "q",
        yun         : "",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 410 */
        text        : "qi",
        sheng       : "q",
        yun         : "i",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 411 */
        text        : "qia",
        sheng       : "q",
        yun         : "ia",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IA,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 412 */
        text        : "qiagn",
        sheng       : "q",
        yun         : "iang",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 413 */
        text        : "qiamg",
        sheng       : "q",
        yun         : "iang",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 414 */
        text        : "qian",
        sheng       : "q",
        yun         : "ian",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 415 */
        text        : "qiang",
        sheng       : "q",
        yun         : "iang",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 416 */
        text        : "qiao",
        sheng       : "q",
        yun         : "iao",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 417 */
        text        : "qie",
        sheng       : "q",
        yun         : "ie",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 418 */
        text        : "qign",
        sheng       : "q",
        yun         : "ing",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 419 */
        text        : "qimg",
        sheng       : "q",
        yun         : "ing",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 420 */
        text        : "qin",
        sheng       : "q",
        yun         : "in",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 421 */
        text        : "qing",
        sheng       : "q",
        yun         : "ing",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 422 */
        text        : "qiogn",
        sheng       : "q",
        yun         : "iong",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 423 */
        text        : "qiomg",
        sheng       : "q",
        yun         : "iong",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 424 */
        text        : "qiong",
        sheng       : "q",
        yun         : "iong",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 425 */
        text        : "qiou",
        sheng       : "q",
        yun         : "iu",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_IOU_TO_IU
    },
    {  /* 426 */
        text        : "qiu",
        sheng       : "q",
        yun         : "iu",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 427 */
        text        : "qu",
        sheng       : "q",
        yun         : "u",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 428 */
        text        : "quan",
        sheng       : "q",
        yun         : "uan",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 429 */
        text        : "quang",
        sheng       : "q",
        yun         : "uang",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 430 */
        text        : "que",
        sheng       : "q",
        yun         : "ue",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 431 */
        text        : "quen",
        sheng       : "q",
        yun         : "un",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 432 */
        text        : "qun",
        sheng       : "q",
        yun         : "un",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 433 */
        text        : "qve",
        sheng       : "q",
        yun         : "ue",
        sheng_id    : PINYIN_ID_Q,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_VE_TO_UE
    },
    {  /* 434 */
        text        : "r",
        sheng       : "r",
        yun         : "",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 435 */
        text        : "ra",
        sheng       : "r",
        yun         : "a",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 436 */
        text        : "ragn",
        sheng       : "r",
        yun         : "ang",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 437 */
        text        : "rai",
        sheng       : "r",
        yun         : "ai",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 438 */
        text        : "ramg",
        sheng       : "r",
        yun         : "ang",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 439 */
        text        : "ran",
        sheng       : "r",
        yun         : "an",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 440 */
        text        : "rang",
        sheng       : "r",
        yun         : "ang",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 441 */
        text        : "rao",
        sheng       : "r",
        yun         : "ao",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 442 */
        text        : "re",
        sheng       : "r",
        yun         : "e",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 443 */
        text        : "regn",
        sheng       : "r",
        yun         : "eng",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 444 */
        text        : "rei",
        sheng       : "r",
        yun         : "ei",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 445 */
        text        : "remg",
        sheng       : "r",
        yun         : "eng",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 446 */
        text        : "ren",
        sheng       : "r",
        yun         : "en",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 447 */
        text        : "reng",
        sheng       : "r",
        yun         : "eng",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 448 */
        text        : "ri",
        sheng       : "r",
        yun         : "i",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 449 */
        text        : "ria",
        sheng       : "r",
        yun         : "ia",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_IA,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 450 */
        text        : "rian",
        sheng       : "r",
        yun         : "ian",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 451 */
        text        : "riang",
        sheng       : "r",
        yun         : "iang",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 452 */
        text        : "riao",
        sheng       : "r",
        yun         : "iao",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 453 */
        text        : "rie",
        sheng       : "r",
        yun         : "ie",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 454 */
        text        : "rin",
        sheng       : "r",
        yun         : "in",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 455 */
        text        : "ring",
        sheng       : "r",
        yun         : "ing",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 456 */
        text        : "riu",
        sheng       : "r",
        yun         : "iu",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 457 */
        text        : "ro",
        sheng       : "r",
        yun         : "o",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 458 */
        text        : "rogn",
        sheng       : "r",
        yun         : "ong",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 459 */
        text        : "romg",
        sheng       : "r",
        yun         : "ong",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 460 */
        text        : "rong",
        sheng       : "r",
        yun         : "ong",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 461 */
        text        : "rou",
        sheng       : "r",
        yun         : "ou",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 462 */
        text        : "ru",
        sheng       : "r",
        yun         : "u",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 463 */
        text        : "ruan",
        sheng       : "r",
        yun         : "uan",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 464 */
        text        : "ruang",
        sheng       : "r",
        yun         : "uang",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 465 */
        text        : "rue",
        sheng       : "r",
        yun         : "ue",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 466 */
        text        : "ruei",
        sheng       : "r",
        yun         : "ui",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 467 */
        text        : "ruen",
        sheng       : "r",
        yun         : "un",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 468 */
        text        : "rui",
        sheng       : "r",
        yun         : "ui",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 469 */
        text        : "run",
        sheng       : "r",
        yun         : "un",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 470 */
        text        : "ruo",
        sheng       : "r",
        yun         : "uo",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 471 */
        text        : "rv",
        sheng       : "r",
        yun         : "v",
        sheng_id    : PINYIN_ID_R,
        yun_id      : PINYIN_ID_V,
        fsheng_id   : PINYIN_ID_L,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_FUZZY_R_L
    },
    {  /* 472 */
        text        : "s",
        sheng       : "s",
        yun         : "",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 473 */
        text        : "sa",
        sheng       : "s",
        yun         : "a",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 474 */
        text        : "sagn",
        sheng       : "s",
        yun         : "ang",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 475 */
        text        : "sai",
        sheng       : "s",
        yun         : "ai",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 476 */
        text        : "samg",
        sheng       : "s",
        yun         : "ang",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 477 */
        text        : "san",
        sheng       : "s",
        yun         : "an",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 478 */
        text        : "sang",
        sheng       : "s",
        yun         : "ang",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 479 */
        text        : "sao",
        sheng       : "s",
        yun         : "ao",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 480 */
        text        : "se",
        sheng       : "s",
        yun         : "e",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 481 */
        text        : "segn",
        sheng       : "s",
        yun         : "eng",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 482 */
        text        : "sei",
        sheng       : "s",
        yun         : "ei",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_S_SH
    },
    {  /* 483 */
        text        : "semg",
        sheng       : "s",
        yun         : "eng",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 484 */
        text        : "sen",
        sheng       : "s",
        yun         : "en",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 485 */
        text        : "seng",
        sheng       : "s",
        yun         : "eng",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 486 */
        text        : "sh",
        sheng       : "sh",
        yun         : "",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 487 */
        text        : "sha",
        sheng       : "sh",
        yun         : "a",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 488 */
        text        : "shagn",
        sheng       : "sh",
        yun         : "ang",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 489 */
        text        : "shai",
        sheng       : "sh",
        yun         : "ai",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 490 */
        text        : "shamg",
        sheng       : "sh",
        yun         : "ang",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 491 */
        text        : "shan",
        sheng       : "sh",
        yun         : "an",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 492 */
        text        : "shang",
        sheng       : "sh",
        yun         : "ang",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 493 */
        text        : "shao",
        sheng       : "sh",
        yun         : "ao",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 494 */
        text        : "she",
        sheng       : "sh",
        yun         : "e",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 495 */
        text        : "shegn",
        sheng       : "sh",
        yun         : "eng",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 496 */
        text        : "shei",
        sheng       : "sh",
        yun         : "ei",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 497 */
        text        : "shemg",
        sheng       : "sh",
        yun         : "eng",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 498 */
        text        : "shen",
        sheng       : "sh",
        yun         : "en",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 499 */
        text        : "sheng",
        sheng       : "sh",
        yun         : "eng",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 500 */
        text        : "shi",
        sheng       : "sh",
        yun         : "i",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 501 */
        text        : "shong",
        sheng       : "sh",
        yun         : "ong",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_SH_S
    },
    {  /* 502 */
        text        : "shou",
        sheng       : "sh",
        yun         : "ou",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 503 */
        text        : "shu",
        sheng       : "sh",
        yun         : "u",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 504 */
        text        : "shua",
        sheng       : "sh",
        yun         : "ua",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 505 */
        text        : "shuagn",
        sheng       : "sh",
        yun         : "uang",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 506 */
        text        : "shuai",
        sheng       : "sh",
        yun         : "uai",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 507 */
        text        : "shuamg",
        sheng       : "sh",
        yun         : "uang",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 508 */
        text        : "shuan",
        sheng       : "sh",
        yun         : "uan",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 509 */
        text        : "shuang",
        sheng       : "sh",
        yun         : "uang",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : 0
    },
    {  /* 510 */
        text        : "shuei",
        sheng       : "sh",
        yun         : "ui",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 511 */
        text        : "shuen",
        sheng       : "sh",
        yun         : "un",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 512 */
        text        : "shui",
        sheng       : "sh",
        yun         : "ui",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 513 */
        text        : "shun",
        sheng       : "sh",
        yun         : "un",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 514 */
        text        : "shuo",
        sheng       : "sh",
        yun         : "uo",
        sheng_id    : PINYIN_ID_SH,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_S,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 515 */
        text        : "si",
        sheng       : "s",
        yun         : "i",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 516 */
        text        : "sogn",
        sheng       : "s",
        yun         : "ong",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 517 */
        text        : "somg",
        sheng       : "s",
        yun         : "ong",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 518 */
        text        : "song",
        sheng       : "s",
        yun         : "ong",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 519 */
        text        : "sou",
        sheng       : "s",
        yun         : "ou",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 520 */
        text        : "su",
        sheng       : "s",
        yun         : "u",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 521 */
        text        : "sua",
        sheng       : "s",
        yun         : "ua",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_S_SH
    },
    {  /* 522 */
        text        : "suai",
        sheng       : "s",
        yun         : "uai",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_S_SH
    },
    {  /* 523 */
        text        : "suan",
        sheng       : "s",
        yun         : "uan",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 524 */
        text        : "suang",
        sheng       : "s",
        yun         : "uang",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_S_SH | PINYIN_FUZZY_UANG_UAN
    },
    {  /* 525 */
        text        : "suei",
        sheng       : "s",
        yun         : "ui",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 526 */
        text        : "suen",
        sheng       : "s",
        yun         : "un",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 527 */
        text        : "sui",
        sheng       : "s",
        yun         : "ui",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 528 */
        text        : "sun",
        sheng       : "s",
        yun         : "un",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 529 */
        text        : "suo",
        sheng       : "s",
        yun         : "uo",
        sheng_id    : PINYIN_ID_S,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_SH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 530 */
        text        : "t",
        sheng       : "t",
        yun         : "",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 531 */
        text        : "ta",
        sheng       : "t",
        yun         : "a",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 532 */
        text        : "tagn",
        sheng       : "t",
        yun         : "ang",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 533 */
        text        : "tai",
        sheng       : "t",
        yun         : "ai",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 534 */
        text        : "tamg",
        sheng       : "t",
        yun         : "ang",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 535 */
        text        : "tan",
        sheng       : "t",
        yun         : "an",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 536 */
        text        : "tang",
        sheng       : "t",
        yun         : "ang",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 537 */
        text        : "tao",
        sheng       : "t",
        yun         : "ao",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 538 */
        text        : "te",
        sheng       : "t",
        yun         : "e",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 539 */
        text        : "tegn",
        sheng       : "t",
        yun         : "eng",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 540 */
        text        : "temg",
        sheng       : "t",
        yun         : "eng",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 541 */
        text        : "ten",
        sheng       : "t",
        yun         : "en",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_EN_ENG
    },
    {  /* 542 */
        text        : "teng",
        sheng       : "t",
        yun         : "eng",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 543 */
        text        : "ti",
        sheng       : "t",
        yun         : "i",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 544 */
        text        : "tian",
        sheng       : "t",
        yun         : "ian",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 545 */
        text        : "tiang",
        sheng       : "t",
        yun         : "iang",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_IANG_IAN
    },
    {  /* 546 */
        text        : "tiao",
        sheng       : "t",
        yun         : "iao",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 547 */
        text        : "tie",
        sheng       : "t",
        yun         : "ie",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 548 */
        text        : "tign",
        sheng       : "t",
        yun         : "ing",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 549 */
        text        : "timg",
        sheng       : "t",
        yun         : "ing",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 550 */
        text        : "tin",
        sheng       : "t",
        yun         : "in",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_IN_ING
    },
    {  /* 551 */
        text        : "ting",
        sheng       : "t",
        yun         : "ing",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 552 */
        text        : "togn",
        sheng       : "t",
        yun         : "ong",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 553 */
        text        : "tomg",
        sheng       : "t",
        yun         : "ong",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 554 */
        text        : "tong",
        sheng       : "t",
        yun         : "ong",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 555 */
        text        : "tou",
        sheng       : "t",
        yun         : "ou",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 556 */
        text        : "tu",
        sheng       : "t",
        yun         : "u",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 557 */
        text        : "tuan",
        sheng       : "t",
        yun         : "uan",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 558 */
        text        : "tuang",
        sheng       : "t",
        yun         : "uang",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 559 */
        text        : "tuei",
        sheng       : "t",
        yun         : "ui",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 560 */
        text        : "tuen",
        sheng       : "t",
        yun         : "un",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 561 */
        text        : "tui",
        sheng       : "t",
        yun         : "ui",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 562 */
        text        : "tun",
        sheng       : "t",
        yun         : "un",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 563 */
        text        : "tuo",
        sheng       : "t",
        yun         : "uo",
        sheng_id    : PINYIN_ID_T,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 564 */
        text        : "w",
        sheng       : "w",
        yun         : "",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 565 */
        text        : "wa",
        sheng       : "w",
        yun         : "a",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 566 */
        text        : "wagn",
        sheng       : "w",
        yun         : "ang",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 567 */
        text        : "wai",
        sheng       : "w",
        yun         : "ai",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 568 */
        text        : "wamg",
        sheng       : "w",
        yun         : "ang",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 569 */
        text        : "wan",
        sheng       : "w",
        yun         : "an",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 570 */
        text        : "wang",
        sheng       : "w",
        yun         : "ang",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 571 */
        text        : "wegn",
        sheng       : "w",
        yun         : "eng",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 572 */
        text        : "wei",
        sheng       : "w",
        yun         : "ei",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 573 */
        text        : "wemg",
        sheng       : "w",
        yun         : "eng",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 574 */
        text        : "wen",
        sheng       : "w",
        yun         : "en",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 575 */
        text        : "weng",
        sheng       : "w",
        yun         : "eng",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 576 */
        text        : "wo",
        sheng       : "w",
        yun         : "o",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 577 */
        text        : "wu",
        sheng       : "w",
        yun         : "u",
        sheng_id    : PINYIN_ID_W,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 578 */
        text        : "x",
        sheng       : "x",
        yun         : "",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 579 */
        text        : "xi",
        sheng       : "x",
        yun         : "i",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 580 */
        text        : "xia",
        sheng       : "x",
        yun         : "ia",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IA,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 581 */
        text        : "xiagn",
        sheng       : "x",
        yun         : "iang",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 582 */
        text        : "xiamg",
        sheng       : "x",
        yun         : "iang",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 583 */
        text        : "xian",
        sheng       : "x",
        yun         : "ian",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 584 */
        text        : "xiang",
        sheng       : "x",
        yun         : "iang",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 585 */
        text        : "xiao",
        sheng       : "x",
        yun         : "iao",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IAO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 586 */
        text        : "xie",
        sheng       : "x",
        yun         : "ie",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 587 */
        text        : "xign",
        sheng       : "x",
        yun         : "ing",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 588 */
        text        : "ximg",
        sheng       : "x",
        yun         : "ing",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 589 */
        text        : "xin",
        sheng       : "x",
        yun         : "in",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 590 */
        text        : "xing",
        sheng       : "x",
        yun         : "ing",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 591 */
        text        : "xiogn",
        sheng       : "x",
        yun         : "iong",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 592 */
        text        : "xiomg",
        sheng       : "x",
        yun         : "iong",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 593 */
        text        : "xiong",
        sheng       : "x",
        yun         : "iong",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 594 */
        text        : "xiou",
        sheng       : "x",
        yun         : "iu",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_IOU_TO_IU
    },
    {  /* 595 */
        text        : "xiu",
        sheng       : "x",
        yun         : "iu",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_IU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 596 */
        text        : "xu",
        sheng       : "x",
        yun         : "u",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 597 */
        text        : "xuan",
        sheng       : "x",
        yun         : "uan",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 598 */
        text        : "xuang",
        sheng       : "x",
        yun         : "uang",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 599 */
        text        : "xue",
        sheng       : "x",
        yun         : "ue",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 600 */
        text        : "xuen",
        sheng       : "x",
        yun         : "un",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 601 */
        text        : "xun",
        sheng       : "x",
        yun         : "un",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 602 */
        text        : "xve",
        sheng       : "x",
        yun         : "ue",
        sheng_id    : PINYIN_ID_X,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_VE_TO_UE
    },
    {  /* 603 */
        text        : "y",
        sheng       : "y",
        yun         : "",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 604 */
        text        : "ya",
        sheng       : "y",
        yun         : "a",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 605 */
        text        : "yagn",
        sheng       : "y",
        yun         : "ang",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 606 */
        text        : "yamg",
        sheng       : "y",
        yun         : "ang",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 607 */
        text        : "yan",
        sheng       : "y",
        yun         : "an",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 608 */
        text        : "yang",
        sheng       : "y",
        yun         : "ang",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 609 */
        text        : "yao",
        sheng       : "y",
        yun         : "ao",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 610 */
        text        : "ye",
        sheng       : "y",
        yun         : "e",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 611 */
        text        : "yi",
        sheng       : "y",
        yun         : "i",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 612 */
        text        : "yign",
        sheng       : "y",
        yun         : "ing",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 613 */
        text        : "yimg",
        sheng       : "y",
        yun         : "ing",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 614 */
        text        : "yin",
        sheng       : "y",
        yun         : "in",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_IN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ING,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 615 */
        text        : "ying",
        sheng       : "y",
        yun         : "ing",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ING,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_IN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 616 */
        text        : "yo",
        sheng       : "y",
        yun         : "o",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_O,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 617 */
        text        : "yogn",
        sheng       : "y",
        yun         : "ong",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 618 */
        text        : "yomg",
        sheng       : "y",
        yun         : "ong",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 619 */
        text        : "yong",
        sheng       : "y",
        yun         : "ong",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 620 */
        text        : "you",
        sheng       : "y",
        yun         : "ou",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 621 */
        text        : "yu",
        sheng       : "y",
        yun         : "u",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 622 */
        text        : "yuan",
        sheng       : "y",
        yun         : "uan",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 623 */
        text        : "yuang",
        sheng       : "y",
        yun         : "uang",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_UANG_UAN
    },
    {  /* 624 */
        text        : "yue",
        sheng       : "y",
        yun         : "ue",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 625 */
        text        : "yuen",
        sheng       : "y",
        yun         : "un",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 626 */
        text        : "yun",
        sheng       : "y",
        yun         : "un",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 627 */
        text        : "yve",
        sheng       : "y",
        yun         : "ue",
        sheng_id    : PINYIN_ID_Y,
        yun_id      : PINYIN_ID_UE,
        fsheng_id   : PINYIN_ID_ZERO,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_CORRECT_VE_TO_UE
    },
    {  /* 628 */
        text        : "z",
        sheng       : "z",
        yun         : "",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 1,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 629 */
        text        : "za",
        sheng       : "z",
        yun         : "a",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 630 */
        text        : "zagn",
        sheng       : "z",
        yun         : "ang",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 631 */
        text        : "zai",
        sheng       : "z",
        yun         : "ai",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 632 */
        text        : "zamg",
        sheng       : "z",
        yun         : "ang",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 633 */
        text        : "zan",
        sheng       : "z",
        yun         : "an",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 634 */
        text        : "zang",
        sheng       : "z",
        yun         : "ang",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 635 */
        text        : "zao",
        sheng       : "z",
        yun         : "ao",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 636 */
        text        : "ze",
        sheng       : "z",
        yun         : "e",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 637 */
        text        : "zegn",
        sheng       : "z",
        yun         : "eng",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 638 */
        text        : "zei",
        sheng       : "z",
        yun         : "ei",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 639 */
        text        : "zemg",
        sheng       : "z",
        yun         : "eng",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 640 */
        text        : "zen",
        sheng       : "z",
        yun         : "en",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 641 */
        text        : "zeng",
        sheng       : "z",
        yun         : "eng",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 642 */
        text        : "zh",
        sheng       : "zh",
        yun         : "",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ZERO,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : PINYIN_INCOMPLETE_PINYIN
    },
    {  /* 643 */
        text        : "zha",
        sheng       : "zh",
        yun         : "a",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_A,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 644 */
        text        : "zhagn",
        sheng       : "zh",
        yun         : "ang",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 645 */
        text        : "zhai",
        sheng       : "zh",
        yun         : "ai",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_AI,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 646 */
        text        : "zhamg",
        sheng       : "zh",
        yun         : "ang",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 647 */
        text        : "zhan",
        sheng       : "zh",
        yun         : "an",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_AN,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 648 */
        text        : "zhang",
        sheng       : "zh",
        yun         : "ang",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ANG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_AN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 649 */
        text        : "zhao",
        sheng       : "zh",
        yun         : "ao",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_AO,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 650 */
        text        : "zhe",
        sheng       : "zh",
        yun         : "e",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_E,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 651 */
        text        : "zhegn",
        sheng       : "zh",
        yun         : "eng",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 652 */
        text        : "zhei",
        sheng       : "zh",
        yun         : "ei",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_EI,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_ZH_Z
    },
    {  /* 653 */
        text        : "zhemg",
        sheng       : "zh",
        yun         : "eng",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 654 */
        text        : "zhen",
        sheng       : "zh",
        yun         : "en",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_EN,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ENG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 655 */
        text        : "zheng",
        sheng       : "zh",
        yun         : "eng",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ENG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_EN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 656 */
        text        : "zhi",
        sheng       : "zh",
        yun         : "i",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 657 */
        text        : "zhogn",
        sheng       : "zh",
        yun         : "ong",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 658 */
        text        : "zhomg",
        sheng       : "zh",
        yun         : "ong",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 659 */
        text        : "zhong",
        sheng       : "zh",
        yun         : "ong",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 660 */
        text        : "zhou",
        sheng       : "zh",
        yun         : "ou",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 661 */
        text        : "zhu",
        sheng       : "zh",
        yun         : "u",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 662 */
        text        : "zhua",
        sheng       : "zh",
        yun         : "ua",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 663 */
        text        : "zhuagn",
        sheng       : "zh",
        yun         : "uang",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 664 */
        text        : "zhuai",
        sheng       : "zh",
        yun         : "uai",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 665 */
        text        : "zhuamg",
        sheng       : "zh",
        yun         : "uang",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 666 */
        text        : "zhuan",
        sheng       : "zh",
        yun         : "uan",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : 0
    },
    {  /* 667 */
        text        : "zhuang",
        sheng       : "zh",
        yun         : "uang",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 6,
        flags       : 0
    },
    {  /* 668 */
        text        : "zhuei",
        sheng       : "zh",
        yun         : "ui",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 669 */
        text        : "zhuen",
        sheng       : "zh",
        yun         : "un",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 670 */
        text        : "zhui",
        sheng       : "zh",
        yun         : "ui",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 671 */
        text        : "zhun",
        sheng       : "zh",
        yun         : "un",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 672 */
        text        : "zhuo",
        sheng       : "zh",
        yun         : "uo",
        sheng_id    : PINYIN_ID_ZH,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_Z,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 673 */
        text        : "zi",
        sheng       : "z",
        yun         : "i",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_I,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 674 */
        text        : "zogn",
        sheng       : "z",
        yun         : "ong",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_GN_TO_NG
    },
    {  /* 675 */
        text        : "zomg",
        sheng       : "z",
        yun         : "ong",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_MG_TO_NG
    },
    {  /* 676 */
        text        : "zong",
        sheng       : "z",
        yun         : "ong",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_ONG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 677 */
        text        : "zou",
        sheng       : "z",
        yun         : "ou",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_OU,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 678 */
        text        : "zu",
        sheng       : "z",
        yun         : "u",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_U,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 2,
        flags       : 0
    },
    {  /* 679 */
        text        : "zua",
        sheng       : "z",
        yun         : "ua",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UA,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : PINYIN_FUZZY_Z_ZH
    },
    {  /* 680 */
        text        : "zuai",
        sheng       : "z",
        yun         : "uai",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UAI,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_FUZZY_Z_ZH
    },
    {  /* 681 */
        text        : "zuan",
        sheng       : "z",
        yun         : "uan",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UAN,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_UANG,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : 0
    },
    {  /* 682 */
        text        : "zuang",
        sheng       : "z",
        yun         : "uang",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UANG,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_UAN,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 5,
        flags       : PINYIN_FUZZY_Z_ZH | PINYIN_FUZZY_UANG_UAN
    },
    {  /* 683 */
        text        : "zuei",
        sheng       : "z",
        yun         : "ui",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEI_TO_UI
    },
    {  /* 684 */
        text        : "zuen",
        sheng       : "z",
        yun         : "un",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 4,
        flags       : PINYIN_CORRECT_UEN_TO_UN
    },
    {  /* 685 */
        text        : "zui",
        sheng       : "z",
        yun         : "ui",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UI,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 686 */
        text        : "zun",
        sheng       : "z",
        yun         : "un",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UN,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
    {  /* 687 */
        text        : "zuo",
        sheng       : "z",
        yun         : "uo",
        sheng_id    : PINYIN_ID_Z,
        yun_id      : PINYIN_ID_UO,
        fsheng_id   : PINYIN_ID_ZH,
        fyun_id     : PINYIN_ID_ZERO,
        fsheng_id_2 : PINYIN_ID_ZERO,
        fyun_id_2   : PINYIN_ID_ZERO,
        len         : 3,
        flags       : 0
    },
};

#define PINYIN_TABLE_NR (sizeof (pinyin_table) / sizeof (pinyin_table[0]))
static const Pinyin *special_table[][4] = {
    { &pinyin_table[4],    &pinyin_table[0],    &pinyin_table[0],    &pinyin_table[342],  }, /* an a => a na */
    { &pinyin_table[4],    &pinyin_table[6],    &pinyin_table[0],    &pinyin_table[348],  }, /* an ao => a nao */
    { &pinyin_table[4],    &pinyin_table[125],  &pinyin_table[0],    &pinyin_table[349],  }, /* an e => a ne */
    { &pinyin_table[4],    &pinyin_table[126],  &pinyin_table[0],    &pinyin_table[351],  }, /* an ei => a nei */
    { &pinyin_table[5],    &pinyin_table[0],    &pinyin_table[4],    &pinyin_table[155],  }, /* ang a => an ga */
    { &pinyin_table[5],    &pinyin_table[2],    &pinyin_table[4],    &pinyin_table[157],  }, /* ang ai => an gai */
    { &pinyin_table[5],    &pinyin_table[4],    &pinyin_table[4],    &pinyin_table[159],  }, /* ang an => an gan */
    { &pinyin_table[5],    &pinyin_table[5],    &pinyin_table[4],    &pinyin_table[160],  }, /* ang ang => an gang */
    { &pinyin_table[5],    &pinyin_table[6],    &pinyin_table[4],    &pinyin_table[161],  }, /* ang ao => an gao */
    { &pinyin_table[5],    &pinyin_table[125],  &pinyin_table[4],    &pinyin_table[162],  }, /* ang e => an ge */
    { &pinyin_table[5],    &pinyin_table[126],  &pinyin_table[4],    &pinyin_table[164],  }, /* ang ei => an gei */
    { &pinyin_table[5],    &pinyin_table[127],  &pinyin_table[4],    &pinyin_table[166],  }, /* ang en => an gen */
    { &pinyin_table[5],    &pinyin_table[383],  &pinyin_table[4],    &pinyin_table[171],  }, /* ang ou => an gou */
    { &pinyin_table[12],   &pinyin_table[0],    &pinyin_table[8],    &pinyin_table[342],  }, /* ban a => ba na */
    { &pinyin_table[12],   &pinyin_table[5],    &pinyin_table[8],    &pinyin_table[347],  }, /* ban ang => ba nang */
    { &pinyin_table[12],   &pinyin_table[6],    &pinyin_table[8],    &pinyin_table[348],  }, /* ban ao => ba nao */
    { &pinyin_table[12],   &pinyin_table[125],  &pinyin_table[8],    &pinyin_table[349],  }, /* ban e => ba ne */
    { &pinyin_table[12],   &pinyin_table[126],  &pinyin_table[8],    &pinyin_table[351],  }, /* ban ei => ba nei */
    { &pinyin_table[13],   &pinyin_table[5],    &pinyin_table[12],   &pinyin_table[160],  }, /* bang ang => ban gang */
    { &pinyin_table[13],   &pinyin_table[6],    &pinyin_table[12],   &pinyin_table[161],  }, /* bang ao => ban gao */
    { &pinyin_table[13],   &pinyin_table[125],  &pinyin_table[12],   &pinyin_table[162],  }, /* bang e => ban ge */
    { &pinyin_table[13],   &pinyin_table[126],  &pinyin_table[12],   &pinyin_table[164],  }, /* bang ei => ban gei */
    { &pinyin_table[19],   &pinyin_table[0],    &pinyin_table[18],   &pinyin_table[155],  }, /* beng a => ben ga */
    { &pinyin_table[19],   &pinyin_table[2],    &pinyin_table[18],   &pinyin_table[157],  }, /* beng ai => ben gai */
    { &pinyin_table[19],   &pinyin_table[4],    &pinyin_table[18],   &pinyin_table[159],  }, /* beng an => ben gan */
    { &pinyin_table[19],   &pinyin_table[5],    &pinyin_table[18],   &pinyin_table[160],  }, /* beng ang => ben gang */
    { &pinyin_table[19],   &pinyin_table[6],    &pinyin_table[18],   &pinyin_table[161],  }, /* beng ao => ben gao */
    { &pinyin_table[19],   &pinyin_table[125],  &pinyin_table[18],   &pinyin_table[162],  }, /* beng e => ben ge */
    { &pinyin_table[19],   &pinyin_table[126],  &pinyin_table[18],   &pinyin_table[164],  }, /* beng ei => ben gei */
    { &pinyin_table[19],   &pinyin_table[127],  &pinyin_table[18],   &pinyin_table[166],  }, /* beng en => ben gen */
    { &pinyin_table[19],   &pinyin_table[383],  &pinyin_table[18],   &pinyin_table[171],  }, /* beng ou => ben gou */
    { &pinyin_table[24],   &pinyin_table[434],  &pinyin_table[20],   &pinyin_table[128],  }, /* bie r => bi er */
    { &pinyin_table[27],   &pinyin_table[0],    &pinyin_table[20],   &pinyin_table[342],  }, /* bin a => bi na */
    { &pinyin_table[27],   &pinyin_table[2],    &pinyin_table[20],   &pinyin_table[344],  }, /* bin ai => bi nai */
    { &pinyin_table[27],   &pinyin_table[4],    &pinyin_table[20],   &pinyin_table[346],  }, /* bin an => bi nan */
    { &pinyin_table[27],   &pinyin_table[5],    &pinyin_table[20],   &pinyin_table[347],  }, /* bin ang => bi nang */
    { &pinyin_table[27],   &pinyin_table[6],    &pinyin_table[20],   &pinyin_table[348],  }, /* bin ao => bi nao */
    { &pinyin_table[27],   &pinyin_table[125],  &pinyin_table[20],   &pinyin_table[349],  }, /* bin e => bi ne */
    { &pinyin_table[27],   &pinyin_table[126],  &pinyin_table[20],   &pinyin_table[351],  }, /* bin ei => bi nei */
    { &pinyin_table[27],   &pinyin_table[127],  &pinyin_table[20],   &pinyin_table[353],  }, /* bin en => bi nen */
    { &pinyin_table[36],   &pinyin_table[125],  &pinyin_table[32],   &pinyin_table[349],  }, /* can e => ca ne */
    { &pinyin_table[36],   &pinyin_table[126],  &pinyin_table[32],   &pinyin_table[351],  }, /* can ei => ca nei */
    { &pinyin_table[37],   &pinyin_table[2],    &pinyin_table[36],   &pinyin_table[157],  }, /* cang ai => can gai */
    { &pinyin_table[37],   &pinyin_table[4],    &pinyin_table[36],   &pinyin_table[159],  }, /* cang an => can gan */
    { &pinyin_table[37],   &pinyin_table[5],    &pinyin_table[36],   &pinyin_table[160],  }, /* cang ang => can gang */
    { &pinyin_table[37],   &pinyin_table[6],    &pinyin_table[36],   &pinyin_table[161],  }, /* cang ao => can gao */
    { &pinyin_table[37],   &pinyin_table[125],  &pinyin_table[36],   &pinyin_table[162],  }, /* cang e => can ge */
    { &pinyin_table[37],   &pinyin_table[126],  &pinyin_table[36],   &pinyin_table[164],  }, /* cang ei => can gei */
    { &pinyin_table[37],   &pinyin_table[127],  &pinyin_table[36],   &pinyin_table[166],  }, /* cang en => can gen */
    { &pinyin_table[37],   &pinyin_table[383],  &pinyin_table[36],   &pinyin_table[171],  }, /* cang ou => can gou */
    { &pinyin_table[42],   &pinyin_table[0],    &pinyin_table[39],   &pinyin_table[342],  }, /* cen a => ce na */
    { &pinyin_table[42],   &pinyin_table[2],    &pinyin_table[39],   &pinyin_table[344],  }, /* cen ai => ce nai */
    { &pinyin_table[42],   &pinyin_table[4],    &pinyin_table[39],   &pinyin_table[346],  }, /* cen an => ce nan */
    { &pinyin_table[42],   &pinyin_table[5],    &pinyin_table[39],   &pinyin_table[347],  }, /* cen ang => ce nang */
    { &pinyin_table[42],   &pinyin_table[6],    &pinyin_table[39],   &pinyin_table[348],  }, /* cen ao => ce nao */
    { &pinyin_table[42],   &pinyin_table[125],  &pinyin_table[39],   &pinyin_table[349],  }, /* cen e => ce ne */
    { &pinyin_table[42],   &pinyin_table[126],  &pinyin_table[39],   &pinyin_table[351],  }, /* cen ei => ce nei */
    { &pinyin_table[42],   &pinyin_table[127],  &pinyin_table[39],   &pinyin_table[353],  }, /* cen en => ce nen */
    { &pinyin_table[49],   &pinyin_table[0],    &pinyin_table[45],   &pinyin_table[342],  }, /* chan a => cha na */
    { &pinyin_table[49],   &pinyin_table[4],    &pinyin_table[45],   &pinyin_table[346],  }, /* chan an => cha nan */
    { &pinyin_table[49],   &pinyin_table[5],    &pinyin_table[45],   &pinyin_table[347],  }, /* chan ang => cha nang */
    { &pinyin_table[49],   &pinyin_table[6],    &pinyin_table[45],   &pinyin_table[348],  }, /* chan ao => cha nao */
    { &pinyin_table[49],   &pinyin_table[125],  &pinyin_table[45],   &pinyin_table[349],  }, /* chan e => cha ne */
    { &pinyin_table[49],   &pinyin_table[126],  &pinyin_table[45],   &pinyin_table[351],  }, /* chan ei => cha nei */
    { &pinyin_table[50],   &pinyin_table[5],    &pinyin_table[49],   &pinyin_table[160],  }, /* chang ang => chan gang */
    { &pinyin_table[50],   &pinyin_table[126],  &pinyin_table[49],   &pinyin_table[164],  }, /* chang ei => chan gei */
    { &pinyin_table[55],   &pinyin_table[0],    &pinyin_table[52],   &pinyin_table[342],  }, /* chen a => che na */
    { &pinyin_table[55],   &pinyin_table[4],    &pinyin_table[52],   &pinyin_table[346],  }, /* chen an => che nan */
    { &pinyin_table[55],   &pinyin_table[6],    &pinyin_table[52],   &pinyin_table[348],  }, /* chen ao => che nao */
    { &pinyin_table[55],   &pinyin_table[125],  &pinyin_table[52],   &pinyin_table[349],  }, /* chen e => che ne */
    { &pinyin_table[55],   &pinyin_table[126],  &pinyin_table[52],   &pinyin_table[351],  }, /* chen ei => che nei */
    { &pinyin_table[56],   &pinyin_table[5],    &pinyin_table[55],   &pinyin_table[160],  }, /* cheng ang => chen gang */
    { &pinyin_table[56],   &pinyin_table[6],    &pinyin_table[55],   &pinyin_table[161],  }, /* cheng ao => chen gao */
    { &pinyin_table[56],   &pinyin_table[125],  &pinyin_table[55],   &pinyin_table[162],  }, /* cheng e => chen ge */
    { &pinyin_table[56],   &pinyin_table[126],  &pinyin_table[55],   &pinyin_table[164],  }, /* cheng ei => chen gei */
    { &pinyin_table[67],   &pinyin_table[2],    &pinyin_table[66],   &pinyin_table[157],  }, /* chuang ai => chuan gai */
    { &pinyin_table[67],   &pinyin_table[4],    &pinyin_table[66],   &pinyin_table[159],  }, /* chuang an => chuan gan */
    { &pinyin_table[67],   &pinyin_table[5],    &pinyin_table[66],   &pinyin_table[160],  }, /* chuang ang => chuan gang */
    { &pinyin_table[67],   &pinyin_table[6],    &pinyin_table[66],   &pinyin_table[161],  }, /* chuang ao => chuan gao */
    { &pinyin_table[67],   &pinyin_table[125],  &pinyin_table[66],   &pinyin_table[162],  }, /* chuang e => chuan ge */
    { &pinyin_table[67],   &pinyin_table[126],  &pinyin_table[66],   &pinyin_table[164],  }, /* chuang ei => chuan gei */
    { &pinyin_table[67],   &pinyin_table[127],  &pinyin_table[66],   &pinyin_table[166],  }, /* chuang en => chuan gen */
    { &pinyin_table[67],   &pinyin_table[383],  &pinyin_table[66],   &pinyin_table[171],  }, /* chuang ou => chuan gou */
    { &pinyin_table[71],   &pinyin_table[0],    &pinyin_table[62],   &pinyin_table[342],  }, /* chun a => chu na */
    { &pinyin_table[71],   &pinyin_table[4],    &pinyin_table[62],   &pinyin_table[346],  }, /* chun an => chu nan */
    { &pinyin_table[71],   &pinyin_table[5],    &pinyin_table[62],   &pinyin_table[347],  }, /* chun ang => chu nang */
    { &pinyin_table[71],   &pinyin_table[6],    &pinyin_table[62],   &pinyin_table[348],  }, /* chun ao => chu nao */
    { &pinyin_table[71],   &pinyin_table[125],  &pinyin_table[62],   &pinyin_table[349],  }, /* chun e => chu ne */
    { &pinyin_table[71],   &pinyin_table[126],  &pinyin_table[62],   &pinyin_table[351],  }, /* chun ei => chu nei */
    { &pinyin_table[85],   &pinyin_table[126],  &pinyin_table[78],   &pinyin_table[351],  }, /* cun ei => cu nei */
    { &pinyin_table[92],   &pinyin_table[0],    &pinyin_table[88],   &pinyin_table[342],  }, /* dan a => da na */
    { &pinyin_table[92],   &pinyin_table[2],    &pinyin_table[88],   &pinyin_table[344],  }, /* dan ai => da nai */
    { &pinyin_table[92],   &pinyin_table[6],    &pinyin_table[88],   &pinyin_table[348],  }, /* dan ao => da nao */
    { &pinyin_table[92],   &pinyin_table[125],  &pinyin_table[88],   &pinyin_table[349],  }, /* dan e => da ne */
    { &pinyin_table[92],   &pinyin_table[126],  &pinyin_table[88],   &pinyin_table[351],  }, /* dan ei => da nei */
    { &pinyin_table[93],   &pinyin_table[2],    &pinyin_table[92],   &pinyin_table[157],  }, /* dang ai => dan gai */
    { &pinyin_table[93],   &pinyin_table[5],    &pinyin_table[92],   &pinyin_table[160],  }, /* dang ang => dan gang */
    { &pinyin_table[93],   &pinyin_table[6],    &pinyin_table[92],   &pinyin_table[161],  }, /* dang ao => dan gao */
    { &pinyin_table[93],   &pinyin_table[125],  &pinyin_table[92],   &pinyin_table[162],  }, /* dang e => dan ge */
    { &pinyin_table[93],   &pinyin_table[126],  &pinyin_table[92],   &pinyin_table[164],  }, /* dang ei => dan gei */
    { &pinyin_table[93],   &pinyin_table[127],  &pinyin_table[92],   &pinyin_table[166],  }, /* dang en => dan gen */
    { &pinyin_table[106],  &pinyin_table[434],  &pinyin_table[101],  &pinyin_table[128],  }, /* die r => di er */
    { &pinyin_table[123],  &pinyin_table[0],    &pinyin_table[117],  &pinyin_table[342],  }, /* dun a => du na */
    { &pinyin_table[123],  &pinyin_table[2],    &pinyin_table[117],  &pinyin_table[344],  }, /* dun ai => du nai */
    { &pinyin_table[123],  &pinyin_table[4],    &pinyin_table[117],  &pinyin_table[346],  }, /* dun an => du nan */
    { &pinyin_table[123],  &pinyin_table[5],    &pinyin_table[117],  &pinyin_table[347],  }, /* dun ang => du nang */
    { &pinyin_table[123],  &pinyin_table[6],    &pinyin_table[117],  &pinyin_table[348],  }, /* dun ao => du nao */
    { &pinyin_table[123],  &pinyin_table[125],  &pinyin_table[117],  &pinyin_table[349],  }, /* dun e => du ne */
    { &pinyin_table[123],  &pinyin_table[126],  &pinyin_table[117],  &pinyin_table[351],  }, /* dun ei => du nei */
    { &pinyin_table[127],  &pinyin_table[125],  &pinyin_table[125],  &pinyin_table[349],  }, /* en e => e ne */
    { &pinyin_table[127],  &pinyin_table[126],  &pinyin_table[125],  &pinyin_table[351],  }, /* en ei => e nei */
    { &pinyin_table[128],  &pinyin_table[4],    &pinyin_table[125],  &pinyin_table[439],  }, /* er an => e ran */
    { &pinyin_table[128],  &pinyin_table[5],    &pinyin_table[125],  &pinyin_table[440],  }, /* er ang => e rang */
    { &pinyin_table[128],  &pinyin_table[127],  &pinyin_table[125],  &pinyin_table[446],  }, /* er en => e ren */
    { &pinyin_table[134],  &pinyin_table[0],    &pinyin_table[130],  &pinyin_table[342],  }, /* fan a => fa na */
    { &pinyin_table[134],  &pinyin_table[4],    &pinyin_table[130],  &pinyin_table[346],  }, /* fan an => fa nan */
    { &pinyin_table[134],  &pinyin_table[5],    &pinyin_table[130],  &pinyin_table[347],  }, /* fan ang => fa nang */
    { &pinyin_table[134],  &pinyin_table[6],    &pinyin_table[130],  &pinyin_table[348],  }, /* fan ao => fa nao */
    { &pinyin_table[134],  &pinyin_table[125],  &pinyin_table[130],  &pinyin_table[349],  }, /* fan e => fa ne */
    { &pinyin_table[134],  &pinyin_table[126],  &pinyin_table[130],  &pinyin_table[351],  }, /* fan ei => fa nei */
    { &pinyin_table[135],  &pinyin_table[5],    &pinyin_table[134],  &pinyin_table[160],  }, /* fang ang => fan gang */
    { &pinyin_table[135],  &pinyin_table[6],    &pinyin_table[134],  &pinyin_table[161],  }, /* fang ao => fan gao */
    { &pinyin_table[135],  &pinyin_table[125],  &pinyin_table[134],  &pinyin_table[162],  }, /* fang e => fan ge */
    { &pinyin_table[135],  &pinyin_table[126],  &pinyin_table[134],  &pinyin_table[164],  }, /* fang ei => fan gei */
    { &pinyin_table[142],  &pinyin_table[2],    &pinyin_table[141],  &pinyin_table[157],  }, /* feng ai => fen gai */
    { &pinyin_table[142],  &pinyin_table[4],    &pinyin_table[141],  &pinyin_table[159],  }, /* feng an => fen gan */
    { &pinyin_table[142],  &pinyin_table[5],    &pinyin_table[141],  &pinyin_table[160],  }, /* feng ang => fen gang */
    { &pinyin_table[142],  &pinyin_table[6],    &pinyin_table[141],  &pinyin_table[161],  }, /* feng ao => fen gao */
    { &pinyin_table[142],  &pinyin_table[125],  &pinyin_table[141],  &pinyin_table[162],  }, /* feng e => fen ge */
    { &pinyin_table[142],  &pinyin_table[126],  &pinyin_table[141],  &pinyin_table[164],  }, /* feng ei => fen gei */
    { &pinyin_table[142],  &pinyin_table[127],  &pinyin_table[141],  &pinyin_table[166],  }, /* feng en => fen gen */
    { &pinyin_table[142],  &pinyin_table[383],  &pinyin_table[141],  &pinyin_table[171],  }, /* feng ou => fen gou */
    { &pinyin_table[159],  &pinyin_table[126],  &pinyin_table[155],  &pinyin_table[351],  }, /* gan ei => ga nei */
    { &pinyin_table[160],  &pinyin_table[0],    &pinyin_table[159],  &pinyin_table[155],  }, /* gang a => gan ga */
    { &pinyin_table[160],  &pinyin_table[4],    &pinyin_table[159],  &pinyin_table[159],  }, /* gang an => gan gan */
    { &pinyin_table[160],  &pinyin_table[5],    &pinyin_table[159],  &pinyin_table[160],  }, /* gang ang => gan gang */
    { &pinyin_table[160],  &pinyin_table[125],  &pinyin_table[159],  &pinyin_table[162],  }, /* gang e => gan ge */
    { &pinyin_table[160],  &pinyin_table[126],  &pinyin_table[159],  &pinyin_table[164],  }, /* gang ei => gan gei */
    { &pinyin_table[166],  &pinyin_table[0],    &pinyin_table[162],  &pinyin_table[342],  }, /* gen a => ge na */
    { &pinyin_table[166],  &pinyin_table[125],  &pinyin_table[162],  &pinyin_table[349],  }, /* gen e => ge ne */
    { &pinyin_table[166],  &pinyin_table[126],  &pinyin_table[162],  &pinyin_table[351],  }, /* gen ei => ge nei */
    { &pinyin_table[167],  &pinyin_table[4],    &pinyin_table[166],  &pinyin_table[159],  }, /* geng an => gen gan */
    { &pinyin_table[167],  &pinyin_table[5],    &pinyin_table[166],  &pinyin_table[160],  }, /* geng ang => gen gang */
    { &pinyin_table[167],  &pinyin_table[6],    &pinyin_table[166],  &pinyin_table[161],  }, /* geng ao => gen gao */
    { &pinyin_table[167],  &pinyin_table[125],  &pinyin_table[166],  &pinyin_table[162],  }, /* geng e => gen ge */
    { &pinyin_table[167],  &pinyin_table[126],  &pinyin_table[166],  &pinyin_table[164],  }, /* geng ei => gen gei */
    { &pinyin_table[167],  &pinyin_table[127],  &pinyin_table[166],  &pinyin_table[166],  }, /* geng en => gen gen */
    { &pinyin_table[177],  &pinyin_table[125],  &pinyin_table[173],  &pinyin_table[349],  }, /* guan e => gua ne */
    { &pinyin_table[177],  &pinyin_table[126],  &pinyin_table[173],  &pinyin_table[351],  }, /* guan ei => gua nei */
    { &pinyin_table[178],  &pinyin_table[2],    &pinyin_table[177],  &pinyin_table[157],  }, /* guang ai => guan gai */
    { &pinyin_table[178],  &pinyin_table[4],    &pinyin_table[177],  &pinyin_table[159],  }, /* guang an => guan gan */
    { &pinyin_table[178],  &pinyin_table[5],    &pinyin_table[177],  &pinyin_table[160],  }, /* guang ang => guan gang */
    { &pinyin_table[178],  &pinyin_table[6],    &pinyin_table[177],  &pinyin_table[161],  }, /* guang ao => guan gao */
    { &pinyin_table[178],  &pinyin_table[125],  &pinyin_table[177],  &pinyin_table[162],  }, /* guang e => guan ge */
    { &pinyin_table[178],  &pinyin_table[126],  &pinyin_table[177],  &pinyin_table[164],  }, /* guang ei => guan gei */
    { &pinyin_table[178],  &pinyin_table[127],  &pinyin_table[177],  &pinyin_table[166],  }, /* guang en => guan gen */
    { &pinyin_table[182],  &pinyin_table[0],    &pinyin_table[172],  &pinyin_table[342],  }, /* gun a => gu na */
    { &pinyin_table[182],  &pinyin_table[4],    &pinyin_table[172],  &pinyin_table[346],  }, /* gun an => gu nan */
    { &pinyin_table[182],  &pinyin_table[5],    &pinyin_table[172],  &pinyin_table[347],  }, /* gun ang => gu nang */
    { &pinyin_table[182],  &pinyin_table[6],    &pinyin_table[172],  &pinyin_table[348],  }, /* gun ao => gu nao */
    { &pinyin_table[182],  &pinyin_table[125],  &pinyin_table[172],  &pinyin_table[349],  }, /* gun e => gu ne */
    { &pinyin_table[182],  &pinyin_table[126],  &pinyin_table[172],  &pinyin_table[351],  }, /* gun ei => gu nei */
    { &pinyin_table[189],  &pinyin_table[0],    &pinyin_table[185],  &pinyin_table[342],  }, /* han a => ha na */
    { &pinyin_table[189],  &pinyin_table[4],    &pinyin_table[185],  &pinyin_table[346],  }, /* han an => ha nan */
    { &pinyin_table[189],  &pinyin_table[5],    &pinyin_table[185],  &pinyin_table[347],  }, /* han ang => ha nang */
    { &pinyin_table[189],  &pinyin_table[6],    &pinyin_table[185],  &pinyin_table[348],  }, /* han ao => ha nao */
    { &pinyin_table[189],  &pinyin_table[125],  &pinyin_table[185],  &pinyin_table[349],  }, /* han e => ha ne */
    { &pinyin_table[189],  &pinyin_table[126],  &pinyin_table[185],  &pinyin_table[351],  }, /* han ei => ha nei */
    { &pinyin_table[190],  &pinyin_table[2],    &pinyin_table[189],  &pinyin_table[157],  }, /* hang ai => han gai */
    { &pinyin_table[190],  &pinyin_table[4],    &pinyin_table[189],  &pinyin_table[159],  }, /* hang an => han gan */
    { &pinyin_table[190],  &pinyin_table[5],    &pinyin_table[189],  &pinyin_table[160],  }, /* hang ang => han gang */
    { &pinyin_table[190],  &pinyin_table[6],    &pinyin_table[189],  &pinyin_table[161],  }, /* hang ao => han gao */
    { &pinyin_table[190],  &pinyin_table[125],  &pinyin_table[189],  &pinyin_table[162],  }, /* hang e => han ge */
    { &pinyin_table[190],  &pinyin_table[126],  &pinyin_table[189],  &pinyin_table[164],  }, /* hang ei => han gei */
    { &pinyin_table[190],  &pinyin_table[127],  &pinyin_table[189],  &pinyin_table[166],  }, /* hang en => han gen */
    { &pinyin_table[190],  &pinyin_table[383],  &pinyin_table[189],  &pinyin_table[171],  }, /* hang ou => han gou */
    { &pinyin_table[196],  &pinyin_table[0],    &pinyin_table[192],  &pinyin_table[342],  }, /* hen a => he na */
    { &pinyin_table[196],  &pinyin_table[4],    &pinyin_table[192],  &pinyin_table[346],  }, /* hen an => he nan */
    { &pinyin_table[196],  &pinyin_table[125],  &pinyin_table[192],  &pinyin_table[349],  }, /* hen e => he ne */
    { &pinyin_table[196],  &pinyin_table[126],  &pinyin_table[192],  &pinyin_table[351],  }, /* hen ei => he nei */
    { &pinyin_table[197],  &pinyin_table[0],    &pinyin_table[196],  &pinyin_table[155],  }, /* heng a => hen ga */
    { &pinyin_table[197],  &pinyin_table[2],    &pinyin_table[196],  &pinyin_table[157],  }, /* heng ai => hen gai */
    { &pinyin_table[197],  &pinyin_table[4],    &pinyin_table[196],  &pinyin_table[159],  }, /* heng an => hen gan */
    { &pinyin_table[197],  &pinyin_table[5],    &pinyin_table[196],  &pinyin_table[160],  }, /* heng ang => hen gang */
    { &pinyin_table[197],  &pinyin_table[6],    &pinyin_table[196],  &pinyin_table[161],  }, /* heng ao => hen gao */
    { &pinyin_table[197],  &pinyin_table[125],  &pinyin_table[196],  &pinyin_table[162],  }, /* heng e => hen ge */
    { &pinyin_table[197],  &pinyin_table[126],  &pinyin_table[196],  &pinyin_table[164],  }, /* heng ei => hen gei */
    { &pinyin_table[197],  &pinyin_table[127],  &pinyin_table[196],  &pinyin_table[166],  }, /* heng en => hen gen */
    { &pinyin_table[197],  &pinyin_table[383],  &pinyin_table[196],  &pinyin_table[171],  }, /* heng ou => hen gou */
    { &pinyin_table[208],  &pinyin_table[0],    &pinyin_table[204],  &pinyin_table[342],  }, /* huan a => hua na */
    { &pinyin_table[208],  &pinyin_table[4],    &pinyin_table[204],  &pinyin_table[346],  }, /* huan an => hua nan */
    { &pinyin_table[208],  &pinyin_table[125],  &pinyin_table[204],  &pinyin_table[349],  }, /* huan e => hua ne */
    { &pinyin_table[208],  &pinyin_table[126],  &pinyin_table[204],  &pinyin_table[351],  }, /* huan ei => hua nei */
    { &pinyin_table[209],  &pinyin_table[2],    &pinyin_table[208],  &pinyin_table[157],  }, /* huang ai => huan gai */
    { &pinyin_table[209],  &pinyin_table[5],    &pinyin_table[208],  &pinyin_table[160],  }, /* huang ang => huan gang */
    { &pinyin_table[209],  &pinyin_table[6],    &pinyin_table[208],  &pinyin_table[161],  }, /* huang ao => huan gao */
    { &pinyin_table[209],  &pinyin_table[125],  &pinyin_table[208],  &pinyin_table[162],  }, /* huang e => huan ge */
    { &pinyin_table[209],  &pinyin_table[126],  &pinyin_table[208],  &pinyin_table[164],  }, /* huang ei => huan gei */
    { &pinyin_table[209],  &pinyin_table[127],  &pinyin_table[208],  &pinyin_table[166],  }, /* huang en => huan gen */
    { &pinyin_table[209],  &pinyin_table[383],  &pinyin_table[208],  &pinyin_table[171],  }, /* huang ou => huan gou */
    { &pinyin_table[213],  &pinyin_table[4],    &pinyin_table[203],  &pinyin_table[346],  }, /* hun an => hu nan */
    { &pinyin_table[213],  &pinyin_table[6],    &pinyin_table[203],  &pinyin_table[348],  }, /* hun ao => hu nao */
    { &pinyin_table[213],  &pinyin_table[125],  &pinyin_table[203],  &pinyin_table[349],  }, /* hun e => hu ne */
    { &pinyin_table[213],  &pinyin_table[126],  &pinyin_table[203],  &pinyin_table[351],  }, /* hun ei => hu nei */
    { &pinyin_table[220],  &pinyin_table[0],    &pinyin_table[217],  &pinyin_table[342],  }, /* jian a => jia na */
    { &pinyin_table[220],  &pinyin_table[125],  &pinyin_table[217],  &pinyin_table[349],  }, /* jian e => jia ne */
    { &pinyin_table[220],  &pinyin_table[126],  &pinyin_table[217],  &pinyin_table[351],  }, /* jian ei => jia nei */
    { &pinyin_table[221],  &pinyin_table[5],    &pinyin_table[220],  &pinyin_table[160],  }, /* jiang ang => jian gang */
    { &pinyin_table[221],  &pinyin_table[6],    &pinyin_table[220],  &pinyin_table[161],  }, /* jiang ao => jian gao */
    { &pinyin_table[221],  &pinyin_table[125],  &pinyin_table[220],  &pinyin_table[162],  }, /* jiang e => jian ge */
    { &pinyin_table[221],  &pinyin_table[126],  &pinyin_table[220],  &pinyin_table[164],  }, /* jiang ei => jian gei */
    { &pinyin_table[221],  &pinyin_table[383],  &pinyin_table[220],  &pinyin_table[171],  }, /* jiang ou => jian gou */
    { &pinyin_table[223],  &pinyin_table[434],  &pinyin_table[216],  &pinyin_table[128],  }, /* jie r => ji er */
    { &pinyin_table[226],  &pinyin_table[0],    &pinyin_table[216],  &pinyin_table[342],  }, /* jin a => ji na */
    { &pinyin_table[226],  &pinyin_table[4],    &pinyin_table[216],  &pinyin_table[346],  }, /* jin an => ji nan */
    { &pinyin_table[226],  &pinyin_table[6],    &pinyin_table[216],  &pinyin_table[348],  }, /* jin ao => ji nao */
    { &pinyin_table[226],  &pinyin_table[126],  &pinyin_table[216],  &pinyin_table[351],  }, /* jin ei => ji nei */
    { &pinyin_table[227],  &pinyin_table[5],    &pinyin_table[226],  &pinyin_table[160],  }, /* jing ang => jin gang */
    { &pinyin_table[227],  &pinyin_table[6],    &pinyin_table[226],  &pinyin_table[161],  }, /* jing ao => jin gao */
    { &pinyin_table[227],  &pinyin_table[126],  &pinyin_table[226],  &pinyin_table[164],  }, /* jing ei => jin gei */
    { &pinyin_table[227],  &pinyin_table[127],  &pinyin_table[226],  &pinyin_table[166],  }, /* jing en => jin gen */
    { &pinyin_table[227],  &pinyin_table[383],  &pinyin_table[226],  &pinyin_table[171],  }, /* jing ou => jin gou */
    { &pinyin_table[236],  &pinyin_table[434],  &pinyin_table[233],  &pinyin_table[128],  }, /* jue r => ju er */
    { &pinyin_table[238],  &pinyin_table[0],    &pinyin_table[233],  &pinyin_table[342],  }, /* jun a => ju na */
    { &pinyin_table[238],  &pinyin_table[4],    &pinyin_table[233],  &pinyin_table[346],  }, /* jun an => ju nan */
    { &pinyin_table[238],  &pinyin_table[6],    &pinyin_table[233],  &pinyin_table[348],  }, /* jun ao => ju nao */
    { &pinyin_table[238],  &pinyin_table[125],  &pinyin_table[233],  &pinyin_table[349],  }, /* jun e => ju ne */
    { &pinyin_table[238],  &pinyin_table[126],  &pinyin_table[233],  &pinyin_table[351],  }, /* jun ei => ju nei */
    { &pinyin_table[245],  &pinyin_table[125],  &pinyin_table[241],  &pinyin_table[349],  }, /* kan e => ka ne */
    { &pinyin_table[245],  &pinyin_table[126],  &pinyin_table[241],  &pinyin_table[351],  }, /* kan ei => ka nei */
    { &pinyin_table[246],  &pinyin_table[0],    &pinyin_table[245],  &pinyin_table[155],  }, /* kang a => kan ga */
    { &pinyin_table[246],  &pinyin_table[4],    &pinyin_table[245],  &pinyin_table[159],  }, /* kang an => kan gan */
    { &pinyin_table[246],  &pinyin_table[5],    &pinyin_table[245],  &pinyin_table[160],  }, /* kang ang => kan gang */
    { &pinyin_table[246],  &pinyin_table[6],    &pinyin_table[245],  &pinyin_table[161],  }, /* kang ao => kan gao */
    { &pinyin_table[246],  &pinyin_table[125],  &pinyin_table[245],  &pinyin_table[162],  }, /* kang e => kan ge */
    { &pinyin_table[246],  &pinyin_table[126],  &pinyin_table[245],  &pinyin_table[164],  }, /* kang ei => kan gei */
    { &pinyin_table[246],  &pinyin_table[127],  &pinyin_table[245],  &pinyin_table[166],  }, /* kang en => kan gen */
    { &pinyin_table[246],  &pinyin_table[383],  &pinyin_table[245],  &pinyin_table[171],  }, /* kang ou => kan gou */
    { &pinyin_table[252],  &pinyin_table[0],    &pinyin_table[248],  &pinyin_table[342],  }, /* ken a => ke na */
    { &pinyin_table[252],  &pinyin_table[2],    &pinyin_table[248],  &pinyin_table[344],  }, /* ken ai => ke nai */
    { &pinyin_table[252],  &pinyin_table[4],    &pinyin_table[248],  &pinyin_table[346],  }, /* ken an => ke nan */
    { &pinyin_table[252],  &pinyin_table[5],    &pinyin_table[248],  &pinyin_table[347],  }, /* ken ang => ke nang */
    { &pinyin_table[252],  &pinyin_table[6],    &pinyin_table[248],  &pinyin_table[348],  }, /* ken ao => ke nao */
    { &pinyin_table[252],  &pinyin_table[125],  &pinyin_table[248],  &pinyin_table[349],  }, /* ken e => ke ne */
    { &pinyin_table[252],  &pinyin_table[126],  &pinyin_table[248],  &pinyin_table[351],  }, /* ken ei => ke nei */
    { &pinyin_table[253],  &pinyin_table[2],    &pinyin_table[252],  &pinyin_table[157],  }, /* keng ai => ken gai */
    { &pinyin_table[253],  &pinyin_table[4],    &pinyin_table[252],  &pinyin_table[159],  }, /* keng an => ken gan */
    { &pinyin_table[253],  &pinyin_table[5],    &pinyin_table[252],  &pinyin_table[160],  }, /* keng ang => ken gang */
    { &pinyin_table[253],  &pinyin_table[6],    &pinyin_table[252],  &pinyin_table[161],  }, /* keng ao => ken gao */
    { &pinyin_table[253],  &pinyin_table[125],  &pinyin_table[252],  &pinyin_table[162],  }, /* keng e => ken ge */
    { &pinyin_table[253],  &pinyin_table[126],  &pinyin_table[252],  &pinyin_table[164],  }, /* keng ei => ken gei */
    { &pinyin_table[253],  &pinyin_table[127],  &pinyin_table[252],  &pinyin_table[166],  }, /* keng en => ken gen */
    { &pinyin_table[253],  &pinyin_table[383],  &pinyin_table[252],  &pinyin_table[171],  }, /* keng ou => ken gou */
    { &pinyin_table[263],  &pinyin_table[126],  &pinyin_table[259],  &pinyin_table[351],  }, /* kuan ei => kua nei */
    { &pinyin_table[264],  &pinyin_table[2],    &pinyin_table[263],  &pinyin_table[157],  }, /* kuang ai => kuan gai */
    { &pinyin_table[264],  &pinyin_table[4],    &pinyin_table[263],  &pinyin_table[159],  }, /* kuang an => kuan gan */
    { &pinyin_table[264],  &pinyin_table[5],    &pinyin_table[263],  &pinyin_table[160],  }, /* kuang ang => kuan gang */
    { &pinyin_table[264],  &pinyin_table[6],    &pinyin_table[263],  &pinyin_table[161],  }, /* kuang ao => kuan gao */
    { &pinyin_table[264],  &pinyin_table[125],  &pinyin_table[263],  &pinyin_table[162],  }, /* kuang e => kuan ge */
    { &pinyin_table[264],  &pinyin_table[126],  &pinyin_table[263],  &pinyin_table[164],  }, /* kuang ei => kuan gei */
    { &pinyin_table[264],  &pinyin_table[127],  &pinyin_table[263],  &pinyin_table[166],  }, /* kuang en => kuan gen */
    { &pinyin_table[264],  &pinyin_table[383],  &pinyin_table[263],  &pinyin_table[171],  }, /* kuang ou => kuan gou */
    { &pinyin_table[268],  &pinyin_table[0],    &pinyin_table[258],  &pinyin_table[342],  }, /* kun a => ku na */
    { &pinyin_table[268],  &pinyin_table[4],    &pinyin_table[258],  &pinyin_table[346],  }, /* kun an => ku nan */
    { &pinyin_table[268],  &pinyin_table[5],    &pinyin_table[258],  &pinyin_table[347],  }, /* kun ang => ku nang */
    { &pinyin_table[268],  &pinyin_table[6],    &pinyin_table[258],  &pinyin_table[348],  }, /* kun ao => ku nao */
    { &pinyin_table[268],  &pinyin_table[125],  &pinyin_table[258],  &pinyin_table[349],  }, /* kun e => ku ne */
    { &pinyin_table[268],  &pinyin_table[126],  &pinyin_table[258],  &pinyin_table[351],  }, /* kun ei => ku nei */
    { &pinyin_table[275],  &pinyin_table[0],    &pinyin_table[271],  &pinyin_table[342],  }, /* lan a => la na */
    { &pinyin_table[275],  &pinyin_table[4],    &pinyin_table[271],  &pinyin_table[346],  }, /* lan an => la nan */
    { &pinyin_table[275],  &pinyin_table[5],    &pinyin_table[271],  &pinyin_table[347],  }, /* lan ang => la nang */
    { &pinyin_table[275],  &pinyin_table[6],    &pinyin_table[271],  &pinyin_table[348],  }, /* lan ao => la nao */
    { &pinyin_table[275],  &pinyin_table[125],  &pinyin_table[271],  &pinyin_table[349],  }, /* lan e => la ne */
    { &pinyin_table[275],  &pinyin_table[126],  &pinyin_table[271],  &pinyin_table[351],  }, /* lan ei => la nei */
    { &pinyin_table[276],  &pinyin_table[2],    &pinyin_table[275],  &pinyin_table[157],  }, /* lang ai => lan gai */
    { &pinyin_table[276],  &pinyin_table[4],    &pinyin_table[275],  &pinyin_table[159],  }, /* lang an => lan gan */
    { &pinyin_table[276],  &pinyin_table[5],    &pinyin_table[275],  &pinyin_table[160],  }, /* lang ang => lan gang */
    { &pinyin_table[276],  &pinyin_table[6],    &pinyin_table[275],  &pinyin_table[161],  }, /* lang ao => lan gao */
    { &pinyin_table[276],  &pinyin_table[125],  &pinyin_table[275],  &pinyin_table[162],  }, /* lang e => lan ge */
    { &pinyin_table[276],  &pinyin_table[126],  &pinyin_table[275],  &pinyin_table[164],  }, /* lang ei => lan gei */
    { &pinyin_table[276],  &pinyin_table[127],  &pinyin_table[275],  &pinyin_table[166],  }, /* lang en => lan gen */
    { &pinyin_table[276],  &pinyin_table[383],  &pinyin_table[275],  &pinyin_table[171],  }, /* lang ou => lan gou */
    { &pinyin_table[288],  &pinyin_table[126],  &pinyin_table[285],  &pinyin_table[351],  }, /* lian ei => lia nei */
    { &pinyin_table[289],  &pinyin_table[2],    &pinyin_table[288],  &pinyin_table[157],  }, /* liang ai => lian gai */
    { &pinyin_table[289],  &pinyin_table[5],    &pinyin_table[288],  &pinyin_table[160],  }, /* liang ang => lian gang */
    { &pinyin_table[289],  &pinyin_table[6],    &pinyin_table[288],  &pinyin_table[161],  }, /* liang ao => lian gao */
    { &pinyin_table[289],  &pinyin_table[125],  &pinyin_table[288],  &pinyin_table[162],  }, /* liang e => lian ge */
    { &pinyin_table[289],  &pinyin_table[126],  &pinyin_table[288],  &pinyin_table[164],  }, /* liang ei => lian gei */
    { &pinyin_table[289],  &pinyin_table[127],  &pinyin_table[288],  &pinyin_table[166],  }, /* liang en => lian gen */
    { &pinyin_table[291],  &pinyin_table[434],  &pinyin_table[284],  &pinyin_table[128],  }, /* lie r => li er */
    { &pinyin_table[294],  &pinyin_table[0],    &pinyin_table[284],  &pinyin_table[342],  }, /* lin a => li na */
    { &pinyin_table[294],  &pinyin_table[5],    &pinyin_table[284],  &pinyin_table[347],  }, /* lin ang => li nang */
    { &pinyin_table[294],  &pinyin_table[6],    &pinyin_table[284],  &pinyin_table[348],  }, /* lin ao => li nao */
    { &pinyin_table[294],  &pinyin_table[125],  &pinyin_table[284],  &pinyin_table[349],  }, /* lin e => li ne */
    { &pinyin_table[294],  &pinyin_table[126],  &pinyin_table[284],  &pinyin_table[351],  }, /* lin ei => li nei */
    { &pinyin_table[295],  &pinyin_table[2],    &pinyin_table[294],  &pinyin_table[157],  }, /* ling ai => lin gai */
    { &pinyin_table[295],  &pinyin_table[4],    &pinyin_table[294],  &pinyin_table[159],  }, /* ling an => lin gan */
    { &pinyin_table[295],  &pinyin_table[5],    &pinyin_table[294],  &pinyin_table[160],  }, /* ling ang => lin gang */
    { &pinyin_table[295],  &pinyin_table[6],    &pinyin_table[294],  &pinyin_table[161],  }, /* ling ao => lin gao */
    { &pinyin_table[295],  &pinyin_table[125],  &pinyin_table[294],  &pinyin_table[162],  }, /* ling e => lin ge */
    { &pinyin_table[295],  &pinyin_table[126],  &pinyin_table[294],  &pinyin_table[164],  }, /* ling ei => lin gei */
    { &pinyin_table[306],  &pinyin_table[434],  &pinyin_table[303],  &pinyin_table[128],  }, /* lue r => lu er */
    { &pinyin_table[309],  &pinyin_table[0],    &pinyin_table[303],  &pinyin_table[342],  }, /* lun a => lu na */
    { &pinyin_table[309],  &pinyin_table[4],    &pinyin_table[303],  &pinyin_table[346],  }, /* lun an => lu nan */
    { &pinyin_table[309],  &pinyin_table[5],    &pinyin_table[303],  &pinyin_table[347],  }, /* lun ang => lu nang */
    { &pinyin_table[309],  &pinyin_table[6],    &pinyin_table[303],  &pinyin_table[348],  }, /* lun ao => lu nao */
    { &pinyin_table[309],  &pinyin_table[125],  &pinyin_table[303],  &pinyin_table[349],  }, /* lun e => lu ne */
    { &pinyin_table[309],  &pinyin_table[126],  &pinyin_table[303],  &pinyin_table[351],  }, /* lun ei => lu nei */
    { &pinyin_table[318],  &pinyin_table[0],    &pinyin_table[314],  &pinyin_table[342],  }, /* man a => ma na */
    { &pinyin_table[318],  &pinyin_table[4],    &pinyin_table[314],  &pinyin_table[346],  }, /* man an => ma nan */
    { &pinyin_table[318],  &pinyin_table[5],    &pinyin_table[314],  &pinyin_table[347],  }, /* man ang => ma nang */
    { &pinyin_table[318],  &pinyin_table[6],    &pinyin_table[314],  &pinyin_table[348],  }, /* man ao => ma nao */
    { &pinyin_table[318],  &pinyin_table[125],  &pinyin_table[314],  &pinyin_table[349],  }, /* man e => ma ne */
    { &pinyin_table[318],  &pinyin_table[126],  &pinyin_table[314],  &pinyin_table[351],  }, /* man ei => ma nei */
    { &pinyin_table[319],  &pinyin_table[5],    &pinyin_table[318],  &pinyin_table[160],  }, /* mang ang => man gang */
    { &pinyin_table[319],  &pinyin_table[6],    &pinyin_table[318],  &pinyin_table[161],  }, /* mang ao => man gao */
    { &pinyin_table[319],  &pinyin_table[125],  &pinyin_table[318],  &pinyin_table[162],  }, /* mang e => man ge */
    { &pinyin_table[319],  &pinyin_table[126],  &pinyin_table[318],  &pinyin_table[164],  }, /* mang ei => man gei */
    { &pinyin_table[325],  &pinyin_table[0],    &pinyin_table[321],  &pinyin_table[342],  }, /* men a => me na */
    { &pinyin_table[325],  &pinyin_table[125],  &pinyin_table[321],  &pinyin_table[349],  }, /* men e => me ne */
    { &pinyin_table[325],  &pinyin_table[126],  &pinyin_table[321],  &pinyin_table[351],  }, /* men ei => me nei */
    { &pinyin_table[326],  &pinyin_table[2],    &pinyin_table[325],  &pinyin_table[157],  }, /* meng ai => men gai */
    { &pinyin_table[326],  &pinyin_table[4],    &pinyin_table[325],  &pinyin_table[159],  }, /* meng an => men gan */
    { &pinyin_table[326],  &pinyin_table[5],    &pinyin_table[325],  &pinyin_table[160],  }, /* meng ang => men gang */
    { &pinyin_table[326],  &pinyin_table[6],    &pinyin_table[325],  &pinyin_table[161],  }, /* meng ao => men gao */
    { &pinyin_table[326],  &pinyin_table[125],  &pinyin_table[325],  &pinyin_table[162],  }, /* meng e => men ge */
    { &pinyin_table[326],  &pinyin_table[126],  &pinyin_table[325],  &pinyin_table[164],  }, /* meng ei => men gei */
    { &pinyin_table[326],  &pinyin_table[127],  &pinyin_table[325],  &pinyin_table[166],  }, /* meng en => men gen */
    { &pinyin_table[326],  &pinyin_table[383],  &pinyin_table[325],  &pinyin_table[171],  }, /* meng ou => men gou */
    { &pinyin_table[331],  &pinyin_table[434],  &pinyin_table[327],  &pinyin_table[128],  }, /* mie r => mi er */
    { &pinyin_table[334],  &pinyin_table[0],    &pinyin_table[327],  &pinyin_table[342],  }, /* min a => mi na */
    { &pinyin_table[334],  &pinyin_table[4],    &pinyin_table[327],  &pinyin_table[346],  }, /* min an => mi nan */
    { &pinyin_table[334],  &pinyin_table[5],    &pinyin_table[327],  &pinyin_table[347],  }, /* min ang => mi nang */
    { &pinyin_table[334],  &pinyin_table[6],    &pinyin_table[327],  &pinyin_table[348],  }, /* min ao => mi nao */
    { &pinyin_table[334],  &pinyin_table[125],  &pinyin_table[327],  &pinyin_table[349],  }, /* min e => mi ne */
    { &pinyin_table[334],  &pinyin_table[126],  &pinyin_table[327],  &pinyin_table[351],  }, /* min ei => mi nei */
    { &pinyin_table[335],  &pinyin_table[4],    &pinyin_table[334],  &pinyin_table[159],  }, /* ming an => min gan */
    { &pinyin_table[335],  &pinyin_table[5],    &pinyin_table[334],  &pinyin_table[160],  }, /* ming ang => min gang */
    { &pinyin_table[335],  &pinyin_table[6],    &pinyin_table[334],  &pinyin_table[161],  }, /* ming ao => min gao */
    { &pinyin_table[335],  &pinyin_table[126],  &pinyin_table[334],  &pinyin_table[164],  }, /* ming ei => min gei */
    { &pinyin_table[346],  &pinyin_table[0],    &pinyin_table[342],  &pinyin_table[342],  }, /* nan a => na na */
    { &pinyin_table[346],  &pinyin_table[5],    &pinyin_table[342],  &pinyin_table[347],  }, /* nan ang => na nang */
    { &pinyin_table[346],  &pinyin_table[125],  &pinyin_table[342],  &pinyin_table[349],  }, /* nan e => na ne */
    { &pinyin_table[346],  &pinyin_table[126],  &pinyin_table[342],  &pinyin_table[351],  }, /* nan ei => na nei */
    { &pinyin_table[347],  &pinyin_table[0],    &pinyin_table[346],  &pinyin_table[155],  }, /* nang a => nan ga */
    { &pinyin_table[347],  &pinyin_table[2],    &pinyin_table[346],  &pinyin_table[157],  }, /* nang ai => nan gai */
    { &pinyin_table[347],  &pinyin_table[4],    &pinyin_table[346],  &pinyin_table[159],  }, /* nang an => nan gan */
    { &pinyin_table[347],  &pinyin_table[5],    &pinyin_table[346],  &pinyin_table[160],  }, /* nang ang => nan gang */
    { &pinyin_table[347],  &pinyin_table[6],    &pinyin_table[346],  &pinyin_table[161],  }, /* nang ao => nan gao */
    { &pinyin_table[347],  &pinyin_table[125],  &pinyin_table[346],  &pinyin_table[162],  }, /* nang e => nan ge */
    { &pinyin_table[347],  &pinyin_table[126],  &pinyin_table[346],  &pinyin_table[164],  }, /* nang ei => nan gei */
    { &pinyin_table[347],  &pinyin_table[127],  &pinyin_table[346],  &pinyin_table[166],  }, /* nang en => nan gen */
    { &pinyin_table[347],  &pinyin_table[383],  &pinyin_table[346],  &pinyin_table[171],  }, /* nang ou => nan gou */
    { &pinyin_table[353],  &pinyin_table[0],    &pinyin_table[349],  &pinyin_table[342],  }, /* nen a => ne na */
    { &pinyin_table[353],  &pinyin_table[2],    &pinyin_table[349],  &pinyin_table[344],  }, /* nen ai => ne nai */
    { &pinyin_table[353],  &pinyin_table[4],    &pinyin_table[349],  &pinyin_table[346],  }, /* nen an => ne nan */
    { &pinyin_table[353],  &pinyin_table[5],    &pinyin_table[349],  &pinyin_table[347],  }, /* nen ang => ne nang */
    { &pinyin_table[353],  &pinyin_table[6],    &pinyin_table[349],  &pinyin_table[348],  }, /* nen ao => ne nao */
    { &pinyin_table[353],  &pinyin_table[125],  &pinyin_table[349],  &pinyin_table[349],  }, /* nen e => ne ne */
    { &pinyin_table[353],  &pinyin_table[126],  &pinyin_table[349],  &pinyin_table[351],  }, /* nen ei => ne nei */
    { &pinyin_table[353],  &pinyin_table[127],  &pinyin_table[349],  &pinyin_table[353],  }, /* nen en => ne nen */
    { &pinyin_table[354],  &pinyin_table[5],    &pinyin_table[353],  &pinyin_table[160],  }, /* neng ang => nen gang */
    { &pinyin_table[354],  &pinyin_table[126],  &pinyin_table[353],  &pinyin_table[164],  }, /* neng ei => nen gei */
    { &pinyin_table[360],  &pinyin_table[0],    &pinyin_table[359],  &pinyin_table[155],  }, /* niang a => nian ga */
    { &pinyin_table[360],  &pinyin_table[2],    &pinyin_table[359],  &pinyin_table[157],  }, /* niang ai => nian gai */
    { &pinyin_table[360],  &pinyin_table[4],    &pinyin_table[359],  &pinyin_table[159],  }, /* niang an => nian gan */
    { &pinyin_table[360],  &pinyin_table[5],    &pinyin_table[359],  &pinyin_table[160],  }, /* niang ang => nian gang */
    { &pinyin_table[360],  &pinyin_table[6],    &pinyin_table[359],  &pinyin_table[161],  }, /* niang ao => nian gao */
    { &pinyin_table[360],  &pinyin_table[125],  &pinyin_table[359],  &pinyin_table[162],  }, /* niang e => nian ge */
    { &pinyin_table[360],  &pinyin_table[126],  &pinyin_table[359],  &pinyin_table[164],  }, /* niang ei => nian gei */
    { &pinyin_table[360],  &pinyin_table[127],  &pinyin_table[359],  &pinyin_table[166],  }, /* niang en => nian gen */
    { &pinyin_table[360],  &pinyin_table[383],  &pinyin_table[359],  &pinyin_table[171],  }, /* niang ou => nian gou */
    { &pinyin_table[362],  &pinyin_table[434],  &pinyin_table[355],  &pinyin_table[128],  }, /* nie r => ni er */
    { &pinyin_table[365],  &pinyin_table[0],    &pinyin_table[355],  &pinyin_table[342],  }, /* nin a => ni na */
    { &pinyin_table[365],  &pinyin_table[4],    &pinyin_table[355],  &pinyin_table[346],  }, /* nin an => ni nan */
    { &pinyin_table[365],  &pinyin_table[6],    &pinyin_table[355],  &pinyin_table[348],  }, /* nin ao => ni nao */
    { &pinyin_table[365],  &pinyin_table[125],  &pinyin_table[355],  &pinyin_table[349],  }, /* nin e => ni ne */
    { &pinyin_table[365],  &pinyin_table[126],  &pinyin_table[355],  &pinyin_table[351],  }, /* nin ei => ni nei */
    { &pinyin_table[366],  &pinyin_table[0],    &pinyin_table[365],  &pinyin_table[155],  }, /* ning a => nin ga */
    { &pinyin_table[366],  &pinyin_table[2],    &pinyin_table[365],  &pinyin_table[157],  }, /* ning ai => nin gai */
    { &pinyin_table[366],  &pinyin_table[4],    &pinyin_table[365],  &pinyin_table[159],  }, /* ning an => nin gan */
    { &pinyin_table[366],  &pinyin_table[5],    &pinyin_table[365],  &pinyin_table[160],  }, /* ning ang => nin gang */
    { &pinyin_table[366],  &pinyin_table[6],    &pinyin_table[365],  &pinyin_table[161],  }, /* ning ao => nin gao */
    { &pinyin_table[366],  &pinyin_table[125],  &pinyin_table[365],  &pinyin_table[162],  }, /* ning e => nin ge */
    { &pinyin_table[366],  &pinyin_table[126],  &pinyin_table[365],  &pinyin_table[164],  }, /* ning ei => nin gei */
    { &pinyin_table[366],  &pinyin_table[127],  &pinyin_table[365],  &pinyin_table[166],  }, /* ning en => nin gen */
    { &pinyin_table[366],  &pinyin_table[383],  &pinyin_table[365],  &pinyin_table[171],  }, /* ning ou => nin gou */
    { &pinyin_table[377],  &pinyin_table[434],  &pinyin_table[374],  &pinyin_table[128],  }, /* nue r => nu er */
    { &pinyin_table[389],  &pinyin_table[0],    &pinyin_table[385],  &pinyin_table[342],  }, /* pan a => pa na */
    { &pinyin_table[389],  &pinyin_table[4],    &pinyin_table[385],  &pinyin_table[346],  }, /* pan an => pa nan */
    { &pinyin_table[389],  &pinyin_table[6],    &pinyin_table[385],  &pinyin_table[348],  }, /* pan ao => pa nao */
    { &pinyin_table[389],  &pinyin_table[125],  &pinyin_table[385],  &pinyin_table[349],  }, /* pan e => pa ne */
    { &pinyin_table[389],  &pinyin_table[126],  &pinyin_table[385],  &pinyin_table[351],  }, /* pan ei => pa nei */
    { &pinyin_table[390],  &pinyin_table[2],    &pinyin_table[389],  &pinyin_table[157],  }, /* pang ai => pan gai */
    { &pinyin_table[390],  &pinyin_table[4],    &pinyin_table[389],  &pinyin_table[159],  }, /* pang an => pan gan */
    { &pinyin_table[390],  &pinyin_table[5],    &pinyin_table[389],  &pinyin_table[160],  }, /* pang ang => pan gang */
    { &pinyin_table[390],  &pinyin_table[6],    &pinyin_table[389],  &pinyin_table[161],  }, /* pang ao => pan gao */
    { &pinyin_table[390],  &pinyin_table[125],  &pinyin_table[389],  &pinyin_table[162],  }, /* pang e => pan ge */
    { &pinyin_table[390],  &pinyin_table[126],  &pinyin_table[389],  &pinyin_table[164],  }, /* pang ei => pan gei */
    { &pinyin_table[390],  &pinyin_table[127],  &pinyin_table[389],  &pinyin_table[166],  }, /* pang en => pan gen */
    { &pinyin_table[390],  &pinyin_table[383],  &pinyin_table[389],  &pinyin_table[171],  }, /* pang ou => pan gou */
    { &pinyin_table[396],  &pinyin_table[5],    &pinyin_table[395],  &pinyin_table[160],  }, /* peng ang => pen gang */
    { &pinyin_table[396],  &pinyin_table[6],    &pinyin_table[395],  &pinyin_table[161],  }, /* peng ao => pen gao */
    { &pinyin_table[396],  &pinyin_table[125],  &pinyin_table[395],  &pinyin_table[162],  }, /* peng e => pen ge */
    { &pinyin_table[396],  &pinyin_table[126],  &pinyin_table[395],  &pinyin_table[164],  }, /* peng ei => pen gei */
    { &pinyin_table[401],  &pinyin_table[434],  &pinyin_table[397],  &pinyin_table[128],  }, /* pie r => pi er */
    { &pinyin_table[404],  &pinyin_table[0],    &pinyin_table[397],  &pinyin_table[342],  }, /* pin a => pi na */
    { &pinyin_table[404],  &pinyin_table[125],  &pinyin_table[397],  &pinyin_table[349],  }, /* pin e => pi ne */
    { &pinyin_table[404],  &pinyin_table[126],  &pinyin_table[397],  &pinyin_table[351],  }, /* pin ei => pi nei */
    { &pinyin_table[405],  &pinyin_table[5],    &pinyin_table[404],  &pinyin_table[160],  }, /* ping ang => pin gang */
    { &pinyin_table[405],  &pinyin_table[6],    &pinyin_table[404],  &pinyin_table[161],  }, /* ping ao => pin gao */
    { &pinyin_table[405],  &pinyin_table[125],  &pinyin_table[404],  &pinyin_table[162],  }, /* ping e => pin ge */
    { &pinyin_table[405],  &pinyin_table[126],  &pinyin_table[404],  &pinyin_table[164],  }, /* ping ei => pin gei */
    { &pinyin_table[415],  &pinyin_table[2],    &pinyin_table[414],  &pinyin_table[157],  }, /* qiang ai => qian gai */
    { &pinyin_table[415],  &pinyin_table[4],    &pinyin_table[414],  &pinyin_table[159],  }, /* qiang an => qian gan */
    { &pinyin_table[415],  &pinyin_table[5],    &pinyin_table[414],  &pinyin_table[160],  }, /* qiang ang => qian gang */
    { &pinyin_table[415],  &pinyin_table[6],    &pinyin_table[414],  &pinyin_table[161],  }, /* qiang ao => qian gao */
    { &pinyin_table[415],  &pinyin_table[125],  &pinyin_table[414],  &pinyin_table[162],  }, /* qiang e => qian ge */
    { &pinyin_table[415],  &pinyin_table[126],  &pinyin_table[414],  &pinyin_table[164],  }, /* qiang ei => qian gei */
    { &pinyin_table[415],  &pinyin_table[127],  &pinyin_table[414],  &pinyin_table[166],  }, /* qiang en => qian gen */
    { &pinyin_table[415],  &pinyin_table[383],  &pinyin_table[414],  &pinyin_table[171],  }, /* qiang ou => qian gou */
    { &pinyin_table[417],  &pinyin_table[434],  &pinyin_table[410],  &pinyin_table[128],  }, /* qie r => qi er */
    { &pinyin_table[420],  &pinyin_table[0],    &pinyin_table[410],  &pinyin_table[342],  }, /* qin a => qi na */
    { &pinyin_table[420],  &pinyin_table[4],    &pinyin_table[410],  &pinyin_table[346],  }, /* qin an => qi nan */
    { &pinyin_table[420],  &pinyin_table[5],    &pinyin_table[410],  &pinyin_table[347],  }, /* qin ang => qi nang */
    { &pinyin_table[420],  &pinyin_table[6],    &pinyin_table[410],  &pinyin_table[348],  }, /* qin ao => qi nao */
    { &pinyin_table[420],  &pinyin_table[125],  &pinyin_table[410],  &pinyin_table[349],  }, /* qin e => qi ne */
    { &pinyin_table[420],  &pinyin_table[126],  &pinyin_table[410],  &pinyin_table[351],  }, /* qin ei => qi nei */
    { &pinyin_table[421],  &pinyin_table[5],    &pinyin_table[420],  &pinyin_table[160],  }, /* qing ang => qin gang */
    { &pinyin_table[421],  &pinyin_table[6],    &pinyin_table[420],  &pinyin_table[161],  }, /* qing ao => qin gao */
    { &pinyin_table[421],  &pinyin_table[126],  &pinyin_table[420],  &pinyin_table[164],  }, /* qing ei => qin gei */
    { &pinyin_table[430],  &pinyin_table[434],  &pinyin_table[427],  &pinyin_table[128],  }, /* que r => qu er */
    { &pinyin_table[432],  &pinyin_table[0],    &pinyin_table[427],  &pinyin_table[342],  }, /* qun a => qu na */
    { &pinyin_table[432],  &pinyin_table[4],    &pinyin_table[427],  &pinyin_table[346],  }, /* qun an => qu nan */
    { &pinyin_table[432],  &pinyin_table[5],    &pinyin_table[427],  &pinyin_table[347],  }, /* qun ang => qu nang */
    { &pinyin_table[432],  &pinyin_table[6],    &pinyin_table[427],  &pinyin_table[348],  }, /* qun ao => qu nao */
    { &pinyin_table[432],  &pinyin_table[125],  &pinyin_table[427],  &pinyin_table[349],  }, /* qun e => qu ne */
    { &pinyin_table[432],  &pinyin_table[126],  &pinyin_table[427],  &pinyin_table[351],  }, /* qun ei => qu nei */
    { &pinyin_table[440],  &pinyin_table[5],    &pinyin_table[439],  &pinyin_table[160],  }, /* rang ang => ran gang */
    { &pinyin_table[440],  &pinyin_table[126],  &pinyin_table[439],  &pinyin_table[164],  }, /* rang ei => ran gei */
    { &pinyin_table[446],  &pinyin_table[6],    &pinyin_table[442],  &pinyin_table[348],  }, /* ren ao => re nao */
    { &pinyin_table[446],  &pinyin_table[125],  &pinyin_table[442],  &pinyin_table[349],  }, /* ren e => re ne */
    { &pinyin_table[446],  &pinyin_table[126],  &pinyin_table[442],  &pinyin_table[351],  }, /* ren ei => re nei */
    { &pinyin_table[447],  &pinyin_table[2],    &pinyin_table[446],  &pinyin_table[157],  }, /* reng ai => ren gai */
    { &pinyin_table[447],  &pinyin_table[4],    &pinyin_table[446],  &pinyin_table[159],  }, /* reng an => ren gan */
    { &pinyin_table[447],  &pinyin_table[5],    &pinyin_table[446],  &pinyin_table[160],  }, /* reng ang => ren gang */
    { &pinyin_table[447],  &pinyin_table[6],    &pinyin_table[446],  &pinyin_table[161],  }, /* reng ao => ren gao */
    { &pinyin_table[447],  &pinyin_table[125],  &pinyin_table[446],  &pinyin_table[162],  }, /* reng e => ren ge */
    { &pinyin_table[447],  &pinyin_table[126],  &pinyin_table[446],  &pinyin_table[164],  }, /* reng ei => ren gei */
    { &pinyin_table[447],  &pinyin_table[127],  &pinyin_table[446],  &pinyin_table[166],  }, /* reng en => ren gen */
    { &pinyin_table[447],  &pinyin_table[383],  &pinyin_table[446],  &pinyin_table[171],  }, /* reng ou => ren gou */
    { &pinyin_table[469],  &pinyin_table[0],    &pinyin_table[462],  &pinyin_table[342],  }, /* run a => ru na */
    { &pinyin_table[469],  &pinyin_table[2],    &pinyin_table[462],  &pinyin_table[344],  }, /* run ai => ru nai */
    { &pinyin_table[469],  &pinyin_table[4],    &pinyin_table[462],  &pinyin_table[346],  }, /* run an => ru nan */
    { &pinyin_table[469],  &pinyin_table[5],    &pinyin_table[462],  &pinyin_table[347],  }, /* run ang => ru nang */
    { &pinyin_table[469],  &pinyin_table[6],    &pinyin_table[462],  &pinyin_table[348],  }, /* run ao => ru nao */
    { &pinyin_table[469],  &pinyin_table[125],  &pinyin_table[462],  &pinyin_table[349],  }, /* run e => ru ne */
    { &pinyin_table[469],  &pinyin_table[126],  &pinyin_table[462],  &pinyin_table[351],  }, /* run ei => ru nei */
    { &pinyin_table[469],  &pinyin_table[127],  &pinyin_table[462],  &pinyin_table[353],  }, /* run en => ru nen */
    { &pinyin_table[477],  &pinyin_table[125],  &pinyin_table[473],  &pinyin_table[349],  }, /* san e => sa ne */
    { &pinyin_table[477],  &pinyin_table[126],  &pinyin_table[473],  &pinyin_table[351],  }, /* san ei => sa nei */
    { &pinyin_table[478],  &pinyin_table[0],    &pinyin_table[477],  &pinyin_table[155],  }, /* sang a => san ga */
    { &pinyin_table[478],  &pinyin_table[2],    &pinyin_table[477],  &pinyin_table[157],  }, /* sang ai => san gai */
    { &pinyin_table[478],  &pinyin_table[4],    &pinyin_table[477],  &pinyin_table[159],  }, /* sang an => san gan */
    { &pinyin_table[478],  &pinyin_table[5],    &pinyin_table[477],  &pinyin_table[160],  }, /* sang ang => san gang */
    { &pinyin_table[478],  &pinyin_table[6],    &pinyin_table[477],  &pinyin_table[161],  }, /* sang ao => san gao */
    { &pinyin_table[478],  &pinyin_table[125],  &pinyin_table[477],  &pinyin_table[162],  }, /* sang e => san ge */
    { &pinyin_table[478],  &pinyin_table[126],  &pinyin_table[477],  &pinyin_table[164],  }, /* sang ei => san gei */
    { &pinyin_table[478],  &pinyin_table[127],  &pinyin_table[477],  &pinyin_table[166],  }, /* sang en => san gen */
    { &pinyin_table[478],  &pinyin_table[383],  &pinyin_table[477],  &pinyin_table[171],  }, /* sang ou => san gou */
    { &pinyin_table[484],  &pinyin_table[0],    &pinyin_table[480],  &pinyin_table[342],  }, /* sen a => se na */
    { &pinyin_table[484],  &pinyin_table[4],    &pinyin_table[480],  &pinyin_table[346],  }, /* sen an => se nan */
    { &pinyin_table[484],  &pinyin_table[5],    &pinyin_table[480],  &pinyin_table[347],  }, /* sen ang => se nang */
    { &pinyin_table[484],  &pinyin_table[6],    &pinyin_table[480],  &pinyin_table[348],  }, /* sen ao => se nao */
    { &pinyin_table[484],  &pinyin_table[125],  &pinyin_table[480],  &pinyin_table[349],  }, /* sen e => se ne */
    { &pinyin_table[484],  &pinyin_table[126],  &pinyin_table[480],  &pinyin_table[351],  }, /* sen ei => se nei */
    { &pinyin_table[485],  &pinyin_table[2],    &pinyin_table[484],  &pinyin_table[157],  }, /* seng ai => sen gai */
    { &pinyin_table[485],  &pinyin_table[4],    &pinyin_table[484],  &pinyin_table[159],  }, /* seng an => sen gan */
    { &pinyin_table[485],  &pinyin_table[5],    &pinyin_table[484],  &pinyin_table[160],  }, /* seng ang => sen gang */
    { &pinyin_table[485],  &pinyin_table[6],    &pinyin_table[484],  &pinyin_table[161],  }, /* seng ao => sen gao */
    { &pinyin_table[485],  &pinyin_table[125],  &pinyin_table[484],  &pinyin_table[162],  }, /* seng e => sen ge */
    { &pinyin_table[485],  &pinyin_table[126],  &pinyin_table[484],  &pinyin_table[164],  }, /* seng ei => sen gei */
    { &pinyin_table[485],  &pinyin_table[127],  &pinyin_table[484],  &pinyin_table[166],  }, /* seng en => sen gen */
    { &pinyin_table[485],  &pinyin_table[383],  &pinyin_table[484],  &pinyin_table[171],  }, /* seng ou => sen gou */
    { &pinyin_table[491],  &pinyin_table[0],    &pinyin_table[487],  &pinyin_table[342],  }, /* shan a => sha na */
    { &pinyin_table[491],  &pinyin_table[4],    &pinyin_table[487],  &pinyin_table[346],  }, /* shan an => sha nan */
    { &pinyin_table[491],  &pinyin_table[5],    &pinyin_table[487],  &pinyin_table[347],  }, /* shan ang => sha nang */
    { &pinyin_table[491],  &pinyin_table[6],    &pinyin_table[487],  &pinyin_table[348],  }, /* shan ao => sha nao */
    { &pinyin_table[491],  &pinyin_table[126],  &pinyin_table[487],  &pinyin_table[351],  }, /* shan ei => sha nei */
    { &pinyin_table[492],  &pinyin_table[5],    &pinyin_table[491],  &pinyin_table[160],  }, /* shang ang => shan gang */
    { &pinyin_table[492],  &pinyin_table[6],    &pinyin_table[491],  &pinyin_table[161],  }, /* shang ao => shan gao */
    { &pinyin_table[492],  &pinyin_table[125],  &pinyin_table[491],  &pinyin_table[162],  }, /* shang e => shan ge */
    { &pinyin_table[492],  &pinyin_table[126],  &pinyin_table[491],  &pinyin_table[164],  }, /* shang ei => shan gei */
    { &pinyin_table[492],  &pinyin_table[383],  &pinyin_table[491],  &pinyin_table[171],  }, /* shang ou => shan gou */
    { &pinyin_table[498],  &pinyin_table[125],  &pinyin_table[494],  &pinyin_table[349],  }, /* shen e => she ne */
    { &pinyin_table[498],  &pinyin_table[126],  &pinyin_table[494],  &pinyin_table[351],  }, /* shen ei => she nei */
    { &pinyin_table[499],  &pinyin_table[4],    &pinyin_table[498],  &pinyin_table[159],  }, /* sheng an => shen gan */
    { &pinyin_table[499],  &pinyin_table[5],    &pinyin_table[498],  &pinyin_table[160],  }, /* sheng ang => shen gang */
    { &pinyin_table[499],  &pinyin_table[6],    &pinyin_table[498],  &pinyin_table[161],  }, /* sheng ao => shen gao */
    { &pinyin_table[499],  &pinyin_table[125],  &pinyin_table[498],  &pinyin_table[162],  }, /* sheng e => shen ge */
    { &pinyin_table[499],  &pinyin_table[126],  &pinyin_table[498],  &pinyin_table[164],  }, /* sheng ei => shen gei */
    { &pinyin_table[499],  &pinyin_table[383],  &pinyin_table[498],  &pinyin_table[171],  }, /* sheng ou => shen gou */
    { &pinyin_table[508],  &pinyin_table[0],    &pinyin_table[504],  &pinyin_table[342],  }, /* shuan a => shua na */
    { &pinyin_table[508],  &pinyin_table[2],    &pinyin_table[504],  &pinyin_table[344],  }, /* shuan ai => shua nai */
    { &pinyin_table[508],  &pinyin_table[4],    &pinyin_table[504],  &pinyin_table[346],  }, /* shuan an => shua nan */
    { &pinyin_table[508],  &pinyin_table[5],    &pinyin_table[504],  &pinyin_table[347],  }, /* shuan ang => shua nang */
    { &pinyin_table[508],  &pinyin_table[6],    &pinyin_table[504],  &pinyin_table[348],  }, /* shuan ao => shua nao */
    { &pinyin_table[508],  &pinyin_table[125],  &pinyin_table[504],  &pinyin_table[349],  }, /* shuan e => shua ne */
    { &pinyin_table[508],  &pinyin_table[126],  &pinyin_table[504],  &pinyin_table[351],  }, /* shuan ei => shua nei */
    { &pinyin_table[508],  &pinyin_table[127],  &pinyin_table[504],  &pinyin_table[353],  }, /* shuan en => shua nen */
    { &pinyin_table[513],  &pinyin_table[0],    &pinyin_table[503],  &pinyin_table[342],  }, /* shun a => shu na */
    { &pinyin_table[513],  &pinyin_table[4],    &pinyin_table[503],  &pinyin_table[346],  }, /* shun an => shu nan */
    { &pinyin_table[513],  &pinyin_table[5],    &pinyin_table[503],  &pinyin_table[347],  }, /* shun ang => shu nang */
    { &pinyin_table[513],  &pinyin_table[6],    &pinyin_table[503],  &pinyin_table[348],  }, /* shun ao => shu nao */
    { &pinyin_table[513],  &pinyin_table[125],  &pinyin_table[503],  &pinyin_table[349],  }, /* shun e => shu ne */
    { &pinyin_table[513],  &pinyin_table[126],  &pinyin_table[503],  &pinyin_table[351],  }, /* shun ei => shu nei */
    { &pinyin_table[528],  &pinyin_table[0],    &pinyin_table[520],  &pinyin_table[342],  }, /* sun a => su na */
    { &pinyin_table[528],  &pinyin_table[4],    &pinyin_table[520],  &pinyin_table[346],  }, /* sun an => su nan */
    { &pinyin_table[528],  &pinyin_table[125],  &pinyin_table[520],  &pinyin_table[349],  }, /* sun e => su ne */
    { &pinyin_table[528],  &pinyin_table[126],  &pinyin_table[520],  &pinyin_table[351],  }, /* sun ei => su nei */
    { &pinyin_table[535],  &pinyin_table[0],    &pinyin_table[531],  &pinyin_table[342],  }, /* tan a => ta na */
    { &pinyin_table[535],  &pinyin_table[4],    &pinyin_table[531],  &pinyin_table[346],  }, /* tan an => ta nan */
    { &pinyin_table[535],  &pinyin_table[5],    &pinyin_table[531],  &pinyin_table[347],  }, /* tan ang => ta nang */
    { &pinyin_table[535],  &pinyin_table[6],    &pinyin_table[531],  &pinyin_table[348],  }, /* tan ao => ta nao */
    { &pinyin_table[535],  &pinyin_table[125],  &pinyin_table[531],  &pinyin_table[349],  }, /* tan e => ta ne */
    { &pinyin_table[535],  &pinyin_table[126],  &pinyin_table[531],  &pinyin_table[351],  }, /* tan ei => ta nei */
    { &pinyin_table[536],  &pinyin_table[2],    &pinyin_table[535],  &pinyin_table[157],  }, /* tang ai => tan gai */
    { &pinyin_table[536],  &pinyin_table[4],    &pinyin_table[535],  &pinyin_table[159],  }, /* tang an => tan gan */
    { &pinyin_table[536],  &pinyin_table[5],    &pinyin_table[535],  &pinyin_table[160],  }, /* tang ang => tan gang */
    { &pinyin_table[536],  &pinyin_table[6],    &pinyin_table[535],  &pinyin_table[161],  }, /* tang ao => tan gao */
    { &pinyin_table[536],  &pinyin_table[125],  &pinyin_table[535],  &pinyin_table[162],  }, /* tang e => tan ge */
    { &pinyin_table[536],  &pinyin_table[126],  &pinyin_table[535],  &pinyin_table[164],  }, /* tang ei => tan gei */
    { &pinyin_table[536],  &pinyin_table[127],  &pinyin_table[535],  &pinyin_table[166],  }, /* tang en => tan gen */
    { &pinyin_table[536],  &pinyin_table[383],  &pinyin_table[535],  &pinyin_table[171],  }, /* tang ou => tan gou */
    { &pinyin_table[547],  &pinyin_table[434],  &pinyin_table[543],  &pinyin_table[128],  }, /* tie r => ti er */
    { &pinyin_table[562],  &pinyin_table[0],    &pinyin_table[556],  &pinyin_table[342],  }, /* tun a => tu na */
    { &pinyin_table[562],  &pinyin_table[2],    &pinyin_table[556],  &pinyin_table[344],  }, /* tun ai => tu nai */
    { &pinyin_table[562],  &pinyin_table[4],    &pinyin_table[556],  &pinyin_table[346],  }, /* tun an => tu nan */
    { &pinyin_table[562],  &pinyin_table[5],    &pinyin_table[556],  &pinyin_table[347],  }, /* tun ang => tu nang */
    { &pinyin_table[562],  &pinyin_table[6],    &pinyin_table[556],  &pinyin_table[348],  }, /* tun ao => tu nao */
    { &pinyin_table[562],  &pinyin_table[125],  &pinyin_table[556],  &pinyin_table[349],  }, /* tun e => tu ne */
    { &pinyin_table[562],  &pinyin_table[126],  &pinyin_table[556],  &pinyin_table[351],  }, /* tun ei => tu nei */
    { &pinyin_table[562],  &pinyin_table[127],  &pinyin_table[556],  &pinyin_table[353],  }, /* tun en => tu nen */
    { &pinyin_table[569],  &pinyin_table[126],  &pinyin_table[565],  &pinyin_table[351],  }, /* wan ei => wa nei */
    { &pinyin_table[570],  &pinyin_table[2],    &pinyin_table[569],  &pinyin_table[157],  }, /* wang ai => wan gai */
    { &pinyin_table[570],  &pinyin_table[4],    &pinyin_table[569],  &pinyin_table[159],  }, /* wang an => wan gan */
    { &pinyin_table[570],  &pinyin_table[5],    &pinyin_table[569],  &pinyin_table[160],  }, /* wang ang => wan gang */
    { &pinyin_table[570],  &pinyin_table[6],    &pinyin_table[569],  &pinyin_table[161],  }, /* wang ao => wan gao */
    { &pinyin_table[570],  &pinyin_table[125],  &pinyin_table[569],  &pinyin_table[162],  }, /* wang e => wan ge */
    { &pinyin_table[570],  &pinyin_table[126],  &pinyin_table[569],  &pinyin_table[164],  }, /* wang ei => wan gei */
    { &pinyin_table[570],  &pinyin_table[127],  &pinyin_table[569],  &pinyin_table[166],  }, /* wang en => wan gen */
    { &pinyin_table[570],  &pinyin_table[383],  &pinyin_table[569],  &pinyin_table[171],  }, /* wang ou => wan gou */
    { &pinyin_table[575],  &pinyin_table[0],    &pinyin_table[574],  &pinyin_table[155],  }, /* weng a => wen ga */
    { &pinyin_table[575],  &pinyin_table[2],    &pinyin_table[574],  &pinyin_table[157],  }, /* weng ai => wen gai */
    { &pinyin_table[575],  &pinyin_table[4],    &pinyin_table[574],  &pinyin_table[159],  }, /* weng an => wen gan */
    { &pinyin_table[575],  &pinyin_table[5],    &pinyin_table[574],  &pinyin_table[160],  }, /* weng ang => wen gang */
    { &pinyin_table[575],  &pinyin_table[6],    &pinyin_table[574],  &pinyin_table[161],  }, /* weng ao => wen gao */
    { &pinyin_table[575],  &pinyin_table[125],  &pinyin_table[574],  &pinyin_table[162],  }, /* weng e => wen ge */
    { &pinyin_table[575],  &pinyin_table[126],  &pinyin_table[574],  &pinyin_table[164],  }, /* weng ei => wen gei */
    { &pinyin_table[575],  &pinyin_table[127],  &pinyin_table[574],  &pinyin_table[166],  }, /* weng en => wen gen */
    { &pinyin_table[575],  &pinyin_table[383],  &pinyin_table[574],  &pinyin_table[171],  }, /* weng ou => wen gou */
    { &pinyin_table[583],  &pinyin_table[0],    &pinyin_table[580],  &pinyin_table[342],  }, /* xian a => xia na */
    { &pinyin_table[583],  &pinyin_table[126],  &pinyin_table[580],  &pinyin_table[351],  }, /* xian ei => xia nei */
    { &pinyin_table[584],  &pinyin_table[5],    &pinyin_table[583],  &pinyin_table[160],  }, /* xiang ang => xian gang */
    { &pinyin_table[584],  &pinyin_table[6],    &pinyin_table[583],  &pinyin_table[161],  }, /* xiang ao => xian gao */
    { &pinyin_table[584],  &pinyin_table[125],  &pinyin_table[583],  &pinyin_table[162],  }, /* xiang e => xian ge */
    { &pinyin_table[584],  &pinyin_table[126],  &pinyin_table[583],  &pinyin_table[164],  }, /* xiang ei => xian gei */
    { &pinyin_table[586],  &pinyin_table[434],  &pinyin_table[579],  &pinyin_table[128],  }, /* xie r => xi er */
    { &pinyin_table[589],  &pinyin_table[0],    &pinyin_table[579],  &pinyin_table[342],  }, /* xin a => xi na */
    { &pinyin_table[589],  &pinyin_table[4],    &pinyin_table[579],  &pinyin_table[346],  }, /* xin an => xi nan */
    { &pinyin_table[589],  &pinyin_table[6],    &pinyin_table[579],  &pinyin_table[348],  }, /* xin ao => xi nao */
    { &pinyin_table[589],  &pinyin_table[125],  &pinyin_table[579],  &pinyin_table[349],  }, /* xin e => xi ne */
    { &pinyin_table[589],  &pinyin_table[126],  &pinyin_table[579],  &pinyin_table[351],  }, /* xin ei => xi nei */
    { &pinyin_table[589],  &pinyin_table[127],  &pinyin_table[579],  &pinyin_table[353],  }, /* xin en => xi nen */
    { &pinyin_table[590],  &pinyin_table[4],    &pinyin_table[589],  &pinyin_table[159],  }, /* xing an => xin gan */
    { &pinyin_table[590],  &pinyin_table[5],    &pinyin_table[589],  &pinyin_table[160],  }, /* xing ang => xin gang */
    { &pinyin_table[590],  &pinyin_table[6],    &pinyin_table[589],  &pinyin_table[161],  }, /* xing ao => xin gao */
    { &pinyin_table[590],  &pinyin_table[125],  &pinyin_table[589],  &pinyin_table[162],  }, /* xing e => xin ge */
    { &pinyin_table[590],  &pinyin_table[126],  &pinyin_table[589],  &pinyin_table[164],  }, /* xing ei => xin gei */
    { &pinyin_table[590],  &pinyin_table[127],  &pinyin_table[589],  &pinyin_table[166],  }, /* xing en => xin gen */
    { &pinyin_table[599],  &pinyin_table[434],  &pinyin_table[596],  &pinyin_table[128],  }, /* xue r => xu er */
    { &pinyin_table[601],  &pinyin_table[0],    &pinyin_table[596],  &pinyin_table[342],  }, /* xun a => xu na */
    { &pinyin_table[601],  &pinyin_table[4],    &pinyin_table[596],  &pinyin_table[346],  }, /* xun an => xu nan */
    { &pinyin_table[601],  &pinyin_table[5],    &pinyin_table[596],  &pinyin_table[347],  }, /* xun ang => xu nang */
    { &pinyin_table[601],  &pinyin_table[6],    &pinyin_table[596],  &pinyin_table[348],  }, /* xun ao => xu nao */
    { &pinyin_table[601],  &pinyin_table[125],  &pinyin_table[596],  &pinyin_table[349],  }, /* xun e => xu ne */
    { &pinyin_table[601],  &pinyin_table[126],  &pinyin_table[596],  &pinyin_table[351],  }, /* xun ei => xu nei */
    { &pinyin_table[607],  &pinyin_table[0],    &pinyin_table[604],  &pinyin_table[342],  }, /* yan a => ya na */
    { &pinyin_table[607],  &pinyin_table[5],    &pinyin_table[604],  &pinyin_table[347],  }, /* yan ang => ya nang */
    { &pinyin_table[607],  &pinyin_table[6],    &pinyin_table[604],  &pinyin_table[348],  }, /* yan ao => ya nao */
    { &pinyin_table[607],  &pinyin_table[125],  &pinyin_table[604],  &pinyin_table[349],  }, /* yan e => ya ne */
    { &pinyin_table[607],  &pinyin_table[126],  &pinyin_table[604],  &pinyin_table[351],  }, /* yan ei => ya nei */
    { &pinyin_table[608],  &pinyin_table[2],    &pinyin_table[607],  &pinyin_table[157],  }, /* yang ai => yan gai */
    { &pinyin_table[608],  &pinyin_table[5],    &pinyin_table[607],  &pinyin_table[160],  }, /* yang ang => yan gang */
    { &pinyin_table[608],  &pinyin_table[6],    &pinyin_table[607],  &pinyin_table[161],  }, /* yang ao => yan gao */
    { &pinyin_table[608],  &pinyin_table[125],  &pinyin_table[607],  &pinyin_table[162],  }, /* yang e => yan ge */
    { &pinyin_table[608],  &pinyin_table[126],  &pinyin_table[607],  &pinyin_table[164],  }, /* yang ei => yan gei */
    { &pinyin_table[614],  &pinyin_table[0],    &pinyin_table[611],  &pinyin_table[342],  }, /* yin a => yi na */
    { &pinyin_table[614],  &pinyin_table[6],    &pinyin_table[611],  &pinyin_table[348],  }, /* yin ao => yi nao */
    { &pinyin_table[614],  &pinyin_table[125],  &pinyin_table[611],  &pinyin_table[349],  }, /* yin e => yi ne */
    { &pinyin_table[614],  &pinyin_table[126],  &pinyin_table[611],  &pinyin_table[351],  }, /* yin ei => yi nei */
    { &pinyin_table[615],  &pinyin_table[2],    &pinyin_table[614],  &pinyin_table[157],  }, /* ying ai => yin gai */
    { &pinyin_table[615],  &pinyin_table[5],    &pinyin_table[614],  &pinyin_table[160],  }, /* ying ang => yin gang */
    { &pinyin_table[615],  &pinyin_table[6],    &pinyin_table[614],  &pinyin_table[161],  }, /* ying ao => yin gao */
    { &pinyin_table[615],  &pinyin_table[125],  &pinyin_table[614],  &pinyin_table[162],  }, /* ying e => yin ge */
    { &pinyin_table[615],  &pinyin_table[126],  &pinyin_table[614],  &pinyin_table[164],  }, /* ying ei => yin gei */
    { &pinyin_table[624],  &pinyin_table[434],  &pinyin_table[621],  &pinyin_table[128],  }, /* yue r => yu er */
    { &pinyin_table[626],  &pinyin_table[0],    &pinyin_table[621],  &pinyin_table[342],  }, /* yun a => yu na */
    { &pinyin_table[626],  &pinyin_table[4],    &pinyin_table[621],  &pinyin_table[346],  }, /* yun an => yu nan */
    { &pinyin_table[626],  &pinyin_table[6],    &pinyin_table[621],  &pinyin_table[348],  }, /* yun ao => yu nao */
    { &pinyin_table[626],  &pinyin_table[125],  &pinyin_table[621],  &pinyin_table[349],  }, /* yun e => yu ne */
    { &pinyin_table[626],  &pinyin_table[126],  &pinyin_table[621],  &pinyin_table[351],  }, /* yun ei => yu nei */
    { &pinyin_table[633],  &pinyin_table[0],    &pinyin_table[629],  &pinyin_table[342],  }, /* zan a => za na */
    { &pinyin_table[633],  &pinyin_table[4],    &pinyin_table[629],  &pinyin_table[346],  }, /* zan an => za nan */
    { &pinyin_table[633],  &pinyin_table[5],    &pinyin_table[629],  &pinyin_table[347],  }, /* zan ang => za nang */
    { &pinyin_table[633],  &pinyin_table[6],    &pinyin_table[629],  &pinyin_table[348],  }, /* zan ao => za nao */
    { &pinyin_table[633],  &pinyin_table[125],  &pinyin_table[629],  &pinyin_table[349],  }, /* zan e => za ne */
    { &pinyin_table[633],  &pinyin_table[126],  &pinyin_table[629],  &pinyin_table[351],  }, /* zan ei => za nei */
    { &pinyin_table[634],  &pinyin_table[2],    &pinyin_table[633],  &pinyin_table[157],  }, /* zang ai => zan gai */
    { &pinyin_table[634],  &pinyin_table[4],    &pinyin_table[633],  &pinyin_table[159],  }, /* zang an => zan gan */
    { &pinyin_table[634],  &pinyin_table[5],    &pinyin_table[633],  &pinyin_table[160],  }, /* zang ang => zan gang */
    { &pinyin_table[634],  &pinyin_table[125],  &pinyin_table[633],  &pinyin_table[162],  }, /* zang e => zan ge */
    { &pinyin_table[634],  &pinyin_table[126],  &pinyin_table[633],  &pinyin_table[164],  }, /* zang ei => zan gei */
    { &pinyin_table[634],  &pinyin_table[127],  &pinyin_table[633],  &pinyin_table[166],  }, /* zang en => zan gen */
    { &pinyin_table[634],  &pinyin_table[383],  &pinyin_table[633],  &pinyin_table[171],  }, /* zang ou => zan gou */
    { &pinyin_table[640],  &pinyin_table[0],    &pinyin_table[636],  &pinyin_table[342],  }, /* zen a => ze na */
    { &pinyin_table[640],  &pinyin_table[2],    &pinyin_table[636],  &pinyin_table[344],  }, /* zen ai => ze nai */
    { &pinyin_table[640],  &pinyin_table[4],    &pinyin_table[636],  &pinyin_table[346],  }, /* zen an => ze nan */
    { &pinyin_table[640],  &pinyin_table[5],    &pinyin_table[636],  &pinyin_table[347],  }, /* zen ang => ze nang */
    { &pinyin_table[640],  &pinyin_table[6],    &pinyin_table[636],  &pinyin_table[348],  }, /* zen ao => ze nao */
    { &pinyin_table[640],  &pinyin_table[125],  &pinyin_table[636],  &pinyin_table[349],  }, /* zen e => ze ne */
    { &pinyin_table[640],  &pinyin_table[126],  &pinyin_table[636],  &pinyin_table[351],  }, /* zen ei => ze nei */
    { &pinyin_table[641],  &pinyin_table[5],    &pinyin_table[640],  &pinyin_table[160],  }, /* zeng ang => zen gang */
    { &pinyin_table[641],  &pinyin_table[6],    &pinyin_table[640],  &pinyin_table[161],  }, /* zeng ao => zen gao */
    { &pinyin_table[641],  &pinyin_table[126],  &pinyin_table[640],  &pinyin_table[164],  }, /* zeng ei => zen gei */
    { &pinyin_table[647],  &pinyin_table[126],  &pinyin_table[643],  &pinyin_table[351],  }, /* zhan ei => zha nei */
    { &pinyin_table[648],  &pinyin_table[5],    &pinyin_table[647],  &pinyin_table[160],  }, /* zhang ang => zhan gang */
    { &pinyin_table[648],  &pinyin_table[6],    &pinyin_table[647],  &pinyin_table[161],  }, /* zhang ao => zhan gao */
    { &pinyin_table[648],  &pinyin_table[125],  &pinyin_table[647],  &pinyin_table[162],  }, /* zhang e => zhan ge */
    { &pinyin_table[648],  &pinyin_table[126],  &pinyin_table[647],  &pinyin_table[164],  }, /* zhang ei => zhan gei */
    { &pinyin_table[654],  &pinyin_table[0],    &pinyin_table[650],  &pinyin_table[342],  }, /* zhen a => zhe na */
    { &pinyin_table[654],  &pinyin_table[125],  &pinyin_table[650],  &pinyin_table[349],  }, /* zhen e => zhe ne */
    { &pinyin_table[654],  &pinyin_table[126],  &pinyin_table[650],  &pinyin_table[351],  }, /* zhen ei => zhe nei */
    { &pinyin_table[655],  &pinyin_table[2],    &pinyin_table[654],  &pinyin_table[157],  }, /* zheng ai => zhen gai */
    { &pinyin_table[655],  &pinyin_table[4],    &pinyin_table[654],  &pinyin_table[159],  }, /* zheng an => zhen gan */
    { &pinyin_table[655],  &pinyin_table[5],    &pinyin_table[654],  &pinyin_table[160],  }, /* zheng ang => zhen gang */
    { &pinyin_table[655],  &pinyin_table[6],    &pinyin_table[654],  &pinyin_table[161],  }, /* zheng ao => zhen gao */
    { &pinyin_table[655],  &pinyin_table[125],  &pinyin_table[654],  &pinyin_table[162],  }, /* zheng e => zhen ge */
    { &pinyin_table[655],  &pinyin_table[126],  &pinyin_table[654],  &pinyin_table[164],  }, /* zheng ei => zhen gei */
    { &pinyin_table[655],  &pinyin_table[127],  &pinyin_table[654],  &pinyin_table[166],  }, /* zheng en => zhen gen */
    { &pinyin_table[655],  &pinyin_table[383],  &pinyin_table[654],  &pinyin_table[171],  }, /* zheng ou => zhen gou */
    { &pinyin_table[666],  &pinyin_table[125],  &pinyin_table[662],  &pinyin_table[349],  }, /* zhuan e => zhua ne */
    { &pinyin_table[666],  &pinyin_table[126],  &pinyin_table[662],  &pinyin_table[351],  }, /* zhuan ei => zhua nei */
    { &pinyin_table[667],  &pinyin_table[5],    &pinyin_table[666],  &pinyin_table[160],  }, /* zhuang ang => zhuan gang */
    { &pinyin_table[667],  &pinyin_table[6],    &pinyin_table[666],  &pinyin_table[161],  }, /* zhuang ao => zhuan gao */
    { &pinyin_table[667],  &pinyin_table[125],  &pinyin_table[666],  &pinyin_table[162],  }, /* zhuang e => zhuan ge */
    { &pinyin_table[667],  &pinyin_table[126],  &pinyin_table[666],  &pinyin_table[164],  }, /* zhuang ei => zhuan gei */
    { &pinyin_table[671],  &pinyin_table[0],    &pinyin_table[661],  &pinyin_table[342],  }, /* zhun a => zhu na */
    { &pinyin_table[671],  &pinyin_table[4],    &pinyin_table[661],  &pinyin_table[346],  }, /* zhun an => zhu nan */
    { &pinyin_table[671],  &pinyin_table[5],    &pinyin_table[661],  &pinyin_table[347],  }, /* zhun ang => zhu nang */
    { &pinyin_table[671],  &pinyin_table[6],    &pinyin_table[661],  &pinyin_table[348],  }, /* zhun ao => zhu nao */
    { &pinyin_table[671],  &pinyin_table[125],  &pinyin_table[661],  &pinyin_table[349],  }, /* zhun e => zhu ne */
    { &pinyin_table[671],  &pinyin_table[126],  &pinyin_table[661],  &pinyin_table[351],  }, /* zhun ei => zhu nei */
    { &pinyin_table[686],  &pinyin_table[0],    &pinyin_table[678],  &pinyin_table[342],  }, /* zun a => zu na */
    { &pinyin_table[686],  &pinyin_table[2],    &pinyin_table[678],  &pinyin_table[344],  }, /* zun ai => zu nai */
    { &pinyin_table[686],  &pinyin_table[4],    &pinyin_table[678],  &pinyin_table[346],  }, /* zun an => zu nan */
    { &pinyin_table[686],  &pinyin_table[5],    &pinyin_table[678],  &pinyin_table[347],  }, /* zun ang => zu nang */
    { &pinyin_table[686],  &pinyin_table[6],    &pinyin_table[678],  &pinyin_table[348],  }, /* zun ao => zu nao */
    { &pinyin_table[686],  &pinyin_table[125],  &pinyin_table[678],  &pinyin_table[349],  }, /* zun e => zu ne */
    { &pinyin_table[686],  &pinyin_table[126],  &pinyin_table[678],  &pinyin_table[351],  }, /* zun ei => zu nei */
    { &pinyin_table[686],  &pinyin_table[127],  &pinyin_table[678],  &pinyin_table[353],  }, /* zun en => zu nen */
};
#define SPECIAL_TABLE_NR (sizeof (special_table) / sizeof (special_table[0]))

