/* xkblayout.c generated by valac 0.26.1, the Vala compiler
 * generated from xkblayout.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2014 Red Hat, Inc.
 * Copyright(c) 2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2014 Takao Fujiwara <tfujiwar@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ibus.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;
typedef struct _XKBLayoutPrivate XKBLayoutPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecXKBLayout ParamSpecXKBLayout;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _XKBLayout {
	GTypeInstance parent_instance;
	volatile int ref_count;
	XKBLayoutPrivate * priv;
};

struct _XKBLayoutClass {
	GTypeClass parent_class;
	void (*finalize) (XKBLayout *self);
};

struct _XKBLayoutPrivate {
	gchar** m_xkb_latin_layouts;
	gint m_xkb_latin_layouts_length1;
	gint _m_xkb_latin_layouts_size_;
	gchar* m_default_layout;
	gchar* m_default_variant;
	gchar* m_default_option;
	gboolean m_use_xmodmap;
};

struct _ParamSpecXKBLayout {
	GParamSpec parent_instance;
};


static gpointer xkb_layout_parent_class = NULL;

gpointer xkb_layout_ref (gpointer instance);
void xkb_layout_unref (gpointer instance);
GParamSpec* param_spec_xkb_layout (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_xkb_layout (GValue* value, gpointer v_object);
void value_take_xkb_layout (GValue* value, gpointer v_object);
gpointer value_get_xkb_layout (const GValue* value);
GType xkb_layout_get_type (void) G_GNUC_CONST;
#define XKB_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_XKB_LAYOUT, XKBLayoutPrivate))
enum  {
	XKB_LAYOUT_DUMMY_PROPERTY
};
#define XKB_LAYOUT_XKB_COMMAND "setxkbmap"
#define XKB_LAYOUT_XKB_QUERY_ARG "-query"
#define XKB_LAYOUT_XKB_LAYOUT_ARG "-layout"
#define XKB_LAYOUT_XMODMAP_COMMAND "xmodmap"
XKBLayout* xkb_layout_new (void);
XKBLayout* xkb_layout_construct (GType object_type);
void xkb_layout_set_latin_layouts (XKBLayout* self, gchar** xkb_latin_layouts, int xkb_latin_layouts_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
void xkb_layout_get_layout (gchar** layout, gchar** variant, gchar** option);
static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add24 (gchar*** array, int* length, int* size, gchar* value);
void xkb_layout_set_layout (XKBLayout* self, IBusEngineDesc* engine);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add25 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add26 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add27 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add28 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add29 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add30 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add31 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add32 (gchar*** array, int* length, int* size, gchar* value);
void xkb_layout_run_xmodmap (XKBLayout* self);
void xkb_layout_set_use_xmodmap (XKBLayout* self, gboolean use_xmodmap);
static void xkb_layout_finalize (XKBLayout* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* XKB_LAYOUT_XMODMAP_KNOWN_FILES[4] = {".xmodmap", ".xmodmaprc", ".Xmodmap", ".Xmodmaprc"};

XKBLayout* xkb_layout_construct (GType object_type) {
	XKBLayout* self = NULL;
	self = (XKBLayout*) g_type_create_instance (object_type);
	return self;
}


XKBLayout* xkb_layout_new (void) {
	return xkb_layout_construct (TYPE_XKB_LAYOUT);
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void xkb_layout_set_latin_layouts (XKBLayout* self, gchar** xkb_latin_layouts, int xkb_latin_layouts_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = xkb_latin_layouts;
	_tmp0__length1 = xkb_latin_layouts_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup6 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->m_xkb_latin_layouts = (_vala_array_free (self->priv->m_xkb_latin_layouts, self->priv->m_xkb_latin_layouts_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_xkb_latin_layouts = _tmp1_;
	self->priv->m_xkb_latin_layouts_length1 = _tmp1__length1;
	self->priv->_m_xkb_latin_layouts_size_ = self->priv->m_xkb_latin_layouts_length1;
}


static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add24 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void xkb_layout_get_layout (gchar** layout, gchar** variant, gchar** option) {
	gchar* _vala_layout = NULL;
	gchar* _vala_variant = NULL;
	gchar* _vala_option = NULL;
	gchar** exec_command = NULL;
	gchar** _tmp0_ = NULL;
	gint exec_command_length1 = 0;
	gint _exec_command_size_ = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* standard_output = NULL;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp15_ = 0;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	exec_command = _tmp0_;
	exec_command_length1 = 0;
	_exec_command_size_ = exec_command_length1;
	_tmp1_ = exec_command;
	_tmp1__length1 = exec_command_length1;
	_tmp2_ = g_strdup (XKB_LAYOUT_XKB_COMMAND);
	_vala_array_add23 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp2_);
	_tmp3_ = exec_command;
	_tmp3__length1 = exec_command_length1;
	_tmp4_ = g_strdup (XKB_LAYOUT_XKB_QUERY_ARG);
	_vala_array_add24 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp4_);
	standard_output = NULL;
	standard_error = NULL;
	exit_status = 0;
	_tmp5_ = g_strdup ("");
	_g_free0 (_vala_layout);
	_vala_layout = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (_vala_variant);
	_vala_variant = _tmp6_;
	_tmp7_ = g_strdup ("");
	_g_free0 (_vala_option);
	_vala_option = _tmp7_;
	{
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp8_ = exec_command;
		_tmp8__length1 = exec_command_length1;
		g_spawn_sync (NULL, _tmp8_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error_);
		_g_free0 (standard_output);
		standard_output = _tmp9_;
		_g_free0 (standard_error);
		standard_error = _tmp10_;
		exit_status = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch12_g_spawn_error;
			}
			_g_free0 (standard_error);
			_g_free0 (standard_output);
			exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally12;
	__catch12_g_spawn_error:
	{
		GError* err = NULL;
		FILE* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "IBUS_ERROR: %s\n", _tmp14_);
		_g_error_free0 (err);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = exit_status;
	if (_tmp15_ != 0) {
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		FILE* _tmp18_ = NULL;
		_tmp17_ = standard_error;
		_tmp16_ = _tmp17_;
		if (_tmp16_ == NULL) {
			_tmp16_ = "";
		}
		_tmp18_ = stderr;
		fprintf (_tmp18_, "IBUS_ERROR: %s\n", _tmp16_);
	}
	_tmp19_ = standard_output;
	if (_tmp19_ == NULL) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		if (layout) {
			*layout = _vala_layout;
		} else {
			_g_free0 (_vala_layout);
		}
		if (variant) {
			*variant = _vala_variant;
		} else {
			_g_free0 (_vala_variant);
		}
		if (option) {
			*option = _vala_option;
		} else {
			_g_free0 (_vala_option);
		}
		return;
	}
	_tmp20_ = standard_output;
	_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp22_;
		line_collection_length1 = _vala_array_length (_tmp21_);
		for (line_it = 0; line_it < _vala_array_length (_tmp21_); line_it = line_it + 1) {
			gchar* _tmp23_ = NULL;
			gchar* line = NULL;
			_tmp23_ = g_strdup (line_collection[line_it]);
			line = _tmp23_;
			{
				gchar* element = NULL;
				gchar* _tmp24_ = NULL;
				gchar* retval = NULL;
				gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				gchar* _tmp60_ = NULL;
				gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				gboolean _tmp64_ = FALSE;
				_tmp24_ = g_strdup ("layout:");
				element = _tmp24_;
				_tmp25_ = g_strdup ("");
				retval = _tmp25_;
				_tmp26_ = line;
				_tmp27_ = element;
				_tmp28_ = g_str_has_prefix (_tmp26_, _tmp27_);
				if (_tmp28_) {
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					const gchar* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					gint _tmp35_ = 0;
					gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					_tmp29_ = line;
					_tmp30_ = element;
					_tmp31_ = strlen (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = line;
					_tmp34_ = strlen (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = string_slice (_tmp29_, (glong) _tmp32_, (glong) _tmp35_);
					_g_free0 (retval);
					retval = _tmp36_;
					_tmp37_ = retval;
					if (_tmp37_ != NULL) {
						const gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						_tmp38_ = retval;
						_tmp39_ = string_strip (_tmp38_);
						_g_free0 (retval);
						retval = _tmp39_;
					}
					_tmp40_ = retval;
					_tmp41_ = g_strdup (_tmp40_);
					_g_free0 (_vala_layout);
					_vala_layout = _tmp41_;
				}
				_tmp42_ = g_strdup ("variant:");
				_g_free0 (element);
				element = _tmp42_;
				_tmp43_ = g_strdup ("");
				_g_free0 (retval);
				retval = _tmp43_;
				_tmp44_ = line;
				_tmp45_ = element;
				_tmp46_ = g_str_has_prefix (_tmp44_, _tmp45_);
				if (_tmp46_) {
					const gchar* _tmp47_ = NULL;
					const gchar* _tmp48_ = NULL;
					gint _tmp49_ = 0;
					gint _tmp50_ = 0;
					const gchar* _tmp51_ = NULL;
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
					gchar* _tmp54_ = NULL;
					const gchar* _tmp55_ = NULL;
					const gchar* _tmp58_ = NULL;
					gchar* _tmp59_ = NULL;
					_tmp47_ = line;
					_tmp48_ = element;
					_tmp49_ = strlen (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = line;
					_tmp52_ = strlen (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = string_slice (_tmp47_, (glong) _tmp50_, (glong) _tmp53_);
					_g_free0 (retval);
					retval = _tmp54_;
					_tmp55_ = retval;
					if (_tmp55_ != NULL) {
						const gchar* _tmp56_ = NULL;
						gchar* _tmp57_ = NULL;
						_tmp56_ = retval;
						_tmp57_ = string_strip (_tmp56_);
						_g_free0 (retval);
						retval = _tmp57_;
					}
					_tmp58_ = retval;
					_tmp59_ = g_strdup (_tmp58_);
					_g_free0 (_vala_variant);
					_vala_variant = _tmp59_;
				}
				_tmp60_ = g_strdup ("options:");
				_g_free0 (element);
				element = _tmp60_;
				_tmp61_ = g_strdup ("");
				_g_free0 (retval);
				retval = _tmp61_;
				_tmp62_ = line;
				_tmp63_ = element;
				_tmp64_ = g_str_has_prefix (_tmp62_, _tmp63_);
				if (_tmp64_) {
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					const gchar* _tmp69_ = NULL;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					gchar* _tmp72_ = NULL;
					const gchar* _tmp73_ = NULL;
					const gchar* _tmp76_ = NULL;
					gchar* _tmp77_ = NULL;
					_tmp65_ = line;
					_tmp66_ = element;
					_tmp67_ = strlen (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = line;
					_tmp70_ = strlen (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = string_slice (_tmp65_, (glong) _tmp68_, (glong) _tmp71_);
					_g_free0 (retval);
					retval = _tmp72_;
					_tmp73_ = retval;
					if (_tmp73_ != NULL) {
						const gchar* _tmp74_ = NULL;
						gchar* _tmp75_ = NULL;
						_tmp74_ = retval;
						_tmp75_ = string_strip (_tmp74_);
						_g_free0 (retval);
						retval = _tmp75_;
					}
					_tmp76_ = retval;
					_tmp77_ = g_strdup (_tmp76_);
					_g_free0 (_vala_option);
					_vala_option = _tmp77_;
				}
				_g_free0 (retval);
				_g_free0 (element);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (standard_error);
	_g_free0 (standard_output);
	exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
	if (layout) {
		*layout = _vala_layout;
	} else {
		_g_free0 (_vala_layout);
	}
	if (variant) {
		*variant = _vala_variant;
	} else {
		_g_free0 (_vala_variant);
	}
	if (option) {
		*option = _vala_option;
	} else {
		_g_free0 (_vala_option);
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add25 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add26 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add27 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add28 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add29 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add30 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add31 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add32 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void xkb_layout_set_layout (XKBLayout* self, IBusEngineDesc* engine) {
	gchar* layout = NULL;
	IBusEngineDesc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* variant = NULL;
	IBusEngineDesc* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* option = NULL;
	IBusEngineDesc* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gboolean need_us_layout = FALSE;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp43_ = NULL;
	gboolean _tmp58_ = FALSE;
	gchar** args = NULL;
	gchar** _tmp64_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar** _tmp65_ = NULL;
	gint _tmp65__length1 = 0;
	gchar* _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gint _tmp67__length1 = 0;
	gchar* _tmp68_ = NULL;
	gchar** _tmp69_ = NULL;
	gint _tmp69__length1 = 0;
	const gchar* _tmp70_ = NULL;
	gchar* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	const gchar* _tmp74_ = NULL;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	const gchar* _tmp84_ = NULL;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gint _tmp103_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_layout (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_layout_variant (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	variant = _tmp5_;
	_tmp6_ = engine;
	_tmp7_ = ibus_engine_desc_get_layout_option (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	option = _tmp8_;
	_tmp9_ = layout;
	_vala_assert (_tmp9_ != NULL, "layout != null");
	_tmp12_ = layout;
	if (g_strcmp0 (_tmp12_, "default") == 0) {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_ = NULL;
		_tmp14_ = variant;
		if (g_strcmp0 (_tmp14_, "default") == 0) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = variant;
			_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
		}
		_tmp11_ = _tmp13_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_ = NULL;
		_tmp17_ = option;
		if (g_strcmp0 (_tmp17_, "default") == 0) {
			_tmp16_ = TRUE;
		} else {
			const gchar* _tmp18_ = NULL;
			_tmp18_ = option;
			_tmp16_ = g_strcmp0 (_tmp18_, "") == 0;
		}
		_tmp10_ = _tmp16_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	need_us_layout = FALSE;
	_tmp19_ = variant;
	if (g_strcmp0 (_tmp19_, "eng") != 0) {
		const gchar* _tmp20_ = NULL;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		_tmp20_ = layout;
		_tmp21_ = self->priv->m_xkb_latin_layouts;
		_tmp21__length1 = self->priv->m_xkb_latin_layouts_length1;
		need_us_layout = _vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_);
	}
	_tmp23_ = need_us_layout;
	if (!_tmp23_) {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = variant;
		_tmp22_ = _tmp24_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		_tmp25_ = layout;
		_tmp26_ = variant;
		_tmp27_ = g_strdup_printf ("%s(%s)", _tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->m_xkb_latin_layouts;
		_tmp29__length1 = self->priv->m_xkb_latin_layouts_length1;
		need_us_layout = _vala_string_array_contains (_tmp29_, _tmp29__length1, _tmp28_);
		_g_free0 (_tmp28_);
	}
	_tmp30_ = self->priv->m_default_layout;
	if (g_strcmp0 (_tmp30_, "") == 0) {
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		xkb_layout_get_layout (&_tmp31_, &_tmp32_, &_tmp33_);
		_g_free0 (self->priv->m_default_layout);
		self->priv->m_default_layout = _tmp31_;
		_g_free0 (self->priv->m_default_variant);
		self->priv->m_default_variant = _tmp32_;
		_g_free0 (self->priv->m_default_option);
		self->priv->m_default_option = _tmp33_;
	}
	_tmp35_ = layout;
	if (g_strcmp0 (_tmp35_, "default") == 0) {
		_tmp34_ = TRUE;
	} else {
		const gchar* _tmp36_ = NULL;
		_tmp36_ = layout;
		_tmp34_ = g_strcmp0 (_tmp36_, "") == 0;
	}
	if (_tmp34_) {
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp37_ = self->priv->m_default_layout;
		_tmp38_ = g_strdup (_tmp37_);
		_g_free0 (layout);
		layout = _tmp38_;
		_tmp39_ = self->priv->m_default_variant;
		_tmp40_ = g_strdup (_tmp39_);
		_g_free0 (variant);
		variant = _tmp40_;
	}
	_tmp41_ = layout;
	if (g_strcmp0 (_tmp41_, "") == 0) {
		g_warning ("xkblayout.vala:148: Could not get the correct layout");
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	_tmp43_ = option;
	if (g_strcmp0 (_tmp43_, "default") == 0) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp44_ = NULL;
		_tmp44_ = option;
		_tmp42_ = g_strcmp0 (_tmp44_, "") == 0;
	}
	if (_tmp42_) {
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		_tmp45_ = self->priv->m_default_option;
		_tmp46_ = g_strdup (_tmp45_);
		_g_free0 (option);
		option = _tmp46_;
	} else {
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gchar** _tmp49_ = NULL;
		gchar** _tmp50_ = NULL;
		gchar** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		gboolean _tmp52_ = FALSE;
		_tmp47_ = option;
		_tmp48_ = self->priv->m_default_option;
		_tmp50_ = _tmp49_ = g_strsplit (_tmp48_, ",", 0);
		_tmp51_ = _tmp50_;
		_tmp51__length1 = _vala_array_length (_tmp49_);
		_tmp52_ = !_vala_string_array_contains (_tmp51_, _vala_array_length (_tmp49_), _tmp47_);
		_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
		if (_tmp52_) {
			const gchar* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			_tmp53_ = self->priv->m_default_option;
			_tmp54_ = option;
			_tmp55_ = g_strdup_printf ("%s,%s", _tmp53_, _tmp54_);
			_g_free0 (option);
			option = _tmp55_;
		} else {
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			_tmp56_ = self->priv->m_default_option;
			_tmp57_ = g_strdup (_tmp56_);
			_g_free0 (option);
			option = _tmp57_;
		}
	}
	_tmp58_ = need_us_layout;
	if (_tmp58_) {
		const gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		_tmp59_ = layout;
		_tmp60_ = g_strconcat (_tmp59_, ",us", NULL);
		_g_free0 (layout);
		layout = _tmp60_;
		_tmp61_ = variant;
		if (_tmp61_ != NULL) {
			const gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
			_tmp62_ = variant;
			_tmp63_ = g_strconcat (_tmp62_, ",", NULL);
			_g_free0 (variant);
			variant = _tmp63_;
		}
	}
	_tmp64_ = g_new0 (gchar*, 0 + 1);
	args = _tmp64_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp65_ = args;
	_tmp65__length1 = args_length1;
	_tmp66_ = g_strdup (XKB_LAYOUT_XKB_COMMAND);
	_vala_array_add25 (&args, &args_length1, &_args_size_, _tmp66_);
	_tmp67_ = args;
	_tmp67__length1 = args_length1;
	_tmp68_ = g_strdup (XKB_LAYOUT_XKB_LAYOUT_ARG);
	_vala_array_add26 (&args, &args_length1, &_args_size_, _tmp68_);
	_tmp69_ = args;
	_tmp69__length1 = args_length1;
	_tmp70_ = layout;
	_tmp71_ = g_strdup (_tmp70_);
	_vala_array_add27 (&args, &args_length1, &_args_size_, _tmp71_);
	_tmp74_ = variant;
	if (_tmp74_ != NULL) {
		const gchar* _tmp75_ = NULL;
		_tmp75_ = variant;
		_tmp73_ = g_strcmp0 (_tmp75_, "") != 0;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		const gchar* _tmp76_ = NULL;
		_tmp76_ = variant;
		_tmp72_ = g_strcmp0 (_tmp76_, "default") != 0;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gchar** _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		gchar* _tmp78_ = NULL;
		gchar** _tmp79_ = NULL;
		gint _tmp79__length1 = 0;
		const gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		_tmp77_ = args;
		_tmp77__length1 = args_length1;
		_tmp78_ = g_strdup ("-variant");
		_vala_array_add28 (&args, &args_length1, &_args_size_, _tmp78_);
		_tmp79_ = args;
		_tmp79__length1 = args_length1;
		_tmp80_ = variant;
		_tmp81_ = g_strdup (_tmp80_);
		_vala_array_add29 (&args, &args_length1, &_args_size_, _tmp81_);
	}
	_tmp84_ = option;
	if (_tmp84_ != NULL) {
		const gchar* _tmp85_ = NULL;
		_tmp85_ = option;
		_tmp83_ = g_strcmp0 (_tmp85_, "") != 0;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		const gchar* _tmp86_ = NULL;
		_tmp86_ = option;
		_tmp82_ = g_strcmp0 (_tmp86_, "default") != 0;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		gchar** _tmp87_ = NULL;
		gint _tmp87__length1 = 0;
		gchar* _tmp88_ = NULL;
		gchar** _tmp89_ = NULL;
		gint _tmp89__length1 = 0;
		gchar* _tmp90_ = NULL;
		gchar** _tmp91_ = NULL;
		gint _tmp91__length1 = 0;
		const gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		_tmp87_ = args;
		_tmp87__length1 = args_length1;
		_tmp88_ = g_strdup ("-option");
		_vala_array_add30 (&args, &args_length1, &_args_size_, _tmp88_);
		_tmp89_ = args;
		_tmp89__length1 = args_length1;
		_tmp90_ = g_strdup ("-option");
		_vala_array_add31 (&args, &args_length1, &_args_size_, _tmp90_);
		_tmp91_ = args;
		_tmp91__length1 = args_length1;
		_tmp92_ = option;
		_tmp93_ = g_strdup (_tmp92_);
		_vala_array_add32 (&args, &args_length1, &_args_size_, _tmp93_);
	}
	standard_error = NULL;
	exit_status = 0;
	{
		gboolean _tmp94_ = FALSE;
		gchar** _tmp95_ = NULL;
		gint _tmp95__length1 = 0;
		gchar* _tmp96_ = NULL;
		gint _tmp97_ = 0;
		gboolean _tmp98_ = FALSE;
		_tmp95_ = args;
		_tmp95__length1 = args_length1;
		_tmp98_ = g_spawn_sync (NULL, _tmp95_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp96_, &_tmp97_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp96_;
		exit_status = _tmp97_;
		_tmp94_ = _tmp98_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch13_g_spawn_error;
			}
			_g_free0 (standard_error);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!_tmp94_) {
			IBusEngineDesc* _tmp99_ = NULL;
			const gchar* _tmp100_ = NULL;
			_tmp99_ = engine;
			_tmp100_ = ibus_engine_desc_get_layout (_tmp99_);
			g_warning ("xkblayout.vala:195: Switch xkb layout to %s failed.", _tmp100_);
		}
	}
	goto __finally13;
	__catch13_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp101_ = NULL;
		const gchar* _tmp102_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp101_ = e;
		_tmp102_ = _tmp101_->message;
		g_warning ("xkblayout.vala:198: Execute setxkbmap failed: %s", _tmp102_);
		_g_error_free0 (e);
		_g_free0 (standard_error);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (standard_error);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp103_ = exit_status;
	if (_tmp103_ != 0) {
		const gchar* _tmp104_ = NULL;
		const gchar* _tmp105_ = NULL;
		_tmp105_ = standard_error;
		_tmp104_ = _tmp105_;
		if (_tmp104_ == NULL) {
			_tmp104_ = "(null)";
		}
		g_warning ("xkblayout.vala:203: Execute setxkbmap failed: %s", _tmp104_);
	}
	xkb_layout_run_xmodmap (self);
	_g_free0 (standard_error);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
}


void xkb_layout_run_xmodmap (XKBLayout* self) {
	gboolean _tmp0_ = FALSE;
	gchar* homedir = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_use_xmodmap;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_strdup (_tmp1_);
	homedir = _tmp2_;
	{
		const gchar** xmodmap_file_collection = NULL;
		gint xmodmap_file_collection_length1 = 0;
		gint _xmodmap_file_collection_size_ = 0;
		gint xmodmap_file_it = 0;
		xmodmap_file_collection = XKB_LAYOUT_XMODMAP_KNOWN_FILES;
		xmodmap_file_collection_length1 = G_N_ELEMENTS (XKB_LAYOUT_XMODMAP_KNOWN_FILES);
		for (xmodmap_file_it = 0; xmodmap_file_it < G_N_ELEMENTS (XKB_LAYOUT_XMODMAP_KNOWN_FILES); xmodmap_file_it = xmodmap_file_it + 1) {
			gchar* _tmp3_ = NULL;
			gchar* xmodmap_file = NULL;
			_tmp3_ = g_strdup (xmodmap_file_collection[xmodmap_file_it]);
			xmodmap_file = _tmp3_;
			{
				gchar* xmodmap_filepath = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gchar** args = NULL;
				gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint args_length1 = 0;
				gint _args_size_ = 0;
				_tmp4_ = homedir;
				_tmp5_ = xmodmap_file;
				_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
				xmodmap_filepath = _tmp6_;
				_tmp7_ = xmodmap_filepath;
				_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
				if (!_tmp8_) {
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					continue;
				}
				_tmp9_ = g_strdup (XKB_LAYOUT_XMODMAP_COMMAND);
				_tmp10_ = xmodmap_filepath;
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = g_new0 (gchar*, 2 + 1);
				_tmp12_[0] = _tmp9_;
				_tmp12_[1] = _tmp11_;
				args = _tmp12_;
				args_length1 = 2;
				_args_size_ = args_length1;
				{
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					_tmp13_ = args;
					_tmp13__length1 = args_length1;
					g_spawn_async (NULL, _tmp13_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_SPAWN_ERROR) {
							goto __catch14_g_spawn_error;
						}
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (xmodmap_filepath);
						_g_free0 (xmodmap_file);
						_g_free0 (homedir);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				goto __finally14;
				__catch14_g_spawn_error:
				{
					GError* e = NULL;
					GError* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = e;
					_tmp15_ = _tmp14_->message;
					g_warning ("xkblayout.vala:241: Execute xmodmap is failed: %s\n", _tmp15_);
					_g_error_free0 (e);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					return;
				}
				__finally14:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (xmodmap_filepath);
				_g_free0 (xmodmap_file);
				break;
			}
		}
	}
	_g_free0 (homedir);
}


void xkb_layout_set_use_xmodmap (XKBLayout* self, gboolean use_xmodmap) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_xmodmap;
	self->priv->m_use_xmodmap = _tmp0_;
}


static void value_xkb_layout_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_xkb_layout_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		xkb_layout_unref (value->data[0].v_pointer);
	}
}


static void value_xkb_layout_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = xkb_layout_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_xkb_layout_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_xkb_layout_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		XKBLayout* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = xkb_layout_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_xkb_layout_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	XKBLayout** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = xkb_layout_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_xkb_layout (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecXKBLayout* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_XKB_LAYOUT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_xkb_layout (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT), NULL);
	return value->data[0].v_pointer;
}


void value_set_xkb_layout (GValue* value, gpointer v_object) {
	XKBLayout* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		xkb_layout_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}


void value_take_xkb_layout (GValue* value, gpointer v_object) {
	XKBLayout* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}


static void xkb_layout_class_init (XKBLayoutClass * klass) {
	xkb_layout_parent_class = g_type_class_peek_parent (klass);
	((XKBLayoutClass *) klass)->finalize = xkb_layout_finalize;
	g_type_class_add_private (klass, sizeof (XKBLayoutPrivate));
}


static void xkb_layout_instance_init (XKBLayout * self) {
	gchar** _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	self->priv = XKB_LAYOUT_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_xkb_latin_layouts = _tmp0_;
	self->priv->m_xkb_latin_layouts_length1 = 0;
	self->priv->_m_xkb_latin_layouts_size_ = self->priv->m_xkb_latin_layouts_length1;
	_tmp1_ = g_strdup ("");
	self->priv->m_default_layout = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->m_default_variant = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->m_default_option = _tmp3_;
	self->priv->m_use_xmodmap = TRUE;
	self->ref_count = 1;
}


static void xkb_layout_finalize (XKBLayout* obj) {
	XKBLayout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_XKB_LAYOUT, XKBLayout);
	g_signal_handlers_destroy (self);
	self->priv->m_xkb_latin_layouts = (_vala_array_free (self->priv->m_xkb_latin_layouts, self->priv->m_xkb_latin_layouts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->m_default_layout);
	_g_free0 (self->priv->m_default_variant);
	_g_free0 (self->priv->m_default_option);
}


GType xkb_layout_get_type (void) {
	static volatile gsize xkb_layout_type_id__volatile = 0;
	if (g_once_init_enter (&xkb_layout_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_xkb_layout_init, value_xkb_layout_free_value, value_xkb_layout_copy_value, value_xkb_layout_peek_pointer, "p", value_xkb_layout_collect_value, "p", value_xkb_layout_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (XKBLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xkb_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XKBLayout), 0, (GInstanceInitFunc) xkb_layout_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType xkb_layout_type_id;
		xkb_layout_type_id = g_type_register_fundamental (g_type_fundamental_next (), "XKBLayout", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&xkb_layout_type_id__volatile, xkb_layout_type_id);
	}
	return xkb_layout_type_id__volatile;
}


gpointer xkb_layout_ref (gpointer instance) {
	XKBLayout* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void xkb_layout_unref (gpointer instance) {
	XKBLayout* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		XKB_LAYOUT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



