/* panel.c generated by valac 0.56.16, the Vala compiler
 * generated from panel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2024 Takao Fujwiara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <ibus.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <locale.h>
#include <float.h>
#include <math.h>
#include <libnotify/notify.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <signal.h>
#include <sys/types.h>
#include <config.h>

#define PANEL_PRELOAD_ENGINES_DELAY_TIME ((guint) 30000)
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
typedef struct _PanelPrivate PanelPrivate;
typedef enum  {
	PANEL_ICON_TYPE_STATUS_ICON,
	PANEL_ICON_TYPE_INDICATOR
} PanelIconType;

#define PANEL_TYPE_ICON_TYPE (panel_icon_type_get_type ())

#define TYPE_INDICATOR (indicator_get_type ())
#define INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR, Indicator))
#define INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR, IndicatorClass))
#define IS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR))
#define IS_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR))
#define INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR, IndicatorClass))

typedef struct _Indicator Indicator;
typedef struct _IndicatorClass IndicatorClass;
typedef enum  {
	INDICATOR_STATUS_PASSIVE,
	INDICATOR_STATUS_ACTIVE,
	INDICATOR_STATUS_ATTENTION
} IndicatorStatus;

#define INDICATOR_TYPE_STATUS (indicator_status_get_type ())

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;

#define TYPE_PROPERTY_MANAGER (property_manager_get_type ())
#define PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_MANAGER, PropertyManager))
#define PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_MANAGER, PropertyManagerClass))
#define IS_PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_MANAGER))
#define IS_PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_MANAGER))
#define PROPERTY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_MANAGER, PropertyManagerClass))

typedef struct _PropertyManager PropertyManager;
typedef struct _PropertyManagerClass PropertyManagerClass;

#define TYPE_PROPERTY_PANEL (property_panel_get_type ())
#define PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_PANEL, PropertyPanel))
#define PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_PANEL, PropertyPanelClass))
#define IS_PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_PANEL))
#define IS_PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_PANEL))
#define PROPERTY_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_PANEL, PropertyPanelClass))

typedef struct _PropertyPanel PropertyPanel;
typedef struct _PropertyPanelClass PropertyPanelClass;

#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;

#define BINDING_COMMON_TYPE_KEYBINDING (binding_common_keybinding_get_type ())
#define BINDING_COMMON_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding))
#define BINDING_COMMON_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))
#define BINDING_COMMON_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))

typedef struct _BindingCommonKeybinding BindingCommonKeybinding;
typedef struct _BindingCommonKeybindingClass BindingCommonKeybindingClass;
enum  {
	PANEL_0_PROPERTY,
	PANEL_NUM_PROPERTIES
};
static GParamSpec* panel_properties[PANEL_NUM_PROPERTIES];
typedef enum  {
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING
} BindingCommonKeyEventFuncType;

#define BINDING_COMMON_TYPE_KEY_EVENT_FUNC_TYPE (binding_common_key_event_func_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _property_manager_unref0(var) ((var == NULL) ? NULL : (var = (property_manager_unref (var), NULL)))
#define _xkb_layout_unref0(var) ((var == NULL) ? NULL : (var = (xkb_layout_unref (var), NULL)))
typedef enum  {
	INDICATOR_CATEGORY_APPLICATION_STATUS,
	INDICATOR_CATEGORY_COMMUNICATIONS,
	INDICATOR_CATEGORY_SYSTEM_SERVICES,
	INDICATOR_CATEGORY_HARDWARE,
	INDICATOR_CATEGORY_OTHER
} IndicatorCategory;

#define INDICATOR_TYPE_CATEGORY (indicator_category_get_type ())
typedef struct _Block7Data Block7Data;

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, gpointer user_data);
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
enum  {
	PANEL_REALIZE_SURFACE_SIGNAL,
	PANEL_UPDATE_SHORTCUT_KEYS_SIGNAL,
	PANEL_NUM_SIGNALS
};
static guint panel_signals[PANEL_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Panel {
	IBusPanelService parent_instance;
	PanelPrivate * priv;
};

struct _PanelClass {
	IBusPanelServiceClass parent_class;
};

struct _PanelPrivate {
	IBusBus* m_bus;
	GSettings* m_settings_general;
	GSettings* m_settings_hotkey;
	GSettings* m_settings_panel;
	PanelIconType m_icon_type;
	Indicator* m_indicator;
	IndicatorStatus m_indicator_show_status;
	GtkStatusIcon* m_status_icon;
	GtkMenu* m_ime_menu;
	GtkMenu* m_sys_menu;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	GHashTable* m_engine_contexts;
	gchar* m_current_context_path;
	gchar* m_real_current_context_path;
	gboolean m_use_global_engine;
	gboolean m_use_engine_lang;
	CandidatePanel* m_candidate_panel;
	Switcher* m_switcher;
	guint m_switcher_focus_set_engine_id;
	gint m_switcher_selected_index;
	GThread* m_switcher_waiting_release;
	PropertyManager* m_property_manager;
	PropertyPanel* m_property_panel;
	GPid m_setup_pid;
	GtkAboutDialog* m_about_dialog;
	GtkCssProvider* m_css_provider;
	gint m_switcher_delay_time;
	gboolean m_use_system_keyboard_layout;
	GHashTable* m_xkb_icon_pixbufs;
	GHashTable* m_xkb_icon_image;
	GdkRGBA m_xkb_icon_rgba;
	XKBLayout* m_xkblayout;
	gboolean inited_engines_order;
	guint m_preload_engines_id;
	gchar* m_icon_prop_key;
	gint m_property_icon_delay_time;
	guint m_property_icon_delay_time_id;
	guint m_menu_update_delay_time;
	guint m_menu_update_delay_time_id;
	gboolean m_is_wayland;
	gboolean m_is_wayland_im;
	gboolean m_is_kde;
	gboolean m_is_context_menu;
	gulong m_popup_menu_id;
	gulong m_activate_id;
	gulong m_registered_status_notifier_item_id;
	FILE* m_log;
	gboolean m_verbose;
	GList* m_keybindings;
};

struct _Block7Data {
	int _ref_count_;
	Panel* self;
	GdkRectangle area;
	GdkWindow* window;
	GtkMenuPositionFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _Block8Data {
	int _ref_count_;
	Panel* self;
	gchar** names;
	gint names_length1;
	gint _names_size_;
};

struct _Block9Data {
	int _ref_count_;
	Panel* self;
	GtkMessageDialog* dialog;
};

struct _Block10Data {
	int _ref_count_;
	Panel* self;
	IBusEngineDesc* e;
};

struct _Block11Data {
	int _ref_count_;
	Panel* self;
	gchar* symbol;
};

static gint Panel_private_offset;
static gpointer panel_parent_class = NULL;

VALA_EXTERN GType panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Panel, g_object_unref)
static GType panel_icon_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType indicator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indicator, g_object_unref)
VALA_EXTERN GType indicator_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType candidate_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CandidatePanel, g_object_unref)
VALA_EXTERN GType switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Switcher, g_object_unref)
VALA_EXTERN gpointer property_manager_ref (gpointer instance);
VALA_EXTERN void property_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_property_manager (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_property_manager (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_property_manager (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_property_manager (const GValue* value);
VALA_EXTERN GType property_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropertyManager, property_manager_unref)
VALA_EXTERN GType property_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropertyPanel, g_object_unref)
VALA_EXTERN gpointer xkb_layout_ref (gpointer instance);
VALA_EXTERN void xkb_layout_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_xkb_layout (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_xkb_layout (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_xkb_layout (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_xkb_layout (const GValue* value);
VALA_EXTERN GType xkb_layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XKBLayout, xkb_layout_unref)
VALA_EXTERN GType binding_common_keybinding_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BindingCommonKeybinding, g_object_unref)
VALA_EXTERN void indicator_unregister_connection (Indicator* self);
VALA_EXTERN GType binding_common_key_event_func_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void binding_common_unbind_switch_shortcut (BindingCommonKeyEventFuncType ftype,
                                            GList* keybindings);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _cairo_surface_destroy0_ (gpointer var);
VALA_EXTERN XKBLayout* xkb_layout_new (void);
VALA_EXTERN XKBLayout* xkb_layout_construct (GType object_type);
static gboolean panel_is_kde (void);
VALA_EXTERN Panel* panel_new (IBusBus* bus,
                  gboolean is_wayland_im);
VALA_EXTERN Panel* panel_construct (GType object_type,
                        IBusBus* bus,
                        gboolean is_wayland_im);
VALA_EXTERN gboolean binding_common_default_is_xdisplay (void);
static void panel_init_settings (Panel* self);
VALA_EXTERN PropertyManager* property_manager_new (void);
VALA_EXTERN PropertyManager* property_manager_construct (GType object_type);
static void __lambda84_ (Panel* self,
                  PropertyManager* w,
                  const gchar* k,
                  gint s);
static void ___lambda84__property_manager_property_activate (PropertyManager* _sender,
                                                      const gchar* key,
                                                      gint state,
                                                      gpointer self);
static void panel_init_indicator (Panel* self);
static void panel_init_status_icon (Panel* self);
VALA_EXTERN CandidatePanel* candidate_panel_new (void);
VALA_EXTERN CandidatePanel* candidate_panel_construct (GType object_type);
static void __lambda96_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda96__candidate_panel_page_up (CandidatePanel* _sender,
                                           gpointer self);
static void __lambda97_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda97__candidate_panel_page_down (CandidatePanel* _sender,
                                             gpointer self);
static void __lambda98_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda98__candidate_panel_cursor_up (CandidatePanel* _sender,
                                             gpointer self);
static void __lambda99_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda99__candidate_panel_cursor_down (CandidatePanel* _sender,
                                               gpointer self);
static void __lambda100_ (Panel* self,
                   CandidatePanel* w,
                   guint i,
                   guint b,
                   guint s);
static void ___lambda100__candidate_panel_candidate_clicked (CandidatePanel* _sender,
                                                      guint index,
                                                      guint button,
                                                      guint state,
                                                      gpointer self);
static void __lambda101_ (Panel* self,
                   CandidatePanel* w,
                   void* s);
static void ___lambda101__candidate_panel_realize_surface (CandidatePanel* _sender,
                                                    void* surface,
                                                    gpointer self);
VALA_EXTERN Switcher* switcher_new (void);
VALA_EXTERN Switcher* switcher_construct (GType object_type);
static void __lambda102_ (Panel* self,
                   Switcher* w,
                   void* s);
static void ___lambda102__switcher_realize_surface (Switcher* _sender,
                                             void* surface,
                                             gpointer self);
static void panel_bind_switch_shortcut (Panel* self);
VALA_EXTERN void switcher_set_popup_delay_time (Switcher* self,
                                    guint popup_delay_time);
VALA_EXTERN PropertyPanel* property_panel_new (void);
VALA_EXTERN PropertyPanel* property_panel_construct (GType object_type);
static void __lambda103_ (Panel* self,
                   PropertyPanel* w,
                   const gchar* k,
                   gint s);
static void ___lambda103__property_panel_property_activate (PropertyPanel* _sender,
                                                     const gchar* key,
                                                     gint state,
                                                     gpointer self);
static void __lambda60_ (Panel* self,
                  const gchar* key);
static void panel_update_engines (Panel* self,
                           gchar** unowned_engine_names,
                           gint unowned_engine_names_length1,
                           gchar** order_names,
                           gint order_names_length1);
static void ___lambda60__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda63_ (Panel* self,
                  const gchar* key);
static void panel_set_switcher_delay_time (Panel* self);
static void ___lambda63__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda64_ (Panel* self,
                  const gchar* key);
static void panel_set_use_system_keyboard_layout (Panel* self);
static void ___lambda64__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda65_ (Panel* self,
                  const gchar* key);
static void panel_set_embed_preedit_text (Panel* self);
static void ___lambda65__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda66_ (Panel* self,
                  const gchar* key);
static void panel_set_use_global_engine (Panel* self);
static void ___lambda66__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda67_ (Panel* self,
                  const gchar* key);
static void panel_set_use_xmodmap (Panel* self);
static void ___lambda67__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda68_ (Panel* self,
                  const gchar* key);
static void ___lambda68__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda70_ (Panel* self,
                  const gchar* key);
VALA_EXTERN void binding_common_set_custom_font (GSettings* settings_panel,
                                     GSettings* settings_emoji,
                                     GtkCssProvider** css_provider);
static void ___lambda70__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda71_ (Panel* self,
                  const gchar* key);
static void ___lambda71__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda72_ (Panel* self,
                  const gchar* key);
VALA_EXTERN void binding_common_set_custom_theme (GSettings* settings_panel);
static void ___lambda72__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda73_ (Panel* self,
                  const gchar* key);
static void ___lambda73__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda74_ (Panel* self,
                  const gchar* key);
VALA_EXTERN void binding_common_set_custom_icon (GSettings* settings_panel);
static void ___lambda74__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda75_ (Panel* self,
                  const gchar* key);
static void ___lambda75__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda76_ (Panel* self,
                  const gchar* key);
static void panel_set_language_from_engine (Panel* self,
                                     IBusEngineDesc* engine);
static void ___lambda76__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda77_ (Panel* self,
                  const gchar* key);
static void panel_set_show_icon_on_systray (Panel* self,
                                     gboolean update_now);
static void ___lambda77__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda78_ (Panel* self,
                  const gchar* key);
static void panel_set_lookup_table_orientation (Panel* self);
static void ___lambda78__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda79_ (Panel* self,
                  const gchar* key);
static void panel_set_show_property_panel (Panel* self);
static void ___lambda79__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda80_ (Panel* self,
                  const gchar* key);
static void panel_set_timeout_property_panel (Panel* self);
static void ___lambda80__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda81_ (Panel* self,
                  const gchar* key);
static void panel_set_follow_input_cursor_when_always_shown_property_panel (Panel* self);
static void ___lambda81__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda82_ (Panel* self,
                  const gchar* key);
static void panel_set_xkb_icon_rgba (Panel* self);
static void ___lambda82__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda83_ (Panel* self,
                  const gchar* key);
static void panel_set_property_icon_delay_time (Panel* self);
static void ___lambda83__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void panel_popup_menu_at_area_window (Panel* self,
                                      GtkMenu* menu,
                                      GdkRectangle* area,
                                      GdkWindow* window,
                                      GtkMenuPositionFunc func,
                                      gpointer func_target);
static gboolean panel_is_gnome (void);
static void panel_popup_menu_at_pointer_window (Panel* self,
                                         GtkMenu* menu,
                                         gint x,
                                         gint y,
                                         GdkWindow* window,
                                         GtkMenuPositionFunc func,
                                         gpointer func_target);
VALA_EXTERN GType indicator_category_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Indicator* indicator_new (const gchar* id,
                          IndicatorCategory category);
VALA_EXTERN Indicator* indicator_construct (GType object_type,
                                const gchar* id,
                                IndicatorCategory category);
VALA_EXTERN void indicator_set_title (Indicator* self,
                          const gchar* value);
static void __lambda85_ (Panel* self);
VALA_EXTERN void indicator_set_status (Indicator* self,
                           IndicatorStatus status);
static void ___lambda85__indicator_registered_status_notifier_item (Indicator* _sender,
                                                             gpointer self);
static void __lambda86_ (Panel* self);
VALA_EXTERN void indicator_set_menu (Indicator* self,
                         GtkMenu* menu);
static GtkMenu* panel_create_context_menu (Panel* self,
                                    gboolean use_x11);
static GtkMenu* panel_create_activate_menu (Panel* self,
                                     gboolean use_x11);
static void ___lambda86__indicator_secondary_activate (Indicator* _sender,
                                                gpointer self);
static void panel_init_status_icon_menu (Panel* self);
static void _panel_init_status_icon_menu_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
VALA_EXTERN GdkX11Display* binding_common_get_xdisplay (void);
static void __lambda94_ (Block7Data* _data7_,
                  guint b,
                  guint t);
static void ___lambda94__gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                              guint button,
                                              guint activate_time,
                                              gpointer self);
static void __lambda95_ (Block7Data* _data7_);
static void ___lambda95__gtk_status_icon_activate (GtkStatusIcon* _sender,
                                            gpointer self);
VALA_EXTERN GType keybinding_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (KeybindingManager, g_object_unref)
VALA_EXTERN KeybindingManager* keybinding_manager_get_instance (void);
VALA_EXTERN void binding_common_keybinding_manager_bind (KeybindingManager* keybinding_manager,
                                             GList** keybindings,
                                             const gchar* accelerator,
                                             BindingCommonKeyEventFuncType ftype,
                                             KeybindingManagerKeybindingHandlerFunc handler_normal,
                                             gpointer handler_normal_target,
                                             KeybindingManagerKeybindingHandlerFunc handler_reverse,
                                             gpointer handler_reverse_target);
static void panel_handle_engine_switch_normal (Panel* self,
                                        GdkEvent* event);
static void _panel_handle_engine_switch_normal_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                                    gpointer self);
static void panel_handle_engine_switch_reverse (Panel* self,
                                         GdkEvent* event);
static void _panel_handle_engine_switch_reverse_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                                     gpointer self);
VALA_EXTERN gboolean binding_common_keybinding_get_reverse (BindingCommonKeybinding* self);
VALA_EXTERN guint binding_common_keybinding_get_keysym (BindingCommonKeybinding* self);
VALA_EXTERN GdkModifierType binding_common_keybinding_get_modifiers (BindingCommonKeybinding* self);
static void _vala_array_add18 (IBusProcessKeyEventData* * array,
                        gint* length,
                        gint* size,
                        const IBusProcessKeyEventData* value);
static void _vala_array_add19 (IBusProcessKeyEventData* * array,
                        gint* length,
                        gint* size,
                        const IBusProcessKeyEventData* value);
static GList* panel_get_engines_from_xkb (Panel* self,
                                   GList* engines);
VALA_EXTERN void xkb_layout_get_layout (gchar** layout,
                            gchar** variant,
                            gchar** option);
static GList* panel_get_engines_from_locale (Panel* self,
                                      GList* engines);
static gint __lambda104_ (IBusEngineDesc* a,
                   IBusEngineDesc* b);
static gint ___lambda104__gcompare_func (gconstpointer a,
                                  gconstpointer b);
static void panel_init_engines_order (Panel* self);
VALA_EXTERN void xkb_layout_set_latin_layouts (XKBLayout* self,
                                   gchar** xkb_latin_layouts,
                                   gint xkb_latin_layouts_length1);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add21 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void xkb_layout_set_use_xmodmap (XKBLayout* self,
                                 gboolean use_xmodmap);
VALA_EXTERN void candidate_panel_set_vertical (CandidatePanel* self,
                                   gboolean vertical);
VALA_EXTERN void property_panel_set_show (PropertyPanel* self,
                              gint _show);
VALA_EXTERN void property_panel_set_auto_hide_timeout (PropertyPanel* self,
                                           guint timeout);
VALA_EXTERN void property_panel_set_follow_input_cursor_when_always_shown (PropertyPanel* self,
                                                               gboolean is_follow);
static gint panel_compare_versions (Panel* self,
                             const gchar* version1,
                             const gchar* version2);
static void panel_update_version_1_5_8 (Panel* self);
static void panel_set_version (Panel* self);
static void panel_check_wayland (Panel* self);
static void panel_save_log (Panel* self,
                     const gchar* format);
VALA_EXTERN void panel_load_settings (Panel* self);
VALA_EXTERN void panel_disconnect_signals (Panel* self);
VALA_EXTERN void panel_set_global_shortcut_key_state (Panel* self,
                                          IBusBusGlobalBindingType type,
                                          gboolean is_pressed,
                                          gboolean is_backward);
static void panel_handle_engine_switch_focused (Panel* self,
                                         gboolean pressed,
                                         gboolean reverse);
VALA_EXTERN void panel_set_log (Panel* self,
                    FILE* log,
                    gboolean verbose);
static void panel_engine_contexts_insert (Panel* self,
                                   IBusEngineDesc* engine);
VALA_EXTERN void candidate_panel_set_language (CandidatePanel* self,
                                   PangoAttribute* language_attribute);
static void panel_set_engine (Panel* self,
                       IBusEngineDesc* engine);
VALA_EXTERN void xkb_layout_set_layout (XKBLayout* self,
                            IBusEngineDesc* engine);
static void panel_switch_engine (Panel* self,
                          gint i,
                          gboolean force);
static void panel_handle_engine_switch (Panel* self,
                                 GdkEvent* event,
                                 gboolean reverse);
VALA_EXTERN GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
VALA_EXTERN gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event,
                                                            guint primary_modifier);
VALA_EXTERN gint switcher_run (Switcher* self,
                   guint keyval,
                   guint state,
                   GdkEvent* event,
                   IBusEngineDesc** engines,
                   gint engines_length1,
                   gint index,
                   const gchar* input_context_path);
static void panel_switcher_focus_set_engine (Panel* self);
VALA_EXTERN gint switcher_run_popup (Switcher* self,
                         IBusEngineDesc** engines,
                         gint engines_length1,
                         gint index);
static gboolean ___lambda105_ (Panel* self);
static void panel_handle_engine_switch_release (Panel* self,
                                         gboolean is_timeout);
static gpointer ____lambda105__gthread_func (gpointer self);
static void panel_run_preload_engines (Panel* self,
                                IBusEngineDesc** engines,
                                gint engines_length1,
                                gint index);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void _vala_array_add22 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean __lambda62_ (Block8Data* _data8_);
static gboolean ___lambda62__gsource_func (gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add23 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add24 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda61_ (Block9Data* _data9_,
                   gint id);
static void ____lambda61__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self,
                                   gssize length);
static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self,
                                   gssize length);
static void panel_context_render_string (Panel* self,
                                  cairo_t* cr,
                                  const gchar* symbol,
                                  gint image_width,
                                  gint image_height);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static cairo_surface_t* panel_create_cairo_image_surface_with_string (Panel* self,
                                                               const gchar* symbol,
                                                               gboolean cache);
static GdkPixbuf* panel_create_icon_pixbuf_with_string (Panel* self,
                                                 const gchar* symbol);
static void panel_show_setup_dialog (Panel* self);
static void __lambda88_ (Panel* self,
                  GPid pid,
                  gint state);
static void ___lambda88__gchild_watch_func (GPid pid,
                                     gint wait_status,
                                     gpointer self);
static void panel_show_about_dialog (Panel* self);
static void panel_run_ibus_command (Panel* self,
                             const gchar* args);
static void _vala_array_add25 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add26 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add27 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void panel_append_preferences_menu (Panel* self,
                                    GtkMenu* menu);
static void __lambda87_ (Panel* self,
                  GtkMenuItem* i);
static void ___lambda87__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void panel_append_emoji_menu (Panel* self,
                              GtkMenu* menu);
static void __lambda89_ (Panel* self,
                  GtkMenuItem* i);
static void ___lambda89__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda90_ (Panel* self,
                  GtkMenuItem* i);
static void ___lambda90__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda91_ (Panel* self,
                  GtkMenuItem* i);
static void ___lambda91__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda92_ (Panel* self,
                  GtkMenuItem* i);
static void ___lambda92__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
VALA_EXTERN gint property_manager_create_menu_items (PropertyManager* self,
                                         GtkMenu* menu);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void ____lambda93_ (Block10Data* _data10_,
                    GtkMenuItem* item);
static void _____lambda93__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void panel_set_properties (Panel* self,
                           IBusPropList* props);
static void panel_set_property (Panel* self,
                         IBusProperty* prop,
                         gboolean all_update);
static void panel_animate_icon (Panel* self,
                         const gchar* symbol,
                         gboolean all_update);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean __lambda106_ (Block11Data* _data11_);
VALA_EXTERN void indicator_set_cairo_image_surface_full (Indicator* self,
                                             cairo_surface_t* image,
                                             const gchar* icon_desc);
static gboolean ___lambda106__gsource_func (gpointer self);
static void panel_real_set_cursor_location (IBusPanelService* base,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height);
VALA_EXTERN void candidate_panel_set_cursor_location (CandidatePanel* self,
                                          gint x,
                                          gint y,
                                          gint width,
                                          gint height);
VALA_EXTERN void property_panel_set_cursor_location (PropertyPanel* self,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height);
static gboolean panel_switcher_focus_set_engine_real (Panel* self);
VALA_EXTERN IBusEngineDesc* switcher_get_selected_engine (Switcher* self);
VALA_EXTERN gchar* switcher_get_input_context_path (Switcher* self);
VALA_EXTERN void switcher_reset (Switcher* self);
VALA_EXTERN gboolean switcher_is_running (Switcher* self);
static gboolean ___lambda69_ (Panel* self);
static gboolean ____lambda69__gsource_func (gpointer self);
static void panel_real_focus_in (IBusPanelService* base,
                          const gchar* input_context_path);
VALA_EXTERN void property_panel_focus_in (PropertyPanel* self);
static void panel_real_focus_out (IBusPanelService* base,
                           const gchar* input_context_path);
static void panel_real_destroy_context (IBusPanelService* base,
                                 const gchar* input_context_path);
static void panel_real_register_properties (IBusPanelService* base,
                                     IBusPropList* props);
VALA_EXTERN void property_manager_set_properties (PropertyManager* self,
                                      IBusPropList* props);
VALA_EXTERN void property_panel_set_properties (PropertyPanel* self,
                                    IBusPropList* props);
static gboolean __lambda107_ (Panel* self);
static gboolean ___lambda107__gsource_func (gpointer self);
static void panel_real_update_property (IBusPanelService* base,
                                 IBusProperty* prop);
VALA_EXTERN void property_manager_update_property (PropertyManager* self,
                                       IBusProperty* prop);
VALA_EXTERN void property_panel_update_property (PropertyPanel* self,
                                     IBusProperty* prop);
static void panel_real_update_preedit_text (IBusPanelService* base,
                                     IBusText* text,
                                     guint cursor_pos,
                                     gboolean visible);
VALA_EXTERN void candidate_panel_set_preedit_text (CandidatePanel* self,
                                       IBusText* text,
                                       guint cursor);
VALA_EXTERN void property_panel_set_preedit_text (PropertyPanel* self,
                                      IBusText* text,
                                      guint cursor);
static void panel_real_hide_preedit_text (IBusPanelService* base);
static void panel_real_update_auxiliary_text (IBusPanelService* base,
                                       IBusText* text,
                                       gboolean visible);
VALA_EXTERN void candidate_panel_set_auxiliary_text (CandidatePanel* self,
                                         IBusText* text);
VALA_EXTERN void property_panel_set_auxiliary_text (PropertyPanel* self,
                                        IBusText* text);
static void panel_real_hide_auxiliary_text (IBusPanelService* base);
static void panel_real_update_lookup_table (IBusPanelService* base,
                                     IBusLookupTable* table,
                                     gboolean visible);
VALA_EXTERN void candidate_panel_set_lookup_table (CandidatePanel* self,
                                       IBusLookupTable* table);
VALA_EXTERN void property_panel_set_lookup_table (PropertyPanel* self,
                                      IBusLookupTable* table);
static void panel_real_hide_lookup_table (IBusPanelService* base);
static void panel_real_set_content_type (IBusPanelService* base,
                                  guint purpose,
                                  guint hints);
VALA_EXTERN void candidate_panel_set_content_type (CandidatePanel* self,
                                       guint purpose,
                                       guint hints);
static void panel_real_state_changed (IBusPanelService* base);
VALA_EXTERN void indicator_set_icon_full (Indicator* self,
                              const gchar* icon_name,
                              const gchar* icon_desc);
VALA_EXTERN gchar* switcher_get_xkb_language (Switcher* self,
                                  IBusEngineDesc* engine);
static void _vala_array_add28 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void g_cclosure_user_marshal_VOID__POINTER_INT_ENUM (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static void panel_finalize (GObject * obj);
static GType panel_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
panel_get_instance_private (Panel* self)
{
	return G_STRUCT_MEMBER_P (self, Panel_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GType
panel_icon_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PANEL_ICON_TYPE_STATUS_ICON, "PANEL_ICON_TYPE_STATUS_ICON", "status-icon"}, {PANEL_ICON_TYPE_INDICATOR, "PANEL_ICON_TYPE_INDICATOR", "indicator"}, {0, NULL, NULL}};
	GType panel_icon_type_type_id;
	panel_icon_type_type_id = g_enum_register_static ("PanelIconType", values);
	return panel_icon_type_type_id;
}

static GType
panel_icon_type_get_type (void)
{
	static volatile gsize panel_icon_type_type_id__once = 0;
	if (g_once_init_enter (&panel_icon_type_type_id__once)) {
		GType panel_icon_type_type_id;
		panel_icon_type_type_id = panel_icon_type_get_type_once ();
		g_once_init_leave (&panel_icon_type_type_id__once, panel_icon_type_type_id);
	}
	return panel_icon_type_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_cairo_surface_destroy0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda84_ (Panel* self,
             PropertyManager* w,
             const gchar* k,
             gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	ibus_panel_service_property_activate ((IBusPanelService*) self, k, (guint) s);
}

static void
___lambda84__property_manager_property_activate (PropertyManager* _sender,
                                                 const gchar* key,
                                                 gint state,
                                                 gpointer self)
{
	__lambda84_ ((Panel*) self, _sender, key, state);
}

static void
__lambda96_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_up ((IBusPanelService*) self);
}

static void
___lambda96__candidate_panel_page_up (CandidatePanel* _sender,
                                      gpointer self)
{
	__lambda96_ ((Panel*) self, _sender);
}

static void
__lambda97_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_down ((IBusPanelService*) self);
}

static void
___lambda97__candidate_panel_page_down (CandidatePanel* _sender,
                                        gpointer self)
{
	__lambda97_ ((Panel*) self, _sender);
}

static void
__lambda98_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_cursor_up ((IBusPanelService*) self);
}

static void
___lambda98__candidate_panel_cursor_up (CandidatePanel* _sender,
                                        gpointer self)
{
	__lambda98_ ((Panel*) self, _sender);
}

static void
__lambda99_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_cursor_down ((IBusPanelService*) self);
}

static void
___lambda99__candidate_panel_cursor_down (CandidatePanel* _sender,
                                          gpointer self)
{
	__lambda99_ ((Panel*) self, _sender);
}

static void
__lambda100_ (Panel* self,
              CandidatePanel* w,
              guint i,
              guint b,
              guint s)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_candidate_clicked ((IBusPanelService*) self, i, b, s);
}

static void
___lambda100__candidate_panel_candidate_clicked (CandidatePanel* _sender,
                                                 guint index,
                                                 guint button,
                                                 guint state,
                                                 gpointer self)
{
	__lambda100_ ((Panel*) self, _sender, index, button, state);
}

static void
__lambda101_ (Panel* self,
              CandidatePanel* w,
              void* s)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, panel_signals[PANEL_REALIZE_SURFACE_SIGNAL], 0, s);
}

static void
___lambda101__candidate_panel_realize_surface (CandidatePanel* _sender,
                                               void* surface,
                                               gpointer self)
{
	__lambda101_ ((Panel*) self, _sender, surface);
}

static void
__lambda102_ (Panel* self,
              Switcher* w,
              void* s)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, panel_signals[PANEL_REALIZE_SURFACE_SIGNAL], 0, s);
}

static void
___lambda102__switcher_realize_surface (Switcher* _sender,
                                        void* surface,
                                        gpointer self)
{
	__lambda102_ ((Panel*) self, _sender, surface);
}

static void
__lambda103_ (Panel* self,
              PropertyPanel* w,
              const gchar* k,
              gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	ibus_panel_service_property_activate ((IBusPanelService*) self, k, (guint) s);
}

static void
___lambda103__property_panel_property_activate (PropertyPanel* _sender,
                                                const gchar* key,
                                                gint state,
                                                gpointer self)
{
	__lambda103_ ((Panel*) self, _sender, key, state);
}

Panel*
panel_construct (GType object_type,
                 IBusBus* bus,
                 gboolean is_wayland_im)
{
	Panel * self = NULL;
	GDBusConnection* _tmp0_;
	IBusBus* _tmp1_;
	PropertyManager* _tmp2_;
	PropertyManager* _tmp3_;
	CandidatePanel* _tmp4_;
	CandidatePanel* _tmp5_;
	CandidatePanel* _tmp6_;
	CandidatePanel* _tmp7_;
	CandidatePanel* _tmp8_;
	CandidatePanel* _tmp9_;
	CandidatePanel* _tmp10_;
	Switcher* _tmp11_;
	Switcher* _tmp12_;
	PropertyPanel* _tmp14_;
	PropertyPanel* _tmp15_;
	g_return_val_if_fail (bus != NULL, NULL);
	_vala_assert (ibus_bus_is_connected (bus), "bus.is_connected()");
	_tmp0_ = ibus_bus_get_connection (bus);
	self = (Panel*) g_object_new (object_type, "connection", _tmp0_, "object-path", "/org/freedesktop/IBus/Panel", NULL);
	_tmp1_ = _g_object_ref0 (bus);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp1_;
	self->priv->m_is_wayland_im = is_wayland_im;
	self->priv->m_is_wayland = !binding_common_default_is_xdisplay ();
	panel_init_settings (self);
	_tmp2_ = property_manager_new ();
	_property_manager_unref0 (self->priv->m_property_manager);
	self->priv->m_property_manager = _tmp2_;
	_tmp3_ = self->priv->m_property_manager;
	g_signal_connect_object (_tmp3_, "property-activate", (GCallback) ___lambda84__property_manager_property_activate, self, 0);
	if (self->priv->m_is_kde) {
		panel_init_indicator (self);
	} else {
		panel_init_status_icon (self);
	}
	_tmp4_ = candidate_panel_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_candidate_panel);
	self->priv->m_candidate_panel = _tmp4_;
	_tmp5_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp5_, "page-up", (GCallback) ___lambda96__candidate_panel_page_up, self, 0);
	_tmp6_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp6_, "page-down", (GCallback) ___lambda97__candidate_panel_page_down, self, 0);
	_tmp7_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp7_, "cursor-up", (GCallback) ___lambda98__candidate_panel_cursor_up, self, 0);
	_tmp8_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp8_, "cursor-down", (GCallback) ___lambda99__candidate_panel_cursor_down, self, 0);
	_tmp9_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp9_, "candidate-clicked", (GCallback) ___lambda100__candidate_panel_candidate_clicked, self, 0);
	_tmp10_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp10_, "realize-surface", (GCallback) ___lambda101__candidate_panel_realize_surface, self, 0);
	_tmp11_ = switcher_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->m_switcher);
	self->priv->m_switcher = _tmp11_;
	_tmp12_ = self->priv->m_switcher;
	g_signal_connect_object (_tmp12_, "realize-surface", (GCallback) ___lambda102__switcher_realize_surface, self, 0);
	panel_bind_switch_shortcut (self);
	if (self->priv->m_switcher_delay_time >= 0) {
		Switcher* _tmp13_;
		_tmp13_ = self->priv->m_switcher;
		switcher_set_popup_delay_time (_tmp13_, (guint) self->priv->m_switcher_delay_time);
	}
	_tmp14_ = property_panel_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->m_property_panel);
	self->priv->m_property_panel = _tmp14_;
	_tmp15_ = self->priv->m_property_panel;
	g_signal_connect_object (_tmp15_, "property-activate", (GCallback) ___lambda103__property_panel_property_activate, self, 0);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
	return self;
}

Panel*
panel_new (IBusBus* bus,
           gboolean is_wayland_im)
{
	return panel_construct (TYPE_PANEL, bus, is_wayland_im);
}

static void
__lambda60_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, key);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	panel_update_engines (self, _tmp3_, (gint) _vala_array_length (_tmp1_), NULL, (gint) 0);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda60__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda60_ ((Panel*) self, key);
}

static void
__lambda63_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_switcher_delay_time (self);
}

static void
___lambda63__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda63_ ((Panel*) self, key);
}

static void
__lambda64_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_use_system_keyboard_layout (self);
}

static void
___lambda64__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda64_ ((Panel*) self, key);
}

static void
__lambda65_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_embed_preedit_text (self);
}

static void
___lambda65__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda65_ ((Panel*) self, key);
}

static void
__lambda66_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_use_global_engine (self);
}

static void
___lambda66__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda66_ ((Panel*) self, key);
}

static void
__lambda67_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_use_xmodmap (self);
}

static void
___lambda67__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda67_ ((Panel*) self, key);
}

static void
__lambda68_ (Panel* self,
             const gchar* key)
{
	GList* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_keybindings;
	binding_common_unbind_switch_shortcut (BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER, _tmp0_);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	self->priv->m_keybindings = NULL;
	panel_bind_switch_shortcut (self);
}

static void
___lambda68__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda68_ ((Panel*) self, key);
}

static void
__lambda70_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_font (_tmp0_, NULL, &self->priv->m_css_provider);
}

static void
___lambda70__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda70_ ((Panel*) self, key);
}

static void
__lambda71_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_font (_tmp0_, NULL, &self->priv->m_css_provider);
}

static void
___lambda71__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda71_ ((Panel*) self, key);
}

static void
__lambda72_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_theme (_tmp0_);
}

static void
___lambda72__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda72_ ((Panel*) self, key);
}

static void
__lambda73_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_theme (_tmp0_);
}

static void
___lambda73__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda73_ ((Panel*) self, key);
}

static void
__lambda74_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_icon (_tmp0_);
}

static void
___lambda74__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda74_ ((Panel*) self, key);
}

static void
__lambda75_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_icon (_tmp0_);
}

static void
___lambda75__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda75_ ((Panel*) self, key);
}

static void
__lambda76_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	IBusEngineDesc* engine = NULL;
	IBusBus* _tmp1_;
	IBusEngineDesc* _tmp2_;
	IBusEngineDesc* _tmp3_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	self->priv->m_use_engine_lang = g_settings_get_boolean (_tmp0_, "use-glyph-from-engine-lang");
	_tmp1_ = self->priv->m_bus;
	_tmp2_ = ibus_bus_get_global_engine (_tmp1_);
	engine = _tmp2_;
	_tmp3_ = engine;
	if (_tmp3_ != NULL) {
		IBusEngineDesc* _tmp4_;
		_tmp4_ = engine;
		panel_set_language_from_engine (self, _tmp4_);
	}
	_g_object_unref0 (engine);
}

static void
___lambda76__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda76_ ((Panel*) self, key);
}

static void
__lambda77_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_show_icon_on_systray (self, TRUE);
}

static void
___lambda77__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda77_ ((Panel*) self, key);
}

static void
__lambda78_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_lookup_table_orientation (self);
}

static void
___lambda78__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda78_ ((Panel*) self, key);
}

static void
__lambda79_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_show_property_panel (self);
}

static void
___lambda79__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda79_ ((Panel*) self, key);
}

static void
__lambda80_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_timeout_property_panel (self);
}

static void
___lambda80__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda80_ ((Panel*) self, key);
}

static void
__lambda81_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_follow_input_cursor_when_always_shown_property_panel (self);
}

static void
___lambda81__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda81_ ((Panel*) self, key);
}

static void
__lambda82_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_xkb_icon_rgba (self);
}

static void
___lambda82__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda82_ ((Panel*) self, key);
}

static void
__lambda83_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_property_icon_delay_time (self);
}

static void
___lambda83__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda83_ ((Panel*) self, key);
}

static void
panel_init_settings (Panel* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.general");
	_g_object_unref0 (self->priv->m_settings_general);
	self->priv->m_settings_general = _tmp0_;
	_tmp1_ = g_settings_new ("org.freedesktop.ibus.general.hotkey");
	_g_object_unref0 (self->priv->m_settings_hotkey);
	self->priv->m_settings_hotkey = _tmp1_;
	_tmp2_ = g_settings_new ("org.freedesktop.ibus.panel");
	_g_object_unref0 (self->priv->m_settings_panel);
	self->priv->m_settings_panel = _tmp2_;
	_tmp3_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp3_, "changed::preload-engines", (GCallback) ___lambda60__g_settings_changed, self, 0);
	_tmp4_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp4_, "changed::switcher-delay-time", (GCallback) ___lambda63__g_settings_changed, self, 0);
	_tmp5_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp5_, "changed::use-system-keyboard-layout", (GCallback) ___lambda64__g_settings_changed, self, 0);
	_tmp6_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp6_, "changed::embed-preedit-text", (GCallback) ___lambda65__g_settings_changed, self, 0);
	_tmp7_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp7_, "changed::use-global-engine", (GCallback) ___lambda66__g_settings_changed, self, 0);
	_tmp8_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp8_, "changed::use-xmodmap", (GCallback) ___lambda67__g_settings_changed, self, 0);
	_tmp9_ = self->priv->m_settings_hotkey;
	g_signal_connect_object (_tmp9_, "changed::triggers", (GCallback) ___lambda68__g_settings_changed, self, 0);
	_tmp10_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp10_, "changed::custom-font", (GCallback) ___lambda70__g_settings_changed, self, 0);
	_tmp11_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp11_, "changed::use-custom-font", (GCallback) ___lambda71__g_settings_changed, self, 0);
	_tmp12_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp12_, "changed::custom-theme", (GCallback) ___lambda72__g_settings_changed, self, 0);
	_tmp13_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp13_, "changed::use-custom-theme", (GCallback) ___lambda73__g_settings_changed, self, 0);
	_tmp14_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp14_, "changed::custom-icon", (GCallback) ___lambda74__g_settings_changed, self, 0);
	_tmp15_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp15_, "changed::use-custom-icon", (GCallback) ___lambda75__g_settings_changed, self, 0);
	_tmp16_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp16_, "changed::use-glyph-from-engine-lang", (GCallback) ___lambda76__g_settings_changed, self, 0);
	_tmp17_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp17_, "changed::show-icon-on-systray", (GCallback) ___lambda77__g_settings_changed, self, 0);
	_tmp18_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp18_, "changed::lookup-table-orientation", (GCallback) ___lambda78__g_settings_changed, self, 0);
	_tmp19_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp19_, "changed::show", (GCallback) ___lambda79__g_settings_changed, self, 0);
	_tmp20_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp20_, "changed::timeout", (GCallback) ___lambda80__g_settings_changed, self, 0);
	_tmp21_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp21_, "changed::follow-input-cursor-when-always-shown", (GCallback) ___lambda81__g_settings_changed, self, 0);
	_tmp22_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp22_, "changed::xkb-icon-rgba", (GCallback) ___lambda82__g_settings_changed, self, 0);
	_tmp23_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp23_, "changed::property-icon-delay-time", (GCallback) ___lambda83__g_settings_changed, self, 0);
}

static void
panel_popup_menu_at_area_window (Panel* self,
                                 GtkMenu* menu,
                                 GdkRectangle* area,
                                 GdkWindow* window,
                                 GtkMenuPositionFunc func,
                                 gpointer func_target)
{
	GdkGravity rect_anchor = 0;
	GdkGravity menu_anchor = 0;
	GdkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (area != NULL);
	rect_anchor = GDK_GRAVITY_SOUTH_WEST;
	menu_anchor = GDK_GRAVITY_NORTH_WEST;
	_tmp0_ = *area;
	gtk_menu_popup_at_rect (menu, window, &_tmp0_, rect_anchor, menu_anchor, NULL);
}

static gboolean
panel_is_gnome (void)
{
	const gchar* desktop = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean result;
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	desktop = _tmp0_;
	_tmp1_ = desktop;
	if (g_strcmp0 (_tmp1_, "GNOME") == 0) {
		result = TRUE;
		return result;
	}
	_tmp3_ = desktop;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = desktop;
		_tmp2_ = g_strcmp0 (_tmp4_, "(null)") == 0;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = g_getenv ("XDG_SESSION_DESKTOP");
		desktop = _tmp5_;
	}
	_tmp7_ = desktop;
	if (g_strcmp0 (_tmp7_, "gnome") == 0) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = desktop;
		_tmp6_ = g_strcmp0 (_tmp8_, "GNOME") == 0;
	}
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
panel_is_kde (void)
{
	const gchar* desktop = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp9_;
	gboolean result;
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	desktop = _tmp0_;
	_tmp1_ = desktop;
	if (g_strcmp0 (_tmp1_, "KDE") == 0) {
		result = TRUE;
		return result;
	}
	_tmp3_ = desktop;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = desktop;
		_tmp2_ = g_strcmp0 (_tmp4_, "(null)") == 0;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = g_getenv ("XDG_SESSION_DESKTOP");
		desktop = _tmp5_;
	}
	_tmp7_ = desktop;
	if (g_strcmp0 (_tmp7_, "plasma") == 0) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = desktop;
		_tmp6_ = g_strcmp0 (_tmp8_, "KDE-wayland") == 0;
	}
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	_tmp9_ = desktop;
	if (_tmp9_ == NULL) {
		g_warning ("panel.vala:337: %s", "XDG_CURRENT_DESKTOP is not exported in your desktop " "session.");
	}
	g_warning ("panel.vala:340: %s", "If you launch KDE5 on xterm, " "export XDG_CURRENT_DESKTOP=KDE before launch KDE5.");
	result = FALSE;
	return result;
}

static void
panel_popup_menu_at_pointer_window (Panel* self,
                                    GtkMenu* menu,
                                    gint x,
                                    gint y,
                                    GdkWindow* window,
                                    GtkMenuPositionFunc func,
                                    gpointer func_target)
{
	gint win_x = 0;
	gint win_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkRectangle area = {0};
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	win_x = 0;
	win_y = 0;
	gdk_window_get_origin (window, &_tmp0_, &_tmp1_);
	win_x = _tmp0_;
	win_y = _tmp1_;
	_tmp2_.x = x - win_x;
	_tmp2_.y = y - win_y;
	_tmp2_.width = 1;
	_tmp2_.height = 1;
	area = _tmp2_;
	_tmp3_ = area;
	panel_popup_menu_at_area_window (self, menu, &_tmp3_, window, func, func_target);
}

static void
__lambda85_ (Panel* self)
{
	Indicator* _tmp0_;
	_tmp0_ = self->priv->m_indicator;
	indicator_set_status (_tmp0_, self->priv->m_indicator_show_status);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
}

static void
___lambda85__indicator_registered_status_notifier_item (Indicator* _sender,
                                                        gpointer self)
{
	__lambda85_ ((Panel*) self);
}

static void
__lambda86_ (Panel* self)
{
	self->priv->m_is_context_menu = !self->priv->m_is_context_menu;
	if (self->priv->m_is_context_menu) {
		Indicator* _tmp0_;
		GtkMenu* _tmp1_;
		GtkMenu* _tmp2_;
		_tmp0_ = self->priv->m_indicator;
		_tmp1_ = panel_create_context_menu (self, FALSE);
		_tmp2_ = _tmp1_;
		indicator_set_menu (_tmp0_, _tmp2_);
		_g_object_unref0 (_tmp2_);
	} else {
		Indicator* _tmp3_;
		GtkMenu* _tmp4_;
		GtkMenu* _tmp5_;
		_tmp3_ = self->priv->m_indicator;
		_tmp4_ = panel_create_activate_menu (self, FALSE);
		_tmp5_ = _tmp4_;
		indicator_set_menu (_tmp3_, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
}

static void
___lambda86__indicator_secondary_activate (Indicator* _sender,
                                           gpointer self)
{
	__lambda86_ ((Panel*) self);
}

static void
panel_init_indicator (Panel* self)
{
	Indicator* _tmp0_;
	Indicator* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	Indicator* _tmp4_;
	gulong _tmp5_;
	Indicator* _tmp6_;
	gulong _tmp7_;
	Indicator* _tmp8_;
	GtkMenu* _tmp9_;
	GtkMenu* _tmp10_;
	g_return_if_fail (self != NULL);
	self->priv->m_icon_type = PANEL_ICON_TYPE_INDICATOR;
	_tmp0_ = indicator_new ("ibus-ui-gtk3", INDICATOR_CATEGORY_APPLICATION_STATUS);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_indicator);
	self->priv->m_indicator = _tmp0_;
	_tmp1_ = self->priv->m_indicator;
	_tmp2_ = g_strdup_printf ("%s\n%s", _ ("IBus Panel"), _ ("You can toggle the activate menu and context one with " "clicking the mouse middle button on the panel icon."));
	_tmp3_ = _tmp2_;
	indicator_set_title (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->m_indicator;
	_tmp5_ = g_signal_connect_object (_tmp4_, "registered-status-notifier-item", (GCallback) ___lambda85__indicator_registered_status_notifier_item, self, 0);
	self->priv->m_registered_status_notifier_item_id = _tmp5_;
	_tmp6_ = self->priv->m_indicator;
	_tmp7_ = g_signal_connect_object (_tmp6_, "secondary-activate", (GCallback) ___lambda86__indicator_secondary_activate, self, 0);
	self->priv->m_popup_menu_id = _tmp7_;
	_tmp8_ = self->priv->m_indicator;
	_tmp9_ = panel_create_activate_menu (self, FALSE);
	_tmp10_ = _tmp9_;
	indicator_set_menu (_tmp8_, _tmp10_);
	_g_object_unref0 (_tmp10_);
}

static void
_panel_init_status_icon_menu_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	panel_init_status_icon_menu ((Panel*) self);
}

static void
panel_init_status_icon (Panel* self)
{
	GtkStatusIcon* _tmp0_;
	GtkStatusIcon* _tmp1_;
	GtkStatusIcon* _tmp2_;
	GtkStatusIcon* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->m_status_icon);
	self->priv->m_status_icon = _tmp0_;
	_tmp1_ = self->priv->m_status_icon;
	gtk_status_icon_set_name (_tmp1_, "ibus-ui-gtk");
	_tmp2_ = self->priv->m_status_icon;
	gtk_status_icon_set_title (_tmp2_, _ ("IBus Panel"));
	_tmp3_ = self->priv->m_status_icon;
	if (gtk_status_icon_get_size (_tmp3_) > 0) {
		panel_init_status_icon_menu (self);
	} else {
		GtkStatusIcon* _tmp4_;
		_tmp4_ = self->priv->m_status_icon;
		g_signal_connect_object ((GObject*) _tmp4_, "notify::size", (GCallback) _panel_init_status_icon_menu_g_object_notify, self, 0);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		Panel* self;
		self = _data7_->self;
		(_data7_->func_target_destroy_notify == NULL) ? NULL : (_data7_->func_target_destroy_notify (_data7_->func_target), NULL);
		_data7_->func = NULL;
		_data7_->func_target = NULL;
		_data7_->func_target_destroy_notify = NULL;
		_g_object_unref0 (_data7_->window);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda94_ (Block7Data* _data7_,
             guint b,
             guint t)
{
	Panel* self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GdkRectangle _tmp2_;
	GdkWindow* _tmp3_;
	GtkMenuPositionFunc _tmp4_;
	gpointer _tmp4__target;
	self = _data7_->self;
	_tmp0_ = panel_create_context_menu (self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data7_->area;
	_tmp3_ = _data7_->window;
	_tmp4_ = _data7_->func;
	_tmp4__target = _data7_->func_target;
	panel_popup_menu_at_area_window (self, _tmp1_, &_tmp2_, _tmp3_, _tmp4_, _tmp4__target);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda94__gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                         guint button,
                                         guint activate_time,
                                         gpointer self)
{
	__lambda94_ (self, button, activate_time);
}

static void
__lambda95_ (Block7Data* _data7_)
{
	Panel* self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GdkRectangle _tmp2_;
	GdkWindow* _tmp3_;
	GtkMenuPositionFunc _tmp4_;
	gpointer _tmp4__target;
	self = _data7_->self;
	_tmp0_ = panel_create_activate_menu (self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data7_->area;
	_tmp3_ = _data7_->window;
	_tmp4_ = _data7_->func;
	_tmp4__target = _data7_->func_target;
	panel_popup_menu_at_area_window (self, _tmp1_, &_tmp2_, _tmp3_, _tmp4_, _tmp4__target);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda95__gtk_status_icon_activate (GtkStatusIcon* _sender,
                                       gpointer self)
{
	__lambda95_ (self);
}

static void
panel_init_status_icon_menu (Panel* self)
{
	Block7Data* _data7_;
	GdkRectangle _tmp0_ = {0};
	GtkStatusIcon* _tmp1_;
	GdkX11Display* display = NULL;
	GdkX11Display* _tmp2_;
	GdkX11Display* _tmp3_;
	GdkX11Display* _tmp4_;
	GtkStatusIcon* _tmp5_;
	GdkX11Window* _tmp6_;
	GdkWindow* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GdkWindow* _tmp9_;
	GdkWindow* _tmp19_;
	GtkOrientation orient = 0;
	GtkStatusIcon* _tmp20_;
	GdkRectangle _tmp21_ = {0};
	GtkOrientation _tmp22_ = 0;
	gint win_x = 0;
	gint win_y = 0;
	GdkWindow* _tmp23_;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkStatusIcon* _tmp26_;
	gulong _tmp27_;
	GtkStatusIcon* _tmp28_;
	gulong _tmp29_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	_data7_->area = _tmp0_;
	_data7_->window = NULL;
	_data7_->func = NULL;
	_data7_->func_target = NULL;
	_data7_->func_target_destroy_notify = NULL;
	_tmp1_ = self->priv->m_status_icon;
	gtk_status_icon_set_from_icon_name (_tmp1_, "ibus-keyboard");
	_tmp2_ = binding_common_get_xdisplay ();
	display = _tmp2_;
	_tmp3_ = display;
	if (_tmp3_ == NULL) {
		g_warning ("panel.vala:402: No Gdk.X11.Display");
		_g_object_unref0 (display);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp4_ = display;
	_tmp5_ = self->priv->m_status_icon;
	_tmp6_ = gdk_x11_window_lookup_for_display (_tmp4_, (Window) gtk_status_icon_get_x11_window_id (_tmp5_));
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gdk_window_get_type ()) ? ((GdkWindow*) _tmp6_) : NULL);
	_g_object_unref0 (_data7_->window);
	_data7_->window = _tmp7_;
	_tmp9_ = _data7_->window;
	if (_tmp9_ == NULL) {
		_tmp8_ = !binding_common_default_is_xdisplay ();
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		Display* xdisplay = NULL;
		GdkX11Display* _tmp10_;
		Display* _tmp11_;
		Window root = 0;
		Display* _tmp12_;
		GdkX11Display* _tmp13_;
		GdkX11Window* _tmp14_;
		GdkWindow* _tmp15_;
		GdkWindow* _tmp16_;
		_tmp10_ = display;
		_tmp11_ = gdk_x11_display_get_xdisplay (_tmp10_);
		xdisplay = _tmp11_;
		_tmp12_ = xdisplay;
		root = DefaultRootWindow (_tmp12_);
		_tmp13_ = display;
		_tmp14_ = gdk_x11_window_lookup_for_display (_tmp13_, root);
		_tmp15_ = _g_object_ref0 ((GdkWindow*) _tmp14_);
		_g_object_unref0 (_data7_->window);
		_data7_->window = _tmp15_;
		_tmp16_ = _data7_->window;
		if (_tmp16_ == NULL) {
			GdkX11Display* _tmp17_;
			GdkX11Window* _tmp18_;
			_tmp17_ = display;
			_tmp18_ = (GdkX11Window*) gdk_x11_window_foreign_new_for_display (_tmp17_, root);
			_g_object_unref0 (_data7_->window);
			_data7_->window = (GdkWindow*) _tmp18_;
		}
	}
	_tmp19_ = _data7_->window;
	if (_tmp19_ == NULL) {
		g_warning ("panel.vala:421: StatusIcon does not have GdkWindow");
		_g_object_unref0 (display);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp20_ = self->priv->m_status_icon;
	gtk_status_icon_get_geometry (_tmp20_, NULL, &_tmp21_, &_tmp22_);
	_data7_->area = _tmp21_;
	orient = _tmp22_;
	win_x = 0;
	win_y = 0;
	_tmp23_ = _data7_->window;
	gdk_window_get_origin (_tmp23_, &_tmp24_, &_tmp25_);
	win_x = _tmp24_;
	win_y = _tmp25_;
	_data7_->area.x = _data7_->area.x - win_x;
	_data7_->area.y = _data7_->area.y - win_y;
	_tmp26_ = self->priv->m_status_icon;
	_tmp27_ = g_signal_connect_data (_tmp26_, "popup-menu", (GCallback) ___lambda94__gtk_status_icon_popup_menu, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	self->priv->m_popup_menu_id = _tmp27_;
	_tmp28_ = self->priv->m_status_icon;
	_tmp29_ = g_signal_connect_data (_tmp28_, "activate", (GCallback) ___lambda95__gtk_status_icon_activate, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	self->priv->m_activate_id = _tmp29_;
	_g_object_unref0 (display);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
_panel_handle_engine_switch_normal_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                               gpointer self)
{
	panel_handle_engine_switch_normal ((Panel*) self, event);
}

static void
_panel_handle_engine_switch_reverse_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                                gpointer self)
{
	panel_handle_engine_switch_reverse ((Panel*) self, event);
}

static void
_vala_array_add18 (IBusProcessKeyEventData* * array,
                   gint* length,
                   gint* size,
                   const IBusProcessKeyEventData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusProcessKeyEventData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add19 (IBusProcessKeyEventData* * array,
                   gint* length,
                   gint* size,
                   const IBusProcessKeyEventData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusProcessKeyEventData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
panel_bind_switch_shortcut (Panel* self)
{
	gchar** accelerators = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint accelerators_length1;
	gint _accelerators_size_;
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp3_;
	BindingCommonKeyEventFuncType ftype = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	IBusProcessKeyEventData* keys = NULL;
	IBusProcessKeyEventData* _tmp8_;
	gint keys_length1;
	gint _keys_size_;
	IBusProcessKeyEventData key = {0};
	GList* _tmp9_;
	IBusProcessKeyEventData* _tmp23_;
	gint _tmp23__length1;
	IBusProcessKeyEventData _tmp24_ = {0};
	IBusProcessKeyEventData _tmp25_;
	IBusBus* _tmp26_;
	IBusProcessKeyEventData* _tmp27_;
	gint _tmp27__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_hotkey;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "triggers");
	accelerators = _tmp2_;
	accelerators_length1 = _vala_array_length (_tmp1_);
	_accelerators_size_ = accelerators_length1;
	_tmp3_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp3_;
	ftype = BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER;
	_tmp4_ = accelerators;
	_tmp4__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp4_;
		accelerator_collection_length1 = _tmp4__length1;
		for (accelerator_it = 0; accelerator_it < accelerator_collection_length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp5_;
			gchar* accelerator = NULL;
			_tmp5_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp5_;
			{
				KeybindingManager* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = keybinding_manager;
				_tmp7_ = accelerator;
				binding_common_keybinding_manager_bind (_tmp6_, &self->priv->m_keybindings, _tmp7_, ftype, _panel_handle_engine_switch_normal_keybinding_manager_keybinding_handler_func, self, _panel_handle_engine_switch_reverse_keybinding_manager_keybinding_handler_func, self);
				_g_free0 (accelerator);
			}
		}
	}
	if (binding_common_default_is_xdisplay ()) {
		_g_object_unref0 (keybinding_manager);
		accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp8_ = g_new0 (IBusProcessKeyEventData, 0);
	keys = _tmp8_;
	keys_length1 = 0;
	_keys_size_ = keys_length1;
	_tmp9_ = self->priv->m_keybindings;
	{
		GList* kb_collection = NULL;
		GList* kb_it = NULL;
		kb_collection = _tmp9_;
		for (kb_it = kb_collection; kb_it != NULL; kb_it = kb_it->next) {
			BindingCommonKeybinding* _tmp10_;
			BindingCommonKeybinding* kb = NULL;
			_tmp10_ = _g_object_ref0 ((BindingCommonKeybinding*) kb_it->data);
			kb = _tmp10_;
			{
				gint _tmp11_ = 0;
				BindingCommonKeybinding* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				BindingCommonKeybinding* _tmp15_;
				guint _tmp16_;
				guint _tmp17_;
				BindingCommonKeybinding* _tmp18_;
				GdkModifierType _tmp19_;
				GdkModifierType _tmp20_;
				IBusProcessKeyEventData _tmp21_ = {0};
				IBusProcessKeyEventData _tmp22_;
				_tmp12_ = kb;
				_tmp13_ = binding_common_keybinding_get_reverse (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_) {
					_tmp11_ = 1;
				} else {
					_tmp11_ = 0;
				}
				_tmp15_ = kb;
				_tmp16_ = binding_common_keybinding_get_keysym (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = kb;
				_tmp19_ = binding_common_keybinding_get_modifiers (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_.keyval = _tmp17_;
				_tmp21_.keycode = (guint) _tmp11_;
				_tmp21_.state = (guint) _tmp20_;
				key = _tmp21_;
				_tmp22_ = key;
				_vala_array_add18 (&keys, &keys_length1, &_keys_size_, &_tmp22_);
				_g_object_unref0 (kb);
			}
		}
	}
	_tmp23_ = keys;
	_tmp23__length1 = keys_length1;
	if (_tmp23__length1 == 0) {
		keys = (g_free (keys), NULL);
		_g_object_unref0 (keybinding_manager);
		accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp24_.keyval = (guint) 0;
	key = _tmp24_;
	_tmp25_ = key;
	_vala_array_add19 (&keys, &keys_length1, &_keys_size_, &_tmp25_);
	_tmp26_ = self->priv->m_bus;
	_tmp27_ = keys;
	_tmp27__length1 = keys_length1;
	ibus_bus_set_global_shortcut_keys_async (_tmp26_, IBUS_BUS_GLOBAL_BINDING_TYPE_IME_SWITCHER, _tmp27_, -1, NULL, NULL, NULL);
	keys = (g_free (keys), NULL);
	_g_object_unref0 (keybinding_manager);
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
}

/**
     * panel_get_engines_from_xkb:
     * @self: #Panel class
     * @engines: all engines from ibus_bus_list_engines()
     * @returns: ibus xkb engines
     *
     * Made ibus engines from the current XKB keymaps.
     * This returns only XKB engines whose name start with "xkb:".
     */
static GList*
panel_get_engines_from_xkb (Panel* self,
                            GList* engines)
{
	gchar* layouts = NULL;
	gchar* variants = NULL;
	gchar* option = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GList* xkb_engines = NULL;
	IBusEngineDesc* us_engine = NULL;
	IBusEngineDesc* _tmp3_;
	gchar** layout_array = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint layout_array_length1;
	gint _layout_array_size_;
	gchar** variant_array = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint variant_array_length1;
	gint _variant_array_size_;
	GList* _tmp45_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	xkb_layout_get_layout (&_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (layouts);
	layouts = _tmp0_;
	_g_free0 (variants);
	variants = _tmp1_;
	_g_free0 (option);
	option = _tmp2_;
	xkb_engines = NULL;
	_tmp3_ = ibus_engine_desc_new ("xkb:us::eng", "", "", "", "", "", "", "");
	g_object_ref_sink (_tmp3_);
	us_engine = _tmp3_;
	_tmp4_ = layouts;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
	layout_array = _tmp6_;
	layout_array_length1 = _vala_array_length (_tmp5_);
	_layout_array_size_ = layout_array_length1;
	_tmp7_ = variants;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ",", 0);
	variant_array = _tmp9_;
	variant_array_length1 = _vala_array_length (_tmp8_);
	_variant_array_size_ = variant_array_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gchar** _tmp12_;
				gint _tmp12__length1;
				gchar* layout = NULL;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* variant = NULL;
				IBusEngineDesc* current_engine = NULL;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp20_;
				IBusEngineDesc* _tmp35_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = layout_array;
				_tmp12__length1 = layout_array_length1;
				if (!(i < _tmp12__length1)) {
					break;
				}
				_tmp13_ = layout_array;
				_tmp13__length1 = layout_array_length1;
				_tmp14_ = _tmp13_[i];
				_tmp15_ = g_strdup (_tmp14_);
				layout = _tmp15_;
				variant = NULL;
				current_engine = NULL;
				_tmp16_ = variant_array;
				_tmp16__length1 = variant_array_length1;
				if (i < _tmp16__length1) {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = variant_array;
					_tmp17__length1 = variant_array_length1;
					_tmp18_ = _tmp17_[i];
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (variant);
					variant = _tmp19_;
				}
				_tmp20_ = variant;
				if (_tmp20_ == NULL) {
					gchar* _tmp21_;
					_tmp21_ = g_strdup ("");
					_g_free0 (variant);
					variant = _tmp21_;
				}
				{
					GList* engine_collection = NULL;
					GList* engine_it = NULL;
					engine_collection = engines;
					for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
						IBusEngineDesc* engine = NULL;
						engine = (IBusEngineDesc*) engine_it->data;
						{
							gchar* name = NULL;
							IBusEngineDesc* _tmp22_;
							const gchar* _tmp23_;
							gchar* _tmp24_;
							const gchar* _tmp25_;
							gboolean _tmp26_ = FALSE;
							IBusEngineDesc* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							_tmp22_ = engine;
							_tmp23_ = ibus_engine_desc_get_name (_tmp22_);
							_tmp24_ = g_strdup (_tmp23_);
							name = _tmp24_;
							_tmp25_ = name;
							if (!g_str_has_prefix (_tmp25_, "xkb:")) {
								_g_free0 (name);
								continue;
							}
							_tmp27_ = engine;
							_tmp28_ = ibus_engine_desc_get_layout (_tmp27_);
							_tmp29_ = layout;
							if (g_strcmp0 (_tmp28_, _tmp29_) == 0) {
								IBusEngineDesc* _tmp30_;
								const gchar* _tmp31_;
								const gchar* _tmp32_;
								_tmp30_ = engine;
								_tmp31_ = ibus_engine_desc_get_layout_variant (_tmp30_);
								_tmp32_ = variant;
								_tmp26_ = g_strcmp0 (_tmp31_, _tmp32_) == 0;
							} else {
								_tmp26_ = FALSE;
							}
							if (_tmp26_) {
								IBusEngineDesc* _tmp33_;
								IBusEngineDesc* _tmp34_;
								_tmp33_ = engine;
								_tmp34_ = _g_object_ref0 (_tmp33_);
								_g_object_unref0 (current_engine);
								current_engine = _tmp34_;
								_g_free0 (name);
								break;
							}
							_g_free0 (name);
						}
					}
				}
				_tmp35_ = current_engine;
				if (_tmp35_ != NULL) {
					IBusEngineDesc* _tmp36_;
					IBusEngineDesc* _tmp37_;
					_tmp36_ = current_engine;
					_tmp37_ = _g_object_ref0 (_tmp36_);
					xkb_engines = g_list_append (xkb_engines, _tmp37_);
				} else {
					GList* _tmp38_;
					IBusEngineDesc* _tmp39_;
					GList* _tmp40_;
					_tmp38_ = xkb_engines;
					_tmp39_ = us_engine;
					_tmp40_ = g_list_find (_tmp38_, _tmp39_);
					if (_tmp40_ == NULL) {
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						IBusEngineDesc* _tmp43_;
						IBusEngineDesc* _tmp44_;
						_tmp41_ = layout;
						_tmp42_ = variant;
						g_warning ("panel.vala:554: Fallback %s(%s) to us layout.", _tmp41_, _tmp42_);
						_tmp43_ = us_engine;
						_tmp44_ = _g_object_ref0 (_tmp43_);
						xkb_engines = g_list_append (xkb_engines, _tmp44_);
					}
				}
				_g_object_unref0 (current_engine);
				_g_free0 (variant);
				_g_free0 (layout);
			}
		}
	}
	_tmp45_ = xkb_engines;
	if (g_list_length (_tmp45_) == ((guint) 0)) {
		g_warning ("panel.vala:560: Not found IBus XKB engines from the session.");
	}
	result = xkb_engines;
	variant_array = (_vala_array_free (variant_array, variant_array_length1, (GDestroyNotify) g_free), NULL);
	layout_array = (_vala_array_free (layout_array, layout_array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (us_engine);
	_g_free0 (option);
	_g_free0 (variants);
	_g_free0 (layouts);
	return result;
}

/**
     * panel_get_engines_from_locale:
     * @self: #Panel class
     * @engines: all engines from ibus_bus_list_engines()
     * @returns: ibus im engines
     *
     * Made ibus engines from the current locale and IBus.EngineDesc.lang .
     * This returns non-XKB engines whose name does not start "xkb:".
     */
static gint
__lambda104_ (IBusEngineDesc* a,
              IBusEngineDesc* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = ((gint) ibus_engine_desc_get_rank (b)) - ((gint) ibus_engine_desc_get_rank (a));
	return result;
}

static gint
___lambda104__gcompare_func (gconstpointer a,
                             gconstpointer b)
{
	gint result;
	result = __lambda104_ ((IBusEngineDesc*) a, (IBusEngineDesc*) b);
	return result;
}

static GList*
panel_get_engines_from_locale (Panel* self,
                               GList* engines)
{
	gchar* locale = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lang = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GList* im_engines = NULL;
	GList* _tmp22_;
	GList* _tmp40_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = setlocale (LC_CTYPE, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	locale = _tmp1_;
	_tmp2_ = locale;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("C");
		_g_free0 (locale);
		locale = _tmp3_;
	}
	_tmp4_ = locale;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ".", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_tmp8_ = _tmp7_[0];
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	lang = _tmp10_;
	im_engines = NULL;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = engines;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				gchar* name = NULL;
				IBusEngineDesc* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				gboolean _tmp15_ = FALSE;
				IBusEngineDesc* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp11_ = engine;
				_tmp12_ = ibus_engine_desc_get_name (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				name = _tmp13_;
				_tmp14_ = name;
				if (g_str_has_prefix (_tmp14_, "xkb:")) {
					_g_free0 (name);
					continue;
				}
				_tmp16_ = engine;
				_tmp17_ = ibus_engine_desc_get_language (_tmp16_);
				_tmp18_ = lang;
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
					IBusEngineDesc* _tmp19_;
					_tmp19_ = engine;
					_tmp15_ = ibus_engine_desc_get_rank (_tmp19_) > ((guint) 0);
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					IBusEngineDesc* _tmp20_;
					IBusEngineDesc* _tmp21_;
					_tmp20_ = engine;
					_tmp21_ = _g_object_ref0 (_tmp20_);
					im_engines = g_list_append (im_engines, _tmp21_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp22_ = im_engines;
	if (g_list_length (_tmp22_) == ((guint) 0)) {
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp23_ = lang;
		_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "_", 0);
		_tmp26_ = _tmp25_;
		_tmp26__length1 = _vala_array_length (_tmp24_);
		_tmp27_ = _tmp26_[0];
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (lang);
		lang = _tmp28_;
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = engines;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					gchar* name = NULL;
					IBusEngineDesc* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					const gchar* _tmp32_;
					gboolean _tmp33_ = FALSE;
					IBusEngineDesc* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					_tmp29_ = engine;
					_tmp30_ = ibus_engine_desc_get_name (_tmp29_);
					_tmp31_ = g_strdup (_tmp30_);
					name = _tmp31_;
					_tmp32_ = name;
					if (g_str_has_prefix (_tmp32_, "xkb:")) {
						_g_free0 (name);
						continue;
					}
					_tmp34_ = engine;
					_tmp35_ = ibus_engine_desc_get_language (_tmp34_);
					_tmp36_ = lang;
					if (g_strcmp0 (_tmp35_, _tmp36_) == 0) {
						IBusEngineDesc* _tmp37_;
						_tmp37_ = engine;
						_tmp33_ = ibus_engine_desc_get_rank (_tmp37_) > ((guint) 0);
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						IBusEngineDesc* _tmp38_;
						IBusEngineDesc* _tmp39_;
						_tmp38_ = engine;
						_tmp39_ = _g_object_ref0 (_tmp38_);
						im_engines = g_list_append (im_engines, _tmp39_);
					}
					_g_free0 (name);
				}
			}
		}
	}
	_tmp40_ = im_engines;
	if (g_list_length (_tmp40_) == ((guint) 0)) {
		result = im_engines;
		_g_free0 (lang);
		_g_free0 (locale);
		return result;
	}
	im_engines = g_list_sort (im_engines, ___lambda104__gcompare_func);
	result = im_engines;
	_g_free0 (lang);
	_g_free0 (locale);
	return result;
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add21 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
panel_init_engines_order (Panel* self)
{
	XKBLayout* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSettings* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_;
	GList* engines = NULL;
	IBusBus* _tmp10_;
	GList* _tmp11_;
	GList* xkb_engines = NULL;
	GList* _tmp12_;
	GList* _tmp13_;
	GList* im_engines = NULL;
	GList* _tmp14_;
	GList* _tmp15_;
	gchar** names = NULL;
	gchar** _tmp16_;
	gint names_length1;
	gint _names_size_;
	GList* _tmp17_;
	GList* _tmp21_;
	GSettings* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = self->priv->m_settings_general;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "xkb-latin-layouts");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	xkb_layout_set_latin_layouts (_tmp0_, _tmp4_, (gint) _vala_array_length (_tmp2_));
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (self->priv->inited_engines_order) {
		return;
	}
	_tmp5_ = self->priv->m_settings_general;
	_tmp7_ = _tmp6_ = g_settings_get_strv (_tmp5_, "preload-engines");
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_tmp9_ = _vala_array_length (_tmp6_) > 0;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp9_) {
		return;
	}
	_tmp10_ = self->priv->m_bus;
	_tmp11_ = ibus_bus_list_engines (_tmp10_);
	engines = _tmp11_;
	_tmp12_ = engines;
	_tmp13_ = panel_get_engines_from_xkb (self, _tmp12_);
	xkb_engines = _tmp13_;
	_tmp14_ = engines;
	_tmp15_ = panel_get_engines_from_locale (self, _tmp14_);
	im_engines = _tmp15_;
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	names = _tmp16_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp17_ = xkb_engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp17_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				IBusEngineDesc* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = engine;
				_tmp19_ = ibus_engine_desc_get_name (_tmp18_);
				_tmp20_ = g_strdup (_tmp19_);
				_vala_array_add20 (&names, &names_length1, &_names_size_, _tmp20_);
			}
		}
	}
	_tmp21_ = im_engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp21_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				IBusEngineDesc* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp22_ = engine;
				_tmp23_ = ibus_engine_desc_get_name (_tmp22_);
				_tmp24_ = g_strdup (_tmp23_);
				_vala_array_add21 (&names, &names_length1, &_names_size_, _tmp24_);
			}
		}
	}
	_tmp25_ = self->priv->m_settings_general;
	_tmp26_ = names;
	_tmp26__length1 = names_length1;
	g_settings_set_strv (_tmp25_, "preload-engines", _tmp26_);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	(im_engines == NULL) ? NULL : (im_engines = (_g_list_free__g_object_unref0_ (im_engines), NULL));
	(xkb_engines == NULL) ? NULL : (xkb_engines = (_g_list_free__g_object_unref0_ (xkb_engines), NULL));
	(engines == NULL) ? NULL : (engines = (_g_list_free__g_object_unref0_ (engines), NULL));
}

static void
panel_set_switcher_delay_time (Panel* self)
{
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Switcher* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	self->priv->m_switcher_delay_time = g_settings_get_int (_tmp0_, "switcher-delay-time");
	_tmp2_ = self->priv->m_switcher;
	if (_tmp2_ != NULL) {
		_tmp1_ = self->priv->m_switcher_delay_time >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Switcher* _tmp3_;
		_tmp3_ = self->priv->m_switcher;
		switcher_set_popup_delay_time (_tmp3_, (guint) self->priv->m_switcher_delay_time);
	}
}

static void
panel_set_use_system_keyboard_layout (Panel* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	self->priv->m_use_system_keyboard_layout = g_settings_get_boolean (_tmp0_, "use-system-keyboard-layout");
}

static void
panel_set_embed_preedit_text (Panel* self)
{
	GVariant* variant = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	IBusBus* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_value (_tmp0_, "embed-preedit-text");
	variant = _tmp1_;
	_tmp2_ = variant;
	if (_tmp2_ == NULL) {
		_g_variant_unref0 (variant);
		return;
	}
	_tmp3_ = self->priv->m_bus;
	_tmp4_ = variant;
	ibus_bus_set_ibus_property (_tmp3_, "EmbedPreeditText", _tmp4_);
	_g_variant_unref0 (variant);
}

static void
panel_set_use_global_engine (Panel* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	self->priv->m_use_global_engine = g_settings_get_boolean (_tmp0_, "use-global-engine");
}

static void
panel_set_use_xmodmap (Panel* self)
{
	XKBLayout* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = self->priv->m_settings_general;
	xkb_layout_set_use_xmodmap (_tmp0_, g_settings_get_boolean (_tmp1_, "use-xmodmap"));
}

static void
panel_set_show_icon_on_systray (Panel* self,
                                gboolean update_now)
{
	g_return_if_fail (self != NULL);
	if (self->priv->m_icon_type == PANEL_ICON_TYPE_STATUS_ICON) {
		GtkStatusIcon* _tmp0_;
		GtkStatusIcon* _tmp1_;
		GSettings* _tmp2_;
		_tmp0_ = self->priv->m_status_icon;
		if (_tmp0_ == NULL) {
			return;
		}
		_tmp1_ = self->priv->m_status_icon;
		_tmp2_ = self->priv->m_settings_panel;
		gtk_status_icon_set_visible (_tmp1_, g_settings_get_boolean (_tmp2_, "show-icon-on-systray"));
	} else {
		if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
			Indicator* _tmp3_;
			GSettings* _tmp4_;
			_tmp3_ = self->priv->m_indicator;
			if (_tmp3_ == NULL) {
				return;
			}
			_tmp4_ = self->priv->m_settings_panel;
			if (g_settings_get_boolean (_tmp4_, "show-icon-on-systray")) {
				self->priv->m_indicator_show_status = INDICATOR_STATUS_ACTIVE;
			} else {
				self->priv->m_indicator_show_status = INDICATOR_STATUS_PASSIVE;
			}
			if (update_now) {
				Indicator* _tmp5_;
				_tmp5_ = self->priv->m_indicator;
				indicator_set_status (_tmp5_, self->priv->m_indicator_show_status);
			}
		}
	}
}

static void
panel_set_lookup_table_orientation (Panel* self)
{
	CandidatePanel* _tmp0_;
	CandidatePanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_candidate_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	_tmp2_ = self->priv->m_settings_panel;
	candidate_panel_set_vertical (_tmp1_, g_settings_get_int (_tmp2_, "lookup-table-orientation") == ((gint) IBUS_ORIENTATION_VERTICAL));
}

static void
panel_set_show_property_panel (Panel* self)
{
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	property_panel_set_show (_tmp1_, g_settings_get_int (_tmp2_, "show"));
}

static void
panel_set_timeout_property_panel (Panel* self)
{
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	property_panel_set_auto_hide_timeout (_tmp1_, (guint) g_settings_get_int (_tmp2_, "auto-hide-timeout"));
}

static void
panel_set_follow_input_cursor_when_always_shown_property_panel (Panel* self)
{
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	property_panel_set_follow_input_cursor_when_always_shown (_tmp1_, g_settings_get_boolean (_tmp2_, "follow-input-cursor-when-always-shown"));
}

static void
panel_set_xkb_icon_rgba (Panel* self)
{
	gchar* spec = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp2_ = {0};
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = g_settings_get_string (_tmp0_, "xkb-icon-rgba");
	spec = _tmp1_;
	_tmp2_.red = (gdouble) 0;
	rgba = _tmp2_;
	_tmp3_ = spec;
	if (!gdk_rgba_parse (&rgba, _tmp3_)) {
		const gchar* _tmp4_;
		GdkRGBA _tmp5_ = {0};
		_tmp4_ = spec;
		g_warning ("panel.vala:747: invalid format of xkb-icon-rgba: %s", _tmp4_);
		memset (&_tmp5_, 0, sizeof (GdkRGBA));
		_tmp5_.red = 0.0;
		_tmp5_.green = 0.0;
		_tmp5_.blue = 0.0;
		_tmp5_.alpha = 1.0;
		self->priv->m_xkb_icon_rgba = _tmp5_;
	} else {
		GdkRGBA _tmp6_;
		_tmp6_ = rgba;
		self->priv->m_xkb_icon_rgba = _tmp6_;
	}
	if (self->priv->m_icon_type == PANEL_ICON_TYPE_STATUS_ICON) {
		GHashTable* _tmp7_;
		_tmp7_ = self->priv->m_xkb_icon_pixbufs;
		if (g_hash_table_size (_tmp7_) > ((guint) 0)) {
			GHashTable* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GtkStatusIcon* _tmp10_;
			_tmp8_ = self->priv->m_xkb_icon_pixbufs;
			g_hash_table_remove_all (_tmp8_);
			_tmp10_ = self->priv->m_status_icon;
			if (_tmp10_ != NULL) {
				Switcher* _tmp11_;
				_tmp11_ = self->priv->m_switcher;
				_tmp9_ = _tmp11_ != NULL;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
			}
		}
	} else {
		if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
			GHashTable* _tmp12_;
			_tmp12_ = self->priv->m_xkb_icon_image;
			if (g_hash_table_size (_tmp12_) > ((guint) 0)) {
				GHashTable* _tmp13_;
				gboolean _tmp14_ = FALSE;
				Indicator* _tmp15_;
				_tmp13_ = self->priv->m_xkb_icon_image;
				g_hash_table_remove_all (_tmp13_);
				_tmp15_ = self->priv->m_indicator;
				if (_tmp15_ != NULL) {
					Switcher* _tmp16_;
					_tmp16_ = self->priv->m_switcher;
					_tmp14_ = _tmp16_ != NULL;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
				}
			}
		}
	}
	_g_free0 (spec);
}

static void
panel_set_property_icon_delay_time (Panel* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	self->priv->m_property_icon_delay_time = g_settings_get_int (_tmp0_, "property-icon-delay-time");
}

static gint
panel_compare_versions (Panel* self,
                        const gchar* version1,
                        const gchar* version2)
{
	gchar** version1_list = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint version1_list_length1;
	gint _version1_list_size_;
	gchar** version2_list = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint version2_list_length1;
	gint _version2_list_size_;
	gint major1 = 0;
	gint minor1 = 0;
	gint micro1 = 0;
	gint major2 = 0;
	gint minor2 = 0;
	gint micro2 = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (version1 != NULL, 0);
	g_return_val_if_fail (version2 != NULL, 0);
	_tmp1_ = _tmp0_ = g_strsplit (version1, ".", 0);
	version1_list = _tmp1_;
	version1_list_length1 = _vala_array_length (_tmp0_);
	_version1_list_size_ = version1_list_length1;
	_tmp3_ = _tmp2_ = g_strsplit (version2, ".", 0);
	version2_list = _tmp3_;
	version2_list_length1 = _vala_array_length (_tmp2_);
	_version2_list_size_ = version2_list_length1;
	if (g_strcmp0 (version1, version2) == 0) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (g_strcmp0 (version1, "") == 0) {
		result = -1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (g_strcmp0 (version2, "") == 0) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp4_ = version1_list;
	_tmp4__length1 = version1_list_length1;
	_vala_assert (_tmp4__length1 >= 3, "version1_list.length >= 3");
	_tmp5_ = version2_list;
	_tmp5__length1 = version2_list_length1;
	_vala_assert (_tmp5__length1 >= 3, "version2_list.length >= 3");
	_tmp6_ = version1_list;
	_tmp6__length1 = version1_list_length1;
	_tmp7_ = _tmp6_[0];
	major1 = atoi (_tmp7_);
	_tmp8_ = version1_list;
	_tmp8__length1 = version1_list_length1;
	_tmp9_ = _tmp8_[1];
	minor1 = atoi (_tmp9_);
	_tmp10_ = version1_list;
	_tmp10__length1 = version1_list_length1;
	_tmp11_ = _tmp10_[2];
	micro1 = atoi (_tmp11_);
	_tmp12_ = version2_list;
	_tmp12__length1 = version2_list_length1;
	_tmp13_ = _tmp12_[0];
	major2 = atoi (_tmp13_);
	_tmp14_ = version2_list;
	_tmp14__length1 = version2_list_length1;
	_tmp15_ = _tmp14_[1];
	minor2 = atoi (_tmp15_);
	_tmp16_ = version2_list;
	_tmp16__length1 = version2_list_length1;
	_tmp17_ = _tmp16_[2];
	micro2 = atoi (_tmp17_);
	if (major1 == minor1) {
		_tmp19_ = minor1 == minor2;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		_tmp18_ = micro1 == micro2;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (major1 > major2) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp22_ = FALSE;
		if (major1 == major2) {
			_tmp22_ = minor1 > minor2;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp21_ = _tmp22_;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		if (major1 == major2) {
			_tmp24_ = minor1 == minor2;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			_tmp23_ = micro1 > micro2;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp20_ = _tmp23_;
	}
	if (_tmp20_) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = -1;
	version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
	version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
panel_update_version_1_5_8 (Panel* self)
{
	g_return_if_fail (self != NULL);
	self->priv->inited_engines_order = FALSE;
}

static void
panel_set_version (Panel* self)
{
	gchar* prev_version = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* current_version = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GSettings* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_string (_tmp0_, "version");
	prev_version = _tmp1_;
	current_version = NULL;
	_tmp2_ = prev_version;
	if (panel_compare_versions (self, _tmp2_, "1.5.8") < 0) {
		panel_update_version_1_5_8 (self);
	}
	_tmp3_ = g_strdup_printf ("%d.%d.%d", IBUS_MAJOR_VERSION, IBUS_MINOR_VERSION, IBUS_MICRO_VERSION);
	_g_free0 (current_version);
	current_version = _tmp3_;
	_tmp4_ = prev_version;
	_tmp5_ = current_version;
	if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
		_g_free0 (current_version);
		_g_free0 (prev_version);
		return;
	}
	_tmp6_ = self->priv->m_settings_general;
	_tmp7_ = current_version;
	g_settings_set_string (_tmp6_, "version", _tmp7_);
	_g_free0 (current_version);
	_g_free0 (prev_version);
}

static void
panel_check_wayland (Panel* self)
{
	gchar* message = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp12_;
	NotifyNotification* notification = NULL;
	const gchar* _tmp13_;
	NotifyNotification* _tmp14_;
	NotifyNotification* _tmp15_;
	NotifyNotification* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	message = NULL;
	if (self->priv->m_is_wayland) {
		_tmp1_ = !self->priv->m_is_wayland_im;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !panel_is_gnome ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* format = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_strdup (_ ("IBus should be called from the desktop session in " "%s. For KDE, you can launch '%s' " "utility and go to \"Input Devices\" -> " "\"Virtual Keyboard\" section and select " "\"%s\" icon and click \"Apply\" button to " "configure IBus in %s. For other desktop " "sessions, you can copy the 'Exec=' line in %s file " "to a configuration file of the session. " "Please refer each document about the \"Wayland " "input method\" configuration. Before you configure " "the \"Wayland input method\", you should make sure " "that QT_IM_MODULE and GTK_IM_MODULE environment " "variables are unset in the desktop session."));
		format = _tmp2_;
		_tmp3_ = format;
		_tmp4_ = g_strdup_printf (_tmp3_, "Wayland", "systemsettings5", "IBus Wayland", "Wayland", "org.freedesktop.IBus.Panel.Wayland.Gtk3.desktop");
		_g_free0 (message);
		message = _tmp4_;
		_g_free0 (format);
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (self->priv->m_is_wayland) {
			_tmp6_ = self->priv->m_is_wayland_im;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_tmp5_ = !panel_is_gnome ();
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			const gchar* _tmp7_;
			_tmp7_ = g_getenv ("QT_IM_MODULE");
			if (g_strcmp0 (_tmp7_, "ibus") == 0) {
				gchar* format = NULL;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = g_strdup (_ ("Please unset QT_IM_MODULE and GTK_IM_MODULE " "environment variables and 'ibus-daemon --panel " "disable' should be executed as a child process " "of %s component."));
				format = _tmp8_;
				_tmp9_ = format;
				_tmp10_ = g_get_prgname ();
				_tmp11_ = g_strdup_printf (_tmp9_, _tmp10_);
				_g_free0 (message);
				message = _tmp11_;
				_g_free0 (format);
			}
		}
	}
	_tmp12_ = message;
	if (_tmp12_ == NULL) {
		_g_free0 (message);
		return;
	}
	if (!notify_is_initted ()) {
		notify_init ("ibus");
	}
	_tmp13_ = message;
	_tmp14_ = notify_notification_new (_ ("IBus Notification"), _tmp13_, "ibus");
	notification = _tmp14_;
	_tmp15_ = notification;
	notify_notification_set_timeout (_tmp15_, 60 * 1000);
	_tmp16_ = notification;
	notify_notification_set_category (_tmp16_, "wayland");
	{
		NotifyNotification* _tmp17_;
		_tmp17_ = notification;
		notify_notification_show (_tmp17_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp18_;
		g_clear_error (&_inner_error0_);
		_tmp18_ = message;
		g_warning ("panel.vala:894: %s", _tmp18_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (notification);
		_g_free0 (message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (notification);
	_g_free0 (message);
}

static void
panel_save_log (Panel* self,
                const gchar* format)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = self->priv->m_log;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_log;
	fputs (format, _tmp1_);
	_tmp2_ = self->priv->m_log;
	fflush (_tmp2_);
}

void
panel_load_settings (Panel* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSettings* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GList* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	g_return_if_fail (self != NULL);
	panel_set_version (self);
	panel_check_wayland (self);
	panel_init_engines_order (self);
	panel_set_use_system_keyboard_layout (self);
	panel_set_use_global_engine (self);
	panel_set_use_xmodmap (self);
	_tmp0_ = self->priv->m_settings_panel;
	self->priv->m_use_engine_lang = g_settings_get_boolean (_tmp0_, "use-glyph-from-engine-lang");
	_tmp1_ = self->priv->m_settings_general;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "preload-engines");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_tmp5_ = self->priv->m_settings_general;
	_tmp7_ = _tmp6_ = g_settings_get_strv (_tmp5_, "engines-order");
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	panel_update_engines (self, _tmp4_, (gint) _vala_array_length (_tmp2_), _tmp8_, (gint) _vala_array_length (_tmp6_));
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = self->priv->m_keybindings;
	binding_common_unbind_switch_shortcut (BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY, _tmp9_);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	self->priv->m_keybindings = NULL;
	panel_bind_switch_shortcut (self);
	panel_set_switcher_delay_time (self);
	panel_set_embed_preedit_text (self);
	_tmp10_ = self->priv->m_settings_panel;
	binding_common_set_custom_font (_tmp10_, NULL, &self->priv->m_css_provider);
	_tmp11_ = self->priv->m_settings_panel;
	binding_common_set_custom_theme (_tmp11_);
	_tmp12_ = self->priv->m_settings_panel;
	binding_common_set_custom_icon (_tmp12_);
	panel_set_show_icon_on_systray (self, FALSE);
	panel_set_lookup_table_orientation (self);
	panel_set_show_property_panel (self);
	panel_set_timeout_property_panel (self);
	panel_set_follow_input_cursor_when_always_shown_property_panel (self);
	panel_set_xkb_icon_rgba (self);
	panel_set_property_icon_delay_time (self);
}

/**
     * disconnect_signals:
     *
     * Call this API before m_panel = null so that the ref_count becomes 0
     */
void
panel_disconnect_signals (Panel* self)
{
	GObject* object = NULL;
	GtkStatusIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_status_icon;
	object = (GObject*) _tmp0_;
	if (self->priv->m_is_kde) {
		Indicator* _tmp1_;
		_tmp1_ = self->priv->m_indicator;
		object = (GObject*) _tmp1_;
	}
	if (self->priv->m_popup_menu_id > ((gulong) 0)) {
		GObject* _tmp2_;
		_tmp2_ = object;
		if (g_signal_handler_is_connected (_tmp2_, self->priv->m_popup_menu_id)) {
			GObject* _tmp3_;
			_tmp3_ = object;
			g_signal_handler_disconnect (_tmp3_, self->priv->m_popup_menu_id);
		}
		self->priv->m_popup_menu_id = (gulong) 0;
	}
	if (self->priv->m_activate_id > ((gulong) 0)) {
		GObject* _tmp4_;
		_tmp4_ = object;
		if (g_signal_handler_is_connected (_tmp4_, self->priv->m_activate_id)) {
			GObject* _tmp5_;
			_tmp5_ = object;
			g_signal_handler_disconnect (_tmp5_, self->priv->m_activate_id);
		}
		self->priv->m_activate_id = (gulong) 0;
	}
	if (self->priv->m_registered_status_notifier_item_id > ((gulong) 0)) {
		GObject* _tmp6_;
		_tmp6_ = object;
		if (g_signal_handler_is_connected (_tmp6_, self->priv->m_registered_status_notifier_item_id)) {
			GObject* _tmp7_;
			_tmp7_ = object;
			g_signal_handler_disconnect (_tmp7_, self->priv->m_registered_status_notifier_item_id);
		}
		self->priv->m_registered_status_notifier_item_id = (gulong) 0;
	}
	if (self->priv->m_preload_engines_id > ((guint) 0)) {
		g_source_remove (self->priv->m_preload_engines_id);
		self->priv->m_preload_engines_id = (guint) 0;
	}
}

/**
     * set_global_shortcut_key_state:
     *
     * Handle IME switcher dialog or Emojier on the focused context only
     * so this API is assumed to use in Wayland.
     */
void
panel_set_global_shortcut_key_state (Panel* self,
                                     IBusBusGlobalBindingType type,
                                     gboolean is_pressed,
                                     gboolean is_backward)
{
	g_return_if_fail (self != NULL);
	switch (type) {
		case IBUS_BUS_GLOBAL_BINDING_TYPE_IME_SWITCHER:
		{
			panel_handle_engine_switch_focused (self, is_pressed, is_backward);
			break;
		}
		default:
		{
			break;
		}
	}
}

void
panel_set_log (Panel* self,
               FILE* log,
               gboolean verbose)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (log != NULL);
	self->priv->m_log = log;
	self->priv->m_verbose = verbose;
}

static void
panel_engine_contexts_insert (Panel* self,
                              IBusEngineDesc* engine)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	IBusEngineDesc* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	if (self->priv->m_use_global_engine) {
		return;
	}
	_tmp0_ = self->priv->m_engine_contexts;
	if (g_hash_table_size (_tmp0_) >= ((guint) 200)) {
		GHashTable* _tmp1_;
		g_warning ("panel.vala:1013: Contexts by windows are too much counted!");
		_tmp1_ = self->priv->m_engine_contexts;
		g_hash_table_remove_all (_tmp1_);
	}
	_tmp2_ = self->priv->m_engine_contexts;
	_tmp3_ = self->priv->m_current_context_path;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _g_object_ref0 (engine);
	g_hash_table_replace (_tmp2_, _tmp4_, _tmp5_);
}

static void
panel_set_language_from_engine (Panel* self,
                                IBusEngineDesc* engine)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	if (self->priv->m_use_engine_lang) {
		CandidatePanel* _tmp0_;
		const gchar* _tmp1_;
		PangoLanguage* _tmp2_;
		PangoAttrLanguage* _tmp3_;
		PangoAttrLanguage* _tmp4_;
		_tmp0_ = self->priv->m_candidate_panel;
		_tmp1_ = ibus_engine_desc_get_language (engine);
		_tmp2_ = pango_language_from_string (_tmp1_);
		_tmp3_ = (PangoAttrLanguage*) pango_attr_language_new (_tmp2_);
		_tmp4_ = _tmp3_;
		candidate_panel_set_language (_tmp0_, (PangoAttribute*) _tmp4_);
		_pango_attribute_destroy0 (_tmp4_);
	} else {
		CandidatePanel* _tmp5_;
		PangoLanguage* _tmp6_;
		PangoAttrLanguage* _tmp7_;
		PangoAttrLanguage* _tmp8_;
		_tmp5_ = self->priv->m_candidate_panel;
		_tmp6_ = pango_language_from_string (NULL);
		_tmp7_ = (PangoAttrLanguage*) pango_attr_language_new (_tmp6_);
		_tmp8_ = _tmp7_;
		candidate_panel_set_language (_tmp5_, (PangoAttribute*) _tmp8_);
		_pango_attribute_destroy0 (_tmp8_);
	}
}

static void
panel_set_engine (Panel* self,
                  IBusEngineDesc* engine)
{
	IBusBus* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	if (self->priv->m_property_icon_delay_time_id > ((guint) 0)) {
		g_source_remove (self->priv->m_property_icon_delay_time_id);
		self->priv->m_property_icon_delay_time_id = (guint) 0;
	}
	_tmp0_ = self->priv->m_bus;
	_tmp1_ = ibus_engine_desc_get_name (engine);
	if (!ibus_bus_set_global_engine (_tmp0_, _tmp1_)) {
		const gchar* _tmp2_;
		_tmp2_ = ibus_engine_desc_get_name (engine);
		g_warning ("panel.vala:1038: Switch engine to %s failed.", _tmp2_);
		return;
	}
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->m_icon_prop_key);
	self->priv->m_icon_prop_key = _tmp3_;
	if (!self->priv->m_use_system_keyboard_layout) {
		_tmp4_ = !self->priv->m_is_wayland;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		XKBLayout* _tmp5_;
		_tmp5_ = self->priv->m_xkblayout;
		xkb_layout_set_layout (_tmp5_, engine);
	}
	panel_set_language_from_engine (self, engine);
	panel_engine_contexts_insert (self, engine);
}

static void
panel_switch_engine (Panel* self,
                     gint i,
                     gboolean force)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	IBusEngineDesc* engine = NULL;
	IBusEngineDesc** _tmp3_;
	gint _tmp3__length1;
	IBusEngineDesc* _tmp4_;
	IBusEngineDesc* _tmp5_;
	IBusEngineDesc* _tmp6_;
	g_return_if_fail (self != NULL);
	if (i >= 0) {
		IBusEngineDesc** _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->m_engines;
		_tmp1__length1 = self->priv->m_engines_length1;
		_tmp0_ = i < _tmp1__length1;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "i >= 0 && i < m_engines.length");
	if (i == 0) {
		_tmp2_ = !force;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->m_engines;
	_tmp3__length1 = self->priv->m_engines_length1;
	_tmp4_ = _tmp3_[i];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	engine = _tmp5_;
	_tmp6_ = engine;
	panel_set_engine (self, _tmp6_);
	_g_object_unref0 (engine);
}

static void
panel_handle_engine_switch_normal (Panel* self,
                                   GdkEvent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	panel_handle_engine_switch (self, event, FALSE);
}

static void
panel_handle_engine_switch_reverse (Panel* self,
                                    GdkEvent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	panel_handle_engine_switch (self, event, TRUE);
}

static void
panel_handle_engine_switch (Panel* self,
                            GdkEvent* event,
                            gboolean reverse)
{
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	guint keyval = 0U;
	GdkEventKey* _tmp1_;
	GdkEventKey* _tmp2_;
	guint modifiers = 0U;
	GdkEventKey* _tmp3_;
	GdkEventKey* _tmp4_;
	guint primary_modifiers = 0U;
	GdkEventKey* _tmp5_;
	GdkEventKey* _tmp6_;
	gboolean pressed = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = (GdkEventKey *) (event);
	_tmp2_ = _tmp1_;
	keyval = _tmp2_->keyval;
	_tmp3_ = (GdkEventKey *) (event);
	_tmp4_ = _tmp3_;
	modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp4_->state;
	_tmp5_ = (GdkEventKey *) (event);
	_tmp6_ = _tmp5_;
	primary_modifiers = (guint) keybinding_manager_get_primary_modifier ((guint) _tmp6_->state);
	pressed = keybinding_manager_primary_modifier_still_pressed (event, primary_modifiers);
	if (reverse) {
		modifiers &= (guint) (~GDK_SHIFT_MASK);
	}
	if (pressed) {
		_tmp7_ = self->priv->m_switcher_delay_time >= 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gint _tmp8_ = 0;
		gint i = 0;
		Switcher* _tmp10_;
		IBusEngineDesc** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		if (reverse) {
			IBusEngineDesc** _tmp9_;
			gint _tmp9__length1;
			_tmp9_ = self->priv->m_engines;
			_tmp9__length1 = self->priv->m_engines_length1;
			_tmp8_ = _tmp9__length1 - 1;
		} else {
			_tmp8_ = 1;
		}
		i = _tmp8_;
		_tmp10_ = self->priv->m_switcher;
		_tmp11_ = self->priv->m_engines;
		_tmp11__length1 = self->priv->m_engines_length1;
		_tmp12_ = self->priv->m_real_current_context_path;
		i = switcher_run (_tmp10_, keyval, modifiers, event, _tmp11_, (gint) _tmp11__length1, i, _tmp12_);
		if (i < 0) {
			g_debug ("panel.vala:1110: switch cancelled");
		} else {
			if (i == 0) {
				g_debug ("panel.vala:1112: do not have to switch");
			} else {
				panel_switcher_focus_set_engine (self);
			}
		}
	} else {
		gint _tmp13_ = 0;
		gint i = 0;
		if (reverse) {
			IBusEngineDesc** _tmp14_;
			gint _tmp14__length1;
			_tmp14_ = self->priv->m_engines;
			_tmp14__length1 = self->priv->m_engines_length1;
			_tmp13_ = _tmp14__length1 - 1;
		} else {
			_tmp13_ = 1;
		}
		i = _tmp13_;
		panel_switch_engine (self, i, FALSE);
	}
}

static gboolean
___lambda105_ (Panel* self)
{
	gboolean result;
	g_usleep ((gulong) 5000000);
	panel_handle_engine_switch_release (self, TRUE);
	_g_thread_unref0 (self->priv->m_switcher_waiting_release);
	self->priv->m_switcher_waiting_release = NULL;
	result = TRUE;
	return result;
}

static gpointer
____lambda105__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda105_ ((Panel*) self));
	g_object_unref (self);
	return result;
}

static void
panel_handle_engine_switch_focused (Panel* self,
                                    gboolean pressed,
                                    gboolean reverse)
{
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 < 2) {
		return;
	}
	if (pressed) {
		gint _tmp1_ = 0;
		gint i = 0;
		GThread* _tmp12_;
		if (reverse) {
			IBusEngineDesc** _tmp2_;
			gint _tmp2__length1;
			_tmp2_ = self->priv->m_engines;
			_tmp2__length1 = self->priv->m_engines_length1;
			_tmp1_ = _tmp2__length1 - 1;
		} else {
			_tmp1_ = 1;
		}
		i = _tmp1_;
		if (self->priv->m_switcher_selected_index >= 0) {
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			if (reverse) {
				_tmp3_ = self->priv->m_switcher_selected_index - 1;
			} else {
				_tmp3_ = self->priv->m_switcher_selected_index + 1;
			}
			i = _tmp3_;
			if (i < 0) {
				IBusEngineDesc** _tmp5_;
				gint _tmp5__length1;
				_tmp5_ = self->priv->m_engines;
				_tmp5__length1 = self->priv->m_engines_length1;
				_tmp4_ = _tmp5__length1 - 1;
			} else {
				gint _tmp6_ = 0;
				IBusEngineDesc** _tmp7_;
				gint _tmp7__length1;
				_tmp7_ = self->priv->m_engines;
				_tmp7__length1 = self->priv->m_engines_length1;
				if (i == _tmp7__length1) {
					_tmp6_ = 0;
				} else {
					_tmp6_ = i;
				}
				_tmp4_ = _tmp6_;
			}
			i = _tmp4_;
		}
		if (self->priv->m_switcher_delay_time >= 0) {
			Switcher* _tmp8_;
			IBusEngineDesc** _tmp9_;
			gint _tmp9__length1;
			_tmp8_ = self->priv->m_switcher;
			_tmp9_ = self->priv->m_engines;
			_tmp9__length1 = self->priv->m_engines_length1;
			self->priv->m_switcher_selected_index = switcher_run_popup (_tmp8_, _tmp9_, (gint) _tmp9__length1, i);
		} else {
			self->priv->m_switcher_selected_index = i;
		}
		if (self->priv->m_verbose) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = g_strdup_printf ("Panel.%s switcher release %d timer\n", G_STRFUNC, self->priv->m_switcher_selected_index);
			_tmp11_ = _tmp10_;
			panel_save_log (self, _tmp11_);
			_g_free0 (_tmp11_);
		}
		_g_thread_unref0 (self->priv->m_switcher_waiting_release);
		self->priv->m_switcher_waiting_release = NULL;
		_tmp12_ = g_thread_new ("wait release", ____lambda105__gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->m_switcher_waiting_release);
		self->priv->m_switcher_waiting_release = _tmp12_;
	} else {
		_g_thread_unref0 (self->priv->m_switcher_waiting_release);
		self->priv->m_switcher_waiting_release = NULL;
		panel_handle_engine_switch_release (self, FALSE);
	}
}

static void
panel_handle_engine_switch_release (Panel* self,
                                    gboolean is_timeout)
{
	Switcher* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->m_verbose) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		if (is_timeout) {
			_tmp0_ = "timeout";
		} else {
			_tmp0_ = "normal";
		}
		_tmp1_ = g_strdup_printf ("Panel.%s switcher release %d %s\n", G_STRFUNC, self->priv->m_switcher_selected_index, _tmp0_);
		_tmp2_ = _tmp1_;
		panel_save_log (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = self->priv->m_switcher;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
	if (self->priv->m_switcher_selected_index < 0) {
		return;
	}
	panel_switch_engine (self, self->priv->m_switcher_selected_index, FALSE);
	self->priv->m_switcher_selected_index = -1;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		Panel* self;
		self = _data8_->self;
		_data8_->names = (_vala_array_free (_data8_->names, _data8_->names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_vala_array_add22 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
__lambda62_ (Block8Data* _data8_)
{
	Panel* self;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	self = _data8_->self;
	_tmp0_ = self->priv->m_bus;
	if (!ibus_bus_is_connected (_tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->m_bus;
	_tmp2_ = _data8_->names;
	_tmp2__length1 = _data8_->names_length1;
	ibus_bus_preload_engines_async (_tmp1_, _tmp2_, -1, NULL, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda62__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda62_ (self);
	return result;
}

static void
panel_run_preload_engines (Panel* self,
                           IBusEngineDesc** engines,
                           gint engines_length1,
                           gint index)
{
	Block8Data* _data8_;
	gchar** _tmp0_;
	IBusEngineDesc* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data8_->names = _tmp0_;
	_data8_->names_length1 = 0;
	_data8_->_names_size_ = _data8_->names_length1;
	if (engines_length1 <= index) {
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	if (self->priv->m_preload_engines_id != ((guint) 0)) {
		g_source_remove (self->priv->m_preload_engines_id);
		self->priv->m_preload_engines_id = (guint) 0;
	}
	_tmp1_ = engines[index];
	_tmp2_ = ibus_engine_desc_get_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_vala_array_add22 (&_data8_->names, &_data8_->names_length1, &_data8_->_names_size_, _tmp3_);
	self->priv->m_preload_engines_id = g_timeout_add_full (G_PRIORITY_DEFAULT, PANEL_PRELOAD_ENGINES_DELAY_TIME, ___lambda62__gsource_func, block8_data_ref (_data8_), block8_data_unref);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add23 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add24 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		Panel* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
___lambda61_ (Block9Data* _data9_,
              gint id)
{
	Panel* self;
	GtkMessageDialog* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda61__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda61_ (self, response_id);
}

static IBusEngineDesc**
_vala_array_dup3 (IBusEngineDesc** self,
                  gssize length)
{
	if (length >= 0) {
		IBusEngineDesc** result;
		gssize i;
		result = g_new0 (IBusEngineDesc*, length + 1);
		for (i = 0; i < length; i++) {
			IBusEngineDesc* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static IBusEngineDesc**
_vala_array_dup4 (IBusEngineDesc** self,
                  gssize length)
{
	if (length >= 0) {
		IBusEngineDesc** result;
		gssize i;
		result = g_new0 (IBusEngineDesc*, length + 1);
		for (i = 0; i < length; i++) {
			IBusEngineDesc* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
panel_update_engines (Panel* self,
                      gchar** unowned_engine_names,
                      gint unowned_engine_names_length1,
                      gchar** order_names,
                      gint order_names_length1)
{
	gchar** engine_names = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint engine_names_length1;
	gint _engine_names_size_;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** names = NULL;
	gchar** _tmp6_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	IBusEngineDesc** engines = NULL;
	IBusBus* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	IBusEngineDesc** _tmp20_;
	IBusEngineDesc** _tmp21_;
	gint engines_length1;
	gint _engines_size_;
	IBusEngineDesc** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	IBusEngineDesc** _tmp43_;
	gint _tmp43__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (unowned_engine_names != NULL) ? _vala_array_dup2 (unowned_engine_names, unowned_engine_names_length1) : unowned_engine_names;
	_tmp0__length1 = unowned_engine_names_length1;
	engine_names = _tmp0_;
	engine_names_length1 = _tmp0__length1;
	_engine_names_size_ = engine_names_length1;
	_tmp2_ = engine_names;
	_tmp2__length1 = engine_names_length1;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = engine_names;
		_tmp3__length1 = engine_names_length1;
		_tmp1_ = _tmp3__length1 == 0;
	}
	if (_tmp1_) {
		gchar* _tmp4_;
		gchar** _tmp5_;
		_tmp4_ = g_strdup ("xkb:us::eng");
		_tmp5_ = g_new0 (gchar*, 1 + 1);
		_tmp5_[0] = _tmp4_;
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp5_;
		engine_names_length1 = 1;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	names = _tmp6_;
	names_length1 = 0;
	_names_size_ = names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = order_names;
		name_collection_length1 = order_names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp7_;
			gchar* name = NULL;
			_tmp7_ = g_strdup (name_collection[name_it]);
			name = _tmp7_;
			{
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp8_ = name;
				_tmp9_ = engine_names;
				_tmp9__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp9_, _tmp9__length1, _tmp8_)) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = name;
					_tmp11_ = g_strdup (_tmp10_);
					_vala_array_add23 (&names, &names_length1, &_names_size_, _tmp11_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp12_ = engine_names;
	_tmp12__length1 = engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp12_;
		name_collection_length1 = _tmp12__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp13_;
			gchar* name = NULL;
			_tmp13_ = g_strdup (name_collection[name_it]);
			name = _tmp13_;
			{
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp14_ = name;
				_tmp15_ = names;
				_tmp15__length1 = names_length1;
				if (_vala_string_array_contains (_tmp15_, _tmp15__length1, _tmp14_)) {
					_g_free0 (name);
					continue;
				}
				_tmp16_ = name;
				_tmp17_ = g_strdup (_tmp16_);
				_vala_array_add24 (&names, &names_length1, &_names_size_, _tmp17_);
				_g_free0 (name);
			}
		}
	}
	_tmp18_ = self->priv->m_bus;
	_tmp19_ = names;
	_tmp19__length1 = names_length1;
	_tmp21_ = _tmp20_ = ibus_bus_get_engines_by_names (_tmp18_, _tmp19_);
	engines = _tmp21_;
	engines_length1 = _vala_array_length (_tmp20_);
	_engines_size_ = engines_length1;
	_tmp22_ = engines;
	_tmp22__length1 = engines_length1;
	_tmp23_ = names;
	_tmp23__length1 = names_length1;
	if (_tmp22__length1 < _tmp23__length1) {
		Block9Data* _data9_;
		gchar* message1 = NULL;
		IBusEngineDesc** _tmp24_;
		gint _tmp24__length1;
		gchar* message2 = NULL;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		GtkMessageDialog* _tmp40_;
		GtkMessageDialog* _tmp41_;
		GtkMessageDialog* _tmp42_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->self = g_object_ref (self);
		_tmp24_ = engines;
		_tmp24__length1 = engines_length1;
		if (_tmp24__length1 == 0) {
			gchar** fallback_names = NULL;
			gchar* _tmp25_;
			gchar** _tmp26_;
			gint fallback_names_length1;
			gint _fallback_names_size_;
			GSettings* _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			IBusBus* _tmp29_;
			gchar** _tmp30_;
			gint _tmp30__length1;
			IBusEngineDesc** _tmp31_;
			IBusEngineDesc** _tmp32_;
			gchar** _tmp33_;
			gint _tmp33__length1;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp25_ = g_strdup ("xkb:us::eng");
			_tmp26_ = g_new0 (gchar*, 1 + 1);
			_tmp26_[0] = _tmp25_;
			fallback_names = _tmp26_;
			fallback_names_length1 = 1;
			_fallback_names_size_ = fallback_names_length1;
			_tmp27_ = self->priv->m_settings_general;
			_tmp28_ = fallback_names;
			_tmp28__length1 = fallback_names_length1;
			g_settings_set_strv (_tmp27_, "preload-engines", _tmp28_);
			_tmp29_ = self->priv->m_bus;
			_tmp30_ = fallback_names;
			_tmp30__length1 = fallback_names_length1;
			_tmp32_ = _tmp31_ = ibus_bus_get_engines_by_names (_tmp29_, _tmp30_);
			engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
			engines = _tmp32_;
			engines_length1 = _vala_array_length (_tmp31_);
			_engines_size_ = engines_length1;
			_tmp33_ = names;
			_tmp33__length1 = names_length1;
			_tmp34_ = _tmp33_[0];
			_tmp35_ = g_strdup_printf (_ ("Your configured input method %s does not exist " "in IBus input methods so \"US\" layout was " "configured instead of your input method."), _tmp34_);
			_g_free0 (message1);
			message1 = _tmp35_;
			fallback_names = (_vala_array_free (fallback_names, fallback_names_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gchar* _tmp36_;
			_tmp36_ = g_strdup (_ ("At least one of your configured input methods " "does not exist in IBus input methods."));
			_g_free0 (message1);
			message1 = _tmp36_;
		}
		_tmp37_ = g_strdup (_ ("Please run `ibus-setup` command, open \"Input " "Method\" tab, and configure your input methods " "again."));
		message2 = _tmp37_;
		_tmp38_ = message1;
		_tmp39_ = message2;
		_tmp40_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, "%s %s", _tmp38_, _tmp39_);
		g_object_ref_sink (_tmp40_);
		_data9_->dialog = _tmp40_;
		_tmp41_ = _data9_->dialog;
		g_signal_connect_data ((GtkDialog*) _tmp41_, "response", (GCallback) ____lambda61__gtk_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_tmp42_ = _data9_->dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp42_);
		_g_free0 (message2);
		_g_free0 (message1);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	}
	_tmp43_ = self->priv->m_engines;
	_tmp43__length1 = self->priv->m_engines_length1;
	if (_tmp43__length1 == 0) {
		IBusEngineDesc** _tmp44_;
		gint _tmp44__length1;
		IBusEngineDesc** _tmp45_;
		gint _tmp45__length1;
		IBusEngineDesc** _tmp46_;
		gint _tmp46__length1;
		_tmp44_ = engines;
		_tmp44__length1 = engines_length1;
		_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup3 (_tmp44_, _tmp44__length1) : _tmp44_;
		_tmp45__length1 = _tmp44__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp45_;
		self->priv->m_engines_length1 = _tmp45__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		panel_switch_engine (self, 0, TRUE);
		_tmp46_ = self->priv->m_engines;
		_tmp46__length1 = self->priv->m_engines_length1;
		panel_run_preload_engines (self, _tmp46_, (gint) _tmp46__length1, 1);
	} else {
		IBusEngineDesc* current_engine = NULL;
		IBusEngineDesc** _tmp47_;
		gint _tmp47__length1;
		IBusEngineDesc* _tmp48_;
		IBusEngineDesc* _tmp49_;
		IBusEngineDesc** _tmp50_;
		gint _tmp50__length1;
		IBusEngineDesc** _tmp51_;
		gint _tmp51__length1;
		gint i = 0;
		IBusEngineDesc** _tmp62_;
		gint _tmp62__length1;
		_tmp47_ = self->priv->m_engines;
		_tmp47__length1 = self->priv->m_engines_length1;
		_tmp48_ = _tmp47_[0];
		_tmp49_ = _g_object_ref0 (_tmp48_);
		current_engine = _tmp49_;
		_tmp50_ = engines;
		_tmp50__length1 = engines_length1;
		_tmp51_ = (_tmp50_ != NULL) ? _vala_array_dup4 (_tmp50_, _tmp50__length1) : _tmp50_;
		_tmp51__length1 = _tmp50__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp51_;
		self->priv->m_engines_length1 = _tmp51__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		{
			gboolean _tmp52_ = FALSE;
			i = 0;
			_tmp52_ = TRUE;
			while (TRUE) {
				IBusEngineDesc** _tmp54_;
				gint _tmp54__length1;
				IBusEngineDesc* _tmp55_;
				const gchar* _tmp56_;
				IBusEngineDesc** _tmp57_;
				gint _tmp57__length1;
				IBusEngineDesc* _tmp58_;
				const gchar* _tmp59_;
				if (!_tmp52_) {
					gint _tmp53_;
					_tmp53_ = i;
					i = _tmp53_ + 1;
				}
				_tmp52_ = FALSE;
				_tmp54_ = self->priv->m_engines;
				_tmp54__length1 = self->priv->m_engines_length1;
				if (!(i < _tmp54__length1)) {
					break;
				}
				_tmp55_ = current_engine;
				_tmp56_ = ibus_engine_desc_get_name (_tmp55_);
				_tmp57_ = engines;
				_tmp57__length1 = engines_length1;
				_tmp58_ = _tmp57_[i];
				_tmp59_ = ibus_engine_desc_get_name (_tmp58_);
				if (g_strcmp0 (_tmp56_, _tmp59_) == 0) {
					panel_switch_engine (self, i, FALSE);
					if (i != 0) {
						IBusEngineDesc** _tmp60_;
						gint _tmp60__length1;
						_tmp60_ = engines;
						_tmp60__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp60_, (gint) _tmp60__length1, 0);
					} else {
						IBusEngineDesc** _tmp61_;
						gint _tmp61__length1;
						_tmp61_ = engines;
						_tmp61__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp61_, (gint) _tmp61__length1, 1);
					}
					_g_object_unref0 (current_engine);
					engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
			}
		}
		panel_switch_engine (self, 0, TRUE);
		_tmp62_ = engines;
		_tmp62__length1 = engines_length1;
		panel_run_preload_engines (self, _tmp62_, (gint) _tmp62__length1, 1);
		_g_object_unref0 (current_engine);
	}
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
panel_context_render_string (Panel* self,
                             cairo_t* cr,
                             const gchar* symbol,
                             gint image_width,
                             gint image_height)
{
	gint lwidth = 0;
	gint lheight = 0;
	PangoFontDescription* desc = NULL;
	PangoFontDescription* _tmp0_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	PangoLayout* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoLayout* _tmp7_;
	PangoLayout* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	PangoLayout* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (symbol != NULL);
	lwidth = 0;
	lheight = 0;
	_tmp0_ = pango_font_description_from_string ("Monospace Bold 22");
	desc = _tmp0_;
	_tmp1_ = pango_cairo_create_layout (cr);
	layout = _tmp1_;
	_tmp2_ = strlen (symbol);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= 3) {
		PangoFontDescription* _tmp4_;
		_tmp4_ = pango_font_description_from_string ("Monospace Bold 18");
		__vala_PangoFontDescription_free0 (desc);
		desc = _tmp4_;
	}
	_tmp5_ = layout;
	_tmp6_ = desc;
	pango_layout_set_font_description (_tmp5_, _tmp6_);
	_tmp7_ = layout;
	pango_layout_set_text (_tmp7_, symbol, -1);
	_tmp8_ = layout;
	pango_layout_get_size (_tmp8_, &_tmp9_, &_tmp10_);
	lwidth = _tmp9_;
	lheight = _tmp10_;
	cairo_move_to (cr, (gdouble) ((image_width - (lwidth / PANGO_SCALE)) / 2), (gdouble) ((image_height - (lheight / PANGO_SCALE)) / 2));
	_tmp11_ = self->priv->m_xkb_icon_rgba;
	_tmp12_ = self->priv->m_xkb_icon_rgba;
	_tmp13_ = self->priv->m_xkb_icon_rgba;
	_tmp14_ = self->priv->m_xkb_icon_rgba;
	cairo_set_source_rgba (cr, _tmp11_.red, _tmp12_.green, _tmp13_.blue, _tmp14_.alpha);
	_tmp15_ = layout;
	pango_cairo_show_layout (cr, _tmp15_);
	_g_object_unref0 (layout);
	__vala_PangoFontDescription_free0 (desc);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static cairo_surface_t*
panel_create_cairo_image_surface_with_string (Panel* self,
                                              const gchar* symbol,
                                              gboolean cache)
{
	cairo_surface_t* image = NULL;
	cairo_surface_t* _tmp4_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp5_;
	cairo_t* _tmp6_;
	gint width = 0;
	cairo_surface_t* _tmp7_;
	gint height = 0;
	cairo_surface_t* _tmp8_;
	gint stride = 0;
	cairo_surface_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	image = NULL;
	if (cache) {
		GHashTable* _tmp0_;
		gconstpointer _tmp1_;
		cairo_surface_t* _tmp2_;
		cairo_surface_t* _tmp3_;
		_tmp0_ = self->priv->m_xkb_icon_image;
		_tmp1_ = g_hash_table_lookup (_tmp0_, symbol);
		_tmp2_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp1_);
		_cairo_surface_destroy0 (image);
		image = _tmp2_;
		_tmp3_ = image;
		if (_tmp3_ != NULL) {
			result = image;
			return result;
		}
	}
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 48, 48);
	_cairo_surface_destroy0 (image);
	image = _tmp4_;
	_tmp5_ = image;
	_tmp6_ = cairo_create (_tmp5_);
	cr = _tmp6_;
	_tmp7_ = image;
	width = cairo_image_surface_get_width (_tmp7_);
	_tmp8_ = image;
	height = cairo_image_surface_get_height (_tmp8_);
	_tmp9_ = image;
	stride = cairo_image_surface_get_stride (_tmp9_);
	_tmp10_ = cr;
	cairo_set_source_rgba (_tmp10_, 0.0, 0.0, 0.0, 0.0);
	_tmp11_ = cr;
	cairo_set_operator (_tmp11_, CAIRO_OPERATOR_SOURCE);
	_tmp12_ = cr;
	cairo_paint (_tmp12_);
	_tmp13_ = cr;
	cairo_set_operator (_tmp13_, CAIRO_OPERATOR_OVER);
	_tmp14_ = cr;
	panel_context_render_string (self, _tmp14_, symbol, width, height);
	_tmp15_ = image;
	cairo_surface_flush (_tmp15_);
	if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
		if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
			guint* data = NULL;
			cairo_surface_t* _tmp16_;
			guchar* _tmp17_;
			gint data_length1;
			gint _data_size_;
			gint length = 0;
			_tmp16_ = image;
			_tmp17_ = cairo_image_surface_get_data (_tmp16_);
			data = (guint*) _tmp17_;
			data_length1 = (-1 * sizeof (guchar)) / sizeof (guint);
			_data_size_ = data_length1;
			length = (stride * height) / ((gint) sizeof (guint));
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp18_ = FALSE;
					_tmp18_ = TRUE;
					while (TRUE) {
						guint* _tmp20_;
						gint _tmp20__length1;
						guint* _tmp21_;
						gint _tmp21__length1;
						guint _tmp22_;
						if (!_tmp18_) {
							gint _tmp19_;
							_tmp19_ = i;
							i = _tmp19_ + 1;
						}
						_tmp18_ = FALSE;
						if (!(i < length)) {
							break;
						}
						_tmp20_ = data;
						_tmp20__length1 = data_length1;
						_tmp21_ = data;
						_tmp21__length1 = data_length1;
						_tmp22_ = _tmp21_[i];
						_tmp20_[i] = GUINT_TO_BE (_tmp22_);
					}
				}
			}
		}
	}
	if (cache) {
		GHashTable* _tmp23_;
		gchar* _tmp24_;
		cairo_surface_t* _tmp25_;
		cairo_surface_t* _tmp26_;
		_tmp23_ = self->priv->m_xkb_icon_image;
		_tmp24_ = g_strdup (symbol);
		_tmp25_ = image;
		_tmp26_ = _cairo_surface_reference0 (_tmp25_);
		g_hash_table_insert (_tmp23_, _tmp24_, _tmp26_);
	}
	result = image;
	_cairo_destroy0 (cr);
	return result;
}

static GdkPixbuf*
panel_create_icon_pixbuf_with_string (Panel* self,
                                      const gchar* symbol)
{
	GdkPixbuf* pixbuf = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	cairo_surface_t* image = NULL;
	cairo_surface_t* _tmp4_;
	gint width = 0;
	cairo_surface_t* _tmp5_;
	gint height = 0;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	GdkPixbuf* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = self->priv->m_xkb_icon_pixbufs;
	_tmp1_ = g_hash_table_lookup (_tmp0_, symbol);
	_tmp2_ = _g_object_ref0 ((GdkPixbuf*) _tmp1_);
	pixbuf = _tmp2_;
	_tmp3_ = pixbuf;
	if (_tmp3_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp4_ = panel_create_cairo_image_surface_with_string (self, symbol, FALSE);
	image = _tmp4_;
	_tmp5_ = image;
	width = cairo_image_surface_get_width (_tmp5_);
	_tmp6_ = image;
	height = cairo_image_surface_get_height (_tmp6_);
	_tmp7_ = image;
	_tmp8_ = gdk_pixbuf_get_from_surface (_tmp7_, 0, 0, width, height);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp8_;
	_tmp9_ = self->priv->m_xkb_icon_pixbufs;
	_tmp10_ = g_strdup (symbol);
	_tmp11_ = pixbuf;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
	result = pixbuf;
	_cairo_surface_destroy0 (image);
	return result;
}

static void
__lambda88_ (Panel* self,
             GPid pid,
             gint state)
{
	if (pid != self->priv->m_setup_pid) {
		return;
	}
	self->priv->m_setup_pid = (GPid) 0;
	g_spawn_close_pid (pid);
}

static void
___lambda88__gchild_watch_func (GPid pid,
                                gint wait_status,
                                gpointer self)
{
	__lambda88_ ((Panel*) self, pid, wait_status);
}

static void
panel_show_setup_dialog (Panel* self)
{
	gchar* binary = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->m_setup_pid != ((GPid) 0)) {
		if (kill ((pid_t) self->priv->m_setup_pid, (gint) SIGUSR1) == 0) {
			return;
		}
		self->priv->m_setup_pid = (GPid) 0;
	}
	_tmp0_ = g_build_filename (BINDIR, "ibus-setup", NULL);
	binary = _tmp0_;
	{
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		GPid _tmp6_ = 0;
		_tmp1_ = binary;
		_tmp2_ = g_strdup (_tmp1_);
		_tmp3_ = g_strdup ("ibus-setup");
		_tmp4_ = g_new0 (gchar*, 2 + 1);
		_tmp4_[0] = _tmp2_;
		_tmp4_[1] = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 2;
		g_spawn_async (NULL, _tmp5_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp6_, &_inner_error0_);
		self->priv->m_setup_pid = _tmp6_;
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = binary;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("panel.vala:1381: Execute %s failed! %s", _tmp7_, _tmp9_);
		self->priv->m_setup_pid = (GPid) 0;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->m_setup_pid, ___lambda88__gchild_watch_func, g_object_ref (self), g_object_unref);
	_g_free0 (binary);
}

static void
panel_show_about_dialog (Panel* self)
{
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_about_dialog;
	if (_tmp0_ == NULL) {
		GtkAboutDialog* _tmp1_;
		GtkAboutDialog* _tmp2_;
		GtkAboutDialog* _tmp3_;
		gchar* copyright = NULL;
		gchar* _tmp4_;
		GtkAboutDialog* _tmp5_;
		const gchar* _tmp6_;
		GtkAboutDialog* _tmp7_;
		GtkAboutDialog* _tmp8_;
		GtkAboutDialog* _tmp9_;
		GtkAboutDialog* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		GtkAboutDialog* _tmp14_;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		GtkAboutDialog* _tmp18_;
		GtkAboutDialog* _tmp19_;
		GtkAboutDialog* _tmp20_;
		_tmp1_ = (GtkAboutDialog*) gtk_about_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_about_dialog);
		self->priv->m_about_dialog = _tmp1_;
		_tmp2_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_program_name (_tmp2_, "IBus");
		_tmp3_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_version (_tmp3_, PACKAGE_VERSION);
		_tmp4_ = g_strdup ("Copyright © 2007-2015 Peng Huang\n" "Copyright © 2015-2022 Takao Fujiwara\n" "Copyright © 2007-2015 Red Hat, Inc.\n");
		copyright = _tmp4_;
		_tmp5_ = self->priv->m_about_dialog;
		_tmp6_ = copyright;
		gtk_about_dialog_set_copyright (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_license (_tmp7_, "LGPL");
		_tmp8_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_comments (_tmp8_, _ ("IBus is an intelligent input bus for Linux/Unix."));
		_tmp9_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_website (_tmp9_, "https://github.com/ibus/ibus/wiki");
		_tmp10_ = self->priv->m_about_dialog;
		_tmp11_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp12_ = g_new0 (gchar*, 1 + 1);
		_tmp12_[0] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 1;
		gtk_about_dialog_set_authors (_tmp10_, _tmp13_);
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
		_tmp14_ = self->priv->m_about_dialog;
		_tmp15_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp16_ = g_new0 (gchar*, 1 + 1);
		_tmp16_[0] = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp17__length1 = 1;
		gtk_about_dialog_set_documenters (_tmp14_, _tmp17_);
		_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
		_tmp18_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_translator_credits (_tmp18_, _ ("translator-credits"));
		_tmp19_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_logo_icon_name (_tmp19_, "ibus");
		_tmp20_ = self->priv->m_about_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp20_, "ibus");
		_g_free0 (copyright);
	}
	_tmp21_ = self->priv->m_about_dialog;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp21_)) {
		GtkAboutDialog* _tmp22_;
		GtkAboutDialog* _tmp23_;
		_tmp22_ = self->priv->m_about_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp22_);
		_tmp23_ = self->priv->m_about_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp23_);
	} else {
		GtkAboutDialog* _tmp24_;
		_tmp24_ = self->priv->m_about_dialog;
		gtk_window_present ((GtkWindow*) _tmp24_);
	}
}

static void
_vala_array_add25 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add26 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add27 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
panel_run_ibus_command (Panel* self,
                        const gchar* args)
{
	gchar* binary = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (args != NULL);
	_tmp0_ = g_build_filename (BINDIR, "ibus", NULL);
	binary = _tmp0_;
	{
		gchar** _args = NULL;
		gchar** _tmp1_;
		gint _args_length1;
		gint __args_size_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gchar* standard_out = NULL;
		gchar* standard_error = NULL;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp15_;
		_tmp1_ = g_new0 (gchar*, 0 + 1);
		_args = _tmp1_;
		_args_length1 = 0;
		__args_size_ = _args_length1;
		_tmp2_ = binary;
		_tmp3_ = g_strdup (_tmp2_);
		_vala_array_add25 (&_args, &_args_length1, &__args_size_, _tmp3_);
		_tmp4_ = g_strdup (args);
		_vala_array_add26 (&_args, &_args_length1, &__args_size_, _tmp4_);
		if (g_strcmp0 (args, "exit") == 0) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = g_strcmp0 (args, "restart") == 0;
		}
		if (_tmp5_) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("--type=kde-wayland");
			_vala_array_add27 (&_args, &_args_length1, &__args_size_, _tmp6_);
		}
		standard_out = NULL;
		standard_error = NULL;
		_tmp7_ = _args;
		_tmp7__length1 = _args_length1;
		_tmp9_ = _tmp8_ = g_get_environ ();
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _vala_array_length (_tmp8_);
		g_spawn_sync (NULL, _tmp7_, _tmp10_, 0, NULL, NULL, &_tmp11_, &_tmp12_, NULL, &_inner_error0_);
		_g_free0 (standard_out);
		standard_out = _tmp11_;
		_g_free0 (standard_error);
		standard_error = _tmp12_;
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (standard_error);
			_g_free0 (standard_out);
			_args = (_vala_array_free (_args, _args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp13_ = standard_out;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_;
			_tmp14_ = standard_out;
			g_print ("%s", _tmp14_);
		}
		_tmp15_ = standard_error;
		if (_tmp15_ != NULL) {
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = binary;
			_tmp17_ = standard_error;
			g_warning ("panel.vala:1444: Execute %s failed! %s", _tmp16_, _tmp17_);
		}
		_g_free0 (standard_error);
		_g_free0 (standard_out);
		_args = (_vala_array_free (_args, _args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = binary;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("panel.vala:1446: Execute %s failed! %s", _tmp18_, _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (binary);
}

static void
__lambda87_ (Panel* self,
             GtkMenuItem* i)
{
	g_return_if_fail (i != NULL);
	panel_show_setup_dialog (self);
}

static void
___lambda87__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda87_ ((Panel*) self, _sender);
}

static void
panel_append_preferences_menu (Panel* self,
                               GtkMenu* menu)
{
	GtkMenuItem* item = NULL;
	GtkMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Preferences"));
	g_object_ref_sink (_tmp0_);
	item = _tmp0_;
	g_signal_connect_object (item, "activate", (GCallback) ___lambda87__gtk_menu_item_activate, self, 0);
	gtk_menu_shell_insert ((GtkMenuShell*) menu, (GtkWidget*) item, -1);
	_g_object_unref0 (item);
}

static void
__lambda89_ (Panel* self,
             GtkMenuItem* i)
{
	IBusExtensionEvent* event = NULL;
	IBusExtensionEvent* _tmp0_;
	IBusExtensionEvent* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = ibus_extension_event_new ("name", "emoji", "is-enabled", TRUE, "params", "category-list", NULL);
	g_object_ref_sink (_tmp0_);
	event = _tmp0_;
	_tmp1_ = _g_object_ref0 (event);
	ibus_panel_service_panel_extension ((IBusPanelService*) self, _tmp1_);
	_g_object_unref0 (event);
}

static void
___lambda89__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda89_ ((Panel*) self, _sender);
}

static void
panel_append_emoji_menu (Panel* self,
                         GtkMenu* menu)
{
	GtkMenuItem* item = NULL;
	GtkMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Emoji Choice"));
	g_object_ref_sink (_tmp0_);
	item = _tmp0_;
	g_signal_connect_object (item, "activate", (GCallback) ___lambda89__gtk_menu_item_activate, self, 0);
	gtk_menu_shell_insert ((GtkMenuShell*) menu, (GtkWidget*) item, -1);
	_g_object_unref0 (item);
}

static void
__lambda90_ (Panel* self,
             GtkMenuItem* i)
{
	g_return_if_fail (i != NULL);
	panel_show_about_dialog (self);
}

static void
___lambda90__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda90_ ((Panel*) self, _sender);
}

static void
__lambda91_ (Panel* self,
             GtkMenuItem* i)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (i != NULL);
	if (self->priv->m_is_kde) {
		_tmp0_ = !binding_common_default_is_xdisplay ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		panel_run_ibus_command (self, "restart");
	} else {
		IBusBus* _tmp1_;
		_tmp1_ = self->priv->m_bus;
		ibus_bus_exit (_tmp1_, TRUE);
	}
}

static void
___lambda91__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda91_ ((Panel*) self, _sender);
}

static void
__lambda92_ (Panel* self,
             GtkMenuItem* i)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (i != NULL);
	if (self->priv->m_is_kde) {
		_tmp0_ = !binding_common_default_is_xdisplay ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		panel_run_ibus_command (self, "exit");
	} else {
		IBusBus* _tmp1_;
		_tmp1_ = self->priv->m_bus;
		ibus_bus_exit (_tmp1_, FALSE);
	}
}

static void
___lambda92__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda92_ ((Panel*) self, _sender);
}

static GtkMenu*
panel_create_context_menu (Panel* self,
                           gboolean use_x11)
{
	GtkMenu* _tmp0_;
	GdkDisplay* display_backup = NULL;
	gboolean _tmp3_ = FALSE;
	GtkMenuItem* item = NULL;
	GtkMenu* _tmp10_;
	GtkMenu* _tmp11_;
	GtkMenu* _tmp12_;
	GtkMenuItem* _tmp13_;
	GtkMenuItem* _tmp14_;
	GtkMenu* _tmp15_;
	GtkMenuItem* _tmp16_;
	GtkMenu* _tmp17_;
	GtkSeparatorMenuItem* _tmp18_;
	GtkSeparatorMenuItem* _tmp19_;
	GtkMenuItem* _tmp20_;
	GtkMenuItem* _tmp21_;
	GtkMenu* _tmp22_;
	GtkMenuItem* _tmp23_;
	GtkMenuItem* _tmp24_;
	GtkMenuItem* _tmp25_;
	GtkMenu* _tmp26_;
	GtkMenuItem* _tmp27_;
	GtkMenu* _tmp28_;
	GdkDisplay* _tmp29_;
	GtkMenu* _tmp32_;
	GtkMenu* _tmp33_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_sys_menu;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_;
		GtkMenu* _tmp2_;
		_tmp1_ = self->priv->m_sys_menu;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	display_backup = NULL;
	if (use_x11) {
		_tmp3_ = !binding_common_default_is_xdisplay ();
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GdkX11Display* display = NULL;
		GdkX11Display* _tmp4_;
		GdkDisplay* _tmp5_;
		GdkDisplay* _tmp6_;
		GdkX11Display* _tmp7_;
		_tmp4_ = binding_common_get_xdisplay ();
		display = _tmp4_;
		_tmp5_ = gdk_display_get_default ();
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (display_backup);
		display_backup = _tmp6_;
		_tmp7_ = display;
		if (_tmp7_ != NULL) {
			GdkDisplayManager* _tmp8_;
			GdkX11Display* _tmp9_;
			_tmp8_ = gdk_display_manager_get ();
			_tmp9_ = display;
			gdk_display_manager_set_default_display (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gdk_display_get_type (), GdkDisplay));
		}
		_g_object_unref0 (display);
	}
	_tmp10_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_sys_menu = _tmp10_;
	_tmp11_ = self->priv->m_sys_menu;
	panel_append_preferences_menu (self, _tmp11_);
	_tmp12_ = self->priv->m_sys_menu;
	panel_append_emoji_menu (self, _tmp12_);
	_tmp13_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("About"));
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (item);
	item = _tmp13_;
	_tmp14_ = item;
	g_signal_connect_object (_tmp14_, "activate", (GCallback) ___lambda90__gtk_menu_item_activate, self, 0);
	_tmp15_ = self->priv->m_sys_menu;
	_tmp16_ = item;
	gtk_menu_shell_insert ((GtkMenuShell*) _tmp15_, (GtkWidget*) _tmp16_, -1);
	_tmp17_ = self->priv->m_sys_menu;
	_tmp18_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_menu_shell_insert ((GtkMenuShell*) _tmp17_, (GtkWidget*) _tmp19_, -1);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Restart"));
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (item);
	item = _tmp20_;
	_tmp21_ = item;
	g_signal_connect_object (_tmp21_, "activate", (GCallback) ___lambda91__gtk_menu_item_activate, self, 0);
	_tmp22_ = self->priv->m_sys_menu;
	_tmp23_ = item;
	gtk_menu_shell_insert ((GtkMenuShell*) _tmp22_, (GtkWidget*) _tmp23_, -1);
	_tmp24_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Quit"));
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (item);
	item = _tmp24_;
	_tmp25_ = item;
	g_signal_connect_object (_tmp25_, "activate", (GCallback) ___lambda92__gtk_menu_item_activate, self, 0);
	_tmp26_ = self->priv->m_sys_menu;
	_tmp27_ = item;
	gtk_menu_shell_insert ((GtkMenuShell*) _tmp26_, (GtkWidget*) _tmp27_, -1);
	_tmp28_ = self->priv->m_sys_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp28_);
	_tmp29_ = display_backup;
	if (_tmp29_ != NULL) {
		GdkDisplayManager* _tmp30_;
		GdkDisplay* _tmp31_;
		_tmp30_ = gdk_display_manager_get ();
		_tmp31_ = display_backup;
		gdk_display_manager_set_default_display (_tmp30_, _tmp31_);
	}
	_tmp32_ = self->priv->m_sys_menu;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	result = _tmp33_;
	_g_object_unref0 (item);
	_g_object_unref0 (display_backup);
	return result;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		Panel* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->e);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
____lambda93_ (Block10Data* _data10_,
               GtkMenuItem* item)
{
	Panel* self;
	self = _data10_->self;
	g_return_if_fail (item != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				IBusEngineDesc** _tmp2_;
				gint _tmp2__length1;
				IBusEngineDesc* _tmp3_;
				IBusEngineDesc** _tmp4_;
				gint _tmp4__length1;
				IBusEngineDesc* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->m_engines;
				_tmp2__length1 = self->priv->m_engines_length1;
				if (!(i < _tmp2__length1)) {
					break;
				}
				_tmp3_ = _data10_->e;
				_tmp4_ = self->priv->m_engines;
				_tmp4__length1 = self->priv->m_engines_length1;
				_tmp5_ = _tmp4_[i];
				if (_tmp3_ == _tmp5_) {
					panel_switch_engine (self, i, FALSE);
					break;
				}
			}
		}
	}
}

static void
_____lambda93__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda93_ (self, _sender);
}

static GtkMenu*
panel_create_activate_menu (Panel* self,
                            gboolean use_x11)
{
	GdkDisplay* display_backup = NULL;
	gboolean _tmp0_ = FALSE;
	GtkMenu* _tmp7_;
	PropertyManager* _tmp8_;
	GtkMenu* _tmp9_;
	GtkMenu* _tmp10_;
	GtkSeparatorMenuItem* _tmp11_;
	GtkSeparatorMenuItem* _tmp12_;
	IBusEngineDesc** _tmp13_;
	gint _tmp13__length1;
	GtkMenu* _tmp45_;
	GtkMenu* _tmp46_;
	GdkDisplay* _tmp47_;
	GtkMenu* _tmp50_;
	GtkMenu* _tmp51_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	display_backup = NULL;
	if (use_x11) {
		_tmp0_ = !binding_common_default_is_xdisplay ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkX11Display* display = NULL;
		GdkX11Display* _tmp1_;
		GdkDisplay* _tmp2_;
		GdkDisplay* _tmp3_;
		GdkX11Display* _tmp4_;
		_tmp1_ = binding_common_get_xdisplay ();
		display = _tmp1_;
		_tmp2_ = gdk_display_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (display_backup);
		display_backup = _tmp3_;
		_tmp4_ = display;
		if (_tmp4_ != NULL) {
			GdkDisplayManager* _tmp5_;
			GdkX11Display* _tmp6_;
			_tmp5_ = gdk_display_manager_get ();
			_tmp6_ = display;
			gdk_display_manager_set_default_display (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gdk_display_get_type (), GdkDisplay));
		}
		_g_object_unref0 (display);
	}
	_tmp7_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->m_ime_menu);
	self->priv->m_ime_menu = _tmp7_;
	_tmp8_ = self->priv->m_property_manager;
	_tmp9_ = self->priv->m_ime_menu;
	property_manager_create_menu_items (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->m_ime_menu;
	_tmp11_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	gtk_menu_shell_insert ((GtkMenuShell*) _tmp10_, (GtkWidget*) _tmp12_, -1);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->m_engines;
	_tmp13__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** engine_collection = NULL;
		gint engine_collection_length1 = 0;
		gint _engine_collection_size_ = 0;
		gint engine_it = 0;
		engine_collection = _tmp13_;
		engine_collection_length1 = _tmp13__length1;
		for (engine_it = 0; engine_it < engine_collection_length1; engine_it = engine_it + 1) {
			IBusEngineDesc* _tmp14_;
			IBusEngineDesc* engine = NULL;
			_tmp14_ = _g_object_ref0 (engine_collection[engine_it]);
			engine = _tmp14_;
			{
				Block10Data* _data10_;
				gchar* language = NULL;
				IBusEngineDesc* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* longname = NULL;
				IBusEngineDesc* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* textdomain = NULL;
				IBusEngineDesc* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* transname = NULL;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				GtkMenuItem* item = NULL;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				GtkMenuItem* _tmp33_;
				GtkMenuItem* _tmp34_;
				IBusEngineDesc* _tmp35_;
				IBusEngineDesc* _tmp36_;
				GtkMenuItem* _tmp37_;
				GtkMenu* _tmp38_;
				GtkMenuItem* _tmp39_;
				_data10_ = g_slice_new0 (Block10Data);
				_data10_->_ref_count_ = 1;
				_data10_->self = g_object_ref (self);
				_tmp15_ = engine;
				_tmp16_ = ibus_engine_desc_get_language (_tmp15_);
				_tmp17_ = g_strdup (_tmp16_);
				language = _tmp17_;
				_tmp18_ = engine;
				_tmp19_ = ibus_engine_desc_get_longname (_tmp18_);
				_tmp20_ = g_strdup (_tmp19_);
				longname = _tmp20_;
				_tmp21_ = engine;
				_tmp22_ = ibus_engine_desc_get_textdomain (_tmp21_);
				_tmp23_ = g_strdup (_tmp22_);
				textdomain = _tmp23_;
				_tmp24_ = textdomain;
				_tmp25_ = longname;
				_tmp26_ = g_strdup (g_dgettext (_tmp24_, _tmp25_));
				transname = _tmp26_;
				_tmp27_ = language;
				_tmp28_ = ibus_get_language_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = transname;
				_tmp31_ = g_strdup_printf ("%s - %s", _tmp29_, _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp32_);
				g_object_ref_sink (_tmp33_);
				_tmp34_ = _tmp33_;
				_g_free0 (_tmp32_);
				_g_free0 (_tmp29_);
				item = _tmp34_;
				_tmp35_ = engine;
				_tmp36_ = _g_object_ref0 (_tmp35_);
				_data10_->e = _tmp36_;
				_tmp37_ = item;
				g_signal_connect_data (_tmp37_, "activate", (GCallback) _____lambda93__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
				_tmp38_ = self->priv->m_ime_menu;
				_tmp39_ = item;
				gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
				_g_object_unref0 (item);
				_g_free0 (transname);
				_g_free0 (textdomain);
				_g_free0 (longname);
				_g_free0 (language);
				_g_object_unref0 (engine);
				block10_data_unref (_data10_);
				_data10_ = NULL;
			}
		}
	}
	if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
		GtkMenu* _tmp40_;
		GtkSeparatorMenuItem* _tmp41_;
		GtkSeparatorMenuItem* _tmp42_;
		GtkMenu* _tmp43_;
		GtkMenu* _tmp44_;
		_tmp40_ = self->priv->m_ime_menu;
		_tmp41_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp41_);
		_tmp42_ = _tmp41_;
		gtk_menu_shell_insert ((GtkMenuShell*) _tmp40_, (GtkWidget*) _tmp42_, -1);
		_g_object_unref0 (_tmp42_);
		_tmp43_ = self->priv->m_ime_menu;
		panel_append_preferences_menu (self, _tmp43_);
		_tmp44_ = self->priv->m_ime_menu;
		panel_append_emoji_menu (self, _tmp44_);
	}
	_tmp45_ = self->priv->m_ime_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->m_ime_menu;
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) _tmp46_, FALSE);
	_tmp47_ = display_backup;
	if (_tmp47_ != NULL) {
		GdkDisplayManager* _tmp48_;
		GdkDisplay* _tmp49_;
		_tmp48_ = gdk_display_manager_get ();
		_tmp49_ = display_backup;
		gdk_display_manager_set_default_display (_tmp48_, _tmp49_);
	}
	_tmp50_ = self->priv->m_ime_menu;
	_tmp51_ = _g_object_ref0 (_tmp50_);
	result = _tmp51_;
	_g_object_unref0 (display_backup);
	return result;
}

static void
panel_set_properties (Panel* self,
                      IBusPropList* props)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	i = 0;
	while (TRUE) {
		IBusProperty* prop = NULL;
		IBusProperty* _tmp0_;
		IBusProperty* _tmp1_;
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		gint _tmp4_;
		_tmp0_ = ibus_prop_list_get (props, (guint) i);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		prop = _tmp1_;
		_tmp2_ = prop;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp3_ = ibus_prop_list_get (props, (guint) i);
		panel_set_property (self, _tmp3_, TRUE);
		_tmp4_ = i;
		i = _tmp4_ + 1;
		_g_object_unref0 (prop);
	}
}

static void
panel_set_property (Panel* self,
                    IBusProperty* prop,
                    gboolean all_update)
{
	gchar* symbol = NULL;
	IBusText* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = ibus_property_get_symbol (prop);
	_tmp1_ = ibus_text_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	symbol = _tmp2_;
	_tmp5_ = self->priv->m_icon_prop_key;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = ibus_property_get_key (prop);
		_tmp7_ = self->priv->m_icon_prop_key;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp8_;
		_tmp8_ = symbol;
		_tmp3_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp9_;
		_tmp9_ = symbol;
		panel_animate_icon (self, _tmp9_, all_update);
	}
	_g_free0 (symbol);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		Panel* self;
		self = _data11_->self;
		_g_free0 (_data11_->symbol);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
__lambda106_ (Block11Data* _data11_)
{
	Panel* self;
	gboolean result;
	self = _data11_->self;
	self->priv->m_property_icon_delay_time_id = (guint) 0;
	if (self->priv->m_icon_type == PANEL_ICON_TYPE_STATUS_ICON) {
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp0_;
		GtkStatusIcon* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp0_ = panel_create_icon_pixbuf_with_string (self, _data11_->symbol);
		pixbuf = _tmp0_;
		_tmp1_ = self->priv->m_status_icon;
		_tmp2_ = pixbuf;
		gtk_status_icon_set_from_pixbuf (_tmp1_, _tmp2_);
		_g_object_unref0 (pixbuf);
	} else {
		if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
			cairo_surface_t* image = NULL;
			cairo_surface_t* _tmp3_;
			Indicator* _tmp4_;
			cairo_surface_t* _tmp5_;
			_tmp3_ = panel_create_cairo_image_surface_with_string (self, _data11_->symbol, TRUE);
			image = _tmp3_;
			_tmp4_ = self->priv->m_indicator;
			_tmp5_ = image;
			indicator_set_cairo_image_surface_full (_tmp4_, _tmp5_, "");
			_cairo_surface_destroy0 (image);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda106__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda106_ (self);
	return result;
}

static void
panel_animate_icon (Panel* self,
                    const gchar* symbol,
                    gboolean all_update)
{
	Block11Data* _data11_;
	gchar* _tmp0_;
	guint timeout = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = g_strdup (symbol);
	_g_free0 (_data11_->symbol);
	_data11_->symbol = _tmp0_;
	if (self->priv->m_property_icon_delay_time < 0) {
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	timeout = (guint) 0;
	if (all_update) {
		timeout = (guint) self->priv->m_property_icon_delay_time;
	}
	if (self->priv->m_property_icon_delay_time_id > ((guint) 0)) {
		g_source_remove (self->priv->m_property_icon_delay_time_id);
		self->priv->m_property_icon_delay_time_id = (guint) 0;
	}
	self->priv->m_property_icon_delay_time_id = g_timeout_add_full (G_PRIORITY_DEFAULT, timeout, ___lambda106__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
panel_real_set_cursor_location (IBusPanelService* base,
                                gint x,
                                gint y,
                                gint width,
                                gint height)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	PropertyPanel* _tmp1_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_cursor_location (_tmp0_, x, y, width, height);
	_tmp1_ = self->priv->m_property_panel;
	property_panel_set_cursor_location (_tmp1_, x, y, width, height);
}

static gboolean
panel_switcher_focus_set_engine_real (Panel* self)
{
	IBusEngineDesc* selected_engine = NULL;
	Switcher* _tmp0_;
	IBusEngineDesc* _tmp1_;
	gchar* prev_context_path = NULL;
	Switcher* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	IBusEngineDesc* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_switcher;
	_tmp1_ = switcher_get_selected_engine (_tmp0_);
	selected_engine = _tmp1_;
	_tmp2_ = self->priv->m_switcher;
	_tmp3_ = switcher_get_input_context_path (_tmp2_);
	prev_context_path = _tmp3_;
	_tmp6_ = selected_engine;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = prev_context_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = prev_context_path;
		_tmp9_ = self->priv->m_current_context_path;
		_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		IBusEngineDesc* _tmp10_;
		Switcher* _tmp11_;
		_tmp10_ = selected_engine;
		panel_set_engine (self, _tmp10_);
		_tmp11_ = self->priv->m_switcher;
		switcher_reset (_tmp11_);
		result = TRUE;
		_g_free0 (prev_context_path);
		_g_object_unref0 (selected_engine);
		return result;
	}
	result = FALSE;
	_g_free0 (prev_context_path);
	_g_object_unref0 (selected_engine);
	return result;
}

static gpointer
_g_main_context_ref0 (gpointer self)
{
	return self ? g_main_context_ref (self) : NULL;
}

static gboolean
___lambda69_ (Panel* self)
{
	gboolean result;
	panel_switcher_focus_set_engine_real (self);
	self->priv->m_switcher_focus_set_engine_id = (guint) -1;
	result = FALSE;
	return result;
}

static gboolean
____lambda69__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda69_ ((Panel*) self);
	return result;
}

static void
panel_switcher_focus_set_engine (Panel* self)
{
	IBusEngineDesc* selected_engine = NULL;
	Switcher* _tmp0_;
	IBusEngineDesc* _tmp1_;
	gchar* prev_context_path = NULL;
	Switcher* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	IBusEngineDesc* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_switcher;
	_tmp1_ = switcher_get_selected_engine (_tmp0_);
	selected_engine = _tmp1_;
	_tmp2_ = self->priv->m_switcher;
	_tmp3_ = switcher_get_input_context_path (_tmp2_);
	prev_context_path = _tmp3_;
	_tmp6_ = selected_engine;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		_tmp7_ = prev_context_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Switcher* _tmp8_;
		_tmp8_ = self->priv->m_switcher;
		_tmp4_ = switcher_is_running (_tmp8_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GMainContext* context = NULL;
		GMainContext* _tmp9_;
		GMainContext* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = g_main_context_default ();
		_tmp10_ = _g_main_context_ref0 (_tmp9_);
		context = _tmp10_;
		if (self->priv->m_switcher_focus_set_engine_id > ((guint) 0)) {
			GMainContext* _tmp12_;
			GSource* _tmp13_;
			_tmp12_ = context;
			_tmp13_ = g_main_context_find_source_by_id (_tmp12_, self->priv->m_switcher_focus_set_engine_id);
			_tmp11_ = _tmp13_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			g_source_remove (self->priv->m_switcher_focus_set_engine_id);
		}
		self->priv->m_switcher_focus_set_engine_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda69__gsource_func, g_object_ref (self), g_object_unref);
		_g_main_context_unref0 (context);
	} else {
		if (panel_switcher_focus_set_engine_real (self)) {
			GMainContext* context = NULL;
			GMainContext* _tmp14_;
			GMainContext* _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = g_main_context_default ();
			_tmp15_ = _g_main_context_ref0 (_tmp14_);
			context = _tmp15_;
			if (self->priv->m_switcher_focus_set_engine_id > ((guint) 0)) {
				GMainContext* _tmp17_;
				GSource* _tmp18_;
				_tmp17_ = context;
				_tmp18_ = g_main_context_find_source_by_id (_tmp17_, self->priv->m_switcher_focus_set_engine_id);
				_tmp16_ = _tmp18_ != NULL;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				g_source_remove (self->priv->m_switcher_focus_set_engine_id);
			}
			self->priv->m_switcher_focus_set_engine_id = (guint) -1;
			_g_main_context_unref0 (context);
		}
	}
	_g_free0 (prev_context_path);
	_g_object_unref0 (selected_engine);
}

static void
panel_real_focus_in (IBusPanelService* base,
                     const gchar* input_context_path)
{
	Panel * self;
	gchar* _tmp0_;
	IBusEngineDesc* engine = NULL;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	IBusEngineDesc* _tmp6_;
	IBusEngineDesc* _tmp7_;
	IBusEngineDesc* _tmp20_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup (input_context_path);
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
	if (!g_str_has_suffix (input_context_path, "InputContext_1")) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		PropertyPanel* _tmp3_;
		_tmp1_ = self->priv->m_current_context_path;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->m_real_current_context_path);
		self->priv->m_real_current_context_path = _tmp2_;
		_tmp3_ = self->priv->m_property_panel;
		property_panel_focus_in (_tmp3_);
		panel_switcher_focus_set_engine (self);
	}
	if (self->priv->m_use_global_engine) {
		return;
	}
	_tmp4_ = self->priv->m_engine_contexts;
	_tmp5_ = g_hash_table_lookup (_tmp4_, input_context_path);
	_tmp6_ = _g_object_ref0 ((IBusEngineDesc*) _tmp5_);
	engine = _tmp6_;
	_tmp7_ = engine;
	if (_tmp7_ == NULL) {
		IBusEngineDesc* _tmp8_ = NULL;
		IBusEngineDesc** _tmp9_;
		gint _tmp9__length1;
		IBusEngineDesc* _tmp12_;
		IBusEngineDesc* _tmp13_;
		_tmp9_ = self->priv->m_engines;
		_tmp9__length1 = self->priv->m_engines_length1;
		if (_tmp9__length1 > 0) {
			IBusEngineDesc** _tmp10_;
			gint _tmp10__length1;
			IBusEngineDesc* _tmp11_;
			_tmp10_ = self->priv->m_engines;
			_tmp10__length1 = self->priv->m_engines_length1;
			_tmp11_ = _tmp10_[0];
			_tmp8_ = _tmp11_;
		} else {
			_tmp8_ = NULL;
		}
		_tmp12_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (engine);
		engine = _tmp12_;
		_tmp13_ = engine;
		if (_tmp13_ == NULL) {
			_g_object_unref0 (engine);
			return;
		}
	} else {
		gboolean in_engines = FALSE;
		IBusEngineDesc** _tmp14_;
		gint _tmp14__length1;
		in_engines = FALSE;
		_tmp14_ = self->priv->m_engines;
		_tmp14__length1 = self->priv->m_engines_length1;
		{
			IBusEngineDesc** e_collection = NULL;
			gint e_collection_length1 = 0;
			gint _e_collection_size_ = 0;
			gint e_it = 0;
			e_collection = _tmp14_;
			e_collection_length1 = _tmp14__length1;
			for (e_it = 0; e_it < e_collection_length1; e_it = e_it + 1) {
				IBusEngineDesc* _tmp15_;
				IBusEngineDesc* e = NULL;
				_tmp15_ = _g_object_ref0 (e_collection[e_it]);
				e = _tmp15_;
				{
					IBusEngineDesc* _tmp16_;
					const gchar* _tmp17_;
					IBusEngineDesc* _tmp18_;
					const gchar* _tmp19_;
					_tmp16_ = engine;
					_tmp17_ = ibus_engine_desc_get_name (_tmp16_);
					_tmp18_ = e;
					_tmp19_ = ibus_engine_desc_get_name (_tmp18_);
					if (g_strcmp0 (_tmp17_, _tmp19_) == 0) {
						in_engines = TRUE;
						_g_object_unref0 (e);
						break;
					}
					_g_object_unref0 (e);
				}
			}
		}
		if (!in_engines) {
			_g_object_unref0 (engine);
			return;
		}
	}
	_tmp20_ = engine;
	panel_set_engine (self, _tmp20_);
	_g_object_unref0 (engine);
}

static void
panel_real_focus_out (IBusPanelService* base,
                      const gchar* input_context_path)
{
	Panel * self;
	gchar* _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
}

static void
panel_real_destroy_context (IBusPanelService* base,
                            const gchar* input_context_path)
{
	Panel * self;
	GHashTable* _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	if (self->priv->m_use_global_engine) {
		return;
	}
	_tmp0_ = self->priv->m_engine_contexts;
	g_hash_table_remove (_tmp0_, input_context_path);
}

static gboolean
__lambda107_ (Panel* self)
{
	Indicator* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->m_indicator;
	_tmp1_ = panel_create_activate_menu (self, FALSE);
	_tmp2_ = _tmp1_;
	indicator_set_menu (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	result = FALSE;
	return result;
}

static gboolean
___lambda107__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda107_ ((Panel*) self);
	return result;
}

static void
panel_real_register_properties (IBusPanelService* base,
                                IBusPropList* props)
{
	Panel * self;
	PropertyManager* _tmp0_;
	PropertyPanel* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_property_manager;
	property_manager_set_properties (_tmp0_, props);
	_tmp1_ = self->priv->m_property_panel;
	property_panel_set_properties (_tmp1_, props);
	panel_set_properties (self, props);
	if (self->priv->m_icon_type != PANEL_ICON_TYPE_INDICATOR) {
		return;
	}
	if (self->priv->m_is_context_menu) {
		return;
	}
	if (self->priv->m_menu_update_delay_time_id > ((guint) 0)) {
		g_source_remove (self->priv->m_menu_update_delay_time_id);
		self->priv->m_menu_update_delay_time_id = (guint) 0;
	}
	self->priv->m_menu_update_delay_time_id = g_timeout_add_full (G_PRIORITY_DEFAULT, self->priv->m_menu_update_delay_time, ___lambda107__gsource_func, g_object_ref (self), g_object_unref);
}

static void
panel_real_update_property (IBusPanelService* base,
                            IBusProperty* prop)
{
	Panel * self;
	PropertyManager* _tmp0_;
	PropertyPanel* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_property_manager;
	property_manager_update_property (_tmp0_, prop);
	_tmp1_ = self->priv->m_property_panel;
	property_panel_update_property (_tmp1_, prop);
	panel_set_property (self, prop, FALSE);
}

static void
panel_real_update_preedit_text (IBusPanelService* base,
                                IBusText* text,
                                guint cursor_pos,
                                gboolean visible)
{
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	if (visible) {
		CandidatePanel* _tmp0_;
		PropertyPanel* _tmp1_;
		_tmp0_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp0_, text, cursor_pos);
		_tmp1_ = self->priv->m_property_panel;
		property_panel_set_preedit_text (_tmp1_, text, cursor_pos);
	} else {
		CandidatePanel* _tmp2_;
		PropertyPanel* _tmp3_;
		_tmp2_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp2_, NULL, (guint) 0);
		_tmp3_ = self->priv->m_property_panel;
		property_panel_set_preedit_text (_tmp3_, NULL, (guint) 0);
	}
}

static void
panel_real_hide_preedit_text (IBusPanelService* base)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_preedit_text (_tmp0_, NULL, (guint) 0);
}

static void
panel_real_update_auxiliary_text (IBusPanelService* base,
                                  IBusText* text,
                                  gboolean visible)
{
	Panel * self;
	IBusText* _tmp0_ = NULL;
	CandidatePanel* _tmp1_;
	IBusText* _tmp2_ = NULL;
	PropertyPanel* _tmp3_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	if (visible) {
		_tmp0_ = text;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp1_, _tmp0_);
	if (visible) {
		_tmp2_ = text;
	} else {
		_tmp2_ = NULL;
	}
	_tmp3_ = self->priv->m_property_panel;
	property_panel_set_auxiliary_text (_tmp3_, _tmp2_);
}

static void
panel_real_hide_auxiliary_text (IBusPanelService* base)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp0_, NULL);
}

static void
panel_real_update_lookup_table (IBusPanelService* base,
                                IBusLookupTable* table,
                                gboolean visible)
{
	Panel * self;
	IBusLookupTable* _tmp0_ = NULL;
	CandidatePanel* _tmp1_;
	IBusLookupTable* _tmp2_ = NULL;
	PropertyPanel* _tmp3_;
	self = (Panel*) base;
	g_return_if_fail (table != NULL);
	if (visible) {
		_tmp0_ = table;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp1_, _tmp0_);
	if (visible) {
		_tmp2_ = table;
	} else {
		_tmp2_ = NULL;
	}
	_tmp3_ = self->priv->m_property_panel;
	property_panel_set_lookup_table (_tmp3_, _tmp2_);
}

static void
panel_real_hide_lookup_table (IBusPanelService* base)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp0_, NULL);
}

static void
panel_real_set_content_type (IBusPanelService* base,
                             guint purpose,
                             guint hints)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_content_type (_tmp0_, purpose, hints);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_vala_array_add28 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
panel_real_state_changed (IBusPanelService* base)
{
	Panel * self;
	Switcher* _tmp0_;
	gchar* icon_name = NULL;
	gchar* _tmp2_;
	IBusEngineDesc* engine = NULL;
	IBusBus* _tmp3_;
	IBusEngineDesc* _tmp4_;
	IBusEngineDesc* _tmp5_;
	const gchar* _tmp13_;
	IBusEngineDesc* _tmp54_;
	gint i = 0;
	IBusEngineDesc** _tmp63_;
	gint _tmp63__length1;
	IBusEngineDesc** _tmp70_;
	gint _tmp70__length1;
	IBusEngineDesc* _tmp71_;
	IBusEngineDesc* _tmp72_;
	gchar** names = NULL;
	gchar** _tmp73_;
	gint names_length1;
	gint _names_size_;
	IBusEngineDesc** _tmp74_;
	gint _tmp74__length1;
	GSettings* _tmp79_;
	gchar** _tmp80_;
	gint _tmp80__length1;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_switcher;
	if (switcher_is_running (_tmp0_)) {
		return;
	}
	if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
		Indicator* _tmp1_;
		_tmp1_ = self->priv->m_indicator;
		if (_tmp1_ == NULL) {
			return;
		}
	}
	_tmp2_ = g_strdup ("ibus-keyboard");
	icon_name = _tmp2_;
	_tmp3_ = self->priv->m_bus;
	_tmp4_ = ibus_bus_get_global_engine (_tmp3_);
	engine = _tmp4_;
	_tmp5_ = engine;
	if (_tmp5_ != NULL) {
		IBusEngineDesc* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		IBusEngineDesc* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = engine;
		_tmp7_ = ibus_engine_desc_get_icon (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (icon_name);
		icon_name = _tmp8_;
		_tmp9_ = engine;
		_tmp10_ = ibus_engine_desc_get_icon_prop_key (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->priv->m_icon_prop_key);
		self->priv->m_icon_prop_key = _tmp11_;
	} else {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("");
		_g_free0 (self->priv->m_icon_prop_key);
		self->priv->m_icon_prop_key = _tmp12_;
	}
	_tmp13_ = icon_name;
	if (string_get (_tmp13_, (glong) 0) == '/') {
		if (self->priv->m_icon_type == PANEL_ICON_TYPE_STATUS_ICON) {
			GtkStatusIcon* _tmp14_;
			const gchar* _tmp15_;
			_tmp14_ = self->priv->m_status_icon;
			_tmp15_ = icon_name;
			gtk_status_icon_set_from_file (_tmp14_, _tmp15_);
		} else {
			if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
				Indicator* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = self->priv->m_indicator;
				_tmp17_ = icon_name;
				indicator_set_icon_full (_tmp16_, _tmp17_, "");
			}
		}
	} else {
		gchar* language = NULL;
		IBusEngineDesc* _tmp18_;
		const gchar* _tmp32_;
		language = NULL;
		_tmp18_ = engine;
		if (_tmp18_ != NULL) {
			gchar* name = NULL;
			IBusEngineDesc* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp19_ = engine;
			_tmp20_ = ibus_engine_desc_get_name (_tmp19_);
			_tmp21_ = g_strdup (_tmp20_);
			name = _tmp21_;
			_tmp23_ = name;
			_tmp24_ = strlen (_tmp23_);
			_tmp25_ = _tmp24_;
			if (_tmp25_ >= 4) {
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp26_ = name;
				_tmp27_ = string_slice (_tmp26_, (glong) 0, (glong) 4);
				_tmp28_ = _tmp27_;
				_tmp22_ = g_strcmp0 (_tmp28_, "xkb:") == 0;
				_g_free0 (_tmp28_);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				Switcher* _tmp29_;
				IBusEngineDesc* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = self->priv->m_switcher;
				_tmp30_ = engine;
				_tmp31_ = switcher_get_xkb_language (_tmp29_, _tmp30_);
				_g_free0 (language);
				language = _tmp31_;
			}
			_g_free0 (name);
		}
		_tmp32_ = language;
		if (_tmp32_ != NULL) {
			if (self->priv->m_icon_type == PANEL_ICON_TYPE_STATUS_ICON) {
				GdkPixbuf* pixbuf = NULL;
				const gchar* _tmp33_;
				GdkPixbuf* _tmp34_;
				GtkStatusIcon* _tmp35_;
				GdkPixbuf* _tmp36_;
				_tmp33_ = language;
				_tmp34_ = panel_create_icon_pixbuf_with_string (self, _tmp33_);
				pixbuf = _tmp34_;
				_tmp35_ = self->priv->m_status_icon;
				_tmp36_ = pixbuf;
				gtk_status_icon_set_from_pixbuf (_tmp35_, _tmp36_);
				_g_object_unref0 (pixbuf);
			} else {
				if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
					cairo_surface_t* image = NULL;
					const gchar* _tmp37_;
					cairo_surface_t* _tmp38_;
					Indicator* _tmp39_;
					cairo_surface_t* _tmp40_;
					_tmp37_ = language;
					_tmp38_ = panel_create_cairo_image_surface_with_string (self, _tmp37_, TRUE);
					image = _tmp38_;
					_tmp39_ = self->priv->m_indicator;
					_tmp40_ = image;
					indicator_set_cairo_image_surface_full (_tmp39_, _tmp40_, "");
					_cairo_surface_destroy0 (image);
				}
			}
		} else {
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp41_;
			GtkIconTheme* _tmp42_;
			GtkIconTheme* _tmp43_;
			const gchar* _tmp44_;
			GtkIconInfo* _tmp45_;
			GtkIconInfo* _tmp46_;
			gboolean _tmp47_;
			_tmp41_ = gtk_icon_theme_get_default ();
			_tmp42_ = _g_object_ref0 (_tmp41_);
			theme = _tmp42_;
			_tmp43_ = theme;
			_tmp44_ = icon_name;
			_tmp45_ = gtk_icon_theme_lookup_icon (_tmp43_, _tmp44_, 48, 0);
			_tmp46_ = _tmp45_;
			_tmp47_ = _tmp46_ != NULL;
			_g_object_unref0 (_tmp46_);
			if (_tmp47_) {
				if (self->priv->m_icon_type == PANEL_ICON_TYPE_STATUS_ICON) {
					GtkStatusIcon* _tmp48_;
					const gchar* _tmp49_;
					_tmp48_ = self->priv->m_status_icon;
					_tmp49_ = icon_name;
					gtk_status_icon_set_from_icon_name (_tmp48_, _tmp49_);
				} else {
					if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
						Indicator* _tmp50_;
						const gchar* _tmp51_;
						_tmp50_ = self->priv->m_indicator;
						_tmp51_ = icon_name;
						indicator_set_icon_full (_tmp50_, _tmp51_, "");
					}
				}
			} else {
				if (self->priv->m_icon_type == PANEL_ICON_TYPE_STATUS_ICON) {
					GtkStatusIcon* _tmp52_;
					_tmp52_ = self->priv->m_status_icon;
					gtk_status_icon_set_from_icon_name (_tmp52_, "ibus-engine");
				} else {
					if (self->priv->m_icon_type == PANEL_ICON_TYPE_INDICATOR) {
						Indicator* _tmp53_;
						_tmp53_ = self->priv->m_indicator;
						indicator_set_icon_full (_tmp53_, "ibus-engine", "");
					}
				}
			}
			_g_object_unref0 (theme);
		}
		_g_free0 (language);
	}
	_tmp54_ = engine;
	if (_tmp54_ == NULL) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gboolean _tmp55_ = FALSE;
		i = 0;
		_tmp55_ = TRUE;
		while (TRUE) {
			IBusEngineDesc** _tmp57_;
			gint _tmp57__length1;
			IBusEngineDesc** _tmp58_;
			gint _tmp58__length1;
			IBusEngineDesc* _tmp59_;
			const gchar* _tmp60_;
			IBusEngineDesc* _tmp61_;
			const gchar* _tmp62_;
			if (!_tmp55_) {
				gint _tmp56_;
				_tmp56_ = i;
				i = _tmp56_ + 1;
			}
			_tmp55_ = FALSE;
			_tmp57_ = self->priv->m_engines;
			_tmp57__length1 = self->priv->m_engines_length1;
			if (!(i < _tmp57__length1)) {
				break;
			}
			_tmp58_ = self->priv->m_engines;
			_tmp58__length1 = self->priv->m_engines_length1;
			_tmp59_ = _tmp58_[i];
			_tmp60_ = ibus_engine_desc_get_name (_tmp59_);
			_tmp61_ = engine;
			_tmp62_ = ibus_engine_desc_get_name (_tmp61_);
			if (g_strcmp0 (_tmp60_, _tmp62_) == 0) {
				break;
			}
		}
	}
	if (i == 0) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	_tmp63_ = self->priv->m_engines;
	_tmp63__length1 = self->priv->m_engines_length1;
	if (i >= _tmp63__length1) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gint j = 0;
		j = i;
		{
			gboolean _tmp64_ = FALSE;
			_tmp64_ = TRUE;
			while (TRUE) {
				IBusEngineDesc** _tmp66_;
				gint _tmp66__length1;
				IBusEngineDesc** _tmp67_;
				gint _tmp67__length1;
				IBusEngineDesc* _tmp68_;
				IBusEngineDesc* _tmp69_;
				if (!_tmp64_) {
					gint _tmp65_;
					_tmp65_ = j;
					j = _tmp65_ - 1;
				}
				_tmp64_ = FALSE;
				if (!(j > 0)) {
					break;
				}
				_tmp66_ = self->priv->m_engines;
				_tmp66__length1 = self->priv->m_engines_length1;
				_tmp67_ = self->priv->m_engines;
				_tmp67__length1 = self->priv->m_engines_length1;
				_tmp68_ = _tmp67_[j - 1];
				_tmp69_ = _g_object_ref0 (_tmp68_);
				_g_object_unref0 (_tmp66_[j]);
				_tmp66_[j] = _tmp69_;
			}
		}
	}
	_tmp70_ = self->priv->m_engines;
	_tmp70__length1 = self->priv->m_engines_length1;
	_tmp71_ = engine;
	_tmp72_ = _g_object_ref0 (_tmp71_);
	_g_object_unref0 (_tmp70_[0]);
	_tmp70_[0] = _tmp72_;
	_tmp73_ = g_new0 (gchar*, 0 + 1);
	names = _tmp73_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp74_ = self->priv->m_engines;
	_tmp74__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** desc_collection = NULL;
		gint desc_collection_length1 = 0;
		gint _desc_collection_size_ = 0;
		gint desc_it = 0;
		desc_collection = _tmp74_;
		desc_collection_length1 = _tmp74__length1;
		for (desc_it = 0; desc_it < desc_collection_length1; desc_it = desc_it + 1) {
			IBusEngineDesc* _tmp75_;
			IBusEngineDesc* desc = NULL;
			_tmp75_ = _g_object_ref0 (desc_collection[desc_it]);
			desc = _tmp75_;
			{
				IBusEngineDesc* _tmp76_;
				const gchar* _tmp77_;
				gchar* _tmp78_;
				_tmp76_ = desc;
				_tmp77_ = ibus_engine_desc_get_name (_tmp76_);
				_tmp78_ = g_strdup (_tmp77_);
				_vala_array_add28 (&names, &names_length1, &_names_size_, _tmp78_);
				_g_object_unref0 (desc);
			}
		}
	}
	_tmp79_ = self->priv->m_settings_general;
	_tmp80_ = names;
	_tmp80__length1 = names_length1;
	g_settings_set_strv (_tmp79_, "engines-order", _tmp80_);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
	_g_free0 (icon_name);
}

static void
g_cclosure_user_marshal_VOID__POINTER_INT_ENUM (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__POINTER_INT_ENUM) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_enum (param_values + 3), data2);
}

static void
panel_class_init (PanelClass * klass,
                  gpointer klass_data)
{
	panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Panel_private_offset);
	((IBusPanelServiceClass *) klass)->set_cursor_location = (void (*) (IBusPanelService*, gint, gint, gint, gint)) panel_real_set_cursor_location;
	((IBusPanelServiceClass *) klass)->focus_in = (void (*) (IBusPanelService*, const gchar*)) panel_real_focus_in;
	((IBusPanelServiceClass *) klass)->focus_out = (void (*) (IBusPanelService*, const gchar*)) panel_real_focus_out;
	((IBusPanelServiceClass *) klass)->destroy_context = (void (*) (IBusPanelService*, const gchar*)) panel_real_destroy_context;
	((IBusPanelServiceClass *) klass)->register_properties = (void (*) (IBusPanelService*, IBusPropList*)) panel_real_register_properties;
	((IBusPanelServiceClass *) klass)->update_property = (void (*) (IBusPanelService*, IBusProperty*)) panel_real_update_property;
	((IBusPanelServiceClass *) klass)->update_preedit_text = (void (*) (IBusPanelService*, IBusText*, guint, gboolean)) panel_real_update_preedit_text;
	((IBusPanelServiceClass *) klass)->hide_preedit_text = (void (*) (IBusPanelService*)) panel_real_hide_preedit_text;
	((IBusPanelServiceClass *) klass)->update_auxiliary_text = (void (*) (IBusPanelService*, IBusText*, gboolean)) panel_real_update_auxiliary_text;
	((IBusPanelServiceClass *) klass)->hide_auxiliary_text = (void (*) (IBusPanelService*)) panel_real_hide_auxiliary_text;
	((IBusPanelServiceClass *) klass)->update_lookup_table = (void (*) (IBusPanelService*, IBusLookupTable*, gboolean)) panel_real_update_lookup_table;
	((IBusPanelServiceClass *) klass)->hide_lookup_table = (void (*) (IBusPanelService*)) panel_real_hide_lookup_table;
	((IBusPanelServiceClass *) klass)->set_content_type = (void (*) (IBusPanelService*, guint, guint)) panel_real_set_content_type;
	((IBusPanelServiceClass *) klass)->state_changed = (void (*) (IBusPanelService*)) panel_real_state_changed;
	G_OBJECT_CLASS (klass)->finalize = panel_finalize;
	panel_signals[PANEL_REALIZE_SURFACE_SIGNAL] = g_signal_new ("realize-surface", TYPE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	panel_signals[PANEL_UPDATE_SHORTCUT_KEYS_SIGNAL] = g_signal_new ("update-shortcut-keys", TYPE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_ENUM, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, BINDING_COMMON_TYPE_KEY_EVENT_FUNC_TYPE);
}

static void
panel_instance_init (Panel * self,
                     gpointer klass)
{
	IBusEngineDesc** _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GdkRGBA _tmp12_ = {0};
	XKBLayout* _tmp13_;
	gchar* _tmp14_;
	self->priv = panel_get_instance_private (self);
	self->priv->m_settings_general = NULL;
	self->priv->m_settings_hotkey = NULL;
	self->priv->m_settings_panel = NULL;
	self->priv->m_icon_type = PANEL_ICON_TYPE_STATUS_ICON;
	self->priv->m_indicator_show_status = INDICATOR_STATUS_ACTIVE;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->priv->m_engines = _tmp0_;
	self->priv->m_engines_length1 = 0;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	self->priv->m_engine_contexts = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->m_current_context_path = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->m_real_current_context_path = _tmp5_;
	self->priv->m_use_global_engine = TRUE;
	self->priv->m_use_engine_lang = TRUE;
	self->priv->m_switcher_selected_index = -1;
	self->priv->m_setup_pid = (GPid) 0;
	self->priv->m_switcher_delay_time = 400;
	self->priv->m_use_system_keyboard_layout = FALSE;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_object_unref0_);
	self->priv->m_xkb_icon_pixbufs = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, _cairo_surface_destroy0_);
	self->priv->m_xkb_icon_image = _tmp11_;
	memset (&_tmp12_, 0, sizeof (GdkRGBA));
	_tmp12_.red = 0.0;
	_tmp12_.green = 0.0;
	_tmp12_.blue = 0.0;
	_tmp12_.alpha = 1.0;
	self->priv->m_xkb_icon_rgba = _tmp12_;
	_tmp13_ = xkb_layout_new ();
	self->priv->m_xkblayout = _tmp13_;
	self->priv->inited_engines_order = TRUE;
	_tmp14_ = g_strdup ("");
	self->priv->m_icon_prop_key = _tmp14_;
	self->priv->m_property_icon_delay_time = 500;
	self->priv->m_menu_update_delay_time = (guint) 100;
	self->priv->m_is_kde = panel_is_kde ();
	self->priv->m_keybindings = NULL;
}

static void
panel_finalize (GObject * obj)
{
	Panel * self;
	Indicator* _tmp0_;
	GList* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL, Panel);
	_tmp0_ = self->priv->m_indicator;
	if (_tmp0_ != NULL) {
		Indicator* _tmp1_;
		_tmp1_ = self->priv->m_indicator;
		indicator_unregister_connection (_tmp1_);
	}
	_tmp2_ = self->priv->m_keybindings;
	binding_common_unbind_switch_shortcut (BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY, _tmp2_);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	self->priv->m_keybindings = NULL;
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_settings_general);
	_g_object_unref0 (self->priv->m_settings_hotkey);
	_g_object_unref0 (self->priv->m_settings_panel);
	_g_object_unref0 (self->priv->m_indicator);
	_g_object_unref0 (self->priv->m_status_icon);
	_g_object_unref0 (self->priv->m_ime_menu);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->m_engine_contexts);
	_g_free0 (self->priv->m_current_context_path);
	_g_free0 (self->priv->m_real_current_context_path);
	_g_object_unref0 (self->priv->m_candidate_panel);
	_g_object_unref0 (self->priv->m_switcher);
	_g_thread_unref0 (self->priv->m_switcher_waiting_release);
	_property_manager_unref0 (self->priv->m_property_manager);
	_g_object_unref0 (self->priv->m_property_panel);
	_g_object_unref0 (self->priv->m_about_dialog);
	_g_object_unref0 (self->priv->m_css_provider);
	_g_hash_table_unref0 (self->priv->m_xkb_icon_pixbufs);
	_g_hash_table_unref0 (self->priv->m_xkb_icon_image);
	_xkb_layout_unref0 (self->priv->m_xkblayout);
	_g_free0 (self->priv->m_icon_prop_key);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	G_OBJECT_CLASS (panel_parent_class)->finalize (obj);
}

static GType
panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Panel), 0, (GInstanceInitFunc) panel_instance_init, NULL };
	GType panel_type_id;
	panel_type_id = g_type_register_static (ibus_panel_service_get_type (), "Panel", &g_define_type_info, 0);
	Panel_private_offset = g_type_add_instance_private (panel_type_id, sizeof (PanelPrivate));
	return panel_type_id;
}

GType
panel_get_type (void)
{
	static volatile gsize panel_type_id__once = 0;
	if (g_once_init_enter (&panel_type_id__once)) {
		GType panel_type_id;
		panel_type_id = panel_get_type_once ();
		g_once_init_leave (&panel_type_id__once, panel_type_id);
	}
	return panel_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

