This module sets the Type of Service field in the IPv4 header (including the
"precedence" bits) or the Priority field in the IPv6 header. Note that TOS
shares the same bits as DSCP and ECN. The TOS target is only valid in the
\fBmangle\fP table.
.TP
\fB\-\-set\-tos\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fP (see NOTE below) and XORs \fIvalue\fP
into the TOS/Priority field. If \fImask\fP is omitted, 0xFF is assumed.
.TP
\fB\-\-set\-tos\fP \fIsymbol\fP
You can specify a symbolic name when using the TOS target for IPv4. It implies
a mask of 0xFF (see NOTE below). The list of recognized TOS names can be
obtained by calling iptables with \fB\-j TOS \-h\fP.
.PP
The following mnemonics are available:
.TP
\fB\-\-and\-tos\fP \fIbits\fP
Binary AND the TOS value with \fIbits\fP. (Mnemonic for \fB\-\-set\-tos
0/\fP\fIinvbits\fP, where \fIinvbits\fP is the binary negation of \fIbits\fP.
See NOTE below.)
.TP
\fB\-\-or\-tos\fP \fIbits\fP
Binary OR the TOS value with \fIbits\fP. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fP\fB/\fP\fIbits\fP. See NOTE below.)
.TP
\fB\-\-xor\-tos\fP \fIbits\fP
Binary XOR the TOS value with \fIbits\fP. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fP\fB/0\fP. See NOTE below.)
.PP
NOTE: In Linux kernels up to and including 2.6.38, with the exception of
longterm releases 2.6.32.42 (or later) and 2.6.33.15 (or later), there is a bug
whereby IPv6 TOS mangling does not behave as documented and differs from the
IPv4 version. The TOS mask indicates the bits one wants to zero out, so it needs
to be inverted before applying it to the original TOS field. However, the
aformentioned kernels forgo the inversion which breaks --set-tos and its
mnemonics.
