
/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: IvmConfigBase.c,v 1.19 2005/05/12 01:42:34 ro_han Exp $
 *****************************************************************************/

#include <string.h>
#include <glib.h>
#include <libxml/tree.h>

#include "IvmConfigBase.h"
#include "common.h"

IvmConfigBase * parseIvmConfigBase(char const * const path)
{
    LIBXML_TEST_VERSION IvmConfigBase * ret = NULL;

    // DEBUG("parseIvmConfigBase %s", path);
    ret = (IvmConfigBase *) malloc(sizeof(IvmConfigBase));

    if (ret == NULL)
    {
        DEBUG("Malloc of ret failed");
        return NULL;
    }

    memset(ret, 0, sizeof(IvmConfigBase));

    xmlDocPtr doc;
    xmlNodePtr cur;

    doc = xmlParseFile(path);
    if (doc == NULL)
    {
        DEBUG("Document not parsed successfully.");
        return NULL;
    }

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL)
    {
        DEBUG("Empty document");
        xmlFreeDoc(doc);
        return NULL;
    }
    if (xmlStrcmp(cur->name, (const xmlChar *) "BaseConfig"))
    {
        DEBUG("Document of the wrong type, root node != BaseConfig");
        xmlFreeDoc(doc);
        return NULL;
    }
    cur = cur->xmlChildrenNode;
    while (cur != NULL)
    {
        if (!xmlStrcmp(cur->name, (const xmlChar *) "Option"))
        {
            // DEBUG("Parsing an Option");

            xmlChar *name;

            name = xmlGetProp(cur, "name");
            // DEBUG("name: %s", name);

            xmlChar *value;

            value = xmlGetProp(cur, "value");
            // DEBUG("value: %s\n", value);

            if (!xmlStrcmp(name, (const xmlChar *) "debug"))
            {
                if (!xmlStrcmp(value, (const xmlChar *) "true"))
                    ret->debug = TRUE;
                else
                    ret->debug = FALSE;
            }
            if (!xmlStrcmp(name, (const xmlChar *) "fork"))
            {
                if (!xmlStrcmp(value, (const xmlChar *) "true"))
                    ret->fork = TRUE;
                else
                    ret->fork = FALSE;
            }

            if (!xmlStrcmp(name, (const xmlChar *) "pidfile"))
            {
                ret->pidFile = (char *) strdup((char *) value);
                // DEBUG("pidfile is %s", ret->pidFile);
            }

            if (!xmlStrcmp(name, (const xmlChar *) "group"))
            {
                ret->group = (char *) strdup((char *) value);
            }

            if (!xmlStrcmp(name, (const xmlChar *) "user"))
            {
                ret->user = (char *) strdup((char *) value);
            }


            xmlFree(value);
            xmlFree(name);
        }
        cur = cur->next;
    }
    xmlFreeDoc(doc);

    xmlCleanupParser();

    return ret;
}
