#!/bin/bash --

set -e
. ../jh_lib.sh

# checkmanifest <source> <correct result> [parameters...]
checkmanifest()
{
	error=0
	source=$1
	verify=$2
	shift
	shift
	touch foo
	jar cfm test.jar $source foo
	../jh_manifest "$@" test.jar
	jar xf test.jar META-INF/MANIFEST.MF
	if ! diff -u $verify META-INF/MANIFEST.MF > test.diff; then
		error=1
		echo "ERROR: difference detected:"
		cat test.diff
		echo
		echo "Source:"
		cat $source
		echo
		echo "Parameters:"
		echo "$@"
		echo
		echo "Desired:"
		cat $verify
		echo
		echo "Actual:"
		cat META-INF/MANIFEST.MF
	fi
	rm -rf META-INF
	rm test.jar test.diff foo
	return $error
}

#checkextract <source> <key> <value>
checkextract()
{
	LINE="`extractline "$1" "$2"`"

	if [ "$LINE" != "$3" ]; then
		echo "Failed to extract $2 from $1"
		echo "Desired: $3"
		echo "Actual: $LINE"
	fi
}

#checkarch input output
checkarch()
{
	OUT="`../java-arch.sh "$1"`"
	if ! [ "$OUT" = "$2" ]; then
		echo "Failed converting arch $1"
		echo "Desired $2"
		echo "Actual $OUT"
	fi
}

# checkarches inputfile output file
checkarches ()
{
	i=1
	for a in `cat "$1"`; do
		checkarch "$a" "`head -n$i "$2" | tail -n1`"
		i=$(( $i + 1 ))
	done
}

checkmanifest sample sample
checkmanifest long-in long-out
checkmanifest onelong-in onelong-out
checkmanifest sample long-out2 --classpath="/usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar"
checkmanifest sample onelong-out2 --classpath=/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/hexdump.jar

checkextract onelong-out2 Class-Path /usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/usr/share/java/hexdump.jar
checkextract long-out2 Class-Path "/usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar /usr/share/java/hexdump.jar"

checkarches archs-in archs-out

