# (c) 2007 Canonical Ltd.
# Author: Martin Pitt <martin.pitt@ubuntu.com>
# License: GPL v2 or later

'''Handler for ipw3945 module.'''

from jockey.handlers import KernelModuleHandler

class Ipw3945Handler(KernelModuleHandler):
    '''Handler for the ipw3945 Wifi module which has a non-free system
    daemon.'''

    def __init__(self, ui):
        KernelModuleHandler.__init__(self, ui, 'ipw3945', rationale=
            ui._('While this driver is mostly free, it relies on a piece of '
            'proprietary software to determine the channels your '
            'wireless card is permitted to use.\n\n'
            'If this driver is not enabled, you will not be able to use '
            'your wireless card.'))
