/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.CallSite;
import java.dyn.LinkagePermission;
import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.WrongMethodTypeException;
import java.dyn.util.MethodHandleInvoker;
import java.util.WeakHashMap;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linkage {
    public static final MethodType BOOTSTRAP_METHOD_TYPE = MethodType.make(Object.class, CallSite.class, Object[].class).newVarArgs(true);
    private static MethodHandleInvoker bootstrapMethodInvoker;
    private static final WeakHashMap<Class, MethodHandle> bootstrapMethods;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBootstrapMethod(Class clazz, MethodHandle methodHandle) {
        Class clazz2 = Reflection.getCallerClass((int)2);
        Linkage.checkPackagePrivilege(clazz2, clazz, "registerBootstrapMethod");
        if (methodHandle != null && methodHandle.type() != BOOTSTRAP_METHOD_TYPE) {
            throw new WrongMethodTypeException(methodHandle.type().toString());
        }
        WeakHashMap<Class, MethodHandle> weakHashMap = bootstrapMethods;
        synchronized (weakHashMap) {
            if (bootstrapMethods.containsKey(clazz)) {
                throw new IllegalStateException("bootstrap method already declared in " + clazz);
            }
            bootstrapMethods.put(clazz, methodHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodHandle getBootstrapMethod(Class clazz) {
        Class clazz2 = Reflection.getCallerClass((int)2);
        Linkage.checkPackagePrivilege(clazz2, clazz, "registerBootstrapMethod");
        WeakHashMap<Class, MethodHandle> weakHashMap = bootstrapMethods;
        synchronized (weakHashMap) {
            return bootstrapMethods.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bootstrapInvokeDynamic(CallSite callSite, Object ... objectArray) {
        MethodHandle methodHandle;
        Class<?> clazz = callSite.callerClass();
        WeakHashMap<Class, MethodHandle> weakHashMap = bootstrapMethods;
        synchronized (weakHashMap) {
            methodHandle = bootstrapMethods.get(clazz);
        }
        if (methodHandle == null) {
            throw new IllegalStateException("no bootstrap method declared in " + clazz);
        }
        System.out.println(callSite + ": calling bootstrap " + methodHandle);
        if (bootstrapMethodInvoker == null) {
            bootstrapMethodInvoker = MethodHandleInvoker.make(BOOTSTRAP_METHOD_TYPE);
        }
        return bootstrapMethodInvoker.invoke_LLL(methodHandle, callSite, objectArray);
    }

    public static Object invalidateAll() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkagePermission("invalidateAll"));
        }
        throw new UnsupportedOperationException("NYI");
    }

    public static Object invalidateCallerClass(Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkagePermission("invalidateAll", clazz));
        }
        throw new UnsupportedOperationException("NYI");
    }

    static void checkPackagePrivilege(Class clazz, Class clazz2, String string) {
        ClassLoader classLoader;
        if (clazz == null) {
            return;
        }
        if (clazz == clazz2) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ClassLoader classLoader2 = clazz.getClassLoader();
        if (Linkage.isParent(classLoader2, classLoader = clazz2.getClassLoader())) {
            String string2 = clazz.getName();
            if (string2.startsWith("java.dyn.")) {
                return;
            }
            String string3 = clazz2.getName();
            if (Linkage.samePackage(string2, string3)) {
                return;
            }
        }
        securityManager.checkPermission(new LinkagePermission(string, clazz));
    }

    static MethodHandle findBootstrapMethod(Class clazz, Class clazz2) {
        if (clazz2 != null) {
            throw new UnsupportedOperationException("NYI");
        }
        MethodHandle methodHandle = Linkage.getBootstrapMethod(clazz);
        System.out.println("reporting bootstrap method to JVM: " + methodHandle);
        return methodHandle;
    }

    private static boolean isParent(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null && classLoader2 != classLoader) {
            classLoader2 = classLoader2.getParent();
        }
        return classLoader2 == classLoader;
    }

    private static boolean samePackage(String string, String string2) {
        assert ((string.indexOf(47) & string2.indexOf(47)) < 0);
        int n = string.lastIndexOf(46);
        if (n != string2.lastIndexOf(46)) {
            return false;
        }
        return string.startsWith(string2.substring(0, n + 1));
    }

    static {
        bootstrapMethods = new WeakHashMap();
    }
}

