/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.Wrappers;
import java.dyn.impl.Access;
import java.dyn.impl.MH;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHandles {
    private static final Access TOKEN = Access.getToken();
    private static MethodHandle IDENTITY;
    private static final MethodType IDENTITY_TYPE;
    private static MethodHandle EMPTY;
    private static final MethodType EMPTY_TYPE;

    private MethodHandles() {
    }

    public static MethodHandle findStatic(Class<?> clazz, String string, MethodType methodType) {
        Class clazz2 = Reflection.getCallerClass((int)2);
        return MH.findMethod(TOKEN, clazz, string, null, methodType, false, clazz2);
    }

    public static MethodHandle findVirtual(Class<?> clazz, String string, MethodType methodType) {
        Class clazz2 = Reflection.getCallerClass((int)2);
        return MH.findMethod(TOKEN, clazz, string, clazz, methodType, true, clazz2);
    }

    public static MethodHandle findSpecial(Class<?> clazz, String string, MethodType methodType) {
        Class clazz2 = Reflection.getCallerClass((int)2);
        return MH.findMethod(TOKEN, clazz, string, clazz, methodType, false, clazz2);
    }

    public static MethodHandle unreflect(Method method) {
        Class clazz = Reflection.getCallerClass((int)2);
        return MH.findMethod(TOKEN, method, true, clazz);
    }

    public static MethodHandle unreflectSpecial(Method method) {
        Class clazz = Reflection.getCallerClass((int)2);
        return MH.findMethod(TOKEN, method, false, clazz);
    }

    public static MethodHandle unreflectGetter(Field field) {
        Class clazz = Reflection.getCallerClass((int)2);
        return MH.findField(TOKEN, field, false, clazz);
    }

    public static MethodHandle unreflectSetter(Field field) {
        Class clazz = Reflection.getCallerClass((int)2);
        return MH.findField(TOKEN, field, true, clazz);
    }

    static <M extends MethodHandle> M castType(M m, MethodType methodType) {
        MethodType methodType2 = m.type();
        if (!methodType.equals((Object)methodType2)) {
            throw new ClassCastException(methodType2.toString());
        }
        return m;
    }

    static Object checkValue(Class<?> clazz, Class<?> clazz2, Object object) throws ClassCastException {
        char c;
        if (clazz == clazz2) {
            return object;
        }
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (!bl) {
            if (!bl2) {
                return clazz2.cast(clazz.cast(object));
            }
            Class<?> clazz3 = Wrappers.asWrapperType(clazz);
            return clazz2.cast(clazz3.cast(object));
        }
        if (!bl2) {
            Class<?> clazz4 = Wrappers.asWrapperType(clazz2);
            return clazz4.cast(clazz.cast(object));
        }
        if (object == null) {
            return Wrappers.zeroValue(clazz2);
        }
        if (object instanceof Character) {
            c = ((Character)object).charValue();
            object = (int)c;
            if (clazz2 == Integer.class) {
                return object;
            }
        } else if (object instanceof Boolean) {
            c = (char)(((Boolean)object).booleanValue() ? 1 : 0);
            object = c != '\u0000' ? 1 : 0;
            if (clazz2 == Integer.class) {
                return object;
            }
        }
        Number number = (Number)object;
        switch (Wrappers.basicTypeChar(clazz2)) {
            case 'Z': {
                return number.intValue() != 0;
            }
            case 'B': {
                return number.byteValue();
            }
            case 'C': {
                return Character.valueOf((char)number.intValue());
            }
            case 'S': {
                return number.shortValue();
            }
            case 'I': {
                return number.intValue();
            }
            case 'J': {
                return number.longValue();
            }
            case 'F': {
                return Float.valueOf(number.floatValue());
            }
            case 'D': {
                return number.doubleValue();
            }
        }
        return null;
    }

    static Object checkValue(Class<?> clazz, Object object) throws ClassCastException {
        return MethodHandles.checkValue(clazz, object.getClass(), object);
    }

    static MethodHandle adaptArguments(MethodHandle methodHandle, MethodType methodType, String string, Object object) {
        throw new UnsupportedOperationException("NYI");
    }

    static MethodHandle adaptArguments(MethodHandle methodHandle, MethodType methodType, String string, Object ... objectArray) {
        return MethodHandles.adaptArguments(methodHandle, methodType, string, (Object)objectArray);
    }

    static MethodHandle adaptArguments(MethodHandle methodHandle, MethodType methodType, String string) {
        return MethodHandles.adaptArguments(methodHandle, methodType, string, (Object)null);
    }

    public static MethodHandle convertArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        if (methodType2.equals((Object)methodType)) {
            return methodHandle;
        }
        return MethodHandles.adaptArguments(methodHandle, methodType, "*$0");
    }

    public static MethodHandle spreadArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        int n = methodType.parameterCount();
        int n2 = methodType2.parameterCount();
        int n3 = n - 1;
        int n4 = n2 - n3;
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("wrong number of arguments");
        }
        StringBuilder stringBuilder = new StringBuilder(n * 4 + 16);
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append("$").append(i);
        }
        stringBuilder.append("!$").append(n3).append("/").append(n4);
        if (n4 != 0) {
            stringBuilder.append("*$").append(n3).append("/0");
        }
        return MethodHandles.adaptArguments(methodHandle, methodType, stringBuilder.toString());
    }

    public static MethodHandle collectArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        int n = methodType.parameterCount();
        int n2 = methodType2.parameterCount();
        int n3 = n2 - 1;
        int n4 = n - n3;
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("wrong number of arguments");
        }
        StringBuilder stringBuilder = new StringBuilder(n * 4 + 16);
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append("$").append(i);
        }
        if (n4 == 0) {
            stringBuilder.append("{}");
        } else {
            stringBuilder.append("{*$").append(n3).append("}");
        }
        return MethodHandles.adaptArguments(methodHandle, methodType, stringBuilder.toString());
    }

    public static MethodHandle insertArgument(MethodHandle methodHandle, Object object) {
        return MethodHandles.insertArgument(methodHandle, object, 0);
    }

    public static MethodHandle appendArgument(MethodHandle methodHandle, Object object) {
        return MethodHandles.insertArgument(methodHandle, object, methodHandle.type().parameterCount());
    }

    public static MethodHandle insertArgument(MethodHandle methodHandle, Object object, int n) {
        Object object2;
        MethodType methodType = methodHandle.type();
        ArrayList arrayList = new ArrayList(methodType.parameterList());
        int n2 = methodType.parameterCount();
        int n3 = n2 - 1;
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("no argument type to append");
        }
        Class<?> clazz = arrayList.remove(n);
        object = MethodHandles.checkValue(clazz, object);
        MethodType methodType2 = MethodType.make(methodType.returnType(), arrayList);
        if (n == 0 && !clazz.isPrimitive() && (object2 = MH.bindReceiver(TOKEN, methodHandle, object)) != null) {
            return object2;
        }
        switch (n) {
            case 0: {
                object2 = n3 == 0 ? "$V" : "$V*$0";
                break;
            }
            case 1: {
                object2 = n3 == 1 ? "$0$V" : "$0$V*$1";
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder(n2 * 4 + 16);
                for (int i = 0; i < n2; ++i) {
                    if (i < n) {
                        stringBuilder.append("$").append(i);
                        continue;
                    }
                    if (i == n) {
                        stringBuilder.append("$V");
                        continue;
                    }
                    stringBuilder.append("*$").append(i - 1);
                    break;
                }
                object2 = stringBuilder.toString();
            }
        }
        return MethodHandles.adaptArguments(methodHandle, methodType2, (String)object2, object);
    }

    public static MethodHandle dropArgument(MethodHandle methodHandle, Class<?> clazz, int n) {
        String string;
        MethodType methodType = methodHandle.type();
        ArrayList arrayList = new ArrayList(methodType.parameterList());
        int n2 = methodType.parameterCount();
        int n3 = n2 + 1;
        if (n < 0 || n >= n3) {
            throw new IllegalArgumentException("no argument type to remove");
        }
        arrayList.add(n, clazz);
        MethodType methodType2 = MethodType.make(methodType.returnType(), arrayList);
        switch (n) {
            case 0: {
                string = n3 == 0 ? "" : "*$1";
                break;
            }
            case 1: {
                string = n3 == 1 ? "$0" : "$0*$2";
                break;
            }
            default: {
                if (n == n2) {
                    string = "*$0";
                    break;
                }
                StringBuilder stringBuilder = new StringBuilder(n2 * 4 + 16);
                for (int i = 0; i < n2; ++i) {
                    if (i < n) {
                        stringBuilder.append("$").append(i);
                        continue;
                    }
                    if (i <= n) continue;
                    stringBuilder.append("*$").append(i);
                    break;
                }
                string = stringBuilder.toString();
            }
        }
        return MethodHandles.adaptArguments(methodHandle, methodType2, string);
    }

    public static <T> T identity(T t) {
        return t;
    }

    public static MethodHandle identityMethod() {
        if (IDENTITY == null) {
            IDENTITY = MethodHandles.findStatic(MethodHandle.class, "identity", IDENTITY_TYPE);
        }
        return IDENTITY;
    }

    public static void empty() {
    }

    public static MethodHandle emptyMethod() {
        if (EMPTY == null) {
            EMPTY = MethodHandles.findStatic(MethodHandle.class, "empty", EMPTY_TYPE);
        }
        return EMPTY;
    }

    static {
        IDENTITY_TYPE = MethodType.make(Object.class, Object.class);
        EMPTY_TYPE = MethodType.make(Void.TYPE);
    }
}

