/*
 * Decompiled with CFR 0.152.
 */
package java.dyn.impl;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.Wrappers;
import java.dyn.impl.AMH;
import java.dyn.impl.Access;
import java.dyn.impl.BMH;
import java.dyn.impl.DMH;
import java.dyn.impl.DynCallSite;
import java.dyn.impl.MTForm;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MH {
    protected final MethodType type;
    Object vmref;
    long vmdata;
    long entry;
    static final boolean JVM_SUPPORT;

    public MH(Access access, MethodType methodType) {
        this.type = methodType;
        Access.check(access);
    }

    public static MethodHandle findMethod(Access access, Class<?> clazz, String string, Class<?> clazz2, MethodType methodType, boolean bl, Class<?> clazz3) {
        boolean bl2;
        Access.check(access);
        Method method = null;
        try {
            method = clazz.getMethod(string, methodType.parameterArray());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        boolean bl3 = Modifier.isStatic(method.getModifiers());
        boolean bl4 = bl2 = clazz2 == null;
        if (bl3 != bl2) {
            return null;
        }
        MethodType methodType2 = MethodType.make(method);
        if (clazz2 != null) {
            if (!methodType2.parameterType(0).isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("incompatible receiver: " + clazz2);
            }
            methodType2 = methodType2.newParameterType(0, clazz2);
        }
        return new DMH(methodType2, method, bl);
    }

    public static MethodHandle findMethod(Access access, Method method, boolean bl, Class<?> clazz) {
        MethodType methodType = MethodType.make(method);
        return new DMH(methodType, method, bl);
    }

    public static MethodHandle findField(Access access, Field field, boolean bl, Class<?> clazz) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static MethodHandle bindReceiver(Access access, MethodHandle methodHandle, Object object) {
        if (methodHandle instanceof DMH) {
            return new BMH((DMH)methodHandle, object);
        }
        return null;
    }

    protected void checkHandler() {
        if (this.entry == 0L) {
            this.noHandler();
        }
    }

    private void noHandler() {
        throw new NullPointerException();
    }

    static int canPassUnchecked(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return 1;
        }
        if (clazz2.isPrimitive()) {
            if (clazz2 == Void.TYPE) {
                return 1;
            }
            if (!clazz.isPrimitive()) {
                return 0;
            }
            boolean bl = Wrappers.isSubwordOrInt(clazz);
            boolean bl2 = Wrappers.isSubwordOrInt(clazz2);
            if (bl && bl2) {
                if (Wrappers.bitWidth(clazz) >= Wrappers.bitWidth(clazz2)) {
                    return -1;
                }
                if (!Wrappers.isSigned(clazz2) && Wrappers.isSigned(clazz)) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        if (clazz.isPrimitive()) {
            return 0;
        }
        if (clazz2.isInterface()) {
            clazz2 = Object.class;
        }
        if (clazz2 == Object.class) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        String string;
        String string2 = string = JVM_SUPPORT ? MH.getMethodName(this) : null;
        if (string == null) {
            string = "*";
        }
        return string + ":" + ((MethodHandle)this).type();
    }

    static native void init(AMH var0, int var1, int var2, Object var3);

    static native void init(BMH var0, Object var1, Object var2);

    static native void init(DMH var0, Object var1, boolean var2);

    static native void init(MTForm var0, MethodType var1);

    static native String getMethodName(MH var0);

    static native void linkCallSite(DynCallSite var0, MH var1);

    static native Object getVMRef(MH var0);

    static void setVMDataArgSlot(MH mH, int n) {
        System.out.println("patching vmdata " + Long.toHexString(mH.vmdata) + " of " + mH);
        long l = mH.vmdata >> 32;
        mH.vmdata = l << 32 | (long)(n << 32 >>> 32);
    }

    private static native void registerNatives();

    static {
        boolean bl;
        try {
            MH.registerNatives();
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        JVM_SUPPORT = bl;
    }
}

