/*
Copyright (c) 2014 VMware, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package types

import (
	"reflect"
	"time"
)

type AboutInfo struct {
	DynamicData

	Name                  string `xml:"name"`
	FullName              string `xml:"fullName"`
	Vendor                string `xml:"vendor"`
	Version               string `xml:"version"`
	Build                 string `xml:"build"`
	LocaleVersion         string `xml:"localeVersion,omitempty"`
	LocaleBuild           string `xml:"localeBuild,omitempty"`
	OsType                string `xml:"osType"`
	ProductLineId         string `xml:"productLineId"`
	ApiType               string `xml:"apiType"`
	ApiVersion            string `xml:"apiVersion"`
	InstanceUuid          string `xml:"instanceUuid,omitempty"`
	LicenseProductName    string `xml:"licenseProductName,omitempty"`
	LicenseProductVersion string `xml:"licenseProductVersion,omitempty"`
}

func init() {
	t["AboutInfo"] = reflect.TypeOf((*AboutInfo)(nil)).Elem()
}

type AccountCreatedEvent struct {
	HostEvent

	Spec  BaseHostAccountSpec `xml:"spec,typeattr"`
	Group bool                `xml:"group"`
}

func init() {
	t["AccountCreatedEvent"] = reflect.TypeOf((*AccountCreatedEvent)(nil)).Elem()
}

type AccountRemovedEvent struct {
	HostEvent

	Account string `xml:"account"`
	Group   bool   `xml:"group"`
}

func init() {
	t["AccountRemovedEvent"] = reflect.TypeOf((*AccountRemovedEvent)(nil)).Elem()
}

type AccountUpdatedEvent struct {
	HostEvent

	Spec  BaseHostAccountSpec `xml:"spec,typeattr"`
	Group bool                `xml:"group"`
}

func init() {
	t["AccountUpdatedEvent"] = reflect.TypeOf((*AccountUpdatedEvent)(nil)).Elem()
}

type AcknowledgeAlarm AcknowledgeAlarmRequestType

func init() {
	t["AcknowledgeAlarm"] = reflect.TypeOf((*AcknowledgeAlarm)(nil)).Elem()
}

type AcknowledgeAlarmRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Alarm  ManagedObjectReference `xml:"alarm"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["AcknowledgeAlarmRequestType"] = reflect.TypeOf((*AcknowledgeAlarmRequestType)(nil)).Elem()
}

type AcknowledgeAlarmResponse struct {
}

type AcquireCimServicesTicket AcquireCimServicesTicketRequestType

func init() {
	t["AcquireCimServicesTicket"] = reflect.TypeOf((*AcquireCimServicesTicket)(nil)).Elem()
}

type AcquireCimServicesTicketRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AcquireCimServicesTicketRequestType"] = reflect.TypeOf((*AcquireCimServicesTicketRequestType)(nil)).Elem()
}

type AcquireCimServicesTicketResponse struct {
	Returnval HostServiceTicket `xml:"returnval"`
}

type AcquireCloneTicket AcquireCloneTicketRequestType

func init() {
	t["AcquireCloneTicket"] = reflect.TypeOf((*AcquireCloneTicket)(nil)).Elem()
}

type AcquireCloneTicketRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AcquireCloneTicketRequestType"] = reflect.TypeOf((*AcquireCloneTicketRequestType)(nil)).Elem()
}

type AcquireCloneTicketResponse struct {
	Returnval string `xml:"returnval"`
}

type AcquireCredentialsInGuest AcquireCredentialsInGuestRequestType

func init() {
	t["AcquireCredentialsInGuest"] = reflect.TypeOf((*AcquireCredentialsInGuest)(nil)).Elem()
}

type AcquireCredentialsInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	RequestedAuth BaseGuestAuthentication `xml:"requestedAuth,typeattr"`
	SessionID     int64                   `xml:"sessionID,omitempty"`
}

func init() {
	t["AcquireCredentialsInGuestRequestType"] = reflect.TypeOf((*AcquireCredentialsInGuestRequestType)(nil)).Elem()
}

type AcquireCredentialsInGuestResponse struct {
	Returnval BaseGuestAuthentication `xml:"returnval,typeattr"`
}

type AcquireGenericServiceTicket AcquireGenericServiceTicketRequestType

func init() {
	t["AcquireGenericServiceTicket"] = reflect.TypeOf((*AcquireGenericServiceTicket)(nil)).Elem()
}

type AcquireGenericServiceTicketRequestType struct {
	This ManagedObjectReference               `xml:"_this"`
	Spec BaseSessionManagerServiceRequestSpec `xml:"spec,typeattr"`
}

func init() {
	t["AcquireGenericServiceTicketRequestType"] = reflect.TypeOf((*AcquireGenericServiceTicketRequestType)(nil)).Elem()
}

type AcquireGenericServiceTicketResponse struct {
	Returnval SessionManagerGenericServiceTicket `xml:"returnval"`
}

type AcquireLocalTicket AcquireLocalTicketRequestType

func init() {
	t["AcquireLocalTicket"] = reflect.TypeOf((*AcquireLocalTicket)(nil)).Elem()
}

type AcquireLocalTicketRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
}

func init() {
	t["AcquireLocalTicketRequestType"] = reflect.TypeOf((*AcquireLocalTicketRequestType)(nil)).Elem()
}

type AcquireLocalTicketResponse struct {
	Returnval SessionManagerLocalTicket `xml:"returnval"`
}

type AcquireMksTicket AcquireMksTicketRequestType

func init() {
	t["AcquireMksTicket"] = reflect.TypeOf((*AcquireMksTicket)(nil)).Elem()
}

type AcquireMksTicketRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AcquireMksTicketRequestType"] = reflect.TypeOf((*AcquireMksTicketRequestType)(nil)).Elem()
}

type AcquireMksTicketResponse struct {
	Returnval VirtualMachineMksTicket `xml:"returnval"`
}

type AcquireTicket AcquireTicketRequestType

func init() {
	t["AcquireTicket"] = reflect.TypeOf((*AcquireTicket)(nil)).Elem()
}

type AcquireTicketRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	TicketType string                 `xml:"ticketType"`
}

func init() {
	t["AcquireTicketRequestType"] = reflect.TypeOf((*AcquireTicketRequestType)(nil)).Elem()
}

type AcquireTicketResponse struct {
	Returnval VirtualMachineTicket `xml:"returnval"`
}

type Action struct {
	DynamicData
}

func init() {
	t["Action"] = reflect.TypeOf((*Action)(nil)).Elem()
}

type ActiveDirectoryFault struct {
	VimFault

	ErrorCode int `xml:"errorCode,omitempty"`
}

func init() {
	t["ActiveDirectoryFault"] = reflect.TypeOf((*ActiveDirectoryFault)(nil)).Elem()
}

type ActiveDirectoryFaultFault BaseActiveDirectoryFault

func init() {
	t["ActiveDirectoryFaultFault"] = reflect.TypeOf((*ActiveDirectoryFaultFault)(nil)).Elem()
}

type ActiveDirectoryProfile struct {
	ApplyProfile
}

func init() {
	t["ActiveDirectoryProfile"] = reflect.TypeOf((*ActiveDirectoryProfile)(nil)).Elem()
}

type AddAuthorizationRole AddAuthorizationRoleRequestType

func init() {
	t["AddAuthorizationRole"] = reflect.TypeOf((*AddAuthorizationRole)(nil)).Elem()
}

type AddAuthorizationRoleRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Name    string                 `xml:"name"`
	PrivIds []string               `xml:"privIds,omitempty"`
}

func init() {
	t["AddAuthorizationRoleRequestType"] = reflect.TypeOf((*AddAuthorizationRoleRequestType)(nil)).Elem()
}

type AddAuthorizationRoleResponse struct {
	Returnval int `xml:"returnval"`
}

type AddCustomFieldDef AddCustomFieldDefRequestType

func init() {
	t["AddCustomFieldDef"] = reflect.TypeOf((*AddCustomFieldDef)(nil)).Elem()
}

type AddCustomFieldDefRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	Name           string                 `xml:"name"`
	MoType         string                 `xml:"moType,omitempty"`
	FieldDefPolicy *PrivilegePolicyDef    `xml:"fieldDefPolicy,omitempty"`
	FieldPolicy    *PrivilegePolicyDef    `xml:"fieldPolicy,omitempty"`
}

func init() {
	t["AddCustomFieldDefRequestType"] = reflect.TypeOf((*AddCustomFieldDefRequestType)(nil)).Elem()
}

type AddCustomFieldDefResponse struct {
	Returnval CustomFieldDef `xml:"returnval"`
}

type AddDVPortgroupRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Spec []DVPortgroupConfigSpec `xml:"spec"`
}

func init() {
	t["AddDVPortgroupRequestType"] = reflect.TypeOf((*AddDVPortgroupRequestType)(nil)).Elem()
}

type AddDVPortgroup_Task AddDVPortgroupRequestType

func init() {
	t["AddDVPortgroup_Task"] = reflect.TypeOf((*AddDVPortgroup_Task)(nil)).Elem()
}

type AddDVPortgroup_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddDisksRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Disk []HostScsiDisk         `xml:"disk"`
}

func init() {
	t["AddDisksRequestType"] = reflect.TypeOf((*AddDisksRequestType)(nil)).Elem()
}

type AddDisks_Task AddDisksRequestType

func init() {
	t["AddDisks_Task"] = reflect.TypeOf((*AddDisks_Task)(nil)).Elem()
}

type AddDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddHostRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Spec         HostConnectSpec         `xml:"spec"`
	AsConnected  bool                    `xml:"asConnected"`
	ResourcePool *ManagedObjectReference `xml:"resourcePool,omitempty"`
	License      string                  `xml:"license,omitempty"`
}

func init() {
	t["AddHostRequestType"] = reflect.TypeOf((*AddHostRequestType)(nil)).Elem()
}

type AddHost_Task AddHostRequestType

func init() {
	t["AddHost_Task"] = reflect.TypeOf((*AddHost_Task)(nil)).Elem()
}

type AddHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddInternetScsiSendTargets AddInternetScsiSendTargetsRequestType

func init() {
	t["AddInternetScsiSendTargets"] = reflect.TypeOf((*AddInternetScsiSendTargets)(nil)).Elem()
}

type AddInternetScsiSendTargetsRequestType struct {
	This           ManagedObjectReference          `xml:"_this"`
	IScsiHbaDevice string                          `xml:"iScsiHbaDevice"`
	Targets        []HostInternetScsiHbaSendTarget `xml:"targets"`
}

func init() {
	t["AddInternetScsiSendTargetsRequestType"] = reflect.TypeOf((*AddInternetScsiSendTargetsRequestType)(nil)).Elem()
}

type AddInternetScsiSendTargetsResponse struct {
}

type AddInternetScsiStaticTargets AddInternetScsiStaticTargetsRequestType

func init() {
	t["AddInternetScsiStaticTargets"] = reflect.TypeOf((*AddInternetScsiStaticTargets)(nil)).Elem()
}

type AddInternetScsiStaticTargetsRequestType struct {
	This           ManagedObjectReference            `xml:"_this"`
	IScsiHbaDevice string                            `xml:"iScsiHbaDevice"`
	Targets        []HostInternetScsiHbaStaticTarget `xml:"targets"`
}

func init() {
	t["AddInternetScsiStaticTargetsRequestType"] = reflect.TypeOf((*AddInternetScsiStaticTargetsRequestType)(nil)).Elem()
}

type AddInternetScsiStaticTargetsResponse struct {
}

type AddLicense AddLicenseRequestType

func init() {
	t["AddLicense"] = reflect.TypeOf((*AddLicense)(nil)).Elem()
}

type AddLicenseRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	LicenseKey string                 `xml:"licenseKey"`
	Labels     []KeyValue             `xml:"labels,omitempty"`
}

func init() {
	t["AddLicenseRequestType"] = reflect.TypeOf((*AddLicenseRequestType)(nil)).Elem()
}

type AddLicenseResponse struct {
	Returnval LicenseManagerLicenseInfo `xml:"returnval"`
}

type AddNetworkResourcePool AddNetworkResourcePoolRequestType

func init() {
	t["AddNetworkResourcePool"] = reflect.TypeOf((*AddNetworkResourcePool)(nil)).Elem()
}

type AddNetworkResourcePoolRequestType struct {
	This       ManagedObjectReference             `xml:"_this"`
	ConfigSpec []DVSNetworkResourcePoolConfigSpec `xml:"configSpec"`
}

func init() {
	t["AddNetworkResourcePoolRequestType"] = reflect.TypeOf((*AddNetworkResourcePoolRequestType)(nil)).Elem()
}

type AddNetworkResourcePoolResponse struct {
}

type AddPortGroup AddPortGroupRequestType

func init() {
	t["AddPortGroup"] = reflect.TypeOf((*AddPortGroup)(nil)).Elem()
}

type AddPortGroupRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Portgrp HostPortGroupSpec      `xml:"portgrp"`
}

func init() {
	t["AddPortGroupRequestType"] = reflect.TypeOf((*AddPortGroupRequestType)(nil)).Elem()
}

type AddPortGroupResponse struct {
}

type AddServiceConsoleVirtualNic AddServiceConsoleVirtualNicRequestType

func init() {
	t["AddServiceConsoleVirtualNic"] = reflect.TypeOf((*AddServiceConsoleVirtualNic)(nil)).Elem()
}

type AddServiceConsoleVirtualNicRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Portgroup string                 `xml:"portgroup"`
	Nic       HostVirtualNicSpec     `xml:"nic"`
}

func init() {
	t["AddServiceConsoleVirtualNicRequestType"] = reflect.TypeOf((*AddServiceConsoleVirtualNicRequestType)(nil)).Elem()
}

type AddServiceConsoleVirtualNicResponse struct {
	Returnval string `xml:"returnval"`
}

type AddStandaloneHostRequestType struct {
	This         ManagedObjectReference        `xml:"_this"`
	Spec         HostConnectSpec               `xml:"spec"`
	CompResSpec  BaseComputeResourceConfigSpec `xml:"compResSpec,omitempty,typeattr"`
	AddConnected bool                          `xml:"addConnected"`
	License      string                        `xml:"license,omitempty"`
}

func init() {
	t["AddStandaloneHostRequestType"] = reflect.TypeOf((*AddStandaloneHostRequestType)(nil)).Elem()
}

type AddStandaloneHost_Task AddStandaloneHostRequestType

func init() {
	t["AddStandaloneHost_Task"] = reflect.TypeOf((*AddStandaloneHost_Task)(nil)).Elem()
}

type AddStandaloneHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddVirtualNic AddVirtualNicRequestType

func init() {
	t["AddVirtualNic"] = reflect.TypeOf((*AddVirtualNic)(nil)).Elem()
}

type AddVirtualNicRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Portgroup string                 `xml:"portgroup"`
	Nic       HostVirtualNicSpec     `xml:"nic"`
}

func init() {
	t["AddVirtualNicRequestType"] = reflect.TypeOf((*AddVirtualNicRequestType)(nil)).Elem()
}

type AddVirtualNicResponse struct {
	Returnval string `xml:"returnval"`
}

type AddVirtualSwitch AddVirtualSwitchRequestType

func init() {
	t["AddVirtualSwitch"] = reflect.TypeOf((*AddVirtualSwitch)(nil)).Elem()
}

type AddVirtualSwitchRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	VswitchName string                 `xml:"vswitchName"`
	Spec        *HostVirtualSwitchSpec `xml:"spec,omitempty"`
}

func init() {
	t["AddVirtualSwitchRequestType"] = reflect.TypeOf((*AddVirtualSwitchRequestType)(nil)).Elem()
}

type AddVirtualSwitchResponse struct {
}

type AdminDisabled struct {
	HostConfigFault
}

func init() {
	t["AdminDisabled"] = reflect.TypeOf((*AdminDisabled)(nil)).Elem()
}

type AdminDisabledFault AdminDisabled

func init() {
	t["AdminDisabledFault"] = reflect.TypeOf((*AdminDisabledFault)(nil)).Elem()
}

type AdminNotDisabled struct {
	HostConfigFault
}

func init() {
	t["AdminNotDisabled"] = reflect.TypeOf((*AdminNotDisabled)(nil)).Elem()
}

type AdminNotDisabledFault AdminNotDisabled

func init() {
	t["AdminNotDisabledFault"] = reflect.TypeOf((*AdminNotDisabledFault)(nil)).Elem()
}

type AdminPasswordNotChangedEvent struct {
	HostEvent
}

func init() {
	t["AdminPasswordNotChangedEvent"] = reflect.TypeOf((*AdminPasswordNotChangedEvent)(nil)).Elem()
}

type AffinityConfigured struct {
	MigrationFault

	ConfiguredAffinity []string `xml:"configuredAffinity"`
}

func init() {
	t["AffinityConfigured"] = reflect.TypeOf((*AffinityConfigured)(nil)).Elem()
}

type AffinityConfiguredFault AffinityConfigured

func init() {
	t["AffinityConfiguredFault"] = reflect.TypeOf((*AffinityConfiguredFault)(nil)).Elem()
}

type AfterStartupTaskScheduler struct {
	TaskScheduler

	Minute int `xml:"minute"`
}

func init() {
	t["AfterStartupTaskScheduler"] = reflect.TypeOf((*AfterStartupTaskScheduler)(nil)).Elem()
}

type AgentInstallFailed struct {
	HostConnectFault

	Reason          string `xml:"reason,omitempty"`
	StatusCode      int    `xml:"statusCode,omitempty"`
	InstallerOutput string `xml:"installerOutput,omitempty"`
}

func init() {
	t["AgentInstallFailed"] = reflect.TypeOf((*AgentInstallFailed)(nil)).Elem()
}

type AgentInstallFailedFault AgentInstallFailed

func init() {
	t["AgentInstallFailedFault"] = reflect.TypeOf((*AgentInstallFailedFault)(nil)).Elem()
}

type AlarmAcknowledgedEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmAcknowledgedEvent"] = reflect.TypeOf((*AlarmAcknowledgedEvent)(nil)).Elem()
}

type AlarmAction struct {
	DynamicData
}

func init() {
	t["AlarmAction"] = reflect.TypeOf((*AlarmAction)(nil)).Elem()
}

type AlarmActionTriggeredEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmActionTriggeredEvent"] = reflect.TypeOf((*AlarmActionTriggeredEvent)(nil)).Elem()
}

type AlarmClearedEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
	From   string                     `xml:"from"`
}

func init() {
	t["AlarmClearedEvent"] = reflect.TypeOf((*AlarmClearedEvent)(nil)).Elem()
}

type AlarmCreatedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmCreatedEvent"] = reflect.TypeOf((*AlarmCreatedEvent)(nil)).Elem()
}

type AlarmDescription struct {
	DynamicData

	Expr                               []BaseTypeDescription    `xml:"expr,typeattr"`
	StateOperator                      []BaseElementDescription `xml:"stateOperator,typeattr"`
	MetricOperator                     []BaseElementDescription `xml:"metricOperator,typeattr"`
	HostSystemConnectionState          []BaseElementDescription `xml:"hostSystemConnectionState,typeattr"`
	VirtualMachinePowerState           []BaseElementDescription `xml:"virtualMachinePowerState,typeattr"`
	DatastoreConnectionState           []BaseElementDescription `xml:"datastoreConnectionState,omitempty,typeattr"`
	HostSystemPowerState               []BaseElementDescription `xml:"hostSystemPowerState,omitempty,typeattr"`
	VirtualMachineGuestHeartbeatStatus []BaseElementDescription `xml:"virtualMachineGuestHeartbeatStatus,omitempty,typeattr"`
	EntityStatus                       []BaseElementDescription `xml:"entityStatus,typeattr"`
	Action                             []BaseTypeDescription    `xml:"action,typeattr"`
}

func init() {
	t["AlarmDescription"] = reflect.TypeOf((*AlarmDescription)(nil)).Elem()
}

type AlarmEmailCompletedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	To     string                     `xml:"to"`
}

func init() {
	t["AlarmEmailCompletedEvent"] = reflect.TypeOf((*AlarmEmailCompletedEvent)(nil)).Elem()
}

type AlarmEmailFailedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	To     string                     `xml:"to"`
	Reason LocalizedMethodFault       `xml:"reason"`
}

func init() {
	t["AlarmEmailFailedEvent"] = reflect.TypeOf((*AlarmEmailFailedEvent)(nil)).Elem()
}

type AlarmEvent struct {
	Event

	Alarm AlarmEventArgument `xml:"alarm"`
}

func init() {
	t["AlarmEvent"] = reflect.TypeOf((*AlarmEvent)(nil)).Elem()
}

type AlarmEventArgument struct {
	EntityEventArgument

	Alarm ManagedObjectReference `xml:"alarm"`
}

func init() {
	t["AlarmEventArgument"] = reflect.TypeOf((*AlarmEventArgument)(nil)).Elem()
}

type AlarmExpression struct {
	DynamicData
}

func init() {
	t["AlarmExpression"] = reflect.TypeOf((*AlarmExpression)(nil)).Elem()
}

type AlarmInfo struct {
	AlarmSpec

	Key              string                 `xml:"key"`
	Alarm            ManagedObjectReference `xml:"alarm"`
	Entity           ManagedObjectReference `xml:"entity"`
	LastModifiedTime time.Time              `xml:"lastModifiedTime"`
	LastModifiedUser string                 `xml:"lastModifiedUser"`
	CreationEventId  int                    `xml:"creationEventId"`
}

func init() {
	t["AlarmInfo"] = reflect.TypeOf((*AlarmInfo)(nil)).Elem()
}

type AlarmReconfiguredEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmReconfiguredEvent"] = reflect.TypeOf((*AlarmReconfiguredEvent)(nil)).Elem()
}

type AlarmRemovedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmRemovedEvent"] = reflect.TypeOf((*AlarmRemovedEvent)(nil)).Elem()
}

type AlarmScriptCompleteEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	Script string                     `xml:"script"`
}

func init() {
	t["AlarmScriptCompleteEvent"] = reflect.TypeOf((*AlarmScriptCompleteEvent)(nil)).Elem()
}

type AlarmScriptFailedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	Script string                     `xml:"script"`
	Reason LocalizedMethodFault       `xml:"reason"`
}

func init() {
	t["AlarmScriptFailedEvent"] = reflect.TypeOf((*AlarmScriptFailedEvent)(nil)).Elem()
}

type AlarmSetting struct {
	DynamicData

	ToleranceRange     int `xml:"toleranceRange"`
	ReportingFrequency int `xml:"reportingFrequency"`
}

func init() {
	t["AlarmSetting"] = reflect.TypeOf((*AlarmSetting)(nil)).Elem()
}

type AlarmSnmpCompletedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmSnmpCompletedEvent"] = reflect.TypeOf((*AlarmSnmpCompletedEvent)(nil)).Elem()
}

type AlarmSnmpFailedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	Reason LocalizedMethodFault       `xml:"reason"`
}

func init() {
	t["AlarmSnmpFailedEvent"] = reflect.TypeOf((*AlarmSnmpFailedEvent)(nil)).Elem()
}

type AlarmSpec struct {
	DynamicData

	Name            string              `xml:"name"`
	SystemName      string              `xml:"systemName,omitempty"`
	Description     string              `xml:"description"`
	Enabled         bool                `xml:"enabled"`
	Expression      BaseAlarmExpression `xml:"expression,typeattr"`
	Action          BaseAlarmAction     `xml:"action,omitempty,typeattr"`
	ActionFrequency int                 `xml:"actionFrequency,omitempty"`
	Setting         *AlarmSetting       `xml:"setting,omitempty"`
}

func init() {
	t["AlarmSpec"] = reflect.TypeOf((*AlarmSpec)(nil)).Elem()
}

type AlarmState struct {
	DynamicData

	Key                string                 `xml:"key"`
	Entity             ManagedObjectReference `xml:"entity"`
	Alarm              ManagedObjectReference `xml:"alarm"`
	OverallStatus      ManagedEntityStatus    `xml:"overallStatus"`
	Time               time.Time              `xml:"time"`
	Acknowledged       *bool                  `xml:"acknowledged"`
	AcknowledgedByUser string                 `xml:"acknowledgedByUser,omitempty"`
	AcknowledgedTime   *time.Time             `xml:"acknowledgedTime"`
}

func init() {
	t["AlarmState"] = reflect.TypeOf((*AlarmState)(nil)).Elem()
}

type AlarmStatusChangedEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
	From   string                     `xml:"from"`
	To     string                     `xml:"to"`
}

func init() {
	t["AlarmStatusChangedEvent"] = reflect.TypeOf((*AlarmStatusChangedEvent)(nil)).Elem()
}

type AlarmTriggeringAction struct {
	AlarmAction

	Action          BaseAction                            `xml:"action,typeattr"`
	TransitionSpecs []AlarmTriggeringActionTransitionSpec `xml:"transitionSpecs,omitempty"`
	Green2yellow    bool                                  `xml:"green2yellow"`
	Yellow2red      bool                                  `xml:"yellow2red"`
	Red2yellow      bool                                  `xml:"red2yellow"`
	Yellow2green    bool                                  `xml:"yellow2green"`
}

func init() {
	t["AlarmTriggeringAction"] = reflect.TypeOf((*AlarmTriggeringAction)(nil)).Elem()
}

type AlarmTriggeringActionTransitionSpec struct {
	DynamicData

	StartState ManagedEntityStatus `xml:"startState"`
	FinalState ManagedEntityStatus `xml:"finalState"`
	Repeats    bool                `xml:"repeats"`
}

func init() {
	t["AlarmTriggeringActionTransitionSpec"] = reflect.TypeOf((*AlarmTriggeringActionTransitionSpec)(nil)).Elem()
}

type AllVirtualMachinesLicensedEvent struct {
	LicenseEvent
}

func init() {
	t["AllVirtualMachinesLicensedEvent"] = reflect.TypeOf((*AllVirtualMachinesLicensedEvent)(nil)).Elem()
}

type AllocateIpv4Address AllocateIpv4AddressRequestType

func init() {
	t["AllocateIpv4Address"] = reflect.TypeOf((*AllocateIpv4Address)(nil)).Elem()
}

type AllocateIpv4AddressRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Dc           ManagedObjectReference `xml:"dc"`
	PoolId       int                    `xml:"poolId"`
	AllocationId string                 `xml:"allocationId"`
}

func init() {
	t["AllocateIpv4AddressRequestType"] = reflect.TypeOf((*AllocateIpv4AddressRequestType)(nil)).Elem()
}

type AllocateIpv4AddressResponse struct {
	Returnval string `xml:"returnval"`
}

type AllocateIpv6Address AllocateIpv6AddressRequestType

func init() {
	t["AllocateIpv6Address"] = reflect.TypeOf((*AllocateIpv6Address)(nil)).Elem()
}

type AllocateIpv6AddressRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Dc           ManagedObjectReference `xml:"dc"`
	PoolId       int                    `xml:"poolId"`
	AllocationId string                 `xml:"allocationId"`
}

func init() {
	t["AllocateIpv6AddressRequestType"] = reflect.TypeOf((*AllocateIpv6AddressRequestType)(nil)).Elem()
}

type AllocateIpv6AddressResponse struct {
	Returnval string `xml:"returnval"`
}

type AlreadyAuthenticatedSessionEvent struct {
	SessionEvent
}

func init() {
	t["AlreadyAuthenticatedSessionEvent"] = reflect.TypeOf((*AlreadyAuthenticatedSessionEvent)(nil)).Elem()
}

type AlreadyBeingManaged struct {
	HostConnectFault

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["AlreadyBeingManaged"] = reflect.TypeOf((*AlreadyBeingManaged)(nil)).Elem()
}

type AlreadyBeingManagedFault AlreadyBeingManaged

func init() {
	t["AlreadyBeingManagedFault"] = reflect.TypeOf((*AlreadyBeingManagedFault)(nil)).Elem()
}

type AlreadyConnected struct {
	HostConnectFault

	Name string `xml:"name"`
}

func init() {
	t["AlreadyConnected"] = reflect.TypeOf((*AlreadyConnected)(nil)).Elem()
}

type AlreadyConnectedFault AlreadyConnected

func init() {
	t["AlreadyConnectedFault"] = reflect.TypeOf((*AlreadyConnectedFault)(nil)).Elem()
}

type AlreadyExists struct {
	VimFault

	Name string `xml:"name,omitempty"`
}

func init() {
	t["AlreadyExists"] = reflect.TypeOf((*AlreadyExists)(nil)).Elem()
}

type AlreadyExistsFault AlreadyExists

func init() {
	t["AlreadyExistsFault"] = reflect.TypeOf((*AlreadyExistsFault)(nil)).Elem()
}

type AlreadyUpgraded struct {
	VimFault
}

func init() {
	t["AlreadyUpgraded"] = reflect.TypeOf((*AlreadyUpgraded)(nil)).Elem()
}

type AlreadyUpgradedFault AlreadyUpgraded

func init() {
	t["AlreadyUpgradedFault"] = reflect.TypeOf((*AlreadyUpgradedFault)(nil)).Elem()
}

type AndAlarmExpression struct {
	AlarmExpression

	Expression []BaseAlarmExpression `xml:"expression,typeattr"`
}

func init() {
	t["AndAlarmExpression"] = reflect.TypeOf((*AndAlarmExpression)(nil)).Elem()
}

type AnswerFile struct {
	DynamicData

	UserInput    []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty"`
	CreatedTime  time.Time                              `xml:"createdTime"`
	ModifiedTime time.Time                              `xml:"modifiedTime"`
}

func init() {
	t["AnswerFile"] = reflect.TypeOf((*AnswerFile)(nil)).Elem()
}

type AnswerFileCreateSpec struct {
	DynamicData
}

func init() {
	t["AnswerFileCreateSpec"] = reflect.TypeOf((*AnswerFileCreateSpec)(nil)).Elem()
}

type AnswerFileOptionsCreateSpec struct {
	AnswerFileCreateSpec

	UserInput []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty"`
}

func init() {
	t["AnswerFileOptionsCreateSpec"] = reflect.TypeOf((*AnswerFileOptionsCreateSpec)(nil)).Elem()
}

type AnswerFileSerializedCreateSpec struct {
	AnswerFileCreateSpec

	AnswerFileConfigString string `xml:"answerFileConfigString"`
}

func init() {
	t["AnswerFileSerializedCreateSpec"] = reflect.TypeOf((*AnswerFileSerializedCreateSpec)(nil)).Elem()
}

type AnswerFileStatusError struct {
	DynamicData

	UserInputPath ProfilePropertyPath `xml:"userInputPath"`
	ErrMsg        LocalizableMessage  `xml:"errMsg"`
}

func init() {
	t["AnswerFileStatusError"] = reflect.TypeOf((*AnswerFileStatusError)(nil)).Elem()
}

type AnswerFileStatusResult struct {
	DynamicData

	CheckedTime time.Time               `xml:"checkedTime"`
	Host        ManagedObjectReference  `xml:"host"`
	Status      string                  `xml:"status"`
	Error       []AnswerFileStatusError `xml:"error,omitempty"`
}

func init() {
	t["AnswerFileStatusResult"] = reflect.TypeOf((*AnswerFileStatusResult)(nil)).Elem()
}

type AnswerFileUpdateFailed struct {
	VimFault

	Failure []AnswerFileUpdateFailure `xml:"failure"`
}

func init() {
	t["AnswerFileUpdateFailed"] = reflect.TypeOf((*AnswerFileUpdateFailed)(nil)).Elem()
}

type AnswerFileUpdateFailedFault AnswerFileUpdateFailed

func init() {
	t["AnswerFileUpdateFailedFault"] = reflect.TypeOf((*AnswerFileUpdateFailedFault)(nil)).Elem()
}

type AnswerFileUpdateFailure struct {
	DynamicData

	UserInputPath ProfilePropertyPath `xml:"userInputPath"`
	ErrMsg        LocalizableMessage  `xml:"errMsg"`
}

func init() {
	t["AnswerFileUpdateFailure"] = reflect.TypeOf((*AnswerFileUpdateFailure)(nil)).Elem()
}

type AnswerVM AnswerVMRequestType

func init() {
	t["AnswerVM"] = reflect.TypeOf((*AnswerVM)(nil)).Elem()
}

type AnswerVMRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	QuestionId   string                 `xml:"questionId"`
	AnswerChoice string                 `xml:"answerChoice"`
}

func init() {
	t["AnswerVMRequestType"] = reflect.TypeOf((*AnswerVMRequestType)(nil)).Elem()
}

type AnswerVMResponse struct {
}

type ApplicationQuiesceFault struct {
	SnapshotFault
}

func init() {
	t["ApplicationQuiesceFault"] = reflect.TypeOf((*ApplicationQuiesceFault)(nil)).Elem()
}

type ApplicationQuiesceFaultFault ApplicationQuiesceFault

func init() {
	t["ApplicationQuiesceFaultFault"] = reflect.TypeOf((*ApplicationQuiesceFaultFault)(nil)).Elem()
}

type ApplyHostConfigRequestType struct {
	This       ManagedObjectReference                 `xml:"_this"`
	Host       ManagedObjectReference                 `xml:"host"`
	ConfigSpec HostConfigSpec                         `xml:"configSpec"`
	UserInput  []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty"`
}

func init() {
	t["ApplyHostConfigRequestType"] = reflect.TypeOf((*ApplyHostConfigRequestType)(nil)).Elem()
}

type ApplyHostConfig_Task ApplyHostConfigRequestType

func init() {
	t["ApplyHostConfig_Task"] = reflect.TypeOf((*ApplyHostConfig_Task)(nil)).Elem()
}

type ApplyHostConfig_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyProfile struct {
	DynamicData

	Enabled         bool                          `xml:"enabled"`
	Policy          []ProfilePolicy               `xml:"policy,omitempty"`
	ProfileTypeName string                        `xml:"profileTypeName,omitempty"`
	ProfileVersion  string                        `xml:"profileVersion,omitempty"`
	Property        []ProfileApplyProfileProperty `xml:"property,omitempty"`
}

func init() {
	t["ApplyProfile"] = reflect.TypeOf((*ApplyProfile)(nil)).Elem()
}

type ApplyRecommendation ApplyRecommendationRequestType

func init() {
	t["ApplyRecommendation"] = reflect.TypeOf((*ApplyRecommendation)(nil)).Elem()
}

type ApplyRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  string                 `xml:"key"`
}

func init() {
	t["ApplyRecommendationRequestType"] = reflect.TypeOf((*ApplyRecommendationRequestType)(nil)).Elem()
}

type ApplyRecommendationResponse struct {
}

type ApplyStorageDrsRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  []string               `xml:"key"`
}

func init() {
	t["ApplyStorageDrsRecommendationRequestType"] = reflect.TypeOf((*ApplyStorageDrsRecommendationRequestType)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPodRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Pod  ManagedObjectReference `xml:"pod"`
	Key  string                 `xml:"key"`
}

func init() {
	t["ApplyStorageDrsRecommendationToPodRequestType"] = reflect.TypeOf((*ApplyStorageDrsRecommendationToPodRequestType)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPod_Task ApplyStorageDrsRecommendationToPodRequestType

func init() {
	t["ApplyStorageDrsRecommendationToPod_Task"] = reflect.TypeOf((*ApplyStorageDrsRecommendationToPod_Task)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPod_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyStorageDrsRecommendation_Task ApplyStorageDrsRecommendationRequestType

func init() {
	t["ApplyStorageDrsRecommendation_Task"] = reflect.TypeOf((*ApplyStorageDrsRecommendation_Task)(nil)).Elem()
}

type ApplyStorageDrsRecommendation_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyStorageRecommendationResult struct {
	DynamicData

	Vm *ManagedObjectReference `xml:"vm,omitempty"`
}

func init() {
	t["ApplyStorageRecommendationResult"] = reflect.TypeOf((*ApplyStorageRecommendationResult)(nil)).Elem()
}

type AreAlarmActionsEnabled AreAlarmActionsEnabledRequestType

func init() {
	t["AreAlarmActionsEnabled"] = reflect.TypeOf((*AreAlarmActionsEnabled)(nil)).Elem()
}

type AreAlarmActionsEnabledRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["AreAlarmActionsEnabledRequestType"] = reflect.TypeOf((*AreAlarmActionsEnabledRequestType)(nil)).Elem()
}

type AreAlarmActionsEnabledResponse struct {
	Returnval bool `xml:"returnval"`
}

type ArrayOfAlarmAction struct {
	AlarmAction []BaseAlarmAction `xml:"AlarmAction,omitempty,typeattr"`
}

func init() {
	t["ArrayOfAlarmAction"] = reflect.TypeOf((*ArrayOfAlarmAction)(nil)).Elem()
}

type ArrayOfAlarmExpression struct {
	AlarmExpression []BaseAlarmExpression `xml:"AlarmExpression,omitempty,typeattr"`
}

func init() {
	t["ArrayOfAlarmExpression"] = reflect.TypeOf((*ArrayOfAlarmExpression)(nil)).Elem()
}

type ArrayOfAlarmState struct {
	AlarmState []AlarmState `xml:"AlarmState,omitempty"`
}

func init() {
	t["ArrayOfAlarmState"] = reflect.TypeOf((*ArrayOfAlarmState)(nil)).Elem()
}

type ArrayOfAlarmTriggeringActionTransitionSpec struct {
	AlarmTriggeringActionTransitionSpec []AlarmTriggeringActionTransitionSpec `xml:"AlarmTriggeringActionTransitionSpec,omitempty"`
}

func init() {
	t["ArrayOfAlarmTriggeringActionTransitionSpec"] = reflect.TypeOf((*ArrayOfAlarmTriggeringActionTransitionSpec)(nil)).Elem()
}

type ArrayOfAnswerFileStatusError struct {
	AnswerFileStatusError []AnswerFileStatusError `xml:"AnswerFileStatusError,omitempty"`
}

func init() {
	t["ArrayOfAnswerFileStatusError"] = reflect.TypeOf((*ArrayOfAnswerFileStatusError)(nil)).Elem()
}

type ArrayOfAnswerFileStatusResult struct {
	AnswerFileStatusResult []AnswerFileStatusResult `xml:"AnswerFileStatusResult,omitempty"`
}

func init() {
	t["ArrayOfAnswerFileStatusResult"] = reflect.TypeOf((*ArrayOfAnswerFileStatusResult)(nil)).Elem()
}

type ArrayOfAnswerFileUpdateFailure struct {
	AnswerFileUpdateFailure []AnswerFileUpdateFailure `xml:"AnswerFileUpdateFailure,omitempty"`
}

func init() {
	t["ArrayOfAnswerFileUpdateFailure"] = reflect.TypeOf((*ArrayOfAnswerFileUpdateFailure)(nil)).Elem()
}

type ArrayOfAnyType struct {
	AnyType []AnyType `xml:"anyType,omitempty,typeattr"`
}

func init() {
	t["ArrayOfAnyType"] = reflect.TypeOf((*ArrayOfAnyType)(nil)).Elem()
}

type ArrayOfApplyProfile struct {
	ApplyProfile []BaseApplyProfile `xml:"ApplyProfile,omitempty,typeattr"`
}

func init() {
	t["ArrayOfApplyProfile"] = reflect.TypeOf((*ArrayOfApplyProfile)(nil)).Elem()
}

type ArrayOfAuthorizationPrivilege struct {
	AuthorizationPrivilege []AuthorizationPrivilege `xml:"AuthorizationPrivilege,omitempty"`
}

func init() {
	t["ArrayOfAuthorizationPrivilege"] = reflect.TypeOf((*ArrayOfAuthorizationPrivilege)(nil)).Elem()
}

type ArrayOfAuthorizationRole struct {
	AuthorizationRole []AuthorizationRole `xml:"AuthorizationRole,omitempty"`
}

func init() {
	t["ArrayOfAuthorizationRole"] = reflect.TypeOf((*ArrayOfAuthorizationRole)(nil)).Elem()
}

type ArrayOfAutoStartPowerInfo struct {
	AutoStartPowerInfo []AutoStartPowerInfo `xml:"AutoStartPowerInfo,omitempty"`
}

func init() {
	t["ArrayOfAutoStartPowerInfo"] = reflect.TypeOf((*ArrayOfAutoStartPowerInfo)(nil)).Elem()
}

type ArrayOfBoolean struct {
	Boolean []bool `xml:"boolean,omitempty"`
}

func init() {
	t["ArrayOfBoolean"] = reflect.TypeOf((*ArrayOfBoolean)(nil)).Elem()
}

type ArrayOfByte struct {
	Byte []byte `xml:"byte,omitempty"`
}

func init() {
	t["ArrayOfByte"] = reflect.TypeOf((*ArrayOfByte)(nil)).Elem()
}

type ArrayOfCheckResult struct {
	CheckResult []CheckResult `xml:"CheckResult,omitempty"`
}

func init() {
	t["ArrayOfCheckResult"] = reflect.TypeOf((*ArrayOfCheckResult)(nil)).Elem()
}

type ArrayOfClusterAction struct {
	ClusterAction []BaseClusterAction `xml:"ClusterAction,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterAction"] = reflect.TypeOf((*ArrayOfClusterAction)(nil)).Elem()
}

type ArrayOfClusterActionHistory struct {
	ClusterActionHistory []ClusterActionHistory `xml:"ClusterActionHistory,omitempty"`
}

func init() {
	t["ArrayOfClusterActionHistory"] = reflect.TypeOf((*ArrayOfClusterActionHistory)(nil)).Elem()
}

type ArrayOfClusterAttemptedVmInfo struct {
	ClusterAttemptedVmInfo []ClusterAttemptedVmInfo `xml:"ClusterAttemptedVmInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterAttemptedVmInfo"] = reflect.TypeOf((*ArrayOfClusterAttemptedVmInfo)(nil)).Elem()
}

type ArrayOfClusterDasAamNodeState struct {
	ClusterDasAamNodeState []ClusterDasAamNodeState `xml:"ClusterDasAamNodeState,omitempty"`
}

func init() {
	t["ArrayOfClusterDasAamNodeState"] = reflect.TypeOf((*ArrayOfClusterDasAamNodeState)(nil)).Elem()
}

type ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots struct {
	ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots `xml:"ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots,omitempty"`
}

func init() {
	t["ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots"] = reflect.TypeOf((*ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots)(nil)).Elem()
}

type ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots struct {
	ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots `xml:"ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots,omitempty"`
}

func init() {
	t["ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots"] = reflect.TypeOf((*ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots)(nil)).Elem()
}

type ArrayOfClusterDasVmConfigInfo struct {
	ClusterDasVmConfigInfo []ClusterDasVmConfigInfo `xml:"ClusterDasVmConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterDasVmConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDasVmConfigInfo)(nil)).Elem()
}

type ArrayOfClusterDasVmConfigSpec struct {
	ClusterDasVmConfigSpec []ClusterDasVmConfigSpec `xml:"ClusterDasVmConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterDasVmConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDasVmConfigSpec)(nil)).Elem()
}

type ArrayOfClusterDpmHostConfigInfo struct {
	ClusterDpmHostConfigInfo []ClusterDpmHostConfigInfo `xml:"ClusterDpmHostConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterDpmHostConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDpmHostConfigInfo)(nil)).Elem()
}

type ArrayOfClusterDpmHostConfigSpec struct {
	ClusterDpmHostConfigSpec []ClusterDpmHostConfigSpec `xml:"ClusterDpmHostConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterDpmHostConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDpmHostConfigSpec)(nil)).Elem()
}

type ArrayOfClusterDrsFaults struct {
	ClusterDrsFaults []ClusterDrsFaults `xml:"ClusterDrsFaults,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsFaults"] = reflect.TypeOf((*ArrayOfClusterDrsFaults)(nil)).Elem()
}

type ArrayOfClusterDrsFaultsFaultsByVm struct {
	ClusterDrsFaultsFaultsByVm []BaseClusterDrsFaultsFaultsByVm `xml:"ClusterDrsFaultsFaultsByVm,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterDrsFaultsFaultsByVm"] = reflect.TypeOf((*ArrayOfClusterDrsFaultsFaultsByVm)(nil)).Elem()
}

type ArrayOfClusterDrsMigration struct {
	ClusterDrsMigration []ClusterDrsMigration `xml:"ClusterDrsMigration,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsMigration"] = reflect.TypeOf((*ArrayOfClusterDrsMigration)(nil)).Elem()
}

type ArrayOfClusterDrsRecommendation struct {
	ClusterDrsRecommendation []ClusterDrsRecommendation `xml:"ClusterDrsRecommendation,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsRecommendation"] = reflect.TypeOf((*ArrayOfClusterDrsRecommendation)(nil)).Elem()
}

type ArrayOfClusterDrsVmConfigInfo struct {
	ClusterDrsVmConfigInfo []ClusterDrsVmConfigInfo `xml:"ClusterDrsVmConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsVmConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDrsVmConfigInfo)(nil)).Elem()
}

type ArrayOfClusterDrsVmConfigSpec struct {
	ClusterDrsVmConfigSpec []ClusterDrsVmConfigSpec `xml:"ClusterDrsVmConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsVmConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDrsVmConfigSpec)(nil)).Elem()
}

type ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus struct {
	ClusterFailoverHostAdmissionControlInfoHostStatus []ClusterFailoverHostAdmissionControlInfoHostStatus `xml:"ClusterFailoverHostAdmissionControlInfoHostStatus,omitempty"`
}

func init() {
	t["ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus"] = reflect.TypeOf((*ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus)(nil)).Elem()
}

type ArrayOfClusterGroupInfo struct {
	ClusterGroupInfo []BaseClusterGroupInfo `xml:"ClusterGroupInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterGroupInfo"] = reflect.TypeOf((*ArrayOfClusterGroupInfo)(nil)).Elem()
}

type ArrayOfClusterGroupSpec struct {
	ClusterGroupSpec []ClusterGroupSpec `xml:"ClusterGroupSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterGroupSpec"] = reflect.TypeOf((*ArrayOfClusterGroupSpec)(nil)).Elem()
}

type ArrayOfClusterHostRecommendation struct {
	ClusterHostRecommendation []ClusterHostRecommendation `xml:"ClusterHostRecommendation,omitempty"`
}

func init() {
	t["ArrayOfClusterHostRecommendation"] = reflect.TypeOf((*ArrayOfClusterHostRecommendation)(nil)).Elem()
}

type ArrayOfClusterNotAttemptedVmInfo struct {
	ClusterNotAttemptedVmInfo []ClusterNotAttemptedVmInfo `xml:"ClusterNotAttemptedVmInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterNotAttemptedVmInfo"] = reflect.TypeOf((*ArrayOfClusterNotAttemptedVmInfo)(nil)).Elem()
}

type ArrayOfClusterRecommendation struct {
	ClusterRecommendation []ClusterRecommendation `xml:"ClusterRecommendation,omitempty"`
}

func init() {
	t["ArrayOfClusterRecommendation"] = reflect.TypeOf((*ArrayOfClusterRecommendation)(nil)).Elem()
}

type ArrayOfClusterRuleInfo struct {
	ClusterRuleInfo []BaseClusterRuleInfo `xml:"ClusterRuleInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterRuleInfo"] = reflect.TypeOf((*ArrayOfClusterRuleInfo)(nil)).Elem()
}

type ArrayOfClusterRuleSpec struct {
	ClusterRuleSpec []ClusterRuleSpec `xml:"ClusterRuleSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterRuleSpec"] = reflect.TypeOf((*ArrayOfClusterRuleSpec)(nil)).Elem()
}

type ArrayOfComplianceFailure struct {
	ComplianceFailure []ComplianceFailure `xml:"ComplianceFailure,omitempty"`
}

func init() {
	t["ArrayOfComplianceFailure"] = reflect.TypeOf((*ArrayOfComplianceFailure)(nil)).Elem()
}

type ArrayOfComplianceLocator struct {
	ComplianceLocator []ComplianceLocator `xml:"ComplianceLocator,omitempty"`
}

func init() {
	t["ArrayOfComplianceLocator"] = reflect.TypeOf((*ArrayOfComplianceLocator)(nil)).Elem()
}

type ArrayOfComplianceResult struct {
	ComplianceResult []ComplianceResult `xml:"ComplianceResult,omitempty"`
}

func init() {
	t["ArrayOfComplianceResult"] = reflect.TypeOf((*ArrayOfComplianceResult)(nil)).Elem()
}

type ArrayOfComputeResourceHostSPBMLicenseInfo struct {
	ComputeResourceHostSPBMLicenseInfo []ComputeResourceHostSPBMLicenseInfo `xml:"ComputeResourceHostSPBMLicenseInfo,omitempty"`
}

func init() {
	t["ArrayOfComputeResourceHostSPBMLicenseInfo"] = reflect.TypeOf((*ArrayOfComputeResourceHostSPBMLicenseInfo)(nil)).Elem()
}

type ArrayOfConflictingConfigurationConfig struct {
	ConflictingConfigurationConfig []ConflictingConfigurationConfig `xml:"ConflictingConfigurationConfig,omitempty"`
}

func init() {
	t["ArrayOfConflictingConfigurationConfig"] = reflect.TypeOf((*ArrayOfConflictingConfigurationConfig)(nil)).Elem()
}

type ArrayOfCustomFieldDef struct {
	CustomFieldDef []CustomFieldDef `xml:"CustomFieldDef,omitempty"`
}

func init() {
	t["ArrayOfCustomFieldDef"] = reflect.TypeOf((*ArrayOfCustomFieldDef)(nil)).Elem()
}

type ArrayOfCustomFieldValue struct {
	CustomFieldValue []BaseCustomFieldValue `xml:"CustomFieldValue,omitempty,typeattr"`
}

func init() {
	t["ArrayOfCustomFieldValue"] = reflect.TypeOf((*ArrayOfCustomFieldValue)(nil)).Elem()
}

type ArrayOfCustomizationAdapterMapping struct {
	CustomizationAdapterMapping []CustomizationAdapterMapping `xml:"CustomizationAdapterMapping,omitempty"`
}

func init() {
	t["ArrayOfCustomizationAdapterMapping"] = reflect.TypeOf((*ArrayOfCustomizationAdapterMapping)(nil)).Elem()
}

type ArrayOfCustomizationIpV6Generator struct {
	CustomizationIpV6Generator []BaseCustomizationIpV6Generator `xml:"CustomizationIpV6Generator,omitempty,typeattr"`
}

func init() {
	t["ArrayOfCustomizationIpV6Generator"] = reflect.TypeOf((*ArrayOfCustomizationIpV6Generator)(nil)).Elem()
}

type ArrayOfCustomizationSpecInfo struct {
	CustomizationSpecInfo []CustomizationSpecInfo `xml:"CustomizationSpecInfo,omitempty"`
}

func init() {
	t["ArrayOfCustomizationSpecInfo"] = reflect.TypeOf((*ArrayOfCustomizationSpecInfo)(nil)).Elem()
}

type ArrayOfDVPortConfigSpec struct {
	DVPortConfigSpec []DVPortConfigSpec `xml:"DVPortConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDVPortConfigSpec"] = reflect.TypeOf((*ArrayOfDVPortConfigSpec)(nil)).Elem()
}

type ArrayOfDVPortgroupConfigSpec struct {
	DVPortgroupConfigSpec []DVPortgroupConfigSpec `xml:"DVPortgroupConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDVPortgroupConfigSpec"] = reflect.TypeOf((*ArrayOfDVPortgroupConfigSpec)(nil)).Elem()
}

type ArrayOfDVSHealthCheckConfig struct {
	DVSHealthCheckConfig []BaseDVSHealthCheckConfig `xml:"DVSHealthCheckConfig,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDVSHealthCheckConfig"] = reflect.TypeOf((*ArrayOfDVSHealthCheckConfig)(nil)).Elem()
}

type ArrayOfDVSNetworkResourcePool struct {
	DVSNetworkResourcePool []DVSNetworkResourcePool `xml:"DVSNetworkResourcePool,omitempty"`
}

func init() {
	t["ArrayOfDVSNetworkResourcePool"] = reflect.TypeOf((*ArrayOfDVSNetworkResourcePool)(nil)).Elem()
}

type ArrayOfDVSNetworkResourcePoolConfigSpec struct {
	DVSNetworkResourcePoolConfigSpec []DVSNetworkResourcePoolConfigSpec `xml:"DVSNetworkResourcePoolConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDVSNetworkResourcePoolConfigSpec"] = reflect.TypeOf((*ArrayOfDVSNetworkResourcePoolConfigSpec)(nil)).Elem()
}

type ArrayOfDasHeartbeatDatastoreInfo struct {
	DasHeartbeatDatastoreInfo []DasHeartbeatDatastoreInfo `xml:"DasHeartbeatDatastoreInfo,omitempty"`
}

func init() {
	t["ArrayOfDasHeartbeatDatastoreInfo"] = reflect.TypeOf((*ArrayOfDasHeartbeatDatastoreInfo)(nil)).Elem()
}

type ArrayOfDatacenterMismatchArgument struct {
	DatacenterMismatchArgument []DatacenterMismatchArgument `xml:"DatacenterMismatchArgument,omitempty"`
}

func init() {
	t["ArrayOfDatacenterMismatchArgument"] = reflect.TypeOf((*ArrayOfDatacenterMismatchArgument)(nil)).Elem()
}

type ArrayOfDatastoreHostMount struct {
	DatastoreHostMount []DatastoreHostMount `xml:"DatastoreHostMount,omitempty"`
}

func init() {
	t["ArrayOfDatastoreHostMount"] = reflect.TypeOf((*ArrayOfDatastoreHostMount)(nil)).Elem()
}

type ArrayOfDatastoreMountPathDatastorePair struct {
	DatastoreMountPathDatastorePair []DatastoreMountPathDatastorePair `xml:"DatastoreMountPathDatastorePair,omitempty"`
}

func init() {
	t["ArrayOfDatastoreMountPathDatastorePair"] = reflect.TypeOf((*ArrayOfDatastoreMountPathDatastorePair)(nil)).Elem()
}

type ArrayOfDiagnosticManagerBundleInfo struct {
	DiagnosticManagerBundleInfo []DiagnosticManagerBundleInfo `xml:"DiagnosticManagerBundleInfo,omitempty"`
}

func init() {
	t["ArrayOfDiagnosticManagerBundleInfo"] = reflect.TypeOf((*ArrayOfDiagnosticManagerBundleInfo)(nil)).Elem()
}

type ArrayOfDiagnosticManagerLogDescriptor struct {
	DiagnosticManagerLogDescriptor []DiagnosticManagerLogDescriptor `xml:"DiagnosticManagerLogDescriptor,omitempty"`
}

func init() {
	t["ArrayOfDiagnosticManagerLogDescriptor"] = reflect.TypeOf((*ArrayOfDiagnosticManagerLogDescriptor)(nil)).Elem()
}

type ArrayOfDiskChangeExtent struct {
	DiskChangeExtent []DiskChangeExtent `xml:"DiskChangeExtent,omitempty"`
}

func init() {
	t["ArrayOfDiskChangeExtent"] = reflect.TypeOf((*ArrayOfDiskChangeExtent)(nil)).Elem()
}

type ArrayOfDistributedVirtualPort struct {
	DistributedVirtualPort []DistributedVirtualPort `xml:"DistributedVirtualPort,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualPort"] = reflect.TypeOf((*ArrayOfDistributedVirtualPort)(nil)).Elem()
}

type ArrayOfDistributedVirtualPortgroupInfo struct {
	DistributedVirtualPortgroupInfo []DistributedVirtualPortgroupInfo `xml:"DistributedVirtualPortgroupInfo,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualPortgroupInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualPortgroupInfo)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostMember struct {
	DistributedVirtualSwitchHostMember []DistributedVirtualSwitchHostMember `xml:"DistributedVirtualSwitchHostMember,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMember"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMember)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostMemberConfigSpec struct {
	DistributedVirtualSwitchHostMemberConfigSpec []DistributedVirtualSwitchHostMemberConfigSpec `xml:"DistributedVirtualSwitchHostMemberConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberConfigSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberConfigSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostMemberPnicSpec struct {
	DistributedVirtualSwitchHostMemberPnicSpec []DistributedVirtualSwitchHostMemberPnicSpec `xml:"DistributedVirtualSwitchHostMemberPnicSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberPnicSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberPnicSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostProductSpec struct {
	DistributedVirtualSwitchHostProductSpec []DistributedVirtualSwitchHostProductSpec `xml:"DistributedVirtualSwitchHostProductSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostProductSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostProductSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchInfo struct {
	DistributedVirtualSwitchInfo []DistributedVirtualSwitchInfo `xml:"DistributedVirtualSwitchInfo,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchInfo)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob struct {
	DistributedVirtualSwitchKeyedOpaqueBlob []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"DistributedVirtualSwitchKeyedOpaqueBlob,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchManagerCompatibilityResult struct {
	DistributedVirtualSwitchManagerCompatibilityResult []DistributedVirtualSwitchManagerCompatibilityResult `xml:"DistributedVirtualSwitchManagerCompatibilityResult,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchManagerCompatibilityResult"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchManagerCompatibilityResult)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec []BaseDistributedVirtualSwitchManagerHostDvsFilterSpec `xml:"DistributedVirtualSwitchManagerHostDvsFilterSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchProductSpec struct {
	DistributedVirtualSwitchProductSpec []DistributedVirtualSwitchProductSpec `xml:"DistributedVirtualSwitchProductSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchProductSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchProductSpec)(nil)).Elem()
}

type ArrayOfDouble struct {
	Double []float64 `xml:"double,omitempty"`
}

func init() {
	t["ArrayOfDouble"] = reflect.TypeOf((*ArrayOfDouble)(nil)).Elem()
}

type ArrayOfDvsApplyOperationFaultFaultOnObject struct {
	DvsApplyOperationFaultFaultOnObject []DvsApplyOperationFaultFaultOnObject `xml:"DvsApplyOperationFaultFaultOnObject,omitempty"`
}

func init() {
	t["ArrayOfDvsApplyOperationFaultFaultOnObject"] = reflect.TypeOf((*ArrayOfDvsApplyOperationFaultFaultOnObject)(nil)).Elem()
}

type ArrayOfDvsFilterConfig struct {
	DvsFilterConfig []BaseDvsFilterConfig `xml:"DvsFilterConfig,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDvsFilterConfig"] = reflect.TypeOf((*ArrayOfDvsFilterConfig)(nil)).Elem()
}

type ArrayOfDvsHostVNicProfile struct {
	DvsHostVNicProfile []DvsHostVNicProfile `xml:"DvsHostVNicProfile,omitempty"`
}

func init() {
	t["ArrayOfDvsHostVNicProfile"] = reflect.TypeOf((*ArrayOfDvsHostVNicProfile)(nil)).Elem()
}

type ArrayOfDvsNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier []BaseDvsNetworkRuleQualifier `xml:"DvsNetworkRuleQualifier,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDvsNetworkRuleQualifier"] = reflect.TypeOf((*ArrayOfDvsNetworkRuleQualifier)(nil)).Elem()
}

type ArrayOfDvsOperationBulkFaultFaultOnHost struct {
	DvsOperationBulkFaultFaultOnHost []DvsOperationBulkFaultFaultOnHost `xml:"DvsOperationBulkFaultFaultOnHost,omitempty"`
}

func init() {
	t["ArrayOfDvsOperationBulkFaultFaultOnHost"] = reflect.TypeOf((*ArrayOfDvsOperationBulkFaultFaultOnHost)(nil)).Elem()
}

type ArrayOfDvsOutOfSyncHostArgument struct {
	DvsOutOfSyncHostArgument []DvsOutOfSyncHostArgument `xml:"DvsOutOfSyncHostArgument,omitempty"`
}

func init() {
	t["ArrayOfDvsOutOfSyncHostArgument"] = reflect.TypeOf((*ArrayOfDvsOutOfSyncHostArgument)(nil)).Elem()
}

type ArrayOfDvsProfile struct {
	DvsProfile []DvsProfile `xml:"DvsProfile,omitempty"`
}

func init() {
	t["ArrayOfDvsProfile"] = reflect.TypeOf((*ArrayOfDvsProfile)(nil)).Elem()
}

type ArrayOfDvsServiceConsoleVNicProfile struct {
	DvsServiceConsoleVNicProfile []DvsServiceConsoleVNicProfile `xml:"DvsServiceConsoleVNicProfile,omitempty"`
}

func init() {
	t["ArrayOfDvsServiceConsoleVNicProfile"] = reflect.TypeOf((*ArrayOfDvsServiceConsoleVNicProfile)(nil)).Elem()
}

type ArrayOfDvsTrafficRule struct {
	DvsTrafficRule []DvsTrafficRule `xml:"DvsTrafficRule,omitempty"`
}

func init() {
	t["ArrayOfDvsTrafficRule"] = reflect.TypeOf((*ArrayOfDvsTrafficRule)(nil)).Elem()
}

type ArrayOfDynamicProperty struct {
	DynamicProperty []DynamicProperty `xml:"DynamicProperty,omitempty"`
}

func init() {
	t["ArrayOfDynamicProperty"] = reflect.TypeOf((*ArrayOfDynamicProperty)(nil)).Elem()
}

type ArrayOfEVCMode struct {
	EVCMode []EVCMode `xml:"EVCMode,omitempty"`
}

func init() {
	t["ArrayOfEVCMode"] = reflect.TypeOf((*ArrayOfEVCMode)(nil)).Elem()
}

type ArrayOfElementDescription struct {
	ElementDescription []BaseElementDescription `xml:"ElementDescription,omitempty,typeattr"`
}

func init() {
	t["ArrayOfElementDescription"] = reflect.TypeOf((*ArrayOfElementDescription)(nil)).Elem()
}

type ArrayOfEntityBackupConfig struct {
	EntityBackupConfig []EntityBackupConfig `xml:"EntityBackupConfig,omitempty"`
}

func init() {
	t["ArrayOfEntityBackupConfig"] = reflect.TypeOf((*ArrayOfEntityBackupConfig)(nil)).Elem()
}

type ArrayOfEntityPrivilege struct {
	EntityPrivilege []EntityPrivilege `xml:"EntityPrivilege,omitempty"`
}

func init() {
	t["ArrayOfEntityPrivilege"] = reflect.TypeOf((*ArrayOfEntityPrivilege)(nil)).Elem()
}

type ArrayOfEnumDescription struct {
	EnumDescription []EnumDescription `xml:"EnumDescription,omitempty"`
}

func init() {
	t["ArrayOfEnumDescription"] = reflect.TypeOf((*ArrayOfEnumDescription)(nil)).Elem()
}

type ArrayOfEvent struct {
	Event []BaseEvent `xml:"Event,omitempty,typeattr"`
}

func init() {
	t["ArrayOfEvent"] = reflect.TypeOf((*ArrayOfEvent)(nil)).Elem()
}

type ArrayOfEventAlarmExpressionComparison struct {
	EventAlarmExpressionComparison []EventAlarmExpressionComparison `xml:"EventAlarmExpressionComparison,omitempty"`
}

func init() {
	t["ArrayOfEventAlarmExpressionComparison"] = reflect.TypeOf((*ArrayOfEventAlarmExpressionComparison)(nil)).Elem()
}

type ArrayOfEventArgDesc struct {
	EventArgDesc []EventArgDesc `xml:"EventArgDesc,omitempty"`
}

func init() {
	t["ArrayOfEventArgDesc"] = reflect.TypeOf((*ArrayOfEventArgDesc)(nil)).Elem()
}

type ArrayOfEventDescriptionEventDetail struct {
	EventDescriptionEventDetail []EventDescriptionEventDetail `xml:"EventDescriptionEventDetail,omitempty"`
}

func init() {
	t["ArrayOfEventDescriptionEventDetail"] = reflect.TypeOf((*ArrayOfEventDescriptionEventDetail)(nil)).Elem()
}

type ArrayOfExtManagedEntityInfo struct {
	ExtManagedEntityInfo []ExtManagedEntityInfo `xml:"ExtManagedEntityInfo,omitempty"`
}

func init() {
	t["ArrayOfExtManagedEntityInfo"] = reflect.TypeOf((*ArrayOfExtManagedEntityInfo)(nil)).Elem()
}

type ArrayOfExtSolutionManagerInfoTabInfo struct {
	ExtSolutionManagerInfoTabInfo []ExtSolutionManagerInfoTabInfo `xml:"ExtSolutionManagerInfoTabInfo,omitempty"`
}

func init() {
	t["ArrayOfExtSolutionManagerInfoTabInfo"] = reflect.TypeOf((*ArrayOfExtSolutionManagerInfoTabInfo)(nil)).Elem()
}

type ArrayOfExtendedEventPair struct {
	ExtendedEventPair []ExtendedEventPair `xml:"ExtendedEventPair,omitempty"`
}

func init() {
	t["ArrayOfExtendedEventPair"] = reflect.TypeOf((*ArrayOfExtendedEventPair)(nil)).Elem()
}

type ArrayOfExtension struct {
	Extension []Extension `xml:"Extension,omitempty"`
}

func init() {
	t["ArrayOfExtension"] = reflect.TypeOf((*ArrayOfExtension)(nil)).Elem()
}

type ArrayOfExtensionClientInfo struct {
	ExtensionClientInfo []ExtensionClientInfo `xml:"ExtensionClientInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionClientInfo"] = reflect.TypeOf((*ArrayOfExtensionClientInfo)(nil)).Elem()
}

type ArrayOfExtensionEventTypeInfo struct {
	ExtensionEventTypeInfo []ExtensionEventTypeInfo `xml:"ExtensionEventTypeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionEventTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionEventTypeInfo)(nil)).Elem()
}

type ArrayOfExtensionFaultTypeInfo struct {
	ExtensionFaultTypeInfo []ExtensionFaultTypeInfo `xml:"ExtensionFaultTypeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionFaultTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionFaultTypeInfo)(nil)).Elem()
}

type ArrayOfExtensionManagerIpAllocationUsage struct {
	ExtensionManagerIpAllocationUsage []ExtensionManagerIpAllocationUsage `xml:"ExtensionManagerIpAllocationUsage,omitempty"`
}

func init() {
	t["ArrayOfExtensionManagerIpAllocationUsage"] = reflect.TypeOf((*ArrayOfExtensionManagerIpAllocationUsage)(nil)).Elem()
}

type ArrayOfExtensionPrivilegeInfo struct {
	ExtensionPrivilegeInfo []ExtensionPrivilegeInfo `xml:"ExtensionPrivilegeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionPrivilegeInfo"] = reflect.TypeOf((*ArrayOfExtensionPrivilegeInfo)(nil)).Elem()
}

type ArrayOfExtensionResourceInfo struct {
	ExtensionResourceInfo []ExtensionResourceInfo `xml:"ExtensionResourceInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionResourceInfo"] = reflect.TypeOf((*ArrayOfExtensionResourceInfo)(nil)).Elem()
}

type ArrayOfExtensionServerInfo struct {
	ExtensionServerInfo []ExtensionServerInfo `xml:"ExtensionServerInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionServerInfo"] = reflect.TypeOf((*ArrayOfExtensionServerInfo)(nil)).Elem()
}

type ArrayOfExtensionTaskTypeInfo struct {
	ExtensionTaskTypeInfo []ExtensionTaskTypeInfo `xml:"ExtensionTaskTypeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionTaskTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionTaskTypeInfo)(nil)).Elem()
}

type ArrayOfFcoeConfigVlanRange struct {
	FcoeConfigVlanRange []FcoeConfigVlanRange `xml:"FcoeConfigVlanRange,omitempty"`
}

func init() {
	t["ArrayOfFcoeConfigVlanRange"] = reflect.TypeOf((*ArrayOfFcoeConfigVlanRange)(nil)).Elem()
}

type ArrayOfFileInfo struct {
	FileInfo []BaseFileInfo `xml:"FileInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfFileInfo"] = reflect.TypeOf((*ArrayOfFileInfo)(nil)).Elem()
}

type ArrayOfFileQuery struct {
	FileQuery []BaseFileQuery `xml:"FileQuery,omitempty,typeattr"`
}

func init() {
	t["ArrayOfFileQuery"] = reflect.TypeOf((*ArrayOfFileQuery)(nil)).Elem()
}

type ArrayOfFirewallProfileRulesetProfile struct {
	FirewallProfileRulesetProfile []FirewallProfileRulesetProfile `xml:"FirewallProfileRulesetProfile,omitempty"`
}

func init() {
	t["ArrayOfFirewallProfileRulesetProfile"] = reflect.TypeOf((*ArrayOfFirewallProfileRulesetProfile)(nil)).Elem()
}

type ArrayOfGuestDiskInfo struct {
	GuestDiskInfo []GuestDiskInfo `xml:"GuestDiskInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestDiskInfo"] = reflect.TypeOf((*ArrayOfGuestDiskInfo)(nil)).Elem()
}

type ArrayOfGuestFileInfo struct {
	GuestFileInfo []GuestFileInfo `xml:"GuestFileInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestFileInfo"] = reflect.TypeOf((*ArrayOfGuestFileInfo)(nil)).Elem()
}

type ArrayOfGuestInfoNamespaceGenerationInfo struct {
	GuestInfoNamespaceGenerationInfo []GuestInfoNamespaceGenerationInfo `xml:"GuestInfoNamespaceGenerationInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestInfoNamespaceGenerationInfo"] = reflect.TypeOf((*ArrayOfGuestInfoNamespaceGenerationInfo)(nil)).Elem()
}

type ArrayOfGuestNicInfo struct {
	GuestNicInfo []GuestNicInfo `xml:"GuestNicInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestNicInfo"] = reflect.TypeOf((*ArrayOfGuestNicInfo)(nil)).Elem()
}

type ArrayOfGuestOsDescriptor struct {
	GuestOsDescriptor []GuestOsDescriptor `xml:"GuestOsDescriptor,omitempty"`
}

func init() {
	t["ArrayOfGuestOsDescriptor"] = reflect.TypeOf((*ArrayOfGuestOsDescriptor)(nil)).Elem()
}

type ArrayOfGuestProcessInfo struct {
	GuestProcessInfo []GuestProcessInfo `xml:"GuestProcessInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestProcessInfo"] = reflect.TypeOf((*ArrayOfGuestProcessInfo)(nil)).Elem()
}

type ArrayOfGuestStackInfo struct {
	GuestStackInfo []GuestStackInfo `xml:"GuestStackInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestStackInfo"] = reflect.TypeOf((*ArrayOfGuestStackInfo)(nil)).Elem()
}

type ArrayOfHostAccountSpec struct {
	HostAccountSpec []BaseHostAccountSpec `xml:"HostAccountSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostAccountSpec"] = reflect.TypeOf((*ArrayOfHostAccountSpec)(nil)).Elem()
}

type ArrayOfHostActiveDirectory struct {
	HostActiveDirectory []HostActiveDirectory `xml:"HostActiveDirectory,omitempty"`
}

func init() {
	t["ArrayOfHostActiveDirectory"] = reflect.TypeOf((*ArrayOfHostActiveDirectory)(nil)).Elem()
}

type ArrayOfHostAuthenticationStoreInfo struct {
	HostAuthenticationStoreInfo []BaseHostAuthenticationStoreInfo `xml:"HostAuthenticationStoreInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostAuthenticationStoreInfo"] = reflect.TypeOf((*ArrayOfHostAuthenticationStoreInfo)(nil)).Elem()
}

type ArrayOfHostBootDevice struct {
	HostBootDevice []HostBootDevice `xml:"HostBootDevice,omitempty"`
}

func init() {
	t["ArrayOfHostBootDevice"] = reflect.TypeOf((*ArrayOfHostBootDevice)(nil)).Elem()
}

type ArrayOfHostCacheConfigurationInfo struct {
	HostCacheConfigurationInfo []HostCacheConfigurationInfo `xml:"HostCacheConfigurationInfo,omitempty"`
}

func init() {
	t["ArrayOfHostCacheConfigurationInfo"] = reflect.TypeOf((*ArrayOfHostCacheConfigurationInfo)(nil)).Elem()
}

type ArrayOfHostConnectInfoNetworkInfo struct {
	HostConnectInfoNetworkInfo []BaseHostConnectInfoNetworkInfo `xml:"HostConnectInfoNetworkInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostConnectInfoNetworkInfo"] = reflect.TypeOf((*ArrayOfHostConnectInfoNetworkInfo)(nil)).Elem()
}

type ArrayOfHostCpuIdInfo struct {
	HostCpuIdInfo []HostCpuIdInfo `xml:"HostCpuIdInfo,omitempty"`
}

func init() {
	t["ArrayOfHostCpuIdInfo"] = reflect.TypeOf((*ArrayOfHostCpuIdInfo)(nil)).Elem()
}

type ArrayOfHostCpuPackage struct {
	HostCpuPackage []HostCpuPackage `xml:"HostCpuPackage,omitempty"`
}

func init() {
	t["ArrayOfHostCpuPackage"] = reflect.TypeOf((*ArrayOfHostCpuPackage)(nil)).Elem()
}

type ArrayOfHostDatastoreBrowserSearchResults struct {
	HostDatastoreBrowserSearchResults []HostDatastoreBrowserSearchResults `xml:"HostDatastoreBrowserSearchResults,omitempty"`
}

func init() {
	t["ArrayOfHostDatastoreBrowserSearchResults"] = reflect.TypeOf((*ArrayOfHostDatastoreBrowserSearchResults)(nil)).Elem()
}

type ArrayOfHostDatastoreConnectInfo struct {
	HostDatastoreConnectInfo []BaseHostDatastoreConnectInfo `xml:"HostDatastoreConnectInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostDatastoreConnectInfo"] = reflect.TypeOf((*ArrayOfHostDatastoreConnectInfo)(nil)).Elem()
}

type ArrayOfHostDateTimeSystemTimeZone struct {
	HostDateTimeSystemTimeZone []HostDateTimeSystemTimeZone `xml:"HostDateTimeSystemTimeZone,omitempty"`
}

func init() {
	t["ArrayOfHostDateTimeSystemTimeZone"] = reflect.TypeOf((*ArrayOfHostDateTimeSystemTimeZone)(nil)).Elem()
}

type ArrayOfHostDhcpService struct {
	HostDhcpService []HostDhcpService `xml:"HostDhcpService,omitempty"`
}

func init() {
	t["ArrayOfHostDhcpService"] = reflect.TypeOf((*ArrayOfHostDhcpService)(nil)).Elem()
}

type ArrayOfHostDhcpServiceConfig struct {
	HostDhcpServiceConfig []HostDhcpServiceConfig `xml:"HostDhcpServiceConfig,omitempty"`
}

func init() {
	t["ArrayOfHostDhcpServiceConfig"] = reflect.TypeOf((*ArrayOfHostDhcpServiceConfig)(nil)).Elem()
}

type ArrayOfHostDiagnosticPartition struct {
	HostDiagnosticPartition []HostDiagnosticPartition `xml:"HostDiagnosticPartition,omitempty"`
}

func init() {
	t["ArrayOfHostDiagnosticPartition"] = reflect.TypeOf((*ArrayOfHostDiagnosticPartition)(nil)).Elem()
}

type ArrayOfHostDiagnosticPartitionCreateOption struct {
	HostDiagnosticPartitionCreateOption []HostDiagnosticPartitionCreateOption `xml:"HostDiagnosticPartitionCreateOption,omitempty"`
}

func init() {
	t["ArrayOfHostDiagnosticPartitionCreateOption"] = reflect.TypeOf((*ArrayOfHostDiagnosticPartitionCreateOption)(nil)).Elem()
}

type ArrayOfHostDiskConfigurationResult struct {
	HostDiskConfigurationResult []HostDiskConfigurationResult `xml:"HostDiskConfigurationResult,omitempty"`
}

func init() {
	t["ArrayOfHostDiskConfigurationResult"] = reflect.TypeOf((*ArrayOfHostDiskConfigurationResult)(nil)).Elem()
}

type ArrayOfHostDiskMappingPartitionOption struct {
	HostDiskMappingPartitionOption []HostDiskMappingPartitionOption `xml:"HostDiskMappingPartitionOption,omitempty"`
}

func init() {
	t["ArrayOfHostDiskMappingPartitionOption"] = reflect.TypeOf((*ArrayOfHostDiskMappingPartitionOption)(nil)).Elem()
}

type ArrayOfHostDiskPartitionAttributes struct {
	HostDiskPartitionAttributes []HostDiskPartitionAttributes `xml:"HostDiskPartitionAttributes,omitempty"`
}

func init() {
	t["ArrayOfHostDiskPartitionAttributes"] = reflect.TypeOf((*ArrayOfHostDiskPartitionAttributes)(nil)).Elem()
}

type ArrayOfHostDiskPartitionBlockRange struct {
	HostDiskPartitionBlockRange []HostDiskPartitionBlockRange `xml:"HostDiskPartitionBlockRange,omitempty"`
}

func init() {
	t["ArrayOfHostDiskPartitionBlockRange"] = reflect.TypeOf((*ArrayOfHostDiskPartitionBlockRange)(nil)).Elem()
}

type ArrayOfHostDiskPartitionInfo struct {
	HostDiskPartitionInfo []HostDiskPartitionInfo `xml:"HostDiskPartitionInfo,omitempty"`
}

func init() {
	t["ArrayOfHostDiskPartitionInfo"] = reflect.TypeOf((*ArrayOfHostDiskPartitionInfo)(nil)).Elem()
}

type ArrayOfHostEventArgument struct {
	HostEventArgument []HostEventArgument `xml:"HostEventArgument,omitempty"`
}

func init() {
	t["ArrayOfHostEventArgument"] = reflect.TypeOf((*ArrayOfHostEventArgument)(nil)).Elem()
}

type ArrayOfHostFeatureCapability struct {
	HostFeatureCapability []HostFeatureCapability `xml:"HostFeatureCapability,omitempty"`
}

func init() {
	t["ArrayOfHostFeatureCapability"] = reflect.TypeOf((*ArrayOfHostFeatureCapability)(nil)).Elem()
}

type ArrayOfHostFeatureMask struct {
	HostFeatureMask []HostFeatureMask `xml:"HostFeatureMask,omitempty"`
}

func init() {
	t["ArrayOfHostFeatureMask"] = reflect.TypeOf((*ArrayOfHostFeatureMask)(nil)).Elem()
}

type ArrayOfHostFeatureVersionInfo struct {
	HostFeatureVersionInfo []HostFeatureVersionInfo `xml:"HostFeatureVersionInfo,omitempty"`
}

func init() {
	t["ArrayOfHostFeatureVersionInfo"] = reflect.TypeOf((*ArrayOfHostFeatureVersionInfo)(nil)).Elem()
}

type ArrayOfHostFileSystemMountInfo struct {
	HostFileSystemMountInfo []HostFileSystemMountInfo `xml:"HostFileSystemMountInfo,omitempty"`
}

func init() {
	t["ArrayOfHostFileSystemMountInfo"] = reflect.TypeOf((*ArrayOfHostFileSystemMountInfo)(nil)).Elem()
}

type ArrayOfHostFirewallConfigRuleSetConfig struct {
	HostFirewallConfigRuleSetConfig []HostFirewallConfigRuleSetConfig `xml:"HostFirewallConfigRuleSetConfig,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallConfigRuleSetConfig"] = reflect.TypeOf((*ArrayOfHostFirewallConfigRuleSetConfig)(nil)).Elem()
}

type ArrayOfHostFirewallRule struct {
	HostFirewallRule []HostFirewallRule `xml:"HostFirewallRule,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallRule"] = reflect.TypeOf((*ArrayOfHostFirewallRule)(nil)).Elem()
}

type ArrayOfHostFirewallRuleset struct {
	HostFirewallRuleset []HostFirewallRuleset `xml:"HostFirewallRuleset,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallRuleset"] = reflect.TypeOf((*ArrayOfHostFirewallRuleset)(nil)).Elem()
}

type ArrayOfHostFirewallRulesetIpNetwork struct {
	HostFirewallRulesetIpNetwork []HostFirewallRulesetIpNetwork `xml:"HostFirewallRulesetIpNetwork,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallRulesetIpNetwork"] = reflect.TypeOf((*ArrayOfHostFirewallRulesetIpNetwork)(nil)).Elem()
}

type ArrayOfHostGraphicsInfo struct {
	HostGraphicsInfo []HostGraphicsInfo `xml:"HostGraphicsInfo,omitempty"`
}

func init() {
	t["ArrayOfHostGraphicsInfo"] = reflect.TypeOf((*ArrayOfHostGraphicsInfo)(nil)).Elem()
}

type ArrayOfHostHardwareElementInfo struct {
	HostHardwareElementInfo []BaseHostHardwareElementInfo `xml:"HostHardwareElementInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostHardwareElementInfo"] = reflect.TypeOf((*ArrayOfHostHardwareElementInfo)(nil)).Elem()
}

type ArrayOfHostHostBusAdapter struct {
	HostHostBusAdapter []BaseHostHostBusAdapter `xml:"HostHostBusAdapter,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostHostBusAdapter"] = reflect.TypeOf((*ArrayOfHostHostBusAdapter)(nil)).Elem()
}

type ArrayOfHostInternetScsiHbaParamValue struct {
	HostInternetScsiHbaParamValue []HostInternetScsiHbaParamValue `xml:"HostInternetScsiHbaParamValue,omitempty"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaParamValue"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaParamValue)(nil)).Elem()
}

type ArrayOfHostInternetScsiHbaSendTarget struct {
	HostInternetScsiHbaSendTarget []HostInternetScsiHbaSendTarget `xml:"HostInternetScsiHbaSendTarget,omitempty"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaSendTarget"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaSendTarget)(nil)).Elem()
}

type ArrayOfHostInternetScsiHbaStaticTarget struct {
	HostInternetScsiHbaStaticTarget []HostInternetScsiHbaStaticTarget `xml:"HostInternetScsiHbaStaticTarget,omitempty"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaStaticTarget"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaStaticTarget)(nil)).Elem()
}

type ArrayOfHostIpConfigIpV6Address struct {
	HostIpConfigIpV6Address []HostIpConfigIpV6Address `xml:"HostIpConfigIpV6Address,omitempty"`
}

func init() {
	t["ArrayOfHostIpConfigIpV6Address"] = reflect.TypeOf((*ArrayOfHostIpConfigIpV6Address)(nil)).Elem()
}

type ArrayOfHostIpRouteEntry struct {
	HostIpRouteEntry []HostIpRouteEntry `xml:"HostIpRouteEntry,omitempty"`
}

func init() {
	t["ArrayOfHostIpRouteEntry"] = reflect.TypeOf((*ArrayOfHostIpRouteEntry)(nil)).Elem()
}

type ArrayOfHostIpRouteOp struct {
	HostIpRouteOp []HostIpRouteOp `xml:"HostIpRouteOp,omitempty"`
}

func init() {
	t["ArrayOfHostIpRouteOp"] = reflect.TypeOf((*ArrayOfHostIpRouteOp)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec struct {
	HostLowLevelProvisioningManagerDiskLayoutSpec []HostLowLevelProvisioningManagerDiskLayoutSpec `xml:"HostLowLevelProvisioningManagerDiskLayoutSpec,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec struct {
	HostLowLevelProvisioningManagerSnapshotLayoutSpec []HostLowLevelProvisioningManagerSnapshotLayoutSpec `xml:"HostLowLevelProvisioningManagerSnapshotLayoutSpec,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec)(nil)).Elem()
}

type ArrayOfHostMemberHealthCheckResult struct {
	HostMemberHealthCheckResult []BaseHostMemberHealthCheckResult `xml:"HostMemberHealthCheckResult,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostMemberHealthCheckResult"] = reflect.TypeOf((*ArrayOfHostMemberHealthCheckResult)(nil)).Elem()
}

type ArrayOfHostMemberRuntimeInfo struct {
	HostMemberRuntimeInfo []HostMemberRuntimeInfo `xml:"HostMemberRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfHostMemberRuntimeInfo"] = reflect.TypeOf((*ArrayOfHostMemberRuntimeInfo)(nil)).Elem()
}

type ArrayOfHostMultipathInfoLogicalUnit struct {
	HostMultipathInfoLogicalUnit []HostMultipathInfoLogicalUnit `xml:"HostMultipathInfoLogicalUnit,omitempty"`
}

func init() {
	t["ArrayOfHostMultipathInfoLogicalUnit"] = reflect.TypeOf((*ArrayOfHostMultipathInfoLogicalUnit)(nil)).Elem()
}

type ArrayOfHostMultipathInfoPath struct {
	HostMultipathInfoPath []HostMultipathInfoPath `xml:"HostMultipathInfoPath,omitempty"`
}

func init() {
	t["ArrayOfHostMultipathInfoPath"] = reflect.TypeOf((*ArrayOfHostMultipathInfoPath)(nil)).Elem()
}

type ArrayOfHostMultipathStateInfoPath struct {
	HostMultipathStateInfoPath []HostMultipathStateInfoPath `xml:"HostMultipathStateInfoPath,omitempty"`
}

func init() {
	t["ArrayOfHostMultipathStateInfoPath"] = reflect.TypeOf((*ArrayOfHostMultipathStateInfoPath)(nil)).Elem()
}

type ArrayOfHostNasVolumeConfig struct {
	HostNasVolumeConfig []HostNasVolumeConfig `xml:"HostNasVolumeConfig,omitempty"`
}

func init() {
	t["ArrayOfHostNasVolumeConfig"] = reflect.TypeOf((*ArrayOfHostNasVolumeConfig)(nil)).Elem()
}

type ArrayOfHostNatService struct {
	HostNatService []HostNatService `xml:"HostNatService,omitempty"`
}

func init() {
	t["ArrayOfHostNatService"] = reflect.TypeOf((*ArrayOfHostNatService)(nil)).Elem()
}

type ArrayOfHostNatServiceConfig struct {
	HostNatServiceConfig []HostNatServiceConfig `xml:"HostNatServiceConfig,omitempty"`
}

func init() {
	t["ArrayOfHostNatServiceConfig"] = reflect.TypeOf((*ArrayOfHostNatServiceConfig)(nil)).Elem()
}

type ArrayOfHostNatServicePortForwardSpec struct {
	HostNatServicePortForwardSpec []HostNatServicePortForwardSpec `xml:"HostNatServicePortForwardSpec,omitempty"`
}

func init() {
	t["ArrayOfHostNatServicePortForwardSpec"] = reflect.TypeOf((*ArrayOfHostNatServicePortForwardSpec)(nil)).Elem()
}

type ArrayOfHostNetStackInstance struct {
	HostNetStackInstance []HostNetStackInstance `xml:"HostNetStackInstance,omitempty"`
}

func init() {
	t["ArrayOfHostNetStackInstance"] = reflect.TypeOf((*ArrayOfHostNetStackInstance)(nil)).Elem()
}

type ArrayOfHostNetworkConfigNetStackSpec struct {
	HostNetworkConfigNetStackSpec []HostNetworkConfigNetStackSpec `xml:"HostNetworkConfigNetStackSpec,omitempty"`
}

func init() {
	t["ArrayOfHostNetworkConfigNetStackSpec"] = reflect.TypeOf((*ArrayOfHostNetworkConfigNetStackSpec)(nil)).Elem()
}

type ArrayOfHostNumaNode struct {
	HostNumaNode []HostNumaNode `xml:"HostNumaNode,omitempty"`
}

func init() {
	t["ArrayOfHostNumaNode"] = reflect.TypeOf((*ArrayOfHostNumaNode)(nil)).Elem()
}

type ArrayOfHostNumericSensorInfo struct {
	HostNumericSensorInfo []HostNumericSensorInfo `xml:"HostNumericSensorInfo,omitempty"`
}

func init() {
	t["ArrayOfHostNumericSensorInfo"] = reflect.TypeOf((*ArrayOfHostNumericSensorInfo)(nil)).Elem()
}

type ArrayOfHostOpaqueNetworkInfo struct {
	HostOpaqueNetworkInfo []HostOpaqueNetworkInfo `xml:"HostOpaqueNetworkInfo,omitempty"`
}

func init() {
	t["ArrayOfHostOpaqueNetworkInfo"] = reflect.TypeOf((*ArrayOfHostOpaqueNetworkInfo)(nil)).Elem()
}

type ArrayOfHostOpaqueSwitch struct {
	HostOpaqueSwitch []HostOpaqueSwitch `xml:"HostOpaqueSwitch,omitempty"`
}

func init() {
	t["ArrayOfHostOpaqueSwitch"] = reflect.TypeOf((*ArrayOfHostOpaqueSwitch)(nil)).Elem()
}

type ArrayOfHostPatchManagerStatus struct {
	HostPatchManagerStatus []HostPatchManagerStatus `xml:"HostPatchManagerStatus,omitempty"`
}

func init() {
	t["ArrayOfHostPatchManagerStatus"] = reflect.TypeOf((*ArrayOfHostPatchManagerStatus)(nil)).Elem()
}

type ArrayOfHostPatchManagerStatusPrerequisitePatch struct {
	HostPatchManagerStatusPrerequisitePatch []HostPatchManagerStatusPrerequisitePatch `xml:"HostPatchManagerStatusPrerequisitePatch,omitempty"`
}

func init() {
	t["ArrayOfHostPatchManagerStatusPrerequisitePatch"] = reflect.TypeOf((*ArrayOfHostPatchManagerStatusPrerequisitePatch)(nil)).Elem()
}

type ArrayOfHostPathSelectionPolicyOption struct {
	HostPathSelectionPolicyOption []HostPathSelectionPolicyOption `xml:"HostPathSelectionPolicyOption,omitempty"`
}

func init() {
	t["ArrayOfHostPathSelectionPolicyOption"] = reflect.TypeOf((*ArrayOfHostPathSelectionPolicyOption)(nil)).Elem()
}

type ArrayOfHostPciDevice struct {
	HostPciDevice []HostPciDevice `xml:"HostPciDevice,omitempty"`
}

func init() {
	t["ArrayOfHostPciDevice"] = reflect.TypeOf((*ArrayOfHostPciDevice)(nil)).Elem()
}

type ArrayOfHostPciPassthruConfig struct {
	HostPciPassthruConfig []BaseHostPciPassthruConfig `xml:"HostPciPassthruConfig,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostPciPassthruConfig"] = reflect.TypeOf((*ArrayOfHostPciPassthruConfig)(nil)).Elem()
}

type ArrayOfHostPciPassthruInfo struct {
	HostPciPassthruInfo []BaseHostPciPassthruInfo `xml:"HostPciPassthruInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostPciPassthruInfo"] = reflect.TypeOf((*ArrayOfHostPciPassthruInfo)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyAdapter struct {
	HostPlugStoreTopologyAdapter []HostPlugStoreTopologyAdapter `xml:"HostPlugStoreTopologyAdapter,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyAdapter"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyAdapter)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyDevice struct {
	HostPlugStoreTopologyDevice []HostPlugStoreTopologyDevice `xml:"HostPlugStoreTopologyDevice,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyDevice"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyDevice)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyPath struct {
	HostPlugStoreTopologyPath []HostPlugStoreTopologyPath `xml:"HostPlugStoreTopologyPath,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyPath"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyPath)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyPlugin struct {
	HostPlugStoreTopologyPlugin []HostPlugStoreTopologyPlugin `xml:"HostPlugStoreTopologyPlugin,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyPlugin"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyPlugin)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyTarget struct {
	HostPlugStoreTopologyTarget []HostPlugStoreTopologyTarget `xml:"HostPlugStoreTopologyTarget,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyTarget"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyTarget)(nil)).Elem()
}

type ArrayOfHostPortGroup struct {
	HostPortGroup []HostPortGroup `xml:"HostPortGroup,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroup"] = reflect.TypeOf((*ArrayOfHostPortGroup)(nil)).Elem()
}

type ArrayOfHostPortGroupConfig struct {
	HostPortGroupConfig []HostPortGroupConfig `xml:"HostPortGroupConfig,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroupConfig"] = reflect.TypeOf((*ArrayOfHostPortGroupConfig)(nil)).Elem()
}

type ArrayOfHostPortGroupPort struct {
	HostPortGroupPort []HostPortGroupPort `xml:"HostPortGroupPort,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroupPort"] = reflect.TypeOf((*ArrayOfHostPortGroupPort)(nil)).Elem()
}

type ArrayOfHostPortGroupProfile struct {
	HostPortGroupProfile []HostPortGroupProfile `xml:"HostPortGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroupProfile"] = reflect.TypeOf((*ArrayOfHostPortGroupProfile)(nil)).Elem()
}

type ArrayOfHostPowerPolicy struct {
	HostPowerPolicy []HostPowerPolicy `xml:"HostPowerPolicy,omitempty"`
}

func init() {
	t["ArrayOfHostPowerPolicy"] = reflect.TypeOf((*ArrayOfHostPowerPolicy)(nil)).Elem()
}

type ArrayOfHostProxySwitch struct {
	HostProxySwitch []HostProxySwitch `xml:"HostProxySwitch,omitempty"`
}

func init() {
	t["ArrayOfHostProxySwitch"] = reflect.TypeOf((*ArrayOfHostProxySwitch)(nil)).Elem()
}

type ArrayOfHostProxySwitchConfig struct {
	HostProxySwitchConfig []HostProxySwitchConfig `xml:"HostProxySwitchConfig,omitempty"`
}

func init() {
	t["ArrayOfHostProxySwitchConfig"] = reflect.TypeOf((*ArrayOfHostProxySwitchConfig)(nil)).Elem()
}

type ArrayOfHostProxySwitchHostLagConfig struct {
	HostProxySwitchHostLagConfig []HostProxySwitchHostLagConfig `xml:"HostProxySwitchHostLagConfig,omitempty"`
}

func init() {
	t["ArrayOfHostProxySwitchHostLagConfig"] = reflect.TypeOf((*ArrayOfHostProxySwitchHostLagConfig)(nil)).Elem()
}

type ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo struct {
	HostRuntimeInfoNetStackInstanceRuntimeInfo []HostRuntimeInfoNetStackInstanceRuntimeInfo `xml:"HostRuntimeInfoNetStackInstanceRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo"] = reflect.TypeOf((*ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo)(nil)).Elem()
}

type ArrayOfHostScsiDisk struct {
	HostScsiDisk []HostScsiDisk `xml:"HostScsiDisk,omitempty"`
}

func init() {
	t["ArrayOfHostScsiDisk"] = reflect.TypeOf((*ArrayOfHostScsiDisk)(nil)).Elem()
}

type ArrayOfHostScsiDiskPartition struct {
	HostScsiDiskPartition []HostScsiDiskPartition `xml:"HostScsiDiskPartition,omitempty"`
}

func init() {
	t["ArrayOfHostScsiDiskPartition"] = reflect.TypeOf((*ArrayOfHostScsiDiskPartition)(nil)).Elem()
}

type ArrayOfHostScsiTopologyInterface struct {
	HostScsiTopologyInterface []HostScsiTopologyInterface `xml:"HostScsiTopologyInterface,omitempty"`
}

func init() {
	t["ArrayOfHostScsiTopologyInterface"] = reflect.TypeOf((*ArrayOfHostScsiTopologyInterface)(nil)).Elem()
}

type ArrayOfHostScsiTopologyLun struct {
	HostScsiTopologyLun []HostScsiTopologyLun `xml:"HostScsiTopologyLun,omitempty"`
}

func init() {
	t["ArrayOfHostScsiTopologyLun"] = reflect.TypeOf((*ArrayOfHostScsiTopologyLun)(nil)).Elem()
}

type ArrayOfHostScsiTopologyTarget struct {
	HostScsiTopologyTarget []HostScsiTopologyTarget `xml:"HostScsiTopologyTarget,omitempty"`
}

func init() {
	t["ArrayOfHostScsiTopologyTarget"] = reflect.TypeOf((*ArrayOfHostScsiTopologyTarget)(nil)).Elem()
}

type ArrayOfHostService struct {
	HostService []HostService `xml:"HostService,omitempty"`
}

func init() {
	t["ArrayOfHostService"] = reflect.TypeOf((*ArrayOfHostService)(nil)).Elem()
}

type ArrayOfHostServiceConfig struct {
	HostServiceConfig []HostServiceConfig `xml:"HostServiceConfig,omitempty"`
}

func init() {
	t["ArrayOfHostServiceConfig"] = reflect.TypeOf((*ArrayOfHostServiceConfig)(nil)).Elem()
}

type ArrayOfHostSnmpDestination struct {
	HostSnmpDestination []HostSnmpDestination `xml:"HostSnmpDestination,omitempty"`
}

func init() {
	t["ArrayOfHostSnmpDestination"] = reflect.TypeOf((*ArrayOfHostSnmpDestination)(nil)).Elem()
}

type ArrayOfHostSslThumbprintInfo struct {
	HostSslThumbprintInfo []HostSslThumbprintInfo `xml:"HostSslThumbprintInfo,omitempty"`
}

func init() {
	t["ArrayOfHostSslThumbprintInfo"] = reflect.TypeOf((*ArrayOfHostSslThumbprintInfo)(nil)).Elem()
}

type ArrayOfHostStorageArrayTypePolicyOption struct {
	HostStorageArrayTypePolicyOption []HostStorageArrayTypePolicyOption `xml:"HostStorageArrayTypePolicyOption,omitempty"`
}

func init() {
	t["ArrayOfHostStorageArrayTypePolicyOption"] = reflect.TypeOf((*ArrayOfHostStorageArrayTypePolicyOption)(nil)).Elem()
}

type ArrayOfHostStorageElementInfo struct {
	HostStorageElementInfo []HostStorageElementInfo `xml:"HostStorageElementInfo,omitempty"`
}

func init() {
	t["ArrayOfHostStorageElementInfo"] = reflect.TypeOf((*ArrayOfHostStorageElementInfo)(nil)).Elem()
}

type ArrayOfHostStorageOperationalInfo struct {
	HostStorageOperationalInfo []HostStorageOperationalInfo `xml:"HostStorageOperationalInfo,omitempty"`
}

func init() {
	t["ArrayOfHostStorageOperationalInfo"] = reflect.TypeOf((*ArrayOfHostStorageOperationalInfo)(nil)).Elem()
}

type ArrayOfHostSystemIdentificationInfo struct {
	HostSystemIdentificationInfo []HostSystemIdentificationInfo `xml:"HostSystemIdentificationInfo,omitempty"`
}

func init() {
	t["ArrayOfHostSystemIdentificationInfo"] = reflect.TypeOf((*ArrayOfHostSystemIdentificationInfo)(nil)).Elem()
}

type ArrayOfHostSystemResourceInfo struct {
	HostSystemResourceInfo []HostSystemResourceInfo `xml:"HostSystemResourceInfo,omitempty"`
}

func init() {
	t["ArrayOfHostSystemResourceInfo"] = reflect.TypeOf((*ArrayOfHostSystemResourceInfo)(nil)).Elem()
}

type ArrayOfHostSystemSwapConfigurationSystemSwapOption struct {
	HostSystemSwapConfigurationSystemSwapOption []BaseHostSystemSwapConfigurationSystemSwapOption `xml:"HostSystemSwapConfigurationSystemSwapOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostSystemSwapConfigurationSystemSwapOption"] = reflect.TypeOf((*ArrayOfHostSystemSwapConfigurationSystemSwapOption)(nil)).Elem()
}

type ArrayOfHostTpmDigestInfo struct {
	HostTpmDigestInfo []HostTpmDigestInfo `xml:"HostTpmDigestInfo,omitempty"`
}

func init() {
	t["ArrayOfHostTpmDigestInfo"] = reflect.TypeOf((*ArrayOfHostTpmDigestInfo)(nil)).Elem()
}

type ArrayOfHostTpmEventLogEntry struct {
	HostTpmEventLogEntry []HostTpmEventLogEntry `xml:"HostTpmEventLogEntry,omitempty"`
}

func init() {
	t["ArrayOfHostTpmEventLogEntry"] = reflect.TypeOf((*ArrayOfHostTpmEventLogEntry)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsExtent struct {
	HostUnresolvedVmfsExtent []HostUnresolvedVmfsExtent `xml:"HostUnresolvedVmfsExtent,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsExtent"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsExtent)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsResolutionResult struct {
	HostUnresolvedVmfsResolutionResult []HostUnresolvedVmfsResolutionResult `xml:"HostUnresolvedVmfsResolutionResult,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsResolutionResult"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsResolutionResult)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsResolutionSpec struct {
	HostUnresolvedVmfsResolutionSpec []HostUnresolvedVmfsResolutionSpec `xml:"HostUnresolvedVmfsResolutionSpec,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsResolutionSpec"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsResolutionSpec)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsVolume struct {
	HostUnresolvedVmfsVolume []HostUnresolvedVmfsVolume `xml:"HostUnresolvedVmfsVolume,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsVolume"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsVolume)(nil)).Elem()
}

type ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption struct {
	HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption []HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption `xml:"HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption,omitempty"`
}

func init() {
	t["ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption"] = reflect.TypeOf((*ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption)(nil)).Elem()
}

type ArrayOfHostVMotionCompatibility struct {
	HostVMotionCompatibility []HostVMotionCompatibility `xml:"HostVMotionCompatibility,omitempty"`
}

func init() {
	t["ArrayOfHostVMotionCompatibility"] = reflect.TypeOf((*ArrayOfHostVMotionCompatibility)(nil)).Elem()
}

type ArrayOfHostVirtualNic struct {
	HostVirtualNic []HostVirtualNic `xml:"HostVirtualNic,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualNic"] = reflect.TypeOf((*ArrayOfHostVirtualNic)(nil)).Elem()
}

type ArrayOfHostVirtualNicConfig struct {
	HostVirtualNicConfig []HostVirtualNicConfig `xml:"HostVirtualNicConfig,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualNicConfig"] = reflect.TypeOf((*ArrayOfHostVirtualNicConfig)(nil)).Elem()
}

type ArrayOfHostVirtualNicManagerNicTypeSelection struct {
	HostVirtualNicManagerNicTypeSelection []HostVirtualNicManagerNicTypeSelection `xml:"HostVirtualNicManagerNicTypeSelection,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualNicManagerNicTypeSelection"] = reflect.TypeOf((*ArrayOfHostVirtualNicManagerNicTypeSelection)(nil)).Elem()
}

type ArrayOfHostVirtualSwitch struct {
	HostVirtualSwitch []HostVirtualSwitch `xml:"HostVirtualSwitch,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualSwitch"] = reflect.TypeOf((*ArrayOfHostVirtualSwitch)(nil)).Elem()
}

type ArrayOfHostVirtualSwitchConfig struct {
	HostVirtualSwitchConfig []HostVirtualSwitchConfig `xml:"HostVirtualSwitchConfig,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualSwitchConfig"] = reflect.TypeOf((*ArrayOfHostVirtualSwitchConfig)(nil)).Elem()
}

type ArrayOfHostVmciAccessManagerAccessSpec struct {
	HostVmciAccessManagerAccessSpec []HostVmciAccessManagerAccessSpec `xml:"HostVmciAccessManagerAccessSpec,omitempty"`
}

func init() {
	t["ArrayOfHostVmciAccessManagerAccessSpec"] = reflect.TypeOf((*ArrayOfHostVmciAccessManagerAccessSpec)(nil)).Elem()
}

type ArrayOfHostVmfsRescanResult struct {
	HostVmfsRescanResult []HostVmfsRescanResult `xml:"HostVmfsRescanResult,omitempty"`
}

func init() {
	t["ArrayOfHostVmfsRescanResult"] = reflect.TypeOf((*ArrayOfHostVmfsRescanResult)(nil)).Elem()
}

type ArrayOfHostVsanInternalSystemCmmdsQuery struct {
	HostVsanInternalSystemCmmdsQuery []HostVsanInternalSystemCmmdsQuery `xml:"HostVsanInternalSystemCmmdsQuery,omitempty"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemCmmdsQuery"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemCmmdsQuery)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseDatastoreLeaseInfo struct {
	HttpNfcLeaseDatastoreLeaseInfo []HttpNfcLeaseDatastoreLeaseInfo `xml:"HttpNfcLeaseDatastoreLeaseInfo,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseDatastoreLeaseInfo"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseDatastoreLeaseInfo)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseDeviceUrl struct {
	HttpNfcLeaseDeviceUrl []HttpNfcLeaseDeviceUrl `xml:"HttpNfcLeaseDeviceUrl,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseDeviceUrl"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseDeviceUrl)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseHostInfo struct {
	HttpNfcLeaseHostInfo []HttpNfcLeaseHostInfo `xml:"HttpNfcLeaseHostInfo,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseHostInfo"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseHostInfo)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseManifestEntry struct {
	HttpNfcLeaseManifestEntry []HttpNfcLeaseManifestEntry `xml:"HttpNfcLeaseManifestEntry,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseManifestEntry"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseManifestEntry)(nil)).Elem()
}

type ArrayOfImportOperationBulkFaultFaultOnImport struct {
	ImportOperationBulkFaultFaultOnImport []ImportOperationBulkFaultFaultOnImport `xml:"ImportOperationBulkFaultFaultOnImport,omitempty"`
}

func init() {
	t["ArrayOfImportOperationBulkFaultFaultOnImport"] = reflect.TypeOf((*ArrayOfImportOperationBulkFaultFaultOnImport)(nil)).Elem()
}

type ArrayOfImportSpec struct {
	ImportSpec []BaseImportSpec `xml:"ImportSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfImportSpec"] = reflect.TypeOf((*ArrayOfImportSpec)(nil)).Elem()
}

type ArrayOfInt struct {
	Int []int `xml:"int,omitempty"`
}

func init() {
	t["ArrayOfInt"] = reflect.TypeOf((*ArrayOfInt)(nil)).Elem()
}

type ArrayOfIpPool struct {
	IpPool []IpPool `xml:"IpPool,omitempty"`
}

func init() {
	t["ArrayOfIpPool"] = reflect.TypeOf((*ArrayOfIpPool)(nil)).Elem()
}

type ArrayOfIpPoolAssociation struct {
	IpPoolAssociation []IpPoolAssociation `xml:"IpPoolAssociation,omitempty"`
}

func init() {
	t["ArrayOfIpPoolAssociation"] = reflect.TypeOf((*ArrayOfIpPoolAssociation)(nil)).Elem()
}

type ArrayOfIpPoolManagerIpAllocation struct {
	IpPoolManagerIpAllocation []IpPoolManagerIpAllocation `xml:"IpPoolManagerIpAllocation,omitempty"`
}

func init() {
	t["ArrayOfIpPoolManagerIpAllocation"] = reflect.TypeOf((*ArrayOfIpPoolManagerIpAllocation)(nil)).Elem()
}

type ArrayOfIscsiDependencyEntity struct {
	IscsiDependencyEntity []IscsiDependencyEntity `xml:"IscsiDependencyEntity,omitempty"`
}

func init() {
	t["ArrayOfIscsiDependencyEntity"] = reflect.TypeOf((*ArrayOfIscsiDependencyEntity)(nil)).Elem()
}

type ArrayOfIscsiPortInfo struct {
	IscsiPortInfo []IscsiPortInfo `xml:"IscsiPortInfo,omitempty"`
}

func init() {
	t["ArrayOfIscsiPortInfo"] = reflect.TypeOf((*ArrayOfIscsiPortInfo)(nil)).Elem()
}

type ArrayOfKernelModuleInfo struct {
	KernelModuleInfo []KernelModuleInfo `xml:"KernelModuleInfo,omitempty"`
}

func init() {
	t["ArrayOfKernelModuleInfo"] = reflect.TypeOf((*ArrayOfKernelModuleInfo)(nil)).Elem()
}

type ArrayOfKeyAnyValue struct {
	KeyAnyValue []KeyAnyValue `xml:"KeyAnyValue,omitempty"`
}

func init() {
	t["ArrayOfKeyAnyValue"] = reflect.TypeOf((*ArrayOfKeyAnyValue)(nil)).Elem()
}

type ArrayOfKeyValue struct {
	KeyValue []KeyValue `xml:"KeyValue,omitempty"`
}

func init() {
	t["ArrayOfKeyValue"] = reflect.TypeOf((*ArrayOfKeyValue)(nil)).Elem()
}

type ArrayOfLicenseAssignmentManagerLicenseAssignment struct {
	LicenseAssignmentManagerLicenseAssignment []LicenseAssignmentManagerLicenseAssignment `xml:"LicenseAssignmentManagerLicenseAssignment,omitempty"`
}

func init() {
	t["ArrayOfLicenseAssignmentManagerLicenseAssignment"] = reflect.TypeOf((*ArrayOfLicenseAssignmentManagerLicenseAssignment)(nil)).Elem()
}

type ArrayOfLicenseAvailabilityInfo struct {
	LicenseAvailabilityInfo []LicenseAvailabilityInfo `xml:"LicenseAvailabilityInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseAvailabilityInfo"] = reflect.TypeOf((*ArrayOfLicenseAvailabilityInfo)(nil)).Elem()
}

type ArrayOfLicenseFeatureInfo struct {
	LicenseFeatureInfo []LicenseFeatureInfo `xml:"LicenseFeatureInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseFeatureInfo"] = reflect.TypeOf((*ArrayOfLicenseFeatureInfo)(nil)).Elem()
}

type ArrayOfLicenseManagerLicenseInfo struct {
	LicenseManagerLicenseInfo []LicenseManagerLicenseInfo `xml:"LicenseManagerLicenseInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseManagerLicenseInfo"] = reflect.TypeOf((*ArrayOfLicenseManagerLicenseInfo)(nil)).Elem()
}

type ArrayOfLicenseReservationInfo struct {
	LicenseReservationInfo []LicenseReservationInfo `xml:"LicenseReservationInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseReservationInfo"] = reflect.TypeOf((*ArrayOfLicenseReservationInfo)(nil)).Elem()
}

type ArrayOfLocalizableMessage struct {
	LocalizableMessage []LocalizableMessage `xml:"LocalizableMessage,omitempty"`
}

func init() {
	t["ArrayOfLocalizableMessage"] = reflect.TypeOf((*ArrayOfLocalizableMessage)(nil)).Elem()
}

type ArrayOfLocalizationManagerMessageCatalog struct {
	LocalizationManagerMessageCatalog []LocalizationManagerMessageCatalog `xml:"LocalizationManagerMessageCatalog,omitempty"`
}

func init() {
	t["ArrayOfLocalizationManagerMessageCatalog"] = reflect.TypeOf((*ArrayOfLocalizationManagerMessageCatalog)(nil)).Elem()
}

type ArrayOfLong struct {
	Long []int64 `xml:"long,omitempty"`
}

func init() {
	t["ArrayOfLong"] = reflect.TypeOf((*ArrayOfLong)(nil)).Elem()
}

type ArrayOfManagedObjectReference struct {
	ManagedObjectReference []ManagedObjectReference `xml:"ManagedObjectReference,omitempty"`
}

func init() {
	t["ArrayOfManagedObjectReference"] = reflect.TypeOf((*ArrayOfManagedObjectReference)(nil)).Elem()
}

type ArrayOfMethodActionArgument struct {
	MethodActionArgument []MethodActionArgument `xml:"MethodActionArgument,omitempty"`
}

func init() {
	t["ArrayOfMethodActionArgument"] = reflect.TypeOf((*ArrayOfMethodActionArgument)(nil)).Elem()
}

type ArrayOfMethodFault struct {
	MethodFault []BaseMethodFault `xml:"MethodFault,omitempty,typeattr"`
}

func init() {
	t["ArrayOfMethodFault"] = reflect.TypeOf((*ArrayOfMethodFault)(nil)).Elem()
}

type ArrayOfMissingObject struct {
	MissingObject []MissingObject `xml:"MissingObject,omitempty"`
}

func init() {
	t["ArrayOfMissingObject"] = reflect.TypeOf((*ArrayOfMissingObject)(nil)).Elem()
}

type ArrayOfMissingProperty struct {
	MissingProperty []MissingProperty `xml:"MissingProperty,omitempty"`
}

func init() {
	t["ArrayOfMissingProperty"] = reflect.TypeOf((*ArrayOfMissingProperty)(nil)).Elem()
}

type ArrayOfMultipleCertificatesVerifyFaultThumbprintData struct {
	MultipleCertificatesVerifyFaultThumbprintData []MultipleCertificatesVerifyFaultThumbprintData `xml:"MultipleCertificatesVerifyFaultThumbprintData,omitempty"`
}

func init() {
	t["ArrayOfMultipleCertificatesVerifyFaultThumbprintData"] = reflect.TypeOf((*ArrayOfMultipleCertificatesVerifyFaultThumbprintData)(nil)).Elem()
}

type ArrayOfNasStorageProfile struct {
	NasStorageProfile []NasStorageProfile `xml:"NasStorageProfile,omitempty"`
}

func init() {
	t["ArrayOfNasStorageProfile"] = reflect.TypeOf((*ArrayOfNasStorageProfile)(nil)).Elem()
}

type ArrayOfNetIpConfigInfoIpAddress struct {
	NetIpConfigInfoIpAddress []NetIpConfigInfoIpAddress `xml:"NetIpConfigInfoIpAddress,omitempty"`
}

func init() {
	t["ArrayOfNetIpConfigInfoIpAddress"] = reflect.TypeOf((*ArrayOfNetIpConfigInfoIpAddress)(nil)).Elem()
}

type ArrayOfNetIpConfigSpecIpAddressSpec struct {
	NetIpConfigSpecIpAddressSpec []NetIpConfigSpecIpAddressSpec `xml:"NetIpConfigSpecIpAddressSpec,omitempty"`
}

func init() {
	t["ArrayOfNetIpConfigSpecIpAddressSpec"] = reflect.TypeOf((*ArrayOfNetIpConfigSpecIpAddressSpec)(nil)).Elem()
}

type ArrayOfNetIpRouteConfigInfoIpRoute struct {
	NetIpRouteConfigInfoIpRoute []NetIpRouteConfigInfoIpRoute `xml:"NetIpRouteConfigInfoIpRoute,omitempty"`
}

func init() {
	t["ArrayOfNetIpRouteConfigInfoIpRoute"] = reflect.TypeOf((*ArrayOfNetIpRouteConfigInfoIpRoute)(nil)).Elem()
}

type ArrayOfNetIpRouteConfigSpecIpRouteSpec struct {
	NetIpRouteConfigSpecIpRouteSpec []NetIpRouteConfigSpecIpRouteSpec `xml:"NetIpRouteConfigSpecIpRouteSpec,omitempty"`
}

func init() {
	t["ArrayOfNetIpRouteConfigSpecIpRouteSpec"] = reflect.TypeOf((*ArrayOfNetIpRouteConfigSpecIpRouteSpec)(nil)).Elem()
}

type ArrayOfNetIpStackInfoDefaultRouter struct {
	NetIpStackInfoDefaultRouter []NetIpStackInfoDefaultRouter `xml:"NetIpStackInfoDefaultRouter,omitempty"`
}

func init() {
	t["ArrayOfNetIpStackInfoDefaultRouter"] = reflect.TypeOf((*ArrayOfNetIpStackInfoDefaultRouter)(nil)).Elem()
}

type ArrayOfNetIpStackInfoNetToMedia struct {
	NetIpStackInfoNetToMedia []NetIpStackInfoNetToMedia `xml:"NetIpStackInfoNetToMedia,omitempty"`
}

func init() {
	t["ArrayOfNetIpStackInfoNetToMedia"] = reflect.TypeOf((*ArrayOfNetIpStackInfoNetToMedia)(nil)).Elem()
}

type ArrayOfNetStackInstanceProfile struct {
	NetStackInstanceProfile []NetStackInstanceProfile `xml:"NetStackInstanceProfile,omitempty"`
}

func init() {
	t["ArrayOfNetStackInstanceProfile"] = reflect.TypeOf((*ArrayOfNetStackInstanceProfile)(nil)).Elem()
}

type ArrayOfNumericRange struct {
	NumericRange []NumericRange `xml:"NumericRange,omitempty"`
}

func init() {
	t["ArrayOfNumericRange"] = reflect.TypeOf((*ArrayOfNumericRange)(nil)).Elem()
}

type ArrayOfObjectContent struct {
	ObjectContent []ObjectContent `xml:"ObjectContent,omitempty"`
}

func init() {
	t["ArrayOfObjectContent"] = reflect.TypeOf((*ArrayOfObjectContent)(nil)).Elem()
}

type ArrayOfObjectSpec struct {
	ObjectSpec []ObjectSpec `xml:"ObjectSpec,omitempty"`
}

func init() {
	t["ArrayOfObjectSpec"] = reflect.TypeOf((*ArrayOfObjectSpec)(nil)).Elem()
}

type ArrayOfObjectUpdate struct {
	ObjectUpdate []ObjectUpdate `xml:"ObjectUpdate,omitempty"`
}

func init() {
	t["ArrayOfObjectUpdate"] = reflect.TypeOf((*ArrayOfObjectUpdate)(nil)).Elem()
}

type ArrayOfOpaqueNetworkTargetInfo struct {
	OpaqueNetworkTargetInfo []OpaqueNetworkTargetInfo `xml:"OpaqueNetworkTargetInfo,omitempty"`
}

func init() {
	t["ArrayOfOpaqueNetworkTargetInfo"] = reflect.TypeOf((*ArrayOfOpaqueNetworkTargetInfo)(nil)).Elem()
}

type ArrayOfOptionDef struct {
	OptionDef []OptionDef `xml:"OptionDef,omitempty"`
}

func init() {
	t["ArrayOfOptionDef"] = reflect.TypeOf((*ArrayOfOptionDef)(nil)).Elem()
}

type ArrayOfOptionProfile struct {
	OptionProfile []OptionProfile `xml:"OptionProfile,omitempty"`
}

func init() {
	t["ArrayOfOptionProfile"] = reflect.TypeOf((*ArrayOfOptionProfile)(nil)).Elem()
}

type ArrayOfOptionValue struct {
	OptionValue []BaseOptionValue `xml:"OptionValue,omitempty,typeattr"`
}

func init() {
	t["ArrayOfOptionValue"] = reflect.TypeOf((*ArrayOfOptionValue)(nil)).Elem()
}

type ArrayOfOvfConsumerOstNode struct {
	OvfConsumerOstNode []OvfConsumerOstNode `xml:"OvfConsumerOstNode,omitempty"`
}

func init() {
	t["ArrayOfOvfConsumerOstNode"] = reflect.TypeOf((*ArrayOfOvfConsumerOstNode)(nil)).Elem()
}

type ArrayOfOvfConsumerOvfSection struct {
	OvfConsumerOvfSection []OvfConsumerOvfSection `xml:"OvfConsumerOvfSection,omitempty"`
}

func init() {
	t["ArrayOfOvfConsumerOvfSection"] = reflect.TypeOf((*ArrayOfOvfConsumerOvfSection)(nil)).Elem()
}

type ArrayOfOvfDeploymentOption struct {
	OvfDeploymentOption []OvfDeploymentOption `xml:"OvfDeploymentOption,omitempty"`
}

func init() {
	t["ArrayOfOvfDeploymentOption"] = reflect.TypeOf((*ArrayOfOvfDeploymentOption)(nil)).Elem()
}

type ArrayOfOvfFile struct {
	OvfFile []OvfFile `xml:"OvfFile,omitempty"`
}

func init() {
	t["ArrayOfOvfFile"] = reflect.TypeOf((*ArrayOfOvfFile)(nil)).Elem()
}

type ArrayOfOvfFileItem struct {
	OvfFileItem []OvfFileItem `xml:"OvfFileItem,omitempty"`
}

func init() {
	t["ArrayOfOvfFileItem"] = reflect.TypeOf((*ArrayOfOvfFileItem)(nil)).Elem()
}

type ArrayOfOvfNetworkInfo struct {
	OvfNetworkInfo []OvfNetworkInfo `xml:"OvfNetworkInfo,omitempty"`
}

func init() {
	t["ArrayOfOvfNetworkInfo"] = reflect.TypeOf((*ArrayOfOvfNetworkInfo)(nil)).Elem()
}

type ArrayOfOvfNetworkMapping struct {
	OvfNetworkMapping []OvfNetworkMapping `xml:"OvfNetworkMapping,omitempty"`
}

func init() {
	t["ArrayOfOvfNetworkMapping"] = reflect.TypeOf((*ArrayOfOvfNetworkMapping)(nil)).Elem()
}

type ArrayOfOvfOptionInfo struct {
	OvfOptionInfo []OvfOptionInfo `xml:"OvfOptionInfo,omitempty"`
}

func init() {
	t["ArrayOfOvfOptionInfo"] = reflect.TypeOf((*ArrayOfOvfOptionInfo)(nil)).Elem()
}

type ArrayOfOvfResourceMap struct {
	OvfResourceMap []OvfResourceMap `xml:"OvfResourceMap,omitempty"`
}

func init() {
	t["ArrayOfOvfResourceMap"] = reflect.TypeOf((*ArrayOfOvfResourceMap)(nil)).Elem()
}

type ArrayOfPerfCounterInfo struct {
	PerfCounterInfo []PerfCounterInfo `xml:"PerfCounterInfo,omitempty"`
}

func init() {
	t["ArrayOfPerfCounterInfo"] = reflect.TypeOf((*ArrayOfPerfCounterInfo)(nil)).Elem()
}

type ArrayOfPerfEntityMetricBase struct {
	PerfEntityMetricBase []BasePerfEntityMetricBase `xml:"PerfEntityMetricBase,omitempty,typeattr"`
}

func init() {
	t["ArrayOfPerfEntityMetricBase"] = reflect.TypeOf((*ArrayOfPerfEntityMetricBase)(nil)).Elem()
}

type ArrayOfPerfInterval struct {
	PerfInterval []PerfInterval `xml:"PerfInterval,omitempty"`
}

func init() {
	t["ArrayOfPerfInterval"] = reflect.TypeOf((*ArrayOfPerfInterval)(nil)).Elem()
}

type ArrayOfPerfMetricId struct {
	PerfMetricId []PerfMetricId `xml:"PerfMetricId,omitempty"`
}

func init() {
	t["ArrayOfPerfMetricId"] = reflect.TypeOf((*ArrayOfPerfMetricId)(nil)).Elem()
}

type ArrayOfPerfMetricSeries struct {
	PerfMetricSeries []BasePerfMetricSeries `xml:"PerfMetricSeries,omitempty,typeattr"`
}

func init() {
	t["ArrayOfPerfMetricSeries"] = reflect.TypeOf((*ArrayOfPerfMetricSeries)(nil)).Elem()
}

type ArrayOfPerfMetricSeriesCSV struct {
	PerfMetricSeriesCSV []PerfMetricSeriesCSV `xml:"PerfMetricSeriesCSV,omitempty"`
}

func init() {
	t["ArrayOfPerfMetricSeriesCSV"] = reflect.TypeOf((*ArrayOfPerfMetricSeriesCSV)(nil)).Elem()
}

type ArrayOfPerfQuerySpec struct {
	PerfQuerySpec []PerfQuerySpec `xml:"PerfQuerySpec,omitempty"`
}

func init() {
	t["ArrayOfPerfQuerySpec"] = reflect.TypeOf((*ArrayOfPerfQuerySpec)(nil)).Elem()
}

type ArrayOfPerfSampleInfo struct {
	PerfSampleInfo []PerfSampleInfo `xml:"PerfSampleInfo,omitempty"`
}

func init() {
	t["ArrayOfPerfSampleInfo"] = reflect.TypeOf((*ArrayOfPerfSampleInfo)(nil)).Elem()
}

type ArrayOfPerformanceManagerCounterLevelMapping struct {
	PerformanceManagerCounterLevelMapping []PerformanceManagerCounterLevelMapping `xml:"PerformanceManagerCounterLevelMapping,omitempty"`
}

func init() {
	t["ArrayOfPerformanceManagerCounterLevelMapping"] = reflect.TypeOf((*ArrayOfPerformanceManagerCounterLevelMapping)(nil)).Elem()
}

type ArrayOfPermission struct {
	Permission []Permission `xml:"Permission,omitempty"`
}

func init() {
	t["ArrayOfPermission"] = reflect.TypeOf((*ArrayOfPermission)(nil)).Elem()
}

type ArrayOfPermissionProfile struct {
	PermissionProfile []PermissionProfile `xml:"PermissionProfile,omitempty"`
}

func init() {
	t["ArrayOfPermissionProfile"] = reflect.TypeOf((*ArrayOfPermissionProfile)(nil)).Elem()
}

type ArrayOfPhysicalNic struct {
	PhysicalNic []PhysicalNic `xml:"PhysicalNic,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNic"] = reflect.TypeOf((*ArrayOfPhysicalNic)(nil)).Elem()
}

type ArrayOfPhysicalNicConfig struct {
	PhysicalNicConfig []PhysicalNicConfig `xml:"PhysicalNicConfig,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicConfig"] = reflect.TypeOf((*ArrayOfPhysicalNicConfig)(nil)).Elem()
}

type ArrayOfPhysicalNicHintInfo struct {
	PhysicalNicHintInfo []PhysicalNicHintInfo `xml:"PhysicalNicHintInfo,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicHintInfo"] = reflect.TypeOf((*ArrayOfPhysicalNicHintInfo)(nil)).Elem()
}

type ArrayOfPhysicalNicIpHint struct {
	PhysicalNicIpHint []PhysicalNicIpHint `xml:"PhysicalNicIpHint,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicIpHint"] = reflect.TypeOf((*ArrayOfPhysicalNicIpHint)(nil)).Elem()
}

type ArrayOfPhysicalNicLinkInfo struct {
	PhysicalNicLinkInfo []PhysicalNicLinkInfo `xml:"PhysicalNicLinkInfo,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicLinkInfo"] = reflect.TypeOf((*ArrayOfPhysicalNicLinkInfo)(nil)).Elem()
}

type ArrayOfPhysicalNicNameHint struct {
	PhysicalNicNameHint []PhysicalNicNameHint `xml:"PhysicalNicNameHint,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicNameHint"] = reflect.TypeOf((*ArrayOfPhysicalNicNameHint)(nil)).Elem()
}

type ArrayOfPhysicalNicProfile struct {
	PhysicalNicProfile []PhysicalNicProfile `xml:"PhysicalNicProfile,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicProfile"] = reflect.TypeOf((*ArrayOfPhysicalNicProfile)(nil)).Elem()
}

type ArrayOfPnicUplinkProfile struct {
	PnicUplinkProfile []PnicUplinkProfile `xml:"PnicUplinkProfile,omitempty"`
}

func init() {
	t["ArrayOfPnicUplinkProfile"] = reflect.TypeOf((*ArrayOfPnicUplinkProfile)(nil)).Elem()
}

type ArrayOfPodDiskLocator struct {
	PodDiskLocator []PodDiskLocator `xml:"PodDiskLocator,omitempty"`
}

func init() {
	t["ArrayOfPodDiskLocator"] = reflect.TypeOf((*ArrayOfPodDiskLocator)(nil)).Elem()
}

type ArrayOfPolicyOption struct {
	PolicyOption []BasePolicyOption `xml:"PolicyOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfPolicyOption"] = reflect.TypeOf((*ArrayOfPolicyOption)(nil)).Elem()
}

type ArrayOfPrivilegeAvailability struct {
	PrivilegeAvailability []PrivilegeAvailability `xml:"PrivilegeAvailability,omitempty"`
}

func init() {
	t["ArrayOfPrivilegeAvailability"] = reflect.TypeOf((*ArrayOfPrivilegeAvailability)(nil)).Elem()
}

type ArrayOfProductComponentInfo struct {
	ProductComponentInfo []ProductComponentInfo `xml:"ProductComponentInfo,omitempty"`
}

func init() {
	t["ArrayOfProductComponentInfo"] = reflect.TypeOf((*ArrayOfProductComponentInfo)(nil)).Elem()
}

type ArrayOfProfileApplyProfileProperty struct {
	ProfileApplyProfileProperty []ProfileApplyProfileProperty `xml:"ProfileApplyProfileProperty,omitempty"`
}

func init() {
	t["ArrayOfProfileApplyProfileProperty"] = reflect.TypeOf((*ArrayOfProfileApplyProfileProperty)(nil)).Elem()
}

type ArrayOfProfileDeferredPolicyOptionParameter struct {
	ProfileDeferredPolicyOptionParameter []ProfileDeferredPolicyOptionParameter `xml:"ProfileDeferredPolicyOptionParameter,omitempty"`
}

func init() {
	t["ArrayOfProfileDeferredPolicyOptionParameter"] = reflect.TypeOf((*ArrayOfProfileDeferredPolicyOptionParameter)(nil)).Elem()
}

type ArrayOfProfileDescriptionSection struct {
	ProfileDescriptionSection []ProfileDescriptionSection `xml:"ProfileDescriptionSection,omitempty"`
}

func init() {
	t["ArrayOfProfileDescriptionSection"] = reflect.TypeOf((*ArrayOfProfileDescriptionSection)(nil)).Elem()
}

type ArrayOfProfileExecuteError struct {
	ProfileExecuteError []ProfileExecuteError `xml:"ProfileExecuteError,omitempty"`
}

func init() {
	t["ArrayOfProfileExecuteError"] = reflect.TypeOf((*ArrayOfProfileExecuteError)(nil)).Elem()
}

type ArrayOfProfileExpression struct {
	ProfileExpression []BaseProfileExpression `xml:"ProfileExpression,omitempty,typeattr"`
}

func init() {
	t["ArrayOfProfileExpression"] = reflect.TypeOf((*ArrayOfProfileExpression)(nil)).Elem()
}

type ArrayOfProfileExpressionMetadata struct {
	ProfileExpressionMetadata []ProfileExpressionMetadata `xml:"ProfileExpressionMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfileExpressionMetadata"] = reflect.TypeOf((*ArrayOfProfileExpressionMetadata)(nil)).Elem()
}

type ArrayOfProfileMetadata struct {
	ProfileMetadata []ProfileMetadata `xml:"ProfileMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfileMetadata"] = reflect.TypeOf((*ArrayOfProfileMetadata)(nil)).Elem()
}

type ArrayOfProfileMetadataProfileSortSpec struct {
	ProfileMetadataProfileSortSpec []ProfileMetadataProfileSortSpec `xml:"ProfileMetadataProfileSortSpec,omitempty"`
}

func init() {
	t["ArrayOfProfileMetadataProfileSortSpec"] = reflect.TypeOf((*ArrayOfProfileMetadataProfileSortSpec)(nil)).Elem()
}

type ArrayOfProfileParameterMetadata struct {
	ProfileParameterMetadata []ProfileParameterMetadata `xml:"ProfileParameterMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfileParameterMetadata"] = reflect.TypeOf((*ArrayOfProfileParameterMetadata)(nil)).Elem()
}

type ArrayOfProfilePolicy struct {
	ProfilePolicy []ProfilePolicy `xml:"ProfilePolicy,omitempty"`
}

func init() {
	t["ArrayOfProfilePolicy"] = reflect.TypeOf((*ArrayOfProfilePolicy)(nil)).Elem()
}

type ArrayOfProfilePolicyMetadata struct {
	ProfilePolicyMetadata []ProfilePolicyMetadata `xml:"ProfilePolicyMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfilePolicyMetadata"] = reflect.TypeOf((*ArrayOfProfilePolicyMetadata)(nil)).Elem()
}

type ArrayOfProfilePolicyOptionMetadata struct {
	ProfilePolicyOptionMetadata []BaseProfilePolicyOptionMetadata `xml:"ProfilePolicyOptionMetadata,omitempty,typeattr"`
}

func init() {
	t["ArrayOfProfilePolicyOptionMetadata"] = reflect.TypeOf((*ArrayOfProfilePolicyOptionMetadata)(nil)).Elem()
}

type ArrayOfProfileProfileStructureProperty struct {
	ProfileProfileStructureProperty []ProfileProfileStructureProperty `xml:"ProfileProfileStructureProperty,omitempty"`
}

func init() {
	t["ArrayOfProfileProfileStructureProperty"] = reflect.TypeOf((*ArrayOfProfileProfileStructureProperty)(nil)).Elem()
}

type ArrayOfProfilePropertyPath struct {
	ProfilePropertyPath []ProfilePropertyPath `xml:"ProfilePropertyPath,omitempty"`
}

func init() {
	t["ArrayOfProfilePropertyPath"] = reflect.TypeOf((*ArrayOfProfilePropertyPath)(nil)).Elem()
}

type ArrayOfProfileUpdateFailedUpdateFailure struct {
	ProfileUpdateFailedUpdateFailure []ProfileUpdateFailedUpdateFailure `xml:"ProfileUpdateFailedUpdateFailure,omitempty"`
}

func init() {
	t["ArrayOfProfileUpdateFailedUpdateFailure"] = reflect.TypeOf((*ArrayOfProfileUpdateFailedUpdateFailure)(nil)).Elem()
}

type ArrayOfPropertyChange struct {
	PropertyChange []PropertyChange `xml:"PropertyChange,omitempty"`
}

func init() {
	t["ArrayOfPropertyChange"] = reflect.TypeOf((*ArrayOfPropertyChange)(nil)).Elem()
}

type ArrayOfPropertyFilterSpec struct {
	PropertyFilterSpec []PropertyFilterSpec `xml:"PropertyFilterSpec,omitempty"`
}

func init() {
	t["ArrayOfPropertyFilterSpec"] = reflect.TypeOf((*ArrayOfPropertyFilterSpec)(nil)).Elem()
}

type ArrayOfPropertyFilterUpdate struct {
	PropertyFilterUpdate []PropertyFilterUpdate `xml:"PropertyFilterUpdate,omitempty"`
}

func init() {
	t["ArrayOfPropertyFilterUpdate"] = reflect.TypeOf((*ArrayOfPropertyFilterUpdate)(nil)).Elem()
}

type ArrayOfPropertySpec struct {
	PropertySpec []PropertySpec `xml:"PropertySpec,omitempty"`
}

func init() {
	t["ArrayOfPropertySpec"] = reflect.TypeOf((*ArrayOfPropertySpec)(nil)).Elem()
}

type ArrayOfReplicationInfoDiskSettings struct {
	ReplicationInfoDiskSettings []ReplicationInfoDiskSettings `xml:"ReplicationInfoDiskSettings,omitempty"`
}

func init() {
	t["ArrayOfReplicationInfoDiskSettings"] = reflect.TypeOf((*ArrayOfReplicationInfoDiskSettings)(nil)).Elem()
}

type ArrayOfResourceConfigSpec struct {
	ResourceConfigSpec []ResourceConfigSpec `xml:"ResourceConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfResourceConfigSpec"] = reflect.TypeOf((*ArrayOfResourceConfigSpec)(nil)).Elem()
}

type ArrayOfScheduledTaskDetail struct {
	ScheduledTaskDetail []ScheduledTaskDetail `xml:"ScheduledTaskDetail,omitempty"`
}

func init() {
	t["ArrayOfScheduledTaskDetail"] = reflect.TypeOf((*ArrayOfScheduledTaskDetail)(nil)).Elem()
}

type ArrayOfScsiLun struct {
	ScsiLun []BaseScsiLun `xml:"ScsiLun,omitempty,typeattr"`
}

func init() {
	t["ArrayOfScsiLun"] = reflect.TypeOf((*ArrayOfScsiLun)(nil)).Elem()
}

type ArrayOfScsiLunDescriptor struct {
	ScsiLunDescriptor []ScsiLunDescriptor `xml:"ScsiLunDescriptor,omitempty"`
}

func init() {
	t["ArrayOfScsiLunDescriptor"] = reflect.TypeOf((*ArrayOfScsiLunDescriptor)(nil)).Elem()
}

type ArrayOfScsiLunDurableName struct {
	ScsiLunDurableName []ScsiLunDurableName `xml:"ScsiLunDurableName,omitempty"`
}

func init() {
	t["ArrayOfScsiLunDurableName"] = reflect.TypeOf((*ArrayOfScsiLunDurableName)(nil)).Elem()
}

type ArrayOfSelectionSet struct {
	SelectionSet []BaseSelectionSet `xml:"SelectionSet,omitempty,typeattr"`
}

func init() {
	t["ArrayOfSelectionSet"] = reflect.TypeOf((*ArrayOfSelectionSet)(nil)).Elem()
}

type ArrayOfSelectionSpec struct {
	SelectionSpec []BaseSelectionSpec `xml:"SelectionSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfSelectionSpec"] = reflect.TypeOf((*ArrayOfSelectionSpec)(nil)).Elem()
}

type ArrayOfServiceConsolePortGroupProfile struct {
	ServiceConsolePortGroupProfile []ServiceConsolePortGroupProfile `xml:"ServiceConsolePortGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfServiceConsolePortGroupProfile"] = reflect.TypeOf((*ArrayOfServiceConsolePortGroupProfile)(nil)).Elem()
}

type ArrayOfServiceManagerServiceInfo struct {
	ServiceManagerServiceInfo []ServiceManagerServiceInfo `xml:"ServiceManagerServiceInfo,omitempty"`
}

func init() {
	t["ArrayOfServiceManagerServiceInfo"] = reflect.TypeOf((*ArrayOfServiceManagerServiceInfo)(nil)).Elem()
}

type ArrayOfServiceProfile struct {
	ServiceProfile []ServiceProfile `xml:"ServiceProfile,omitempty"`
}

func init() {
	t["ArrayOfServiceProfile"] = reflect.TypeOf((*ArrayOfServiceProfile)(nil)).Elem()
}

type ArrayOfShort struct {
	Short []int16 `xml:"short,omitempty"`
}

func init() {
	t["ArrayOfShort"] = reflect.TypeOf((*ArrayOfShort)(nil)).Elem()
}

type ArrayOfStaticRouteProfile struct {
	StaticRouteProfile []StaticRouteProfile `xml:"StaticRouteProfile,omitempty"`
}

func init() {
	t["ArrayOfStaticRouteProfile"] = reflect.TypeOf((*ArrayOfStaticRouteProfile)(nil)).Elem()
}

type ArrayOfStorageDrsOptionSpec struct {
	StorageDrsOptionSpec []StorageDrsOptionSpec `xml:"StorageDrsOptionSpec,omitempty"`
}

func init() {
	t["ArrayOfStorageDrsOptionSpec"] = reflect.TypeOf((*ArrayOfStorageDrsOptionSpec)(nil)).Elem()
}

type ArrayOfStorageDrsVmConfigInfo struct {
	StorageDrsVmConfigInfo []StorageDrsVmConfigInfo `xml:"StorageDrsVmConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfStorageDrsVmConfigInfo"] = reflect.TypeOf((*ArrayOfStorageDrsVmConfigInfo)(nil)).Elem()
}

type ArrayOfStorageDrsVmConfigSpec struct {
	StorageDrsVmConfigSpec []StorageDrsVmConfigSpec `xml:"StorageDrsVmConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfStorageDrsVmConfigSpec"] = reflect.TypeOf((*ArrayOfStorageDrsVmConfigSpec)(nil)).Elem()
}

type ArrayOfStoragePerformanceSummary struct {
	StoragePerformanceSummary []StoragePerformanceSummary `xml:"StoragePerformanceSummary,omitempty"`
}

func init() {
	t["ArrayOfStoragePerformanceSummary"] = reflect.TypeOf((*ArrayOfStoragePerformanceSummary)(nil)).Elem()
}

type ArrayOfStorageRequirement struct {
	StorageRequirement []StorageRequirement `xml:"StorageRequirement,omitempty"`
}

func init() {
	t["ArrayOfStorageRequirement"] = reflect.TypeOf((*ArrayOfStorageRequirement)(nil)).Elem()
}

type ArrayOfString struct {
	String []string `xml:"string,omitempty"`
}

func init() {
	t["ArrayOfString"] = reflect.TypeOf((*ArrayOfString)(nil)).Elem()
}

type ArrayOfTag struct {
	Tag []Tag `xml:"Tag,omitempty"`
}

func init() {
	t["ArrayOfTag"] = reflect.TypeOf((*ArrayOfTag)(nil)).Elem()
}

type ArrayOfTaskInfo struct {
	TaskInfo []TaskInfo `xml:"TaskInfo,omitempty"`
}

func init() {
	t["ArrayOfTaskInfo"] = reflect.TypeOf((*ArrayOfTaskInfo)(nil)).Elem()
}

type ArrayOfTaskInfoState struct {
	TaskInfoState []TaskInfoState `xml:"TaskInfoState,omitempty"`
}

func init() {
	t["ArrayOfTaskInfoState"] = reflect.TypeOf((*ArrayOfTaskInfoState)(nil)).Elem()
}

type ArrayOfTypeDescription struct {
	TypeDescription []BaseTypeDescription `xml:"TypeDescription,omitempty,typeattr"`
}

func init() {
	t["ArrayOfTypeDescription"] = reflect.TypeOf((*ArrayOfTypeDescription)(nil)).Elem()
}

type ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo struct {
	UpdateVirtualMachineFilesResultFailedVmFileInfo []UpdateVirtualMachineFilesResultFailedVmFileInfo `xml:"UpdateVirtualMachineFilesResultFailedVmFileInfo,omitempty"`
}

func init() {
	t["ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo"] = reflect.TypeOf((*ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo)(nil)).Elem()
}

type ArrayOfUserGroupProfile struct {
	UserGroupProfile []UserGroupProfile `xml:"UserGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfUserGroupProfile"] = reflect.TypeOf((*ArrayOfUserGroupProfile)(nil)).Elem()
}

type ArrayOfUserProfile struct {
	UserProfile []UserProfile `xml:"UserProfile,omitempty"`
}

func init() {
	t["ArrayOfUserProfile"] = reflect.TypeOf((*ArrayOfUserProfile)(nil)).Elem()
}

type ArrayOfUserSearchResult struct {
	UserSearchResult []BaseUserSearchResult `xml:"UserSearchResult,omitempty,typeattr"`
}

func init() {
	t["ArrayOfUserSearchResult"] = reflect.TypeOf((*ArrayOfUserSearchResult)(nil)).Elem()
}

type ArrayOfUserSession struct {
	UserSession []UserSession `xml:"UserSession,omitempty"`
}

func init() {
	t["ArrayOfUserSession"] = reflect.TypeOf((*ArrayOfUserSession)(nil)).Elem()
}

type ArrayOfVAppCloneSpecNetworkMappingPair struct {
	VAppCloneSpecNetworkMappingPair []VAppCloneSpecNetworkMappingPair `xml:"VAppCloneSpecNetworkMappingPair,omitempty"`
}

func init() {
	t["ArrayOfVAppCloneSpecNetworkMappingPair"] = reflect.TypeOf((*ArrayOfVAppCloneSpecNetworkMappingPair)(nil)).Elem()
}

type ArrayOfVAppCloneSpecResourceMap struct {
	VAppCloneSpecResourceMap []VAppCloneSpecResourceMap `xml:"VAppCloneSpecResourceMap,omitempty"`
}

func init() {
	t["ArrayOfVAppCloneSpecResourceMap"] = reflect.TypeOf((*ArrayOfVAppCloneSpecResourceMap)(nil)).Elem()
}

type ArrayOfVAppEntityConfigInfo struct {
	VAppEntityConfigInfo []VAppEntityConfigInfo `xml:"VAppEntityConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppEntityConfigInfo"] = reflect.TypeOf((*ArrayOfVAppEntityConfigInfo)(nil)).Elem()
}

type ArrayOfVAppOvfSectionInfo struct {
	VAppOvfSectionInfo []VAppOvfSectionInfo `xml:"VAppOvfSectionInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppOvfSectionInfo"] = reflect.TypeOf((*ArrayOfVAppOvfSectionInfo)(nil)).Elem()
}

type ArrayOfVAppOvfSectionSpec struct {
	VAppOvfSectionSpec []VAppOvfSectionSpec `xml:"VAppOvfSectionSpec,omitempty"`
}

func init() {
	t["ArrayOfVAppOvfSectionSpec"] = reflect.TypeOf((*ArrayOfVAppOvfSectionSpec)(nil)).Elem()
}

type ArrayOfVAppProductInfo struct {
	VAppProductInfo []VAppProductInfo `xml:"VAppProductInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppProductInfo"] = reflect.TypeOf((*ArrayOfVAppProductInfo)(nil)).Elem()
}

type ArrayOfVAppProductSpec struct {
	VAppProductSpec []VAppProductSpec `xml:"VAppProductSpec,omitempty"`
}

func init() {
	t["ArrayOfVAppProductSpec"] = reflect.TypeOf((*ArrayOfVAppProductSpec)(nil)).Elem()
}

type ArrayOfVAppPropertyInfo struct {
	VAppPropertyInfo []VAppPropertyInfo `xml:"VAppPropertyInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppPropertyInfo"] = reflect.TypeOf((*ArrayOfVAppPropertyInfo)(nil)).Elem()
}

type ArrayOfVAppPropertySpec struct {
	VAppPropertySpec []VAppPropertySpec `xml:"VAppPropertySpec,omitempty"`
}

func init() {
	t["ArrayOfVAppPropertySpec"] = reflect.TypeOf((*ArrayOfVAppPropertySpec)(nil)).Elem()
}

type ArrayOfVMwareDVSPvlanConfigSpec struct {
	VMwareDVSPvlanConfigSpec []VMwareDVSPvlanConfigSpec `xml:"VMwareDVSPvlanConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfVMwareDVSPvlanConfigSpec"] = reflect.TypeOf((*ArrayOfVMwareDVSPvlanConfigSpec)(nil)).Elem()
}

type ArrayOfVMwareDVSPvlanMapEntry struct {
	VMwareDVSPvlanMapEntry []VMwareDVSPvlanMapEntry `xml:"VMwareDVSPvlanMapEntry,omitempty"`
}

func init() {
	t["ArrayOfVMwareDVSPvlanMapEntry"] = reflect.TypeOf((*ArrayOfVMwareDVSPvlanMapEntry)(nil)).Elem()
}

type ArrayOfVMwareDVSVspanConfigSpec struct {
	VMwareDVSVspanConfigSpec []VMwareDVSVspanConfigSpec `xml:"VMwareDVSVspanConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfVMwareDVSVspanConfigSpec"] = reflect.TypeOf((*ArrayOfVMwareDVSVspanConfigSpec)(nil)).Elem()
}

type ArrayOfVMwareDvsLacpGroupConfig struct {
	VMwareDvsLacpGroupConfig []VMwareDvsLacpGroupConfig `xml:"VMwareDvsLacpGroupConfig,omitempty"`
}

func init() {
	t["ArrayOfVMwareDvsLacpGroupConfig"] = reflect.TypeOf((*ArrayOfVMwareDvsLacpGroupConfig)(nil)).Elem()
}

type ArrayOfVMwareDvsLacpGroupSpec struct {
	VMwareDvsLacpGroupSpec []VMwareDvsLacpGroupSpec `xml:"VMwareDvsLacpGroupSpec,omitempty"`
}

func init() {
	t["ArrayOfVMwareDvsLacpGroupSpec"] = reflect.TypeOf((*ArrayOfVMwareDvsLacpGroupSpec)(nil)).Elem()
}

type ArrayOfVMwareVspanSession struct {
	VMwareVspanSession []VMwareVspanSession `xml:"VMwareVspanSession,omitempty"`
}

func init() {
	t["ArrayOfVMwareVspanSession"] = reflect.TypeOf((*ArrayOfVMwareVspanSession)(nil)).Elem()
}

type ArrayOfVirtualAppLinkInfo struct {
	VirtualAppLinkInfo []VirtualAppLinkInfo `xml:"VirtualAppLinkInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualAppLinkInfo"] = reflect.TypeOf((*ArrayOfVirtualAppLinkInfo)(nil)).Elem()
}

type ArrayOfVirtualDevice struct {
	VirtualDevice []BaseVirtualDevice `xml:"VirtualDevice,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDevice"] = reflect.TypeOf((*ArrayOfVirtualDevice)(nil)).Elem()
}

type ArrayOfVirtualDeviceBackingOption struct {
	VirtualDeviceBackingOption []BaseVirtualDeviceBackingOption `xml:"VirtualDeviceBackingOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDeviceBackingOption"] = reflect.TypeOf((*ArrayOfVirtualDeviceBackingOption)(nil)).Elem()
}

type ArrayOfVirtualDeviceConfigSpec struct {
	VirtualDeviceConfigSpec []BaseVirtualDeviceConfigSpec `xml:"VirtualDeviceConfigSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDeviceConfigSpec"] = reflect.TypeOf((*ArrayOfVirtualDeviceConfigSpec)(nil)).Elem()
}

type ArrayOfVirtualDeviceOption struct {
	VirtualDeviceOption []BaseVirtualDeviceOption `xml:"VirtualDeviceOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDeviceOption"] = reflect.TypeOf((*ArrayOfVirtualDeviceOption)(nil)).Elem()
}

type ArrayOfVirtualDisk struct {
	VirtualDisk []VirtualDisk `xml:"VirtualDisk,omitempty"`
}

func init() {
	t["ArrayOfVirtualDisk"] = reflect.TypeOf((*ArrayOfVirtualDisk)(nil)).Elem()
}

type ArrayOfVirtualDiskDeltaDiskFormatsSupported struct {
	VirtualDiskDeltaDiskFormatsSupported []VirtualDiskDeltaDiskFormatsSupported `xml:"VirtualDiskDeltaDiskFormatsSupported,omitempty"`
}

func init() {
	t["ArrayOfVirtualDiskDeltaDiskFormatsSupported"] = reflect.TypeOf((*ArrayOfVirtualDiskDeltaDiskFormatsSupported)(nil)).Elem()
}

type ArrayOfVirtualMachineBootOptionsBootableDevice struct {
	VirtualMachineBootOptionsBootableDevice []BaseVirtualMachineBootOptionsBootableDevice `xml:"VirtualMachineBootOptionsBootableDevice,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachineBootOptionsBootableDevice"] = reflect.TypeOf((*ArrayOfVirtualMachineBootOptionsBootableDevice)(nil)).Elem()
}

type ArrayOfVirtualMachineCdromInfo struct {
	VirtualMachineCdromInfo []VirtualMachineCdromInfo `xml:"VirtualMachineCdromInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineCdromInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineCdromInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineConfigInfoDatastoreUrlPair struct {
	VirtualMachineConfigInfoDatastoreUrlPair []VirtualMachineConfigInfoDatastoreUrlPair `xml:"VirtualMachineConfigInfoDatastoreUrlPair,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineConfigInfoDatastoreUrlPair"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigInfoDatastoreUrlPair)(nil)).Elem()
}

type ArrayOfVirtualMachineConfigOptionDescriptor struct {
	VirtualMachineConfigOptionDescriptor []VirtualMachineConfigOptionDescriptor `xml:"VirtualMachineConfigOptionDescriptor,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineConfigOptionDescriptor"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigOptionDescriptor)(nil)).Elem()
}

type ArrayOfVirtualMachineCpuIdInfoSpec struct {
	VirtualMachineCpuIdInfoSpec []VirtualMachineCpuIdInfoSpec `xml:"VirtualMachineCpuIdInfoSpec,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineCpuIdInfoSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineCpuIdInfoSpec)(nil)).Elem()
}

type ArrayOfVirtualMachineDatastoreInfo struct {
	VirtualMachineDatastoreInfo []VirtualMachineDatastoreInfo `xml:"VirtualMachineDatastoreInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDatastoreInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDatastoreInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineDatastoreVolumeOption struct {
	VirtualMachineDatastoreVolumeOption []VirtualMachineDatastoreVolumeOption `xml:"VirtualMachineDatastoreVolumeOption,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDatastoreVolumeOption"] = reflect.TypeOf((*ArrayOfVirtualMachineDatastoreVolumeOption)(nil)).Elem()
}

type ArrayOfVirtualMachineDeviceRuntimeInfo struct {
	VirtualMachineDeviceRuntimeInfo []VirtualMachineDeviceRuntimeInfo `xml:"VirtualMachineDeviceRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDeviceRuntimeInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDeviceRuntimeInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineDisplayTopology struct {
	VirtualMachineDisplayTopology []VirtualMachineDisplayTopology `xml:"VirtualMachineDisplayTopology,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDisplayTopology"] = reflect.TypeOf((*ArrayOfVirtualMachineDisplayTopology)(nil)).Elem()
}

type ArrayOfVirtualMachineFeatureRequirement struct {
	VirtualMachineFeatureRequirement []VirtualMachineFeatureRequirement `xml:"VirtualMachineFeatureRequirement,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFeatureRequirement"] = reflect.TypeOf((*ArrayOfVirtualMachineFeatureRequirement)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutDiskLayout struct {
	VirtualMachineFileLayoutDiskLayout []VirtualMachineFileLayoutDiskLayout `xml:"VirtualMachineFileLayoutDiskLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutDiskLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutDiskLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExDiskLayout struct {
	VirtualMachineFileLayoutExDiskLayout []VirtualMachineFileLayoutExDiskLayout `xml:"VirtualMachineFileLayoutExDiskLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExDiskLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExDiskLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExDiskUnit struct {
	VirtualMachineFileLayoutExDiskUnit []VirtualMachineFileLayoutExDiskUnit `xml:"VirtualMachineFileLayoutExDiskUnit,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExDiskUnit"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExDiskUnit)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExFileInfo struct {
	VirtualMachineFileLayoutExFileInfo []VirtualMachineFileLayoutExFileInfo `xml:"VirtualMachineFileLayoutExFileInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExFileInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExFileInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExSnapshotLayout struct {
	VirtualMachineFileLayoutExSnapshotLayout []VirtualMachineFileLayoutExSnapshotLayout `xml:"VirtualMachineFileLayoutExSnapshotLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExSnapshotLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExSnapshotLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutSnapshotLayout struct {
	VirtualMachineFileLayoutSnapshotLayout []VirtualMachineFileLayoutSnapshotLayout `xml:"VirtualMachineFileLayoutSnapshotLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutSnapshotLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutSnapshotLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFloppyInfo struct {
	VirtualMachineFloppyInfo []VirtualMachineFloppyInfo `xml:"VirtualMachineFloppyInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFloppyInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineFloppyInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineIdeDiskDeviceInfo struct {
	VirtualMachineIdeDiskDeviceInfo []VirtualMachineIdeDiskDeviceInfo `xml:"VirtualMachineIdeDiskDeviceInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineIdeDiskDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineIdeDiskDeviceInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineIdeDiskDevicePartitionInfo struct {
	VirtualMachineIdeDiskDevicePartitionInfo []VirtualMachineIdeDiskDevicePartitionInfo `xml:"VirtualMachineIdeDiskDevicePartitionInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineIdeDiskDevicePartitionInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineIdeDiskDevicePartitionInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineLegacyNetworkSwitchInfo struct {
	VirtualMachineLegacyNetworkSwitchInfo []VirtualMachineLegacyNetworkSwitchInfo `xml:"VirtualMachineLegacyNetworkSwitchInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineLegacyNetworkSwitchInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineLegacyNetworkSwitchInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineMessage struct {
	VirtualMachineMessage []VirtualMachineMessage `xml:"VirtualMachineMessage,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineMessage"] = reflect.TypeOf((*ArrayOfVirtualMachineMessage)(nil)).Elem()
}

type ArrayOfVirtualMachineMetadataManagerVmMetadataInput struct {
	VirtualMachineMetadataManagerVmMetadataInput []VirtualMachineMetadataManagerVmMetadataInput `xml:"VirtualMachineMetadataManagerVmMetadataInput,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineMetadataManagerVmMetadataInput"] = reflect.TypeOf((*ArrayOfVirtualMachineMetadataManagerVmMetadataInput)(nil)).Elem()
}

type ArrayOfVirtualMachineMetadataManagerVmMetadataResult struct {
	VirtualMachineMetadataManagerVmMetadataResult []VirtualMachineMetadataManagerVmMetadataResult `xml:"VirtualMachineMetadataManagerVmMetadataResult,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineMetadataManagerVmMetadataResult"] = reflect.TypeOf((*ArrayOfVirtualMachineMetadataManagerVmMetadataResult)(nil)).Elem()
}

type ArrayOfVirtualMachineNetworkInfo struct {
	VirtualMachineNetworkInfo []VirtualMachineNetworkInfo `xml:"VirtualMachineNetworkInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineNetworkInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineNetworkInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineParallelInfo struct {
	VirtualMachineParallelInfo []VirtualMachineParallelInfo `xml:"VirtualMachineParallelInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineParallelInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineParallelInfo)(nil)).Elem()
}

type ArrayOfVirtualMachinePciPassthroughInfo struct {
	VirtualMachinePciPassthroughInfo []BaseVirtualMachinePciPassthroughInfo `xml:"VirtualMachinePciPassthroughInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachinePciPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachinePciPassthroughInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineProfileSpec struct {
	VirtualMachineProfileSpec []BaseVirtualMachineProfileSpec `xml:"VirtualMachineProfileSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachineProfileSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineProfileSpec)(nil)).Elem()
}

type ArrayOfVirtualMachineRelocateSpecDiskLocator struct {
	VirtualMachineRelocateSpecDiskLocator []VirtualMachineRelocateSpecDiskLocator `xml:"VirtualMachineRelocateSpecDiskLocator,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineRelocateSpecDiskLocator"] = reflect.TypeOf((*ArrayOfVirtualMachineRelocateSpecDiskLocator)(nil)).Elem()
}

type ArrayOfVirtualMachineScsiDiskDeviceInfo struct {
	VirtualMachineScsiDiskDeviceInfo []VirtualMachineScsiDiskDeviceInfo `xml:"VirtualMachineScsiDiskDeviceInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineScsiDiskDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineScsiDiskDeviceInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineScsiPassthroughInfo struct {
	VirtualMachineScsiPassthroughInfo []VirtualMachineScsiPassthroughInfo `xml:"VirtualMachineScsiPassthroughInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineScsiPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineScsiPassthroughInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSerialInfo struct {
	VirtualMachineSerialInfo []VirtualMachineSerialInfo `xml:"VirtualMachineSerialInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSerialInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSerialInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSnapshotTree struct {
	VirtualMachineSnapshotTree []VirtualMachineSnapshotTree `xml:"VirtualMachineSnapshotTree,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSnapshotTree"] = reflect.TypeOf((*ArrayOfVirtualMachineSnapshotTree)(nil)).Elem()
}

type ArrayOfVirtualMachineSoundInfo struct {
	VirtualMachineSoundInfo []VirtualMachineSoundInfo `xml:"VirtualMachineSoundInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSoundInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSoundInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSriovInfo struct {
	VirtualMachineSriovInfo []VirtualMachineSriovInfo `xml:"VirtualMachineSriovInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSriovInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSriovInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSummary struct {
	VirtualMachineSummary []VirtualMachineSummary `xml:"VirtualMachineSummary,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSummary"] = reflect.TypeOf((*ArrayOfVirtualMachineSummary)(nil)).Elem()
}

type ArrayOfVirtualMachineUsageOnDatastore struct {
	VirtualMachineUsageOnDatastore []VirtualMachineUsageOnDatastore `xml:"VirtualMachineUsageOnDatastore,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineUsageOnDatastore"] = reflect.TypeOf((*ArrayOfVirtualMachineUsageOnDatastore)(nil)).Elem()
}

type ArrayOfVirtualMachineUsbInfo struct {
	VirtualMachineUsbInfo []VirtualMachineUsbInfo `xml:"VirtualMachineUsbInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineUsbInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineUsbInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineVFlashModuleInfo struct {
	VirtualMachineVFlashModuleInfo []VirtualMachineVFlashModuleInfo `xml:"VirtualMachineVFlashModuleInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineVFlashModuleInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVFlashModuleInfo)(nil)).Elem()
}

type ArrayOfVirtualNicManagerNetConfig struct {
	VirtualNicManagerNetConfig []VirtualNicManagerNetConfig `xml:"VirtualNicManagerNetConfig,omitempty"`
}

func init() {
	t["ArrayOfVirtualNicManagerNetConfig"] = reflect.TypeOf((*ArrayOfVirtualNicManagerNetConfig)(nil)).Elem()
}

type ArrayOfVirtualSCSISharing struct {
	VirtualSCSISharing []VirtualSCSISharing `xml:"VirtualSCSISharing,omitempty"`
}

func init() {
	t["ArrayOfVirtualSCSISharing"] = reflect.TypeOf((*ArrayOfVirtualSCSISharing)(nil)).Elem()
}

type ArrayOfVirtualSwitchProfile struct {
	VirtualSwitchProfile []VirtualSwitchProfile `xml:"VirtualSwitchProfile,omitempty"`
}

func init() {
	t["ArrayOfVirtualSwitchProfile"] = reflect.TypeOf((*ArrayOfVirtualSwitchProfile)(nil)).Elem()
}

type ArrayOfVmEventArgument struct {
	VmEventArgument []VmEventArgument `xml:"VmEventArgument,omitempty"`
}

func init() {
	t["ArrayOfVmEventArgument"] = reflect.TypeOf((*ArrayOfVmEventArgument)(nil)).Elem()
}

type ArrayOfVmPodConfigForPlacement struct {
	VmPodConfigForPlacement []VmPodConfigForPlacement `xml:"VmPodConfigForPlacement,omitempty"`
}

func init() {
	t["ArrayOfVmPodConfigForPlacement"] = reflect.TypeOf((*ArrayOfVmPodConfigForPlacement)(nil)).Elem()
}

type ArrayOfVmPortGroupProfile struct {
	VmPortGroupProfile []VmPortGroupProfile `xml:"VmPortGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfVmPortGroupProfile"] = reflect.TypeOf((*ArrayOfVmPortGroupProfile)(nil)).Elem()
}

type ArrayOfVmfsDatastoreOption struct {
	VmfsDatastoreOption []VmfsDatastoreOption `xml:"VmfsDatastoreOption,omitempty"`
}

func init() {
	t["ArrayOfVmfsDatastoreOption"] = reflect.TypeOf((*ArrayOfVmfsDatastoreOption)(nil)).Elem()
}

type ArrayOfVnicPortArgument struct {
	VnicPortArgument []VnicPortArgument `xml:"VnicPortArgument,omitempty"`
}

func init() {
	t["ArrayOfVnicPortArgument"] = reflect.TypeOf((*ArrayOfVnicPortArgument)(nil)).Elem()
}

type ArrayOfVsanHostConfigInfo struct {
	VsanHostConfigInfo []VsanHostConfigInfo `xml:"VsanHostConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfVsanHostConfigInfo"] = reflect.TypeOf((*ArrayOfVsanHostConfigInfo)(nil)).Elem()
}

type ArrayOfVsanHostConfigInfoNetworkInfoPortConfig struct {
	VsanHostConfigInfoNetworkInfoPortConfig []VsanHostConfigInfoNetworkInfoPortConfig `xml:"VsanHostConfigInfoNetworkInfoPortConfig,omitempty"`
}

func init() {
	t["ArrayOfVsanHostConfigInfoNetworkInfoPortConfig"] = reflect.TypeOf((*ArrayOfVsanHostConfigInfoNetworkInfoPortConfig)(nil)).Elem()
}

type ArrayOfVsanHostDiskMapResult struct {
	VsanHostDiskMapResult []VsanHostDiskMapResult `xml:"VsanHostDiskMapResult,omitempty"`
}

func init() {
	t["ArrayOfVsanHostDiskMapResult"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapResult)(nil)).Elem()
}

type ArrayOfVsanHostDiskMapping struct {
	VsanHostDiskMapping []VsanHostDiskMapping `xml:"VsanHostDiskMapping,omitempty"`
}

func init() {
	t["ArrayOfVsanHostDiskMapping"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapping)(nil)).Elem()
}

type ArrayOfVsanHostDiskResult struct {
	VsanHostDiskResult []VsanHostDiskResult `xml:"VsanHostDiskResult,omitempty"`
}

func init() {
	t["ArrayOfVsanHostDiskResult"] = reflect.TypeOf((*ArrayOfVsanHostDiskResult)(nil)).Elem()
}

type ArrayOfVsanHostMembershipInfo struct {
	VsanHostMembershipInfo []VsanHostMembershipInfo `xml:"VsanHostMembershipInfo,omitempty"`
}

func init() {
	t["ArrayOfVsanHostMembershipInfo"] = reflect.TypeOf((*ArrayOfVsanHostMembershipInfo)(nil)).Elem()
}

type ArrayOfVsanHostRuntimeInfoDiskIssue struct {
	VsanHostRuntimeInfoDiskIssue []VsanHostRuntimeInfoDiskIssue `xml:"VsanHostRuntimeInfoDiskIssue,omitempty"`
}

func init() {
	t["ArrayOfVsanHostRuntimeInfoDiskIssue"] = reflect.TypeOf((*ArrayOfVsanHostRuntimeInfoDiskIssue)(nil)).Elem()
}

type ArrayUpdateSpec struct {
	DynamicData

	Operation ArrayUpdateOperation `xml:"operation"`
	RemoveKey AnyType              `xml:"removeKey,omitempty,typeattr"`
}

func init() {
	t["ArrayUpdateSpec"] = reflect.TypeOf((*ArrayUpdateSpec)(nil)).Elem()
}

type AssignUserToGroup AssignUserToGroupRequestType

func init() {
	t["AssignUserToGroup"] = reflect.TypeOf((*AssignUserToGroup)(nil)).Elem()
}

type AssignUserToGroupRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	User  string                 `xml:"user"`
	Group string                 `xml:"group"`
}

func init() {
	t["AssignUserToGroupRequestType"] = reflect.TypeOf((*AssignUserToGroupRequestType)(nil)).Elem()
}

type AssignUserToGroupResponse struct {
}

type AssociateProfile AssociateProfileRequestType

func init() {
	t["AssociateProfile"] = reflect.TypeOf((*AssociateProfile)(nil)).Elem()
}

type AssociateProfileRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity"`
}

func init() {
	t["AssociateProfileRequestType"] = reflect.TypeOf((*AssociateProfileRequestType)(nil)).Elem()
}

type AssociateProfileResponse struct {
}

type AttachScsiLun AttachScsiLunRequestType

func init() {
	t["AttachScsiLun"] = reflect.TypeOf((*AttachScsiLun)(nil)).Elem()
}

type AttachScsiLunRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid string                 `xml:"lunUuid"`
}

func init() {
	t["AttachScsiLunRequestType"] = reflect.TypeOf((*AttachScsiLunRequestType)(nil)).Elem()
}

type AttachScsiLunResponse struct {
}

type AttachVmfsExtent AttachVmfsExtentRequestType

func init() {
	t["AttachVmfsExtent"] = reflect.TypeOf((*AttachVmfsExtent)(nil)).Elem()
}

type AttachVmfsExtentRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsPath string                 `xml:"vmfsPath"`
	Extent   HostScsiDiskPartition  `xml:"extent"`
}

func init() {
	t["AttachVmfsExtentRequestType"] = reflect.TypeOf((*AttachVmfsExtentRequestType)(nil)).Elem()
}

type AttachVmfsExtentResponse struct {
}

type AuthMinimumAdminPermission struct {
	VimFault
}

func init() {
	t["AuthMinimumAdminPermission"] = reflect.TypeOf((*AuthMinimumAdminPermission)(nil)).Elem()
}

type AuthMinimumAdminPermissionFault AuthMinimumAdminPermission

func init() {
	t["AuthMinimumAdminPermissionFault"] = reflect.TypeOf((*AuthMinimumAdminPermissionFault)(nil)).Elem()
}

type AuthenticationProfile struct {
	ApplyProfile

	ActiveDirectory *ActiveDirectoryProfile `xml:"activeDirectory,omitempty"`
}

func init() {
	t["AuthenticationProfile"] = reflect.TypeOf((*AuthenticationProfile)(nil)).Elem()
}

type AuthorizationDescription struct {
	DynamicData

	Privilege      []BaseElementDescription `xml:"privilege,typeattr"`
	PrivilegeGroup []BaseElementDescription `xml:"privilegeGroup,typeattr"`
}

func init() {
	t["AuthorizationDescription"] = reflect.TypeOf((*AuthorizationDescription)(nil)).Elem()
}

type AuthorizationEvent struct {
	Event
}

func init() {
	t["AuthorizationEvent"] = reflect.TypeOf((*AuthorizationEvent)(nil)).Elem()
}

type AuthorizationPrivilege struct {
	DynamicData

	PrivId        string `xml:"privId"`
	OnParent      bool   `xml:"onParent"`
	Name          string `xml:"name"`
	PrivGroupName string `xml:"privGroupName"`
}

func init() {
	t["AuthorizationPrivilege"] = reflect.TypeOf((*AuthorizationPrivilege)(nil)).Elem()
}

type AuthorizationRole struct {
	DynamicData

	RoleId    int             `xml:"roleId"`
	System    bool            `xml:"system"`
	Name      string          `xml:"name"`
	Info      BaseDescription `xml:"info,typeattr"`
	Privilege []string        `xml:"privilege,omitempty"`
}

func init() {
	t["AuthorizationRole"] = reflect.TypeOf((*AuthorizationRole)(nil)).Elem()
}

type AutoStartDefaults struct {
	DynamicData

	Enabled          *bool  `xml:"enabled"`
	StartDelay       int    `xml:"startDelay,omitempty"`
	StopDelay        int    `xml:"stopDelay,omitempty"`
	WaitForHeartbeat *bool  `xml:"waitForHeartbeat"`
	StopAction       string `xml:"stopAction,omitempty"`
}

func init() {
	t["AutoStartDefaults"] = reflect.TypeOf((*AutoStartDefaults)(nil)).Elem()
}

type AutoStartPowerInfo struct {
	DynamicData

	Key              ManagedObjectReference        `xml:"key"`
	StartOrder       int                           `xml:"startOrder"`
	StartDelay       int                           `xml:"startDelay"`
	WaitForHeartbeat AutoStartWaitHeartbeatSetting `xml:"waitForHeartbeat"`
	StartAction      string                        `xml:"startAction"`
	StopDelay        int                           `xml:"stopDelay"`
	StopAction       string                        `xml:"stopAction"`
}

func init() {
	t["AutoStartPowerInfo"] = reflect.TypeOf((*AutoStartPowerInfo)(nil)).Elem()
}

type AutoStartPowerOff AutoStartPowerOffRequestType

func init() {
	t["AutoStartPowerOff"] = reflect.TypeOf((*AutoStartPowerOff)(nil)).Elem()
}

type AutoStartPowerOffRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AutoStartPowerOffRequestType"] = reflect.TypeOf((*AutoStartPowerOffRequestType)(nil)).Elem()
}

type AutoStartPowerOffResponse struct {
}

type AutoStartPowerOn AutoStartPowerOnRequestType

func init() {
	t["AutoStartPowerOn"] = reflect.TypeOf((*AutoStartPowerOn)(nil)).Elem()
}

type AutoStartPowerOnRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AutoStartPowerOnRequestType"] = reflect.TypeOf((*AutoStartPowerOnRequestType)(nil)).Elem()
}

type AutoStartPowerOnResponse struct {
}

type BackupBlobReadFailure struct {
	DvsFault

	EntityName string               `xml:"entityName"`
	EntityType string               `xml:"entityType"`
	Fault      LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["BackupBlobReadFailure"] = reflect.TypeOf((*BackupBlobReadFailure)(nil)).Elem()
}

type BackupBlobReadFailureFault BackupBlobReadFailure

func init() {
	t["BackupBlobReadFailureFault"] = reflect.TypeOf((*BackupBlobReadFailureFault)(nil)).Elem()
}

type BackupBlobWriteFailure struct {
	DvsFault

	EntityName string               `xml:"entityName"`
	EntityType string               `xml:"entityType"`
	Fault      LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["BackupBlobWriteFailure"] = reflect.TypeOf((*BackupBlobWriteFailure)(nil)).Elem()
}

type BackupBlobWriteFailureFault BackupBlobWriteFailure

func init() {
	t["BackupBlobWriteFailureFault"] = reflect.TypeOf((*BackupBlobWriteFailureFault)(nil)).Elem()
}

type BackupFirmwareConfiguration BackupFirmwareConfigurationRequestType

func init() {
	t["BackupFirmwareConfiguration"] = reflect.TypeOf((*BackupFirmwareConfiguration)(nil)).Elem()
}

type BackupFirmwareConfigurationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["BackupFirmwareConfigurationRequestType"] = reflect.TypeOf((*BackupFirmwareConfigurationRequestType)(nil)).Elem()
}

type BackupFirmwareConfigurationResponse struct {
	Returnval string `xml:"returnval"`
}

type BadUsernameSessionEvent struct {
	SessionEvent

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["BadUsernameSessionEvent"] = reflect.TypeOf((*BadUsernameSessionEvent)(nil)).Elem()
}

type BindVnic BindVnicRequestType

func init() {
	t["BindVnic"] = reflect.TypeOf((*BindVnic)(nil)).Elem()
}

type BindVnicRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	IScsiHbaName string                 `xml:"iScsiHbaName"`
	VnicDevice   string                 `xml:"vnicDevice"`
}

func init() {
	t["BindVnicRequestType"] = reflect.TypeOf((*BindVnicRequestType)(nil)).Elem()
}

type BindVnicResponse struct {
}

type BlockedByFirewall struct {
	HostConfigFault
}

func init() {
	t["BlockedByFirewall"] = reflect.TypeOf((*BlockedByFirewall)(nil)).Elem()
}

type BlockedByFirewallFault BlockedByFirewall

func init() {
	t["BlockedByFirewallFault"] = reflect.TypeOf((*BlockedByFirewallFault)(nil)).Elem()
}

type BoolOption struct {
	OptionType

	Supported    bool `xml:"supported"`
	DefaultValue bool `xml:"defaultValue"`
}

func init() {
	t["BoolOption"] = reflect.TypeOf((*BoolOption)(nil)).Elem()
}

type BoolPolicy struct {
	InheritablePolicy

	Value *bool `xml:"value"`
}

func init() {
	t["BoolPolicy"] = reflect.TypeOf((*BoolPolicy)(nil)).Elem()
}

type BrowseDiagnosticLog BrowseDiagnosticLogRequestType

func init() {
	t["BrowseDiagnosticLog"] = reflect.TypeOf((*BrowseDiagnosticLog)(nil)).Elem()
}

type BrowseDiagnosticLogRequestType struct {
	This  ManagedObjectReference  `xml:"_this"`
	Host  *ManagedObjectReference `xml:"host,omitempty"`
	Key   string                  `xml:"key"`
	Start int                     `xml:"start,omitempty"`
	Lines int                     `xml:"lines,omitempty"`
}

func init() {
	t["BrowseDiagnosticLogRequestType"] = reflect.TypeOf((*BrowseDiagnosticLogRequestType)(nil)).Elem()
}

type BrowseDiagnosticLogResponse struct {
	Returnval DiagnosticManagerLogHeader `xml:"returnval"`
}

type CAMServerRefusedConnection struct {
	InvalidCAMServer
}

func init() {
	t["CAMServerRefusedConnection"] = reflect.TypeOf((*CAMServerRefusedConnection)(nil)).Elem()
}

type CAMServerRefusedConnectionFault CAMServerRefusedConnection

func init() {
	t["CAMServerRefusedConnectionFault"] = reflect.TypeOf((*CAMServerRefusedConnectionFault)(nil)).Elem()
}

type CancelRecommendation CancelRecommendationRequestType

func init() {
	t["CancelRecommendation"] = reflect.TypeOf((*CancelRecommendation)(nil)).Elem()
}

type CancelRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  string                 `xml:"key"`
}

func init() {
	t["CancelRecommendationRequestType"] = reflect.TypeOf((*CancelRecommendationRequestType)(nil)).Elem()
}

type CancelRecommendationResponse struct {
}

type CancelRetrievePropertiesEx CancelRetrievePropertiesExRequestType

func init() {
	t["CancelRetrievePropertiesEx"] = reflect.TypeOf((*CancelRetrievePropertiesEx)(nil)).Elem()
}

type CancelRetrievePropertiesExRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Token string                 `xml:"token"`
}

func init() {
	t["CancelRetrievePropertiesExRequestType"] = reflect.TypeOf((*CancelRetrievePropertiesExRequestType)(nil)).Elem()
}

type CancelRetrievePropertiesExResponse struct {
}

type CancelStorageDrsRecommendation CancelStorageDrsRecommendationRequestType

func init() {
	t["CancelStorageDrsRecommendation"] = reflect.TypeOf((*CancelStorageDrsRecommendation)(nil)).Elem()
}

type CancelStorageDrsRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  []string               `xml:"key"`
}

func init() {
	t["CancelStorageDrsRecommendationRequestType"] = reflect.TypeOf((*CancelStorageDrsRecommendationRequestType)(nil)).Elem()
}

type CancelStorageDrsRecommendationResponse struct {
}

type CancelTask CancelTaskRequestType

func init() {
	t["CancelTask"] = reflect.TypeOf((*CancelTask)(nil)).Elem()
}

type CancelTaskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CancelTaskRequestType"] = reflect.TypeOf((*CancelTaskRequestType)(nil)).Elem()
}

type CancelTaskResponse struct {
}

type CancelWaitForUpdates CancelWaitForUpdatesRequestType

func init() {
	t["CancelWaitForUpdates"] = reflect.TypeOf((*CancelWaitForUpdates)(nil)).Elem()
}

type CancelWaitForUpdatesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CancelWaitForUpdatesRequestType"] = reflect.TypeOf((*CancelWaitForUpdatesRequestType)(nil)).Elem()
}

type CancelWaitForUpdatesResponse struct {
}

type CanceledHostOperationEvent struct {
	HostEvent
}

func init() {
	t["CanceledHostOperationEvent"] = reflect.TypeOf((*CanceledHostOperationEvent)(nil)).Elem()
}

type CannotAccessFile struct {
	FileFault
}

func init() {
	t["CannotAccessFile"] = reflect.TypeOf((*CannotAccessFile)(nil)).Elem()
}

type CannotAccessFileFault CannotAccessFile

func init() {
	t["CannotAccessFileFault"] = reflect.TypeOf((*CannotAccessFileFault)(nil)).Elem()
}

type CannotAccessLocalSource struct {
	VimFault
}

func init() {
	t["CannotAccessLocalSource"] = reflect.TypeOf((*CannotAccessLocalSource)(nil)).Elem()
}

type CannotAccessLocalSourceFault CannotAccessLocalSource

func init() {
	t["CannotAccessLocalSourceFault"] = reflect.TypeOf((*CannotAccessLocalSourceFault)(nil)).Elem()
}

type CannotAccessNetwork struct {
	CannotAccessVmDevice
}

func init() {
	t["CannotAccessNetwork"] = reflect.TypeOf((*CannotAccessNetwork)(nil)).Elem()
}

type CannotAccessNetworkFault BaseCannotAccessNetwork

func init() {
	t["CannotAccessNetworkFault"] = reflect.TypeOf((*CannotAccessNetworkFault)(nil)).Elem()
}

type CannotAccessVmComponent struct {
	VmConfigFault
}

func init() {
	t["CannotAccessVmComponent"] = reflect.TypeOf((*CannotAccessVmComponent)(nil)).Elem()
}

type CannotAccessVmComponentFault BaseCannotAccessVmComponent

func init() {
	t["CannotAccessVmComponentFault"] = reflect.TypeOf((*CannotAccessVmComponentFault)(nil)).Elem()
}

type CannotAccessVmConfig struct {
	CannotAccessVmComponent

	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["CannotAccessVmConfig"] = reflect.TypeOf((*CannotAccessVmConfig)(nil)).Elem()
}

type CannotAccessVmConfigFault CannotAccessVmConfig

func init() {
	t["CannotAccessVmConfigFault"] = reflect.TypeOf((*CannotAccessVmConfigFault)(nil)).Elem()
}

type CannotAccessVmDevice struct {
	CannotAccessVmComponent

	Device    string `xml:"device"`
	Backing   string `xml:"backing"`
	Connected bool   `xml:"connected"`
}

func init() {
	t["CannotAccessVmDevice"] = reflect.TypeOf((*CannotAccessVmDevice)(nil)).Elem()
}

type CannotAccessVmDeviceFault BaseCannotAccessVmDevice

func init() {
	t["CannotAccessVmDeviceFault"] = reflect.TypeOf((*CannotAccessVmDeviceFault)(nil)).Elem()
}

type CannotAccessVmDisk struct {
	CannotAccessVmDevice

	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["CannotAccessVmDisk"] = reflect.TypeOf((*CannotAccessVmDisk)(nil)).Elem()
}

type CannotAccessVmDiskFault BaseCannotAccessVmDisk

func init() {
	t["CannotAccessVmDiskFault"] = reflect.TypeOf((*CannotAccessVmDiskFault)(nil)).Elem()
}

type CannotAddHostWithFTVmAsStandalone struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmAsStandalone"] = reflect.TypeOf((*CannotAddHostWithFTVmAsStandalone)(nil)).Elem()
}

type CannotAddHostWithFTVmAsStandaloneFault CannotAddHostWithFTVmAsStandalone

func init() {
	t["CannotAddHostWithFTVmAsStandaloneFault"] = reflect.TypeOf((*CannotAddHostWithFTVmAsStandaloneFault)(nil)).Elem()
}

type CannotAddHostWithFTVmToDifferentCluster struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmToDifferentCluster"] = reflect.TypeOf((*CannotAddHostWithFTVmToDifferentCluster)(nil)).Elem()
}

type CannotAddHostWithFTVmToDifferentClusterFault CannotAddHostWithFTVmToDifferentCluster

func init() {
	t["CannotAddHostWithFTVmToDifferentClusterFault"] = reflect.TypeOf((*CannotAddHostWithFTVmToDifferentClusterFault)(nil)).Elem()
}

type CannotAddHostWithFTVmToNonHACluster struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmToNonHACluster"] = reflect.TypeOf((*CannotAddHostWithFTVmToNonHACluster)(nil)).Elem()
}

type CannotAddHostWithFTVmToNonHAClusterFault CannotAddHostWithFTVmToNonHACluster

func init() {
	t["CannotAddHostWithFTVmToNonHAClusterFault"] = reflect.TypeOf((*CannotAddHostWithFTVmToNonHAClusterFault)(nil)).Elem()
}

type CannotChangeDrsBehaviorForFtSecondary struct {
	VmFaultToleranceIssue

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["CannotChangeDrsBehaviorForFtSecondary"] = reflect.TypeOf((*CannotChangeDrsBehaviorForFtSecondary)(nil)).Elem()
}

type CannotChangeDrsBehaviorForFtSecondaryFault CannotChangeDrsBehaviorForFtSecondary

func init() {
	t["CannotChangeDrsBehaviorForFtSecondaryFault"] = reflect.TypeOf((*CannotChangeDrsBehaviorForFtSecondaryFault)(nil)).Elem()
}

type CannotChangeHaSettingsForFtSecondary struct {
	VmFaultToleranceIssue

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["CannotChangeHaSettingsForFtSecondary"] = reflect.TypeOf((*CannotChangeHaSettingsForFtSecondary)(nil)).Elem()
}

type CannotChangeHaSettingsForFtSecondaryFault CannotChangeHaSettingsForFtSecondary

func init() {
	t["CannotChangeHaSettingsForFtSecondaryFault"] = reflect.TypeOf((*CannotChangeHaSettingsForFtSecondaryFault)(nil)).Elem()
}

type CannotChangeVsanClusterUuid struct {
	VsanFault
}

func init() {
	t["CannotChangeVsanClusterUuid"] = reflect.TypeOf((*CannotChangeVsanClusterUuid)(nil)).Elem()
}

type CannotChangeVsanClusterUuidFault CannotChangeVsanClusterUuid

func init() {
	t["CannotChangeVsanClusterUuidFault"] = reflect.TypeOf((*CannotChangeVsanClusterUuidFault)(nil)).Elem()
}

type CannotChangeVsanNodeUuid struct {
	VsanFault
}

func init() {
	t["CannotChangeVsanNodeUuid"] = reflect.TypeOf((*CannotChangeVsanNodeUuid)(nil)).Elem()
}

type CannotChangeVsanNodeUuidFault CannotChangeVsanNodeUuid

func init() {
	t["CannotChangeVsanNodeUuidFault"] = reflect.TypeOf((*CannotChangeVsanNodeUuidFault)(nil)).Elem()
}

type CannotCreateFile struct {
	FileFault
}

func init() {
	t["CannotCreateFile"] = reflect.TypeOf((*CannotCreateFile)(nil)).Elem()
}

type CannotCreateFileFault CannotCreateFile

func init() {
	t["CannotCreateFileFault"] = reflect.TypeOf((*CannotCreateFileFault)(nil)).Elem()
}

type CannotDecryptPasswords struct {
	CustomizationFault
}

func init() {
	t["CannotDecryptPasswords"] = reflect.TypeOf((*CannotDecryptPasswords)(nil)).Elem()
}

type CannotDecryptPasswordsFault CannotDecryptPasswords

func init() {
	t["CannotDecryptPasswordsFault"] = reflect.TypeOf((*CannotDecryptPasswordsFault)(nil)).Elem()
}

type CannotDeleteFile struct {
	FileFault
}

func init() {
	t["CannotDeleteFile"] = reflect.TypeOf((*CannotDeleteFile)(nil)).Elem()
}

type CannotDeleteFileFault CannotDeleteFile

func init() {
	t["CannotDeleteFileFault"] = reflect.TypeOf((*CannotDeleteFileFault)(nil)).Elem()
}

type CannotDisableDrsOnClustersWithVApps struct {
	RuntimeFault
}

func init() {
	t["CannotDisableDrsOnClustersWithVApps"] = reflect.TypeOf((*CannotDisableDrsOnClustersWithVApps)(nil)).Elem()
}

type CannotDisableDrsOnClustersWithVAppsFault CannotDisableDrsOnClustersWithVApps

func init() {
	t["CannotDisableDrsOnClustersWithVAppsFault"] = reflect.TypeOf((*CannotDisableDrsOnClustersWithVAppsFault)(nil)).Elem()
}

type CannotDisableSnapshot struct {
	VmConfigFault
}

func init() {
	t["CannotDisableSnapshot"] = reflect.TypeOf((*CannotDisableSnapshot)(nil)).Elem()
}

type CannotDisableSnapshotFault CannotDisableSnapshot

func init() {
	t["CannotDisableSnapshotFault"] = reflect.TypeOf((*CannotDisableSnapshotFault)(nil)).Elem()
}

type CannotDisconnectHostWithFaultToleranceVm struct {
	VimFault

	HostName string `xml:"hostName"`
}

func init() {
	t["CannotDisconnectHostWithFaultToleranceVm"] = reflect.TypeOf((*CannotDisconnectHostWithFaultToleranceVm)(nil)).Elem()
}

type CannotDisconnectHostWithFaultToleranceVmFault CannotDisconnectHostWithFaultToleranceVm

func init() {
	t["CannotDisconnectHostWithFaultToleranceVmFault"] = reflect.TypeOf((*CannotDisconnectHostWithFaultToleranceVmFault)(nil)).Elem()
}

type CannotModifyConfigCpuRequirements struct {
	MigrationFault
}

func init() {
	t["CannotModifyConfigCpuRequirements"] = reflect.TypeOf((*CannotModifyConfigCpuRequirements)(nil)).Elem()
}

type CannotModifyConfigCpuRequirementsFault CannotModifyConfigCpuRequirements

func init() {
	t["CannotModifyConfigCpuRequirementsFault"] = reflect.TypeOf((*CannotModifyConfigCpuRequirementsFault)(nil)).Elem()
}

type CannotMoveFaultToleranceVm struct {
	VimFault

	MoveType string `xml:"moveType"`
	VmName   string `xml:"vmName"`
}

func init() {
	t["CannotMoveFaultToleranceVm"] = reflect.TypeOf((*CannotMoveFaultToleranceVm)(nil)).Elem()
}

type CannotMoveFaultToleranceVmFault CannotMoveFaultToleranceVm

func init() {
	t["CannotMoveFaultToleranceVmFault"] = reflect.TypeOf((*CannotMoveFaultToleranceVmFault)(nil)).Elem()
}

type CannotMoveHostWithFaultToleranceVm struct {
	VimFault
}

func init() {
	t["CannotMoveHostWithFaultToleranceVm"] = reflect.TypeOf((*CannotMoveHostWithFaultToleranceVm)(nil)).Elem()
}

type CannotMoveHostWithFaultToleranceVmFault CannotMoveHostWithFaultToleranceVm

func init() {
	t["CannotMoveHostWithFaultToleranceVmFault"] = reflect.TypeOf((*CannotMoveHostWithFaultToleranceVmFault)(nil)).Elem()
}

type CannotMoveVmWithDeltaDisk struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["CannotMoveVmWithDeltaDisk"] = reflect.TypeOf((*CannotMoveVmWithDeltaDisk)(nil)).Elem()
}

type CannotMoveVmWithDeltaDiskFault CannotMoveVmWithDeltaDisk

func init() {
	t["CannotMoveVmWithDeltaDiskFault"] = reflect.TypeOf((*CannotMoveVmWithDeltaDiskFault)(nil)).Elem()
}

type CannotMoveVmWithNativeDeltaDisk struct {
	MigrationFault
}

func init() {
	t["CannotMoveVmWithNativeDeltaDisk"] = reflect.TypeOf((*CannotMoveVmWithNativeDeltaDisk)(nil)).Elem()
}

type CannotMoveVmWithNativeDeltaDiskFault CannotMoveVmWithNativeDeltaDisk

func init() {
	t["CannotMoveVmWithNativeDeltaDiskFault"] = reflect.TypeOf((*CannotMoveVmWithNativeDeltaDiskFault)(nil)).Elem()
}

type CannotMoveVsanEnabledHost struct {
	VsanFault
}

func init() {
	t["CannotMoveVsanEnabledHost"] = reflect.TypeOf((*CannotMoveVsanEnabledHost)(nil)).Elem()
}

type CannotMoveVsanEnabledHostFault BaseCannotMoveVsanEnabledHost

func init() {
	t["CannotMoveVsanEnabledHostFault"] = reflect.TypeOf((*CannotMoveVsanEnabledHostFault)(nil)).Elem()
}

type CannotPlaceWithoutPrerequisiteMoves struct {
	VimFault
}

func init() {
	t["CannotPlaceWithoutPrerequisiteMoves"] = reflect.TypeOf((*CannotPlaceWithoutPrerequisiteMoves)(nil)).Elem()
}

type CannotPlaceWithoutPrerequisiteMovesFault CannotPlaceWithoutPrerequisiteMoves

func init() {
	t["CannotPlaceWithoutPrerequisiteMovesFault"] = reflect.TypeOf((*CannotPlaceWithoutPrerequisiteMovesFault)(nil)).Elem()
}

type CannotPowerOffVmInCluster struct {
	InvalidState

	Operation string                 `xml:"operation"`
	Vm        ManagedObjectReference `xml:"vm"`
	VmName    string                 `xml:"vmName"`
}

func init() {
	t["CannotPowerOffVmInCluster"] = reflect.TypeOf((*CannotPowerOffVmInCluster)(nil)).Elem()
}

type CannotPowerOffVmInClusterFault CannotPowerOffVmInCluster

func init() {
	t["CannotPowerOffVmInClusterFault"] = reflect.TypeOf((*CannotPowerOffVmInClusterFault)(nil)).Elem()
}

type CannotReconfigureVsanWhenHaEnabled struct {
	VsanFault
}

func init() {
	t["CannotReconfigureVsanWhenHaEnabled"] = reflect.TypeOf((*CannotReconfigureVsanWhenHaEnabled)(nil)).Elem()
}

type CannotReconfigureVsanWhenHaEnabledFault CannotReconfigureVsanWhenHaEnabled

func init() {
	t["CannotReconfigureVsanWhenHaEnabledFault"] = reflect.TypeOf((*CannotReconfigureVsanWhenHaEnabledFault)(nil)).Elem()
}

type CannotUseNetwork struct {
	VmConfigFault

	Device    string `xml:"device"`
	Backing   string `xml:"backing"`
	Connected bool   `xml:"connected"`
	Reason    string `xml:"reason"`
}

func init() {
	t["CannotUseNetwork"] = reflect.TypeOf((*CannotUseNetwork)(nil)).Elem()
}

type CannotUseNetworkFault CannotUseNetwork

func init() {
	t["CannotUseNetworkFault"] = reflect.TypeOf((*CannotUseNetworkFault)(nil)).Elem()
}

type Capability struct {
	DynamicData

	ProvisioningSupported            bool      `xml:"provisioningSupported"`
	MultiHostSupported               bool      `xml:"multiHostSupported"`
	UserShellAccessSupported         bool      `xml:"userShellAccessSupported"`
	SupportedEVCMode                 []EVCMode `xml:"supportedEVCMode,omitempty"`
	NetworkBackupAndRestoreSupported *bool     `xml:"networkBackupAndRestoreSupported"`
}

func init() {
	t["Capability"] = reflect.TypeOf((*Capability)(nil)).Elem()
}

type ChangeFileAttributesInGuest ChangeFileAttributesInGuestRequestType

func init() {
	t["ChangeFileAttributesInGuest"] = reflect.TypeOf((*ChangeFileAttributesInGuest)(nil)).Elem()
}

type ChangeFileAttributesInGuestRequestType struct {
	This           ManagedObjectReference  `xml:"_this"`
	Vm             ManagedObjectReference  `xml:"vm"`
	Auth           BaseGuestAuthentication `xml:"auth,typeattr"`
	GuestFilePath  string                  `xml:"guestFilePath"`
	FileAttributes BaseGuestFileAttributes `xml:"fileAttributes,typeattr"`
}

func init() {
	t["ChangeFileAttributesInGuestRequestType"] = reflect.TypeOf((*ChangeFileAttributesInGuestRequestType)(nil)).Elem()
}

type ChangeFileAttributesInGuestResponse struct {
}

type ChangeOwner ChangeOwnerRequestType

func init() {
	t["ChangeOwner"] = reflect.TypeOf((*ChangeOwner)(nil)).Elem()
}

type ChangeOwnerRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Owner      string                  `xml:"owner"`
}

func init() {
	t["ChangeOwnerRequestType"] = reflect.TypeOf((*ChangeOwnerRequestType)(nil)).Elem()
}

type ChangeOwnerResponse struct {
}

type CheckAnswerFileStatusRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["CheckAnswerFileStatusRequestType"] = reflect.TypeOf((*CheckAnswerFileStatusRequestType)(nil)).Elem()
}

type CheckAnswerFileStatus_Task CheckAnswerFileStatusRequestType

func init() {
	t["CheckAnswerFileStatus_Task"] = reflect.TypeOf((*CheckAnswerFileStatus_Task)(nil)).Elem()
}

type CheckAnswerFileStatus_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckCompatibilityRequestType struct {
	This     ManagedObjectReference  `xml:"_this"`
	Vm       ManagedObjectReference  `xml:"vm"`
	Host     *ManagedObjectReference `xml:"host,omitempty"`
	Pool     *ManagedObjectReference `xml:"pool,omitempty"`
	TestType []string                `xml:"testType,omitempty"`
}

func init() {
	t["CheckCompatibilityRequestType"] = reflect.TypeOf((*CheckCompatibilityRequestType)(nil)).Elem()
}

type CheckCompatibility_Task CheckCompatibilityRequestType

func init() {
	t["CheckCompatibility_Task"] = reflect.TypeOf((*CheckCompatibility_Task)(nil)).Elem()
}

type CheckCompatibility_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckComplianceRequestType struct {
	This    ManagedObjectReference   `xml:"_this"`
	Profile []ManagedObjectReference `xml:"profile,omitempty"`
	Entity  []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["CheckComplianceRequestType"] = reflect.TypeOf((*CheckComplianceRequestType)(nil)).Elem()
}

type CheckCompliance_Task CheckComplianceRequestType

func init() {
	t["CheckCompliance_Task"] = reflect.TypeOf((*CheckCompliance_Task)(nil)).Elem()
}

type CheckCompliance_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckCustomizationResources CheckCustomizationResourcesRequestType

func init() {
	t["CheckCustomizationResources"] = reflect.TypeOf((*CheckCustomizationResources)(nil)).Elem()
}

type CheckCustomizationResourcesRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	GuestOs string                 `xml:"guestOs"`
}

func init() {
	t["CheckCustomizationResourcesRequestType"] = reflect.TypeOf((*CheckCustomizationResourcesRequestType)(nil)).Elem()
}

type CheckCustomizationResourcesResponse struct {
}

type CheckCustomizationSpec CheckCustomizationSpecRequestType

func init() {
	t["CheckCustomizationSpec"] = reflect.TypeOf((*CheckCustomizationSpec)(nil)).Elem()
}

type CheckCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec CustomizationSpec      `xml:"spec"`
}

func init() {
	t["CheckCustomizationSpecRequestType"] = reflect.TypeOf((*CheckCustomizationSpecRequestType)(nil)).Elem()
}

type CheckCustomizationSpecResponse struct {
}

type CheckForUpdates CheckForUpdatesRequestType

func init() {
	t["CheckForUpdates"] = reflect.TypeOf((*CheckForUpdates)(nil)).Elem()
}

type CheckForUpdatesRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Version string                 `xml:"version,omitempty"`
}

func init() {
	t["CheckForUpdatesRequestType"] = reflect.TypeOf((*CheckForUpdatesRequestType)(nil)).Elem()
}

type CheckForUpdatesResponse struct {
	Returnval *UpdateSet `xml:"returnval,omitempty"`
}

type CheckHostPatchRequestType struct {
	This       ManagedObjectReference                     `xml:"_this"`
	MetaUrls   []string                                   `xml:"metaUrls,omitempty"`
	BundleUrls []string                                   `xml:"bundleUrls,omitempty"`
	Spec       *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty"`
}

func init() {
	t["CheckHostPatchRequestType"] = reflect.TypeOf((*CheckHostPatchRequestType)(nil)).Elem()
}

type CheckHostPatch_Task CheckHostPatchRequestType

func init() {
	t["CheckHostPatch_Task"] = reflect.TypeOf((*CheckHostPatch_Task)(nil)).Elem()
}

type CheckHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckLicenseFeature CheckLicenseFeatureRequestType

func init() {
	t["CheckLicenseFeature"] = reflect.TypeOf((*CheckLicenseFeature)(nil)).Elem()
}

type CheckLicenseFeatureRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
	FeatureKey string                  `xml:"featureKey"`
}

func init() {
	t["CheckLicenseFeatureRequestType"] = reflect.TypeOf((*CheckLicenseFeatureRequestType)(nil)).Elem()
}

type CheckLicenseFeatureResponse struct {
	Returnval bool `xml:"returnval"`
}

type CheckMigrateRequestType struct {
	This     ManagedObjectReference   `xml:"_this"`
	Vm       ManagedObjectReference   `xml:"vm"`
	Host     *ManagedObjectReference  `xml:"host,omitempty"`
	Pool     *ManagedObjectReference  `xml:"pool,omitempty"`
	State    VirtualMachinePowerState `xml:"state,omitempty"`
	TestType []string                 `xml:"testType,omitempty"`
}

func init() {
	t["CheckMigrateRequestType"] = reflect.TypeOf((*CheckMigrateRequestType)(nil)).Elem()
}

type CheckMigrate_Task CheckMigrateRequestType

func init() {
	t["CheckMigrate_Task"] = reflect.TypeOf((*CheckMigrate_Task)(nil)).Elem()
}

type CheckMigrate_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckProfileComplianceRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["CheckProfileComplianceRequestType"] = reflect.TypeOf((*CheckProfileComplianceRequestType)(nil)).Elem()
}

type CheckProfileCompliance_Task CheckProfileComplianceRequestType

func init() {
	t["CheckProfileCompliance_Task"] = reflect.TypeOf((*CheckProfileCompliance_Task)(nil)).Elem()
}

type CheckProfileCompliance_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckRelocateRequestType struct {
	This     ManagedObjectReference     `xml:"_this"`
	Vm       ManagedObjectReference     `xml:"vm"`
	Spec     VirtualMachineRelocateSpec `xml:"spec"`
	TestType []string                   `xml:"testType,omitempty"`
}

func init() {
	t["CheckRelocateRequestType"] = reflect.TypeOf((*CheckRelocateRequestType)(nil)).Elem()
}

type CheckRelocate_Task CheckRelocateRequestType

func init() {
	t["CheckRelocate_Task"] = reflect.TypeOf((*CheckRelocate_Task)(nil)).Elem()
}

type CheckRelocate_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckResult struct {
	DynamicData

	Vm      *ManagedObjectReference `xml:"vm,omitempty"`
	Host    *ManagedObjectReference `xml:"host,omitempty"`
	Warning []LocalizedMethodFault  `xml:"warning,omitempty"`
	Error   []LocalizedMethodFault  `xml:"error,omitempty"`
}

func init() {
	t["CheckResult"] = reflect.TypeOf((*CheckResult)(nil)).Elem()
}

type ChoiceOption struct {
	OptionType

	ChoiceInfo   []BaseElementDescription `xml:"choiceInfo,typeattr"`
	DefaultIndex int                      `xml:"defaultIndex,omitempty"`
}

func init() {
	t["ChoiceOption"] = reflect.TypeOf((*ChoiceOption)(nil)).Elem()
}

type ClearComplianceStatus ClearComplianceStatusRequestType

func init() {
	t["ClearComplianceStatus"] = reflect.TypeOf((*ClearComplianceStatus)(nil)).Elem()
}

type ClearComplianceStatusRequestType struct {
	This    ManagedObjectReference   `xml:"_this"`
	Profile []ManagedObjectReference `xml:"profile,omitempty"`
	Entity  []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["ClearComplianceStatusRequestType"] = reflect.TypeOf((*ClearComplianceStatusRequestType)(nil)).Elem()
}

type ClearComplianceStatusResponse struct {
}

type ClockSkew struct {
	HostConfigFault
}

func init() {
	t["ClockSkew"] = reflect.TypeOf((*ClockSkew)(nil)).Elem()
}

type ClockSkewFault ClockSkew

func init() {
	t["ClockSkewFault"] = reflect.TypeOf((*ClockSkewFault)(nil)).Elem()
}

type CloneFromSnapshotNotSupported struct {
	MigrationFault
}

func init() {
	t["CloneFromSnapshotNotSupported"] = reflect.TypeOf((*CloneFromSnapshotNotSupported)(nil)).Elem()
}

type CloneFromSnapshotNotSupportedFault CloneFromSnapshotNotSupported

func init() {
	t["CloneFromSnapshotNotSupportedFault"] = reflect.TypeOf((*CloneFromSnapshotNotSupportedFault)(nil)).Elem()
}

type CloneSession CloneSessionRequestType

func init() {
	t["CloneSession"] = reflect.TypeOf((*CloneSession)(nil)).Elem()
}

type CloneSessionRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	CloneTicket string                 `xml:"cloneTicket"`
}

func init() {
	t["CloneSessionRequestType"] = reflect.TypeOf((*CloneSessionRequestType)(nil)).Elem()
}

type CloneSessionResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type CloneVAppRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Name   string                 `xml:"name"`
	Target ManagedObjectReference `xml:"target"`
	Spec   VAppCloneSpec          `xml:"spec"`
}

func init() {
	t["CloneVAppRequestType"] = reflect.TypeOf((*CloneVAppRequestType)(nil)).Elem()
}

type CloneVApp_Task CloneVAppRequestType

func init() {
	t["CloneVApp_Task"] = reflect.TypeOf((*CloneVApp_Task)(nil)).Elem()
}

type CloneVApp_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CloneVMRequestType struct {
	This   ManagedObjectReference  `xml:"_this"`
	Folder ManagedObjectReference  `xml:"folder"`
	Name   string                  `xml:"name"`
	Spec   VirtualMachineCloneSpec `xml:"spec"`
}

func init() {
	t["CloneVMRequestType"] = reflect.TypeOf((*CloneVMRequestType)(nil)).Elem()
}

type CloneVM_Task CloneVMRequestType

func init() {
	t["CloneVM_Task"] = reflect.TypeOf((*CloneVM_Task)(nil)).Elem()
}

type CloneVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CloseInventoryViewFolder CloseInventoryViewFolderRequestType

func init() {
	t["CloseInventoryViewFolder"] = reflect.TypeOf((*CloseInventoryViewFolder)(nil)).Elem()
}

type CloseInventoryViewFolderRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity"`
}

func init() {
	t["CloseInventoryViewFolderRequestType"] = reflect.TypeOf((*CloseInventoryViewFolderRequestType)(nil)).Elem()
}

type CloseInventoryViewFolderResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type ClusterAction struct {
	DynamicData

	Type   string                  `xml:"type"`
	Target *ManagedObjectReference `xml:"target,omitempty"`
}

func init() {
	t["ClusterAction"] = reflect.TypeOf((*ClusterAction)(nil)).Elem()
}

type ClusterActionHistory struct {
	DynamicData

	Action BaseClusterAction `xml:"action,typeattr"`
	Time   time.Time         `xml:"time"`
}

func init() {
	t["ClusterActionHistory"] = reflect.TypeOf((*ClusterActionHistory)(nil)).Elem()
}

type ClusterAffinityRuleSpec struct {
	ClusterRuleInfo

	Vm []ManagedObjectReference `xml:"vm"`
}

func init() {
	t["ClusterAffinityRuleSpec"] = reflect.TypeOf((*ClusterAffinityRuleSpec)(nil)).Elem()
}

type ClusterAntiAffinityRuleSpec struct {
	ClusterRuleInfo

	Vm []ManagedObjectReference `xml:"vm"`
}

func init() {
	t["ClusterAntiAffinityRuleSpec"] = reflect.TypeOf((*ClusterAntiAffinityRuleSpec)(nil)).Elem()
}

type ClusterAttemptedVmInfo struct {
	DynamicData

	Vm   ManagedObjectReference  `xml:"vm"`
	Task *ManagedObjectReference `xml:"task,omitempty"`
}

func init() {
	t["ClusterAttemptedVmInfo"] = reflect.TypeOf((*ClusterAttemptedVmInfo)(nil)).Elem()
}

type ClusterComplianceCheckedEvent struct {
	ClusterEvent

	Profile ProfileEventArgument `xml:"profile"`
}

func init() {
	t["ClusterComplianceCheckedEvent"] = reflect.TypeOf((*ClusterComplianceCheckedEvent)(nil)).Elem()
}

type ClusterComputeResourceSummary struct {
	ComputeResourceSummary

	CurrentFailoverLevel int                                `xml:"currentFailoverLevel"`
	AdmissionControlInfo BaseClusterDasAdmissionControlInfo `xml:"admissionControlInfo,omitempty,typeattr"`
	NumVmotions          int                                `xml:"numVmotions"`
	TargetBalance        int                                `xml:"targetBalance,omitempty"`
	CurrentBalance       int                                `xml:"currentBalance,omitempty"`
	CurrentEVCModeKey    string                             `xml:"currentEVCModeKey,omitempty"`
	DasData              BaseClusterDasData                 `xml:"dasData,omitempty,typeattr"`
}

func init() {
	t["ClusterComputeResourceSummary"] = reflect.TypeOf((*ClusterComputeResourceSummary)(nil)).Elem()
}

type ClusterConfigInfo struct {
	DynamicData

	DasConfig   ClusterDasConfigInfo     `xml:"dasConfig"`
	DasVmConfig []ClusterDasVmConfigInfo `xml:"dasVmConfig,omitempty"`
	DrsConfig   ClusterDrsConfigInfo     `xml:"drsConfig"`
	DrsVmConfig []ClusterDrsVmConfigInfo `xml:"drsVmConfig,omitempty"`
	Rule        []BaseClusterRuleInfo    `xml:"rule,omitempty,typeattr"`
}

func init() {
	t["ClusterConfigInfo"] = reflect.TypeOf((*ClusterConfigInfo)(nil)).Elem()
}

type ClusterConfigInfoEx struct {
	ComputeResourceConfigInfo

	DasConfig      ClusterDasConfigInfo       `xml:"dasConfig"`
	DasVmConfig    []ClusterDasVmConfigInfo   `xml:"dasVmConfig,omitempty"`
	DrsConfig      ClusterDrsConfigInfo       `xml:"drsConfig"`
	DrsVmConfig    []ClusterDrsVmConfigInfo   `xml:"drsVmConfig,omitempty"`
	Rule           []BaseClusterRuleInfo      `xml:"rule,omitempty,typeattr"`
	DpmConfigInfo  *ClusterDpmConfigInfo      `xml:"dpmConfigInfo,omitempty"`
	DpmHostConfig  []ClusterDpmHostConfigInfo `xml:"dpmHostConfig,omitempty"`
	VsanConfigInfo *VsanClusterConfigInfo     `xml:"vsanConfigInfo,omitempty"`
	VsanHostConfig []VsanHostConfigInfo       `xml:"vsanHostConfig,omitempty"`
	Group          []BaseClusterGroupInfo     `xml:"group,omitempty,typeattr"`
}

func init() {
	t["ClusterConfigInfoEx"] = reflect.TypeOf((*ClusterConfigInfoEx)(nil)).Elem()
}

type ClusterConfigSpec struct {
	DynamicData

	DasConfig       *ClusterDasConfigInfo    `xml:"dasConfig,omitempty"`
	DasVmConfigSpec []ClusterDasVmConfigSpec `xml:"dasVmConfigSpec,omitempty"`
	DrsConfig       *ClusterDrsConfigInfo    `xml:"drsConfig,omitempty"`
	DrsVmConfigSpec []ClusterDrsVmConfigSpec `xml:"drsVmConfigSpec,omitempty"`
	RulesSpec       []ClusterRuleSpec        `xml:"rulesSpec,omitempty"`
}

func init() {
	t["ClusterConfigSpec"] = reflect.TypeOf((*ClusterConfigSpec)(nil)).Elem()
}

type ClusterConfigSpecEx struct {
	ComputeResourceConfigSpec

	DasConfig          *ClusterDasConfigInfo      `xml:"dasConfig,omitempty"`
	DasVmConfigSpec    []ClusterDasVmConfigSpec   `xml:"dasVmConfigSpec,omitempty"`
	DrsConfig          *ClusterDrsConfigInfo      `xml:"drsConfig,omitempty"`
	DrsVmConfigSpec    []ClusterDrsVmConfigSpec   `xml:"drsVmConfigSpec,omitempty"`
	RulesSpec          []ClusterRuleSpec          `xml:"rulesSpec,omitempty"`
	DpmConfig          *ClusterDpmConfigInfo      `xml:"dpmConfig,omitempty"`
	DpmHostConfigSpec  []ClusterDpmHostConfigSpec `xml:"dpmHostConfigSpec,omitempty"`
	VsanConfig         *VsanClusterConfigInfo     `xml:"vsanConfig,omitempty"`
	VsanHostConfigSpec []VsanHostConfigInfo       `xml:"vsanHostConfigSpec,omitempty"`
	GroupSpec          []ClusterGroupSpec         `xml:"groupSpec,omitempty"`
}

func init() {
	t["ClusterConfigSpecEx"] = reflect.TypeOf((*ClusterConfigSpecEx)(nil)).Elem()
}

type ClusterCreatedEvent struct {
	ClusterEvent

	Parent FolderEventArgument `xml:"parent"`
}

func init() {
	t["ClusterCreatedEvent"] = reflect.TypeOf((*ClusterCreatedEvent)(nil)).Elem()
}

type ClusterDasAamHostInfo struct {
	ClusterDasHostInfo

	HostDasState []ClusterDasAamNodeState `xml:"hostDasState,omitempty"`
	PrimaryHosts []string                 `xml:"primaryHosts,omitempty"`
}

func init() {
	t["ClusterDasAamHostInfo"] = reflect.TypeOf((*ClusterDasAamHostInfo)(nil)).Elem()
}

type ClusterDasAamNodeState struct {
	DynamicData

	Host         ManagedObjectReference `xml:"host"`
	Name         string                 `xml:"name"`
	ConfigState  string                 `xml:"configState"`
	RuntimeState string                 `xml:"runtimeState"`
}

func init() {
	t["ClusterDasAamNodeState"] = reflect.TypeOf((*ClusterDasAamNodeState)(nil)).Elem()
}

type ClusterDasAdmissionControlInfo struct {
	DynamicData
}

func init() {
	t["ClusterDasAdmissionControlInfo"] = reflect.TypeOf((*ClusterDasAdmissionControlInfo)(nil)).Elem()
}

type ClusterDasAdmissionControlPolicy struct {
	DynamicData
}

func init() {
	t["ClusterDasAdmissionControlPolicy"] = reflect.TypeOf((*ClusterDasAdmissionControlPolicy)(nil)).Elem()
}

type ClusterDasAdvancedRuntimeInfo struct {
	DynamicData

	DasHostInfo            BaseClusterDasHostInfo      `xml:"dasHostInfo,omitempty,typeattr"`
	HeartbeatDatastoreInfo []DasHeartbeatDatastoreInfo `xml:"heartbeatDatastoreInfo,omitempty"`
}

func init() {
	t["ClusterDasAdvancedRuntimeInfo"] = reflect.TypeOf((*ClusterDasAdvancedRuntimeInfo)(nil)).Elem()
}

type ClusterDasConfigInfo struct {
	DynamicData

	Enabled                    *bool                                `xml:"enabled"`
	VmMonitoring               string                               `xml:"vmMonitoring,omitempty"`
	HostMonitoring             string                               `xml:"hostMonitoring,omitempty"`
	FailoverLevel              int                                  `xml:"failoverLevel,omitempty"`
	AdmissionControlPolicy     BaseClusterDasAdmissionControlPolicy `xml:"admissionControlPolicy,omitempty,typeattr"`
	AdmissionControlEnabled    *bool                                `xml:"admissionControlEnabled"`
	DefaultVmSettings          *ClusterDasVmSettings                `xml:"defaultVmSettings,omitempty"`
	Option                     []BaseOptionValue                    `xml:"option,omitempty,typeattr"`
	HeartbeatDatastore         []ManagedObjectReference             `xml:"heartbeatDatastore,omitempty"`
	HBDatastoreCandidatePolicy string                               `xml:"hBDatastoreCandidatePolicy,omitempty"`
}

func init() {
	t["ClusterDasConfigInfo"] = reflect.TypeOf((*ClusterDasConfigInfo)(nil)).Elem()
}

type ClusterDasData struct {
	DynamicData
}

func init() {
	t["ClusterDasData"] = reflect.TypeOf((*ClusterDasData)(nil)).Elem()
}

type ClusterDasDataSummary struct {
	ClusterDasData

	HostListVersion      int64 `xml:"hostListVersion"`
	ClusterConfigVersion int64 `xml:"clusterConfigVersion"`
	CompatListVersion    int64 `xml:"compatListVersion"`
}

func init() {
	t["ClusterDasDataSummary"] = reflect.TypeOf((*ClusterDasDataSummary)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfo struct {
	ClusterDasAdvancedRuntimeInfo

	SlotInfo                  ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo    `xml:"slotInfo"`
	TotalSlots                int                                                   `xml:"totalSlots"`
	UsedSlots                 int                                                   `xml:"usedSlots"`
	UnreservedSlots           int                                                   `xml:"unreservedSlots"`
	TotalVms                  int                                                   `xml:"totalVms"`
	TotalHosts                int                                                   `xml:"totalHosts"`
	TotalGoodHosts            int                                                   `xml:"totalGoodHosts"`
	HostSlots                 []ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots `xml:"hostSlots,omitempty"`
	VmsRequiringMultipleSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots   `xml:"vmsRequiringMultipleSlots,omitempty"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfo"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfo)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Slots int                    `xml:"slots"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo struct {
	DynamicData

	NumVcpus int `xml:"numVcpus"`
	CpuMHz   int `xml:"cpuMHz"`
	MemoryMB int `xml:"memoryMB"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots struct {
	DynamicData

	Vm    ManagedObjectReference `xml:"vm"`
	Slots int                    `xml:"slots"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots)(nil)).Elem()
}

type ClusterDasFdmHostState struct {
	DynamicData

	State         string                  `xml:"state"`
	StateReporter *ManagedObjectReference `xml:"stateReporter,omitempty"`
}

func init() {
	t["ClusterDasFdmHostState"] = reflect.TypeOf((*ClusterDasFdmHostState)(nil)).Elem()
}

type ClusterDasHostInfo struct {
	DynamicData
}

func init() {
	t["ClusterDasHostInfo"] = reflect.TypeOf((*ClusterDasHostInfo)(nil)).Elem()
}

type ClusterDasHostRecommendation struct {
	DynamicData

	Host      ManagedObjectReference `xml:"host"`
	DrsRating int                    `xml:"drsRating,omitempty"`
}

func init() {
	t["ClusterDasHostRecommendation"] = reflect.TypeOf((*ClusterDasHostRecommendation)(nil)).Elem()
}

type ClusterDasVmConfigInfo struct {
	DynamicData

	Key                 ManagedObjectReference `xml:"key"`
	RestartPriority     DasVmPriority          `xml:"restartPriority,omitempty"`
	PowerOffOnIsolation *bool                  `xml:"powerOffOnIsolation"`
	DasSettings         *ClusterDasVmSettings  `xml:"dasSettings,omitempty"`
}

func init() {
	t["ClusterDasVmConfigInfo"] = reflect.TypeOf((*ClusterDasVmConfigInfo)(nil)).Elem()
}

type ClusterDasVmConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDasVmConfigInfo `xml:"info,omitempty"`
}

func init() {
	t["ClusterDasVmConfigSpec"] = reflect.TypeOf((*ClusterDasVmConfigSpec)(nil)).Elem()
}

type ClusterDasVmSettings struct {
	DynamicData

	RestartPriority           string                            `xml:"restartPriority,omitempty"`
	IsolationResponse         string                            `xml:"isolationResponse,omitempty"`
	VmToolsMonitoringSettings *ClusterVmToolsMonitoringSettings `xml:"vmToolsMonitoringSettings,omitempty"`
}

func init() {
	t["ClusterDasVmSettings"] = reflect.TypeOf((*ClusterDasVmSettings)(nil)).Elem()
}

type ClusterDestroyedEvent struct {
	ClusterEvent
}

func init() {
	t["ClusterDestroyedEvent"] = reflect.TypeOf((*ClusterDestroyedEvent)(nil)).Elem()
}

type ClusterDpmConfigInfo struct {
	DynamicData

	Enabled             *bool             `xml:"enabled"`
	DefaultDpmBehavior  DpmBehavior       `xml:"defaultDpmBehavior,omitempty"`
	HostPowerActionRate int               `xml:"hostPowerActionRate,omitempty"`
	Option              []BaseOptionValue `xml:"option,omitempty,typeattr"`
}

func init() {
	t["ClusterDpmConfigInfo"] = reflect.TypeOf((*ClusterDpmConfigInfo)(nil)).Elem()
}

type ClusterDpmHostConfigInfo struct {
	DynamicData

	Key      ManagedObjectReference `xml:"key"`
	Enabled  *bool                  `xml:"enabled"`
	Behavior DpmBehavior            `xml:"behavior,omitempty"`
}

func init() {
	t["ClusterDpmHostConfigInfo"] = reflect.TypeOf((*ClusterDpmHostConfigInfo)(nil)).Elem()
}

type ClusterDpmHostConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDpmHostConfigInfo `xml:"info,omitempty"`
}

func init() {
	t["ClusterDpmHostConfigSpec"] = reflect.TypeOf((*ClusterDpmHostConfigSpec)(nil)).Elem()
}

type ClusterDrsConfigInfo struct {
	DynamicData

	Enabled                   *bool             `xml:"enabled"`
	EnableVmBehaviorOverrides *bool             `xml:"enableVmBehaviorOverrides"`
	DefaultVmBehavior         DrsBehavior       `xml:"defaultVmBehavior,omitempty"`
	VmotionRate               int               `xml:"vmotionRate,omitempty"`
	Option                    []BaseOptionValue `xml:"option,omitempty,typeattr"`
}

func init() {
	t["ClusterDrsConfigInfo"] = reflect.TypeOf((*ClusterDrsConfigInfo)(nil)).Elem()
}

type ClusterDrsFaults struct {
	DynamicData

	Reason     string                           `xml:"reason"`
	FaultsByVm []BaseClusterDrsFaultsFaultsByVm `xml:"faultsByVm,typeattr"`
}

func init() {
	t["ClusterDrsFaults"] = reflect.TypeOf((*ClusterDrsFaults)(nil)).Elem()
}

type ClusterDrsFaultsFaultsByVirtualDisk struct {
	ClusterDrsFaultsFaultsByVm

	Disk *VirtualDiskId `xml:"disk,omitempty"`
}

func init() {
	t["ClusterDrsFaultsFaultsByVirtualDisk"] = reflect.TypeOf((*ClusterDrsFaultsFaultsByVirtualDisk)(nil)).Elem()
}

type ClusterDrsFaultsFaultsByVm struct {
	DynamicData

	Vm    *ManagedObjectReference `xml:"vm,omitempty"`
	Fault []LocalizedMethodFault  `xml:"fault"`
}

func init() {
	t["ClusterDrsFaultsFaultsByVm"] = reflect.TypeOf((*ClusterDrsFaultsFaultsByVm)(nil)).Elem()
}

type ClusterDrsMigration struct {
	DynamicData

	Key                   string                 `xml:"key"`
	Time                  time.Time              `xml:"time"`
	Vm                    ManagedObjectReference `xml:"vm"`
	CpuLoad               int                    `xml:"cpuLoad,omitempty"`
	MemoryLoad            int64                  `xml:"memoryLoad,omitempty"`
	Source                ManagedObjectReference `xml:"source"`
	SourceCpuLoad         int                    `xml:"sourceCpuLoad,omitempty"`
	SourceMemoryLoad      int64                  `xml:"sourceMemoryLoad,omitempty"`
	Destination           ManagedObjectReference `xml:"destination"`
	DestinationCpuLoad    int                    `xml:"destinationCpuLoad,omitempty"`
	DestinationMemoryLoad int64                  `xml:"destinationMemoryLoad,omitempty"`
}

func init() {
	t["ClusterDrsMigration"] = reflect.TypeOf((*ClusterDrsMigration)(nil)).Elem()
}

type ClusterDrsRecommendation struct {
	DynamicData

	Key           string                `xml:"key"`
	Rating        int                   `xml:"rating"`
	Reason        string                `xml:"reason"`
	ReasonText    string                `xml:"reasonText"`
	MigrationList []ClusterDrsMigration `xml:"migrationList"`
}

func init() {
	t["ClusterDrsRecommendation"] = reflect.TypeOf((*ClusterDrsRecommendation)(nil)).Elem()
}

type ClusterDrsVmConfigInfo struct {
	DynamicData

	Key      ManagedObjectReference `xml:"key"`
	Enabled  *bool                  `xml:"enabled"`
	Behavior DrsBehavior            `xml:"behavior,omitempty"`
}

func init() {
	t["ClusterDrsVmConfigInfo"] = reflect.TypeOf((*ClusterDrsVmConfigInfo)(nil)).Elem()
}

type ClusterDrsVmConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDrsVmConfigInfo `xml:"info,omitempty"`
}

func init() {
	t["ClusterDrsVmConfigSpec"] = reflect.TypeOf((*ClusterDrsVmConfigSpec)(nil)).Elem()
}

type ClusterEnterMaintenanceMode ClusterEnterMaintenanceModeRequestType

func init() {
	t["ClusterEnterMaintenanceMode"] = reflect.TypeOf((*ClusterEnterMaintenanceMode)(nil)).Elem()
}

type ClusterEnterMaintenanceModeRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Host   []ManagedObjectReference `xml:"host"`
	Option []BaseOptionValue        `xml:"option,omitempty,typeattr"`
}

func init() {
	t["ClusterEnterMaintenanceModeRequestType"] = reflect.TypeOf((*ClusterEnterMaintenanceModeRequestType)(nil)).Elem()
}

type ClusterEnterMaintenanceModeResponse struct {
	Returnval ClusterEnterMaintenanceResult `xml:"returnval"`
}

type ClusterEnterMaintenanceResult struct {
	DynamicData

	Recommendations []ClusterRecommendation `xml:"recommendations,omitempty"`
	Fault           *ClusterDrsFaults       `xml:"fault,omitempty"`
}

func init() {
	t["ClusterEnterMaintenanceResult"] = reflect.TypeOf((*ClusterEnterMaintenanceResult)(nil)).Elem()
}

type ClusterEvent struct {
	Event
}

func init() {
	t["ClusterEvent"] = reflect.TypeOf((*ClusterEvent)(nil)).Elem()
}

type ClusterFailoverHostAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	HostStatus []ClusterFailoverHostAdmissionControlInfoHostStatus `xml:"hostStatus,omitempty"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlInfo)(nil)).Elem()
}

type ClusterFailoverHostAdmissionControlInfoHostStatus struct {
	DynamicData

	Host   ManagedObjectReference `xml:"host"`
	Status ManagedEntityStatus    `xml:"status"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlInfoHostStatus"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlInfoHostStatus)(nil)).Elem()
}

type ClusterFailoverHostAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	FailoverHosts []ManagedObjectReference `xml:"failoverHosts,omitempty"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlPolicy)(nil)).Elem()
}

type ClusterFailoverLevelAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	CurrentFailoverLevel int `xml:"currentFailoverLevel"`
}

func init() {
	t["ClusterFailoverLevelAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverLevelAdmissionControlInfo)(nil)).Elem()
}

type ClusterFailoverLevelAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	FailoverLevel int                   `xml:"failoverLevel"`
	SlotPolicy    BaseClusterSlotPolicy `xml:"slotPolicy,omitempty,typeattr"`
}

func init() {
	t["ClusterFailoverLevelAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverLevelAdmissionControlPolicy)(nil)).Elem()
}

type ClusterFailoverResourcesAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	CurrentCpuFailoverResourcesPercent    int `xml:"currentCpuFailoverResourcesPercent"`
	CurrentMemoryFailoverResourcesPercent int `xml:"currentMemoryFailoverResourcesPercent"`
}

func init() {
	t["ClusterFailoverResourcesAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverResourcesAdmissionControlInfo)(nil)).Elem()
}

type ClusterFailoverResourcesAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	CpuFailoverResourcesPercent    int `xml:"cpuFailoverResourcesPercent"`
	MemoryFailoverResourcesPercent int `xml:"memoryFailoverResourcesPercent"`
}

func init() {
	t["ClusterFailoverResourcesAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverResourcesAdmissionControlPolicy)(nil)).Elem()
}

type ClusterFixedSizeSlotPolicy struct {
	ClusterSlotPolicy

	Cpu    int `xml:"cpu"`
	Memory int `xml:"memory"`
}

func init() {
	t["ClusterFixedSizeSlotPolicy"] = reflect.TypeOf((*ClusterFixedSizeSlotPolicy)(nil)).Elem()
}

type ClusterGroupInfo struct {
	DynamicData

	Name        string `xml:"name"`
	UserCreated *bool  `xml:"userCreated"`
}

func init() {
	t["ClusterGroupInfo"] = reflect.TypeOf((*ClusterGroupInfo)(nil)).Elem()
}

type ClusterGroupSpec struct {
	ArrayUpdateSpec

	Info BaseClusterGroupInfo `xml:"info,omitempty,typeattr"`
}

func init() {
	t["ClusterGroupSpec"] = reflect.TypeOf((*ClusterGroupSpec)(nil)).Elem()
}

type ClusterHostGroup struct {
	ClusterGroupInfo

	Host []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["ClusterHostGroup"] = reflect.TypeOf((*ClusterHostGroup)(nil)).Elem()
}

type ClusterHostPowerAction struct {
	ClusterAction

	OperationType        HostPowerOperationType `xml:"operationType"`
	PowerConsumptionWatt int                    `xml:"powerConsumptionWatt,omitempty"`
	CpuCapacityMHz       int                    `xml:"cpuCapacityMHz,omitempty"`
	MemCapacityMB        int                    `xml:"memCapacityMB,omitempty"`
}

func init() {
	t["ClusterHostPowerAction"] = reflect.TypeOf((*ClusterHostPowerAction)(nil)).Elem()
}

type ClusterHostRecommendation struct {
	DynamicData

	Host   ManagedObjectReference `xml:"host"`
	Rating int                    `xml:"rating"`
}

func init() {
	t["ClusterHostRecommendation"] = reflect.TypeOf((*ClusterHostRecommendation)(nil)).Elem()
}

type ClusterInitialPlacementAction struct {
	ClusterAction

	TargetHost ManagedObjectReference  `xml:"targetHost"`
	Pool       *ManagedObjectReference `xml:"pool,omitempty"`
}

func init() {
	t["ClusterInitialPlacementAction"] = reflect.TypeOf((*ClusterInitialPlacementAction)(nil)).Elem()
}

type ClusterMigrationAction struct {
	ClusterAction

	DrsMigration *ClusterDrsMigration `xml:"drsMigration,omitempty"`
}

func init() {
	t["ClusterMigrationAction"] = reflect.TypeOf((*ClusterMigrationAction)(nil)).Elem()
}

type ClusterNotAttemptedVmInfo struct {
	DynamicData

	Vm    ManagedObjectReference `xml:"vm"`
	Fault LocalizedMethodFault   `xml:"fault"`
}

func init() {
	t["ClusterNotAttemptedVmInfo"] = reflect.TypeOf((*ClusterNotAttemptedVmInfo)(nil)).Elem()
}

type ClusterOvercommittedEvent struct {
	ClusterEvent
}

func init() {
	t["ClusterOvercommittedEvent"] = reflect.TypeOf((*ClusterOvercommittedEvent)(nil)).Elem()
}

type ClusterPowerOnVmResult struct {
	DynamicData

	Attempted       []ClusterAttemptedVmInfo    `xml:"attempted,omitempty"`
	NotAttempted    []ClusterNotAttemptedVmInfo `xml:"notAttempted,omitempty"`
	Recommendations []ClusterRecommendation     `xml:"recommendations,omitempty"`
}

func init() {
	t["ClusterPowerOnVmResult"] = reflect.TypeOf((*ClusterPowerOnVmResult)(nil)).Elem()
}

type ClusterProfileCompleteConfigSpec struct {
	ClusterProfileConfigSpec

	ComplyProfile *ComplianceProfile `xml:"complyProfile,omitempty"`
}

func init() {
	t["ClusterProfileCompleteConfigSpec"] = reflect.TypeOf((*ClusterProfileCompleteConfigSpec)(nil)).Elem()
}

type ClusterProfileConfigInfo struct {
	ProfileConfigInfo

	ComplyProfile *ComplianceProfile `xml:"complyProfile,omitempty"`
}

func init() {
	t["ClusterProfileConfigInfo"] = reflect.TypeOf((*ClusterProfileConfigInfo)(nil)).Elem()
}

type ClusterProfileConfigServiceCreateSpec struct {
	ClusterProfileConfigSpec

	ServiceType []string `xml:"serviceType,omitempty"`
}

func init() {
	t["ClusterProfileConfigServiceCreateSpec"] = reflect.TypeOf((*ClusterProfileConfigServiceCreateSpec)(nil)).Elem()
}

type ClusterProfileConfigSpec struct {
	ClusterProfileCreateSpec
}

func init() {
	t["ClusterProfileConfigSpec"] = reflect.TypeOf((*ClusterProfileConfigSpec)(nil)).Elem()
}

type ClusterProfileCreateSpec struct {
	ProfileCreateSpec
}

func init() {
	t["ClusterProfileCreateSpec"] = reflect.TypeOf((*ClusterProfileCreateSpec)(nil)).Elem()
}

type ClusterRecommendation struct {
	DynamicData

	Key          string                  `xml:"key"`
	Type         string                  `xml:"type"`
	Time         time.Time               `xml:"time"`
	Rating       int                     `xml:"rating"`
	Reason       string                  `xml:"reason"`
	ReasonText   string                  `xml:"reasonText"`
	Prerequisite []string                `xml:"prerequisite,omitempty"`
	Action       []BaseClusterAction     `xml:"action,omitempty,typeattr"`
	Target       *ManagedObjectReference `xml:"target,omitempty"`
}

func init() {
	t["ClusterRecommendation"] = reflect.TypeOf((*ClusterRecommendation)(nil)).Elem()
}

type ClusterReconfiguredEvent struct {
	ClusterEvent
}

func init() {
	t["ClusterReconfiguredEvent"] = reflect.TypeOf((*ClusterReconfiguredEvent)(nil)).Elem()
}

type ClusterRuleInfo struct {
	DynamicData

	Key          int                 `xml:"key,omitempty"`
	Status       ManagedEntityStatus `xml:"status,omitempty"`
	Enabled      *bool               `xml:"enabled"`
	Name         string              `xml:"name,omitempty"`
	Mandatory    *bool               `xml:"mandatory"`
	UserCreated  *bool               `xml:"userCreated"`
	InCompliance *bool               `xml:"inCompliance"`
}

func init() {
	t["ClusterRuleInfo"] = reflect.TypeOf((*ClusterRuleInfo)(nil)).Elem()
}

type ClusterRuleSpec struct {
	ArrayUpdateSpec

	Info BaseClusterRuleInfo `xml:"info,omitempty,typeattr"`
}

func init() {
	t["ClusterRuleSpec"] = reflect.TypeOf((*ClusterRuleSpec)(nil)).Elem()
}

type ClusterSlotPolicy struct {
	DynamicData
}

func init() {
	t["ClusterSlotPolicy"] = reflect.TypeOf((*ClusterSlotPolicy)(nil)).Elem()
}

type ClusterStatusChangedEvent struct {
	ClusterEvent

	OldStatus string `xml:"oldStatus"`
	NewStatus string `xml:"newStatus"`
}

func init() {
	t["ClusterStatusChangedEvent"] = reflect.TypeOf((*ClusterStatusChangedEvent)(nil)).Elem()
}

type ClusterVmGroup struct {
	ClusterGroupInfo

	Vm []ManagedObjectReference `xml:"vm,omitempty"`
}

func init() {
	t["ClusterVmGroup"] = reflect.TypeOf((*ClusterVmGroup)(nil)).Elem()
}

type ClusterVmHostRuleInfo struct {
	ClusterRuleInfo

	VmGroupName             string `xml:"vmGroupName,omitempty"`
	AffineHostGroupName     string `xml:"affineHostGroupName,omitempty"`
	AntiAffineHostGroupName string `xml:"antiAffineHostGroupName,omitempty"`
}

func init() {
	t["ClusterVmHostRuleInfo"] = reflect.TypeOf((*ClusterVmHostRuleInfo)(nil)).Elem()
}

type ClusterVmToolsMonitoringSettings struct {
	DynamicData

	Enabled          *bool  `xml:"enabled"`
	VmMonitoring     string `xml:"vmMonitoring,omitempty"`
	ClusterSettings  *bool  `xml:"clusterSettings"`
	FailureInterval  int    `xml:"failureInterval,omitempty"`
	MinUpTime        int    `xml:"minUpTime,omitempty"`
	MaxFailures      int    `xml:"maxFailures,omitempty"`
	MaxFailureWindow int    `xml:"maxFailureWindow,omitempty"`
}

func init() {
	t["ClusterVmToolsMonitoringSettings"] = reflect.TypeOf((*ClusterVmToolsMonitoringSettings)(nil)).Elem()
}

type CollectorAddressUnset struct {
	DvsFault
}

func init() {
	t["CollectorAddressUnset"] = reflect.TypeOf((*CollectorAddressUnset)(nil)).Elem()
}

type CollectorAddressUnsetFault CollectorAddressUnset

func init() {
	t["CollectorAddressUnsetFault"] = reflect.TypeOf((*CollectorAddressUnsetFault)(nil)).Elem()
}

type ComplianceFailure struct {
	DynamicData

	FailureType    string             `xml:"failureType"`
	Message        LocalizableMessage `xml:"message"`
	ExpressionName string             `xml:"expressionName,omitempty"`
}

func init() {
	t["ComplianceFailure"] = reflect.TypeOf((*ComplianceFailure)(nil)).Elem()
}

type ComplianceLocator struct {
	DynamicData

	ExpressionName string              `xml:"expressionName"`
	ApplyPath      ProfilePropertyPath `xml:"applyPath"`
}

func init() {
	t["ComplianceLocator"] = reflect.TypeOf((*ComplianceLocator)(nil)).Elem()
}

type ComplianceProfile struct {
	DynamicData

	Expression     []BaseProfileExpression `xml:"expression,typeattr"`
	RootExpression string                  `xml:"rootExpression"`
}

func init() {
	t["ComplianceProfile"] = reflect.TypeOf((*ComplianceProfile)(nil)).Elem()
}

type ComplianceResult struct {
	DynamicData

	Profile          *ManagedObjectReference `xml:"profile,omitempty"`
	ComplianceStatus string                  `xml:"complianceStatus"`
	Entity           *ManagedObjectReference `xml:"entity,omitempty"`
	CheckTime        *time.Time              `xml:"checkTime"`
	Failure          []ComplianceFailure     `xml:"failure,omitempty"`
}

func init() {
	t["ComplianceResult"] = reflect.TypeOf((*ComplianceResult)(nil)).Elem()
}

type CompositePolicyOption struct {
	PolicyOption

	Option []BasePolicyOption `xml:"option,omitempty,typeattr"`
}

func init() {
	t["CompositePolicyOption"] = reflect.TypeOf((*CompositePolicyOption)(nil)).Elem()
}

type ComputeDiskPartitionInfo ComputeDiskPartitionInfoRequestType

func init() {
	t["ComputeDiskPartitionInfo"] = reflect.TypeOf((*ComputeDiskPartitionInfo)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResize ComputeDiskPartitionInfoForResizeRequestType

func init() {
	t["ComputeDiskPartitionInfoForResize"] = reflect.TypeOf((*ComputeDiskPartitionInfoForResize)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResizeRequestType struct {
	This            ManagedObjectReference      `xml:"_this"`
	Partition       HostScsiDiskPartition       `xml:"partition"`
	BlockRange      HostDiskPartitionBlockRange `xml:"blockRange"`
	PartitionFormat string                      `xml:"partitionFormat,omitempty"`
}

func init() {
	t["ComputeDiskPartitionInfoForResizeRequestType"] = reflect.TypeOf((*ComputeDiskPartitionInfoForResizeRequestType)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResizeResponse struct {
	Returnval HostDiskPartitionInfo `xml:"returnval"`
}

type ComputeDiskPartitionInfoRequestType struct {
	This            ManagedObjectReference  `xml:"_this"`
	DevicePath      string                  `xml:"devicePath"`
	Layout          HostDiskPartitionLayout `xml:"layout"`
	PartitionFormat string                  `xml:"partitionFormat,omitempty"`
}

func init() {
	t["ComputeDiskPartitionInfoRequestType"] = reflect.TypeOf((*ComputeDiskPartitionInfoRequestType)(nil)).Elem()
}

type ComputeDiskPartitionInfoResponse struct {
	Returnval HostDiskPartitionInfo `xml:"returnval"`
}

type ComputeResourceConfigInfo struct {
	DynamicData

	VmSwapPlacement           string `xml:"vmSwapPlacement"`
	SpbmEnabled               *bool  `xml:"spbmEnabled"`
	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty"`
}

func init() {
	t["ComputeResourceConfigInfo"] = reflect.TypeOf((*ComputeResourceConfigInfo)(nil)).Elem()
}

type ComputeResourceConfigSpec struct {
	DynamicData

	VmSwapPlacement           string `xml:"vmSwapPlacement,omitempty"`
	SpbmEnabled               *bool  `xml:"spbmEnabled"`
	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty"`
}

func init() {
	t["ComputeResourceConfigSpec"] = reflect.TypeOf((*ComputeResourceConfigSpec)(nil)).Elem()
}

type ComputeResourceEventArgument struct {
	EntityEventArgument

	ComputeResource ManagedObjectReference `xml:"computeResource"`
}

func init() {
	t["ComputeResourceEventArgument"] = reflect.TypeOf((*ComputeResourceEventArgument)(nil)).Elem()
}

type ComputeResourceHostSPBMLicenseInfo struct {
	DynamicData

	Host         ManagedObjectReference                                 `xml:"host"`
	LicenseState ComputeResourceHostSPBMLicenseInfoHostSPBMLicenseState `xml:"licenseState"`
}

func init() {
	t["ComputeResourceHostSPBMLicenseInfo"] = reflect.TypeOf((*ComputeResourceHostSPBMLicenseInfo)(nil)).Elem()
}

type ComputeResourceSummary struct {
	DynamicData

	TotalCpu          int                 `xml:"totalCpu"`
	TotalMemory       int64               `xml:"totalMemory"`
	NumCpuCores       int16               `xml:"numCpuCores"`
	NumCpuThreads     int16               `xml:"numCpuThreads"`
	EffectiveCpu      int                 `xml:"effectiveCpu"`
	EffectiveMemory   int64               `xml:"effectiveMemory"`
	NumHosts          int                 `xml:"numHosts"`
	NumEffectiveHosts int                 `xml:"numEffectiveHosts"`
	OverallStatus     ManagedEntityStatus `xml:"overallStatus"`
}

func init() {
	t["ComputeResourceSummary"] = reflect.TypeOf((*ComputeResourceSummary)(nil)).Elem()
}

type ConcurrentAccess struct {
	VimFault
}

func init() {
	t["ConcurrentAccess"] = reflect.TypeOf((*ConcurrentAccess)(nil)).Elem()
}

type ConcurrentAccessFault ConcurrentAccess

func init() {
	t["ConcurrentAccessFault"] = reflect.TypeOf((*ConcurrentAccessFault)(nil)).Elem()
}

type ConfigTarget struct {
	DynamicData

	NumCpus                     int                                     `xml:"numCpus"`
	NumCpuCores                 int                                     `xml:"numCpuCores"`
	NumNumaNodes                int                                     `xml:"numNumaNodes"`
	SmcPresent                  *bool                                   `xml:"smcPresent"`
	Datastore                   []VirtualMachineDatastoreInfo           `xml:"datastore,omitempty"`
	Network                     []VirtualMachineNetworkInfo             `xml:"network,omitempty"`
	OpaqueNetwork               []OpaqueNetworkTargetInfo               `xml:"opaqueNetwork,omitempty"`
	DistributedVirtualPortgroup []DistributedVirtualPortgroupInfo       `xml:"distributedVirtualPortgroup,omitempty"`
	DistributedVirtualSwitch    []DistributedVirtualSwitchInfo          `xml:"distributedVirtualSwitch,omitempty"`
	CdRom                       []VirtualMachineCdromInfo               `xml:"cdRom,omitempty"`
	Serial                      []VirtualMachineSerialInfo              `xml:"serial,omitempty"`
	Parallel                    []VirtualMachineParallelInfo            `xml:"parallel,omitempty"`
	Sound                       []VirtualMachineSoundInfo               `xml:"sound,omitempty"`
	Usb                         []VirtualMachineUsbInfo                 `xml:"usb,omitempty"`
	Floppy                      []VirtualMachineFloppyInfo              `xml:"floppy,omitempty"`
	LegacyNetworkInfo           []VirtualMachineLegacyNetworkSwitchInfo `xml:"legacyNetworkInfo,omitempty"`
	ScsiPassthrough             []VirtualMachineScsiPassthroughInfo     `xml:"scsiPassthrough,omitempty"`
	ScsiDisk                    []VirtualMachineScsiDiskDeviceInfo      `xml:"scsiDisk,omitempty"`
	IdeDisk                     []VirtualMachineIdeDiskDeviceInfo       `xml:"ideDisk,omitempty"`
	MaxMemMBOptimalPerf         int                                     `xml:"maxMemMBOptimalPerf"`
	ResourcePool                *ResourcePoolRuntimeInfo                `xml:"resourcePool,omitempty"`
	AutoVmotion                 *bool                                   `xml:"autoVmotion"`
	PciPassthrough              []BaseVirtualMachinePciPassthroughInfo  `xml:"pciPassthrough,omitempty,typeattr"`
	Sriov                       []VirtualMachineSriovInfo               `xml:"sriov,omitempty"`
	VFlashModule                []VirtualMachineVFlashModuleInfo        `xml:"vFlashModule,omitempty"`
}

func init() {
	t["ConfigTarget"] = reflect.TypeOf((*ConfigTarget)(nil)).Elem()
}

type ConfigureDatastoreIORMRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
	Spec      StorageIORMConfigSpec  `xml:"spec"`
}

func init() {
	t["ConfigureDatastoreIORMRequestType"] = reflect.TypeOf((*ConfigureDatastoreIORMRequestType)(nil)).Elem()
}

type ConfigureDatastoreIORM_Task ConfigureDatastoreIORMRequestType

func init() {
	t["ConfigureDatastoreIORM_Task"] = reflect.TypeOf((*ConfigureDatastoreIORM_Task)(nil)).Elem()
}

type ConfigureDatastoreIORM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureDatastorePrincipal ConfigureDatastorePrincipalRequestType

func init() {
	t["ConfigureDatastorePrincipal"] = reflect.TypeOf((*ConfigureDatastorePrincipal)(nil)).Elem()
}

type ConfigureDatastorePrincipalRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
	Password string                 `xml:"password,omitempty"`
}

func init() {
	t["ConfigureDatastorePrincipalRequestType"] = reflect.TypeOf((*ConfigureDatastorePrincipalRequestType)(nil)).Elem()
}

type ConfigureDatastorePrincipalResponse struct {
}

type ConfigureHostCacheRequestType struct {
	This ManagedObjectReference     `xml:"_this"`
	Spec HostCacheConfigurationSpec `xml:"spec"`
}

func init() {
	t["ConfigureHostCacheRequestType"] = reflect.TypeOf((*ConfigureHostCacheRequestType)(nil)).Elem()
}

type ConfigureHostCache_Task ConfigureHostCacheRequestType

func init() {
	t["ConfigureHostCache_Task"] = reflect.TypeOf((*ConfigureHostCache_Task)(nil)).Elem()
}

type ConfigureHostCache_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureLicenseSource ConfigureLicenseSourceRequestType

func init() {
	t["ConfigureLicenseSource"] = reflect.TypeOf((*ConfigureLicenseSource)(nil)).Elem()
}

type ConfigureLicenseSourceRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Host          *ManagedObjectReference `xml:"host,omitempty"`
	LicenseSource BaseLicenseSource       `xml:"licenseSource,typeattr"`
}

func init() {
	t["ConfigureLicenseSourceRequestType"] = reflect.TypeOf((*ConfigureLicenseSourceRequestType)(nil)).Elem()
}

type ConfigureLicenseSourceResponse struct {
}

type ConfigurePowerPolicy ConfigurePowerPolicyRequestType

func init() {
	t["ConfigurePowerPolicy"] = reflect.TypeOf((*ConfigurePowerPolicy)(nil)).Elem()
}

type ConfigurePowerPolicyRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  int                    `xml:"key"`
}

func init() {
	t["ConfigurePowerPolicyRequestType"] = reflect.TypeOf((*ConfigurePowerPolicyRequestType)(nil)).Elem()
}

type ConfigurePowerPolicyResponse struct {
}

type ConfigureStorageDrsForPodRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Pod    ManagedObjectReference `xml:"pod"`
	Spec   StorageDrsConfigSpec   `xml:"spec"`
	Modify bool                   `xml:"modify"`
}

func init() {
	t["ConfigureStorageDrsForPodRequestType"] = reflect.TypeOf((*ConfigureStorageDrsForPodRequestType)(nil)).Elem()
}

type ConfigureStorageDrsForPod_Task ConfigureStorageDrsForPodRequestType

func init() {
	t["ConfigureStorageDrsForPod_Task"] = reflect.TypeOf((*ConfigureStorageDrsForPod_Task)(nil)).Elem()
}

type ConfigureStorageDrsForPod_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureVFlashResourceExRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	DevicePath []string               `xml:"devicePath,omitempty"`
}

func init() {
	t["ConfigureVFlashResourceExRequestType"] = reflect.TypeOf((*ConfigureVFlashResourceExRequestType)(nil)).Elem()
}

type ConfigureVFlashResourceEx_Task ConfigureVFlashResourceExRequestType

func init() {
	t["ConfigureVFlashResourceEx_Task"] = reflect.TypeOf((*ConfigureVFlashResourceEx_Task)(nil)).Elem()
}

type ConfigureVFlashResourceEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConflictingConfiguration struct {
	DvsFault

	ConfigInConflict []ConflictingConfigurationConfig `xml:"configInConflict"`
}

func init() {
	t["ConflictingConfiguration"] = reflect.TypeOf((*ConflictingConfiguration)(nil)).Elem()
}

type ConflictingConfigurationConfig struct {
	DynamicData

	Entity       *ManagedObjectReference `xml:"entity,omitempty"`
	PropertyPath string                  `xml:"propertyPath"`
}

func init() {
	t["ConflictingConfigurationConfig"] = reflect.TypeOf((*ConflictingConfigurationConfig)(nil)).Elem()
}

type ConflictingConfigurationFault ConflictingConfiguration

func init() {
	t["ConflictingConfigurationFault"] = reflect.TypeOf((*ConflictingConfigurationFault)(nil)).Elem()
}

type ConflictingDatastoreFound struct {
	RuntimeFault

	Name string `xml:"name"`
	Url  string `xml:"url"`
}

func init() {
	t["ConflictingDatastoreFound"] = reflect.TypeOf((*ConflictingDatastoreFound)(nil)).Elem()
}

type ConflictingDatastoreFoundFault ConflictingDatastoreFound

func init() {
	t["ConflictingDatastoreFoundFault"] = reflect.TypeOf((*ConflictingDatastoreFoundFault)(nil)).Elem()
}

type ConnectedIso struct {
	OvfExport

	Cdrom    VirtualCdrom `xml:"cdrom"`
	Filename string       `xml:"filename"`
}

func init() {
	t["ConnectedIso"] = reflect.TypeOf((*ConnectedIso)(nil)).Elem()
}

type ConnectedIsoFault ConnectedIso

func init() {
	t["ConnectedIsoFault"] = reflect.TypeOf((*ConnectedIsoFault)(nil)).Elem()
}

type ConsolidateVMDisksRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ConsolidateVMDisksRequestType"] = reflect.TypeOf((*ConsolidateVMDisksRequestType)(nil)).Elem()
}

type ConsolidateVMDisks_Task ConsolidateVMDisksRequestType

func init() {
	t["ConsolidateVMDisks_Task"] = reflect.TypeOf((*ConsolidateVMDisks_Task)(nil)).Elem()
}

type ConsolidateVMDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ContinueRetrievePropertiesEx ContinueRetrievePropertiesExRequestType

func init() {
	t["ContinueRetrievePropertiesEx"] = reflect.TypeOf((*ContinueRetrievePropertiesEx)(nil)).Elem()
}

type ContinueRetrievePropertiesExRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Token string                 `xml:"token"`
}

func init() {
	t["ContinueRetrievePropertiesExRequestType"] = reflect.TypeOf((*ContinueRetrievePropertiesExRequestType)(nil)).Elem()
}

type ContinueRetrievePropertiesExResponse struct {
	Returnval RetrieveResult `xml:"returnval"`
}

type CopyDatastoreFileRequestType struct {
	This                  ManagedObjectReference  `xml:"_this"`
	SourceName            string                  `xml:"sourceName"`
	SourceDatacenter      *ManagedObjectReference `xml:"sourceDatacenter,omitempty"`
	DestinationName       string                  `xml:"destinationName"`
	DestinationDatacenter *ManagedObjectReference `xml:"destinationDatacenter,omitempty"`
	Force                 *bool                   `xml:"force"`
}

func init() {
	t["CopyDatastoreFileRequestType"] = reflect.TypeOf((*CopyDatastoreFileRequestType)(nil)).Elem()
}

type CopyDatastoreFile_Task CopyDatastoreFileRequestType

func init() {
	t["CopyDatastoreFile_Task"] = reflect.TypeOf((*CopyDatastoreFile_Task)(nil)).Elem()
}

type CopyDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CopyVirtualDiskRequestType struct {
	This             ManagedObjectReference  `xml:"_this"`
	SourceName       string                  `xml:"sourceName"`
	SourceDatacenter *ManagedObjectReference `xml:"sourceDatacenter,omitempty"`
	DestName         string                  `xml:"destName"`
	DestDatacenter   *ManagedObjectReference `xml:"destDatacenter,omitempty"`
	DestSpec         BaseVirtualDiskSpec     `xml:"destSpec,omitempty,typeattr"`
	Force            *bool                   `xml:"force"`
}

func init() {
	t["CopyVirtualDiskRequestType"] = reflect.TypeOf((*CopyVirtualDiskRequestType)(nil)).Elem()
}

type CopyVirtualDisk_Task CopyVirtualDiskRequestType

func init() {
	t["CopyVirtualDisk_Task"] = reflect.TypeOf((*CopyVirtualDisk_Task)(nil)).Elem()
}

type CopyVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CpuCompatibilityUnknown struct {
	CpuIncompatible
}

func init() {
	t["CpuCompatibilityUnknown"] = reflect.TypeOf((*CpuCompatibilityUnknown)(nil)).Elem()
}

type CpuCompatibilityUnknownFault CpuCompatibilityUnknown

func init() {
	t["CpuCompatibilityUnknownFault"] = reflect.TypeOf((*CpuCompatibilityUnknownFault)(nil)).Elem()
}

type CpuHotPlugNotSupported struct {
	VmConfigFault
}

func init() {
	t["CpuHotPlugNotSupported"] = reflect.TypeOf((*CpuHotPlugNotSupported)(nil)).Elem()
}

type CpuHotPlugNotSupportedFault CpuHotPlugNotSupported

func init() {
	t["CpuHotPlugNotSupportedFault"] = reflect.TypeOf((*CpuHotPlugNotSupportedFault)(nil)).Elem()
}

type CpuIncompatible struct {
	VirtualHardwareCompatibilityIssue

	Level        int                     `xml:"level"`
	RegisterName string                  `xml:"registerName"`
	RegisterBits string                  `xml:"registerBits,omitempty"`
	DesiredBits  string                  `xml:"desiredBits,omitempty"`
	Host         *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["CpuIncompatible"] = reflect.TypeOf((*CpuIncompatible)(nil)).Elem()
}

type CpuIncompatible1ECX struct {
	CpuIncompatible

	Sse3      bool  `xml:"sse3"`
	Pclmulqdq *bool `xml:"pclmulqdq"`
	Ssse3     bool  `xml:"ssse3"`
	Sse41     bool  `xml:"sse41"`
	Sse42     bool  `xml:"sse42"`
	Aes       *bool `xml:"aes"`
	Other     bool  `xml:"other"`
	OtherOnly bool  `xml:"otherOnly"`
}

func init() {
	t["CpuIncompatible1ECX"] = reflect.TypeOf((*CpuIncompatible1ECX)(nil)).Elem()
}

type CpuIncompatible1ECXFault CpuIncompatible1ECX

func init() {
	t["CpuIncompatible1ECXFault"] = reflect.TypeOf((*CpuIncompatible1ECXFault)(nil)).Elem()
}

type CpuIncompatible81EDX struct {
	CpuIncompatible

	Nx        bool `xml:"nx"`
	Ffxsr     bool `xml:"ffxsr"`
	Rdtscp    bool `xml:"rdtscp"`
	Lm        bool `xml:"lm"`
	Other     bool `xml:"other"`
	OtherOnly bool `xml:"otherOnly"`
}

func init() {
	t["CpuIncompatible81EDX"] = reflect.TypeOf((*CpuIncompatible81EDX)(nil)).Elem()
}

type CpuIncompatible81EDXFault CpuIncompatible81EDX

func init() {
	t["CpuIncompatible81EDXFault"] = reflect.TypeOf((*CpuIncompatible81EDXFault)(nil)).Elem()
}

type CpuIncompatibleFault BaseCpuIncompatible

func init() {
	t["CpuIncompatibleFault"] = reflect.TypeOf((*CpuIncompatibleFault)(nil)).Elem()
}

type CreateAlarm CreateAlarmRequestType

func init() {
	t["CreateAlarm"] = reflect.TypeOf((*CreateAlarm)(nil)).Elem()
}

type CreateAlarmRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Spec   BaseAlarmSpec          `xml:"spec,typeattr"`
}

func init() {
	t["CreateAlarmRequestType"] = reflect.TypeOf((*CreateAlarmRequestType)(nil)).Elem()
}

type CreateAlarmResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateChildVMRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Config VirtualMachineConfigSpec `xml:"config"`
	Host   *ManagedObjectReference  `xml:"host,omitempty"`
}

func init() {
	t["CreateChildVMRequestType"] = reflect.TypeOf((*CreateChildVMRequestType)(nil)).Elem()
}

type CreateChildVM_Task CreateChildVMRequestType

func init() {
	t["CreateChildVM_Task"] = reflect.TypeOf((*CreateChildVM_Task)(nil)).Elem()
}

type CreateChildVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCluster CreateClusterRequestType

func init() {
	t["CreateCluster"] = reflect.TypeOf((*CreateCluster)(nil)).Elem()
}

type CreateClusterEx CreateClusterExRequestType

func init() {
	t["CreateClusterEx"] = reflect.TypeOf((*CreateClusterEx)(nil)).Elem()
}

type CreateClusterExRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Spec ClusterConfigSpecEx    `xml:"spec"`
}

func init() {
	t["CreateClusterExRequestType"] = reflect.TypeOf((*CreateClusterExRequestType)(nil)).Elem()
}

type CreateClusterExResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateClusterRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Spec ClusterConfigSpec      `xml:"spec"`
}

func init() {
	t["CreateClusterRequestType"] = reflect.TypeOf((*CreateClusterRequestType)(nil)).Elem()
}

type CreateClusterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCollectorForEvents CreateCollectorForEventsRequestType

func init() {
	t["CreateCollectorForEvents"] = reflect.TypeOf((*CreateCollectorForEvents)(nil)).Elem()
}

type CreateCollectorForEventsRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Filter EventFilterSpec        `xml:"filter"`
}

func init() {
	t["CreateCollectorForEventsRequestType"] = reflect.TypeOf((*CreateCollectorForEventsRequestType)(nil)).Elem()
}

type CreateCollectorForEventsResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCollectorForTasks CreateCollectorForTasksRequestType

func init() {
	t["CreateCollectorForTasks"] = reflect.TypeOf((*CreateCollectorForTasks)(nil)).Elem()
}

type CreateCollectorForTasksRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Filter TaskFilterSpec         `xml:"filter"`
}

func init() {
	t["CreateCollectorForTasksRequestType"] = reflect.TypeOf((*CreateCollectorForTasksRequestType)(nil)).Elem()
}

type CreateCollectorForTasksResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateContainerView CreateContainerViewRequestType

func init() {
	t["CreateContainerView"] = reflect.TypeOf((*CreateContainerView)(nil)).Elem()
}

type CreateContainerViewRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Container ManagedObjectReference `xml:"container"`
	Type      []string               `xml:"type,omitempty"`
	Recursive bool                   `xml:"recursive"`
}

func init() {
	t["CreateContainerViewRequestType"] = reflect.TypeOf((*CreateContainerViewRequestType)(nil)).Elem()
}

type CreateContainerViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCustomizationSpec CreateCustomizationSpecRequestType

func init() {
	t["CreateCustomizationSpec"] = reflect.TypeOf((*CreateCustomizationSpec)(nil)).Elem()
}

type CreateCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Item CustomizationSpecItem  `xml:"item"`
}

func init() {
	t["CreateCustomizationSpecRequestType"] = reflect.TypeOf((*CreateCustomizationSpecRequestType)(nil)).Elem()
}

type CreateCustomizationSpecResponse struct {
}

type CreateDVPortgroupRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec DVPortgroupConfigSpec  `xml:"spec"`
}

func init() {
	t["CreateDVPortgroupRequestType"] = reflect.TypeOf((*CreateDVPortgroupRequestType)(nil)).Elem()
}

type CreateDVPortgroup_Task CreateDVPortgroupRequestType

func init() {
	t["CreateDVPortgroup_Task"] = reflect.TypeOf((*CreateDVPortgroup_Task)(nil)).Elem()
}

type CreateDVPortgroup_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateDVSRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec DVSCreateSpec          `xml:"spec"`
}

func init() {
	t["CreateDVSRequestType"] = reflect.TypeOf((*CreateDVSRequestType)(nil)).Elem()
}

type CreateDVS_Task CreateDVSRequestType

func init() {
	t["CreateDVS_Task"] = reflect.TypeOf((*CreateDVS_Task)(nil)).Elem()
}

type CreateDVS_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateDatacenter CreateDatacenterRequestType

func init() {
	t["CreateDatacenter"] = reflect.TypeOf((*CreateDatacenter)(nil)).Elem()
}

type CreateDatacenterRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["CreateDatacenterRequestType"] = reflect.TypeOf((*CreateDatacenterRequestType)(nil)).Elem()
}

type CreateDatacenterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateDefaultProfile CreateDefaultProfileRequestType

func init() {
	t["CreateDefaultProfile"] = reflect.TypeOf((*CreateDefaultProfile)(nil)).Elem()
}

type CreateDefaultProfileRequestType struct {
	This            ManagedObjectReference  `xml:"_this"`
	ProfileType     string                  `xml:"profileType"`
	ProfileTypeName string                  `xml:"profileTypeName,omitempty"`
	Profile         *ManagedObjectReference `xml:"profile,omitempty"`
}

func init() {
	t["CreateDefaultProfileRequestType"] = reflect.TypeOf((*CreateDefaultProfileRequestType)(nil)).Elem()
}

type CreateDefaultProfileResponse struct {
	Returnval BaseApplyProfile `xml:"returnval,typeattr"`
}

type CreateDescriptor CreateDescriptorRequestType

func init() {
	t["CreateDescriptor"] = reflect.TypeOf((*CreateDescriptor)(nil)).Elem()
}

type CreateDescriptorRequestType struct {
	This ManagedObjectReference    `xml:"_this"`
	Obj  ManagedObjectReference    `xml:"obj"`
	Cdp  OvfCreateDescriptorParams `xml:"cdp"`
}

func init() {
	t["CreateDescriptorRequestType"] = reflect.TypeOf((*CreateDescriptorRequestType)(nil)).Elem()
}

type CreateDescriptorResponse struct {
	Returnval OvfCreateDescriptorResult `xml:"returnval"`
}

type CreateDiagnosticPartition CreateDiagnosticPartitionRequestType

func init() {
	t["CreateDiagnosticPartition"] = reflect.TypeOf((*CreateDiagnosticPartition)(nil)).Elem()
}

type CreateDiagnosticPartitionRequestType struct {
	This ManagedObjectReference            `xml:"_this"`
	Spec HostDiagnosticPartitionCreateSpec `xml:"spec"`
}

func init() {
	t["CreateDiagnosticPartitionRequestType"] = reflect.TypeOf((*CreateDiagnosticPartitionRequestType)(nil)).Elem()
}

type CreateDiagnosticPartitionResponse struct {
}

type CreateDirectory CreateDirectoryRequestType

func init() {
	t["CreateDirectory"] = reflect.TypeOf((*CreateDirectory)(nil)).Elem()
}

type CreateDirectoryRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Datastore   ManagedObjectReference `xml:"datastore"`
	DisplayName string                 `xml:"displayName,omitempty"`
	Policy      string                 `xml:"policy,omitempty"`
}

func init() {
	t["CreateDirectoryRequestType"] = reflect.TypeOf((*CreateDirectoryRequestType)(nil)).Elem()
}

type CreateDirectoryResponse struct {
	Returnval string `xml:"returnval"`
}

type CreateFilter CreateFilterRequestType

func init() {
	t["CreateFilter"] = reflect.TypeOf((*CreateFilter)(nil)).Elem()
}

type CreateFilterRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	Spec           PropertyFilterSpec     `xml:"spec"`
	PartialUpdates bool                   `xml:"partialUpdates"`
}

func init() {
	t["CreateFilterRequestType"] = reflect.TypeOf((*CreateFilterRequestType)(nil)).Elem()
}

type CreateFilterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateFolder CreateFolderRequestType

func init() {
	t["CreateFolder"] = reflect.TypeOf((*CreateFolder)(nil)).Elem()
}

type CreateFolderRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["CreateFolderRequestType"] = reflect.TypeOf((*CreateFolderRequestType)(nil)).Elem()
}

type CreateFolderResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateGroup CreateGroupRequestType

func init() {
	t["CreateGroup"] = reflect.TypeOf((*CreateGroup)(nil)).Elem()
}

type CreateGroupRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Group BaseHostAccountSpec    `xml:"group,typeattr"`
}

func init() {
	t["CreateGroupRequestType"] = reflect.TypeOf((*CreateGroupRequestType)(nil)).Elem()
}

type CreateGroupResponse struct {
}

type CreateImportSpec CreateImportSpecRequestType

func init() {
	t["CreateImportSpec"] = reflect.TypeOf((*CreateImportSpec)(nil)).Elem()
}

type CreateImportSpecRequestType struct {
	This          ManagedObjectReference    `xml:"_this"`
	OvfDescriptor string                    `xml:"ovfDescriptor"`
	ResourcePool  ManagedObjectReference    `xml:"resourcePool"`
	Datastore     ManagedObjectReference    `xml:"datastore"`
	Cisp          OvfCreateImportSpecParams `xml:"cisp"`
}

func init() {
	t["CreateImportSpecRequestType"] = reflect.TypeOf((*CreateImportSpecRequestType)(nil)).Elem()
}

type CreateImportSpecResponse struct {
	Returnval OvfCreateImportSpecResult `xml:"returnval"`
}

type CreateInventoryView CreateInventoryViewRequestType

func init() {
	t["CreateInventoryView"] = reflect.TypeOf((*CreateInventoryView)(nil)).Elem()
}

type CreateInventoryViewRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CreateInventoryViewRequestType"] = reflect.TypeOf((*CreateInventoryViewRequestType)(nil)).Elem()
}

type CreateInventoryViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateIpPool CreateIpPoolRequestType

func init() {
	t["CreateIpPool"] = reflect.TypeOf((*CreateIpPool)(nil)).Elem()
}

type CreateIpPoolRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Dc   ManagedObjectReference `xml:"dc"`
	Pool IpPool                 `xml:"pool"`
}

func init() {
	t["CreateIpPoolRequestType"] = reflect.TypeOf((*CreateIpPoolRequestType)(nil)).Elem()
}

type CreateIpPoolResponse struct {
	Returnval int `xml:"returnval"`
}

type CreateListView CreateListViewRequestType

func init() {
	t["CreateListView"] = reflect.TypeOf((*CreateListView)(nil)).Elem()
}

type CreateListViewFromView CreateListViewFromViewRequestType

func init() {
	t["CreateListViewFromView"] = reflect.TypeOf((*CreateListViewFromView)(nil)).Elem()
}

type CreateListViewFromViewRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	View ManagedObjectReference `xml:"view"`
}

func init() {
	t["CreateListViewFromViewRequestType"] = reflect.TypeOf((*CreateListViewFromViewRequestType)(nil)).Elem()
}

type CreateListViewFromViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateListViewRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Obj  []ManagedObjectReference `xml:"obj,omitempty"`
}

func init() {
	t["CreateListViewRequestType"] = reflect.TypeOf((*CreateListViewRequestType)(nil)).Elem()
}

type CreateListViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateLocalDatastore CreateLocalDatastoreRequestType

func init() {
	t["CreateLocalDatastore"] = reflect.TypeOf((*CreateLocalDatastore)(nil)).Elem()
}

type CreateLocalDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Path string                 `xml:"path"`
}

func init() {
	t["CreateLocalDatastoreRequestType"] = reflect.TypeOf((*CreateLocalDatastoreRequestType)(nil)).Elem()
}

type CreateLocalDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateNasDatastore CreateNasDatastoreRequestType

func init() {
	t["CreateNasDatastore"] = reflect.TypeOf((*CreateNasDatastore)(nil)).Elem()
}

type CreateNasDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec HostNasVolumeSpec      `xml:"spec"`
}

func init() {
	t["CreateNasDatastoreRequestType"] = reflect.TypeOf((*CreateNasDatastoreRequestType)(nil)).Elem()
}

type CreateNasDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateObjectScheduledTask CreateObjectScheduledTaskRequestType

func init() {
	t["CreateObjectScheduledTask"] = reflect.TypeOf((*CreateObjectScheduledTask)(nil)).Elem()
}

type CreateObjectScheduledTaskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Obj  ManagedObjectReference `xml:"obj"`
	Spec BaseScheduledTaskSpec  `xml:"spec,typeattr"`
}

func init() {
	t["CreateObjectScheduledTaskRequestType"] = reflect.TypeOf((*CreateObjectScheduledTaskRequestType)(nil)).Elem()
}

type CreateObjectScheduledTaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreatePerfInterval CreatePerfIntervalRequestType

func init() {
	t["CreatePerfInterval"] = reflect.TypeOf((*CreatePerfInterval)(nil)).Elem()
}

type CreatePerfIntervalRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	IntervalId PerfInterval           `xml:"intervalId"`
}

func init() {
	t["CreatePerfIntervalRequestType"] = reflect.TypeOf((*CreatePerfIntervalRequestType)(nil)).Elem()
}

type CreatePerfIntervalResponse struct {
}

type CreateProfile CreateProfileRequestType

func init() {
	t["CreateProfile"] = reflect.TypeOf((*CreateProfile)(nil)).Elem()
}

type CreateProfileRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	CreateSpec BaseProfileCreateSpec  `xml:"createSpec,typeattr"`
}

func init() {
	t["CreateProfileRequestType"] = reflect.TypeOf((*CreateProfileRequestType)(nil)).Elem()
}

type CreateProfileResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreatePropertyCollector CreatePropertyCollectorRequestType

func init() {
	t["CreatePropertyCollector"] = reflect.TypeOf((*CreatePropertyCollector)(nil)).Elem()
}

type CreatePropertyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CreatePropertyCollectorRequestType"] = reflect.TypeOf((*CreatePropertyCollectorRequestType)(nil)).Elem()
}

type CreatePropertyCollectorResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateResourcePool CreateResourcePoolRequestType

func init() {
	t["CreateResourcePool"] = reflect.TypeOf((*CreateResourcePool)(nil)).Elem()
}

type CreateResourcePoolRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Spec ResourceConfigSpec     `xml:"spec"`
}

func init() {
	t["CreateResourcePoolRequestType"] = reflect.TypeOf((*CreateResourcePoolRequestType)(nil)).Elem()
}

type CreateResourcePoolResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateScheduledTask CreateScheduledTaskRequestType

func init() {
	t["CreateScheduledTask"] = reflect.TypeOf((*CreateScheduledTask)(nil)).Elem()
}

type CreateScheduledTaskRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Spec   BaseScheduledTaskSpec  `xml:"spec,typeattr"`
}

func init() {
	t["CreateScheduledTaskRequestType"] = reflect.TypeOf((*CreateScheduledTaskRequestType)(nil)).Elem()
}

type CreateScheduledTaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateScreenshotRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CreateScreenshotRequestType"] = reflect.TypeOf((*CreateScreenshotRequestType)(nil)).Elem()
}

type CreateScreenshot_Task CreateScreenshotRequestType

func init() {
	t["CreateScreenshot_Task"] = reflect.TypeOf((*CreateScreenshot_Task)(nil)).Elem()
}

type CreateScreenshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateSecondaryVMRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["CreateSecondaryVMRequestType"] = reflect.TypeOf((*CreateSecondaryVMRequestType)(nil)).Elem()
}

type CreateSecondaryVM_Task CreateSecondaryVMRequestType

func init() {
	t["CreateSecondaryVM_Task"] = reflect.TypeOf((*CreateSecondaryVM_Task)(nil)).Elem()
}

type CreateSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateSnapshotRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Name        string                 `xml:"name"`
	Description string                 `xml:"description,omitempty"`
	Memory      bool                   `xml:"memory"`
	Quiesce     bool                   `xml:"quiesce"`
}

func init() {
	t["CreateSnapshotRequestType"] = reflect.TypeOf((*CreateSnapshotRequestType)(nil)).Elem()
}

type CreateSnapshot_Task CreateSnapshotRequestType

func init() {
	t["CreateSnapshot_Task"] = reflect.TypeOf((*CreateSnapshot_Task)(nil)).Elem()
}

type CreateSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateStoragePod CreateStoragePodRequestType

func init() {
	t["CreateStoragePod"] = reflect.TypeOf((*CreateStoragePod)(nil)).Elem()
}

type CreateStoragePodRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["CreateStoragePodRequestType"] = reflect.TypeOf((*CreateStoragePodRequestType)(nil)).Elem()
}

type CreateStoragePodResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateTask CreateTaskRequestType

func init() {
	t["CreateTask"] = reflect.TypeOf((*CreateTask)(nil)).Elem()
}

type CreateTaskAction struct {
	Action

	TaskTypeId string `xml:"taskTypeId"`
	Cancelable bool   `xml:"cancelable"`
}

func init() {
	t["CreateTaskAction"] = reflect.TypeOf((*CreateTaskAction)(nil)).Elem()
}

type CreateTaskRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	Obj           ManagedObjectReference `xml:"obj"`
	TaskTypeId    string                 `xml:"taskTypeId"`
	InitiatedBy   string                 `xml:"initiatedBy,omitempty"`
	Cancelable    bool                   `xml:"cancelable"`
	ParentTaskKey string                 `xml:"parentTaskKey,omitempty"`
}

func init() {
	t["CreateTaskRequestType"] = reflect.TypeOf((*CreateTaskRequestType)(nil)).Elem()
}

type CreateTaskResponse struct {
	Returnval TaskInfo `xml:"returnval"`
}

type CreateTemporaryDirectoryInGuest CreateTemporaryDirectoryInGuestRequestType

func init() {
	t["CreateTemporaryDirectoryInGuest"] = reflect.TypeOf((*CreateTemporaryDirectoryInGuest)(nil)).Elem()
}

type CreateTemporaryDirectoryInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	Prefix        string                  `xml:"prefix"`
	Suffix        string                  `xml:"suffix"`
	DirectoryPath string                  `xml:"directoryPath,omitempty"`
}

func init() {
	t["CreateTemporaryDirectoryInGuestRequestType"] = reflect.TypeOf((*CreateTemporaryDirectoryInGuestRequestType)(nil)).Elem()
}

type CreateTemporaryDirectoryInGuestResponse struct {
	Returnval string `xml:"returnval"`
}

type CreateTemporaryFileInGuest CreateTemporaryFileInGuestRequestType

func init() {
	t["CreateTemporaryFileInGuest"] = reflect.TypeOf((*CreateTemporaryFileInGuest)(nil)).Elem()
}

type CreateTemporaryFileInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	Prefix        string                  `xml:"prefix"`
	Suffix        string                  `xml:"suffix"`
	DirectoryPath string                  `xml:"directoryPath,omitempty"`
}

func init() {
	t["CreateTemporaryFileInGuestRequestType"] = reflect.TypeOf((*CreateTemporaryFileInGuestRequestType)(nil)).Elem()
}

type CreateTemporaryFileInGuestResponse struct {
	Returnval string `xml:"returnval"`
}

type CreateUser CreateUserRequestType

func init() {
	t["CreateUser"] = reflect.TypeOf((*CreateUser)(nil)).Elem()
}

type CreateUserRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	User BaseHostAccountSpec    `xml:"user,typeattr"`
}

func init() {
	t["CreateUserRequestType"] = reflect.TypeOf((*CreateUserRequestType)(nil)).Elem()
}

type CreateUserResponse struct {
}

type CreateVApp CreateVAppRequestType

func init() {
	t["CreateVApp"] = reflect.TypeOf((*CreateVApp)(nil)).Elem()
}

type CreateVAppRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	ResSpec    ResourceConfigSpec      `xml:"resSpec"`
	ConfigSpec VAppConfigSpec          `xml:"configSpec"`
	VmFolder   *ManagedObjectReference `xml:"vmFolder,omitempty"`
}

func init() {
	t["CreateVAppRequestType"] = reflect.TypeOf((*CreateVAppRequestType)(nil)).Elem()
}

type CreateVAppResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateVMRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Config VirtualMachineConfigSpec `xml:"config"`
	Pool   ManagedObjectReference   `xml:"pool"`
	Host   *ManagedObjectReference  `xml:"host,omitempty"`
}

func init() {
	t["CreateVMRequestType"] = reflect.TypeOf((*CreateVMRequestType)(nil)).Elem()
}

type CreateVM_Task CreateVMRequestType

func init() {
	t["CreateVM_Task"] = reflect.TypeOf((*CreateVM_Task)(nil)).Elem()
}

type CreateVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Spec       BaseVirtualDiskSpec     `xml:"spec,typeattr"`
}

func init() {
	t["CreateVirtualDiskRequestType"] = reflect.TypeOf((*CreateVirtualDiskRequestType)(nil)).Elem()
}

type CreateVirtualDisk_Task CreateVirtualDiskRequestType

func init() {
	t["CreateVirtualDisk_Task"] = reflect.TypeOf((*CreateVirtualDisk_Task)(nil)).Elem()
}

type CreateVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateVmfsDatastore CreateVmfsDatastoreRequestType

func init() {
	t["CreateVmfsDatastore"] = reflect.TypeOf((*CreateVmfsDatastore)(nil)).Elem()
}

type CreateVmfsDatastoreRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Spec VmfsDatastoreCreateSpec `xml:"spec"`
}

func init() {
	t["CreateVmfsDatastoreRequestType"] = reflect.TypeOf((*CreateVmfsDatastoreRequestType)(nil)).Elem()
}

type CreateVmfsDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CurrentTime CurrentTimeRequestType

func init() {
	t["CurrentTime"] = reflect.TypeOf((*CurrentTime)(nil)).Elem()
}

type CurrentTimeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CurrentTimeRequestType"] = reflect.TypeOf((*CurrentTimeRequestType)(nil)).Elem()
}

type CurrentTimeResponse struct {
	Returnval time.Time `xml:"returnval"`
}

type CustomFieldDef struct {
	DynamicData

	Key                     int                 `xml:"key"`
	Name                    string              `xml:"name"`
	Type                    string              `xml:"type"`
	ManagedObjectType       string              `xml:"managedObjectType,omitempty"`
	FieldDefPrivileges      *PrivilegePolicyDef `xml:"fieldDefPrivileges,omitempty"`
	FieldInstancePrivileges *PrivilegePolicyDef `xml:"fieldInstancePrivileges,omitempty"`
}

func init() {
	t["CustomFieldDef"] = reflect.TypeOf((*CustomFieldDef)(nil)).Elem()
}

type CustomFieldDefAddedEvent struct {
	CustomFieldDefEvent
}

func init() {
	t["CustomFieldDefAddedEvent"] = reflect.TypeOf((*CustomFieldDefAddedEvent)(nil)).Elem()
}

type CustomFieldDefEvent struct {
	CustomFieldEvent

	FieldKey int    `xml:"fieldKey"`
	Name     string `xml:"name"`
}

func init() {
	t["CustomFieldDefEvent"] = reflect.TypeOf((*CustomFieldDefEvent)(nil)).Elem()
}

type CustomFieldDefRemovedEvent struct {
	CustomFieldDefEvent
}

func init() {
	t["CustomFieldDefRemovedEvent"] = reflect.TypeOf((*CustomFieldDefRemovedEvent)(nil)).Elem()
}

type CustomFieldDefRenamedEvent struct {
	CustomFieldDefEvent

	NewName string `xml:"newName"`
}

func init() {
	t["CustomFieldDefRenamedEvent"] = reflect.TypeOf((*CustomFieldDefRenamedEvent)(nil)).Elem()
}

type CustomFieldEvent struct {
	Event
}

func init() {
	t["CustomFieldEvent"] = reflect.TypeOf((*CustomFieldEvent)(nil)).Elem()
}

type CustomFieldStringValue struct {
	CustomFieldValue

	Value string `xml:"value"`
}

func init() {
	t["CustomFieldStringValue"] = reflect.TypeOf((*CustomFieldStringValue)(nil)).Elem()
}

type CustomFieldValue struct {
	DynamicData

	Key int `xml:"key"`
}

func init() {
	t["CustomFieldValue"] = reflect.TypeOf((*CustomFieldValue)(nil)).Elem()
}

type CustomFieldValueChangedEvent struct {
	CustomFieldEvent

	Entity   ManagedEntityEventArgument `xml:"entity"`
	FieldKey int                        `xml:"fieldKey"`
	Name     string                     `xml:"name"`
	Value    string                     `xml:"value"`
}

func init() {
	t["CustomFieldValueChangedEvent"] = reflect.TypeOf((*CustomFieldValueChangedEvent)(nil)).Elem()
}

type CustomizationAdapterMapping struct {
	DynamicData

	MacAddress string                  `xml:"macAddress,omitempty"`
	Adapter    CustomizationIPSettings `xml:"adapter"`
}

func init() {
	t["CustomizationAdapterMapping"] = reflect.TypeOf((*CustomizationAdapterMapping)(nil)).Elem()
}

type CustomizationAutoIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationAutoIpV6Generator"] = reflect.TypeOf((*CustomizationAutoIpV6Generator)(nil)).Elem()
}

type CustomizationCustomIpGenerator struct {
	CustomizationIpGenerator

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomIpGenerator"] = reflect.TypeOf((*CustomizationCustomIpGenerator)(nil)).Elem()
}

type CustomizationCustomIpV6Generator struct {
	CustomizationIpV6Generator

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomIpV6Generator"] = reflect.TypeOf((*CustomizationCustomIpV6Generator)(nil)).Elem()
}

type CustomizationCustomName struct {
	CustomizationName

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomName"] = reflect.TypeOf((*CustomizationCustomName)(nil)).Elem()
}

type CustomizationDhcpIpGenerator struct {
	CustomizationIpGenerator
}

func init() {
	t["CustomizationDhcpIpGenerator"] = reflect.TypeOf((*CustomizationDhcpIpGenerator)(nil)).Elem()
}

type CustomizationDhcpIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationDhcpIpV6Generator"] = reflect.TypeOf((*CustomizationDhcpIpV6Generator)(nil)).Elem()
}

type CustomizationEvent struct {
	VmEvent

	LogLocation string `xml:"logLocation,omitempty"`
}

func init() {
	t["CustomizationEvent"] = reflect.TypeOf((*CustomizationEvent)(nil)).Elem()
}

type CustomizationFailed struct {
	CustomizationEvent
}

func init() {
	t["CustomizationFailed"] = reflect.TypeOf((*CustomizationFailed)(nil)).Elem()
}

type CustomizationFault struct {
	VimFault
}

func init() {
	t["CustomizationFault"] = reflect.TypeOf((*CustomizationFault)(nil)).Elem()
}

type CustomizationFaultFault BaseCustomizationFault

func init() {
	t["CustomizationFaultFault"] = reflect.TypeOf((*CustomizationFaultFault)(nil)).Elem()
}

type CustomizationFixedIp struct {
	CustomizationIpGenerator

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["CustomizationFixedIp"] = reflect.TypeOf((*CustomizationFixedIp)(nil)).Elem()
}

type CustomizationFixedIpV6 struct {
	CustomizationIpV6Generator

	IpAddress  string `xml:"ipAddress"`
	SubnetMask int    `xml:"subnetMask"`
}

func init() {
	t["CustomizationFixedIpV6"] = reflect.TypeOf((*CustomizationFixedIpV6)(nil)).Elem()
}

type CustomizationFixedName struct {
	CustomizationName

	Name string `xml:"name"`
}

func init() {
	t["CustomizationFixedName"] = reflect.TypeOf((*CustomizationFixedName)(nil)).Elem()
}

type CustomizationGlobalIPSettings struct {
	DynamicData

	DnsSuffixList []string `xml:"dnsSuffixList,omitempty"`
	DnsServerList []string `xml:"dnsServerList,omitempty"`
}

func init() {
	t["CustomizationGlobalIPSettings"] = reflect.TypeOf((*CustomizationGlobalIPSettings)(nil)).Elem()
}

type CustomizationGuiRunOnce struct {
	DynamicData

	CommandList []string `xml:"commandList"`
}

func init() {
	t["CustomizationGuiRunOnce"] = reflect.TypeOf((*CustomizationGuiRunOnce)(nil)).Elem()
}

type CustomizationGuiUnattended struct {
	DynamicData

	Password       *CustomizationPassword `xml:"password,omitempty"`
	TimeZone       int                    `xml:"timeZone"`
	AutoLogon      bool                   `xml:"autoLogon"`
	AutoLogonCount int                    `xml:"autoLogonCount"`
}

func init() {
	t["CustomizationGuiUnattended"] = reflect.TypeOf((*CustomizationGuiUnattended)(nil)).Elem()
}

type CustomizationIPSettings struct {
	DynamicData

	Ip            BaseCustomizationIpGenerator            `xml:"ip,typeattr"`
	SubnetMask    string                                  `xml:"subnetMask,omitempty"`
	Gateway       []string                                `xml:"gateway,omitempty"`
	IpV6Spec      *CustomizationIPSettingsIpV6AddressSpec `xml:"ipV6Spec,omitempty"`
	DnsServerList []string                                `xml:"dnsServerList,omitempty"`
	DnsDomain     string                                  `xml:"dnsDomain,omitempty"`
	PrimaryWINS   string                                  `xml:"primaryWINS,omitempty"`
	SecondaryWINS string                                  `xml:"secondaryWINS,omitempty"`
	NetBIOS       CustomizationNetBIOSMode                `xml:"netBIOS,omitempty"`
}

func init() {
	t["CustomizationIPSettings"] = reflect.TypeOf((*CustomizationIPSettings)(nil)).Elem()
}

type CustomizationIPSettingsIpV6AddressSpec struct {
	DynamicData

	Ip      []BaseCustomizationIpV6Generator `xml:"ip,typeattr"`
	Gateway []string                         `xml:"gateway,omitempty"`
}

func init() {
	t["CustomizationIPSettingsIpV6AddressSpec"] = reflect.TypeOf((*CustomizationIPSettingsIpV6AddressSpec)(nil)).Elem()
}

type CustomizationIdentification struct {
	DynamicData

	JoinWorkgroup       string                 `xml:"joinWorkgroup,omitempty"`
	JoinDomain          string                 `xml:"joinDomain,omitempty"`
	DomainAdmin         string                 `xml:"domainAdmin,omitempty"`
	DomainAdminPassword *CustomizationPassword `xml:"domainAdminPassword,omitempty"`
}

func init() {
	t["CustomizationIdentification"] = reflect.TypeOf((*CustomizationIdentification)(nil)).Elem()
}

type CustomizationIdentitySettings struct {
	DynamicData
}

func init() {
	t["CustomizationIdentitySettings"] = reflect.TypeOf((*CustomizationIdentitySettings)(nil)).Elem()
}

type CustomizationIpGenerator struct {
	DynamicData
}

func init() {
	t["CustomizationIpGenerator"] = reflect.TypeOf((*CustomizationIpGenerator)(nil)).Elem()
}

type CustomizationIpV6Generator struct {
	DynamicData
}

func init() {
	t["CustomizationIpV6Generator"] = reflect.TypeOf((*CustomizationIpV6Generator)(nil)).Elem()
}

type CustomizationLicenseFilePrintData struct {
	DynamicData

	AutoMode  CustomizationLicenseDataMode `xml:"autoMode"`
	AutoUsers int                          `xml:"autoUsers,omitempty"`
}

func init() {
	t["CustomizationLicenseFilePrintData"] = reflect.TypeOf((*CustomizationLicenseFilePrintData)(nil)).Elem()
}

type CustomizationLinuxIdentityFailed struct {
	CustomizationFailed
}

func init() {
	t["CustomizationLinuxIdentityFailed"] = reflect.TypeOf((*CustomizationLinuxIdentityFailed)(nil)).Elem()
}

type CustomizationLinuxOptions struct {
	CustomizationOptions
}

func init() {
	t["CustomizationLinuxOptions"] = reflect.TypeOf((*CustomizationLinuxOptions)(nil)).Elem()
}

type CustomizationLinuxPrep struct {
	CustomizationIdentitySettings

	HostName   BaseCustomizationName `xml:"hostName,typeattr"`
	Domain     string                `xml:"domain"`
	TimeZone   string                `xml:"timeZone,omitempty"`
	HwClockUTC *bool                 `xml:"hwClockUTC"`
}

func init() {
	t["CustomizationLinuxPrep"] = reflect.TypeOf((*CustomizationLinuxPrep)(nil)).Elem()
}

type CustomizationName struct {
	DynamicData
}

func init() {
	t["CustomizationName"] = reflect.TypeOf((*CustomizationName)(nil)).Elem()
}

type CustomizationNetworkSetupFailed struct {
	CustomizationFailed
}

func init() {
	t["CustomizationNetworkSetupFailed"] = reflect.TypeOf((*CustomizationNetworkSetupFailed)(nil)).Elem()
}

type CustomizationOptions struct {
	DynamicData
}

func init() {
	t["CustomizationOptions"] = reflect.TypeOf((*CustomizationOptions)(nil)).Elem()
}

type CustomizationPassword struct {
	DynamicData

	Value     string `xml:"value"`
	PlainText bool   `xml:"plainText"`
}

func init() {
	t["CustomizationPassword"] = reflect.TypeOf((*CustomizationPassword)(nil)).Elem()
}

type CustomizationPending struct {
	CustomizationFault
}

func init() {
	t["CustomizationPending"] = reflect.TypeOf((*CustomizationPending)(nil)).Elem()
}

type CustomizationPendingFault CustomizationPending

func init() {
	t["CustomizationPendingFault"] = reflect.TypeOf((*CustomizationPendingFault)(nil)).Elem()
}

type CustomizationPrefixName struct {
	CustomizationName

	Base string `xml:"base"`
}

func init() {
	t["CustomizationPrefixName"] = reflect.TypeOf((*CustomizationPrefixName)(nil)).Elem()
}

type CustomizationSpec struct {
	DynamicData

	Options          BaseCustomizationOptions          `xml:"options,omitempty,typeattr"`
	Identity         BaseCustomizationIdentitySettings `xml:"identity,typeattr"`
	GlobalIPSettings CustomizationGlobalIPSettings     `xml:"globalIPSettings"`
	NicSettingMap    []CustomizationAdapterMapping     `xml:"nicSettingMap,omitempty"`
	EncryptionKey    []byte                            `xml:"encryptionKey,omitempty"`
}

func init() {
	t["CustomizationSpec"] = reflect.TypeOf((*CustomizationSpec)(nil)).Elem()
}

type CustomizationSpecInfo struct {
	DynamicData

	Name           string     `xml:"name"`
	Description    string     `xml:"description"`
	Type           string     `xml:"type"`
	ChangeVersion  string     `xml:"changeVersion,omitempty"`
	LastUpdateTime *time.Time `xml:"lastUpdateTime"`
}

func init() {
	t["CustomizationSpecInfo"] = reflect.TypeOf((*CustomizationSpecInfo)(nil)).Elem()
}

type CustomizationSpecItem struct {
	DynamicData

	Info CustomizationSpecInfo `xml:"info"`
	Spec CustomizationSpec     `xml:"spec"`
}

func init() {
	t["CustomizationSpecItem"] = reflect.TypeOf((*CustomizationSpecItem)(nil)).Elem()
}

type CustomizationSpecItemToXml CustomizationSpecItemToXmlRequestType

func init() {
	t["CustomizationSpecItemToXml"] = reflect.TypeOf((*CustomizationSpecItemToXml)(nil)).Elem()
}

type CustomizationSpecItemToXmlRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Item CustomizationSpecItem  `xml:"item"`
}

func init() {
	t["CustomizationSpecItemToXmlRequestType"] = reflect.TypeOf((*CustomizationSpecItemToXmlRequestType)(nil)).Elem()
}

type CustomizationSpecItemToXmlResponse struct {
	Returnval string `xml:"returnval"`
}

type CustomizationStartedEvent struct {
	CustomizationEvent
}

func init() {
	t["CustomizationStartedEvent"] = reflect.TypeOf((*CustomizationStartedEvent)(nil)).Elem()
}

type CustomizationStatelessIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationStatelessIpV6Generator"] = reflect.TypeOf((*CustomizationStatelessIpV6Generator)(nil)).Elem()
}

type CustomizationSucceeded struct {
	CustomizationEvent
}

func init() {
	t["CustomizationSucceeded"] = reflect.TypeOf((*CustomizationSucceeded)(nil)).Elem()
}

type CustomizationSysprep struct {
	CustomizationIdentitySettings

	GuiUnattended        CustomizationGuiUnattended         `xml:"guiUnattended"`
	UserData             CustomizationUserData              `xml:"userData"`
	GuiRunOnce           *CustomizationGuiRunOnce           `xml:"guiRunOnce,omitempty"`
	Identification       CustomizationIdentification        `xml:"identification"`
	LicenseFilePrintData *CustomizationLicenseFilePrintData `xml:"licenseFilePrintData,omitempty"`
}

func init() {
	t["CustomizationSysprep"] = reflect.TypeOf((*CustomizationSysprep)(nil)).Elem()
}

type CustomizationSysprepFailed struct {
	CustomizationFailed

	SysprepVersion string `xml:"sysprepVersion"`
	SystemVersion  string `xml:"systemVersion"`
}

func init() {
	t["CustomizationSysprepFailed"] = reflect.TypeOf((*CustomizationSysprepFailed)(nil)).Elem()
}

type CustomizationSysprepText struct {
	CustomizationIdentitySettings

	Value string `xml:"value"`
}

func init() {
	t["CustomizationSysprepText"] = reflect.TypeOf((*CustomizationSysprepText)(nil)).Elem()
}

type CustomizationUnknownFailure struct {
	CustomizationFailed
}

func init() {
	t["CustomizationUnknownFailure"] = reflect.TypeOf((*CustomizationUnknownFailure)(nil)).Elem()
}

type CustomizationUnknownIpGenerator struct {
	CustomizationIpGenerator
}

func init() {
	t["CustomizationUnknownIpGenerator"] = reflect.TypeOf((*CustomizationUnknownIpGenerator)(nil)).Elem()
}

type CustomizationUnknownIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationUnknownIpV6Generator"] = reflect.TypeOf((*CustomizationUnknownIpV6Generator)(nil)).Elem()
}

type CustomizationUnknownName struct {
	CustomizationName
}

func init() {
	t["CustomizationUnknownName"] = reflect.TypeOf((*CustomizationUnknownName)(nil)).Elem()
}

type CustomizationUserData struct {
	DynamicData

	FullName     string                `xml:"fullName"`
	OrgName      string                `xml:"orgName"`
	ComputerName BaseCustomizationName `xml:"computerName,typeattr"`
	ProductId    string                `xml:"productId"`
}

func init() {
	t["CustomizationUserData"] = reflect.TypeOf((*CustomizationUserData)(nil)).Elem()
}

type CustomizationVirtualMachineName struct {
	CustomizationName
}

func init() {
	t["CustomizationVirtualMachineName"] = reflect.TypeOf((*CustomizationVirtualMachineName)(nil)).Elem()
}

type CustomizationWinOptions struct {
	CustomizationOptions

	ChangeSID      bool                             `xml:"changeSID"`
	DeleteAccounts bool                             `xml:"deleteAccounts"`
	Reboot         CustomizationSysprepRebootOption `xml:"reboot,omitempty"`
}

func init() {
	t["CustomizationWinOptions"] = reflect.TypeOf((*CustomizationWinOptions)(nil)).Elem()
}

type CustomizeVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec CustomizationSpec      `xml:"spec"`
}

func init() {
	t["CustomizeVMRequestType"] = reflect.TypeOf((*CustomizeVMRequestType)(nil)).Elem()
}

type CustomizeVM_Task CustomizeVMRequestType

func init() {
	t["CustomizeVM_Task"] = reflect.TypeOf((*CustomizeVM_Task)(nil)).Elem()
}

type CustomizeVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVPortConfigInfo struct {
	DynamicData

	Name          string                   `xml:"name,omitempty"`
	Scope         []ManagedObjectReference `xml:"scope,omitempty"`
	Description   string                   `xml:"description,omitempty"`
	Setting       BaseDVPortSetting        `xml:"setting,omitempty,typeattr"`
	ConfigVersion string                   `xml:"configVersion"`
}

func init() {
	t["DVPortConfigInfo"] = reflect.TypeOf((*DVPortConfigInfo)(nil)).Elem()
}

type DVPortConfigSpec struct {
	DynamicData

	Operation     string                   `xml:"operation"`
	Key           string                   `xml:"key,omitempty"`
	Name          string                   `xml:"name,omitempty"`
	Scope         []ManagedObjectReference `xml:"scope,omitempty"`
	Description   string                   `xml:"description,omitempty"`
	Setting       BaseDVPortSetting        `xml:"setting,omitempty,typeattr"`
	ConfigVersion string                   `xml:"configVersion,omitempty"`
}

func init() {
	t["DVPortConfigSpec"] = reflect.TypeOf((*DVPortConfigSpec)(nil)).Elem()
}

type DVPortNotSupported struct {
	DeviceBackingNotSupported
}

func init() {
	t["DVPortNotSupported"] = reflect.TypeOf((*DVPortNotSupported)(nil)).Elem()
}

type DVPortNotSupportedFault DVPortNotSupported

func init() {
	t["DVPortNotSupportedFault"] = reflect.TypeOf((*DVPortNotSupportedFault)(nil)).Elem()
}

type DVPortSetting struct {
	DynamicData

	Blocked                 *BoolPolicy              `xml:"blocked,omitempty"`
	VmDirectPathGen2Allowed *BoolPolicy              `xml:"vmDirectPathGen2Allowed,omitempty"`
	InShapingPolicy         *DVSTrafficShapingPolicy `xml:"inShapingPolicy,omitempty"`
	OutShapingPolicy        *DVSTrafficShapingPolicy `xml:"outShapingPolicy,omitempty"`
	VendorSpecificConfig    *DVSVendorSpecificConfig `xml:"vendorSpecificConfig,omitempty"`
	NetworkResourcePoolKey  *StringPolicy            `xml:"networkResourcePoolKey,omitempty"`
	FilterPolicy            *DvsFilterPolicy         `xml:"filterPolicy,omitempty"`
}

func init() {
	t["DVPortSetting"] = reflect.TypeOf((*DVPortSetting)(nil)).Elem()
}

type DVPortState struct {
	DynamicData

	RuntimeInfo         *DVPortStatus                             `xml:"runtimeInfo,omitempty"`
	Stats               DistributedVirtualSwitchPortStatistics    `xml:"stats"`
	VendorSpecificState []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificState,omitempty"`
}

func init() {
	t["DVPortState"] = reflect.TypeOf((*DVPortState)(nil)).Elem()
}

type DVPortStatus struct {
	DynamicData

	LinkUp                                 bool           `xml:"linkUp"`
	Blocked                                bool           `xml:"blocked"`
	VlanIds                                []NumericRange `xml:"vlanIds,omitempty"`
	TrunkingMode                           *bool          `xml:"trunkingMode"`
	Mtu                                    int            `xml:"mtu,omitempty"`
	LinkPeer                               string         `xml:"linkPeer,omitempty"`
	MacAddress                             string         `xml:"macAddress,omitempty"`
	StatusDetail                           string         `xml:"statusDetail,omitempty"`
	VmDirectPathGen2Active                 *bool          `xml:"vmDirectPathGen2Active"`
	VmDirectPathGen2InactiveReasonNetwork  []string       `xml:"vmDirectPathGen2InactiveReasonNetwork,omitempty"`
	VmDirectPathGen2InactiveReasonOther    []string       `xml:"vmDirectPathGen2InactiveReasonOther,omitempty"`
	VmDirectPathGen2InactiveReasonExtended string         `xml:"vmDirectPathGen2InactiveReasonExtended,omitempty"`
}

func init() {
	t["DVPortStatus"] = reflect.TypeOf((*DVPortStatus)(nil)).Elem()
}

type DVPortgroupConfigInfo struct {
	DynamicData

	Key                      string                                    `xml:"key"`
	Name                     string                                    `xml:"name"`
	NumPorts                 int                                       `xml:"numPorts"`
	DistributedVirtualSwitch *ManagedObjectReference                   `xml:"distributedVirtualSwitch,omitempty"`
	DefaultPortConfig        BaseDVPortSetting                         `xml:"defaultPortConfig,omitempty,typeattr"`
	Description              string                                    `xml:"description,omitempty"`
	Type                     string                                    `xml:"type"`
	Policy                   BaseDVPortgroupPolicy                     `xml:"policy,typeattr"`
	PortNameFormat           string                                    `xml:"portNameFormat,omitempty"`
	Scope                    []ManagedObjectReference                  `xml:"scope,omitempty"`
	VendorSpecificConfig     []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty"`
	ConfigVersion            string                                    `xml:"configVersion,omitempty"`
	AutoExpand               *bool                                     `xml:"autoExpand"`
}

func init() {
	t["DVPortgroupConfigInfo"] = reflect.TypeOf((*DVPortgroupConfigInfo)(nil)).Elem()
}

type DVPortgroupConfigSpec struct {
	DynamicData

	ConfigVersion        string                                    `xml:"configVersion,omitempty"`
	Name                 string                                    `xml:"name,omitempty"`
	NumPorts             int                                       `xml:"numPorts,omitempty"`
	PortNameFormat       string                                    `xml:"portNameFormat,omitempty"`
	DefaultPortConfig    BaseDVPortSetting                         `xml:"defaultPortConfig,omitempty,typeattr"`
	Description          string                                    `xml:"description,omitempty"`
	Type                 string                                    `xml:"type,omitempty"`
	Scope                []ManagedObjectReference                  `xml:"scope,omitempty"`
	Policy               BaseDVPortgroupPolicy                     `xml:"policy,omitempty,typeattr"`
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty"`
	AutoExpand           *bool                                     `xml:"autoExpand"`
}

func init() {
	t["DVPortgroupConfigSpec"] = reflect.TypeOf((*DVPortgroupConfigSpec)(nil)).Elem()
}

type DVPortgroupCreatedEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DVPortgroupCreatedEvent"] = reflect.TypeOf((*DVPortgroupCreatedEvent)(nil)).Elem()
}

type DVPortgroupDestroyedEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DVPortgroupDestroyedEvent"] = reflect.TypeOf((*DVPortgroupDestroyedEvent)(nil)).Elem()
}

type DVPortgroupEvent struct {
	Event
}

func init() {
	t["DVPortgroupEvent"] = reflect.TypeOf((*DVPortgroupEvent)(nil)).Elem()
}

type DVPortgroupPolicy struct {
	DynamicData

	BlockOverrideAllowed               bool  `xml:"blockOverrideAllowed"`
	ShapingOverrideAllowed             bool  `xml:"shapingOverrideAllowed"`
	VendorConfigOverrideAllowed        bool  `xml:"vendorConfigOverrideAllowed"`
	LivePortMovingAllowed              bool  `xml:"livePortMovingAllowed"`
	PortConfigResetAtDisconnect        bool  `xml:"portConfigResetAtDisconnect"`
	NetworkResourcePoolOverrideAllowed *bool `xml:"networkResourcePoolOverrideAllowed"`
	TrafficFilterOverrideAllowed       *bool `xml:"trafficFilterOverrideAllowed"`
}

func init() {
	t["DVPortgroupPolicy"] = reflect.TypeOf((*DVPortgroupPolicy)(nil)).Elem()
}

type DVPortgroupReconfiguredEvent struct {
	DVPortgroupEvent

	ConfigSpec DVPortgroupConfigSpec `xml:"configSpec"`
}

func init() {
	t["DVPortgroupReconfiguredEvent"] = reflect.TypeOf((*DVPortgroupReconfiguredEvent)(nil)).Elem()
}

type DVPortgroupRenamedEvent struct {
	DVPortgroupEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DVPortgroupRenamedEvent"] = reflect.TypeOf((*DVPortgroupRenamedEvent)(nil)).Elem()
}

type DVPortgroupRollbackRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	EntityBackup *EntityBackupConfig    `xml:"entityBackup,omitempty"`
}

func init() {
	t["DVPortgroupRollbackRequestType"] = reflect.TypeOf((*DVPortgroupRollbackRequestType)(nil)).Elem()
}

type DVPortgroupRollback_Task DVPortgroupRollbackRequestType

func init() {
	t["DVPortgroupRollback_Task"] = reflect.TypeOf((*DVPortgroupRollback_Task)(nil)).Elem()
}

type DVPortgroupRollback_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVPortgroupSelection struct {
	SelectionSet

	DvsUuid      string   `xml:"dvsUuid"`
	PortgroupKey []string `xml:"portgroupKey"`
}

func init() {
	t["DVPortgroupSelection"] = reflect.TypeOf((*DVPortgroupSelection)(nil)).Elem()
}

type DVSBackupRestoreCapability struct {
	DynamicData

	BackupRestoreSupported bool `xml:"backupRestoreSupported"`
}

func init() {
	t["DVSBackupRestoreCapability"] = reflect.TypeOf((*DVSBackupRestoreCapability)(nil)).Elem()
}

type DVSCapability struct {
	DynamicData

	DvsOperationSupported              *bool                                     `xml:"dvsOperationSupported"`
	DvPortGroupOperationSupported      *bool                                     `xml:"dvPortGroupOperationSupported"`
	DvPortOperationSupported           *bool                                     `xml:"dvPortOperationSupported"`
	CompatibleHostComponentProductInfo []DistributedVirtualSwitchHostProductSpec `xml:"compatibleHostComponentProductInfo,omitempty"`
	FeaturesSupported                  BaseDVSFeatureCapability                  `xml:"featuresSupported,omitempty,typeattr"`
}

func init() {
	t["DVSCapability"] = reflect.TypeOf((*DVSCapability)(nil)).Elem()
}

type DVSConfigInfo struct {
	DynamicData

	Uuid                             string                                    `xml:"uuid"`
	Name                             string                                    `xml:"name"`
	NumStandalonePorts               int                                       `xml:"numStandalonePorts"`
	NumPorts                         int                                       `xml:"numPorts"`
	MaxPorts                         int                                       `xml:"maxPorts"`
	UplinkPortPolicy                 BaseDVSUplinkPortPolicy                   `xml:"uplinkPortPolicy,typeattr"`
	UplinkPortgroup                  []ManagedObjectReference                  `xml:"uplinkPortgroup,omitempty"`
	DefaultPortConfig                BaseDVPortSetting                         `xml:"defaultPortConfig,typeattr"`
	Host                             []DistributedVirtualSwitchHostMember      `xml:"host,omitempty"`
	ProductInfo                      DistributedVirtualSwitchProductSpec       `xml:"productInfo"`
	TargetInfo                       *DistributedVirtualSwitchProductSpec      `xml:"targetInfo,omitempty"`
	ExtensionKey                     string                                    `xml:"extensionKey,omitempty"`
	VendorSpecificConfig             []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty"`
	Policy                           *DVSPolicy                                `xml:"policy,omitempty"`
	Description                      string                                    `xml:"description,omitempty"`
	ConfigVersion                    string                                    `xml:"configVersion"`
	Contact                          DVSContactInfo                            `xml:"contact"`
	SwitchIpAddress                  string                                    `xml:"switchIpAddress,omitempty"`
	CreateTime                       time.Time                                 `xml:"createTime"`
	NetworkResourceManagementEnabled *bool                                     `xml:"networkResourceManagementEnabled"`
	DefaultProxySwitchMaxNumPorts    int                                       `xml:"defaultProxySwitchMaxNumPorts,omitempty"`
	HealthCheckConfig                []BaseDVSHealthCheckConfig                `xml:"healthCheckConfig,omitempty,typeattr"`
}

func init() {
	t["DVSConfigInfo"] = reflect.TypeOf((*DVSConfigInfo)(nil)).Elem()
}

type DVSConfigSpec struct {
	DynamicData

	ConfigVersion                 string                                         `xml:"configVersion,omitempty"`
	Name                          string                                         `xml:"name,omitempty"`
	NumStandalonePorts            int                                            `xml:"numStandalonePorts,omitempty"`
	MaxPorts                      int                                            `xml:"maxPorts,omitempty"`
	UplinkPortPolicy              BaseDVSUplinkPortPolicy                        `xml:"uplinkPortPolicy,omitempty,typeattr"`
	UplinkPortgroup               []ManagedObjectReference                       `xml:"uplinkPortgroup,omitempty"`
	DefaultPortConfig             BaseDVPortSetting                              `xml:"defaultPortConfig,omitempty,typeattr"`
	Host                          []DistributedVirtualSwitchHostMemberConfigSpec `xml:"host,omitempty"`
	ExtensionKey                  string                                         `xml:"extensionKey,omitempty"`
	Description                   string                                         `xml:"description,omitempty"`
	Policy                        *DVSPolicy                                     `xml:"policy,omitempty"`
	VendorSpecificConfig          []DistributedVirtualSwitchKeyedOpaqueBlob      `xml:"vendorSpecificConfig,omitempty"`
	Contact                       *DVSContactInfo                                `xml:"contact,omitempty"`
	SwitchIpAddress               string                                         `xml:"switchIpAddress,omitempty"`
	DefaultProxySwitchMaxNumPorts int                                            `xml:"defaultProxySwitchMaxNumPorts,omitempty"`
}

func init() {
	t["DVSConfigSpec"] = reflect.TypeOf((*DVSConfigSpec)(nil)).Elem()
}

type DVSContactInfo struct {
	DynamicData

	Name    string `xml:"name,omitempty"`
	Contact string `xml:"contact,omitempty"`
}

func init() {
	t["DVSContactInfo"] = reflect.TypeOf((*DVSContactInfo)(nil)).Elem()
}

type DVSCreateSpec struct {
	DynamicData

	ConfigSpec  BaseDVSConfigSpec                    `xml:"configSpec,typeattr"`
	ProductInfo *DistributedVirtualSwitchProductSpec `xml:"productInfo,omitempty"`
	Capability  *DVSCapability                       `xml:"capability,omitempty"`
}

func init() {
	t["DVSCreateSpec"] = reflect.TypeOf((*DVSCreateSpec)(nil)).Elem()
}

type DVSFailureCriteria struct {
	InheritablePolicy

	CheckSpeed        *StringPolicy `xml:"checkSpeed,omitempty"`
	Speed             *IntPolicy    `xml:"speed,omitempty"`
	CheckDuplex       *BoolPolicy   `xml:"checkDuplex,omitempty"`
	FullDuplex        *BoolPolicy   `xml:"fullDuplex,omitempty"`
	CheckErrorPercent *BoolPolicy   `xml:"checkErrorPercent,omitempty"`
	Percentage        *IntPolicy    `xml:"percentage,omitempty"`
	CheckBeacon       *BoolPolicy   `xml:"checkBeacon,omitempty"`
}

func init() {
	t["DVSFailureCriteria"] = reflect.TypeOf((*DVSFailureCriteria)(nil)).Elem()
}

type DVSFeatureCapability struct {
	DynamicData

	NetworkResourceManagementSupported  bool                                    `xml:"networkResourceManagementSupported"`
	VmDirectPathGen2Supported           bool                                    `xml:"vmDirectPathGen2Supported"`
	NicTeamingPolicy                    []string                                `xml:"nicTeamingPolicy,omitempty"`
	NetworkResourcePoolHighShareValue   int                                     `xml:"networkResourcePoolHighShareValue,omitempty"`
	NetworkResourceManagementCapability *DVSNetworkResourceManagementCapability `xml:"networkResourceManagementCapability,omitempty"`
	HealthCheckCapability               BaseDVSHealthCheckCapability            `xml:"healthCheckCapability,omitempty,typeattr"`
	RollbackCapability                  *DVSRollbackCapability                  `xml:"rollbackCapability,omitempty"`
	BackupRestoreCapability             *DVSBackupRestoreCapability             `xml:"backupRestoreCapability,omitempty"`
	NetworkFilterSupported              *bool                                   `xml:"networkFilterSupported"`
}

func init() {
	t["DVSFeatureCapability"] = reflect.TypeOf((*DVSFeatureCapability)(nil)).Elem()
}

type DVSHealthCheckCapability struct {
	DynamicData
}

func init() {
	t["DVSHealthCheckCapability"] = reflect.TypeOf((*DVSHealthCheckCapability)(nil)).Elem()
}

type DVSHealthCheckConfig struct {
	DynamicData

	Enable   *bool `xml:"enable"`
	Interval int   `xml:"interval,omitempty"`
}

func init() {
	t["DVSHealthCheckConfig"] = reflect.TypeOf((*DVSHealthCheckConfig)(nil)).Elem()
}

type DVSHostLocalPortInfo struct {
	DynamicData

	SwitchUuid string            `xml:"switchUuid"`
	PortKey    string            `xml:"portKey"`
	Setting    BaseDVPortSetting `xml:"setting,typeattr"`
	Vnic       string            `xml:"vnic"`
}

func init() {
	t["DVSHostLocalPortInfo"] = reflect.TypeOf((*DVSHostLocalPortInfo)(nil)).Elem()
}

type DVSManagerDvsConfigTarget struct {
	DynamicData

	DistributedVirtualPortgroup []DistributedVirtualPortgroupInfo `xml:"distributedVirtualPortgroup,omitempty"`
	DistributedVirtualSwitch    []DistributedVirtualSwitchInfo    `xml:"distributedVirtualSwitch,omitempty"`
}

func init() {
	t["DVSManagerDvsConfigTarget"] = reflect.TypeOf((*DVSManagerDvsConfigTarget)(nil)).Elem()
}

type DVSManagerExportEntityRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	SelectionSet []BaseSelectionSet     `xml:"selectionSet,typeattr"`
}

func init() {
	t["DVSManagerExportEntityRequestType"] = reflect.TypeOf((*DVSManagerExportEntityRequestType)(nil)).Elem()
}

type DVSManagerExportEntity_Task DVSManagerExportEntityRequestType

func init() {
	t["DVSManagerExportEntity_Task"] = reflect.TypeOf((*DVSManagerExportEntity_Task)(nil)).Elem()
}

type DVSManagerExportEntity_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVSManagerImportEntityRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	EntityBackup []EntityBackupConfig   `xml:"entityBackup"`
	ImportType   string                 `xml:"importType"`
}

func init() {
	t["DVSManagerImportEntityRequestType"] = reflect.TypeOf((*DVSManagerImportEntityRequestType)(nil)).Elem()
}

type DVSManagerImportEntity_Task DVSManagerImportEntityRequestType

func init() {
	t["DVSManagerImportEntity_Task"] = reflect.TypeOf((*DVSManagerImportEntity_Task)(nil)).Elem()
}

type DVSManagerImportEntity_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVSManagerLookupDvPortGroup DVSManagerLookupDvPortGroupRequestType

func init() {
	t["DVSManagerLookupDvPortGroup"] = reflect.TypeOf((*DVSManagerLookupDvPortGroup)(nil)).Elem()
}

type DVSManagerLookupDvPortGroupRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	SwitchUuid   string                 `xml:"switchUuid"`
	PortgroupKey string                 `xml:"portgroupKey"`
}

func init() {
	t["DVSManagerLookupDvPortGroupRequestType"] = reflect.TypeOf((*DVSManagerLookupDvPortGroupRequestType)(nil)).Elem()
}

type DVSManagerLookupDvPortGroupResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type DVSNameArrayUplinkPortPolicy struct {
	DVSUplinkPortPolicy

	UplinkPortName []string `xml:"uplinkPortName"`
}

func init() {
	t["DVSNameArrayUplinkPortPolicy"] = reflect.TypeOf((*DVSNameArrayUplinkPortPolicy)(nil)).Elem()
}

type DVSNetworkResourceManagementCapability struct {
	DynamicData

	NetworkResourceManagementSupported       bool `xml:"networkResourceManagementSupported"`
	NetworkResourcePoolHighShareValue        int  `xml:"networkResourcePoolHighShareValue"`
	QosSupported                             bool `xml:"qosSupported"`
	UserDefinedNetworkResourcePoolsSupported bool `xml:"userDefinedNetworkResourcePoolsSupported"`
}

func init() {
	t["DVSNetworkResourceManagementCapability"] = reflect.TypeOf((*DVSNetworkResourceManagementCapability)(nil)).Elem()
}

type DVSNetworkResourcePool struct {
	DynamicData

	Key            string                               `xml:"key"`
	Name           string                               `xml:"name,omitempty"`
	Description    string                               `xml:"description,omitempty"`
	ConfigVersion  string                               `xml:"configVersion"`
	AllocationInfo DVSNetworkResourcePoolAllocationInfo `xml:"allocationInfo"`
}

func init() {
	t["DVSNetworkResourcePool"] = reflect.TypeOf((*DVSNetworkResourcePool)(nil)).Elem()
}

type DVSNetworkResourcePoolAllocationInfo struct {
	DynamicData

	Limit       int64       `xml:"limit,omitempty"`
	Shares      *SharesInfo `xml:"shares,omitempty"`
	PriorityTag int         `xml:"priorityTag,omitempty"`
}

func init() {
	t["DVSNetworkResourcePoolAllocationInfo"] = reflect.TypeOf((*DVSNetworkResourcePoolAllocationInfo)(nil)).Elem()
}

type DVSNetworkResourcePoolConfigSpec struct {
	DynamicData

	Key            string                                `xml:"key"`
	ConfigVersion  string                                `xml:"configVersion,omitempty"`
	AllocationInfo *DVSNetworkResourcePoolAllocationInfo `xml:"allocationInfo,omitempty"`
	Name           string                                `xml:"name,omitempty"`
	Description    string                                `xml:"description,omitempty"`
}

func init() {
	t["DVSNetworkResourcePoolConfigSpec"] = reflect.TypeOf((*DVSNetworkResourcePoolConfigSpec)(nil)).Elem()
}

type DVSPolicy struct {
	DynamicData

	AutoPreInstallAllowed *bool `xml:"autoPreInstallAllowed"`
	AutoUpgradeAllowed    *bool `xml:"autoUpgradeAllowed"`
	PartialUpgradeAllowed *bool `xml:"partialUpgradeAllowed"`
}

func init() {
	t["DVSPolicy"] = reflect.TypeOf((*DVSPolicy)(nil)).Elem()
}

type DVSRollbackCapability struct {
	DynamicData

	RollbackSupported bool `xml:"rollbackSupported"`
}

func init() {
	t["DVSRollbackCapability"] = reflect.TypeOf((*DVSRollbackCapability)(nil)).Elem()
}

type DVSRollbackRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	EntityBackup *EntityBackupConfig    `xml:"entityBackup,omitempty"`
}

func init() {
	t["DVSRollbackRequestType"] = reflect.TypeOf((*DVSRollbackRequestType)(nil)).Elem()
}

type DVSRollback_Task DVSRollbackRequestType

func init() {
	t["DVSRollback_Task"] = reflect.TypeOf((*DVSRollback_Task)(nil)).Elem()
}

type DVSRollback_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVSRuntimeInfo struct {
	DynamicData

	HostMemberRuntime []HostMemberRuntimeInfo `xml:"hostMemberRuntime,omitempty"`
}

func init() {
	t["DVSRuntimeInfo"] = reflect.TypeOf((*DVSRuntimeInfo)(nil)).Elem()
}

type DVSSecurityPolicy struct {
	InheritablePolicy

	AllowPromiscuous *BoolPolicy `xml:"allowPromiscuous,omitempty"`
	MacChanges       *BoolPolicy `xml:"macChanges,omitempty"`
	ForgedTransmits  *BoolPolicy `xml:"forgedTransmits,omitempty"`
}

func init() {
	t["DVSSecurityPolicy"] = reflect.TypeOf((*DVSSecurityPolicy)(nil)).Elem()
}

type DVSSelection struct {
	SelectionSet

	DvsUuid string `xml:"dvsUuid"`
}

func init() {
	t["DVSSelection"] = reflect.TypeOf((*DVSSelection)(nil)).Elem()
}

type DVSSummary struct {
	DynamicData

	Name          string                               `xml:"name"`
	Uuid          string                               `xml:"uuid"`
	NumPorts      int                                  `xml:"numPorts"`
	ProductInfo   *DistributedVirtualSwitchProductSpec `xml:"productInfo,omitempty"`
	HostMember    []ManagedObjectReference             `xml:"hostMember,omitempty"`
	Vm            []ManagedObjectReference             `xml:"vm,omitempty"`
	Host          []ManagedObjectReference             `xml:"host,omitempty"`
	PortgroupName []string                             `xml:"portgroupName,omitempty"`
	Description   string                               `xml:"description,omitempty"`
	Contact       *DVSContactInfo                      `xml:"contact,omitempty"`
	NumHosts      int                                  `xml:"numHosts,omitempty"`
}

func init() {
	t["DVSSummary"] = reflect.TypeOf((*DVSSummary)(nil)).Elem()
}

type DVSTrafficShapingPolicy struct {
	InheritablePolicy

	Enabled          *BoolPolicy `xml:"enabled,omitempty"`
	AverageBandwidth *LongPolicy `xml:"averageBandwidth,omitempty"`
	PeakBandwidth    *LongPolicy `xml:"peakBandwidth,omitempty"`
	BurstSize        *LongPolicy `xml:"burstSize,omitempty"`
}

func init() {
	t["DVSTrafficShapingPolicy"] = reflect.TypeOf((*DVSTrafficShapingPolicy)(nil)).Elem()
}

type DVSUplinkPortPolicy struct {
	DynamicData
}

func init() {
	t["DVSUplinkPortPolicy"] = reflect.TypeOf((*DVSUplinkPortPolicy)(nil)).Elem()
}

type DVSVendorSpecificConfig struct {
	InheritablePolicy

	KeyValue []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"keyValue,omitempty"`
}

func init() {
	t["DVSVendorSpecificConfig"] = reflect.TypeOf((*DVSVendorSpecificConfig)(nil)).Elem()
}

type DailyTaskScheduler struct {
	HourlyTaskScheduler

	Hour int `xml:"hour"`
}

func init() {
	t["DailyTaskScheduler"] = reflect.TypeOf((*DailyTaskScheduler)(nil)).Elem()
}

type DasAdmissionControlDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasAdmissionControlDisabledEvent"] = reflect.TypeOf((*DasAdmissionControlDisabledEvent)(nil)).Elem()
}

type DasAdmissionControlEnabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasAdmissionControlEnabledEvent"] = reflect.TypeOf((*DasAdmissionControlEnabledEvent)(nil)).Elem()
}

type DasAgentFoundEvent struct {
	ClusterEvent
}

func init() {
	t["DasAgentFoundEvent"] = reflect.TypeOf((*DasAgentFoundEvent)(nil)).Elem()
}

type DasAgentUnavailableEvent struct {
	ClusterEvent
}

func init() {
	t["DasAgentUnavailableEvent"] = reflect.TypeOf((*DasAgentUnavailableEvent)(nil)).Elem()
}

type DasClusterIsolatedEvent struct {
	ClusterEvent
}

func init() {
	t["DasClusterIsolatedEvent"] = reflect.TypeOf((*DasClusterIsolatedEvent)(nil)).Elem()
}

type DasConfigFault struct {
	VimFault

	Reason string      `xml:"reason,omitempty"`
	Output string      `xml:"output,omitempty"`
	Event  []BaseEvent `xml:"event,omitempty,typeattr"`
}

func init() {
	t["DasConfigFault"] = reflect.TypeOf((*DasConfigFault)(nil)).Elem()
}

type DasConfigFaultFault DasConfigFault

func init() {
	t["DasConfigFaultFault"] = reflect.TypeOf((*DasConfigFaultFault)(nil)).Elem()
}

type DasDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasDisabledEvent"] = reflect.TypeOf((*DasDisabledEvent)(nil)).Elem()
}

type DasEnabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasEnabledEvent"] = reflect.TypeOf((*DasEnabledEvent)(nil)).Elem()
}

type DasHeartbeatDatastoreInfo struct {
	DynamicData

	Datastore ManagedObjectReference   `xml:"datastore"`
	Hosts     []ManagedObjectReference `xml:"hosts"`
}

func init() {
	t["DasHeartbeatDatastoreInfo"] = reflect.TypeOf((*DasHeartbeatDatastoreInfo)(nil)).Elem()
}

type DasHostFailedEvent struct {
	ClusterEvent

	FailedHost HostEventArgument `xml:"failedHost"`
}

func init() {
	t["DasHostFailedEvent"] = reflect.TypeOf((*DasHostFailedEvent)(nil)).Elem()
}

type DasHostIsolatedEvent struct {
	ClusterEvent

	IsolatedHost HostEventArgument `xml:"isolatedHost"`
}

func init() {
	t["DasHostIsolatedEvent"] = reflect.TypeOf((*DasHostIsolatedEvent)(nil)).Elem()
}

type DatabaseError struct {
	RuntimeFault
}

func init() {
	t["DatabaseError"] = reflect.TypeOf((*DatabaseError)(nil)).Elem()
}

type DatabaseErrorFault DatabaseError

func init() {
	t["DatabaseErrorFault"] = reflect.TypeOf((*DatabaseErrorFault)(nil)).Elem()
}

type DatabaseSizeEstimate struct {
	DynamicData

	Size int64 `xml:"size"`
}

func init() {
	t["DatabaseSizeEstimate"] = reflect.TypeOf((*DatabaseSizeEstimate)(nil)).Elem()
}

type DatabaseSizeParam struct {
	DynamicData

	InventoryDesc InventoryDescription              `xml:"inventoryDesc"`
	PerfStatsDesc *PerformanceStatisticsDescription `xml:"perfStatsDesc,omitempty"`
}

func init() {
	t["DatabaseSizeParam"] = reflect.TypeOf((*DatabaseSizeParam)(nil)).Elem()
}

type DatacenterConfigInfo struct {
	DynamicData

	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty"`
}

func init() {
	t["DatacenterConfigInfo"] = reflect.TypeOf((*DatacenterConfigInfo)(nil)).Elem()
}

type DatacenterConfigSpec struct {
	DynamicData

	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty"`
}

func init() {
	t["DatacenterConfigSpec"] = reflect.TypeOf((*DatacenterConfigSpec)(nil)).Elem()
}

type DatacenterCreatedEvent struct {
	DatacenterEvent

	Parent FolderEventArgument `xml:"parent"`
}

func init() {
	t["DatacenterCreatedEvent"] = reflect.TypeOf((*DatacenterCreatedEvent)(nil)).Elem()
}

type DatacenterEvent struct {
	Event
}

func init() {
	t["DatacenterEvent"] = reflect.TypeOf((*DatacenterEvent)(nil)).Elem()
}

type DatacenterEventArgument struct {
	EntityEventArgument

	Datacenter ManagedObjectReference `xml:"datacenter"`
}

func init() {
	t["DatacenterEventArgument"] = reflect.TypeOf((*DatacenterEventArgument)(nil)).Elem()
}

type DatacenterMismatch struct {
	MigrationFault

	InvalidArgument    []DatacenterMismatchArgument `xml:"invalidArgument"`
	ExpectedDatacenter ManagedObjectReference       `xml:"expectedDatacenter"`
}

func init() {
	t["DatacenterMismatch"] = reflect.TypeOf((*DatacenterMismatch)(nil)).Elem()
}

type DatacenterMismatchArgument struct {
	DynamicData

	Entity          ManagedObjectReference  `xml:"entity"`
	InputDatacenter *ManagedObjectReference `xml:"inputDatacenter,omitempty"`
}

func init() {
	t["DatacenterMismatchArgument"] = reflect.TypeOf((*DatacenterMismatchArgument)(nil)).Elem()
}

type DatacenterMismatchFault DatacenterMismatch

func init() {
	t["DatacenterMismatchFault"] = reflect.TypeOf((*DatacenterMismatchFault)(nil)).Elem()
}

type DatacenterRenamedEvent struct {
	DatacenterEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DatacenterRenamedEvent"] = reflect.TypeOf((*DatacenterRenamedEvent)(nil)).Elem()
}

type DatastoreCapability struct {
	DynamicData

	DirectoryHierarchySupported      bool  `xml:"directoryHierarchySupported"`
	RawDiskMappingsSupported         bool  `xml:"rawDiskMappingsSupported"`
	PerFileThinProvisioningSupported bool  `xml:"perFileThinProvisioningSupported"`
	StorageIORMSupported             *bool `xml:"storageIORMSupported"`
	NativeSnapshotSupported          *bool `xml:"nativeSnapshotSupported"`
	TopLevelDirectoryCreateSupported *bool `xml:"topLevelDirectoryCreateSupported"`
	SeSparseSupported                *bool `xml:"seSparseSupported"`
}

func init() {
	t["DatastoreCapability"] = reflect.TypeOf((*DatastoreCapability)(nil)).Elem()
}

type DatastoreCapacityIncreasedEvent struct {
	DatastoreEvent

	OldCapacity int64 `xml:"oldCapacity"`
	NewCapacity int64 `xml:"newCapacity"`
}

func init() {
	t["DatastoreCapacityIncreasedEvent"] = reflect.TypeOf((*DatastoreCapacityIncreasedEvent)(nil)).Elem()
}

type DatastoreDestroyedEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreDestroyedEvent"] = reflect.TypeOf((*DatastoreDestroyedEvent)(nil)).Elem()
}

type DatastoreDiscoveredEvent struct {
	HostEvent

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["DatastoreDiscoveredEvent"] = reflect.TypeOf((*DatastoreDiscoveredEvent)(nil)).Elem()
}

type DatastoreDuplicatedEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreDuplicatedEvent"] = reflect.TypeOf((*DatastoreDuplicatedEvent)(nil)).Elem()
}

type DatastoreEnterMaintenanceMode DatastoreEnterMaintenanceModeRequestType

func init() {
	t["DatastoreEnterMaintenanceMode"] = reflect.TypeOf((*DatastoreEnterMaintenanceMode)(nil)).Elem()
}

type DatastoreEnterMaintenanceModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DatastoreEnterMaintenanceModeRequestType"] = reflect.TypeOf((*DatastoreEnterMaintenanceModeRequestType)(nil)).Elem()
}

type DatastoreEnterMaintenanceModeResponse struct {
	Returnval StoragePlacementResult `xml:"returnval"`
}

type DatastoreEvent struct {
	Event

	Datastore *DatastoreEventArgument `xml:"datastore,omitempty"`
}

func init() {
	t["DatastoreEvent"] = reflect.TypeOf((*DatastoreEvent)(nil)).Elem()
}

type DatastoreEventArgument struct {
	EntityEventArgument

	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["DatastoreEventArgument"] = reflect.TypeOf((*DatastoreEventArgument)(nil)).Elem()
}

type DatastoreExitMaintenanceModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DatastoreExitMaintenanceModeRequestType"] = reflect.TypeOf((*DatastoreExitMaintenanceModeRequestType)(nil)).Elem()
}

type DatastoreExitMaintenanceMode_Task DatastoreExitMaintenanceModeRequestType

func init() {
	t["DatastoreExitMaintenanceMode_Task"] = reflect.TypeOf((*DatastoreExitMaintenanceMode_Task)(nil)).Elem()
}

type DatastoreExitMaintenanceMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DatastoreFileCopiedEvent struct {
	DatastoreFileEvent

	SourceDatastore DatastoreEventArgument `xml:"sourceDatastore"`
	SourceFile      string                 `xml:"sourceFile"`
}

func init() {
	t["DatastoreFileCopiedEvent"] = reflect.TypeOf((*DatastoreFileCopiedEvent)(nil)).Elem()
}

type DatastoreFileDeletedEvent struct {
	DatastoreFileEvent
}

func init() {
	t["DatastoreFileDeletedEvent"] = reflect.TypeOf((*DatastoreFileDeletedEvent)(nil)).Elem()
}

type DatastoreFileEvent struct {
	DatastoreEvent

	TargetFile string `xml:"targetFile"`
}

func init() {
	t["DatastoreFileEvent"] = reflect.TypeOf((*DatastoreFileEvent)(nil)).Elem()
}

type DatastoreFileMovedEvent struct {
	DatastoreFileEvent

	SourceDatastore DatastoreEventArgument `xml:"sourceDatastore"`
	SourceFile      string                 `xml:"sourceFile"`
}

func init() {
	t["DatastoreFileMovedEvent"] = reflect.TypeOf((*DatastoreFileMovedEvent)(nil)).Elem()
}

type DatastoreHostMount struct {
	DynamicData

	Key       ManagedObjectReference `xml:"key"`
	MountInfo HostMountInfo          `xml:"mountInfo"`
}

func init() {
	t["DatastoreHostMount"] = reflect.TypeOf((*DatastoreHostMount)(nil)).Elem()
}

type DatastoreIORMReconfiguredEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreIORMReconfiguredEvent"] = reflect.TypeOf((*DatastoreIORMReconfiguredEvent)(nil)).Elem()
}

type DatastoreInfo struct {
	DynamicData

	Name                   string     `xml:"name"`
	Url                    string     `xml:"url"`
	FreeSpace              int64      `xml:"freeSpace"`
	MaxFileSize            int64      `xml:"maxFileSize"`
	MaxVirtualDiskCapacity int64      `xml:"maxVirtualDiskCapacity,omitempty"`
	Timestamp              *time.Time `xml:"timestamp"`
	ContainerId            string     `xml:"containerId,omitempty"`
}

func init() {
	t["DatastoreInfo"] = reflect.TypeOf((*DatastoreInfo)(nil)).Elem()
}

type DatastoreMountPathDatastorePair struct {
	DynamicData

	OldMountPath string                 `xml:"oldMountPath"`
	Datastore    ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["DatastoreMountPathDatastorePair"] = reflect.TypeOf((*DatastoreMountPathDatastorePair)(nil)).Elem()
}

type DatastoreNotWritableOnHost struct {
	InvalidDatastore

	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["DatastoreNotWritableOnHost"] = reflect.TypeOf((*DatastoreNotWritableOnHost)(nil)).Elem()
}

type DatastoreNotWritableOnHostFault BaseDatastoreNotWritableOnHost

func init() {
	t["DatastoreNotWritableOnHostFault"] = reflect.TypeOf((*DatastoreNotWritableOnHostFault)(nil)).Elem()
}

type DatastoreOption struct {
	DynamicData

	UnsupportedVolumes []VirtualMachineDatastoreVolumeOption `xml:"unsupportedVolumes,omitempty"`
}

func init() {
	t["DatastoreOption"] = reflect.TypeOf((*DatastoreOption)(nil)).Elem()
}

type DatastorePrincipalConfigured struct {
	HostEvent

	DatastorePrincipal string `xml:"datastorePrincipal"`
}

func init() {
	t["DatastorePrincipalConfigured"] = reflect.TypeOf((*DatastorePrincipalConfigured)(nil)).Elem()
}

type DatastoreRemovedOnHostEvent struct {
	HostEvent

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["DatastoreRemovedOnHostEvent"] = reflect.TypeOf((*DatastoreRemovedOnHostEvent)(nil)).Elem()
}

type DatastoreRenamedEvent struct {
	DatastoreEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DatastoreRenamedEvent"] = reflect.TypeOf((*DatastoreRenamedEvent)(nil)).Elem()
}

type DatastoreRenamedOnHostEvent struct {
	HostEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DatastoreRenamedOnHostEvent"] = reflect.TypeOf((*DatastoreRenamedOnHostEvent)(nil)).Elem()
}

type DatastoreSummary struct {
	DynamicData

	Datastore          *ManagedObjectReference `xml:"datastore,omitempty"`
	Name               string                  `xml:"name"`
	Url                string                  `xml:"url"`
	Capacity           int64                   `xml:"capacity"`
	FreeSpace          int64                   `xml:"freeSpace"`
	Uncommitted        int64                   `xml:"uncommitted,omitempty"`
	Accessible         bool                    `xml:"accessible"`
	MultipleHostAccess *bool                   `xml:"multipleHostAccess"`
	Type               string                  `xml:"type"`
	MaintenanceMode    string                  `xml:"maintenanceMode,omitempty"`
}

func init() {
	t["DatastoreSummary"] = reflect.TypeOf((*DatastoreSummary)(nil)).Elem()
}

type DateTimeProfile struct {
	ApplyProfile
}

func init() {
	t["DateTimeProfile"] = reflect.TypeOf((*DateTimeProfile)(nil)).Elem()
}

type DecodeLicense DecodeLicenseRequestType

func init() {
	t["DecodeLicense"] = reflect.TypeOf((*DecodeLicense)(nil)).Elem()
}

type DecodeLicenseRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	LicenseKey string                 `xml:"licenseKey"`
}

func init() {
	t["DecodeLicenseRequestType"] = reflect.TypeOf((*DecodeLicenseRequestType)(nil)).Elem()
}

type DecodeLicenseResponse struct {
	Returnval LicenseManagerLicenseInfo `xml:"returnval"`
}

type DefragmentAllDisks DefragmentAllDisksRequestType

func init() {
	t["DefragmentAllDisks"] = reflect.TypeOf((*DefragmentAllDisks)(nil)).Elem()
}

type DefragmentAllDisksRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DefragmentAllDisksRequestType"] = reflect.TypeOf((*DefragmentAllDisksRequestType)(nil)).Elem()
}

type DefragmentAllDisksResponse struct {
}

type DefragmentVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["DefragmentVirtualDiskRequestType"] = reflect.TypeOf((*DefragmentVirtualDiskRequestType)(nil)).Elem()
}

type DefragmentVirtualDisk_Task DefragmentVirtualDiskRequestType

func init() {
	t["DefragmentVirtualDisk_Task"] = reflect.TypeOf((*DefragmentVirtualDisk_Task)(nil)).Elem()
}

type DefragmentVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteCustomizationSpec DeleteCustomizationSpecRequestType

func init() {
	t["DeleteCustomizationSpec"] = reflect.TypeOf((*DeleteCustomizationSpec)(nil)).Elem()
}

type DeleteCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["DeleteCustomizationSpecRequestType"] = reflect.TypeOf((*DeleteCustomizationSpecRequestType)(nil)).Elem()
}

type DeleteCustomizationSpecResponse struct {
}

type DeleteDatastoreFileRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["DeleteDatastoreFileRequestType"] = reflect.TypeOf((*DeleteDatastoreFileRequestType)(nil)).Elem()
}

type DeleteDatastoreFile_Task DeleteDatastoreFileRequestType

func init() {
	t["DeleteDatastoreFile_Task"] = reflect.TypeOf((*DeleteDatastoreFile_Task)(nil)).Elem()
}

type DeleteDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteDirectory DeleteDirectoryRequestType

func init() {
	t["DeleteDirectory"] = reflect.TypeOf((*DeleteDirectory)(nil)).Elem()
}

type DeleteDirectoryInGuest DeleteDirectoryInGuestRequestType

func init() {
	t["DeleteDirectoryInGuest"] = reflect.TypeOf((*DeleteDirectoryInGuest)(nil)).Elem()
}

type DeleteDirectoryInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	DirectoryPath string                  `xml:"directoryPath"`
	Recursive     bool                    `xml:"recursive"`
}

func init() {
	t["DeleteDirectoryInGuestRequestType"] = reflect.TypeOf((*DeleteDirectoryInGuestRequestType)(nil)).Elem()
}

type DeleteDirectoryInGuestResponse struct {
}

type DeleteDirectoryRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Datacenter    *ManagedObjectReference `xml:"datacenter,omitempty"`
	DatastorePath string                  `xml:"datastorePath"`
}

func init() {
	t["DeleteDirectoryRequestType"] = reflect.TypeOf((*DeleteDirectoryRequestType)(nil)).Elem()
}

type DeleteDirectoryResponse struct {
}

type DeleteFile DeleteFileRequestType

func init() {
	t["DeleteFile"] = reflect.TypeOf((*DeleteFile)(nil)).Elem()
}

type DeleteFileInGuest DeleteFileInGuestRequestType

func init() {
	t["DeleteFileInGuest"] = reflect.TypeOf((*DeleteFileInGuest)(nil)).Elem()
}

type DeleteFileInGuestRequestType struct {
	This     ManagedObjectReference  `xml:"_this"`
	Vm       ManagedObjectReference  `xml:"vm"`
	Auth     BaseGuestAuthentication `xml:"auth,typeattr"`
	FilePath string                  `xml:"filePath"`
}

func init() {
	t["DeleteFileInGuestRequestType"] = reflect.TypeOf((*DeleteFileInGuestRequestType)(nil)).Elem()
}

type DeleteFileInGuestResponse struct {
}

type DeleteFileRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	DatastorePath string                 `xml:"datastorePath"`
}

func init() {
	t["DeleteFileRequestType"] = reflect.TypeOf((*DeleteFileRequestType)(nil)).Elem()
}

type DeleteFileResponse struct {
}

type DeleteScsiLunState DeleteScsiLunStateRequestType

func init() {
	t["DeleteScsiLunState"] = reflect.TypeOf((*DeleteScsiLunState)(nil)).Elem()
}

type DeleteScsiLunStateRequestType struct {
	This             ManagedObjectReference `xml:"_this"`
	LunCanonicalName string                 `xml:"lunCanonicalName"`
}

func init() {
	t["DeleteScsiLunStateRequestType"] = reflect.TypeOf((*DeleteScsiLunStateRequestType)(nil)).Elem()
}

type DeleteScsiLunStateResponse struct {
}

type DeleteVffsVolumeState DeleteVffsVolumeStateRequestType

func init() {
	t["DeleteVffsVolumeState"] = reflect.TypeOf((*DeleteVffsVolumeState)(nil)).Elem()
}

type DeleteVffsVolumeStateRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VffsUuid string                 `xml:"vffsUuid"`
}

func init() {
	t["DeleteVffsVolumeStateRequestType"] = reflect.TypeOf((*DeleteVffsVolumeStateRequestType)(nil)).Elem()
}

type DeleteVffsVolumeStateResponse struct {
}

type DeleteVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["DeleteVirtualDiskRequestType"] = reflect.TypeOf((*DeleteVirtualDiskRequestType)(nil)).Elem()
}

type DeleteVirtualDisk_Task DeleteVirtualDiskRequestType

func init() {
	t["DeleteVirtualDisk_Task"] = reflect.TypeOf((*DeleteVirtualDisk_Task)(nil)).Elem()
}

type DeleteVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteVmfsVolumeState DeleteVmfsVolumeStateRequestType

func init() {
	t["DeleteVmfsVolumeState"] = reflect.TypeOf((*DeleteVmfsVolumeState)(nil)).Elem()
}

type DeleteVmfsVolumeStateRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsUuid string                 `xml:"vmfsUuid"`
}

func init() {
	t["DeleteVmfsVolumeStateRequestType"] = reflect.TypeOf((*DeleteVmfsVolumeStateRequestType)(nil)).Elem()
}

type DeleteVmfsVolumeStateResponse struct {
}

type DeltaDiskFormatNotSupported struct {
	VmConfigFault

	Datastore       []ManagedObjectReference `xml:"datastore,omitempty"`
	DeltaDiskFormat string                   `xml:"deltaDiskFormat"`
}

func init() {
	t["DeltaDiskFormatNotSupported"] = reflect.TypeOf((*DeltaDiskFormatNotSupported)(nil)).Elem()
}

type DeltaDiskFormatNotSupportedFault DeltaDiskFormatNotSupported

func init() {
	t["DeltaDiskFormatNotSupportedFault"] = reflect.TypeOf((*DeltaDiskFormatNotSupportedFault)(nil)).Elem()
}

type Description struct {
	DynamicData

	Label   string `xml:"label"`
	Summary string `xml:"summary"`
}

func init() {
	t["Description"] = reflect.TypeOf((*Description)(nil)).Elem()
}

type DeselectVnic DeselectVnicRequestType

func init() {
	t["DeselectVnic"] = reflect.TypeOf((*DeselectVnic)(nil)).Elem()
}

type DeselectVnicForNicType DeselectVnicForNicTypeRequestType

func init() {
	t["DeselectVnicForNicType"] = reflect.TypeOf((*DeselectVnicForNicType)(nil)).Elem()
}

type DeselectVnicForNicTypeRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	NicType string                 `xml:"nicType"`
	Device  string                 `xml:"device"`
}

func init() {
	t["DeselectVnicForNicTypeRequestType"] = reflect.TypeOf((*DeselectVnicForNicTypeRequestType)(nil)).Elem()
}

type DeselectVnicForNicTypeResponse struct {
}

type DeselectVnicRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DeselectVnicRequestType"] = reflect.TypeOf((*DeselectVnicRequestType)(nil)).Elem()
}

type DeselectVnicResponse struct {
}

type DestinationSwitchFull struct {
	CannotAccessNetwork
}

func init() {
	t["DestinationSwitchFull"] = reflect.TypeOf((*DestinationSwitchFull)(nil)).Elem()
}

type DestinationSwitchFullFault DestinationSwitchFull

func init() {
	t["DestinationSwitchFullFault"] = reflect.TypeOf((*DestinationSwitchFullFault)(nil)).Elem()
}

type DestinationVsanDisabled struct {
	CannotMoveVsanEnabledHost

	DestinationCluster string `xml:"destinationCluster"`
}

func init() {
	t["DestinationVsanDisabled"] = reflect.TypeOf((*DestinationVsanDisabled)(nil)).Elem()
}

type DestinationVsanDisabledFault DestinationVsanDisabled

func init() {
	t["DestinationVsanDisabledFault"] = reflect.TypeOf((*DestinationVsanDisabledFault)(nil)).Elem()
}

type DestroyChildren DestroyChildrenRequestType

func init() {
	t["DestroyChildren"] = reflect.TypeOf((*DestroyChildren)(nil)).Elem()
}

type DestroyChildrenRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyChildrenRequestType"] = reflect.TypeOf((*DestroyChildrenRequestType)(nil)).Elem()
}

type DestroyChildrenResponse struct {
}

type DestroyCollector DestroyCollectorRequestType

func init() {
	t["DestroyCollector"] = reflect.TypeOf((*DestroyCollector)(nil)).Elem()
}

type DestroyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyCollectorRequestType"] = reflect.TypeOf((*DestroyCollectorRequestType)(nil)).Elem()
}

type DestroyCollectorResponse struct {
}

type DestroyDatastore DestroyDatastoreRequestType

func init() {
	t["DestroyDatastore"] = reflect.TypeOf((*DestroyDatastore)(nil)).Elem()
}

type DestroyDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyDatastoreRequestType"] = reflect.TypeOf((*DestroyDatastoreRequestType)(nil)).Elem()
}

type DestroyDatastoreResponse struct {
}

type DestroyIpPool DestroyIpPoolRequestType

func init() {
	t["DestroyIpPool"] = reflect.TypeOf((*DestroyIpPool)(nil)).Elem()
}

type DestroyIpPoolRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Dc    ManagedObjectReference `xml:"dc"`
	Id    int                    `xml:"id"`
	Force bool                   `xml:"force"`
}

func init() {
	t["DestroyIpPoolRequestType"] = reflect.TypeOf((*DestroyIpPoolRequestType)(nil)).Elem()
}

type DestroyIpPoolResponse struct {
}

type DestroyNetwork DestroyNetworkRequestType

func init() {
	t["DestroyNetwork"] = reflect.TypeOf((*DestroyNetwork)(nil)).Elem()
}

type DestroyNetworkRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyNetworkRequestType"] = reflect.TypeOf((*DestroyNetworkRequestType)(nil)).Elem()
}

type DestroyNetworkResponse struct {
}

type DestroyProfile DestroyProfileRequestType

func init() {
	t["DestroyProfile"] = reflect.TypeOf((*DestroyProfile)(nil)).Elem()
}

type DestroyProfileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyProfileRequestType"] = reflect.TypeOf((*DestroyProfileRequestType)(nil)).Elem()
}

type DestroyProfileResponse struct {
}

type DestroyPropertyCollector DestroyPropertyCollectorRequestType

func init() {
	t["DestroyPropertyCollector"] = reflect.TypeOf((*DestroyPropertyCollector)(nil)).Elem()
}

type DestroyPropertyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyPropertyCollectorRequestType"] = reflect.TypeOf((*DestroyPropertyCollectorRequestType)(nil)).Elem()
}

type DestroyPropertyCollectorResponse struct {
}

type DestroyPropertyFilter DestroyPropertyFilterRequestType

func init() {
	t["DestroyPropertyFilter"] = reflect.TypeOf((*DestroyPropertyFilter)(nil)).Elem()
}

type DestroyPropertyFilterRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyPropertyFilterRequestType"] = reflect.TypeOf((*DestroyPropertyFilterRequestType)(nil)).Elem()
}

type DestroyPropertyFilterResponse struct {
}

type DestroyRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyRequestType"] = reflect.TypeOf((*DestroyRequestType)(nil)).Elem()
}

type DestroyVffs DestroyVffsRequestType

func init() {
	t["DestroyVffs"] = reflect.TypeOf((*DestroyVffs)(nil)).Elem()
}

type DestroyVffsRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VffsPath string                 `xml:"vffsPath"`
}

func init() {
	t["DestroyVffsRequestType"] = reflect.TypeOf((*DestroyVffsRequestType)(nil)).Elem()
}

type DestroyVffsResponse struct {
}

type DestroyView DestroyViewRequestType

func init() {
	t["DestroyView"] = reflect.TypeOf((*DestroyView)(nil)).Elem()
}

type DestroyViewRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyViewRequestType"] = reflect.TypeOf((*DestroyViewRequestType)(nil)).Elem()
}

type DestroyViewResponse struct {
}

type Destroy_Task DestroyRequestType

func init() {
	t["Destroy_Task"] = reflect.TypeOf((*Destroy_Task)(nil)).Elem()
}

type Destroy_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DetachScsiLun DetachScsiLunRequestType

func init() {
	t["DetachScsiLun"] = reflect.TypeOf((*DetachScsiLun)(nil)).Elem()
}

type DetachScsiLunRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid string                 `xml:"lunUuid"`
}

func init() {
	t["DetachScsiLunRequestType"] = reflect.TypeOf((*DetachScsiLunRequestType)(nil)).Elem()
}

type DetachScsiLunResponse struct {
}

type DeviceBackedVirtualDiskSpec struct {
	VirtualDiskSpec

	Device string `xml:"device"`
}

func init() {
	t["DeviceBackedVirtualDiskSpec"] = reflect.TypeOf((*DeviceBackedVirtualDiskSpec)(nil)).Elem()
}

type DeviceBackingNotSupported struct {
	DeviceNotSupported

	Backing string `xml:"backing"`
}

func init() {
	t["DeviceBackingNotSupported"] = reflect.TypeOf((*DeviceBackingNotSupported)(nil)).Elem()
}

type DeviceBackingNotSupportedFault BaseDeviceBackingNotSupported

func init() {
	t["DeviceBackingNotSupportedFault"] = reflect.TypeOf((*DeviceBackingNotSupportedFault)(nil)).Elem()
}

type DeviceControllerNotSupported struct {
	DeviceNotSupported

	Controller string `xml:"controller"`
}

func init() {
	t["DeviceControllerNotSupported"] = reflect.TypeOf((*DeviceControllerNotSupported)(nil)).Elem()
}

type DeviceControllerNotSupportedFault DeviceControllerNotSupported

func init() {
	t["DeviceControllerNotSupportedFault"] = reflect.TypeOf((*DeviceControllerNotSupportedFault)(nil)).Elem()
}

type DeviceHotPlugNotSupported struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceHotPlugNotSupported"] = reflect.TypeOf((*DeviceHotPlugNotSupported)(nil)).Elem()
}

type DeviceHotPlugNotSupportedFault DeviceHotPlugNotSupported

func init() {
	t["DeviceHotPlugNotSupportedFault"] = reflect.TypeOf((*DeviceHotPlugNotSupportedFault)(nil)).Elem()
}

type DeviceNotFound struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceNotFound"] = reflect.TypeOf((*DeviceNotFound)(nil)).Elem()
}

type DeviceNotFoundFault DeviceNotFound

func init() {
	t["DeviceNotFoundFault"] = reflect.TypeOf((*DeviceNotFoundFault)(nil)).Elem()
}

type DeviceNotSupported struct {
	VirtualHardwareCompatibilityIssue

	Device string `xml:"device"`
	Reason string `xml:"reason,omitempty"`
}

func init() {
	t["DeviceNotSupported"] = reflect.TypeOf((*DeviceNotSupported)(nil)).Elem()
}

type DeviceNotSupportedFault BaseDeviceNotSupported

func init() {
	t["DeviceNotSupportedFault"] = reflect.TypeOf((*DeviceNotSupportedFault)(nil)).Elem()
}

type DeviceUnsupportedForVmPlatform struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceUnsupportedForVmPlatform"] = reflect.TypeOf((*DeviceUnsupportedForVmPlatform)(nil)).Elem()
}

type DeviceUnsupportedForVmPlatformFault DeviceUnsupportedForVmPlatform

func init() {
	t["DeviceUnsupportedForVmPlatformFault"] = reflect.TypeOf((*DeviceUnsupportedForVmPlatformFault)(nil)).Elem()
}

type DeviceUnsupportedForVmVersion struct {
	InvalidDeviceSpec

	CurrentVersion  string `xml:"currentVersion"`
	ExpectedVersion string `xml:"expectedVersion"`
}

func init() {
	t["DeviceUnsupportedForVmVersion"] = reflect.TypeOf((*DeviceUnsupportedForVmVersion)(nil)).Elem()
}

type DeviceUnsupportedForVmVersionFault DeviceUnsupportedForVmVersion

func init() {
	t["DeviceUnsupportedForVmVersionFault"] = reflect.TypeOf((*DeviceUnsupportedForVmVersionFault)(nil)).Elem()
}

type DiagnosticManagerBundleInfo struct {
	DynamicData

	System *ManagedObjectReference `xml:"system,omitempty"`
	Url    string                  `xml:"url"`
}

func init() {
	t["DiagnosticManagerBundleInfo"] = reflect.TypeOf((*DiagnosticManagerBundleInfo)(nil)).Elem()
}

type DiagnosticManagerLogDescriptor struct {
	DynamicData

	Key      string          `xml:"key"`
	FileName string          `xml:"fileName"`
	Creator  string          `xml:"creator"`
	Format   string          `xml:"format"`
	MimeType string          `xml:"mimeType"`
	Info     BaseDescription `xml:"info,typeattr"`
}

func init() {
	t["DiagnosticManagerLogDescriptor"] = reflect.TypeOf((*DiagnosticManagerLogDescriptor)(nil)).Elem()
}

type DiagnosticManagerLogHeader struct {
	DynamicData

	LineStart int      `xml:"lineStart"`
	LineEnd   int      `xml:"lineEnd"`
	LineText  []string `xml:"lineText,omitempty"`
}

func init() {
	t["DiagnosticManagerLogHeader"] = reflect.TypeOf((*DiagnosticManagerLogHeader)(nil)).Elem()
}

type DirectoryNotEmpty struct {
	FileFault
}

func init() {
	t["DirectoryNotEmpty"] = reflect.TypeOf((*DirectoryNotEmpty)(nil)).Elem()
}

type DirectoryNotEmptyFault DirectoryNotEmpty

func init() {
	t["DirectoryNotEmptyFault"] = reflect.TypeOf((*DirectoryNotEmptyFault)(nil)).Elem()
}

type DisableAdminNotSupported struct {
	HostConfigFault
}

func init() {
	t["DisableAdminNotSupported"] = reflect.TypeOf((*DisableAdminNotSupported)(nil)).Elem()
}

type DisableAdminNotSupportedFault DisableAdminNotSupported

func init() {
	t["DisableAdminNotSupportedFault"] = reflect.TypeOf((*DisableAdminNotSupportedFault)(nil)).Elem()
}

type DisableFeature DisableFeatureRequestType

func init() {
	t["DisableFeature"] = reflect.TypeOf((*DisableFeature)(nil)).Elem()
}

type DisableFeatureRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
	FeatureKey string                  `xml:"featureKey"`
}

func init() {
	t["DisableFeatureRequestType"] = reflect.TypeOf((*DisableFeatureRequestType)(nil)).Elem()
}

type DisableFeatureResponse struct {
	Returnval bool `xml:"returnval"`
}

type DisableHyperThreading DisableHyperThreadingRequestType

func init() {
	t["DisableHyperThreading"] = reflect.TypeOf((*DisableHyperThreading)(nil)).Elem()
}

type DisableHyperThreadingRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DisableHyperThreadingRequestType"] = reflect.TypeOf((*DisableHyperThreadingRequestType)(nil)).Elem()
}

type DisableHyperThreadingResponse struct {
}

type DisableMultipathPath DisableMultipathPathRequestType

func init() {
	t["DisableMultipathPath"] = reflect.TypeOf((*DisableMultipathPath)(nil)).Elem()
}

type DisableMultipathPathRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	PathName string                 `xml:"pathName"`
}

func init() {
	t["DisableMultipathPathRequestType"] = reflect.TypeOf((*DisableMultipathPathRequestType)(nil)).Elem()
}

type DisableMultipathPathResponse struct {
}

type DisableRuleset DisableRulesetRequestType

func init() {
	t["DisableRuleset"] = reflect.TypeOf((*DisableRuleset)(nil)).Elem()
}

type DisableRulesetRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["DisableRulesetRequestType"] = reflect.TypeOf((*DisableRulesetRequestType)(nil)).Elem()
}

type DisableRulesetResponse struct {
}

type DisableSecondaryVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Vm   ManagedObjectReference `xml:"vm"`
}

func init() {
	t["DisableSecondaryVMRequestType"] = reflect.TypeOf((*DisableSecondaryVMRequestType)(nil)).Elem()
}

type DisableSecondaryVM_Task DisableSecondaryVMRequestType

func init() {
	t["DisableSecondaryVM_Task"] = reflect.TypeOf((*DisableSecondaryVM_Task)(nil)).Elem()
}

type DisableSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DisallowedChangeByService struct {
	RuntimeFault

	ServiceName      string `xml:"serviceName"`
	DisallowedChange string `xml:"disallowedChange,omitempty"`
}

func init() {
	t["DisallowedChangeByService"] = reflect.TypeOf((*DisallowedChangeByService)(nil)).Elem()
}

type DisallowedChangeByServiceFault DisallowedChangeByService

func init() {
	t["DisallowedChangeByServiceFault"] = reflect.TypeOf((*DisallowedChangeByServiceFault)(nil)).Elem()
}

type DisallowedDiskModeChange struct {
	InvalidDeviceSpec
}

func init() {
	t["DisallowedDiskModeChange"] = reflect.TypeOf((*DisallowedDiskModeChange)(nil)).Elem()
}

type DisallowedDiskModeChangeFault DisallowedDiskModeChange

func init() {
	t["DisallowedDiskModeChangeFault"] = reflect.TypeOf((*DisallowedDiskModeChangeFault)(nil)).Elem()
}

type DisallowedMigrationDeviceAttached struct {
	MigrationFault

	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["DisallowedMigrationDeviceAttached"] = reflect.TypeOf((*DisallowedMigrationDeviceAttached)(nil)).Elem()
}

type DisallowedMigrationDeviceAttachedFault DisallowedMigrationDeviceAttached

func init() {
	t["DisallowedMigrationDeviceAttachedFault"] = reflect.TypeOf((*DisallowedMigrationDeviceAttachedFault)(nil)).Elem()
}

type DisallowedOperationOnFailoverHost struct {
	RuntimeFault

	Host     ManagedObjectReference `xml:"host"`
	Hostname string                 `xml:"hostname"`
}

func init() {
	t["DisallowedOperationOnFailoverHost"] = reflect.TypeOf((*DisallowedOperationOnFailoverHost)(nil)).Elem()
}

type DisallowedOperationOnFailoverHostFault DisallowedOperationOnFailoverHost

func init() {
	t["DisallowedOperationOnFailoverHostFault"] = reflect.TypeOf((*DisallowedOperationOnFailoverHostFault)(nil)).Elem()
}

type DisconnectHostRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DisconnectHostRequestType"] = reflect.TypeOf((*DisconnectHostRequestType)(nil)).Elem()
}

type DisconnectHost_Task DisconnectHostRequestType

func init() {
	t["DisconnectHost_Task"] = reflect.TypeOf((*DisconnectHost_Task)(nil)).Elem()
}

type DisconnectHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DiscoverFcoeHbas DiscoverFcoeHbasRequestType

func init() {
	t["DiscoverFcoeHbas"] = reflect.TypeOf((*DiscoverFcoeHbas)(nil)).Elem()
}

type DiscoverFcoeHbasRequestType struct {
	This     ManagedObjectReference      `xml:"_this"`
	FcoeSpec FcoeConfigFcoeSpecification `xml:"fcoeSpec"`
}

func init() {
	t["DiscoverFcoeHbasRequestType"] = reflect.TypeOf((*DiscoverFcoeHbasRequestType)(nil)).Elem()
}

type DiscoverFcoeHbasResponse struct {
}

type DiskChangeExtent struct {
	DynamicData

	Start  int64 `xml:"start"`
	Length int64 `xml:"length"`
}

func init() {
	t["DiskChangeExtent"] = reflect.TypeOf((*DiskChangeExtent)(nil)).Elem()
}

type DiskChangeInfo struct {
	DynamicData

	StartOffset int64              `xml:"startOffset"`
	Length      int64              `xml:"length"`
	ChangedArea []DiskChangeExtent `xml:"changedArea,omitempty"`
}

func init() {
	t["DiskChangeInfo"] = reflect.TypeOf((*DiskChangeInfo)(nil)).Elem()
}

type DiskHasPartitions struct {
	VsanDiskFault
}

func init() {
	t["DiskHasPartitions"] = reflect.TypeOf((*DiskHasPartitions)(nil)).Elem()
}

type DiskHasPartitionsFault DiskHasPartitions

func init() {
	t["DiskHasPartitionsFault"] = reflect.TypeOf((*DiskHasPartitionsFault)(nil)).Elem()
}

type DiskIsLastRemainingNonSSD struct {
	VsanDiskFault
}

func init() {
	t["DiskIsLastRemainingNonSSD"] = reflect.TypeOf((*DiskIsLastRemainingNonSSD)(nil)).Elem()
}

type DiskIsLastRemainingNonSSDFault DiskIsLastRemainingNonSSD

func init() {
	t["DiskIsLastRemainingNonSSDFault"] = reflect.TypeOf((*DiskIsLastRemainingNonSSDFault)(nil)).Elem()
}

type DiskIsNonLocal struct {
	VsanDiskFault
}

func init() {
	t["DiskIsNonLocal"] = reflect.TypeOf((*DiskIsNonLocal)(nil)).Elem()
}

type DiskIsNonLocalFault DiskIsNonLocal

func init() {
	t["DiskIsNonLocalFault"] = reflect.TypeOf((*DiskIsNonLocalFault)(nil)).Elem()
}

type DiskIsUSB struct {
	VsanDiskFault
}

func init() {
	t["DiskIsUSB"] = reflect.TypeOf((*DiskIsUSB)(nil)).Elem()
}

type DiskIsUSBFault DiskIsUSB

func init() {
	t["DiskIsUSBFault"] = reflect.TypeOf((*DiskIsUSBFault)(nil)).Elem()
}

type DiskMoveTypeNotSupported struct {
	MigrationFault
}

func init() {
	t["DiskMoveTypeNotSupported"] = reflect.TypeOf((*DiskMoveTypeNotSupported)(nil)).Elem()
}

type DiskMoveTypeNotSupportedFault DiskMoveTypeNotSupported

func init() {
	t["DiskMoveTypeNotSupportedFault"] = reflect.TypeOf((*DiskMoveTypeNotSupportedFault)(nil)).Elem()
}

type DiskNotSupported struct {
	VirtualHardwareCompatibilityIssue

	Disk int `xml:"disk"`
}

func init() {
	t["DiskNotSupported"] = reflect.TypeOf((*DiskNotSupported)(nil)).Elem()
}

type DiskNotSupportedFault BaseDiskNotSupported

func init() {
	t["DiskNotSupportedFault"] = reflect.TypeOf((*DiskNotSupportedFault)(nil)).Elem()
}

type DiskTooSmall struct {
	VsanDiskFault
}

func init() {
	t["DiskTooSmall"] = reflect.TypeOf((*DiskTooSmall)(nil)).Elem()
}

type DiskTooSmallFault DiskTooSmall

func init() {
	t["DiskTooSmallFault"] = reflect.TypeOf((*DiskTooSmallFault)(nil)).Elem()
}

type DissociateProfile DissociateProfileRequestType

func init() {
	t["DissociateProfile"] = reflect.TypeOf((*DissociateProfile)(nil)).Elem()
}

type DissociateProfileRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["DissociateProfileRequestType"] = reflect.TypeOf((*DissociateProfileRequestType)(nil)).Elem()
}

type DissociateProfileResponse struct {
}

type DistributedVirtualPort struct {
	DynamicData

	Key              string                                 `xml:"key"`
	Config           DVPortConfigInfo                       `xml:"config"`
	DvsUuid          string                                 `xml:"dvsUuid"`
	PortgroupKey     string                                 `xml:"portgroupKey,omitempty"`
	ProxyHost        *ManagedObjectReference                `xml:"proxyHost,omitempty"`
	Connectee        *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty"`
	Conflict         bool                                   `xml:"conflict"`
	ConflictPortKey  string                                 `xml:"conflictPortKey,omitempty"`
	State            *DVPortState                           `xml:"state,omitempty"`
	ConnectionCookie int                                    `xml:"connectionCookie,omitempty"`
	LastStatusChange time.Time                              `xml:"lastStatusChange"`
	HostLocalPort    *bool                                  `xml:"hostLocalPort"`
}

func init() {
	t["DistributedVirtualPort"] = reflect.TypeOf((*DistributedVirtualPort)(nil)).Elem()
}

type DistributedVirtualPortgroupInfo struct {
	DynamicData

	SwitchName      string                 `xml:"switchName"`
	SwitchUuid      string                 `xml:"switchUuid"`
	PortgroupName   string                 `xml:"portgroupName"`
	PortgroupKey    string                 `xml:"portgroupKey"`
	PortgroupType   string                 `xml:"portgroupType"`
	UplinkPortgroup bool                   `xml:"uplinkPortgroup"`
	Portgroup       ManagedObjectReference `xml:"portgroup"`
}

func init() {
	t["DistributedVirtualPortgroupInfo"] = reflect.TypeOf((*DistributedVirtualPortgroupInfo)(nil)).Elem()
}

type DistributedVirtualSwitchHostMember struct {
	DynamicData

	RuntimeState  *DistributedVirtualSwitchHostMemberRuntimeState `xml:"runtimeState,omitempty"`
	Config        DistributedVirtualSwitchHostMemberConfigInfo    `xml:"config"`
	ProductInfo   *DistributedVirtualSwitchProductSpec            `xml:"productInfo,omitempty"`
	UplinkPortKey []string                                        `xml:"uplinkPortKey,omitempty"`
	Status        string                                          `xml:"status"`
	StatusDetail  string                                          `xml:"statusDetail,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMember"] = reflect.TypeOf((*DistributedVirtualSwitchHostMember)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberBacking struct {
	DynamicData
}

func init() {
	t["DistributedVirtualSwitchHostMemberBacking"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberBacking)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberConfigInfo struct {
	DynamicData

	Host                 *ManagedObjectReference                       `xml:"host,omitempty"`
	MaxProxySwitchPorts  int                                           `xml:"maxProxySwitchPorts"`
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob     `xml:"vendorSpecificConfig,omitempty"`
	Backing              BaseDistributedVirtualSwitchHostMemberBacking `xml:"backing,typeattr"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberConfigInfo"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberConfigInfo)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberConfigSpec struct {
	DynamicData

	Operation            string                                        `xml:"operation"`
	Host                 ManagedObjectReference                        `xml:"host"`
	Backing              BaseDistributedVirtualSwitchHostMemberBacking `xml:"backing,omitempty,typeattr"`
	MaxProxySwitchPorts  int                                           `xml:"maxProxySwitchPorts,omitempty"`
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob     `xml:"vendorSpecificConfig,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberConfigSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberConfigSpec)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberPnicBacking struct {
	DistributedVirtualSwitchHostMemberBacking

	PnicSpec []DistributedVirtualSwitchHostMemberPnicSpec `xml:"pnicSpec,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberPnicBacking"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberPnicBacking)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberPnicSpec struct {
	DynamicData

	PnicDevice         string `xml:"pnicDevice"`
	UplinkPortKey      string `xml:"uplinkPortKey,omitempty"`
	UplinkPortgroupKey string `xml:"uplinkPortgroupKey,omitempty"`
	ConnectionCookie   int    `xml:"connectionCookie,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberPnicSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberPnicSpec)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberRuntimeState struct {
	DynamicData

	CurrentMaxProxySwitchPorts int `xml:"currentMaxProxySwitchPorts"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberRuntimeState"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberRuntimeState)(nil)).Elem()
}

type DistributedVirtualSwitchHostProductSpec struct {
	DynamicData

	ProductLineId string `xml:"productLineId,omitempty"`
	Version       string `xml:"version,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostProductSpec)(nil)).Elem()
}

type DistributedVirtualSwitchInfo struct {
	DynamicData

	SwitchName               string                 `xml:"switchName"`
	SwitchUuid               string                 `xml:"switchUuid"`
	DistributedVirtualSwitch ManagedObjectReference `xml:"distributedVirtualSwitch"`
}

func init() {
	t["DistributedVirtualSwitchInfo"] = reflect.TypeOf((*DistributedVirtualSwitchInfo)(nil)).Elem()
}

type DistributedVirtualSwitchKeyedOpaqueBlob struct {
	DynamicData

	Key        string `xml:"key"`
	OpaqueData string `xml:"opaqueData"`
}

func init() {
	t["DistributedVirtualSwitchKeyedOpaqueBlob"] = reflect.TypeOf((*DistributedVirtualSwitchKeyedOpaqueBlob)(nil)).Elem()
}

type DistributedVirtualSwitchManagerCompatibilityResult struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Error []LocalizedMethodFault `xml:"error,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerCompatibilityResult"] = reflect.TypeOf((*DistributedVirtualSwitchManagerCompatibilityResult)(nil)).Elem()
}

type DistributedVirtualSwitchManagerDvsProductSpec struct {
	DynamicData

	NewSwitchProductSpec     *DistributedVirtualSwitchProductSpec `xml:"newSwitchProductSpec,omitempty"`
	DistributedVirtualSwitch *ManagedObjectReference              `xml:"distributedVirtualSwitch,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerDvsProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchManagerDvsProductSpec)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostArrayFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostArrayFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostArrayFilter)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostContainer struct {
	DynamicData

	Container ManagedObjectReference `xml:"container"`
	Recursive bool                   `xml:"recursive"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostContainer"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostContainer)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostContainerFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	HostContainer DistributedVirtualSwitchManagerHostContainer `xml:"hostContainer"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostContainerFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostContainerFilter)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostDvsFilterSpec struct {
	DynamicData

	Inclusive bool `xml:"inclusive"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostDvsFilterSpec"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostDvsFilterSpec)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostDvsMembershipFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	DistributedVirtualSwitch ManagedObjectReference `xml:"distributedVirtualSwitch"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostDvsMembershipFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostDvsMembershipFilter)(nil)).Elem()
}

type DistributedVirtualSwitchManagerImportResult struct {
	DynamicData

	DistributedVirtualSwitch    []ManagedObjectReference                `xml:"distributedVirtualSwitch,omitempty"`
	DistributedVirtualPortgroup []ManagedObjectReference                `xml:"distributedVirtualPortgroup,omitempty"`
	ImportFault                 []ImportOperationBulkFaultFaultOnImport `xml:"importFault,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerImportResult"] = reflect.TypeOf((*DistributedVirtualSwitchManagerImportResult)(nil)).Elem()
}

type DistributedVirtualSwitchPortConnectee struct {
	DynamicData

	ConnectedEntity *ManagedObjectReference `xml:"connectedEntity,omitempty"`
	NicKey          string                  `xml:"nicKey,omitempty"`
	Type            string                  `xml:"type,omitempty"`
	AddressHint     string                  `xml:"addressHint,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortConnectee"] = reflect.TypeOf((*DistributedVirtualSwitchPortConnectee)(nil)).Elem()
}

type DistributedVirtualSwitchPortConnection struct {
	DynamicData

	SwitchUuid       string `xml:"switchUuid"`
	PortgroupKey     string `xml:"portgroupKey,omitempty"`
	PortKey          string `xml:"portKey,omitempty"`
	ConnectionCookie int    `xml:"connectionCookie,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortConnection"] = reflect.TypeOf((*DistributedVirtualSwitchPortConnection)(nil)).Elem()
}

type DistributedVirtualSwitchPortCriteria struct {
	DynamicData

	Connected    *bool                   `xml:"connected"`
	Active       *bool                   `xml:"active"`
	UplinkPort   *bool                   `xml:"uplinkPort"`
	Scope        *ManagedObjectReference `xml:"scope,omitempty"`
	PortgroupKey []string                `xml:"portgroupKey,omitempty"`
	Inside       *bool                   `xml:"inside"`
	PortKey      []string                `xml:"portKey,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortCriteria"] = reflect.TypeOf((*DistributedVirtualSwitchPortCriteria)(nil)).Elem()
}

type DistributedVirtualSwitchPortStatistics struct {
	DynamicData

	PacketsInMulticast  int64 `xml:"packetsInMulticast"`
	PacketsOutMulticast int64 `xml:"packetsOutMulticast"`
	BytesInMulticast    int64 `xml:"bytesInMulticast"`
	BytesOutMulticast   int64 `xml:"bytesOutMulticast"`
	PacketsInUnicast    int64 `xml:"packetsInUnicast"`
	PacketsOutUnicast   int64 `xml:"packetsOutUnicast"`
	BytesInUnicast      int64 `xml:"bytesInUnicast"`
	BytesOutUnicast     int64 `xml:"bytesOutUnicast"`
	PacketsInBroadcast  int64 `xml:"packetsInBroadcast"`
	PacketsOutBroadcast int64 `xml:"packetsOutBroadcast"`
	BytesInBroadcast    int64 `xml:"bytesInBroadcast"`
	BytesOutBroadcast   int64 `xml:"bytesOutBroadcast"`
	PacketsInDropped    int64 `xml:"packetsInDropped"`
	PacketsOutDropped   int64 `xml:"packetsOutDropped"`
	PacketsInException  int64 `xml:"packetsInException"`
	PacketsOutException int64 `xml:"packetsOutException"`
}

func init() {
	t["DistributedVirtualSwitchPortStatistics"] = reflect.TypeOf((*DistributedVirtualSwitchPortStatistics)(nil)).Elem()
}

type DistributedVirtualSwitchProductSpec struct {
	DynamicData

	Name            string `xml:"name,omitempty"`
	Vendor          string `xml:"vendor,omitempty"`
	Version         string `xml:"version,omitempty"`
	Build           string `xml:"build,omitempty"`
	ForwardingClass string `xml:"forwardingClass,omitempty"`
	BundleId        string `xml:"bundleId,omitempty"`
	BundleUrl       string `xml:"bundleUrl,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchProductSpec)(nil)).Elem()
}

type DoesCustomizationSpecExist DoesCustomizationSpecExistRequestType

func init() {
	t["DoesCustomizationSpecExist"] = reflect.TypeOf((*DoesCustomizationSpecExist)(nil)).Elem()
}

type DoesCustomizationSpecExistRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["DoesCustomizationSpecExistRequestType"] = reflect.TypeOf((*DoesCustomizationSpecExistRequestType)(nil)).Elem()
}

type DoesCustomizationSpecExistResponse struct {
	Returnval bool `xml:"returnval"`
}

type DomainNotFound struct {
	ActiveDirectoryFault

	DomainName string `xml:"domainName"`
}

func init() {
	t["DomainNotFound"] = reflect.TypeOf((*DomainNotFound)(nil)).Elem()
}

type DomainNotFoundFault DomainNotFound

func init() {
	t["DomainNotFoundFault"] = reflect.TypeOf((*DomainNotFoundFault)(nil)).Elem()
}

type DrsDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DrsDisabledEvent"] = reflect.TypeOf((*DrsDisabledEvent)(nil)).Elem()
}

type DrsDisabledOnVm struct {
	VimFault
}

func init() {
	t["DrsDisabledOnVm"] = reflect.TypeOf((*DrsDisabledOnVm)(nil)).Elem()
}

type DrsDisabledOnVmFault DrsDisabledOnVm

func init() {
	t["DrsDisabledOnVmFault"] = reflect.TypeOf((*DrsDisabledOnVmFault)(nil)).Elem()
}

type DrsEnabledEvent struct {
	ClusterEvent

	Behavior string `xml:"behavior"`
}

func init() {
	t["DrsEnabledEvent"] = reflect.TypeOf((*DrsEnabledEvent)(nil)).Elem()
}

type DrsEnteredStandbyModeEvent struct {
	EnteredStandbyModeEvent
}

func init() {
	t["DrsEnteredStandbyModeEvent"] = reflect.TypeOf((*DrsEnteredStandbyModeEvent)(nil)).Elem()
}

type DrsEnteringStandbyModeEvent struct {
	EnteringStandbyModeEvent
}

func init() {
	t["DrsEnteringStandbyModeEvent"] = reflect.TypeOf((*DrsEnteringStandbyModeEvent)(nil)).Elem()
}

type DrsExitStandbyModeFailedEvent struct {
	ExitStandbyModeFailedEvent
}

func init() {
	t["DrsExitStandbyModeFailedEvent"] = reflect.TypeOf((*DrsExitStandbyModeFailedEvent)(nil)).Elem()
}

type DrsExitedStandbyModeEvent struct {
	ExitedStandbyModeEvent
}

func init() {
	t["DrsExitedStandbyModeEvent"] = reflect.TypeOf((*DrsExitedStandbyModeEvent)(nil)).Elem()
}

type DrsExitingStandbyModeEvent struct {
	ExitingStandbyModeEvent
}

func init() {
	t["DrsExitingStandbyModeEvent"] = reflect.TypeOf((*DrsExitingStandbyModeEvent)(nil)).Elem()
}

type DrsInvocationFailedEvent struct {
	ClusterEvent
}

func init() {
	t["DrsInvocationFailedEvent"] = reflect.TypeOf((*DrsInvocationFailedEvent)(nil)).Elem()
}

type DrsRecoveredFromFailureEvent struct {
	ClusterEvent
}

func init() {
	t["DrsRecoveredFromFailureEvent"] = reflect.TypeOf((*DrsRecoveredFromFailureEvent)(nil)).Elem()
}

type DrsResourceConfigureFailedEvent struct {
	HostEvent

	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["DrsResourceConfigureFailedEvent"] = reflect.TypeOf((*DrsResourceConfigureFailedEvent)(nil)).Elem()
}

type DrsResourceConfigureSyncedEvent struct {
	HostEvent
}

func init() {
	t["DrsResourceConfigureSyncedEvent"] = reflect.TypeOf((*DrsResourceConfigureSyncedEvent)(nil)).Elem()
}

type DrsRuleComplianceEvent struct {
	VmEvent
}

func init() {
	t["DrsRuleComplianceEvent"] = reflect.TypeOf((*DrsRuleComplianceEvent)(nil)).Elem()
}

type DrsRuleViolationEvent struct {
	VmEvent
}

func init() {
	t["DrsRuleViolationEvent"] = reflect.TypeOf((*DrsRuleViolationEvent)(nil)).Elem()
}

type DrsVmMigratedEvent struct {
	VmMigratedEvent
}

func init() {
	t["DrsVmMigratedEvent"] = reflect.TypeOf((*DrsVmMigratedEvent)(nil)).Elem()
}

type DrsVmPoweredOnEvent struct {
	VmPoweredOnEvent
}

func init() {
	t["DrsVmPoweredOnEvent"] = reflect.TypeOf((*DrsVmPoweredOnEvent)(nil)).Elem()
}

type DrsVmotionIncompatibleFault struct {
	VirtualHardwareCompatibilityIssue

	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["DrsVmotionIncompatibleFault"] = reflect.TypeOf((*DrsVmotionIncompatibleFault)(nil)).Elem()
}

type DrsVmotionIncompatibleFaultFault DrsVmotionIncompatibleFault

func init() {
	t["DrsVmotionIncompatibleFaultFault"] = reflect.TypeOf((*DrsVmotionIncompatibleFaultFault)(nil)).Elem()
}

type DuplicateCustomizationSpec DuplicateCustomizationSpecRequestType

func init() {
	t["DuplicateCustomizationSpec"] = reflect.TypeOf((*DuplicateCustomizationSpec)(nil)).Elem()
}

type DuplicateCustomizationSpecRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Name    string                 `xml:"name"`
	NewName string                 `xml:"newName"`
}

func init() {
	t["DuplicateCustomizationSpecRequestType"] = reflect.TypeOf((*DuplicateCustomizationSpecRequestType)(nil)).Elem()
}

type DuplicateCustomizationSpecResponse struct {
}

type DuplicateDisks struct {
	VsanDiskFault
}

func init() {
	t["DuplicateDisks"] = reflect.TypeOf((*DuplicateDisks)(nil)).Elem()
}

type DuplicateDisksFault DuplicateDisks

func init() {
	t["DuplicateDisksFault"] = reflect.TypeOf((*DuplicateDisksFault)(nil)).Elem()
}

type DuplicateIpDetectedEvent struct {
	HostEvent

	DuplicateIP string `xml:"duplicateIP"`
	MacAddress  string `xml:"macAddress"`
}

func init() {
	t["DuplicateIpDetectedEvent"] = reflect.TypeOf((*DuplicateIpDetectedEvent)(nil)).Elem()
}

type DuplicateName struct {
	VimFault

	Name   string                 `xml:"name"`
	Object ManagedObjectReference `xml:"object"`
}

func init() {
	t["DuplicateName"] = reflect.TypeOf((*DuplicateName)(nil)).Elem()
}

type DuplicateNameFault DuplicateName

func init() {
	t["DuplicateNameFault"] = reflect.TypeOf((*DuplicateNameFault)(nil)).Elem()
}

type DuplicateVsanNetworkInterface struct {
	VsanFault

	Device string `xml:"device"`
}

func init() {
	t["DuplicateVsanNetworkInterface"] = reflect.TypeOf((*DuplicateVsanNetworkInterface)(nil)).Elem()
}

type DuplicateVsanNetworkInterfaceFault DuplicateVsanNetworkInterface

func init() {
	t["DuplicateVsanNetworkInterfaceFault"] = reflect.TypeOf((*DuplicateVsanNetworkInterfaceFault)(nil)).Elem()
}

type DvpgImportEvent struct {
	DVPortgroupEvent

	ImportType string `xml:"importType"`
}

func init() {
	t["DvpgImportEvent"] = reflect.TypeOf((*DvpgImportEvent)(nil)).Elem()
}

type DvpgRestoreEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DvpgRestoreEvent"] = reflect.TypeOf((*DvpgRestoreEvent)(nil)).Elem()
}

type DvsAcceptNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsAcceptNetworkRuleAction"] = reflect.TypeOf((*DvsAcceptNetworkRuleAction)(nil)).Elem()
}

type DvsApplyOperationFault struct {
	DvsFault

	ObjectFault []DvsApplyOperationFaultFaultOnObject `xml:"objectFault"`
}

func init() {
	t["DvsApplyOperationFault"] = reflect.TypeOf((*DvsApplyOperationFault)(nil)).Elem()
}

type DvsApplyOperationFaultFault DvsApplyOperationFault

func init() {
	t["DvsApplyOperationFaultFault"] = reflect.TypeOf((*DvsApplyOperationFaultFault)(nil)).Elem()
}

type DvsApplyOperationFaultFaultOnObject struct {
	DynamicData

	ObjectId string               `xml:"objectId"`
	Type     string               `xml:"type"`
	Fault    LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["DvsApplyOperationFaultFaultOnObject"] = reflect.TypeOf((*DvsApplyOperationFaultFaultOnObject)(nil)).Elem()
}

type DvsCopyNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsCopyNetworkRuleAction"] = reflect.TypeOf((*DvsCopyNetworkRuleAction)(nil)).Elem()
}

type DvsCreatedEvent struct {
	DvsEvent

	Parent FolderEventArgument `xml:"parent"`
}

func init() {
	t["DvsCreatedEvent"] = reflect.TypeOf((*DvsCreatedEvent)(nil)).Elem()
}

type DvsDestroyedEvent struct {
	DvsEvent
}

func init() {
	t["DvsDestroyedEvent"] = reflect.TypeOf((*DvsDestroyedEvent)(nil)).Elem()
}

type DvsDropNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsDropNetworkRuleAction"] = reflect.TypeOf((*DvsDropNetworkRuleAction)(nil)).Elem()
}

type DvsEvent struct {
	Event
}

func init() {
	t["DvsEvent"] = reflect.TypeOf((*DvsEvent)(nil)).Elem()
}

type DvsEventArgument struct {
	EntityEventArgument

	Dvs ManagedObjectReference `xml:"dvs"`
}

func init() {
	t["DvsEventArgument"] = reflect.TypeOf((*DvsEventArgument)(nil)).Elem()
}

type DvsFault struct {
	VimFault
}

func init() {
	t["DvsFault"] = reflect.TypeOf((*DvsFault)(nil)).Elem()
}

type DvsFaultFault BaseDvsFault

func init() {
	t["DvsFaultFault"] = reflect.TypeOf((*DvsFaultFault)(nil)).Elem()
}

type DvsFilterConfig struct {
	InheritablePolicy

	Key        string              `xml:"key,omitempty"`
	AgentName  string              `xml:"agentName,omitempty"`
	SlotNumber string              `xml:"slotNumber,omitempty"`
	Parameters *DvsFilterParameter `xml:"parameters,omitempty"`
	OnFailure  string              `xml:"onFailure,omitempty"`
}

func init() {
	t["DvsFilterConfig"] = reflect.TypeOf((*DvsFilterConfig)(nil)).Elem()
}

type DvsFilterConfigSpec struct {
	DvsFilterConfig

	Operation string `xml:"operation"`
}

func init() {
	t["DvsFilterConfigSpec"] = reflect.TypeOf((*DvsFilterConfigSpec)(nil)).Elem()
}

type DvsFilterParameter struct {
	DynamicData

	Parameters []string `xml:"parameters,omitempty"`
}

func init() {
	t["DvsFilterParameter"] = reflect.TypeOf((*DvsFilterParameter)(nil)).Elem()
}

type DvsFilterPolicy struct {
	InheritablePolicy

	FilterConfig []BaseDvsFilterConfig `xml:"filterConfig,omitempty,typeattr"`
}

func init() {
	t["DvsFilterPolicy"] = reflect.TypeOf((*DvsFilterPolicy)(nil)).Elem()
}

type DvsGreEncapNetworkRuleAction struct {
	DvsNetworkRuleAction

	EncapsulationIp SingleIp `xml:"encapsulationIp"`
}

func init() {
	t["DvsGreEncapNetworkRuleAction"] = reflect.TypeOf((*DvsGreEncapNetworkRuleAction)(nil)).Elem()
}

type DvsHealthStatusChangeEvent struct {
	HostEvent

	SwitchUuid   string                          `xml:"switchUuid"`
	HealthResult BaseHostMemberHealthCheckResult `xml:"healthResult,omitempty,typeattr"`
}

func init() {
	t["DvsHealthStatusChangeEvent"] = reflect.TypeOf((*DvsHealthStatusChangeEvent)(nil)).Elem()
}

type DvsHostBackInSyncEvent struct {
	DvsEvent

	HostBackInSync HostEventArgument `xml:"hostBackInSync"`
}

func init() {
	t["DvsHostBackInSyncEvent"] = reflect.TypeOf((*DvsHostBackInSyncEvent)(nil)).Elem()
}

type DvsHostJoinedEvent struct {
	DvsEvent

	HostJoined HostEventArgument `xml:"hostJoined"`
}

func init() {
	t["DvsHostJoinedEvent"] = reflect.TypeOf((*DvsHostJoinedEvent)(nil)).Elem()
}

type DvsHostLeftEvent struct {
	DvsEvent

	HostLeft HostEventArgument `xml:"hostLeft"`
}

func init() {
	t["DvsHostLeftEvent"] = reflect.TypeOf((*DvsHostLeftEvent)(nil)).Elem()
}

type DvsHostStatusUpdated struct {
	DvsEvent

	HostMember      HostEventArgument `xml:"hostMember"`
	OldStatus       string            `xml:"oldStatus,omitempty"`
	NewStatus       string            `xml:"newStatus,omitempty"`
	OldStatusDetail string            `xml:"oldStatusDetail,omitempty"`
	NewStatusDetail string            `xml:"newStatusDetail,omitempty"`
}

func init() {
	t["DvsHostStatusUpdated"] = reflect.TypeOf((*DvsHostStatusUpdated)(nil)).Elem()
}

type DvsHostVNicProfile struct {
	DvsVNicProfile
}

func init() {
	t["DvsHostVNicProfile"] = reflect.TypeOf((*DvsHostVNicProfile)(nil)).Elem()
}

type DvsHostWentOutOfSyncEvent struct {
	DvsEvent

	HostOutOfSync DvsOutOfSyncHostArgument `xml:"hostOutOfSync"`
}

func init() {
	t["DvsHostWentOutOfSyncEvent"] = reflect.TypeOf((*DvsHostWentOutOfSyncEvent)(nil)).Elem()
}

type DvsImportEvent struct {
	DvsEvent

	ImportType string `xml:"importType"`
}

func init() {
	t["DvsImportEvent"] = reflect.TypeOf((*DvsImportEvent)(nil)).Elem()
}

type DvsIpNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	SourceAddress      BaseIpAddress  `xml:"sourceAddress,omitempty,typeattr"`
	DestinationAddress BaseIpAddress  `xml:"destinationAddress,omitempty,typeattr"`
	Protocol           *IntExpression `xml:"protocol,omitempty"`
	SourceIpPort       BaseDvsIpPort  `xml:"sourceIpPort,omitempty,typeattr"`
	DestinationIpPort  BaseDvsIpPort  `xml:"destinationIpPort,omitempty,typeattr"`
	TcpFlags           *IntExpression `xml:"tcpFlags,omitempty"`
}

func init() {
	t["DvsIpNetworkRuleQualifier"] = reflect.TypeOf((*DvsIpNetworkRuleQualifier)(nil)).Elem()
}

type DvsIpPort struct {
	NegatableExpression
}

func init() {
	t["DvsIpPort"] = reflect.TypeOf((*DvsIpPort)(nil)).Elem()
}

type DvsIpPortRange struct {
	DvsIpPort

	StartPortNumber int `xml:"startPortNumber"`
	EndPortNumber   int `xml:"endPortNumber"`
}

func init() {
	t["DvsIpPortRange"] = reflect.TypeOf((*DvsIpPortRange)(nil)).Elem()
}

type DvsLogNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsLogNetworkRuleAction"] = reflect.TypeOf((*DvsLogNetworkRuleAction)(nil)).Elem()
}

type DvsMacNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	SourceAddress      BaseMacAddress `xml:"sourceAddress,omitempty,typeattr"`
	DestinationAddress BaseMacAddress `xml:"destinationAddress,omitempty,typeattr"`
	Protocol           *IntExpression `xml:"protocol,omitempty"`
	VlanId             *IntExpression `xml:"vlanId,omitempty"`
}

func init() {
	t["DvsMacNetworkRuleQualifier"] = reflect.TypeOf((*DvsMacNetworkRuleQualifier)(nil)).Elem()
}

type DvsMacRewriteNetworkRuleAction struct {
	DvsNetworkRuleAction

	RewriteMac string `xml:"rewriteMac"`
}

func init() {
	t["DvsMacRewriteNetworkRuleAction"] = reflect.TypeOf((*DvsMacRewriteNetworkRuleAction)(nil)).Elem()
}

type DvsMergedEvent struct {
	DvsEvent

	SourceDvs      DvsEventArgument `xml:"sourceDvs"`
	DestinationDvs DvsEventArgument `xml:"destinationDvs"`
}

func init() {
	t["DvsMergedEvent"] = reflect.TypeOf((*DvsMergedEvent)(nil)).Elem()
}

type DvsNetworkRuleAction struct {
	DynamicData
}

func init() {
	t["DvsNetworkRuleAction"] = reflect.TypeOf((*DvsNetworkRuleAction)(nil)).Elem()
}

type DvsNetworkRuleQualifier struct {
	DynamicData

	Key string `xml:"key,omitempty"`
}

func init() {
	t["DvsNetworkRuleQualifier"] = reflect.TypeOf((*DvsNetworkRuleQualifier)(nil)).Elem()
}

type DvsNotAuthorized struct {
	DvsFault

	SessionExtensionKey string `xml:"sessionExtensionKey,omitempty"`
	DvsExtensionKey     string `xml:"dvsExtensionKey,omitempty"`
}

func init() {
	t["DvsNotAuthorized"] = reflect.TypeOf((*DvsNotAuthorized)(nil)).Elem()
}

type DvsNotAuthorizedFault DvsNotAuthorized

func init() {
	t["DvsNotAuthorizedFault"] = reflect.TypeOf((*DvsNotAuthorizedFault)(nil)).Elem()
}

type DvsOperationBulkFault struct {
	DvsFault

	HostFault []DvsOperationBulkFaultFaultOnHost `xml:"hostFault"`
}

func init() {
	t["DvsOperationBulkFault"] = reflect.TypeOf((*DvsOperationBulkFault)(nil)).Elem()
}

type DvsOperationBulkFaultFault DvsOperationBulkFault

func init() {
	t["DvsOperationBulkFaultFault"] = reflect.TypeOf((*DvsOperationBulkFaultFault)(nil)).Elem()
}

type DvsOperationBulkFaultFaultOnHost struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Fault LocalizedMethodFault   `xml:"fault"`
}

func init() {
	t["DvsOperationBulkFaultFaultOnHost"] = reflect.TypeOf((*DvsOperationBulkFaultFaultOnHost)(nil)).Elem()
}

type DvsOutOfSyncHostArgument struct {
	DynamicData

	OutOfSyncHost   HostEventArgument `xml:"outOfSyncHost"`
	ConfigParamters []string          `xml:"configParamters"`
}

func init() {
	t["DvsOutOfSyncHostArgument"] = reflect.TypeOf((*DvsOutOfSyncHostArgument)(nil)).Elem()
}

type DvsPortBlockedEvent struct {
	DvsEvent

	PortKey      string        `xml:"portKey"`
	StatusDetail string        `xml:"statusDetail,omitempty"`
	RuntimeInfo  *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortBlockedEvent"] = reflect.TypeOf((*DvsPortBlockedEvent)(nil)).Elem()
}

type DvsPortConnectedEvent struct {
	DvsEvent

	PortKey   string                                 `xml:"portKey"`
	Connectee *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty"`
}

func init() {
	t["DvsPortConnectedEvent"] = reflect.TypeOf((*DvsPortConnectedEvent)(nil)).Elem()
}

type DvsPortCreatedEvent struct {
	DvsEvent

	PortKey []string `xml:"portKey"`
}

func init() {
	t["DvsPortCreatedEvent"] = reflect.TypeOf((*DvsPortCreatedEvent)(nil)).Elem()
}

type DvsPortDeletedEvent struct {
	DvsEvent

	PortKey []string `xml:"portKey"`
}

func init() {
	t["DvsPortDeletedEvent"] = reflect.TypeOf((*DvsPortDeletedEvent)(nil)).Elem()
}

type DvsPortDisconnectedEvent struct {
	DvsEvent

	PortKey   string                                 `xml:"portKey"`
	Connectee *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty"`
}

func init() {
	t["DvsPortDisconnectedEvent"] = reflect.TypeOf((*DvsPortDisconnectedEvent)(nil)).Elem()
}

type DvsPortEnteredPassthruEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortEnteredPassthruEvent"] = reflect.TypeOf((*DvsPortEnteredPassthruEvent)(nil)).Elem()
}

type DvsPortExitedPassthruEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortExitedPassthruEvent"] = reflect.TypeOf((*DvsPortExitedPassthruEvent)(nil)).Elem()
}

type DvsPortJoinPortgroupEvent struct {
	DvsEvent

	PortKey       string `xml:"portKey"`
	PortgroupKey  string `xml:"portgroupKey"`
	PortgroupName string `xml:"portgroupName"`
}

func init() {
	t["DvsPortJoinPortgroupEvent"] = reflect.TypeOf((*DvsPortJoinPortgroupEvent)(nil)).Elem()
}

type DvsPortLeavePortgroupEvent struct {
	DvsEvent

	PortKey       string `xml:"portKey"`
	PortgroupKey  string `xml:"portgroupKey"`
	PortgroupName string `xml:"portgroupName"`
}

func init() {
	t["DvsPortLeavePortgroupEvent"] = reflect.TypeOf((*DvsPortLeavePortgroupEvent)(nil)).Elem()
}

type DvsPortLinkDownEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortLinkDownEvent"] = reflect.TypeOf((*DvsPortLinkDownEvent)(nil)).Elem()
}

type DvsPortLinkUpEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortLinkUpEvent"] = reflect.TypeOf((*DvsPortLinkUpEvent)(nil)).Elem()
}

type DvsPortReconfiguredEvent struct {
	DvsEvent

	PortKey []string `xml:"portKey"`
}

func init() {
	t["DvsPortReconfiguredEvent"] = reflect.TypeOf((*DvsPortReconfiguredEvent)(nil)).Elem()
}

type DvsPortRuntimeChangeEvent struct {
	DvsEvent

	PortKey     string       `xml:"portKey"`
	RuntimeInfo DVPortStatus `xml:"runtimeInfo"`
}

func init() {
	t["DvsPortRuntimeChangeEvent"] = reflect.TypeOf((*DvsPortRuntimeChangeEvent)(nil)).Elem()
}

type DvsPortUnblockedEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortUnblockedEvent"] = reflect.TypeOf((*DvsPortUnblockedEvent)(nil)).Elem()
}

type DvsPortVendorSpecificStateChangeEvent struct {
	DvsEvent

	PortKey string `xml:"portKey"`
}

func init() {
	t["DvsPortVendorSpecificStateChangeEvent"] = reflect.TypeOf((*DvsPortVendorSpecificStateChangeEvent)(nil)).Elem()
}

type DvsProfile struct {
	ApplyProfile

	Key    string              `xml:"key"`
	Name   string              `xml:"name"`
	Uplink []PnicUplinkProfile `xml:"uplink,omitempty"`
}

func init() {
	t["DvsProfile"] = reflect.TypeOf((*DvsProfile)(nil)).Elem()
}

type DvsPuntNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsPuntNetworkRuleAction"] = reflect.TypeOf((*DvsPuntNetworkRuleAction)(nil)).Elem()
}

type DvsRateLimitNetworkRuleAction struct {
	DvsNetworkRuleAction

	PacketsPerSecond int `xml:"packetsPerSecond"`
}

func init() {
	t["DvsRateLimitNetworkRuleAction"] = reflect.TypeOf((*DvsRateLimitNetworkRuleAction)(nil)).Elem()
}

type DvsReconfiguredEvent struct {
	DvsEvent

	ConfigSpec BaseDVSConfigSpec `xml:"configSpec,typeattr"`
}

func init() {
	t["DvsReconfiguredEvent"] = reflect.TypeOf((*DvsReconfiguredEvent)(nil)).Elem()
}

type DvsRenamedEvent struct {
	DvsEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DvsRenamedEvent"] = reflect.TypeOf((*DvsRenamedEvent)(nil)).Elem()
}

type DvsRestoreEvent struct {
	DvsEvent
}

func init() {
	t["DvsRestoreEvent"] = reflect.TypeOf((*DvsRestoreEvent)(nil)).Elem()
}

type DvsScopeViolated struct {
	DvsFault

	Scope  []ManagedObjectReference `xml:"scope"`
	Entity ManagedObjectReference   `xml:"entity"`
}

func init() {
	t["DvsScopeViolated"] = reflect.TypeOf((*DvsScopeViolated)(nil)).Elem()
}

type DvsScopeViolatedFault DvsScopeViolated

func init() {
	t["DvsScopeViolatedFault"] = reflect.TypeOf((*DvsScopeViolatedFault)(nil)).Elem()
}

type DvsServiceConsoleVNicProfile struct {
	DvsVNicProfile
}

func init() {
	t["DvsServiceConsoleVNicProfile"] = reflect.TypeOf((*DvsServiceConsoleVNicProfile)(nil)).Elem()
}

type DvsSingleIpPort struct {
	DvsIpPort

	PortNumber int `xml:"portNumber"`
}

func init() {
	t["DvsSingleIpPort"] = reflect.TypeOf((*DvsSingleIpPort)(nil)).Elem()
}

type DvsSystemTrafficNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	TypeOfSystemTraffic *StringExpression `xml:"typeOfSystemTraffic,omitempty"`
}

func init() {
	t["DvsSystemTrafficNetworkRuleQualifier"] = reflect.TypeOf((*DvsSystemTrafficNetworkRuleQualifier)(nil)).Elem()
}

type DvsTrafficFilterConfig struct {
	DvsFilterConfig

	TrafficRuleset *DvsTrafficRuleset `xml:"trafficRuleset,omitempty"`
}

func init() {
	t["DvsTrafficFilterConfig"] = reflect.TypeOf((*DvsTrafficFilterConfig)(nil)).Elem()
}

type DvsTrafficFilterConfigSpec struct {
	DvsTrafficFilterConfig

	Operation string `xml:"operation"`
}

func init() {
	t["DvsTrafficFilterConfigSpec"] = reflect.TypeOf((*DvsTrafficFilterConfigSpec)(nil)).Elem()
}

type DvsTrafficRule struct {
	DynamicData

	Key         string                        `xml:"key,omitempty"`
	Description string                        `xml:"description,omitempty"`
	Sequence    int                           `xml:"sequence,omitempty"`
	Qualifier   []BaseDvsNetworkRuleQualifier `xml:"qualifier,omitempty,typeattr"`
	Action      BaseDvsNetworkRuleAction      `xml:"action,omitempty,typeattr"`
	Direction   string                        `xml:"direction,omitempty"`
}

func init() {
	t["DvsTrafficRule"] = reflect.TypeOf((*DvsTrafficRule)(nil)).Elem()
}

type DvsTrafficRuleset struct {
	DynamicData

	Key        string           `xml:"key,omitempty"`
	Enabled    *bool            `xml:"enabled"`
	Precedence int              `xml:"precedence,omitempty"`
	Rules      []DvsTrafficRule `xml:"rules,omitempty"`
}

func init() {
	t["DvsTrafficRuleset"] = reflect.TypeOf((*DvsTrafficRuleset)(nil)).Elem()
}

type DvsUpdateTagNetworkRuleAction struct {
	DvsNetworkRuleAction

	QosTag  int `xml:"qosTag,omitempty"`
	DscpTag int `xml:"dscpTag,omitempty"`
}

func init() {
	t["DvsUpdateTagNetworkRuleAction"] = reflect.TypeOf((*DvsUpdateTagNetworkRuleAction)(nil)).Elem()
}

type DvsUpgradeAvailableEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradeAvailableEvent"] = reflect.TypeOf((*DvsUpgradeAvailableEvent)(nil)).Elem()
}

type DvsUpgradeInProgressEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradeInProgressEvent"] = reflect.TypeOf((*DvsUpgradeInProgressEvent)(nil)).Elem()
}

type DvsUpgradeRejectedEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradeRejectedEvent"] = reflect.TypeOf((*DvsUpgradeRejectedEvent)(nil)).Elem()
}

type DvsUpgradedEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradedEvent"] = reflect.TypeOf((*DvsUpgradedEvent)(nil)).Elem()
}

type DvsVNicProfile struct {
	ApplyProfile

	Key      string           `xml:"key"`
	IpConfig IpAddressProfile `xml:"ipConfig"`
}

func init() {
	t["DvsVNicProfile"] = reflect.TypeOf((*DvsVNicProfile)(nil)).Elem()
}

type DynamicArray struct {
	DynamicType string    `xml:"dynamicType,omitempty"`
	Val         []AnyType `xml:"val,typeattr"`
}

func init() {
	t["DynamicArray"] = reflect.TypeOf((*DynamicArray)(nil)).Elem()
}

type DynamicData struct {
	DynamicType     string            `xml:"dynamicType,omitempty"`
	DynamicProperty []DynamicProperty `xml:"dynamicProperty,omitempty"`
}

func init() {
	t["DynamicData"] = reflect.TypeOf((*DynamicData)(nil)).Elem()
}

type DynamicProperty struct {
	Name string  `xml:"name"`
	Val  AnyType `xml:"val,typeattr"`
}

func init() {
	t["DynamicProperty"] = reflect.TypeOf((*DynamicProperty)(nil)).Elem()
}

type EVCAdmissionFailed struct {
	NotSupportedHostInCluster

	Faults []LocalizedMethodFault `xml:"faults,omitempty"`
}

func init() {
	t["EVCAdmissionFailed"] = reflect.TypeOf((*EVCAdmissionFailed)(nil)).Elem()
}

type EVCAdmissionFailedCPUFeaturesForMode struct {
	EVCAdmissionFailed

	CurrentEVCModeKey string `xml:"currentEVCModeKey"`
}

func init() {
	t["EVCAdmissionFailedCPUFeaturesForMode"] = reflect.TypeOf((*EVCAdmissionFailedCPUFeaturesForMode)(nil)).Elem()
}

type EVCAdmissionFailedCPUFeaturesForModeFault EVCAdmissionFailedCPUFeaturesForMode

func init() {
	t["EVCAdmissionFailedCPUFeaturesForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUFeaturesForModeFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUModel struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedCPUModel"] = reflect.TypeOf((*EVCAdmissionFailedCPUModel)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelFault EVCAdmissionFailedCPUModel

func init() {
	t["EVCAdmissionFailedCPUModelFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelForMode struct {
	EVCAdmissionFailed

	CurrentEVCModeKey string `xml:"currentEVCModeKey"`
}

func init() {
	t["EVCAdmissionFailedCPUModelForMode"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelForMode)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelForModeFault EVCAdmissionFailedCPUModelForMode

func init() {
	t["EVCAdmissionFailedCPUModelForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelForModeFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendor struct {
	EVCAdmissionFailed

	ClusterCPUVendor string `xml:"clusterCPUVendor"`
	HostCPUVendor    string `xml:"hostCPUVendor"`
}

func init() {
	t["EVCAdmissionFailedCPUVendor"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendor)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorFault EVCAdmissionFailedCPUVendor

func init() {
	t["EVCAdmissionFailedCPUVendorFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorUnknown struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedCPUVendorUnknown"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorUnknown)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorUnknownFault EVCAdmissionFailedCPUVendorUnknown

func init() {
	t["EVCAdmissionFailedCPUVendorUnknownFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorUnknownFault)(nil)).Elem()
}

type EVCAdmissionFailedFault BaseEVCAdmissionFailed

func init() {
	t["EVCAdmissionFailedFault"] = reflect.TypeOf((*EVCAdmissionFailedFault)(nil)).Elem()
}

type EVCAdmissionFailedHostDisconnected struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostDisconnected"] = reflect.TypeOf((*EVCAdmissionFailedHostDisconnected)(nil)).Elem()
}

type EVCAdmissionFailedHostDisconnectedFault EVCAdmissionFailedHostDisconnected

func init() {
	t["EVCAdmissionFailedHostDisconnectedFault"] = reflect.TypeOf((*EVCAdmissionFailedHostDisconnectedFault)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftware struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostSoftware"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftware)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareFault EVCAdmissionFailedHostSoftware

func init() {
	t["EVCAdmissionFailedHostSoftwareFault"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareFault)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareForMode struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostSoftwareForMode"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareForMode)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareForModeFault EVCAdmissionFailedHostSoftwareForMode

func init() {
	t["EVCAdmissionFailedHostSoftwareForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareForModeFault)(nil)).Elem()
}

type EVCAdmissionFailedVmActive struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedVmActive"] = reflect.TypeOf((*EVCAdmissionFailedVmActive)(nil)).Elem()
}

type EVCAdmissionFailedVmActiveFault EVCAdmissionFailedVmActive

func init() {
	t["EVCAdmissionFailedVmActiveFault"] = reflect.TypeOf((*EVCAdmissionFailedVmActiveFault)(nil)).Elem()
}

type EVCMode struct {
	ElementDescription

	GuaranteedCPUFeatures []HostCpuIdInfo                    `xml:"guaranteedCPUFeatures,omitempty"`
	FeatureCapability     []HostFeatureCapability            `xml:"featureCapability,omitempty"`
	FeatureMask           []HostFeatureMask                  `xml:"featureMask,omitempty"`
	FeatureRequirement    []VirtualMachineFeatureRequirement `xml:"featureRequirement,omitempty"`
	Vendor                string                             `xml:"vendor"`
	Track                 []string                           `xml:"track,omitempty"`
	VendorTier            int                                `xml:"vendorTier"`
}

func init() {
	t["EVCMode"] = reflect.TypeOf((*EVCMode)(nil)).Elem()
}

type EagerZeroVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["EagerZeroVirtualDiskRequestType"] = reflect.TypeOf((*EagerZeroVirtualDiskRequestType)(nil)).Elem()
}

type EagerZeroVirtualDisk_Task EagerZeroVirtualDiskRequestType

func init() {
	t["EagerZeroVirtualDisk_Task"] = reflect.TypeOf((*EagerZeroVirtualDisk_Task)(nil)).Elem()
}

type EagerZeroVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EightHostLimitViolated struct {
	VmConfigFault
}

func init() {
	t["EightHostLimitViolated"] = reflect.TypeOf((*EightHostLimitViolated)(nil)).Elem()
}

type EightHostLimitViolatedFault EightHostLimitViolated

func init() {
	t["EightHostLimitViolatedFault"] = reflect.TypeOf((*EightHostLimitViolatedFault)(nil)).Elem()
}

type ElementDescription struct {
	Description

	Key string `xml:"key"`
}

func init() {
	t["ElementDescription"] = reflect.TypeOf((*ElementDescription)(nil)).Elem()
}

type EnableAlarmActions EnableAlarmActionsRequestType

func init() {
	t["EnableAlarmActions"] = reflect.TypeOf((*EnableAlarmActions)(nil)).Elem()
}

type EnableAlarmActionsRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Entity  ManagedObjectReference `xml:"entity"`
	Enabled bool                   `xml:"enabled"`
}

func init() {
	t["EnableAlarmActionsRequestType"] = reflect.TypeOf((*EnableAlarmActionsRequestType)(nil)).Elem()
}

type EnableAlarmActionsResponse struct {
}

type EnableFeature EnableFeatureRequestType

func init() {
	t["EnableFeature"] = reflect.TypeOf((*EnableFeature)(nil)).Elem()
}

type EnableFeatureRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
	FeatureKey string                  `xml:"featureKey"`
}

func init() {
	t["EnableFeatureRequestType"] = reflect.TypeOf((*EnableFeatureRequestType)(nil)).Elem()
}

type EnableFeatureResponse struct {
	Returnval bool `xml:"returnval"`
}

type EnableHyperThreading EnableHyperThreadingRequestType

func init() {
	t["EnableHyperThreading"] = reflect.TypeOf((*EnableHyperThreading)(nil)).Elem()
}

type EnableHyperThreadingRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EnableHyperThreadingRequestType"] = reflect.TypeOf((*EnableHyperThreadingRequestType)(nil)).Elem()
}

type EnableHyperThreadingResponse struct {
}

type EnableMultipathPath EnableMultipathPathRequestType

func init() {
	t["EnableMultipathPath"] = reflect.TypeOf((*EnableMultipathPath)(nil)).Elem()
}

type EnableMultipathPathRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	PathName string                 `xml:"pathName"`
}

func init() {
	t["EnableMultipathPathRequestType"] = reflect.TypeOf((*EnableMultipathPathRequestType)(nil)).Elem()
}

type EnableMultipathPathResponse struct {
}

type EnableNetworkResourceManagement EnableNetworkResourceManagementRequestType

func init() {
	t["EnableNetworkResourceManagement"] = reflect.TypeOf((*EnableNetworkResourceManagement)(nil)).Elem()
}

type EnableNetworkResourceManagementRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Enable bool                   `xml:"enable"`
}

func init() {
	t["EnableNetworkResourceManagementRequestType"] = reflect.TypeOf((*EnableNetworkResourceManagementRequestType)(nil)).Elem()
}

type EnableNetworkResourceManagementResponse struct {
}

type EnableRuleset EnableRulesetRequestType

func init() {
	t["EnableRuleset"] = reflect.TypeOf((*EnableRuleset)(nil)).Elem()
}

type EnableRulesetRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["EnableRulesetRequestType"] = reflect.TypeOf((*EnableRulesetRequestType)(nil)).Elem()
}

type EnableRulesetResponse struct {
}

type EnableSecondaryVMRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["EnableSecondaryVMRequestType"] = reflect.TypeOf((*EnableSecondaryVMRequestType)(nil)).Elem()
}

type EnableSecondaryVM_Task EnableSecondaryVMRequestType

func init() {
	t["EnableSecondaryVM_Task"] = reflect.TypeOf((*EnableSecondaryVM_Task)(nil)).Elem()
}

type EnableSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EnterLockdownMode EnterLockdownModeRequestType

func init() {
	t["EnterLockdownMode"] = reflect.TypeOf((*EnterLockdownMode)(nil)).Elem()
}

type EnterLockdownModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EnterLockdownModeRequestType"] = reflect.TypeOf((*EnterLockdownModeRequestType)(nil)).Elem()
}

type EnterLockdownModeResponse struct {
}

type EnterMaintenanceModeRequestType struct {
	This                  ManagedObjectReference `xml:"_this"`
	Timeout               int                    `xml:"timeout"`
	EvacuatePoweredOffVms *bool                  `xml:"evacuatePoweredOffVms"`
	MaintenanceSpec       *HostMaintenanceSpec   `xml:"maintenanceSpec,omitempty"`
}

func init() {
	t["EnterMaintenanceModeRequestType"] = reflect.TypeOf((*EnterMaintenanceModeRequestType)(nil)).Elem()
}

type EnterMaintenanceMode_Task EnterMaintenanceModeRequestType

func init() {
	t["EnterMaintenanceMode_Task"] = reflect.TypeOf((*EnterMaintenanceMode_Task)(nil)).Elem()
}

type EnterMaintenanceMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EnteredMaintenanceModeEvent struct {
	HostEvent
}

func init() {
	t["EnteredMaintenanceModeEvent"] = reflect.TypeOf((*EnteredMaintenanceModeEvent)(nil)).Elem()
}

type EnteredStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["EnteredStandbyModeEvent"] = reflect.TypeOf((*EnteredStandbyModeEvent)(nil)).Elem()
}

type EnteringMaintenanceModeEvent struct {
	HostEvent
}

func init() {
	t["EnteringMaintenanceModeEvent"] = reflect.TypeOf((*EnteringMaintenanceModeEvent)(nil)).Elem()
}

type EnteringStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["EnteringStandbyModeEvent"] = reflect.TypeOf((*EnteringStandbyModeEvent)(nil)).Elem()
}

type EntityBackup struct {
	DynamicData
}

func init() {
	t["EntityBackup"] = reflect.TypeOf((*EntityBackup)(nil)).Elem()
}

type EntityBackupConfig struct {
	DynamicData

	EntityType    string                  `xml:"entityType"`
	ConfigBlob    []byte                  `xml:"configBlob"`
	Key           string                  `xml:"key,omitempty"`
	Name          string                  `xml:"name,omitempty"`
	Container     *ManagedObjectReference `xml:"container,omitempty"`
	ConfigVersion string                  `xml:"configVersion,omitempty"`
}

func init() {
	t["EntityBackupConfig"] = reflect.TypeOf((*EntityBackupConfig)(nil)).Elem()
}

type EntityEventArgument struct {
	EventArgument

	Name string `xml:"name"`
}

func init() {
	t["EntityEventArgument"] = reflect.TypeOf((*EntityEventArgument)(nil)).Elem()
}

type EntityPrivilege struct {
	DynamicData

	Entity           ManagedObjectReference  `xml:"entity"`
	PrivAvailability []PrivilegeAvailability `xml:"privAvailability"`
}

func init() {
	t["EntityPrivilege"] = reflect.TypeOf((*EntityPrivilege)(nil)).Elem()
}

type EnumDescription struct {
	DynamicData

	Key  string                   `xml:"key"`
	Tags []BaseElementDescription `xml:"tags,typeattr"`
}

func init() {
	t["EnumDescription"] = reflect.TypeOf((*EnumDescription)(nil)).Elem()
}

type ErrorUpgradeEvent struct {
	UpgradeEvent
}

func init() {
	t["ErrorUpgradeEvent"] = reflect.TypeOf((*ErrorUpgradeEvent)(nil)).Elem()
}

type EstimateDatabaseSize EstimateDatabaseSizeRequestType

func init() {
	t["EstimateDatabaseSize"] = reflect.TypeOf((*EstimateDatabaseSize)(nil)).Elem()
}

type EstimateDatabaseSizeRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	DbSizeParam DatabaseSizeParam      `xml:"dbSizeParam"`
}

func init() {
	t["EstimateDatabaseSizeRequestType"] = reflect.TypeOf((*EstimateDatabaseSizeRequestType)(nil)).Elem()
}

type EstimateDatabaseSizeResponse struct {
	Returnval DatabaseSizeEstimate `xml:"returnval"`
}

type EstimateStorageForConsolidateSnapshotsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EstimateStorageForConsolidateSnapshotsRequestType"] = reflect.TypeOf((*EstimateStorageForConsolidateSnapshotsRequestType)(nil)).Elem()
}

type EstimateStorageForConsolidateSnapshots_Task EstimateStorageForConsolidateSnapshotsRequestType

func init() {
	t["EstimateStorageForConsolidateSnapshots_Task"] = reflect.TypeOf((*EstimateStorageForConsolidateSnapshots_Task)(nil)).Elem()
}

type EstimateStorageForConsolidateSnapshots_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EsxAgentHostManagerUpdateConfig EsxAgentHostManagerUpdateConfigRequestType

func init() {
	t["EsxAgentHostManagerUpdateConfig"] = reflect.TypeOf((*EsxAgentHostManagerUpdateConfig)(nil)).Elem()
}

type EsxAgentHostManagerUpdateConfigRequestType struct {
	This       ManagedObjectReference            `xml:"_this"`
	ConfigInfo HostEsxAgentHostManagerConfigInfo `xml:"configInfo"`
}

func init() {
	t["EsxAgentHostManagerUpdateConfigRequestType"] = reflect.TypeOf((*EsxAgentHostManagerUpdateConfigRequestType)(nil)).Elem()
}

type EsxAgentHostManagerUpdateConfigResponse struct {
}

type EvaluationLicenseSource struct {
	LicenseSource

	RemainingHours int64 `xml:"remainingHours,omitempty"`
}

func init() {
	t["EvaluationLicenseSource"] = reflect.TypeOf((*EvaluationLicenseSource)(nil)).Elem()
}

type Event struct {
	DynamicData

	Key                  int                           `xml:"key"`
	ChainId              int                           `xml:"chainId"`
	CreatedTime          time.Time                     `xml:"createdTime"`
	UserName             string                        `xml:"userName"`
	Datacenter           *DatacenterEventArgument      `xml:"datacenter,omitempty"`
	ComputeResource      *ComputeResourceEventArgument `xml:"computeResource,omitempty"`
	Host                 *HostEventArgument            `xml:"host,omitempty"`
	Vm                   *VmEventArgument              `xml:"vm,omitempty"`
	Ds                   *DatastoreEventArgument       `xml:"ds,omitempty"`
	Net                  *NetworkEventArgument         `xml:"net,omitempty"`
	Dvs                  *DvsEventArgument             `xml:"dvs,omitempty"`
	FullFormattedMessage string                        `xml:"fullFormattedMessage,omitempty"`
	ChangeTag            string                        `xml:"changeTag,omitempty"`
}

func init() {
	t["Event"] = reflect.TypeOf((*Event)(nil)).Elem()
}

type EventAlarmExpression struct {
	AlarmExpression

	Comparisons []EventAlarmExpressionComparison `xml:"comparisons,omitempty"`
	EventType   string                           `xml:"eventType"`
	EventTypeId string                           `xml:"eventTypeId,omitempty"`
	ObjectType  string                           `xml:"objectType,omitempty"`
	Status      ManagedEntityStatus              `xml:"status,omitempty"`
}

func init() {
	t["EventAlarmExpression"] = reflect.TypeOf((*EventAlarmExpression)(nil)).Elem()
}

type EventAlarmExpressionComparison struct {
	DynamicData

	AttributeName string `xml:"attributeName"`
	Operator      string `xml:"operator"`
	Value         string `xml:"value"`
}

func init() {
	t["EventAlarmExpressionComparison"] = reflect.TypeOf((*EventAlarmExpressionComparison)(nil)).Elem()
}

type EventArgDesc struct {
	DynamicData

	Name        string                 `xml:"name"`
	Type        string                 `xml:"type"`
	Description BaseElementDescription `xml:"description,omitempty,typeattr"`
}

func init() {
	t["EventArgDesc"] = reflect.TypeOf((*EventArgDesc)(nil)).Elem()
}

type EventArgument struct {
	DynamicData
}

func init() {
	t["EventArgument"] = reflect.TypeOf((*EventArgument)(nil)).Elem()
}

type EventDescription struct {
	DynamicData

	Category        []BaseElementDescription      `xml:"category,typeattr"`
	EventInfo       []EventDescriptionEventDetail `xml:"eventInfo"`
	EnumeratedTypes []EnumDescription             `xml:"enumeratedTypes,omitempty"`
}

func init() {
	t["EventDescription"] = reflect.TypeOf((*EventDescription)(nil)).Elem()
}

type EventDescriptionEventDetail struct {
	DynamicData

	Key                     string `xml:"key"`
	Description             string `xml:"description,omitempty"`
	Category                string `xml:"category"`
	FormatOnDatacenter      string `xml:"formatOnDatacenter"`
	FormatOnComputeResource string `xml:"formatOnComputeResource"`
	FormatOnHost            string `xml:"formatOnHost"`
	FormatOnVm              string `xml:"formatOnVm"`
	FullFormat              string `xml:"fullFormat"`
	LongDescription         string `xml:"longDescription,omitempty"`
}

func init() {
	t["EventDescriptionEventDetail"] = reflect.TypeOf((*EventDescriptionEventDetail)(nil)).Elem()
}

type EventEx struct {
	Event

	EventTypeId string                `xml:"eventTypeId"`
	Severity    string                `xml:"severity,omitempty"`
	Message     string                `xml:"message,omitempty"`
	Arguments   []KeyAnyValue         `xml:"arguments,omitempty"`
	ObjectId    string                `xml:"objectId,omitempty"`
	ObjectType  string                `xml:"objectType,omitempty"`
	ObjectName  string                `xml:"objectName,omitempty"`
	Fault       *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["EventEx"] = reflect.TypeOf((*EventEx)(nil)).Elem()
}

type EventFilterSpec struct {
	DynamicData

	Entity             *EventFilterSpecByEntity   `xml:"entity,omitempty"`
	Time               *EventFilterSpecByTime     `xml:"time,omitempty"`
	UserName           *EventFilterSpecByUsername `xml:"userName,omitempty"`
	EventChainId       int                        `xml:"eventChainId,omitempty"`
	Alarm              *ManagedObjectReference    `xml:"alarm,omitempty"`
	ScheduledTask      *ManagedObjectReference    `xml:"scheduledTask,omitempty"`
	DisableFullMessage *bool                      `xml:"disableFullMessage"`
	Category           []string                   `xml:"category,omitempty"`
	Type               []string                   `xml:"type,omitempty"`
	Tag                []string                   `xml:"tag,omitempty"`
	EventTypeId        []string                   `xml:"eventTypeId,omitempty"`
}

func init() {
	t["EventFilterSpec"] = reflect.TypeOf((*EventFilterSpec)(nil)).Elem()
}

type EventFilterSpecByEntity struct {
	DynamicData

	Entity    ManagedObjectReference         `xml:"entity"`
	Recursion EventFilterSpecRecursionOption `xml:"recursion"`
}

func init() {
	t["EventFilterSpecByEntity"] = reflect.TypeOf((*EventFilterSpecByEntity)(nil)).Elem()
}

type EventFilterSpecByTime struct {
	DynamicData

	BeginTime *time.Time `xml:"beginTime"`
	EndTime   *time.Time `xml:"endTime"`
}

func init() {
	t["EventFilterSpecByTime"] = reflect.TypeOf((*EventFilterSpecByTime)(nil)).Elem()
}

type EventFilterSpecByUsername struct {
	DynamicData

	SystemUser bool     `xml:"systemUser"`
	UserList   []string `xml:"userList,omitempty"`
}

func init() {
	t["EventFilterSpecByUsername"] = reflect.TypeOf((*EventFilterSpecByUsername)(nil)).Elem()
}

type ExecuteHostProfile ExecuteHostProfileRequestType

func init() {
	t["ExecuteHostProfile"] = reflect.TypeOf((*ExecuteHostProfile)(nil)).Elem()
}

type ExecuteHostProfileRequestType struct {
	This          ManagedObjectReference                 `xml:"_this"`
	Host          ManagedObjectReference                 `xml:"host"`
	DeferredParam []ProfileDeferredPolicyOptionParameter `xml:"deferredParam,omitempty"`
}

func init() {
	t["ExecuteHostProfileRequestType"] = reflect.TypeOf((*ExecuteHostProfileRequestType)(nil)).Elem()
}

type ExecuteHostProfileResponse struct {
	Returnval ProfileExecuteResult `xml:"returnval"`
}

type ExecuteSimpleCommand ExecuteSimpleCommandRequestType

func init() {
	t["ExecuteSimpleCommand"] = reflect.TypeOf((*ExecuteSimpleCommand)(nil)).Elem()
}

type ExecuteSimpleCommandRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Arguments []string               `xml:"arguments,omitempty"`
}

func init() {
	t["ExecuteSimpleCommandRequestType"] = reflect.TypeOf((*ExecuteSimpleCommandRequestType)(nil)).Elem()
}

type ExecuteSimpleCommandResponse struct {
	Returnval string `xml:"returnval"`
}

type ExitLockdownMode ExitLockdownModeRequestType

func init() {
	t["ExitLockdownMode"] = reflect.TypeOf((*ExitLockdownMode)(nil)).Elem()
}

type ExitLockdownModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExitLockdownModeRequestType"] = reflect.TypeOf((*ExitLockdownModeRequestType)(nil)).Elem()
}

type ExitLockdownModeResponse struct {
}

type ExitMaintenanceModeEvent struct {
	HostEvent
}

func init() {
	t["ExitMaintenanceModeEvent"] = reflect.TypeOf((*ExitMaintenanceModeEvent)(nil)).Elem()
}

type ExitMaintenanceModeRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Timeout int                    `xml:"timeout"`
}

func init() {
	t["ExitMaintenanceModeRequestType"] = reflect.TypeOf((*ExitMaintenanceModeRequestType)(nil)).Elem()
}

type ExitMaintenanceMode_Task ExitMaintenanceModeRequestType

func init() {
	t["ExitMaintenanceMode_Task"] = reflect.TypeOf((*ExitMaintenanceMode_Task)(nil)).Elem()
}

type ExitMaintenanceMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExitStandbyModeFailedEvent struct {
	HostEvent
}

func init() {
	t["ExitStandbyModeFailedEvent"] = reflect.TypeOf((*ExitStandbyModeFailedEvent)(nil)).Elem()
}

type ExitedStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["ExitedStandbyModeEvent"] = reflect.TypeOf((*ExitedStandbyModeEvent)(nil)).Elem()
}

type ExitingStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["ExitingStandbyModeEvent"] = reflect.TypeOf((*ExitingStandbyModeEvent)(nil)).Elem()
}

type ExpandVmfsDatastore ExpandVmfsDatastoreRequestType

func init() {
	t["ExpandVmfsDatastore"] = reflect.TypeOf((*ExpandVmfsDatastore)(nil)).Elem()
}

type ExpandVmfsDatastoreRequestType struct {
	This      ManagedObjectReference  `xml:"_this"`
	Datastore ManagedObjectReference  `xml:"datastore"`
	Spec      VmfsDatastoreExpandSpec `xml:"spec"`
}

func init() {
	t["ExpandVmfsDatastoreRequestType"] = reflect.TypeOf((*ExpandVmfsDatastoreRequestType)(nil)).Elem()
}

type ExpandVmfsDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExpandVmfsExtent ExpandVmfsExtentRequestType

func init() {
	t["ExpandVmfsExtent"] = reflect.TypeOf((*ExpandVmfsExtent)(nil)).Elem()
}

type ExpandVmfsExtentRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsPath string                 `xml:"vmfsPath"`
	Extent   HostScsiDiskPartition  `xml:"extent"`
}

func init() {
	t["ExpandVmfsExtentRequestType"] = reflect.TypeOf((*ExpandVmfsExtentRequestType)(nil)).Elem()
}

type ExpandVmfsExtentResponse struct {
}

type ExpiredAddonLicense struct {
	ExpiredFeatureLicense
}

func init() {
	t["ExpiredAddonLicense"] = reflect.TypeOf((*ExpiredAddonLicense)(nil)).Elem()
}

type ExpiredAddonLicenseFault ExpiredAddonLicense

func init() {
	t["ExpiredAddonLicenseFault"] = reflect.TypeOf((*ExpiredAddonLicenseFault)(nil)).Elem()
}

type ExpiredEditionLicense struct {
	ExpiredFeatureLicense
}

func init() {
	t["ExpiredEditionLicense"] = reflect.TypeOf((*ExpiredEditionLicense)(nil)).Elem()
}

type ExpiredEditionLicenseFault ExpiredEditionLicense

func init() {
	t["ExpiredEditionLicenseFault"] = reflect.TypeOf((*ExpiredEditionLicenseFault)(nil)).Elem()
}

type ExpiredFeatureLicense struct {
	NotEnoughLicenses

	Feature        string    `xml:"feature"`
	Count          int       `xml:"count"`
	ExpirationDate time.Time `xml:"expirationDate"`
}

func init() {
	t["ExpiredFeatureLicense"] = reflect.TypeOf((*ExpiredFeatureLicense)(nil)).Elem()
}

type ExpiredFeatureLicenseFault BaseExpiredFeatureLicense

func init() {
	t["ExpiredFeatureLicenseFault"] = reflect.TypeOf((*ExpiredFeatureLicenseFault)(nil)).Elem()
}

type ExportAnswerFileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["ExportAnswerFileRequestType"] = reflect.TypeOf((*ExportAnswerFileRequestType)(nil)).Elem()
}

type ExportAnswerFile_Task ExportAnswerFileRequestType

func init() {
	t["ExportAnswerFile_Task"] = reflect.TypeOf((*ExportAnswerFile_Task)(nil)).Elem()
}

type ExportAnswerFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExportProfile ExportProfileRequestType

func init() {
	t["ExportProfile"] = reflect.TypeOf((*ExportProfile)(nil)).Elem()
}

type ExportProfileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportProfileRequestType"] = reflect.TypeOf((*ExportProfileRequestType)(nil)).Elem()
}

type ExportProfileResponse struct {
	Returnval string `xml:"returnval"`
}

type ExportSnapshot ExportSnapshotRequestType

func init() {
	t["ExportSnapshot"] = reflect.TypeOf((*ExportSnapshot)(nil)).Elem()
}

type ExportSnapshotRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportSnapshotRequestType"] = reflect.TypeOf((*ExportSnapshotRequestType)(nil)).Elem()
}

type ExportSnapshotResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExportVApp ExportVAppRequestType

func init() {
	t["ExportVApp"] = reflect.TypeOf((*ExportVApp)(nil)).Elem()
}

type ExportVAppRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportVAppRequestType"] = reflect.TypeOf((*ExportVAppRequestType)(nil)).Elem()
}

type ExportVAppResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExportVm ExportVmRequestType

func init() {
	t["ExportVm"] = reflect.TypeOf((*ExportVm)(nil)).Elem()
}

type ExportVmRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportVmRequestType"] = reflect.TypeOf((*ExportVmRequestType)(nil)).Elem()
}

type ExportVmResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtExtendedProductInfo struct {
	DynamicData

	CompanyUrl    string                  `xml:"companyUrl,omitempty"`
	ProductUrl    string                  `xml:"productUrl,omitempty"`
	ManagementUrl string                  `xml:"managementUrl,omitempty"`
	Self          *ManagedObjectReference `xml:"self,omitempty"`
}

func init() {
	t["ExtExtendedProductInfo"] = reflect.TypeOf((*ExtExtendedProductInfo)(nil)).Elem()
}

type ExtManagedEntityInfo struct {
	DynamicData

	Type         string `xml:"type"`
	SmallIconUrl string `xml:"smallIconUrl,omitempty"`
	IconUrl      string `xml:"iconUrl,omitempty"`
	Description  string `xml:"description,omitempty"`
}

func init() {
	t["ExtManagedEntityInfo"] = reflect.TypeOf((*ExtManagedEntityInfo)(nil)).Elem()
}

type ExtSolutionManagerInfo struct {
	DynamicData

	Tab          []ExtSolutionManagerInfoTabInfo `xml:"tab,omitempty"`
	SmallIconUrl string                          `xml:"smallIconUrl,omitempty"`
}

func init() {
	t["ExtSolutionManagerInfo"] = reflect.TypeOf((*ExtSolutionManagerInfo)(nil)).Elem()
}

type ExtSolutionManagerInfoTabInfo struct {
	DynamicData

	Label string `xml:"label"`
	Url   string `xml:"url"`
}

func init() {
	t["ExtSolutionManagerInfoTabInfo"] = reflect.TypeOf((*ExtSolutionManagerInfoTabInfo)(nil)).Elem()
}

type ExtendVffs ExtendVffsRequestType

func init() {
	t["ExtendVffs"] = reflect.TypeOf((*ExtendVffs)(nil)).Elem()
}

type ExtendVffsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	VffsPath   string                 `xml:"vffsPath"`
	DevicePath string                 `xml:"devicePath"`
	Spec       *HostDiskPartitionSpec `xml:"spec,omitempty"`
}

func init() {
	t["ExtendVffsRequestType"] = reflect.TypeOf((*ExtendVffsRequestType)(nil)).Elem()
}

type ExtendVffsResponse struct {
}

type ExtendVirtualDiskRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Name          string                  `xml:"name"`
	Datacenter    *ManagedObjectReference `xml:"datacenter,omitempty"`
	NewCapacityKb int64                   `xml:"newCapacityKb"`
	EagerZero     *bool                   `xml:"eagerZero"`
}

func init() {
	t["ExtendVirtualDiskRequestType"] = reflect.TypeOf((*ExtendVirtualDiskRequestType)(nil)).Elem()
}

type ExtendVirtualDisk_Task ExtendVirtualDiskRequestType

func init() {
	t["ExtendVirtualDisk_Task"] = reflect.TypeOf((*ExtendVirtualDisk_Task)(nil)).Elem()
}

type ExtendVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtendVmfsDatastore ExtendVmfsDatastoreRequestType

func init() {
	t["ExtendVmfsDatastore"] = reflect.TypeOf((*ExtendVmfsDatastore)(nil)).Elem()
}

type ExtendVmfsDatastoreRequestType struct {
	This      ManagedObjectReference  `xml:"_this"`
	Datastore ManagedObjectReference  `xml:"datastore"`
	Spec      VmfsDatastoreExtendSpec `xml:"spec"`
}

func init() {
	t["ExtendVmfsDatastoreRequestType"] = reflect.TypeOf((*ExtendVmfsDatastoreRequestType)(nil)).Elem()
}

type ExtendVmfsDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtendedDescription struct {
	Description

	MessageCatalogKeyPrefix string        `xml:"messageCatalogKeyPrefix"`
	MessageArg              []KeyAnyValue `xml:"messageArg,omitempty"`
}

func init() {
	t["ExtendedDescription"] = reflect.TypeOf((*ExtendedDescription)(nil)).Elem()
}

type ExtendedElementDescription struct {
	ElementDescription

	MessageCatalogKeyPrefix string        `xml:"messageCatalogKeyPrefix"`
	MessageArg              []KeyAnyValue `xml:"messageArg,omitempty"`
}

func init() {
	t["ExtendedElementDescription"] = reflect.TypeOf((*ExtendedElementDescription)(nil)).Elem()
}

type ExtendedEvent struct {
	GeneralEvent

	EventTypeId   string                 `xml:"eventTypeId"`
	ManagedObject ManagedObjectReference `xml:"managedObject"`
	Data          []ExtendedEventPair    `xml:"data,omitempty"`
}

func init() {
	t["ExtendedEvent"] = reflect.TypeOf((*ExtendedEvent)(nil)).Elem()
}

type ExtendedEventPair struct {
	DynamicData

	Key   string `xml:"key"`
	Value string `xml:"value"`
}

func init() {
	t["ExtendedEventPair"] = reflect.TypeOf((*ExtendedEventPair)(nil)).Elem()
}

type ExtendedFault struct {
	VimFault

	FaultTypeId string     `xml:"faultTypeId"`
	Data        []KeyValue `xml:"data,omitempty"`
}

func init() {
	t["ExtendedFault"] = reflect.TypeOf((*ExtendedFault)(nil)).Elem()
}

type ExtendedFaultFault ExtendedFault

func init() {
	t["ExtendedFaultFault"] = reflect.TypeOf((*ExtendedFaultFault)(nil)).Elem()
}

type Extension struct {
	DynamicData

	Description            BaseDescription           `xml:"description,typeattr"`
	Key                    string                    `xml:"key"`
	Company                string                    `xml:"company,omitempty"`
	Type                   string                    `xml:"type,omitempty"`
	Version                string                    `xml:"version"`
	SubjectName            string                    `xml:"subjectName,omitempty"`
	Server                 []ExtensionServerInfo     `xml:"server,omitempty"`
	Client                 []ExtensionClientInfo     `xml:"client,omitempty"`
	TaskList               []ExtensionTaskTypeInfo   `xml:"taskList,omitempty"`
	EventList              []ExtensionEventTypeInfo  `xml:"eventList,omitempty"`
	FaultList              []ExtensionFaultTypeInfo  `xml:"faultList,omitempty"`
	PrivilegeList          []ExtensionPrivilegeInfo  `xml:"privilegeList,omitempty"`
	ResourceList           []ExtensionResourceInfo   `xml:"resourceList,omitempty"`
	LastHeartbeatTime      time.Time                 `xml:"lastHeartbeatTime"`
	HealthInfo             *ExtensionHealthInfo      `xml:"healthInfo,omitempty"`
	OvfConsumerInfo        *ExtensionOvfConsumerInfo `xml:"ovfConsumerInfo,omitempty"`
	ExtendedProductInfo    *ExtExtendedProductInfo   `xml:"extendedProductInfo,omitempty"`
	ManagedEntityInfo      []ExtManagedEntityInfo    `xml:"managedEntityInfo,omitempty"`
	ShownInSolutionManager *bool                     `xml:"shownInSolutionManager"`
	SolutionManagerInfo    *ExtSolutionManagerInfo   `xml:"solutionManagerInfo,omitempty"`
}

func init() {
	t["Extension"] = reflect.TypeOf((*Extension)(nil)).Elem()
}

type ExtensionClientInfo struct {
	DynamicData

	Version     string          `xml:"version"`
	Description BaseDescription `xml:"description,typeattr"`
	Company     string          `xml:"company"`
	Type        string          `xml:"type"`
	Url         string          `xml:"url"`
}

func init() {
	t["ExtensionClientInfo"] = reflect.TypeOf((*ExtensionClientInfo)(nil)).Elem()
}

type ExtensionEventTypeInfo struct {
	DynamicData

	EventID         string `xml:"eventID"`
	EventTypeSchema string `xml:"eventTypeSchema,omitempty"`
}

func init() {
	t["ExtensionEventTypeInfo"] = reflect.TypeOf((*ExtensionEventTypeInfo)(nil)).Elem()
}

type ExtensionFaultTypeInfo struct {
	DynamicData

	FaultID string `xml:"faultID"`
}

func init() {
	t["ExtensionFaultTypeInfo"] = reflect.TypeOf((*ExtensionFaultTypeInfo)(nil)).Elem()
}

type ExtensionHealthInfo struct {
	DynamicData

	Url string `xml:"url"`
}

func init() {
	t["ExtensionHealthInfo"] = reflect.TypeOf((*ExtensionHealthInfo)(nil)).Elem()
}

type ExtensionManagerIpAllocationUsage struct {
	DynamicData

	ExtensionKey string `xml:"extensionKey"`
	NumAddresses int    `xml:"numAddresses"`
}

func init() {
	t["ExtensionManagerIpAllocationUsage"] = reflect.TypeOf((*ExtensionManagerIpAllocationUsage)(nil)).Elem()
}

type ExtensionOvfConsumerInfo struct {
	DynamicData

	CallbackUrl string   `xml:"callbackUrl"`
	SectionType []string `xml:"sectionType"`
}

func init() {
	t["ExtensionOvfConsumerInfo"] = reflect.TypeOf((*ExtensionOvfConsumerInfo)(nil)).Elem()
}

type ExtensionPrivilegeInfo struct {
	DynamicData

	PrivID        string `xml:"privID"`
	PrivGroupName string `xml:"privGroupName"`
}

func init() {
	t["ExtensionPrivilegeInfo"] = reflect.TypeOf((*ExtensionPrivilegeInfo)(nil)).Elem()
}

type ExtensionResourceInfo struct {
	DynamicData

	Locale string     `xml:"locale"`
	Module string     `xml:"module"`
	Data   []KeyValue `xml:"data"`
}

func init() {
	t["ExtensionResourceInfo"] = reflect.TypeOf((*ExtensionResourceInfo)(nil)).Elem()
}

type ExtensionServerInfo struct {
	DynamicData

	Url              string          `xml:"url"`
	Description      BaseDescription `xml:"description,typeattr"`
	Company          string          `xml:"company"`
	Type             string          `xml:"type"`
	AdminEmail       []string        `xml:"adminEmail"`
	ServerThumbprint string          `xml:"serverThumbprint,omitempty"`
}

func init() {
	t["ExtensionServerInfo"] = reflect.TypeOf((*ExtensionServerInfo)(nil)).Elem()
}

type ExtensionTaskTypeInfo struct {
	DynamicData

	TaskID string `xml:"taskID"`
}

func init() {
	t["ExtensionTaskTypeInfo"] = reflect.TypeOf((*ExtensionTaskTypeInfo)(nil)).Elem()
}

type ExtractOvfEnvironment ExtractOvfEnvironmentRequestType

func init() {
	t["ExtractOvfEnvironment"] = reflect.TypeOf((*ExtractOvfEnvironment)(nil)).Elem()
}

type ExtractOvfEnvironmentRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExtractOvfEnvironmentRequestType"] = reflect.TypeOf((*ExtractOvfEnvironmentRequestType)(nil)).Elem()
}

type ExtractOvfEnvironmentResponse struct {
	Returnval string `xml:"returnval"`
}

type FailToEnableSPBM struct {
	NotEnoughLicenses

	Cs                ManagedObjectReference               `xml:"cs"`
	CsName            string                               `xml:"csName"`
	HostLicenseStates []ComputeResourceHostSPBMLicenseInfo `xml:"hostLicenseStates"`
}

func init() {
	t["FailToEnableSPBM"] = reflect.TypeOf((*FailToEnableSPBM)(nil)).Elem()
}

type FailToEnableSPBMFault FailToEnableSPBM

func init() {
	t["FailToEnableSPBMFault"] = reflect.TypeOf((*FailToEnableSPBMFault)(nil)).Elem()
}

type FailToLockFaultToleranceVMs struct {
	RuntimeFault

	VmName          string                 `xml:"vmName"`
	Vm              ManagedObjectReference `xml:"vm"`
	AlreadyLockedVm ManagedObjectReference `xml:"alreadyLockedVm"`
}

func init() {
	t["FailToLockFaultToleranceVMs"] = reflect.TypeOf((*FailToLockFaultToleranceVMs)(nil)).Elem()
}

type FailToLockFaultToleranceVMsFault FailToLockFaultToleranceVMs

func init() {
	t["FailToLockFaultToleranceVMsFault"] = reflect.TypeOf((*FailToLockFaultToleranceVMsFault)(nil)).Elem()
}

type FailoverLevelRestored struct {
	ClusterEvent
}

func init() {
	t["FailoverLevelRestored"] = reflect.TypeOf((*FailoverLevelRestored)(nil)).Elem()
}

type FaultToleranceAntiAffinityViolated struct {
	MigrationFault

	HostName string                 `xml:"hostName"`
	Host     ManagedObjectReference `xml:"host"`
}

func init() {
	t["FaultToleranceAntiAffinityViolated"] = reflect.TypeOf((*FaultToleranceAntiAffinityViolated)(nil)).Elem()
}

type FaultToleranceAntiAffinityViolatedFault FaultToleranceAntiAffinityViolated

func init() {
	t["FaultToleranceAntiAffinityViolatedFault"] = reflect.TypeOf((*FaultToleranceAntiAffinityViolatedFault)(nil)).Elem()
}

type FaultToleranceCannotEditMem struct {
	VmConfigFault

	VmName string                 `xml:"vmName"`
	Vm     ManagedObjectReference `xml:"vm"`
}

func init() {
	t["FaultToleranceCannotEditMem"] = reflect.TypeOf((*FaultToleranceCannotEditMem)(nil)).Elem()
}

type FaultToleranceCannotEditMemFault FaultToleranceCannotEditMem

func init() {
	t["FaultToleranceCannotEditMemFault"] = reflect.TypeOf((*FaultToleranceCannotEditMemFault)(nil)).Elem()
}

type FaultToleranceConfigInfo struct {
	DynamicData

	Role          int      `xml:"role"`
	InstanceUuids []string `xml:"instanceUuids"`
	ConfigPaths   []string `xml:"configPaths"`
}

func init() {
	t["FaultToleranceConfigInfo"] = reflect.TypeOf((*FaultToleranceConfigInfo)(nil)).Elem()
}

type FaultToleranceCpuIncompatible struct {
	CpuIncompatible

	Model    bool `xml:"model"`
	Family   bool `xml:"family"`
	Stepping bool `xml:"stepping"`
}

func init() {
	t["FaultToleranceCpuIncompatible"] = reflect.TypeOf((*FaultToleranceCpuIncompatible)(nil)).Elem()
}

type FaultToleranceCpuIncompatibleFault FaultToleranceCpuIncompatible

func init() {
	t["FaultToleranceCpuIncompatibleFault"] = reflect.TypeOf((*FaultToleranceCpuIncompatibleFault)(nil)).Elem()
}

type FaultToleranceNeedsThickDisk struct {
	MigrationFault

	VmName string `xml:"vmName"`
}

func init() {
	t["FaultToleranceNeedsThickDisk"] = reflect.TypeOf((*FaultToleranceNeedsThickDisk)(nil)).Elem()
}

type FaultToleranceNeedsThickDiskFault FaultToleranceNeedsThickDisk

func init() {
	t["FaultToleranceNeedsThickDiskFault"] = reflect.TypeOf((*FaultToleranceNeedsThickDiskFault)(nil)).Elem()
}

type FaultToleranceNotLicensed struct {
	VmFaultToleranceIssue

	HostName string `xml:"hostName,omitempty"`
}

func init() {
	t["FaultToleranceNotLicensed"] = reflect.TypeOf((*FaultToleranceNotLicensed)(nil)).Elem()
}

type FaultToleranceNotLicensedFault FaultToleranceNotLicensed

func init() {
	t["FaultToleranceNotLicensedFault"] = reflect.TypeOf((*FaultToleranceNotLicensedFault)(nil)).Elem()
}

type FaultToleranceNotSameBuild struct {
	MigrationFault

	Build string `xml:"build"`
}

func init() {
	t["FaultToleranceNotSameBuild"] = reflect.TypeOf((*FaultToleranceNotSameBuild)(nil)).Elem()
}

type FaultToleranceNotSameBuildFault FaultToleranceNotSameBuild

func init() {
	t["FaultToleranceNotSameBuildFault"] = reflect.TypeOf((*FaultToleranceNotSameBuildFault)(nil)).Elem()
}

type FaultTolerancePrimaryConfigInfo struct {
	FaultToleranceConfigInfo

	Secondaries []ManagedObjectReference `xml:"secondaries"`
}

func init() {
	t["FaultTolerancePrimaryConfigInfo"] = reflect.TypeOf((*FaultTolerancePrimaryConfigInfo)(nil)).Elem()
}

type FaultTolerancePrimaryPowerOnNotAttempted struct {
	VmFaultToleranceIssue

	SecondaryVm ManagedObjectReference `xml:"secondaryVm"`
	PrimaryVm   ManagedObjectReference `xml:"primaryVm"`
}

func init() {
	t["FaultTolerancePrimaryPowerOnNotAttempted"] = reflect.TypeOf((*FaultTolerancePrimaryPowerOnNotAttempted)(nil)).Elem()
}

type FaultTolerancePrimaryPowerOnNotAttemptedFault FaultTolerancePrimaryPowerOnNotAttempted

func init() {
	t["FaultTolerancePrimaryPowerOnNotAttemptedFault"] = reflect.TypeOf((*FaultTolerancePrimaryPowerOnNotAttemptedFault)(nil)).Elem()
}

type FaultToleranceSecondaryConfigInfo struct {
	FaultToleranceConfigInfo

	PrimaryVM ManagedObjectReference `xml:"primaryVM"`
}

func init() {
	t["FaultToleranceSecondaryConfigInfo"] = reflect.TypeOf((*FaultToleranceSecondaryConfigInfo)(nil)).Elem()
}

type FaultToleranceSecondaryOpResult struct {
	DynamicData

	Vm               ManagedObjectReference  `xml:"vm"`
	PowerOnAttempted bool                    `xml:"powerOnAttempted"`
	PowerOnResult    *ClusterPowerOnVmResult `xml:"powerOnResult,omitempty"`
}

func init() {
	t["FaultToleranceSecondaryOpResult"] = reflect.TypeOf((*FaultToleranceSecondaryOpResult)(nil)).Elem()
}

type FaultToleranceVmNotDasProtected struct {
	VimFault

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["FaultToleranceVmNotDasProtected"] = reflect.TypeOf((*FaultToleranceVmNotDasProtected)(nil)).Elem()
}

type FaultToleranceVmNotDasProtectedFault FaultToleranceVmNotDasProtected

func init() {
	t["FaultToleranceVmNotDasProtectedFault"] = reflect.TypeOf((*FaultToleranceVmNotDasProtectedFault)(nil)).Elem()
}

type FcoeConfig struct {
	DynamicData

	PriorityClass int                        `xml:"priorityClass"`
	SourceMac     string                     `xml:"sourceMac"`
	VlanRange     []FcoeConfigVlanRange      `xml:"vlanRange"`
	Capabilities  FcoeConfigFcoeCapabilities `xml:"capabilities"`
	FcoeActive    bool                       `xml:"fcoeActive"`
}

func init() {
	t["FcoeConfig"] = reflect.TypeOf((*FcoeConfig)(nil)).Elem()
}

type FcoeConfigFcoeCapabilities struct {
	DynamicData

	PriorityClass    bool `xml:"priorityClass"`
	SourceMacAddress bool `xml:"sourceMacAddress"`
	VlanRange        bool `xml:"vlanRange"`
}

func init() {
	t["FcoeConfigFcoeCapabilities"] = reflect.TypeOf((*FcoeConfigFcoeCapabilities)(nil)).Elem()
}

type FcoeConfigFcoeSpecification struct {
	DynamicData

	UnderlyingPnic string                `xml:"underlyingPnic"`
	PriorityClass  int                   `xml:"priorityClass,omitempty"`
	SourceMac      string                `xml:"sourceMac,omitempty"`
	VlanRange      []FcoeConfigVlanRange `xml:"vlanRange,omitempty"`
}

func init() {
	t["FcoeConfigFcoeSpecification"] = reflect.TypeOf((*FcoeConfigFcoeSpecification)(nil)).Elem()
}

type FcoeConfigVlanRange struct {
	DynamicData

	VlanLow  int `xml:"vlanLow"`
	VlanHigh int `xml:"vlanHigh"`
}

func init() {
	t["FcoeConfigVlanRange"] = reflect.TypeOf((*FcoeConfigVlanRange)(nil)).Elem()
}

type FcoeFault struct {
	VimFault
}

func init() {
	t["FcoeFault"] = reflect.TypeOf((*FcoeFault)(nil)).Elem()
}

type FcoeFaultFault BaseFcoeFault

func init() {
	t["FcoeFaultFault"] = reflect.TypeOf((*FcoeFaultFault)(nil)).Elem()
}

type FcoeFaultPnicHasNoPortSet struct {
	FcoeFault

	NicDevice string `xml:"nicDevice"`
}

func init() {
	t["FcoeFaultPnicHasNoPortSet"] = reflect.TypeOf((*FcoeFaultPnicHasNoPortSet)(nil)).Elem()
}

type FcoeFaultPnicHasNoPortSetFault FcoeFaultPnicHasNoPortSet

func init() {
	t["FcoeFaultPnicHasNoPortSetFault"] = reflect.TypeOf((*FcoeFaultPnicHasNoPortSetFault)(nil)).Elem()
}

type FeatureRequirementsNotMet struct {
	VirtualHardwareCompatibilityIssue

	FeatureRequirement []VirtualMachineFeatureRequirement `xml:"featureRequirement,omitempty"`
	Vm                 *ManagedObjectReference            `xml:"vm,omitempty"`
	Host               *ManagedObjectReference            `xml:"host,omitempty"`
}

func init() {
	t["FeatureRequirementsNotMet"] = reflect.TypeOf((*FeatureRequirementsNotMet)(nil)).Elem()
}

type FeatureRequirementsNotMetFault FeatureRequirementsNotMet

func init() {
	t["FeatureRequirementsNotMetFault"] = reflect.TypeOf((*FeatureRequirementsNotMetFault)(nil)).Elem()
}

type FetchDVPortKeys FetchDVPortKeysRequestType

func init() {
	t["FetchDVPortKeys"] = reflect.TypeOf((*FetchDVPortKeys)(nil)).Elem()
}

type FetchDVPortKeysRequestType struct {
	This     ManagedObjectReference                `xml:"_this"`
	Criteria *DistributedVirtualSwitchPortCriteria `xml:"criteria,omitempty"`
}

func init() {
	t["FetchDVPortKeysRequestType"] = reflect.TypeOf((*FetchDVPortKeysRequestType)(nil)).Elem()
}

type FetchDVPortKeysResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type FetchDVPorts FetchDVPortsRequestType

func init() {
	t["FetchDVPorts"] = reflect.TypeOf((*FetchDVPorts)(nil)).Elem()
}

type FetchDVPortsRequestType struct {
	This     ManagedObjectReference                `xml:"_this"`
	Criteria *DistributedVirtualSwitchPortCriteria `xml:"criteria,omitempty"`
}

func init() {
	t["FetchDVPortsRequestType"] = reflect.TypeOf((*FetchDVPortsRequestType)(nil)).Elem()
}

type FetchDVPortsResponse struct {
	Returnval []DistributedVirtualPort `xml:"returnval,omitempty"`
}

type FileAlreadyExists struct {
	FileFault
}

func init() {
	t["FileAlreadyExists"] = reflect.TypeOf((*FileAlreadyExists)(nil)).Elem()
}

type FileAlreadyExistsFault FileAlreadyExists

func init() {
	t["FileAlreadyExistsFault"] = reflect.TypeOf((*FileAlreadyExistsFault)(nil)).Elem()
}

type FileBackedPortNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["FileBackedPortNotSupported"] = reflect.TypeOf((*FileBackedPortNotSupported)(nil)).Elem()
}

type FileBackedPortNotSupportedFault FileBackedPortNotSupported

func init() {
	t["FileBackedPortNotSupportedFault"] = reflect.TypeOf((*FileBackedPortNotSupportedFault)(nil)).Elem()
}

type FileBackedVirtualDiskSpec struct {
	VirtualDiskSpec

	CapacityKb int64                           `xml:"capacityKb"`
	Profile    []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr"`
}

func init() {
	t["FileBackedVirtualDiskSpec"] = reflect.TypeOf((*FileBackedVirtualDiskSpec)(nil)).Elem()
}

type FileFault struct {
	VimFault

	File string `xml:"file"`
}

func init() {
	t["FileFault"] = reflect.TypeOf((*FileFault)(nil)).Elem()
}

type FileFaultFault BaseFileFault

func init() {
	t["FileFaultFault"] = reflect.TypeOf((*FileFaultFault)(nil)).Elem()
}

type FileInfo struct {
	DynamicData

	Path         string     `xml:"path"`
	FileSize     int64      `xml:"fileSize,omitempty"`
	Modification *time.Time `xml:"modification"`
	Owner        string     `xml:"owner,omitempty"`
}

func init() {
	t["FileInfo"] = reflect.TypeOf((*FileInfo)(nil)).Elem()
}

type FileLocked struct {
	FileFault
}

func init() {
	t["FileLocked"] = reflect.TypeOf((*FileLocked)(nil)).Elem()
}

type FileLockedFault FileLocked

func init() {
	t["FileLockedFault"] = reflect.TypeOf((*FileLockedFault)(nil)).Elem()
}

type FileNameTooLong struct {
	FileFault
}

func init() {
	t["FileNameTooLong"] = reflect.TypeOf((*FileNameTooLong)(nil)).Elem()
}

type FileNameTooLongFault FileNameTooLong

func init() {
	t["FileNameTooLongFault"] = reflect.TypeOf((*FileNameTooLongFault)(nil)).Elem()
}

type FileNotFound struct {
	FileFault
}

func init() {
	t["FileNotFound"] = reflect.TypeOf((*FileNotFound)(nil)).Elem()
}

type FileNotFoundFault FileNotFound

func init() {
	t["FileNotFoundFault"] = reflect.TypeOf((*FileNotFoundFault)(nil)).Elem()
}

type FileNotWritable struct {
	FileFault
}

func init() {
	t["FileNotWritable"] = reflect.TypeOf((*FileNotWritable)(nil)).Elem()
}

type FileNotWritableFault FileNotWritable

func init() {
	t["FileNotWritableFault"] = reflect.TypeOf((*FileNotWritableFault)(nil)).Elem()
}

type FileQuery struct {
	DynamicData
}

func init() {
	t["FileQuery"] = reflect.TypeOf((*FileQuery)(nil)).Elem()
}

type FileQueryFlags struct {
	DynamicData

	FileType     bool  `xml:"fileType"`
	FileSize     bool  `xml:"fileSize"`
	Modification bool  `xml:"modification"`
	FileOwner    *bool `xml:"fileOwner"`
}

func init() {
	t["FileQueryFlags"] = reflect.TypeOf((*FileQueryFlags)(nil)).Elem()
}

type FileTooLarge struct {
	FileFault

	Datastore   string `xml:"datastore"`
	FileSize    int64  `xml:"fileSize"`
	MaxFileSize int64  `xml:"maxFileSize,omitempty"`
}

func init() {
	t["FileTooLarge"] = reflect.TypeOf((*FileTooLarge)(nil)).Elem()
}

type FileTooLargeFault FileTooLarge

func init() {
	t["FileTooLargeFault"] = reflect.TypeOf((*FileTooLargeFault)(nil)).Elem()
}

type FileTransferInformation struct {
	DynamicData

	Attributes BaseGuestFileAttributes `xml:"attributes,typeattr"`
	Size       int64                   `xml:"size"`
	Url        string                  `xml:"url"`
}

func init() {
	t["FileTransferInformation"] = reflect.TypeOf((*FileTransferInformation)(nil)).Elem()
}

type FilesystemQuiesceFault struct {
	SnapshotFault
}

func init() {
	t["FilesystemQuiesceFault"] = reflect.TypeOf((*FilesystemQuiesceFault)(nil)).Elem()
}

type FilesystemQuiesceFaultFault FilesystemQuiesceFault

func init() {
	t["FilesystemQuiesceFaultFault"] = reflect.TypeOf((*FilesystemQuiesceFaultFault)(nil)).Elem()
}

type FindAllByDnsName FindAllByDnsNameRequestType

func init() {
	t["FindAllByDnsName"] = reflect.TypeOf((*FindAllByDnsName)(nil)).Elem()
}

type FindAllByDnsNameRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	DnsName    string                  `xml:"dnsName"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindAllByDnsNameRequestType"] = reflect.TypeOf((*FindAllByDnsNameRequestType)(nil)).Elem()
}

type FindAllByDnsNameResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval"`
}

type FindAllByIp FindAllByIpRequestType

func init() {
	t["FindAllByIp"] = reflect.TypeOf((*FindAllByIp)(nil)).Elem()
}

type FindAllByIpRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Ip         string                  `xml:"ip"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindAllByIpRequestType"] = reflect.TypeOf((*FindAllByIpRequestType)(nil)).Elem()
}

type FindAllByIpResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval"`
}

type FindAllByUuid FindAllByUuidRequestType

func init() {
	t["FindAllByUuid"] = reflect.TypeOf((*FindAllByUuid)(nil)).Elem()
}

type FindAllByUuidRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Datacenter   *ManagedObjectReference `xml:"datacenter,omitempty"`
	Uuid         string                  `xml:"uuid"`
	VmSearch     bool                    `xml:"vmSearch"`
	InstanceUuid *bool                   `xml:"instanceUuid"`
}

func init() {
	t["FindAllByUuidRequestType"] = reflect.TypeOf((*FindAllByUuidRequestType)(nil)).Elem()
}

type FindAllByUuidResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval"`
}

type FindAssociatedProfile FindAssociatedProfileRequestType

func init() {
	t["FindAssociatedProfile"] = reflect.TypeOf((*FindAssociatedProfile)(nil)).Elem()
}

type FindAssociatedProfileRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["FindAssociatedProfileRequestType"] = reflect.TypeOf((*FindAssociatedProfileRequestType)(nil)).Elem()
}

type FindAssociatedProfileResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByDatastorePath FindByDatastorePathRequestType

func init() {
	t["FindByDatastorePath"] = reflect.TypeOf((*FindByDatastorePath)(nil)).Elem()
}

type FindByDatastorePathRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Datacenter ManagedObjectReference `xml:"datacenter"`
	Path       string                 `xml:"path"`
}

func init() {
	t["FindByDatastorePathRequestType"] = reflect.TypeOf((*FindByDatastorePathRequestType)(nil)).Elem()
}

type FindByDatastorePathResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByDnsName FindByDnsNameRequestType

func init() {
	t["FindByDnsName"] = reflect.TypeOf((*FindByDnsName)(nil)).Elem()
}

type FindByDnsNameRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	DnsName    string                  `xml:"dnsName"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindByDnsNameRequestType"] = reflect.TypeOf((*FindByDnsNameRequestType)(nil)).Elem()
}

type FindByDnsNameResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByInventoryPath FindByInventoryPathRequestType

func init() {
	t["FindByInventoryPath"] = reflect.TypeOf((*FindByInventoryPath)(nil)).Elem()
}

type FindByInventoryPathRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	InventoryPath string                 `xml:"inventoryPath"`
}

func init() {
	t["FindByInventoryPathRequestType"] = reflect.TypeOf((*FindByInventoryPathRequestType)(nil)).Elem()
}

type FindByInventoryPathResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByIp FindByIpRequestType

func init() {
	t["FindByIp"] = reflect.TypeOf((*FindByIp)(nil)).Elem()
}

type FindByIpRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Ip         string                  `xml:"ip"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindByIpRequestType"] = reflect.TypeOf((*FindByIpRequestType)(nil)).Elem()
}

type FindByIpResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByUuid FindByUuidRequestType

func init() {
	t["FindByUuid"] = reflect.TypeOf((*FindByUuid)(nil)).Elem()
}

type FindByUuidRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Datacenter   *ManagedObjectReference `xml:"datacenter,omitempty"`
	Uuid         string                  `xml:"uuid"`
	VmSearch     bool                    `xml:"vmSearch"`
	InstanceUuid *bool                   `xml:"instanceUuid"`
}

func init() {
	t["FindByUuidRequestType"] = reflect.TypeOf((*FindByUuidRequestType)(nil)).Elem()
}

type FindByUuidResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindChild FindChildRequestType

func init() {
	t["FindChild"] = reflect.TypeOf((*FindChild)(nil)).Elem()
}

type FindChildRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Name   string                 `xml:"name"`
}

func init() {
	t["FindChildRequestType"] = reflect.TypeOf((*FindChildRequestType)(nil)).Elem()
}

type FindChildResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindExtension FindExtensionRequestType

func init() {
	t["FindExtension"] = reflect.TypeOf((*FindExtension)(nil)).Elem()
}

type FindExtensionRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
}

func init() {
	t["FindExtensionRequestType"] = reflect.TypeOf((*FindExtensionRequestType)(nil)).Elem()
}

type FindExtensionResponse struct {
	Returnval *Extension `xml:"returnval,omitempty"`
}

type FirewallProfile struct {
	ApplyProfile

	Ruleset []FirewallProfileRulesetProfile `xml:"ruleset,omitempty"`
}

func init() {
	t["FirewallProfile"] = reflect.TypeOf((*FirewallProfile)(nil)).Elem()
}

type FirewallProfileRulesetProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["FirewallProfileRulesetProfile"] = reflect.TypeOf((*FirewallProfileRulesetProfile)(nil)).Elem()
}

type FloatOption struct {
	OptionType

	Min          float32 `xml:"min"`
	Max          float32 `xml:"max"`
	DefaultValue float32 `xml:"defaultValue"`
}

func init() {
	t["FloatOption"] = reflect.TypeOf((*FloatOption)(nil)).Elem()
}

type FloppyImageFileInfo struct {
	FileInfo
}

func init() {
	t["FloppyImageFileInfo"] = reflect.TypeOf((*FloppyImageFileInfo)(nil)).Elem()
}

type FloppyImageFileQuery struct {
	FileQuery
}

func init() {
	t["FloppyImageFileQuery"] = reflect.TypeOf((*FloppyImageFileQuery)(nil)).Elem()
}

type FolderEventArgument struct {
	EntityEventArgument

	Folder ManagedObjectReference `xml:"folder"`
}

func init() {
	t["FolderEventArgument"] = reflect.TypeOf((*FolderEventArgument)(nil)).Elem()
}

type FolderFileInfo struct {
	FileInfo
}

func init() {
	t["FolderFileInfo"] = reflect.TypeOf((*FolderFileInfo)(nil)).Elem()
}

type FolderFileQuery struct {
	FileQuery
}

func init() {
	t["FolderFileQuery"] = reflect.TypeOf((*FolderFileQuery)(nil)).Elem()
}

type FormatVffs FormatVffsRequestType

func init() {
	t["FormatVffs"] = reflect.TypeOf((*FormatVffs)(nil)).Elem()
}

type FormatVffsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	CreateSpec HostVffsSpec           `xml:"createSpec"`
}

func init() {
	t["FormatVffsRequestType"] = reflect.TypeOf((*FormatVffsRequestType)(nil)).Elem()
}

type FormatVffsResponse struct {
	Returnval HostVffsVolume `xml:"returnval"`
}

type FormatVmfs FormatVmfsRequestType

func init() {
	t["FormatVmfs"] = reflect.TypeOf((*FormatVmfs)(nil)).Elem()
}

type FormatVmfsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	CreateSpec HostVmfsSpec           `xml:"createSpec"`
}

func init() {
	t["FormatVmfsRequestType"] = reflect.TypeOf((*FormatVmfsRequestType)(nil)).Elem()
}

type FormatVmfsResponse struct {
	Returnval HostVmfsVolume `xml:"returnval"`
}

type FtIssuesOnHost struct {
	VmFaultToleranceIssue

	Host     ManagedObjectReference `xml:"host"`
	HostName string                 `xml:"hostName"`
	Errors   []LocalizedMethodFault `xml:"errors,omitempty"`
}

func init() {
	t["FtIssuesOnHost"] = reflect.TypeOf((*FtIssuesOnHost)(nil)).Elem()
}

type FtIssuesOnHostFault FtIssuesOnHost

func init() {
	t["FtIssuesOnHostFault"] = reflect.TypeOf((*FtIssuesOnHostFault)(nil)).Elem()
}

type FullStorageVMotionNotSupported struct {
	MigrationFeatureNotSupported
}

func init() {
	t["FullStorageVMotionNotSupported"] = reflect.TypeOf((*FullStorageVMotionNotSupported)(nil)).Elem()
}

type FullStorageVMotionNotSupportedFault FullStorageVMotionNotSupported

func init() {
	t["FullStorageVMotionNotSupportedFault"] = reflect.TypeOf((*FullStorageVMotionNotSupportedFault)(nil)).Elem()
}

type GeneralEvent struct {
	Event

	Message string `xml:"message"`
}

func init() {
	t["GeneralEvent"] = reflect.TypeOf((*GeneralEvent)(nil)).Elem()
}

type GeneralHostErrorEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralHostErrorEvent"] = reflect.TypeOf((*GeneralHostErrorEvent)(nil)).Elem()
}

type GeneralHostInfoEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralHostInfoEvent"] = reflect.TypeOf((*GeneralHostInfoEvent)(nil)).Elem()
}

type GeneralHostWarningEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralHostWarningEvent"] = reflect.TypeOf((*GeneralHostWarningEvent)(nil)).Elem()
}

type GeneralUserEvent struct {
	GeneralEvent

	Entity *ManagedEntityEventArgument `xml:"entity,omitempty"`
}

func init() {
	t["GeneralUserEvent"] = reflect.TypeOf((*GeneralUserEvent)(nil)).Elem()
}

type GeneralVmErrorEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralVmErrorEvent"] = reflect.TypeOf((*GeneralVmErrorEvent)(nil)).Elem()
}

type GeneralVmInfoEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralVmInfoEvent"] = reflect.TypeOf((*GeneralVmInfoEvent)(nil)).Elem()
}

type GeneralVmWarningEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralVmWarningEvent"] = reflect.TypeOf((*GeneralVmWarningEvent)(nil)).Elem()
}

type GenerateConfigTaskList GenerateConfigTaskListRequestType

func init() {
	t["GenerateConfigTaskList"] = reflect.TypeOf((*GenerateConfigTaskList)(nil)).Elem()
}

type GenerateConfigTaskListRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	ConfigSpec HostConfigSpec         `xml:"configSpec"`
	Host       ManagedObjectReference `xml:"host"`
}

func init() {
	t["GenerateConfigTaskListRequestType"] = reflect.TypeOf((*GenerateConfigTaskListRequestType)(nil)).Elem()
}

type GenerateConfigTaskListResponse struct {
	Returnval HostProfileManagerConfigTaskList `xml:"returnval"`
}

type GenerateHostProfileTaskListRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	ConfigSpec HostConfigSpec         `xml:"configSpec"`
	Host       ManagedObjectReference `xml:"host"`
}

func init() {
	t["GenerateHostProfileTaskListRequestType"] = reflect.TypeOf((*GenerateHostProfileTaskListRequestType)(nil)).Elem()
}

type GenerateHostProfileTaskList_Task GenerateHostProfileTaskListRequestType

func init() {
	t["GenerateHostProfileTaskList_Task"] = reflect.TypeOf((*GenerateHostProfileTaskList_Task)(nil)).Elem()
}

type GenerateHostProfileTaskList_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type GenerateLogBundlesRequestType struct {
	This           ManagedObjectReference   `xml:"_this"`
	IncludeDefault bool                     `xml:"includeDefault"`
	Host           []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["GenerateLogBundlesRequestType"] = reflect.TypeOf((*GenerateLogBundlesRequestType)(nil)).Elem()
}

type GenerateLogBundles_Task GenerateLogBundlesRequestType

func init() {
	t["GenerateLogBundles_Task"] = reflect.TypeOf((*GenerateLogBundles_Task)(nil)).Elem()
}

type GenerateLogBundles_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type GenericDrsFault struct {
	VimFault

	HostFaults []LocalizedMethodFault `xml:"hostFaults,omitempty"`
}

func init() {
	t["GenericDrsFault"] = reflect.TypeOf((*GenericDrsFault)(nil)).Elem()
}

type GenericDrsFaultFault GenericDrsFault

func init() {
	t["GenericDrsFaultFault"] = reflect.TypeOf((*GenericDrsFaultFault)(nil)).Elem()
}

type GenericVmConfigFault struct {
	VmConfigFault

	Reason string `xml:"reason"`
}

func init() {
	t["GenericVmConfigFault"] = reflect.TypeOf((*GenericVmConfigFault)(nil)).Elem()
}

type GenericVmConfigFaultFault GenericVmConfigFault

func init() {
	t["GenericVmConfigFaultFault"] = reflect.TypeOf((*GenericVmConfigFaultFault)(nil)).Elem()
}

type GetAlarm GetAlarmRequestType

func init() {
	t["GetAlarm"] = reflect.TypeOf((*GetAlarm)(nil)).Elem()
}

type GetAlarmRequestType struct {
	This   ManagedObjectReference  `xml:"_this"`
	Entity *ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["GetAlarmRequestType"] = reflect.TypeOf((*GetAlarmRequestType)(nil)).Elem()
}

type GetAlarmResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type GetAlarmState GetAlarmStateRequestType

func init() {
	t["GetAlarmState"] = reflect.TypeOf((*GetAlarmState)(nil)).Elem()
}

type GetAlarmStateRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["GetAlarmStateRequestType"] = reflect.TypeOf((*GetAlarmStateRequestType)(nil)).Elem()
}

type GetAlarmStateResponse struct {
	Returnval []AlarmState `xml:"returnval,omitempty"`
}

type GetCustomizationSpec GetCustomizationSpecRequestType

func init() {
	t["GetCustomizationSpec"] = reflect.TypeOf((*GetCustomizationSpec)(nil)).Elem()
}

type GetCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["GetCustomizationSpecRequestType"] = reflect.TypeOf((*GetCustomizationSpecRequestType)(nil)).Elem()
}

type GetCustomizationSpecResponse struct {
	Returnval CustomizationSpecItem `xml:"returnval"`
}

type GetPublicKey GetPublicKeyRequestType

func init() {
	t["GetPublicKey"] = reflect.TypeOf((*GetPublicKey)(nil)).Elem()
}

type GetPublicKeyRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["GetPublicKeyRequestType"] = reflect.TypeOf((*GetPublicKeyRequestType)(nil)).Elem()
}

type GetPublicKeyResponse struct {
	Returnval string `xml:"returnval"`
}

type GhostDvsProxySwitchDetectedEvent struct {
	HostEvent

	SwitchUuid []string `xml:"switchUuid"`
}

func init() {
	t["GhostDvsProxySwitchDetectedEvent"] = reflect.TypeOf((*GhostDvsProxySwitchDetectedEvent)(nil)).Elem()
}

type GhostDvsProxySwitchRemovedEvent struct {
	HostEvent

	SwitchUuid []string `xml:"switchUuid"`
}

func init() {
	t["GhostDvsProxySwitchRemovedEvent"] = reflect.TypeOf((*GhostDvsProxySwitchRemovedEvent)(nil)).Elem()
}

type GlobalMessageChangedEvent struct {
	SessionEvent

	Message string `xml:"message"`
}

func init() {
	t["GlobalMessageChangedEvent"] = reflect.TypeOf((*GlobalMessageChangedEvent)(nil)).Elem()
}

type GroupAlarmAction struct {
	AlarmAction

	Action []BaseAlarmAction `xml:"action,typeattr"`
}

func init() {
	t["GroupAlarmAction"] = reflect.TypeOf((*GroupAlarmAction)(nil)).Elem()
}

type GuestAuthentication struct {
	DynamicData

	InteractiveSession bool `xml:"interactiveSession"`
}

func init() {
	t["GuestAuthentication"] = reflect.TypeOf((*GuestAuthentication)(nil)).Elem()
}

type GuestAuthenticationChallenge struct {
	GuestOperationsFault

	ServerChallenge BaseGuestAuthentication `xml:"serverChallenge,typeattr"`
	SessionID       int64                   `xml:"sessionID"`
}

func init() {
	t["GuestAuthenticationChallenge"] = reflect.TypeOf((*GuestAuthenticationChallenge)(nil)).Elem()
}

type GuestAuthenticationChallengeFault GuestAuthenticationChallenge

func init() {
	t["GuestAuthenticationChallengeFault"] = reflect.TypeOf((*GuestAuthenticationChallengeFault)(nil)).Elem()
}

type GuestComponentsOutOfDate struct {
	GuestOperationsFault
}

func init() {
	t["GuestComponentsOutOfDate"] = reflect.TypeOf((*GuestComponentsOutOfDate)(nil)).Elem()
}

type GuestComponentsOutOfDateFault GuestComponentsOutOfDate

func init() {
	t["GuestComponentsOutOfDateFault"] = reflect.TypeOf((*GuestComponentsOutOfDateFault)(nil)).Elem()
}

type GuestDiskInfo struct {
	DynamicData

	DiskPath  string `xml:"diskPath,omitempty"`
	Capacity  int64  `xml:"capacity,omitempty"`
	FreeSpace int64  `xml:"freeSpace,omitempty"`
}

func init() {
	t["GuestDiskInfo"] = reflect.TypeOf((*GuestDiskInfo)(nil)).Elem()
}

type GuestFileAttributes struct {
	DynamicData

	ModificationTime *time.Time `xml:"modificationTime"`
	AccessTime       *time.Time `xml:"accessTime"`
	SymlinkTarget    string     `xml:"symlinkTarget,omitempty"`
}

func init() {
	t["GuestFileAttributes"] = reflect.TypeOf((*GuestFileAttributes)(nil)).Elem()
}

type GuestFileInfo struct {
	DynamicData

	Path       string                  `xml:"path"`
	Type       string                  `xml:"type"`
	Size       int64                   `xml:"size"`
	Attributes BaseGuestFileAttributes `xml:"attributes,typeattr"`
}

func init() {
	t["GuestFileInfo"] = reflect.TypeOf((*GuestFileInfo)(nil)).Elem()
}

type GuestInfo struct {
	DynamicData

	ToolsStatus                     VirtualMachineToolsStatus          `xml:"toolsStatus,omitempty"`
	ToolsVersionStatus              string                             `xml:"toolsVersionStatus,omitempty"`
	ToolsVersionStatus2             string                             `xml:"toolsVersionStatus2,omitempty"`
	ToolsRunningStatus              string                             `xml:"toolsRunningStatus,omitempty"`
	ToolsVersion                    string                             `xml:"toolsVersion,omitempty"`
	GuestId                         string                             `xml:"guestId,omitempty"`
	GuestFamily                     string                             `xml:"guestFamily,omitempty"`
	GuestFullName                   string                             `xml:"guestFullName,omitempty"`
	HostName                        string                             `xml:"hostName,omitempty"`
	IpAddress                       string                             `xml:"ipAddress,omitempty"`
	Net                             []GuestNicInfo                     `xml:"net,omitempty"`
	IpStack                         []GuestStackInfo                   `xml:"ipStack,omitempty"`
	Disk                            []GuestDiskInfo                    `xml:"disk,omitempty"`
	Screen                          *GuestScreenInfo                   `xml:"screen,omitempty"`
	GuestState                      string                             `xml:"guestState"`
	AppHeartbeatStatus              string                             `xml:"appHeartbeatStatus,omitempty"`
	AppState                        string                             `xml:"appState,omitempty"`
	GuestOperationsReady            *bool                              `xml:"guestOperationsReady"`
	InteractiveGuestOperationsReady *bool                              `xml:"interactiveGuestOperationsReady"`
	GenerationInfo                  []GuestInfoNamespaceGenerationInfo `xml:"generationInfo,omitempty"`
}

func init() {
	t["GuestInfo"] = reflect.TypeOf((*GuestInfo)(nil)).Elem()
}

type GuestInfoNamespaceGenerationInfo struct {
	DynamicData

	Key          string `xml:"key"`
	GenerationNo int    `xml:"generationNo"`
}

func init() {
	t["GuestInfoNamespaceGenerationInfo"] = reflect.TypeOf((*GuestInfoNamespaceGenerationInfo)(nil)).Elem()
}

type GuestListFileInfo struct {
	DynamicData

	Files     []GuestFileInfo `xml:"files,omitempty"`
	Remaining int             `xml:"remaining"`
}

func init() {
	t["GuestListFileInfo"] = reflect.TypeOf((*GuestListFileInfo)(nil)).Elem()
}

type GuestNicInfo struct {
	DynamicData

	Network        string                `xml:"network,omitempty"`
	IpAddress      []string              `xml:"ipAddress,omitempty"`
	MacAddress     string                `xml:"macAddress,omitempty"`
	Connected      bool                  `xml:"connected"`
	DeviceConfigId int                   `xml:"deviceConfigId"`
	DnsConfig      *NetDnsConfigInfo     `xml:"dnsConfig,omitempty"`
	IpConfig       *NetIpConfigInfo      `xml:"ipConfig,omitempty"`
	NetBIOSConfig  BaseNetBIOSConfigInfo `xml:"netBIOSConfig,omitempty,typeattr"`
}

func init() {
	t["GuestNicInfo"] = reflect.TypeOf((*GuestNicInfo)(nil)).Elem()
}

type GuestOperationsFault struct {
	VimFault
}

func init() {
	t["GuestOperationsFault"] = reflect.TypeOf((*GuestOperationsFault)(nil)).Elem()
}

type GuestOperationsFaultFault BaseGuestOperationsFault

func init() {
	t["GuestOperationsFaultFault"] = reflect.TypeOf((*GuestOperationsFaultFault)(nil)).Elem()
}

type GuestOperationsUnavailable struct {
	GuestOperationsFault
}

func init() {
	t["GuestOperationsUnavailable"] = reflect.TypeOf((*GuestOperationsUnavailable)(nil)).Elem()
}

type GuestOperationsUnavailableFault GuestOperationsUnavailable

func init() {
	t["GuestOperationsUnavailableFault"] = reflect.TypeOf((*GuestOperationsUnavailableFault)(nil)).Elem()
}

type GuestOsDescriptor struct {
	DynamicData

	Id                          string          `xml:"id"`
	Family                      string          `xml:"family"`
	FullName                    string          `xml:"fullName"`
	SupportedMaxCPUs            int             `xml:"supportedMaxCPUs"`
	NumSupportedPhysicalSockets int             `xml:"numSupportedPhysicalSockets,omitempty"`
	NumSupportedCoresPerSocket  int             `xml:"numSupportedCoresPerSocket,omitempty"`
	SupportedMinMemMB           int             `xml:"supportedMinMemMB"`
	SupportedMaxMemMB           int             `xml:"supportedMaxMemMB"`
	RecommendedMemMB            int             `xml:"recommendedMemMB"`
	RecommendedColorDepth       int             `xml:"recommendedColorDepth"`
	SupportedDiskControllerList []string        `xml:"supportedDiskControllerList"`
	RecommendedSCSIController   string          `xml:"recommendedSCSIController,omitempty"`
	RecommendedDiskController   string          `xml:"recommendedDiskController"`
	SupportedNumDisks           int             `xml:"supportedNumDisks"`
	RecommendedDiskSizeMB       int             `xml:"recommendedDiskSizeMB"`
	RecommendedCdromController  string          `xml:"recommendedCdromController,omitempty"`
	SupportedEthernetCard       []string        `xml:"supportedEthernetCard"`
	RecommendedEthernetCard     string          `xml:"recommendedEthernetCard,omitempty"`
	SupportsSlaveDisk           *bool           `xml:"supportsSlaveDisk"`
	CpuFeatureMask              []HostCpuIdInfo `xml:"cpuFeatureMask,omitempty"`
	SmcRequired                 *bool           `xml:"smcRequired"`
	SupportsWakeOnLan           bool            `xml:"supportsWakeOnLan"`
	SupportsVMI                 *bool           `xml:"supportsVMI"`
	SupportsMemoryHotAdd        *bool           `xml:"supportsMemoryHotAdd"`
	SupportsCpuHotAdd           *bool           `xml:"supportsCpuHotAdd"`
	SupportsCpuHotRemove        *bool           `xml:"supportsCpuHotRemove"`
	SupportedFirmware           []string        `xml:"supportedFirmware,omitempty"`
	RecommendedFirmware         string          `xml:"recommendedFirmware,omitempty"`
	SupportedUSBControllerList  []string        `xml:"supportedUSBControllerList,omitempty"`
	RecommendedUSBController    string          `xml:"recommendedUSBController,omitempty"`
	Supports3D                  *bool           `xml:"supports3D"`
	Recommended3D               *bool           `xml:"recommended3D"`
	SmcRecommended              *bool           `xml:"smcRecommended"`
	Ich7mRecommended            *bool           `xml:"ich7mRecommended"`
	UsbRecommended              *bool           `xml:"usbRecommended"`
	SupportLevel                string          `xml:"supportLevel,omitempty"`
	SupportedForCreate          *bool           `xml:"supportedForCreate"`
	VRAMSizeInKB                *IntOption      `xml:"vRAMSizeInKB,omitempty"`
}

func init() {
	t["GuestOsDescriptor"] = reflect.TypeOf((*GuestOsDescriptor)(nil)).Elem()
}

type GuestPermissionDenied struct {
	GuestOperationsFault
}

func init() {
	t["GuestPermissionDenied"] = reflect.TypeOf((*GuestPermissionDenied)(nil)).Elem()
}

type GuestPermissionDeniedFault GuestPermissionDenied

func init() {
	t["GuestPermissionDeniedFault"] = reflect.TypeOf((*GuestPermissionDeniedFault)(nil)).Elem()
}

type GuestPosixFileAttributes struct {
	GuestFileAttributes

	OwnerId     int   `xml:"ownerId,omitempty"`
	GroupId     int   `xml:"groupId,omitempty"`
	Permissions int64 `xml:"permissions,omitempty"`
}

func init() {
	t["GuestPosixFileAttributes"] = reflect.TypeOf((*GuestPosixFileAttributes)(nil)).Elem()
}

type GuestProcessInfo struct {
	DynamicData

	Name      string     `xml:"name"`
	Pid       int64      `xml:"pid"`
	Owner     string     `xml:"owner"`
	CmdLine   string     `xml:"cmdLine"`
	StartTime time.Time  `xml:"startTime"`
	EndTime   *time.Time `xml:"endTime"`
	ExitCode  int        `xml:"exitCode,omitempty"`
}

func init() {
	t["GuestProcessInfo"] = reflect.TypeOf((*GuestProcessInfo)(nil)).Elem()
}

type GuestProcessNotFound struct {
	GuestOperationsFault

	Pid int64 `xml:"pid"`
}

func init() {
	t["GuestProcessNotFound"] = reflect.TypeOf((*GuestProcessNotFound)(nil)).Elem()
}

type GuestProcessNotFoundFault GuestProcessNotFound

func init() {
	t["GuestProcessNotFoundFault"] = reflect.TypeOf((*GuestProcessNotFoundFault)(nil)).Elem()
}

type GuestProgramSpec struct {
	DynamicData

	ProgramPath      string   `xml:"programPath"`
	Arguments        string   `xml:"arguments"`
	WorkingDirectory string   `xml:"workingDirectory,omitempty"`
	EnvVariables     []string `xml:"envVariables,omitempty"`
}

func init() {
	t["GuestProgramSpec"] = reflect.TypeOf((*GuestProgramSpec)(nil)).Elem()
}

type GuestScreenInfo struct {
	DynamicData

	Width  int `xml:"width"`
	Height int `xml:"height"`
}

func init() {
	t["GuestScreenInfo"] = reflect.TypeOf((*GuestScreenInfo)(nil)).Elem()
}

type GuestStackInfo struct {
	DynamicData

	DnsConfig     *NetDnsConfigInfo     `xml:"dnsConfig,omitempty"`
	IpRouteConfig *NetIpRouteConfigInfo `xml:"ipRouteConfig,omitempty"`
	IpStackConfig []KeyValue            `xml:"ipStackConfig,omitempty"`
	DhcpConfig    *NetDhcpConfigInfo    `xml:"dhcpConfig,omitempty"`
}

func init() {
	t["GuestStackInfo"] = reflect.TypeOf((*GuestStackInfo)(nil)).Elem()
}

type GuestWindowsFileAttributes struct {
	GuestFileAttributes

	Hidden     *bool      `xml:"hidden"`
	ReadOnly   *bool      `xml:"readOnly"`
	CreateTime *time.Time `xml:"createTime"`
}

func init() {
	t["GuestWindowsFileAttributes"] = reflect.TypeOf((*GuestWindowsFileAttributes)(nil)).Elem()
}

type GuestWindowsProgramSpec struct {
	GuestProgramSpec

	StartMinimized bool `xml:"startMinimized"`
}

func init() {
	t["GuestWindowsProgramSpec"] = reflect.TypeOf((*GuestWindowsProgramSpec)(nil)).Elem()
}

type HAErrorsAtDest struct {
	MigrationFault
}

func init() {
	t["HAErrorsAtDest"] = reflect.TypeOf((*HAErrorsAtDest)(nil)).Elem()
}

type HAErrorsAtDestFault HAErrorsAtDest

func init() {
	t["HAErrorsAtDestFault"] = reflect.TypeOf((*HAErrorsAtDestFault)(nil)).Elem()
}

type HasPrivilegeOnEntities HasPrivilegeOnEntitiesRequestType

func init() {
	t["HasPrivilegeOnEntities"] = reflect.TypeOf((*HasPrivilegeOnEntities)(nil)).Elem()
}

type HasPrivilegeOnEntitiesRequestType struct {
	This      ManagedObjectReference   `xml:"_this"`
	Entity    []ManagedObjectReference `xml:"entity"`
	SessionId string                   `xml:"sessionId"`
	PrivId    []string                 `xml:"privId,omitempty"`
}

func init() {
	t["HasPrivilegeOnEntitiesRequestType"] = reflect.TypeOf((*HasPrivilegeOnEntitiesRequestType)(nil)).Elem()
}

type HasPrivilegeOnEntitiesResponse struct {
	Returnval []EntityPrivilege `xml:"returnval,omitempty"`
}

type HasPrivilegeOnEntity HasPrivilegeOnEntityRequestType

func init() {
	t["HasPrivilegeOnEntity"] = reflect.TypeOf((*HasPrivilegeOnEntity)(nil)).Elem()
}

type HasPrivilegeOnEntityRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Entity    ManagedObjectReference `xml:"entity"`
	SessionId string                 `xml:"sessionId"`
	PrivId    []string               `xml:"privId,omitempty"`
}

func init() {
	t["HasPrivilegeOnEntityRequestType"] = reflect.TypeOf((*HasPrivilegeOnEntityRequestType)(nil)).Elem()
}

type HasPrivilegeOnEntityResponse struct {
	Returnval []bool `xml:"returnval,omitempty"`
}

type HbrManagerReplicationVmInfo struct {
	DynamicData

	State        string                     `xml:"state"`
	ProgressInfo *ReplicationVmProgressInfo `xml:"progressInfo,omitempty"`
	ImageId      string                     `xml:"imageId,omitempty"`
	LastError    *LocalizedMethodFault      `xml:"lastError,omitempty"`
}

func init() {
	t["HbrManagerReplicationVmInfo"] = reflect.TypeOf((*HbrManagerReplicationVmInfo)(nil)).Elem()
}

type HealthStatusChangedEvent struct {
	Event

	ComponentId   string `xml:"componentId"`
	OldStatus     string `xml:"oldStatus"`
	NewStatus     string `xml:"newStatus"`
	ComponentName string `xml:"componentName"`
}

func init() {
	t["HealthStatusChangedEvent"] = reflect.TypeOf((*HealthStatusChangedEvent)(nil)).Elem()
}

type HealthSystemRuntime struct {
	DynamicData

	SystemHealthInfo   *HostSystemHealthInfo   `xml:"systemHealthInfo,omitempty"`
	HardwareStatusInfo *HostHardwareStatusInfo `xml:"hardwareStatusInfo,omitempty"`
}

func init() {
	t["HealthSystemRuntime"] = reflect.TypeOf((*HealthSystemRuntime)(nil)).Elem()
}

type HostAccessRestrictedToManagementServer struct {
	NotSupported

	ManagementServer string `xml:"managementServer"`
}

func init() {
	t["HostAccessRestrictedToManagementServer"] = reflect.TypeOf((*HostAccessRestrictedToManagementServer)(nil)).Elem()
}

type HostAccessRestrictedToManagementServerFault HostAccessRestrictedToManagementServer

func init() {
	t["HostAccessRestrictedToManagementServerFault"] = reflect.TypeOf((*HostAccessRestrictedToManagementServerFault)(nil)).Elem()
}

type HostAccountSpec struct {
	DynamicData

	Id          string `xml:"id"`
	Password    string `xml:"password,omitempty"`
	Description string `xml:"description,omitempty"`
}

func init() {
	t["HostAccountSpec"] = reflect.TypeOf((*HostAccountSpec)(nil)).Elem()
}

type HostActiveDirectory struct {
	DynamicData

	ChangeOperation string                   `xml:"changeOperation"`
	Spec            *HostActiveDirectorySpec `xml:"spec,omitempty"`
}

func init() {
	t["HostActiveDirectory"] = reflect.TypeOf((*HostActiveDirectory)(nil)).Elem()
}

type HostActiveDirectoryInfo struct {
	HostDirectoryStoreInfo

	JoinedDomain           string   `xml:"joinedDomain,omitempty"`
	TrustedDomain          []string `xml:"trustedDomain,omitempty"`
	DomainMembershipStatus string   `xml:"domainMembershipStatus,omitempty"`
}

func init() {
	t["HostActiveDirectoryInfo"] = reflect.TypeOf((*HostActiveDirectoryInfo)(nil)).Elem()
}

type HostActiveDirectorySpec struct {
	DynamicData

	DomainName string `xml:"domainName,omitempty"`
	UserName   string `xml:"userName,omitempty"`
	Password   string `xml:"password,omitempty"`
	CamServer  string `xml:"camServer,omitempty"`
	Thumbprint string `xml:"thumbprint,omitempty"`
}

func init() {
	t["HostActiveDirectorySpec"] = reflect.TypeOf((*HostActiveDirectorySpec)(nil)).Elem()
}

type HostAddFailedEvent struct {
	HostEvent

	Hostname string `xml:"hostname"`
}

func init() {
	t["HostAddFailedEvent"] = reflect.TypeOf((*HostAddFailedEvent)(nil)).Elem()
}

type HostAddedEvent struct {
	HostEvent
}

func init() {
	t["HostAddedEvent"] = reflect.TypeOf((*HostAddedEvent)(nil)).Elem()
}

type HostAdminDisableEvent struct {
	HostEvent
}

func init() {
	t["HostAdminDisableEvent"] = reflect.TypeOf((*HostAdminDisableEvent)(nil)).Elem()
}

type HostAdminEnableEvent struct {
	HostEvent
}

func init() {
	t["HostAdminEnableEvent"] = reflect.TypeOf((*HostAdminEnableEvent)(nil)).Elem()
}

type HostApplyProfile struct {
	ApplyProfile

	Memory           *HostMemoryProfile     `xml:"memory,omitempty"`
	Storage          *StorageProfile        `xml:"storage,omitempty"`
	Network          *NetworkProfile        `xml:"network,omitempty"`
	Datetime         *DateTimeProfile       `xml:"datetime,omitempty"`
	Firewall         *FirewallProfile       `xml:"firewall,omitempty"`
	Security         *SecurityProfile       `xml:"security,omitempty"`
	Service          []ServiceProfile       `xml:"service,omitempty"`
	Option           []OptionProfile        `xml:"option,omitempty"`
	UserAccount      []UserProfile          `xml:"userAccount,omitempty"`
	UsergroupAccount []UserGroupProfile     `xml:"usergroupAccount,omitempty"`
	Authentication   *AuthenticationProfile `xml:"authentication,omitempty"`
}

func init() {
	t["HostApplyProfile"] = reflect.TypeOf((*HostApplyProfile)(nil)).Elem()
}

type HostAuthenticationManagerInfo struct {
	DynamicData

	AuthConfig []BaseHostAuthenticationStoreInfo `xml:"authConfig,typeattr"`
}

func init() {
	t["HostAuthenticationManagerInfo"] = reflect.TypeOf((*HostAuthenticationManagerInfo)(nil)).Elem()
}

type HostAuthenticationStoreInfo struct {
	DynamicData

	Enabled bool `xml:"enabled"`
}

func init() {
	t["HostAuthenticationStoreInfo"] = reflect.TypeOf((*HostAuthenticationStoreInfo)(nil)).Elem()
}

type HostAutoStartManagerConfig struct {
	DynamicData

	Defaults  *AutoStartDefaults   `xml:"defaults,omitempty"`
	PowerInfo []AutoStartPowerInfo `xml:"powerInfo,omitempty"`
}

func init() {
	t["HostAutoStartManagerConfig"] = reflect.TypeOf((*HostAutoStartManagerConfig)(nil)).Elem()
}

type HostBIOSInfo struct {
	DynamicData

	BiosVersion string     `xml:"biosVersion,omitempty"`
	ReleaseDate *time.Time `xml:"releaseDate"`
}

func init() {
	t["HostBIOSInfo"] = reflect.TypeOf((*HostBIOSInfo)(nil)).Elem()
}

type HostBlockAdapterTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostBlockAdapterTargetTransport"] = reflect.TypeOf((*HostBlockAdapterTargetTransport)(nil)).Elem()
}

type HostBlockHba struct {
	HostHostBusAdapter
}

func init() {
	t["HostBlockHba"] = reflect.TypeOf((*HostBlockHba)(nil)).Elem()
}

type HostBootDevice struct {
	DynamicData

	Key         string `xml:"key"`
	Description string `xml:"description"`
}

func init() {
	t["HostBootDevice"] = reflect.TypeOf((*HostBootDevice)(nil)).Elem()
}

type HostBootDeviceInfo struct {
	DynamicData

	BootDevices          []HostBootDevice `xml:"bootDevices,omitempty"`
	CurrentBootDeviceKey string           `xml:"currentBootDeviceKey,omitempty"`
}

func init() {
	t["HostBootDeviceInfo"] = reflect.TypeOf((*HostBootDeviceInfo)(nil)).Elem()
}

type HostCacheConfigurationInfo struct {
	DynamicData

	Key      ManagedObjectReference `xml:"key"`
	SwapSize int64                  `xml:"swapSize"`
}

func init() {
	t["HostCacheConfigurationInfo"] = reflect.TypeOf((*HostCacheConfigurationInfo)(nil)).Elem()
}

type HostCacheConfigurationSpec struct {
	DynamicData

	Datastore ManagedObjectReference `xml:"datastore"`
	SwapSize  int64                  `xml:"swapSize"`
}

func init() {
	t["HostCacheConfigurationSpec"] = reflect.TypeOf((*HostCacheConfigurationSpec)(nil)).Elem()
}

type HostCapability struct {
	DynamicData

	RecursiveResourcePoolsSupported           bool            `xml:"recursiveResourcePoolsSupported"`
	CpuMemoryResourceConfigurationSupported   bool            `xml:"cpuMemoryResourceConfigurationSupported"`
	RebootSupported                           bool            `xml:"rebootSupported"`
	ShutdownSupported                         bool            `xml:"shutdownSupported"`
	VmotionSupported                          bool            `xml:"vmotionSupported"`
	StandbySupported                          bool            `xml:"standbySupported"`
	IpmiSupported                             *bool           `xml:"ipmiSupported"`
	MaxSupportedVMs                           int             `xml:"maxSupportedVMs,omitempty"`
	MaxRunningVMs                             int             `xml:"maxRunningVMs,omitempty"`
	MaxSupportedVcpus                         int             `xml:"maxSupportedVcpus,omitempty"`
	MaxRegisteredVMs                          int             `xml:"maxRegisteredVMs,omitempty"`
	DatastorePrincipalSupported               bool            `xml:"datastorePrincipalSupported"`
	SanSupported                              bool            `xml:"sanSupported"`
	NfsSupported                              bool            `xml:"nfsSupported"`
	IscsiSupported                            bool            `xml:"iscsiSupported"`
	VlanTaggingSupported                      bool            `xml:"vlanTaggingSupported"`
	NicTeamingSupported                       bool            `xml:"nicTeamingSupported"`
	HighGuestMemSupported                     bool            `xml:"highGuestMemSupported"`
	MaintenanceModeSupported                  bool            `xml:"maintenanceModeSupported"`
	SuspendedRelocateSupported                bool            `xml:"suspendedRelocateSupported"`
	RestrictedSnapshotRelocateSupported       bool            `xml:"restrictedSnapshotRelocateSupported"`
	PerVmSwapFiles                            bool            `xml:"perVmSwapFiles"`
	LocalSwapDatastoreSupported               bool            `xml:"localSwapDatastoreSupported"`
	UnsharedSwapVMotionSupported              bool            `xml:"unsharedSwapVMotionSupported"`
	BackgroundSnapshotsSupported              bool            `xml:"backgroundSnapshotsSupported"`
	PreAssignedPCIUnitNumbersSupported        bool            `xml:"preAssignedPCIUnitNumbersSupported"`
	ScreenshotSupported                       bool            `xml:"screenshotSupported"`
	ScaledScreenshotSupported                 bool            `xml:"scaledScreenshotSupported"`
	StorageVMotionSupported                   *bool           `xml:"storageVMotionSupported"`
	VmotionWithStorageVMotionSupported        *bool           `xml:"vmotionWithStorageVMotionSupported"`
	VmotionAcrossNetworkSupported             *bool           `xml:"vmotionAcrossNetworkSupported"`
	HbrNicSelectionSupported                  *bool           `xml:"hbrNicSelectionSupported"`
	RecordReplaySupported                     *bool           `xml:"recordReplaySupported"`
	FtSupported                               *bool           `xml:"ftSupported"`
	ReplayUnsupportedReason                   string          `xml:"replayUnsupportedReason,omitempty"`
	ReplayCompatibilityIssues                 []string        `xml:"replayCompatibilityIssues,omitempty"`
	FtCompatibilityIssues                     []string        `xml:"ftCompatibilityIssues,omitempty"`
	LoginBySSLThumbprintSupported             *bool           `xml:"loginBySSLThumbprintSupported"`
	CloneFromSnapshotSupported                *bool           `xml:"cloneFromSnapshotSupported"`
	DeltaDiskBackingsSupported                *bool           `xml:"deltaDiskBackingsSupported"`
	PerVMNetworkTrafficShapingSupported       *bool           `xml:"perVMNetworkTrafficShapingSupported"`
	TpmSupported                              *bool           `xml:"tpmSupported"`
	SupportedCpuFeature                       []HostCpuIdInfo `xml:"supportedCpuFeature,omitempty"`
	VirtualExecUsageSupported                 *bool           `xml:"virtualExecUsageSupported"`
	StorageIORMSupported                      *bool           `xml:"storageIORMSupported"`
	VmDirectPathGen2Supported                 *bool           `xml:"vmDirectPathGen2Supported"`
	VmDirectPathGen2UnsupportedReason         []string        `xml:"vmDirectPathGen2UnsupportedReason,omitempty"`
	VmDirectPathGen2UnsupportedReasonExtended string          `xml:"vmDirectPathGen2UnsupportedReasonExtended,omitempty"`
	SupportedVmfsMajorVersion                 []int           `xml:"supportedVmfsMajorVersion,omitempty"`
	VStorageCapable                           *bool           `xml:"vStorageCapable"`
	SnapshotRelayoutSupported                 *bool           `xml:"snapshotRelayoutSupported"`
	FirewallIpRulesSupported                  *bool           `xml:"firewallIpRulesSupported"`
	ServicePackageInfoSupported               *bool           `xml:"servicePackageInfoSupported"`
	MaxHostRunningVms                         int             `xml:"maxHostRunningVms,omitempty"`
	MaxHostSupportedVcpus                     int             `xml:"maxHostSupportedVcpus,omitempty"`
	VmfsDatastoreMountCapable                 *bool           `xml:"vmfsDatastoreMountCapable"`
	EightPlusHostVmfsSharedAccessSupported    *bool           `xml:"eightPlusHostVmfsSharedAccessSupported"`
	NestedHVSupported                         *bool           `xml:"nestedHVSupported"`
	VPMCSupported                             *bool           `xml:"vPMCSupported"`
	InterVMCommunicationThroughVMCISupported  *bool           `xml:"interVMCommunicationThroughVMCISupported"`
	ScheduledHardwareUpgradeSupported         *bool           `xml:"scheduledHardwareUpgradeSupported"`
	FeatureCapabilitiesSupported              *bool           `xml:"featureCapabilitiesSupported"`
	LatencySensitivitySupported               *bool           `xml:"latencySensitivitySupported"`
	StoragePolicySupported                    *bool           `xml:"storagePolicySupported"`
	Accel3dSupported                          *bool           `xml:"accel3dSupported"`
	ReliableMemoryAware                       *bool           `xml:"reliableMemoryAware"`
	MultipleNetworkStackInstanceSupported     *bool           `xml:"multipleNetworkStackInstanceSupported"`
	VsanSupported                             *bool           `xml:"vsanSupported"`
	VFlashSupported                           *bool           `xml:"vFlashSupported"`
}

func init() {
	t["HostCapability"] = reflect.TypeOf((*HostCapability)(nil)).Elem()
}

type HostCnxFailedAccountFailedEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedAccountFailedEvent"] = reflect.TypeOf((*HostCnxFailedAccountFailedEvent)(nil)).Elem()
}

type HostCnxFailedAlreadyManagedEvent struct {
	HostEvent

	ServerName string `xml:"serverName"`
}

func init() {
	t["HostCnxFailedAlreadyManagedEvent"] = reflect.TypeOf((*HostCnxFailedAlreadyManagedEvent)(nil)).Elem()
}

type HostCnxFailedBadCcagentEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedBadCcagentEvent"] = reflect.TypeOf((*HostCnxFailedBadCcagentEvent)(nil)).Elem()
}

type HostCnxFailedBadUsernameEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedBadUsernameEvent"] = reflect.TypeOf((*HostCnxFailedBadUsernameEvent)(nil)).Elem()
}

type HostCnxFailedBadVersionEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedBadVersionEvent"] = reflect.TypeOf((*HostCnxFailedBadVersionEvent)(nil)).Elem()
}

type HostCnxFailedCcagentUpgradeEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedCcagentUpgradeEvent"] = reflect.TypeOf((*HostCnxFailedCcagentUpgradeEvent)(nil)).Elem()
}

type HostCnxFailedEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedEvent"] = reflect.TypeOf((*HostCnxFailedEvent)(nil)).Elem()
}

type HostCnxFailedNetworkErrorEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNetworkErrorEvent"] = reflect.TypeOf((*HostCnxFailedNetworkErrorEvent)(nil)).Elem()
}

type HostCnxFailedNoAccessEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNoAccessEvent"] = reflect.TypeOf((*HostCnxFailedNoAccessEvent)(nil)).Elem()
}

type HostCnxFailedNoConnectionEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNoConnectionEvent"] = reflect.TypeOf((*HostCnxFailedNoConnectionEvent)(nil)).Elem()
}

type HostCnxFailedNoLicenseEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNoLicenseEvent"] = reflect.TypeOf((*HostCnxFailedNoLicenseEvent)(nil)).Elem()
}

type HostCnxFailedNotFoundEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNotFoundEvent"] = reflect.TypeOf((*HostCnxFailedNotFoundEvent)(nil)).Elem()
}

type HostCnxFailedTimeoutEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedTimeoutEvent"] = reflect.TypeOf((*HostCnxFailedTimeoutEvent)(nil)).Elem()
}

type HostCommunication struct {
	RuntimeFault
}

func init() {
	t["HostCommunication"] = reflect.TypeOf((*HostCommunication)(nil)).Elem()
}

type HostCommunicationFault BaseHostCommunication

func init() {
	t["HostCommunicationFault"] = reflect.TypeOf((*HostCommunicationFault)(nil)).Elem()
}

type HostComplianceCheckedEvent struct {
	HostEvent

	Profile ProfileEventArgument `xml:"profile"`
}

func init() {
	t["HostComplianceCheckedEvent"] = reflect.TypeOf((*HostComplianceCheckedEvent)(nil)).Elem()
}

type HostCompliantEvent struct {
	HostEvent
}

func init() {
	t["HostCompliantEvent"] = reflect.TypeOf((*HostCompliantEvent)(nil)).Elem()
}

type HostConfigAppliedEvent struct {
	HostEvent
}

func init() {
	t["HostConfigAppliedEvent"] = reflect.TypeOf((*HostConfigAppliedEvent)(nil)).Elem()
}

type HostConfigChange struct {
	DynamicData
}

func init() {
	t["HostConfigChange"] = reflect.TypeOf((*HostConfigChange)(nil)).Elem()
}

type HostConfigFailed struct {
	HostConfigFault

	Failure []LocalizedMethodFault `xml:"failure"`
}

func init() {
	t["HostConfigFailed"] = reflect.TypeOf((*HostConfigFailed)(nil)).Elem()
}

type HostConfigFailedFault HostConfigFailed

func init() {
	t["HostConfigFailedFault"] = reflect.TypeOf((*HostConfigFailedFault)(nil)).Elem()
}

type HostConfigFault struct {
	VimFault
}

func init() {
	t["HostConfigFault"] = reflect.TypeOf((*HostConfigFault)(nil)).Elem()
}

type HostConfigFaultFault BaseHostConfigFault

func init() {
	t["HostConfigFaultFault"] = reflect.TypeOf((*HostConfigFaultFault)(nil)).Elem()
}

type HostConfigInfo struct {
	DynamicData

	Host                      ManagedObjectReference               `xml:"host"`
	Product                   AboutInfo                            `xml:"product"`
	HyperThread               *HostHyperThreadScheduleInfo         `xml:"hyperThread,omitempty"`
	ConsoleReservation        *ServiceConsoleReservationInfo       `xml:"consoleReservation,omitempty"`
	VirtualMachineReservation *VirtualMachineMemoryReservationInfo `xml:"virtualMachineReservation,omitempty"`
	StorageDevice             *HostStorageDeviceInfo               `xml:"storageDevice,omitempty"`
	MultipathState            *HostMultipathStateInfo              `xml:"multipathState,omitempty"`
	FileSystemVolume          *HostFileSystemVolumeInfo            `xml:"fileSystemVolume,omitempty"`
	SystemFile                []string                             `xml:"systemFile,omitempty"`
	Network                   *HostNetworkInfo                     `xml:"network,omitempty"`
	Vmotion                   *HostVMotionInfo                     `xml:"vmotion,omitempty"`
	VirtualNicManagerInfo     *HostVirtualNicManagerInfo           `xml:"virtualNicManagerInfo,omitempty"`
	Capabilities              *HostNetCapabilities                 `xml:"capabilities,omitempty"`
	DatastoreCapabilities     *HostDatastoreSystemCapabilities     `xml:"datastoreCapabilities,omitempty"`
	OffloadCapabilities       *HostNetOffloadCapabilities          `xml:"offloadCapabilities,omitempty"`
	Service                   *HostServiceInfo                     `xml:"service,omitempty"`
	Firewall                  *HostFirewallInfo                    `xml:"firewall,omitempty"`
	AutoStart                 *HostAutoStartManagerConfig          `xml:"autoStart,omitempty"`
	ActiveDiagnosticPartition *HostDiagnosticPartition             `xml:"activeDiagnosticPartition,omitempty"`
	Option                    []BaseOptionValue                    `xml:"option,omitempty,typeattr"`
	OptionDef                 []OptionDef                          `xml:"optionDef,omitempty"`
	DatastorePrincipal        string                               `xml:"datastorePrincipal,omitempty"`
	LocalSwapDatastore        *ManagedObjectReference              `xml:"localSwapDatastore,omitempty"`
	SystemSwapConfiguration   *HostSystemSwapConfiguration         `xml:"systemSwapConfiguration,omitempty"`
	SystemResources           *HostSystemResourceInfo              `xml:"systemResources,omitempty"`
	DateTimeInfo              *HostDateTimeInfo                    `xml:"dateTimeInfo,omitempty"`
	Flags                     *HostFlagInfo                        `xml:"flags,omitempty"`
	AdminDisabled             *bool                                `xml:"adminDisabled"`
	Ipmi                      *HostIpmiInfo                        `xml:"ipmi,omitempty"`
	SslThumbprintInfo         *HostSslThumbprintInfo               `xml:"sslThumbprintInfo,omitempty"`
	SslThumbprintData         []HostSslThumbprintInfo              `xml:"sslThumbprintData,omitempty"`
	Certificate               []byte                               `xml:"certificate,omitempty"`
	PciPassthruInfo           []BaseHostPciPassthruInfo            `xml:"pciPassthruInfo,omitempty,typeattr"`
	AuthenticationManagerInfo *HostAuthenticationManagerInfo       `xml:"authenticationManagerInfo,omitempty"`
	FeatureVersion            []HostFeatureVersionInfo             `xml:"featureVersion,omitempty"`
	PowerSystemCapability     *PowerSystemCapability               `xml:"powerSystemCapability,omitempty"`
	PowerSystemInfo           *PowerSystemInfo                     `xml:"powerSystemInfo,omitempty"`
	CacheConfigurationInfo    []HostCacheConfigurationInfo         `xml:"cacheConfigurationInfo,omitempty"`
	WakeOnLanCapable          *bool                                `xml:"wakeOnLanCapable"`
	FeatureCapability         []HostFeatureCapability              `xml:"featureCapability,omitempty"`
	MaskedFeatureCapability   []HostFeatureCapability              `xml:"maskedFeatureCapability,omitempty"`
	VFlashConfigInfo          *HostVFlashManagerVFlashConfigInfo   `xml:"vFlashConfigInfo,omitempty"`
	VsanHostConfig            *VsanHostConfigInfo                  `xml:"vsanHostConfig,omitempty"`
	GraphicsInfo              []HostGraphicsInfo                   `xml:"graphicsInfo,omitempty"`
}

func init() {
	t["HostConfigInfo"] = reflect.TypeOf((*HostConfigInfo)(nil)).Elem()
}

type HostConfigManager struct {
	DynamicData

	CpuScheduler              *ManagedObjectReference `xml:"cpuScheduler,omitempty"`
	DatastoreSystem           *ManagedObjectReference `xml:"datastoreSystem,omitempty"`
	MemoryManager             *ManagedObjectReference `xml:"memoryManager,omitempty"`
	StorageSystem             *ManagedObjectReference `xml:"storageSystem,omitempty"`
	NetworkSystem             *ManagedObjectReference `xml:"networkSystem,omitempty"`
	VmotionSystem             *ManagedObjectReference `xml:"vmotionSystem,omitempty"`
	VirtualNicManager         *ManagedObjectReference `xml:"virtualNicManager,omitempty"`
	ServiceSystem             *ManagedObjectReference `xml:"serviceSystem,omitempty"`
	FirewallSystem            *ManagedObjectReference `xml:"firewallSystem,omitempty"`
	AdvancedOption            *ManagedObjectReference `xml:"advancedOption,omitempty"`
	DiagnosticSystem          *ManagedObjectReference `xml:"diagnosticSystem,omitempty"`
	AutoStartManager          *ManagedObjectReference `xml:"autoStartManager,omitempty"`
	SnmpSystem                *ManagedObjectReference `xml:"snmpSystem,omitempty"`
	DateTimeSystem            *ManagedObjectReference `xml:"dateTimeSystem,omitempty"`
	PatchManager              *ManagedObjectReference `xml:"patchManager,omitempty"`
	ImageConfigManager        *ManagedObjectReference `xml:"imageConfigManager,omitempty"`
	BootDeviceSystem          *ManagedObjectReference `xml:"bootDeviceSystem,omitempty"`
	FirmwareSystem            *ManagedObjectReference `xml:"firmwareSystem,omitempty"`
	HealthStatusSystem        *ManagedObjectReference `xml:"healthStatusSystem,omitempty"`
	PciPassthruSystem         *ManagedObjectReference `xml:"pciPassthruSystem,omitempty"`
	LicenseManager            *ManagedObjectReference `xml:"licenseManager,omitempty"`
	KernelModuleSystem        *ManagedObjectReference `xml:"kernelModuleSystem,omitempty"`
	AuthenticationManager     *ManagedObjectReference `xml:"authenticationManager,omitempty"`
	PowerSystem               *ManagedObjectReference `xml:"powerSystem,omitempty"`
	CacheConfigurationManager *ManagedObjectReference `xml:"cacheConfigurationManager,omitempty"`
	EsxAgentHostManager       *ManagedObjectReference `xml:"esxAgentHostManager,omitempty"`
	IscsiManager              *ManagedObjectReference `xml:"iscsiManager,omitempty"`
	VFlashManager             *ManagedObjectReference `xml:"vFlashManager,omitempty"`
	VsanSystem                *ManagedObjectReference `xml:"vsanSystem,omitempty"`
	GraphicsManager           *ManagedObjectReference `xml:"graphicsManager,omitempty"`
	VsanInternalSystem        *ManagedObjectReference `xml:"vsanInternalSystem,omitempty"`
}

func init() {
	t["HostConfigManager"] = reflect.TypeOf((*HostConfigManager)(nil)).Elem()
}

type HostConfigSpec struct {
	DynamicData

	NasDatastore             []HostNasVolumeConfig                   `xml:"nasDatastore,omitempty"`
	Network                  *HostNetworkConfig                      `xml:"network,omitempty"`
	NicTypeSelection         []HostVirtualNicManagerNicTypeSelection `xml:"nicTypeSelection,omitempty"`
	Service                  []HostServiceConfig                     `xml:"service,omitempty"`
	Firewall                 *HostFirewallConfig                     `xml:"firewall,omitempty"`
	Option                   []BaseOptionValue                       `xml:"option,omitempty,typeattr"`
	DatastorePrincipal       string                                  `xml:"datastorePrincipal,omitempty"`
	DatastorePrincipalPasswd string                                  `xml:"datastorePrincipalPasswd,omitempty"`
	Datetime                 *HostDateTimeConfig                     `xml:"datetime,omitempty"`
	StorageDevice            *HostStorageDeviceInfo                  `xml:"storageDevice,omitempty"`
	License                  *HostLicenseSpec                        `xml:"license,omitempty"`
	Security                 *HostSecuritySpec                       `xml:"security,omitempty"`
	UserAccount              []BaseHostAccountSpec                   `xml:"userAccount,omitempty,typeattr"`
	UsergroupAccount         []BaseHostAccountSpec                   `xml:"usergroupAccount,omitempty,typeattr"`
	Memory                   *HostMemorySpec                         `xml:"memory,omitempty"`
	ActiveDirectory          []HostActiveDirectory                   `xml:"activeDirectory,omitempty"`
	GenericConfig            []KeyAnyValue                           `xml:"genericConfig,omitempty"`
}

func init() {
	t["HostConfigSpec"] = reflect.TypeOf((*HostConfigSpec)(nil)).Elem()
}

type HostConfigSummary struct {
	DynamicData

	Name                  string                   `xml:"name"`
	Port                  int                      `xml:"port"`
	SslThumbprint         string                   `xml:"sslThumbprint,omitempty"`
	Product               *AboutInfo               `xml:"product,omitempty"`
	VmotionEnabled        bool                     `xml:"vmotionEnabled"`
	FaultToleranceEnabled *bool                    `xml:"faultToleranceEnabled"`
	FeatureVersion        []HostFeatureVersionInfo `xml:"featureVersion,omitempty"`
	AgentVmDatastore      *ManagedObjectReference  `xml:"agentVmDatastore,omitempty"`
	AgentVmNetwork        *ManagedObjectReference  `xml:"agentVmNetwork,omitempty"`
}

func init() {
	t["HostConfigSummary"] = reflect.TypeOf((*HostConfigSummary)(nil)).Elem()
}

type HostConfigVFlashCache HostConfigVFlashCacheRequestType

func init() {
	t["HostConfigVFlashCache"] = reflect.TypeOf((*HostConfigVFlashCache)(nil)).Elem()
}

type HostConfigVFlashCacheRequestType struct {
	This ManagedObjectReference                 `xml:"_this"`
	Spec HostVFlashManagerVFlashCacheConfigSpec `xml:"spec"`
}

func init() {
	t["HostConfigVFlashCacheRequestType"] = reflect.TypeOf((*HostConfigVFlashCacheRequestType)(nil)).Elem()
}

type HostConfigVFlashCacheResponse struct {
}

type HostConfigureVFlashResource HostConfigureVFlashResourceRequestType

func init() {
	t["HostConfigureVFlashResource"] = reflect.TypeOf((*HostConfigureVFlashResource)(nil)).Elem()
}

type HostConfigureVFlashResourceRequestType struct {
	This ManagedObjectReference                    `xml:"_this"`
	Spec HostVFlashManagerVFlashResourceConfigSpec `xml:"spec"`
}

func init() {
	t["HostConfigureVFlashResourceRequestType"] = reflect.TypeOf((*HostConfigureVFlashResourceRequestType)(nil)).Elem()
}

type HostConfigureVFlashResourceResponse struct {
}

type HostConnectFault struct {
	VimFault
}

func init() {
	t["HostConnectFault"] = reflect.TypeOf((*HostConnectFault)(nil)).Elem()
}

type HostConnectFaultFault BaseHostConnectFault

func init() {
	t["HostConnectFaultFault"] = reflect.TypeOf((*HostConnectFaultFault)(nil)).Elem()
}

type HostConnectInfo struct {
	DynamicData

	ServerIp               string                           `xml:"serverIp,omitempty"`
	InDasCluster           *bool                            `xml:"inDasCluster"`
	Host                   HostListSummary                  `xml:"host"`
	Vm                     []VirtualMachineSummary          `xml:"vm,omitempty"`
	VimAccountNameRequired *bool                            `xml:"vimAccountNameRequired"`
	ClusterSupported       *bool                            `xml:"clusterSupported"`
	Network                []BaseHostConnectInfoNetworkInfo `xml:"network,omitempty,typeattr"`
	Datastore              []BaseHostDatastoreConnectInfo   `xml:"datastore,omitempty,typeattr"`
	License                *HostLicenseConnectInfo          `xml:"license,omitempty"`
}

func init() {
	t["HostConnectInfo"] = reflect.TypeOf((*HostConnectInfo)(nil)).Elem()
}

type HostConnectInfoNetworkInfo struct {
	DynamicData

	Summary BaseNetworkSummary `xml:"summary,typeattr"`
}

func init() {
	t["HostConnectInfoNetworkInfo"] = reflect.TypeOf((*HostConnectInfoNetworkInfo)(nil)).Elem()
}

type HostConnectSpec struct {
	DynamicData

	HostName           string                  `xml:"hostName,omitempty"`
	Port               int                     `xml:"port,omitempty"`
	SslThumbprint      string                  `xml:"sslThumbprint,omitempty"`
	UserName           string                  `xml:"userName,omitempty"`
	Password           string                  `xml:"password,omitempty"`
	VmFolder           *ManagedObjectReference `xml:"vmFolder,omitempty"`
	Force              bool                    `xml:"force"`
	VimAccountName     string                  `xml:"vimAccountName,omitempty"`
	VimAccountPassword string                  `xml:"vimAccountPassword,omitempty"`
	ManagementIp       string                  `xml:"managementIp,omitempty"`
}

func init() {
	t["HostConnectSpec"] = reflect.TypeOf((*HostConnectSpec)(nil)).Elem()
}

type HostConnectedEvent struct {
	HostEvent
}

func init() {
	t["HostConnectedEvent"] = reflect.TypeOf((*HostConnectedEvent)(nil)).Elem()
}

type HostConnectionLostEvent struct {
	HostEvent
}

func init() {
	t["HostConnectionLostEvent"] = reflect.TypeOf((*HostConnectionLostEvent)(nil)).Elem()
}

type HostCpuIdInfo struct {
	DynamicData

	Level  int    `xml:"level"`
	Vendor string `xml:"vendor,omitempty"`
	Eax    string `xml:"eax,omitempty"`
	Ebx    string `xml:"ebx,omitempty"`
	Ecx    string `xml:"ecx,omitempty"`
	Edx    string `xml:"edx,omitempty"`
}

func init() {
	t["HostCpuIdInfo"] = reflect.TypeOf((*HostCpuIdInfo)(nil)).Elem()
}

type HostCpuInfo struct {
	DynamicData

	NumCpuPackages int16 `xml:"numCpuPackages"`
	NumCpuCores    int16 `xml:"numCpuCores"`
	NumCpuThreads  int16 `xml:"numCpuThreads"`
	Hz             int64 `xml:"hz"`
}

func init() {
	t["HostCpuInfo"] = reflect.TypeOf((*HostCpuInfo)(nil)).Elem()
}

type HostCpuPackage struct {
	DynamicData

	Index       int16           `xml:"index"`
	Vendor      string          `xml:"vendor"`
	Hz          int64           `xml:"hz"`
	BusHz       int64           `xml:"busHz"`
	Description string          `xml:"description"`
	ThreadId    []int16         `xml:"threadId"`
	CpuFeature  []HostCpuIdInfo `xml:"cpuFeature,omitempty"`
}

func init() {
	t["HostCpuPackage"] = reflect.TypeOf((*HostCpuPackage)(nil)).Elem()
}

type HostCpuPowerManagementInfo struct {
	DynamicData

	CurrentPolicy   string `xml:"currentPolicy,omitempty"`
	HardwareSupport string `xml:"hardwareSupport,omitempty"`
}

func init() {
	t["HostCpuPowerManagementInfo"] = reflect.TypeOf((*HostCpuPowerManagementInfo)(nil)).Elem()
}

type HostDasDisabledEvent struct {
	HostEvent
}

func init() {
	t["HostDasDisabledEvent"] = reflect.TypeOf((*HostDasDisabledEvent)(nil)).Elem()
}

type HostDasDisablingEvent struct {
	HostEvent
}

func init() {
	t["HostDasDisablingEvent"] = reflect.TypeOf((*HostDasDisablingEvent)(nil)).Elem()
}

type HostDasEnabledEvent struct {
	HostEvent
}

func init() {
	t["HostDasEnabledEvent"] = reflect.TypeOf((*HostDasEnabledEvent)(nil)).Elem()
}

type HostDasEnablingEvent struct {
	HostEvent
}

func init() {
	t["HostDasEnablingEvent"] = reflect.TypeOf((*HostDasEnablingEvent)(nil)).Elem()
}

type HostDasErrorEvent struct {
	HostEvent

	Message string `xml:"message,omitempty"`
	Reason  string `xml:"reason,omitempty"`
}

func init() {
	t["HostDasErrorEvent"] = reflect.TypeOf((*HostDasErrorEvent)(nil)).Elem()
}

type HostDasEvent struct {
	HostEvent
}

func init() {
	t["HostDasEvent"] = reflect.TypeOf((*HostDasEvent)(nil)).Elem()
}

type HostDasOkEvent struct {
	HostEvent
}

func init() {
	t["HostDasOkEvent"] = reflect.TypeOf((*HostDasOkEvent)(nil)).Elem()
}

type HostDatastoreBrowserSearchResults struct {
	DynamicData

	Datastore  *ManagedObjectReference `xml:"datastore,omitempty"`
	FolderPath string                  `xml:"folderPath,omitempty"`
	File       []BaseFileInfo          `xml:"file,omitempty,typeattr"`
}

func init() {
	t["HostDatastoreBrowserSearchResults"] = reflect.TypeOf((*HostDatastoreBrowserSearchResults)(nil)).Elem()
}

type HostDatastoreBrowserSearchSpec struct {
	DynamicData

	Query                 []BaseFileQuery `xml:"query,omitempty,typeattr"`
	Details               *FileQueryFlags `xml:"details,omitempty"`
	SearchCaseInsensitive *bool           `xml:"searchCaseInsensitive"`
	MatchPattern          []string        `xml:"matchPattern,omitempty"`
	SortFoldersFirst      *bool           `xml:"sortFoldersFirst"`
}

func init() {
	t["HostDatastoreBrowserSearchSpec"] = reflect.TypeOf((*HostDatastoreBrowserSearchSpec)(nil)).Elem()
}

type HostDatastoreConnectInfo struct {
	DynamicData

	Summary DatastoreSummary `xml:"summary"`
}

func init() {
	t["HostDatastoreConnectInfo"] = reflect.TypeOf((*HostDatastoreConnectInfo)(nil)).Elem()
}

type HostDatastoreExistsConnectInfo struct {
	HostDatastoreConnectInfo

	NewDatastoreName string `xml:"newDatastoreName"`
}

func init() {
	t["HostDatastoreExistsConnectInfo"] = reflect.TypeOf((*HostDatastoreExistsConnectInfo)(nil)).Elem()
}

type HostDatastoreNameConflictConnectInfo struct {
	HostDatastoreConnectInfo

	NewDatastoreName string `xml:"newDatastoreName"`
}

func init() {
	t["HostDatastoreNameConflictConnectInfo"] = reflect.TypeOf((*HostDatastoreNameConflictConnectInfo)(nil)).Elem()
}

type HostDatastoreSystemCapabilities struct {
	DynamicData

	NfsMountCreationRequired     bool  `xml:"nfsMountCreationRequired"`
	NfsMountCreationSupported    bool  `xml:"nfsMountCreationSupported"`
	LocalDatastoreSupported      bool  `xml:"localDatastoreSupported"`
	VmfsExtentExpansionSupported *bool `xml:"vmfsExtentExpansionSupported"`
}

func init() {
	t["HostDatastoreSystemCapabilities"] = reflect.TypeOf((*HostDatastoreSystemCapabilities)(nil)).Elem()
}

type HostDateTimeConfig struct {
	DynamicData

	TimeZone  string         `xml:"timeZone,omitempty"`
	NtpConfig *HostNtpConfig `xml:"ntpConfig,omitempty"`
}

func init() {
	t["HostDateTimeConfig"] = reflect.TypeOf((*HostDateTimeConfig)(nil)).Elem()
}

type HostDateTimeInfo struct {
	DynamicData

	TimeZone  HostDateTimeSystemTimeZone `xml:"timeZone"`
	NtpConfig *HostNtpConfig             `xml:"ntpConfig,omitempty"`
}

func init() {
	t["HostDateTimeInfo"] = reflect.TypeOf((*HostDateTimeInfo)(nil)).Elem()
}

type HostDateTimeSystemTimeZone struct {
	DynamicData

	Key         string `xml:"key"`
	Name        string `xml:"name"`
	Description string `xml:"description"`
	GmtOffset   int    `xml:"gmtOffset"`
}

func init() {
	t["HostDateTimeSystemTimeZone"] = reflect.TypeOf((*HostDateTimeSystemTimeZone)(nil)).Elem()
}

type HostDevice struct {
	DynamicData

	DeviceName string `xml:"deviceName"`
	DeviceType string `xml:"deviceType"`
}

func init() {
	t["HostDevice"] = reflect.TypeOf((*HostDevice)(nil)).Elem()
}

type HostDhcpService struct {
	DynamicData

	Key  string              `xml:"key"`
	Spec HostDhcpServiceSpec `xml:"spec"`
}

func init() {
	t["HostDhcpService"] = reflect.TypeOf((*HostDhcpService)(nil)).Elem()
}

type HostDhcpServiceConfig struct {
	DynamicData

	ChangeOperation string              `xml:"changeOperation,omitempty"`
	Key             string              `xml:"key"`
	Spec            HostDhcpServiceSpec `xml:"spec"`
}

func init() {
	t["HostDhcpServiceConfig"] = reflect.TypeOf((*HostDhcpServiceConfig)(nil)).Elem()
}

type HostDhcpServiceSpec struct {
	DynamicData

	VirtualSwitch        string `xml:"virtualSwitch"`
	DefaultLeaseDuration int    `xml:"defaultLeaseDuration"`
	LeaseBeginIp         string `xml:"leaseBeginIp"`
	LeaseEndIp           string `xml:"leaseEndIp"`
	MaxLeaseDuration     int    `xml:"maxLeaseDuration"`
	UnlimitedLease       bool   `xml:"unlimitedLease"`
	IpSubnetAddr         string `xml:"ipSubnetAddr"`
	IpSubnetMask         string `xml:"ipSubnetMask"`
}

func init() {
	t["HostDhcpServiceSpec"] = reflect.TypeOf((*HostDhcpServiceSpec)(nil)).Elem()
}

type HostDiagnosticPartition struct {
	DynamicData

	StorageType    string                `xml:"storageType"`
	DiagnosticType string                `xml:"diagnosticType"`
	Slots          int                   `xml:"slots"`
	Id             HostScsiDiskPartition `xml:"id"`
}

func init() {
	t["HostDiagnosticPartition"] = reflect.TypeOf((*HostDiagnosticPartition)(nil)).Elem()
}

type HostDiagnosticPartitionCreateDescription struct {
	DynamicData

	Layout   HostDiskPartitionLayout           `xml:"layout"`
	DiskUuid string                            `xml:"diskUuid"`
	Spec     HostDiagnosticPartitionCreateSpec `xml:"spec"`
}

func init() {
	t["HostDiagnosticPartitionCreateDescription"] = reflect.TypeOf((*HostDiagnosticPartitionCreateDescription)(nil)).Elem()
}

type HostDiagnosticPartitionCreateOption struct {
	DynamicData

	StorageType    string       `xml:"storageType"`
	DiagnosticType string       `xml:"diagnosticType"`
	Disk           HostScsiDisk `xml:"disk"`
}

func init() {
	t["HostDiagnosticPartitionCreateOption"] = reflect.TypeOf((*HostDiagnosticPartitionCreateOption)(nil)).Elem()
}

type HostDiagnosticPartitionCreateSpec struct {
	DynamicData

	StorageType    string                `xml:"storageType"`
	DiagnosticType string                `xml:"diagnosticType"`
	Id             HostScsiDiskPartition `xml:"id"`
	Partition      HostDiskPartitionSpec `xml:"partition"`
	Active         *bool                 `xml:"active"`
}

func init() {
	t["HostDiagnosticPartitionCreateSpec"] = reflect.TypeOf((*HostDiagnosticPartitionCreateSpec)(nil)).Elem()
}

type HostDigestInfo struct {
	DynamicData

	DigestMethod string `xml:"digestMethod"`
	DigestValue  []byte `xml:"digestValue"`
	ObjectName   string `xml:"objectName,omitempty"`
}

func init() {
	t["HostDigestInfo"] = reflect.TypeOf((*HostDigestInfo)(nil)).Elem()
}

type HostDirectoryStoreInfo struct {
	HostAuthenticationStoreInfo
}

func init() {
	t["HostDirectoryStoreInfo"] = reflect.TypeOf((*HostDirectoryStoreInfo)(nil)).Elem()
}

type HostDisconnectedEvent struct {
	HostEvent

	Reason string `xml:"reason,omitempty"`
}

func init() {
	t["HostDisconnectedEvent"] = reflect.TypeOf((*HostDisconnectedEvent)(nil)).Elem()
}

type HostDiskConfigurationResult struct {
	DynamicData

	DevicePath string                `xml:"devicePath,omitempty"`
	Success    *bool                 `xml:"success"`
	Fault      *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["HostDiskConfigurationResult"] = reflect.TypeOf((*HostDiskConfigurationResult)(nil)).Elem()
}

type HostDiskDimensions struct {
	DynamicData
}

func init() {
	t["HostDiskDimensions"] = reflect.TypeOf((*HostDiskDimensions)(nil)).Elem()
}

type HostDiskDimensionsChs struct {
	DynamicData

	Cylinder int64 `xml:"cylinder"`
	Head     int   `xml:"head"`
	Sector   int   `xml:"sector"`
}

func init() {
	t["HostDiskDimensionsChs"] = reflect.TypeOf((*HostDiskDimensionsChs)(nil)).Elem()
}

type HostDiskDimensionsLba struct {
	DynamicData

	BlockSize int   `xml:"blockSize"`
	Block     int64 `xml:"block"`
}

func init() {
	t["HostDiskDimensionsLba"] = reflect.TypeOf((*HostDiskDimensionsLba)(nil)).Elem()
}

type HostDiskMappingInfo struct {
	DynamicData

	PhysicalPartition *HostDiskMappingPartitionInfo `xml:"physicalPartition,omitempty"`
	Name              string                        `xml:"name"`
	Exclusive         *bool                         `xml:"exclusive"`
}

func init() {
	t["HostDiskMappingInfo"] = reflect.TypeOf((*HostDiskMappingInfo)(nil)).Elem()
}

type HostDiskMappingOption struct {
	DynamicData

	PhysicalPartition []HostDiskMappingPartitionOption `xml:"physicalPartition,omitempty"`
	Name              string                           `xml:"name"`
}

func init() {
	t["HostDiskMappingOption"] = reflect.TypeOf((*HostDiskMappingOption)(nil)).Elem()
}

type HostDiskMappingPartitionInfo struct {
	DynamicData

	Name         string `xml:"name"`
	FileSystem   string `xml:"fileSystem"`
	CapacityInKb int64  `xml:"capacityInKb"`
}

func init() {
	t["HostDiskMappingPartitionInfo"] = reflect.TypeOf((*HostDiskMappingPartitionInfo)(nil)).Elem()
}

type HostDiskMappingPartitionOption struct {
	DynamicData

	Name         string `xml:"name"`
	FileSystem   string `xml:"fileSystem"`
	CapacityInKb int64  `xml:"capacityInKb"`
}

func init() {
	t["HostDiskMappingPartitionOption"] = reflect.TypeOf((*HostDiskMappingPartitionOption)(nil)).Elem()
}

type HostDiskPartitionAttributes struct {
	DynamicData

	Partition          int    `xml:"partition"`
	StartSector        int64  `xml:"startSector"`
	EndSector          int64  `xml:"endSector"`
	Type               string `xml:"type"`
	Guid               string `xml:"guid,omitempty"`
	Logical            bool   `xml:"logical"`
	Attributes         byte   `xml:"attributes"`
	PartitionAlignment int64  `xml:"partitionAlignment,omitempty"`
}

func init() {
	t["HostDiskPartitionAttributes"] = reflect.TypeOf((*HostDiskPartitionAttributes)(nil)).Elem()
}

type HostDiskPartitionBlockRange struct {
	DynamicData

	Partition int                   `xml:"partition,omitempty"`
	Type      string                `xml:"type"`
	Start     HostDiskDimensionsLba `xml:"start"`
	End       HostDiskDimensionsLba `xml:"end"`
}

func init() {
	t["HostDiskPartitionBlockRange"] = reflect.TypeOf((*HostDiskPartitionBlockRange)(nil)).Elem()
}

type HostDiskPartitionInfo struct {
	DynamicData

	DeviceName string                  `xml:"deviceName"`
	Spec       HostDiskPartitionSpec   `xml:"spec"`
	Layout     HostDiskPartitionLayout `xml:"layout"`
}

func init() {
	t["HostDiskPartitionInfo"] = reflect.TypeOf((*HostDiskPartitionInfo)(nil)).Elem()
}

type HostDiskPartitionLayout struct {
	DynamicData

	Total     *HostDiskDimensionsLba        `xml:"total,omitempty"`
	Partition []HostDiskPartitionBlockRange `xml:"partition"`
}

func init() {
	t["HostDiskPartitionLayout"] = reflect.TypeOf((*HostDiskPartitionLayout)(nil)).Elem()
}

type HostDiskPartitionSpec struct {
	DynamicData

	PartitionFormat string                        `xml:"partitionFormat,omitempty"`
	Chs             *HostDiskDimensionsChs        `xml:"chs,omitempty"`
	TotalSectors    int64                         `xml:"totalSectors,omitempty"`
	Partition       []HostDiskPartitionAttributes `xml:"partition,omitempty"`
}

func init() {
	t["HostDiskPartitionSpec"] = reflect.TypeOf((*HostDiskPartitionSpec)(nil)).Elem()
}

type HostDnsConfig struct {
	DynamicData

	Dhcp             bool     `xml:"dhcp"`
	VirtualNicDevice string   `xml:"virtualNicDevice,omitempty"`
	HostName         string   `xml:"hostName"`
	DomainName       string   `xml:"domainName"`
	Address          []string `xml:"address,omitempty"`
	SearchDomain     []string `xml:"searchDomain,omitempty"`
}

func init() {
	t["HostDnsConfig"] = reflect.TypeOf((*HostDnsConfig)(nil)).Elem()
}

type HostDnsConfigSpec struct {
	HostDnsConfig

	VirtualNicConnection *HostVirtualNicConnection `xml:"virtualNicConnection,omitempty"`
}

func init() {
	t["HostDnsConfigSpec"] = reflect.TypeOf((*HostDnsConfigSpec)(nil)).Elem()
}

type HostEnableAdminFailedEvent struct {
	HostEvent

	Permissions []Permission `xml:"permissions"`
}

func init() {
	t["HostEnableAdminFailedEvent"] = reflect.TypeOf((*HostEnableAdminFailedEvent)(nil)).Elem()
}

type HostEsxAgentHostManagerConfigInfo struct {
	DynamicData

	AgentVmDatastore *ManagedObjectReference `xml:"agentVmDatastore,omitempty"`
	AgentVmNetwork   *ManagedObjectReference `xml:"agentVmNetwork,omitempty"`
}

func init() {
	t["HostEsxAgentHostManagerConfigInfo"] = reflect.TypeOf((*HostEsxAgentHostManagerConfigInfo)(nil)).Elem()
}

type HostEvent struct {
	Event
}

func init() {
	t["HostEvent"] = reflect.TypeOf((*HostEvent)(nil)).Elem()
}

type HostEventArgument struct {
	EntityEventArgument

	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["HostEventArgument"] = reflect.TypeOf((*HostEventArgument)(nil)).Elem()
}

type HostExtraNetworksEvent struct {
	HostDasEvent

	Ips string `xml:"ips,omitempty"`
}

func init() {
	t["HostExtraNetworksEvent"] = reflect.TypeOf((*HostExtraNetworksEvent)(nil)).Elem()
}

type HostFeatureCapability struct {
	DynamicData

	Key         string `xml:"key"`
	FeatureName string `xml:"featureName"`
	Value       string `xml:"value"`
}

func init() {
	t["HostFeatureCapability"] = reflect.TypeOf((*HostFeatureCapability)(nil)).Elem()
}

type HostFeatureMask struct {
	DynamicData

	Key         string `xml:"key"`
	FeatureName string `xml:"featureName"`
	Value       string `xml:"value"`
}

func init() {
	t["HostFeatureMask"] = reflect.TypeOf((*HostFeatureMask)(nil)).Elem()
}

type HostFeatureVersionInfo struct {
	DynamicData

	Key   string `xml:"key"`
	Value string `xml:"value"`
}

func init() {
	t["HostFeatureVersionInfo"] = reflect.TypeOf((*HostFeatureVersionInfo)(nil)).Elem()
}

type HostFibreChannelHba struct {
	HostHostBusAdapter

	PortWorldWideName int64                `xml:"portWorldWideName"`
	NodeWorldWideName int64                `xml:"nodeWorldWideName"`
	PortType          FibreChannelPortType `xml:"portType"`
	Speed             int64                `xml:"speed"`
}

func init() {
	t["HostFibreChannelHba"] = reflect.TypeOf((*HostFibreChannelHba)(nil)).Elem()
}

type HostFibreChannelOverEthernetHba struct {
	HostFibreChannelHba

	UnderlyingNic    string                                  `xml:"underlyingNic"`
	LinkInfo         HostFibreChannelOverEthernetHbaLinkInfo `xml:"linkInfo"`
	IsSoftwareFcoe   bool                                    `xml:"isSoftwareFcoe"`
	MarkedForRemoval bool                                    `xml:"markedForRemoval"`
}

func init() {
	t["HostFibreChannelOverEthernetHba"] = reflect.TypeOf((*HostFibreChannelOverEthernetHba)(nil)).Elem()
}

type HostFibreChannelOverEthernetHbaLinkInfo struct {
	DynamicData

	VnportMac string `xml:"vnportMac"`
	FcfMac    string `xml:"fcfMac"`
	VlanId    int    `xml:"vlanId"`
}

func init() {
	t["HostFibreChannelOverEthernetHbaLinkInfo"] = reflect.TypeOf((*HostFibreChannelOverEthernetHbaLinkInfo)(nil)).Elem()
}

type HostFibreChannelOverEthernetTargetTransport struct {
	HostFibreChannelTargetTransport

	VnportMac string `xml:"vnportMac"`
	FcfMac    string `xml:"fcfMac"`
	VlanId    int    `xml:"vlanId"`
}

func init() {
	t["HostFibreChannelOverEthernetTargetTransport"] = reflect.TypeOf((*HostFibreChannelOverEthernetTargetTransport)(nil)).Elem()
}

type HostFibreChannelTargetTransport struct {
	HostTargetTransport

	PortWorldWideName int64 `xml:"portWorldWideName"`
	NodeWorldWideName int64 `xml:"nodeWorldWideName"`
}

func init() {
	t["HostFibreChannelTargetTransport"] = reflect.TypeOf((*HostFibreChannelTargetTransport)(nil)).Elem()
}

type HostFileAccess struct {
	DynamicData

	Who  string `xml:"who"`
	What string `xml:"what"`
}

func init() {
	t["HostFileAccess"] = reflect.TypeOf((*HostFileAccess)(nil)).Elem()
}

type HostFileSystemMountInfo struct {
	DynamicData

	MountInfo       HostMountInfo            `xml:"mountInfo"`
	Volume          BaseHostFileSystemVolume `xml:"volume,typeattr"`
	VStorageSupport string                   `xml:"vStorageSupport,omitempty"`
}

func init() {
	t["HostFileSystemMountInfo"] = reflect.TypeOf((*HostFileSystemMountInfo)(nil)).Elem()
}

type HostFileSystemVolume struct {
	DynamicData

	Type     string `xml:"type"`
	Name     string `xml:"name"`
	Capacity int64  `xml:"capacity"`
}

func init() {
	t["HostFileSystemVolume"] = reflect.TypeOf((*HostFileSystemVolume)(nil)).Elem()
}

type HostFileSystemVolumeInfo struct {
	DynamicData

	VolumeTypeList []string                  `xml:"volumeTypeList,omitempty"`
	MountInfo      []HostFileSystemMountInfo `xml:"mountInfo,omitempty"`
}

func init() {
	t["HostFileSystemVolumeInfo"] = reflect.TypeOf((*HostFileSystemVolumeInfo)(nil)).Elem()
}

type HostFirewallConfig struct {
	DynamicData

	Rule                  []HostFirewallConfigRuleSetConfig `xml:"rule,omitempty"`
	DefaultBlockingPolicy HostFirewallDefaultPolicy         `xml:"defaultBlockingPolicy"`
}

func init() {
	t["HostFirewallConfig"] = reflect.TypeOf((*HostFirewallConfig)(nil)).Elem()
}

type HostFirewallConfigRuleSetConfig struct {
	DynamicData

	RulesetId    string                     `xml:"rulesetId"`
	Enabled      bool                       `xml:"enabled"`
	AllowedHosts *HostFirewallRulesetIpList `xml:"allowedHosts,omitempty"`
}

func init() {
	t["HostFirewallConfigRuleSetConfig"] = reflect.TypeOf((*HostFirewallConfigRuleSetConfig)(nil)).Elem()
}

type HostFirewallDefaultPolicy struct {
	DynamicData

	IncomingBlocked *bool `xml:"incomingBlocked"`
	OutgoingBlocked *bool `xml:"outgoingBlocked"`
}

func init() {
	t["HostFirewallDefaultPolicy"] = reflect.TypeOf((*HostFirewallDefaultPolicy)(nil)).Elem()
}

type HostFirewallInfo struct {
	DynamicData

	DefaultPolicy HostFirewallDefaultPolicy `xml:"defaultPolicy"`
	Ruleset       []HostFirewallRuleset     `xml:"ruleset,omitempty"`
}

func init() {
	t["HostFirewallInfo"] = reflect.TypeOf((*HostFirewallInfo)(nil)).Elem()
}

type HostFirewallRule struct {
	DynamicData

	Port      int                       `xml:"port"`
	EndPort   int                       `xml:"endPort,omitempty"`
	Direction HostFirewallRuleDirection `xml:"direction"`
	PortType  HostFirewallRulePortType  `xml:"portType,omitempty"`
	Protocol  string                    `xml:"protocol"`
}

func init() {
	t["HostFirewallRule"] = reflect.TypeOf((*HostFirewallRule)(nil)).Elem()
}

type HostFirewallRuleset struct {
	DynamicData

	Key          string                     `xml:"key"`
	Label        string                     `xml:"label"`
	Required     bool                       `xml:"required"`
	Rule         []HostFirewallRule         `xml:"rule"`
	Service      string                     `xml:"service,omitempty"`
	Enabled      bool                       `xml:"enabled"`
	AllowedHosts *HostFirewallRulesetIpList `xml:"allowedHosts,omitempty"`
}

func init() {
	t["HostFirewallRuleset"] = reflect.TypeOf((*HostFirewallRuleset)(nil)).Elem()
}

type HostFirewallRulesetIpList struct {
	DynamicData

	IpAddress []string                       `xml:"ipAddress,omitempty"`
	IpNetwork []HostFirewallRulesetIpNetwork `xml:"ipNetwork,omitempty"`
	AllIp     bool                           `xml:"allIp"`
}

func init() {
	t["HostFirewallRulesetIpList"] = reflect.TypeOf((*HostFirewallRulesetIpList)(nil)).Elem()
}

type HostFirewallRulesetIpNetwork struct {
	DynamicData

	Network      string `xml:"network"`
	PrefixLength int    `xml:"prefixLength"`
}

func init() {
	t["HostFirewallRulesetIpNetwork"] = reflect.TypeOf((*HostFirewallRulesetIpNetwork)(nil)).Elem()
}

type HostFirewallRulesetRulesetSpec struct {
	DynamicData

	AllowedHosts HostFirewallRulesetIpList `xml:"allowedHosts"`
}

func init() {
	t["HostFirewallRulesetRulesetSpec"] = reflect.TypeOf((*HostFirewallRulesetRulesetSpec)(nil)).Elem()
}

type HostFlagInfo struct {
	DynamicData

	BackgroundSnapshotsEnabled *bool `xml:"backgroundSnapshotsEnabled"`
}

func init() {
	t["HostFlagInfo"] = reflect.TypeOf((*HostFlagInfo)(nil)).Elem()
}

type HostForceMountedInfo struct {
	DynamicData

	Persist bool `xml:"persist"`
	Mounted bool `xml:"mounted"`
}

func init() {
	t["HostForceMountedInfo"] = reflect.TypeOf((*HostForceMountedInfo)(nil)).Elem()
}

type HostGetShortNameFailedEvent struct {
	HostEvent
}

func init() {
	t["HostGetShortNameFailedEvent"] = reflect.TypeOf((*HostGetShortNameFailedEvent)(nil)).Elem()
}

type HostGetVFlashModuleDefaultConfig HostGetVFlashModuleDefaultConfigRequestType

func init() {
	t["HostGetVFlashModuleDefaultConfig"] = reflect.TypeOf((*HostGetVFlashModuleDefaultConfig)(nil)).Elem()
}

type HostGetVFlashModuleDefaultConfigRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	VFlashModule string                 `xml:"vFlashModule"`
}

func init() {
	t["HostGetVFlashModuleDefaultConfigRequestType"] = reflect.TypeOf((*HostGetVFlashModuleDefaultConfigRequestType)(nil)).Elem()
}

type HostGetVFlashModuleDefaultConfigResponse struct {
	Returnval VirtualDiskVFlashCacheConfigInfo `xml:"returnval"`
}

type HostGraphicsInfo struct {
	DynamicData

	DeviceName     string                   `xml:"deviceName"`
	VendorName     string                   `xml:"vendorName"`
	PciId          string                   `xml:"pciId"`
	GraphicsType   string                   `xml:"graphicsType"`
	MemorySizeInKB int64                    `xml:"memorySizeInKB"`
	Vm             []ManagedObjectReference `xml:"vm,omitempty"`
}

func init() {
	t["HostGraphicsInfo"] = reflect.TypeOf((*HostGraphicsInfo)(nil)).Elem()
}

type HostHardwareElementInfo struct {
	DynamicData

	Name   string                 `xml:"name"`
	Status BaseElementDescription `xml:"status,typeattr"`
}

func init() {
	t["HostHardwareElementInfo"] = reflect.TypeOf((*HostHardwareElementInfo)(nil)).Elem()
}

type HostHardwareInfo struct {
	DynamicData

	SystemInfo             HostSystemInfo              `xml:"systemInfo"`
	CpuPowerManagementInfo *HostCpuPowerManagementInfo `xml:"cpuPowerManagementInfo,omitempty"`
	CpuInfo                HostCpuInfo                 `xml:"cpuInfo"`
	CpuPkg                 []HostCpuPackage            `xml:"cpuPkg"`
	MemorySize             int64                       `xml:"memorySize"`
	NumaInfo               *HostNumaInfo               `xml:"numaInfo,omitempty"`
	SmcPresent             *bool                       `xml:"smcPresent"`
	PciDevice              []HostPciDevice             `xml:"pciDevice,omitempty"`
	CpuFeature             []HostCpuIdInfo             `xml:"cpuFeature,omitempty"`
	BiosInfo               *HostBIOSInfo               `xml:"biosInfo,omitempty"`
	ReliableMemoryInfo     *HostReliableMemoryInfo     `xml:"reliableMemoryInfo,omitempty"`
}

func init() {
	t["HostHardwareInfo"] = reflect.TypeOf((*HostHardwareInfo)(nil)).Elem()
}

type HostHardwareStatusInfo struct {
	DynamicData

	MemoryStatusInfo  []BaseHostHardwareElementInfo `xml:"memoryStatusInfo,omitempty,typeattr"`
	CpuStatusInfo     []BaseHostHardwareElementInfo `xml:"cpuStatusInfo,omitempty,typeattr"`
	StorageStatusInfo []HostStorageElementInfo      `xml:"storageStatusInfo,omitempty"`
}

func init() {
	t["HostHardwareStatusInfo"] = reflect.TypeOf((*HostHardwareStatusInfo)(nil)).Elem()
}

type HostHardwareSummary struct {
	DynamicData

	Vendor               string                         `xml:"vendor"`
	Model                string                         `xml:"model"`
	Uuid                 string                         `xml:"uuid"`
	OtherIdentifyingInfo []HostSystemIdentificationInfo `xml:"otherIdentifyingInfo,omitempty"`
	MemorySize           int64                          `xml:"memorySize"`
	CpuModel             string                         `xml:"cpuModel"`
	CpuMhz               int                            `xml:"cpuMhz"`
	NumCpuPkgs           int16                          `xml:"numCpuPkgs"`
	NumCpuCores          int16                          `xml:"numCpuCores"`
	NumCpuThreads        int16                          `xml:"numCpuThreads"`
	NumNics              int                            `xml:"numNics"`
	NumHBAs              int                            `xml:"numHBAs"`
}

func init() {
	t["HostHardwareSummary"] = reflect.TypeOf((*HostHardwareSummary)(nil)).Elem()
}

type HostHostBusAdapter struct {
	DynamicData

	Key    string `xml:"key,omitempty"`
	Device string `xml:"device"`
	Bus    int    `xml:"bus"`
	Status string `xml:"status"`
	Model  string `xml:"model"`
	Driver string `xml:"driver,omitempty"`
	Pci    string `xml:"pci,omitempty"`
}

func init() {
	t["HostHostBusAdapter"] = reflect.TypeOf((*HostHostBusAdapter)(nil)).Elem()
}

type HostHyperThreadScheduleInfo struct {
	DynamicData

	Available bool `xml:"available"`
	Active    bool `xml:"active"`
	Config    bool `xml:"config"`
}

func init() {
	t["HostHyperThreadScheduleInfo"] = reflect.TypeOf((*HostHyperThreadScheduleInfo)(nil)).Elem()
}

type HostImageConfigGetAcceptance HostImageConfigGetAcceptanceRequestType

func init() {
	t["HostImageConfigGetAcceptance"] = reflect.TypeOf((*HostImageConfigGetAcceptance)(nil)).Elem()
}

type HostImageConfigGetAcceptanceRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HostImageConfigGetAcceptanceRequestType"] = reflect.TypeOf((*HostImageConfigGetAcceptanceRequestType)(nil)).Elem()
}

type HostImageConfigGetAcceptanceResponse struct {
	Returnval string `xml:"returnval"`
}

type HostImageConfigGetProfile HostImageConfigGetProfileRequestType

func init() {
	t["HostImageConfigGetProfile"] = reflect.TypeOf((*HostImageConfigGetProfile)(nil)).Elem()
}

type HostImageConfigGetProfileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HostImageConfigGetProfileRequestType"] = reflect.TypeOf((*HostImageConfigGetProfileRequestType)(nil)).Elem()
}

type HostImageConfigGetProfileResponse struct {
	Returnval HostImageProfileSummary `xml:"returnval"`
}

type HostImageProfileSummary struct {
	DynamicData

	Name   string `xml:"name"`
	Vendor string `xml:"vendor"`
}

func init() {
	t["HostImageProfileSummary"] = reflect.TypeOf((*HostImageProfileSummary)(nil)).Elem()
}

type HostInAuditModeEvent struct {
	HostEvent
}

func init() {
	t["HostInAuditModeEvent"] = reflect.TypeOf((*HostInAuditModeEvent)(nil)).Elem()
}

type HostInDomain struct {
	HostConfigFault
}

func init() {
	t["HostInDomain"] = reflect.TypeOf((*HostInDomain)(nil)).Elem()
}

type HostInDomainFault HostInDomain

func init() {
	t["HostInDomainFault"] = reflect.TypeOf((*HostInDomainFault)(nil)).Elem()
}

type HostIncompatibleForFaultTolerance struct {
	VmFaultToleranceIssue

	HostName string `xml:"hostName,omitempty"`
	Reason   string `xml:"reason,omitempty"`
}

func init() {
	t["HostIncompatibleForFaultTolerance"] = reflect.TypeOf((*HostIncompatibleForFaultTolerance)(nil)).Elem()
}

type HostIncompatibleForFaultToleranceFault HostIncompatibleForFaultTolerance

func init() {
	t["HostIncompatibleForFaultToleranceFault"] = reflect.TypeOf((*HostIncompatibleForFaultToleranceFault)(nil)).Elem()
}

type HostIncompatibleForRecordReplay struct {
	VimFault

	HostName string `xml:"hostName,omitempty"`
	Reason   string `xml:"reason,omitempty"`
}

func init() {
	t["HostIncompatibleForRecordReplay"] = reflect.TypeOf((*HostIncompatibleForRecordReplay)(nil)).Elem()
}

type HostIncompatibleForRecordReplayFault HostIncompatibleForRecordReplay

func init() {
	t["HostIncompatibleForRecordReplayFault"] = reflect.TypeOf((*HostIncompatibleForRecordReplayFault)(nil)).Elem()
}

type HostInternetScsiHba struct {
	HostHostBusAdapter

	IsSoftwareBased            bool                                          `xml:"isSoftwareBased"`
	CanBeDisabled              *bool                                         `xml:"canBeDisabled"`
	NetworkBindingSupport      HostInternetScsiHbaNetworkBindingSupportType  `xml:"networkBindingSupport,omitempty"`
	DiscoveryCapabilities      HostInternetScsiHbaDiscoveryCapabilities      `xml:"discoveryCapabilities"`
	DiscoveryProperties        HostInternetScsiHbaDiscoveryProperties        `xml:"discoveryProperties"`
	AuthenticationCapabilities HostInternetScsiHbaAuthenticationCapabilities `xml:"authenticationCapabilities"`
	AuthenticationProperties   HostInternetScsiHbaAuthenticationProperties   `xml:"authenticationProperties"`
	DigestCapabilities         *HostInternetScsiHbaDigestCapabilities        `xml:"digestCapabilities,omitempty"`
	DigestProperties           *HostInternetScsiHbaDigestProperties          `xml:"digestProperties,omitempty"`
	IpCapabilities             HostInternetScsiHbaIPCapabilities             `xml:"ipCapabilities"`
	IpProperties               HostInternetScsiHbaIPProperties               `xml:"ipProperties"`
	SupportedAdvancedOptions   []OptionDef                                   `xml:"supportedAdvancedOptions,omitempty"`
	AdvancedOptions            []HostInternetScsiHbaParamValue               `xml:"advancedOptions,omitempty"`
	IScsiName                  string                                        `xml:"iScsiName"`
	IScsiAlias                 string                                        `xml:"iScsiAlias,omitempty"`
	ConfiguredSendTarget       []HostInternetScsiHbaSendTarget               `xml:"configuredSendTarget,omitempty"`
	ConfiguredStaticTarget     []HostInternetScsiHbaStaticTarget             `xml:"configuredStaticTarget,omitempty"`
	MaxSpeedMb                 int                                           `xml:"maxSpeedMb,omitempty"`
	CurrentSpeedMb             int                                           `xml:"currentSpeedMb,omitempty"`
}

func init() {
	t["HostInternetScsiHba"] = reflect.TypeOf((*HostInternetScsiHba)(nil)).Elem()
}

type HostInternetScsiHbaAuthenticationCapabilities struct {
	DynamicData

	ChapAuthSettable         bool  `xml:"chapAuthSettable"`
	Krb5AuthSettable         bool  `xml:"krb5AuthSettable"`
	SrpAuthSettable          bool  `xml:"srpAuthSettable"`
	SpkmAuthSettable         bool  `xml:"spkmAuthSettable"`
	MutualChapSettable       *bool `xml:"mutualChapSettable"`
	TargetChapSettable       *bool `xml:"targetChapSettable"`
	TargetMutualChapSettable *bool `xml:"targetMutualChapSettable"`
}

func init() {
	t["HostInternetScsiHbaAuthenticationCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaAuthenticationCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaAuthenticationProperties struct {
	DynamicData

	ChapAuthEnabled              bool   `xml:"chapAuthEnabled"`
	ChapName                     string `xml:"chapName,omitempty"`
	ChapSecret                   string `xml:"chapSecret,omitempty"`
	ChapAuthenticationType       string `xml:"chapAuthenticationType,omitempty"`
	ChapInherited                *bool  `xml:"chapInherited"`
	MutualChapName               string `xml:"mutualChapName,omitempty"`
	MutualChapSecret             string `xml:"mutualChapSecret,omitempty"`
	MutualChapAuthenticationType string `xml:"mutualChapAuthenticationType,omitempty"`
	MutualChapInherited          *bool  `xml:"mutualChapInherited"`
}

func init() {
	t["HostInternetScsiHbaAuthenticationProperties"] = reflect.TypeOf((*HostInternetScsiHbaAuthenticationProperties)(nil)).Elem()
}

type HostInternetScsiHbaDigestCapabilities struct {
	DynamicData

	HeaderDigestSettable       *bool `xml:"headerDigestSettable"`
	DataDigestSettable         *bool `xml:"dataDigestSettable"`
	TargetHeaderDigestSettable *bool `xml:"targetHeaderDigestSettable"`
	TargetDataDigestSettable   *bool `xml:"targetDataDigestSettable"`
}

func init() {
	t["HostInternetScsiHbaDigestCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaDigestCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaDigestProperties struct {
	DynamicData

	HeaderDigestType      string `xml:"headerDigestType,omitempty"`
	HeaderDigestInherited *bool  `xml:"headerDigestInherited"`
	DataDigestType        string `xml:"dataDigestType,omitempty"`
	DataDigestInherited   *bool  `xml:"dataDigestInherited"`
}

func init() {
	t["HostInternetScsiHbaDigestProperties"] = reflect.TypeOf((*HostInternetScsiHbaDigestProperties)(nil)).Elem()
}

type HostInternetScsiHbaDiscoveryCapabilities struct {
	DynamicData

	ISnsDiscoverySettable         bool `xml:"iSnsDiscoverySettable"`
	SlpDiscoverySettable          bool `xml:"slpDiscoverySettable"`
	StaticTargetDiscoverySettable bool `xml:"staticTargetDiscoverySettable"`
	SendTargetsDiscoverySettable  bool `xml:"sendTargetsDiscoverySettable"`
}

func init() {
	t["HostInternetScsiHbaDiscoveryCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaDiscoveryCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaDiscoveryProperties struct {
	DynamicData

	ISnsDiscoveryEnabled         bool   `xml:"iSnsDiscoveryEnabled"`
	ISnsDiscoveryMethod          string `xml:"iSnsDiscoveryMethod,omitempty"`
	ISnsHost                     string `xml:"iSnsHost,omitempty"`
	SlpDiscoveryEnabled          bool   `xml:"slpDiscoveryEnabled"`
	SlpDiscoveryMethod           string `xml:"slpDiscoveryMethod,omitempty"`
	SlpHost                      string `xml:"slpHost,omitempty"`
	StaticTargetDiscoveryEnabled bool   `xml:"staticTargetDiscoveryEnabled"`
	SendTargetsDiscoveryEnabled  bool   `xml:"sendTargetsDiscoveryEnabled"`
}

func init() {
	t["HostInternetScsiHbaDiscoveryProperties"] = reflect.TypeOf((*HostInternetScsiHbaDiscoveryProperties)(nil)).Elem()
}

type HostInternetScsiHbaIPCapabilities struct {
	DynamicData

	AddressSettable                   bool  `xml:"addressSettable"`
	IpConfigurationMethodSettable     bool  `xml:"ipConfigurationMethodSettable"`
	SubnetMaskSettable                bool  `xml:"subnetMaskSettable"`
	DefaultGatewaySettable            bool  `xml:"defaultGatewaySettable"`
	PrimaryDnsServerAddressSettable   bool  `xml:"primaryDnsServerAddressSettable"`
	AlternateDnsServerAddressSettable bool  `xml:"alternateDnsServerAddressSettable"`
	Ipv6Supported                     *bool `xml:"ipv6Supported"`
	ArpRedirectSettable               *bool `xml:"arpRedirectSettable"`
	MtuSettable                       *bool `xml:"mtuSettable"`
	HostNameAsTargetAddress           *bool `xml:"hostNameAsTargetAddress"`
	NameAliasSettable                 *bool `xml:"nameAliasSettable"`
}

func init() {
	t["HostInternetScsiHbaIPCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaIPCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaIPProperties struct {
	DynamicData

	Mac                       string `xml:"mac,omitempty"`
	Address                   string `xml:"address,omitempty"`
	DhcpConfigurationEnabled  bool   `xml:"dhcpConfigurationEnabled"`
	SubnetMask                string `xml:"subnetMask,omitempty"`
	DefaultGateway            string `xml:"defaultGateway,omitempty"`
	PrimaryDnsServerAddress   string `xml:"primaryDnsServerAddress,omitempty"`
	AlternateDnsServerAddress string `xml:"alternateDnsServerAddress,omitempty"`
	Ipv6Address               string `xml:"ipv6Address,omitempty"`
	Ipv6SubnetMask            string `xml:"ipv6SubnetMask,omitempty"`
	Ipv6DefaultGateway        string `xml:"ipv6DefaultGateway,omitempty"`
	ArpRedirectEnabled        *bool  `xml:"arpRedirectEnabled"`
	Mtu                       int    `xml:"mtu,omitempty"`
	JumboFramesEnabled        *bool  `xml:"jumboFramesEnabled"`
}

func init() {
	t["HostInternetScsiHbaIPProperties"] = reflect.TypeOf((*HostInternetScsiHbaIPProperties)(nil)).Elem()
}

type HostInternetScsiHbaParamValue struct {
	OptionValue

	IsInherited *bool `xml:"isInherited"`
}

func init() {
	t["HostInternetScsiHbaParamValue"] = reflect.TypeOf((*HostInternetScsiHbaParamValue)(nil)).Elem()
}

type HostInternetScsiHbaSendTarget struct {
	DynamicData

	Address                  string                                       `xml:"address"`
	Port                     int                                          `xml:"port,omitempty"`
	AuthenticationProperties *HostInternetScsiHbaAuthenticationProperties `xml:"authenticationProperties,omitempty"`
	DigestProperties         *HostInternetScsiHbaDigestProperties         `xml:"digestProperties,omitempty"`
	SupportedAdvancedOptions []OptionDef                                  `xml:"supportedAdvancedOptions,omitempty"`
	AdvancedOptions          []HostInternetScsiHbaParamValue              `xml:"advancedOptions,omitempty"`
	Parent                   string                                       `xml:"parent,omitempty"`
}

func init() {
	t["HostInternetScsiHbaSendTarget"] = reflect.TypeOf((*HostInternetScsiHbaSendTarget)(nil)).Elem()
}

type HostInternetScsiHbaStaticTarget struct {
	DynamicData

	Address                  string                                       `xml:"address"`
	Port                     int                                          `xml:"port,omitempty"`
	IScsiName                string                                       `xml:"iScsiName"`
	DiscoveryMethod          string                                       `xml:"discoveryMethod,omitempty"`
	AuthenticationProperties *HostInternetScsiHbaAuthenticationProperties `xml:"authenticationProperties,omitempty"`
	DigestProperties         *HostInternetScsiHbaDigestProperties         `xml:"digestProperties,omitempty"`
	SupportedAdvancedOptions []OptionDef                                  `xml:"supportedAdvancedOptions,omitempty"`
	AdvancedOptions          []HostInternetScsiHbaParamValue              `xml:"advancedOptions,omitempty"`
	Parent                   string                                       `xml:"parent,omitempty"`
}

func init() {
	t["HostInternetScsiHbaStaticTarget"] = reflect.TypeOf((*HostInternetScsiHbaStaticTarget)(nil)).Elem()
}

type HostInternetScsiHbaTargetSet struct {
	DynamicData

	StaticTargets []HostInternetScsiHbaStaticTarget `xml:"staticTargets,omitempty"`
	SendTargets   []HostInternetScsiHbaSendTarget   `xml:"sendTargets,omitempty"`
}

func init() {
	t["HostInternetScsiHbaTargetSet"] = reflect.TypeOf((*HostInternetScsiHbaTargetSet)(nil)).Elem()
}

type HostInternetScsiTargetTransport struct {
	HostTargetTransport

	IScsiName  string   `xml:"iScsiName"`
	IScsiAlias string   `xml:"iScsiAlias"`
	Address    []string `xml:"address,omitempty"`
}

func init() {
	t["HostInternetScsiTargetTransport"] = reflect.TypeOf((*HostInternetScsiTargetTransport)(nil)).Elem()
}

type HostInventoryFull struct {
	NotEnoughLicenses

	Capacity int `xml:"capacity"`
}

func init() {
	t["HostInventoryFull"] = reflect.TypeOf((*HostInventoryFull)(nil)).Elem()
}

type HostInventoryFullEvent struct {
	LicenseEvent

	Capacity int `xml:"capacity"`
}

func init() {
	t["HostInventoryFullEvent"] = reflect.TypeOf((*HostInventoryFullEvent)(nil)).Elem()
}

type HostInventoryFullFault HostInventoryFull

func init() {
	t["HostInventoryFullFault"] = reflect.TypeOf((*HostInventoryFullFault)(nil)).Elem()
}

type HostInventoryUnreadableEvent struct {
	Event
}

func init() {
	t["HostInventoryUnreadableEvent"] = reflect.TypeOf((*HostInventoryUnreadableEvent)(nil)).Elem()
}

type HostIpChangedEvent struct {
	HostEvent

	OldIP string `xml:"oldIP"`
	NewIP string `xml:"newIP"`
}

func init() {
	t["HostIpChangedEvent"] = reflect.TypeOf((*HostIpChangedEvent)(nil)).Elem()
}

type HostIpConfig struct {
	DynamicData

	Dhcp       bool                                  `xml:"dhcp"`
	IpAddress  string                                `xml:"ipAddress,omitempty"`
	SubnetMask string                                `xml:"subnetMask,omitempty"`
	IpV6Config *HostIpConfigIpV6AddressConfiguration `xml:"ipV6Config,omitempty"`
}

func init() {
	t["HostIpConfig"] = reflect.TypeOf((*HostIpConfig)(nil)).Elem()
}

type HostIpConfigIpV6Address struct {
	DynamicData

	IpAddress    string     `xml:"ipAddress"`
	PrefixLength int        `xml:"prefixLength"`
	Origin       string     `xml:"origin,omitempty"`
	DadState     string     `xml:"dadState,omitempty"`
	Lifetime     *time.Time `xml:"lifetime"`
	Operation    string     `xml:"operation,omitempty"`
}

func init() {
	t["HostIpConfigIpV6Address"] = reflect.TypeOf((*HostIpConfigIpV6Address)(nil)).Elem()
}

type HostIpConfigIpV6AddressConfiguration struct {
	DynamicData

	IpV6Address              []HostIpConfigIpV6Address `xml:"ipV6Address,omitempty"`
	AutoConfigurationEnabled *bool                     `xml:"autoConfigurationEnabled"`
	DhcpV6Enabled            *bool                     `xml:"dhcpV6Enabled"`
}

func init() {
	t["HostIpConfigIpV6AddressConfiguration"] = reflect.TypeOf((*HostIpConfigIpV6AddressConfiguration)(nil)).Elem()
}

type HostIpInconsistentEvent struct {
	HostEvent

	IpAddress  string `xml:"ipAddress"`
	IpAddress2 string `xml:"ipAddress2"`
}

func init() {
	t["HostIpInconsistentEvent"] = reflect.TypeOf((*HostIpInconsistentEvent)(nil)).Elem()
}

type HostIpRouteConfig struct {
	DynamicData

	DefaultGateway     string `xml:"defaultGateway,omitempty"`
	GatewayDevice      string `xml:"gatewayDevice,omitempty"`
	IpV6DefaultGateway string `xml:"ipV6DefaultGateway,omitempty"`
	IpV6GatewayDevice  string `xml:"ipV6GatewayDevice,omitempty"`
}

func init() {
	t["HostIpRouteConfig"] = reflect.TypeOf((*HostIpRouteConfig)(nil)).Elem()
}

type HostIpRouteConfigSpec struct {
	HostIpRouteConfig

	GatewayDeviceConnection     *HostVirtualNicConnection `xml:"gatewayDeviceConnection,omitempty"`
	IpV6GatewayDeviceConnection *HostVirtualNicConnection `xml:"ipV6GatewayDeviceConnection,omitempty"`
}

func init() {
	t["HostIpRouteConfigSpec"] = reflect.TypeOf((*HostIpRouteConfigSpec)(nil)).Elem()
}

type HostIpRouteEntry struct {
	DynamicData

	Network      string `xml:"network"`
	PrefixLength int    `xml:"prefixLength"`
	Gateway      string `xml:"gateway"`
	DeviceName   string `xml:"deviceName,omitempty"`
}

func init() {
	t["HostIpRouteEntry"] = reflect.TypeOf((*HostIpRouteEntry)(nil)).Elem()
}

type HostIpRouteOp struct {
	DynamicData

	ChangeOperation string           `xml:"changeOperation"`
	Route           HostIpRouteEntry `xml:"route"`
}

func init() {
	t["HostIpRouteOp"] = reflect.TypeOf((*HostIpRouteOp)(nil)).Elem()
}

type HostIpRouteTableConfig struct {
	DynamicData

	IpRoute   []HostIpRouteOp `xml:"ipRoute,omitempty"`
	Ipv6Route []HostIpRouteOp `xml:"ipv6Route,omitempty"`
}

func init() {
	t["HostIpRouteTableConfig"] = reflect.TypeOf((*HostIpRouteTableConfig)(nil)).Elem()
}

type HostIpRouteTableInfo struct {
	DynamicData

	IpRoute   []HostIpRouteEntry `xml:"ipRoute,omitempty"`
	Ipv6Route []HostIpRouteEntry `xml:"ipv6Route,omitempty"`
}

func init() {
	t["HostIpRouteTableInfo"] = reflect.TypeOf((*HostIpRouteTableInfo)(nil)).Elem()
}

type HostIpToShortNameFailedEvent struct {
	HostEvent
}

func init() {
	t["HostIpToShortNameFailedEvent"] = reflect.TypeOf((*HostIpToShortNameFailedEvent)(nil)).Elem()
}

type HostIpmiInfo struct {
	DynamicData

	BmcIpAddress  string `xml:"bmcIpAddress,omitempty"`
	BmcMacAddress string `xml:"bmcMacAddress,omitempty"`
	Login         string `xml:"login,omitempty"`
	Password      string `xml:"password,omitempty"`
}

func init() {
	t["HostIpmiInfo"] = reflect.TypeOf((*HostIpmiInfo)(nil)).Elem()
}

type HostIsolationIpPingFailedEvent struct {
	HostDasEvent

	IsolationIp string `xml:"isolationIp"`
}

func init() {
	t["HostIsolationIpPingFailedEvent"] = reflect.TypeOf((*HostIsolationIpPingFailedEvent)(nil)).Elem()
}

type HostLicensableResourceInfo struct {
	DynamicData

	Resource []KeyAnyValue `xml:"resource"`
}

func init() {
	t["HostLicensableResourceInfo"] = reflect.TypeOf((*HostLicensableResourceInfo)(nil)).Elem()
}

type HostLicenseConnectInfo struct {
	DynamicData

	License    LicenseManagerLicenseInfo    `xml:"license"`
	Evaluation LicenseManagerEvaluationInfo `xml:"evaluation"`
	Resource   *HostLicensableResourceInfo  `xml:"resource,omitempty"`
}

func init() {
	t["HostLicenseConnectInfo"] = reflect.TypeOf((*HostLicenseConnectInfo)(nil)).Elem()
}

type HostLicenseExpiredEvent struct {
	LicenseEvent
}

func init() {
	t["HostLicenseExpiredEvent"] = reflect.TypeOf((*HostLicenseExpiredEvent)(nil)).Elem()
}

type HostLicenseSpec struct {
	DynamicData

	Source             BaseLicenseSource `xml:"source,omitempty,typeattr"`
	EditionKey         string            `xml:"editionKey,omitempty"`
	DisabledFeatureKey []string          `xml:"disabledFeatureKey,omitempty"`
	EnabledFeatureKey  []string          `xml:"enabledFeatureKey,omitempty"`
}

func init() {
	t["HostLicenseSpec"] = reflect.TypeOf((*HostLicenseSpec)(nil)).Elem()
}

type HostListSummary struct {
	DynamicData

	Host               *ManagedObjectReference   `xml:"host,omitempty"`
	Hardware           *HostHardwareSummary      `xml:"hardware,omitempty"`
	Runtime            *HostRuntimeInfo          `xml:"runtime,omitempty"`
	Config             HostConfigSummary         `xml:"config"`
	QuickStats         HostListSummaryQuickStats `xml:"quickStats"`
	OverallStatus      ManagedEntityStatus       `xml:"overallStatus"`
	RebootRequired     bool                      `xml:"rebootRequired"`
	CustomValue        []BaseCustomFieldValue    `xml:"customValue,omitempty,typeattr"`
	ManagementServerIp string                    `xml:"managementServerIp,omitempty"`
	MaxEVCModeKey      string                    `xml:"maxEVCModeKey,omitempty"`
	CurrentEVCModeKey  string                    `xml:"currentEVCModeKey,omitempty"`
}

func init() {
	t["HostListSummary"] = reflect.TypeOf((*HostListSummary)(nil)).Elem()
}

type HostListSummaryQuickStats struct {
	DynamicData

	OverallCpuUsage           int `xml:"overallCpuUsage,omitempty"`
	OverallMemoryUsage        int `xml:"overallMemoryUsage,omitempty"`
	DistributedCpuFairness    int `xml:"distributedCpuFairness,omitempty"`
	DistributedMemoryFairness int `xml:"distributedMemoryFairness,omitempty"`
	Uptime                    int `xml:"uptime,omitempty"`
}

func init() {
	t["HostListSummaryQuickStats"] = reflect.TypeOf((*HostListSummaryQuickStats)(nil)).Elem()
}

type HostLocalAuthenticationInfo struct {
	HostAuthenticationStoreInfo
}

func init() {
	t["HostLocalAuthenticationInfo"] = reflect.TypeOf((*HostLocalAuthenticationInfo)(nil)).Elem()
}

type HostLocalFileSystemVolume struct {
	HostFileSystemVolume

	Device string `xml:"device"`
}

func init() {
	t["HostLocalFileSystemVolume"] = reflect.TypeOf((*HostLocalFileSystemVolume)(nil)).Elem()
}

type HostLocalFileSystemVolumeSpec struct {
	DynamicData

	Device    string `xml:"device"`
	LocalPath string `xml:"localPath"`
}

func init() {
	t["HostLocalFileSystemVolumeSpec"] = reflect.TypeOf((*HostLocalFileSystemVolumeSpec)(nil)).Elem()
}

type HostLocalPortCreatedEvent struct {
	DvsEvent

	HostLocalPort DVSHostLocalPortInfo `xml:"hostLocalPort"`
}

func init() {
	t["HostLocalPortCreatedEvent"] = reflect.TypeOf((*HostLocalPortCreatedEvent)(nil)).Elem()
}

type HostLowLevelProvisioningManagerDiskLayoutSpec struct {
	DynamicData

	ControllerType string `xml:"controllerType"`
	BusNumber      int    `xml:"busNumber"`
	UnitNumber     int    `xml:"unitNumber"`
	SrcFilename    string `xml:"srcFilename"`
	DstFilename    string `xml:"dstFilename"`
}

func init() {
	t["HostLowLevelProvisioningManagerDiskLayoutSpec"] = reflect.TypeOf((*HostLowLevelProvisioningManagerDiskLayoutSpec)(nil)).Elem()
}

type HostLowLevelProvisioningManagerSnapshotLayoutSpec struct {
	DynamicData

	Id          int                                             `xml:"id"`
	SrcFilename string                                          `xml:"srcFilename"`
	DstFilename string                                          `xml:"dstFilename"`
	Disk        []HostLowLevelProvisioningManagerDiskLayoutSpec `xml:"disk,omitempty"`
}

func init() {
	t["HostLowLevelProvisioningManagerSnapshotLayoutSpec"] = reflect.TypeOf((*HostLowLevelProvisioningManagerSnapshotLayoutSpec)(nil)).Elem()
}

type HostLowLevelProvisioningManagerVmMigrationStatus struct {
	DynamicData

	MigrationId          int64  `xml:"migrationId"`
	Type                 string `xml:"type"`
	Source               bool   `xml:"source"`
	ConsideredSuccessful bool   `xml:"consideredSuccessful"`
}

func init() {
	t["HostLowLevelProvisioningManagerVmMigrationStatus"] = reflect.TypeOf((*HostLowLevelProvisioningManagerVmMigrationStatus)(nil)).Elem()
}

type HostLowLevelProvisioningManagerVmRecoveryInfo struct {
	DynamicData

	Version      string                       `xml:"version"`
	BiosUUID     string                       `xml:"biosUUID"`
	InstanceUUID string                       `xml:"instanceUUID"`
	FtInfo       BaseFaultToleranceConfigInfo `xml:"ftInfo,omitempty,typeattr"`
}

func init() {
	t["HostLowLevelProvisioningManagerVmRecoveryInfo"] = reflect.TypeOf((*HostLowLevelProvisioningManagerVmRecoveryInfo)(nil)).Elem()
}

type HostMaintenanceSpec struct {
	DynamicData

	VsanMode *VsanHostDecommissionMode `xml:"vsanMode,omitempty"`
}

func init() {
	t["HostMaintenanceSpec"] = reflect.TypeOf((*HostMaintenanceSpec)(nil)).Elem()
}

type HostMemberHealthCheckResult struct {
	DynamicData

	Summary string `xml:"summary,omitempty"`
}

func init() {
	t["HostMemberHealthCheckResult"] = reflect.TypeOf((*HostMemberHealthCheckResult)(nil)).Elem()
}

type HostMemberRuntimeInfo struct {
	DynamicData

	Host              ManagedObjectReference            `xml:"host"`
	Status            string                            `xml:"status,omitempty"`
	StatusDetail      string                            `xml:"statusDetail,omitempty"`
	HealthCheckResult []BaseHostMemberHealthCheckResult `xml:"healthCheckResult,omitempty,typeattr"`
}

func init() {
	t["HostMemberRuntimeInfo"] = reflect.TypeOf((*HostMemberRuntimeInfo)(nil)).Elem()
}

type HostMemberUplinkHealthCheckResult struct {
	HostMemberHealthCheckResult

	UplinkPortKey string `xml:"uplinkPortKey"`
}

func init() {
	t["HostMemberUplinkHealthCheckResult"] = reflect.TypeOf((*HostMemberUplinkHealthCheckResult)(nil)).Elem()
}

type HostMemoryProfile struct {
	ApplyProfile
}

func init() {
	t["HostMemoryProfile"] = reflect.TypeOf((*HostMemoryProfile)(nil)).Elem()
}

type HostMemorySpec struct {
	DynamicData

	ServiceConsoleReservation int64 `xml:"serviceConsoleReservation,omitempty"`
}

func init() {
	t["HostMemorySpec"] = reflect.TypeOf((*HostMemorySpec)(nil)).Elem()
}

type HostMissingNetworksEvent struct {
	HostDasEvent

	Ips string `xml:"ips,omitempty"`
}

func init() {
	t["HostMissingNetworksEvent"] = reflect.TypeOf((*HostMissingNetworksEvent)(nil)).Elem()
}

type HostMonitoringStateChangedEvent struct {
	ClusterEvent

	State string `xml:"state"`
}

func init() {
	t["HostMonitoringStateChangedEvent"] = reflect.TypeOf((*HostMonitoringStateChangedEvent)(nil)).Elem()
}

type HostMountInfo struct {
	DynamicData

	Path               string `xml:"path,omitempty"`
	AccessMode         string `xml:"accessMode"`
	Mounted            *bool  `xml:"mounted"`
	Accessible         *bool  `xml:"accessible"`
	InaccessibleReason string `xml:"inaccessibleReason,omitempty"`
}

func init() {
	t["HostMountInfo"] = reflect.TypeOf((*HostMountInfo)(nil)).Elem()
}

type HostMultipathInfo struct {
	DynamicData

	Lun []HostMultipathInfoLogicalUnit `xml:"lun,omitempty"`
}

func init() {
	t["HostMultipathInfo"] = reflect.TypeOf((*HostMultipathInfo)(nil)).Elem()
}

type HostMultipathInfoFixedLogicalUnitPolicy struct {
	HostMultipathInfoLogicalUnitPolicy

	Prefer string `xml:"prefer"`
}

func init() {
	t["HostMultipathInfoFixedLogicalUnitPolicy"] = reflect.TypeOf((*HostMultipathInfoFixedLogicalUnitPolicy)(nil)).Elem()
}

type HostMultipathInfoLogicalUnit struct {
	DynamicData

	Key                    string                                              `xml:"key"`
	Id                     string                                              `xml:"id"`
	Lun                    string                                              `xml:"lun"`
	Path                   []HostMultipathInfoPath                             `xml:"path"`
	Policy                 BaseHostMultipathInfoLogicalUnitPolicy              `xml:"policy,typeattr"`
	StorageArrayTypePolicy *HostMultipathInfoLogicalUnitStorageArrayTypePolicy `xml:"storageArrayTypePolicy,omitempty"`
}

func init() {
	t["HostMultipathInfoLogicalUnit"] = reflect.TypeOf((*HostMultipathInfoLogicalUnit)(nil)).Elem()
}

type HostMultipathInfoLogicalUnitPolicy struct {
	DynamicData

	Policy string `xml:"policy"`
}

func init() {
	t["HostMultipathInfoLogicalUnitPolicy"] = reflect.TypeOf((*HostMultipathInfoLogicalUnitPolicy)(nil)).Elem()
}

type HostMultipathInfoLogicalUnitStorageArrayTypePolicy struct {
	DynamicData

	Policy string `xml:"policy"`
}

func init() {
	t["HostMultipathInfoLogicalUnitStorageArrayTypePolicy"] = reflect.TypeOf((*HostMultipathInfoLogicalUnitStorageArrayTypePolicy)(nil)).Elem()
}

type HostMultipathInfoPath struct {
	DynamicData

	Key           string                  `xml:"key"`
	Name          string                  `xml:"name"`
	PathState     string                  `xml:"pathState"`
	State         string                  `xml:"state,omitempty"`
	IsWorkingPath *bool                   `xml:"isWorkingPath"`
	Adapter       string                  `xml:"adapter"`
	Lun           string                  `xml:"lun"`
	Transport     BaseHostTargetTransport `xml:"transport,omitempty,typeattr"`
}

func init() {
	t["HostMultipathInfoPath"] = reflect.TypeOf((*HostMultipathInfoPath)(nil)).Elem()
}

type HostMultipathStateInfo struct {
	DynamicData

	Path []HostMultipathStateInfoPath `xml:"path,omitempty"`
}

func init() {
	t["HostMultipathStateInfo"] = reflect.TypeOf((*HostMultipathStateInfo)(nil)).Elem()
}

type HostMultipathStateInfoPath struct {
	DynamicData

	Name      string `xml:"name"`
	PathState string `xml:"pathState"`
}

func init() {
	t["HostMultipathStateInfoPath"] = reflect.TypeOf((*HostMultipathStateInfoPath)(nil)).Elem()
}

type HostNasVolume struct {
	HostFileSystemVolume

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
	UserName   string `xml:"userName,omitempty"`
}

func init() {
	t["HostNasVolume"] = reflect.TypeOf((*HostNasVolume)(nil)).Elem()
}

type HostNasVolumeConfig struct {
	DynamicData

	ChangeOperation string             `xml:"changeOperation,omitempty"`
	Spec            *HostNasVolumeSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostNasVolumeConfig"] = reflect.TypeOf((*HostNasVolumeConfig)(nil)).Elem()
}

type HostNasVolumeSpec struct {
	DynamicData

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
	LocalPath  string `xml:"localPath"`
	AccessMode string `xml:"accessMode"`
	Type       string `xml:"type,omitempty"`
	UserName   string `xml:"userName,omitempty"`
	Password   string `xml:"password,omitempty"`
}

func init() {
	t["HostNasVolumeSpec"] = reflect.TypeOf((*HostNasVolumeSpec)(nil)).Elem()
}

type HostNatService struct {
	DynamicData

	Key  string             `xml:"key"`
	Spec HostNatServiceSpec `xml:"spec"`
}

func init() {
	t["HostNatService"] = reflect.TypeOf((*HostNatService)(nil)).Elem()
}

type HostNatServiceConfig struct {
	DynamicData

	ChangeOperation string             `xml:"changeOperation,omitempty"`
	Key             string             `xml:"key"`
	Spec            HostNatServiceSpec `xml:"spec"`
}

func init() {
	t["HostNatServiceConfig"] = reflect.TypeOf((*HostNatServiceConfig)(nil)).Elem()
}

type HostNatServiceNameServiceSpec struct {
	DynamicData

	DnsAutoDetect bool     `xml:"dnsAutoDetect"`
	DnsPolicy     string   `xml:"dnsPolicy"`
	DnsRetries    int      `xml:"dnsRetries"`
	DnsTimeout    int      `xml:"dnsTimeout"`
	DnsNameServer []string `xml:"dnsNameServer,omitempty"`
	NbdsTimeout   int      `xml:"nbdsTimeout"`
	NbnsRetries   int      `xml:"nbnsRetries"`
	NbnsTimeout   int      `xml:"nbnsTimeout"`
}

func init() {
	t["HostNatServiceNameServiceSpec"] = reflect.TypeOf((*HostNatServiceNameServiceSpec)(nil)).Elem()
}

type HostNatServicePortForwardSpec struct {
	DynamicData

	Type           string `xml:"type"`
	Name           string `xml:"name"`
	HostPort       int    `xml:"hostPort"`
	GuestPort      int    `xml:"guestPort"`
	GuestIpAddress string `xml:"guestIpAddress"`
}

func init() {
	t["HostNatServicePortForwardSpec"] = reflect.TypeOf((*HostNatServicePortForwardSpec)(nil)).Elem()
}

type HostNatServiceSpec struct {
	DynamicData

	VirtualSwitch    string                          `xml:"virtualSwitch"`
	ActiveFtp        bool                            `xml:"activeFtp"`
	AllowAnyOui      bool                            `xml:"allowAnyOui"`
	ConfigPort       bool                            `xml:"configPort"`
	IpGatewayAddress string                          `xml:"ipGatewayAddress"`
	UdpTimeout       int                             `xml:"udpTimeout"`
	PortForward      []HostNatServicePortForwardSpec `xml:"portForward,omitempty"`
	NameService      *HostNatServiceNameServiceSpec  `xml:"nameService,omitempty"`
}

func init() {
	t["HostNatServiceSpec"] = reflect.TypeOf((*HostNatServiceSpec)(nil)).Elem()
}

type HostNetCapabilities struct {
	DynamicData

	CanSetPhysicalNicLinkSpeed bool     `xml:"canSetPhysicalNicLinkSpeed"`
	SupportsNicTeaming         bool     `xml:"supportsNicTeaming"`
	NicTeamingPolicy           []string `xml:"nicTeamingPolicy,omitempty"`
	SupportsVlan               bool     `xml:"supportsVlan"`
	UsesServiceConsoleNic      bool     `xml:"usesServiceConsoleNic"`
	SupportsNetworkHints       bool     `xml:"supportsNetworkHints"`
	MaxPortGroupsPerVswitch    int      `xml:"maxPortGroupsPerVswitch,omitempty"`
	VswitchConfigSupported     bool     `xml:"vswitchConfigSupported"`
	VnicConfigSupported        bool     `xml:"vnicConfigSupported"`
	IpRouteConfigSupported     bool     `xml:"ipRouteConfigSupported"`
	DnsConfigSupported         bool     `xml:"dnsConfigSupported"`
	DhcpOnVnicSupported        bool     `xml:"dhcpOnVnicSupported"`
	IpV6Supported              *bool    `xml:"ipV6Supported"`
}

func init() {
	t["HostNetCapabilities"] = reflect.TypeOf((*HostNetCapabilities)(nil)).Elem()
}

type HostNetOffloadCapabilities struct {
	DynamicData

	CsumOffload     *bool `xml:"csumOffload"`
	TcpSegmentation *bool `xml:"tcpSegmentation"`
	ZeroCopyXmit    *bool `xml:"zeroCopyXmit"`
}

func init() {
	t["HostNetOffloadCapabilities"] = reflect.TypeOf((*HostNetOffloadCapabilities)(nil)).Elem()
}

type HostNetStackInstance struct {
	DynamicData

	Key                             string                  `xml:"key,omitempty"`
	Name                            string                  `xml:"name,omitempty"`
	DnsConfig                       BaseHostDnsConfig       `xml:"dnsConfig,omitempty,typeattr"`
	IpRouteConfig                   BaseHostIpRouteConfig   `xml:"ipRouteConfig,omitempty,typeattr"`
	RequestedMaxNumberOfConnections int                     `xml:"requestedMaxNumberOfConnections,omitempty"`
	CongestionControlAlgorithm      string                  `xml:"congestionControlAlgorithm,omitempty"`
	IpV6Enabled                     *bool                   `xml:"ipV6Enabled"`
	RouteTableConfig                *HostIpRouteTableConfig `xml:"routeTableConfig,omitempty"`
}

func init() {
	t["HostNetStackInstance"] = reflect.TypeOf((*HostNetStackInstance)(nil)).Elem()
}

type HostNetworkConfig struct {
	DynamicData

	Vswitch              []HostVirtualSwitchConfig       `xml:"vswitch,omitempty"`
	ProxySwitch          []HostProxySwitchConfig         `xml:"proxySwitch,omitempty"`
	Portgroup            []HostPortGroupConfig           `xml:"portgroup,omitempty"`
	Pnic                 []PhysicalNicConfig             `xml:"pnic,omitempty"`
	Vnic                 []HostVirtualNicConfig          `xml:"vnic,omitempty"`
	ConsoleVnic          []HostVirtualNicConfig          `xml:"consoleVnic,omitempty"`
	DnsConfig            BaseHostDnsConfig               `xml:"dnsConfig,omitempty,typeattr"`
	IpRouteConfig        BaseHostIpRouteConfig           `xml:"ipRouteConfig,omitempty,typeattr"`
	ConsoleIpRouteConfig BaseHostIpRouteConfig           `xml:"consoleIpRouteConfig,omitempty,typeattr"`
	RouteTableConfig     *HostIpRouteTableConfig         `xml:"routeTableConfig,omitempty"`
	Dhcp                 []HostDhcpServiceConfig         `xml:"dhcp,omitempty"`
	Nat                  []HostNatServiceConfig          `xml:"nat,omitempty"`
	IpV6Enabled          *bool                           `xml:"ipV6Enabled"`
	NetStackSpec         []HostNetworkConfigNetStackSpec `xml:"netStackSpec,omitempty"`
}

func init() {
	t["HostNetworkConfig"] = reflect.TypeOf((*HostNetworkConfig)(nil)).Elem()
}

type HostNetworkConfigNetStackSpec struct {
	DynamicData

	NetStackInstance HostNetStackInstance `xml:"netStackInstance"`
	Operation        string               `xml:"operation,omitempty"`
}

func init() {
	t["HostNetworkConfigNetStackSpec"] = reflect.TypeOf((*HostNetworkConfigNetStackSpec)(nil)).Elem()
}

type HostNetworkConfigResult struct {
	DynamicData

	VnicDevice        []string `xml:"vnicDevice,omitempty"`
	ConsoleVnicDevice []string `xml:"consoleVnicDevice,omitempty"`
}

func init() {
	t["HostNetworkConfigResult"] = reflect.TypeOf((*HostNetworkConfigResult)(nil)).Elem()
}

type HostNetworkInfo struct {
	DynamicData

	Vswitch              []HostVirtualSwitch     `xml:"vswitch,omitempty"`
	ProxySwitch          []HostProxySwitch       `xml:"proxySwitch,omitempty"`
	Portgroup            []HostPortGroup         `xml:"portgroup,omitempty"`
	Pnic                 []PhysicalNic           `xml:"pnic,omitempty"`
	Vnic                 []HostVirtualNic        `xml:"vnic,omitempty"`
	ConsoleVnic          []HostVirtualNic        `xml:"consoleVnic,omitempty"`
	DnsConfig            BaseHostDnsConfig       `xml:"dnsConfig,omitempty,typeattr"`
	IpRouteConfig        BaseHostIpRouteConfig   `xml:"ipRouteConfig,omitempty,typeattr"`
	ConsoleIpRouteConfig BaseHostIpRouteConfig   `xml:"consoleIpRouteConfig,omitempty,typeattr"`
	RouteTableInfo       *HostIpRouteTableInfo   `xml:"routeTableInfo,omitempty"`
	Dhcp                 []HostDhcpService       `xml:"dhcp,omitempty"`
	Nat                  []HostNatService        `xml:"nat,omitempty"`
	IpV6Enabled          *bool                   `xml:"ipV6Enabled"`
	AtBootIpV6Enabled    *bool                   `xml:"atBootIpV6Enabled"`
	NetStackInstance     []HostNetStackInstance  `xml:"netStackInstance,omitempty"`
	OpaqueSwitch         []HostOpaqueSwitch      `xml:"opaqueSwitch,omitempty"`
	OpaqueNetwork        []HostOpaqueNetworkInfo `xml:"opaqueNetwork,omitempty"`
}

func init() {
	t["HostNetworkInfo"] = reflect.TypeOf((*HostNetworkInfo)(nil)).Elem()
}

type HostNetworkPolicy struct {
	DynamicData

	Security      *HostNetworkSecurityPolicy       `xml:"security,omitempty"`
	NicTeaming    *HostNicTeamingPolicy            `xml:"nicTeaming,omitempty"`
	OffloadPolicy *HostNetOffloadCapabilities      `xml:"offloadPolicy,omitempty"`
	ShapingPolicy *HostNetworkTrafficShapingPolicy `xml:"shapingPolicy,omitempty"`
}

func init() {
	t["HostNetworkPolicy"] = reflect.TypeOf((*HostNetworkPolicy)(nil)).Elem()
}

type HostNetworkSecurityPolicy struct {
	DynamicData

	AllowPromiscuous *bool `xml:"allowPromiscuous"`
	MacChanges       *bool `xml:"macChanges"`
	ForgedTransmits  *bool `xml:"forgedTransmits"`
}

func init() {
	t["HostNetworkSecurityPolicy"] = reflect.TypeOf((*HostNetworkSecurityPolicy)(nil)).Elem()
}

type HostNetworkTrafficShapingPolicy struct {
	DynamicData

	Enabled          *bool `xml:"enabled"`
	AverageBandwidth int64 `xml:"averageBandwidth,omitempty"`
	PeakBandwidth    int64 `xml:"peakBandwidth,omitempty"`
	BurstSize        int64 `xml:"burstSize,omitempty"`
}

func init() {
	t["HostNetworkTrafficShapingPolicy"] = reflect.TypeOf((*HostNetworkTrafficShapingPolicy)(nil)).Elem()
}

type HostNewNetworkConnectInfo struct {
	HostConnectInfoNetworkInfo
}

func init() {
	t["HostNewNetworkConnectInfo"] = reflect.TypeOf((*HostNewNetworkConnectInfo)(nil)).Elem()
}

type HostNicFailureCriteria struct {
	DynamicData

	CheckSpeed        string `xml:"checkSpeed,omitempty"`
	Speed             int    `xml:"speed,omitempty"`
	CheckDuplex       *bool  `xml:"checkDuplex"`
	FullDuplex        *bool  `xml:"fullDuplex"`
	CheckErrorPercent *bool  `xml:"checkErrorPercent"`
	Percentage        int    `xml:"percentage,omitempty"`
	CheckBeacon       *bool  `xml:"checkBeacon"`
}

func init() {
	t["HostNicFailureCriteria"] = reflect.TypeOf((*HostNicFailureCriteria)(nil)).Elem()
}

type HostNicOrderPolicy struct {
	DynamicData

	ActiveNic  []string `xml:"activeNic,omitempty"`
	StandbyNic []string `xml:"standbyNic,omitempty"`
}

func init() {
	t["HostNicOrderPolicy"] = reflect.TypeOf((*HostNicOrderPolicy)(nil)).Elem()
}

type HostNicTeamingPolicy struct {
	DynamicData

	Policy          string                  `xml:"policy,omitempty"`
	ReversePolicy   *bool                   `xml:"reversePolicy"`
	NotifySwitches  *bool                   `xml:"notifySwitches"`
	RollingOrder    *bool                   `xml:"rollingOrder"`
	FailureCriteria *HostNicFailureCriteria `xml:"failureCriteria,omitempty"`
	NicOrder        *HostNicOrderPolicy     `xml:"nicOrder,omitempty"`
}

func init() {
	t["HostNicTeamingPolicy"] = reflect.TypeOf((*HostNicTeamingPolicy)(nil)).Elem()
}

type HostNoAvailableNetworksEvent struct {
	HostDasEvent

	Ips string `xml:"ips,omitempty"`
}

func init() {
	t["HostNoAvailableNetworksEvent"] = reflect.TypeOf((*HostNoAvailableNetworksEvent)(nil)).Elem()
}

type HostNoHAEnabledPortGroupsEvent struct {
	HostDasEvent
}

func init() {
	t["HostNoHAEnabledPortGroupsEvent"] = reflect.TypeOf((*HostNoHAEnabledPortGroupsEvent)(nil)).Elem()
}

type HostNoRedundantManagementNetworkEvent struct {
	HostDasEvent
}

func init() {
	t["HostNoRedundantManagementNetworkEvent"] = reflect.TypeOf((*HostNoRedundantManagementNetworkEvent)(nil)).Elem()
}

type HostNonCompliantEvent struct {
	HostEvent
}

func init() {
	t["HostNonCompliantEvent"] = reflect.TypeOf((*HostNonCompliantEvent)(nil)).Elem()
}

type HostNotConnected struct {
	HostCommunication
}

func init() {
	t["HostNotConnected"] = reflect.TypeOf((*HostNotConnected)(nil)).Elem()
}

type HostNotConnectedFault HostNotConnected

func init() {
	t["HostNotConnectedFault"] = reflect.TypeOf((*HostNotConnectedFault)(nil)).Elem()
}

type HostNotInClusterEvent struct {
	HostDasEvent
}

func init() {
	t["HostNotInClusterEvent"] = reflect.TypeOf((*HostNotInClusterEvent)(nil)).Elem()
}

type HostNotReachable struct {
	HostCommunication
}

func init() {
	t["HostNotReachable"] = reflect.TypeOf((*HostNotReachable)(nil)).Elem()
}

type HostNotReachableFault HostNotReachable

func init() {
	t["HostNotReachableFault"] = reflect.TypeOf((*HostNotReachableFault)(nil)).Elem()
}

type HostNtpConfig struct {
	DynamicData

	Server []string `xml:"server,omitempty"`
}

func init() {
	t["HostNtpConfig"] = reflect.TypeOf((*HostNtpConfig)(nil)).Elem()
}

type HostNumaInfo struct {
	DynamicData

	Type     string         `xml:"type"`
	NumNodes int            `xml:"numNodes"`
	NumaNode []HostNumaNode `xml:"numaNode,omitempty"`
}

func init() {
	t["HostNumaInfo"] = reflect.TypeOf((*HostNumaInfo)(nil)).Elem()
}

type HostNumaNode struct {
	DynamicData

	TypeId            byte    `xml:"typeId"`
	CpuID             []int16 `xml:"cpuID"`
	MemoryRangeBegin  int64   `xml:"memoryRangeBegin"`
	MemoryRangeLength int64   `xml:"memoryRangeLength"`
}

func init() {
	t["HostNumaNode"] = reflect.TypeOf((*HostNumaNode)(nil)).Elem()
}

type HostNumericSensorInfo struct {
	DynamicData

	Name           string                 `xml:"name"`
	HealthState    BaseElementDescription `xml:"healthState,omitempty,typeattr"`
	CurrentReading int64                  `xml:"currentReading"`
	UnitModifier   int                    `xml:"unitModifier"`
	BaseUnits      string                 `xml:"baseUnits"`
	RateUnits      string                 `xml:"rateUnits,omitempty"`
	SensorType     string                 `xml:"sensorType"`
}

func init() {
	t["HostNumericSensorInfo"] = reflect.TypeOf((*HostNumericSensorInfo)(nil)).Elem()
}

type HostOpaqueNetworkInfo struct {
	DynamicData

	OpaqueNetworkId   string `xml:"opaqueNetworkId"`
	OpaqueNetworkName string `xml:"opaqueNetworkName"`
	OpaqueNetworkType string `xml:"opaqueNetworkType"`
}

func init() {
	t["HostOpaqueNetworkInfo"] = reflect.TypeOf((*HostOpaqueNetworkInfo)(nil)).Elem()
}

type HostOpaqueSwitch struct {
	DynamicData

	Key  string   `xml:"key"`
	Name string   `xml:"name,omitempty"`
	Pnic []string `xml:"pnic,omitempty"`
}

func init() {
	t["HostOpaqueSwitch"] = reflect.TypeOf((*HostOpaqueSwitch)(nil)).Elem()
}

type HostOvercommittedEvent struct {
	ClusterOvercommittedEvent
}

func init() {
	t["HostOvercommittedEvent"] = reflect.TypeOf((*HostOvercommittedEvent)(nil)).Elem()
}

type HostParallelScsiHba struct {
	HostHostBusAdapter
}

func init() {
	t["HostParallelScsiHba"] = reflect.TypeOf((*HostParallelScsiHba)(nil)).Elem()
}

type HostParallelScsiTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostParallelScsiTargetTransport"] = reflect.TypeOf((*HostParallelScsiTargetTransport)(nil)).Elem()
}

type HostPatchManagerLocator struct {
	DynamicData

	Url   string `xml:"url"`
	Proxy string `xml:"proxy,omitempty"`
}

func init() {
	t["HostPatchManagerLocator"] = reflect.TypeOf((*HostPatchManagerLocator)(nil)).Elem()
}

type HostPatchManagerPatchManagerOperationSpec struct {
	DynamicData

	Proxy     string `xml:"proxy,omitempty"`
	Port      int    `xml:"port,omitempty"`
	UserName  string `xml:"userName,omitempty"`
	Password  string `xml:"password,omitempty"`
	CmdOption string `xml:"cmdOption,omitempty"`
}

func init() {
	t["HostPatchManagerPatchManagerOperationSpec"] = reflect.TypeOf((*HostPatchManagerPatchManagerOperationSpec)(nil)).Elem()
}

type HostPatchManagerResult struct {
	DynamicData

	Version   string                   `xml:"version"`
	Status    []HostPatchManagerStatus `xml:"status,omitempty"`
	XmlResult string                   `xml:"xmlResult,omitempty"`
}

func init() {
	t["HostPatchManagerResult"] = reflect.TypeOf((*HostPatchManagerResult)(nil)).Elem()
}

type HostPatchManagerStatus struct {
	DynamicData

	Id                 string                                    `xml:"id"`
	Applicable         bool                                      `xml:"applicable"`
	Reason             []string                                  `xml:"reason,omitempty"`
	Integrity          string                                    `xml:"integrity,omitempty"`
	Installed          bool                                      `xml:"installed"`
	InstallState       []string                                  `xml:"installState,omitempty"`
	PrerequisitePatch  []HostPatchManagerStatusPrerequisitePatch `xml:"prerequisitePatch,omitempty"`
	RestartRequired    bool                                      `xml:"restartRequired"`
	ReconnectRequired  bool                                      `xml:"reconnectRequired"`
	VmOffRequired      bool                                      `xml:"vmOffRequired"`
	SupersededPatchIds []string                                  `xml:"supersededPatchIds,omitempty"`
}

func init() {
	t["HostPatchManagerStatus"] = reflect.TypeOf((*HostPatchManagerStatus)(nil)).Elem()
}

type HostPatchManagerStatusPrerequisitePatch struct {
	DynamicData

	Id           string   `xml:"id"`
	InstallState []string `xml:"installState,omitempty"`
}

func init() {
	t["HostPatchManagerStatusPrerequisitePatch"] = reflect.TypeOf((*HostPatchManagerStatusPrerequisitePatch)(nil)).Elem()
}

type HostPathSelectionPolicyOption struct {
	DynamicData

	Policy BaseElementDescription `xml:"policy,typeattr"`
}

func init() {
	t["HostPathSelectionPolicyOption"] = reflect.TypeOf((*HostPathSelectionPolicyOption)(nil)).Elem()
}

type HostPciDevice struct {
	DynamicData

	Id           string `xml:"id"`
	ClassId      int16  `xml:"classId"`
	Bus          byte   `xml:"bus"`
	Slot         byte   `xml:"slot"`
	Function     byte   `xml:"function"`
	VendorId     int16  `xml:"vendorId"`
	SubVendorId  int16  `xml:"subVendorId"`
	VendorName   string `xml:"vendorName"`
	DeviceId     int16  `xml:"deviceId"`
	SubDeviceId  int16  `xml:"subDeviceId"`
	ParentBridge string `xml:"parentBridge,omitempty"`
	DeviceName   string `xml:"deviceName"`
}

func init() {
	t["HostPciDevice"] = reflect.TypeOf((*HostPciDevice)(nil)).Elem()
}

type HostPciPassthruConfig struct {
	DynamicData

	Id              string `xml:"id"`
	PassthruEnabled bool   `xml:"passthruEnabled"`
}

func init() {
	t["HostPciPassthruConfig"] = reflect.TypeOf((*HostPciPassthruConfig)(nil)).Elem()
}

type HostPciPassthruInfo struct {
	DynamicData

	Id              string `xml:"id"`
	DependentDevice string `xml:"dependentDevice"`
	PassthruEnabled bool   `xml:"passthruEnabled"`
	PassthruCapable bool   `xml:"passthruCapable"`
	PassthruActive  bool   `xml:"passthruActive"`
}

func init() {
	t["HostPciPassthruInfo"] = reflect.TypeOf((*HostPciPassthruInfo)(nil)).Elem()
}

type HostPlugStoreTopology struct {
	DynamicData

	Adapter []HostPlugStoreTopologyAdapter `xml:"adapter,omitempty"`
	Path    []HostPlugStoreTopologyPath    `xml:"path,omitempty"`
	Target  []HostPlugStoreTopologyTarget  `xml:"target,omitempty"`
	Device  []HostPlugStoreTopologyDevice  `xml:"device,omitempty"`
	Plugin  []HostPlugStoreTopologyPlugin  `xml:"plugin,omitempty"`
}

func init() {
	t["HostPlugStoreTopology"] = reflect.TypeOf((*HostPlugStoreTopology)(nil)).Elem()
}

type HostPlugStoreTopologyAdapter struct {
	DynamicData

	Key     string   `xml:"key"`
	Adapter string   `xml:"adapter"`
	Path    []string `xml:"path,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyAdapter"] = reflect.TypeOf((*HostPlugStoreTopologyAdapter)(nil)).Elem()
}

type HostPlugStoreTopologyDevice struct {
	DynamicData

	Key  string   `xml:"key"`
	Lun  string   `xml:"lun"`
	Path []string `xml:"path,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyDevice"] = reflect.TypeOf((*HostPlugStoreTopologyDevice)(nil)).Elem()
}

type HostPlugStoreTopologyPath struct {
	DynamicData

	Key           string `xml:"key"`
	Name          string `xml:"name"`
	ChannelNumber int    `xml:"channelNumber,omitempty"`
	TargetNumber  int    `xml:"targetNumber,omitempty"`
	LunNumber     int    `xml:"lunNumber,omitempty"`
	Adapter       string `xml:"adapter,omitempty"`
	Target        string `xml:"target,omitempty"`
	Device        string `xml:"device,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyPath"] = reflect.TypeOf((*HostPlugStoreTopologyPath)(nil)).Elem()
}

type HostPlugStoreTopologyPlugin struct {
	DynamicData

	Key         string   `xml:"key"`
	Name        string   `xml:"name"`
	Device      []string `xml:"device,omitempty"`
	ClaimedPath []string `xml:"claimedPath,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyPlugin"] = reflect.TypeOf((*HostPlugStoreTopologyPlugin)(nil)).Elem()
}

type HostPlugStoreTopologyTarget struct {
	DynamicData

	Key       string                  `xml:"key"`
	Transport BaseHostTargetTransport `xml:"transport,omitempty,typeattr"`
}

func init() {
	t["HostPlugStoreTopologyTarget"] = reflect.TypeOf((*HostPlugStoreTopologyTarget)(nil)).Elem()
}

type HostPortGroup struct {
	DynamicData

	Key            string              `xml:"key,omitempty"`
	Port           []HostPortGroupPort `xml:"port,omitempty"`
	Vswitch        string              `xml:"vswitch,omitempty"`
	ComputedPolicy HostNetworkPolicy   `xml:"computedPolicy"`
	Spec           HostPortGroupSpec   `xml:"spec"`
}

func init() {
	t["HostPortGroup"] = reflect.TypeOf((*HostPortGroup)(nil)).Elem()
}

type HostPortGroupConfig struct {
	DynamicData

	ChangeOperation string             `xml:"changeOperation,omitempty"`
	Spec            *HostPortGroupSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostPortGroupConfig"] = reflect.TypeOf((*HostPortGroupConfig)(nil)).Elem()
}

type HostPortGroupPort struct {
	DynamicData

	Key  string   `xml:"key,omitempty"`
	Mac  []string `xml:"mac,omitempty"`
	Type string   `xml:"type"`
}

func init() {
	t["HostPortGroupPort"] = reflect.TypeOf((*HostPortGroupPort)(nil)).Elem()
}

type HostPortGroupProfile struct {
	PortGroupProfile

	IpConfig IpAddressProfile `xml:"ipConfig"`
}

func init() {
	t["HostPortGroupProfile"] = reflect.TypeOf((*HostPortGroupProfile)(nil)).Elem()
}

type HostPortGroupSpec struct {
	DynamicData

	Name        string            `xml:"name"`
	VlanId      int               `xml:"vlanId"`
	VswitchName string            `xml:"vswitchName"`
	Policy      HostNetworkPolicy `xml:"policy"`
}

func init() {
	t["HostPortGroupSpec"] = reflect.TypeOf((*HostPortGroupSpec)(nil)).Elem()
}

type HostPosixAccountSpec struct {
	HostAccountSpec

	PosixId     int   `xml:"posixId,omitempty"`
	ShellAccess *bool `xml:"shellAccess"`
}

func init() {
	t["HostPosixAccountSpec"] = reflect.TypeOf((*HostPosixAccountSpec)(nil)).Elem()
}

type HostPowerOpFailed struct {
	VimFault
}

func init() {
	t["HostPowerOpFailed"] = reflect.TypeOf((*HostPowerOpFailed)(nil)).Elem()
}

type HostPowerOpFailedFault BaseHostPowerOpFailed

func init() {
	t["HostPowerOpFailedFault"] = reflect.TypeOf((*HostPowerOpFailedFault)(nil)).Elem()
}

type HostPowerPolicy struct {
	DynamicData

	Key         int    `xml:"key"`
	Name        string `xml:"name"`
	ShortName   string `xml:"shortName"`
	Description string `xml:"description"`
}

func init() {
	t["HostPowerPolicy"] = reflect.TypeOf((*HostPowerPolicy)(nil)).Elem()
}

type HostPrimaryAgentNotShortNameEvent struct {
	HostDasEvent

	PrimaryAgent string `xml:"primaryAgent"`
}

func init() {
	t["HostPrimaryAgentNotShortNameEvent"] = reflect.TypeOf((*HostPrimaryAgentNotShortNameEvent)(nil)).Elem()
}

type HostProfileAppliedEvent struct {
	HostEvent

	Profile ProfileEventArgument `xml:"profile"`
}

func init() {
	t["HostProfileAppliedEvent"] = reflect.TypeOf((*HostProfileAppliedEvent)(nil)).Elem()
}

type HostProfileCompleteConfigSpec struct {
	HostProfileConfigSpec

	ApplyProfile                  *HostApplyProfile       `xml:"applyProfile,omitempty"`
	CustomComplyProfile           *ComplianceProfile      `xml:"customComplyProfile,omitempty"`
	DisabledExpressionListChanged bool                    `xml:"disabledExpressionListChanged"`
	DisabledExpressionList        []string                `xml:"disabledExpressionList,omitempty"`
	ValidatorHost                 *ManagedObjectReference `xml:"validatorHost,omitempty"`
}

func init() {
	t["HostProfileCompleteConfigSpec"] = reflect.TypeOf((*HostProfileCompleteConfigSpec)(nil)).Elem()
}

type HostProfileConfigInfo struct {
	ProfileConfigInfo

	ApplyProfile           *HostApplyProfile   `xml:"applyProfile,omitempty"`
	DefaultComplyProfile   *ComplianceProfile  `xml:"defaultComplyProfile,omitempty"`
	DefaultComplyLocator   []ComplianceLocator `xml:"defaultComplyLocator,omitempty"`
	CustomComplyProfile    *ComplianceProfile  `xml:"customComplyProfile,omitempty"`
	DisabledExpressionList []string            `xml:"disabledExpressionList,omitempty"`
}

func init() {
	t["HostProfileConfigInfo"] = reflect.TypeOf((*HostProfileConfigInfo)(nil)).Elem()
}

type HostProfileConfigSpec struct {
	ProfileCreateSpec
}

func init() {
	t["HostProfileConfigSpec"] = reflect.TypeOf((*HostProfileConfigSpec)(nil)).Elem()
}

type HostProfileHostBasedConfigSpec struct {
	HostProfileConfigSpec

	Host                 ManagedObjectReference `xml:"host"`
	UseHostProfileEngine *bool                  `xml:"useHostProfileEngine"`
}

func init() {
	t["HostProfileHostBasedConfigSpec"] = reflect.TypeOf((*HostProfileHostBasedConfigSpec)(nil)).Elem()
}

type HostProfileManagerConfigTaskList struct {
	DynamicData

	ConfigSpec      *HostConfigSpec      `xml:"configSpec,omitempty"`
	TaskDescription []LocalizableMessage `xml:"taskDescription,omitempty"`
}

func init() {
	t["HostProfileManagerConfigTaskList"] = reflect.TypeOf((*HostProfileManagerConfigTaskList)(nil)).Elem()
}

type HostProfileSerializedHostProfileSpec struct {
	ProfileSerializedCreateSpec

	ValidatorHost *ManagedObjectReference `xml:"validatorHost,omitempty"`
}

func init() {
	t["HostProfileSerializedHostProfileSpec"] = reflect.TypeOf((*HostProfileSerializedHostProfileSpec)(nil)).Elem()
}

type HostProxySwitch struct {
	DynamicData

	DvsUuid                     string                         `xml:"dvsUuid"`
	DvsName                     string                         `xml:"dvsName"`
	Key                         string                         `xml:"key"`
	NumPorts                    int                            `xml:"numPorts"`
	ConfigNumPorts              int                            `xml:"configNumPorts,omitempty"`
	NumPortsAvailable           int                            `xml:"numPortsAvailable"`
	UplinkPort                  []KeyValue                     `xml:"uplinkPort,omitempty"`
	Mtu                         int                            `xml:"mtu,omitempty"`
	Pnic                        []string                       `xml:"pnic,omitempty"`
	Spec                        HostProxySwitchSpec            `xml:"spec"`
	HostLag                     []HostProxySwitchHostLagConfig `xml:"hostLag,omitempty"`
	NetworkReservationSupported *bool                          `xml:"networkReservationSupported"`
}

func init() {
	t["HostProxySwitch"] = reflect.TypeOf((*HostProxySwitch)(nil)).Elem()
}

type HostProxySwitchConfig struct {
	DynamicData

	ChangeOperation string               `xml:"changeOperation,omitempty"`
	Uuid            string               `xml:"uuid"`
	Spec            *HostProxySwitchSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostProxySwitchConfig"] = reflect.TypeOf((*HostProxySwitchConfig)(nil)).Elem()
}

type HostProxySwitchHostLagConfig struct {
	DynamicData

	LagKey     string     `xml:"lagKey"`
	LagName    string     `xml:"lagName,omitempty"`
	UplinkPort []KeyValue `xml:"uplinkPort,omitempty"`
}

func init() {
	t["HostProxySwitchHostLagConfig"] = reflect.TypeOf((*HostProxySwitchHostLagConfig)(nil)).Elem()
}

type HostProxySwitchSpec struct {
	DynamicData

	Backing BaseDistributedVirtualSwitchHostMemberBacking `xml:"backing,omitempty,typeattr"`
}

func init() {
	t["HostProxySwitchSpec"] = reflect.TypeOf((*HostProxySwitchSpec)(nil)).Elem()
}

type HostReconnectionFailedEvent struct {
	HostEvent
}

func init() {
	t["HostReconnectionFailedEvent"] = reflect.TypeOf((*HostReconnectionFailedEvent)(nil)).Elem()
}

type HostReliableMemoryInfo struct {
	DynamicData

	MemorySize int64 `xml:"memorySize"`
}

func init() {
	t["HostReliableMemoryInfo"] = reflect.TypeOf((*HostReliableMemoryInfo)(nil)).Elem()
}

type HostRemoveVFlashResource HostRemoveVFlashResourceRequestType

func init() {
	t["HostRemoveVFlashResource"] = reflect.TypeOf((*HostRemoveVFlashResource)(nil)).Elem()
}

type HostRemoveVFlashResourceRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HostRemoveVFlashResourceRequestType"] = reflect.TypeOf((*HostRemoveVFlashResourceRequestType)(nil)).Elem()
}

type HostRemoveVFlashResourceResponse struct {
}

type HostRemovedEvent struct {
	HostEvent
}

func init() {
	t["HostRemovedEvent"] = reflect.TypeOf((*HostRemovedEvent)(nil)).Elem()
}

type HostResignatureRescanResult struct {
	DynamicData

	Rescan []HostVmfsRescanResult `xml:"rescan,omitempty"`
	Result ManagedObjectReference `xml:"result"`
}

func init() {
	t["HostResignatureRescanResult"] = reflect.TypeOf((*HostResignatureRescanResult)(nil)).Elem()
}

type HostRuntimeInfo struct {
	DynamicData

	ConnectionState            HostSystemConnectionState                   `xml:"connectionState"`
	PowerState                 HostSystemPowerState                        `xml:"powerState"`
	StandbyMode                string                                      `xml:"standbyMode,omitempty"`
	InMaintenanceMode          bool                                        `xml:"inMaintenanceMode"`
	BootTime                   *time.Time                                  `xml:"bootTime"`
	HealthSystemRuntime        *HealthSystemRuntime                        `xml:"healthSystemRuntime,omitempty"`
	DasHostState               *ClusterDasFdmHostState                     `xml:"dasHostState,omitempty"`
	TpmPcrValues               []HostTpmDigestInfo                         `xml:"tpmPcrValues,omitempty"`
	VsanRuntimeInfo            *VsanHostRuntimeInfo                        `xml:"vsanRuntimeInfo,omitempty"`
	NetworkRuntimeInfo         *HostRuntimeInfoNetworkRuntimeInfo          `xml:"networkRuntimeInfo,omitempty"`
	VFlashResourceRuntimeInfo  *HostVFlashManagerVFlashResourceRunTimeInfo `xml:"vFlashResourceRuntimeInfo,omitempty"`
	HostMaxVirtualDiskCapacity int64                                       `xml:"hostMaxVirtualDiskCapacity,omitempty"`
}

func init() {
	t["HostRuntimeInfo"] = reflect.TypeOf((*HostRuntimeInfo)(nil)).Elem()
}

type HostRuntimeInfoNetStackInstanceRuntimeInfo struct {
	DynamicData

	NetStackInstanceKey    string   `xml:"netStackInstanceKey"`
	State                  string   `xml:"state,omitempty"`
	VmknicKeys             []string `xml:"vmknicKeys,omitempty"`
	MaxNumberOfConnections int      `xml:"maxNumberOfConnections,omitempty"`
	CurrentIpV6Enabled     *bool    `xml:"currentIpV6Enabled"`
}

func init() {
	t["HostRuntimeInfoNetStackInstanceRuntimeInfo"] = reflect.TypeOf((*HostRuntimeInfoNetStackInstanceRuntimeInfo)(nil)).Elem()
}

type HostRuntimeInfoNetworkRuntimeInfo struct {
	DynamicData

	NetStackInstanceRuntimeInfo []HostRuntimeInfoNetStackInstanceRuntimeInfo `xml:"netStackInstanceRuntimeInfo,omitempty"`
}

func init() {
	t["HostRuntimeInfoNetworkRuntimeInfo"] = reflect.TypeOf((*HostRuntimeInfoNetworkRuntimeInfo)(nil)).Elem()
}

type HostScsiDisk struct {
	ScsiLun

	Capacity   HostDiskDimensionsLba `xml:"capacity"`
	DevicePath string                `xml:"devicePath"`
	Ssd        *bool                 `xml:"ssd"`
}

func init() {
	t["HostScsiDisk"] = reflect.TypeOf((*HostScsiDisk)(nil)).Elem()
}

type HostScsiDiskPartition struct {
	DynamicData

	DiskName  string `xml:"diskName"`
	Partition int    `xml:"partition"`
}

func init() {
	t["HostScsiDiskPartition"] = reflect.TypeOf((*HostScsiDiskPartition)(nil)).Elem()
}

type HostScsiTopology struct {
	DynamicData

	Adapter []HostScsiTopologyInterface `xml:"adapter,omitempty"`
}

func init() {
	t["HostScsiTopology"] = reflect.TypeOf((*HostScsiTopology)(nil)).Elem()
}

type HostScsiTopologyInterface struct {
	DynamicData

	Key     string                   `xml:"key"`
	Adapter string                   `xml:"adapter"`
	Target  []HostScsiTopologyTarget `xml:"target,omitempty"`
}

func init() {
	t["HostScsiTopologyInterface"] = reflect.TypeOf((*HostScsiTopologyInterface)(nil)).Elem()
}

type HostScsiTopologyLun struct {
	DynamicData

	Key     string `xml:"key"`
	Lun     int    `xml:"lun"`
	ScsiLun string `xml:"scsiLun"`
}

func init() {
	t["HostScsiTopologyLun"] = reflect.TypeOf((*HostScsiTopologyLun)(nil)).Elem()
}

type HostScsiTopologyTarget struct {
	DynamicData

	Key       string                  `xml:"key"`
	Target    int                     `xml:"target"`
	Lun       []HostScsiTopologyLun   `xml:"lun,omitempty"`
	Transport BaseHostTargetTransport `xml:"transport,omitempty,typeattr"`
}

func init() {
	t["HostScsiTopologyTarget"] = reflect.TypeOf((*HostScsiTopologyTarget)(nil)).Elem()
}

type HostSecuritySpec struct {
	DynamicData

	AdminPassword    string       `xml:"adminPassword,omitempty"`
	RemovePermission []Permission `xml:"removePermission,omitempty"`
	AddPermission    []Permission `xml:"addPermission,omitempty"`
}

func init() {
	t["HostSecuritySpec"] = reflect.TypeOf((*HostSecuritySpec)(nil)).Elem()
}

type HostService struct {
	DynamicData

	Key           string                    `xml:"key"`
	Label         string                    `xml:"label"`
	Required      bool                      `xml:"required"`
	Uninstallable bool                      `xml:"uninstallable"`
	Running       bool                      `xml:"running"`
	Ruleset       []string                  `xml:"ruleset,omitempty"`
	Policy        string                    `xml:"policy"`
	SourcePackage *HostServiceSourcePackage `xml:"sourcePackage,omitempty"`
}

func init() {
	t["HostService"] = reflect.TypeOf((*HostService)(nil)).Elem()
}

type HostServiceConfig struct {
	DynamicData

	ServiceId     string `xml:"serviceId"`
	StartupPolicy string `xml:"startupPolicy"`
}

func init() {
	t["HostServiceConfig"] = reflect.TypeOf((*HostServiceConfig)(nil)).Elem()
}

type HostServiceInfo struct {
	DynamicData

	Service []HostService `xml:"service,omitempty"`
}

func init() {
	t["HostServiceInfo"] = reflect.TypeOf((*HostServiceInfo)(nil)).Elem()
}

type HostServiceSourcePackage struct {
	DynamicData

	SourcePackageName string `xml:"sourcePackageName"`
	Description       string `xml:"description"`
}

func init() {
	t["HostServiceSourcePackage"] = reflect.TypeOf((*HostServiceSourcePackage)(nil)).Elem()
}

type HostServiceTicket struct {
	DynamicData

	Host           string `xml:"host,omitempty"`
	Port           int    `xml:"port,omitempty"`
	SslThumbprint  string `xml:"sslThumbprint,omitempty"`
	Service        string `xml:"service"`
	ServiceVersion string `xml:"serviceVersion"`
	SessionId      string `xml:"sessionId"`
}

func init() {
	t["HostServiceTicket"] = reflect.TypeOf((*HostServiceTicket)(nil)).Elem()
}

type HostShortNameInconsistentEvent struct {
	HostDasEvent

	ShortName  string `xml:"shortName"`
	ShortName2 string `xml:"shortName2"`
}

func init() {
	t["HostShortNameInconsistentEvent"] = reflect.TypeOf((*HostShortNameInconsistentEvent)(nil)).Elem()
}

type HostShortNameToIpFailedEvent struct {
	HostEvent

	ShortName string `xml:"shortName"`
}

func init() {
	t["HostShortNameToIpFailedEvent"] = reflect.TypeOf((*HostShortNameToIpFailedEvent)(nil)).Elem()
}

type HostShutdownEvent struct {
	HostEvent

	Reason string `xml:"reason"`
}

func init() {
	t["HostShutdownEvent"] = reflect.TypeOf((*HostShutdownEvent)(nil)).Elem()
}

type HostSnmpConfigSpec struct {
	DynamicData

	Enabled             *bool                 `xml:"enabled"`
	Port                int                   `xml:"port,omitempty"`
	ReadOnlyCommunities []string              `xml:"readOnlyCommunities,omitempty"`
	TrapTargets         []HostSnmpDestination `xml:"trapTargets,omitempty"`
	Option              []KeyValue            `xml:"option,omitempty"`
}

func init() {
	t["HostSnmpConfigSpec"] = reflect.TypeOf((*HostSnmpConfigSpec)(nil)).Elem()
}

type HostSnmpDestination struct {
	DynamicData

	HostName  string `xml:"hostName"`
	Port      int    `xml:"port"`
	Community string `xml:"community"`
}

func init() {
	t["HostSnmpDestination"] = reflect.TypeOf((*HostSnmpDestination)(nil)).Elem()
}

type HostSnmpSystemAgentLimits struct {
	DynamicData

	MaxReadOnlyCommunities int                     `xml:"maxReadOnlyCommunities"`
	MaxTrapDestinations    int                     `xml:"maxTrapDestinations"`
	MaxCommunityLength     int                     `xml:"maxCommunityLength"`
	MaxBufferSize          int                     `xml:"maxBufferSize"`
	Capability             HostSnmpAgentCapability `xml:"capability,omitempty"`
}

func init() {
	t["HostSnmpSystemAgentLimits"] = reflect.TypeOf((*HostSnmpSystemAgentLimits)(nil)).Elem()
}

type HostSriovConfig struct {
	HostPciPassthruConfig

	SriovEnabled       bool `xml:"sriovEnabled"`
	NumVirtualFunction int  `xml:"numVirtualFunction"`
}

func init() {
	t["HostSriovConfig"] = reflect.TypeOf((*HostSriovConfig)(nil)).Elem()
}

type HostSriovInfo struct {
	HostPciPassthruInfo

	SriovEnabled                bool `xml:"sriovEnabled"`
	SriovCapable                bool `xml:"sriovCapable"`
	SriovActive                 bool `xml:"sriovActive"`
	NumVirtualFunctionRequested int  `xml:"numVirtualFunctionRequested"`
	NumVirtualFunction          int  `xml:"numVirtualFunction"`
	MaxVirtualFunctionSupported int  `xml:"maxVirtualFunctionSupported"`
}

func init() {
	t["HostSriovInfo"] = reflect.TypeOf((*HostSriovInfo)(nil)).Elem()
}

type HostSslThumbprintInfo struct {
	DynamicData

	Principal      string   `xml:"principal"`
	OwnerTag       string   `xml:"ownerTag,omitempty"`
	SslThumbprints []string `xml:"sslThumbprints,omitempty"`
}

func init() {
	t["HostSslThumbprintInfo"] = reflect.TypeOf((*HostSslThumbprintInfo)(nil)).Elem()
}

type HostStatusChangedEvent struct {
	ClusterStatusChangedEvent
}

func init() {
	t["HostStatusChangedEvent"] = reflect.TypeOf((*HostStatusChangedEvent)(nil)).Elem()
}

type HostStorageArrayTypePolicyOption struct {
	DynamicData

	Policy BaseElementDescription `xml:"policy,typeattr"`
}

func init() {
	t["HostStorageArrayTypePolicyOption"] = reflect.TypeOf((*HostStorageArrayTypePolicyOption)(nil)).Elem()
}

type HostStorageDeviceInfo struct {
	DynamicData

	HostBusAdapter              []BaseHostHostBusAdapter `xml:"hostBusAdapter,omitempty,typeattr"`
	ScsiLun                     []BaseScsiLun            `xml:"scsiLun,omitempty,typeattr"`
	ScsiTopology                *HostScsiTopology        `xml:"scsiTopology,omitempty"`
	MultipathInfo               *HostMultipathInfo       `xml:"multipathInfo,omitempty"`
	PlugStoreTopology           *HostPlugStoreTopology   `xml:"plugStoreTopology,omitempty"`
	SoftwareInternetScsiEnabled bool                     `xml:"softwareInternetScsiEnabled"`
}

func init() {
	t["HostStorageDeviceInfo"] = reflect.TypeOf((*HostStorageDeviceInfo)(nil)).Elem()
}

type HostStorageElementInfo struct {
	HostHardwareElementInfo

	OperationalInfo []HostStorageOperationalInfo `xml:"operationalInfo,omitempty"`
}

func init() {
	t["HostStorageElementInfo"] = reflect.TypeOf((*HostStorageElementInfo)(nil)).Elem()
}

type HostStorageOperationalInfo struct {
	DynamicData

	Property string `xml:"property"`
	Value    string `xml:"value"`
}

func init() {
	t["HostStorageOperationalInfo"] = reflect.TypeOf((*HostStorageOperationalInfo)(nil)).Elem()
}

type HostSyncFailedEvent struct {
	HostEvent

	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["HostSyncFailedEvent"] = reflect.TypeOf((*HostSyncFailedEvent)(nil)).Elem()
}

type HostSystemHealthInfo struct {
	DynamicData

	NumericSensorInfo []HostNumericSensorInfo `xml:"numericSensorInfo,omitempty"`
}

func init() {
	t["HostSystemHealthInfo"] = reflect.TypeOf((*HostSystemHealthInfo)(nil)).Elem()
}

type HostSystemIdentificationInfo struct {
	DynamicData

	IdentifierValue string                 `xml:"identifierValue"`
	IdentifierType  BaseElementDescription `xml:"identifierType,typeattr"`
}

func init() {
	t["HostSystemIdentificationInfo"] = reflect.TypeOf((*HostSystemIdentificationInfo)(nil)).Elem()
}

type HostSystemInfo struct {
	DynamicData

	Vendor               string                         `xml:"vendor"`
	Model                string                         `xml:"model"`
	Uuid                 string                         `xml:"uuid"`
	OtherIdentifyingInfo []HostSystemIdentificationInfo `xml:"otherIdentifyingInfo,omitempty"`
}

func init() {
	t["HostSystemInfo"] = reflect.TypeOf((*HostSystemInfo)(nil)).Elem()
}

type HostSystemReconnectSpec struct {
	DynamicData

	SyncState *bool `xml:"syncState"`
}

func init() {
	t["HostSystemReconnectSpec"] = reflect.TypeOf((*HostSystemReconnectSpec)(nil)).Elem()
}

type HostSystemResourceInfo struct {
	DynamicData

	Key    string                   `xml:"key"`
	Config *ResourceConfigSpec      `xml:"config,omitempty"`
	Child  []HostSystemResourceInfo `xml:"child,omitempty"`
}

func init() {
	t["HostSystemResourceInfo"] = reflect.TypeOf((*HostSystemResourceInfo)(nil)).Elem()
}

type HostSystemSwapConfiguration struct {
	DynamicData

	Option []BaseHostSystemSwapConfigurationSystemSwapOption `xml:"option,omitempty,typeattr"`
}

func init() {
	t["HostSystemSwapConfiguration"] = reflect.TypeOf((*HostSystemSwapConfiguration)(nil)).Elem()
}

type HostSystemSwapConfigurationDatastoreOption struct {
	HostSystemSwapConfigurationSystemSwapOption

	Datastore string `xml:"datastore"`
}

func init() {
	t["HostSystemSwapConfigurationDatastoreOption"] = reflect.TypeOf((*HostSystemSwapConfigurationDatastoreOption)(nil)).Elem()
}

type HostSystemSwapConfigurationDisabledOption struct {
	HostSystemSwapConfigurationSystemSwapOption
}

func init() {
	t["HostSystemSwapConfigurationDisabledOption"] = reflect.TypeOf((*HostSystemSwapConfigurationDisabledOption)(nil)).Elem()
}

type HostSystemSwapConfigurationHostCacheOption struct {
	HostSystemSwapConfigurationSystemSwapOption
}

func init() {
	t["HostSystemSwapConfigurationHostCacheOption"] = reflect.TypeOf((*HostSystemSwapConfigurationHostCacheOption)(nil)).Elem()
}

type HostSystemSwapConfigurationHostLocalSwapOption struct {
	HostSystemSwapConfigurationSystemSwapOption
}

func init() {
	t["HostSystemSwapConfigurationHostLocalSwapOption"] = reflect.TypeOf((*HostSystemSwapConfigurationHostLocalSwapOption)(nil)).Elem()
}

type HostSystemSwapConfigurationSystemSwapOption struct {
	DynamicData

	Key int `xml:"key"`
}

func init() {
	t["HostSystemSwapConfigurationSystemSwapOption"] = reflect.TypeOf((*HostSystemSwapConfigurationSystemSwapOption)(nil)).Elem()
}

type HostTargetTransport struct {
	DynamicData
}

func init() {
	t["HostTargetTransport"] = reflect.TypeOf((*HostTargetTransport)(nil)).Elem()
}

type HostTpmAttestationReport struct {
	DynamicData

	TpmPcrValues   []HostTpmDigestInfo    `xml:"tpmPcrValues"`
	TpmEvents      []HostTpmEventLogEntry `xml:"tpmEvents"`
	TpmLogReliable bool                   `xml:"tpmLogReliable"`
}

func init() {
	t["HostTpmAttestationReport"] = reflect.TypeOf((*HostTpmAttestationReport)(nil)).Elem()
}

type HostTpmBootSecurityOptionEventDetails struct {
	HostTpmEventDetails

	BootSecurityOption string `xml:"bootSecurityOption"`
}

func init() {
	t["HostTpmBootSecurityOptionEventDetails"] = reflect.TypeOf((*HostTpmBootSecurityOptionEventDetails)(nil)).Elem()
}

type HostTpmCommandEventDetails struct {
	HostTpmEventDetails

	CommandLine string `xml:"commandLine"`
}

func init() {
	t["HostTpmCommandEventDetails"] = reflect.TypeOf((*HostTpmCommandEventDetails)(nil)).Elem()
}

type HostTpmDigestInfo struct {
	HostDigestInfo

	PcrNumber int `xml:"pcrNumber"`
}

func init() {
	t["HostTpmDigestInfo"] = reflect.TypeOf((*HostTpmDigestInfo)(nil)).Elem()
}

type HostTpmEventDetails struct {
	DynamicData

	DataHash []byte `xml:"dataHash"`
}

func init() {
	t["HostTpmEventDetails"] = reflect.TypeOf((*HostTpmEventDetails)(nil)).Elem()
}

type HostTpmEventLogEntry struct {
	DynamicData

	PcrIndex     int                     `xml:"pcrIndex"`
	EventDetails BaseHostTpmEventDetails `xml:"eventDetails,typeattr"`
}

func init() {
	t["HostTpmEventLogEntry"] = reflect.TypeOf((*HostTpmEventLogEntry)(nil)).Elem()
}

type HostTpmOptionEventDetails struct {
	HostTpmEventDetails

	OptionsFileName string `xml:"optionsFileName"`
	BootOptions     []byte `xml:"bootOptions,omitempty"`
}

func init() {
	t["HostTpmOptionEventDetails"] = reflect.TypeOf((*HostTpmOptionEventDetails)(nil)).Elem()
}

type HostTpmSoftwareComponentEventDetails struct {
	HostTpmEventDetails

	ComponentName string `xml:"componentName"`
	VibName       string `xml:"vibName"`
	VibVersion    string `xml:"vibVersion"`
	VibVendor     string `xml:"vibVendor"`
}

func init() {
	t["HostTpmSoftwareComponentEventDetails"] = reflect.TypeOf((*HostTpmSoftwareComponentEventDetails)(nil)).Elem()
}

type HostUnresolvedVmfsExtent struct {
	DynamicData

	Device       HostScsiDiskPartition `xml:"device"`
	DevicePath   string                `xml:"devicePath"`
	VmfsUuid     string                `xml:"vmfsUuid"`
	IsHeadExtent bool                  `xml:"isHeadExtent"`
	Ordinal      int                   `xml:"ordinal"`
	StartBlock   int                   `xml:"startBlock"`
	EndBlock     int                   `xml:"endBlock"`
	Reason       string                `xml:"reason"`
}

func init() {
	t["HostUnresolvedVmfsExtent"] = reflect.TypeOf((*HostUnresolvedVmfsExtent)(nil)).Elem()
}

type HostUnresolvedVmfsResignatureSpec struct {
	DynamicData

	ExtentDevicePath []string `xml:"extentDevicePath"`
}

func init() {
	t["HostUnresolvedVmfsResignatureSpec"] = reflect.TypeOf((*HostUnresolvedVmfsResignatureSpec)(nil)).Elem()
}

type HostUnresolvedVmfsResolutionResult struct {
	DynamicData

	Spec  HostUnresolvedVmfsResolutionSpec `xml:"spec"`
	Vmfs  *HostVmfsVolume                  `xml:"vmfs,omitempty"`
	Fault *LocalizedMethodFault            `xml:"fault,omitempty"`
}

func init() {
	t["HostUnresolvedVmfsResolutionResult"] = reflect.TypeOf((*HostUnresolvedVmfsResolutionResult)(nil)).Elem()
}

type HostUnresolvedVmfsResolutionSpec struct {
	DynamicData

	ExtentDevicePath []string `xml:"extentDevicePath"`
	UuidResolution   string   `xml:"uuidResolution"`
}

func init() {
	t["HostUnresolvedVmfsResolutionSpec"] = reflect.TypeOf((*HostUnresolvedVmfsResolutionSpec)(nil)).Elem()
}

type HostUnresolvedVmfsVolume struct {
	DynamicData

	Extent        []HostUnresolvedVmfsExtent            `xml:"extent"`
	VmfsLabel     string                                `xml:"vmfsLabel"`
	VmfsUuid      string                                `xml:"vmfsUuid"`
	TotalBlocks   int                                   `xml:"totalBlocks"`
	ResolveStatus HostUnresolvedVmfsVolumeResolveStatus `xml:"resolveStatus"`
}

func init() {
	t["HostUnresolvedVmfsVolume"] = reflect.TypeOf((*HostUnresolvedVmfsVolume)(nil)).Elem()
}

type HostUnresolvedVmfsVolumeResolveStatus struct {
	DynamicData

	Resolvable        bool  `xml:"resolvable"`
	IncompleteExtents *bool `xml:"incompleteExtents"`
	MultipleCopies    *bool `xml:"multipleCopies"`
}

func init() {
	t["HostUnresolvedVmfsVolumeResolveStatus"] = reflect.TypeOf((*HostUnresolvedVmfsVolumeResolveStatus)(nil)).Elem()
}

type HostUpgradeFailedEvent struct {
	HostEvent
}

func init() {
	t["HostUpgradeFailedEvent"] = reflect.TypeOf((*HostUpgradeFailedEvent)(nil)).Elem()
}

type HostUserWorldSwapNotEnabledEvent struct {
	HostEvent
}

func init() {
	t["HostUserWorldSwapNotEnabledEvent"] = reflect.TypeOf((*HostUserWorldSwapNotEnabledEvent)(nil)).Elem()
}

type HostVFlashManagerVFlashCacheConfigInfo struct {
	DynamicData

	VFlashModuleConfigOption []HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption `xml:"vFlashModuleConfigOption,omitempty"`
	DefaultVFlashModule      string                                                           `xml:"defaultVFlashModule,omitempty"`
	SwapCacheReservationInGB int64                                                            `xml:"swapCacheReservationInGB,omitempty"`
}

func init() {
	t["HostVFlashManagerVFlashCacheConfigInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashCacheConfigInfo)(nil)).Elem()
}

type HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption struct {
	DynamicData

	VFlashModule              string       `xml:"vFlashModule"`
	VFlashModuleVersion       string       `xml:"vFlashModuleVersion"`
	MinSupportedModuleVersion string       `xml:"minSupportedModuleVersion"`
	CacheConsistencyType      ChoiceOption `xml:"cacheConsistencyType"`
	CacheMode                 ChoiceOption `xml:"cacheMode"`
	BlockSizeInKBOption       LongOption   `xml:"blockSizeInKBOption"`
	ReservationInMBOption     LongOption   `xml:"reservationInMBOption"`
	MaxDiskSizeInKB           int64        `xml:"maxDiskSizeInKB"`
}

func init() {
	t["HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption"] = reflect.TypeOf((*HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption)(nil)).Elem()
}

type HostVFlashManagerVFlashCacheConfigSpec struct {
	DynamicData

	DefaultVFlashModule      string `xml:"defaultVFlashModule"`
	SwapCacheReservationInGB int64  `xml:"swapCacheReservationInGB"`
}

func init() {
	t["HostVFlashManagerVFlashCacheConfigSpec"] = reflect.TypeOf((*HostVFlashManagerVFlashCacheConfigSpec)(nil)).Elem()
}

type HostVFlashManagerVFlashConfigInfo struct {
	DynamicData

	VFlashResourceConfigInfo *HostVFlashManagerVFlashResourceConfigInfo `xml:"vFlashResourceConfigInfo,omitempty"`
	VFlashCacheConfigInfo    *HostVFlashManagerVFlashCacheConfigInfo    `xml:"vFlashCacheConfigInfo,omitempty"`
}

func init() {
	t["HostVFlashManagerVFlashConfigInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashConfigInfo)(nil)).Elem()
}

type HostVFlashManagerVFlashResourceConfigInfo struct {
	DynamicData

	Vffs     *HostVffsVolume `xml:"vffs,omitempty"`
	Capacity int64           `xml:"capacity"`
}

func init() {
	t["HostVFlashManagerVFlashResourceConfigInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashResourceConfigInfo)(nil)).Elem()
}

type HostVFlashManagerVFlashResourceConfigSpec struct {
	DynamicData

	VffsUuid string `xml:"vffsUuid"`
}

func init() {
	t["HostVFlashManagerVFlashResourceConfigSpec"] = reflect.TypeOf((*HostVFlashManagerVFlashResourceConfigSpec)(nil)).Elem()
}

type HostVFlashManagerVFlashResourceRunTimeInfo struct {
	DynamicData

	Usage              int64 `xml:"usage"`
	Capacity           int64 `xml:"capacity"`
	Accessible         bool  `xml:"accessible"`
	CapacityForVmCache int64 `xml:"capacityForVmCache"`
	FreeForVmCache     int64 `xml:"freeForVmCache"`
}

func init() {
	t["HostVFlashManagerVFlashResourceRunTimeInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashResourceRunTimeInfo)(nil)).Elem()
}

type HostVFlashResourceConfigurationResult struct {
	DynamicData

	DevicePath              []string                      `xml:"devicePath,omitempty"`
	Vffs                    *HostVffsVolume               `xml:"vffs,omitempty"`
	DiskConfigurationResult []HostDiskConfigurationResult `xml:"diskConfigurationResult,omitempty"`
}

func init() {
	t["HostVFlashResourceConfigurationResult"] = reflect.TypeOf((*HostVFlashResourceConfigurationResult)(nil)).Elem()
}

type HostVMotionCompatibility struct {
	DynamicData

	Host          ManagedObjectReference `xml:"host"`
	Compatibility []string               `xml:"compatibility,omitempty"`
}

func init() {
	t["HostVMotionCompatibility"] = reflect.TypeOf((*HostVMotionCompatibility)(nil)).Elem()
}

type HostVMotionConfig struct {
	DynamicData

	VmotionNicKey string `xml:"vmotionNicKey,omitempty"`
	Enabled       bool   `xml:"enabled"`
}

func init() {
	t["HostVMotionConfig"] = reflect.TypeOf((*HostVMotionConfig)(nil)).Elem()
}

type HostVMotionInfo struct {
	DynamicData

	NetConfig *HostVMotionNetConfig `xml:"netConfig,omitempty"`
	IpConfig  *HostIpConfig         `xml:"ipConfig,omitempty"`
}

func init() {
	t["HostVMotionInfo"] = reflect.TypeOf((*HostVMotionInfo)(nil)).Elem()
}

type HostVMotionNetConfig struct {
	DynamicData

	CandidateVnic []HostVirtualNic `xml:"candidateVnic,omitempty"`
	SelectedVnic  string           `xml:"selectedVnic,omitempty"`
}

func init() {
	t["HostVMotionNetConfig"] = reflect.TypeOf((*HostVMotionNetConfig)(nil)).Elem()
}

type HostVfatVolume struct {
	HostFileSystemVolume
}

func init() {
	t["HostVfatVolume"] = reflect.TypeOf((*HostVfatVolume)(nil)).Elem()
}

type HostVffsSpec struct {
	DynamicData

	DevicePath   string                 `xml:"devicePath"`
	Partition    *HostDiskPartitionSpec `xml:"partition,omitempty"`
	MajorVersion int                    `xml:"majorVersion"`
	VolumeName   string                 `xml:"volumeName"`
}

func init() {
	t["HostVffsSpec"] = reflect.TypeOf((*HostVffsSpec)(nil)).Elem()
}

type HostVffsVolume struct {
	HostFileSystemVolume

	MajorVersion int                     `xml:"majorVersion"`
	Version      string                  `xml:"version"`
	Uuid         string                  `xml:"uuid"`
	Extent       []HostScsiDiskPartition `xml:"extent"`
}

func init() {
	t["HostVffsVolume"] = reflect.TypeOf((*HostVffsVolume)(nil)).Elem()
}

type HostVirtualNic struct {
	DynamicData

	Device    string             `xml:"device"`
	Key       string             `xml:"key"`
	Portgroup string             `xml:"portgroup"`
	Spec      HostVirtualNicSpec `xml:"spec"`
	Port      string             `xml:"port,omitempty"`
}

func init() {
	t["HostVirtualNic"] = reflect.TypeOf((*HostVirtualNic)(nil)).Elem()
}

type HostVirtualNicConfig struct {
	DynamicData

	ChangeOperation string              `xml:"changeOperation,omitempty"`
	Device          string              `xml:"device,omitempty"`
	Portgroup       string              `xml:"portgroup"`
	Spec            *HostVirtualNicSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostVirtualNicConfig"] = reflect.TypeOf((*HostVirtualNicConfig)(nil)).Elem()
}

type HostVirtualNicConnection struct {
	DynamicData

	Portgroup string                                  `xml:"portgroup,omitempty"`
	DvPort    *DistributedVirtualSwitchPortConnection `xml:"dvPort,omitempty"`
}

func init() {
	t["HostVirtualNicConnection"] = reflect.TypeOf((*HostVirtualNicConnection)(nil)).Elem()
}

type HostVirtualNicManagerInfo struct {
	DynamicData

	NetConfig []VirtualNicManagerNetConfig `xml:"netConfig,omitempty"`
}

func init() {
	t["HostVirtualNicManagerInfo"] = reflect.TypeOf((*HostVirtualNicManagerInfo)(nil)).Elem()
}

type HostVirtualNicManagerNicTypeSelection struct {
	DynamicData

	Vnic    HostVirtualNicConnection `xml:"vnic"`
	NicType []string                 `xml:"nicType,omitempty"`
}

func init() {
	t["HostVirtualNicManagerNicTypeSelection"] = reflect.TypeOf((*HostVirtualNicManagerNicTypeSelection)(nil)).Elem()
}

type HostVirtualNicSpec struct {
	DynamicData

	Ip                     *HostIpConfig                           `xml:"ip,omitempty"`
	Mac                    string                                  `xml:"mac,omitempty"`
	DistributedVirtualPort *DistributedVirtualSwitchPortConnection `xml:"distributedVirtualPort,omitempty"`
	Portgroup              string                                  `xml:"portgroup,omitempty"`
	Mtu                    int                                     `xml:"mtu,omitempty"`
	TsoEnabled             *bool                                   `xml:"tsoEnabled"`
	NetStackInstanceKey    string                                  `xml:"netStackInstanceKey,omitempty"`
}

func init() {
	t["HostVirtualNicSpec"] = reflect.TypeOf((*HostVirtualNicSpec)(nil)).Elem()
}

type HostVirtualSwitch struct {
	DynamicData

	Name              string                `xml:"name"`
	Key               string                `xml:"key"`
	NumPorts          int                   `xml:"numPorts"`
	NumPortsAvailable int                   `xml:"numPortsAvailable"`
	Mtu               int                   `xml:"mtu,omitempty"`
	Portgroup         []string              `xml:"portgroup,omitempty"`
	Pnic              []string              `xml:"pnic,omitempty"`
	Spec              HostVirtualSwitchSpec `xml:"spec"`
}

func init() {
	t["HostVirtualSwitch"] = reflect.TypeOf((*HostVirtualSwitch)(nil)).Elem()
}

type HostVirtualSwitchAutoBridge struct {
	HostVirtualSwitchBridge

	ExcludedNicDevice []string `xml:"excludedNicDevice,omitempty"`
}

func init() {
	t["HostVirtualSwitchAutoBridge"] = reflect.TypeOf((*HostVirtualSwitchAutoBridge)(nil)).Elem()
}

type HostVirtualSwitchBeaconConfig struct {
	DynamicData

	Interval int `xml:"interval"`
}

func init() {
	t["HostVirtualSwitchBeaconConfig"] = reflect.TypeOf((*HostVirtualSwitchBeaconConfig)(nil)).Elem()
}

type HostVirtualSwitchBondBridge struct {
	HostVirtualSwitchBridge

	NicDevice                   []string                       `xml:"nicDevice"`
	Beacon                      *HostVirtualSwitchBeaconConfig `xml:"beacon,omitempty"`
	LinkDiscoveryProtocolConfig *LinkDiscoveryProtocolConfig   `xml:"linkDiscoveryProtocolConfig,omitempty"`
}

func init() {
	t["HostVirtualSwitchBondBridge"] = reflect.TypeOf((*HostVirtualSwitchBondBridge)(nil)).Elem()
}

type HostVirtualSwitchBridge struct {
	DynamicData
}

func init() {
	t["HostVirtualSwitchBridge"] = reflect.TypeOf((*HostVirtualSwitchBridge)(nil)).Elem()
}

type HostVirtualSwitchConfig struct {
	DynamicData

	ChangeOperation string                 `xml:"changeOperation,omitempty"`
	Name            string                 `xml:"name"`
	Spec            *HostVirtualSwitchSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostVirtualSwitchConfig"] = reflect.TypeOf((*HostVirtualSwitchConfig)(nil)).Elem()
}

type HostVirtualSwitchSimpleBridge struct {
	HostVirtualSwitchBridge

	NicDevice string `xml:"nicDevice"`
}

func init() {
	t["HostVirtualSwitchSimpleBridge"] = reflect.TypeOf((*HostVirtualSwitchSimpleBridge)(nil)).Elem()
}

type HostVirtualSwitchSpec struct {
	DynamicData

	NumPorts int                         `xml:"numPorts"`
	Bridge   BaseHostVirtualSwitchBridge `xml:"bridge,omitempty,typeattr"`
	Policy   *HostNetworkPolicy          `xml:"policy,omitempty"`
	Mtu      int                         `xml:"mtu,omitempty"`
}

func init() {
	t["HostVirtualSwitchSpec"] = reflect.TypeOf((*HostVirtualSwitchSpec)(nil)).Elem()
}

type HostVmciAccessManagerAccessSpec struct {
	DynamicData

	Vm       ManagedObjectReference `xml:"vm"`
	Services []string               `xml:"services,omitempty"`
	Mode     string                 `xml:"mode"`
}

func init() {
	t["HostVmciAccessManagerAccessSpec"] = reflect.TypeOf((*HostVmciAccessManagerAccessSpec)(nil)).Elem()
}

type HostVmfsRescanResult struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Fault *LocalizedMethodFault  `xml:"fault,omitempty"`
}

func init() {
	t["HostVmfsRescanResult"] = reflect.TypeOf((*HostVmfsRescanResult)(nil)).Elem()
}

type HostVmfsSpec struct {
	DynamicData

	Extent       HostScsiDiskPartition `xml:"extent"`
	BlockSizeMb  int                   `xml:"blockSizeMb,omitempty"`
	MajorVersion int                   `xml:"majorVersion"`
	VolumeName   string                `xml:"volumeName"`
}

func init() {
	t["HostVmfsSpec"] = reflect.TypeOf((*HostVmfsSpec)(nil)).Elem()
}

type HostVmfsVolume struct {
	HostFileSystemVolume

	BlockSizeMb      int                     `xml:"blockSizeMb"`
	MaxBlocks        int                     `xml:"maxBlocks"`
	MajorVersion     int                     `xml:"majorVersion"`
	Version          string                  `xml:"version"`
	Uuid             string                  `xml:"uuid"`
	Extent           []HostScsiDiskPartition `xml:"extent"`
	VmfsUpgradable   bool                    `xml:"vmfsUpgradable"`
	ForceMountedInfo *HostForceMountedInfo   `xml:"forceMountedInfo,omitempty"`
	Ssd              *bool                   `xml:"ssd"`
	Local            *bool                   `xml:"local"`
}

func init() {
	t["HostVmfsVolume"] = reflect.TypeOf((*HostVmfsVolume)(nil)).Elem()
}

type HostVnicConnectedToCustomizedDVPortEvent struct {
	HostEvent

	Vnic VnicPortArgument `xml:"vnic"`
}

func init() {
	t["HostVnicConnectedToCustomizedDVPortEvent"] = reflect.TypeOf((*HostVnicConnectedToCustomizedDVPortEvent)(nil)).Elem()
}

type HostVsanInternalSystemCmmdsQuery struct {
	DynamicData

	Type  string `xml:"type,omitempty"`
	Uuid  string `xml:"uuid,omitempty"`
	Owner string `xml:"owner,omitempty"`
}

func init() {
	t["HostVsanInternalSystemCmmdsQuery"] = reflect.TypeOf((*HostVsanInternalSystemCmmdsQuery)(nil)).Elem()
}

type HostWwnChangedEvent struct {
	HostEvent

	OldNodeWwns []int64 `xml:"oldNodeWwns,omitempty"`
	OldPortWwns []int64 `xml:"oldPortWwns,omitempty"`
	NewNodeWwns []int64 `xml:"newNodeWwns,omitempty"`
	NewPortWwns []int64 `xml:"newPortWwns,omitempty"`
}

func init() {
	t["HostWwnChangedEvent"] = reflect.TypeOf((*HostWwnChangedEvent)(nil)).Elem()
}

type HostWwnConflictEvent struct {
	HostEvent

	ConflictedVms   []VmEventArgument   `xml:"conflictedVms,omitempty"`
	ConflictedHosts []HostEventArgument `xml:"conflictedHosts,omitempty"`
	Wwn             int64               `xml:"wwn"`
}

func init() {
	t["HostWwnConflictEvent"] = reflect.TypeOf((*HostWwnConflictEvent)(nil)).Elem()
}

type HotSnapshotMoveNotSupported struct {
	SnapshotCopyNotSupported
}

func init() {
	t["HotSnapshotMoveNotSupported"] = reflect.TypeOf((*HotSnapshotMoveNotSupported)(nil)).Elem()
}

type HotSnapshotMoveNotSupportedFault HotSnapshotMoveNotSupported

func init() {
	t["HotSnapshotMoveNotSupportedFault"] = reflect.TypeOf((*HotSnapshotMoveNotSupportedFault)(nil)).Elem()
}

type HourlyTaskScheduler struct {
	RecurrentTaskScheduler

	Minute int `xml:"minute"`
}

func init() {
	t["HourlyTaskScheduler"] = reflect.TypeOf((*HourlyTaskScheduler)(nil)).Elem()
}

type HttpNfcLeaseAbort HttpNfcLeaseAbortRequestType

func init() {
	t["HttpNfcLeaseAbort"] = reflect.TypeOf((*HttpNfcLeaseAbort)(nil)).Elem()
}

type HttpNfcLeaseAbortRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Fault *LocalizedMethodFault  `xml:"fault,omitempty"`
}

func init() {
	t["HttpNfcLeaseAbortRequestType"] = reflect.TypeOf((*HttpNfcLeaseAbortRequestType)(nil)).Elem()
}

type HttpNfcLeaseAbortResponse struct {
}

type HttpNfcLeaseComplete HttpNfcLeaseCompleteRequestType

func init() {
	t["HttpNfcLeaseComplete"] = reflect.TypeOf((*HttpNfcLeaseComplete)(nil)).Elem()
}

type HttpNfcLeaseCompleteRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HttpNfcLeaseCompleteRequestType"] = reflect.TypeOf((*HttpNfcLeaseCompleteRequestType)(nil)).Elem()
}

type HttpNfcLeaseCompleteResponse struct {
}

type HttpNfcLeaseDatastoreLeaseInfo struct {
	DynamicData

	DatastoreKey string                 `xml:"datastoreKey"`
	Hosts        []HttpNfcLeaseHostInfo `xml:"hosts"`
}

func init() {
	t["HttpNfcLeaseDatastoreLeaseInfo"] = reflect.TypeOf((*HttpNfcLeaseDatastoreLeaseInfo)(nil)).Elem()
}

type HttpNfcLeaseDeviceUrl struct {
	DynamicData

	Key           string `xml:"key"`
	ImportKey     string `xml:"importKey"`
	Url           string `xml:"url"`
	SslThumbprint string `xml:"sslThumbprint"`
	Disk          *bool  `xml:"disk"`
	TargetId      string `xml:"targetId,omitempty"`
	DatastoreKey  string `xml:"datastoreKey,omitempty"`
	FileSize      int64  `xml:"fileSize,omitempty"`
}

func init() {
	t["HttpNfcLeaseDeviceUrl"] = reflect.TypeOf((*HttpNfcLeaseDeviceUrl)(nil)).Elem()
}

type HttpNfcLeaseGetManifest HttpNfcLeaseGetManifestRequestType

func init() {
	t["HttpNfcLeaseGetManifest"] = reflect.TypeOf((*HttpNfcLeaseGetManifest)(nil)).Elem()
}

type HttpNfcLeaseGetManifestRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HttpNfcLeaseGetManifestRequestType"] = reflect.TypeOf((*HttpNfcLeaseGetManifestRequestType)(nil)).Elem()
}

type HttpNfcLeaseGetManifestResponse struct {
	Returnval []HttpNfcLeaseManifestEntry `xml:"returnval,omitempty"`
}

type HttpNfcLeaseHostInfo struct {
	DynamicData

	Url           string `xml:"url"`
	SslThumbprint string `xml:"sslThumbprint"`
}

func init() {
	t["HttpNfcLeaseHostInfo"] = reflect.TypeOf((*HttpNfcLeaseHostInfo)(nil)).Elem()
}

type HttpNfcLeaseInfo struct {
	DynamicData

	Lease                 ManagedObjectReference           `xml:"lease"`
	Entity                ManagedObjectReference           `xml:"entity"`
	DeviceUrl             []HttpNfcLeaseDeviceUrl          `xml:"deviceUrl,omitempty"`
	TotalDiskCapacityInKB int64                            `xml:"totalDiskCapacityInKB"`
	LeaseTimeout          int                              `xml:"leaseTimeout"`
	HostMap               []HttpNfcLeaseDatastoreLeaseInfo `xml:"hostMap,omitempty"`
}

func init() {
	t["HttpNfcLeaseInfo"] = reflect.TypeOf((*HttpNfcLeaseInfo)(nil)).Elem()
}

type HttpNfcLeaseManifestEntry struct {
	DynamicData

	Key           string `xml:"key"`
	Sha1          string `xml:"sha1"`
	Size          int64  `xml:"size"`
	Disk          bool   `xml:"disk"`
	Capacity      int64  `xml:"capacity,omitempty"`
	PopulatedSize int64  `xml:"populatedSize,omitempty"`
}

func init() {
	t["HttpNfcLeaseManifestEntry"] = reflect.TypeOf((*HttpNfcLeaseManifestEntry)(nil)).Elem()
}

type HttpNfcLeaseProgress HttpNfcLeaseProgressRequestType

func init() {
	t["HttpNfcLeaseProgress"] = reflect.TypeOf((*HttpNfcLeaseProgress)(nil)).Elem()
}

type HttpNfcLeaseProgressRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Percent int                    `xml:"percent"`
}

func init() {
	t["HttpNfcLeaseProgressRequestType"] = reflect.TypeOf((*HttpNfcLeaseProgressRequestType)(nil)).Elem()
}

type HttpNfcLeaseProgressResponse struct {
}

type IDEDiskNotSupported struct {
	DiskNotSupported
}

func init() {
	t["IDEDiskNotSupported"] = reflect.TypeOf((*IDEDiskNotSupported)(nil)).Elem()
}

type IDEDiskNotSupportedFault IDEDiskNotSupported

func init() {
	t["IDEDiskNotSupportedFault"] = reflect.TypeOf((*IDEDiskNotSupportedFault)(nil)).Elem()
}

type IORMNotSupportedHostOnDatastore struct {
	VimFault

	Datastore     ManagedObjectReference   `xml:"datastore"`
	DatastoreName string                   `xml:"datastoreName"`
	Host          []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["IORMNotSupportedHostOnDatastore"] = reflect.TypeOf((*IORMNotSupportedHostOnDatastore)(nil)).Elem()
}

type IORMNotSupportedHostOnDatastoreFault IORMNotSupportedHostOnDatastore

func init() {
	t["IORMNotSupportedHostOnDatastoreFault"] = reflect.TypeOf((*IORMNotSupportedHostOnDatastoreFault)(nil)).Elem()
}

type IScsiBootFailureEvent struct {
	HostEvent
}

func init() {
	t["IScsiBootFailureEvent"] = reflect.TypeOf((*IScsiBootFailureEvent)(nil)).Elem()
}

type ImpersonateUser ImpersonateUserRequestType

func init() {
	t["ImpersonateUser"] = reflect.TypeOf((*ImpersonateUser)(nil)).Elem()
}

type ImpersonateUserRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
	Locale   string                 `xml:"locale,omitempty"`
}

func init() {
	t["ImpersonateUserRequestType"] = reflect.TypeOf((*ImpersonateUserRequestType)(nil)).Elem()
}

type ImpersonateUserResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type ImportCertificateForCAMRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	CertPath  string                 `xml:"certPath"`
	CamServer string                 `xml:"camServer"`
}

func init() {
	t["ImportCertificateForCAMRequestType"] = reflect.TypeOf((*ImportCertificateForCAMRequestType)(nil)).Elem()
}

type ImportCertificateForCAM_Task ImportCertificateForCAMRequestType

func init() {
	t["ImportCertificateForCAM_Task"] = reflect.TypeOf((*ImportCertificateForCAM_Task)(nil)).Elem()
}

type ImportCertificateForCAM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ImportHostAddFailure struct {
	DvsFault

	HostIp []string `xml:"hostIp"`
}

func init() {
	t["ImportHostAddFailure"] = reflect.TypeOf((*ImportHostAddFailure)(nil)).Elem()
}

type ImportHostAddFailureFault ImportHostAddFailure

func init() {
	t["ImportHostAddFailureFault"] = reflect.TypeOf((*ImportHostAddFailureFault)(nil)).Elem()
}

type ImportOperationBulkFault struct {
	DvsFault

	ImportFaults []ImportOperationBulkFaultFaultOnImport `xml:"importFaults"`
}

func init() {
	t["ImportOperationBulkFault"] = reflect.TypeOf((*ImportOperationBulkFault)(nil)).Elem()
}

type ImportOperationBulkFaultFault ImportOperationBulkFault

func init() {
	t["ImportOperationBulkFaultFault"] = reflect.TypeOf((*ImportOperationBulkFaultFault)(nil)).Elem()
}

type ImportOperationBulkFaultFaultOnImport struct {
	DynamicData

	EntityType string               `xml:"entityType,omitempty"`
	Key        string               `xml:"key,omitempty"`
	Fault      LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["ImportOperationBulkFaultFaultOnImport"] = reflect.TypeOf((*ImportOperationBulkFaultFaultOnImport)(nil)).Elem()
}

type ImportSpec struct {
	DynamicData

	EntityConfig     *VAppEntityConfigInfo `xml:"entityConfig,omitempty"`
	InstantiationOst *OvfConsumerOstNode   `xml:"instantiationOst,omitempty"`
}

func init() {
	t["ImportSpec"] = reflect.TypeOf((*ImportSpec)(nil)).Elem()
}

type ImportVApp ImportVAppRequestType

func init() {
	t["ImportVApp"] = reflect.TypeOf((*ImportVApp)(nil)).Elem()
}

type ImportVAppRequestType struct {
	This   ManagedObjectReference  `xml:"_this"`
	Spec   BaseImportSpec          `xml:"spec,typeattr"`
	Folder *ManagedObjectReference `xml:"folder,omitempty"`
	Host   *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["ImportVAppRequestType"] = reflect.TypeOf((*ImportVAppRequestType)(nil)).Elem()
}

type ImportVAppResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InUseFeatureManipulationDisallowed struct {
	NotEnoughLicenses
}

func init() {
	t["InUseFeatureManipulationDisallowed"] = reflect.TypeOf((*InUseFeatureManipulationDisallowed)(nil)).Elem()
}

type InUseFeatureManipulationDisallowedFault InUseFeatureManipulationDisallowed

func init() {
	t["InUseFeatureManipulationDisallowedFault"] = reflect.TypeOf((*InUseFeatureManipulationDisallowedFault)(nil)).Elem()
}

type InaccessibleDatastore struct {
	InvalidDatastore

	Detail string `xml:"detail,omitempty"`
}

func init() {
	t["InaccessibleDatastore"] = reflect.TypeOf((*InaccessibleDatastore)(nil)).Elem()
}

type InaccessibleDatastoreFault InaccessibleDatastore

func init() {
	t["InaccessibleDatastoreFault"] = reflect.TypeOf((*InaccessibleDatastoreFault)(nil)).Elem()
}

type InaccessibleVFlashSource struct {
	VimFault

	HostName string `xml:"hostName"`
}

func init() {
	t["InaccessibleVFlashSource"] = reflect.TypeOf((*InaccessibleVFlashSource)(nil)).Elem()
}

type InaccessibleVFlashSourceFault InaccessibleVFlashSource

func init() {
	t["InaccessibleVFlashSourceFault"] = reflect.TypeOf((*InaccessibleVFlashSourceFault)(nil)).Elem()
}

type IncompatibleDefaultDevice struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["IncompatibleDefaultDevice"] = reflect.TypeOf((*IncompatibleDefaultDevice)(nil)).Elem()
}

type IncompatibleDefaultDeviceFault IncompatibleDefaultDevice

func init() {
	t["IncompatibleDefaultDeviceFault"] = reflect.TypeOf((*IncompatibleDefaultDeviceFault)(nil)).Elem()
}

type IncompatibleHostForFtSecondary struct {
	VmFaultToleranceIssue

	Host  ManagedObjectReference `xml:"host"`
	Error []LocalizedMethodFault `xml:"error,omitempty"`
}

func init() {
	t["IncompatibleHostForFtSecondary"] = reflect.TypeOf((*IncompatibleHostForFtSecondary)(nil)).Elem()
}

type IncompatibleHostForFtSecondaryFault IncompatibleHostForFtSecondary

func init() {
	t["IncompatibleHostForFtSecondaryFault"] = reflect.TypeOf((*IncompatibleHostForFtSecondaryFault)(nil)).Elem()
}

type IncompatibleSetting struct {
	InvalidArgument

	ConflictingProperty string `xml:"conflictingProperty"`
}

func init() {
	t["IncompatibleSetting"] = reflect.TypeOf((*IncompatibleSetting)(nil)).Elem()
}

type IncompatibleSettingFault IncompatibleSetting

func init() {
	t["IncompatibleSettingFault"] = reflect.TypeOf((*IncompatibleSettingFault)(nil)).Elem()
}

type IncorrectFileType struct {
	FileFault
}

func init() {
	t["IncorrectFileType"] = reflect.TypeOf((*IncorrectFileType)(nil)).Elem()
}

type IncorrectFileTypeFault IncorrectFileType

func init() {
	t["IncorrectFileTypeFault"] = reflect.TypeOf((*IncorrectFileTypeFault)(nil)).Elem()
}

type IncorrectHostInformation struct {
	NotEnoughLicenses
}

func init() {
	t["IncorrectHostInformation"] = reflect.TypeOf((*IncorrectHostInformation)(nil)).Elem()
}

type IncorrectHostInformationEvent struct {
	LicenseEvent
}

func init() {
	t["IncorrectHostInformationEvent"] = reflect.TypeOf((*IncorrectHostInformationEvent)(nil)).Elem()
}

type IncorrectHostInformationFault IncorrectHostInformation

func init() {
	t["IncorrectHostInformationFault"] = reflect.TypeOf((*IncorrectHostInformationFault)(nil)).Elem()
}

type IndependentDiskVMotionNotSupported struct {
	MigrationFeatureNotSupported
}

func init() {
	t["IndependentDiskVMotionNotSupported"] = reflect.TypeOf((*IndependentDiskVMotionNotSupported)(nil)).Elem()
}

type IndependentDiskVMotionNotSupportedFault IndependentDiskVMotionNotSupported

func init() {
	t["IndependentDiskVMotionNotSupportedFault"] = reflect.TypeOf((*IndependentDiskVMotionNotSupportedFault)(nil)).Elem()
}

type InflateVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["InflateVirtualDiskRequestType"] = reflect.TypeOf((*InflateVirtualDiskRequestType)(nil)).Elem()
}

type InflateVirtualDisk_Task InflateVirtualDiskRequestType

func init() {
	t["InflateVirtualDisk_Task"] = reflect.TypeOf((*InflateVirtualDisk_Task)(nil)).Elem()
}

type InflateVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InfoUpgradeEvent struct {
	UpgradeEvent
}

func init() {
	t["InfoUpgradeEvent"] = reflect.TypeOf((*InfoUpgradeEvent)(nil)).Elem()
}

type InheritablePolicy struct {
	DynamicData

	Inherited bool `xml:"inherited"`
}

func init() {
	t["InheritablePolicy"] = reflect.TypeOf((*InheritablePolicy)(nil)).Elem()
}

type InitializeDisksRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Mapping []VsanHostDiskMapping  `xml:"mapping"`
}

func init() {
	t["InitializeDisksRequestType"] = reflect.TypeOf((*InitializeDisksRequestType)(nil)).Elem()
}

type InitializeDisks_Task InitializeDisksRequestType

func init() {
	t["InitializeDisks_Task"] = reflect.TypeOf((*InitializeDisks_Task)(nil)).Elem()
}

type InitializeDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InitiateFileTransferFromGuest InitiateFileTransferFromGuestRequestType

func init() {
	t["InitiateFileTransferFromGuest"] = reflect.TypeOf((*InitiateFileTransferFromGuest)(nil)).Elem()
}

type InitiateFileTransferFromGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	GuestFilePath string                  `xml:"guestFilePath"`
}

func init() {
	t["InitiateFileTransferFromGuestRequestType"] = reflect.TypeOf((*InitiateFileTransferFromGuestRequestType)(nil)).Elem()
}

type InitiateFileTransferFromGuestResponse struct {
	Returnval FileTransferInformation `xml:"returnval"`
}

type InitiateFileTransferToGuest InitiateFileTransferToGuestRequestType

func init() {
	t["InitiateFileTransferToGuest"] = reflect.TypeOf((*InitiateFileTransferToGuest)(nil)).Elem()
}

type InitiateFileTransferToGuestRequestType struct {
	This           ManagedObjectReference  `xml:"_this"`
	Vm             ManagedObjectReference  `xml:"vm"`
	Auth           BaseGuestAuthentication `xml:"auth,typeattr"`
	GuestFilePath  string                  `xml:"guestFilePath"`
	FileAttributes BaseGuestFileAttributes `xml:"fileAttributes,typeattr"`
	FileSize       int64                   `xml:"fileSize"`
	Overwrite      bool                    `xml:"overwrite"`
}

func init() {
	t["InitiateFileTransferToGuestRequestType"] = reflect.TypeOf((*InitiateFileTransferToGuestRequestType)(nil)).Elem()
}

type InitiateFileTransferToGuestResponse struct {
	Returnval string `xml:"returnval"`
}

type InstallHostPatchRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Repository HostPatchManagerLocator `xml:"repository"`
	UpdateID   string                  `xml:"updateID"`
	Force      *bool                   `xml:"force"`
}

func init() {
	t["InstallHostPatchRequestType"] = reflect.TypeOf((*InstallHostPatchRequestType)(nil)).Elem()
}

type InstallHostPatchV2RequestType struct {
	This       ManagedObjectReference                     `xml:"_this"`
	MetaUrls   []string                                   `xml:"metaUrls,omitempty"`
	BundleUrls []string                                   `xml:"bundleUrls,omitempty"`
	VibUrls    []string                                   `xml:"vibUrls,omitempty"`
	Spec       *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty"`
}

func init() {
	t["InstallHostPatchV2RequestType"] = reflect.TypeOf((*InstallHostPatchV2RequestType)(nil)).Elem()
}

type InstallHostPatchV2_Task InstallHostPatchV2RequestType

func init() {
	t["InstallHostPatchV2_Task"] = reflect.TypeOf((*InstallHostPatchV2_Task)(nil)).Elem()
}

type InstallHostPatchV2_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InstallHostPatch_Task InstallHostPatchRequestType

func init() {
	t["InstallHostPatch_Task"] = reflect.TypeOf((*InstallHostPatch_Task)(nil)).Elem()
}

type InstallHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InsufficientAgentVmsDeployed struct {
	InsufficientResourcesFault

	HostName            string `xml:"hostName"`
	RequiredNumAgentVms int    `xml:"requiredNumAgentVms"`
	CurrentNumAgentVms  int    `xml:"currentNumAgentVms"`
}

func init() {
	t["InsufficientAgentVmsDeployed"] = reflect.TypeOf((*InsufficientAgentVmsDeployed)(nil)).Elem()
}

type InsufficientAgentVmsDeployedFault InsufficientAgentVmsDeployed

func init() {
	t["InsufficientAgentVmsDeployedFault"] = reflect.TypeOf((*InsufficientAgentVmsDeployedFault)(nil)).Elem()
}

type InsufficientCpuResourcesFault struct {
	InsufficientResourcesFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientCpuResourcesFault"] = reflect.TypeOf((*InsufficientCpuResourcesFault)(nil)).Elem()
}

type InsufficientCpuResourcesFaultFault InsufficientCpuResourcesFault

func init() {
	t["InsufficientCpuResourcesFaultFault"] = reflect.TypeOf((*InsufficientCpuResourcesFaultFault)(nil)).Elem()
}

type InsufficientDisks struct {
	VsanDiskFault
}

func init() {
	t["InsufficientDisks"] = reflect.TypeOf((*InsufficientDisks)(nil)).Elem()
}

type InsufficientDisksFault InsufficientDisks

func init() {
	t["InsufficientDisksFault"] = reflect.TypeOf((*InsufficientDisksFault)(nil)).Elem()
}

type InsufficientFailoverResourcesEvent struct {
	ClusterEvent
}

func init() {
	t["InsufficientFailoverResourcesEvent"] = reflect.TypeOf((*InsufficientFailoverResourcesEvent)(nil)).Elem()
}

type InsufficientFailoverResourcesFault struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientFailoverResourcesFault"] = reflect.TypeOf((*InsufficientFailoverResourcesFault)(nil)).Elem()
}

type InsufficientFailoverResourcesFaultFault InsufficientFailoverResourcesFault

func init() {
	t["InsufficientFailoverResourcesFaultFault"] = reflect.TypeOf((*InsufficientFailoverResourcesFaultFault)(nil)).Elem()
}

type InsufficientHostCapacityFault struct {
	InsufficientResourcesFault

	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["InsufficientHostCapacityFault"] = reflect.TypeOf((*InsufficientHostCapacityFault)(nil)).Elem()
}

type InsufficientHostCapacityFaultFault BaseInsufficientHostCapacityFault

func init() {
	t["InsufficientHostCapacityFaultFault"] = reflect.TypeOf((*InsufficientHostCapacityFaultFault)(nil)).Elem()
}

type InsufficientHostCpuCapacityFault struct {
	InsufficientHostCapacityFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientHostCpuCapacityFault"] = reflect.TypeOf((*InsufficientHostCpuCapacityFault)(nil)).Elem()
}

type InsufficientHostCpuCapacityFaultFault InsufficientHostCpuCapacityFault

func init() {
	t["InsufficientHostCpuCapacityFaultFault"] = reflect.TypeOf((*InsufficientHostCpuCapacityFaultFault)(nil)).Elem()
}

type InsufficientHostMemoryCapacityFault struct {
	InsufficientHostCapacityFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientHostMemoryCapacityFault"] = reflect.TypeOf((*InsufficientHostMemoryCapacityFault)(nil)).Elem()
}

type InsufficientHostMemoryCapacityFaultFault InsufficientHostMemoryCapacityFault

func init() {
	t["InsufficientHostMemoryCapacityFaultFault"] = reflect.TypeOf((*InsufficientHostMemoryCapacityFaultFault)(nil)).Elem()
}

type InsufficientMemoryResourcesFault struct {
	InsufficientResourcesFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientMemoryResourcesFault"] = reflect.TypeOf((*InsufficientMemoryResourcesFault)(nil)).Elem()
}

type InsufficientMemoryResourcesFaultFault InsufficientMemoryResourcesFault

func init() {
	t["InsufficientMemoryResourcesFaultFault"] = reflect.TypeOf((*InsufficientMemoryResourcesFaultFault)(nil)).Elem()
}

type InsufficientPerCpuCapacity struct {
	InsufficientHostCapacityFault
}

func init() {
	t["InsufficientPerCpuCapacity"] = reflect.TypeOf((*InsufficientPerCpuCapacity)(nil)).Elem()
}

type InsufficientPerCpuCapacityFault InsufficientPerCpuCapacity

func init() {
	t["InsufficientPerCpuCapacityFault"] = reflect.TypeOf((*InsufficientPerCpuCapacityFault)(nil)).Elem()
}

type InsufficientResourcesFault struct {
	VimFault
}

func init() {
	t["InsufficientResourcesFault"] = reflect.TypeOf((*InsufficientResourcesFault)(nil)).Elem()
}

type InsufficientResourcesFaultFault BaseInsufficientResourcesFault

func init() {
	t["InsufficientResourcesFaultFault"] = reflect.TypeOf((*InsufficientResourcesFaultFault)(nil)).Elem()
}

type InsufficientStandbyCpuResource struct {
	InsufficientStandbyResource

	Available int64 `xml:"available"`
	Requested int64 `xml:"requested"`
}

func init() {
	t["InsufficientStandbyCpuResource"] = reflect.TypeOf((*InsufficientStandbyCpuResource)(nil)).Elem()
}

type InsufficientStandbyCpuResourceFault InsufficientStandbyCpuResource

func init() {
	t["InsufficientStandbyCpuResourceFault"] = reflect.TypeOf((*InsufficientStandbyCpuResourceFault)(nil)).Elem()
}

type InsufficientStandbyMemoryResource struct {
	InsufficientStandbyResource

	Available int64 `xml:"available"`
	Requested int64 `xml:"requested"`
}

func init() {
	t["InsufficientStandbyMemoryResource"] = reflect.TypeOf((*InsufficientStandbyMemoryResource)(nil)).Elem()
}

type InsufficientStandbyMemoryResourceFault InsufficientStandbyMemoryResource

func init() {
	t["InsufficientStandbyMemoryResourceFault"] = reflect.TypeOf((*InsufficientStandbyMemoryResourceFault)(nil)).Elem()
}

type InsufficientStandbyResource struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientStandbyResource"] = reflect.TypeOf((*InsufficientStandbyResource)(nil)).Elem()
}

type InsufficientStandbyResourceFault BaseInsufficientStandbyResource

func init() {
	t["InsufficientStandbyResourceFault"] = reflect.TypeOf((*InsufficientStandbyResourceFault)(nil)).Elem()
}

type InsufficientStorageSpace struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientStorageSpace"] = reflect.TypeOf((*InsufficientStorageSpace)(nil)).Elem()
}

type InsufficientStorageSpaceFault InsufficientStorageSpace

func init() {
	t["InsufficientStorageSpaceFault"] = reflect.TypeOf((*InsufficientStorageSpaceFault)(nil)).Elem()
}

type InsufficientVFlashResourcesFault struct {
	InsufficientResourcesFault

	FreeSpace      int64 `xml:"freeSpace"`
	RequestedSpace int64 `xml:"requestedSpace"`
}

func init() {
	t["InsufficientVFlashResourcesFault"] = reflect.TypeOf((*InsufficientVFlashResourcesFault)(nil)).Elem()
}

type InsufficientVFlashResourcesFaultFault InsufficientVFlashResourcesFault

func init() {
	t["InsufficientVFlashResourcesFaultFault"] = reflect.TypeOf((*InsufficientVFlashResourcesFaultFault)(nil)).Elem()
}

type IntExpression struct {
	NegatableExpression

	Value int `xml:"value,omitempty"`
}

func init() {
	t["IntExpression"] = reflect.TypeOf((*IntExpression)(nil)).Elem()
}

type IntOption struct {
	OptionType

	Min          int `xml:"min"`
	Max          int `xml:"max"`
	DefaultValue int `xml:"defaultValue"`
}

func init() {
	t["IntOption"] = reflect.TypeOf((*IntOption)(nil)).Elem()
}

type IntPolicy struct {
	InheritablePolicy

	Value int `xml:"value,omitempty"`
}

func init() {
	t["IntPolicy"] = reflect.TypeOf((*IntPolicy)(nil)).Elem()
}

type InvalidAffinitySettingFault struct {
	VimFault
}

func init() {
	t["InvalidAffinitySettingFault"] = reflect.TypeOf((*InvalidAffinitySettingFault)(nil)).Elem()
}

type InvalidAffinitySettingFaultFault InvalidAffinitySettingFault

func init() {
	t["InvalidAffinitySettingFaultFault"] = reflect.TypeOf((*InvalidAffinitySettingFaultFault)(nil)).Elem()
}

type InvalidArgument struct {
	RuntimeFault

	InvalidProperty string `xml:"invalidProperty,omitempty"`
}

func init() {
	t["InvalidArgument"] = reflect.TypeOf((*InvalidArgument)(nil)).Elem()
}

type InvalidArgumentFault BaseInvalidArgument

func init() {
	t["InvalidArgumentFault"] = reflect.TypeOf((*InvalidArgumentFault)(nil)).Elem()
}

type InvalidBmcRole struct {
	VimFault
}

func init() {
	t["InvalidBmcRole"] = reflect.TypeOf((*InvalidBmcRole)(nil)).Elem()
}

type InvalidBmcRoleFault InvalidBmcRole

func init() {
	t["InvalidBmcRoleFault"] = reflect.TypeOf((*InvalidBmcRoleFault)(nil)).Elem()
}

type InvalidBundle struct {
	PlatformConfigFault
}

func init() {
	t["InvalidBundle"] = reflect.TypeOf((*InvalidBundle)(nil)).Elem()
}

type InvalidBundleFault InvalidBundle

func init() {
	t["InvalidBundleFault"] = reflect.TypeOf((*InvalidBundleFault)(nil)).Elem()
}

type InvalidCAMCertificate struct {
	InvalidCAMServer
}

func init() {
	t["InvalidCAMCertificate"] = reflect.TypeOf((*InvalidCAMCertificate)(nil)).Elem()
}

type InvalidCAMCertificateFault InvalidCAMCertificate

func init() {
	t["InvalidCAMCertificateFault"] = reflect.TypeOf((*InvalidCAMCertificateFault)(nil)).Elem()
}

type InvalidCAMServer struct {
	ActiveDirectoryFault

	CamServer string `xml:"camServer"`
}

func init() {
	t["InvalidCAMServer"] = reflect.TypeOf((*InvalidCAMServer)(nil)).Elem()
}

type InvalidCAMServerFault BaseInvalidCAMServer

func init() {
	t["InvalidCAMServerFault"] = reflect.TypeOf((*InvalidCAMServerFault)(nil)).Elem()
}

type InvalidClientCertificate struct {
	InvalidLogin
}

func init() {
	t["InvalidClientCertificate"] = reflect.TypeOf((*InvalidClientCertificate)(nil)).Elem()
}

type InvalidClientCertificateFault InvalidClientCertificate

func init() {
	t["InvalidClientCertificateFault"] = reflect.TypeOf((*InvalidClientCertificateFault)(nil)).Elem()
}

type InvalidCollectorVersion struct {
	MethodFault
}

func init() {
	t["InvalidCollectorVersion"] = reflect.TypeOf((*InvalidCollectorVersion)(nil)).Elem()
}

type InvalidCollectorVersionFault InvalidCollectorVersion

func init() {
	t["InvalidCollectorVersionFault"] = reflect.TypeOf((*InvalidCollectorVersionFault)(nil)).Elem()
}

type InvalidController struct {
	InvalidDeviceSpec

	ControllerKey int `xml:"controllerKey"`
}

func init() {
	t["InvalidController"] = reflect.TypeOf((*InvalidController)(nil)).Elem()
}

type InvalidControllerFault InvalidController

func init() {
	t["InvalidControllerFault"] = reflect.TypeOf((*InvalidControllerFault)(nil)).Elem()
}

type InvalidDasConfigArgument struct {
	InvalidArgument

	Entry       string `xml:"entry,omitempty"`
	ClusterName string `xml:"clusterName,omitempty"`
}

func init() {
	t["InvalidDasConfigArgument"] = reflect.TypeOf((*InvalidDasConfigArgument)(nil)).Elem()
}

type InvalidDasConfigArgumentFault InvalidDasConfigArgument

func init() {
	t["InvalidDasConfigArgumentFault"] = reflect.TypeOf((*InvalidDasConfigArgumentFault)(nil)).Elem()
}

type InvalidDasRestartPriorityForFtVm struct {
	InvalidArgument

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["InvalidDasRestartPriorityForFtVm"] = reflect.TypeOf((*InvalidDasRestartPriorityForFtVm)(nil)).Elem()
}

type InvalidDasRestartPriorityForFtVmFault InvalidDasRestartPriorityForFtVm

func init() {
	t["InvalidDasRestartPriorityForFtVmFault"] = reflect.TypeOf((*InvalidDasRestartPriorityForFtVmFault)(nil)).Elem()
}

type InvalidDatastore struct {
	VimFault

	Datastore *ManagedObjectReference `xml:"datastore,omitempty"`
	Name      string                  `xml:"name,omitempty"`
}

func init() {
	t["InvalidDatastore"] = reflect.TypeOf((*InvalidDatastore)(nil)).Elem()
}

type InvalidDatastoreFault BaseInvalidDatastore

func init() {
	t["InvalidDatastoreFault"] = reflect.TypeOf((*InvalidDatastoreFault)(nil)).Elem()
}

type InvalidDatastorePath struct {
	InvalidDatastore

	DatastorePath string `xml:"datastorePath"`
}

func init() {
	t["InvalidDatastorePath"] = reflect.TypeOf((*InvalidDatastorePath)(nil)).Elem()
}

type InvalidDatastorePathFault InvalidDatastorePath

func init() {
	t["InvalidDatastorePathFault"] = reflect.TypeOf((*InvalidDatastorePathFault)(nil)).Elem()
}

type InvalidDatastoreState struct {
	InvalidState

	DatastoreName string `xml:"datastoreName,omitempty"`
}

func init() {
	t["InvalidDatastoreState"] = reflect.TypeOf((*InvalidDatastoreState)(nil)).Elem()
}

type InvalidDatastoreStateFault InvalidDatastoreState

func init() {
	t["InvalidDatastoreStateFault"] = reflect.TypeOf((*InvalidDatastoreStateFault)(nil)).Elem()
}

type InvalidDeviceBacking struct {
	InvalidDeviceSpec
}

func init() {
	t["InvalidDeviceBacking"] = reflect.TypeOf((*InvalidDeviceBacking)(nil)).Elem()
}

type InvalidDeviceBackingFault InvalidDeviceBacking

func init() {
	t["InvalidDeviceBackingFault"] = reflect.TypeOf((*InvalidDeviceBackingFault)(nil)).Elem()
}

type InvalidDeviceOperation struct {
	InvalidDeviceSpec

	BadOp     VirtualDeviceConfigSpecOperation     `xml:"badOp,omitempty"`
	BadFileOp VirtualDeviceConfigSpecFileOperation `xml:"badFileOp,omitempty"`
}

func init() {
	t["InvalidDeviceOperation"] = reflect.TypeOf((*InvalidDeviceOperation)(nil)).Elem()
}

type InvalidDeviceOperationFault InvalidDeviceOperation

func init() {
	t["InvalidDeviceOperationFault"] = reflect.TypeOf((*InvalidDeviceOperationFault)(nil)).Elem()
}

type InvalidDeviceSpec struct {
	InvalidVmConfig

	DeviceIndex int `xml:"deviceIndex"`
}

func init() {
	t["InvalidDeviceSpec"] = reflect.TypeOf((*InvalidDeviceSpec)(nil)).Elem()
}

type InvalidDeviceSpecFault BaseInvalidDeviceSpec

func init() {
	t["InvalidDeviceSpecFault"] = reflect.TypeOf((*InvalidDeviceSpecFault)(nil)).Elem()
}

type InvalidDiskFormat struct {
	InvalidFormat
}

func init() {
	t["InvalidDiskFormat"] = reflect.TypeOf((*InvalidDiskFormat)(nil)).Elem()
}

type InvalidDiskFormatFault InvalidDiskFormat

func init() {
	t["InvalidDiskFormatFault"] = reflect.TypeOf((*InvalidDiskFormatFault)(nil)).Elem()
}

type InvalidDrsBehaviorForFtVm struct {
	InvalidArgument

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["InvalidDrsBehaviorForFtVm"] = reflect.TypeOf((*InvalidDrsBehaviorForFtVm)(nil)).Elem()
}

type InvalidDrsBehaviorForFtVmFault InvalidDrsBehaviorForFtVm

func init() {
	t["InvalidDrsBehaviorForFtVmFault"] = reflect.TypeOf((*InvalidDrsBehaviorForFtVmFault)(nil)).Elem()
}

type InvalidEditionEvent struct {
	LicenseEvent

	Feature string `xml:"feature"`
}

func init() {
	t["InvalidEditionEvent"] = reflect.TypeOf((*InvalidEditionEvent)(nil)).Elem()
}

type InvalidEditionLicense struct {
	NotEnoughLicenses

	Feature string `xml:"feature"`
}

func init() {
	t["InvalidEditionLicense"] = reflect.TypeOf((*InvalidEditionLicense)(nil)).Elem()
}

type InvalidEditionLicenseFault InvalidEditionLicense

func init() {
	t["InvalidEditionLicenseFault"] = reflect.TypeOf((*InvalidEditionLicenseFault)(nil)).Elem()
}

type InvalidEvent struct {
	VimFault
}

func init() {
	t["InvalidEvent"] = reflect.TypeOf((*InvalidEvent)(nil)).Elem()
}

type InvalidEventFault InvalidEvent

func init() {
	t["InvalidEventFault"] = reflect.TypeOf((*InvalidEventFault)(nil)).Elem()
}

type InvalidFolder struct {
	VimFault

	Target ManagedObjectReference `xml:"target"`
}

func init() {
	t["InvalidFolder"] = reflect.TypeOf((*InvalidFolder)(nil)).Elem()
}

type InvalidFolderFault BaseInvalidFolder

func init() {
	t["InvalidFolderFault"] = reflect.TypeOf((*InvalidFolderFault)(nil)).Elem()
}

type InvalidFormat struct {
	VmConfigFault
}

func init() {
	t["InvalidFormat"] = reflect.TypeOf((*InvalidFormat)(nil)).Elem()
}

type InvalidFormatFault BaseInvalidFormat

func init() {
	t["InvalidFormatFault"] = reflect.TypeOf((*InvalidFormatFault)(nil)).Elem()
}

type InvalidGuestLogin struct {
	GuestOperationsFault
}

func init() {
	t["InvalidGuestLogin"] = reflect.TypeOf((*InvalidGuestLogin)(nil)).Elem()
}

type InvalidGuestLoginFault InvalidGuestLogin

func init() {
	t["InvalidGuestLoginFault"] = reflect.TypeOf((*InvalidGuestLoginFault)(nil)).Elem()
}

type InvalidHostConnectionState struct {
	InvalidHostState
}

func init() {
	t["InvalidHostConnectionState"] = reflect.TypeOf((*InvalidHostConnectionState)(nil)).Elem()
}

type InvalidHostConnectionStateFault InvalidHostConnectionState

func init() {
	t["InvalidHostConnectionStateFault"] = reflect.TypeOf((*InvalidHostConnectionStateFault)(nil)).Elem()
}

type InvalidHostName struct {
	HostConfigFault
}

func init() {
	t["InvalidHostName"] = reflect.TypeOf((*InvalidHostName)(nil)).Elem()
}

type InvalidHostNameFault InvalidHostName

func init() {
	t["InvalidHostNameFault"] = reflect.TypeOf((*InvalidHostNameFault)(nil)).Elem()
}

type InvalidHostState struct {
	InvalidState

	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["InvalidHostState"] = reflect.TypeOf((*InvalidHostState)(nil)).Elem()
}

type InvalidHostStateFault BaseInvalidHostState

func init() {
	t["InvalidHostStateFault"] = reflect.TypeOf((*InvalidHostStateFault)(nil)).Elem()
}

type InvalidIndexArgument struct {
	InvalidArgument

	Key string `xml:"key"`
}

func init() {
	t["InvalidIndexArgument"] = reflect.TypeOf((*InvalidIndexArgument)(nil)).Elem()
}

type InvalidIndexArgumentFault InvalidIndexArgument

func init() {
	t["InvalidIndexArgumentFault"] = reflect.TypeOf((*InvalidIndexArgumentFault)(nil)).Elem()
}

type InvalidIpfixConfig struct {
	DvsFault

	Property string `xml:"property,omitempty"`
}

func init() {
	t["InvalidIpfixConfig"] = reflect.TypeOf((*InvalidIpfixConfig)(nil)).Elem()
}

type InvalidIpfixConfigFault InvalidIpfixConfig

func init() {
	t["InvalidIpfixConfigFault"] = reflect.TypeOf((*InvalidIpfixConfigFault)(nil)).Elem()
}

type InvalidIpmiLoginInfo struct {
	VimFault
}

func init() {
	t["InvalidIpmiLoginInfo"] = reflect.TypeOf((*InvalidIpmiLoginInfo)(nil)).Elem()
}

type InvalidIpmiLoginInfoFault InvalidIpmiLoginInfo

func init() {
	t["InvalidIpmiLoginInfoFault"] = reflect.TypeOf((*InvalidIpmiLoginInfoFault)(nil)).Elem()
}

type InvalidIpmiMacAddress struct {
	VimFault

	UserProvidedMacAddress string `xml:"userProvidedMacAddress"`
	ObservedMacAddress     string `xml:"observedMacAddress"`
}

func init() {
	t["InvalidIpmiMacAddress"] = reflect.TypeOf((*InvalidIpmiMacAddress)(nil)).Elem()
}

type InvalidIpmiMacAddressFault InvalidIpmiMacAddress

func init() {
	t["InvalidIpmiMacAddressFault"] = reflect.TypeOf((*InvalidIpmiMacAddressFault)(nil)).Elem()
}

type InvalidLicense struct {
	VimFault

	LicenseContent string `xml:"licenseContent"`
}

func init() {
	t["InvalidLicense"] = reflect.TypeOf((*InvalidLicense)(nil)).Elem()
}

type InvalidLicenseFault InvalidLicense

func init() {
	t["InvalidLicenseFault"] = reflect.TypeOf((*InvalidLicenseFault)(nil)).Elem()
}

type InvalidLocale struct {
	VimFault
}

func init() {
	t["InvalidLocale"] = reflect.TypeOf((*InvalidLocale)(nil)).Elem()
}

type InvalidLocaleFault InvalidLocale

func init() {
	t["InvalidLocaleFault"] = reflect.TypeOf((*InvalidLocaleFault)(nil)).Elem()
}

type InvalidLogin struct {
	VimFault
}

func init() {
	t["InvalidLogin"] = reflect.TypeOf((*InvalidLogin)(nil)).Elem()
}

type InvalidLoginFault BaseInvalidLogin

func init() {
	t["InvalidLoginFault"] = reflect.TypeOf((*InvalidLoginFault)(nil)).Elem()
}

type InvalidName struct {
	VimFault

	Name   string                  `xml:"name"`
	Entity *ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["InvalidName"] = reflect.TypeOf((*InvalidName)(nil)).Elem()
}

type InvalidNameFault InvalidName

func init() {
	t["InvalidNameFault"] = reflect.TypeOf((*InvalidNameFault)(nil)).Elem()
}

type InvalidNasCredentials struct {
	NasConfigFault

	UserName string `xml:"userName"`
}

func init() {
	t["InvalidNasCredentials"] = reflect.TypeOf((*InvalidNasCredentials)(nil)).Elem()
}

type InvalidNasCredentialsFault InvalidNasCredentials

func init() {
	t["InvalidNasCredentialsFault"] = reflect.TypeOf((*InvalidNasCredentialsFault)(nil)).Elem()
}

type InvalidNetworkInType struct {
	VAppPropertyFault
}

func init() {
	t["InvalidNetworkInType"] = reflect.TypeOf((*InvalidNetworkInType)(nil)).Elem()
}

type InvalidNetworkInTypeFault InvalidNetworkInType

func init() {
	t["InvalidNetworkInTypeFault"] = reflect.TypeOf((*InvalidNetworkInTypeFault)(nil)).Elem()
}

type InvalidNetworkResource struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
}

func init() {
	t["InvalidNetworkResource"] = reflect.TypeOf((*InvalidNetworkResource)(nil)).Elem()
}

type InvalidNetworkResourceFault InvalidNetworkResource

func init() {
	t["InvalidNetworkResourceFault"] = reflect.TypeOf((*InvalidNetworkResourceFault)(nil)).Elem()
}

type InvalidOperationOnSecondaryVm struct {
	VmFaultToleranceIssue

	InstanceUuid string `xml:"instanceUuid,omitempty"`
}

func init() {
	t["InvalidOperationOnSecondaryVm"] = reflect.TypeOf((*InvalidOperationOnSecondaryVm)(nil)).Elem()
}

type InvalidOperationOnSecondaryVmFault InvalidOperationOnSecondaryVm

func init() {
	t["InvalidOperationOnSecondaryVmFault"] = reflect.TypeOf((*InvalidOperationOnSecondaryVmFault)(nil)).Elem()
}

type InvalidPowerState struct {
	InvalidState

	RequestedState VirtualMachinePowerState `xml:"requestedState,omitempty"`
	ExistingState  VirtualMachinePowerState `xml:"existingState"`
}

func init() {
	t["InvalidPowerState"] = reflect.TypeOf((*InvalidPowerState)(nil)).Elem()
}

type InvalidPowerStateFault InvalidPowerState

func init() {
	t["InvalidPowerStateFault"] = reflect.TypeOf((*InvalidPowerStateFault)(nil)).Elem()
}

type InvalidPrivilege struct {
	VimFault

	Privilege string `xml:"privilege"`
}

func init() {
	t["InvalidPrivilege"] = reflect.TypeOf((*InvalidPrivilege)(nil)).Elem()
}

type InvalidPrivilegeFault InvalidPrivilege

func init() {
	t["InvalidPrivilegeFault"] = reflect.TypeOf((*InvalidPrivilegeFault)(nil)).Elem()
}

type InvalidProfileReferenceHost struct {
	RuntimeFault

	Reason  string                  `xml:"reason,omitempty"`
	Host    *ManagedObjectReference `xml:"host,omitempty"`
	Profile *ManagedObjectReference `xml:"profile,omitempty"`
}

func init() {
	t["InvalidProfileReferenceHost"] = reflect.TypeOf((*InvalidProfileReferenceHost)(nil)).Elem()
}

type InvalidProfileReferenceHostFault InvalidProfileReferenceHost

func init() {
	t["InvalidProfileReferenceHostFault"] = reflect.TypeOf((*InvalidProfileReferenceHostFault)(nil)).Elem()
}

type InvalidProperty struct {
	MethodFault

	Name string `xml:"name"`
}

func init() {
	t["InvalidProperty"] = reflect.TypeOf((*InvalidProperty)(nil)).Elem()
}

type InvalidPropertyFault InvalidProperty

func init() {
	t["InvalidPropertyFault"] = reflect.TypeOf((*InvalidPropertyFault)(nil)).Elem()
}

type InvalidPropertyType struct {
	VAppPropertyFault
}

func init() {
	t["InvalidPropertyType"] = reflect.TypeOf((*InvalidPropertyType)(nil)).Elem()
}

type InvalidPropertyTypeFault InvalidPropertyType

func init() {
	t["InvalidPropertyTypeFault"] = reflect.TypeOf((*InvalidPropertyTypeFault)(nil)).Elem()
}

type InvalidPropertyValue struct {
	VAppPropertyFault
}

func init() {
	t["InvalidPropertyValue"] = reflect.TypeOf((*InvalidPropertyValue)(nil)).Elem()
}

type InvalidPropertyValueFault BaseInvalidPropertyValue

func init() {
	t["InvalidPropertyValueFault"] = reflect.TypeOf((*InvalidPropertyValueFault)(nil)).Elem()
}

type InvalidRequest struct {
	RuntimeFault
}

func init() {
	t["InvalidRequest"] = reflect.TypeOf((*InvalidRequest)(nil)).Elem()
}

type InvalidRequestFault BaseInvalidRequest

func init() {
	t["InvalidRequestFault"] = reflect.TypeOf((*InvalidRequestFault)(nil)).Elem()
}

type InvalidResourcePoolStructureFault struct {
	InsufficientResourcesFault
}

func init() {
	t["InvalidResourcePoolStructureFault"] = reflect.TypeOf((*InvalidResourcePoolStructureFault)(nil)).Elem()
}

type InvalidResourcePoolStructureFaultFault InvalidResourcePoolStructureFault

func init() {
	t["InvalidResourcePoolStructureFaultFault"] = reflect.TypeOf((*InvalidResourcePoolStructureFaultFault)(nil)).Elem()
}

type InvalidSnapshotFormat struct {
	InvalidFormat
}

func init() {
	t["InvalidSnapshotFormat"] = reflect.TypeOf((*InvalidSnapshotFormat)(nil)).Elem()
}

type InvalidSnapshotFormatFault InvalidSnapshotFormat

func init() {
	t["InvalidSnapshotFormatFault"] = reflect.TypeOf((*InvalidSnapshotFormatFault)(nil)).Elem()
}

type InvalidState struct {
	VimFault
}

func init() {
	t["InvalidState"] = reflect.TypeOf((*InvalidState)(nil)).Elem()
}

type InvalidStateFault BaseInvalidState

func init() {
	t["InvalidStateFault"] = reflect.TypeOf((*InvalidStateFault)(nil)).Elem()
}

type InvalidType struct {
	InvalidRequest

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["InvalidType"] = reflect.TypeOf((*InvalidType)(nil)).Elem()
}

type InvalidTypeFault InvalidType

func init() {
	t["InvalidTypeFault"] = reflect.TypeOf((*InvalidTypeFault)(nil)).Elem()
}

type InvalidVmConfig struct {
	VmConfigFault

	Property string `xml:"property,omitempty"`
}

func init() {
	t["InvalidVmConfig"] = reflect.TypeOf((*InvalidVmConfig)(nil)).Elem()
}

type InvalidVmConfigFault BaseInvalidVmConfig

func init() {
	t["InvalidVmConfigFault"] = reflect.TypeOf((*InvalidVmConfigFault)(nil)).Elem()
}

type InventoryDescription struct {
	DynamicData

	NumHosts           int `xml:"numHosts"`
	NumVirtualMachines int `xml:"numVirtualMachines"`
	NumResourcePools   int `xml:"numResourcePools,omitempty"`
	NumClusters        int `xml:"numClusters,omitempty"`
	NumCpuDev          int `xml:"numCpuDev,omitempty"`
	NumNetDev          int `xml:"numNetDev,omitempty"`
	NumDiskDev         int `xml:"numDiskDev,omitempty"`
	NumvCpuDev         int `xml:"numvCpuDev,omitempty"`
	NumvNetDev         int `xml:"numvNetDev,omitempty"`
	NumvDiskDev        int `xml:"numvDiskDev,omitempty"`
}

func init() {
	t["InventoryDescription"] = reflect.TypeOf((*InventoryDescription)(nil)).Elem()
}

type InventoryHasStandardAloneHosts struct {
	NotEnoughLicenses

	Hosts []string `xml:"hosts"`
}

func init() {
	t["InventoryHasStandardAloneHosts"] = reflect.TypeOf((*InventoryHasStandardAloneHosts)(nil)).Elem()
}

type InventoryHasStandardAloneHostsFault InventoryHasStandardAloneHosts

func init() {
	t["InventoryHasStandardAloneHostsFault"] = reflect.TypeOf((*InventoryHasStandardAloneHostsFault)(nil)).Elem()
}

type IpAddress struct {
	NegatableExpression
}

func init() {
	t["IpAddress"] = reflect.TypeOf((*IpAddress)(nil)).Elem()
}

type IpAddressProfile struct {
	ApplyProfile
}

func init() {
	t["IpAddressProfile"] = reflect.TypeOf((*IpAddressProfile)(nil)).Elem()
}

type IpHostnameGeneratorError struct {
	CustomizationFault
}

func init() {
	t["IpHostnameGeneratorError"] = reflect.TypeOf((*IpHostnameGeneratorError)(nil)).Elem()
}

type IpHostnameGeneratorErrorFault IpHostnameGeneratorError

func init() {
	t["IpHostnameGeneratorErrorFault"] = reflect.TypeOf((*IpHostnameGeneratorErrorFault)(nil)).Elem()
}

type IpPool struct {
	DynamicData

	Id                     int                     `xml:"id,omitempty"`
	Name                   string                  `xml:"name,omitempty"`
	Ipv4Config             *IpPoolIpPoolConfigInfo `xml:"ipv4Config,omitempty"`
	Ipv6Config             *IpPoolIpPoolConfigInfo `xml:"ipv6Config,omitempty"`
	DnsDomain              string                  `xml:"dnsDomain,omitempty"`
	DnsSearchPath          string                  `xml:"dnsSearchPath,omitempty"`
	HostPrefix             string                  `xml:"hostPrefix,omitempty"`
	HttpProxy              string                  `xml:"httpProxy,omitempty"`
	NetworkAssociation     []IpPoolAssociation     `xml:"networkAssociation,omitempty"`
	AvailableIpv4Addresses int                     `xml:"availableIpv4Addresses,omitempty"`
	AvailableIpv6Addresses int                     `xml:"availableIpv6Addresses,omitempty"`
	AllocatedIpv4Addresses int                     `xml:"allocatedIpv4Addresses,omitempty"`
	AllocatedIpv6Addresses int                     `xml:"allocatedIpv6Addresses,omitempty"`
}

func init() {
	t["IpPool"] = reflect.TypeOf((*IpPool)(nil)).Elem()
}

type IpPoolAssociation struct {
	DynamicData

	Network     *ManagedObjectReference `xml:"network,omitempty"`
	NetworkName string                  `xml:"networkName"`
}

func init() {
	t["IpPoolAssociation"] = reflect.TypeOf((*IpPoolAssociation)(nil)).Elem()
}

type IpPoolIpPoolConfigInfo struct {
	DynamicData

	SubnetAddress       string   `xml:"subnetAddress,omitempty"`
	Netmask             string   `xml:"netmask,omitempty"`
	Gateway             string   `xml:"gateway,omitempty"`
	Range               string   `xml:"range,omitempty"`
	Dns                 []string `xml:"dns,omitempty"`
	DhcpServerAvailable *bool    `xml:"dhcpServerAvailable"`
	IpPoolEnabled       *bool    `xml:"ipPoolEnabled"`
}

func init() {
	t["IpPoolIpPoolConfigInfo"] = reflect.TypeOf((*IpPoolIpPoolConfigInfo)(nil)).Elem()
}

type IpPoolManagerIpAllocation struct {
	DynamicData

	IpAddress    string `xml:"ipAddress"`
	AllocationId string `xml:"allocationId"`
}

func init() {
	t["IpPoolManagerIpAllocation"] = reflect.TypeOf((*IpPoolManagerIpAllocation)(nil)).Elem()
}

type IpRange struct {
	IpAddress

	AddressPrefix string `xml:"addressPrefix"`
	PrefixLength  int    `xml:"prefixLength,omitempty"`
}

func init() {
	t["IpRange"] = reflect.TypeOf((*IpRange)(nil)).Elem()
}

type IpRouteProfile struct {
	ApplyProfile

	StaticRoute []StaticRouteProfile `xml:"staticRoute,omitempty"`
}

func init() {
	t["IpRouteProfile"] = reflect.TypeOf((*IpRouteProfile)(nil)).Elem()
}

type IsSharedGraphicsActive IsSharedGraphicsActiveRequestType

func init() {
	t["IsSharedGraphicsActive"] = reflect.TypeOf((*IsSharedGraphicsActive)(nil)).Elem()
}

type IsSharedGraphicsActiveRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["IsSharedGraphicsActiveRequestType"] = reflect.TypeOf((*IsSharedGraphicsActiveRequestType)(nil)).Elem()
}

type IsSharedGraphicsActiveResponse struct {
	Returnval bool `xml:"returnval"`
}

type IscsiDependencyEntity struct {
	DynamicData

	PnicDevice string `xml:"pnicDevice"`
	VnicDevice string `xml:"vnicDevice"`
	VmhbaName  string `xml:"vmhbaName"`
}

func init() {
	t["IscsiDependencyEntity"] = reflect.TypeOf((*IscsiDependencyEntity)(nil)).Elem()
}

type IscsiFault struct {
	VimFault
}

func init() {
	t["IscsiFault"] = reflect.TypeOf((*IscsiFault)(nil)).Elem()
}

type IscsiFaultFault BaseIscsiFault

func init() {
	t["IscsiFaultFault"] = reflect.TypeOf((*IscsiFaultFault)(nil)).Elem()
}

type IscsiFaultInvalidVnic struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultInvalidVnic"] = reflect.TypeOf((*IscsiFaultInvalidVnic)(nil)).Elem()
}

type IscsiFaultInvalidVnicFault IscsiFaultInvalidVnic

func init() {
	t["IscsiFaultInvalidVnicFault"] = reflect.TypeOf((*IscsiFaultInvalidVnicFault)(nil)).Elem()
}

type IscsiFaultPnicInUse struct {
	IscsiFault

	PnicDevice string `xml:"pnicDevice"`
}

func init() {
	t["IscsiFaultPnicInUse"] = reflect.TypeOf((*IscsiFaultPnicInUse)(nil)).Elem()
}

type IscsiFaultPnicInUseFault IscsiFaultPnicInUse

func init() {
	t["IscsiFaultPnicInUseFault"] = reflect.TypeOf((*IscsiFaultPnicInUseFault)(nil)).Elem()
}

type IscsiFaultVnicAlreadyBound struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicAlreadyBound"] = reflect.TypeOf((*IscsiFaultVnicAlreadyBound)(nil)).Elem()
}

type IscsiFaultVnicAlreadyBoundFault IscsiFaultVnicAlreadyBound

func init() {
	t["IscsiFaultVnicAlreadyBoundFault"] = reflect.TypeOf((*IscsiFaultVnicAlreadyBoundFault)(nil)).Elem()
}

type IscsiFaultVnicHasActivePaths struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasActivePaths"] = reflect.TypeOf((*IscsiFaultVnicHasActivePaths)(nil)).Elem()
}

type IscsiFaultVnicHasActivePathsFault IscsiFaultVnicHasActivePaths

func init() {
	t["IscsiFaultVnicHasActivePathsFault"] = reflect.TypeOf((*IscsiFaultVnicHasActivePathsFault)(nil)).Elem()
}

type IscsiFaultVnicHasMultipleUplinks struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasMultipleUplinks"] = reflect.TypeOf((*IscsiFaultVnicHasMultipleUplinks)(nil)).Elem()
}

type IscsiFaultVnicHasMultipleUplinksFault IscsiFaultVnicHasMultipleUplinks

func init() {
	t["IscsiFaultVnicHasMultipleUplinksFault"] = reflect.TypeOf((*IscsiFaultVnicHasMultipleUplinksFault)(nil)).Elem()
}

type IscsiFaultVnicHasNoUplinks struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasNoUplinks"] = reflect.TypeOf((*IscsiFaultVnicHasNoUplinks)(nil)).Elem()
}

type IscsiFaultVnicHasNoUplinksFault IscsiFaultVnicHasNoUplinks

func init() {
	t["IscsiFaultVnicHasNoUplinksFault"] = reflect.TypeOf((*IscsiFaultVnicHasNoUplinksFault)(nil)).Elem()
}

type IscsiFaultVnicHasWrongUplink struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasWrongUplink"] = reflect.TypeOf((*IscsiFaultVnicHasWrongUplink)(nil)).Elem()
}

type IscsiFaultVnicHasWrongUplinkFault IscsiFaultVnicHasWrongUplink

func init() {
	t["IscsiFaultVnicHasWrongUplinkFault"] = reflect.TypeOf((*IscsiFaultVnicHasWrongUplinkFault)(nil)).Elem()
}

type IscsiFaultVnicInUse struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicInUse"] = reflect.TypeOf((*IscsiFaultVnicInUse)(nil)).Elem()
}

type IscsiFaultVnicInUseFault IscsiFaultVnicInUse

func init() {
	t["IscsiFaultVnicInUseFault"] = reflect.TypeOf((*IscsiFaultVnicInUseFault)(nil)).Elem()
}

type IscsiFaultVnicIsLastPath struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicIsLastPath"] = reflect.TypeOf((*IscsiFaultVnicIsLastPath)(nil)).Elem()
}

type IscsiFaultVnicIsLastPathFault IscsiFaultVnicIsLastPath

func init() {
	t["IscsiFaultVnicIsLastPathFault"] = reflect.TypeOf((*IscsiFaultVnicIsLastPathFault)(nil)).Elem()
}

type IscsiFaultVnicNotBound struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicNotBound"] = reflect.TypeOf((*IscsiFaultVnicNotBound)(nil)).Elem()
}

type IscsiFaultVnicNotBoundFault IscsiFaultVnicNotBound

func init() {
	t["IscsiFaultVnicNotBoundFault"] = reflect.TypeOf((*IscsiFaultVnicNotBoundFault)(nil)).Elem()
}

type IscsiFaultVnicNotFound struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicNotFound"] = reflect.TypeOf((*IscsiFaultVnicNotFound)(nil)).Elem()
}

type IscsiFaultVnicNotFoundFault IscsiFaultVnicNotFound

func init() {
	t["IscsiFaultVnicNotFoundFault"] = reflect.TypeOf((*IscsiFaultVnicNotFoundFault)(nil)).Elem()
}

type IscsiMigrationDependency struct {
	DynamicData

	MigrationAllowed bool                    `xml:"migrationAllowed"`
	DisallowReason   *IscsiStatus            `xml:"disallowReason,omitempty"`
	Dependency       []IscsiDependencyEntity `xml:"dependency,omitempty"`
}

func init() {
	t["IscsiMigrationDependency"] = reflect.TypeOf((*IscsiMigrationDependency)(nil)).Elem()
}

type IscsiPortInfo struct {
	DynamicData

	VnicDevice       string          `xml:"vnicDevice,omitempty"`
	Vnic             *HostVirtualNic `xml:"vnic,omitempty"`
	PnicDevice       string          `xml:"pnicDevice,omitempty"`
	Pnic             *PhysicalNic    `xml:"pnic,omitempty"`
	SwitchName       string          `xml:"switchName,omitempty"`
	SwitchUuid       string          `xml:"switchUuid,omitempty"`
	PortgroupName    string          `xml:"portgroupName,omitempty"`
	PortgroupKey     string          `xml:"portgroupKey,omitempty"`
	PortKey          string          `xml:"portKey,omitempty"`
	ComplianceStatus *IscsiStatus    `xml:"complianceStatus,omitempty"`
	PathStatus       string          `xml:"pathStatus,omitempty"`
}

func init() {
	t["IscsiPortInfo"] = reflect.TypeOf((*IscsiPortInfo)(nil)).Elem()
}

type IscsiStatus struct {
	DynamicData

	Reason []LocalizedMethodFault `xml:"reason,omitempty"`
}

func init() {
	t["IscsiStatus"] = reflect.TypeOf((*IscsiStatus)(nil)).Elem()
}

type IsoImageFileInfo struct {
	FileInfo
}

func init() {
	t["IsoImageFileInfo"] = reflect.TypeOf((*IsoImageFileInfo)(nil)).Elem()
}

type IsoImageFileQuery struct {
	FileQuery
}

func init() {
	t["IsoImageFileQuery"] = reflect.TypeOf((*IsoImageFileQuery)(nil)).Elem()
}

type JoinDomainRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	DomainName string                 `xml:"domainName"`
	UserName   string                 `xml:"userName"`
	Password   string                 `xml:"password"`
}

func init() {
	t["JoinDomainRequestType"] = reflect.TypeOf((*JoinDomainRequestType)(nil)).Elem()
}

type JoinDomainWithCAMRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	DomainName string                 `xml:"domainName"`
	CamServer  string                 `xml:"camServer"`
}

func init() {
	t["JoinDomainWithCAMRequestType"] = reflect.TypeOf((*JoinDomainWithCAMRequestType)(nil)).Elem()
}

type JoinDomainWithCAM_Task JoinDomainWithCAMRequestType

func init() {
	t["JoinDomainWithCAM_Task"] = reflect.TypeOf((*JoinDomainWithCAM_Task)(nil)).Elem()
}

type JoinDomainWithCAM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type JoinDomain_Task JoinDomainRequestType

func init() {
	t["JoinDomain_Task"] = reflect.TypeOf((*JoinDomain_Task)(nil)).Elem()
}

type JoinDomain_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type KernelModuleInfo struct {
	DynamicData

	Id              int                     `xml:"id"`
	Name            string                  `xml:"name"`
	Version         string                  `xml:"version"`
	Filename        string                  `xml:"filename"`
	OptionString    string                  `xml:"optionString"`
	Loaded          bool                    `xml:"loaded"`
	Enabled         bool                    `xml:"enabled"`
	UseCount        int                     `xml:"useCount"`
	ReadOnlySection KernelModuleSectionInfo `xml:"readOnlySection"`
	WritableSection KernelModuleSectionInfo `xml:"writableSection"`
	TextSection     KernelModuleSectionInfo `xml:"textSection"`
	DataSection     KernelModuleSectionInfo `xml:"dataSection"`
	BssSection      KernelModuleSectionInfo `xml:"bssSection"`
}

func init() {
	t["KernelModuleInfo"] = reflect.TypeOf((*KernelModuleInfo)(nil)).Elem()
}

type KernelModuleSectionInfo struct {
	DynamicData

	Address int64 `xml:"address"`
	Length  int   `xml:"length,omitempty"`
}

func init() {
	t["KernelModuleSectionInfo"] = reflect.TypeOf((*KernelModuleSectionInfo)(nil)).Elem()
}

type KeyAnyValue struct {
	DynamicData

	Key   string  `xml:"key"`
	Value AnyType `xml:"value,typeattr"`
}

func init() {
	t["KeyAnyValue"] = reflect.TypeOf((*KeyAnyValue)(nil)).Elem()
}

type KeyValue struct {
	DynamicData

	Key   string `xml:"key"`
	Value string `xml:"value"`
}

func init() {
	t["KeyValue"] = reflect.TypeOf((*KeyValue)(nil)).Elem()
}

type LargeRDMConversionNotSupported struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["LargeRDMConversionNotSupported"] = reflect.TypeOf((*LargeRDMConversionNotSupported)(nil)).Elem()
}

type LargeRDMConversionNotSupportedFault LargeRDMConversionNotSupported

func init() {
	t["LargeRDMConversionNotSupportedFault"] = reflect.TypeOf((*LargeRDMConversionNotSupportedFault)(nil)).Elem()
}

type LargeRDMNotSupportedOnDatastore struct {
	VmConfigFault

	Device        string                 `xml:"device"`
	Datastore     ManagedObjectReference `xml:"datastore"`
	DatastoreName string                 `xml:"datastoreName"`
}

func init() {
	t["LargeRDMNotSupportedOnDatastore"] = reflect.TypeOf((*LargeRDMNotSupportedOnDatastore)(nil)).Elem()
}

type LargeRDMNotSupportedOnDatastoreFault LargeRDMNotSupportedOnDatastore

func init() {
	t["LargeRDMNotSupportedOnDatastoreFault"] = reflect.TypeOf((*LargeRDMNotSupportedOnDatastoreFault)(nil)).Elem()
}

type LatencySensitivity struct {
	DynamicData

	Level       LatencySensitivitySensitivityLevel `xml:"level"`
	Sensitivity int                                `xml:"sensitivity,omitempty"`
}

func init() {
	t["LatencySensitivity"] = reflect.TypeOf((*LatencySensitivity)(nil)).Elem()
}

type LeaveCurrentDomainRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Force bool                   `xml:"force"`
}

func init() {
	t["LeaveCurrentDomainRequestType"] = reflect.TypeOf((*LeaveCurrentDomainRequestType)(nil)).Elem()
}

type LeaveCurrentDomain_Task LeaveCurrentDomainRequestType

func init() {
	t["LeaveCurrentDomain_Task"] = reflect.TypeOf((*LeaveCurrentDomain_Task)(nil)).Elem()
}

type LeaveCurrentDomain_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type LegacyNetworkInterfaceInUse struct {
	CannotAccessNetwork
}

func init() {
	t["LegacyNetworkInterfaceInUse"] = reflect.TypeOf((*LegacyNetworkInterfaceInUse)(nil)).Elem()
}

type LegacyNetworkInterfaceInUseFault LegacyNetworkInterfaceInUse

func init() {
	t["LegacyNetworkInterfaceInUseFault"] = reflect.TypeOf((*LegacyNetworkInterfaceInUseFault)(nil)).Elem()
}

type LicenseAssignmentFailed struct {
	RuntimeFault

	Reason string `xml:"reason,omitempty"`
}

func init() {
	t["LicenseAssignmentFailed"] = reflect.TypeOf((*LicenseAssignmentFailed)(nil)).Elem()
}

type LicenseAssignmentFailedFault LicenseAssignmentFailed

func init() {
	t["LicenseAssignmentFailedFault"] = reflect.TypeOf((*LicenseAssignmentFailedFault)(nil)).Elem()
}

type LicenseAssignmentManagerLicenseAssignment struct {
	DynamicData

	EntityId          string                    `xml:"entityId"`
	Scope             string                    `xml:"scope,omitempty"`
	EntityDisplayName string                    `xml:"entityDisplayName,omitempty"`
	AssignedLicense   LicenseManagerLicenseInfo `xml:"assignedLicense"`
	Properties        []KeyAnyValue             `xml:"properties,omitempty"`
}

func init() {
	t["LicenseAssignmentManagerLicenseAssignment"] = reflect.TypeOf((*LicenseAssignmentManagerLicenseAssignment)(nil)).Elem()
}

type LicenseAvailabilityInfo struct {
	DynamicData

	Feature   LicenseFeatureInfo `xml:"feature"`
	Total     int                `xml:"total"`
	Available int                `xml:"available"`
}

func init() {
	t["LicenseAvailabilityInfo"] = reflect.TypeOf((*LicenseAvailabilityInfo)(nil)).Elem()
}

type LicenseDiagnostics struct {
	DynamicData

	SourceLastChanged      time.Time           `xml:"sourceLastChanged"`
	SourceLost             string              `xml:"sourceLost"`
	SourceLatency          float32             `xml:"sourceLatency"`
	LicenseRequests        string              `xml:"licenseRequests"`
	LicenseRequestFailures string              `xml:"licenseRequestFailures"`
	LicenseFeatureUnknowns string              `xml:"licenseFeatureUnknowns"`
	OpState                LicenseManagerState `xml:"opState"`
	LastStatusUpdate       time.Time           `xml:"lastStatusUpdate"`
	OpFailureMessage       string              `xml:"opFailureMessage"`
}

func init() {
	t["LicenseDiagnostics"] = reflect.TypeOf((*LicenseDiagnostics)(nil)).Elem()
}

type LicenseDowngradeDisallowed struct {
	NotEnoughLicenses

	Edition  string        `xml:"edition"`
	EntityId string        `xml:"entityId"`
	Features []KeyAnyValue `xml:"features"`
}

func init() {
	t["LicenseDowngradeDisallowed"] = reflect.TypeOf((*LicenseDowngradeDisallowed)(nil)).Elem()
}

type LicenseDowngradeDisallowedFault LicenseDowngradeDisallowed

func init() {
	t["LicenseDowngradeDisallowedFault"] = reflect.TypeOf((*LicenseDowngradeDisallowedFault)(nil)).Elem()
}

type LicenseEntityNotFound struct {
	VimFault

	EntityId string `xml:"entityId"`
}

func init() {
	t["LicenseEntityNotFound"] = reflect.TypeOf((*LicenseEntityNotFound)(nil)).Elem()
}

type LicenseEntityNotFoundFault LicenseEntityNotFound

func init() {
	t["LicenseEntityNotFoundFault"] = reflect.TypeOf((*LicenseEntityNotFoundFault)(nil)).Elem()
}

type LicenseEvent struct {
	Event
}

func init() {
	t["LicenseEvent"] = reflect.TypeOf((*LicenseEvent)(nil)).Elem()
}

type LicenseExpired struct {
	NotEnoughLicenses

	LicenseKey string `xml:"licenseKey"`
}

func init() {
	t["LicenseExpired"] = reflect.TypeOf((*LicenseExpired)(nil)).Elem()
}

type LicenseExpiredEvent struct {
	Event

	Feature LicenseFeatureInfo `xml:"feature"`
}

func init() {
	t["LicenseExpiredEvent"] = reflect.TypeOf((*LicenseExpiredEvent)(nil)).Elem()
}

type LicenseExpiredFault LicenseExpired

func init() {
	t["LicenseExpiredFault"] = reflect.TypeOf((*LicenseExpiredFault)(nil)).Elem()
}

type LicenseFeatureInfo struct {
	DynamicData

	Key                string                  `xml:"key"`
	FeatureName        string                  `xml:"featureName"`
	FeatureDescription string                  `xml:"featureDescription,omitempty"`
	State              LicenseFeatureInfoState `xml:"state,omitempty"`
	CostUnit           string                  `xml:"costUnit"`
	SourceRestriction  string                  `xml:"sourceRestriction,omitempty"`
	DependentKey       []string                `xml:"dependentKey,omitempty"`
	Edition            *bool                   `xml:"edition"`
	ExpiresOn          *time.Time              `xml:"expiresOn"`
}

func init() {
	t["LicenseFeatureInfo"] = reflect.TypeOf((*LicenseFeatureInfo)(nil)).Elem()
}

type LicenseKeyEntityMismatch struct {
	NotEnoughLicenses
}

func init() {
	t["LicenseKeyEntityMismatch"] = reflect.TypeOf((*LicenseKeyEntityMismatch)(nil)).Elem()
}

type LicenseKeyEntityMismatchFault LicenseKeyEntityMismatch

func init() {
	t["LicenseKeyEntityMismatchFault"] = reflect.TypeOf((*LicenseKeyEntityMismatchFault)(nil)).Elem()
}

type LicenseManagerEvaluationInfo struct {
	DynamicData

	Properties []KeyAnyValue `xml:"properties"`
}

func init() {
	t["LicenseManagerEvaluationInfo"] = reflect.TypeOf((*LicenseManagerEvaluationInfo)(nil)).Elem()
}

type LicenseManagerLicenseInfo struct {
	DynamicData

	LicenseKey string        `xml:"licenseKey"`
	EditionKey string        `xml:"editionKey"`
	Name       string        `xml:"name"`
	Total      int           `xml:"total"`
	Used       int           `xml:"used,omitempty"`
	CostUnit   string        `xml:"costUnit"`
	Properties []KeyAnyValue `xml:"properties,omitempty"`
	Labels     []KeyValue    `xml:"labels,omitempty"`
}

func init() {
	t["LicenseManagerLicenseInfo"] = reflect.TypeOf((*LicenseManagerLicenseInfo)(nil)).Elem()
}

type LicenseNonComplianceEvent struct {
	LicenseEvent

	Url string `xml:"url"`
}

func init() {
	t["LicenseNonComplianceEvent"] = reflect.TypeOf((*LicenseNonComplianceEvent)(nil)).Elem()
}

type LicenseReservationInfo struct {
	DynamicData

	Key      string                      `xml:"key"`
	State    LicenseReservationInfoState `xml:"state"`
	Required int                         `xml:"required"`
}

func init() {
	t["LicenseReservationInfo"] = reflect.TypeOf((*LicenseReservationInfo)(nil)).Elem()
}

type LicenseRestricted struct {
	NotEnoughLicenses
}

func init() {
	t["LicenseRestricted"] = reflect.TypeOf((*LicenseRestricted)(nil)).Elem()
}

type LicenseRestrictedEvent struct {
	LicenseEvent
}

func init() {
	t["LicenseRestrictedEvent"] = reflect.TypeOf((*LicenseRestrictedEvent)(nil)).Elem()
}

type LicenseRestrictedFault LicenseRestricted

func init() {
	t["LicenseRestrictedFault"] = reflect.TypeOf((*LicenseRestrictedFault)(nil)).Elem()
}

type LicenseServerAvailableEvent struct {
	LicenseEvent

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerAvailableEvent"] = reflect.TypeOf((*LicenseServerAvailableEvent)(nil)).Elem()
}

type LicenseServerSource struct {
	LicenseSource

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerSource"] = reflect.TypeOf((*LicenseServerSource)(nil)).Elem()
}

type LicenseServerUnavailable struct {
	VimFault

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerUnavailable"] = reflect.TypeOf((*LicenseServerUnavailable)(nil)).Elem()
}

type LicenseServerUnavailableEvent struct {
	LicenseEvent

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerUnavailableEvent"] = reflect.TypeOf((*LicenseServerUnavailableEvent)(nil)).Elem()
}

type LicenseServerUnavailableFault LicenseServerUnavailable

func init() {
	t["LicenseServerUnavailableFault"] = reflect.TypeOf((*LicenseServerUnavailableFault)(nil)).Elem()
}

type LicenseSource struct {
	DynamicData
}

func init() {
	t["LicenseSource"] = reflect.TypeOf((*LicenseSource)(nil)).Elem()
}

type LicenseSourceUnavailable struct {
	NotEnoughLicenses

	LicenseSource BaseLicenseSource `xml:"licenseSource,typeattr"`
}

func init() {
	t["LicenseSourceUnavailable"] = reflect.TypeOf((*LicenseSourceUnavailable)(nil)).Elem()
}

type LicenseSourceUnavailableFault LicenseSourceUnavailable

func init() {
	t["LicenseSourceUnavailableFault"] = reflect.TypeOf((*LicenseSourceUnavailableFault)(nil)).Elem()
}

type LicenseUsageInfo struct {
	DynamicData

	Source          BaseLicenseSource        `xml:"source,typeattr"`
	SourceAvailable bool                     `xml:"sourceAvailable"`
	ReservationInfo []LicenseReservationInfo `xml:"reservationInfo,omitempty"`
	FeatureInfo     []LicenseFeatureInfo     `xml:"featureInfo,omitempty"`
}

func init() {
	t["LicenseUsageInfo"] = reflect.TypeOf((*LicenseUsageInfo)(nil)).Elem()
}

type LimitExceeded struct {
	VimFault

	Property string `xml:"property,omitempty"`
	Limit    int    `xml:"limit,omitempty"`
}

func init() {
	t["LimitExceeded"] = reflect.TypeOf((*LimitExceeded)(nil)).Elem()
}

type LimitExceededFault LimitExceeded

func init() {
	t["LimitExceededFault"] = reflect.TypeOf((*LimitExceededFault)(nil)).Elem()
}

type LinkDiscoveryProtocolConfig struct {
	DynamicData

	Protocol  string `xml:"protocol"`
	Operation string `xml:"operation"`
}

func init() {
	t["LinkDiscoveryProtocolConfig"] = reflect.TypeOf((*LinkDiscoveryProtocolConfig)(nil)).Elem()
}

type LinkLayerDiscoveryProtocolInfo struct {
	DynamicData

	ChassisId  string        `xml:"chassisId"`
	PortId     string        `xml:"portId"`
	TimeToLive int           `xml:"timeToLive"`
	Parameter  []KeyAnyValue `xml:"parameter,omitempty"`
}

func init() {
	t["LinkLayerDiscoveryProtocolInfo"] = reflect.TypeOf((*LinkLayerDiscoveryProtocolInfo)(nil)).Elem()
}

type LinkProfile struct {
	ApplyProfile
}

func init() {
	t["LinkProfile"] = reflect.TypeOf((*LinkProfile)(nil)).Elem()
}

type LinuxVolumeNotClean struct {
	CustomizationFault
}

func init() {
	t["LinuxVolumeNotClean"] = reflect.TypeOf((*LinuxVolumeNotClean)(nil)).Elem()
}

type LinuxVolumeNotCleanFault LinuxVolumeNotClean

func init() {
	t["LinuxVolumeNotCleanFault"] = reflect.TypeOf((*LinuxVolumeNotCleanFault)(nil)).Elem()
}

type ListFilesInGuest ListFilesInGuestRequestType

func init() {
	t["ListFilesInGuest"] = reflect.TypeOf((*ListFilesInGuest)(nil)).Elem()
}

type ListFilesInGuestRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Vm           ManagedObjectReference  `xml:"vm"`
	Auth         BaseGuestAuthentication `xml:"auth,typeattr"`
	FilePath     string                  `xml:"filePath"`
	Index        int                     `xml:"index,omitempty"`
	MaxResults   int                     `xml:"maxResults,omitempty"`
	MatchPattern string                  `xml:"matchPattern,omitempty"`
}

func init() {
	t["ListFilesInGuestRequestType"] = reflect.TypeOf((*ListFilesInGuestRequestType)(nil)).Elem()
}

type ListFilesInGuestResponse struct {
	Returnval GuestListFileInfo `xml:"returnval"`
}

type ListProcessesInGuest ListProcessesInGuestRequestType

func init() {
	t["ListProcessesInGuest"] = reflect.TypeOf((*ListProcessesInGuest)(nil)).Elem()
}

type ListProcessesInGuestRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Auth BaseGuestAuthentication `xml:"auth,typeattr"`
	Pids []int64                 `xml:"pids,omitempty"`
}

func init() {
	t["ListProcessesInGuestRequestType"] = reflect.TypeOf((*ListProcessesInGuestRequestType)(nil)).Elem()
}

type ListProcessesInGuestResponse struct {
	Returnval []GuestProcessInfo `xml:"returnval,omitempty"`
}

type LocalDatastoreCreatedEvent struct {
	HostEvent

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["LocalDatastoreCreatedEvent"] = reflect.TypeOf((*LocalDatastoreCreatedEvent)(nil)).Elem()
}

type LocalDatastoreInfo struct {
	DatastoreInfo

	Path string `xml:"path,omitempty"`
}

func init() {
	t["LocalDatastoreInfo"] = reflect.TypeOf((*LocalDatastoreInfo)(nil)).Elem()
}

type LocalLicenseSource struct {
	LicenseSource

	LicenseKeys string `xml:"licenseKeys"`
}

func init() {
	t["LocalLicenseSource"] = reflect.TypeOf((*LocalLicenseSource)(nil)).Elem()
}

type LocalTSMEnabledEvent struct {
	HostEvent
}

func init() {
	t["LocalTSMEnabledEvent"] = reflect.TypeOf((*LocalTSMEnabledEvent)(nil)).Elem()
}

type LocalizableMessage struct {
	DynamicData

	Key     string        `xml:"key"`
	Arg     []KeyAnyValue `xml:"arg,omitempty"`
	Message string        `xml:"message,omitempty"`
}

func init() {
	t["LocalizableMessage"] = reflect.TypeOf((*LocalizableMessage)(nil)).Elem()
}

type LocalizationManagerMessageCatalog struct {
	DynamicData

	ModuleName   string     `xml:"moduleName"`
	CatalogName  string     `xml:"catalogName"`
	Locale       string     `xml:"locale"`
	CatalogUri   string     `xml:"catalogUri"`
	LastModified *time.Time `xml:"lastModified"`
	Md5sum       string     `xml:"md5sum,omitempty"`
	Version      string     `xml:"version,omitempty"`
}

func init() {
	t["LocalizationManagerMessageCatalog"] = reflect.TypeOf((*LocalizationManagerMessageCatalog)(nil)).Elem()
}

type LocalizedMethodFault struct {
	DynamicData

	Fault            BaseMethodFault `xml:"fault,typeattr"`
	LocalizedMessage string          `xml:"localizedMessage,omitempty"`
}

func init() {
	t["LocalizedMethodFault"] = reflect.TypeOf((*LocalizedMethodFault)(nil)).Elem()
}

type LockerMisconfiguredEvent struct {
	Event

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["LockerMisconfiguredEvent"] = reflect.TypeOf((*LockerMisconfiguredEvent)(nil)).Elem()
}

type LockerReconfiguredEvent struct {
	Event

	OldDatastore *DatastoreEventArgument `xml:"oldDatastore,omitempty"`
	NewDatastore *DatastoreEventArgument `xml:"newDatastore,omitempty"`
}

func init() {
	t["LockerReconfiguredEvent"] = reflect.TypeOf((*LockerReconfiguredEvent)(nil)).Elem()
}

type LogBundlingFailed struct {
	VimFault
}

func init() {
	t["LogBundlingFailed"] = reflect.TypeOf((*LogBundlingFailed)(nil)).Elem()
}

type LogBundlingFailedFault LogBundlingFailed

func init() {
	t["LogBundlingFailedFault"] = reflect.TypeOf((*LogBundlingFailedFault)(nil)).Elem()
}

type LogUserEvent LogUserEventRequestType

func init() {
	t["LogUserEvent"] = reflect.TypeOf((*LogUserEvent)(nil)).Elem()
}

type LogUserEventRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Msg    string                 `xml:"msg"`
}

func init() {
	t["LogUserEventRequestType"] = reflect.TypeOf((*LogUserEventRequestType)(nil)).Elem()
}

type LogUserEventResponse struct {
}

type Login LoginRequestType

func init() {
	t["Login"] = reflect.TypeOf((*Login)(nil)).Elem()
}

type LoginBySSPI LoginBySSPIRequestType

func init() {
	t["LoginBySSPI"] = reflect.TypeOf((*LoginBySSPI)(nil)).Elem()
}

type LoginBySSPIRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Base64Token string                 `xml:"base64Token"`
	Locale      string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginBySSPIRequestType"] = reflect.TypeOf((*LoginBySSPIRequestType)(nil)).Elem()
}

type LoginBySSPIResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginByToken LoginByTokenRequestType

func init() {
	t["LoginByToken"] = reflect.TypeOf((*LoginByToken)(nil)).Elem()
}

type LoginByTokenRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Locale string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginByTokenRequestType"] = reflect.TypeOf((*LoginByTokenRequestType)(nil)).Elem()
}

type LoginByTokenResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginExtensionByCertificate LoginExtensionByCertificateRequestType

func init() {
	t["LoginExtensionByCertificate"] = reflect.TypeOf((*LoginExtensionByCertificate)(nil)).Elem()
}

type LoginExtensionByCertificateRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
	Locale       string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginExtensionByCertificateRequestType"] = reflect.TypeOf((*LoginExtensionByCertificateRequestType)(nil)).Elem()
}

type LoginExtensionByCertificateResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginExtensionBySubjectName LoginExtensionBySubjectNameRequestType

func init() {
	t["LoginExtensionBySubjectName"] = reflect.TypeOf((*LoginExtensionBySubjectName)(nil)).Elem()
}

type LoginExtensionBySubjectNameRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
	Locale       string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginExtensionBySubjectNameRequestType"] = reflect.TypeOf((*LoginExtensionBySubjectNameRequestType)(nil)).Elem()
}

type LoginExtensionBySubjectNameResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
	Password string                 `xml:"password"`
	Locale   string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginRequestType"] = reflect.TypeOf((*LoginRequestType)(nil)).Elem()
}

type LoginResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type Logout LogoutRequestType

func init() {
	t["Logout"] = reflect.TypeOf((*Logout)(nil)).Elem()
}

type LogoutRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["LogoutRequestType"] = reflect.TypeOf((*LogoutRequestType)(nil)).Elem()
}

type LogoutResponse struct {
}

type LongOption struct {
	OptionType

	Min          int64 `xml:"min"`
	Max          int64 `xml:"max"`
	DefaultValue int64 `xml:"defaultValue"`
}

func init() {
	t["LongOption"] = reflect.TypeOf((*LongOption)(nil)).Elem()
}

type LongPolicy struct {
	InheritablePolicy

	Value int64 `xml:"value,omitempty"`
}

func init() {
	t["LongPolicy"] = reflect.TypeOf((*LongPolicy)(nil)).Elem()
}

type LookupDvPortGroup LookupDvPortGroupRequestType

func init() {
	t["LookupDvPortGroup"] = reflect.TypeOf((*LookupDvPortGroup)(nil)).Elem()
}

type LookupDvPortGroupRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	PortgroupKey string                 `xml:"portgroupKey"`
}

func init() {
	t["LookupDvPortGroupRequestType"] = reflect.TypeOf((*LookupDvPortGroupRequestType)(nil)).Elem()
}

type LookupDvPortGroupResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type MacAddress struct {
	NegatableExpression
}

func init() {
	t["MacAddress"] = reflect.TypeOf((*MacAddress)(nil)).Elem()
}

type MacRange struct {
	MacAddress

	Address string `xml:"address"`
	Mask    string `xml:"mask"`
}

func init() {
	t["MacRange"] = reflect.TypeOf((*MacRange)(nil)).Elem()
}

type MaintenanceModeFileMove struct {
	MigrationFault
}

func init() {
	t["MaintenanceModeFileMove"] = reflect.TypeOf((*MaintenanceModeFileMove)(nil)).Elem()
}

type MaintenanceModeFileMoveFault MaintenanceModeFileMove

func init() {
	t["MaintenanceModeFileMoveFault"] = reflect.TypeOf((*MaintenanceModeFileMoveFault)(nil)).Elem()
}

type MakeDirectory MakeDirectoryRequestType

func init() {
	t["MakeDirectory"] = reflect.TypeOf((*MakeDirectory)(nil)).Elem()
}

type MakeDirectoryInGuest MakeDirectoryInGuestRequestType

func init() {
	t["MakeDirectoryInGuest"] = reflect.TypeOf((*MakeDirectoryInGuest)(nil)).Elem()
}

type MakeDirectoryInGuestRequestType struct {
	This                    ManagedObjectReference  `xml:"_this"`
	Vm                      ManagedObjectReference  `xml:"vm"`
	Auth                    BaseGuestAuthentication `xml:"auth,typeattr"`
	DirectoryPath           string                  `xml:"directoryPath"`
	CreateParentDirectories bool                    `xml:"createParentDirectories"`
}

func init() {
	t["MakeDirectoryInGuestRequestType"] = reflect.TypeOf((*MakeDirectoryInGuestRequestType)(nil)).Elem()
}

type MakeDirectoryInGuestResponse struct {
}

type MakeDirectoryRequestType struct {
	This                    ManagedObjectReference  `xml:"_this"`
	Name                    string                  `xml:"name"`
	Datacenter              *ManagedObjectReference `xml:"datacenter,omitempty"`
	CreateParentDirectories *bool                   `xml:"createParentDirectories"`
}

func init() {
	t["MakeDirectoryRequestType"] = reflect.TypeOf((*MakeDirectoryRequestType)(nil)).Elem()
}

type MakeDirectoryResponse struct {
}

type MakePrimaryVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Vm   ManagedObjectReference `xml:"vm"`
}

func init() {
	t["MakePrimaryVMRequestType"] = reflect.TypeOf((*MakePrimaryVMRequestType)(nil)).Elem()
}

type MakePrimaryVM_Task MakePrimaryVMRequestType

func init() {
	t["MakePrimaryVM_Task"] = reflect.TypeOf((*MakePrimaryVM_Task)(nil)).Elem()
}

type MakePrimaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ManagedByInfo struct {
	DynamicData

	ExtensionKey string `xml:"extensionKey"`
	Type         string `xml:"type"`
}

func init() {
	t["ManagedByInfo"] = reflect.TypeOf((*ManagedByInfo)(nil)).Elem()
}

type ManagedEntityEventArgument struct {
	EntityEventArgument

	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["ManagedEntityEventArgument"] = reflect.TypeOf((*ManagedEntityEventArgument)(nil)).Elem()
}

type ManagedObjectNotFound struct {
	RuntimeFault

	Obj ManagedObjectReference `xml:"obj"`
}

func init() {
	t["ManagedObjectNotFound"] = reflect.TypeOf((*ManagedObjectNotFound)(nil)).Elem()
}

type ManagedObjectNotFoundFault ManagedObjectNotFound

func init() {
	t["ManagedObjectNotFoundFault"] = reflect.TypeOf((*ManagedObjectNotFoundFault)(nil)).Elem()
}

type ManagedObjectReference struct {
	Type  string `xml:"type,attr"`
	Value string `xml:",chardata"`
}

func init() {
	t["ManagedObjectReference"] = reflect.TypeOf((*ManagedObjectReference)(nil)).Elem()
}

type MarkAsTemplate MarkAsTemplateRequestType

func init() {
	t["MarkAsTemplate"] = reflect.TypeOf((*MarkAsTemplate)(nil)).Elem()
}

type MarkAsTemplateRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["MarkAsTemplateRequestType"] = reflect.TypeOf((*MarkAsTemplateRequestType)(nil)).Elem()
}

type MarkAsTemplateResponse struct {
}

type MarkAsVirtualMachine MarkAsVirtualMachineRequestType

func init() {
	t["MarkAsVirtualMachine"] = reflect.TypeOf((*MarkAsVirtualMachine)(nil)).Elem()
}

type MarkAsVirtualMachineRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Pool ManagedObjectReference  `xml:"pool"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["MarkAsVirtualMachineRequestType"] = reflect.TypeOf((*MarkAsVirtualMachineRequestType)(nil)).Elem()
}

type MarkAsVirtualMachineResponse struct {
}

type MarkForRemoval MarkForRemovalRequestType

func init() {
	t["MarkForRemoval"] = reflect.TypeOf((*MarkForRemoval)(nil)).Elem()
}

type MarkForRemovalRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	HbaName string                 `xml:"hbaName"`
	Remove  bool                   `xml:"remove"`
}

func init() {
	t["MarkForRemovalRequestType"] = reflect.TypeOf((*MarkForRemovalRequestType)(nil)).Elem()
}

type MarkForRemovalResponse struct {
}

type MemoryHotPlugNotSupported struct {
	VmConfigFault
}

func init() {
	t["MemoryHotPlugNotSupported"] = reflect.TypeOf((*MemoryHotPlugNotSupported)(nil)).Elem()
}

type MemoryHotPlugNotSupportedFault MemoryHotPlugNotSupported

func init() {
	t["MemoryHotPlugNotSupportedFault"] = reflect.TypeOf((*MemoryHotPlugNotSupportedFault)(nil)).Elem()
}

type MemorySizeNotRecommended struct {
	VirtualHardwareCompatibilityIssue

	MemorySizeMB    int `xml:"memorySizeMB"`
	MinMemorySizeMB int `xml:"minMemorySizeMB"`
	MaxMemorySizeMB int `xml:"maxMemorySizeMB"`
}

func init() {
	t["MemorySizeNotRecommended"] = reflect.TypeOf((*MemorySizeNotRecommended)(nil)).Elem()
}

type MemorySizeNotRecommendedFault MemorySizeNotRecommended

func init() {
	t["MemorySizeNotRecommendedFault"] = reflect.TypeOf((*MemorySizeNotRecommendedFault)(nil)).Elem()
}

type MemorySizeNotSupported struct {
	VirtualHardwareCompatibilityIssue

	MemorySizeMB    int `xml:"memorySizeMB"`
	MinMemorySizeMB int `xml:"minMemorySizeMB"`
	MaxMemorySizeMB int `xml:"maxMemorySizeMB"`
}

func init() {
	t["MemorySizeNotSupported"] = reflect.TypeOf((*MemorySizeNotSupported)(nil)).Elem()
}

type MemorySizeNotSupportedByDatastore struct {
	VirtualHardwareCompatibilityIssue

	Datastore       ManagedObjectReference `xml:"datastore"`
	MemorySizeMB    int                    `xml:"memorySizeMB"`
	MaxMemorySizeMB int                    `xml:"maxMemorySizeMB"`
}

func init() {
	t["MemorySizeNotSupportedByDatastore"] = reflect.TypeOf((*MemorySizeNotSupportedByDatastore)(nil)).Elem()
}

type MemorySizeNotSupportedByDatastoreFault MemorySizeNotSupportedByDatastore

func init() {
	t["MemorySizeNotSupportedByDatastoreFault"] = reflect.TypeOf((*MemorySizeNotSupportedByDatastoreFault)(nil)).Elem()
}

type MemorySizeNotSupportedFault MemorySizeNotSupported

func init() {
	t["MemorySizeNotSupportedFault"] = reflect.TypeOf((*MemorySizeNotSupportedFault)(nil)).Elem()
}

type MemorySnapshotOnIndependentDisk struct {
	SnapshotFault
}

func init() {
	t["MemorySnapshotOnIndependentDisk"] = reflect.TypeOf((*MemorySnapshotOnIndependentDisk)(nil)).Elem()
}

type MemorySnapshotOnIndependentDiskFault MemorySnapshotOnIndependentDisk

func init() {
	t["MemorySnapshotOnIndependentDiskFault"] = reflect.TypeOf((*MemorySnapshotOnIndependentDiskFault)(nil)).Elem()
}

type MergeDvsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Dvs  ManagedObjectReference `xml:"dvs"`
}

func init() {
	t["MergeDvsRequestType"] = reflect.TypeOf((*MergeDvsRequestType)(nil)).Elem()
}

type MergeDvs_Task MergeDvsRequestType

func init() {
	t["MergeDvs_Task"] = reflect.TypeOf((*MergeDvs_Task)(nil)).Elem()
}

type MergeDvs_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MergePermissions MergePermissionsRequestType

func init() {
	t["MergePermissions"] = reflect.TypeOf((*MergePermissions)(nil)).Elem()
}

type MergePermissionsRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	SrcRoleId int                    `xml:"srcRoleId"`
	DstRoleId int                    `xml:"dstRoleId"`
}

func init() {
	t["MergePermissionsRequestType"] = reflect.TypeOf((*MergePermissionsRequestType)(nil)).Elem()
}

type MergePermissionsResponse struct {
}

type MethodAction struct {
	Action

	Name     string                 `xml:"name"`
	Argument []MethodActionArgument `xml:"argument,omitempty"`
}

func init() {
	t["MethodAction"] = reflect.TypeOf((*MethodAction)(nil)).Elem()
}

type MethodActionArgument struct {
	DynamicData

	Value AnyType `xml:"value,omitempty,typeattr"`
}

func init() {
	t["MethodActionArgument"] = reflect.TypeOf((*MethodActionArgument)(nil)).Elem()
}

type MethodAlreadyDisabledFault struct {
	RuntimeFault

	SourceId string `xml:"sourceId"`
}

func init() {
	t["MethodAlreadyDisabledFault"] = reflect.TypeOf((*MethodAlreadyDisabledFault)(nil)).Elem()
}

type MethodAlreadyDisabledFaultFault MethodAlreadyDisabledFault

func init() {
	t["MethodAlreadyDisabledFaultFault"] = reflect.TypeOf((*MethodAlreadyDisabledFaultFault)(nil)).Elem()
}

type MethodDescription struct {
	Description

	Key string `xml:"key"`
}

func init() {
	t["MethodDescription"] = reflect.TypeOf((*MethodDescription)(nil)).Elem()
}

type MethodDisabled struct {
	RuntimeFault

	Source string `xml:"source,omitempty"`
}

func init() {
	t["MethodDisabled"] = reflect.TypeOf((*MethodDisabled)(nil)).Elem()
}

type MethodDisabledFault MethodDisabled

func init() {
	t["MethodDisabledFault"] = reflect.TypeOf((*MethodDisabledFault)(nil)).Elem()
}

type MethodFault struct {
	DynamicType     string                `xml:"dynamicType,omitempty"`
	DynamicProperty []DynamicProperty     `xml:"dynamicProperty,omitempty"`
	FaultCause      *LocalizedMethodFault `xml:"faultCause,omitempty"`
	FaultMessage    []LocalizableMessage  `xml:"faultMessage,omitempty"`
}

func init() {
	t["MethodFault"] = reflect.TypeOf((*MethodFault)(nil)).Elem()
}

type MethodFaultFault BaseMethodFault

func init() {
	t["MethodFaultFault"] = reflect.TypeOf((*MethodFaultFault)(nil)).Elem()
}

type MethodNotFound struct {
	InvalidRequest

	Receiver ManagedObjectReference `xml:"receiver"`
	Method   string                 `xml:"method"`
}

func init() {
	t["MethodNotFound"] = reflect.TypeOf((*MethodNotFound)(nil)).Elem()
}

type MethodNotFoundFault MethodNotFound

func init() {
	t["MethodNotFoundFault"] = reflect.TypeOf((*MethodNotFoundFault)(nil)).Elem()
}

type MetricAlarmExpression struct {
	AlarmExpression

	Operator       MetricAlarmOperator `xml:"operator"`
	Type           string              `xml:"type"`
	Metric         PerfMetricId        `xml:"metric"`
	Yellow         int                 `xml:"yellow,omitempty"`
	YellowInterval int                 `xml:"yellowInterval,omitempty"`
	Red            int                 `xml:"red,omitempty"`
	RedInterval    int                 `xml:"redInterval,omitempty"`
}

func init() {
	t["MetricAlarmExpression"] = reflect.TypeOf((*MetricAlarmExpression)(nil)).Elem()
}

type MigrateVMRequestType struct {
	This     ManagedObjectReference     `xml:"_this"`
	Pool     *ManagedObjectReference    `xml:"pool,omitempty"`
	Host     *ManagedObjectReference    `xml:"host,omitempty"`
	Priority VirtualMachineMovePriority `xml:"priority"`
	State    VirtualMachinePowerState   `xml:"state,omitempty"`
}

func init() {
	t["MigrateVMRequestType"] = reflect.TypeOf((*MigrateVMRequestType)(nil)).Elem()
}

type MigrateVM_Task MigrateVMRequestType

func init() {
	t["MigrateVM_Task"] = reflect.TypeOf((*MigrateVM_Task)(nil)).Elem()
}

type MigrateVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MigrationDisabled struct {
	MigrationFault
}

func init() {
	t["MigrationDisabled"] = reflect.TypeOf((*MigrationDisabled)(nil)).Elem()
}

type MigrationDisabledFault MigrationDisabled

func init() {
	t["MigrationDisabledFault"] = reflect.TypeOf((*MigrationDisabledFault)(nil)).Elem()
}

type MigrationErrorEvent struct {
	MigrationEvent
}

func init() {
	t["MigrationErrorEvent"] = reflect.TypeOf((*MigrationErrorEvent)(nil)).Elem()
}

type MigrationEvent struct {
	VmEvent

	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["MigrationEvent"] = reflect.TypeOf((*MigrationEvent)(nil)).Elem()
}

type MigrationFault struct {
	VimFault
}

func init() {
	t["MigrationFault"] = reflect.TypeOf((*MigrationFault)(nil)).Elem()
}

type MigrationFaultFault BaseMigrationFault

func init() {
	t["MigrationFaultFault"] = reflect.TypeOf((*MigrationFaultFault)(nil)).Elem()
}

type MigrationFeatureNotSupported struct {
	MigrationFault

	AtSourceHost   bool                   `xml:"atSourceHost"`
	FailedHostName string                 `xml:"failedHostName"`
	FailedHost     ManagedObjectReference `xml:"failedHost"`
}

func init() {
	t["MigrationFeatureNotSupported"] = reflect.TypeOf((*MigrationFeatureNotSupported)(nil)).Elem()
}

type MigrationFeatureNotSupportedFault BaseMigrationFeatureNotSupported

func init() {
	t["MigrationFeatureNotSupportedFault"] = reflect.TypeOf((*MigrationFeatureNotSupportedFault)(nil)).Elem()
}

type MigrationHostErrorEvent struct {
	MigrationEvent

	DstHost HostEventArgument `xml:"dstHost"`
}

func init() {
	t["MigrationHostErrorEvent"] = reflect.TypeOf((*MigrationHostErrorEvent)(nil)).Elem()
}

type MigrationHostWarningEvent struct {
	MigrationEvent

	DstHost HostEventArgument `xml:"dstHost"`
}

func init() {
	t["MigrationHostWarningEvent"] = reflect.TypeOf((*MigrationHostWarningEvent)(nil)).Elem()
}

type MigrationNotReady struct {
	MigrationFault

	Reason string `xml:"reason"`
}

func init() {
	t["MigrationNotReady"] = reflect.TypeOf((*MigrationNotReady)(nil)).Elem()
}

type MigrationNotReadyFault MigrationNotReady

func init() {
	t["MigrationNotReadyFault"] = reflect.TypeOf((*MigrationNotReadyFault)(nil)).Elem()
}

type MigrationResourceErrorEvent struct {
	MigrationEvent

	DstPool ResourcePoolEventArgument `xml:"dstPool"`
	DstHost HostEventArgument         `xml:"dstHost"`
}

func init() {
	t["MigrationResourceErrorEvent"] = reflect.TypeOf((*MigrationResourceErrorEvent)(nil)).Elem()
}

type MigrationResourceWarningEvent struct {
	MigrationEvent

	DstPool ResourcePoolEventArgument `xml:"dstPool"`
	DstHost HostEventArgument         `xml:"dstHost"`
}

func init() {
	t["MigrationResourceWarningEvent"] = reflect.TypeOf((*MigrationResourceWarningEvent)(nil)).Elem()
}

type MigrationWarningEvent struct {
	MigrationEvent
}

func init() {
	t["MigrationWarningEvent"] = reflect.TypeOf((*MigrationWarningEvent)(nil)).Elem()
}

type MismatchedBundle struct {
	VimFault

	BundleUuid        string `xml:"bundleUuid"`
	HostUuid          string `xml:"hostUuid"`
	BundleBuildNumber int    `xml:"bundleBuildNumber"`
	HostBuildNumber   int    `xml:"hostBuildNumber"`
}

func init() {
	t["MismatchedBundle"] = reflect.TypeOf((*MismatchedBundle)(nil)).Elem()
}

type MismatchedBundleFault MismatchedBundle

func init() {
	t["MismatchedBundleFault"] = reflect.TypeOf((*MismatchedBundleFault)(nil)).Elem()
}

type MismatchedNetworkPolicies struct {
	MigrationFault

	Device    string `xml:"device"`
	Backing   string `xml:"backing"`
	Connected bool   `xml:"connected"`
}

func init() {
	t["MismatchedNetworkPolicies"] = reflect.TypeOf((*MismatchedNetworkPolicies)(nil)).Elem()
}

type MismatchedNetworkPoliciesFault MismatchedNetworkPolicies

func init() {
	t["MismatchedNetworkPoliciesFault"] = reflect.TypeOf((*MismatchedNetworkPoliciesFault)(nil)).Elem()
}

type MismatchedVMotionNetworkNames struct {
	MigrationFault

	SourceNetwork string `xml:"sourceNetwork"`
	DestNetwork   string `xml:"destNetwork"`
}

func init() {
	t["MismatchedVMotionNetworkNames"] = reflect.TypeOf((*MismatchedVMotionNetworkNames)(nil)).Elem()
}

type MismatchedVMotionNetworkNamesFault MismatchedVMotionNetworkNames

func init() {
	t["MismatchedVMotionNetworkNamesFault"] = reflect.TypeOf((*MismatchedVMotionNetworkNamesFault)(nil)).Elem()
}

type MissingBmcSupport struct {
	VimFault
}

func init() {
	t["MissingBmcSupport"] = reflect.TypeOf((*MissingBmcSupport)(nil)).Elem()
}

type MissingBmcSupportFault MissingBmcSupport

func init() {
	t["MissingBmcSupportFault"] = reflect.TypeOf((*MissingBmcSupportFault)(nil)).Elem()
}

type MissingController struct {
	InvalidDeviceSpec
}

func init() {
	t["MissingController"] = reflect.TypeOf((*MissingController)(nil)).Elem()
}

type MissingControllerFault MissingController

func init() {
	t["MissingControllerFault"] = reflect.TypeOf((*MissingControllerFault)(nil)).Elem()
}

type MissingIpPool struct {
	VAppPropertyFault
}

func init() {
	t["MissingIpPool"] = reflect.TypeOf((*MissingIpPool)(nil)).Elem()
}

type MissingIpPoolFault MissingIpPool

func init() {
	t["MissingIpPoolFault"] = reflect.TypeOf((*MissingIpPoolFault)(nil)).Elem()
}

type MissingLinuxCustResources struct {
	CustomizationFault
}

func init() {
	t["MissingLinuxCustResources"] = reflect.TypeOf((*MissingLinuxCustResources)(nil)).Elem()
}

type MissingLinuxCustResourcesFault MissingLinuxCustResources

func init() {
	t["MissingLinuxCustResourcesFault"] = reflect.TypeOf((*MissingLinuxCustResourcesFault)(nil)).Elem()
}

type MissingNetworkIpConfig struct {
	VAppPropertyFault
}

func init() {
	t["MissingNetworkIpConfig"] = reflect.TypeOf((*MissingNetworkIpConfig)(nil)).Elem()
}

type MissingNetworkIpConfigFault MissingNetworkIpConfig

func init() {
	t["MissingNetworkIpConfigFault"] = reflect.TypeOf((*MissingNetworkIpConfigFault)(nil)).Elem()
}

type MissingObject struct {
	DynamicData

	Obj   ManagedObjectReference `xml:"obj"`
	Fault LocalizedMethodFault   `xml:"fault"`
}

func init() {
	t["MissingObject"] = reflect.TypeOf((*MissingObject)(nil)).Elem()
}

type MissingPowerOffConfiguration struct {
	VAppConfigFault
}

func init() {
	t["MissingPowerOffConfiguration"] = reflect.TypeOf((*MissingPowerOffConfiguration)(nil)).Elem()
}

type MissingPowerOffConfigurationFault MissingPowerOffConfiguration

func init() {
	t["MissingPowerOffConfigurationFault"] = reflect.TypeOf((*MissingPowerOffConfigurationFault)(nil)).Elem()
}

type MissingPowerOnConfiguration struct {
	VAppConfigFault
}

func init() {
	t["MissingPowerOnConfiguration"] = reflect.TypeOf((*MissingPowerOnConfiguration)(nil)).Elem()
}

type MissingPowerOnConfigurationFault MissingPowerOnConfiguration

func init() {
	t["MissingPowerOnConfigurationFault"] = reflect.TypeOf((*MissingPowerOnConfigurationFault)(nil)).Elem()
}

type MissingProperty struct {
	DynamicData

	Path  string               `xml:"path"`
	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["MissingProperty"] = reflect.TypeOf((*MissingProperty)(nil)).Elem()
}

type MissingWindowsCustResources struct {
	CustomizationFault
}

func init() {
	t["MissingWindowsCustResources"] = reflect.TypeOf((*MissingWindowsCustResources)(nil)).Elem()
}

type MissingWindowsCustResourcesFault MissingWindowsCustResources

func init() {
	t["MissingWindowsCustResourcesFault"] = reflect.TypeOf((*MissingWindowsCustResourcesFault)(nil)).Elem()
}

type MksConnectionLimitReached struct {
	InvalidState

	ConnectionLimit int `xml:"connectionLimit"`
}

func init() {
	t["MksConnectionLimitReached"] = reflect.TypeOf((*MksConnectionLimitReached)(nil)).Elem()
}

type MksConnectionLimitReachedFault MksConnectionLimitReached

func init() {
	t["MksConnectionLimitReachedFault"] = reflect.TypeOf((*MksConnectionLimitReachedFault)(nil)).Elem()
}

type ModeInfo struct {
	DynamicData

	Browse string `xml:"browse,omitempty"`
	Read   string `xml:"read"`
	Modify string `xml:"modify"`
	Use    string `xml:"use"`
	Admin  string `xml:"admin,omitempty"`
	Full   string `xml:"full"`
}

func init() {
	t["ModeInfo"] = reflect.TypeOf((*ModeInfo)(nil)).Elem()
}

type ModifyListView ModifyListViewRequestType

func init() {
	t["ModifyListView"] = reflect.TypeOf((*ModifyListView)(nil)).Elem()
}

type ModifyListViewRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Add    []ManagedObjectReference `xml:"add,omitempty"`
	Remove []ManagedObjectReference `xml:"remove,omitempty"`
}

func init() {
	t["ModifyListViewRequestType"] = reflect.TypeOf((*ModifyListViewRequestType)(nil)).Elem()
}

type ModifyListViewResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type MonthlyByDayTaskScheduler struct {
	MonthlyTaskScheduler

	Day int `xml:"day"`
}

func init() {
	t["MonthlyByDayTaskScheduler"] = reflect.TypeOf((*MonthlyByDayTaskScheduler)(nil)).Elem()
}

type MonthlyByWeekdayTaskScheduler struct {
	MonthlyTaskScheduler

	Offset  WeekOfMonth `xml:"offset"`
	Weekday DayOfWeek   `xml:"weekday"`
}

func init() {
	t["MonthlyByWeekdayTaskScheduler"] = reflect.TypeOf((*MonthlyByWeekdayTaskScheduler)(nil)).Elem()
}

type MonthlyTaskScheduler struct {
	DailyTaskScheduler
}

func init() {
	t["MonthlyTaskScheduler"] = reflect.TypeOf((*MonthlyTaskScheduler)(nil)).Elem()
}

type MountError struct {
	CustomizationFault

	Vm        ManagedObjectReference `xml:"vm"`
	DiskIndex int                    `xml:"diskIndex"`
}

func init() {
	t["MountError"] = reflect.TypeOf((*MountError)(nil)).Elem()
}

type MountErrorFault MountError

func init() {
	t["MountErrorFault"] = reflect.TypeOf((*MountErrorFault)(nil)).Elem()
}

type MountToolsInstaller MountToolsInstallerRequestType

func init() {
	t["MountToolsInstaller"] = reflect.TypeOf((*MountToolsInstaller)(nil)).Elem()
}

type MountToolsInstallerRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["MountToolsInstallerRequestType"] = reflect.TypeOf((*MountToolsInstallerRequestType)(nil)).Elem()
}

type MountToolsInstallerResponse struct {
}

type MountVffsVolume MountVffsVolumeRequestType

func init() {
	t["MountVffsVolume"] = reflect.TypeOf((*MountVffsVolume)(nil)).Elem()
}

type MountVffsVolumeRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VffsUuid string                 `xml:"vffsUuid"`
}

func init() {
	t["MountVffsVolumeRequestType"] = reflect.TypeOf((*MountVffsVolumeRequestType)(nil)).Elem()
}

type MountVffsVolumeResponse struct {
}

type MountVmfsVolume MountVmfsVolumeRequestType

func init() {
	t["MountVmfsVolume"] = reflect.TypeOf((*MountVmfsVolume)(nil)).Elem()
}

type MountVmfsVolumeRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsUuid string                 `xml:"vmfsUuid"`
}

func init() {
	t["MountVmfsVolumeRequestType"] = reflect.TypeOf((*MountVmfsVolumeRequestType)(nil)).Elem()
}

type MountVmfsVolumeResponse struct {
}

type MoveDVPortRequestType struct {
	This                    ManagedObjectReference `xml:"_this"`
	PortKey                 []string               `xml:"portKey"`
	DestinationPortgroupKey string                 `xml:"destinationPortgroupKey,omitempty"`
}

func init() {
	t["MoveDVPortRequestType"] = reflect.TypeOf((*MoveDVPortRequestType)(nil)).Elem()
}

type MoveDVPort_Task MoveDVPortRequestType

func init() {
	t["MoveDVPort_Task"] = reflect.TypeOf((*MoveDVPort_Task)(nil)).Elem()
}

type MoveDVPort_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveDatastoreFileRequestType struct {
	This                  ManagedObjectReference  `xml:"_this"`
	SourceName            string                  `xml:"sourceName"`
	SourceDatacenter      *ManagedObjectReference `xml:"sourceDatacenter,omitempty"`
	DestinationName       string                  `xml:"destinationName"`
	DestinationDatacenter *ManagedObjectReference `xml:"destinationDatacenter,omitempty"`
	Force                 *bool                   `xml:"force"`
}

func init() {
	t["MoveDatastoreFileRequestType"] = reflect.TypeOf((*MoveDatastoreFileRequestType)(nil)).Elem()
}

type MoveDatastoreFile_Task MoveDatastoreFileRequestType

func init() {
	t["MoveDatastoreFile_Task"] = reflect.TypeOf((*MoveDatastoreFile_Task)(nil)).Elem()
}

type MoveDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveDirectoryInGuest MoveDirectoryInGuestRequestType

func init() {
	t["MoveDirectoryInGuest"] = reflect.TypeOf((*MoveDirectoryInGuest)(nil)).Elem()
}

type MoveDirectoryInGuestRequestType struct {
	This             ManagedObjectReference  `xml:"_this"`
	Vm               ManagedObjectReference  `xml:"vm"`
	Auth             BaseGuestAuthentication `xml:"auth,typeattr"`
	SrcDirectoryPath string                  `xml:"srcDirectoryPath"`
	DstDirectoryPath string                  `xml:"dstDirectoryPath"`
}

func init() {
	t["MoveDirectoryInGuestRequestType"] = reflect.TypeOf((*MoveDirectoryInGuestRequestType)(nil)).Elem()
}

type MoveDirectoryInGuestResponse struct {
}

type MoveFileInGuest MoveFileInGuestRequestType

func init() {
	t["MoveFileInGuest"] = reflect.TypeOf((*MoveFileInGuest)(nil)).Elem()
}

type MoveFileInGuestRequestType struct {
	This        ManagedObjectReference  `xml:"_this"`
	Vm          ManagedObjectReference  `xml:"vm"`
	Auth        BaseGuestAuthentication `xml:"auth,typeattr"`
	SrcFilePath string                  `xml:"srcFilePath"`
	DstFilePath string                  `xml:"dstFilePath"`
	Overwrite   bool                    `xml:"overwrite"`
}

func init() {
	t["MoveFileInGuestRequestType"] = reflect.TypeOf((*MoveFileInGuestRequestType)(nil)).Elem()
}

type MoveFileInGuestResponse struct {
}

type MoveHostIntoRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Host         ManagedObjectReference  `xml:"host"`
	ResourcePool *ManagedObjectReference `xml:"resourcePool,omitempty"`
}

func init() {
	t["MoveHostIntoRequestType"] = reflect.TypeOf((*MoveHostIntoRequestType)(nil)).Elem()
}

type MoveHostInto_Task MoveHostIntoRequestType

func init() {
	t["MoveHostInto_Task"] = reflect.TypeOf((*MoveHostInto_Task)(nil)).Elem()
}

type MoveHostInto_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveIntoFolderRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	List []ManagedObjectReference `xml:"list"`
}

func init() {
	t["MoveIntoFolderRequestType"] = reflect.TypeOf((*MoveIntoFolderRequestType)(nil)).Elem()
}

type MoveIntoFolder_Task MoveIntoFolderRequestType

func init() {
	t["MoveIntoFolder_Task"] = reflect.TypeOf((*MoveIntoFolder_Task)(nil)).Elem()
}

type MoveIntoFolder_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveIntoRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["MoveIntoRequestType"] = reflect.TypeOf((*MoveIntoRequestType)(nil)).Elem()
}

type MoveIntoResourcePool MoveIntoResourcePoolRequestType

func init() {
	t["MoveIntoResourcePool"] = reflect.TypeOf((*MoveIntoResourcePool)(nil)).Elem()
}

type MoveIntoResourcePoolRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	List []ManagedObjectReference `xml:"list"`
}

func init() {
	t["MoveIntoResourcePoolRequestType"] = reflect.TypeOf((*MoveIntoResourcePoolRequestType)(nil)).Elem()
}

type MoveIntoResourcePoolResponse struct {
}

type MoveInto_Task MoveIntoRequestType

func init() {
	t["MoveInto_Task"] = reflect.TypeOf((*MoveInto_Task)(nil)).Elem()
}

type MoveInto_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveVirtualDiskRequestType struct {
	This             ManagedObjectReference          `xml:"_this"`
	SourceName       string                          `xml:"sourceName"`
	SourceDatacenter *ManagedObjectReference         `xml:"sourceDatacenter,omitempty"`
	DestName         string                          `xml:"destName"`
	DestDatacenter   *ManagedObjectReference         `xml:"destDatacenter,omitempty"`
	Force            *bool                           `xml:"force"`
	Profile          []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr"`
}

func init() {
	t["MoveVirtualDiskRequestType"] = reflect.TypeOf((*MoveVirtualDiskRequestType)(nil)).Elem()
}

type MoveVirtualDisk_Task MoveVirtualDiskRequestType

func init() {
	t["MoveVirtualDisk_Task"] = reflect.TypeOf((*MoveVirtualDisk_Task)(nil)).Elem()
}

type MoveVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MtuMatchEvent struct {
	DvsHealthStatusChangeEvent
}

func init() {
	t["MtuMatchEvent"] = reflect.TypeOf((*MtuMatchEvent)(nil)).Elem()
}

type MtuMismatchEvent struct {
	DvsHealthStatusChangeEvent
}

func init() {
	t["MtuMismatchEvent"] = reflect.TypeOf((*MtuMismatchEvent)(nil)).Elem()
}

type MultipleCertificatesVerifyFault struct {
	HostConnectFault

	ThumbprintData []MultipleCertificatesVerifyFaultThumbprintData `xml:"thumbprintData"`
}

func init() {
	t["MultipleCertificatesVerifyFault"] = reflect.TypeOf((*MultipleCertificatesVerifyFault)(nil)).Elem()
}

type MultipleCertificatesVerifyFaultFault MultipleCertificatesVerifyFault

func init() {
	t["MultipleCertificatesVerifyFaultFault"] = reflect.TypeOf((*MultipleCertificatesVerifyFaultFault)(nil)).Elem()
}

type MultipleCertificatesVerifyFaultThumbprintData struct {
	DynamicData

	Port       int    `xml:"port"`
	Thumbprint string `xml:"thumbprint"`
}

func init() {
	t["MultipleCertificatesVerifyFaultThumbprintData"] = reflect.TypeOf((*MultipleCertificatesVerifyFaultThumbprintData)(nil)).Elem()
}

type MultipleSnapshotsNotSupported struct {
	SnapshotFault
}

func init() {
	t["MultipleSnapshotsNotSupported"] = reflect.TypeOf((*MultipleSnapshotsNotSupported)(nil)).Elem()
}

type MultipleSnapshotsNotSupportedFault MultipleSnapshotsNotSupported

func init() {
	t["MultipleSnapshotsNotSupportedFault"] = reflect.TypeOf((*MultipleSnapshotsNotSupportedFault)(nil)).Elem()
}

type NASDatastoreCreatedEvent struct {
	HostEvent

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["NASDatastoreCreatedEvent"] = reflect.TypeOf((*NASDatastoreCreatedEvent)(nil)).Elem()
}

type NamePasswordAuthentication struct {
	GuestAuthentication

	Username string `xml:"username"`
	Password string `xml:"password"`
}

func init() {
	t["NamePasswordAuthentication"] = reflect.TypeOf((*NamePasswordAuthentication)(nil)).Elem()
}

type NamespaceFull struct {
	VimFault

	Name           string `xml:"name"`
	CurrentMaxSize int64  `xml:"currentMaxSize"`
	RequiredSize   int64  `xml:"requiredSize,omitempty"`
}

func init() {
	t["NamespaceFull"] = reflect.TypeOf((*NamespaceFull)(nil)).Elem()
}

type NamespaceFullFault NamespaceFull

func init() {
	t["NamespaceFullFault"] = reflect.TypeOf((*NamespaceFullFault)(nil)).Elem()
}

type NamespaceLimitReached struct {
	VimFault

	Limit int `xml:"limit,omitempty"`
}

func init() {
	t["NamespaceLimitReached"] = reflect.TypeOf((*NamespaceLimitReached)(nil)).Elem()
}

type NamespaceLimitReachedFault NamespaceLimitReached

func init() {
	t["NamespaceLimitReachedFault"] = reflect.TypeOf((*NamespaceLimitReachedFault)(nil)).Elem()
}

type NamespaceWriteProtected struct {
	VimFault

	Name string `xml:"name"`
}

func init() {
	t["NamespaceWriteProtected"] = reflect.TypeOf((*NamespaceWriteProtected)(nil)).Elem()
}

type NamespaceWriteProtectedFault NamespaceWriteProtected

func init() {
	t["NamespaceWriteProtectedFault"] = reflect.TypeOf((*NamespaceWriteProtectedFault)(nil)).Elem()
}

type NasConfigFault struct {
	HostConfigFault

	Name string `xml:"name"`
}

func init() {
	t["NasConfigFault"] = reflect.TypeOf((*NasConfigFault)(nil)).Elem()
}

type NasConfigFaultFault BaseNasConfigFault

func init() {
	t["NasConfigFaultFault"] = reflect.TypeOf((*NasConfigFaultFault)(nil)).Elem()
}

type NasConnectionLimitReached struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
}

func init() {
	t["NasConnectionLimitReached"] = reflect.TypeOf((*NasConnectionLimitReached)(nil)).Elem()
}

type NasConnectionLimitReachedFault NasConnectionLimitReached

func init() {
	t["NasConnectionLimitReachedFault"] = reflect.TypeOf((*NasConnectionLimitReachedFault)(nil)).Elem()
}

type NasDatastoreInfo struct {
	DatastoreInfo

	Nas *HostNasVolume `xml:"nas,omitempty"`
}

func init() {
	t["NasDatastoreInfo"] = reflect.TypeOf((*NasDatastoreInfo)(nil)).Elem()
}

type NasSessionCredentialConflict struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
	UserName   string `xml:"userName"`
}

func init() {
	t["NasSessionCredentialConflict"] = reflect.TypeOf((*NasSessionCredentialConflict)(nil)).Elem()
}

type NasSessionCredentialConflictFault NasSessionCredentialConflict

func init() {
	t["NasSessionCredentialConflictFault"] = reflect.TypeOf((*NasSessionCredentialConflictFault)(nil)).Elem()
}

type NasStorageProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["NasStorageProfile"] = reflect.TypeOf((*NasStorageProfile)(nil)).Elem()
}

type NasVolumeNotMounted struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
}

func init() {
	t["NasVolumeNotMounted"] = reflect.TypeOf((*NasVolumeNotMounted)(nil)).Elem()
}

type NasVolumeNotMountedFault NasVolumeNotMounted

func init() {
	t["NasVolumeNotMountedFault"] = reflect.TypeOf((*NasVolumeNotMountedFault)(nil)).Elem()
}

type NegatableExpression struct {
	DynamicData

	Negate *bool `xml:"negate"`
}

func init() {
	t["NegatableExpression"] = reflect.TypeOf((*NegatableExpression)(nil)).Elem()
}

type NetBIOSConfigInfo struct {
	DynamicData

	Mode string `xml:"mode"`
}

func init() {
	t["NetBIOSConfigInfo"] = reflect.TypeOf((*NetBIOSConfigInfo)(nil)).Elem()
}

type NetDhcpConfigInfo struct {
	DynamicData

	Ipv6 *NetDhcpConfigInfoDhcpOptions `xml:"ipv6,omitempty"`
	Ipv4 *NetDhcpConfigInfoDhcpOptions `xml:"ipv4,omitempty"`
}

func init() {
	t["NetDhcpConfigInfo"] = reflect.TypeOf((*NetDhcpConfigInfo)(nil)).Elem()
}

type NetDhcpConfigInfoDhcpOptions struct {
	DynamicData

	Enable bool       `xml:"enable"`
	Config []KeyValue `xml:"config,omitempty"`
}

func init() {
	t["NetDhcpConfigInfoDhcpOptions"] = reflect.TypeOf((*NetDhcpConfigInfoDhcpOptions)(nil)).Elem()
}

type NetDhcpConfigSpec struct {
	DynamicData

	Ipv6 *NetDhcpConfigSpecDhcpOptionsSpec `xml:"ipv6,omitempty"`
	Ipv4 *NetDhcpConfigSpecDhcpOptionsSpec `xml:"ipv4,omitempty"`
}

func init() {
	t["NetDhcpConfigSpec"] = reflect.TypeOf((*NetDhcpConfigSpec)(nil)).Elem()
}

type NetDhcpConfigSpecDhcpOptionsSpec struct {
	DynamicData

	Enable    *bool      `xml:"enable"`
	Config    []KeyValue `xml:"config"`
	Operation string     `xml:"operation"`
}

func init() {
	t["NetDhcpConfigSpecDhcpOptionsSpec"] = reflect.TypeOf((*NetDhcpConfigSpecDhcpOptionsSpec)(nil)).Elem()
}

type NetDnsConfigInfo struct {
	DynamicData

	Dhcp         bool     `xml:"dhcp"`
	HostName     string   `xml:"hostName"`
	DomainName   string   `xml:"domainName"`
	IpAddress    []string `xml:"ipAddress,omitempty"`
	SearchDomain []string `xml:"searchDomain,omitempty"`
}

func init() {
	t["NetDnsConfigInfo"] = reflect.TypeOf((*NetDnsConfigInfo)(nil)).Elem()
}

type NetDnsConfigSpec struct {
	DynamicData

	Dhcp         *bool    `xml:"dhcp"`
	HostName     string   `xml:"hostName,omitempty"`
	DomainName   string   `xml:"domainName,omitempty"`
	IpAddress    []string `xml:"ipAddress,omitempty"`
	SearchDomain []string `xml:"searchDomain,omitempty"`
}

func init() {
	t["NetDnsConfigSpec"] = reflect.TypeOf((*NetDnsConfigSpec)(nil)).Elem()
}

type NetIpConfigInfo struct {
	DynamicData

	IpAddress                []NetIpConfigInfoIpAddress `xml:"ipAddress,omitempty"`
	Dhcp                     *NetDhcpConfigInfo         `xml:"dhcp,omitempty"`
	AutoConfigurationEnabled *bool                      `xml:"autoConfigurationEnabled"`
}

func init() {
	t["NetIpConfigInfo"] = reflect.TypeOf((*NetIpConfigInfo)(nil)).Elem()
}

type NetIpConfigInfoIpAddress struct {
	DynamicData

	IpAddress    string     `xml:"ipAddress"`
	PrefixLength int        `xml:"prefixLength"`
	Origin       string     `xml:"origin,omitempty"`
	State        string     `xml:"state,omitempty"`
	Lifetime     *time.Time `xml:"lifetime"`
}

func init() {
	t["NetIpConfigInfoIpAddress"] = reflect.TypeOf((*NetIpConfigInfoIpAddress)(nil)).Elem()
}

type NetIpConfigSpec struct {
	DynamicData

	IpAddress                []NetIpConfigSpecIpAddressSpec `xml:"ipAddress,omitempty"`
	Dhcp                     *NetDhcpConfigSpec             `xml:"dhcp,omitempty"`
	AutoConfigurationEnabled *bool                          `xml:"autoConfigurationEnabled"`
}

func init() {
	t["NetIpConfigSpec"] = reflect.TypeOf((*NetIpConfigSpec)(nil)).Elem()
}

type NetIpConfigSpecIpAddressSpec struct {
	DynamicData

	IpAddress    string `xml:"ipAddress"`
	PrefixLength int    `xml:"prefixLength"`
	Operation    string `xml:"operation"`
}

func init() {
	t["NetIpConfigSpecIpAddressSpec"] = reflect.TypeOf((*NetIpConfigSpecIpAddressSpec)(nil)).Elem()
}

type NetIpRouteConfigInfo struct {
	DynamicData

	IpRoute []NetIpRouteConfigInfoIpRoute `xml:"ipRoute,omitempty"`
}

func init() {
	t["NetIpRouteConfigInfo"] = reflect.TypeOf((*NetIpRouteConfigInfo)(nil)).Elem()
}

type NetIpRouteConfigInfoGateway struct {
	DynamicData

	IpAddress string `xml:"ipAddress,omitempty"`
	Device    string `xml:"device,omitempty"`
}

func init() {
	t["NetIpRouteConfigInfoGateway"] = reflect.TypeOf((*NetIpRouteConfigInfoGateway)(nil)).Elem()
}

type NetIpRouteConfigInfoIpRoute struct {
	DynamicData

	Network      string                      `xml:"network"`
	PrefixLength int                         `xml:"prefixLength"`
	Gateway      NetIpRouteConfigInfoGateway `xml:"gateway"`
}

func init() {
	t["NetIpRouteConfigInfoIpRoute"] = reflect.TypeOf((*NetIpRouteConfigInfoIpRoute)(nil)).Elem()
}

type NetIpRouteConfigSpec struct {
	DynamicData

	IpRoute []NetIpRouteConfigSpecIpRouteSpec `xml:"ipRoute,omitempty"`
}

func init() {
	t["NetIpRouteConfigSpec"] = reflect.TypeOf((*NetIpRouteConfigSpec)(nil)).Elem()
}

type NetIpRouteConfigSpecGatewaySpec struct {
	DynamicData

	IpAddress string `xml:"ipAddress,omitempty"`
	Device    string `xml:"device,omitempty"`
}

func init() {
	t["NetIpRouteConfigSpecGatewaySpec"] = reflect.TypeOf((*NetIpRouteConfigSpecGatewaySpec)(nil)).Elem()
}

type NetIpRouteConfigSpecIpRouteSpec struct {
	DynamicData

	Network      string                          `xml:"network"`
	PrefixLength int                             `xml:"prefixLength"`
	Gateway      NetIpRouteConfigSpecGatewaySpec `xml:"gateway"`
	Operation    string                          `xml:"operation"`
}

func init() {
	t["NetIpRouteConfigSpecIpRouteSpec"] = reflect.TypeOf((*NetIpRouteConfigSpecIpRouteSpec)(nil)).Elem()
}

type NetIpStackInfo struct {
	DynamicData

	Neighbor      []NetIpStackInfoNetToMedia    `xml:"neighbor,omitempty"`
	DefaultRouter []NetIpStackInfoDefaultRouter `xml:"defaultRouter,omitempty"`
}

func init() {
	t["NetIpStackInfo"] = reflect.TypeOf((*NetIpStackInfo)(nil)).Elem()
}

type NetIpStackInfoDefaultRouter struct {
	DynamicData

	IpAddress  string    `xml:"ipAddress"`
	Device     string    `xml:"device"`
	Lifetime   time.Time `xml:"lifetime"`
	Preference string    `xml:"preference"`
}

func init() {
	t["NetIpStackInfoDefaultRouter"] = reflect.TypeOf((*NetIpStackInfoDefaultRouter)(nil)).Elem()
}

type NetIpStackInfoNetToMedia struct {
	DynamicData

	IpAddress       string `xml:"ipAddress"`
	PhysicalAddress string `xml:"physicalAddress"`
	Device          string `xml:"device"`
	Type            string `xml:"type"`
}

func init() {
	t["NetIpStackInfoNetToMedia"] = reflect.TypeOf((*NetIpStackInfoNetToMedia)(nil)).Elem()
}

type NetStackInstanceProfile struct {
	ApplyProfile

	Key           string                         `xml:"key"`
	DnsConfig     NetworkProfileDnsConfigProfile `xml:"dnsConfig"`
	IpRouteConfig IpRouteProfile                 `xml:"ipRouteConfig"`
}

func init() {
	t["NetStackInstanceProfile"] = reflect.TypeOf((*NetStackInstanceProfile)(nil)).Elem()
}

type NetworkCopyFault struct {
	FileFault
}

func init() {
	t["NetworkCopyFault"] = reflect.TypeOf((*NetworkCopyFault)(nil)).Elem()
}

type NetworkCopyFaultFault NetworkCopyFault

func init() {
	t["NetworkCopyFaultFault"] = reflect.TypeOf((*NetworkCopyFaultFault)(nil)).Elem()
}

type NetworkDisruptedAndConfigRolledBack struct {
	VimFault

	Host string `xml:"host"`
}

func init() {
	t["NetworkDisruptedAndConfigRolledBack"] = reflect.TypeOf((*NetworkDisruptedAndConfigRolledBack)(nil)).Elem()
}

type NetworkDisruptedAndConfigRolledBackFault NetworkDisruptedAndConfigRolledBack

func init() {
	t["NetworkDisruptedAndConfigRolledBackFault"] = reflect.TypeOf((*NetworkDisruptedAndConfigRolledBackFault)(nil)).Elem()
}

type NetworkEventArgument struct {
	EntityEventArgument

	Network ManagedObjectReference `xml:"network"`
}

func init() {
	t["NetworkEventArgument"] = reflect.TypeOf((*NetworkEventArgument)(nil)).Elem()
}

type NetworkInaccessible struct {
	NasConfigFault
}

func init() {
	t["NetworkInaccessible"] = reflect.TypeOf((*NetworkInaccessible)(nil)).Elem()
}

type NetworkInaccessibleFault NetworkInaccessible

func init() {
	t["NetworkInaccessibleFault"] = reflect.TypeOf((*NetworkInaccessibleFault)(nil)).Elem()
}

type NetworkPolicyProfile struct {
	ApplyProfile
}

func init() {
	t["NetworkPolicyProfile"] = reflect.TypeOf((*NetworkPolicyProfile)(nil)).Elem()
}

type NetworkProfile struct {
	ApplyProfile

	Vswitch                 []VirtualSwitchProfile           `xml:"vswitch,omitempty"`
	VmPortGroup             []VmPortGroupProfile             `xml:"vmPortGroup,omitempty"`
	HostPortGroup           []HostPortGroupProfile           `xml:"hostPortGroup,omitempty"`
	ServiceConsolePortGroup []ServiceConsolePortGroupProfile `xml:"serviceConsolePortGroup,omitempty"`
	DnsConfig               *NetworkProfileDnsConfigProfile  `xml:"dnsConfig,omitempty"`
	IpRouteConfig           *IpRouteProfile                  `xml:"ipRouteConfig,omitempty"`
	ConsoleIpRouteConfig    *IpRouteProfile                  `xml:"consoleIpRouteConfig,omitempty"`
	Pnic                    []PhysicalNicProfile             `xml:"pnic,omitempty"`
	Dvswitch                []DvsProfile                     `xml:"dvswitch,omitempty"`
	DvsServiceConsoleNic    []DvsServiceConsoleVNicProfile   `xml:"dvsServiceConsoleNic,omitempty"`
	DvsHostNic              []DvsHostVNicProfile             `xml:"dvsHostNic,omitempty"`
	NetStackInstance        []NetStackInstanceProfile        `xml:"netStackInstance,omitempty"`
}

func init() {
	t["NetworkProfile"] = reflect.TypeOf((*NetworkProfile)(nil)).Elem()
}

type NetworkProfileDnsConfigProfile struct {
	ApplyProfile
}

func init() {
	t["NetworkProfileDnsConfigProfile"] = reflect.TypeOf((*NetworkProfileDnsConfigProfile)(nil)).Elem()
}

type NetworkRollbackEvent struct {
	Event

	MethodName    string `xml:"methodName"`
	TransactionId string `xml:"transactionId"`
}

func init() {
	t["NetworkRollbackEvent"] = reflect.TypeOf((*NetworkRollbackEvent)(nil)).Elem()
}

type NetworkSummary struct {
	DynamicData

	Network    *ManagedObjectReference `xml:"network,omitempty"`
	Name       string                  `xml:"name"`
	Accessible bool                    `xml:"accessible"`
	IpPoolName string                  `xml:"ipPoolName,omitempty"`
	IpPoolId   int                     `xml:"ipPoolId,omitempty"`
}

func init() {
	t["NetworkSummary"] = reflect.TypeOf((*NetworkSummary)(nil)).Elem()
}

type NetworksMayNotBeTheSame struct {
	MigrationFault

	Name string `xml:"name,omitempty"`
}

func init() {
	t["NetworksMayNotBeTheSame"] = reflect.TypeOf((*NetworksMayNotBeTheSame)(nil)).Elem()
}

type NetworksMayNotBeTheSameFault NetworksMayNotBeTheSame

func init() {
	t["NetworksMayNotBeTheSameFault"] = reflect.TypeOf((*NetworksMayNotBeTheSameFault)(nil)).Elem()
}

type NicSettingMismatch struct {
	CustomizationFault

	NumberOfNicsInSpec int `xml:"numberOfNicsInSpec"`
	NumberOfNicsInVM   int `xml:"numberOfNicsInVM"`
}

func init() {
	t["NicSettingMismatch"] = reflect.TypeOf((*NicSettingMismatch)(nil)).Elem()
}

type NicSettingMismatchFault NicSettingMismatch

func init() {
	t["NicSettingMismatchFault"] = reflect.TypeOf((*NicSettingMismatchFault)(nil)).Elem()
}

type NoAccessUserEvent struct {
	SessionEvent

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["NoAccessUserEvent"] = reflect.TypeOf((*NoAccessUserEvent)(nil)).Elem()
}

type NoActiveHostInCluster struct {
	InvalidState

	ComputeResource ManagedObjectReference `xml:"computeResource"`
}

func init() {
	t["NoActiveHostInCluster"] = reflect.TypeOf((*NoActiveHostInCluster)(nil)).Elem()
}

type NoActiveHostInClusterFault NoActiveHostInCluster

func init() {
	t["NoActiveHostInClusterFault"] = reflect.TypeOf((*NoActiveHostInClusterFault)(nil)).Elem()
}

type NoAvailableIp struct {
	VAppPropertyFault

	Network ManagedObjectReference `xml:"network"`
}

func init() {
	t["NoAvailableIp"] = reflect.TypeOf((*NoAvailableIp)(nil)).Elem()
}

type NoAvailableIpFault NoAvailableIp

func init() {
	t["NoAvailableIpFault"] = reflect.TypeOf((*NoAvailableIpFault)(nil)).Elem()
}

type NoClientCertificate struct {
	VimFault
}

func init() {
	t["NoClientCertificate"] = reflect.TypeOf((*NoClientCertificate)(nil)).Elem()
}

type NoClientCertificateFault NoClientCertificate

func init() {
	t["NoClientCertificateFault"] = reflect.TypeOf((*NoClientCertificateFault)(nil)).Elem()
}

type NoCompatibleDatastore struct {
	VimFault
}

func init() {
	t["NoCompatibleDatastore"] = reflect.TypeOf((*NoCompatibleDatastore)(nil)).Elem()
}

type NoCompatibleDatastoreFault NoCompatibleDatastore

func init() {
	t["NoCompatibleDatastoreFault"] = reflect.TypeOf((*NoCompatibleDatastoreFault)(nil)).Elem()
}

type NoCompatibleHardAffinityHost struct {
	VmConfigFault

	VmName string `xml:"vmName"`
}

func init() {
	t["NoCompatibleHardAffinityHost"] = reflect.TypeOf((*NoCompatibleHardAffinityHost)(nil)).Elem()
}

type NoCompatibleHardAffinityHostFault NoCompatibleHardAffinityHost

func init() {
	t["NoCompatibleHardAffinityHostFault"] = reflect.TypeOf((*NoCompatibleHardAffinityHostFault)(nil)).Elem()
}

type NoCompatibleHost struct {
	VimFault

	Host  []ManagedObjectReference `xml:"host,omitempty"`
	Error []LocalizedMethodFault   `xml:"error,omitempty"`
}

func init() {
	t["NoCompatibleHost"] = reflect.TypeOf((*NoCompatibleHost)(nil)).Elem()
}

type NoCompatibleHostFault BaseNoCompatibleHost

func init() {
	t["NoCompatibleHostFault"] = reflect.TypeOf((*NoCompatibleHostFault)(nil)).Elem()
}

type NoCompatibleHostWithAccessToDevice struct {
	NoCompatibleHost
}

func init() {
	t["NoCompatibleHostWithAccessToDevice"] = reflect.TypeOf((*NoCompatibleHostWithAccessToDevice)(nil)).Elem()
}

type NoCompatibleHostWithAccessToDeviceFault NoCompatibleHostWithAccessToDevice

func init() {
	t["NoCompatibleHostWithAccessToDeviceFault"] = reflect.TypeOf((*NoCompatibleHostWithAccessToDeviceFault)(nil)).Elem()
}

type NoCompatibleSoftAffinityHost struct {
	VmConfigFault

	VmName string `xml:"vmName"`
}

func init() {
	t["NoCompatibleSoftAffinityHost"] = reflect.TypeOf((*NoCompatibleSoftAffinityHost)(nil)).Elem()
}

type NoCompatibleSoftAffinityHostFault NoCompatibleSoftAffinityHost

func init() {
	t["NoCompatibleSoftAffinityHostFault"] = reflect.TypeOf((*NoCompatibleSoftAffinityHostFault)(nil)).Elem()
}

type NoConnectedDatastore struct {
	VimFault
}

func init() {
	t["NoConnectedDatastore"] = reflect.TypeOf((*NoConnectedDatastore)(nil)).Elem()
}

type NoConnectedDatastoreFault NoConnectedDatastore

func init() {
	t["NoConnectedDatastoreFault"] = reflect.TypeOf((*NoConnectedDatastoreFault)(nil)).Elem()
}

type NoDatastoresConfiguredEvent struct {
	HostEvent
}

func init() {
	t["NoDatastoresConfiguredEvent"] = reflect.TypeOf((*NoDatastoresConfiguredEvent)(nil)).Elem()
}

type NoDiskFound struct {
	VimFault
}

func init() {
	t["NoDiskFound"] = reflect.TypeOf((*NoDiskFound)(nil)).Elem()
}

type NoDiskFoundFault NoDiskFound

func init() {
	t["NoDiskFoundFault"] = reflect.TypeOf((*NoDiskFoundFault)(nil)).Elem()
}

type NoDiskSpace struct {
	FileFault

	Datastore string `xml:"datastore"`
}

func init() {
	t["NoDiskSpace"] = reflect.TypeOf((*NoDiskSpace)(nil)).Elem()
}

type NoDiskSpaceFault NoDiskSpace

func init() {
	t["NoDiskSpaceFault"] = reflect.TypeOf((*NoDiskSpaceFault)(nil)).Elem()
}

type NoDisksToCustomize struct {
	CustomizationFault
}

func init() {
	t["NoDisksToCustomize"] = reflect.TypeOf((*NoDisksToCustomize)(nil)).Elem()
}

type NoDisksToCustomizeFault NoDisksToCustomize

func init() {
	t["NoDisksToCustomizeFault"] = reflect.TypeOf((*NoDisksToCustomizeFault)(nil)).Elem()
}

type NoGateway struct {
	HostConfigFault
}

func init() {
	t["NoGateway"] = reflect.TypeOf((*NoGateway)(nil)).Elem()
}

type NoGatewayFault NoGateway

func init() {
	t["NoGatewayFault"] = reflect.TypeOf((*NoGatewayFault)(nil)).Elem()
}

type NoGuestHeartbeat struct {
	MigrationFault
}

func init() {
	t["NoGuestHeartbeat"] = reflect.TypeOf((*NoGuestHeartbeat)(nil)).Elem()
}

type NoGuestHeartbeatFault NoGuestHeartbeat

func init() {
	t["NoGuestHeartbeatFault"] = reflect.TypeOf((*NoGuestHeartbeatFault)(nil)).Elem()
}

type NoHost struct {
	HostConnectFault

	Name string `xml:"name,omitempty"`
}

func init() {
	t["NoHost"] = reflect.TypeOf((*NoHost)(nil)).Elem()
}

type NoHostFault NoHost

func init() {
	t["NoHostFault"] = reflect.TypeOf((*NoHostFault)(nil)).Elem()
}

type NoHostSuitableForFtSecondary struct {
	VmFaultToleranceIssue

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["NoHostSuitableForFtSecondary"] = reflect.TypeOf((*NoHostSuitableForFtSecondary)(nil)).Elem()
}

type NoHostSuitableForFtSecondaryFault NoHostSuitableForFtSecondary

func init() {
	t["NoHostSuitableForFtSecondaryFault"] = reflect.TypeOf((*NoHostSuitableForFtSecondaryFault)(nil)).Elem()
}

type NoLicenseEvent struct {
	LicenseEvent

	Feature LicenseFeatureInfo `xml:"feature"`
}

func init() {
	t["NoLicenseEvent"] = reflect.TypeOf((*NoLicenseEvent)(nil)).Elem()
}

type NoLicenseServerConfigured struct {
	NotEnoughLicenses
}

func init() {
	t["NoLicenseServerConfigured"] = reflect.TypeOf((*NoLicenseServerConfigured)(nil)).Elem()
}

type NoLicenseServerConfiguredFault NoLicenseServerConfigured

func init() {
	t["NoLicenseServerConfiguredFault"] = reflect.TypeOf((*NoLicenseServerConfiguredFault)(nil)).Elem()
}

type NoMaintenanceModeDrsRecommendationForVM struct {
	VmEvent
}

func init() {
	t["NoMaintenanceModeDrsRecommendationForVM"] = reflect.TypeOf((*NoMaintenanceModeDrsRecommendationForVM)(nil)).Elem()
}

type NoPeerHostFound struct {
	HostPowerOpFailed
}

func init() {
	t["NoPeerHostFound"] = reflect.TypeOf((*NoPeerHostFound)(nil)).Elem()
}

type NoPeerHostFoundFault NoPeerHostFound

func init() {
	t["NoPeerHostFoundFault"] = reflect.TypeOf((*NoPeerHostFoundFault)(nil)).Elem()
}

type NoPermission struct {
	SecurityError

	Object      ManagedObjectReference `xml:"object"`
	PrivilegeId string                 `xml:"privilegeId"`
}

func init() {
	t["NoPermission"] = reflect.TypeOf((*NoPermission)(nil)).Elem()
}

type NoPermissionFault BaseNoPermission

func init() {
	t["NoPermissionFault"] = reflect.TypeOf((*NoPermissionFault)(nil)).Elem()
}

type NoPermissionOnAD struct {
	ActiveDirectoryFault
}

func init() {
	t["NoPermissionOnAD"] = reflect.TypeOf((*NoPermissionOnAD)(nil)).Elem()
}

type NoPermissionOnADFault NoPermissionOnAD

func init() {
	t["NoPermissionOnADFault"] = reflect.TypeOf((*NoPermissionOnADFault)(nil)).Elem()
}

type NoPermissionOnHost struct {
	HostConnectFault
}

func init() {
	t["NoPermissionOnHost"] = reflect.TypeOf((*NoPermissionOnHost)(nil)).Elem()
}

type NoPermissionOnHostFault NoPermissionOnHost

func init() {
	t["NoPermissionOnHostFault"] = reflect.TypeOf((*NoPermissionOnHostFault)(nil)).Elem()
}

type NoPermissionOnNasVolume struct {
	NasConfigFault

	UserName string `xml:"userName,omitempty"`
}

func init() {
	t["NoPermissionOnNasVolume"] = reflect.TypeOf((*NoPermissionOnNasVolume)(nil)).Elem()
}

type NoPermissionOnNasVolumeFault NoPermissionOnNasVolume

func init() {
	t["NoPermissionOnNasVolumeFault"] = reflect.TypeOf((*NoPermissionOnNasVolumeFault)(nil)).Elem()
}

type NoSubjectName struct {
	VimFault
}

func init() {
	t["NoSubjectName"] = reflect.TypeOf((*NoSubjectName)(nil)).Elem()
}

type NoSubjectNameFault NoSubjectName

func init() {
	t["NoSubjectNameFault"] = reflect.TypeOf((*NoSubjectNameFault)(nil)).Elem()
}

type NoVcManagedIpConfigured struct {
	VAppPropertyFault
}

func init() {
	t["NoVcManagedIpConfigured"] = reflect.TypeOf((*NoVcManagedIpConfigured)(nil)).Elem()
}

type NoVcManagedIpConfiguredFault NoVcManagedIpConfigured

func init() {
	t["NoVcManagedIpConfiguredFault"] = reflect.TypeOf((*NoVcManagedIpConfiguredFault)(nil)).Elem()
}

type NoVirtualNic struct {
	HostConfigFault
}

func init() {
	t["NoVirtualNic"] = reflect.TypeOf((*NoVirtualNic)(nil)).Elem()
}

type NoVirtualNicFault NoVirtualNic

func init() {
	t["NoVirtualNicFault"] = reflect.TypeOf((*NoVirtualNicFault)(nil)).Elem()
}

type NoVmInVApp struct {
	VAppConfigFault
}

func init() {
	t["NoVmInVApp"] = reflect.TypeOf((*NoVmInVApp)(nil)).Elem()
}

type NoVmInVAppFault NoVmInVApp

func init() {
	t["NoVmInVAppFault"] = reflect.TypeOf((*NoVmInVAppFault)(nil)).Elem()
}

type NonADUserRequired struct {
	ActiveDirectoryFault
}

func init() {
	t["NonADUserRequired"] = reflect.TypeOf((*NonADUserRequired)(nil)).Elem()
}

type NonADUserRequiredFault NonADUserRequired

func init() {
	t["NonADUserRequiredFault"] = reflect.TypeOf((*NonADUserRequiredFault)(nil)).Elem()
}

type NonHomeRDMVMotionNotSupported struct {
	MigrationFeatureNotSupported

	Device string `xml:"device"`
}

func init() {
	t["NonHomeRDMVMotionNotSupported"] = reflect.TypeOf((*NonHomeRDMVMotionNotSupported)(nil)).Elem()
}

type NonHomeRDMVMotionNotSupportedFault NonHomeRDMVMotionNotSupported

func init() {
	t["NonHomeRDMVMotionNotSupportedFault"] = reflect.TypeOf((*NonHomeRDMVMotionNotSupportedFault)(nil)).Elem()
}

type NonPersistentDisksNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["NonPersistentDisksNotSupported"] = reflect.TypeOf((*NonPersistentDisksNotSupported)(nil)).Elem()
}

type NonPersistentDisksNotSupportedFault NonPersistentDisksNotSupported

func init() {
	t["NonPersistentDisksNotSupportedFault"] = reflect.TypeOf((*NonPersistentDisksNotSupportedFault)(nil)).Elem()
}

type NonVIWorkloadDetectedOnDatastoreEvent struct {
	DatastoreEvent
}

func init() {
	t["NonVIWorkloadDetectedOnDatastoreEvent"] = reflect.TypeOf((*NonVIWorkloadDetectedOnDatastoreEvent)(nil)).Elem()
}

type NonVmwareOuiMacNotSupportedHost struct {
	NotSupportedHost

	HostName string `xml:"hostName"`
}

func init() {
	t["NonVmwareOuiMacNotSupportedHost"] = reflect.TypeOf((*NonVmwareOuiMacNotSupportedHost)(nil)).Elem()
}

type NonVmwareOuiMacNotSupportedHostFault NonVmwareOuiMacNotSupportedHost

func init() {
	t["NonVmwareOuiMacNotSupportedHostFault"] = reflect.TypeOf((*NonVmwareOuiMacNotSupportedHostFault)(nil)).Elem()
}

type NotADirectory struct {
	FileFault
}

func init() {
	t["NotADirectory"] = reflect.TypeOf((*NotADirectory)(nil)).Elem()
}

type NotADirectoryFault NotADirectory

func init() {
	t["NotADirectoryFault"] = reflect.TypeOf((*NotADirectoryFault)(nil)).Elem()
}

type NotAFile struct {
	FileFault
}

func init() {
	t["NotAFile"] = reflect.TypeOf((*NotAFile)(nil)).Elem()
}

type NotAFileFault NotAFile

func init() {
	t["NotAFileFault"] = reflect.TypeOf((*NotAFileFault)(nil)).Elem()
}

type NotAuthenticated struct {
	NoPermission
}

func init() {
	t["NotAuthenticated"] = reflect.TypeOf((*NotAuthenticated)(nil)).Elem()
}

type NotAuthenticatedFault NotAuthenticated

func init() {
	t["NotAuthenticatedFault"] = reflect.TypeOf((*NotAuthenticatedFault)(nil)).Elem()
}

type NotEnoughCpus struct {
	VirtualHardwareCompatibilityIssue

	NumCpuDest int `xml:"numCpuDest"`
	NumCpuVm   int `xml:"numCpuVm"`
}

func init() {
	t["NotEnoughCpus"] = reflect.TypeOf((*NotEnoughCpus)(nil)).Elem()
}

type NotEnoughCpusFault BaseNotEnoughCpus

func init() {
	t["NotEnoughCpusFault"] = reflect.TypeOf((*NotEnoughCpusFault)(nil)).Elem()
}

type NotEnoughLicenses struct {
	RuntimeFault
}

func init() {
	t["NotEnoughLicenses"] = reflect.TypeOf((*NotEnoughLicenses)(nil)).Elem()
}

type NotEnoughLicensesFault BaseNotEnoughLicenses

func init() {
	t["NotEnoughLicensesFault"] = reflect.TypeOf((*NotEnoughLicensesFault)(nil)).Elem()
}

type NotEnoughLogicalCpus struct {
	NotEnoughCpus

	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["NotEnoughLogicalCpus"] = reflect.TypeOf((*NotEnoughLogicalCpus)(nil)).Elem()
}

type NotEnoughLogicalCpusFault NotEnoughLogicalCpus

func init() {
	t["NotEnoughLogicalCpusFault"] = reflect.TypeOf((*NotEnoughLogicalCpusFault)(nil)).Elem()
}

type NotEnoughResourcesToStartVmEvent struct {
	VmEvent
}

func init() {
	t["NotEnoughResourcesToStartVmEvent"] = reflect.TypeOf((*NotEnoughResourcesToStartVmEvent)(nil)).Elem()
}

type NotFound struct {
	VimFault
}

func init() {
	t["NotFound"] = reflect.TypeOf((*NotFound)(nil)).Elem()
}

type NotFoundFault NotFound

func init() {
	t["NotFoundFault"] = reflect.TypeOf((*NotFoundFault)(nil)).Elem()
}

type NotImplemented struct {
	RuntimeFault
}

func init() {
	t["NotImplemented"] = reflect.TypeOf((*NotImplemented)(nil)).Elem()
}

type NotImplementedFault NotImplemented

func init() {
	t["NotImplementedFault"] = reflect.TypeOf((*NotImplementedFault)(nil)).Elem()
}

type NotSupported struct {
	RuntimeFault
}

func init() {
	t["NotSupported"] = reflect.TypeOf((*NotSupported)(nil)).Elem()
}

type NotSupportedDeviceForFT struct {
	VmFaultToleranceIssue

	Host        ManagedObjectReference `xml:"host"`
	HostName    string                 `xml:"hostName,omitempty"`
	Vm          ManagedObjectReference `xml:"vm"`
	VmName      string                 `xml:"vmName,omitempty"`
	DeviceType  string                 `xml:"deviceType"`
	DeviceLabel string                 `xml:"deviceLabel,omitempty"`
}

func init() {
	t["NotSupportedDeviceForFT"] = reflect.TypeOf((*NotSupportedDeviceForFT)(nil)).Elem()
}

type NotSupportedDeviceForFTFault NotSupportedDeviceForFT

func init() {
	t["NotSupportedDeviceForFTFault"] = reflect.TypeOf((*NotSupportedDeviceForFTFault)(nil)).Elem()
}

type NotSupportedFault BaseNotSupported

func init() {
	t["NotSupportedFault"] = reflect.TypeOf((*NotSupportedFault)(nil)).Elem()
}

type NotSupportedHost struct {
	HostConnectFault

	ProductName    string `xml:"productName,omitempty"`
	ProductVersion string `xml:"productVersion,omitempty"`
}

func init() {
	t["NotSupportedHost"] = reflect.TypeOf((*NotSupportedHost)(nil)).Elem()
}

type NotSupportedHostFault BaseNotSupportedHost

func init() {
	t["NotSupportedHostFault"] = reflect.TypeOf((*NotSupportedHostFault)(nil)).Elem()
}

type NotSupportedHostForVFlash struct {
	NotSupportedHost

	HostName string `xml:"hostName"`
}

func init() {
	t["NotSupportedHostForVFlash"] = reflect.TypeOf((*NotSupportedHostForVFlash)(nil)).Elem()
}

type NotSupportedHostForVFlashFault NotSupportedHostForVFlash

func init() {
	t["NotSupportedHostForVFlashFault"] = reflect.TypeOf((*NotSupportedHostForVFlashFault)(nil)).Elem()
}

type NotSupportedHostForVsan struct {
	NotSupportedHost

	HostName string `xml:"hostName"`
}

func init() {
	t["NotSupportedHostForVsan"] = reflect.TypeOf((*NotSupportedHostForVsan)(nil)).Elem()
}

type NotSupportedHostForVsanFault NotSupportedHostForVsan

func init() {
	t["NotSupportedHostForVsanFault"] = reflect.TypeOf((*NotSupportedHostForVsanFault)(nil)).Elem()
}

type NotSupportedHostInCluster struct {
	NotSupportedHost
}

func init() {
	t["NotSupportedHostInCluster"] = reflect.TypeOf((*NotSupportedHostInCluster)(nil)).Elem()
}

type NotSupportedHostInClusterFault BaseNotSupportedHostInCluster

func init() {
	t["NotSupportedHostInClusterFault"] = reflect.TypeOf((*NotSupportedHostInClusterFault)(nil)).Elem()
}

type NotSupportedHostInDvs struct {
	NotSupportedHost

	SwitchProductSpec DistributedVirtualSwitchProductSpec `xml:"switchProductSpec"`
}

func init() {
	t["NotSupportedHostInDvs"] = reflect.TypeOf((*NotSupportedHostInDvs)(nil)).Elem()
}

type NotSupportedHostInDvsFault NotSupportedHostInDvs

func init() {
	t["NotSupportedHostInDvsFault"] = reflect.TypeOf((*NotSupportedHostInDvsFault)(nil)).Elem()
}

type NotSupportedHostInHACluster struct {
	NotSupportedHost

	HostName string `xml:"hostName"`
	Build    string `xml:"build"`
}

func init() {
	t["NotSupportedHostInHACluster"] = reflect.TypeOf((*NotSupportedHostInHACluster)(nil)).Elem()
}

type NotSupportedHostInHAClusterFault NotSupportedHostInHACluster

func init() {
	t["NotSupportedHostInHAClusterFault"] = reflect.TypeOf((*NotSupportedHostInHAClusterFault)(nil)).Elem()
}

type NotUserConfigurableProperty struct {
	VAppPropertyFault
}

func init() {
	t["NotUserConfigurableProperty"] = reflect.TypeOf((*NotUserConfigurableProperty)(nil)).Elem()
}

type NotUserConfigurablePropertyFault NotUserConfigurableProperty

func init() {
	t["NotUserConfigurablePropertyFault"] = reflect.TypeOf((*NotUserConfigurablePropertyFault)(nil)).Elem()
}

type NumPortsProfile struct {
	ApplyProfile
}

func init() {
	t["NumPortsProfile"] = reflect.TypeOf((*NumPortsProfile)(nil)).Elem()
}

type NumVirtualCoresPerSocketNotSupported struct {
	VirtualHardwareCompatibilityIssue

	MaxSupportedCoresPerSocketDest int `xml:"maxSupportedCoresPerSocketDest"`
	NumCoresPerSocketVm            int `xml:"numCoresPerSocketVm"`
}

func init() {
	t["NumVirtualCoresPerSocketNotSupported"] = reflect.TypeOf((*NumVirtualCoresPerSocketNotSupported)(nil)).Elem()
}

type NumVirtualCoresPerSocketNotSupportedFault NumVirtualCoresPerSocketNotSupported

func init() {
	t["NumVirtualCoresPerSocketNotSupportedFault"] = reflect.TypeOf((*NumVirtualCoresPerSocketNotSupportedFault)(nil)).Elem()
}

type NumVirtualCpusExceedsLimit struct {
	InsufficientResourcesFault

	MaxSupportedVcpus int `xml:"maxSupportedVcpus"`
}

func init() {
	t["NumVirtualCpusExceedsLimit"] = reflect.TypeOf((*NumVirtualCpusExceedsLimit)(nil)).Elem()
}

type NumVirtualCpusExceedsLimitFault NumVirtualCpusExceedsLimit

func init() {
	t["NumVirtualCpusExceedsLimitFault"] = reflect.TypeOf((*NumVirtualCpusExceedsLimitFault)(nil)).Elem()
}

type NumVirtualCpusIncompatible struct {
	VmConfigFault

	Reason string `xml:"reason"`
	NumCpu int    `xml:"numCpu"`
}

func init() {
	t["NumVirtualCpusIncompatible"] = reflect.TypeOf((*NumVirtualCpusIncompatible)(nil)).Elem()
}

type NumVirtualCpusIncompatibleFault NumVirtualCpusIncompatible

func init() {
	t["NumVirtualCpusIncompatibleFault"] = reflect.TypeOf((*NumVirtualCpusIncompatibleFault)(nil)).Elem()
}

type NumVirtualCpusNotSupported struct {
	VirtualHardwareCompatibilityIssue

	MaxSupportedVcpusDest int `xml:"maxSupportedVcpusDest"`
	NumCpuVm              int `xml:"numCpuVm"`
}

func init() {
	t["NumVirtualCpusNotSupported"] = reflect.TypeOf((*NumVirtualCpusNotSupported)(nil)).Elem()
}

type NumVirtualCpusNotSupportedFault NumVirtualCpusNotSupported

func init() {
	t["NumVirtualCpusNotSupportedFault"] = reflect.TypeOf((*NumVirtualCpusNotSupportedFault)(nil)).Elem()
}

type NumericRange struct {
	DynamicData

	Start int `xml:"start"`
	End   int `xml:"end"`
}

func init() {
	t["NumericRange"] = reflect.TypeOf((*NumericRange)(nil)).Elem()
}

type ObjectContent struct {
	DynamicData

	Obj        ManagedObjectReference `xml:"obj"`
	PropSet    []DynamicProperty      `xml:"propSet,omitempty"`
	MissingSet []MissingProperty      `xml:"missingSet,omitempty"`
}

func init() {
	t["ObjectContent"] = reflect.TypeOf((*ObjectContent)(nil)).Elem()
}

type ObjectSpec struct {
	DynamicData

	Obj       ManagedObjectReference `xml:"obj"`
	Skip      *bool                  `xml:"skip"`
	SelectSet []BaseSelectionSpec    `xml:"selectSet,omitempty,typeattr"`
}

func init() {
	t["ObjectSpec"] = reflect.TypeOf((*ObjectSpec)(nil)).Elem()
}

type ObjectUpdate struct {
	DynamicData

	Kind       ObjectUpdateKind       `xml:"kind"`
	Obj        ManagedObjectReference `xml:"obj"`
	ChangeSet  []PropertyChange       `xml:"changeSet,omitempty"`
	MissingSet []MissingProperty      `xml:"missingSet,omitempty"`
}

func init() {
	t["ObjectUpdate"] = reflect.TypeOf((*ObjectUpdate)(nil)).Elem()
}

type OnceTaskScheduler struct {
	TaskScheduler

	RunAt *time.Time `xml:"runAt"`
}

func init() {
	t["OnceTaskScheduler"] = reflect.TypeOf((*OnceTaskScheduler)(nil)).Elem()
}

type OpaqueNetworkSummary struct {
	NetworkSummary

	OpaqueNetworkId   string `xml:"opaqueNetworkId"`
	OpaqueNetworkType string `xml:"opaqueNetworkType"`
}

func init() {
	t["OpaqueNetworkSummary"] = reflect.TypeOf((*OpaqueNetworkSummary)(nil)).Elem()
}

type OpaqueNetworkTargetInfo struct {
	VirtualMachineTargetInfo

	Network OpaqueNetworkSummary `xml:"network"`
}

func init() {
	t["OpaqueNetworkTargetInfo"] = reflect.TypeOf((*OpaqueNetworkTargetInfo)(nil)).Elem()
}

type OpenInventoryViewFolder OpenInventoryViewFolderRequestType

func init() {
	t["OpenInventoryViewFolder"] = reflect.TypeOf((*OpenInventoryViewFolder)(nil)).Elem()
}

type OpenInventoryViewFolderRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity"`
}

func init() {
	t["OpenInventoryViewFolderRequestType"] = reflect.TypeOf((*OpenInventoryViewFolderRequestType)(nil)).Elem()
}

type OpenInventoryViewFolderResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type OperationDisabledByGuest struct {
	GuestOperationsFault
}

func init() {
	t["OperationDisabledByGuest"] = reflect.TypeOf((*OperationDisabledByGuest)(nil)).Elem()
}

type OperationDisabledByGuestFault OperationDisabledByGuest

func init() {
	t["OperationDisabledByGuestFault"] = reflect.TypeOf((*OperationDisabledByGuestFault)(nil)).Elem()
}

type OperationDisallowedOnHost struct {
	RuntimeFault
}

func init() {
	t["OperationDisallowedOnHost"] = reflect.TypeOf((*OperationDisallowedOnHost)(nil)).Elem()
}

type OperationDisallowedOnHostFault OperationDisallowedOnHost

func init() {
	t["OperationDisallowedOnHostFault"] = reflect.TypeOf((*OperationDisallowedOnHostFault)(nil)).Elem()
}

type OperationNotSupportedByGuest struct {
	GuestOperationsFault
}

func init() {
	t["OperationNotSupportedByGuest"] = reflect.TypeOf((*OperationNotSupportedByGuest)(nil)).Elem()
}

type OperationNotSupportedByGuestFault OperationNotSupportedByGuest

func init() {
	t["OperationNotSupportedByGuestFault"] = reflect.TypeOf((*OperationNotSupportedByGuestFault)(nil)).Elem()
}

type OptionDef struct {
	ElementDescription

	OptionType BaseOptionType `xml:"optionType,typeattr"`
}

func init() {
	t["OptionDef"] = reflect.TypeOf((*OptionDef)(nil)).Elem()
}

type OptionProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["OptionProfile"] = reflect.TypeOf((*OptionProfile)(nil)).Elem()
}

type OptionType struct {
	DynamicData

	ValueIsReadonly *bool `xml:"valueIsReadonly"`
}

func init() {
	t["OptionType"] = reflect.TypeOf((*OptionType)(nil)).Elem()
}

type OptionValue struct {
	DynamicData

	Key   string  `xml:"key"`
	Value AnyType `xml:"value,omitempty,typeattr"`
}

func init() {
	t["OptionValue"] = reflect.TypeOf((*OptionValue)(nil)).Elem()
}

type OrAlarmExpression struct {
	AlarmExpression

	Expression []BaseAlarmExpression `xml:"expression,typeattr"`
}

func init() {
	t["OrAlarmExpression"] = reflect.TypeOf((*OrAlarmExpression)(nil)).Elem()
}

type OutOfBounds struct {
	VimFault

	ArgumentName string `xml:"argumentName"`
}

func init() {
	t["OutOfBounds"] = reflect.TypeOf((*OutOfBounds)(nil)).Elem()
}

type OutOfBoundsFault OutOfBounds

func init() {
	t["OutOfBoundsFault"] = reflect.TypeOf((*OutOfBoundsFault)(nil)).Elem()
}

type OutOfSyncDvsHost struct {
	DvsEvent

	HostOutOfSync []DvsOutOfSyncHostArgument `xml:"hostOutOfSync"`
}

func init() {
	t["OutOfSyncDvsHost"] = reflect.TypeOf((*OutOfSyncDvsHost)(nil)).Elem()
}

type OverwriteCustomizationSpec OverwriteCustomizationSpecRequestType

func init() {
	t["OverwriteCustomizationSpec"] = reflect.TypeOf((*OverwriteCustomizationSpec)(nil)).Elem()
}

type OverwriteCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Item CustomizationSpecItem  `xml:"item"`
}

func init() {
	t["OverwriteCustomizationSpecRequestType"] = reflect.TypeOf((*OverwriteCustomizationSpecRequestType)(nil)).Elem()
}

type OverwriteCustomizationSpecResponse struct {
}

type OvfAttribute struct {
	OvfInvalidPackage

	ElementName   string `xml:"elementName"`
	AttributeName string `xml:"attributeName"`
}

func init() {
	t["OvfAttribute"] = reflect.TypeOf((*OvfAttribute)(nil)).Elem()
}

type OvfAttributeFault BaseOvfAttribute

func init() {
	t["OvfAttributeFault"] = reflect.TypeOf((*OvfAttributeFault)(nil)).Elem()
}

type OvfConnectedDevice struct {
	OvfHardwareExport
}

func init() {
	t["OvfConnectedDevice"] = reflect.TypeOf((*OvfConnectedDevice)(nil)).Elem()
}

type OvfConnectedDeviceFault BaseOvfConnectedDevice

func init() {
	t["OvfConnectedDeviceFault"] = reflect.TypeOf((*OvfConnectedDeviceFault)(nil)).Elem()
}

type OvfConnectedDeviceFloppy struct {
	OvfConnectedDevice

	Filename string `xml:"filename"`
}

func init() {
	t["OvfConnectedDeviceFloppy"] = reflect.TypeOf((*OvfConnectedDeviceFloppy)(nil)).Elem()
}

type OvfConnectedDeviceFloppyFault OvfConnectedDeviceFloppy

func init() {
	t["OvfConnectedDeviceFloppyFault"] = reflect.TypeOf((*OvfConnectedDeviceFloppyFault)(nil)).Elem()
}

type OvfConnectedDeviceIso struct {
	OvfConnectedDevice

	Filename string `xml:"filename"`
}

func init() {
	t["OvfConnectedDeviceIso"] = reflect.TypeOf((*OvfConnectedDeviceIso)(nil)).Elem()
}

type OvfConnectedDeviceIsoFault OvfConnectedDeviceIso

func init() {
	t["OvfConnectedDeviceIsoFault"] = reflect.TypeOf((*OvfConnectedDeviceIsoFault)(nil)).Elem()
}

type OvfConstraint struct {
	OvfInvalidPackage

	Name string `xml:"name"`
}

func init() {
	t["OvfConstraint"] = reflect.TypeOf((*OvfConstraint)(nil)).Elem()
}

type OvfConstraintFault BaseOvfConstraint

func init() {
	t["OvfConstraintFault"] = reflect.TypeOf((*OvfConstraintFault)(nil)).Elem()
}

type OvfConsumerCallbackFault struct {
	OvfFault

	ExtensionKey  string `xml:"extensionKey"`
	ExtensionName string `xml:"extensionName"`
}

func init() {
	t["OvfConsumerCallbackFault"] = reflect.TypeOf((*OvfConsumerCallbackFault)(nil)).Elem()
}

type OvfConsumerCallbackFaultFault BaseOvfConsumerCallbackFault

func init() {
	t["OvfConsumerCallbackFaultFault"] = reflect.TypeOf((*OvfConsumerCallbackFaultFault)(nil)).Elem()
}

type OvfConsumerCommunicationError struct {
	OvfConsumerCallbackFault

	Description string `xml:"description"`
}

func init() {
	t["OvfConsumerCommunicationError"] = reflect.TypeOf((*OvfConsumerCommunicationError)(nil)).Elem()
}

type OvfConsumerCommunicationErrorFault OvfConsumerCommunicationError

func init() {
	t["OvfConsumerCommunicationErrorFault"] = reflect.TypeOf((*OvfConsumerCommunicationErrorFault)(nil)).Elem()
}

type OvfConsumerFault struct {
	OvfConsumerCallbackFault

	ErrorKey string     `xml:"errorKey"`
	Message  string     `xml:"message"`
	Params   []KeyValue `xml:"params,omitempty"`
}

func init() {
	t["OvfConsumerFault"] = reflect.TypeOf((*OvfConsumerFault)(nil)).Elem()
}

type OvfConsumerFaultFault OvfConsumerFault

func init() {
	t["OvfConsumerFaultFault"] = reflect.TypeOf((*OvfConsumerFaultFault)(nil)).Elem()
}

type OvfConsumerInvalidSection struct {
	OvfConsumerCallbackFault

	LineNumber  int    `xml:"lineNumber"`
	Description string `xml:"description"`
}

func init() {
	t["OvfConsumerInvalidSection"] = reflect.TypeOf((*OvfConsumerInvalidSection)(nil)).Elem()
}

type OvfConsumerInvalidSectionFault OvfConsumerInvalidSection

func init() {
	t["OvfConsumerInvalidSectionFault"] = reflect.TypeOf((*OvfConsumerInvalidSectionFault)(nil)).Elem()
}

type OvfConsumerOstNode struct {
	DynamicData

	Id      string                  `xml:"id"`
	Type    string                  `xml:"type"`
	Section []OvfConsumerOvfSection `xml:"section,omitempty"`
	Child   []OvfConsumerOstNode    `xml:"child,omitempty"`
	Entity  *ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["OvfConsumerOstNode"] = reflect.TypeOf((*OvfConsumerOstNode)(nil)).Elem()
}

type OvfConsumerOvfSection struct {
	DynamicData

	LineNumber int    `xml:"lineNumber"`
	Xml        string `xml:"xml"`
}

func init() {
	t["OvfConsumerOvfSection"] = reflect.TypeOf((*OvfConsumerOvfSection)(nil)).Elem()
}

type OvfConsumerPowerOnFault struct {
	InvalidState

	ExtensionKey  string `xml:"extensionKey"`
	ExtensionName string `xml:"extensionName"`
	Description   string `xml:"description"`
}

func init() {
	t["OvfConsumerPowerOnFault"] = reflect.TypeOf((*OvfConsumerPowerOnFault)(nil)).Elem()
}

type OvfConsumerPowerOnFaultFault OvfConsumerPowerOnFault

func init() {
	t["OvfConsumerPowerOnFaultFault"] = reflect.TypeOf((*OvfConsumerPowerOnFaultFault)(nil)).Elem()
}

type OvfConsumerUndeclaredSection struct {
	OvfConsumerCallbackFault

	QualifiedSectionType string `xml:"qualifiedSectionType"`
}

func init() {
	t["OvfConsumerUndeclaredSection"] = reflect.TypeOf((*OvfConsumerUndeclaredSection)(nil)).Elem()
}

type OvfConsumerUndeclaredSectionFault OvfConsumerUndeclaredSection

func init() {
	t["OvfConsumerUndeclaredSectionFault"] = reflect.TypeOf((*OvfConsumerUndeclaredSectionFault)(nil)).Elem()
}

type OvfConsumerUndefinedPrefix struct {
	OvfConsumerCallbackFault

	Prefix string `xml:"prefix"`
}

func init() {
	t["OvfConsumerUndefinedPrefix"] = reflect.TypeOf((*OvfConsumerUndefinedPrefix)(nil)).Elem()
}

type OvfConsumerUndefinedPrefixFault OvfConsumerUndefinedPrefix

func init() {
	t["OvfConsumerUndefinedPrefixFault"] = reflect.TypeOf((*OvfConsumerUndefinedPrefixFault)(nil)).Elem()
}

type OvfConsumerValidationFault struct {
	VmConfigFault

	ExtensionKey  string `xml:"extensionKey"`
	ExtensionName string `xml:"extensionName"`
	Message       string `xml:"message"`
}

func init() {
	t["OvfConsumerValidationFault"] = reflect.TypeOf((*OvfConsumerValidationFault)(nil)).Elem()
}

type OvfConsumerValidationFaultFault OvfConsumerValidationFault

func init() {
	t["OvfConsumerValidationFaultFault"] = reflect.TypeOf((*OvfConsumerValidationFaultFault)(nil)).Elem()
}

type OvfCpuCompatibility struct {
	OvfImport

	RegisterName         string `xml:"registerName"`
	Level                int    `xml:"level"`
	RegisterValue        string `xml:"registerValue"`
	DesiredRegisterValue string `xml:"desiredRegisterValue"`
}

func init() {
	t["OvfCpuCompatibility"] = reflect.TypeOf((*OvfCpuCompatibility)(nil)).Elem()
}

type OvfCpuCompatibilityCheckNotSupported struct {
	OvfImport
}

func init() {
	t["OvfCpuCompatibilityCheckNotSupported"] = reflect.TypeOf((*OvfCpuCompatibilityCheckNotSupported)(nil)).Elem()
}

type OvfCpuCompatibilityCheckNotSupportedFault OvfCpuCompatibilityCheckNotSupported

func init() {
	t["OvfCpuCompatibilityCheckNotSupportedFault"] = reflect.TypeOf((*OvfCpuCompatibilityCheckNotSupportedFault)(nil)).Elem()
}

type OvfCpuCompatibilityFault OvfCpuCompatibility

func init() {
	t["OvfCpuCompatibilityFault"] = reflect.TypeOf((*OvfCpuCompatibilityFault)(nil)).Elem()
}

type OvfCreateDescriptorParams struct {
	DynamicData

	OvfFiles          []OvfFile               `xml:"ovfFiles,omitempty"`
	Name              string                  `xml:"name,omitempty"`
	Description       string                  `xml:"description,omitempty"`
	IncludeImageFiles *bool                   `xml:"includeImageFiles"`
	ExportOption      []string                `xml:"exportOption,omitempty"`
	Snapshot          *ManagedObjectReference `xml:"snapshot,omitempty"`
}

func init() {
	t["OvfCreateDescriptorParams"] = reflect.TypeOf((*OvfCreateDescriptorParams)(nil)).Elem()
}

type OvfCreateDescriptorResult struct {
	DynamicData

	OvfDescriptor     string                 `xml:"ovfDescriptor"`
	Error             []LocalizedMethodFault `xml:"error,omitempty"`
	Warning           []LocalizedMethodFault `xml:"warning,omitempty"`
	IncludeImageFiles *bool                  `xml:"includeImageFiles"`
}

func init() {
	t["OvfCreateDescriptorResult"] = reflect.TypeOf((*OvfCreateDescriptorResult)(nil)).Elem()
}

type OvfCreateImportSpecParams struct {
	OvfManagerCommonParams

	EntityName         string                  `xml:"entityName"`
	HostSystem         *ManagedObjectReference `xml:"hostSystem,omitempty"`
	NetworkMapping     []OvfNetworkMapping     `xml:"networkMapping,omitempty"`
	IpAllocationPolicy string                  `xml:"ipAllocationPolicy,omitempty"`
	IpProtocol         string                  `xml:"ipProtocol,omitempty"`
	PropertyMapping    []KeyValue              `xml:"propertyMapping,omitempty"`
	ResourceMapping    []OvfResourceMap        `xml:"resourceMapping,omitempty"`
	DiskProvisioning   string                  `xml:"diskProvisioning,omitempty"`
	InstantiationOst   *OvfConsumerOstNode     `xml:"instantiationOst,omitempty"`
}

func init() {
	t["OvfCreateImportSpecParams"] = reflect.TypeOf((*OvfCreateImportSpecParams)(nil)).Elem()
}

type OvfCreateImportSpecResult struct {
	DynamicData

	ImportSpec BaseImportSpec         `xml:"importSpec,omitempty,typeattr"`
	FileItem   []OvfFileItem          `xml:"fileItem,omitempty"`
	Warning    []LocalizedMethodFault `xml:"warning,omitempty"`
	Error      []LocalizedMethodFault `xml:"error,omitempty"`
}

func init() {
	t["OvfCreateImportSpecResult"] = reflect.TypeOf((*OvfCreateImportSpecResult)(nil)).Elem()
}

type OvfDeploymentOption struct {
	DynamicData

	Key         string `xml:"key"`
	Label       string `xml:"label"`
	Description string `xml:"description"`
}

func init() {
	t["OvfDeploymentOption"] = reflect.TypeOf((*OvfDeploymentOption)(nil)).Elem()
}

type OvfDiskMappingNotFound struct {
	OvfSystemFault

	DiskName string `xml:"diskName"`
	VmName   string `xml:"vmName"`
}

func init() {
	t["OvfDiskMappingNotFound"] = reflect.TypeOf((*OvfDiskMappingNotFound)(nil)).Elem()
}

type OvfDiskMappingNotFoundFault OvfDiskMappingNotFound

func init() {
	t["OvfDiskMappingNotFoundFault"] = reflect.TypeOf((*OvfDiskMappingNotFoundFault)(nil)).Elem()
}

type OvfDiskOrderConstraint struct {
	OvfConstraint
}

func init() {
	t["OvfDiskOrderConstraint"] = reflect.TypeOf((*OvfDiskOrderConstraint)(nil)).Elem()
}

type OvfDiskOrderConstraintFault OvfDiskOrderConstraint

func init() {
	t["OvfDiskOrderConstraintFault"] = reflect.TypeOf((*OvfDiskOrderConstraintFault)(nil)).Elem()
}

type OvfDuplicateElement struct {
	OvfElement
}

func init() {
	t["OvfDuplicateElement"] = reflect.TypeOf((*OvfDuplicateElement)(nil)).Elem()
}

type OvfDuplicateElementFault OvfDuplicateElement

func init() {
	t["OvfDuplicateElementFault"] = reflect.TypeOf((*OvfDuplicateElementFault)(nil)).Elem()
}

type OvfDuplicatedElementBoundary struct {
	OvfElement

	Boundary string `xml:"boundary"`
}

func init() {
	t["OvfDuplicatedElementBoundary"] = reflect.TypeOf((*OvfDuplicatedElementBoundary)(nil)).Elem()
}

type OvfDuplicatedElementBoundaryFault OvfDuplicatedElementBoundary

func init() {
	t["OvfDuplicatedElementBoundaryFault"] = reflect.TypeOf((*OvfDuplicatedElementBoundaryFault)(nil)).Elem()
}

type OvfDuplicatedPropertyIdExport struct {
	OvfExport

	Fqid string `xml:"fqid"`
}

func init() {
	t["OvfDuplicatedPropertyIdExport"] = reflect.TypeOf((*OvfDuplicatedPropertyIdExport)(nil)).Elem()
}

type OvfDuplicatedPropertyIdExportFault OvfDuplicatedPropertyIdExport

func init() {
	t["OvfDuplicatedPropertyIdExportFault"] = reflect.TypeOf((*OvfDuplicatedPropertyIdExportFault)(nil)).Elem()
}

type OvfDuplicatedPropertyIdImport struct {
	OvfExport
}

func init() {
	t["OvfDuplicatedPropertyIdImport"] = reflect.TypeOf((*OvfDuplicatedPropertyIdImport)(nil)).Elem()
}

type OvfDuplicatedPropertyIdImportFault OvfDuplicatedPropertyIdImport

func init() {
	t["OvfDuplicatedPropertyIdImportFault"] = reflect.TypeOf((*OvfDuplicatedPropertyIdImportFault)(nil)).Elem()
}

type OvfElement struct {
	OvfInvalidPackage

	Name string `xml:"name"`
}

func init() {
	t["OvfElement"] = reflect.TypeOf((*OvfElement)(nil)).Elem()
}

type OvfElementFault BaseOvfElement

func init() {
	t["OvfElementFault"] = reflect.TypeOf((*OvfElementFault)(nil)).Elem()
}

type OvfElementInvalidValue struct {
	OvfElement

	Value string `xml:"value"`
}

func init() {
	t["OvfElementInvalidValue"] = reflect.TypeOf((*OvfElementInvalidValue)(nil)).Elem()
}

type OvfElementInvalidValueFault OvfElementInvalidValue

func init() {
	t["OvfElementInvalidValueFault"] = reflect.TypeOf((*OvfElementInvalidValueFault)(nil)).Elem()
}

type OvfExport struct {
	OvfFault
}

func init() {
	t["OvfExport"] = reflect.TypeOf((*OvfExport)(nil)).Elem()
}

type OvfExportFailed struct {
	OvfExport
}

func init() {
	t["OvfExportFailed"] = reflect.TypeOf((*OvfExportFailed)(nil)).Elem()
}

type OvfExportFailedFault OvfExportFailed

func init() {
	t["OvfExportFailedFault"] = reflect.TypeOf((*OvfExportFailedFault)(nil)).Elem()
}

type OvfExportFault BaseOvfExport

func init() {
	t["OvfExportFault"] = reflect.TypeOf((*OvfExportFault)(nil)).Elem()
}

type OvfFault struct {
	VimFault
}

func init() {
	t["OvfFault"] = reflect.TypeOf((*OvfFault)(nil)).Elem()
}

type OvfFaultFault BaseOvfFault

func init() {
	t["OvfFaultFault"] = reflect.TypeOf((*OvfFaultFault)(nil)).Elem()
}

type OvfFile struct {
	DynamicData

	DeviceId          string `xml:"deviceId"`
	Path              string `xml:"path"`
	CompressionMethod string `xml:"compressionMethod,omitempty"`
	ChunkSize         int64  `xml:"chunkSize,omitempty"`
	Size              int64  `xml:"size"`
	Capacity          int64  `xml:"capacity,omitempty"`
	PopulatedSize     int64  `xml:"populatedSize,omitempty"`
}

func init() {
	t["OvfFile"] = reflect.TypeOf((*OvfFile)(nil)).Elem()
}

type OvfFileItem struct {
	DynamicData

	DeviceId          string `xml:"deviceId"`
	Path              string `xml:"path"`
	CompressionMethod string `xml:"compressionMethod,omitempty"`
	ChunkSize         int64  `xml:"chunkSize,omitempty"`
	Size              int64  `xml:"size,omitempty"`
	CimType           int    `xml:"cimType"`
	Create            bool   `xml:"create"`
}

func init() {
	t["OvfFileItem"] = reflect.TypeOf((*OvfFileItem)(nil)).Elem()
}

type OvfHardwareCheck struct {
	OvfImport
}

func init() {
	t["OvfHardwareCheck"] = reflect.TypeOf((*OvfHardwareCheck)(nil)).Elem()
}

type OvfHardwareCheckFault OvfHardwareCheck

func init() {
	t["OvfHardwareCheckFault"] = reflect.TypeOf((*OvfHardwareCheckFault)(nil)).Elem()
}

type OvfHardwareExport struct {
	OvfExport

	Device BaseVirtualDevice `xml:"device,omitempty,typeattr"`
	VmPath string            `xml:"vmPath"`
}

func init() {
	t["OvfHardwareExport"] = reflect.TypeOf((*OvfHardwareExport)(nil)).Elem()
}

type OvfHardwareExportFault BaseOvfHardwareExport

func init() {
	t["OvfHardwareExportFault"] = reflect.TypeOf((*OvfHardwareExportFault)(nil)).Elem()
}

type OvfHostResourceConstraint struct {
	OvfConstraint

	Value string `xml:"value"`
}

func init() {
	t["OvfHostResourceConstraint"] = reflect.TypeOf((*OvfHostResourceConstraint)(nil)).Elem()
}

type OvfHostResourceConstraintFault OvfHostResourceConstraint

func init() {
	t["OvfHostResourceConstraintFault"] = reflect.TypeOf((*OvfHostResourceConstraintFault)(nil)).Elem()
}

type OvfHostValueNotParsed struct {
	OvfSystemFault

	Property string `xml:"property"`
	Value    string `xml:"value"`
}

func init() {
	t["OvfHostValueNotParsed"] = reflect.TypeOf((*OvfHostValueNotParsed)(nil)).Elem()
}

type OvfHostValueNotParsedFault OvfHostValueNotParsed

func init() {
	t["OvfHostValueNotParsedFault"] = reflect.TypeOf((*OvfHostValueNotParsedFault)(nil)).Elem()
}

type OvfImport struct {
	OvfFault
}

func init() {
	t["OvfImport"] = reflect.TypeOf((*OvfImport)(nil)).Elem()
}

type OvfImportFailed struct {
	OvfImport
}

func init() {
	t["OvfImportFailed"] = reflect.TypeOf((*OvfImportFailed)(nil)).Elem()
}

type OvfImportFailedFault OvfImportFailed

func init() {
	t["OvfImportFailedFault"] = reflect.TypeOf((*OvfImportFailedFault)(nil)).Elem()
}

type OvfImportFault BaseOvfImport

func init() {
	t["OvfImportFault"] = reflect.TypeOf((*OvfImportFault)(nil)).Elem()
}

type OvfInternalError struct {
	OvfSystemFault
}

func init() {
	t["OvfInternalError"] = reflect.TypeOf((*OvfInternalError)(nil)).Elem()
}

type OvfInternalErrorFault OvfInternalError

func init() {
	t["OvfInternalErrorFault"] = reflect.TypeOf((*OvfInternalErrorFault)(nil)).Elem()
}

type OvfInvalidPackage struct {
	OvfFault

	LineNumber int `xml:"lineNumber"`
}

func init() {
	t["OvfInvalidPackage"] = reflect.TypeOf((*OvfInvalidPackage)(nil)).Elem()
}

type OvfInvalidPackageFault BaseOvfInvalidPackage

func init() {
	t["OvfInvalidPackageFault"] = reflect.TypeOf((*OvfInvalidPackageFault)(nil)).Elem()
}

type OvfInvalidValue struct {
	OvfAttribute

	Value string `xml:"value"`
}

func init() {
	t["OvfInvalidValue"] = reflect.TypeOf((*OvfInvalidValue)(nil)).Elem()
}

type OvfInvalidValueConfiguration struct {
	OvfInvalidValue
}

func init() {
	t["OvfInvalidValueConfiguration"] = reflect.TypeOf((*OvfInvalidValueConfiguration)(nil)).Elem()
}

type OvfInvalidValueConfigurationFault OvfInvalidValueConfiguration

func init() {
	t["OvfInvalidValueConfigurationFault"] = reflect.TypeOf((*OvfInvalidValueConfigurationFault)(nil)).Elem()
}

type OvfInvalidValueEmpty struct {
	OvfInvalidValue
}

func init() {
	t["OvfInvalidValueEmpty"] = reflect.TypeOf((*OvfInvalidValueEmpty)(nil)).Elem()
}

type OvfInvalidValueEmptyFault OvfInvalidValueEmpty

func init() {
	t["OvfInvalidValueEmptyFault"] = reflect.TypeOf((*OvfInvalidValueEmptyFault)(nil)).Elem()
}

type OvfInvalidValueFault BaseOvfInvalidValue

func init() {
	t["OvfInvalidValueFault"] = reflect.TypeOf((*OvfInvalidValueFault)(nil)).Elem()
}

type OvfInvalidValueFormatMalformed struct {
	OvfInvalidValue
}

func init() {
	t["OvfInvalidValueFormatMalformed"] = reflect.TypeOf((*OvfInvalidValueFormatMalformed)(nil)).Elem()
}

type OvfInvalidValueFormatMalformedFault OvfInvalidValueFormatMalformed

func init() {
	t["OvfInvalidValueFormatMalformedFault"] = reflect.TypeOf((*OvfInvalidValueFormatMalformedFault)(nil)).Elem()
}

type OvfInvalidValueReference struct {
	OvfInvalidValue
}

func init() {
	t["OvfInvalidValueReference"] = reflect.TypeOf((*OvfInvalidValueReference)(nil)).Elem()
}

type OvfInvalidValueReferenceFault OvfInvalidValueReference

func init() {
	t["OvfInvalidValueReferenceFault"] = reflect.TypeOf((*OvfInvalidValueReferenceFault)(nil)).Elem()
}

type OvfInvalidVmName struct {
	OvfUnsupportedPackage

	Name string `xml:"name"`
}

func init() {
	t["OvfInvalidVmName"] = reflect.TypeOf((*OvfInvalidVmName)(nil)).Elem()
}

type OvfInvalidVmNameFault OvfInvalidVmName

func init() {
	t["OvfInvalidVmNameFault"] = reflect.TypeOf((*OvfInvalidVmNameFault)(nil)).Elem()
}

type OvfManagerCommonParams struct {
	DynamicData

	Locale           string     `xml:"locale"`
	DeploymentOption string     `xml:"deploymentOption"`
	MsgBundle        []KeyValue `xml:"msgBundle,omitempty"`
	ImportOption     []string   `xml:"importOption,omitempty"`
}

func init() {
	t["OvfManagerCommonParams"] = reflect.TypeOf((*OvfManagerCommonParams)(nil)).Elem()
}

type OvfMappedOsId struct {
	OvfImport

	OvfId             int    `xml:"ovfId"`
	OvfDescription    string `xml:"ovfDescription"`
	TargetDescription string `xml:"targetDescription"`
}

func init() {
	t["OvfMappedOsId"] = reflect.TypeOf((*OvfMappedOsId)(nil)).Elem()
}

type OvfMappedOsIdFault OvfMappedOsId

func init() {
	t["OvfMappedOsIdFault"] = reflect.TypeOf((*OvfMappedOsIdFault)(nil)).Elem()
}

type OvfMissingAttribute struct {
	OvfAttribute
}

func init() {
	t["OvfMissingAttribute"] = reflect.TypeOf((*OvfMissingAttribute)(nil)).Elem()
}

type OvfMissingAttributeFault OvfMissingAttribute

func init() {
	t["OvfMissingAttributeFault"] = reflect.TypeOf((*OvfMissingAttributeFault)(nil)).Elem()
}

type OvfMissingElement struct {
	OvfElement
}

func init() {
	t["OvfMissingElement"] = reflect.TypeOf((*OvfMissingElement)(nil)).Elem()
}

type OvfMissingElementFault BaseOvfMissingElement

func init() {
	t["OvfMissingElementFault"] = reflect.TypeOf((*OvfMissingElementFault)(nil)).Elem()
}

type OvfMissingElementNormalBoundary struct {
	OvfMissingElement

	Boundary string `xml:"boundary"`
}

func init() {
	t["OvfMissingElementNormalBoundary"] = reflect.TypeOf((*OvfMissingElementNormalBoundary)(nil)).Elem()
}

type OvfMissingElementNormalBoundaryFault OvfMissingElementNormalBoundary

func init() {
	t["OvfMissingElementNormalBoundaryFault"] = reflect.TypeOf((*OvfMissingElementNormalBoundaryFault)(nil)).Elem()
}

type OvfMissingHardware struct {
	OvfImport

	Name         string `xml:"name"`
	ResourceType int    `xml:"resourceType"`
}

func init() {
	t["OvfMissingHardware"] = reflect.TypeOf((*OvfMissingHardware)(nil)).Elem()
}

type OvfMissingHardwareFault OvfMissingHardware

func init() {
	t["OvfMissingHardwareFault"] = reflect.TypeOf((*OvfMissingHardwareFault)(nil)).Elem()
}

type OvfNetworkInfo struct {
	DynamicData

	Name        string `xml:"name"`
	Description string `xml:"description"`
}

func init() {
	t["OvfNetworkInfo"] = reflect.TypeOf((*OvfNetworkInfo)(nil)).Elem()
}

type OvfNetworkMapping struct {
	DynamicData

	Name    string                 `xml:"name"`
	Network ManagedObjectReference `xml:"network"`
}

func init() {
	t["OvfNetworkMapping"] = reflect.TypeOf((*OvfNetworkMapping)(nil)).Elem()
}

type OvfNetworkMappingNotSupported struct {
	OvfImport
}

func init() {
	t["OvfNetworkMappingNotSupported"] = reflect.TypeOf((*OvfNetworkMappingNotSupported)(nil)).Elem()
}

type OvfNetworkMappingNotSupportedFault OvfNetworkMappingNotSupported

func init() {
	t["OvfNetworkMappingNotSupportedFault"] = reflect.TypeOf((*OvfNetworkMappingNotSupportedFault)(nil)).Elem()
}

type OvfNoHostNic struct {
	OvfUnsupportedPackage
}

func init() {
	t["OvfNoHostNic"] = reflect.TypeOf((*OvfNoHostNic)(nil)).Elem()
}

type OvfNoHostNicFault OvfNoHostNic

func init() {
	t["OvfNoHostNicFault"] = reflect.TypeOf((*OvfNoHostNicFault)(nil)).Elem()
}

type OvfNoSpaceOnController struct {
	OvfUnsupportedElement

	Parent string `xml:"parent"`
}

func init() {
	t["OvfNoSpaceOnController"] = reflect.TypeOf((*OvfNoSpaceOnController)(nil)).Elem()
}

type OvfNoSpaceOnControllerFault OvfNoSpaceOnController

func init() {
	t["OvfNoSpaceOnControllerFault"] = reflect.TypeOf((*OvfNoSpaceOnControllerFault)(nil)).Elem()
}

type OvfNoSupportedHardwareFamily struct {
	OvfUnsupportedPackage

	Version string `xml:"version"`
}

func init() {
	t["OvfNoSupportedHardwareFamily"] = reflect.TypeOf((*OvfNoSupportedHardwareFamily)(nil)).Elem()
}

type OvfNoSupportedHardwareFamilyFault OvfNoSupportedHardwareFamily

func init() {
	t["OvfNoSupportedHardwareFamilyFault"] = reflect.TypeOf((*OvfNoSupportedHardwareFamilyFault)(nil)).Elem()
}

type OvfOptionInfo struct {
	DynamicData

	Option      string             `xml:"option"`
	Description LocalizableMessage `xml:"description"`
}

func init() {
	t["OvfOptionInfo"] = reflect.TypeOf((*OvfOptionInfo)(nil)).Elem()
}

type OvfParseDescriptorParams struct {
	OvfManagerCommonParams
}

func init() {
	t["OvfParseDescriptorParams"] = reflect.TypeOf((*OvfParseDescriptorParams)(nil)).Elem()
}

type OvfParseDescriptorResult struct {
	DynamicData

	Eula                            []string               `xml:"eula,omitempty"`
	Network                         []OvfNetworkInfo       `xml:"network,omitempty"`
	IpAllocationScheme              []string               `xml:"ipAllocationScheme,omitempty"`
	IpProtocols                     []string               `xml:"ipProtocols,omitempty"`
	Property                        []VAppPropertyInfo     `xml:"property,omitempty"`
	ProductInfo                     *VAppProductInfo       `xml:"productInfo,omitempty"`
	Annotation                      string                 `xml:"annotation"`
	ApproximateDownloadSize         int64                  `xml:"approximateDownloadSize,omitempty"`
	ApproximateFlatDeploymentSize   int64                  `xml:"approximateFlatDeploymentSize,omitempty"`
	ApproximateSparseDeploymentSize int64                  `xml:"approximateSparseDeploymentSize,omitempty"`
	DefaultEntityName               string                 `xml:"defaultEntityName"`
	VirtualApp                      bool                   `xml:"virtualApp"`
	DeploymentOption                []OvfDeploymentOption  `xml:"deploymentOption,omitempty"`
	DefaultDeploymentOption         string                 `xml:"defaultDeploymentOption"`
	EntityName                      []KeyValue             `xml:"entityName,omitempty"`
	AnnotatedOst                    *OvfConsumerOstNode    `xml:"annotatedOst,omitempty"`
	Error                           []LocalizedMethodFault `xml:"error,omitempty"`
	Warning                         []LocalizedMethodFault `xml:"warning,omitempty"`
}

func init() {
	t["OvfParseDescriptorResult"] = reflect.TypeOf((*OvfParseDescriptorResult)(nil)).Elem()
}

type OvfProperty struct {
	OvfInvalidPackage

	Type  string `xml:"type"`
	Value string `xml:"value"`
}

func init() {
	t["OvfProperty"] = reflect.TypeOf((*OvfProperty)(nil)).Elem()
}

type OvfPropertyExport struct {
	OvfExport

	Type  string `xml:"type"`
	Value string `xml:"value"`
}

func init() {
	t["OvfPropertyExport"] = reflect.TypeOf((*OvfPropertyExport)(nil)).Elem()
}

type OvfPropertyExportFault OvfPropertyExport

func init() {
	t["OvfPropertyExportFault"] = reflect.TypeOf((*OvfPropertyExportFault)(nil)).Elem()
}

type OvfPropertyFault BaseOvfProperty

func init() {
	t["OvfPropertyFault"] = reflect.TypeOf((*OvfPropertyFault)(nil)).Elem()
}

type OvfPropertyNetwork struct {
	OvfProperty
}

func init() {
	t["OvfPropertyNetwork"] = reflect.TypeOf((*OvfPropertyNetwork)(nil)).Elem()
}

type OvfPropertyNetworkExport struct {
	OvfExport

	Network string `xml:"network"`
}

func init() {
	t["OvfPropertyNetworkExport"] = reflect.TypeOf((*OvfPropertyNetworkExport)(nil)).Elem()
}

type OvfPropertyNetworkExportFault OvfPropertyNetworkExport

func init() {
	t["OvfPropertyNetworkExportFault"] = reflect.TypeOf((*OvfPropertyNetworkExportFault)(nil)).Elem()
}

type OvfPropertyNetworkFault OvfPropertyNetwork

func init() {
	t["OvfPropertyNetworkFault"] = reflect.TypeOf((*OvfPropertyNetworkFault)(nil)).Elem()
}

type OvfPropertyQualifier struct {
	OvfProperty

	Qualifier string `xml:"qualifier"`
}

func init() {
	t["OvfPropertyQualifier"] = reflect.TypeOf((*OvfPropertyQualifier)(nil)).Elem()
}

type OvfPropertyQualifierDuplicate struct {
	OvfProperty

	Qualifier string `xml:"qualifier"`
}

func init() {
	t["OvfPropertyQualifierDuplicate"] = reflect.TypeOf((*OvfPropertyQualifierDuplicate)(nil)).Elem()
}

type OvfPropertyQualifierDuplicateFault OvfPropertyQualifierDuplicate

func init() {
	t["OvfPropertyQualifierDuplicateFault"] = reflect.TypeOf((*OvfPropertyQualifierDuplicateFault)(nil)).Elem()
}

type OvfPropertyQualifierFault OvfPropertyQualifier

func init() {
	t["OvfPropertyQualifierFault"] = reflect.TypeOf((*OvfPropertyQualifierFault)(nil)).Elem()
}

type OvfPropertyQualifierIgnored struct {
	OvfProperty

	Qualifier string `xml:"qualifier"`
}

func init() {
	t["OvfPropertyQualifierIgnored"] = reflect.TypeOf((*OvfPropertyQualifierIgnored)(nil)).Elem()
}

type OvfPropertyQualifierIgnoredFault OvfPropertyQualifierIgnored

func init() {
	t["OvfPropertyQualifierIgnoredFault"] = reflect.TypeOf((*OvfPropertyQualifierIgnoredFault)(nil)).Elem()
}

type OvfPropertyType struct {
	OvfProperty
}

func init() {
	t["OvfPropertyType"] = reflect.TypeOf((*OvfPropertyType)(nil)).Elem()
}

type OvfPropertyTypeFault OvfPropertyType

func init() {
	t["OvfPropertyTypeFault"] = reflect.TypeOf((*OvfPropertyTypeFault)(nil)).Elem()
}

type OvfPropertyValue struct {
	OvfProperty
}

func init() {
	t["OvfPropertyValue"] = reflect.TypeOf((*OvfPropertyValue)(nil)).Elem()
}

type OvfPropertyValueFault OvfPropertyValue

func init() {
	t["OvfPropertyValueFault"] = reflect.TypeOf((*OvfPropertyValueFault)(nil)).Elem()
}

type OvfResourceMap struct {
	DynamicData

	Source       string                  `xml:"source"`
	Parent       *ManagedObjectReference `xml:"parent,omitempty"`
	ResourceSpec *ResourceConfigSpec     `xml:"resourceSpec,omitempty"`
	Datastore    *ManagedObjectReference `xml:"datastore,omitempty"`
}

func init() {
	t["OvfResourceMap"] = reflect.TypeOf((*OvfResourceMap)(nil)).Elem()
}

type OvfSystemFault struct {
	OvfFault
}

func init() {
	t["OvfSystemFault"] = reflect.TypeOf((*OvfSystemFault)(nil)).Elem()
}

type OvfSystemFaultFault BaseOvfSystemFault

func init() {
	t["OvfSystemFaultFault"] = reflect.TypeOf((*OvfSystemFaultFault)(nil)).Elem()
}

type OvfToXmlUnsupportedElement struct {
	OvfSystemFault

	Name string `xml:"name,omitempty"`
}

func init() {
	t["OvfToXmlUnsupportedElement"] = reflect.TypeOf((*OvfToXmlUnsupportedElement)(nil)).Elem()
}

type OvfToXmlUnsupportedElementFault OvfToXmlUnsupportedElement

func init() {
	t["OvfToXmlUnsupportedElementFault"] = reflect.TypeOf((*OvfToXmlUnsupportedElementFault)(nil)).Elem()
}

type OvfUnableToExportDisk struct {
	OvfHardwareExport

	DiskName string `xml:"diskName"`
}

func init() {
	t["OvfUnableToExportDisk"] = reflect.TypeOf((*OvfUnableToExportDisk)(nil)).Elem()
}

type OvfUnableToExportDiskFault OvfUnableToExportDisk

func init() {
	t["OvfUnableToExportDiskFault"] = reflect.TypeOf((*OvfUnableToExportDiskFault)(nil)).Elem()
}

type OvfUnexpectedElement struct {
	OvfElement
}

func init() {
	t["OvfUnexpectedElement"] = reflect.TypeOf((*OvfUnexpectedElement)(nil)).Elem()
}

type OvfUnexpectedElementFault OvfUnexpectedElement

func init() {
	t["OvfUnexpectedElementFault"] = reflect.TypeOf((*OvfUnexpectedElementFault)(nil)).Elem()
}

type OvfUnknownDevice struct {
	OvfSystemFault

	Device BaseVirtualDevice `xml:"device,omitempty,typeattr"`
	VmName string            `xml:"vmName"`
}

func init() {
	t["OvfUnknownDevice"] = reflect.TypeOf((*OvfUnknownDevice)(nil)).Elem()
}

type OvfUnknownDeviceBacking struct {
	OvfHardwareExport

	Backing BaseVirtualDeviceBackingInfo `xml:"backing,typeattr"`
}

func init() {
	t["OvfUnknownDeviceBacking"] = reflect.TypeOf((*OvfUnknownDeviceBacking)(nil)).Elem()
}

type OvfUnknownDeviceBackingFault OvfUnknownDeviceBacking

func init() {
	t["OvfUnknownDeviceBackingFault"] = reflect.TypeOf((*OvfUnknownDeviceBackingFault)(nil)).Elem()
}

type OvfUnknownDeviceFault OvfUnknownDevice

func init() {
	t["OvfUnknownDeviceFault"] = reflect.TypeOf((*OvfUnknownDeviceFault)(nil)).Elem()
}

type OvfUnknownEntity struct {
	OvfSystemFault

	LineNumber int `xml:"lineNumber"`
}

func init() {
	t["OvfUnknownEntity"] = reflect.TypeOf((*OvfUnknownEntity)(nil)).Elem()
}

type OvfUnknownEntityFault OvfUnknownEntity

func init() {
	t["OvfUnknownEntityFault"] = reflect.TypeOf((*OvfUnknownEntityFault)(nil)).Elem()
}

type OvfUnsupportedAttribute struct {
	OvfUnsupportedPackage

	ElementName   string `xml:"elementName"`
	AttributeName string `xml:"attributeName"`
}

func init() {
	t["OvfUnsupportedAttribute"] = reflect.TypeOf((*OvfUnsupportedAttribute)(nil)).Elem()
}

type OvfUnsupportedAttributeFault BaseOvfUnsupportedAttribute

func init() {
	t["OvfUnsupportedAttributeFault"] = reflect.TypeOf((*OvfUnsupportedAttributeFault)(nil)).Elem()
}

type OvfUnsupportedAttributeValue struct {
	OvfUnsupportedAttribute

	Value string `xml:"value"`
}

func init() {
	t["OvfUnsupportedAttributeValue"] = reflect.TypeOf((*OvfUnsupportedAttributeValue)(nil)).Elem()
}

type OvfUnsupportedAttributeValueFault OvfUnsupportedAttributeValue

func init() {
	t["OvfUnsupportedAttributeValueFault"] = reflect.TypeOf((*OvfUnsupportedAttributeValueFault)(nil)).Elem()
}

type OvfUnsupportedDeviceBackingInfo struct {
	OvfSystemFault

	ElementName string `xml:"elementName,omitempty"`
	InstanceId  string `xml:"instanceId,omitempty"`
	DeviceName  string `xml:"deviceName"`
	BackingName string `xml:"backingName,omitempty"`
}

func init() {
	t["OvfUnsupportedDeviceBackingInfo"] = reflect.TypeOf((*OvfUnsupportedDeviceBackingInfo)(nil)).Elem()
}

type OvfUnsupportedDeviceBackingInfoFault OvfUnsupportedDeviceBackingInfo

func init() {
	t["OvfUnsupportedDeviceBackingInfoFault"] = reflect.TypeOf((*OvfUnsupportedDeviceBackingInfoFault)(nil)).Elem()
}

type OvfUnsupportedDeviceBackingOption struct {
	OvfSystemFault

	ElementName string `xml:"elementName,omitempty"`
	InstanceId  string `xml:"instanceId,omitempty"`
	DeviceName  string `xml:"deviceName"`
	BackingName string `xml:"backingName,omitempty"`
}

func init() {
	t["OvfUnsupportedDeviceBackingOption"] = reflect.TypeOf((*OvfUnsupportedDeviceBackingOption)(nil)).Elem()
}

type OvfUnsupportedDeviceBackingOptionFault OvfUnsupportedDeviceBackingOption

func init() {
	t["OvfUnsupportedDeviceBackingOptionFault"] = reflect.TypeOf((*OvfUnsupportedDeviceBackingOptionFault)(nil)).Elem()
}

type OvfUnsupportedDeviceExport struct {
	OvfHardwareExport
}

func init() {
	t["OvfUnsupportedDeviceExport"] = reflect.TypeOf((*OvfUnsupportedDeviceExport)(nil)).Elem()
}

type OvfUnsupportedDeviceExportFault OvfUnsupportedDeviceExport

func init() {
	t["OvfUnsupportedDeviceExportFault"] = reflect.TypeOf((*OvfUnsupportedDeviceExportFault)(nil)).Elem()
}

type OvfUnsupportedDiskProvisioning struct {
	OvfImport

	DiskProvisioning          string `xml:"diskProvisioning"`
	SupportedDiskProvisioning string `xml:"supportedDiskProvisioning"`
}

func init() {
	t["OvfUnsupportedDiskProvisioning"] = reflect.TypeOf((*OvfUnsupportedDiskProvisioning)(nil)).Elem()
}

type OvfUnsupportedDiskProvisioningFault OvfUnsupportedDiskProvisioning

func init() {
	t["OvfUnsupportedDiskProvisioningFault"] = reflect.TypeOf((*OvfUnsupportedDiskProvisioningFault)(nil)).Elem()
}

type OvfUnsupportedElement struct {
	OvfUnsupportedPackage

	Name string `xml:"name"`
}

func init() {
	t["OvfUnsupportedElement"] = reflect.TypeOf((*OvfUnsupportedElement)(nil)).Elem()
}

type OvfUnsupportedElementFault BaseOvfUnsupportedElement

func init() {
	t["OvfUnsupportedElementFault"] = reflect.TypeOf((*OvfUnsupportedElementFault)(nil)).Elem()
}

type OvfUnsupportedElementValue struct {
	OvfUnsupportedElement

	Value string `xml:"value"`
}

func init() {
	t["OvfUnsupportedElementValue"] = reflect.TypeOf((*OvfUnsupportedElementValue)(nil)).Elem()
}

type OvfUnsupportedElementValueFault OvfUnsupportedElementValue

func init() {
	t["OvfUnsupportedElementValueFault"] = reflect.TypeOf((*OvfUnsupportedElementValueFault)(nil)).Elem()
}

type OvfUnsupportedPackage struct {
	OvfFault

	LineNumber int `xml:"lineNumber,omitempty"`
}

func init() {
	t["OvfUnsupportedPackage"] = reflect.TypeOf((*OvfUnsupportedPackage)(nil)).Elem()
}

type OvfUnsupportedPackageFault BaseOvfUnsupportedPackage

func init() {
	t["OvfUnsupportedPackageFault"] = reflect.TypeOf((*OvfUnsupportedPackageFault)(nil)).Elem()
}

type OvfUnsupportedSection struct {
	OvfUnsupportedElement

	Info string `xml:"info"`
}

func init() {
	t["OvfUnsupportedSection"] = reflect.TypeOf((*OvfUnsupportedSection)(nil)).Elem()
}

type OvfUnsupportedSectionFault OvfUnsupportedSection

func init() {
	t["OvfUnsupportedSectionFault"] = reflect.TypeOf((*OvfUnsupportedSectionFault)(nil)).Elem()
}

type OvfUnsupportedSubType struct {
	OvfUnsupportedPackage

	ElementName   string `xml:"elementName"`
	InstanceId    string `xml:"instanceId"`
	DeviceType    int    `xml:"deviceType"`
	DeviceSubType string `xml:"deviceSubType"`
}

func init() {
	t["OvfUnsupportedSubType"] = reflect.TypeOf((*OvfUnsupportedSubType)(nil)).Elem()
}

type OvfUnsupportedSubTypeFault OvfUnsupportedSubType

func init() {
	t["OvfUnsupportedSubTypeFault"] = reflect.TypeOf((*OvfUnsupportedSubTypeFault)(nil)).Elem()
}

type OvfUnsupportedType struct {
	OvfUnsupportedPackage

	Name       string `xml:"name"`
	InstanceId string `xml:"instanceId"`
	DeviceType int    `xml:"deviceType"`
}

func init() {
	t["OvfUnsupportedType"] = reflect.TypeOf((*OvfUnsupportedType)(nil)).Elem()
}

type OvfUnsupportedTypeFault OvfUnsupportedType

func init() {
	t["OvfUnsupportedTypeFault"] = reflect.TypeOf((*OvfUnsupportedTypeFault)(nil)).Elem()
}

type OvfValidateHostParams struct {
	OvfManagerCommonParams
}

func init() {
	t["OvfValidateHostParams"] = reflect.TypeOf((*OvfValidateHostParams)(nil)).Elem()
}

type OvfValidateHostResult struct {
	DynamicData

	DownloadSize              int64                  `xml:"downloadSize,omitempty"`
	FlatDeploymentSize        int64                  `xml:"flatDeploymentSize,omitempty"`
	SparseDeploymentSize      int64                  `xml:"sparseDeploymentSize,omitempty"`
	Error                     []LocalizedMethodFault `xml:"error,omitempty"`
	Warning                   []LocalizedMethodFault `xml:"warning,omitempty"`
	SupportedDiskProvisioning []string               `xml:"supportedDiskProvisioning,omitempty"`
}

func init() {
	t["OvfValidateHostResult"] = reflect.TypeOf((*OvfValidateHostResult)(nil)).Elem()
}

type OvfWrongElement struct {
	OvfElement
}

func init() {
	t["OvfWrongElement"] = reflect.TypeOf((*OvfWrongElement)(nil)).Elem()
}

type OvfWrongElementFault OvfWrongElement

func init() {
	t["OvfWrongElementFault"] = reflect.TypeOf((*OvfWrongElementFault)(nil)).Elem()
}

type OvfWrongNamespace struct {
	OvfInvalidPackage

	NamespaceName string `xml:"namespaceName"`
}

func init() {
	t["OvfWrongNamespace"] = reflect.TypeOf((*OvfWrongNamespace)(nil)).Elem()
}

type OvfWrongNamespaceFault OvfWrongNamespace

func init() {
	t["OvfWrongNamespaceFault"] = reflect.TypeOf((*OvfWrongNamespaceFault)(nil)).Elem()
}

type OvfXmlFormat struct {
	OvfInvalidPackage

	Description string `xml:"description"`
}

func init() {
	t["OvfXmlFormat"] = reflect.TypeOf((*OvfXmlFormat)(nil)).Elem()
}

type OvfXmlFormatFault OvfXmlFormat

func init() {
	t["OvfXmlFormatFault"] = reflect.TypeOf((*OvfXmlFormatFault)(nil)).Elem()
}

type ParaVirtualSCSIController struct {
	VirtualSCSIController
}

func init() {
	t["ParaVirtualSCSIController"] = reflect.TypeOf((*ParaVirtualSCSIController)(nil)).Elem()
}

type ParaVirtualSCSIControllerOption struct {
	VirtualSCSIControllerOption
}

func init() {
	t["ParaVirtualSCSIControllerOption"] = reflect.TypeOf((*ParaVirtualSCSIControllerOption)(nil)).Elem()
}

type ParseDescriptor ParseDescriptorRequestType

func init() {
	t["ParseDescriptor"] = reflect.TypeOf((*ParseDescriptor)(nil)).Elem()
}

type ParseDescriptorRequestType struct {
	This          ManagedObjectReference   `xml:"_this"`
	OvfDescriptor string                   `xml:"ovfDescriptor"`
	Pdp           OvfParseDescriptorParams `xml:"pdp"`
}

func init() {
	t["ParseDescriptorRequestType"] = reflect.TypeOf((*ParseDescriptorRequestType)(nil)).Elem()
}

type ParseDescriptorResponse struct {
	Returnval OvfParseDescriptorResult `xml:"returnval"`
}

type PasswordField struct {
	DynamicData

	Value string `xml:"value"`
}

func init() {
	t["PasswordField"] = reflect.TypeOf((*PasswordField)(nil)).Elem()
}

type PatchAlreadyInstalled struct {
	PatchNotApplicable
}

func init() {
	t["PatchAlreadyInstalled"] = reflect.TypeOf((*PatchAlreadyInstalled)(nil)).Elem()
}

type PatchAlreadyInstalledFault PatchAlreadyInstalled

func init() {
	t["PatchAlreadyInstalledFault"] = reflect.TypeOf((*PatchAlreadyInstalledFault)(nil)).Elem()
}

type PatchBinariesNotFound struct {
	VimFault

	PatchID string   `xml:"patchID"`
	Binary  []string `xml:"binary,omitempty"`
}

func init() {
	t["PatchBinariesNotFound"] = reflect.TypeOf((*PatchBinariesNotFound)(nil)).Elem()
}

type PatchBinariesNotFoundFault PatchBinariesNotFound

func init() {
	t["PatchBinariesNotFoundFault"] = reflect.TypeOf((*PatchBinariesNotFoundFault)(nil)).Elem()
}

type PatchInstallFailed struct {
	PlatformConfigFault

	RolledBack bool `xml:"rolledBack"`
}

func init() {
	t["PatchInstallFailed"] = reflect.TypeOf((*PatchInstallFailed)(nil)).Elem()
}

type PatchInstallFailedFault PatchInstallFailed

func init() {
	t["PatchInstallFailedFault"] = reflect.TypeOf((*PatchInstallFailedFault)(nil)).Elem()
}

type PatchIntegrityError struct {
	PlatformConfigFault
}

func init() {
	t["PatchIntegrityError"] = reflect.TypeOf((*PatchIntegrityError)(nil)).Elem()
}

type PatchIntegrityErrorFault PatchIntegrityError

func init() {
	t["PatchIntegrityErrorFault"] = reflect.TypeOf((*PatchIntegrityErrorFault)(nil)).Elem()
}

type PatchMetadataCorrupted struct {
	PatchMetadataInvalid
}

func init() {
	t["PatchMetadataCorrupted"] = reflect.TypeOf((*PatchMetadataCorrupted)(nil)).Elem()
}

type PatchMetadataCorruptedFault PatchMetadataCorrupted

func init() {
	t["PatchMetadataCorruptedFault"] = reflect.TypeOf((*PatchMetadataCorruptedFault)(nil)).Elem()
}

type PatchMetadataInvalid struct {
	VimFault

	PatchID  string   `xml:"patchID"`
	MetaData []string `xml:"metaData,omitempty"`
}

func init() {
	t["PatchMetadataInvalid"] = reflect.TypeOf((*PatchMetadataInvalid)(nil)).Elem()
}

type PatchMetadataInvalidFault BasePatchMetadataInvalid

func init() {
	t["PatchMetadataInvalidFault"] = reflect.TypeOf((*PatchMetadataInvalidFault)(nil)).Elem()
}

type PatchMetadataNotFound struct {
	PatchMetadataInvalid
}

func init() {
	t["PatchMetadataNotFound"] = reflect.TypeOf((*PatchMetadataNotFound)(nil)).Elem()
}

type PatchMetadataNotFoundFault PatchMetadataNotFound

func init() {
	t["PatchMetadataNotFoundFault"] = reflect.TypeOf((*PatchMetadataNotFoundFault)(nil)).Elem()
}

type PatchMissingDependencies struct {
	PatchNotApplicable

	PrerequisitePatch []string `xml:"prerequisitePatch,omitempty"`
	PrerequisiteLib   []string `xml:"prerequisiteLib,omitempty"`
}

func init() {
	t["PatchMissingDependencies"] = reflect.TypeOf((*PatchMissingDependencies)(nil)).Elem()
}

type PatchMissingDependenciesFault PatchMissingDependencies

func init() {
	t["PatchMissingDependenciesFault"] = reflect.TypeOf((*PatchMissingDependenciesFault)(nil)).Elem()
}

type PatchNotApplicable struct {
	VimFault

	PatchID string `xml:"patchID"`
}

func init() {
	t["PatchNotApplicable"] = reflect.TypeOf((*PatchNotApplicable)(nil)).Elem()
}

type PatchNotApplicableFault BasePatchNotApplicable

func init() {
	t["PatchNotApplicableFault"] = reflect.TypeOf((*PatchNotApplicableFault)(nil)).Elem()
}

type PatchSuperseded struct {
	PatchNotApplicable

	Supersede []string `xml:"supersede,omitempty"`
}

func init() {
	t["PatchSuperseded"] = reflect.TypeOf((*PatchSuperseded)(nil)).Elem()
}

type PatchSupersededFault PatchSuperseded

func init() {
	t["PatchSupersededFault"] = reflect.TypeOf((*PatchSupersededFault)(nil)).Elem()
}

type PerfCompositeMetric struct {
	DynamicData

	Entity      BasePerfEntityMetricBase   `xml:"entity,omitempty,typeattr"`
	ChildEntity []BasePerfEntityMetricBase `xml:"childEntity,omitempty,typeattr"`
}

func init() {
	t["PerfCompositeMetric"] = reflect.TypeOf((*PerfCompositeMetric)(nil)).Elem()
}

type PerfCounterInfo struct {
	DynamicData

	Key                 int                    `xml:"key"`
	NameInfo            BaseElementDescription `xml:"nameInfo,typeattr"`
	GroupInfo           BaseElementDescription `xml:"groupInfo,typeattr"`
	UnitInfo            BaseElementDescription `xml:"unitInfo,typeattr"`
	RollupType          PerfSummaryType        `xml:"rollupType"`
	StatsType           PerfStatsType          `xml:"statsType"`
	Level               int                    `xml:"level,omitempty"`
	PerDeviceLevel      int                    `xml:"perDeviceLevel,omitempty"`
	AssociatedCounterId []int                  `xml:"associatedCounterId,omitempty"`
}

func init() {
	t["PerfCounterInfo"] = reflect.TypeOf((*PerfCounterInfo)(nil)).Elem()
}

type PerfEntityMetric struct {
	PerfEntityMetricBase

	SampleInfo []PerfSampleInfo       `xml:"sampleInfo,omitempty"`
	Value      []BasePerfMetricSeries `xml:"value,omitempty,typeattr"`
}

func init() {
	t["PerfEntityMetric"] = reflect.TypeOf((*PerfEntityMetric)(nil)).Elem()
}

type PerfEntityMetricBase struct {
	DynamicData

	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["PerfEntityMetricBase"] = reflect.TypeOf((*PerfEntityMetricBase)(nil)).Elem()
}

type PerfEntityMetricCSV struct {
	PerfEntityMetricBase

	SampleInfoCSV string                `xml:"sampleInfoCSV"`
	Value         []PerfMetricSeriesCSV `xml:"value,omitempty"`
}

func init() {
	t["PerfEntityMetricCSV"] = reflect.TypeOf((*PerfEntityMetricCSV)(nil)).Elem()
}

type PerfInterval struct {
	DynamicData

	Key            int    `xml:"key"`
	SamplingPeriod int    `xml:"samplingPeriod"`
	Name           string `xml:"name"`
	Length         int    `xml:"length"`
	Level          int    `xml:"level,omitempty"`
	Enabled        bool   `xml:"enabled"`
}

func init() {
	t["PerfInterval"] = reflect.TypeOf((*PerfInterval)(nil)).Elem()
}

type PerfMetricId struct {
	DynamicData

	CounterId int    `xml:"counterId"`
	Instance  string `xml:"instance"`
}

func init() {
	t["PerfMetricId"] = reflect.TypeOf((*PerfMetricId)(nil)).Elem()
}

type PerfMetricIntSeries struct {
	PerfMetricSeries

	Value []int64 `xml:"value,omitempty"`
}

func init() {
	t["PerfMetricIntSeries"] = reflect.TypeOf((*PerfMetricIntSeries)(nil)).Elem()
}

type PerfMetricSeries struct {
	DynamicData

	Id PerfMetricId `xml:"id"`
}

func init() {
	t["PerfMetricSeries"] = reflect.TypeOf((*PerfMetricSeries)(nil)).Elem()
}

type PerfMetricSeriesCSV struct {
	PerfMetricSeries

	Value string `xml:"value,omitempty"`
}

func init() {
	t["PerfMetricSeriesCSV"] = reflect.TypeOf((*PerfMetricSeriesCSV)(nil)).Elem()
}

type PerfProviderSummary struct {
	DynamicData

	Entity           ManagedObjectReference `xml:"entity"`
	CurrentSupported bool                   `xml:"currentSupported"`
	SummarySupported bool                   `xml:"summarySupported"`
	RefreshRate      int                    `xml:"refreshRate,omitempty"`
}

func init() {
	t["PerfProviderSummary"] = reflect.TypeOf((*PerfProviderSummary)(nil)).Elem()
}

type PerfQuerySpec struct {
	DynamicData

	Entity     ManagedObjectReference `xml:"entity"`
	StartTime  *time.Time             `xml:"startTime"`
	EndTime    *time.Time             `xml:"endTime"`
	MaxSample  int                    `xml:"maxSample,omitempty"`
	MetricId   []PerfMetricId         `xml:"metricId,omitempty"`
	IntervalId int                    `xml:"intervalId,omitempty"`
	Format     string                 `xml:"format,omitempty"`
}

func init() {
	t["PerfQuerySpec"] = reflect.TypeOf((*PerfQuerySpec)(nil)).Elem()
}

type PerfSampleInfo struct {
	DynamicData

	Timestamp time.Time `xml:"timestamp"`
	Interval  int       `xml:"interval"`
}

func init() {
	t["PerfSampleInfo"] = reflect.TypeOf((*PerfSampleInfo)(nil)).Elem()
}

type PerformDvsProductSpecOperationRequestType struct {
	This        ManagedObjectReference               `xml:"_this"`
	Operation   string                               `xml:"operation"`
	ProductSpec *DistributedVirtualSwitchProductSpec `xml:"productSpec,omitempty"`
}

func init() {
	t["PerformDvsProductSpecOperationRequestType"] = reflect.TypeOf((*PerformDvsProductSpecOperationRequestType)(nil)).Elem()
}

type PerformDvsProductSpecOperation_Task PerformDvsProductSpecOperationRequestType

func init() {
	t["PerformDvsProductSpecOperation_Task"] = reflect.TypeOf((*PerformDvsProductSpecOperation_Task)(nil)).Elem()
}

type PerformDvsProductSpecOperation_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PerformanceDescription struct {
	DynamicData

	CounterType []BaseElementDescription `xml:"counterType,typeattr"`
	StatsType   []BaseElementDescription `xml:"statsType,typeattr"`
}

func init() {
	t["PerformanceDescription"] = reflect.TypeOf((*PerformanceDescription)(nil)).Elem()
}

type PerformanceManagerCounterLevelMapping struct {
	DynamicData

	CounterId      int `xml:"counterId"`
	AggregateLevel int `xml:"aggregateLevel,omitempty"`
	PerDeviceLevel int `xml:"perDeviceLevel,omitempty"`
}

func init() {
	t["PerformanceManagerCounterLevelMapping"] = reflect.TypeOf((*PerformanceManagerCounterLevelMapping)(nil)).Elem()
}

type PerformanceStatisticsDescription struct {
	DynamicData

	Intervals []PerfInterval `xml:"intervals,omitempty"`
}

func init() {
	t["PerformanceStatisticsDescription"] = reflect.TypeOf((*PerformanceStatisticsDescription)(nil)).Elem()
}

type Permission struct {
	DynamicData

	Entity    *ManagedObjectReference `xml:"entity,omitempty"`
	Principal string                  `xml:"principal"`
	Group     bool                    `xml:"group"`
	RoleId    int                     `xml:"roleId"`
	Propagate bool                    `xml:"propagate"`
}

func init() {
	t["Permission"] = reflect.TypeOf((*Permission)(nil)).Elem()
}

type PermissionAddedEvent struct {
	PermissionEvent

	Role      RoleEventArgument `xml:"role"`
	Propagate bool              `xml:"propagate"`
}

func init() {
	t["PermissionAddedEvent"] = reflect.TypeOf((*PermissionAddedEvent)(nil)).Elem()
}

type PermissionEvent struct {
	AuthorizationEvent

	Entity    ManagedEntityEventArgument `xml:"entity"`
	Principal string                     `xml:"principal"`
	Group     bool                       `xml:"group"`
}

func init() {
	t["PermissionEvent"] = reflect.TypeOf((*PermissionEvent)(nil)).Elem()
}

type PermissionProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["PermissionProfile"] = reflect.TypeOf((*PermissionProfile)(nil)).Elem()
}

type PermissionRemovedEvent struct {
	PermissionEvent
}

func init() {
	t["PermissionRemovedEvent"] = reflect.TypeOf((*PermissionRemovedEvent)(nil)).Elem()
}

type PermissionUpdatedEvent struct {
	PermissionEvent

	Role      RoleEventArgument `xml:"role"`
	Propagate bool              `xml:"propagate"`
}

func init() {
	t["PermissionUpdatedEvent"] = reflect.TypeOf((*PermissionUpdatedEvent)(nil)).Elem()
}

type PhysCompatRDMNotSupported struct {
	RDMNotSupported
}

func init() {
	t["PhysCompatRDMNotSupported"] = reflect.TypeOf((*PhysCompatRDMNotSupported)(nil)).Elem()
}

type PhysCompatRDMNotSupportedFault PhysCompatRDMNotSupported

func init() {
	t["PhysCompatRDMNotSupportedFault"] = reflect.TypeOf((*PhysCompatRDMNotSupportedFault)(nil)).Elem()
}

type PhysicalNic struct {
	DynamicData

	Key                                   string                `xml:"key,omitempty"`
	Device                                string                `xml:"device"`
	Pci                                   string                `xml:"pci"`
	Driver                                string                `xml:"driver,omitempty"`
	LinkSpeed                             *PhysicalNicLinkInfo  `xml:"linkSpeed,omitempty"`
	ValidLinkSpecification                []PhysicalNicLinkInfo `xml:"validLinkSpecification,omitempty"`
	Spec                                  PhysicalNicSpec       `xml:"spec"`
	WakeOnLanSupported                    bool                  `xml:"wakeOnLanSupported"`
	Mac                                   string                `xml:"mac"`
	FcoeConfiguration                     *FcoeConfig           `xml:"fcoeConfiguration,omitempty"`
	VmDirectPathGen2Supported             *bool                 `xml:"vmDirectPathGen2Supported"`
	VmDirectPathGen2SupportedMode         string                `xml:"vmDirectPathGen2SupportedMode,omitempty"`
	ResourcePoolSchedulerAllowed          *bool                 `xml:"resourcePoolSchedulerAllowed"`
	ResourcePoolSchedulerDisallowedReason []string              `xml:"resourcePoolSchedulerDisallowedReason,omitempty"`
	AutoNegotiateSupported                *bool                 `xml:"autoNegotiateSupported"`
}

func init() {
	t["PhysicalNic"] = reflect.TypeOf((*PhysicalNic)(nil)).Elem()
}

type PhysicalNicCdpDeviceCapability struct {
	DynamicData

	Router            bool `xml:"router"`
	TransparentBridge bool `xml:"transparentBridge"`
	SourceRouteBridge bool `xml:"sourceRouteBridge"`
	NetworkSwitch     bool `xml:"networkSwitch"`
	Host              bool `xml:"host"`
	IgmpEnabled       bool `xml:"igmpEnabled"`
	Repeater          bool `xml:"repeater"`
}

func init() {
	t["PhysicalNicCdpDeviceCapability"] = reflect.TypeOf((*PhysicalNicCdpDeviceCapability)(nil)).Elem()
}

type PhysicalNicCdpInfo struct {
	DynamicData

	CdpVersion       int                             `xml:"cdpVersion,omitempty"`
	Timeout          int                             `xml:"timeout,omitempty"`
	Ttl              int                             `xml:"ttl,omitempty"`
	Samples          int                             `xml:"samples,omitempty"`
	DevId            string                          `xml:"devId,omitempty"`
	Address          string                          `xml:"address,omitempty"`
	PortId           string                          `xml:"portId,omitempty"`
	DeviceCapability *PhysicalNicCdpDeviceCapability `xml:"deviceCapability,omitempty"`
	SoftwareVersion  string                          `xml:"softwareVersion,omitempty"`
	HardwarePlatform string                          `xml:"hardwarePlatform,omitempty"`
	IpPrefix         string                          `xml:"ipPrefix,omitempty"`
	IpPrefixLen      int                             `xml:"ipPrefixLen,omitempty"`
	Vlan             int                             `xml:"vlan,omitempty"`
	FullDuplex       *bool                           `xml:"fullDuplex"`
	Mtu              int                             `xml:"mtu,omitempty"`
	SystemName       string                          `xml:"systemName,omitempty"`
	SystemOID        string                          `xml:"systemOID,omitempty"`
	MgmtAddr         string                          `xml:"mgmtAddr,omitempty"`
	Location         string                          `xml:"location,omitempty"`
}

func init() {
	t["PhysicalNicCdpInfo"] = reflect.TypeOf((*PhysicalNicCdpInfo)(nil)).Elem()
}

type PhysicalNicConfig struct {
	DynamicData

	Device string          `xml:"device"`
	Spec   PhysicalNicSpec `xml:"spec"`
}

func init() {
	t["PhysicalNicConfig"] = reflect.TypeOf((*PhysicalNicConfig)(nil)).Elem()
}

type PhysicalNicHint struct {
	DynamicData

	VlanId int `xml:"vlanId,omitempty"`
}

func init() {
	t["PhysicalNicHint"] = reflect.TypeOf((*PhysicalNicHint)(nil)).Elem()
}

type PhysicalNicHintInfo struct {
	DynamicData

	Device              string                          `xml:"device"`
	Subnet              []PhysicalNicIpHint             `xml:"subnet,omitempty"`
	Network             []PhysicalNicNameHint           `xml:"network,omitempty"`
	ConnectedSwitchPort *PhysicalNicCdpInfo             `xml:"connectedSwitchPort,omitempty"`
	LldpInfo            *LinkLayerDiscoveryProtocolInfo `xml:"lldpInfo,omitempty"`
}

func init() {
	t["PhysicalNicHintInfo"] = reflect.TypeOf((*PhysicalNicHintInfo)(nil)).Elem()
}

type PhysicalNicIpHint struct {
	PhysicalNicHint

	IpSubnet string `xml:"ipSubnet"`
}

func init() {
	t["PhysicalNicIpHint"] = reflect.TypeOf((*PhysicalNicIpHint)(nil)).Elem()
}

type PhysicalNicLinkInfo struct {
	DynamicData

	SpeedMb int  `xml:"speedMb"`
	Duplex  bool `xml:"duplex"`
}

func init() {
	t["PhysicalNicLinkInfo"] = reflect.TypeOf((*PhysicalNicLinkInfo)(nil)).Elem()
}

type PhysicalNicNameHint struct {
	PhysicalNicHint

	Network string `xml:"network"`
}

func init() {
	t["PhysicalNicNameHint"] = reflect.TypeOf((*PhysicalNicNameHint)(nil)).Elem()
}

type PhysicalNicProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["PhysicalNicProfile"] = reflect.TypeOf((*PhysicalNicProfile)(nil)).Elem()
}

type PhysicalNicSpec struct {
	DynamicData

	Ip        *HostIpConfig        `xml:"ip,omitempty"`
	LinkSpeed *PhysicalNicLinkInfo `xml:"linkSpeed,omitempty"`
}

func init() {
	t["PhysicalNicSpec"] = reflect.TypeOf((*PhysicalNicSpec)(nil)).Elem()
}

type PlatformConfigFault struct {
	HostConfigFault

	Text string `xml:"text"`
}

func init() {
	t["PlatformConfigFault"] = reflect.TypeOf((*PlatformConfigFault)(nil)).Elem()
}

type PlatformConfigFaultFault BasePlatformConfigFault

func init() {
	t["PlatformConfigFaultFault"] = reflect.TypeOf((*PlatformConfigFaultFault)(nil)).Elem()
}

type PnicUplinkProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["PnicUplinkProfile"] = reflect.TypeOf((*PnicUplinkProfile)(nil)).Elem()
}

type PodDiskLocator struct {
	DynamicData

	DiskId          int                             `xml:"diskId"`
	DiskMoveType    string                          `xml:"diskMoveType,omitempty"`
	DiskBackingInfo BaseVirtualDeviceBackingInfo    `xml:"diskBackingInfo,omitempty,typeattr"`
	Profile         []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr"`
}

func init() {
	t["PodDiskLocator"] = reflect.TypeOf((*PodDiskLocator)(nil)).Elem()
}

type PodStorageDrsEntry struct {
	DynamicData

	StorageDrsConfig StorageDrsConfigInfo    `xml:"storageDrsConfig"`
	Recommendation   []ClusterRecommendation `xml:"recommendation,omitempty"`
	DrsFault         []ClusterDrsFaults      `xml:"drsFault,omitempty"`
	ActionHistory    []ClusterActionHistory  `xml:"actionHistory,omitempty"`
}

func init() {
	t["PodStorageDrsEntry"] = reflect.TypeOf((*PodStorageDrsEntry)(nil)).Elem()
}

type PolicyOption struct {
	DynamicData

	Id        string        `xml:"id"`
	Parameter []KeyAnyValue `xml:"parameter,omitempty"`
}

func init() {
	t["PolicyOption"] = reflect.TypeOf((*PolicyOption)(nil)).Elem()
}

type PortGroupProfile struct {
	ApplyProfile

	Key           string                        `xml:"key"`
	Name          string                        `xml:"name"`
	Vlan          VlanProfile                   `xml:"vlan"`
	Vswitch       VirtualSwitchSelectionProfile `xml:"vswitch"`
	NetworkPolicy NetworkPolicyProfile          `xml:"networkPolicy"`
}

func init() {
	t["PortGroupProfile"] = reflect.TypeOf((*PortGroupProfile)(nil)).Elem()
}

type PosixUserSearchResult struct {
	UserSearchResult

	Id          int   `xml:"id"`
	ShellAccess *bool `xml:"shellAccess"`
}

func init() {
	t["PosixUserSearchResult"] = reflect.TypeOf((*PosixUserSearchResult)(nil)).Elem()
}

type PostEvent PostEventRequestType

func init() {
	t["PostEvent"] = reflect.TypeOf((*PostEvent)(nil)).Elem()
}

type PostEventRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	EventToPost BaseEvent              `xml:"eventToPost,typeattr"`
	TaskInfo    *TaskInfo              `xml:"taskInfo,omitempty"`
}

func init() {
	t["PostEventRequestType"] = reflect.TypeOf((*PostEventRequestType)(nil)).Elem()
}

type PostEventResponse struct {
}

type PowerDownHostToStandByRequestType struct {
	This                  ManagedObjectReference `xml:"_this"`
	TimeoutSec            int                    `xml:"timeoutSec"`
	EvacuatePoweredOffVms *bool                  `xml:"evacuatePoweredOffVms"`
}

func init() {
	t["PowerDownHostToStandByRequestType"] = reflect.TypeOf((*PowerDownHostToStandByRequestType)(nil)).Elem()
}

type PowerDownHostToStandBy_Task PowerDownHostToStandByRequestType

func init() {
	t["PowerDownHostToStandBy_Task"] = reflect.TypeOf((*PowerDownHostToStandBy_Task)(nil)).Elem()
}

type PowerDownHostToStandBy_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PowerOffVAppRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Force bool                   `xml:"force"`
}

func init() {
	t["PowerOffVAppRequestType"] = reflect.TypeOf((*PowerOffVAppRequestType)(nil)).Elem()
}

type PowerOffVApp_Task PowerOffVAppRequestType

func init() {
	t["PowerOffVApp_Task"] = reflect.TypeOf((*PowerOffVApp_Task)(nil)).Elem()
}

type PowerOffVApp_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PowerOffVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["PowerOffVMRequestType"] = reflect.TypeOf((*PowerOffVMRequestType)(nil)).Elem()
}

type PowerOffVM_Task PowerOffVMRequestType

func init() {
	t["PowerOffVM_Task"] = reflect.TypeOf((*PowerOffVM_Task)(nil)).Elem()
}

type PowerOffVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PowerOnFtSecondaryFailed struct {
	VmFaultToleranceIssue

	Vm              ManagedObjectReference          `xml:"vm"`
	VmName          string                          `xml:"vmName"`
	HostSelectionBy FtIssuesOnHostHostSelectionType `xml:"hostSelectionBy"`
	HostErrors      []LocalizedMethodFault          `xml:"hostErrors,omitempty"`
	RootCause       LocalizedMethodFault            `xml:"rootCause"`
}

func init() {
	t["PowerOnFtSecondaryFailed"] = reflect.TypeOf((*PowerOnFtSecondaryFailed)(nil)).Elem()
}

type PowerOnFtSecondaryFailedFault PowerOnFtSecondaryFailed

func init() {
	t["PowerOnFtSecondaryFailedFault"] = reflect.TypeOf((*PowerOnFtSecondaryFailedFault)(nil)).Elem()
}

type PowerOnFtSecondaryTimedout struct {
	Timedout

	Vm      ManagedObjectReference `xml:"vm"`
	VmName  string                 `xml:"vmName"`
	Timeout int                    `xml:"timeout"`
}

func init() {
	t["PowerOnFtSecondaryTimedout"] = reflect.TypeOf((*PowerOnFtSecondaryTimedout)(nil)).Elem()
}

type PowerOnFtSecondaryTimedoutFault PowerOnFtSecondaryTimedout

func init() {
	t["PowerOnFtSecondaryTimedoutFault"] = reflect.TypeOf((*PowerOnFtSecondaryTimedoutFault)(nil)).Elem()
}

type PowerOnMultiVMRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Vm     []ManagedObjectReference `xml:"vm"`
	Option []BaseOptionValue        `xml:"option,omitempty,typeattr"`
}

func init() {
	t["PowerOnMultiVMRequestType"] = reflect.TypeOf((*PowerOnMultiVMRequestType)(nil)).Elem()
}

type PowerOnMultiVM_Task PowerOnMultiVMRequestType

func init() {
	t["PowerOnMultiVM_Task"] = reflect.TypeOf((*PowerOnMultiVM_Task)(nil)).Elem()
}

type PowerOnMultiVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PowerOnVAppRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["PowerOnVAppRequestType"] = reflect.TypeOf((*PowerOnVAppRequestType)(nil)).Elem()
}

type PowerOnVApp_Task PowerOnVAppRequestType

func init() {
	t["PowerOnVApp_Task"] = reflect.TypeOf((*PowerOnVApp_Task)(nil)).Elem()
}

type PowerOnVApp_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PowerOnVMRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["PowerOnVMRequestType"] = reflect.TypeOf((*PowerOnVMRequestType)(nil)).Elem()
}

type PowerOnVM_Task PowerOnVMRequestType

func init() {
	t["PowerOnVM_Task"] = reflect.TypeOf((*PowerOnVM_Task)(nil)).Elem()
}

type PowerOnVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PowerSystemCapability struct {
	DynamicData

	AvailablePolicy []HostPowerPolicy `xml:"availablePolicy"`
}

func init() {
	t["PowerSystemCapability"] = reflect.TypeOf((*PowerSystemCapability)(nil)).Elem()
}

type PowerSystemInfo struct {
	DynamicData

	CurrentPolicy HostPowerPolicy `xml:"currentPolicy"`
}

func init() {
	t["PowerSystemInfo"] = reflect.TypeOf((*PowerSystemInfo)(nil)).Elem()
}

type PowerUpHostFromStandByRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	TimeoutSec int                    `xml:"timeoutSec"`
}

func init() {
	t["PowerUpHostFromStandByRequestType"] = reflect.TypeOf((*PowerUpHostFromStandByRequestType)(nil)).Elem()
}

type PowerUpHostFromStandBy_Task PowerUpHostFromStandByRequestType

func init() {
	t["PowerUpHostFromStandBy_Task"] = reflect.TypeOf((*PowerUpHostFromStandBy_Task)(nil)).Elem()
}

type PowerUpHostFromStandBy_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PrivilegeAvailability struct {
	DynamicData

	PrivId    string `xml:"privId"`
	IsGranted bool   `xml:"isGranted"`
}

func init() {
	t["PrivilegeAvailability"] = reflect.TypeOf((*PrivilegeAvailability)(nil)).Elem()
}

type PrivilegePolicyDef struct {
	DynamicData

	CreatePrivilege string `xml:"createPrivilege"`
	ReadPrivilege   string `xml:"readPrivilege"`
	UpdatePrivilege string `xml:"updatePrivilege"`
	DeletePrivilege string `xml:"deletePrivilege"`
}

func init() {
	t["PrivilegePolicyDef"] = reflect.TypeOf((*PrivilegePolicyDef)(nil)).Elem()
}

type ProductComponentInfo struct {
	DynamicData

	Id      string `xml:"id"`
	Name    string `xml:"name"`
	Version string `xml:"version"`
	Release int    `xml:"release"`
}

func init() {
	t["ProductComponentInfo"] = reflect.TypeOf((*ProductComponentInfo)(nil)).Elem()
}

type ProfileApplyProfileElement struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["ProfileApplyProfileElement"] = reflect.TypeOf((*ProfileApplyProfileElement)(nil)).Elem()
}

type ProfileApplyProfileProperty struct {
	DynamicData

	PropertyName string             `xml:"propertyName"`
	Array        bool               `xml:"array"`
	Profile      []BaseApplyProfile `xml:"profile,omitempty,typeattr"`
}

func init() {
	t["ProfileApplyProfileProperty"] = reflect.TypeOf((*ProfileApplyProfileProperty)(nil)).Elem()
}

type ProfileAssociatedEvent struct {
	ProfileEvent
}

func init() {
	t["ProfileAssociatedEvent"] = reflect.TypeOf((*ProfileAssociatedEvent)(nil)).Elem()
}

type ProfileChangedEvent struct {
	ProfileEvent
}

func init() {
	t["ProfileChangedEvent"] = reflect.TypeOf((*ProfileChangedEvent)(nil)).Elem()
}

type ProfileCompositeExpression struct {
	ProfileExpression

	Operator       string   `xml:"operator"`
	ExpressionName []string `xml:"expressionName"`
}

func init() {
	t["ProfileCompositeExpression"] = reflect.TypeOf((*ProfileCompositeExpression)(nil)).Elem()
}

type ProfileCompositePolicyOptionMetadata struct {
	ProfilePolicyOptionMetadata

	Option []string `xml:"option"`
}

func init() {
	t["ProfileCompositePolicyOptionMetadata"] = reflect.TypeOf((*ProfileCompositePolicyOptionMetadata)(nil)).Elem()
}

type ProfileConfigInfo struct {
	DynamicData

	Name       string `xml:"name"`
	Annotation string `xml:"annotation,omitempty"`
	Enabled    bool   `xml:"enabled"`
}

func init() {
	t["ProfileConfigInfo"] = reflect.TypeOf((*ProfileConfigInfo)(nil)).Elem()
}

type ProfileCreateSpec struct {
	DynamicData

	Name       string `xml:"name,omitempty"`
	Annotation string `xml:"annotation,omitempty"`
	Enabled    *bool  `xml:"enabled"`
}

func init() {
	t["ProfileCreateSpec"] = reflect.TypeOf((*ProfileCreateSpec)(nil)).Elem()
}

type ProfileCreatedEvent struct {
	ProfileEvent
}

func init() {
	t["ProfileCreatedEvent"] = reflect.TypeOf((*ProfileCreatedEvent)(nil)).Elem()
}

type ProfileDeferredPolicyOptionParameter struct {
	DynamicData

	InputPath ProfilePropertyPath `xml:"inputPath"`
	Parameter []KeyAnyValue       `xml:"parameter,omitempty"`
}

func init() {
	t["ProfileDeferredPolicyOptionParameter"] = reflect.TypeOf((*ProfileDeferredPolicyOptionParameter)(nil)).Elem()
}

type ProfileDescription struct {
	DynamicData

	Section []ProfileDescriptionSection `xml:"section"`
}

func init() {
	t["ProfileDescription"] = reflect.TypeOf((*ProfileDescription)(nil)).Elem()
}

type ProfileDescriptionSection struct {
	DynamicData

	Description ExtendedElementDescription `xml:"description"`
	Message     []LocalizableMessage       `xml:"message,omitempty"`
}

func init() {
	t["ProfileDescriptionSection"] = reflect.TypeOf((*ProfileDescriptionSection)(nil)).Elem()
}

type ProfileDissociatedEvent struct {
	ProfileEvent
}

func init() {
	t["ProfileDissociatedEvent"] = reflect.TypeOf((*ProfileDissociatedEvent)(nil)).Elem()
}

type ProfileEvent struct {
	Event

	Profile ProfileEventArgument `xml:"profile"`
}

func init() {
	t["ProfileEvent"] = reflect.TypeOf((*ProfileEvent)(nil)).Elem()
}

type ProfileEventArgument struct {
	EventArgument

	Profile ManagedObjectReference `xml:"profile"`
	Name    string                 `xml:"name"`
}

func init() {
	t["ProfileEventArgument"] = reflect.TypeOf((*ProfileEventArgument)(nil)).Elem()
}

type ProfileExecuteError struct {
	DynamicData

	Path    *ProfilePropertyPath `xml:"path,omitempty"`
	Message LocalizableMessage   `xml:"message"`
}

func init() {
	t["ProfileExecuteError"] = reflect.TypeOf((*ProfileExecuteError)(nil)).Elem()
}

type ProfileExecuteResult struct {
	DynamicData

	Status           string                                 `xml:"status"`
	ConfigSpec       *HostConfigSpec                        `xml:"configSpec,omitempty"`
	InapplicablePath []string                               `xml:"inapplicablePath,omitempty"`
	RequireInput     []ProfileDeferredPolicyOptionParameter `xml:"requireInput,omitempty"`
	Error            []ProfileExecuteError                  `xml:"error,omitempty"`
}

func init() {
	t["ProfileExecuteResult"] = reflect.TypeOf((*ProfileExecuteResult)(nil)).Elem()
}

type ProfileExpression struct {
	DynamicData

	Id          string `xml:"id"`
	DisplayName string `xml:"displayName"`
	Negated     bool   `xml:"negated"`
}

func init() {
	t["ProfileExpression"] = reflect.TypeOf((*ProfileExpression)(nil)).Elem()
}

type ProfileExpressionMetadata struct {
	DynamicData

	ExpressionId ExtendedElementDescription `xml:"expressionId"`
	Parameter    []ProfileParameterMetadata `xml:"parameter,omitempty"`
}

func init() {
	t["ProfileExpressionMetadata"] = reflect.TypeOf((*ProfileExpressionMetadata)(nil)).Elem()
}

type ProfileMetadata struct {
	DynamicData

	Key              string                           `xml:"key"`
	ProfileTypeName  string                           `xml:"profileTypeName,omitempty"`
	Description      *ExtendedDescription             `xml:"description,omitempty"`
	SortSpec         []ProfileMetadataProfileSortSpec `xml:"sortSpec,omitempty"`
	ProfileCategory  string                           `xml:"profileCategory,omitempty"`
	ProfileComponent string                           `xml:"profileComponent,omitempty"`
}

func init() {
	t["ProfileMetadata"] = reflect.TypeOf((*ProfileMetadata)(nil)).Elem()
}

type ProfileMetadataProfileSortSpec struct {
	DynamicData

	PolicyId  string `xml:"policyId"`
	Parameter string `xml:"parameter"`
}

func init() {
	t["ProfileMetadataProfileSortSpec"] = reflect.TypeOf((*ProfileMetadataProfileSortSpec)(nil)).Elem()
}

type ProfileParameterMetadata struct {
	DynamicData

	Id           ExtendedElementDescription `xml:"id"`
	Type         string                     `xml:"type"`
	Optional     bool                       `xml:"optional"`
	DefaultValue AnyType                    `xml:"defaultValue,omitempty,typeattr"`
}

func init() {
	t["ProfileParameterMetadata"] = reflect.TypeOf((*ProfileParameterMetadata)(nil)).Elem()
}

type ProfilePolicy struct {
	DynamicData

	Id           string           `xml:"id"`
	PolicyOption BasePolicyOption `xml:"policyOption,typeattr"`
}

func init() {
	t["ProfilePolicy"] = reflect.TypeOf((*ProfilePolicy)(nil)).Elem()
}

type ProfilePolicyMetadata struct {
	DynamicData

	Id             ExtendedElementDescription        `xml:"id"`
	PossibleOption []BaseProfilePolicyOptionMetadata `xml:"possibleOption,typeattr"`
}

func init() {
	t["ProfilePolicyMetadata"] = reflect.TypeOf((*ProfilePolicyMetadata)(nil)).Elem()
}

type ProfilePolicyOptionMetadata struct {
	DynamicData

	Id        ExtendedElementDescription `xml:"id"`
	Parameter []ProfileParameterMetadata `xml:"parameter,omitempty"`
}

func init() {
	t["ProfilePolicyOptionMetadata"] = reflect.TypeOf((*ProfilePolicyOptionMetadata)(nil)).Elem()
}

type ProfileProfileStructure struct {
	DynamicData

	ProfileTypeName string                            `xml:"profileTypeName"`
	Child           []ProfileProfileStructureProperty `xml:"child,omitempty"`
}

func init() {
	t["ProfileProfileStructure"] = reflect.TypeOf((*ProfileProfileStructure)(nil)).Elem()
}

type ProfileProfileStructureProperty struct {
	DynamicData

	PropertyName string                  `xml:"propertyName"`
	Array        bool                    `xml:"array"`
	Element      ProfileProfileStructure `xml:"element"`
}

func init() {
	t["ProfileProfileStructureProperty"] = reflect.TypeOf((*ProfileProfileStructureProperty)(nil)).Elem()
}

type ProfilePropertyPath struct {
	DynamicData

	ProfilePath string `xml:"profilePath"`
	PolicyId    string `xml:"policyId,omitempty"`
	ParameterId string `xml:"parameterId,omitempty"`
}

func init() {
	t["ProfilePropertyPath"] = reflect.TypeOf((*ProfilePropertyPath)(nil)).Elem()
}

type ProfileReferenceHostChangedEvent struct {
	ProfileEvent

	ReferenceHost *ManagedObjectReference `xml:"referenceHost,omitempty"`
}

func init() {
	t["ProfileReferenceHostChangedEvent"] = reflect.TypeOf((*ProfileReferenceHostChangedEvent)(nil)).Elem()
}

type ProfileRemovedEvent struct {
	ProfileEvent
}

func init() {
	t["ProfileRemovedEvent"] = reflect.TypeOf((*ProfileRemovedEvent)(nil)).Elem()
}

type ProfileSerializedCreateSpec struct {
	ProfileCreateSpec

	ProfileConfigString string `xml:"profileConfigString"`
}

func init() {
	t["ProfileSerializedCreateSpec"] = reflect.TypeOf((*ProfileSerializedCreateSpec)(nil)).Elem()
}

type ProfileSimpleExpression struct {
	ProfileExpression

	ExpressionType string        `xml:"expressionType"`
	Parameter      []KeyAnyValue `xml:"parameter,omitempty"`
}

func init() {
	t["ProfileSimpleExpression"] = reflect.TypeOf((*ProfileSimpleExpression)(nil)).Elem()
}

type ProfileUpdateFailed struct {
	VimFault

	Failure []ProfileUpdateFailedUpdateFailure `xml:"failure"`
}

func init() {
	t["ProfileUpdateFailed"] = reflect.TypeOf((*ProfileUpdateFailed)(nil)).Elem()
}

type ProfileUpdateFailedFault ProfileUpdateFailed

func init() {
	t["ProfileUpdateFailedFault"] = reflect.TypeOf((*ProfileUpdateFailedFault)(nil)).Elem()
}

type ProfileUpdateFailedUpdateFailure struct {
	DynamicData

	ProfilePath ProfilePropertyPath `xml:"profilePath"`
	ErrMsg      LocalizableMessage  `xml:"errMsg"`
}

func init() {
	t["ProfileUpdateFailedUpdateFailure"] = reflect.TypeOf((*ProfileUpdateFailedUpdateFailure)(nil)).Elem()
}

type PromoteDisksRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Unlink bool                   `xml:"unlink"`
	Disks  []VirtualDisk          `xml:"disks,omitempty"`
}

func init() {
	t["PromoteDisksRequestType"] = reflect.TypeOf((*PromoteDisksRequestType)(nil)).Elem()
}

type PromoteDisks_Task PromoteDisksRequestType

func init() {
	t["PromoteDisks_Task"] = reflect.TypeOf((*PromoteDisks_Task)(nil)).Elem()
}

type PromoteDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type PropertyChange struct {
	DynamicData

	Name string           `xml:"name"`
	Op   PropertyChangeOp `xml:"op"`
	Val  AnyType          `xml:"val,omitempty,typeattr"`
}

func init() {
	t["PropertyChange"] = reflect.TypeOf((*PropertyChange)(nil)).Elem()
}

type PropertyFilterSpec struct {
	DynamicData

	PropSet                       []PropertySpec `xml:"propSet"`
	ObjectSet                     []ObjectSpec   `xml:"objectSet"`
	ReportMissingObjectsInResults *bool          `xml:"reportMissingObjectsInResults"`
}

func init() {
	t["PropertyFilterSpec"] = reflect.TypeOf((*PropertyFilterSpec)(nil)).Elem()
}

type PropertyFilterUpdate struct {
	DynamicData

	Filter     ManagedObjectReference `xml:"filter"`
	ObjectSet  []ObjectUpdate         `xml:"objectSet,omitempty"`
	MissingSet []MissingObject        `xml:"missingSet,omitempty"`
}

func init() {
	t["PropertyFilterUpdate"] = reflect.TypeOf((*PropertyFilterUpdate)(nil)).Elem()
}

type PropertySpec struct {
	DynamicData

	Type    string   `xml:"type"`
	All     *bool    `xml:"all"`
	PathSet []string `xml:"pathSet,omitempty"`
}

func init() {
	t["PropertySpec"] = reflect.TypeOf((*PropertySpec)(nil)).Elem()
}

type QueryAnswerFileStatus QueryAnswerFileStatusRequestType

func init() {
	t["QueryAnswerFileStatus"] = reflect.TypeOf((*QueryAnswerFileStatus)(nil)).Elem()
}

type QueryAnswerFileStatusRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["QueryAnswerFileStatusRequestType"] = reflect.TypeOf((*QueryAnswerFileStatusRequestType)(nil)).Elem()
}

type QueryAnswerFileStatusResponse struct {
	Returnval []AnswerFileStatusResult `xml:"returnval,omitempty"`
}

type QueryAssignedLicenses QueryAssignedLicensesRequestType

func init() {
	t["QueryAssignedLicenses"] = reflect.TypeOf((*QueryAssignedLicenses)(nil)).Elem()
}

type QueryAssignedLicensesRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	EntityId string                 `xml:"entityId,omitempty"`
}

func init() {
	t["QueryAssignedLicensesRequestType"] = reflect.TypeOf((*QueryAssignedLicensesRequestType)(nil)).Elem()
}

type QueryAssignedLicensesResponse struct {
	Returnval []LicenseAssignmentManagerLicenseAssignment `xml:"returnval"`
}

type QueryAvailableDisksForVmfs QueryAvailableDisksForVmfsRequestType

func init() {
	t["QueryAvailableDisksForVmfs"] = reflect.TypeOf((*QueryAvailableDisksForVmfs)(nil)).Elem()
}

type QueryAvailableDisksForVmfsRequestType struct {
	This      ManagedObjectReference  `xml:"_this"`
	Datastore *ManagedObjectReference `xml:"datastore,omitempty"`
}

func init() {
	t["QueryAvailableDisksForVmfsRequestType"] = reflect.TypeOf((*QueryAvailableDisksForVmfsRequestType)(nil)).Elem()
}

type QueryAvailableDisksForVmfsResponse struct {
	Returnval []HostScsiDisk `xml:"returnval,omitempty"`
}

type QueryAvailableDvsSpec QueryAvailableDvsSpecRequestType

func init() {
	t["QueryAvailableDvsSpec"] = reflect.TypeOf((*QueryAvailableDvsSpec)(nil)).Elem()
}

type QueryAvailableDvsSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryAvailableDvsSpecRequestType"] = reflect.TypeOf((*QueryAvailableDvsSpecRequestType)(nil)).Elem()
}

type QueryAvailableDvsSpecResponse struct {
	Returnval []DistributedVirtualSwitchProductSpec `xml:"returnval,omitempty"`
}

type QueryAvailablePartition QueryAvailablePartitionRequestType

func init() {
	t["QueryAvailablePartition"] = reflect.TypeOf((*QueryAvailablePartition)(nil)).Elem()
}

type QueryAvailablePartitionRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryAvailablePartitionRequestType"] = reflect.TypeOf((*QueryAvailablePartitionRequestType)(nil)).Elem()
}

type QueryAvailablePartitionResponse struct {
	Returnval []HostDiagnosticPartition `xml:"returnval,omitempty"`
}

type QueryAvailablePerfMetric QueryAvailablePerfMetricRequestType

func init() {
	t["QueryAvailablePerfMetric"] = reflect.TypeOf((*QueryAvailablePerfMetric)(nil)).Elem()
}

type QueryAvailablePerfMetricRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Entity     ManagedObjectReference `xml:"entity"`
	BeginTime  *time.Time             `xml:"beginTime"`
	EndTime    *time.Time             `xml:"endTime"`
	IntervalId int                    `xml:"intervalId,omitempty"`
}

func init() {
	t["QueryAvailablePerfMetricRequestType"] = reflect.TypeOf((*QueryAvailablePerfMetricRequestType)(nil)).Elem()
}

type QueryAvailablePerfMetricResponse struct {
	Returnval []PerfMetricId `xml:"returnval,omitempty"`
}

type QueryAvailableSsds QueryAvailableSsdsRequestType

func init() {
	t["QueryAvailableSsds"] = reflect.TypeOf((*QueryAvailableSsds)(nil)).Elem()
}

type QueryAvailableSsdsRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VffsPath string                 `xml:"vffsPath,omitempty"`
}

func init() {
	t["QueryAvailableSsdsRequestType"] = reflect.TypeOf((*QueryAvailableSsdsRequestType)(nil)).Elem()
}

type QueryAvailableSsdsResponse struct {
	Returnval []HostScsiDisk `xml:"returnval,omitempty"`
}

type QueryAvailableTimeZones QueryAvailableTimeZonesRequestType

func init() {
	t["QueryAvailableTimeZones"] = reflect.TypeOf((*QueryAvailableTimeZones)(nil)).Elem()
}

type QueryAvailableTimeZonesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryAvailableTimeZonesRequestType"] = reflect.TypeOf((*QueryAvailableTimeZonesRequestType)(nil)).Elem()
}

type QueryAvailableTimeZonesResponse struct {
	Returnval []HostDateTimeSystemTimeZone `xml:"returnval,omitempty"`
}

type QueryBootDevices QueryBootDevicesRequestType

func init() {
	t["QueryBootDevices"] = reflect.TypeOf((*QueryBootDevices)(nil)).Elem()
}

type QueryBootDevicesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryBootDevicesRequestType"] = reflect.TypeOf((*QueryBootDevicesRequestType)(nil)).Elem()
}

type QueryBootDevicesResponse struct {
	Returnval *HostBootDeviceInfo `xml:"returnval,omitempty"`
}

type QueryBoundVnics QueryBoundVnicsRequestType

func init() {
	t["QueryBoundVnics"] = reflect.TypeOf((*QueryBoundVnics)(nil)).Elem()
}

type QueryBoundVnicsRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	IScsiHbaName string                 `xml:"iScsiHbaName"`
}

func init() {
	t["QueryBoundVnicsRequestType"] = reflect.TypeOf((*QueryBoundVnicsRequestType)(nil)).Elem()
}

type QueryBoundVnicsResponse struct {
	Returnval []IscsiPortInfo `xml:"returnval,omitempty"`
}

type QueryCandidateNics QueryCandidateNicsRequestType

func init() {
	t["QueryCandidateNics"] = reflect.TypeOf((*QueryCandidateNics)(nil)).Elem()
}

type QueryCandidateNicsRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	IScsiHbaName string                 `xml:"iScsiHbaName"`
}

func init() {
	t["QueryCandidateNicsRequestType"] = reflect.TypeOf((*QueryCandidateNicsRequestType)(nil)).Elem()
}

type QueryCandidateNicsResponse struct {
	Returnval []IscsiPortInfo `xml:"returnval,omitempty"`
}

type QueryChangedDiskAreas QueryChangedDiskAreasRequestType

func init() {
	t["QueryChangedDiskAreas"] = reflect.TypeOf((*QueryChangedDiskAreas)(nil)).Elem()
}

type QueryChangedDiskAreasRequestType struct {
	This        ManagedObjectReference  `xml:"_this"`
	Snapshot    *ManagedObjectReference `xml:"snapshot,omitempty"`
	DeviceKey   int                     `xml:"deviceKey"`
	StartOffset int64                   `xml:"startOffset"`
	ChangeId    string                  `xml:"changeId"`
}

func init() {
	t["QueryChangedDiskAreasRequestType"] = reflect.TypeOf((*QueryChangedDiskAreasRequestType)(nil)).Elem()
}

type QueryChangedDiskAreasResponse struct {
	Returnval DiskChangeInfo `xml:"returnval"`
}

type QueryCmmds QueryCmmdsRequestType

func init() {
	t["QueryCmmds"] = reflect.TypeOf((*QueryCmmds)(nil)).Elem()
}

type QueryCmmdsRequestType struct {
	This    ManagedObjectReference             `xml:"_this"`
	Queries []HostVsanInternalSystemCmmdsQuery `xml:"queries"`
}

func init() {
	t["QueryCmmdsRequestType"] = reflect.TypeOf((*QueryCmmdsRequestType)(nil)).Elem()
}

type QueryCmmdsResponse struct {
	Returnval string `xml:"returnval"`
}

type QueryCompatibleHostForExistingDvs QueryCompatibleHostForExistingDvsRequestType

func init() {
	t["QueryCompatibleHostForExistingDvs"] = reflect.TypeOf((*QueryCompatibleHostForExistingDvs)(nil)).Elem()
}

type QueryCompatibleHostForExistingDvsRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Container ManagedObjectReference `xml:"container"`
	Recursive bool                   `xml:"recursive"`
	Dvs       ManagedObjectReference `xml:"dvs"`
}

func init() {
	t["QueryCompatibleHostForExistingDvsRequestType"] = reflect.TypeOf((*QueryCompatibleHostForExistingDvsRequestType)(nil)).Elem()
}

type QueryCompatibleHostForExistingDvsResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type QueryCompatibleHostForNewDvs QueryCompatibleHostForNewDvsRequestType

func init() {
	t["QueryCompatibleHostForNewDvs"] = reflect.TypeOf((*QueryCompatibleHostForNewDvs)(nil)).Elem()
}

type QueryCompatibleHostForNewDvsRequestType struct {
	This              ManagedObjectReference               `xml:"_this"`
	Container         ManagedObjectReference               `xml:"container"`
	Recursive         bool                                 `xml:"recursive"`
	SwitchProductSpec *DistributedVirtualSwitchProductSpec `xml:"switchProductSpec,omitempty"`
}

func init() {
	t["QueryCompatibleHostForNewDvsRequestType"] = reflect.TypeOf((*QueryCompatibleHostForNewDvsRequestType)(nil)).Elem()
}

type QueryCompatibleHostForNewDvsResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type QueryComplianceStatus QueryComplianceStatusRequestType

func init() {
	t["QueryComplianceStatus"] = reflect.TypeOf((*QueryComplianceStatus)(nil)).Elem()
}

type QueryComplianceStatusRequestType struct {
	This    ManagedObjectReference   `xml:"_this"`
	Profile []ManagedObjectReference `xml:"profile,omitempty"`
	Entity  []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["QueryComplianceStatusRequestType"] = reflect.TypeOf((*QueryComplianceStatusRequestType)(nil)).Elem()
}

type QueryComplianceStatusResponse struct {
	Returnval []ComplianceResult `xml:"returnval,omitempty"`
}

type QueryConfigOption QueryConfigOptionRequestType

func init() {
	t["QueryConfigOption"] = reflect.TypeOf((*QueryConfigOption)(nil)).Elem()
}

type QueryConfigOptionDescriptor QueryConfigOptionDescriptorRequestType

func init() {
	t["QueryConfigOptionDescriptor"] = reflect.TypeOf((*QueryConfigOptionDescriptor)(nil)).Elem()
}

type QueryConfigOptionDescriptorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryConfigOptionDescriptorRequestType"] = reflect.TypeOf((*QueryConfigOptionDescriptorRequestType)(nil)).Elem()
}

type QueryConfigOptionDescriptorResponse struct {
	Returnval []VirtualMachineConfigOptionDescriptor `xml:"returnval,omitempty"`
}

type QueryConfigOptionRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Key  string                  `xml:"key,omitempty"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["QueryConfigOptionRequestType"] = reflect.TypeOf((*QueryConfigOptionRequestType)(nil)).Elem()
}

type QueryConfigOptionResponse struct {
	Returnval *VirtualMachineConfigOption `xml:"returnval,omitempty"`
}

type QueryConfigTarget QueryConfigTargetRequestType

func init() {
	t["QueryConfigTarget"] = reflect.TypeOf((*QueryConfigTarget)(nil)).Elem()
}

type QueryConfigTargetRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["QueryConfigTargetRequestType"] = reflect.TypeOf((*QueryConfigTargetRequestType)(nil)).Elem()
}

type QueryConfigTargetResponse struct {
	Returnval *ConfigTarget `xml:"returnval,omitempty"`
}

type QueryConfiguredModuleOptionString QueryConfiguredModuleOptionStringRequestType

func init() {
	t["QueryConfiguredModuleOptionString"] = reflect.TypeOf((*QueryConfiguredModuleOptionString)(nil)).Elem()
}

type QueryConfiguredModuleOptionStringRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["QueryConfiguredModuleOptionStringRequestType"] = reflect.TypeOf((*QueryConfiguredModuleOptionStringRequestType)(nil)).Elem()
}

type QueryConfiguredModuleOptionStringResponse struct {
	Returnval string `xml:"returnval"`
}

type QueryConnectionInfo QueryConnectionInfoRequestType

func init() {
	t["QueryConnectionInfo"] = reflect.TypeOf((*QueryConnectionInfo)(nil)).Elem()
}

type QueryConnectionInfoRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	Hostname      string                 `xml:"hostname"`
	Port          int                    `xml:"port"`
	Username      string                 `xml:"username"`
	Password      string                 `xml:"password"`
	SslThumbprint string                 `xml:"sslThumbprint,omitempty"`
}

func init() {
	t["QueryConnectionInfoRequestType"] = reflect.TypeOf((*QueryConnectionInfoRequestType)(nil)).Elem()
}

type QueryConnectionInfoResponse struct {
	Returnval HostConnectInfo `xml:"returnval"`
}

type QueryDatastorePerformanceSummary QueryDatastorePerformanceSummaryRequestType

func init() {
	t["QueryDatastorePerformanceSummary"] = reflect.TypeOf((*QueryDatastorePerformanceSummary)(nil)).Elem()
}

type QueryDatastorePerformanceSummaryRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["QueryDatastorePerformanceSummaryRequestType"] = reflect.TypeOf((*QueryDatastorePerformanceSummaryRequestType)(nil)).Elem()
}

type QueryDatastorePerformanceSummaryResponse struct {
	Returnval []StoragePerformanceSummary `xml:"returnval,omitempty"`
}

type QueryDateTime QueryDateTimeRequestType

func init() {
	t["QueryDateTime"] = reflect.TypeOf((*QueryDateTime)(nil)).Elem()
}

type QueryDateTimeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryDateTimeRequestType"] = reflect.TypeOf((*QueryDateTimeRequestType)(nil)).Elem()
}

type QueryDateTimeResponse struct {
	Returnval time.Time `xml:"returnval"`
}

type QueryDescriptions QueryDescriptionsRequestType

func init() {
	t["QueryDescriptions"] = reflect.TypeOf((*QueryDescriptions)(nil)).Elem()
}

type QueryDescriptionsRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["QueryDescriptionsRequestType"] = reflect.TypeOf((*QueryDescriptionsRequestType)(nil)).Elem()
}

type QueryDescriptionsResponse struct {
	Returnval []DiagnosticManagerLogDescriptor `xml:"returnval,omitempty"`
}

type QueryDisksForVsan QueryDisksForVsanRequestType

func init() {
	t["QueryDisksForVsan"] = reflect.TypeOf((*QueryDisksForVsan)(nil)).Elem()
}

type QueryDisksForVsanRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	CanonicalName []string               `xml:"canonicalName,omitempty"`
}

func init() {
	t["QueryDisksForVsanRequestType"] = reflect.TypeOf((*QueryDisksForVsanRequestType)(nil)).Elem()
}

type QueryDisksForVsanResponse struct {
	Returnval []VsanHostDiskResult `xml:"returnval,omitempty"`
}

type QueryDvsByUuid QueryDvsByUuidRequestType

func init() {
	t["QueryDvsByUuid"] = reflect.TypeOf((*QueryDvsByUuid)(nil)).Elem()
}

type QueryDvsByUuidRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Uuid string                 `xml:"uuid"`
}

func init() {
	t["QueryDvsByUuidRequestType"] = reflect.TypeOf((*QueryDvsByUuidRequestType)(nil)).Elem()
}

type QueryDvsByUuidResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type QueryDvsCheckCompatibility QueryDvsCheckCompatibilityRequestType

func init() {
	t["QueryDvsCheckCompatibility"] = reflect.TypeOf((*QueryDvsCheckCompatibility)(nil)).Elem()
}

type QueryDvsCheckCompatibilityRequestType struct {
	This           ManagedObjectReference                                 `xml:"_this"`
	HostContainer  DistributedVirtualSwitchManagerHostContainer           `xml:"hostContainer"`
	DvsProductSpec *DistributedVirtualSwitchManagerDvsProductSpec         `xml:"dvsProductSpec,omitempty"`
	HostFilterSpec []BaseDistributedVirtualSwitchManagerHostDvsFilterSpec `xml:"hostFilterSpec,omitempty,typeattr"`
}

func init() {
	t["QueryDvsCheckCompatibilityRequestType"] = reflect.TypeOf((*QueryDvsCheckCompatibilityRequestType)(nil)).Elem()
}

type QueryDvsCheckCompatibilityResponse struct {
	Returnval []DistributedVirtualSwitchManagerCompatibilityResult `xml:"returnval,omitempty"`
}

type QueryDvsCompatibleHostSpec QueryDvsCompatibleHostSpecRequestType

func init() {
	t["QueryDvsCompatibleHostSpec"] = reflect.TypeOf((*QueryDvsCompatibleHostSpec)(nil)).Elem()
}

type QueryDvsCompatibleHostSpecRequestType struct {
	This              ManagedObjectReference               `xml:"_this"`
	SwitchProductSpec *DistributedVirtualSwitchProductSpec `xml:"switchProductSpec,omitempty"`
}

func init() {
	t["QueryDvsCompatibleHostSpecRequestType"] = reflect.TypeOf((*QueryDvsCompatibleHostSpecRequestType)(nil)).Elem()
}

type QueryDvsCompatibleHostSpecResponse struct {
	Returnval []DistributedVirtualSwitchHostProductSpec `xml:"returnval,omitempty"`
}

type QueryDvsConfigTarget QueryDvsConfigTargetRequestType

func init() {
	t["QueryDvsConfigTarget"] = reflect.TypeOf((*QueryDvsConfigTarget)(nil)).Elem()
}

type QueryDvsConfigTargetRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
	Dvs  *ManagedObjectReference `xml:"dvs,omitempty"`
}

func init() {
	t["QueryDvsConfigTargetRequestType"] = reflect.TypeOf((*QueryDvsConfigTargetRequestType)(nil)).Elem()
}

type QueryDvsConfigTargetResponse struct {
	Returnval DVSManagerDvsConfigTarget `xml:"returnval"`
}

type QueryDvsFeatureCapability QueryDvsFeatureCapabilityRequestType

func init() {
	t["QueryDvsFeatureCapability"] = reflect.TypeOf((*QueryDvsFeatureCapability)(nil)).Elem()
}

type QueryDvsFeatureCapabilityRequestType struct {
	This              ManagedObjectReference               `xml:"_this"`
	SwitchProductSpec *DistributedVirtualSwitchProductSpec `xml:"switchProductSpec,omitempty"`
}

func init() {
	t["QueryDvsFeatureCapabilityRequestType"] = reflect.TypeOf((*QueryDvsFeatureCapabilityRequestType)(nil)).Elem()
}

type QueryDvsFeatureCapabilityResponse struct {
	Returnval BaseDVSFeatureCapability `xml:"returnval,omitempty,typeattr"`
}

type QueryEvents QueryEventsRequestType

func init() {
	t["QueryEvents"] = reflect.TypeOf((*QueryEvents)(nil)).Elem()
}

type QueryEventsRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Filter EventFilterSpec        `xml:"filter"`
}

func init() {
	t["QueryEventsRequestType"] = reflect.TypeOf((*QueryEventsRequestType)(nil)).Elem()
}

type QueryEventsResponse struct {
	Returnval []BaseEvent `xml:"returnval,omitempty,typeattr"`
}

type QueryExpressionMetadata QueryExpressionMetadataRequestType

func init() {
	t["QueryExpressionMetadata"] = reflect.TypeOf((*QueryExpressionMetadata)(nil)).Elem()
}

type QueryExpressionMetadataRequestType struct {
	This           ManagedObjectReference  `xml:"_this"`
	ExpressionName []string                `xml:"expressionName,omitempty"`
	Profile        *ManagedObjectReference `xml:"profile,omitempty"`
}

func init() {
	t["QueryExpressionMetadataRequestType"] = reflect.TypeOf((*QueryExpressionMetadataRequestType)(nil)).Elem()
}

type QueryExpressionMetadataResponse struct {
	Returnval []ProfileExpressionMetadata `xml:"returnval,omitempty"`
}

type QueryExtensionIpAllocationUsage QueryExtensionIpAllocationUsageRequestType

func init() {
	t["QueryExtensionIpAllocationUsage"] = reflect.TypeOf((*QueryExtensionIpAllocationUsage)(nil)).Elem()
}

type QueryExtensionIpAllocationUsageRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	ExtensionKeys []string               `xml:"extensionKeys,omitempty"`
}

func init() {
	t["QueryExtensionIpAllocationUsageRequestType"] = reflect.TypeOf((*QueryExtensionIpAllocationUsageRequestType)(nil)).Elem()
}

type QueryExtensionIpAllocationUsageResponse struct {
	Returnval []ExtensionManagerIpAllocationUsage `xml:"returnval,omitempty"`
}

type QueryFaultToleranceCompatibility QueryFaultToleranceCompatibilityRequestType

func init() {
	t["QueryFaultToleranceCompatibility"] = reflect.TypeOf((*QueryFaultToleranceCompatibility)(nil)).Elem()
}

type QueryFaultToleranceCompatibilityRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryFaultToleranceCompatibilityRequestType"] = reflect.TypeOf((*QueryFaultToleranceCompatibilityRequestType)(nil)).Elem()
}

type QueryFaultToleranceCompatibilityResponse struct {
	Returnval []LocalizedMethodFault `xml:"returnval,omitempty"`
}

type QueryFirmwareConfigUploadURL QueryFirmwareConfigUploadURLRequestType

func init() {
	t["QueryFirmwareConfigUploadURL"] = reflect.TypeOf((*QueryFirmwareConfigUploadURL)(nil)).Elem()
}

type QueryFirmwareConfigUploadURLRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryFirmwareConfigUploadURLRequestType"] = reflect.TypeOf((*QueryFirmwareConfigUploadURLRequestType)(nil)).Elem()
}

type QueryFirmwareConfigUploadURLResponse struct {
	Returnval string `xml:"returnval"`
}

type QueryHostConnectionInfo QueryHostConnectionInfoRequestType

func init() {
	t["QueryHostConnectionInfo"] = reflect.TypeOf((*QueryHostConnectionInfo)(nil)).Elem()
}

type QueryHostConnectionInfoRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryHostConnectionInfoRequestType"] = reflect.TypeOf((*QueryHostConnectionInfoRequestType)(nil)).Elem()
}

type QueryHostConnectionInfoResponse struct {
	Returnval HostConnectInfo `xml:"returnval"`
}

type QueryHostPatchRequestType struct {
	This ManagedObjectReference                     `xml:"_this"`
	Spec *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty"`
}

func init() {
	t["QueryHostPatchRequestType"] = reflect.TypeOf((*QueryHostPatchRequestType)(nil)).Elem()
}

type QueryHostPatch_Task QueryHostPatchRequestType

func init() {
	t["QueryHostPatch_Task"] = reflect.TypeOf((*QueryHostPatch_Task)(nil)).Elem()
}

type QueryHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type QueryHostProfileMetadata QueryHostProfileMetadataRequestType

func init() {
	t["QueryHostProfileMetadata"] = reflect.TypeOf((*QueryHostProfileMetadata)(nil)).Elem()
}

type QueryHostProfileMetadataRequestType struct {
	This        ManagedObjectReference  `xml:"_this"`
	ProfileName []string                `xml:"profileName,omitempty"`
	Profile     *ManagedObjectReference `xml:"profile,omitempty"`
}

func init() {
	t["QueryHostProfileMetadataRequestType"] = reflect.TypeOf((*QueryHostProfileMetadataRequestType)(nil)).Elem()
}

type QueryHostProfileMetadataResponse struct {
	Returnval []ProfileMetadata `xml:"returnval,omitempty"`
}

type QueryHostStatus QueryHostStatusRequestType

func init() {
	t["QueryHostStatus"] = reflect.TypeOf((*QueryHostStatus)(nil)).Elem()
}

type QueryHostStatusRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryHostStatusRequestType"] = reflect.TypeOf((*QueryHostStatusRequestType)(nil)).Elem()
}

type QueryHostStatusResponse struct {
	Returnval VsanHostClusterStatus `xml:"returnval"`
}

type QueryIORMConfigOption QueryIORMConfigOptionRequestType

func init() {
	t["QueryIORMConfigOption"] = reflect.TypeOf((*QueryIORMConfigOption)(nil)).Elem()
}

type QueryIORMConfigOptionRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["QueryIORMConfigOptionRequestType"] = reflect.TypeOf((*QueryIORMConfigOptionRequestType)(nil)).Elem()
}

type QueryIORMConfigOptionResponse struct {
	Returnval StorageIORMConfigOption `xml:"returnval"`
}

type QueryIPAllocations QueryIPAllocationsRequestType

func init() {
	t["QueryIPAllocations"] = reflect.TypeOf((*QueryIPAllocations)(nil)).Elem()
}

type QueryIPAllocationsRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Dc           ManagedObjectReference `xml:"dc"`
	PoolId       int                    `xml:"poolId"`
	ExtensionKey string                 `xml:"extensionKey"`
}

func init() {
	t["QueryIPAllocationsRequestType"] = reflect.TypeOf((*QueryIPAllocationsRequestType)(nil)).Elem()
}

type QueryIPAllocationsResponse struct {
	Returnval []IpPoolManagerIpAllocation `xml:"returnval"`
}

type QueryIpPools QueryIpPoolsRequestType

func init() {
	t["QueryIpPools"] = reflect.TypeOf((*QueryIpPools)(nil)).Elem()
}

type QueryIpPoolsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Dc   ManagedObjectReference `xml:"dc"`
}

func init() {
	t["QueryIpPoolsRequestType"] = reflect.TypeOf((*QueryIpPoolsRequestType)(nil)).Elem()
}

type QueryIpPoolsResponse struct {
	Returnval []IpPool `xml:"returnval,omitempty"`
}

type QueryLicenseSourceAvailability QueryLicenseSourceAvailabilityRequestType

func init() {
	t["QueryLicenseSourceAvailability"] = reflect.TypeOf((*QueryLicenseSourceAvailability)(nil)).Elem()
}

type QueryLicenseSourceAvailabilityRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["QueryLicenseSourceAvailabilityRequestType"] = reflect.TypeOf((*QueryLicenseSourceAvailabilityRequestType)(nil)).Elem()
}

type QueryLicenseSourceAvailabilityResponse struct {
	Returnval []LicenseAvailabilityInfo `xml:"returnval,omitempty"`
}

type QueryLicenseUsage QueryLicenseUsageRequestType

func init() {
	t["QueryLicenseUsage"] = reflect.TypeOf((*QueryLicenseUsage)(nil)).Elem()
}

type QueryLicenseUsageRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["QueryLicenseUsageRequestType"] = reflect.TypeOf((*QueryLicenseUsageRequestType)(nil)).Elem()
}

type QueryLicenseUsageResponse struct {
	Returnval LicenseUsageInfo `xml:"returnval"`
}

type QueryManagedBy QueryManagedByRequestType

func init() {
	t["QueryManagedBy"] = reflect.TypeOf((*QueryManagedBy)(nil)).Elem()
}

type QueryManagedByRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
}

func init() {
	t["QueryManagedByRequestType"] = reflect.TypeOf((*QueryManagedByRequestType)(nil)).Elem()
}

type QueryManagedByResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type QueryMemoryOverhead QueryMemoryOverheadRequestType

func init() {
	t["QueryMemoryOverhead"] = reflect.TypeOf((*QueryMemoryOverhead)(nil)).Elem()
}

type QueryMemoryOverheadEx QueryMemoryOverheadExRequestType

func init() {
	t["QueryMemoryOverheadEx"] = reflect.TypeOf((*QueryMemoryOverheadEx)(nil)).Elem()
}

type QueryMemoryOverheadExRequestType struct {
	This         ManagedObjectReference   `xml:"_this"`
	VmConfigInfo VirtualMachineConfigInfo `xml:"vmConfigInfo"`
}

func init() {
	t["QueryMemoryOverheadExRequestType"] = reflect.TypeOf((*QueryMemoryOverheadExRequestType)(nil)).Elem()
}

type QueryMemoryOverheadExResponse struct {
	Returnval int64 `xml:"returnval"`
}

type QueryMemoryOverheadRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	MemorySize   int64                  `xml:"memorySize"`
	VideoRamSize int                    `xml:"videoRamSize,omitempty"`
	NumVcpus     int                    `xml:"numVcpus"`
}

func init() {
	t["QueryMemoryOverheadRequestType"] = reflect.TypeOf((*QueryMemoryOverheadRequestType)(nil)).Elem()
}

type QueryMemoryOverheadResponse struct {
	Returnval int64 `xml:"returnval"`
}

type QueryMigrationDependencies QueryMigrationDependenciesRequestType

func init() {
	t["QueryMigrationDependencies"] = reflect.TypeOf((*QueryMigrationDependencies)(nil)).Elem()
}

type QueryMigrationDependenciesRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	PnicDevice []string               `xml:"pnicDevice"`
}

func init() {
	t["QueryMigrationDependenciesRequestType"] = reflect.TypeOf((*QueryMigrationDependenciesRequestType)(nil)).Elem()
}

type QueryMigrationDependenciesResponse struct {
	Returnval IscsiMigrationDependency `xml:"returnval"`
}

type QueryModules QueryModulesRequestType

func init() {
	t["QueryModules"] = reflect.TypeOf((*QueryModules)(nil)).Elem()
}

type QueryModulesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryModulesRequestType"] = reflect.TypeOf((*QueryModulesRequestType)(nil)).Elem()
}

type QueryModulesResponse struct {
	Returnval []KernelModuleInfo `xml:"returnval,omitempty"`
}

type QueryNetConfig QueryNetConfigRequestType

func init() {
	t["QueryNetConfig"] = reflect.TypeOf((*QueryNetConfig)(nil)).Elem()
}

type QueryNetConfigRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	NicType string                 `xml:"nicType"`
}

func init() {
	t["QueryNetConfigRequestType"] = reflect.TypeOf((*QueryNetConfigRequestType)(nil)).Elem()
}

type QueryNetConfigResponse struct {
	Returnval *VirtualNicManagerNetConfig `xml:"returnval,omitempty"`
}

type QueryNetworkHint QueryNetworkHintRequestType

func init() {
	t["QueryNetworkHint"] = reflect.TypeOf((*QueryNetworkHint)(nil)).Elem()
}

type QueryNetworkHintRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Device []string               `xml:"device,omitempty"`
}

func init() {
	t["QueryNetworkHintRequestType"] = reflect.TypeOf((*QueryNetworkHintRequestType)(nil)).Elem()
}

type QueryNetworkHintResponse struct {
	Returnval []PhysicalNicHintInfo `xml:"returnval,omitempty"`
}

type QueryObjectsOnPhysicalVsanDisk QueryObjectsOnPhysicalVsanDiskRequestType

func init() {
	t["QueryObjectsOnPhysicalVsanDisk"] = reflect.TypeOf((*QueryObjectsOnPhysicalVsanDisk)(nil)).Elem()
}

type QueryObjectsOnPhysicalVsanDiskRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Disks []string               `xml:"disks"`
}

func init() {
	t["QueryObjectsOnPhysicalVsanDiskRequestType"] = reflect.TypeOf((*QueryObjectsOnPhysicalVsanDiskRequestType)(nil)).Elem()
}

type QueryObjectsOnPhysicalVsanDiskResponse struct {
	Returnval string `xml:"returnval"`
}

type QueryOptions QueryOptionsRequestType

func init() {
	t["QueryOptions"] = reflect.TypeOf((*QueryOptions)(nil)).Elem()
}

type QueryOptionsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name,omitempty"`
}

func init() {
	t["QueryOptionsRequestType"] = reflect.TypeOf((*QueryOptionsRequestType)(nil)).Elem()
}

type QueryOptionsResponse struct {
	Returnval []BaseOptionValue `xml:"returnval,omitempty,typeattr"`
}

type QueryPartitionCreateDesc QueryPartitionCreateDescRequestType

func init() {
	t["QueryPartitionCreateDesc"] = reflect.TypeOf((*QueryPartitionCreateDesc)(nil)).Elem()
}

type QueryPartitionCreateDescRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	DiskUuid       string                 `xml:"diskUuid"`
	DiagnosticType string                 `xml:"diagnosticType"`
}

func init() {
	t["QueryPartitionCreateDescRequestType"] = reflect.TypeOf((*QueryPartitionCreateDescRequestType)(nil)).Elem()
}

type QueryPartitionCreateDescResponse struct {
	Returnval HostDiagnosticPartitionCreateDescription `xml:"returnval"`
}

type QueryPartitionCreateOptions QueryPartitionCreateOptionsRequestType

func init() {
	t["QueryPartitionCreateOptions"] = reflect.TypeOf((*QueryPartitionCreateOptions)(nil)).Elem()
}

type QueryPartitionCreateOptionsRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	StorageType    string                 `xml:"storageType"`
	DiagnosticType string                 `xml:"diagnosticType"`
}

func init() {
	t["QueryPartitionCreateOptionsRequestType"] = reflect.TypeOf((*QueryPartitionCreateOptionsRequestType)(nil)).Elem()
}

type QueryPartitionCreateOptionsResponse struct {
	Returnval []HostDiagnosticPartitionCreateOption `xml:"returnval,omitempty"`
}

type QueryPathSelectionPolicyOptions QueryPathSelectionPolicyOptionsRequestType

func init() {
	t["QueryPathSelectionPolicyOptions"] = reflect.TypeOf((*QueryPathSelectionPolicyOptions)(nil)).Elem()
}

type QueryPathSelectionPolicyOptionsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryPathSelectionPolicyOptionsRequestType"] = reflect.TypeOf((*QueryPathSelectionPolicyOptionsRequestType)(nil)).Elem()
}

type QueryPathSelectionPolicyOptionsResponse struct {
	Returnval []HostPathSelectionPolicyOption `xml:"returnval,omitempty"`
}

type QueryPerf QueryPerfRequestType

func init() {
	t["QueryPerf"] = reflect.TypeOf((*QueryPerf)(nil)).Elem()
}

type QueryPerfComposite QueryPerfCompositeRequestType

func init() {
	t["QueryPerfComposite"] = reflect.TypeOf((*QueryPerfComposite)(nil)).Elem()
}

type QueryPerfCompositeRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	QuerySpec PerfQuerySpec          `xml:"querySpec"`
}

func init() {
	t["QueryPerfCompositeRequestType"] = reflect.TypeOf((*QueryPerfCompositeRequestType)(nil)).Elem()
}

type QueryPerfCompositeResponse struct {
	Returnval PerfCompositeMetric `xml:"returnval"`
}

type QueryPerfCounter QueryPerfCounterRequestType

func init() {
	t["QueryPerfCounter"] = reflect.TypeOf((*QueryPerfCounter)(nil)).Elem()
}

type QueryPerfCounterByLevel QueryPerfCounterByLevelRequestType

func init() {
	t["QueryPerfCounterByLevel"] = reflect.TypeOf((*QueryPerfCounterByLevel)(nil)).Elem()
}

type QueryPerfCounterByLevelRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Level int                    `xml:"level"`
}

func init() {
	t["QueryPerfCounterByLevelRequestType"] = reflect.TypeOf((*QueryPerfCounterByLevelRequestType)(nil)).Elem()
}

type QueryPerfCounterByLevelResponse struct {
	Returnval []PerfCounterInfo `xml:"returnval"`
}

type QueryPerfCounterRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	CounterId []int                  `xml:"counterId"`
}

func init() {
	t["QueryPerfCounterRequestType"] = reflect.TypeOf((*QueryPerfCounterRequestType)(nil)).Elem()
}

type QueryPerfCounterResponse struct {
	Returnval []PerfCounterInfo `xml:"returnval,omitempty"`
}

type QueryPerfProviderSummary QueryPerfProviderSummaryRequestType

func init() {
	t["QueryPerfProviderSummary"] = reflect.TypeOf((*QueryPerfProviderSummary)(nil)).Elem()
}

type QueryPerfProviderSummaryRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["QueryPerfProviderSummaryRequestType"] = reflect.TypeOf((*QueryPerfProviderSummaryRequestType)(nil)).Elem()
}

type QueryPerfProviderSummaryResponse struct {
	Returnval PerfProviderSummary `xml:"returnval"`
}

type QueryPerfRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	QuerySpec []PerfQuerySpec        `xml:"querySpec"`
}

func init() {
	t["QueryPerfRequestType"] = reflect.TypeOf((*QueryPerfRequestType)(nil)).Elem()
}

type QueryPerfResponse struct {
	Returnval []BasePerfEntityMetricBase `xml:"returnval,omitempty,typeattr"`
}

type QueryPhysicalVsanDisks QueryPhysicalVsanDisksRequestType

func init() {
	t["QueryPhysicalVsanDisks"] = reflect.TypeOf((*QueryPhysicalVsanDisks)(nil)).Elem()
}

type QueryPhysicalVsanDisksRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Props []string               `xml:"props,omitempty"`
}

func init() {
	t["QueryPhysicalVsanDisksRequestType"] = reflect.TypeOf((*QueryPhysicalVsanDisksRequestType)(nil)).Elem()
}

type QueryPhysicalVsanDisksResponse struct {
	Returnval string `xml:"returnval"`
}

type QueryPnicStatus QueryPnicStatusRequestType

func init() {
	t["QueryPnicStatus"] = reflect.TypeOf((*QueryPnicStatus)(nil)).Elem()
}

type QueryPnicStatusRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	PnicDevice string                 `xml:"pnicDevice"`
}

func init() {
	t["QueryPnicStatusRequestType"] = reflect.TypeOf((*QueryPnicStatusRequestType)(nil)).Elem()
}

type QueryPnicStatusResponse struct {
	Returnval IscsiStatus `xml:"returnval"`
}

type QueryPolicyMetadata QueryPolicyMetadataRequestType

func init() {
	t["QueryPolicyMetadata"] = reflect.TypeOf((*QueryPolicyMetadata)(nil)).Elem()
}

type QueryPolicyMetadataRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	PolicyName []string                `xml:"policyName,omitempty"`
	Profile    *ManagedObjectReference `xml:"profile,omitempty"`
}

func init() {
	t["QueryPolicyMetadataRequestType"] = reflect.TypeOf((*QueryPolicyMetadataRequestType)(nil)).Elem()
}

type QueryPolicyMetadataResponse struct {
	Returnval []ProfilePolicyMetadata `xml:"returnval,omitempty"`
}

type QueryProfileStructure QueryProfileStructureRequestType

func init() {
	t["QueryProfileStructure"] = reflect.TypeOf((*QueryProfileStructure)(nil)).Elem()
}

type QueryProfileStructureRequestType struct {
	This    ManagedObjectReference  `xml:"_this"`
	Profile *ManagedObjectReference `xml:"profile,omitempty"`
}

func init() {
	t["QueryProfileStructureRequestType"] = reflect.TypeOf((*QueryProfileStructureRequestType)(nil)).Elem()
}

type QueryProfileStructureResponse struct {
	Returnval ProfileProfileStructure `xml:"returnval"`
}

type QueryResourceConfigOption QueryResourceConfigOptionRequestType

func init() {
	t["QueryResourceConfigOption"] = reflect.TypeOf((*QueryResourceConfigOption)(nil)).Elem()
}

type QueryResourceConfigOptionRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryResourceConfigOptionRequestType"] = reflect.TypeOf((*QueryResourceConfigOptionRequestType)(nil)).Elem()
}

type QueryResourceConfigOptionResponse struct {
	Returnval ResourceConfigOption `xml:"returnval"`
}

type QueryServiceList QueryServiceListRequestType

func init() {
	t["QueryServiceList"] = reflect.TypeOf((*QueryServiceList)(nil)).Elem()
}

type QueryServiceListRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	ServiceName string                 `xml:"serviceName,omitempty"`
	Location    []string               `xml:"location,omitempty"`
}

func init() {
	t["QueryServiceListRequestType"] = reflect.TypeOf((*QueryServiceListRequestType)(nil)).Elem()
}

type QueryServiceListResponse struct {
	Returnval []ServiceManagerServiceInfo `xml:"returnval,omitempty"`
}

type QueryStorageArrayTypePolicyOptions QueryStorageArrayTypePolicyOptionsRequestType

func init() {
	t["QueryStorageArrayTypePolicyOptions"] = reflect.TypeOf((*QueryStorageArrayTypePolicyOptions)(nil)).Elem()
}

type QueryStorageArrayTypePolicyOptionsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryStorageArrayTypePolicyOptionsRequestType"] = reflect.TypeOf((*QueryStorageArrayTypePolicyOptionsRequestType)(nil)).Elem()
}

type QueryStorageArrayTypePolicyOptionsResponse struct {
	Returnval []HostStorageArrayTypePolicyOption `xml:"returnval,omitempty"`
}

type QuerySupportedFeatures QuerySupportedFeaturesRequestType

func init() {
	t["QuerySupportedFeatures"] = reflect.TypeOf((*QuerySupportedFeatures)(nil)).Elem()
}

type QuerySupportedFeaturesRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["QuerySupportedFeaturesRequestType"] = reflect.TypeOf((*QuerySupportedFeaturesRequestType)(nil)).Elem()
}

type QuerySupportedFeaturesResponse struct {
	Returnval []LicenseFeatureInfo `xml:"returnval,omitempty"`
}

type QueryTargetCapabilities QueryTargetCapabilitiesRequestType

func init() {
	t["QueryTargetCapabilities"] = reflect.TypeOf((*QueryTargetCapabilities)(nil)).Elem()
}

type QueryTargetCapabilitiesRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["QueryTargetCapabilitiesRequestType"] = reflect.TypeOf((*QueryTargetCapabilitiesRequestType)(nil)).Elem()
}

type QueryTargetCapabilitiesResponse struct {
	Returnval *HostCapability `xml:"returnval,omitempty"`
}

type QueryTpmAttestationReport QueryTpmAttestationReportRequestType

func init() {
	t["QueryTpmAttestationReport"] = reflect.TypeOf((*QueryTpmAttestationReport)(nil)).Elem()
}

type QueryTpmAttestationReportRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryTpmAttestationReportRequestType"] = reflect.TypeOf((*QueryTpmAttestationReportRequestType)(nil)).Elem()
}

type QueryTpmAttestationReportResponse struct {
	Returnval *HostTpmAttestationReport `xml:"returnval,omitempty"`
}

type QueryUnownedFiles QueryUnownedFilesRequestType

func init() {
	t["QueryUnownedFiles"] = reflect.TypeOf((*QueryUnownedFiles)(nil)).Elem()
}

type QueryUnownedFilesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryUnownedFilesRequestType"] = reflect.TypeOf((*QueryUnownedFilesRequestType)(nil)).Elem()
}

type QueryUnownedFilesResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type QueryUnresolvedVmfsVolume QueryUnresolvedVmfsVolumeRequestType

func init() {
	t["QueryUnresolvedVmfsVolume"] = reflect.TypeOf((*QueryUnresolvedVmfsVolume)(nil)).Elem()
}

type QueryUnresolvedVmfsVolumeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryUnresolvedVmfsVolumeRequestType"] = reflect.TypeOf((*QueryUnresolvedVmfsVolumeRequestType)(nil)).Elem()
}

type QueryUnresolvedVmfsVolumeResponse struct {
	Returnval []HostUnresolvedVmfsVolume `xml:"returnval,omitempty"`
}

type QueryUnresolvedVmfsVolumes QueryUnresolvedVmfsVolumesRequestType

func init() {
	t["QueryUnresolvedVmfsVolumes"] = reflect.TypeOf((*QueryUnresolvedVmfsVolumes)(nil)).Elem()
}

type QueryUnresolvedVmfsVolumesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryUnresolvedVmfsVolumesRequestType"] = reflect.TypeOf((*QueryUnresolvedVmfsVolumesRequestType)(nil)).Elem()
}

type QueryUnresolvedVmfsVolumesResponse struct {
	Returnval []HostUnresolvedVmfsVolume `xml:"returnval,omitempty"`
}

type QueryUsedVlanIdInDvs QueryUsedVlanIdInDvsRequestType

func init() {
	t["QueryUsedVlanIdInDvs"] = reflect.TypeOf((*QueryUsedVlanIdInDvs)(nil)).Elem()
}

type QueryUsedVlanIdInDvsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["QueryUsedVlanIdInDvsRequestType"] = reflect.TypeOf((*QueryUsedVlanIdInDvsRequestType)(nil)).Elem()
}

type QueryUsedVlanIdInDvsResponse struct {
	Returnval []int `xml:"returnval,omitempty"`
}

type QueryVMotionCompatibility QueryVMotionCompatibilityRequestType

func init() {
	t["QueryVMotionCompatibility"] = reflect.TypeOf((*QueryVMotionCompatibility)(nil)).Elem()
}

type QueryVMotionCompatibilityExRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Vm   []ManagedObjectReference `xml:"vm"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["QueryVMotionCompatibilityExRequestType"] = reflect.TypeOf((*QueryVMotionCompatibilityExRequestType)(nil)).Elem()
}

type QueryVMotionCompatibilityEx_Task QueryVMotionCompatibilityExRequestType

func init() {
	t["QueryVMotionCompatibilityEx_Task"] = reflect.TypeOf((*QueryVMotionCompatibilityEx_Task)(nil)).Elem()
}

type QueryVMotionCompatibilityEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type QueryVMotionCompatibilityRequestType struct {
	This          ManagedObjectReference   `xml:"_this"`
	Vm            ManagedObjectReference   `xml:"vm"`
	Host          []ManagedObjectReference `xml:"host"`
	Compatibility []string                 `xml:"compatibility,omitempty"`
}

func init() {
	t["QueryVMotionCompatibilityRequestType"] = reflect.TypeOf((*QueryVMotionCompatibilityRequestType)(nil)).Elem()
}

type QueryVMotionCompatibilityResponse struct {
	Returnval []HostVMotionCompatibility `xml:"returnval,omitempty"`
}

type QueryVirtualDiskFragmentation QueryVirtualDiskFragmentationRequestType

func init() {
	t["QueryVirtualDiskFragmentation"] = reflect.TypeOf((*QueryVirtualDiskFragmentation)(nil)).Elem()
}

type QueryVirtualDiskFragmentationRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["QueryVirtualDiskFragmentationRequestType"] = reflect.TypeOf((*QueryVirtualDiskFragmentationRequestType)(nil)).Elem()
}

type QueryVirtualDiskFragmentationResponse struct {
	Returnval int `xml:"returnval"`
}

type QueryVirtualDiskGeometry QueryVirtualDiskGeometryRequestType

func init() {
	t["QueryVirtualDiskGeometry"] = reflect.TypeOf((*QueryVirtualDiskGeometry)(nil)).Elem()
}

type QueryVirtualDiskGeometryRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["QueryVirtualDiskGeometryRequestType"] = reflect.TypeOf((*QueryVirtualDiskGeometryRequestType)(nil)).Elem()
}

type QueryVirtualDiskGeometryResponse struct {
	Returnval HostDiskDimensionsChs `xml:"returnval"`
}

type QueryVirtualDiskUuid QueryVirtualDiskUuidRequestType

func init() {
	t["QueryVirtualDiskUuid"] = reflect.TypeOf((*QueryVirtualDiskUuid)(nil)).Elem()
}

type QueryVirtualDiskUuidRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["QueryVirtualDiskUuidRequestType"] = reflect.TypeOf((*QueryVirtualDiskUuidRequestType)(nil)).Elem()
}

type QueryVirtualDiskUuidResponse struct {
	Returnval string `xml:"returnval"`
}

type QueryVmfsDatastoreCreateOptions QueryVmfsDatastoreCreateOptionsRequestType

func init() {
	t["QueryVmfsDatastoreCreateOptions"] = reflect.TypeOf((*QueryVmfsDatastoreCreateOptions)(nil)).Elem()
}

type QueryVmfsDatastoreCreateOptionsRequestType struct {
	This             ManagedObjectReference `xml:"_this"`
	DevicePath       string                 `xml:"devicePath"`
	VmfsMajorVersion int                    `xml:"vmfsMajorVersion,omitempty"`
}

func init() {
	t["QueryVmfsDatastoreCreateOptionsRequestType"] = reflect.TypeOf((*QueryVmfsDatastoreCreateOptionsRequestType)(nil)).Elem()
}

type QueryVmfsDatastoreCreateOptionsResponse struct {
	Returnval []VmfsDatastoreOption `xml:"returnval,omitempty"`
}

type QueryVmfsDatastoreExpandOptions QueryVmfsDatastoreExpandOptionsRequestType

func init() {
	t["QueryVmfsDatastoreExpandOptions"] = reflect.TypeOf((*QueryVmfsDatastoreExpandOptions)(nil)).Elem()
}

type QueryVmfsDatastoreExpandOptionsRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["QueryVmfsDatastoreExpandOptionsRequestType"] = reflect.TypeOf((*QueryVmfsDatastoreExpandOptionsRequestType)(nil)).Elem()
}

type QueryVmfsDatastoreExpandOptionsResponse struct {
	Returnval []VmfsDatastoreOption `xml:"returnval,omitempty"`
}

type QueryVmfsDatastoreExtendOptions QueryVmfsDatastoreExtendOptionsRequestType

func init() {
	t["QueryVmfsDatastoreExtendOptions"] = reflect.TypeOf((*QueryVmfsDatastoreExtendOptions)(nil)).Elem()
}

type QueryVmfsDatastoreExtendOptionsRequestType struct {
	This                     ManagedObjectReference `xml:"_this"`
	Datastore                ManagedObjectReference `xml:"datastore"`
	DevicePath               string                 `xml:"devicePath"`
	SuppressExpandCandidates *bool                  `xml:"suppressExpandCandidates"`
}

func init() {
	t["QueryVmfsDatastoreExtendOptionsRequestType"] = reflect.TypeOf((*QueryVmfsDatastoreExtendOptionsRequestType)(nil)).Elem()
}

type QueryVmfsDatastoreExtendOptionsResponse struct {
	Returnval []VmfsDatastoreOption `xml:"returnval,omitempty"`
}

type QueryVnicStatus QueryVnicStatusRequestType

func init() {
	t["QueryVnicStatus"] = reflect.TypeOf((*QueryVnicStatus)(nil)).Elem()
}

type QueryVnicStatusRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	VnicDevice string                 `xml:"vnicDevice"`
}

func init() {
	t["QueryVnicStatusRequestType"] = reflect.TypeOf((*QueryVnicStatusRequestType)(nil)).Elem()
}

type QueryVnicStatusResponse struct {
	Returnval IscsiStatus `xml:"returnval"`
}

type QueryVsanObjects QueryVsanObjectsRequestType

func init() {
	t["QueryVsanObjects"] = reflect.TypeOf((*QueryVsanObjects)(nil)).Elem()
}

type QueryVsanObjectsRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Uuids []string               `xml:"uuids,omitempty"`
}

func init() {
	t["QueryVsanObjectsRequestType"] = reflect.TypeOf((*QueryVsanObjectsRequestType)(nil)).Elem()
}

type QueryVsanObjectsResponse struct {
	Returnval string `xml:"returnval"`
}

type QuestionPending struct {
	InvalidState

	Text string `xml:"text"`
}

func init() {
	t["QuestionPending"] = reflect.TypeOf((*QuestionPending)(nil)).Elem()
}

type QuestionPendingFault QuestionPending

func init() {
	t["QuestionPendingFault"] = reflect.TypeOf((*QuestionPendingFault)(nil)).Elem()
}

type QuiesceDatastoreIOForHAFailed struct {
	ResourceInUse

	Host     ManagedObjectReference `xml:"host"`
	HostName string                 `xml:"hostName"`
	Ds       ManagedObjectReference `xml:"ds"`
	DsName   string                 `xml:"dsName"`
}

func init() {
	t["QuiesceDatastoreIOForHAFailed"] = reflect.TypeOf((*QuiesceDatastoreIOForHAFailed)(nil)).Elem()
}

type QuiesceDatastoreIOForHAFailedFault QuiesceDatastoreIOForHAFailed

func init() {
	t["QuiesceDatastoreIOForHAFailedFault"] = reflect.TypeOf((*QuiesceDatastoreIOForHAFailedFault)(nil)).Elem()
}

type RDMConversionNotSupported struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["RDMConversionNotSupported"] = reflect.TypeOf((*RDMConversionNotSupported)(nil)).Elem()
}

type RDMConversionNotSupportedFault RDMConversionNotSupported

func init() {
	t["RDMConversionNotSupportedFault"] = reflect.TypeOf((*RDMConversionNotSupportedFault)(nil)).Elem()
}

type RDMNotPreserved struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["RDMNotPreserved"] = reflect.TypeOf((*RDMNotPreserved)(nil)).Elem()
}

type RDMNotPreservedFault RDMNotPreserved

func init() {
	t["RDMNotPreservedFault"] = reflect.TypeOf((*RDMNotPreservedFault)(nil)).Elem()
}

type RDMNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["RDMNotSupported"] = reflect.TypeOf((*RDMNotSupported)(nil)).Elem()
}

type RDMNotSupportedFault BaseRDMNotSupported

func init() {
	t["RDMNotSupportedFault"] = reflect.TypeOf((*RDMNotSupportedFault)(nil)).Elem()
}

type RDMNotSupportedOnDatastore struct {
	VmConfigFault

	Device        string                 `xml:"device"`
	Datastore     ManagedObjectReference `xml:"datastore"`
	DatastoreName string                 `xml:"datastoreName"`
}

func init() {
	t["RDMNotSupportedOnDatastore"] = reflect.TypeOf((*RDMNotSupportedOnDatastore)(nil)).Elem()
}

type RDMNotSupportedOnDatastoreFault RDMNotSupportedOnDatastore

func init() {
	t["RDMNotSupportedOnDatastoreFault"] = reflect.TypeOf((*RDMNotSupportedOnDatastoreFault)(nil)).Elem()
}

type RDMPointsToInaccessibleDisk struct {
	CannotAccessVmDisk
}

func init() {
	t["RDMPointsToInaccessibleDisk"] = reflect.TypeOf((*RDMPointsToInaccessibleDisk)(nil)).Elem()
}

type RDMPointsToInaccessibleDiskFault RDMPointsToInaccessibleDisk

func init() {
	t["RDMPointsToInaccessibleDiskFault"] = reflect.TypeOf((*RDMPointsToInaccessibleDiskFault)(nil)).Elem()
}

type RawDiskNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["RawDiskNotSupported"] = reflect.TypeOf((*RawDiskNotSupported)(nil)).Elem()
}

type RawDiskNotSupportedFault RawDiskNotSupported

func init() {
	t["RawDiskNotSupportedFault"] = reflect.TypeOf((*RawDiskNotSupportedFault)(nil)).Elem()
}

type ReadEnvironmentVariableInGuest ReadEnvironmentVariableInGuestRequestType

func init() {
	t["ReadEnvironmentVariableInGuest"] = reflect.TypeOf((*ReadEnvironmentVariableInGuest)(nil)).Elem()
}

type ReadEnvironmentVariableInGuestRequestType struct {
	This  ManagedObjectReference  `xml:"_this"`
	Vm    ManagedObjectReference  `xml:"vm"`
	Auth  BaseGuestAuthentication `xml:"auth,typeattr"`
	Names []string                `xml:"names,omitempty"`
}

func init() {
	t["ReadEnvironmentVariableInGuestRequestType"] = reflect.TypeOf((*ReadEnvironmentVariableInGuestRequestType)(nil)).Elem()
}

type ReadEnvironmentVariableInGuestResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type ReadHostResourcePoolTreeFailed struct {
	HostConnectFault
}

func init() {
	t["ReadHostResourcePoolTreeFailed"] = reflect.TypeOf((*ReadHostResourcePoolTreeFailed)(nil)).Elem()
}

type ReadHostResourcePoolTreeFailedFault ReadHostResourcePoolTreeFailed

func init() {
	t["ReadHostResourcePoolTreeFailedFault"] = reflect.TypeOf((*ReadHostResourcePoolTreeFailedFault)(nil)).Elem()
}

type ReadNextEvents ReadNextEventsRequestType

func init() {
	t["ReadNextEvents"] = reflect.TypeOf((*ReadNextEvents)(nil)).Elem()
}

type ReadNextEventsRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	MaxCount int                    `xml:"maxCount"`
}

func init() {
	t["ReadNextEventsRequestType"] = reflect.TypeOf((*ReadNextEventsRequestType)(nil)).Elem()
}

type ReadNextEventsResponse struct {
	Returnval []BaseEvent `xml:"returnval,omitempty,typeattr"`
}

type ReadNextTasks ReadNextTasksRequestType

func init() {
	t["ReadNextTasks"] = reflect.TypeOf((*ReadNextTasks)(nil)).Elem()
}

type ReadNextTasksRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	MaxCount int                    `xml:"maxCount"`
}

func init() {
	t["ReadNextTasksRequestType"] = reflect.TypeOf((*ReadNextTasksRequestType)(nil)).Elem()
}

type ReadNextTasksResponse struct {
	Returnval []TaskInfo `xml:"returnval,omitempty"`
}

type ReadOnlyDisksWithLegacyDestination struct {
	MigrationFault

	RoDiskCount   int  `xml:"roDiskCount"`
	TimeoutDanger bool `xml:"timeoutDanger"`
}

func init() {
	t["ReadOnlyDisksWithLegacyDestination"] = reflect.TypeOf((*ReadOnlyDisksWithLegacyDestination)(nil)).Elem()
}

type ReadOnlyDisksWithLegacyDestinationFault ReadOnlyDisksWithLegacyDestination

func init() {
	t["ReadOnlyDisksWithLegacyDestinationFault"] = reflect.TypeOf((*ReadOnlyDisksWithLegacyDestinationFault)(nil)).Elem()
}

type ReadPreviousEvents ReadPreviousEventsRequestType

func init() {
	t["ReadPreviousEvents"] = reflect.TypeOf((*ReadPreviousEvents)(nil)).Elem()
}

type ReadPreviousEventsRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	MaxCount int                    `xml:"maxCount"`
}

func init() {
	t["ReadPreviousEventsRequestType"] = reflect.TypeOf((*ReadPreviousEventsRequestType)(nil)).Elem()
}

type ReadPreviousEventsResponse struct {
	Returnval []BaseEvent `xml:"returnval,omitempty,typeattr"`
}

type ReadPreviousTasks ReadPreviousTasksRequestType

func init() {
	t["ReadPreviousTasks"] = reflect.TypeOf((*ReadPreviousTasks)(nil)).Elem()
}

type ReadPreviousTasksRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	MaxCount int                    `xml:"maxCount"`
}

func init() {
	t["ReadPreviousTasksRequestType"] = reflect.TypeOf((*ReadPreviousTasksRequestType)(nil)).Elem()
}

type ReadPreviousTasksResponse struct {
	Returnval []TaskInfo `xml:"returnval,omitempty"`
}

type RebootGuest RebootGuestRequestType

func init() {
	t["RebootGuest"] = reflect.TypeOf((*RebootGuest)(nil)).Elem()
}

type RebootGuestRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RebootGuestRequestType"] = reflect.TypeOf((*RebootGuestRequestType)(nil)).Elem()
}

type RebootGuestResponse struct {
}

type RebootHostRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Force bool                   `xml:"force"`
}

func init() {
	t["RebootHostRequestType"] = reflect.TypeOf((*RebootHostRequestType)(nil)).Elem()
}

type RebootHost_Task RebootHostRequestType

func init() {
	t["RebootHost_Task"] = reflect.TypeOf((*RebootHost_Task)(nil)).Elem()
}

type RebootHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RebootRequired struct {
	VimFault

	Patch string `xml:"patch,omitempty"`
}

func init() {
	t["RebootRequired"] = reflect.TypeOf((*RebootRequired)(nil)).Elem()
}

type RebootRequiredFault RebootRequired

func init() {
	t["RebootRequiredFault"] = reflect.TypeOf((*RebootRequiredFault)(nil)).Elem()
}

type RecommendDatastores RecommendDatastoresRequestType

func init() {
	t["RecommendDatastores"] = reflect.TypeOf((*RecommendDatastores)(nil)).Elem()
}

type RecommendDatastoresRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	StorageSpec StoragePlacementSpec   `xml:"storageSpec"`
}

func init() {
	t["RecommendDatastoresRequestType"] = reflect.TypeOf((*RecommendDatastoresRequestType)(nil)).Elem()
}

type RecommendDatastoresResponse struct {
	Returnval StoragePlacementResult `xml:"returnval"`
}

type RecommendHostsForVm RecommendHostsForVmRequestType

func init() {
	t["RecommendHostsForVm"] = reflect.TypeOf((*RecommendHostsForVm)(nil)).Elem()
}

type RecommendHostsForVmRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Pool *ManagedObjectReference `xml:"pool,omitempty"`
}

func init() {
	t["RecommendHostsForVmRequestType"] = reflect.TypeOf((*RecommendHostsForVmRequestType)(nil)).Elem()
}

type RecommendHostsForVmResponse struct {
	Returnval []ClusterHostRecommendation `xml:"returnval,omitempty"`
}

type ReconfigVMRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Spec VirtualMachineConfigSpec `xml:"spec"`
}

func init() {
	t["ReconfigVMRequestType"] = reflect.TypeOf((*ReconfigVMRequestType)(nil)).Elem()
}

type ReconfigVM_Task ReconfigVMRequestType

func init() {
	t["ReconfigVM_Task"] = reflect.TypeOf((*ReconfigVM_Task)(nil)).Elem()
}

type ReconfigVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureAlarm ReconfigureAlarmRequestType

func init() {
	t["ReconfigureAlarm"] = reflect.TypeOf((*ReconfigureAlarm)(nil)).Elem()
}

type ReconfigureAlarmRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec BaseAlarmSpec          `xml:"spec,typeattr"`
}

func init() {
	t["ReconfigureAlarmRequestType"] = reflect.TypeOf((*ReconfigureAlarmRequestType)(nil)).Elem()
}

type ReconfigureAlarmResponse struct {
}

type ReconfigureAutostart ReconfigureAutostartRequestType

func init() {
	t["ReconfigureAutostart"] = reflect.TypeOf((*ReconfigureAutostart)(nil)).Elem()
}

type ReconfigureAutostartRequestType struct {
	This ManagedObjectReference     `xml:"_this"`
	Spec HostAutoStartManagerConfig `xml:"spec"`
}

func init() {
	t["ReconfigureAutostartRequestType"] = reflect.TypeOf((*ReconfigureAutostartRequestType)(nil)).Elem()
}

type ReconfigureAutostartResponse struct {
}

type ReconfigureClusterRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Spec   ClusterConfigSpec      `xml:"spec"`
	Modify bool                   `xml:"modify"`
}

func init() {
	t["ReconfigureClusterRequestType"] = reflect.TypeOf((*ReconfigureClusterRequestType)(nil)).Elem()
}

type ReconfigureCluster_Task ReconfigureClusterRequestType

func init() {
	t["ReconfigureCluster_Task"] = reflect.TypeOf((*ReconfigureCluster_Task)(nil)).Elem()
}

type ReconfigureCluster_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureComputeResourceRequestType struct {
	This   ManagedObjectReference        `xml:"_this"`
	Spec   BaseComputeResourceConfigSpec `xml:"spec,typeattr"`
	Modify bool                          `xml:"modify"`
}

func init() {
	t["ReconfigureComputeResourceRequestType"] = reflect.TypeOf((*ReconfigureComputeResourceRequestType)(nil)).Elem()
}

type ReconfigureComputeResource_Task ReconfigureComputeResourceRequestType

func init() {
	t["ReconfigureComputeResource_Task"] = reflect.TypeOf((*ReconfigureComputeResource_Task)(nil)).Elem()
}

type ReconfigureComputeResource_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureDVPortRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Port []DVPortConfigSpec     `xml:"port"`
}

func init() {
	t["ReconfigureDVPortRequestType"] = reflect.TypeOf((*ReconfigureDVPortRequestType)(nil)).Elem()
}

type ReconfigureDVPort_Task ReconfigureDVPortRequestType

func init() {
	t["ReconfigureDVPort_Task"] = reflect.TypeOf((*ReconfigureDVPort_Task)(nil)).Elem()
}

type ReconfigureDVPort_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureDVPortgroupRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec DVPortgroupConfigSpec  `xml:"spec"`
}

func init() {
	t["ReconfigureDVPortgroupRequestType"] = reflect.TypeOf((*ReconfigureDVPortgroupRequestType)(nil)).Elem()
}

type ReconfigureDVPortgroup_Task ReconfigureDVPortgroupRequestType

func init() {
	t["ReconfigureDVPortgroup_Task"] = reflect.TypeOf((*ReconfigureDVPortgroup_Task)(nil)).Elem()
}

type ReconfigureDVPortgroup_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureDatacenterRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Spec   DatacenterConfigSpec   `xml:"spec"`
	Modify bool                   `xml:"modify"`
}

func init() {
	t["ReconfigureDatacenterRequestType"] = reflect.TypeOf((*ReconfigureDatacenterRequestType)(nil)).Elem()
}

type ReconfigureDatacenter_Task ReconfigureDatacenterRequestType

func init() {
	t["ReconfigureDatacenter_Task"] = reflect.TypeOf((*ReconfigureDatacenter_Task)(nil)).Elem()
}

type ReconfigureDatacenter_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureDvsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec BaseDVSConfigSpec      `xml:"spec,typeattr"`
}

func init() {
	t["ReconfigureDvsRequestType"] = reflect.TypeOf((*ReconfigureDvsRequestType)(nil)).Elem()
}

type ReconfigureDvs_Task ReconfigureDvsRequestType

func init() {
	t["ReconfigureDvs_Task"] = reflect.TypeOf((*ReconfigureDvs_Task)(nil)).Elem()
}

type ReconfigureDvs_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureHostForDASRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ReconfigureHostForDASRequestType"] = reflect.TypeOf((*ReconfigureHostForDASRequestType)(nil)).Elem()
}

type ReconfigureHostForDAS_Task ReconfigureHostForDASRequestType

func init() {
	t["ReconfigureHostForDAS_Task"] = reflect.TypeOf((*ReconfigureHostForDAS_Task)(nil)).Elem()
}

type ReconfigureHostForDAS_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReconfigureScheduledTask ReconfigureScheduledTaskRequestType

func init() {
	t["ReconfigureScheduledTask"] = reflect.TypeOf((*ReconfigureScheduledTask)(nil)).Elem()
}

type ReconfigureScheduledTaskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec BaseScheduledTaskSpec  `xml:"spec,typeattr"`
}

func init() {
	t["ReconfigureScheduledTaskRequestType"] = reflect.TypeOf((*ReconfigureScheduledTaskRequestType)(nil)).Elem()
}

type ReconfigureScheduledTaskResponse struct {
}

type ReconfigureServiceConsoleReservation ReconfigureServiceConsoleReservationRequestType

func init() {
	t["ReconfigureServiceConsoleReservation"] = reflect.TypeOf((*ReconfigureServiceConsoleReservation)(nil)).Elem()
}

type ReconfigureServiceConsoleReservationRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	CfgBytes int64                  `xml:"cfgBytes"`
}

func init() {
	t["ReconfigureServiceConsoleReservationRequestType"] = reflect.TypeOf((*ReconfigureServiceConsoleReservationRequestType)(nil)).Elem()
}

type ReconfigureServiceConsoleReservationResponse struct {
}

type ReconfigureSnmpAgent ReconfigureSnmpAgentRequestType

func init() {
	t["ReconfigureSnmpAgent"] = reflect.TypeOf((*ReconfigureSnmpAgent)(nil)).Elem()
}

type ReconfigureSnmpAgentRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec HostSnmpConfigSpec     `xml:"spec"`
}

func init() {
	t["ReconfigureSnmpAgentRequestType"] = reflect.TypeOf((*ReconfigureSnmpAgentRequestType)(nil)).Elem()
}

type ReconfigureSnmpAgentResponse struct {
}

type ReconfigureVirtualMachineReservation ReconfigureVirtualMachineReservationRequestType

func init() {
	t["ReconfigureVirtualMachineReservation"] = reflect.TypeOf((*ReconfigureVirtualMachineReservation)(nil)).Elem()
}

type ReconfigureVirtualMachineReservationRequestType struct {
	This ManagedObjectReference              `xml:"_this"`
	Spec VirtualMachineMemoryReservationSpec `xml:"spec"`
}

func init() {
	t["ReconfigureVirtualMachineReservationRequestType"] = reflect.TypeOf((*ReconfigureVirtualMachineReservationRequestType)(nil)).Elem()
}

type ReconfigureVirtualMachineReservationResponse struct {
}

type ReconnectHostRequestType struct {
	This          ManagedObjectReference   `xml:"_this"`
	CnxSpec       *HostConnectSpec         `xml:"cnxSpec,omitempty"`
	ReconnectSpec *HostSystemReconnectSpec `xml:"reconnectSpec,omitempty"`
}

func init() {
	t["ReconnectHostRequestType"] = reflect.TypeOf((*ReconnectHostRequestType)(nil)).Elem()
}

type ReconnectHost_Task ReconnectHostRequestType

func init() {
	t["ReconnectHost_Task"] = reflect.TypeOf((*ReconnectHost_Task)(nil)).Elem()
}

type ReconnectHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RecordReplayDisabled struct {
	VimFault
}

func init() {
	t["RecordReplayDisabled"] = reflect.TypeOf((*RecordReplayDisabled)(nil)).Elem()
}

type RecordReplayDisabledFault RecordReplayDisabled

func init() {
	t["RecordReplayDisabledFault"] = reflect.TypeOf((*RecordReplayDisabledFault)(nil)).Elem()
}

type RecoveryEvent struct {
	DvsEvent

	HostName string `xml:"hostName"`
	PortKey  string `xml:"portKey"`
	DvsUuid  string `xml:"dvsUuid,omitempty"`
	Vnic     string `xml:"vnic,omitempty"`
}

func init() {
	t["RecoveryEvent"] = reflect.TypeOf((*RecoveryEvent)(nil)).Elem()
}

type RectifyDvsHostRequestType struct {
	This  ManagedObjectReference   `xml:"_this"`
	Hosts []ManagedObjectReference `xml:"hosts,omitempty"`
}

func init() {
	t["RectifyDvsHostRequestType"] = reflect.TypeOf((*RectifyDvsHostRequestType)(nil)).Elem()
}

type RectifyDvsHost_Task RectifyDvsHostRequestType

func init() {
	t["RectifyDvsHost_Task"] = reflect.TypeOf((*RectifyDvsHost_Task)(nil)).Elem()
}

type RectifyDvsHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RectifyDvsOnHostRequestType struct {
	This  ManagedObjectReference   `xml:"_this"`
	Hosts []ManagedObjectReference `xml:"hosts"`
}

func init() {
	t["RectifyDvsOnHostRequestType"] = reflect.TypeOf((*RectifyDvsOnHostRequestType)(nil)).Elem()
}

type RectifyDvsOnHost_Task RectifyDvsOnHostRequestType

func init() {
	t["RectifyDvsOnHost_Task"] = reflect.TypeOf((*RectifyDvsOnHost_Task)(nil)).Elem()
}

type RectifyDvsOnHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RecurrentTaskScheduler struct {
	TaskScheduler

	Interval int `xml:"interval"`
}

func init() {
	t["RecurrentTaskScheduler"] = reflect.TypeOf((*RecurrentTaskScheduler)(nil)).Elem()
}

type Refresh RefreshRequestType

func init() {
	t["Refresh"] = reflect.TypeOf((*Refresh)(nil)).Elem()
}

type RefreshDVPortState RefreshDVPortStateRequestType

func init() {
	t["RefreshDVPortState"] = reflect.TypeOf((*RefreshDVPortState)(nil)).Elem()
}

type RefreshDVPortStateRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	PortKeys []string               `xml:"portKeys,omitempty"`
}

func init() {
	t["RefreshDVPortStateRequestType"] = reflect.TypeOf((*RefreshDVPortStateRequestType)(nil)).Elem()
}

type RefreshDVPortStateResponse struct {
}

type RefreshDatastore RefreshDatastoreRequestType

func init() {
	t["RefreshDatastore"] = reflect.TypeOf((*RefreshDatastore)(nil)).Elem()
}

type RefreshDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshDatastoreRequestType"] = reflect.TypeOf((*RefreshDatastoreRequestType)(nil)).Elem()
}

type RefreshDatastoreResponse struct {
}

type RefreshDatastoreStorageInfo RefreshDatastoreStorageInfoRequestType

func init() {
	t["RefreshDatastoreStorageInfo"] = reflect.TypeOf((*RefreshDatastoreStorageInfo)(nil)).Elem()
}

type RefreshDatastoreStorageInfoRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshDatastoreStorageInfoRequestType"] = reflect.TypeOf((*RefreshDatastoreStorageInfoRequestType)(nil)).Elem()
}

type RefreshDatastoreStorageInfoResponse struct {
}

type RefreshDateTimeSystem RefreshDateTimeSystemRequestType

func init() {
	t["RefreshDateTimeSystem"] = reflect.TypeOf((*RefreshDateTimeSystem)(nil)).Elem()
}

type RefreshDateTimeSystemRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshDateTimeSystemRequestType"] = reflect.TypeOf((*RefreshDateTimeSystemRequestType)(nil)).Elem()
}

type RefreshDateTimeSystemResponse struct {
}

type RefreshFirewall RefreshFirewallRequestType

func init() {
	t["RefreshFirewall"] = reflect.TypeOf((*RefreshFirewall)(nil)).Elem()
}

type RefreshFirewallRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshFirewallRequestType"] = reflect.TypeOf((*RefreshFirewallRequestType)(nil)).Elem()
}

type RefreshFirewallResponse struct {
}

type RefreshGraphicsManager RefreshGraphicsManagerRequestType

func init() {
	t["RefreshGraphicsManager"] = reflect.TypeOf((*RefreshGraphicsManager)(nil)).Elem()
}

type RefreshGraphicsManagerRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshGraphicsManagerRequestType"] = reflect.TypeOf((*RefreshGraphicsManagerRequestType)(nil)).Elem()
}

type RefreshGraphicsManagerResponse struct {
}

type RefreshHealthStatusSystem RefreshHealthStatusSystemRequestType

func init() {
	t["RefreshHealthStatusSystem"] = reflect.TypeOf((*RefreshHealthStatusSystem)(nil)).Elem()
}

type RefreshHealthStatusSystemRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshHealthStatusSystemRequestType"] = reflect.TypeOf((*RefreshHealthStatusSystemRequestType)(nil)).Elem()
}

type RefreshHealthStatusSystemResponse struct {
}

type RefreshNetworkSystem RefreshNetworkSystemRequestType

func init() {
	t["RefreshNetworkSystem"] = reflect.TypeOf((*RefreshNetworkSystem)(nil)).Elem()
}

type RefreshNetworkSystemRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshNetworkSystemRequestType"] = reflect.TypeOf((*RefreshNetworkSystemRequestType)(nil)).Elem()
}

type RefreshNetworkSystemResponse struct {
}

type RefreshRecommendation RefreshRecommendationRequestType

func init() {
	t["RefreshRecommendation"] = reflect.TypeOf((*RefreshRecommendation)(nil)).Elem()
}

type RefreshRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshRecommendationRequestType"] = reflect.TypeOf((*RefreshRecommendationRequestType)(nil)).Elem()
}

type RefreshRecommendationResponse struct {
}

type RefreshRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshRequestType"] = reflect.TypeOf((*RefreshRequestType)(nil)).Elem()
}

type RefreshResponse struct {
}

type RefreshRuntime RefreshRuntimeRequestType

func init() {
	t["RefreshRuntime"] = reflect.TypeOf((*RefreshRuntime)(nil)).Elem()
}

type RefreshRuntimeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshRuntimeRequestType"] = reflect.TypeOf((*RefreshRuntimeRequestType)(nil)).Elem()
}

type RefreshRuntimeResponse struct {
}

type RefreshServices RefreshServicesRequestType

func init() {
	t["RefreshServices"] = reflect.TypeOf((*RefreshServices)(nil)).Elem()
}

type RefreshServicesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshServicesRequestType"] = reflect.TypeOf((*RefreshServicesRequestType)(nil)).Elem()
}

type RefreshServicesResponse struct {
}

type RefreshStorageDrsRecommendation RefreshStorageDrsRecommendationRequestType

func init() {
	t["RefreshStorageDrsRecommendation"] = reflect.TypeOf((*RefreshStorageDrsRecommendation)(nil)).Elem()
}

type RefreshStorageDrsRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Pod  ManagedObjectReference `xml:"pod"`
}

func init() {
	t["RefreshStorageDrsRecommendationRequestType"] = reflect.TypeOf((*RefreshStorageDrsRecommendationRequestType)(nil)).Elem()
}

type RefreshStorageDrsRecommendationResponse struct {
}

type RefreshStorageInfo RefreshStorageInfoRequestType

func init() {
	t["RefreshStorageInfo"] = reflect.TypeOf((*RefreshStorageInfo)(nil)).Elem()
}

type RefreshStorageInfoRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshStorageInfoRequestType"] = reflect.TypeOf((*RefreshStorageInfoRequestType)(nil)).Elem()
}

type RefreshStorageInfoResponse struct {
}

type RefreshStorageSystem RefreshStorageSystemRequestType

func init() {
	t["RefreshStorageSystem"] = reflect.TypeOf((*RefreshStorageSystem)(nil)).Elem()
}

type RefreshStorageSystemRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RefreshStorageSystemRequestType"] = reflect.TypeOf((*RefreshStorageSystemRequestType)(nil)).Elem()
}

type RefreshStorageSystemResponse struct {
}

type RegisterChildVMRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Path string                  `xml:"path"`
	Name string                  `xml:"name,omitempty"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["RegisterChildVMRequestType"] = reflect.TypeOf((*RegisterChildVMRequestType)(nil)).Elem()
}

type RegisterChildVM_Task RegisterChildVMRequestType

func init() {
	t["RegisterChildVM_Task"] = reflect.TypeOf((*RegisterChildVM_Task)(nil)).Elem()
}

type RegisterChildVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RegisterExtension RegisterExtensionRequestType

func init() {
	t["RegisterExtension"] = reflect.TypeOf((*RegisterExtension)(nil)).Elem()
}

type RegisterExtensionRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Extension Extension              `xml:"extension"`
}

func init() {
	t["RegisterExtensionRequestType"] = reflect.TypeOf((*RegisterExtensionRequestType)(nil)).Elem()
}

type RegisterExtensionResponse struct {
}

type RegisterVMRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Path       string                  `xml:"path"`
	Name       string                  `xml:"name,omitempty"`
	AsTemplate bool                    `xml:"asTemplate"`
	Pool       *ManagedObjectReference `xml:"pool,omitempty"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["RegisterVMRequestType"] = reflect.TypeOf((*RegisterVMRequestType)(nil)).Elem()
}

type RegisterVM_Task RegisterVMRequestType

func init() {
	t["RegisterVM_Task"] = reflect.TypeOf((*RegisterVM_Task)(nil)).Elem()
}

type RegisterVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReleaseCredentialsInGuest ReleaseCredentialsInGuestRequestType

func init() {
	t["ReleaseCredentialsInGuest"] = reflect.TypeOf((*ReleaseCredentialsInGuest)(nil)).Elem()
}

type ReleaseCredentialsInGuestRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Auth BaseGuestAuthentication `xml:"auth,typeattr"`
}

func init() {
	t["ReleaseCredentialsInGuestRequestType"] = reflect.TypeOf((*ReleaseCredentialsInGuestRequestType)(nil)).Elem()
}

type ReleaseCredentialsInGuestResponse struct {
}

type ReleaseIpAllocation ReleaseIpAllocationRequestType

func init() {
	t["ReleaseIpAllocation"] = reflect.TypeOf((*ReleaseIpAllocation)(nil)).Elem()
}

type ReleaseIpAllocationRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Dc           ManagedObjectReference `xml:"dc"`
	PoolId       int                    `xml:"poolId"`
	AllocationId string                 `xml:"allocationId"`
}

func init() {
	t["ReleaseIpAllocationRequestType"] = reflect.TypeOf((*ReleaseIpAllocationRequestType)(nil)).Elem()
}

type ReleaseIpAllocationResponse struct {
}

type Reload ReloadRequestType

func init() {
	t["Reload"] = reflect.TypeOf((*Reload)(nil)).Elem()
}

type ReloadRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ReloadRequestType"] = reflect.TypeOf((*ReloadRequestType)(nil)).Elem()
}

type ReloadResponse struct {
}

type RelocateVMRequestType struct {
	This     ManagedObjectReference     `xml:"_this"`
	Spec     VirtualMachineRelocateSpec `xml:"spec"`
	Priority VirtualMachineMovePriority `xml:"priority,omitempty"`
}

func init() {
	t["RelocateVMRequestType"] = reflect.TypeOf((*RelocateVMRequestType)(nil)).Elem()
}

type RelocateVM_Task RelocateVMRequestType

func init() {
	t["RelocateVM_Task"] = reflect.TypeOf((*RelocateVM_Task)(nil)).Elem()
}

type RelocateVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RemoteDeviceNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["RemoteDeviceNotSupported"] = reflect.TypeOf((*RemoteDeviceNotSupported)(nil)).Elem()
}

type RemoteDeviceNotSupportedFault RemoteDeviceNotSupported

func init() {
	t["RemoteDeviceNotSupportedFault"] = reflect.TypeOf((*RemoteDeviceNotSupportedFault)(nil)).Elem()
}

type RemoteTSMEnabledEvent struct {
	HostEvent
}

func init() {
	t["RemoteTSMEnabledEvent"] = reflect.TypeOf((*RemoteTSMEnabledEvent)(nil)).Elem()
}

type RemoveAlarm RemoveAlarmRequestType

func init() {
	t["RemoveAlarm"] = reflect.TypeOf((*RemoveAlarm)(nil)).Elem()
}

type RemoveAlarmRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RemoveAlarmRequestType"] = reflect.TypeOf((*RemoveAlarmRequestType)(nil)).Elem()
}

type RemoveAlarmResponse struct {
}

type RemoveAllSnapshotsRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Consolidate *bool                  `xml:"consolidate"`
}

func init() {
	t["RemoveAllSnapshotsRequestType"] = reflect.TypeOf((*RemoveAllSnapshotsRequestType)(nil)).Elem()
}

type RemoveAllSnapshots_Task RemoveAllSnapshotsRequestType

func init() {
	t["RemoveAllSnapshots_Task"] = reflect.TypeOf((*RemoveAllSnapshots_Task)(nil)).Elem()
}

type RemoveAllSnapshots_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RemoveAssignedLicense RemoveAssignedLicenseRequestType

func init() {
	t["RemoveAssignedLicense"] = reflect.TypeOf((*RemoveAssignedLicense)(nil)).Elem()
}

type RemoveAssignedLicenseRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	EntityId string                 `xml:"entityId"`
}

func init() {
	t["RemoveAssignedLicenseRequestType"] = reflect.TypeOf((*RemoveAssignedLicenseRequestType)(nil)).Elem()
}

type RemoveAssignedLicenseResponse struct {
}

type RemoveAuthorizationRole RemoveAuthorizationRoleRequestType

func init() {
	t["RemoveAuthorizationRole"] = reflect.TypeOf((*RemoveAuthorizationRole)(nil)).Elem()
}

type RemoveAuthorizationRoleRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	RoleId     int                    `xml:"roleId"`
	FailIfUsed bool                   `xml:"failIfUsed"`
}

func init() {
	t["RemoveAuthorizationRoleRequestType"] = reflect.TypeOf((*RemoveAuthorizationRoleRequestType)(nil)).Elem()
}

type RemoveAuthorizationRoleResponse struct {
}

type RemoveCustomFieldDef RemoveCustomFieldDefRequestType

func init() {
	t["RemoveCustomFieldDef"] = reflect.TypeOf((*RemoveCustomFieldDef)(nil)).Elem()
}

type RemoveCustomFieldDefRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  int                    `xml:"key"`
}

func init() {
	t["RemoveCustomFieldDefRequestType"] = reflect.TypeOf((*RemoveCustomFieldDefRequestType)(nil)).Elem()
}

type RemoveCustomFieldDefResponse struct {
}

type RemoveDatastore RemoveDatastoreRequestType

func init() {
	t["RemoveDatastore"] = reflect.TypeOf((*RemoveDatastore)(nil)).Elem()
}

type RemoveDatastoreRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["RemoveDatastoreRequestType"] = reflect.TypeOf((*RemoveDatastoreRequestType)(nil)).Elem()
}

type RemoveDatastoreResponse struct {
}

type RemoveDiskMappingRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Mapping []VsanHostDiskMapping  `xml:"mapping"`
}

func init() {
	t["RemoveDiskMappingRequestType"] = reflect.TypeOf((*RemoveDiskMappingRequestType)(nil)).Elem()
}

type RemoveDiskMapping_Task RemoveDiskMappingRequestType

func init() {
	t["RemoveDiskMapping_Task"] = reflect.TypeOf((*RemoveDiskMapping_Task)(nil)).Elem()
}

type RemoveDiskMapping_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RemoveDiskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Disk []HostScsiDisk         `xml:"disk"`
}

func init() {
	t["RemoveDiskRequestType"] = reflect.TypeOf((*RemoveDiskRequestType)(nil)).Elem()
}

type RemoveDisk_Task RemoveDiskRequestType

func init() {
	t["RemoveDisk_Task"] = reflect.TypeOf((*RemoveDisk_Task)(nil)).Elem()
}

type RemoveDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RemoveEntityPermission RemoveEntityPermissionRequestType

func init() {
	t["RemoveEntityPermission"] = reflect.TypeOf((*RemoveEntityPermission)(nil)).Elem()
}

type RemoveEntityPermissionRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Entity  ManagedObjectReference `xml:"entity"`
	User    string                 `xml:"user"`
	IsGroup bool                   `xml:"isGroup"`
}

func init() {
	t["RemoveEntityPermissionRequestType"] = reflect.TypeOf((*RemoveEntityPermissionRequestType)(nil)).Elem()
}

type RemoveEntityPermissionResponse struct {
}

type RemoveFailed struct {
	VimFault
}

func init() {
	t["RemoveFailed"] = reflect.TypeOf((*RemoveFailed)(nil)).Elem()
}

type RemoveFailedFault RemoveFailed

func init() {
	t["RemoveFailedFault"] = reflect.TypeOf((*RemoveFailedFault)(nil)).Elem()
}

type RemoveGroup RemoveGroupRequestType

func init() {
	t["RemoveGroup"] = reflect.TypeOf((*RemoveGroup)(nil)).Elem()
}

type RemoveGroupRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	GroupName string                 `xml:"groupName"`
}

func init() {
	t["RemoveGroupRequestType"] = reflect.TypeOf((*RemoveGroupRequestType)(nil)).Elem()
}

type RemoveGroupResponse struct {
}

type RemoveInternetScsiSendTargets RemoveInternetScsiSendTargetsRequestType

func init() {
	t["RemoveInternetScsiSendTargets"] = reflect.TypeOf((*RemoveInternetScsiSendTargets)(nil)).Elem()
}

type RemoveInternetScsiSendTargetsRequestType struct {
	This           ManagedObjectReference          `xml:"_this"`
	IScsiHbaDevice string                          `xml:"iScsiHbaDevice"`
	Targets        []HostInternetScsiHbaSendTarget `xml:"targets"`
}

func init() {
	t["RemoveInternetScsiSendTargetsRequestType"] = reflect.TypeOf((*RemoveInternetScsiSendTargetsRequestType)(nil)).Elem()
}

type RemoveInternetScsiSendTargetsResponse struct {
}

type RemoveInternetScsiStaticTargets RemoveInternetScsiStaticTargetsRequestType

func init() {
	t["RemoveInternetScsiStaticTargets"] = reflect.TypeOf((*RemoveInternetScsiStaticTargets)(nil)).Elem()
}

type RemoveInternetScsiStaticTargetsRequestType struct {
	This           ManagedObjectReference            `xml:"_this"`
	IScsiHbaDevice string                            `xml:"iScsiHbaDevice"`
	Targets        []HostInternetScsiHbaStaticTarget `xml:"targets"`
}

func init() {
	t["RemoveInternetScsiStaticTargetsRequestType"] = reflect.TypeOf((*RemoveInternetScsiStaticTargetsRequestType)(nil)).Elem()
}

type RemoveInternetScsiStaticTargetsResponse struct {
}

type RemoveLicense RemoveLicenseRequestType

func init() {
	t["RemoveLicense"] = reflect.TypeOf((*RemoveLicense)(nil)).Elem()
}

type RemoveLicenseLabel RemoveLicenseLabelRequestType

func init() {
	t["RemoveLicenseLabel"] = reflect.TypeOf((*RemoveLicenseLabel)(nil)).Elem()
}

type RemoveLicenseLabelRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	LicenseKey string                 `xml:"licenseKey"`
	LabelKey   string                 `xml:"labelKey"`
}

func init() {
	t["RemoveLicenseLabelRequestType"] = reflect.TypeOf((*RemoveLicenseLabelRequestType)(nil)).Elem()
}

type RemoveLicenseLabelResponse struct {
}

type RemoveLicenseRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	LicenseKey string                 `xml:"licenseKey"`
}

func init() {
	t["RemoveLicenseRequestType"] = reflect.TypeOf((*RemoveLicenseRequestType)(nil)).Elem()
}

type RemoveLicenseResponse struct {
}

type RemoveNetworkResourcePool RemoveNetworkResourcePoolRequestType

func init() {
	t["RemoveNetworkResourcePool"] = reflect.TypeOf((*RemoveNetworkResourcePool)(nil)).Elem()
}

type RemoveNetworkResourcePoolRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  []string               `xml:"key"`
}

func init() {
	t["RemoveNetworkResourcePoolRequestType"] = reflect.TypeOf((*RemoveNetworkResourcePoolRequestType)(nil)).Elem()
}

type RemoveNetworkResourcePoolResponse struct {
}

type RemovePerfInterval RemovePerfIntervalRequestType

func init() {
	t["RemovePerfInterval"] = reflect.TypeOf((*RemovePerfInterval)(nil)).Elem()
}

type RemovePerfIntervalRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	SamplePeriod int                    `xml:"samplePeriod"`
}

func init() {
	t["RemovePerfIntervalRequestType"] = reflect.TypeOf((*RemovePerfIntervalRequestType)(nil)).Elem()
}

type RemovePerfIntervalResponse struct {
}

type RemovePortGroup RemovePortGroupRequestType

func init() {
	t["RemovePortGroup"] = reflect.TypeOf((*RemovePortGroup)(nil)).Elem()
}

type RemovePortGroupRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	PgName string                 `xml:"pgName"`
}

func init() {
	t["RemovePortGroupRequestType"] = reflect.TypeOf((*RemovePortGroupRequestType)(nil)).Elem()
}

type RemovePortGroupResponse struct {
}

type RemoveScheduledTask RemoveScheduledTaskRequestType

func init() {
	t["RemoveScheduledTask"] = reflect.TypeOf((*RemoveScheduledTask)(nil)).Elem()
}

type RemoveScheduledTaskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RemoveScheduledTaskRequestType"] = reflect.TypeOf((*RemoveScheduledTaskRequestType)(nil)).Elem()
}

type RemoveScheduledTaskResponse struct {
}

type RemoveServiceConsoleVirtualNic RemoveServiceConsoleVirtualNicRequestType

func init() {
	t["RemoveServiceConsoleVirtualNic"] = reflect.TypeOf((*RemoveServiceConsoleVirtualNic)(nil)).Elem()
}

type RemoveServiceConsoleVirtualNicRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Device string                 `xml:"device"`
}

func init() {
	t["RemoveServiceConsoleVirtualNicRequestType"] = reflect.TypeOf((*RemoveServiceConsoleVirtualNicRequestType)(nil)).Elem()
}

type RemoveServiceConsoleVirtualNicResponse struct {
}

type RemoveSnapshotRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	RemoveChildren bool                   `xml:"removeChildren"`
	Consolidate    *bool                  `xml:"consolidate"`
}

func init() {
	t["RemoveSnapshotRequestType"] = reflect.TypeOf((*RemoveSnapshotRequestType)(nil)).Elem()
}

type RemoveSnapshot_Task RemoveSnapshotRequestType

func init() {
	t["RemoveSnapshot_Task"] = reflect.TypeOf((*RemoveSnapshot_Task)(nil)).Elem()
}

type RemoveSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RemoveUser RemoveUserRequestType

func init() {
	t["RemoveUser"] = reflect.TypeOf((*RemoveUser)(nil)).Elem()
}

type RemoveUserRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
}

func init() {
	t["RemoveUserRequestType"] = reflect.TypeOf((*RemoveUserRequestType)(nil)).Elem()
}

type RemoveUserResponse struct {
}

type RemoveVirtualNic RemoveVirtualNicRequestType

func init() {
	t["RemoveVirtualNic"] = reflect.TypeOf((*RemoveVirtualNic)(nil)).Elem()
}

type RemoveVirtualNicRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Device string                 `xml:"device"`
}

func init() {
	t["RemoveVirtualNicRequestType"] = reflect.TypeOf((*RemoveVirtualNicRequestType)(nil)).Elem()
}

type RemoveVirtualNicResponse struct {
}

type RemoveVirtualSwitch RemoveVirtualSwitchRequestType

func init() {
	t["RemoveVirtualSwitch"] = reflect.TypeOf((*RemoveVirtualSwitch)(nil)).Elem()
}

type RemoveVirtualSwitchRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	VswitchName string                 `xml:"vswitchName"`
}

func init() {
	t["RemoveVirtualSwitchRequestType"] = reflect.TypeOf((*RemoveVirtualSwitchRequestType)(nil)).Elem()
}

type RemoveVirtualSwitchResponse struct {
}

type RenameCustomFieldDef RenameCustomFieldDefRequestType

func init() {
	t["RenameCustomFieldDef"] = reflect.TypeOf((*RenameCustomFieldDef)(nil)).Elem()
}

type RenameCustomFieldDefRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  int                    `xml:"key"`
	Name string                 `xml:"name"`
}

func init() {
	t["RenameCustomFieldDefRequestType"] = reflect.TypeOf((*RenameCustomFieldDefRequestType)(nil)).Elem()
}

type RenameCustomFieldDefResponse struct {
}

type RenameCustomizationSpec RenameCustomizationSpecRequestType

func init() {
	t["RenameCustomizationSpec"] = reflect.TypeOf((*RenameCustomizationSpec)(nil)).Elem()
}

type RenameCustomizationSpecRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Name    string                 `xml:"name"`
	NewName string                 `xml:"newName"`
}

func init() {
	t["RenameCustomizationSpecRequestType"] = reflect.TypeOf((*RenameCustomizationSpecRequestType)(nil)).Elem()
}

type RenameCustomizationSpecResponse struct {
}

type RenameDatastore RenameDatastoreRequestType

func init() {
	t["RenameDatastore"] = reflect.TypeOf((*RenameDatastore)(nil)).Elem()
}

type RenameDatastoreRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	NewName string                 `xml:"newName"`
}

func init() {
	t["RenameDatastoreRequestType"] = reflect.TypeOf((*RenameDatastoreRequestType)(nil)).Elem()
}

type RenameDatastoreResponse struct {
}

type RenameRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	NewName string                 `xml:"newName"`
}

func init() {
	t["RenameRequestType"] = reflect.TypeOf((*RenameRequestType)(nil)).Elem()
}

type RenameSnapshot RenameSnapshotRequestType

func init() {
	t["RenameSnapshot"] = reflect.TypeOf((*RenameSnapshot)(nil)).Elem()
}

type RenameSnapshotRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Name        string                 `xml:"name,omitempty"`
	Description string                 `xml:"description,omitempty"`
}

func init() {
	t["RenameSnapshotRequestType"] = reflect.TypeOf((*RenameSnapshotRequestType)(nil)).Elem()
}

type RenameSnapshotResponse struct {
}

type Rename_Task RenameRequestType

func init() {
	t["Rename_Task"] = reflect.TypeOf((*Rename_Task)(nil)).Elem()
}

type Rename_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ReplicationConfigFault struct {
	ReplicationFault
}

func init() {
	t["ReplicationConfigFault"] = reflect.TypeOf((*ReplicationConfigFault)(nil)).Elem()
}

type ReplicationConfigFaultFault BaseReplicationConfigFault

func init() {
	t["ReplicationConfigFaultFault"] = reflect.TypeOf((*ReplicationConfigFaultFault)(nil)).Elem()
}

type ReplicationDiskConfigFault struct {
	ReplicationConfigFault

	Reason string                  `xml:"reason,omitempty"`
	VmRef  *ManagedObjectReference `xml:"vmRef,omitempty"`
	Key    int                     `xml:"key,omitempty"`
}

func init() {
	t["ReplicationDiskConfigFault"] = reflect.TypeOf((*ReplicationDiskConfigFault)(nil)).Elem()
}

type ReplicationDiskConfigFaultFault ReplicationDiskConfigFault

func init() {
	t["ReplicationDiskConfigFaultFault"] = reflect.TypeOf((*ReplicationDiskConfigFaultFault)(nil)).Elem()
}

type ReplicationFault struct {
	VimFault
}

func init() {
	t["ReplicationFault"] = reflect.TypeOf((*ReplicationFault)(nil)).Elem()
}

type ReplicationFaultFault BaseReplicationFault

func init() {
	t["ReplicationFaultFault"] = reflect.TypeOf((*ReplicationFaultFault)(nil)).Elem()
}

type ReplicationIncompatibleWithFT struct {
	ReplicationFault
}

func init() {
	t["ReplicationIncompatibleWithFT"] = reflect.TypeOf((*ReplicationIncompatibleWithFT)(nil)).Elem()
}

type ReplicationIncompatibleWithFTFault ReplicationIncompatibleWithFT

func init() {
	t["ReplicationIncompatibleWithFTFault"] = reflect.TypeOf((*ReplicationIncompatibleWithFTFault)(nil)).Elem()
}

type ReplicationInfoDiskSettings struct {
	DynamicData

	Key               int    `xml:"key"`
	DiskReplicationId string `xml:"diskReplicationId"`
}

func init() {
	t["ReplicationInfoDiskSettings"] = reflect.TypeOf((*ReplicationInfoDiskSettings)(nil)).Elem()
}

type ReplicationInvalidOptions struct {
	ReplicationFault

	Options string                  `xml:"options"`
	Entity  *ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["ReplicationInvalidOptions"] = reflect.TypeOf((*ReplicationInvalidOptions)(nil)).Elem()
}

type ReplicationInvalidOptionsFault ReplicationInvalidOptions

func init() {
	t["ReplicationInvalidOptionsFault"] = reflect.TypeOf((*ReplicationInvalidOptionsFault)(nil)).Elem()
}

type ReplicationNotSupportedOnHost struct {
	ReplicationFault
}

func init() {
	t["ReplicationNotSupportedOnHost"] = reflect.TypeOf((*ReplicationNotSupportedOnHost)(nil)).Elem()
}

type ReplicationNotSupportedOnHostFault ReplicationNotSupportedOnHost

func init() {
	t["ReplicationNotSupportedOnHostFault"] = reflect.TypeOf((*ReplicationNotSupportedOnHostFault)(nil)).Elem()
}

type ReplicationVmConfigFault struct {
	ReplicationConfigFault

	Reason string                  `xml:"reason,omitempty"`
	VmRef  *ManagedObjectReference `xml:"vmRef,omitempty"`
}

func init() {
	t["ReplicationVmConfigFault"] = reflect.TypeOf((*ReplicationVmConfigFault)(nil)).Elem()
}

type ReplicationVmConfigFaultFault ReplicationVmConfigFault

func init() {
	t["ReplicationVmConfigFaultFault"] = reflect.TypeOf((*ReplicationVmConfigFaultFault)(nil)).Elem()
}

type ReplicationVmFault struct {
	ReplicationFault

	Reason     string                  `xml:"reason,omitempty"`
	State      string                  `xml:"state,omitempty"`
	InstanceId string                  `xml:"instanceId,omitempty"`
	Vm         *ManagedObjectReference `xml:"vm,omitempty"`
}

func init() {
	t["ReplicationVmFault"] = reflect.TypeOf((*ReplicationVmFault)(nil)).Elem()
}

type ReplicationVmFaultFault ReplicationVmFault

func init() {
	t["ReplicationVmFaultFault"] = reflect.TypeOf((*ReplicationVmFaultFault)(nil)).Elem()
}

type ReplicationVmProgressInfo struct {
	DynamicData

	Progress              int   `xml:"progress"`
	BytesTransferred      int64 `xml:"bytesTransferred"`
	BytesToTransfer       int64 `xml:"bytesToTransfer"`
	ChecksumTotalBytes    int64 `xml:"checksumTotalBytes,omitempty"`
	ChecksumComparedBytes int64 `xml:"checksumComparedBytes,omitempty"`
}

func init() {
	t["ReplicationVmProgressInfo"] = reflect.TypeOf((*ReplicationVmProgressInfo)(nil)).Elem()
}

type RequestCanceled struct {
	RuntimeFault
}

func init() {
	t["RequestCanceled"] = reflect.TypeOf((*RequestCanceled)(nil)).Elem()
}

type RequestCanceledFault RequestCanceled

func init() {
	t["RequestCanceledFault"] = reflect.TypeOf((*RequestCanceledFault)(nil)).Elem()
}

type RescanAllHba RescanAllHbaRequestType

func init() {
	t["RescanAllHba"] = reflect.TypeOf((*RescanAllHba)(nil)).Elem()
}

type RescanAllHbaRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RescanAllHbaRequestType"] = reflect.TypeOf((*RescanAllHbaRequestType)(nil)).Elem()
}

type RescanAllHbaResponse struct {
}

type RescanHba RescanHbaRequestType

func init() {
	t["RescanHba"] = reflect.TypeOf((*RescanHba)(nil)).Elem()
}

type RescanHbaRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	HbaDevice string                 `xml:"hbaDevice"`
}

func init() {
	t["RescanHbaRequestType"] = reflect.TypeOf((*RescanHbaRequestType)(nil)).Elem()
}

type RescanHbaResponse struct {
}

type RescanVffs RescanVffsRequestType

func init() {
	t["RescanVffs"] = reflect.TypeOf((*RescanVffs)(nil)).Elem()
}

type RescanVffsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RescanVffsRequestType"] = reflect.TypeOf((*RescanVffsRequestType)(nil)).Elem()
}

type RescanVffsResponse struct {
}

type RescanVmfs RescanVmfsRequestType

func init() {
	t["RescanVmfs"] = reflect.TypeOf((*RescanVmfs)(nil)).Elem()
}

type RescanVmfsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RescanVmfsRequestType"] = reflect.TypeOf((*RescanVmfsRequestType)(nil)).Elem()
}

type RescanVmfsResponse struct {
}

type ResetCollector ResetCollectorRequestType

func init() {
	t["ResetCollector"] = reflect.TypeOf((*ResetCollector)(nil)).Elem()
}

type ResetCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ResetCollectorRequestType"] = reflect.TypeOf((*ResetCollectorRequestType)(nil)).Elem()
}

type ResetCollectorResponse struct {
}

type ResetCounterLevelMapping ResetCounterLevelMappingRequestType

func init() {
	t["ResetCounterLevelMapping"] = reflect.TypeOf((*ResetCounterLevelMapping)(nil)).Elem()
}

type ResetCounterLevelMappingRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	Counters []int                  `xml:"counters"`
}

func init() {
	t["ResetCounterLevelMappingRequestType"] = reflect.TypeOf((*ResetCounterLevelMappingRequestType)(nil)).Elem()
}

type ResetCounterLevelMappingResponse struct {
}

type ResetEntityPermissions ResetEntityPermissionsRequestType

func init() {
	t["ResetEntityPermissions"] = reflect.TypeOf((*ResetEntityPermissions)(nil)).Elem()
}

type ResetEntityPermissionsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Entity     ManagedObjectReference `xml:"entity"`
	Permission []Permission           `xml:"permission,omitempty"`
}

func init() {
	t["ResetEntityPermissionsRequestType"] = reflect.TypeOf((*ResetEntityPermissionsRequestType)(nil)).Elem()
}

type ResetEntityPermissionsResponse struct {
}

type ResetFirmwareToFactoryDefaults ResetFirmwareToFactoryDefaultsRequestType

func init() {
	t["ResetFirmwareToFactoryDefaults"] = reflect.TypeOf((*ResetFirmwareToFactoryDefaults)(nil)).Elem()
}

type ResetFirmwareToFactoryDefaultsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ResetFirmwareToFactoryDefaultsRequestType"] = reflect.TypeOf((*ResetFirmwareToFactoryDefaultsRequestType)(nil)).Elem()
}

type ResetFirmwareToFactoryDefaultsResponse struct {
}

type ResetGuestInformation ResetGuestInformationRequestType

func init() {
	t["ResetGuestInformation"] = reflect.TypeOf((*ResetGuestInformation)(nil)).Elem()
}

type ResetGuestInformationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ResetGuestInformationRequestType"] = reflect.TypeOf((*ResetGuestInformationRequestType)(nil)).Elem()
}

type ResetGuestInformationResponse struct {
}

type ResetListView ResetListViewRequestType

func init() {
	t["ResetListView"] = reflect.TypeOf((*ResetListView)(nil)).Elem()
}

type ResetListViewFromView ResetListViewFromViewRequestType

func init() {
	t["ResetListViewFromView"] = reflect.TypeOf((*ResetListViewFromView)(nil)).Elem()
}

type ResetListViewFromViewRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	View ManagedObjectReference `xml:"view"`
}

func init() {
	t["ResetListViewFromViewRequestType"] = reflect.TypeOf((*ResetListViewFromViewRequestType)(nil)).Elem()
}

type ResetListViewFromViewResponse struct {
}

type ResetListViewRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Obj  []ManagedObjectReference `xml:"obj,omitempty"`
}

func init() {
	t["ResetListViewRequestType"] = reflect.TypeOf((*ResetListViewRequestType)(nil)).Elem()
}

type ResetListViewResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type ResetSystemHealthInfo ResetSystemHealthInfoRequestType

func init() {
	t["ResetSystemHealthInfo"] = reflect.TypeOf((*ResetSystemHealthInfo)(nil)).Elem()
}

type ResetSystemHealthInfoRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ResetSystemHealthInfoRequestType"] = reflect.TypeOf((*ResetSystemHealthInfoRequestType)(nil)).Elem()
}

type ResetSystemHealthInfoResponse struct {
}

type ResetVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ResetVMRequestType"] = reflect.TypeOf((*ResetVMRequestType)(nil)).Elem()
}

type ResetVM_Task ResetVMRequestType

func init() {
	t["ResetVM_Task"] = reflect.TypeOf((*ResetVM_Task)(nil)).Elem()
}

type ResetVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ResignatureUnresolvedVmfsVolumeRequestType struct {
	This           ManagedObjectReference            `xml:"_this"`
	ResolutionSpec HostUnresolvedVmfsResignatureSpec `xml:"resolutionSpec"`
}

func init() {
	t["ResignatureUnresolvedVmfsVolumeRequestType"] = reflect.TypeOf((*ResignatureUnresolvedVmfsVolumeRequestType)(nil)).Elem()
}

type ResignatureUnresolvedVmfsVolume_Task ResignatureUnresolvedVmfsVolumeRequestType

func init() {
	t["ResignatureUnresolvedVmfsVolume_Task"] = reflect.TypeOf((*ResignatureUnresolvedVmfsVolume_Task)(nil)).Elem()
}

type ResignatureUnresolvedVmfsVolume_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ResolveMultipleUnresolvedVmfsVolumes ResolveMultipleUnresolvedVmfsVolumesRequestType

func init() {
	t["ResolveMultipleUnresolvedVmfsVolumes"] = reflect.TypeOf((*ResolveMultipleUnresolvedVmfsVolumes)(nil)).Elem()
}

type ResolveMultipleUnresolvedVmfsVolumesExRequestType struct {
	This           ManagedObjectReference             `xml:"_this"`
	ResolutionSpec []HostUnresolvedVmfsResolutionSpec `xml:"resolutionSpec"`
}

func init() {
	t["ResolveMultipleUnresolvedVmfsVolumesExRequestType"] = reflect.TypeOf((*ResolveMultipleUnresolvedVmfsVolumesExRequestType)(nil)).Elem()
}

type ResolveMultipleUnresolvedVmfsVolumesEx_Task ResolveMultipleUnresolvedVmfsVolumesExRequestType

func init() {
	t["ResolveMultipleUnresolvedVmfsVolumesEx_Task"] = reflect.TypeOf((*ResolveMultipleUnresolvedVmfsVolumesEx_Task)(nil)).Elem()
}

type ResolveMultipleUnresolvedVmfsVolumesEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ResolveMultipleUnresolvedVmfsVolumesRequestType struct {
	This           ManagedObjectReference             `xml:"_this"`
	ResolutionSpec []HostUnresolvedVmfsResolutionSpec `xml:"resolutionSpec"`
}

func init() {
	t["ResolveMultipleUnresolvedVmfsVolumesRequestType"] = reflect.TypeOf((*ResolveMultipleUnresolvedVmfsVolumesRequestType)(nil)).Elem()
}

type ResolveMultipleUnresolvedVmfsVolumesResponse struct {
	Returnval []HostUnresolvedVmfsResolutionResult `xml:"returnval,omitempty"`
}

type ResourceAllocationInfo struct {
	DynamicData

	Reservation           int64       `xml:"reservation,omitempty"`
	ExpandableReservation *bool       `xml:"expandableReservation"`
	Limit                 int64       `xml:"limit,omitempty"`
	Shares                *SharesInfo `xml:"shares,omitempty"`
	OverheadLimit         int64       `xml:"overheadLimit,omitempty"`
}

func init() {
	t["ResourceAllocationInfo"] = reflect.TypeOf((*ResourceAllocationInfo)(nil)).Elem()
}

type ResourceAllocationOption struct {
	DynamicData

	SharesOption SharesOption `xml:"sharesOption"`
}

func init() {
	t["ResourceAllocationOption"] = reflect.TypeOf((*ResourceAllocationOption)(nil)).Elem()
}

type ResourceConfigOption struct {
	DynamicData

	CpuAllocationOption    ResourceAllocationOption `xml:"cpuAllocationOption"`
	MemoryAllocationOption ResourceAllocationOption `xml:"memoryAllocationOption"`
}

func init() {
	t["ResourceConfigOption"] = reflect.TypeOf((*ResourceConfigOption)(nil)).Elem()
}

type ResourceConfigSpec struct {
	DynamicData

	Entity           *ManagedObjectReference `xml:"entity,omitempty"`
	ChangeVersion    string                  `xml:"changeVersion,omitempty"`
	LastModified     *time.Time              `xml:"lastModified"`
	CpuAllocation    ResourceAllocationInfo  `xml:"cpuAllocation"`
	MemoryAllocation ResourceAllocationInfo  `xml:"memoryAllocation"`
}

func init() {
	t["ResourceConfigSpec"] = reflect.TypeOf((*ResourceConfigSpec)(nil)).Elem()
}

type ResourceInUse struct {
	VimFault

	Type string `xml:"type,omitempty"`
	Name string `xml:"name,omitempty"`
}

func init() {
	t["ResourceInUse"] = reflect.TypeOf((*ResourceInUse)(nil)).Elem()
}

type ResourceInUseFault BaseResourceInUse

func init() {
	t["ResourceInUseFault"] = reflect.TypeOf((*ResourceInUseFault)(nil)).Elem()
}

type ResourceNotAvailable struct {
	VimFault

	ContainerType string `xml:"containerType,omitempty"`
	ContainerName string `xml:"containerName,omitempty"`
	Type          string `xml:"type,omitempty"`
}

func init() {
	t["ResourceNotAvailable"] = reflect.TypeOf((*ResourceNotAvailable)(nil)).Elem()
}

type ResourceNotAvailableFault ResourceNotAvailable

func init() {
	t["ResourceNotAvailableFault"] = reflect.TypeOf((*ResourceNotAvailableFault)(nil)).Elem()
}

type ResourcePoolCreatedEvent struct {
	ResourcePoolEvent

	Parent ResourcePoolEventArgument `xml:"parent"`
}

func init() {
	t["ResourcePoolCreatedEvent"] = reflect.TypeOf((*ResourcePoolCreatedEvent)(nil)).Elem()
}

type ResourcePoolDestroyedEvent struct {
	ResourcePoolEvent
}

func init() {
	t["ResourcePoolDestroyedEvent"] = reflect.TypeOf((*ResourcePoolDestroyedEvent)(nil)).Elem()
}

type ResourcePoolEvent struct {
	Event

	ResourcePool ResourcePoolEventArgument `xml:"resourcePool"`
}

func init() {
	t["ResourcePoolEvent"] = reflect.TypeOf((*ResourcePoolEvent)(nil)).Elem()
}

type ResourcePoolEventArgument struct {
	EntityEventArgument

	ResourcePool ManagedObjectReference `xml:"resourcePool"`
}

func init() {
	t["ResourcePoolEventArgument"] = reflect.TypeOf((*ResourcePoolEventArgument)(nil)).Elem()
}

type ResourcePoolMovedEvent struct {
	ResourcePoolEvent

	OldParent ResourcePoolEventArgument `xml:"oldParent"`
	NewParent ResourcePoolEventArgument `xml:"newParent"`
}

func init() {
	t["ResourcePoolMovedEvent"] = reflect.TypeOf((*ResourcePoolMovedEvent)(nil)).Elem()
}

type ResourcePoolQuickStats struct {
	DynamicData

	OverallCpuUsage              int64 `xml:"overallCpuUsage,omitempty"`
	OverallCpuDemand             int64 `xml:"overallCpuDemand,omitempty"`
	GuestMemoryUsage             int64 `xml:"guestMemoryUsage,omitempty"`
	HostMemoryUsage              int64 `xml:"hostMemoryUsage,omitempty"`
	DistributedCpuEntitlement    int64 `xml:"distributedCpuEntitlement,omitempty"`
	DistributedMemoryEntitlement int64 `xml:"distributedMemoryEntitlement,omitempty"`
	StaticCpuEntitlement         int   `xml:"staticCpuEntitlement,omitempty"`
	StaticMemoryEntitlement      int   `xml:"staticMemoryEntitlement,omitempty"`
	PrivateMemory                int64 `xml:"privateMemory,omitempty"`
	SharedMemory                 int64 `xml:"sharedMemory,omitempty"`
	SwappedMemory                int64 `xml:"swappedMemory,omitempty"`
	BalloonedMemory              int64 `xml:"balloonedMemory,omitempty"`
	OverheadMemory               int64 `xml:"overheadMemory,omitempty"`
	ConsumedOverheadMemory       int64 `xml:"consumedOverheadMemory,omitempty"`
	CompressedMemory             int64 `xml:"compressedMemory,omitempty"`
}

func init() {
	t["ResourcePoolQuickStats"] = reflect.TypeOf((*ResourcePoolQuickStats)(nil)).Elem()
}

type ResourcePoolReconfiguredEvent struct {
	ResourcePoolEvent
}

func init() {
	t["ResourcePoolReconfiguredEvent"] = reflect.TypeOf((*ResourcePoolReconfiguredEvent)(nil)).Elem()
}

type ResourcePoolResourceUsage struct {
	DynamicData

	ReservationUsed      int64 `xml:"reservationUsed"`
	ReservationUsedForVm int64 `xml:"reservationUsedForVm"`
	UnreservedForPool    int64 `xml:"unreservedForPool"`
	UnreservedForVm      int64 `xml:"unreservedForVm"`
	OverallUsage         int64 `xml:"overallUsage"`
	MaxUsage             int64 `xml:"maxUsage"`
}

func init() {
	t["ResourcePoolResourceUsage"] = reflect.TypeOf((*ResourcePoolResourceUsage)(nil)).Elem()
}

type ResourcePoolRuntimeInfo struct {
	DynamicData

	Memory        ResourcePoolResourceUsage `xml:"memory"`
	Cpu           ResourcePoolResourceUsage `xml:"cpu"`
	OverallStatus ManagedEntityStatus       `xml:"overallStatus"`
}

func init() {
	t["ResourcePoolRuntimeInfo"] = reflect.TypeOf((*ResourcePoolRuntimeInfo)(nil)).Elem()
}

type ResourcePoolSummary struct {
	DynamicData

	Name               string                  `xml:"name"`
	Config             ResourceConfigSpec      `xml:"config"`
	Runtime            ResourcePoolRuntimeInfo `xml:"runtime"`
	QuickStats         *ResourcePoolQuickStats `xml:"quickStats,omitempty"`
	ConfiguredMemoryMB int                     `xml:"configuredMemoryMB,omitempty"`
}

func init() {
	t["ResourcePoolSummary"] = reflect.TypeOf((*ResourcePoolSummary)(nil)).Elem()
}

type ResourceViolatedEvent struct {
	ResourcePoolEvent
}

func init() {
	t["ResourceViolatedEvent"] = reflect.TypeOf((*ResourceViolatedEvent)(nil)).Elem()
}

type RestartService RestartServiceRequestType

func init() {
	t["RestartService"] = reflect.TypeOf((*RestartService)(nil)).Elem()
}

type RestartServiceConsoleVirtualNic RestartServiceConsoleVirtualNicRequestType

func init() {
	t["RestartServiceConsoleVirtualNic"] = reflect.TypeOf((*RestartServiceConsoleVirtualNic)(nil)).Elem()
}

type RestartServiceConsoleVirtualNicRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Device string                 `xml:"device"`
}

func init() {
	t["RestartServiceConsoleVirtualNicRequestType"] = reflect.TypeOf((*RestartServiceConsoleVirtualNicRequestType)(nil)).Elem()
}

type RestartServiceConsoleVirtualNicResponse struct {
}

type RestartServiceRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["RestartServiceRequestType"] = reflect.TypeOf((*RestartServiceRequestType)(nil)).Elem()
}

type RestartServiceResponse struct {
}

type RestoreFirmwareConfiguration RestoreFirmwareConfigurationRequestType

func init() {
	t["RestoreFirmwareConfiguration"] = reflect.TypeOf((*RestoreFirmwareConfiguration)(nil)).Elem()
}

type RestoreFirmwareConfigurationRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Force bool                   `xml:"force"`
}

func init() {
	t["RestoreFirmwareConfigurationRequestType"] = reflect.TypeOf((*RestoreFirmwareConfigurationRequestType)(nil)).Elem()
}

type RestoreFirmwareConfigurationResponse struct {
}

type RestrictedVersion struct {
	SecurityError
}

func init() {
	t["RestrictedVersion"] = reflect.TypeOf((*RestrictedVersion)(nil)).Elem()
}

type RestrictedVersionFault RestrictedVersion

func init() {
	t["RestrictedVersionFault"] = reflect.TypeOf((*RestrictedVersionFault)(nil)).Elem()
}

type RetrieveAllPermissions RetrieveAllPermissionsRequestType

func init() {
	t["RetrieveAllPermissions"] = reflect.TypeOf((*RetrieveAllPermissions)(nil)).Elem()
}

type RetrieveAllPermissionsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RetrieveAllPermissionsRequestType"] = reflect.TypeOf((*RetrieveAllPermissionsRequestType)(nil)).Elem()
}

type RetrieveAllPermissionsResponse struct {
	Returnval []Permission `xml:"returnval,omitempty"`
}

type RetrieveAnswerFile RetrieveAnswerFileRequestType

func init() {
	t["RetrieveAnswerFile"] = reflect.TypeOf((*RetrieveAnswerFile)(nil)).Elem()
}

type RetrieveAnswerFileForProfile RetrieveAnswerFileForProfileRequestType

func init() {
	t["RetrieveAnswerFileForProfile"] = reflect.TypeOf((*RetrieveAnswerFileForProfile)(nil)).Elem()
}

type RetrieveAnswerFileForProfileRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Host         ManagedObjectReference `xml:"host"`
	ApplyProfile HostApplyProfile       `xml:"applyProfile"`
}

func init() {
	t["RetrieveAnswerFileForProfileRequestType"] = reflect.TypeOf((*RetrieveAnswerFileForProfileRequestType)(nil)).Elem()
}

type RetrieveAnswerFileForProfileResponse struct {
	Returnval *AnswerFile `xml:"returnval,omitempty"`
}

type RetrieveAnswerFileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["RetrieveAnswerFileRequestType"] = reflect.TypeOf((*RetrieveAnswerFileRequestType)(nil)).Elem()
}

type RetrieveAnswerFileResponse struct {
	Returnval *AnswerFile `xml:"returnval,omitempty"`
}

type RetrieveArgumentDescription RetrieveArgumentDescriptionRequestType

func init() {
	t["RetrieveArgumentDescription"] = reflect.TypeOf((*RetrieveArgumentDescription)(nil)).Elem()
}

type RetrieveArgumentDescriptionRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	EventTypeId string                 `xml:"eventTypeId"`
}

func init() {
	t["RetrieveArgumentDescriptionRequestType"] = reflect.TypeOf((*RetrieveArgumentDescriptionRequestType)(nil)).Elem()
}

type RetrieveArgumentDescriptionResponse struct {
	Returnval []EventArgDesc `xml:"returnval,omitempty"`
}

type RetrieveDasAdvancedRuntimeInfo RetrieveDasAdvancedRuntimeInfoRequestType

func init() {
	t["RetrieveDasAdvancedRuntimeInfo"] = reflect.TypeOf((*RetrieveDasAdvancedRuntimeInfo)(nil)).Elem()
}

type RetrieveDasAdvancedRuntimeInfoRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RetrieveDasAdvancedRuntimeInfoRequestType"] = reflect.TypeOf((*RetrieveDasAdvancedRuntimeInfoRequestType)(nil)).Elem()
}

type RetrieveDasAdvancedRuntimeInfoResponse struct {
	Returnval BaseClusterDasAdvancedRuntimeInfo `xml:"returnval,omitempty,typeattr"`
}

type RetrieveDescription RetrieveDescriptionRequestType

func init() {
	t["RetrieveDescription"] = reflect.TypeOf((*RetrieveDescription)(nil)).Elem()
}

type RetrieveDescriptionRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RetrieveDescriptionRequestType"] = reflect.TypeOf((*RetrieveDescriptionRequestType)(nil)).Elem()
}

type RetrieveDescriptionResponse struct {
	Returnval *ProfileDescription `xml:"returnval,omitempty"`
}

type RetrieveDiskPartitionInfo RetrieveDiskPartitionInfoRequestType

func init() {
	t["RetrieveDiskPartitionInfo"] = reflect.TypeOf((*RetrieveDiskPartitionInfo)(nil)).Elem()
}

type RetrieveDiskPartitionInfoRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	DevicePath []string               `xml:"devicePath"`
}

func init() {
	t["RetrieveDiskPartitionInfoRequestType"] = reflect.TypeOf((*RetrieveDiskPartitionInfoRequestType)(nil)).Elem()
}

type RetrieveDiskPartitionInfoResponse struct {
	Returnval []HostDiskPartitionInfo `xml:"returnval,omitempty"`
}

type RetrieveEntityPermissions RetrieveEntityPermissionsRequestType

func init() {
	t["RetrieveEntityPermissions"] = reflect.TypeOf((*RetrieveEntityPermissions)(nil)).Elem()
}

type RetrieveEntityPermissionsRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Entity    ManagedObjectReference `xml:"entity"`
	Inherited bool                   `xml:"inherited"`
}

func init() {
	t["RetrieveEntityPermissionsRequestType"] = reflect.TypeOf((*RetrieveEntityPermissionsRequestType)(nil)).Elem()
}

type RetrieveEntityPermissionsResponse struct {
	Returnval []Permission `xml:"returnval,omitempty"`
}

type RetrieveEntityScheduledTask RetrieveEntityScheduledTaskRequestType

func init() {
	t["RetrieveEntityScheduledTask"] = reflect.TypeOf((*RetrieveEntityScheduledTask)(nil)).Elem()
}

type RetrieveEntityScheduledTaskRequestType struct {
	This   ManagedObjectReference  `xml:"_this"`
	Entity *ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["RetrieveEntityScheduledTaskRequestType"] = reflect.TypeOf((*RetrieveEntityScheduledTaskRequestType)(nil)).Elem()
}

type RetrieveEntityScheduledTaskResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type RetrieveHardwareUptime RetrieveHardwareUptimeRequestType

func init() {
	t["RetrieveHardwareUptime"] = reflect.TypeOf((*RetrieveHardwareUptime)(nil)).Elem()
}

type RetrieveHardwareUptimeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RetrieveHardwareUptimeRequestType"] = reflect.TypeOf((*RetrieveHardwareUptimeRequestType)(nil)).Elem()
}

type RetrieveHardwareUptimeResponse struct {
	Returnval int64 `xml:"returnval"`
}

type RetrieveObjectScheduledTask RetrieveObjectScheduledTaskRequestType

func init() {
	t["RetrieveObjectScheduledTask"] = reflect.TypeOf((*RetrieveObjectScheduledTask)(nil)).Elem()
}

type RetrieveObjectScheduledTaskRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Obj  *ManagedObjectReference `xml:"obj,omitempty"`
}

func init() {
	t["RetrieveObjectScheduledTaskRequestType"] = reflect.TypeOf((*RetrieveObjectScheduledTaskRequestType)(nil)).Elem()
}

type RetrieveObjectScheduledTaskResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type RetrieveOptions struct {
	DynamicData

	MaxObjects int `xml:"maxObjects,omitempty"`
}

func init() {
	t["RetrieveOptions"] = reflect.TypeOf((*RetrieveOptions)(nil)).Elem()
}

type RetrieveProductComponents RetrieveProductComponentsRequestType

func init() {
	t["RetrieveProductComponents"] = reflect.TypeOf((*RetrieveProductComponents)(nil)).Elem()
}

type RetrieveProductComponentsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RetrieveProductComponentsRequestType"] = reflect.TypeOf((*RetrieveProductComponentsRequestType)(nil)).Elem()
}

type RetrieveProductComponentsResponse struct {
	Returnval []ProductComponentInfo `xml:"returnval,omitempty"`
}

type RetrieveProperties RetrievePropertiesRequestType

func init() {
	t["RetrieveProperties"] = reflect.TypeOf((*RetrieveProperties)(nil)).Elem()
}

type RetrievePropertiesEx RetrievePropertiesExRequestType

func init() {
	t["RetrievePropertiesEx"] = reflect.TypeOf((*RetrievePropertiesEx)(nil)).Elem()
}

type RetrievePropertiesExRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	SpecSet []PropertyFilterSpec   `xml:"specSet"`
	Options RetrieveOptions        `xml:"options"`
}

func init() {
	t["RetrievePropertiesExRequestType"] = reflect.TypeOf((*RetrievePropertiesExRequestType)(nil)).Elem()
}

type RetrievePropertiesExResponse struct {
	Returnval *RetrieveResult `xml:"returnval,omitempty"`
}

type RetrievePropertiesRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	SpecSet []PropertyFilterSpec   `xml:"specSet"`
}

func init() {
	t["RetrievePropertiesRequestType"] = reflect.TypeOf((*RetrievePropertiesRequestType)(nil)).Elem()
}

type RetrievePropertiesResponse struct {
	Returnval []ObjectContent `xml:"returnval,omitempty"`
}

type RetrieveResult struct {
	DynamicData

	Token   string          `xml:"token,omitempty"`
	Objects []ObjectContent `xml:"objects"`
}

func init() {
	t["RetrieveResult"] = reflect.TypeOf((*RetrieveResult)(nil)).Elem()
}

type RetrieveRolePermissions RetrieveRolePermissionsRequestType

func init() {
	t["RetrieveRolePermissions"] = reflect.TypeOf((*RetrieveRolePermissions)(nil)).Elem()
}

type RetrieveRolePermissionsRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	RoleId int                    `xml:"roleId"`
}

func init() {
	t["RetrieveRolePermissionsRequestType"] = reflect.TypeOf((*RetrieveRolePermissionsRequestType)(nil)).Elem()
}

type RetrieveRolePermissionsResponse struct {
	Returnval []Permission `xml:"returnval,omitempty"`
}

type RetrieveServiceContent RetrieveServiceContentRequestType

func init() {
	t["RetrieveServiceContent"] = reflect.TypeOf((*RetrieveServiceContent)(nil)).Elem()
}

type RetrieveServiceContentRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RetrieveServiceContentRequestType"] = reflect.TypeOf((*RetrieveServiceContentRequestType)(nil)).Elem()
}

type RetrieveServiceContentResponse struct {
	Returnval ServiceContent `xml:"returnval"`
}

type RetrieveUserGroups RetrieveUserGroupsRequestType

func init() {
	t["RetrieveUserGroups"] = reflect.TypeOf((*RetrieveUserGroups)(nil)).Elem()
}

type RetrieveUserGroupsRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	Domain         string                 `xml:"domain,omitempty"`
	SearchStr      string                 `xml:"searchStr"`
	BelongsToGroup string                 `xml:"belongsToGroup,omitempty"`
	BelongsToUser  string                 `xml:"belongsToUser,omitempty"`
	ExactMatch     bool                   `xml:"exactMatch"`
	FindUsers      bool                   `xml:"findUsers"`
	FindGroups     bool                   `xml:"findGroups"`
}

func init() {
	t["RetrieveUserGroupsRequestType"] = reflect.TypeOf((*RetrieveUserGroupsRequestType)(nil)).Elem()
}

type RetrieveUserGroupsResponse struct {
	Returnval []BaseUserSearchResult `xml:"returnval,omitempty,typeattr"`
}

type RevertToCurrentSnapshotRequestType struct {
	This            ManagedObjectReference  `xml:"_this"`
	Host            *ManagedObjectReference `xml:"host,omitempty"`
	SuppressPowerOn *bool                   `xml:"suppressPowerOn"`
}

func init() {
	t["RevertToCurrentSnapshotRequestType"] = reflect.TypeOf((*RevertToCurrentSnapshotRequestType)(nil)).Elem()
}

type RevertToCurrentSnapshot_Task RevertToCurrentSnapshotRequestType

func init() {
	t["RevertToCurrentSnapshot_Task"] = reflect.TypeOf((*RevertToCurrentSnapshot_Task)(nil)).Elem()
}

type RevertToCurrentSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RevertToSnapshotRequestType struct {
	This            ManagedObjectReference  `xml:"_this"`
	Host            *ManagedObjectReference `xml:"host,omitempty"`
	SuppressPowerOn *bool                   `xml:"suppressPowerOn"`
}

func init() {
	t["RevertToSnapshotRequestType"] = reflect.TypeOf((*RevertToSnapshotRequestType)(nil)).Elem()
}

type RevertToSnapshot_Task RevertToSnapshotRequestType

func init() {
	t["RevertToSnapshot_Task"] = reflect.TypeOf((*RevertToSnapshot_Task)(nil)).Elem()
}

type RevertToSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type RewindCollector RewindCollectorRequestType

func init() {
	t["RewindCollector"] = reflect.TypeOf((*RewindCollector)(nil)).Elem()
}

type RewindCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RewindCollectorRequestType"] = reflect.TypeOf((*RewindCollectorRequestType)(nil)).Elem()
}

type RewindCollectorResponse struct {
}

type RoleAddedEvent struct {
	RoleEvent

	PrivilegeList []string `xml:"privilegeList,omitempty"`
}

func init() {
	t["RoleAddedEvent"] = reflect.TypeOf((*RoleAddedEvent)(nil)).Elem()
}

type RoleEvent struct {
	AuthorizationEvent

	Role RoleEventArgument `xml:"role"`
}

func init() {
	t["RoleEvent"] = reflect.TypeOf((*RoleEvent)(nil)).Elem()
}

type RoleEventArgument struct {
	EventArgument

	RoleId int    `xml:"roleId"`
	Name   string `xml:"name"`
}

func init() {
	t["RoleEventArgument"] = reflect.TypeOf((*RoleEventArgument)(nil)).Elem()
}

type RoleRemovedEvent struct {
	RoleEvent
}

func init() {
	t["RoleRemovedEvent"] = reflect.TypeOf((*RoleRemovedEvent)(nil)).Elem()
}

type RoleUpdatedEvent struct {
	RoleEvent

	PrivilegeList []string `xml:"privilegeList,omitempty"`
}

func init() {
	t["RoleUpdatedEvent"] = reflect.TypeOf((*RoleUpdatedEvent)(nil)).Elem()
}

type RollbackEvent struct {
	DvsEvent

	HostName   string `xml:"hostName"`
	MethodName string `xml:"methodName,omitempty"`
}

func init() {
	t["RollbackEvent"] = reflect.TypeOf((*RollbackEvent)(nil)).Elem()
}

type RollbackFailure struct {
	DvsFault

	EntityName string `xml:"entityName"`
	EntityType string `xml:"entityType"`
}

func init() {
	t["RollbackFailure"] = reflect.TypeOf((*RollbackFailure)(nil)).Elem()
}

type RollbackFailureFault RollbackFailure

func init() {
	t["RollbackFailureFault"] = reflect.TypeOf((*RollbackFailureFault)(nil)).Elem()
}

type RuleViolation struct {
	VmConfigFault

	Host *ManagedObjectReference `xml:"host,omitempty"`
	Rule BaseClusterRuleInfo     `xml:"rule,omitempty,typeattr"`
}

func init() {
	t["RuleViolation"] = reflect.TypeOf((*RuleViolation)(nil)).Elem()
}

type RuleViolationFault RuleViolation

func init() {
	t["RuleViolationFault"] = reflect.TypeOf((*RuleViolationFault)(nil)).Elem()
}

type RunScheduledTask RunScheduledTaskRequestType

func init() {
	t["RunScheduledTask"] = reflect.TypeOf((*RunScheduledTask)(nil)).Elem()
}

type RunScheduledTaskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["RunScheduledTaskRequestType"] = reflect.TypeOf((*RunScheduledTaskRequestType)(nil)).Elem()
}

type RunScheduledTaskResponse struct {
}

type RunScriptAction struct {
	Action

	Script string `xml:"script"`
}

func init() {
	t["RunScriptAction"] = reflect.TypeOf((*RunScriptAction)(nil)).Elem()
}

type RuntimeFault struct {
	MethodFault
}

func init() {
	t["RuntimeFault"] = reflect.TypeOf((*RuntimeFault)(nil)).Elem()
}

type RuntimeFaultFault BaseRuntimeFault

func init() {
	t["RuntimeFaultFault"] = reflect.TypeOf((*RuntimeFaultFault)(nil)).Elem()
}

type SSLDisabledFault struct {
	HostConnectFault
}

func init() {
	t["SSLDisabledFault"] = reflect.TypeOf((*SSLDisabledFault)(nil)).Elem()
}

type SSLDisabledFaultFault SSLDisabledFault

func init() {
	t["SSLDisabledFaultFault"] = reflect.TypeOf((*SSLDisabledFaultFault)(nil)).Elem()
}

type SSLVerifyFault struct {
	HostConnectFault

	SelfSigned bool   `xml:"selfSigned"`
	Thumbprint string `xml:"thumbprint"`
}

func init() {
	t["SSLVerifyFault"] = reflect.TypeOf((*SSLVerifyFault)(nil)).Elem()
}

type SSLVerifyFaultFault SSLVerifyFault

func init() {
	t["SSLVerifyFaultFault"] = reflect.TypeOf((*SSLVerifyFaultFault)(nil)).Elem()
}

type SSPIAuthentication struct {
	GuestAuthentication

	SspiToken string `xml:"sspiToken"`
}

func init() {
	t["SSPIAuthentication"] = reflect.TypeOf((*SSPIAuthentication)(nil)).Elem()
}

type SSPIChallenge struct {
	VimFault

	Base64Token string `xml:"base64Token"`
}

func init() {
	t["SSPIChallenge"] = reflect.TypeOf((*SSPIChallenge)(nil)).Elem()
}

type SSPIChallengeFault SSPIChallenge

func init() {
	t["SSPIChallengeFault"] = reflect.TypeOf((*SSPIChallengeFault)(nil)).Elem()
}

type ScanHostPatchRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Repository HostPatchManagerLocator `xml:"repository"`
	UpdateID   []string                `xml:"updateID,omitempty"`
}

func init() {
	t["ScanHostPatchRequestType"] = reflect.TypeOf((*ScanHostPatchRequestType)(nil)).Elem()
}

type ScanHostPatchV2RequestType struct {
	This       ManagedObjectReference                     `xml:"_this"`
	MetaUrls   []string                                   `xml:"metaUrls,omitempty"`
	BundleUrls []string                                   `xml:"bundleUrls,omitempty"`
	Spec       *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty"`
}

func init() {
	t["ScanHostPatchV2RequestType"] = reflect.TypeOf((*ScanHostPatchV2RequestType)(nil)).Elem()
}

type ScanHostPatchV2_Task ScanHostPatchV2RequestType

func init() {
	t["ScanHostPatchV2_Task"] = reflect.TypeOf((*ScanHostPatchV2_Task)(nil)).Elem()
}

type ScanHostPatchV2_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ScanHostPatch_Task ScanHostPatchRequestType

func init() {
	t["ScanHostPatch_Task"] = reflect.TypeOf((*ScanHostPatch_Task)(nil)).Elem()
}

type ScanHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ScheduledHardwareUpgradeInfo struct {
	DynamicData

	UpgradePolicy                  string                `xml:"upgradePolicy,omitempty"`
	VersionKey                     string                `xml:"versionKey,omitempty"`
	ScheduledHardwareUpgradeStatus string                `xml:"scheduledHardwareUpgradeStatus,omitempty"`
	Fault                          *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["ScheduledHardwareUpgradeInfo"] = reflect.TypeOf((*ScheduledHardwareUpgradeInfo)(nil)).Elem()
}

type ScheduledTaskCompletedEvent struct {
	ScheduledTaskEvent
}

func init() {
	t["ScheduledTaskCompletedEvent"] = reflect.TypeOf((*ScheduledTaskCompletedEvent)(nil)).Elem()
}

type ScheduledTaskCreatedEvent struct {
	ScheduledTaskEvent
}

func init() {
	t["ScheduledTaskCreatedEvent"] = reflect.TypeOf((*ScheduledTaskCreatedEvent)(nil)).Elem()
}

type ScheduledTaskDescription struct {
	DynamicData

	Action        []BaseTypeDescription    `xml:"action,typeattr"`
	SchedulerInfo []ScheduledTaskDetail    `xml:"schedulerInfo"`
	State         []BaseElementDescription `xml:"state,typeattr"`
	DayOfWeek     []BaseElementDescription `xml:"dayOfWeek,typeattr"`
	WeekOfMonth   []BaseElementDescription `xml:"weekOfMonth,typeattr"`
}

func init() {
	t["ScheduledTaskDescription"] = reflect.TypeOf((*ScheduledTaskDescription)(nil)).Elem()
}

type ScheduledTaskDetail struct {
	TypeDescription

	Frequency string `xml:"frequency"`
}

func init() {
	t["ScheduledTaskDetail"] = reflect.TypeOf((*ScheduledTaskDetail)(nil)).Elem()
}

type ScheduledTaskEmailCompletedEvent struct {
	ScheduledTaskEvent

	To string `xml:"to"`
}

func init() {
	t["ScheduledTaskEmailCompletedEvent"] = reflect.TypeOf((*ScheduledTaskEmailCompletedEvent)(nil)).Elem()
}

type ScheduledTaskEmailFailedEvent struct {
	ScheduledTaskEvent

	To     string               `xml:"to"`
	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["ScheduledTaskEmailFailedEvent"] = reflect.TypeOf((*ScheduledTaskEmailFailedEvent)(nil)).Elem()
}

type ScheduledTaskEvent struct {
	Event

	ScheduledTask ScheduledTaskEventArgument `xml:"scheduledTask"`
	Entity        ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["ScheduledTaskEvent"] = reflect.TypeOf((*ScheduledTaskEvent)(nil)).Elem()
}

type ScheduledTaskEventArgument struct {
	EntityEventArgument

	ScheduledTask ManagedObjectReference `xml:"scheduledTask"`
}

func init() {
	t["ScheduledTaskEventArgument"] = reflect.TypeOf((*ScheduledTaskEventArgument)(nil)).Elem()
}

type ScheduledTaskFailedEvent struct {
	ScheduledTaskEvent

	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["ScheduledTaskFailedEvent"] = reflect.TypeOf((*ScheduledTaskFailedEvent)(nil)).Elem()
}

type ScheduledTaskInfo struct {
	ScheduledTaskSpec

	ScheduledTask    ManagedObjectReference  `xml:"scheduledTask"`
	Entity           ManagedObjectReference  `xml:"entity"`
	LastModifiedTime time.Time               `xml:"lastModifiedTime"`
	LastModifiedUser string                  `xml:"lastModifiedUser"`
	NextRunTime      *time.Time              `xml:"nextRunTime"`
	PrevRunTime      *time.Time              `xml:"prevRunTime"`
	State            TaskInfoState           `xml:"state"`
	Error            *LocalizedMethodFault   `xml:"error,omitempty"`
	Result           AnyType                 `xml:"result,omitempty,typeattr"`
	Progress         int                     `xml:"progress,omitempty"`
	ActiveTask       *ManagedObjectReference `xml:"activeTask,omitempty"`
	TaskObject       *ManagedObjectReference `xml:"taskObject,omitempty"`
}

func init() {
	t["ScheduledTaskInfo"] = reflect.TypeOf((*ScheduledTaskInfo)(nil)).Elem()
}

type ScheduledTaskReconfiguredEvent struct {
	ScheduledTaskEvent
}

func init() {
	t["ScheduledTaskReconfiguredEvent"] = reflect.TypeOf((*ScheduledTaskReconfiguredEvent)(nil)).Elem()
}

type ScheduledTaskRemovedEvent struct {
	ScheduledTaskEvent
}

func init() {
	t["ScheduledTaskRemovedEvent"] = reflect.TypeOf((*ScheduledTaskRemovedEvent)(nil)).Elem()
}

type ScheduledTaskSpec struct {
	DynamicData

	Name         string            `xml:"name"`
	Description  string            `xml:"description"`
	Enabled      bool              `xml:"enabled"`
	Scheduler    BaseTaskScheduler `xml:"scheduler,typeattr"`
	Action       BaseAction        `xml:"action,typeattr"`
	Notification string            `xml:"notification,omitempty"`
}

func init() {
	t["ScheduledTaskSpec"] = reflect.TypeOf((*ScheduledTaskSpec)(nil)).Elem()
}

type ScheduledTaskStartedEvent struct {
	ScheduledTaskEvent
}

func init() {
	t["ScheduledTaskStartedEvent"] = reflect.TypeOf((*ScheduledTaskStartedEvent)(nil)).Elem()
}

type ScsiLun struct {
	HostDevice

	Key              string               `xml:"key,omitempty"`
	Uuid             string               `xml:"uuid"`
	Descriptor       []ScsiLunDescriptor  `xml:"descriptor,omitempty"`
	CanonicalName    string               `xml:"canonicalName,omitempty"`
	DisplayName      string               `xml:"displayName,omitempty"`
	LunType          string               `xml:"lunType"`
	Vendor           string               `xml:"vendor,omitempty"`
	Model            string               `xml:"model,omitempty"`
	Revision         string               `xml:"revision,omitempty"`
	ScsiLevel        int                  `xml:"scsiLevel,omitempty"`
	SerialNumber     string               `xml:"serialNumber,omitempty"`
	DurableName      *ScsiLunDurableName  `xml:"durableName,omitempty"`
	AlternateName    []ScsiLunDurableName `xml:"alternateName,omitempty"`
	StandardInquiry  []byte               `xml:"standardInquiry,omitempty"`
	QueueDepth       int                  `xml:"queueDepth,omitempty"`
	OperationalState []string             `xml:"operationalState"`
	Capabilities     *ScsiLunCapabilities `xml:"capabilities,omitempty"`
	VStorageSupport  string               `xml:"vStorageSupport,omitempty"`
}

func init() {
	t["ScsiLun"] = reflect.TypeOf((*ScsiLun)(nil)).Elem()
}

type ScsiLunCapabilities struct {
	DynamicData

	UpdateDisplayNameSupported bool `xml:"updateDisplayNameSupported"`
}

func init() {
	t["ScsiLunCapabilities"] = reflect.TypeOf((*ScsiLunCapabilities)(nil)).Elem()
}

type ScsiLunDescriptor struct {
	DynamicData

	Quality string `xml:"quality"`
	Id      string `xml:"id"`
}

func init() {
	t["ScsiLunDescriptor"] = reflect.TypeOf((*ScsiLunDescriptor)(nil)).Elem()
}

type ScsiLunDurableName struct {
	DynamicData

	Namespace   string `xml:"namespace"`
	NamespaceId byte   `xml:"namespaceId"`
	Data        []byte `xml:"data,omitempty"`
}

func init() {
	t["ScsiLunDurableName"] = reflect.TypeOf((*ScsiLunDurableName)(nil)).Elem()
}

type SeSparseVirtualDiskSpec struct {
	FileBackedVirtualDiskSpec

	GrainSizeKb int `xml:"grainSizeKb,omitempty"`
}

func init() {
	t["SeSparseVirtualDiskSpec"] = reflect.TypeOf((*SeSparseVirtualDiskSpec)(nil)).Elem()
}

type SearchDatastoreRequestType struct {
	This          ManagedObjectReference          `xml:"_this"`
	DatastorePath string                          `xml:"datastorePath"`
	SearchSpec    *HostDatastoreBrowserSearchSpec `xml:"searchSpec,omitempty"`
}

func init() {
	t["SearchDatastoreRequestType"] = reflect.TypeOf((*SearchDatastoreRequestType)(nil)).Elem()
}

type SearchDatastoreSubFoldersRequestType struct {
	This          ManagedObjectReference          `xml:"_this"`
	DatastorePath string                          `xml:"datastorePath"`
	SearchSpec    *HostDatastoreBrowserSearchSpec `xml:"searchSpec,omitempty"`
}

func init() {
	t["SearchDatastoreSubFoldersRequestType"] = reflect.TypeOf((*SearchDatastoreSubFoldersRequestType)(nil)).Elem()
}

type SearchDatastoreSubFolders_Task SearchDatastoreSubFoldersRequestType

func init() {
	t["SearchDatastoreSubFolders_Task"] = reflect.TypeOf((*SearchDatastoreSubFolders_Task)(nil)).Elem()
}

type SearchDatastoreSubFolders_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type SearchDatastore_Task SearchDatastoreRequestType

func init() {
	t["SearchDatastore_Task"] = reflect.TypeOf((*SearchDatastore_Task)(nil)).Elem()
}

type SearchDatastore_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type SecondaryVmAlreadyDisabled struct {
	VmFaultToleranceIssue

	InstanceUuid string `xml:"instanceUuid"`
}

func init() {
	t["SecondaryVmAlreadyDisabled"] = reflect.TypeOf((*SecondaryVmAlreadyDisabled)(nil)).Elem()
}

type SecondaryVmAlreadyDisabledFault SecondaryVmAlreadyDisabled

func init() {
	t["SecondaryVmAlreadyDisabledFault"] = reflect.TypeOf((*SecondaryVmAlreadyDisabledFault)(nil)).Elem()
}

type SecondaryVmAlreadyEnabled struct {
	VmFaultToleranceIssue

	InstanceUuid string `xml:"instanceUuid"`
}

func init() {
	t["SecondaryVmAlreadyEnabled"] = reflect.TypeOf((*SecondaryVmAlreadyEnabled)(nil)).Elem()
}

type SecondaryVmAlreadyEnabledFault SecondaryVmAlreadyEnabled

func init() {
	t["SecondaryVmAlreadyEnabledFault"] = reflect.TypeOf((*SecondaryVmAlreadyEnabledFault)(nil)).Elem()
}

type SecondaryVmAlreadyRegistered struct {
	VmFaultToleranceIssue

	InstanceUuid string `xml:"instanceUuid,omitempty"`
}

func init() {
	t["SecondaryVmAlreadyRegistered"] = reflect.TypeOf((*SecondaryVmAlreadyRegistered)(nil)).Elem()
}

type SecondaryVmAlreadyRegisteredFault SecondaryVmAlreadyRegistered

func init() {
	t["SecondaryVmAlreadyRegisteredFault"] = reflect.TypeOf((*SecondaryVmAlreadyRegisteredFault)(nil)).Elem()
}

type SecondaryVmNotRegistered struct {
	VmFaultToleranceIssue

	InstanceUuid string `xml:"instanceUuid,omitempty"`
}

func init() {
	t["SecondaryVmNotRegistered"] = reflect.TypeOf((*SecondaryVmNotRegistered)(nil)).Elem()
}

type SecondaryVmNotRegisteredFault SecondaryVmNotRegistered

func init() {
	t["SecondaryVmNotRegisteredFault"] = reflect.TypeOf((*SecondaryVmNotRegisteredFault)(nil)).Elem()
}

type SecurityError struct {
	RuntimeFault
}

func init() {
	t["SecurityError"] = reflect.TypeOf((*SecurityError)(nil)).Elem()
}

type SecurityErrorFault BaseSecurityError

func init() {
	t["SecurityErrorFault"] = reflect.TypeOf((*SecurityErrorFault)(nil)).Elem()
}

type SecurityProfile struct {
	ApplyProfile

	Permission []PermissionProfile `xml:"permission,omitempty"`
}

func init() {
	t["SecurityProfile"] = reflect.TypeOf((*SecurityProfile)(nil)).Elem()
}

type SelectActivePartition SelectActivePartitionRequestType

func init() {
	t["SelectActivePartition"] = reflect.TypeOf((*SelectActivePartition)(nil)).Elem()
}

type SelectActivePartitionRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Partition *HostScsiDiskPartition `xml:"partition,omitempty"`
}

func init() {
	t["SelectActivePartitionRequestType"] = reflect.TypeOf((*SelectActivePartitionRequestType)(nil)).Elem()
}

type SelectActivePartitionResponse struct {
}

type SelectVnic SelectVnicRequestType

func init() {
	t["SelectVnic"] = reflect.TypeOf((*SelectVnic)(nil)).Elem()
}

type SelectVnicForNicType SelectVnicForNicTypeRequestType

func init() {
	t["SelectVnicForNicType"] = reflect.TypeOf((*SelectVnicForNicType)(nil)).Elem()
}

type SelectVnicForNicTypeRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	NicType string                 `xml:"nicType"`
	Device  string                 `xml:"device"`
}

func init() {
	t["SelectVnicForNicTypeRequestType"] = reflect.TypeOf((*SelectVnicForNicTypeRequestType)(nil)).Elem()
}

type SelectVnicForNicTypeResponse struct {
}

type SelectVnicRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Device string                 `xml:"device"`
}

func init() {
	t["SelectVnicRequestType"] = reflect.TypeOf((*SelectVnicRequestType)(nil)).Elem()
}

type SelectVnicResponse struct {
}

type SelectionSet struct {
	DynamicData
}

func init() {
	t["SelectionSet"] = reflect.TypeOf((*SelectionSet)(nil)).Elem()
}

type SelectionSpec struct {
	DynamicData

	Name string `xml:"name,omitempty"`
}

func init() {
	t["SelectionSpec"] = reflect.TypeOf((*SelectionSpec)(nil)).Elem()
}

type SendEmailAction struct {
	Action

	ToList  string `xml:"toList"`
	CcList  string `xml:"ccList"`
	Subject string `xml:"subject"`
	Body    string `xml:"body"`
}

func init() {
	t["SendEmailAction"] = reflect.TypeOf((*SendEmailAction)(nil)).Elem()
}

type SendSNMPAction struct {
	Action
}

func init() {
	t["SendSNMPAction"] = reflect.TypeOf((*SendSNMPAction)(nil)).Elem()
}

type SendTestNotification SendTestNotificationRequestType

func init() {
	t["SendTestNotification"] = reflect.TypeOf((*SendTestNotification)(nil)).Elem()
}

type SendTestNotificationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["SendTestNotificationRequestType"] = reflect.TypeOf((*SendTestNotificationRequestType)(nil)).Elem()
}

type SendTestNotificationResponse struct {
}

type ServerLicenseExpiredEvent struct {
	LicenseEvent

	Product string `xml:"product"`
}

func init() {
	t["ServerLicenseExpiredEvent"] = reflect.TypeOf((*ServerLicenseExpiredEvent)(nil)).Elem()
}

type ServerStartedSessionEvent struct {
	SessionEvent
}

func init() {
	t["ServerStartedSessionEvent"] = reflect.TypeOf((*ServerStartedSessionEvent)(nil)).Elem()
}

type ServiceConsolePortGroupProfile struct {
	PortGroupProfile

	IpConfig IpAddressProfile `xml:"ipConfig"`
}

func init() {
	t["ServiceConsolePortGroupProfile"] = reflect.TypeOf((*ServiceConsolePortGroupProfile)(nil)).Elem()
}

type ServiceConsoleReservationInfo struct {
	DynamicData

	ServiceConsoleReservedCfg int64 `xml:"serviceConsoleReservedCfg"`
	ServiceConsoleReserved    int64 `xml:"serviceConsoleReserved"`
	Unreserved                int64 `xml:"unreserved"`
}

func init() {
	t["ServiceConsoleReservationInfo"] = reflect.TypeOf((*ServiceConsoleReservationInfo)(nil)).Elem()
}

type ServiceContent struct {
	DynamicData

	RootFolder                ManagedObjectReference  `xml:"rootFolder"`
	PropertyCollector         ManagedObjectReference  `xml:"propertyCollector"`
	ViewManager               *ManagedObjectReference `xml:"viewManager,omitempty"`
	About                     AboutInfo               `xml:"about"`
	Setting                   *ManagedObjectReference `xml:"setting,omitempty"`
	UserDirectory             *ManagedObjectReference `xml:"userDirectory,omitempty"`
	SessionManager            *ManagedObjectReference `xml:"sessionManager,omitempty"`
	AuthorizationManager      *ManagedObjectReference `xml:"authorizationManager,omitempty"`
	ServiceManager            *ManagedObjectReference `xml:"serviceManager,omitempty"`
	PerfManager               *ManagedObjectReference `xml:"perfManager,omitempty"`
	ScheduledTaskManager      *ManagedObjectReference `xml:"scheduledTaskManager,omitempty"`
	AlarmManager              *ManagedObjectReference `xml:"alarmManager,omitempty"`
	EventManager              *ManagedObjectReference `xml:"eventManager,omitempty"`
	TaskManager               *ManagedObjectReference `xml:"taskManager,omitempty"`
	ExtensionManager          *ManagedObjectReference `xml:"extensionManager,omitempty"`
	CustomizationSpecManager  *ManagedObjectReference `xml:"customizationSpecManager,omitempty"`
	CustomFieldsManager       *ManagedObjectReference `xml:"customFieldsManager,omitempty"`
	AccountManager            *ManagedObjectReference `xml:"accountManager,omitempty"`
	DiagnosticManager         *ManagedObjectReference `xml:"diagnosticManager,omitempty"`
	LicenseManager            *ManagedObjectReference `xml:"licenseManager,omitempty"`
	SearchIndex               *ManagedObjectReference `xml:"searchIndex,omitempty"`
	FileManager               *ManagedObjectReference `xml:"fileManager,omitempty"`
	DatastoreNamespaceManager *ManagedObjectReference `xml:"datastoreNamespaceManager,omitempty"`
	VirtualDiskManager        *ManagedObjectReference `xml:"virtualDiskManager,omitempty"`
	VirtualizationManager     *ManagedObjectReference `xml:"virtualizationManager,omitempty"`
	SnmpSystem                *ManagedObjectReference `xml:"snmpSystem,omitempty"`
	VmProvisioningChecker     *ManagedObjectReference `xml:"vmProvisioningChecker,omitempty"`
	VmCompatibilityChecker    *ManagedObjectReference `xml:"vmCompatibilityChecker,omitempty"`
	OvfManager                *ManagedObjectReference `xml:"ovfManager,omitempty"`
	IpPoolManager             *ManagedObjectReference `xml:"ipPoolManager,omitempty"`
	DvSwitchManager           *ManagedObjectReference `xml:"dvSwitchManager,omitempty"`
	HostProfileManager        *ManagedObjectReference `xml:"hostProfileManager,omitempty"`
	ClusterProfileManager     *ManagedObjectReference `xml:"clusterProfileManager,omitempty"`
	ComplianceManager         *ManagedObjectReference `xml:"complianceManager,omitempty"`
	LocalizationManager       *ManagedObjectReference `xml:"localizationManager,omitempty"`
	StorageResourceManager    *ManagedObjectReference `xml:"storageResourceManager,omitempty"`
	GuestOperationsManager    *ManagedObjectReference `xml:"guestOperationsManager,omitempty"`
}

func init() {
	t["ServiceContent"] = reflect.TypeOf((*ServiceContent)(nil)).Elem()
}

type ServiceManagerServiceInfo struct {
	DynamicData

	ServiceName string                 `xml:"serviceName"`
	Location    []string               `xml:"location,omitempty"`
	Service     ManagedObjectReference `xml:"service"`
	Description string                 `xml:"description"`
}

func init() {
	t["ServiceManagerServiceInfo"] = reflect.TypeOf((*ServiceManagerServiceInfo)(nil)).Elem()
}

type ServiceProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["ServiceProfile"] = reflect.TypeOf((*ServiceProfile)(nil)).Elem()
}

type SessionEvent struct {
	Event
}

func init() {
	t["SessionEvent"] = reflect.TypeOf((*SessionEvent)(nil)).Elem()
}

type SessionIsActive SessionIsActiveRequestType

func init() {
	t["SessionIsActive"] = reflect.TypeOf((*SessionIsActive)(nil)).Elem()
}

type SessionIsActiveRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	SessionID string                 `xml:"sessionID"`
	UserName  string                 `xml:"userName"`
}

func init() {
	t["SessionIsActiveRequestType"] = reflect.TypeOf((*SessionIsActiveRequestType)(nil)).Elem()
}

type SessionIsActiveResponse struct {
	Returnval bool `xml:"returnval"`
}

type SessionManagerGenericServiceTicket struct {
	DynamicData

	Id            string `xml:"id"`
	HostName      string `xml:"hostName,omitempty"`
	SslThumbprint string `xml:"sslThumbprint,omitempty"`
}

func init() {
	t["SessionManagerGenericServiceTicket"] = reflect.TypeOf((*SessionManagerGenericServiceTicket)(nil)).Elem()
}

type SessionManagerHttpServiceRequestSpec struct {
	SessionManagerServiceRequestSpec

	Method string `xml:"method,omitempty"`
	Url    string `xml:"url"`
}

func init() {
	t["SessionManagerHttpServiceRequestSpec"] = reflect.TypeOf((*SessionManagerHttpServiceRequestSpec)(nil)).Elem()
}

type SessionManagerLocalTicket struct {
	DynamicData

	UserName         string `xml:"userName"`
	PasswordFilePath string `xml:"passwordFilePath"`
}

func init() {
	t["SessionManagerLocalTicket"] = reflect.TypeOf((*SessionManagerLocalTicket)(nil)).Elem()
}

type SessionManagerServiceRequestSpec struct {
	DynamicData
}

func init() {
	t["SessionManagerServiceRequestSpec"] = reflect.TypeOf((*SessionManagerServiceRequestSpec)(nil)).Elem()
}

type SessionManagerVmomiServiceRequestSpec struct {
	SessionManagerServiceRequestSpec

	Method string `xml:"method"`
}

func init() {
	t["SessionManagerVmomiServiceRequestSpec"] = reflect.TypeOf((*SessionManagerVmomiServiceRequestSpec)(nil)).Elem()
}

type SessionTerminatedEvent struct {
	SessionEvent

	SessionId          string `xml:"sessionId"`
	TerminatedUsername string `xml:"terminatedUsername"`
}

func init() {
	t["SessionTerminatedEvent"] = reflect.TypeOf((*SessionTerminatedEvent)(nil)).Elem()
}

type SetCollectorPageSize SetCollectorPageSizeRequestType

func init() {
	t["SetCollectorPageSize"] = reflect.TypeOf((*SetCollectorPageSize)(nil)).Elem()
}

type SetCollectorPageSizeRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	MaxCount int                    `xml:"maxCount"`
}

func init() {
	t["SetCollectorPageSizeRequestType"] = reflect.TypeOf((*SetCollectorPageSizeRequestType)(nil)).Elem()
}

type SetCollectorPageSizeResponse struct {
}

type SetDisplayTopology SetDisplayTopologyRequestType

func init() {
	t["SetDisplayTopology"] = reflect.TypeOf((*SetDisplayTopology)(nil)).Elem()
}

type SetDisplayTopologyRequestType struct {
	This     ManagedObjectReference          `xml:"_this"`
	Displays []VirtualMachineDisplayTopology `xml:"displays"`
}

func init() {
	t["SetDisplayTopologyRequestType"] = reflect.TypeOf((*SetDisplayTopologyRequestType)(nil)).Elem()
}

type SetDisplayTopologyResponse struct {
}

type SetEntityPermissions SetEntityPermissionsRequestType

func init() {
	t["SetEntityPermissions"] = reflect.TypeOf((*SetEntityPermissions)(nil)).Elem()
}

type SetEntityPermissionsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Entity     ManagedObjectReference `xml:"entity"`
	Permission []Permission           `xml:"permission,omitempty"`
}

func init() {
	t["SetEntityPermissionsRequestType"] = reflect.TypeOf((*SetEntityPermissionsRequestType)(nil)).Elem()
}

type SetEntityPermissionsResponse struct {
}

type SetExtensionCertificate SetExtensionCertificateRequestType

func init() {
	t["SetExtensionCertificate"] = reflect.TypeOf((*SetExtensionCertificate)(nil)).Elem()
}

type SetExtensionCertificateRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	ExtensionKey   string                 `xml:"extensionKey"`
	CertificatePem string                 `xml:"certificatePem,omitempty"`
}

func init() {
	t["SetExtensionCertificateRequestType"] = reflect.TypeOf((*SetExtensionCertificateRequestType)(nil)).Elem()
}

type SetExtensionCertificateResponse struct {
}

type SetField SetFieldRequestType

func init() {
	t["SetField"] = reflect.TypeOf((*SetField)(nil)).Elem()
}

type SetFieldRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Key    int                    `xml:"key"`
	Value  string                 `xml:"value"`
}

func init() {
	t["SetFieldRequestType"] = reflect.TypeOf((*SetFieldRequestType)(nil)).Elem()
}

type SetFieldResponse struct {
}

type SetLicenseEdition SetLicenseEditionRequestType

func init() {
	t["SetLicenseEdition"] = reflect.TypeOf((*SetLicenseEdition)(nil)).Elem()
}

type SetLicenseEditionRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
	FeatureKey string                  `xml:"featureKey,omitempty"`
}

func init() {
	t["SetLicenseEditionRequestType"] = reflect.TypeOf((*SetLicenseEditionRequestType)(nil)).Elem()
}

type SetLicenseEditionResponse struct {
}

type SetLocale SetLocaleRequestType

func init() {
	t["SetLocale"] = reflect.TypeOf((*SetLocale)(nil)).Elem()
}

type SetLocaleRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Locale string                 `xml:"locale"`
}

func init() {
	t["SetLocaleRequestType"] = reflect.TypeOf((*SetLocaleRequestType)(nil)).Elem()
}

type SetLocaleResponse struct {
}

type SetMultipathLunPolicy SetMultipathLunPolicyRequestType

func init() {
	t["SetMultipathLunPolicy"] = reflect.TypeOf((*SetMultipathLunPolicy)(nil)).Elem()
}

type SetMultipathLunPolicyRequestType struct {
	This   ManagedObjectReference                 `xml:"_this"`
	LunId  string                                 `xml:"lunId"`
	Policy BaseHostMultipathInfoLogicalUnitPolicy `xml:"policy,typeattr"`
}

func init() {
	t["SetMultipathLunPolicyRequestType"] = reflect.TypeOf((*SetMultipathLunPolicyRequestType)(nil)).Elem()
}

type SetMultipathLunPolicyResponse struct {
}

type SetPublicKey SetPublicKeyRequestType

func init() {
	t["SetPublicKey"] = reflect.TypeOf((*SetPublicKey)(nil)).Elem()
}

type SetPublicKeyRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
	PublicKey    string                 `xml:"publicKey"`
}

func init() {
	t["SetPublicKeyRequestType"] = reflect.TypeOf((*SetPublicKeyRequestType)(nil)).Elem()
}

type SetPublicKeyResponse struct {
}

type SetScreenResolution SetScreenResolutionRequestType

func init() {
	t["SetScreenResolution"] = reflect.TypeOf((*SetScreenResolution)(nil)).Elem()
}

type SetScreenResolutionRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Width  int                    `xml:"width"`
	Height int                    `xml:"height"`
}

func init() {
	t["SetScreenResolutionRequestType"] = reflect.TypeOf((*SetScreenResolutionRequestType)(nil)).Elem()
}

type SetScreenResolutionResponse struct {
}

type SetTaskDescription SetTaskDescriptionRequestType

func init() {
	t["SetTaskDescription"] = reflect.TypeOf((*SetTaskDescription)(nil)).Elem()
}

type SetTaskDescriptionRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Description LocalizableMessage     `xml:"description"`
}

func init() {
	t["SetTaskDescriptionRequestType"] = reflect.TypeOf((*SetTaskDescriptionRequestType)(nil)).Elem()
}

type SetTaskDescriptionResponse struct {
}

type SetTaskState SetTaskStateRequestType

func init() {
	t["SetTaskState"] = reflect.TypeOf((*SetTaskState)(nil)).Elem()
}

type SetTaskStateRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	State  TaskInfoState          `xml:"state"`
	Result AnyType                `xml:"result,omitempty,typeattr"`
	Fault  *LocalizedMethodFault  `xml:"fault,omitempty"`
}

func init() {
	t["SetTaskStateRequestType"] = reflect.TypeOf((*SetTaskStateRequestType)(nil)).Elem()
}

type SetTaskStateResponse struct {
}

type SetVirtualDiskUuid SetVirtualDiskUuidRequestType

func init() {
	t["SetVirtualDiskUuid"] = reflect.TypeOf((*SetVirtualDiskUuid)(nil)).Elem()
}

type SetVirtualDiskUuidRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Uuid       string                  `xml:"uuid"`
}

func init() {
	t["SetVirtualDiskUuidRequestType"] = reflect.TypeOf((*SetVirtualDiskUuidRequestType)(nil)).Elem()
}

type SetVirtualDiskUuidResponse struct {
}

type SharedBusControllerNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["SharedBusControllerNotSupported"] = reflect.TypeOf((*SharedBusControllerNotSupported)(nil)).Elem()
}

type SharedBusControllerNotSupportedFault SharedBusControllerNotSupported

func init() {
	t["SharedBusControllerNotSupportedFault"] = reflect.TypeOf((*SharedBusControllerNotSupportedFault)(nil)).Elem()
}

type SharesInfo struct {
	DynamicData

	Shares int         `xml:"shares"`
	Level  SharesLevel `xml:"level"`
}

func init() {
	t["SharesInfo"] = reflect.TypeOf((*SharesInfo)(nil)).Elem()
}

type SharesOption struct {
	DynamicData

	SharesOption IntOption   `xml:"sharesOption"`
	DefaultLevel SharesLevel `xml:"defaultLevel"`
}

func init() {
	t["SharesOption"] = reflect.TypeOf((*SharesOption)(nil)).Elem()
}

type ShrinkDiskFault struct {
	VimFault

	DiskId int `xml:"diskId,omitempty"`
}

func init() {
	t["ShrinkDiskFault"] = reflect.TypeOf((*ShrinkDiskFault)(nil)).Elem()
}

type ShrinkDiskFaultFault ShrinkDiskFault

func init() {
	t["ShrinkDiskFaultFault"] = reflect.TypeOf((*ShrinkDiskFaultFault)(nil)).Elem()
}

type ShrinkVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Copy       *bool                   `xml:"copy"`
}

func init() {
	t["ShrinkVirtualDiskRequestType"] = reflect.TypeOf((*ShrinkVirtualDiskRequestType)(nil)).Elem()
}

type ShrinkVirtualDisk_Task ShrinkVirtualDiskRequestType

func init() {
	t["ShrinkVirtualDisk_Task"] = reflect.TypeOf((*ShrinkVirtualDisk_Task)(nil)).Elem()
}

type ShrinkVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ShutdownGuest ShutdownGuestRequestType

func init() {
	t["ShutdownGuest"] = reflect.TypeOf((*ShutdownGuest)(nil)).Elem()
}

type ShutdownGuestRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ShutdownGuestRequestType"] = reflect.TypeOf((*ShutdownGuestRequestType)(nil)).Elem()
}

type ShutdownGuestResponse struct {
}

type ShutdownHostRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Force bool                   `xml:"force"`
}

func init() {
	t["ShutdownHostRequestType"] = reflect.TypeOf((*ShutdownHostRequestType)(nil)).Elem()
}

type ShutdownHost_Task ShutdownHostRequestType

func init() {
	t["ShutdownHost_Task"] = reflect.TypeOf((*ShutdownHost_Task)(nil)).Elem()
}

type ShutdownHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type SingleIp struct {
	IpAddress

	Address string `xml:"address"`
}

func init() {
	t["SingleIp"] = reflect.TypeOf((*SingleIp)(nil)).Elem()
}

type SingleMac struct {
	MacAddress

	Address string `xml:"address"`
}

func init() {
	t["SingleMac"] = reflect.TypeOf((*SingleMac)(nil)).Elem()
}

type SnapshotCloneNotSupported struct {
	SnapshotCopyNotSupported
}

func init() {
	t["SnapshotCloneNotSupported"] = reflect.TypeOf((*SnapshotCloneNotSupported)(nil)).Elem()
}

type SnapshotCloneNotSupportedFault SnapshotCloneNotSupported

func init() {
	t["SnapshotCloneNotSupportedFault"] = reflect.TypeOf((*SnapshotCloneNotSupportedFault)(nil)).Elem()
}

type SnapshotCopyNotSupported struct {
	MigrationFault
}

func init() {
	t["SnapshotCopyNotSupported"] = reflect.TypeOf((*SnapshotCopyNotSupported)(nil)).Elem()
}

type SnapshotCopyNotSupportedFault BaseSnapshotCopyNotSupported

func init() {
	t["SnapshotCopyNotSupportedFault"] = reflect.TypeOf((*SnapshotCopyNotSupportedFault)(nil)).Elem()
}

type SnapshotDisabled struct {
	SnapshotFault
}

func init() {
	t["SnapshotDisabled"] = reflect.TypeOf((*SnapshotDisabled)(nil)).Elem()
}

type SnapshotDisabledFault SnapshotDisabled

func init() {
	t["SnapshotDisabledFault"] = reflect.TypeOf((*SnapshotDisabledFault)(nil)).Elem()
}

type SnapshotFault struct {
	VimFault
}

func init() {
	t["SnapshotFault"] = reflect.TypeOf((*SnapshotFault)(nil)).Elem()
}

type SnapshotFaultFault BaseSnapshotFault

func init() {
	t["SnapshotFaultFault"] = reflect.TypeOf((*SnapshotFaultFault)(nil)).Elem()
}

type SnapshotIncompatibleDeviceInVm struct {
	SnapshotFault

	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["SnapshotIncompatibleDeviceInVm"] = reflect.TypeOf((*SnapshotIncompatibleDeviceInVm)(nil)).Elem()
}

type SnapshotIncompatibleDeviceInVmFault SnapshotIncompatibleDeviceInVm

func init() {
	t["SnapshotIncompatibleDeviceInVmFault"] = reflect.TypeOf((*SnapshotIncompatibleDeviceInVmFault)(nil)).Elem()
}

type SnapshotLocked struct {
	SnapshotFault
}

func init() {
	t["SnapshotLocked"] = reflect.TypeOf((*SnapshotLocked)(nil)).Elem()
}

type SnapshotLockedFault SnapshotLocked

func init() {
	t["SnapshotLockedFault"] = reflect.TypeOf((*SnapshotLockedFault)(nil)).Elem()
}

type SnapshotMoveFromNonHomeNotSupported struct {
	SnapshotCopyNotSupported
}

func init() {
	t["SnapshotMoveFromNonHomeNotSupported"] = reflect.TypeOf((*SnapshotMoveFromNonHomeNotSupported)(nil)).Elem()
}

type SnapshotMoveFromNonHomeNotSupportedFault SnapshotMoveFromNonHomeNotSupported

func init() {
	t["SnapshotMoveFromNonHomeNotSupportedFault"] = reflect.TypeOf((*SnapshotMoveFromNonHomeNotSupportedFault)(nil)).Elem()
}

type SnapshotMoveNotSupported struct {
	SnapshotCopyNotSupported
}

func init() {
	t["SnapshotMoveNotSupported"] = reflect.TypeOf((*SnapshotMoveNotSupported)(nil)).Elem()
}

type SnapshotMoveNotSupportedFault SnapshotMoveNotSupported

func init() {
	t["SnapshotMoveNotSupportedFault"] = reflect.TypeOf((*SnapshotMoveNotSupportedFault)(nil)).Elem()
}

type SnapshotMoveToNonHomeNotSupported struct {
	SnapshotCopyNotSupported
}

func init() {
	t["SnapshotMoveToNonHomeNotSupported"] = reflect.TypeOf((*SnapshotMoveToNonHomeNotSupported)(nil)).Elem()
}

type SnapshotMoveToNonHomeNotSupportedFault SnapshotMoveToNonHomeNotSupported

func init() {
	t["SnapshotMoveToNonHomeNotSupportedFault"] = reflect.TypeOf((*SnapshotMoveToNonHomeNotSupportedFault)(nil)).Elem()
}

type SnapshotNoChange struct {
	SnapshotFault
}

func init() {
	t["SnapshotNoChange"] = reflect.TypeOf((*SnapshotNoChange)(nil)).Elem()
}

type SnapshotNoChangeFault SnapshotNoChange

func init() {
	t["SnapshotNoChangeFault"] = reflect.TypeOf((*SnapshotNoChangeFault)(nil)).Elem()
}

type SnapshotRevertIssue struct {
	MigrationFault

	SnapshotName string      `xml:"snapshotName,omitempty"`
	Event        []BaseEvent `xml:"event,omitempty,typeattr"`
	Errors       bool        `xml:"errors"`
}

func init() {
	t["SnapshotRevertIssue"] = reflect.TypeOf((*SnapshotRevertIssue)(nil)).Elem()
}

type SnapshotRevertIssueFault SnapshotRevertIssue

func init() {
	t["SnapshotRevertIssueFault"] = reflect.TypeOf((*SnapshotRevertIssueFault)(nil)).Elem()
}

type SoftRuleVioCorrectionDisallowed struct {
	VmConfigFault

	VmName string `xml:"vmName"`
}

func init() {
	t["SoftRuleVioCorrectionDisallowed"] = reflect.TypeOf((*SoftRuleVioCorrectionDisallowed)(nil)).Elem()
}

type SoftRuleVioCorrectionDisallowedFault SoftRuleVioCorrectionDisallowed

func init() {
	t["SoftRuleVioCorrectionDisallowedFault"] = reflect.TypeOf((*SoftRuleVioCorrectionDisallowedFault)(nil)).Elem()
}

type SoftRuleVioCorrectionImpact struct {
	VmConfigFault

	VmName string `xml:"vmName"`
}

func init() {
	t["SoftRuleVioCorrectionImpact"] = reflect.TypeOf((*SoftRuleVioCorrectionImpact)(nil)).Elem()
}

type SoftRuleVioCorrectionImpactFault SoftRuleVioCorrectionImpact

func init() {
	t["SoftRuleVioCorrectionImpactFault"] = reflect.TypeOf((*SoftRuleVioCorrectionImpactFault)(nil)).Elem()
}

type SsdDiskNotAvailable struct {
	VimFault

	DevicePath string `xml:"devicePath"`
}

func init() {
	t["SsdDiskNotAvailable"] = reflect.TypeOf((*SsdDiskNotAvailable)(nil)).Elem()
}

type SsdDiskNotAvailableFault SsdDiskNotAvailable

func init() {
	t["SsdDiskNotAvailableFault"] = reflect.TypeOf((*SsdDiskNotAvailableFault)(nil)).Elem()
}

type StageHostPatchRequestType struct {
	This       ManagedObjectReference                     `xml:"_this"`
	MetaUrls   []string                                   `xml:"metaUrls,omitempty"`
	BundleUrls []string                                   `xml:"bundleUrls,omitempty"`
	VibUrls    []string                                   `xml:"vibUrls,omitempty"`
	Spec       *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty"`
}

func init() {
	t["StageHostPatchRequestType"] = reflect.TypeOf((*StageHostPatchRequestType)(nil)).Elem()
}

type StageHostPatch_Task StageHostPatchRequestType

func init() {
	t["StageHostPatch_Task"] = reflect.TypeOf((*StageHostPatch_Task)(nil)).Elem()
}

type StageHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type StandbyGuest StandbyGuestRequestType

func init() {
	t["StandbyGuest"] = reflect.TypeOf((*StandbyGuest)(nil)).Elem()
}

type StandbyGuestRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["StandbyGuestRequestType"] = reflect.TypeOf((*StandbyGuestRequestType)(nil)).Elem()
}

type StandbyGuestResponse struct {
}

type StartProgramInGuest StartProgramInGuestRequestType

func init() {
	t["StartProgramInGuest"] = reflect.TypeOf((*StartProgramInGuest)(nil)).Elem()
}

type StartProgramInGuestRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Auth BaseGuestAuthentication `xml:"auth,typeattr"`
	Spec BaseGuestProgramSpec    `xml:"spec,typeattr"`
}

func init() {
	t["StartProgramInGuestRequestType"] = reflect.TypeOf((*StartProgramInGuestRequestType)(nil)).Elem()
}

type StartProgramInGuestResponse struct {
	Returnval int64 `xml:"returnval"`
}

type StartRecordingRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Name        string                 `xml:"name"`
	Description string                 `xml:"description,omitempty"`
}

func init() {
	t["StartRecordingRequestType"] = reflect.TypeOf((*StartRecordingRequestType)(nil)).Elem()
}

type StartRecording_Task StartRecordingRequestType

func init() {
	t["StartRecording_Task"] = reflect.TypeOf((*StartRecording_Task)(nil)).Elem()
}

type StartRecording_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type StartReplayingRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	ReplaySnapshot ManagedObjectReference `xml:"replaySnapshot"`
}

func init() {
	t["StartReplayingRequestType"] = reflect.TypeOf((*StartReplayingRequestType)(nil)).Elem()
}

type StartReplaying_Task StartReplayingRequestType

func init() {
	t["StartReplaying_Task"] = reflect.TypeOf((*StartReplaying_Task)(nil)).Elem()
}

type StartReplaying_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type StartService StartServiceRequestType

func init() {
	t["StartService"] = reflect.TypeOf((*StartService)(nil)).Elem()
}

type StartServiceRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["StartServiceRequestType"] = reflect.TypeOf((*StartServiceRequestType)(nil)).Elem()
}

type StartServiceResponse struct {
}

type StateAlarmExpression struct {
	AlarmExpression

	Operator  StateAlarmOperator `xml:"operator"`
	Type      string             `xml:"type"`
	StatePath string             `xml:"statePath"`
	Yellow    string             `xml:"yellow,omitempty"`
	Red       string             `xml:"red,omitempty"`
}

func init() {
	t["StateAlarmExpression"] = reflect.TypeOf((*StateAlarmExpression)(nil)).Elem()
}

type StaticRouteProfile struct {
	ApplyProfile

	Key string `xml:"key,omitempty"`
}

func init() {
	t["StaticRouteProfile"] = reflect.TypeOf((*StaticRouteProfile)(nil)).Elem()
}

type StopRecordingRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["StopRecordingRequestType"] = reflect.TypeOf((*StopRecordingRequestType)(nil)).Elem()
}

type StopRecording_Task StopRecordingRequestType

func init() {
	t["StopRecording_Task"] = reflect.TypeOf((*StopRecording_Task)(nil)).Elem()
}

type StopRecording_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type StopReplayingRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["StopReplayingRequestType"] = reflect.TypeOf((*StopReplayingRequestType)(nil)).Elem()
}

type StopReplaying_Task StopReplayingRequestType

func init() {
	t["StopReplaying_Task"] = reflect.TypeOf((*StopReplaying_Task)(nil)).Elem()
}

type StopReplaying_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type StopService StopServiceRequestType

func init() {
	t["StopService"] = reflect.TypeOf((*StopService)(nil)).Elem()
}

type StopServiceRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["StopServiceRequestType"] = reflect.TypeOf((*StopServiceRequestType)(nil)).Elem()
}

type StopServiceResponse struct {
}

type StorageDrsCannotMoveDiskInMultiWriterMode struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveDiskInMultiWriterMode"] = reflect.TypeOf((*StorageDrsCannotMoveDiskInMultiWriterMode)(nil)).Elem()
}

type StorageDrsCannotMoveDiskInMultiWriterModeFault StorageDrsCannotMoveDiskInMultiWriterMode

func init() {
	t["StorageDrsCannotMoveDiskInMultiWriterModeFault"] = reflect.TypeOf((*StorageDrsCannotMoveDiskInMultiWriterModeFault)(nil)).Elem()
}

type StorageDrsCannotMoveFTVm struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveFTVm"] = reflect.TypeOf((*StorageDrsCannotMoveFTVm)(nil)).Elem()
}

type StorageDrsCannotMoveFTVmFault StorageDrsCannotMoveFTVm

func init() {
	t["StorageDrsCannotMoveFTVmFault"] = reflect.TypeOf((*StorageDrsCannotMoveFTVmFault)(nil)).Elem()
}

type StorageDrsCannotMoveIndependentDisk struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveIndependentDisk"] = reflect.TypeOf((*StorageDrsCannotMoveIndependentDisk)(nil)).Elem()
}

type StorageDrsCannotMoveIndependentDiskFault StorageDrsCannotMoveIndependentDisk

func init() {
	t["StorageDrsCannotMoveIndependentDiskFault"] = reflect.TypeOf((*StorageDrsCannotMoveIndependentDiskFault)(nil)).Elem()
}

type StorageDrsCannotMoveManuallyPlacedSwapFile struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveManuallyPlacedSwapFile"] = reflect.TypeOf((*StorageDrsCannotMoveManuallyPlacedSwapFile)(nil)).Elem()
}

type StorageDrsCannotMoveManuallyPlacedSwapFileFault StorageDrsCannotMoveManuallyPlacedSwapFile

func init() {
	t["StorageDrsCannotMoveManuallyPlacedSwapFileFault"] = reflect.TypeOf((*StorageDrsCannotMoveManuallyPlacedSwapFileFault)(nil)).Elem()
}

type StorageDrsCannotMoveManuallyPlacedVm struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveManuallyPlacedVm"] = reflect.TypeOf((*StorageDrsCannotMoveManuallyPlacedVm)(nil)).Elem()
}

type StorageDrsCannotMoveManuallyPlacedVmFault StorageDrsCannotMoveManuallyPlacedVm

func init() {
	t["StorageDrsCannotMoveManuallyPlacedVmFault"] = reflect.TypeOf((*StorageDrsCannotMoveManuallyPlacedVmFault)(nil)).Elem()
}

type StorageDrsCannotMoveSharedDisk struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveSharedDisk"] = reflect.TypeOf((*StorageDrsCannotMoveSharedDisk)(nil)).Elem()
}

type StorageDrsCannotMoveSharedDiskFault StorageDrsCannotMoveSharedDisk

func init() {
	t["StorageDrsCannotMoveSharedDiskFault"] = reflect.TypeOf((*StorageDrsCannotMoveSharedDiskFault)(nil)).Elem()
}

type StorageDrsCannotMoveTemplate struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveTemplate"] = reflect.TypeOf((*StorageDrsCannotMoveTemplate)(nil)).Elem()
}

type StorageDrsCannotMoveTemplateFault StorageDrsCannotMoveTemplate

func init() {
	t["StorageDrsCannotMoveTemplateFault"] = reflect.TypeOf((*StorageDrsCannotMoveTemplateFault)(nil)).Elem()
}

type StorageDrsCannotMoveVmInUserFolder struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveVmInUserFolder"] = reflect.TypeOf((*StorageDrsCannotMoveVmInUserFolder)(nil)).Elem()
}

type StorageDrsCannotMoveVmInUserFolderFault StorageDrsCannotMoveVmInUserFolder

func init() {
	t["StorageDrsCannotMoveVmInUserFolderFault"] = reflect.TypeOf((*StorageDrsCannotMoveVmInUserFolderFault)(nil)).Elem()
}

type StorageDrsCannotMoveVmWithMountedCDROM struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveVmWithMountedCDROM"] = reflect.TypeOf((*StorageDrsCannotMoveVmWithMountedCDROM)(nil)).Elem()
}

type StorageDrsCannotMoveVmWithMountedCDROMFault StorageDrsCannotMoveVmWithMountedCDROM

func init() {
	t["StorageDrsCannotMoveVmWithMountedCDROMFault"] = reflect.TypeOf((*StorageDrsCannotMoveVmWithMountedCDROMFault)(nil)).Elem()
}

type StorageDrsCannotMoveVmWithNoFilesInLayout struct {
	VimFault
}

func init() {
	t["StorageDrsCannotMoveVmWithNoFilesInLayout"] = reflect.TypeOf((*StorageDrsCannotMoveVmWithNoFilesInLayout)(nil)).Elem()
}

type StorageDrsCannotMoveVmWithNoFilesInLayoutFault StorageDrsCannotMoveVmWithNoFilesInLayout

func init() {
	t["StorageDrsCannotMoveVmWithNoFilesInLayoutFault"] = reflect.TypeOf((*StorageDrsCannotMoveVmWithNoFilesInLayoutFault)(nil)).Elem()
}

type StorageDrsConfigInfo struct {
	DynamicData

	PodConfig StorageDrsPodConfigInfo  `xml:"podConfig"`
	VmConfig  []StorageDrsVmConfigInfo `xml:"vmConfig,omitempty"`
}

func init() {
	t["StorageDrsConfigInfo"] = reflect.TypeOf((*StorageDrsConfigInfo)(nil)).Elem()
}

type StorageDrsConfigSpec struct {
	DynamicData

	PodConfigSpec *StorageDrsPodConfigSpec `xml:"podConfigSpec,omitempty"`
	VmConfigSpec  []StorageDrsVmConfigSpec `xml:"vmConfigSpec,omitempty"`
}

func init() {
	t["StorageDrsConfigSpec"] = reflect.TypeOf((*StorageDrsConfigSpec)(nil)).Elem()
}

type StorageDrsDatacentersCannotShareDatastore struct {
	VimFault
}

func init() {
	t["StorageDrsDatacentersCannotShareDatastore"] = reflect.TypeOf((*StorageDrsDatacentersCannotShareDatastore)(nil)).Elem()
}

type StorageDrsDatacentersCannotShareDatastoreFault StorageDrsDatacentersCannotShareDatastore

func init() {
	t["StorageDrsDatacentersCannotShareDatastoreFault"] = reflect.TypeOf((*StorageDrsDatacentersCannotShareDatastoreFault)(nil)).Elem()
}

type StorageDrsDisabledOnVm struct {
	VimFault
}

func init() {
	t["StorageDrsDisabledOnVm"] = reflect.TypeOf((*StorageDrsDisabledOnVm)(nil)).Elem()
}

type StorageDrsDisabledOnVmFault StorageDrsDisabledOnVm

func init() {
	t["StorageDrsDisabledOnVmFault"] = reflect.TypeOf((*StorageDrsDisabledOnVmFault)(nil)).Elem()
}

type StorageDrsIoLoadBalanceConfig struct {
	DynamicData

	IoLatencyThreshold       int `xml:"ioLatencyThreshold,omitempty"`
	IoLoadImbalanceThreshold int `xml:"ioLoadImbalanceThreshold,omitempty"`
}

func init() {
	t["StorageDrsIoLoadBalanceConfig"] = reflect.TypeOf((*StorageDrsIoLoadBalanceConfig)(nil)).Elem()
}

type StorageDrsIolbDisabledInternally struct {
	VimFault
}

func init() {
	t["StorageDrsIolbDisabledInternally"] = reflect.TypeOf((*StorageDrsIolbDisabledInternally)(nil)).Elem()
}

type StorageDrsIolbDisabledInternallyFault StorageDrsIolbDisabledInternally

func init() {
	t["StorageDrsIolbDisabledInternallyFault"] = reflect.TypeOf((*StorageDrsIolbDisabledInternallyFault)(nil)).Elem()
}

type StorageDrsOptionSpec struct {
	ArrayUpdateSpec

	Option BaseOptionValue `xml:"option,omitempty,typeattr"`
}

func init() {
	t["StorageDrsOptionSpec"] = reflect.TypeOf((*StorageDrsOptionSpec)(nil)).Elem()
}

type StorageDrsPodConfigInfo struct {
	DynamicData

	Enabled                bool                              `xml:"enabled"`
	IoLoadBalanceEnabled   bool                              `xml:"ioLoadBalanceEnabled"`
	DefaultVmBehavior      string                            `xml:"defaultVmBehavior"`
	LoadBalanceInterval    int                               `xml:"loadBalanceInterval,omitempty"`
	DefaultIntraVmAffinity *bool                             `xml:"defaultIntraVmAffinity"`
	SpaceLoadBalanceConfig *StorageDrsSpaceLoadBalanceConfig `xml:"spaceLoadBalanceConfig,omitempty"`
	IoLoadBalanceConfig    *StorageDrsIoLoadBalanceConfig    `xml:"ioLoadBalanceConfig,omitempty"`
	Rule                   []BaseClusterRuleInfo             `xml:"rule,omitempty,typeattr"`
	Option                 []BaseOptionValue                 `xml:"option,omitempty,typeattr"`
}

func init() {
	t["StorageDrsPodConfigInfo"] = reflect.TypeOf((*StorageDrsPodConfigInfo)(nil)).Elem()
}

type StorageDrsPodConfigSpec struct {
	DynamicData

	Enabled                *bool                             `xml:"enabled"`
	IoLoadBalanceEnabled   *bool                             `xml:"ioLoadBalanceEnabled"`
	DefaultVmBehavior      string                            `xml:"defaultVmBehavior,omitempty"`
	LoadBalanceInterval    int                               `xml:"loadBalanceInterval,omitempty"`
	DefaultIntraVmAffinity *bool                             `xml:"defaultIntraVmAffinity"`
	SpaceLoadBalanceConfig *StorageDrsSpaceLoadBalanceConfig `xml:"spaceLoadBalanceConfig,omitempty"`
	IoLoadBalanceConfig    *StorageDrsIoLoadBalanceConfig    `xml:"ioLoadBalanceConfig,omitempty"`
	Rule                   []ClusterRuleSpec                 `xml:"rule,omitempty"`
	Option                 []StorageDrsOptionSpec            `xml:"option,omitempty"`
}

func init() {
	t["StorageDrsPodConfigSpec"] = reflect.TypeOf((*StorageDrsPodConfigSpec)(nil)).Elem()
}

type StorageDrsPodSelectionSpec struct {
	DynamicData

	InitialVmConfig []VmPodConfigForPlacement `xml:"initialVmConfig,omitempty"`
	StoragePod      *ManagedObjectReference   `xml:"storagePod,omitempty"`
}

func init() {
	t["StorageDrsPodSelectionSpec"] = reflect.TypeOf((*StorageDrsPodSelectionSpec)(nil)).Elem()
}

type StorageDrsSpaceLoadBalanceConfig struct {
	DynamicData

	SpaceUtilizationThreshold     int `xml:"spaceUtilizationThreshold,omitempty"`
	MinSpaceUtilizationDifference int `xml:"minSpaceUtilizationDifference,omitempty"`
}

func init() {
	t["StorageDrsSpaceLoadBalanceConfig"] = reflect.TypeOf((*StorageDrsSpaceLoadBalanceConfig)(nil)).Elem()
}

type StorageDrsUnableToMoveFiles struct {
	VimFault
}

func init() {
	t["StorageDrsUnableToMoveFiles"] = reflect.TypeOf((*StorageDrsUnableToMoveFiles)(nil)).Elem()
}

type StorageDrsUnableToMoveFilesFault StorageDrsUnableToMoveFiles

func init() {
	t["StorageDrsUnableToMoveFilesFault"] = reflect.TypeOf((*StorageDrsUnableToMoveFilesFault)(nil)).Elem()
}

type StorageDrsVmConfigInfo struct {
	DynamicData

	Vm                  *ManagedObjectReference          `xml:"vm,omitempty"`
	Enabled             *bool                            `xml:"enabled"`
	Behavior            string                           `xml:"behavior,omitempty"`
	IntraVmAffinity     *bool                            `xml:"intraVmAffinity"`
	IntraVmAntiAffinity *VirtualDiskAntiAffinityRuleSpec `xml:"intraVmAntiAffinity,omitempty"`
}

func init() {
	t["StorageDrsVmConfigInfo"] = reflect.TypeOf((*StorageDrsVmConfigInfo)(nil)).Elem()
}

type StorageDrsVmConfigSpec struct {
	ArrayUpdateSpec

	Info *StorageDrsVmConfigInfo `xml:"info,omitempty"`
}

func init() {
	t["StorageDrsVmConfigSpec"] = reflect.TypeOf((*StorageDrsVmConfigSpec)(nil)).Elem()
}

type StorageIOAllocationInfo struct {
	DynamicData

	Limit       int64       `xml:"limit,omitempty"`
	Shares      *SharesInfo `xml:"shares,omitempty"`
	Reservation int         `xml:"reservation,omitempty"`
}

func init() {
	t["StorageIOAllocationInfo"] = reflect.TypeOf((*StorageIOAllocationInfo)(nil)).Elem()
}

type StorageIOAllocationOption struct {
	DynamicData

	LimitOption  LongOption   `xml:"limitOption"`
	SharesOption SharesOption `xml:"sharesOption"`
}

func init() {
	t["StorageIOAllocationOption"] = reflect.TypeOf((*StorageIOAllocationOption)(nil)).Elem()
}

type StorageIORMConfigOption struct {
	DynamicData

	EnabledOption                BoolOption  `xml:"enabledOption"`
	CongestionThresholdOption    IntOption   `xml:"congestionThresholdOption"`
	StatsCollectionEnabledOption *BoolOption `xml:"statsCollectionEnabledOption,omitempty"`
}

func init() {
	t["StorageIORMConfigOption"] = reflect.TypeOf((*StorageIORMConfigOption)(nil)).Elem()
}

type StorageIORMConfigSpec struct {
	DynamicData

	Enabled                  *bool  `xml:"enabled"`
	CongestionThresholdMode  string `xml:"congestionThresholdMode,omitempty"`
	CongestionThreshold      int    `xml:"congestionThreshold,omitempty"`
	PercentOfPeakThroughput  int    `xml:"percentOfPeakThroughput,omitempty"`
	StatsCollectionEnabled   *bool  `xml:"statsCollectionEnabled"`
	StatsAggregationDisabled *bool  `xml:"statsAggregationDisabled"`
}

func init() {
	t["StorageIORMConfigSpec"] = reflect.TypeOf((*StorageIORMConfigSpec)(nil)).Elem()
}

type StorageIORMInfo struct {
	DynamicData

	Enabled                  bool   `xml:"enabled"`
	CongestionThresholdMode  string `xml:"congestionThresholdMode,omitempty"`
	CongestionThreshold      int    `xml:"congestionThreshold"`
	PercentOfPeakThroughput  int    `xml:"percentOfPeakThroughput,omitempty"`
	StatsCollectionEnabled   *bool  `xml:"statsCollectionEnabled"`
	StatsAggregationDisabled *bool  `xml:"statsAggregationDisabled"`
}

func init() {
	t["StorageIORMInfo"] = reflect.TypeOf((*StorageIORMInfo)(nil)).Elem()
}

type StorageMigrationAction struct {
	ClusterAction

	Vm                 ManagedObjectReference     `xml:"vm"`
	RelocateSpec       VirtualMachineRelocateSpec `xml:"relocateSpec"`
	Source             ManagedObjectReference     `xml:"source"`
	Destination        ManagedObjectReference     `xml:"destination"`
	SizeTransferred    int64                      `xml:"sizeTransferred"`
	SpaceUtilSrcBefore float32                    `xml:"spaceUtilSrcBefore,omitempty"`
	SpaceUtilDstBefore float32                    `xml:"spaceUtilDstBefore,omitempty"`
	SpaceUtilSrcAfter  float32                    `xml:"spaceUtilSrcAfter,omitempty"`
	SpaceUtilDstAfter  float32                    `xml:"spaceUtilDstAfter,omitempty"`
	IoLatencySrcBefore float32                    `xml:"ioLatencySrcBefore,omitempty"`
	IoLatencyDstBefore float32                    `xml:"ioLatencyDstBefore,omitempty"`
}

func init() {
	t["StorageMigrationAction"] = reflect.TypeOf((*StorageMigrationAction)(nil)).Elem()
}

type StoragePerformanceSummary struct {
	DynamicData

	Interval              int       `xml:"interval"`
	Percentile            []int     `xml:"percentile"`
	DatastoreReadLatency  []float64 `xml:"datastoreReadLatency"`
	DatastoreWriteLatency []float64 `xml:"datastoreWriteLatency"`
	DatastoreVmLatency    []float64 `xml:"datastoreVmLatency"`
	DatastoreReadIops     []float64 `xml:"datastoreReadIops"`
	DatastoreWriteIops    []float64 `xml:"datastoreWriteIops"`
	SiocActivityDuration  int       `xml:"siocActivityDuration"`
}

func init() {
	t["StoragePerformanceSummary"] = reflect.TypeOf((*StoragePerformanceSummary)(nil)).Elem()
}

type StoragePlacementAction struct {
	ClusterAction

	Vm              *ManagedObjectReference    `xml:"vm,omitempty"`
	RelocateSpec    VirtualMachineRelocateSpec `xml:"relocateSpec"`
	Destination     ManagedObjectReference     `xml:"destination"`
	SpaceUtilBefore float32                    `xml:"spaceUtilBefore,omitempty"`
	SpaceUtilAfter  float32                    `xml:"spaceUtilAfter,omitempty"`
	IoLatencyBefore float32                    `xml:"ioLatencyBefore,omitempty"`
}

func init() {
	t["StoragePlacementAction"] = reflect.TypeOf((*StoragePlacementAction)(nil)).Elem()
}

type StoragePlacementResult struct {
	DynamicData

	Recommendations []ClusterRecommendation `xml:"recommendations,omitempty"`
	DrsFault        *ClusterDrsFaults       `xml:"drsFault,omitempty"`
	Task            *ManagedObjectReference `xml:"task,omitempty"`
}

func init() {
	t["StoragePlacementResult"] = reflect.TypeOf((*StoragePlacementResult)(nil)).Elem()
}

type StoragePlacementSpec struct {
	DynamicData

	Type                      string                      `xml:"type"`
	Priority                  VirtualMachineMovePriority  `xml:"priority,omitempty"`
	Vm                        *ManagedObjectReference     `xml:"vm,omitempty"`
	PodSelectionSpec          StorageDrsPodSelectionSpec  `xml:"podSelectionSpec"`
	CloneSpec                 *VirtualMachineCloneSpec    `xml:"cloneSpec,omitempty"`
	CloneName                 string                      `xml:"cloneName,omitempty"`
	ConfigSpec                *VirtualMachineConfigSpec   `xml:"configSpec,omitempty"`
	RelocateSpec              *VirtualMachineRelocateSpec `xml:"relocateSpec,omitempty"`
	ResourcePool              *ManagedObjectReference     `xml:"resourcePool,omitempty"`
	Host                      *ManagedObjectReference     `xml:"host,omitempty"`
	Folder                    *ManagedObjectReference     `xml:"folder,omitempty"`
	DisallowPrerequisiteMoves *bool                       `xml:"disallowPrerequisiteMoves"`
	ResourceLeaseDurationSec  int                         `xml:"resourceLeaseDurationSec,omitempty"`
}

func init() {
	t["StoragePlacementSpec"] = reflect.TypeOf((*StoragePlacementSpec)(nil)).Elem()
}

type StoragePodSummary struct {
	DynamicData

	Name      string `xml:"name"`
	Capacity  int64  `xml:"capacity"`
	FreeSpace int64  `xml:"freeSpace"`
}

func init() {
	t["StoragePodSummary"] = reflect.TypeOf((*StoragePodSummary)(nil)).Elem()
}

type StorageProfile struct {
	ApplyProfile

	NasStorage []NasStorageProfile `xml:"nasStorage,omitempty"`
}

func init() {
	t["StorageProfile"] = reflect.TypeOf((*StorageProfile)(nil)).Elem()
}

type StorageRequirement struct {
	DynamicData

	Datastore             ManagedObjectReference `xml:"datastore"`
	FreeSpaceRequiredInKb int64                  `xml:"freeSpaceRequiredInKb"`
}

func init() {
	t["StorageRequirement"] = reflect.TypeOf((*StorageRequirement)(nil)).Elem()
}

type StorageVMotionNotSupported struct {
	MigrationFeatureNotSupported
}

func init() {
	t["StorageVMotionNotSupported"] = reflect.TypeOf((*StorageVMotionNotSupported)(nil)).Elem()
}

type StorageVMotionNotSupportedFault StorageVMotionNotSupported

func init() {
	t["StorageVMotionNotSupportedFault"] = reflect.TypeOf((*StorageVMotionNotSupportedFault)(nil)).Elem()
}

type StorageVmotionIncompatible struct {
	VirtualHardwareCompatibilityIssue

	Datastore *ManagedObjectReference `xml:"datastore,omitempty"`
}

func init() {
	t["StorageVmotionIncompatible"] = reflect.TypeOf((*StorageVmotionIncompatible)(nil)).Elem()
}

type StorageVmotionIncompatibleFault StorageVmotionIncompatible

func init() {
	t["StorageVmotionIncompatibleFault"] = reflect.TypeOf((*StorageVmotionIncompatibleFault)(nil)).Elem()
}

type StringExpression struct {
	NegatableExpression

	Value string `xml:"value,omitempty"`
}

func init() {
	t["StringExpression"] = reflect.TypeOf((*StringExpression)(nil)).Elem()
}

type StringOption struct {
	OptionType

	DefaultValue    string `xml:"defaultValue"`
	ValidCharacters string `xml:"validCharacters,omitempty"`
}

func init() {
	t["StringOption"] = reflect.TypeOf((*StringOption)(nil)).Elem()
}

type StringPolicy struct {
	InheritablePolicy

	Value string `xml:"value,omitempty"`
}

func init() {
	t["StringPolicy"] = reflect.TypeOf((*StringPolicy)(nil)).Elem()
}

type SuspendVAppRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["SuspendVAppRequestType"] = reflect.TypeOf((*SuspendVAppRequestType)(nil)).Elem()
}

type SuspendVApp_Task SuspendVAppRequestType

func init() {
	t["SuspendVApp_Task"] = reflect.TypeOf((*SuspendVApp_Task)(nil)).Elem()
}

type SuspendVApp_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type SuspendVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["SuspendVMRequestType"] = reflect.TypeOf((*SuspendVMRequestType)(nil)).Elem()
}

type SuspendVM_Task SuspendVMRequestType

func init() {
	t["SuspendVM_Task"] = reflect.TypeOf((*SuspendVM_Task)(nil)).Elem()
}

type SuspendVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type SuspendedRelocateNotSupported struct {
	MigrationFault
}

func init() {
	t["SuspendedRelocateNotSupported"] = reflect.TypeOf((*SuspendedRelocateNotSupported)(nil)).Elem()
}

type SuspendedRelocateNotSupportedFault SuspendedRelocateNotSupported

func init() {
	t["SuspendedRelocateNotSupportedFault"] = reflect.TypeOf((*SuspendedRelocateNotSupportedFault)(nil)).Elem()
}

type SwapDatastoreNotWritableOnHost struct {
	DatastoreNotWritableOnHost
}

func init() {
	t["SwapDatastoreNotWritableOnHost"] = reflect.TypeOf((*SwapDatastoreNotWritableOnHost)(nil)).Elem()
}

type SwapDatastoreNotWritableOnHostFault SwapDatastoreNotWritableOnHost

func init() {
	t["SwapDatastoreNotWritableOnHostFault"] = reflect.TypeOf((*SwapDatastoreNotWritableOnHostFault)(nil)).Elem()
}

type SwapDatastoreUnset struct {
	VimFault
}

func init() {
	t["SwapDatastoreUnset"] = reflect.TypeOf((*SwapDatastoreUnset)(nil)).Elem()
}

type SwapDatastoreUnsetFault SwapDatastoreUnset

func init() {
	t["SwapDatastoreUnsetFault"] = reflect.TypeOf((*SwapDatastoreUnsetFault)(nil)).Elem()
}

type SwapPlacementOverrideNotSupported struct {
	InvalidVmConfig
}

func init() {
	t["SwapPlacementOverrideNotSupported"] = reflect.TypeOf((*SwapPlacementOverrideNotSupported)(nil)).Elem()
}

type SwapPlacementOverrideNotSupportedFault SwapPlacementOverrideNotSupported

func init() {
	t["SwapPlacementOverrideNotSupportedFault"] = reflect.TypeOf((*SwapPlacementOverrideNotSupportedFault)(nil)).Elem()
}

type SwitchIpUnset struct {
	DvsFault
}

func init() {
	t["SwitchIpUnset"] = reflect.TypeOf((*SwitchIpUnset)(nil)).Elem()
}

type SwitchIpUnsetFault SwitchIpUnset

func init() {
	t["SwitchIpUnsetFault"] = reflect.TypeOf((*SwitchIpUnsetFault)(nil)).Elem()
}

type SwitchNotInUpgradeMode struct {
	DvsFault
}

func init() {
	t["SwitchNotInUpgradeMode"] = reflect.TypeOf((*SwitchNotInUpgradeMode)(nil)).Elem()
}

type SwitchNotInUpgradeModeFault SwitchNotInUpgradeMode

func init() {
	t["SwitchNotInUpgradeModeFault"] = reflect.TypeOf((*SwitchNotInUpgradeModeFault)(nil)).Elem()
}

type SystemError struct {
	RuntimeFault

	Reason string `xml:"reason"`
}

func init() {
	t["SystemError"] = reflect.TypeOf((*SystemError)(nil)).Elem()
}

type SystemErrorFault SystemError

func init() {
	t["SystemErrorFault"] = reflect.TypeOf((*SystemErrorFault)(nil)).Elem()
}

type Tag struct {
	DynamicData

	Key string `xml:"key"`
}

func init() {
	t["Tag"] = reflect.TypeOf((*Tag)(nil)).Elem()
}

type TaskDescription struct {
	DynamicData

	MethodInfo []BaseElementDescription `xml:"methodInfo,typeattr"`
	State      []BaseElementDescription `xml:"state,typeattr"`
	Reason     []BaseTypeDescription    `xml:"reason,typeattr"`
}

func init() {
	t["TaskDescription"] = reflect.TypeOf((*TaskDescription)(nil)).Elem()
}

type TaskEvent struct {
	Event

	Info TaskInfo `xml:"info"`
}

func init() {
	t["TaskEvent"] = reflect.TypeOf((*TaskEvent)(nil)).Elem()
}

type TaskFilterSpec struct {
	DynamicData

	Entity        *TaskFilterSpecByEntity   `xml:"entity,omitempty"`
	Time          *TaskFilterSpecByTime     `xml:"time,omitempty"`
	UserName      *TaskFilterSpecByUsername `xml:"userName,omitempty"`
	State         []TaskInfoState           `xml:"state,omitempty"`
	Alarm         *ManagedObjectReference   `xml:"alarm,omitempty"`
	ScheduledTask *ManagedObjectReference   `xml:"scheduledTask,omitempty"`
	EventChainId  []int                     `xml:"eventChainId,omitempty"`
	Tag           []string                  `xml:"tag,omitempty"`
	ParentTaskKey []string                  `xml:"parentTaskKey,omitempty"`
	RootTaskKey   []string                  `xml:"rootTaskKey,omitempty"`
}

func init() {
	t["TaskFilterSpec"] = reflect.TypeOf((*TaskFilterSpec)(nil)).Elem()
}

type TaskFilterSpecByEntity struct {
	DynamicData

	Entity    ManagedObjectReference        `xml:"entity"`
	Recursion TaskFilterSpecRecursionOption `xml:"recursion"`
}

func init() {
	t["TaskFilterSpecByEntity"] = reflect.TypeOf((*TaskFilterSpecByEntity)(nil)).Elem()
}

type TaskFilterSpecByTime struct {
	DynamicData

	TimeType  TaskFilterSpecTimeOption `xml:"timeType"`
	BeginTime *time.Time               `xml:"beginTime"`
	EndTime   *time.Time               `xml:"endTime"`
}

func init() {
	t["TaskFilterSpecByTime"] = reflect.TypeOf((*TaskFilterSpecByTime)(nil)).Elem()
}

type TaskFilterSpecByUsername struct {
	DynamicData

	SystemUser bool     `xml:"systemUser"`
	UserList   []string `xml:"userList,omitempty"`
}

func init() {
	t["TaskFilterSpecByUsername"] = reflect.TypeOf((*TaskFilterSpecByUsername)(nil)).Elem()
}

type TaskInProgress struct {
	VimFault

	Task ManagedObjectReference `xml:"task"`
}

func init() {
	t["TaskInProgress"] = reflect.TypeOf((*TaskInProgress)(nil)).Elem()
}

type TaskInProgressFault BaseTaskInProgress

func init() {
	t["TaskInProgressFault"] = reflect.TypeOf((*TaskInProgressFault)(nil)).Elem()
}

type TaskInfo struct {
	DynamicData

	Key           string                   `xml:"key"`
	Task          ManagedObjectReference   `xml:"task"`
	Description   *LocalizableMessage      `xml:"description,omitempty"`
	Name          string                   `xml:"name,omitempty"`
	DescriptionId string                   `xml:"descriptionId"`
	Entity        *ManagedObjectReference  `xml:"entity,omitempty"`
	EntityName    string                   `xml:"entityName,omitempty"`
	Locked        []ManagedObjectReference `xml:"locked,omitempty"`
	State         TaskInfoState            `xml:"state"`
	Cancelled     bool                     `xml:"cancelled"`
	Cancelable    bool                     `xml:"cancelable"`
	Error         *LocalizedMethodFault    `xml:"error,omitempty"`
	Result        AnyType                  `xml:"result,omitempty,typeattr"`
	Progress      int                      `xml:"progress,omitempty"`
	Reason        BaseTaskReason           `xml:"reason,typeattr"`
	QueueTime     time.Time                `xml:"queueTime"`
	StartTime     *time.Time               `xml:"startTime"`
	CompleteTime  *time.Time               `xml:"completeTime"`
	EventChainId  int                      `xml:"eventChainId"`
	ChangeTag     string                   `xml:"changeTag,omitempty"`
	ParentTaskKey string                   `xml:"parentTaskKey,omitempty"`
	RootTaskKey   string                   `xml:"rootTaskKey,omitempty"`
}

func init() {
	t["TaskInfo"] = reflect.TypeOf((*TaskInfo)(nil)).Elem()
}

type TaskReason struct {
	DynamicData
}

func init() {
	t["TaskReason"] = reflect.TypeOf((*TaskReason)(nil)).Elem()
}

type TaskReasonAlarm struct {
	TaskReason

	AlarmName  string                 `xml:"alarmName"`
	Alarm      ManagedObjectReference `xml:"alarm"`
	EntityName string                 `xml:"entityName"`
	Entity     ManagedObjectReference `xml:"entity"`
}

func init() {
	t["TaskReasonAlarm"] = reflect.TypeOf((*TaskReasonAlarm)(nil)).Elem()
}

type TaskReasonSchedule struct {
	TaskReason

	Name          string                 `xml:"name"`
	ScheduledTask ManagedObjectReference `xml:"scheduledTask"`
}

func init() {
	t["TaskReasonSchedule"] = reflect.TypeOf((*TaskReasonSchedule)(nil)).Elem()
}

type TaskReasonSystem struct {
	TaskReason
}

func init() {
	t["TaskReasonSystem"] = reflect.TypeOf((*TaskReasonSystem)(nil)).Elem()
}

type TaskReasonUser struct {
	TaskReason

	UserName string `xml:"userName"`
}

func init() {
	t["TaskReasonUser"] = reflect.TypeOf((*TaskReasonUser)(nil)).Elem()
}

type TaskScheduler struct {
	DynamicData

	ActiveTime *time.Time `xml:"activeTime"`
	ExpireTime *time.Time `xml:"expireTime"`
}

func init() {
	t["TaskScheduler"] = reflect.TypeOf((*TaskScheduler)(nil)).Elem()
}

type TaskTimeoutEvent struct {
	TaskEvent
}

func init() {
	t["TaskTimeoutEvent"] = reflect.TypeOf((*TaskTimeoutEvent)(nil)).Elem()
}

type TeamingMatchEvent struct {
	DvsHealthStatusChangeEvent
}

func init() {
	t["TeamingMatchEvent"] = reflect.TypeOf((*TeamingMatchEvent)(nil)).Elem()
}

type TeamingMisMatchEvent struct {
	DvsHealthStatusChangeEvent
}

func init() {
	t["TeamingMisMatchEvent"] = reflect.TypeOf((*TeamingMisMatchEvent)(nil)).Elem()
}

type TemplateBeingUpgradedEvent struct {
	TemplateUpgradeEvent
}

func init() {
	t["TemplateBeingUpgradedEvent"] = reflect.TypeOf((*TemplateBeingUpgradedEvent)(nil)).Elem()
}

type TemplateConfigFileInfo struct {
	VmConfigFileInfo
}

func init() {
	t["TemplateConfigFileInfo"] = reflect.TypeOf((*TemplateConfigFileInfo)(nil)).Elem()
}

type TemplateConfigFileQuery struct {
	VmConfigFileQuery
}

func init() {
	t["TemplateConfigFileQuery"] = reflect.TypeOf((*TemplateConfigFileQuery)(nil)).Elem()
}

type TemplateUpgradeEvent struct {
	Event

	LegacyTemplate string `xml:"legacyTemplate"`
}

func 